/* Generated from posixwin.scm by the CHICKEN compiler
   http://www.call-cc.org
   2014-06-07 15:23
   Version 4.9.0.1 (stability/4.9.0) (rev 8b3189b)
   linux-unix-gnu-x86-64 [ 64bit manyargs ptables ]
   compiled 2014-06-07 on yves (Linux)
   command line: posixwin.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -types ./types.db -explicit-use -no-trace -output-file posixwin.c
   unit: posix
*/

#include "chicken.h"

#ifndef WIN32_LEAN_AND_MEAN
# define WIN32_LEAN_AND_MEAN
#endif

#include <direct.h>
#include <errno.h>
#include <fcntl.h>
#include <io.h>
#include <process.h>
#include <signal.h>
#include <utime.h>
#include <winsock2.h>

#define ARG_MAX		256
#define PIPE_BUF	512
#ifndef ENV_MAX
# define ENV_MAX	1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;

/* pipe handles */
static C_TLS HANDLE C_rd0, C_wr0, C_wr0_, C_rd1, C_wr1, C_rd1_;
static C_TLS HANDLE C_save0, C_save1; /* saved I/O handles */
static C_TLS char C_rdbuf; /* one-char buffer for read */
static C_TLS int C_exstatus;

/* platform information; initialized for cached testing */
static C_TLS char C_hostname[256] = "";
static C_TLS char C_osver[16] = "";
static C_TLS char C_osrel[16] = "";
static C_TLS char C_processor[16] = "";
static C_TLS char C_shlcmd[256] = "";

/* Windows NT or better */
static int C_isNT = 0;

/* Current user name */
static C_TLS TCHAR C_username[255 + 1] = "";

/* Directory Operations */

#define C_mkdir(str)	    C_fix(mkdir(C_c_string(str)))
#define C_chdir(str)	    C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)	    C_fix(rmdir(C_c_string(str)))

#ifndef __WATCOMC__
/* DIRENT stuff */
struct dirent
{
    char *		d_name;
};

typedef struct
{
    struct _finddata_t	fdata;
    int			handle;
    struct dirent	current;
} DIR;

static DIR * C_fcall
opendir(const char *name)
{
    int name_len = strlen(name);
    int what_len = name_len + 3;
    DIR *dir = (DIR *)malloc(sizeof(DIR));
    char *what;
    if (!dir)
    {
	errno = ENOMEM;
	return NULL;
    }
    what = (char *)malloc(what_len);
    if (!what)
    {
	free(dir);
	errno = ENOMEM;
	return NULL;
    }
    C_strlcpy(what, name, what_len);
    if (strchr("\\/", name[name_len - 1]))
	C_strlcat(what, "*", what_len);
    else
	C_strlcat(what, "\\*", what_len);

    dir->handle = _findfirst(what, &dir->fdata);
    if (dir->handle == -1)
    {
	free(what);
	free(dir);
	return NULL;
    }
    dir->current.d_name = NULL; /* as the first-time indicator */
    free(what);
    return dir;
}

static int C_fcall
closedir(DIR * dir)
{
    if (dir)
    {
	int res = _findclose(dir->handle);
	free(dir);
	return res;
    }
    return -1;
}

static struct dirent * C_fcall
readdir(DIR * dir)
{
    if (dir)
    {
	if (!dir->current.d_name /* first time after opendir */
	     || _findnext(dir->handle, &dir->fdata) != -1)
	{
	    dir->current.d_name = dir->fdata.name;
	    return &dir->current;
	}
    }
    return NULL;
}
#endif /* ifndef __WATCOMC__ */

#ifdef __WATCOMC__
# define mktemp _mktemp
/* there is no P_DETACH in Watcom CRTL */
# define P_DETACH P_NOWAIT
#endif

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, _popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, _popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)			     C_fix(_pclose(C_port_file(p)))

#define C_chmod(fn, m)	    C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_test_access(fn, m)	    C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_pipe(d, m)	    C_fix(_pipe(C_pipefds, PIPE_BUF, C_unfix(m)))
#define C_close(fd)	    C_fix(close(C_unfix(fd)))

#define C_getenventry(i)   environ[ i ]

#define C_lstat(fn)	    C_stat(fn)

static void C_fcall
C_set_arg_string(char **where, int i, char *dat, int len)
{
    char *ptr;
    if (dat)
    {
	ptr = (char *)C_malloc(len + 1);
	C_memcpy(ptr, dat, len);
	ptr[ len ] = '\0';
        /* Can't barf() here, so the NUL byte check happens in Scheme */
    }
    else
	ptr = NULL;
    where[ i ] = ptr;
}

static void C_fcall
C_free_arg_string(char **where) {
  while (*where) C_free(*(where++));
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)

#define C_free_exec_args()		(C_free_arg_string(C_exec_args), C_SCHEME_TRUE)
#define C_free_exec_env()		(C_free_arg_string(C_exec_env), C_SCHEME_TRUE)

#define C_execvp(f)	    C_fix(execvp(C_data_pointer(f), (const char *const *)C_exec_args))
#define C_execve(f)	    C_fix(execve(C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

/* MS replacement for the fork-exec pair */
#define C_spawnvp(m, f)	    C_fix(spawnvp(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args))
#define C_spawnvpe(m, f)    C_fix(spawnvpe(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)	    C_fix(mktemp(C_c_string(t)))

/* It is assumed that 'int' is-a 'long' */
#define C_ftell(p)          C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_num_to_int(n), C_unfix(w)))
#define C_lseek(fd, o, w)   C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_flushall()	    C_fix(_flushall())

#define C_umask(m)          C_fix(_umask(C_unfix(m)))

#define C_ctime(n)	    (C_secs = (n), ctime(&C_secs))

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

/*
  mapping from Win32 error codes to errno
*/

typedef struct
{
    DWORD   win32;
    int	    libc;
} errmap_t;

static errmap_t errmap[] =
{
    {ERROR_INVALID_FUNCTION,	  EINVAL},
    {ERROR_FILE_NOT_FOUND,	  ENOENT},
    {ERROR_PATH_NOT_FOUND,	  ENOENT},
    {ERROR_TOO_MANY_OPEN_FILES,	  EMFILE},
    {ERROR_ACCESS_DENIED,	  EACCES},
    {ERROR_INVALID_HANDLE,	  EBADF},
    {ERROR_ARENA_TRASHED,	  ENOMEM},
    {ERROR_NOT_ENOUGH_MEMORY,	  ENOMEM},
    {ERROR_INVALID_BLOCK,	  ENOMEM},
    {ERROR_BAD_ENVIRONMENT,	  E2BIG},
    {ERROR_BAD_FORMAT,		  ENOEXEC},
    {ERROR_INVALID_ACCESS,	  EINVAL},
    {ERROR_INVALID_DATA,	  EINVAL},
    {ERROR_INVALID_DRIVE,	  ENOENT},
    {ERROR_CURRENT_DIRECTORY,	  EACCES},
    {ERROR_NOT_SAME_DEVICE,	  EXDEV},
    {ERROR_NO_MORE_FILES,	  ENOENT},
    {ERROR_LOCK_VIOLATION,	  EACCES},
    {ERROR_BAD_NETPATH,		  ENOENT},
    {ERROR_NETWORK_ACCESS_DENIED, EACCES},
    {ERROR_BAD_NET_NAME,	  ENOENT},
    {ERROR_FILE_EXISTS,		  EEXIST},
    {ERROR_CANNOT_MAKE,		  EACCES},
    {ERROR_FAIL_I24,		  EACCES},
    {ERROR_INVALID_PARAMETER,	  EINVAL},
    {ERROR_NO_PROC_SLOTS,	  EAGAIN},
    {ERROR_DRIVE_LOCKED,	  EACCES},
    {ERROR_BROKEN_PIPE,		  EPIPE},
    {ERROR_DISK_FULL,		  ENOSPC},
    {ERROR_INVALID_TARGET_HANDLE, EBADF},
    {ERROR_INVALID_HANDLE,	  EINVAL},
    {ERROR_WAIT_NO_CHILDREN,	  ECHILD},
    {ERROR_CHILD_NOT_COMPLETE,	  ECHILD},
    {ERROR_DIRECT_ACCESS_HANDLE,  EBADF},
    {ERROR_NEGATIVE_SEEK,	  EINVAL},
    {ERROR_SEEK_ON_DEVICE,	  EACCES},
    {ERROR_DIR_NOT_EMPTY,	  ENOTEMPTY},
    {ERROR_NOT_LOCKED,		  EACCES},
    {ERROR_BAD_PATHNAME,	  ENOENT},
    {ERROR_MAX_THRDS_REACHED,	  EAGAIN},
    {ERROR_LOCK_FAILED,		  EACCES},
    {ERROR_ALREADY_EXISTS,	  EEXIST},
    {ERROR_FILENAME_EXCED_RANGE,  ENOENT},
    {ERROR_NESTING_NOT_ALLOWED,	  EAGAIN},
    {ERROR_NOT_ENOUGH_QUOTA,	  ENOMEM},
    {0, 0}
};

static void C_fcall
set_errno(DWORD w32err)
{
    errmap_t *map;
    for (map = errmap; map->win32; ++map)
    {
	if (map->win32 == w32err)
	{
	    errno = map->libc;
	    return;
	}
    }
    errno = ENOSYS; /* For lack of anything better */
}

static int C_fcall
set_last_errno()
{
    set_errno(GetLastError());
    return 0;
}

static int C_fcall
process_wait(C_word h, C_word t)
{
    if (WaitForSingleObject((HANDLE)h, (t ? 0 : INFINITE)) == WAIT_OBJECT_0)
    {
	DWORD ret;
	if (GetExitCodeProcess((HANDLE)h, &ret))
	{
	    CloseHandle((HANDLE)h);
	    C_exstatus = ret;
	    return 1;
	}
    }
    return set_last_errno();
}

#define C_process_wait(p, t) (process_wait(C_unfix(p), C_truep(t)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sleep(t) (Sleep(C_unfix(t) * 1000), C_fix(0))

static int C_fcall
get_hostname()
{
    /* Do we already have hostname? */
    if (strlen(C_hostname))
    {
	return 1;
    }
    else
    {
	WSADATA wsa;
	if (WSAStartup(MAKEWORD(1, 1), &wsa) == 0)
	{
	    int nok = gethostname(C_hostname, sizeof(C_hostname));
	    WSACleanup();
	    return !nok;
	}
	return 0;
    }
}

static int C_fcall
sysinfo()
{
    /* Do we need to build the sysinfo? */
    if (!strlen(C_osrel))
    {
	OSVERSIONINFO ovf;
	ZeroMemory(&ovf, sizeof(ovf));
	ovf.dwOSVersionInfoSize = sizeof(ovf);
	if (get_hostname() && GetVersionEx(&ovf))
	{
	    SYSTEM_INFO si;
	    _snprintf(C_osver, sizeof(C_osver) - 1, "%d.%d.%d",
			ovf.dwMajorVersion, ovf.dwMinorVersion, ovf.dwBuildNumber);
	    strncpy(C_osrel, "Win", sizeof(C_osrel) - 1);
	    switch (ovf.dwPlatformId)
	    {
	    case VER_PLATFORM_WIN32s:
		strncpy(C_osrel, "Win32s", sizeof(C_osrel) - 1);
		break;
	    case VER_PLATFORM_WIN32_WINDOWS:
		if (ovf.dwMajorVersion == 4)
		{
		    if (ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win95", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 10)
			strncpy(C_osrel, "Win98", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 90)
			strncpy(C_osrel, "WinMe", sizeof(C_osrel) - 1);
		}
		break;
	    case VER_PLATFORM_WIN32_NT:
		C_isNT = 1;
		if (ovf.dwMajorVersion == 6)
		    strncpy(C_osrel, "WinVista", sizeof(C_osrel) - 1);
		else if (ovf.dwMajorVersion == 5)
		{
		    if (ovf.dwMinorVersion == 2)
			strncpy(C_osrel, "WinServer2003", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 1)
			strncpy(C_osrel, "WinXP", sizeof(C_osrel) - 1);
		    else if ( ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win2000", sizeof(C_osrel) - 1);
		}
		else if (ovf.dwMajorVersion <= 4)
		   strncpy(C_osrel, "WinNT", sizeof(C_osrel) - 1);
		break;
	    }
	    GetSystemInfo(&si);
	    strncpy(C_processor, "Unknown", sizeof(C_processor) - 1);
	    switch (si.wProcessorArchitecture)
	    {
	    case PROCESSOR_ARCHITECTURE_INTEL:
		strncpy(C_processor, "x86", sizeof(C_processor) - 1);
		break;
#	    ifdef PROCESSOR_ARCHITECTURE_IA64
	    case PROCESSOR_ARCHITECTURE_IA64:
		strncpy(C_processor, "IA64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_AMD64
	    case PROCESSOR_ARCHITECTURE_AMD64:
		strncpy(C_processor, "x64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_IA32_ON_WIN64
	    case PROCESSOR_ARCHITECTURE_IA32_ON_WIN64:
		strncpy(C_processor, "WOW64", sizeof(C_processor) - 1);
		break;
#	    endif
	    }
	}
	else
	    return set_last_errno();
    }
    return 1;
}

static int C_fcall
get_shlcmd()
{
    /* Do we need to build the shell command pathname? */
    if (!strlen(C_shlcmd))
    {
	if (sysinfo()) /* for C_isNT */
	{
	    char *cmdnam = C_isNT ? "\\cmd.exe" : "\\command.com";
	    UINT len = GetSystemDirectory(C_shlcmd, sizeof(C_shlcmd) - strlen(cmdnam));
	    if (len)
		C_strlcpy(C_shlcmd + len, cmdnam, sizeof(C_shlcmd));
	    else
		return set_last_errno();
	}
	else
	    return 0;
    }
    return 1;
}

#define C_get_hostname() (get_hostname() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sysinfo() (sysinfo() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_get_shlcmd() (get_shlcmd() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* GetUserName */

static int C_fcall
get_user_name()
{
    if (!strlen(C_username))
    {
	DWORD bufCharCount = sizeof(C_username) / sizeof(C_username[0]);
	if (!GetUserName(C_username, &bufCharCount))
	    return set_last_errno();
    }
    return 1;
}

#define C_get_user_name() (get_user_name() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/*
    Spawn a process directly.
    Params:
    app		Command to execute.
    cmdlin	Command line (arguments).
    env		Environment for the new process (may be NULL).
    handle, stdin, stdout, stderr
		Spawned process info are returned in integers.
		When spawned process shares standard io stream with the parent
		process the respective value in handle, stdin, stdout, stderr
		is -1.
    params	A bitmask controling operation.
		Bit 1: Child & parent share standard input if this bit is set.
		Bit 2: Share standard output if bit is set.
		Bit 3: Share standard error if bit is set.

    Returns: zero return value indicates failure.
*/
static int C_fcall
C_process(const char * app, const char * cmdlin, const char ** env,
	  C_word * phandle,
	  int * pstdin_fd, int * pstdout_fd, int * pstderr_fd,
	  int params)
{
    int i;
    int success = TRUE;
    const int f_share_io[3] = { params & 1, params & 2, params & 4};
    int io_fds[3] = { -1, -1, -1 };
    HANDLE
	child_io_handles[3] = { NULL, NULL, NULL },
	standard_io_handles[3] = {
	    GetStdHandle(STD_INPUT_HANDLE),
	    GetStdHandle(STD_OUTPUT_HANDLE),
	    GetStdHandle(STD_ERROR_HANDLE)};
    const char modes[3] = "rww";
    HANDLE cur_process = GetCurrentProcess(), child_process = NULL;
    void* envblk = NULL;

    /****** create io handles & fds ***/

    for (i=0; i<3 && success; ++i)
    {
	if (f_share_io[i])
	{
	    success = DuplicateHandle(
		cur_process, standard_io_handles[i],
		cur_process, &child_io_handles[i],
		0, FALSE, DUPLICATE_SAME_ACCESS);
	}
	else
	{
	    HANDLE a, b;
	    success = CreatePipe(&a,&b,NULL,0);
	    if(success)
	    {
		HANDLE parent_end;
		if (modes[i]=='r') { child_io_handles[i]=a; parent_end=b; }
		else		   { parent_end=a; child_io_handles[i]=b; }
		success = (io_fds[i] = _open_osfhandle((C_word)parent_end,0)) >= 0;
                /* Make new handle inheritable */
		if (success)
		  success = SetHandleInformation(child_io_handles[i], HANDLE_FLAG_INHERIT, -1);
	    }
	}
    }

#if 0 /* Requires a sorted list by key! */
    /****** create environment block if necessary ****/

    if (env && success)
    {
	char** p;
	int len = 0;

	for (p = env; *p; ++p) len += strlen(*p) + 1;

	if (envblk = C_malloc(len + 1))
	{
	    char* pb = (char*)envblk;
	    for (p = env; *p; ++p)
	    {
		C_strlcpy(pb, *p, len+1);
		pb += strlen(*p) + 1;
	    }
	    *pb = '\0';
            /* This _should_ already have been checked for embedded NUL bytes */
	}
	else
	    success = FALSE;
    }
#endif

    /****** finally spawn process ****/

    if (success)
    {
	PROCESS_INFORMATION pi;
	STARTUPINFO si;

	ZeroMemory(&pi,sizeof pi);
	ZeroMemory(&si,sizeof si);
	si.cb = sizeof si;
	si.dwFlags = STARTF_USESTDHANDLES;
	si.hStdInput = child_io_handles[0];
	si.hStdOutput = child_io_handles[1];
	si.hStdError = child_io_handles[2];

	/* FIXME passing 'app' param causes failure & possible stack corruption */
	success = CreateProcess(
	    NULL, (char*)cmdlin, NULL, NULL, TRUE, 0, envblk, NULL, &si, &pi);

	if (success)
	{
	    child_process=pi.hProcess;
	    CloseHandle(pi.hThread);
	}
	else
	    set_last_errno();
    }
    else
	set_last_errno();

    /****** cleanup & return *********/

    /* parent must close child end */
    for (i=0; i<3; ++i) {
	if (child_io_handles[i] != NULL)
	    CloseHandle(child_io_handles[i]);
    }

    if (success)
    {
	*phandle = (C_word)child_process;
	*pstdin_fd = io_fds[0];
	*pstdout_fd = io_fds[1];
	*pstderr_fd = io_fds[2];
    }
    else
    {
	for (i=0; i<3; ++i) {
	    if (io_fds[i] != -1)
		_close(io_fds[i]);
	}
    }

    return success;
}

static int set_file_mtime(char *filename, C_word tm)
{
  struct _utimbuf tb;

  tb.actime = tb.modtime = C_num_to_int(tm);
  return _utime(filename, &tb);
}

#include <signal.h>
#include <errno.h>

#include <sys/stat.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#define C_curdir(buf)       (getcwd(C_c_string(buf), 1024) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

static C_TLS struct stat C_statbuf;

#define C_stat_type         (C_statbuf.st_mode & S_IFMT)
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#ifndef S_IFSOCK
# define S_IFSOCK           0140000
#endif

#define cpy_tmvec_to_tmstc08(ptm, v) \
    ((ptm)->tm_sec = C_unfix(C_block_item((v), 0)), \
    (ptm)->tm_min = C_unfix(C_block_item((v), 1)), \
    (ptm)->tm_hour = C_unfix(C_block_item((v), 2)), \
    (ptm)->tm_mday = C_unfix(C_block_item((v), 3)), \
    (ptm)->tm_mon = C_unfix(C_block_item((v), 4)), \
    (ptm)->tm_year = C_unfix(C_block_item((v), 5)), \
    (ptm)->tm_wday = C_unfix(C_block_item((v), 6)), \
    (ptm)->tm_yday = C_unfix(C_block_item((v), 7)), \
    (ptm)->tm_isdst = (C_block_item((v), 8) != C_SCHEME_FALSE))

#define cpy_tmvec_to_tmstc9(ptm, v) \
    (((struct tm *)ptm)->tm_gmtoff = -C_unfix(C_block_item((v), 9)))

#define C_tm_set_08(v, tm)  cpy_tmvec_to_tmstc08( (tm), (v) )
#define C_tm_set_9(v, tm)   cpy_tmvec_to_tmstc9( (tm), (v) )

static struct tm *
C_tm_set( C_word v, void *tm )
{
  C_tm_set_08( v, (struct tm *)tm );
#if defined(C_GNU_ENV) && !defined(__CYGWIN__) && !defined(__uClinux__)
  C_tm_set_9( v, (struct tm *)tm );
#endif
  return tm;
}

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f, tm) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set((v), (tm))) ? C_time_string : NULL)
#define C_a_mktime(ptr, c, v, tm)  C_flonum(ptr, mktime(C_tm_set((v), C_data_pointer(tm))))
#define C_asctime(v, tm)    (asctime(C_tm_set((v), (tm))))

#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_opendir(x,h)      C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)       (closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)      C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b,l)    (C_strlcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name, l), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#ifdef HAVE_SETENV
# define C_unsetenv(s)      (unsetenv((char *)C_data_pointer(s)), C_SCHEME_TRUE)
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
# if defined(_WIN32) && !defined(__CYGWIN__)
#  define C_unsetenv(s)      C_setenv(s, C_SCHEME_FALSE)
# else
#  define C_unsetenv(s)      C_fix(putenv((char *)C_data_pointer(s)))
# endif
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_c_string(x),
       *sy = (y == C_SCHEME_FALSE ? "" : C_c_string(y));
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  int buf_len = n1 + n2 + 2;
  char *buf = (char *)C_malloc(buf_len);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strlcpy(buf, sx, buf_len);
    C_strlcat(buf, "=", buf_len);
    C_strlcat(buf, sy, buf_len);
    return(C_fix(putenv(buf)));
  }
}
#endif

#ifndef S_IFLNK
#define S_IFLNK S_IFREG
#endif

#ifndef S_IFREG
#define S_IFREG S_IFREG
#endif

#ifndef S_IFDIR
#define S_IFDIR S_IFREG
#endif

#ifndef S_IFCHR
#define S_IFCHR S_IFREG
#endif

#ifndef S_IFBLK
#define S_IFBLK S_IFREG
#endif

#ifndef S_IFSOCK
#define S_IFSOCK S_IFREG
#endif

#ifndef S_IFIFO
#define S_IFIFO S_IFREG
#endif


#define PROT_NONE       0
#define PROT_READ       1
#define PROT_WRITE      2
#define PROT_EXEC       4
#define MAP_FILE        0
#define MAP_SHARED      1
#define MAP_PRIVATE     2
#define MAP_FIXED       0x10
#define MAP_ANONYMOUS   0x20

// This value is available starting with Windows XP with SP2 
// and Windows Server 2003 with SP1.
#ifndef FILE_MAP_EXECUTE
#define FILE_MAP_EXECUTE 0x20
#endif//FILE_MAP_EXECUTE

static int page_flags[] =
{
    0,
    PAGE_READONLY,
    PAGE_READWRITE,
    PAGE_READWRITE,
    PAGE_EXECUTE_READ,
    PAGE_EXECUTE_READ,
    PAGE_EXECUTE_READWRITE
};

static int file_flags[] =
{
    0,
    FILE_MAP_READ,
    FILE_MAP_READ|FILE_MAP_WRITE,
    FILE_MAP_READ|FILE_MAP_WRITE,
    FILE_MAP_READ|FILE_MAP_EXECUTE,
    FILE_MAP_READ|FILE_MAP_EXECUTE,
    FILE_MAP_READ|FILE_MAP_WRITE|FILE_MAP_EXECUTE
};

void* mmap(void* addr,int len,int prot,int flags,int fd,int off)
{
    HANDLE hMap;
    HANDLE hFile;

    void* ptr;

    if ((flags & MAP_FIXED) || (flags & MAP_PRIVATE) || (flags & MAP_ANONYMOUS))
    {
        errno = EINVAL;
        return (void*)-1;
    }

    /*
     * We must cast because _get_osfhandle returns intptr_t, but it must
     * be compared with INVALID_HANDLE_VALUE, which is a HANDLE type.
     * Who comes up with this shit?
     */
    hFile = (HANDLE)_get_osfhandle(fd);
    if (hFile == INVALID_HANDLE_VALUE)
    {
        return (void*)-1;
    }

    hMap = CreateFileMapping(
            hFile,
            NULL,
            page_flags[prot & (PROT_READ|PROT_WRITE|PROT_EXEC)],
            0,
            0,
            NULL);

    if (hMap == INVALID_HANDLE_VALUE)
    {
        set_last_errno();
        return (void*)-1;
    }

    ptr = MapViewOfFile(
            hMap,
            file_flags[prot & (PROT_READ|PROT_WRITE|PROT_EXEC)],
            0,
            off,
            len);

    if (ptr == NULL)
    {
        set_last_errno();
        ptr = (void*)-1;
    }

    CloseHandle(hMap);

    return ptr;
}

int munmap(void* addr,int len)
{
    if (UnmapViewOfFile(addr))
    {
        errno = 0;
        return 0;
    }
    set_last_errno();
    return -1;
}

int is_bad_mmap(void* p)
{
    void* bad_ptr;
    bad_ptr = (void*)-1;
    return p == bad_ptr;
}


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_irregex_toplevel)
C_externimport void C_ccall C_irregex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[405];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,41),40,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,55,49,32,108,111,99,55,50,32,109,115,103,55,51,32,46,32,97,114,103,115,55,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,115,116,97,116,32,102,105,108,101,56,54,32,108,105,110,107,56,55,32,101,114,114,56,56,32,108,111,99,56,57,41,0,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,28),40,102,105,108,101,45,115,116,97,116,32,102,49,48,50,32,46,32,116,109,112,49,48,49,49,48,51,41,0,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,49,50,56,41,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,49,51,49,41,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,111,119,110,101,114,32,102,49,51,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,32,102,49,51,55,41,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,16),40,102,105,108,101,45,115,105,122,101,32,102,49,52,48,41};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,116,121,112,101,32,102,105,108,101,49,52,56,32,46,32,116,109,112,49,52,55,49,52,57,41,0};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,23),40,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,105,108,101,49,54,55,41,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,16),40,102,95,50,52,53,54,32,102,105,108,101,49,54,57,41};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,16),40,102,95,50,52,54,54,32,102,105,108,101,49,55,49,41};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,16),40,102,95,50,52,55,54,32,102,105,108,101,49,55,51,41};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,16),40,102,95,50,52,56,54,32,102,105,108,101,49,55,53,41};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,16),40,102,95,50,52,57,54,32,102,105,108,101,49,55,55,41};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,20),40,100,105,114,101,99,116,111,114,121,63,32,102,105,108,101,49,55,57,41,0,0,0,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,25),40,109,111,100,101,32,105,110,112,49,56,53,32,109,49,56,54,32,108,111,99,49,56,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,32,108,111,99,49,57,57,32,102,100,50,48,48,32,105,110,112,50,48,49,32,114,50,48,50,41};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,21),40,102,95,50,53,55,49,32,102,100,50,48,53,32,46,32,109,50,48,54,41,0,0,0};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,21),40,102,95,50,53,56,53,32,102,100,50,48,56,32,46,32,109,50,48,57,41,0,0,0};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,16),40,102,95,50,53,57,57,32,112,111,114,116,50,49,53,41};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,24),40,102,95,50,54,52,55,32,111,108,100,50,50,52,32,46,32,110,101,119,50,50,53,41};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,31),40,99,117,114,114,101,110,116,45,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,50,51,54,50,51,55,41,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,14),40,114,109,100,105,114,32,100,105,114,50,54,52,41,0,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,11),40,103,50,55,49,32,102,50,56,48,41,0,0,0,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,55,48,32,103,50,55,55,50,56,56,41,0,0,0,0,0,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,38),40,100,101,108,101,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,50,53,54,32,46,32,116,109,112,50,53,53,50,53,55,41,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,23),40,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,51,48,48,51,48,49,41,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,7),40,97,50,57,54,51,41,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,11),40,103,51,54,51,32,109,51,54,53,41,0,0,0,0,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,102,110,115,51,53,54,41,0,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,46),40,97,50,57,54,57,32,100,105,114,51,51,57,51,52,48,51,52,53,32,102,105,108,51,52,49,51,52,50,51,52,54,32,101,120,116,51,52,51,51,52,52,51,52,55,41,0,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,20),40,99,111,110,99,45,108,111,111,112,32,112,97,116,104,115,51,51,55,41,0,0,0,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,17),40,103,108,111,98,32,46,32,112,97,116,104,115,51,51,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,7),40,97,51,49,51,51,41,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,7),40,97,51,49,51,56,41,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,7),40,97,51,49,54,54,41,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,102,115,51,57,50,32,114,51,57,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,13),40,102,95,51,50,50,52,32,120,51,57,48,41,0,0,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,15),40,102,95,51,50,52,48,32,46,32,95,51,56,55,41,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,15),40,102,95,51,50,51,50,32,46,32,95,51,56,54,41,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,7),40,97,51,50,54,57,41,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,7),40,97,51,50,55,50,41,0};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,7),40,97,51,50,55,53,41,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,7),40,97,51,50,55,56,41,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,18),40,102,95,51,50,56,52,32,120,52,50,56,32,121,52,50,57,41,0,0,0,0,0,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,7),40,97,51,50,56,49,41,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,15),40,102,95,51,50,57,50,32,46,32,95,52,50,54,41,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,7),40,97,51,50,56,57,41,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,31),40,102,105,110,100,45,102,105,108,101,115,32,100,105,114,52,50,51,32,46,32,116,109,112,52,50,50,52,50,52,41,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,45,116,105,109,101,45,118,101,99,116,111,114,32,108,111,99,52,53,53,32,116,109,52,53,54,41};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,33),40,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,46,32,116,109,112,52,54,51,52,54,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,31),40,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,46,32,116,109,112,52,55,54,52,55,55,41,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,29),40,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,46,32,116,109,112,52,57,53,52,57,54,41,0,0,0};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,27),40,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,53,48,55,41,0,0,0,0,0};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,32),40,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,53,52,48,32,46,32,116,109,112,53,51,57,53,52,49,41};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,22),40,115,101,116,101,110,118,32,118,97,114,53,53,52,32,118,97,108,53,53,53,41,0,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,17),40,117,110,115,101,116,101,110,118,32,118,97,114,53,54,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,11),40,115,99,97,110,32,106,53,55,52,41,0,0,0,0,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,53,55,49,41,0,0,0,0,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,27),40,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,36),40,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,53,55,56,32,112,114,111,99,53,55,57,41,0,0,0,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,20),40,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,7),40,97,51,54,54,52,41,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,33),40,97,51,54,55,48,32,101,112,105,100,54,48,51,32,101,110,111,114,109,54,48,52,32,101,99,111,100,101,54,48,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,24),40,112,114,111,99,101,115,115,45,119,97,105,116,32,46,32,97,114,103,115,53,56,56,41};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,54,55,55,32,102,108,97,103,115,54,55,56,32,46,32,109,111,100,101,54,55,57,41,0,0,0,0,0,0};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,18),40,102,105,108,101,45,99,108,111,115,101,32,102,100,54,56,56,41,0,0,0,0,0,0};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,37),40,102,105,108,101,45,114,101,97,100,32,102,100,54,57,50,32,115,105,122,101,54,57,51,32,46,32,98,117,102,102,101,114,54,57,52,41,0,0,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,38),40,102,105,108,101,45,119,114,105,116,101,32,102,100,55,48,52,32,98,117,102,102,101,114,55,48,53,32,46,32,115,105,122,101,55,48,54,41,0,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,55,49,54,41,0,0,0,0,0,0};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,25),40,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,110,97,109,101,55,50,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,20),40,102,54,57,49,56,32,102,110,97,109,101,55,51,49,54,57,49,55,41,0,0,0,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,20),40,102,54,57,49,50,32,102,110,97,109,101,55,51,49,54,57,49,49,41,0,0,0,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,20),40,102,54,57,48,54,32,102,110,97,109,101,55,51,49,54,57,48,53,41,0,0,0,0};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,20),40,102,54,57,48,48,32,102,110,97,109,101,55,51,49,54,56,57,57,41,0,0,0,0};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,55,51,55,32,112,111,115,55,51,56,32,46,32,119,104,101,110,99,101,55,51,57,41,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,11),40,103,55,55,57,32,120,55,56,56,41,0,0,0,0,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,55,56,32,103,55,56,53,55,57,56,41,0,0,0,0,0,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,55,54,51,32,46,32,116,109,112,55,54,50,55,54,52,41,0,0};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,56,48,57,41,0,0,0,0,0,0};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,26),40,99,104,101,99,107,32,99,109,100,56,49,57,32,105,110,112,56,50,48,32,114,56,50,49,41,0,0,0,0,0,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,56,50,53,32,46,32,109,56,50,54,41,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,56,51,53,32,46,32,109,56,51,54,41};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,26),40,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,56,52,53,41,0,0,0,0,0,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,27),40,99,108,111,115,101,45,111,117,116,112,117,116,45,112,105,112,101,32,112,111,114,116,56,53,48,41,0,0,0,0,0};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,7),40,97,52,51,49,52,41,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,20),40,97,52,51,50,48,32,46,32,114,101,115,117,108,116,115,56,54,54,41,0,0,0,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,47),40,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,56,54,50,32,112,114,111,99,56,54,51,32,46,32,109,111,100,101,56,54,52,41,0};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,7),40,97,52,51,51,56,41,0};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,20),40,97,52,51,52,52,32,46,32,114,101,115,117,108,116,115,56,55,51,41,0,0,0,0};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,48),40,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,56,54,57,32,112,114,111,99,56,55,48,32,46,32,109,111,100,101,56,55,49,41};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,7),40,97,52,51,54,50,41,0};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,20),40,97,52,51,55,51,32,46,32,114,101,115,117,108,116,115,56,56,56,41,0,0,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,7),40,97,52,51,54,55,41,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,7),40,97,52,51,56,50,41,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,48),40,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,56,55,54,32,116,104,117,110,107,56,55,55,32,46,32,109,111,100,101,56,55,56,41};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,7),40,97,52,51,57,54,41,0};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,20),40,97,52,52,48,55,32,46,32,114,101,115,117,108,116,115,57,48,53,41,0,0,0,0};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,7),40,97,52,52,48,49,41,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,7),40,97,52,52,49,54,41,0};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,47),40,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,56,57,51,32,116,104,117,110,107,56,57,52,32,46,32,109,111,100,101,56,57,53,41,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,25),40,99,114,101,97,116,101,45,112,105,112,101,32,46,32,116,109,112,57,49,52,57,49,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,32),40,99,104,97,110,103,101,45,102,105,108,101,45,109,111,100,101,32,102,110,97,109,101,57,56,57,32,109,57,57,48,41};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,33),40,99,104,101,99,107,32,102,105,108,101,110,97,109,101,57,57,53,32,97,99,99,57,57,54,32,108,111,99,57,57,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,114,101,97,100,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,48,48,49,41};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,33),40,102,105,108,101,45,119,114,105,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,48,48,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,35),40,102,105,108,101,45,101,120,101,99,117,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,48,48,51,41,0,0,0,0,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,28),40,109,111,100,101,32,105,110,112,49,48,49,50,32,109,49,48,49,51,32,108,111,99,49,48,49,52,41,0,0,0,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,28),40,99,104,101,99,107,32,102,100,49,48,50,54,32,105,110,112,49,48,50,55,32,114,49,48,50,56,41,0,0,0,0};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,33),40,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,49,48,51,50,32,46,32,109,49,48,51,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,34),40,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,49,48,51,53,32,46,32,109,49,48,51,54,41,0,0,0,0,0,0};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,23),40,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,49,48,52,50,41,0};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,36),40,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,49,48,52,56,32,46,32,110,101,119,49,48,52,57,41,0,0,0,0};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,29),40,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41,0,0,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,18),40,95,101,120,105,116,32,46,32,99,111,100,101,49,48,54,54,41,0,0,0,0,0,0};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,25),40,116,101,114,109,105,110,97,108,45,112,111,114,116,63,32,112,111,114,116,49,48,54,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,115,105,122,101,32,112,111,114,116,49,48,55,51,41};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,50),40,115,101,116,45,98,117,102,102,101,114,105,110,103,45,109,111,100,101,33,32,112,111,114,116,49,48,55,53,32,109,111,100,101,49,48,55,54,32,46,32,115,105,122,101,49,48,55,55,41,0,0,0,0,0,0};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,24),40,108,111,111,112,32,105,108,115,116,49,49,48,55,32,111,108,115,116,49,49,48,56,41};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,37),40,36,113,117,111,116,101,45,97,114,103,115,45,108,105,115,116,32,108,115,116,49,48,57,52,32,101,120,97,99,116,102,49,48,57,53,41,0,0,0};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,49),40,115,101,116,97,114,103,32,105,110,116,49,49,49,53,49,49,50,49,32,99,45,115,116,114,105,110,103,49,49,49,54,49,49,50,50,32,105,110,116,49,49,49,55,49,49,50,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,49),40,115,101,116,101,110,118,32,105,110,116,49,49,50,53,49,49,51,49,32,99,45,115,116,114,105,110,103,49,49,50,54,49,49,51,50,32,105,110,116,49,49,50,55,49,49,51,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,24),40,100,111,108,111,111,112,49,49,51,57,32,108,49,49,52,49,32,105,49,49,52,50,41};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,61),40,98,117,105,108,100,45,101,120,101,99,45,97,114,103,118,101,99,32,108,111,99,49,49,51,53,32,108,115,116,49,49,51,54,32,97,114,103,118,101,99,45,115,101,116,116,101,114,49,49,51,55,32,105,100,120,49,49,51,56,41,0,0,0};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,67),40,36,101,120,101,99,45,115,101,116,117,112,32,108,111,99,49,49,52,56,32,102,105,108,101,110,97,109,101,49,49,52,57,32,97,114,103,108,115,116,49,49,53,48,32,101,110,118,108,115,116,49,49,53,49,32,101,120,97,99,116,102,49,49,53,50,41,0,0,0,0,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,53),40,36,101,120,101,99,45,116,101,97,114,100,111,119,110,32,108,111,99,49,49,54,49,32,109,115,103,49,49,54,50,32,102,105,108,101,110,97,109,101,49,49,54,51,32,114,101,115,49,49,54,52,41,0,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,44),40,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,49,49,55,52,32,46,32,116,109,112,49,49,55,51,49,49,55,53,41,0,0,0,0};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,51),40,112,114,111,99,101,115,115,45,115,112,97,119,110,32,109,111,100,101,49,49,57,53,32,102,105,108,101,110,97,109,101,49,49,57,54,32,46,32,116,109,112,49,49,57,52,49,49,57,55,41,0,0,0,0,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,41,0,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,45,97,114,103,117,109,101,110,116,115,32,99,109,100,108,105,110,49,50,49,55,41,0,0,0,0,0,0};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,114,117,110,32,102,49,50,49,57,32,46,32,97,114,103,115,49,50,50,48,41,0,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,97),40,35,35,115,121,115,35,112,114,111,99,101,115,115,32,108,111,99,49,50,54,49,32,99,109,100,49,50,54,50,32,97,114,103,115,49,50,54,51,32,101,110,118,49,50,54,52,32,115,116,100,111,117,116,102,49,50,54,53,32,115,116,100,105,110,102,49,50,54,54,32,115,116,100,101,114,114,102,49,50,54,55,32,46,32,116,109,112,49,50,54,48,49,50,54,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,7),40,103,49,51,51,48,41,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,49,51,50,57,41,0,0,0,0,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,19),40,99,104,107,115,116,114,108,115,116,32,108,115,116,49,51,50,54,41,0,0,0,0,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,7),40,97,53,52,56,51,41,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,38),40,97,53,52,56,57,32,105,110,49,51,53,53,32,111,117,116,49,51,53,54,32,112,105,100,49,51,53,55,32,101,114,114,49,51,53,56,41,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,63),40,37,112,114,111,99,101,115,115,32,108,111,99,49,51,49,57,32,101,114,114,63,49,51,50,48,32,99,109,100,49,51,50,49,32,97,114,103,115,49,51,50,50,32,101,110,118,49,51,50,51,32,101,120,97,99,116,102,49,51,50,52,41,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,31),40,112,114,111,99,101,115,115,32,99,109,100,49,51,54,55,32,46,32,116,109,112,49,51,54,54,49,51,54,56,41,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,32),40,112,114,111,99,101,115,115,42,32,99,109,100,49,51,56,54,32,46,32,116,109,112,49,51,56,53,49,51,56,55,41};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,52,48,50,32,110,111,104,97,110,103,49,52,48,51,41,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,13),40,115,108,101,101,112,32,115,49,52,48,53,41,0,0,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,15),40,103,101,116,45,104,111,115,116,45,110,97,109,101,41,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,20),40,115,121,115,116,101,109,45,105,110,102,111,114,109,97,116,105,111,110,41,0,0,0,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,19),40,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,72),40,109,97,112,45,102,105,108,101,45,116,111,45,109,101,109,111,114,121,32,97,100,100,114,49,52,52,55,32,108,101,110,49,52,52,56,32,112,114,111,116,49,52,52,57,32,102,108,97,103,49,52,53,48,32,102,100,49,52,53,49,32,46,32,111,102,102,49,52,53,50,41};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,43),40,117,110,109,97,112,45,102,105,108,101,45,102,114,111,109,45,109,101,109,111,114,121,32,109,109,97,112,49,52,54,57,32,46,32,108,101,110,49,52,55,48,41,0,0,0,0,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,37),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,45,112,111,105,110,116,101,114,32,109,109,97,112,49,52,55,52,41,0,0,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,27),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,63,32,120,49,52,55,55,41,0,0,0,0,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,31),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,42,32,46,32,95,49,53,48,56,49,53,49,50,41,0};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,31),40,99,104,97,110,103,101,45,102,105,108,101,45,111,119,110,101,114,32,46,32,95,49,53,49,53,49,53,49,57,41,0};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,25),40,99,114,101,97,116,101,45,102,105,102,111,32,46,32,95,49,53,50,49,49,53,50,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,28),40,99,114,101,97,116,101,45,115,101,115,115,105,111,110,32,46,32,95,49,53,50,55,49,53,51,49,41,0,0,0,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,34),40,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,46,32,95,49,53,51,51,49,53,51,55,41,0,0,0,0,0,0};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,40),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,103,114,111,117,112,45,105,100,32,46,32,95,49,53,51,57,49,53,52,51,41};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,39),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,105,100,32,46,32,95,49,53,52,53,49,53,52,57,41,0};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,41),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,32,46,32,95,49,53,53,49,49,53,53,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,30),40,99,117,114,114,101,110,116,45,103,114,111,117,112,45,105,100,32,46,32,95,49,53,53,55,49,53,54,49,41,0,0};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,117,115,101,114,45,105,100,32,46,32,95,49,53,54,51,49,53,54,55,41,0,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,108,105,110,107,32,46,32,95,49,53,54,57,49,53,55,51,41,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,108,111,99,107,32,46,32,95,49,53,55,53,49,53,55,57,41,0};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,46,32,95,49,53,56,49,49,53,56,53,41};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,115,101,108,101,99,116,32,46,32,95,49,53,56,55,49,53,57,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,28),40,102,105,108,101,45,116,101,115,116,45,108,111,99,107,32,46,32,95,49,53,57,51,49,53,57,55,41,0,0,0,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,27),40,102,105,108,101,45,116,114,117,110,99,97,116,101,32,46,32,95,49,53,57,57,49,54,48,51,41,0,0,0,0,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,25),40,102,105,108,101,45,117,110,108,111,99,107,32,46,32,95,49,54,48,53,49,54,48,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,24),40,103,101,116,45,103,114,111,117,112,115,32,46,32,95,49,54,49,49,49,54,49,53,41};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,31),40,103,114,111,117,112,45,105,110,102,111,114,109,97,116,105,111,110,32,46,32,95,49,54,49,55,49,54,50,49,41,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,31),40,105,110,105,116,105,97,108,105,122,101,45,103,114,111,117,112,115,32,46,32,95,49,54,50,51,49,54,50,55,41,0};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,31),40,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,32,46,32,95,49,54,50,57,49,54,51,51,41,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,26),40,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,95,49,54,51,53,49,54,51,57,41,0,0,0,0,0,0};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,32,46,32,95,49,54,52,49,49,54,52,53,41,0,0};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,28),40,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,46,32,95,49,54,52,55,49,54,53,49,41,0,0,0,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,32),40,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,46,32,95,49,54,53,51,49,54,53,55,41};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,24),40,115,101,116,45,97,108,97,114,109,33,32,46,32,95,49,54,53,57,49,54,54,51,41};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,27),40,115,101,116,45,103,114,111,117,112,45,105,100,33,32,46,32,95,49,54,54,53,49,54,54,57,41,0,0,0,0,0};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,25),40,115,101,116,45,103,114,111,117,112,115,33,32,46,32,95,49,54,55,49,49,54,55,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,35),40,115,101,116,45,112,114,111,99,101,115,115,45,103,114,111,117,112,45,105,100,33,32,46,32,95,49,54,55,55,49,54,56,49,41,0,0,0,0,0};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,33),40,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,46,32,95,49,54,56,51,49,54,56,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,30),40,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,46,32,95,49,54,56,57,49,54,57,51,41,0,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,26),40,115,101,116,45,117,115,101,114,45,105,100,33,32,46,32,95,49,54,57,53,49,54,57,57,41,0,0,0,0,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,25),40,115,105,103,110,97,108,45,109,97,115,107,32,46,32,95,49,55,48,49,49,55,48,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,26),40,115,105,103,110,97,108,45,109,97,115,107,33,32,46,32,95,49,55,48,55,49,55,49,49,41,0,0,0,0,0,0};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,28),40,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,46,32,95,49,55,49,51,49,55,49,55,41,0,0,0,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,28),40,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,46,32,95,49,55,49,57,49,55,50,51,41,0,0,0,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,27),40,116,101,114,109,105,110,97,108,45,110,97,109,101,32,46,32,95,49,55,50,53,49,55,50,57,41,0,0,0,0,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,30),40,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,46,32,95,49,55,51,49,49,55,51,53,41,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,31),40,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,46,32,95,49,55,51,55,49,55,52,49,41,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,26),40,115,116,114,105,110,103,45,62,116,105,109,101,32,46,32,95,49,55,52,51,49,55,52,55,41,0,0,0,0,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,13),40,102,105,102,111,63,32,95,49,55,53,48,41,0,0,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,15),40,97,54,49,49,52,32,112,111,114,116,55,53,48,41,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,14),40,97,54,49,53,53,32,115,105,103,53,56,52,41,0,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,19),40,97,54,49,54,52,32,46,32,116,109,112,52,51,57,52,52,48,41,0,0,0,0,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,13),40,97,54,49,56,57,32,117,109,52,53,50,41,0,0,0};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,12),40,97,54,49,57,53,32,102,49,49,49,41,0,0,0,0};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,17),40,97,54,50,48,49,32,102,49,49,51,32,116,49,49,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k5810 */
static C_word C_fcall stub1463(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1463(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k5754 */
static C_word C_fcall stub1442(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1442(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
C_r=C_mk_bool(is_bad_mmap(t0));
return C_r;}

/* from k5745 */
static C_word C_fcall stub1430(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub1430(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from k5307 */
static C_word C_fcall stub1232(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7) C_regparm;
C_regparm static C_word C_fcall stub1232(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
void * t2=(void * )C_c_pointer_or_null(C_a2);
int *t3=(int *)C_c_pointer_or_null(C_a3);
int *t4=(int *)C_c_pointer_or_null(C_a4);
int *t5=(int *)C_c_pointer_or_null(C_a5);
int *t6=(int *)C_c_pointer_or_null(C_a6);
int t7=(int )C_unfix(C_a7);
C_r=C_mk_bool(C_process(t0,t1,t2,t3,t4,t5,t6,t7));
return C_r;}

/* from k4979 */
static C_word C_fcall stub1128(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1128(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from k4958 */
static C_word C_fcall stub1118(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1118(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k4753 */
static C_word C_fcall stub1063(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1063(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1057(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1057(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char *z = (_daylight ? _tzname[1] : _tzname[0]);
C_return(z);
C_ret:
#undef return

return C_r;}

/* from k3549 */
static C_word C_fcall stub566(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub566(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k3447 */
static C_word C_fcall stub526(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub526(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
void * t2=(void * )C_data_pointer_or_null(C_a2);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1,t2));
return C_r;}

/* from k3434 */
static C_word C_fcall stub516(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub516(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0,t1));
return C_r;}

/* from k3367 */
static C_word C_fcall stub487(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub487(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k6210 in k6233 in a6201 in k2231 in k2228 in k2225 in k2222 in k2219 */
static C_word C_fcall stub120(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub120(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_fix((C_word)set_file_mtime(t0,t1));
return C_r;}

/* from k2242 */
static C_word C_fcall stub67(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub67(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(f_4812)
static void C_ccall f_4812(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3671)
static void C_ccall f_3671(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4803)
static void C_ccall f_4803(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4803)
static void C_ccall f_4803r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2446)
static void C_ccall f_2446(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3665)
static void C_ccall f_3665(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2474)
static void C_ccall f_2474(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2476)
static void C_ccall f_2476(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4809)
static void C_fcall f_4809(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2464)
static void C_ccall f_2464(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2466)
static void C_ccall f_2466(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2496)
static void C_ccall f_2496(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2494)
static void C_ccall f_2494(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6131)
static void C_ccall f_6131(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5776)
static void C_ccall f_5776(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5770)
static void C_ccall f_5770(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2291)
static void C_ccall f_2291(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5767)
static void C_fcall f_5767(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2298)
static void C_ccall f_2298(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2800)
static void C_ccall f_2800(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2800)
static void C_ccall f_2800r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2804)
static void C_ccall f_2804(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5764)
static void C_ccall f_5764(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5760)
static void C_ccall f_5760(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
C_noret_decl(f_5760)
static void C_ccall f_5760r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
C_noret_decl(f_6119)
static void C_ccall f_6119(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6115)
static void C_ccall f_6115(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2456)
static void C_ccall f_2456(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2454)
static void C_ccall f_2454(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6122)
static void C_ccall f_6122(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2233)
static void C_ccall f_2233(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2230)
static void C_ccall f_2230(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4521)
static void C_ccall f_4521(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2822)
static void C_ccall f_2822(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2983)
static void C_fcall f_2983(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2825)
static void C_ccall f_2825(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2981)
static void C_ccall f_2981(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2829)
static void C_ccall f_2829(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5782)
static void C_fcall f_5782(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2221)
static void C_ccall f_2221(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2227)
static void C_ccall f_2227(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2224)
static void C_ccall f_2224(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2819)
static void C_ccall f_2819(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2256)
static void C_ccall f_2256(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6105)
static void C_ccall f_6105(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4277)
static void C_ccall f_4277(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2624)
static void C_ccall f_2624(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4270)
static void C_ccall f_4270(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6156)
static void C_ccall f_6156(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2245)
static void C_ccall f_2245(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_2245)
static void C_ccall f_2245r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_2249)
static void C_ccall f_2249(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5577)
static void C_ccall f_5577(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5577)
static void C_ccall f_5577r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f6918)
static void C_ccall f6918(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6165)
static void C_ccall f_6165(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6165)
static void C_ccall f_6165r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4261)
static void C_ccall f_4261(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f6912)
static void C_ccall f6912(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2943)
static void C_ccall f_2943(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2943)
static void C_ccall f_2943r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2949)
static void C_fcall f_2949(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2486)
static void C_ccall f_2486(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2484)
static void C_ccall f_2484(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f6906)
static void C_ccall f6906(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4251)
static void C_ccall f_4251(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f6900)
static void C_ccall f6900(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2974)
static void C_ccall f_2974(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2970)
static void C_ccall f_2970(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4244)
static void C_ccall f_4244(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4989)
static void C_fcall f_4989(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2964)
static void C_ccall f_2964(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3618)
static void C_ccall f_3618(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6196)
static void C_ccall f_6196(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4230)
static void C_ccall f_4230(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4230)
static void C_ccall f_4230r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6190)
static void C_ccall f_6190(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4977)
static void C_ccall f_4977(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2913)
static void C_ccall f_2913(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2615)
static void C_ccall f_2615(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4221)
static void C_ccall f_4221(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4968)
static void C_ccall f_4968(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4422)
static void C_ccall f_4422(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4422)
static void C_ccall f_4422r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4438)
static void C_ccall f_4438(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4956)
static void C_ccall f_4956(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4429)
static void C_ccall f_4429(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4947)
static void C_ccall f_4947(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4939)
static void C_ccall f_4939(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4569)
static void C_ccall f_4569(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4561)
static void C_ccall f_4561(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5073)
static void C_fcall f_5073(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5077)
static void C_ccall f_5077(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4551)
static void C_fcall f_4551(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2260)
static void C_ccall f_2260(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4913)
static void C_fcall f_4913(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2267)
static void C_ccall f_2267(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2263)
static void C_fcall f_2263(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2869)
static void C_fcall f_2869(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2857)
static void C_ccall f_2857(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4549)
static void C_ccall f_4549(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4545)
static void C_ccall f_4545(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5053)
static void C_ccall f_5053(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5050)
static void C_ccall f_5050(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5088)
static void C_ccall f_5088(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5088)
static void C_ccall f_5088r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4298)
static void C_ccall f_4298(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4295)
static void C_ccall f_4295(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5037)
static void C_fcall f_5037(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_5060)
static void C_ccall f_5060(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5064)
static void C_ccall f_5064(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4870)
static void C_fcall f_4870(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4288)
static void C_ccall f_4288(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4280)
static void C_ccall f_4280(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4884)
static C_word C_fcall f_4884(C_word t0,C_word t1);
C_noret_decl(f_4573)
static void C_ccall f_4573(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4575)
static void C_ccall f_4575(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4417)
static void C_ccall f_4417(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4412)
static void C_ccall f_4412(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5912)
static void C_ccall f_5912(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5044)
static void C_ccall f_5044(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2657)
static void C_ccall f_2657(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2654)
static void C_fcall f_2654(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5047)
static void C_ccall f_5047(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4408)
static void C_ccall f_4408(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4408)
static void C_ccall f_4408r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4402)
static void C_ccall f_4402(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2647)
static void C_ccall f_2647(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2647)
static void C_ccall f_2647r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2641)
static void C_ccall f_2641(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5020)
static void C_ccall f_5020(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4537)
static void C_ccall f_4537(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2879)
static void C_ccall f_2879(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5001)
static void C_fcall f_5001(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5433)
static void C_fcall f_5433(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_5435)
static void C_fcall f_5435(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4596)
static void C_fcall f_4596(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4211)
static void C_ccall f_4211(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5422)
static void C_ccall f_5422(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4587)
static void C_ccall f_4587(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4204)
static void C_ccall f_4204(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4581)
static void C_ccall f_4581(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5490)
static void C_ccall f_5490(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_2843)
static void C_fcall f_2843(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5484)
static void C_ccall f_5484(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2674)
static void C_ccall f_2674(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2674)
static void C_ccall f_2674r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5816)
static void C_ccall f_5816(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5816)
static void C_ccall f_5816r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3318)
static void C_ccall f_3318(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3318)
static void C_ccall f_3318r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5440)
static C_word C_fcall f_5440(C_word t0,C_word t1);
C_noret_decl(f_5449)
static C_word C_fcall f_5449(C_word t0,C_word t1);
C_noret_decl(f_2690)
static void C_ccall f_2690(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3570)
static void C_fcall f_3570(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2687)
static void C_ccall f_2687(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5823)
static void C_fcall f_5823(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3562)
static void C_ccall f_3562(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3596)
static void C_ccall f_3596(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5402)
static void C_ccall f_5402(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3588)
static void C_ccall f_3588(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5406)
static void C_ccall f_5406(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3343)
static void C_ccall f_3343(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5984)
static void C_ccall f_5984(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5476)
static void C_ccall f_5476(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3532)
static void C_ccall f_3532(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3530)
static void C_ccall f_3530(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5479)
static void C_ccall f_5479(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5996)
static void C_ccall f_5996(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3374)
static void C_ccall f_3374(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3370)
static void C_ccall f_3370(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3370)
static void C_ccall f_3370r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3558)
static void C_fcall f_3558(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3552)
static void C_ccall f_3552(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3540)
static void C_ccall f_3540(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3113)
static void C_ccall f_3113(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3110)
static void C_ccall f_3110(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3380)
static void C_ccall f_3380(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5942)
static void C_ccall f_5942(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3777)
static void C_ccall f_3777(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3771)
static void C_ccall f_3771(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5972)
static void C_ccall f_5972(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5948)
static void C_ccall f_5948(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5960)
static void C_ccall f_5960(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3515)
static void C_ccall f_3515(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5978)
static void C_ccall f_5978(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5990)
static void C_ccall f_5990(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3507)
static void C_ccall f_3507(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5966)
static void C_ccall f_5966(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3972)
static void C_ccall f_3972(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5906)
static void C_ccall f_5906(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5900)
static void C_ccall f_5900(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5918)
static void C_ccall f_5918(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5864)
static void C_ccall f_5864(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3966)
static void C_ccall f_3966(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3960)
static void C_ccall f_3960(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5936)
static void C_ccall f_5936(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5930)
static void C_ccall f_5930(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3177)
static void C_ccall f_3177(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3910)
static void C_ccall f_3910(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3918)
static void C_ccall f_3918(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5924)
static void C_ccall f_5924(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3758)
static void C_ccall f_3758(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3755)
static void C_ccall f_3755(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3161)
static void C_ccall f_3161(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6086)
static void C_ccall f_6086(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6080)
static void C_ccall f_6080(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3167)
static void C_ccall f_3167(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3900)
static void C_ccall f_3900(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5849)
static void C_ccall f_5849(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5954)
static void C_ccall f_5954(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3193)
static void C_ccall f_3193(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6098)
static void C_ccall f_6098(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6092)
static void C_ccall f_6092(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3199)
static void C_ccall f_3199(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3186)
static void C_ccall f_3186(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3180)
static void C_ccall f_3180(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3339)
static void C_ccall f_3339(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3339)
static void C_ccall f_3339r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6212)
static void C_ccall f_6212(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3132)
static void C_ccall f_3132(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3134)
static void C_ccall f_3134(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3139)
static void C_ccall f_3139(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4711)
static void C_ccall f_4711(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4713)
static void C_ccall f_4713(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4713)
static void C_ccall f_4713r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3322)
static void C_ccall f_3322(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6222)
static void C_ccall f_6222(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3796)
static void C_ccall f_3796(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3796)
static void C_ccall f_3796r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3122)
static void C_ccall f_3122(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6044)
static void C_ccall f_6044(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3790)
static void C_ccall f_3790(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2353)
static void C_ccall f_2353(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2351)
static void C_ccall f_2351(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2357)
static void C_ccall f_2357(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2359)
static void C_ccall f_2359(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2359)
static void C_ccall f_2359r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6235)
static void C_ccall f_6235(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3151)
static void C_ccall f_3151(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3154)
static void C_ccall f_3154(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3742)
static void C_fcall f_3742(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6056)
static void C_ccall f_6056(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6050)
static void C_ccall f_6050(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2341)
static void C_ccall f_2341(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2347)
static void C_ccall f_2347(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2345)
static void C_ccall f_2345(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4729)
static void C_ccall f_4729(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6062)
static void C_ccall f_6062(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3738)
static void C_ccall f_3738(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3738)
static void C_ccall f_3738r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3147)
static void C_ccall f_3147(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6068)
static void C_ccall f_6068(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4720)
static void C_fcall f_4720(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4723)
static void C_ccall f_4723(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2378)
static void C_ccall f_2378(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3526)
static void C_ccall f_3526(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6074)
static void C_ccall f_6074(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3764)
static void C_ccall f_3764(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5894)
static void C_ccall f_5894(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6002)
static void C_ccall f_6002(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6008)
static void C_ccall f_6008(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5870)
static void C_ccall f_5870(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6014)
static void C_ccall f_6014(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5876)
static void C_ccall f_5876(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6200)
static void C_ccall f_6200(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6202)
static void C_ccall f_6202(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6020)
static void C_ccall f_6020(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6026)
static void C_ccall f_6026(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2333)
static void C_ccall f_2333(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2335)
static void C_ccall f_2335(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2339)
static void C_ccall f_2339(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6032)
static void C_ccall f_6032(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6038)
static void C_ccall f_6038(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3951)
static void C_fcall f_3951(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2327)
static void C_ccall f_2327(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2329)
static void C_ccall f_2329(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5858)
static void C_ccall f_5858(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2714)
static void C_fcall f_2714(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2718)
static void C_ccall f_2718(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3947)
static void C_ccall f_3947(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3947)
static void C_ccall f_3947r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5882)
static void C_ccall f_5882(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5888)
static void C_ccall f_5888(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2708)
static void C_ccall f_2708(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2708)
static void C_ccall f_2708r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4604)
static void C_ccall f_4604(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2514)
static void C_ccall f_2514(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4176)
static void C_ccall f_4176(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2519)
static void C_fcall f_2519(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4172)
static void C_fcall f_4172(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4152)
static void C_ccall f_4152(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4144)
static void C_ccall f_4144(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4135)
static void C_ccall f_4135(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4138)
static void C_ccall f_4138(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4128)
static void C_ccall f_4128(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2506)
static void C_ccall f_2506(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2504)
static void C_ccall f_2504(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4743)
static void C_ccall f_4743(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4334)
static void C_ccall f_4334(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4339)
static void C_ccall f_4339(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4330)
static void C_ccall f_4330(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4330)
static void C_ccall f_4330r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2527)
static void C_ccall f_2527(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4325)
static void C_ccall f_4325(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4321)
static void C_ccall f_4321(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4321)
static void C_ccall f_4321r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4397)
static void C_ccall f_4397(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4392)
static void C_ccall f_4392(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4388)
static void C_ccall f_4388(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4388)
static void C_ccall f_4388r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4383)
static void C_ccall f_4383(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2757)
static void C_ccall f_2757(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2751)
static void C_ccall f_2751(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2314)
static void C_ccall f_2314(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2741)
static void C_fcall f_2741(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2740)
static void C_ccall f_2740(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2307)
static void C_ccall f_2307(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2307)
static void C_ccall f_2307r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2302)
static void C_ccall f_2302(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4354)
static void C_ccall f_4354(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4354)
static void C_ccall f_4354r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4358)
static void C_ccall f_4358(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2768)
static void C_fcall f_2768(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2763)
static void C_ccall f_2763(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4795)
static void C_ccall f_4795(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4345)
static void C_ccall f_4345(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4345)
static void C_ccall f_4345r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4349)
static void C_ccall f_4349(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5222)
static void C_ccall f_5222(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5226)
static void C_ccall f_5226(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4190)
static void C_ccall f_4190(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4190)
static void C_ccall f_4190r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4651)
static void C_ccall f_4651(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4651)
static void C_ccall f_4651r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4776)
static void C_ccall f_4776(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4770)
static void C_ccall f_4770(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4188)
static void C_ccall f_4188(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4315)
static void C_ccall f_4315(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4637)
static void C_ccall f_4637(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4633)
static void C_fcall f_4633(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4310)
static void C_ccall f_4310(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4756)
static void C_ccall f_4756(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4756)
static void C_ccall f_4756r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4665)
static void C_ccall f_4665(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4665)
static void C_ccall f_4665r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4306)
static void C_ccall f_4306(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4306)
static void C_ccall f_4306r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4663)
static void C_ccall f_4663(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5266)
static void C_ccall f_5266(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4788)
static void C_ccall f_4788(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4378)
static void C_ccall f_4378(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4374)
static void C_ccall f_4374(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4374)
static void C_ccall f_4374r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5253)
static void C_fcall f_5253(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2569)
static void C_ccall f_2569(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4368)
static void C_ccall f_4368(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4363)
static void C_ccall f_4363(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5243)
static void C_ccall f_5243(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5249)
static void C_ccall f_5249(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5249)
static void C_ccall f_5249r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2778)
static void C_ccall f_2778(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5238)
static void C_ccall f_5238(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3000)
static void C_ccall f_3000(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3004)
static void C_fcall f_3004(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4117)
static void C_ccall f_4117(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4109)
static void C_ccall f_4109(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2734)
static void C_ccall f_2734(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2597)
static void C_ccall f_2597(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2599)
static void C_ccall f_2599(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3887)
static void C_ccall f_3887(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3880)
static void C_ccall f_3880(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3044)
static void C_ccall f_3044(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4697)
static void C_ccall f_4697(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4691)
static void C_ccall f_4691(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5398)
static void C_ccall f_5398(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4649)
static void C_ccall f_4649(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5394)
static void C_ccall f_5394(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3024)
static void C_ccall f_3024(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5390)
static void C_ccall f_5390(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2556)
static void C_fcall f_2556(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4677)
static void C_ccall f_4677(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4679)
static void C_ccall f_4679(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5383)
static void C_ccall f_5383(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3016)
static void C_ccall f_3016(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3012)
static void C_ccall f_3012(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5339)
static void C_ccall f_5339(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...) C_noret;
C_noret_decl(f_5339)
static void C_ccall f_5339r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t10) C_noret;
C_noret_decl(f_2585)
static void C_ccall f_2585(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2585)
static void C_ccall f_2585r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2583)
static void C_ccall f_2583(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3088)
static void C_ccall f_3088(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3821)
static void C_ccall f_3821(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2571)
static void C_ccall f_2571(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2571)
static void C_ccall f_2571r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3812)
static void C_ccall f_3812(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3206)
static void C_ccall f_3206(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5353)
static void C_ccall f_5353(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3060)
static void C_fcall f_3060(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3067)
static void C_ccall f_3067(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3069)
static void C_fcall f_3069(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5346)
static void C_ccall f_5346(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3057)
static void C_fcall f_3057(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3862)
static void C_ccall f_3862(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3416)
static void C_ccall f_3416(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3213)
static void C_ccall f_3213(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3412)
static void C_ccall f_3412(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3856)
static void C_ccall f_3856(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5177)
static void C_ccall f_5177(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3850)
static void C_fcall f_3850(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3408)
static void C_ccall f_3408(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3847)
static void C_ccall f_3847(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3840)
static void C_ccall f_3840(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3840)
static void C_ccall f_3840r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4084)
static void C_ccall f_4084(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3223)
static void C_ccall f_3223(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3224)
static void C_ccall f_3224(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3460)
static void C_ccall f_3460(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5708)
static void C_ccall f_5708(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3469)
static void C_ccall f_3469(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4074)
static void C_fcall f_4074(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4051)
static void C_ccall f_4051(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3250)
static void C_ccall f_3250(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3453)
static void C_ccall f_3453(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3453)
static void C_ccall f_3453r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3253)
static void C_ccall f_3253(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3256)
static void C_ccall f_3256(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3259)
static void C_ccall f_3259(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4040)
static void C_ccall f_4040(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3893)
static void C_ccall f_3893(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3284)
static void C_ccall f_3284(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5285)
static void C_ccall f_5285(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3282)
static void C_ccall f_3282(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5281)
static void C_ccall f_5281(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4059)
static void C_ccall f_4059(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4032)
static void C_ccall f_4032(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5155)
static void C_ccall f_5155(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5155)
static void C_ccall f_5155r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3232)
static void C_ccall f_3232(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5270)
static void C_ccall f_5270(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3265)
static void C_ccall f_3265(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3262)
static void C_ccall f_3262(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5511)
static void C_ccall f_5511(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5517)
static void C_ccall f_5517(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5517)
static void C_ccall f_5517r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5515)
static void C_ccall f_5515(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5371)
static void C_ccall f_5371(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5367)
static void C_ccall f_5367(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3290)
static void C_ccall f_3290(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3292)
static void C_ccall f_3292(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3297)
static void C_ccall f_3297(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3299)
static void C_fcall f_3299(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4027)
static void C_fcall f_4027(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5363)
static void C_ccall f_5363(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4023)
static void C_ccall f_4023(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3486)
static void C_ccall f_3486(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3483)
static void C_ccall f_3483(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4018)
static void C_ccall f_4018(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4015)
static void C_ccall f_4015(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5110)
static void C_ccall f_5110(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3276)
static void C_ccall f_3276(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3273)
static void C_ccall f_3273(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3270)
static void C_ccall f_3270(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3279)
static void C_ccall f_3279(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3479)
static void C_ccall f_3479(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4003)
static void C_ccall f_4003(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4005)
static void C_ccall f_4005(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4005)
static void C_ccall f_4005r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3600)
static void C_ccall f_3600(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5667)
static void C_ccall f_5667(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5655)
static void C_ccall f_5655(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5649)
static void C_ccall f_5649(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3806)
static void C_ccall f_3806(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3809)
static void C_ccall f_3809(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5637)
static void C_ccall f_5637(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3641)
static void C_ccall f_3641(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3641)
static void C_ccall f_3641r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3422)
static void C_ccall f_3422(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5690)
static void C_ccall f_5690(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5693)
static void C_ccall f_5693(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3635)
static void C_ccall f_3635(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3633)
static void C_ccall f_3633(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5698)
static void C_ccall f_5698(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5682)
static void C_ccall f_5682(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5686)
static void C_ccall f_5686(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3240)
static void C_ccall f_3240(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3246)
static void C_ccall f_3246(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3246)
static void C_ccall f_3246r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5678)
static void C_ccall f_5678(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4821)
static void C_fcall f_4821(C_word t0,C_word t1) C_noret;

C_noret_decl(trf_4809)
static void C_fcall trf_4809(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4809(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4809(t0,t1);}

C_noret_decl(trf_5767)
static void C_fcall trf_5767(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5767(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5767(t0,t1);}

C_noret_decl(trf_2983)
static void C_fcall trf_2983(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2983(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2983(t0,t1,t2);}

C_noret_decl(trf_5782)
static void C_fcall trf_5782(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5782(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5782(t0,t1);}

C_noret_decl(trf_2949)
static void C_fcall trf_2949(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2949(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2949(t0,t1,t2);}

C_noret_decl(trf_4989)
static void C_fcall trf_4989(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4989(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4989(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5073)
static void C_fcall trf_5073(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5073(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5073(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4551)
static void C_fcall trf_4551(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4551(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4551(t0,t1,t2,t3);}

C_noret_decl(trf_4913)
static void C_fcall trf_4913(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4913(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4913(t0,t1,t2,t3);}

C_noret_decl(trf_2263)
static void C_fcall trf_2263(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2263(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2263(t0,t1,t2,t3,t4);}

C_noret_decl(trf_2869)
static void C_fcall trf_2869(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2869(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2869(t0,t1);}

C_noret_decl(trf_5037)
static void C_fcall trf_5037(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5037(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_5037(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_4870)
static void C_fcall trf_4870(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4870(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4870(t0,t1,t2);}

C_noret_decl(trf_2654)
static void C_fcall trf_2654(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2654(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2654(t0,t1);}

C_noret_decl(trf_5001)
static void C_fcall trf_5001(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5001(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5001(t0,t1,t2,t3);}

C_noret_decl(trf_5433)
static void C_fcall trf_5433(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5433(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_5433(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_5435)
static void C_fcall trf_5435(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5435(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5435(t0,t1,t2);}

C_noret_decl(trf_4596)
static void C_fcall trf_4596(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4596(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4596(t0,t1,t2,t3);}

C_noret_decl(trf_2843)
static void C_fcall trf_2843(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2843(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2843(t0,t1);}

C_noret_decl(trf_3570)
static void C_fcall trf_3570(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3570(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3570(t0,t1,t2);}

C_noret_decl(trf_5823)
static void C_fcall trf_5823(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5823(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5823(t0,t1);}

C_noret_decl(trf_3558)
static void C_fcall trf_3558(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3558(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3558(t0,t1,t2);}

C_noret_decl(trf_3742)
static void C_fcall trf_3742(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3742(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3742(t0,t1);}

C_noret_decl(trf_4720)
static void C_fcall trf_4720(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4720(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4720(t0,t1);}

C_noret_decl(trf_3951)
static void C_fcall trf_3951(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3951(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3951(t0,t1);}

C_noret_decl(trf_2714)
static void C_fcall trf_2714(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2714(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2714(t0,t1);}

C_noret_decl(trf_2519)
static void C_fcall trf_2519(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2519(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2519(t0,t1,t2,t3);}

C_noret_decl(trf_4172)
static void C_fcall trf_4172(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4172(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4172(t0,t1,t2,t3);}

C_noret_decl(trf_2741)
static void C_fcall trf_2741(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2741(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2741(t0,t1,t2);}

C_noret_decl(trf_2768)
static void C_fcall trf_2768(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2768(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2768(t0,t1,t2);}

C_noret_decl(trf_4633)
static void C_fcall trf_4633(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4633(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4633(t0,t1,t2,t3);}

C_noret_decl(trf_5253)
static void C_fcall trf_5253(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5253(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5253(t0,t1);}

C_noret_decl(trf_3004)
static void C_fcall trf_3004(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3004(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3004(t0,t1,t2);}

C_noret_decl(trf_2556)
static void C_fcall trf_2556(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2556(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2556(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3060)
static void C_fcall trf_3060(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3060(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3060(t0,t1);}

C_noret_decl(trf_3069)
static void C_fcall trf_3069(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3069(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3069(t0,t1,t2,t3);}

C_noret_decl(trf_3057)
static void C_fcall trf_3057(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3057(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3057(t0,t1);}

C_noret_decl(trf_3850)
static void C_fcall trf_3850(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3850(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3850(t0,t1);}

C_noret_decl(trf_4074)
static void C_fcall trf_4074(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4074(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4074(t0,t1,t2);}

C_noret_decl(trf_3299)
static void C_fcall trf_3299(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3299(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3299(t0,t1,t2);}

C_noret_decl(trf_4027)
static void C_fcall trf_4027(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4027(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4027(t0,t1,t2);}

C_noret_decl(trf_4821)
static void C_fcall trf_4821(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4821(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4821(t0,t1);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr9r)
static void C_fcall tr9r(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9r(C_proc9 k){
int n;
C_word *a,t9;
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
n=C_rest_count(0);
a=C_alloc(n*3);
t9=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr7r)
static void C_fcall tr7r(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7r(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n*3);
t7=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

/* k4810 in k4807 in set-buffering-mode! in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4812(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4812,2,t0,t1);}
t2=t1;
t3=C_i_check_exact_2(((C_word*)t0)[2],lf[286]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4821,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t5=C_slot(((C_word*)t0)[4],C_fix(7));
t6=C_eqp(lf[55],t5);
if(C_truep(t6)){
t7=C_setvbuf(((C_word*)t0)[4],t2,((C_word*)t0)[2]);
t8=t4;
f_4821(t8,C_fixnum_lessp(t7,C_fix(0)));}
else{
t7=t4;
f_4821(t7,C_SCHEME_TRUE);}}

/* a3670 in process-wait in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3671(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3671,5,t0,t1,t2,t3,t4);}
t5=C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
/* posix-common.scm:613: posix-error */
t6=lf[2];
f_2245(6,t6,t1,lf[126],lf[124],lf[127],((C_word*)t0)[2]);}
else{
/* posix-common.scm:614: values */
C_values(5,0,t1,t2,t3,t4);}}

/* set-buffering-mode! in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4803(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_4803r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4803r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4803r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(5);
t5=t2;
t6=C_i_check_port_2(t5,C_fix(0),C_SCHEME_TRUE,lf[286]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4809,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t8=t4;
t9=t7;
f_4809(t9,C_u_i_car(t8));}
else{
t8=t7;
f_4809(t8,C_fix((C_word)BUFSIZ));}}

/* regular-file? in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2446(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2446,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2454,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:277: file-type */
t4=*((C_word*)lf[26]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* a3664 in process-wait in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3665(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3665,2,t0,t1);}
/* posix-common.scm:611: ##sys#process-wait */
t2=*((C_word*)lf[125]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* k2472 */
static void C_ccall f_2474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[31],t1));}

/* f_2476 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2476(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2476,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2484,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:286: file-type */
t4=*((C_word*)lf[26]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k4807 in set-buffering-mode! in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_4809(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4809,NULL,2,t0,t1);}
t2=t1;
t3=((C_word*)t0)[2];
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4812,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=C_eqp(t3,lf[288]);
if(C_truep(t5)){
t6=t4;
f_4812(2,t6,C_fix((C_word)_IOFBF));}
else{
t6=C_eqp(t3,lf[289]);
if(C_truep(t6)){
t7=C_fix((C_word)_IOLBF);
t8=t4;
f_4812(2,t8,t7);}
else{
t7=C_eqp(t3,lf[290]);
if(C_truep(t7)){
t8=t4;
f_4812(2,t8,C_fix((C_word)_IONBF));}
else{
/* posixwin.scm:1206: ##sys#error */
t8=*((C_word*)lf[45]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t4,lf[286],lf[291],((C_word*)t0)[2],((C_word*)t0)[4]);}}}}

/* k2462 */
static void C_ccall f_2464(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[28],t1));}

/* f_2466 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2466(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2466,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2474,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:283: file-type */
t4=*((C_word*)lf[26]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* f_2496 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2496(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2496,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2504,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:292: file-type */
t4=*((C_word*)lf[26]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2492 */
static void C_ccall f_2494(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[32],t1));}

/* k6129 in a6114 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6131(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[55]);
if(C_truep(t3)){
t4=C_ftell(((C_word*)t0)[2]);
t5=((C_word*)t0)[3];
f_6119(2,t5,t4);}
else{
t4=((C_word*)t0)[3];
f_6119(2,t4,C_fix(-1));}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=C_lseek(((C_word*)t0)[2],C_fix(0),C_fix((C_word)SEEK_CUR));
t3=((C_word*)t0)[3];
f_6119(2,t3,t2);}
else{
/* posixwin.scm:845: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[15],lf[174],lf[398],((C_word*)t0)[2]);}}}

/* k5774 in k5768 in k5765 in k5762 in map-file-to-memory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5776(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5776,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_record3(&a,3,lf[340],((C_word*)t0)[3],((C_word*)t0)[4]));}

/* k5768 in k5765 in k5762 in map-file-to-memory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5770(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5770,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[5];
t6=C_a_i_bytevector(&a,1,C_fix(3));
t7=(C_truep(((C_word*)t0)[6])?C_i_foreign_pointer_argumentp(((C_word*)t0)[6]):C_SCHEME_FALSE);
t8=C_i_foreign_integer_argumentp(t2);
t9=C_i_foreign_fixnum_argumentp(t3);
t10=C_i_foreign_fixnum_argumentp(t4);
t11=C_i_foreign_fixnum_argumentp(t5);
t12=C_i_foreign_integer_argumentp(((C_word*)t0)[7]);
t13=stub1430(t6,t7,t8,t9,t10,t11,t12);
t14=t13;
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5776,a[2]=((C_word*)t0)[8],a[3]=t14,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5782,a[2]=t15,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=t14,tmp=(C_word)a,a+=11,tmp);
if(C_truep(t14)){
t17=C_i_foreign_pointer_argumentp(t14);
t18=t16;
f_5782(t18,stub1442(C_SCHEME_UNDEFINED,t17));}
else{
t17=t16;
f_5782(t17,stub1442(C_SCHEME_UNDEFINED,C_SCHEME_FALSE));}}

/* k2289 in stat in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2291(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2267(2,t2,(C_truep(((C_word*)t0)[3])?C_lstat(t1):C_stat(t1)));}

/* k5765 in k5762 in map-file-to-memory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_5767(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5767,NULL,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5770,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_blockp(((C_word*)t0)[6]))){
if(C_truep(C_specialp(((C_word*)t0)[6]))){
t4=t3;
f_5770(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm:1579: ##sys#signal-hook */
t4=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t3,lf[15],lf[339],lf[342],((C_word*)t0)[6]);}}
else{
/* posixwin.scm:1579: ##sys#signal-hook */
t4=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t3,lf[15],lf[339],lf[342],((C_word*)t0)[6]);}}

/* k2296 in stat in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:220: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2800(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2800r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2800r(t0,t1,t2);}}

static void C_ccall f_2800r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2804,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* posix-common.scm:402: current-directory */
t5=*((C_word*)lf[65]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t5=t4;
f_2804(2,t5,C_i_car(t3));}}

/* k2802 in directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2804(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2804,2,t0,t1);}
t2=t1;
t3=C_i_nullp(((C_word*)t0)[2]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_i_cdr(((C_word*)t0)[2]));
t5=C_i_nullp(t4);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_i_car(t4));
t7=t6;
t8=C_i_nullp(t4);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t4));
t10=C_i_check_string_2(t2,lf[29]);
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2819,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t7,tmp=(C_word)a,a+=5,tmp);
/* ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[69]+1)))(4,*((C_word*)lf[69]+1),t11,C_fix(256),C_make_character(32));}

/* k5762 in map-file-to-memory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5764(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5764,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5767,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[7]))){
t4=((C_word*)t0)[7];
t5=t3;
f_5767(t5,C_u_i_car(t4));}
else{
t4=t3;
f_5767(t4,C_fix(0));}}

/* map-file-to-memory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5760(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(c<7) C_bad_min_argc_2(c,7,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7r,(void*)f_5760r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest(a,C_rest_count(0));
f_5760r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void C_ccall f_5760r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5764,a[2]=t3,a[3]=t4,a[4]=t5,a[5]=t6,a[6]=t1,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_5764(2,t10,t2);}
else{
/* posixwin.scm:1576: ##sys#null-pointer */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[343]+1)))(2,*((C_word*)lf[343]+1),t8);}}

/* k6117 in a6114 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6119(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6119,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6122,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_lessp(t2,C_fix(0)))){
/* posixwin.scm:847: posix-error */
t4=lf[2];
f_2245(6,t4,t3,lf[10],lf[174],lf[397],((C_word*)t0)[3]);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* a6114 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6115(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6115,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6119,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6131,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:838: port? */
t5=*((C_word*)lf[171]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* f_2456 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2456(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2456,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2464,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:280: file-type */
t4=*((C_word*)lf[26]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_TRUE,C_SCHEME_FALSE);}

/* k2452 in regular-file? in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2454(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[27],t1));}

/* k6120 in k6117 in a6114 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6122(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2233(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2233,2,t0,t1);}
t2=C_mutate2(&lf[2] /* (set! posix-error ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2245,a[2]=((C_word)li0),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate2((C_word*)lf[8]+1 /* (set! ##sys#posix-error ...) */,lf[2]);
t4=C_mutate2(&lf[9] /* (set! ##sys#stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2263,a[2]=((C_word)li1),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[17]+1 /* (set! file-stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2307,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2327,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6196,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6202,a[2]=((C_word)li198),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:245: getter-with-setter */
t9=*((C_word*)lf[399]+1);
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,t6,t7,t8,lf[404]);}

/* k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2230(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2230,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2233,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_ports_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* change-file-mode in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4521(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4521,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[266]);
t5=C_i_check_exact_2(t3,lf[266]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4545,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4549,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1086: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t7,t2);}

/* k2820 in k2817 in k2802 in directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2822(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2822,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2825,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:406: ##sys#make-pointer */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[78]+1)))(2,*((C_word*)lf[78]+1),t3);}

/* loop in k2979 in k2972 in a2969 in conc-loop in glob in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_2983(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2983,NULL,3,t0,t1,t2);}
if(C_truep(C_i_nullp(t2))){
t3=C_i_cdr(((C_word*)t0)[2]);
/* posix-common.scm:441: conc-loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_2949(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3000,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t4=C_i_car(t2);
/* posix-common.scm:442: irregex-match */
t5=*((C_word*)lf[83]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[6],t4);}}

/* k2823 in k2820 in k2817 in k2802 in directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2825(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2825,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2829,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2913,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:409: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t4,((C_word*)t0)[4]);}

/* k2979 in k2972 in a2969 in conc-loop in glob in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2981(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2981,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2983,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word)li31),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_2983(t5,((C_word*)t0)[6],t1);}

/* k2827 in k2823 in k2820 in k2817 in k2802 in directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2829(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2829,2,t0,t1);}
t2=C_opendir(t1,((C_word*)t0)[2]);
if(C_truep(C_null_pointerp(((C_word*)t0)[2]))){
/* posix-common.scm:411: posix-error */
t3=lf[2];
f_2245(6,t3,((C_word*)t0)[3],lf[10],lf[29],lf[77],((C_word*)t0)[4]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2843,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t4,a[6]=((C_word*)t0)[7],a[7]=((C_word)li27),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_2843(t6,((C_word*)t0)[3]);}}

/* k5780 in k5768 in k5765 in k5762 in map-file-to-memory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_5782(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5782,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm:1582: posix-error */
t2=lf[2];
f_2245(11,t2,((C_word*)t0)[2],lf[10],lf[339],lf[341],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)t0)[8]);}
else{
t2=((C_word*)t0)[9];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_record3(&a,3,lf[340],((C_word*)t0)[10],((C_word*)t0)[4]));}}

/* k2219 */
static void C_ccall f_2221(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2221,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2224,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_irregex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2225 in k2222 in k2219 */
static void C_ccall f_2227(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2227,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2230,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_files_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2222 in k2219 */
static void C_ccall f_2224(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2224,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2227,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2817 in k2802 in directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2819(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2819,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2822,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:405: ##sys#make-pointer */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[78]+1)))(2,*((C_word*)lf[78]+1),t3);}

/* k2254 in k2247 in posix-error in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2256(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[2],*((C_word*)lf[3]+1),((C_word*)t0)[3],((C_word*)t0)[4],t1,((C_word*)t0)[5]);}

/* fifo? in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6105(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6105,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* k4275 in close-input-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4277(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4277,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4280,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_eqp(C_fix(-1),((C_word*)t0)[3]);
if(C_truep(t3)){
/* posixwin.scm:932: ##sys#signal-hook */
t4=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[10],lf[189],lf[190],((C_word*)t0)[4]);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,((C_word*)t0)[3]);}}

/* k2622 in k2639 */
static void C_ccall f_2624(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* close-input-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4270(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4270,3,t0,t1,t2);}
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_TRUE,C_SCHEME_TRUE,lf[189]);
t5=close_pipe(t2);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4277,a[2]=t1,a[3]=t5,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:930: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t6);}

/* a6155 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6156(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6156,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[122]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_slot(*((C_word*)lf[121]+1),t2));}

/* posix-error in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2245(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr5r,(void*)f_2245r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_2245r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_2245r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2249,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t5,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:178: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t6);}

/* k2247 in posix-error in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2249(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2249,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2256,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2260,a[2]=t2,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(t1);
t6=stub67(t4,t5);
/* posix-common.scm:175: ##sys#peek-c-string */
t7=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t3,t6,C_fix(0));}

/* process* in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5577(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3r,(void*)f_5577r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5577r(t0,t1,t2,t3);}}

static void C_ccall f_5577r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=C_i_nullp(t11);
t13=(C_truep(t12)?C_SCHEME_FALSE:C_i_car(t11));
if(C_truep(C_i_nullp(t11))){
/* posixwin.scm:1391: %process */
f_5433(t1,lf[321],C_SCHEME_TRUE,t2,t5,t9,t13);}
else{
t14=C_i_cdr(t11);
/* posixwin.scm:1391: %process */
f_5433(t1,lf[321],C_SCHEME_TRUE,t2,t5,t9,t13);}}

/* f6918 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f6918(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f6918,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[37]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* a6164 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6165(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2r,(void*)f_6165r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_6165r(t0,t1,t2);}}

static void C_ccall f_6165r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=(C_truep(t4)?C_i_check_exact_2(t4,lf[101]):C_SCHEME_UNDEFINED);
if(C_truep(t4)){
t6=C_umask(t4);
if(C_truep(t4)){
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t7=C_umask(t6);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t6);}}
else{
t6=C_umask(C_fix(0));
if(C_truep(t4)){
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t7=C_umask(t6);
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t6);}}}

/* k4259 in open-output-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4261(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4261,2,t0,t1);}
t2=open_binary_output_pipe(&a,1,t1);
/* posixwin.scm:920: check */
f_4172(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* f6912 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f6912(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f6912,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[36]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* glob in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2943(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr2r,(void*)f_2943r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2943r(t0,t1,t2);}}

static void C_ccall f_2943r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2949,a[2]=t4,a[3]=((C_word)li33),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_2949(t6,t1,t2);}

/* conc-loop in glob in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_2949(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2949,NULL,3,t0,t1,t2);}
if(C_truep(C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=C_i_car(t2);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2964,a[2]=t4,a[3]=((C_word)li29),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2970,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li32),tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:437: ##sys#call-with-values */
C_call_with_values(4,0,t1,t5,t6);}}

/* f_2486 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2486(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2486,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2494,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:289: file-type */
t4=*((C_word*)lf[26]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2482 */
static void C_ccall f_2484(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[30],t1));}

/* f6906 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f6906(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f6906,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[38]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* k4249 in open-output-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4251(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4251,2,t0,t1);}
t2=open_text_output_pipe(&a,1,t1);
/* posixwin.scm:920: check */
f_4172(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* f6900 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f6900(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f6900,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[39]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* k2972 in a2969 in conc-loop in glob in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2974(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2974,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2981,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[4])){
/* posix-common.scm:440: directory */
t4=*((C_word*)lf[29]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[4],C_SCHEME_TRUE);}
else{
/* posix-common.scm:440: directory */
t4=*((C_word*)lf[29]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,lf[84],C_SCHEME_TRUE);}}

/* a2969 in conc-loop in glob in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2970(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_2970,5,t0,t1,t2,t3,t4);}
t5=t2;
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2974,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t5,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3044,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t3)){
t8=t3;
/* posix-common.scm:439: make-pathname */
t9=*((C_word*)lf[81]+1);
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,t7,C_SCHEME_FALSE,t8,t4);}
else{
/* posix-common.scm:439: make-pathname */
t8=*((C_word*)lf[81]+1);
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t7,C_SCHEME_FALSE,lf[86],t4);}}

/* k4242 in open-output-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4244(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:920: check */
f_4172(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_FALSE,t1);}

/* build-exec-argvec in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_4989(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4989,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(t3)){
t6=C_i_check_list_2(t3,t2);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5001,a[2]=t4,a[3]=t2,a[4]=t8,a[5]=((C_word)li125),tmp=(C_word)a,a+=6,tmp));
t10=((C_word*)t8)[1];
f_5001(t10,t1,t3,t5);}
else{
/* posixwin.scm:1272: argvec-setter */
t6=t4;
((C_proc5)C_fast_retrieve_proc(t6))(5,t6,t1,t5,C_SCHEME_FALSE,C_fix(0));}}

/* a2963 in conc-loop in glob in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2964(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2964,2,t0,t1);}
/* posix-common.scm:438: decompose-pathname */
t2=*((C_word*)lf[80]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* set-signal-handler! in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3618(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3618,4,t0,t1,t2,t3);}
t4=C_i_check_exact_2(t2,lf[120]);
if(C_truep(t3)){
t5=t2;
t6=C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,C_i_vector_set(*((C_word*)lf[121]+1),t2,t3));}
else{
t5=C_establish_signal_handler(t2,C_SCHEME_FALSE);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_i_vector_set(*((C_word*)lf[121]+1),t2,t3));}}

/* a6195 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6196(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6196,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6200,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:247: ##sys#stat */
f_2263(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[20]);}

/* open-output-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4230(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_4230r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4230r(t0,t1,t2,t3);}}

static void C_ccall f_4230r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(10);
t4=C_i_check_string_2(t2,lf[188]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[185]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4244,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[185]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4251,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:923: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t9,t2,lf[188]);}
else{
t9=C_eqp(t6,lf[186]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4261,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:924: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t10,t2,lf[188]);}
else{
/* posixwin.scm:898: ##sys#error */
t10=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t7,lf[187],t6);}}}

/* a6189 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6190(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6190,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[101]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_umask(t2));}

/* k4975 in setenv in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4977(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,stub1128(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t1,t2));}

/* k2911 in k2823 in k2820 in k2817 in k2802 in directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2913(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:409: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[29]);}

/* k2613 */
static void C_ccall f_2615(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_slot(t1,C_fix(0)));}

/* k4219 in open-input-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4221(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4221,2,t0,t1);}
t2=open_binary_input_pipe(&a,1,t1);
/* posixwin.scm:910: check */
f_4172(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* setenv in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4968(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4968,5,t0,t1,t2,t3,t4);}
t5=C_i_foreign_fixnum_argumentp(t2);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4977,a[2]=t4,a[3]=t1,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t3)){
t8=C_i_foreign_string_argumentp(t3);
/* posixwin.scm:1260: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t7,t8);}
else{
t8=C_i_foreign_fixnum_argumentp(t4);
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,stub1128(C_SCHEME_UNDEFINED,t6,C_SCHEME_FALSE,t8));}}

/* create-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4422(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr2r,(void*)f_4422r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4422r(t0,t1,t2);}}

static void C_ccall f_4422r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_fixnum_or(*((C_word*)lf[138]+1),*((C_word*)lf[140]+1)):C_i_car(t2));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4429,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t6=C_pipe(C_SCHEME_FALSE,t4);
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4438,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:990: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t7);}
else{
/* posixwin.scm:992: values */
C_values(4,0,t1,C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}}

/* k4436 in create-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4438(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:991: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[10],lf[199],lf[200]);}

/* k4954 in setarg in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4956(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,stub1118(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t1,t2));}

/* k4427 in create-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4429(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:992: values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* setarg in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4947(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4947,5,t0,t1,t2,t3,t4);}
t5=C_i_foreign_fixnum_argumentp(t2);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4956,a[2]=t4,a[3]=t1,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t3)){
t8=C_i_foreign_string_argumentp(t3);
/* posixwin.scm:1259: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t7,t8);}
else{
t8=C_i_foreign_fixnum_argumentp(t4);
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,stub1118(C_SCHEME_UNDEFINED,t6,C_SCHEME_FALSE,t8));}}

/* k4937 in loop in $quote-args-list in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4939(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4939,2,t0,t1);}
t2=C_a_i_cons(&a,2,t1,((C_word*)t0)[2]);
/* posixwin.scm:1249: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_4913(t3,((C_word*)t0)[4],((C_word*)t0)[5],t2);}

/* k4567 in check in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4569(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4569,2,t0,t1);}
t2=C_test_access(t1,((C_word*)t0)[2]);
t3=C_eqp(C_fix(0),t2);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4561,a[2]=((C_word*)t0)[3],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
t6=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t4);}
else{
/* posixwin.scm:1098: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t5);}}

/* k4559 in k4567 in check in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4561(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* $exec-teardown in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_5073(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5073,NULL,5,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5077,a[2]=t5,a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm:1283: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t6);}

/* k5075 in $exec-teardown in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5077(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=C_free_exec_args();
t3=C_free_exec_env();
t4=C_eqp(((C_word*)t0)[2],C_fix(-1));
if(C_truep(t4)){
/* posixwin.scm:1287: ##sys#error */
t5=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6]);}
else{
t5=((C_word*)t0)[2];
t6=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* check in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_4551(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4551,NULL,4,t1,t2,t3,t4);}
t5=C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4569,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4573,a[2]=t6,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1097: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t7,t2);}

/* k2258 in k2247 in posix-error in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2260(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:179: string-append */
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],((C_word*)t0)[3],lf[5],t1);}

/* loop in $quote-args-list in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_4913(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
loop:
a=C_alloc(14);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4913,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm:1247: ##sys#fast-reverse */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[298]+1)))(3,*((C_word*)lf[298]+1),t1,t3);}
else{
t4=C_i_car(t2);
t5=t2;
t6=C_u_i_cdr(t5);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4939,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t6,tmp=(C_word)a,a+=6,tmp);
t8=t4;
t9=C_i_string_length(t8);
t10=t9;
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4884,a[2]=t10,a[3]=t8,a[4]=((C_word)li120),tmp=(C_word)a,a+=5,tmp);
t12=f_4884(t11,C_fix(0));
if(C_truep(t12)){
/* posixwin.scm:1252: string-append */
t13=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t13+1)))(5,t13,t7,lf[299],t4,lf[300]);}
else{
t13=C_a_i_cons(&a,2,t4,t3);
/* posixwin.scm:1249: loop */
t15=t1;
t16=t6;
t17=t13;
t1=t15;
t2=t16;
t3=t17;
goto loop;}}}

/* k2265 in stat in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2267(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:232: posix-error */
t2=lf[2];
f_2245(6,t2,((C_word*)t0)[3],lf[10],((C_word*)t0)[4],lf[11],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}}

/* ##sys#stat in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_2263(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2263,NULL,5,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2267,a[2]=t4,a[3]=t1,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnump(t2))){
t7=t6;
f_2267(2,t7,C_fstat(t2));}
else{
if(C_truep(C_i_stringp(t2))){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2291,a[2]=t6,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2298,a[2]=t7,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2302,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:222: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t9,t2);}
else{
/* posix-common.scm:228: ##sys#signal-hook */
t7=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,lf[15],t5,lf[16],t2);}}}

/* k2867 in k2855 in loop in k2827 in k2823 in k2820 in k2817 in k2802 in directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_2869(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2869,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posix-common.scm:426: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_2843(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2879,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:427: loop */
t3=((C_word*)((C_word*)t0)[2])[1];
f_2843(t3,t2);}}

/* k2855 in loop in k2827 in k2823 in k2820 in k2817 in k2802 in directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2857(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2857,2,t0,t1);}
t2=t1;
t3=C_i_string_ref(t2,C_fix(0));
t4=C_fixnum_greaterp(((C_word*)t0)[2],C_fix(1));
t5=(C_truep(t4)?C_subchar(t2,C_fix(1)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2869,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t7=C_eqp(C_make_character(46),t3);
if(C_truep(t7)){
t8=C_i_not(t5);
if(C_truep(t8)){
t9=t6;
f_2869(t9,t8);}
else{
t9=C_eqp(C_make_character(46),t5);
if(C_truep(t9)){
t10=C_eqp(C_fix(2),((C_word*)t0)[2]);
t11=t6;
f_2869(t11,(C_truep(t10)?t10:C_i_not(((C_word*)t0)[5])));}
else{
t10=t6;
f_2869(t10,C_i_not(((C_word*)t0)[5]));}}}
else{
t8=t6;
f_2869(t8,C_SCHEME_FALSE);}}

/* k4547 in change-file-mode in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4549(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1086: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[266]);}

/* k4543 in change-file-mode in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4545(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4545,2,t0,t1);}
t2=C_chmod(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4537,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1087: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k5051 in k5048 in k5045 in k5042 in $exec-setup in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5053(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5053,2,t0,t1);}
t2=C_flushall();
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5060,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1280: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t3,((C_word*)t0)[4]);}

/* k5048 in k5045 in k5042 in $exec-setup in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5050(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5050,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5053,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1278: build-exec-argvec */
f_4989(t2,((C_word*)t0)[3],((C_word*)t0)[6],((C_word*)t0)[7],C_fix(0));}

/* process-execute in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5088(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_5088r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5088r(t0,t1,t2,t3);}}

static void C_ccall f_5088r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word *a=C_alloc(5);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=t9;
t11=C_i_nullp(t7);
t12=(C_truep(t11)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t13=C_i_nullp(t12);
t14=(C_truep(t13)?C_SCHEME_FALSE:C_i_car(t12));
t15=C_i_nullp(t12);
t16=(C_truep(t15)?C_SCHEME_END_OF_LIST:C_i_cdr(t12));
t17=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5110,a[2]=t10,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1291: $exec-setup */
t18=lf[301];
f_5037(t18,t17,lf[304],t2,t5,t10,t14);}

/* k4296 in k4293 in close-output-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k4293 in close-output-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4295(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4295,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4298,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_eqp(C_fix(-1),((C_word*)t0)[3]);
if(C_truep(t3)){
/* posixwin.scm:940: ##sys#signal-hook */
t4=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[10],lf[191],lf[192],((C_word*)t0)[4]);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,((C_word*)t0)[3]);}}

/* $exec-setup in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_5037(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5037,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=C_i_check_string_2(t3,t2);
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5044,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=((C_word*)t0)[2],a[6]=t5,a[7]=((C_word*)t0)[3],a[8]=((C_word*)t0)[4],a[9]=t4,a[10]=t6,tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm:1275: pathname-strip-directory */
t9=*((C_word*)lf[302]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t3);}

/* k5058 in k5051 in k5048 in k5045 in k5042 in $exec-setup in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5060(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1280: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* k5062 in k5045 in k5042 in $exec-setup in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5064(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1277: build-exec-argvec */
f_4989(((C_word*)t0)[3],((C_word*)t0)[4],t1,((C_word*)t0)[5],C_fix(1));}

/* $quote-args-list in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_4870(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4870,NULL,3,t1,t2,t3);}
if(C_truep(t3)){
t4=t2;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4913,a[2]=t5,a[3]=((C_word)li121),tmp=(C_word)a,a+=4,tmp));
t7=((C_word*)t5)[1];
f_4913(t7,t1,t2,C_SCHEME_END_OF_LIST);}}

/* close-output-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4288(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4288,3,t0,t1,t2);}
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[191]);
t5=close_pipe(t2);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4295,a[2]=t1,a[3]=t5,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:938: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t6);}

/* k4278 in k4275 in close-input-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4280(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* loop in loop in $quote-args-list in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static C_word C_fcall f_4884(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;
loop:
t2=C_eqp(t1,((C_word*)t0)[2]);
if(C_truep(t2)){
return(C_SCHEME_FALSE);}
else{
t3=C_i_string_ref(((C_word*)t0)[3],t1);
if(C_truep(C_u_i_char_whitespacep(t3))){
return(C_SCHEME_TRUE);}
else{
t4=C_fixnum_plus(t1,C_fix(1));
t6=t4;
t1=t6;
goto loop;}}}

/* k4571 in check in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4573(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1097: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* file-read-access? in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4575(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4575,3,t0,t1,t2);}
/* posixwin.scm:1100: check */
f_4551(t1,t2,C_fix((C_word)2),lf[268]);}

/* a4416 in k4390 in with-output-to-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4417(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4417,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[198]+1));
t3=C_mutate2((C_word*)lf[198]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k4410 in a4407 in a4401 in k4390 in with-output-to-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4412(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* current-group-id in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5912(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5912,2,t0,t1);}
/* posixwin.scm:1616: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[357],lf[0]);}

/* k5042 in $exec-setup in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5044,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5047,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t3=C_block_size(t1);
/* posixwin.scm:1276: setarg */
t4=((C_word*)t0)[8];
f_4947(5,t4,t2,C_fix(0),t1,t3);}

/* k2655 in k2652 */
static void C_ccall f_2657(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k2652 */
static void C_fcall f_2654(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2654,NULL,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2657,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posix-common.scm:359: posix-error */
t4=lf[2];
f_2245(6,t4,t3,lf[10],lf[63],lf[64],((C_word*)t0)[3]);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* k5045 in k5042 in $exec-setup in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5047(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5047,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5050,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5064,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[9])){
/* posixwin.scm:1277: $quote-args-list */
f_4870(t3,((C_word*)t0)[9],((C_word*)t0)[10]);}
else{
/* posixwin.scm:1277: build-exec-argvec */
f_4989(t2,((C_word*)t0)[3],C_SCHEME_FALSE,((C_word*)t0)[8],C_fix(1));}}

/* a4407 in a4401 in k4390 in with-output-to-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4408(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4408r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4408r(t0,t1,t2);}}

static void C_ccall f_4408r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4412,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:978: close-output-pipe */
t4=*((C_word*)lf[191]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* a4401 in k4390 in with-output-to-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4402(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4402,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4408,a[2]=((C_word*)t0)[2],a[3]=((C_word)li99),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:975: ##sys#call-with-values */
C_call_with_values(4,0,t1,((C_word*)t0)[3],t2);}

/* f_2647 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2647(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_2647r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2647r(t0,t1,t2,t3);}}

static void C_ccall f_2647r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=C_i_check_exact_2(t2,*((C_word*)lf[63]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2654,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t6=t5;
f_2654(t6,C_dup(t2));}
else{
t6=C_i_car(t3);
t7=C_i_check_exact_2(t6,lf[63]);
t8=t5;
f_2654(t8,C_dup2(t2,t6));}}

/* k2639 */
static void C_ccall f_2641(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2641,2,t0,t1);}
if(C_truep(C_i_zerop(t1))){
/* posix-common.scm:348: posix-error */
t2=lf[2];
f_2245(6,t2,((C_word*)t0)[2],lf[15],lf[58],lf[60],((C_word*)t0)[3]);}
else{
t2=C_C_fileno(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2624,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posix-common.scm:346: posix-error */
t4=lf[2];
f_2245(6,t4,t3,lf[10],lf[58],lf[61],((C_word*)t0)[3]);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}}

/* k5018 in doloop1139 in build-exec-argvec in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5020(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[4])[1];
f_5001(t5,((C_word*)t0)[5],t3,t4);}

/* k4535 in k4543 in change-file-mode in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4537(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1088: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[2],lf[10],lf[266],lf[267],((C_word*)t0)[3],((C_word*)t0)[4]);}

/* k2877 in k2867 in k2855 in loop in k2827 in k2823 in k2820 in k2817 in k2802 in directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2879(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2879,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* doloop1139 in build-exec-argvec in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_5001(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5001,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
/* posixwin.scm:1268: argvec-setter */
t4=((C_word*)t0)[2];
((C_proc5)C_fast_retrieve_proc(t4))(5,t4,t1,t3,C_SCHEME_FALSE,C_fix(0));}
else{
t4=C_i_car(t2);
t5=C_i_check_string_2(t4,((C_word*)t0)[3]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5020,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t7=C_block_size(t4);
/* posixwin.scm:1271: argvec-setter */
t8=((C_word*)t0)[2];
((C_proc5)C_fast_retrieve_proc(t8))(5,t8,t6,t3,t4,t7);}}

/* %process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_5433(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5433,NULL,7,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5435,a[2]=t2,a[3]=((C_word)li137),tmp=(C_word)a,a+=4,tmp);
t12=C_i_check_string_2(((C_word*)t8)[1],t2);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5476,a[2]=t2,a[3]=t8,a[4]=t9,a[5]=t6,a[6]=t3,a[7]=t10,a[8]=t1,a[9]=t11,tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t9)[1])){
/* posixwin.scm:1376: chkstrlst */
t14=t11;
f_5435(t14,t13,((C_word*)t9)[1]);}
else{
t14=C_set_block_item(t10,0,C_SCHEME_TRUE);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5511,a[2]=t9,a[3]=t8,a[4]=t13,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1379: ##sys#shell-command-arguments */
t16=*((C_word*)lf[312]+1);
((C_proc3)(void*)(*((C_word*)t16+1)))(3,t16,t15,((C_word*)t8)[1]);}}

/* chkstrlst in %process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_5435(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5435,NULL,3,t0,t1,t2);}
t3=C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5440,a[2]=((C_word*)t0)[2],a[3]=((C_word)li135),tmp=(C_word)a,a+=4,tmp);
t5=t2;
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5449,a[2]=t4,a[3]=((C_word)li136),tmp=(C_word)a,a+=4,tmp);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,f_5449(t6,t5));}

/* mode in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_4596(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4596,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4604,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=C_u_i_car(t6);
t8=C_eqp(t7,lf[44]);
if(C_truep(t8)){
t9=t2;
if(C_truep(t9)){
/* posixwin.scm:1122: ##sys#error */
t10=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t5,lf[271],t7);}
else{
/* posixwin.scm:1118: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[272],t4);}}
else{
/* posixwin.scm:1123: ##sys#error */
t9=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t9+1)))(4,t9,t5,lf[273],t7);}}
else{
if(C_truep(t2)){
/* posixwin.scm:1118: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[274],t4);}
else{
/* posixwin.scm:1118: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[275],t4);}}}

/* k4209 in open-input-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4211(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4211,2,t0,t1);}
t2=open_text_input_pipe(&a,1,t1);
/* posixwin.scm:910: check */
f_4172(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* k5420 in process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5422(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1347: string-intersperse */
t2=*((C_word*)lf[319]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-execute-access? in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4587(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4587,3,t0,t1,t2);}
/* posixwin.scm:1102: check */
f_4551(t1,t2,C_fix((C_word)2),lf[270]);}

/* k4202 in open-input-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4204(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:910: check */
f_4172(((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_TRUE,t1);}

/* file-write-access? in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4581(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4581,3,t0,t1,t2);}
/* posixwin.scm:1101: check */
f_4551(t1,t2,C_fix((C_word)4),lf[269]);}

/* a5489 in k5477 in k5474 in %process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5490(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_5490,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixwin.scm:1384: values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixwin.scm:1385: values */
C_values(5,0,t1,t2,t3,t4);}}

/* loop in k2827 in k2823 in k2820 in k2817 in k2802 in directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_2843(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2843,NULL,2,t0,t1);}
t2=C_readdir(((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_null_pointerp(((C_word*)t0)[3]))){
t3=C_closedir(((C_word*)t0)[2]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=C_block_size(((C_word*)t0)[4]);
t4=C_foundfile(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2857,a[2]=t4,a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:419: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[67]+1)))(5,*((C_word*)lf[67]+1),t5,((C_word*)t0)[4],C_fix(0),t4);}}

/* a5483 in k5477 in k5474 in %process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5484(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5484,2,t0,t1);}
/* posixwin.scm:1382: ##sys#process */
t2=*((C_word*)lf[315]+1);
((C_proc10)(void*)(*((C_word*)t2+1)))(10,t2,t1,((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[5],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[6],((C_word*)((C_word*)t0)[7])[1]);}

/* current-directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2674(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_2674r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2674r(t0,t1,t2);}}

static void C_ccall f_2674r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
if(C_truep(t4)){
/* posix-common.scm:367: change-directory */
t5=*((C_word*)lf[66]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,t4);}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2687,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[69]+1)))(4,*((C_word*)lf[69]+1),t5,C_fix(1024),C_make_character(32));}}

/* unmap-file-from-memory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5816(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_5816r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5816r(t0,t1,t2,t3);}}

static void C_ccall f_5816r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=C_i_check_structure_2(t2,lf[340],lf[344]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5823,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=t5;
f_5823(t7,C_u_i_car(t6));}
else{
t6=t5;
f_5823(t6,C_slot(t2,C_fix(2)));}}

/* seconds->local-time in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3318(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3318r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3318r(t0,t1,t2);}}

static void C_ccall f_3318r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3322,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:515: current-seconds */
t4=*((C_word*)lf[106]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=C_i_car(t2);
t5=C_i_check_number_2(t4,lf[104]);
/* posix-common.scm:517: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[105]+1)))(4,*((C_word*)lf[105]+1),t1,t4,C_SCHEME_FALSE);}}

/* g1330 in chkstrlst in %process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static C_word C_fcall f_5440(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_stack_overflow_check;
return(C_i_check_string_2(t1,((C_word*)t0)[2]));}

/* for-each-loop1329 in chkstrlst in %process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static C_word C_fcall f_5449(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_overflow_check;
loop:
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=f_5440(((C_word*)t0)[2],t2);
t4=C_slot(t1,C_fix(1));
t7=t4;
t1=t7;
goto loop;}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* k2688 in k2685 in current-directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2690(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:373: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[67]+1)))(5,*((C_word*)lf[67]+1),((C_word*)t0)[3],((C_word*)t0)[4],C_fix(0),((C_word*)t0)[2]);}
else{
/* posix-common.scm:374: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[10],lf[65],lf[68]);}}

/* scan in k3560 in loop in get-environment-variables in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_3570(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3570,NULL,3,t0,t1,t2);}
t3=C_subchar(((C_word*)t0)[2],t2);
if(C_truep(C_i_char_equalp(C_make_character(61),t3))){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3596,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:580: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[67]+1)))(5,*((C_word*)lf[67]+1),t4,((C_word*)t0)[2],C_fix(0),t2);}
else{
t4=C_fixnum_plus(t2,C_fix(1));
/* posix-common.scm:583: scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k2685 in current-directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2687(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2687,2,t0,t1);}
t2=t1;
t3=C_curdir(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2690,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:371: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t4);}

/* k5821 in unmap-file-from-memory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_5823(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=(C_truep(t2)?C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t4=C_i_foreign_integer_argumentp(t1);
t5=stub1463(C_SCHEME_UNDEFINED,t3,t4);
t6=C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=C_SCHEME_UNDEFINED;
t8=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}
else{
/* posixwin.scm:1591: posix-error */
t7=lf[2];
f_2245(7,t7,((C_word*)t0)[3],lf[10],lf[344],lf[345],((C_word*)t0)[2],t1);}}

/* k3560 in loop in get-environment-variables in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3562(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3562,2,t0,t1);}
t2=t1;
if(C_truep(t2)){
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3570,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t4,a[6]=((C_word)li59),tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_3570(t6,((C_word*)t0)[4],C_fix(0));}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}}

/* k3594 in scan in k3560 in loop in get-environment-variables in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3596(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3596,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3600,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=C_fixnum_plus(((C_word*)t0)[5],C_fix(1));
t5=C_block_size(((C_word*)t0)[6]);
/* posix-common.scm:581: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[67]+1)))(5,*((C_word*)lf[67]+1),t3,((C_word*)t0)[6],t4,t5);}

/* k5400 in k5396 in k5392 in k5388 in k5344 in process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5402(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5402,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5406,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
t4=(C_truep(((C_word*)t0)[8])?C_fix(0):C_fix(1));
t5=(C_truep(((C_word*)t0)[9])?C_fix(0):C_fix(2));
if(C_truep(((C_word*)t0)[10])){
/* posixwin.scm:1354: + */
C_plus(5,0,t3,t4,t5,C_fix(0));}
else{
/* posixwin.scm:1354: + */
C_plus(5,0,t3,t4,t5,C_fix(4));}}

/* k3586 in k3598 in k3594 in scan in k3560 in loop in get-environment-variables in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3588(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3588,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* k5404 in k5400 in k5396 in k5392 in k5388 in k5344 in process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5406(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5406,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[6];
t7=((C_word*)t0)[7];
t8=((C_word*)t0)[8];
t9=t1;
t10=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5281,a[2]=t5,a[3]=t6,a[4]=t7,a[5]=t8,a[6]=t9,a[7]=t2,a[8]=t4,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t3)){
t11=C_i_foreign_string_argumentp(t3);
/* posixwin.scm:1341: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t10,t11);}
else{
t11=t10;
f_5281(2,t11,C_SCHEME_FALSE);}}

/* k3341 in seconds->utc-time in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3343(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_check_number_2(t1,lf[107]);
/* posix-common.scm:521: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[105]+1)))(4,*((C_word*)lf[105]+1),((C_word*)t0)[2],t1,C_SCHEME_TRUE);}

/* parent-process-id in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5984(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5984,2,t0,t1);}
/* posixwin.scm:1628: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[369],lf[0]);}

/* k5474 in %process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5476(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5476,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5479,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixwin.scm:1381: chkstrlst */
t3=((C_word*)t0)[9];
f_5435(t3,t2,((C_word*)t0)[5]);}
else{
t3=t2;
f_5479(2,t3,C_SCHEME_UNDEFINED);}}

/* unsetenv in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3532(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3532,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[118]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3540,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:569: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t4,t2,lf[118]);}

/* k3528 in k3524 in setenv in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3530(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_setenv(((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* k5477 in k5474 in %process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5479(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5479,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5484,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word)li138),tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5490,a[2]=((C_word*)t0)[6],a[3]=((C_word)li139),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1382: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[8],t2,t3);}

/* process-group-id in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5996(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5996,2,t0,t1);}
/* posixwin.scm:1630: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[371],lf[0]);}

/* k3372 in seconds->string in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3374(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3374,2,t0,t1);}
t2=t1;
t3=C_i_check_number_2(t2,lf[108]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3380,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_integer_argumentp(t2);
t7=stub487(t5,t6);
/* posix-common.scm:524: ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,t7,C_fix(0));}

/* seconds->string in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3370(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3370r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3370r(t0,t1,t2);}}

static void C_ccall f_3370r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3374,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:525: current-seconds */
t4=*((C_word*)lf[106]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=t3;
f_3374(2,t4,C_i_car(t2));}}

/* loop in get-environment-variables in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_3558(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3558,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3562,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub566(t5,t6);
/* posix-common.scm:573: ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* get-environment-variables in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3552(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3552,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3558,a[2]=t3,a[3]=((C_word)li60),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3558(t5,t1,C_fix(0));}

/* k3538 in unsetenv in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3540(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_unsetenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* k3111 in k3184 in k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3113(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:474: action */
t2=((C_word*)t0)[2];
((C_proc4)C_fast_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:474: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3069(t3,((C_word*)t0)[7],((C_word*)t0)[8],t2);}}

/* k3108 in k3184 in k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3110(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:474: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3069(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k3378 in k3372 in seconds->string in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3380(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posix-common.scm:529: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[67]+1)))(5,*((C_word*)lf[67]+1),((C_word*)t0)[2],t1,C_fix(0),t3);}
else{
/* posix-common.scm:530: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[108],lf[109],((C_word*)t0)[3]);}}

/* file-select in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5942(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5942,2,t0,t1);}
/* posixwin.scm:1621: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[362],lf[0]);}

/* file-close in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3777(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3777,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[155]);
t4=C_close(t2);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3790,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:754: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t5);}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}

/* k3769 in k3740 in file-open in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3771(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:744: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[153]);}

/* group-information in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5972(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5972,2,t0,t1);}
/* posixwin.scm:1626: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[367],lf[0]);}

/* file-test-lock in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5948(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5948,2,t0,t1);}
/* posixwin.scm:1622: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[363],lf[0]);}

/* file-unlock in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5960(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5960,2,t0,t1);}
/* posixwin.scm:1624: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[365],lf[0]);}

/* setenv in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3515(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3515,4,t0,t1,t2,t3);}
t4=C_i_check_string_2(t2,lf[117]);
t5=C_i_check_string_2(t3,lf[117]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3526,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:564: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t6,t2,lf[117]);}

/* initialize-groups in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5978(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5978,2,t0,t1);}
/* posixwin.scm:1627: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[368],lf[0]);}

/* process-fork in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5990(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5990,2,t0,t1);}
/* posixwin.scm:1629: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[370],lf[0]);}

/* k3505 in k3458 in time->string in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3507(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3507,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=C_a_i_bytevector(&a,1,C_fix(3));
if(C_truep(t1)){
t4=C_i_foreign_block_argumentp(t1);
t5=stub516(t3,t2,t4);
/* posix-common.scm:542: ##sys#peek-c-string */
t6=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,((C_word*)t0)[3],t5,C_fix(0));}
else{
t4=stub516(t3,t2,C_SCHEME_FALSE);
/* posix-common.scm:542: ##sys#peek-c-string */
t5=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,((C_word*)t0)[3],t4,C_fix(0));}}

/* get-groups in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5966(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5966,2,t0,t1);}
/* posixwin.scm:1625: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[366],lf[0]);}

/* k3970 in k3958 in k3949 in set-file-position! in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3972(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[55]);
if(C_truep(t3)){
t4=C_fseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t5=((C_word*)t0)[5];
f_3966(2,t5,t4);}
else{
t4=((C_word*)t0)[5];
f_3966(2,t4,C_SCHEME_FALSE);}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=C_lseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=((C_word*)t0)[5];
f_3966(2,t3,t2);}
else{
/* posixwin.scm:832: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[5],lf[15],lf[168],lf[170],((C_word*)t0)[2]);}}}

/* current-effective-user-name in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5906(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5906,2,t0,t1);}
/* posixwin.scm:1615: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[356],lf[0]);}

/* current-effective-user-id in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5900(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5900,2,t0,t1);}
/* posixwin.scm:1614: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[355],lf[0]);}

/* current-user-id in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5918(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5918,2,t0,t1);}
/* posixwin.scm:1617: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[358],lf[0]);}

/* change-directory* in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5864(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5864,2,t0,t1);}
/* posixwin.scm:1608: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[348],lf[0]);}

/* k3964 in k3958 in k3949 in set-file-position! in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3966(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixwin.scm:833: posix-error */
t2=lf[2];
f_2245(7,t2,((C_word*)t0)[2],lf[10],lf[168],lf[169],((C_word*)t0)[3],((C_word*)t0)[4]);}}

/* k3958 in k3949 in set-file-position! in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3960(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3960,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3966,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3972,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:826: port? */
t4=*((C_word*)lf[171]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[3]);}

/* file-lock/blocking in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5936(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5936,2,t0,t1);}
/* posixwin.scm:1620: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[361],lf[0]);}

/* file-lock in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5930(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5930,2,t0,t1);}
/* posixwin.scm:1619: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[360],lf[0]);}

/* k3175 in k3120 in k3184 in k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 in ... */
static void C_ccall f_3177(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:480: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3069(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k3908 in k3885 in file-mkstemp in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3910(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:791: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[10],lf[163],lf[164],((C_word*)t0)[3]);}

/* symbolic-link? in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3918(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3918,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[35]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* file-link in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5924(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5924,2,t0,t1);}
/* posixwin.scm:1618: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[359],lf[0]);}

/* k3756 in k3753 in k3740 in file-open in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3758(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k3753 in k3740 in file-open in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3755(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3755,2,t0,t1);}
t2=C_open(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3758,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3764,a[2]=t3,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:746: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t5);}
else{
t5=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}}

/* k3159 in a3138 in k3120 in k3184 in k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in ... */
static void C_ccall f_3161(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:478: glob */
t2=*((C_word*)lf[79]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* user-information in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6086(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6086,2,t0,t1);}
/* posixwin.scm:1645: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[386],lf[0]);}

/* terminal-name in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6080(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6080,2,t0,t1);}
/* posixwin.scm:1644: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[385],lf[0]);}

/* a3166 in k3120 in k3184 in k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 in ... */
static void C_ccall f_3167(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3167,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate2(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[4])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k3898 in k3891 in k3885 in file-mkstemp in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3900(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:792: values */
C_values(4,0,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* memory-mapped-file-pointer in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5849(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5849,3,t0,t1,t2);}
t3=C_i_check_structure_2(t2,lf[340],lf[346]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_slot(t2,C_fix(1)));}

/* file-truncate in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5954(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5954,2,t0,t1);}
/* posixwin.scm:1623: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[364],lf[0]);}

/* k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3193(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3193,2,t0,t1);}
if(C_truep((C_truep(C_i_equalp(t1,lf[87]))?C_SCHEME_TRUE:(C_truep(C_i_equalp(t1,lf[88]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posix-common.scm:472: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3069(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_3186,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[12],tmp=(C_word)a,a+=13,tmp);
/* posix-common.scm:473: symbolic-link? */
t3=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[8]);}}

/* string->time in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6098(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6098,2,t0,t1);}
/* posixwin.scm:1647: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[388],lf[0]);}

/* utc-time->seconds in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6092(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6092,2,t0,t1);}
/* posixwin.scm:1646: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[387],lf[0]);}

/* k3197 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3199(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3199,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3206,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:481: action */
t3=((C_word*)t0)[5];
((C_proc4)C_fast_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[6],((C_word*)t0)[7]);}
else{
/* posix-common.scm:482: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3069(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[7]);}}

/* k3184 in k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3186(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3186,2,t0,t1);}
t2=(C_truep(t1)?C_i_not(((C_word*)t0)[2]):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3110,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3113,a[2]=((C_word*)t0)[6],a[3]=t3,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:474: pproc */
t5=((C_word*)t0)[9];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[7]);}
else{
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3122,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[11],tmp=(C_word)a,a+=11,tmp);
/* posix-common.scm:475: lproc */
t4=((C_word*)t0)[12];
((C_proc3)C_fast_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[7]);}}

/* k3178 in k3120 in k3184 in k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 in ... */
static void C_ccall f_3180(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:480: action */
t2=((C_word*)t0)[2];
((C_proc4)C_fast_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:480: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3069(t3,((C_word*)t0)[7],((C_word*)t0)[8],t2);}}

/* seconds->utc-time in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3339(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3339r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3339r(t0,t1,t2);}}

static void C_ccall f_3339r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3343,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:519: current-seconds */
t4=*((C_word*)lf[106]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=C_i_car(t2);
t5=C_i_check_number_2(t4,lf[107]);
/* posix-common.scm:521: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[105]+1)))(4,*((C_word*)lf[105]+1),t1,t4,C_SCHEME_TRUE);}}

/* k6210 in k6233 in a6201 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6212(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,stub120(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[3]));}

/* k3130 in k3120 in k3184 in k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 in ... */
static void C_ccall f_3132(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:476: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3069(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* a3133 in k3120 in k3184 in k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 in ... */
static void C_ccall f_3134(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3134,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate2(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[4])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* a3138 in k3120 in k3184 in k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 in ... */
static void C_ccall f_3139(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3139,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3147,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3161,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
if(C_truep(((C_word*)t0)[7])){
/* posix-common.scm:478: make-pathname */
t4=*((C_word*)lf[81]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[4],lf[89]);}
else{
/* posix-common.scm:478: make-pathname */
t4=*((C_word*)lf[81]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[4],lf[90]);}}

/* k4709 in port->fileno in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4711(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4711,2,t0,t1);}
if(C_truep(C_i_zerop(t1))){
/* posixwin.scm:1152: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[15],lf[58],lf[278],((C_word*)t0)[3]);}
else{
t2=C_C_fileno(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4691,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4697,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1149: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t4);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}}

/* duplicate-fileno in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4713(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_4713r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4713r(t0,t1,t2,t3);}}

static void C_ccall f_4713r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=C_i_check_exact_2(t2,*((C_word*)lf[63]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4720,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t6=t5;
f_4720(t6,C_dup(t2));}
else{
t6=C_i_car(t3);
t7=C_i_check_exact_2(t6,lf[63]);
t8=t5;
f_4720(t8,C_dup2(t2,t6));}}

/* k3320 in seconds->local-time in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3322(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_i_check_number_2(t1,lf[104]);
/* posix-common.scm:517: ##sys#decode-seconds */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[105]+1)))(4,*((C_word*)lf[105]+1),((C_word*)t0)[2],t1,C_SCHEME_FALSE);}

/* k6220 in a6201 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6222(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posix-common.scm:253: posix-error */
t2=lf[2];
f_2245(7,t2,((C_word*)t0)[2],lf[10],lf[402],lf[403],((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* file-read in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3796(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3796r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3796r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3796r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(5);
t5=C_i_check_exact_2(t2,lf[157]);
t6=C_i_check_exact_2(t3,lf[157]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3806,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t8=t4;
t9=t7;
f_3806(2,t9,C_u_i_car(t8));}
else{
t8=t3;
/* ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[69]+1)))(4,*((C_word*)lf[69]+1),t7,t8,C_make_character(32));}}

/* k3120 in k3184 in k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3122(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3122,2,t0,t1);}
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3132,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3134,a[2]=t6,a[3]=((C_word*)t0)[2],a[4]=t4,a[5]=((C_word)li35),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3139,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word)li36),tmp=(C_word)a,a+=9,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3167,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=((C_word)li37),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:477: ##sys#dynamic-wind */
t11=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3177,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3180,a[2]=((C_word*)t0)[6],a[3]=t2,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:480: pproc */
t4=((C_word*)t0)[9];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[7]);}}

/* set-signal-mask! in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6044(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6044,2,t0,t1);}
/* posixwin.scm:1638: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[379],lf[0]);}

/* k3788 in file-close in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3790(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:755: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[10],lf[155],lf[156],((C_word*)t0)[3]);}

/* file-size in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2353(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2353,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2357,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:262: ##sys#stat */
f_2263(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[25]);}

/* k2349 in file-permissions in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2351(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* k2355 in file-size in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2357(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2357,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_double_to_num(&a,C_statbuf.st_size));}

/* file-type in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2359(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3r,(void*)f_2359r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2359r(t0,t1,t2,t3);}}

static void C_ccall f_2359r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a=C_alloc(3);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_TRUE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2378,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:265: ##sys#stat */
f_2263(t12,t2,t5,t9,lf[26]);}

/* k6233 in a6201 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6235(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6235,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6212,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t5=C_i_foreign_string_argumentp(t1);
/* posix-common.scm:250: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t4,t5);}
else{
t5=t2;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,stub120(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t3));}}

/* k3149 in k3145 in a3138 in k3120 in k3184 in k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in ... */
static void C_ccall f_3151(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:478: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3069(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k3152 in k3145 in a3138 in k3120 in k3184 in k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in ... */
static void C_ccall f_3154(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:479: action */
t2=((C_word*)t0)[2];
((C_proc4)C_fast_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:478: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3069(t3,((C_word*)t0)[7],((C_word*)t0)[8],t2);}}

/* k3740 in file-open in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_3742(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3742,NULL,2,t0,t1);}
t2=t1;
t3=C_i_check_string_2(((C_word*)t0)[2],lf[153]);
t4=C_i_check_exact_2(((C_word*)t0)[3],lf[153]);
t5=C_i_check_exact_2(t2,lf[153]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3755,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3771,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:744: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t7,((C_word*)t0)[2]);}

/* signal-mask in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6056(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6056,2,t0,t1);}
/* posixwin.scm:1640: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[381],lf[0]);}

/* set-user-id! in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6050(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6050,2,t0,t1);}
/* posixwin.scm:1639: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[380],lf[0]);}

/* file-owner in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2341(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2341,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2345,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:260: ##sys#stat */
f_2263(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[23]);}

/* file-permissions in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2347(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2347,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2351,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:261: ##sys#stat */
f_2263(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[24]);}

/* k2343 in file-owner in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2345(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* k4727 in k4718 in duplicate-fileno in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4729(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1164: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[10],lf[63],lf[280],((C_word*)t0)[3]);}

/* signal-mask! in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6062(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6062,2,t0,t1);}
/* posixwin.scm:1641: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[382],lf[0]);}

/* file-open in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3738(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3738r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3738r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3738r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3742,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_3742(t7,C_u_i_car(t6));}
else{
t6=t5;
f_3742(t6,((C_word*)t0)[2]);}}

/* k3145 in a3138 in k3120 in k3184 in k3191 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in ... */
static void C_ccall f_3147(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3147,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3151,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3154,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[2],a[7]=((C_word*)t0)[3],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:479: pproc */
t5=((C_word*)t0)[7];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[5]);}

/* signal-masked? in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6068(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6068,2,t0,t1);}
/* posixwin.scm:1642: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[383],lf[0]);}

/* k4718 in duplicate-fileno in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_4720(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4720,NULL,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4723,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4729,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1163: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t4);}
else{
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* k4721 in k4718 in duplicate-fileno in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4723(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k2376 in file-type in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2378(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_stat_type);
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFREG)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[27]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFLNK)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[28]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFDIR)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[29]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFCHR)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[30]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFBLK)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[31]);}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFIFO)))){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,lf[32]);}
else{
t3=C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFSOCK));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?lf[33]:lf[27]));}}}}}}}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k3524 in setenv in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3526(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3526,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3530,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:564: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t3,((C_word*)t0)[3],lf[117]);}

/* signal-unmask! in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6074(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6074,2,t0,t1);}
/* posixwin.scm:1643: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[384],lf[0]);}

/* k3762 in k3753 in k3740 in file-open in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3764(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:747: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[2],lf[10],lf[153],lf[154],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}

/* current-effective-group-id in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5894(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5894,2,t0,t1);}
/* posixwin.scm:1613: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[354],lf[0]);}

/* process-signal in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6002(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6002,2,t0,t1);}
/* posixwin.scm:1631: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[372],lf[0]);}

/* read-symbolic-link in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6008(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6008,2,t0,t1);}
/* posixwin.scm:1632: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[373],lf[0]);}

/* change-file-owner in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5870(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5870,2,t0,t1);}
/* posixwin.scm:1609: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[350],lf[0]);}

/* set-alarm! in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6014(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6014,2,t0,t1);}
/* posixwin.scm:1633: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[374],lf[0]);}

/* create-fifo in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5876(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5876,2,t0,t1);}
/* posixwin.scm:1610: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[351],lf[0]);}

/* k6198 in a6195 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6200(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6200,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* a6201 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6202(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6202,4,t0,t1,t2,t3);}
t4=C_i_check_number_2(t3,lf[402]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6222,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6235,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:251: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t6,t2);}

/* set-group-id! in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6020(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6020,2,t0,t1);}
/* posixwin.scm:1634: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[375],lf[0]);}

/* set-groups! in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6026(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6026,2,t0,t1);}
/* posixwin.scm:1635: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[376],lf[0]);}

/* k2331 in file-access-time in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2333(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2333,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-change-time in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2335(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2335,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2339,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:259: ##sys#stat */
f_2263(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[22]);}

/* k2337 in file-change-time in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2339(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2339,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* set-process-group-id! in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6032(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6032,2,t0,t1);}
/* posixwin.scm:1636: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[377],lf[0]);}

/* set-root-directory! in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_6038(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6038,2,t0,t1);}
/* posixwin.scm:1637: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[378],lf[0]);}

/* k3949 in set-file-position! in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_3951(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3951,NULL,2,t0,t1);}
t2=t1;
t3=C_i_check_exact_2(((C_word*)t0)[2],lf[168]);
t4=C_i_check_exact_2(t2,lf[168]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3960,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t6=((C_word*)t0)[2];
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
/* posixwin.scm:825: ##sys#signal-hook */
t7=*((C_word*)lf[3]+1);
((C_proc7)(void*)(*((C_word*)t7+1)))(7,t7,t5,lf[172],lf[168],lf[173],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t7=t5;
f_3960(2,t7,C_SCHEME_UNDEFINED);}}

/* k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2327(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word ab[89],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2327,2,t0,t1);}
t2=C_mutate2((C_word*)lf[20]+1 /* (set! file-modification-time ...) */,t1);
t3=C_mutate2((C_word*)lf[21]+1 /* (set! file-access-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2329,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[22]+1 /* (set! file-change-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2335,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[23]+1 /* (set! file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2341,a[2]=((C_word)li5),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[24]+1 /* (set! file-permissions ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2347,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[25]+1 /* (set! file-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2353,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate2((C_word*)lf[26]+1 /* (set! file-type ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2359,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate2((C_word*)lf[34]+1 /* (set! regular-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2446,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate2((C_word*)lf[35]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2456,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate2((C_word*)lf[36]+1 /* (set! block-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2466,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[37]+1 /* (set! character-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2476,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[38]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2486,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate2((C_word*)lf[39]+1 /* (set! socket? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2496,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[40]+1 /* (set! directory? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2506,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate2((C_word*)lf[41]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)STDIN_FILENO));
t17=C_mutate2((C_word*)lf[42]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)STDOUT_FILENO));
t18=C_mutate2((C_word*)lf[43]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)STDERR_FILENO));
t19=C_SCHEME_UNDEFINED;
t20=(*a=C_VECTOR_TYPE|1,a[1]=t19,tmp=(C_word)a,a+=2,tmp);
t21=C_SCHEME_UNDEFINED;
t22=(*a=C_VECTOR_TYPE|1,a[1]=t21,tmp=(C_word)a,a+=2,tmp);
t23=C_set_block_item(t20,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2519,a[2]=((C_word)li16),tmp=(C_word)a,a+=3,tmp));
t24=C_set_block_item(t22,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2556,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t25=C_mutate2((C_word*)lf[56]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2571,a[2]=t22,a[3]=t20,a[4]=((C_word)li18),tmp=(C_word)a,a+=5,tmp));
t26=C_mutate2((C_word*)lf[57]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2585,a[2]=t22,a[3]=t20,a[4]=((C_word)li19),tmp=(C_word)a,a+=5,tmp));
t27=C_mutate2((C_word*)lf[58]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2599,a[2]=((C_word)li20),tmp=(C_word)a,a+=3,tmp));
t28=C_mutate2((C_word*)lf[63]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2647,a[2]=((C_word)li21),tmp=(C_word)a,a+=3,tmp));
t29=C_mutate2((C_word*)lf[65]+1 /* (set! current-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2674,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t30=C_mutate2((C_word*)lf[70]+1 /* (set! delete-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2708,a[2]=((C_word)li26),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate2((C_word*)lf[29]+1 /* (set! directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2800,a[2]=((C_word)li28),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate2((C_word*)lf[79]+1 /* (set! glob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2943,a[2]=((C_word)li34),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate2((C_word*)lf[74]+1 /* (set! find-files ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3246,a[2]=((C_word)li50),tmp=(C_word)a,a+=3,tmp));
t34=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3297,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t35=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6165,a[2]=((C_word)li195),tmp=(C_word)a,a+=3,tmp);
t36=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6190,a[2]=((C_word)li196),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:496: getter-with-setter */
t37=*((C_word*)lf[399]+1);
((C_proc5)(void*)(*((C_word*)t37+1)))(5,t37,t34,t35,t36,lf[401]);}

/* file-access-time in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2329(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2329,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2333,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:258: ##sys#stat */
f_2263(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);}

/* memory-mapped-file? in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5858(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5858,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_i_structurep(t2,lf[340]));}

/* rmdir in delete-directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_2714(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2714,NULL,2,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2718,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:381: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t3,t2);}

/* k2716 in rmdir in delete-directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2718(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_rmdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
/* posix-common.scm:383: posix-error */
t4=lf[2];
f_2245(6,t4,((C_word*)t0)[2],lf[10],lf[70],lf[71],((C_word*)t0)[3]);}}

/* set-file-position! in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3947(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3947r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3947r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3947r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3951,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_3951(t7,C_u_i_car(t6));}
else{
t6=t5;
f_3951(t6,C_fix((C_word)SEEK_SET));}}

/* create-session in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5882(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5882,2,t0,t1);}
/* posixwin.scm:1611: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[352],lf[0]);}

/* create-symbolic-link in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5888(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5888,2,t0,t1);}
/* posixwin.scm:1612: error */
t2=*((C_word*)lf[349]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[353],lf[0]);}

/* delete-directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2708(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_2708r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2708r(t0,t1,t2,t3);}}

static void C_ccall f_2708r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2714,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp);
t8=C_i_check_string_2(t2,lf[70]);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2734,a[2]=t6,a[3]=t7,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:385: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t9,t2);}

/* k4602 in mode in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4604(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1118: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* k2512 in directory? in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2514(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[29],t1));}

/* k4174 in check in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4176(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4176,2,t0,t1);}
if(C_truep(C_null_pointerp(((C_word*)t0)[2]))){
/* posixwin.scm:902: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[10],lf[182],((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4188,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:903: ##sys#make-port */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[52]+1)))(6,*((C_word*)lf[52]+1),t2,((C_word*)t0)[5],*((C_word*)lf[53]+1),lf[183],lf[55]);}}

/* mode in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_2519(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2519,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2527,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=C_u_i_car(t6);
t8=C_eqp(t7,lf[44]);
if(C_truep(t8)){
t9=t2;
if(C_truep(t9)){
/* posix-common.scm:314: ##sys#error */
t10=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t5,lf[46],t7);}
else{
/* posix-common.scm:310: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[47],t4);}}
else{
/* posix-common.scm:315: ##sys#error */
t9=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t9+1)))(4,t9,t5,lf[48],t7);}}
else{
if(C_truep(t2)){
/* posix-common.scm:310: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[49],t4);}
else{
/* posix-common.scm:310: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t1,lf[50],t4);}}}

/* check in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_4172(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4172,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4176,a[2]=t4,a[3]=t1,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:900: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t5);}

/* k4150 in change-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4152(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:886: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,lf[66]);}

/* k4142 in k4133 in change-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4144(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:889: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[10],lf[66],lf[181],((C_word*)t0)[3]);}

/* k4133 in change-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4135(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4135,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4138,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_chdir(t1);
t4=C_eqp(C_fix(0),t3);
if(C_truep(t4)){
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,((C_word*)t0)[3]);}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4144,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:888: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t5);}}

/* k4136 in k4133 in change-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4138(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* change-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4128(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4128,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[66]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4135,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4152,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:886: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t5,t2);}

/* directory? in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2506(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2506,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2514,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:295: file-type */
t4=*((C_word*)lf[26]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);}

/* k2502 */
static void C_ccall f_2504(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_eqp(lf[33],t1));}

/* local-timezone-abbreviation in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4743(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4743,2,t0,t1);}
t2=C_a_i_bytevector(&a,1,C_fix(3));
t3=stub1057(t2);
/* posixwin.scm:1171: ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t3,C_fix(0));}

/* k4332 in call-with-output-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4334(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4334,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4339,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word)li90),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4345,a[2]=t2,a[3]=((C_word)li91),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:955: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],t3,t4);}

/* a4338 in k4332 in call-with-output-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4339(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4339,2,t0,t1);}
/* posixwin.scm:956: proc */
t2=((C_word*)t0)[2];
((C_proc3)C_fast_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[3]);}

/* call-with-output-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4330(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_4330r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4330r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4330r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4334,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[188]+1),t2,t4);}

/* k2525 in mode in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2527(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:310: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),((C_word*)t0)[2],t1,((C_word*)t0)[3]);}

/* k4323 in a4320 in k4308 in call-with-input-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4325(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* a4320 in k4308 in call-with-input-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4321(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4321r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4321r(t0,t1,t2);}}

static void C_ccall f_4321r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4325,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:949: close-input-pipe */
t4=*((C_word*)lf[189]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* a4396 in k4390 in with-output-to-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4397(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4397,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[198]+1));
t3=C_mutate2((C_word*)lf[198]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k4390 in with-output-to-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4392(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4392,2,t0,t1);}
t2=t1;
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4397,a[2]=t6,a[3]=t4,a[4]=((C_word)li98),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4402,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li100),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4417,a[2]=t4,a[3]=t6,a[4]=((C_word)li101),tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:972: ##sys#dynamic-wind */
t10=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t10+1)))(5,t10,((C_word*)t0)[3],t7,t8,t9);}

/* with-output-to-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4388(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_4388r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4388r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4388r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4392,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[188]+1),t2,t4);}

/* a4382 in k4356 in with-input-from-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4383(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4383,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[196]+1));
t3=C_mutate2((C_word*)lf[196]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k2755 in k2749 in g271 in k2738 in k2732 in delete-directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2757(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:392: g281 */
f_2714(((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=*((C_word*)lf[72]+1);
t3=*((C_word*)lf[72]+1);
/* posix-common.scm:392: g281 */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[72]+1)))(3,*((C_word*)lf[72]+1),((C_word*)t0)[3],((C_word*)t0)[4]);}}

/* k2749 in g271 in k2738 in k2732 in delete-directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2751(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2751,2,t0,t1);}
if(C_truep(t1)){
t2=*((C_word*)lf[72]+1);
t3=*((C_word*)lf[72]+1);
/* posix-common.scm:392: g281 */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[72]+1)))(3,*((C_word*)lf[72]+1),((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2757,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:394: directory? */
t3=*((C_word*)lf[40]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}}

/* k2312 in file-stat in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2314(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2314,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_a_double_to_num(&a,C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),*((C_word*)lf[18]+1),*((C_word*)lf[19]+1)));}

/* g271 in k2738 in k2732 in delete-directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_2741(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2741,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2751,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:393: symbolic-link? */
t4=*((C_word*)lf[35]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k2738 in k2732 in delete-directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2740(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2740,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2741,a[2]=((C_word*)t0)[2],a[3]=((C_word)li24),tmp=(C_word)a,a+=4,tmp);
t3=C_i_check_list_2(t1,lf[73]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2763,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2768,a[2]=t6,a[3]=t2,a[4]=((C_word)li25),tmp=(C_word)a,a+=5,tmp));
t8=((C_word*)t6)[1];
f_2768(t8,t4,t1);}

/* file-stat in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2307(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3r,(void*)f_2307r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2307r(t0,t1,t2,t3);}}

static void C_ccall f_2307r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2314,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:237: ##sys#stat */
f_2263(t6,t2,t5,C_SCHEME_TRUE,lf[17]);}

/* k2300 in stat in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2302(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:221: ##sys#platform-fixup-pathname */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[13]+1)))(3,*((C_word*)lf[13]+1),((C_word*)t0)[2],t1);}

/* with-input-from-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4354(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_4354r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4354r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4354r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4358,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[184]+1),t2,t4);}

/* k4356 in with-input-from-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4358(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4358,2,t0,t1);}
t2=t1;
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4363,a[2]=t6,a[3]=t4,a[4]=((C_word)li93),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4368,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li95),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4383,a[2]=t4,a[3]=t6,a[4]=((C_word)li96),tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:962: ##sys#dynamic-wind */
t10=*((C_word*)lf[91]+1);
((C_proc5)(void*)(*((C_word*)t10+1)))(5,t10,((C_word*)t0)[3],t7,t8,t9);}

/* for-each-loop270 in k2738 in k2732 in delete-directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_2768(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2768,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2778,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posix-common.scm:387: g271 */
t5=((C_word*)t0)[3];
f_2741(t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k2761 in k2738 in k2732 in delete-directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2763(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:398: rmdir */
f_2714(((C_word*)t0)[3],((C_word*)t0)[4]);}

/* k4793 in terminal-size in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4795(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm:1190: values */
C_values(4,0,((C_word*)t0)[2],C_fix(0),C_fix(0));}
else{
/* posixwin.scm:1191: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[284],lf[285],((C_word*)t0)[3]);}}

/* a4344 in k4332 in call-with-output-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4345(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4345r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4345r(t0,t1,t2);}}

static void C_ccall f_4345r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4349,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:958: close-output-pipe */
t4=*((C_word*)lf[191]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4347 in a4344 in k4332 in call-with-output-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4349(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* ##sys#shell-command in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5222(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5222,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5226,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1303: get-environment-variable */
t3=*((C_word*)lf[310]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[311]);}

/* k5224 in shell-command in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5226(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5226,2,t0,t1);}
if(C_truep(t1)){
t2=t1;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
if(C_truep(C_get_shlcmd())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_mpointer(&a,(void*)C_shlcmd),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5238,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1307: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t2);}}}

/* open-input-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4190(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_4190r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4190r(t0,t1,t2,t3);}}

static void C_ccall f_4190r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(10);
t4=C_i_check_string_2(t2,lf[184]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[185]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4204,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[185]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4211,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:913: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t9,t2,lf[184]);}
else{
t9=C_eqp(t6,lf[186]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4221,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:914: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t10,t2,lf[184]);}
else{
/* posixwin.scm:898: ##sys#error */
t10=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t7,lf[187],t6);}}}

/* open-input-file* in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4651(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4651r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4651r(t0,t1,t2,t3);}}

static void C_ccall f_4651r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[56]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4663,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1137: mode */
f_4596(t5,C_SCHEME_TRUE,t3,lf[56]);}

/* k4774 in terminal-port? in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4776(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}
else{
t3=C_tty_portp(((C_word*)t0)[3]);
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* terminal-port? in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4770(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4770,3,t0,t1,t2);}
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[283]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4776,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1185: ##sys#peek-unsigned-integer */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[62]+1)))(4,*((C_word*)lf[62]+1),t5,t2,C_fix(0));}

/* k4186 in k4174 in check in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4188(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a4314 in k4308 in call-with-input-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4315(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4315,2,t0,t1);}
/* posixwin.scm:947: proc */
t2=((C_word*)t0)[2];
((C_proc3)C_fast_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[3]);}

/* k4635 in check in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4637(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4637,2,t0,t1);}
if(C_truep(C_null_pointerp(((C_word*)t0)[2]))){
/* posixwin.scm:1130: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[10],lf[276],((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4649,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1131: ##sys#make-port */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[52]+1)))(6,*((C_word*)lf[52]+1),t2,((C_word*)t0)[5],*((C_word*)lf[53]+1),lf[277],lf[55]);}}

/* check in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_4633(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4633,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4637,a[2]=t4,a[3]=t1,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1128: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t5);}

/* k4308 in call-with-input-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4310(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4310,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4315,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word)li87),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4321,a[2]=t2,a[3]=((C_word)li88),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:946: ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],t3,t4);}

/* _exit in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4756(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2r,(void*)f_4756r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4756r(t0,t1,t2);}}

static void C_ccall f_4756r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
if(C_truep(C_i_pairp(t2))){
t3=t2;
t4=C_u_i_car(t3);
t5=t1;
t6=C_i_foreign_fixnum_argumentp(t4);
t7=t5;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,stub1063(C_SCHEME_UNDEFINED,t6));}
else{
t3=t1;
t4=C_i_foreign_fixnum_argumentp(C_fix(0));
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,stub1063(C_SCHEME_UNDEFINED,t4));}}

/* open-output-file* in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4665(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4665r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4665r(t0,t1,t2,t3);}}

static void C_ccall f_4665r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[57]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4677,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1141: mode */
f_4596(t5,C_SCHEME_FALSE,t3,lf[57]);}

/* call-with-input-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4306(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr4r,(void*)f_4306r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4306r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4306r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4310,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
C_apply(5,0,t5,*((C_word*)lf[184]+1),t2,t4);}

/* k4661 in open-input-file* in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4663(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4663,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posixwin.scm:1137: check */
f_4633(((C_word*)t0)[4],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* k5264 in k5251 in process-run in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5266(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5266,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5270,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1318: ##sys#shell-command-arguments */
t4=*((C_word*)lf[312]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[3]);}

/* terminal-size in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4788(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4788,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4795,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1189: terminal-port? */
t4=*((C_word*)lf[283]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k4376 in a4373 in a4367 in k4356 in with-input-from-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4378(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* a4373 in a4367 in k4356 in with-input-from-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4374(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4374r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4374r(t0,t1,t2);}}

static void C_ccall f_4374r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4378,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:968: close-input-pipe */
t4=*((C_word*)lf[189]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k5251 in process-run in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_5253(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5253,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm:1317: process-spawn */
t2=*((C_word*)lf[306]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],*((C_word*)lf[294]+1),((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5266,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1318: ##sys#shell-command */
t3=*((C_word*)lf[308]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k2567 in check in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2569(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a4367 in k4356 in with-input-from-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4368(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4368,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4374,a[2]=((C_word*)t0)[2],a[3]=((C_word)li94),tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:965: ##sys#call-with-values */
C_call_with_values(4,0,t1,((C_word*)t0)[3],t2);}

/* a4362 in k4356 in with-input-from-pipe in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4363(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4363,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[196]+1));
t3=C_mutate2((C_word*)lf[196]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* ##sys#shell-command-arguments in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5243(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5243,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_a_i_list2(&a,2,lf[313],t2));}

/* process-run in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5249(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_5249r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5249r(t0,t1,t2,t3);}}

static void C_ccall f_5249r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5253,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t5=t3;
t6=t4;
f_5253(t6,C_u_i_car(t5));}
else{
t5=t4;
f_5253(t5,C_SCHEME_FALSE);}}

/* k2776 in for-each-loop270 in k2738 in k2732 in delete-directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2778(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_2768(t3,((C_word*)t0)[4],t2);}

/* k5236 in k5224 in shell-command in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5238(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1308: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[308],lf[309]);}

/* k2998 in loop in k2979 in k2972 in a2969 in conc-loop in glob in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3000(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3000,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3004,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word)li30),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:437: g363 */
t3=t2;
f_3004(t3,((C_word*)t0)[5],t1);}
else{
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
/* posix-common.scm:447: loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_2983(t4,((C_word*)t0)[5],t3);}}

/* g363 in k2998 in loop in k2979 in k2972 in a2969 in conc-loop in glob in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_3004(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3004,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3012,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3024,a[2]=t3,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:445: irregex-match-substring */
t5=*((C_word*)lf[82]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k4115 in k4013 in create-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4117(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4117,2,t0,t1);}
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4109,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:857: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t4);}}

/* k4107 in k4115 in k4013 in create-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4109(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:858: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[10],lf[175],lf[176],((C_word*)t0)[3]);}

/* k2732 in delete-directory in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2734(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2734,2,t0,t1);}
t2=t1;
if(C_truep(((C_word*)t0)[2])){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2740,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:387: find-files */
t4=*((C_word*)lf[74]+1);
((C_proc7)(void*)(*((C_word*)t4+1)))(7,t4,t3,t2,lf[75],C_SCHEME_TRUE,lf[76],C_SCHEME_FALSE);}
else{
/* posix-common.scm:399: rmdir */
f_2714(((C_word*)t0)[4],t2);}}

/* k2595 */
static void C_ccall f_2597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2597,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:332: check */
f_2556(((C_word*)t0)[4],lf[57],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* f_2599 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2599(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2599,3,t0,t1,t2);}
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[58]);
t5=C_slot(t2,C_fix(7));
t6=C_eqp(lf[33],t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2615,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:342: ##sys#port-data */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[59]+1)))(3,*((C_word*)lf[59]+1),t7,t2);}
else{
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2641,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:343: ##sys#peek-unsigned-integer */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[62]+1)))(4,*((C_word*)lf[62]+1),t7,t2,C_fix(0));}}

/* k3885 in file-mkstemp in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3887(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3887,2,t0,t1);}
t2=t1;
t3=C_mkstemp(t2);
t4=C_i_string_length(t2);
t5=t4;
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3893,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t7=C_eqp(C_fix(-1),t3);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3910,a[2]=t6,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:790: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t8);}
else{
t8=t6;
f_3893(2,t8,C_SCHEME_UNDEFINED);}}

/* file-mkstemp in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3880(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3880,3,t0,t1,t2);}
t3=C_i_check_string_2(t2,lf[163]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3887,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:786: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t4,t2,lf[163]);}

/* k3042 in a2969 in conc-loop in glob in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:439: ##sys#glob->regexp */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[85]+1)))(3,*((C_word*)lf[85]+1),((C_word*)t0)[2],t1);}

/* k4695 in k4709 in port->fileno in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4697(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1150: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[10],lf[58],lf[279],((C_word*)t0)[3]);}

/* k4689 in k4709 in port->fileno in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4691(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k5396 in k5392 in k5388 in k5344 in process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5398(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5398,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5402,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm:1353: ##sys#make-locative */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[317]+1)))(6,*((C_word*)lf[317]+1),t3,((C_word*)t0)[10],C_fix(0),C_SCHEME_FALSE,lf[318]);}

/* k4647 in k4635 in check in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4649(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k5392 in k5388 in k5344 in process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5394(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5394,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5398,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm:1353: ##sys#make-locative */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[317]+1)))(6,*((C_word*)lf[317]+1),t3,((C_word*)t0)[10],C_fix(0),C_SCHEME_FALSE,lf[318]);}

/* k3022 in g363 in k2998 in loop in k2979 in k2972 in a2969 in conc-loop in glob in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3024(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:445: make-pathname */
t2=*((C_word*)lf[81]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* k5388 in k5344 in process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5390(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5390,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5394,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm:1353: ##sys#make-locative */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[317]+1)))(6,*((C_word*)lf[317]+1),t3,((C_word*)t0)[10],C_fix(0),C_SCHEME_FALSE,lf[318]);}

/* check in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_2556(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2556,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(C_null_pointerp(t5))){
/* posix-common.scm:321: posix-error */
t6=lf[2];
f_2245(6,t6,t1,lf[10],t2,lf[51],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2569,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:322: ##sys#make-port */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[52]+1)))(6,*((C_word*)lf[52]+1),t6,t4,*((C_word*)lf[53]+1),lf[54],lf[55]);}}

/* k4675 in open-output-file* in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4677(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4677,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posixwin.scm:1141: check */
f_4633(((C_word*)t0)[4],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* port->fileno in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4679(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4679,3,t0,t1,t2);}
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[58]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4711,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1146: ##sys#peek-unsigned-integer */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[62]+1)))(4,*((C_word*)lf[62]+1),t5,t2,C_fix(0));}

/* k5381 in k5351 in k5344 in process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5383(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1363: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[126],((C_word*)t0)[3],lf[316],((C_word*)t0)[4]);}

/* k3014 in k3010 in g363 in k2998 in loop in k2979 in k2972 in a2969 in conc-loop in glob in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3016(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3016,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_cons(&a,2,((C_word*)t0)[3],t1));}

/* k3010 in g363 in k2998 in loop in k2979 in k2972 in a2969 in conc-loop in glob in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3012(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3012,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3016,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_i_cdr(((C_word*)t0)[3]);
/* posix-common.scm:446: loop */
t5=((C_word*)((C_word*)t0)[4])[1];
f_2983(t5,t3,t4);}

/* ##sys#process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5339(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...){
C_word tmp;
C_word t9;
va_list v;
C_word *a,c2=c;
C_save_rest(t8,c2,9);
if(c<9) C_bad_min_argc_2(c,9,t0);
if(!C_demand(c*C_SIZEOF_PAIR+14)){
C_save_and_reclaim((void*)tr9r,(void*)f_5339r,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
else{
a=C_alloc((c-9)*3);
t9=C_restore_rest(a,C_rest_count(0));
f_5339r(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}}

static void C_ccall f_5339r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9){
C_word tmp;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(14);
t10=C_i_nullp(t9);
t11=(C_truep(t10)?C_SCHEME_FALSE:C_i_car(t9));
t12=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5346,a[2]=t1,a[3]=t8,a[4]=t7,a[5]=t6,a[6]=t2,a[7]=t3,tmp=(C_word)a,a+=8,tmp);
t13=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5422,a[2]=t12,tmp=(C_word)a,a+=3,tmp);
t14=C_a_i_cons(&a,2,t3,t4);
/* posixwin.scm:1347: $quote-args-list */
f_4870(t13,t14,t11);}

/* f_2585 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2585(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2585r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2585r(t0,t1,t2,t3);}}

static void C_ccall f_2585r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[57]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2597,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:332: mode */
f_2519(t5,C_SCHEME_FALSE,t3,lf[57]);}

/* k2581 */
static void C_ccall f_2583(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2583,2,t0,t1);}
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:328: check */
f_2556(((C_word*)t0)[4],lf[56],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3088(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3088,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_3193,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[12],tmp=(C_word)a,a+=13,tmp);
/* posix-common.scm:472: pathname-file */
t3=*((C_word*)lf[92]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[8]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3199,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:481: pproc */
t3=((C_word*)t0)[9];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[8]);}}

/* k3819 in k3807 in k3804 in file-read in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3821(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:767: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[2],lf[10],lf[157],lf[158],((C_word*)t0)[3],((C_word*)t0)[4]);}

/* f_2571 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_2571(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2571r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2571r(t0,t1,t2,t3);}}

static void C_ccall f_2571r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[56]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2583,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:328: mode */
f_2519(t5,C_SCHEME_TRUE,t3,lf[56]);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3114)){
C_save(t1);
C_rereclaim2(3114*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,405);
lf[1]=C_decode_literal(C_heaptop,"\376B\000\000/this function is not available on this platform");
lf[3]=C_h_intern(&lf[3],15,"\003syssignal-hook");
lf[4]=C_h_intern(&lf[4],13,"string-append");
lf[5]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[6]=C_h_intern(&lf[6],17,"\003syspeek-c-string");
lf[7]=C_h_intern(&lf[7],16,"\003sysupdate-errno");
lf[8]=C_h_intern(&lf[8],15,"\003sysposix-error");
lf[10]=C_h_intern(&lf[10],11,"\000file-error");
lf[11]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[12]=C_h_intern(&lf[12],17,"\003sysmake-c-string");
lf[13]=C_h_intern(&lf[13],27,"\003sysplatform-fixup-pathname");
lf[14]=C_h_intern(&lf[14],20,"\003sysexpand-home-path");
lf[15]=C_h_intern(&lf[15],11,"\000type-error");
lf[16]=C_decode_literal(C_heaptop,"\376B\000\000\052bad argument type - not a fixnum or string");
lf[17]=C_h_intern(&lf[17],9,"file-stat");
lf[18]=C_h_intern(&lf[18],16,"_stat_st_blksize");
lf[19]=C_h_intern(&lf[19],15,"_stat_st_blocks");
lf[20]=C_h_intern(&lf[20],22,"file-modification-time");
lf[21]=C_h_intern(&lf[21],16,"file-access-time");
lf[22]=C_h_intern(&lf[22],16,"file-change-time");
lf[23]=C_h_intern(&lf[23],10,"file-owner");
lf[24]=C_h_intern(&lf[24],16,"file-permissions");
lf[25]=C_h_intern(&lf[25],9,"file-size");
lf[26]=C_h_intern(&lf[26],9,"file-type");
lf[27]=C_h_intern(&lf[27],12,"regular-file");
lf[28]=C_h_intern(&lf[28],13,"symbolic-link");
lf[29]=C_h_intern(&lf[29],9,"directory");
lf[30]=C_h_intern(&lf[30],16,"character-device");
lf[31]=C_h_intern(&lf[31],12,"block-device");
lf[32]=C_h_intern(&lf[32],4,"fifo");
lf[33]=C_h_intern(&lf[33],6,"socket");
lf[34]=C_h_intern(&lf[34],13,"regular-file\077");
lf[35]=C_h_intern(&lf[35],14,"symbolic-link\077");
lf[36]=C_h_intern(&lf[36],13,"block-device\077");
lf[37]=C_h_intern(&lf[37],17,"character-device\077");
lf[38]=C_h_intern(&lf[38],5,"fifo\077");
lf[39]=C_h_intern(&lf[39],7,"socket\077");
lf[40]=C_h_intern(&lf[40],10,"directory\077");
lf[41]=C_h_intern(&lf[41],12,"fileno/stdin");
lf[42]=C_h_intern(&lf[42],13,"fileno/stdout");
lf[43]=C_h_intern(&lf[43],13,"fileno/stderr");
lf[44]=C_h_intern(&lf[44],7,"\000append");
lf[45]=C_h_intern(&lf[45],9,"\003syserror");
lf[46]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[47]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[48]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[49]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[50]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[51]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[52]=C_h_intern(&lf[52],13,"\003sysmake-port");
lf[53]=C_h_intern(&lf[53],21,"\003sysstream-port-class");
lf[54]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[55]=C_h_intern(&lf[55],6,"stream");
lf[56]=C_h_intern(&lf[56],16,"open-input-file\052");
lf[57]=C_h_intern(&lf[57],17,"open-output-file\052");
lf[58]=C_h_intern(&lf[58],12,"port->fileno");
lf[59]=C_h_intern(&lf[59],13,"\003sysport-data");
lf[60]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[61]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[62]=C_h_intern(&lf[62],25,"\003syspeek-unsigned-integer");
lf[63]=C_h_intern(&lf[63],16,"duplicate-fileno");
lf[64]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file-descriptor");
lf[65]=C_h_intern(&lf[65],17,"current-directory");
lf[66]=C_h_intern(&lf[66],16,"change-directory");
lf[67]=C_h_intern(&lf[67],13,"\003syssubstring");
lf[68]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[69]=C_h_intern(&lf[69],15,"\003sysmake-string");
lf[70]=C_h_intern(&lf[70],16,"delete-directory");
lf[71]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[72]=C_h_intern(&lf[72],11,"delete-file");
lf[73]=C_h_intern(&lf[73],8,"for-each");
lf[74]=C_h_intern(&lf[74],10,"find-files");
lf[75]=C_h_intern(&lf[75],9,"\000dotfiles");
lf[76]=C_h_intern(&lf[76],16,"\000follow-symlinks");
lf[77]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[78]=C_h_intern(&lf[78],16,"\003sysmake-pointer");
lf[79]=C_h_intern(&lf[79],4,"glob");
lf[80]=C_h_intern(&lf[80],18,"decompose-pathname");
lf[81]=C_h_intern(&lf[81],13,"make-pathname");
lf[82]=C_h_intern(&lf[82],23,"irregex-match-substring");
lf[83]=C_h_intern(&lf[83],13,"irregex-match");
lf[84]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[85]=C_h_intern(&lf[85],16,"\003sysglob->regexp");
lf[86]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[87]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[88]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[89]=C_decode_literal(C_heaptop,"\376B\000\000\002\077\052");
lf[90]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[91]=C_h_intern(&lf[91],16,"\003sysdynamic-wind");
lf[92]=C_h_intern(&lf[92],13,"pathname-file");
lf[93]=C_decode_literal(C_heaptop,"\376B\000\000\002\077\052");
lf[94]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[95]=C_h_intern(&lf[95],7,"irregex");
lf[96]=C_h_intern(&lf[96],15,"\003sysget-keyword");
lf[97]=C_h_intern(&lf[97],6,"\000limit");
lf[98]=C_h_intern(&lf[98],5,"\000seed");
lf[99]=C_h_intern(&lf[99],7,"\000action");
lf[100]=C_h_intern(&lf[100],5,"\000test");
lf[101]=C_h_intern(&lf[101],18,"file-creation-mode");
lf[103]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[104]=C_h_intern(&lf[104],19,"seconds->local-time");
lf[105]=C_h_intern(&lf[105],18,"\003sysdecode-seconds");
lf[106]=C_h_intern(&lf[106],15,"current-seconds");
lf[107]=C_h_intern(&lf[107],17,"seconds->utc-time");
lf[108]=C_h_intern(&lf[108],15,"seconds->string");
lf[109]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[110]=C_h_intern(&lf[110],19,"local-time->seconds");
lf[111]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[112]=C_h_intern(&lf[112],3,"fp=");
lf[113]=C_decode_literal(C_heaptop,"\376U-1.0\000");
lf[114]=C_h_intern(&lf[114],12,"time->string");
lf[115]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[116]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[117]=C_h_intern(&lf[117],6,"setenv");
lf[118]=C_h_intern(&lf[118],8,"unsetenv");
lf[119]=C_h_intern(&lf[119],25,"get-environment-variables");
lf[120]=C_h_intern(&lf[120],19,"set-signal-handler!");
lf[121]=C_h_intern(&lf[121],17,"\003syssignal-vector");
lf[122]=C_h_intern(&lf[122],14,"signal-handler");
lf[123]=C_h_intern(&lf[123],18,"current-process-id");
lf[124]=C_h_intern(&lf[124],12,"process-wait");
lf[125]=C_h_intern(&lf[125],16,"\003sysprocess-wait");
lf[126]=C_h_intern(&lf[126],14,"\000process-error");
lf[127]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[128]=C_h_intern(&lf[128],8,"pipe/buf");
lf[129]=C_h_intern(&lf[129],11,"open/rdonly");
lf[130]=C_h_intern(&lf[130],11,"open/wronly");
lf[131]=C_h_intern(&lf[131],9,"open/rdwr");
lf[132]=C_h_intern(&lf[132],9,"open/read");
lf[133]=C_h_intern(&lf[133],10,"open/write");
lf[134]=C_h_intern(&lf[134],10,"open/creat");
lf[135]=C_h_intern(&lf[135],11,"open/append");
lf[136]=C_h_intern(&lf[136],9,"open/excl");
lf[137]=C_h_intern(&lf[137],10,"open/trunc");
lf[138]=C_h_intern(&lf[138],11,"open/binary");
lf[139]=C_h_intern(&lf[139],9,"open/text");
lf[140]=C_h_intern(&lf[140],14,"open/noinherit");
lf[141]=C_h_intern(&lf[141],10,"perm/irusr");
lf[142]=C_h_intern(&lf[142],10,"perm/iwusr");
lf[143]=C_h_intern(&lf[143],10,"perm/ixusr");
lf[144]=C_h_intern(&lf[144],10,"perm/irgrp");
lf[145]=C_h_intern(&lf[145],10,"perm/iwgrp");
lf[146]=C_h_intern(&lf[146],10,"perm/ixgrp");
lf[147]=C_h_intern(&lf[147],10,"perm/iroth");
lf[148]=C_h_intern(&lf[148],10,"perm/iwoth");
lf[149]=C_h_intern(&lf[149],10,"perm/ixoth");
lf[150]=C_h_intern(&lf[150],10,"perm/irwxu");
lf[151]=C_h_intern(&lf[151],10,"perm/irwxg");
lf[152]=C_h_intern(&lf[152],10,"perm/irwxo");
lf[153]=C_h_intern(&lf[153],9,"file-open");
lf[154]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[155]=C_h_intern(&lf[155],10,"file-close");
lf[156]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[157]=C_h_intern(&lf[157],9,"file-read");
lf[158]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[159]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[160]=C_h_intern(&lf[160],10,"file-write");
lf[161]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[162]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[163]=C_h_intern(&lf[163],12,"file-mkstemp");
lf[164]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[165]=C_h_intern(&lf[165],8,"seek/set");
lf[166]=C_h_intern(&lf[166],8,"seek/end");
lf[167]=C_h_intern(&lf[167],8,"seek/cur");
lf[168]=C_h_intern(&lf[168],18,"set-file-position!");
lf[169]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[170]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[171]=C_h_intern(&lf[171],5,"port\077");
lf[172]=C_h_intern(&lf[172],13,"\000bounds-error");
lf[173]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[174]=C_h_intern(&lf[174],13,"file-position");
lf[175]=C_h_intern(&lf[175],16,"create-directory");
lf[176]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[177]=C_h_intern(&lf[177],16,"\003sysfile-exists\077");
lf[178]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[179]=C_h_intern(&lf[179],12,"string-split");
lf[180]=C_decode_literal(C_heaptop,"\376B\000\000\002/\134");
lf[181]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[182]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[183]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[184]=C_h_intern(&lf[184],15,"open-input-pipe");
lf[185]=C_h_intern(&lf[185],5,"\000text");
lf[186]=C_h_intern(&lf[186],7,"\000binary");
lf[187]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[188]=C_h_intern(&lf[188],16,"open-output-pipe");
lf[189]=C_h_intern(&lf[189],16,"close-input-pipe");
lf[190]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[191]=C_h_intern(&lf[191],17,"close-output-pipe");
lf[192]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[193]=C_h_intern(&lf[193],20,"call-with-input-pipe");
lf[194]=C_h_intern(&lf[194],21,"call-with-output-pipe");
lf[195]=C_h_intern(&lf[195],20,"with-input-from-pipe");
lf[196]=C_h_intern(&lf[196],18,"\003sysstandard-input");
lf[197]=C_h_intern(&lf[197],19,"with-output-to-pipe");
lf[198]=C_h_intern(&lf[198],19,"\003sysstandard-output");
lf[199]=C_h_intern(&lf[199],11,"create-pipe");
lf[200]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[201]=C_h_intern(&lf[201],11,"signal/term");
lf[202]=C_h_intern(&lf[202],10,"signal/int");
lf[203]=C_h_intern(&lf[203],10,"signal/fpe");
lf[204]=C_h_intern(&lf[204],10,"signal/ill");
lf[205]=C_h_intern(&lf[205],11,"signal/segv");
lf[206]=C_h_intern(&lf[206],11,"signal/abrt");
lf[207]=C_h_intern(&lf[207],12,"signal/break");
lf[208]=C_h_intern(&lf[208],11,"signal/alrm");
lf[209]=C_h_intern(&lf[209],11,"signal/chld");
lf[210]=C_h_intern(&lf[210],11,"signal/cont");
lf[211]=C_h_intern(&lf[211],10,"signal/hup");
lf[212]=C_h_intern(&lf[212],9,"signal/io");
lf[213]=C_h_intern(&lf[213],11,"signal/kill");
lf[214]=C_h_intern(&lf[214],11,"signal/pipe");
lf[215]=C_h_intern(&lf[215],11,"signal/prof");
lf[216]=C_h_intern(&lf[216],11,"signal/quit");
lf[217]=C_h_intern(&lf[217],11,"signal/stop");
lf[218]=C_h_intern(&lf[218],11,"signal/trap");
lf[219]=C_h_intern(&lf[219],11,"signal/tstp");
lf[220]=C_h_intern(&lf[220],10,"signal/urg");
lf[221]=C_h_intern(&lf[221],11,"signal/usr1");
lf[222]=C_h_intern(&lf[222],11,"signal/usr2");
lf[223]=C_h_intern(&lf[223],13,"signal/vtalrm");
lf[224]=C_h_intern(&lf[224],12,"signal/winch");
lf[225]=C_h_intern(&lf[225],11,"signal/xcpu");
lf[226]=C_h_intern(&lf[226],11,"signal/xfsz");
lf[227]=C_h_intern(&lf[227],12,"signals-list");
lf[228]=C_h_intern(&lf[228],10,"errno/perm");
lf[229]=C_h_intern(&lf[229],11,"errno/noent");
lf[230]=C_h_intern(&lf[230],10,"errno/srch");
lf[231]=C_h_intern(&lf[231],10,"errno/intr");
lf[232]=C_h_intern(&lf[232],8,"errno/io");
lf[233]=C_h_intern(&lf[233],12,"errno/noexec");
lf[234]=C_h_intern(&lf[234],10,"errno/badf");
lf[235]=C_h_intern(&lf[235],11,"errno/child");
lf[236]=C_h_intern(&lf[236],11,"errno/nomem");
lf[237]=C_h_intern(&lf[237],11,"errno/acces");
lf[238]=C_h_intern(&lf[238],11,"errno/fault");
lf[239]=C_h_intern(&lf[239],10,"errno/busy");
lf[240]=C_h_intern(&lf[240],11,"errno/exist");
lf[241]=C_h_intern(&lf[241],12,"errno/notdir");
lf[242]=C_h_intern(&lf[242],11,"errno/isdir");
lf[243]=C_h_intern(&lf[243],11,"errno/inval");
lf[244]=C_h_intern(&lf[244],11,"errno/mfile");
lf[245]=C_h_intern(&lf[245],11,"errno/nospc");
lf[246]=C_h_intern(&lf[246],11,"errno/spipe");
lf[247]=C_h_intern(&lf[247],10,"errno/pipe");
lf[248]=C_h_intern(&lf[248],11,"errno/again");
lf[249]=C_h_intern(&lf[249],10,"errno/rofs");
lf[250]=C_h_intern(&lf[250],10,"errno/nxio");
lf[251]=C_h_intern(&lf[251],10,"errno/2big");
lf[252]=C_h_intern(&lf[252],10,"errno/xdev");
lf[253]=C_h_intern(&lf[253],11,"errno/nodev");
lf[254]=C_h_intern(&lf[254],11,"errno/nfile");
lf[255]=C_h_intern(&lf[255],11,"errno/notty");
lf[256]=C_h_intern(&lf[256],10,"errno/fbig");
lf[257]=C_h_intern(&lf[257],11,"errno/mlink");
lf[258]=C_h_intern(&lf[258],9,"errno/dom");
lf[259]=C_h_intern(&lf[259],11,"errno/range");
lf[260]=C_h_intern(&lf[260],12,"errno/deadlk");
lf[261]=C_h_intern(&lf[261],17,"errno/nametoolong");
lf[262]=C_h_intern(&lf[262],11,"errno/nolck");
lf[263]=C_h_intern(&lf[263],11,"errno/nosys");
lf[264]=C_h_intern(&lf[264],14,"errno/notempty");
lf[265]=C_h_intern(&lf[265],11,"errno/ilseq");
lf[266]=C_h_intern(&lf[266],16,"change-file-mode");
lf[267]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[268]=C_h_intern(&lf[268],17,"file-read-access\077");
lf[269]=C_h_intern(&lf[269],18,"file-write-access\077");
lf[270]=C_h_intern(&lf[270],20,"file-execute-access\077");
lf[271]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[272]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[273]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[274]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[275]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[276]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[277]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[278]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[279]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[280]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file descriptor");
lf[281]=C_h_intern(&lf[281],27,"local-timezone-abbreviation");
lf[282]=C_h_intern(&lf[282],5,"_exit");
lf[283]=C_h_intern(&lf[283],14,"terminal-port\077");
lf[284]=C_h_intern(&lf[284],13,"terminal-size");
lf[285]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[286]=C_h_intern(&lf[286],19,"set-buffering-mode!");
lf[287]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[288]=C_h_intern(&lf[288],5,"\000full");
lf[289]=C_h_intern(&lf[289],5,"\000line");
lf[290]=C_h_intern(&lf[290],5,"\000none");
lf[291]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[292]=C_h_intern(&lf[292],13,"spawn/overlay");
lf[293]=C_h_intern(&lf[293],10,"spawn/wait");
lf[294]=C_h_intern(&lf[294],12,"spawn/nowait");
lf[295]=C_h_intern(&lf[295],13,"spawn/nowaito");
lf[296]=C_h_intern(&lf[296],12,"spawn/detach");
lf[298]=C_h_intern(&lf[298],16,"\003sysfast-reverse");
lf[299]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[300]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[302]=C_h_intern(&lf[302],24,"pathname-strip-directory");
lf[304]=C_h_intern(&lf[304],15,"process-execute");
lf[305]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[306]=C_h_intern(&lf[306],13,"process-spawn");
lf[307]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot spawn process");
lf[308]=C_h_intern(&lf[308],17,"\003sysshell-command");
lf[309]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve system directory");
lf[310]=C_h_intern(&lf[310],24,"get-environment-variable");
lf[311]=C_decode_literal(C_heaptop,"\376B\000\000\007COMSPEC");
lf[312]=C_h_intern(&lf[312],27,"\003sysshell-command-arguments");
lf[313]=C_decode_literal(C_heaptop,"\376B\000\000\002/c");
lf[314]=C_h_intern(&lf[314],11,"process-run");
lf[315]=C_h_intern(&lf[315],11,"\003sysprocess");
lf[316]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[317]=C_h_intern(&lf[317],17,"\003sysmake-locative");
lf[318]=C_h_intern(&lf[318],8,"location");
lf[319]=C_h_intern(&lf[319],18,"string-intersperse");
lf[320]=C_h_intern(&lf[320],7,"process");
lf[321]=C_h_intern(&lf[321],8,"process\052");
lf[322]=C_h_intern(&lf[322],5,"sleep");
lf[323]=C_h_intern(&lf[323],13,"get-host-name");
lf[324]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[325]=C_h_intern(&lf[325],18,"system-information");
lf[326]=C_decode_literal(C_heaptop,"\376B\000\000\007windows");
lf[327]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system-information");
lf[328]=C_h_intern(&lf[328],17,"current-user-name");
lf[329]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current user-name");
lf[330]=C_h_intern(&lf[330],9,"prot/none");
lf[331]=C_h_intern(&lf[331],9,"prot/read");
lf[332]=C_h_intern(&lf[332],10,"prot/write");
lf[333]=C_h_intern(&lf[333],9,"prot/exec");
lf[334]=C_h_intern(&lf[334],8,"map/file");
lf[335]=C_h_intern(&lf[335],10,"map/shared");
lf[336]=C_h_intern(&lf[336],11,"map/private");
lf[337]=C_h_intern(&lf[337],9,"map/fixed");
lf[338]=C_h_intern(&lf[338],13,"map/anonymous");
lf[339]=C_h_intern(&lf[339],18,"map-file-to-memory");
lf[340]=C_h_intern(&lf[340],4,"mmap");
lf[341]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot map file to memory");
lf[342]=C_decode_literal(C_heaptop,"\376B\000\000)bad argument type - not a foreign pointer");
lf[343]=C_h_intern(&lf[343],16,"\003sysnull-pointer");
lf[344]=C_h_intern(&lf[344],22,"unmap-file-from-memory");
lf[345]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot unmap file from memory");
lf[346]=C_h_intern(&lf[346],26,"memory-mapped-file-pointer");
lf[347]=C_h_intern(&lf[347],19,"memory-mapped-file\077");
lf[348]=C_h_intern(&lf[348],17,"change-directory\052");
lf[349]=C_h_intern(&lf[349],5,"error");
lf[350]=C_h_intern(&lf[350],17,"change-file-owner");
lf[351]=C_h_intern(&lf[351],11,"create-fifo");
lf[352]=C_h_intern(&lf[352],14,"create-session");
lf[353]=C_h_intern(&lf[353],20,"create-symbolic-link");
lf[354]=C_h_intern(&lf[354],26,"current-effective-group-id");
lf[355]=C_h_intern(&lf[355],25,"current-effective-user-id");
lf[356]=C_h_intern(&lf[356],27,"current-effective-user-name");
lf[357]=C_h_intern(&lf[357],16,"current-group-id");
lf[358]=C_h_intern(&lf[358],15,"current-user-id");
lf[359]=C_h_intern(&lf[359],9,"file-link");
lf[360]=C_h_intern(&lf[360],9,"file-lock");
lf[361]=C_h_intern(&lf[361],18,"file-lock/blocking");
lf[362]=C_h_intern(&lf[362],11,"file-select");
lf[363]=C_h_intern(&lf[363],14,"file-test-lock");
lf[364]=C_h_intern(&lf[364],13,"file-truncate");
lf[365]=C_h_intern(&lf[365],11,"file-unlock");
lf[366]=C_h_intern(&lf[366],10,"get-groups");
lf[367]=C_h_intern(&lf[367],17,"group-information");
lf[368]=C_h_intern(&lf[368],17,"initialize-groups");
lf[369]=C_h_intern(&lf[369],17,"parent-process-id");
lf[370]=C_h_intern(&lf[370],12,"process-fork");
lf[371]=C_h_intern(&lf[371],16,"process-group-id");
lf[372]=C_h_intern(&lf[372],14,"process-signal");
lf[373]=C_h_intern(&lf[373],18,"read-symbolic-link");
lf[374]=C_h_intern(&lf[374],10,"set-alarm!");
lf[375]=C_h_intern(&lf[375],13,"set-group-id!");
lf[376]=C_h_intern(&lf[376],11,"set-groups!");
lf[377]=C_h_intern(&lf[377],21,"set-process-group-id!");
lf[378]=C_h_intern(&lf[378],19,"set-root-directory!");
lf[379]=C_h_intern(&lf[379],16,"set-signal-mask!");
lf[380]=C_h_intern(&lf[380],12,"set-user-id!");
lf[381]=C_h_intern(&lf[381],11,"signal-mask");
lf[382]=C_h_intern(&lf[382],12,"signal-mask!");
lf[383]=C_h_intern(&lf[383],14,"signal-masked\077");
lf[384]=C_h_intern(&lf[384],14,"signal-unmask!");
lf[385]=C_h_intern(&lf[385],13,"terminal-name");
lf[386]=C_h_intern(&lf[386],16,"user-information");
lf[387]=C_h_intern(&lf[387],17,"utc-time->seconds");
lf[388]=C_h_intern(&lf[388],12,"string->time");
lf[389]=C_h_intern(&lf[389],16,"errno/wouldblock");
lf[390]=C_h_intern(&lf[390],10,"open/fsync");
lf[391]=C_h_intern(&lf[391],11,"open/noctty");
lf[392]=C_h_intern(&lf[392],13,"open/nonblock");
lf[393]=C_h_intern(&lf[393],9,"open/sync");
lf[394]=C_h_intern(&lf[394],10,"perm/isgid");
lf[395]=C_h_intern(&lf[395],10,"perm/isuid");
lf[396]=C_h_intern(&lf[396],10,"perm/isvtx");
lf[397]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[398]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[399]=C_h_intern(&lf[399],18,"getter-with-setter");
lf[400]=C_decode_literal(C_heaptop,"\376B\000\000\024(file-position port)");
lf[401]=C_decode_literal(C_heaptop,"\376B\000\000\031(file-creation-mode mode)");
lf[402]=C_h_intern(&lf[402],26,"set-file-modification-time");
lf[403]=C_decode_literal(C_heaptop,"\376B\000\000!cannot set file modification-time");
lf[404]=C_decode_literal(C_heaptop,"\376B\000\000\032(file-modification-time f)");
C_register_lf2(lf,405,create_ptable());
t2=C_mutate2(&lf[0] /* (set! c1513 ...) */,lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2221,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k3810 in k3807 in k3804 in file-read in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3812(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3812,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_list2(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]));}

/* k3204 in k3197 in k3086 in loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3206(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:481: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3069(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k5351 in k5344 in process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5353(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5353,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5363,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[8])){
/* posixwin.scm:1357: open-input-file* */
t3=*((C_word*)lf[56]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[9]))));}
else{
t3=t2;
f_5363(2,t3,C_SCHEME_FALSE);}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5383,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[11],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:1362: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t2);}}

/* k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_3060(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3060,NULL,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3067,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3213,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posix-common.scm:465: make-pathname */
t5=*((C_word*)lf[81]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[9],lf[93]);}
else{
/* posix-common.scm:465: make-pathname */
t5=*((C_word*)lf[81]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[9],lf[94]);}}

/* k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3067(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3067,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3069,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word)li38),tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_3069(t5,((C_word*)t0)[8],t1,((C_word*)t0)[9]);}

/* loop in k3065 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_3069(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3069,NULL,4,t0,t1,t2,t3);}
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=C_slot(t2,C_fix(0));
t5=t4;
t6=C_slot(t2,C_fix(1));
t7=t6;
t8=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_3088,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t7,a[5]=t3,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=t5,a[9]=((C_word*)t0)[5],a[10]=((C_word*)t0)[6],a[11]=((C_word*)t0)[7],a[12]=((C_word*)t0)[8],tmp=(C_word)a,a+=13,tmp);
/* posix-common.scm:471: directory? */
t9=*((C_word*)lf[40]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t5);}}

/* k5344 in process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5346(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[35],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5346,2,t0,t1);}
t2=t1;
t3=C_a_i_bytevector(&a,1,C_fix(1));
t4=((*(int *)C_data_pointer(t3))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(1));
t6=((*(int *)C_data_pointer(t5))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t7=C_a_i_bytevector(&a,1,C_fix(1));
t8=((*(int *)C_data_pointer(t7))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t9=C_a_i_bytevector(&a,1,C_fix(1));
t10=((*(int *)C_data_pointer(t9))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t11=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_5353,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=t9,a[6]=((C_word*)t0)[4],a[7]=t5,a[8]=((C_word*)t0)[5],a[9]=t7,a[10]=((C_word*)t0)[6],a[11]=t2,tmp=(C_word)a,a+=12,tmp);
t12=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5390,a[2]=t11,a[3]=((C_word*)t0)[7],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[3],a[8]=t9,a[9]=t7,a[10]=t5,tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm:1352: ##sys#make-locative */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[317]+1)))(6,*((C_word*)lf[317]+1),t12,t3,C_fix(0),C_SCHEME_FALSE,lf[318]);}

/* k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_3057(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3057,NULL,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3060,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
if(C_truep(C_i_closurep(((C_word*)t0)[9]))){
t4=t3;
f_3060(t4,((C_word*)t0)[9]);}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3223,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:463: irregex */
t5=*((C_word*)lf[95]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[9]);}}

/* k3860 in k3848 in k3845 in file-write in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3862(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:780: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[2],lf[10],lf[160],lf[161],((C_word*)t0)[3],((C_word*)t0)[4]);}

/* k3414 in k3410 in local-time->seconds in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3416(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3416,2,t0,t1);}
t2=C_a_mktime(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3422,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:537: fp= */
t4=*((C_word*)lf[112]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,lf[113],t2);}

/* k3211 in k3058 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3213(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posix-common.scm:465: glob */
t2=*((C_word*)lf[79]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3410 in local-time->seconds in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3412(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3412,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3416,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:536: ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[69]+1)))(4,*((C_word*)lf[69]+1),t2,((C_word*)t0)[4],C_make_character(0));}

/* k3854 in k3848 in k3845 in file-write in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3856(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k5175 in process-spawn in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5177(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(((C_word*)t0)[2])){
t2=C_spawnvpe(((C_word*)t0)[3],t1);
/* posixwin.scm:1297: $exec-teardown */
f_5073(((C_word*)t0)[4],lf[306],lf[307],((C_word*)t0)[5],t2);}
else{
t2=C_spawnvp(((C_word*)t0)[3],t1);
/* posixwin.scm:1297: $exec-teardown */
f_5073(((C_word*)t0)[4],lf[306],lf[307],((C_word*)t0)[5],t2);}}

/* k3848 in k3845 in file-write in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_3850(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3850,NULL,2,t0,t1);}
t2=t1;
t3=C_i_check_exact_2(t2,lf[160]);
t4=C_write(((C_word*)t0)[2],((C_word*)t0)[3],t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3856,a[2]=((C_word*)t0)[4],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=C_eqp(C_fix(-1),t4);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3862,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:779: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t7);}
else{
t7=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t4);}}

/* local-time->seconds in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3408(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3408,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3412,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:535: check-time-vector */
f_3299(t3,lf[110],t2);}

/* k3845 in file-write in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3847(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3847,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3850,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=((C_word*)t0)[5];
t4=t2;
f_3850(t4,C_u_i_car(t3));}
else{
t3=t2;
f_3850(t3,C_block_size(((C_word*)t0)[3]));}}

/* file-write in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3840(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_3840r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3840r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3840r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=C_i_check_exact_2(t2,lf[160]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3847,a[2]=t2,a[3]=t3,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t3))){
if(C_truep(C_byteblockp(t3))){
t7=t6;
f_3847(2,t7,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm:774: ##sys#signal-hook */
t7=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,lf[15],lf[160],lf[162],t3);}}
else{
/* posixwin.scm:774: ##sys#signal-hook */
t7=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,lf[15],lf[160],lf[162],t3);}}

/* k4082 in for-each-loop778 in k4021 in k4013 in create-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4084(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_4074(t3,((C_word*)t0)[4],t2);}

/* k3221 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3223(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3223,2,t0,t1);}
t2=t1;
t3=((C_word*)t0)[2];
f_3060(t3,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3224,a[2]=t2,a[3]=((C_word)li39),tmp=(C_word)a,a+=4,tmp));}

/* f_3224 in k3221 in k3055 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3224(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3224,3,t0,t1,t2);}
/* posix-common.scm:464: irregex-match */
t3=*((C_word*)lf[83]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,((C_word*)t0)[2],t2);}

/* k3458 in time->string in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3460(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3460,2,t0,t1);}
if(C_truep(((C_word*)t0)[2])){
t2=C_i_check_string_2(((C_word*)t0)[2],lf[114]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3469,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3479,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:550: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t4,((C_word*)t0)[2],lf[114]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3486,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3507,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:552: ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[69]+1)))(4,*((C_word*)lf[69]+1),t3,((C_word*)t0)[5],C_make_character(0));}}

/* k5706 in current-user-name in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5708(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1433: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[328],lf[329]);}

/* k3467 in k3458 in time->string in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3469(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posix-common.scm:551: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[114],lf[115],((C_word*)t0)[3]);}}

/* for-each-loop778 in k4021 in k4013 in create-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_4074(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4074,NULL,3,t0,t1,t2);}
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4084,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posixwin.scm:879: g779 */
t5=((C_word*)t0)[3];
f_4027(t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k4049 in k4057 in k4038 in k4030 in g779 in k4021 in k4013 in create-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4051(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:858: ##sys#signal-hook */
t2=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[10],lf[175],lf[176],((C_word*)t0)[3]);}

/* k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3250(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3250,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3253,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3282,a[2]=((C_word)li47),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:484: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[96]+1)))(5,*((C_word*)lf[96]+1),t3,lf[99],((C_word*)t0)[4],t4);}

/* time->string in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3453(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3r,(void*)f_3453r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3453r(t0,t1,t2,t3);}}

static void C_ccall f_3453r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3460,a[2]=t6,a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:546: check-time-vector */
f_3299(t7,lf[114],t2);}

/* k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3253(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3253,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3256,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3279,a[2]=((C_word)li45),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:484: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[96]+1)))(5,*((C_word*)lf[96]+1),t3,lf[98],((C_word*)t0)[5],t4);}

/* k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3256(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3256,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3259,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3276,a[2]=((C_word)li44),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:484: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[96]+1)))(5,*((C_word*)lf[96]+1),t3,lf[97],((C_word*)t0)[6],t4);}

/* k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3259(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3259,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3262,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3273,a[2]=((C_word)li43),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:484: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[96]+1)))(5,*((C_word*)lf[96]+1),t3,lf[75],((C_word*)t0)[7],t4);}

/* k4038 in k4030 in g779 in k4021 in k4013 in create-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4040(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4040,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4059,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:856: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t4,t3,lf[175]);}}

/* k3891 in k3885 in file-mkstemp in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3893(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3893,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3900,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_fixnum_difference(((C_word*)t0)[4],C_fix(1));
/* posixwin.scm:792: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[67]+1)))(5,*((C_word*)lf[67]+1),t2,((C_word*)t0)[5],C_fix(0),t3);}

/* f_3284 in a3281 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3284(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3284,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_a_i_cons(&a,2,t2,t3));}

/* k5283 in k5279 in k5404 in k5400 in k5396 in k5392 in k5388 in k5344 in process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5285(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
t2=(C_truep(((C_word*)t0)[2])?C_i_foreign_pointer_argumentp(((C_word*)t0)[2]):C_SCHEME_FALSE);
t3=(C_truep(((C_word*)t0)[3])?C_i_foreign_pointer_argumentp(((C_word*)t0)[3]):C_SCHEME_FALSE);
t4=(C_truep(((C_word*)t0)[4])?C_i_foreign_pointer_argumentp(((C_word*)t0)[4]):C_SCHEME_FALSE);
t5=(C_truep(((C_word*)t0)[5])?C_i_foreign_pointer_argumentp(((C_word*)t0)[5]):C_SCHEME_FALSE);
t6=C_i_foreign_fixnum_argumentp(((C_word*)t0)[6]);
t7=((C_word*)t0)[7];
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,stub1232(C_SCHEME_UNDEFINED,((C_word*)t0)[8],t1,C_SCHEME_FALSE,t2,t3,t4,t5,t6));}

/* a3281 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3282(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3282,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3284,a[2]=((C_word)li46),tmp=(C_word)a,a+=3,tmp));}

/* k5279 in k5404 in k5400 in k5396 in k5392 in k5388 in k5344 in process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5281(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5281,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5285,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[8])){
t4=C_i_foreign_string_argumentp(((C_word*)t0)[8]);
/* posixwin.scm:1341: ##sys#make-c-string */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(3,*((C_word*)lf[12]+1),t3,t4);}
else{
t4=t3;
f_5285(2,t4,C_SCHEME_FALSE);}}

/* k4057 in k4038 in k4030 in g779 in k4021 in k4013 in create-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4059(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4059,2,t0,t1);}
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4051,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:857: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t4);}}

/* k4030 in g779 in k4021 in k4013 in create-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4032(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4032,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];
t4=((C_word*)((C_word*)t0)[2])[1];
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4040,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:862: ##sys#file-exists? */
((C_proc6)C_fast_retrieve_proc(*((C_word*)lf[177]+1)))(6,*((C_word*)lf[177]+1),t5,t4,C_SCHEME_FALSE,C_SCHEME_TRUE,C_SCHEME_FALSE);}

/* process-spawn in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5155(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_5155r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5155r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5155r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word *a=C_alloc(6);
t5=C_i_nullp(t4);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_i_car(t4));
t7=C_i_nullp(t4);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:C_i_cdr(t4));
t9=C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_FALSE:C_i_car(t8));
t11=t10;
t12=C_i_nullp(t8);
t13=(C_truep(t12)?C_SCHEME_END_OF_LIST:C_i_cdr(t8));
t14=C_i_nullp(t13);
t15=(C_truep(t14)?C_SCHEME_FALSE:C_i_car(t13));
t16=C_i_nullp(t13);
t17=(C_truep(t16)?C_SCHEME_END_OF_LIST:C_i_cdr(t13));
t18=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5177,a[2]=t11,a[3]=t2,a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm:1296: $exec-setup */
t19=lf[301];
f_5037(t19,t18,lf[306],t3,t6,t11,t15);}

/* f_3232 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3232(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3232,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* k5268 in k5264 in k5251 in process-run in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5270(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1318: process-spawn */
t2=*((C_word*)lf[306]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],*((C_word*)lf[294]+1),((C_word*)t0)[3],t1);}

/* k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3265(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3265,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[6];
t7=((C_word*)t0)[7];
t8=t1;
t9=((C_word*)t0)[8];
t10=C_i_check_string_2(t3,lf[74]);
t11=C_fix(0);
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3057,a[2]=t8,a[3]=t5,a[4]=t12,a[5]=t9,a[6]=t2,a[7]=t6,a[8]=t3,a[9]=t4,tmp=(C_word)a,a+=10,tmp);
if(C_truep(t7)){
if(C_truep(C_fixnump(t7))){
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3240,a[2]=t12,a[3]=t7,a[4]=((C_word)li40),tmp=(C_word)a,a+=5,tmp);
t15=t13;
f_3057(t15,t14);}
else{
t14=t13;
f_3057(t14,t7);}}
else{
t14=t13;
f_3057(t14,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3232,a[2]=((C_word)li41),tmp=(C_word)a,a+=3,tmp));}}

/* k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3262(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3262,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3265,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3270,a[2]=((C_word)li42),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:484: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[96]+1)))(5,*((C_word*)lf[96]+1),t3,lf[76],((C_word*)t0)[8],t4);}

/* k5509 in %process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5511(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5511,2,t0,t1);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5515,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:1380: ##sys#shell-command */
t4=*((C_word*)lf[308]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5517(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3r,(void*)f_5517r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5517r(t0,t1,t2,t3);}}

static void C_ccall f_5517r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=C_i_nullp(t11);
t13=(C_truep(t12)?C_SCHEME_FALSE:C_i_car(t11));
if(C_truep(C_i_nullp(t11))){
/* posixwin.scm:1388: %process */
f_5433(t1,lf[320],C_SCHEME_FALSE,t2,t5,t9,t13);}
else{
t14=C_i_cdr(t11);
/* posixwin.scm:1388: %process */
f_5433(t1,lf[320],C_SCHEME_FALSE,t2,t5,t9,t13);}}

/* k5513 in k5509 in %process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5515(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];
f_5476(2,t3,t2);}

/* k5369 in k5365 in k5361 in k5351 in k5344 in process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5371(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1356: values */
C_values(6,0,((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[5]))),t1);}

/* k5365 in k5361 in k5351 in k5344 in process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5367(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5367,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5371,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixwin.scm:1360: open-input-file* */
t4=*((C_word*)lf[56]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[6]))));}
else{
/* posixwin.scm:1356: values */
C_values(6,0,((C_word*)t0)[2],((C_word*)t0)[3],t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[4]))),C_SCHEME_FALSE);}}

/* a3289 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3290(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3290,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3292,a[2]=((C_word)li48),tmp=(C_word)a,a+=3,tmp));}

/* f_3292 in a3289 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3292(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3292,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3297(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[38],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3297,2,t0,t1);}
t2=C_mutate2((C_word*)lf[101]+1 /* (set! file-creation-mode ...) */,t1);
t3=C_mutate2(&lf[102] /* (set! check-time-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3299,a[2]=((C_word)li51),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[104]+1 /* (set! seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3318,a[2]=((C_word)li52),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[107]+1 /* (set! seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3339,a[2]=((C_word)li53),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[108]+1 /* (set! seconds->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3370,a[2]=((C_word)li54),tmp=(C_word)a,a+=3,tmp));
t7=C_fix((C_word)sizeof(struct tm));
t8=C_mutate2((C_word*)lf[110]+1 /* (set! local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3408,a[2]=t7,a[3]=((C_word)li55),tmp=(C_word)a,a+=4,tmp));
t9=C_fix((C_word)sizeof(struct tm));
t10=C_mutate2((C_word*)lf[114]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3453,a[2]=t9,a[3]=((C_word)li56),tmp=(C_word)a,a+=4,tmp));
t11=C_mutate2((C_word*)lf[117]+1 /* (set! setenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3515,a[2]=((C_word)li57),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[118]+1 /* (set! unsetenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3532,a[2]=((C_word)li58),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[119]+1 /* (set! get-environment-variables ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3552,a[2]=((C_word)li61),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate2((C_word*)lf[120]+1 /* (set! set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3618,a[2]=((C_word)li62),tmp=(C_word)a,a+=3,tmp));
t15=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3633,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t16=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6156,a[2]=((C_word)li194),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:595: getter-with-setter */
t17=*((C_word*)lf[399]+1);
((C_proc4)(void*)(*((C_word*)t17+1)))(4,t17,t15,t16,*((C_word*)lf[120]+1));}

/* check-time-vector in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_3299(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3299,NULL,3,t1,t2,t3);}
t4=C_i_check_vector_2(t3,t2);
t5=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t5,C_fix(10)))){
/* posix-common.scm:513: ##sys#error */
t6=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,t2,lf[103],t3);}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* g779 in k4021 in k4013 in create-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_4027(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4027,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4032,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:870: string-append */
t4=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)((C_word*)t0)[2])[1],lf[178],t2);}

/* k5361 in k5351 in k5344 in process in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5363(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5363,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5367,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[6])){
/* posixwin.scm:1358: open-output-file* */
t4=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[7]))));}
else{
t4=t3;
f_5367(2,t4,C_SCHEME_FALSE);}}

/* k4021 in k4013 in create-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4023(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4023,2,t0,t1);}
t2=C_i_car(t1);
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4027,a[2]=t4,a[3]=((C_word)li78),tmp=(C_word)a,a+=4,tmp);
t6=C_u_i_cdr(t1);
t7=C_i_check_list_2(t6,lf[73]);
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4074,a[2]=t9,a[3]=t5,a[4]=((C_word)li79),tmp=(C_word)a,a+=5,tmp));
t11=((C_word*)t9)[1];
f_4074(t11,((C_word*)t0)[2],t6);}

/* k3484 in k3458 in time->string in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3486(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posix-common.scm:554: ##sys#substring */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[67]+1)))(5,*((C_word*)lf[67]+1),((C_word*)t0)[2],t1,C_fix(0),t3);}
else{
/* posix-common.scm:555: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[114],lf[116],((C_word*)t0)[3]);}}

/* k3481 in k3477 in k3458 in time->string in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3483(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3483,2,t0,t1);}
t2=((C_word*)t0)[2];
t3=C_a_i_bytevector(&a,1,C_fix(3));
if(C_truep(t1)){
t4=C_i_foreign_block_argumentp(t1);
t5=stub526(t3,t2,((C_word*)t0)[3],t4);
/* posix-common.scm:543: ##sys#peek-c-string */
t6=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,((C_word*)t0)[4],t5,C_fix(0));}
else{
t4=stub526(t3,t2,((C_word*)t0)[3],C_SCHEME_FALSE);
/* posix-common.scm:543: ##sys#peek-c-string */
t5=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,((C_word*)t0)[4],t4,C_fix(0));}}

/* k4016 in k4013 in create-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4018(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[3]);}

/* k4013 in create-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4015(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4015,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4018,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
t4=t3;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4023,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:866: string-split */
t6=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[180]);}
else{
t4=t3;
t5=t2;
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4117,a[2]=t4,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:856: ##sys#make-c-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[12]+1)))(4,*((C_word*)lf[12]+1),t6,t5,lf[175]);}}

/* k5108 in process-execute in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5110(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(((C_word*)t0)[2])){
t2=C_execve(t1);
/* posixwin.scm:1292: $exec-teardown */
f_5073(((C_word*)t0)[3],lf[304],lf[305],((C_word*)t0)[4],t2);}
else{
t2=C_execvp(t1);
/* posixwin.scm:1292: $exec-teardown */
f_5073(((C_word*)t0)[3],lf[304],lf[305],((C_word*)t0)[4],t2);}}

/* a3275 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3276(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3276,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* a3272 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3273(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3273,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* a3269 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3270(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3270,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* a3278 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3279(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3279,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}

/* k3477 in k3458 in time->string in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3479(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3479,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3483,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:550: ##sys#make-string */
((C_proc4)C_fast_retrieve_proc(*((C_word*)lf[69]+1)))(4,*((C_word*)lf[69]+1),t3,((C_word*)t0)[4],C_make_character(0));}

/* k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4003(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word t181;
C_word t182;
C_word t183;
C_word t184;
C_word t185;
C_word t186;
C_word t187;
C_word t188;
C_word t189;
C_word t190;
C_word t191;
C_word ab[318],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4003,2,t0,t1);}
t2=C_mutate2((C_word*)lf[174]+1 /* (set! file-position ...) */,t1);
t3=C_mutate2((C_word*)lf[175]+1 /* (set! create-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4005,a[2]=((C_word)li80),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[66]+1 /* (set! change-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4128,a[2]=((C_word)li81),tmp=(C_word)a,a+=3,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4172,a[2]=((C_word)li82),tmp=(C_word)a,a+=3,tmp);
t6=C_mutate2((C_word*)lf[184]+1 /* (set! open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4190,a[2]=t5,a[3]=((C_word)li83),tmp=(C_word)a,a+=4,tmp));
t7=C_mutate2((C_word*)lf[188]+1 /* (set! open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4230,a[2]=t5,a[3]=((C_word)li84),tmp=(C_word)a,a+=4,tmp));
t8=C_mutate2((C_word*)lf[189]+1 /* (set! close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4270,a[2]=((C_word)li85),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate2((C_word*)lf[191]+1 /* (set! close-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4288,a[2]=((C_word)li86),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate2((C_word*)lf[193]+1 /* (set! call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4306,a[2]=((C_word)li89),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate2((C_word*)lf[194]+1 /* (set! call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4330,a[2]=((C_word)li92),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[195]+1 /* (set! with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4354,a[2]=((C_word)li97),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[197]+1 /* (set! with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4388,a[2]=((C_word)li102),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate2((C_word*)lf[199]+1 /* (set! create-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4422,a[2]=((C_word)li103),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[201]+1 /* (set! signal/term ...) */,C_fix((C_word)SIGTERM));
t16=C_mutate2((C_word*)lf[202]+1 /* (set! signal/int ...) */,C_fix((C_word)SIGINT));
t17=C_mutate2((C_word*)lf[203]+1 /* (set! signal/fpe ...) */,C_fix((C_word)SIGFPE));
t18=C_mutate2((C_word*)lf[204]+1 /* (set! signal/ill ...) */,C_fix((C_word)SIGILL));
t19=C_mutate2((C_word*)lf[205]+1 /* (set! signal/segv ...) */,C_fix((C_word)SIGSEGV));
t20=C_mutate2((C_word*)lf[206]+1 /* (set! signal/abrt ...) */,C_fix((C_word)SIGABRT));
t21=C_mutate2((C_word*)lf[207]+1 /* (set! signal/break ...) */,C_fix((C_word)SIGBREAK));
t22=C_set_block_item(lf[208] /* signal/alrm */,0,C_fix(0));
t23=C_set_block_item(lf[209] /* signal/chld */,0,C_fix(0));
t24=C_set_block_item(lf[210] /* signal/cont */,0,C_fix(0));
t25=C_set_block_item(lf[211] /* signal/hup */,0,C_fix(0));
t26=C_set_block_item(lf[212] /* signal/io */,0,C_fix(0));
t27=C_set_block_item(lf[213] /* signal/kill */,0,C_fix(0));
t28=C_set_block_item(lf[214] /* signal/pipe */,0,C_fix(0));
t29=C_set_block_item(lf[215] /* signal/prof */,0,C_fix(0));
t30=C_set_block_item(lf[216] /* signal/quit */,0,C_fix(0));
t31=C_set_block_item(lf[217] /* signal/stop */,0,C_fix(0));
t32=C_set_block_item(lf[218] /* signal/trap */,0,C_fix(0));
t33=C_set_block_item(lf[219] /* signal/tstp */,0,C_fix(0));
t34=C_set_block_item(lf[220] /* signal/urg */,0,C_fix(0));
t35=C_set_block_item(lf[221] /* signal/usr1 */,0,C_fix(0));
t36=C_set_block_item(lf[222] /* signal/usr2 */,0,C_fix(0));
t37=C_set_block_item(lf[223] /* signal/vtalrm */,0,C_fix(0));
t38=C_set_block_item(lf[224] /* signal/winch */,0,C_fix(0));
t39=C_set_block_item(lf[225] /* signal/xcpu */,0,C_fix(0));
t40=C_set_block_item(lf[226] /* signal/xfsz */,0,C_fix(0));
t41=C_a_i_list7(&a,7,*((C_word*)lf[201]+1),*((C_word*)lf[202]+1),*((C_word*)lf[203]+1),*((C_word*)lf[204]+1),*((C_word*)lf[205]+1),*((C_word*)lf[206]+1),*((C_word*)lf[207]+1));
t42=C_mutate2((C_word*)lf[227]+1 /* (set! signals-list ...) */,t41);
t43=C_mutate2((C_word*)lf[228]+1 /* (set! errno/perm ...) */,C_fix((C_word)EPERM));
t44=C_mutate2((C_word*)lf[229]+1 /* (set! errno/noent ...) */,C_fix((C_word)ENOENT));
t45=C_mutate2((C_word*)lf[230]+1 /* (set! errno/srch ...) */,C_fix((C_word)ESRCH));
t46=C_mutate2((C_word*)lf[231]+1 /* (set! errno/intr ...) */,C_fix((C_word)EINTR));
t47=C_mutate2((C_word*)lf[232]+1 /* (set! errno/io ...) */,C_fix((C_word)EIO));
t48=C_mutate2((C_word*)lf[233]+1 /* (set! errno/noexec ...) */,C_fix((C_word)ENOEXEC));
t49=C_mutate2((C_word*)lf[234]+1 /* (set! errno/badf ...) */,C_fix((C_word)EBADF));
t50=C_mutate2((C_word*)lf[235]+1 /* (set! errno/child ...) */,C_fix((C_word)ECHILD));
t51=C_mutate2((C_word*)lf[236]+1 /* (set! errno/nomem ...) */,C_fix((C_word)ENOMEM));
t52=C_mutate2((C_word*)lf[237]+1 /* (set! errno/acces ...) */,C_fix((C_word)EACCES));
t53=C_mutate2((C_word*)lf[238]+1 /* (set! errno/fault ...) */,C_fix((C_word)EFAULT));
t54=C_mutate2((C_word*)lf[239]+1 /* (set! errno/busy ...) */,C_fix((C_word)EBUSY));
t55=C_mutate2((C_word*)lf[240]+1 /* (set! errno/exist ...) */,C_fix((C_word)EEXIST));
t56=C_mutate2((C_word*)lf[241]+1 /* (set! errno/notdir ...) */,C_fix((C_word)ENOTDIR));
t57=C_mutate2((C_word*)lf[242]+1 /* (set! errno/isdir ...) */,C_fix((C_word)EISDIR));
t58=C_mutate2((C_word*)lf[243]+1 /* (set! errno/inval ...) */,C_fix((C_word)EINVAL));
t59=C_mutate2((C_word*)lf[244]+1 /* (set! errno/mfile ...) */,C_fix((C_word)EMFILE));
t60=C_mutate2((C_word*)lf[245]+1 /* (set! errno/nospc ...) */,C_fix((C_word)ENOSPC));
t61=C_mutate2((C_word*)lf[246]+1 /* (set! errno/spipe ...) */,C_fix((C_word)ESPIPE));
t62=C_mutate2((C_word*)lf[247]+1 /* (set! errno/pipe ...) */,C_fix((C_word)EPIPE));
t63=C_mutate2((C_word*)lf[248]+1 /* (set! errno/again ...) */,C_fix((C_word)EAGAIN));
t64=C_mutate2((C_word*)lf[249]+1 /* (set! errno/rofs ...) */,C_fix((C_word)EROFS));
t65=C_mutate2((C_word*)lf[250]+1 /* (set! errno/nxio ...) */,C_fix((C_word)ENXIO));
t66=C_mutate2((C_word*)lf[251]+1 /* (set! errno/2big ...) */,C_fix((C_word)E2BIG));
t67=C_mutate2((C_word*)lf[252]+1 /* (set! errno/xdev ...) */,C_fix((C_word)EXDEV));
t68=C_mutate2((C_word*)lf[253]+1 /* (set! errno/nodev ...) */,C_fix((C_word)ENODEV));
t69=C_mutate2((C_word*)lf[254]+1 /* (set! errno/nfile ...) */,C_fix((C_word)ENFILE));
t70=C_mutate2((C_word*)lf[255]+1 /* (set! errno/notty ...) */,C_fix((C_word)ENOTTY));
t71=C_mutate2((C_word*)lf[256]+1 /* (set! errno/fbig ...) */,C_fix((C_word)EFBIG));
t72=C_mutate2((C_word*)lf[257]+1 /* (set! errno/mlink ...) */,C_fix((C_word)EMLINK));
t73=C_mutate2((C_word*)lf[258]+1 /* (set! errno/dom ...) */,C_fix((C_word)EDOM));
t74=C_mutate2((C_word*)lf[259]+1 /* (set! errno/range ...) */,C_fix((C_word)ERANGE));
t75=C_mutate2((C_word*)lf[260]+1 /* (set! errno/deadlk ...) */,C_fix((C_word)EDEADLK));
t76=C_mutate2((C_word*)lf[261]+1 /* (set! errno/nametoolong ...) */,C_fix((C_word)ENAMETOOLONG));
t77=C_mutate2((C_word*)lf[262]+1 /* (set! errno/nolck ...) */,C_fix((C_word)ENOLCK));
t78=C_mutate2((C_word*)lf[263]+1 /* (set! errno/nosys ...) */,C_fix((C_word)ENOSYS));
t79=C_mutate2((C_word*)lf[264]+1 /* (set! errno/notempty ...) */,C_fix((C_word)ENOTEMPTY));
t80=C_mutate2((C_word*)lf[265]+1 /* (set! errno/ilseq ...) */,C_fix((C_word)EILSEQ));
t81=C_mutate2((C_word*)lf[266]+1 /* (set! change-file-mode ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4521,a[2]=((C_word)li104),tmp=(C_word)a,a+=3,tmp));
t82=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4551,a[2]=((C_word)li105),tmp=(C_word)a,a+=3,tmp);
t83=C_mutate2((C_word*)lf[268]+1 /* (set! file-read-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4575,a[2]=t82,a[3]=((C_word)li106),tmp=(C_word)a,a+=4,tmp));
t84=C_mutate2((C_word*)lf[269]+1 /* (set! file-write-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4581,a[2]=t82,a[3]=((C_word)li107),tmp=(C_word)a,a+=4,tmp));
t85=C_mutate2((C_word*)lf[270]+1 /* (set! file-execute-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4587,a[2]=t82,a[3]=((C_word)li108),tmp=(C_word)a,a+=4,tmp));
t86=C_mutate2((C_word*)lf[41]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)0));
t87=C_mutate2((C_word*)lf[42]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)1));
t88=C_mutate2((C_word*)lf[43]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)2));
t89=C_SCHEME_UNDEFINED;
t90=(*a=C_VECTOR_TYPE|1,a[1]=t89,tmp=(C_word)a,a+=2,tmp);
t91=C_SCHEME_UNDEFINED;
t92=(*a=C_VECTOR_TYPE|1,a[1]=t91,tmp=(C_word)a,a+=2,tmp);
t93=C_set_block_item(t90,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4596,a[2]=((C_word)li109),tmp=(C_word)a,a+=3,tmp));
t94=C_set_block_item(t92,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4633,a[2]=((C_word)li110),tmp=(C_word)a,a+=3,tmp));
t95=C_mutate2((C_word*)lf[56]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4651,a[2]=t92,a[3]=t90,a[4]=((C_word)li111),tmp=(C_word)a,a+=5,tmp));
t96=C_mutate2((C_word*)lf[57]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4665,a[2]=t92,a[3]=t90,a[4]=((C_word)li112),tmp=(C_word)a,a+=5,tmp));
t97=C_mutate2((C_word*)lf[58]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4679,a[2]=((C_word)li113),tmp=(C_word)a,a+=3,tmp));
t98=C_mutate2((C_word*)lf[63]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4713,a[2]=((C_word)li114),tmp=(C_word)a,a+=3,tmp));
t99=C_mutate2((C_word*)lf[281]+1 /* (set! local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4743,a[2]=((C_word)li115),tmp=(C_word)a,a+=3,tmp));
t100=C_mutate2((C_word*)lf[282]+1 /* (set! _exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4756,a[2]=((C_word)li116),tmp=(C_word)a,a+=3,tmp));
t101=C_mutate2((C_word*)lf[283]+1 /* (set! terminal-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4770,a[2]=((C_word)li117),tmp=(C_word)a,a+=3,tmp));
t102=C_mutate2((C_word*)lf[284]+1 /* (set! terminal-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4788,a[2]=((C_word)li118),tmp=(C_word)a,a+=3,tmp));
t103=C_mutate2((C_word*)lf[286]+1 /* (set! set-buffering-mode! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4803,a[2]=((C_word)li119),tmp=(C_word)a,a+=3,tmp));
t104=C_mutate2((C_word*)lf[292]+1 /* (set! spawn/overlay ...) */,C_fix((C_word)P_OVERLAY));
t105=C_mutate2((C_word*)lf[293]+1 /* (set! spawn/wait ...) */,C_fix((C_word)P_WAIT));
t106=C_mutate2((C_word*)lf[294]+1 /* (set! spawn/nowait ...) */,C_fix((C_word)P_NOWAIT));
t107=C_mutate2((C_word*)lf[295]+1 /* (set! spawn/nowaito ...) */,C_fix((C_word)P_NOWAITO));
t108=C_mutate2((C_word*)lf[296]+1 /* (set! spawn/detach ...) */,C_fix((C_word)P_DETACH));
t109=C_mutate2(&lf[297] /* (set! $quote-args-list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4870,a[2]=((C_word)li122),tmp=(C_word)a,a+=3,tmp));
t110=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4947,a[2]=((C_word)li123),tmp=(C_word)a,a+=3,tmp);
t111=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4968,a[2]=((C_word)li124),tmp=(C_word)a,a+=3,tmp);
t112=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4989,a[2]=((C_word)li126),tmp=(C_word)a,a+=3,tmp);
t113=C_mutate2(&lf[301] /* (set! $exec-setup ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5037,a[2]=t112,a[3]=t111,a[4]=t110,a[5]=((C_word)li127),tmp=(C_word)a,a+=6,tmp));
t114=C_mutate2(&lf[303] /* (set! $exec-teardown ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5073,a[2]=((C_word)li128),tmp=(C_word)a,a+=3,tmp));
t115=C_mutate2((C_word*)lf[304]+1 /* (set! process-execute ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5088,a[2]=((C_word)li129),tmp=(C_word)a,a+=3,tmp));
t116=C_mutate2((C_word*)lf[306]+1 /* (set! process-spawn ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5155,a[2]=((C_word)li130),tmp=(C_word)a,a+=3,tmp));
t117=C_mutate2((C_word*)lf[308]+1 /* (set! ##sys#shell-command ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5222,a[2]=((C_word)li131),tmp=(C_word)a,a+=3,tmp));
t118=C_mutate2((C_word*)lf[312]+1 /* (set! ##sys#shell-command-arguments ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5243,a[2]=((C_word)li132),tmp=(C_word)a,a+=3,tmp));
t119=C_mutate2((C_word*)lf[314]+1 /* (set! process-run ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5249,a[2]=((C_word)li133),tmp=(C_word)a,a+=3,tmp));
t120=C_mutate2((C_word*)lf[315]+1 /* (set! ##sys#process ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5339,a[2]=((C_word)li134),tmp=(C_word)a,a+=3,tmp));
t121=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5433,a[2]=((C_word)li140),tmp=(C_word)a,a+=3,tmp);
t122=C_mutate2((C_word*)lf[320]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5517,a[2]=t121,a[3]=((C_word)li141),tmp=(C_word)a,a+=4,tmp));
t123=C_mutate2((C_word*)lf[321]+1 /* (set! process* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5577,a[2]=t121,a[3]=((C_word)li142),tmp=(C_word)a,a+=4,tmp));
t124=C_mutate2((C_word*)lf[125]+1 /* (set! ##sys#process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5637,a[2]=((C_word)li143),tmp=(C_word)a,a+=3,tmp));
t125=C_mutate2((C_word*)lf[322]+1 /* (set! sleep ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5649,a[2]=((C_word)li144),tmp=(C_word)a,a+=3,tmp));
t126=C_mutate2((C_word*)lf[323]+1 /* (set! get-host-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5655,a[2]=((C_word)li145),tmp=(C_word)a,a+=3,tmp));
t127=C_mutate2((C_word*)lf[325]+1 /* (set! system-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5667,a[2]=((C_word)li146),tmp=(C_word)a,a+=3,tmp));
t128=C_mutate2((C_word*)lf[328]+1 /* (set! current-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5698,a[2]=((C_word)li147),tmp=(C_word)a,a+=3,tmp));
t129=C_mutate2((C_word*)lf[330]+1 /* (set! prot/none ...) */,C_fix((C_word)PROT_NONE));
t130=C_mutate2((C_word*)lf[331]+1 /* (set! prot/read ...) */,C_fix((C_word)PROT_READ));
t131=C_mutate2((C_word*)lf[332]+1 /* (set! prot/write ...) */,C_fix((C_word)PROT_WRITE));
t132=C_mutate2((C_word*)lf[333]+1 /* (set! prot/exec ...) */,C_fix((C_word)PROT_EXEC));
t133=C_mutate2((C_word*)lf[334]+1 /* (set! map/file ...) */,C_fix((C_word)MAP_FILE));
t134=C_mutate2((C_word*)lf[335]+1 /* (set! map/shared ...) */,C_fix((C_word)MAP_SHARED));
t135=C_mutate2((C_word*)lf[336]+1 /* (set! map/private ...) */,C_fix((C_word)MAP_PRIVATE));
t136=C_mutate2((C_word*)lf[337]+1 /* (set! map/fixed ...) */,C_fix((C_word)MAP_FIXED));
t137=C_mutate2((C_word*)lf[338]+1 /* (set! map/anonymous ...) */,C_fix((C_word)MAP_ANONYMOUS));
t138=C_mutate2((C_word*)lf[339]+1 /* (set! map-file-to-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5760,a[2]=((C_word)li148),tmp=(C_word)a,a+=3,tmp));
t139=C_mutate2((C_word*)lf[344]+1 /* (set! unmap-file-from-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5816,a[2]=((C_word)li149),tmp=(C_word)a,a+=3,tmp));
t140=C_mutate2((C_word*)lf[346]+1 /* (set! memory-mapped-file-pointer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5849,a[2]=((C_word)li150),tmp=(C_word)a,a+=3,tmp));
t141=C_mutate2((C_word*)lf[347]+1 /* (set! memory-mapped-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5858,a[2]=((C_word)li151),tmp=(C_word)a,a+=3,tmp));
t142=C_mutate2((C_word*)lf[348]+1 /* (set! change-directory* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5864,a[2]=((C_word)li152),tmp=(C_word)a,a+=3,tmp));
t143=C_mutate2((C_word*)lf[350]+1 /* (set! change-file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5870,a[2]=((C_word)li153),tmp=(C_word)a,a+=3,tmp));
t144=C_mutate2((C_word*)lf[351]+1 /* (set! create-fifo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5876,a[2]=((C_word)li154),tmp=(C_word)a,a+=3,tmp));
t145=C_mutate2((C_word*)lf[352]+1 /* (set! create-session ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5882,a[2]=((C_word)li155),tmp=(C_word)a,a+=3,tmp));
t146=C_mutate2((C_word*)lf[353]+1 /* (set! create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5888,a[2]=((C_word)li156),tmp=(C_word)a,a+=3,tmp));
t147=C_mutate2((C_word*)lf[354]+1 /* (set! current-effective-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5894,a[2]=((C_word)li157),tmp=(C_word)a,a+=3,tmp));
t148=C_mutate2((C_word*)lf[355]+1 /* (set! current-effective-user-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5900,a[2]=((C_word)li158),tmp=(C_word)a,a+=3,tmp));
t149=C_mutate2((C_word*)lf[356]+1 /* (set! current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5906,a[2]=((C_word)li159),tmp=(C_word)a,a+=3,tmp));
t150=C_mutate2((C_word*)lf[357]+1 /* (set! current-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5912,a[2]=((C_word)li160),tmp=(C_word)a,a+=3,tmp));
t151=C_mutate2((C_word*)lf[358]+1 /* (set! current-user-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5918,a[2]=((C_word)li161),tmp=(C_word)a,a+=3,tmp));
t152=C_mutate2((C_word*)lf[359]+1 /* (set! file-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5924,a[2]=((C_word)li162),tmp=(C_word)a,a+=3,tmp));
t153=C_mutate2((C_word*)lf[360]+1 /* (set! file-lock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5930,a[2]=((C_word)li163),tmp=(C_word)a,a+=3,tmp));
t154=C_mutate2((C_word*)lf[361]+1 /* (set! file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5936,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t155=C_mutate2((C_word*)lf[362]+1 /* (set! file-select ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5942,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t156=C_mutate2((C_word*)lf[363]+1 /* (set! file-test-lock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5948,a[2]=((C_word)li166),tmp=(C_word)a,a+=3,tmp));
t157=C_mutate2((C_word*)lf[364]+1 /* (set! file-truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5954,a[2]=((C_word)li167),tmp=(C_word)a,a+=3,tmp));
t158=C_mutate2((C_word*)lf[365]+1 /* (set! file-unlock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5960,a[2]=((C_word)li168),tmp=(C_word)a,a+=3,tmp));
t159=C_mutate2((C_word*)lf[366]+1 /* (set! get-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5966,a[2]=((C_word)li169),tmp=(C_word)a,a+=3,tmp));
t160=C_mutate2((C_word*)lf[367]+1 /* (set! group-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5972,a[2]=((C_word)li170),tmp=(C_word)a,a+=3,tmp));
t161=C_mutate2((C_word*)lf[368]+1 /* (set! initialize-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5978,a[2]=((C_word)li171),tmp=(C_word)a,a+=3,tmp));
t162=C_mutate2((C_word*)lf[369]+1 /* (set! parent-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5984,a[2]=((C_word)li172),tmp=(C_word)a,a+=3,tmp));
t163=C_mutate2((C_word*)lf[370]+1 /* (set! process-fork ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5990,a[2]=((C_word)li173),tmp=(C_word)a,a+=3,tmp));
t164=C_mutate2((C_word*)lf[371]+1 /* (set! process-group-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5996,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t165=C_mutate2((C_word*)lf[372]+1 /* (set! process-signal ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6002,a[2]=((C_word)li175),tmp=(C_word)a,a+=3,tmp));
t166=C_mutate2((C_word*)lf[373]+1 /* (set! read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6008,a[2]=((C_word)li176),tmp=(C_word)a,a+=3,tmp));
t167=C_mutate2((C_word*)lf[374]+1 /* (set! set-alarm! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6014,a[2]=((C_word)li177),tmp=(C_word)a,a+=3,tmp));
t168=C_mutate2((C_word*)lf[375]+1 /* (set! set-group-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6020,a[2]=((C_word)li178),tmp=(C_word)a,a+=3,tmp));
t169=C_mutate2((C_word*)lf[376]+1 /* (set! set-groups! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6026,a[2]=((C_word)li179),tmp=(C_word)a,a+=3,tmp));
t170=C_mutate2((C_word*)lf[377]+1 /* (set! set-process-group-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6032,a[2]=((C_word)li180),tmp=(C_word)a,a+=3,tmp));
t171=C_mutate2((C_word*)lf[378]+1 /* (set! set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6038,a[2]=((C_word)li181),tmp=(C_word)a,a+=3,tmp));
t172=C_mutate2((C_word*)lf[379]+1 /* (set! set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6044,a[2]=((C_word)li182),tmp=(C_word)a,a+=3,tmp));
t173=C_mutate2((C_word*)lf[380]+1 /* (set! set-user-id! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6050,a[2]=((C_word)li183),tmp=(C_word)a,a+=3,tmp));
t174=C_mutate2((C_word*)lf[381]+1 /* (set! signal-mask ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6056,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp));
t175=C_mutate2((C_word*)lf[382]+1 /* (set! signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6062,a[2]=((C_word)li185),tmp=(C_word)a,a+=3,tmp));
t176=C_mutate2((C_word*)lf[383]+1 /* (set! signal-masked? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6068,a[2]=((C_word)li186),tmp=(C_word)a,a+=3,tmp));
t177=C_mutate2((C_word*)lf[384]+1 /* (set! signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6074,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp));
t178=C_mutate2((C_word*)lf[385]+1 /* (set! terminal-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6080,a[2]=((C_word)li188),tmp=(C_word)a,a+=3,tmp));
t179=C_mutate2((C_word*)lf[386]+1 /* (set! user-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6086,a[2]=((C_word)li189),tmp=(C_word)a,a+=3,tmp));
t180=C_mutate2((C_word*)lf[387]+1 /* (set! utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6092,a[2]=((C_word)li190),tmp=(C_word)a,a+=3,tmp));
t181=C_mutate2((C_word*)lf[388]+1 /* (set! string->time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6098,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp));
t182=C_set_block_item(lf[389] /* errno/wouldblock */,0,C_fix(0));
t183=C_mutate2((C_word*)lf[38]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6105,a[2]=((C_word)li192),tmp=(C_word)a,a+=3,tmp));
t184=C_set_block_item(lf[390] /* open/fsync */,0,C_fix(0));
t185=C_set_block_item(lf[391] /* open/noctty */,0,C_fix(0));
t186=C_set_block_item(lf[392] /* open/nonblock */,0,C_fix(0));
t187=C_set_block_item(lf[393] /* open/sync */,0,C_fix(0));
t188=C_set_block_item(lf[394] /* perm/isgid */,0,C_fix(0));
t189=C_set_block_item(lf[395] /* perm/isuid */,0,C_fix(0));
t190=C_set_block_item(lf[396] /* perm/isvtx */,0,C_fix(0));
t191=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t191+1)))(2,t191,C_SCHEME_UNDEFINED);}

/* create-directory in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_4005(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f_4005r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4005r(t0,t1,t2,t3);}}

static void C_ccall f_4005r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(4);
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=C_i_check_string_2(t2,lf[175]);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4015,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm:877: ##sys#expand-home-path */
((C_proc3)C_fast_retrieve_proc(*((C_word*)lf[14]+1)))(3,*((C_word*)lf[14]+1),t8,t2);}

/* k3598 in k3594 in scan in k3560 in loop in get-environment-variables in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3600(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3600,2,t0,t1);}
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],t1);
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3588,a[2]=((C_word*)t0)[3],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
/* posix-common.scm:582: loop */
t6=((C_word*)((C_word*)t0)[5])[1];
f_3558(t6,t4,t5);}

/* system-information in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5667(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5667,2,t0,t1);}
if(C_truep(C_sysinfo())){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5678,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5693,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1423: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t2);}}

/* get-host-name in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5655(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5655,2,t0,t1);}
if(C_truep(C_get_hostname())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
/* posixwin.scm:1413: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[323],lf[324]);}}

/* sleep in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5649(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5649,3,t0,t1,t2);}
t3=C_i_check_exact_2(t2,lf[322]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_sleep(t2));}

/* k3804 in file-read in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3806(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3806,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3809,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t2))){
if(C_truep(C_byteblockp(t2))){
t4=t3;
f_3809(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm:763: ##sys#signal-hook */
t4=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t3,lf[15],lf[157],lf[159],t2);}}
else{
/* posixwin.scm:763: ##sys#signal-hook */
t4=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t3,lf[15],lf[157],lf[159],t2);}}

/* k3807 in k3804 in file-read in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3809(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3809,2,t0,t1);}
t2=C_read(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3812,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3821,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm:766: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t5);}
else{
t5=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_a_i_list2(&a,2,((C_word*)t0)[3],t2));}}

/* ##sys#process-wait in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5637(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5637,4,t0,t1,t2,t3);}
if(C_truep(C_process_wait(t2,t3))){
/* posixwin.scm:1397: values */
C_values(5,0,t1,t2,C_SCHEME_TRUE,C_fix((C_word)C_exstatus));}
else{
/* posixwin.scm:1398: values */
C_values(5,0,t1,C_fix(-1),C_SCHEME_FALSE,C_SCHEME_FALSE);}}

/* process-wait in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3641(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_3641r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3641r(t0,t1,t2);}}

static void C_ccall f_3641r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a=C_alloc(9);
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_i_cdr(t2));
t7=C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:C_i_car(t6));
t9=t8;
t10=C_i_nullp(t6);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t6));
t12=(C_truep(t4)?t4:C_fix(-1));
t13=t12;
t14=C_i_check_exact_2(t13,lf[124]);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3665,a[2]=t13,a[3]=t9,a[4]=((C_word)li64),tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3671,a[2]=t13,a[3]=((C_word)li65),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:611: ##sys#call-with-values */
C_call_with_values(4,0,t1,t15,t16);}

/* k3420 in k3414 in k3410 in local-time->seconds in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3422(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posix-common.scm:538: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[110],lf[111],((C_word*)t0)[3]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[4]);}}

/* k5688 in k5684 in k5680 in k5676 in system-information in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5690(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5690,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_i_list5(&a,5,lf[326],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1));}

/* k5691 in system-information in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5693(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm:1424: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[325],lf[327]);}

/* current-process-id in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3635(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3635,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fudge(C_fix(33)));}

/* k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3633(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word ab[50],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3633,2,t0,t1);}
t2=C_mutate2((C_word*)lf[122]+1 /* (set! signal-handler ...) */,t1);
t3=C_mutate2((C_word*)lf[123]+1 /* (set! current-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3635,a[2]=((C_word)li63),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[124]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3641,a[2]=((C_word)li66),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[128]+1 /* (set! pipe/buf ...) */,C_fix((C_word)PIPE_BUF));
t6=C_mutate2((C_word*)lf[129]+1 /* (set! open/rdonly ...) */,C_fix((C_word)O_RDONLY));
t7=C_mutate2((C_word*)lf[130]+1 /* (set! open/wronly ...) */,C_fix((C_word)O_WRONLY));
t8=C_mutate2((C_word*)lf[131]+1 /* (set! open/rdwr ...) */,C_fix((C_word)O_RDWR));
t9=C_mutate2((C_word*)lf[132]+1 /* (set! open/read ...) */,C_fix((C_word)O_RDWR));
t10=C_mutate2((C_word*)lf[133]+1 /* (set! open/write ...) */,C_fix((C_word)O_WRONLY));
t11=C_mutate2((C_word*)lf[134]+1 /* (set! open/creat ...) */,C_fix((C_word)O_CREAT));
t12=C_mutate2((C_word*)lf[135]+1 /* (set! open/append ...) */,C_fix((C_word)O_APPEND));
t13=C_mutate2((C_word*)lf[136]+1 /* (set! open/excl ...) */,C_fix((C_word)O_EXCL));
t14=C_mutate2((C_word*)lf[137]+1 /* (set! open/trunc ...) */,C_fix((C_word)O_TRUNC));
t15=C_mutate2((C_word*)lf[138]+1 /* (set! open/binary ...) */,C_fix((C_word)O_BINARY));
t16=C_mutate2((C_word*)lf[139]+1 /* (set! open/text ...) */,C_fix((C_word)O_TEXT));
t17=C_mutate2((C_word*)lf[140]+1 /* (set! open/noinherit ...) */,C_fix((C_word)O_NOINHERIT));
t18=C_mutate2((C_word*)lf[141]+1 /* (set! perm/irusr ...) */,C_fix((C_word)S_IREAD));
t19=C_mutate2((C_word*)lf[142]+1 /* (set! perm/iwusr ...) */,C_fix((C_word)S_IWRITE));
t20=C_mutate2((C_word*)lf[143]+1 /* (set! perm/ixusr ...) */,C_fix((C_word)S_IEXEC));
t21=C_mutate2((C_word*)lf[144]+1 /* (set! perm/irgrp ...) */,C_fix((C_word)S_IREAD));
t22=C_mutate2((C_word*)lf[145]+1 /* (set! perm/iwgrp ...) */,C_fix((C_word)S_IWRITE));
t23=C_mutate2((C_word*)lf[146]+1 /* (set! perm/ixgrp ...) */,C_fix((C_word)S_IEXEC));
t24=C_mutate2((C_word*)lf[147]+1 /* (set! perm/iroth ...) */,C_fix((C_word)S_IREAD));
t25=C_mutate2((C_word*)lf[148]+1 /* (set! perm/iwoth ...) */,C_fix((C_word)S_IWRITE));
t26=C_mutate2((C_word*)lf[149]+1 /* (set! perm/ixoth ...) */,C_fix((C_word)S_IEXEC));
t27=C_mutate2((C_word*)lf[150]+1 /* (set! perm/irwxu ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t28=C_mutate2((C_word*)lf[151]+1 /* (set! perm/irwxg ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t29=C_mutate2((C_word*)lf[152]+1 /* (set! perm/irwxo ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t30=C_fixnum_or(C_fix((C_word)S_IREAD),C_fix((C_word)S_IREAD));
t31=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC),t30);
t32=t31;
t33=C_mutate2((C_word*)lf[153]+1 /* (set! file-open ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3738,a[2]=t32,a[3]=((C_word)li67),tmp=(C_word)a,a+=4,tmp));
t34=C_mutate2((C_word*)lf[155]+1 /* (set! file-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3777,a[2]=((C_word)li68),tmp=(C_word)a,a+=3,tmp));
t35=C_mutate2((C_word*)lf[157]+1 /* (set! file-read ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3796,a[2]=((C_word)li69),tmp=(C_word)a,a+=3,tmp));
t36=C_mutate2((C_word*)lf[160]+1 /* (set! file-write ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3840,a[2]=((C_word)li70),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate2((C_word*)lf[163]+1 /* (set! file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3880,a[2]=((C_word)li71),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate2((C_word*)lf[165]+1 /* (set! seek/set ...) */,C_fix((C_word)SEEK_SET));
t39=C_mutate2((C_word*)lf[166]+1 /* (set! seek/end ...) */,C_fix((C_word)SEEK_END));
t40=C_mutate2((C_word*)lf[167]+1 /* (set! seek/cur ...) */,C_fix((C_word)SEEK_CUR));
t41=C_mutate2((C_word*)lf[35]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3918,a[2]=((C_word)li72),tmp=(C_word)a,a+=3,tmp));
t42=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f6918,a[2]=((C_word)li73),tmp=(C_word)a,a+=3,tmp);
t43=C_mutate2((C_word*)lf[37]+1 /* (set! character-device? ...) */,t42);
t44=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f6912,a[2]=((C_word)li74),tmp=(C_word)a,a+=3,tmp);
t45=C_mutate2((C_word*)lf[36]+1 /* (set! block-device? ...) */,t44);
t46=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f6906,a[2]=((C_word)li75),tmp=(C_word)a,a+=3,tmp);
t47=C_mutate2((C_word*)lf[38]+1 /* (set! fifo? ...) */,t46);
t48=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f6900,a[2]=((C_word)li76),tmp=(C_word)a,a+=3,tmp);
t49=C_mutate2((C_word*)lf[39]+1 /* (set! socket? ...) */,t48);
t50=C_mutate2((C_word*)lf[168]+1 /* (set! set-file-position! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3947,a[2]=((C_word)li77),tmp=(C_word)a,a+=3,tmp));
t51=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4003,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t52=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6115,a[2]=((C_word)li193),tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:836: getter-with-setter */
t53=*((C_word*)lf[399]+1);
((C_proc5)(void*)(*((C_word*)t53+1)))(5,t53,t51,t52,*((C_word*)lf[168]+1),lf[400]);}

/* current-user-name in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5698(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5698,2,t0,t1);}
if(C_truep(C_get_user_name())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_username),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5708,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm:1432: ##sys#update-errno */
((C_proc2)C_fast_retrieve_proc(*((C_word*)lf[7]+1)))(2,*((C_word*)lf[7]+1),t2);}}

/* k5680 in k5676 in system-information in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5682(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5682,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5686,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_osver),C_fix(0));}

/* k5684 in k5680 in k5676 in system-information in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5686(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5686,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5690,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_processor),C_fix(0));}

/* f_3240 in k3263 in k3260 in k3257 in k3254 in k3251 in k3248 in find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3240(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3240,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]));}

/* find-files in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_3246(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_3246r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3246r(t0,t1,t2,t3);}}

static void C_ccall f_3246r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(8);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3250,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3290,a[2]=((C_word)li49),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:484: ##sys#get-keyword */
((C_proc5)C_fast_retrieve_proc(*((C_word*)lf[96]+1)))(5,*((C_word*)lf[96]+1),t4,lf[100],t3,t5);}

/* k5676 in system-information in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_ccall f_5678(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5678,2,t0,t1);}
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5682,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,C_mpointer(&a,(void*)C_osrel),C_fix(0));}

/* k4819 in k4810 in k4807 in set-buffering-mode! in k4001 in k3631 in k3295 in k2325 in k2231 in k2228 in k2225 in k2222 in k2219 */
static void C_fcall f_4821(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm:1212: ##sys#error */
t2=*((C_word*)lf[45]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[2],lf[286],lf[287],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[446] = {
{"f_4812:posixwin_2escm",(void*)f_4812},
{"f_3671:posixwin_2escm",(void*)f_3671},
{"f_4803:posixwin_2escm",(void*)f_4803},
{"f_2446:posixwin_2escm",(void*)f_2446},
{"f_3665:posixwin_2escm",(void*)f_3665},
{"f_2474:posixwin_2escm",(void*)f_2474},
{"f_2476:posixwin_2escm",(void*)f_2476},
{"f_4809:posixwin_2escm",(void*)f_4809},
{"f_2464:posixwin_2escm",(void*)f_2464},
{"f_2466:posixwin_2escm",(void*)f_2466},
{"f_2496:posixwin_2escm",(void*)f_2496},
{"f_2494:posixwin_2escm",(void*)f_2494},
{"f_6131:posixwin_2escm",(void*)f_6131},
{"f_5776:posixwin_2escm",(void*)f_5776},
{"f_5770:posixwin_2escm",(void*)f_5770},
{"f_2291:posixwin_2escm",(void*)f_2291},
{"f_5767:posixwin_2escm",(void*)f_5767},
{"f_2298:posixwin_2escm",(void*)f_2298},
{"f_2800:posixwin_2escm",(void*)f_2800},
{"f_2804:posixwin_2escm",(void*)f_2804},
{"f_5764:posixwin_2escm",(void*)f_5764},
{"f_5760:posixwin_2escm",(void*)f_5760},
{"f_6119:posixwin_2escm",(void*)f_6119},
{"f_6115:posixwin_2escm",(void*)f_6115},
{"f_2456:posixwin_2escm",(void*)f_2456},
{"f_2454:posixwin_2escm",(void*)f_2454},
{"f_6122:posixwin_2escm",(void*)f_6122},
{"f_2233:posixwin_2escm",(void*)f_2233},
{"f_2230:posixwin_2escm",(void*)f_2230},
{"f_4521:posixwin_2escm",(void*)f_4521},
{"f_2822:posixwin_2escm",(void*)f_2822},
{"f_2983:posixwin_2escm",(void*)f_2983},
{"f_2825:posixwin_2escm",(void*)f_2825},
{"f_2981:posixwin_2escm",(void*)f_2981},
{"f_2829:posixwin_2escm",(void*)f_2829},
{"f_5782:posixwin_2escm",(void*)f_5782},
{"f_2221:posixwin_2escm",(void*)f_2221},
{"f_2227:posixwin_2escm",(void*)f_2227},
{"f_2224:posixwin_2escm",(void*)f_2224},
{"f_2819:posixwin_2escm",(void*)f_2819},
{"f_2256:posixwin_2escm",(void*)f_2256},
{"f_6105:posixwin_2escm",(void*)f_6105},
{"f_4277:posixwin_2escm",(void*)f_4277},
{"f_2624:posixwin_2escm",(void*)f_2624},
{"f_4270:posixwin_2escm",(void*)f_4270},
{"f_6156:posixwin_2escm",(void*)f_6156},
{"f_2245:posixwin_2escm",(void*)f_2245},
{"f_2249:posixwin_2escm",(void*)f_2249},
{"f_5577:posixwin_2escm",(void*)f_5577},
{"f6918:posixwin_2escm",(void*)f6918},
{"f_6165:posixwin_2escm",(void*)f_6165},
{"f_4261:posixwin_2escm",(void*)f_4261},
{"f6912:posixwin_2escm",(void*)f6912},
{"f_2943:posixwin_2escm",(void*)f_2943},
{"f_2949:posixwin_2escm",(void*)f_2949},
{"f_2486:posixwin_2escm",(void*)f_2486},
{"f_2484:posixwin_2escm",(void*)f_2484},
{"f6906:posixwin_2escm",(void*)f6906},
{"f_4251:posixwin_2escm",(void*)f_4251},
{"f6900:posixwin_2escm",(void*)f6900},
{"f_2974:posixwin_2escm",(void*)f_2974},
{"f_2970:posixwin_2escm",(void*)f_2970},
{"f_4244:posixwin_2escm",(void*)f_4244},
{"f_4989:posixwin_2escm",(void*)f_4989},
{"f_2964:posixwin_2escm",(void*)f_2964},
{"f_3618:posixwin_2escm",(void*)f_3618},
{"f_6196:posixwin_2escm",(void*)f_6196},
{"f_4230:posixwin_2escm",(void*)f_4230},
{"f_6190:posixwin_2escm",(void*)f_6190},
{"f_4977:posixwin_2escm",(void*)f_4977},
{"f_2913:posixwin_2escm",(void*)f_2913},
{"f_2615:posixwin_2escm",(void*)f_2615},
{"f_4221:posixwin_2escm",(void*)f_4221},
{"f_4968:posixwin_2escm",(void*)f_4968},
{"f_4422:posixwin_2escm",(void*)f_4422},
{"f_4438:posixwin_2escm",(void*)f_4438},
{"f_4956:posixwin_2escm",(void*)f_4956},
{"f_4429:posixwin_2escm",(void*)f_4429},
{"f_4947:posixwin_2escm",(void*)f_4947},
{"f_4939:posixwin_2escm",(void*)f_4939},
{"f_4569:posixwin_2escm",(void*)f_4569},
{"f_4561:posixwin_2escm",(void*)f_4561},
{"f_5073:posixwin_2escm",(void*)f_5073},
{"f_5077:posixwin_2escm",(void*)f_5077},
{"f_4551:posixwin_2escm",(void*)f_4551},
{"f_2260:posixwin_2escm",(void*)f_2260},
{"f_4913:posixwin_2escm",(void*)f_4913},
{"f_2267:posixwin_2escm",(void*)f_2267},
{"f_2263:posixwin_2escm",(void*)f_2263},
{"f_2869:posixwin_2escm",(void*)f_2869},
{"f_2857:posixwin_2escm",(void*)f_2857},
{"f_4549:posixwin_2escm",(void*)f_4549},
{"f_4545:posixwin_2escm",(void*)f_4545},
{"f_5053:posixwin_2escm",(void*)f_5053},
{"f_5050:posixwin_2escm",(void*)f_5050},
{"f_5088:posixwin_2escm",(void*)f_5088},
{"f_4298:posixwin_2escm",(void*)f_4298},
{"f_4295:posixwin_2escm",(void*)f_4295},
{"f_5037:posixwin_2escm",(void*)f_5037},
{"f_5060:posixwin_2escm",(void*)f_5060},
{"f_5064:posixwin_2escm",(void*)f_5064},
{"f_4870:posixwin_2escm",(void*)f_4870},
{"f_4288:posixwin_2escm",(void*)f_4288},
{"f_4280:posixwin_2escm",(void*)f_4280},
{"f_4884:posixwin_2escm",(void*)f_4884},
{"f_4573:posixwin_2escm",(void*)f_4573},
{"f_4575:posixwin_2escm",(void*)f_4575},
{"f_4417:posixwin_2escm",(void*)f_4417},
{"f_4412:posixwin_2escm",(void*)f_4412},
{"f_5912:posixwin_2escm",(void*)f_5912},
{"f_5044:posixwin_2escm",(void*)f_5044},
{"f_2657:posixwin_2escm",(void*)f_2657},
{"f_2654:posixwin_2escm",(void*)f_2654},
{"f_5047:posixwin_2escm",(void*)f_5047},
{"f_4408:posixwin_2escm",(void*)f_4408},
{"f_4402:posixwin_2escm",(void*)f_4402},
{"f_2647:posixwin_2escm",(void*)f_2647},
{"f_2641:posixwin_2escm",(void*)f_2641},
{"f_5020:posixwin_2escm",(void*)f_5020},
{"f_4537:posixwin_2escm",(void*)f_4537},
{"f_2879:posixwin_2escm",(void*)f_2879},
{"f_5001:posixwin_2escm",(void*)f_5001},
{"f_5433:posixwin_2escm",(void*)f_5433},
{"f_5435:posixwin_2escm",(void*)f_5435},
{"f_4596:posixwin_2escm",(void*)f_4596},
{"f_4211:posixwin_2escm",(void*)f_4211},
{"f_5422:posixwin_2escm",(void*)f_5422},
{"f_4587:posixwin_2escm",(void*)f_4587},
{"f_4204:posixwin_2escm",(void*)f_4204},
{"f_4581:posixwin_2escm",(void*)f_4581},
{"f_5490:posixwin_2escm",(void*)f_5490},
{"f_2843:posixwin_2escm",(void*)f_2843},
{"f_5484:posixwin_2escm",(void*)f_5484},
{"f_2674:posixwin_2escm",(void*)f_2674},
{"f_5816:posixwin_2escm",(void*)f_5816},
{"f_3318:posixwin_2escm",(void*)f_3318},
{"f_5440:posixwin_2escm",(void*)f_5440},
{"f_5449:posixwin_2escm",(void*)f_5449},
{"f_2690:posixwin_2escm",(void*)f_2690},
{"f_3570:posixwin_2escm",(void*)f_3570},
{"f_2687:posixwin_2escm",(void*)f_2687},
{"f_5823:posixwin_2escm",(void*)f_5823},
{"f_3562:posixwin_2escm",(void*)f_3562},
{"f_3596:posixwin_2escm",(void*)f_3596},
{"f_5402:posixwin_2escm",(void*)f_5402},
{"f_3588:posixwin_2escm",(void*)f_3588},
{"f_5406:posixwin_2escm",(void*)f_5406},
{"f_3343:posixwin_2escm",(void*)f_3343},
{"f_5984:posixwin_2escm",(void*)f_5984},
{"f_5476:posixwin_2escm",(void*)f_5476},
{"f_3532:posixwin_2escm",(void*)f_3532},
{"f_3530:posixwin_2escm",(void*)f_3530},
{"f_5479:posixwin_2escm",(void*)f_5479},
{"f_5996:posixwin_2escm",(void*)f_5996},
{"f_3374:posixwin_2escm",(void*)f_3374},
{"f_3370:posixwin_2escm",(void*)f_3370},
{"f_3558:posixwin_2escm",(void*)f_3558},
{"f_3552:posixwin_2escm",(void*)f_3552},
{"f_3540:posixwin_2escm",(void*)f_3540},
{"f_3113:posixwin_2escm",(void*)f_3113},
{"f_3110:posixwin_2escm",(void*)f_3110},
{"f_3380:posixwin_2escm",(void*)f_3380},
{"f_5942:posixwin_2escm",(void*)f_5942},
{"f_3777:posixwin_2escm",(void*)f_3777},
{"f_3771:posixwin_2escm",(void*)f_3771},
{"f_5972:posixwin_2escm",(void*)f_5972},
{"f_5948:posixwin_2escm",(void*)f_5948},
{"f_5960:posixwin_2escm",(void*)f_5960},
{"f_3515:posixwin_2escm",(void*)f_3515},
{"f_5978:posixwin_2escm",(void*)f_5978},
{"f_5990:posixwin_2escm",(void*)f_5990},
{"f_3507:posixwin_2escm",(void*)f_3507},
{"f_5966:posixwin_2escm",(void*)f_5966},
{"f_3972:posixwin_2escm",(void*)f_3972},
{"f_5906:posixwin_2escm",(void*)f_5906},
{"f_5900:posixwin_2escm",(void*)f_5900},
{"f_5918:posixwin_2escm",(void*)f_5918},
{"f_5864:posixwin_2escm",(void*)f_5864},
{"f_3966:posixwin_2escm",(void*)f_3966},
{"f_3960:posixwin_2escm",(void*)f_3960},
{"f_5936:posixwin_2escm",(void*)f_5936},
{"f_5930:posixwin_2escm",(void*)f_5930},
{"f_3177:posixwin_2escm",(void*)f_3177},
{"f_3910:posixwin_2escm",(void*)f_3910},
{"f_3918:posixwin_2escm",(void*)f_3918},
{"f_5924:posixwin_2escm",(void*)f_5924},
{"f_3758:posixwin_2escm",(void*)f_3758},
{"f_3755:posixwin_2escm",(void*)f_3755},
{"f_3161:posixwin_2escm",(void*)f_3161},
{"f_6086:posixwin_2escm",(void*)f_6086},
{"f_6080:posixwin_2escm",(void*)f_6080},
{"f_3167:posixwin_2escm",(void*)f_3167},
{"f_3900:posixwin_2escm",(void*)f_3900},
{"f_5849:posixwin_2escm",(void*)f_5849},
{"f_5954:posixwin_2escm",(void*)f_5954},
{"f_3193:posixwin_2escm",(void*)f_3193},
{"f_6098:posixwin_2escm",(void*)f_6098},
{"f_6092:posixwin_2escm",(void*)f_6092},
{"f_3199:posixwin_2escm",(void*)f_3199},
{"f_3186:posixwin_2escm",(void*)f_3186},
{"f_3180:posixwin_2escm",(void*)f_3180},
{"f_3339:posixwin_2escm",(void*)f_3339},
{"f_6212:posixwin_2escm",(void*)f_6212},
{"f_3132:posixwin_2escm",(void*)f_3132},
{"f_3134:posixwin_2escm",(void*)f_3134},
{"f_3139:posixwin_2escm",(void*)f_3139},
{"f_4711:posixwin_2escm",(void*)f_4711},
{"f_4713:posixwin_2escm",(void*)f_4713},
{"f_3322:posixwin_2escm",(void*)f_3322},
{"f_6222:posixwin_2escm",(void*)f_6222},
{"f_3796:posixwin_2escm",(void*)f_3796},
{"f_3122:posixwin_2escm",(void*)f_3122},
{"f_6044:posixwin_2escm",(void*)f_6044},
{"f_3790:posixwin_2escm",(void*)f_3790},
{"f_2353:posixwin_2escm",(void*)f_2353},
{"f_2351:posixwin_2escm",(void*)f_2351},
{"f_2357:posixwin_2escm",(void*)f_2357},
{"f_2359:posixwin_2escm",(void*)f_2359},
{"f_6235:posixwin_2escm",(void*)f_6235},
{"f_3151:posixwin_2escm",(void*)f_3151},
{"f_3154:posixwin_2escm",(void*)f_3154},
{"f_3742:posixwin_2escm",(void*)f_3742},
{"f_6056:posixwin_2escm",(void*)f_6056},
{"f_6050:posixwin_2escm",(void*)f_6050},
{"f_2341:posixwin_2escm",(void*)f_2341},
{"f_2347:posixwin_2escm",(void*)f_2347},
{"f_2345:posixwin_2escm",(void*)f_2345},
{"f_4729:posixwin_2escm",(void*)f_4729},
{"f_6062:posixwin_2escm",(void*)f_6062},
{"f_3738:posixwin_2escm",(void*)f_3738},
{"f_3147:posixwin_2escm",(void*)f_3147},
{"f_6068:posixwin_2escm",(void*)f_6068},
{"f_4720:posixwin_2escm",(void*)f_4720},
{"f_4723:posixwin_2escm",(void*)f_4723},
{"f_2378:posixwin_2escm",(void*)f_2378},
{"f_3526:posixwin_2escm",(void*)f_3526},
{"f_6074:posixwin_2escm",(void*)f_6074},
{"f_3764:posixwin_2escm",(void*)f_3764},
{"f_5894:posixwin_2escm",(void*)f_5894},
{"f_6002:posixwin_2escm",(void*)f_6002},
{"f_6008:posixwin_2escm",(void*)f_6008},
{"f_5870:posixwin_2escm",(void*)f_5870},
{"f_6014:posixwin_2escm",(void*)f_6014},
{"f_5876:posixwin_2escm",(void*)f_5876},
{"f_6200:posixwin_2escm",(void*)f_6200},
{"f_6202:posixwin_2escm",(void*)f_6202},
{"f_6020:posixwin_2escm",(void*)f_6020},
{"f_6026:posixwin_2escm",(void*)f_6026},
{"f_2333:posixwin_2escm",(void*)f_2333},
{"f_2335:posixwin_2escm",(void*)f_2335},
{"f_2339:posixwin_2escm",(void*)f_2339},
{"f_6032:posixwin_2escm",(void*)f_6032},
{"f_6038:posixwin_2escm",(void*)f_6038},
{"f_3951:posixwin_2escm",(void*)f_3951},
{"f_2327:posixwin_2escm",(void*)f_2327},
{"f_2329:posixwin_2escm",(void*)f_2329},
{"f_5858:posixwin_2escm",(void*)f_5858},
{"f_2714:posixwin_2escm",(void*)f_2714},
{"f_2718:posixwin_2escm",(void*)f_2718},
{"f_3947:posixwin_2escm",(void*)f_3947},
{"f_5882:posixwin_2escm",(void*)f_5882},
{"f_5888:posixwin_2escm",(void*)f_5888},
{"f_2708:posixwin_2escm",(void*)f_2708},
{"f_4604:posixwin_2escm",(void*)f_4604},
{"f_2514:posixwin_2escm",(void*)f_2514},
{"f_4176:posixwin_2escm",(void*)f_4176},
{"f_2519:posixwin_2escm",(void*)f_2519},
{"f_4172:posixwin_2escm",(void*)f_4172},
{"f_4152:posixwin_2escm",(void*)f_4152},
{"f_4144:posixwin_2escm",(void*)f_4144},
{"f_4135:posixwin_2escm",(void*)f_4135},
{"f_4138:posixwin_2escm",(void*)f_4138},
{"f_4128:posixwin_2escm",(void*)f_4128},
{"f_2506:posixwin_2escm",(void*)f_2506},
{"f_2504:posixwin_2escm",(void*)f_2504},
{"f_4743:posixwin_2escm",(void*)f_4743},
{"f_4334:posixwin_2escm",(void*)f_4334},
{"f_4339:posixwin_2escm",(void*)f_4339},
{"f_4330:posixwin_2escm",(void*)f_4330},
{"f_2527:posixwin_2escm",(void*)f_2527},
{"f_4325:posixwin_2escm",(void*)f_4325},
{"f_4321:posixwin_2escm",(void*)f_4321},
{"f_4397:posixwin_2escm",(void*)f_4397},
{"f_4392:posixwin_2escm",(void*)f_4392},
{"f_4388:posixwin_2escm",(void*)f_4388},
{"f_4383:posixwin_2escm",(void*)f_4383},
{"f_2757:posixwin_2escm",(void*)f_2757},
{"f_2751:posixwin_2escm",(void*)f_2751},
{"f_2314:posixwin_2escm",(void*)f_2314},
{"f_2741:posixwin_2escm",(void*)f_2741},
{"f_2740:posixwin_2escm",(void*)f_2740},
{"f_2307:posixwin_2escm",(void*)f_2307},
{"f_2302:posixwin_2escm",(void*)f_2302},
{"f_4354:posixwin_2escm",(void*)f_4354},
{"f_4358:posixwin_2escm",(void*)f_4358},
{"f_2768:posixwin_2escm",(void*)f_2768},
{"f_2763:posixwin_2escm",(void*)f_2763},
{"f_4795:posixwin_2escm",(void*)f_4795},
{"f_4345:posixwin_2escm",(void*)f_4345},
{"f_4349:posixwin_2escm",(void*)f_4349},
{"f_5222:posixwin_2escm",(void*)f_5222},
{"f_5226:posixwin_2escm",(void*)f_5226},
{"f_4190:posixwin_2escm",(void*)f_4190},
{"f_4651:posixwin_2escm",(void*)f_4651},
{"f_4776:posixwin_2escm",(void*)f_4776},
{"f_4770:posixwin_2escm",(void*)f_4770},
{"f_4188:posixwin_2escm",(void*)f_4188},
{"f_4315:posixwin_2escm",(void*)f_4315},
{"f_4637:posixwin_2escm",(void*)f_4637},
{"f_4633:posixwin_2escm",(void*)f_4633},
{"f_4310:posixwin_2escm",(void*)f_4310},
{"f_4756:posixwin_2escm",(void*)f_4756},
{"f_4665:posixwin_2escm",(void*)f_4665},
{"f_4306:posixwin_2escm",(void*)f_4306},
{"f_4663:posixwin_2escm",(void*)f_4663},
{"f_5266:posixwin_2escm",(void*)f_5266},
{"f_4788:posixwin_2escm",(void*)f_4788},
{"f_4378:posixwin_2escm",(void*)f_4378},
{"f_4374:posixwin_2escm",(void*)f_4374},
{"f_5253:posixwin_2escm",(void*)f_5253},
{"f_2569:posixwin_2escm",(void*)f_2569},
{"f_4368:posixwin_2escm",(void*)f_4368},
{"f_4363:posixwin_2escm",(void*)f_4363},
{"f_5243:posixwin_2escm",(void*)f_5243},
{"f_5249:posixwin_2escm",(void*)f_5249},
{"f_2778:posixwin_2escm",(void*)f_2778},
{"f_5238:posixwin_2escm",(void*)f_5238},
{"f_3000:posixwin_2escm",(void*)f_3000},
{"f_3004:posixwin_2escm",(void*)f_3004},
{"f_4117:posixwin_2escm",(void*)f_4117},
{"f_4109:posixwin_2escm",(void*)f_4109},
{"f_2734:posixwin_2escm",(void*)f_2734},
{"f_2597:posixwin_2escm",(void*)f_2597},
{"f_2599:posixwin_2escm",(void*)f_2599},
{"f_3887:posixwin_2escm",(void*)f_3887},
{"f_3880:posixwin_2escm",(void*)f_3880},
{"f_3044:posixwin_2escm",(void*)f_3044},
{"f_4697:posixwin_2escm",(void*)f_4697},
{"f_4691:posixwin_2escm",(void*)f_4691},
{"f_5398:posixwin_2escm",(void*)f_5398},
{"f_4649:posixwin_2escm",(void*)f_4649},
{"f_5394:posixwin_2escm",(void*)f_5394},
{"f_3024:posixwin_2escm",(void*)f_3024},
{"f_5390:posixwin_2escm",(void*)f_5390},
{"f_2556:posixwin_2escm",(void*)f_2556},
{"f_4677:posixwin_2escm",(void*)f_4677},
{"f_4679:posixwin_2escm",(void*)f_4679},
{"f_5383:posixwin_2escm",(void*)f_5383},
{"f_3016:posixwin_2escm",(void*)f_3016},
{"f_3012:posixwin_2escm",(void*)f_3012},
{"f_5339:posixwin_2escm",(void*)f_5339},
{"f_2585:posixwin_2escm",(void*)f_2585},
{"f_2583:posixwin_2escm",(void*)f_2583},
{"f_3088:posixwin_2escm",(void*)f_3088},
{"f_3821:posixwin_2escm",(void*)f_3821},
{"f_2571:posixwin_2escm",(void*)f_2571},
{"toplevel:posixwin_2escm",(void*)C_posix_toplevel},
{"f_3812:posixwin_2escm",(void*)f_3812},
{"f_3206:posixwin_2escm",(void*)f_3206},
{"f_5353:posixwin_2escm",(void*)f_5353},
{"f_3060:posixwin_2escm",(void*)f_3060},
{"f_3067:posixwin_2escm",(void*)f_3067},
{"f_3069:posixwin_2escm",(void*)f_3069},
{"f_5346:posixwin_2escm",(void*)f_5346},
{"f_3057:posixwin_2escm",(void*)f_3057},
{"f_3862:posixwin_2escm",(void*)f_3862},
{"f_3416:posixwin_2escm",(void*)f_3416},
{"f_3213:posixwin_2escm",(void*)f_3213},
{"f_3412:posixwin_2escm",(void*)f_3412},
{"f_3856:posixwin_2escm",(void*)f_3856},
{"f_5177:posixwin_2escm",(void*)f_5177},
{"f_3850:posixwin_2escm",(void*)f_3850},
{"f_3408:posixwin_2escm",(void*)f_3408},
{"f_3847:posixwin_2escm",(void*)f_3847},
{"f_3840:posixwin_2escm",(void*)f_3840},
{"f_4084:posixwin_2escm",(void*)f_4084},
{"f_3223:posixwin_2escm",(void*)f_3223},
{"f_3224:posixwin_2escm",(void*)f_3224},
{"f_3460:posixwin_2escm",(void*)f_3460},
{"f_5708:posixwin_2escm",(void*)f_5708},
{"f_3469:posixwin_2escm",(void*)f_3469},
{"f_4074:posixwin_2escm",(void*)f_4074},
{"f_4051:posixwin_2escm",(void*)f_4051},
{"f_3250:posixwin_2escm",(void*)f_3250},
{"f_3453:posixwin_2escm",(void*)f_3453},
{"f_3253:posixwin_2escm",(void*)f_3253},
{"f_3256:posixwin_2escm",(void*)f_3256},
{"f_3259:posixwin_2escm",(void*)f_3259},
{"f_4040:posixwin_2escm",(void*)f_4040},
{"f_3893:posixwin_2escm",(void*)f_3893},
{"f_3284:posixwin_2escm",(void*)f_3284},
{"f_5285:posixwin_2escm",(void*)f_5285},
{"f_3282:posixwin_2escm",(void*)f_3282},
{"f_5281:posixwin_2escm",(void*)f_5281},
{"f_4059:posixwin_2escm",(void*)f_4059},
{"f_4032:posixwin_2escm",(void*)f_4032},
{"f_5155:posixwin_2escm",(void*)f_5155},
{"f_3232:posixwin_2escm",(void*)f_3232},
{"f_5270:posixwin_2escm",(void*)f_5270},
{"f_3265:posixwin_2escm",(void*)f_3265},
{"f_3262:posixwin_2escm",(void*)f_3262},
{"f_5511:posixwin_2escm",(void*)f_5511},
{"f_5517:posixwin_2escm",(void*)f_5517},
{"f_5515:posixwin_2escm",(void*)f_5515},
{"f_5371:posixwin_2escm",(void*)f_5371},
{"f_5367:posixwin_2escm",(void*)f_5367},
{"f_3290:posixwin_2escm",(void*)f_3290},
{"f_3292:posixwin_2escm",(void*)f_3292},
{"f_3297:posixwin_2escm",(void*)f_3297},
{"f_3299:posixwin_2escm",(void*)f_3299},
{"f_4027:posixwin_2escm",(void*)f_4027},
{"f_5363:posixwin_2escm",(void*)f_5363},
{"f_4023:posixwin_2escm",(void*)f_4023},
{"f_3486:posixwin_2escm",(void*)f_3486},
{"f_3483:posixwin_2escm",(void*)f_3483},
{"f_4018:posixwin_2escm",(void*)f_4018},
{"f_4015:posixwin_2escm",(void*)f_4015},
{"f_5110:posixwin_2escm",(void*)f_5110},
{"f_3276:posixwin_2escm",(void*)f_3276},
{"f_3273:posixwin_2escm",(void*)f_3273},
{"f_3270:posixwin_2escm",(void*)f_3270},
{"f_3279:posixwin_2escm",(void*)f_3279},
{"f_3479:posixwin_2escm",(void*)f_3479},
{"f_4003:posixwin_2escm",(void*)f_4003},
{"f_4005:posixwin_2escm",(void*)f_4005},
{"f_3600:posixwin_2escm",(void*)f_3600},
{"f_5667:posixwin_2escm",(void*)f_5667},
{"f_5655:posixwin_2escm",(void*)f_5655},
{"f_5649:posixwin_2escm",(void*)f_5649},
{"f_3806:posixwin_2escm",(void*)f_3806},
{"f_3809:posixwin_2escm",(void*)f_3809},
{"f_5637:posixwin_2escm",(void*)f_5637},
{"f_3641:posixwin_2escm",(void*)f_3641},
{"f_3422:posixwin_2escm",(void*)f_3422},
{"f_5690:posixwin_2escm",(void*)f_5690},
{"f_5693:posixwin_2escm",(void*)f_5693},
{"f_3635:posixwin_2escm",(void*)f_3635},
{"f_3633:posixwin_2escm",(void*)f_3633},
{"f_5698:posixwin_2escm",(void*)f_5698},
{"f_5682:posixwin_2escm",(void*)f_5682},
{"f_5686:posixwin_2escm",(void*)f_5686},
{"f_3240:posixwin_2escm",(void*)f_3240},
{"f_3246:posixwin_2escm",(void*)f_3246},
{"f_5678:posixwin_2escm",(void*)f_5678},
{"f_4821:posixwin_2escm",(void*)f_4821},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}

/*
S|applied compiler syntax:
S|  for-each		3
o|eliminated procedure checks: 157 
o|specializations:
o|  1 (##sys#check-list (or pair list) *)
o|  4 (##sys#foreign-fixnum-argument fixnum)
o|  1 (##sys#check-output-port * * *)
o|  1 (##sys#check-input-port * * *)
o|  1 (negative? fixnum)
o|  4 (cdr pair)
o|  1 (string-ref string fixnum)
o|  1 (string-length string)
o|  3 (make-string fixnum)
o|  4 (##sys#check-open-port * *)
o|  9 (eqv? * (not float))
o|  11 (car pair)
o|dropping redundant toplevel assignment: process 
o|dropping redundant toplevel assignment: process* 
o|safe globals: (file-stat ##sys#stat ##sys#posix-error posix-error c1513) 
o|Removed `not' forms: 7 
o|contracted procedure: "(posix-common.scm:179) strerror64" 
o|inlining procedure: k2268 
o|inlining procedure: k2268 
o|inlining procedure: k2283 
o|inlining procedure: k2283 
o|inlining procedure: k2373 
o|inlining procedure: k2385 
o|inlining procedure: k2385 
o|inlining procedure: k2397 
o|inlining procedure: k2397 
o|inlining procedure: k2409 
o|inlining procedure: k2409 
o|inlining procedure: k2373 
o|inlining procedure: k2525 
o|contracted procedure: k2541 
o|inlining procedure: k2538 
o|inlining procedure: k2538 
o|substituted constant variable: a2551 
o|inlining procedure: k2525 
o|inlining procedure: k2558 
o|inlining procedure: k2558 
o|substituted constant variable: a2602 
o|inlining procedure: k2603 
o|inlining procedure: k2603 
o|contracted procedure: k2619 
o|inlining procedure: k2622 
o|inlining procedure: k2622 
o|inlining procedure: k2655 
o|inlining procedure: k2655 
o|inlining procedure: k2679 
o|inlining procedure: k2679 
o|substituted constant variable: a2700 
o|inlining procedure: k2719 
o|inlining procedure: k2719 
o|inlining procedure: k2743 
o|propagated global variable: r27446270 delete-file 
o|inlining procedure: k2743 
o|inlining procedure: k2735 
o|inlining procedure: k2770 
o|inlining procedure: k2770 
o|inlining procedure: k2735 
o|inlining procedure: k2830 
o|inlining procedure: k2830 
o|inlining procedure: k2845 
o|inlining procedure: k2845 
o|inlining procedure: k2886 
o|inlining procedure: k2886 
o|substituted constant variable: a2908 
o|substituted constant variable: a2914 
o|inlining procedure: k2951 
o|inlining procedure: k2951 
o|inlining procedure: k2985 
o|inlining procedure: k2985 
o|inlining procedure: k3038 
o|inlining procedure: k3038 
o|inlining procedure: k3046 
o|inlining procedure: k3046 
o|contracted procedure: "(posix-common.scm:490) find-files" 
o|inlining procedure: k3071 
o|inlining procedure: k3071 
o|inlining procedure: k3089 
o|inlining procedure: k3089 
o|inlining procedure: k3108 
o|inlining procedure: k3108 
o|inlining procedure: k3117 
o|inlining procedure: k3149 
o|inlining procedure: k3149 
o|inlining procedure: k3163 
o|inlining procedure: k3163 
o|inlining procedure: k3117 
o|inlining procedure: k3175 
o|inlining procedure: k3175 
o|inlining procedure: k3194 
o|inlining procedure: k3194 
o|inlining procedure: k3215 
o|inlining procedure: k3215 
o|contracted procedure: k3229 
o|inlining procedure: k3234 
o|inlining procedure: k3234 
o|inlining procedure: k3304 
o|inlining procedure: k3304 
o|inlining procedure: k3381 
o|inlining procedure: k3381 
o|contracted procedure: "(posix-common.scm:527) ctime485" 
o|inlining procedure: k3417 
o|inlining procedure: k3417 
o|inlining procedure: k3461 
o|contracted procedure: "(posix-common.scm:550) strftime512" 
o|inlining procedure: k3447 
o|inlining procedure: k3447 
o|inlining procedure: k3461 
o|contracted procedure: "(posix-common.scm:552) asctime511" 
o|inlining procedure: k3434 
o|inlining procedure: k3434 
o|inlining procedure: k3563 
o|inlining procedure: k3572 
o|inlining procedure: k3572 
o|inlining procedure: k3563 
o|contracted procedure: "(posix-common.scm:576) get564" 
o|inlining procedure: k3673 
o|inlining procedure: k3673 
o|inlining procedure: k3756 
o|inlining procedure: k3756 
o|inlining procedure: k3782 
o|inlining procedure: k3782 
o|inlining procedure: k3810 
o|inlining procedure: k3810 
o|inlining procedure: k3854 
o|inlining procedure: k3854 
o|inlining procedure: k3961 
o|inlining procedure: k3961 
o|inlining procedure: k3973 
o|inlining procedure: k3973 
o|inlining procedure: k3983 
o|inlining procedure: k3983 
o|inlining procedure: k4016 
o|contracted procedure: "(posixwin.scm:879) g771772" 
o|contracted procedure: "(posixwin.scm:871) g789790" 
o|inlining procedure: k4035 
o|inlining procedure: k4035 
o|contracted procedure: "(posixwin.scm:863) g792793" 
o|inlining procedure: k4043 
o|inlining procedure: k4043 
o|inlining procedure: k4076 
o|inlining procedure: k4076 
o|inlining procedure: k4016 
o|contracted procedure: "(posixwin.scm:880) g802803" 
o|inlining procedure: k4101 
o|inlining procedure: k4101 
o|inlining procedure: k4136 
o|inlining procedure: k4136 
o|inlining procedure: k4156 
o|inlining procedure: k4156 
o|inlining procedure: k4177 
o|inlining procedure: k4177 
o|inlining procedure: k4202 
o|inlining procedure: k4202 
o|inlining procedure: "(posixwin.scm:915) badmode815" 
o|substituted constant variable: a4226 
o|substituted constant variable: a4228 
o|inlining procedure: k4242 
o|inlining procedure: k4242 
o|inlining procedure: "(posixwin.scm:925) badmode815" 
o|substituted constant variable: a4266 
o|substituted constant variable: a4268 
o|substituted constant variable: a4273 
o|substituted constant variable: a4274 
o|inlining procedure: k4278 
o|inlining procedure: k4278 
o|substituted constant variable: a4291 
o|substituted constant variable: a4292 
o|inlining procedure: k4296 
o|inlining procedure: k4296 
o|inlining procedure: k4427 
o|inlining procedure: k4427 
o|inlining procedure: k4529 
o|inlining procedure: k4529 
o|inlining procedure: k4559 
o|inlining procedure: k4559 
o|inlining procedure: k4602 
o|contracted procedure: k4618 
o|inlining procedure: k4615 
o|inlining procedure: k4615 
o|substituted constant variable: a4628 
o|inlining procedure: k4602 
o|inlining procedure: k4638 
o|inlining procedure: k4638 
o|substituted constant variable: a4682 
o|contracted procedure: k4686 
o|inlining procedure: k4683 
o|inlining procedure: k4683 
o|inlining procedure: k4721 
o|inlining procedure: k4721 
o|contracted procedure: "(posixwin.scm:1181) ex01061" 
o|substituted constant variable: a4773 
o|contracted procedure: k4780 
o|inlining procedure: k4777 
o|inlining procedure: k4777 
o|inlining procedure: k4790 
o|inlining procedure: k4790 
o|substituted constant variable: a4806 
o|inlining procedure: k4816 
o|inlining procedure: k4816 
o|inlining procedure: k4826 
o|inlining procedure: k4826 
o|inlining procedure: k4839 
o|inlining procedure: k4839 
o|substituted constant variable: a4855 
o|substituted constant variable: a4857 
o|substituted constant variable: a4859 
o|inlining procedure: k4872 
o|inlining procedure: k4872 
o|inlining procedure: k4915 
o|inlining procedure: k4915 
o|inlining procedure: k4937 
o|inlining procedure: k4937 
o|contracted procedure: "(posixwin.scm:1252) needs-quoting?1096" 
o|inlining procedure: k4886 
o|inlining procedure: k4886 
o|inlining procedure: k4991 
o|inlining procedure: k5003 
o|inlining procedure: k5003 
o|inlining procedure: k4991 
o|inlining procedure: k5062 
o|inlining procedure: k5062 
o|inlining procedure: k5078 
o|inlining procedure: k5078 
o|inlining procedure: k5115 
o|inlining procedure: k5115 
o|inlining procedure: k5182 
o|inlining procedure: k5182 
o|inlining procedure: k5227 
o|inlining procedure: k5227 
o|inlining procedure: k5254 
o|inlining procedure: k5254 
o|substituted constant variable: g127512761283 
o|substituted constant variable: g127512761283 
o|substituted constant variable: g127512761283 
o|substituted constant variable: g127712781284 
o|substituted constant variable: g127712781284 
o|substituted constant variable: g127712781284 
o|substituted constant variable: g127912801285 
o|substituted constant variable: g127912801285 
o|substituted constant variable: g127912801285 
o|substituted constant variable: g128112821286 
o|substituted constant variable: g128112821286 
o|substituted constant variable: g128112821286 
o|inlining procedure: k5354 
o|inlining procedure: k5369 
o|inlining procedure: k5369 
o|inlining procedure: k5354 
o|contracted procedure: "(posixwin.scm:1351) c-process1223" 
o|inlining procedure: k5416 
o|inlining procedure: k5416 
o|inlining procedure: k5451 
o|inlining procedure: k5451 
o|inlining procedure: k5492 
o|inlining procedure: k5492 
o|inlining procedure: k5639 
o|inlining procedure: k5639 
o|inlining procedure: k5657 
o|inlining procedure: k5657 
o|inlining procedure: k5669 
o|inlining procedure: k5669 
o|inlining procedure: k5700 
o|inlining procedure: k5700 
o|contracted procedure: "(posixwin.scm:1581) bad-mmap?1423" 
o|inlining procedure: k5754 
o|inlining procedure: k5754 
o|contracted procedure: "(posixwin.scm:1580) mmap1422" 
o|contracted procedure: k5796 
o|inlining procedure: k5824 
o|inlining procedure: k5824 
o|contracted procedure: "(posixwin.scm:1590) munmap1460" 
o|inlining procedure: k6120 
o|inlining procedure: k6120 
o|inlining procedure: k6132 
o|inlining procedure: k6132 
o|inlining procedure: k6142 
o|inlining procedure: k6142 
o|inlining procedure: k6177 
o|inlining procedure: k6177 
o|inlining procedure: k6223 
o|inlining procedure: k6223 
o|contracted procedure: "(posix-common.scm:250) g116117" 
o|inlining procedure: k6210 
o|inlining procedure: k6210 
o|replaced variables: 613 
o|removed binding forms: 458 
o|substituted constant variable: r22696237 
o|substituted constant variable: r23866241 
o|substituted constant variable: r23986243 
o|substituted constant variable: r24106245 
o|substituted constant variable: r23746247 
o|inlining procedure: k2525 
o|substituted constant variable: r25396251 
o|inlining procedure: k2525 
o|inlining procedure: k2525 
o|propagated global variable: g2812826271 delete-file 
o|inlining procedure: k2743 
o|inlining procedure: k2743 
o|propagated global variable: r27446561 delete-file 
o|propagated global variable: r27446561 delete-file 
o|converted assignments to bindings: (rmdir263) 
o|substituted constant variable: r28466286 
o|substituted constant variable: r29526290 
o|substituted constant variable: r30396296 
o|substituted constant variable: r30396296 
o|substituted constant variable: r30476300 
o|substituted constant variable: r30476300 
o|substituted constant variable: r31646315 
o|substituted constant variable: r31646315 
o|substituted constant variable: r31646317 
o|substituted constant variable: r31646317 
o|substituted constant variable: r32166326 
o|substituted constant variable: r32166326 
o|substituted constant variable: r32166328 
o|substituted constant variable: r32166328 
o|substituted constant variable: loc379 
o|substituted constant variable: r34486342 
o|substituted constant variable: r34486342 
o|substituted constant variable: r34356349 
o|substituted constant variable: r34356349 
o|substituted constant variable: r35646355 
o|substituted constant variable: r39746381 
o|substituted constant variable: r41576401 
o|removed side-effect free assignment to unused variable: badmode815 
o|inlining procedure: k4202 
o|inlining procedure: k4242 
o|inlining procedure: k4602 
o|substituted constant variable: r46166449 
o|inlining procedure: k4602 
o|inlining procedure: k4602 
o|inlining procedure: k4689 
o|substituted constant variable: r47786460 
o|substituted constant variable: r48276468 
o|substituted constant variable: r48276468 
o|folded constant expression: (fx< (quote -1) (quote 0)) 
o|substituted constant variable: r48876480 
o|substituted constant variable: r50636488 
o|substituted constant variable: r50636488 
o|substituted constant variable: r53706507 
o|substituted constant variable: r53706507 
o|substituted constant variable: c-pointer12261243 
o|substituted constant variable: c-pointer12261243 
o|substituted constant variable: c-pointer12261243 
o|substituted constant variable: r54176510 
o|substituted constant variable: r54176510 
o|substituted constant variable: r54176512 
o|substituted constant variable: r54176512 
o|inlining procedure: k5774 
o|substituted constant variable: r57556528 
o|substituted constant variable: r57556528 
o|converted assignments to bindings: (check994) 
o|substituted constant variable: r61336537 
o|substituted constant variable: r62116548 
o|substituted constant variable: r62116548 
o|simplifications: ((let . 2)) 
o|replaced variables: 42 
o|removed binding forms: 638 
o|removed conditional forms: 1 
o|inlining procedure: k2889 
o|inlining procedure: k3624 
o|inlining procedure: k3624 
o|inlining procedure: k3825 
o|inlining procedure: k3825 
o|inlining procedure: k3873 
o|inlining procedure: k3873 
o|contracted procedure: k5287 
o|inlining procedure: k5534 
o|inlining procedure: k5594 
o|inlining procedure: k5786 
o|inlining procedure: k5786 
o|replaced variables: 19 
o|removed binding forms: 114 
o|substituted constant variable: r25266550 
o|substituted constant variable: r25266552 
o|substituted constant variable: r25266554 
o|substituted constant variable: r28906632 
o|substituted constant variable: r28906632 
o|substituted constant variable: r36256647 
o|substituted constant variable: r38266650 
o|substituted constant variable: r38746652 
o|substituted constant variable: r46036601 
o|substituted constant variable: r46036603 
o|substituted constant variable: r46036605 
o|substituted constant variable: r5288 
o|substituted constant variable: r57876666 
o|inlining procedure: k6174 
o|inlining procedure: k6174 
o|simplifications: ((let . 3)) 
o|replaced variables: 2 
o|removed binding forms: 19 
o|removed conditional forms: 4 
o|inlining procedure: k4762 
o|inlining procedure: k4762 
o|substituted constant variable: a5286 
o|substituted constant variable: r61756694 
o|replaced variables: 1 
o|removed binding forms: 15 
o|substituted constant variable: r47636718 
o|removed binding forms: 4 
o|removed binding forms: 1 
o|simplifications: ((if . 57) (##core#call . 383)) 
o|  call simplifications:
o|    bitwise-ior
o|    <
o|    ##sys#structure?
o|    ##sys#check-structure	2
o|    ##sys#make-structure	2
o|    +	2
o|    ##sys#foreign-pointer-argument	7
o|    ##sys#foreign-string-argument	5
o|    char-whitespace?
o|    fxior	2
o|    string-length	2
o|    list	5
o|    values	11
o|    ##sys#fudge
o|    vector-set!	2
o|    char=?
o|    ##sys#foreign-block-argument	2
o|    ##sys#foreign-integer-argument	4
o|    fx-	3
o|    ##sys#check-number	4
o|    ##sys#check-vector
o|    procedure?
o|    member
o|    fx+	6
o|    ##sys#call-with-values	7
o|    ##sys#size	8
o|    string-ref	2
o|    fx>
o|    not	4
o|    cons	8
o|    ##sys#check-string	21
o|    ##sys#check-list	4
o|    fx=	8
o|    zero?	2
o|    ##sys#slot	18
o|    ##sys#check-exact	25
o|    ##sys#null-pointer?	5
o|    pair?	15
o|    eq?	31
o|    cdr	20
o|    ##sys#eqv?	7
o|    null?	54
o|    car	36
o|    vector
o|    fixnum?	4
o|    string?
o|    fx<	12
o|    ##sys#foreign-fixnum-argument	12
o|    apply	9
o|contracted procedure: k2242 
o|contracted procedure: k2271 
o|contracted procedure: k2280 
o|contracted procedure: k2286 
o|contracted procedure: k2318 
o|contracted procedure: k2309 
o|contracted procedure: k2439 
o|contracted procedure: k2361 
o|contracted procedure: k2433 
o|contracted procedure: k2364 
o|contracted procedure: k2427 
o|contracted procedure: k2367 
o|contracted procedure: k2421 
o|contracted procedure: k2370 
o|contracted procedure: k2382 
o|contracted procedure: k2388 
o|contracted procedure: k2394 
o|contracted procedure: k2400 
o|contracted procedure: k2406 
o|contracted procedure: k2412 
o|contracted procedure: k2418 
o|contracted procedure: k2528 
o|contracted procedure: k2535 
o|contracted procedure: k2561 
o|contracted procedure: k2573 
o|contracted procedure: k2587 
o|contracted procedure: k2643 
o|contracted procedure: k2606 
o|contracted procedure: k2635 
o|contracted procedure: k2625 
o|contracted procedure: k2649 
o|contracted procedure: k2658 
o|contracted procedure: k2664 
o|contracted procedure: k2667 
o|contracted procedure: k2670 
o|contracted procedure: k2701 
o|contracted procedure: k2676 
o|contracted procedure: k2793 
o|contracted procedure: k2710 
o|contracted procedure: k2722 
o|contracted procedure: k2729 
o|contracted procedure: k2758 
o|contracted procedure: k2773 
o|contracted procedure: k2783 
o|contracted procedure: k2787 
o|contracted procedure: k2927 
o|contracted procedure: k2805 
o|contracted procedure: k2921 
o|contracted procedure: k2808 
o|contracted procedure: k2915 
o|contracted procedure: k2811 
o|contracted procedure: k2814 
o|contracted procedure: k2833 
o|contracted procedure: k2848 
o|contracted procedure: k2852 
o|contracted procedure: k2858 
o|contracted procedure: k2904 
o|contracted procedure: k2861 
o|contracted procedure: k2880 
o|contracted procedure: k2883 
o|contracted procedure: k2898 
o|contracted procedure: k2889 
o|contracted procedure: k2933 
o|contracted procedure: k2954 
o|contracted procedure: k2957 
o|contracted procedure: k2988 
o|contracted procedure: k2995 
o|contracted procedure: k3018 
o|contracted procedure: k3034 
o|contracted procedure: k3052 
o|contracted procedure: k3074 
o|contracted procedure: k3077 
o|contracted procedure: k3080 
o|contracted procedure: k3092 
o|contracted procedure: k3101 
o|contracted procedure: k3127 
o|contracted procedure: k3218 
o|contracted procedure: k3237 
o|contracted procedure: k3301 
o|contracted procedure: k3314 
o|contracted procedure: k3307 
o|contracted procedure: k3323 
o|contracted procedure: k3329 
o|contracted procedure: k3344 
o|contracted procedure: k3350 
o|contracted procedure: k3375 
o|contracted procedure: k3392 
o|contracted procedure: k3388 
o|contracted procedure: k3367 
o|contracted procedure: k3398 
o|contracted procedure: k3508 
o|contracted procedure: k3455 
o|contracted procedure: k3464 
o|contracted procedure: k3447 
o|contracted procedure: k3498 
o|contracted procedure: k3494 
o|contracted procedure: k3434 
o|contracted procedure: k3517 
o|contracted procedure: k3520 
o|contracted procedure: k3534 
o|contracted procedure: k3575 
o|contracted procedure: k3582 
o|contracted procedure: k3590 
o|contracted procedure: k3602 
o|contracted procedure: k3606 
o|contracted procedure: k3613 
o|contracted procedure: k3549 
o|contracted procedure: k3620 
o|contracted procedure: k3703 
o|contracted procedure: k3643 
o|contracted procedure: k3697 
o|contracted procedure: k3646 
o|contracted procedure: k3691 
o|contracted procedure: k3649 
o|contracted procedure: k3685 
o|contracted procedure: k3652 
o|contracted procedure: k3655 
o|contracted procedure: k3658 
o|contracted procedure: k3676 
o|contracted procedure: k6152 
o|contracted procedure: k3735 
o|contracted procedure: k3743 
o|contracted procedure: k3746 
o|contracted procedure: k3749 
o|contracted procedure: k3759 
o|contracted procedure: k3772 
o|contracted procedure: k3779 
o|contracted procedure: k3785 
o|contracted procedure: k3798 
o|contracted procedure: k3801 
o|contracted procedure: k3816 
o|contracted procedure: k3831 
o|contracted procedure: k3842 
o|contracted procedure: k3851 
o|contracted procedure: k3857 
o|contracted procedure: k3866 
o|contracted procedure: k3882 
o|contracted procedure: k3888 
o|contracted procedure: k3902 
o|contracted procedure: k3905 
o|contracted procedure: k3920 
o|contracted procedure: k3927 
o|contracted procedure: k3952 
o|contracted procedure: k3955 
o|contracted procedure: k3980 
o|contracted procedure: k3976 
o|contracted procedure: k3986 
o|contracted procedure: k3996 
o|contracted procedure: k4121 
o|contracted procedure: k4007 
o|contracted procedure: k4010 
o|contracted procedure: k4024 
o|contracted procedure: k4046 
o|contracted procedure: k4067 
o|contracted procedure: k4079 
o|contracted procedure: k4089 
o|contracted procedure: k4093 
o|contracted procedure: k4104 
o|contracted procedure: k4130 
o|contracted procedure: k4139 
o|contracted procedure: k4159 
o|contracted procedure: k4180 
o|contracted procedure: k4192 
o|contracted procedure: k4205 
o|contracted procedure: k4215 
o|contracted procedure: k4232 
o|contracted procedure: k4245 
o|contracted procedure: k4255 
o|contracted procedure: k4281 
o|contracted procedure: k4299 
o|contracted procedure: k4443 
o|contracted procedure: k4424 
o|contracted procedure: k4433 
o|contracted procedure: k4479 
o|contracted procedure: k4523 
o|contracted procedure: k4526 
o|contracted procedure: k4532 
o|contracted procedure: k4553 
o|contracted procedure: k4556 
o|contracted procedure: k4605 
o|contracted procedure: k4612 
o|contracted procedure: k4641 
o|contracted procedure: k4653 
o|contracted procedure: k4667 
o|contracted procedure: k4705 
o|contracted procedure: k4692 
o|contracted procedure: k4715 
o|contracted procedure: k4724 
o|contracted procedure: k4733 
o|contracted procedure: k4736 
o|contracted procedure: k4739 
o|contracted procedure: k4765 
o|contracted procedure: k47536717 
o|contracted procedure: k47536722 
o|contracted procedure: k4784 
o|contracted procedure: k4813 
o|contracted procedure: k4833 
o|contracted procedure: k4829 
o|contracted procedure: k4836 
o|contracted procedure: k4842 
o|contracted procedure: k4848 
o|contracted procedure: k4860 
o|contracted procedure: k4918 
o|contracted procedure: k4924 
o|inlining procedure: k4933 
o|inlining procedure: k4933 
o|contracted procedure: k4877 
o|contracted procedure: k4889 
o|contracted procedure: k4906 
o|contracted procedure: k4895 
o|contracted procedure: k4902 
o|contracted procedure: k4950 
o|contracted procedure: k4958 
o|contracted procedure: k4965 
o|contracted procedure: k4971 
o|contracted procedure: k4979 
o|contracted procedure: k4986 
o|contracted procedure: k4994 
o|contracted procedure: k5006 
o|contracted procedure: k5012 
o|contracted procedure: k5015 
o|contracted procedure: k5027 
o|contracted procedure: k5031 
o|contracted procedure: k5039 
o|contracted procedure: k5069 
o|contracted procedure: k5081 
o|contracted procedure: k5148 
o|contracted procedure: k5090 
o|contracted procedure: k5142 
o|contracted procedure: k5093 
o|contracted procedure: k5136 
o|contracted procedure: k5096 
o|contracted procedure: k5130 
o|contracted procedure: k5099 
o|contracted procedure: k5124 
o|contracted procedure: k5102 
o|contracted procedure: k5118 
o|contracted procedure: k5105 
o|contracted procedure: k5215 
o|contracted procedure: k5157 
o|contracted procedure: k5209 
o|contracted procedure: k5160 
o|contracted procedure: k5203 
o|contracted procedure: k5163 
o|contracted procedure: k5197 
o|contracted procedure: k5166 
o|contracted procedure: k5191 
o|contracted procedure: k5169 
o|contracted procedure: k5185 
o|contracted procedure: k5172 
o|contracted procedure: k5271 
o|contracted procedure: k5427 
o|contracted procedure: k5341 
o|contracted procedure: k5291 
o|contracted procedure: k5295 
o|contracted procedure: k5299 
o|contracted procedure: k5303 
o|contracted procedure: k5307 
o|contracted procedure: k5329 
o|contracted procedure: k5336 
o|contracted procedure: k5408 
o|contracted procedure: k5412 
o|contracted procedure: k5424 
o|contracted procedure: k5437 
o|contracted procedure: k5454 
o|contracted procedure: k5464 
o|contracted procedure: k5468 
o|contracted procedure: k5471 
o|contracted procedure: k5570 
o|contracted procedure: k5519 
o|contracted procedure: k5564 
o|contracted procedure: k5522 
o|contracted procedure: k5558 
o|contracted procedure: k5525 
o|contracted procedure: k5552 
o|contracted procedure: k5528 
o|contracted procedure: k5546 
o|contracted procedure: k5531 
o|contracted procedure: k5540 
o|contracted procedure: k5534 
o|contracted procedure: k5630 
o|contracted procedure: k5579 
o|contracted procedure: k5624 
o|contracted procedure: k5582 
o|contracted procedure: k5618 
o|contracted procedure: k5585 
o|contracted procedure: k5612 
o|contracted procedure: k5588 
o|contracted procedure: k5606 
o|contracted procedure: k5591 
o|contracted procedure: k5600 
o|contracted procedure: k5594 
o|contracted procedure: k5651 
o|contracted procedure: k5754 
o|contracted procedure: k5725 
o|contracted procedure: k5729 
o|contracted procedure: k5733 
o|contracted procedure: k5737 
o|contracted procedure: k5741 
o|contracted procedure: k5745 
o|contracted procedure: k5792 
o|contracted procedure: k5818 
o|contracted procedure: k5827 
o|contracted procedure: k5838 
o|contracted procedure: k5806 
o|contracted procedure: k5810 
o|contracted procedure: k5841 
o|contracted procedure: k5851 
o|contracted procedure: k6123 
o|contracted procedure: k6139 
o|contracted procedure: k6135 
o|contracted procedure: k6145 
o|contracted procedure: k6158 
o|contracted procedure: k6183 
o|contracted procedure: k6167 
o|contracted procedure: k6170 
o|contracted procedure: k6192 
o|contracted procedure: k6204 
o|contracted procedure: k6226 
o|contracted procedure: k6217 
o|simplifications: ((if . 1) (let . 60)) 
o|removed binding forms: 318 
o|inlining procedure: k3320 
o|inlining procedure: k3341 
o|inlining procedure: "(posixwin.scm:909) mode814" 
o|inlining procedure: "(posixwin.scm:919) mode814" 
o|inlining procedure: k4954 
o|inlining procedure: k4975 
o|inlining procedure: "(posixwin.scm:817) stat-type729" 
o|inlining procedure: "(posixwin.scm:816) stat-type729" 
o|inlining procedure: "(posixwin.scm:815) stat-type729" 
o|inlining procedure: "(posixwin.scm:814) stat-type729" 
o|replaced variables: 190 
o|removed binding forms: 1 
o|removed side-effect free assignment to unused variable: mode814 
o|substituted constant variable: r49556886 
o|substituted constant variable: r49556886 
o|substituted constant variable: r49766889 
o|substituted constant variable: r49766889 
o|substituted constant variable: name7306897 
o|substituted constant variable: name7306903 
o|substituted constant variable: name7306909 
o|substituted constant variable: name7306915 
o|replaced variables: 14 
o|removed binding forms: 91 
o|contracted procedure: k5771 
o|contracted procedure: k5834 
o|converted assignments to bindings: (check816) 
o|simplifications: ((let . 1)) 
o|removed binding forms: 22 
o|contracted procedure: k3931 
o|contracted procedure: k3935 
o|contracted procedure: k3939 
o|contracted procedure: k3943 
o|contracted procedure: k4195 
o|contracted procedure: k4235 
o|replaced variables: 2 
o|removed binding forms: 6 
o|removed binding forms: 1 
o|direct leaf routine/allocation: loop1099 0 
o|direct leaf routine/allocation: g13301337 0 
o|contracted procedure: k4940 
o|converted assignments to bindings: (loop1099) 
o|contracted procedure: "(posixwin.scm:1373) k5457" 
o|simplifications: ((let . 1)) 
o|removed binding forms: 2 
o|replaced variables: 3 
o|removed binding forms: 1 
o|direct leaf routine/allocation: for-each-loop13291347 0 
o|converted assignments to bindings: (for-each-loop13291347) 
o|simplifications: ((let . 1)) 
o|customizable procedures: (k5821 k5765 k5780 %process1318 chkstrlst1325 k5251 $exec-setup $exec-teardown $quote-args-list build-exec-argvec1114 doloop11391140 loop1106 k4807 k4819 k4718 mode1010 check1011 check994 check816 g779786 for-each-loop778797 k3949 k3848 k3740 scan573 loop570 check-time-vector k3055 k3058 loop391 g363364 loop355 conc-loop336 k2867 loop315 g271278 for-each-loop270287 rmdir263 k2652 mode183 check184 ##sys#stat) 
o|calls to known targets: 153 
o|unused rest argument: _387 f_3240 
o|unused rest argument: _386 f_3232 
o|unused rest argument: _426 f_3292 
o|identified direct recursive calls: f_3570 1 
o|identified direct recursive calls: f_4884 1 
o|identified direct recursive calls: f_4913 1 
o|identified direct recursive calls: f_5449 1 
o|unused rest argument: _15081512 f_5864 
o|unused rest argument: _15151519 f_5870 
o|unused rest argument: _15211525 f_5876 
o|unused rest argument: _15271531 f_5882 
o|unused rest argument: _15331537 f_5888 
o|unused rest argument: _15391543 f_5894 
o|unused rest argument: _15451549 f_5900 
o|unused rest argument: _15511555 f_5906 
o|unused rest argument: _15571561 f_5912 
o|unused rest argument: _15631567 f_5918 
o|unused rest argument: _15691573 f_5924 
o|unused rest argument: _15751579 f_5930 
o|unused rest argument: _15811585 f_5936 
o|unused rest argument: _15871591 f_5942 
o|unused rest argument: _15931597 f_5948 
o|unused rest argument: _15991603 f_5954 
o|unused rest argument: _16051609 f_5960 
o|unused rest argument: _16111615 f_5966 
o|unused rest argument: _16171621 f_5972 
o|unused rest argument: _16231627 f_5978 
o|unused rest argument: _16291633 f_5984 
o|unused rest argument: _16351639 f_5990 
o|unused rest argument: _16411645 f_5996 
o|unused rest argument: _16471651 f_6002 
o|unused rest argument: _16531657 f_6008 
o|unused rest argument: _16591663 f_6014 
o|unused rest argument: _16651669 f_6020 
o|unused rest argument: _16711675 f_6026 
o|unused rest argument: _16771681 f_6032 
o|unused rest argument: _16831687 f_6038 
o|unused rest argument: _16891693 f_6044 
o|unused rest argument: _16951699 f_6050 
o|unused rest argument: _17011705 f_6056 
o|unused rest argument: _17071711 f_6062 
o|unused rest argument: _17131717 f_6068 
o|unused rest argument: _17191723 f_6074 
o|unused rest argument: _17251729 f_6080 
o|unused rest argument: _17311735 f_6086 
o|unused rest argument: _17371741 f_6092 
o|unused rest argument: _17431747 f_6098 
o|fast box initializations: 14 
o|fast global references: 72 
o|fast global assignments: 7 
o|dropping unused closure argument: f_4989 
o|dropping unused closure argument: f_5073 
o|dropping unused closure argument: f_4551 
o|dropping unused closure argument: f_2263 
o|dropping unused closure argument: f_4870 
o|dropping unused closure argument: f_5433 
o|dropping unused closure argument: f_4596 
o|dropping unused closure argument: f_2714 
o|dropping unused closure argument: f_2519 
o|dropping unused closure argument: f_4172 
o|dropping unused closure argument: f_4633 
o|dropping unused closure argument: f_2556 
o|dropping unused closure argument: f_3299 
*/
/* end of file */
