// Copyright 2021 Canonical Ltd.
// Licensed under the LGPLv3 with static-linking exception.
// See LICENCE file for details.

// This file is autogenerated with testdata/gentest.go

package drbg_test

import (
	"crypto"
	_ "crypto/sha1"
	_ "crypto/sha256"
	_ "crypto/sha512"

	. "gopkg.in/check.v1"
)

func (s *drbgSuite) testHash0_SHA1(c *C, data *testData) {
	s.testHash(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHash0_SHA1_0(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "136cf1c174e5a09f66b962d994396525"),
		nonce:           decodeHexString(c, "fff1c6645f19231f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0e28130fa5ca11edd3293ca26fdb8ae1810611f78715082ed3841e7486f16677b28e33ffe0b93d98ba57ba358c1343ab2a26b4eb7940f5bc639384641ee80a25140331076268bd1ce702ad534dda0ed8"),
	})
}

func (s *drbgSuite) TestHash0_SHA1_1(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "dfed69b08902fcfb795d5d35dbe23f6b"),
		nonce:           decodeHexString(c, "37258e820432e392"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "adcb8e2cbbc5957d538a20db18b5e7fe350a90a201359fab9e0f154c53aa146bc6af1fcc7ff8f330b8d9f3d7b038488ba627e6fa21d0147377b1340422b22634b412dac69ac82c35b5fb411a4e42a133"),
	})
}

func (s *drbgSuite) TestHash0_SHA1_2(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f32e36ff8098f932035cae429c0ece72"),
		nonce:           decodeHexString(c, "5552ceb182324b49"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bac94bc1797b209b8e576709d68d92a94aa8a5f414feee3e87d2f21fcb5939314b1b4711274077e794e8e385a28fabb5b49081ef14cb1396cb12542fd1b48c2ad4df98f74bf08346f0a29ff7088dcbfe"),
	})
}

func (s *drbgSuite) TestHash0_SHA1_3(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "213e9022898aa05c7a6a01a4b8d343cc"),
		nonce:           decodeHexString(c, "7b6981d7e16c9880"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a74906340d7514db5b44860170a5e0733c67d3ce7e51bd32b049800d8e3c36c845560084decc79e6f7b4d6f2f127592e645891792d0f562b67bc8a1f63aa149d849de1fe032825f3a5d46fe3705024eb"),
	})
}

func (s *drbgSuite) TestHash0_SHA1_4(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "091ba785fac466b4851ea2dca8b38bcd"),
		nonce:           decodeHexString(c, "9012cbb0f9b59cac"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "399ae61fe531448c8206d7ac127b6a4486adaebeff3567b6bcd0f554b82a6aa6337f7311465946912283dc3fb05cf89a74ad0a1851c5a20026ca990f1184a8a9978aad2e0c40b6c4e3571bfa0f144329"),
	})
}

func (s *drbgSuite) TestHash0_SHA1_5(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ff076a630f39bd94d07e88d0232dd56e"),
		nonce:           decodeHexString(c, "f51a8c5d4cd4131f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "991d77b515bb73dec2226c2486e634d6531aaa6cef9f646fba5fdd0210834c730b7f2fa110ab061cfbb08a95b3694b62e81d0c6b82cf294ea62fdec094c3ed7834fbf9b876f1a63a583e2ea42a58ff74"),
	})
}

func (s *drbgSuite) TestHash0_SHA1_6(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0f679e662f08197e7645763919ba08e8"),
		nonce:           decodeHexString(c, "187e82eb844b32c2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ff639c15f873d350f1778f1e9ea0a5614eb260ac453f5c5730bb0be9072a013f1596ae266cc09ff1c8a7fe520ebd4069248d86ea36de43580cd07ccef1ec8b6fe16c2a500424abe65765c41891972dc9"),
	})
}

func (s *drbgSuite) TestHash0_SHA1_7(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "c448624035df3b168af39755b952f0ef"),
		nonce:           decodeHexString(c, "6c32bd9dd5347f3c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3bb725633745c30a3cfe9feb0529532a65368b65d2e7fb990d6ba2f9bbbbb8cd66ec1af530614fe39b7ad55b2a6291791741f7e76116da1ebfed658ec55a862947671682d287c0f6e8ceabd50c4c3759"),
	})
}

func (s *drbgSuite) TestHash0_SHA1_8(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "efd2561148bfad41595be969c3f021fe"),
		nonce:           decodeHexString(c, "7c7233e9e06fa189"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d9b6b5b0aa26a01de152ced94a83bbb6affdb915e488a04b642211f8e3b88d89f59d92f9f4fcd8998907bf148bc58f30115c8fff85c55713545fe77582d906758db20ae7537f3da6f9a8c994fa2d01b5"),
	})
}

func (s *drbgSuite) TestHash0_SHA1_9(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "a13ed8f604ac0346c2ac270129bb3578"),
		nonce:           decodeHexString(c, "9ca5f62c4d09de87"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6cf70e27a9793c14ebae73b653798c15e14e6cb9b854349e42d8801d49364d7788686f89c6ea2db7f038dd42432dd744bbc91e1fcdaf6eee2e76325db729fd3a99b96cd638c4a8923516fa04fd90eac5"),
	})
}

func (s *drbgSuite) TestHash0_SHA1_10(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "dfe6ebca43ec46b8aac35333ddc47d44"),
		nonce:           decodeHexString(c, "5d03cbacd44db169"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1c1d756b6d5d475ee39319399200b7f864112454bf03cc61f6856c5d4207b1cd9792c0841ab3b56730ab26d95c360cc02ac4611ef47f80d665ffb8327e103fef246bf93a2a1038b2beda9a8a6d21c415"),
	})
}

func (s *drbgSuite) TestHash0_SHA1_11(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "48e5fbd1acc601e02d81ce030f100155"),
		nonce:           decodeHexString(c, "a0fc82d8e692e69b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9eea525ca572095b4d0b967ca8fcc5dae6ec326a0b9bb63c4a7f08d1dad4a5d21c15cf4b8df9eb8ad26037d9dce9a7848af5ee8e30493dea7be2b1f1ffe8c4171c1311acf9821c06614838ae2b8ab7b2"),
	})
}

func (s *drbgSuite) TestHash0_SHA1_12(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "dc8c369f6f659cf760710b1a69a547cf"),
		nonce:           decodeHexString(c, "45847cf48b89b3c9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f84562c15d3a3574a27d3ed8991f17b8e7d3b74a0650d6dc328d947a984257cf22f9f6ef5f5fb2080e59d65f6f2ca996b7b151d7b79bc98cc71e5042a10bc4b933fa5ca2731bfc5cc6b0b7ca25e6416b"),
	})
}

func (s *drbgSuite) TestHash0_SHA1_13(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "4e8b4b1e2f6a9fe8abb56f716bc894b8"),
		nonce:           decodeHexString(c, "38565e90cd131e3f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e046050ed2a14a564dc69b7e4aa89a998a0dc7325a05e4666b0cf611885f6391d98c31d8e2527ea296791d0c8f34522ced84217bae3eac5eb8732cbc4af07169e25f9fb6da4588e019969d79fcccd5f7"),
	})
}

func (s *drbgSuite) TestHash0_SHA1_14(c *C) {
	s.testHash0_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6fe9597b59903b1af4012a15368af7b1"),
		nonce:           decodeHexString(c, "fd3e84b3a96caaff"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1eee4c786476d488e58d0e065bb025db548787fafbe757f29ee2bd4781cf69216091ba2b68919b54ad3070ac72a2342320eb1e697b9115acbe07e194d060562e4d0fd966ab29e2c5e560574b2dac04ce"),
	})
}

func (s *drbgSuite) testHash2_SHA1(c *C, data *testData) {
	s.testHash(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHash2_SHA1_0(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f7e316b13117dcc18c4407b6a5cdc5d8"),
		nonce:           decodeHexString(c, "b80ddee75cf39a48"),
		personalization: decodeHexString(c, "816cb137ef64f9df71a3b3a0b3aaf9b1"),
		expected:        decodeHexString(c, "be888585d95d95269f002abd8b1e33b2cb667a96d3be6d20d784b1bbc6639347837d01d4b95eed8137cf29fe724cfedf8b23f9258480be350c3407973c59a9d7f3a6585b3c0e36a36c6234d68852acaf"),
	})
}

func (s *drbgSuite) TestHash2_SHA1_1(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "033f1e32612fd11974c6992be28b009d"),
		nonce:           decodeHexString(c, "6b528c9d2accd0af"),
		personalization: decodeHexString(c, "1b1defb546206d555c55bf23a7fefd10"),
		expected:        decodeHexString(c, "f1e012c33a6f2a5f06f00ecae997e4d6c48b3e5b769c058951e3cb3cd1ae0794165b54d90f0df66a40025956eb76a6150a850cec48c2497d2d5861296877e627df2f064d3d7c12f9692d657f4eea7086"),
	})
}

func (s *drbgSuite) TestHash2_SHA1_2(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b207ab840b357ae0f84d84fd91fe9db2"),
		nonce:           decodeHexString(c, "6ad6f67b654f8c1d"),
		personalization: decodeHexString(c, "80e0290e51b67e7a5f26b151717c11c4"),
		expected:        decodeHexString(c, "b1500533483e007f9221663f00e3745b151b8085229df05e90ad6e1b4f286c11656bcd13ec280cb92075b50c17f4cc9bf4a07d661cfe17518ec5d2649318b9587db88e093e981fc51674c9893044ac7d"),
	})
}

func (s *drbgSuite) TestHash2_SHA1_3(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d88957fbca97ba8a2e73eb64a38ef31c"),
		nonce:           decodeHexString(c, "3e07a917c111c5f4"),
		personalization: decodeHexString(c, "70860be005c1dd2bf322744040e2b702"),
		expected:        decodeHexString(c, "d7a9f9c6ac7b5ab8e06ef707626888628a3fa9cc86385ab56e39901e8b720b932c5c77980a967f38edb95f19b3c0f8e95e0bfdc8fb404771f053da5f96e79d52945cb4277981a978cee80d84b286e1b6"),
	})
}

func (s *drbgSuite) TestHash2_SHA1_4(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0a4c590ebcef0556af9811b6462b92d6"),
		nonce:           decodeHexString(c, "238d395f8d295205"),
		personalization: decodeHexString(c, "3df3ddb4cb22e2a6ccd685f094078a12"),
		expected:        decodeHexString(c, "22dfbc9462cff94c26d6073ce10949fb5cd53c6055d727b1be798c5b1d018f732139e74fd7df604224423a2cba88dfe98af88f9977b7d79fff08fc6cdefcad3ac74084bab8af04c5fdabc943d51eda0a"),
	})
}

func (s *drbgSuite) TestHash2_SHA1_5(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f8d9705829d4908e43d0fb62f72b120a"),
		nonce:           decodeHexString(c, "349618dce551e7c3"),
		personalization: decodeHexString(c, "054d18ec3b0f5afc46f97bbc0c5821e1"),
		expected:        decodeHexString(c, "a43c01fe30b01dd1468e4c81f9a6b04f8c34f904b21e5dbe1890778c13f5b36a664837b98a1bb0f533653d6ac7e537a6a0c5c879baf45815ecaee6b03a677b2dc5cc12042f7ca161bf90b2a73cf41d23"),
	})
}

func (s *drbgSuite) TestHash2_SHA1_6(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "53e093055d912f7fe96f0bccc46165c8"),
		nonce:           decodeHexString(c, "80f5977f22a096b1"),
		personalization: decodeHexString(c, "92ad83187b24748ed77b36313917e980"),
		expected:        decodeHexString(c, "e95937e34e5e0c547aeb0e8dbe3cb9ba5f823978e3a42255a0803d096bea9cd22f387b4d967ec6c6d5a66d62f45a837673c586351d7533472d3bd4fa149d26e15ebae9107146b99219d4faed1380a81b"),
	})
}

func (s *drbgSuite) TestHash2_SHA1_7(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "cacb0bf934e427bccd07a6ed85d551e1"),
		nonce:           decodeHexString(c, "bc16676c4386ffa4"),
		personalization: decodeHexString(c, "5fd3b05beaab79953709ed3c60e71230"),
		expected:        decodeHexString(c, "60ecf6d89ae63b0ca3c395ecba93fa167776dd46fa2018f11b5d4cfb29ce1fb19d14ca7ce8887c5b195bd1bc0df473505d4b0e69a7bb54ff31c4b48fd06bbc783bfa85c8715aef86fdeeca5212a12bac"),
	})
}

func (s *drbgSuite) TestHash2_SHA1_8(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b9b66aea1e07b60b30fd32ff2cdcba61"),
		nonce:           decodeHexString(c, "9b497bed54945c93"),
		personalization: decodeHexString(c, "edde3ae39578ea819f67b38e552be3b8"),
		expected:        decodeHexString(c, "7dfb2cfa0747071c97f11a4dda3780f3cad20b1c598d3e74b2a90fd39ff6b659012cacbf604b270762bf5008a9f779acbfb2c4b160d42285d63e5a9019626361bbd98bfad148cc81426cecbc076e926f"),
	})
}

func (s *drbgSuite) TestHash2_SHA1_9(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "811bd64fa915fadf72c114b7b9a3cd40"),
		nonce:           decodeHexString(c, "8870420e78b33af8"),
		personalization: decodeHexString(c, "e0dcc2804ed07b8f4eeea4e40268443b"),
		expected:        decodeHexString(c, "7f4dbdaacedcce576bdfa03a80c3861cb52d8b14a6f63e034868dc3fdebb5f2cd1ae5790b755ca617c91714be92902d0088a60d2501123945d533ebc8b9a13fc81b6cf22cc0dca1c86f28aa5bf38a6fa"),
	})
}

func (s *drbgSuite) TestHash2_SHA1_10(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "375ade012aaefb480dd9e01dcac6b09d"),
		nonce:           decodeHexString(c, "4b5218c585464fa1"),
		personalization: decodeHexString(c, "1d04beeaf792cf336013f6dfecf8bf37"),
		expected:        decodeHexString(c, "eabfcdfc396b5e9c10e09b45aa0fe978558aaf8a13c4ce7cdcbab0216882d39555b369c68e62484d1ccd51fdcc4cb61b22a0120147e6686c263c32f66233273a3011dad2428d4d6f5e9e20b9ef6474e4"),
	})
}

func (s *drbgSuite) TestHash2_SHA1_11(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "86e59a0469837c69ffeca566656f0254"),
		nonce:           decodeHexString(c, "677e6cb313a34a19"),
		personalization: decodeHexString(c, "3809013d72fc559901ca1b06be5878f8"),
		expected:        decodeHexString(c, "8fa62314bf1a1ff584317996a13a648006958fe8cd5263c61a2c689419358dc356f34e1b1981aa8f4d1899a51fed1a9cfc8db7e84b73506377cd12366bbc1440321ef1d64a0a6eb0ffe25400eb82a7ac"),
	})
}

func (s *drbgSuite) TestHash2_SHA1_12(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "66d1ab7b3115249361db41482538d142"),
		nonce:           decodeHexString(c, "a17cbbde7200d2be"),
		personalization: decodeHexString(c, "aad7b6a9de717acc17fa7cedc2858ea9"),
		expected:        decodeHexString(c, "18e3fa3d861ab810e4fcd05206b3ec4987c16000f6a84a28e2e89387b4010c840f796484d4730c5b3a46e37c99e5e1ea02a6d153d50e9719e0419e58e9f6254ba3b9ca80bb1b27f70a05c944cbbf9e89"),
	})
}

func (s *drbgSuite) TestHash2_SHA1_13(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6149060c71c6d6fac0d3088369a9628e"),
		nonce:           decodeHexString(c, "6a97f8199b36b3ca"),
		personalization: decodeHexString(c, "231c6f78388fb63cfe9422ded41caa7a"),
		expected:        decodeHexString(c, "9d7cea9927e5e9552de9da9a8c291b9400e38fb32c30dc334f572bace072815bcc4806fc077b7ae6e4c82ed9a80b281fe186818c38bc1d0f16ce05ee644450d20de5ecdba575e436acb8526230cd8bce"),
	})
}

func (s *drbgSuite) TestHash2_SHA1_14(c *C) {
	s.testHash2_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f368b81501338a3cca948353fe16970d"),
		nonce:           decodeHexString(c, "fa9adae924417150"),
		personalization: decodeHexString(c, "dbad22c389c527715d21a5bdf38c1fad"),
		expected:        decodeHexString(c, "a18d57e672218956e6c8cb9901d02888f3587177c3e11e1a99ea72370347b953a9f122c9446dfa109723b27f36fbf15edf103a56741c24968592479cfe30bc0053fa7b9818e9debcc494db64d15d038b"),
	})
}

func (s *drbgSuite) testHash4_SHA1(c *C, data *testData) {
	s.testHash(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHash4_SHA1_0(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "66b3c78fa8c86dd891aab0e53f3606de"),
		nonce:           decodeHexString(c, "84142c2d1f1cda88"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e60d83ed6bbe75351f2fbd356a4bc8904b970d45982edeb898d0f2e6f4707faf497471c3df7460783e4beff0015d23d8c7ba270b6f562c4a7b76c0690b2609ade3fe372b53f1c5ff4d5f0dd9a3966825"),
	})
}

func (s *drbgSuite) TestHash4_SHA1_1(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "22bf7d4b28e0b0cd263c114e594ce5a1"),
		nonce:           decodeHexString(c, "209eab8979e7b59a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4ca3bb37cf63c589edfd062abd77116542b5b753c3cdca97497eb6e13beaedde8c43beedbcf9a72cc8715070cbddf0f6ddc6146971b22ccdb1e3c9ee730da1b2126bff2c3cb0efabc871fea49470a7cb"),
	})
}

func (s *drbgSuite) TestHash4_SHA1_2(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "20807f2c0e865514f6fcdbbbaac59895"),
		nonce:           decodeHexString(c, "e60baa003c2c18d5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ff897d957d8be86391546129ce6c98ddc43806784c24a0d3cb3080e9eac3c20605ff6d1caa24bd038d8b683f07b24f3846aca8236581b4c4d04eb8b87020c07b55888347a26382d62f9d10d4121a21c9"),
	})
}

func (s *drbgSuite) TestHash4_SHA1_3(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "be8d9fec6b80914c70a9c28ea6bfe7c4"),
		nonce:           decodeHexString(c, "d6f7da93c2693341"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7aab1f408b871a494b9df42208d83bfef1ba6476a51cc2f3b70896816b1c1e410d506aacd3e1f8916dc8be0bce42f986f67bd2f9f02395fba1ffe499e5eef70b3bf743f519fd8ca1db694f8970f82421"),
	})
}

func (s *drbgSuite) TestHash4_SHA1_4(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "2958128df4649e1ae1f0dd5dd3740ce9"),
		nonce:           decodeHexString(c, "181ce194bb3aa4ec"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b7cda6ec47ed3ff8dafb78ed04fc5c0ec2d6ccb1869422665dc4bdf9842596eee00fd5934dc17cbb17c57fb970ce9a9bdfdca75aaaa4263a875a2ed012b6d56049f13b51e2a44acb37f922f8d13a4d19"),
	})
}

func (s *drbgSuite) TestHash4_SHA1_5(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "91eaffb7b63f5dba7824d562f863b053"),
		nonce:           decodeHexString(c, "fe530ca5b6e3243f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ea3708f56e3a515b5eef9e361c4e0a8c385f38c17e8216f42a2db58e4ce5b48c7521b2ffdfe2e0be55d430150b6a2121de11ca7197167ec0d3bd6383be4b3b47d9c57fc224088d050114757115eee002"),
	})
}

func (s *drbgSuite) TestHash4_SHA1_6(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "22c89c671b478015cae3da530356852d"),
		nonce:           decodeHexString(c, "9632ebd13ac406d6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "861aec2488df56ea7f0bc4bd142c9162ce6a64b73912d94981b715aa14dd1fd649ad1d86fc4a5365c2307d9f6771ddfdb72d6d89d98a10341e440562c761c9ab1190529bf721db2ac0d00cfb618e34a5"),
	})
}

func (s *drbgSuite) TestHash4_SHA1_7(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "eda4dd917fd7765a8b102e831c39384b"),
		nonce:           decodeHexString(c, "255d248cdba3cf78"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "83263fec6c1c70cbc088e13dde4de31f142d7d2042457d79f0c033f0d790621f75823c55e41e9a4461ad7ccddf52377340d51f727b0f9b812d151036cfa686bc28afeaae995e130a1ee0dd11104e5ab1"),
	})
}

func (s *drbgSuite) TestHash4_SHA1_8(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "4ef4978078ec29820636bb177ffb4b2f"),
		nonce:           decodeHexString(c, "e4c9c345cedfc123"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "22c7eca633dab483688139397a2cd8c426506f60dde1bfe5e4e799999087f7f2046f7d8e0406179d4859ff619d70ce6db7573ec4a2085c4824d7e82d4fefa6fa43cfe23b245dab95c624866a72c167a0"),
	})
}

func (s *drbgSuite) TestHash4_SHA1_9(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "a2680750d8731cd093d6284f570466ad"),
		nonce:           decodeHexString(c, "7658f300666b66d2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "da6cdf3548ef1ae5955814e36c73b7aeaf5b4d533b037afce49bf72bf0416c911825ae05fd97cc5fed2301cbfb20545a20d56096aa474a39b3dabfc888a8a65ef3230e69f2ce5b0d7d30738f708d5f58"),
	})
}

func (s *drbgSuite) TestHash4_SHA1_10(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "238f4a64db2cd8d140f9fbfdea102338"),
		nonce:           decodeHexString(c, "b19af3bc12552fbb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "27ce1efb77df4a848f0eb72451c0771f08b80f45e290091f8c3852fda0b71b281d01a070b380daf7efa94697806d3d138e945113002a628483dd7e341c7a9a6f836d99577b39fb0f9a732f14459595fc"),
	})
}

func (s *drbgSuite) TestHash4_SHA1_11(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1a3a0333340f1d67dda715285bbfb617"),
		nonce:           decodeHexString(c, "374b8f8be9f2820e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f28cd91365d02d204fa71fe86ee40fb05f477864be556f2e8e0f212dcb1ed98ef59adde485cb28afee97ac44a789626550d533e6cb8a13e0cd039a7d56f270b892df742c499f5c609ef74454f1a8cbf5"),
	})
}

func (s *drbgSuite) TestHash4_SHA1_12(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d622c47e9838e0fcd8bfb209f42a3c29"),
		nonce:           decodeHexString(c, "b29bba7cfeba90cc"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9340bb4692e52792693e8edc0c2883f54f8b93942ae36f06d5532964f1f9b581c02a86b9520566f5f796e3cb2194853ed9ec18b693bc7ac9a83c0f8db896d93fa20953d459afe443b63d1241d0b47cc1"),
	})
}

func (s *drbgSuite) TestHash4_SHA1_13(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b54fa4fbefc63f96a45070dba669c3fa"),
		nonce:           decodeHexString(c, "dc9bb5e014df5f2b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "07452aa85d2416bb091b9cc8f49add2dc897465998782a01e628e9fed6f0f185fd5d412dc40625dec710ebf26729d0346c344ef2b1d3d42a9ad60f05386413e40978d206cf3fc8ecf40950a280e4477c"),
	})
}

func (s *drbgSuite) TestHash4_SHA1_14(c *C) {
	s.testHash4_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ceb354444d1a29c0c3e8a1cc24d02846"),
		nonce:           decodeHexString(c, "86d3fd9fc51f8b19"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6f90ad611987a37bac54bea0782ac78215b7d17ecdd3991a81a36d0e263c6f0dda2c102cfba56b26c7b74b5dd2548be9bc81c7958e9d19821583c6f388132b9e19ae7609add9a296c1e92d66a2ef5464"),
	})
}

func (s *drbgSuite) testHash6_SHA1(c *C, data *testData) {
	s.testHash(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHash6_SHA1_0(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f0fd2199c6252628639976628cb71c39"),
		nonce:           decodeHexString(c, "e2daebbc0ce7a183"),
		personalization: decodeHexString(c, "5fa5eee4f36f5d42f593c57de87543ab"),
		expected:        decodeHexString(c, "3e1a75df8612b40eceade7a8c73f0c11ca4046a3a13e159af3fb9b969f38994fd1bf6896a268125555934aeea0145a8a83a780f2d71c12689caa9faec6d0d198758d4a0664250bd4d89fe9614adca3e3"),
	})
}

func (s *drbgSuite) TestHash6_SHA1_1(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "75b8f66db02e8a39d48ff6bdb864392a"),
		nonce:           decodeHexString(c, "19883bc681293991"),
		personalization: decodeHexString(c, "1c5f890dcf7c4c81fbe59f12dfa487bf"),
		expected:        decodeHexString(c, "9a4d78b6ee54bc200488fbc522d967c6e397b12f29dedd2a44b4c2d2a5e0c5de7d19a5cd778fb0a0cbe1d9893865a378380d12b0582c35befebaa135da44dc08403165a001bb3180cfa5644992112f26"),
	})
}

func (s *drbgSuite) TestHash6_SHA1_2(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "8ddc1d1aa73c797502f971bbd59efec6"),
		nonce:           decodeHexString(c, "e5b54a7af76fb120"),
		personalization: decodeHexString(c, "37ec2725347b4908abe8f69e22836d4b"),
		expected:        decodeHexString(c, "bd96549ed8c094bb043870424d38a71479e44a3f47e92ec010a1018ad5eeafe832fda541553948c975540ad8e73acb364868149504df3574a04b1c34fe7bd7009211c27f30cd34c1fdd410b83201947a"),
	})
}

func (s *drbgSuite) TestHash6_SHA1_3(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "3c03464129b13d93e4bc07f5731a59b6"),
		nonce:           decodeHexString(c, "5ffea12fd5f62dcc"),
		personalization: decodeHexString(c, "588204a022727afa3f94ceb7bb8edfbb"),
		expected:        decodeHexString(c, "17a2fb65d66d8a7f31924638a9445136ca6e5bdc3599a5501ffe976289297be9ee0028215901b4dfe66430fca4b0e4c8f0e0c74d9869b58c7b67b5fac560349f2c60318c79a7f3c143c5f61caa3714e5"),
	})
}

func (s *drbgSuite) TestHash6_SHA1_4(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "05b17d9962ee6ba8cfd6f5e849b8457b"),
		nonce:           decodeHexString(c, "f6d7a5aea88a24be"),
		personalization: decodeHexString(c, "13d9c60de4b04fc63d07485d0eb2337b"),
		expected:        decodeHexString(c, "80a296e2082324e1d7a850abb5eec23694ae695345d57f07f3bc46c42e5d8012b37dadadaca5f1fcb0088c590050589e5b10f8bfd96722ec0c567b90bea565edbedd415bab2fa630d94738c444db14dc"),
	})
}

func (s *drbgSuite) TestHash6_SHA1_5(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "e536cf0138566d88525565c6b6cd2f86"),
		nonce:           decodeHexString(c, "d048a518569027f9"),
		personalization: decodeHexString(c, "68e2286ed468333ee27c573453569994"),
		expected:        decodeHexString(c, "615384d1982f75f8e8c008fd656b3be095dc6a1b15725cdc2206abb5b0e7d72514ee4f477d120a4b1fa81c40ec88bc7cb4048df83c94c7b2b6f7fd916ffc176781517d4decb9b8abe53c2289db4b41ef"),
	})
}

func (s *drbgSuite) TestHash6_SHA1_6(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0f48eecd9913b7104ff8b8800a2b1316"),
		nonce:           decodeHexString(c, "6de036fe5a201b5f"),
		personalization: decodeHexString(c, "d00c237030adba874e1e6bcbcf2a47bf"),
		expected:        decodeHexString(c, "36b76562ae5dc30545e6ce14ddbce12330f1cfea88227b8ec11654e62b4e81063a5574758163f4478a2838af2583ece2e69bfbf1450f12ac6e37a6948e7ec36716db22c40565b1a16a4b06e26659c34f"),
	})
}

func (s *drbgSuite) TestHash6_SHA1_7(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "662930e8bae14d3be87d9654635a2022"),
		nonce:           decodeHexString(c, "3836f4d7a508595d"),
		personalization: decodeHexString(c, "7460d16da01dfe504870de63bd4cf60c"),
		expected:        decodeHexString(c, "c99b9cea7f7610d54632d39b457525dff4f01c57989f50949d1857998f4aae14aac57a1cc7ad5138e970ca678a7d4cbd42c9d961f15b45665dda08ab2cb1eaff6890c7b62684e294f6b37f89f1119835"),
	})
}

func (s *drbgSuite) TestHash6_SHA1_8(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "3ef096ac9e72a961f56890f4b523f95f"),
		nonce:           decodeHexString(c, "1c100401a49402cb"),
		personalization: decodeHexString(c, "e22d6f4b7fa50463db12138044ccfd37"),
		expected:        decodeHexString(c, "4138091774bbf394d90b33c1b66017d842c7c5e7221f57f55ef0d60da4398c50c7d2ec9813177673b9f336a0b85a25f88e2156ea5fb2250b95ebc879a5ac58584af8094c31d771835e2624d11db50118"),
	})
}

func (s *drbgSuite) TestHash6_SHA1_9(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "a30092b4f481c74efa85a2836a92dc2b"),
		nonce:           decodeHexString(c, "cd22e3e3e7021c08"),
		personalization: decodeHexString(c, "8602bf589cf670e6ba787b32153b2d3a"),
		expected:        decodeHexString(c, "678f1bcedbc85c2002e04cf78ba8a89e7b1d56fee420d215a0fbf33e301de3f075acdeb3363b3c6c5d73ed1d5a284375fc3b8b4c73a27405d75703ea6bd9b295148ba9b703639cffee9b378082318940"),
	})
}

func (s *drbgSuite) TestHash6_SHA1_10(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "2516c22aa5aecfb06594db8039fbab26"),
		nonce:           decodeHexString(c, "2b52ac3399c0d7b4"),
		personalization: decodeHexString(c, "ed8cdbd10a1fc7c4280f399a93b8e47a"),
		expected:        decodeHexString(c, "b926bdf438c6e306a9ac0084294c1a97ef1368e106244edd4066248a20d4f8d601e43583b682afed5189f51b6f06ae004414cc668c082f8845a7075e5d3923158fdd8377d17351b9d924c8b8f38bea4d"),
	})
}

func (s *drbgSuite) TestHash6_SHA1_11(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "35edf013d80eec2d3b785726629ee074"),
		nonce:           decodeHexString(c, "149c1260bd2b1d9c"),
		personalization: decodeHexString(c, "9212a95a4cf0855e3ee8c5257914ea36"),
		expected:        decodeHexString(c, "910bfa602583b1fa5c05918d3453ac7efc163040cd345fdd2b5b342d0dd6f42eb2f847932712cf1219ae29766532ab16e6d8112cd6feac569f3e9942c0450b9fcca22cb9504b289094c96d5d1a7f7c3b"),
	})
}

func (s *drbgSuite) TestHash6_SHA1_12(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "88ebea4ad88d9e35187cc70503d773f5"),
		nonce:           decodeHexString(c, "53ad0f40facc3f98"),
		personalization: decodeHexString(c, "8095d8ab6b617fa1d115d1bfe517f4ef"),
		expected:        decodeHexString(c, "256c837781fa60cd1f775db1d4d7b765adbb3bb5dacc1716d39efd718f8e999566f09cebc1d8d038c63a3192d6ababf5b3eb38f8795662be594e63589d7adce57884ab62dc4099c49c1d25e88a99283f"),
	})
}

func (s *drbgSuite) TestHash6_SHA1_13(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7e9d7f2d749fd44674714d0f6b098b47"),
		nonce:           decodeHexString(c, "2970b716b2116895"),
		personalization: decodeHexString(c, "57acd2520d9ebfb762b759b998fe5f36"),
		expected:        decodeHexString(c, "ea846303d9e1ac8469fed0163deb49c6d6f69da2443dd31b66c72855ac30e7c02e06558d78e733d9f5a0f6e52763639cc2b8c4c0e05b8c69f6a3dd84063997663ed5f4e690ddbb8642380f8e8c9aa8a2"),
	})
}

func (s *drbgSuite) TestHash6_SHA1_14(c *C) {
	s.testHash6_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d20b5ed70118ecfeb2dcfe8cfd7e6b6e"),
		nonce:           decodeHexString(c, "8368ee0e29d35c67"),
		personalization: decodeHexString(c, "f189a80d5619f53cce878ed57522a468"),
		expected:        decodeHexString(c, "aeac5933065c33ce2ace2531a193e367f73c83fc328f61ee2627f6f3841914c6b8a3ff767f96b3c3b685bac931af9ec10c6f3efe25b5109bb647b120e3a3f6971a4ec41f4ef0c7a900fdb09d7ff3b247"),
	})
}

func (s *drbgSuite) testHash8_SHA1(c *C, data *testData) {
	s.testHash(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHash8_SHA1_0(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ac1f51d43fafea519453eaca3ebb2f95"),
		nonce:           decodeHexString(c, "a6666fe26d8702c1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3ea69dff9d5633699d27fb4bab4ca972536daef15de584427384d66f00312c31a21ef02d88ec9ca79583b69fca776e2f67fc6a9a1ca2c519317d2523793dec48e11cdee28b1fc610024b03bc234619ba"),
	})
}

func (s *drbgSuite) TestHash8_SHA1_1(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "bd6768788f02e84a2fc3580a87b469fa"),
		nonce:           decodeHexString(c, "e26b8c9c4bc6128a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d4e900b0a6ed2c88ca0b28ee9212faf0657d28d7a53d393f0475c43ce5f0f2207a3f18cdea08d96a2a533647a69005b675758c9318a8340979c4e1d0bb46040e3f656a4862d4dbfd0780cae9baa4ab5a"),
	})
}

func (s *drbgSuite) TestHash8_SHA1_2(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "514cb05af192b0b04435e21a13de0a2b"),
		nonce:           decodeHexString(c, "278c9a83acbddaff"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "31f864417ac27992788bcd5e07fff7886e969d06e747fa5c73a48a194a54f612327aecc3127b1e410a5d3f564aa56b978350e93e2b988b99a6d31cb0fd8b7406aaa2daaa5a9ed66fb746e3a58cc3614c"),
	})
}

func (s *drbgSuite) TestHash8_SHA1_3(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "8a0899c465949b4999619c06086997e6"),
		nonce:           decodeHexString(c, "e1ad18e17645df1c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "39de5b2b5dff4aad99cdfabcac9d7b3c0d0f9fedb1c1f03704b3b5bbd8c8ea2cbd759b4e668d12708550bad5d5d315acec8c0ab952bf2ac869586aaa27863d68d9183960d508133e4adb9c8af3e41f53"),
	})
}

func (s *drbgSuite) TestHash8_SHA1_4(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5dd1da788775b4a30669b92a1c992eba"),
		nonce:           decodeHexString(c, "b43aa41b02eb42cf"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8a4562f76621610004f401fe72f5d1406dbe6adaebd926c2065f57466bd788306b20d13c16d1e7627cdb200c2581eb23b02d588dc4e5251d610562a084c18940f2f4d5ec306c6eee83ee257b93a749d8"),
	})
}

func (s *drbgSuite) TestHash8_SHA1_5(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7c4637dc79e29f7b857f65700d6fa891"),
		nonce:           decodeHexString(c, "8ab36789a68a4a94"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4dfd7bdee8966c260331adc8a1763bd4d15ba713d5ce7e291d274387d59a98028b3675c5a58c237d8f40638bfe4892a16c6f76e92e8b4335f28a93ef41018e6022a9072eef6cf0aa833d80f056a8898a"),
	})
}

func (s *drbgSuite) TestHash8_SHA1_6(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "46f15e711ddd172ed99469a9d1758011"),
		nonce:           decodeHexString(c, "b22c685bd5463521"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b2b00d3ef6a9ec8a8ccd827f828fd56556ea3dbdc47a73a315f07253d66e14f8fa020e5bf025c7adc5f0b81b2cd992930e43e4b4e2d8dfb926fc387f9fa98c58f29f267de1a8235c5327ae85486fa3ba"),
	})
}

func (s *drbgSuite) TestHash8_SHA1_7(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "89486609b21f4a77d44903309238cd10"),
		nonce:           decodeHexString(c, "2c65e57dc62b7182"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "044eb722caf85f4aa4586459925f7768a595674092f559f04d78ef6d94db382bb1ebbb7b9e10ba28896e84fa54b100715f6de5d9c313832338307cd480e7caa5b958d39f4899ef8f1e0926e9f9de9642"),
	})
}

func (s *drbgSuite) TestHash8_SHA1_8(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f1322328dff8c7330d7408315f7476ad"),
		nonce:           decodeHexString(c, "3026a9607bc8d5a7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b5fc472a4a35d59a0f298ea5fc1446d150820f8c78088511a45397f47fce79bdf5fd62af96e7d97a83ef505459aadd81c244bbe4704196bd1f3124f6d421f7a82bcf8be40e5460f0f74e6ca8ec39d7a3"),
	})
}

func (s *drbgSuite) TestHash8_SHA1_9(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0cadd9c27360ad9cf3de96b62056f6c4"),
		nonce:           decodeHexString(c, "b2eb6a839574c019"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d28a38ebc8aebfc41d58116df36a3533c48c877bb8992c30ea17b46ba2945967c8178a500f271197c67e8766bb552df5970f07a76a4d8e57fd6467b4148439dc163cf700781c7bd81c1d1b2fc3848510"),
	})
}

func (s *drbgSuite) TestHash8_SHA1_10(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "12c2b495cfa55a4482dcee035923e85e"),
		nonce:           decodeHexString(c, "cb5b88622d933589"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7075312c4dc21e54a2a83346ee8d3710a2eceb34c02dcdab3817f8a682cc0b1bf7b1c777cbd2af1e454ff471129a94059a253c82955b5ad9196372d1c93416500a65f962151a32c63bc6bc6b8443ac9f"),
	})
}

func (s *drbgSuite) TestHash8_SHA1_11(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "2fea9691d8258763d5d0e86954cfd8da"),
		nonce:           decodeHexString(c, "3ef71a3017eef25a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5956ec9a16bc61b84bc0014eee2f5615cc259008bab23ad6a00ff7e36687e0f6ee90ea4b90b3c7a9e90c8f9d844c915b4caaea7c158b0e9164d98d2e9531f02f5dcb36a84bebcdbd7b7a91a7f8e13538"),
	})
}

func (s *drbgSuite) TestHash8_SHA1_12(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "624ab76f3291da22fa54d49031fe02fc"),
		nonce:           decodeHexString(c, "d401ec34a7e4ff2f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8b862d9ba4adafd17a458c585d8706f1132aeed8aa119ddaf4412a4a5716ad442c974f6fb367bae76fe0f33f84d3117887ac4592dfbc8599839b8e436fb22632fe43a8aa77ffd86d09b4b378a39c6137"),
	})
}

func (s *drbgSuite) TestHash8_SHA1_13(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1da2ef227cb78db77ffa872e407624c3"),
		nonce:           decodeHexString(c, "3c17de55283fe66a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "682a991fe836c32b611340e698c48301c4c0b14a221f2f75e37e68b4db4cf9a26a465a8bbe55589a8a5d006093917ce859f93b0f016d43e2eeb4ed739a77e65fa5c08806ce7a89d305405a720e296d25"),
	})
}

func (s *drbgSuite) TestHash8_SHA1_14(c *C) {
	s.testHash8_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b7ddb82f5664834b4fb17778d22e62f2"),
		nonce:           decodeHexString(c, "52461924becab175"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8735d06e26814ee54b5daca4e1da3e321a5a19b062ec0c3afbe3b16f23332a687fadb29e65208130c3d667c075660ff70aea96430fee254c472686b8e82ca359a57bbdc3004bb3eb641c1f97e4b19e02"),
	})
}

func (s *drbgSuite) testHash10_SHA1(c *C, data *testData) {
	s.testHash(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHash10_SHA1_0(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "91d99c511c2f1967d31d20b313e5382d"),
		nonce:           decodeHexString(c, "1eaf7f1d0aa36a19"),
		personalization: decodeHexString(c, "31e6b04d73b1a970fd3dcd8f089e4402"),
		expected:        decodeHexString(c, "1c95fb985cf17cb9cf0bcd53959972c8fd4bbc725b2ecc8ee843d55e494bc7684d1765931c173a838dc7b4344cdc14586409066d4f1d54ac214ecbe5bd139c65abe199525fa8ffbef59304e47baac9a9"),
	})
}

func (s *drbgSuite) TestHash10_SHA1_1(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "e677281e871c28d631b2361107240c22"),
		nonce:           decodeHexString(c, "87468967e455d2da"),
		personalization: decodeHexString(c, "114ba92f794518015c067f7c358c4041"),
		expected:        decodeHexString(c, "59584ff00c44a0dbd15c1f35e050c184e8d587e8859cb061c8409c454b953924f5e6ee1fee4d763462dd6a29a6cbe4a373974c01d688ee5728cf712bcdc82cb0ad15419229b8cd114ac7851e37a3d7b2"),
	})
}

func (s *drbgSuite) TestHash10_SHA1_2(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "bd4831a85279fd767caff44ba26053ae"),
		nonce:           decodeHexString(c, "9e56a808711827f6"),
		personalization: decodeHexString(c, "69e0fe7b804c65bb8c7ba89a8b4c7c6a"),
		expected:        decodeHexString(c, "7d1fe8c9de79611d57b51297cf1b2304591504a04694e60e21fdd70f3d782d17aea35173efa30ef2f235894d696f1a150bfe0396271fd8cba062823580a9e1de8e32d962bdcb4b4f47b942fc39849abf"),
	})
}

func (s *drbgSuite) TestHash10_SHA1_3(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "46bdab811f76b752551a2b11b708963e"),
		nonce:           decodeHexString(c, "8be4fc159fdb7515"),
		personalization: decodeHexString(c, "bc4f4d95927b1aa666791c4aa818700f"),
		expected:        decodeHexString(c, "c535859cef074916f7a3785537285be385893822a953fd41aba600f56d80e6efe2952f92ece5cbec15b2b03a229080de98c6ebda741f19d3557015a90ee0b2a0de9c0eb64c8b8af6dccf8f74e7ca1c1f"),
	})
}

func (s *drbgSuite) TestHash10_SHA1_4(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6701138a46b148a2688879989ab4da96"),
		nonce:           decodeHexString(c, "1bbd5c7f095534cc"),
		personalization: decodeHexString(c, "ced04a25a8bdedbdbb28534376bb2414"),
		expected:        decodeHexString(c, "b4c2f0e989bd858ed16037f8344557b0cb35d044191d680cb1afcd2d8563686a92fdff5e1331fd3fc87d14f3ba10eb14ee6b16d648181392335c0ee4c2ab275881bba36c553d34810b8c689aad017343"),
	})
}

func (s *drbgSuite) TestHash10_SHA1_5(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "9df820297bc0016d246a93cb64192073"),
		nonce:           decodeHexString(c, "f2dcff78c90a15a7"),
		personalization: decodeHexString(c, "7059433f58646f5794ccf171ca188a95"),
		expected:        decodeHexString(c, "06a5c61c664503469af0ff6714ae87e8a76996c35d80d45b0208bb26735b9e4630eacf50cf62ff3530214e8dedbe4240848638eb41783f8d1d3efa6399bc1d9554f5b5a386082498a33f8ea4fa5309f1"),
	})
}

func (s *drbgSuite) TestHash10_SHA1_6(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "244cc3baa000afa7d547511770165f70"),
		nonce:           decodeHexString(c, "c583942d888828ff"),
		personalization: decodeHexString(c, "53ab8f3e392696ffb6b06f45af125656"),
		expected:        decodeHexString(c, "67d1735a4cd37be67e682ee5a3c99aba138b74887b90c8291e9e4e7156c786ef5626ecb2420e47d64b6a044fac951ddb302d184c5ae01f03c42ecf633a1e539fcdb4f926a472c48dd8ce30914cc229d4"),
	})
}

func (s *drbgSuite) TestHash10_SHA1_7(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d8997d36ed9d8d50a190ed4ff8160acf"),
		nonce:           decodeHexString(c, "d9b4add5ce5a28b9"),
		personalization: decodeHexString(c, "fd9f0cfdb80ee581e83676cfc4fa09d7"),
		expected:        decodeHexString(c, "6850db84a868eb1f0de75a3881a4ec79a1156f30b8618ca16e55175ab6f840932d21a340d9465fa12a587cff1f878627aad2e9c82784f650dfcabd12b36cdb1b10a2d1751d9756b5e289e8aa7d2302eb"),
	})
}

func (s *drbgSuite) TestHash10_SHA1_8(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0285da431ed1c618078e1b4ed9effca4"),
		nonce:           decodeHexString(c, "f10a22cf4adb6c3f"),
		personalization: decodeHexString(c, "073b537b35c6a497e478516ed79783ee"),
		expected:        decodeHexString(c, "12f8f357633b5c769665c333b975a81ed97f940f50094bdab1e278126356f9f9dab21a2fea61a0f491143978894238c04cf4956ae8ffabadb6abf0ac4efef76d5a581ed797948c6672008a8973e97567"),
	})
}

func (s *drbgSuite) TestHash10_SHA1_9(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d6b735fda7419f43231d9051d73541f6"),
		nonce:           decodeHexString(c, "7e095b38be8ec549"),
		personalization: decodeHexString(c, "27872af730f3ab90a3a520e324c908a0"),
		expected:        decodeHexString(c, "f684248e039a9919773e178086deb5581052ee66ec06236a4972e4459ae16f7d5de66c7423189f12e1c9a105d1fb1500010eb280f346b45d96ac90389ff5174cc00911ec3a8972ed028f74eba8347732"),
	})
}

func (s *drbgSuite) TestHash10_SHA1_10(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "8706dece8a595f0c4885c14695ff29d9"),
		nonce:           decodeHexString(c, "96587c6f34d29e6f"),
		personalization: decodeHexString(c, "bd770a8f31f78482b2ca2e1e4b24b33b"),
		expected:        decodeHexString(c, "4d30523fc574d6352bada3d2567178c702805adeef69bd6820ed97146bb30d09c16fff502089a90f9c993686c72c401825a83f094e8152af221d71d55e6882a10f4d17aa08dfbe54b263d2baae0b83d4"),
	})
}

func (s *drbgSuite) TestHash10_SHA1_11(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "32526f30f361bcd4df5802724442b01d"),
		nonce:           decodeHexString(c, "1929dfb17d500442"),
		personalization: decodeHexString(c, "f945c1e2eabc435193134628bc8c03e1"),
		expected:        decodeHexString(c, "e896265457d9251f4062a14f08d16ae5c4ff370b4675f20fed9511ead999a5e4ab7094ba6678e69abc7a95916676280c7f78cfbed7dfcea46493f57634e93dd18700607e1e19b78a57d1e47ba079e405"),
	})
}

func (s *drbgSuite) TestHash10_SHA1_12(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "874b0dd42d1ddfb3d3835271f5731629"),
		nonce:           decodeHexString(c, "87b6c89eda28478a"),
		personalization: decodeHexString(c, "7d5b80247411c067797dfc10c1668775"),
		expected:        decodeHexString(c, "699723859d25ab759a9b8b3728a67bf639e02b805d5ea7b6e6d614ec29728b68d6d9ed29a93ab1f1c624d3f2d5ca1826cd09cc1c5555604537567fa6fdb1f6622d29f2d81d1dd7c23179d75c43d72f06"),
	})
}

func (s *drbgSuite) TestHash10_SHA1_13(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5162636e7b1a5cf9b1c14d723bb3eeb9"),
		nonce:           decodeHexString(c, "21e5b177f119c477"),
		personalization: decodeHexString(c, "6513318d80218546385c2afc56e4116d"),
		expected:        decodeHexString(c, "c295e6515abf2598122752b24b4bb1493d821e6bb19561c2690dfbc06119c86539c0d21002d2448474762d60751ba8a58165f66fcaf6342dcd4e468363462f94149da6636c548fe5b9f2aad138a54a43"),
	})
}

func (s *drbgSuite) TestHash10_SHA1_14(c *C) {
	s.testHash10_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f8a1566d14fff92e8de379d168ff3cfa"),
		nonce:           decodeHexString(c, "4e838a124e4b53df"),
		personalization: decodeHexString(c, "163e393b290a4d390ab0beb392f52d26"),
		expected:        decodeHexString(c, "76234afc296ea36a44254f999ac31fca258a24427cf4bfe2c54495fc41478ec4a00b540659b3b9461cc6188bc1f57c19ae414bd18aa81eca7b9d765a784f0ef24335e46c2c77b8dc915f5d12c26bc653"),
	})
}

func (s *drbgSuite) testHash12_SHA1(c *C, data *testData) {
	s.testHash(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHash12_SHA1_0(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "4c2fbea166f7920af0f0521e22487266"),
		nonce:           decodeHexString(c, "ef58d39807d588d8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "54d8c2266c0fa6613e76768856883da0bdcd0d6621407e8599451e2859b5d0b56e588089e39e229ddf84f3267ba5acde539e5c0e4d33aa51e18e0758e7b52a240d3994a77edc4bd8d3c254bedbbe27f1"),
	})
}

func (s *drbgSuite) TestHash12_SHA1_1(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5d839ad9eda931021901b262e48ffc81"),
		nonce:           decodeHexString(c, "efbee0dcb5601086"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "de5d1198d1da55806056d79579409fe72415d181148db8273b0cba1e9ff0a8f4552047ded2f565e6ff7035ed420478ebbd8e4f0e301de8a5b558f2373a57708e05f0017748c40f7bbda2d297be23cfdb"),
	})
}

func (s *drbgSuite) TestHash12_SHA1_2(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "803171f06759503e5aca87ee10d37fbe"),
		nonce:           decodeHexString(c, "df19527df6da466b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8f71d35e91480b1931174d080c905abba4e1179476a35eaffb18df538b397d45decc4a4c9fbee8e8b74911e7e379d67cad77873671248c65c21c7f93d9c2116284e795e941c8efaf2de0d1474e81e70d"),
	})
}

func (s *drbgSuite) TestHash12_SHA1_3(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "beb33d42e9be573bd9e1c9e1d6aff44d"),
		nonce:           decodeHexString(c, "e42f6b8177fc417d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dfcac439738b84d03818568b2bb9d71a0f52f0b962d93d913e2b909ab464a378e003640ca3addb46f1f4607543f2985f561fc4def408b47fcaf838e25468fc97dbcf057edd51d88c342c81d6ce92b020"),
	})
}

func (s *drbgSuite) TestHash12_SHA1_4(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6bd49cb7c8ac1d6a04db642d8b462ee7"),
		nonce:           decodeHexString(c, "73e7cadf29be5f35"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "aa5157bde2c8332f7ede49b6fd590d90dcb637aa2c62272d721f0f80ba8fa83f616b901dffe3b9e236003ad01a959d95bffb1e24f18cb4445d4b64ae2b5d1e78fd0b5830fa4aec73ee189f17bed79b80"),
	})
}

func (s *drbgSuite) TestHash12_SHA1_5(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "9306eb88e8a62744ff5dd01d92e5fc4e"),
		nonce:           decodeHexString(c, "582de62d3c45e9c6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b73714fb42e91620d1b81a80a416f5239ed3856e4f7320fc5726a63207707710803ea3fe11813e6bb7d5c2b9565eaf059d8f3384f6dd1d83f6917ff3efcf9290e34752923e54774a103d0a5135ef2fdf"),
	})
}

func (s *drbgSuite) TestHash12_SHA1_6(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0283592b01b7d932dd79be815a325841"),
		nonce:           decodeHexString(c, "4fcf02c7764c5a3b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2470de1ff90fd84c4e17eac1dcff65634799716aa0d027a3a9abdf92ae956a18abe8b23742bbf8317aece6a6d1ad2e0041fb112b7c857150f337a15927095f0a9e8caa42b347c65e750b0737b0a70241"),
	})
}

func (s *drbgSuite) TestHash12_SHA1_7(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d1b81fb414d0c070ee8469b190c33279"),
		nonce:           decodeHexString(c, "43f72e66358b29e1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "caad4638fb82e619665a300cfa2f88234eb65d414b9d1ec9f9cbee9429626393366c8148be55b238c08ff48935738ca6e840cce024a5805de92146408993547380cf53be7c6e455daced820fc8fb34e4"),
	})
}

func (s *drbgSuite) TestHash12_SHA1_8(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6123ec40c42f3bed9cd178d4004ee91f"),
		nonce:           decodeHexString(c, "0264712f52edb23d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d58b3f091a967ca13b55463e8529045d60a60b9602f43ee7bee075471eef83823b2d540b3ece6d637e1153579e2c179ec155250a18c3ae46490c61e4643143464dcee94c88c2afb41b7d516f65f215fc"),
	})
}

func (s *drbgSuite) TestHash12_SHA1_9(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b1e632849427bec02897718c3df8865b"),
		nonce:           decodeHexString(c, "c8c1c64bfd80be1f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4985777745c4fb29d01967570937da62a6c644881a4fd03e1403992a6a86dbeb98442852728844429dadbab434a0b03594c8d6ae41fc2b4a9ced5f63b4ecd8d4064f80acd3ef50910c9d84a0290c2615"),
	})
}

func (s *drbgSuite) TestHash12_SHA1_10(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f6b732cd0aa7200aee6784552d0c38af"),
		nonce:           decodeHexString(c, "2d69a600a42674ac"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "47e9738a0d0e09ba786d5c9d0a14472679432aaa363bceb12bca2d85248d61cfb2e4b712ea4ccefa14820227db3a31f063e98c40ac21bbbfae3d6326c2fd59046d8864976bcd517827503362429748bb"),
	})
}

func (s *drbgSuite) TestHash12_SHA1_11(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "49c494013bbe3320859fcc0cf73cd472"),
		nonce:           decodeHexString(c, "83f14a32419cdae2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b1f3aa9a90440b35ccb797f7e0b7b4b70715796f320439937b5e7cc69ceac6691d3cc262bab35708ac845d9c44c50a0d45e29401e52be422460e0c0f6b983dad6d5e61f7f6929d881f430348bf16de94"),
	})
}

func (s *drbgSuite) TestHash12_SHA1_12(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "498c61223bfaa533da307e7fd79b776e"),
		nonce:           decodeHexString(c, "b362d90663b1c921"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "80a2a0f2822985428471bac8c5c46cd5dbee0f9fb91d08b9ed69a557700134738752310eefc23ace021fbcb82cc67096b58aae14463607a5077072ea74af4bfde68ee91f89231bd3bafaeaaad1406b39"),
	})
}

func (s *drbgSuite) TestHash12_SHA1_13(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "33f724717aeff485543ad0d5c7703356"),
		nonce:           decodeHexString(c, "ac4558a22aaefc9d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "810be2ed84cb7bc205f6ba6dd691186e454da073955ce6e54f9b945445ae698a3d4747c973052aa1cc7e212208ecd4cc58b2f30ff6c4f2acdcabc3727e8665f55de7962f6fcbbeb406869924c6166ac2"),
	})
}

func (s *drbgSuite) TestHash12_SHA1_14(c *C) {
	s.testHash12_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f484b922f492d19b58407c242ab90e76"),
		nonce:           decodeHexString(c, "8952a0a4b666b0c8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2d77235fa273cab3c1bb176d44817cc25300b3f0172a0b5aaa66b282c015d426edec5f1ebbfc0269956b85994167992a71002586923ea234be6c5df09f47d89132e440827b89f7ff97e032b3f74fe32f"),
	})
}

func (s *drbgSuite) testHash14_SHA1(c *C, data *testData) {
	s.testHash(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHash14_SHA1_0(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "e4bac955a3e820e5895194e2c13ef9ac"),
		nonce:           decodeHexString(c, "8f4d177da65ed48e"),
		personalization: decodeHexString(c, "06c4c601145a9d137a490c7bcd22f41e"),
		expected:        decodeHexString(c, "e967d2fa2478775342ec5ca153e5cb13c66134d4e17a89cf629d7845f8ce268332a04f0d7e2282368f4033994f20bcbc7d4397d5facc448842b1e9246c24a68e029fff99e90853bb19b7e6fc9f29e4b0"),
	})
}

func (s *drbgSuite) TestHash14_SHA1_1(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "2e9518f753f59a4a53fdac88af187dac"),
		nonce:           decodeHexString(c, "9b926c223ad3efb0"),
		personalization: decodeHexString(c, "bca05ffdbc7d8b928c7979c083d65784"),
		expected:        decodeHexString(c, "055fbe1d5e276068f7883094c3df679da1bfcf38562ebbff64456c2ed4fb03985bddfb352122adbb0bdd92672d454f7db516209cfafe289bd28bdbc50bc22f03912ea694ad2fe1c9f2d57ed39893e801"),
	})
}

func (s *drbgSuite) TestHash14_SHA1_2(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "299fb649ae002b0bd29f23fbeb221f08"),
		nonce:           decodeHexString(c, "6140ec1a5899ebab"),
		personalization: decodeHexString(c, "acd2160d088532e0588a888c5dba863b"),
		expected:        decodeHexString(c, "1630fcb482956b0f9a1f2c248d06d8069669ab2c90aa390da636954945312607d645a6ae864c3e3f823e2aac900075728548d784aca351f1f098fb401fd7e4141e2a374c8f252bd72aa8f55dc014a68c"),
	})
}

func (s *drbgSuite) TestHash14_SHA1_3(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "bf9508828a6df39ce1957ac53a216ae8"),
		nonce:           decodeHexString(c, "6cf30f3288512f8c"),
		personalization: decodeHexString(c, "133f95816e48f9c57b5edbb22c6ff97e"),
		expected:        decodeHexString(c, "478399dbad14a599027c8dc6bfd79d26ed36997de488de51b56671d1c1a3fed83075fe3b5c930c5a0feb42575317e8c64956207b62414896f599164e5da7afa69d07874bf168992bba0a9f9842fd1d21"),
	})
}

func (s *drbgSuite) TestHash14_SHA1_4(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "15ff59f07c18ab878336dee54dcb47a4"),
		nonce:           decodeHexString(c, "396376c48a1ce343"),
		personalization: decodeHexString(c, "924ddac14f9611ca3f81712021c7f7da"),
		expected:        decodeHexString(c, "76be3c7f886ab38c1f982cd68e0a2c4485cf69627d670159673b9f3185de190fb8df92e51643c661ee84faf91e4ae7ec26788df47672a1e3c483dd28dcf48841c9f910fb0d46ddda6f16791afba73a83"),
	})
}

func (s *drbgSuite) TestHash14_SHA1_5(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "dc5fd0fcab490b8aec8db121543e750c"),
		nonce:           decodeHexString(c, "b0ae04cce14b1d5d"),
		personalization: decodeHexString(c, "159d87275dde2e356fa81d693c5171d7"),
		expected:        decodeHexString(c, "bac7c6c0fcde7784f561f66b07a12422a3c745d0ef4d17433ae0e16a02e08d8cdbe0ed5a968964ff0aa9dddd9abd5c55904ad7da95f9ca6f745f0ffe4be0a0a880dcee0a631d3492c99f6cc5e05457c9"),
	})
}

func (s *drbgSuite) TestHash14_SHA1_6(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "eca59ee314b9598f2b9a79b22bb791d4"),
		nonce:           decodeHexString(c, "8382ba70ecce359f"),
		personalization: decodeHexString(c, "821de63abd7ccf3f74dc9e99a5f6e398"),
		expected:        decodeHexString(c, "1f35097f7c0806a6fa9399da1c45e8eaa07c6b1c8fc3dad96667de01a313938e376490e214207f79e10c2434380287b5f72c67b9147a8f5682cdaa041abb7bf324464f589c06afe1aadbd474aa51497d"),
	})
}

func (s *drbgSuite) TestHash14_SHA1_7(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "243dec1c74b6daf75c9481de3accb394"),
		nonce:           decodeHexString(c, "63a8361f5b8c9c0e"),
		personalization: decodeHexString(c, "79c60f83c9266b48e351648c991cf4d5"),
		expected:        decodeHexString(c, "a85f1e42f6b73b34fb63e5623047d2a16e9e03b9ab8b2bd035669b7edf18a71f7ee96de85f8b2ceafbe1347e9194b3a62df8ee5e069b8d1f619c2050fcf9d2db1010a493e9c0d36f46fb98406083f335"),
	})
}

func (s *drbgSuite) TestHash14_SHA1_8(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7fb905a5598e3133d3c47489b11eaa17"),
		nonce:           decodeHexString(c, "918cf0f9152b6294"),
		personalization: decodeHexString(c, "2815187728790a95bb6d22d7b092d2c4"),
		expected:        decodeHexString(c, "1556a182045706d3c860f2432ec0bbe968955ebd528c2e8fbcc5c104be889c7b76ff91350ee5ba6908c7fc18f8b11afd9bb9057281e462f5350fd678e5d872df1991017717197c21b1374b79f6f7febb"),
	})
}

func (s *drbgSuite) TestHash14_SHA1_9(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "01fb28bfa403a719e1ae11f61aae035e"),
		nonce:           decodeHexString(c, "27036cd4158f1b7b"),
		personalization: decodeHexString(c, "6e181755168169ba43c269af58ec40fe"),
		expected:        decodeHexString(c, "1de83d60a0e36f7f4f7edce03077bc9268da4d64edd24859d21a190c06a09aa3a5c791116ba12e2a13ffa5e190d1338b8f655a8d9822b84d8650958bba819bf9b41292bf5d66b49ac6ccc02b9dfd39a8"),
	})
}

func (s *drbgSuite) TestHash14_SHA1_10(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "9649465c60879b3725b92aad1fa41077"),
		nonce:           decodeHexString(c, "8e35b287bc32c273"),
		personalization: decodeHexString(c, "361ff99634ed9541e710b951b0105cd3"),
		expected:        decodeHexString(c, "0211e8083c4576a815ab2d68f1c4ae8979198d8e44a5d14f80987695a397cf71d257edec3a32bccb2e293c59173fce4a1f975e4e9111cadfab18cfa0bf5f392e4e144c48279da563bac9d03ddf0c7357"),
	})
}

func (s *drbgSuite) TestHash14_SHA1_11(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b33dca3fc104ae072a781ecc2dc4aa35"),
		nonce:           decodeHexString(c, "92d974f0278111a6"),
		personalization: decodeHexString(c, "f271500a57f6d0fa653e2a9761a5118e"),
		expected:        decodeHexString(c, "c471044678d3bfca70b7c0979d82d0d3d7c7efacf878ff6e1d30f0f8ff48aff4d639fb189acdab5b3c31826c960f444073147d8a6c8ed508188f48c95f401d002ee5dd866f0c4b05d0acc4840c6becf2"),
	})
}

func (s *drbgSuite) TestHash14_SHA1_12(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "bf2d50d29b7337e71ce129ae8f8611f1"),
		nonce:           decodeHexString(c, "3cffbf94c8462df7"),
		personalization: decodeHexString(c, "5263f5b6eaf9122c2b57c563aac6583c"),
		expected:        decodeHexString(c, "1ace79cb19719f58f320bb68e5aa531ebf5956bb2307dc09cf9ab544bfae36301a908445e4195f334e6287c90ff8a8c579f4337f88ccf9095ce23168702959a821ca7a92efb0aa748cd252298a59ee96"),
	})
}

func (s *drbgSuite) TestHash14_SHA1_13(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "a2c76004f52292ae30744b3bb7b9746a"),
		nonce:           decodeHexString(c, "a26e98090c9c4e16"),
		personalization: decodeHexString(c, "dfffada152ebc2c6e2dd7121d5844ea0"),
		expected:        decodeHexString(c, "675ed1b8a28f8f00c3b6efd9276daf5cfbff95fd592ce8c94c4b5dc9793b67eb2d9ca37aa9c0b60ec5c9a2a56839708809594894cb7adcf6c9cee794471dba01d6eba2d1a631624b6d0c36804faf6a60"),
	})
}

func (s *drbgSuite) TestHash14_SHA1_14(c *C) {
	s.testHash14_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "4a1b6e50d2854866e1c1ddb65377baca"),
		nonce:           decodeHexString(c, "7239f92b63fb3dbe"),
		personalization: decodeHexString(c, "8d2e2ca3985bd2538a71f02cc3eb5568"),
		expected:        decodeHexString(c, "0e4cb328c03faaedbec7215725851069bceae4332de6a70e3521dd065f2f7923485969571ebd7f24be460fd901c6b3e356da6ee5262ef2d76ad14eb0f697f8fb92af2f46630198c5f7018860886147b3"),
	})
}

func (s *drbgSuite) testHash16_SHA224(c *C, data *testData) {
	s.testHash(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHash16_SHA224_0(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "39af3b5438eef3242073aa3aa7a3cf1b713cd38e230fc782"),
		nonce:           decodeHexString(c, "45fadab7fd239df2b9a4783f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d86792dca80f167184fad6eba188a08160b14c324c5e279d98e5de1047402e3de71fe92aefdfe5c8aecb416757a67dcce3d0523a50ecdc381a98da93a511ac95f4a6b7a9c3192ebe21bbc27fe005bc413c1c10a1995b24078dd05727d55da602ba93a392769349993552a157f5699f16"),
	})
}

func (s *drbgSuite) TestHash16_SHA224_1(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b596a90d7dcd893bdadfc2036fc9c69836506f1a3e7c70e7"),
		nonce:           decodeHexString(c, "651cb16aeaf9514db4210a5c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "828c322f7de418314f16dc4b3935ece4151c7e124afcece08c49c4c12cdca6eeee36ab524a4896055afe4fb06c5ce2a5bcbde6e8e368b60e82592fd3b50dc2d4fac70911fde5bedbb6f0c68f7cc3a0cd5c4fa1018158830d5ede3e2115ebbbb9c38a11e8aae5696ef7e9d02b9808a01e"),
	})
}

func (s *drbgSuite) TestHash16_SHA224_2(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "5d3e0111bf4634adc2d5a34accb2dd366231664c7c6a31ab"),
		nonce:           decodeHexString(c, "bbab567ae9b2eaeb83497b40"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8de1b396ae524f4ae9f98a835d5951b342760bab11628a13a7a4dfd033ea8206c5e27c39066cdb18f82ffca68ac2829911394d71817fc7e35d17bbfc67b3bd2e9e40f68277323faf11b9559fdc0d25ef447718e6f923891d65f342506079d7fe22a33bbd5e57b1038d2348f936449d3d"),
	})
}

func (s *drbgSuite) TestHash16_SHA224_3(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "10662fcce8c1c629bc829e8d03e55ad681b6c64b84133b03"),
		nonce:           decodeHexString(c, "78b0848a2169e9fd9e1436fb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ce1391c86b679604972e97123703fe4946777533c319ef1aa9ea7fbcb5a4f26e70cb92c7cd9a65e5151d88e56d741a8c208487f33d93bfcc7aa817acb7b239111e36a80d0b17102400c1894e896d7e1ee5dee8663c651813ce938b749fdb2f80a1b5d09fde101b1ba72c1ce56ca35bd3"),
	})
}

func (s *drbgSuite) TestHash16_SHA224_4(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7de89e0492545ceb3b6b1bce17996746747da2cd6e1480ae"),
		nonce:           decodeHexString(c, "353c23b65d82f445161f2ac0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c7a6cc4ad4a983d548e09cafd45abcddd037f4dcd6835ab80f4af6922309eaeeae6f8ba5c7e0190806bf00ec749b5daf2fd2ee09e5f2095320bda0c1e26113153d207f5e5469a3979d2a7c0aa518db394643b42795799bf890d78414b1eaeb1c481f14035864a56f425d6bf38d6b67bb"),
	})
}

func (s *drbgSuite) TestHash16_SHA224_5(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2411daf4e0ef271c26d7bfe46e25277b13244be8bbcf9445"),
		nonce:           decodeHexString(c, "7fd5297678093b80876badcb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8cc0db0f68355fea00a6dc1361a3f9c44bb87f3ce288c35d0e5769b7890c0774ced8bf5cacfa7cc4b774f83d6465128c23adfef61974ebf8981d6b48587604f9ad8fa943ed52302cf6e83a9c7b34ba9433c00f8d779ffdcff133abc9438ea5fa3eb0bcf9a2cd8fe39f947352f94d5bac"),
	})
}

func (s *drbgSuite) TestHash16_SHA224_6(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "99048602ebf1ddfdb73d95d0d8e212b04d7c4170e0b5d574"),
		nonce:           decodeHexString(c, "b1dfe61f43696313b7411954"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "fd3fb94bc19b82c15f4bb79768b5101be90b5c40813a3eb9e199b539b91df298749b7736eeafbf6000bf5ca1d65eb5cd642acaffd1e1315d8324b54a7c6fc6988108979ac1bb5646fed02f72fd4d3dde3a90a317fd853c771465110fc7049625f2ad9b54c0a04d78d0e584e74a7ade70"),
	})
}

func (s *drbgSuite) TestHash16_SHA224_7(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "d97b3e0a52771dad4581175a169a51a70ebe877e506781ac"),
		nonce:           decodeHexString(c, "f31e0f4ae9109c1c128ddec7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ebe9286c56e9323670c12510b912150ecd95f9f13ec5a1151df0fe060322144e81f68c24135dc0450d88cc370bbbb539437829da659622b27e1eb8645249518591182e126c8b1da02e511f59340eba10dab125569e56d51c41f61cd0e1c359dcd0aece6cde268b941a7681b1c78da57a"),
	})
}

func (s *drbgSuite) TestHash16_SHA224_8(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "74d9e68b256193fd4abd18f6a3ed0c48558039a1a611320e"),
		nonce:           decodeHexString(c, "986fbf89ea3f65aa491bdff4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "79a3ed8db4ae607601dbbe2690fb01e19aea95f30ce563d0cd39b9fd537f4c048b5136645cd43ed9e60d77b21203a70085bd8f6bd16ae33fefda796b11cad5173c0af42ec369eb9422a4453187871a0f5be7b381fca79d4aa05d50c0d59ebddbe7974ac6a387eb27f70ce4f679fa3ebf"),
	})
}

func (s *drbgSuite) TestHash16_SHA224_9(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "cdb221e409443cebc91f9ee083796595aaaccb0dce24da0e"),
		nonce:           decodeHexString(c, "925ebd02da9e4e3be1bcaa6d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "826005339522db9c7c7399c390bbf4f6bbb5c552cad487b443a3ad1e5db3622a98ef61f712b03c5c5e975fd4979ed9fb6d057340855ceedd8d45a6468762d2726f313ea23a1dabf101bab8cbbc31eb67dfca58711aa16f07e553269c380266e04face8bea52dcc6f4c3b7f901df01bc8"),
	})
}

func (s *drbgSuite) TestHash16_SHA224_10(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a961eebabb968499c010a92e71f0222119efcd4056961bea"),
		nonce:           decodeHexString(c, "daac098a7a136c8a847a8e25"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5584363551b2f93f31df0796d72449778e5e9b4f02eddfa06426d6857818d385343a553b55924ec848cabd6a1a6ce3b6bd1e0844e1b7d55d5b8e631cb24cdacaf7c2ee5452ad41ef419d08b53336783f93f108be30a0d9db24dfc7e5197adb2d53ee0537078bf946bea1b6174dcb06f4"),
	})
}

func (s *drbgSuite) TestHash16_SHA224_11(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2e66c4cabd72b8c2f8094370d7b118fc63fa9d24e9a40299"),
		nonce:           decodeHexString(c, "7342a6af50601e3fa9d20921"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a55517be119c37c3605d3b1aa4680abdb8698d9ceba46e66f702b204c21c8cc980ced84759dad161a3a84d130aeb4c37ab41ac83ee696a8ab3c9656c5e4f7ca51fc9830d3841d29e2f38cace9d22195242626a7b60ad89acc32b11aedd82eac3401e246361b61c05da5226645cd6592d"),
	})
}

func (s *drbgSuite) TestHash16_SHA224_12(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ee960f5e2de2b565c4c7c4cd8b0aeff9bd0fa294ef2dd19d"),
		nonce:           decodeHexString(c, "6aaffa9d66fc3545752b167e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bdd50169fd9a819f429fc7ad947394ee155cde628469df339fb479155e6b232aab084709aeede7564e1aa0cce6061760b1a3cb36730964d9060b970856009d0c6701fd61243e7c86f09000c2d91a9a429517737174fe99a9442967218bf8d9701bf4e37736ae467cffc343f0f2f5cae0"),
	})
}

func (s *drbgSuite) TestHash16_SHA224_13(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "10aaabbcae9df8a6e9b45d93872e08d470a5b143fb349e60"),
		nonce:           decodeHexString(c, "2f2e4a64cc4ea0f25675c5d5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7bc574e9a6e0cf6271fd7fbf6f8878373763e4f925239339bfba8cdbcca600213ca667b6d75e8ffff84ef6963b3023b0fbee76d890af3ca4c552585219197faaf963d6007d23522d579d2e874ab1dc517c0c2092faad19e8e10f7c417adf02391c6da6e27be0f60af99d2e3b4e0904eb"),
	})
}

func (s *drbgSuite) TestHash16_SHA224_14(c *C) {
	s.testHash16_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "08a325accfe119fa807a95e8cc2cd8ff041ccad8e2c4cf49"),
		nonce:           decodeHexString(c, "c85baec1c2d1f3f189eecad5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2567712d6fd3b52364b508bb2e4ae18e34b155dbe99fef9acbe21346715d36c538dc380a5e5900e0ebde76c779006fabe2b3f171fa63fa0f5ba264748278549c9beb26db701c8fab7adfdf48eb63e48ca6f3be8f17131c5e9145f5dadb00fe666a651d2b1b9e785fd444b05d4efa8ccc"),
	})
}

func (s *drbgSuite) testHash18_SHA224(c *C, data *testData) {
	s.testHash(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHash18_SHA224_0(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9e7e20ab14485f3638d7c21057ba5014b64bc6b555c0c07f"),
		nonce:           decodeHexString(c, "a5123d9e723137f2f735d16f"),
		personalization: decodeHexString(c, "fab61ef10db3d14a61ee7c4923fd1dce1b0de0c74f3b1b5a"),
		expected:        decodeHexString(c, "1d5adbf9a0dcbc7754b669d49c4b36ad5cdf12b8a1ed0854797d11636f9c901a4be0fb295c459cfc36293fabd40e90419b6908f41fbacc4d8569731f376c35d78634530827173dd7db7eccf616783576133d6019b869ebae4f21524092fffd9b0909dec7e49fa3e465d07ae5103f0892"),
	})
}

func (s *drbgSuite) TestHash18_SHA224_1(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "48f5b0e478ef1381ba5736a31ee174450b4f8c5a7ba4ffc0"),
		nonce:           decodeHexString(c, "b26b2667562dab396fb38979"),
		personalization: decodeHexString(c, "602dab661d8e8b90b39d12819f147360519a27aeddca9bd6"),
		expected:        decodeHexString(c, "32b06226ba0ed1ac99b2717841f7a32f1f749eb89b8aa0314db53fb6ece27b7261d1d84e3b942b65cfec767e158bb5260720b4958e2dc632f6703578fae0d97d60c944b373d6070fd276a442063f91157951c7461f25e05e024bf44c0deb5feb34828b930437985e0f627ac5f4643db6"),
	})
}

func (s *drbgSuite) TestHash18_SHA224_2(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "595a904e81b8f0e78a9af3cdea59c1e4f1e8d1828c04c3dc"),
		nonce:           decodeHexString(c, "7b5ac38c3aa063227adadfa0"),
		personalization: decodeHexString(c, "e499452d048bb04eea2e19ea236e6c114e0684d886dba38f"),
		expected:        decodeHexString(c, "4bf95e071060bf536a681beecc5caba6c8cf0eb71e7c9647eaa953a3ddc8ff3ab4f8d8d76cd119cf339c491e54e010c7825a74d7658a8ce1924e1f24ab60a354414aa7109a69aaa3a50dfe187f7f562e30e1dbf7c9de546094192615646885841d55199d0606d698fe4b7342704882fa"),
	})
}

func (s *drbgSuite) TestHash18_SHA224_3(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "bcf847f45abc8eff6f7a0e158e1d27a4663e06d1cdf4705a"),
		nonce:           decodeHexString(c, "6887396363601d522026b579"),
		personalization: decodeHexString(c, "7c86288e9f3fc1b6f7433f020e231ae7d88dc23bd4b1924c"),
		expected:        decodeHexString(c, "696c8477989bcce357e6297a49ef021d5fa87add4b5eebabff8d5e9614c3be39dc432d0fb9168d7fe30c8aa6532c7499cbca5fb6de898ef785cb1ef1387d5e15cb07d699af4eb3bf4a2b70a300c625edc89e78e2539cbb4931df82cd5814ee2a2dd17829171d1b52ea850bdb79052be0"),
	})
}

func (s *drbgSuite) TestHash18_SHA224_4(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1b2b172021f45e443242a0f4be9843a94ddd558118373558"),
		nonce:           decodeHexString(c, "a53e39d64c49013038ef6bd4"),
		personalization: decodeHexString(c, "94f9b7f659d945105e07882bfb1910fe37b524e22145177a"),
		expected:        decodeHexString(c, "39c8a23b7fb65e08574eebc2a13a337bfab83fe86c4357cb8b70b542f20b6326bb9dda38f872e1ac12af4b69ba2192ca791b8bf0dce95789356ccea93ac1f8eb2a8a8016a76cb11e24054af33d3bbd873d6668c25386204d75efe45841865c6ebd8e659eb3fe7b35a2f530c21660e377"),
	})
}

func (s *drbgSuite) TestHash18_SHA224_5(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "98974198980fb7aeb80c1236888aeff4f3dbf3077ec9721b"),
		nonce:           decodeHexString(c, "b0bc98b7862d920714d45e0b"),
		personalization: decodeHexString(c, "d42f9cae63146b60778af96bca786400e39922907d72750a"),
		expected:        decodeHexString(c, "0ff30be6aa0ae9c5f88fd185775539ae3cc2f758e3e3ea8973421f1e80f326552308c3365a0c515ee402a70eeea86a9a6e1d0324e7af59c983ea0f55f74991aa86aad89faae5f4dff40e3ac5050d465323ad34586e9328dc6a8949c6d96d74ee1a266eb6f21593a43f7875289e6e6002"),
	})
}

func (s *drbgSuite) TestHash18_SHA224_6(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "93f74a2657f77af265ff2bfe239dbf791b95c393741925d3"),
		nonce:           decodeHexString(c, "fb6b25507a03dab25e16e90d"),
		personalization: decodeHexString(c, "a7469a28f62717f55d37942a1b5b1e0b8826615946230e98"),
		expected:        decodeHexString(c, "3263b77752e82b44c1d50c89587ba17d065b75ed74060d3b6c8a7da560abf9477a807c415f927b501b323e83534817f2908e468c1381de28003fe84840eb0c00d38e4508651113cd718128ed139e1d73392a8680e3c6bd48c1bdef53fce3c7caf869e80d451b1ecdf9376ea8af013618"),
	})
}

func (s *drbgSuite) TestHash18_SHA224_7(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "3ab557b366e5db028976cb6a10b93fa1ecf15ed083035932"),
		nonce:           decodeHexString(c, "f2a593ec45593a1c5f3df02f"),
		personalization: decodeHexString(c, "b5ee3645bf2e69d19db24ceb4108bd1744581006d3cf40e3"),
		expected:        decodeHexString(c, "0b54712d4cc97cf575141cec2da8f0f454ea1b1e2160991f433f976132f3022045bb6d9f1adcb693a72fe7c7a73463c7eaf805fc1782bac89593b9fe313d1bdc4b46531a385d5885206c3b45a663beb8cef069c1fe5748cb595a23f146e8eb964ae312a53ab0edc870585bee280c0bdc"),
	})
}

func (s *drbgSuite) TestHash18_SHA224_8(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "5d37382677f0f018dfdfe2fe52ab8889fe66632ebef3b3a9"),
		nonce:           decodeHexString(c, "23ac3092d1d655aa549235b1"),
		personalization: decodeHexString(c, "fc0287a70afa3b32f2976aebaa9180d2f75a0cba5d60bea1"),
		expected:        decodeHexString(c, "50203b0d1790105742988c2d522c2aea0f214ea7838bfe74133f088673a443d861ab61286843ca8872827df9ee911feb6d1fefe207ef1207c469c8d782a1d8a3592feeeadc69e889db030ff56bb1dd867542aee785d00ef3052b846906d554be510db992400e58e8353b8343dc672eb9"),
	})
}

func (s *drbgSuite) TestHash18_SHA224_9(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "08af5f91562cc16d21de2e752239c08968688e24b789f254"),
		nonce:           decodeHexString(c, "1c14e7e904d5d1a07a79f97a"),
		personalization: decodeHexString(c, "ec3736f64db617371be06196aebcb684d3fa9ac6ce1354ca"),
		expected:        decodeHexString(c, "7b78c3f9be80926f962d9fd68c53428a6de1472574691e88ccee58ac6c1de0bee933e701785fa97740cfa3e8ca305a2ff9ee08d8a496551336696e6cfdc9b1a543017461518401e5db39619d005626421d3b6b005c2cecbd36044e49388e5f8715341e60e9ffe241165519474f21664c"),
	})
}

func (s *drbgSuite) TestHash18_SHA224_10(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "018714fb60f53fb1963cb015a48c34fa7dba0054292dd8bb"),
		nonce:           decodeHexString(c, "98a2df9ae9be1ee7d55263a9"),
		personalization: decodeHexString(c, "acb8b85f7b2d82035d6394fd5aa55e4c75d0f801c4033e25"),
		expected:        decodeHexString(c, "a4e60d42cb81c787e51fc988e184fbade8f66253988823e9d48d9bb1ffb971e5fd4ed5dd2587d957303dfac5d7615160790d0345d9ff5654dbfe2d67a6477c210d27578eb66ccae918d6bc1898e00e943617acbe4c3e7d7513157a63d40684da25a6a53fbc0dc5765ff14f961728fa77"),
	})
}

func (s *drbgSuite) TestHash18_SHA224_11(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "73faa419e45b495c279958ce1711f05dc0c08d2c2f4c4e9d"),
		nonce:           decodeHexString(c, "b251cc83a727a5487d8538ed"),
		personalization: decodeHexString(c, "7896475d8edfa394f97b99dfa997353e4c5b3ae77b683288"),
		expected:        decodeHexString(c, "e4cbab42a9ceb0c61bd63ae1a5dbe79338a32a98874883acd69b9ce7f5360ee04f7fd18096dc4f03255b8f282ed648a4e6ede977fa648f658fd1f3f191d8e72022a65b14d7fd8ec98564117e98f123db1e9187a6d553dd576dea6ebc00401d8424fe3d0532f8178231e7ce3b6b9f668c"),
	})
}

func (s *drbgSuite) TestHash18_SHA224_12(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "10176715b5690e976b4f24f2f2602a8ccc2be365c7627a7a"),
		nonce:           decodeHexString(c, "5f3c085a00995e66377decce"),
		personalization: decodeHexString(c, "737bd459570a832e5714024ab2bf23c82221aaeef17a67db"),
		expected:        decodeHexString(c, "6ab86eb8b59124591708a327c621781003b5d02b1ffef62746be109dea8d14eb6fd19787eb10f00b4c49eb444596019a7298260b58f0d4cb7f78f2b38ce5ed5ed7c8fe434a9352e43d16e0fcb7de0a4bfebdf3ad178e692a87407c99e7615ee578cb48e8cfddeecd779e795640797ed3"),
	})
}

func (s *drbgSuite) TestHash18_SHA224_13(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "38fe230e10f88c866e6a24da2dfb2b673c089e35e0121165"),
		nonce:           decodeHexString(c, "f8c136acb3462ed183bd6160"),
		personalization: decodeHexString(c, "8cef1f8bc7a7fe65bc73497ae9cf14ce9b19aa89f0d7a21f"),
		expected:        decodeHexString(c, "f52a7ef834d1b1fee9ea9537aa9a8ce7ae1568501c03c865dcf1a9539bd90da4a0baa9696c27b55cf00a4012345bb86df73f6f735f50809261da19f737a2dfdf8f37d8cbc7fb1a37b4f07f47abd40c6c2941e1599875f3ccb73cb50d440b5ef8282bd7ea7accffe5ae23092e462c2664"),
	})
}

func (s *drbgSuite) TestHash18_SHA224_14(c *C) {
	s.testHash18_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f7c0487018b79c81579d97ce58732c2be599c043bf8d5709"),
		nonce:           decodeHexString(c, "e41f19a969494a2293ad0542"),
		personalization: decodeHexString(c, "f67bda6553b5e4b89e309cb48a336b78460aff498846c2e9"),
		expected:        decodeHexString(c, "44d544ac910b7668ba9c5524e388957520fdbf11383808a5a8008d119aff7e1e2bbe63b4cbff19455f20f3dc79ab0a83dcf0e403728f2a2b2a9f3b98930d9f285641da3b6b9a9467b2701ce1ecac82bad8214bb618c40999f5023dc2d97dc1a53a0296d44f6fc9d49db00959c89e9f5e"),
	})
}

func (s *drbgSuite) testHash20_SHA224(c *C, data *testData) {
	s.testHash(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHash20_SHA224_0(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9c65020f706e8c75fbdd78ea563f84cfc6b9050dce27e4ba"),
		nonce:           decodeHexString(c, "9f1c43b205b36fe351b65c55"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "99f53667646f88b47df606644c02f1c61adec7c89d50258c4f8a918d06a8e1a043a23b083012ccc86b3939e05dd97a4540e4e3eb9f9dde191a3187455c8804dc80142d2567abc93f8db756d03d16683ef754caeff10f58665aaa9663e5b17b06ed8cb7338532380613908eba86b763e3"),
	})
}

func (s *drbgSuite) TestHash20_SHA224_1(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9d68decc71bd587f078feda4375446dd17615396a44f127a"),
		nonce:           decodeHexString(c, "e67844f498d87e8bbb8f57a3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e34545e29a6436b38bbb55d40f1570731816ce159c1154bbc9b872046e5a9035a7cd55f42c0cae7ff36388b8a25b0ce89daac4ecdb15dcf31b8ecaddf7cbf54a39916c829dd4ce9efe89d7e500d09fa31d641c01a6cb69da78d365f0b802ac1ecc4454d38caa02d4b42dfc8cabd75423"),
	})
}

func (s *drbgSuite) TestHash20_SHA224_2(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "4c1b729c232d90a41634350b6bf66ccbb95658a325a53253"),
		nonce:           decodeHexString(c, "1e4763e6a25dcefa047031d2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "61eb52fe649811b66dec63a356a3678e7cb207c36e58ad8ea8d91a58b94428f2d4e69ad49e24935da38efb2338070d8ac72b0cfb8ccf0add461b33ca9c5a9f6075fd06cd3aaa129c1983136c6a3cf220ae5db8cc6bba70b5092cc1cf8a679e01cc3fa76df54a96c36ffa684ca465515f"),
	})
}

func (s *drbgSuite) TestHash20_SHA224_3(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a633333cc2827486dfe3a5d321f2f4b6b52661cac187c28a"),
		nonce:           decodeHexString(c, "1441e4d26478d9ecb0392802"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0d5f4c53a2ad1422490b29479614d864cbc533b8bea9eb6517aff19754f4399c29b536c7f114e41f4c477fb366c19242da40116e6d690717ebad47afb7903ee83537fab189e0f866c12b2d3029528e89d67d557e16b79ef18faa946900a45b863e7de3e3b33f899fe4fc6881b72b6670"),
	})
}

func (s *drbgSuite) TestHash20_SHA224_4(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "6109f13048e43c82a8808c4d946e6724619a25d7314bd6b9"),
		nonce:           decodeHexString(c, "492ab3e85d4fc964f97d53a3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2f9049109702d4a7e36396268a05531c43c2d129cb12096163d777d916a8c81c9495387e3d74d78e63e20670890bb47cf1ff08c760e2964a66ca22bde0ccf8c6cfed80f69a53ccb1cfdf7fc26d928cec7e6df29c9e96d71d9471e25290dc267247096ab90840566435655f793baeb0f2"),
	})
}

func (s *drbgSuite) TestHash20_SHA224_5(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a7a8706c6aefd2ef52761c6e121b43e4819ee7a8e554b401"),
		nonce:           decodeHexString(c, "531f90167a768935c3ab9ee3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7c010a60a29fdce26bf05299ebec4237d0b003318e556f65283d00dfc95253d93d18da301d7546dcc89634c1eb7f68439aecf48d2bb43f38125cf8be191414861269df59066f2f6257b6df2e36c2dce63348a68c778bcbb62e8328d8383d0c3c197aabf858787462f737c34ce99abc43"),
	})
}

func (s *drbgSuite) TestHash20_SHA224_6(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7c240d7bd377145dcba9299c3f2566f0661c09a21ba7424c"),
		nonce:           decodeHexString(c, "48e79c69684578e3759d9020"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2a9bd64b633a397cd0d5f3154fc049da73a2db8c58b46c26d8d7eccb0c92e2979e959ecfa6abb8c8a967f80b7c530e879f93933acf230bc056755324d9521453643b99b6f8d6403d65e75934bf905cc6b55d629237a3c12d8e8c3ba9c75e66773d1b755f6020ba0cef47964138bfe8f3"),
	})
}

func (s *drbgSuite) TestHash20_SHA224_7(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a14bd07bb34467ff2e0bd383e8a0dc270c60b9306ad644cc"),
		nonce:           decodeHexString(c, "e33f6bfc74044cf7c222cd40"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "61d7e0d36ec226d6e6873cf1e06fde37ea126b217decef90d4a33e4141e3647b09cd80845c3efc701df4f374f91b5aee0548534999903640fed0ae12c1101d1d999b0357c4ce2daac8f7632e6c3f176edd4b5a2fae1798efb488795bfd39b53a881b4b53768d123d05c159726242849a"),
	})
}

func (s *drbgSuite) TestHash20_SHA224_8(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e727491d18e47a6a0729896d98355f62ca4a36ad73eba327"),
		nonce:           decodeHexString(c, "05f43e9a8a1eb0bcd450d51d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "253429a4ea44ba84ca5985779956bf7763fc0b60c3c93d51fe9d514b9aac7a8ccb80f798dfbd0581650cd84d4c23c6367c9e5078fc7739f19b7e2c1850ce694e80df4a7c639d9167de53132905abdab64311571d437c3d985f794748bfa78ce5452c1714eae0c125efaecd8339eb71c1"),
	})
}

func (s *drbgSuite) TestHash20_SHA224_9(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ac963e16bbb33458253e166033ed0bc4924899e1e4aee9f6"),
		nonce:           decodeHexString(c, "fa04ef8bd29881239220c38e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8495d2df82bb3794ffc19e43dbd3097f181fbf4c5d801907b9c74a9be5f2b5ccc43aef7c137cc367a98bb58577c748c9780db7926af184db912c3fba177cfc64dd28dc22f1d423c1df3e92c5485a0d6883c828491766010201756a6f46184fc9bf65bf377710a483144ec82b83eab26b"),
	})
}

func (s *drbgSuite) TestHash20_SHA224_10(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a822fac1fc504878de7d02eae642fc803df432dba16f7a27"),
		nonce:           decodeHexString(c, "fe6bab4221b751687b3f8714"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "77de4777faa5fa60ec7aa8fc1803fe8e63adcbfd3edbe67325c6eea9f7e1ab0ae572562aa6a4707319c8d3324d6eb240545264258f6caa309778c44dccda298ae7a5cc973562696d7eb07a21a019631a839fff3e7b65f4ca6b1e4f336494d5f58cd738d7a2e515b9ca771d96301ec58a"),
	})
}

func (s *drbgSuite) TestHash20_SHA224_11(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "d5bda6bb1db8610502b3c38aff5f68758e0cae2bbf948014"),
		nonce:           decodeHexString(c, "388ca55b9b21b61edb225b13"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "abf73fdbe8330272be77a28ebab485b9e32d368b38589b62bfd24e2b18b95eec681810de939b9c297a520c2938460083c86d3a63b86e1f2dc6f2b27e73c6825ca780b4d80d1d7b46aad53047ef73b325bf80aba04567320cebb9b69411d3d4858079cea3df45ad8ed77ac0ed4abf7fd5"),
	})
}

func (s *drbgSuite) TestHash20_SHA224_12(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "8404ae2e83a8acf41b4bba86cc32400a2721f0de90150473"),
		nonce:           decodeHexString(c, "66dda22b74aa8abe9d70b62b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0edecc03b6368917de3877ab5478f8b52d211e9460ca8ccfd3c84d5f3764997fc15ddfe77452e7d1fcf3169215cc76a949d0a1487127604cfd7114330c7de19b958e0d70a4c2f1bb051a4afa444bbce831f9453399bb14ee241e58685af5d981f43d3d0b3e7d823d4771ba3bea93f82e"),
	})
}

func (s *drbgSuite) TestHash20_SHA224_13(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f33d76bd0a5f52f3e8bcc23a3ee312dd2665ad2a5352fd7c"),
		nonce:           decodeHexString(c, "0b1a57561b83783b52efed0a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7faeffe318d1838a13fef2c6385a89b6a59095d9113fe70a49b83f89e4c87abd47e427185d6b2e6e58da388ef903fb932429dbf918190e3039f4e8a105e589a45f9f26a48db4caa13a7b8dec6c34351e08ed538353330256535daca6cb917988e7a3285100d5b4d3fc0681d9afe51a29"),
	})
}

func (s *drbgSuite) TestHash20_SHA224_14(c *C) {
	s.testHash20_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a71c303bf17e128c8e0aa07fb61ccc1f40fdb487a955fd95"),
		nonce:           decodeHexString(c, "d3ca16fb12ae4709d411e5c5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "61a51fe1eca4cf947bbf2a77d643e7963ca2c587e0eacc8f7fab3b3f0e166197a4d15184cec4f0858de2773d8becb339bbb18ab2c10c8b246ca66dce48e2a0938fe1ab122b4930d603b937491ddd3d10abac731957f2e1e030eef33f7f311ed782b06697914145e266d0b967914d638a"),
	})
}

func (s *drbgSuite) testHash22_SHA224(c *C, data *testData) {
	s.testHash(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHash22_SHA224_0(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "bf6003e9570026651e8cf7e8ac75b68291380303d65c7b23"),
		nonce:           decodeHexString(c, "7780ada8e5577a0fc81f8ead"),
		personalization: decodeHexString(c, "961c0e8f9723d8065452be8fa8a4f87cd7759110a5e97aad"),
		expected:        decodeHexString(c, "b2fa39f5c5527462831f0eeefd39bb9eb42966199addcdb3df94c1a7410e464efdfb06e057826e7f1b03bfde277ef84954a9ecfd5b83ff8a39b77a7ce2d98e257d2903732ae6605bb624923250c91926243354f134e006a43f653a80c0809f4d53828b9fc0113ac2265c1f1cbd6ec6fa"),
	})
}

func (s *drbgSuite) TestHash22_SHA224_1(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "6d405a2430af83447de6bb4eb49d0f2a734320b6c8dc01d2"),
		nonce:           decodeHexString(c, "25fd9e8673e6a1660a2ed76a"),
		personalization: decodeHexString(c, "cc5054d440c96bc2a367ed15e3a8cf0813ba92435ec682e1"),
		expected:        decodeHexString(c, "c4af166057f60236d28ac0ac707edaf0bc71b380146c8ac3e7ccb8739d78309e853bbb69e6b9b6fff954d292b79e6f7b0b2c7dec071c289819306a2097b3a12c637f8c5a46391485c92173d4c446d75d7a7e886a13cec8d8d0accc724f6962fc6759194f5b51ae978368c46232913de6"),
	})
}

func (s *drbgSuite) TestHash22_SHA224_2(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "fc56dbec9fe303db2046e838ebdb1a86dfd2e8ea2163433b"),
		nonce:           decodeHexString(c, "cc8ced973c8d6dbd314de957"),
		personalization: decodeHexString(c, "c23dfc21deae8c28e0ce302f0a40e835e0f6418e42f062ff"),
		expected:        decodeHexString(c, "1e652571eab5c7fe644d492f594bbb65f2cec1cc709f59c914f8d5839292d71e3e9dbb7a30f7536097211a2db3d54bb4821cd6e19867cdd35d5022e1be5ff0baae0d3b29a640f0c4e3ec1fe8bb684ef042b5f2fd569054e4273ae5090345e1e919163a29a1a85540c25885ab7b86c060"),
	})
}

func (s *drbgSuite) TestHash22_SHA224_3(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "13182a94147ae4d3003d849793c8565766b6e5983e7b4e24"),
		nonce:           decodeHexString(c, "a46fe731649397ac3fde715e"),
		personalization: decodeHexString(c, "b9ff01eddb2d0a4bbf93c7d39bbeee0eb2b819ceda280efc"),
		expected:        decodeHexString(c, "47c31300337c2cd60fa6a335f8facc96a801c180ba6802188cd180b1d9f0240eaa6f93246ba07734475859c0d2cb480b17bdbed437ec1135bc0cf4440abbfac52d6e973a8f38eadfec8aab3e7828873e9bb9d98fda0daf7f20bf588f2fcd11b9cd5b35e63a8762f7719bb76e33d30b01"),
	})
}

func (s *drbgSuite) TestHash22_SHA224_4(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "41a22ae37622c9e569165bf8e49f343f0aaddd1e95428ff2"),
		nonce:           decodeHexString(c, "03959dccb3997763b67a493b"),
		personalization: decodeHexString(c, "bbd24c4ec6973f8bafb9480f387dcff2e0597409d3c52897"),
		expected:        decodeHexString(c, "2a233dbffdca2341db0f8d3a34d9e4370d4e9ee329f4a12853eb0a1792369965f1e70500b02e4a3f92a9c4fe7df8ed7c94082c40db6fe098f7dca1e4a84e3c93fcdfb8f053ec20ea09f94805a51ba657bfde5364cc049caf8bbdfc20fc0a47ba4a753785adc3f91d262c03eb38f67cae"),
	})
}

func (s *drbgSuite) TestHash22_SHA224_5(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e206413826911ca6f48a356f19f7f68c721a3bf61583bbb1"),
		nonce:           decodeHexString(c, "093b4311281b519f803ba9e4"),
		personalization: decodeHexString(c, "d26a88780806f78f739ac7a7ed7d0c24bef62f4b72df63b0"),
		expected:        decodeHexString(c, "4bd1a7832e7acfd81d413b2d1d6eba8bc20547d3a956b11231317a3d31cc062952023e7eb65410c1da56150befaea9846180a850ced118c01d251b1baa271aa695a420edb2d24bb96a0d7fdb75bd35aa384a36262ec139a9db6b46a5a770bfda54306341f0eebd693bba2f0f73761fe5"),
	})
}

func (s *drbgSuite) TestHash22_SHA224_6(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ffe3b136da099d974145c3e1f287121c57bb3bac337b5000"),
		nonce:           decodeHexString(c, "630f2dcaae56d5f80bd98996"),
		personalization: decodeHexString(c, "abc9a770e6f2c789270693ab1914e1a07eda7532c1bfbd3d"),
		expected:        decodeHexString(c, "8ca7d3f48f15df2c2297a3624f193752f806fb44e0b8addd14cb83d7e68b4798b9a5c291f3c909e9fa2beb780da20213d2e0a5d86385ef268a6ae8614454e9ae53c23e20adb444336376fa2f512e169272cd8ab4b47999d6f9cac52c20464f2b433c9b92838bb71a45d1e676253911aa"),
	})
}

func (s *drbgSuite) TestHash22_SHA224_7(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0fa18417968db22fc28f3bb8a1c2ab94114b97164ca354a9"),
		nonce:           decodeHexString(c, "486bd6ba73fe4c9c160db841"),
		personalization: decodeHexString(c, "47b1f40ab253c3d8861b6e3ef53f4565a14021c00362ca08"),
		expected:        decodeHexString(c, "18b1e0f40ce697f5a889b514eb6c2b2c2886d3c566c5ee90733e7105bad4f10a05a115c164112019f4d8413b218ac3cfa13b7adfb0bc629f440617678b0951613bb660068df8c74f416c6e329123ebc60f0d6971f03f0d932948f93d7cb42a2aca4644e712194b0723817c38757543b9"),
	})
}

func (s *drbgSuite) TestHash22_SHA224_8(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "fe57ec71c62d1915b4f0cc7fd55fbabe922b6ac434d16649"),
		nonce:           decodeHexString(c, "9085bcb0074fb874bd645063"),
		personalization: decodeHexString(c, "c9519a97b7986f966f5da687d147b3bae7567fa87142aa1d"),
		expected:        decodeHexString(c, "1b4a7a400a666f49a01394038fd1ac43efdb32fbbff5a3dbbbe9a100cb640f3eb72fd0f23d647972ce7aa6fc7a1beadbb0d2db154ee023ce4931b9fb3f9b7d10f6686482a0dc68899769e5ae6733972c3bda40fbe0cd009c671083b6a92aedd9727d8281f45926bcb1f5c35764ebd50f"),
	})
}

func (s *drbgSuite) TestHash22_SHA224_9(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e3dd8f02b72c2ba4fd7c2975fce4f7fc8ec84eaf2afba222"),
		nonce:           decodeHexString(c, "10373bf894dd7ffd03824d3b"),
		personalization: decodeHexString(c, "b9b6fdb5d5c9aa4b4d3df3049dfd4afc57161fbdae5b9db2"),
		expected:        decodeHexString(c, "429c6f96b04987a320a5d176875df21ef0ecf76da2eb829f9dded0ae8ec50964237e0beabcd25f6d79dada7925c3108efe1b800170504083dea192b2b67754c5dd8ab3cd4a8f7597fa49795d6568a2e935d4a7e823c9bfbc7f8a72fa7304dab208885a7b0932ff4fe1c7a9e5b1934c93"),
	})
}

func (s *drbgSuite) TestHash22_SHA224_10(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "dfc61f3477fd2877399d37785a63e16b2eb111b38cc2dfd3"),
		nonce:           decodeHexString(c, "d67ea41ab522165d1b07563e"),
		personalization: decodeHexString(c, "f72b1f8b77f1a6c6e9268920cde5b2c8136c5e6b7233fb36"),
		expected:        decodeHexString(c, "a671c514bfca26220cfc979fb13e05b4a59007d2bc96d3626afa46f68b443f003672a557de10fca5dfdedff67f1e9a3f4cf0957d8d2f6c1274854b4c54822ac4b94606a175dce53decc5702c94d4bbb35c7175dc28cc0a0ca8278b9abd8b056ead8af721e4a20492e40706ee71e7b497"),
	})
}

func (s *drbgSuite) TestHash22_SHA224_11(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b97a5b9989f450dcf32018d7a1441de61612fc6462ea0b6b"),
		nonce:           decodeHexString(c, "1966ef1b54cfad93852dc7e3"),
		personalization: decodeHexString(c, "b64c98d70757172f168eb76bb2868409442ea80404a50a89"),
		expected:        decodeHexString(c, "4dade80f03040c7c89e5ca7d8c601de677bee101376e6a7978c31f88623aa8bb5c7084318c23e38be77e747b8b328da520bd5f1a3b2626d71e2963f59691ac448c507cb9ab4acaa3c4e52628f6c9fb0bab576a615fb0af942ec32a50de682fedbb60fb5f1d1a00ac018be7d1c4647dcd"),
	})
}

func (s *drbgSuite) TestHash22_SHA224_12(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f4bd151844b44bc43d10133fc27ce1cac4f5c3cb71ec16f1"),
		nonce:           decodeHexString(c, "16035452d515d67fc4115673"),
		personalization: decodeHexString(c, "ed9707c88d5900915e278cc673ae1d4a0c5b62049150437e"),
		expected:        decodeHexString(c, "1f6c2ba5223668f4e01da36b763f9cb633798ca06891f37a6c42f2a70b2cdb32c5d96b46a9f8e29ab132d90e3ba7f63849ae513b063778fd92f936838faef6bb66d78f13ede5a4c46476f71b0766b2127f64351e5949b40b47953b06430dafddc9fa838d2bf9f90653b975497f609107"),
	})
}

func (s *drbgSuite) TestHash22_SHA224_13(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "79c9e1064e67d917ea72eaeef13d7a98318d948f8fe06d45"),
		nonce:           decodeHexString(c, "6af7a5efbda335d0276bd740"),
		personalization: decodeHexString(c, "eb08a942b8a0a278dac3e3f0cb0b1a1829157dd9cbd093b4"),
		expected:        decodeHexString(c, "98c0c192010ae52d41b0fa86dd5e77029200491eb876976b9f72b860e17646365b2a31894f44daace5ecc70ed85a892b6792f458687dbd72eb5a6d1a8daefe73f4f4e0743e41bd8eb26f7cd8c2888f636a77a38ecb243e89cbe3deefb76d0b10ce266e68fc6b6548323f3394c13d4550"),
	})
}

func (s *drbgSuite) TestHash22_SHA224_14(c *C) {
	s.testHash22_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "bc74e505f0d4db45bf15edd7950b4a54bbf99ae04e8c4e04"),
		nonce:           decodeHexString(c, "838d1c69d8408cf0134f54e1"),
		personalization: decodeHexString(c, "f08a964b386eeadc4bbe57164d3b3a0c7c0068c49c9bc5ad"),
		expected:        decodeHexString(c, "d8af077476875fca2ef9f04013976c3c278d30592361b923bab2f7e3c8af4affac5408c390b4989da254eeb97ccdabf32f5e246739d0e532a6ea317e7dda02bae5051ca97a445f5e0696a041e5f9f2c077b26e575d749cae344859864aa00f262c1c41b2964b78f72f9cb98abce103f9"),
	})
}

func (s *drbgSuite) testHash24_SHA224(c *C, data *testData) {
	s.testHash(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHash24_SHA224_0(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "4359f7e431da8a2d30c6e0a53fc233d09b5f2aeb010f91b1"),
		nonce:           decodeHexString(c, "ef430d7678c1a5efd64a1473"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a45f79ea40f5032fa17fc43bbe41eeeb44067e389771ec66e5491d0aba88f28d1ecf415b852296f53f18c1ebbebb03c5e5a69421bc1aac4afe90b7a7978111c41bc80c12152b641d5482e4feec1b751ae781055cec4e28e675a44984f9799be3499e28877db87c127ddd388b80fb044c"),
	})
}

func (s *drbgSuite) TestHash24_SHA224_1(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a9858542925dc08bcb69d3e114191483dd93428b761fdb64"),
		nonce:           decodeHexString(c, "f6a387906d68ae5116ef345e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a9b88c7af4e02648956e3ad8ce26c67a7157436134686b4124b0fad82d08a29eaa90dff650255a0cb7a2f228151d01e1c9ec46c5528980f51695f35bcaa249bd9992ffeee5523d062201d5eec73602290fe883ad629d4b5df6acbcc9b5075b2025a07a782de9c0b3a1b04c6bef8070f1"),
	})
}

func (s *drbgSuite) TestHash24_SHA224_2(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "144e6b7499db6fd3aaddd9d373c8154ffd2c0755762070db"),
		nonce:           decodeHexString(c, "bab79a27bab306e2d23ebf95"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f6253496835bb5af6488b00987c332296b2ae545d3e528b4680a020a705c12e5ba02264d0aeca53dcd575baa35eb56ed8a0f04a2b48ed5339072c7b37acc0568e59cf03c5dea832a96a980eb3a1519121545c8d089ea0cc91cf17f1bf97f0970b57402f7e01b4f6dc1409c9a0155a048"),
	})
}

func (s *drbgSuite) TestHash24_SHA224_3(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f576df3cd49a7fb3ebc99caa21d022d0472bdad51d54b0ea"),
		nonce:           decodeHexString(c, "5fb61a2c347bb89d74ac36d2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8face2b28607b247f82107dd616ecd23a51cffa2a2800207dd60da0d5e1e793b39e438a284690578a911bd42a33fdc4f25ff47dd93dcca05a8e5d5ab9c07dbca211dd0f4dac999223233e5d7aac490282dcd981012aa8228c14417ef5cdff331e47c3714a930b6224e024e5aaefc195b"),
	})
}

func (s *drbgSuite) TestHash24_SHA224_4(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "194639e5abdb1af8fb1c69a58a8b9082706a1994f5e7692f"),
		nonce:           decodeHexString(c, "fbcfa94a79ffbee32237fd48"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e5fdf2167e86ca9c25acd3e23815ee202241f1e848538c9dd271a2b4ddc958e2d32aeaed437fb9623504874676b35d242edf2f1afbcd29544dde8238bc611127b234ff6dedf7138f19a214d3d9f3a42738737e71e6afd0d06ca8752d91ee6a41940edc2ab14764a32e00ceea20a6996e"),
	})
}

func (s *drbgSuite) TestHash24_SHA224_5(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "80dec8a6b5f61419ecd68ad8f85d6541983e661c876babad"),
		nonce:           decodeHexString(c, "5d36cc4fc35f703228585159"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d5768005ce952b9a92bde19a65665f672353b3f1ad9fccdc0504a421e7c7d6339e562f6419d1ff8ce08042866bcd1e482b83df49a6db756aa1a2b00557275540e910a7aadb70db4a570c8cefde394a712adfb292c93907fededc26540cedc10d75516f8232722457e56af1ba1b15cea3"),
	})
}

func (s *drbgSuite) TestHash24_SHA224_6(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "105406056b36b6aef7ead09062234afd92ed1bc0a193dbb8"),
		nonce:           decodeHexString(c, "d11bfb602b2a0ad2c084ffe8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2633b64c11e6a22a8aefd5156397c9fcf55fe3e29e3bb972d20f25c9232fd6261ba029260608a820b23e5df227fdf1b8f2c6246cf510e60ddb18d5ba52a510dba8c65f98c6dc6f42043fc8e8364237480a9a7ae3b0eddc23648297a6842e9c1f7c4d7ae69f7623dcf76a96c5b9531eaa"),
	})
}

func (s *drbgSuite) TestHash24_SHA224_7(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "752371b36fbab5be9e34310c523af45c7dc3942129a0e975"),
		nonce:           decodeHexString(c, "0e89683eb12924f48863acb0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "42a537d7d66a4ab65ec60f937c763d038d7a27b74219379ce12c2896dfc62903ea6bfb3e22bcc90004a7cca83dab8dae1c643c87f3fd4829e2236f4e1df25a71caf4baea73417d9ed0de7e52b13b3c4b8dd200a95c8ad77b4855796f67f5e5928a729657878900dcd85fa0c168a4bd07"),
	})
}

func (s *drbgSuite) TestHash24_SHA224_8(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "78b2e69e1b9df3bbd9e91c5c1637ec8d4f8ff397a2eeca25"),
		nonce:           decodeHexString(c, "45b7fe4f558c74e873517a4d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f8d8e42a247f040b9e68a91efcac3fa2bdb0a3f800bc4bb2dd3dba7c30256722b8f4b809b4d7a8aa0fa3a594e2c6731eee1d3f3c2b08f2e85cab116a13d2691a88cd6541492014cc07955c5f8a587e4653ca1b46f9c55a9a1cd3f64d1a84798872cbab3d410d076108cd44f2f059af35"),
	})
}

func (s *drbgSuite) TestHash24_SHA224_9(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "716b62ac333a62e01309364e1fd997c0330d5b7cbd98573b"),
		nonce:           decodeHexString(c, "f4c50be56f2ae092fdd4037e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4275d4cf2fc6a66d287a6dcac96c37f200e772a124e6e60ffe1c24d830e574950e3b8157d824ad2b574975df2b78503326a7b924597def7ed4b6aeb64bf1a6af7cee3b5eebc3ef5ba496a676724201fe818a4320bf97ca48dd8caa63909b66eb7f51dc793f613f107037567143d1cf55"),
	})
}

func (s *drbgSuite) TestHash24_SHA224_10(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1125b7287f4b0faeda7d738d5ebada5aae877cf81f752286"),
		nonce:           decodeHexString(c, "22f0897a5bc208af54221e85"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c028912701d511c09541b222c49b7d86266af6a809848b6603a4e93d199f1ab610c2a674fbcb7e1d9beec910fffa82195f999a201f4d27bc3a30918ea155b7bfea4046d5227ea216a431ec2c5abcb99469e825495da6347de11d6c479928e456d4c23c367b6c2cfd848d540c8a0819a9"),
	})
}

func (s *drbgSuite) TestHash24_SHA224_11(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "fc78fd63632c2fb6ce6b2324d99e11e6cf83a33b6e88ac9e"),
		nonce:           decodeHexString(c, "2165a244df8d1a3bb1d94e8b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b7949cf6c67964fff1487a06168422e87b755e0385a68bd862089f59d76b0681b920389c5a9dfcc41bc95524fa5e040ec24f0b817c2830c111d233bfd3013ee09d3e54c10271399dd8f42eceadee0058abd26aed92ab9755e8bbc3eaf93998a7ab163cd607921f220c232ed32bbd78c4"),
	})
}

func (s *drbgSuite) TestHash24_SHA224_12(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "91c1b3ef048b9427d6bc49af4333721882f36febfca0bb00"),
		nonce:           decodeHexString(c, "b58377ace58be8dda71b8f5a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "25c113c302faddfe001699270f83d242a00d49ec346ed0a97bdc503cd945f3073dceef5adddb4eed0084bb5ee18a07a8c6236f5f4232f47d0016965ffb9333757ca778fb7b3d003a77c26923798aa00c0bca1293c32490727f358a5b548f1fc83bf8e62c8e023449c9c20a9c93a5f04a"),
	})
}

func (s *drbgSuite) TestHash24_SHA224_13(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "6789002d8743ba72ee8ee2b30489e5b60ee0d9d7222be0ee"),
		nonce:           decodeHexString(c, "da4590b325550d0723683e50"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "01c4946ea5df3f1d2d8b7a04cf9056fd1b31b2c874e5cb2046af258fce4161162ce9898de21e2228f66c29cbf318bf97080d476dd501b95df1a0f9bd100ae492fa9861136d39121493ae3d1940d2045f248dde99e4b0e741d1ec8fc816b29e3c360efc27a4c24a578334b18ec793ee80"),
	})
}

func (s *drbgSuite) TestHash24_SHA224_14(c *C) {
	s.testHash24_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2a55ddbf673f4e12538e61cd2bfda6f0316277661f553c38"),
		nonce:           decodeHexString(c, "a0c71049f5c75c23cc11c7ca"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a88e6cc37617929bee1e14f74ee363d1e05fee618fc1eb1f8abaff42c571048032c84ef0ec7a6d8ad7e6c5a4a6e90d714d76643eca063287929032fe75a2b63fb1f83ab36a7fa12a12d7332459bba56b017654bc0fc29beae1897863a63276208f9d11a32780a627135b271efda4f4f0"),
	})
}

func (s *drbgSuite) testHash26_SHA224(c *C, data *testData) {
	s.testHash(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHash26_SHA224_0(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a26e9537dbdfdbe2c16ce370e309def06d088db2f3642230"),
		nonce:           decodeHexString(c, "4618dc0cb490dafdf5ba6147"),
		personalization: decodeHexString(c, "7c26b15ff60b195aadb5a9a4d25f70aeaa84265b27d73542"),
		expected:        decodeHexString(c, "9f0a324c3ce414ba2e966d3312fbc52536241ccf9bce590f15dea7e45d8e7806d715a4a62b541a8c55366d96583ad052ab2f748e47eac850ebaa2e891db60f8a7544e7d6fee7bf506421eb899c11d827842385473e88830ef8fd068e32e5752caa8b2b63b1be888dc561c2a553d42c42"),
	})
}

func (s *drbgSuite) TestHash26_SHA224_1(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0d92b4e01fa4394d802b79ea8f4c73006287367df2155d7c"),
		nonce:           decodeHexString(c, "71050e82b95bf8f5d21687e1"),
		personalization: decodeHexString(c, "e74a641fbe4ceba851456904ec9e8ca4218e670a18019098"),
		expected:        decodeHexString(c, "49a66c2431185f175a2b881a0daa796e0f66df9bc96e446647769f5ebb6627a4ef09d299ed4deda1fe99b4c8cf7022dff28fce6b3de3124f92480d8f83cfc49e4b9ce114a922d66e96d1401aa6203e1655dc0b17f0412b61dcd4fb07f35d0c8ebceec459a4af86fbacab1541d82d6e7b"),
	})
}

func (s *drbgSuite) TestHash26_SHA224_2(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f08d21c58984d116c239b6ce7f0f072c4d41b2eb32484df9"),
		nonce:           decodeHexString(c, "a54d4972c87520aa415b7e25"),
		personalization: decodeHexString(c, "70934927388e99fbc9b861517909b910d242b6231a8bc790"),
		expected:        decodeHexString(c, "c4fcf36a963bf3ef0830b08931960dd0fd62840610249884f89ef2897ba8896ff09639fd7cc136d2d814bae0ea8932a83dd24c1efb730d41f4ca10744de802f4a055dfbfea225722781a9ae821e437865146c6639e87d91737057de0882c270ac6f262cd2c478fed91135a4eaa81164f"),
	})
}

func (s *drbgSuite) TestHash26_SHA224_3(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7a9f4ec4675e3db725e6f0cad3fe524d1e02d8180bb273b4"),
		nonce:           decodeHexString(c, "9529558fc7776ada7490f295"),
		personalization: decodeHexString(c, "054b2054c4ee9d9fe813ae63675fb998ac4fe0180fd13492"),
		expected:        decodeHexString(c, "c15cac5ecce3b57bcf5eea6d1d3ec4988d3c97b6d5cda287df44c2867e632db3eece965d3294eed71f8158653061b8ffee0ee8dae87d29474729451c0296597187c714d6897b3f1bcd1bda05418163ca557697277e9ee6b2c1a3c47ef5b261dd82d4f881c97de1485d0db26146ff9415"),
	})
}

func (s *drbgSuite) TestHash26_SHA224_4(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "3f87d110b5896071c058c809b0ca5008f09a9056e0630c1d"),
		nonce:           decodeHexString(c, "fc22430c4dbf9d4afcde32a0"),
		personalization: decodeHexString(c, "3dfd0c683bfdb483fc9d6ee7eb787a79ef910eb55b5f0405"),
		expected:        decodeHexString(c, "ff9bfc1d1e80d7f3eb4435c8df3e582eab3d12ccb9d7dfa33965d23e5728200eeb555e39c7ce00c964287a24a7c600dab589287ff82e12cac3534bd9e4d0a1d261f67a8e644101f990112d8389753761324447e78c6cdf4c447e59be5c16ff6d886a296805e904350fa62b498866c583"),
	})
}

func (s *drbgSuite) TestHash26_SHA224_5(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "46aeebd8df9bfa3431b183cc1d4e39929fb52d3090deec25"),
		nonce:           decodeHexString(c, "6b3ce40b7f3fa7448a938e04"),
		personalization: decodeHexString(c, "46878a6a01cef1c4a30ea47066eba37b0ab9c5b7b76f190d"),
		expected:        decodeHexString(c, "674fafa55cb6a977872b12dc3c426f4ded58e51f176cf5f591b7d84352910f7f39d66f7f85e33e30158cf4e6243f458298467e01f9df3a9723eaf685f4643c4051b76b85f4dc153b1ce9d163e49e85929f9f95b9fba3c0d96b0ff990ffc6376488a86a990af180992128fa7f8d542d2a"),
	})
}

func (s *drbgSuite) TestHash26_SHA224_6(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9861f6f037a71ca9c86164eb5c4eec91bce74ce6e72101a2"),
		nonce:           decodeHexString(c, "c2af429929d4829b4b94974f"),
		personalization: decodeHexString(c, "37f023fabe12c0fff44aa961f5412cbd0ca34f0828038543"),
		expected:        decodeHexString(c, "105a15364d15aebe50903e138cd32465b8b3a5fa2da47802d32d7a8cb75c89b5ba621c3d4ddb4ac9133c653a6cb2ccb971e9125b38634a400b8ace6eb4e99b109d160234ab4cafe83a1320354b55c89e3cd073a263d411482845d96fe1e032e43db88885871a8c27fe13e8514067dbf3"),
	})
}

func (s *drbgSuite) TestHash26_SHA224_7(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e22a7f109f9a975a80820edfde25597b1778b821338cdf91"),
		nonce:           decodeHexString(c, "9c1a3b79b0bb3edd2bb1d118"),
		personalization: decodeHexString(c, "3f7bbe12073c941c1f6ed31fb12e255ac01b393e973dceac"),
		expected:        decodeHexString(c, "536aff6c0cd2e4bb32f11170edb87f7ff7e2e5e6dbb2cffefed60e4d5b6cd6f8f5df013f5e13aa800a8c7d291e659e17f935065c481bc852c5fd65c88c9d40fcf3473048cbcda84e3f279ae1e8d33e9d106cc894cd2c549d2f0d6476dd8e783c3e9be2e116915498370ce0d2b77d14c2"),
	})
}

func (s *drbgSuite) TestHash26_SHA224_8(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "cc934eb554741f1579572a1e145c5c752eaa5fa64789def1"),
		nonce:           decodeHexString(c, "d099e1fff20fccb16208d507"),
		personalization: decodeHexString(c, "82883f10a78958c6d5b8c92dec9110893e77ff09bdc997ba"),
		expected:        decodeHexString(c, "e56b85b3f9bf7b9e74425a4488cc087f6ce99dcd9f45f501321dcfae27618dea4916083b9ccc8f3384095408dbb2d02ee8690527b2374ae5c37b699ec7f3c313289c771ec82866fe79ea025405c15b5ea154e09319a075f71a49ad6d638d99b83ccd29f47e054146240bf0870aa89c2f"),
	})
}

func (s *drbgSuite) TestHash26_SHA224_9(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f67452b2e842973883350d8866997e5e2c1feee6bb7685e2"),
		nonce:           decodeHexString(c, "9c0b03805dad87ca333db255"),
		personalization: decodeHexString(c, "0984d59b7d4a95bcf7f0f10f9245aa1651a3e3cca35f8e0c"),
		expected:        decodeHexString(c, "36cf230211dc74b6297c07b0bbfa542681c57c4bf41c5658af20ffc0ee985c892369a40629a6e713f5b4cabc3c38d2a0189174e9f5f1af10dee459f4419a4caea3613370ccaeeb9d2da810cc05064df3b4e5349f50ae5d2120216f435195432db4544f4aa3f72d22bc2286a312206184"),
	})
}

func (s *drbgSuite) TestHash26_SHA224_10(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f69fb91ad26201a137d9358ed6a37c1601abc7fa2c4b55ca"),
		nonce:           decodeHexString(c, "df47344ea318139384b1cf3a"),
		personalization: decodeHexString(c, "517949f5451e9a4c9e38802f0e841ed51447bb634447fd7c"),
		expected:        decodeHexString(c, "9982b4fb5c7784d5564e6175bdb4b11238a3d2fca5ef396a6bc2459930e56a01baff452b5c422161a5257639f175648b6ff95612fb7a2a4ab933ea0dcba04ff6bdf36b84f09a094d234945d0e4248c0a4ca5805a72e374be263778e5f7b32d004d6690bacebfc7aa3df31af8c081f6e4"),
	})
}

func (s *drbgSuite) TestHash26_SHA224_11(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f4e9a343c49283a26de114e6583bfb6f2107b375678df18f"),
		nonce:           decodeHexString(c, "f1e57f308d3626c8f4a9b743"),
		personalization: decodeHexString(c, "9007875be95be3b8f77e805204565649a817d2013b249958"),
		expected:        decodeHexString(c, "2a6a06189aeb79cf666aca755fb68db130714efaa27df3a6f0c87cf2b2dbad6d93d0a5c44dc146ab484c47e8814072fa9fda814bd6391cfa809631ca896ba762a104b601a05266eaaa80daa3458897d7f5038e433e171ddd15f1ae6c5d89d2b97b5b6513e1870c931553aab08860c51e"),
	})
}

func (s *drbgSuite) TestHash26_SHA224_12(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9c9a3402aaa5d4726e8c236b94f9f6f85132ef650b8f0fbb"),
		nonce:           decodeHexString(c, "136c3e41a55f46428031ca1c"),
		personalization: decodeHexString(c, "c2090b993dc33ea85ed255d213100dc0f9352bf9ede57a75"),
		expected:        decodeHexString(c, "44989fc040f82db3963fb5a8dbdc6630f30e7809f0eb660675fdd906b87277961ecfe3291f6c70f59a41e0990fbce70d8b8c2c50b19812056cbf168020eb9e7debe996f7bc54a744b49e79f43acfa362b90217eca65d1a70c6f57c85e589a52b57364bb666b28313e78b998e30831d11"),
	})
}

func (s *drbgSuite) TestHash26_SHA224_13(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "39ded30a35e0c0e02dc11b8fbcb9f01d54dbef143e27f0b6"),
		nonce:           decodeHexString(c, "92b92837b8c53bce250f4356"),
		personalization: decodeHexString(c, "628d19f1c82d07a6a03de095626dc93e298624c07d95277f"),
		expected:        decodeHexString(c, "61234e866121741a10a65b027797703c29cb7cf7347348aac1e600e460243be86b494102d1a8704afcc49c5eceb566cf5a0dee57cb60926ae46ed46724d1e4a2628370ea5b6258c0c187f4c385b8ccf9625a0fee3f9d11de23315a09d8090c7ef16f52afe605e4dea661900014d4bb7e"),
	})
}

func (s *drbgSuite) TestHash26_SHA224_14(c *C) {
	s.testHash26_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2a053d72f043eb480f1bae697a59f17cdd44b9f2ca9112fa"),
		nonce:           decodeHexString(c, "1ffb77244697c3d67a564d06"),
		personalization: decodeHexString(c, "62865bf0f5af2146440d74e5ac8787cbedc544de16db24f1"),
		expected:        decodeHexString(c, "1a74f62cc6bb05ff956d1af526926b937a84352830a78c7ecd2ad9c39a796f29f640d188ded8bda0e66ba81c941fed5e82f3c78543d9fca14335459ad9d573362f6b5d69861cb94c0bb055723ba5416b1fe08e74f27f23cdec9db05b50b01a20f0337cafec896f5f7412e1dbe7307e0c"),
	})
}

func (s *drbgSuite) testHash28_SHA224(c *C, data *testData) {
	s.testHash(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHash28_SHA224_0(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "d51bfa907234595dbd898908e3e90e00791e275223ff7770"),
		nonce:           decodeHexString(c, "f3813570a475aac3b7fbe345"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c2e1c50b8a0d0a0a76b0a41b3f3b46f3edf1c81918d20ded790426c58a2643ac72ef1bac86579bd93de0b8426a30a1c297b54f8a01f80e96bae7f4f1fa03e2edc31b0e44c82f338a4c2aab4905a6e231e0e04f0829450c88d17177f3305742def23f6b20a1fbd8eaad8c0f4aae0420a3"),
	})
}

func (s *drbgSuite) TestHash28_SHA224_1(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "c16de117afb858ea09eebeede6c98959cc7d23e7d76e60aa"),
		nonce:           decodeHexString(c, "3a5cd5294eb7148fe0bf49e6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ddd1c2dbc679a1b8daf403cf549bb19b8e88610df4ad5583cf32c5d7b223e564d365e5aff9a1c358a8f22938cb7fd8be6f4c187cd32c2956460d7b27dd883c5b5548529e757a7b89eb8c629414dd6d05c93b362de92f5e59f546a94f8677e117f62cc01755bfeee85fa1ed34dcc83c79"),
	})
}

func (s *drbgSuite) TestHash28_SHA224_2(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "d4c80c96d8c77c32143b0910404d24c5c60aa6c4beeee7d1"),
		nonce:           decodeHexString(c, "0fe1715a585315e7dc190e8f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8c39007e62a24a425b607a918484664ce901530372dcb62240b2b23b7701e0fabcd27211b137c428443bd7b4f082c82d60e1b882d16d603062f8170f309dbf4ab42f243a6f3f53d131a33cb0dbb4b7bd256432756878c4b791ecc1b850218a018a0aa9e85131f34400592ee859ad00e3"),
	})
}

func (s *drbgSuite) TestHash28_SHA224_3(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a79ce1a08f37ee3f37d6f8ab435b94cf28749da73eedb41b"),
		nonce:           decodeHexString(c, "0988b6bb35ce37d3f1624887"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6f048662784d28bd3c3129f0feaf7b50b862a5e02b0daf428bf90e97ac3501f378f342d987cc11a0ac1faa1550c2f2c78468cc6ad47f8c9d047f849dcb2c9b2cf6f7dbfa398ae3033ae02d39e492b8ec20e2283ada6864b3ae2057620887a369ee08cf1c812b23a31715be7f5af7d6d1"),
	})
}

func (s *drbgSuite) TestHash28_SHA224_4(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f766e51848fed6b6758a8a74fa792f86e7ba840d9a9a5ba3"),
		nonce:           decodeHexString(c, "72210ebe17918750526f6b55"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "70215dc0057e036ff584af502fc3aa1c6c7563a87fecee315c1d42d6dcb5acca0d858b3042ee8accb28306cfa2bb5d3e6e355ffb2419214f7be6465b34a0062538d6898c81feff31657480f67bd986cb1b196383b19cbb8f91a8d0c72ef9b0e884c98f6ba46ab9cd03533df2381884d6"),
	})
}

func (s *drbgSuite) TestHash28_SHA224_5(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "163dca82234c9a423748bd5e607b90af327f1cb32f64bf97"),
		nonce:           decodeHexString(c, "9504c77f0e342d14557157bf"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c295cabc4d521a9da9458718fcacd74bf07cc142d3d09260482100faabde35e329fe46e4dc1c36308199eeceaf4f8208a55e74cc4b98bedb9f63568d9f855d8a54db3c30fb0690096c0f5c3ae819110d000283f3bd8575dc532ad4b66b7efc67eaad32018967b43b4c9304122c11a863"),
	})
}

func (s *drbgSuite) TestHash28_SHA224_6(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1ca226fe84594d89cf82967429052f6d1788623fad8fa0d9"),
		nonce:           decodeHexString(c, "f45f05d64f558ec02141fd3a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b3fc16f281290a7d7a2c3afabd44f717170f6355c1453d19498427216c7e270bfa7f5d1e699881f1f105bd52dc41d0790be4dc0ae7e1d73e13c34e7f892f658cd8bc2e811bfa1fedad6070b33a8b90d53e2b40d1763584a59a688d3f887f9005919e5604ecf4261cc283da76677f8989"),
	})
}

func (s *drbgSuite) TestHash28_SHA224_7(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "d576a4fc84fd78a40a40b521075afe5e261c048cbb9d511b"),
		nonce:           decodeHexString(c, "17fdcffdf7eb1ae65cb95b1b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bad25947cdb63f878491fcfe8580f1fd18ef0e83e853877090e8aa4782713205810b1736e9d71cb775ce9664c056fa94ddc62566072e04acb1e4def924b209f9a097ebddbdfb8f8cdc3c7f1f28ee2526ba36674430398bb2de13fc622c83025d2ac61c7028d6a113c3b6ad98e67e895c"),
	})
}

func (s *drbgSuite) TestHash28_SHA224_8(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2e98287a92bd9a5503ab95f4cb4a554cc0bae99784b44c26"),
		nonce:           decodeHexString(c, "cbf0010846e067fe1a6a3560"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "81f7dd83421637be81f9e5de165e71b6a09d7c0a6ee26f6d9408dd88988c160f1f179bc730d43b96be2e7e14072ef13531717e65600a3953c40f62362f2c457e57b2dae9c759bc4af38c65d50e6f72760fe07f8dcec219d033d7e06980fb9ac4e65843b370cd8300aef092252208a07b"),
	})
}

func (s *drbgSuite) TestHash28_SHA224_9(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ed4e03b2b75ffccabeaee1ecc37ae454123dfca7bf852d1e"),
		nonce:           decodeHexString(c, "ad93779cf99817b01412d49e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "da2cbf5d47a4df44b3b7bb80134af2c19c0f5e628aadbf4c0fac5d0e6ca2babcca83a2396922d02c58cdc2771de74c82fbb48af8aaff04181076019d8041341c3274dd2242ee768c6bcd1b0aa542ae1caf4209819a30df44bfdeb7a485ff1a02672580b8a8042b0e7d4425286842f994"),
	})
}

func (s *drbgSuite) TestHash28_SHA224_10(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1ff763c25d909bae4442e148129fe050eeac7ee2f08d1dd4"),
		nonce:           decodeHexString(c, "3bbbceb8183547518df61ddf"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "763a7f1da652e50fd8aec81b81d70b58eb054e5b0d79dbfca87f1cd44600606dfb0b3e4199d2ab56a99dcd01d23b154428e5b8586a4d56031e0e82d303915ead070c2e77b5b328a3c6de274f25b57eb60fa1dc53de84fdc9449a9bc8e2d85c6ef5dc96f83690c06cef3ebbd0a28ae64a"),
	})
}

func (s *drbgSuite) TestHash28_SHA224_11(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "52ce78ea0da6c9e4d5c47dc011fb6a0445b039898e97c961"),
		nonce:           decodeHexString(c, "9446829e092993fe6c009f0c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c79890800b6c62b38b9fb12e8d07e74d7903c130e006cd28c138167e8851ab938cfaebb54db84829bfbb5a972a2755b99e051738b6d22f916d77ddd123e28103cb868545b5a0f316d488cac8bef473dfbd66846d57dfaa906aafdd557e65f2fdba750f9237523df5d60cc43290eef572"),
	})
}

func (s *drbgSuite) TestHash28_SHA224_12(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "939f7ca40e30cc2fc4a1bc8ccc7e274a55f9249e31d9aca1"),
		nonce:           decodeHexString(c, "9f3589315f1d5851e52e0736"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9aa1eccedc69e688941c876b17589ed757d8601da125bf4d81ccfb3dbe3a8776839839426f6f434155ddb82118e36f10242dab580fe588e6396f2a9931b0d9bc4f13dc38fc85a990f8b9f4968110a5dbdc8aec5d5eac0c084c3320e757117b1c9b6ac1553fc23c291bfe39f41ebc8605"),
	})
}

func (s *drbgSuite) TestHash28_SHA224_13(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "20247aa9598553f13234e8d8fe89ab145644293de871aaac"),
		nonce:           decodeHexString(c, "31a04e9b534bba701eab1093"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bd955300e06403ec6f27654fac1aa5ae176f911c8a90103e5d2b5001b37e0cb3f22b4a8c0f772f706bb954428283ef2dc341c143c1e1522f97a1a711e4c7a56d67f1384471db8eff43fd58f1fe5b61332707a08bb5624580b1ef102d774feeee046764b63e80792d871f61aeafecf90d"),
	})
}

func (s *drbgSuite) TestHash28_SHA224_14(c *C) {
	s.testHash28_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7c8a961f01c1888456ae6042caf338c3ab8b5be28b34d15b"),
		nonce:           decodeHexString(c, "61edc22b49e518eaa9e4e04d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9d2eb0a41f7b03ccae8e4e3c61628e6710f5999f3991f04ba90fb3007275d07ff169d325ab26f3446e585c2d454ff8f6cd4a520190afbc06f30ec9b49668b09de45a116b171c210f5f888cf3c273c803044b17a16b06b44bc39344f2b2acb2f21f4b0a7abafec8c8d406d26477db9b7b"),
	})
}

func (s *drbgSuite) testHash30_SHA224(c *C, data *testData) {
	s.testHash(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHash30_SHA224_0(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ad09c736cb8dda3d7712cd5c7202f2b35aae8e300af8c791"),
		nonce:           decodeHexString(c, "2ff77f55e60ff80d39407602"),
		personalization: decodeHexString(c, "f5679ce508efb1da2d956972d3b60e7de12d8c1ade1e9478"),
		expected:        decodeHexString(c, "0e56df58b8807f848adfa323418993b3d7ed775241b457f11d4897920c16d477d0fa27fdde930e936d241dca0ca7b0114b52aa778b4c8e7e01b056184a164b8295884831221ee59f00076c73d4597e4682b7be34ccb25a3f33bba38cb1f92fa64812f250b992d4f7279ed42cea6f747d"),
	})
}

func (s *drbgSuite) TestHash30_SHA224_1(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "3f35b7c4276fa70aa68003827acd417e7eabbf1d20b916bf"),
		nonce:           decodeHexString(c, "8a0be31a81791c537639e863"),
		personalization: decodeHexString(c, "b5eb60eb35397c2d3cb98d1edce6a2211da99e7b9314ddfd"),
		expected:        decodeHexString(c, "e1692317a5014ac1b8b45018b968cd7fd536c550846a9810cc5ace69dbc6dda7131738b529379c2e8c34ad57cabf3e91083c8a5781a00991365aec36a91d465d6e88a6f2c935989a95c8d5bba947669fd35d6b45dd83bcc26548d45d27f72e0a239cc1526a8623cb162d4a082e624b64"),
	})
}

func (s *drbgSuite) TestHash30_SHA224_2(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "4d461486b3f22d8ce8da08af84f25ec15fc10c4705110366"),
		nonce:           decodeHexString(c, "fcacdff9520c5d24a11cb448"),
		personalization: decodeHexString(c, "1be95db1c7f0c8b11a5d6f3701a7141a2c65d6eda737678a"),
		expected:        decodeHexString(c, "4b99ac142918528dbbaf74af8714885d674dfadf7600e82ec7aa83e37dd0da47d92b2550bf7c91d903d38f60a5e09cb0b1ba58a4175e47ebf3bc67e65a681d78282b2a1478af9d1540bc67d2bd5bb954a7e649eddac051360b5a9fafc08a24c1b77d59c467311c6803aadfc509651fc8"),
	})
}

func (s *drbgSuite) TestHash30_SHA224_3(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "db072d9325597a235926c59464ee717f8b4810de056627ff"),
		nonce:           decodeHexString(c, "4f6473ce509637b9caa79721"),
		personalization: decodeHexString(c, "cae57c3640f4c61b94359d03c6353711c7fbc8f423edf99b"),
		expected:        decodeHexString(c, "559d18ab0727efd3cd27d984698be9fd86ef503a299cec2432aef179a969b51b101995114587390a4d623ddcd396ffab11991732dce0ad364462d9ada9f2ac85b4a58b5bd5575b9693ae8199826916d0280601443fbaee51e9c8d73c1fc622a7e825dae538a51b03faedc2f1b973f605"),
	})
}

func (s *drbgSuite) TestHash30_SHA224_4(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f72f4f8a6833835810b3e0cc780f5ff555d95072197a7409"),
		nonce:           decodeHexString(c, "681a5457166ca6f83ed03328"),
		personalization: decodeHexString(c, "18718eb98db1faaaeb245072245138cb6c2da969d02c81e3"),
		expected:        decodeHexString(c, "07ea38d594c3cc10f98b8fea0a718814d31dcb0616354b0b4c8b6576ed7b77a086b673193d44de988ae90a5ee485ea6ee0030b79cb6532f11084c5cc7f35f3a8868ffbf5a77e3eff411129f1a70741dfb57ee017133c5c463b210cbda1f555ac25acc18bca1b119d99cf1170f4d267eb"),
	})
}

func (s *drbgSuite) TestHash30_SHA224_5(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9f99d3a316cb6e1580ec67e8fc5167a7759c6c6fbfe8da1d"),
		nonce:           decodeHexString(c, "9c88d540c0095e2747c100c2"),
		personalization: decodeHexString(c, "a3007f783412cb79038f976a266d45809de66088cca7503a"),
		expected:        decodeHexString(c, "835f099315eaca6cb518b4fd087a95f72225a08f732c9acad08f014f3aae3f5759039157d50d9a1714c614a4457ff7ae6318c7c09f9dd11936ab6488032ed675c3982237ab7cac5fcfc2f7cc1f0138ee5a2b946ef74bd807cf26f7df81048c940ed3237067023ba5a3cbdb47c6361ac5"),
	})
}

func (s *drbgSuite) TestHash30_SHA224_6(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "c80f7d2bfd86ba62a67cdf3404e8a79c881ce8217a9c4074"),
		nonce:           decodeHexString(c, "1d192883a140eb8d8a90c301"),
		personalization: decodeHexString(c, "0767e17904a4539e99ad56e85f8583980dfe16c80122e0d2"),
		expected:        decodeHexString(c, "f050a9ecb38a3e524b43d987649787fed31d6ec4a4020c569e43fc97c346c02d54304c8548f3be16ae608ca19ed9c343863842e11300650ae2caec61340b6f8e342a701fc9aaa88a0d6a830ae05467ac2793067ade18693843c7af8bc32ef99bdf10bc4db86b3d4a0b978cfcfab89b39"),
	})
}

func (s *drbgSuite) TestHash30_SHA224_7(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "66d5a510a0e0b51d8b028b87f152431fe48d612bfc2ad2c0"),
		nonce:           decodeHexString(c, "acec6d7148362a28e602dd97"),
		personalization: decodeHexString(c, "5001bf497d90587fb7d99bbb4ce1a4ddfe561b469e07de53"),
		expected:        decodeHexString(c, "080f9e361847528f4b8c78fe332988a395ecb87475239ea5d99dbcf819c4951e55ad7a2c140e2167cc83a14c98fdb052b155612b898b5a69f14bf394bd378cbe1a87fb2704a39821b23e2fb2a7f1f17b3f6c8530eb45d2d270438352d9f8af7f63e95f98d05099e6a36e0c8ea45a5b1c"),
	})
}

func (s *drbgSuite) TestHash30_SHA224_8(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ecca6005a5f965238a48a0ea2d18c3623f07af97adc0e48c"),
		nonce:           decodeHexString(c, "2693e9da016b14e2530304ed"),
		personalization: decodeHexString(c, "cf50ca5152d134a6599a1806cffbf4567e340cad1b87bec3"),
		expected:        decodeHexString(c, "3f7860118fc63c701bb883ad136e4e29c0988fa5d223819f718f54ec4f4777d8b114de6eacf0ebac1b68dec8b0ca66e0a316197508c2c3977473628335e201e8a28e9d9221a5ae11cc26aefa34024225d250e8ad2d1eead2aae05b5fd222a7c6750d908bfbe9c4fda64ccfc6b72f99df"),
	})
}

func (s *drbgSuite) TestHash30_SHA224_9(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a173c93315fb6ef19c2e3968482c1e9fe282bfd9f6ec2f1c"),
		nonce:           decodeHexString(c, "0672a5a7f027dc327cbba66d"),
		personalization: decodeHexString(c, "c163923974d37cf0073720da4fb395fc3979edfd29dfe631"),
		expected:        decodeHexString(c, "7916596b3214113a3272de3b4f30105ae1157c1d4b7343422467dec2e0f8cd75d7afe7b5492a4295e9060be4c366532e3de87b88a1a5d509a3057d2115e2d5ead68970b54ebed07a330cf994a0899b5666ca3f18327c8933464d57e145a4505426be34a8f486bab0cea64eb8752984c4"),
	})
}

func (s *drbgSuite) TestHash30_SHA224_10(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "4d3578f68331d9f93e3b0aa2c3e2dafa808975635f3cc0a0"),
		nonce:           decodeHexString(c, "504c206fe630797bebc50739"),
		personalization: decodeHexString(c, "68354010ec6e00d140dc70175a49aa6f11da22a112eb552c"),
		expected:        decodeHexString(c, "a38afb8c951188b43a7e8b2e5439668fa316c427bd0072f34be412d3a422e45441d19bfe4a68aa6ab346480bd3c283d32da19609e332d1c12656f20efca50141c6c65d17583c06960450fda068d11536a3cb7d4957ae54e1f564ba798072b4579254a2e91e217000878be390acdf9cde"),
	})
}

func (s *drbgSuite) TestHash30_SHA224_11(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "8a5ea0aa66a0207bdbc6bad06491d5e6b9301758a6a776f4"),
		nonce:           decodeHexString(c, "8a038ddfd11361cb70717ca5"),
		personalization: decodeHexString(c, "5c27e921a3a1747c9a9163a41d32f96ae33012abaf46c893"),
		expected:        decodeHexString(c, "34d240b19c2eb1872a0e9b1dfb9e04f1b157b1a85c712bd74eeaeee252a62f8870f9c3529016ffe8b854567d402d77fdb81938dd0bb5f87069599e09882bb30d76df8f2e16c0c075098bfd9ebd5422703461ec986a7c7b9ff4cef52b84a437f5c50a71ce01a166b0ae8df0432950c462"),
	})
}

func (s *drbgSuite) TestHash30_SHA224_12(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b4b4575f39053a6de34b8670e564b0da6cf51bc92b918faa"),
		nonce:           decodeHexString(c, "1c5af0c009ba0eef40e13201"),
		personalization: decodeHexString(c, "88473e868b244d58965983ba2cb6b30519c46a287969a339"),
		expected:        decodeHexString(c, "88ebe1bd3ffbb585d9fb77a9c07eac151e90f1f53ba4a30a000cabff625c2775f2f2512560363f950bb77c7f4f55551c21eb769a360c358551203bcf96a57755e15b91e0bf1901338da338640f9c5a4c2f8e077d7daff35344244510da18b3d0c9e97ce264c3dc6823a213f843950fba"),
	})
}

func (s *drbgSuite) TestHash30_SHA224_13(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0a53165a0acfe31772a6f362d1f6c690963a9ac202581722"),
		nonce:           decodeHexString(c, "77656bf507e3a5a512e4627e"),
		personalization: decodeHexString(c, "f99cd75d3174aa3733e6824202e49b454b1fe86302543f57"),
		expected:        decodeHexString(c, "d97971a69784aeb3313e65ef2e33dac16bb86bdb10b79ad3d62f2f2f5fe2240901ce0673bb2df1bb2781c3f45e56d786a22ac774a44777809b59d0fbd5b420335e04bf4046ba90b5a3637e255b3dbb89204e4639739dade26a313e2778ef93e16e775cc003aae8653a77542633c37ff7"),
	})
}

func (s *drbgSuite) TestHash30_SHA224_14(c *C) {
	s.testHash30_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "411b71a143c57ac4afcad74acb1c61f671999a0c00a9c6c9"),
		nonce:           decodeHexString(c, "a16783ada78fa029ca3fe31b"),
		personalization: decodeHexString(c, "b20dae78f254b07fe3eeb7c793334f3f432930353fe7f221"),
		expected:        decodeHexString(c, "081803927779c7b2039681db542c965fe48dc3cfde712a361e77da9aaf9f21cf38e18b4e8e5ae5a365910ada327b05630abe87858163713fd8c2988975eca44ee3725370f1c68117e58c2164605524102f22f3ea55f21f7e8fccd9861c59973d71c0aaca574480be6ec8e1fb9a163680"),
	})
}

func (s *drbgSuite) testHash32_SHA256(c *C, data *testData) {
	s.testHash(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHash32_SHA256_0(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a65ad0f345db4e0effe875c3a2e71f42c7129d620ff5c119a9ef55f05185e0fb"),
		nonce:           decodeHexString(c, "8581f9317517276e06e9607ddbcbcc2e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d3e160c35b99f340b2628264d1751060e0045da383ff57a57d73a673d2b8d80daaf6a6c35a91bb4579d73fd0c8fed111b0391306828adfed528f018121b3febdc343e797b87dbb63db1333ded9d1ece177cfa6b71fe8ab1da46624ed6415e51ccde2c7ca86e283990eeaeb91120415528b2295910281b02dd431f4c9f70427df"),
	})
}

func (s *drbgSuite) TestHash32_SHA256_1(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "72da39d053c6e052bde22d10ace144cc74a65fa22610140168c6e01a5a987918"),
		nonce:           decodeHexString(c, "c015f7a717b530cd6b3db49fdf62c494"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2daae5267ee22d8488ec158086bca87f1abffa5fe76dc532516e0f93dea5ad30f6d179e977e2bba496868e535c0489227af41ae73d61909b2dba2d94f80530dd87a9292080f6bef224d1292d70a5d35c5b5b94f7bf7c0f70f4cf1475c27de210c5173875f7bbe59f9adf07a721a914afe3ad1c8729947d514d2bb33f6c298b4c"),
	})
}

func (s *drbgSuite) TestHash32_SHA256_2(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "9d98394dc924928124f67d496aff2744a2443512d21cd9b1e4741c0bae0fbaa9"),
		nonce:           decodeHexString(c, "9cd0880276376b7e1bc904605daf79a6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2067124679ffc89649ca204db906b8f3b570e809162e3fbfc84917f60655a907e79f6e01a57c968f366c30d741a6bee959ff7617c43d29a64c159431e23958a54b5aec1f39beb42ba717bc370588ef422d04649e56c2d076b18f3625a9ac3eeaab437942e77839baee63618dfa3fa09c3a2fa12a2a3c3fa4d355050b0015db01"),
	})
}

func (s *drbgSuite) TestHash32_SHA256_3(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "123093771f61bfbf02672d2e51669095eac503f28260650acd956d66489cc2cf"),
		nonce:           decodeHexString(c, "6be500bed696f47639b637182f35fcdb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0d2880b8ea355466c4f2aae750203e497e8cc43c949e1fe53c51943b9e712e0e6c33c85edd3421e09d7d2d15a464f94127208fbfb4c36d986aacffffb6ee95533fcbe251a822bb2870dbcb3032acde54f7b1af63bf352a84f5b1655b756b56ec7f470b23f04224456c51db772c4d21b50bc8e6133f22c00644d840e34316210d"),
	})
}

func (s *drbgSuite) TestHash32_SHA256_4(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8dba318b8188294b3c67d7a623e8cebf89b4b9a2e87cd318869d074502abaae2"),
		nonce:           decodeHexString(c, "3bf3fbd4a3f814e4d63b670fb2770ede"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3be2b8659f989e0c2ba62d019406c893a6f69135dafeb28684b6062ba16a245e8979808f4b42d3839d6f4b1e7b8c3aa2601fa2ac5c97bfb54b7abe172b4104a449c0f10525599d1d119d36993b1cac64a8807478477d492d614096d360a024063295fb05d4d686c95eb1debd7af9e5cdaf3960ee6a673c1e211cb3b7403b3f7a"),
	})
}

func (s *drbgSuite) TestHash32_SHA256_5(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e003fe0ce5a6943e0b195bb7824ba31ba95ff93089a502367a0ebab5c819c93d"),
		nonce:           decodeHexString(c, "0941087af48ff89f0b5fcaf3b3585c12"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "85b83ab2a160aa214ecd024052352ca433b444788a968f83555c8c2d4bd9f4482d34d29fb544a00a764d21fb384e36e3799d94932bbfd2b7f0e34638febc7c649e8830f773689a0cc360629db21e604700689d5b9c4b5acb2f460a1e588a38203a5d412fd17c5b561ad843fd28f7dc17a3b3d8c18872cb790803d06374cb27a8"),
	})
}

func (s *drbgSuite) TestHash32_SHA256_6(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "590cdd82ed0ff23e5b84861734ee42c53882e10b030c05057202f2c43fa9ec71"),
		nonce:           decodeHexString(c, "95dc6706b352dd1c7bde6fa11d6a9aca"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c664fa13b6274143ddf17368995d0b213cbda25fea4ba4373166d294d51541b8b1a1c6391480fa7f2a37e3a0f28d182ac5f2f1e8f956f776dbb7ba72a1913fa995daca4e4ce2031c1b4c64d3676b108d0c82772ab574a53d35c2a7fc2649836ab06f883aa5c044e1018cc348b45db431489f4fc16ff3bcd3c7374d24d2100f60"),
	})
}

func (s *drbgSuite) TestHash32_SHA256_7(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a7166b37034444c20af70f98d18b570c289d6a6869aefddd2f2377b0c5c4e5f1"),
		nonce:           decodeHexString(c, "d7b8d8758add3d0013ca46f9c992a15b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0ec5a634f1878d5dddcd5cef2d6318d25b289b91b8c80cceeaeb63c27e2c3e3a0f41e21e213fb87f0ed7cb70651f5e4a9ec5ce2743bc828a25f1de8adf5d2bedbe9e02c17dc0070bf4e603bdea8cda856d64ba0b4b4e72c8c7618a3b154e759cd19b048cbb44280a67cbc985739bd325f8a349b72b5803adffe968b88b294705"),
	})
}

func (s *drbgSuite) TestHash32_SHA256_8(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b37f0d04e8fdb956114f529ed685d810b0d8a71f3fcaabbfc798dd9e63f91c11"),
		nonce:           decodeHexString(c, "dde1f4938d25f6a9308934f0eabed3d3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ca2e784e37d1d468f1699bd8fffc44907f2369bcef5b17f256e4d01054e231142bec9582d15c40d858bc912196bbbf844033893aad7c84905e172d5736949cc53199beb42eba5c990e8e0b76cc4558e755ee5abaf40fcfdc6c01a43a59ae7fffbb7e54100d9734b8db7f575ff0d919c92d8eacff73d9f5136fa86d1c9f0e04c7"),
	})
}

func (s *drbgSuite) TestHash32_SHA256_9(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "55943fa5274526031f20a0b34822a5c74702ba93c87cf21ad6ec17b99236abb0"),
		nonce:           decodeHexString(c, "95a37931988963066826e5d91c006497"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "575d788ca6f6388514e17c1b859d98a97b00d3d71f7ef8e620e621e2f7de4f5dd84a9bc72df70f7e65c50b49c3554d6d6288c776e51eddec155573861f87c961c6b3a78247f78db02413f17902c20b8e510834816873bfb225b667ecfb0fc947e28f66080c6f88faa289abfe821e6ae4de6d7bc4a1c36e187ecdf550ad41b9d0"),
	})
}

func (s *drbgSuite) TestHash32_SHA256_10(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "34c06a3af1031f2c6b15baeb68ebd42162571d867713b5f572afe92226229d4e"),
		nonce:           decodeHexString(c, "c92092af647d3117533f0e894a3914e2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "76a85071777d64c95de7f5b6da5d98678b07988ba91e561aa47fa08535ba4dc25d22fac26dc844660a125a6913ec648676d6da0f4d9af6385b0fde771dea9f6491568356bb176f02452f2a330174ba3c9baa8949678ca94aa1fcd4d3bc7037fd0cc7872c407c2bb79a57991c328145b9a6382fe062b1f95b21eb76467529b251"),
	})
}

func (s *drbgSuite) TestHash32_SHA256_11(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b8b93e7f1ba7d16778c2f0534f085aed65af14704f810255c52a2c2f73e286dc"),
		nonce:           decodeHexString(c, "692ab38ad1ec0732ebf1531f127f1bf0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2c3c63ecddd73ddbf468a98a16f9d1ff2c9ff51598923406b040602d874ececfae4cb412a11df96a75015171f93517c0571aa595a6b64c504626c5298c70e929ada8b3be41de2534808df4f5338595b09ca6d81da66cf7a1568faee77f7f23f5e481e0ada60422530c028332765c295a07fce0107c77a5b4aa4b34801834d178"),
	})
}

func (s *drbgSuite) TestHash32_SHA256_12(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "13a63ca5e762aaf2a821853b87bc608e0acd52bb8167a0cd5fdfa2156c941eef"),
		nonce:           decodeHexString(c, "73d2167bcf6f89e1a548ad80afb13de3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bb68646451a871898c67a312f12f6217d6047551414dab2c64dd786d308d2cfdca2082f2d4d497e7a890da3c04a5613e9efacf01417ca01f303d3419871a97e3d7cf67b53391da651b2ddb5df2ec6448b8dce0ca3e5fe78fdf7d5955b6b205dafcbb74365e3493ae2b709c4638243f1d77f5397fe7ac78baaf337b23b5faa851"),
	})
}

func (s *drbgSuite) TestHash32_SHA256_13(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "af58361acbbd1e254ce98f463d1a47f64998e4264780ea84d03ee67fba6d0a62"),
		nonce:           decodeHexString(c, "1ffe801e5c71a15d4b80375c066ec61b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "02a06a8cbdfc215476d526c91a6f2bff994e6d7d40c0fc73b3fb2723fc8c6c9e669af37df33ad62827ee9da452c9c7f46d24caa1f1ca99333e26ecb6470db9522c6fe319bdb1d34ed52037e4b5b2021d8f63f388b954c7f0342394196522bdef3251ffda5efa9f4f84dfbd3dad94ebf84e7fb988e6cb631de9ab73818e6fde3b"),
	})
}

func (s *drbgSuite) TestHash32_SHA256_14(c *C) {
	s.testHash32_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "1194beb668839c47c73e7516f9ba09d23dec3553b3b5532f75b260106dcc2abf"),
		nonce:           decodeHexString(c, "3c8a77351e93065d584feeb08c8424a9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "fabd48bfcdd07968239fe538c2d8c9bde2e257b9b244078f39287c7ee90de167fff56a693c4e64f45081635511b5fd031c0270a31b4a014e44c0516a55ae72345aa11dffcda4ccf8cda50f6948d5ae425d8d53ad5c74cef1364277990156796e1c5dfa1ef095c0d8983477eb24241135760b02c86c86d4ec3627edac8c1a7e32"),
	})
}

func (s *drbgSuite) testHash34_SHA256(c *C, data *testData) {
	s.testHash(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHash34_SHA256_0(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "dfeabab904bfe93a37bb5b1ea4a696f881ab5ab4be87ffbf2d4e8cdfaabb37fd"),
		nonce:           decodeHexString(c, "a2d458b475053a0346b57fc518849ba1"),
		personalization: decodeHexString(c, "d15d5d9a4a3a41877b4ea98dbda5079ee393f6ab24105dbd70f5bf145772b15c"),
		expected:        decodeHexString(c, "86d8c63ed4a8a19f3429b4dd57ede5ca573e861712e631400645ceee763c37cf950bdcc4d9c886ead3f0f1bf46a63bf22bd2eb39b2dac61d2e8c8f29e26045b3db56b2265adc8152d4f736c09ee90364a1e265eb5e77b0c5988c8fa52717fd33b6da760e78f2a7c27065227c47ac2134b95b7dadbf96e4ea2dad78ef200e174b"),
	})
}

func (s *drbgSuite) TestHash34_SHA256_1(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "2a85a98bd0da83d6adab9fbb543115951c4d499f6a15f6e415508806290ded8d"),
		nonce:           decodeHexString(c, "b96f96e1839ff788da84bf4428d91daa"),
		personalization: decodeHexString(c, "a880ec98309815d2c6c468f13a1cbfce6a4014eb369953da576bcea41c663dbc"),
		expected:        decodeHexString(c, "2d55dec9ed0547073d04fc280f92f04dd80032470a1b1c4befd997a11767da266cfe76466fbc6d824e838a98666c01b6e664e008106fd35d90e70d72a6a7e3bb9811125623c26dd1c8a87a39f334e3b8f86600777dcf3c3efac90fafe024fae984f96a01f635db5cab2aef4eacab55b89bef9868af51d816a55eaef91ed2dbe6"),
	})
}

func (s *drbgSuite) TestHash34_SHA256_2(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c58e3fda017dc0757c452873657d6fae6b2af071e8bb2c0e7b55df8a9ec3dd29"),
		nonce:           decodeHexString(c, "ba0686d6f607c6d2dda190cd01fe0b9f"),
		personalization: decodeHexString(c, "c072a6bb045d682c498b88030f9a7fffae8912ee89c8fc3c2dd672df18e03452"),
		expected:        decodeHexString(c, "c6ababbe424a7a6a3f3a07a6cd566fe44280a1a15b2c8a5507ab0d9516b03ca7be90158531ca6c8ff4d6ca9589b8f62754e542a47f815fe869a255792b4bb6bacb1c50a06af035b61aca966cedf45f6b7982f4382532acf62defd68db41d507b6bc261efd9c00cd0991bdf589e1de807282468ff53288e33e48725830f4f0245"),
	})
}

func (s *drbgSuite) TestHash34_SHA256_3(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0cc162cd3088cf13d44691eb9cda01458fb16c34d3c320d04210dc29cf1b55de"),
		nonce:           decodeHexString(c, "df875475252ad6d66afaa66748d776df"),
		personalization: decodeHexString(c, "326849e67e7439fd905a66f4fec74ebdd309a0a050a2a6d3d98f015a4aa876fa"),
		expected:        decodeHexString(c, "f52678b368fcab4ec1126a2c3d931ba8a1f4e90890ea6be5c3acea5234d6a71c4daa96d563a9be5044562821cf31dc962435aa8c0fb3c514590e7e293ff98a5bf9df0ec5f73bf36381e0e5df5fc842de44c7b5921023404280bc223aece659138917bcd9689bd3f2fb82cf47b1db49e91b5eaa0f10491aeab3ceac78f4a2f598"),
	})
}

func (s *drbgSuite) TestHash34_SHA256_4(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "bfc6258061ff1e94930600f5ef0dd56d6565b61b99add62ffcf87bcdbdd68691"),
		nonce:           decodeHexString(c, "80b249023eb6c58d62c509ac8332964f"),
		personalization: decodeHexString(c, "bc6d7c7af785c30082de5f83c999a3e418c46140ad180b6a8146bb8787a7b729"),
		expected:        decodeHexString(c, "d39a223384d05574896716912a33d2e113fd737786e6f25f44dbbe2df0903bccf141aebe3eba4b326f10665c57c630bcbcdc1362b9a0f244ee788199dc6d9ff99eca9f8b7ef76c4655851ccc6d652ea46ed2c3148f9cbe9ac534d888ef648580ee97a5b09ef5c86fb1cb99a4734b8dce19d225efb078826bebcc5a1712fd7519"),
	})
}

func (s *drbgSuite) TestHash34_SHA256_5(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "31a463f2ac5e9a3a69c1c2a29bd15ebc089dc364db3596a0db6d6c6f7a599055"),
		nonce:           decodeHexString(c, "342776716c675bd0473cd104ab978cdf"),
		personalization: decodeHexString(c, "fd8d04c7f277caac8d96be3f9563333fb462997471f4e2ec16932d05439e92eb"),
		expected:        decodeHexString(c, "b5e5a7cebd1cc522b4d00c0aa7a1c6b4d13314e208f1eee85c7e1750f145181019c2f86d7b4ce995a14bdff40571edf6ede51c4bcfa88b6a717b5bdf7138c83ccb2aeaa8bf5375c483e04ea65c8340e347e63902ac986f6837b50d5afeb6f5ded5938ceb663259b66b6ae041dde1093b1282f834c1fc6e35a318832898fb8648"),
	})
}

func (s *drbgSuite) TestHash34_SHA256_6(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "745b09d574d1c6369eb41e4c86f281895c3e6a035c35b31b0bce032010758f9d"),
		nonce:           decodeHexString(c, "36b69a1b6633b08495a4105872d64dd2"),
		personalization: decodeHexString(c, "94129bf095d49565414f83c1cc06e0109fa416511756d9096a95da27e00c8d68"),
		expected:        decodeHexString(c, "e273d0698423cb0064c7d19d3298feb9a15e7684c7e8b80f0bfb88459a02dd58ef2ee8f8bb0694cbc404c459ba22d10c855ba6a5f2377a4c6fc125dee75e8da4ecd291c1716c694191964060a9f7c0699a681bfd423858d67fdf49da3a44011cb92ac61a68db3718cc5eba2cd25ec5436201b4d6a0949d86ed94c985aaedba18"),
	})
}

func (s *drbgSuite) TestHash34_SHA256_7(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "1a13e1268eb80323e04ec0a32c8ed99ae4e2f18f2eecf29149115839f2c369e0"),
		nonce:           decodeHexString(c, "ebcb8216494217a7d32b43f9b866c13f"),
		personalization: decodeHexString(c, "e1380276e67134a1b2100a2239512095f2866795566dea7418d2ff95ca35477b"),
		expected:        decodeHexString(c, "f2bb0cfcdc7af7dc06ef410677a84b61d8774a8c2575126302751a9207ae21a5c7d76eceb6b81a438bf4247541476c0f2405e2eef136eb970eed83ba0361c2446717449b9598f5a78dd82c444594e82c13f49f34d340d2e67253c199049e1c44ccc1cbdb76f2a458e9987a8bb033bf69642865dcaa39c384930942c911eb1e13"),
	})
}

func (s *drbgSuite) TestHash34_SHA256_8(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c1efb4a10bda29d83e46ff69b5e59de6174c34334300c7038656242fe3f6ce90"),
		nonce:           decodeHexString(c, "0baf6e6e5f7279278634a18824c4a7df"),
		personalization: decodeHexString(c, "7c234f15165216df8b7b5dad39cb860366832243bbbfe5d7d501ce9966f4fc6e"),
		expected:        decodeHexString(c, "0dfc48f2a0e0f9fe8bd2066cf32cfb1b62658909d940e1a16c492eddeecc9bac2e210328203741356434c553dfe84522f97cdb351c4d67d990a74654b223c2ccfbce95253223066b6f7561bb6a348a4050329c0c2aa601bfb8398a9578b87d686884feaa7cc4a01dbb646f788d8b071ad00440606182cb3ae65180ccb0cce4c4"),
	})
}

func (s *drbgSuite) TestHash34_SHA256_9(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "59002231818991eb8b51e07e402e29b2c5c14d29ed37d315513ad9b61b53dea8"),
		nonce:           decodeHexString(c, "ffeea2ee73f3aa4791c74b4148772855"),
		personalization: decodeHexString(c, "71344e7b94d373d5fee3e28f7a3f98770b85e81ab9090b7c35077efc3bb2e744"),
		expected:        decodeHexString(c, "25ee5dafe8da2302ceb60c80e9c47bde1a45be8d4b190f24a5b0c9cece4041086e4c36e721d7c65f0cad043a0877e7de748336b2b68e833decd0279702aa45efa0b904efff95878055cbb583e21e55a1645b4936bfb5d6ef7508284e7e2ba99c87c70f1ba6094258e32b7c87f32c93210c6ab2b6874473cf7adcd34d94cdf8d9"),
	})
}

func (s *drbgSuite) TestHash34_SHA256_10(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c018badb3ddf970d34d4f229c73c5053f6e74672afdd9066e0cbd7bc3307e1c9"),
		nonce:           decodeHexString(c, "56833cf4f4fcd47999dbec236a4d1382"),
		personalization: decodeHexString(c, "fb553107a28b004be536e1e15911a383c20118d3986b25686190000c894280cb"),
		expected:        decodeHexString(c, "cc168e495fe82793e3fe9b4ef497f09bd04bc50519598c07c7db0450482fa32d0ffae15f76777d6c047182acebe89f79f86a9e1a90a1a8c372ed8bac7adf9b03277204abceb5f8b487c437b79664628028c169f367e3508ab212ba7215105c3e01063a3a0d0db7781331e6012b5b465a417b05ebb4f548da70f83797e3753739"),
	})
}

func (s *drbgSuite) TestHash34_SHA256_11(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f8fd7b39f1be4c6c7494bfa8b0087c90ef11f2302d36d3464a63401c0c8b5c83"),
		nonce:           decodeHexString(c, "22dc2792fcbc2a7c40ccc655cbe0fa8d"),
		personalization: decodeHexString(c, "8fccc783a77a175c1225ff4ef6e0c2733cea2bd61856e000980ef9d895ef877f"),
		expected:        decodeHexString(c, "7524774e098c3dfce4da6d839ad696fce268c24525f1439517633e82d52aae315373e36797e1e3b36adc67425e9aaf7cceb1b19e13484131cd0aff9335cf48d3068d205952fe231d6dbf74c7d97077453f7ab1447f24ce4ee2f61975c17bf671ecffbe2dea4505fec87021c5f56840271b87b90caf590c95983a8440de42d54d"),
	})
}

func (s *drbgSuite) TestHash34_SHA256_12(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "dde38ed265be4426d7fa447ee70b7c811bfd0e74a2618b60e36de8dea5aa4af6"),
		nonce:           decodeHexString(c, "f8dba4c31093d140acf8ca561de80e90"),
		personalization: decodeHexString(c, "971af30ffeabc6cc3330cf52108b4a6d278af52dd4bdcbfbd99494f12dc6c9aa"),
		expected:        decodeHexString(c, "42d3dcd59e4a09f0781b28268031ffddacd6de651a988949854bb0958d74a91f2ab07a3b4f29eec666b516f7ac8867ba2aa915c08a27af59875a5a6673559eca0bd40688bc9ef1731e36150de1c242cdca4d734357768b2377768a8a73a627f1c7422bc985c25a763205d65ff7c3afd9e51064ce9cfb25ef37aaf902b86e96b7"),
	})
}

func (s *drbgSuite) TestHash34_SHA256_13(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "39edf813bd7a141659a5962720c0ea8d91edb00f54f05b433252a076acf1b5dc"),
		nonce:           decodeHexString(c, "d74cba7ba9f7991c7f0c5aecc4788d49"),
		personalization: decodeHexString(c, "9b546dcfe080170378bc1e833674925d0da0be2e81656d11935f29edcdde9bee"),
		expected:        decodeHexString(c, "ad933ba15f8b440c0c08303389a3a11f3abed7dbff640f95e4c09fdb9dedb05606cba2e4ff419c0f38471307469be4814e341f74092cf7b314bc26177a97f1806d5e69570d7a789e8310f9b1775bec2562fbc2aacbe7d9ebaf8ba4e953998cbd9ebb9902ed98dd05381f44d9b08587be13c32b5dd23a6717102e3de450b82c99"),
	})
}

func (s *drbgSuite) TestHash34_SHA256_14(c *C) {
	s.testHash34_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "17176a26d4364c55020dcdf2f82d792caa013d63e6ea4610ac123ce2fbe4c6ba"),
		nonce:           decodeHexString(c, "de2186bafa82b0d08a0b8215e3424512"),
		personalization: decodeHexString(c, "d96db27febe22db935b117dc3068374e39c5b2119b497e3c1d858ef649e01de5"),
		expected:        decodeHexString(c, "d04435a8aab397cfcee5151f7aa24298ffc6eee4f577cda42d5e154b8d28cb2f0f945f11a15ed5b76486c88f03081cfd262d94a8e0b332e3c9c608461dcc8eba20d7db209810d25c226fda9fe218022a9b2c96876cb16c06c0553dd84ce57e20338c3d3e03c59ce22e668e25c2c50d5cc9afab91f50a28680964c2dacb9d2fb3"),
	})
}

func (s *drbgSuite) testHash36_SHA256(c *C, data *testData) {
	s.testHash(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHash36_SHA256_0(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8bb315fb43de660049bfe98905376379a133e2936061a58538d7a3e9f9727fc5"),
		nonce:           decodeHexString(c, "1fef1c133df5640b0248b246ed9ddf49"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "705e1e0dda60268015dcead1a889728ec6d079582eec9acf79e6fad850c8965cd264d3061756d196236053ff561972e231681cf89e96a4e1f6b074f5c6f0cb2742d9b5d9db3c60657db17e15b86eae41626bfb62e0d58fdafbbb3e6563407eec8f5d166d15dce3eb0386444f16ef72678d549d3c96c33b0ee89802e50e3b93a1"),
	})
}

func (s *drbgSuite) TestHash36_SHA256_1(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3909ccca9c088242777e7360deb0ffd08305edd8f2cc975a5766b1cca4edd23b"),
		nonce:           decodeHexString(c, "ff6de7667baee1fe86b57b0197257b7b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9310fce4493058822a5502fb3f6d62568cd003f485a95d07f02cdff93750265771c0d58abf73ce024c5f8dca7e8f37818d51c6c369d03e67850c4904c5788d7923978a47a4d395d76809924b8366d50eddc740159949269f1107d3295043a0f25ac0064bec05cd868b5cab3fa55cd1f3bddc37048d4a30b05ce598dd1f9f2c58"),
	})
}

func (s *drbgSuite) TestHash36_SHA256_2(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "ff4f40e7427160c8ff9f802ac43053be76bfe72ea3f918cb1ea160956c5ff42e"),
		nonce:           decodeHexString(c, "18eb15e50b958a52fe4fcd40f259586a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "57942a072f37854c09e1cb83969397c896f716a3b593c24460fdd3677e06db3d6a6e08fb38b0e9eb7f7ec3cedf29d5ed91e261c9f7f41481eef75f1b005585909ed03e5f05a8af32de5a2378c32088df022d1cb3eff1ed0bd8b9572995760456f9ec1fc21e1690948e5fa9c6d6b95072ae8c8436a781e062856748da6fab714c"),
	})
}

func (s *drbgSuite) TestHash36_SHA256_3(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3c9c77a0983bf33660e14dc595a39a589cf9ee93330dbacc7f9b090e62e09099"),
		nonce:           decodeHexString(c, "f52b0b2a38a6c4af309b604dbd08d822"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "24b811821fb55cf52f18dc812453e2379842e3674b59313b3cf1c9a397e79e0bfedc60db6d2ee97c83fb3370e6c6d399106f9897b542cddd06a9071aa2746c1442b6ec7762a7110c8c2ac7d3d94a1744a685c06826e2828705e139f78e6d23c3f7508f2ba98e2f47d47ab2e3b0d85a8a4d614899178643ecd0c669ffb39ceaf7"),
	})
}

func (s *drbgSuite) TestHash36_SHA256_4(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "773d008ee1a1b0917fc3da03c76f6e52e74748d7869a22508e3b4cf50c0015c2"),
		nonce:           decodeHexString(c, "1502e2fc204e59de9ff39933c429d154"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f0ddc5760e73b7fd5bc560678b006711f25af13d7d05c1f2c7e1ca462b3418158582176b848b88781a583bc7ebde955bec90d9f3585f6e7e139b4c8a7113099be4ca75f51d4479e62f34a3eff1ccace97e7b3522b7956505c5e79ea18405aa1a129f5b5650cd6d9cc1604e854a6af770df3f984e47965119299173fa39f6163a"),
	})
}

func (s *drbgSuite) TestHash36_SHA256_5(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "193da0a769483b58b66f059072fc8885d62635825c42216c034a8febf65001f1"),
		nonce:           decodeHexString(c, "f597da9635ca4f395fb99477b5447cdc"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "52c2a48f73a509cf78e1fe5f2eab809140c5ebcd24a356e8a6d8756c8f169d817bf1e3344e2d79ca75843263455cd861a83866b64b1ecb2caa96b775bfc8102058dbe1986d1c1a96df3873da9a64b82515ba05751b32f08f19250ea9bc96d81e8d0ea0a6f2d36ea571724f1a7d30aa0fcb098e2b79b4556f7b68553ee6b6d282"),
	})
}

func (s *drbgSuite) TestHash36_SHA256_6(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8b0ab289c5d2e286f8ae42ef04a4198bb10c11031f9d3ce49e3ebbcd80dc0e7b"),
		nonce:           decodeHexString(c, "67dccac1f5e4e921c9fdf450f9cdd665"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0f7fe7d5d75796201ab88997fe48de8d1e7f617c68b00f3f121d5ed76052818da98f34d3d0c91bfc317e7226619692d222b88757f5520da601d50729d1467ce6f74690bcc0efb48f3bb904ab4b6f5d8268370b614a7d60ce58897f0bce02210afbb57e5699c783a8725c1974ca165e70c46d6e56cdf2d1f3acaed83768ed9c39"),
	})
}

func (s *drbgSuite) TestHash36_SHA256_7(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "870dc6dda31e7b6b6d8c42e4662d01a9b66db626a5fc00cc16d4b70e7dfcaee2"),
		nonce:           decodeHexString(c, "9e18a3c040e3f380f3f150b383721b03"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bdd6083abb14ae806c4dfb3c415d0e65b081281339708fa35bc08bd7788b39683ecc597bef877823fc32afc868dcc3ea72576de3cfacf5681ca450aa8ffe32f3dd5f16136c76ed05918b3588de8465ecfdb316c5bc3271a9868653f906b976c9558c2cea41d5fc06eae8ea11cd5d5129658a047852d4d4bd6a29b7d03a1d9a30"),
	})
}

func (s *drbgSuite) TestHash36_SHA256_8(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "6314cbed7f60bcc38ba5c68ed66a6e540acc489c64a757e8ffec995a412f66e5"),
		nonce:           decodeHexString(c, "ed635d56e7a0e6ec4ef471c0809676cf"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b009bb2c49f06a1fa12554e5dc8d27557658512b70f3a4774594dc71b3c6fefe9c4000c9a4d604cfd1bfe54446dcf59f416382568ca7e50b0e4c1a6942ad4fbc852c363f6c8f47e19e23edf6eda5fa2e9bf33f1df10d2549cc27dffdf93acf638662bdbcbe9d3586df89c22f91d63db4a216b28fa5218edbdc8f1301421901fe"),
	})
}

func (s *drbgSuite) TestHash36_SHA256_9(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3a7bb4e4ca42c61b49d4f4bf5fd2309f68864f663090c47ae014c38930c9dd1f"),
		nonce:           decodeHexString(c, "368e34c93980503730aa8fa8bcbc342e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ffea14c68a3121760c7c978d2e9b7f7dd2432ebc78b8e82a8e542893f4be5f9069a30eb425d51798578ee8ffe41003039fd09b58d3669c1a0cb18ba6a7f939fd62007da8401dfbb46941965ab79ba93e0feef9de42bb658aa9b1f4c2a758ebe8da978fc35f905d4f9688ed6a03c70b1fb6d76a054aa5f56572e34104e676cb1d"),
	})
}

func (s *drbgSuite) TestHash36_SHA256_10(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4230265fef6d8cb9ed4472e8f1a1a58bb7af6d9348a728686244c362c48f60a6"),
		nonce:           decodeHexString(c, "d709d06ae6a992c14b18353cb5ecfc45"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4982902068289b598cfb64efa3f5f3f1edd06cb14c4d636c633af56b16f8fd1c4a285517c7d6b4e9a894ce9013a8c8f92fb951a335dd464200f0734968d286c8e111ae946067a7d840b98fc99ae17cd314bad538079898e55ec7d77a6d53c99b313745d16b7f60ba36eadde1c1bec39359e275d18a345d9562751991e28d34e0"),
	})
}

func (s *drbgSuite) TestHash36_SHA256_11(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "1b1b02ab5ebe5500732893112e792c4633e61c5e20d8f437394b8e82c35e0ce5"),
		nonce:           decodeHexString(c, "cc7579c3164a92f56ad93bd6091e644b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "392ea89da64cb6effde107c6ad12be67189979a145d03bca6ad7dd23b8dc48837ba3719a297141839295e3d41bf6d5eeb54da403e1451d402497649a9a98d66b5fbc0e7e38d9304b5e1ccc1204e465ab0634e1f4a5b3a6b11794df8e96c4c260acee65379e73644845c150679fa178ff8fe5557562ee2a94cd0fbf965cdd0995"),
	})
}

func (s *drbgSuite) TestHash36_SHA256_12(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "eceea48f2056736e94b43bff65c091b119d9c2b34a78e8bf4f3de9a44cd6bdaa"),
		nonce:           decodeHexString(c, "554ae80ed94a3294851b89fc20e73ba9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "490b1f1e861d4eb98c282edcc6bcc7b0eeaa8892c6c44ecee0dd3fb5bc0ce0e4b8b24a927e256f8fa092720009c90ff2d2b684eaada7316d0b4ef83cdb8e22a3725796a2b4f557e9db98c2f0b29e30315241dd68d3fe889358c427c510871c797cc263f18b1b931c03a2af2ad315603d2c53b3d62ce0e1e1b4bcd6cea2655a10"),
	})
}

func (s *drbgSuite) TestHash36_SHA256_13(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e610dafc442915f0c59bc9b5f6a05e297b67d6ae410cff56c4a39a8f2517299c"),
		nonce:           decodeHexString(c, "44a14f823bfdfab85bcc4a941cf9a4ec"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "65b3fbb62ff2ccf8a65ed9881e07f1d2d0c734aca7f203ee301bfccc4c4669ef4bf2b8491289457ea618196c2465a2310baf410835f94979dbbb93a42040f36ed162777664b475d6df38b00be98110002d74614322586a69112bfbbf52f31aaa417e5e729052db13e3328d97ab1bf2fca3bcfef581c55692fa17e0090d7e1a07"),
	})
}

func (s *drbgSuite) TestHash36_SHA256_14(c *C) {
	s.testHash36_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a7a1dbf7f828555610197e71e0ad563b8691589c5289ced03e9ef83b6f9ff938"),
		nonce:           decodeHexString(c, "4274788c5d80e26ec1ac3a57b9c7c0df"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5a907a26c1ef588219d4c69fcf4c5c283ab148a77588a40b323bd24e6dfb29551c4b6116c4d61349f5f8bd9ed497f38b239c37283902beb3c9700c768fa289ee4573f92316efb860a5ca4267b328f03c13138b774b4b9f7516003a699f7a0854a0efb045a5932753a771c2cc6119202b33336f10edb715bcce1d20ff503dda01"),
	})
}

func (s *drbgSuite) testHash38_SHA256(c *C, data *testData) {
	s.testHash(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHash38_SHA256_0(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a4857cf33fd496f9e7171d3ad64b6a35c5ae44af7b87912bc1fd540722796137"),
		nonce:           decodeHexString(c, "1a9c73962f2f3f2d4790a58eaa3d9096"),
		personalization: decodeHexString(c, "5e3677e8e9a43ac8181622b42e91c448280896f55cef2a9734e5e5527bc530ae"),
		expected:        decodeHexString(c, "fa82f560fb8bb4ba24ec563fb03be58792bf3a11c9c60c025fad0aa4dfa68fbf318ab0b6594be18b07bce52d227f50a44a650ac4df479b969d5b46ae60a66421dbf3ebfef0737c71b5d76b7b616bb9764b2edbd87ef52a5185fcda3c6a6dbc4270bd61c1bd50e606556343017001a3dde98a265f36ac3d124cb18a5dcfb37940"),
	})
}

func (s *drbgSuite) TestHash38_SHA256_1(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "983d05878c13076379d2d4a0b5712256a7ee1c9fc9865d0023fbaac065077929"),
		nonce:           decodeHexString(c, "68379638e3ad024573e711065178ca7c"),
		personalization: decodeHexString(c, "b4c34d7bb19f2b4e7d1a3c33f3f036ec27a874f0d24fe4f2c33dbd3a85d5596f"),
		expected:        decodeHexString(c, "5e258d2f9270c6daa80434c98cd1f05dc26330b8dfa6d53d490bad58a96ada5b8098bdae39f4d97fce8f561a242358b832df3d2a352fc5ede95f6d041bb2f8ecc00d62bd358d3df2d8fa6e2841ed515b96c013d3fb321aba54c497c29422cb54bcbc09bb8906a03d63bfb9784c0fd04072d895c019c1d69ea5346d754601d069"),
	})
}

func (s *drbgSuite) TestHash38_SHA256_2(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "43dc8c77c621519733c71184fdbe44c7ebd4bce8786c8f4cea5844c29610231f"),
		nonce:           decodeHexString(c, "c606c535e068a6a79eb87e25c6efe068"),
		personalization: decodeHexString(c, "bb15d65d180c4b5de14457bd6454b31c8a15047460b153976eaf65104c9b1e04"),
		expected:        decodeHexString(c, "bd4a55395f1f8ad37a7a7f3476b5ddb569ad42ed57d678f1e8af97905e4d151d3511d2db6b8bcf313bb58675768f472ae96171a0c362c4b2e8548cb3b4c9129721e2c3e0ec8d576935f150fd8c79eeea7d6cb25b54c86a975546edb32df6198b2d47138943f0379391ce8b5c7a20faf0d268f21652d25187afc04763156feaf4"),
	})
}

func (s *drbgSuite) TestHash38_SHA256_3(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "56754c7b7825c717212481de3dbe1f11c71332eb01f395ed8d2dfc681ac95181"),
		nonce:           decodeHexString(c, "102bb5e8ecfb2cbabd0ccde543763853"),
		personalization: decodeHexString(c, "0cbed991d2abb392cfdb311ea5ec9c9d01a48839e5b216e58c3a67b749220982"),
		expected:        decodeHexString(c, "b4e382281c2f937287e622f27ed8de73cb67d99227265c191ab488573ebdd779e8466e9cbf26be26fc838c3398ca8fed126f755398b93303dbaee84ddb6746ef1cc1d8c75a38ee2e43927d9e295ab3dbf070528d17642b4c9fa439a814b41d122591156715cd0fe54e9bbfe03ef3974965415976f20a345f456e14dae8848b84"),
	})
}

func (s *drbgSuite) TestHash38_SHA256_4(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "bed1f25fc400357a1d25c2a54d65b9d128f3ea5c63cf46fa4b0328ec31a4a8ef"),
		nonce:           decodeHexString(c, "1462b598c9415f991e755d586929e325"),
		personalization: decodeHexString(c, "4f6b1ec3f487f7341088abec343c51aef8cfb60d8d46a0e9c68d187da02f14d1"),
		expected:        decodeHexString(c, "0f9162d9f5321552f080f9453203c3d589554c6232f04de0e3868a2adc2d288b4f4f03d118e9f7fdfc96271f77894eed97aaccb613da415206bf2ef4036ab882964095eb1e246e78890651659a5104753652deb54e822543e5c4c6bdd8164a49d5478436f1e74677d5112bdfd59dfabe21a8d973368f738c512aa66d0f87071a"),
	})
}

func (s *drbgSuite) TestHash38_SHA256_5(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "1dfbe58785ee77f0ef206a25466cb27834f314ddec65c1eafe19aee1bd86c623"),
		nonce:           decodeHexString(c, "ac5d723fa5faf45b114cbdfc42e2211f"),
		personalization: decodeHexString(c, "40e715a969293a45afb1eeeab4e8b11d5c043cf58a8a596e1fdb626d7f8fc008"),
		expected:        decodeHexString(c, "bd6bc74b7a0fd49fec46cb4fcd5940a77a1ec93705ce356ffdfa40225fc728f3cc8e3918dee65fd21dc94b6926407e7903a17856ef1bd761e6d089988ea5b0a449c09ee0de8fd4489dda793b96639bb35188029a79e8c8b337c0c40c59122c47313903068da8b77b21318b59bdb34310d7c16ec91cf46a69a567099d29afabe5"),
	})
}

func (s *drbgSuite) TestHash38_SHA256_6(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "7edbfcc031bb2f1b6915c4a7829959547410c2d9ae72bcd807905c7cf6ef3bad"),
		nonce:           decodeHexString(c, "ebde9ff05b417e6285b88eb4714ed97b"),
		personalization: decodeHexString(c, "3514eefe53e06b85cfc7c9e56ac4aad000000557420b79c5c17f54498244af86"),
		expected:        decodeHexString(c, "c8e418b8ade328deeda4e595662f4f18edab051f799df6d48641357035cf90147b2b63b452f6531649cc80b27da7d1b25a89979498232cb1695cd6e563c50cc9b7895e8bfbef2d6a098670d630c8b96d7e29e376e1723a617436a65cf9ed730448c251438025964a01dbf6221b9aaa1327add8f4544e6fa15f7f410def8861f3"),
	})
}

func (s *drbgSuite) TestHash38_SHA256_7(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "1909e66624d0581dcb233e385509d6be6ad3babef2383869df05b8d4ea6470e0"),
		nonce:           decodeHexString(c, "901d6f4340b6a62c9cd6e4416579b1e8"),
		personalization: decodeHexString(c, "87e0df2f0382030b9c075a7c9904cd2373c23d9b91e1a3fbcea1390fb2d3b94c"),
		expected:        decodeHexString(c, "4cd933385c35765ae534e6856b27db712bbd3929bcbbf1a178279712e495dfd0dce8badd62e2e29ac17f00b2bd2319aa9e46f43b819c48af364011543bdb3f96b19687dbe5ad3afd04ccdc888089c3ef2e5b7ee9e17520e36409b24007633a09f9cc1cb34ba5a403db103e987148c24f6d62629ba82dd8ed5ecd189a238e09a5"),
	})
}

func (s *drbgSuite) TestHash38_SHA256_8(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a5f94511ff07b6bbc622f0f3fa2c6b60f285b51122f8bb314be2af0c947b54c6"),
		nonce:           decodeHexString(c, "b05459791bba70d4889369f43567911f"),
		personalization: decodeHexString(c, "aa196426a45d6f5aebc5792876e55beeb2e54d2a828952b5ce925a3b6d0c8cd7"),
		expected:        decodeHexString(c, "874e0417b59921fa32983c7bc3bf68a1efa3d954d1fe479bffc35f57e919581dce3d219707fd7a5e5cd236997cc57fce7d305172864228c23ac8873a2b282ac90d2c0f32bb900c047370f086ed06d3cf0469c3b82d37dcfbda0b1beeaa9c62329555ee9a5367221ecdcad623a778055e5c0a1ebb1d8b454346bfd1a78572cf17"),
	})
}

func (s *drbgSuite) TestHash38_SHA256_9(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "95c199afd85fc1981ec2aa6fede6436c28c32eae52e6a44edddf1f5b4cf7642f"),
		nonce:           decodeHexString(c, "8dedd5c32085a23c1c6180f453cb4dfd"),
		personalization: decodeHexString(c, "3a162000c4097360c4ab4137ca5631c1c8e025341d1b62efae92fafd59a48e85"),
		expected:        decodeHexString(c, "c6227f19d479cd1fc49dc13dbdeeb0df06fc9f6ce11c6c1f3c6708675140463f2133c8bc6ab6ebd8e9461e14f75d2939df0df46e0c331c3043aa04d23ab93fb0cda15923e071087b22b5ba63f9484e7e496b2a9a9e8823b9a8276ab846b4c9a9de2dcd6691fbef71100ce82ebea79418b870eb3f8fde931bfdc6258f74b72025"),
	})
}

func (s *drbgSuite) TestHash38_SHA256_10(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "fcbcef50028bdc7ad212751633a02914372c6129a08a006a6018e4a347236a87"),
		nonce:           decodeHexString(c, "01f3250094b99f81778642d3be752d10"),
		personalization: decodeHexString(c, "45508dce23e691f9e70c6b2e1b2d3ede36b70e7ad23ea78db232666856d2339e"),
		expected:        decodeHexString(c, "ba7f0b27f7ff1af636b284e964c4cffc8ea96e5d8bafde594fa95b3508af6901cadbe73898200265a4aa7fc4401767da4395b83bfa1cc331161f13a976946eb5dc6fbee959ca7db4374a4a9456939abf1865a41b16c146ddcd655878011182a8d244c6e2b36acc47b3c2e72f9c03015463ab9afb56c5e169d27a8fd61dd2dff8"),
	})
}

func (s *drbgSuite) TestHash38_SHA256_11(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "6dee1a672ad15390a3aa8726f010069c9b7fe9478f14e18ec3f4c342ab133190"),
		nonce:           decodeHexString(c, "313177543441c2ff222d912ee95334d6"),
		personalization: decodeHexString(c, "898c40045cedd2c82de0b0f83802aeb3ef575ad9635405a95c8fbeba921c1491"),
		expected:        decodeHexString(c, "131b74ff3efb83e60c5222715eadec6e0e75e6467eb45a31f253b63c01dfd5029339a5312889aa038cd0fbd16212324db31556fbbb06f86ce99383f237a194368e3540bf8cd4c6d3dce85dbe1d13f6a3aca30f93093d9d0c9e73122d1fa718b2a8d245fcbb8db13e89e417fbe95474dee914a4746acfda507403b9c222070fd0"),
	})
}

func (s *drbgSuite) TestHash38_SHA256_12(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "df6c135f471686d1af5ef05f297f25595c5f05e4fd502a1f693d9ec44df1191c"),
		nonce:           decodeHexString(c, "f6ac42f54beedf4643e4423892b52e8a"),
		personalization: decodeHexString(c, "2d8d07894bb0256782f300054d95cfb51a9d19fbfec922108a50cc2995aa705c"),
		expected:        decodeHexString(c, "34ae97069cfa8629b801b8db03f1ba0db19d9322b817a7eba89c3cfd909cf8f07ecc0402ca9bf2c894c4d3807bf3b9b4d674ce169b2a26eea3ce9ba64994dcd393be35eae7c8ec640185aa290d8152bdb854bbadb33521f897553b46297e4b2af2d0a9b1743ceff7648d60a73b4f5805d5f06fe5296ebdf0d14f430e7b2f2f3e"),
	})
}

func (s *drbgSuite) TestHash38_SHA256_13(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b92b652bd6bbe5b5dec2e1d736f9c90f1b1df723952638cc6aaa8023c029a49f"),
		nonce:           decodeHexString(c, "37ec9e6c51a7bc6bae0f526c83c86bcc"),
		personalization: decodeHexString(c, "529cda96958ff83d39a5fd469834a0c140b3efb8e4cfe663e2d5d2ced7fa7616"),
		expected:        decodeHexString(c, "052bfa2f45ab5459f2911c0a606f90b91124eb6bd1d9af30e56299127129c464bfc66c816264c8a71f6f1fdf4f2395bf00942cc23b99d05e07e92ed8c172de7d608db41b35154dbefd625d06172dcefcc0235dd567d1fda69d255aff1fa5b698abf60aea6c0e7b13ae3898609ecbfe3c90b737ecd7d2b9a3dcedd647bbf04181"),
	})
}

func (s *drbgSuite) TestHash38_SHA256_14(c *C) {
	s.testHash38_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "46d644ff515f49a39b743bd15469d7f96b2737037120a2a9279f564850027a3d"),
		nonce:           decodeHexString(c, "ab7843b73ecb4858f2cc5e9dfca803ef"),
		personalization: decodeHexString(c, "dee559515084d8ac49c3803f09f3d5fed3b307946a2752c267677f22786a0125"),
		expected:        decodeHexString(c, "a12f5e8ea3bb174934c15e5d114ba615da33210c98c38d7fde4b5aef9aecdeaef311d929d7fece7fee11db67134c3326b413b8dc17766ba4fb881105db68688b148fd95d812f6538b14f25afaae84d39025336136d270bd643f2a6c7164930372fb1c8f4f0dab60283e9d8d3440ce8dc66761c5d5c4c13cc3a367feb4869b559"),
	})
}

func (s *drbgSuite) testHash40_SHA256(c *C, data *testData) {
	s.testHash(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHash40_SHA256_0(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "7cbc54c2e6a7f023a8f8999a5f1acdaf7507cd5d77114cc9b4ac7299dc1be328"),
		nonce:           decodeHexString(c, "3da78de7b8f5e46ae8d906702d5a4bab"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "13d4bd6089a740b85a8e90683adb29bc8ede7b21c2a96c96b79573b2367fdffd00de609b786f751020f8d9f94b7052f0a14c1c4ab54cfa093b1e7237f3c72d95aed30f79b501d2e2616ee51f124e656e9ec94ba64e399c88089233928fa3fc0399bdbe145a275be1787d73ab22fdd54e142f312d4050645c2a45884506f3fdff"),
	})
}

func (s *drbgSuite) TestHash40_SHA256_1(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d60129547fb2f419089a6dab653274ae805eac0affd7b94250a258b56524fbfc"),
		nonce:           decodeHexString(c, "95ca595db46dabb4c2fbd72585b96850"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "849069b5c73b05db92cd63a035624fe247e9d84f6d489ec767ecc70d14ae87e23a097ec145103a85728e8c85a8c8b3ffca8d7c8ff080e8b6a8fb41697d5c9ce10ebd69ce9e57917ac488bd1bd2ca9ab97adcc9c769a6ba45a2a812b15c740577fd13d20a4257220e3436c3e517a3c49fb16a7d17d48aa7a32b49279c6c5ba06c"),
	})
}

func (s *drbgSuite) TestHash40_SHA256_2(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "97d2211c473eee50c5de5cebc764c096bf5e3553cfad251e1025d8bfe7629263"),
		nonce:           decodeHexString(c, "e44bf914f9c6678bf6dc14dc37d3c7cf"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c079e2405ace7085f70a35120826babe44989f559765ef368475e643ccd09fe1ba61ee7a3fef478fddc44914877860658ecf0c00b5c32944841bebbf73ab716b113e4f55cfc55f974c3bed717255ff5632d29f66594d72c15425fb7525dc814e28af2dbb0f3f2435becad4f1ff67b6b6758a7cb280670a3b33328de6959a997f"),
	})
}

func (s *drbgSuite) TestHash40_SHA256_3(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e4054f80f7b7713e5969d74bd5947366e6b6c91904fc6b0833b2a9215bf16098"),
		nonce:           decodeHexString(c, "560a78b9d9d918182ff199cd979d4d00"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f546d5d35a4d82f2741e9619afbb746c36843a486dd9932a4add1ba92ac58e7da6174f3c7168d30009823a946140d9f7cc027c4070870b9e8775da22f8b7d46e94eeadf89ab17932ab9fb05da08ead3b011575d50ac991d51f5dc46515e9fda09cd8e1fb24cbb70a9d412c111bac94b27845986106db3ec3523374c83ab0b366"),
	})
}

func (s *drbgSuite) TestHash40_SHA256_4(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "445adb190686c6f01267f85a9417a07891964db6d4912ca0104d8b1913c2d417"),
		nonce:           decodeHexString(c, "629f5ad6ab4c9a53b855a89ef9131b6f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "025d2c8da422f0cc95863cb879da114311c00c0bdfddcf5b7a7fdae89aaf116d5dbfc97e0a610bd5883c57d2e07668730566e6e0605a1810e6ee818246588f12a965c0db4b639e2ff8d3a8085b3f1736c46a86e1c7752a7538bf240f33b817470e69ded4d223911538e6fce9e39a215ac1c70e978a1b82c6a85066cf0e341b2e"),
	})
}

func (s *drbgSuite) TestHash40_SHA256_5(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "663442555b663b23c27815574b8d6ea4181baf870a5325b22364efdf27acb811"),
		nonce:           decodeHexString(c, "13059175b7f5a2990691f8b6ead2f9b1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "159ac7471027dc356b90dc757ba922d84f2e393d528bb851a91c46bcf82e3b08f73a3fe6177cf5548b542b4061facb28e936f153169c0e0148284367cbc21ed8eb577a31581c94c69c7c8245213c53168f268b817667860122c5c2e1e06695b7f2db2ee8254fe3c3c121232f4000c2ab5218b4ceb1eb129c93d821616586ab8b"),
	})
}

func (s *drbgSuite) TestHash40_SHA256_6(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0471b2c922386cd7ecc4f58a69ade3837118a3ff31c2baecc0761231cdcd1dd4"),
		nonce:           decodeHexString(c, "21cc4f15f288ac2e391802d9c25d2989"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c528cdcfc606beecd15152e89e564acb9dfb44d760d557aba44cd8c2d7c1918abb49aa4ef4184a189672811247e828ae5ecd0ee1afbc03831e7725767da12b61b4173afe68aa71ab34bdc69dcd9e744194f3f9d5b3664548972df82ce61bf1ece49b61d973d153c286f510ea6dd165921cffeec2ed4a3867b7fa23ee933e0342"),
	})
}

func (s *drbgSuite) TestHash40_SHA256_7(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5fd39bb79825e10cfcd9c836059672484d68caf7572f03c7dc7c87cec3b09157"),
		nonce:           decodeHexString(c, "11e932c81d29873a46836836cdec4a93"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3aada5139ed24c194427f0e2102f16da7fa20faf88bc0fe2a91799566217212314ef60e3adbf7fe3fd0f25737cc0c6d1c469b99759c6672904c5faa3214ceac0bfb9115322e2f277e8a7d963a5fc9bb1be05105375a50b9dc7468b91ef8d39cb04e1d80d756d7b4260e3edd22c94fddbfdcb9f74f47e4dd4368045194893a4cd"),
	})
}

func (s *drbgSuite) TestHash40_SHA256_8(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "fb1af2b3a8e063696a0c98a69bf3185a60b81c5ab631fed390780c4c777ebb3b"),
		nonce:           decodeHexString(c, "09656fa3bee0b69678e11caa1ecda431"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2aef0263d44bd904d62ec386b43320f6bada030699d1e5a1b418364b9159b24db47be608447f4b313bdff6365ce8b07775b94c30a03e7a73fc06156580a2fa35b83e62bd502d3a48cd518911c05611a7b3e7787bd4c15e8f51f52bcf1bf748225704b7fd463c74ee34f86485a82e495455e84b67f2859e227c90a0f1e8abd2c7"),
	})
}

func (s *drbgSuite) TestHash40_SHA256_9(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "9ad917a384303e4eb02a5ad4d4655123441d015be4c79de9b75252f4966eee2e"),
		nonce:           decodeHexString(c, "7cae69ae330b83357d52a0c60db51dd6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4715b2e627ce240b670868fa0d2c2db6fddf79d349debd8d1638e96d4fc75367e216d5c1bbc24e7f04bb9b4018799a5857286bb048670de20112cf19fbc1078fbc0494f867f73080663a86d020faef2ad639000e8f469157b07b56aa24cfd9de96503d5a497c36a76bb5f1315fbc0368ffa63c086eec9f3c2a2f05f39ec4b730"),
	})
}

func (s *drbgSuite) TestHash40_SHA256_10(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "63b10164fad0f77497172f863e0dbf7b832ec44b130013f88a036cf35ba00787"),
		nonce:           decodeHexString(c, "42dfcf70ca6d0f748086b035893044b1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c174c81bedc81793110fe8afac7549475ea85a5ef44ab286a44ee5b886d5432b6c47c1eb37ef6df908a26f10fb36a8f7956c0651c2ed14a730456062d1f1b99d2048cf61e76270e1dff2262d69dff741f5e1785659a90ea81595ae0aeaa1b69f8653675d39e50423976523894557853c396b8d36b82e31cb9696a50ddbd51e78"),
	})
}

func (s *drbgSuite) TestHash40_SHA256_11(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4e5d44e9aa525bed9b454072ba8ce8716a5bffbfa0048998d83de5f3a9d91d37"),
		nonce:           decodeHexString(c, "57ddcd4ab6b80fd437826cb65c86b257"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9b0869731cb7008c93284ba8bdc6d13502f4b702b3dadeec8adc49bd7c6b120ec05f1cd817b7a91c01976642c96efaf9a28513361f8bc91e6abf0937661eab6ae2da72dfe6b1010739f4bc649ee31c326ccbd8142add4a67cb7ad4ea43aa464611bf42d0ea566d5123526f13ac4be3be1f2d0c63e2019525b51b7de24c34a6f6"),
	})
}

func (s *drbgSuite) TestHash40_SHA256_12(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0234b735e8ffbea694599073e9180ecdd4ca98ba58c75b9f67ba81d19db07db9"),
		nonce:           decodeHexString(c, "dd0b80deaf176186c758f3587b741d42"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7584d6ce09b80b66fb2da0300cda78bf4e8f6c7b9069fafe59279184ec53efed9433e12bf0107a28a5e6f570ea7b103060203af7cc275a846305e30e67204a4c09375cfa74c2ae96ab0eb5b81eb51c6c95d09ac5be8f1312834d47d1883253bcda11517f22138ce72fe6256ee21b62bef368cca98c1eb8804ef7d75ad9ed2a88"),
	})
}

func (s *drbgSuite) TestHash40_SHA256_13(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e9377e9319cfbb35462c4a68e31efdfcf812a678dc4a6b09561d1f8d7cf83e53"),
		nonce:           decodeHexString(c, "f10fe7569a02299e548b2a374eaf0320"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "eeb4cb39f9a7099ca43fea36969d8ffc6035107f7f442eb93f47e9ce739c45c23d9080b00c5824f702a8b4a79a43963e31075c974a021db55e2e419ba7e76fb568d8d24a6fca1df0fe286802f0b51d0ce35b6dc2d105da2ad3a36d14743fa22eac0b2316933dc0c3bd56fbefb4239fead21e42a065eb222460d0c711ea2ed1b0"),
	})
}

func (s *drbgSuite) TestHash40_SHA256_14(c *C) {
	s.testHash40_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "dfa94c198483c5daa046f1dd1e4e83f854fd6c5cbc3465f671bdfd36837779ab"),
		nonce:           decodeHexString(c, "298de64bbd817d009a71c1424ae839f9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bfb9a54ce31406a82608aebc826441f8f633813a0c3bad723b802f3e905a6ee3512ff3513062aea51f93be17aebf1cfcd81868e85db3db9aa98680f974001fda8fe6a644f5efbb9d6e52e99ff606ef1ed7cd3b17fa6c6844790ed58da6df61aba0c200d7dff943588f4520891798098bddc65797b2f99c05efa090c60dc48a4e"),
	})
}

func (s *drbgSuite) testHash42_SHA256(c *C, data *testData) {
	s.testHash(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHash42_SHA256_0(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b1cf2861d5076eb18612c3f82930cc4ba6b9550736f741c0cd0534b87d86fa3c"),
		nonce:           decodeHexString(c, "cea21378eee439c51109b3f79c910c45"),
		personalization: decodeHexString(c, "24c0a8516faa85e14808e89aa0a2d71975cd68e0dd31b6c43b309deaeeef058e"),
		expected:        decodeHexString(c, "9ffc823cf7dcdf286bc53d8adb84f2d12e5925c660f365aff1faa13bd3ba78e65a457f1daa93e4e5eac8d75299455d4fe4ae00e801fc49a70be1ec8e8ccd63537ca176b2d37b5f60bf558afb5fb5073261dd488d10fd1478361549485e9a38e9e94c2f0a2afe5c9de2a8a33969e19ba5c23e617412cfa5acc8cf3782ed9aa883"),
	})
}

func (s *drbgSuite) TestHash42_SHA256_1(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b2fbb673ebcc69fa3c0030973f6638b3c180336c13a54ac3b6e3346bb7efd7f5"),
		nonce:           decodeHexString(c, "f373aebed57ac427e23e2ebbc35d19b8"),
		personalization: decodeHexString(c, "d3303fb23acc24e13b28fa6fa333a1b7be244bf5ab3cfc4b13680c08a4ffaa95"),
		expected:        decodeHexString(c, "1eb240532d54a759d0607ffa55b59f01c6deb83ebe4f0c5e72a86876463e2386e33b7dcdecd7bb21ddd3af56602a2e7566a88d5a27dea795a81f6e765cab3c071e25ea3e33202a9ebe31ed2a4857dc902107449b6c69c7d929ff35bb44ccf22064bf382c0d405f08aa73cdc312cabe4c49beaee3d7726b77ee0a24394a4f8162"),
	})
}

func (s *drbgSuite) TestHash42_SHA256_2(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "80cc1236257b9f5e35c5598b33eb0161bbbf23ec7d9a90793191be7c7475d770"),
		nonce:           decodeHexString(c, "aedaa60739ca728db6aed8bbca4c9316"),
		personalization: decodeHexString(c, "ecb8cbdcaf00649e9bfe53f6a06c7d004f2660f2b54f514dd9d2c9dce81eb249"),
		expected:        decodeHexString(c, "801627b51c768103363fe4bf5525a96fa396b32d76864a8dd81a35eb20034b870759735d7248d40f023ba59ec6de827468fb7610e8312a78474724d1812683479537981da2b2b17eccec2158b18731806be9d58dbada2214d810db05ab358dbeedb101e9d957b15bb1388e4a3916d13f4c901ef9c06aa034dd87f05ab1012850"),
	})
}

func (s *drbgSuite) TestHash42_SHA256_3(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d20d511eabb09c81a79f3ba6f6d281af2a55aa20733d66c633adfccc3c634be0"),
		nonce:           decodeHexString(c, "7420ca6931c91336f864c5c8f8ffec88"),
		personalization: decodeHexString(c, "9fc3b3b3f6d39e533fcf1bf0b3144f481e52a7924406f7433bfdf244e96fd94e"),
		expected:        decodeHexString(c, "765e248b0db5920307b4be960e057142b3366b590d96c2e9924386a707eed69ca983c5cc60440f402239a1cee2cc221c314803d35c8a5dc49ddfd339f10943744fd3b7b8ceef2cc8d9cf902a8710ef794140eda8b66d4c91bca7546681b4eff9d3e44dae601ba5f64c4ace842e10d865bd42238a13be3d60f08c4d64195568fa"),
	})
}

func (s *drbgSuite) TestHash42_SHA256_4(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8cad67aee7daa30e2a3278db86031dca6c49b33a475ba679151378bd60465201"),
		nonce:           decodeHexString(c, "386f929e5d599de61b93f49d7b2ea208"),
		personalization: decodeHexString(c, "7609160f2e21c410db396f68218702fbd8269058ca2c210b8992c7b89f8d4b69"),
		expected:        decodeHexString(c, "0db79419874923766f12b77fdd961b4384fad24e836b5ffc99382dc0832f5eb6e306b635ef220441e2c5331c9a22a3ac73ea487615112c9ce247bde7926bed0b17ec920f44ba6283289e9ec938da4ef559b44986001773e89d63934e15c467e8fd03924b12004df1390c267c29bb2084d06cff48913cebfd6cab5771011ff6ce"),
	})
}

func (s *drbgSuite) TestHash42_SHA256_5(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "7aec24d543632b4b17e6c8282bf780ae4823baa9d302025ff1c0a4212433371d"),
		nonce:           decodeHexString(c, "148bc4071939c0df24a0ee1403a91cbd"),
		personalization: decodeHexString(c, "dfc5432fdb048a77eb3489331063144a67119f5c9e9b81292e695603fbf36f33"),
		expected:        decodeHexString(c, "60e502787163b2cd2713f717bad799753de94875e423949b1f00d5ea607f62b25cf40266f05486ec0230340fb66fbcbc7825ee86e2f6aafb5852f8581e7ba6c1901d63352d60ad8266e6f4caed56941222726ae1035f66f380c1636c4b627694ee57e2e6986cfab21c6d78d4f073eb7e367df8adf4b7aed4e0a50df0237b03f2"),
	})
}

func (s *drbgSuite) TestHash42_SHA256_6(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "2b0f60802f16954e86360bb30f57235c6ae602abaae59890d4586943f7cbc6f0"),
		nonce:           decodeHexString(c, "da6409a4a3aadc73f4313da03f8ac920"),
		personalization: decodeHexString(c, "98080ac454e0947dfb872df6491abb45c361d58ddea368d98f9e6bd2a74ef816"),
		expected:        decodeHexString(c, "2b0be9b692b3a28891d635566b6358d5c17eeddc5e1795b879adb4655df7c2a241c8eee6b8f7b6168d55367c3a2899bfb530b67586e9f2b8940019d10dfad986abcf103b787fa982e009aebd24eb52cecfb916a1e2de8dbd8168c2f6a159c6fe0ef18892573c28b141812bde837d2c749951cae490b491d26f39f7e17a3ed7e0"),
	})
}

func (s *drbgSuite) TestHash42_SHA256_7(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0b2f3490a83576f730ed04bd570e4dc2513a739a282b4a5f843dc42d7db3b60b"),
		nonce:           decodeHexString(c, "d4c38f01cacdff71be37c02ed68b4186"),
		personalization: decodeHexString(c, "170a9ba375aa92d5252586eb08f04658e7fed3a6820e5e2d3df7db4b29740989"),
		expected:        decodeHexString(c, "46778c8804b6e5ecb7cda8c0535c6257b80bba1d362b45bc1ff67d181c2a02ebd0f3cff63d04f6c4c4db5b0b5954d3c2037c6eef94ce36b7f24a0cfa0b00905d8ddabdc201007b6bcd0d7c60e219fe1ca9995a3527b1dba50caceb5e0eb7120eefd1e9625891edce039c4d7ebc7f6bfd3839b4f608b18ebf3e004d913e029078"),
	})
}

func (s *drbgSuite) TestHash42_SHA256_8(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "2e9ecbbfa3fad5e53c4321a800b5297af95f1471256b2a09453ba7934d02cb46"),
		nonce:           decodeHexString(c, "9d0e03e36ce2410a125d0b5173b4edce"),
		personalization: decodeHexString(c, "6bfd6bd8e4461f827a206aaad604904fe9b90f209a9e2337394971cc9cbf19f7"),
		expected:        decodeHexString(c, "085a72dbfab649bf383ac75b6a044eb694b02371cd880e372c42cd0ffa265ce3d9b5253f2782b3ba701175f8c4b81f280f9996c3ed652b1e409a3740c5a176a5624784c3f03aaaf2b0f721428fcb55c9aebed4b0a13ad2c1bb2170adfe64a25130a41b18066017fa6e5595bb5d1d4f6c7355e0a97046d892cb255b91a03d5f1f"),
	})
}

func (s *drbgSuite) TestHash42_SHA256_9(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c9e0346eebd8b4e63974f7bbcb54c85f8290afa61432cca40a5bb2486c116f5f"),
		nonce:           decodeHexString(c, "28421ed541358dd585abf9e3415f3260"),
		personalization: decodeHexString(c, "297a6461f314d04a9a30cb4606e1a31f4eb5cf89fdb2c4c716e83d21588e4573"),
		expected:        decodeHexString(c, "2829cdb58fa9d47b5518ea8b34d67935ffd1b9d753ed340f7f6d0d76883ccfe0998dfb07f0d3431902cb1681de34dcc78637a34d3450c600af0bf67fe86674d5dd8b667e5aa5f1dd9e78039b2e634857a97bb2fcb566f695e678af10b5bce17d30876a63e11d6a4053d159095ee0bd6f5f872050cf9ef712ee600fd05865550a"),
	})
}

func (s *drbgSuite) TestHash42_SHA256_10(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a438e51dfd58079f0cbf7d0722965f95ec21ebde892d4c36d3d95b5f5e8e9dd7"),
		nonce:           decodeHexString(c, "c9195a85b4748684a50238890b00d373"),
		personalization: decodeHexString(c, "c99f46288fe839c63bd1bc21e3211901dd8393fe3bd18c5567ffbba90eccf747"),
		expected:        decodeHexString(c, "e1ba377f1966c66329b6b0a3997d6fb62e06afa00cecc41f3dd532e6b0427d89c89bfa38cdc92abb90a512040d6ecc99bccfdfd9ef7f59c46ebf0aa63b45bca6e45eee02d0389e283c144ffadbcbaaaccf60ed958eba454ec31a026f0d397c5c5c451e8a301537e7e2569ec791b68f868e7e374a590b56381b6350dd5ab217f9"),
	})
}

func (s *drbgSuite) TestHash42_SHA256_11(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c39b9c88b3bee8eb346bf86bd4435e738b450149d1bbdc0fb9c16ba9ef3a02dd"),
		nonce:           decodeHexString(c, "12918b5e939878686facf9264338b73b"),
		personalization: decodeHexString(c, "16da91970406d5cd9c29ecc18cd3d189e0f6cf65d86612b26bf6f2bd88dbbecc"),
		expected:        decodeHexString(c, "ea21806f4f2202cc00216f88299bc6681c3e0fd0c5608e8f4b6ee4522d59c43588f769fac9b48631eecd415c643665a83bb4b6d39a26d81de07eb3a296bdc406f7916b412264bff596ba85ee6866bdd64a56b6f15776c41b063b89a9a80a7abc3c54cafb7e7db65b5e3f781e770b5880041e484335165fb7d859158403d18470"),
	})
}

func (s *drbgSuite) TestHash42_SHA256_12(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "6dcbbe3731f95f1fbd6576433f97890b52a498a022ee4931fca4478061ec5bfd"),
		nonce:           decodeHexString(c, "44abbc3bd9db8c992cc7d3cbd5978610"),
		personalization: decodeHexString(c, "a4902e4d2530596e087584d55cb1175ba700fc66b1cba3cc9025a1c5fd984098"),
		expected:        decodeHexString(c, "a4f8dea1d06fa88c2eff31fc04c18f0611b63fcd6639b26a884d0dbf58f880d498bf2adf172ba9b3898ddc710b19a9f9f7cd57aecf588bf131418daf73f728e33f94348ee5d3d8b935e6461f9b30b33f83b1459e17792463c2b4527a1837daa05a976b62cacbb81ca9e826e7179a118ceb2096f3f5f6d8371ae67e6b91dd274d"),
	})
}

func (s *drbgSuite) TestHash42_SHA256_13(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5b44870f8a759e080d05b26502d930e3014857c25c0112f46869244f7e3124a2"),
		nonce:           decodeHexString(c, "930524dc57d8c1666a375ba95a99e97f"),
		personalization: decodeHexString(c, "d880eb9e2df605d87b070c5fcdac39d18da0674d2ace57753c09cda63e0ad896"),
		expected:        decodeHexString(c, "89eec24a8954a252b43271c3226f3a3bf814d8f7d14d7ea53b215333e42df4441d646ae967055d29ddd127bd7c96bd30b21e4d379ca75a831a97d516b1f9141814b654dc55f99522af8a92c72c78f5207d49afd3bf1eb52e26f89b7d6fa3504341e6e627771c925990b87070867e9eb972a29e3da7fe944bb486a19c41d1462f"),
	})
}

func (s *drbgSuite) TestHash42_SHA256_14(c *C) {
	s.testHash42_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "88f77e49e275f9db1ee419e3629c942623becfa50072eb2aabc98730ffe5977f"),
		nonce:           decodeHexString(c, "ea7d3c3b8f6da0667d7f0d543c68d7d1"),
		personalization: decodeHexString(c, "86c20a7e794c887898d5bc00e98398276a4e3ad8d674fb808a63a44330490d2b"),
		expected:        decodeHexString(c, "ee8e21ff48af611a17d33e130f4e4224330efcc1402b6d55aaf1f514553b880f18df68c0e4279854eb2e9b904c552f69f0e1badc347ebe336b70456f221e07a2fc78df72551d99df3755997029ee1461e2b6e396370096d7e8c2dfceb73214a72ae2b25ccc60b92dd71988eda811ceac4b7c335528249aaf82826a14c142007c"),
	})
}

func (s *drbgSuite) testHash44_SHA256(c *C, data *testData) {
	s.testHash(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHash44_SHA256_0(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "10fcf8146dae3b9128b9602fd61a2a6bb009978bc9722a85bd60f8d30b83f552"),
		nonce:           decodeHexString(c, "6baea5c15e9250c9db5c09435c4ffa73"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "24ae5313ea0103b4b333ba25e22457259a41f85bac9db81b6b55f1caa621557ede088d6a0c4819a253c58bc562e00c6447499c091f93077dccbe8e911f9475da659ab9ae2a931f66065f67d8c24047be1481e706ea73ca69765a65f9dcb591e1b73a8bcf8a475ec946477b8cef12723c2742304578f0bccd7e513b78ac94136e"),
	})
}

func (s *drbgSuite) TestHash44_SHA256_1(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d77be0a5a4fe465537546e994851fcab484262f4c697a2adcce15539eff5e675"),
		nonce:           decodeHexString(c, "8c752466ee270cd4870f5b4d3e6567e1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "227673c200cb5d2b60c44d7bb90c43a8b06cedcbd93c3000651f8fd0b075d56f824aafac1c6cb892e75db3be1ce0cd65eb2069fb58adc875f098d8224cf62d4c04609f4571abbdcefad66c461a0c3b893f2140333ee4b8a89cc8468f41748fc565fb65798aa11e030df73a285407e6db30dc4a62f9bae2a7b42203bc8a6a4917"),
	})
}

func (s *drbgSuite) TestHash44_SHA256_2(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c162e8a2cdd60c3c63145741dba3976d08793c2a9eefe422ed2790f0388a7a9d"),
		nonce:           decodeHexString(c, "f5e38686bd46f8841253465bfffacfda"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "63701fad5563373bd6c3ff38a1bb7c8e5bd3a88b4cd182af534c3a120317fed5303efd8002709da280a17b39b506c4188f0eca9219db90868e3780f462b95902cbbd339543e41b8a98eabfa31399a0bcea9e8201efa961aca14a888d99556da529e72bb8158f855fd8c161cde32d130afd8c8691cd81a785e85ebe212dfac0d8"),
	})
}

func (s *drbgSuite) TestHash44_SHA256_3(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d44e4e3e5347e90b4d2ee05888af66da3c26e1aaa53ffe764168c53f4e8c4777"),
		nonce:           decodeHexString(c, "ca8495549e2bc06e444e559ee0c2e259"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "77356279c3c7cac6f804f32c496078604db25290aebd9014fb54b2c6854134f11f8dba3290725c97a6908bfc266563652ba59404611351c4b010bf2ed2d53e0cb5bc9812a27919e0db208b7897ba426b2b0f7c6982a6c3d3d9343093a689038d9e695449ef5a5db0786cbcb9f738bbecba27bc9310c62955a99c2a079b3f0d64"),
	})
}

func (s *drbgSuite) TestHash44_SHA256_4(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "164eddf7e5ac3a97f12fd9dcec6a2c28299fe438b2f2e528b85a5570273c49d2"),
		nonce:           decodeHexString(c, "6e8ffb04f424e4a44cf9ef1d23976056"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ad381ec5b480bcb139067d5c6fc34fca074e7582bbcc2950de130fbf5a71ffd66c79a5366bed8749a2fcca8aec48738024b59af4f50a8ea435daab467bcaf8be0b340022bbacba80fd6ce5dc31e83f86435acb4af5ac6bfd7ea55ad66e99c5d77332efaf734560def68562f44530a4006d4d861daf290a10e22305b4e629e716"),
	})
}

func (s *drbgSuite) TestHash44_SHA256_5(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c08325886f63c7468875930cdde822f98bcc5a8bcc9c3d3ddcc93b87778dcb8e"),
		nonce:           decodeHexString(c, "91b70fec62c55f130b605687773d1ec9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b87be3fe492519398921db91d60ae31c99ee62069fd1b36d8e5f2e18f832ebca16e72b88c5898b27d8713718cc240b4517dd2cba73cc00fbdfd6cd94eb9ab2cfbd4c276b68881cfc9c612fd39599d73570a4614353795a9357f12450bb1c9efa096dc45a203c11291aadd765eefcbd20d2af70c51327453b4e8c3d67f13557b4"),
	})
}

func (s *drbgSuite) TestHash44_SHA256_6(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e5e81b2d7aca827c8afdabf6d1aa2fd0e83ea5e14f44bca8210f70a5ba4a6efc"),
		nonce:           decodeHexString(c, "0a48b9ffba4ec92d4394aa47b3b5e76f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2f9b61ec113842913bccfed32b6b49ac99da8ed983d66757044b7d8ff01953a444527b111f78af5e2be174772008084f17c4ec950e1fe050dcd59c8e67f83338587e134149b363d46bbdc71fb5ca402a0499c72782795b128a2622d8c4934f0c4d9a59c5c71f28d6da1daacdb4b5a7e9fa7cc57ab9ea0bac9fb53af8d03bd906"),
	})
}

func (s *drbgSuite) TestHash44_SHA256_7(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "2a0e188c8c89586dfe41d99664ca7742a6351bb359d9f6acd1aef946f08d442b"),
		nonce:           decodeHexString(c, "ed97b1b9ac5d5d9dcdba2f83d6571c8c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1e242848fd1ec106dba9ddf8df21712872c1e6b99308f49ff48edb51e5d3af5f2d7f2347cdbef284a1b5377ebb06ec0d1318d2cb21185a0892db0dae9614a0e8886986ed9d3fdc2a666c7f853def036fb0d4ee3e4a0ce5a716dccb486acde448aab6b11789440c72902ba4a8951b486575d8d643a9137f44d92ad499fc2133c8"),
	})
}

func (s *drbgSuite) TestHash44_SHA256_8(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d994f45a7cc96c251231be52fb9a0ee71598bcd9ea238d5e3bb0d9024b109790"),
		nonce:           decodeHexString(c, "960e6914924980f39ef4467995e7acb5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1e79ee0fb78196863e08ca886b756dd527bb26ffd8742517ec5b2a2db2cca7ff3d0141843b31500803d93d3081f6cff618d85a68b87eaa6467f3a5d4a8faee15494bc67d0e20ecdf0c045df362754d1eac229ac08db652421590481482c95469a6ff0d33c82680bd24879cbaa3422ebe2c21053e90ce3da7387f1a8ee2386520"),
	})
}

func (s *drbgSuite) TestHash44_SHA256_9(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "cc1b4aaaf4bb4e6f780c01387d1dc96052b9d31df08ba65ffe03a3b81d266a7a"),
		nonce:           decodeHexString(c, "6e3efc6d37a59c41b722c44ff63228b4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9dcc10acecae8b398c336fee4a041d5ff8a17b814625ae8425e7c0544864985d63479fb89306f9b10a2dc6b3d125729b5be30d7657203b869205193507f495128f456e167d8ba6d61471e5306faeaa2377c8b5ec2d02a2e78e3980b5a980d3c3d775908cd7e22c84beaeca68271df7f5b9a165fa5c00ff1d1eb9719c6c5b480b"),
	})
}

func (s *drbgSuite) TestHash44_SHA256_10(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "309d4fb899d41e6ade625394ffdabd2eff54a8894e5d72440c2132d51efeb9f3"),
		nonce:           decodeHexString(c, "9963ca2c47c1373151d4aceea538e81d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d8e507a090a690bf6dd264ddcf8440202d6f824d43ba695124a9bbae11486661fab6e47ca402d50d56307ded294c94ec0f3ac9f77f194fa3a0568c8729bac5a2af5687d0900cf8f173cf1e6b06bf1a1b319e0f8674ddfc97089119474a76bfe7f1d8607d667ac786de8f4f582b29deb9b984f0a3e07ea16a266532bea581e0be"),
	})
}

func (s *drbgSuite) TestHash44_SHA256_11(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "dc50dffd0059b869f4c5c1c26eb84e7952ec88acc30981c22bdb3eaeba78573e"),
		nonce:           decodeHexString(c, "deb4925ecafedce0a2b22d34cb2c4db4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d439604e338e75bdf6913fb60bfaf55f351f59e6c053dc0f5b2d511f810f1a92c2c419253e8b3916f50c5e9c0eb562f78df2ec853b8ae11b5a13c08eaeaea511b2881232504df077ee85b401c81f472aa1f11c7d039eb1a94ac3637a23ac2930b8fa8147f907868b94eac0141869da3c87931735bb5c52f420af6babdc5f7270"),
	})
}

func (s *drbgSuite) TestHash44_SHA256_12(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "92fc3bf974984f9319909b012857495678e321005b3719b20a29bcb66aa0d8fd"),
		nonce:           decodeHexString(c, "c7b8a5b55120c311a7ce4d246d55b3ff"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bd6dc280a58e046bb49d05ed62b3569d958b8d8a3578ff341f142c6903f1f927820c3ef4973abe202fcc720e8b672d68c49be711bb21bbc63703e62f91ccc496134a660e7f70e3d105b9f51a75b3c7e0b029749eb6f58acbd905abe6fd38dfa7d1a3bbba234313278265d2c5268641ef76e920ab413b8c2011a94755cf809e97"),
	})
}

func (s *drbgSuite) TestHash44_SHA256_13(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5b1bf9aa49da3f434e5b0335866131e3539bdfa57e039a2e788d9144dfda66f4"),
		nonce:           decodeHexString(c, "3e30ce4bc1b60bb53d0bd4ca23a2f638"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "885f089848ae891ae62153773b0ccf4711563956e50b6f3bd4f35d3b55ca64b528146f28704bd2a81b11b644cfe83709c3aa038a062f4946121d5a71c39735ccdea64f50358ffe71cb015674c351af290971c7e2cbb8e8fc4e1d24132c1547e83ccc3dc64f4991fd5e317b771eeb7045835db0fda85c719b03828ccf1d001ee9"),
	})
}

func (s *drbgSuite) TestHash44_SHA256_14(c *C) {
	s.testHash44_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "6b9f904ac4b16d36e06a1bddc501d7ef98d5685c1ceadd0a6e1622e0c1e73716"),
		nonce:           decodeHexString(c, "4a42f39e5a241a2b96db29055159c91f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "785014b0460831b7b67346c6997217b0f6c8e7313687ea6ff4d0b09a0786bd6ac362a0b1ddc6ab8c9c624625a379cbec7f11cf30ddab23cdec054b986175cdae0ca4ba4610e0711bc94e9ab706539d5fa2c1a4fd3cd49042696b58dce465f8e09a200e7d214cda357021c62248a01aeb95f8ffa8bd49d354fdccf4c71eec3491"),
	})
}

func (s *drbgSuite) testHash46_SHA256(c *C, data *testData) {
	s.testHash(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHash46_SHA256_0(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "1d867f5035bc9283f28d1c73c0694f9845ab8cf0183d88675f8f7c554161dda1"),
		nonce:           decodeHexString(c, "62cf61dff15053a91ffca7e72d5fc123"),
		personalization: decodeHexString(c, "549acbdbdcdf94e8494685f00b9845f3de370334602aa41f8180e198a35cab26"),
		expected:        decodeHexString(c, "9bf8bd71725c751cd6e82a288f50d9b710fda83903093efb49b06098fb904d08339a0ba0f489517c0cdfc12e1eaa3ab4caf00374e1fb5c776cb75589b1600b33c60e2d6f8ed29dba28ed08a183257c8b7635f987c037b29377d4c5348a46e0845ef7e13cb682345f99be900b3cfc7fc4e746a21d06754c14ebb5853f8cc8dd66"),
	})
}

func (s *drbgSuite) TestHash46_SHA256_1(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "28b9d9578a541a44f581a0a4057e0f7150d495ff29d3e8f8fc34bf689bba5b4c"),
		nonce:           decodeHexString(c, "f960a9afcacc864451ddaf6a8b503acd"),
		personalization: decodeHexString(c, "68cc3f6f753574432091f165230d96c20797a61f2bf17419bb39251400d980b1"),
		expected:        decodeHexString(c, "1006fd00b5818f28eed75ec1649a28ed20781898fff9c162cebd4e84d3363a1c140c7a110a315ba1f300422542f191ab5239b658048dc701321d8e94dbd12ee985e317d680708801fddaa27737c32e511b496e9ee260e030c64618d40180117faac4a1f0a68359f361d3d3c6cf163246554856c176fcc6642e3b2596ebc59768"),
	})
}

func (s *drbgSuite) TestHash46_SHA256_2(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "680a780fb5cdb70f9589612d22ee4e4120a073041d36e48ab2e68a71d37cd247"),
		nonce:           decodeHexString(c, "ca385301faed38577c2f378f1aa7f661"),
		personalization: decodeHexString(c, "eec481b1191d2899498a0cdb771d1315ca8037a562526a92a13cd3713fbacd08"),
		expected:        decodeHexString(c, "a23f2ae78157f70dd684b8a553dc3bc16bcbb561037d1d39313ea7e3bdec13c1c7f98091bb0dc8825a1f743696639b6a3a9facc0b06f2a4de50878b1295ab2ba8ac7c38714dceb9d7a3220a3bae3f4c58079e3cdd302f4d333d42ab11fef3b93e40deb44579508232c1028b36001e3e19d3f9d7ba01c149e8c91c773012efd76"),
	})
}

func (s *drbgSuite) TestHash46_SHA256_3(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5b0c1030a67d25ad814be77ee43246aaa507583543d0af127af72701ce096697"),
		nonce:           decodeHexString(c, "4f4bf66ea5dd80e2f8a74e07f283d82c"),
		personalization: decodeHexString(c, "a6509051d055cd1511437a23c4c4ad604d77f30c7fe9576015a9d7d0b7aace3b"),
		expected:        decodeHexString(c, "80d95ba8500a378bcca272b2d062dbc9203a5e977724bbe4a743612becf097b00db35d08dfb151abe8928f8644bbbc74080136bb209d02a8f5fdc7c1341e60d4dc3f451ffbc05936e201a03281a4a2fab279b664142aa94019b75fb30a2954a877e327728bd8f1aa10fe675037a33138857b173ae96ad2bfbb9efbecc4710faa"),
	})
}

func (s *drbgSuite) TestHash46_SHA256_4(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "87c8ce027600444466242819326a0965f807a39faf3a0b48021a65ff13ab266a"),
		nonce:           decodeHexString(c, "136b1cedfdfd4d603d8fc83309eb67ee"),
		personalization: decodeHexString(c, "0fcf8547b441ab422f0cf2d95c47cc28e428cf12d9a9ea2ff0eb42b0f7fd1bd2"),
		expected:        decodeHexString(c, "fc1155c5af51a61e86ab99c9f7cd56adf24f58445e3fb698e843b949b4662aac552443519dd7ea9d22208287190ae3228f089e32fe4f5f5d1151708dc3993e4ca645e9743b4b2f7f8180417b5645b77a066c114c3c742c3ac7a93b6b34e8209404c54c349f9128d474a0f2cbe311bc94880cc96a071ec1d0dd1effad9a315b31"),
	})
}

func (s *drbgSuite) TestHash46_SHA256_5(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "ad907f38567e95322ed5b3c2a215be0f7194b132e80619e35fcf57b3586b816b"),
		nonce:           decodeHexString(c, "8631ea64725c6ccc082c3d0af5d81f5c"),
		personalization: decodeHexString(c, "05553e60f6063389263229903834ea47dc81aad5347fec7e8ef9876fc37bf2ae"),
		expected:        decodeHexString(c, "b03cd5a6df9082f1e6dc342c435ec792119affde694cae8f5b37eafacf973c270344f1d729bc3d9e4c7baaf6438475a57614489253ed7125bb80ebec8672135e8b7372c457d6a0cbead529069872f470367db15d591293321dd1d6e90885c094e0b30761fdc33c0e6537b56a88d1de9d9525aa655c9466e0ee9e1945218f7aaa"),
	})
}

func (s *drbgSuite) TestHash46_SHA256_6(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "795769b8351dd888aa92f07d6e8f9a04fed7296c15ab6d235e8a8316680fd786"),
		nonce:           decodeHexString(c, "ee62b4927f4c1ccc96e4c76e014afe13"),
		personalization: decodeHexString(c, "04c749682fc9b1cc67c679fdbed9632c29f18225873e4e6107661f6d6eb12757"),
		expected:        decodeHexString(c, "662395d3e6b7f213b8b4b59c97be6663da654193376ac232df472354e551edf83ed2737f935dfac99e025ae0fdefa2859d53197cd13d654eacba97b0e13f06c4541e9091c4a52362260a8015a7eece8b7f54f875dec083c16b38ab591372e4dab931171467a12be970e77131be76ad179aa9eee7b29856b2a60037cca58ea579"),
	})
}

func (s *drbgSuite) TestHash46_SHA256_7(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4a5e73475c94f15b6d3e2f3a17925077a0f278f84254f2499a4730864e9fa5a4"),
		nonce:           decodeHexString(c, "6d585a87e829c62df7a844eafe7dab29"),
		personalization: decodeHexString(c, "628f527dddae90cbe378425f45c6c2838550687a3eabc00962e74f673578667a"),
		expected:        decodeHexString(c, "45a45ba2ecb6022043258fd8c9802fde9bfb96834e78597dfad861eb0686672de521e2f73956fada2112731dd4d4681c878248997b97cfe5ef41af7ff0d6b1aa235dd815ec7e907840b4d324ce144d6008d76fe9d750095bfcaef07b9b61252c9c2d8d925e950394636232a21595bdd9ac72a4e288884b3c9400b8f282f59789"),
	})
}

func (s *drbgSuite) TestHash46_SHA256_8(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b54f138047988aa6444e39f1d6f6d678ee76959c8a60dcfbf326bdec982ad6f0"),
		nonce:           decodeHexString(c, "07d1124bf91d521a748da933eb2e84c6"),
		personalization: decodeHexString(c, "d5c439bea73527337a3c286475e0e1843a9eaf4c37f2924a802ef0063a6e0b22"),
		expected:        decodeHexString(c, "67aa568db726709a5cc6d5e157a50338bc898eb47ba8cc4b6fde07bda95bde5543f2e2773b0a557f91aa19e450db0b937516af6e80245d3cf60c3030fe8e3924d26f722c17442b534d7bf1a72ac8e0d426d36875e5d6d9e39c0bd607f3f041cd6c80c5a4625a8c3ba92189c8c35ba27a8647d09783aea4c69fa50654eae83aa8"),
	})
}

func (s *drbgSuite) TestHash46_SHA256_9(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "598db9f9c8e94758ed16901120b063894e3c8c9b49f09084ef5d5b6ba4f95941"),
		nonce:           decodeHexString(c, "e6efac7fd9a7547b465765505359e8da"),
		personalization: decodeHexString(c, "1bc2ee7e72244c607173c82de730983a7f919980c3c9ea9220b13c008d21259d"),
		expected:        decodeHexString(c, "21a946737912de5069cd01dddc9fb261e42ac76d69c7c0d583dea9fdb7d464bbd1c4238ff21df42e8079a5ff33fe96a47e4f0767c3b91a1c1b3f415f257ab08d76fa8ffcaac09859625184eb29900637b812c2fee97d996f4910c7651bc587cee8483f1fc699466a30580ae91c5ebf7a75e20262c20538c855c154f82231da6d"),
	})
}

func (s *drbgSuite) TestHash46_SHA256_10(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f34c4e31d24427b4baf883d84c332922be2d998b8cf44c7ab037730ac50f2f10"),
		nonce:           decodeHexString(c, "6de71410f79ea1e45f5e48c97f3bffee"),
		personalization: decodeHexString(c, "0007d483ccf2b8fb72e7d1d01b087d192acdf644366461af5356e13bffd041cf"),
		expected:        decodeHexString(c, "c517a99856ec0dd95556a0f7674deb0263d1fcfa09dec8e3448697e17bee0946d94cfb6979b429fd318a33750e61eb4649c0eb6b77e25884725c74bd0cdf08a204de6bfeca7b259fe0215175f5b7b8b8750eef9a6066238aac5d4144d1ed8e03710cc69d6a87d25ac00bcd0d783e07e819d05cc2cdb593ba535225d3c05b8c54"),
	})
}

func (s *drbgSuite) TestHash46_SHA256_11(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f086b40e1a22e54642765b231fca1398b52df50232a513f2c6f88838785bb962"),
		nonce:           decodeHexString(c, "40b44a20f4f3d848d2b8309d70fb9a16"),
		personalization: decodeHexString(c, "4f3e71366ef7b27524834ff83baeffa8f736b38135d3f467e7a7afe65c640b9d"),
		expected:        decodeHexString(c, "db909bdb459091fd42334d1c59a89087b155f5ac97b02c3249a05d98c16e861b4368b5c82995139b608b7fc836358ccac44d9caed7a38a76c0a3d8462cf714cb3341c7ff21513bfdd0205d0230042004f6262ebd6e33607c9e7540d72e4e37ebdf4057d277031d217cbdc5f0eec0dfa9befd4473bdc046735e39ee8cb99e81aa"),
	})
}

func (s *drbgSuite) TestHash46_SHA256_12(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "fbc3e284684fc31743e16443ad93bccaced82b9959a2aaed7aaa2f9c2e71e89d"),
		nonce:           decodeHexString(c, "b2a22ee90257c40d14f2a3409e7385e5"),
		personalization: decodeHexString(c, "318d3a036f26aa3abb7de9a028f74c8e3268197ed0ac9dbbc54d093435230e2f"),
		expected:        decodeHexString(c, "3256410afa0fb106c00a00e1c306c8bd9b8ad77b8b90512a5a7d0c6465417d93466c77408bdbd6272a7ef9b772291bf5d9c7af12a57301bb9bc3a765648d574ec0f3d51b13ceff5b7bfb03f5eca9f320acf107f9c755b45d914ad6beeb3436a1817bd39717c601dba9a715daabc28f35dce70199f432dd35cbeb36be1317ebf8"),
	})
}

func (s *drbgSuite) TestHash46_SHA256_13(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "306c6de3fbc4696fc0e76b022883f7e076cfdd900a1d34840084633567ed5f4d"),
		nonce:           decodeHexString(c, "2f7d1ab58b6851661e2073619bdaf613"),
		personalization: decodeHexString(c, "adb09590e12e09dfcf790763f5a11ad8e9756d60e05272c6b294f58346c8b1ba"),
		expected:        decodeHexString(c, "9a92b93500a7285b299c50f54270a2e0039e6a90ce6cd67bee14a00e3965961b313f6ae16932bdca6da66abc350323b2f8b72a5362869fe2e46a725844b984a060de718538dd0f245e2f2c7e99f4730fc2061dbaf4833a9bd7a61981d8cbe0283080db13d6c4613369837c72f6a2504c731ca9ff4c7d63bdb491a0a7795153f0"),
	})
}

func (s *drbgSuite) TestHash46_SHA256_14(c *C) {
	s.testHash46_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f6c327302f4c09fdf6a622d304f5ba778020b00fb31321193d9c3feed76edc61"),
		nonce:           decodeHexString(c, "66ad2a0d5de624f3d709cc95e5c99220"),
		personalization: decodeHexString(c, "6f7f8f1ffdcf859adcf6020d5cffdd8e3e1bdcaef0b22e9e61384b888f1b3537"),
		expected:        decodeHexString(c, "1bc4cd76787f031df8e4f592f56a845f7d8aa200aca0b910e68f149cde112d0f1e127faa7fae25ca4299eacf9e49e132f3e4083f1c5fb0304b714f06cea122bc1392cbe18289d2411ae08642a9196b654a8b177c127b9215f9df815eceb254b8d9b4f632d25d123ceec686124e58b3606ff1ce51fce0752f42232c03694a1d8a"),
	})
}

func (s *drbgSuite) testHash48_SHA384(c *C, data *testData) {
	s.testHash(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHash48_SHA384_0(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9ef0b00381d6c8c54d08fcadc6f5ef331134bb986373f65c6a14f553bcb6c55d"),
		nonce:           decodeHexString(c, "9fce26ada7b1de39590312bd9d81c4f5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "663ffb625e62c4eb67d7177a6abb808a9f68c2d5840f19992c11ea3a635d05b537fae1f1746c1314e1a75e141c2e094187d17b9daae1442e41d3a0d1fea94d8ef9d840111379a52e6c7ffafa7ee83b244ced129613d5b8bb089e7ea25de1c29897735cf95695043a648a2ef6fd4aa74ce8328a5550da8ddb51f98adcdc108e455603f6f18f5a50016f3e8ebcb244a16bc6b6e554a7546153c12f522c75ca5f1017e01da36650e6203f30ed5c3da3b6078736465eecb400eeaaa2c876e37564d8"),
	})
}

func (s *drbgSuite) TestHash48_SHA384_1(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3435d2929787173084e16310a1c407699b08d8c68760d2662ed844c98c2ce66e"),
		nonce:           decodeHexString(c, "e3ed52b47254ab2624de1c200a261eb2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7c8474fb0192b64c6b113d38d277a6825440bc2b484714c3a35d9bc3d35fc652b61741771e5d3abd7a1bea0263e35ba2ed4589a07363c1337895c40228ed6dcc36e02faf519919876b652f24cb80cdb044db786b240adf946ec0dcefcc2b406c7073db0f88024cfbad5a39ea53236f232d1251d640adb47c176cee0941bdb15e785344cd3753a7d77cf2a1b4a7048d00a94224de6822588e91cf3a1f2e966564a93bca54637724a4fcfdee95fb1f74550593f8367665eeb84625deb46307c21b"),
	})
}

func (s *drbgSuite) TestHash48_SHA384_2(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "caccd506e5e63ed46c19edd7474132d14ede0855dc64069316b4ca85a2943d53"),
		nonce:           decodeHexString(c, "c26ae8b85baae65e669aabd4373b9f27"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "09d8cadaae97213ca801776fba9c58f2aadf19b8272911f7912905d030045fb77cfcf75c13eefd7a0bafe57b8c23852ca2f016beb5700b924f25cb123a5f527bd8cf2a34653446477c5a53f8dee827eab2eb6a2a43705abf22e1ac023ca92226493cc0a192f945cbfa62e84fbdb1afc3ecb31dcf6992d376bed81a9a3e426e770b12eacdeb32d9f3ac4d39a7bed6263c1422145b2ab84206b9c5da60cd5b5cf940be909033a3dd17246307fa428c6eacef705023d61538e781bf5d436c61d290"),
	})
}

func (s *drbgSuite) TestHash48_SHA384_3(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "57b92173647a1bbfd7f490ac965739c76c2977ee2e5912d882c7125fd91aeda8"),
		nonce:           decodeHexString(c, "b5dcd934cd05ef2c4e80450abedec058"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f0ef1c21a8e3615df65275fe61c11457e1ea15089ae80efb72c55da4a2845d8b265efc9e7dec770857e6553f48da64fb05c0d381eca7452bb05c6126ca897c97d4440d28be66300bb1377ad9ef8884b077753865e8769343b498f5f4d6a0dcd9bb0d03733ae8522c0d9226ed079205448efd4f2f752fd7e80b5c01a5ef525be5285fe1af113a355b8512d0efa256eb4cf2b957e4fbff861bcf04d13c51a3fb586265df2c7ce6adbfd3d91e943944333619a16e6dea782392dabc0635e960c793"),
	})
}

func (s *drbgSuite) TestHash48_SHA384_4(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a146876f3c486fa6d06880ce232379cb929a0b8b8dba3f9c0196c39325ebfcbf"),
		nonce:           decodeHexString(c, "c25a3bdcfd83770bd5041ab44bd0addb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "12168702864f57ffdd8234a4d2b163e5e010bbe1f8049e08bb59e834dc04ac057a6cbfbfcea30fd93c7313193af0f017989b872f1159b5eb7c331571b10089a1f8ac3fd68626af7cd615d7bbccc7a47a0c325a20804a8c3c0bbba23d139506ca61d52a651a79133c2c3b1fd1b54f3f96791c6923025d7a2ade36c4b3efaca78fdad3185437ad7a41e42ff53f6096419b5fd3bdaf2d292175aed4d067c85c7f9257a91a319e9ed29cd4d5c728a11032f0b355f31dc3a9e030d4cafd98b7e99381"),
	})
}

func (s *drbgSuite) TestHash48_SHA384_5(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "97f4d4103ba98184ae39a50470843b72d11f815a1563ff06fb8d7e5518a180d2"),
		nonce:           decodeHexString(c, "d9b5a03e919666d1290fc42abde8f075"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "85b668b85d7f329e940c3f45fb0ea192c0d44f4d3a983af4685045f8bd23810e6c79644bde6870e83691392816dfecfbfb3e73434381c834d5a3a801109572f3a720d082866d8dd8845e4a11e4ff8542b26afe2ae78d5debc37c81295f89b1f1066d0d17af8795b011e854aa7f511285686db7b8dba0020cf62f9f33a141faa39ac5c6b62ec4a7353bf47d25d71facc5ed566cc3a83f52a5f03c1be283daa1edfeac3c2562a2c96931f5e833839502701389a934460550665e5fe0ac498e4148"),
	})
}

func (s *drbgSuite) TestHash48_SHA384_6(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "72415fe7e91b29586157394464b95153664a3c44e3744d523e875cffa477e1d0"),
		nonce:           decodeHexString(c, "e189caf1cd88569844a8eb1ac41fbccb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f5316b3a02e9e4cc1aa16c1f686109122f2b3eb0e098233e1e2600913815075d922d038a57d9294cd7ccb7e888f7c186cad94228d62f33795878801362ae194cafddf39a2ef565378009f14b7fc5a17ef274dbf537d931dd3ff2563cbd01193ac77404b7c01f204a3ab63622c86ebf00ec5ccdf72f82b8c0bf75fd2385536ff4f73250a987fd557b52db57c4c4d7d110cd118d6df6b3b8579acd36382fbd8bf3ce84f0df2761717c8d2f9f199cbb67847bf6921e648873065c727cf7a4acb693"),
	})
}

func (s *drbgSuite) TestHash48_SHA384_7(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1fa6bd2bddc62da7be0ccc4b42fdb0607d9004dfd64bc588d7e35d74b17138f7"),
		nonce:           decodeHexString(c, "49a6f6162647c60f8043fe6b2321bb75"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5aedbc8507377df3b171fa7665f12fcc76f5078a55ea0699323d67a1d6b22ace8023e20d00c57c707172bdb6d6989f03ed0c80a3098e07ee0c8974edd7b95205b01dd5fe41b4ef52a55fc947429381a91cafa8e8e0327a94846a21973da06d97d6ec271d1761f3d98319fd1067305d83a70cf61be3891309e1c8f4c60311492fd80177dd40040f6e4575132bc2e57cec17ecd849daef92b4f359689a70dac01d1a66248256c0dc9413256c70612356669ac12da3a41f5f66e3026af6bbaa0097"),
	})
}

func (s *drbgSuite) TestHash48_SHA384_8(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b5065f850e8cf5dd50cce69848431785493a0aef850d46f5fd5588432cbbd0a3"),
		nonce:           decodeHexString(c, "750aa066e5cb008037f9c0787024102d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f481d7bb452b065ca03b142ef53352ae8685acd6983566e9f8bb5a9bd4aca77476eb8f4ea85cadd7b4cf653058926311a49d160e9f1e70936543a6865f793333c7342f379e261e63b2c5c4d2ff0d3a80809074de2c3ae240b0214738476080ec0edda729a0235e561894cf09f3a8d7fb542471e293147a7dcd8085e80e3d7295436002c8870ac2bd3bd6a8197a1e8fbbc438d5b56ec8809941fc98393a9510c8f2330f2e724477ce117d499fe94d20f81a9dcdd062379adf101a07b32a4f42a6"),
	})
}

func (s *drbgSuite) TestHash48_SHA384_9(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "bc3c1154386f35b46813087587635c870eb94bb8f7e3d4fde740c05fb45fa8e8"),
		nonce:           decodeHexString(c, "c78502e2d0dc1f2c571dd7d2980ba9a8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ff7e33d7811a78e24a9d0d928619f4e0272cb0635e32e4919a55130aa1182019b713e54a5cc20fdb9b6f4233399db5d5311530503a82c6708600ac6fd3a69f01a0345e012e54002b6c9057b8d404d4e031e52965f4599c1aa65934a8453dd5f23bb158cc79cf6450c5024205eadf94ade87775f97526605b994c5a4208b6028d94a777ec909362eea4135d1dc6a8ea69196327ceadc8460ca134c54a377a373d641c97842606856bf8ea2038066705696ef61a2cdbe3dd355e14450a6e35360d"),
	})
}

func (s *drbgSuite) TestHash48_SHA384_10(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1ff952239e146246fd4690675930aef07de1ad5bc8005c312b329be044a41fcf"),
		nonce:           decodeHexString(c, "03bbfc86b7997955e2bcbde229050589"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "03c0613f0563a15efeb8aa262150f024e55fc0bf887266f2d283741c1f70991106cef811af091cb8e7b6af56d1c1965700d4d5e33c2536ed20f1bb782901cebcc56226e8dad0194c816980dffdd29ab28fdb3f6dd9b1594b5f904e8978d100192ebb627dbb99a9a3fda6bfaaaac69d6c27a17ed4d262a641a0ffad042ceb4123b7505afe32567b544fe4154e3bc805d171cd707da2916b0647487b18c0f2782c2a6c1c187d809dc5124f5af19fe6effd01e0b507f5adb65d5a4eeade5e6fcf23"),
	})
}

func (s *drbgSuite) TestHash48_SHA384_11(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "57f2c0ad254729619876820e3844bff93b2958b100a6d825a65088c1eda38650"),
		nonce:           decodeHexString(c, "b6a49e7c0822ce5b7e9c7155163cc5c9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0988429e260a33fe96f6151378effca8fb70d87744afb067264ea67717c5a55bb8ca7a02aff494eb3b64f90499f1ea75bd94a100e241be77ac81dd615b9a7e128bb4bd4093b0d82e3051ae36319df64b907523425acda58a2cea448c75f3f955c485a0955bdaa122001dcfe898cea2ee641bd3b92b98d203b0fb30b0798eb482c164305280d6559fb4947363e2d247fb7a74e63bb8f72a6019f32bc445760022f51d71313a974faabd6856deca0e5a465a00fb48583ac59c785e21e318adf36e"),
	})
}

func (s *drbgSuite) TestHash48_SHA384_12(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3f43daa8ce5c8bc35dfcb7e1cefe5956cbf4c3f37a4aefc4547eb58502390d12"),
		nonce:           decodeHexString(c, "0b66b696c61848e76bbbb50b875aff0f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6160184556703fa73f49098c9db27d2fcd1ce717fb2cc537c205c5da96b9c346db63225c83d35c7ba3ba248d068eeb5e266dfdc9a95814d2637b6ed7af6fbc3f6caf21d210ed7ab71b48275321e3145efa9cb54ef5e37989bd6762dd412b55403f2da6f6a9deba87d90c01f5cdb4beb118e191753c19d5df7e3aa117bf6ba623125ef5565eb60d2d0b17fdc154579b71842941316104d3414743e484957e41a8fb3e697bb7ecaf6409f895e144d36a6fc204520c6d3b5216aefa31f101977cac"),
	})
}

func (s *drbgSuite) TestHash48_SHA384_13(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "e0ec2dae2f4ebcb630ae1ff2f52bc119a60f39fa233379df4d7d6ac3d9650bff"),
		nonce:           decodeHexString(c, "bad9acaf0c5b0854005501457c6fc470"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dba059ecbdbd45c9712fb704b063a624e883f6619b5e55831a172ce5797a78bb72c236a968437524b1008fc82202deab247015bd2adac38803fa38204a2f3595e14d8e39c19c1d6e64001a9f64761c1eb4fd874edf3b1f138f7249a9da5b74deffa8d17627348b9dab419a59f5d3c7464f7b9826aeee32de66c905082784ed39b34e7d3be4b03d7c211aef6e22b07ee73b11c4034e01d2e64a3555a7e1d844170a79a82667163c6a4334bc5c561b73d4a1620235a49e0d6de64ee61d0f978875"),
	})
}

func (s *drbgSuite) TestHash48_SHA384_14(c *C) {
	s.testHash48_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c0509068d88167921812103b67e734698d68718ecf42cd99e0f55836c162d450"),
		nonce:           decodeHexString(c, "71a50d2db258ea35ba69b5716bf68a14"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f66c05713ebe804b4273103997d260adbe8a7d0f6b2bb862b867ca59874ab9e0898102664af2a8db24a7ccb4637269ac67d5e834941303acab9076ebfa04cef64f73480afb6808f11e6ab1a9deae514f5db1c90c59ce988cc1d04012640a40173362de2689f88647268c665ca44f57534c9ad9b8316b9cd1d5a14942e94e90607acf6ad37a2398979e56e9c227c1803f90844d6140f10d0baf20dd789d808a647b4df54d2136d967461383dd4db9dc154dd89cd282a2766dd6086bf3825d095c"),
	})
}

func (s *drbgSuite) testHash50_SHA384(c *C, data *testData) {
	s.testHash(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHash50_SHA384_0(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d1b31487d6de11389313b9fcb6d47a80068e27e7dd4f5d19bcdbb5ba7737e433"),
		nonce:           decodeHexString(c, "97c18a1c1bd7ef912be91521be7309dd"),
		personalization: decodeHexString(c, "a7a2a558852c4b63be3502e8e636ee918d6d4689a647c91d50e3bf0b219f71ce"),
		expected:        decodeHexString(c, "e28462f6504456bfb2e6b96dd6a6a4d07feecb3eeb2ae93f6f12e0edc476caa9407d0ea113553038ee14077d368a589a20328a9ca3900c5b7b55fcbbfee5955e66aab957ecda339bc06372e152f7a150069404c20ac3829ac83559eec8c47e4cd297d091611b9c836d143c228726a8a9db34183c5a88ce18ea0f26c0aa166aa3f0d20e2612217d6d1088b28e09e4560970206a381bfcb1fcb2d623b0adc6e4090b3f85631281a37e755cb8b0f03eb9e0b6436034885919933d24cf8987b03d1c"),
	})
}

func (s *drbgSuite) TestHash50_SHA384_1(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6ad32284947f5537ff84e54fb0b1a06565aa3ad9a0631bd92b6134896a867e38"),
		nonce:           decodeHexString(c, "b425d4cb33cb9b2f164b18a1858fa26e"),
		personalization: decodeHexString(c, "ffd4a433802560050af263470dfd4f3d21420e3cdbae3b0dfab206a6ca477006"),
		expected:        decodeHexString(c, "103adeafbea45fc3803e0632e8c1168d6a573126324a1d8805d225445f3de561215cebf6535edfc209ca34abb11b3e52de76a89aa4f83f6a3f6926e4bbf57d727312951e1d6ba41be3779cb868d954205f1806e230a77d5ae670008cfcb19f086ee704ced10a6441b887f155a7f0e67b6fad397668d5e35ed418110c56c1bf48264e5f3eeb0cfb2e3d95c6dff07edf106643867207d26a6faabc230fc871313240eede78b66019a039b9671f634908be7998c8122c63c92abaaf04c60cd56bdf"),
	})
}

func (s *drbgSuite) TestHash50_SHA384_2(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "20f05b7de796da9c719b1ca95aaec82bcde16d4d6a12cbf838217dc35e64cd6f"),
		nonce:           decodeHexString(c, "b4bc248b81ecf604c46217a1f4c885a3"),
		personalization: decodeHexString(c, "5565ef9e4917df80bef6ec0e0f640c9c74cd196701382e3b4ab51abc4c4c0514"),
		expected:        decodeHexString(c, "07d464b783cc66f8333b800c0d0962d965fc0380c7fa013334a95bd5c43731493202aceadccf13b954548fc2962343ef5d0cf5b53811a13aed0edba9f89edfdb2f138d299b559cfa0447c57e8a68da97af4d04ec55f5195f3e4a0f62a54ca5ed2540d0c9440444908bb9417a60bdd946c409003a7890782c28524a4a1a3f7ae129b4c84282891ccd6726a7c8b87e94bc61680d8d147c3c753081aafb529308b1efef3ac701409767eaf17a7f4b08fcf31697728ecaf5dd9d797e3389323d4a4a"),
	})
}

func (s *drbgSuite) TestHash50_SHA384_3(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "46e4ae18d4b4b0820eb45c0993e1da164544574eb0253d17c1e8b5b7ff172bec"),
		nonce:           decodeHexString(c, "ddab598c043ee6e39c2407c2d8ca5377"),
		personalization: decodeHexString(c, "e6fe2a7c315e586d3ea7cfe9e33003c8808373c82648849132a9b603169fee45"),
		expected:        decodeHexString(c, "a37393f43d3fa32cdaafbc30f2e28efcc0c099a429b49fd9e89e17367a45f0bd818dba8aa5e87e1b9b04f298253c5424628612a86646b27b4a763bc63e79d8bc9b27f84244dc8e5354f742b27563b14f3ab35abb8fbbff748788847c67042e09cede1e07ad03440b0d4711ba762a5ca7954d31ddaab26fc57ef07db7a3a4af18e9416c31e9a205651a669ca105035b5e35f54bd129eb766b7fa98b9dc9e543b2b5aa6598635351e3fd279c4970cdc639eade7bb302d1d6514614fdd1c65a517c"),
	})
}

func (s *drbgSuite) TestHash50_SHA384_4(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "2311845ad0e4bd78126d71360e01a8b15b032607f008e8c35a6cdd6d145993c5"),
		nonce:           decodeHexString(c, "4ad8c6d9fbabf571ec4561c2aefa8202"),
		personalization: decodeHexString(c, "8d3f2aa391a053b6855766742914bf04067369e03414e3d68439e07f4e7ee26b"),
		expected:        decodeHexString(c, "356fd204d7124d3eb0794f4563218446d1c781106d4da8d7763f1c849743ebbf5d01234b5f1ae93338616b9c581356cb2ff46299a8a5f4558e3cc53f631b340bd7af7a86337e4cab890c55c1a3c97e92a1ce15ce6aa2e32daf6d8c00f33b8abf1c05affacfe492d8ec9165390ccd264763ba3479ad83371befce8b40e36d0a8daae47c4f65963ba01aec198478cc99e7036491121b684aaad6b24d44ad2824c7a0175f0e8f5f86c04018aeec6751b0f0db07f8d75a9e30407d9afd573d8d4c90"),
	})
}

func (s *drbgSuite) TestHash50_SHA384_5(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "7f8e103246a2b0f2849410ccb45a82214d1aae70a31ec2e830bea88763a864f4"),
		nonce:           decodeHexString(c, "4d7799fcec689da7b9ac2de78b9ce699"),
		personalization: decodeHexString(c, "34103f676b7c6bee8916bdfc5a74fa5d3bd5a7844176978d4d0cca1d77bac99e"),
		expected:        decodeHexString(c, "cab956dfef85d06c81e7da03fc40e043263fe212d78ae13bfb487dec6488b584b575868b607b252ee5c27af701f1b670152879bd413c46b47cba2bc37d8d9a51b71dca801bb2f79c12cba61674db0a22817035e74403d85b9f8ff751d86d1ba0ddacf969ad12009370237078719c56e17489505bbf5382793268b75344dcce85b53882c0c7d47f671f6fbaa811add4b461dc73daf17c6ee58854035cee29dcc49526b603b7c8f95d54517113b4b506dd716ced88e93c9cc20cb702206a769792"),
	})
}

func (s *drbgSuite) TestHash50_SHA384_6(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8806cd8adc9560774806f3743bcff600bade3e4f83a894c4a3040493e41d9b50"),
		nonce:           decodeHexString(c, "d53ef5a1e8dc12be1ace6fd4e57ee0ab"),
		personalization: decodeHexString(c, "a1491b48414f827d5c98ae16f301e12dc73c4dead9e6c7c0d7196431c3ae518b"),
		expected:        decodeHexString(c, "2785f18188143fb138091b1e4e87753d647d549b9c35b786eb6aa6f760173a872a18e883c4139b1e906852bf6eb0f036c302726cc34c562debb13dc908f52ca7bef533b591604964a34a802218b940434584da29efba25d76d12b06216aa1dc41f03281ceee0ee8431c14a7f2205e4b6712d090404a06b7607c7a2b2f83a0106c05aba701f1992611e90cf5727176d87a42c1775acb90d643c4f37a0a9af55c8426686019b0a9f6383dfcc70c6a7f68afe7cdc4d4de84c756b53003cde73dda0"),
	})
}

func (s *drbgSuite) TestHash50_SHA384_7(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "edd1eb05c38dc7c1277ad85ea3099571b53514768ee71ad63259d10d58b28d5a"),
		nonce:           decodeHexString(c, "2fc0c76a3d624967c69bd2047a6c2961"),
		personalization: decodeHexString(c, "c73ed0a632db7a800d0cf2d309298685ae3bc82ffc6e32fa4af44315e2979779"),
		expected:        decodeHexString(c, "7d76f8730148d8257000a841227cb9f264ace803a580683858033fce9284f958380f416e0bcf72ab4966d74e2984f4f7944e4d72ba59d54fc8e84480487719d7c85c68f51f7119934d70d35f372e1c410390f7613e101cf1dcd5d748d9254fda42c073d46c8e834daf8b898bd53bbd8a99a6206fad1715931ad0de7f04743cb776f9c22db58acb21da72ef046cc9040c36f178c098ad60ac62e372b40c9dd6c781169863831c1608fe170ac4729913461a4ce7cd5f98710b1850497fc59b4620"),
	})
}

func (s *drbgSuite) TestHash50_SHA384_8(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c70c64e47c76f021327116f283f1b8027d95ad71e927f1b3ff56094890befd1a"),
		nonce:           decodeHexString(c, "5f15c6adabfb9b9e715e58b4e531460b"),
		personalization: decodeHexString(c, "49e5e6186ed6d33611c300942e10797fb106fe057beb87206cad1f5e91e7970f"),
		expected:        decodeHexString(c, "0f4f6ed160d861bfc9636d13e756d508314f7a94adf247f73bd6b35fee25473d7cd8e7f970e1e1b74c1dc4bde70cce4bc10ea2bb9c3ad35133f820478d3b1010f314219cce19f1849dab890dbe2f22280eb0769c41f2e8326cb698fff45559b4b1c05fac2f5c1da8347659750388810f93ff6111a2e2b24e59c2b2930fd3d49b17d095ded0a8028e142be72edd9d60f17cb87c0cd3b600710779ff1695b9a366104e8a3844731ba3e995d6dd9de0eec34adb06c0ef5f197d23004e5edd514f5b"),
	})
}

func (s *drbgSuite) TestHash50_SHA384_9(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "920167ac2f1e7875430f6ede151e6e1ef55e021816713d8f507d293755298b61"),
		nonce:           decodeHexString(c, "8923f7863865bc27e20525ef13f712c3"),
		personalization: decodeHexString(c, "31be01d9533aa6d5731cf0ed3ba80cf47e232ae931a6e24f0dbc0140cf83c723"),
		expected:        decodeHexString(c, "b20569b73ac501e1c17ff898d676a658e96bb0d3a69b9d62e0f11a50b04cf018bdf610a8d2efb5322ed23c4644ecf683a971e52cadb318523bb9680f6e6209ec6f1e68962fb3691207898cf60ab2fb423eaed082a5686a78ef00e2a9bbde6c4ac48506d78393a2914d00db2e3cf0b293362c54dfe78e123ed8439f37a93ffeda9a96aa1de1e9323072579fcb289a726a4b66c8e69a541c458d263fc9767655c3c5ec0b687f9e5b0878458f07c255ef709025225d30fd4f54bffd942fced1ac10"),
	})
}

func (s *drbgSuite) TestHash50_SHA384_10(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5d7a94bddbdfc566f019d5df9f2bb6004d17bfd17f78ef55b0707200d1a5cb2b"),
		nonce:           decodeHexString(c, "b32410dd50ff9be1c397267d292fbc51"),
		personalization: decodeHexString(c, "6432eee53cc19589f1502d86f51faddd59b800e973c860c4ca251d86c84d54b0"),
		expected:        decodeHexString(c, "4639b0a8e9f1da8dc49b0d84701712a3d0f47bb98d57803df7d4f7b0aabf99af7dc78d38dcadbefc2e570c2c7c51c2cbb37d50070c6b6857ad75b605ea006d29737d6819cfbfa4824088c70eb51777fc7ff884613d2a9f7989ea75e3bdd51e0ac3139faa934bb9ef6d8a0b25035fee2acf2ef783538e7be8e4416430dd058a58c712a41ed6051b283aff5e644b9cdb89433a414b5fe5f1dc172040bacf145d8ee19cc75cb6c2aceda689d3226c9039e95669e11dd4085ea104444c0bc4e9af3a"),
	})
}

func (s *drbgSuite) TestHash50_SHA384_11(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "bdaa691810d9aae1175a5a4f90505efe05b3cfc57d4497e7bfbe31227a6b7b33"),
		nonce:           decodeHexString(c, "14d732ea6bfc01fa7d6b865c9b764964"),
		personalization: decodeHexString(c, "fa1cad909364487bb524391afef23df89abe9f5a830ab86e1989ed44a02a1b0d"),
		expected:        decodeHexString(c, "57de79efc2ebf40829ca43a8e2e0c9bc402c3dc0f12fe27fe49aae94f9ffe31cafe897ec47b95fa2541036c5db941dfcbcf17f7d0c10c492189cf7c12bf03e8fc9334df9dd6484657638f8faa697db696480ffba3447f333fa6d3b8d71df9a4404e9671f6415f9701bb73b23accf5bf4ffc3ef8c04db8784067fffccb8adca7704c6c8a7392ad3ffc278707527ccfb670f5d2ea8a914b369b18419bfce64f605a48fb7b3c6f0bf68207fc601bfbc75c5d58094b9bfffdac5225a8e55a5a28411"),
	})
}

func (s *drbgSuite) TestHash50_SHA384_12(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "472b189a407b5b8ba02b893f74201a93c6d432e3593126d3c6e0d8f44d445d4c"),
		nonce:           decodeHexString(c, "3f9332a1d6531aa582eabe1c0de0836a"),
		personalization: decodeHexString(c, "78f2eb71d0310d05b547fba63e57fd66bdbb705c9d9bd0aa957b8439e616f078"),
		expected:        decodeHexString(c, "f52fadf02cc573205fd654284387219c83ff8636997392397fa45544b4da3e757cdbdf1b58cddce1c418b24c8c89454244132acaf1e53f472713a925102d2e313eb850e4cbff7b282c6eb1b959643cb1f72e76dd12a6c8aef62b56773e7dba3a43f67cee488d4f608f8124b9629963b19983876e099bf1e5b8de90d651a3a001eb7234a96bc7a7d0d4d9d07e2bab8a841b44a6215752b9a8625c2490ec8cd8542a22f62f24a3d1f6682272002f78cd96d4ba1d5edba25ac616b33f9e6c95c589"),
	})
}

func (s *drbgSuite) TestHash50_SHA384_13(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "7f254388dc53c8011d891b24d4fd310f579cf4cf390212dd375bcb5eea787924"),
		nonce:           decodeHexString(c, "c7155c12d487753b7a3b25a23b6c208f"),
		personalization: decodeHexString(c, "522744097cee423dd9af5ed4e939eeee69ccb888f3b9d41049946085533f7cde"),
		expected:        decodeHexString(c, "332a6c0a3cf911342c54a6e9acd59d76a5b1175268208a45be86f265d7719220b2a73151bce99d83657303e9c010cf083f9bffbac065adde660a896548e7e443e219d6dfbadb57244b8718cd417ef01126c969f2219479e39694f67c310c785b6af9cc4ff8ecc9bf74244c97b91be77cc2812c897fd110d120da3d4ff8d1bc18381ec1daf3f1d434853c8852303790cb11aab0847b578d1b33be0d4ad1e0def891f883dc6cb5efb9a7cf9735bdf58d666b4c55abcfe342856d43afc019f092c1"),
	})
}

func (s *drbgSuite) TestHash50_SHA384_14(c *C) {
	s.testHash50_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f43136a4ebdb1cf771055e2df4fd26f5a83beead0d407e3137ec35cd95668e73"),
		nonce:           decodeHexString(c, "aadd62dbd7b34bf2021ea74a2788b17b"),
		personalization: decodeHexString(c, "cc3308e380672a955620fba59999ec4fcabf1b7f63089a124cc1f65d58b691e3"),
		expected:        decodeHexString(c, "6c39f49bb51765dbae1de8325e7a6f8f8aec031dbdd94b83d5c4e062848eb4e01e3912784f817ee16f9c2dd0129eacd3f7b8d5bb4cf9a4a2ef823b0505c2ac8e4a1ec30812e98564aebaec14ff710a77c1904ab1fa3fef3c3d09f2d55b047a8db860322fab6d939093385838ec6d11667ca843f69268ba1fb7edc462fcc285adc9b4b97f0f717c28ac1b6f371d90baa86e8728051dfe9b68f15dd31a6da35194253545a5d667df6a1322f6b73ba661c7407608fa42e1b894bd1b6e7641749977"),
	})
}

func (s *drbgSuite) testHash52_SHA384(c *C, data *testData) {
	s.testHash(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHash52_SHA384_0(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d6e0c22a71a37faf7f8cb744370a51b66fe2c89b42d50de1f8022fb32f96e483"),
		nonce:           decodeHexString(c, "e755e976530fd24517fd4bbbc890ceec"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "16372a83494157b62c4941864831dbd05d46224240e821a87f66f530ef89bd4087f2a50d2399d109303f03821ae62d6566163bfa94a23b64198f9b4dc1db5aa924ea06841509bc3258007834b44f3be34a7f9c7125af1794945bbfa78e02a87c15101bc3a079f932c4691f1e5e1b9639ea74af07c7f026da30712fb4f9f9de6947a27b71d7995a494d83b480a284db2d287e75bc9a813241ea1d480a0a44033663bed21adbbfe89fb2d27cbb35ce878bb4883399602519b387bdaef42a1f2ecf"),
	})
}

func (s *drbgSuite) TestHash52_SHA384_1(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "7d2e345d75538d97f3ecc1aa8083028cdd0fcf8418eae999c53f74e5c440cc0f"),
		nonce:           decodeHexString(c, "9f103a26cec74bf2a128fbe921e435ba"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6cf2c0dc869761d64600d643dd5ef745af81b4b4c6efa431a2f2e4d63f362447e64a405604a1e598674c0bb1524797d42ef08609b7ed70feddf4e09209b01e4a88c447ccbb8c2888e94fa99c2d47ee540d0e14430eca74e8b1cb95de9683886d7f01910633bc52dd38007deeeab8057d669de681adf2661dbc5c89c3703abe3aa948fd970aef87b69ac88d6fe92e4380873bf380ebcd3d8552501900e60a4bea791bc66043e1415f93abdc06d512a4d890f9465eb5b235dcb34ecf976093e634"),
	})
}

func (s *drbgSuite) TestHash52_SHA384_2(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8bb875478eb91d564fbcfffe66fc6c20f6511898ea00bb830042d78ce633e0ac"),
		nonce:           decodeHexString(c, "04729420a565164a204ec7a38f16ab12"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "41e6abd28b73f030a3e48652d149e619e73898ecdad64691e0e683bd9088e7c3203bc46a49a23b5ded69e35d4d1a8f910f9fdbf80028c101eff30cfbf40ac1328a97a90bb31aae52383617b556217ec28a84ba3ee538ae81336fdc969ca7d50b1835d013671a5872c84dbdcfeafede20682f6f3dbabb66ef13e3585978a82a578e6de52fb940ca9b53003a40c15af2467b02de84882506afe2f40fee47cc5469caacd47b7b4456ab432d922320f320a02ec18e4b11a264219dc8c3ba0e9288cf"),
	})
}

func (s *drbgSuite) TestHash52_SHA384_3(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3a612d8a0b7cfedd97b4f703428d763ee29ea921078a17cc3e48aa458934909a"),
		nonce:           decodeHexString(c, "3c7ce412400fff61d0eff60dd832b0ec"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "805d75ea3dc1043883bbe6f35a269342ef16135a4a38caaa9e6ab270bdaf76b5c2ada5852c083e1446c5e52ea0060cbd29223ae6f66643f5a20763a265252aa71bee6bec068f9b74a128e70dcf5d8ca5b1a4250d6545c5191db80097f50a3050e992dd29bda521dd226f4a9f57c888b616671d9892535f647c34ad51d089bd5c0766c9ec4f8557640245937bb63f030e8e9aecd718357b34235710c7741bd2531ddc06a3d2fa27f47e8cfecb5cfc226fea92df329e6c0a64072711ea21026067"),
	})
}

func (s *drbgSuite) TestHash52_SHA384_4(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "4dcef4b9b65c0bc00e19f802488d9cddc9e81f1b037325f3e3bf06d0ed003430"),
		nonce:           decodeHexString(c, "4e2f76d7fda5c7b10157569152d9d807"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ca3bd705171d8aeeb8ac1b6d2bf44fbf3429ad01f665be63be51607178b239409882b762113b9c927a01bd727bc12d8e60635c4b81bfed9b551647dc98070de799cae9b2b1c124d3e9a23f4ce39e83b76566ef2b752c6d7f9d68c1dcae984cbb1166605e19319046e19750e7f2810e60152ee5854d775df557b699f0b5c082b619df57244d865daaeadb113bf5e810c967512f5902e5b645ef5daf349e548b8647832008ad4770a8d59f327550e2c137e6d51288db79e7c2cec28e9c3a2c23be"),
	})
}

func (s *drbgSuite) TestHash52_SHA384_5(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "68c0ed82a8f7d6cae4e8cc561b68494007c97ba71a7b8db070f6ea70efde8ff2"),
		nonce:           decodeHexString(c, "43a5e1a85c58613ad2e5864f471a8ca1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "55a4ce97d98c266bfb6de5e5d309e95d10ef5e0b37d581b16f8bd8b973e91d9288b17ec45d7b12872fcceeefbd9128b3395f9238fa8726eeed2a8144571a64728b6f8f79dbb926c7e638f753453493672a2da55e7fe819525ba7672ab4b74220c3cf80c7001fd8969bef48e2f3f3d4af8d9839b688172a8a672ba6ad9c356f2d185ea0ee180857b0f2f12d729f2dff8ec907231f8082d0f0b37b4a25ede5ee53bdf2925df51226b5b2b1fa10f7cea53996572a9ae8615617de53428516a63d8c"),
	})
}

func (s *drbgSuite) TestHash52_SHA384_6(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c6acc1d7e37b5c60eeb5cfcecb59ac587e63089fa00735a3b6aace2c1c8e068a"),
		nonce:           decodeHexString(c, "a6129d1e7b6522735859e952c20f3d65"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a3679089cdada405d4ba1ab74ee6bf62780ac5f35259064c17d9429258dde96a5249c4656b25df32f3b263d33897f1b770a8248eaa3317fb2ba506c2a127c878762c0f14b25a0575fba8f2f38824213c62fe753e0ab1682cb5f63b2d0b1b9e2b13bf5039f54b15265d2d3b06e64aa3ab777742e746c944666b9ae1079c820575b7fd44e69e89fd89feb24ba911738a1d4e88c8ba7b1bbe144ed92382d0f46cf5ba743ce78908c61de2ee14fa077c5aad9f74e879a200159b21f5c1442226df6f"),
	})
}

func (s *drbgSuite) TestHash52_SHA384_7(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c0a1360bca46d67702442ce5f87f902469c7bd73c4ff66e0683d523e139bde38"),
		nonce:           decodeHexString(c, "0d582cd3341b9989b6368e434765ab41"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5b008b5596c448d003fbe0f603cc322e4fc482680d9fa05719d39ab120a2eef03879afc3be01005f00ef1d2d44583b2a882305589dc854bf1a718689094ea9ef52bf6065b593b35eb7252cc9543bb64326e49b56b993e8ca5881936a87395bde6781e3db6d491cda72d1240b5ca30b3796394cb170b25a07a5a7c2b78f4c133009d19b95a910f025fe5940e1bcab86a9401b58c748af5d3bfdd632fbd3d992cbe3cd3be326532f4c0c49620199f860f92d8b3de61f671288c2c3a1c6dbe3c663"),
	})
}

func (s *drbgSuite) TestHash52_SHA384_8(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8b6d99b6135b7ec97a4f3c360c9946761f66307bc8b975a7efea3fab625e34b8"),
		nonce:           decodeHexString(c, "00c7703abfe7768fba80a98e7e5914e6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "fb5b0e2d676407ecab27604ca92e2dc8d4e1bc65813abe801952acf0841b3c588ab87a0ceca68d5e402c6b8e029ee6b6181568a99c247e2fae1f65726e4992c52ff22191ea50e2d72017eda7f0a2c9be4537513d9243be6d2af9b8f0d12e6bf93054ac34c448c9fd85e0e0d86f83fdb794721662eec37673714cfa7e10daf1f939dd8af9c2bf43e5a9d423f68e16a7ad4458a6ccaa39564bc3e3822a6acd1141ce1c6fa8029f7f752702b6e3f9e565864e99fc088646c4c893b37062d2e40136"),
	})
}

func (s *drbgSuite) TestHash52_SHA384_9(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "eba5c7d36e345db4720d4b4911ee8918e6c87bf7a119e157b4a2984f3ec8acdd"),
		nonce:           decodeHexString(c, "32663a93c5cf65c628be04e578b5d037"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b23cf638f7245e309330a4743ce70f991b8ee317fda128dcebb3ce9e320be53fa89376b9842b8265ee0989993306aab234bd8912adcee5e0c25b5302fc52a06d19caa705825d414e9c456ef1d6585f530ccd2dc51659f3b1549efdd5debad83ca48bf55ef989aa362613691ee321667f5e480cedbd8376f033eb0250b6de795281e7d08f79a92e74f5063770937f4998cb27bffd86a6891298729a99a566bf63f80b5fb1582db22abffbe0e14606fafedf5546c2fc2cbb24e0f97432c3104716"),
	})
}

func (s *drbgSuite) TestHash52_SHA384_10(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9594c8a4bddd9b3f31f915001691f189cd877cf75c637e322ea28e0fe749dbad"),
		nonce:           decodeHexString(c, "65fa788422a6bffdb3c078f8fa210811"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3a8e824da1646ecea7dca609165d9d5a0de86e635dc3e15def45437e6d486ee65f232179a7320b57a0c2556c0b3f2dd61d1788c40c893c01bd3407de2db57aa247fda07bf9f31dab68e906dea52853d5fa21bf33445348f4f1017c04f1c2b19292f6e60969242640b1fceb39cc86a86b36ff261c242f791108f8a62dcc2a641375370add670170d25614e7ace84c456a03a189164e93bd3b9f770dda15f9dc80f3e03ffe4e28b3b9f3622789d50d789903d0d69deeee07d9946732911fb4bf47"),
	})
}

func (s *drbgSuite) TestHash52_SHA384_11(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "e74104e5509896eb533e308c16dcbfca3676ce05dda54ccd729bf816d766cc4e"),
		nonce:           decodeHexString(c, "718e3b194e34782f288eccb8557820a4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "320f8c6e6c744ab73dd0d3aef9cd4bcea31a68aa76f8426a08cb78846674ea20db0ec1f8e4f581ac1b8032b6552b32a6eef95f8a80d738032354776f590d642676078a0e51277040249ab50e94ab11fbab1ef049f7ee5a156c2f220aa97af300cf8cc50e774e54c5da30dd42102916c47d00f465045cfa97e01e31c266347496214758c5eb76c31ac0008027521e0341c751be8ff9ab7b4113127076ec746425d1f1c4d1f541713efc8c85ee29428316e69a4f7face139b372ee040d53178891"),
	})
}

func (s *drbgSuite) TestHash52_SHA384_12(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "565886b248aec5fa1f84ae53bb59c23ee62e944a3e6fbef5020df88fca96a5b2"),
		nonce:           decodeHexString(c, "43f4f2ac29055c105622c341abf7159e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "287ec9bfc3d229745529a68c8cd0b090298613ac2502a5f2ddc8902686a6cb367e2f3d2af3224acfa6f162464ffc670300cfe982cab3c236e8bdb0e3dc42f0e764004b6d2d26053912f9a80869dc012822ec3da13ffc611805100f4cfff1579e9ee8e6d9235fe8b272a2c0ba2428a4e7a974dfbb107c51643da50c6890e49ff5384668820ff8f330b42f6da796c47b2e113c4fe9136f4adfec36e063999a7a319a138c70d9c610f2b7625e0c1d13686152efe779ceabb4e1afe13ce464f6800d"),
	})
}

func (s *drbgSuite) TestHash52_SHA384_13(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "20d35d6b462d216df8636a0843199a237036d645c6443ee404916205b34a8bc2"),
		nonce:           decodeHexString(c, "052f65db73c9f250c315a26a1b5ac123"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5127e4982babb89f73c65c9c0c09e36071a8f59395af06d569ac8487aab7de071c7b5c620f6d74debbeba1bac7c7a692d99ca2357e8efe8fab61531f6a3932f7f7c57e8f184cf957dfedf0aaf0b0b138acc47b0cc697337a704785b8288d594a2d1618f74ed8d27b9be60168413edbb0e68c2130605f3a373e345eb1413decef8af2ce05cb641c2052098787596a81238948889f07c366b29d18a9055ae898957d86e380e53627859aa7df8cb16bab8ceaa914050ec467f14cf33b4811b53984"),
	})
}

func (s *drbgSuite) TestHash52_SHA384_14(c *C) {
	s.testHash52_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5b50064163ae6238f462461472ad2ac9acc300316e140abd9cd6edb87b8ffa09"),
		nonce:           decodeHexString(c, "581d145675384210801d9c75d4d19624"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "de0ace4f4a728c681a0b326298142fe79cbff2ce5230e6c1ca3e2808692d02e4845867763cb9e93acb983aa54659be6f9baf210048baf7ea4f062bd7e3d9a6d5e7dccf427422b9dd93d392ffc810dfe185bbee253c3208e22a83c9804501321c6cc0357d22859487a3eaba53444f4027843699d5a78214c431ea741bba73bd29550925443cfa5f494372bd0e482e3ab4eace1b60187b6db588c0d252c8da3e0d6dd3e475040817ca2c85b1149d8447a52c111f05d7c14a0f6b7b6ea4f60aed3e"),
	})
}

func (s *drbgSuite) testHash54_SHA384(c *C, data *testData) {
	s.testHash(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHash54_SHA384_0(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a591f47c35f3190df0dc5a050fd6688b46dd5ed8bd05b64e7d42715e47d601a8"),
		nonce:           decodeHexString(c, "274e2aa59f62afaa52ece2a08245e628"),
		personalization: decodeHexString(c, "801822d1fb033db1e122470d04cf21462cfbdfe98c0ef63dadac8aa12dc44f1c"),
		expected:        decodeHexString(c, "4d88a45ffad0f6982306f61e7f99ba170675cdd9abdec8e0e8a7378d849cebd37c632605a36bc1d54fa1c96897f043d7e54d9dd30769c939d65eccd09578cd60fcd340d02cd6388fa96e6243ba6fe1a26bed000c8ea7c3973ce74603c00335a182024dc22a02da4e364e76582902cfc314e6b501578b5d822cf14b6f4769d576dd64aa1c43c3a624d5227fe6bbc35b35d19bb34c22d0ccf025dfa19f9b5f8234bd9a852574f94b7d09b36fc541b72510b2a0ee4a429a82b4b00b42aeaecb527e"),
	})
}

func (s *drbgSuite) TestHash54_SHA384_1(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d5b431386e583e5068b10483cd96590325732b8a1632fb2a3255833cd0a81715"),
		nonce:           decodeHexString(c, "25eae1c35de2ed75ef0d3cc5fb1038e0"),
		personalization: decodeHexString(c, "644f86121ac6309069d35bdc7c69d40cb5cbbd30e853ff1d18dbf20bb057bf40"),
		expected:        decodeHexString(c, "061f8dd15ced1bd4644b765683d3264fccd5b31666e3973d8ad6aea95fb4fa9bc1760e69856e56529fd9ad17a86b0065bf436ed6ce668703d423185fa06a55bb1a450da95f9a9ddf454b02f2a8f00e3b302fd80b195b102136786610948a4a7f84be326f62e88d6ffab4b76b611bfed716340de11c64d6588a54bb8c016e8990be363ad582ac0d79cd071aa97f7d4c1aff94cc5496045f28afcd85ac22736bd521c5fd9ab0016be3d1d3f8f553fde82f0cc718d4d0d213262f71d99eabb36a47"),
	})
}

func (s *drbgSuite) TestHash54_SHA384_2(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1110ed21313ebfd146e3b6dd92bcaa35c2150c7c5d74bf1d0147ca4fea6dc15a"),
		nonce:           decodeHexString(c, "3067c7c896397f37336986a763e4984a"),
		personalization: decodeHexString(c, "e7a6a485a05e39d1214140bff403a779c39b60260f29f2d1c91df91554fcd340"),
		expected:        decodeHexString(c, "98a3abd3929f1962d024c93ba45e357d637d53697e43e3c662acf0446431ec4493e1da539532b5fa6bb4dcf5e80309a83e7d76ad917fed80b7cf62b52f25f14a2cae01749d7e28e4e6a5b65c2735474cf19c4d3e2b4c495586bca0c592ee11ebe3f1d4c7fac16e1f4474ff65d95fb45c919b77bae8f8b533358b5c1cc806b0a250053792238df745461513bda2186a274086f0115a3c63917a4c30fb345cf944ce749e0765ac3b163bb35ce1788b0e2724aba458f6082980263912d7ce8a455e"),
	})
}

func (s *drbgSuite) TestHash54_SHA384_3(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1e2380287dd296d984586d87e8558484c45d3dd626eea6a0beea898063aa3551"),
		nonce:           decodeHexString(c, "c2c10c2b5f33a915c1dbbdc91b5d2912"),
		personalization: decodeHexString(c, "07df0d10a9eee870cdaf53682adf44de9435d5cfec2591eeead2020314189765"),
		expected:        decodeHexString(c, "8bf2d1bd01506d78f79a8d08974bea54fff47169467e02fa7bdab00ce3150e4f216dc636a1e323e50446b6547044a5e1f727ab5badca1c0b3722ba4c26306f247507842c68f97d063a15e2268ce48a497aa891fed3c5437a9f1833fa064af4b3af8239608720623ad955f84219dcbfef6a6f9de46e591448fba67900f7fad9d684ccfc1cb78a8c93fab3c354ff5190ebff024ebec283a02295f123a9a24ba644c14422d829a9905ead3d9ceb66f42f48cca5a51dfd5368a5fbeccaf7dec5ff4b"),
	})
}

func (s *drbgSuite) TestHash54_SHA384_4(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3b31507e411888b65eb1d417c65db0422ab1b1d89686217dfc523699f9da757c"),
		nonce:           decodeHexString(c, "177ff5164eea1202ce6a19a2bf20bef4"),
		personalization: decodeHexString(c, "78c1e87ce1cacc654f7152d47e02b650b28d66a75f1d397e5e0832d13bc3163b"),
		expected:        decodeHexString(c, "f8df7f6c419e22ad6c87c46023b6fe190353f8eefe7cbc3dc3e203343134bf9fe963f2cfa029536bae9ff501018a39d5e962aca1c0f802e25bec0329af4806fcb76debb6734cefc25966cbb4b723d701ab17bcf227004a2bf907db1c1c3d9b39fd99a74497350cf4663ac19b712388625a45be24009afe54e8ff5952c7eb753da8a87dc00f7e8237a67332ae56848e825cb68f09e818399d5604e212fd72a7d5a698f902fadb1fa4464ed9c2b077c97f16f67cd54516ff29e043cf25f204ebea"),
	})
}

func (s *drbgSuite) TestHash54_SHA384_5(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "909ceb355e5651e5df02c2e28791cd01dd45f3a97d79ddec63be9dc8889f5582"),
		nonce:           decodeHexString(c, "0bfe518565ce04138328c9cd305143ab"),
		personalization: decodeHexString(c, "69b6f1b31726c9dffd667b080555fa57d2a76a4139683e712d4b883f8b4d9c7a"),
		expected:        decodeHexString(c, "a9482cf7d0d9de7b291f7368786e930146bc139c311eda6c51c2a8e47a64a3892d7166cc271eb3a3cdce9b640429675434236a14d19a985d8d4f0c690f8f39e31552a9e4577a93b1383ca345ed1c0259b72bd9ea6a61bc18682dcb9c59f97ce7841bf247127df75c6d246ec0b4dc1ff87f94b2d3aa922e5c2c6f0cb468c60bc538e3c7843cf79ba1c42d449d2a8db4c15ab386ce0816601120935f8122b31fad93e7429cb30fb00ba7dfd8f37b131b9b7ce648e5d4cc2b12bfad1483d918ef52"),
	})
}

func (s *drbgSuite) TestHash54_SHA384_6(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "daf64055f2f675748a46eba5cc3b87a9e0fefd092dd1385c628b5e58fd900911"),
		nonce:           decodeHexString(c, "7ea7b0b1839bd451a61d21258f67cf64"),
		personalization: decodeHexString(c, "6c81e5048cc7f4dd6119d2559b559c76ee664490fd2231eb6782722eaf547ef3"),
		expected:        decodeHexString(c, "38d0730d2ad1925e2bfb6880ed2e4a4b0a540696524fd75ad089cfa71ce5558e0d22b8b3eee6a1c3a80de84ab689e614f73b8e44862b46709553c02bd674b6915296fef49c01d7c6289345f212adcb69dd66d7e1b871ea31701f4ee618a722e00c441c271ac05d078bbe14c1d74c0589aec34b053ae0c53a06bfa9b1e5720b8b8a3c2a319961a3e439dfa74d48fe77e6df9e2594c8288d56a88dd1563397eca440656f5cb428a66a102bcc8fa8869d5f40d6df15b33ed6fc7b9335f7b8314c07"),
	})
}

func (s *drbgSuite) TestHash54_SHA384_7(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8c313ac7ccc78a2a37800654e5c4c9e219d1c4066829d9ee9af7cab1a5f76702"),
		nonce:           decodeHexString(c, "f6c7031cb31e3dadd45301932a721288"),
		personalization: decodeHexString(c, "c198bae21397263a4fce1a253f418803ade06edd961c7656287333d93d369dbc"),
		expected:        decodeHexString(c, "7cba65a1f7424bbd3054cd681d9c6a89fd64c67da5eadab49d2d688113f79eed721acaff2a282eaf02b823d928d28b8e500c2450ed07e6e1bc6c5f9023f91df2fed7063e32c4c8264e6904bde1e85cd3ddfc6d7db385b9834d36d1127f3be9dc197f3f2df26f11a4f33298d9af5d89ebc2648b2d4c8c15dce8e535103d36c19a4f48af8a740b89150c93cff5dd4c244519908e54079b2a1aacddfd6ea1dbdec6dd6f142ed284ed868fe451b5da7bc773b4b0af0fa1c1992661eb1f89fc0f6f54"),
	})
}

func (s *drbgSuite) TestHash54_SHA384_8(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "2d914f23c9c337d6c9075676eb69ee9117653c3f240801dc93f630e880bd7c73"),
		nonce:           decodeHexString(c, "7fc5e341c5839e2eb16bad31692280bb"),
		personalization: decodeHexString(c, "4853b817b858f6d0301233ae99660742960f3cf45db20ba1741373b4ea4aa8f2"),
		expected:        decodeHexString(c, "0939234892e77964590b4a37eb11bb286f6ff63db2840d3fe6e527e7f00246eec418b3d79c2d41685841ecee9979bdb732feaa424ff5e51b4e2117d9d2dcafcdc6e890de6215581ad10549c84fd332ba4cad847abefe253863152ce3233152cef672437d686146a123667f3bf621e7a251471a26a695f091045cd8e8133b0670086092c33bcc8304ccf704d875deb7a359a38e4f7453e732ebe1f6519a7f1c31f59abdd7eff68743dff31b4f625f9cc315579fd472583c918a72a7ffa018b6f4"),
	})
}

func (s *drbgSuite) TestHash54_SHA384_9(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "78d96495678401fd9b8a7bb09ce5eb7b5a82064669542fb6903768fcbb939490"),
		nonce:           decodeHexString(c, "d652398df43d1c1b56f4ebc5b98a600e"),
		personalization: decodeHexString(c, "9d7e3515e98af6e36501ddec8ffdd055452d508ba27d0ec9d06ddef2746d6a60"),
		expected:        decodeHexString(c, "80044c300c94b51a3c5e84600537c33c2d3e696ce6ed4ad38505ade4b14c65fd6af38cb7d9f104e9f4b5f3c53f9323fec9c3cadbed0bcf09075d45a5c10f8cf40fa70588d5bab1c2ad2609dfdb216c20cc409ac7baad103fd3065bf2349d3ee59aa96a420e6f627d9b5dc602ba4af8c8ced0f455a27ccc45be32dff01342c432c358196621c672ae1af55e218d82d0f692ed7e40bfd57d6f9ac243048d4085e24bc38287ce1aafb1bd8ca754ac33d6640519ab5480b724c5dff69c8ce5a67310"),
	})
}

func (s *drbgSuite) TestHash54_SHA384_10(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b5334d2c3d504ea556e377d68e9b712b6d961153e671fdec6221b2d54e21b32e"),
		nonce:           decodeHexString(c, "49f105e0321ba1b39bb4d315560bd2de"),
		personalization: decodeHexString(c, "216d9ebf2006991e8540bfdfd430926ae922a8c12759797dd8c684ec26f49dbb"),
		expected:        decodeHexString(c, "6849b8bcc155899625db6a4a7ad347125c99c61f2600da0c1b28c2a7b6f1be83967ccb1e40a1f89fea7e8341c30acae8b1e46c7a332f9f5785547712f7c930bc846efd7e6fe74d1c2954baeac284baf896ff51a688eb6a6eb50bac7eccdec2e9fad688135884a2bf8e0e5ccd2bf27c771806190102055eb07eedb749b0d96f99d34fa64c8254f375cfee6515d4eedd4a44b3597a7f6367013cd9412738fa8868a5cf13be772a2c6dabfd7e707c76f31d7880e91fe2afc5748f3b88fd06f1cbbd"),
	})
}

func (s *drbgSuite) TestHash54_SHA384_11(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "28f183e74f140dd8ac8734d189241287e1a04355ace6f304c515392b0bb7699d"),
		nonce:           decodeHexString(c, "a403cad967a07bdb585063ef1c9fbdbc"),
		personalization: decodeHexString(c, "972a837632cc67c264845e308270660abb9bd4b1262efc05f884c463388c6de2"),
		expected:        decodeHexString(c, "6b56d50a4100e6daf006c581a65f4f97bcabbc8d102fe80d72853a88d7c69148f2e4eff6db1263b6ce92c92366255fb4ba937dc3847964433a8e63f70bbd758a6132d6b0390a8582bbe372b137b329bd92307fae48b6a16bb094fb00494aa574ba9e143b49a46c25bb1fd0d6968c1c24585a697fd88d331b0e9076755a7ec9106e0ff34c428f0e39f48b3034eba14dc5740a22541e07d61d2e99f5007592875ff479eae65d42d65e648d573f5ffe23013550072fa55dfe9f5fcbd9cd5aea9590"),
	})
}

func (s *drbgSuite) TestHash54_SHA384_12(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "2dd6b3e58ff00dbce6255c452d1eb3aeb211e2fd936d5d0f855518ff2c1c099b"),
		nonce:           decodeHexString(c, "61156de8a16776022afe3c6e6b26ff39"),
		personalization: decodeHexString(c, "674a4dcc09eab1cd4bb4f21a70f3ef511de6aefe317509ebd9bc477ba792636c"),
		expected:        decodeHexString(c, "add0b4f31a396bef6c75ee4f6feda4909f6d1838a5e7d707c6362d56c62ba84f1a9093ed6c141b9a50b0d6a319b6ff3490eafa848628be4d84b822cd4b1735e52948714b6e0cf96e71d27c3b713ef4f22bf29e198eba2840cb01975247cf08208942747907779e591e1ae526b71e2a943f0a84b0044209de531ac3d4b2005818237c60a03e03918aeaa7045480315d2ee29957c709cbf50c98a87d9d194f4b00d6baad6446f40caf11fee232062e1df92bc57bc7c4dcb46f2ed175c21249d037"),
	})
}

func (s *drbgSuite) TestHash54_SHA384_13(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b6a5b50f57d8ebf8a619615c9b91c1642fb0525fcf4d8d3733c944e3221471b5"),
		nonce:           decodeHexString(c, "8c37ba49cf56b9dcbab0cb4d238b4b86"),
		personalization: decodeHexString(c, "a94b6b839fd0c30318b189391fb30877f17208f9401033aad4bb0332656b3b23"),
		expected:        decodeHexString(c, "17c954b37811b89cf00b823a0c5f0a07418131200f8cd88d321a0dd48aa3853c4332f0c32a9bc039142790be11b69ad69c7463b166924182e07d7fc1e1427e42e6815c0161b45b6f6f53d1ef12c139c035fffd997711a94ac6b82ce25a5d6c7d7b465467ab30c66eae498870ce6b7dd5dfecd6cd40b9897d17298073f82b588965b6761566ef868365cfcad26a75ddce316e420faeffda45439ecf5d39775c471c683999cfe93be718b1c8b32a5d1d3a5c5d48a06ef7d4d7d9c8684e4a165bcf"),
	})
}

func (s *drbgSuite) TestHash54_SHA384_14(c *C) {
	s.testHash54_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "09758e8217802f40ba0d6e9c71c142de1b40022ec1af3354e69048ef3be6077d"),
		nonce:           decodeHexString(c, "3432a2e2263728e375ab973bb5842d40"),
		personalization: decodeHexString(c, "ccfee35071757d5141f55a481b7c44a584c5e537c636d4d0ba10dc3c88adf6a2"),
		expected:        decodeHexString(c, "72a77d1c5dea9d00c349d4e5a9e6dff63ef6cb80b7998ef62e7a1fdc2267057d07fafb993e8df868821c6cf76430f3b7ff24a527f7e41fda6d560a773d05bc003f7e1ed5085f6da3785dd999a4763894455febf7618750bad4e30d8f52f3a072af30d57df5afda08ae7cebdcb659e6cdeaff52b47d4dc571e28315ff0e38538baf436e02d157b64afc6d50e6a4c5842aff1e7573888c6ff9beaf4f91aed988f03032388940c4f54afda05bf55ef6fc8c673f01ab545838574f3bd4f22865cfd6"),
	})
}

func (s *drbgSuite) testHash56_SHA384(c *C, data *testData) {
	s.testHash(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHash56_SHA384_0(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6ef7df0c0b9181fbff0d97b87caf9882c5af2a5ef9b51e987a9e83d1f2deafc5"),
		nonce:           decodeHexString(c, "aa26b2f2536bc7adaddf6573aab6dd5b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "38c2ce0f928bf7a737b681360397036568719ca0d956292c0dcefea6183af0b68cc2bcaa4f00847980d21476f07a8c2ec4c11a8b63af03e62f7c2047d26a331db4fe9501a6f5007fc7702823954ccb8761a2fbd5c9f699ce260ef24ac6b080c5b5806dadfddba4d509d92f1cf387ee09e7474deae77f575ae4eb630226b7d738e8543f4cbc862fb87541c3d201fc2f1cd8509cbfd3f756ea0990ad8ef2105313eb3caabae0281b8088d0931110ef635d4d380b98d220635ef01cb2c345f5bc22"),
	})
}

func (s *drbgSuite) TestHash56_SHA384_1(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b328bee870ca03a6d14e1f209addcac9b3751b22eb99c6e4a2a3b4a9e80e8683"),
		nonce:           decodeHexString(c, "ce4bf7c799f3c7b0bb803a787ad28b26"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8d0bf7fe6ae18a1d7c897429a373a98e8fa5f15c464427b8a1a36b3338ff746b7a90404148fe767f6f093a36481c95cd6f51a6efd9c6fff0d014d3b080f5233a6ab7fadb19d0b31bf789c1412b5d0440b720aac605a57ff517d7037e3bc4fd94207304751af0a5ec111b98923ffa4574da4d80de45f45ba5ec7d006681390ee014c026f7e0e355e610677377ea2348526fe723b7ec56726955fa95787e2d48cb9ea729fefb889b68568589a3c6e5450ccdadc38d027736777f32f69aeb74e2c9"),
	})
}

func (s *drbgSuite) TestHash56_SHA384_2(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "e29f20b139d71b3f6956366a4e735a91b29630fad720f56d62fcd4e98745cb55"),
		nonce:           decodeHexString(c, "9204c396863fdadce6ee46abbe655df8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a882e81a9c6e10aa87ebea482efe66c6d95c6965a18b5c929b07157f79c7158e20a013e63effd24eae52c594a838297ba18c0f5c4df21193df16f9cdcc88532b423be880d328eadc531c1640b886e211b23f60d95507764c4320e0ceda4a4aa70ae4a5889faae167f59723378a0e14166f813dc4187d5f36641a98092e68e8bccc6b28da2f1ac60ee60eb74e6c2acc5036f12ea0532c32deabeec2c4b00c212201cc4945f1b32b0b445b4bfa2d1fd1f7108ec74c602538651bc6dac2ee025fbe"),
	})
}

func (s *drbgSuite) TestHash56_SHA384_3(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "2c8bf920b79657639a86aa5cd7e48e70d8651b33686c7a3142c9448477074d95"),
		nonce:           decodeHexString(c, "ee54fda4225a04499f170f680214961e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cfb7f884ff3b36fa4db5eeeb296f4f0319485a2bf1de8d2ac5dbe98cee9abf24937ebb8d4af9cae3534990f2b0b866e2e6e866ded378ff7ae7b3772d7c013c7f5f91e070fcca8da7b94f372971e0c6ac3f2fa2612d7faeec8fd57b6c0ed038ae368ac8bdfd1a13aa0cc46ed1a2fbfd135950a90de13cb56eba982a7d9ebe9c64a59ace8b154d342966849edec062754be2bc86faf80f3fb87001611ab90b36672150c5f11930fd31bddb5675778e7430571fab26c04eb86689b12a48bfe32e40"),
	})
}

func (s *drbgSuite) TestHash56_SHA384_4(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a2b35e243bf41155ec95b89ca8c02a14aa6cd3f3469d1cde5de53142e00b8b9e"),
		nonce:           decodeHexString(c, "5ac28918d35ad33dc28d346cf1186690"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4c4745be14071078b55427ef5fb5297286b9d83b69396c2d2f24716ab4cac2fba4231d525b5c972bdb7fda75a3dec15d35885fda6471f39c6868b74c478886640c4012eea52fe5d919737b2c7ce47294549eea8f6ffb6a149f888dcaf3cc8dc1bc3d6fe48a7cea610cd00b9103712f05325d3f3ed2220972bce4cf92a9d86a6d10748a1172b2bd0fdcb9b159efbd0e0b2e8434b1e7b1a78220c96935d3f6989f4fd4b0d6722137fb67823034cd7b3f5a230148a0fba339b060f9e7b8dc024797"),
	})
}

func (s *drbgSuite) TestHash56_SHA384_5(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5e711d2210345876355dd9e09616e041e84fcb26d7d65cb522050040feaf0dbc"),
		nonce:           decodeHexString(c, "d4ef1bd75e85b4901d8c005a684970bf"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ae839e7fa091788e8e11f29c14411569a2b4437719d7411436357f7034eee223c7acfead356f07119da87cca1b787207907d6f1484d8b85a3de58beda9f5fa913fe66ae347582c87564d13b47eace00b64ac08863d6e5e1304f70251280b86a6ec0301677e3cffe2429e865da116ccbfbf9dbb6c15454c7df23b66ded8972d8dd0d95ca154bfb4dec53d57d220882a26effe456201c37895ad7d94f1f18c9d97526c32cb206da2b52603f4c699093c7447d38ef9f49b5f000f1e6832e01efdb9"),
	})
}

func (s *drbgSuite) TestHash56_SHA384_6(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ca71fd984698d4a801adde55a12e1d3dbf947beaa12fefa27116a542f83cd353"),
		nonce:           decodeHexString(c, "841355c447a8909c1b763ff0f99bcf95"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6ca4163d630a00e9a19b9a8db91ceea4a9853cc816fca57d8c87c56d3071ca069c15855902c5105a577a6262101a2302741facf85b111de0b6b6dc052dd2e9b566e0fc53e2aee7e876cad9a5a257f544d4f0b3adb5b2720b4a96c32258c699ae449ead389609ed48452bd2e7bb2478c3436314f8c700bf57c5b3b1214a0b7ca89d2dbfd197e652c508b16b0098b46c08ac04168545c7f496d5b7381ee05c587687d0c473a05584d9e1fd8d6a8c650fba986f3b87bb69548be13006cb450973cd"),
	})
}

func (s *drbgSuite) TestHash56_SHA384_7(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "2e2f77a265443252a51f674940f3d22e7471146663051e7b3c8d9d6294f2e533"),
		nonce:           decodeHexString(c, "0eedba6cf1248acd00895b7b731b8a5e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bb580a32c2274aefa39c7f396d12bc2e4806201319daa402a4bfda6d6e112d977c0f699843cf0fdc488ab2bc6067d9b28f45a51842bc23cd1e2a658d09913b0548576105bb688c9f4859a280fb1829b5a73eb7b1e56bc2531598fc0b78abd5eeb9fa700d35f8d66cd534d868ccd803802e92447c2482c69307e52e687537c2670603014ba26ae7ee5306141270e7490f747d7fb6f10f988e7f59abb95ec698b467424e8717f5fde81a82da5bcebfd9ed0bc2202e04d3f05500dc160507b29bae"),
	})
}

func (s *drbgSuite) TestHash56_SHA384_8(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "cbdc84de78841d6eba2d14afe71d38a1c82e07165d69505034d8a287d8f5b26e"),
		nonce:           decodeHexString(c, "970d3c34193f81bf1fe70634e915645d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "47f0ae073c8a605be62b79d0cec7b4909bb55d1315e13f22197b0735489c06a47a3c5c209522b7c21b551bc0782017a5a9e79e18fa75e167617000ef5f28cf9d464b76f66e20d2ea5ef98220ee92874b046891a7838965e818ad58e837240970270ed576e545d9746ccf0bf2c20c30299cd4cd3a5b5c038d622c376d3ec08344fe695a01987c5e1c298edcf7a42ae7473cdacf4b9d775d480af2d162b6d6b1d139bd0c208bd5dca83c5d4bbfe2ea64d5ef94da813cce88ca18825d47d740a1d0"),
	})
}

func (s *drbgSuite) TestHash56_SHA384_9(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b917e2a2a8365f097649682aed69a177b2dd468aaba7b73d9bb66245d851538f"),
		nonce:           decodeHexString(c, "89e6729035344e3d82652b0bcc024db3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8bd97d4299911a92dec3fad5c198403eeefd3be981b25898eafc6b652da6cdfdfa223db37eaaa03e30c5054584f9025e1704e8e20f53ef4534c13bd714726fe765ff63645910c926de05c067ac20cd974b44704fd457c35359d4520610f4b51d041031a81435dc17a43cf0e4426d88643da33b82cc71635723bf5d959c546a8ec479dd7741852227fd5a9d4e9bcf2b7faf2084c67f776bd9ce2f208de44c8d2c03ae9a7cd7ba4fcd6a6ffa274333bb28b6abba2afd2dbfb9fe0486b378122001"),
	})
}

func (s *drbgSuite) TestHash56_SHA384_10(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "208307e4ad35ab0be593d0c3f9a85819ed05c521519b493056d0a53f1ecda414"),
		nonce:           decodeHexString(c, "d980460023bb998eb0d858791d5ff895"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "11be42b4a95f07a68b66340157575056269854617608a13b249dd69f8f29d2c191b9dcdb1b1777a28d55540cb1926b2a5cbb8adb558ace37feb280d4563c4201733c9008202db5d611713c66b70cbb81889136329f90e9aac3daba22c8e200b68a72621707229205dcd35f4abfa79a7c38cd5ccf21e71f3dcf769130273849bb58e90a4881e85dc7ee92f4dbb613f10e2acbff67a5c99429a9221aaa2dc73e714f735ca4a758a85ebf7eada7e37ccd9a6f7005276086c4e19a9469e88cb47434"),
	})
}

func (s *drbgSuite) TestHash56_SHA384_11(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "92b42d45f93e85403bb49d9aaabc9d7b80eaa544f79dae4659820a0b08ace8f4"),
		nonce:           decodeHexString(c, "b818f47e3225bb3f2e742c4fc3d241a3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "39e1e1cbbc02111fd07009e694adff48c35def11fedc24eaddcc82ecee8d389f3afc8619392b49559036f3eab823fdd2ffa8555dd60d2fc3c51db0a46b0cd346d7213f931a186a967f15265f7825b65edcd5240f3522713eb867843294016907f9ad3b3858324482444310e28fae521e154c31b10c268d87e1bbc7641731f8705a1f0509ed4570162f6af1c2700e82f56846920238a9fb878d45e35598c43a269a8ed33df361d4749c0f67eac9b94b63fbc54d0a314c8c59b3315895fe6d643b"),
	})
}

func (s *drbgSuite) TestHash56_SHA384_12(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "fd96da186fc0247e6e7d05d98fd1db570b748372a5c17698d1367990c7429c5f"),
		nonce:           decodeHexString(c, "2dda1c20be855abd248ddacd2fc9b4c5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f8abf96caa8d6b7356cf2b20ab810726fc170bd46e9d2b0817d9b8d818af28d9d7de4e7d1d379535173f84230d77444b5781b41abce6046f19df985e83409072c710d0dfcaf70b4fed4b54b9f53b233488a8c6ca01effc36784267667d58058e8be544a17ce1fa5af1729ca9a0ff1c5657e659228e15f246c3c3bbe56d6f55f59a14b421c759a7f5a310c9c5e590d8b80532dcfb6449664c7dbd29b998420a443d79bb433624f03c1843f23883827f42d755ed663714530e3dc5545c7c38e76a"),
	})
}

func (s *drbgSuite) TestHash56_SHA384_13(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "cfdb054dab9f892968fabec8e00730ba4d33cb161e4f9912f6e740a16f2e4763"),
		nonce:           decodeHexString(c, "e3de0b0263c5560b98e2d9df0beec8dd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9530a7a287bd21829b2fba080f52fa63f688b9cbacc0ae4c13f9cbd692d318364a3d2f62e043a2c096ecbdcf5b33b47543d45c84b762f2c1ead80e979415f2428741cbb8ae79ac44c8261c4e9d561d9884a4a9946d826b5f1538e73c8a20414a0b1878a396e1181c2eaa8da3e666863704cc0892d1b96030f9624f864b01f787ecec03e237bc85f5431ea058a28a9b3bd4608563a2018d9150094ca007a7c7a5fa641875559cc85ac54986f92c34ffb4f23fe1456b35f1358f025c31054b36f4"),
	})
}

func (s *drbgSuite) TestHash56_SHA384_14(c *C) {
	s.testHash56_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3b6dde5f550d482d30eee2288bff802241ef20ec15696e614b7268f7c574eb1f"),
		nonce:           decodeHexString(c, "b8d8984703ca7f942951fca97129135a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "36d0cce70eb5aaccf9b172fccf68e01eb8ac8b1f2652cdd238f4b070c8f2d9a128418badb38d5d5fabe28b59d15cd432010716fa6a48071114b2168cd29028386171594291118e54fbf5b61ae3fbbf9a21ebe73a4aba482c7cdc5ea1a4f21a0f1b38812cefff9bae78c2b95f417dc0cda010079b637f825dcba059d154f5a53050db773250013a1f051de9f7882433d2054ef2adf9b7b57c67173c06ad16cac6bdf74a10bcc666f7d4a091a78131c5ed76fb733791278b6ee0f55302c4b122a4"),
	})
}

func (s *drbgSuite) testHash58_SHA384(c *C, data *testData) {
	s.testHash(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHash58_SHA384_0(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "705386dd8a706d0774b65941ce63c71f6424c4c91b0fca6213f2e6f23315f761"),
		nonce:           decodeHexString(c, "737cd32701fef49041fb80cd03077513"),
		personalization: decodeHexString(c, "de8e15f6d310fea562341ec51e474455047cad287259928fc3c94cb3b153b241"),
		expected:        decodeHexString(c, "88d333e5b81fa6738de0b1bc50b2309368c70ddcfcb5d2b268540ed506cd2d897dbad3069ca0577fe639f965963a07886c27539d48c7f6ef79aadff5c5a9865aaf3e781c0ec48556625a2b9d0a11a71a65b96a4b49d30a8178eb0e345b9c92084137d7bb95c2440640e8af22dd8061eb474f956446ada61cd8f0fd538cb8287ce33bf508b3b40b1346a42bec6e16a05b09f3c8a7e7e4c488a29f43c8ac77cde3fc0f3a17bfbe11c3848ead351d28487dc9469c537d210f0f01ffcb0fdadadd98"),
	})
}

func (s *drbgSuite) TestHash58_SHA384_1(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "fd72e20fe3bc974a33ddb71df40a6d8933dc7ba71b8069e0184ec25f17208a77"),
		nonce:           decodeHexString(c, "e231684bf93354be1b95c7e485c8cb0e"),
		personalization: decodeHexString(c, "3076b2c4ef5e2942738a86eb1ea2c16c29d50d8ab2651bfa193a96c1b29be27b"),
		expected:        decodeHexString(c, "d4d5597cde675f700ffc4f45386f5dde0040788e9b4af8f6a8fdfbab3d9ac755fe99e3906e37fe67bbb323f32a264bd5a137217d6cf986a60070fa4389dbd476719a88cfad84920702fa8c6e8cd820a59be4f1c7a04bc2e89c7deb9ac4b8a8471a560fedefe360ae8594bdea4a8508f1052f165f5e774d362a6a57c5d89bd7ffcedebb9db1e76fe50e3db62c7958749d8498573bc4c0b7e04e7111534b333555b6a836a745b2ef793bcda23966e66bc177af74e04d07df6e4c05364fc6c5cfb0"),
	})
}

func (s *drbgSuite) TestHash58_SHA384_2(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "36bc1f2d997c7e90489baaaea0e3a26f1c25e630ab76fe469d3a2be6f6f6f4a2"),
		nonce:           decodeHexString(c, "f81e1e8299c4ce15b86fdf17bf480b51"),
		personalization: decodeHexString(c, "8ddc2e0d4dc14de4f335f7ce32d2ca9aed9c9c2cb8b7246b8be42df2b61f4fc9"),
		expected:        decodeHexString(c, "e06007b997f2ea6a48b4f01cacb89b35b3f67e13e99a3369070a720afff12b2da06b0d724d67ac18b1589dabd3267aa868d0f3f2836a115cc1e4af6b3a45bc8326f116a310cb92efca5785c387e6fceaa00188387e93c05dd45b71da23839ecee8d40b63191debc65b6e2632480d1747f581dd9d15b90df0272182a778f47b761147a749e9ef0ac0e59d4b40f7f360857e09de551d186f64d92d7e1f11a3da321b87ecd1c36a411f5a12e8e8b31406b7183265c9ef471a966810d10ed3652ee1"),
	})
}

func (s *drbgSuite) TestHash58_SHA384_3(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a8b61446a8440fefb294e6beefc40d7c49640fb7b2d1f326f48f8dbc3647fd87"),
		nonce:           decodeHexString(c, "0505e5311530d5078407355eb1b7e6c4"),
		personalization: decodeHexString(c, "02e7e187f276a181c3b4f1fc39bfb09f16ae58f81c24c976645847c2e16b0260"),
		expected:        decodeHexString(c, "22253f2904cea40099a0b24d92995094436563f933fa005019d7bfadd7ab6783c4e7e0881a5acf46e6db6da5272f768f23fbba6cfd3fae6c76a6896c1e0a80bbdc0ecc7cb88cdb554236c9157dc157fc10f199c22fc18cacf675008b371b381e484d2d854151b9bea555bd533945e6427ed4cc9cc74cfa0aa92ebc412e56cfd951181e376f0f900d0326e10876dcf2a880ea2830c0632631da09ce2caaaabf96d56f9d8eb25404c77e46d9c20e788cd1abc84c73e380a7e8dbeb5e4ce1f1f97f"),
	})
}

func (s *drbgSuite) TestHash58_SHA384_4(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "debb0f618a1a660f9a720440b775542862c150512d6e2d713fe61d0a090355b2"),
		nonce:           decodeHexString(c, "c8cb776647df80f1b2dfe3e96d07ecf2"),
		personalization: decodeHexString(c, "588b837cfdf6e18b4d700d8a7903177231a36a41338048de302c9c3cdbcd0f32"),
		expected:        decodeHexString(c, "4991f9fe4b6a0b791e9aafdc117add0e350fb2e25791a4eb3a3f9b5d05f619af797ac6d65c1bf1a5db175115c9dda209c0c0295eb5e4217ed8522a623a8166ea23b6799955360de7866cf41e9329d98fc7f29e04d6d5120ba541e5c01e6b250b7094ac035535be80b2597397b0644d6a3147060944459b2678e89cee3d38ae5c9a8c608ad3f20f2bc45ca2934e5175791eba4d650449392cfcabe4591f21cd44c96abdc2d71bdca80ec1fd92c47a02ebc996090ff58351e6ef7a050be12e56b2"),
	})
}

func (s *drbgSuite) TestHash58_SHA384_5(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "4bf21213d980252f5dc3518b867b15b2899755e91fa461eac27c71477849dd8b"),
		nonce:           decodeHexString(c, "25647b2d71a8f3a6310a0e04a3e4f08c"),
		personalization: decodeHexString(c, "f64157717d1ff1bcd6737216e1643adeece3025cff83297cf8113d6505de2df9"),
		expected:        decodeHexString(c, "91d8d74d1c708edbaed3b47d47255969b52c34d3296c16ab803263c25e82996ffee23972e763b8305f01426217ed4b3fd2dce2250da3519550dd5e278cdf501c22dc97b582abfb237672ba695cf561f190a66744299dfafa764d7ccda05a36b250c68a21a491ba132b91f56eca7411dcaf023514c65ec6e8d13bf1f3b86c827d61aa223de5d92c20afc531de3a1d7e2769d494a33e7ca3badcaa7bc9547b48dba1706c68920c0472f5128ee3cc205ff63e6e7fd2ee60c12f2c7336361e81bfa4"),
	})
}

func (s *drbgSuite) TestHash58_SHA384_6(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "91e9323c47847ca546d94fb870e112dd03f756ffd1037ee766bed618c49f6056"),
		nonce:           decodeHexString(c, "ff42d9add486f711de89352075bfaf5b"),
		personalization: decodeHexString(c, "f9ae90cea69c9987483268ced4240b5740319470f37a4db14ae090e4d5f35a5a"),
		expected:        decodeHexString(c, "3b90cd426385b80c697bcef30f2fda44194aac38c726a1a6079b430d1b6c8fc2639836bb11abc40d7eb3037f26dc794b075437e080fa21da6e2b0b7c2c15c4f4f6ec9e27578d65b66edbe3f24d9ab5c4864b3f5dc2949e85484a958e68af6d5cc45a21662d4fe4dc8131501cf6faf4e3016b5a4fabd02fec24ef03b1dd1ccb5efde85430aeb4298d947150c6eea220b09e2177d9df19c6ff8b54c0168215fa6a3aa08886ea9036ea14d92ac817f903ef4f1c2eb8d79e9e920ea42273e53f5d0b"),
	})
}

func (s *drbgSuite) TestHash58_SHA384_7(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "910b3ad9e38f603112e94fd39aa04a171c66bbb51804870568c11367dc8d4145"),
		nonce:           decodeHexString(c, "9ad5b632d6b69716bf89875b041db5d8"),
		personalization: decodeHexString(c, "98177a8f3e6a507a3b5b1b7f7870eb9c104c9aa4734398df3fd53af397078ce3"),
		expected:        decodeHexString(c, "38d5d1cfad5004302a35ab1db30a3d1e5b372416a538fd2ac89aebd886fd1e4fea179c8fa2c020475b6ca3689c0bd9165553e559d4e69e9994a2805fe72740cc5c0361757565e8e6ce822ea6705e8babc9c7a435852f3dca8ba69fb0aafff13f9a5af520bb07cdcb294a731e089fa0ff34a90af31bc369fc6206608aca2d00c8f9f13ea6798e481e0aafee906539a715546a54a8a9bdff14a3f318c542f7442554be15dbfa56053ddec14320de8a2f0bbadce69324428e4f6dc4071329bb4d03"),
	})
}

func (s *drbgSuite) TestHash58_SHA384_8(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "eb5cdd42ed4773b75c2f4150ae05a22f912761ba6432eefae73bc51befcca0c5"),
		nonce:           decodeHexString(c, "000c53ac6e933508af6ff52eea37b551"),
		personalization: decodeHexString(c, "8e43ecffbab808b752d3c45c0581f7bf765ae2bb385ababb200ec157d1cacf8e"),
		expected:        decodeHexString(c, "d7e00ef43fa63f7663704f50ed7720dd84948937782876a88bf1fb393670d6e65ec27a0bc6a9301c17231d673cdc4d7083cb634703732012a4812ccca0e1f76886801d2113b3210c6e3bf15a7ee3c429d4cefa4c0fc87cf453fc7422939c29764f8d0b685a52dbd231410b890f5187d5e77fd645d7757f10e79ebef6ab52d1f4aa385d60440b4b9c4fc9c4db8880e5f57a743644c1e47a15d9b5a219bbe98495c900e248933c556a37c381274452a1a20282e17ddeaebc1ccf4d186ff3042946"),
	})
}

func (s *drbgSuite) TestHash58_SHA384_9(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "59a0a9b8209a18b98133e9a7c4969122296e3ff2828f7b3524df4f1c132e0331"),
		nonce:           decodeHexString(c, "05b93b55f2a2b597be5bf578e1aaa517"),
		personalization: decodeHexString(c, "6b056e5c0d3820976ce478aa422fe508998b73b07d8a0e39b8d977f9c4883843"),
		expected:        decodeHexString(c, "560f7c7cd24f94fb71cf128fe6b80592c1a9a68892bc06dcd872818a267c9a71acb613c6c8ffc916e7b3b17ffbbbead1954686e410d22c9959deff6d57935d8fe378de7a7ed5306118a5204eec12b3cd42ddcef213b676161e77e1c6b815c7241655ffdd63d6df99df3b446ade23293f6d71d33832127525ee133c8b4d9739d1f09ca51a860326d7819ce458e453b6156e8f78e4fd0674fd0c1c13509732e7fe00600ea2bbba6a1c8176430a2d5ceb75dbf42fba35ff21aa94f3b28e6fb226bd"),
	})
}

func (s *drbgSuite) TestHash58_SHA384_10(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "4a347a7f16af01da9dead84ed59f4cf5ee88a80b0a1f1adc2a3950af9d225054"),
		nonce:           decodeHexString(c, "4ac8f9b859a19190043e552d8462ff30"),
		personalization: decodeHexString(c, "e3dea246be6832fc4bfa5d33f51f25fdf4bd3413c69f3203747db51ea51ef9b2"),
		expected:        decodeHexString(c, "dbe0b8417996f8096bb3fc4634f673eb748e0fa66d50fb4f2af703080c8d214b35d302852ebc37b1b94615dfa22ff2daa50a7ac4b3026ac9a12dc77585142ae66520ba66642dc95a6adc5a1443c3a5e043009dbb3470d1b32abc77c035e1069c4807553f10ff6b148505ea4aeafd2e37adb2068d69bc5229425f8114a693413d8b5f545424fa04cdae9bb02adffa1af6999b7b67fec536c70c1880426a387efb67193c3173315fa9156898d9e24ab71a0000ab1b1ab3475ac2607aafec922f55"),
	})
}

func (s *drbgSuite) TestHash58_SHA384_11(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "451b3d6e11a8f91912517e8a665a7c9fcfa9ad540ca57778280c50ace87c7dad"),
		nonce:           decodeHexString(c, "148cfd56c82348bee96a572d3ebff728"),
		personalization: decodeHexString(c, "862533cb4031e95b7ef8a05763f2566bbd51bd2019e2cca9c2016672fc6bf2b7"),
		expected:        decodeHexString(c, "63103b4698327d4dc418388e5f2216899b2e46fac2adb002beeb940d0ec25b1362d6b4013a0507c2d8c9d68b8af61e3d53674722a4ad111950c6ec59d03a9bbd025b61d8c0a39c2a01a7d19cf26c1cd4c724831dc8f61ec77fba616e6f2fd336a39fc823788b96a89e219e4186367e91720db0cc165207b92db064c71c8c14dbe8d1135cea6c60f8fbde17b44c8416875551fa616a3290a8d0ed4590f0993534d223e882d74815e0facb0859af394d566d944bf220655b978fd155c6a6b3b3d4"),
	})
}

func (s *drbgSuite) TestHash58_SHA384_12(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "77149d1581e379f92cb5aa34096a4f15ac25967e35419d4a5e91fd416930e791"),
		nonce:           decodeHexString(c, "7912098288b0bda5d195d0c389097d61"),
		personalization: decodeHexString(c, "861b9a1a2907805253ec3b2d3e87bf3fafa6deff2ba86be3877d3225e63a73d4"),
		expected:        decodeHexString(c, "edb878d87d903b9ded63158a3ae7e271d3f6cb454de15abad12ba082768123770e510709de531dd473f2b9bc4165a6946b91e5cddd15e7cb4c4e8d635b3e75494e4046913d8f08ce36b9468b003226190811470827ef5efbc4a90b4817a6f4767846a8516066feaf63c95bb9db8a67a744b7046a1e73e32ba62526375b5997d305082675ea0164a25df2808b70b98bd1a5393cdee448a400e3e6a066fd566035fa2926cbd2f044714e87bec4ce7273faa31d68a30f09eaddbfae14e45e1f2264"),
	})
}

func (s *drbgSuite) TestHash58_SHA384_13(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "86aabec349d1c0f2ab21048228c940f5a06db0e5b7a6c8e2ebb3f2c607afc2de"),
		nonce:           decodeHexString(c, "1f952b9665ed8568e555aeca2e5dd84e"),
		personalization: decodeHexString(c, "d80a0fd76fc5de2e674c4cb012ff479efb79b419167fb741585c2e38d4972780"),
		expected:        decodeHexString(c, "8cafdd5141f593062496f7c9f401c84cbda10e5498cbaacfeb3a25acce4427f8fb0335b9439ab9e954b6773594b9976a70b1d2234b7a67093a3d75d0adef3b7cf192c775b850b978fa52cac4d2d9412b22cfb8dd25b03ffd7fffedd503c320847f934db95d680daf77ce351d473304c2b29d6083ae854fe6d9db87d412d780d007c3e72ed84fe2f43f00543d76a679bacbffdf21e3f1cd779a603d6940c892cbb27c1afcdead292b1b0f0943fc72e60f60aa4ebb007d3b62d81611e5f9179d53"),
	})
}

func (s *drbgSuite) TestHash58_SHA384_14(c *C) {
	s.testHash58_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c0b522f46a82a6968e16c28d2dfd4c425411914fa4ddb7402612489624860f16"),
		nonce:           decodeHexString(c, "a684932ea2337296cc3d150174a47ce0"),
		personalization: decodeHexString(c, "b2c0af9038c2ef79ca8263a047bb9293a44ecdb457fb45945996157dcd199cec"),
		expected:        decodeHexString(c, "316fbc32ecc1dfa778b13921b1d624f9231c0ecca03e17fde750b1e31e76b1c330ea5bd62ca76150f231ac4aa96b06f845db2d03b65cdaba4c160b288a121eb144058f65a751e22151f91b90131e6756356e7f90d880ce754cf965f439189eb8bedf86c58e1fc2751e65637930c42552fdf81acfa1d4515ad49dc532b2a10b2b11209425ed1cf43c991b4a7c49bf6e701990fddc420608d74c3636829e4683c4e77a8151708d82ef8fb81b3655670fd4d242e357831bc091f30e6d139d5e5ba5"),
	})
}

func (s *drbgSuite) testHash60_SHA384(c *C, data *testData) {
	s.testHash(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHash60_SHA384_0(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8c801881eab7c4ee266eefdfe4542c577ed822b8d287f9b505158b57aa4fcd45"),
		nonce:           decodeHexString(c, "dd30c873d352d24610b55fd3469bbd27"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a12284431482d6dc016df53984647576a2ae619026786936e8e8644da80a2b4a81dd49e4562ba0e3435c199967ae9084fdfda4978759803d60f3eea6a88e32d3152f02a6f026f6c5be231bc352c381600c3a9c98fe371b460128724beac130a57b19d4f5b68d34054fe4fea076ed5c598f78f503b1cb31d445c93e12458f9fc31e6732a1b212105e438c8700eba68768b084eb3bd1760aabe5cd8b31175b0bdb09038da6a166c8f93552add13ed047b65c54d47b4b5568dfff2a3bf3daaf0fab"),
	})
}

func (s *drbgSuite) TestHash60_SHA384_1(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "4227d1d20f16951377c275cf7ab4598328045c736b43514e39cca65741a37165"),
		nonce:           decodeHexString(c, "058acf3c8846fcbe63c25f497082b127"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "08b00d950dcf31df0f82d8831917fbe5bf2342753ff1d0bf0988cd9c9103d607967c525b11822f65616b1d5c9db40dbd67e87eef6a02575f7597332cca37e0ba63aa98e1a42e26fd84cb910259bd758d4e5350abf6764f6c2fcb58c3a9c33523b4d4920162393203529e221b25f0e1efa64abc09e1c647af55ee29fe57e744c206868b13124e7377ee201cb6847399bb2c2a209a050a1954a7ec43a8397ac82d586230b8cbd2c58072eb4a626aab866f39d4be2abecb9d2e8bffc696ced23fc4"),
	})
}

func (s *drbgSuite) TestHash60_SHA384_2(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "979283d921c012117037d6c450e2ac3dbf47fc5ff8ec935aa2b2ca44c5191c26"),
		nonce:           decodeHexString(c, "255dc3a53398c95a36ff5ffc63404653"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1e7ba5bf07492bd8647b0192566e3614213888b895ccca23fd55b398fcddbd8da06b2adf6a7772eaf053124b8ac6a88f48e2e6e9680cb1015436c4930390b1f0ecfba2bfabddfff9b550251194562512f0ea9f6d589857195d55e44aa4f8bede27a7304403222a9eedf9eec7e9927defb1f1338175afd9d7d1b2a4339262997f05b58bf589faed4555102633dbae9010de91844f532d4d944ec19a33e68afddd77a81617476d7cc6fb91e65306373f369a44107974ee7fe522d3e81f61442fa0"),
	})
}

func (s *drbgSuite) TestHash60_SHA384_3(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "77dd9f622715bfe6d98eb9f71a999589df32fda44abba1ab3d94aea5bd01d1c4"),
		nonce:           decodeHexString(c, "526097f9e7ca8c1300bd4c68641d18b7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4873dcc448595c5be71a566deeb53c83696765eac2ff61843a00f9cad83ffe062632788d879b30a99539a60535fbfed447378f9ed14daaf5e3b2e8a35e539d263810d5f3d6b2f3d21769aa1b338069e26ef91c4e8024cff2c502341764b5f3fd3c2f6c86f30c2a8b528258b81cac6c3a6a1410e9abe633944ae3467512f84cf7ac2c4fc76992dda5e2bb87cc7e9136bed5d16df4178778f21956733df3775453098ce3ced544935b4ac8d5fc7808c1ebd18cad0362fa6b8b421f4d32415995dc"),
	})
}

func (s *drbgSuite) TestHash60_SHA384_4(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d84eb51f6f165941a8bf40ba46cd1ad5fbb785b051fe4c338e29843517dca6f1"),
		nonce:           decodeHexString(c, "b1915f5effd8bdc4af8800e15beb6f7a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e35734999749f558bd177695b2694ca8870f4dea23e05b167af5ded6c832c6b79e3275eb81f84e60fe493f175bb45291818e7e74ea7c6f18c6f442f75b6365be04781e3fb0979ca35d04fb12d4484c95ea4edcff739ca22010766eff7bc61e465028fd61f7ab7279f2affe55d3a06b04c9da5f10ae940d3eba56e8b0086d15c69ca4a20fc1a3a7a4c46941e3e750e6219e87ab956b1d9194dd0c61f22868b6452ffcd9c555337f8e5e515e52de90937f1b523edcedb1b0102e6dd0ec649fb116"),
	})
}

func (s *drbgSuite) TestHash60_SHA384_5(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "51b37bd315ac0678725c9139a78ce7ad7d23359f31d015add589f91b61f39781"),
		nonce:           decodeHexString(c, "2809ebddb9fb5798398560a9dfa1fc51"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "93420bcc789c6e870ad5f924fa3b358817b78ee883ebefa6fd106d74a363f908cf9e60e24f958a7cde96d0cec8000ef78d056300404f1e02c10f1d2471fe3dd6c103f5dadeeaba37e88bfbb4f033c5aca2b2dec35b10c8d34d56bd86459db87ed45f0ddc85b2f52e4f44f0ce81ca77830ffcf5694e3a0d481a83f41147808b30c6f2a05b013f0db1d4e8c9faa8e8ba1d68402966f2e650fa613b3aaf6dfb07afbe436a527a7744e7215fcccf0b3b6ebae0b4196ba8a7541fe44573c8172b0fed"),
	})
}

func (s *drbgSuite) TestHash60_SHA384_6(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "203b742d2fbd8ddb86b4cb9375dbda0c8ed21a8ff8b20c37f0f337d1c714d662"),
		nonce:           decodeHexString(c, "4d1469ef82e38b7e8c53a2d288fa8c8f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b612b61051530714138bf287ace0d00d922add8e74e74daff67ae281915a8b0f74df894f8b3f577d84fbdddd268f4e47bb7c51378da7a59d46883c0229b220f5469c0718b39fbe99f7cedf93a0b03d3e14481422f1b3785e670e963046d017c1013f09ef94f39dd4cad753f861ff2f0b330c751e2143ab207c0b646638cebd951b4eeab42eaf43486106176496311aa4e1a2e10f3718ecc4615a94aade44e735976a79c1c75eb1b4dd899927f8db44dfc163da8a47c0c5f6517a016a0b42389b"),
	})
}

func (s *drbgSuite) TestHash60_SHA384_7(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8d4053c62e4560aa5eaff157ce25439fc719811cd8057a72cd14bc0359e1efe8"),
		nonce:           decodeHexString(c, "ae0b87643123e790a82ae9f89966e0d9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "86ac147e7d0f32d9b242a838460c863f4786dcb116024c836007af4e322c21726806314c82a14d2a9ec396d4ab30cd3fcdb5df21c68af1ad702d6885a977b73e38628d391f4b313a2941e26ffbc38e4196c7ddf8f7e3afa3f2b062dfcd8485e98f87a3943b9baeef17be6ae9787032ed466ee00919b60c288d02c6ca42300cfd8df6cd10d8d6a7eaba6fb4d4b7d74f9e2df747fdbc28020716755bfbc1a431ff8ff01e2564e9ca06a422a7fafaa87456243f967665ab28cbead6d07c9da0fa2b"),
	})
}

func (s *drbgSuite) TestHash60_SHA384_8(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "aa674aeb1b5da4b7c726b83bfeb4b1a4bde1a52a087ccbdb4e0fdaf87f484460"),
		nonce:           decodeHexString(c, "973fe67fc1b2b8877d1083a555ca651b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0c8195756f630eb5d3d98a35b72431b57e070fb1f4eee8e97f884c2dfee0e5645611dfdd2663085870b18ac7d59caf727bae7a8eb70ba0920ae89c1d826aef98b30e5dfd79bb9fd6f02237ee8f60e43dded18d79e27e4bbdb08685b2bd8c179b2e121f636063a911f01e4be98feced5207c2d665cc7478ae0afcc29690c3084011a050ec3829e32a7bba89424f2e2210feb082c74d5e4eca516f220163acca8422ea3db37d8b543c3726091a3211e8c57baadd18c12993e4ab05eddf2d76970d"),
	})
}

func (s *drbgSuite) TestHash60_SHA384_9(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6d8188fe3de5e2a5b04af343731bbbd2e3735cbd4ddb440a4c676498567b08e8"),
		nonce:           decodeHexString(c, "3f16ad4eea9e9b8e0c9923fc915ca4a0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9e6f6b2d7a1eab7178442820bc3fa72e8a3fe412c99b5f05b7394d866ee0fb1d264caeba7ba178bcf6c3742917a2435cd89863fda6774ce49c3949568022f2129de240294786ecdc6cd2ccd4758bb2e2614177baa8402d110f8056f22a4275aa1c72b7df820b8a33f13e21c7c1d3799c115dfabc1cca757d2d7903583025d75c4f233584b4d71ade533f426ce45b007d0aa7f92260f3f88436d42bd7e798a574ebf3aa42124a6e0fc1d46519c642f8e50018843067b7a986cab6bb2eeaa983a7"),
	})
}

func (s *drbgSuite) TestHash60_SHA384_10(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c17f5c6544320dd01aab91b17e756c828c5e003cfb2afae7ddb91785bb4da3af"),
		nonce:           decodeHexString(c, "84b440fe338967162e348e7dc30d56de"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dd5f09c47e45da8da6c8e7237cbd0a7cfbec482017d9ffc3f9a6b78f0adeaa5b82152302584d51cd25836732b8a1027ca804847bc9268248f3ba772424896a0dcfaf1b1db5326fed41517a0a60a8034b0182d8acb21f819921790eb9942e8af0a4b4a8d91eb6ad9eff795a35bc9d3c37cb3fa6b484d207867301fad80b685d3e0d0a1ea55a3c41d46d5de62e39c725c31b331410d94392f8d9669564ab97cd79ed69be64695d8298602d64f3dd2e32b1bbdd5f845e617782fed2b4fb4975961a"),
	})
}

func (s *drbgSuite) TestHash60_SHA384_11(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "ab40718cc20345ca62b5b15b3d868decead7139f616db6629e7f16aa12162295"),
		nonce:           decodeHexString(c, "ecf873875a825dcd78ed858f09bf2726"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "92283cb0871966ceb9bff4573b3f4600d87f6427882f4e47967ffcad8cbcd3aca7e5bd0b2c5fbd7286ebf26161322417ab932b063b8847139acec642b9b1cd0c8174b25eec9f8749d338d4dfba6c8b73b0926ec5e2f0547da7c57ead4ddb237a204053cb55cea76b2e30a103883bcd0f7886c4c27461a4a38dece4734cc70973d25059731dbad506a8007a1e05259b9882a0060ae86a274cc2a71a87fff7a583a3fb6a3ed3797c37d88b00578780f1ef8864a05f15f640dd9807a9a78ceca5b6"),
	})
}

func (s *drbgSuite) TestHash60_SHA384_12(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f6445b4f2c2d4afb4e9945d88f32555bf58bb4f1d9677cd955830c5c888fb503"),
		nonce:           decodeHexString(c, "66549dcbd3f07c92b6848766aab11f46"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a4699e29b2e509247366a6ea8f3784b03c10da3216a59675a2820101b51d4a3551fd5ecec7514091024117d6bddb8c3fd5fd499baa941ce1059f846f5ce5dcdb276d234521144fbcc14b9d7b457a13c860758aae61cdc2c92c520c93b0fecdf5e8f329b44c6dc3cd3e2522f5f514f18897d52562621bab6f93c93c74c55b4bc98105120dcd80d0247779595a1862c52d7cd701f203433e04c6052fc30f6620eb1a4ef9b63461f80367174accf8db1ab416687b0aada0da7c8b9ef954779f55dd"),
	})
}

func (s *drbgSuite) TestHash60_SHA384_13(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "fbaa77fddaa6f0b737902459f117ab739494b165136ebf8d75c00a12384d363a"),
		nonce:           decodeHexString(c, "1cce6f7b6dbe8e0902f6790c782216ae"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a47c6f2e3699f5f89700a0b0908f40b6a6135a8041d133e244d968953651f7f70c1b2c1a1fd93b1de3f863c1f97067716a60c0d418b10f70e21d641f9d5857d949819ac9a5dbefe5095e8eaeffb36b1e6d96d2d53d7eb11a60eefe6b3de99034b7f9ff58258ce1a9164bd5e928c7e1832cce094b7fbc431144cf042d2a1aef7101a18e52d68cdcd3f46f9e4239e0b312033d8baf5316183ce1899fff4b51078fab6e721c4e23f911ab58fb68b6bee28a23a44fef2742788448612dd77c8a4b96"),
	})
}

func (s *drbgSuite) TestHash60_SHA384_14(c *C) {
	s.testHash60_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1e1cde834393e00a2136b8924be5600c8bf59dc2d8a9eeae467ede71ee7b75af"),
		nonce:           decodeHexString(c, "b6035e96adcb7e8f2e17022e2e4f39ad"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9dde9f29034b6e784be24fe600c39b091568afb4c40c8e05b8b7dc36ca74a1bed38ab15643ca8c6da2f5aa4b7a6a5d5c9920cc31129c84e2fc9b865b3f30b698a143189a3f3b692b3e5641499c949e53e3619cb112f42046a18d5d12dfb3c6932a6a829d07deb17b799519b81e961ff293c0b2d24b629fe906166e330135e4ffd00609462f0f9b89a110084945243972486a0e1aedb2eceec02d402696c89abbc950dcaa72d7b0e00ed8e65c3e9eb1af7535de2da728f901650633242b3368c6"),
	})
}

func (s *drbgSuite) testHash62_SHA384(c *C, data *testData) {
	s.testHash(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHash62_SHA384_0(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "70de81d127c681561c6b493c8cadc8414e8cee05483f55536c9ca85870bca0ca"),
		nonce:           decodeHexString(c, "9b0100814f2583b7238bfb1fd0ba667c"),
		personalization: decodeHexString(c, "aaa228c9acc8f8d349f96509ed5d2908baa5a3df28fe4e286b7f555dc7080117"),
		expected:        decodeHexString(c, "daef45c681b71075a8ab3493f872a27a5889201f89d965b01e3a57ddeeab7fa9fa132187d1862dc51fab0ad807b81cc7d00bebbe72ec6b1f223f901bf959f66d8bc9c27fe4a8549272446d000b32ae9e33db96e71695643e1a612414e850e4c3345b0ae0b8a30ad1badab20b06d4f6200923aae94a856727b0e95d10f55efc3c2f456580b4db9e0318836e4e513ef7fba11c87c1cbd879a87ead4fb0afd28aa6e0fbd2583566f77c658fa6a153feb00b4b6a834e42f50cc1591fbd2564fa117f"),
	})
}

func (s *drbgSuite) TestHash62_SHA384_1(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "7815eca31f6cb0d691feb6ea67bf2f1f7d18c663a009406c32cade57826b2383"),
		nonce:           decodeHexString(c, "f7d59e72891fc864183031865fbf2494"),
		personalization: decodeHexString(c, "80db21b0ce635e1fd1e32ac1269681dfebb60d91993872a0bd90a792a455469f"),
		expected:        decodeHexString(c, "f1947411a357d7e6906530c81b424210327aaf43a9e8072b55f3360d86e6aa7c5f16d1563be36c57189f1bc5d83eaf95b33ee23871c5fa79b5a97baaaf6de395a7edd3b2f0dd0e45f8e5bdcfadfea6d369f1ab47851110cc39552dfcc4da755b7ca485dff07c51aeb6da71d2b4f9fc65c332abeace27327d4eb4658bb9c1bb5c6d27347be882b8c9642d91f08876fb9ded6ba78c2bd52ad9494bf494221f5861242574f32602a052f8946d320c552e265a0c6212d052c66ddfef1feff6a81d6d"),
	})
}

func (s *drbgSuite) TestHash62_SHA384_2(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "07c630984fd7902054ccce7f2628e288815eb6ba9eab2aeb601e994773c308e5"),
		nonce:           decodeHexString(c, "fd945debd0724f4070bfa831cd805322"),
		personalization: decodeHexString(c, "7e5491051d49b1c6b96928a2e8b0c5f59baa3be90d60104e22ff72d9fbcc0b24"),
		expected:        decodeHexString(c, "8e6d633d282ba33e96a08eb6189aeb405237be9c841937d15a811536cef8165287261def7a63127fc4204f6643900f44829230ccc7de2685f41b50bb7502147b38d20b4fa67738de2e8bde5acbd249d1dcd748b39870d8abe49d3e0228099269f33ce7a4dc0dab1cd74b1ee9376768302dd48e5c7cbb967403c02a3e5eea40170ec5f6b3ab519016df3cf065cfb2c5791d0edd7dd53a9d483c469b4b37748e35325e4c66fa91ed693ef72f275a94341155083b8338b5a9f0be85dc71ad7230b2"),
	})
}

func (s *drbgSuite) TestHash62_SHA384_3(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "99f5690a9b572caf0946163879e8e76f350edfef7e5f832ba3c970f2aec9b60e"),
		nonce:           decodeHexString(c, "a2daf8ff525d7193bcbf6387cb07b31a"),
		personalization: decodeHexString(c, "263944e089bb9e05ef88a683d8393eb603567917e7f1dedddb7b69c487e1d703"),
		expected:        decodeHexString(c, "0d1bf25551ef211926382b3fd4ac107229e528b6e653f3284eb77b77a089a0777c54794f35ef77a9a99a42cbad5e0e057c5857acd1b9c127f092d83b09ede142a425a01898253b3d5cce91f3e9105ffb3e6327bdd9ec7a75b221283a559d42a53c7e47bf3a8282e3f5a6612c0f53b728f626e580ab02f3a7a81b5c4b770aebaa4466d0e12c8771f9c40c8c1e6da1b18b440c767b10656af633ca304f5f9dabe26c9c0699bc886985a624b6f9a823122451eef6a16723b0504ca4ccf33390cc38"),
	})
}

func (s *drbgSuite) TestHash62_SHA384_4(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a159ae0bcb55d0b4989662a5f5a95da1be050a5373c4aa5713bf1db7b2d84bf7"),
		nonce:           decodeHexString(c, "e60db02a03f866aad3081cace521d148"),
		personalization: decodeHexString(c, "d150b2067a427e4e05d474b365c89db93c11ba124116f68b0b028c2b8ade8f65"),
		expected:        decodeHexString(c, "7a3e407bc1166263f6c7528bef56e5da21cc170c9eb6781643bfd772fb5b1c274552bff9de0dc964e5ddb3ce3833a5a0e83ff84c15f7d288a9b054a7b94229f92d00b05ddf7419ec73d8c567c1a2170a40223428ee2f879bb84592d4b36fdc622ec5d7d615f794b323d211588d1805181fb0e33fcb963142af52977f0ddd9c9f60e84cb202dec3d1b0e8c26135bc1f51c1cbe4b36a996dabb7ee1a11927b705909bcb0f13e2b7d6a1ea51c2134cf48a1fc9f34556257602e87ba68a73a6554ba"),
	})
}

func (s *drbgSuite) TestHash62_SHA384_5(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "494f20f6b24bb5b0b422a07473e9f771a6fb0590e7599f6be557de35ecf1e7d4"),
		nonce:           decodeHexString(c, "87b2204760911cdfa00811e7c7a8698a"),
		personalization: decodeHexString(c, "141df457de2fe1ac041ff60c670eb7f5cbe90c2a8a7c17d9606791b66c2553d7"),
		expected:        decodeHexString(c, "383021db6e4f1d414726e20e063f10e71a48fe90cf5bcf7c9e8a0650db622e98e72026e24901f446928f59669b03a1db535390d29b1a87c23bacfa0fc0ba01755f22ccf84600d49cd20c705dc4f6ac1c8b7343f97ea87841075d089755d022001f3ef8df4c06fd057b654bb46349ad5792d1b408491dd82d35a6f09a60831ec8d9f17832a690c32f73eabe604570bdcffa88155aa0509664cd0662da4e75a192e4662fd82222ddd6304523425eba02dad98d0b28692b43d61ba44127ed545957"),
	})
}

func (s *drbgSuite) TestHash62_SHA384_6(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "74ac530e95e14ec86f990260c234845a163030ce2ca86a24f0459630fdb629db"),
		nonce:           decodeHexString(c, "66040001c1fa6528f678c4c0d9061f46"),
		personalization: decodeHexString(c, "946d491549cb1f1761836d2c594f32b16e6736afd8460c0ecb1bfda1a7d7dca7"),
		expected:        decodeHexString(c, "a497a45f83669ef44a4a08db6aa2f69b5bd0c8a5a7fbe0ea70d2e9f996334659c2ce6ad3d5f5dc733c5e44b506d0610c0a251cf315cbdb8e0735d3f23da38d3e14354d932ab3ed99b3d4b6f1048d28d79ef36f910b6d211a5098b78b2a0dff215a7d64c9a26e201c9cd2dbccd03c19ef5f831dc4cfaef2bda854a540b69452d6e1e0b82c08a4bb861f24626a7e8c9b17fe7cf1ec0d3a6dae71ad20b1ff5629ed09f59b060622088a042abc62b2eb7aeed4ee4f9ef821e438ce4c8cb0c5724501"),
	})
}

func (s *drbgSuite) TestHash62_SHA384_7(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "506c04817286c07ddebd09ff08ed68914db54c1b7c73c819fdaf23d1e48b2f08"),
		nonce:           decodeHexString(c, "329f92547b4d42764c2deef18b06161c"),
		personalization: decodeHexString(c, "97ca09edac4a17df2f6d65c0e4958f760c8416f2bce656d9eb3919faf0b918fa"),
		expected:        decodeHexString(c, "7494c76a946c6fa4c79044b566b49f41637695cfa8e933f13be301dc11d6f5e703720ad344a92edd2d1de07e07c7595da8f03054c05ad01886d2cb5f4f6c4c5f0cfb29a371ec65ddcdda744f2e8015d813fcd9190eff3f6512c587a8e503f3e0d4299bd6a5eeb530a9dced480abef3e05ba1df1a7e04bd24d6b9cc052172a00e96ea3edfa41952786b157f6a124dbc7fbcc6732a8df256b979ef8492188f2f50a8f36490fcac63245d82687f0c502abca7ec7dd1982f5beb662215262a1759f9"),
	})
}

func (s *drbgSuite) TestHash62_SHA384_8(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6c7bedf7b1c554e344b26782bb7269a453f7fbc5aabf42f09e3033b58630f0ae"),
		nonce:           decodeHexString(c, "564f4f9c541b3107596cd3e8292b7a23"),
		personalization: decodeHexString(c, "9f05ef7646b4be65741c55c65a5ae569615d257434595b35afa2e4415024c972"),
		expected:        decodeHexString(c, "4d08e9668fedbc387adc4f170f8b656f826f9f62801407853801d3c238705080cbbeab1860354cb60e765207b04bb3630da109b9b0d8857339172224729fc5420c47f844509d63a3d70325b0952753b41545eb8f87a837ddc78854ff04c3ae67736284589ebbc017b0e9e6ef9e8b6de43e1de0d80d4fe303795b99c2a87f02932681cfde9d75b2d2052ad74eeb7654c7dde25d541bb09bad52fb1f232a81f1af740db999ba8a88fce9c024911f080ab6021ec7cff968b48e7b22b96499cea5ac"),
	})
}

func (s *drbgSuite) TestHash62_SHA384_9(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "2fb7776f60596cc045c2c92e05d0baeaed6021fcc0a66c3751817d6d5c72f665"),
		nonce:           decodeHexString(c, "feeee4984161db20ac810d441e3fc3e1"),
		personalization: decodeHexString(c, "2e8f0b6f22b86cd484d7cad65089b1430ee4051c83d3e560d81c02b539c29a8c"),
		expected:        decodeHexString(c, "c508658e64534c789f930bae1ad77966d05a2d556447e5c7407a806e7af4bb626d4a010902cae02a2692e91a18a5a136d48c0cedacccf04883fc2d3b5d1720e184691aa726d0a47a0a74f6b2039af4ea3ee5756746a9984748b1dda81cd4185b8b71f014fae6e15154d276ee9f7562dab242c95eff1c69b4000f964a243b681d060b292166ff4b2e54be84ac576194bb96b511fb510ae6d19e783cf632efee03ea22a0d3a1f60b3a2571ed7d5a6ccb1c3286219f0c3f992d865a7707129f45a5"),
	})
}

func (s *drbgSuite) TestHash62_SHA384_10(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "778e9175d3e502548ef4b5c7fc0698e7557e7f8903b86951ded11b90320c517f"),
		nonce:           decodeHexString(c, "c9da53d66f5be160d9d4587e6fc4601c"),
		personalization: decodeHexString(c, "8221e6b8c882560efe8fae9bd849f0bbdd93b8ed84a3dbcb00e342600384f946"),
		expected:        decodeHexString(c, "2e95d3bd5ab51a03d89feafd4b2ff60e2df83737cc78714dcbcd93837113819fd7b0e2d4257345aeec923ee51ea306deea04c31729e692d577731dbaa43a5ba14a67153776a2ee9064774a2590f2bd37a77372266f7455d856f61d902acf10cb0f8403a2fa050acb58cd0c044e9b8ce079b9f28da5271f961c39fba814f818f006cadbe31f55ae88f47748a5c34e8d6fe0324eafd8e3e1398eb0983455f38089dd46c5ee0f2abaeb582ddf8f0ed910e3111b0106da5dd1b83efd40f01577aa1b"),
	})
}

func (s *drbgSuite) TestHash62_SHA384_11(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9abe6eadd8df7fc85e4f414feb36fe06b587e1b4a29909062940def816045ff9"),
		nonce:           decodeHexString(c, "07bee03f9779b86260e73338aa509243"),
		personalization: decodeHexString(c, "e24084f08e30990410592879c20e7b661a0cd1ffac997173631d68bdc8e9489b"),
		expected:        decodeHexString(c, "74f1ce1b87f539012c3d69ab217c4b1fdb8f656cfd455a2e328a2e8d6eb16800b1a6f1810a34cedfe80439166cf7e4c06411d5a872859082170b84e19a9c71b5ab0417e4ed923b190d44263ba3dfc89c8167118cdfad4053c93d90cfaa23125a64a19fff17124e085f129508835fb9e8bdb4e6bfd40089113fbfb05c0cd6cb774f5368255dbadaab3136a49aa0bc8eef0ee25a0e61dcdfb5ac8b09a4c5381d649a05c4474d1952e95fa4597f9947a8ea0bcf7f68be6bb194dc1eba442ac5aab1"),
	})
}

func (s *drbgSuite) TestHash62_SHA384_12(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3dea25021f90e1651008ad4c589f789cf93e43fa30770f3b1b6d513335d01f1e"),
		nonce:           decodeHexString(c, "691b22cb58210e7b277595d1bd2a6c3e"),
		personalization: decodeHexString(c, "a7fde42c12f8767851d1d0ed0c0b97efb9f1aaf837e0f5c2173ebd73f31f8b80"),
		expected:        decodeHexString(c, "c61743c144ea662c459d947a22a57565eb5da0774a6e1ab29cbb9052e72fe45a4223e31226cb65465fd6a0a0ee94f81d7c5ed07d5395dba87ead2222dc235b33ee1fdf561060eacc9b661985698d7c34f28743fd8f78b3c87391895761d19489abcb7e97ae3dc6246b6164b18d41d996446c6d5da6b64474eacb99520401c0abe21bf7545e3e75ab0fc8d1813a4cdb8cc0a3572f8d386cc166e4a516dc4f6a84109fec2a0e1648c630c245bd61214b36b42462226a451c8dc4bd80d823c51eb1"),
	})
}

func (s *drbgSuite) TestHash62_SHA384_13(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5241cced127c6d4ade1c8c26a34aa330e8453f22c3ef07ba712ac3bca4e3e29b"),
		nonce:           decodeHexString(c, "0c2c26095bc35ae5ecbb261a9fca3f52"),
		personalization: decodeHexString(c, "743a783fba241267380acf9157f3a5066ff7b29cbd74d1452c9b6db3b4b819ab"),
		expected:        decodeHexString(c, "dff087e2fcac155933af6b0f610141ee4c62ea5e32cd101a84aec4d8ef186d322899c88ca4f361fc0caf1f9758ef4a9eb696babe0eb16d4d36d1b020e8a3bc6938042dd63db602d729eddf17851d79b5465f33e809a8a998197afdac882d2f791bd6e9fd8aca8fd3ebe776c257509f2c9eb135c1df8a2b56207e0c9b98f46fe37502eccfba54a8525486a38cfb94f56e9f18efb166881354292cf33ec2de3c846f4c162050c901055b8b41d1202b1c65be475f3671e6bde85211729132e08a7b"),
	})
}

func (s *drbgSuite) TestHash62_SHA384_14(c *C) {
	s.testHash62_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "fc2fd0bf5fd34e2a04100ac16ad994b7538f90db4094e00bb477af5fc223da61"),
		nonce:           decodeHexString(c, "67f50628067bc401648926d7567711cb"),
		personalization: decodeHexString(c, "5f8cb19e3c86b179ffb8812db791e8bbe6b0caff958715dd9e3368a2d48f65d7"),
		expected:        decodeHexString(c, "f178a20d27725759c839e7fabb63bd101c3352f582524ff088ccaf6f0546ecbd3d5165f1e3cacbb49ede115b8f6c8db3aa9720692efda124138d29eac17637b84977384fb88e81289ed5ec960e6e98fdc71d03ef0bbc05ac7682acdc62888b49fdbb442080687f902b5a313ac88d364b13871b20f684cf1acbfa229fa203607a0a37b4e1685d13a508da9f48dcd83f26751a2284044f93e18b2a206a1887d77c4b76e821952b376f19fcf53d83f704e3ec3b5c3cb4c390b213d57dbe4852914b"),
	})
}

func (s *drbgSuite) testHash64_SHA512(c *C, data *testData) {
	s.testHash(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHash64_SHA512_0(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "6b50a7d8f8a55d7a3df8bb40bcc3b722d8708de67fda010b03c4c84d72096f8c"),
		nonce:           decodeHexString(c, "3ec649cc6256d9fa31db7a2904aaf025"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "95b7f17e9802d3577392c6a9c08083b67dd1292265b5f42d237f1c55bb9b10bfcfd82c77a378b8266a0099143b3c2d64611eeeb69acdc055957c139e8b190c7a06955f2c797c2778de940396a501f40e91396acf8d7e45ebdbb53bbf8c975230d2f0ff9106c76119ae498e7fbc03d90f8e4c51627aed5c8d4263d5d2b978873a0de596ee6dc7f7c29e37eee8b34c90dd1cf6a9ddb22b4cbd086b14b35de93da2d5cb1806698cbd7bbb67bfe3d31fd2d1dbd2a1e058a3eb99d7e51f1a938eed5e1c1de23a6b4345d3191409f92f39b3670d8dbfb635d8e6a36932d81033d1448d63b403ddf88e121b6e819ac381226c1321e4b08644f6727c368c5a9f7a4b3ee2"),
	})
}

func (s *drbgSuite) TestHash64_SHA512_1(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "22342fe603f975ea26c7ed7ddddb38b504e43c689176016c8a56b7af47b8459a"),
		nonce:           decodeHexString(c, "ea8633f25650d21dcc79734a9ad41d3f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0aaf02a611b4d461e493e3532ce8ab0155811d3f0676fda82a64daf16c1f8ed1730887ce9f9b2ba38495e5360a44cc3efc4ca8c83f8a64e6e0f1922123505ebfa9d30412e5c4884aa1e067efafbbf8a560574646fea79bb89399477cad3a142957789fa78972d5680d3165cf2cb6eaa2cbd4201c76bd6263840cc745a43f647d8f3b6d674fc654ee71d8e6196cbfb341dcd0eb98bf126756d67a6a42afb8d24d3edbaf288af6ac09503f4d4794b4872b36a72c3387024e3647447fa767136ca3dc247cfd6ca22b169d3dac9808d85cc193e9bbf3658b6b4f6ab39445a2b127f46a1a8aee1cc19b44fa85848a7814aedde84ec1b1cff69bcb6107c7647b3a90ae"),
	})
}

func (s *drbgSuite) TestHash64_SHA512_2(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "b29e584555b8f7721368a042bd6e173e250126ea5b848544c63e8588c45f7456"),
		nonce:           decodeHexString(c, "58035791f0e93f5ee3b5087a13004e16"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5afb6fd3253b8cf132fcb6f2cac2f5ab9470f9123d861353aac795569eebbee38487c0888bd9df77a45cc9fa8c584d8e534f2cdff13fed96f3caf377feabb346cc0f27733f68a68a92f8c0686d469b2453df75b7b2b75b5cb4153d0f5997890c986ade6652eaf1b12ce6ba9ae642c5646ec40791e74ebabd4e122d5113f34a97942fbc9a968eade54d2a3017335537c61118a855598b866a4017fd683da336eede2c2c435aecd838b01b166ba61cf93f6ef0a5930f1b54fba1237f92bccbaa2a30ce44fbcb9d74a9d031c02d63d374b20d3c1dcfe9ff6a554afdb81215ecc1032d8c8ed64af0cbbfd82af5fbc4da62328ecb2f559368daaf9b8c1bdea2eb2b0c"),
	})
}

func (s *drbgSuite) TestHash64_SHA512_3(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "0ba19a623ce2ebff98f6a8c5868c89aaf061fb664ac01b59c8ee649691a99fed"),
		nonce:           decodeHexString(c, "71219f471964d6d88aa3576910b03f44"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8f05c6dd8cded901daaf2078ea4b03e890251f298847a81bd826b61a3613c29671bf720cdf1262f0f3d2d7f502e527c1b0c7147c93d6bae619a64fb2ca7d9d8b0267781c9bac6755a25fed3e729c7baf3e8a477c329d56a1332874e4be626ff05f00df8f75dfeb2d06a391bd75c4e1ca89b858a214464d4d1f24a9e379c563f48fdcc93d92f0be5c115c7a10551a1ba1da08e519f4a4c815c3cad1eb21ffffc5c8fabe690b97e4077fffbe87b36d0e09da0fad2b55e0f812bf67714909cffabfa97e083dce8180323caf68ff9eb20368fe444f00d1d711ab683ec35235e31c82d56b523437a0ab90154b9f2d6a8695d9620f4c41ab5be48b5a6118a242ec785b"),
	})
}

func (s *drbgSuite) TestHash64_SHA512_4(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "01ad79f5be89f5191da48a44d56ca5071e99f15a3714eb92174749ac0da9c53e"),
		nonce:           decodeHexString(c, "774995740ad00048ee2996ed7e1c603a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d228d36033738b3b82f2840b46b5f0fe1bb06cb204ab3b68fa80725966f3674490ec6748e48db9a00285d63a29ef905cae5fb1552409f89fd6541b307e4b1231d46556af591023474bc2c07c821c745ffd7c24d311c4ff6bb5d346e15e4b617faef14a51bc3820270fd010d064daac2257df088bc65242656e7e8645989c0884b2dfcb6d725073150ae0c3d00c89b118d0dd1a424919aa8e9ba6e0aa3a8c4f13d2dca4f339b220356dd27f9df153e9c2ab86c03c1075c54583c95b64f42eb2b5b4f8797964d10f5f5d4b01899d81c53b86e11b6633ea2265aa2bb4b7a231b68eab232fd222a73c109530d1ec5649c2e0f596f5e37f340f84be9330d6979c2655"),
	})
}

func (s *drbgSuite) TestHash64_SHA512_5(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "aa82ceec0eb83402fb324471c806b95a4638d983dc2a9760f1147b6caad6cb3e"),
		nonce:           decodeHexString(c, "0de90f870d610034803f19ac72ee076e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "69176ef1b1ca271ebbc18e438abdb58da73e8973da0d8f09db50394e648aeab12f236261e29bc95e39a230abeb63b2baede8d5760f5935103034d2d3163ef70cf86ddb1eeb51b0785b6c4d0790b8a9aff1a93965ff2ec0619d78f2986078a7dbed21420b1c768e59b4f65017f392aa7f72b47c7129f7ea55717be1f924766643aabad143ac153525a7f8196bd689d5543b9c1f5b6fdc50c9ced379cb6e979fb68c162abc89681b6255baebd7e125a5bd0da884454d225e621d4c0ef9f68d48eecff271e7e1845ed0a32b3998d114c6f57a53d1230e9976472fa0c51a4d77329d833f9061fc0301626eb11dc9c701358576e9a6a104bd86f222e6a0f9d0b4597a"),
	})
}

func (s *drbgSuite) TestHash64_SHA512_6(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "a6ea179c5b95eb59011f0975ce9752fcab7fd245e16c9ed5a211c822162d2ee6"),
		nonce:           decodeHexString(c, "54a833261bb18d895d11f517a6541c28"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "79292869d53048446d1ab4c5e4ad360aa4fbaad9b11c084a05884527393f877edb6565717afe88be6ff1a5562d2d94f5932b65fb3412891d47985b8499947675278e4a2980c5c2bf45f41c3d9c411927530a599f8592e83cd03b2baf47a60d2bb62e1c9b176a82f62bba15413464a338bb90e8e3524a8cca13395aa81e19c82d58e26d8ecf9099b9d1e879ba60dcac907bc74f8669f9fca4db4d7272aa57ff77c376e89bb696f3db16ae1b22a89a072f8909678a2e2ce370a33c53d65ecba52f6312d6f66d3c000b3ee6d58c8896b207e707933f4ef764330cf5d9a8a6ee6271f034c78bf9f7bfc9135590ba44f61fe89db440eb6d4aba5fe553a628ea466ee6"),
	})
}

func (s *drbgSuite) TestHash64_SHA512_7(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "6fbddfa9c6d79513644acf22143108ef8808387055f7eb94538ac7ee2dbff197"),
		nonce:           decodeHexString(c, "7612a515530deefe1696f0838166820f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4741b139d81ec6aa6c56b365f4505df51651558a43236f0e05daeb36a0f2520172979402f7ef9e88d729cec885093b6687ff42918f162c97acd02968601af0c58f0be3f0c744741caf9e8096625b11441bd28c48d3b5deed47afb5cc57c7e2b4bd6c9fa400d5637b4cafdf406370c519a5ea1de8c38cbe40473dba8ed7d50d6524e37be7a0287dc21c4cf1f5d3a0b2f03ae2c349b76d3c2d3921307c15839247ebbda381b97976a15f7175cb6aa3b65324e7086f2affda903cc3ee3584a9c4807ac3555c1bcdf8f28a0daad1a55267baecd7da76837b455556fe2a03dc4f8f7dffd69da0164812e55a455418d34868372f5e0f292dfc08abee2e4a458f9c539e"),
	})
}

func (s *drbgSuite) TestHash64_SHA512_8(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "e11dbb2fdf96b61b60171eac2ddd71731457a61d750325413eaf0d631565ae27"),
		nonce:           decodeHexString(c, "48bef2b3617ada8a3bab0851ea3b2491"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9b31fed9016a5de5d22186e88362a951e00f33eac66148d84276ce22021f71b5af99bc7439b610d347a6b1414c4c50a911f4e14a8997600686289320568996d26170f10454995d6f81ac4baecdbbf7411e04a767ac11416dda24db4e55be7c1d10d4da23d7b35c9226fb2d9c146b928d2339275433aff0b5527b29036c12173befcaacd5e9d7118d1dbd994c96b6602e86b537fd00b3191fd1abac4ccc4f6ddae7c59abe0cb3602930d9eb6294a9e053a415c1bc62a6b5f2aad89fa6c3cf4ca03d9cd150c2f252154bc46f524e8ecf90e819d97822e698a487bb92d7780532261cae81fc309679231ba6bdcc1087e71159169b41534b9af31f566a92a14cb492"),
	})
}

func (s *drbgSuite) TestHash64_SHA512_9(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "31113275ab562f8b1704e21b7905df530d5b0f81f044844a0db06071587510b4"),
		nonce:           decodeHexString(c, "35fc721e174e3b372c304f0b3c0b1a42"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "967c10c259c5ed4d98a91f16454c452deafecd63f685c3bef917e55acb6dd955b690f730f968c5a888650c2562bd23c1d5ba6598e11d9389afe12d6178cc8a2c77447f8acdedd028c01f6ee81022729ecb88b837e54f27babfb785023a6e596ebee6df3caf1e8975cf040def89e742b907c3e51ba0afc36ce3e7fd85b25a5550f4ab01e1db76419f8a732a6cf8af141b8d9923607ba185be6ef60908667ae0ee0b7d293012fe52dbe6550f3eee6867a8a37f88aedd2da962dfaefdc5d5cac5e8e7456f709848bbdd508cc5f5cd706e7b5ae9af57fd994d3f2e61bca98dc3069967e56f1f30ba0cce2bbf390b1f02dedfceba56158009cbc23c2c4e9e646bdbc9"),
	})
}

func (s *drbgSuite) TestHash64_SHA512_10(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "027bd3dbfada2497ad20782a28101ea5c9390f7371cd3245fa537ef932920bde"),
		nonce:           decodeHexString(c, "cbcd6d23d8ab4b66a83545536930f557"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "290f47f88b75d2ee16030bd9836a5ffdee9eed568fdf300ae7f99ea28c9c4751fa46c1ba5d367f1c6e334f10f61cbe3ae81268826b6025396e73f6a3de2c835a15f57ac8e1992f1a46ef6aa9e96d77b37aaa24ebaafb3f1d211d2204562af188492c537b314dbd7a8c47ccecf1b2b692aabcd53040d19c329fc1e856057dcec0fba97beade1beaf9f253280e519d05f98bbd31e87170a7e186d824966710620ff1b3b66155ee34b42f4e4a97f12248c8a1fa1fada70f95f7d41348caa00ad2c56162909a1092b4e69adfcde429a02109b4dfc91aed1174efc16e79c72c98906747aa18f0ea877bd7ecbee871987e1f6aa8192b3e63ce4dc14f5e596492c74419"),
	})
}

func (s *drbgSuite) TestHash64_SHA512_11(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "307480b232f51a42fa3a342eb8af69657ac0ebd1552585aaec8b3e88b0165263"),
		nonce:           decodeHexString(c, "71cd330614b1e942393c58e3bb65c2a2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "545c5d384388091030791a107c52f615cfbcad977123c426de51e990617744be456952bbdec541f03fc5ba1ce745d2545108089492a8154ea700f71ff6b5dce1ff718368bb28e3c4df7c904dc9d11a10732675bf3aba0c1119ee56c3ad2ae3e67b75748ef0e4ba5c9102f0c7fcc83afe78ca19afa8446aa41172e1e2978923d14d7027f80eb1b325b99bf4fe3318b8f5ce41ff7687f075902a0ac5fb672b6bf05a90ac5dbf15832cdeaac4c562b7dcc58dacc40c5b859cf47c9ba74034cb18fb589babc40c2b4cf62eaebdf0c0f6143d6a6271f4b0637f15ffa18943c1c97b14061de36fa52f1237b0ee868ffe8615d9084437948ca0aed845c2b7e9d7700bdb"),
	})
}

func (s *drbgSuite) TestHash64_SHA512_12(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "285278848f83eb2976183e15c93c2f8b9f99b35cc99f213bba0c7d772499cdb4"),
		nonce:           decodeHexString(c, "f5278af81d428e5f86eb8c8bb430c468"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ff6eeb98c17f76b293dfe58b2f3ecd9cacfdedc9656459fbdefe21c528332ca2622caa102a24bce8c5a1d86e4c2c186de72519c6e0249cc153ac57a196a3eba5e38c7f1a5251dda339554460b0edd7e6688ec4b2bac7615623a85b2dd980f51c50182058ef28daa38ca819e7f6bcdea908b899934bf9717ffddb85e0a992787e30a920d6c1d01d5ffa6af5ac0b4cc9be59f3537352d92552903971888b0eb32100dd8e4a3192fc180ac0c49f274c8f52061fe42d2f3db5135cd5771cf20cb0abe50512559f7a775072fda463c82b51bbcd79e1e518860fed4c463a7ddc3fc0f5c29e8f82ef58001a1afbd73c404e7f93a5266c26cc8dec0445482e6d24d2f340"),
	})
}

func (s *drbgSuite) TestHash64_SHA512_13(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "7badb80300f7b88022a593cabc5f857877e4544cd8aeefcb86b5d35e524e6e9f"),
		nonce:           decodeHexString(c, "d5374c5187e21547541d27c67722f497"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b1791685a44eabdd6f1f65e428e2b943f0e5f1a9f926be96d8b30c089971dec6c5ee3431ea654fb5645d2e8f54b6dcee3d829d6f27b11ddc98d4337e1420d85ae6f82971a5fd6e4bede7d2a211da0a88e7f95e30347aa8f824dd7a7bb08f19bccf1f3b2cfccb37022344aca75900c868da52d251b17d9160755ba26ac5029e4706cba96c9c30199635116916c508095b4f55e6612386eb3740dbebedb085d1d513cee5eeff03d8e2da492d2c5a5016fd6af571013a59c4895769530cbdf820c88618b59153cd839049d0a587af9f2ac5f96bc6c0b3bad00bfc83e164d6d54e86585cc3c292d2e588b4217739107eeea6150efa2aee98565451eeddcc80027e60"),
	})
}

func (s *drbgSuite) TestHash64_SHA512_14(c *C) {
	s.testHash64_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "471746177fa3ebbc1f1e06fa42d61d5d491abc82eb7d66e749b87d562a7eff34"),
		nonce:           decodeHexString(c, "42f8a1ee9b09940e9e1dc64f51a78b4b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "238c9889284139945e657d2c4312ee3ca2013de69be10bdc8b90d54867889f2c15c6cc933913457d4f5a00bd52b0216d90c56bcb341dde7496218861b083f80d8c933627e19b7bd8b73d6dda1bb0b2b0f1f90e2b453cd063938cec3a08f34e5581c1322329d87709e552a97e8a8c8e8e598a5c5cd6623ad1eb9f7ddd12739b1d157b1020cb8cef19402938d31b74e490c0ce75a9f57a17476df1cffa55de73bb8151071edf396c3b9e4607b07c7e2b45c249f5a8194cca1e97af78be47cec0ab0096cf588f3d4432393a8f5423a165d585e2e5f98fe47510d9415418aba28aab1193261036214c35d8ba04650b4539be6b9f7377e3c75ed236d0e69cce004906"),
	})
}

func (s *drbgSuite) testHash66_SHA512(c *C, data *testData) {
	s.testHash(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHash66_SHA512_0(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "67d492360c69fd41aca0ac52f5e2ba1820a5e73fb5fe5dbcd00bb9ea05af0523"),
		nonce:           decodeHexString(c, "5e7d69e187577b0433eee8eab9f77731"),
		personalization: decodeHexString(c, "22e4e18124ef50ae514d5146479d83f0be23c5c4df4ba208e5e5b3506d3e104e"),
		expected:        decodeHexString(c, "f7aa49abb823c6c41e99e782d098821b9f4029790c701d015b356a1b7c655ff1553180e20cdda09c82864933a079cb81ef033d356ed011ad2777dcca17666127c230198c89f1f372fddb307614d062187f0b4099101617d5c2e1b4792b1d91bf5eec60ba1dbf20e7b070379c3a097a98a043a583718101c052f29dc281d1f666494e11d5f80cded4e6a9385143d0bf33e7d687f8204cc97f57d9f0ddfc205a8efe2787e8f49575ebf83fabf585840212dc6fce1c54df92608b01e7d36538d9ef2b8a6b8910daa3c8ccc72f284cc2f2573412085d232e29eabbe61b27eaa2ed485059198d0ae57bb35a7fa66492c12e782c5774e1abeb202e0744e9d766f2f133"),
	})
}

func (s *drbgSuite) TestHash66_SHA512_1(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "fbf07f5125ca55031fda59f0c0709c58db66e58ec199bab56ab0642366225993"),
		nonce:           decodeHexString(c, "4a5c510b0831afe7de48dc135df7b01f"),
		personalization: decodeHexString(c, "f9abdd2ae83f55daad43f94f3294b5c3e3e4a94a0a46dc37876c83a327e6897d"),
		expected:        decodeHexString(c, "223fb23049250be1785a7d89fd0d472214d560528bb98d9e65fa3de2d5bad182f6c960b478562e74408755c4586f9448ed5a4802d0b33d42bb5362008880a82ff662535aa5855f1f0b82009251086a9e0c555cb0ab279c3ebb8c3afa2b2e674cd122c605856f9a2f404c225119c4e46e890afd3ba54548f102bff18fe4590e68c509c137096da4375ddebe8c57ef34150d536d24aa34402a2a17a10b1e06d300cfcad63d3bd788c3e13734ede9c6311f1a03b5bff3d2412de8e4fd116783d8af69cf481a64f461f9d2f80169f2504c1597af0066c4273277a26d11e58fdef365f902c14b72f426c97b97be16d744679636d943ce319fddfd15eda8886bfc46b9"),
	})
}

func (s *drbgSuite) TestHash66_SHA512_2(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "909f726634f77ca65889f92331c3d3f5a8fb677dddb8447995d7a0d0ea8bcd33"),
		nonce:           decodeHexString(c, "0f95ca1a3a1dbd5110640b07fc3188b5"),
		personalization: decodeHexString(c, "dc7c673317e8074c4400a4b23b7cd617fcaa14c3e2c577da0445c888f74c1f65"),
		expected:        decodeHexString(c, "328e94f4af0c77914adde912afc2e7149b438dffadbe65f2b9b5d951b790ac616633d5fa98324631d542ec52129c6cc3cc3c90bf76f8dc916c3f5849d459036f98699d86d4395bc435c5e64c51a1bdaad35bacd9aed2748fc201358efa6aad0c42d675fa00b42553c134109faca026697080a9cd8c47a34aad8df0b70257d6705b91e5237d6ba29a19f17ae358a38faa28e0f6315bb9102f67e2c66330808b97e46b98c3d4f0d74b8fecb66acfc19974588e67e089a0a7f81933e8427b17db4fd3cf44d04b6251131330be52e2f924beed7a3aed905178732a5bff28fb7387b438cc61fc47cb6a7f143475f12d06c80066178d1d27882fc20e90e579fb30a19c"),
	})
}

func (s *drbgSuite) TestHash66_SHA512_3(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "1cf9663b23982e38ff659f30f152f4fff812d21c565de45d1ae0ccc4473a36e2"),
		nonce:           decodeHexString(c, "21ed13b5925fd53b016a08337516157f"),
		personalization: decodeHexString(c, "923a425b4b1f9c1f7406ef300d09ff05d9a52befa2a2f55067ea541816a1016a"),
		expected:        decodeHexString(c, "9e2dc48e266427a81d4bd74b802030748e53b8a0a76010fb76bb6b612cb6bcb76902ddebed71fec51caaef13146455b01d1e6e4bde4fd1d57ae9945374e0e4bd7ef78dcdf9e23abd86c6dfc013c49a211878ce1d3840a0263aeed12266542eb74df2a13542b681d768eff64e1725e209ce85e9148b47d50b7435065d760bde93fb6b6762bf8b260aab6ec38dc43a24f9816052d23f669c84ce8b6cb323949a4ea2d1ff9f4d4a356df45cd0235883d30068837f3fca8ce0430c0ea7e97e873a8c7d6b0894d6d8e20c0f52e4106d19af83a7b3540a9b20c099f3896b8b009e89f76cca8127c04c3c34371c04501fd03adad0f81b7e742705039332fad327ea0eac"),
	})
}

func (s *drbgSuite) TestHash66_SHA512_4(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "adc00d4f536f383b7df5ace4eb9548a5febc3e9c2903b53f88ba0be65ae6204b"),
		nonce:           decodeHexString(c, "6a39430795557e5188c0d1306614cf71"),
		personalization: decodeHexString(c, "a332597b684c8fa2b5973fd526ffd55c99fc7e3416395794fb92aeb6aa3cf878"),
		expected:        decodeHexString(c, "0c28bbc89dde0e01a853433536a54891e6b0f9e4066ee5eeff40d48c69d49280072302982aaab83a98e486e68888472207d51bb4dc3b28408ed04996045c27e0371ed0d09b197ea733fa32e67bfcbdc537d8e576f1811e9a44b63e400e06024cab6c42ffe77ffb9691f42871e7fed672de1ace37c241d49b38ed2bd53a6718d9ce385737f22e245146781ba0d6d4ec0198ce963072dd4aa085065f27965d899ebc10674f82bed0a4863441aadbcb9dff6020fabafd3dcb147f20814933a7f7ab22fc375d7030b2ffee2ce3298737bbc2c549ccb9c10dd9c9decf58896e3d8367882c89b90738923f8524004b7ed5433c28a9546ceb7e34864510f46f1bcb5550"),
	})
}

func (s *drbgSuite) TestHash66_SHA512_5(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "8d67d1d0a85764dc1534a1177cfd14e6711171682c9ef5f037d2318bdc02d55d"),
		nonce:           decodeHexString(c, "4485e5ec300e024d7434ac8012291e82"),
		personalization: decodeHexString(c, "c2fbb8c66e89908561af60bd468c39d2bd5ad4a66f9a8dd08185fab68644862e"),
		expected:        decodeHexString(c, "edfd24b72b3865e61915e79f3338ede16cc8e46cc8a694c52c491b981ca97bb11be78d3c30ccf03c1b03a7f7335b9c4214f362d437573362273d15240579ce2aa8745ef8fa4dda78cb3e939793e2fef43083bc699e56c9a7352ef14f12633e4fadd1a948afa08902ba6d09c494616f27e1b80575ec8720dded7a4bf4bb1fd0d9552caec2b033fcaab937ce7cfdee8497c7a0d3eee81969832cc8eb3fc8b9da97ebda4aae4a85ab99a0a9a09982c2c26f67d81dfd6216a76f06f50dc7286b83b9b54b79b5210aaff61bb8dec5cf670bc2d647fc3a126a4283d724d8a64c919628d1b97278bdd5de6dcc5baa6879ea9645b6b7720239eabd9a71df1b57cea0bc2c"),
	})
}

func (s *drbgSuite) TestHash66_SHA512_6(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "eebca3dd0a97fd507b9041e08a23a07390e009a4a2551dabfac0378704937f3c"),
		nonce:           decodeHexString(c, "727db88630875d690eb62030399672e4"),
		personalization: decodeHexString(c, "55c4f548879f4ddd11d44804732bb0a18c7cea3862f0ec7678eba8c751d75cf5"),
		expected:        decodeHexString(c, "753723803f7005d26b1bcea4078bebdfc5b97dbcc62386f6c79e5b51df4b6902455ebe8b5f12e1220341c0dacc3e07b6b8355c3f372abbbc04e6a5ac72ddc0da1a32031b3178e6332f24eb0a98ff12a550a3bb8ea052574984e19b5a60a6dd7575e263be1ce9c26ad7251df75e4d49acdf9ad7ba21a75e156b7c8eef7cd77559200e22f573858b8485ab1ef991ba7764155da74b96f36157a23a3019527e96c8312dba922cf5779f23aa64f1860dd17ecfd82f37689f6fc618d204325cf4305ca5da09ad2eeba06884ec1919fbadd6eccfbc17dbc2337fceb88579368e0f305d70469f8e4794f513c88a096d3012dd43fdc1179dc27b8c1569ecceb3a0f5d44c"),
	})
}

func (s *drbgSuite) TestHash66_SHA512_7(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "8268ec3826db5adbf921e9739a05c988df9a28e3621a68f584c9fc4292754275"),
		nonce:           decodeHexString(c, "ed90c6b8824a0617f3b325c3e3900def"),
		personalization: decodeHexString(c, "9ce84503c8ef7e8f238c98d6bc9278c83e1f00d0d6db677874878d711f3662f8"),
		expected:        decodeHexString(c, "7f761255e03be3b9fe8cfb2485ec0df22b954bec934f5b48fa64d63622d4a80197e9d8bcbafb181296e569f0ffdee8fddf44546a5ecde0d6812c9800903249cd23781769b1d2477d1afeb47ef07dcde6b9505ac3ab0ea7bc62220cec17f2594c9922b4704d7e1054251667c283622d5ff67446a3176a39bf5dcbc229dd45b71d7e71cfcb04dd1aa009fb5c4e4eb11c20b9ebb6963d37790d079c51c05ae169a9df659ac2547dfa1988ef9cd7def2b8cf5c32d8ea47dfe900fa97c40bff96ff4b7d1a3b2b51b34ab0075d32dc9e8692f9e735f0193a54d598879a311f066b0aeacbc0e4bcd709a3123de58ed71e6db6fbe4af3d9beca6fd4c018cf5cc1baa3533"),
	})
}

func (s *drbgSuite) TestHash66_SHA512_8(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "6ba76df39a3fba79b29ead091c7b7bb0066d71b497b58a59d4c93eb3c8db902b"),
		nonce:           decodeHexString(c, "cd24098e11d97aee427110bb29fde68b"),
		personalization: decodeHexString(c, "ab091ecbe6b462a79e11bf0efdfcbfbab0604baa1a4d1dba1cd2e0a1b691313e"),
		expected:        decodeHexString(c, "17f40c6a90ea77d29c6ce0ae5575baffcfb79d5ca15d70b2b1fcdb0a88666335b674ac5fcd48becf72be1f8a73c55ba60264c2169b68fc3a1f2dcf99d9b5176200fc66ad498ede17290f562a0aa397997a0cdb72b4936f1a58b335fa1ab0ae9362e0cc11e6adfb4d41aa4df6e2a8da87bfee28b7bcb7deec686f54d5b20087dae8d995e065c7d3c1da4c5c7b99fda3a7fd0a5e2cf6f471fa8cbcc700aaad3463640e9abe9d4465fe66023ce80b183cd1647f4ef527ce26305d43d480bbca239fd8210f09df21aee1ba40c07f05861b23cf971c0a056b4326479d0ae03479ab5ef19c3b735602360fa1b5df07385a1c1e5c509c3b4f55b398981ac62080595637"),
	})
}

func (s *drbgSuite) TestHash66_SHA512_9(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "e048a1fb7d64b7217fda281cb41776a2d4b46de489b90d5f9772dac5477956bc"),
		nonce:           decodeHexString(c, "5353abb44215646a8f7c05eb53c94a2a"),
		personalization: decodeHexString(c, "ce0cb9f85badc9cd5f15e573a99f00a4060b66d5ea00dd77139b95468e8ea82f"),
		expected:        decodeHexString(c, "ea23957103cdecdb012b42012c1b10afd88a028b9559be9e7e3f1897dafeaf4f8e5f927b93b5718a3127b89ac84544bea9424acb4f06395def1ee054fe944c6339a8484941aaa5c92beede9cec976fc4167b1d0d0a29a63f59f54c7b5ab8c87b6ae91475ca57bb11c0dbdae426681e2c1261983252fad76c51acaaef65b95c9854778812f0bfb6e6abd7b8d17e99cb63a8ab4e6c2498fd12ec11fa7baccfd9a6f1241d65d79c2db7070b3a5c781a4fa119c1a88592c8995aca893b18ad43bff40c1515d18407f34e1eec70547fa0b0d25e1a2bb7c31ce253b2fec2771c62ca35936a39be7063be5ef934d4e2e7982b66ad8ea6ed7bccb664ae2494f795170cec"),
	})
}

func (s *drbgSuite) TestHash66_SHA512_10(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "25409ba4ab52a0e452e799229cd057bf06704578a490c5d1e6835fcf542a7768"),
		nonce:           decodeHexString(c, "eb75bbb6f4578a1152c0fcf919f77625"),
		personalization: decodeHexString(c, "1fb58175e5d8cc325bba59fdba58fc8c2a3f81a178e606f381c32a54e5c94765"),
		expected:        decodeHexString(c, "c156c12387a228b4d71db7f4be9d58b0ef09a7989cf0cf4f3b0945cb872c45e07b8129c18bd407bf27e83b2dfc24058c83f96bcd2ddd482f678102bf17ed0632c7321b66d3f1d27364d99db713f5d9e7e1347096eafcc46efac0acd96bf0c3971bd862c94af3e25cda255bd604872f565374dd03a37105e26a5b7f456cd36f22af3cb979689745c72bc1eda048912afa2b13346a819bc9809d80b4b1288ef8ade5d2db60617d89a66d63db70cd66e7581594670a2c60d591c578f6683e7b952047943795ec3501fdbaab4ddc3c075cde070b5eae9d0cbe76c039ee69ac691a35153122dc03b3657fedba475d3261d8a989d7fd4498e0e47d54d091c83d11308e"),
	})
}

func (s *drbgSuite) TestHash66_SHA512_11(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "d819597700d01af57ab5bb0d684cd587315da065a308dfb0819a297bcca33a5c"),
		nonce:           decodeHexString(c, "2a350973b91e7fc46fe8dc948e04b1e9"),
		personalization: decodeHexString(c, "d644aeea2ef1aa8a84b44140b1f293fb6dee3e786acdaaa0639ce5d55ac90970"),
		expected:        decodeHexString(c, "c9f229c3a02de30395f9b55416cc4b81ca6ef2668e1d611ab58b1c8254f0091d57a808da88aa816b0901684689347fd4eb2da833a48be4140ad303735210f21937c59fe4b5601a5df8dfc48e3bc2a2e1330438646a946edaa60aaaa6bf942efdf03977e48cc6c24e095242bb9ce8e10521fc1847f57df099ab5d13901e4230a4f35c0d6c02b851607d5f9f9908884c5348eb64817dbcc32b0ecb9887fd94272ca5d8ba9e7d3730fe1457fcc8ee00b4ffdb0a184be8db8aa3ab97803ed95a2014133e5e0d00fa5420668810c4a90966ac63e0d780474f6adae9049d9446ad2a7eb1bca57e8a5f47649dca17d29939c8862e0a2ca63298744069cd1b410a0d5bd4"),
	})
}

func (s *drbgSuite) TestHash66_SHA512_12(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "cda7b628ed5b62786f6931c1194ef7dfa888a3b81991c7f5f140f1c39118a801"),
		nonce:           decodeHexString(c, "2061ad369e7cc487dcf0ae6192dc5b42"),
		personalization: decodeHexString(c, "7e915dd5000824059f6165d02811fc38fad6b954f8b168d4822a45302f356615"),
		expected:        decodeHexString(c, "c3a0296844d24b4f0e43120713a4cfb272b40f01d2548f296645c0ce3d8c5644077c3051cd882aff85e692ec111008f46473abfa461dfc52ca5e0ef79cf5489fdd16a26d9f1b9cbc00201720ea3dd32afda2b09777e5bc78f8b345f66d317bd9edbd0d836c8bc1e8cd5d793d0702f7eac2cb51562c2ea2babfb220234139e3ece41e9000212285fedd4863a9c4851cecd4e1c17a5c364dc650411aeba5089b88ca63d35ca4bc4e4f1d0ba31b3f4c890a6e49f90ec7e203ac84d627361e5b6c4e31f23e72b93cd4e40a7d284442e52f0d8b1444c48c70703f12cfe733240667aa2c77958783490df8b84a0eeef0a12885c0765e36af6677635ea30542c2f5f43f"),
	})
}

func (s *drbgSuite) TestHash66_SHA512_13(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "8e3f8c69a382e524c4ed5ae465cd077b2541ab17efbcbbd726e3a93cd7be34d8"),
		nonce:           decodeHexString(c, "dd87a12de5a73084da6760bbfd1aa5ba"),
		personalization: decodeHexString(c, "5ac9d0b995f41bb75cb0356e54fe2ea21d65db45f19b2a0f5135b6b533cbc34b"),
		expected:        decodeHexString(c, "123f7e607e4f02ea8eb5dd74660a9536056550377b46bfe0815aafba7578c3d30e750339d7f20f240b5e6e2e2cd4eec10983f20e09772e904dcbab56306eb99f7be4f57b64c3eec9a78be8149663096e9d6f7946a1a5f32f2eb13c580dd6d52c7428d4c4aca1ed77f8c9f303111961d0e2d61af6bb76920101995b2c633eca98affac8686ad66d37d1af91fb6cae8132857eccaf56f6e87179279306cdf33260383d39fa19872d8385057bc386ad8d3599a7cce183997418e7e249eb71e3c0d11fbd048f88bf1d997560df21eae81f35486481ec58414b2f7acfd0a6a03531e3533ed67e705894797c1cc4be841d578876ddd7287e0ab10f8e0790f07e078efb"),
	})
}

func (s *drbgSuite) TestHash66_SHA512_14(c *C) {
	s.testHash66_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "c88a94c68f5c6560d90559173f8b9fd04a83a0f6578b22f057c781408dc1f6d2"),
		nonce:           decodeHexString(c, "8680d7b3f0a8ae576bb0f75364b463ea"),
		personalization: decodeHexString(c, "c0bf8f2ca4efb48b8dca73ca7148da3cd5981c5a459be32db5a14fc7762c68d6"),
		expected:        decodeHexString(c, "269b3b656e58f9aeed32c80700d9d1b863b0253b3b33155cc0849efbedfa51cff82262c9342cff7f1a7a58a5954fe66547baa1831fee55ae0d322674c6c784095f43b30c1887fb9fa5e7e7f1905da2808ab810ecd224ab403b6f562bac54e65cf7f0473991ce7d7cbc1a669a022fde3141a9880d974b7ede2fad24a3263570443cab0e8017d242fb4c2032dc8be56d8fc1e0e8f92254c7480e4941259ecc29ea47a1d11e074148b259ff95a94711d767f0655f1e0574dfdc4ae4f27b12015af86aefd36f6c10056c3d83e639e3641cdd8ba178f7779dcf502bab3d7588cffb72f6489981aaa7139c255df0e76bf6bba32e4f547327da4597745b15042869b2c2"),
	})
}

func (s *drbgSuite) testHash68_SHA512(c *C, data *testData) {
	s.testHash(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHash68_SHA512_0(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "e8347c69f4cc4d35b03fe0f74d38a8fa1dd57dd7a2a4272684a4823703f9dfc1"),
		nonce:           decodeHexString(c, "bf28460d47c2457b173c46d5853a8d54"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "aef43abba93dc266185516f1ed9ae5267016ab2502a0d1c42c602d1f12df539d042e2f5cdd52e4eff95b8a34be363bd49cbd3bce2a42187a2ee8d1af5f77b29748f1ad692de2f28f57cd312bf0d2a1b7701ce14ebc11aa56367cf6ea4855c4ae4a3d8e686c748d5c9e9e62926e1165375935605566b4d98b378ec42bad973a002f063c700930a737e8333227f0e612ef84989186c9859ee2e669fb259c30778c6d92d1e8ba0883ddddf0517bb98144a481d8016567866f91847bfa964367d28930ff3a84c27dc7fbdf8e449122e6d071be26777280a48d362e35b364cd816d91b281caec0000e7ea76a87bf3e1227d068f1fc3fef2ecee337d970cb08847ea13"),
	})
}

func (s *drbgSuite) TestHash68_SHA512_1(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "becdef2a9133c89941bb031628a42315247b63bcf47d0deb982a75df98a17ead"),
		nonce:           decodeHexString(c, "43c77151d200f0988c040d4665268f93"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cf13657fa184a2bf7747728e66813c3e795fd9ceb80483d6a2cbe25577eccb937b195059df92a0e5613263167e3ddf097a5bf77b223b2a63e0563adce0fc1af09cea497cc6717f098a6f85c6a8154ea3855477ece71ebf723b466f1c8bf3f56f2e28f4456750689a8dd73e73c8fba35f1d1d3dae80d67a2ddfdb7c6ac7e3a91f439eeede14cf79198354d9ff47845bf684da9a7a47f51a5ed3232708c0d78ead7be463a5d2c35e0b7b74aa3043d6673c5d09c98f91cfb1c8d3f9bc609d40fb8084d77c128d5abc55e2cfc5c1280a612d220af2b6871555c2c5290dcbadd96a01c67e1c953eceb6d305e48354f28efd21a1a7eaccb68825ef2ad1249b573bf39b"),
	})
}

func (s *drbgSuite) TestHash68_SHA512_2(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "5591084e26463aa51e9c8b3bb653ff3868e2a2d89589abc93a2e09a9c2a065bd"),
		nonce:           decodeHexString(c, "39e3dac5749bd0a8046e2f0e32d50ae3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1d2dbc3cd00c8daa226746f500d2465feb8fa97566630b2d9a9e021b97cf1924e8137c64d5311bf82bf1d0ebdf909445151ca627497237b9f121f265b2ab304a5b2724355f63556a66b3a5bc9407c8bddfece164c38df52a29f656ea6c8e417aa752e6ea5c37163bec602a40446e41f138752d4562b5426fe5f85efd76f3b16e271de6ed2d52f05d3a896b7e490f5d1a98f8cf9816c5173efcd48db8c8573c59738ca6fd48950cd421ffdebf32b86683daab770d88cc059a6cf857c401e29561594e85e5a3191cbd95b61815a934fb0f0103d4ca7a176488780cbf100a473bf94a80a8e40fa65c92db33706f0f2838aa418ee72617a3efa902b2988483dcc876"),
	})
}

func (s *drbgSuite) TestHash68_SHA512_3(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "070a1b7af0d37c6a26a7bef39a44fd37b736f665a9623fb1fe208e52e2bf23ff"),
		nonce:           decodeHexString(c, "0c3b6a5c15ef557e5a9272e7b5aabcca"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "62ed333f27cb9928f5bae6631be85d4ecff4c893bfc38880ddaca7cde714d0c203c2ae162aa8e0fdad445e4e81c34b96398a0fc46c6f5d94c61d2ae3632411540c1689eb0fe919f5e6c82a9892ac03ca55e2c192897f676c1fc1d1a4cb65b3d4bb957ef2f7aea1bb2ccb7951904bee6c3f6eedb99f02921e08e62c7ccde1ceb7a5b20735a3233ea1cf09eb8b2704d630028f81bd711baacb4b09e6193d65f11a3dd9e5c536a231d6366c03431305f790b121845038ed6c762e41841b938e21738e7f0fab5a189eeb34adac6de4bdbe9ab9348d4d5c2cb61406a31c224dd8aec8570c87cf4c75911f3316f95a921d9c6a90ad3c494dde5028eb9d66177b0d3658"),
	})
}

func (s *drbgSuite) TestHash68_SHA512_4(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "28e996e15aa02541f781cfd86ab9ce74724a3000a22a70d101b900303848692d"),
		nonce:           decodeHexString(c, "d5c4ba58065f6343cc51d9c598de26ad"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "fc684639d41093580a3d31b4fea1d92ce92cf67a231c16c634028ddceebca4a754fc19a150ba618cd8c77c98e0b107ebe8402068c14779ac184ca7d506679b2a48291785a47c9a07a09f8bef24afb8875452ff15c96351a07ad7a5539a14d578cd7e4be6b9ad5c2bb8fb8087fe82b13b0ff93be8847c4790c7899203baac4050c8be7936783cd5e7dd3cb0068b8b41ecd246b909fb80083f0cc378bdbb39cff96611d51b3e94df7dfbc8afc4224af1594a536f277e0d3c34e8f08003989fb8f2d18c0db3d7f8ab08d1c351ebd24d39f9be002980b88f3917e68891e1d26f775ebcf960d1d9ec0348d8404cd86838c76bd691ca0160b57dfe75cc717cbb9c0195"),
	})
}

func (s *drbgSuite) TestHash68_SHA512_5(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "21bcc39dd3e90e5a95b4056e385a1e7644b96e629f51b1e5f030857a9bf3c523"),
		nonce:           decodeHexString(c, "0090eeead56651d1f4acb93a2640d9c1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7bcf06841db1169aac8d0101240b4face1c11ec4dde6307df08de7b3d817c36b550fc86635d6921f93e2a39f395da6bf09f3b4ebae9272bf8e85c4e564c410aa09a4904bd17ba7200165672d64b1e6cf49cc4ab8483edfcb60e898f01584917368d380e00d5a3482a0a68ec673f20c03c72ebd53027cfd367df0b00d513dadb70da739a8d28ae4800fcf129b5edd33a87c0bba39c22ae192c2b19529f74ad6ad00e39e5bb58a09cba331115d538a70f09d1b1c95a0cade85dd4b61d224edbf7f26ba347010174cf244cb2700999d65cf8394357b3ca70e323c7e1509bef4b97019db32be0d91bad8ac2b4684462d3a6f6022bb30e4df1b299bd0bb24af338f73"),
	})
}

func (s *drbgSuite) TestHash68_SHA512_6(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "53773445ce198107882c7714d361ac0484fac8d5aad4be7f1b415189beae6777"),
		nonce:           decodeHexString(c, "d0349f351ed59b8b1625adda05f99c62"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "97443cf87445d4b7b36da5efa232b21b293c59546fdac531f98a1d76c219aeb046b7f190ed5ff5971ed7a62117287effdc4e1a692a9bb5067a733013d0527fcf5c85731aa61dda10a7d231ccf01c2fee79bf511dc01f5561b3f98298662ff3a74ea1d57170f322a40caaaebba287bbe150a22087cdd902a741efa527a372610f3bd7a0f2c59878c4e95b57b5b8615d4eec128ef009de7a5db2ac6177eafdc1f153b70a0ff60168d185b626acf4ff4ae8ff47c88eeb1fa41eafa36d9dce7d782a7528d1d676f9ee7848ce19dfabe5b24f395184112f6bd5c50e451ed6b6dbb7165aeb82d5100d26e220b7eae2df912aedb69990c3603df39f362aa9302982b980"),
	})
}

func (s *drbgSuite) TestHash68_SHA512_7(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "ff37fa0b66c83c3a2e2452068d13bebe869f7488968b518a2cb2f4836ce39f05"),
		nonce:           decodeHexString(c, "4304b9a6a5eaae133b2d42e3c70deecb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "240b7b7baec7ad9cbd2884b27885484f4ae28778f8b746701eae2217697d5fd2eccf5ba78c59c76f75e33b2f93d84019fced311cbf153e843c9c1aa257bfd67fedc5682f912f64aa53bf95807f1024225542c661370457003b748529ad4a7f352535cb81632bfe4deb1781c94feb943294bec498a4f69ed12937bc751d135a937b2cac9f946bfa5025f4b6749ba412bb4e80c7ac07e2c66a1465e8895d40f26533dd2c0677a2bfb4f140eae18f95b789bc5dbf8634e2077a4c6ffa02f4d1757951b04ffb85bc405414317565efbf0a17aee32315688084ad72a6efeeaf2c793821359604aba2225ce7b5f9074d4842b0971cb6385be332f74d6f403ba14c0cdc"),
	})
}

func (s *drbgSuite) TestHash68_SHA512_8(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "8cef16d1b9840107449d2c00d44dc14012d0dea61e7c8cb04ef5ff8d0c9be9cd"),
		nonce:           decodeHexString(c, "f65e96812c6b43723777fdb77434232c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "de1aa00b946a9490c9313df6d3921d2ce4b86d5130742a8c0bf5763e81a562972d9c213f3b91c2b02ac06fb706817e642d6766d644d907dfd0fe09c8bbe760fbd8decca95208904dc6bff68b757d1fa1ff850eaf1447a7592ddb5e81f295f5f944e18dc620aeb96eddfb7938f8a3531d74a78df3e8db6cbd6fdc4365fdde3f2b9839e020098467f7be7a22e78f322265a3e01b80b97d2829aa2a17c56ce45006fff89677bc7c9c6520eb7568e1a96e3473d7d60ec2657a640df820ba63a9319c8c09da22a01000ebfb7cc1aa106704b2178e9423036378e125b2af7238ae06a0907e0c2ccc7f0c053e3ee72c79b2e6ddf470de452a2f4297e7a7f3582ee818d3"),
	})
}

func (s *drbgSuite) TestHash68_SHA512_9(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "0b8b66c4a6fee647cac32bad5a11d98a86239059082cbf4369f8266288f1c169"),
		nonce:           decodeHexString(c, "73eca8a8a3bc1847bc198dcffd17425d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c39a83bcc27acb6a436d7ed496dbb7ea17bd7d2daa3f4f7d5228ecf6f17fedb4d1c425128606b9188bbdeb80a10b9e4df8453bbe1d9c193b6785dcbde3a552bf0affc92f57427d8995c5d03b6f71feb2357634e93e85cc9907bd5528258d54db8fbfa8ecd5af5a3a675916977d6bef69bd2b25f9ef320684c3c0fa49754933e84fe496f61f9efe0770e3e3d893ae081ce347bb7bd3540402864c31305fed1ca8db00dc2a2ff820fd131a7cdbbce1aca08f9ca08edafea299b3abea97ab4f46a76ad3feb34a8ce72de0f0ef64ed7fa255ec92b12bec61621ca6492b63e76a975b72e59d2c8a070a15e7641d0a0db40772ee005a7987798dc59d34c7615b38c3ce"),
	})
}

func (s *drbgSuite) TestHash68_SHA512_10(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "8faf72bd73374b5bf519417ced57dee0bb01c571d1548f7e2bc46195e21d768c"),
		nonce:           decodeHexString(c, "59ab29dbed76070b9258fc4222b181c4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e946b4bee41de29082548275ab4209246c2d07508da801725f9daea8fbf9b3384c535be59c6e92a3c582f95a33cc9558255243169d0498c6ec2131e2c2be93ff9d8e0a9591d76bcecdda03b40aff3d5a001f4a61147294c4192e4a7cc90f1f57d1797271857f5c5820ca89d71c485c7b78ba1c9335d35f2c0eb74ad94085344df073b6bb4a950937bbdb85a33d3339d0b014117974c0e546ac0d36a13789edb31fbbad1eb0f36cce6203faa5e5f2aa8e15cc32fc473e4dabddcab3b856533eb45bcc7e3ad2ab4cbbc08f15ebce24f4f4ee0b7e096b6a27b59165584ec362578c319aa66e8a824956f5f9401c0c026d8412649be75c48d5a9d9d7af47a6f3f293"),
	})
}

func (s *drbgSuite) TestHash68_SHA512_11(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "651779d201cbca886d6162cf5a4454fda9dd98918fc7c42aeece0847fb51c608"),
		nonce:           decodeHexString(c, "1dc96c75c0a1730062d1eb4f6bd19f06"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ad9ae444f5fb779d3336322f2af2956b851498e71877c506f8124c772dfa27f86a9fdab8b5e88b39c204bebe6d706bccf205a8524a7304f2a982341b26240719cbefca0adf09a118d447c173622189fe710dd272d9b10cb89c4e3b04f8729f664ef657beb1f6c3b35c580caa1ab96d3cfdc774633f29009cb2880f7370dbfc23c56729a4da86615e70bf378fa140512c056ceb417e5d8f0dfd498fb6b2eca31eae755bf0b67d30e132ebc22fc9e499aef98ce64dfe18580112d7fb16fd21b74f579d082c8f11bc10c3ba4471266eca17620398b81341cb8f6e9362afd012d94a8fe5a40838f5177d6990dfc236dec5aa6fe3fc9504d3e35ea9cfe62a5e296db6"),
	})
}

func (s *drbgSuite) TestHash68_SHA512_12(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "3927db9cd0fe4551cc89c5f4503e7d3238ce1cd674b9614f5ca5166eae69521c"),
		nonce:           decodeHexString(c, "d5e7c45dc3108368a22c1d449e89b084"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "953d87a53e3291608727b17a9a4408615a12958133ed6ccf0dc35b4c27f7c64441e795c08b2e379851a95bab9d83338dcff384011ba6de3a61b62eae465d589b705482d5fe8697bc68bd061f49ae07749e2b259f6d96d40c763181c6c6bf71d89ac22f59fbedc82e63925a2068e9a1ce3243899a980c8650ebda07cd681fc99d0e46919fa379eb84443427208a5f173ead9cb75be4e2a89a16f25c632ef4ae3f1c7819ff0d6b3cd204fc98ae489a31625194e30a4edb5a57aea04187823fdbbfcfa9d5d4cb0ccec5a10985bf2cba6fd245b5cbbf4c8fde250d02b3a7ccb7ea2bd043ebe654eaab650c97c8394f07088037c9ac12d666b7686b2f470eaa690216"),
	})
}

func (s *drbgSuite) TestHash68_SHA512_13(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "c7710ca435d5fe4b980e2aeb847b8073368a1e41ae2fe51dc5c76a12aebf22e4"),
		nonce:           decodeHexString(c, "10db159ade08e39ec81ee8ecb87c3332"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7129640f6dc744cae4ab716689bafbc55d198c8e49e53b22eafe7eef106e29dcf9500192f6dfb9a709a448ba391d46d127028ab01a7bbc614f93621c10277ad86aa2e1d9c77b34849c3a082b9a28aaf27f13894f7472cffacfc33b5e0f9f60e58b191ea710bff020533a60fbd110808af1422afad9d35fe75cdee60368920cd27a2667e94d334a56ce0ad9cd726a9e7af237b5fdda0c457d42f5400ae94d0199cd84bbe54cfa709661b5714c2f7f19393bf0ef66c17fb29ed2f4c2bafd1bf1a13121c0d43747d9f549939e286f7c67ab8f9c13f140dab49bcd402fd107327340246365341c4672a5534863676ea058d8206c25645424b688d8fa9ed6f8092c8a"),
	})
}

func (s *drbgSuite) TestHash68_SHA512_14(c *C) {
	s.testHash68_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "337373a24fe76f025575b3dbd7eeedd03d3459d6ef44cd53335a9c4963cc45de"),
		nonce:           decodeHexString(c, "ebbea7e8e1a3a45c58044b65ab7688b9"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "21ae4510a133fa0906c873eb73e00d777b68a45a1de8759b1497f5146f0c45cf612b02e972ec93ebccbb85c9adaf0f5942fcfbb3b808482f05497f2f4734dd6d42c8413e1bd1bad10463dd4b4cf29f1662c15efc6d24955b1e54a60508d9ed008c9d29f8a6bddfe564c21473271350137452f4601179af37e19d553ec738539cfd7a8df17f07e1f9db5df776256e3c00199997307de394a8ba41be2829defbd8105fcb3cda215219fecb607eb1e7137a29eef188ca7eb349d2d1fe27edc2526ccc6d8f1af7eec9c06910f3909907f966d5904b32577f2715cc32ac08f1b5e25a734716ffddf60c57d422b515ce817b605ead2f875db7a789e351b660704f0cbc"),
	})
}

func (s *drbgSuite) testHash70_SHA512(c *C, data *testData) {
	s.testHash(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHash70_SHA512_0(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "817aeb8122d0917c53e8418ac6eee6c99dc3b481c9fc7626bed01285aa54ef5e"),
		nonce:           decodeHexString(c, "90e1381793a3b028c0c5e449e21bf95e"),
		personalization: decodeHexString(c, "a955157f807bcb16ba6f213ecff5079081b361877db855d6e3063482307f7ed2"),
		expected:        decodeHexString(c, "a5eee0d85f5b5e3dbe452549e2dee5c74f56488d4c64562407818c70ddba651a4600bb83d3ff8df38f7e862e86a6d7461f1e5e422042b9b88ff954710d6848df69b568ea50f24fb3f8d4cc1e31aa8e6662b8a0a147557122aa771bde792c4e40d9f850252ef9fe36d273298d1936a64377a24ccfc9f4dc26967fd7f91479193ccfac2a5486fbada7db2beafd8fd516d800bdb2d88e18770064757fe1e14a65ffc9577d5fb262c8d2e394a27d9686e1d353f12da21e65a41a4076275d5a9beaf875f516e6f27aad0e85cc3315371efb33fc3f10cfc97861700bcf3f8b2b561463e443994f7ee1b2a29aec92a0e0def2fa397e6b6f04634d18d93570abc2dd0a5a"),
	})
}

func (s *drbgSuite) TestHash70_SHA512_1(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "361bc3f1939172d5a0e3f20eec7d26fb8966ce4bde21cb07fd2eb00b0b9a6169"),
		nonce:           decodeHexString(c, "e331cb224e5afd8e7af80bdcf66d24fd"),
		personalization: decodeHexString(c, "b045395a04c8c66daa3a64dd7427e3ac7551df67083bca9c6e8ccec5de93d746"),
		expected:        decodeHexString(c, "5a75fe2e7277b2b82273321f9a94b6c5e0ec72a216f7dedb67dd78a1a4428dd083f48c4929ce7861641191b00f91a1a56a2c280b3da234173377401b1650d3b92b6799c5e73236c7630b30421a694448aadfb7a2541c514e061f60e11814e81f982486e26b14b5280a620434802c8c0e725f18316c8416d9a77e682111a1c6c0d3ed8341b13fc3f35e22e4e8686cc870f61af68d650acaee8a4d5e85293cfc2385dcc70667c753deef62c17ff1a69931b5f8431bdd3ac22e04746b380dc78bf3642dfb9cc6e67b82c3bbc9160e77cb0556515451b4ad1a212c93724f4eee95429f60918e4ed8710b94ab63f2c4b106aa2fba439ed484e7ae8b36cd8c3b0bcac3"),
	})
}

func (s *drbgSuite) TestHash70_SHA512_2(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "c22d5e0d0b90201476f12ad0a5c4a6f825354f20bdaa5a0b0fd66cb21ebbcece"),
		nonce:           decodeHexString(c, "9bce3473f1b59d0f2d9c330e897d043b"),
		personalization: decodeHexString(c, "7e750fc176910b54649685c2fb32ac230477d841798976439a4818632ae27723"),
		expected:        decodeHexString(c, "016c4a3de0558ab9ecec3e5c5ffa2c006d2ff2ab05304a7c7ad2acacae941d005e78bebfff592cc21e3cf6b190085835530950bd2b66225bbfb926f696223b8e8e0c78f317b927786fb5902965f6ec1753e56356c5c08966a670a34233f7481a4c15fa68fa79d4d6869287e0c1d3f53682d78c4c077a440694bd9d4c328d37ce794cb207222b1a70cb8c1a56c72b362ca91f78e91feced6b899fb56031e11095eed8c13817df532a06b5177566e1776b77503099473e21a3672dc6a29b959379c6ead06e0394790d72fac35954d81b9c5ea16a04125aceb1daf85f3a21e0b6eed54fbe641c700934575b0be11c7257a7a80d66ff50ad6d610e5a39d37ace782e"),
	})
}

func (s *drbgSuite) TestHash70_SHA512_3(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "66665a56b7c7fc57851475903a28eba6294c8cfeb267164d53895f167e0868cf"),
		nonce:           decodeHexString(c, "bea9c55fa782318c31209649338066f0"),
		personalization: decodeHexString(c, "cb105533e41126fb2a824c036b3cfb66dc114be8b409ee511c9ffed0b45da084"),
		expected:        decodeHexString(c, "6df8890f9ffe35015b3b4351a0520c266499fd08bdefd474a2fd77bc8483382ac46b49d3cc7cc88aaf728756651b0d4d8ca7eebd2f1d9c9c2159f62781882042c9258c59e7e50bffb58bdcd1b7b3f218efabbcb9f2f76c19fecc2fb3487c8f675a0e3b297c3ebd007c478baa815443cbdcd67ee1fd6d16b746387b9193fc5530157c0bb5bc34205db53084f0af81dec6024acea4c445584e8c432231f224a6ce0d659b25a887e068eef35e69497faae09dd554b323f417a3392799618f524dcad8b75a30fbf8ad131aebb8abe383ae77fbd91b15aac7719119fa4aaf9a091735a8688b96a6d3bc683313bd749e4a3d7dac3a1b4d68bf446b74bb73584a13008a"),
	})
}

func (s *drbgSuite) TestHash70_SHA512_4(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "7154d7c79e3c5d084f35a935d75d4aed9f9bcb2e38b48502cc6aa12966fd62a0"),
		nonce:           decodeHexString(c, "4eb3709e8ddf142c64aae00a6cddef64"),
		personalization: decodeHexString(c, "b0a0eb6a778f3b8a244de21607362d441127c80146c12fbfc52f71f71cc37193"),
		expected:        decodeHexString(c, "159c424308885870464bca92fd917fbfb96c0e7c8e8d1f6f6f658272d6749bcb315bc7c15e20f601f9ae4110b153bf011b28de19aaddd3186b6aa2b9c0975486dc534ab06e19276cf92fa3ac8919fe4344b0e02967b2ec6130965daf4700f9eada02733df2c4e0ead926f3f69c6c8019b1eec72674a617195a8fefc769cf96e7576134cb26d8023a5b6ab96d58da2313699a75e2e1fb17386e5cb1b38fe435c2768cdd799fbbcce67d0dabfbe42ea12d50dba80f20c1de1ea8abbe66d9d3bbfddbed6db7dff72e2c596f8f70a5d0206fd041ed5a20161bd8c7550a0929b5e35cdf22871c25ee0b92e284f4598f92e348ea35ac9e4a9a93d67619cb1628c149b7"),
	})
}

func (s *drbgSuite) TestHash70_SHA512_5(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "633a7564cbc72526d5e71718216d07768be27580711fb84ef32e6d7b06f47549"),
		nonce:           decodeHexString(c, "ab841d51f3ab6a5242027e823c5c7038"),
		personalization: decodeHexString(c, "be890eb2e33801fa2ef030d719376d69fb57ed165a176b743853538037e57c74"),
		expected:        decodeHexString(c, "b8740ec92271e2730aadf58fa3f0a42a1e9b1bd131cae290c882a7cf27762e0208ad3e21963b7622b9329e68ce1fd2db7c634b51a165601630957042e3795704834cc64223215c5ddd877b9be7a6cd1a63c9c15fab52018bff5c9c9e5c1181314c0e3318b98b6caf828cdffb2af6997ce62a598e12d4e7bbb3fd5f40a2a6ad84e4d10e7d0f68cd85e231d2c21a65588b571ff272bed2fcde15566caad4a76e4c273815f7dc883d4bdc16a311156d1f948f69684bd5fce7781439c28cce3e6fb40f9c9681a484f0d5a072b486b85b3a0ed5670b0d83dbfa4350a3e9422e2527789bf6f1df2c4cfaed345fee21b6e003c61097946506fe7e8318a9b12be6aba2d1"),
	})
}

func (s *drbgSuite) TestHash70_SHA512_6(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "2ad728895a8e9a65a17f4c6bc49205353188f771ae113028a60292a7937bf7a9"),
		nonce:           decodeHexString(c, "b67ac3e318d1ededd77c50c9543b23fa"),
		personalization: decodeHexString(c, "96a4faf4462a176345e48ddbde783052a733c1fa15cc42f9cf6b84a3cb8f3c92"),
		expected:        decodeHexString(c, "6680b2e8b1e88ab0e00eb80c3dda0b14d7f02ba8e4daebc698642623ae4699cf5a4b9e428b165ef90026d33a71d1cd513a5252d600b0dea3f436e2263663fcdcbf36e685cea6b9f684530780ed3657f9af4e3e1ffc81c1ce76dc731e9b3c1e5a88a36c9e95c3efb2a204637b3d2ed94a3bdaf9155230f6287227bcb743fb360c33d059b39f978fe94216a54e39d5e0f0490a42107390271bb6d10015278bc6b50e79b95b76bbf27a2f37b2afd5da61fceec5b484ea74d6cddb34ba5c2736ca9b7ad0d334e3ba596611d224a7c51ab4777cacd4a9bbb66c46b6988ae03c1fbe8f60c8fa23ac1689a85a19307c98d149f65b856f2d760453bf7a1c8041b948affb"),
	})
}

func (s *drbgSuite) TestHash70_SHA512_7(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "ae6ef33071077fb24135ebf9120f795ef6aaa3c8505b8d3984b22880e385f49a"),
		nonce:           decodeHexString(c, "715658156bc021a4bcd193e5a2ac71a5"),
		personalization: decodeHexString(c, "8ab53e1458fb557964f0f2402da861e632393c1affc3ed324d4b6dd8e65c584d"),
		expected:        decodeHexString(c, "fc8781ba00efe3bf57d7beb9c1f25a604bdf45c15361ea7f742dd976781a9cd422a7346e5c9bcec222f53eaa53230c63c10a5ce2daf5a7069d1fd2b9dccb4c57387f6f38c705a3bfd3f117f9ee97079f44cf5f01d64065f5fdd9c4a3a524d3fbad99b67ba5f8f99cf91f93a662d67267f3c63ad9f0831b9a74eb7dcf50b0ab8c1a29c4573eb38ab556ed76f5304dc96373b9785bce9b30d81135dbcd9bcb5ec67fd72806334602124a2cff24921e2cf3a499922ede97a15eb066eefd2c447f5dbed7f193567ad4c8e109d236d01909291e118c938aa853e0292dec054bd40194ae603857355807c2e73372f38a2d6f7175850a807e798daf164c9a668316a6ba"),
	})
}

func (s *drbgSuite) TestHash70_SHA512_8(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "84418e25f9d919c1e4b2e599346c4c0e6d56baf450d297863457a6659f40f8c7"),
		nonce:           decodeHexString(c, "3101341550b803c626559bc5ad77b629"),
		personalization: decodeHexString(c, "0f876d2e02da0970dcf0673795862666a4915c0190cd7dcd5e30182aa3640872"),
		expected:        decodeHexString(c, "8aad39bbcb00432b9beb63a88d2ac3046286980a079ba0141fc875a837c120734c50f15e7e7248c14e13c5c8daa2dbd9a03de205ea0c00492a48cebe8a995c60d051f396447c3ee4c74f5a67fad6eca4d34896be95bb28149c293939b9b86e734e12ae18f22acdae026a9686aa4e7ad373c93cb5f9fa9950cf0a70a870fa49f79885554d015e603bdfd87a0a5f6a9cbe3c719d692d10f8c8d2dd10d23fd94866ce2b2016acc22b08e16d4ff0af5727a1d4fa29dc0bfa53d506de7def8f140c5c8a0922415207f4d21ffd2c13da38e21c7071beb5fe340492c545ec6e6d942403cf32d32b3b17f5c966453a9df28597ff3a8594a37a17929d2c759879aa905fbc"),
	})
}

func (s *drbgSuite) TestHash70_SHA512_9(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "298dc1e39e49d3b43da34126df0542194516c00e4be461cf43d946e057c70df1"),
		nonce:           decodeHexString(c, "9118a385d2a8d788be53ad4621c42554"),
		personalization: decodeHexString(c, "147cd977a6e77928fbfdc29a6ad3ca1baab50c84efd592498465346d5673ee62"),
		expected:        decodeHexString(c, "3a1d7fb2f86ff8921aea91310c61a1613d441402cfb71e3b78da7f811cf249f280742972fadd78f37719e37be78ebdebff95e2568951a4b8eda6819673c4872996f1fa9fcbb8bd99ad31cadd795b7e8100179666be0975116630ff55bed336fcee8aba1f2eb8b559f2a96734bdee9474e66ef1f655e4e08b736903e9256b104251bfcf3de7d9c3399b3db824f4452baa487dcbd8d05e80a5501682c1f2936fccd6c500f1d646b470260bb59acc37df03040999f3be8aa705f480a65efbf4282c786df4571cba381389b5c1732367b4c8292f009653cf2039dcd6e0c1de4286f70f821477cef404b8d9a14f65585b8cc177191577c5243434b02e37c753cd6971"),
	})
}

func (s *drbgSuite) TestHash70_SHA512_10(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "4b72ce006313008e8174f1681fe10322bf185f31a8db8736bdef94e035e43050"),
		nonce:           decodeHexString(c, "5967fa9c75a93c0e079ffc562e5fbb6d"),
		personalization: decodeHexString(c, "f3cdaa0a7ee5bbb944fadfeb32f151f76fb666b87879146af06110a2463b9b79"),
		expected:        decodeHexString(c, "4a763a13ea5f1f61fbaeacd3cd0f7df564d88aaae84cac8b342eaf739f0f1ec49c382ee27b5ce07bfd0794f95c015d796852b8f2645bcc25d70a1f4fb8c1f2e042ec97c120d26a89c71b6d2123076afb82978f59c57d333e5a5710581d8695ecbb8734c902b3a0050cdeff4f59316fa3201a23c56d38d4339c635372353105000062259a9700217fa70165de95794bf8d3081f4c7b47948000a77cc787f39502c2ff2cfabba0b6ef7f52f6e6eda41d7646578bb93e5753c1541b6eeda7460acc1c5be3fe959ce709aee31e025bb5fb7517ddab28be4a725af6c94a3bf06f2039a8e3beeb224e5aa50d068a9dbcdf0cd461c65da1fedb1949832f3fa1bfbb6efe"),
	})
}

func (s *drbgSuite) TestHash70_SHA512_11(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "2b525261b3c1978ddfa0bcc4ce9e825778f6ab04563c3a013c1e38e69aba21fe"),
		nonce:           decodeHexString(c, "f294648a4acbec0ad48e2efd66c55a58"),
		personalization: decodeHexString(c, "fea7926f3aa3338ee68a9e6db66ece6657bb35a274d79a65fe51e2be3b87b37e"),
		expected:        decodeHexString(c, "60a2de6d286227c08602d2d0bc76b4d6b12a5d5acda5862cbff2443b63ad9bc1320d0864b2d3b63933ff323f8ea9f815a28728c7effa585a8f3a33739941f1ead91b1f045c2ef200140c317e8e6c6df67d951b607ebea239d5c7c2a9d436aec9b571d6bff5132a78e4c915a25448c1aa12335e80f9c1a34eddc696b408996c6f436e7f641d2ff391cfc85d395ed3f183c506c0bab8083e6ed8e704e1cd8eae8a990930dce1e5d728d98cdd034884390e521f42c164b784ea031132f5153e3ebf04b82823441688bfb05cbf8370fe25265abe08d088a9235c7657a53de6dc5142c0cd422deabcc6eb79377c733142e686cfe7be4337ef75067c8d191d0f950e57"),
	})
}

func (s *drbgSuite) TestHash70_SHA512_12(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "5580b093f694f090bf77306ec904c026b66579f3c51102d3b19babc68e157ece"),
		nonce:           decodeHexString(c, "ab7257bd6e808ef2474a487b628ce94a"),
		personalization: decodeHexString(c, "a79c6b1e57b7512b5c178003eefa6d03f3916dbefd9a39a2e1c5a564d0bf18d5"),
		expected:        decodeHexString(c, "8d7a771fc0a8ea899f1ef41f03feb7ebe947f30165467f9a5ed8e5ac803f7f51cd05d9168ee95d516585cd6d6b943a2093fef4f7a863bd25efbaf6dc33d2a484157452b68cca3a4f50221864905243bfd0f027801167a05244bc61cf263bae21283acd89954800f433c38f3a90e768d1425260eac41f0128807f750fb3fad302b4d1a052c542f28ca04440aa05311b48f4796e09917e3907a984ffb0dfe58ba1a9227999f6fab97280b44e3e951cd32ad49760e83dbf46d28ab7770980feb177c8ccabc8cd1646aa1893000ef3d3cd5d8b7a3080d9b9aeb19378f5a905497794842d103c48957434238d8da01fa89d4bcde7fa3af48b8db062243049d58fbc65"),
	})
}

func (s *drbgSuite) TestHash70_SHA512_13(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "ab21771485af32348fae88e1cf038cd60e2c875a8ef7857f5fc1bb5a432673a8"),
		nonce:           decodeHexString(c, "ba5432bb86fb476f8b70533f304c94b6"),
		personalization: decodeHexString(c, "c0bf62619671a60389e72da333e230a2af34d5594bc844d3b470fe3e747ce9c5"),
		expected:        decodeHexString(c, "a326ae9b147b2094fe07651f32021c5668f234e062a5b90a96a225b2ab0e0fb92645db0ddf087c920d829c06449e2cc497d7570408d80614e7d60bc44aef6f3bf89b850db6e796b72ba4d8586493028b064cb80094911e4151a57634468f1e7055957d40b9520a0d27fd7f99bf679f31e7c94f0d25de533862071b48f84b63879801d6f6ce2e2fdff1ccfdc17a8e0d97d38568999230f716b8b66d00a6adeecf1c72518dd66ef054df6e57d28d1cac28b8bb3544342a1397f89107b25f0668d2f733a288d52bf877e5ec0c807b9cab3f924f48d90e399e7d35ede45db2210a06f38c26f81505c5284ae38757aec9db48868bf9daa7cf784a7b09767464a6dc1a"),
	})
}

func (s *drbgSuite) TestHash70_SHA512_14(c *C) {
	s.testHash70_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "155c57577074e6bbbc350223b66f64bd6fd4781d3feef2e6811339664f59b9ee"),
		nonce:           decodeHexString(c, "78e7f6e9e8e1511bc0ba7f230b65fe47"),
		personalization: decodeHexString(c, "37544eb1992fc569ff259946d639a00230ec1196c5565b8f9da62d9ce552e09a"),
		expected:        decodeHexString(c, "0ddbb84e21d4d7110b933bbeaddb35ad81dc1f331ac8293695b30924f2713eca6f93a13d520da4486f32a12412a927d00e3f27009a944056a5805b0e050f5bf6c6bd32c523c1d607d6e3e97b59fd059a610d664396f69961599ce7f0a0cbd1dcff15474ac267e36c0b871c559fd13b7ff0c3fcc11ff8dac26761a42697c3744981cc5c5ac10cd0f3b285c4ceb4a550ecead095f90fb6f53aa302218ede7ed5ae5deac91a83f957d15ee901746d11777b23c327ee811966690f5f253c7c314a2bf2bea73ca46c6c8cc332c3493f9d023029d762fc90e5dddbb838f2225c521f196332812570a17455b3db45306aa9100ca83185395435137a0b961531cbcafc03"),
	})
}

func (s *drbgSuite) testHash72_SHA512(c *C, data *testData) {
	s.testHash(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHash72_SHA512_0(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "0f025f0a0226f2157269122d07a77a57ad00e0880c1b300ce0ccaeec1050ee45"),
		nonce:           decodeHexString(c, "4ef3654c08e3ce4510e771ea7d031afb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "46c8a4a0802b7636e92c51376d3b8c028804d6e296cbdc01841f3c3f753c12b52fac5a079e58171c1b5764b4f7036c2c13ad66c2feb8e66e9a3526bb838a7ece35701e075265333f7391c01132633088d686d3fe6e8d432d26d0bacef5bd8c66c9543c9b3633c5413343458129f6074ec937de6a27b7f3ec9b17ffaef9549f071888304cd0d8d103b922ab835acae44a4f9fff00465344f214e21bdeeca836858c9c38f651d24ebc60c2aaed83046ab1660f0ebbeafd955b681cedc3b77c89954d8f3f6950f614a6db70a4fc3a06c262cc18d47481dc1a0cf3178be2a2173eb565f9a054cc14f27fa436ff4f0fbc94a0dc013f0a358f55a0bfe4cc223ea4db47"),
	})
}

func (s *drbgSuite) TestHash72_SHA512_1(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "c5c141e969c34cbe958f7f7d9265dfa8fa7f1d4c861b059b317a078077bb8687"),
		nonce:           decodeHexString(c, "fffe17bc7a56ee1a19a19a0b12d7e5d7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1655f23d48cdbb733e14cc69c1da950fd14406d92ce41bf6056f83cd5503e5dff368c58991365223e202e0523696c67bb985d94d161ca124e7fe27230b36fa580c9177cef6b0725ede59068264e68b9826c32b2c8c7e442a55b78b4ee9809de0e391ed7fa60af03c96fd6868d307e6c61d90ccf6a6814c02f8641fef75008b727d73fcea92c9fece1f553d8936f51b8dc6d6736e6907b74ace32fca7963fc11541fe978173629b4aea86bb84624b5d4ded151fd64856226ffc4d37dd254263d7a8fb4689273066a153686852fc0b0d1f6781d1ba209d5238e0109b899c0efc75668f94c71dc9e68771ab11d3e352625680a3f5c8aaf7a144854c7623d6fd7275"),
	})
}

func (s *drbgSuite) TestHash72_SHA512_2(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "fea87fefe9eaac7ebe0d77cde87fd40e84354c06188d5e077058c685bc7a23e1"),
		nonce:           decodeHexString(c, "e4ee2c0d6078eb436a063662130eac45"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5c80cea857b936bfbb882e3a58e7df17b65a49c6bfcb1f183ce96b74eb53319be82afb8371beb9458167186228f1b5cfff856b1d5648693a0b99f5d7cff61866be763154d489d60e0c7dcbbb4343e7c36130cff9f787ccc7c813556e6c5ad7fd42ed2bdcde950af5c6a4e7d1d9d1918cfd28f0863c8163a044485e29bfa40078844a321d46b4ebbab2cfa7447a6d9bdc819bff3d8aaeb99e9adc55fae6e3fc89660926f1e37084dd94107ae7bd6a256851fc2a351ef2aaec1a4a709ff48f52715b74efe37149cf98055ea2dfc0a3185fb7ba0d24adfdc00dd13106edd78590b80ea47e865d17926c228cba1c5fa3a188b7dd892c8947ca335cc56d42d564cecb"),
	})
}

func (s *drbgSuite) TestHash72_SHA512_3(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "9bd21ef53f195507c8efac8bb42c22c808159bb2d504c0eb38b6664fad9c7f4e"),
		nonce:           decodeHexString(c, "39baf025d0a74e580bb28f3853fe0c8f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "13198fadcdd9487dcfadbcbd1c53d9b5313170d1d2a4596f1c1b945ac7381a71c7aef8573ba5d2d5d282b3e1b9e3f272d704e17655665e34d14df14388604e6f30d92faf9ca51ce2422f028004e720b62c4f700052a387ca96a16b053236940d6a1842dde5df8fe68595d1038b82ec00743c4f31539514dacf58a8ed2aea0e0414b7875aa6fe591cf76e14653385c674872300441cb30a27bed8b036a0ce9139ecf995cd66dda412f4f8053e48d475651872f9ae89b161cbc99fa3dbf6cbaa2708b02afa2cd69737562fe86458d78821df77e6f82741f9dc56d7c0c806578f2459048b890278382763292eb5b07aba1eea365afb704d762057154a551f0736dc"),
	})
}

func (s *drbgSuite) TestHash72_SHA512_4(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "a2903152c9c4308b8c1a52b3d19594872ae56ecdef67c6aea5a54897c3862e5c"),
		nonce:           decodeHexString(c, "ca79f1cd283a142c7d69f845ec4686fc"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a5f63d837a35bce8285e26f239a636bdcd220a9558f6ab809328df034c28cee1904cc1aba40418027ed2e579f84077eccd3bfa5ddc303b9f29dcf2afb138b17768d3b0356c23496de614108f54d6a8dd38d060f69800cd5ec5746f7249316f84a5c8324a33035e3d585871bd2908dcd5f34288a8fedc8ba6b5fe89386de39e8d186a71203b7e5b3b2a7a95348630e61473d01cb38a36a57ff7b1d7518ec9cb37edcbef4d81f4b2a75ca75ef79abfe1377fe678c53a151cde9edbad14230f5e0b17be4b253c473c9f69170982ca8489d1439732f0a912c24ed0445f9ee9da76820ac7c95855c6c4ebd668d684768bb9e411a2cd6658afc50ab5ced87799ed3727"),
	})
}

func (s *drbgSuite) TestHash72_SHA512_5(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "81df6214fcd7c04e1a5df60114bdacd850fd9f08ab6da2663c49c18c3f3c2b19"),
		nonce:           decodeHexString(c, "e64c4fbc5a8dccc87f7a16ca23fa24f5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dffcb91c73ffe1ee0864224faa30ed8698a3e98783366dd7292c9208abf7ae0d0ac5253fb1e604cc5d6ddb80f3e2020f594025168d968be6c623a46d7a2830d8f7a12b505180a4556ae7c0119d87e3b71d75458afabf0d5aadbfa48f6dbcad3ff27904fd4c258ac0c0640d283d3b73361d1dcf69783384dc1a771fb586a7a8cc5a879d36bc4bbff7380494c0f8269cb8f02217463255d19181353e13bc971d1ec53a19f3be339cb17498ad24289cfba76daf1fc48f2d10aecc110352b940e947e445a332ff3f2aa10661b708987e7fe6037a864e4b30c03cd2c3d8a1265de30b823d9da470f900e0ae67ed4c4172e0c6f2de34345f43976c521fc84974d8c616"),
	})
}

func (s *drbgSuite) TestHash72_SHA512_6(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "34d6a4b0707359ad99f66be8fe5c6ef3667ae02c4dc8424ba032c477528d34de"),
		nonce:           decodeHexString(c, "e0ad85fd0473022ba066300963c0d6e8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4c356339929f1ff03ab48f19d926e8bb58fb594cb0c8e7f309c21fef97b36f3c435167ceef664eaedaec74bd3665e007ce9d9a13e1196f8c28b67d98f447937ca776b66b9adac014ca159d55a99e0607195ee97c140775e7e0321737072142f9caba600725c6b4eddf7013e71ffd5371972be82638a3041ff3bad3c75c7db30cf4b6383dcb5f8287d31864d8964f23e5011d75f6af46f83735209fe564f7ff16853855ed773f0584b658ef94b8ecd61c7da95ca8f2f755401048f795b6fb13e2baada159a07457739b0810938e306c88c28833492435b09c3707e21a07909d7fd05dbb903013f1a85300aa6ddfce2ddb99e2222ab64fb86b466b6ea55b3302fa"),
	})
}

func (s *drbgSuite) TestHash72_SHA512_7(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "6c8a323e45d62c399e4bb39d7ec415da5462320550352b58d750a08eacd0e0c7"),
		nonce:           decodeHexString(c, "a3777d95021e0ec49284264d8aec2841"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d7c0d66f844dbf8279033d55e909f1d31c9f6e6fd58347c7145d8e5930db54bdfb42c89177165d54f079d4fe16ea5f5111fcecded389c450a8fad22cda5afde70d24935dcdc76fbdf161bf24f8cdf6f2408d0790972d1df2173c641fa534a345b6f234abc0aa1281e2531442c3941cca77466721bf6178262cf0a97bdecfc61fcd14a8de7efb9ecc14718aaf345d809c8bd39b0746b6b63a556d27d0a56d8fd0d8edb36288ef92bf89709a36d1fbf0228066b67b5a9991edfd75d47fd6135dfbeddb2ca36dfe27a5ca31bfd24e3e4828c876c8721d81bd2ef2291061e3c9419b3121d557ce3a34c429ebd070279264f853ad256d09723613d1b21d26615c5dc8"),
	})
}

func (s *drbgSuite) TestHash72_SHA512_8(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "bd16765357555b8bcad0bcb3e7510f064a0682c2763b35235e453c3e03f1cd90"),
		nonce:           decodeHexString(c, "f8444e16c867bd6d0c99689b5fd33c6d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e19f0a6cfffe8f1dab321e63650288aafcc689d730065d2aeafa2db661d66a319d9ef454d87b7e3d9df89537cf20d735d6cf9812b0db8db219a1abc1c8a40ac60e38e3e0a2de494dd962d74d612c003ce333e63a40c429201c373c75e7abc505cadaf13274e3e9b1cd3f0bfa5b3167598b24733ea6199ebead46bc6f0e1ed2bc3e246482ea141ab2cebf4c4ff1faa5c30da19a60c3c9b11e2b0f6259e793120c2166d5826e2819ac8d5f31b5a2574263201e21f5c82fec2b6f396212721c0d9ebdcd75b0b1f2a85bf9d9098a1db35fec6b46ace45a7674c272fcb7d33da9d857eae0ba8c5aef8232c3b877847eb8da6ed363e93cbc20f906aaed7d3b402651ad"),
	})
}

func (s *drbgSuite) TestHash72_SHA512_9(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "63245db20f9ed7e9971d11411d8bec7dd8c619c186aa773bd1c212688f63f1a4"),
		nonce:           decodeHexString(c, "8eb298afd828a37621dfcebc3953207e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b39dbd68fc00d55e6ea223f3859f657f4bdcf7485172620e9ed64945228cfe4d2045b141372921c6ff60db2c368a953cf28225ff9e9a2adaabbdd08bdf8e1fa3f66586b46568062eb1c4ca38e16ea89ed4357ec2d62396ac71537ec19095046769d84d15e5f8551ae94769e023f5053e5fb47672b8ca87192327dd21b7610d90cb534e3eed32d6517102a6c97e70a63a3342ad6728db1d6aecff81982f9a3eebb905b1cc47d597b393934ee2ae4f78ad081321fc702477a0e0d003b2eb46ed8f1d5fb934139267b0dba609c45334275c88f7c3d38cd601a42f3c7e79ab7a65614214b1980b53ff54ebf845430d80ead61cb31836de61984d0213d6a4f7e58d02"),
	})
}

func (s *drbgSuite) TestHash72_SHA512_10(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "4b28b3e591bf4de102f6059750fbc3b257013a5ee9acac70150e3e69f8c3e8a7"),
		nonce:           decodeHexString(c, "d48010157a266089207cdbb9f33417dd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8db6436c2222efc43f8e654376a997b545518ebed313d56e41ae2c2106479d67c92312ac1932a2fd34e35f21f3334b3af34b82234f7a7f8edaa4b21c2d91ca62d01333e55bab9a6c57fef029be043a1700851c4d41e35d667e4ff828086fc0db7ba7be7119c563189078c5d44e779a6439b1e03eb99da3ceef0b251b7c0d9b7656c4f31298a8927c36bf86d2692cd3da393fd6c05461c392f32a20f904fa667007770cbe34c2308883819006f8cb4d94e802a7d48d7c4921c33b713b049019b412df375e9c1fc73b52fd2f4142f41bb6f4d081f11c51221588a44640d0991bc0f2d8f0c1934080d0c3b22815f2a8346567aad97c2e90448f496e25178bbdb095"),
	})
}

func (s *drbgSuite) TestHash72_SHA512_11(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "46bfee256f59babf082172c127bad6c765abdfe7697bb0c5f2fccfacae6683ad"),
		nonce:           decodeHexString(c, "58a5ae0bce251f0bf90a8842dd492c76"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6d0fe78c5b2520222cfd07b407f6a009316735d845a2091a2dbab1881085f45a45111ddcc9c5533b26dc40fb357d5937866f834df38890a00f986d6f4438114fc1a922f0f5a4555596257a76a14aeba3b04350cf96f511f9d95d3fad0340e87c9aa1497a54e76a831de3569b8c75a343e81846549d4cf9b22060d3634c23563a11acb1002a926d236a8b2b0987711a1dccf5c9db17992379937e162d60586749a1fa30ba55e98990dd2de252a7b5fdb69fec6f0f275f409e11fa36a39eee404e19f60cc2308834d83e031e0936833f001d4e0ee8afd6a95b575675a63209054780ebdf0e6a9975a417c256577538a960cc9a65ebd4fd05550c28ddb82283cdbb"),
	})
}

func (s *drbgSuite) TestHash72_SHA512_12(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "e6d74ed56c614d4f7ad84a483712f2950d1707f22fbd17ba007574efda1bb907"),
		nonce:           decodeHexString(c, "597476f8c2399506ffc8a4c4a8cd6c35"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bdcd77917724d8343827fac4df8f6bab525d32ff935fb8d907cde66a1d75469c9095b8227b1ca1e32242e5330184ee4dc3a26d654e4282cbc3f60a6a9a0926467deddcece4b4bcac8c3cd4ffe21c1a9613dc985b09bb36e14defeec022b5c067ef37fc94fb4179b598eb5e96ac302e17832a6539c1d5fba1a229bc88ef02758cb7f644654f3860f70965af024037320a1c4839fc267c54b10c1a4aa91d0c04fc6122ed28f6ee4d20eba4af2512c898ef9ab35e09f754d1fb9baf9256961b1814abca124e439b44245d3558a3ca6bbdb7a01df7875a9553428006feb85a7194029d578315f1b2764e6586e5800cbf214a9eb1237c183882671dc1d545945d68eb"),
	})
}

func (s *drbgSuite) TestHash72_SHA512_13(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "62ed680cb940790fa4e83c5bbe1143b8b8fbc1e5f1325adb1c58071ebc5d5061"),
		nonce:           decodeHexString(c, "963694cc9244a17afe30497a06e3432a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8396f1eaabd07b55c64ae1b70ac585fdeac582956894192d08291e97441eb1e7508b00caa5e75a4d29118e3d9d45313335fcdefac07953402b28c887a0250ab47a85e07368a1468347d4d678e2ec7eebcfdad9133d86d76e7253e85bc9fd873eb3f09a8e77df0f0de753d05eb0b51c36cfdc9c2c42737655719820570884f77d6d35ba232538870333ae3c3f3bb9a9f072e6532081bdb9574bf539dc2a8f7475c4871f082b501ad686b66f4f5b5557479cdbe829e16138d4c4f3633078a59c05984eebc74822ff7750242ae1e27dd43f73073700af07c63d85c8213645243d82614a5f7f7ff2d478c384b3cb6d9c967fdecb0d2dbb5b9e7130b351ddeb64c647"),
	})
}

func (s *drbgSuite) TestHash72_SHA512_14(c *C) {
	s.testHash72_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "5f72e390aa960846a0004d266e3741b6fe0aaac98d9d87b4cbaaa7a2af0d0bdf"),
		nonce:           decodeHexString(c, "2074991cf0c22cd34b2de48ea1f9ec66"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7bf54b69e455c7941e8e24ef59b5525dc1ed3b7f934333713b9dc305dcae2cd1b74648149e04bb4f4e00b110926a6bfead7adef954b6d7e180ff820192677efa3c0c8af6a3e201d8d555cc599cdd2626d8778ea2c7a2a8e0c99e719929ae9ac4fb9a7e5176da8987508d1152909f456a4ce9461188e264cda1c879af1a8cca6c182e73c164986cbf07f441756791fa1fae40b784800335d94b0b54135831044bf0cb5dbb5c0c71de6b6ae33d6b87782d34be3cbc2991ad109d6c0440916d91baf96c4375ecdc9f09dca79671a45309c408062cd08ee623c8de007cda3b3d110425d7e8fee13b2a14215033d9ea2397cc6b5c995f37273a00dbcdf9437bc77857"),
	})
}

func (s *drbgSuite) testHash74_SHA512(c *C, data *testData) {
	s.testHash(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHash74_SHA512_0(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "1bfd7f07f367098d36af5b8bbffee873c007dc0bd48f5cf7c91f8b9e5cef2c8d"),
		nonce:           decodeHexString(c, "2d857c6bd75cb4714b7d4fe7d4d594fd"),
		personalization: decodeHexString(c, "d192f006b0f877fdb711220c5cda3c8e20ea9542901f45be9dfee0f32523141a"),
		expected:        decodeHexString(c, "291a924fb5fc8151c9e94664dbe2f2cdd67716268cbb4a8b04185b09feeaffae5f95ce43b6dced5274e09656b78c73a4cbf20728b23d926908abcd437d121a3fbe1ce98f601b5ef82f4c7ab43750b4824ebe3ef61abb424e1be5ee81b8ae2423f89d91c2066a199d411f22038b44e93ac7691f7d5890b6e8be650e8f00f2bfff54041050a949b52d018c40b92e1d41a1908604a6aedad1c412b6e23f519b3104cc8bc8485069cee56d85bc422d39f6e64828f63b4a15cc8dcc186d2109d8da3758e941d9e69b032593cbfea06b336d24e3f694db5efb1f75a131c8ede6d85904030ad550e3e711a448299df867c28d9cedc00f7a6af858941f739d0318a04240"),
	})
}

func (s *drbgSuite) TestHash74_SHA512_1(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "add7259c467713fc7cdb2d2c75c222c087c91e6324178a5f0643c59ed353533d"),
		nonce:           decodeHexString(c, "7d6c4365b04d1e5775e6d28201b484b3"),
		personalization: decodeHexString(c, "9d03b16fb608c1dcb6b152df2eac6bc9cb06b4992fb7a6c3ff23b16175e64a96"),
		expected:        decodeHexString(c, "0e480db2cba1b1251bacec61ddfbc13edeebd9ee7aed408482c90d49041dbeac08dbaaedd44d93e5695b741a2968cadbf6547491aa9ba1b254353bb7adcb39ad8b037009400e2a7091d03e3752646cc1f1dbfbb0c32f5dbac693533eb8fcb4a0ac4a3ef022859a08497511134300d27c2ae96ae67c4ec2e0930d3f4bd8062bf03018f74e72734ff18d295db4339de172774b6f795507ed5f3c54914b1e561e9d4de15ff2109bec9ed9d6d909e79c32285e63675022bb86b7f797c9b8b4f82b127f3e078539ffcaae5d3707505351e0776696667aaecd2c175605b180deda7f6fef8e89943a6bc6d2d0edd69d64dc82d1c4bb91a7aef9e7dd6b92b5647e29503b"),
	})
}

func (s *drbgSuite) TestHash74_SHA512_2(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "b253f84edd98a84c546c19344f7fe406c106e5275cd34fc54f5c716e975258b6"),
		nonce:           decodeHexString(c, "7066dd73e116f98f1c8610cf799f8ed2"),
		personalization: decodeHexString(c, "7f0970f71af66801d6b2c0192bfa3edc3dc7fc3d1ce70060015d322637c4418d"),
		expected:        decodeHexString(c, "fc53724ca146ed88d58a5933a6a5a8a1bc05f0cda68dcfedfb43aace70066c7fb51242934313334f4c68c63aaf0a7c128e0bc72fa1a9b87b0b07dee4d3215e546f72fad5dd8ffa7310a2b944407c962e240829d7c7bc84add1a1639a439786bce6e5e2d35d8692559ccf4dda107f9c8c4ce1ba204489a4af4d3f6151176d45b365433f0523b9f07144c8f5bd62f8927e2eddeb050b1f94bc659a4b23d7bcdd4b84eeb7fb6e5614503c13540e90084b5cdafe5ddfc57d4f85b87c39a01224724287d567d30c2fcd6dd89b026e969e301027e3f1b80a81cc9fc105c6487760e7ccdd4fa4c386dc08b854445653b70452e66e7d36e44c1a3b6dbcf690f0d621c351"),
	})
}

func (s *drbgSuite) TestHash74_SHA512_3(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "780985ea184a51700b88638f1864f8c4f0547718bf1e6fd2126ee168dcfdfa26"),
		nonce:           decodeHexString(c, "c4f5e33004b3ae055d2661a4b85db863"),
		personalization: decodeHexString(c, "b01c2f6daf9c3def73f437fbd52fc45ea0f230d9f0325598bdd15e81b34ee668"),
		expected:        decodeHexString(c, "b926314f2bf2c1dacc40e1c545b9a7d00e54884c2ed42e4bf6b2d96c17a3932b5d909059f21e3048d40379c44bbb6c6bebc264d169a59aac4165c10b735f3616df0236ef3b68dcaa5eb54155d3a58bc1831a22d55dd2fd46ece154f8e59cafc3008a4a9455a2eed024854bae4d4073147a21abfc0981213aa70ae408406d9f23e8da353fbcaed67709f4ebdb8c1cfb20dc3bc63ae70a1fd89a5f8592b1d2cfab27ae69d626fe93a9c0d3ce2a41b033ecc155afb4a96be6185ae4e5701acb1db1116dae3f41b241e60d378b34c0cdbd1ffb44550308cadc6e418da0ba3e1a356d06dad6d61e07f24e2f885b37f5d587a31f1658f7d2d8e572b9003342803a2332"),
	})
}

func (s *drbgSuite) TestHash74_SHA512_4(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "d1f50d07a46ba5b8b595efd66acabc6b70198f1b65ec4a739f2f89fc0d6743f2"),
		nonce:           decodeHexString(c, "8683889ab82b349f74656c4056f7d07b"),
		personalization: decodeHexString(c, "1788efb9a2619e0242639d39380ba1eccd7f9af6101f217204da17ad4cc0a0b5"),
		expected:        decodeHexString(c, "cc3a655585bbbaa957ef336dddcd63e45cbb56c197c6675e795c9de383d74bade00330599606b9fa63bec1f46ec3e92848b745201ccdc25fca84956e07132de002d8297e7917fe8fc2b2d5693b6c9c47c718de6eab306142be185ce6d08df089046c443827c045c8302d9c0eeec74d519d926f7d64c1fd2f9aed283595be1d4d3949ac1c1af8490f9d219941a16ba5812a8478319462601995c90618ac70873838ed3d4f5897d0763881115162d3061fe7788751736a2e01fa89d3be440f980c60b061e81fccea6a8d3c4317eae0e021f8b146dea15aed73670538a8885dd5049290596475a915664b3bc16f447c4ccf0a5d7d1769c9d1159055af40012aecf1"),
	})
}

func (s *drbgSuite) TestHash74_SHA512_5(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "2e03ac55686f056f06f3e90f4eca2d92dea91e789c09b199651408e121f817a2"),
		nonce:           decodeHexString(c, "d5af61ea5dacb0842ce832d36462b8a7"),
		personalization: decodeHexString(c, "9b3567f32cf3df72af5c44f0a75a176eb7a49e436476e3e8a6c4d2d8630cf1cc"),
		expected:        decodeHexString(c, "e72c1145666da3744344dbee03bf30120fd9ea7e77e587873bf55fa6e40d2ff0e0ae7fadd0ac79ab7543d566a35b022cbf3e2f63da0fd967e09ae0a5c6d32d8a8cecaad57888984fd82a196406048bd0fdbdd4b7bc9e0ee08ea8263924fe0ee4447e0a9de019092b12258a159f20a32c62f5d6456d4cbde3f4d46d60326b4a68a922b23b2a55e7a0d90fedbd171482e7b293150da2ea6e1303934cc09c6d8d5d39f34475d866f449b82586040926c589f1db594a5f94e93b1540798eab92b1771a9acdd92038229386a3fe944ea2166a27c06f1b9978bdb3c6a1796c82f4eca35f54d356b8d6518b3567f63362f73db1f95f9198ddd41f88024a4105598fa111"),
	})
}

func (s *drbgSuite) TestHash74_SHA512_6(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "b08d614babaaeff7b60f30bfdb767cd1ef2117e744ebb40bb0e26ebd780a2f85"),
		nonce:           decodeHexString(c, "f7c44a92685cb9982eb2b303ab423a6a"),
		personalization: decodeHexString(c, "4daf05558ff18c380695d6e488aba4e278b079830fcdf553bad05bba94817102"),
		expected:        decodeHexString(c, "554da4fb08e93dd5568ebdbdd31f22241892e5af438a57e64e494f780174909126c7294118c20d7bae25dc2f9084ac35517f36dfd4dcee58af25a95fdafd2a6ed998c7c41e21191df73548fcc63e61c01107c24c786030ab817005989fa0e7509246b9005ce6bdd4e26d545a9cb89f4175af7ff8c0a1046b0291504bf82d78da3aae30809b402e549f2a1c3a246f927241d045e8589d973888a47dfe2574dd0c9a9e9dfea377937e0fc69e4bf40b6a86b612cea29cce7d41dd15f76bb93eafefc43bfa9237de1167395474d42669f05daaaf4034ff97c410440ba175f4b431d16d702c9718e1ceefe4236c608e61f66cc378251bfacc36606f47f364df48f143"),
	})
}

func (s *drbgSuite) TestHash74_SHA512_7(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "daf400bd2c2f4ec2eb1b5ad2942df95ee1630f89bec55512297c73336b20747d"),
		nonce:           decodeHexString(c, "e1036a0cb21f0316460d607dd43cab3e"),
		personalization: decodeHexString(c, "c5b771c4d77dc827fe0c8fba95e2572871d202628606bf2f9762be02e018c6b7"),
		expected:        decodeHexString(c, "85a0b64015dcb79df5943f856007f1dc38c561675e75721f0c7525dbb94c68cb8187d80ab92e1b318234e3dab273e97db5591713910da80b5222216883dc848eb51e2223552ef0c72147b445b497270355868b9e299c5f647b144e4e270a5478a67b86f220d1b83b1ed4262c4f341bd0b79d8f276396c87639a270ec6378c4d4046512461931a2234b72c70421a5ff8ae234f02a40bb0149ca6229e8708381b8d3b1ed321dc92d586770972849becfdcdd2d44bee53ae4dafcb36f37f2f68670ab266466d7975c1c660b9bce2c616bd06b0fb37e85f988cd21548ee2261e5d659004e12fce1ad46f065999cbe5cf7244b7ee79371fd51d7aa305c4716ca1d03f"),
	})
}

func (s *drbgSuite) TestHash74_SHA512_8(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "c47c748c91179ef923096cbfd0a514089b3aaaae521adef2ccf4e001a70d7a35"),
		nonce:           decodeHexString(c, "fe0756615d0c7cf7da577b211990ef35"),
		personalization: decodeHexString(c, "9f676d607442a3eeb812146e5e61b23e860c567d388130498d109912c444e58d"),
		expected:        decodeHexString(c, "8af06bf08fef7dda378002f9e40ed424110f9316fb1bf2b1bfde0b8d11f5d58c9a38a2afd9e9554b12e3d32e1745f38c6a3c753d7b30d9503c47d914acfd54207dee165903230a8de58b5e9f52f92ab08bc6f343a6176ef45c9d1b22c16521e2e08102db80e3ca1dead0c0216f70505efe869b1b1b441a69b83795847bb454f42235cbbb3e93db43b062d64b6b61adeb0ac8f08cbd3bdbd3c8f41120a2cde082ada4684831c35343bfbbbf33650cc17835246ce2536da3fdea5d90e569175f01f56134f614253029c928c7e6291fc5d96a14ad74a13a2531152994e6044a0ec501d8c301dd3eace89fd876742816985da1cb5d406ae7c3fc576072b0dacdde72"),
	})
}

func (s *drbgSuite) TestHash74_SHA512_9(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "c6f1e5decdaa6d12bb0a89a4f57d2ab2bc4a5acdfd7a0142bac9da1b90d9d29f"),
		nonce:           decodeHexString(c, "5cd1c356950d1ffadfcf6f6b70090ee9"),
		personalization: decodeHexString(c, "db319328e8644fb9bf6645e8eff5181511e93c9b711316744a81ddce4cef695f"),
		expected:        decodeHexString(c, "b948b02d0f6c9a48fc9ebc1dcc399969e0470a2bfe5fc4c977eb4dc4efe25a2a3f78b044679ed25c0ff22c27d55198d6ae674d4647863cafd60ec8cb3a48dc4dd1aac9c71c6cdcfac43836a3a44a2048f4d76a35f2a10fb02ded6e6bd2ce23bc4f759c391becfc5e5d853ba67d27a197ebe5ae254c5af417a9da29b95decb3ca7c6969e68dce0b9b1560274ebf16a69be07b8c4b3f13f62cc86ff69fc1b734f4b0f6e0575eb0c485a65e8a7aca45f9ec35ceb620a39be1f438d994684c0028955cc89d0e4d1ff972a7acfcbf684acde9a2257067f2f3bf74758238812c99cd83b1a3005fb3b179639c2c9a7ed35942696d488e5811a7db3c9b2056ca1adb6ab3"),
	})
}

func (s *drbgSuite) TestHash74_SHA512_10(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "03742b9f381090cef732fb774b73e3a10ddd99f45ddcb5724020b9b63d18b6eb"),
		nonce:           decodeHexString(c, "bb80c667f0a4b2eb8bd51b0008737c3b"),
		personalization: decodeHexString(c, "c00f0fc8c9a15ab7c066bf77e264f1e5b747b91fe6824905caccbb17edddfbb4"),
		expected:        decodeHexString(c, "ff587ca07631eb2ea9712dc7f7db74a0e008afd77804f4016df2efe649dc23bb1fa64059e0be09bf803d5110a027bdaeaa926992402fc5c523ae3409bc99173aecfdf34b03bba173f985d505f8b5ace8df2f8d30524316c7467b9c02b424160e3e1e99972628b0396c24d48665454e44baec91a867d400f9ca4a7da19bcffe1383cac3796aeaac49303821a7bc121dc7cc780b5e90d7f0292efb4e9c9c366ba37f6d857b2f56a395b7a34a07bdc1b6023763d04ddae07a6fc5b5081eaf6dc7e369e9349b5ddd150e29c693dd6ed513305039199b7313d5002d7fffe8d32f1f58883ccab59a48bcb4d25eeb29b540f1face3b3c4dba2731835c105d80edd45d23"),
	})
}

func (s *drbgSuite) TestHash74_SHA512_11(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "5c9714d0458f6bdc3b57956436db01a91cec80cfec267daf62834c16c0600b7b"),
		nonce:           decodeHexString(c, "cabb734b5011dda60f0772d415cdeb32"),
		personalization: decodeHexString(c, "ca5abbcdf8578fb58619f4dab1f065c8a7a69e6173ea893f16c5cb9a27e6a054"),
		expected:        decodeHexString(c, "b3df6dee7fe5d5cea49d88587da12776b0c9928019829cdb7f8fb761973a24ed9be245e57ee39e73b994121b3cdb902bb9d36bbb5e1b77e4b5c9fbcff14d7f1d2c1c7913ced5fc99a6e8b98168e9b3564682ddcbdf714bdbd020e01611644aeb2d32192caa7abb7b320c34714ee6e817fbeb8f7a265e2ce12503dcb811b09b752de4dce1d28dd558e859aa89288fdce3cc8de2b3e20c7fd802ab506e7587cb5ead79fcfa836923d0b2a0e7b5b9c8f4dcd32a14ca495c52d2317c895d8d3b5ee184f4886a6776fe7e4da5d24bdad322b975ecd16f26f5edf1dccd42acd9c01e132d325773981047f49cc65687e2b631ce4c57b1680d35c01acd8360e66af6f906"),
	})
}

func (s *drbgSuite) TestHash74_SHA512_12(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "e2253a35a6439e8d3c0f2d79bfab941f517739a23f7965f3a4b164129ca7491e"),
		nonce:           decodeHexString(c, "4d8438248515909bc48d85c62e597b43"),
		personalization: decodeHexString(c, "bf19a8dba2b174fa7a16151c17faf3689b97281868e9b49c749e7df255383872"),
		expected:        decodeHexString(c, "91fc2f02c0a5748253f87d2a661264e128d9b919a51e149cf1a922d49a8b891ff937b809f2791d477d824b999a7b9d7573c86971e92fccde9798ea935cc1ad03e0cde00e9fddd481d0e33433824dc1253b6a144955a735fb4303accc3325b23fbf7e99affc7f95cca2c585b2dee3762765db7a1ce93229933d0ebe39edf985e84f5fb671c86f2a5d6d660bb7933f204cbcadb0eb829d9397d15184af6b7891e91fa1f82bd342b8d88b9748cbcd66c2a75ea1bb8546a088e0b29bf2f74f55f8842abe2d3214b1f4a37f2477d744747209d2c516d1d284c5828320c29abb331d32febe6199d37b3cc6bd89c4e9c9dcf5c55c7ca2f4a0b233c7154a946f54205663"),
	})
}

func (s *drbgSuite) TestHash74_SHA512_13(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "288d9d6c23ccbde96cc3ed1df7ed35a56ee768805ee8fb529e7e00a62fb3955e"),
		nonce:           decodeHexString(c, "388145778b16d54b3029c40758081c06"),
		personalization: decodeHexString(c, "793655b5ce3ab8bee33ee590eec8de5b09b459e9875b9f99aef8a2ea8573a395"),
		expected:        decodeHexString(c, "186995df846c1c5a02c1170239c3165938acd5dc9d3999a72f8a27f0abcb880ce9214f7e4dadd91bc116210cd110643e1f5a13f558f1efc46aa42155084bfc2de536f4435ef48ac85b167943c9b0323f9f6dcdd4ef6d8a0a665ecb467c0bfc523d439d50b7b164c4d54c0cbd51a7ae7c53941a09ab5c9d8fe77f5277014349ff79ec2b1d1ad94642b28be4dcb1d081880d11b6a0bae19e3192b3cf50badc9ec01439b193c5a76c29da92d269ceeedd39b3ccf7cafa8d85ce32c59b3f63e272418c3c62446c41e41ced3f45f5972ef9e31f5b7fcb3779bc6627fdb093f66da9f382e2b722a9f928910f5c209d18488f46ee56f5f6822dcedce604aae79f4698d0"),
	})
}

func (s *drbgSuite) TestHash74_SHA512_14(c *C) {
	s.testHash74_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "a6f5450b36f9b76e6bea00769bd7586d30f7633312fdceb82de3106940c6c96f"),
		nonce:           decodeHexString(c, "fe9dfa1b683fa9cc70b7c7f8c81185b2"),
		personalization: decodeHexString(c, "7e86cf4111fbea8fa9b180a1bd9ff3e9d233304b1d293adffa49ce8e77f400ab"),
		expected:        decodeHexString(c, "ca0a6268d034f6817edcb6875b4754b5e9b2061ce0bc2bcd27c28065d8258b40ae63bf6d1e15521196da0afea8139c10d7bf3b54694a82d24476c578991fce1371e40b78087d95b1117650af7134567513a017353bb4af85cdc98db757cec9f92df42b7323b1e5d05387debb02750683a5553bdfb5f9fa34e14d29e09ad18bc6ef2380c173a19631abde085369ff47fa8b4fdfebe13b95b90c6f5841fe5aa6334edcfae26c13cc5d14d17a02d684b64bd55841831bde4c75de7d49bdc1a405d4e3e0d327bec44644e972349a49cbd48a4d3b8e984f5847ffeba950fff55bba9b287d51d8475f7799752208da31d91853fe6d04d97ea2a33d53b07a4fc787be2a"),
	})
}

func (s *drbgSuite) testHash76_SHA512(c *C, data *testData) {
	s.testHash(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHash76_SHA512_0(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "9bbd1324f894dcca51a32242e73bae6450f70574c39762966c5e273e5a2bd6bd"),
		nonce:           decodeHexString(c, "b5d6bceacadde8b9084f9e513b3f9a4e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "951d7e7b3e00a588d4d7db7f1ad9340e6405e653b06616d276f9110f9ac92a0d01f054bac3f360b3c8a0546595372502203efae87c6c34f1a8ffc60affd246917d289d6dc864aa4d4ad43300b2e37555de3453e20ec33707bc8e3b43f196db1f728d294111ec438200030a2896cc2705ae0b4de0648fbd35eabbcab9306f97984cb6b41c966cf247bd0bdda4bf2295f9c801d02b94cad22d553dabacd6f7c0f5aec91648ea9c3790553fee7e3594ccc5300b234d22df110de392a05af9fea978391e6405a34de26ceed8787a4a042ce4cb05d11d43dfa7757b75f18235d7d14b87fdd0d4ed758c93fb8ca249f63d54891509bf884a63cbf3f0fef92a7ede8d72"),
	})
}

func (s *drbgSuite) TestHash76_SHA512_1(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "9b064fec39a980af5ad1802e451573c00a628c9b0f0220a132eb35efb75c8006"),
		nonce:           decodeHexString(c, "d0b7183b91055191f09d9d23caf4a4e1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "459ee4ea91b9b8d4092bb0eb0324ded2e22ff9c058766d0877472e867840d578465e5d6a8b6992b9d67802a0ebc24a7f2cee48e78a296652479a63d9a8d64e3f0da8205fed8b52618f28511a8029153ee633370ea4d54b8d0afeded37ac8f083299df7f15612a2a918f06b65a620327bb0d44dc8cb4a8dd6a327c1a891b2126ee395598d263cc2d8c08eac61bbcfc93036f4ffea495db5500aa13c25c570de95834134a253a2ca2c960f1cdc947ddeeb7127107ae4927e831b9dbf07220c1b71e4576132d49652f54a4b106f216dd6070bf0258b9b58ae84359d0145a775f42d8d54f9969bf95342c8bb15e75710f0f5c48d216b78af297c4476fc4c888ce022"),
	})
}

func (s *drbgSuite) TestHash76_SHA512_2(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "2380f4b2a43c3cef6b8f70628f90fb7456d08dd8bbc83943f3936d9c2b1bbe87"),
		nonce:           decodeHexString(c, "41dff48bd7e3903160ee27870ace09a1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ebd1ab440ab8252d07aba0770db62a9d9e84f2cd7db61c0cef74c1d508b4627d9e4572c147f8c3a3b594a6be90f7b8a6ff3f0a9fa4fa4940923541f763146b83545cd3155110d41b779f6c24aec8346cc1d0a809bfe5f51112b3864a6663cec439fac9d34aa23f25e7f8e8c220422f80bb7c90b420a0deacd3db4789dca47dda971e7d2a1bf37084097ee328f4d9732f236d9c157e3d04c089c3ab6183e783144f40a841eaf0a1229fb01ebb2e9d162104ff51ad6ca0d388d488a9c29ef877f5945c01852a4bd45db1092859a1556c59d82befe203fa1818ab499c6d48c4e4d773357d8c9614b30197dd5c1665f6ebd9ffdf4bc39523b33a264cb2ff3eba361a"),
	})
}

func (s *drbgSuite) TestHash76_SHA512_3(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "84e7dba652be17c1c0cca87d9a969b9af18282202842ad14c2531fe76f83e875"),
		nonce:           decodeHexString(c, "4896f2ddf35c6401740e8480bf163565"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "fe34c3145de3aa378fcafe1ecbd30d003eb9e68765ff8ce2d6cb998694c6f7aeb1d8be429a56d9c20243f56406e69e6aa88a4d57ebc49583b7fa440b32e891232d01f7deabac95d2611fd9d235822c562fae741420824b3792ff368e0177aedaf5e2e934e626a887a93da6fe6ed13e2b427b81972644a62e18ad1f8f876a06b30aac3227c0954b9ff442dcf87c638262fbb04d3e1fb246c9500121d90045e146afbb3f925cdce3752a941b8a0487a7b3192294a47011ff99ea9744792a01a8ff7694d0df491750d3fa1daf3d16a9cd3b05dec2c8970b179d46ea293dd6e6d0ff7202c71d3252f0afa6206b17eb3f289d388e3a9c29df8147ed57024e1187c7ac"),
	})
}

func (s *drbgSuite) TestHash76_SHA512_4(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "4d28b4f412affb229b3385b79f99a65dc363058c6314e2d47556598a428cb3bf"),
		nonce:           decodeHexString(c, "69ab35a35eb5600c31b54effcab74075"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0c206078d2d03fa13c60daaa827c7021e15a0290dd77b24bd018e008c0178bfa38eb1c0fe466f135c8e8b2e9e6eceeb2af31a6a16fc5507ddf777265710789ac248fbf9403e3716a3232566429c00e3cc5dcdea4f2437f2ff2a1f31ac0964a0346a6c6c293e1a3265237132cccaaf8780a58d8f324adb39ff2bb70ddb5132723315f8eb3384fd7d254e6551066a7a91adfb0ae9add781303695807eca55a588045f0caec82907b3a3d4ed0f1419c844de59596bc1b5f740632079502f6de79420736917776b1ee1d11a2f59bd9ce2b6e2b3906f2d38f4d96bbb449a29501655797ca990b85437245434a84756123113f20bafae1c2be0f0ed899dba4e116bc93"),
	})
}

func (s *drbgSuite) TestHash76_SHA512_5(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "24448a568f6912661a26c34627fac21f2a67e798a2290cde17150ac593b179ed"),
		nonce:           decodeHexString(c, "9c2350726dceb1e3b2f5a07889e52d57"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d000492bf88878adaf7af6453ed1c45010d4fbfffa45213f7aac603e60c3fb575ae49f7db997b1d952d4840b6d82fcf0a4b00eb1ae153eb90f7b165cd7525edfa8bcdd86592d651f0afb40b635fbf391eb60146894e271e96e49138a4e145495406743a9385fdc68f23ff5e86c69916ee7d3a41691f9722ecb82e5791b81e11af3926d1c324d70bf63df39b3ada3e90f010326c2ee0d0580e7987b34ec03f5f5ba630c1e9290f8333b84bab99024bbb0cc81706f99f218d9d0a132d8b2fcf91e2906ce816b21913c20235616317d78bfcbf6c60900fa61570c28649809eef49c4e105793b0e08bd77947bebd9332ab5336b11d81c6b33bf984b2b355359e10db"),
	})
}

func (s *drbgSuite) TestHash76_SHA512_6(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "3a0da00487148ca4e561f0b95faadceeeb35fc591661c76fcc7935ad78a5650d"),
		nonce:           decodeHexString(c, "e3bf035deea32c0a36b5f2059fb5c877"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5a2dd8c26bd0a3b565c135342d74b99142429355d51a3a4b139a2cdbc3d64eb4f478600b847388aa722a9bb25fe89ee7d0a60131490e083e76cac916154e39521c3be699174fa92e71ca98130b7dbffd01b54c2621b3525b0386b5861b540cc7c02a879a41789163447ddad8e3ac732d05fb6446eb4eff85970cc9c5797e6b1a3b507248cd2e242dfff48db1eaca77f5001f424d208247d8ca8d1998e7ae7d33eb293da86609c17effa828fc27a52014c6688b235d5b89aab5d7702acc446913fb50a160830450b2733eba77dd297006b33f55677c2400e09942a5dbc75703e09903f4c31369d582057dfadb98358a9d39e3545b793bab0ed8dcdff253cef3c9"),
	})
}

func (s *drbgSuite) TestHash76_SHA512_7(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "1ceb646925c3e7c1c81eb2342008819010d49e0d11dcb6d972a85a007870fdf1"),
		nonce:           decodeHexString(c, "e298763219629e8901e9365ff3f56367"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6b50e633a4b2d6feaff1dc328f074f0978913abc373a557d8ca2adcb922aaf94d20e79f1346b6b85c843e2b69bfbb7dfa16f9debb8234141be1df06217b685703020d3ddd3a7f74793ecb56a88723c1ce81ab29f9f7ef56b3eb0b24142285a667a3b1f2e2b50aaf2accd89144ac3abccbdc16f3b68b1d61987aab373e47fe57e7621e328c0544febb987c599a434a1e10a91ad8f096764f51588e4c0eca548c66351348e728f144a7e585a0f81fdda645c7ed8541f967ad8f60968f09993ebd9a4c2ad63862857cd8fe5aafc78afef0ef03cc47ee88d912d37618ee59e0fd2ebfce9a7a4af6211cf23fca88aa134b80e22cf93dc8e15fd8bc30ca1a5775e1157"),
	})
}

func (s *drbgSuite) TestHash76_SHA512_8(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "62851d19bd8146cd9829e252154734642a1b39d03392b7f138b0bbb7813c3262"),
		nonce:           decodeHexString(c, "bf47c30f8f05e8dc84c5983747ce9730"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4c619f0ec161fda03583ed4328ded5fbc84fc854c30f5cc777c47ab118fc15d56ce1713d64b75dd6c168225459cc7137c5f324338b57a954b839a461e38c407f6d4be935be264875a6cd693ec98b90125629edbf3c29c7a0b3c57f7e6542d2ad32899e56a496c3675773f794e08cab7ad8bfe95769a13ab43cc99d7ee7d68dd5a35cb57a668db468a99f1831972e4d7cff59f75fc1ac4c6a3c08eb01d94f0e7f1f940c801d960a6a85eb2f3f4578911e9222dd2f62cc18611e3bcb879443f91dad2d0d0e2f9603b09ba400fb6af4b7b73c97db42178c27765ba5df01b3b7b42e80560dadd73433d82073fdb09f93a381150ce8046014b5bd50c25e214e98734a"),
	})
}

func (s *drbgSuite) TestHash76_SHA512_9(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "3b7964ddada8f16b495d277e57c7dd721bb098a49bcc0f116050596c8b88b94c"),
		nonce:           decodeHexString(c, "6f63d3239a7415859d302e78bb082dad"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "60df463f43c0340e5c63c1df2659eccd9f79266eebc88f5169d3a972904932c02758404e840002716add87208043766c94138f7bc162eeb754f050aab0e92df079589a46522b26ae33615923380de81a63e45181aee673e4b3ebef3c1f312ca922300f49edf85f5f7416bd2af9daa9ff729fbd01047a87c2788e842628d0221660df566d5921a7095977dfa9441c3e0c8b89d3cdf8b3575d13c4c4bfadd382703b9948fb0f767d468400a206a5f8eecb06575ca1d9d6d737bf3b7c80e42a233d4e5875fc46eb59db81542d91e9cc56aa71451160c38bc06e056cdc981e4b8c54d23330dae67f75fa3528345efa71ef5b0c51e601cc43dbb4a5968583e0304306"),
	})
}

func (s *drbgSuite) TestHash76_SHA512_10(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "69bcc1be3917a3a035ec29eaeaf961e74954eb2126986f27e703b2813536e91e"),
		nonce:           decodeHexString(c, "adf874cea249a301d88be68d97a7cdcf"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1c59daef4f22a035f4f30c1791cd6aa73b5a939f27b2cef241df70c70bd3e324ca0b6f1b439c923c96acca5cb106002c5f73f3f6a6a8335dd7353f2dc1d9b2c10cff71f27d9b564e187e97cdc289df66de95aa7f2d39594abdcc4c123376110e6c09e19dd84ccadee35e4bd3fbb38b80623ba781c268958661ac31dc234cce44e29bc4644426eab0d1587aed15bd145838bcaa97819f61811f87a9d4ba14510ece56309ea88af8914b9b3d45b1fac3882e5fc0cdd2ba67a309f0bb278d170cf06c22589acd6fef645cdcb5fbe8bfe3b020fae2db4472b324e4ecb1d7bfa6d1317a9f649378eab952ad988f220ae12cc823f5ab8a2441927014dc74086bb64dbc"),
	})
}

func (s *drbgSuite) TestHash76_SHA512_11(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "ed0bcf14ad870c697972952ccf028a0200d5292028b0d3c0895830f316b674e4"),
		nonce:           decodeHexString(c, "92658caa52c652b04e1f87ea3923679c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "acd2e85b622993f76008b25c676a4354c56f3603a9311d7041d37e1fb44c5bbdb488d1b4a06b03155225b81f09ac25a7c6998effdc1a7803ed13af96d69f31f2872afa3e181c3dcf07aa338837a193451a715c02c75511bb63d7cfec5659f2bfd4b906761339b8e0d4a2f2cd2b4377a6449bdc877b59bb403074b4b3190f52c74a4d0672fed5070da1550edbfe75fe15bb2be3b8dfc632ae166f86ee8271d066592f76473df3eb645e97f12e1e519affe4f38941a4e9acdfeae336c9d83132981c4a1ae9eb3ab7eb1577a942b2522c3eb4c2dce453c59fc9bd46562520893bf9082e89fcd2d418afdc2ecead17bc292edd4830db798b6c2f00192340be018da2"),
	})
}

func (s *drbgSuite) TestHash76_SHA512_12(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "6c652fb18bdc0a9ceb6a4a64a91b47bde1f14bda9e4cb2aee4bf7a1b5614642f"),
		nonce:           decodeHexString(c, "494cae47efb1609d8a042e6167ba16a8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cc64d8334817fe22d79e4d03c8e20e732c6ca4bd04d10688593a42cf06cd044951c068f7396118a78ad6475b39285d12cb225438db9bccbfda6e0ae385eda77333c8e8237cdbb6a0500c1ebb8f8e9fdc065e35fc73a6c3e4630b79172e965f6d6183f91528b331f075a788a8fff1e1a410bc44b5b06bb5ade7fc59b7aedec39c0453a3249badbea0fc60bb38f4a132c3e0bb786e63a26f8ef29720f4fbe4834bd114e20679c8fbd2a20f8350d602e5e46a0a826376e98fd5e65fb3b44339cc00234cc033011f56dd25e1a84cc2be53e2fc52ef482432fa571148fa7c8ce27c04b0e16f7bb44e02b123099a9c1f9f8f8511f0699a646bbac2595acffd3c0f9815"),
	})
}

func (s *drbgSuite) TestHash76_SHA512_13(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "1a41e673f9dcd36f8d875f2de629d2d8781cffa2ad7fc330700c766e5f864fd7"),
		nonce:           decodeHexString(c, "490c0d75948be3dc5659e1f71dea4859"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "423b41674ccab8ecb7084d77d69b2f3e6edcaecc1472959a836d8268e512af76acb32d7c891e78128ce7332df464c9bb0647e4c7634c2d03a4af2a9cf07cb59c01bab64485d3c419c210fff1bb77700bf6ff7d38848d677ab2fe032a2d246b49cb88c0e5b67334362f986d06ce7a832f15252a2c4a7cfee05f3dace252b2fdf797560c9fc8deb7186853a4fa3a228d1a2cf26114e2b7d5769300d5d5331ca0b7455d6ca341f32548de5e31005f8654112528fc9ce09ec7779504d90901dcafc77b3c2ff174203b38055fc5d3d271aa349722880569186604d4d290a70eaf3950b4b1adf5951d731b6c63839870667f12690c834455b27a8b838be7fe83b7b9e8"),
	})
}

func (s *drbgSuite) TestHash76_SHA512_14(c *C) {
	s.testHash76_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "c5ebb2ae08a03815e496c2db1e2a650b40893ea78fbd7ca8434edcde4432a43e"),
		nonce:           decodeHexString(c, "0cede46aca7d2a60f2e98eb3c7d1dba7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6d8eeb5ba130de7dca993b44b46e08894fd84ab8c347992aeeac56ce5fb5f435bba92f1129aaf9b3035aa117301a1289acc222cdac043dac58b62567102dd5a57483d79fd703e188a0fe47254bb20b361281b5b8cedded86ba9b6d86deb30e539eb7ee007131ab2af99408f38ec7fd66bec4f1ed71251c149dbf8393b6dbe96cdeb9a3b5ee065ec8636444e72339ed2cb27fbbe5421f7f141940d6fa1cf570b8dd0393625ae16b10df2f1f6fe35dba15a732357dcdf4f56abcbb47a4640dcef618e27d049e27f2af7b8634faad00280e004cfe3f52d63185eccd6c4937a026830c38e1ed6aa9bfeaf739416706f63bb8b1475ac25d734db28e39163aa0c69c52"),
	})
}

func (s *drbgSuite) testHash78_SHA512(c *C, data *testData) {
	s.testHash(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHash78_SHA512_0(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "b510a60a5a19007ba808e60b1628ed9907d1bef992d4fc0abe51500131cb4cf8"),
		nonce:           decodeHexString(c, "eb1bd783accc855eb320cde10b1be6d0"),
		personalization: decodeHexString(c, "7ea10e96af900c25d3be3b50a0cc71a79fe414bd4c3739803f02ffe5b260bfbb"),
		expected:        decodeHexString(c, "5f03ab529b9edab55e75e489bceb0ab6cb9ec6255c6196cd075397b091c3eb598e3162320c71e389e1d9d62a2de5990c2097561084e13ab4b2977f99c23daf214bbfeb162167c933860fb2cc9f80079e17893962ff03a26b2b4b838e6de9ff5e9dcfba73acc6ee76c477d1f7002265e693850a260e68617f13b24716d8db42c9a8f2e0bd5002289a86b02a845d9886d3fd05d8d85ac77ea60192a29047303a03b51e0e708fa00205b5c03b67b77874052ce56d5cf38e726d608bc0ef8fc2a7d27778f47c6891637b631ccc6e36eb893fe08a5b9f5571bd432c826d99698fd4179bc5cfb0d8ea2d555c36b70568c2206b18f3bea14b398d2b6a00122d7a447ea3"),
	})
}

func (s *drbgSuite) TestHash78_SHA512_1(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "437eb8bb624742b377a03156a2bd868425c25bc01fd2d7d766ebaa4a0fe7b204"),
		nonce:           decodeHexString(c, "5b88ce5733490661afa2634097d95e77"),
		personalization: decodeHexString(c, "a34be0d37e0149d78601bb796bdec7035c4c18c71d386fa5675b0e9f4217515e"),
		expected:        decodeHexString(c, "24c4647c869efbd691ce8818f943db07d819862fa91afa55035ad86c4c33f4fe165246306a551c7fadac73595346154c7653499125964eb4e81789384efe2c16af8ffcb0900492c032e83fa26077a58b59668eb873036fbcfa8ed45ee7aa267e5e476a3955d22ba4a173eca18d5ac828de5edd5547a9671b90317804d30a5f9725642aa0b4f7fff3226814888efd515d81f07f15b00c67249cb1f42296f10b27a97059e2ba10681b4232acac8af616b71707e01a5632d0549f5c19c00940f6b9009f683e64cae69e72a62ac7b714c2f21ff199e601ee989883a3a8db0c85793bd994bc22f364e0c96bec4166427188aa08317cba5b5414b001462054cb003fc6"),
	})
}

func (s *drbgSuite) TestHash78_SHA512_2(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "41b7ccf06fc6eaa85970896d34bc45a09ca8c2d688fda7fc1d9fc699204cb352"),
		nonce:           decodeHexString(c, "ac7cc04dcfc4659c2f08dcd6b09bcac8"),
		personalization: decodeHexString(c, "9cda5c090ed1e6ec9f7d31f5073955c4c7d8c3011c8419ae91e4a829d4b3ed30"),
		expected:        decodeHexString(c, "58921de02e81855122c17ae22e8400ca14a4fb17c2d16aefcef4cd5c59cf30f7c9a35e89b567a2f9ccf87e1b2c7dc86544d36e25b111ad3cdd0693f563fb9fd25bea8b61293c8fcda4d71c28a3f6b86881e5e0821f011bb94df2ecba6e04ba97a962082328cd10d8a06a150d86e59ca1e542b85dbffc9018e800dddaffc82aeea8b4b9099a3de939e5940459d17fb2265820545546252228a938b657c98efdb22f2fef35d24c6317dd6fc01910b6e4d3522dae3360a8e72ea50c01bf14bd06a713d1feba12c738008347985f133a43d4b8289cf709a5687a19f755d7891ba4b0e4bb5ebd4739411630eacbbee4d7d56352ee2f2505e516806ca7f54d7ef2842d"),
	})
}

func (s *drbgSuite) TestHash78_SHA512_3(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "f851e2ffc4e36ec323788fda250e712f08cdf832d13126d723e75a9c47c9e974"),
		nonce:           decodeHexString(c, "eacf73975cf3ba5cfd4fe76e86ecc732"),
		personalization: decodeHexString(c, "39128755ccc6116548f90b53775c7fcae46a7c22b13d807e0314561c2e3e3b98"),
		expected:        decodeHexString(c, "a07dc1182a42dfaf31d99e3585e5d8c5bb77e43ea23e3bf5605ee22ffb453a9e1061b9692ebff369e8a91daeea4681d672e516143a0e63c684613ed7559701e2411ff94a8d23d816d30b9e5eb5c029e6f2ae419a076bb2b049ade66fed50b1f6c31978631b66ce8e9365e75c113278788a3779f4ae3547cd308eb99a57bf12079afa098d2b1f596bf6775ed38a4519924d4e0f7362755ae414ad1b5d1f534d45ef84f194e5e7a99b259fb09376164ba7c44489444f24e77dcc77189b450528447ae4a7b85724ad8cd379c7ce8dfe42722f596b3124da4d42c090b6c1060b29e33176e4462efafa3438c8a20a3d41c758edba313789271ee15a6770694a2cab16"),
	})
}

func (s *drbgSuite) TestHash78_SHA512_4(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "99a179a403dfc5a28c515e62b3299d8deee64125f064b7563d9221eb2099931b"),
		nonce:           decodeHexString(c, "f1219ad014e02fcc007d657726493060"),
		personalization: decodeHexString(c, "13dbe49995e1aa08edea3565456c97d65868d475ea48cfdd25fb52e76b33730c"),
		expected:        decodeHexString(c, "7d46ce1bdd8a080de2f9a276b3ddccdcf2aeb51afcda9e3c7e4f21f8a4446087c7f61c600684b9ef6955a3f547a923086116dd634f40f6261950a9da0015d1f79c220fd36ec0decb7d3d6e65562c087e395f719051f21bc43283d217aec39b8e059b3b9222209b71a76c91d183fa791514a6f7386fcd7244674a54f0327acbdd1c2d8be494f82903f7710b1e2139d4174b736c5935c9b23da43ef25baf8125bbb7095881c21b7beed0df96f2979a8b981efc75eb4cfaa89c76bb7d14c9763ffb9c16173e556d57cbdc7f8a2397790f7b7b99650a4bf75d044cd1faa925d129f51ff9a1d5688769cfda7d4572378d99120d37f627271c40d4f847c311049a24ad"),
	})
}

func (s *drbgSuite) TestHash78_SHA512_5(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "08f9bbbce05bb88a664fbc00b109148b8019917b29299594a3223cb9353cf06b"),
		nonce:           decodeHexString(c, "d88e0b2604170d8f96f939063c868440"),
		personalization: decodeHexString(c, "f5e65b38d925a8143669046aa129447019dbd4326856892d3cf8cdbb63ebc80a"),
		expected:        decodeHexString(c, "f16920529a5a7a841ffc8533ccaced4d7259857462445bb7be98de303f9f7ed243f58668a172092109ad4825cfc96b24ff6341db70b50a06fd508143e9e0ede67f32c6673dda34ef66f74fae2f940b52716e50453fcc021d3a72746b6ded4c1b19c50b8f6d21c5c7c1a96cbd05b393790ce18ffa737c45b9c1b2e7cf05b110026fc401937493f94b4d8464638e03d19485e642cdf38f6729e0c3dfdecb1c8559dfb62987ff629f1f57b4eeffbf9943caa2b12e0d77e51ec09507cdbbaf40666756f32a7810cdf69452e46d75f2d1fb7437d1ef75d13486d97b384f030d713f2b502e3287bc014e6bb6e373821c4756828e71b4c2e08ef3501ef12caa82c0e02f"),
	})
}

func (s *drbgSuite) TestHash78_SHA512_6(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "33a4d88a408ce2450fc303c3ce2b397d97afa2c29e1fa9f27cf98bec60fdf007"),
		nonce:           decodeHexString(c, "f870245d7194575faf70e9e63a417bae"),
		personalization: decodeHexString(c, "af2966f37b4b080d4ae4da52a5e247252c7e0dad65e180fa2e1ecb05992b6691"),
		expected:        decodeHexString(c, "84b2825630c86859c5ba59324b292dd1f4923df5b2e664ca4a3d6a5eeca62f5157dff1ad0c7bbc785fc7eb15091f25ae31b7da54658e4ff0fcdf7c1a3a4734f7a9647db50c3c45c48fc334b7ae1a725f0eb57cf1c078683aa50a7b3cd4c051ad3d59daae5e2409321dc8433f439cedf9129b1aa3e2d1ce5e659080762bfa8db259eaccfbb1f704a76f59e5878044df9fb08e65fdfeac65185603b0904561aced4ad32b6bb52cca180944c62d9102480cd0d59413fab6268f92224df1fef21c11c984ae263f24de504e6a52869066014ca230e33a9d7f64c7100ae286378c44bcfa15b1c5f43d55b79afd69bbcbe6ee3255b78cb59a0f7ae1bb9b4be239301c81"),
	})
}

func (s *drbgSuite) TestHash78_SHA512_7(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "7c796db5544d37174068161145e2e3675e705dc54cc82d1e3486cdf59bb7f82b"),
		nonce:           decodeHexString(c, "da2de425e5a735f9f799705c54e88640"),
		personalization: decodeHexString(c, "67f98ddc76c61b93270f3fab40a09eadbebde1aa252efb937d6cecf5f3a9e48d"),
		expected:        decodeHexString(c, "3c3688bf7410f545073813eba8e58d89efa56564c50475648821c048fdff3369d188b61a3a40b7a75df7883aeabaa400252e2247e5553aa6050c2b0703ea79d85de06c7c18d650389b4d30c1735bd0452798a12d428acee1800a4d9b3666f247cf9f8dd2b611e3a0aac763886fcf49bceb66af8ddef6ed4e5bb39512dc27f29e14cb4ebe2f675ee28f2069e09ff9e87c7b43fd89ac710ae2dc49d49140079ba999c19391e8d7220c176f9912b011b799332ea545c666283ccc1455deea01eebfd4ced590e3454ed34ab80f4e2f7f7336f86bd295779948f8f982c5a4223873dd7c2ff87b5ee73a2472d86817d39a9b8a37daf0935a1ac7340679ead86f9e4139"),
	})
}

func (s *drbgSuite) TestHash78_SHA512_8(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "0b8ecf86967f9f654f5b4fec1af177761caf138ff5b40dff36183a01a630c5dc"),
		nonce:           decodeHexString(c, "564ff097b9842c8539d8c255198057d9"),
		personalization: decodeHexString(c, "30320137d43b37d7a17c15f9763bcb37790ace97d88eddc92f3ee1d60ca1a929"),
		expected:        decodeHexString(c, "9338ab01620bb5c9fd698ad49a18bebf4d1613254b1bd619cdcf746fb850481d44ddc88538eed16c29540337374e901f1e8d667bdee99e40237c086569a0be686489724a58b72012281d9241afaf27f16cabe5f41c2b3652708907c63d782e67fb58ec4442e71c02f98882950fa96f58cd19783f7106159adcda38416863bcb7fd6844394733263d96590d0cdc8065118555b2a524ba3c1327ffff2d2a894163a64525584df8ee65e315a472ee9752214e06a2b6c0e72c4c12a5008a8fbcabfa7b6289043448b65c077b64863653f6c11b70ff701296631a307bdb0019214379ffb70c0eb8c3563b1eddad3359401894522819f5f82b25d0753b154bb8d278e1"),
	})
}

func (s *drbgSuite) TestHash78_SHA512_9(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "8a1c324d7c5d79f4cb89b5b24d447cfd2737a1cc166db3d34acaa50054a0ef66"),
		nonce:           decodeHexString(c, "19c7f7bd9c27a80b01722d3fb71565d7"),
		personalization: decodeHexString(c, "e81d9c0f169a6f536369e4ceca14b2828057d7574b34a535bb39ea2929e193aa"),
		expected:        decodeHexString(c, "33953f7192160d854d0fb54467382c0d8229c1331639c15a7067727b6af0fb0cc5551ad9fc7e0253441a4e54df8f7471f94e1dac4971c710d1cf4b4f37672681bec6c85caddfdfbe247855cdc4cf423805f4dfc681aa95958c804214c45e93c2620f298faf7685567d26d2de5185a591b0c0057eebcb715cf01743c6716484133024be4dbc05321d7ceaad7fdcb854f31b4858549c7a1cf296c16c3a39c5026c97471bc9034fd056950037c37dbc538e1dee56c566bd911f08e6c4e7fd0efb9e55bb4b1025b2a8b76014a19ba4c418285f177ab19308620fc4197204f0222429791dd0b88dd66d65af0ee681cf01bb7b77af0ec827ce72ab7530f1b2c0a54d9d"),
	})
}

func (s *drbgSuite) TestHash78_SHA512_10(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "bdd5ca5f0746ec225150cd85e7d8acfad14c329b478d9f069aff030380cecdec"),
		nonce:           decodeHexString(c, "31227b1d0e935db6aaa63578f1cff0b2"),
		personalization: decodeHexString(c, "13e4bbb57e9dfe1c22fd410859b25f587be324755cb8902c9f67424796c808ec"),
		expected:        decodeHexString(c, "cc312a20d41da4fb965668c719257b1d85f8d83d667c124655581d10b84afda46b637c5bce4f02ecb538661e9cba650a35d2b802eab3f8f12c38c92518579d500e077257869b82940b280fda6af390104d78d958d5da66afbd4cfa57b1158bb9730a521fc3e8f694213bc19b974983b34a8b912aef8306be0a622007b120e9e883e966a8d469b48c9cfde72410ac6795d0eb7ce1fe76f502940845a7d3170e2c8adbd522237bc25ce04c431424b4d98b692e36b2ef1d08491319d367f0d6f25afeca22ae65926f99376495b2747664079532ff4fcac4437120d54d720cfe3e41834df5857ddd34eac2a127bb14406794d3f07e36ae7e4d1279ee347d8004a167"),
	})
}

func (s *drbgSuite) TestHash78_SHA512_11(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "aadaccf8b08461e106ae1c8f7f1f73bb44fc7cb27cace17b9a78b4fa39a0a3fb"),
		nonce:           decodeHexString(c, "3f09fbc98dd8d90a3367364e13bfac0e"),
		personalization: decodeHexString(c, "f089ae100801d5ee126c1de1dc84977b162e55a644a09e628876a411ffc8a3a5"),
		expected:        decodeHexString(c, "7205d5cfce7d15bbe9cff1494660de9d7946160bb692b5e610e6c63cae2f4f273fd6ee3a3d2998a8be7b55557c6d591fe301f70754a4bfd00f07037a12d26dcbd9bf29b69254431f75b2c68ea7d7b42a1db0fba3fb411196388a19eedeea96a6418745bbd4c3dcb97a88eb952b4306273dc6f1b1c5f8da92bfcc34db99efe52b31cfd3585219735dc86aaf132bc9dd25d0e228a31393b6ea306b7de6c40ce0ecf31d3f69d478780b6cf54d4c5def99d1cbf36e785fa70a41f4f528acd89e9aa453f92f071915b9efe6b3170850d3870cb93da9960c1557148a1d8259f1740758790013c2e9b2fb929c953595d4c1eb54964c1d1aa31d8f886a713b86508195fb"),
	})
}

func (s *drbgSuite) TestHash78_SHA512_12(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "3ceb5f4355f3a8d026842f45513ab83e3ce2d28b55ada2767effb313ad3c2e1d"),
		nonce:           decodeHexString(c, "a87a2f032cfdaa979d11bbe96fc79485"),
		personalization: decodeHexString(c, "d7f3aed96ca0719dfc4abc445a5d5e284fa46dbc3ad180f51792c7e1f4c701df"),
		expected:        decodeHexString(c, "900cbcd97a61a8c00af8e9179259527ce85cda82b44d2fc2a71a3452795048745995d51ef2771e4feb80ffd3084029d2e6f83c99bd6496de6940b54e38041540e3effbbd89ce71871b28ff99ff9d62ee533c85ec50c116dae9fe555ef1fb444a2f8f593609a4e767a03024d6a61191bb14f59c5b95c28df537d411e6a55f89d0d7d04fe4ed2b917e966c12e9ee21af0705e6e7b09cc553c2a772f421b07a88621cb2ed5b62b8fdeadad1e1c5b3fdc875dfe8c32266078a9c30d088f6e9429877d1964b39efa7ee99008d19931f733516b2dd83aafca1bebe8c63e638169fc55c2b6cc98ff89e61566472f1713021d84c7138143b2ecf03b0cc2e77b5e001d98e"),
	})
}

func (s *drbgSuite) TestHash78_SHA512_13(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "bab81ccb0e7325ae4efb2844013e64b321d5df0bdd6c70a5e5f5c093f246fd7a"),
		nonce:           decodeHexString(c, "4fe74a45ca5175bc0b3e1bb3c9ac0799"),
		personalization: decodeHexString(c, "27e6945dc80dd525c33c7111b17899453218ba38df9802477881d013ca7add2d"),
		expected:        decodeHexString(c, "9a44b46739ee75788dec7d182491e58796c308ab1d27a4eef0151cac65c31f7e5806b9ad7aa9636688a67c1a9f18298061a8d33b8d708adb9f05935e729dc977b9584af8a5c1ac3107d58bd4e3c751585259dfc39950ead6b47fdc0c3db5c9f8809881f4f9fbbbf2bc5299900745c0cd826993e2e3cb96df22e1b5da18a8c1b2037ef65b999cb0a7ed16b1ca92a31aeb7216723cf20c070143c1298e5f5bc344c5252ab966bc477327ad1cc52192a69baf181d07293acb00416b7e86ef9ae871a8d750c3653d8c27c2da99eb1fea14aed21f247d31aa817830489b11e2104d2d978b7dbbfd2167d599c252350f122b130838bff709bfa879a909cab5ddff12d7"),
	})
}

func (s *drbgSuite) TestHash78_SHA512_14(c *C) {
	s.testHash78_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "e5f5eaa9d45ab64e902b5444ac7084b776521f36ce76bb504d8e719be4a401ee"),
		nonce:           decodeHexString(c, "7b9a876017e5e14bd6a19719c73035da"),
		personalization: decodeHexString(c, "eb97028b093f820b182384baafa56ecf196dc11ebc515a405ac24f73e465ae9a"),
		expected:        decodeHexString(c, "3791ee66e505257b0bebc4319897e80ea8a70577b8a85d809cc7e4c77a458e8517368e2eaa7c0623b91ab3ebc4de3240e00e5f0cd20524d73b8000f00a3cecf869bee26763db9689dfaad9b5f21e3975f750e0c6b694d7df35fea26b2ff3c2bc679b5ecaf129320dde8245677aab9fb54b8faa97d394adae687a35b00f026430ef29bc7226957dac5edbc4a70dc82fcac00bf89d97e11d2a3e6ecfc4af4536c329ed3f4dda201db47236b03f30daf71e6368a18ab6224a023fca2ead589d9ea165d66fbce2b37a630d18ef1c97a619cd8949f16f44a9bc0f5837737d7fa4355587af5ab452f53fb82dd8b8b4706cf04e77938d7e0c3a9744c353edd0c6931591"),
	})
}

func (s *drbgSuite) testHash80_SHA512_224(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHash80_SHA512_224_0(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "65568162700f22ac868a504110fa466c70cfe0e7c32f1451"),
		nonce:           decodeHexString(c, "69545e871b89c7b3f95885eb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "588572c2e4f0d6c7077d2b9eb593687ca92c86e5a9729505fcff52adfcf8a5eb850b910b985df10299bfe7434f3b6b7af92a3edaed732751cdb421c38431e2763afc6799eb61e176f9f20945870680ff8b62484378d3a7fd7d29202e5d371785d68fe399d5f600f34517fcccadf58937"),
	})
}

func (s *drbgSuite) TestHash80_SHA512_224_1(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "6d8db826a6f0ed60070b934ee06e8bccf3f9c6cdc8a293d1"),
		nonce:           decodeHexString(c, "20f2e84ef04067e356118b8e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "efac8a6fa5372ac76a9f3dd3f6e39ff442c3efeaf85fbc446a4421d2b7c09f4fee0e7d74883cb0b9b95e810818506cbf4f553f6f8485756b823e10fd78f1704adc546243346a2148a3dba769b826002ffa74dd1f0bf2da571ca65838a582801c7b407b73526532c4dd4c01916c6ff7ab"),
	})
}

func (s *drbgSuite) TestHash80_SHA512_224_2(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "41d983db9c26d36697da9ab03389b5ac45defae909956590"),
		nonce:           decodeHexString(c, "9ce16c8ba7e65d061b3cd4e2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1108c6cbc9227cfe9f1bc71d5e5a62df032a8bc8f96afd34ad4348254263f9528b3a564cce8cc3773841e25652d415c8c723013e392490ad8b8a4af7b052a537114afa5b7b34d067fac674f8d9fefaea7626ca04dc4025d49a55ff3821502bad6ae644e96d6c16beed3a209ee4f81371"),
	})
}

func (s *drbgSuite) TestHash80_SHA512_224_3(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "c711979849f2ac221e09a8d583fc8aea14cbed3bc3610ea2"),
		nonce:           decodeHexString(c, "662b94e01e557db42d04163c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8ef303d36fd31070f836af719fc36c34df0de52ee760261a909bd6a1ff80f4be8be5b9ac8f6c5cdf2f8cd9624d92461bd8c9306931c537162d4bcd81632b5d9d611c7b5eaa4c422249940bd7daac90c2a5fef9e2b7198583a85fe521740049a2a900f836c5086b131630938b71389103"),
	})
}

func (s *drbgSuite) TestHash80_SHA512_224_4(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "9e32307f0307ddba166b20e1adadd1d9209678a84c0cc42d"),
		nonce:           decodeHexString(c, "d5672f24c209be66d596e110"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7929d9a6a925693f1c363930e600b41e21af13c58b3e7bd4badaec4e4563563a3788165ca4c2965242c8212fe90a62948e727349acb4131f60b66e9c9a965ffe72e82df4d74c49b23c7224535535bdff4fd42bf341204fb3f5acf617f3185be4a9e49185eacc44c0b290fd2b5155dfb4"),
	})
}

func (s *drbgSuite) TestHash80_SHA512_224_5(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "e548d22a097e1d2c32633f2fbc3b42d4fd8218f1d5f973da"),
		nonce:           decodeHexString(c, "edbee16768a4b4e54c0cfec6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a1927d0652ab1ffccccac434b5d22dba891622c75f4e383336ad180416adfbd68722ed6f63c0f6b34a2a427a87dd62f1df139abe2a0f48e80dd9aca0c6a6eaaf746a89bf965522c6f91b7e653a2c0cbf12fec6a1288abd4997c85682a500db0a6f7ebe98c9f0e8a5b7a00811edded092"),
	})
}

func (s *drbgSuite) TestHash80_SHA512_224_6(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "34912165f33d3b3c63dddcd17d0bf5a0c789b54cc5abfaa2"),
		nonce:           decodeHexString(c, "a1fdc19ec11766bce95221a6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3f96e8dd99851979743c0caf99e40c9eb604803b45a2457e331d4a688950912888abfa23ae15f233b5648180d7d89eefe49a0ee8e6caeb7c21fef7615bea2640c48d5441acfd6c883d8bd0bc47dd5a5f1a1b9e4ab1b1c2e963418b35bc4bc994d1edbd40719094800847f4e7407c89d9"),
	})
}

func (s *drbgSuite) TestHash80_SHA512_224_7(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "00eaae3aab4866a4198aafc76d7822bbe92563770df281db"),
		nonce:           decodeHexString(c, "7e2257ebb3294ce85410a7ba"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "72e97d7dab6afe13df5c66822a57b80fa651721c83efb97ebaba112ac7c632a9239fc19f707a2a8871671eb60df465afc495d099bdda21ec117ed3c7e46316b0d9d9fd443f8b2bb3ddb2753338b7627ed9ee5c9f0ad02174dfd7e1c704577214ba1103d3ad97c40bb34458cd10c11b5a"),
	})
}

func (s *drbgSuite) TestHash80_SHA512_224_8(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "a87af23ab0a9e5b9d85b467eaf313a6fd264120f9c46e4e5"),
		nonce:           decodeHexString(c, "39ef754427d169b779cf926a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f1bf2596fe551f4370a0adc27855a784bdd953746b892ec1053ea1615b304ad2bd2e57b150f167b0edfef2aeeb0b821107588e6fac002e664b71cafb79ae5e30d0f9fcfb22d96e5d205ae485fa6ebc6d3892fd9617c71f1b028787524b3e528c0c9e6b7e157f91585513fe061fdef7fa"),
	})
}

func (s *drbgSuite) TestHash80_SHA512_224_9(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "e767b88e1f3309b52d786742fa9158f34883ef6995051eb7"),
		nonce:           decodeHexString(c, "679fe80305cd357589106435"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4f94f91f14844aa0f06d1126bd3e54ca7e0e353970c0fc77f39391b9400aed70471bd0bf9f458914658792c26c923d045d85b1618bc70155e665d23f441f2e01cf64094f3564a8893a07c5f1f9d1f7a904ed059d554c8561e869f59a0d89e25c770e2623b5ad793dc040a7760abae6a9"),
	})
}

func (s *drbgSuite) TestHash80_SHA512_224_10(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "627a82e304483ce645b59717deabb782f03115ce7513539d"),
		nonce:           decodeHexString(c, "50360b296b8493afa8550710"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "034be2b6b71aa11d39e52970dae6ca3fbe6076d5915039e660f4def6da51bfbfe22864c88fc4e86e5f1a4b0d4628de7659f4238ec93d301b3d1cbde172bf675fb6479a463782e5691abacb4c9c1bde65a525d44ac986cbc94f0b229e76e524fb8c1790583a41f3ff8cdc59e414cdfcc7"),
	})
}

func (s *drbgSuite) TestHash80_SHA512_224_11(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "0dd73d1481466f7f6feb9fa43aa2f9c53e1a102056072830"),
		nonce:           decodeHexString(c, "6c0a28a9866f0fe64bcc6aa0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e9a42f4c90c3f190c41dd90cd26abf226c1da39529b8fb2680f2b65340b375c6753eab97ac42f65e71a5a92a8f08857bba3b13b06cb0686e4e62a3a80080867bbef67fde793de451adfff6e60434ebad8272d2d14cfe4f178d811e62eb45e53e5caade08c1db8c6f2d9133b5bd8aad9d"),
	})
}

func (s *drbgSuite) TestHash80_SHA512_224_12(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "e239c344ee1bddf16d0e01b644e35729a88aec9330c37563"),
		nonce:           decodeHexString(c, "82760380668b3e1d1b0f5536"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1b349479778dc46eb4511acb435a31344e4a62d596b61f5127bf93be7f1fe83db61907e4f692305c6b9bd45717e63c7bdc787f2153171c261787f980ef310bd122e68f2ecbf57aa07fc13f5f97771a05d71d98af6167471a9fe55f58bbbff0e019d683fbd9aabaa987ba5256c857b770"),
	})
}

func (s *drbgSuite) TestHash80_SHA512_224_13(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "b67ad5d53b269f1ffbd6cb0f0c2e10dbd71ea4ffd5cc02dc"),
		nonce:           decodeHexString(c, "7b18284cbad366d4023e0e5a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d632a5f015ceb58e7e56985f6367043828ba0422070d9a7a1ad8b5738576356f998351b571b260965d79c2dec654024152452656788ce6cb5fa79acf86deab8966f7abe500c6667ba9b514a8918524854138af5f1c2383cb70ddddb0461561076ec93c02bd1f464e93d2e188a5048084"),
	})
}

func (s *drbgSuite) TestHash80_SHA512_224_14(c *C) {
	s.testHash80_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "42623115c0a43edeab391ee8ac84c2b3b1bebba8a6040cd1"),
		nonce:           decodeHexString(c, "b79f5c377be52381210c1c2c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a59dcfa9585b1080cee51ee493fabc22394ccd0949e3a4d4e5b8d60e1137288d20f65e7f1ddc1345869e1af62562d6c11044bb65d11dc0071a04a2cd0eab76718ec9a67d4482acbc82ac27685b98c50064b41e120a35e5ca57ed1bed6963fdd03e26865ddd3217d67cdddbc990c5833c"),
	})
}

func (s *drbgSuite) testHash82_SHA512_224(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHash82_SHA512_224_0(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "2f0af7cdf5e627402e65fa67975754b54b02ffe18ac2bfdc"),
		nonce:           decodeHexString(c, "a77bf219dc5379a37a99c715"),
		personalization: decodeHexString(c, "ed3b70e30ba4e29c14c6f5d0b14e898173ed519f38a8f76c"),
		expected:        decodeHexString(c, "ddbd262c7cb9c049d12057801e21a32408db3978d1b88bce0dbdd205bdb89da0293960d243047796884ac28514d523c5d07210567a351366639f79f9ddeabfc06630a14ed6df9dfdff62e82a79a59ec619598559053df328bf5921aa3e21f87400612cbb52a6c3cc56d3e0c36c784a58"),
	})
}

func (s *drbgSuite) TestHash82_SHA512_224_1(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "72f987de64d4e20f09a599b180e1513c8488e21c7499c610"),
		nonce:           decodeHexString(c, "77ec128a5eae089e9d10eb74"),
		personalization: decodeHexString(c, "ca9060a3a37665c26274537d270e4bb8affd076ab64f48c4"),
		expected:        decodeHexString(c, "6bff81ece61034e05b84ee46518c0cdf3f6cbe4d6e10d1834cb0def74c9528b15acdb03f8749ac9b76886fef8c2f8b4f01818ae217d66dce7855b3785ba479a591b93e81c4456f6ab7f198159541211d8391f7e437c8867c247e98c27a349807213327ac0ebc79ff6ca5b720ba3c655d"),
	})
}

func (s *drbgSuite) TestHash82_SHA512_224_2(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "bb684cc81ae4bc31ed11a7c137e36edde3841ee8332099b4"),
		nonce:           decodeHexString(c, "a95a1834cca4759176498163"),
		personalization: decodeHexString(c, "6ece01ad5600c194873294b82601526425e38b0d2e41abc0"),
		expected:        decodeHexString(c, "fbae71283f422550f0f567d6ee6850ed1a394f4e6870707fbca4ec24449d4b8be9fe72a5e0b1d87be1c8b4c89b8d056a04d6b196504b61d470892e294339531dcb65b0c8b7c85e55f9654ea01b3bb6f9d46cf70375988dd9a292999104b7848b9490ab5da31a4a1bdac248c4ff239e25"),
	})
}

func (s *drbgSuite) TestHash82_SHA512_224_3(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "724317287fc41a2c6ef20eb466fbd707cd0018ddee71c95d"),
		nonce:           decodeHexString(c, "283561a4b7e8aa80f83351af"),
		personalization: decodeHexString(c, "dec43db3496be4765f5a0e305a880c846b0a9e699a7d198a"),
		expected:        decodeHexString(c, "45e20c24122aba282bcf342a2fa42dc272ba3fa90aa8c7342118ebd0bd59dba2001d79f4f49574cc807e51fe6bf59bdd0b81191d122dbe521055e11e4729430d14553d0390176edac67a15a4cda0d2164063fe5570560e2c1d8099a255afbe77b218ad2172d53e0b7f9af3991120f9e7"),
	})
}

func (s *drbgSuite) TestHash82_SHA512_224_4(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "9e5a9a30661dee3b312c6239b68fe33c00348d169aa101ab"),
		nonce:           decodeHexString(c, "b7c24e79f475ae0ac0682ab8"),
		personalization: decodeHexString(c, "42be159ead7265245de53b7bca0c1592bdd8927448eba930"),
		expected:        decodeHexString(c, "fc6fa5b9f0aecf616f59645652626b3057841605264e2f34de81d771b44f47b6e943aae80412f2d3732bb4fdf09cc1a935669d92714fe0a2ac3fc05581724ab9bfe8f5a5b505413ea6d48a7bc1f7efc3064c1752e32d149f05b56a81d4a0065a997a98377c772cf3e7d097829bfb358a"),
	})
}

func (s *drbgSuite) TestHash82_SHA512_224_5(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "f2fafffafbe4147b41a25026638cb7c2551a19b95c37a1c5"),
		nonce:           decodeHexString(c, "3caf68f7be4c8d177cc12c7b"),
		personalization: decodeHexString(c, "1bacac297e2cb2dc292247c038e30f1c62714c35c33b6c23"),
		expected:        decodeHexString(c, "89088f1b2c2c2bd4375455a8a395ad657515d7ca8172ee2e5eaa3b02a86fd39fba00daf2906ea83485c8b21e6776f8cf379a70ea1cd83090e6257baf34a4d2580cce4f884b49e5fdf5d1c43713e42a3afc40971108ddc9b83d217bd9fcb7ac99e1f002285ee6c438e71420f75c45f444"),
	})
}

func (s *drbgSuite) TestHash82_SHA512_224_6(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "933fad2d86855f427949b567231b0718001375e08a774df7"),
		nonce:           decodeHexString(c, "fb878fc9bb993a44aefb211a"),
		personalization: decodeHexString(c, "bf76e3e3097433f46348ef46bbc74d1629870884a7cbd905"),
		expected:        decodeHexString(c, "df59e6ca711d1b9ae21523058b3a0d59aa8aebf3d233d615d7e2eb85bf015936b3970f7037714af092e7310c25bae280784c51d11be2c29909041139aef75e1fde2df87879b11a62214011f967a1cfb44abe4bd47bb0cb18fd54673d3ff52e6a2fd480367e6123dce2af3e55f1c04041"),
	})
}

func (s *drbgSuite) TestHash82_SHA512_224_7(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "186d0b34e0bcbb0413a5b6bec4fba5e9de5972289e978af1"),
		nonce:           decodeHexString(c, "8fc32990df17fe63d69d5dc2"),
		personalization: decodeHexString(c, "a56e6121891194848aec57e05e2d03552fcf497d688da69a"),
		expected:        decodeHexString(c, "5e2c291a793e5e2f4fd9305b104f41379f30600dd4c536a0b4aff9d0d7d5e98587a5f042e44d396c8e002b89bbf263ad6844b967da48490a566486d2fb07f6086384ca3e4116fc3b279571fabeb3c6de5489d2421540ce3702d84c6f390519149b2ec29c8a98f501f5838872671b871b"),
	})
}

func (s *drbgSuite) TestHash82_SHA512_224_8(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "ed30a0ff85b7850e00bd50b10cb25322ae463fe08916158a"),
		nonce:           decodeHexString(c, "9aa741c4faa9bd8150d12614"),
		personalization: decodeHexString(c, "e138f0bff72f7e1192dddb3e5f0bb36c49cf1335941df9fc"),
		expected:        decodeHexString(c, "bb1546b07894dbdb7eedac4487a84c08ffed37d1183e8f9f18616609a1c0aefae244f740249e930c9f66f8c16ee3f5a58c323df5bf0b58bb020c7e903d06a6c1af96066da1b3e744bcfa3445c99bb3c3edc6e832001a70773dffc5dbe001bfdaf3b3987a6dbe905acf7f15c9228188d5"),
	})
}

func (s *drbgSuite) TestHash82_SHA512_224_9(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "eafb4ead0744a60ec5349c4f6c997afd9410a3510513b821"),
		nonce:           decodeHexString(c, "6b236aa2e650229561cba5f4"),
		personalization: decodeHexString(c, "c6d3a51e61733a124d4580515cbfe48214f6538862f3cee4"),
		expected:        decodeHexString(c, "0282a5b8cf8a2895bee135ded99ecd62f9f82badc61cf5d1b98850693e920caff4aaac69667d2c2d705cc818fb0ce7c7a87b289eab60d7a1f75dc963b6f0b2badea43b75f1df470dd540a7eee5edb082320a9799b3863e873eca71287c50f01743dd46a3cbb8bd50b292e0e48e1e33d0"),
	})
}

func (s *drbgSuite) TestHash82_SHA512_224_10(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "3251085c799a617933c43263559d4079bab2066c12c175ac"),
		nonce:           decodeHexString(c, "f876fc6367bb50e29a65ae27"),
		personalization: decodeHexString(c, "4ea8910480e2f10f01322173d4bf56e78fd28e5a5ea76dce"),
		expected:        decodeHexString(c, "0db26f82dc278cdfe28018720a21b08f054205022819cf509bcab48726eabf2333208d06604b0ec58e75c0019cc0db64dfd51d42e4652b062f97402c5c9e97be30258ac93cce34f5eb72b46b8ac0e1463a4f91354ef3a0e728e2553bba05f483652ca09f3cc760afdd32887d8281e4c2"),
	})
}

func (s *drbgSuite) TestHash82_SHA512_224_11(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "bffe08de3c6ada50493bf7710c4f76901b29d4f5085e75d8"),
		nonce:           decodeHexString(c, "9fe7b08be59ea8f984f7bb22"),
		personalization: decodeHexString(c, "50c5baeb68259df26e9393376015446fa64f13e53ef99802"),
		expected:        decodeHexString(c, "0405a18d3c876fb3d492096e55ab18f2c2d871f6cf877d6aaac4f0b10f7ec94d1f0fde299b1fe20a93b7bf5b5cee8afb8311c7af0f590f9210dc93ab2ffd5be8afb6917bdd54fc8bb829c68065b02394b3e14c91cb6d45727d09225156d4d74aed091d349784193b26504977baf8968a"),
	})
}

func (s *drbgSuite) TestHash82_SHA512_224_12(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "baedf1669fb2adad3cf4dc057f165445f88dc2ad8d10b0fc"),
		nonce:           decodeHexString(c, "a06e451ab4aa19365f6593ac"),
		personalization: decodeHexString(c, "96ddb2bafaaff6992a320c37ba30e6775cb4968791f0da2d"),
		expected:        decodeHexString(c, "0b4bcd441f192f1497a435b12153a52d3d3a27adcffd87bf366de3d1f7fc2909091eeacbcd8b3bd7b110a410cdd24e70eb7b993b72fe69e606c9e67ea7fe1e75ddf4f2d8833e79914d1cfc4b2f9d75e4f251980b2e99460bb9026b8c1021dca83f7396aca5be746515ee8476aedddf33"),
	})
}

func (s *drbgSuite) TestHash82_SHA512_224_13(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7d829378240e77befd623cc191b42c0353dbad49556b6868"),
		nonce:           decodeHexString(c, "ff36e29ff50e871aa2c219d6"),
		personalization: decodeHexString(c, "418df77501e64240b3af94b01e623d3c1dbc04cfe89ef1bc"),
		expected:        decodeHexString(c, "57743e47cc9d88534cbf28dfa195f6080d73b5fb202382cb2ada100f3522fa89f8b0b1639ca7229fa7c44ab0dda3a064ab217f0793027bc88d119ff056d66558c7bc63db483703056c01bc73986ef5854c265f5d2894aa12cb684773008f51ddf761119dbcb8376fb1f3540200fb0916"),
	})
}

func (s *drbgSuite) TestHash82_SHA512_224_14(c *C) {
	s.testHash82_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "65b70b238a1a7107b83c1b9f1270bf1ab4ab454690f3333f"),
		nonce:           decodeHexString(c, "f2435f70e075f8044d4235cb"),
		personalization: decodeHexString(c, "80fa0ec5a3a1b46cd639ae19c137239ba8113db33984c593"),
		expected:        decodeHexString(c, "e547f6d8cd665204f8ebf6d64ecaa23fcc59c1682eab3190bc76ad4981d68810833f1212965def4868883529c0bae4a2345da6a0e6a7e766d16022c6f371db8ad089d9227e3a85168d080c3ff2bdd604e7f8404a16268bd66d70f5fb164cee60f1af97bdb6e1d72059d7028a13ec83f5"),
	})
}

func (s *drbgSuite) testHash84_SHA512_224(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHash84_SHA512_224_0(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "9adba4f888747eb59b4754790ad681ef015fe6707acc4740"),
		nonce:           decodeHexString(c, "042ca5d6914bda92b9cae9ad"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ee99b96d6babe910dd8e042cc028dc0c76fd63929463569687669b47b22f8472a3da67b6bfd48320970cd61d2a7a06dc62e0cf496aa4e75bee83eda197f164fa275f2d9043c2bde8c87fd1b0c8673f8793e66c7ff26ecaa22c1b79ec5fa8f525474247e80bde3690d48d0381d6a484e1"),
	})
}

func (s *drbgSuite) TestHash84_SHA512_224_1(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "16697879a21c21091bddfa6c27aacdf456af7949607d19a1"),
		nonce:           decodeHexString(c, "d96f230702adaa8dd09ca95f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c82a5a60a240858db67812df34bf1e5b5c7ae6d9d1d2d9cbd0aad4d50eaf1ac4029215ab2081fa802b359e87dcebc7517e61a5ab239bd8e9e82a670b9fdf101cb04c2d40f9743324aecc5e83d26cbbcd1d4d6262135f34eecd17c2093b9614eb52d77c1d57b6ad51956af395c4d7a05f"),
	})
}

func (s *drbgSuite) TestHash84_SHA512_224_2(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "acb035ec4597de66d5b298ade97e01094dd21cbbd1b2eb14"),
		nonce:           decodeHexString(c, "b5129b90c1f942a078d07186"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b51a58d7d8fa7bb83fd1c871c954a141555e1e01f73b67c13a613a8a7b65736ab6205bb63bd3c95c8d94a29883b4d1349307baa781a3e2e1346537aafe98d040538609831d86424067eb3515f4d34c1d7c8ecfd48b7e1d00b71c370697f2870bd3e2c9ee65beef855f5e1520dbee119d"),
	})
}

func (s *drbgSuite) TestHash84_SHA512_224_3(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "dbf353cc5d0522f8fbe08752c7d6c9f67f8def3720837aec"),
		nonce:           decodeHexString(c, "922f28b3c7f11cb1bfc2151a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bc720a1a5a27beb5963992537ab2434da6547867b8a6fdf2bcc902fc54e5ad282f4277964536973f9c080226b6ac6333b216dd60ae015e0af1b8081cdf4782df65aaaf138e1c02322bb4a14900cb624c887b453a9607e79b8d9c8b630f4f8f9f5915c4159931f9c4252d92db3bb7a0e8"),
	})
}

func (s *drbgSuite) TestHash84_SHA512_224_4(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "3ade8164ddc5518c56b8e27dd12d729808441543093d2071"),
		nonce:           decodeHexString(c, "fc55f735f052a912d8d844d1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bc305a5dbe0de0c96540f3392f06120457aa12001fb1090d2871ed682196d63333c68767dddd760c5aa033d802573166ee5af4b8449b93dee686632a771070dc7767ad4feb798080951a1f5de6847843dd4a5e81f8f6c7ec17725f2bf1375508b4b1b9a2e74b8f7ec52251cbf855a866"),
	})
}

func (s *drbgSuite) TestHash84_SHA512_224_5(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "075804484a8e276ae130d319724f6902ce63916e2bfd8ca6"),
		nonce:           decodeHexString(c, "22390f15a33ad072e6317986"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "19c343c0b156f023de9dd804335220cd0132ae69471fed0327a678a5ab1199f7a9492a2295f69a6e1ce7b7771c1dcc6d2ac7f10108104aa22b8e413883f59cd8b4fce06e17ee767a9d35a7b4a3bf415c926e39c0a4a3a151630b06a6277700b24c7644587e126966a0ec401452bb2805"),
	})
}

func (s *drbgSuite) TestHash84_SHA512_224_6(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "c48b3edd0eaa59b5b597e33d06686d45ebd07558ed706cd8"),
		nonce:           decodeHexString(c, "a674b554357ecbf7f11b8224"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9e7dc7c3a48c6da3f2e48f6e4ce8d19843f384b2dddc99ea78e8a79780d37a2f04cefe31c106b593c5b8ce5fb63314488feeeb2dc6bf0b46ef62456bc0c8717e5873c8ee78788f8892f10a62de78ffe63491dfdcc7069cc81e9c2a5b70bcc807d9797f926d5aef5c42c53b7608bb5b87"),
	})
}

func (s *drbgSuite) TestHash84_SHA512_224_7(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "5783bc44e7581781a6a7a91a251b277b3aa9bdfdf79fcaf7"),
		nonce:           decodeHexString(c, "1262f4e9c5df985b33359de6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0985885ac635d9361f1d3f8a08d0c3222713e689186ed6d761618a8843bb3f2c4d8831eacc70926cdc2c125603ca4c9190f387e0da5e72565b7530259f58d85e24765ea4059a26a0f3136ac03811166b57c876c529deb268e031a2b49405b695ad1165d66dddebecf9a96737f184ce63"),
	})
}

func (s *drbgSuite) TestHash84_SHA512_224_8(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "729e8de3d5f8a92856d9f537c1ac4f06f4806f79bb795e5d"),
		nonce:           decodeHexString(c, "48e8bcb81b45d6b2a5402df1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d8af0382834c7a2f22a40831c827135f1ec801cbc2f5fea3575695a585bf12a0ee7f09b9a0143181493f9ccf027d8be81b99077f035e7d26ea78a83456fa208a1fe70a7239c40607e946ff00094c867ac9db36182c25cd7717202c0f71a20c486816d5ae628aa89c181894468dbb81d5"),
	})
}

func (s *drbgSuite) TestHash84_SHA512_224_9(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7b8b66ad077aa353bccea7c2053591e08f961a1c13dd757c"),
		nonce:           decodeHexString(c, "d96a36123fec868284ffa6e2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2cb858bbcc3722b3839d7c179375e43a30198a1528942135ea8c3aa36560635b80379f96a17154853bf75731cca14cc506d5e547d5e1d7b5af972507a4392580ee59f5b1c9ced155c0ff61c9d4790d03e870d52125c29f9827baebdeff34b1c8d8b586439e3dc42990787350428cb0ae"),
	})
}

func (s *drbgSuite) TestHash84_SHA512_224_10(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "a5961a00f82563e89384310d53fbafd2ff3b1c8d729b5c3b"),
		nonce:           decodeHexString(c, "8ea1871eb02020da39751fc2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "59b33b69aaf52948cdcd0a408788a0eadeba9d40198d43b815897a71adb441ddcd09276795250b527427c72d15acfd7c1e9bca417b1f079b4b25ff0876f051322dded8b39aefebdb24b11baac8659ea83afc363d9f1eda7dfb5e973e5736467c551089db74b796437afbd5e6f0248bef"),
	})
}

func (s *drbgSuite) TestHash84_SHA512_224_11(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "a961b933a1c9ad696659e5e87f5b2d92bc470666fa3ae13c"),
		nonce:           decodeHexString(c, "81ee1293cdc958aa629cbb3e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f9138e627879ef1dd36acbbaaf8c7a23cd52a4f0adae38cd47a8082458a085da585fa87402c9ae333a28f50bf33865737a8db85ee9dd2a4c86a7bb4d0d4c47c5bb57ace31df78b11cb2835a6ff7187a0a322883b28215a532306fd8c380bae23e13605052f737fb5bd8a5ab0327931c8"),
	})
}

func (s *drbgSuite) TestHash84_SHA512_224_12(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "8db9ff5b00e13418a902135f279e268ab923d1554008b29b"),
		nonce:           decodeHexString(c, "fc8c8af3aee6b77c4a8eebf1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "2a5389db0f0c697d32ae0cc477bae8c92a670e19b7e431783ad6c4e7fa6572aecb40d04ee87a23491ed38a2207e90c44fd3cd1271b470690aa5f4eafcc834aef64a1f8d98c4b4b8592f17ce95badaa4e75fc95c32ff52fe66bc611d312eb008e7d22c7eea53894b955030d4b842e7680"),
	})
}

func (s *drbgSuite) TestHash84_SHA512_224_13(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "f859ceded81b96ab234189739ad6454bdaed399822d14fcd"),
		nonce:           decodeHexString(c, "42b14df0f8f9a1690f3bee46"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8835761208b138ca1720296e1849e32e1a02859d9ea76298eac19cccc3663ec9308a2b68ebd4d18024d4f39ce560a0bd3aed9c52d53db1b53baded8b2d24f1ed5807caac9ceb6595cfa024815d32cb871ddb71a03b116906be43b5c7890729abf5d6379333e24e78192659774b2e3165"),
	})
}

func (s *drbgSuite) TestHash84_SHA512_224_14(c *C) {
	s.testHash84_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "3879ca720aaebb2a29c99c0aa21d63308b44677f2bbe6056"),
		nonce:           decodeHexString(c, "2642dd7030605b3608f4513e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b7ddc2d0295a550e44103ffe7e6e1771cd488fa2ea32b091076085284edb870220e02ba6facdf27d8b34209048d0aa4cce4556c074fc7ec2c3691b95aac3f47c3b42bee3c2e35da17b040188d47b7effef8ac471a669f29e6c4b97ff6836cb9fd8954f57309a97e9a697e061010525a1"),
	})
}

func (s *drbgSuite) testHash86_SHA512_224(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHash86_SHA512_224_0(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "6e6710c92a30ecc014c1aa6f22b0951cc0430ca16255accf"),
		nonce:           decodeHexString(c, "45b5b13de6920a077b2810cd"),
		personalization: decodeHexString(c, "007f8d3fed0d3ca512ddbd457fdda84b8fa4aadb64ccf03b"),
		expected:        decodeHexString(c, "fd5ac10678a82e72b59b4b980d43e3113f27bd37982974477f700d73996c04d357c3e56f9e62c4d1c78d921efbde081d6ad0ff62e3a5816084d7206cb4bbc95b8f7f6fa2e73e5644f7a6801b603b730564b523c9b078c36cfb2ab6cbf05a0777f4ea99be0b75d02277a577032dfa6c16"),
	})
}

func (s *drbgSuite) TestHash86_SHA512_224_1(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "af06de911970172cae8fbdba5d68a704d45a2b66fa10a64a"),
		nonce:           decodeHexString(c, "9c150019343b6121c7ecadc9"),
		personalization: decodeHexString(c, "fd2d79e8d237b56c423496e093f3c0eec3d42d6d495f5867"),
		expected:        decodeHexString(c, "58c46b3be593b27bd9a291a2f0bb2fbaefc50f4713dabcb30696d5bcb088d042697ac2b3209b5eeca580ed218ea277edd9fc79323f891d471a84e6c45bfb161594b8be949eb7502d3815ec88b164ce1469bd78a1a733aa3549258e64a5856b0faadaf084f9e69f0a437f47a9bb363ad6"),
	})
}

func (s *drbgSuite) TestHash86_SHA512_224_2(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "4436c8a1af7823cd4a7a45ee0e69d711d403e74ec6c69c96"),
		nonce:           decodeHexString(c, "55df37296d72605af0bef1cb"),
		personalization: decodeHexString(c, "24d2cb8ac193a62ab79e06221871a6f0c01e8ecf4dcda0fa"),
		expected:        decodeHexString(c, "af29c84946f492f67d6f7f8772c12745a1683d48692b7b76108c4f1b5f64acf9aa7c6cdbd11dcb5247bf7f3914a147d845ede06afd4861dab3fbbd3245107adca4c4f462674b05dd5ba6264b5606b5a4fc1c1775024b38b86025706db7927d2525a2277b06e0fffe92c141e452cc39b3"),
	})
}

func (s *drbgSuite) TestHash86_SHA512_224_3(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "785124d2a657d0d9c7aced67d052af7ef3ed276e99f3a134"),
		nonce:           decodeHexString(c, "8580660681ccc094d999e906"),
		personalization: decodeHexString(c, "1d05ee577ead88fac87d5e5d6fecb3e995acf859d01bf923"),
		expected:        decodeHexString(c, "46ca8576b7667fed06438c9cdf248eac2b4dec8f8b8ddd301b907a0498e754095aa3afb8199bc1fec276e93289c3fa3a976bb84cf41bf0cc243ac9b9513bce3a65abbfe8d8c338fad7e889d3ecc4a036d188efbad6da1fa8fa63e6d861aaa2d752f123df6a8ad56fd3e113ac15970c49"),
	})
}

func (s *drbgSuite) TestHash86_SHA512_224_4(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "5e3c0551e9f8b7ade059965154ddfba00cd29ba005c30e4c"),
		nonce:           decodeHexString(c, "4bc4b1b444f4456a689d1d79"),
		personalization: decodeHexString(c, "d11f62673361a7118820e1b9e64ed62432b56e31bc6bd4aa"),
		expected:        decodeHexString(c, "e4219a090ede86c2a34b8565d09364a1015a979221ae2df30a835df57de44a2ff32971f9878566597366c4201387f7fea93589b910bb82d99227ef64f7af6294ac5a434794ca1f0432c92677d171fa5d870c77d2108dc38508fb580577da77bcac39cdfd64187e2779bb59807392b809"),
	})
}

func (s *drbgSuite) TestHash86_SHA512_224_5(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "daff5ef6e2c193348c5ea64796a7e6788b8654a8309d200f"),
		nonce:           decodeHexString(c, "62c6606f4ae3a6fc4aac397b"),
		personalization: decodeHexString(c, "41178dc742ff695cbab25da273a5aff44d0499133a3b2246"),
		expected:        decodeHexString(c, "36c11234660c94260a06c6f7bcf2d9bb655656e5a383759d15f5c5dd4b6e48f7168bef004efffc3ae365652964a7ee7a885ac29f6f6b9ccb51ac77e35078040dc6cff7ec03d01d8ac5a2ed16058af9cbe5740cef6073cf43f88daeb6504af3c8e6511ec2036d2e353f034614e32b19a8"),
	})
}

func (s *drbgSuite) TestHash86_SHA512_224_6(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "a9c1318ff59a561728c9f26924acef51ecf46e75b2d9a7e9"),
		nonce:           decodeHexString(c, "8582f0d6eb3e3f465a5ad313"),
		personalization: decodeHexString(c, "cbb5a1319fcc9d0a9b96da31f626c2ae533aecc93f35faba"),
		expected:        decodeHexString(c, "a7d61a982c64fa7674f97172be791ce0b364a2e32e364b8df1cfec75291ecec19d599bf5c4ab9735240817d7c52b46c6a2e2ba05f9ffff9b19d742e056c3aa82e7be015d7b86dc99036a3dfa729cf078fa5ccb9e2bccd79142a4607f4fc94ff78d951581be4e9935f0861623bd06eb0c"),
	})
}

func (s *drbgSuite) TestHash86_SHA512_224_7(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "2eb43ca2539335eedca293dbcb9d5bdab627a66afbe7c108"),
		nonce:           decodeHexString(c, "06b3aa48769d3d8d2dc8bfbd"),
		personalization: decodeHexString(c, "a052b0dbd0df209714085f49d786b6033871296ef64b85dd"),
		expected:        decodeHexString(c, "81d156ff0d3c8575f406f890d81f409ca8aa128b56e73ad890dc1f36a0b466d4af3e78747e106cff7b17f27ae95b73ba8aa09aa3608b3be5877641fbeddbd5aa26ad0bc9152a57a4f75bdcbad8dc74f5ecc8cea6852c078cd9639515a9333e3e426ccfcf452eebbd4b7ff399ad58afb5"),
	})
}

func (s *drbgSuite) TestHash86_SHA512_224_8(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "0de760c9c3d76e864339b5490db818e4e6db41c63a41665f"),
		nonce:           decodeHexString(c, "bb1a29370c6e57eac8f646c7"),
		personalization: decodeHexString(c, "e6b33288a0f6413bc826f398f8bd6c12201a60c16c2c26ef"),
		expected:        decodeHexString(c, "655ad7daacd83cb1890ebbd6ef5095d8a4faaf5f6583609fbd9d9cb59204148c6b732109028cc1ca56a1708938fd835b3f841aabff5179590612671ed7ac48b48c87defa49811d95b5bb88246e9f8c1b246be6066d94865cf29e228a8a686b820cd7d762752cf9da15adc8066b161274"),
	})
}

func (s *drbgSuite) TestHash86_SHA512_224_9(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "8313933bbb67aca8534cacf25dac26e9be0150ebf7e74d91"),
		nonce:           decodeHexString(c, "3d9627615e1ea6d5d74afc0d"),
		personalization: decodeHexString(c, "11a3c0b1c19cb1d81d4ac4a99132ef87ed2ea757463ead56"),
		expected:        decodeHexString(c, "ab5b3171983d19ffad762c932fe89640d5c4fc0dd27f87f85240a80ac59a08b55a62b4b4ecf4d3cd11232a2435d4b8c803df6b70cb801671dc45b5fec76d48bb4f55ba91aa942fda880cb2bd8c3dea412b0c3f872b35299fb80298ef5b81d22e84c4b60479b5421b5f9f2d2b9a8c6f8c"),
	})
}

func (s *drbgSuite) TestHash86_SHA512_224_10(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7eb8a42a6d3b773856fdd615fa8f0faaf265d09ddd831d9f"),
		nonce:           decodeHexString(c, "3ebc730446b23afab85fd0cf"),
		personalization: decodeHexString(c, "8d2883a3a40a4a849b79b9cef7da2fcc1e5ffe2b4e8e10ad"),
		expected:        decodeHexString(c, "50a43bf5120962bb141fa7d9dd669112aceb00b5ae6adacc6047f7fe1693bd11b1f915219c023061867bf1bec19c2d3849ea3c566d1c3c491540c5c84b4727e73b12c9e1bc4cca577f6b2cd3c9b626fe91672f0ab624f76a1e13cffe1e2daa513c75982a8e7c6b2f3044c21c6159c924"),
	})
}

func (s *drbgSuite) TestHash86_SHA512_224_11(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "75d715ed43edc2506564c06e7dcd3ee6c6f111ad999b2488"),
		nonce:           decodeHexString(c, "c00a2e3c32ed1e0b2e435dc8"),
		personalization: decodeHexString(c, "0b906a36230c92785838d09a03cb8a0ece30138d61cc11c4"),
		expected:        decodeHexString(c, "51328103fd7e7ed67aeda05059570892d775205282ea925292e8febe64c01bdfe16e2f6afbf7de7323c337f7faca3f253485430c8d3e5f7086a647cad2e307cb80b9725d57ad60c8046b16de0c29d310085465baf966041b6065d72519f92a637a486e43a39199545a8b1ebd097986ae"),
	})
}

func (s *drbgSuite) TestHash86_SHA512_224_12(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "54891fc89ab7805b3129c70ecad75c5331bb821b8f1c3b1f"),
		nonce:           decodeHexString(c, "69187d8c108c876b1c283aa5"),
		personalization: decodeHexString(c, "62d69ea0f81954352f554587533838e6193165f36b7ee737"),
		expected:        decodeHexString(c, "ad82de4dad4beb78281d29a0e34e369c4f35de269eadffe95fcd4a44e6dfbd311587f80acc869cb84eebbc48b75d7cd83e3a790cac2f5b92e97c0ffe4bc08a5c5ec38460f79736d978dc53758b6598ea6debda6068121ac1804b2ea6e684b9cda6e8786b6432632ede5fb40dad7e0f20"),
	})
}

func (s *drbgSuite) TestHash86_SHA512_224_13(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7dc68690b5a7cbc776c59419326d3fd8dc343dcd91d922f7"),
		nonce:           decodeHexString(c, "6d72bc54cd426fe51815d88c"),
		personalization: decodeHexString(c, "665f6e331d0a7bf0bef0cefb47bbb41485618b97f116c7d2"),
		expected:        decodeHexString(c, "f502a71908f9396591cf21b2f3cbad59f7253af8964cedeab7d307140dc4baabc3831015e9498aa5657b11b22953a0b24da5e4e53ce9db4125ba325d270339c34e50af89df0e1370ab2c40a3989cc222d68ab14c443ddeee929b78841b02c82b922d5a88ded6c9b5a7d8a47d4b4fc397"),
	})
}

func (s *drbgSuite) TestHash86_SHA512_224_14(c *C) {
	s.testHash86_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "23c19b9ac1ae1ce4bba0c0262fffb615d010b317f7013ff5"),
		nonce:           decodeHexString(c, "ddb5c0cd2b4b640898c2fd1a"),
		personalization: decodeHexString(c, "a096d62f947314691cfb647cc2f331af834cbcdd5918f099"),
		expected:        decodeHexString(c, "dc9175fb05854708739c3da005592ada29d408ed6162dd278ee457bd3304e4f7011355da2302df1d0d190ef846cadaccfa5325d3f71c407ab2434d65d815dafa6ca15f7e701a104225a839f2fa9874ad49bbdbee576b1bc71ace28c825095510890861c851bb79e2e2e922c3ac22fcde"),
	})
}

func (s *drbgSuite) testHash88_SHA512_224(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHash88_SHA512_224_0(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "a1eea5996a5a9bc30ef4d3a83a07aaf3e29bfc5070835d69"),
		nonce:           decodeHexString(c, "dd272151121d5c5a851173ba"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "340a081e6a7b044485ddb306c8aa26133a6d88dbd068bb622fc9c627f3d5b92cb783a6720907c50518963c911d836ebfbfb530e85b7ddc00dc9e262922b5354841ee4ce13c67cebbf768131d189c4093577b31ce136839c60052a4a57109cac049d7057764fe9c63d8f13ae2201bcb3a"),
	})
}

func (s *drbgSuite) TestHash88_SHA512_224_1(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "90b6ee9f10d340cc43ae5edf72a9219c96ac7d9efd91648d"),
		nonce:           decodeHexString(c, "da5032b93360b0cf804d90e8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5a1daf8c44000fc7a21f3868411b5f0a0366669a3620e0566dbd10f5b43f7b8d827fea6ad97361a0c8c5d90f1eddc9642107451e0aee275e30d9cee80bee182fbf4cfcfb647eb32de8cd3dbdde58ed4eac8b74cdd391e16f26885bd049a889341a37e8bc5e6fa56bcaa4bd81597534ca"),
	})
}

func (s *drbgSuite) TestHash88_SHA512_224_2(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "d8de4335819ef3e045145887e3ee56390171764276e82280"),
		nonce:           decodeHexString(c, "89ec41b62c811bcaf403257c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7377c76bfe76fd807582e066e629386980398fd2dd93a3bfcd476a626e1a46b7f72da48603a0800702debe1e50ebf4fbb2583854b179c242eab345f156cd1050c136cc5a59fa1a8ba160e793623ca665bd9b22488ff018713315a0e5fe0e6f86321fcff5ef753002e8a3253e849de9c5"),
	})
}

func (s *drbgSuite) TestHash88_SHA512_224_3(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "4a0f5b66c344f6a603f90073d1aebe5ac69fb88af67a27b5"),
		nonce:           decodeHexString(c, "8ffdd2352cbcb4408c8b4fe1"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "eb3b6f7bf9f4431e44a7265f562968d762a298513110066b226f3f7c8c7821eb00d3caf950ae9002301ed3ce20bb473f76160251017830e7605c3160e2b83dfdd516e20b00f9f34070af76b8efdd23019fb976a3daacad8bcf158c82b3f2519907156ab978d15beccaae43b807ea60e3"),
	})
}

func (s *drbgSuite) TestHash88_SHA512_224_4(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "2bfcd1971a175e5a6e21920ec52791753eb1089875fab23a"),
		nonce:           decodeHexString(c, "81921e9cd6d27afab41e57ab"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a2bee41f3f38e2f356c82e461edb05218585eeb3325016d4d2bddd538e585aaeaf9b09dc652317b47f961a6ac424b28f4600f525e73689ee871d016e78c5d49e1a250409eae07a29371c43357b95d0bd9a02ffeb9541790344dfc91fe204bee47a8faf70dc2f885590f2a1a18d5a534b"),
	})
}

func (s *drbgSuite) TestHash88_SHA512_224_5(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "9f09d96326362aa176874095dba668ec83deb995c17eceda"),
		nonce:           decodeHexString(c, "6e17699a0d655f4752d25f69"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7bed096952b285b372f208a300b142c479d89a22b6098eb4b90d6a3b299977e2429a9461c71e7b9926a0774125475dbc8f0c1c127c916b2ca32bee8e8c28bb6a8390915763346b29a01fdb313c617ca91f382467befb89f5e58a63b1e3f826c1fda9d953709e0d91109309ba07bcc2ae"),
	})
}

func (s *drbgSuite) TestHash88_SHA512_224_6(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "b244d85a21073232c82c821823f196d292bad5295c922423"),
		nonce:           decodeHexString(c, "4ade801e3750dd91dbbe4173"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "44cbe6ea80ca8c9107de7733fdccafa6aa285ea82fd26b778cc2b93c652b3173bf9eb7988fb872e82794fbcc83ef0b83644d0c8f84012174cd1accff643fb57dd9ba992cba911081ceb3f67e654a4a2044195f16ad1092c095d52c1ba5b04964e2fc46f30a59ee8a5aff41cbf00ddef6"),
	})
}

func (s *drbgSuite) TestHash88_SHA512_224_7(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "261495e2cce8181f414ae5f02a5dc80332b06424b5d23676"),
		nonce:           decodeHexString(c, "c995ae783f33905a315030ce"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c5ac2bab9d7a3e0e016f3400b5878826b85df58988a03969ee3ee240a717215050518ab17f276d8bead20d2591ed6fe4b98d00e74e264c2924ef5fef18fe39d7443f94edaf831736b52e8eebd89afc2331e1d5411c59216b310c99ae1219dc3375a87ac7820cd590f162f766df21361f"),
	})
}

func (s *drbgSuite) TestHash88_SHA512_224_8(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "60198ce36d280b35c8a944d36ca19297e980ca5241b35056"),
		nonce:           decodeHexString(c, "ea5d96bad5525bff0db96ec8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "62402bacf66838c7fd7f69eb9af3bd6c7c6c88a346338fa340d1245af69a935e1d0a8ddd98e38958cdac357bfd1ce65652db99416d6e0a9ed1757b5167ad23bc14629fdf0422598df93c3996298e7dff16a0c02b75a6dae1b459d5398424ea930b016a538b14cf05f3509479af9d4f4b"),
	})
}

func (s *drbgSuite) TestHash88_SHA512_224_9(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "c1e02fd43b86dcdcb40e454e1630f44d673974165e67f3ff"),
		nonce:           decodeHexString(c, "b2b3a26dcd32751d517f81ea"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b884469b1b9f63b73499ec814685df4c794ef0db26864bced7ee6cb7206882a44d230e5fd6ff3a539397d3d099ab1116307ac94f7b16a041699838985c89dfc60eab5016055b0605aea3779d00918f0ebb8eb575f50b46061ad578fcd785e3ed639a3bae07533eaf6b0baba2db1438af"),
	})
}

func (s *drbgSuite) TestHash88_SHA512_224_10(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "f07143d93991f1f2a320505309c15cb2732e84cfa76ca1c4"),
		nonce:           decodeHexString(c, "228282541a29052f64617903"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6bd0cafac285894ad2d2d4399eebb2d44a133d1cc65832e674b7b601e75527611e5d7f9716c624cb026936d7f9aef9300245e061407345ca0da411ab3e21104738c32afc62f8944ae2040db6eef6d5caf57a36b1baa48458a064616f21c6dca5757ad5f880350dec8f5707a27cbd5b7b"),
	})
}

func (s *drbgSuite) TestHash88_SHA512_224_11(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "c41f4eb1d82e66940ed38e18dd372907ed1c579a5a92ad63"),
		nonce:           decodeHexString(c, "a0d3a5c0f8db3d6cfb9bc4fb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f2b2872a29ac51f4c5522408af7c7d66d909a557a79a027e7171a8714167776b5a372604371fedae1b173269fe7d8139b7f4093599736f8d9cb315820ac2061bef6869e97f3d33f7fb79ba57bcea537cbf0a96869dac4a69cda5ddad47ed5d96880c222e461e5ec2b1f4813749a94372"),
	})
}

func (s *drbgSuite) TestHash88_SHA512_224_12(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "970c52538b1d5ccf06c66de93301cc139bdd90307c05d357"),
		nonce:           decodeHexString(c, "6fcbc09b40f49f502e3bb557"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f509589df9d4734a333e04b2a920703b9daddc16da84bb798f77a26500d584d99099042ce5cd784c57135a26470864873b83707ea9e0adc7bb8e930d5184184985348c44a23ba2a81a4188909d80a88b611322fe621f53e0c2a0c0312bddfdd793d1eff95e4a3e620f83a3e41fa8a7cc"),
	})
}

func (s *drbgSuite) TestHash88_SHA512_224_13(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "cfaaa279e934c56f0f5be56aeed7d634aa1d4d3b423a2027"),
		nonce:           decodeHexString(c, "efa4ec5a62f2d9eebac36340"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cc15948050d2b54c4275155a37930aeec88c9e023c07bb7d2bac4c1368f11fb171fa39c4cfdd16d1bdb20530897e379072179686afa8f32c2837920fe6d4bd62d23da391dceb5b3e46accf7d51a621d550f5648b857bd0f8b91e89a3ad887f8fdb64cf943982f2ed718c29ec7343d3c6"),
	})
}

func (s *drbgSuite) TestHash88_SHA512_224_14(c *C) {
	s.testHash88_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7ce7dd98c93953a8b60d395a68f03b8919931031e8f68bb9"),
		nonce:           decodeHexString(c, "1c217188f9c7980b8b03b41b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "58884a4316fe8104459bb339a4bac08d95461ad8e58f333eae5ceeecbf2d375e8fbb82eb1d29890ee0c56037bbbac8cd8e202d7ef05ed7126a15064699b9dfd4523782aabc6eaf21f1727d02c1311f5812c4b4294827a75f1cd6e6dcc73ba45ea8fc5f2647dff725f5fd9bc64d7b21ec"),
	})
}

func (s *drbgSuite) testHash90_SHA512_224(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHash90_SHA512_224_0(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "d2c3aecd6b8e486cb76eab38e5ebc37b5070f6a790e092b0"),
		nonce:           decodeHexString(c, "0f64a8baea52bd3afc8b5dcb"),
		personalization: decodeHexString(c, "858ef40692b7f7e62f3169fa8a13c98d8f6933e50ebc8c75"),
		expected:        decodeHexString(c, "d12a8f8f008459664f44c573591dac13151f862af5577578e3e38289743b8a080b907806cc44f9c47332b1003da2c21486395bfa81ff6187cf8ad8810d35606376e099a1933ab6852209573c8d8a0e4352dea51caf95052e5f6486ea14789e4d2c05c9472f1183686340ce301f4fb6c9"),
	})
}

func (s *drbgSuite) TestHash90_SHA512_224_1(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "91bcbadfff067f44a0cb9a1b4f8f438e03c9b0843e27ac3e"),
		nonce:           decodeHexString(c, "c291985430f9c5b07fa1eeeb"),
		personalization: decodeHexString(c, "c641e0b1ec8f43159bad85cfd577ce65ff567ba7d00f20bc"),
		expected:        decodeHexString(c, "3a511c4bb4f326ac0ce253c4c34051bad1b06fc6b7bb047af3fa49be2c2786390d513aa787de6dc249d3cb6c8559774f477af2cb0046d2e0d75fbff5be4e7d31bf148df55339e1c1c08e96529eea8cb931a17625605c0e4d52c4c8360f33149e5baeac5aacd9b7515ea53035ba15fe31"),
	})
}

func (s *drbgSuite) TestHash90_SHA512_224_2(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "bae11100f3b038d02df5504ec3586710b453b141d03ea2b3"),
		nonce:           decodeHexString(c, "24f397b2eaa88a79b4c3f5e9"),
		personalization: decodeHexString(c, "1f83c3423b5e0cf93f47c5c9f6cbd572868c3eee4598a631"),
		expected:        decodeHexString(c, "bdf0c385401bff132bfc64bcf6f61bb337450f5e3e7c74b062c2ddaa657e5b29ff1bc65a9052b1cf9d620d999dc9031ced8b301f09dcaa0a830ff5f93f837dd118126e89f7c1f589f65de29bae3eea425f4e7409b79885f7724d21ceb52677e4c823e37632a03b9ae46fba675ce4a02a"),
	})
}

func (s *drbgSuite) TestHash90_SHA512_224_3(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "c2db152b8262365b4bf4aa660b3e070f12e6a14661224adb"),
		nonce:           decodeHexString(c, "a5b7010cf753eff0d8a2c1cc"),
		personalization: decodeHexString(c, "723f791c5149d19889df6a7fd26e6f3515e929c573f4ee9d"),
		expected:        decodeHexString(c, "4f83a33fe344b532956bc1b8434b013245e125493748f6e607c5169fc05e2474c703f688e896cb518d2c97d732de8f9d71b1d21e83483875f81069ca46d276e0f205079006d8589b70792abf143e141cc9b806c5209f4b531c6638393d61194e5d0525aac52372aefba937dfb4cf6b8f"),
	})
}

func (s *drbgSuite) TestHash90_SHA512_224_4(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7c4c298c6f162ef881e9efaf353c1919d2ff61c663e799ef"),
		nonce:           decodeHexString(c, "a8de0d8f94afa79c44743eb3"),
		personalization: decodeHexString(c, "c9950f64970dffdbe517d6223402230c46cd2f1e56a3dc7d"),
		expected:        decodeHexString(c, "190f43d2b90ef83a1aeb14d400e6ccf549ef524bb4e3497a7b3e3cd013091049da732ce906f038cf8b44ca9a2c4ec932af1713e225a5a0d4e0263a04258cf205e94826cc855bda050e45ca63d0f77011b0f8b8f4d3a6ed13b3192f1c1bf77a0b640c038821f11d41b4f88b91d068ee1f"),
	})
}

func (s *drbgSuite) TestHash90_SHA512_224_5(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "946d612a20f4faaf16e3426e903da5a6aac3c3f5d2929684"),
		nonce:           decodeHexString(c, "87a348f5273c351adcee6d84"),
		personalization: decodeHexString(c, "473125a5f41e02787ac3aed779d82879767bc0b99e9d229e"),
		expected:        decodeHexString(c, "269a92f3f76485d79ac532157b1db86857e47d06d31a9baed10f77ac14535ec3755f0d62d5ac7a319afed2c97e80f763d1a34d9081c930a51e0ecca69de5993603c8fecf48d2724daf0beee1a2121b46a722184201a1e1d458f546ac2ad7efac9f6b1dc04b86d6fd3f338b73e51c0dac"),
	})
}

func (s *drbgSuite) TestHash90_SHA512_224_6(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "a2195db288fcf466dcfdd2dfa28eb5f179523432c44a8d9e"),
		nonce:           decodeHexString(c, "9c646dda740c309373503d49"),
		personalization: decodeHexString(c, "b653612c7c4c76f2a4280ba9b7bcd7a9ca4b457734429e95"),
		expected:        decodeHexString(c, "0c0304e64f89c28a21312d33e41852d66dd0fa0b3182d72a7700218f733f9800919c5c797f0954b06225e98b1141b3195c65ed24b2a6803d8fb61ffe122101844b452ba5393abb4761c958a048a62632648a5fbd814e42b1085fcb90b73671066ea0469b50b8ccb26ab8ef248b6e7f9d"),
	})
}

func (s *drbgSuite) TestHash90_SHA512_224_7(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "09f28af22f2c439fff5c6af171b86d9201c7dce8b2405570"),
		nonce:           decodeHexString(c, "27c07db1c3e3678af7382b3d"),
		personalization: decodeHexString(c, "6df87edc7dfdf3083d217487b89aa47447ca9affbe5e5592"),
		expected:        decodeHexString(c, "002be4fe83c41eb3049a9f1557047862e041bd60cd35b294c7482de1c91461dd533fe4e214f2df61010785d468f73e1f869197a4d88a630ef6d2a5d3c0b50b4b7fec387010f6343676f6a04bc6e508d8433fd3fc4312584c8b7199866cac5ba3e7284f5bb7da65d7cc88e8d3d49b82a7"),
	})
}

func (s *drbgSuite) TestHash90_SHA512_224_8(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "d8a0bc2b9ce7d23d94d6ee904a0dff1473b11316f851cd16"),
		nonce:           decodeHexString(c, "ff15280c224aa6aae3066f65"),
		personalization: decodeHexString(c, "1e3022cab1cbe04de0ab9c8ad2998db3553b8b608c3d3c1a"),
		expected:        decodeHexString(c, "20d424dc6924a19008a710de4665193bf83faebd4f239731a3bab01fd4b990c9770ca8d361cca9af6125fef5f5043717b3647e74a44258365cd729b958b17ea92ff7cb5f4c87c131dc6bdb67dbd85bb7c663738e1ea9b4b94f169488b1f4fc1bbaedcd259909b85ce5c7d5531bc8c65b"),
	})
}

func (s *drbgSuite) TestHash90_SHA512_224_9(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "bdba37524b555c142daa35562079fcbf08166f09a439f69e"),
		nonce:           decodeHexString(c, "3aa829e7919f1c9eb09a63e1"),
		personalization: decodeHexString(c, "f3649eb1152ced76f287fb5415dab4930fd29e84e05b1186"),
		expected:        decodeHexString(c, "3bad1871d40135e270f1378381e09301b3411e5a4a8d3347724e5189c1e92ab74414541ab8e3ac140133534611200332a05020163b77f757a4ffdeff7e3b85a50eeeb42689b3476bf63ec6b904a4c2a60be64e5f934e0de23f86261e2a5b8fd2c4d2657711fdf3c4fb59051a6d8e639a"),
	})
}

func (s *drbgSuite) TestHash90_SHA512_224_10(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "0d889f0d95587ded8068472717b617c8ceb69298db344b6f"),
		nonce:           decodeHexString(c, "fa8bffc02a360841b4d3fc46"),
		personalization: decodeHexString(c, "19d290761d2856e9c1e1dd2b35679d0cc1a0757c1a21408d"),
		expected:        decodeHexString(c, "d655db972f521ccc3055c4887093f7321fc21cd0f035020f4c15be34fbc64ab68a2bde5294f6e5e3f64b6f38e1b49e05d7c0c4972e8c9a6331ce1c6db742d6be2447306f47ffd2ae1df9389a150f0961be5077fc0362995b6fe0ba36693b6a41cc79c25ea0f75bb45a8ef54160e0f47a"),
	})
}

func (s *drbgSuite) TestHash90_SHA512_224_11(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "5405f8b990b109536745533c43bd0126be9dfe88c17d50b2"),
		nonce:           decodeHexString(c, "29f019f96913ff7ea46ccef3"),
		personalization: decodeHexString(c, "991e58db922e1cd06211a35b393fef2ff78f114e70e33cec"),
		expected:        decodeHexString(c, "b8688fbb263c38db01dac9d67051fce737fb6acb6ccadd44e56d40a2d1d20e84b895021ef44c45c04175bc8f11ab3620d685c65b24bafcd1b064929c87b465266b99b6c038c912b4aedb237f2a7eadeeb096fa2399156bc2da6d4375683753f81fe18fc8ac0fc2472a20ed6f243a6a04"),
	})
}

func (s *drbgSuite) TestHash90_SHA512_224_12(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "388955e39a1d0c84effd224f8637ddeb2dc6250fd2aa3237"),
		nonce:           decodeHexString(c, "43df01675b45d6af47f02901"),
		personalization: decodeHexString(c, "536d92cfd3cc5ba79ad4717d04a694bcc4ed6d911ac715c7"),
		expected:        decodeHexString(c, "aee2949fc76d80fc2faf4d8afee1d3be3a131d6c106601e7f43b22a28983320a8ee0880f72efae6c172bdf208d06231a2d17a497207bb922210e850d2d1a03037f5a71c058fb170d91eb96dd9f31ed5970382c7b7929f5a8abe495ae57562683faf889fcfec8074c574224de29e7d5f2"),
	})
}

func (s *drbgSuite) TestHash90_SHA512_224_13(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "dbc97c6aab6ae3674b4f962adc755265dfb525364477b160"),
		nonce:           decodeHexString(c, "e7cfab7d59f5dff3d69d04be"),
		personalization: decodeHexString(c, "102ce2c09246c041187d63a17fc7bf25463903b27b5af110"),
		expected:        decodeHexString(c, "c58d25782af2737c8ff81b9b98d63e1f7ce58afdee6ec032450669dd1ed9f0878fd31471f937a6af7fb81c1a81fce4bd8b4523c369798b1cd8b6477d5bedfbcfbf7fc35cfa2db9ba0e22837aa8f71bca9f5c41613d839175739c1d1384fb615a0364ae5a6ef8bed781944e0dfca6a6e9"),
	})
}

func (s *drbgSuite) TestHash90_SHA512_224_14(c *C) {
	s.testHash90_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "3a32dc87d05cf806884f2ee71e881d8d2bdb4f3f07784ae3"),
		nonce:           decodeHexString(c, "2b884a75ff571f92ba1eb965"),
		personalization: decodeHexString(c, "273f3885354c0a8296b0862e19157fbad69578ec121cecbb"),
		expected:        decodeHexString(c, "b60362ddfbb4fc41f4f5ef353fc0fd8f31e139876a3af0e69f9049aca46a5989ee3a1ebb6cf14f525c3d8a944f4e88e030e020ef6551289c93f5c6ca2f6bc495cdf49ac91bb86e4766ccbace5f7aba008390d2b6dfd416d63ebfe07f5d583b8f9916ebb54620953d0b73c136de06f520"),
	})
}

func (s *drbgSuite) testHash92_SHA512_224(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHash92_SHA512_224_0(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "71fc858e73ed787eadaa38733cb5ffeb072eea80b09c9e7e"),
		nonce:           decodeHexString(c, "f848717a0473168fc4371814"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a52ce6f1b31d66992e2dd6c5e57894f764a088564f6891b24d5ac7c8521b735e6728cb95b7c23f1ed03ebe39644fd3006f2e2da22311b0923f024eed0af5e359a27d6b59044b14f394f19a68d221971c6e9143753a85fcef5f245ce9acc971972f3c67336c5ea6c34a61fefdd9962ea7"),
	})
}

func (s *drbgSuite) TestHash92_SHA512_224_1(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "587028c1e8f76ce745e9689ccc118674be36c7204d41d21f"),
		nonce:           decodeHexString(c, "e925267d28e1dd4e6fe4514d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "296eab44fab0bf62c413e5296fcf1f07d454d7df9e925f42b05c6b648012262fb04eb8920538515ce6bcf2504982c0fcb63db4bcf63ca8eadd58bedf89b59abfe6242ed7cfea2c3fb4d12b4d84be4b5849e71a8269cd03facf61bc27aa2d4cd99bb91265aa54dd03d134bfb9cf832a7c"),
	})
}

func (s *drbgSuite) TestHash92_SHA512_224_2(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "bb03984a46eee7f2a41530b4a96af56aca2e04dbf1dcba4b"),
		nonce:           decodeHexString(c, "ecc5aeb62fb194c02c9677a7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "83000ef8474b2b642bdde0ab1063d229e74931ec2d053041ef1fb84cd3ecbf07a5c4069455592387d7437ca8fdc7549f763c7a18e5caf76ddcc7e17e0c9dcd4530307a5f3d38ca33d331370b4605a9fd1e1295ec0c5d7bb6c1c70aa1a63b6da8a5fbedef0c572ef18056ddf536a391db"),
	})
}

func (s *drbgSuite) TestHash92_SHA512_224_3(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "57dbdea7bb92a12135c8c4001f1efcf7c54cb12d44451dd8"),
		nonce:           decodeHexString(c, "db4eda7e3e6aa1f69c84fe6c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a232d6906f05acba7cdcb03084ffcdf4e56a7bf7e654d42e07ae7710f6dae9d1f92df02f249ad5f8e7313e93fa14fad64d17f0143c5035e5715606131dd1e1f6dce0128af84eb707ac64601a0de966dd0a64b370206dd00cba6aab2f7e3cad5bc6522030bece4596706fa142e95e1afb"),
	})
}

func (s *drbgSuite) TestHash92_SHA512_224_4(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "906af4f88938fc8fbda3319724ec2cc413b5ac17290f3401"),
		nonce:           decodeHexString(c, "b2aeca9df80294d337480dd6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a2ee18e606e12f92accf27ff587a8655bd2ff6afd2b9d0e53693deaa7086911ae6c5895cc794953323bdc70e383b33571bcfb67d9aca27f2cf63b2243e31f7c5cbe848b22b5f90eaf1f5a5d92eff4304f42d5b3d4799dc24e47b0030adcb468a497f8b688989160d4f5005d9809a5aaf"),
	})
}

func (s *drbgSuite) TestHash92_SHA512_224_5(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "dd1e5493cf766a4b496452f2116cba41ccc8f57f6cb95a14"),
		nonce:           decodeHexString(c, "bff415595d30532918ad8ba8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7babe6d85ac651a036074cc31a14b9b37409544a6ced441b4c473e97c5c91443ad68910762f5faf3ca9fa3a258d7e24a779eec41397d34c106baf31cc709a5b043f0ea90962b388d5746806669c6e93b999a96d23a9c87a8eddab6eee46cd546b868fbf8cb101ebfe7d5fe36b557b4af"),
	})
}

func (s *drbgSuite) TestHash92_SHA512_224_6(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "758e40e00995ad2876689112071d646986533b2ab411b3a3"),
		nonce:           decodeHexString(c, "525ec489a9567c31cd4ce1c6"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9fa00f4eb8b1cce59bb7949429ad926eeea463014ca69fd7ba1ab2dbe181fb535bfa3a891844dc4075c3638f8503a18144a6697e6b097027e1e06fbf0a652c55fca4abad84f5184da6a5377d37d29d7f8c938fa2fc9d0ae187d46e2b1b2ca64ccc568a6c551cabb490977932427fdc90"),
	})
}

func (s *drbgSuite) TestHash92_SHA512_224_7(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "39926ef11aa90d6b9f65c298313f27ce31bf845d721bbda4"),
		nonce:           decodeHexString(c, "5d6d2d9c6393365b811065ad"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "188a62988ead6121186fe2f44203de6ee5de2f52335bc003587cfdc676b8e86acf84a3538de7c81471e20efcd1cc0e14169b71d5288e4664718ab6c2d04037447e7178a3ce6f28ecf8bcb411e3d3ff6be89ab28291838325872435aad78f3856e25bbf33854fdc7a973c08106d6fbe00"),
	})
}

func (s *drbgSuite) TestHash92_SHA512_224_8(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "dbc63ed9d56330ac6bd00ed75929ac14c4a59d8a0aee93cb"),
		nonce:           decodeHexString(c, "eaf3f72ddc566e85377d5f98"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9bf07006aab508c74ddf9dbd56f98f961568a84d7704f08caa32f1ef7c40647166bf77b25f036a0e59d7d5898b461fdff9b343094b8fa5ea697632fb71906cfb36fccce0e62b1afa59832375a09bac40ae79d762b4bc6a912599d93a6d1cbe4a577bc8d0f734dc21b992c7dee5c8516c"),
	})
}

func (s *drbgSuite) TestHash92_SHA512_224_9(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "64127714968ddc1027b41e5d6dab51459aa682134b228c5c"),
		nonce:           decodeHexString(c, "bd4dd19ddfbfb63269b657bd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "b90349b768786c8563211362410aaabeb969c0780955b50d7eeab669eaa7c86871ae777121c1fa6ba3dcb9474fafe41ad1e573b86310fc86e09abcaa6ecc89d8b0bef1c57981f4b673fef68473e9a2fa14c3e5cb42d0d37407bc99a661197469648e6706005d347d5e5dd905a6d698ab"),
	})
}

func (s *drbgSuite) TestHash92_SHA512_224_10(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "c2f31a71e59f642244b2739e4cedc85a94f4027b743d7e98"),
		nonce:           decodeHexString(c, "b73f789e070f663b13f304dd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dca57d85851119dabf202831440511b3d162760ce0c6f0613ef16ed5c92babcc989b42e7b4ea5f9c374e81f5803e2febeea8b19df3de2041a80f1887c335f93a6710334ed47bea388629447e12c9d58fb1274fbe9476a1448f2bd92f2b7cf11dc8c55949774adeed4796cf40239d6e1b"),
	})
}

func (s *drbgSuite) TestHash92_SHA512_224_11(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "84896a00a3e8174deeab5dd358266d58c59586490b6267ca"),
		nonce:           decodeHexString(c, "ee0bf931d1e7572f1f25338a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5feb955aa6720e98353eb0e59786857c8bf5a04e63610d975e74aa4304c5dabc9c0d2d2aa93e44b23751c1814d164cfe6e816aa3f6212e42c5316edd2fe85f60640656e5233a54dfb287efea2d78666c9ba7cbbe45147ccce53813dc0ff449292e7f83e069b827a241c07e8bed4289d4"),
	})
}

func (s *drbgSuite) TestHash92_SHA512_224_12(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "409025abc3da1f7b1583e66a0d5bd971b2ff583cfbd036c2"),
		nonce:           decodeHexString(c, "d00af7fc331768ffd71fb90e"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "757f23e57616b0bf3fd7be2d2f339c056052b43ef537fc925cff33d7112f1e2e6c244f2a7dc441f9b22249c39ad21b9ad41d3b8789b5a0f1d307a0178ca89afc2dabd08e6809246d48bd251fbf830b67036d94c0bcb395ec03a9f454e2d34e4445b2286e69876b2b2cc822030ecfb52b"),
	})
}

func (s *drbgSuite) TestHash92_SHA512_224_13(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "f8ffee199676bdf335d2effa3a407dbd79ac61c42c7cf3fc"),
		nonce:           decodeHexString(c, "a75aee976130194789ba4478"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ea9a1cdfe63628be6fed5de00024130c5c4a5047081f8805e23a5ab3cd7f18d2f874a1da2dcb6dfcac7e7c170ec6884a80f50bc9aa792774c7f076868ea0809fb9e843de4ef5a7654777c4ab4b99e234a0bd4b76cba943a4dd70a8d045b9f6913f9ac57eaa105f29e5b8395c60292b29"),
	})
}

func (s *drbgSuite) TestHash92_SHA512_224_14(c *C) {
	s.testHash92_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "e03af342db03da30e2b0e5b8ed76c2562194417fbf6be645"),
		nonce:           decodeHexString(c, "6a9a5188dabd510894073f76"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7963276f1054db251369a0b91d854fabaa3dd5b2343ef4306cf897bf964fc8b885908c4ada163b929a19c948ac89c8480170eb59b9a8d7d2d30ddfd1248e2c1795c69da81fe72d6361d34754f88eeffca2c31859bc8940d6662abe2622fdfcc28a1764355aaf46a2e00e50606af2b6be"),
	})
}

func (s *drbgSuite) testHash94_SHA512_224(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_224, data)
}

func (s *drbgSuite) TestHash94_SHA512_224_0(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "82f80722b82936a3a90f7371f92ed1d8a17521598653b38d"),
		nonce:           decodeHexString(c, "b67742c5943422e7b6e74dd5"),
		personalization: decodeHexString(c, "207e1f982da78ae5f0612517efac3a13f024aef04f20509e"),
		expected:        decodeHexString(c, "91de62aab4ba484d0b419e7211a44d2665f4800a166d8621a33452506c3753aae6142b27cef8247a7170ad9a3b777e175b852e3b493fe100c5cec89c819d6dd59b42d7deb411b5d4a9b9538a1dd051e195098ef4b0a23b55351276e2adc88395140514c6a9266ff32de25b911d7e18cc"),
	})
}

func (s *drbgSuite) TestHash94_SHA512_224_1(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "4d6d79e80207e6f7bc2f34be3b701b84b0ef3c778629a46f"),
		nonce:           decodeHexString(c, "9e0e534a3f9a2afe7bf48896"),
		personalization: decodeHexString(c, "55abdb0275ba50f84b63a96bff7938e999a4f2087c2c0768"),
		expected:        decodeHexString(c, "a404ed0511d6046f84cf8c6e97cfd335ab4d28d0a1880da9a15b523ce5ed3edff6f2371134f55ac29c4f1c730ea0bc6566edcd3c5a848fc85f7b8bef501f055f254af6bd1361b7d0ee0397d60db1135956750669f891d993760bc38715932f36207c9caff81601aecbf68c1da3104adc"),
	})
}

func (s *drbgSuite) TestHash94_SHA512_224_2(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "2e71accf7079a2544a44abc2b92441b73da66aac771be4ad"),
		nonce:           decodeHexString(c, "12f5d93b63e468e3b3307cea"),
		personalization: decodeHexString(c, "76d40812c4a48bc75fb234d6eaaa5ab2ba8fff7f04f78ff7"),
		expected:        decodeHexString(c, "0e28a5c44e4e7c979f34af183cbe6bdf95376064db25198f0990d45a4ff50ddefb0f248257bbb3199e9f046081b9f55abf68f3c7703e4de4ec0750c2a7fc934b0ad13ad7412936bb907a33f65cf0b25e06cd6b23486feff09afd1cbea3115d210ef6fcd01e8ac2924c8a658fb40d50b3"),
	})
}

func (s *drbgSuite) TestHash94_SHA512_224_3(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "8c199b3019a1dedeb9bf42d55fa6349b378878f33f8c9074"),
		nonce:           decodeHexString(c, "5251ee36a7b5f8d676a19eb3"),
		personalization: decodeHexString(c, "cdea66ba0ce12cd4f98c2127c048ae8701aa7641e09f4cf5"),
		expected:        decodeHexString(c, "2ecc11dd488d9e1f7eb4c50f501abb9702abba33e2727dec27f3baa2117bf793da57cb3304102549d5f405fd72af1a9bb557d34cea00dfec681dd4ee4673807af4774616894762ff8e9634246b5dd6147398b7640e86e00993245d9575368c841c94b83a9d8aa8ad87bd7ff20f1a01d5"),
	})
}

func (s *drbgSuite) TestHash94_SHA512_224_4(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "03a6b9b143701e2b668accb182d2326319173b4a911856da"),
		nonce:           decodeHexString(c, "b2c5cc00d378472f661e9aeb"),
		personalization: decodeHexString(c, "d00bcda132b614d8025214bef489fcfeec9a532f16a9873c"),
		expected:        decodeHexString(c, "b65c54cc7aceb322190c7228075e3811321168a8063fb0081dfb0c7bb52b4d83f81906f18f90b946de23af0871b9afbfa4cb749d5c7b2818d4a753a57cd270145671071704f6d3aced07864a3a443c11b232390bd8959476243526de19408fd3e96a598d1ed40230f8c8a3aafa48a0ab"),
	})
}

func (s *drbgSuite) TestHash94_SHA512_224_5(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "8785e1954572dd3ba178144856f7c3a8f6c2d9ec4c903941"),
		nonce:           decodeHexString(c, "06c4e1c7eebe745b0c045e95"),
		personalization: decodeHexString(c, "7d500869fe79ee995b47701d0027a8439907b7a67c31259c"),
		expected:        decodeHexString(c, "943431f66d874d8cbb1eb93b14fb10506e16f7eaf7cc5c09b60011fe4491796a16ccbcae76a4a31e16c13ea661036246017dd52fe32afc5ab0b688bedea23c02c30d02bdd1d086cd4a5c843b54908f5eeb7a11f1a29c6d31dfa4d004a66ccc8520c3f016077c4904836df207b924cca7"),
	})
}

func (s *drbgSuite) TestHash94_SHA512_224_6(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "3d744caadf5e12dac7ee05b2716485ce3d6ffe74be1e61d1"),
		nonce:           decodeHexString(c, "d68ac7fbd4608bdd8d60808f"),
		personalization: decodeHexString(c, "6153c6eec875c7336c05ae17caa9aee71e74de74ce6d8760"),
		expected:        decodeHexString(c, "ddc959d5cc7b9bf9cc50de20d450b2b91fee5ac90c416218933a90d453bf448e391d0df88021032db82ac82a79ae218aef0d622a370ab69140b79896b27de188aa6563dd7e8ed9dc7ace1b15860e3ae944bcc249a4ba9353a2512a55abad2cea26cb6c3811d835960764d143eb21cacc"),
	})
}

func (s *drbgSuite) TestHash94_SHA512_224_7(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "7b2dc2121cc9f905afae63d19c012b37589aa5a1959ac85f"),
		nonce:           decodeHexString(c, "bcdfff8bc3171a2c708437f9"),
		personalization: decodeHexString(c, "22bb071709a9dd5a91ad11c8aab5c8d33ec6ad362486330f"),
		expected:        decodeHexString(c, "f4a63180ba722f70204c9f65058863a56761fc76c9078fc28f5a5bb945d878c61dfac1af2598ec333113aa4301fe652b13a80f7e39c1cad0f9ea3a555888f0b942517cfc576e2c1d08b64a0f18258a1692d3f24376147847700c15d3690daa4b1fb76290be325ccc1445a0ce1bab5050"),
	})
}

func (s *drbgSuite) TestHash94_SHA512_224_8(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "87301c8c4755737f7d4b53402f0aa6dde672f73335e388e6"),
		nonce:           decodeHexString(c, "8fac88676f79916cb94e7edc"),
		personalization: decodeHexString(c, "4822054e5b777ef1c84c22e9a64a902b50c3c792dbc54fbb"),
		expected:        decodeHexString(c, "15fdba37887729e1b41fc9476abb8091ce43d3bb695d50a949a889394d1a8afa81d28b18e748d630d5b685b655a06abd82c23e2e8e82b3de3e7dfdd0b065536917d649fa9b69805be4c4c53c6855ba98a9f4194e7fdc63cf1dcd08b2991dd9d417dfb5e245cc7b1fa4a432a3311e73a0"),
	})
}

func (s *drbgSuite) TestHash94_SHA512_224_9(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "c3066b5b1740731e553444ebd46109e1eab2f88f4e6ae6bd"),
		nonce:           decodeHexString(c, "01e9f3ef450b23f624304b41"),
		personalization: decodeHexString(c, "f395a173b9fe3598d7fe48606682a2147a7fc59c5cb84572"),
		expected:        decodeHexString(c, "9a7aa949fceb393736655a43c27a138d0ea49eb6be7ff4076444bf9d3d36d8cad49506a90c347270cc00cd915087e55a683c3f1e0841561ef3cf923855eed9d61622cf08f906e026eddede5d025b6e7862539136f1e9823cb0bf20d43c023a70130c0d73fd352e9e7e24f7b224038105"),
	})
}

func (s *drbgSuite) TestHash94_SHA512_224_10(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "e3aba0ed7bf3629d7ca5d39113c152841c19fe057704de63"),
		nonce:           decodeHexString(c, "9f60ce4f30f99d30459f5811"),
		personalization: decodeHexString(c, "8f1bb66a0f1c5138baed9c37158c0e04a6ecf7e5344c3c49"),
		expected:        decodeHexString(c, "e1cbba70b4dc058de330f33a7b9ee76656c72b4b102cd2a38b428216e708c7d8a403e9045407de2de7f1db07aad1000e69f6969d21b71b83f7502ed4e638563bb212db5be6daf94e645430dadf0b08d72ea726f6a1bb3eced96c75cb1c9202ade822e386c1f6024a2b5ad02f132971f4"),
	})
}

func (s *drbgSuite) TestHash94_SHA512_224_11(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "3e84bc6241f9af681846ec2937fd34c6353833048f548628"),
		nonce:           decodeHexString(c, "bd2e9b42fe60087ba3b00fc2"),
		personalization: decodeHexString(c, "76a6f3cf8da4ec437d4c2ac4433c0c5ea9e777702238642e"),
		expected:        decodeHexString(c, "bdb5d00d8ae3f94d931886023393aab4ef42967be2c67bd59c9b549f215e086809a6fefa6692f3ca56375acf5798ec7a400938ed34da2cbff1b3284446b42536844242061b4551e005b3e83e63b61494f87148699f149608745bf0a9df5296675e0026a1255365ba8f33adff8894a332"),
	})
}

func (s *drbgSuite) TestHash94_SHA512_224_12(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "1cbab75221a9c1cd75af7e6949b43eb3ceb07dc2895379fc"),
		nonce:           decodeHexString(c, "33764191bfe1e1085c3eb069"),
		personalization: decodeHexString(c, "8642a444814f7086d3271a1728ea6a4e6ad54a062fdcad2c"),
		expected:        decodeHexString(c, "7818e2068120a003279975ea5132d2e6b2477bcfe528052203d8f114537959eb45e6f64a71cd9bcc53e99213f1c6ed16d1fc874419cdb46ab32ddaf7219855fc54e8583f1502fcee1b6362ce40a46802e14745982c068b39b881d3aab21629e9fad97241dac2c1a13f07ed9dd3d1dddf"),
	})
}

func (s *drbgSuite) TestHash94_SHA512_224_13(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "cc38ffbe80111dbda46003b743864f93ef26b297d95b20b4"),
		nonce:           decodeHexString(c, "5b25836b5ba143123661c6ff"),
		personalization: decodeHexString(c, "f1126463017cfde28aca230aacf02544f3e5b6815765e6f8"),
		expected:        decodeHexString(c, "c036c23671f7f3ebfe9e4c34afce5b892a668572223f86815867f423a9c2cc704b1428036e45913e029d621f9a5f8478dff2a57a87cba21c19fe969898c2cb97e267bb6fbca6cf86da2dd437ae46a54f1d0b094f476715b425b35bbe988b1b28e54e6ffea2d74b85fe3bf1c208ce34fe"),
	})
}

func (s *drbgSuite) TestHash94_SHA512_224_14(c *C) {
	s.testHash94_SHA512_224(c, &testData{
		entropyInput:    decodeHexString(c, "19970d8a70d136a19088c975ab0262e51d2cdc41792d402f"),
		nonce:           decodeHexString(c, "9dcc6c4317ff492d0d7dec5b"),
		personalization: decodeHexString(c, "7d30c5a4aa169c6dce156a8eaf000f9be0f8681e3282dbae"),
		expected:        decodeHexString(c, "550a9ad9e45ba359d463c1e084777bfb2ee25ff791070a87f01adc04cd1a7e9e6ef334e477fb5cadd82381e0add8a39ffc222150f17b8bb0d3b1cd80948c0a5ee09a84ccfff6c9ac33e6831d1a84182edac6bcc25fe357a708f78db9a88daf553914cdf0bc7a9b0527597f73707fec8e"),
	})
}

func (s *drbgSuite) testHash96_SHA512_256(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHash96_SHA512_256_0(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "44ce0a55dd28a430bc87627f2a06a391269c4294f10d65cc674b47a12cc9d6f6"),
		nonce:           decodeHexString(c, "c289eaa7eb8c0ec54d1a1d380f16def5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "c294640085507dee07b3a9e14c89a9d246370314b88ad7f22f5143132f953bbef8aeeef29dac7907c5f6da5f79f5e0cf89e9d63adc9f4eea7bef098d68389e681e9ff31dff03b26d6183bbcabad590cbdece476dc0cab3e6fcf85ac7c12149640e272cf85571aa2c638165df5553519116393a3c0ee3aed718d42380201d2c35"),
	})
}

func (s *drbgSuite) TestHash96_SHA512_256_1(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "81db6e036142ee644359d026d3722abd944ef4f801091b7dac913b193df72743"),
		nonce:           decodeHexString(c, "194b73a2374a8f06ca8defafa55da78b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "698fe521f8d37410bcc2f084d5a4fd704440d0c9ce1dad1f06f2e8fd79107457a2f604f1f0b35c4579fd2da01cec3327b6f5c99ed3a64f9f972218cbbf0070e73d7f12eb67bf18b43a3291f3979f36188a201f7638e3bed7749abaca34b65a23a5ff4525097172ca397d718b0ca13aaad7c97295a466da743dafa035ca1481fb"),
	})
}

func (s *drbgSuite) TestHash96_SHA512_256_2(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "c819743d44b0c5154d1d448d3e7e0e02efa80dccea6f9843b15a668888da3d44"),
		nonce:           decodeHexString(c, "50e36ddc82ac6a685e8810ed0beab583"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "02be729982a0d8f619267b2d574c1b45e648d46fffca0068664f835e272c89a53b470f6dc2cce5b743b447a5a7be0d4c5a3246d648dd729dc181043025aa5b5f8c6f603e3d921460e1f1ae90b618c9522a63fba1b28c2766a504908faf091b2731a6ab04d2770a1dacb2de12f48449b7b9a720939efd83cfa07e2ed98e9dc919"),
	})
}

func (s *drbgSuite) TestHash96_SHA512_256_3(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "85128e5cbacc89aaeb6351bd06044ea4672791007514d2c9e8a65d1174e2f483"),
		nonce:           decodeHexString(c, "a32f0d51f9ac809154bd794d913e3998"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1825f282561b15bae06e5b874fe809d7dab530dda79c024608453da8351a21315c2f32a226a4f3e50a6a7803eb6c7d1c0ef034af809965d9da39942b1688c45f5ec88ce2c80343710ae52906c0d864781e493ab70ef8bda30f513a912e98efa64e40cb6c8936bffe196f02bab50987d6777eb8812e930228777978735feee0ed"),
	})
}

func (s *drbgSuite) TestHash96_SHA512_256_4(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "69a947c4df683cae4f7d0880ddd1b1ecf162ade97360711e75615fdbbe54a54e"),
		nonce:           decodeHexString(c, "a8a4136f9828abe10e9014555b092079"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0fc08cc068b5d4a3f90bf6cd7f6f5c9d5bd8101b46bd618b80ff62d524d00bde3bb115bf3f8b819ff0d898579d8eb2d3f94b0ad1ab39a5ec784ea47a480ddb1a34d7bc472194b28a6df40d3098e7b3a47218d487d50b3c648b71fd4d3ef6f09c1cdd6c60d3de6e34583e8c664ad3c84128b16124b962fc519fb5a0a3fe071a81"),
	})
}

func (s *drbgSuite) TestHash96_SHA512_256_5(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "b03e1c29ccc69746a5b4ce0d0900c98f471711b9bfe00a3f6496fd290f619e63"),
		nonce:           decodeHexString(c, "c1ebca6465ee352d159e489593de1b1b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1f0c7c8b4c182f1ce3a686b719439ccfee663f6f90bce5983b35d0680ad4d87ea865bba548f2e37f7670a8d2860f988372d3781386977819b9adf97c020655dece66bb88c027cd619b24e680f254571a2801544fa2d8b1207a8d431eff5fb32672c4df8fc143c6d4ba2614a3d601fa05730aa49b513389f01dcfd17b2541f597"),
	})
}

func (s *drbgSuite) TestHash96_SHA512_256_6(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d89e696eda1436eab85b43264b484ed00614890ffa6db1890ee93e39c8b6c192"),
		nonce:           decodeHexString(c, "38a098244fbbcb2c1fde4b84a6c623ac"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e7aca2411dc9d15fe008864e1a8fad4a1c5d4d70ae324e102a35ffe798767948650fc34f23a42c1d2a779c7f6b44deb06144bab6ab1ef8664dabac9e86103233ad97164784ed23b878a223652da3ccb7d60396f1df945b6152233708c7ed22e8cc272709f33b4e21404b13dd33066f5557ced5415f3c860c55d1cf6ed32fe047"),
	})
}

func (s *drbgSuite) TestHash96_SHA512_256_7(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e57a58fca96ad41884d89ef1433232bcb75f137747819959684081d754fe52dc"),
		nonce:           decodeHexString(c, "fc3de0c440a955bd19d1d0e3feb1582a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "7955e398bbe54f70bf430eedac37d5e8767a19088d5b41d4180e64f41b15dfcdc74d77b573030ad3ab29824b8bac5172d575e2fd035e7a8640a51536f26a3d8b0dcfbc92fd47e2f90cf9a125c9e11a002debec0bb08e27790dd2977f11c67355b435d70bcd84ee0cb672850b65cdf75ead392c49740942b865a16ab501d36c0a"),
	})
}

func (s *drbgSuite) TestHash96_SHA512_256_8(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d5f809f10e0fd0ad3ff770006734320d4894d790bd21b1b7536fdac5efb5ce58"),
		nonce:           decodeHexString(c, "03fe039e7e942a7728a11367a73f7a32"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "596420d1cf1296081f985bbc8d39bf7693890fb0995043ba548054e4a161c0cbf807f8ad7187cbb424302f4e41a33b9ddec8a8dc07bccc511519116e29958fbd2c842c528536bfd6cadf6e77f97112fb30b370d1312eef66a127d1de5ed85db0f56f8bcd9bdc7c1d0fdcfd578b4e17f34b63188cd74808847ef7c72b9289ce85"),
	})
}

func (s *drbgSuite) TestHash96_SHA512_256_9(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "a6c7c911cdb55e30a4378a9bc822a2addef16f8bf95cc8ecc23461fb22da0d83"),
		nonce:           decodeHexString(c, "3b3885f628e8ccdc6653b2100a626001"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dd26f2bd84bdd8545893359c9f97ab81f98a0b70d56a8c0f0f54f16cf7e9f5a3eaa18f326637ccd44111008d9c8fa028f2e9a2b65dd0f06fa07bf4f90231657158f901003b42e07db224bc2db5dfcbc64ea6c394e76bdb82e1f4747b2d8bd1908169c2938c9a4bae8de37110daaae12ea3b974f7c5637f68c9007442af04d791"),
	})
}

func (s *drbgSuite) TestHash96_SHA512_256_10(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "2d4602c7055b2fd556d342570611c679a3b0511f05a6fb548dec3a68abf39e8b"),
		nonce:           decodeHexString(c, "2abd4e48ae6216fb0d7c57149ad65c36"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ab8e4f28b147addd5a0a8b89f385b26d35c38e1e8d7956561c974197bebec46e9e1ff63ed57cda3037edc88a3ad1b891c4276f6c5ffb052def2cad96a274d68c9d63db2d9f3fdb367b0e79aa7bd631478b4d1c15d4d3a6aca9a4957fc15ff5cd7770955e6d58afe1cad201ab87248178d88b8d15d410790ec89600d551159f19"),
	})
}

func (s *drbgSuite) TestHash96_SHA512_256_11(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "5660c5540607a5e4e4f425b6ccb5e21a0d5ce831287250c0ec09530e6015a9ea"),
		nonce:           decodeHexString(c, "c7acad8bdd4aaf7c32920228e7f1292a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "00904c4dd19ae62eaf31ed2b15b90f158e5d6e5368e6e8b55580c95d9b6ce91b902d7bedcaa39d6741b7e0e01db3f2f713118a4534284bfc1d6f72e3e22443fbbdbffe869c3700352071f4926a58957f5bfcd0970585feedda6dfd0297a17375b43d5c27b5a3b2c9049ee9e825bb14e653235f710e01eed8decb792488646e2e"),
	})
}

func (s *drbgSuite) TestHash96_SHA512_256_12(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "a59be6b1032007ea49513ccf13989d3494bdf927b1d3f8be0b66611e7e65c08d"),
		nonce:           decodeHexString(c, "0f6777475ec852294ba42fb74dc97760"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "fe0e0248a9e9097689f39b043918db834011e15949ff5960898bbee0822a22556e84cb2098161e7ff5e8a4957a404bf704ac59fecb2d99acd0727400696fc1977f28bb702392614e79cb0820682215741058d6b2a7c96cf3d35b357c7361ed5e614193b781d81ad1e0c081947a13d30adf4710750c2535d82047d609701a81fd"),
	})
}

func (s *drbgSuite) TestHash96_SHA512_256_13(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "476c950159ac9772eb7c477a3a5266c0e3b55c8f94a293268b53c3d4cb2d5490"),
		nonce:           decodeHexString(c, "369f60012a316ee36a0febfc0c8c508f"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bc433937b71f65d261167977afaf152ed57cd834c1367797e14c22277b4317d2478ee3ab2755d4ffe3a63f9325a21a5be13fde2d9a8521b5e8f3477d62160a42145dc368fd5e24f24b2e33aeccf4debeedae10c77606130b0c575c41147246ccf851d489e030c8f6795e25462450711c59839a4708984a0d7443149ff0a492bd"),
	})
}

func (s *drbgSuite) TestHash96_SHA512_256_14(c *C) {
	s.testHash96_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "9021c403eada5eac222dc48e1437b6de48ca31b9e7e76fc5f60653a3d901308a"),
		nonce:           decodeHexString(c, "503b4bbc0ca538983285857a573f6166"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bca7456257568a178877bca602d331161828a4ed0758d1ec3febcc21717cc4142e5481dc9756c56099cb043130345689156cb96e1664ad007c461ef8b5b0fa7d18508541f528a43fe8c719f3a269ff2821ca655980579dfc2c794da673b8c9234d561b833855efc91b4747ea5135a1a05017543f5780f2cde8b472787173ec50"),
	})
}

func (s *drbgSuite) testHash98_SHA512_256(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHash98_SHA512_256_0(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e724ab61bd5e236354310c8e3b1c1cef587eacc99ea3411cd61e1e033c834e5d"),
		nonce:           decodeHexString(c, "2951ffc5d08e47040572ff1ba43493c0"),
		personalization: decodeHexString(c, "59bfffefbc2c23df1f33f6b6dd852039daa82ef64d219ba4ff2ab243652eb9a2"),
		expected:        decodeHexString(c, "d640ceacaf7a7fea51dcb22704cc6d93d042e4fc667189e891ce5a221b7911041240498c11a51ccfae98dbce4e7b0ee1b63db44b04f8349631dd935dd18b205a7197e4de79086902a2a85594213a95cf37cff5068b51f23bb6e99c2853ce57869d1032071459471d8a2103a620a76826749bed5428eb197176202e9bcfbb3ca2"),
	})
}

func (s *drbgSuite) TestHash98_SHA512_256_1(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "08fb48fbca8c66b084be402d80196ddb171f70be1a0ef209139af642e98751ed"),
		nonce:           decodeHexString(c, "8b2e95f175103ebcb419531deedc47b0"),
		personalization: decodeHexString(c, "ebeb41167e04ece3f0ba908671174ae50a4c6e2f38ca97c8b45a89726c48776a"),
		expected:        decodeHexString(c, "35a47ade8f180524a3a2da52a1b41e196fd5fe2d7e8f4456383a459c8682b501fcea1a21b730c70f7f5979a1d15c22446131fbd41e661446ddc02090b90c37816345384eab418c7a9266b16a76df8eccd665211ec7a06cd276c1164442f23518f51196ab76486d2891d6fdde918ae66b84224d42c07936b4a00b92453f3ce633"),
	})
}

func (s *drbgSuite) TestHash98_SHA512_256_2(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e1a456bf6ac6f942a82dde80ee33814d30cb920d3bc94126e583cd870caf15cf"),
		nonce:           decodeHexString(c, "76ebdb506909457b308be76e5a62a54f"),
		personalization: decodeHexString(c, "3ceee1ebc781a9cab0e04300c972ef69dc548ade6fd731ffd8c343d93d08d185"),
		expected:        decodeHexString(c, "57e56d0d7bd6f7197c7504f7a390603ead14ec6f13a4a744bdb9b296f08380dce9e0772f43de2009040da2506ec44b9dcd455c352515d17234333aca348c488242079b63dbaca2a6863f6b821c5840eebfd682c98619eeab05dad517584e0864d6be51df43da43f4ec1c95cf8164f8ee97f2c3776e99f2a3a21e6070f9b4ec60"),
	})
}

func (s *drbgSuite) TestHash98_SHA512_256_3(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e25523d7266a5dd737b1e4ca76aaabffef4fc6fea945984e1c627b7eebc999fe"),
		nonce:           decodeHexString(c, "371c38983c6e99eddf211cf5d46e8355"),
		personalization: decodeHexString(c, "03ad49a7cf8a2df45f762af8d826d436a7f27c1840d53026a5ae3dfa00cd1346"),
		expected:        decodeHexString(c, "32d68a82bfca15f8f1ec6f237601fb3bdd2d0078269c863898c6494b7ded5cc3eb110e0c25836721cc22a105817029df725bb65482e8776c2619e9bb97a2dcf7ac6e30c3fcfe15afdc7ffb9eca24fa41ec8d076065521bbff417c670aceae43267785caec7e978d1d0705d32e5375da93c41b7cb68af3592ed6957f225da8cb1"),
	})
}

func (s *drbgSuite) TestHash98_SHA512_256_4(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "a81b323ec47b3112d08d51d3abcfd967b36380f0f9d233d9675309b8455c792e"),
		nonce:           decodeHexString(c, "8ef18e08c3f6f957f026296c61dd8077"),
		personalization: decodeHexString(c, "91c526dea9e0f80e46cc2a07f793fcf36397bf528e63a7fe4891becad029bb31"),
		expected:        decodeHexString(c, "ca8f58eb28693eafc2f1d2c111f87e864d2a59f7966420d5df510639b0af39cbb577969de697c0bd14c36dc946c60ca257cd365bacc740e09746c1c73264bec0370d4f9b9fdc7b8db7f38514c020993386153115c19f0bfe211151fb482934f3f226ddfee8a392a3feb7e8f3c8fd707fdd8b260dc34e0f6165f5f4c6d0ecb1aa"),
	})
}

func (s *drbgSuite) TestHash98_SHA512_256_5(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "f26f12b72b13316624c0981d40c8c9b21cd570c5bd7dcc2ed0d8d63e1bbd7dee"),
		nonce:           decodeHexString(c, "dddcaf5eca7cdc074325a6090f59259d"),
		personalization: decodeHexString(c, "464a49c5b2a999a791ca83107ac10ddd294c5ec8efdbf645072e4258f0ef2025"),
		expected:        decodeHexString(c, "71ef604646c91a59471f87d7f7e968f06b079008e7713189d75a0e5dfeca5c95a8b2612525ecae1233073fdca57f68a58ead71cc0c9830cae1eb4e6f136e850657b507e00d3abd1caba6c7b36d2dfd562872dfe1695e3283bf3759421d0f00c50c43712c33ad6e65089572b33402c8a75374009d934af66b6dc93390a037e3db"),
	})
}

func (s *drbgSuite) TestHash98_SHA512_256_6(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "8bfa430c3d068c53d4585dc8ec918ab63233e0f77a6b8515fcb34f6b0f4b6367"),
		nonce:           decodeHexString(c, "f00c91f2b479bc03426ba64975e1a3c7"),
		personalization: decodeHexString(c, "3377a98ebccd45729efe0c12ce23ddf7f6ecb91241b5b355fbc005ab1e2e9c9d"),
		expected:        decodeHexString(c, "cfac175dfe794093c1abc24e74718c5cfb08b6ffb542aacf4dc966aaed2d52cae48f85022977339edcbfccde88f6eb03c3f4dc789fb0401ac63257783740168b789159b2ab4bb56fa00d0365edc3208e70e6b0cdd535a403c12b54919095500c0267d9cc69ed1c354f34d5f8bbd4e1282f7f07b6b233dd3d11b04920f503d597"),
	})
}

func (s *drbgSuite) TestHash98_SHA512_256_7(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e0b146dccdb2e37ff596a5091185833eb7fba5ef5524bde1ee0bc9158ef651dc"),
		nonce:           decodeHexString(c, "c07559a3718465d5c0f4a99eefb62324"),
		personalization: decodeHexString(c, "649f74cdb5f0301a7914d6535d3df548930c7e1427c75978508fed0471d39d45"),
		expected:        decodeHexString(c, "9e8bc8ad94a1c5b4d2b46c5f2c2055cbc896d34bcbae9fc05c9f5e03ae2749110b50b4539a91cbf57ac62ed0cf3f50e76623a869b519f5a3e4293d4950d6c2d77dc7a546413c8725d2e666e54c381d6d5f45a43672c480110c503a7bc388bcbaa0aa431db2e54159fa7790f71bed2a78cd9cd3795a37bc7eefde6b442f39ebc1"),
	})
}

func (s *drbgSuite) TestHash98_SHA512_256_8(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "845fd8931c77e4bf47596f06e89c215254a399f1495c49945fad2c5cb36d330e"),
		nonce:           decodeHexString(c, "bfd5379edf92ded08630f328af6d8dd2"),
		personalization: decodeHexString(c, "d560adb65f7b844d95ffa0616add4354d3c6acb5853efdffea71f8f0fb883293"),
		expected:        decodeHexString(c, "c57fb3411dcb917b6ee4a1f77b38de618bc454f650952d59c9acfcab49933d2b034414c8ea8da47d77bb3d8594ac60595f63b9fb3e43c21257fc3cae7b47cd1b37171abc54602312dd1513bb43dadc84a6b37bf0c916e8ef51da7cf6d051b0c1290dcfc7c9791828b6d588e470729f4da568f30e739b327e64b1ea4cc6fae034"),
	})
}

func (s *drbgSuite) TestHash98_SHA512_256_9(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "cbd7f084473c6168d48683b7944d4556ec2fa28742170586e75511af9180827f"),
		nonce:           decodeHexString(c, "74f44a86c386d27d9af962232348db03"),
		personalization: decodeHexString(c, "d513dca6b39458c8b1b9f2d2f74098f2efb1417fa7f73073f9a34fe13cb1fe9f"),
		expected:        decodeHexString(c, "d1cf18a8232761dd30370c31253e5daf1be13ca524591948e0059c4e13e4ddc292df631d5dc8249accf981a4b1fa62dabc456ff6e3f4a972d587f6751155564664004ad8d957fd5231302b79e3243f72a3e01a611696d347ce3ad9a5e18312b71334294ebf1305c5d67266583e3fc9b06992a9077470cdfb74807e44351b8970"),
	})
}

func (s *drbgSuite) TestHash98_SHA512_256_10(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "aeb1ce335e02ac888506cdb89f484dceaf8e9a57b521d3dc47f03a82372a383e"),
		nonce:           decodeHexString(c, "70f20f150c35224dba780ea65657500e"),
		personalization: decodeHexString(c, "e53a56519c5bccdb4326510b314faf0954f5bee1aed96a3126f3b38a2a79e69b"),
		expected:        decodeHexString(c, "4ddf00587d70d1e9e35f252503e5e4a4b60ca6fd3de4fa4fc6f1dde8bffbcf60ee331bdae6fbf9d6ca9656e681cdcff243b66644e4808d71572b081760498604e32259c4a9d438c8134dbb8dfbb4ceb8913244e4516a36e8cf808ae4c91d65d56e5bd618db7a3ab438f3f6fb75136958a4a62b2e60d38545b177f90b9316087f"),
	})
}

func (s *drbgSuite) TestHash98_SHA512_256_11(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "eb94dbfaffab3c835efca8f6a2622a20287dcad7bae8b479bc9b4eaab2728525"),
		nonce:           decodeHexString(c, "c3e3ca60398229280b765e0d0b53c3cc"),
		personalization: decodeHexString(c, "a2268c8f7bb66f717e5e5a5682cd31901a192848578f0ca41867231cb7b26594"),
		expected:        decodeHexString(c, "98be7dca4d36b878fdb708d367ccf9cbdc6075e06e3cc8c96d29e1ec5e01dd89d3a03e630b40bd1b4937fcea7386604bb64f4ac4effaff5f3037617a1ab52f3e0b89fd33d5b0e765f7234bce8f3efdff0c9c7000706ab96b22c673d9524fa6357d230fd12c77b490274641eeeefb6bc6aefb66a08d7522132250ceac3e8506b1"),
	})
}

func (s *drbgSuite) TestHash98_SHA512_256_12(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "62a3be65cd40f626fa593c77f7fb098394f8d987e747691573fd170dc2863b37"),
		nonce:           decodeHexString(c, "38cbe852b48ebd1f07be7a2eee40ff62"),
		personalization: decodeHexString(c, "9f110af9f88ec6d2e0244b5a939aa8fef180c0dcf3aa53f4b31dae88595304df"),
		expected:        decodeHexString(c, "ab11fb7ff24f0fc05b13f6fc26dbecda3daf9157704c76a94a47ec9d4510a127dc60f9311306a0c02bb29d1bf7e01171743381774194728d9d0ba28ea8bb04d19eed67b205a7e511e71e3175c574d9dccae046ee9de2f38d360ba7816ba32f70ec2f7023e1b49de108483df1accae257e59b66b876cd5c2e590389ccd54e9b0e"),
	})
}

func (s *drbgSuite) TestHash98_SHA512_256_13(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "f7cd72cf750d99b41b08d1e88552119e9105cfa27c3038d1def40e919c63218e"),
		nonce:           decodeHexString(c, "3ef0bc4710cd8599dd342df67c4a6e74"),
		personalization: decodeHexString(c, "89550defa381aa25dfd1f60333c8a4d08acf784b538e13ec4718349fa7ba34d7"),
		expected:        decodeHexString(c, "e1bb1e2f3d4efb3378469779e538e1e1762c996361d14c400b198648a8d0ebb8700f73acc9d916c62f8ce74cc72357caf9d9d601c279de562c4e9e37b1b7cd45032ad93276bf785ca6022e3347a065811b2d34721d66bbe477aafa9d98dc3f5b34061d740434fdd682caff77934f4e00802c464bf645aff920d36a297e1f0474"),
	})
}

func (s *drbgSuite) TestHash98_SHA512_256_14(c *C) {
	s.testHash98_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "7282abdbf2244658abe14be954a66476d48b06436c3fd7144a56d80a0f7df290"),
		nonce:           decodeHexString(c, "ef68efad369ca5fe791ad438cf9dbbd2"),
		personalization: decodeHexString(c, "012ff5b08fe14fad65ebad5f15d74fd72d8577115e5e91262043e85a13a3043b"),
		expected:        decodeHexString(c, "1779c05411254dc5ff714eb56332cdf9a378a160bf0a20ca2da9e4c3b4e3c425d2f08dc969bd4924560c8caf9686b27720307af8246e6cef20fcbc00cb1f137b6efe9902f9944c1384bf917675a52b7b816795327afc4896182a78d4664b98196f89c466d5fe1e2a54122035863c8bd61461b2ef9e7b469492ff63364b013dfb"),
	})
}

func (s *drbgSuite) testHash100_SHA512_256(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHash100_SHA512_256_0(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "6b8959a8cddd935015cbeceb995c5418ddfa7611dbd75671d2dd1b5747936049"),
		nonce:           decodeHexString(c, "8273a47d99dfd7f6397e198551c1b065"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "d2b00bb883798f8b4db72f53ea28a6c87019085d858dead160cd7d7f59ebba333ad59542f1351998a1a5ee93d7bfc5a11c30898a7ae60a2a98a5b4c0421d86306c5357422362791eaa22d913a91f88805c34e97c5ccb0dce5182a68b429f46c9eab04a134e16af7967630dc53091269765a806f285192866d8b44b4910dd3134"),
	})
}

func (s *drbgSuite) TestHash100_SHA512_256_1(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "5c87b92d5bfdc04b6e7ea8c424588a0384797d71546be7772a8a1eb856742c5c"),
		nonce:           decodeHexString(c, "b6022d20ea5bb6873a66ae5b2ff35b4a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5274aacf6dafc0352e1362e0751ad929d789370e97c066c5c538b574666c5fc96a3d40682cd461929c9cb334e525c23a3ac64101c5ea992e94ee744a4ade3ea57e6ecb1a99ecd42a406ca5f9de7e57e6539955a80fed2a094d45095114427d2b156b390f9613845332067f49ddae05eb75977fadda554d65b229d390ba6a714c"),
	})
}

func (s *drbgSuite) TestHash100_SHA512_256_2(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "c7713c833739b3f814ca26478a80b4226c000311afce895b2d57ea1b2be62a2d"),
		nonce:           decodeHexString(c, "eabde28b11e5a74bea96bffbbff23372"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "081d6e1f6b07d7c1059e9d2dd94c7d05be33c197c476a6834c96e588341a363016468113f4cdc34b3192cafbff1dabddffc3e611db4f23dd5ae866521397f4f570f7bccd15b318eaee7f24981fc51d2eecfdd2cabca6cc24c38b97012517338c3b9ec9c19a2ec97b30a03cade30e941f351c4c18c05005376bba014168942c6a"),
	})
}

func (s *drbgSuite) TestHash100_SHA512_256_3(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "5288e404f724ac7c46decefc0abe0025a499b3c40b6205bf75188b56edb4080a"),
		nonce:           decodeHexString(c, "999fe785ca96a292c10ce6bf04c65fb3"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "abcdf9ee977cc5028d86c7fa3fbd5338a6223644e8083808f30e49c5f335d5654923fd26d84b972405d06bd4601c845a0b98cabeb87e25c8d24e063748b3e3fbf0c161faaf2f339efe54395509f1a5a04f698aca4010438cd3caa1648e84e934b067e0c9f1a9b5489d30edc160cc9633598f949e96bfdfefccacbdf104b0550a"),
	})
}

func (s *drbgSuite) TestHash100_SHA512_256_4(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "bddca3bea89caad07d4738a9102e37db9eda2b6bbf49a26fbefafe1e489efec8"),
		nonce:           decodeHexString(c, "283b34d93edeccab93c19a64d1b6dc6c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "f98dd65a3f940062ef8c17ae1ccb0e592a7488913269450fdbfbce024b59fff234667ee811a73e8022c70bf4dfb70f02e334e1c5945e63e6164318f0cf64344fe8bc1107628a9335f718f0a4a8968054fe7311b2ffff9e25c0db8de396107f7d54acb8453aaf16a99dfa435e0fd2cd5e2e40011f5fc4ad335523ac0c530ccb90"),
	})
}

func (s *drbgSuite) TestHash100_SHA512_256_5(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "a65a81f933e09ff147e99539819ee8d9ccf0cef5c40c61d01355670161e5a21e"),
		nonce:           decodeHexString(c, "2c97bd8b2b1ca680bd30e5510178d389"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "caba65a5c56aa4bd9de518494d83dec8e0e7cf81edd57013be3ab8370dac3f5118f568a460dca8e126f3e197cffcfd88270e80de2630a8e0c8b921d8d4b49b59e2c69b0d84180920436bf53a6e87883986216c82e76a41ce1f0091007aa95ac98e1b24c86a945844d0024d22e66c5553d11ae09d72d7fe1e71634b3a18015f8b"),
	})
}

func (s *drbgSuite) TestHash100_SHA512_256_6(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "4ef4884ccaca2c0d21a0449945e4c4830cffb670de3230a94166b9aea851167f"),
		nonce:           decodeHexString(c, "7076c9ac76169ef2c86de3d57c310a37"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "321a73d3b018d1e7d56703ad895e83f95fe527c89e27aca2ab8880f27b93acef790698c3d8f03c463f5fc1424ebd83992bddbbd05da00d05ce8ae90122981d3df71d7a81f70ac6faf3b15d7e46d86182dca46d9708839696778fcc345a4d7b01b88a92f3592b7ed4f12be26e4046c3af82a5c369e98e085d6d30cd549801a63a"),
	})
}

func (s *drbgSuite) TestHash100_SHA512_256_7(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "ed0f1e9b57791a225f2f30bf3b6b23b5b7e3522891221f4104a3de50e64f253d"),
		nonce:           decodeHexString(c, "3b1511eac28053ba0e617ebe9e3a855d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "cbc2df37fd9c3ea926c75b516d1a23fe69e720903246e79035ddae60530bf21758246dbb404d4685c4cfcd4f678a9c30e59be13a3b4149a2de84d74daab47cadeb43eae79c2a40f5b30cc12450872f320087c5621ccfd94deb397be150ef69db4e8f8fc12899aa174d11b9223013ca887c427ac03f7c78419df940fd86b407fa"),
	})
}

func (s *drbgSuite) TestHash100_SHA512_256_8(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "f17065ca3d67cdc96ad35875bfb0c5ebc0a3b9a0b1229fac931b3b2bb94bdb8c"),
		nonce:           decodeHexString(c, "1bb5fb90d6bc99d68a121a506651e0a0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "0e49c041f17a7e9efce3a648635ec94b21e85ba0926705a46ad1ed9a6429ecbd75d846cd8aa493c70ee16b4064b4829ed71bd3ac43aa39c83aa4b083467510ecfda55c58c86aea9e96f346c8c1d2c24704d36d11a6e9a8ef4cd523d3f6a5a3c58f63fab379a539d7ec0e2f2e74e24c39b4457a7994240a3aa9b675a199fdd738"),
	})
}

func (s *drbgSuite) TestHash100_SHA512_256_9(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "2329c54d4ff27ccf43911dfce4d7089bc7e1dbd097b8e54ea58000d1ab075917"),
		nonce:           decodeHexString(c, "f2ec3e850028ee960871dc25c3cb0230"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "16245b7f998e714cfe8388088e00d17796e4fb77b520d70103e8af876005a1afc48b382e2c05b72c4e8b1ba1d918ac2303a02f33e02383ec53ee7ca1ceedcea50963d8d57ab5e4061d6b1e8afd73bdf9d064b5d4c977bb27e2b79320077a0d368f727aa3ef95d70d5333dbfabb9ba5cf958e7be79d7eeeb8c83d3b2e63060673"),
	})
}

func (s *drbgSuite) TestHash100_SHA512_256_10(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "20b3a9c78aa533afb888486dd4c4a25a236205724fe4e4a5f769974be2089b8b"),
		nonce:           decodeHexString(c, "e96d564dd0b12ff8d2872495608b21e5"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "01930849a07748b0c2469160afcbfcccc4bf909df5a4c2eae684cc08e28883142e760e7884bf10873cb3700fcedafec4f2dc4429fa712546ee750bda0174e94e35f4cc04de4c79055ab457d9629168b6337969f6f2128a7a7e2a4651bf99512825b851217df9ca15905df4ba516119f84d0c8aaa3f6cb3b5fcd3a29dc55f940a"),
	})
}

func (s *drbgSuite) TestHash100_SHA512_256_11(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "902c4bef72d4140d8c7a31406880f8e8a9e2f3e6a9b8b130a8f9a9e7422b70b4"),
		nonce:           decodeHexString(c, "25cb3fd05429899977bb62077b55341c"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "34bb5610fdc5a9668cbdf35158bbfe8854ac2fd82dcb2dce70f549cf9152fb3380ce054bb12f4e4e9a1e3d507f8fa3b7e63790f5d5fa4fb987ed6c67bc1ad0c9dfa3cbf987bab4392088d97d76a12cfebea471ebe49b11f9e125b78b49ce01d1d932fde99cf482f902f2f5ea444261eb25cd7c6e9ddabf296ce05a0e2e01dad0"),
	})
}

func (s *drbgSuite) TestHash100_SHA512_256_12(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "590e6c0cfdb6858bd8820664684bad3f2c6e599b2864ca497f2dc9a6d2bc4237"),
		nonce:           decodeHexString(c, "025b0b96dc76e414ee0364f851f2bca4"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5bd5ef1b1d58b77f86f6b33e7afa14617622672a27f599dcf938dd0585cef44e41b736fca01ca13d773f6117a9000ce6cddc0119f60da8e2d07a0f23df8cc623c3a597f86c1b6b234448b8e056433e1ced41e6c9b909449876ed0ece18ad7371ebb86cd765dcc65af13ea4cb35e82d3a437649373fac9abe4099d15d2547ef3d"),
	})
}

func (s *drbgSuite) TestHash100_SHA512_256_13(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "4a90c6acd54292dbcd698f061143b3f41331008d8749da24034c77433d9ca735"),
		nonce:           decodeHexString(c, "b2ca57227002eb0ada32630938b908bb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "880876ee68e2d0dcf07951479e1002eee41dbdc5c4713e818f7cd8c6928ab600bd92155fe52a2f8518dfbe430c3f81bbd5ea093d012e8cbf8c010ba3628677a547791a804b5037a95c51f33196435e7235573c1fa173b6f28bc1cdf60944b8a2b6754c693a3b9ab1a59791118988357b0a4f95f353ee7e0dc4f3bb42998222cd"),
	})
}

func (s *drbgSuite) TestHash100_SHA512_256_14(c *C) {
	s.testHash100_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "0653c409e957302f6eb62bbc4f42b30942ff7860e7c38dfb2fd26b164e83a713"),
		nonce:           decodeHexString(c, "273f7eab3dc9bf11216d5216bd12478d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "51dfe9851da8d7d5add3dae413d8bab8bc7d1fcecea00795ffadce047d5243ae36f29f3611fb8cb66e98717a98735384aa6a310696356cb48f4672b2ddccf86eb44777c1616338792629b6cc6ec2b66dbacc1a6b66bd9364914f1f43277f6f43e13145fcdb73a4aca6b784f9084d22c967033651da610e9a85b1eb7513683dc9"),
	})
}

func (s *drbgSuite) testHash102_SHA512_256(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHash102_SHA512_256_0(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "a2b29309b2f92b994cca9341763711f410de0809864222725b0a6788c93c4edf"),
		nonce:           decodeHexString(c, "9ce6dda51f41070595a1e46ff04a9946"),
		personalization: decodeHexString(c, "7a76798b54541f1e467d8c9b3abfb0fa4aa8d0198dfdaf8f76018a44b39ff01e"),
		expected:        decodeHexString(c, "ebe18d74e532f6b2fd39cc67578a201846b071455399e28817f88d821b83a7241d67b3339e668590fe7095a777e91e648d535acfbbe6dbed8da2a4a372afb6665a450252758a311a26a90c59a31b2b231d7d23b5b96c85d505fd00b8181a92b71a33c7d01bd4f9d99a304fb5ee5201a8d252fb56cc41e631f489f153037765f1"),
	})
}

func (s *drbgSuite) TestHash102_SHA512_256_1(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "df32286b47c0ef2e1c970a7c3dfc467b91ca44f6d7a1f0445b42ea0d837bc950"),
		nonce:           decodeHexString(c, "7546e66191cf9e9161232119d7e13c69"),
		personalization: decodeHexString(c, "c931524ba9e0e2b2f3f6022feaf919e26747dc6844fbc5ba3860aaf54bcaa0bf"),
		expected:        decodeHexString(c, "922dbec1d4cbb4db10f0e820df95fc89dd8621ca5594d5805d15d705cd37cb36a62c381ef769e7af533af4093840bb2831f49d280a8861d82b2730ef9ad99c219554d8975743d68e8690137fbfc2e5533395c2399782e914f1d79f6dae6f2f2b9baabc9f6554955dc21f07aa9adb322253298b0beed2ff5f7a4531b53e64393d"),
	})
}

func (s *drbgSuite) TestHash102_SHA512_256_2(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "6fce9964b6bb05281bbd8311590012e1108271c8ad097db0699f7ac3d67f3a29"),
		nonce:           decodeHexString(c, "2e045d1cc4eb81ae38413fa6659014fc"),
		personalization: decodeHexString(c, "bea5d64a6baad14fc071bd6762a5c12479453924d5aa5e323d21221abe198dae"),
		expected:        decodeHexString(c, "212445f37cc2a1ff5cb25e8a2af91bd27fe35c51785ce1cec4153cf948cc11b306cdcc0d51987f966f4158ce0fe7d220da97a15e673013d935cfc2fd02387ab33bae792855a1293e7693347d247201d9197bbcd4aa62e8eddfd0a451471d9b87a2fa364fc5ff26d3282628284b0920faac064279ca14115193a3b34446987a6b"),
	})
}

func (s *drbgSuite) TestHash102_SHA512_256_3(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "9f8b0f7624abb0a45e80b90c5b3553f8d959aff3f815800e25e5240a3600bf62"),
		nonce:           decodeHexString(c, "10c7fc760070664da80fdb1ac11e2d68"),
		personalization: decodeHexString(c, "281bd732a5178359bd5a41d12f4dc2d98fb765e770ec0246e027e0111f936482"),
		expected:        decodeHexString(c, "a7ca3f6d2627c8206ec0c2b2384a280704e13e25438e1d0b3fc8adb5007ba878d1af2252f931065e199a01067961f4126b68f7f2e57b704dadbf9e088a5e46414ad2e8e5c737c84076f9b278b263aca7cd47fae99e67e4165f0cbe4188f07a96f9642050c5f4cbe85ae6ad3f4d07ec16466af69016f4e4991f1d73bad6ccbdae"),
	})
}

func (s *drbgSuite) TestHash102_SHA512_256_4(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "bf54e9b65e42afc599b1a12c8e2d375c6bee191b726f3233251cf7d54b81042c"),
		nonce:           decodeHexString(c, "ba8ce550953593d132ceb2a745e3c389"),
		personalization: decodeHexString(c, "49e27487fab5d22994ceb07e334374258e77dfc044aa233be3a3671ed4d49444"),
		expected:        decodeHexString(c, "f1ade51fc3b79e8a2a800ba853a28e1575a89fddda009f2539c8c33a5e7262e337b4a72ed687963936d39da22295a71c30f80c4712ce4f32e09450559e72e1b1189ccdf54b1b13a3452716d48a2104c6855a89c4fbf1f0544d3a16e7f8b5e5bb65130f78b75e648bf19f70548c48d42e9267c5afe31ab45204679748046fc692"),
	})
}

func (s *drbgSuite) TestHash102_SHA512_256_5(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "4735955e851914d0d4d9af22e10edcf09e9f27435c29227e4dc2b7fe83081a0d"),
		nonce:           decodeHexString(c, "bd9b292dcbcbf64e11d402c30a76b086"),
		personalization: decodeHexString(c, "6c69a375f34ea77f015324b2638db8078d005d2ed6e719d3275e02fbe277bd78"),
		expected:        decodeHexString(c, "b1b0bc1e3170d66293e5eae853477cb0d0124359d39c03e7797d0756a696e6ab432e2e30296897b065ff2d0ed352a06fed9960e25c562bdd16a9e06befa4c71d97c6a386f8d9dc15fc8510dce6066e9deafcae0854e6919255b4fb58e74ca74346b898b33ae6c67a43d3a4d9ff0c733ae037430892a890959d22ad8402ccc789"),
	})
}

func (s *drbgSuite) TestHash102_SHA512_256_6(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "b3a2333c8bdfff01ce14a548c449ee740373a4cc5230d8b98942aee21f37c850"),
		nonce:           decodeHexString(c, "f5fec1553d0f592a169e29fd589ce3c6"),
		personalization: decodeHexString(c, "1f6917764a67b698377791dc5a485afbbe61d9a31c5a51467ac626d4dac4cdf8"),
		expected:        decodeHexString(c, "7c4acaeabe4a2286a99a69a79140090c274c8c77b17743caa20df2fa1a53278ffe89ea16011058ea42fe34513b77334b702efdcd10ca177ae6142f8b2659e9d798933dcaad33c4c461dd22114ceb33c419aa3a6cd39e924ad7d67c4473c9e2c7c0c5a8527be4df29dce0acf7aeba64c0361c6ba00593acc913c225b201ea6d3c"),
	})
}

func (s *drbgSuite) TestHash102_SHA512_256_7(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "7b002015b18111df35257b166fbdb5164bc6a7c40d5ba772ec156e0e743652c8"),
		nonce:           decodeHexString(c, "19c0a51144fb8075ea7940d4f5052726"),
		personalization: decodeHexString(c, "7b60ffba6c8ea841bc142ea2a5f0712ec5a388e66c782a27c24948184ac14d6b"),
		expected:        decodeHexString(c, "b6fc6ef2cfd4d6eaa83d8519456eebc0e4252f63f94596868a4221f41f82f58c1971b1fdfd164ab9f537b491c823608eeb2ca0a099762d8eee4ceff82067fb7bf6cfd41b60cbeed82c3a971fc00b7f119d08c8ab1d69ce9ec63639116964cf29d2bdbf22213241493e6a2a08975e76335ac454a892052ce973a557cbcf73c3af"),
	})
}

func (s *drbgSuite) TestHash102_SHA512_256_8(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "1903fc982cc88bcf375bce7b64e493ba9733a728e81caed82a0e3a86d98b7530"),
		nonce:           decodeHexString(c, "592c7e7a4aa8d34cc21afce08f230249"),
		personalization: decodeHexString(c, "aed355a1a441126913c093b512532afebd9d9a847162534654bbde9681c1486e"),
		expected:        decodeHexString(c, "7e912023704f16153c4536fd54b7f04233ad944f5d844605eb804d26f1ca9b67fe7eda2f92d0dbec79532739d82d10bbba01ff4a54a1d2924423dfe55c279ed734e34d40123ff85cfaad3057ee0700940c6aa0ecd6fb0eb19b1e65e687315d59d18cf713fbc21dda8dd810b1df9b82dabc045b3122fc15311ddc07a6f13a6d3e"),
	})
}

func (s *drbgSuite) TestHash102_SHA512_256_9(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "c934043116ae190c4ad878b68baa55a105ea3d1cd1a23e8666a3c1b3e02ba71b"),
		nonce:           decodeHexString(c, "f08277c2711222d21e3318ab9248f8de"),
		personalization: decodeHexString(c, "b35121b4542add788df00c652c248532fa7c7f13b8d00f15b6d688bc0248dc52"),
		expected:        decodeHexString(c, "472ea39833518026a07fb3e27902eb45c67526f097c35411bee82e57321dfd19cc1cd5bf0c34df829130a6cb54f4393354edc2c403d3060650e86b284fb62220771dde26c151495486e4b6b3f08fcae2477ebef222dcad87e637aa8caaf965ea116452c2b3e633a1ad91d0a8ed53c13778901e83de77517ebd9c64011c131f5e"),
	})
}

func (s *drbgSuite) TestHash102_SHA512_256_10(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "a206aa10c2456110318e3e76cec80fee80496e1f595f26afd100f2a531131699"),
		nonce:           decodeHexString(c, "9c332bef31e05c6ec0c0c2f2c6562cd3"),
		personalization: decodeHexString(c, "2391dab997a7f4563a5f5ea03835293645ec700b922d1d722e3a1a4885c165f7"),
		expected:        decodeHexString(c, "ff6947374b3d0658da07923ffe4d1f5c014061ef906b02ed82c1c59321c4776a5b4b43f203d94a86f309fbfbc9c1ff7384778a5b35c74f5b6c4ed1dfe23ffe1cea0435effbb7faef75e9bf83fc8493319b8279130c1d0373d04e8f1906ad03bc0563ca2551cc314d7a160982740a0212208a46ceb1ecc738a1b49987fed632db"),
	})
}

func (s *drbgSuite) TestHash102_SHA512_256_11(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "c9632fc29a38d4f1b72654e1502544e786fccd7fa34ae513cb5c96680c4214d8"),
		nonce:           decodeHexString(c, "4d99af0e49407764159aaa3928d6cd1f"),
		personalization: decodeHexString(c, "75ae0ec81469e7f2c902fa4c328f9eb9ffdf277f656b82ecb637db898aed5dc8"),
		expected:        decodeHexString(c, "b0654f50e28ed708484952510dd4a04c631fe420025fa006b937a5046d5726803961ed5474e07005c6b3b6e391ed5eb89f1ad1e23fade6247bf14417087e62d27320c75a1eb5b842a4722b9cf6ff9f79911f747ec25709b8ef643cc76bf6006b3ba237ed9ebb18d0f98e9f7f6fbc6e5591da1e51956ee961bacb51a1037b25fc"),
	})
}

func (s *drbgSuite) TestHash102_SHA512_256_12(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "c0819e94b28e3ad495edc492d65e0d58cf83ced02e31bba09516c5be06c87476"),
		nonce:           decodeHexString(c, "afc45eba87e9542f12c85287cc79c880"),
		personalization: decodeHexString(c, "f64a0309ec12b8b38433d3e22870a8efd95a9cb891a706ef0815720a7f79bcba"),
		expected:        decodeHexString(c, "03b81d0734664b3154c1c1b6a354a5a5c5990596a141a5153f0dda4a91d02e79cb2aa1c442f1f34d65852100e3b6522da2921820c791d3db0447a31698e967d24989fc9071b0571ba4484a7e87966f85a99b0b7f1f13bdc156c546dd5eff2bd8e62419390291f4a6d8b4706cda3dcac5382150ee68f6f41896daf60692458040"),
	})
}

func (s *drbgSuite) TestHash102_SHA512_256_13(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "2d44aa9db2cca111cff20727708b96ec48aa270b9711dd4f3a7e41c7c91627b6"),
		nonce:           decodeHexString(c, "d9ffef52eda7a37a2ac55e170c8287a0"),
		personalization: decodeHexString(c, "eee6408c66e3853730d50bac7ef6964dbb6e0180b75de7aff2102e178209f1f0"),
		expected:        decodeHexString(c, "a4f7e08a321a50417d71076d08f86b71e644303a4366fa39e3cb27b8b2cc0dfc2903ca54cccb019463e0cd6c7cb29ce024820c2fb5d2d40d56c158117710a80018a6440b19396f025d069d32a59364e758f13bf05f406bb8ecc6dea73c8da68cc36306d7e66a1af6909ac3fbab7b9d515e881547da0b9cececed22c3ed8b01b5"),
	})
}

func (s *drbgSuite) TestHash102_SHA512_256_14(c *C) {
	s.testHash102_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "708525ab7b7b2027fe3d5024e81a14e828ea85a78633618486938a4460c601b1"),
		nonce:           decodeHexString(c, "10818cc50b58ccb660d65ff705041a37"),
		personalization: decodeHexString(c, "2756a89e79266d6d86bbd865708321f529b023d0cb5ee5d9888c37db33dd5164"),
		expected:        decodeHexString(c, "7b3d778ee1623b08875305d5761ce2cf44ef1bab87c7d0f29c862c40d3da31240e7450d827909b6b131a9b0e9ad68d5c02caebf4f3b0b7d7ac1cc58e353ba68e7ac9eefc3de1310cf9bf5f4b854ef3fc36e940d4fc50072845a83c38a7d4372c191b900d11d11a907a50607c348951ccfeba4efc30377e4a965056e4e84eeb02"),
	})
}

func (s *drbgSuite) testHash104_SHA512_256(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHash104_SHA512_256_0(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "db6dfba414ef49f895955df1945d700563af82c139d2bcf6c01b95adbfe77f00"),
		nonce:           decodeHexString(c, "69ea910066446cd8ba291faa094db8a7"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1533fafabfa93fd946de67a35b7c26a9a143c59bae9338e226a2ac46984b7d2d674d8adbcbaa9795c3b2ad64540207a6f6131f549cffeb6e39522a1f23fdc8f347f23a51489889badfed38b3ae3742bf4779229aea54c5e844ee84479a8786e61755d610fa3ce6e687ba18ed5d174d823b15ccef9880111e02db9315b8515352"),
	})
}

func (s *drbgSuite) TestHash104_SHA512_256_1(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "9699a65f2df69a8b3ababe4a7227608ac30f63d5487e7b3b05f28ed941803bc1"),
		nonce:           decodeHexString(c, "7d42534a62ba99f267dc52feced0edff"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5206df57c834ba53c50b116f9a0cec6add0c9541deb030b39c217a5598fbc6372dfaed871162af6c99c36ed86d8c08d819fa56b1fa2a203fb54628a8d348c8fc65cf21a021b85b8b8650d6178042d75124557e55334a7759307900c42e0442dcb090a931d4dd817ee1dda05f7886529315e940695a8ed56b2006bfc61b2e85f5"),
	})
}

func (s *drbgSuite) TestHash104_SHA512_256_2(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d5b674e58f5f8f21e0d8da8703ee62dc1286de9af95ee7421b34a951ce5db6a7"),
		nonce:           decodeHexString(c, "19c2ba4373b0e0c7c20a281ac8d3c438"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "991c8007d8632e34001bdc6283190c2a43d89a56176708247c74a24ed65cb1f544d1abadfef80133015af9bfe9502834c13f1ad0d5259a61f19e378c970fe7eddf9bb5750359d54fa30febe7fd3768db08d8ee3772dab65f3d78417cf13747af2bfae448b3ca4e0a02ece5eb04195c6c635f95b99782e42b74a07815936cb064"),
	})
}

func (s *drbgSuite) TestHash104_SHA512_256_3(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "4ce06c20df676af7fa851e9be2b4ea2a86be64d8188c7da6353df113b4f000ca"),
		nonce:           decodeHexString(c, "c7542cfb2456650d2ccefcad9c7964d8"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e0b6d8f203e6ac81a4bf4a751530c2f09fea755bb0a972bbb2dd30d413a43678ac90315ecf05e624d10e1a5db7fe89daeb2a4ce455197f4f490c4ebcf8866587764b77f48be58f88949e7af6e759fa99d3663fff8106c0352350a24a78564212c6da2d6772d1d0d038cdc509dfe1f066e8714ee230366727958570e1a6e4abe8"),
	})
}

func (s *drbgSuite) TestHash104_SHA512_256_4(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "f15833c6350257237e8307a32b4db1d638639d8b473810493ecb6d62ac0c1094"),
		nonce:           decodeHexString(c, "f562941b78e840493f81760a83e47209"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "760a9b1b06ef0e409efc635e5a86da02718a84927de5b51d30474984b018e466eb176d3cd548bc3dd6b776fa102dab67ad1be00e5754387ba80921a90ea5ba9299cccb8a2e3eb72b3f04a5c6ae4aaf62ab04c5660421582a305e1a54f34d9dff34c3e33f47928ac780afadecfe50a905a672a7fac476a7c12716b2e0d5de92a3"),
	})
}

func (s *drbgSuite) TestHash104_SHA512_256_5(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "f33f1c74da1ca7000bb8c4dba59a79f3bc8a11c3fdd3e73196a54b0c93732946"),
		nonce:           decodeHexString(c, "543b324f3807f63e749c3629c4a5ea0a"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "8d2b1c2c2835c21c7d1ec1c382e717738a2a8eeee716146fd23f12d0ce42c320fd935b97710702639628592f4dbfc83334bc921cb27adc8bd704affe1616af16aae655f4026a7d931f8092bfaa60df8bb750e4aac86505df154cdc68d5be3bcf64f09297df172808efa2baed0ac6159db3ee4d887c74140803f0927c56e225ea"),
	})
}

func (s *drbgSuite) TestHash104_SHA512_256_6(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d1f72d93915eb1dbdc5e0783078c64b7fc1ff3f746eba67f07260641bb4ae597"),
		nonce:           decodeHexString(c, "820759cae8c50a47f349acc059d8970b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "4255a149e758b54ce159c7a627d5b0ae5ba89822094d7d5e8ae5ec4b8149ca04655d7ee953a78200358f95880434aab6b3dd5b5d90440dccf7acd8001728adf857610de53c98e9717536dec368e9cdb4db2e683db30b2269a485fa5087be25bf4f845f2301b858a9b32e1cfb09b8bfeb7e4e2b38cd3140f016e4a17457efc1ac"),
	})
}

func (s *drbgSuite) TestHash104_SHA512_256_7(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "89af1c3421ddee1b8abd1a3dc386f10c0d02b9efa1defb30f6bfa02faad51492"),
		nonce:           decodeHexString(c, "f723457ce9aa2a3aa439711829a15a70"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "508685fa0696b2d5d2aac8f6987b4c83a0118efd349ab72d3ba13363a4ccae18f41ff1c05cb5be59b3b45de85c332212d8cc827ce4ca00630581bd15f47551848557494d0040bafd02193971802db5483727eb00d1f7ea620648c92760de8780e5d70487085b215f3a67f130c633bd7e6e4a963c57d0b35232cc16f332933890"),
	})
}

func (s *drbgSuite) TestHash104_SHA512_256_8(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "9c2749813fa1d0475abb8fa34d2ace6340d3693801f506448f89284693380d98"),
		nonce:           decodeHexString(c, "2c2fe7f4ec934b5f7d51dbd1410c9308"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6ddd7cc110272e0fbf8aea493e5319435d3d2446ff51ce89c84ee2cfa4dd42c0a10e1bebfc92977f6c898ab65a2bd59a7170e8c83a0b349399026bb8a656f8f9f27d167042f43fa367d407d460a44d1f6776f5420afae894f76fb6b960a2d76b2a7ac4ba2653e8753fcd54dc36ef5907373ba20db4fed72a078eec3d99687bce"),
	})
}

func (s *drbgSuite) TestHash104_SHA512_256_9(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "1de3b3eac4ac1b5981a60b929fe054b81780889919cecc4d06304b5efd1128e7"),
		nonce:           decodeHexString(c, "d46cf622a5ba659a3a53a6e3aa02abed"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "58363af7e61ea5f8bd8313abd508bda4bdb4c89f26fe3f2f4ed0d56b5e22bc24f28ff17fbd03aa842032cc0f780407dc9a67588f31634d28ad6cad773a36e58dac33243c2e25a9c72cc91fba36a6c0ccbb504f1b64f76c69ea857c9a58ac396a054095464a69ea916df9eb178872d1162ec3b857fb69d5fb0b28ee98ea309fbd"),
	})
}

func (s *drbgSuite) TestHash104_SHA512_256_10(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "5ec6edc2bdca4fa7e3b885e70a43045b4088ee07eb79ed563cab5716e9843d9b"),
		nonce:           decodeHexString(c, "fea3bdb647c22649fec9a30cd1d44bfb"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "1aa2d21d79e82e6382423101eafbbb905513930beb78864a023c0ba81f9bebc99f74e9f97dc8f68c5701fceb6991a7b65e3978e17e24bdb898fdb96037fbd1d6820caf2ef786d2825d95fc3ea031597f4e286c48d036d49194c3da219cf7b9d90ae72f161ba2ceb642d622cc3256689ebb2cc8a4e46051ecbf6a6304ec36c54a"),
	})
}

func (s *drbgSuite) TestHash104_SHA512_256_11(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "59d17c36e4eceb4de7c23c104a3cc94572a7297c8cd83735a9e0184e74dbaaa7"),
		nonce:           decodeHexString(c, "1147202d56aec98b784c2703f8b66474"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "72624e2c6f1bb62079e3e3b74d60869a7d63d49426f51e4bc6da2c171247779dc3370c3ec48aa2c64f5d712d0d41ef040410f5056fb08894392dfd576f2df410947b54c4bf3540187120d4301b51fc11014b7f6c1a03867a81eccbdd6e0d73f8e758c3ae0b935df40771a0f0c890c9f3d2f46c1eb9e66c1688c14427a6b58da1"),
	})
}

func (s *drbgSuite) TestHash104_SHA512_256_12(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "ca9f514aba48a854c94f9973f69994262411da1728585322a71691507895b3a8"),
		nonce:           decodeHexString(c, "b04944da2bc79245a96a015d9f2673da"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "bcbe1625a4e0e6417c13b0a615102934333d942dac85ef3ed0289b6f7a318f80addd5b1e9382165d5a3ddf11a171979d855c7bd5a8fc2e3976029f3dcacdb14e04178d4bd84483856be2f988af694d8e482eb1282d7730b288b7dd7c3eabbc60f673d3e229628b5f6ab4af9f173f7aeefd249d2bd73a78403cfdbbae6cb2a053"),
	})
}

func (s *drbgSuite) TestHash104_SHA512_256_13(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d31ae8d557811d17f12d1e8d98e897499e6cea5ad51afa654f3ab2c43b633597"),
		nonce:           decodeHexString(c, "8478c766f94b48f94aa2b67f8963b52d"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "6ce2058f4dd4d7c2aadf03a0424a33c439b641de320ec2e8fcb33f8fdab0410cb015a76d4931892ea0a188e55d3a9790692731648be5e3ae36be3b9d3eeba21a2c62a0ec7af9f8c2e3eff2792e7bfafb4d346a4fe5077f6b3c2e34d059104072137576721a113e981e47480635e5d0da90143f2c960ee3f34f5e50cc22b15b75"),
	})
}

func (s *drbgSuite) TestHash104_SHA512_256_14(c *C) {
	s.testHash104_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "3bb1f6cabc56a02643eb767cc6e5bb3a5bd765555e4e27159ec905012f58de22"),
		nonce:           decodeHexString(c, "cc37cc9b20a2e4de0bdf8ccc3261eb90"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "28f20b9a94340aaa6ca98174b5929ce3329d81bebd67faf5e30d12f775748c34c848bcda26cac8b4a9b34c7c92c9984a6f5a85269583358e985c2b372a887f9e3f0f3920dd512def27d818522ed1a49e96d00a5aeb41bafd152144a8b6f93426e73d6e8ef7a8a5381bc464b24061080af02aac51fdc52f404e1349b7d04daef8"),
	})
}

func (s *drbgSuite) testHash106_SHA512_256(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHash106_SHA512_256_0(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "6ae74ea53cf8de98a48987c0791031a3788fc6f1a3a9fa3c2ca98456fae413f2"),
		nonce:           decodeHexString(c, "77128adb2bb9ee72aa11b510c92aa39b"),
		personalization: decodeHexString(c, "d309529d43091c81bff08bcbfc643a1d46121be49fbb503cd8401d86a5f585d9"),
		expected:        decodeHexString(c, "7f7a9cf087d098d8f437304c5ac8896b16d8190b618bccccc5b6e15a83e9a178abf78c176f8d43c80451f15fdd1af1e247d00475c759f269e5d3c30d279c90152292c3bb850fbed2c59bbff1d4ea15aa57e97aa35204e1831a35ff53e5f4669733db3629f213a1a1efe3c758c6f9c23dd7d99685a4b19f1a3c3f2e0596019e7c"),
	})
}

func (s *drbgSuite) TestHash106_SHA512_256_1(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "b2192e2f41f611db8fd6578c4db7b622e1356747b49a63277815ba90113336e4"),
		nonce:           decodeHexString(c, "a9879ba05c4b012f9a371fcdc37d6b4c"),
		personalization: decodeHexString(c, "5bd87f3a4a6f3b5f901382397af83ac3e6cfac953ae1b35b257341e0e8ee4bc8"),
		expected:        decodeHexString(c, "814e44b745382415fc4978094c77dfa29ff6b2beaa09d89ff1301355f72535cd35b45a3766acb81715d7e71defd76a73488ca327c4633bdda604d4b3a5e7311e85b828debcd56ee1cd306b69eb09293aa3bd4ff79d857b5dd1ceee89ba47e7142bdf786a3724ef6ea9486e1f3d49b634e3ee1f9684eab8b8f0fb447b9cb0ad63"),
	})
}

func (s *drbgSuite) TestHash106_SHA512_256_2(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "de2bfb9cb335e6bc20ec4996ee55ea9fcbb5332d0f5609dd08b9a8e6c3a764d6"),
		nonce:           decodeHexString(c, "d002e99b429afc604c2fad8be38eabd7"),
		personalization: decodeHexString(c, "cddcf4bc93b29b5f80d3007bffede16937aab58c86ebe57268c9887c8dbf809d"),
		expected:        decodeHexString(c, "f79d24aca980c80d4e446a1b52ab36e9f5cde9726890be621a2609e3888fd6c4d7a263ba045603b28dd2059398986387129d08cdbbd667606d83c561bd7e024813656834643adf5507101275bf99c9f3f706c06c031a03fd34b10d05df736d819d720265f7c6833e7291150f93c19ee3a563e969aaa7c7ab993d2e995fc4cead"),
	})
}

func (s *drbgSuite) TestHash106_SHA512_256_3(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "608a851046e8a59c9cbef11357552d67e4dbe386b164ba0972939f11343f6427"),
		nonce:           decodeHexString(c, "17f976167e4cc80effd01d7e63635a51"),
		personalization: decodeHexString(c, "31296aaedc99cf580cd06278f024f6c64ad1497195396f303dba4ea0757bb631"),
		expected:        decodeHexString(c, "782f444c80b8d9fc17120795fa5873414f6a3bac01a6f4dc3152aaaba22d3b6c592c5745a1f6d51c42887933d7077cdb648c4adebbeaf14f7eb43a001e2d6350c7c4bb4912ec75de5383610704d76f4c7e8da45f03b337a7fac87dda64b896b9b3cd1c4530402539871bf974c69d3d26eb11c0fb8ba159a723aa06dc0fb7b262"),
	})
}

func (s *drbgSuite) TestHash106_SHA512_256_4(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d34d85e13a4a8b2b22818984da7b1025554a9a5340aee24002e8cd6504fcff28"),
		nonce:           decodeHexString(c, "61fa36db1ca8950aa4862abb44b50600"),
		personalization: decodeHexString(c, "76e9f9bfc30cf06b1212d0df29660f1454b877a83a4f90b5718b2fde18d73224"),
		expected:        decodeHexString(c, "3df907621663d94d48613ef08d1663249a4b148989fee50d44795337b6edcd9f7dd22d626524cd90f725e2c26ea5269b5cd10ca341186c4bb0f488c0a91011bf960bf535dcedcf6c2d0021beb24a2466929bb3da14ae417612ec609d09e563dc5dd29fde5b9fa84c24aee995380da430b381c2c8bca77a66e3c589497f0cda8f"),
	})
}

func (s *drbgSuite) TestHash106_SHA512_256_5(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "f8dabe8985be5e7d44394353b116a05f04639a9af63cb86c5d7869c52a1c081d"),
		nonce:           decodeHexString(c, "492f6e8c76b8f44dee078c05faecfb06"),
		personalization: decodeHexString(c, "82b9e30283d501574db8be220af52b91537f3c4642ca187f47e04c3f18094136"),
		expected:        decodeHexString(c, "d161b0aa71e697bcc4c5c66573c9d4256b8320aeba913b41b84ab5626db7bfce534dcf655bafbf518586e68fdbc86026a60626b96f4c0b021fbcfb03ff39cbe537acf30af98a81e1756577fa4a99a0f0d92fd5f05d654e53f7b50de81befcb2d78338f7af6d2b7522cc2d709797662d2b6e75020c21a327d03d92437cc95351d"),
	})
}

func (s *drbgSuite) TestHash106_SHA512_256_6(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "8b7c9af20937836cec75d7b500dbec1249815da50471950b721473203cb32045"),
		nonce:           decodeHexString(c, "f587727b11ceaec028b58695724896e5"),
		personalization: decodeHexString(c, "92caff644278f146b70b5c07239b4759f76c7a7491fe810699bf632b95931568"),
		expected:        decodeHexString(c, "63f7946fa19b086ae9c0dfafe4222a5f71aa1de2ad00fc16f1a4cdbc428b1dc5e33bc0512c3bc2bab4f38847eceeabf45ec49310cdf27809125aade4cae5922043ef63f5218e08dbb09c04551615e8766efcd77d7d7ee532cc8abb730917aeed6b9afb33e7fa7d659e1f11d6cb1ad178dc1c55a9771fa08597e615e2868e3d87"),
	})
}

func (s *drbgSuite) TestHash106_SHA512_256_7(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "fd95873c6328ea01bbd080bc83c6dc6396da15484e6458fe7af7c43ac0bc52a8"),
		nonce:           decodeHexString(c, "bed78eb94bd44d8d542067cd04c68fc4"),
		personalization: decodeHexString(c, "5db74cc6cadd8b18dbc31fddfb8d22af93dd63cf7c1070bb377d97b2c18c8475"),
		expected:        decodeHexString(c, "7636443dbf0aa1ac9fc49532b62c74cf307df234b84c2b90e24dfeab7de95334adf2b3304fc549a27c45f915219cb3b305942a902ac08f6975dd5d607ffbb0a7d75d0373d647d5ab49f35651a53e18ce3c7f8a3355368199095965b7cf79c4e6cb030d5813ca83b1f6fa353245bc2a269cc4c905c51f5944e0e0336f263848bf"),
	})
}

func (s *drbgSuite) TestHash106_SHA512_256_8(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "9db7bbd5d511a3c605c4aeb5d7815af5fea38f3750cb01f8f8ae74a2071a3ea9"),
		nonce:           decodeHexString(c, "b1d9f4c7b1f2dfa17d892b341c55e8ae"),
		personalization: decodeHexString(c, "e89a556721874b6939a8dbcab703f416380bc054d88bf50783260cff144379a5"),
		expected:        decodeHexString(c, "ad1b0813e743524d0aa4ee845ceba906ea66347a4d285b06cf84707a9ae6bcc36fb0db52141020bccc846b0847b633f3d5f24046dcdaae2dc456ee2f67655f1152a36383448d835fdd1333c832ccf96cf96f394a5830a3909010eb647d4366d63cc710433ddce17310e82c49aa56dded4e0f5f9df213a1dcdf3e456334bcb404"),
	})
}

func (s *drbgSuite) TestHash106_SHA512_256_9(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "b516efeecffd7bcec3bd16f39dc3aadfcb230385153112df9ca3a3413563916f"),
		nonce:           decodeHexString(c, "9ba212a4d73bda328199b5bb7252d84a"),
		personalization: decodeHexString(c, "7e2343b0525373c968cc752a66345c30b74cc7fe95d558f86d96fcb67b9ae3d2"),
		expected:        decodeHexString(c, "3112e7dfba7f5571bf806c49c384dc025ddf537f3c37f5d7af7b98c5b809b5cdc9300816c25ef7dbda98856f08c8aff7db12d62d4f4dfc2cff3b7f7f043feebbf09751848b01dfba36d26f33162c0f57c15dba334093bc9b7a36a6a023c5a29100b2bd3406bf83e56d4e68896d70467db38228c82fdea9aeff1574c34a99e134"),
	})
}

func (s *drbgSuite) TestHash106_SHA512_256_10(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "b0a0e3d75f5d91dcea7e53f283f0f613075878c654925948c15531fb97016e8b"),
		nonce:           decodeHexString(c, "2eaa61a0624b32c1ad8b0ab1f6d9b96e"),
		personalization: decodeHexString(c, "f3b8d9d83f8b212c84442cc604fb4e6475a8e92e2ea1cc38fb8990da9d8af148"),
		expected:        decodeHexString(c, "4434a9db8500c93fa9bb921733c6f2dcd5489830411af3e00a2374e958ec759608ff0c72cabe91dad49c6a8f3d89cf426e42dcb74a279064fa8747eb387fcdf513f658d91b4a9ef103fe02c35d879c9a07cbad40b0dd26ac29c67416492f8711bd391d34cef8f242f0a3ca9c421cc2129d609dbadcbb9a6870aaa5079870ab34"),
	})
}

func (s *drbgSuite) TestHash106_SHA512_256_11(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "9a54bc2e5a90360029b9fea13a5336f61c437a939318d0006f07269f0276f86f"),
		nonce:           decodeHexString(c, "76abe2c9ef42157a84657584e86ac70e"),
		personalization: decodeHexString(c, "556f13f8ab3f6650a67625118cfe5eae4c0a341c06ea923172eacc779896b18e"),
		expected:        decodeHexString(c, "1c972c4979ea6f14f39c8539a1ba71e37fe8fa37af64a415bf7d67f55125a4ffab8c7e89643299d71298c1737252e670a898af1c687cec44ff6a224b9ad5718deed65f1ea30a59ce3b7495e7e93f3d7abe9c137cb48f848acea34cd72573a44fac2889027aa4b055f73e40a0aa1a5935990770ba1b69c450deaa9c811df5a6e3"),
	})
}

func (s *drbgSuite) TestHash106_SHA512_256_12(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "42710e2a84f8f1d6a31e37e0bbdbcedded32384b6b4d375ea1cf83c77364b983"),
		nonce:           decodeHexString(c, "1a79de4edc07936df71a9bd75b03a680"),
		personalization: decodeHexString(c, "e61d835e4f11b75c98918f21b9055a5bbc03e30cf61bb155f9d8b5671f16152e"),
		expected:        decodeHexString(c, "61dc4d2b522e1c1b5183896910302c43f3233d0f4d615250865ae13ddb525e4d32091e832e8ac9c3b21ad0829b7d22a092c9660f437542ac0f5d677ac7c70712a8073696f96264daa0d600f9c1c49edf79c03f2c7a2279ffa1efb1e05603df367ab435791af7ae2b15ba3531540c5a57e00bc5d20f699251cca26acfa2c10e1f"),
	})
}

func (s *drbgSuite) TestHash106_SHA512_256_13(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d242a4324a6769c5a0e4877166fd8fec89a5cf2707bb6556cb30805f003927cb"),
		nonce:           decodeHexString(c, "dee5f4c2e66d90f90217cd138d5946ab"),
		personalization: decodeHexString(c, "bb95bb17629b0611cf2ca41b8762f0efcf3795401bca5b5770598982f2218812"),
		expected:        decodeHexString(c, "bd331c3416fabc12e29d69fa497d42038c42b17c1a2eb717cffc6bed960ba03fe156b0cdc83d5bc97cd4013e8e04d2a2588fa5064449aa9829abd64ccb5c798f597991e9d04feb5c80c09feb48247f421cc3953247662a98a4cc9b48250da4c4eea6fbfc8a5ca664c94c4a37445863787ceeb112b25fe17ddea6822464475632"),
	})
}

func (s *drbgSuite) TestHash106_SHA512_256_14(c *C) {
	s.testHash106_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "38c054fd0b1218674700518ddd07985cc9bc7586bb7453daf0e4c0a1e5b90dd5"),
		nonce:           decodeHexString(c, "704e8e29c7aac1d8cbe97bd7305f8cb3"),
		personalization: decodeHexString(c, "631c5d0240b8d9800211ee6c97a5ae77405a354ac25705f22d405e17a52109cb"),
		expected:        decodeHexString(c, "9ee855e661d4293fdd7353492c711b39625ead90849ae5808b1f67c55cabe17ae13f0f18c0954341d6a2d24b899785642c0b29bb1b81fe098a17f8701e8820cacf6c00a8dab2e96e7f8593e188aae48385ede7bb5ed5ffa3f19053663383d666d38eea377d121e0b55ee58ee8fbf1e49c42a4d3d48fb0c9247c6b94c6539f4cf"),
	})
}

func (s *drbgSuite) testHash108_SHA512_256(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHash108_SHA512_256_0(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "977bad794d6a66f653391048a93fd5487ae87d5786eb3660b3242f9745196945"),
		nonce:           decodeHexString(c, "2da69e3c2ad6113fb856e64a9952f59b"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3b668c087681b0754e11cf961586916a33d94241e30590c54cff103eb8d5249305b4f5d5f2caca1f2917d76dbc88b6b7c5d7fdf81c4d2335e4bec48ab762dc6071a445bdce662723f9163162719892626ea64db5e5a679eae9e7ead61a4ee68548476807e274e916b78e31b3f24358d0f85b55d3799cd004c52b3f072fe513e6"),
	})
}

func (s *drbgSuite) TestHash108_SHA512_256_1(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "6ff27c10e8a5d50a44635f2c8523d5be10119ba9ca91138812da510dc53c3df9"),
		nonce:           decodeHexString(c, "4f9e28d517e4c9fe2d80ef045415a5db"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dd4683e3a61712a3f9a5022fd85fa721047461c3f14594cb26e582159c5da63b6a1feb35bc2d5ad0e91d6753afb88872b0a7452a794324bce76caec058b49dcd1bcff66650ab4351d28bc9f27470f49ff0624cb887307a73a53b36ac538efe7ccbf668452d554f5bf29b5eecfb239f65b4f93f7ec170b1bdd4d702819d1bb08d"),
	})
}

func (s *drbgSuite) TestHash108_SHA512_256_2(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e281e4ca50cef54b78023f0216811c8e496c283f8129b67b0138a721ab9d4c29"),
		nonce:           decodeHexString(c, "3aafb1ecd651aa6af196a5027889dfb0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "dfbc79df8f637f2a5700ad6b909ce181d57d5a77ea6dc57345bd81c2c3abe17698ba449756648d0374f3eaba4330061a9c0fcae19c0cefae6c4117f17c4b4905dd21b279c927fd98eff97a2fc4d8c17b2ff161f0bccb8dab8b8886068d17aec68ffd8dea073ec13564e20c405a15fee13623adfd27cdd7aaf2a445e636785052"),
	})
}

func (s *drbgSuite) TestHash108_SHA512_256_3(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "97e7a9d8590a7f6d2091bd6572d47114dea68c15210d696425ba7ca6a8a0befb"),
		nonce:           decodeHexString(c, "592c5ec696188a36c377709e9f403979"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "5846dc2fd66a0d8c90d0d539c175019eff89c13e8a13924f71db344196a4ae1f42d86ffe9ba8b6919b68608ea89a8a2dca19d2d0ff27fc35e5210d0dde04fdfad4cb5d3d9910312df4daac2b9a072d1002e95b0c062bb7b9423c4402bf7b2a2872b50abf2e1e9a2341645ab18ee60290d3b8ef309fb43aee97ac1a791dc49ebe"),
	})
}

func (s *drbgSuite) TestHash108_SHA512_256_4(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "fe2f9a2dcf2d3676f9182343ca2bc9778d391d9fd4dba746bef150a3c64d0312"),
		nonce:           decodeHexString(c, "1c17ff1e271f7ec1dd46a027eb762c24"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "9007fab4989a4e950c746ec716dd16df19ed62530d3926a363660bf3ee321d86ee698510383bdd65a5e8e0572c41e3f439ece3e8d9188469e086afb260cdd835aac531b449729eb05c4b333060ce2ace0b7db464fd6e6227b4d0e2b0458b8cc64e4a4c60e1c9976cd2ab4bff3427f3d4da8ca3e79f6f02262a48bc6b2d0e241f"),
	})
}

func (s *drbgSuite) TestHash108_SHA512_256_5(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "0659dfd417ff136896c1bb6b2adc25eebc70913754f764cd1fd5d6d00403cf1b"),
		nonce:           decodeHexString(c, "4d85548cbb9f647b60dcb8d28c57a0a2"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "123a082d2228a4371bfd8666d83cd5d4d2d3d140dde50c8e0a81c725ea38145d4cbe27d96abe618594812fcd291523ba4e15f60a19d7e19296076a0ea082ea082639579270b2751d87d1636df08b38f542891024a166b2927335ed5d98c468fee4957867bccf2e5b03d631a7c30d67e4730503a87010608a4b76d10f0c789719"),
	})
}

func (s *drbgSuite) TestHash108_SHA512_256_6(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "c56e1588c753cbbd1f7b4ea9caab01e9e2326b194f73a2da7a50eb1006ec9cf4"),
		nonce:           decodeHexString(c, "b7d1a7edf25ad51ec8806d85152aaa21"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "e76e079021c9403d2dc1e1d1c116948b34aeb08ce8a11fd50ec698e0925570170956febc0a50be7f08fc175e27d989e11802403ddfd9d5354391fa716cc83fab6a26b364aef36d810b8822e76d4474722df58590148a0ee798082a7c22f3a8e25f8e30d3f5b8189f1e93ba8493f395ab2fcb42fdc6450af3865d23f734004c51"),
	})
}

func (s *drbgSuite) TestHash108_SHA512_256_7(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "8491ecb34bb773da280dcc16a53d1ad06ec448b1cb07989e7391ce231941309a"),
		nonce:           decodeHexString(c, "5ea5d2bcda790c24e14e8974fb4dfcbd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "19038826a6ccd215b4a65e99ae00449d5591313e9fb0232c071aefa2967ba057ffb593dc1017b18c80cca3a0e11d9f380181e0d9639cb353a668d53ad090eefdd7b7d1f6957c18ec53f4d790c6c30903a8a3b6d7be0e113fb068a15c089d6178374d5f624aa85b9033f15decd454be569ced0b6e660240d70bc75bbfd6908c13"),
	})
}

func (s *drbgSuite) TestHash108_SHA512_256_8(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "48badb5d8130d9bcef7d56f70213455887fbbd9b6fc52eff7f1fce3e1686b342"),
		nonce:           decodeHexString(c, "9d43bb414ce755be3dcc04016a8c9870"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "a64b5f39f00ee23fd9d95613993ce5f69c1f55c466e0434537b2c3829653f59f0a35742084f7fef22f24f642b2912fe2285eb50add5fa76e9cb96d09a482776ea8f82886d547864a0cf5e397481192a3fdf11a8a1bce892db86b7e9d15a7ae8a12607410203fc787c92b9273fa522ea7191af0593815debc41bfcbe465df0790"),
	})
}

func (s *drbgSuite) TestHash108_SHA512_256_9(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "46be19b1b70166e32c2b1704387586c3c50a79749e4f9bf3f2966403190156f8"),
		nonce:           decodeHexString(c, "4e706f2158e038b19dab6c3bd8137868"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "3c96cd98e0beb49b8b88dea365cf70af8fdcf9c1080d5212fedd1cdda17c9d008425acd60254c21c411075164bf50d0432f3b984e5be6cac47dfa4efa802f15432ccc2c2630cb0a126c33d6a2610c6631e6dd1f1745139ecdfec8563fffed93afe2f35b5435fb600d451830d391c924ebdb7eb233b1ea8df38a658e3e3fb1f14"),
	})
}

func (s *drbgSuite) TestHash108_SHA512_256_10(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d48b7cad74849bec068e7743af6cf710685cb4e1f2a8b7d7267a12ccbf3c3706"),
		nonce:           decodeHexString(c, "e61fac110b7beddf3d9b6a0956991600"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "755835306c0c0b799cdfb7a6daee20d560ce3b5baf7bc6d92d60eae60f653fe820ab6896bf18aaa52b9308c9afd940ed447cdb7e52248597eab7cdcc3bf9b03b078874067a4a4c58e548797691f687db6b12aa61b85d70eb6293d6e7d0b12f906e85051183152427a8f6aeb3f4f27fbc77dfbc6b27939e4b94663f0f120ba091"),
	})
}

func (s *drbgSuite) TestHash108_SHA512_256_11(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e71e6ef37a8a6b5b56941634ed456c1a36f0168dbb4e13c21f89e7ab1eb843e4"),
		nonce:           decodeHexString(c, "2bdf609ba15aa5ee348c3a18253546dd"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "21caf52eea10dd1d5182f003b2161e5608677721dc926ec45a5c3a13640b2459809a5eadd7f10f314a0b1380d5cfd18bec41fb9a6f3082e6be19f0ec36acd640d1013f62ddb74af2e4af37c7b6c50a1d993612dcd1c1a3b008dbf7efd80a2987050a33b0c5e0eeb51d9bd42c3782a7f541a4d228b55a2f2ecf54bc72d2cac46d"),
	})
}

func (s *drbgSuite) TestHash108_SHA512_256_12(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "a6ded3a009274d1aede6412ab7a2383bc11dc302a82309fa6e4a25159635e4e7"),
		nonce:           decodeHexString(c, "42ba80e06774c7355d245b103abd8dff"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "14e43d4cf7fc8efc26c36bf74b42381a5f6410fde51e3d37c8dcaa7d2cb8fa1402ed73b7f3b938c7cfdb13741557e3fa45851fe54e35a594ba0c07bae01aa2bd3a667813682d4b7a1855c48d8ac7ec0a1129463e8659744fe16196af806a305bec9e8c26682f3d4c4e710f380fc6b998a0de036b042058eb49b51da561245e1a"),
	})
}

func (s *drbgSuite) TestHash108_SHA512_256_13(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "01097e91d496e7154abfafb70c4a1813d5a4c761fbdba36f097448f6c1920b12"),
		nonce:           decodeHexString(c, "e3a1b6a347bbe21c7204ac04e5499866"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "ab4336414fa90466d90b7e62b6d1aa8da7b590b6e95a1ed298d3300bd1f1fa5221225d34145b2eedd00ecc25813661d8ad43665d9f32d11a4ab287db83618006ce7936f559c9376fcd168d3c7cab6a719d1fdb2857747a9173bf3e644049d4e8cc82d49a38957d5b6e84c316784197507b883b91ec60b2bced85c53d8de4af17"),
	})
}

func (s *drbgSuite) TestHash108_SHA512_256_14(c *C) {
	s.testHash108_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "043872fa9f0c4d97e2c6824b778a4fb0debae214d3358a5aa01c0092c9dab6a1"),
		nonce:           decodeHexString(c, "0fc8d529a37083c2efe84aba8c8abbc0"),
		personalization: decodeHexString(c, ""),
		expected:        decodeHexString(c, "22e8eb6b4d11657a66cba93f89b519bcce87a9bfa5ee22cd3cfef6180cb8ca842e8d408257b8140fabbf1dd65085ae62fb8b1d2a679dc0bb0a82ecd3b8bbc05782a20a6345554a1f5467e9811e0fce41a786c805ce2882f8b4d972b9a37eedbf828a381d34bab95efc47233846f8b5c701563033253323eda41effad5fe37d3a"),
	})
}

func (s *drbgSuite) testHash110_SHA512_256(c *C, data *testData) {
	s.testHash(c, crypto.SHA512_256, data)
}

func (s *drbgSuite) TestHash110_SHA512_256_0(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "36bdafb62d8d85c6c1dfc1e74e618967379d8b2894cc91cec2d63e59eea27454"),
		nonce:           decodeHexString(c, "0e917bee109086aec697e039a2649da0"),
		personalization: decodeHexString(c, "7934847193396c925e3527a3be05f8f847cbdd6a97450c421af61e214590f433"),
		expected:        decodeHexString(c, "c89c518bf530228c5286c0e8080c54d3800848b6fce01c5ff5e48123c5da6470b54597f08c215d27622f0e3c141088b4dea13042a22ee9f56f9cecb44077b651da382d996f7822878b57124938879cf5f95dd0ca277d132a74b1f0fc4d3264cc2883fad8d2dc5525b1e13538dbc7dd159e56b445ee8edb307adb7be2fbc80aa1"),
	})
}

func (s *drbgSuite) TestHash110_SHA512_256_1(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "6a59054b7ac00a84cb8a7b6a2c94f2392602be03a964d46084786e59e3c39351"),
		nonce:           decodeHexString(c, "2e46a12ecb7377212e7af1f6dfd0a5af"),
		personalization: decodeHexString(c, "d2fe3aa0e0835ea3d35fdac43990a9996f6a90a3d672d5210b798b96620fdffd"),
		expected:        decodeHexString(c, "67c78059d7da65a67642d78c8a78066ef6429b9410f9c6225a10d59f35d0355dc1d0b278f36e54654bc39d0264284338e11e0f4d2f320e02d18c79f4c12e5f6c06d0123312ce031657308baeaf370aa6eb0706bb75de2d40f10eb3667d13f874ad30bfbac42120ed319e78056b202b19e002ef5e07861bc9dae8f22f606ad5d0"),
	})
}

func (s *drbgSuite) TestHash110_SHA512_256_2(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "e39eeee22c0cf449605bb65f595a230a93081fe2e9c1c5dbbc9c76ffda60d469"),
		nonce:           decodeHexString(c, "e438292cc51a948e95de47b2b900c04c"),
		personalization: decodeHexString(c, "408f5fd16a3f69e173f8bb03b769bdca5da2c7ea23523de2a1fd3181af028ee2"),
		expected:        decodeHexString(c, "64f34c811fdbe73192a8c4e176423e05d8003e7727566917b5fe51e32174ce3ba9ced9aad03720905688501b640ff4b74aa6d59e50fb69f73b31c23ff86d237d16b3550c8b96f426125406d7e551b8e9dc7d5cf3de62851c17931429b83893dd1dc1601eb1a75f977e3913fcfc093743a65dc953685d63d3a9f0aa565735ffbf"),
	})
}

func (s *drbgSuite) TestHash110_SHA512_256_3(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "878b3976dd608df84e9f052d4334e8c8509d2216bb700029a99a96d169be21a7"),
		nonce:           decodeHexString(c, "bca9170bf78e85805fc6ea2d3b98c227"),
		personalization: decodeHexString(c, "209da5e2d50581d0a52aca020a2f55b63c693801de19e43c7c181761ffbc16bd"),
		expected:        decodeHexString(c, "6a5c5178b56f9c4c7c183f32ba6ea8981d575beb7fdc71ac19697ce58bceecb72fe25428be950adde5ce468d16c459dd7a0f1dc646cf5f53d193df030e5abeddc807b2e888c1adaf74f2a7ee469b82235772c6dc0e737da07779046064d0edfc21891d365afd1c6f0a797907d319f48797a69ca45310e888862e1a4efc36819e"),
	})
}

func (s *drbgSuite) TestHash110_SHA512_256_4(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "a703f570ffb78938dd155b0cd100afee6c26ed97c2675125c7cbb7dee598af79"),
		nonce:           decodeHexString(c, "ea5e00c45ffcc23ae5afedc3e7c1894b"),
		personalization: decodeHexString(c, "bdaf2d9baa9b8d80aad7afae5eb38232ffc7a726900b4f33d7e4e31f7bfd5018"),
		expected:        decodeHexString(c, "46c088ca13d596069732cf233a625e9541a98df14d08f2f58b9365817335698a287edcf26db955d096ba43cefd37b4de4fea1b2bbf9c4fd0dd9c34d9d5c7bb2029453a455031bc69142186151524ae8e8c1114c5074a4751dea96c7bdffe4747c63ccf0eeed6732981fac6b28288d414b4ffa08ffbbeace515251e5cee0a6b7f"),
	})
}

func (s *drbgSuite) TestHash110_SHA512_256_5(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "d2a8d2a92b5e98080e38fc5c86e3e8950a71993dcf8b1c893e0adb64abf2e505"),
		nonce:           decodeHexString(c, "ddd08bf7aa7a03d0af0d08a0f6a91d55"),
		personalization: decodeHexString(c, "a6a3697a569825871d1681ca5d6c7e3ef7eb927c49738358bc116e2d0b65fe61"),
		expected:        decodeHexString(c, "347e66e4ed7cfa5255275d5d23312489562f7d83e024e921344223945c1135621e09f52cab7a6425474c40c4cce594257451140d31f09fa3e740cdc17884aa01d251976e7c8f9671e26f8a9de27d163c951a970e2ec471324a77d433303b5192ecb5776d2f93f3741c0911be509e7c868933e1494e68e997f0758cf364b5a8d0"),
	})
}

func (s *drbgSuite) TestHash110_SHA512_256_6(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "4c22707f97a09ddbda3ffc43e2dc41e2d8a91ea751c327107b9addb62a2f692f"),
		nonce:           decodeHexString(c, "3cb7afa9053bf6bb6dc98b7b31618405"),
		personalization: decodeHexString(c, "b1dd737b2c437ba426810c0263d10992ca9dfb0efc8fe5f64a2ccd8f2831c25c"),
		expected:        decodeHexString(c, "2f0712ed85a3a7ee5f940e37ef1bb571bd6701c98c45ae652be0f88895c9372001eac4ae4c728da07573b7cfd3443ff18ca0e2d7f9798457b5133fed02f25526accf90ea69eb57eb582461106a04b2f9175ec301ffb5eeaa392d45e250016b1c64a466c6215febe159bcb15ef702a98514d92a80f4b8a9f8b5835ce1d07ce240"),
	})
}

func (s *drbgSuite) TestHash110_SHA512_256_7(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "c5990752da659ae294056723ba56ea93a82bd152530d018b5b58b65c65628605"),
		nonce:           decodeHexString(c, "b068f59c108526820c5d490b312a4686"),
		personalization: decodeHexString(c, "7d032fad9355aa9c73ad6d80b2a24ff293d9bc7419189088a60fdfe57df59f6d"),
		expected:        decodeHexString(c, "e4f4d01ab06caa4430628fd227b24581b3c0f33ae51eb6a5b4ac42aeaed548d5e44c286f1ee54a45cda80dc3a16e8ef739861d40711e5526191dffcfd6082fd38392c8ad5525dd3c4bd00db00086b48b459c1188cdfdbd4fe5f0ce8dec7dc11ee0238a813db043e1c73de82abe21396f86d4d11495302e64a487da654013b62f"),
	})
}

func (s *drbgSuite) TestHash110_SHA512_256_8(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "aaf44678e88d8e7a98da178d806d543dfb77593f2097c1aeb254cf742c59b765"),
		nonce:           decodeHexString(c, "0a971c8bb64fcb80edd392656d322beb"),
		personalization: decodeHexString(c, "88fcf865da483f1feae2299ba3783ed417ef14671d4163d5c85652ebe44d1f29"),
		expected:        decodeHexString(c, "45d1acf678c646e15a9277a453b77afdeeb7214c49c29aa8e6e8b849498880028f7e764ce1713e6771b633c3753cdff943b96366d5b0f88d8c41369b352f6e0f8939b37b90fa79195677c555ad48aa0d40050ab35fd797758bfb20757d26f44d5b610ef0c0172546d6365f7a861c629dc8fd9316b04654ce5e309bbbb5578627"),
	})
}

func (s *drbgSuite) TestHash110_SHA512_256_9(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "7f8cf3f0c0ba8c3a8b72c6442f486df6121431f9622f2359377ba05329d61c18"),
		nonce:           decodeHexString(c, "0768cea6f0fffa07bf57a9d99edb900e"),
		personalization: decodeHexString(c, "80e5a3f74e89a75196069f8b90254b3809e8e9695c70624aa6fd2b65bc7932aa"),
		expected:        decodeHexString(c, "0e793e7a940a7d5ec3168b7eec9712197fba8d330cf4e0327ee77009d9ba6c60f3b75586ed07fc56f4b2e56834012791a9f34cab2d9284644a635026244f3dc6798414f3f9ba743ebd3eebe8f5e7a2b4339730e52cb001a48015398a89f5cd802e8da1bed1b93135bba8f0b1f71ba4e1ed3fcb6d8be05102e2c53fc0e8f0daa5"),
	})
}

func (s *drbgSuite) TestHash110_SHA512_256_10(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "5f483698dfeae3d00e4dd1a8c5d1055f9faa9c37b76c7f6b427d4ce1504e8970"),
		nonce:           decodeHexString(c, "fd6abb49f9982d7462c1a52231820301"),
		personalization: decodeHexString(c, "24308ba52c488b388cd3ed49277fe3ed7f4023f1ab2d4e839da7e3e2a7595c23"),
		expected:        decodeHexString(c, "b341031f9e030db833489f45c065c9a106abff89b43eb0112cd8ce2825b6cf25a9e8d58c969310c1bf9d6c849e133e44419c5d23d673b897dfb7efdc688fdbc779b56f714d8434b5cd12ca5a657e3c0450908425612e230a9235eadeb31d4202f02b38f8eda36b4135bb8a869eafe9ca77410adba8089ba2b305735e262633b2"),
	})
}

func (s *drbgSuite) TestHash110_SHA512_256_11(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "023a4f36a435e33b4b6b6d3c484a165ebc61e9090245ff07fa59a363c29d5115"),
		nonce:           decodeHexString(c, "07309a34c4749f791e2f17ddf711ea93"),
		personalization: decodeHexString(c, "0d20c4c4be9883e1e251f3075193497d55c9bea63db4d1b87502e037a99abe61"),
		expected:        decodeHexString(c, "97e85682a9a3260f958d457d6adda086902d65415dc9716f1c8f54c029e5608c15e0efdc5729cba64b373c4dd811b156f7730439a4bb3564bf64c9d5ab170d4503dddc82b5572489898e9d5230ac318676327a983b58a36cc28cf7fd082d63dbb4bce99ce3e949488a98a3aac576d83844abb41089be54056b41e2872bedd0bf"),
	})
}

func (s *drbgSuite) TestHash110_SHA512_256_12(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "156a743c0ae8e39ce81b7dbc3c756256aab68d488e74c857e630b6ecae78c853"),
		nonce:           decodeHexString(c, "e9ea051ab34490e29779b79991981464"),
		personalization: decodeHexString(c, "4ed22791055df7800f153f2f0c9187629d6bb1df4cd5c5ae738427a40238241b"),
		expected:        decodeHexString(c, "ae7aa0c1fb0b2c44775bfb5eb357104e308fe3e4ac21c8b0dbcf0810c815bf59473f3d252f4b469607398421ffd96bc116fdb09aa3116678d344f53b44230198cd1d87cbf3f82e68a3f7890487f93a7c8058d2611f5b952ef869fafa542b3006b833bbd27fc5a6115702778d0c87e7f76d96fe2164d95c1bb29e15360920480a"),
	})
}

func (s *drbgSuite) TestHash110_SHA512_256_13(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "924140b7374a855269956d3300dfdaa74f7427815fe8930d2699ad9717f12615"),
		nonce:           decodeHexString(c, "1a320adc8d60f29ea9debffc2d4337ee"),
		personalization: decodeHexString(c, "a1005683468a9e0443df0fc9170f80c950831d5c7d41f3161b60be684248dff8"),
		expected:        decodeHexString(c, "6e6d4af61a5c67b7265c74e2da280ce8617adaa90fbc64fd886de42a5107dadc6eb81f76fe02e8bdd2aec2c6cae4ccd11954b5033f20303cc0a301ead5b33e94ef1d95173bf1598db7aea0087a92f838b1e18fe95e738b4da7f81e91a0060fdf2201aaf4c9fe2679943773602a0abdeb784c38538b3a47f47414086b3d299ce7"),
	})
}

func (s *drbgSuite) TestHash110_SHA512_256_14(c *C) {
	s.testHash110_SHA512_256(c, &testData{
		entropyInput:    decodeHexString(c, "5c8a9f7e1416be2aec921eb7e0534453ac6689deb0e569011ae6ccf4375acbce"),
		nonce:           decodeHexString(c, "b2328815495d926dc8ff075d5834bc20"),
		personalization: decodeHexString(c, "4c539b94823c6c7883b071ac395203bfb5117b6f9d5db7cf4063132e6a2a3cb8"),
		expected:        decodeHexString(c, "4f6035946d4305290485c7aea10bbceb99b841770dbf5529e31ad51b0ce138344ac0b193a5074234adab8887a51d9448a2cc637a543372ed93885975b8de342c6a12a1ca8f3d053ced1dd2c7d6a3fabf6ea7860071c035f0fd54ee5775ae3a5d457d4af9e034ed337d79e9fd52c2ad051388dda50aa78d37403f33d52d30f6be"),
	})
}

func (s *drbgSuite) testHashGenerate1_SHA1(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHashGenerate1_SHA1_0(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "c3ef82ce241f02e4298b118ca4f16225"),
		nonce:           decodeHexString(c, "15e32abbae6b7433"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2b790052f09b364d4a8267a0a7de63b8"),
			decodeHexString(c, "2ee0819a671d07b5085cc46aa0e61b56"),
		},
		expected: decodeHexString(c, "5825fa1d1dc33c64cdc8690682eff06039e79508c3af48e880f8227d5f9aaa14b3bc76baee477ebbb5c45547134179223257525e8f3afefb78b59da032f1006d74c9831375a677eab3239c94ebe3f7fa"),
	})
}

func (s *drbgSuite) TestHashGenerate1_SHA1_1(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "4ba70743accd4319e11de0461d9a37aa"),
		nonce:           decodeHexString(c, "845e4a96462fb16a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c7deec6cb5049c34c8be42375afec6f0"),
			decodeHexString(c, "37af8411085b41d88ecf899ff2bb1325"),
		},
		expected: decodeHexString(c, "7b6dacba0f66f2a12071f9da43f75a61240df75a47dda16f474ed2cf0308f50794bf017cc6e6f018fa9fa1500748f7e0b36e62c62a8dc427f58c1f2c5aed10a4726d886ca12325ef0c566d5bc9a04ecf"),
	})
}

func (s *drbgSuite) TestHashGenerate1_SHA1_2(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ac3cd0ea3d26197cc9379b82bd8289ff"),
		nonce:           decodeHexString(c, "e363ff61741aab5e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c7c30f2a6e500b0bf946d021932bb124"),
			decodeHexString(c, "bcb40c373a4a9be606790e551737f06c"),
		},
		expected: decodeHexString(c, "15f49e7914fe0bce039b99060cc372ceb453282946579a47d9bfb61c5aed7a4da0dc77be7e7bc33b63d650f28490d92fb58725d519fad94492f712bd8193d094c865ccbd419625d5d27e249b1cc555cc"),
	})
}

func (s *drbgSuite) TestHashGenerate1_SHA1_3(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "eb51fe7bd72474659947b0ed5109be38"),
		nonce:           decodeHexString(c, "0a2aff93bfcc0722"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "94f6173ed7c36a63c4a95c914d0742b7"),
			decodeHexString(c, "6b11989148cb860407a3675a33798969"),
		},
		expected: decodeHexString(c, "a679a08a100ecc5250c33b9b1dcd9e20469b30316d0e0e4780ffe15c06c99c0440f7dbf04621215d3d5081201d4a10416a9138782c5692ed9eaedc99c7ccfb09ab0849381150145dc0e55a8fa8898068"),
	})
}

func (s *drbgSuite) TestHashGenerate1_SHA1_4(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "9cdb91a21b4fdcc410f960ceb7ac8ec8"),
		nonce:           decodeHexString(c, "9d01f73ae168ed6e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e1eb4bb2d080b1d3e95bc042ace94c68"),
			decodeHexString(c, "062dc866f414b951e3f61aa7fe6d1ffe"),
		},
		expected: decodeHexString(c, "bfb0077e995f49c403dc38297ee47b41938864d734b2e7b794e9bbf461a2a4a45f364d82a66b3730bc5c9902d7b5999f74554e59e454d658a86d4813b5e7609e03bc750c38cd52b36676057ed80bfd41"),
	})
}

func (s *drbgSuite) TestHashGenerate1_SHA1_5(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7dd2fffc51456dd47260395ddca60c8f"),
		nonce:           decodeHexString(c, "631e5b0ce84e3652"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cfc3ab0a51c3b0adb320fba6112ac856"),
			decodeHexString(c, "f5aaae47c823c04e6960dcc205fd77a3"),
		},
		expected: decodeHexString(c, "c6118f4689c7fccd5aeb468775807d39631f5b315f0c83b5d96fa6c2ebc0f95ef4414efe1c99ce71e62c4617dd1cc95777dddaa8258d065bf3af2adc679dd3d19d23ced6e2b4b47c856576f9697a5f42"),
	})
}

func (s *drbgSuite) TestHashGenerate1_SHA1_6(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7491cd165de84be1ce94f0bc28b7a01c"),
		nonce:           decodeHexString(c, "7de5f37fbd777526"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2c2eb193197be11fd96c6b4f8a56748e"),
			decodeHexString(c, "411d9f71e0f97e940650f4ca999fde5c"),
		},
		expected: decodeHexString(c, "dfd15d00e3693e89efffedd287af2f6f33004cb42b16b38b41a393548190f841dbcaddf67c410b79a9cf104ad1805e89e2c1a41a24053614d67e9567c1ac989db33d792d802455b17b174adbc9ded7b4"),
	})
}

func (s *drbgSuite) TestHashGenerate1_SHA1_7(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "14986734e419b647da59bad386a16cf9"),
		nonce:           decodeHexString(c, "c37c9bf5a4365123"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "58bb485852a867eb556c53e904c55939"),
			decodeHexString(c, "92fd0b39db4f98260399d5c12d744ad3"),
		},
		expected: decodeHexString(c, "81c7509fd3aa29f79e6ce6037ed4800317b74a6eab5c8ee15205d292bdab76d7bae62cb2c26c6bb95d66bc8d3b270e89f9e61b62818ebe27ffe49f3eb86ee5fcd492b7ee03ddca6dd333a3d9334fe2da"),
	})
}

func (s *drbgSuite) TestHashGenerate1_SHA1_8(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "29872460a7f13c18e68067a0fb8dd6c2"),
		nonce:           decodeHexString(c, "7d62e20aa71a945b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ebd987bd551b354bddc17414a26e1f08"),
			decodeHexString(c, "c2c0e53e61451ae17ff6a90c49b466d7"),
		},
		expected: decodeHexString(c, "95609822203263f92a40955a5619240e7409136334e31b956368b49bb855065172de3718c40483871b455d8e25f43423b991b3aa9bcf0e27b4509b45d8f7983bc054ed5ff1999fbb75f9e91bfeab8a6e"),
	})
}

func (s *drbgSuite) TestHashGenerate1_SHA1_9(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "bb0a1f9b84741b55384b89c055d50272"),
		nonce:           decodeHexString(c, "2586dfe6306db73d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "bcf6ee1eac1d2d3a7b960500f80c5328"),
			decodeHexString(c, "543fea5515ec0ea5d25d019bce973909"),
		},
		expected: decodeHexString(c, "9d88970a8076401fc132ecff782a2f6817e4829f6e874172ab3b991f46ff5319987dd6ae539fc2a3657f00480c7bb5e7dd6d1a12969e81a387a9ae43ab9c0d2826448c6ca9e9bf9ae0821a35c4e2f0bd"),
	})
}

func (s *drbgSuite) TestHashGenerate1_SHA1_10(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b9de6531312e4c7c6f492f943d74c2c3"),
		nonce:           decodeHexString(c, "ae15bdf3cd2086dc"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f40354918f5878ccb02e3829893035f5"),
			decodeHexString(c, "df587b0822e64918c2f4903a0f3e2e3b"),
		},
		expected: decodeHexString(c, "a7ab93cd9ffe246dd4e3dc55ba946eb2151d03d0dd2b6a812f8e3a2db19c7810fbf2b9513413141562aad7e57f8ddf7425702f6c1976dfcd821a715868cb6d436acf9708481bfa095454c8c6b81de62b"),
	})
}

func (s *drbgSuite) TestHashGenerate1_SHA1_11(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "70fdd37d3864be6992fbdb7855649fcc"),
		nonce:           decodeHexString(c, "9f6d994d1cdd270b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9e5a48c9b34289dcce947c37cf1a8db7"),
			decodeHexString(c, "a23dd58bf5fd187fc2a0636224388a3f"),
		},
		expected: decodeHexString(c, "bb89ab5854ede92ab6766db2db04a78cd03192ba64f957779d6a23221edbe86c1ab76ddd1af7406688fbebb8ad377bb499f66ec9672705d2fe30e8a2d5eed9b5da5c2c2fd1e059d06c84e3a4d046fc66"),
	})
}

func (s *drbgSuite) TestHashGenerate1_SHA1_12(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0e1834ca718e2ec89df66f767e31018b"),
		nonce:           decodeHexString(c, "b97757adf5158e82"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1b8f115dc9375400212e503376a90f6b"),
			decodeHexString(c, "b7b8a74d1db1ecb66c8a7f82ec55ec13"),
		},
		expected: decodeHexString(c, "a55d54fa57aa36456c64edf2a4bfc3a0458d20c00bd19b5dc971647eb46d282466c5ade26403f37af1906e57550bd41ed4e8848b485a122050c71ec1c59a28399ff07097ab2849cb0165fe6fa577f032"),
	})
}

func (s *drbgSuite) TestHashGenerate1_SHA1_13(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "49666d8b26cf630f37eab9089eabbae2"),
		nonce:           decodeHexString(c, "85ead758fa67a29a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "7702e397a447472df6aba9b322368aee"),
			decodeHexString(c, "d1afea4c22369333a7b08299ae3d44b1"),
		},
		expected: decodeHexString(c, "63854c32a58054e7ddb0c0c39b8e54a9de6df4a9d8b6324452cf9d022319f6b7e30c7f6c75019a0f37b74b8d1cb19b0dd2814de6b3668fc79c34222fffafbaca9489413d0e29f8b62d7594274371dd90"),
	})
}

func (s *drbgSuite) TestHashGenerate1_SHA1_14(c *C) {
	s.testHashGenerate1_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "a3a0cfee0a1fcc885583615d2d4b5952"),
		nonce:           decodeHexString(c, "e7de2c6ffbf1fca0"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "93dc424bd0d266879601745a23317141"),
			decodeHexString(c, "a17321015d327c5dc0bc1e130aad81ee"),
		},
		expected: decodeHexString(c, "f682834b5b492e09ff8e0f2c80683b032a3b262d16bc609c550dc0e74a4b7d8ebc0e3b8f2c9970d90aec9a82497dded20422b17b9e3cc3bca771cbe717ddaed5a7a6ae2601c7f765eaa719b71624e83b"),
	})
}

func (s *drbgSuite) testHashGenerate3_SHA1(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHashGenerate3_SHA1_0(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6466e1799a68012379631b3aae41f59b"),
		nonce:           decodeHexString(c, "6b0c61269f67c576"),
		personalization: decodeHexString(c, "cc936b87c8c8c1ab85dde0ad2e9242b4"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d1033ac553ef08f22fd38f12b49b45bc"),
			decodeHexString(c, "f004ba01f51455430d84362e376eb775"),
		},
		expected: decodeHexString(c, "5d675d1e92490952703c194194e1b061b6ec4e219dc2e1edaa891ef2d1b7ed050a06342d3c095011eb339f198519779b01ab1a580bd2e34d6cf4e47c1befe0c7dc37b4aafb31128fa396267f3732095a"),
	})
}

func (s *drbgSuite) TestHashGenerate3_SHA1_1(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7ed284c8596b6f0107de3b4b95cd9114"),
		nonce:           decodeHexString(c, "69116c8a073bf4f4"),
		personalization: decodeHexString(c, "af668eb65b0f4df2ed49b37c842b272e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f0ddc45922363f40271e7a01ed67ba84"),
			decodeHexString(c, "c2da95cbfefd2ac7395cf989711c1350"),
		},
		expected: decodeHexString(c, "306f553077034ec2a86a64cdf34387c59769aae149d8cdb0041a5c2e6df9dd1e00ef0898179d6c6bf02b2c42b4a898f48cdd9ba4ad2b99fb133c5ace4249a67bc30e6452495c186244dc5ac6928b1ff3"),
	})
}

func (s *drbgSuite) TestHashGenerate3_SHA1_2(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "48fefe997cef3ba2b73e76aaf003590a"),
		nonce:           decodeHexString(c, "19db21e0d05d99b9"),
		personalization: decodeHexString(c, "d81759f6a2892c5b2d51b85f94d89872"),
		additionalInput: [2][]byte{
			decodeHexString(c, "700842841573e6aefc1fcf20aa877416"),
			decodeHexString(c, "a91efe1415ecfee71df068a16baf034d"),
		},
		expected: decodeHexString(c, "e6bed78be09215d9d1beb0b8b0889e677962a61bf901df09ad8e36ceec052588b57cdd445ce5a2c57fd40b7432860fa3c1c97847d790abd5d704eefc12ff1636a6c999c4dae9400a7c968e84bc7ec3e6"),
	})
}

func (s *drbgSuite) TestHashGenerate3_SHA1_3(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "31c4900e6e37250a80db3b59cbaa10ee"),
		nonce:           decodeHexString(c, "8e194c494a419d9e"),
		personalization: decodeHexString(c, "121674898e64775d344f022ea692d9e7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "06620c1998de3331b92f2409e8635861"),
			decodeHexString(c, "e0bc045344e45927364b27d9fca2c53f"),
		},
		expected: decodeHexString(c, "1b6e68ec91ba9708562aaf2ce6e3b499f42a1b72b14e5c20a88e373b85cbffc924da24b4c08836b7a84927064eb0cc824f2dfa0f5aa8d480cbbf7ca7508d96370d92a59f8137ea39167a37da7f75c89b"),
	})
}

func (s *drbgSuite) TestHashGenerate3_SHA1_4(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "e8b41a5af5c4515282f3078688be48a2"),
		nonce:           decodeHexString(c, "4c3b5a559ceca51d"),
		personalization: decodeHexString(c, "cf1ad8f0839817061ba534e004f61311"),
		additionalInput: [2][]byte{
			decodeHexString(c, "3c783aa5e096f5305d84aaef0de0865e"),
			decodeHexString(c, "62271e8341725fadfc41ef136492c6b3"),
		},
		expected: decodeHexString(c, "48a11729d198f908269065bc852d062b9332047535c04d8c0ad0b6b99e9a90e686dfca344df68c7bb72ecbc739634519077fa6f1f00e8df4e3712cfa79ef4d2d7e950085994bd553502f673f8ffec17a"),
	})
}

func (s *drbgSuite) TestHashGenerate3_SHA1_5(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "e900d8f9803f7fdeb4fe5222d99ce8b5"),
		nonce:           decodeHexString(c, "a5412a73d59ffd2f"),
		personalization: decodeHexString(c, "10523f20a690465f7339f66f8d91f9af"),
		additionalInput: [2][]byte{
			decodeHexString(c, "754fb2b62ce1791c0a1731eca8d006dc"),
			decodeHexString(c, "66a8fa0727f4f880afd4006574a51bd8"),
		},
		expected: decodeHexString(c, "a72c09f23de8cdab9d6067b8ee0dbcbba97306ad711860f7958d4c5889e61549e30fea415abcb6211d0ebddd27da0ca1104a4c585486ea495edea87257d2b75462504538f21d1803f2679128f8fdab7a"),
	})
}

func (s *drbgSuite) TestHashGenerate3_SHA1_6(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "395b1da917188371adbb0d5027dfc2d8"),
		nonce:           decodeHexString(c, "7739dd160f53bf02"),
		personalization: decodeHexString(c, "3e864c1287dc15ee2c585faed12226c5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b406d8b89f3d602560257fa4760316e1"),
			decodeHexString(c, "94b72e355fd12a0834cd2448f4343d16"),
		},
		expected: decodeHexString(c, "e0a3a7c36b9461a03f75356e588b6434c1ea08d9168358c8287e7a3d99fc15530e1561d312c741df9e8fac58299ebde18fc90ad8a952c8984ef31dcdc9a6023d5edb4bc393b379feb9a918898d8c468e"),
	})
}

func (s *drbgSuite) TestHashGenerate3_SHA1_7(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0acd1da3cfebd6c66d4f2ac36aec6dee"),
		nonce:           decodeHexString(c, "fba4c200ff691bcc"),
		personalization: decodeHexString(c, "6afca0034dbcf632c815e33e69f73340"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0f3deadddf2c53bfeedb47fed10cf4e3"),
			decodeHexString(c, "326ed610fe038f5f168cf7ee4a1ef38e"),
		},
		expected: decodeHexString(c, "a65ef722c91721baf5e609ea129a3211d05c53677a576ac5552e0d032ca17228a1a6cedc41a06e5add7d9c44c41110afdf5fa27f9cd4b4fd1b65c7a346c39fc3c22d1e042e396ae19628b2ee4f3cb5d9"),
	})
}

func (s *drbgSuite) TestHashGenerate3_SHA1_8(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "e9492967a06e84c80bd049fe9f2d08a7"),
		nonce:           decodeHexString(c, "287d30dc972ffc8c"),
		personalization: decodeHexString(c, "fa60a894d9955fd14d368aefcbe50e67"),
		additionalInput: [2][]byte{
			decodeHexString(c, "bae9d792a1d667fadbeefe98d645780e"),
			decodeHexString(c, "418202160d92cb59d1e7378838643c1e"),
		},
		expected: decodeHexString(c, "a6dbefeaf6f859d7ac4137af798caa8fbb4fa2fbe496986cdc8c86babc72b1655e98e52c40f66681c4d4cb1319b3cfa97da73333109ce414ce41c93b1e62767fd26a757eb82dce2d4454f8e9dffb791f"),
	})
}

func (s *drbgSuite) TestHashGenerate3_SHA1_9(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "3a655b77527c1524aa13c71a3d9e1916"),
		nonce:           decodeHexString(c, "6612c746e4bcc0ef"),
		personalization: decodeHexString(c, "8a1c402e8abc71ff11d7e4738f14b00f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "39af3ce99eb8e9ea5964310c27c50673"),
			decodeHexString(c, "b3353bf522fdf8ca87e840665db73a1e"),
		},
		expected: decodeHexString(c, "2be29338c915bd42397d73907d70f5d95ba9bff499d11f7a27399db66470e26598cdacb5ab06d1d13757043c8dbf56a05d30392cc3b21f4210cc141652ea42b02e4b957c846efd214a4be0f015b514d0"),
	})
}

func (s *drbgSuite) TestHashGenerate3_SHA1_10(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "12420eb02fd4383263814968dcf60791"),
		nonce:           decodeHexString(c, "377a3fcaa2670b8b"),
		personalization: decodeHexString(c, "4efc5926bd999ad46c30e9bc7296b2ba"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5c68c0f079110476c14877c5fded2b7f"),
			decodeHexString(c, "3f1747b2a64bb371eb566a0204c82e7b"),
		},
		expected: decodeHexString(c, "1d73392928438da9e9f7a28fff3332746f7ff90558c987383305c8db8175c9012debdaf73659fdb4c40417b5d8daa4fef8b42696359f05584542d14721d68f8ca7807b751d649ef24eb42946c1c5003c"),
	})
}

func (s *drbgSuite) TestHashGenerate3_SHA1_11(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "847b94cbbff8bce709530aa019d10281"),
		nonce:           decodeHexString(c, "f1266d652c327aa5"),
		personalization: decodeHexString(c, "af28af297ab298a838616f1fdde1ceed"),
		additionalInput: [2][]byte{
			decodeHexString(c, "09334ce23df4cf7629794ac016d4ab61"),
			decodeHexString(c, "592f2a1f075ae69f310827d15eb2d6c9"),
		},
		expected: decodeHexString(c, "0035684b66bd9e73cb23fb04fd47c4e1f35467031acf05dcd9771a8193180d7c69bf87521a1df19bf847c659a6c4cdbc0c21e2b9cb26034cccb902563d16c63f39314d8cb5950487bc378f775b8cfd8f"),
	})
}

func (s *drbgSuite) TestHashGenerate3_SHA1_12(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "3daf9f110bfe02bb4b1cadb61f79da85"),
		nonce:           decodeHexString(c, "1a0e5f88d50fd86e"),
		personalization: decodeHexString(c, "16b320d8bf28c72642aa32d4d9798c4b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "153ab430f0750659fdffa6f98c6ea9f6"),
			decodeHexString(c, "7eb0d6259b237b7c38728fe7649e643f"),
		},
		expected: decodeHexString(c, "92d066eb16cb8753630888e44018592880c6253576531d90d042d1be9671c1b78cb84261b5ce0b12f3fc1e12a88f9799cba1a8a05b1cb0c58925a7913ab274f875cc71c47403fb242f85ae858ec58505"),
	})
}

func (s *drbgSuite) TestHashGenerate3_SHA1_13(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "dd71993ab8d7f4de58f4a94aecb0962a"),
		nonce:           decodeHexString(c, "b617be934450431b"),
		personalization: decodeHexString(c, "84c695d83bc7d5ef902a583bd799f2b8"),
		additionalInput: [2][]byte{
			decodeHexString(c, "13ee6cced402ef8c8543ec3ac16a38c6"),
			decodeHexString(c, "9d0a0fc678849860320568f9b19053f9"),
		},
		expected: decodeHexString(c, "fbda060bd0d00b0c31c8cd13507c36579e6af5e156c96bd860646b83e81c2437f636deba7b2ef6e5958fb3dae265934476a654990d08926deedecf1e43a41ffb61bcad560dcbce858c6ac3f748955660"),
	})
}

func (s *drbgSuite) TestHashGenerate3_SHA1_14(c *C) {
	s.testHashGenerate3_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d77ff86d653f38975322d0b7f1c02b6b"),
		nonce:           decodeHexString(c, "4b2d2a31b1367c86"),
		personalization: decodeHexString(c, "842108e074fdea387cfe71526eaac9b4"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e488e16f48c61dd2152afe925eceee92"),
			decodeHexString(c, "12c692abd90ab485f4d9499680a6893f"),
		},
		expected: decodeHexString(c, "8ba04617a135d8abe0c3c0a170e7472e7ed750eac706e5c3ed8305d6f6f8a1a53e0c52d4853b21ab8951e80970b426008ae11952ff364817b6856ef0810860dc65faea487b5d7c3f3d63fd443756d2a8"),
	})
}

func (s *drbgSuite) testHashGenerate5_SHA1(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHashGenerate5_SHA1_0(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ea97cecbcaa4ed7da13becfeda6205b4"),
		nonce:           decodeHexString(c, "59315cd461663fe0"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2b4bc495eb171e88bd9f63427080fa75"),
			decodeHexString(c, "dac97bb5116f63bdb72f29f46d38e57c"),
		},
		expected: decodeHexString(c, "d7536dab2b3b6c7186443de2a7c69e6965a09ca8c70f5da069eaa9d1b9ffb2714bda751e479d837f7de4c8c97bc8c14925795ff1983af71f042df3c873e8c40081b9a42053d42153dd1680bb2e8a4556"),
	})
}

func (s *drbgSuite) TestHashGenerate5_SHA1_1(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "be8bb186bd76c6e3c2aa016785ef0c94"),
		nonce:           decodeHexString(c, "0cdf980a9249180d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "5762c6478f213df44118a872a761623a"),
			decodeHexString(c, "984475db5403d4acf71bad13567228c6"),
		},
		expected: decodeHexString(c, "1519c0132bec9881f803fee16fccf04db11da71057a883fe268d3c120e41b6ef8630a191adc2c9a4183303966f6f815a1cbcfdc22edc1f95bc82076ab5261e8ea749660dd3a8f1077201284a752970a5"),
	})
}

func (s *drbgSuite) TestHashGenerate5_SHA1_2(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "8c3f3c3ad85d8dbf0b755714477b456c"),
		nonce:           decodeHexString(c, "69628bcc65bb1328"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "5d85f4408624692f0d0258dadeb70e16"),
			decodeHexString(c, "4f943e043dd224db1a144ff74fe913ad"),
		},
		expected: decodeHexString(c, "1e39687f18b08f56bce6c2022e5a7de1b04ced771630efeb32b6c4a125ba83eced08084c9ad179c626ce930704a060b25d15be032e15ee67695280dac2e2b3864ad308bb54f9b60b0f1bd9212e0321e1"),
	})
}

func (s *drbgSuite) TestHashGenerate5_SHA1_3(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5f5a57c0e78390ba0e9aa6073102a563"),
		nonce:           decodeHexString(c, "4678275a8b8dfcbd"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1e457cd70484f764fd44921edd931a93"),
			decodeHexString(c, "c3dc45c220b7bc21b318053f3629f56d"),
		},
		expected: decodeHexString(c, "1f582cec88d71acdc1544a89918628e9abb9f58b8ff8b96259df55bb1fa2b5a7529c0e790eaceaa8f4a81f8622698ebfb2db9da255a3f2b45156a4219f6dea2498d8dfff599a2d0c0bc8f0fb220dc6d5"),
	})
}

func (s *drbgSuite) TestHashGenerate5_SHA1_4(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "90ada55bf6def39bf8f61699e7c45834"),
		nonce:           decodeHexString(c, "f034db6d3251b3ea"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e5f15880935ae775fac2c15de20a32a9"),
			decodeHexString(c, "bff526e108b7818d5a30e9b0626a8794"),
		},
		expected: decodeHexString(c, "78793871b3d29667cedd4396389070c8aedf115a0cbf3a4ad2eba1c3bca058f8c3dec4e23c6353ff501614ea376783e9ecd8396910f04fb7005fb9f279eabd1b2620626499cd7702f41e781fd3413d7a"),
	})
}

func (s *drbgSuite) TestHashGenerate5_SHA1_5(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "467d32153d4503255bfabbbbe445b388"),
		nonce:           decodeHexString(c, "182b13922fa86d97"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "84e961472125df37396be2d8f4187a9d"),
			decodeHexString(c, "1232644aaab0b9a661fa2aef5976dee7"),
		},
		expected: decodeHexString(c, "204ab49a983dbdda27bcd1a0b83dcd2333877d6db67d6c310d492c1827274e34226efa028870c5c125656dddaa77babc47db6bdafa3c2fade12d8ec5f3c8b81f81b1e9eef38f33cd840234d39767a97e"),
	})
}

func (s *drbgSuite) TestHashGenerate5_SHA1_6(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1d22fa6cda79053b68bb6ba98b985a52"),
		nonce:           decodeHexString(c, "2f7d01a0fb26145a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "6b786ce43da77a58a531fbac7493ec2e"),
			decodeHexString(c, "917b220b809793a4193827e4fbf0db70"),
		},
		expected: decodeHexString(c, "bfdc3c800681acb5337bd3ad904e26fae6174c3e576579c495ccce73ecabd54a5e14e6a8980f6e8fb2cee621343092d04559451ee5e16deecbaf57d1bc4cb5087b3291941ef7e6c6f511a869ee2d57ee"),
	})
}

func (s *drbgSuite) TestHashGenerate5_SHA1_7(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "54b5fdd7dd2e7e1c4f09a6118e4e60eb"),
		nonce:           decodeHexString(c, "8162379c2b3dd97f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b2ed5078e176447a17986e98f9827a43"),
			decodeHexString(c, "5e6a483cc9f23e5c9d96952ba7cf105e"),
		},
		expected: decodeHexString(c, "867ec6f925c5227c7483678b4b0985f902f1fd87f22edae2a5adaf85cc771b16408ed646778d8724370bdb0137a872b76994e874de7fc2e724de16f5a07dc949d1c3bc9e73a4a0c29905c2b1cd99df48"),
	})
}

func (s *drbgSuite) TestHashGenerate5_SHA1_8(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "bb20617cc0f7ed8ef129a7a0e4784c58"),
		nonce:           decodeHexString(c, "cb3b83d613cc85dc"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b1419e3dbf91e155cd3207ead528b23d"),
			decodeHexString(c, "9d5488ca664c2b1979489a4cf7420e8d"),
		},
		expected: decodeHexString(c, "97ee02e386b01b929bde522e5f198c85ed031025f4fd3f805c8aceab9d43286f7ec71422828b427006d035df494b86fb9e710901651897187e1cdea5a649418c8724f0e641269a03127252b29d79494e"),
	})
}

func (s *drbgSuite) TestHashGenerate5_SHA1_9(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "e9ae7fab36e16442fc6f88b7d890d73d"),
		nonce:           decodeHexString(c, "37f721f2b227f172"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "63f92ec70f47458ca0388acb1dc551d2"),
			decodeHexString(c, "853311c75063ada99d25baa6484fc953"),
		},
		expected: decodeHexString(c, "2ca79459fa301219881213cd3e0c14cb004d12e1b0c776fd4f0632f91673cb67a66522fb724be121f8b46cfbd122cfd2b16d36f27d1735e5f1732acae85bf20fb4b55c53bdc9309062a6649fb50fbcb2"),
	})
}

func (s *drbgSuite) TestHashGenerate5_SHA1_10(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ef8b69c2113d3e8387500b8e91e6d077"),
		nonce:           decodeHexString(c, "a4b25bcbe92a9e5a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3a426211e76c0246cf2582a07e5ca681"),
			decodeHexString(c, "d8721b09b240486761ee0c670e5af473"),
		},
		expected: decodeHexString(c, "055e5f058b054377830ba4c731617f9acf164fc5e25174234e052095410b91243666ef57335329908943c6d88cfc00ee3f0dc00023ec32cfc490e82cfbf435e388949815dfc005fc0393d1d5eff7fdcf"),
	})
}

func (s *drbgSuite) TestHashGenerate5_SHA1_11(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1c98412f62d9220ebd841b379128b189"),
		nonce:           decodeHexString(c, "e1be2432431e83eb"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "6b43fe770e72497c13685aa558727f2d"),
			decodeHexString(c, "9682fa8b498d853f3b436498aa68358b"),
		},
		expected: decodeHexString(c, "ca1079d686754c553882ab963dbd43a953bc76bc779b945cf380ac6d38d21244a1bc146320214041bbb5560439fab99721ccdca64f79b557f6cd1e051c6b41d3a3bb867caedb4575749c5cd451b695e3"),
	})
}

func (s *drbgSuite) TestHashGenerate5_SHA1_12(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d7f75f8896cecbd64927320dbbe7a71c"),
		nonce:           decodeHexString(c, "bb0e49ae3b40e28b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cdd35d76e4dceceae918a3f58dc11ae2"),
			decodeHexString(c, "efddd6121e3f27665e0e585b035f771f"),
		},
		expected: decodeHexString(c, "236bf72559c48ba0ea7d0d8a6c76e06dbf966af7cc29b168fd798aecbb00ddda6e82cf03d430e083cb4fe42a9eb547e2c82ad0dd62882c1731de37e8874419e896a4a53e448e98a0b30887a7fc8e50b5"),
	})
}

func (s *drbgSuite) TestHashGenerate5_SHA1_13(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "4084b05fd62da1890245ed6bcce6cd72"),
		nonce:           decodeHexString(c, "cfc362ec0dbf23e0"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a5292a172339a4291fb30b9a3325aa97"),
			decodeHexString(c, "eae3dd073edcf84caac2f6161973ddaa"),
		},
		expected: decodeHexString(c, "b030974cd3f0a21251821be65a0a2c9d8baacaaa06804b6e74bfe00ba0691a055211acbdeb2fa7da9641ab4f8bbf74ab3032a98f2417697fbdf80d74887752072659f817f168175341ddef5b6efd9fb6"),
	})
}

func (s *drbgSuite) TestHashGenerate5_SHA1_14(c *C) {
	s.testHashGenerate5_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "46ebaf3fb0583fc5b8013e14584ce717"),
		nonce:           decodeHexString(c, "d5d68f69567cb290"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "32d09b604a65dc8daa35cdc34141b751"),
			decodeHexString(c, "b8186a294c7824b7c550c1054badec00"),
		},
		expected: decodeHexString(c, "ae9a091cfafbf0e74c2be8ad4b984e824a24e65ba7610b0f3ab1750e2f12de1620db6bb8c493b3d8b06ab78e69cf2dffd73d4322a67ee7725aad84fb458b8f26cf04846850202e53c874213221e761e5"),
	})
}

func (s *drbgSuite) testHashGenerate7_SHA1(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHashGenerate7_SHA1_0(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ef3eb1e63f9878d62984876712e76e56"),
		nonce:           decodeHexString(c, "f959d31650364e70"),
		personalization: decodeHexString(c, "fcfe42c0c65bbdc4a29eb0b598353e17"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d218da501fa09b43ed8e2fb8c3ecc564"),
			decodeHexString(c, "2479f4330af9910d7408404690d8eb93"),
		},
		expected: decodeHexString(c, "5de81d92cdddb3ec236037f4dc80d6c778ca72e128411a64689f26a243fb2b6fc54411ee9f417b1e113760139ae4b2f80d7475b666af16f87badc58e53046ee605ae9606ba9743c5e57a6959bebeb3a8"),
	})
}

func (s *drbgSuite) TestHashGenerate7_SHA1_1(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7480afff274e3188c6c68628fc315c0b"),
		nonce:           decodeHexString(c, "fd5ebbedaadb6ae4"),
		personalization: decodeHexString(c, "1cab5735b249e550ff3609efe89dbc9e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "834ea3f15f773e6d9c27fa787aa65886"),
			decodeHexString(c, "85cb35d2e7ccef7d22e1638554228912"),
		},
		expected: decodeHexString(c, "f8b050224ee890defaf9aa7dc50b0e3adacc51f5d2b54fbd1cf99525681876d21e5c45271f8a8e9ef89870e52142a7f990afd486895912c3d456dbc13e89b28638e9a3130e808ddbae96de74b3dc1617"),
	})
}

func (s *drbgSuite) TestHashGenerate7_SHA1_2(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7266e7e0a7ad0252d27b82a0289858d4"),
		nonce:           decodeHexString(c, "b02aa92033b4045b"),
		personalization: decodeHexString(c, "d0d22478c069deda197e7351edfd6a0c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "36991264cbc2171d2e3fc956c2d81f57"),
			decodeHexString(c, "e4e2e976bf833695e0bbaea1d92bed7b"),
		},
		expected: decodeHexString(c, "06c9ff2a148a9b5f080fd0fd7742dee91e5f1b4bff6fc4ad274638aca07e9eebc22d484733c827b61f47c6d0c44b33ddbbec1f2ab3ad0042dd501aeee2c919af266351e2f070cee6e7288c306b8f84d3"),
	})
}

func (s *drbgSuite) TestHashGenerate7_SHA1_3(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7c6c0d591b81bd601602f1f3be60a053"),
		nonce:           decodeHexString(c, "84e2d7b9d80af9e2"),
		personalization: decodeHexString(c, "e96d183121239ba35056264e73edbe79"),
		additionalInput: [2][]byte{
			decodeHexString(c, "673f409a0e133c6f37f2f3c3a30ef0dc"),
			decodeHexString(c, "c26810121161f3e08c854c299a3c5b45"),
		},
		expected: decodeHexString(c, "7b1c784cce238da765184c6fc03f2bf582d2652c5b763d425b5be932bd3d7565aad01eb90213d00fd1d38c59dfb3d5cd92cf8a0b676de1c113d7c567ac92b852851210b6207e484fdf4a3a6244a2ffae"),
	})
}

func (s *drbgSuite) TestHashGenerate7_SHA1_4(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5f6ad5aefcc39b3319aa7edabd5c3b5b"),
		nonce:           decodeHexString(c, "dcbee75db307b6f5"),
		personalization: decodeHexString(c, "6bc3fb023c6fd9ceb65eacceaa5c4e76"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8e9ba1a1f6a7315b7b5c557ab00c68d7"),
			decodeHexString(c, "e54bfbf4415104e476cc9f37c50edea7"),
		},
		expected: decodeHexString(c, "3371866666c2cabf028f888ab12b6aece43a7b2021d8098ecc423c3e72600bf49aedc71d24da4c7d992a7ce15896f7ae11b324fec93d76150b13892b00e911026ac8e3543bbbd0caf1996d9e07b049b4"),
	})
}

func (s *drbgSuite) TestHashGenerate7_SHA1_5(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7f267c4cb07d85bac0614dddd4d89d80"),
		nonce:           decodeHexString(c, "d819ac8c6b43fd61"),
		personalization: decodeHexString(c, "617d258740d8ab7cb2c632b6372ef3ae"),
		additionalInput: [2][]byte{
			decodeHexString(c, "3a299fd07e8611e1c3bbffac001adb2c"),
			decodeHexString(c, "94f5bfb53e3203b212bffd88695cfb58"),
		},
		expected: decodeHexString(c, "468bedcbb2f9c6deb8141888a758bd7931ef128de4e678be9985298c2664d33999d68342a0747acf18dffcabc32a0c09ce7c6522673b6739efe66cc25b28c06e8677ab3c6f1e3840852d245e0553ca47"),
	})
}

func (s *drbgSuite) TestHashGenerate7_SHA1_6(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "858923f05c1a1a9370c495fc8402589d"),
		nonce:           decodeHexString(c, "a88f688f22e8bd53"),
		personalization: decodeHexString(c, "4cc68f42206afd82608ddf9f18507398"),
		additionalInput: [2][]byte{
			decodeHexString(c, "4670631a5d2fbd86f58487603b880065"),
			decodeHexString(c, "34f7b4c92ba1aa900f7bc676c28f4283"),
		},
		expected: decodeHexString(c, "a391bb3c2f2cbde7dabd18a72b4e29b3b5c11d07c5c77a6b34e930f2804d3abd5af45f4102ad1e41da512572ed94d9d3317ac9c76bd56a0f10ff10ca7a8beb592dc3c8a017030b0b190a7abd506ea59b"),
	})
}

func (s *drbgSuite) TestHashGenerate7_SHA1_7(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "317ddfb1a01bb0e147eaaed375999730"),
		nonce:           decodeHexString(c, "d7c5a27ebd9209ee"),
		personalization: decodeHexString(c, "8d535a8d76042233e4b2bcf6ae3a7142"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b986568460caf36f3e83cd27d79fcb69"),
			decodeHexString(c, "1a4be6766a5899a21bea3287fa21cd88"),
		},
		expected: decodeHexString(c, "3e1c688bb6b680502061514b59ae90809dfc72182f54f0e8377ff50db2a86082f99e9f4c9eac9e3c5f06eec49d9e51434028be4e08f70634b1339db703bfc848ebc660a06ab8440409ed1ef4175584cc"),
	})
}

func (s *drbgSuite) TestHashGenerate7_SHA1_8(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "e3dd2e767f5205b6d0c4908d465cd2a0"),
		nonce:           decodeHexString(c, "4e356c171709cefe"),
		personalization: decodeHexString(c, "eb84e2e5b2208882d372f266bd1b5ba1"),
		additionalInput: [2][]byte{
			decodeHexString(c, "831868d30c12ad5a81e39f74eda9f87e"),
			decodeHexString(c, "0e34960f9469e23ed4fa285edd6b8371"),
		},
		expected: decodeHexString(c, "e47b96a306a4079a1a79e7e8e93d8a5e2f96fd995a02be29c4c36f980f2342aa949967a3a4f312a702081ef7bd959125287411f96ce647b91b56ee932e5554d455703faa6abe4109436335c4d2312b77"),
	})
}

func (s *drbgSuite) TestHashGenerate7_SHA1_9(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "cbff42d1361fa6cf283ea30f49f85abd"),
		nonce:           decodeHexString(c, "82418a778aeafccc"),
		personalization: decodeHexString(c, "93de9731c0c71807984681699a782798"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7d11ebedcc74e249b27ab30987539792"),
			decodeHexString(c, "dd2c3632f573ebdbbdb5622c04b31ddc"),
		},
		expected: decodeHexString(c, "12afcb023c29795c6b3deeb6558d59c7a0739d499c4135c37ff3dcd0022c7515b1f8777c1f2ebb49322f5dfdf9ea14151d20869b5ca145feec0dcff84293ed31557744cc74eac3b15cf450d19d1136f8"),
	})
}

func (s *drbgSuite) TestHashGenerate7_SHA1_10(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "9c501a2207d416c084f8c6ba022a7a35"),
		nonce:           decodeHexString(c, "cb44767de7042909"),
		personalization: decodeHexString(c, "f3232ca9def83fbb545e2cbaf80bc806"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f4f676890634e131d03750e93b25fae8"),
			decodeHexString(c, "48bbaad191bdc777937444bd2334dacf"),
		},
		expected: decodeHexString(c, "200217f9151c702840d9fcd13dc30b993f1ddab2291791a92ee562e52abcd5358aff1ab24e63f7dd1af270fd1e3e58c4d400252253a80d7eb0501e4a4113c06d945bce640b775ad657bad105af60280d"),
	})
}

func (s *drbgSuite) TestHashGenerate7_SHA1_11(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "a8c68826ec8254bef24517adc8962f0b"),
		nonce:           decodeHexString(c, "bd514bfa52bcf849"),
		personalization: decodeHexString(c, "00072c1d2e7670bd38f7e4093d894b51"),
		additionalInput: [2][]byte{
			decodeHexString(c, "351af55b61249dbae60adee7156cfe40"),
			decodeHexString(c, "02d997aae48047eead333c640a10958d"),
		},
		expected: decodeHexString(c, "9e3dcea0562a8c76a569abcfc805a178825d8de5d7ebccaf48747a68d5e5480706ef6acc5fe5e0e24ca9362ab23df84ca629876b23bf4bbbe9eefe58c93676b47c582c1a7181f5057495e83d30ef9844"),
	})
}

func (s *drbgSuite) TestHashGenerate7_SHA1_12(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0e579bc11f69b1d106e92c0a31833aac"),
		nonce:           decodeHexString(c, "8557f80c6f1ea349"),
		personalization: decodeHexString(c, "c6f3848b26fdb4b4402b4f9516e71145"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1a068f37e9c4a7a155b8b73eb31a726f"),
			decodeHexString(c, "8c3597d23da6cd672b6ec873aac9502f"),
		},
		expected: decodeHexString(c, "dd605d5f8b193196ad843072768f8727594c2c4e741d220cb5d4e7d7001b93ced734f1a3ad263bdbf203fe5fbb07e62af456f9ef4bfd93d0c4f6a7523ac84b8088da6c5786c52c648902b972d0781c15"),
	})
}

func (s *drbgSuite) TestHashGenerate7_SHA1_13(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "06ddcfcd7c11f7cad49e83290ccfe320"),
		nonce:           decodeHexString(c, "bdd6f8b19ddaee6c"),
		personalization: decodeHexString(c, "c473d3e0778927665f2e36187bd8e8a0"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d6463160605f3d40344ae8fe8d5b7c5e"),
			decodeHexString(c, "ebbab9e5e4d84227e8cabe8bcaac7711"),
		},
		expected: decodeHexString(c, "0e57836e98299c4680bd28fb26ca848070ad83e9991f7d934c31e0ae17f32cd591d4f2eef14b2eaf95b27e3b1c75e9a0496a6deceae8fed5982d03a0baf861ee9324fc6e75093c7953461918a608450b"),
	})
}

func (s *drbgSuite) TestHashGenerate7_SHA1_14(c *C) {
	s.testHashGenerate7_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "03d389e9a0fc110d173adb2ceb3358ba"),
		nonce:           decodeHexString(c, "8b325599297c0d47"),
		personalization: decodeHexString(c, "ab25bef8d0097bbd42d55316af321bac"),
		additionalInput: [2][]byte{
			decodeHexString(c, "af578fbbb8a830947e9b4e2c9e729336"),
			decodeHexString(c, "5a69864ca39da1ba4719dfe1dc850a4a"),
		},
		expected: decodeHexString(c, "8b846f03cb66f7e49fdddf7cc449a5f3f6ccdc17ae7e2265a5d0e39ea10fc3e6cffefc04147b773a1584e429fe99e885f278aff74a49d8c842e7ccd870f1330692fc9c4836dac5046c544be74652da26"),
	})
}

func (s *drbgSuite) testHashGenerate9_SHA1(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHashGenerate9_SHA1_0(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "21b6808c0fc59ecd925ebe35ddfece08"),
		nonce:           decodeHexString(c, "09dd03ccac5485df"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2272f1976f1465a07ffd72ae250e200d"),
			decodeHexString(c, "0b2e0090a21ac372c94ce89a2cfbc5f0"),
		},
		expected: decodeHexString(c, "165915d1ba81eb3f0b0213b058e528265d290c14d30b532a7f3cf1c3941a73ef5fe37c872d7241b1544548a23e9230cc7f2115d3bb44a30d1a34ea93bb5fed305f95ad7d4c3be5efede5a89edf97557e"),
	})
}

func (s *drbgSuite) TestHashGenerate9_SHA1_1(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "3813f376f4fd1c6d73f3e160d4f998e9"),
		nonce:           decodeHexString(c, "95428569742d387a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "64a733e774596ff48ded129b04d9285a"),
			decodeHexString(c, "5b12c6915e0b86998b00ed290b901a30"),
		},
		expected: decodeHexString(c, "6224b1ea5d097290a603b72fdb2a94dcd855fc702f9e7f0c1f4d57fa1b64e20f660beb6120f6d6ee24765b50674f1e612bb29159d09934ba18403328edf82f3530291e6172bc4b7e76e7da5db0e6cfcd"),
	})
}

func (s *drbgSuite) TestHashGenerate9_SHA1_2(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "e75004f41ae07db8ecefca47888ec114"),
		nonce:           decodeHexString(c, "1c1d86980d1dad6c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "fe3a341a5c8faff31559793f3dd9b43f"),
			decodeHexString(c, "95ee782ac0ac3ea4d2c5148f3b37747f"),
		},
		expected: decodeHexString(c, "bf506dd70b76c9541a063b8cc4aa6f93b5549d71df899823c9b69c47d30a77c4cd6f4e50654c4955a8e5581e43be2cf46a5289560acf000bf54430a1949b5243e9a799db3cb086f08e6e1e34e54d3208"),
	})
}

func (s *drbgSuite) TestHashGenerate9_SHA1_3(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "786471928ff558a293f4a36686611872"),
		nonce:           decodeHexString(c, "dc41930c5163bc77"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "fcfc99f05fe9a058c047dc03c0171c6f"),
			decodeHexString(c, "eba3d9774243a273eed091d5444a7ba2"),
		},
		expected: decodeHexString(c, "5eb133f8f1ef9d764ce450d6d2bedab3dbc82f5a956be57ac408d6ba9251e642bda0bbcd920efee32bbe77c3abe845b4aa0cb2dd450e97108ca2a9a0e8fa9b3c4addc20bdb2ab5d76a5a4eee3e015793"),
	})
}

func (s *drbgSuite) TestHashGenerate9_SHA1_4(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "51359dd92bf3b8c432d328aa4a6ce8da"),
		nonce:           decodeHexString(c, "f844b34babf2bc9b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "593b025d3278c32b2697076195888ebf"),
			decodeHexString(c, "ae23f51ebb06f517cd5ccd2b86cafd28"),
		},
		expected: decodeHexString(c, "1d9fe28a9d695d14200d193636933c94ac118f2ec33c16a8a671f9c1ef474b5bcfb18e99d29ba6d55c1a07ea42958b5ff64685172cd7de24faf06510d5b9f7c84cf8955af6707b9321692336dfedf2ec"),
	})
}

func (s *drbgSuite) TestHashGenerate9_SHA1_5(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5672ab20f667e5918a8087681c187dac"),
		nonce:           decodeHexString(c, "a9b42cfb74ccceaa"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "6f4d34dd4cc41d015d002630a57b5da5"),
			decodeHexString(c, "d571f6f4c1200b619483b69166a59cdc"),
		},
		expected: decodeHexString(c, "6c4369290d517d4097260f88618c366a855351bf5e78abcbb23321f5f0f2da592b21024fc7e9b27d768e841e8d778d4367a0faca959a2c9b96bd2f256fbdd345ab9cdd5b035bdd7ac3c5d356bc1ed8e4"),
	})
}

func (s *drbgSuite) TestHashGenerate9_SHA1_6(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b65bc4cfa115bcdd15730ef5f7b3d7b1"),
		nonce:           decodeHexString(c, "577f9be90f625ede"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9e76dae1d2f68f6993e531e613f62263"),
			decodeHexString(c, "16a5fc599f9d94e2d3717cf77551d47e"),
		},
		expected: decodeHexString(c, "33e09a710ab41034d16bb1369e2bc157f333a3ba6dfc7300f6fe600c5245b043c5918dba6bd3bca6afcfff3325adabe550884f80b07239684bd2d8f9d558f58b520828067ee90f47b30954a2676c5cec"),
	})
}

func (s *drbgSuite) TestHashGenerate9_SHA1_7(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5639fff8a23ae7c51bce0744cc69e534"),
		nonce:           decodeHexString(c, "c6d5632fd6899da2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "abce9c7fb00d7e4801651f89d5bd47ea"),
			decodeHexString(c, "1da0833202c82da971e8198ee7aa0b90"),
		},
		expected: decodeHexString(c, "7c0a2305e5233edeeda421906d8528426ccc455ccdc28f30df3b31ad8bec990bfc283fe5ffbaba93b880f9a01724684ce8e7242a26c3e9b1a9d23a14a481e5d3c75612c6be2763361a749e8ece57f7f5"),
	})
}

func (s *drbgSuite) TestHashGenerate9_SHA1_8(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b039d4adad57680ad2a0f743a50633a0"),
		nonce:           decodeHexString(c, "0a472bdd9f6e2bea"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c539241ee05944ed0874eaf3aabf342a"),
			decodeHexString(c, "e97f92e56cde350d1901206903605f66"),
		},
		expected: decodeHexString(c, "228361a8b6113eed3d84ed46a0573134c70d2d5a187a35b4599f2bf1820309e7211dea34d33a62dfa742a216752a9e57f33a604be3e88ea0f15f5d916d72664673d886104a7b6c3904af6d6563e05761"),
	})
}

func (s *drbgSuite) TestHashGenerate9_SHA1_9(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "71e7d5b1845707ebbed471bc663b8517"),
		nonce:           decodeHexString(c, "42503fc9496864a8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "59ea5dc55e22e034f1ed46d1739f1d33"),
			decodeHexString(c, "d97af01277043395dbef3a0eacd6163d"),
		},
		expected: decodeHexString(c, "d6c5cad4af95483428497f0ff0d8a30f673787f44ffcb9bf55c1ed39fa41e3f53849da76faa5377eaa832c835eea200226f5f3f0575d67514820024339e248b09111195c0bb7148facf310b593947256"),
	})
}

func (s *drbgSuite) TestHashGenerate9_SHA1_10(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ef325265d5af25d255784e109b20b761"),
		nonce:           decodeHexString(c, "52f6faa7f37c7df2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "7709e220f067ba161cd361639580c42e"),
			decodeHexString(c, "ed6acb902f1d0266c14f2993bdb77ff9"),
		},
		expected: decodeHexString(c, "3b8bc3e1cab67f41841f74b0d20b87b95483be53da229fe34b47151d2ac2808ceb6e50da6cfffb14b55d0f3b846676612130a7011915b946df67189514b69c11514c06ce271dc370f136f6c5089f8c6d"),
	})
}

func (s *drbgSuite) TestHashGenerate9_SHA1_11(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "80da5b7e5316c99ae6a21ecfe2e013b0"),
		nonce:           decodeHexString(c, "28dcd71591a764b5"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "39a165630c5dbf4ecc53f8dd825d982a"),
			decodeHexString(c, "576afbba4f9408050938b8d204a8b1f6"),
		},
		expected: decodeHexString(c, "9d0b9b54b9a2cb6186d43b1282fd214a00cb413904023b4820084f36a0f0e50888cb8b33f6731555595ea5b20521f18d1e94aa8eabafcf1686cdc850965911166f94115013e78d85804a634cf07a3d55"),
	})
}

func (s *drbgSuite) TestHashGenerate9_SHA1_12(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d74921d6dfa69d7a73861016cf155cbb"),
		nonce:           decodeHexString(c, "3e49483902086004"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "4839cd9386e68298aa274b83f5ae9134"),
			decodeHexString(c, "c08d03f65eeabde5c9bf7230a5a3bf91"),
		},
		expected: decodeHexString(c, "172b29d46e9acd26c0a38271adaf926e4ece4803f213abd6a1065b8fe31427f1f5bcac78f2f2156e7811e9c5c984f97aeffaa4519daed067ffa1975945897460548f78b67370d332af3af1f9a12ddc22"),
	})
}

func (s *drbgSuite) TestHashGenerate9_SHA1_13(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d4a2f2ded01ae7a5c33b09f638f9ae5c"),
		nonce:           decodeHexString(c, "eeab2ac971bc8f6b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c3e727b3ce8cf2200dfc067d13c80218"),
			decodeHexString(c, "6d4c889b91603890458277b9fcc57aa8"),
		},
		expected: decodeHexString(c, "9defb23c7cbf32e2f895d8be3ccd9b0c6f2d6cdd3db0aad9a3a5f2f6189a441758bf1a622313a9ad7da7d295364ef857901e2229e7315b06c75598c9ce6db26a966c3dfa49df45514bdf46125c622866"),
	})
}

func (s *drbgSuite) TestHashGenerate9_SHA1_14(c *C) {
	s.testHashGenerate9_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "bf764151136597eef9c1a7ccff0f345f"),
		nonce:           decodeHexString(c, "29f9059f90816c57"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "7725ef70592c362d70b088ed639f9d9b"),
			decodeHexString(c, "5ab2e0067c3b384e55a78492f0f6ed44"),
		},
		expected: decodeHexString(c, "ca095da39d9c21d7da073d9c95d2e415503b33c327d739f1838bbea4fc6f0254fdaf8ef6152e9263f46b864f39c7104d1d337d99fee588061152e623d7e00a27e03b5d16fe6e543453a31d4dafeda3b5"),
	})
}

func (s *drbgSuite) testHashGenerate11_SHA1(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHashGenerate11_SHA1_0(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5e0566b660631b94bfa096b3225d59e3"),
		nonce:           decodeHexString(c, "812bba142937562d"),
		personalization: decodeHexString(c, "08e83a8e3d50e50db2b0be92f236f786"),
		additionalInput: [2][]byte{
			decodeHexString(c, "496b30ceb7ef9ebe9d449d124d2202a6"),
			decodeHexString(c, "2df0b03dd0ececd20552fbfd33188d4f"),
		},
		expected: decodeHexString(c, "481e3558c50cb669164448001daa1d563c52afe14a92b58dbfa612f0ecd94e2e642340a3907028fecc214087abefe3b65c8fc2e0255f520c85bf62f02a7e18796950f4fdd4a408bec6924ea502360590"),
	})
}

func (s *drbgSuite) TestHashGenerate11_SHA1_1(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f9bd510f8ab89ee8451069f3f9c01cb0"),
		nonce:           decodeHexString(c, "a422dfa0b0621ea0"),
		personalization: decodeHexString(c, "94b4b3cf1453457fd58edcf4aeaf4c4c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "3066bde4e26c14da649fc0cb714b7e20"),
			decodeHexString(c, "40544e972e9a7bc227c87feb193a85eb"),
		},
		expected: decodeHexString(c, "44f971347abb13b45030ef6003ac154e076e6ef49ec5849d80f092650701559c41cf6eeb02e8d8e319a5b75695014db895de56db1121798f8e681e6f4a3ec66e853f013b017859d1c76d348c0ee72665"),
	})
}

func (s *drbgSuite) TestHashGenerate11_SHA1_2(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "105d33d2362b87ad3ee51fd7ac74b756"),
		nonce:           decodeHexString(c, "cfa20f0e566dc5c7"),
		personalization: decodeHexString(c, "764c28ee81336aedca872ce266d56313"),
		additionalInput: [2][]byte{
			decodeHexString(c, "12cca70dcf8bee7fcb198949839b1440"),
			decodeHexString(c, "114bc17e4391cc4fe8cd4515c2eb05a9"),
		},
		expected: decodeHexString(c, "00db8005e9c9191c5cb1c89f79fe13a0e9b5b4e10b4cc772c8ad9f86d57bb0f43ec8a4b875a5d42575b91d6e5277b18275ac769325af3faffbff6a9d66f68500a07faee822d08ed8de790bc51cea80a9"),
	})
}

func (s *drbgSuite) TestHashGenerate11_SHA1_3(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5f21e96d25a54ec1dba73e67b2202dab"),
		nonce:           decodeHexString(c, "b8fd4345dc8eb083"),
		personalization: decodeHexString(c, "4092d35fe74609eb540bfbc18f0788c6"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2bcbc4a021884db410b7d23a35162924"),
			decodeHexString(c, "7420ff1fbcf833db6afffa4c0f8bd0f8"),
		},
		expected: decodeHexString(c, "6f433e459b9adca5c73693c586e9d37183b9f8c4463805cf2b784fcd8b9e6771f53b6f8dd8a98e047617333cd26ea7b76b2c7efdc1cc2ccb8858777f6467b222c51eab14bc0d74c62af735820eca54ce"),
	})
}

func (s *drbgSuite) TestHashGenerate11_SHA1_4(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "db01942b1e189b2981407ddfb84b3081"),
		nonce:           decodeHexString(c, "3fbe7768dcd64870"),
		personalization: decodeHexString(c, "eba9f4974b3ce7bf67577fdbb69160ad"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f9f85dc7362a009510955f9000423556"),
			decodeHexString(c, "7bd4f4d130a5d61be19edca07078e28d"),
		},
		expected: decodeHexString(c, "57a4b0e981762f6bc6a980b693a6e1dac85ce344e98f63de345d3427d98c4ccc00892c6b3ef735bc273f6857021a1f2b81be7d60c22e60042fad8750894f77fe64bf25312f150ffee6121b13451aebed"),
	})
}

func (s *drbgSuite) TestHashGenerate11_SHA1_5(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "3375f034069c2569e64d718a4deb9874"),
		nonce:           decodeHexString(c, "58cf63122c30c5f5"),
		personalization: decodeHexString(c, "4765142da01613784583cfe59c5b9ddf"),
		additionalInput: [2][]byte{
			decodeHexString(c, "47dc6757cbce9386867808b24f3278fa"),
			decodeHexString(c, "20496311bfad06ccd3460c931107ad87"),
		},
		expected: decodeHexString(c, "f599cbbbf0d93c9e30151dd08689838d4132e4d83bd38063da1d845766f4c37b00bbd560b78362687cdf7d674337d203a33467226d35cbdb6fc924c9b966f9df19966f59f5f57c9f3b46e3065ec8b652"),
	})
}

func (s *drbgSuite) TestHashGenerate11_SHA1_6(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "629b62131d5af04fe2e1f377c6fe7d01"),
		nonce:           decodeHexString(c, "caeb888184526f97"),
		personalization: decodeHexString(c, "e96e5ca5455d7a26941bd993e480e64e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0dd70e0d02984767293758485619a318"),
			decodeHexString(c, "1b3405eaa98408014e6b14f080b4b740"),
		},
		expected: decodeHexString(c, "9cf202d4d49e744ae4cff504904991e4d8ad9612d64da8ea03ba023f54f4cc49598d2f8015b2c8be8400b4a3d9b44dda532b3e724e27dd5744f8f3c7d99a33670999b11d403d694c95cb7e06a8a0e0b4"),
	})
}

func (s *drbgSuite) TestHashGenerate11_SHA1_7(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1e46ccc7b62a7a19958d65cb6d20c106"),
		nonce:           decodeHexString(c, "680bb7fa43b0db4a"),
		personalization: decodeHexString(c, "2e38eb083fc5db4598576dae95a093b2"),
		additionalInput: [2][]byte{
			decodeHexString(c, "95b3649acfe5158ef80906c41ae7487f"),
			decodeHexString(c, "03a90dc938650d30be53cd72c2690714"),
		},
		expected: decodeHexString(c, "05495f39993c97e1f84faee2058264b1c25b3ef61f59eba1832fa6af8c11e21ba3d4d38c257a46efaac7942a582b17277fec6b3a9a954e3f323c9a2a9f8fa9f90b1f47fbeec6d10698337c187e5b82c8"),
	})
}

func (s *drbgSuite) TestHashGenerate11_SHA1_8(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "21952db33ebdf9ae6a785f6af9809154"),
		nonce:           decodeHexString(c, "722ee382e4a04ae5"),
		personalization: decodeHexString(c, "b991bf9eb7cca76f25f45e1d0e0e96ff"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a8d8b6ee7be52cb0414c55a38f6ad74c"),
			decodeHexString(c, "7f5c64ce3373c154376f4f189b11e6fe"),
		},
		expected: decodeHexString(c, "33bc2a7599b4a2db6f0dd1896e40dcf612b6269195e81b20c4842cda27227fd9e74911d5504fc34ca0d858412b5082cce2c07d377ea4eaa7e878229460ac2fb5adf241b292dec31aebfa4434eeff3808"),
	})
}

func (s *drbgSuite) TestHashGenerate11_SHA1_9(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f081dd932d9f5e53d9eee9807db58fcd"),
		nonce:           decodeHexString(c, "92f027b15ca5866f"),
		personalization: decodeHexString(c, "3cabd9fd3de7e196e1803f3619a3d048"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5aea804f5250075d5427de0e73df42da"),
			decodeHexString(c, "eddc6c242813841ed7ac483eb6cbab67"),
		},
		expected: decodeHexString(c, "be5036d8f79fc9c1029c3f9e42f1045343dfca9eff6b74f6ac0b9666b4df7151ebd13fd052cc8bb9bc7b1ce6fce0f2749f313df7b9d06cebf3f6aa936270032e8e0dec3405ee246b80826850a1228900"),
	})
}

func (s *drbgSuite) TestHashGenerate11_SHA1_10(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "9eb908f509c77c0ac953560493f4dc28"),
		nonce:           decodeHexString(c, "1aebf69b03de5cf8"),
		personalization: decodeHexString(c, "a7f01f55fe0e6b6d731f387caf95d045"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5dca6d75183f3092a18c8dfd950fdf98"),
			decodeHexString(c, "50eb0cc76aa38e31b87e7cd8df950f08"),
		},
		expected: decodeHexString(c, "ba52cbdb845f5ee864fc1c17c6bd0a68439a7eee7027fef5a8083b2e0146c60464246527d52ae59ff5580f336b94594f5aa933c3f75744c76784df9783bdc91d130e29658fb272045e953794ae9bb316"),
	})
}

func (s *drbgSuite) TestHashGenerate11_SHA1_11(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "f8cf962f6e583970027d4263f3f8b936"),
		nonce:           decodeHexString(c, "0cc239a1fe9750c7"),
		personalization: decodeHexString(c, "c9251c519d5526d6882f1b235fb9b944"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9752b7e44c67da390d4ed5e8b95817cb"),
			decodeHexString(c, "d18d460512747b638652fd4d457bbce9"),
		},
		expected: decodeHexString(c, "5a7e2ac66b5fb12b3eee1b6aad4b34e2439c53229e6f2a10a92069f8034562d1125a707766936b6e9c6551d7c8c02775a5721881f12a28e1d63c18e4a7869232511989c79c5a8d3cb1d4cb36ea921c78"),
	})
}

func (s *drbgSuite) TestHashGenerate11_SHA1_12(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "55e311a23e872ba906bf060388e60ae5"),
		nonce:           decodeHexString(c, "5972e7aeb9f75344"),
		personalization: decodeHexString(c, "be3f6e932339c5b9f71b87e72ff4dab1"),
		additionalInput: [2][]byte{
			decodeHexString(c, "fab46e391e2c5f30b37298643bc55d50"),
			decodeHexString(c, "cf4e5483cfd794f03269e289f2b4c08c"),
		},
		expected: decodeHexString(c, "648ec7773f8c664f3d7fb279b51c5b9a3d9b067d6aa54e93c9bb9a892da91fad4a30e8e4c5866ddabd2bb44b243d7a3a00affec9efb725c951862ff9184392dfd626e711e0a3840db849b1e3b01b4fa4"),
	})
}

func (s *drbgSuite) TestHashGenerate11_SHA1_13(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "4a989e6bc37b9157fefe6789aff230f3"),
		nonce:           decodeHexString(c, "7e5ee246798dd7bd"),
		personalization: decodeHexString(c, "a7f5af48da677d6721d11e284fb1ffef"),
		additionalInput: [2][]byte{
			decodeHexString(c, "3351002030eea100c84840748b0a3d4d"),
			decodeHexString(c, "acd32c8d515109e90dfe1bd9e6b326bd"),
		},
		expected: decodeHexString(c, "a77bd7dc3986b43136606a209d600ad90068b567a5e3a2f75e61b2748e265e500fc7ed492b8cdde39a6b0a87ad4dd00529fa7feb4635e315b7116e1ce6251a806c7c871f7ccc4475e332054ef812c631"),
	})
}

func (s *drbgSuite) TestHashGenerate11_SHA1_14(c *C) {
	s.testHashGenerate11_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "75ddc6b58a06a0feb20b703ab6dd6da0"),
		nonce:           decodeHexString(c, "527130cde5214f55"),
		personalization: decodeHexString(c, "3a2fa9c3b13397ed8ebdf57d1efc1c97"),
		additionalInput: [2][]byte{
			decodeHexString(c, "27486f8dae1b36462639ff7eee869a29"),
			decodeHexString(c, "d1bfc7eabd8eddf622297012169f351b"),
		},
		expected: decodeHexString(c, "4c893c3d1ed3a190fa88e159d6c99f26a02fb5fccb98bdef9fe43f1f492f490109224ba6c317db9569f618984409f2fb3db0b1e2cd4b95746f159cca76f1204f6d2a4c455c547a39a5f79fec95c8f4cd"),
	})
}

func (s *drbgSuite) testHashGenerate13_SHA1(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHashGenerate13_SHA1_0(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "9e13a57fb43ddcd069fc8380b818f2ae"),
		nonce:           decodeHexString(c, "fd09586067e5d92c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b2257ba77d8af75d23b80c9a9ce74630"),
			decodeHexString(c, "79775210d749662d6a5ea2b2bbbf3530"),
		},
		expected: decodeHexString(c, "78a4957978450a7f8ad00f3c3b4e21876f5a828cc60cd8eaf488eaeb1b9640bf493a9ceda1d3c768434deb20183b7c0ec8e7d751ba9011e3489563c795b678be5ea13618bcc3ba54fe594453c95c888b"),
	})
}

func (s *drbgSuite) TestHashGenerate13_SHA1_1(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "a4e86218fbebac79a31b3acf2ad3c6ea"),
		nonce:           decodeHexString(c, "ea2aec423f4dcf62"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "00277c54a49f8d71d324c4f6d753ab8b"),
			decodeHexString(c, "8b56dd32e14fe606898f8feb4b5e05d6"),
		},
		expected: decodeHexString(c, "c9310694bbea399211ec91d41c60f32313fca28ae5eddc772e98d8f5927864ad69f71800d9331ea4e531e3bb8356c6ba9365ac76b78c40ff28d0bad4a144b8d74fe4566e8dcff046dccaa938aedbb290"),
	})
}

func (s *drbgSuite) TestHashGenerate13_SHA1_2(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b13f2409b5bc4151ca7037f7de835261"),
		nonce:           decodeHexString(c, "2f7ae458deda5e41"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b24f349c357a53b342ebe531e1a04013"),
			decodeHexString(c, "e8a5c65474a27d2fd50f6e6bd03cc27a"),
		},
		expected: decodeHexString(c, "b7d3337834f2e223570300f16b9b5a1d1d7fda5eb5be14b89066dd9be39babdae41afdf57589e4c9ec062dc0ab0d6295458fe083dfa6c55147a13565628d596c913e28a82700d89a8bbe226d33e08e8b"),
	})
}

func (s *drbgSuite) TestHashGenerate13_SHA1_3(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "70c73c776232d14f09dc1f84afadeab4"),
		nonce:           decodeHexString(c, "39d459b1a361740d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "679f2ff0aaf51a1e69ac27480d576932"),
			decodeHexString(c, "27d4920dfd2683b66a42ad3d32071547"),
		},
		expected: decodeHexString(c, "bb8e5008c11c4d6e4c63996f1e50edf480bd155fd04668652eeed6a871de7c8605f217fa7942e03f3cc2b8bd1ca18d6ddef73ed9ec0072036a3416102c60f83debebacffe9fdebe2a478c2c7ca68abb6"),
	})
}

func (s *drbgSuite) TestHashGenerate13_SHA1_4(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b838bb136ad9b6f2b7913ff41af9af40"),
		nonce:           decodeHexString(c, "43ccad7a4227ad7c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "09db57817051cc2e19806d18b0a9084f"),
			decodeHexString(c, "f8ebc3544a5cd56e0b6136c9c3428499"),
		},
		expected: decodeHexString(c, "2060e3922728703c947e0d7d94374e9741f433ca244c6cd396db884aa41f6a75d834fe763c8c873a960ff301586c87012721d8be1bc0226884c235321b818ec195940dcb5c21bfe95936ec2fe4a5deef"),
	})
}

func (s *drbgSuite) TestHashGenerate13_SHA1_5(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "e4f69f558dbbcf15768e21e276c7381c"),
		nonce:           decodeHexString(c, "6d14d8cdc6bbe6bb"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "dbf765ff204ee32c5382a39dd6aff870"),
			decodeHexString(c, "4fa90168a5a0073090e4d4af432c39a4"),
		},
		expected: decodeHexString(c, "e65401ce0ec9f0d247d50cff3ad070bb1f3c9f9e81e7237ca0539b82e4c4d362983bb5adc3d2d98dbc9a21a3351e17fd7890ef8fef7268f5c0031fd49df563ab6771939dd2bcd6d65c307485c0ce1af5"),
	})
}

func (s *drbgSuite) TestHashGenerate13_SHA1_6(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d7a32b5597d9994fcadd9d94565523a8"),
		nonce:           decodeHexString(c, "5f47254c88b71055"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1ebfd0d0a13ffb06dd3bc3192f55b2c6"),
			decodeHexString(c, "804fc1772ab393c74d7cca2e566ef70f"),
		},
		expected: decodeHexString(c, "eb269c0f2d02ab4448f51e0421df9701f27e9da77e75b2e7603cf42152a8edc5fc292fa9d4046b22f7842bfa80d4a0334c79e0c8389a9ccd94f34b9c6a188b09996bd6d1e0ebe72539f6a25a5cc706f5"),
	})
}

func (s *drbgSuite) TestHashGenerate13_SHA1_7(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b6801ab728562acbd71a2e2157eaa5b1"),
		nonce:           decodeHexString(c, "2ef69d68e40b3d82"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9bab4de8295a5ee6e15cc4962f089631"),
			decodeHexString(c, "aaaa367701552819c4a2331665bbf061"),
		},
		expected: decodeHexString(c, "091edfd88948e749b6aba6dd70077c88f1ea297bcedcd9e1f0da80e53ec1517f08786f2e864517a2754c5cd15008d6c03ab9ff2d058880869d8b8247be79a01133c556a515fde2b2119269c7de06b473"),
	})
}

func (s *drbgSuite) TestHashGenerate13_SHA1_8(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ee5affe5e315db84f71a220b315888bb"),
		nonce:           decodeHexString(c, "f5e5f7aa35eae629"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "6d3e8fd6870d2fcb22381c1958e3875e"),
			decodeHexString(c, "8a3a4093fe500feaa1f7e2de9fc56bc0"),
		},
		expected: decodeHexString(c, "27e79a6de3b99971182eab73e321683e2a601dee46314531ef8a0400037b1a660e2cf0759df0f6d2afca9a0dec502b466d95afec52b89741242dada5202806ece73996df88f35bf7c686a0f69732fa9e"),
	})
}

func (s *drbgSuite) TestHashGenerate13_SHA1_9(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "28f15b1ecf1e8fbeb4ebb243e86e510e"),
		nonce:           decodeHexString(c, "a149011ca0962b79"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c54425d43b1e6635467c5158ab570596"),
			decodeHexString(c, "794c9b2604ba2402a47638dc7360ac29"),
		},
		expected: decodeHexString(c, "487119e5db7e5b6e5792ac25ebc055e91ba827cd695b5b0f959185d9bb62e27a8f6c814afc39b26f94878707ae2d67d01877ea267fcc55d5df83b2d8099a093e952a43c5d8de9925e5a0bbdafd813700"),
	})
}

func (s *drbgSuite) TestHashGenerate13_SHA1_10(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "ae23ada45ba1c1c491185311aa994b18"),
		nonce:           decodeHexString(c, "03a157c7a74a20d2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "09f37d8e0ce23d2ed9a820c41c9c06ee"),
			decodeHexString(c, "f38dd16e2fa8d52c1708fc3869bd9a09"),
		},
		expected: decodeHexString(c, "d45f27d91e077b9fa060c6a7d707c07c0ea3cbdb80194f08fea64d317715cef76dc88fef48356c1cf9f99e5644e6c5872e7937dc1e2c9ffe0dfaa87e425108d97f65166ac2c110ed0cd07facba773673"),
	})
}

func (s *drbgSuite) TestHashGenerate13_SHA1_11(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b0050cbc412b3122d8915b795321614c"),
		nonce:           decodeHexString(c, "a098bfa017d5eeb4"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "75816d4ad2581f92bce5e679bbcfff53"),
			decodeHexString(c, "7d40de162b812131915408f979bf1ac8"),
		},
		expected: decodeHexString(c, "74cf8c5d35dcfcf472f0842b465fdd136f12b405ee356ef480943e704cbb12a8f568d7e1c131e291a4e82a018b667bb5c812745514c902e713c9352653696ee07df6a552598d0473460bb38fe1d602c8"),
	})
}

func (s *drbgSuite) TestHashGenerate13_SHA1_12(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "faab57f31239c22e8808c246596c1f5b"),
		nonce:           decodeHexString(c, "0387f1636543a661"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d1b1eac58101b56082f6cf3f03ba3e6b"),
			decodeHexString(c, "13b0b5baad299e76c732dd79878b7e4a"),
		},
		expected: decodeHexString(c, "1a7230d14eda7f2f96e30e9b60137ba33aa4c5be0472880437bcc61ca82d1e0828918b4062ff7dee89128a48ed87ac60657051e0eeb4cbf372a24befff4d6e22e73d3dfb34d59d213e05cc099d48bbda"),
	})
}

func (s *drbgSuite) TestHashGenerate13_SHA1_13(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "93d771d07ae98d787fdb787f30abd7d4"),
		nonce:           decodeHexString(c, "380d743dcf70a78f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e8b4b833d8657364b8ea4a6704fb732f"),
			decodeHexString(c, "615853a9e6e59be8353cb23ed9b068c0"),
		},
		expected: decodeHexString(c, "2aea2555d25835ceb3425f584ba11f20f237e0a6af2f554b382411ecb0ffa8d6d5504b654467ba34a0436dae4a9d483f6f58a52d73844586bce2d1406f4d5f9b878c4d1460ef9c974cac1ce0ebe8627d"),
	})
}

func (s *drbgSuite) TestHashGenerate13_SHA1_14(c *C) {
	s.testHashGenerate13_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "7d7b1c325e9843c3d2770efd5e134fe7"),
		nonce:           decodeHexString(c, "9dac46a2da81030f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9e3ea6eac120d663e330d282ca9b9d7c"),
			decodeHexString(c, "b8d71fce7779a9906b9790cd1d4e48d5"),
		},
		expected: decodeHexString(c, "63d28a300a329ca202b98498c9f46912620bc85c246f034dca4186cd9b0e0810a363785878effde90aec8cb584862524eebf940c44fed21cb580d4115f3e0dda07e0e4a66689c2ff3e9b87edfaa4d051"),
	})
}

func (s *drbgSuite) testHashGenerate15_SHA1(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA1, data)
}

func (s *drbgSuite) TestHashGenerate15_SHA1_0(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "1b2827ae51824e1f68a48116dfb2e343"),
		nonce:           decodeHexString(c, "b9eac1b947ad0f4c"),
		personalization: decodeHexString(c, "51fc5e485d8cd08209c9894821a2a6b6"),
		additionalInput: [2][]byte{
			decodeHexString(c, "39a52748bdbc7fe0ff4545f0179949e6"),
			decodeHexString(c, "4d1a774a707438bf46e6909aff874189"),
		},
		expected: decodeHexString(c, "900d585848388e452fde7771408c5292645df462389bbdbb29cd1e2ab4f2287468eefa08b7b3bb69c26453bd47abdb91ba582ae27bb9d5243f983fefc62bc186584799963314d0f564ef36be638b1a64"),
	})
}

func (s *drbgSuite) TestHashGenerate15_SHA1_1(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0f3b65bb13f1acb3172be72edea5247c"),
		nonce:           decodeHexString(c, "3522f2cbac34238b"),
		personalization: decodeHexString(c, "d892f65f1949d280eecb295276b9c69f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "372c1f00a462a535c47a771b8e265358"),
			decodeHexString(c, "3062268c6109e92e964a655bbe3f9380"),
		},
		expected: decodeHexString(c, "b7bb52384ca0e607a986abac175ec272ddaf0530f241bda6ea7b54b42456569eccc025ca66936f2bacaee6df8c93f7c13a89bf3032b817464425f324ba1763ada71d2d83466c4f6931626482238ff21b"),
	})
}

func (s *drbgSuite) TestHashGenerate15_SHA1_2(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "d79c74c23e2e016f64bfa3ad5b351972"),
		nonce:           decodeHexString(c, "5efc54f323f2083c"),
		personalization: decodeHexString(c, "08e31c36e9296c6cc2a96f2fd539ae5f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "80540491eb6a5b39b079726a2d2e6ed7"),
			decodeHexString(c, "57d492f0b098ccd5810f9a6bc9f79213"),
		},
		expected: decodeHexString(c, "40a1a6f13f9e2c2b20e4be32e5162155165403e92ab8e4d5517b44ad6d24e0f7e51a970b469adb6ddb9870c11955746e280667185c5a5eb1c721863c22b260c2c00780020e6a66e6531dc714e883bc01"),
	})
}

func (s *drbgSuite) TestHashGenerate15_SHA1_3(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "da8b8c8a285dedce252e10eb803e9b90"),
		nonce:           decodeHexString(c, "477b9d7bb8f076af"),
		personalization: decodeHexString(c, "b7a6edb7ad251007c28b2d3330e7c66b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2671081c7cf3b20a65444c3ed495a8d4"),
			decodeHexString(c, "e31b868cfe2824135d1532f8823122e4"),
		},
		expected: decodeHexString(c, "602599edeeb4c86baf9479d4b745bd0f39299d2b8084f1f6df9f48eecd08dea98a8137732f08ae83c61b73ae5af095edf7caf112d98901622432b4f8d88f2e6561245652ef94b327faf9ce090f79068f"),
	})
}

func (s *drbgSuite) TestHashGenerate15_SHA1_4(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "4c49cff551db41e601bd14005c9090a6"),
		nonce:           decodeHexString(c, "7e9bf1339d18cb6c"),
		personalization: decodeHexString(c, "b834ac33cd97a9b506593ed59709e213"),
		additionalInput: [2][]byte{
			decodeHexString(c, "85649837db269104ef6a976738a171a8"),
			decodeHexString(c, "598238e90189d1e923ae39ee5e7ec2d8"),
		},
		expected: decodeHexString(c, "4c28991d91984941d126add74b463a8c31c8e0b66d12e664021671234d4946cd3e55f14d22506623165ba9d22c6a7f11ff2a12c626746f739d70c971d4d47f22976a0e8d06b93661350b43c6b2754a89"),
	})
}

func (s *drbgSuite) TestHashGenerate15_SHA1_5(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "65a08a98f1b632beda761c078d4a195b"),
		nonce:           decodeHexString(c, "b93a7d1a2f859cc9"),
		personalization: decodeHexString(c, "38bf8e9db845fb9ee4a4a50f6a14eb9e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "865a17d8b9f7f95a4b08bf94bda268a7"),
			decodeHexString(c, "7f18182a36a6cf7240337c4fbb5e4e72"),
		},
		expected: decodeHexString(c, "30e24271f413596f8cb0f3d37cb5d33fa5f1abeb08e5331ce6901bdbc1b8de42ac12e49bc050ebcff00b42b394cde6bef0993f002f18c0e68aedff969670f312b9cdd8359faf3e0c4de24ef9db613c98"),
	})
}

func (s *drbgSuite) TestHashGenerate15_SHA1_6(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "70827084cc1f48317e1c95f255837a3c"),
		nonce:           decodeHexString(c, "765fbaf6d035abb7"),
		personalization: decodeHexString(c, "a5b804296206cf3a7893780865643330"),
		additionalInput: [2][]byte{
			decodeHexString(c, "bd67fbd0cea225282dbbde85f9d85324"),
			decodeHexString(c, "55b5b415ccb031f6ca34c9d7713bced6"),
		},
		expected: decodeHexString(c, "2b8540e37c318afa95fc1e8d08b8d9ebf9e2b910f22ddeb5fbae4327d37cd98724dc95bf367e6e90196639bd21323d111278ca1666658ac1e55c7c930f85e773d37dcfaf591151ffec2729e36ec5fc4e"),
	})
}

func (s *drbgSuite) TestHashGenerate15_SHA1_7(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "39e794b3b956574adc9fa54001b2bad5"),
		nonce:           decodeHexString(c, "fc251a9ca81c029b"),
		personalization: decodeHexString(c, "7b564f1515461fa9ef7352a89ffcb98e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "249b0afda23f95f45cb51116923359e7"),
			decodeHexString(c, "18b4255845cd8b2f3ecd84f2708d6a91"),
		},
		expected: decodeHexString(c, "d5367e186259b8900a4cc2d08de8bb86503d23d8264252dd73ff9d21ce9cb5b465676269808b477b4b24a7231e5c8e31bf3a5d1d96444e8fe128cc7140213da67062660ba490b8e6abeeeb3381018f0b"),
	})
}

func (s *drbgSuite) TestHashGenerate15_SHA1_8(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "0e54fd9317324539b5f87dda8c5feee2"),
		nonce:           decodeHexString(c, "f66ceba0134d1392"),
		personalization: decodeHexString(c, "83ca3099c4fd956d69de1da9dd2dae70"),
		additionalInput: [2][]byte{
			decodeHexString(c, "604460201adba7560a9b7fcbb2dab345"),
			decodeHexString(c, "911ee9cfbab9d8ab26131593b9a974b8"),
		},
		expected: decodeHexString(c, "5598424e63e74429431ad9a07df02704754ffb9b304d2893d02ec6b45f335cf0663e865203cf2f106c1a9472e60c0c0631a96fd3856255ac01ddb94c7d0a235da604e46c19decfd00834a463ea270657"),
	})
}

func (s *drbgSuite) TestHashGenerate15_SHA1_9(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6b95ce60fbde0b7a1c084ee9c4c0ef3a"),
		nonce:           decodeHexString(c, "bc55d0d73df2016c"),
		personalization: decodeHexString(c, "54d5952c46fccb8bdda8dec9fe0f4420"),
		additionalInput: [2][]byte{
			decodeHexString(c, "eefa1d450f09445e372f30c8e7d0f306"),
			decodeHexString(c, "160ade5d9d4dfdce0e044567a8bac002"),
		},
		expected: decodeHexString(c, "2a7d8d1d248edd67b80b636c22b5ca69e904cefca340bd8586d17955c82d7729bb243b2c1715074d856597406b86b925818724237041127e6728fe3080a43f6955019e10a0e9b4b65e1de655d2621160"),
	})
}

func (s *drbgSuite) TestHashGenerate15_SHA1_10(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "83998366ce3e12202f20af4c355679f5"),
		nonce:           decodeHexString(c, "4db83f885fcd6819"),
		personalization: decodeHexString(c, "6e69e4ad38719f5a36f624e3766ffea0"),
		additionalInput: [2][]byte{
			decodeHexString(c, "4ed8ecc9a49fdee286355b494af86d9b"),
			decodeHexString(c, "c1e79feacb7575244342e0183d25456c"),
		},
		expected: decodeHexString(c, "ba1b0c908e3015bbd805dffc803bfa93f1306d30dc7f05d2d4e75d3063371b947ed7ec98c24c9e2de43b37220f85af7d4ad26388948693358da23bdee6f225e8776905da1c24b0f96125c081a90ce7cb"),
	})
}

func (s *drbgSuite) TestHashGenerate15_SHA1_11(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "2a400808e03ced3842ba1eb3f1575fe6"),
		nonce:           decodeHexString(c, "c6b9b8c333063c4e"),
		personalization: decodeHexString(c, "4424f53b70a4f48730f812b3cfcf539c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "665c1718a488186e3f7d0bb696762aa6"),
			decodeHexString(c, "b6d13ebd7209437ea5faba33814b2c74"),
		},
		expected: decodeHexString(c, "2dc7a954ff439ec8108b0649acd3c5d8b2e28c8804cc9d249acafedc0ef81aab1caec356cc50c43b70c1fe4dc117290bb0648588bfe84c9b839640c1503438765cedb0e589cd13fc8cd80bd96ad19c6f"),
	})
}

func (s *drbgSuite) TestHashGenerate15_SHA1_12(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "6f7a7d94dce02590e790b971af9d4295"),
		nonce:           decodeHexString(c, "d742b2e7e6100044"),
		personalization: decodeHexString(c, "b9db42702623c750b8a56f87e9b86ce3"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d8aa1660026346b64c73042ccd7be911"),
			decodeHexString(c, "b842d8105b29dcdd493b371bfe5fd9d9"),
		},
		expected: decodeHexString(c, "5eb008c4e9bdab611628ff587411a8262c2758958103bd266aa1af386ebc70482481dc8dd6a253222e34444be45a6aa231119987379bd7ffc43f7a4ab793d1fe90855264f1f94733e424dd97387a180a"),
	})
}

func (s *drbgSuite) TestHashGenerate15_SHA1_13(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "5c6aed6f74cc302e86c504f0586cdcbd"),
		nonce:           decodeHexString(c, "e7cc8cd44f6dace7"),
		personalization: decodeHexString(c, "771141d942658fe4d658f4a8af0dc471"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5d7a91e18f88bd509a6a0d590e71c761"),
			decodeHexString(c, "d46b57fa51a421e25aedf111157db8b9"),
		},
		expected: decodeHexString(c, "ad1ada8ce79045cb24748378b4c4629dd908058377502436e6de51b8dbbd70d721e804955a1ecb02f8b11d1d44d9f5011808c56a6afe94c77c15319d8e1f48c50234d13228fbc84e13b4440eacf4cd21"),
	})
}

func (s *drbgSuite) TestHashGenerate15_SHA1_14(c *C) {
	s.testHashGenerate15_SHA1(c, &testData{
		entropyInput:    decodeHexString(c, "b30ed321b4609c2c1b51235963958ea5"),
		nonce:           decodeHexString(c, "5bf9bc2fee575eb4"),
		personalization: decodeHexString(c, "8fbd86da0724355a4059f6ac78fe6342"),
		additionalInput: [2][]byte{
			decodeHexString(c, "fc54b5339b37eb6889cfd7c185070bd0"),
			decodeHexString(c, "f6a783d6d42e5ad5abb0a996bddfa04c"),
		},
		expected: decodeHexString(c, "683faa732c4551604c8865b5f777571c7d3cf1a60124c59b91283da0cda9b21761d1c17c81856958c6d590436c73594bb36f46c2f89237d8c7a7ddd2c58394c983f8f6c000d77566f2a1d89bac054bdb"),
	})
}

func (s *drbgSuite) testHashGenerate17_SHA224(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHashGenerate17_SHA224_0(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "57ec3fe9533e71f46cb381364c7e7bb3be15c16b8a484a80"),
		nonce:           decodeHexString(c, "0588d36a9b96207b3c169500"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e557d72e18467da1256c35ff5f04ad049ace3a71b8149b55"),
			decodeHexString(c, "ff296d65a9733440c2970f2eb0f98b52500d5d87819200e4"),
		},
		expected: decodeHexString(c, "b8110a77cf2a6d5bff616f13d203c58b1c3fc982c2e6d1717cda266be36bfbddc4680e6881244a92b2a9eb2fedde45e70c8236b20ffc507c8b34e6b45147f85505f9237c23d5b6bd9ce2e69ef559fb0a42e26c42bbf64cdf4d8ae02b9e7e033abe49bde1a49f857565b1b65d66dc8bfe"),
	})
}

func (s *drbgSuite) TestHashGenerate17_SHA224_1(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "3fff3ced5bbdd110846671b7c2bc239e9dbfd08a78906564"),
		nonce:           decodeHexString(c, "d4009d747d5e191d91c710eb"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "4964ce869e7a9a0e8be86da8999313401308b979c2ca07c1"),
			decodeHexString(c, "a35e6c2fd6dcd49cef38f8023255822f82a825bf5d4cbdc2"),
		},
		expected: decodeHexString(c, "e4feda7a2d3a3bc9a63b16dd48ebef84503656a5a712312f8cd18484d89ffe2e2db35b6da23ffc6fdb885a37fb594d40a5952916d909caaf4baa422be7f604769d70d9134f09ac76666f90897e390882001f4a5dba98fd6e3c5d6ab4cf259be6380b11be2f64158650cd03d28c343f0f"),
	})
}

func (s *drbgSuite) TestHashGenerate17_SHA224_2(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "546d1ddf61bae1b0d070dfdf14b9842296136b9905db5f7a"),
		nonce:           decodeHexString(c, "9b567c2c99647072a2f36f9f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b47ea851859a5359a4016557d3e400b2989d31adead62642"),
			decodeHexString(c, "5c7e7e774dc0bf68e5fa5e8961b1dbb88f48be925e29c524"),
		},
		expected: decodeHexString(c, "63478e622e9ec86597f757a0453d0d79f3328dfff8606635afbd48d0930c44cbe067eeff10cfd56029236328685a7a3d96c8a84145a648719130239db0425f21845669b9cb1a114f3fc532e73818d0e832ce28c945c45d9dd7463b76696115c3afad89946e7bb6096d61c77ca2d0caf2"),
	})
}

func (s *drbgSuite) TestHashGenerate17_SHA224_3(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "6bdae2c75a1b00bc5577054d425835f2104c57f73bef9c75"),
		nonce:           decodeHexString(c, "208ffc58c5562e8fedfc6405"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b9c029bd7716c56b1d15c34de531344b80467abf2a3ac1d7"),
			decodeHexString(c, "8ddfad16dea80d45620f58b791b0e4efb6b06fa707103fdc"),
		},
		expected: decodeHexString(c, "e42b3c5de8bf00430e57948a515f59db11f534c5c680b9ac0c6a960c9c9a4b6c2ecd3dcf28bc5e421ae7c0dd00e5b917420d4960cc4dedadc2ba576bcd4626ce08439f747b7e192f167e3a814a59ebf78898c2e5fc2d8ae2618f0f36778a9793dd120130423f09e7a51ddffcd3ba7083"),
	})
}

func (s *drbgSuite) TestHashGenerate17_SHA224_4(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a7050ed64ca3be6100c29d7412be192e2328bb4a428f9817"),
		nonce:           decodeHexString(c, "87f1be6e98a5fce717865a5a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "62782544d2586a307e8a93815d3d0c0f37bc130fe6a617cf"),
			decodeHexString(c, "4fae0a45436047f36bd6871873995e569f4f51f8bd78223d"),
		},
		expected: decodeHexString(c, "837b99c913c8c876d251c81541254c5d9955c8df693a9a09ff485ec1c5edcc9eb58bec7fb70bf01ba15437d4fd6514fbdef0551bdc2862166231c349574094542145df5afb2394d46f089cb6971213322526339b7a9b82d2b42ed53f9415319a6255bf7c6a9f973fef0c598599cc0e4b"),
	})
}

func (s *drbgSuite) TestHashGenerate17_SHA224_5(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "6cdf34bfa839e52c08ccfe7dc67e28b1b6a6eba76af69d1e"),
		nonce:           decodeHexString(c, "6881cac7d7bbe9d5e5cc506e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3a4e7355f1edda2ec1f04c20360720aa98e092c85d0d1497"),
			decodeHexString(c, "7c669b1ac5529d08bdbe63420fb7b3c4f57b2c489a92562f"),
		},
		expected: decodeHexString(c, "4dad4488f235c6f3764bbddfa9584ebf3a8f9532b32fa2cb7ad84a65aed9fef6883688e8d4a404e1b6e59053de30dd65c3b1afd12bda2e2c81a8cc18d13d927499e6e471b730ad366f1b135fd4d97cf8f2132f7b966233894cb6397a435e516ec2ae26829839c0ed5e58960cc13a886c"),
	})
}

func (s *drbgSuite) TestHashGenerate17_SHA224_6(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "faeb44374a731c82fb796f679c137d360e905978b4ced587"),
		nonce:           decodeHexString(c, "0167ca06d311d149d6ed2f30"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f8481def8df17524980aff55d653a1c221baf18206edbc70"),
			decodeHexString(c, "16d5448307898425cb1014d6a14e641e25184ed2d2d3dd3b"),
		},
		expected: decodeHexString(c, "7a942785235544df844c6c3033e28a0298d0e64709efb36d3d8e9d3da4b1997dde9cbc58f6f0463e3425836d301960096eb0fdf6ea523be33ba35cedf9851955eb337dc06ac2bc67939da433912262f10670fb75583d07e848d8ed7ad9509b40b88b4fab9b1a4a70858b62f9618d42d8"),
	})
}

func (s *drbgSuite) TestHashGenerate17_SHA224_7(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "509d37f3cf2d564ca35083a8c823dd498f36de4858c9cc30"),
		nonce:           decodeHexString(c, "0921aa137edf66b88398788e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "949d1399d8852a6ec8edfd205b5c8dd8b5560306b3299bdb"),
			decodeHexString(c, "49c7c7774b4edd529d3012b25aec554c26f7247ef62b9f41"),
		},
		expected: decodeHexString(c, "374fac9f78c78e0a9a00c9ef630aa725d7f4b663549ee32a91317a66762032e6bc2e65c8f121f9ddf85276d1205b4c0bdd3c9c672ae287127f15a5294905fc508f18eed03e2bb0a7deb87cf6def9e558ee83c909b348457582877098cec55f32f8996cb97a7cb477db51c48f75f93b2c"),
	})
}

func (s *drbgSuite) TestHashGenerate17_SHA224_8(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f0233dab01ca210375e0691d710e278bc094e0da74e28a11"),
		nonce:           decodeHexString(c, "22a3e5f5cbbdc0f02fdde2dd"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f32e29e5416591ef1b0793d90931284733965d13c10604eb"),
			decodeHexString(c, "1f319ecceb9da477a063f53415e477217af5426d2081e0a4"),
		},
		expected: decodeHexString(c, "ffb6abac49d5222c54f7445e7c2f96ded4a9b33ed082e6b4eb29098af75faeaec618c08ed4b1b8e9851707e5bd74d626aa0c7a473c6b225597fb986c0a84d1b4db05b2eff7574e7f8daf9165621408fc3c70ff143a1d30bfdfa6846a9430f46c8122fc61925bc4d3389203f8c9d49677"),
	})
}

func (s *drbgSuite) TestHashGenerate17_SHA224_9(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "371141411acb60ce353a99001a34ef64ecd08d9c1a3d94fa"),
		nonce:           decodeHexString(c, "20e31c5f4642f3419aa6572a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e7bf563c7481567cdf750b9594bec27a23d9ca1a2afaf121"),
			decodeHexString(c, "ef60f08d130484bed0259c3afa1ff13ff8560fa9209bbb55"),
		},
		expected: decodeHexString(c, "670eac12513e54bfe7e972b98376e3f3af484e74ab9c8b254562b4d80ddccb749e429f13cd2d2f891c0da0d7ca82ca0c3e73e23f9c445b2243f0392690591e399f7a6ac93ef811122e0ef143ff712e518ff48b2ef10752e5c0351346f7eccf431de77f2da8024c03bec3e7ae2d6249ab"),
	})
}

func (s *drbgSuite) TestHashGenerate17_SHA224_10(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "96e47d26fbe063fa5672e45d85beddfad1bc8400927595cf"),
		nonce:           decodeHexString(c, "cee03bd6ccf68cb43339edc5"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ed1b0cf1cbcbb1db11325d0d2c42bb4cafacf52d48a90bb9"),
			decodeHexString(c, "5eeaa3791e518ad39d49d6feda6ed8dc8b745b1dba128c25"),
		},
		expected: decodeHexString(c, "0e9e53b9a3755455b75002797ae1715bbd593ed3b0aac423916da5048ab3766ca3274e715cc739e1d8dff93d3eb5eb41006b362528f38eed8d65ccbc48c13e4bbe8501d36cf89caec78f306442b4c84032fe2688dc453fa3a5fd5ee388495164694e5af82548d2f35c82e21509408faf"),
	})
}

func (s *drbgSuite) TestHashGenerate17_SHA224_11(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "39089d3faf3c4f562ba15c8a87b533b792edfda4b70c35b3"),
		nonce:           decodeHexString(c, "6ca12a4ac1957a25bd2d72b1"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f1325d8cc54a4bd472e47a7f298d8f87b5d21522b733e85f"),
			decodeHexString(c, "cd3e29872c0ad0ca42e988a1e7b2dc1dcaa969de8a1e7612"),
		},
		expected: decodeHexString(c, "18f69df6dcd8e5a13c55c779f78381e501a7a59e1add9cccefd95866ae464e441c16cc538a8519ae39373b476a90796c6fa0f31d9789a857c2c2db02e27197f28571aed511c97f2fed2871105c2ac76b7382c563caa78177f8b9ef481aa04773ae0705ee1f71bcba2c58db671f77acb6"),
	})
}

func (s *drbgSuite) TestHashGenerate17_SHA224_12(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "29273551e60c507b97ee3321dffa92b05e47e282bcd47bd4"),
		nonce:           decodeHexString(c, "684db0cc7665a4f1f64168fb"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "878a46b06144e8a32afc3f31e8c5718cc6601504b5580053"),
			decodeHexString(c, "f7dfb4c5acfc5310a6c50e7f2ba088b71f1cdfba13331219"),
		},
		expected: decodeHexString(c, "2a31df52695d478083c5dea78b0ae1bff652c751eba47a48cf921b54993d469b1a31d96abdc3d63907b4cce9b76ea6a5322b1e4bf6c10956cc104a950cb1991390374bb8c6e4eb4c370300a59138602768654c2f98f3419cc76c95253a1e4fea1b92a1a57806c492553f6d9344e16767"),
	})
}

func (s *drbgSuite) TestHashGenerate17_SHA224_13(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a688e1931165bfa1a3abe9a05808770a5794eb418ca09127"),
		nonce:           decodeHexString(c, "8484f1229a5ddc11d3db57d6"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cd41c2ab3a6927b0e69f603769d76b42ba4ce0a5c91e989c"),
			decodeHexString(c, "3505ebea09a6d420186202e06bfe1bebdd642cc7bf22234d"),
		},
		expected: decodeHexString(c, "d37da943810b389e6675179f960b1c1d6f59ea87f3f14568fe53ce0885e8ef34f3384fa840742a9164092dcfa719e0372f20c905694a15b97667e16c9bb88c66e3b94cd0b41e9010730a60d6eb48ef61e287e71128d7e05e22c4bd3480f861bef7221468638502a4ce26f2cf5a015ca1"),
	})
}

func (s *drbgSuite) TestHashGenerate17_SHA224_14(c *C) {
	s.testHashGenerate17_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2a9ed97cbbbc782ff8578faf135881d22ee08aea73b3d920"),
		nonce:           decodeHexString(c, "024d6781b3bd41c5f468876e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ae701404440c584e27266a12318c1793b6a112d96e6a6749"),
			decodeHexString(c, "53861747c9627e9244679d58e2dc8cfd8a72d1bab611dfd1"),
		},
		expected: decodeHexString(c, "665481033912ca7d87caa56af2612338768b044953b02b9a50e0244bb805ca007648f71ccf923030e56baa13a88111fe211091a54744aa5d82abe97775878059dedc6272e7c7a5392d1fb443b770ee7f5dd05a3f2bba4cab1cf473d02648d4f8acce91ef167e3ac00c1c9324ca074486"),
	})
}

func (s *drbgSuite) testHashGenerate19_SHA224(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHashGenerate19_SHA224_0(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1bab3002107d7de482ddbd21bd1ce935167214236c92e43a"),
		nonce:           decodeHexString(c, "4a7b14930f5df7b3bdf07054"),
		personalization: decodeHexString(c, "4b1a3411df2fba9949d7b700f3eb75beb34262aafd674e9c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7f1eb4bd7ec9b4e59a0fc53a02a95170021b5776f7285d8c"),
			decodeHexString(c, "6473fef885a0da4788045f51cd66abc76ee052f1dbe5a30b"),
		},
		expected: decodeHexString(c, "e0a42484d556ad6b20bb2dad3511e66aa2805af76174a70632ffbf6d52f157039dc678698ee72aecdbcfe4fede4fee9d60dc38c6ae8ec97966dc88051499cc3a9ed58bd18d61f7cc64c095a2b49a956625c507a04888fcc2e19ea2c285be0b821c3862914bd620193f5e26eb81e6f2ca"),
	})
}

func (s *drbgSuite) TestHashGenerate19_SHA224_1(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "30eec7225472ef50584745c4d676b61200ee836795f017cc"),
		nonce:           decodeHexString(c, "d761bf03df1cadd9bea7be70"),
		personalization: decodeHexString(c, "002a1e6b9b5ce9815f73e982394e59c950bbb24d206a6c24"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e7f188e48df3b5ca50b708b5c84719ab27b1581252fccf27"),
			decodeHexString(c, "f88d3d90d63cc742d910f99f5ecd667d6015b85bfe221eb0"),
		},
		expected: decodeHexString(c, "e15b37d524a96b80df3760f34292ecaf61058ef149e07f703da7149400aa6d99c782fc763bad6c49e30c6979d759f91440dba1caf411a691de73514919e9e6102a3dc766c470181b10c3d4345bc1325cca41aa784456f2fa78d5861c591b4adb749a6d97be96433aca16a0e603aa3530"),
	})
}

func (s *drbgSuite) TestHashGenerate19_SHA224_2(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "72e7883fcfccfd62d3f2150fa08ee829c9c52356aec67541"),
		nonce:           decodeHexString(c, "001df146cf34d5e2e595a710"),
		personalization: decodeHexString(c, "865cfe82eb7c484811ff8ca0788689dd7bed895da4df4150"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1e7ef4aedcba893a3a064427fd2510a2d959648997ce0834"),
			decodeHexString(c, "940d31590fc49c73a386d8d0f3f1eb6c0eb2f27071982612"),
		},
		expected: decodeHexString(c, "29125118f209ced4edce132adf6c303924751ece992e4d69fdea39f41e2ab70d8fac68c6d97dfc2a85a63bad2e224e1f2862533a69dd0991b322a8380be33a3bcad0b7e157d794922e107a8fde5951642b05f6872409aaf7c33647e0efd8d3e413247ea2e1814cb90802d244894a7d9c"),
	})
}

func (s *drbgSuite) TestHashGenerate19_SHA224_3(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "61bd2985abde8125847f20bec4aa48a5db010dd7a30df85c"),
		nonce:           decodeHexString(c, "e2e2f42a84a539be984d2943"),
		personalization: decodeHexString(c, "3028581d08ce2ece9f3aed84f39e74f91c6fcd255302e8bd"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7166e72914bc5e7e604a4e0676efbda668053ecf17ee0c28"),
			decodeHexString(c, "f7ca28589b5a3d8c4b951858c252b9982bc7db1e2d0d7692"),
		},
		expected: decodeHexString(c, "ba9ab80afd33c4ff09192a41bad9bb631c3906e80516a291beb9ff3e094473a7f67cd3b24494c3b8a27b5418948802d091f591400ad95223fed1fe74ef0047b25da08a1a6a292213fd669a801f732cc1b3a3e37c948d12746e2efcec25eed880ad1284283d82b996da95907d137f63d5"),
	})
}

func (s *drbgSuite) TestHashGenerate19_SHA224_4(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "63f006ddd4457b36ad98266c409843bc887909e91a08cbe4"),
		nonce:           decodeHexString(c, "78befcbb0f4b40c7f8e05e26"),
		personalization: decodeHexString(c, "9421617640fcbc98a0c3af2ccecc47f17a7a25d215404c0c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6690de079871e452b0faf6d4bc2b60ca0e94402a15d81407"),
			decodeHexString(c, "910976d3fb6a72a9ba8e762ababca95f7e2dedc4722f1b2e"),
		},
		expected: decodeHexString(c, "0c127ca482e866e0002de04b89dfa4da737758e2f86e59d8e38562515b366b8150c4c9aa760f7a990f498283a8376ea9864e1c12700748f3aa7db8a58ffc2968e4e3b6db7a30a0cfc400ea1fec45bb3ed47e63aa757b16bb3d83c51094847ecf9986b600f8f8e6c8f2d71c09bd8c0c5a"),
	})
}

func (s *drbgSuite) TestHashGenerate19_SHA224_5(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "919ce30cee5673cd5e370193c82ef302042e6a086ce3e417"),
		nonce:           decodeHexString(c, "2c5a8c562f49ca60ea2b8a08"),
		personalization: decodeHexString(c, "2e40eefddaa7264bb7862ff29749b30dc08dd0a6dea87aef"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5a291bfe3f658ffe92cea07cacb7da014d9a1abc6dee4f8f"),
			decodeHexString(c, "d1a0305d91ecb9e475ebdd79456c918cc42078b2ffc8d1a9"),
		},
		expected: decodeHexString(c, "ba9f67613f729a4c439f7f3d8ec243aa6a93f0d24a5193790aaafccb5884492e97c659c639fcb9c1645139b9ff59ccb5e6547d5ef6d0e9677a2783a4b92fa908393a899acb10140c127da125368f5d2d33db02da4f7853d893c0d796b9610b581244f8970493308dadd393b4dda24201"),
	})
}

func (s *drbgSuite) TestHashGenerate19_SHA224_6(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2e1812a26b9f528507703f924c4e90e0177d0b840d8d7895"),
		nonce:           decodeHexString(c, "f5f4941005232e4e81a5924c"),
		personalization: decodeHexString(c, "982d33bebaa6dbcbe340fc9491900bf630db8623f5e9018c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "726c5209a537bec66a88633821fa9ed20c1513343f138219"),
			decodeHexString(c, "16708e9315e047dfba2a09cb6e470d427c30364a57f0adfe"),
		},
		expected: decodeHexString(c, "bd8085cab7335324cb5020fecdca1ae30959f9ceca2cc165591e699450cb28fa31130a3055658dff122f8b51c571eb5b32b9c6e3950ab93c9f8d25c83dd591e31dd73c3fa874abb6942c450d95b352214e480943ae6d51376b8fe08c9a6af0d231548085fd883a35a5c5ceb81a5068b9"),
	})
}

func (s *drbgSuite) TestHashGenerate19_SHA224_7(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "edf886248c36776c68f61ad1c503ea221cdfd5f5b46c0aae"),
		nonce:           decodeHexString(c, "86de752e8a66db374cf4dd21"),
		personalization: decodeHexString(c, "b1ee07f1b27c5095020761e95b5797136b8e4007ea34289c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c0e37683ffa869f741d7780d3b91f6581053a3f776abcb1a"),
			decodeHexString(c, "cc5c7eafd69ebb7f53b95a9c4898bda0a806e33fa7a8199c"),
		},
		expected: decodeHexString(c, "f8364516bd1caf2756d3fe58d28c63aa5fc938aa5c81cf5a391fc0534777b177bfc81234fda0f8c48329c8abbad50934d239774ef578af162a1ab8521a05fb946faa8d00c7d0aee59d20514bf0bf2f34a2e8bd8af00e41485cb980b93f3b23fd3ff369e73a9a7e8e5c51bd5ddfd6a3c9"),
	})
}

func (s *drbgSuite) TestHashGenerate19_SHA224_8(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1bb6659bb07dd8f917d116c7fd8f70b9690900478dbfaee6"),
		nonce:           decodeHexString(c, "6fe8a574a9c3b861cca7237e"),
		personalization: decodeHexString(c, "feb686a43fab38860c78782b7af6d6f84a5c0605746858cd"),
		additionalInput: [2][]byte{
			decodeHexString(c, "bc345708d16a151117e727245a77aa7876950fbbb93c191d"),
			decodeHexString(c, "aee40ac3ea5092a0e5175bd88394c8a7ecb918e2388fd392"),
		},
		expected: decodeHexString(c, "a2940c974731dc62f488da42e13d393b7245cc9b2421de67f1bd50cd369507f157095c6a93753771aee9a97963319ff00fbaeece28a18aac7e66f697957d37a74cdcdfdfa0c55900980224ae59486b3d14b9c5ef0c9932c78aeeccd883d4fb2b7287fc4220423f635b3455e6bcad9f82"),
	})
}

func (s *drbgSuite) TestHashGenerate19_SHA224_9(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "19cd3546e81906f47be220bc0e61a4a3ee2649e2892ed9e9"),
		nonce:           decodeHexString(c, "0fc41524fdb61c7446c31d06"),
		personalization: decodeHexString(c, "e4debd11929e7100f9717d07499b3d2b42294b4e1aec4615"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d18658bcfcddde258981445127414ada98f41c9a88cab369"),
			decodeHexString(c, "b88b9ad3d560d9ba8d46d1a75c1c7a1d5a849bd8b60e5864"),
		},
		expected: decodeHexString(c, "e2629e998c4abaa06414918ff0291704f7be337583e925bc157d109fd414ef1872bcb581946715d6fc5f8e7589075856cb14bd6e3fbf3f22655102d567e95011697912a1e64221db9bcc6ece8e4d3c835d56fe95246a499a96495ebf1f10f30261f50228cd7e0f7190de8bb8c25cc4fd"),
	})
}

func (s *drbgSuite) TestHashGenerate19_SHA224_10(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "570832676dde2571c29d228aa10194b98fff4d22113ac6bd"),
		nonce:           decodeHexString(c, "cb20bf3ead7dee58f872d72b"),
		personalization: decodeHexString(c, "0ff90aed77f3aef768f662a7f178502c797a1e84bf724144"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0d33b4e282e686b1d3c892d5d5899909aa2b4332b76a57ed"),
			decodeHexString(c, "b499be360808a6651cf393389c6035a18e300d2caf80af63"),
		},
		expected: decodeHexString(c, "5ef31ceee8f12bc07a2f121c52260b2686e79e4f617bb9a8569f672cf569c45680ad360bd49443cebbbe0bbac5ba9107e5056d62050a9c6f1000d0b1ba3c70e2379c276e11aae99d425c61330d7994812e6e3f242511de45715df5f41e92a2a4b9de3296b77e0e2f94ac06f81d59900f"),
	})
}

func (s *drbgSuite) TestHashGenerate19_SHA224_11(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "420014f2d7fe3e8f0e18853aa883d5a3790ad462e8991041"),
		nonce:           decodeHexString(c, "fb3c1a7dc0d5d5e466d79f47"),
		personalization: decodeHexString(c, "c25b761a0368b5b157cb3de8717e7a49b548da3c286695b5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1cb26c9ee6a57408e1e97c44f7f5d7ad6df1fe72720e95e8"),
			decodeHexString(c, "230df1b947f49a4af8d50b6476676863391c388d37ce8250"),
		},
		expected: decodeHexString(c, "ec50603a77e6dd71131eb84f1aa27d767344627ffb2fc372570cbba13b3dc5c9d1a4273ca27aeb58a685268da846b0e48cddecb48e52e659d6b30330cbf18cacd7e95ce9bdaeb95cf39b57fb7100bfbd56117e4c8525a62540c309a51b0d3ed407c4450baff058ff3bb482e17deb166c"),
	})
}

func (s *drbgSuite) TestHashGenerate19_SHA224_12(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0157720fd6d573a9da653b99af202f9f8e28e386aaa3044f"),
		nonce:           decodeHexString(c, "84c575d3bb195163f003d739"),
		personalization: decodeHexString(c, "c9f419dd3684262d3746012a42419e3d3024dc78d3d2779b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "dafe211b9a53b7ea473c235e5dca0022d10d7afa6bab46fd"),
			decodeHexString(c, "71366d7acec1b4d80ef81ba514ac572f897f45a0e729ae27"),
		},
		expected: decodeHexString(c, "cd9b74d1c8f1101e88621f9df4bf4d2b41d06db74af8bb221d1a5054cc296b3c2293301e32bd20db4697784129308d366f210adb46f451ab720ef729f140cc712d98e4c07e23f25fa4255f11f840037db870dde814d002f35a5232412370c28b28ea001428550d836ae0999676370eb7"),
	})
}

func (s *drbgSuite) TestHashGenerate19_SHA224_13(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "4f9ff2ebf2a5493ab6bcc882d662108c4eb7e23ea2aa9bf3"),
		nonce:           decodeHexString(c, "3ecb528e7757a8dea6a69f49"),
		personalization: decodeHexString(c, "e9806c7050d4eb3e23df8301598e848e5784b365e39ccc42"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d0c111ba31c992775d870796e9f7cdb1dc84cd8264f21467"),
			decodeHexString(c, "5ce7aeddaff0fc56490cf5e167d6d5e936d1dd1f2691058a"),
		},
		expected: decodeHexString(c, "2cac8f376d0e0bdc23f150a3d7970142eabf2a5096c3b2578946997ba66bcdaf9b5fe0d0b907d49ee86855a27c9c8c8ec0d5a630ae2b2f35ebd9f0031d497b3655da00494b93da98f82b43c4b8ba223060c577f27d488c48a496cdc5827c106d116a8d291a2462493ec45eafcc68b810"),
	})
}

func (s *drbgSuite) TestHashGenerate19_SHA224_14(c *C) {
	s.testHashGenerate19_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0d2514fc19a6be4bcb424115f4a4f7e0601b11042b535dad"),
		nonce:           decodeHexString(c, "b84f6a9f408d87d6b932b127"),
		personalization: decodeHexString(c, "316764260e00d8e4b0a08969b0e9ed8478fc85e26f3b8e9c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6a7418d4ffc40e11859f33189d5a8327042ec268b004ade8"),
			decodeHexString(c, "97beb8c47434a23efe536287d776edda7ed7cae84c0c7e35"),
		},
		expected: decodeHexString(c, "1fe94acb5f5cb7e4a8edf5be61673bdc066288538dbd0ac29ce2d43f7b890028e48131e6b3a7cfbb42772b63f2fac8c0472418653ee2ebcdfa5ec08683e7d4a9cb2c67cf7e22c2ddc779c6d9971b29347e6688113294c902a5d62c1fc35595e091cb10e5a895d7c3697056659ae457d1"),
	})
}

func (s *drbgSuite) testHashGenerate21_SHA224(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHashGenerate21_SHA224_0(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "938caabfdc9309495fcdfc44cbe9842767c0ee5f46008c8e"),
		nonce:           decodeHexString(c, "611843a74d8dc052379b5b7e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "87b5ee416834f5ecef4c44e2f793c5d57fff283b7abe939c"),
			decodeHexString(c, "b12d12ae51eb9b13b6ed70b5ab2bb66b4e37e423d7656a91"),
		},
		expected: decodeHexString(c, "a67ed0ca435774a863d01e01d85a12d5bc5c0974f13a1435d06b1cc47af47039f36cbd19a0e34b441729c4190796ff70deba9d6f02c1c6972178584c7638e0004bfb2f76d70d9aa69cd34c6ac70a5b71fa2dcf9830e50aff7d30f828acc7736fe70528be85a8e38313504b0277cbedb6"),
	})
}

func (s *drbgSuite) TestHashGenerate21_SHA224_1(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "5da96699db3f427d93a7ecc7071de112639b3c931cddc43d"),
		nonce:           decodeHexString(c, "7915faf89645da8c5767f564"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "eb37fa58900ada7428d21b515be543c1f619ceb6bbe5d28b"),
			decodeHexString(c, "82432e8cd090dba93d57986f1a02b20c8c11dbb51135566e"),
		},
		expected: decodeHexString(c, "db9235843239b85b7cf1e956022e4c2203b7e44070c72500866ac3d5c9e140c6aa0a397403207444adeb58cd0cbeac1abe815c858537c3f09a0305e0aac599818d70efb3e20068af159d902a1ce9f191b91bd5cfb532f718095fefd09701089d73e7aac3ecb58a5d1a0cf07396ed906b"),
	})
}

func (s *drbgSuite) TestHashGenerate21_SHA224_2(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "8afff5cce17d445a3be8b01b9a32ac7b7f68db301785684d"),
		nonce:           decodeHexString(c, "f766c18b867a77f5902d32ad"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "fbef49b8d9eb99b7f1a70f8e5aabe341d9f0a8ef026eb1d0"),
			decodeHexString(c, "dd46cc6eb0bc8c9b26a895e8ec4d042db035d0f38cfd81c5"),
		},
		expected: decodeHexString(c, "0a2680918a97591d11fdf5f4b268487696ecba630d52b13db834a4a15f9debe46dded68cb4056e8ebf31b334b8e22f8ddde4eeb23971c21144c929a5a3cfbf920f586eca7d3a0bcc6d889acd894da3a82f8ba5c93e2c5832bf6fe120eace55b8fd3a632e99dfe8286f8faabca2ddd362"),
	})
}

func (s *drbgSuite) TestHashGenerate21_SHA224_3(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "69f89bae7ba220ce4611288a90b4aea5b0475715f1c757ad"),
		nonce:           decodeHexString(c, "19e4dd98f33b3e9e23d9b0ca"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d440c43db22b6c0dc8604379ade4e74f87b23ef40e7aef0f"),
			decodeHexString(c, "e7f81b34383d6c22d5a419695444177e11afbf7312c84f5b"),
		},
		expected: decodeHexString(c, "8723b8252043c6556382257872461771c583f1874b74735207b4ced3ff66f9e12efec90693fcc6e50121dd0a5fca9ce490e2f5be6c61679d24db892b28cef2acb73f7e3d696fadbd02c87a476e4c10b46b7d5d5c8fcce53e1148f88da5cc47a5641478915296f62f05969f039e3289b0"),
	})
}

func (s *drbgSuite) TestHashGenerate21_SHA224_4(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "47808d81119c7a2d2c299c50080d7dae57c599145553087d"),
		nonce:           decodeHexString(c, "b1d1064765de807691be89c9"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "bbcc725e6131b463e93d1b00d240b15c022da5c8d3395970"),
			decodeHexString(c, "6479122c6ce7da9e736bc58f69b132140586d16b4ec9ac42"),
		},
		expected: decodeHexString(c, "9c6ae442048ad9d8dc62c40840f7dd7db8d4ddd43ade18b9f6b0b83ae7bb3a6bbe8f5073a15e95298ae683a823fdcc466773e725d05c327ea334d96c9ea57a883b6e46356f6552a9c2d941d2af497d175f551b764fd5833de092c66e58cf2cca07879d768851abaf2df8ffb3995042b8"),
	})
}

func (s *drbgSuite) TestHashGenerate21_SHA224_5(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "aa5121e4b43e8dab0fcd714cf8bc8ff4fc99bf472f077478"),
		nonce:           decodeHexString(c, "dc8bbbec75d23286dfe68162"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ad667b7251c0fcb2270d92df2853580d4e2f7e05adcb3add"),
			decodeHexString(c, "3a9e35c51e134cee45aae7307bd9413e3c622d7750a58231"),
		},
		expected: decodeHexString(c, "ae2f72ff6a30cd9b823f618493b25e7eb9a0d986f0bf722e79c0a798d2edbe51fd30a1114788afb477a72d946eda35000bc918e8588b37d1a334398c57bcdf3000f7bc0aec42bac791e786a8926f64b6624d753216fdb9d5e6557083e221d3d777002c72236a9f732c119a76dfa422af"),
	})
}

func (s *drbgSuite) TestHashGenerate21_SHA224_6(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "db0f7af8b2ac81e74489eda4684c44b9fc64b8a93f6edfa2"),
		nonce:           decodeHexString(c, "e6e00ce5bb343024a42da740"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "92468d0ff72e178452b3cb8dd41afe032193180b1fa32aea"),
			decodeHexString(c, "350f5a101f6a739b987cbe87a7654e911094b8a76de05059"),
		},
		expected: decodeHexString(c, "a6dc5dfd703c5c82181d5f7c06ed42db88b0d91fa27cdc59632b9e44811e73ea0dae9cd3e2349278fb1023a97358e87da5a33fd1f5b63877a3c6482d1e24e59219261c7c35af6fad75fd7e19659b90e9aea18e30502bae9e3ba72b3b07dd58c12ea109de754e6ed4a4d84d9ee722d99e"),
	})
}

func (s *drbgSuite) TestHashGenerate21_SHA224_7(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "bfe94ae6fd97503cb9d25fee8a578f4c25ec69a2501c0e11"),
		nonce:           decodeHexString(c, "c0db5a14ca6cd3311b11f0b8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "54a43dadb1d9a4455a7c092822d53f8fe0aa66b722ca2a41"),
			decodeHexString(c, "a7f7cfb7580e8b88f8ba61f09e92c96e9a0280b7b5b4fbd6"),
		},
		expected: decodeHexString(c, "4bd989753aaada62cdef8714eeaaa42eebac9b5bc5172868549541d50f1dfb37e04340cf9dc766915c600b6d9e6e96b8fd5696bc44642c1fb053c3ea2b43047cf3d97f3684431063d72a1d805f7b9f7f6f46ec2ad3acab9ba1c753b0eea9349140cb1c3a1df81be781c018706ddd87e0"),
	})
}

func (s *drbgSuite) TestHashGenerate21_SHA224_8(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "3e8c1d5ba26f71b63de7517a78bdc74be1ba3d3e3dbbe1f0"),
		nonce:           decodeHexString(c, "4557d172729d217b15986c6e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1db74b668f64922d426b6d2f678368ac2c4d9f8702f1a82d"),
			decodeHexString(c, "7e6b01dfeb46c2466633f0f80a4ed6c5ceb84eb421b49be2"),
		},
		expected: decodeHexString(c, "78e4caa69663107a4e062561872ed5429e76b116b2952440d9e943f97fe26b607cc852d2834573cc64b306df19d1ff4e94e1ae3743dfa9194975a1edac840ed59f5897a0e244c48eea6f83ad6b2557ce9af8af866d010c6b414795b7fc520e2e20777aea7036cfed6255e30187c5752b"),
	})
}

func (s *drbgSuite) TestHashGenerate21_SHA224_9(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "cfcb605fb2bcdf037cbe0f882af18cd8af470b3e8207682f"),
		nonce:           decodeHexString(c, "3aef12e590829834b6557f34"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "20eea72865c3a32d903b2a763756adbffa1d42b1a61c91e7"),
			decodeHexString(c, "9c1990f7f2176904d9ea99bf974dacd039fd8c25531e8c3a"),
		},
		expected: decodeHexString(c, "1a1bc626c61f4f4c9a87342f590a2b9d1f09c16edb68202ac1986a11512dcf30b7be7af95373185e1d2561f75abb8c7926f76d00f8d66b59c11fa3ecbf7726c143a82079e55202799ddba02b2c7345f4c96c41dc785d5fc113ed7e50b38e86aeb63e586ed1f6d02ecb3c6348c91d6a26"),
	})
}

func (s *drbgSuite) TestHashGenerate21_SHA224_10(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "47a8cfaea7ec9f0a2d674e34e7c643b61b45df907a2ff4eb"),
		nonce:           decodeHexString(c, "9a4da5f34cbfb9792dfdb636"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d504bd2d3ebef9e51d15e0f3993243099ca83e984ad5ac29"),
			decodeHexString(c, "d37523e672ac67b03e2da915675bda621755057fad998254"),
		},
		expected: decodeHexString(c, "94784791d9a903d3a073f22cc5d148f2b04af03bcb1e9dec2a24703df9dcf8fdbb6cb954564320039b6b9222801c95965bd244faec947fef5358116cf3c1dd4638eebadfd50b3ef38ac4185bd9ab6ff3a51ac0b1c198c04c91582e42e413497ef8ec8741f2af7d1f86d54130ef67342d"),
	})
}

func (s *drbgSuite) TestHashGenerate21_SHA224_11(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "bf684f270948765b3a404ac189bfa3b1919ca6df8ce3f8f0"),
		nonce:           decodeHexString(c, "885d7169185c0c7a07f66496"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "50e9cafe7d7d6ed864afd568aa5d7de2d0db5f5a681f2e83"),
			decodeHexString(c, "4b5ba83a92cd16ee0656663aacc93699a1002a4454119eef"),
		},
		expected: decodeHexString(c, "84823c7a826106426e3b5e3ed356a2a1b95acec9179fae4988956ee2fbef3be9ddf3acbe0e72e091d31c115ece372f209ed6e26a5d85e5ea2fb1737612d5d24e7ae210eb90dd670b9f84129b6ab6a96e85191d6b71b5393d62aed703f02238ffd7da9e3e42aea388ac1dd1625be76d78"),
	})
}

func (s *drbgSuite) TestHashGenerate21_SHA224_12(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "56d5f5e2ba0f288f8775432986f8969968ef6691de1838a1"),
		nonce:           decodeHexString(c, "96ad6dd5293404bba074e007"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f03afbeec8ada1aad046e28923f0ca7d83710bcc75c05512"),
			decodeHexString(c, "a96034cbcb0c93268cfbb83efff8683e50c5cc1cda357eee"),
		},
		expected: decodeHexString(c, "5d0220dec7261725586627a1ef9e41956e57a158a2b9fb1189d5e402e3e11e32cba47409cfaa9c3cba943c3a1ce23b9885cfcbb55ca8e633d632c0229b967d02ec0adf4cc94754ffc130d55295471c17a416fde7a0136a579feebd1d01a85223e595db4ab50104e0426d816cdc6baf94"),
	})
}

func (s *drbgSuite) TestHashGenerate21_SHA224_13(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1c87802746f255241d8398f12acfdc09084b8998ed37831c"),
		nonce:           decodeHexString(c, "55ef213bd0399b008855e787"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "83d7f0a1666112ec78df40b5d349095d53e70333808dc8a1"),
			decodeHexString(c, "721c9df9f5f61c1d0fa767f65f3276211e91f8214c5ec733"),
		},
		expected: decodeHexString(c, "cfc278e4bc12cc3ab515e00afc24c315adc3db92b7b74266ca1cf05d887a8c7ab8f068eaf6044d3e5ab7ffa341bd4f2b163c4691d51ac58163013b514262781277a5206090b8fb659481a6370767cf57d6535fc9954e936fe720de862baad11b6276955c75c5397502f281ec67a68fda"),
	})
}

func (s *drbgSuite) TestHashGenerate21_SHA224_14(c *C) {
	s.testHashGenerate21_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "8a0fea72b780967d1d582bf62c2857b4d49d5063c4a40e7b"),
		nonce:           decodeHexString(c, "87f95440746ac4e00622b200"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e098f0e076a3f40fd970f5d221944f0040ef4a18d88dbe6c"),
			decodeHexString(c, "d7eb01dfd7c13fece92d35133c3be71efba145d7353c6d69"),
		},
		expected: decodeHexString(c, "f03074a219ef31d395451ebc8534e4f2cd2dbfebbd9257507979ecec79a5f76359f2d6b4653b31704ae5a49f884db91ac335ddc6d11768cac7850734e76734b63b71ff12f3f8d42cd404009e7f4b66bc0a639a9354ebd754c17f3cc65704e698d9bc0640919c386e96760f3c36d8789e"),
	})
}

func (s *drbgSuite) testHashGenerate23_SHA224(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHashGenerate23_SHA224_0(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0e8efb12bd55fc07c34ef9682ff8a804c3d454dede06f249"),
		nonce:           decodeHexString(c, "8f3a9b2dd9627c09f761a8ac"),
		personalization: decodeHexString(c, "2cb8fb48d1da52810db7f1b771f2399fe4c8bdbfadac49d0"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c72e717b30c6954227576e99685b38e7562c4b1107e6028c"),
			decodeHexString(c, "d3e1dde19a4cfd7bbcccc1b323153dca4b59208161ac1518"),
		},
		expected: decodeHexString(c, "2952cf5b4ec9f46691a855575edcf629f6a0f8138b8d4a1f62d3229e1c852b7e7e8815377c16b582a27406701e3f5395acf0bcaf7dedf161efe853ed6856dff173fac149d2cc783dc1ae77781103f1c9656e3a6adf3cffbc1185c9b943f5baea907e41d3c8bf64cc8f15b22ba96d59c4"),
	})
}

func (s *drbgSuite) TestHashGenerate23_SHA224_1(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "bef4134cfe6e952ef4954f0b43779c27731aa7ee1fc472d8"),
		nonce:           decodeHexString(c, "9fb0510d794281d606324ed1"),
		personalization: decodeHexString(c, "70b141ce833db247d2fcbfb1ef84c9f7c77e80124491697e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "efb3d5af5bfb4908c39fede9cd3463502bb4831357aa9007"),
			decodeHexString(c, "f7b2fe8f57f076d95678dea798c412db611a2a0f459ec15d"),
		},
		expected: decodeHexString(c, "49be64e83a506b8cc3f0d801fd7c7a502d63090a8087ac471e7af1a7b31e78a0caa014b0e4899ecd83fa12022661f19c1fb17884c25a1d3681c921a465dea99bd48990fba31b42c75794f3f4535c1f6aa3bfb97bc1fa195fb024067d7b34fef241629b58fac1bb5c05de4dcea8e79b20"),
	})
}

func (s *drbgSuite) TestHashGenerate23_SHA224_2(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b2e3d9a234e65876dfd1e945307c5c13dba9a23bb5a778c5"),
		nonce:           decodeHexString(c, "d984c7113a3a7ee0690fc4bf"),
		personalization: decodeHexString(c, "fa9332ce5fb875c8e9f773276a04c1ee56bc0d5b0efe4aff"),
		additionalInput: [2][]byte{
			decodeHexString(c, "af1e9b36e7f93f35a10c18d5176f81c96227eb9ee362803b"),
			decodeHexString(c, "df5e1f0268abcde9da54d855a6e9f50e6f44c8731cb48043"),
		},
		expected: decodeHexString(c, "d51d635f45051a842e6fd418c01ef3c7b7363e63f84dcd0676b19dbd60df2ee0420bd82e59a6714302198ba9ea08c9f0f3de3ccf5f8a20cab378a772d082d4b94d21ffb695c7df6056ce8dafef38d4a0a33aa2af47feb73b704fc6df4df42bff4042c80615785a74df9088b25c60bc12"),
	})
}

func (s *drbgSuite) TestHashGenerate23_SHA224_3(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "274000a2ca67257e92f123f669e505437e2a391bd828e151"),
		nonce:           decodeHexString(c, "bd5abdff6e5d8c3345ce2325"),
		personalization: decodeHexString(c, "9dcad23fe569e5b75fa485eccba734fdbc00f874e1fbfbc7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1558e022437bd96a04496c937b662b262cf8ec03ee7cb11e"),
			decodeHexString(c, "044928a106985ee2223c3df9d7df2a67813bde19906c59c5"),
		},
		expected: decodeHexString(c, "ead500db29ebf8d9432f9f53d8ea4def1dd92b79b296251b0385abe653070ac95a4db9768fe34a5226785b51148942325b76c1e4017dc0921e11fb548279e69840ea6d01e5de078ed23569b67f8e1f3165ceb173328ab9fb7b7a9f3245c6c07c640605972b281036f3749c885432feaa"),
	})
}

func (s *drbgSuite) TestHashGenerate23_SHA224_4(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b3aae8e63a9bf9e766e36f351c82f095433d94216ff3db33"),
		nonce:           decodeHexString(c, "6b91c9dda6ff6996ebb8eb65"),
		personalization: decodeHexString(c, "9957de3dfcd3e00f5c376083011aecc97600d78e4354752e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "02373d44d4d8ccf12139b869778344ff1048ff9dfc5a7530"),
			decodeHexString(c, "d996a59e3b203bbc0f97bf3a5abe22b442dc5e21b2ada571"),
		},
		expected: decodeHexString(c, "9866105bec3087104d36e345514a19d857b15299d352c48075113b34b73823362c5ef47bb93e7fba2930b61ccbe9d73f0f5b284b9bc8b272aaad4229d9dc1ec4ef17f6d6bc428bf7053b4faa5a388f095b82e5bbfabf4ca8bdfbca725f384af8a78d2fc00527c5604fea07d990cd0d00"),
	})
}

func (s *drbgSuite) TestHashGenerate23_SHA224_5(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "56909e95490f7d0d2c1b24c97006f05c9607d8111df52682"),
		nonce:           decodeHexString(c, "7aa9e95304def7b9224d315a"),
		personalization: decodeHexString(c, "ffac409a9f1663710d1a042e9264df312c68d347d2eac97d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2a28e7d1755646737f5a3d3e22d2b34e9d2964c8913d3afd"),
			decodeHexString(c, "9108ad8bbbb814d9196143185563f2684fbe84c1120eafcb"),
		},
		expected: decodeHexString(c, "5b89b41311a53d8b7871f4905308f34a63df857230069bac66c5876d5efeab50854a0f5b94410aa187d2d34c2068add565721e1d1e2b22a43b23c8c2a2d7f2504c66f45a51600729b4dd639b93c2f55d67158cbee93483add30cacfe634a9f307663485c69f98f221dd0a28d144eea0d"),
	})
}

func (s *drbgSuite) TestHashGenerate23_SHA224_6(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a3d5e7563a9c087250dba95c13e3dd5555b1671212ae4a48"),
		nonce:           decodeHexString(c, "af8c7de0e94721f98ccca348"),
		personalization: decodeHexString(c, "ed18f2b927d3dc023d1fba05ac6038869bc8eac0c0c5ae4e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7717361e23ee3e154a49627db0f13eccebccfb25774da9a0"),
			decodeHexString(c, "107af893df1fd36bead4f53ef69f0d7e17263eee8aaa0923"),
		},
		expected: decodeHexString(c, "dd945e4f0179cc65ab7d841f61b122cde1df3651f405ccabab7162b66ad4a4855aefb267092c4989eb3d38c93042808710f1976b66131537018d42fd2609735e187d1c75b98765859f8ace0ae21ec198d2390826e5e9a36a03b2edb270705a44cf7d32435d2bd430ff6e34bf4b8af9cc"),
	})
}

func (s *drbgSuite) TestHashGenerate23_SHA224_7(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "cdb1376cb00d50572fbedbd45296743064ab739053ad9434"),
		nonce:           decodeHexString(c, "cce908f55c50c4e05adb622b"),
		personalization: decodeHexString(c, "0b8e5b5496e99bc1ced351cc235b02f766182c24902e92cf"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c72f68725a3be4b3533b6de78c138365a82b6a24deb0d1d1"),
			decodeHexString(c, "a47d05afd1feb32bdebd4e6abb9c61d14db53d42cf9575d5"),
		},
		expected: decodeHexString(c, "f92d14de4be09f5a865ec4337015b36043f3286c92ed27c4f61ddcd9ffb8efb109b01637fc65ab13bd9ed9d70a0f737f44dfb6f9dbc8ab4bcc001341b238d65137d4498c2ffee062ad166f95e4e61f4b14643e6e1a41883c9811d21a32b795a8508f09a7653b4b00d430db03446f3b74"),
	})
}

func (s *drbgSuite) TestHashGenerate23_SHA224_8(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "577eb580f7fb24351328950558d36510226f9228fe1e9ba6"),
		nonce:           decodeHexString(c, "2b7a15b342e96edb2b30076a"),
		personalization: decodeHexString(c, "072a22f1622a275bb47b4c67cea53ec0ac04ad464df7a3dc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "cad80dd8af88defe6568559c42d74e0f36fe003de9e0c8b7"),
			decodeHexString(c, "15fbb51b940ff28cdd201ecde47141cdd2d939e0f03224c5"),
		},
		expected: decodeHexString(c, "d3c3616942892257cd8f55d56abfa6cdbc3db4c23739865bf696f626d5feb6ae5d255fe1301396c02b493243a3c366ddafe8207997b281e74de2dad91601893c56817f3a6f6a77908b2ac61a868ad035b5e6d54e10972713a8789f4878d0c6a1ce5a154f30c88d48f3cf52ad352d4c32"),
	})
}

func (s *drbgSuite) TestHashGenerate23_SHA224_9(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "cfdc5653ab06d78239fb6cec4e60c3241f980cb7b95fe05f"),
		nonce:           decodeHexString(c, "0613b0d3745613752a0119ab"),
		personalization: decodeHexString(c, "257de719c9b27931d39da3b95cf4480a1d84773ee77d0ed8"),
		additionalInput: [2][]byte{
			decodeHexString(c, "97733b171ab2b6f11e87d26048c7a8b9739df361a4885807"),
			decodeHexString(c, "2f77f09c6a301e5b0b044fa7cfcaf63e907299199071146a"),
		},
		expected: decodeHexString(c, "d4aed48bab03c936eed8d08e50bca8e0762784dc930bdabb93e8c8191eeee4c5685e059db66b4a654e4cabf69a1e436e7436f608efe938a26164ecde7eb3196491315414edbf91aa036ab1db8a34f4ecd8654e5b327a68b55ddb9d3e74b340d0058b1fed8a2f55e24724d9360bf92502"),
	})
}

func (s *drbgSuite) TestHashGenerate23_SHA224_10(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "800beb831b1e3ee733ac369238244cdd6062e5d1a5e2d29d"),
		nonce:           decodeHexString(c, "346ac541842a8103b9015980"),
		personalization: decodeHexString(c, "50a04b367e96822ea2f57d3487c73fc77de775e7aa7fb438"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ece3847b1e906aeb3d803c094b185f39fac052e31fd6f8ac"),
			decodeHexString(c, "605cf7b158fa8655c81990c7a9acee96644c762191026953"),
		},
		expected: decodeHexString(c, "76efa82867c3c7e7d6a9cfe08223b60f48dbea8410bb0ac6126f834759397de473d5644e409b26e05cad49cf0a4dac01da5150f746f2a85e899fc575f408e8ac6c9885c5ac6942da805b1738d4fb59ffd54f4da6b07068c07b2113eae2f64bc5c735a0b5298982e7e658a38c191fb3d5"),
	})
}

func (s *drbgSuite) TestHashGenerate23_SHA224_11(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "246373f4e0f1e7c8e6ced8fccc86e83124f156bf7dee64c1"),
		nonce:           decodeHexString(c, "4ca6d0f9d5dcb88ac8f4a10f"),
		personalization: decodeHexString(c, "0b718f380c2802ff9276d3b89a7e0cde41d66eda99ddebad"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b5b3889a2987040c4013bde5bf3ba82060d32e6cb24e16fd"),
			decodeHexString(c, "2dd07ade930289fb29486362f1a906d2630a27d126402af6"),
		},
		expected: decodeHexString(c, "2faeeb7669909f31316712364b143cdf8bc96c4738e98a364116e84772c54b438a3eab37aa427ddc3d39411610294f4343c13442ebb6c4971207451f0f716af1ec592e5392cb8a6b0f7514bc11b1497ede1372d85ea3a72f18014d7dddc96d741a807ad8881173503207f7c5682d73dc"),
	})
}

func (s *drbgSuite) TestHashGenerate23_SHA224_12(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "4464f4ab7210871eaf00e6b8928654d1f5b6edef2a6a33da"),
		nonce:           decodeHexString(c, "46fd0422d575d125b72aed67"),
		personalization: decodeHexString(c, "184d12502fbe8d37c43cdcb35152e3b3c37e9054dc1d3585"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7ab983c20f1d8a6b004dc58f0f48af590dbb08832bb7bb10"),
			decodeHexString(c, "d07a2a1fec3b82462fc1460f064bacf5922e2ef0c4ed76ea"),
		},
		expected: decodeHexString(c, "e2afd0ac3774eb85cdfbbe4c98b8f18999b868a8faa24265ef28126f59a1cce496ba0747bb316290796d301bb6665e56beeb5c13c9965190bfe660e41ff9dc89a8ee2a6b0ea3067de1c5e091ffd75037566bf7848ba6e69479519b3e987a4adc2da8372e2f7153e6f0b622791f585645"),
	})
}

func (s *drbgSuite) TestHashGenerate23_SHA224_13(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "5213a1f2263a3e9530acb8f5b9bacd4ac96951fc397005bb"),
		nonce:           decodeHexString(c, "03d1901dfdb49f92b6baa118"),
		personalization: decodeHexString(c, "3c736791ea6d1bc5d848029512053c20ef7dadc20e0ee70c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e951c13d3dccb9559921cd205928ff68fc06d1eb59de1971"),
			decodeHexString(c, "e7007c806db5d1f31fde06715e46f27816df74a2022830d7"),
		},
		expected: decodeHexString(c, "4f259149fe3d999daa93ceec96b789c765396075a1f82eaa9b8a33b5518cc746b346ab6ce488f97051349a2d6d1135f93cf4074d0f19216bd6ada4338f3fa20bc52dfe8c7749a93b38018894473c7236beb036a63c6f307999a106557c76d6f258ec2f9dda5789a69828b5d658806884"),
	})
}

func (s *drbgSuite) TestHashGenerate23_SHA224_14(c *C) {
	s.testHashGenerate23_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f04bd923480d383ede25ae2d72687980cad91d008ce30e59"),
		nonce:           decodeHexString(c, "ad9b67d7d3d71583bad67abd"),
		personalization: decodeHexString(c, "80326f5777366dce4f91f54cdcb6abc4d676174fc2a0e0ef"),
		additionalInput: [2][]byte{
			decodeHexString(c, "fa0823db6808a3de1a7dcc081c01cca840f68b005d473bfe"),
			decodeHexString(c, "d3054fa2bdec7c63dc009ecccf25c1116380ac25f82a9085"),
		},
		expected: decodeHexString(c, "556e90c95c1abcdde027fb2b88cf191f0686830ecf3fbf89de51c9bd735726131472a17f307263d57c03bd5ecd9ceba6cd5759b06594bf901418e2421fcef4b72678614079cdf4d25fa0b74985380552d2bbf478290445066e3f4a40a2e2b0792a685b769ffdb27721b1faa484e9c783"),
	})
}

func (s *drbgSuite) testHashGenerate25_SHA224(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHashGenerate25_SHA224_0(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "4cd821f06021e05a4fb3dc2634c405e9acf84c0fc59ed546"),
		nonce:           decodeHexString(c, "e4efaac03361296616c3ad77"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "166d8115e78c87dfb715beaede2b5d63565c5bf52d8ac61f"),
			decodeHexString(c, "ba4e92236fd2a5a362673d464dd5f5b4fc0a5ad2c0fdeb62"),
		},
		expected: decodeHexString(c, "5de3a9e43e4448e72c4e42ec32942185a4f58f8dd3fc1e1be4337baa5aab3315c3d537dff954ae43e8d79e218acbfc6f970559eaa41e4666df14817ec706837726df717e54aaaf5980c096c5ea91788f824a2d729ec8c11c30179811424bd9dddb24ac100b2474e22a7d822daf4dd938"),
	})
}

func (s *drbgSuite) TestHashGenerate25_SHA224_1(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "5d1733d64c95628bc65b3dfc297751addd74228f98a9ae68"),
		nonce:           decodeHexString(c, "afac53f1ff1eca8ab6994c3a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1a20ba633b7504c3d6e5d09f34ee81db5202285e83fef53f"),
			decodeHexString(c, "13227640103fe093e830040674d53fea9ace7dd4f664ec49"),
		},
		expected: decodeHexString(c, "419e5623bff172121c6ba2dff5699d053c6d9d86f2c2abb4eb305a2cdddf666069476c8ba58ae9f6b0b8414c0b698d5f4b151cdeccf338267d7e33101f2463a9396a1aeeaa467016ef0f53c3799492ea0768f849a7ef9e795d6ea9e0a81ea95ef69671c8dac68d51ad221547c61a5545"),
	})
}

func (s *drbgSuite) TestHashGenerate25_SHA224_2(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "fe3a4e53ae825eb82e278a317df56b9221a79489e11b93ef"),
		nonce:           decodeHexString(c, "1ac17b5202826a273d483386"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f21cbde7d9020de82f37e79dbdca1121d0a042a0b975b430"),
			decodeHexString(c, "ea04a666edf06b829ea91dbb84b484b19edc23b16bb53eac"),
		},
		expected: decodeHexString(c, "a8f60f803ce8eb612f7d1c1a698c95fc97451e0789ea2be634b2465d8bffbfa960aeaed937296a68794889b5af1522deabd64a1be9a215d709bb6a3d226bc499f4e5438c812e018b2247c133d94bb224d978a962a6287d01d85a238d904f5e297b2d6e729d85c5252203be431fc7869f"),
	})
}

func (s *drbgSuite) TestHashGenerate25_SHA224_3(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a52c8e6f027701c1fcbd76722f921e301c3fd9dd7149b4bf"),
		nonce:           decodeHexString(c, "9a357a1452c5971d9b45dc4d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a4bad1136595353bbd3b01cdda8c56928ed6f130503766e0"),
			decodeHexString(c, "8f37092c5f54ffbd51f58b8023c72fc6bcea5a625b0ffa70"),
		},
		expected: decodeHexString(c, "437fcd666beb67fd00f0137c75c27e234415e24028e07f7e5e884258fc8bebb177d74728f5a27dfb17a66ff60c1685fbd48f2d3c1c80db688cf7fa0dfdf8be9cf637a3a30a5ad43e98b6e80ab7c02a7f78635a9c6623ae1ab1be40f2a2a4c471cc78240fc10b3bf6856bc987f09fc105"),
	})
}

func (s *drbgSuite) TestHashGenerate25_SHA224_4(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f9564d418c8fd789ff48314dea505185af276aba322c0622"),
		nonce:           decodeHexString(c, "a1b7ae87bdccde885218741a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "18a32ef711846c7716269ac04ae257501f4e09ebdad8a555"),
			decodeHexString(c, "6c39dbc8050310ea67e70b3d007c5a8fb094f581a0ca6977"),
		},
		expected: decodeHexString(c, "28c96c56cd76adc7b1c8e960e08974c4d75db4851068b6f9f1d2dbf922554a726e84528224c3638d39d9833f4a038f328a515b3da486804cbf82c4f083a8d2854acc06b97c5d957a39b216e55a8694d6b550aa0f322cca773e1dceabd84f381df06eb898c76dd296e4d67a0db63554fe"),
	})
}

func (s *drbgSuite) TestHashGenerate25_SHA224_5(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "c9406228b7220dff834f28c3e4c3abf0ff04bccd7786977a"),
		nonce:           decodeHexString(c, "46e5e4c9877d7468cc733911"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "339593a6cff7530fc2c310505dd9be6f701b3c72f26d6207"),
			decodeHexString(c, "55de0b922ad1763fbf875f835d37d01419715fb1638a8cd5"),
		},
		expected: decodeHexString(c, "d2c9a62b6f62c4f95c1ff34d759fbfd9ad76bd3710ba5ddb3b6a942230126c8d8ae1ed25bc38ea42efaa604975fad55260edc832ce4652a22fc2a769b3a5c8846bd5bce2310db85bb0576543cb677ef5b26f8a3f01b123c868f638622f550025825180762df043efbface399e2b11a31"),
	})
}

func (s *drbgSuite) TestHashGenerate25_SHA224_6(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "eed7dfbfbd982f35f19ca1916de883db1a21363ff16d1716"),
		nonce:           decodeHexString(c, "6e78bdff2ea6dd8e8e865fd4"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c0e564b5f793e98d4b708df37e9b832bd11bd69f210b9546"),
			decodeHexString(c, "73cae8da3674ff00bdae141bf13aa6372b81dd78a149aa10"),
		},
		expected: decodeHexString(c, "951185132d67120a238cc4da1f79eded6c1171a109f0a65b489fc0d7a88b6cb003b2e14596783189b3566a614f392307440794dee4d95973df8abaea5601353e99173261252b1ba41d70df1c5e8ae184d66ee6a2c6896b076bacafe99218a16c3fe9efebead542bf3f7130b934096b61"),
	})
}

func (s *drbgSuite) TestHashGenerate25_SHA224_7(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b6a05e14e60c752b4c307850d7661183d598fd522ab41f61"),
		nonce:           decodeHexString(c, "8c5264b568d376be822c843a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d68702d4eea9219745d4a26aec5ebbe2651ccceffb6e8952"),
			decodeHexString(c, "d8ce1a1350fb9b34c63bdd82009d35eff4fb493b402554c3"),
		},
		expected: decodeHexString(c, "2374474b62a52202eb178f82d5b4e1aa529e7a062e00329fda1a22f89a2ebacc955afdec457d5a84d159d94e94f112d04ae606e9afcd47fb9caca95c63885fa18ced924495fb5360836c70bbf06322e5d34a0e9c72c9a8c5ed0abe1eb920bb8c9c46b7478d88af57be13a60057f53385"),
	})
}

func (s *drbgSuite) TestHashGenerate25_SHA224_8(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ea985af279f8c2391223e5bd31c0ab1db25d5e3f08d8c323"),
		nonce:           decodeHexString(c, "401d027ba90697c72b1735d2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "285a68a8b4fa92cd671798b8d34040a795da82b1d24caa6a"),
			decodeHexString(c, "5c66cf1e80cd8d039934d1f3c2898e9682320d4b2b460326"),
		},
		expected: decodeHexString(c, "0418dbc1cbfbc79f4da20e56f4f80cbe2e4eb40ebeabe45ee6e8c3979cc982fc527fe9c2d7808e0b1c3369b57e118c88ee4eff1aa4b88b35de9a72760e923a44b29e7be4e379e78db3d10f4bf60c59af1f9c86f052d07a60496aee7d2c99b4167989e21e39b53f5d4d47027d299320ae"),
	})
}

func (s *drbgSuite) TestHashGenerate25_SHA224_9(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "fca365c5621af51099f6ca78d835420c5b9761a558f8e3a5"),
		nonce:           decodeHexString(c, "a00c1fa36d37469bf62ebec8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "891e5403d20ff0a902446aede74ffcc93135a847fdcd862b"),
			decodeHexString(c, "a044ff5ea904f54ae35832e4697a6d5b543cf843ec9b0966"),
		},
		expected: decodeHexString(c, "a27c2c3ea8ce9b892c2868521730371ae68f32174efe0d67bae63e4cab720eca6cb2597a6c391833865ab3c98f57ff507a3ee5602e88be441767d75ed97af9a36512183c2313e9defdd2b174f784ec962eee13da71a4cae2ef8b9f615c285d8fe5bc8704bf3462f46010ab512c99a5f3"),
	})
}

func (s *drbgSuite) TestHashGenerate25_SHA224_10(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "506180b944d400028d3b4a43e4a553001c3b89b41c62fdb4"),
		nonce:           decodeHexString(c, "7743de27fa7d4af082a947fe"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cc2d5629cdec0dac130e73546791f29713dec64fff7bc0d8"),
			decodeHexString(c, "46419305e58cb2e6d761dd23e67722012d9c83e552fccc3f"),
		},
		expected: decodeHexString(c, "8d901f6fd77a489786ffe9df84d1bf8690a34ca5e5c3895309651d967032316b8d1965474e18051d00f47128cfae379762262e9e4da3594c0e93494e3da922e9fd6e63720beb14f8618bf6d94d7f3e105f9b51fe6bfefce1a925b133360cb3f48383118e3b8fd09f1f7cfa2770cc40ee"),
	})
}

func (s *drbgSuite) TestHashGenerate25_SHA224_11(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "cb3a0ccb89d85dc1fdf9397f6eb8bd1f28f8939b08a7563d"),
		nonce:           decodeHexString(c, "7be548412365a33260841966"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "77fbec5631f027758edc94f0cea95712147755519b1170bf"),
			decodeHexString(c, "a55a54ba72f9fb1e3e5fec8bb1b599ead10705319280dc3d"),
		},
		expected: decodeHexString(c, "d022253f3a832a58bf287b9d2d774ddaf72db6cff7bac1d62dff318f26b01be9ada7dc95af3ac6896898b5eaa96fb05ce097e6ef58efd90c6c68bacf75921f3fb36f3bd906dcca8eb478d6b29143237e752946731d03c695f4eb5cb86f978072f77384fd853bfaae60219e165c2f1529"),
	})
}

func (s *drbgSuite) TestHashGenerate25_SHA224_12(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "bd3c57df249fdfe7a12356df12689c927041fbd1f33774c4"),
		nonce:           decodeHexString(c, "c4cf057afcb8ae81f811f414"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "4013eb9f96639a06325f381e6f7cd270daebb6999bfd0cd4"),
			decodeHexString(c, "5773619ed73ab37b7002efa1102530d8385740b8aac81569"),
		},
		expected: decodeHexString(c, "4c8154a08a21be50e9a8f8e1d4b0cfa5275e72b26433efebfd303d90e9fcbf0be8ed01cbed5cdc4b4fa0a27025e36668515a8ad1a31e4f4b0697b8ef6447b821721bf04131ae105456ca92a45a3193ba15be07347b9e99660a9e45ba88267c2010e0a0f4f47cca488f828344e353a7da"),
	})
}

func (s *drbgSuite) TestHashGenerate25_SHA224_13(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "59f155ac90041456b095e61308181d14fb5a07c69981a0e9"),
		nonce:           decodeHexString(c, "2cbe51b9ebb4077266b5a952"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3f9cfe88753e67b682fd496dfc1d43fb001549090855ff5e"),
			decodeHexString(c, "17f6d34e5b1a5c2604f6641a2e09d1fb4e711747f2ec50fa"),
		},
		expected: decodeHexString(c, "ac6830003eaa94eb5a68252fea2a17b046d3684340181ca39930cbf2eb75686672556103d81c127d140506da6c183145628b8a2b53e8b855f8da0681f1af90f6f5ed0a4de7fb6006e0ed2f91e018646fcccb4f271d6f560cf76b40407159172592f48d45ff9959041db35cbddb75435d"),
	})
}

func (s *drbgSuite) TestHashGenerate25_SHA224_14(c *C) {
	s.testHashGenerate25_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "598774dbbe13282b79c80e67efc9982c7750f18bf737f733"),
		nonce:           decodeHexString(c, "cd1f12bd2899329b39c3253c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "65e70309f7386d1a0aaa53da65263d5263bc5eaff0d5f3d8"),
			decodeHexString(c, "abb8cd0ce0560309d2424d2f3fdce7af085e6c14699b4799"),
		},
		expected: decodeHexString(c, "8188a498ef9e0fd52a77c3a44f1c7edccf9248590aebc52cb9ba7b5cddffe867b26309f032a78c0ab751741fdd9bd77d4bd17be90dd045f6f8b45826c9900028f68138cf1ca8e18b253b8eb73ae04f2e156d51a792abdc6524e4f45e4ed0b06ab3b0c94bc5e1ed58f917c17f72161d31"),
	})
}

func (s *drbgSuite) testHashGenerate27_SHA224(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHashGenerate27_SHA224_0(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "86a1b85b447ed6047efd9d941076f8e2574a59825d823471"),
		nonce:           decodeHexString(c, "ae0b9731774f400b41984dbf"),
		personalization: decodeHexString(c, "530ee91ea4d80431b54a3af8e6576f01aed5f3896c4aa732"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ac82066b7fd4d4c700084653dbafbcc2b37842febf08fa04"),
			decodeHexString(c, "57b7737a97247423b83971cfbe1d1a77a61535b8922a4e90"),
		},
		expected: decodeHexString(c, "ba15fb11668d1a84785f5edf8b9054647fb702623a1140de9109ccbe1e14eec643fba1f4fc9debbe35d8a1fae3895cdbdc4a1e13f463955c3ccb16469817bae97c028f327c71386873dbf0da9fcda200a474d2e74ffffc867cd7e25f40158c4d5711c63af48e5e2590e787f0db84fae6"),
	})
}

func (s *drbgSuite) TestHashGenerate27_SHA224_1(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9fa2311cfbdd52a3133f50799390d6d670c28e6a6aee1047"),
		nonce:           decodeHexString(c, "c7c811332cd0923de0f21868"),
		personalization: decodeHexString(c, "2a6da1f72de610e1d3322d33941d4091ca2a72452f1ee330"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7a632b14f1607625575d89b86610aad7915503c2ca140866"),
			decodeHexString(c, "c7956c39600ce8361de289de2cfb36875e2f0460e2f3a904"),
		},
		expected: decodeHexString(c, "b17c449e66fe2950ec28d8e82c9a744fd89d91a4b4ce45f96b69ef98ce13704949f5b883f5c409483ba9d915d911c341855f4684f5d015b9039055689b7fe28adcf75e7159f05bdf0ae6e3cf37b07fe7583ca3169ac6ed96af336eafda91bd86731a38dcb655a048e4a7121749a2126b"),
	})
}

func (s *drbgSuite) TestHashGenerate27_SHA224_2(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "211e39be0bab7a81c555d13981a12696e590fe65e5170fcc"),
		nonce:           decodeHexString(c, "16b7dbda910cc80202edc3a2"),
		personalization: decodeHexString(c, "8dbfc18b5fbfb523a79859decda92afd103e2fed12211b10"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ea753210ef86579deaf11bb431ae68c364e964b868160f84"),
			decodeHexString(c, "5c3e93fe188b9b535a10dff33e5af1b4dd0d650068f808eb"),
		},
		expected: decodeHexString(c, "7a7fd347a9d7a51aac53675a5f61810f1e7f1531ccd40d46e0d34b9084cf5b347b10098d3bade378c9190eda9bea755800b723331d182e1a693d76db0f73ccc3a209afb65a7aa713b3b9364c48c70a4656c7d3cffc404c07277669403145c595469006353b77574cf2d565e2033cff1e"),
	})
}

func (s *drbgSuite) TestHashGenerate27_SHA224_3(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "acc90c5fde8d56a80447cd97ccb88f72b2104956166d3d99"),
		nonce:           decodeHexString(c, "e45efd3ecd788ba826f7d51d"),
		personalization: decodeHexString(c, "b75c900d8e94e3926bff49bb55b1a3679dd9ab2970122939"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e52ee85ddd31155e77931f1ad6e9c994f28ffc10e5e15b09"),
			decodeHexString(c, "3c90340045534f3ba3f4c9d4e427fb912434ec1304073b5a"),
		},
		expected: decodeHexString(c, "9e5566edea3ca7048a602012617bd16fbd230aac183db50d161b36d02ae19afc1b734090bc2c064ef4e9662bf45618fd649c0794ecee55fb440f24c8a4105a77a7b512c5701ad7417e52997a1e27edd9dcfa45884b2f5c8e3d8a20ae8913b0a6915d3c1dda085a61dafb30392b41b4f7"),
	})
}

func (s *drbgSuite) TestHashGenerate27_SHA224_4(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7f5156a1c615c0f8f9e964363ec7584eb8ef40d27b9388dc"),
		nonce:           decodeHexString(c, "74563632edf1100fb1c33c81"),
		personalization: decodeHexString(c, "b4884c6c63d03fbe824d4ae6b3c23cb4c5471b06604ba511"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2488044d437698280452c0e1d368fd989377ec94f7a3b8cb"),
			decodeHexString(c, "df94bbc38c787272f64364eae04f92333439a546a6f80e97"),
		},
		expected: decodeHexString(c, "0928230871ab46a44138fc00748a667ad6b1a72584625d6cb5b00e675ce505dd5db08883c1db0ac86646f2a39879694e16bad7b7592c50f0ddf3cefb00620c8500a353e27b1d233662295f1f17e08cfa4417afabb5678475dc55bc8e614fffb6c44b80ad4aabac18f389c1a9fdd61b53"),
	})
}

func (s *drbgSuite) TestHashGenerate27_SHA224_5(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "24d7995747256a94f9d817003f64a9fe06cb158db616f584"),
		nonce:           decodeHexString(c, "9f54e37fe84d8a0c94523de4"),
		personalization: decodeHexString(c, "8924f0c493f87a8cd8ee710eb80831c106de5553041e9e9c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7ec5f3134edc34995e03ceb25045ec8f9230e53f25310247"),
			decodeHexString(c, "2f4eda92e7f69499f8684395001d8c02e2a28c8a62d946b1"),
		},
		expected: decodeHexString(c, "eb9e6c934bea04b91056db81e56fe91109e3b85b8ce32cecdadf7b37d7939d2686c08c5e0ff11007d54af4e36694cfcd1448b0ebea99caeca8c98547128cd9e78a5541f291d1249f1cf281a7e555fdc24567d287326683b7ba9b458f7ae980773afec8d8650808ef7433a5273c06292f"),
	})
}

func (s *drbgSuite) TestHashGenerate27_SHA224_6(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "aec9f1cc9c78f32a518e7c442ad709ae4f79c2ba51bab92c"),
		nonce:           decodeHexString(c, "66a2175c4a34f0c483035f84"),
		personalization: decodeHexString(c, "bc5f1615325ca6c968f7c1777a4f026fafebf802918b54eb"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c46a3fd414081ff3c88bb7d5b266399281da880f91d9d4c2"),
			decodeHexString(c, "ad063400d0fdc9a7174b3fb6b42304c763739f3152ee99a6"),
		},
		expected: decodeHexString(c, "12a5c705873fc8d4ccb2594a61df026cf0e60433bb6bab16e98242671a8ae9d97bb6a5bd033464b30d26eda6bb05290fb8b7dd0c5b0062f25adfc3f5343c570322856b80bdbf4d9c65e25823291998ca46e34f3ee9fecb112df2cf3ad3455eee204c64a39838814f40d39a5c62ad5153"),
	})
}

func (s *drbgSuite) TestHashGenerate27_SHA224_7(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "1b7313a4bfd08e69e356efd3cd89b03aa574b08346d4db5d"),
		nonce:           decodeHexString(c, "7560c73a2a82cd6633dc2097"),
		personalization: decodeHexString(c, "d5a9a27d17deff4ed2d7bd2310aa19fe9351ecf6b308dde0"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9557d12b235921a46abcb1e71252742459a45194df8d4fbf"),
			decodeHexString(c, "a0f7264952fcdeb12d065d80cbe988b9d295d70e0285b0a5"),
		},
		expected: decodeHexString(c, "f3e7cbe2f69fcc53e40bc62e89539b7231dc1ccb4699a1e7e512c75a7ca93820ec8459a1e12510ce112c6e0c2465aa76fffb9cdb9598c5b95bdf1eedd2d3e8eca5887781a06895eaccd9e465c9af03c65d046c5f45cff0f07a10a5908b949bc2a7b1469db1fe3aadf4babf4057ceb4e8"),
	})
}

func (s *drbgSuite) TestHashGenerate27_SHA224_8(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "16f52fab801fc54345b49168884c5f06e1992bf6f3cb705b"),
		nonce:           decodeHexString(c, "7a5100a4247ceef1044f2355"),
		personalization: decodeHexString(c, "32ca8d5a042d4b744ad5e59379801254ea92ad6e9adabff0"),
		additionalInput: [2][]byte{
			decodeHexString(c, "479fc760afefb2991f9164245eccab65d3e370eecc3916e4"),
			decodeHexString(c, "992aa7758aa7b962103296c997ee0254b7717d9254d2491d"),
		},
		expected: decodeHexString(c, "ec2ba51eef719223d8df5809516c51f4079ebcd0ce85c57c53587533a49c798396b026c564aea04c5bfffeaf4f9fd8eaa7ecf50d2f3cf0c14eb99dc461649f7740a93b40446dfcf2a68a85d78294bfa79b7586ab3ac3b5e31412c972dfbfb174615e56e18de4facf659d7ae25355b59a"),
	})
}

func (s *drbgSuite) TestHashGenerate27_SHA224_9(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "3e33049c4af4b3876cb43f67ac8f8d5a8ac97806fa6d1508"),
		nonce:           decodeHexString(c, "22c2d8c3b59e99ab926b77a3"),
		personalization: decodeHexString(c, "7516be26f052af032b28e5f3e7d36139d584c3bcc14235bb"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0d39b1348286ed5d5a1cc52a9358da88eec1e963a6eb0772"),
			decodeHexString(c, "03248c2f296f87035626f743ff970691935bbf62d6eef9b6"),
		},
		expected: decodeHexString(c, "24be53c262f5181a02359f73e97f6474c2433f77b4ba4fc7444ddd0e00982815945d180d860aa5e403c4fe4562b48b2583c5d51cca3a24a59f05a93c9744f436650af562b94d75d95c44625e85a0d6a161bb7130395c75cc3e067a2aed3c7f69adadc9dfa7e10015d030abaf80432a4a"),
	})
}

func (s *drbgSuite) TestHashGenerate27_SHA224_10(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "d883e6934565e0bf22c092233843736c1e7becde906366dc"),
		nonce:           decodeHexString(c, "c73a7fa276796d45d16f36f4"),
		personalization: decodeHexString(c, "829c8d4fcfa8e520d0ba7114abead1940b23763abc4aa67a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2a8d92c1fe4e8f5ca89a277319e7ef4fdf9869bddb816307"),
			decodeHexString(c, "76b8e1f0ac6572b1af383f99e3dfddc7a6e4ddfa69034016"),
		},
		expected: decodeHexString(c, "073257ad0dc09fe074e8feadca8b38d884e355638d27ad27b1d473cbb5853ce552cb4e5f1bb3f4b074554825e5bea5c9c68c075706ca7bca6e094ac48c1fb1684f5fecf1acde94c71842628bbc8dcfec5cc2aac19dad22e75314dc69d902571f07226dbe75ab761a33bdc8a474c354eb"),
	})
}

func (s *drbgSuite) TestHashGenerate27_SHA224_11(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7a94944be2d18a2aa15ce5ee67f4c0343c4ff36a953d7328"),
		nonce:           decodeHexString(c, "c218a8219257216a97cb037f"),
		personalization: decodeHexString(c, "8a31d2b549c488913eb64d0eac57a78c43a699ea168085e2"),
		additionalInput: [2][]byte{
			decodeHexString(c, "00fbd9fd9922029a48a6293958ed90cca72d97ef27f758ec"),
			decodeHexString(c, "2f17c557b5b475fced2fd433577ebc7384e5a59aeebbc3f4"),
		},
		expected: decodeHexString(c, "73d09e22031cc800b50a6e2bb189a69bb06dbdf03c32c042c94e407dc3047738eba7c265d815c3609f75144207b60f866e230aa9a43128d6a52544d5e220a8782865cd56aa3e2fdafab705db3eff96d6f2123ed932a447ba3e7d3db01b240e20a68846008e4c9e51d78d337cddea8ae4"),
	})
}

func (s *drbgSuite) TestHashGenerate27_SHA224_12(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "87557273860b5d01c48d8196908649c4b88328809590e675"),
		nonce:           decodeHexString(c, "56833473f22dc22d14170a55"),
		personalization: decodeHexString(c, "998435cf6d83dcaa8e4bb70a1139817d223ddfec2adf7838"),
		additionalInput: [2][]byte{
			decodeHexString(c, "16708c9a59592f37f6d94f5937c4adb1707f93be28154d82"),
			decodeHexString(c, "829a67d0b1814dd03f466f37ffb9c5131f7d74438a685f8a"),
		},
		expected: decodeHexString(c, "d1fa4436d881a25a10e5120c2935c46e03a3578a21efb382a68e22eda8c9c52adbaf611dfa14291e86ad62b77ed8d5fd5305f82fab0c0f8315a2bf6790d45fb4f0a9d3b704e4a52cff215526bc2b5b2427c51e117373edc7b254335914f19430c56a56dff1e199a8f727b0543e3c4149"),
	})
}

func (s *drbgSuite) TestHashGenerate27_SHA224_13(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e26a797b9bc023f5fe87c7586165df6eaa17ffd60d6be21f"),
		nonce:           decodeHexString(c, "bcd47b2bc34eff92a68baaa6"),
		personalization: decodeHexString(c, "9b51cd536ccf30091302e654758fe1b2d2ff820b3c42436f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "58aac703a592da10ab6462bcc2ec2d67ce31a747a9098662"),
			decodeHexString(c, "5a40bb66161a7c1e1664d2ad911f323727198d5f8dd41986"),
		},
		expected: decodeHexString(c, "7f0b2349248371a7b4d07888919d214d94de1b3ee1e3b9f87ba84c9ae6f14617398920e632e34e6c03361b9ef0a5c96c7baab811fb3f0f6ae3a034ecb604b59ecb274e847239cfa1dde2bd238891b5c9c8e4fd8d8783f18f46a18e2277fdef293ad56abe9517e5c15e3f83cd6f458155"),
	})
}

func (s *drbgSuite) TestHashGenerate27_SHA224_14(c *C) {
	s.testHashGenerate27_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "9e7b96155105119e84d8bc01d157e096b55d8fe43beadd3a"),
		nonce:           decodeHexString(c, "84e628d6411c355793266da6"),
		personalization: decodeHexString(c, "dccbb94a69a73d5428753bbe29a53657060345b9db3298a8"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1a6853817be281e26796430dc90f014f6fde64cbef16e58d"),
			decodeHexString(c, "bdfa703974a758cd4eb00661e0f4663f4e574cc7be6906e9"),
		},
		expected: decodeHexString(c, "23c9f591ec9abea9f9eb89ab8d705a1e570fd2888772db5d6fc6e418a34e32d78fe49be8d4d8288fa397b57afd49c07b715e276c68a2eb8f3e63f67de21d8ad23fbbdcfa03b201952fae49928ce4da66cb70638398bfdba4db7635c8c726a3cdac22c98ae776e881edd60b69f0b38e4c"),
	})
}

func (s *drbgSuite) testHashGenerate29_SHA224(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHashGenerate29_SHA224_0(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "a8dbb0592dcf5173471de8818a20bcfe1a5d556b60dc3087"),
		nonce:           decodeHexString(c, "b84edec829fc7262aba706c5"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d97f4bfc7c27073b4101c7c5dccf7819d3266a031d31cf90"),
			decodeHexString(c, "0edcf2e8d86f9ffced03d2bd6505cd9c16d3097ad2b9d60a"),
		},
		expected: decodeHexString(c, "7b3e67ac5f353053c73c03d80f8c070fbd2ff490bff4a577f2b97f5b5fe926d4ecf61b2d6fa290a769e6206e33e02c3355b6ea149c2ab754738260393edb3390b7ed8837c751370b116affce76cf1b62d7fe96b4d6aa0c986749828c20835ca939eca5f846bb90623bbc7adee4400409"),
	})
}

func (s *drbgSuite) TestHashGenerate29_SHA224_1(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "c4ab93b1af2574f70bcc6566f9035f1a4f78ccb4ba7ea719"),
		nonce:           decodeHexString(c, "2278891c155a1be29276334c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f780f62b823ffd10d7473764dff5cf9492d4205b8fdac28c"),
			decodeHexString(c, "91e8e6894bbe6558b1a5249bdcaf220f8f9bd8b33cc8953a"),
		},
		expected: decodeHexString(c, "8921c09ac83ad49be61df6f45babb2239a1f7be9cd2dc5979abc29cd15aae8d51e93080bf28697f49a152068431c7717fec47b95a3fcf00c36671a4f3b3bd2e66b3f4f0979441b7b224ce1c0df34193cccf0ad1ff760d54c293ee9560375b344bcef715af8e511de772a0b0d6108d69c"),
	})
}

func (s *drbgSuite) TestHashGenerate29_SHA224_2(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "b56380830ea9fe95209e7d6aa4c23b71d34a58cdff979c03"),
		nonce:           decodeHexString(c, "ad1698ff336da87908e6f5ce"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ec98aad65398c61bca7b7b32440bec139d646f1a9e484baf"),
			decodeHexString(c, "8f151a3c7d292cf742621101c6e4ee7226158e441c9a012d"),
		},
		expected: decodeHexString(c, "58eaefccbc5d04e9c8f584c4e5455797cb4e221c36b4e3867ea9f16f72294f9d0a1e6f7b0a6ab6d51a6935df1452f1cabd408974bdee9a17c52ae95068e6ecb7ec55ee39062fa795e647c7058f9e71ec01ef4f398bd11cdf88c61771982477e2478c438bf8f1591b0945c3416bfa439e"),
	})
}

func (s *drbgSuite) TestHashGenerate29_SHA224_3(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2c1b7b611c85df6e59907df53e5d3fc597f31f4f7539de2b"),
		nonce:           decodeHexString(c, "a3c67467169a12beb63f34ef"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b84eda25bbf4f706ced37ad409e69b5564fe7403237bea6b"),
			decodeHexString(c, "20907c3cdc7514c09f37e6f469e85944c00781a90de40037"),
		},
		expected: decodeHexString(c, "dff125381a7299be9f571980a7ab068157d05c21b37ceb400b5abe6513d4bb05136b0f1a093d8363b2d43395403fc11c2f2a1b6457db7b44dc165e918c5bb7567de7dde0fad44d47bed60a98c3dda461c36796d99ed2799e7ff5db8dad041b0c63a36f103103d699df8b555713f40e8f"),
	})
}

func (s *drbgSuite) TestHashGenerate29_SHA224_4(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f1b9bfcd31a1fb8e6e8b6f05579674b5058edb1191edba86"),
		nonce:           decodeHexString(c, "aaf079e0d66448177dd35175"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "706137c5519d877beb492556129e28481617cda963c82a67"),
			decodeHexString(c, "06cd1a519df346e24078d435b5c2790e1d3facd3cee6087b"),
		},
		expected: decodeHexString(c, "d839b094dc03598b56f864a1077712cbeb7558209b5ed19a5f0f69653664ab89249d4ffbc80624c12cf19d7eee63f0bb9527beb5a057afdd2570f5a54b77cf64f1bcddb6e6995c997786903caf1242d808484fce6acbe85e357c9759668f5c232683b3b54083b781ea2da4e7c8bbe876"),
	})
}

func (s *drbgSuite) TestHashGenerate29_SHA224_5(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "fc4a6f6e2521d029e56bd53c430b2d8d5adcf9afe8d0b6b3"),
		nonce:           decodeHexString(c, "23bbcdff40f58cac16e0c26f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "58b02447c1781199614a2c9779d391816ccb40908600427a"),
			decodeHexString(c, "6b1d9257d8cf58a28905a8b308b7d433d4fd0565c1d1e8ae"),
		},
		expected: decodeHexString(c, "e625380c083be01bc4ef0123b622356bb0528e78614b18fc534123b5b7ba0127cf7cb8d0c8df89e8bcf2ce9880490d28e75b8dd8136263cd9b328b04ea469d1dd1086f11a9352fad67f78f82b945c75dee283848055f83a82897e06703a66f8b18cf1a88361a701d1c0bd738c7745b41"),
	})
}

func (s *drbgSuite) TestHashGenerate29_SHA224_6(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "20948d554a41ff027528c1300809bcacb4780b959469d578"),
		nonce:           decodeHexString(c, "2b9367eaf432073142dcee41"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "8b7f07e8263842cfaf7d582c0927864170ae4df33f0311cc"),
			decodeHexString(c, "73d0eeaa3206998cd7a2dd70b60d6da178c65a3a9fb215c3"),
		},
		expected: decodeHexString(c, "40d20a3df1351bf03af3447da04a930270de48613a1b73681fa041e903385d4257a7774b8d62e726050c9a21da17af8e0ec107bfae390a37895d71f8d126ddd015b1d4e77a205b358f85372fb81107f0a5ec2fdbe37dd00877d286cecdd1991fc1638bbeaab27a3ac70e8c060747cadf"),
	})
}

func (s *drbgSuite) TestHashGenerate29_SHA224_7(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ff41b81599810a01cca6159097feae80ab55e03dd04d333c"),
		nonce:           decodeHexString(c, "fbba10f7eea1e17b95c6f4a0"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a40fc869741f62cbcdf1c6ca2faac41e40450c3624965e1f"),
			decodeHexString(c, "7a7f5ceed2127cc6a16943ef630f07c9031326714e119df0"),
		},
		expected: decodeHexString(c, "3a6018a00a97ccf114c3b764fef9215d6484da8ba9e085ef26d019be93f8ed1e37c4b891f88bf5ea051c1d09f4bd6851967293acc8a7ad73ce5c73366aa2404de86f9fe1c077d0434ec39757050e986a2f86f55e8a6bec27b016e0dbf4b9c9016f0a918eb417f441f7ff724d5ca8f468"),
	})
}

func (s *drbgSuite) TestHashGenerate29_SHA224_8(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "5e7fa3002e0f5adabe9be1b79d792a16850d43705e744453"),
		nonce:           decodeHexString(c, "42b548d2a692fb79db011e43"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c1bb8ebdd77e142537f477557f190b026fbc1e0bdd1dc4b6"),
			decodeHexString(c, "a72b7c2552e9b46d3c34084a5da6c122e3cbe53f988016ad"),
		},
		expected: decodeHexString(c, "2770b5910cde1fd5e54720d8b57e137ed77c2a7a50ece9c1c019bfbf92e279f141f71586764deab8214e83a4c9b3e61fd2563a8ed9645a2f13004b9ff3c0481dc1db497d63456103816414e4f1cf002cc24a0da861639fc847711f661b9ae91b6982ef2857eafacc8621fa4c7d66fc11"),
	})
}

func (s *drbgSuite) TestHashGenerate29_SHA224_9(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0db64b56c91e1d72e019da8b9829bbcac9e64dd674f64560"),
		nonce:           decodeHexString(c, "d1637d39057566d9d20a1320"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "33f94abc4a8846483abc9695edbaa3479bcad3b994b80ce8"),
			decodeHexString(c, "781e62295a01cf6513c0b917321ee9fb1ebdf2674302b48e"),
		},
		expected: decodeHexString(c, "36043d99c14308be1fc5d518955fcf766f7b7e81812fa42ee98b367c5a5c5b46e2eac44ddffa3c21eaa48ec55f7e416cac71651540d5f29fe95b24dbd203f83c074ff2f9e6b561055121274438060450146c2c2cf21b884035c7f762dd923e3acf21ce26dc6291be66e93d74e9d3e8b2"),
	})
}

func (s *drbgSuite) TestHashGenerate29_SHA224_10(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ddac5cd0ab9f7fd33bfca2f320c82c519ea4a65088c064bd"),
		nonce:           decodeHexString(c, "72a7a2d38467857f6d887d4a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "7cef1f18e474b776a443980ebfe97d8ad661391c46d237d5"),
			decodeHexString(c, "b3d6f72fa5f4130b96f64cef11115aa4fee0b68fb5be5910"),
		},
		expected: decodeHexString(c, "2f3245bcf7d45e1e22e3842857fe2b539e5938e0eae31271faf93f301e4aed4a4f4efec3a081bbdeca2c3c4e70fc0299a920261e0852543551d8de0b25bc2f543b6f6183b859e50c0162b26ca73a9ae6e504986b4ae5cd69b4abc8f6f1a12490d4f97b74a0650c8e8576aa165f453be6"),
	})
}

func (s *drbgSuite) TestHashGenerate29_SHA224_11(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7fd978b33986297a99ac44d269222b20828574624bc208b2"),
		nonce:           decodeHexString(c, "7cf10f8e5c1188480ab5e95a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "65beb2e3a0fc3484e34e957ef004715762b2b9fbd68ddcff"),
			decodeHexString(c, "df6f2ddee86689f5a8592bd41e1cb59fe00374401ff7e8a1"),
		},
		expected: decodeHexString(c, "5d9bb9b209911577b187adf0ac343a5a0545b77191d7e1cc191c2fab4e86ef6a88fb1282141d83994bc039e17f4b7d29ae8a3117586bea2afed00a41677dfb2ea9b68d6618d75da7d0afa5ec4a14ac80be6873d158f23de297ed4c0aa3b5fadeeaf189c7126c460b9044b93b87c71c69"),
	})
}

func (s *drbgSuite) TestHashGenerate29_SHA224_12(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "ccbc856e0ad43d99b8d62e6d9a3ad4c46619c738003c833a"),
		nonce:           decodeHexString(c, "49a96897c2d217859598faba"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "af4eee45d2958ea81f98ed760a8a220384fc1116fe54df7f"),
			decodeHexString(c, "b5c42a81a7c83320235598bee78b2286b91f236187f5b85d"),
		},
		expected: decodeHexString(c, "4a44fb3cc340ebbda4eb2d55312ebe2dc23ad7698d78b5556475f764003e50fe9e48dc33b6d1441b4a26f2fc5ce357dc9ff99c32ebcbb38f66c2052034bd98fb6bf638c6994b312ec5e389cd7b72f4312043c772973eac1664146bcb19dd97e142613f6aa26456bbab200ab98215a8fb"),
	})
}

func (s *drbgSuite) TestHashGenerate29_SHA224_13(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "4b68982eb3b81c8b149603cb5176598a7b405a71186afd63"),
		nonce:           decodeHexString(c, "9b62ba7d0213555226c43b4d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "8ecd586643a108b396694e4d30a28d32ef32551777a2d094"),
			decodeHexString(c, "f977340856dc1f6d1e90b74ee76173512ca25c59d9bd9495"),
		},
		expected: decodeHexString(c, "c117887bf34cd682114555f017a0689880ef011254023570f5f78dbf6223bf6e94ce9c2023abaeb579791249191fa1c95ba3f1bbf9278836943ea8b37aacbec8f0d0b1c42d30c373138ef078ad1533e4f17d3d87ea093dec837ae90afe8905a7f505603be966a2cdc8512f8ee8b19f84"),
	})
}

func (s *drbgSuite) TestHashGenerate29_SHA224_14(c *C) {
	s.testHashGenerate29_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7c6d9c85ccd4cfa4e9418baf144da0f635f0be86a4cadd48"),
		nonce:           decodeHexString(c, "8d574440a514427686dd0eae"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "71b5b9e9b813b5f69e8fa9fa7f588217268581b7d135fd7b"),
			decodeHexString(c, "e5b06d8f12539d36c665cf129c1c42e3b7e88edce1650870"),
		},
		expected: decodeHexString(c, "64595391a02ff750b46418274b8366bbca0e9c52c95bbdfa65882b76395887a018faa276f3fd6c8dbccdb964755e36508897cdac977037d0978f2752d1dc68bde3ba1edc94787c1c8cfe42c2347052da30ba7f1e06b44c10805196e7bb048cf572fda62b4a28fc189702b1e575b008ef"),
	})
}

func (s *drbgSuite) testHashGenerate31_SHA224(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA224, data)
}

func (s *drbgSuite) TestHashGenerate31_SHA224_0(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "de1fc2448e0033444984047e187b6fc2c15d638ba445493f"),
		nonce:           decodeHexString(c, "a7bfe594b1e4e735a283b49a"),
		personalization: decodeHexString(c, "a3985856f6cf4ad07b57f4932cfa4ad96256e3101964c4b3"),
		additionalInput: [2][]byte{
			decodeHexString(c, "cafc4a0576ce7beecd09717b413854b4ce83ffb12a19be51"),
			decodeHexString(c, "9dd94e1d4ceb539a59ea283596e11711576d24a51316ebef"),
		},
		expected: decodeHexString(c, "e96607fbd3379d34d505a80b2afb102e2b6ded5f587e75fdaf111a1d325e972d6afb3a4277c07d1441d74b26250f9a9d9022431569adf36833cf30922ba462fb6cfc1777473f84452d2abe498f29a7fb8acf924143d8fcec84603d7a022a0893ebbcccaf3d390f22b63097ef007f15d8"),
	})
}

func (s *drbgSuite) TestHashGenerate31_SHA224_1(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2f9ff6037fc3ba1d56efbfc890a0cb543d5e2c925a97b0c9"),
		nonce:           decodeHexString(c, "70f99e00b55e3cac6357b0c5"),
		personalization: decodeHexString(c, "978c1c174b077d1eca30b7048ad51c08c8eb7075356d12a7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "3845a37b64c25844da62bbd7851976ec13815f291fcfcaa0"),
			decodeHexString(c, "8aaec921ca08c9e9e88c1d7e2d904246b83a2de50d80902d"),
		},
		expected: decodeHexString(c, "4cb4185632630662d984e834d0ea3c0bb1c7fcf4370979b8cfb3812387728b4dd5bca023911ba0b7b2e0c225ee2c630e1f77463eea3cc20a71c4e6da4e6590bf53171207d70d35f401c2be555b74ba67be41c4a2fc7b255d44b1d5483d33f813046263875ce52b9cb44a29392f18616b"),
	})
}

func (s *drbgSuite) TestHashGenerate31_SHA224_2(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "0e34dfd2fcaa9b61e43f1e3d7671f67b1c740727eca8de3e"),
		nonce:           decodeHexString(c, "9e86de397cc30e25cef81e69"),
		personalization: decodeHexString(c, "591d7cadc1b4875cabdec90ea5e121432770a0add5481106"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d13e2237d7387f97d9fabf10f6d33d2f47371e95d101a97d"),
			decodeHexString(c, "90a31e97a288a714816f061ddb62466a17e3e8e860ea6591"),
		},
		expected: decodeHexString(c, "2a49158f8c5fe3bceeba5f43417ebc99d664f169d19579cc959607c20065498e69b5683bdac9fc02ddb7ffaba3fa3fb556dfb89e692c1f56cfd9d367d287e07d4367b10a7a35099baa5a9a645dae4178a688b0f2886d050642d5346576b3428aa6f534edc8d1b472645b0fbf1d9a84d9"),
	})
}

func (s *drbgSuite) TestHashGenerate31_SHA224_3(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "e2ffcf413362ec0e5f64cf6559587c99e90ca53e744c7c76"),
		nonce:           decodeHexString(c, "29cf38eb43688c895473e6c4"),
		personalization: decodeHexString(c, "c9e9b52552287e7cdf1fba96ac9a9f933ce83122de0c2550"),
		additionalInput: [2][]byte{
			decodeHexString(c, "43b4c0f0f1a951bba10a3168750ebc7ba9429ca1a0d9d833"),
			decodeHexString(c, "d006395f7d47c5c54e99f7edb31711e58554a872c9628996"),
		},
		expected: decodeHexString(c, "876d500e593fe085aca5492adf113edf3decae539493913032eebcf8630b9be8ced544a6ddfdf2248d2fb5fbcae26ea1e799fac91d49e1bd4ce13006e9e899c24eba714a7cf4fc15fd8c7d7d12682e851b32b93e45a2db1c0a797b5f03b2f25ec1ab257a7857eba257712a298deb3363"),
	})
}

func (s *drbgSuite) TestHashGenerate31_SHA224_4(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "dde4c5e0494373fd847e1cf9ca64c1192156ff072a177e73"),
		nonce:           decodeHexString(c, "957462efa059df6f56477315"),
		personalization: decodeHexString(c, "2d2f37b8e2d2788f2ce3272410585fa4cfa5e9174355503b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0546cbc0b8a93030e812eda71d40d514134f3f81b9b63587"),
			decodeHexString(c, "9c7d51a9f7e0798ab67cce06717eb324288596ec6d3b57fc"),
		},
		expected: decodeHexString(c, "55280136c9399e638dae3183afdf03b6cb91f04c85f728e65d5d683e8d551fe55e47449e782a7b8d5c133abec46d9164ba30710457a0d38ddc937d92558f768f757f6512d08f198cd5f3ebcd2bae21f0173ecdf5c1a59e8b87e9af4fd93de0a548f7294558ade7acb748b95c24184ad4"),
	})
}

func (s *drbgSuite) TestHashGenerate31_SHA224_5(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "c4123044e021a669bc67f477ee9fb0fcf8f777fd0d8d3fc4"),
		nonce:           decodeHexString(c, "c152d4000ad67858256e3cc3"),
		personalization: decodeHexString(c, "bc7d7de5487fed58f18ba3196938db5b1612ff8d25b273e4"),
		additionalInput: [2][]byte{
			decodeHexString(c, "68ff8f956bdca81fea0fcb32e564fd4d964999caf1ffa54e"),
			decodeHexString(c, "66a47d5368654fd60dba5c85862f3d348b5482bb251970a8"),
		},
		expected: decodeHexString(c, "70f629cd970034597c24fe00162d5c3f2c5097c685e9883cd2cd83e7b3b883224507eeb12797a98e4b4509b1ddc203c99fcba4c5ee0a7d0440f3e8e55e81a842aff210b3c7c24a73dea10f1fc3d4fff16a49094fe919c9084d2f0af39f1f66533edf90eca7cea1ae8fd676b7df0761a8"),
	})
}

func (s *drbgSuite) TestHashGenerate31_SHA224_6(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "f25e241132fb3410c8ef3f656d71dd5a3e3d6c72f0e6e9be"),
		nonce:           decodeHexString(c, "8dcc1aaeef78bb09059b2c4c"),
		personalization: decodeHexString(c, "e86fd52e459d5a0452ed4e21f2875ac3079856f1faf64354"),
		additionalInput: [2][]byte{
			decodeHexString(c, "51a0ab662e9f592b92885c3beedc9f06e59c4a338ee70bce"),
			decodeHexString(c, "3f9f05cd66cc7e3d83cca473dd9b859dd24905e80833fcb4"),
		},
		expected: decodeHexString(c, "7809f1fd836a54c202befc994e47f288d0be785d794d9e52a0f56ffda32d706fd8d2d28cfeaa89a44cf514951bfedc9adf6183d297bae0e609665e4cafb5e0ecfc45cf3a760b538290ff880c1d24f031382a42d3de9639a44fe8ed15c4b79de8512e2dcdd68c38e59b58207ec1b40384"),
	})
}

func (s *drbgSuite) TestHashGenerate31_SHA224_7(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "643a0493bf6b7ae347c63a708d4de9ea7b9536c386de6c74"),
		nonce:           decodeHexString(c, "28966cf93eb8415ec6653bc8"),
		personalization: decodeHexString(c, "6929e98df76b8d767c414a7f06227a4e88003a1dcd2d4ed2"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b6b3aa1f95e9a2eaeb51ddafe4d303f5b0165933055c25fd"),
			decodeHexString(c, "1beb02a0183407e74fa5166808beda53feafb1d26c8b9db9"),
		},
		expected: decodeHexString(c, "eab0ea389bc66aeb0f01302ee412a7c87f300c95e45919bb9565a49fc2ed5e65d73d9517c3b4e10a1305bfef65c0dcf0142bffa715f4e041b98fe055483567a7b2f8f0e63aeaa6ec267bf7a54884ff3ecd11be6873fba7bffb7df998e80235d2360f23110c82fbcca12e08e6330b9f64"),
	})
}

func (s *drbgSuite) TestHashGenerate31_SHA224_8(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2145e283d674ce8061e31925d888e26b4d8bb7ab6ec162dc"),
		nonce:           decodeHexString(c, "d87f3bd6b88cb1469caa4369"),
		personalization: decodeHexString(c, "f9912008933b4604ddaf05b277fee26c3f8ab1696a7e0b82"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e9aa10aadefed36f4d65a034af21ac15d8ea6768785e5e9c"),
			decodeHexString(c, "2a61ffd60625f27ef7d03f755693cf152426cb35e9e2aa48"),
		},
		expected: decodeHexString(c, "aae61efe5c21ff8b25dc39bf885a845dc1f21ad37956d63b0f419b3f7692ca037297e4fa5e3e83f6c72bdddede3fdaa9b7560877fde867da51b3769f5ae58b84441eb739a6256b09366fc7eafd1b11a4078d028e7ac328cf7e11a76b9ca3286f4df5e9e23798f2347e201630899fefff"),
	})
}

func (s *drbgSuite) TestHashGenerate31_SHA224_9(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "7483bb2c5e9df76ff37f2d8919ffb54aa6adc0b992f1b4cc"),
		nonce:           decodeHexString(c, "bf5f3b883468d1c49733fda4"),
		personalization: decodeHexString(c, "47282993db33ca2ed7fad8236063aad6313b788a6d421f59"),
		additionalInput: [2][]byte{
			decodeHexString(c, "de49cb2490296839bd41fddaf31f3388252d41cde88aa215"),
			decodeHexString(c, "dfb03b86d8a19a2064ea289993854045284d08ffa68e309c"),
		},
		expected: decodeHexString(c, "c170e7e13ffc5a410dff29a6c6ddca5652c0f0792c09b66eec1badd7f4df967d8b15c91becd7f414019df2ed564d075d581153a2c2e0bf1294fc65386e286318523efba8728fc1e4ae030b9b001aa2ddfc48a5a7756cd60bdaa55f3bfc7bdd86091c90065f2f65e34d00e9d40d6bd2a0"),
	})
}

func (s *drbgSuite) TestHashGenerate31_SHA224_10(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "2f42a38e99885aa203085915c1be080a6cf6e0264b0f2354"),
		nonce:           decodeHexString(c, "977a232d6aabda96cc84a4b5"),
		personalization: decodeHexString(c, "2b6fcffe888671b20cd8e12be8737e5b963f9aee1ae26ed3"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8d727475783d45e864ef8a53aa3687edff5030525ea75b47"),
			decodeHexString(c, "640b60cab272ab414cddea8970a12a3e6cf6885cfef7a034"),
		},
		expected: decodeHexString(c, "4d738163a479e71f7b45dd0c2ff08eaa35a10d7e7b07192e6b88915c2780efdb7d7ca9adc239b26ee24fcff3ab419ca26aaa575a65e334347f259a0c439ec15cf2702685a6b9933da6825b9c394eed70b24fd69644b642f1fc4a0c12bc390ebfe479bdd8ff7a4bf37b03b8d6f2ac7632"),
	})
}

func (s *drbgSuite) TestHashGenerate31_SHA224_11(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "de952b5578d813ed8acf967ba93f75098d423eee2473fe1a"),
		nonce:           decodeHexString(c, "71638a0d1e6fa1e51c56bdc9"),
		personalization: decodeHexString(c, "74dcd9ae2c668f0256a601186140446eb44673399be80771"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1259e07bf0e060137b8ab17a244ba6a34df152d34c11a2d3"),
			decodeHexString(c, "55804e4c7029832e097cf404d6cc8a87121750e28feba0f1"),
		},
		expected: decodeHexString(c, "bece47e28e5bffe94522bf00c8564c39b1cc03b6a86a48192e8dabb74d24d0c7b3dea71d104fc6a4c9ae48ccfeaea474f4dd639f6dee9c6297d54b80adbe9d564b2b3c38d970fc836a8a8376ba5b991613df421286bffc02eb315a1db3f37ab5dde6344e25a3acd1513c313cf5fc777f"),
	})
}

func (s *drbgSuite) TestHashGenerate31_SHA224_12(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "625e312e5d83f306dd93c5722f5624c8b6f3e5c014dc77c0"),
		nonce:           decodeHexString(c, "54f58da4c06c6525cc18a12b"),
		personalization: decodeHexString(c, "3cba7790e518323c7c415c5ff8a5d1ed959d25936cb689ea"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9499c0165da8ade78a8616f3eb815660bcca2480b766404d"),
			decodeHexString(c, "5942ab9dbc8464e4928a006a09a5c03141fed3ea4e9c58bb"),
		},
		expected: decodeHexString(c, "f1870634d5bec5ebce2e0bd52c1616926c79c053271bd9ae34e3cb16fd0d598d96fe8b6daebeb7977fc0e1841b8e8bbdb0bf0a2ed4c78104d4d60a5d38c79e5801538c81af945c7c3b4d8813bf2744b688577140f66f8534ee537d2dd78ea005c688ed91fcdaa74cecdb062439121f64"),
	})
}

func (s *drbgSuite) TestHashGenerate31_SHA224_13(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "02dfde97b93b6c5bbae81b95f0d0aafdd7c0dfcd88d7ea19"),
		nonce:           decodeHexString(c, "59135b7a1abe397da4f5cf4a"),
		personalization: decodeHexString(c, "54faac09060a302f27a4986cfc14e49de181c83d6f74cfae"),
		additionalInput: [2][]byte{
			decodeHexString(c, "74e500a48d1b58b0175f0b18339ea02b11686d2d13f01e22"),
			decodeHexString(c, "6aa3c0391703a47029da8f41c77f8ee78afa0b847dd771ba"),
		},
		expected: decodeHexString(c, "8b0cc9bbd6d9f6a1a1273772a2592692921b464aaa3414ac3505a6c28e3b007ae7875088038e2f1b2902450f246346ef7f097a6f44951a63c9ff5bd136ab5925e9d5ec690cb9e990e4b1b15d38f4f209d86e38f5dd798f716cfffb6bbdee4e541351f86c0c60418a3afffabffd7d432b"),
	})
}

func (s *drbgSuite) TestHashGenerate31_SHA224_14(c *C) {
	s.testHashGenerate31_SHA224(c, &testData{
		entropyInput:    decodeHexString(c, "63b6771661ab689809ccc5e5591bd1743921d6ed1e1ddd01"),
		nonce:           decodeHexString(c, "b634e989ec3bd5b59777b27d"),
		personalization: decodeHexString(c, "822de3952ff36cf2d4e4027c12c4f7cd665c08d929591b21"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e5c633ca50dcd83e0a34d397df53f6d7a6f7170a3f81f0e6"),
			decodeHexString(c, "5f0beb5a2d2968e83ba87c92bfa420fd6e8526fbbfdea128"),
		},
		expected: decodeHexString(c, "8bec11df1022aa50d95daeaf23d78d6ee45c43c5768b90181e106c7df8ff333d7cb87ca1ab83f8742370db1c8c0c0c22f141ff4de33ae8bdb14fee7e6c069819320629c66d94c7c97ff52930a3c1dcd501b60f0f84bda4720ee187ae858a6e068326eda5809716e366d1b608c61b0100"),
	})
}

func (s *drbgSuite) testHashGenerate33_SHA256(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHashGenerate33_SHA256_0(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "9b6d88373841458da926cc51f83922d363f0f80f90a2f5505c04033824ef7385"),
		nonce:           decodeHexString(c, "82b21ff47bb5e1b33288b22f3856886b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "45d21d94ae1ea460857b50b5b240d943d42160e4c12377e0f817b79e92530bc1"),
			decodeHexString(c, "ea432e31cc94c20d66fb13d1ef42a5f62b024134fc635aa1279a6179204731ca"),
		},
		expected: decodeHexString(c, "3d23d0fc03936766a1e1330393e8ff6211149f3d0758db038da1c833ca8e5265c2a9ff6c8e0836904c5fcd3e61b1c77d613dc6bdaf6437573a618e3e75e455338a7f9a41300da8fd2da408cf095ff7eae1686d60ce9c2f547d0515da91600201c8374b7af8a5f49a6381aaca394c65d451341a0ae1546cd57e0d9167a6b5397d"),
	})
}

func (s *drbgSuite) TestHashGenerate33_SHA256_1(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "73d3fba3945f2b5fb98ff69c8a9317ae19c34cc3d6caa32d16fc42d22dd56f56"),
		nonce:           decodeHexString(c, "cc1d30ff9e063e09ce58e69a35b3a656"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f4d5983da8fcfa37b7546773c7c3dd473471025dc1a0d310c18bbdf566346fdd"),
			decodeHexString(c, "f79e6a560e73e9d97ad169e06f8c551c44d1ce6f28cca44da8c085d15a0c5940"),
		},
		expected: decodeHexString(c, "717b93461a40aa35a4aac5e76d5b5b8aa0df397dae71585b3c7cb4f089fa4a8ca95c54c040dfbcce268134f8ba7d1ce8ad21e074cf4884301fa1d54f81422ff4db0b23f87327b81d42f84458d85b29270af86959b57844eb9ee0686f429ab05be04ecb6aaae2d2d533253ee06cc76a07a503839fe28bd11c70a8075997ebf6be"),
	})
}

func (s *drbgSuite) TestHashGenerate33_SHA256_2(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3c898d0b88cfde1955ca1c25d3c876c834fbf4ecaad1cfe7f2072dde4184f34a"),
		nonce:           decodeHexString(c, "cf65881c53ca2b79541dae65b15ed8b4"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f5b4624b38efe5115e54937dfe654e2ba7dfe64ec88a6442e53de50780dbad54"),
			decodeHexString(c, "64e14c43a3b2f2bb638d80eb5e57e74b07bf5005a424e0c1b5eaad6a26e9cbe5"),
		},
		expected: decodeHexString(c, "b2a5c7478dd213b82eb05a0cee3dc6fe25c8d9bb64b90ceecc17c56b0cf8fd877d330e3091cc27e6baba7961251818446eb44eafab8c6532c5fdd3d0f0331baca3d81a6f20494e524e73b21dfab347bb54f2bd211621c88aa1813c26295a80443c87fd9476616af7ac8ca83738d95dba2ff421dcabb8b5c82f445812a545fba2"),
	})
}

func (s *drbgSuite) TestHashGenerate33_SHA256_3(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "59e6b039e5174328c4ec09933e51bd01a1de95f01df8bbe73edce41b80396b78"),
		nonce:           decodeHexString(c, "c6b56372644546b6731dcfc68858e4ff"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d87ebb74220a6f15e8afa0c4bcacf1af13da5f5ac17c896ecd9de40bf88a559e"),
			decodeHexString(c, "2974f4ce59fe9e5d605bbea8b7ca203b25dde4b76e02bf93b7f06393d7f9138e"),
		},
		expected: decodeHexString(c, "683bb8bf39ac5513ee5d83235f53dbae4ceb1c6bce7933ac3b5885939d6c42e9939808e27a492e842330620082c716f99c75f213b9edfa059f93fa952b3968db3765c5eb8e6762810cfa2b6c8a0039834b2326710fb5e458354fa6697574f611ad50c99c13acc906df2ebcc68a040b5b11ebaf95884ca6931d95ee3756ec888a"),
	})
}

func (s *drbgSuite) TestHashGenerate33_SHA256_4(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3ac6fc55ea67b9735f21f597d0b9b479ff0a77995f1d8a12c2876b09b322ee75"),
		nonce:           decodeHexString(c, "4275cfee69dd2f9c4be5099ff62969bd"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f44174a0bf525241218949269a3e6003911e421a35819a98b8bf5f93aa78a091"),
			decodeHexString(c, "331fcc1af5ce6ae7996bb8b0731575ec8d97c5fab072bb4275f2faada32509d1"),
		},
		expected: decodeHexString(c, "dd5c54bfc1a3084bcdeca594caa44e9ed7551cba4e08c945ce4d1412eae73a7fd026e2efa96e91e59e3a0f0534bec554b5826e0d75b2959242f0d3d7564fe16c3600a129f74c450bfe39b0a0030ac07e8a99862dd74d4f84c2ac83d526b0617b24f16b2789c93f375e1e760e7f7b326d0ed00b5d57fe9a1b6be441e321d8d51e"),
	})
}

func (s *drbgSuite) TestHashGenerate33_SHA256_5(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "49767ea772dccdb46873254add3edb457d96e8e372fad8a83ef0e30f59a9c8f8"),
		nonce:           decodeHexString(c, "3a136c8903397675c5356eb5cc5c97b0"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cfa444405db381a4700f61215d38bf55d1bf16539dbfc8f4d67d43173b1da349"),
			decodeHexString(c, "b994b14265ceb89f580d7ab9837a150f0a47b53676cc9a8ee7c4a047eed9adef"),
		},
		expected: decodeHexString(c, "acccdcf505120250e5c6015ae085b90a92e35b35df3a6751cbb8d5068a8338451fe2d9b28985c4a145038d7ee3f13130d7abf63b9b67b4ade6e67d0712baf53de2edb340b4ca252f9dbc0e59008f4110d6fd841350e2da413425c97129af504c1915f25ef0db36c38a97386fa5949a2464091bd3b6f7f229777c438df5028a02"),
	})
}

func (s *drbgSuite) TestHashGenerate33_SHA256_6(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c9ac39cf41fbea7d7063efbfa8720a98172587f7c2a75716521e58ef7d77fc32"),
		nonce:           decodeHexString(c, "3565603453aa3efcec11da7b1de53cc8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ea0defb7a4c21ce69cdeec640285671bba779036de382bc037de24130199acf4"),
			decodeHexString(c, "2ab1926921f686b2fd33e9fc2cef4e5d030e051f50d4adb73c3c7be90929e76b"),
		},
		expected: decodeHexString(c, "fb6eec78eed8ac3c623c2b8015df988233fd436db6855e9d3e14910f0ed0cb6c7abd34b708ce39fd2bac9837a0aaf64460b93b12673e9dfa43a65f81982f78025268cad6ccab62a9e0edb7860b2ba6780c6b7292a279799d4f5d77c01e9e4804477746728e3d834e73f4c46fa0f010b0eae1a89d655c832159ab8b86781c5de5"),
	})
}

func (s *drbgSuite) TestHashGenerate33_SHA256_7(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "827076c54b7740f92244501069c0e3bd133b70bf737617bae2b05c42436d1a1a"),
		nonce:           decodeHexString(c, "db9ea9b3eb20d8914dc7a05c17273024"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "aebf4c50f089479e01736fc06e6dc8cb66ca03dd53e3ccca07e6dc6b8d6a4800"),
			decodeHexString(c, "404c9aac98518d4b39a75019f729d271d6a7664a42c225ab211f1452d7ffb058"),
		},
		expected: decodeHexString(c, "42fd372e3b6d47c89077e42f4634eb20ce349a33d4bee3faf1ebc0ecaf3cd98b2a2d16c8c602ba973ebb7255098bf498b4e273b54d647a6ef474891a3306007c0deb4fe6cb2288d6a08be5ed1ad96a60cf4d5cdf8ad4c9a5f831eb9dc9e3299b96bfef8dff43d774738fe81f36b2b23bfe5cf103fe36d47b94f0d24ca913d989"),
	})
}

func (s *drbgSuite) TestHashGenerate33_SHA256_8(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c8bfc49fed3468a1c4907275181b843d7b36598c547e7593e65472eecb610929"),
		nonce:           decodeHexString(c, "0c04252eeec241ac99ddb84a30187a24"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9fdb8ca4a7325f7b0a172d47ea493e9c41e8264a2a62cf4f5ef432735aac2b55"),
			decodeHexString(c, "f6fe7359d6993c9e6842c17b2328f01e00ea5123f4746265c160c2ba4f43c78a"),
		},
		expected: decodeHexString(c, "a4d366f0ab0d4017feb83f3bf7cc26d4b0938aac3b099dbae8a3e2e0ba06e1f089fe1f7026ec9ea86ee6ac5dd893fe8a64c9cd0a683787884b2c26082dd47b31ac09dcadb22cf6ae8e707c54e38748ab157175f7b7ed69b5d924d5cad699e1367bbb32b6762badee2e5e509fd48f6a6081e4c43061c4c111ceba5afd470d4edc"),
	})
}

func (s *drbgSuite) TestHashGenerate33_SHA256_9(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c7d5db3d2d84d4b464c9e98ad2171599247c157a4938fa2f8ce474e940bc0a7c"),
		nonce:           decodeHexString(c, "fea36dddd102ab8472653ec0232c9b7b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9b52dbe64ac0a770bf69db0aa0ecad599990d28f085ab409f2252a55d3b01cb0"),
			decodeHexString(c, "a403456feeb69abf91cb7422054b167725490756ccebbdf499df535fbf886007"),
		},
		expected: decodeHexString(c, "7f61226e0ff11733b84a62be5602601cbfa728f9840199fc0c0957e9d39b4133e6936b5f97b09250e9d686b17ad80f6366cd7dffe7644e29cdaf4d07d305cb25be2b17f5ef81c190fb812b93d2be0780de4d7838933c4365db9889b6c65d61f2eda63f30947e21c4d0c6130aadb903db65518e9df3f1ecd58b8ad50100742d64"),
	})
}

func (s *drbgSuite) TestHashGenerate33_SHA256_10(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "ac1b4db7dacb4f441af73eb4b6f05d774ae4fbc980450cf1fccbff7dda78e6f7"),
		nonce:           decodeHexString(c, "2f3686096587c177076939789da6a0a0"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0b3212fa7b2128b730c119355e76e38520c64c3c552ace52c74bce27b7b75b19"),
			decodeHexString(c, "e0290804900ffebffbc625454127118d251b2e8055ad424a0889b8173ff94d5c"),
		},
		expected: decodeHexString(c, "f16ef06ff5227da000e02c01b94350d9201013ce11200d0e3f69934cdc963fa886360d4ac2031c5c00d2c701264c5a193329dd71cba66a650d9f51dc124c7c016a7e0506b04b15513b5e30656b2c0bc12a7b266317797b57bd4d82ebb56e949cff26d6ed5083e35490bd77c8c4d088ac155d7998fc749b2974f21788db6e62da"),
	})
}

func (s *drbgSuite) TestHashGenerate33_SHA256_11(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "aa166e22cc538ee40ec2b84b110fd3355983d640d0e9aabec7f8bc0e17228a57"),
		nonce:           decodeHexString(c, "dbb258a9a489fead5ae91017f96a4ca4"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "06c47d8f46743aa345d83436fc2a9760f9dfa681d75908a3df1e15f40656b73f"),
			decodeHexString(c, "717a311e8342eeea8b369b74e25b64075add804d81f448f13515a7a71f818152"),
		},
		expected: decodeHexString(c, "6a935a251a50a58aabee538d29d8898de9cd18d7dd7fd2465f4ecda7a35cd94579d70ec0fd96f2ea9492030d9f74c0e2a9d29d947b9880f9823973905a79a030b6995bbf6c7a7505a36601b23d7504062e8a7821df01d092b2c93579dbc2579e6c64846d5b04b62414a59be3c0cf3caae40d3b847acff3b221580f60c7a7085d"),
	})
}

func (s *drbgSuite) TestHashGenerate33_SHA256_12(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "13e1bd42516a7193c1cbed5c54fc643623dcc0b59a4fad9aeeeefba207c8a558"),
		nonce:           decodeHexString(c, "c8c41ea0dd6580ce4a2372dffee3947d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3bd158cb5cd9435a711293ecf4e84649164b72322bf638e0749f8afbc119c552"),
			decodeHexString(c, "cbecb4c129c1cad1bb3e478f208034ba92b19ea35941c631b29b2e7b40d719c1"),
		},
		expected: decodeHexString(c, "0ea605fd73ca3dda32efe99b30e184973203b7a28479ef5a2b1375ef39726ed6cb8a6887710cb4d541aaef9646aec911d16606d2fbb2fb4e6e8a215f6ca5d251254b4ee5742093a5578ac74c80682f2dedd53df2c067e41052a59f84740c3a13f10472bb41d638bbc509db62d143791c2b09ee9161ff1021eb6b90c0ecb426c2"),
	})
}

func (s *drbgSuite) TestHashGenerate33_SHA256_13(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "2101469bd69c6d5bb217ceb621c03c25270d2ca7e8298560810a94893f5ba025"),
		nonce:           decodeHexString(c, "15bef90fd6ca8fa00a8ff1cb1e75f40c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "6d464d49a2d426d9321fe48bac2774764dec2228cfa1e9f883af39e1f06a579e"),
			decodeHexString(c, "1462a06143d7ad6bb0f9e1c1d7c00dcca212e4f5dabd795e57881b26b5cfaeec"),
		},
		expected: decodeHexString(c, "50b5eaf20eb7520572b214f4ff875a602e5a343ce69d0d73fe9b35d5ed43b9b9290b5f8319d1f753855c7d4cf97605862f7e3d33ea1caeb974d93ddbc93eb28664014caa87454d5773fe525f97cd29bd92fd273fbc1449340ff3e5a0fa752ddb56cdeb5221f61b35ea45cf4bfc5308f774dbb87c992e3618d3342fd2364b4912"),
	})
}

func (s *drbgSuite) TestHashGenerate33_SHA256_14(c *C) {
	s.testHashGenerate33_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "0238890e5ac9ff931824bd6d660dac9979b25df92702790308b124d40d60db64"),
		nonce:           decodeHexString(c, "b9b5d120774c962d946bd57615c92700"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "626385595bef7103af0af700e1df048d7572286af709289b7894d2ab09ca8608"),
			decodeHexString(c, "bfe8946dbf27d3a2127ec600351c3920d2531eb9419408233e0a888059b5eb68"),
		},
		expected: decodeHexString(c, "ee6d07661828213e6453d94faaf76345c70949eca4965714c350313b0bcd8e079e6a07f8b2f7a91bcb7ef39a61568fd1c40ab78f154b3582f830095d571de29f81f9565e46b560d34c32bff55341a991f8e863bd9242c7cdd366be12538bb6922f1abfa19e7998aac61d465fc46538ee9142acc66786f4516ef4105fe1d80372"),
	})
}

func (s *drbgSuite) testHashGenerate35_SHA256(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHashGenerate35_SHA256_0(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "68c43a008fe46a823d260a9d7fa388fb9e401f0197e7e758a744b4babb3f4651"),
		nonce:           decodeHexString(c, "eb6825777856331884aaf3751b3e4006"),
		personalization: decodeHexString(c, "23ce0d32cbf2d26467f0d62acff1a3acbaa6d2746dc3ee7aa9d32c880788afc8"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a31b9f13b58d4fa2f8d8ac42b62a207ff647339a146bd8b268b33d4aff57adbd"),
			decodeHexString(c, "d34fc6504eca4b568193c75357b0d3821a48c77ff80d6dbd21c6cf045ff489cf"),
		},
		expected: decodeHexString(c, "abb4ecbacd4e8fa943c7221aed433861c3b203232657ec4c417d021f905d911db1058ff1e11e272232482ec96bae7cb4efc135502dbe41724077077f6de79b713670c385d04644e1281c3e582e0016255abbe5f8c06d0de57160559f0c08f7fb5be3563c649966190f8d3261364447537de2c7371c6e8c308933d27145bf90ab"),
	})
}

func (s *drbgSuite) TestHashGenerate35_SHA256_1(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "69ed82a9c57bbfe51d2fcb7ad3507d96b4b92b50775127743374baf130df8edf"),
		nonce:           decodeHexString(c, "871d87bc96b2c3a7ed605e614e51291a"),
		personalization: decodeHexString(c, "74a6e008f927ee1d6e3c282087ddd7543147784be56da373a965b110c1dc777c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "74d36ddae8d6865f6301fdf27d06296d94d166f0d272674e77c53d9e03e3a578"),
			decodeHexString(c, "f6b63df07c2604c58bcd3e6a9f9c3a2edb4787e58e005e2b747fa6f680cd9b21"),
		},
		expected: decodeHexString(c, "a571243111fe13e1a82412fb37a127a5ab77a19fae8faf1393f7538591b61babd46beab6efda4c906eef5fdee1c71036d567bd14b689210cc9926564d0f323e07fd1e875c28506eacac0cb792d2982fcaa9ac6957edc8865baec0e1687eca39ed88c80ab3a64e0cb0e4598dd7c6c6c261113c8cea947a60657a266bb2d7ff3c1"),
	})
}

func (s *drbgSuite) TestHashGenerate35_SHA256_2(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f2e0bf10cb9e688ecc98aedac6a894b0e68808c1ab424f772b3c74e92401a36e"),
		nonce:           decodeHexString(c, "c8f6ca4258729201fc9a7bcd8ccc6691"),
		personalization: decodeHexString(c, "43db83d12fb72b50d0f46aa8233aa7c15df0510dfafb7bbe9f05a6a6c8cf4d4a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "be5e3c8da18585d0924a74f548164147d6d1b08e97e395fb1857add58e23a417"),
			decodeHexString(c, "8ee379a80c68e6d3b6b45958a6f95bd9956c7c07dc7a4c89a2379202999860c2"),
		},
		expected: decodeHexString(c, "34dc1c639cb823a36011654fc313b0d2c241fb11901f36eb388794b8aec61b64bd53362ab85a041b6480118459a4474851929d42fa1f62c4ed8ca8c43faade7d0f4c4738fffcb265d8e362d8598366261894db33dbda5636192b374291f0026f93c2f8f025e9df69d68c54a31861b88351aa1e5420f1d5a799dfcbbb291174a6"),
	})
}

func (s *drbgSuite) TestHashGenerate35_SHA256_3(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "7d84ff603d8a8bcffe884381b729ee0b434595794922511f77bbf5a843d98549"),
		nonce:           decodeHexString(c, "006e929a53ee5fc650e48568d484fb3a"),
		personalization: decodeHexString(c, "9fbfe65a75785f7d1284f84c565354b764a6148b156fa8a327be5398d9d0c974"),
		additionalInput: [2][]byte{
			decodeHexString(c, "612152ed93c4429d722a44d35a09ea8fc722c39b1e8af9081f37243f44303067"),
			decodeHexString(c, "829fbd42761ddba851ba02f6abb7bf8878422993685dae5bfd00f2c2929fe227"),
		},
		expected: decodeHexString(c, "abd6c6c163946d7239d58af9629a830ac6ebd952d506c45fd75cff8515cda1781b58ef48d54e77c33c2d979f00553a3d0c2cb1801b4b1f6e777ba568fc4fab40a19c56b1dc77f34a032c8ccac896d99297a8bd1a93736428cac23292f2f759a9897aab5eaa233d961235f34b30e632303d502a63455de5448172c3d1cf252103"),
	})
}

func (s *drbgSuite) TestHashGenerate35_SHA256_4(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "dea24d19bd79e90cdc97d34952e6956ae37d5f7b3ec14821101e82e5ebdd4e07"),
		nonce:           decodeHexString(c, "95df8697d4f8755bf60c7af5d5ae4a86"),
		personalization: decodeHexString(c, "6dab966662ed761b37f15efe3387c62ace3446295322de138757c706ac058d95"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6a4a6d21a4800d5464a04fa10da71aa0c02c52a88ac531ebbad9a4d4b5a63185"),
			decodeHexString(c, "b6b2fb182c43a903713b907cffca85af04abcfa35fb0fa4ab66852a02ea3c311"),
		},
		expected: decodeHexString(c, "14b83b155ed9cfcfdcf18eb96761a205cc63308e2f0c068e63b066a8085bd6936cbb8d5ba14d8973061372a5909f46ecddcf91b913b07b232e29914fed4d77f706d805fc36fbc665135ab3586024ed9390290d8999898b98b2cc0aa488561b587948c0fba9683d910e27720acf5a2f45d47894dd7fb2e93e9b0db54da736f2a0"),
	})
}

func (s *drbgSuite) TestHashGenerate35_SHA256_5(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4444ff211d265c17282c9fc6f2764280b9b5b4ea1858130389c403336aadfe14"),
		nonce:           decodeHexString(c, "193a1cce77e54299a3e878033d088f0b"),
		personalization: decodeHexString(c, "3dab537625e6407e9951efc7b973b1ff59ec4aaeb0c6e2b824a29f7ae8f8bc75"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a0695732cd80a797f47e976c7cd4ce16d8b5251caa760c05b8d8af708af1a694"),
			decodeHexString(c, "19f17b170270f3a4cabad1618f0450cacb42917cf4d1419217a6574ff186a8d2"),
		},
		expected: decodeHexString(c, "fbf2936012c8699bdfdb961e97b745303324bd5bf97f6c682aa2f4fea30771dc1bda81c3a2612ec58bc56198ad7f6a7304a41b94061c62fb3299321524ecf552fbf23efdeb6ec99301cf52b830f515e8f9227f91da667ce3238a694c8fe4def4bda51e996d57734f24a7c699c59ccae867482e49aeeca6255d72e7f09a12f8be"),
	})
}

func (s *drbgSuite) TestHashGenerate35_SHA256_6(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "aeba3ed174c711b74e0213f49c02c0d1510372ca489d8628e1a55c646b2ee14f"),
		nonce:           decodeHexString(c, "6c884ad3662aba1fd335e94d1ec7b979"),
		personalization: decodeHexString(c, "f781d9d51f77dda624a76ea73c0f9e23b8be8db4455672e3c1baa07823c04ba1"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5d97ace9bea303472991913238745401790df08a586865e83fccdf052ac5fae0"),
			decodeHexString(c, "2ed263134f95d83c4e18088b4b1ec2cb785f563b075b6992fa7e143769a821ad"),
		},
		expected: decodeHexString(c, "3d8476a01b2ecfd01dea948d6237e1fcd7c918369b541e96fbb23b0254cceaebd90a459ae5bbb74823aa2ee5a5e1748aae604d29cfb65631f5fd405dfd66bbf76a5759afc2b13c1ca878772c1681a561e5f5a5f70a87070b4411712b4983ca8d5a68a37400d33e98e7f65af28a92385239f04e8ce43c3ce65ad234d43e331254"),
	})
}

func (s *drbgSuite) TestHashGenerate35_SHA256_7(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a83a6346373b2f957b40a7b39f061b02fb07fac1d8096fa2cff752dd7380656a"),
		nonce:           decodeHexString(c, "4ced16a1ffd25b6d940b2b66dba5d1ff"),
		personalization: decodeHexString(c, "94e53cd05418f8f9e0bd36462bd935e6a4330c6bdcaf4a63630186c8fe7a63ca"),
		additionalInput: [2][]byte{
			decodeHexString(c, "61fe3257d38cb5fc1cc6f8d0c19bee3fe04a141ccabdfb64f005ed396a41d682"),
			decodeHexString(c, "e5f28fc44f462d4e704d6c07f9c7724dba3ed3205affac7a98365af4241bbe57"),
		},
		expected: decodeHexString(c, "a5bcd00ea1370743c858cc94c9f00f65229852e48df544295b2eb1e41a721f932038755e4761defe890702569c2af3ed889024cb6bae8fc056e866b73462a09797b58bc2d94bee0f0a23114946057c831f6f3b860c6b150df8f730449fbfa5b5a783796dd907926227759a4161f96ec06bd3dcd29d19c184309c6a4ac29aad4f"),
	})
}

func (s *drbgSuite) TestHashGenerate35_SHA256_8(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c213db4e1bcf76ca0065fa2ddb46ba1b6e57965f06be127b38d1c4b4a8d7f56a"),
		nonce:           decodeHexString(c, "b0f4151fc917433839cd65b761a98c87"),
		personalization: decodeHexString(c, "dbcc5c472c52a98aff1eae55916c2d6116eb3387fcdecf2cb14840601ca09f8c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f8c66edf70a4e0255d6ffe97eaf58e58b8c49ca36541c6d6fbb6f5eb49ae0b2f"),
			decodeHexString(c, "d1f6dd9b2d8f831e8a16dddf1cbd16bf82aab1183d690ce74c5a2a167ee90c0c"),
		},
		expected: decodeHexString(c, "0a1da67b92e1df34109c9177261434fb628d34c82019f62570818c842a1b120a738f645f06889073116fda460760174be18b66566db049a06489a52d1d51881808bd338af6610dc685ca1ffe6e867bfa921de3523d7671821b59c0ae62dea7d79f31dde0ffe7f33707b1fb11e336f25cf437597744a9ebfb6df5dd795f7397b7"),
	})
}

func (s *drbgSuite) TestHashGenerate35_SHA256_9(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "21a044e313428b929b65a998f54620e6ca26015a6110c81f530b00af0fc95287"),
		nonce:           decodeHexString(c, "aabadc55cda3dcbc11bf2abd873f07c9"),
		personalization: decodeHexString(c, "b797d26284ed7c8ae00deb200933e45c398de596fdc74750cc4acfdb3f12bb0c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2cc66c78657bfee4972d3a305cb18e0b9bb88f9efbeb0dc9d3cf278af0a90403"),
			decodeHexString(c, "f09df1f2ab01d8ec547fc493bc5b6cd20ad4335881ff5f7fb4a5b2ab5697a946"),
		},
		expected: decodeHexString(c, "453873968e964ac0822b3f64c5badab507d037b9a66fbd0bcf830518711d93a425aa618b25971888e693180edc41306ad88f9adb0a0cde019d5c2c04ffbfb33bc7b03bddc4ff6829232fc27308c3f543fa8ece805d30b0d7e629e7e19ba7d4aa4e6c2b8fb7190918239afc6d5de1b088aa4a9a4f74c3092bcff4174f5ed46b81"),
	})
}

func (s *drbgSuite) TestHashGenerate35_SHA256_10(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "40555cabd1d8990d9e4f082bfd6b511a9b0eff43405e82e794e512f21e37ebcd"),
		nonce:           decodeHexString(c, "822d4f55c5a11496e882a104f0a405ab"),
		personalization: decodeHexString(c, "c296d39ef5e09d2572522dfcb0f877bee7eb3d5144a761c597e9dd9036e5c27e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c621a48d502af2d475757dfca86fbdf0cdd5285beb99bfa3c7ae5682ad595413"),
			decodeHexString(c, "9eacd5708ccaa65b3e8f3cfdeb2ce7cdb5523545fffb2a373a760212c7d48b01"),
		},
		expected: decodeHexString(c, "4530deb1de06b127aef059bec9445cd4399e8ff1919ec4b6e42b807d68441e7c7d5518e53ec0afe4cab6df6103b99a3a6bb2b23b40bf0d826cb99e4cdbadd3b8f94266753103572b192adc4e8fc64b41ed5e8c81a9c9d02b38e9bb42676c74e4c1b7dd403b67395187b5c0041355f168e8ad2c604fa5d195c5716be43bf69668"),
	})
}

func (s *drbgSuite) TestHashGenerate35_SHA256_11(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "57f18d806b5fd33b3ed7184d3760f5e5a1157495fae2cd94832e1c17c1a1b249"),
		nonce:           decodeHexString(c, "c45022394c32b2eb630a3ed07439e6d0"),
		personalization: decodeHexString(c, "523fb8c335fee7b217dd729ee37c3cf6db2e25354763ec6d49027c1f4a3f5de1"),
		additionalInput: [2][]byte{
			decodeHexString(c, "67450c806290fcfc0a54541c2467d3856fe819a86ad12c0750878228b3bbc8d0"),
			decodeHexString(c, "1d28c847c3e68667394b9104ebe83eb840c07edeec94dbc485676bfd534af985"),
		},
		expected: decodeHexString(c, "9f3fff4be1b601b4636a3d15bdba81088781fe389c49bfb33ddfada0acc11490d707513107353496f63250e5d288b7961ad1320fa8ceb0493c2839f987a7b1118e65a77e8a3813d2be19395951a24c7b6f74e8a82436814db0dfa02b22dfc7e7d4b4568f3faeba4dffef5055a6010c50a878fad0485956f350762f2897725eef"),
	})
}

func (s *drbgSuite) TestHashGenerate35_SHA256_12(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "99325d0905ace7ad3ae6c8edb8a634f82ea240c5603207943d7b2b2a0c5e4b78"),
		nonce:           decodeHexString(c, "d3093e34b298c00a24698b808cd0bd4c"),
		personalization: decodeHexString(c, "d5292bda059675853fe99c506611f5cc6a050b2568f1d96b0878859a86b7e94a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6d270cffe63788a0d48007ff04420d09c630f5af89d4b9a50598b0909de06559"),
			decodeHexString(c, "5994aa92dda4498cfc2382987bb4989b4e80b96882fd9c8a56f62a7ebe91968f"),
		},
		expected: decodeHexString(c, "ddb71dfb398a9a35310a993420d82e1dbcf8ff4a5dbadcd9f70aefaa0ae576ee5a383d7c8a118c1d89268a730684a87531da5d732730b3700764589450fb4b1ddaaa31537e47748e28c69bf53beb6b2e66cfc8af1636c439971299c6a771f4b126aa1508adf8e2f6e0abb24a01adf9b1ddce28e838f8e93c977003ccccea67d5"),
	})
}

func (s *drbgSuite) TestHashGenerate35_SHA256_13(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "21f48333f24396f8e84a408fd3a0c396d1ddb6e99e29ddc000b3b8b9879bda19"),
		nonce:           decodeHexString(c, "a86258317db03497bd588f6726611667"),
		personalization: decodeHexString(c, "634b5d47bd8ffd18a07ada3d63d9ed2713bf8d330e2c17879ba51c4862c46ad4"),
		additionalInput: [2][]byte{
			decodeHexString(c, "efdd4c50cc73ff5553c9c385325c79e27ecbffc7f96ac69d5a75d772a0be0fe2"),
			decodeHexString(c, "ebe0256bc9c42914df8c2be8bcd43b7b7c10ac28f27fd89880600f7fadae88d5"),
		},
		expected: decodeHexString(c, "bdf7581e00f22d104602b2b61240de26b97af058cd143b6919c334f2d095e2a2aa6a75670a849a156f41f7791b70d762b57f921db42ac0527165f4569b7d17a9647c1123cd8edccfaede16a40f311fb421387ebfe9a5725ea82b2f1dcc88ef886b5db0c54ba6b2213671c69070a4dd6f9b27e4cc115cb7dee935f1f481b02f70"),
	})
}

func (s *drbgSuite) TestHashGenerate35_SHA256_14(c *C) {
	s.testHashGenerate35_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "2576827a528dfd324252be2a1da179bd64f1779fe56713a45b576053351b96c0"),
		nonce:           decodeHexString(c, "31a04c75f5ea01779d6b96e461fef171"),
		personalization: decodeHexString(c, "98e288b1da6983d32a11d24fd4ac447cca253d069e2388d6894054274badb783"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5d9446eff72d59529a90b498d8f40983b3b2904f63664fc0aa1de8700dcbf81f"),
			decodeHexString(c, "e19707aafa391e8622539d52a05d930292bd0f7c17825dbed5fb7a2f8734081b"),
		},
		expected: decodeHexString(c, "6ce2ae37349cbef9ebd1f9b85485810a22d430d94abf66912dd7b6cc751400e777be2f1cebc19d65694a456b2c6429cefd95eb934030846708d50be3b274c2f7de299f3c311038491f271448c7d02ff51de048fa1184e8ee06b7b46a9f123daecbebae4a2183dc8eb6976abf0dae7cdbea6017cd1500f37dfadcce0c1956ea87"),
	})
}

func (s *drbgSuite) testHashGenerate37_SHA256(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHashGenerate37_SHA256_0(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "63aeb1416480639ecd17cb6ceec14cc78b3660b48e028bef7d1bf2941ba088d1"),
		nonce:           decodeHexString(c, "068cb2383db7997a69f5e0b30a09e402"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "35ad8aaa5845bfa226659044ca9abf6cbe02abf03df7b897f4ecfe70821e66e6"),
			decodeHexString(c, "4d4065a69b30be27febcc97fd5299bbbab34fbe48e1cf392561c0a3ef9852f1f"),
		},
		expected: decodeHexString(c, "bd325ad3673c1d9530692c4454e0f66ff6a767f7b198e17c6f00e92a073e023745fe9cad7d7eb3bda115ff7c11517475e933f8dba00282c3b0d62a3831033bfc123f8370d21b08ea21e33566ab3e6f3f0111fdb9b4db8f7a0617fa7c803e776d97830c911f3483c2c55700d1f71c21e03f563394208b2a03508c5e9103c93c4e"),
	})
}

func (s *drbgSuite) TestHashGenerate37_SHA256_1(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "734ceb9a6f45a559c05cc1ab095c4f561fb2ad0ce25999016c5e8874dbad72ab"),
		nonce:           decodeHexString(c, "647b6d99ede2c06b3a1a1c8ea280856b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e45a22c77574ec407f3dcc31b60124b87cc3b78407a0c0dd25f25c5387e9deb1"),
			decodeHexString(c, "6603bbe82700d219137f64a6ccf165f169dfd6508a33cd23a08201cfcf20ade8"),
		},
		expected: decodeHexString(c, "634ffb5ad2fabd33da3910b8b7a748cfbd91c29704fae6bd85bc4d73f01165c1af97393257efe33d326673a26a7a448e725b4ec17ea63b260df6968e6431c98e3a72df8b1e64eed0ae04adcd8c4d817d2ad363ad47407891e962ed2fc0a4f3aab7c222197859a791c3d3453e5884563cf74b771e8cab0560c88de34179989e5c"),
	})
}

func (s *drbgSuite) TestHashGenerate37_SHA256_2(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e2e0e3cb832263fa1bb2e95dc7bcd371dc6f2aab8abc493c95f402ce2cee6656"),
		nonce:           decodeHexString(c, "60e767ea37623a30133c0ce7549e6d12"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f641397d38cde556f4dc902707ab44c65b4c0590c1367adee548ab2d87c45865"),
			decodeHexString(c, "6d2e2b9496d966f7fcba0cec8475c1dd58379cadb326e84c2925cb536ca543e2"),
		},
		expected: decodeHexString(c, "d58ed53651d081c8c56ddfd6265956e954af3a43c7d0c17926335dff7a0ceec231a5a9251ec7ace919f9d5584439b007424d2adf67664582722dcdec60ab67601f780a1cc4952ecf00477cd93eaddf94bddd0feb3f60786d2e4eeaeec91975897b0517d78a1497ad614abc0bf88b3e856b4e07fba8de5871f79f8a212c3c911c"),
	})
}

func (s *drbgSuite) TestHashGenerate37_SHA256_3(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3e4312079b57f5161781ed08a5d7e5a373b89c848807fcddd95391ed67c332bb"),
		nonce:           decodeHexString(c, "823bd17bc73e233cbd61bd06f27c850e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "bd001f6a383003d56ae28def7dc9b6d9f0a0636f3f0044ff6cd31e4568cb8d40"),
			decodeHexString(c, "92f25bdfbb8dbee577000edf6af0e107182c815aeb95ba1d76e87ee57130a908"),
		},
		expected: decodeHexString(c, "e4f46e23f87c1160e066bf68968856b7da50029445ec56b6057d2fb99ea58d8a13129c54f45c60b3e4390e52cdc301b4fde169971034f56b4ceae8d4b4f32f5a45e75b7650cf2f53118ab0494720320fa0a39af585523feb45019890fa30507806b868f04f3be1722c44b0d8a5b1de558bec795de71a8534a84f0592ef68d7b0"),
	})
}

func (s *drbgSuite) TestHashGenerate37_SHA256_4(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5b59736e2ff2fecac4e3fe6ca38c1d156cdb1e436b684eff3b18ee3adf6b1863"),
		nonce:           decodeHexString(c, "0ea312ff6e274cfa87eb65550342ccca"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "61dad6d9c004dcabe17f434ea6dcb2ee9042b3f7a2418016a6eeffb2742a170b"),
			decodeHexString(c, "633ed383277b3fd3a87a33229b7b8b6d9f309e2812e92cd21ef406e000bb7597"),
		},
		expected: decodeHexString(c, "8554e104170c5a24b0c6befbda4abd4832f449433dbc597fbea375d887aa968cd44611103842c84f427878bda0aa13b0802a6b062d3900c7a1e56c113fd0d7627036708436191bcbcae76bea72fba68d912a5e365fe00a7d0a49f3fa282f12da7534233a25eb148ef270cb8a6256090a633d90e90739ba81f21dbe513e0eab45"),
	})
}

func (s *drbgSuite) TestHashGenerate37_SHA256_5(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "bef87a4bca98a155ccb67988ebc885aa56489fd074d13f517a17cecd8cb04cb7"),
		nonce:           decodeHexString(c, "3f81624d79b7f0cc4b69c5fd3663474d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "06f0ef0c8635be4d159a17415699d36ff082a9c469ed566241bb2aa5de01ac8d"),
			decodeHexString(c, "4650561c2130ade440e3ac3301b295ee58e89501e19989a6dd76ce4951d1b1f7"),
		},
		expected: decodeHexString(c, "4b13b45a6b3bbb76724f8b04495e96a07fd31b9815f85d25666d9f8200fecc29a5e63c58af7e157a1eaf31537eb043de493487299711ffe5ceb26b2e3d76dded3f71240b36068ff7513ab39989f7bdf04b0aa589a91bb62b0acf240e92c2a680b25b207bed4ac1f348a893e262bcf469b01c72436e72394a1ba809638573d5a8"),
	})
}

func (s *drbgSuite) TestHashGenerate37_SHA256_6(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "159e8f04a0b5bfc54b95dc2dc95d06fb329db7ff1a7263e549796ccd5534b2c2"),
		nonce:           decodeHexString(c, "515911b912cbbbf8f152e9625b49061c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cb4045faaa85bd0981c5c1a4f51163d5523efe3e1e6e821e82a71eef515f80e1"),
			decodeHexString(c, "3ce43a880c49bae46419212dea9e0c807b9b8ca216643d8899aee8a850541c7c"),
		},
		expected: decodeHexString(c, "37a3cd5b60ea5bcdb39ef1f3b4b595ec0c609aad55e27053dee44aea6ae42f1ee5de247eb0324307848d988f6d042b9e7dce2db732be28b172202e82303543f52698cd164b2314a0dfdf032695b8dd98c83532ee104749308506ee8938a0fb316cbaf2c337fa581c951558143caa9ebf094d973c7ea774e11e8bda9a36e749e5"),
	})
}

func (s *drbgSuite) TestHashGenerate37_SHA256_7(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5457daab7b5a0254a1700359e45b093972242c967c76696b2019df59b5b209b4"),
		nonce:           decodeHexString(c, "3e579bec2c1b263d010e51b7a92c3079"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e0cbdbb2fa88963ce02fc8d585a08926c7bebc803f1ceec4fc1604ce01bbf530"),
			decodeHexString(c, "1920881620aa877047bba5850dce86a17c4b0ab2dee5904922b4ac5ba4973e87"),
		},
		expected: decodeHexString(c, "ba062bebc757ddb62c5f21d262c44417ec834dba37e81f33ec755de184f73d7f922c6ab378cff9ea412c5c0bd003ccc280299860bff326d2d47996914d1751b4379a43b6891ca578034d5ce5c726f2a6bb6401de67b26f465ef8a9de0c15d5d861742e48bbcd22df2bce14c6b831040633dc8437b9b6a317431ff412eb689483"),
	})
}

func (s *drbgSuite) TestHashGenerate37_SHA256_8(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "2f53d66ab1acf5f53d845c0adce99707e2f9819847ce07bc303dfa5eddc83de0"),
		nonce:           decodeHexString(c, "4a512b024a947cd5b5ec13da59f08881"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "47030202d5078bc2e99a8c48ca835bb41393db3cca68310f58d63c8e26beb5e3"),
			decodeHexString(c, "2774c7b6e2ae784fbe756e067d59d5a493d9983a10704b6a6ab938b6d4a2e390"),
		},
		expected: decodeHexString(c, "e2d647dcf1af9bcb59a3dc9a9b94c7b0f1d7635db0af00263b2b545359ec445d1c6a1d5e968b7be9cbdfada681bfc442f65392805949b49d8b9d1d90f710abd15891e2f9863569f7654d9205466accad45dbb2a08fbd9e449bb1ce3ecf3fb214106e651582a5d7ff80fa9fe4635b79ce6b33688fe26f161d2441ae0a41996fd3"),
	})
}

func (s *drbgSuite) TestHashGenerate37_SHA256_9(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "ffff1bcf83a3e162ad10ac026caeedbf5438db6932bc0d0aea62c919cb98d289"),
		nonce:           decodeHexString(c, "2d54df18a916e1b118a8f0da749b4c42"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d26a700d5ccc8618504f59c0bd100515f6036fb34926a5d0f0c226f2cf9795ba"),
			decodeHexString(c, "787e1f5b8ddd6bed24dbb7508ec3a92110eaad45d883e546ee46c62bc0cf9888"),
		},
		expected: decodeHexString(c, "9d941f943a3aa0ccc342b134e6f5914c76b2b21a589280639cae9bd52c7919120d9c74b5df9b99bebbe63ff8b0d6b20664c3eb00523dacb90968bbf0bc5b6a9ed53e024a97c63499a7a73c1b509975beda5a3528663071d6c97a45ef796f187aa8d83c41ce7e5d687a25ced9818d31b2103a72bf6404eea253b2342ccd193218"),
	})
}

func (s *drbgSuite) TestHashGenerate37_SHA256_10(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "524650bcf012792ca955ec312001ff8d453af7e556984bcc44707d5577641b0d"),
		nonce:           decodeHexString(c, "30f93f55a89806747171bfb2d4da347b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ae68e720e75337ef6b2eb086f3dde3dabb854992091d44d2e5f414cba6d8b0b3"),
			decodeHexString(c, "0e0f9371007aee353a9f2324b43578fdc4324ad0241b63400e03460d66eb0cdc"),
		},
		expected: decodeHexString(c, "862a9f86597a1a930f317de9415088087763de830009b4b30695aa58b04b46db17c1cc816ef5c70437e0d925a52139ea483cd7d0b2119454be5abeac9565150858ac5504a9d3b49ad7085f720944a704f000e26bffbd7ac09b15e9aa2eecf56003d452bf832c032e77584d99043322016e2f4fd9e3db61a74318821ead14a132"),
	})
}

func (s *drbgSuite) TestHashGenerate37_SHA256_11(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4d0f84bfc6f3c7a8ac3dbe37f599309f6df1380cfd70b6accfd28290142a8a6c"),
		nonce:           decodeHexString(c, "c335a2858b0db8d12c2545234180c0da"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "324a329c2df9cc02117f05cfd8e8943300fdbbccff400a2b8acbc3565232ae12"),
			decodeHexString(c, "937e2c9c139d9a79a3e1b573ecdcb51ccba3ecf1ca56047067646a19345ed883"),
		},
		expected: decodeHexString(c, "79e2595ed3b0e146e7dc750e4b8c4747560b715708a7d4d254f92cff581e70a5a9caa897b9317357e27ed7d4901a3974951d88024560e1c2f2bcb8a3b407ebdae8d149afd4958b941eaf1a0456856c2fd7cdd89d4e556633dab095e089441dc46cf0df676908b04fbc450957fb91e2b005fd3529a2b82cacbbf129e7ca573564"),
	})
}

func (s *drbgSuite) TestHashGenerate37_SHA256_12(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a2aea6ee39285bd1aa410c1a4d019cbb91e408c5c597c0de88f780b543660069"),
		nonce:           decodeHexString(c, "8f77489159b279b406c5a3ce7b0cccfd"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e1342c6aa402b4f1d3ae7e51a86ed3ca72738e1ff6874ca58548162023096303"),
			decodeHexString(c, "d77efe99511bb301506a34e69bf726eba4f1aaddbf87d1af2fc55ebac73f45f9"),
		},
		expected: decodeHexString(c, "238dee65f3e1a111a5b9030d1fbf2b900b632d2e3e28684a1352978b2939bf863d2e5091dbced8297234bb8f49e59e34b3bf38b4f3f2b2f61bb5989bc1e0f425857d684a843286fc8c302976f2f237c01c3794a10ef786fb7649f0a0aab523cfdb8de755ab4f4a397ce541cd718dd3fe10db428b00d3acdcb80b0c1cb17c7c88"),
	})
}

func (s *drbgSuite) TestHashGenerate37_SHA256_13(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a18c44693042f527c948315e2be58edf552727cf44aefe76debef2c83d19950e"),
		nonce:           decodeHexString(c, "4c6c6903a482457a7bb5be08a4727de9"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1886624786e1a2cde983ec9286f0f3999b55d778257436393d19cc25abbd14ed"),
			decodeHexString(c, "ff4c7080453d152a36b1284a8eb1854dff5f29f277f36a9ea8169b0282091a65"),
		},
		expected: decodeHexString(c, "c00f3b2d3e62b2f7fb082ea4e074980931a4abd84970842474da319b496aa2f6568b4bf1616ceab1de1469434b528f2d621a29052dcb92e9537ea266a9a41c52141ca6a16734f592cf99dd4ff652a8f0800927b9632d01bda8e02544ed978ff6dac3034116d787e54bd58a9a653459b14d9c27966886097fe925141f3b188f4f"),
	})
}

func (s *drbgSuite) TestHashGenerate37_SHA256_14(c *C) {
	s.testHashGenerate37_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "23e264d1c47ef7670a3f95f4b17d8ffa06fdfaafdbc5190e75c55debd6cf805a"),
		nonce:           decodeHexString(c, "71fcf2bad21c4f472d1d50521372de2a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "de1bbca12357943b4489cc7209b3f063b51b91acc168ec5e0ad88048b65d1b06"),
			decodeHexString(c, "6ddd9aba4f100ef902ba50adee53ef44a4f45564c13e774e69557e36a357e7cf"),
		},
		expected: decodeHexString(c, "544ec80a966644454886fb97a0f05eb6a4a25fcbce795b5e5b27ee06ba14b7de18dbf54f80a670b87c76c336ac9af16c8958ad6c1bde9a97aa4c1ab5823d24a53c64f6766ce6eb9b7085cf7282499c37fc1e2e825f53bc357bf36d5901e0ae93cd3bd821fa18b5aa17548560f7ad6ef38124814fccf9b2b89de61cfc27c7269b"),
	})
}

func (s *drbgSuite) testHashGenerate39_SHA256(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHashGenerate39_SHA256_0(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "bf4dab346966f86b5163b0f2afc02998549f4f4210b5191a2d27400da12686d5"),
		nonce:           decodeHexString(c, "328531648f5ce509bc011f65f76270ca"),
		personalization: decodeHexString(c, "d6b55b157655a82d9afcef78ca2201388ea1793012007feb778959b8731325a3"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a12e7e89437b5a7db04934a84a2d8d678c836d5a2b8a990a69831829a71a677d"),
			decodeHexString(c, "be03bad20228f7cd4003e902cd9ebbad3161fd264372aa69b16b662ff9d66f51"),
		},
		expected: decodeHexString(c, "44c05784091d0407dbec91a9d0439fdae627eda462a775e4074a80bcf33fa7cca1d2942d1dab232aaf5b83070c83009f4e6291876cdb7a28777f8cbfd305367c5e93455e8b9ed520f48d35dcb28c5f15df8dcd168dbcb963f9e9f8451117206a2b775cf1f00e4480b85e60f9158ce6bf6fdfb0a21879e8b83d4b371fef1bda67"),
	})
}

func (s *drbgSuite) TestHashGenerate39_SHA256_1(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4681c3fc821372f81b7e450fdd4df1454d1cd607430406dc62f310dcb808d2c9"),
		nonce:           decodeHexString(c, "95551c07a7bb908caae996f5315afd98"),
		personalization: decodeHexString(c, "bb9f353d9c286f07fbd21c9e5880b5d2fd6d704dd78ac98fd7eae231cfbbb49e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8a41773b12d07115e1ed177ab6048c6505ced1d763bafc3665201af79a5dcacc"),
			decodeHexString(c, "f7158a12bff554b1a517d92cfa5f6f6ce7a5e60a14a059ec1f91c6dc5a17d6fc"),
		},
		expected: decodeHexString(c, "077f92e9c43e1db80af239ac32ace4ea1151a29d50fd24512ca82fef323abcfcdde436bfcd4f9c16b6d290982d92481ab2666abc96a380a8bd29eaa5fbd88cc230772a75220bf8962c9b49e129b677018f859ca5af234d47e6c5ac69f410438d6e6c87d8587f3421f6458ec3b4ed693744ae63a189d0f6e309025580e7910793"),
	})
}

func (s *drbgSuite) TestHashGenerate39_SHA256_2(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "aef83ba870cc3cd21caba2f67b37e7baff19588a012844d84eaa0ccc4bf1484a"),
		nonce:           decodeHexString(c, "1f669e6a3e1820065aa55a7ec6132f88"),
		personalization: decodeHexString(c, "31eb4cef3c6087600b0e248769440b003bc3250611a90b228797eaf4420464bc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2129382690e63c03cdf6a08d51271d823e1964c3720bda5716847a0a0f750169"),
			decodeHexString(c, "127053dc46722a42d7d333691ae9aa6edaf3acd0e1546d414f4b11e3dd70080c"),
		},
		expected: decodeHexString(c, "5400017c4f7ee8067b328d575c84807c9c597cb1c9211c1655c9b4d2c0f0bd7b688ee8b3f6b26db138f7175f382f28821cba9fc383d7949585bf3ac00412c53a03cbe2fd4868353b83d409dd2149e372b2102c3ce4f6f083946af834eb09d9ead0af65e2f32569bde1d476765a3325ceb1c26128f08e931f73cd6efc49396a33"),
	})
}

func (s *drbgSuite) TestHashGenerate39_SHA256_3(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "1457b500bf68716f376c804bf42b2db445763efb6d58fca870e299683dfca095"),
		nonce:           decodeHexString(c, "987e1d205b40b5f3bb43cfbcea1ee19f"),
		personalization: decodeHexString(c, "7552ae50ade95bfc7226cb9f890ffacfbe8edd5db2d717c26b14e92414a2789f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "80d6c93068ca7d1623aa88e0ecccb140c578b4578b72805dfdf4dd6ea4f96ee2"),
			decodeHexString(c, "ffca4be8e551d5635d52b7cb1161c214275daa27c49135f9f6c5015049e88f97"),
		},
		expected: decodeHexString(c, "33d161d75d7555ce16446264e2f424f15750eae0060e123362bd15a69608ab82e3c9b269737e74c864b40c9afb052ac756f75356bc4a648d4ed1ee4365f82389981fccded063029e1a60a763bc0a0b748d02eff0fe0581c7f795b0df67631ddede8ba240b97ebacb99a6f1baf500552a467c1cc9b01e4e9a71ce4c914a7222bf"),
	})
}

func (s *drbgSuite) TestHashGenerate39_SHA256_4(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "eacd2f167c5402a308c1c282678dd2d46b92497dbacedde6a0f700ae5a5d2be4"),
		nonce:           decodeHexString(c, "480cf5dfd1749fb9611ae1f1c46a2d86"),
		personalization: decodeHexString(c, "87684df9b557496b22130c57fd82bcfca30b0eca281911027971cad60e913590"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6642da6d01d7134dd14ae87ef27e613bcd5b0440cf903a58bcc99411f02692b1"),
			decodeHexString(c, "1ba71824d224fb3a81bdf43f516e6e070473c5a305706fb648f113fc1c5ae0e3"),
		},
		expected: decodeHexString(c, "fb1627b50e153a752fdf09bebff3d180a1705c99d9ea7cf35a6a466d06571919ad2ad598f6a9cdd482bc28f8b5e4cd2f6adf5027f42eb2c4fadbfb9aa9e7c77690ffe04335b53911733b40a86d51f520301ece0e88b38c08e6110214c5130aa23638acb3913afaeece5bdb347e05c83649d8f7597ff3cdd3617738b112e33b59"),
	})
}

func (s *drbgSuite) TestHashGenerate39_SHA256_5(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "5a95b90f0a12a9709862f0b5b62df3321739ed2ced7f7e0ad06f92c0c5b8cf87"),
		nonce:           decodeHexString(c, "955de565bee3b8a798790d6b9b2f99b2"),
		personalization: decodeHexString(c, "4aa1cee36350d5825521a1c01144847e73e16bd1dcf1a424ffaab8e2b3cfb6cc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "168fc301b28761d918f34f0a1fe7340bf39904d153a3dee4ecb232c7959a839f"),
			decodeHexString(c, "d90af4d5aa0ff6f6788cf8eb485ec70d1d396a3d561c5e1783c54d435dacf08d"),
		},
		expected: decodeHexString(c, "ab8f97f616a1be46b75832f9599f6258adc24eda0e6233b99a78140ab06ae68e385762fc564880eca8e3a6e26a1baa829fc380c21301c10b6d0772ef55ffad6a3e0b8ae514bcee33d39f8405fc2520a14f128bffe4fb4e193b617f0e21c3653ad1634febc27465612d853d43f2652c4966f38dc14ff487359f9c920e213100e4"),
	})
}

func (s *drbgSuite) TestHashGenerate39_SHA256_6(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "1501b2734f2b5a12d037e36c05d70c72b7525cc226b9d0b99a5ed75730b4055c"),
		nonce:           decodeHexString(c, "1e97ad09e8c8ce00643220306e7c2b1a"),
		personalization: decodeHexString(c, "980089fbcf2be84bbedf1f70be0e7e1b759558734864db3b61d36ec8c5bea5d5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1cabfbbcf982e634a61bc97c10c65bd66e7914100aff52993ae6523aeeed92a2"),
			decodeHexString(c, "c7569da40ad37cb121132e86bb019f7d8456610fee981491279ed85652ba91f7"),
		},
		expected: decodeHexString(c, "6a6e1b875d116e3440ef1906659c11ff6d25cf11ae9c6f79148357c8164db9ec5845eb9f53b6d85e6cf5632679431debb1ac433cceccf8491167866c30203eb12d9fd51292ab49872a961e27d253439eee0bd8d50ec915809c8e2a9b3a1b205b8593b5e3d809adcd3c29038a4768bbb6fefaae7a69b594f5acde75bcdfbf1a9c"),
	})
}

func (s *drbgSuite) TestHashGenerate39_SHA256_7(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8cb5f92d948a3b3733759b1c8c671c38a072a826ad3a421d4c01eb9625178de2"),
		nonce:           decodeHexString(c, "ded2146932ce5bbf623dfc526e9d25dd"),
		personalization: decodeHexString(c, "346e870dfca20293e230edf222b79aa09f88485fa7ff2d76b1e65e26faedbd96"),
		additionalInput: [2][]byte{
			decodeHexString(c, "4aff0273664abbc33da9609439c4c4071f1d19cf743f7e7d87bb3065278dd4ae"),
			decodeHexString(c, "c7fe6180c505612ece7738d0145e6c80723cd5005da952b73e6b14c6241b18d1"),
		},
		expected: decodeHexString(c, "3dd20a98949196c7ff3e68d9c7fa5b1b62a2bd65d12583ec7bed6d19d7d2e6fbd024e30651477ee8dcd5817f27a5fad6c6434862a5117ecd43b0934fec64f9060ed8ba6dcb240470038adf085d69151dc8c207666b2ed8ef7c1bd871039ed02e414f0e8a7ba3ae6a2cc1652689f96a62110ae8a0a45a0d213a89307b282f02a4"),
	})
}

func (s *drbgSuite) TestHashGenerate39_SHA256_8(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "9072aeac1f8145cc4935bbab510ebced1380690b125c85142696d923d0576ced"),
		nonce:           decodeHexString(c, "b3d5610767d3847cef3b93cb973944f6"),
		personalization: decodeHexString(c, "f9eb0e7870a8a85a3052ce9d07674a7c77df4203a0fc6dd3ebe5ba397932cc55"),
		additionalInput: [2][]byte{
			decodeHexString(c, "21ee27230c10def9d7124274f4a0d8db2401762e9863d5806107490d1439f82a"),
			decodeHexString(c, "122e466a41db172101ed95267761f8ed4a12774ce7520b9fb2d90bf7558998f9"),
		},
		expected: decodeHexString(c, "9e97fb32a86b6515026c0f7e6b269c1049deeb140d55d184ddea1e34a01fb3432ccc79f0c9acb131e74e8d7c71e4c91b9937669fa0dbc1ee553ad031b2839efe7d112fea1e192ece3f31a4229a247e94b2a5346c0c8ffc4bce6ad8a8729936e72cc42734c56b6cb7356b7beae6d644a7c48f12b1debcb6d686b4049e7e12b07e"),
	})
}

func (s *drbgSuite) TestHashGenerate39_SHA256_9(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "fe9ff50ad33173cce2a5ce25f375497d6a5d7c43b2a9caea455b1ffac9135642"),
		nonce:           decodeHexString(c, "8fd27c24fb0a2ab14c2c0ea18ce5e230"),
		personalization: decodeHexString(c, "ce916e34e5f55436c34b1067f8ecb89131c458bc1d49c65e7c677f64a3e77452"),
		additionalInput: [2][]byte{
			decodeHexString(c, "dd006f41ecd84df573375bd0fc8115337282d4b2999416324e8f3e4ef92a96b3"),
			decodeHexString(c, "56d7491938ff04a76957b2bf373c89803f82b5b6ac96c049c3dcd3d21926f722"),
		},
		expected: decodeHexString(c, "441738781a055916e0df8bab44206da6646d1fa61a3bf5279ab78258ba2faa6aded2aea37b9627ab2ccc3a45ed52fd2653344854356e80ec4a22d7ff650c1a3ca9bab1da1cd198a5fbb5590cd525031989c4eefb19aa93c699b4ed8de7d6c1a57d7039438b970c1da6726044cb18f232375f22f7d4f94291b378b43c8e32d59a"),
	})
}

func (s *drbgSuite) TestHashGenerate39_SHA256_10(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "2a5cdad2a51bc22eb42541524e63d047147c2b9999cd5bc588d976b033a49cf8"),
		nonce:           decodeHexString(c, "b5b89b35470ffa02980da08b1474ef10"),
		personalization: decodeHexString(c, "5b99bb7bce03b2d301f9287268a2a7a8d1925d783dc895e71bfd525650db12de"),
		additionalInput: [2][]byte{
			decodeHexString(c, "95f30b42c8459b3fffaff9654cddec1ca7178047647884d601eabf5e0fa1913f"),
			decodeHexString(c, "2cac6c504b2276ae297bb9b35925e66148f44c11e4af8af881bbd90978eab9b4"),
		},
		expected: decodeHexString(c, "8729e536e7c8171083140681269ce1546056118f4854c65b6ba132d5023e3513cbd28ed661926dd8aea2de60984a8cbc6e7988e1f0147ec636e77785591d45fa925b9fb619786c7d225713f82aa332f858a0fd55803b9c7f11323efaf2a7ab480e628defecace0135b661106df1799516b2349428a8ff3a611f0c4c936d0aece"),
	})
}

func (s *drbgSuite) TestHashGenerate39_SHA256_11(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "604510e4fbafecd10eff25ea275f079a93014c9b177565d011527916b67401cb"),
		nonce:           decodeHexString(c, "d9d1685cd5fed8b234834963d673ccd7"),
		personalization: decodeHexString(c, "5581cc0672f840160517ba3832c280326abb20a02132381ca7ba988a2a75455d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "20bb83e3bf457f06f40ca4e951df626acb3f6a44aa4129616953707bc3a7ce9f"),
			decodeHexString(c, "48b106aaff970622537ae5ddde1437605a11c1a8bc7c01886bef0acdd4fdaafc"),
		},
		expected: decodeHexString(c, "32774e5526e3ebebeccbd372ce2400e591656cccbde5904ca0263e5088ee7044571134cb29b09b6deb222f1ad1980fb60601795507a16f26227aa09f1c56d056825438a05a38c4404e23f42703b007aa2280030bc83fa6fa1cab7ccb1031232e380fa849c56a989563254eed0c3e6f0d4ea28a76f1e91f4b2d34a139f80a6c71"),
	})
}

func (s *drbgSuite) TestHashGenerate39_SHA256_12(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "eeb334175126f50ee83446966e73d349cb5a09da9cfd577fa01f424175fa611a"),
		nonce:           decodeHexString(c, "9563c77fc27d1d71eed0df7b8ea1dae1"),
		personalization: decodeHexString(c, "373887452f3c3a4d081afab548c4b190b75aa883893c91184f9fbf45a1eacac9"),
		additionalInput: [2][]byte{
			decodeHexString(c, "96797f861d3cd72fe2926b16e2b08182b8c957a8e98b2ace8b7a3dc6d80e655e"),
			decodeHexString(c, "02156d4cbcf8ef9805ad73f67bd5e77bdb60e7484fb056b313131fe9ce0c6e86"),
		},
		expected: decodeHexString(c, "a9a089f9acc276c0412f0603e72e82392c06886541969e036fefd7e9ce5017f4887a9a0c54a5fb7216be36567f438a9651696f235722dd6630f6f2a1bad465861bd8474f8a783a85c4ed9b6d8341f99800cc36d6627374f072253b68181cc96b84e8a54095562c41f10285bfe770f68d0294d9dc18ef742286f362ac85936ecc"),
	})
}

func (s *drbgSuite) TestHashGenerate39_SHA256_13(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "97cf46058b89537c97da8f9cf3ce36b666defa680bb36e6636b4500586756fd2"),
		nonce:           decodeHexString(c, "8e3c0413783ad9cc7e8915322af518e7"),
		personalization: decodeHexString(c, "1d846168da367975f77e58daf5a2f0fdd682637fa96702bd6055c4a899b16b42"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7d7407eb173f12df15cea9fbdf3eabd963709fabd8b395c9ba3d4ae2ef62664a"),
			decodeHexString(c, "250f31f1f3370cd9751c8b025053147f307d65cdf6ea0833cbd7b8b5b8252d1e"),
		},
		expected: decodeHexString(c, "d760c25a167e3a7ec8189f06eb51d36c6421ccdef7ea5b4f8cdfc9b6e228e6bfc8244855f83ab232d01cb64e20cf6cc02418827dc4514299e5896e494f45452b102a2ba4db1747d9f53a9f7e11043249deabfa0357d07ac9548d9dc200b38ea3501e9a4e90ce402d2844b8da1c5bf9cc91a8b74f532a3ddbc69c91ef75c3c5d5"),
	})
}

func (s *drbgSuite) TestHashGenerate39_SHA256_14(c *C) {
	s.testHashGenerate39_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b6e25e76bb40fd7edadfb03c7793dc3f63f9b0068beacc1baab2f15865cce448"),
		nonce:           decodeHexString(c, "a27a691d8629bc963e7e06ddd115881d"),
		personalization: decodeHexString(c, "df596e76d8d7c4a74001ccfb2fa9e8e28703c6e2d584062edc485955e1488316"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ead8c0dcf4ddc909aab96eadab509a46908ee5f090983af609f08d8a8b28ffdf"),
			decodeHexString(c, "f357bda8f2048929a4e31969ec978cc333d58b4fc09a8aa1b73ec9bdfaa1a8f6"),
		},
		expected: decodeHexString(c, "901aabb3f065be08e2f8072d5d3ffcb28ab291420644e407e7a6a3346b75a5be535bdbdd5a8245998689450292df877233ef0783e0bd1765413193790995d884ffcb2c8dc35fe4cfc12def2f091866d735b1dcfc9d8d8c26903d50e9397b1bbd674bb81fc908361b2bddb68f02031d87588cc3e94210422674e93fea6a5329af"),
	})
}

func (s *drbgSuite) testHashGenerate41_SHA256(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHashGenerate41_SHA256_0(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8ad4599f8ede0ffb061bec6128c9f1786158f0f1f4473efbd562998fcff49629"),
		nonce:           decodeHexString(c, "caba97e9cba4cfa0078cdfe4dd402ab1"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "4e004fc65b9679ce99bf5b52095b4faad01b5b2b8e4a539cc8b85fd2dde3c053"),
			decodeHexString(c, "5690a64642b64ca0673dd65a4af898536758de741b685a4d8a160721385b72d6"),
		},
		expected: decodeHexString(c, "db766b26234330a21385b454beec705227010909593f117bab2fee95b5aaa10c19fa417e51a0d99a3d1cde3e9cbd235bf75a4f3162b0072f51bfd27999d3a902aec303b5f9f3e24930eb0f15b9d8c9005b601e3e67fd030e0c2b714a1e651201c97b9978823beb7c4769d98ba5b7c0c33384bb2083b49283fcdfb5c9ec8eb7f9"),
	})
}

func (s *drbgSuite) TestHashGenerate41_SHA256_1(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "95f53e2ccbbcaea435c381f31ca04a2dc5d611f6bed5b7f7888da0c9b662932b"),
		nonce:           decodeHexString(c, "fa9b946858d7547eec559927dbaa8df8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "11949a77612333c5e6ddfc368ca9428e76d87575f01238a321bd22aa604f6660"),
			decodeHexString(c, "4d56fbc716951ca2809bd2e6e48a724c3c2533f233a3edc475de7659e310583d"),
		},
		expected: decodeHexString(c, "a36235c717d1cd4d2108109a468584b930ac564d909c4c69c0d494943306234f1322abf78a5e49695d3912331795264aae02874914e747deffbbaac834f60d4cbbb157f0407748a30a6d949de5f848e366b870967505107e4db8ce3d8758ae80c2e83b8ebf5abe155c184b9045aaa17044ebe97567f22bf4aa4c1d33425e6efd"),
	})
}

func (s *drbgSuite) TestHashGenerate41_SHA256_2(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4a0a0b52a6b4923b0705a4f676662bf6898202985b76dea7e7d892909b1f70af"),
		nonce:           decodeHexString(c, "d34add9dacf77c317874e921d0a4a50b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "575b394d41caf41da40eca2d1c534afcd74b2df67b03b66e3f93c31240a728ab"),
			decodeHexString(c, "9fb2b4faa33e748a94b01fc3d5aa931f71f23709001fcecac637b143faba10cd"),
		},
		expected: decodeHexString(c, "85cfa124db69026339ca03af0df44398b5711c3fd7ea7eaffe05f82c1bd049fb7e688d7b98e3aac80c8c562dc25125577768bd8b766555ae8be74b139f105b97f19a8745e429178f767a2efd0fa91b1e91938e8b9828c5b2e66eba09d403e385f2e32c6eb8b667a31a061c9fe2dd811a23290e2555557336f39d95c29146d6f6"),
	})
}

func (s *drbgSuite) TestHashGenerate41_SHA256_3(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f6742c2483ed572d63908ad501372ed18c05ec8b85f4d896f39db46f1c70cfb9"),
		nonce:           decodeHexString(c, "fea41783c5d30b10db03a2a0e71400c8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c946c84dd66d43fcd3f502bf616cea154fce51ac12484d3467bb8d719afd4250"),
			decodeHexString(c, "b043067557e0b7efe6e2c1cc6e9412a19bad509454d19c1888b975824d281dfb"),
		},
		expected: decodeHexString(c, "0352a32a0c62dffeae34e503d0a127e50d71f8275d92ecb000be8ba074d3aaca26fbd9e11b03f317073b0683230e162a2ab4efa521cce0867f7fb61b69dbe31f67a8d42216629b2ff039e5a1a499b47181910c5790f1eb4cad7d07862fb8672a2b81e5d8c62ffa055e97f9411043f7da0c655b2567c56903cfaf1e7d256ede2b"),
	})
}

func (s *drbgSuite) TestHashGenerate41_SHA256_4(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "650a1cc6927648e074fa9f6b0e411ba80d7a8bde7f41cdd40f145818e24d3f76"),
		nonce:           decodeHexString(c, "3098850b25334a27d0de3b106beb6dc1"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "8017e0a4c1d22060e56afde6357ffe9200ad1ec3beb9c2bb381d661c2eff4395"),
			decodeHexString(c, "ecbf1580f1b80856c384a9321a48a78d2ebe4eb413a314e5c4414db132f831a7"),
		},
		expected: decodeHexString(c, "e7ded56decca9a5d59e81b933008bf52a5ed40de1c99c98b846d1a104ec25a69e6248fcfea2295d78419a9293db247dbabc3d688fdddd58d9305fce64209b41fe5bb56e6bbf13447c7e96728a6e71518619e2c93aa9d56797c5436dd1562239da1eef524ddb9c4bae9ad6cc3bd497d71344a39419eacc784b039a4a72cdcac44"),
	})
}

func (s *drbgSuite) TestHashGenerate41_SHA256_5(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e904f170a6bc1fb658f6bd0ae5b3b75aff1c7277fbf576247226250fb23424e3"),
		nonce:           decodeHexString(c, "323fccd0c9edaf325e38aa789f3c0172"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a5c257bba6418564858990b1cdcda34f79b48d2ac3ebe25e23219542566981b1"),
			decodeHexString(c, "4c91b2f0e17726b653e4b142b4a319ec952fe4d2b71de31ff14460c3f4f55991"),
		},
		expected: decodeHexString(c, "4334ec672d6a9c69a5203126a9db2ce35e19ec0a4ac3c0713062792a8c0a16934b8ed85df80890550265614625a5145eacc20df8137046b53ff4fbbf9d50607c731e3b82a41a1b74c8ab25f54a1955105aaedacc5d7759a8b60a70623a37f4de7c18c7605e99e3f532ad8c277a7fc44dd38de2caec60310ef7f1544e34a49bca"),
	})
}

func (s *drbgSuite) TestHashGenerate41_SHA256_6(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "a342e20ec138de7d9abf4e52830ba788306c54c137f9b6d8e9cc1b16563d7403"),
		nonce:           decodeHexString(c, "fe1b14ef184c19c39e124118ed5b5e57"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "870ade2f3209ccf92e3f473a8ed0a312067f1afac0d57cf0c316a56c13280dbe"),
			decodeHexString(c, "4d9e9a304272c9dbc109486522b4d60ae52beeb87671e893a83d372a14d2a949"),
		},
		expected: decodeHexString(c, "83ea469ce91234c7a1d4589565220fc80c81cc7facc12801589051e9e18e42858b9ee397599a276de205a9b1ee7b44fe8c6d20c371c104119d371550d825b6acad530121b2046471dd8261b95492ad7b58ace823bec2c14384096b261161efa5cf69b8c92a4a699ea8d8df7b04cc24a5a12f4c6978ea50fe0edb7216e35753cb"),
	})
}

func (s *drbgSuite) TestHashGenerate41_SHA256_7(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d6c4bc8f069e09e2cf0eff6241dca6e169c6c928c6049f6aa33141b459cc08c7"),
		nonce:           decodeHexString(c, "81509d1be3aad60707c156a7439029d3"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "877606701c8bfc7174a6ed8b8e07b2a7af902ce25923f91170e3115504ac95ef"),
			decodeHexString(c, "17f92164ba8187f74a5d3cca30dbfcc9bf8da5405c808d86e69ec0cf34b6ed3b"),
		},
		expected: decodeHexString(c, "566392354a817eb021e4a3a13ea276194879cb0cd72428e3b216aede311b5a4137321e6d2c44ea15e14015707a240389f0d44794d081d049f45405fc52b326b3f6d5d1271cf0cf219fe1141fb3404265bc77e4457ecd86288f67a2edf0e57cb43947c9c12ea41cb89dee94e6bda39833ee5cdb77a0732daa43d8cf2b0b95fb77"),
	})
}

func (s *drbgSuite) TestHashGenerate41_SHA256_8(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "15aa5fb1bb743e06b63cfb87926d26a62ab0352b362f5cb14e0951860eca9dd3"),
		nonce:           decodeHexString(c, "81ffc56e38a7b4e25a22c12101d77cdd"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "48cf244e0840d885e32a6ca3a779f8aa85d1b85ccf963fdbec676cd6cb2d1ec9"),
			decodeHexString(c, "16e545c23ae386c1b7e21338f0837f51c38a3a283c57f0a3aa97b11f8d684450"),
		},
		expected: decodeHexString(c, "e5eca8b0dba87ca8c2c7b8c2be1c8e8009a6440256d84d35a1d7e032e054366400dfe19bad435b119f4f5337944da5154d2d5b3b0b6324bfbeadef8a33c9d8f1e4e2fd6b7ebb939b8504bb002333fa73029f1c7c2bb9fba93c65a391aae2bb985b576c2026a41d1d56b6a33caf3fed8a75bc392de872710ac94bfdb558543a5a"),
	})
}

func (s *drbgSuite) TestHashGenerate41_SHA256_9(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "991541686e31ca1b376aaba2e0fec39a211e45d6d5cd653e721fa8bcfeb6262c"),
		nonce:           decodeHexString(c, "465996218ddf25598a39db7fbbfb24d9"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "5066003a10d0c836aede4934cf5482f7124d49aff46da0298f0107077f6a385a"),
			decodeHexString(c, "64e9478e3e0802273717f862d3551a22454aab44c19fa4e4c3aa16d2efecd447"),
		},
		expected: decodeHexString(c, "1441ca96dc3ec8f9c7624d8f81dbfef698eae0ce9035b7bee89bed4d412762279cd2fe8bff51b629d136e5a80b0dd748c629d81ed84ff9a3812a27555aa78c00fb80731cda6d167fec9b22c3e48a673a00c039922f3b6c3c2caccd31d898840c0ae1f245b1e8f2ae82453280255ccc2c4cdd9585f0d2ea2040c4c59e673b3e6a"),
	})
}

func (s *drbgSuite) TestHashGenerate41_SHA256_10(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d37d1b441184a5c18d519c3e3a18ec8df0682a0be062e909ed45605d2b538625"),
		nonce:           decodeHexString(c, "773501f19012e827cb6bceb2f4e8c0f2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "07244b2920c9311b5b84b67f37bcccc4522614658ccb131665eed288f20deeb2"),
			decodeHexString(c, "090f46ebabdbd29da8f871ba586811e8764d2445422082a41d150e2f00bc382d"),
		},
		expected: decodeHexString(c, "eea85ef6e9a0912cdc5ba42016b5814a7b48f6113e629f3b73eea46bfc77871f0c73cefead3ccfc373d87928f4e20594dcc4046b6ef79ba36930b793f34707297e3a8ab3696578197e21a515e8d940b44f625e684dde7939fed3d2c422dfade2b277ce631acb3b616c700d401a5fe7009b09da04d190a4422e76b013af1b6691"),
	})
}

func (s *drbgSuite) TestHashGenerate41_SHA256_11(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "98f6d51abe3da3fd83239406d2e184a589c0046039bc94853660796c7667fb62"),
		nonce:           decodeHexString(c, "d7d45de8d622d502db4b3d5147aeef79"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cf46d251b282e5242c84a83facf25209d840a7ef21ee8626c2c82ce9ad709b41"),
			decodeHexString(c, "fa655c1c925811b53074ecef18c3eb3fadabaf931c421653f29c01ce506992d0"),
		},
		expected: decodeHexString(c, "6ae9ca31e2e885e519132aab97a36a87f676d84a94fa41f1a18eccaa0777e3fc494f934ff6d8625373aa8a949cbb3abddfca2606fd8bb8c7d333f423a05beeb3835e413db9758ae382d4484a09c59432cbe0db0d6d1d32598b0acee7a902e76f47865b9a3d666cab7321a1d7cbf3aefd49257972088fd45caf3b4e46a49485f2"),
	})
}

func (s *drbgSuite) TestHashGenerate41_SHA256_12(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "4a9950eb71baba3ac0b25e5149a208571d8cfdeb443901936e850dcfee59ca66"),
		nonce:           decodeHexString(c, "e6708320ae2071c2296e02d27deba664"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "831049a05f536feb8794e1589e47bc67ac697e3395a5b5ff85f9151feaa8f1c9"),
			decodeHexString(c, "c6fa8a6fa23a94f15a91b69ca106cd96a1527217e24a2f3eb54a52817b91c31f"),
		},
		expected: decodeHexString(c, "59e02e5499cf7c0cfe286044e5f9f15cc4a4ecab02e88208ffd80758c8863c0a226e6e54c85c0a8e79bb2e5d262b4fc9f66ffe031693eb6f04e2ca1e3af5b611ee4de26f9e2bd2735c8d746bc0aceaeeaef7c6d8c881e7bd57cfed134f2742b4af9b2451d77588e17e2cfc8b8f8eb644e4c8073b5812ab4d70aa2a9a42330567"),
	})
}

func (s *drbgSuite) TestHashGenerate41_SHA256_13(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "31edde9cb9e9ae2ff997b925ec5e42588a7d023c124083190aac093c5b961a5e"),
		nonce:           decodeHexString(c, "220d2b712f7e2bf38e70783d82d6969b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9e65e620d96a304a62ace2c3e5ff05cc5e6b7cb5fd714f758e76e43137cba685"),
			decodeHexString(c, "8c779a51462f3aa70b60f90d3aada08994c5dce7efaef6bbecdf34b3c1613405"),
		},
		expected: decodeHexString(c, "2a80233fa1ddd3f0e9a7257283e3ace1d9569c4bbd3a7f6ec8d272f64c1ab39dac19af57490e19706b3cd293db04a6320a825a854b16c9d066d6da2745682272d6c4f75b3e5801652d563beabba31cb8f1b3e643c90d91f173fc01d729d7108e9cc7cdd89765cb8d4894de54774dc3f5e8aca3d77aded01cf264d770b9007eaa"),
	})
}

func (s *drbgSuite) TestHashGenerate41_SHA256_14(c *C) {
	s.testHashGenerate41_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b4e09a55671ef9ddd3aad256efdc6347e881f49c38aadb2a03bea89c48d3c08a"),
		nonce:           decodeHexString(c, "e1a14d523eee40240fb5ef16b0d86915"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "066b072d48f6cc6bb00273e0bc0ebc086235fe79af1fbdb46318f56c62709f87"),
			decodeHexString(c, "cfb58f59c6d56993b9f0b5ba1643554072cf4ae8013c236120044ae909083f5f"),
		},
		expected: decodeHexString(c, "d5dd7f55ffa7d53fc0f679cddadeb869f39b29a6d394c9f1185b11ebefbcb43419c6a26ae3c9ab9d456e2cdba1aead05e67eabd3596526ee431ba7cab7f94838062fcec2363cf0e19849ffef30064263b3a059ce38aa02c2729bff5af9450e035161816724163906112205196c642bfd70f36abb4639fd6e4f7f6a879ebbcc62"),
	})
}

func (s *drbgSuite) testHashGenerate43_SHA256(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHashGenerate43_SHA256_0(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "01e809719a3ce9027940128c4f86a0ed0ce29b5706741419c79da0d20cf29bc5"),
		nonce:           decodeHexString(c, "6c330857c50137dcbdbc6f684ea866b6"),
		personalization: decodeHexString(c, "5b36a0584b687a996e6d2d30715492a50380ba09c5b0fa68a4968a5e155f1c3a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2a74b5a9451f6e7e607d7b79a3f5228979399f48d71ef8a6dcb2f853536bc404"),
			decodeHexString(c, "92ef06f35ddfa17675286e81d755f443d0249879cd777086d43681cd9d43e338"),
		},
		expected: decodeHexString(c, "c509d76427e6c352f2d5fe44c9b245ece37cac9eed48dc8392e0b793da558e35c59876fb6990b2afb6321b8feeca8370b64ef97335aec7d5e0619be85f13964fbf6b736960925e9adc2c5b1bfd31eb9f1a0b457e915c5a3843d411d95738fe6d99e4ff9658646658ea5165f8a1e5c3777192b4fab92f683a3af03f9622e152b3"),
	})
}

func (s *drbgSuite) TestHashGenerate43_SHA256_1(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "ff9959921f3b0f311af7165f90f69b0b677c2ed1a6e2f92844b6c805a4a7020e"),
		nonce:           decodeHexString(c, "4051880ab2d0db4542a40589dfc49a04"),
		personalization: decodeHexString(c, "1953a947629fbc79ce4323c727466723fc4184195f9bb1018af15fcfa22aee6a"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8db0de6a5418df8c1bf002d190853f4f88f01384eb791e8c377130353d586d59"),
			decodeHexString(c, "5fc6d23ca5e8f7cb6f2fc33f3c0041e49b0d41fe9f1f1292cf0405e14135d099"),
		},
		expected: decodeHexString(c, "3025684ea6661fd1696beb6df0585b647438522d9c712c0dbbe9b356139e03c8957f6d3268f447320568b20caea135df9b97115ea7bc91e7f3563a9c80562283a0667409323739801628f965488e5a1e83087a779dba53390a961534901da7b67f968618d76909ff18b30b5c3906e0bb59d6876eac561899b7e9fabe74d69641"),
	})
}

func (s *drbgSuite) TestHashGenerate43_SHA256_2(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f126f51d9c04ea06556a96ec6ad8ed12dcd2bc832acf4d653711dc4f391369e3"),
		nonce:           decodeHexString(c, "b29d96d615b25eeeb1a2070d84b90258"),
		personalization: decodeHexString(c, "bcf7cbc8e73c0927e66e00afc3b43a24c70fff1e92a6d6bb2c37f5fc246ca8f4"),
		additionalInput: [2][]byte{
			decodeHexString(c, "16514ee7a0bf9c2fb784de90fc5a52ac72cb7d7e6a0635f4c01683d6538995de"),
			decodeHexString(c, "8b8f41c3e4015e3f2703a0f2f034eb1503984b593f1e5e8b0e0ba7ed17f2577d"),
		},
		expected: decodeHexString(c, "8632eff5a138313f3505cd6ed20e59ce2c4843b560f876041171efe5c13a1286fb00f54b41a2c70ab92ddc18810e4a81d69e1693057bd7bdeab55f42486d7c4ceb588d6ba133d5cdc9a5df24bc1eb1ee62073a5de06c522da65b2d524798aa2eb6f56256930d31d72ac981bffcacd5c06f33ed1f1873009b70dac04d5eb79c08"),
	})
}

func (s *drbgSuite) TestHashGenerate43_SHA256_3(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "162a6a17e07c17c1917f8a42c256113031fbcb00a131b34ad3becd1953bafce0"),
		nonce:           decodeHexString(c, "af05a340ab1088ad42615cdc28e27e1a"),
		personalization: decodeHexString(c, "91b5ccf739aba6ce49653bef8e67aa0171b5f7763adc881a13324d284a937c6b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0882e2475bf8bfb5c4581256cc99256f92261d493704602daba7ff6ce1dc718c"),
			decodeHexString(c, "ef71a7b29ad2c6ae7ced171a2a6f5d39e67e460ae806336421389f99c8ef5183"),
		},
		expected: decodeHexString(c, "c2ef477cc7f3563c9a2f310c6917160ca9cb17fa31b8163ebb71959472b9a070c219205148ac472eee736778cf14aab8fae0a0c8ef48cec8c5c8f51a17aa79651304e33976e6f62d23494d0991e9566dc0b07b70bb855868f07e175bac2b293da46c74b1dc0cff7aa322fba4ab03a1aa2029ea739de40fdd6e507ac5836f76a7"),
	})
}

func (s *drbgSuite) TestHashGenerate43_SHA256_4(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "241646d8af39e2256e4d031fcf7e2fb654b492bea8b5856796da6454c35e11ee"),
		nonce:           decodeHexString(c, "0d3339bd543f500c688c36b777a46e33"),
		personalization: decodeHexString(c, "15118c191fe254393333003fc85ce6d6c659857593a1c6b185bfd405ad6a7b9d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d5391da6acc380ec75c5e99f177acdc34b13e05339afa5c49bf6869a797f1908"),
			decodeHexString(c, "9a1248121aa18874ef9bd2b2f1f80678e108f17af3f70b4ebb951ba5cc46fa25"),
		},
		expected: decodeHexString(c, "8349a0fa7b9a805c2604ab51ef2a993c6bc98a250c0d4dfdae704516a40bb1c3c199a1fdbb887a750fcff07550798183aa6507f5d24e6db53f92b55f29082bc62203da3e4e0bc279be58f7a7eeb7b8622d5f8aa0af3781a8b22fb21cd3527917aabf8101bbd3f427520ad40575999ac1f116d8b3c77f2941f6e8b60f5baad571"),
	})
}

func (s *drbgSuite) TestHashGenerate43_SHA256_5(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "ad198f51da004a3fe11e648b56a95fc0b839cc75497dc6f80c7595334b6fd0ef"),
		nonce:           decodeHexString(c, "1829727d4e2f51813a7f17aad62258fa"),
		personalization: decodeHexString(c, "7f0d878a5b774954f525d8d2607972a8c0ce934aa237bcb677e8d0a47b14da84"),
		additionalInput: [2][]byte{
			decodeHexString(c, "baa453fe5d536da109a55dc4ff6fd2707a89f787f03060c1e974071b9ee40bd1"),
			decodeHexString(c, "7cbb581d62e0838cfc8b97647e7b04db1b78c8703a4587747f653c65ac4a09d0"),
		},
		expected: decodeHexString(c, "c66586515942f7eb5a809ef9d07ebebf55862b2e1ee1fd31e1f3c54f39bfbbfd7a28879f4bea55d48eed2f1f867420d9ea06b1be01b56588c923e473e72f8d18d4ac7e6120885e21c8eea32c3ae0cccdc3129ae0b92756a94a78d9af7c8bb0d3830fd332e7ce08ee2472625449edafa001a068b6e1b572c089e472d0660650a7"),
	})
}

func (s *drbgSuite) TestHashGenerate43_SHA256_6(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f74411625306c229c827b9122c9d4191c59932d98d17a360a6c4efd21d000b4b"),
		nonce:           decodeHexString(c, "a21b091e3a76e201ac6e7c3c7472784a"),
		personalization: decodeHexString(c, "69741345b60abe7f78fe30fdab9d7cac15eb5281e2fee8dbc6042971520b4e40"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a472e06c1ef17c091e26681e081c2093f1553a563e513b19e7f51726ab665a78"),
			decodeHexString(c, "2882a7b34d9cd9455401afa4b9e6770af410c0cdfb0070650699872d89a052e0"),
		},
		expected: decodeHexString(c, "53969b2d1669d2a9d74a617a2cdc443dce8f5e5b78df5bd1341aecf49c6fd1818738ca90a60650ad3b25bd3a85d6fd539d399fd0eb89732ce30aec0bc046b674ebb8f7f42a3a40c013e316b2e437dfccccc5a3407688d68a7954754b316cb0a27817418092bf181dcdffb662345c4afc70bc106e1a1009c62e4c02ac68bea160"),
	})
}

func (s *drbgSuite) TestHashGenerate43_SHA256_7(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "04912d87d697225c1c06236752d9965d461bbc4b6f2bfeaacf7fa4dfe4845b7c"),
		nonce:           decodeHexString(c, "9876c69ab89ba243bf526d7e56fcf17d"),
		personalization: decodeHexString(c, "50766199d4eda1a22ad50520e2b15efe1d557198d0dce24256b316da3b676904"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1fc4ba8d936c8d923218b0c5373f59ddaa87026ea9138270199b67c3aea60c19"),
			decodeHexString(c, "da9745b63be291cdd7bdc7592c72639f4b1ac555ad4722fad01de4d3139d611c"),
		},
		expected: decodeHexString(c, "233f2eb59e53a468d5c939e2cd8ff0f53c84a358a1f568f0dabe8a6da1f05fefcab09084721e04e94dd6ad5499b27f58c3623f38a058626e36c199df9d0c4f7d43b7aaa91694e8fa005c20ba1185f562c766afdc46f5e0b21ee8f99f1b5d74d2a5c3761712686360457ee5f39e401cf13a7860465266885c852c7e0047ff10ad"),
	})
}

func (s *drbgSuite) TestHashGenerate43_SHA256_8(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "62be631f13d81b1e541266db7e6f700d20e57507286194f9df24ae1206b194bb"),
		nonce:           decodeHexString(c, "7c96ef19f0a493ab125a6ad652907f49"),
		personalization: decodeHexString(c, "c5e7158a2f998a0d7a86fa200095658f06bfdface259e4d834d6c1527d77a005"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7bffae3849642f4e4c11e2c9d0661af728da444e84e9443cf08e16901fa6db5f"),
			decodeHexString(c, "2002702e7dbc7f9c6de15c8278b45fbfb4d49d4380e9449dd7954e85354968e5"),
		},
		expected: decodeHexString(c, "3206ceecea52e28e6d9d03394dcbb911c24550863b296213083c6c8378341c4e249a74fb6cc5076cda6ba3ea7ef4986fa11ab85dfbb0f0d1e482264a198e0d5d2237a6c8133f162df2ea903c77aea9869199a72b2b832b50702d2c56d2acd89721ab1030a7717d6013f1094094932776eb37bf4bb312c0d5890058035354f4dd"),
	})
}

func (s *drbgSuite) TestHashGenerate43_SHA256_9(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "04373d0851b92846756c9afaff843434e6dcd239e30b004be5e028c3b2f980d8"),
		nonce:           decodeHexString(c, "e4500e5872e8172297637eab7c397a0a"),
		personalization: decodeHexString(c, "335ac62faf112760a094defd1816063fc6fb9737eba95eaf6958afa58791e987"),
		additionalInput: [2][]byte{
			decodeHexString(c, "23e90c1e4d86371d1a18dad03b65e773939c1acfd348d5560440c8423ca9c187"),
			decodeHexString(c, "b7bf74b8e469f17684975ef1505074c31111cc8bf1cb383e983488b55d2ab652"),
		},
		expected: decodeHexString(c, "a57c021e65c874f93073566d8c7236ec4e4052bed18dc16adf4932c1bce124fc23db979af66feb3bf195d9037f0cc2f8d4c548453046881aaf36429fefc1177b8646306a257ffe402371b0d246f8c498f5e64fbdc41a3829c8e8c3b885e0ca373a634889f7adae7f320aefb129159ee448b1b31ba1cb7f4ed0abd8dc52029350"),
	})
}

func (s *drbgSuite) TestHashGenerate43_SHA256_10(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "1b3d9c778d104ce50cb8a355015e0f844a24da6d8f87f411df25b125f3023654"),
		nonce:           decodeHexString(c, "42dc85ba551339bbab7acc35d05ca12a"),
		personalization: decodeHexString(c, "9007cb64fe8c835f896f7c627d0c8c629a3eb498b914da68a6ece90bb8603708"),
		additionalInput: [2][]byte{
			decodeHexString(c, "959613514456db6b097a3da7f2013b20838d3f9e33b93b420ab9708faea7ff55"),
			decodeHexString(c, "545c76712a388957b402beefafcac4af90c4415a5b25af0deff0c399b75926bf"),
		},
		expected: decodeHexString(c, "0418769773d2c54d1e949960758b979ab5821db817f923ad7f4e30db99ddfe256af450d25226ce59dc089a42a3ec14d4852e67c62dcdf49aa1533f8d764771e24ea67cf3a891ac173727598e5aa7838e72c2a2cb1a880ec07d8e85c3b4c36afd263ab5697c777a90ec1505275d19b0902ba02373b1892473b79005c5564f84ac"),
	})
}

func (s *drbgSuite) TestHashGenerate43_SHA256_11(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3d6ef5c299ef4e48f9d6062692202843517883fcfbd8f04a5b1d8827f03e8341"),
		nonce:           decodeHexString(c, "da32122de317e8139ddfbf04bccee593"),
		personalization: decodeHexString(c, "0e17a64f24ffa899e7d1187311d1d15bdbb188efafa2747a961db871b2a6814c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "bdfe3217d22d26c594e1c9f294dc9bbd0524a4b986ebb0b961a8ba776c90696d"),
			decodeHexString(c, "833d96a820995207045e7be63024668cd06974a8e5cf0b5e51ac786954dc077d"),
		},
		expected: decodeHexString(c, "1a60dc419f613f8dd6ce5c1ebecd57f94c0c2d7d4a76b0eaf14f06c77056f4d85ed6bb91f93d007f73cb1628113abc7a34c6a2cdd7dd80ec14104073e6eb72e61dcc972b4bde93d298bfe12460c64dd83738fd2a39bd02dd52c910a4192fcfcd392d96f8fec83ab935d5b4bc53fa8e03ad080aa279956d9cf3a5baedb7bf46fc"),
	})
}

func (s *drbgSuite) TestHashGenerate43_SHA256_12(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "307095d3988a6784c0de8b62bfba14e76d0837497608e3ca09f40855d776ce40"),
		nonce:           decodeHexString(c, "bad3299ad3c9f0b421f3920156f84d43"),
		personalization: decodeHexString(c, "a29a09d32283d14ab219a9ddb9e16b0b1ab1d0388d20e4c67bcf0cfec09c412f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0d0256993bd88c8c8bbd46c2d57a1e691aa8d63fc52469f7d8309e984312d2c2"),
			decodeHexString(c, "c35129927df9da0114f9f4bee2cb0bf3f40703c4ae373c2d5b365e4d9ca47f07"),
		},
		expected: decodeHexString(c, "45a5acbb705603659ad55439707c31309ba29235c7394309de2fce87fefde33eca5cdf6eb2d552774d5a3567e69de17336d906891b50768b9a05200dcaab488fb626a64fb95ae13928971db3d4d5ec98cf89e72c2b8e0bdc833e316c93e06559e72d12343ff9e6340f6c6eaebb8f4bdc9756d24b25e6e18f0bb71440aa60c36f"),
	})
}

func (s *drbgSuite) TestHashGenerate43_SHA256_13(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "bc8ba446c68b2fd3fdbeb8e477344258a2ef2255c3f14dba02542bf51cc33a85"),
		nonce:           decodeHexString(c, "5d04e33def6b5ed8732dc93bdeb5000a"),
		personalization: decodeHexString(c, "26f7c629dc1c44dcc3833474bbfd76ed047b863a20d809c0b5f00eccad3ffe30"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2eea882d53ba94dd7ec57591240c8742d4c0201de62ced053f197aaf97b9a44b"),
			decodeHexString(c, "850a641c6a528478e9d21e4c1122159658b9925118c20b1f08daff3d1ddc6163"),
		},
		expected: decodeHexString(c, "c6f69853b30a92c617e2a048df8644d15eb4d4405f4c2f9eb532e8e012e57408b5390e2b71c6e1c67584817270cb981358c8ce4e211e313b5f98b9940b6b7b803a5c9eb7a5487d2f2d67fea38b45bd5d9a01d22fa0364594d21c1cb8a8f74a042dbb30ba31d5d9c4e085deb09868944cd1ec19d3e4dc9c2f1cf113eb9b116160"),
	})
}

func (s *drbgSuite) TestHashGenerate43_SHA256_14(c *C) {
	s.testHashGenerate43_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "afe8f1aed0e9117f195e425b7315f05f8635297dedec8b41d13e53b2d852a924"),
		nonce:           decodeHexString(c, "e4d356f3e11f31d3e4e6e295d15f042e"),
		personalization: decodeHexString(c, "0806cd80140302b264ac5812b74d718d60d8b3a9b279c592716a6a3d3f7ab79b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ea12ddcafa4f578b8b43337508dd8627844d185b10af7de7e907d113c6d1fac1"),
			decodeHexString(c, "0cc670275cd2b0eac5df123eb1fd73c2f2b093b76806943918cf49930fa97515"),
		},
		expected: decodeHexString(c, "88dc727007c0e03c8d27d00c87876f8990b271964a5275f636ecd7f18cac9c869e5f9df5fb2d34e7f89c2e9819af562a706a03d9be9318896f5ab16573aebbfd94a681cbf27e7202b8674437667893246c267785d0deca5033de88a61bf5158177391c2e3232ea6f812c468d5629ed9f89ad0bec0f6c7a469f56331f9eba1cd2"),
	})
}

func (s *drbgSuite) testHashGenerate45_SHA256(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHashGenerate45_SHA256_0(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d655b2dce5be6c88242c85aef1155b8b8a191de6565ead972f6199f370116296"),
		nonce:           decodeHexString(c, "4aef212c45fc6e4fcbafb655a909a153"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cb28b3e5ff3b6f72444c1c1df2f6a288bd3d8c77d26ea641af9e733b5231630b"),
			decodeHexString(c, "a2eb20f07b2514c782f71d9a3b9c5a41420d7a8bf172c06738c8d2a6b86b8bf4"),
		},
		expected: decodeHexString(c, "2990b9c15396e07ea7b03b7904df85e1a0115c55a6db7d710147ddb4fd88a0d45cfb87f77ec51f58ae5b7659fa62b1a7e29697e8b77b6f3d5e56e0cb16edbea0e7a4157fac157a57263e96806df0c095d7e1a52a29d941bfa8934f1346a3747e8ba4ac48564bad03abc9c67a418954d9658212192f456aafff6ba7802d4c7c76"),
	})
}

func (s *drbgSuite) TestHashGenerate45_SHA256_1(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e5075419dc3e8ef44b2f70de3cc4754448cf310ce7611b5e22664ccf7f76a45f"),
		nonce:           decodeHexString(c, "459551c770cb5738d6a0c9dff5a885c8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3fcca6b0a9d76038dcdf653fbdb9ea1c974772cf502cad722b0e9586e7095fa9"),
			decodeHexString(c, "12813e4f10c6b9c4c336b925acee74bf8f6898985cf2ad344f966f36dbaef5c1"),
		},
		expected: decodeHexString(c, "4ada3d40b220d74b49cb06e4a521fb9c8842df180df35c7305ae90cdac41092818fbaf4a7009061d7a47d9b59a7fa0ef571516bcc1a6e3696e22d75db0303fb60cf9b7f6cfcb433cf7066640557e755aa8acf44752b694aa6482550f00454c7c38baf071f52af82723b72ae32d5cb1db9f08b8cc9938cb41a01b572e1dfd2031"),
	})
}

func (s *drbgSuite) TestHashGenerate45_SHA256_2(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "fe4e8ef17eedfeab58afc8408657b157d237dd5a3032c3384451c645d2e1f032"),
		nonce:           decodeHexString(c, "04f259b71a64f449a96ce8bf4aaf6640"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f0c0a62b9457a43ac2055ad05534c0e588559e97042daada79ce544145cab762"),
			decodeHexString(c, "f3fb563d2743fff9be92724f07b36db36ca315b46aa58cc6e852fad274ac2882"),
		},
		expected: decodeHexString(c, "5431db2c241a02f4052065e3d9660d78b80e17d87bf4bbe1a2607bda5066a019c31ca77c5de700345ab85d7e7721fc225bba3af19a211f3d7dacf9c8636b0cd4d7cfedce80ebda6a3172fac658145c09f84324d42f40b0d9646297e8b05adddf016cf99c82cb10570e3009de92b7ac0033e0d9442d597a8a12ad9a540a6ad8a3"),
	})
}

func (s *drbgSuite) TestHashGenerate45_SHA256_3(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "acc8cce03d6331eee00e2f92afd0e57af6d334dc09f1f12b09531aedf1ff97af"),
		nonce:           decodeHexString(c, "0490c0ece0001c457c37a6ac2aaa9c84"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "7a279958ff7353a86d21b1ed8da13e82dbaad5b6ba9d575d2438ff78681e78d9"),
			decodeHexString(c, "45fb4909381329cd115e20de635c17c8aca86660d8261c8c484726c6b7a528e7"),
		},
		expected: decodeHexString(c, "c70252129ebb4eea5d8f16d74cb1bc9158410a6a21f9d531ca72753724bf65a8524aedd2e52e415a94da0bd935e8a70b411e54ca27c589bc39a7500113d693274e7ed63c1efb5d0e6ad0534587ac465bc27650457b76acb1b5edfb8e84f4879d65a96d560578a6a470f51e746a0b6ef16e905f523ee75c6dee7558042a5b5344"),
	})
}

func (s *drbgSuite) TestHashGenerate45_SHA256_4(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b4c0cc8b22ff8b0964cf0bcbb346698a55ea7919a46bc3f8b3c1d15ac8f4a2e7"),
		nonce:           decodeHexString(c, "a7a37ad52402287f358ad4ba0fe5f65c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "bd3fd666290c62f6a983165e0a9b0b6c2c8eb6c103f0f3ae81182daa0e23ac09"),
			decodeHexString(c, "d57fcaf6e2ace0ce6d593130c3981ce85b9e6028bed032d161b724526209c930"),
		},
		expected: decodeHexString(c, "d2517b96327b4254eb58ebc81d39ab86812a8e44ef791b03db3da09cda50235483708f7c8a43a2242b90a31b0a46cb3a156731d7df131ea98ccb34ff2e8c31ed1d50735cbcead7b897e68d85327c88355216cb0e9f5464e9e31d6f19e3c65354092de3ce7305f37bf6dcfda024856b4e40ca5363db69de046a0744633c7174ef"),
	})
}

func (s *drbgSuite) TestHashGenerate45_SHA256_5(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "33397b807ba729011829cb675eb78e0f242760e4d23be6346cc4a848c8652264"),
		nonce:           decodeHexString(c, "df486ddf24880a5f4e215b300b6a78f2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d0bc65dda5f4cb52a3f29a0d5795f9ff625dfa99bb18224ebcb1942409afa073"),
			decodeHexString(c, "05c67b270f38894b0be81004cac9da1e63fc5926e984a1e9ba74f683941b5494"),
		},
		expected: decodeHexString(c, "01989d154481cac57e014d92dddfe8090c408f4b429b1e7ac516ae3eaa1f82b5edad323a438b6411b7ce1387fb3b5cfb8e0c362bc7a9b3f415f3c70ddfd85bc70c9c7b206920e298d83d9926e5d499bac651761187bce386d07775941e535708bd567f394412caa57142ece8a6467d9c2c6f92ff70eb8581b6da36e047621f8f"),
	})
}

func (s *drbgSuite) TestHashGenerate45_SHA256_6(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8acf2e4ae9db6969555b4bdffddb23ebd57e95ef12e1fbc601560b95c33df434"),
		nonce:           decodeHexString(c, "ba6fbc2f089305fe03043853aac64402"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "175e6b4b49e4aecd13c597210eb134231807d59df4166a08b65c993539e49275"),
			decodeHexString(c, "dd14a03bb1c5fdd814dd26427cdec4374b6c9fc33961a825d5fc806171418d76"),
		},
		expected: decodeHexString(c, "5ea601cfcd6ae2be5416536c090fa84f890f7ebdddd25aa4e2a6310134cd14651ce733a4d51a0fe272683474e0910fd1802f1c1e1a0d5e1a4cadfcc4a1ecf125ed48bc8ae751c07b8aa6052d6ac4112c3f9845ca554087a8b33ebe999743a9e02d2904a2f309783eeb78f639846214d95805e69531617fca284c911937bafcfc"),
	})
}

func (s *drbgSuite) TestHashGenerate45_SHA256_7(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "7e4bc7f6ce0e75a2c1a9ac2816fbc72fb47d36516d116e753cbedeb3098474e6"),
		nonce:           decodeHexString(c, "b5a7315add24016885430c4dc66db469"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "e32bbf798ecf281397138c0948070a7f84b99b700bc37e0767515768bc172a94"),
			decodeHexString(c, "343c58ed4dc4eb6b9d4b2955b9a9c0af8b2cf150861b75544e59aee5b288a6ee"),
		},
		expected: decodeHexString(c, "517eae10ef91051ef43eedd77347777358bcaf7b7851a74e1ba1fc42471ec1a4aaee4e0cde41fb0cd89b1b30aabb146b8f267dde63e875ff1a2cf3414b5fe3f3b22bc7dbdfebaae3432a620f1ed7353970553748e2188f99e0d081eb6910009a6404701bbba1955bd33caf6f8cd6a117d55b4202180994866f6e91bda647a512"),
	})
}

func (s *drbgSuite) TestHashGenerate45_SHA256_8(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b467e6551dab99051d2273b89a5167df8ae9a85d7c8c038a1c9c36e8f72547af"),
		nonce:           decodeHexString(c, "82e5429a03e76b1b51eccbac296232f6"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f0fb787b91336de9bed6ce86398fa84e0c3a640fe904efbc4b80bb28f77b656d"),
			decodeHexString(c, "36d776f40a725de32a94bc516e9aebcb1058440020829d32a96a4fde1b8c02be"),
		},
		expected: decodeHexString(c, "82eed6652c2b374ca8827fc0772c0bd7ad22913dbf84f5808dfb1cfa717d996d9638cbbf93f5d6b8c8b71186efdc8f0aa8a7d2c7afc3b29a0b4790b317742e40c5584842929843219b5504f4d8af002518fee33fed858615b3151601c4f6206545e257045b1cfa7a8d6f22097a734918d0f8774e4cb87fac1b93e071e5edc393"),
	})
}

func (s *drbgSuite) TestHashGenerate45_SHA256_9(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "7b87eb8c272b101223ae3b6f2e7195a88e37a85136fc7a9f7057826ebe604e3c"),
		nonce:           decodeHexString(c, "71766afe4ab1a1aa178854f5b5b683c3"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0ba1674cdefebe59a2d33c06105dfabfad70ad76153988b69b2bc10cef7d1a50"),
			decodeHexString(c, "78e45ebf6e2032c437fe7f9e3310b5ede1b0547cae5b1372cbc69a1744c85930"),
		},
		expected: decodeHexString(c, "e442973e8f6b9daeb2740c5878ecffcd1ec1afa28a32b76c5d93a0257713e3e198dfcd4488b17c54c2fe4b014846abdcf2c4f881af2bafa7cbd16e17f89ce9f3bdf8a5810fde977760159e254ec5ff098df410a5f27e35fba25532add23227a5cdedae75b0f08420568086812fac85d2bbe055b4c0847e644ad227e4d5f1d719"),
	})
}

func (s *drbgSuite) TestHashGenerate45_SHA256_10(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "e465ead60ef17fe195a6bfff3c852d7d5dc0ce0397c8e3fcaf16c042fcc52503"),
		nonce:           decodeHexString(c, "78d40b9b261f53adf952b9b38c2a46c7"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0d0f507da569735731a31c722818699bf682258afacee50a4b0dd6e5be24a868"),
			decodeHexString(c, "69157422c69d110ca6f34592dfe3096f5fba3c5a06ddcdf86eadc34bcce5d427"),
		},
		expected: decodeHexString(c, "acb0d6ec609f8bfbe92fc5ad23bf23bc2ddf625374c09fa3ceb1cf162b4952a696d9cf899e1e3622820f374d7e1d33f61109c9bf57ad999a9d55db02be669d999975b19c29c34f22951dc922954253d18126e7aca1e6105ceef1b3ced0afdfb196a87e8aa8a8eefcbfc7082702bba3e3562b183d1ca776f219497ffde29e702b"),
	})
}

func (s *drbgSuite) TestHashGenerate45_SHA256_11(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "ecdb60558a727c176cac1394fe81333b6a01d73bee0ff98575670a9146961532"),
		nonce:           decodeHexString(c, "d9b2933300f20e5755a15b8f53ae0f84"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "77ca4365ae20c488297a08fdb134137ae4048a4f1769c873375bde2984aeafd4"),
			decodeHexString(c, "f72c33140e7f95c1257dd5cc7150d0383e23c70afc44ca0985741ff1c5d7bd69"),
		},
		expected: decodeHexString(c, "283657e6d2effde0b190509c70b649ab3185db1c0e305dc796c215ac06baeaeb4df94c903a6eed2bb713fdb129ce3638a2d4364401aa3c79bddb1017bdc5f452eb469e6780a87733207bb2f0ef6df431d8143c0310e374c3e3df59f233648d43b0d954f0cb8b40b733bda65d07a4b6e94fbcbcf409c422208a208343d8709250"),
	})
}

func (s *drbgSuite) TestHashGenerate45_SHA256_12(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "911929c3ffc14a8ecb5b26586edae6ff282bcbdaf9c4d4907f6846a2562a0c3c"),
		nonce:           decodeHexString(c, "4d7a46dbc5b6ffd0481a3e070d5664ee"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "4ed9f3b31507637e0692f2f0c705b41b0ddfeae0498622517c03682cac40d7cf"),
			decodeHexString(c, "3c529fe88e7863a78cd4f0e893b56d8b780723f2b579dfb855b7135dfc04090d"),
		},
		expected: decodeHexString(c, "c6b33017129a5fa1ae98855377447cbb51274780ea819f322e3180cce3b92abd0ecd188bd45ecbd7f2457b49fc560159f70ca07a26f6ef199f5f05673a2a153a4c2d05b2db11cbba731a8cae0074434f743eacd8de46ca73a70a105b5a902c47e6a5c94b55184993ab4a11a9cb9b0914c3e0cc022663c517fc0ed8bdfd91a435"),
	})
}

func (s *drbgSuite) TestHashGenerate45_SHA256_13(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8663a4934a27f7ce257aa05f3e7c64ac4478481f0c822e2e5a7ab17208f16965"),
		nonce:           decodeHexString(c, "1a26322dfdb96fe4a881eb32efa4e8af"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "43a3a82254715ff38223b1bdaba44167a475915782313bc3a6403cf470f53158"),
			decodeHexString(c, "03b74c720e937417684628992ae20f9058109bec1c40ed42fc782c83745ab16c"),
		},
		expected: decodeHexString(c, "38ac18a7b3e8b4c7ab345281031584c8ae55997bc99b3bb16b9b822acd2da7e07b82b6bbbf1aff01a091252658f641de11706fd00939335f0fbd841b7cc8229aebf0abb5ae1ef08ccd9f9d28c3e11246e8ff56b2254d32c5a8f961d17109edb44e4b8f057bd64672b231e5b6a7617f34602174bac27ee405a4815b17ee9006a3"),
	})
}

func (s *drbgSuite) TestHashGenerate45_SHA256_14(c *C) {
	s.testHashGenerate45_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "614eea0aad7d0c66200092a0f8303aa21b3349ccf05ec5590272f890578176fa"),
		nonce:           decodeHexString(c, "4c4fff769cb2196ad57c9a674db91bae"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "147d51711ae8a420f165db0000d9d0cb9e9cd5447311eed43d7cc9217df97a3d"),
			decodeHexString(c, "2910968bb1976a1b8ced116e673f408da6fc563695c918ac0a230b0bb800c707"),
		},
		expected: decodeHexString(c, "357a7269b30ca744e213d894f5c45d0db9fba897e0c863a56062f5018ad9be9f37b8d550014ed68f2c34bf5195c0b7460df171ff3bd4a590578670c92470d876c8de19d48a6d7fa15fc7996be78d3cc8a5c657439f4bb9865bd56e187d5df2531a405e3e0f4b87c611aa8e226b8b0266290f06f8062456a7a4bf0896e4ddd948"),
	})
}

func (s *drbgSuite) testHashGenerate47_SHA256(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA256, data)
}

func (s *drbgSuite) TestHashGenerate47_SHA256_0(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "b1a1a0a1f13a67d9d35441c96f8662e499f78a75b1c0a5c2e26dbde74cfa8489"),
		nonce:           decodeHexString(c, "e0c8a8ad309488f2043ba4afde664d10"),
		personalization: decodeHexString(c, "b54c1b191e08d33957b9e42712df4e64c8ee9ccc5c2e21a64748b36bb82315ed"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7a57a675c9df3ec61a20194a34fbd9f75944b36ac33f755b5a4546830011f3f6"),
			decodeHexString(c, "83e57b2d0f045d63f01cf2b43ca38b2b2f043fb2335f1bb1b571a813d561ede1"),
		},
		expected: decodeHexString(c, "884328b4186f195800c5896fabe2a0cee49151678508c71b7ac394981168535baf1d6cb5bd6e6a1bb32af4ebbd8ad74cdfb5a6339b20c3cdc671fdca118156735979da11ed1e4a3fda76b4611407f6b8e80a3ed25802a4d431c01be668c52d37cd5b4f1cb61f57e3ff5ce0c374e2554e9ce311426a053299c3c846594e4bf536"),
	})
}

func (s *drbgSuite) TestHashGenerate47_SHA256_1(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3a12416992753074ff1459c565803a9dd38f733b1e609a0d8529717edf9967af"),
		nonce:           decodeHexString(c, "3a9eff839b5a3e16ad9754b4ca9fc888"),
		personalization: decodeHexString(c, "ae8fae6429488ce9cbc42f6ed589107a28a93f47c4f76a4ea3c0d8cb62530a50"),
		additionalInput: [2][]byte{
			decodeHexString(c, "258634c87d0990169b2d36f418ab810fc03728406581c2f5d0baaeb9e4443ed3"),
			decodeHexString(c, "4111d6bf8b9b9e3bbe9f9c3c412c846ca2628249cd1923a233e10ed08bf81872"),
		},
		expected: decodeHexString(c, "4869bc773ac8a485aaeeee27ac7c3b6ddb4671951020de82d31005efe399d5e42eb4b6681e860bf7a75cec554bb93c20379fe61cd618aec52b934f5673b48c0dd79ace33854c30adcfe254921c63b7092636873248f004fa8136c6724d480e5a30786f281610ab29820f0c83d47e70b8f67620090bcede7e185ca11a75765847"),
	})
}

func (s *drbgSuite) TestHashGenerate47_SHA256_2(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3f6dfbf0dddb435f4918f8589a307a13b18b5266c968d16e1c25deee80dbf27a"),
		nonce:           decodeHexString(c, "6136d723b92eb98e77691fb67de701b8"),
		personalization: decodeHexString(c, "90048b185cc1d7432b1221520bdef6dc4156ae35920e3abb541875d7249b6c06"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8ede7c3f39be4edd57d351c30be8998cb38d7686eb6cc1bd070f35d792a2fea6"),
			decodeHexString(c, "f6a8f40c943d3c40e8915738fb702f862cc105f94831b794bdb606e86235f394"),
		},
		expected: decodeHexString(c, "c19b388646174a0156f3ec227e42664737c735fa69b587a0534f261eaa65d7c533407f071e8fcc81f42d085fe9f9543aaadfe060340bbcf4223220d0683a4fcb89a7c69426d1806d04cdc2489643e7e133579002aa48fae5792841119065a4f8fd7209074298ebf7fb467ba52cff2842a36a85fde71ac4b129fcd109d9d3e967"),
	})
}

func (s *drbgSuite) TestHashGenerate47_SHA256_3(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "997d371ea177188463c9ecaf63ae2ba867d8d448c91df1977dbe70ccb1f6cb6b"),
		nonce:           decodeHexString(c, "20ea48799426051ba13939653d9668ae"),
		personalization: decodeHexString(c, "dfa25a85675adc25db3570ec790dd7eac9e92b64a5879371e6c67fb3be630dc1"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f68a5656436c9f739c72bf831da09512d79814445bdd9c1801ea367ce2928e0a"),
			decodeHexString(c, "a0ff3a93a1626935749fce8c63216492123a96fce53098787e2ad4bfc3b883d4"),
		},
		expected: decodeHexString(c, "c27f8dd3df5ae2131dd6cc7e673ab0edc84eedf3dfbab0e0c871fc0b8050eae21cfd437656095b25e89fdd35fb29d684e342a0e882d4967db8feab6c60c2aa8488045be63332610b0b5779825eecc6283b066ecc1df976c283ce8864276e7560e53167721b4aebfc95441717f7469cbb2cc0d7e082116e201278252602026ea0"),
	})
}

func (s *drbgSuite) TestHashGenerate47_SHA256_4(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "abd3ab8031c50746da7504c8d6e004ffb9bed74ced3365423cb76149376817a6"),
		nonce:           decodeHexString(c, "db56167358e4bcc8dd261f2129879d6a"),
		personalization: decodeHexString(c, "faaf7dfa866a726e635750e7fbeadc268f2213e70fc59082b7c451feaf902fc0"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f10a641ddb688473c47ac20baf6ddefdbcd9805776333481acca26c61bd7ed2d"),
			decodeHexString(c, "5b849bde9a82cdbe65ed6efe5b49cdd0579b40c53d3014eab041f7cc645db05f"),
		},
		expected: decodeHexString(c, "d0c6b5cf0ab7434f9e6a9b7ceed29ed9ced755385c8a66fa9d448bd7e5b6fcea32fc6e1fee34b6ba49c727d228b84f192ba29c8e8c30effe59105a81f7059ea94573c00b83c58c9d0e0c2ae080d94a52c71f95bab28f7634984732dbb19a756c378279b48ef6aa7ec32145e395352c1dc0c856727bcb857dc0a8e1b935848dfd"),
	})
}

func (s *drbgSuite) TestHashGenerate47_SHA256_5(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "39cc6cff94a582f5bd8f0a963f185211d121d84f20082ac45f079fb8078aa024"),
		nonce:           decodeHexString(c, "0a195896ffa44dc3d33a9dfc1e3ace72"),
		personalization: decodeHexString(c, "a4f2dbfd33237f628d40c7abd0de84d8327727ca2c7ed3c203dcb437717f51a4"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e4ab130c1453ae6400bb2f27f8dd5b0d96fdf46f50964bff5f11f00c3c3c8431"),
			decodeHexString(c, "86884795ac9c045ed5eecce236f9194d801707907e40c867ec1760e170304e31"),
		},
		expected: decodeHexString(c, "c5073fd20fb16fd9afcd5e15221371d5e066cafc80f2ce559e2f814ebbec6ff2f4c07c11de5bbeef9d6cfc92cc6bac904a3c5c1055fdd7094d805d38f0ac6c5467b28acb7680ea836d616c0a5e3468da5022d6a382abeb8b81210f7fe84e8048cbf112e8e6d6fcbc65bd67b344888265ad295dff7664699b35433b5b3ec13e7e"),
	})
}

func (s *drbgSuite) TestHashGenerate47_SHA256_6(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3e8579f74c8d91b38b03a190f5cd17f6eaccb2e77cff28011175509096cff146"),
		nonce:           decodeHexString(c, "c6402322de78227a783751c4b1fe28cd"),
		personalization: decodeHexString(c, "fdb70c3c22d04d7ab2e442183ed0b2e090b0bcf2187f0d2a87152631753bac4c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5879107cc1629ffebd599b9c11f61e89fe8b73c427ca67a5643e3856eaa778a1"),
			decodeHexString(c, "0623d12e4106cb37e516236b90ba0baa6eeb6ae4428d64b6986b4daeeb0ca814"),
		},
		expected: decodeHexString(c, "390df2130922b7cc05978855a3b5c8a4412b86ed6450bc43ab99bc3a4d7621f818b9db1c79bf2cc0ea496a5dbd33001b9645fffa7301e9342337406f56804ca8176fc2919357294b5b9301780a8388188c4fbd894008185b4ca58d424061961380e80f771a81fc31dc0ce17abba9bf0527aed5668df5299cd568d9d86f7cdc00"),
	})
}

func (s *drbgSuite) TestHashGenerate47_SHA256_7(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "d53b6acd4850470025257fb4ceb30991e2670f1cc6015a071446d40c8b2c956e"),
		nonce:           decodeHexString(c, "94ce72ca1d7d450a3aa0737bb8e5fdf8"),
		personalization: decodeHexString(c, "13e3eae54ab017d88353b6e71403d8153974658d0d63adc823bc6748e6c4465c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "364a3967aa3828df17918077555e7b4330bfd6db87e38a41813a0f289a351033"),
			decodeHexString(c, "5fc5a13e7174d56fb8f706c3786be94e345afbf87fe436602ed525f6db29bad3"),
		},
		expected: decodeHexString(c, "edc776718183149e3e2b2ae74bfd586d288264fdd888c71a184fd310197ee6d01edd10c9e4a985409ac0033989552b61209ce02aa40f8abaa48e58277c6967bfdc5871eae4df83479aa935ad1b9c0216ea12776df676c7d1e6b804e76140ea044d98a1f1729a773f8123fd7dff0e9ef801cdd0c53ba4f0564b499669e9d973cd"),
	})
}

func (s *drbgSuite) TestHashGenerate47_SHA256_8(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "14d1e6a1896f2e2d5c3c9f52fdb0a38c153adefb2b721ba1c7e5bb0845b08eab"),
		nonce:           decodeHexString(c, "6facbae25c11e8944f8810b57fed4fc2"),
		personalization: decodeHexString(c, "bf740e44536271b254e9a65a0418585ce49efbbdfa3ae5868809b3a9cf1c3148"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1a2e1486550f5857defadde82a341e3437a3cf27c6bf4fc1cd8a5be6661e6d14"),
			decodeHexString(c, "e054ad9b1aeeb46b9ab9effe96cf44e8d9a8c1f6a2099d0c0ffcc8f2e171bfd4"),
		},
		expected: decodeHexString(c, "91eff4f9d61ebd4993431628cfe473d8dc106cb69ece1cd060930804f93766b2d5c49a0de45d89b022651a26094c4cd07812bcbea7fe546d942eddbcc1bbcbb954d5bd84b0db9366fb353e24d34a4cfc37cc002f2b5baef7b79674a4d63330ada487f7bd269c13cb723331018a0afab0fdede8f2ac6ea93e84571d7112e78263"),
	})
}

func (s *drbgSuite) TestHashGenerate47_SHA256_9(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f57c1dcdf515c3c663f4e0cc90674cf6678e7e84bc36d54027a87813ff366be9"),
		nonce:           decodeHexString(c, "7c750b805493eef74cf1756242ba1b12"),
		personalization: decodeHexString(c, "816deaa6c27d0a2f6caf8df8b7a222554b4fb6fc50350bbb82c99c82814628cd"),
		additionalInput: [2][]byte{
			decodeHexString(c, "1045d2c2bee045362968da8d54ea42fef4cdc4b0b8f32fc05eead7401d4aa04b"),
			decodeHexString(c, "40e33c65d62342748014e179cd08d8a3c5d7d7e212cd75fe7522c79ac88533bb"),
		},
		expected: decodeHexString(c, "f0fd07ee4406f2be3ea26dd81d27567af67fbad791a22154e878d388da66d8138a77b559401cddd950eda9d4e8fcd7d3441ba52efa9d373a75300c7d2da993bab5edc1a73dcbb954da090e3d171660229e8674ea72076506210ace9841f292245668e42c6ae666d803de03a91fb969907aced7b2ea99ba09132096a056861846"),
	})
}

func (s *drbgSuite) TestHashGenerate47_SHA256_10(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "c913a05682edbb93d3893e433716d6ee85d714472b8787e8da9c9cdc5ad47520"),
		nonce:           decodeHexString(c, "10723ef0d3156cb3ea73462117b9043e"),
		personalization: decodeHexString(c, "3bf67a5ea55fecb3f53fd95e9a0869e5f3d0ecb26f4e427d5f38388ea041b5cc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9c17b2c6048db20efa260c491e5105dea2f7c6253008d0feaeaf099ccd43e9bd"),
			decodeHexString(c, "5a739729baea3994f4c57ea0f5141a9869de011c88ae3d262b2e744624f44de1"),
		},
		expected: decodeHexString(c, "c567a512a21e53e687b63c51bff9144ddb902939fb5e7507e1d954b3122820dbd7d693edca18f825bb65efb122a86c02ff418065a5068fac80faeb9846f8db5aee39c3f20b60afec484f53510c47740dfa7a8c9fd606b0d50d20d6c07cedd47c22f9985e363554fb567c8294c864b5d9488c3ee0e483a775e9e668dfe73a1afd"),
	})
}

func (s *drbgSuite) TestHashGenerate47_SHA256_11(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "f1917e59978b897e41b41356f83e19ed1e07d5b02a13dd512507dafe16b38280"),
		nonce:           decodeHexString(c, "4e417a1f441a4a3b0ec19f31e944bde1"),
		personalization: decodeHexString(c, "1d0627e94172c9d02d3d71ba39e35c79393c55b797575a6e4249bbff8618d5e7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d07ac1b2a33fe514e04941c244ca1755a59adaebd6880331728dab83f978bb4e"),
			decodeHexString(c, "74f46be664a44b27dec26cb0c889fe87d5f0e43cd790616fa0a79f875629a57d"),
		},
		expected: decodeHexString(c, "5752817dff8a947aa14d632862f2b83bd6dc862815e461b4bed109e49419912cd0a129e15646d9ea18be1ea9564930cbd499ec7bbc1526d73350117ea036e97482e31ea189da754e9a3248fd0657885b1bb9fa3c8e9095130e7173d41728defed97438597fde676623bd1d4fddd30cf5e5b2054dd2031300694e6a05d5adfdd1"),
	})
}

func (s *drbgSuite) TestHashGenerate47_SHA256_12(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "3c4022358cbffdf5f462bbe4bac6cd55f544a4738aa7efcb5c0ffb11e759a3b1"),
		nonce:           decodeHexString(c, "53651bd2bd2bb9041846457c47e0ca53"),
		personalization: decodeHexString(c, "45416521e2e852298c341b02ffc9e7ecaf0ef5a1548dfe56f33e6b6300edadd2"),
		additionalInput: [2][]byte{
			decodeHexString(c, "d3b202d046f032ff11cbcfa59a549920f3a673f73b1fd1de8a4143f73922fed5"),
			decodeHexString(c, "10c480b05092b16bcbb354cfc0933ca36f281880d5d10b58a9679b5d3853f0aa"),
		},
		expected: decodeHexString(c, "02f4e3c8c123438863d569a91257e9aaa67eca364ce32fde7ebbb3e810caddd76b205aec1f067842f54536fa61328c6d4341985a1cfac6151f63c47c198c5065e615ccaf33b712305c78876d2af1cdc0fa552dad953f67e25a975d8889977b1befccc4cff20061f76bf023fcf578bb2dcb1ea044bd53826d11838c3500d29790"),
	})
}

func (s *drbgSuite) TestHashGenerate47_SHA256_13(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "8f2654e05afd29355a758443de6140fd3eebddbcb4bd09c85c83c8a737d2963d"),
		nonce:           decodeHexString(c, "f2d38dadd537090a398a811e8534713b"),
		personalization: decodeHexString(c, "f8eaf956faf312265e85b66ddd9741254f2ac3437690b4e583201d93565771e8"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5250dcc23357fe76b2e7995926545350a8b9c95787b498c98762b0cccfa84a64"),
			decodeHexString(c, "bd67d109db303aec39cc14f6133359c89035991bf43a3e97b1ad0a3c7dc63190"),
		},
		expected: decodeHexString(c, "c02bf26819037d80eddd5749aba29c9de7d05891f541239c14f935a49ac56a3d3280291d3726ab471841ab8f7e3f5e785a94b23e057dae900508da24f6e007c6f783c08f6ab7de49ef637d1812ac822a4c0c84616e509121d902bec2e3c4f6626979724f2b0cd2ec3f7b44522345e56699ca3ba701a6b9c4bb0a7836fe161845"),
	})
}

func (s *drbgSuite) TestHashGenerate47_SHA256_14(c *C) {
	s.testHashGenerate47_SHA256(c, &testData{
		entropyInput:    decodeHexString(c, "708f5c7e10d56c30456e9e3f5869a95a051cf7cf107708c40cccb801a3a7636d"),
		nonce:           decodeHexString(c, "bac755e701b1fdd170dc92eb0f12bd4b"),
		personalization: decodeHexString(c, "f1db3acd73914a62bca9a5ce3497b1b4da12b29cee7dc4781d7caddf67e45f2c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "228522e58e65d50dfd176e8ff1749faa70fc2c82eda25b0748ddc5d41fd71be5"),
			decodeHexString(c, "7af60c47b4cd146a39887c9b812a1dd814d74c398609bbbfb57e73da9caff57a"),
		},
		expected: decodeHexString(c, "9528c88f0aea3fc03bb8a9061e159a06d78a2a654408808aa4d0e73ab1a51e5aa85e8bcae72d34784ff6f513193e183d556ddac5675314f2b5cfe392d1526056afe32d7c03e09ba2bdf3b10e228b0f600a61cccd9e7bf14dccf13b16a838e60909785307e6905d510d9888eaab169fa601558fc952aa8559d270ecd386d7fbd7"),
	})
}

func (s *drbgSuite) testHashGenerate49_SHA384(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHashGenerate49_SHA384_0(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "88e60bdc0216ffda724d75a78929a362e6d15ec340f4cb52822660da777e5420"),
		nonce:           decodeHexString(c, "38643e37dd376ba886262ae8b7130d93"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "78860ac12d6f1779bd54383ec65f2594ae87f290a3fa3df29f11aba212ef469f"),
			decodeHexString(c, "a074df12db9ecb372949dc73a02a7cafca80440824b8e6ccdb0cfa817c89fe23"),
		},
		expected: decodeHexString(c, "56b45cdf36fb6d47cd26b8e6f02677ba42cf43dea896ddb9e9e724a741e4112df6d396dbcd47672c6f85f9b2aa672645f6e0cb01ea13609fbbcd16978d741357f3e7211c07ca90e42b5639cb5e3227b549972a6a7ae5602f5b400de64c0a578ac59a133b7ebd97febf50002b3317b7b7d02f664d1e1254ef3c5c7043fe0bb7cc0ec20fec6b908ce697dd084a4c21fd1327014f95ce5f1842e07f69691c6d978a0a10c645827553045c7b54e22d38a17b5b0ed491b1b65505ab2be58940cc0d6a"),
	})
}

func (s *drbgSuite) TestHashGenerate49_SHA384_1(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "039742435f3781b50364bbb02f1d5be7a943aeb672fea3086f64981e03ee9914"),
		nonce:           decodeHexString(c, "cae0b79fb64a8fe3762e1959d1926a61"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "f65ef033dec80726a302f5131a2062fe521dd1f2e78c77c68409cda3637e428e"),
			decodeHexString(c, "ee22d109cbd742cfc29bf70e24a4a4654e011728e72d5bc6a208986448cf8510"),
		},
		expected: decodeHexString(c, "619e0cc67d3caff375b4686f913178dc49a357f632b383b020ddf3e3bee64e1869678284e24b15cd367d0d0f3803b131cb5b3fdedbabafd65487e026e6557cb6e3e0269dfa1fedf5f84acda609defa95309fba8d43c9b68b9bb4cdcb52f8ceb1533a4125282ed69df3913529682a402bf4f896b890c5f13e9cfd9de36aa0d3914f50ac1445f3c0cb491978443a9d64c00f582d4879fdca89a1958e6fa6ff49ee0ce3070b25202de9a482a871abfbb579eb33367c78a3b7c2f643246e01042764"),
	})
}

func (s *drbgSuite) TestHashGenerate49_SHA384_2(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "61ff07cdda8bd6aa9b3c7c16c9a3e1cbcd17511096853c7c982b433879517ce7"),
		nonce:           decodeHexString(c, "8b017ca23dcfd6ec887b7a4a25bf56ac"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "280967d19ba7a145e9954fd7a95c71745e6915dc0193351b213db508b864f210"),
			decodeHexString(c, "9740369c9166c6c8a37dd78f15cbdd1caefdaff34c11bad2c4fca926f349e513"),
		},
		expected: decodeHexString(c, "c0c980b883af16003f9713ff2f362059fd213bd9c39998e0fc3c2327c6c8bb89aea75e8830ca8f379156824650de3731a9942dcfbe46b65985e52aba8798ba6eb1ea85cc559f2a106a6f8aa82d4bbfe2d37cdd0a1a5dc22cd9267029b00eca99dc20129b6faaaa7b066d3e06d66993f91091117552a41fe615c3ce025aed44a8bbc994de6eaec33f6b3f62b343d3c27b54ad78ba833d92c0c376117e4900f97bda6037c445ebdc370d78e335cda3884d1b78663f172610880f56bcb4021bce65"),
	})
}

func (s *drbgSuite) TestHashGenerate49_SHA384_3(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "133897c5d21d1486736de5a9ea7c56cb9657baa215bb7485d5762ba114d13252"),
		nonce:           decodeHexString(c, "ca46dc46d97577e4b105a4c3d9e2cc3b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2c2315115ae67ca3734a4709ffbe6dea36644f07a5c3108f22f2c9ed00d0037c"),
			decodeHexString(c, "1a267eac7ea6c2419b5fb175254a307e388aed2d91d26086dac65edbd4ef3edc"),
		},
		expected: decodeHexString(c, "787937789e810e5bb3bf99274dfaeba0155f6671fe9aa6d7044f8d8e6d2e1ca71c3ea087412c7566f56240d34ead516c222d0f07e0b8922a3614ddd4307d29d76e05340c86934db19982c29bce0196c7ebdd7824827df114cfb0ccafe884d4fe4e5d4dd6b5bc50dfeaa95cc3db7e20bd6823aac27b7cd329daa149eead3443878030453ba15e992da7146a04dcd0707cea0449ad6fdd5110c71e68ccc639d92308b3fca5c32fb5ac8ac74f0e895e703ff5036955805b4b64bfc3064a13d3cc13"),
	})
}

func (s *drbgSuite) TestHashGenerate49_SHA384_4(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "cc4017a405dad4a7a8dfec1fca936e216eaf449284a21030720dd9dbdd11a829"),
		nonce:           decodeHexString(c, "cb23d09e086ea3388c18b99fc0942b09"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1dc3f63073d70e2712b59a8ffd341a949ffa834c8d5bd504a70cc159dda7cdca"),
			decodeHexString(c, "3d7cc17df61bdbddaf7f7370d8d0e27b4ed7fe01c29fbe4cb356a453cb86bd80"),
		},
		expected: decodeHexString(c, "2e0193b4efa8599c01493712126e9858538fd094e063e775020a0b9f0b8863a048ed9a5bc31fe0504ae8ccd4c69b2fa74619e19cad595817dd8599b4cc59f586e4bd6a1b09b7500690348a002277877a43e1b240837f89b12cb2a8e630375a18af8571dbe8ea61f5261f747b5ce10ba48582943f60facfc37bd2b30d00f1fa9482d793da6119c2740c12f9954dcb93edf97e0c759f600d4ee30bf66bbfdd58831a882d871f2e0f75bb387e0466cc5960f349cf842b1f74d055025546dd3646aa"),
	})
}

func (s *drbgSuite) TestHashGenerate49_SHA384_5(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d7faa4176cbbfe084fb4a621f7dc5833a5822e5e91357bcd271f42a12b40bf00"),
		nonce:           decodeHexString(c, "95c3bcc58d1e8d6343271ac68ab83133"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cb9fd2644cb3592492bc41b9cafa676f1ae2ba415f782beba264f4c5f7929885"),
			decodeHexString(c, "c3612a530b3c6dec171c065a5c9e8733640d2d89b57cdb881727d0ada35df35e"),
		},
		expected: decodeHexString(c, "a4fa57a5ec0bd703ca2d2331096595f5950908060b78173c882c7a075cd9f55eca67df781bfc8916be366c9110f1394f47b573c6febdd652c69aab60b651d9ac2f466544f8e463d14f9b727f81f23a5adb83c9aa92da30bb620e0238a56188a42bc4d06c07d9fa3a0a0f123f808247416bd326c42b7414b615eae907119763c4aab18e130741447747964b6d0d72e881597901dc9b4fe08f3e7700dfc243dc9633765f85b088c1e71fbea816b523905003bdf5a4e4aacb6f3454c07d7ee63b6a"),
	})
}

func (s *drbgSuite) TestHashGenerate49_SHA384_6(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "affa831c6d28648f3c3b8920be71f02326b089bf1872bacb2955bb81e900791d"),
		nonce:           decodeHexString(c, "6fb415aab2bc9ab49239180d06f88350"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "22afeb7c0744e21e6272c38025502de4c767077b12616b5803e77ca3a61e9810"),
			decodeHexString(c, "5eeafbe50d479be20ddecff20225b5c82dc4db3b64bafbd0f7e473decc81471f"),
		},
		expected: decodeHexString(c, "76911a7de8ebc80c8047a902362191ab8a2d63e3e022e318db7279377653009ed9c6addc0bfde08245d4f10c5fc25b58223b7dd6b951ef83aaf259b353c1537e2aa3c49d3ea5e9c8431c091e19294eaafcf91164e61d5d06944b3e14ec3fb9560722f5e6708152355abc4268eaf77f13155d3bce2360e6c8dca56df85c2f90fb3699b86c3e10782dddb0fb658366355aaccee6c70d1a49240fd3a7bb0d74d47a8caba3e508535e6424dcba812b3ca2ee09f91fc74af7b22a877369843c2526bf"),
	})
}

func (s *drbgSuite) TestHashGenerate49_SHA384_7(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "14e71204bf09aee3e2e588d6d34f4302a4942a67e3b4f92d86401813839bcabd"),
		nonce:           decodeHexString(c, "94e6df08a79317fb7c7744a5e56b983f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ff0527ac23da576c37a5669b91198c6b553998b17da665e424060f6c4908cc4d"),
			decodeHexString(c, "c72a465515451bf1a45adf1e7c772aebb62f718c4ac5203f68499518d607032c"),
		},
		expected: decodeHexString(c, "9259e4b645b3323d6045e25684349c0fb09c5abe48c9ca7d847dfc3f38930c55e68fd580951921c6322ccee36030ba32b3f72e118d54d28551fc7cb4a88da6158bfc4838ba96dc6e491b1023a7171fd9798a8b507bc615d2f7c3f99f27693ab777e05cc98518095625eae58930936e1423d3076e38eebeddaeb9c643905ba3ec3c20ad7fe7f7bfe821912180b1924d0a05f7dee45ab4a3bdd334eacbd27e6d8dc96db706d6bc593f9ed16d111c86060028f9ddfe692f2d4152be33db7e2e01d3"),
	})
}

func (s *drbgSuite) TestHashGenerate49_SHA384_8(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "0b2a266c50a0c6454bee0f46cd186906809bf0c4cc753369bf31a57ada6c0a8c"),
		nonce:           decodeHexString(c, "4bf252fc2a6c71f47bd6d8fe5558fd49"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "94adffa25a5deeaf363622be8dcf228586d91a221d71a933d7121eaf639f58d0"),
			decodeHexString(c, "f7247ff324010fdb00c8ae78e4127dfc6e9f4c2fdec670560d269b9f5e0ba91c"),
		},
		expected: decodeHexString(c, "4158fd28933a76e4b33bded70b1183988c6fd4a7eda1bbe9010c2c65d286c17c4576853d7bc05549e5fab44dd1c139c2483cc1217bcc717091161552e1e7656268f62fe5772a3f20133d89fdeaa6f235fdf6add1f91cccace65ab0e053c1016546addac1659993983f527bd5f99e246ed46fe9bceb669ec80e786c22fd2c0b79b3ea2218bafa09011120491d2eaa61896d80ae856ed5b1d880251fad58e7d0a3643a7c903931d736eed3a91a4af8b1c2eecc3351a3eade3f8d65df762b97f631"),
	})
}

func (s *drbgSuite) TestHashGenerate49_SHA384_9(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "30587705218a4f096c22e07b68b4bc87b59809a11805df1559063684711cdb60"),
		nonce:           decodeHexString(c, "8ce54736359b9ffed924fceea9268a2e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9dad957eb776d28017d624353546c6a83471abf8e7e4a7f0564d4bcadabfd50c"),
			decodeHexString(c, "7aee53efc446c7c50b4fafec9eccea1d74d39dbc43f8a803e963e92dd80b1f55"),
		},
		expected: decodeHexString(c, "227d7243267b50a739cff7eb482e0ca9bad3d51dc6f340ba9babdd1b62bfac3681caa81c50209b7efad8b3dd00d687200b4c8794f0ba484d1a1eb153190e2cc10cf05531aad40ed7407d9dc64b6af32f7effbf09e837cca892e81b9ba2c03b631693005d98dba3db367cdb1b46bc07afa179afad5d6dff705d2d7a6878a998603e91dcc23f634994464292682eb8e06d6089068a0e4c265cbb2fb437eedca92acd3ea823c6c29d37314f126eb9dd54269d9020c7591f6cd53b2108d19c535c9a"),
	})
}

func (s *drbgSuite) TestHashGenerate49_SHA384_10(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d759c8de12fd5e45793bf14603249a9f4d57ccb356e335986528fe46a9c084eb"),
		nonce:           decodeHexString(c, "0f476e3015befa6ea741b15291b62ece"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "14272338e0cf017bd43565a9bd4437e2c9f2881dd99f97d4f9211828aa7e3daa"),
			decodeHexString(c, "dbcf24ed6f4486dcb4c536dec4efc9c2089bf505c935e31763925469a7c6de3f"),
		},
		expected: decodeHexString(c, "c508302eadd6baabd6531f8a51fed008d3a36821bbf19787debaf44327a71bc63694e30cb1dce8b21328ff170e8c902f10f754f827c59f2acd032bbc9a7427e308caeda7ed19375d7171498a7562cb5f9354b0c7b0b67d96c3ff645323b65d6720b52f48adcabc846d16e99f11339b1db6506229efd588e9ddb77df8e3c4c700d2ddbd88c02b9fb1fc9da30ebad6a7566ef8e494dce5036480bda81736dd70cb71945757e3e0a557be25e2c61a091388ee373000f86d20f62bf3f6d73f70baab"),
	})
}

func (s *drbgSuite) TestHashGenerate49_SHA384_11(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a6d633b526904a14a768167eaa43878f3e90c0bcdd8b29f533fc1e022808b550"),
		nonce:           decodeHexString(c, "fee06f56bc7eb905bea1a88b70a70533"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1de361bfa968b6153d6bb4bf74a91fce6170cbf0147c6ab8d8dddb30f585e542"),
			decodeHexString(c, "e3351eda060f18fa13a561b117e95cf6a6c614d8ccd2a75593f1b452ac04cd03"),
		},
		expected: decodeHexString(c, "a02459823e3848982ddc13580f6bb232095d4f1d333c307ea642185ee4b08ec362dde9f091ffbabd16563ab71cb726f5c14357fd28ff82e17121c9ec5bfe652d0abaadfdc04e087e986f0788484e810a3847e3b4583ac6b1c83526dfc2002d3a8a9b3ca40fb032a4e6c0e90f846192107104c01191bf071092f07c98078e916fad6e6167d2abf465e300b555eacb7c0b461e57dc6d28ccad40788ea884104b9c491a086e482dfa9ce635d5a055acd459bbd5541e12f44913fb75548f51c4f179"),
	})
}

func (s *drbgSuite) TestHashGenerate49_SHA384_12(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "e1a0e3963cabc7bc2d060a9fefcd18d4807df4ea44576e509a7407197b2e7d6a"),
		nonce:           decodeHexString(c, "ff3c19e05bba77254c651add6ff6a684"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2bb78f1d58462bb8bca712c6318e45ab0795f50af86032f849b829a1f5589846"),
			decodeHexString(c, "343524b558f80f05f1dde3b56cc0b1480e5eb2be09414d95550b6e6deb87111f"),
		},
		expected: decodeHexString(c, "2dfb951274800f418e9f9ce49eba3158bae66419598e6de45f8c0c7ad9d209a4d9c62b981ad67a89f86d9944845c416aaf097437fee3488e0b270174786985c67075bc11c02ba6631fed1005b291fa468aba902f131558c64516b6b85b3f56dc1835b5939ca194d9e808f30bd4c59502bd7a03609d7d5d52c8e266f25597dda0a73ef3180ac4eaf9ce3d9c95181cde3e7b88b064ff28c423219540eaed1a97dd88a91dae7d9e4419f695155c3da4819e92347559d0744697eb9f711ef83c4e2b"),
	})
}

func (s *drbgSuite) TestHashGenerate49_SHA384_13(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "93e60c6b2f81642e04080231cb60f5a82dda1d2c29abec3d24c16aca31c3e7c5"),
		nonce:           decodeHexString(c, "627e420471fcd82c381e4eeea2b3b15b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "59bce0170d87db5046f4b325f9afe2d4f68a8ca75d724cba772ef8379be25337"),
			decodeHexString(c, "c52e68493a8fd1b206a89728fb35bd37859b1d6a413b35513b07456c7c74e6e5"),
		},
		expected: decodeHexString(c, "f5d662bfbd1ec6e7ebb7c14b628e0aec1b814da4be26d48e5f390f20b0dc3c87b7189c3d8a5a417f3d00f7df891d86c904cbb7090cc02ba034e2e7fc5aa0d264a12e9bf8d9268efef72acedb1dc24ea59e6393f1a249a9f90e70ab94a9d810e92d93c726eaad2d1fb44fc583acdd0f9ad1bc615498451a130bca5e65a43d7da5ca15252587f3b7552b29f9fe4e101923c697fbe8e8a7c697fa00dfa9b701019281252413a8b00c4045ecc3c4bc48074c2603361493ad09c2fdb1aa9c4b500fdb"),
	})
}

func (s *drbgSuite) TestHashGenerate49_SHA384_14(c *C) {
	s.testHashGenerate49_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "0d9baf7e4622d9637d858d5a31d9de2cb23b7b06101f7d881a6278d526495f18"),
		nonce:           decodeHexString(c, "1ba76b79471a3f330931e4e67a066cde"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "25d2ad9eecd3bb8bb60769942abd16edf0ba777f2541a4b0e80fdd70fc2d26c4"),
			decodeHexString(c, "608c5789b5a2a6c11c7df095be8c81968c0bdbc6296026ab65195bdc5a297366"),
		},
		expected: decodeHexString(c, "e1c600294a86393b7067b6e77ca83e68d28a6b76f6f81007183be65a50fd2f1adf6eec5a64cc753c5bd0ebc12387bde8c6ec10e6ec7e603f09d4ae624cc5423b5bd53da4f0af064e14a7d176369f1726fdcf6468ee15ffd7db3be48d196601506c71e2f443a768e03ebc35245d254bb87a392508ab07c95bce84ba81058ca1545289c9d8142aa0858c9cd5ba54ee2bb75cebb5b74e0d099ee458752d11ed70122aed1254609a715ddf2720798c9194ae4a7424e2c518ce7a8277ec79da86263a"),
	})
}

func (s *drbgSuite) testHashGenerate51_SHA384(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHashGenerate51_SHA384_0(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "2e154070573312bc5ea0fa00e589b85dd559797a47c7e5ac731fea50531771a1"),
		nonce:           decodeHexString(c, "8443504d05af55a2c5091f077b1edf22"),
		personalization: decodeHexString(c, "35679c78e75c78bd6eff67b7d62a9fef1fad39a049debd1efb09be9acc62260d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f4bf0561b3e91f0eab5a801388b04b43eee57887d43516a1f332c7c503ab53d6"),
			decodeHexString(c, "77371fdee3485a12e55d5029d70b9536aabbb28ac1ef9ca761633bec9058bc04"),
		},
		expected: decodeHexString(c, "c6a7ee27596c28ed32d6d0a3dc5b7255448c873b2246d2bd5dbecb1a3d32de95ecd780e3e61974a84b374a1c0b32258ef8dd41371c5af762aaec6555fd1359efa5051f24bfdbadf9be8c101198fbf6fa97ef58c1ab2865a913f1b1e08019bb25f0e17ff5f7543cc1fd35e7baa042916d12d29ac6a52202082f4224a45932772dec149a34da4b3912c30903b7681e89e1530c7d8569eef281d165ea99da653df0728c74c809dc4a0ec8b754193ccfef2ab725db8890f84b1aa19bed96ed1c6927"),
	})
}

func (s *drbgSuite) TestHashGenerate51_SHA384_1(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "56aa34e25431cb55b28b35d5d2171dcbf5109948748e69dfa8832987f43b73b9"),
		nonce:           decodeHexString(c, "5336e88c494dfe9674e304e12350ee34"),
		personalization: decodeHexString(c, "f73605cf71020175a225019df4525f7f11d130087a4e19cdda01c80c55928db8"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8f694bf8a86e3dba03cda34dc7bbdfa372d576ac4c6d19c79f8c49e122403a6d"),
			decodeHexString(c, "7f78f38a570313528857ac213f56cf7afa8fb42f282ca57646c1a4764f7ac28c"),
		},
		expected: decodeHexString(c, "50618916906cfed37d51ea1fc6c6f31f8e7c2390bc7fd0f6c55f4421435fe23b81c1f08e401cea7b1c9432cc592bf6161119ef278d4e3f629a76c4c4a5722a0a813c6d47dbadb431299372a38ffe35eb413097fde80a8786b4e875871784f533162335875432451538b0132c4b0dfb557d9aa4d9504c667014aaf0cda557b462b46fdcb6fafc90c01ff4f216630f22976b9ede9f7cfc31e124929571147d842363b5dfe4c3876504178200f48e8cd549abd90520baabda136c3cf76936ac8b8f"),
	})
}

func (s *drbgSuite) TestHashGenerate51_SHA384_2(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9df99ed4bbf654ee42718bfdf5d756b59096275a8407fec46d212c844068d9c2"),
		nonce:           decodeHexString(c, "24f3efba4c5dd500ba7b346071cbd588"),
		personalization: decodeHexString(c, "d8192cd5da58cd2ce7eb2a871fea1bb725c889bd4a0dd2d4ad9871ddd53335e9"),
		additionalInput: [2][]byte{
			decodeHexString(c, "771d33e918623c8519df44680f8357c4c12622cf02c1dd5b00721aa22e4b65b7"),
			decodeHexString(c, "4b8c08f8b829afdfa9fcf3109fab4a0fa3c32f13b3f19fb60c6087f73eee802c"),
		},
		expected: decodeHexString(c, "127a9dd1892b185e9fe850883e9d4e1288c8e3450b27e8ee217de51130046bc86a2c73a72c3f3fb325a85292e844d9d9a9fba380553ee18f451897d6ff898398d1b7223e187864813e117c8bd07b788d6ca3d0a9cad0ce3473d6ffa65612ce0e75dbe5f26484bd7839c80d404dac15bd204e8ab26a3bfdd0c7989e028aab9998c31cbbe238b4681cc6461c6941dfa32bebbbf0869f1f3922f2b1c453a2d0ad8316bc41c9eb5305b7a8fcaa287dd4e6875a248e5969aa84d29fd9ff5ce0477712"),
	})
}

func (s *drbgSuite) TestHashGenerate51_SHA384_3(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "81360c806d49db96f2c53347efe920fda660f47c42a505478374b880181f79ab"),
		nonce:           decodeHexString(c, "f4fcd0443aa830028d028b9a4e1958d2"),
		personalization: decodeHexString(c, "a89a326ef0794e50f751d630da7a20c3462d73fab81b0d59a9a3f93397a367f9"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a29fbb07b42e6ce50b38851b703e61e5852df006859f64a5b80703c519b97513"),
			decodeHexString(c, "1ffd978e3f471d853bad3f20b4e65e50dc33bccfc29c990eb1e19024bf352af0"),
		},
		expected: decodeHexString(c, "9343cbc5f389ee33e2ef49962ea461a3fae44771774e4663ca8aacfc2df341cf3c2de3b7ce9e1820ae0aa3100c0fcc80fd04efd729f87ec0c2835c547906f6605c8653ab8435165601c0bed7d5442bd434d1dfcec9e99bf7a1820cc9ec01372e548fc6d5a11aa4229382ecab6e537792cf8292291f903c1e3f115a837fa15dda971a116989eb6ca049bbe5fdad94e2f4575ac09ee65823b7f659dacfb8d6c1801ec1529961b1774205996ca89be7dd6c8599ad47a09bc2b0e340ad64a6653b39"),
	})
}

func (s *drbgSuite) TestHashGenerate51_SHA384_4(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b438ee94e419abf4a9b26171654b8acf3f023f1902df040e1ff868b3ebec9cf9"),
		nonce:           decodeHexString(c, "a1e665d173905eb64654d3fe4a4a8a39"),
		personalization: decodeHexString(c, "28e523314338cbd3341a69deacd32220ff10ee1693cb4f548c9b58d2366591b8"),
		additionalInput: [2][]byte{
			decodeHexString(c, "781fd50e7ce600e3cc2bbe5e39ee3e625819752de5150d2655500701ebbd3cf0"),
			decodeHexString(c, "3d1fd74618631f5d2ce8a36f92fca951f68dddc7dcbaeb557e15a85c5de19342"),
		},
		expected: decodeHexString(c, "205920cbec20c34acc1d3c7e37c27de9a525d08528be14b3081e2fe5faa8e8ce0b96b3869f967e1c22c1bf66ea29971dec903b26a8ff6f1d72bff095bdc2d44d8964128af4ea8c5a3a45cb82b04e984f2a25160715e5d90b22ca19c06f4299f564263e35fe4d4e0829341c85b70cf8928e09810fd1007af84df5cf719348427b0903de0ebf83a9a0d70b657bfe22dac66abbae44d7012f9ed94a7fa09db9b465898e322c30a91bc428ea2a8a34ef8ee037831fbbf8bfe54cdbd0ba8f469cd0e7"),
	})
}

func (s *drbgSuite) TestHashGenerate51_SHA384_5(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "573791109e5b80f450996f5c043878ce92e6850028759569f80a685c5c36b8ff"),
		nonce:           decodeHexString(c, "69589107861c79db2ce75a44a992fe8e"),
		personalization: decodeHexString(c, "2a5300534308cebfccdf895813e5abda83d744f98f14a89fb98c0e5d72132167"),
		additionalInput: [2][]byte{
			decodeHexString(c, "3b7f239900f508fce28dabd192aaae0c1c0c24b44f392cd562636d54c569d5ff"),
			decodeHexString(c, "62860d4da851a1049c3b5765e0e69febbcc43b4cd70c91cade3ab85f17df608f"),
		},
		expected: decodeHexString(c, "81ba3e144d8b6fc7c451cbde078a59b5d8a467bc37db6b9426568a58fffd7abf87d574921519c8600fae27ef8b76a15b8ddcb5e97a828e1063c317646e463ed37fd1057ad0b395c4d9e6f3d3dcabaf9fa78826df6f906a88d85bd6f2a87879dd2351cab1abf1d5978c713751a0c2223177a1f8ca255297c71126c9ec81aaac49034499b6acd230385c944aaab76dcf58d76d602c1d5ce5fd96d6d8c332140eb7d764e5345fe95d40186b15a0e1bf1af89b396f56b571a19b988fbfcc61f764e6"),
	})
}

func (s *drbgSuite) TestHashGenerate51_SHA384_6(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5082ac80cd3af3ccaaed9d107162fe84454519d4bce78cf34af410ebfee2ef3f"),
		nonce:           decodeHexString(c, "36b63e1c771cd2e5af376eb2161fd374"),
		personalization: decodeHexString(c, "2f094d73456b3831f8b87a4da447996131fc8e1dfc57177badbd2dd6ccfbb3a7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a243f0204f0a8856967d59fb345598b63bf04eaddb1d11ef37d1241562f6933d"),
			decodeHexString(c, "3080f43610f9d3543cd7326b23b5a156406eada28ba975e534d39f89b9d70478"),
		},
		expected: decodeHexString(c, "2fd543b2dbd38cec3507c18f07515d07d67be9c0b52fe5b5710ff3d7e7be8fb79386c93cc0030847e813ab7ee8c7c3d95228bf903f6fbfd8efd428bb84b2d1f4ee038ec208c2474a63b3ab9f26afd11d5b10cfe8e6ee1abd43329aae940668c680953842b4943a69e4271ebc991575058178cc137c3035d1211d815859781b5065b8687c4ff0430c40dacedf7777d4433a6bebd3ddb6ee3967511186fa108fdad428d98274388babfea5c44d241c7a2acb9aadc5cafbbcc9a302d76bd86d6c14"),
	})
}

func (s *drbgSuite) TestHashGenerate51_SHA384_7(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1be0d9f203502eeec2ba0eab43afa0772c08538a27f25a1072c522e7cd5924c9"),
		nonce:           decodeHexString(c, "b5cb88da2dd02fac6019532608e078b0"),
		personalization: decodeHexString(c, "4ed471e5ca7930e9d5bfe3260a3090183c87fbd083c81c85b27912039d8177e7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "42cf078e22f1bd0096c9f246e8cd2208a3175d2ff95b478691c05d97b2793a29"),
			decodeHexString(c, "7fa2610dfe9cc13ebf33b05e8131ed132f4f461885d141848f5c5cb0f3182296"),
		},
		expected: decodeHexString(c, "e4e9363ac7bc2d89459b9b396fbe5a76ec1718b7492932163d37cf343ed6e76dd36ecc24c18e061ad66a20c7b701ecbe5ae2786944887aeeba344768caeff8c913c8100d5bec0ac28d6c820bcab2727c4981d8214896ec8656642db09968b26a465c283bd68f592fcbc76b9cf25d5df57fb050a7e13ffced7354abb9c9807fe9955894b2200f97aa9aae645ae16f4e971efba4302157b073ffc2f127027e0fe8e7f9e7bf3f141fad60a1b23a584b8315eea13242f27f8727aed8c48b90de8278"),
	})
}

func (s *drbgSuite) TestHashGenerate51_SHA384_8(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1bd9b187964cffe0655f1eaf6fcc324b5d14a33411a82f2c3140c68efcec5451"),
		nonce:           decodeHexString(c, "29c20377bb7d252c690dec0c909a054d"),
		personalization: decodeHexString(c, "bbf4bab9dc99aec01423f0bdb5d166e34fed5aafa78ebc5b1b8d4b4f994ba169"),
		additionalInput: [2][]byte{
			decodeHexString(c, "77db5cbf6576699ffe42e4eb5ec799acdf9bfdd9232aaf8819c2832b2aa0add9"),
			decodeHexString(c, "23be6002c22f6f0b8d0a4f0c0f36b939e7d4cfdcfb68ce5ec8f2b929c32a85cd"),
		},
		expected: decodeHexString(c, "59e5c468ce27d689f56d99f528765b38932706d0c858ed9efc4d4e4d4e159ea42b230b5537d39723c3b650b15afc20d80eec152b3911dde83bd2da7cf806415b7ead8b7d39573e07fa6c41a60c9f2ece70e71da8e0b8e88ebf951bf04f058973739360f0b56f9a723dc72a36efef2efa5cc2d2cbbf1d5839b8a64569132ec41cfd6eb10508e6e32eda400141b966008e4badca0db252ebbb8da0074ba27b01166e2d79b96ec20b117d2e25115b4ae90ab2fa6af6cd16cd880a2c35e308790e46"),
	})
}

func (s *drbgSuite) TestHashGenerate51_SHA384_9(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "658b37da967f57c093f07ef201b433b5606204e6cb12b843a1f30f2495357b7e"),
		nonce:           decodeHexString(c, "0bf0d51ab3318fd208609ff11036ee6a"),
		personalization: decodeHexString(c, "ecab60ddd0c61d2579c2fff0f67aca10d3cc45cffdc256134a504b668c2ff81f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ff38fa79a7a410a992388b6b94c37bffb6349362bbe399467f1774b2e81fc176"),
			decodeHexString(c, "d5d4a4491ca00893f1d4a8d3ef3067de4b5299c68bdcc9eda341804801157a9f"),
		},
		expected: decodeHexString(c, "ca0343e7b1924562c56fddc5c29d126017a7213f6d8fc30c5fa97a4672187425f1639660da96f29d0c33ecce1735b95eaeedb54219fc1ca028d31fde7c1cd40bf88dc41ec6a549dc0c08d86d2ac553ecc9f3c6aa1a1b8e4f1313197c14bdb33e53b6fdb4301171520021dc2c9818f4388ee5cb82ce1e4de847ee7ba263bdf78d8d9ee7a55f301b2277ab846bba7897dfd632d17125edad4329d52b0d6bcad53c654aa2424601c604be69dca7f6c8585ad56c9c3c35ccb2e015022b7c11b63e72"),
	})
}

func (s *drbgSuite) TestHashGenerate51_SHA384_10(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6e40520c653ac0b72294ff90e30bc026f5e0e5e322a33820177d3834697d8803"),
		nonce:           decodeHexString(c, "4b18ee04649d5134fa426a5bb453053a"),
		personalization: decodeHexString(c, "dad9b3448fab084661daf4a775dec7c3b4199fcab85108056d862e4d0b04e955"),
		additionalInput: [2][]byte{
			decodeHexString(c, "c56b5f7cbc33cdd88969b6146e0feade007b22eefcc6dc63ac60b7ea3770e6b0"),
			decodeHexString(c, "966836832a93c8ad45cf032d525a6706bdd7c48715948ae0055672b885e34bed"),
		},
		expected: decodeHexString(c, "d9a4a53b5be1838297f8ad604dd18cb660ee1b724d1e7a4ab3ba4b1d669cbe02f1d55b6623d9116499e4a64d3ce40eac2ef009f60df52eacd5c5b9378b4191d92b4f9efdbfaf14033fded7efc64ba7418791e86b76c56ce768f041f9cbaea360584631dd72a453cf79ce07f72478bc51bb7024e6b60610076928d4c992ec073420e7ec6a3dc7436a27ceb3bd981cb176b4b77888070cd203227a459c97ebf79b514be290cc8f174d7d62041a3b602fdf86c8c45160dcfe661713104a12a0a43a"),
	})
}

func (s *drbgSuite) TestHashGenerate51_SHA384_11(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "09244932ecc3befaaf0bbd5c5997419ce657b15870778508a8f8ae8b73bde52e"),
		nonce:           decodeHexString(c, "9157244f767efd95f6a3359eee1291e0"),
		personalization: decodeHexString(c, "db358320a8fbe8f021e8b1d6e7538c31ca0a8b1d82405b800f92fe17c08877a5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a17ea8d6bf91d97e590578e20223a130b3b2fcbebb85d4cc3325da882c009ff8"),
			decodeHexString(c, "ed9670361a39daf1163f8dba4f47d07ed5dd77e341901994b829814942a0c04a"),
		},
		expected: decodeHexString(c, "e89fb75235c0528a58429a00a56ab0d9e072a8b909d35c01ecb2c37ee0f969d4edd3d6ef009ec0e56aa3922ad615e28bd1c2217d16d7e50742af212b99a7909d9249df4d822d0489ed2115c3b8c44087b85f848fb0b62de4e53ea81e12c8f4afeb2c503f6d7816c594f00263cbf83f98ca0677e1ad99d93e57433f0e774ce1bdf4bdd41bfde44614d1f9eb7f42bd125470b3f9c8b0a498a65dfd0d076ced8ff6c3a2ff412076ca3392d94d250cbedc849af19e450ca4aa07beb8a9d14c47153a"),
	})
}

func (s *drbgSuite) TestHashGenerate51_SHA384_12(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d0379fa4eeae6c42e1f88627c96814df67257676734a8bbdafa90102a36a7893"),
		nonce:           decodeHexString(c, "3bdabed423e71d7667c08c699bc13e73"),
		personalization: decodeHexString(c, "3d4059d31c5fb99017cd60bb7cc33e012eb78b854667c3099e82034455a25e49"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0ef949be1899fafa522942480321712450546354ea74fe7a2aa711846a3dc9ec"),
			decodeHexString(c, "c0012dc814f413de90a2963cffaaf8a15443ea21f539af12b0970277c6c906cc"),
		},
		expected: decodeHexString(c, "4491950b4b0cd996aa6be99c7516b7ce2b1261d7603b8b0fbe18607c5aec09f957884ae5f31da8eff1d19c4d7a22e2e3f02649e69464e788e898b4345d8e9c2ae3a1441cdbe678034dbc2a6254b4a01edf0563275db80feb638e05c2cb7374af732ca6ec426f1e5bc7fb73611a42321c5d811958e2ad75ee8bb49588af35991c646396f8d322525a354728a1b93dccb507fe6fc68fd2e35660ca18faad7e30e8878b019830a05dd3b8fb3ac7da288fae8343fcf22593a10146f91a55e6d8c9f3"),
	})
}

func (s *drbgSuite) TestHashGenerate51_SHA384_13(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "2636f178a386017608f098c7fd3d8baa39c7174bc566bf9d5424abfe5e50332f"),
		nonce:           decodeHexString(c, "0db8ea2daa6d04fc79778832f414a860"),
		personalization: decodeHexString(c, "a97e80d4eb0facc482498bc0af7159a39c00eb0bb59bab969f109277a0173936"),
		additionalInput: [2][]byte{
			decodeHexString(c, "718c2b3a8b8ec53bd2d3a7693e110ef86881270c96635b3946e7b2794da96251"),
			decodeHexString(c, "94a197e66302e871d2fcc5ef3a9e4c1118dcdf1f12de3d3ae22cc8f1749cb286"),
		},
		expected: decodeHexString(c, "6976bb84ceda5248cb5702cb9c6c0d3706b7961e9932ca37646ea3fde76e8eec760ca17c89c640f1956ae9b7d06357a2c2fee21dda0592215a0060832e99f5593f8e30b47719673fcf870a2f5c09dd034bc890795905266221b85dc17e54a2e06be6af322e9017198a6bfedcae3924d140001036f3020c04a0799c4599c76b83a6ad6fa110d2d4b6c4d64d57aa9dbd55811dc531f65f21f331bd51d7f3508df1095db9ac9aa2d84deb97566748064ffec59b9eb89716369fa56255474359aacb"),
	})
}

func (s *drbgSuite) TestHashGenerate51_SHA384_14(c *C) {
	s.testHashGenerate51_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "fb1a0b4091757e86f201ca94aaee4dc80c8d1f0653b8f94c6375d4d3e5ef16f8"),
		nonce:           decodeHexString(c, "717570cb86547c1b5c0b719ad04a1aab"),
		personalization: decodeHexString(c, "5793999a1a395eb5acc1bb16c1259cef3244f584a98129709a4e9c5bcee9001c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0d81d8c5af9885d1b30d2174429bcc6979bdb2b82e6fd3ccdfe93f36fabf45e3"),
			decodeHexString(c, "c63866629ed771e53d2fe2d5c21e98ebde295c3fc3896fb67279427c61a89eb7"),
		},
		expected: decodeHexString(c, "b369b226dd535dbdab45ff8f13735214f9abe6d11463a44804b838d2932112ce6799341505b7b5bab423a3794c37f383b06be1fe21f5c7da97b333a41fb67908dbeeb2450a3581ef71870c964c976f039ee856fa507e9de948c4c097a64070b23cfa09ab7506a8ec4fc38a38ce21fbee3f3c1ef3ab598f5da202f35b90f422af31688402509c38ac25359409d2b61958390d28ca2d8b5dea99ae26c90978f01d7a482c12e134a81de0bf6c9f39e32a8b597ec7b7a05a805ebc7ce260c381f189"),
	})
}

func (s *drbgSuite) testHashGenerate53_SHA384(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHashGenerate53_SHA384_0(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9c92ab8084ce412bd4a5c763b5f4c3365ad5bfbe1c8092fb6da3c8652393882b"),
		nonce:           decodeHexString(c, "d2195e1f57c899b67a6fe60b8b44fde0"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2c554956d68cdf327f9dfa3fc4485e552077f9ef24a69dcd009e4769ad4716e9"),
			decodeHexString(c, "65ca4e0b75c823f13985f0f9b5a5b4958e6462326c05e2187a09575d71c3606e"),
		},
		expected: decodeHexString(c, "4e909782c00a98ac54089005d1c097bb63ea3ac1fb496a21b6a3cbaf671dbf382d30d3f9d764c84f5cb727ff822e75c555937cab416e9777f53e9d2e70312d007aacfb23b562129d3a1d813192bd39987722c21fa4183494edde0c35ab30f0e0f606afb51f8920f7885641ff61f87c3ca0bd972a37726cebdde6006869955ca84042a69b7091672d6ff7c413819c50d8ae1bb3936723a0a84ec48886739acc7e05885290ba8fa966fb120bc8b5cff0d6fa672bf561c093102de085dd8856f290"),
	})
}

func (s *drbgSuite) TestHashGenerate53_SHA384_1(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "419688851d8975ff61be12acc0e4f1b40b63b8b925948196444b49a50020b24d"),
		nonce:           decodeHexString(c, "423b885d9c19a5ea9485e8ae21107eb3"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2dfb5083605f674b39ea91089dc5a94bf44d9510e31fa1e75de253049cc7f48a"),
			decodeHexString(c, "f50a59deb68db0f9c1d230558ff4f8e9619c92d56803c63de90ffcf3e6a094b3"),
		},
		expected: decodeHexString(c, "f85fb91e6827ded04a080ff6b198350d0b3e173bb05f6975ceeffe2fcce9ca7fd02022bfbbaa904ea3f23c15723018a3d31804768c87fea70f68ff7869b127ba231667dd304b8ce15984f47c37fc45b1ea17e634f76e4382fb0d5b49b4b4cdb64602df4c1e91b063728da6efd3b056a40ec2d0cbfecb21068a86d02dbc7fe4bc000050dc3702d7cbb4c7544608194047dbcd3ad076dc48b921b633df641c658f2fd14ffac65f28b20cc1755330948eb47d59a5b1c6b43f167846ac191cfd2e18"),
	})
}

func (s *drbgSuite) TestHashGenerate53_SHA384_2(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "056e4326d5e8238d2ca40396a987107cccf6d2e178b93e03387114caea9729b2"),
		nonce:           decodeHexString(c, "d674aca5cb260a52570ba1456e3e67ad"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c65f0703585665f9d911130fbb4e2007d089cfee3b349704306e16fc62f396e9"),
			decodeHexString(c, "1c29bd4ac2e279bb09826a8fa1170538ff6335587d7d13744841722b21af28b0"),
		},
		expected: decodeHexString(c, "23de91bf8195e5dcab43dc75ed4c30f8742a391b3abf1a00cec0752e9d92b70645b0c9998ff4b4a0f087fdced4daf48005e25b897b2e730d5191163faee672b31418b40bc99d84b688dbdb076e23983ecda347940ec877e8930620998416204c691cc65a46e879f3183505cb65e486f4a5a8f244bbac42f3ae4dc705fd1255e2fca12cc3050d1156a13f036e49dea77b6b9888e200d9276cd0b4267ef583144dbace60dd02ca139522ca13d75217fa9e1f041cc57e5eb05c82edfc4b8444267e"),
	})
}

func (s *drbgSuite) TestHashGenerate53_SHA384_3(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "62434fe9c36ed3a7d5cbd3c01c019575da3013eca715ff2e371628672231e816"),
		nonce:           decodeHexString(c, "e7ce6dac29c8ec7021c076c7c81de966"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "46266c8a159c53c69cdf84d6fe725ba29a9039020625cb2e6b03f1e660082de5"),
			decodeHexString(c, "936116f23970e8874424bc3f4d88ef2c16b165decfd814320dbacd10babdfddc"),
		},
		expected: decodeHexString(c, "a21fb58d30926ae8f8f61639528bc0bd8e6ece00d031692c4f5c7cd31556d4854efd278260268fdd27e610579c01a28777ce183eb855b4e0ffdb59c6b4e5d223d5cfa3e48c6ec64a0c6f415544f3191f59d7f171237e75604e65a0c9b5a3341252da3067a85626170aaed23a5596a7391ffae4f9c3cd9ea8b8fb2097223ed225d8d5b335ed016341a53ff31e727d0015a7f2e76b7d6cd4600eff8bc4c6a40c6452ff336c229528f494686f0cd53a8d08d0ebfb482f730b600ead59000e57d65e"),
	})
}

func (s *drbgSuite) TestHashGenerate53_SHA384_4(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a70a1c62ea656d332ae88954662a8f3598f92ef2b2ead334feed6923d6423940"),
		nonce:           decodeHexString(c, "df356a7da8e81dae6dd97ded66487c7f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ee9778138589f49fbc301d2bd04bbc5cf16edcc58ea6520cc83cfb1cecfebcb8"),
			decodeHexString(c, "1623dfe328ab24b9fc11b6fbc47ba1f41a65b3ae9c1920279f557adb63f2da49"),
		},
		expected: decodeHexString(c, "1535f4f76ca442d06f883b4c57a64d92662833cc74dc6bca95cdc6958b7632c2b19400c8c9baf27571f346a0021abb3232aed0bb018eeaa2d8803b84c1a3f3957727b04cb9eb988365521fd8aae14bb2ba797be1dfe5a3a0a57bd610785a9a14954e86fed25a354dee0a77e6b9f6ee35be27b66a45236c33cae6101086e593b6b44b44f79881fd674e4ddb638455855b2ca9096ad13d288f02797f1a2ceadaa1760d99d2d348fb6c77a3a0ab26e865f7a25a691d2171bec0f9554cf08cb10cc1"),
	})
}

func (s *drbgSuite) TestHashGenerate53_SHA384_5(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b9e8a6f7ebaba074850bc8b75f4ba991956a1c7ffef4d9233c47f3a984cf6e08"),
		nonce:           decodeHexString(c, "dd3085a721fbf3a59b49885decccadd1"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "41b3f7a531fddda2e3e9b46fefc1f8ef0cc5e2a7eb3330f70c51369379f537fe"),
			decodeHexString(c, "c7db86a2de326f8476ae906be92f13783d238a4bd81f7e460ebb92df925d7de6"),
		},
		expected: decodeHexString(c, "639390ee12a46e9ee8f520a4a74ec0a2dfdca9d6250186c49efcb58f6aa9174189fe73bd222162529036a7c612ff7d8afc755359d65bf420d191758c4f0ce6728c4748ab703413ab70145d2fcbace4b1a5783d46a9a9c51dfc172127f668102e3695d5861b76fed157529d6948345ece071d8dd32cdd66805edf15cc7f8a03fab38811deaadf5010f75e73cfb3cb80972d1d0c557419f489b3331ba413cf0bca9c84132fe0a06692d7f54006926457535fecae9ee7d4d1851526cd87c342fe8d"),
	})
}

func (s *drbgSuite) TestHashGenerate53_SHA384_6(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "0e72fae2c0d72c2ffde1f047e4e3c751582301e621b941ae6b1729d3e10367d4"),
		nonce:           decodeHexString(c, "a47f175a22a9dd5c9324e0b2c3359a14"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d2ec23eebd97f62245f237a8d46ccb8346482ecfb8d20ddba22abbafb1cdae1a"),
			decodeHexString(c, "2d4b97d1109d273d3917f237dcce2e68a7a047e9f163a0cdf02d35c61bd86d35"),
		},
		expected: decodeHexString(c, "b63966464df830fb1420ca5a3eae048f7cf6f47b1f7181b16adca2bc6cd27a2b50e900ae4c9d8b5f6f6d2a76080a02303149329acb3f1c15c3e236c9d5fdbc3026bcb1353e3d32d91950b87144845d526dcf93248cf9080aa4fd89aaf500f8603bf52317d56ea773693c64ad840fd8d7915a26c507dc72cfce822a42030514ab7921814a404df9086363ba353bc2b1270b40540178771693b710718b5e8980f224bb0c94c79d5914b43a404da064b8687cd9fa517f9d634b148c776598b483e6"),
	})
}

func (s *drbgSuite) TestHashGenerate53_SHA384_7(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9c9ae156bdf2c5e0191559f71c2075aa13ddf830da77b9ed823a00b105c4a769"),
		nonce:           decodeHexString(c, "98f7ec8ec236d76b01beca6d2367dd55"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c04fcd4fc4ffec31fa410682efb6ac2bf3011faa86dd80fb8edc88725dcbf30a"),
			decodeHexString(c, "ce614aa457287fdeecfaed756b937f59aaa312e7a3d730c8c2f122749db4a7bd"),
		},
		expected: decodeHexString(c, "a4c71c976aefbef24763d712460917f4ffb39d5df4cd1e062eb25a91e332c4ab32f77527262a8708e55ddd40be624dedba49205206412d9b1a5f2ab4ab64dd33dff2135ec27b1f5dc877835f777183e0573fdbb8efb99c437e9b022dc9304dd937cfd368ca5cee9cce373c19acdbf5ac594da8fe2c5b6f5346ee58d81897b3cb430687b6d1fb01911a47f4de60eaf71568f80eea983a1a4fce2c2324a1d417d5439e752ecda1a309a1a7c97c0c41a8384f412b7cbae5d61dae9b94192eca5029"),
	})
}

func (s *drbgSuite) TestHashGenerate53_SHA384_8(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a8e3298143a6a06b5be4f7e30ff40ff51f65af40d575082e0342d0aa0393f55f"),
		nonce:           decodeHexString(c, "93c445374a3d7e3e65dc28deab89ca46"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2c6bd3beb51734118e7633d0da17146a00c408ed678a23fc39f98320800a4470"),
			decodeHexString(c, "8a9fdaa38777f31a65791fc3b0787394538eb04640d4467a4ebdd517b129be0e"),
		},
		expected: decodeHexString(c, "4a1ecb32c35f71c2c7c9438e232a11a353f1e674e4c589855c04f0006cced932d61cb696e864be0d12b2e7f3bef0e9caec18fd27e4a7d0dce9b4aa81d084a4cee2985c415d2619834c724a6bbaf4ad3337907cf37fc37d221a0987861fad588a3c11a7a962466aaf4093c7a828a5a2897afd7b0c2f2c7237c952caa95e33ad6d70f793549674168b675db9440c8af702023d0fa2e4c15a75bbaa1ac0168888792d8af4d458e2f5227d46bacfc8a56ff31fdca36e4004948ae422759d5d69268c"),
	})
}

func (s *drbgSuite) TestHashGenerate53_SHA384_9(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "da0521494a14b82937012cf47bcc0735cfcf42147bf3907d8e4dbe23dbe470b1"),
		nonce:           decodeHexString(c, "41eff6b9b0c2312422063c1418830754"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d88235ecdea2d0c8ddc0adbd60cb7706378d05ae69fbf2d25b576136f427360a"),
			decodeHexString(c, "28d7c1a7e7bee1b49b268e4c67bed13cab26fbcdf10f54eca239c15ef195d9c7"),
		},
		expected: decodeHexString(c, "401500b8a9a85a812e45ad14494dc0d4756bad54ba0ce6e77a72db21cdedd64a121867e833e3c2a21501cc9d695d73ac478fb880fd600c227feb08d77daa40ce0f78a5f7f6bb008d3810fb3e5a00c30031e5a26995754e25b6889a66625379890937d5f1b3d1476f9ce436e84f905954392de14f919099e13018530d8eb5eef2ca78f35a9138974bdf761fa6c19435cf27a6994da80577474896d1b975d23ac231bc4fb0e26dc9b1a83856eac5cf1fe9d4400b6d3ab99c99c737e5b7b3910126"),
	})
}

func (s *drbgSuite) TestHashGenerate53_SHA384_10(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "4ef0eb84fde6b6437e3a56352b978377608810840393fc68a1eb9eb75d58ecf5"),
		nonce:           decodeHexString(c, "b87c5f8289ec92b6e2a2b5356b47df19"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "36fa25cc7b32dfd23d578c7d47fc495df20e7304fa839d2c4b0bd8bf7a022059"),
			decodeHexString(c, "d72b7e5876809766048542869e47c6efa6d1e4c43665677281a0842569eec754"),
		},
		expected: decodeHexString(c, "d502bc88cd8b862dcbe940d15125883657e1e5ebba4a16ad4090cf5183371dcb1ac2fad5f5ad1e347b90565c073925ac70c088cfaedbb8f1ad08027c9a08ce5a939a2b8368d8b75c2f0a7b32fdfc2b3ba13207bf558dddbba1a2769075946a44181e38e0796bf0e8c0ddf40037294a3ae331e412ffa2dd3f7971a7314aa8e3006245f7dcd3342da8292453b03af3f3f9d1fbad1959815e227e39a1ebf7d2828437d61f4173dbe19fa48a7d6df0c204ab18010fea46269c1896672627a85d11a9"),
	})
}

func (s *drbgSuite) TestHashGenerate53_SHA384_11(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3da7692320d19bc3ae58ae5f26e0d9beeca3e15003d55ad02762d5135b6e5fc4"),
		nonce:           decodeHexString(c, "58781992a8b9147c48a1d2fb3b5a6d53"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9231ae680ae9320b5edd550993c0a6ae47c684b4546059f484005027a512a6a4"),
			decodeHexString(c, "9eb5b5dd0847ccb1e996317a22a9a607f8339d073bcf6c2e967b49ffe2e01bed"),
		},
		expected: decodeHexString(c, "1d8bbcb653e61bf2ea1601f4cde346fce963977f38477d74a4b4887fd0684ad1f7babc8fd15e197c5c77d0de545838313adbc03e91f9553b3dc1e124115cc31f3700ee2f94975d19ade55952480c6b29aee2f38555cf9dc87782f915b1f4e4b7318269a88bcaffd1e987c711bf7187fb2df85d4ae4648846ca4fbab420b04739c6a1e56af022ef830f21044c95ec76d6e70fb2e0581d47c3f5ccbde05fc0b9b631e338b3bc846c4ca0dbf0d39f88372c1788bff8df035a2e296edd17b53f45ea"),
	})
}

func (s *drbgSuite) TestHashGenerate53_SHA384_12(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f52fd8a98c584e12d5542f9b693ba547cd03ace419a57d296e199608977851dd"),
		nonce:           decodeHexString(c, "fa974668497f72f265d8b3f6d571bec8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "ddda31a89347f7ec8bc10a4635e803580a7e88baa32fbfffdadfb0f731bb3f45"),
			decodeHexString(c, "b46ede7d4885ef59856752767fe4fdcba935d1af82237a526697f02ba6f0bc43"),
		},
		expected: decodeHexString(c, "01b9d2abee6c4213e3774925b0596e44838f3edce85b2c68309637012018c1a9ce1138e5f298cd0a249be681bb5677b667c0989f9aa165db4992cea51dd349de340d95aabd49071bf18e5df3855e7416beaa07803b9007d91ca44776feaa27b3afa6869e9ba7be9ff3de136ce60b93dd0bb3ff15d5b1cee6b751014bcd8bf335e7e6ec4cae6d2811861fb07998c124ade2cfe2716548f392a8366476ff991c631f6460e41d8fc91a36f5193187df3920f0469b2f24f054e397ce0bf4547a327d"),
	})
}

func (s *drbgSuite) TestHashGenerate53_SHA384_13(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "2f703d506f0223a0773b3a7ca5b46619e86ba8a026a7666e60897e28c1d978a4"),
		nonce:           decodeHexString(c, "5f350c592f781cf7063fb68db563c3e6"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "76c2a197fcdc3ef743028e91aa94c2dd7ce934d0ffef1fd344a82f4e6408a91a"),
			decodeHexString(c, "2ce9c93b579b9a5c4aee0997416a580e8e8bfd5b8c7347c23de454f5ae2f7b74"),
		},
		expected: decodeHexString(c, "369e9f330bea22ec0927e12f74a3c94c87083ad3a69df792851497900b5bca3a9a20ac2ae64c35e7ccf90f707e767370b46636652603f8410fe8ce3496d6cd3240e73130f3df59cc6121389dde78d7c71ea85ff898521d52b21585661b808b70532494d27d9c39daeda64979c6383c31c40cacb9931faa4570258c15a7fd2bf72453175f798b8b2c765f2771a045fb5da3d1f702d627a3f708f5755753a320e5d1b0c00a61341c7ac50f55c5988103092f4a2a6f90c555874c77d4589b1dee93"),
	})
}

func (s *drbgSuite) TestHashGenerate53_SHA384_14(c *C) {
	s.testHashGenerate53_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "222b09b67be3cf48846336aaa0e76c8587edbb0cdc5123fb9319924e452d49c8"),
		nonce:           decodeHexString(c, "1dc18a8c2637c16759c67bdff0600365"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "80bb70930ef2015949b53d787630f5de93d93f98c577ca4632266e1bb1f6f33e"),
			decodeHexString(c, "b6afd2c00be2eaed5c1991909e89029db0b04598115fae5118cc215298e0528b"),
		},
		expected: decodeHexString(c, "c20bd78d9c396fc8fb408361e1dd4827ed3231617a73cd8848e493927207ea23e6efecd4fae36aff74b5235067543c7eb44c290122f9167a0ec4c6a530ecb0936fd683fbd866b73afb712b2f20ccc981b3f70faec4f4fda62e956c7d04cf578b06259b0f3c044e6dc68baf91e6149efa70b2ad2b81c8e14d1a994887193e53bdb5986a23d0412e989c447689a71b283934e50c25e10bdef0b22ce7368840cf761e32aebc07d7b51da16dad4c332926a4cc9853ac8db36b4b01bb36746a28f527"),
	})
}

func (s *drbgSuite) testHashGenerate55_SHA384(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHashGenerate55_SHA384_0(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a5825e0855cfcd4221837b493718a380740d53a21870837671664196ccc54d9e"),
		nonce:           decodeHexString(c, "361d804f9865631a0c929edaf560eba0"),
		personalization: decodeHexString(c, "c337212fd68d23d15415bff96d8e8fbb4dc9b79b5044c213f513f6917487d772"),
		additionalInput: [2][]byte{
			decodeHexString(c, "5987f21b584c2107b445f06be605eb00d62acc379f7f24ec55b65c5467aedb19"),
			decodeHexString(c, "74132b412a58461aa41e2db743daeb6d809b0043fbfde801815aa2984a47b59c"),
		},
		expected: decodeHexString(c, "a1876c53450ea07a97d260ef23f3520baba8b6942535db0ace5f2538c0c2418403c50d1f5fb10b9757a7e7ad7344b5e564be357271c007bb03b6964a891e29fdf17b7520e905804272dc3a692adc20136cebe7e14cce28c39bf509267bb4ecb8c036c3413acf0ce7aa4c2b0955825a00afa1ee6ea655d1cf5acccb66f52eb643b117e3c92feca13e190c517987074dd4464e44b3156383e6481ed743634c6eceefc336212b9d52e67af8dc60bab9feedd57a27c5eb97835bc9a3690801aa8c7f"),
	})
}

func (s *drbgSuite) TestHashGenerate55_SHA384_1(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6fe04ac2198c0a2c386b0beb4030b3037dad41fa62f88a8428aa94f7c83e9df9"),
		nonce:           decodeHexString(c, "2eca61bd42ccdc2b9673b093cb9cd4c5"),
		personalization: decodeHexString(c, "a4d77e5d47af90366d947ec0bb67768ea4e868979045b68702842077e21d1c20"),
		additionalInput: [2][]byte{
			decodeHexString(c, "054e9f11cbd49e916fd7e6a14534aee0c456dc97ec0043e4cbec9626a381ccff"),
			decodeHexString(c, "6a3ad6f6716a302677f597e790778421bac683cee0b840b2e9a0d86c2e326a67"),
		},
		expected: decodeHexString(c, "4daf3f82f38a9ec3f2bf8a471da37aabe2a7d27c0bab3de118d66b1c1c8e137d0258aaad8ea36031de8c16cba7829544e8268a0674696a0a56262a05d0ef5ebce44b31ab6f234334e3aa20984696aaf37aeed7650677ca5a46727b73867be491619f55614af2a47a6b7e7faa3f57cf04b757a43319c59c0784f0a069131d962d6a155a8f69fe4dee911cc130a2a9d67db554b5789fd7ca66a71963c091242f44b402f80d9e8f0b6cc47620e9f1898ecd87bfa80dcbb31ee225229231a57bebb0"),
	})
}

func (s *drbgSuite) TestHashGenerate55_SHA384_2(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c85ae79239ea7f32597ca927dd42a9d992016828464a5df8318f7ced398c0a48"),
		nonce:           decodeHexString(c, "c384b12989ab5a7dad84e73085dac1ff"),
		personalization: decodeHexString(c, "06bc07e3728ec33aa92c2904fa89e4465aeffb4717fccf36eba7920cd1c73fe8"),
		additionalInput: [2][]byte{
			decodeHexString(c, "78f8a518a5657e9816b9befe8f216ed47152bb9eecb5cc36042314c0504a5fe7"),
			decodeHexString(c, "6e4f0c9be8d4da198dbafe8abdb5d2bb5097d5ccbb697a7d1a668cde0890e155"),
		},
		expected: decodeHexString(c, "c02e1eaa1bb6fbad9c6ad2d7661dbba8600fc8d403e80b0542b22e499ce055bc7453ff11050b0320be3d0852020c95fe80538918a4b4d6871a6f159bfdfa671d2a3739eebf8fcd68cd2997f0de63fa8c9ce89fe663e2195b1d19340a9429fd4936a2289ad97ce1bd83bc95978aa4a5bf2720fd91568269659e43d8bc88e10d5b806968eb0bcc33570d4396881e59ed92c3c07f4765515d77ddacb6003cca95731b27dd5c48ddaa346a0cc313154f2d42dfa62d9ec65d8d5c9005cde2d0ae02fc"),
	})
}

func (s *drbgSuite) TestHashGenerate55_SHA384_3(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "e3f2f42dd8e41d8f252b3e77c3fe7025b48b416f49f634df469850f22c4aacdc"),
		nonce:           decodeHexString(c, "ab60bfc89badfcc16ad53f991d2b3b54"),
		personalization: decodeHexString(c, "008b552e005c78568f8b865f3857b0b37f8f28a7fe277ff63dd64c5d44f376cf"),
		additionalInput: [2][]byte{
			decodeHexString(c, "cb634698375959c4fca74026ee8606d76051c1903579acb3bb28772db7d289a5"),
			decodeHexString(c, "fa7f8bd37a442c09b7ac8256aea83bb88b05fe288e1655e79b2f56541738b639"),
		},
		expected: decodeHexString(c, "2d301f5701673f080ba68fbe3da99a389efc9d6e4aa3995825a3f2f7cfcd24164c6a2db4cf507531577dbd8ef6618321f8bbebacdfb6da028dac51965bd10d0eddcdc7f34e0e03695a2e24ef852800fbf7085ba6d8d605e88659e3dc7e9944c712a4713cbac6d35b03965eb2a4890ff3e01bc6cbf625049aa139f042abdc50b17a187bf3bc23d40756a7e017fc875db1532e2e8c20d5e895f2a7e36c066e4f1fdfeb62a5eb00eb2ef06561cc97ad6eeabe5b536a314eb369fb4ff702939e0d10"),
	})
}

func (s *drbgSuite) TestHashGenerate55_SHA384_4(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "c2bb31d49db727c52800d589bbebd2ed6a9279034fe573defe4a3fc8181c6ba5"),
		nonce:           decodeHexString(c, "d3f1992a0c9f2c9000ab8866b59fa28c"),
		personalization: decodeHexString(c, "3fb63ef00ad27975477091c18afebcef0fd815eed6387acdd1bf69a2563da5f7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "37ff14bec69d47f767b1b7d877396ac6eba2381ad1e526d96621a98c921dff5b"),
			decodeHexString(c, "d6b53f08b72158dc971f53be13cd2dacd41de11d6dbb82b518f8d09f63b0b3b2"),
		},
		expected: decodeHexString(c, "192c2cfcae91a6c130b8fddc321690dfa797606c45ba5016c29fe92cd59e1537097d4c0d5fb1bacc795010984d2d5235c2ebae16c0f36ff5f6d3ec2059bce03cb3f8e002499611490c994d74e678bcd87b610adc07dac492ea429127dfbc66399b150b7a89364a6bbfac8f18ded63dd544f1ca63e59e87bed39565230ca47c1bfbdd7a7554d3dc434ac01216d6bf173fd3fff5f378e487ac4078774e1432195f0ac30e8448c3d9b5394ff472afb345e725eb6b8ce1e98c5daeb0dd66665d41ff"),
	})
}

func (s *drbgSuite) TestHashGenerate55_SHA384_5(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a356eeaf651bdd92ffab32abcf9b98155e71f7fac0f0e4adefa815e1d6c5636b"),
		nonce:           decodeHexString(c, "5841b7c7f014ac05ac65174255d1ee4e"),
		personalization: decodeHexString(c, "23685d20bc0302ddb7671f9b6986ded41fc6cf5059023ef3cb72680fdc030b6c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "72470c86828d6bf03dcd3d23d0076712169a313ca3eaf32dcc513825beb2baae"),
			decodeHexString(c, "f1ed0e127c984b2289e28661620237336e030c43dc5f0677d784c3b325a75679"),
		},
		expected: decodeHexString(c, "65bc2efa1ad4b2384228300a98761caa2ae97d8c0ccd6e4e445fd8de0a2e59ff25076de563913e0870458e8f9c70fdddbac3fc8d513f3f17669a1133a3fa87cff6ac447d7638a64d1f9609bbf1fc178e1e712a69f61d208e9747a2c834816a99ddddc8be9e35d70114a9db3d9b55e134898940adef320b4686770ba00d56bd7eb26ddfaabe168ce903704dbf0a7136b025737ea54159046d3cee11692c7f57e98e16f4442d0cf773a668fd709ce49935dae67f46bb58f96636e71c185f1a3870"),
	})
}

func (s *drbgSuite) TestHashGenerate55_SHA384_6(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9ff397614ad95ed8b6ac225ba32fc4224b8deb5dff0e73dddb670bbacd74e571"),
		nonce:           decodeHexString(c, "61c0b59489b8d6bb16bfad0fb2e4f0d5"),
		personalization: decodeHexString(c, "04b6f3a762a89f61990efec287674b816f7b12199067f350dc2bdc36648e9946"),
		additionalInput: [2][]byte{
			decodeHexString(c, "99faf59f88fb098b094a9514eebe0222d3670a7b91282b9a4f4b624d221eece1"),
			decodeHexString(c, "b3b94a78978bf27e3b44593dbfa8db5e9436cd23baa42453c3a39b6c80ac70b7"),
		},
		expected: decodeHexString(c, "2750644b55acae6e32dbfc9c36b11af369e5fa190afe98b1eb0d12a96ebb2af43e49b8ea2b4347d0cf264f873d0fef08fd030b14c5cb8ad95bcc3a74ef78ae81346ce4f1ae48d98ca9d8a7d19272c475239173c169014e75304d4f737b7ac2e33ee621ea7aed7cf06e6c0a5dbc26cdcd9e425480e34428f7699458b571c116846e39ed7e720cd9dbfc9c6783cb92649cc8ef05077db319fd42a1c2e958bfea2148f19219487c57927a7f9feb568cfc7395989f7847e1cb90c6a7ec04439bf92a"),
	})
}

func (s *drbgSuite) TestHashGenerate55_SHA384_7(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "1c6c04a77a4e7ba9fe80e6a181e033ab6f5bba8b9f3a4d8196748312c4a815f7"),
		nonce:           decodeHexString(c, "989de5c9845754012f1a22bec65468a5"),
		personalization: decodeHexString(c, "ff4bff05cdfc71ae321ad58299185112bfc9356dc346e86e907fca645cbb9b0c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "07315e2a0c7900ce7fb89de89d79bba2b8e6b56d99c8223a154472f25d11f4a2"),
			decodeHexString(c, "eb5b307b7ba293ba2ad700f2e829a6dd34e258013560068648ec3c89d2c89496"),
		},
		expected: decodeHexString(c, "512c3d7c71e1e57bbe451e79e47f5c6fc07ad8acc3e93ef7324cb6f24b108a8487422704b82e5cb66001f4a2c523602093ee6a29905c143f838603702d4f61c522d8184755e57776e615b4967af9bbb5b29144d683ea9d8ab6fac3ac7e1a5c0579294b4d72e475a03e1f1b82db6868fb2bd361f3ca42f48d4443d51d593efe5a12ed8b34eb664e61c7c0b7da453f5e66891c91f0859dbed4dc1fd7d4a5969172309b5aaa55eef5871ea68047a58961afa761c5cd3c5805a8a7e7f0edb6ee4eb2"),
	})
}

func (s *drbgSuite) TestHashGenerate55_SHA384_8(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "815e69bd8935f67f12239b4382bca5913aae0725b93e757d93974ecd6744306a"),
		nonce:           decodeHexString(c, "c1b5d24c068435355f3affaab90099bc"),
		personalization: decodeHexString(c, "136e4bc9ce2d6217e74348a6b33199bb39ecc6ecd9553b9a94de75f3bd886bfd"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ec4c6dcce484736c22dffed8488d6bfb95867db71ad53eece69ea09f6d38562d"),
			decodeHexString(c, "cd23eb8437f35af8c0a0cee068a3f93fc9e830828338462eaab55e158a647a3a"),
		},
		expected: decodeHexString(c, "561330156d2a91169db6bc0c885a99dddfe8af40fbe969fb22a079654ff6141110697923dd7f6c9d12a27797310b66d05bfbe9d4fab16c34cb1bc715fa4fbe41b9d90bc3b5f0958bccd2d968abe62734ac8b4c66a375c249a71b33a9170b192b9a60951ed2c2170456c5a69b6ec41898cfadd5aa1e198df642e0498454daf567c009ea750cdf452dd4a8d0e6f95d1be72fd24d0b90241e7b5843280bffe502d22722763c3d9a865210d32c0defc7dae395a4080430807c2d36863e1a27ed2eb6"),
	})
}

func (s *drbgSuite) TestHashGenerate55_SHA384_9(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "eb4f2e37c052b6e67beaafb75c575ac7146db34eced5c24dc6d4eb1fbf50dcf3"),
		nonce:           decodeHexString(c, "828dff1d8bbc85840e7b18e801e69ddb"),
		personalization: decodeHexString(c, "e68223a3274661aa668de15765f8c334503dd41843cbbf743de5ec5d5958544b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7ca640279006e71bb906b5e8c1debe3cdb82d843e5b945959fbb22e597d35406"),
			decodeHexString(c, "772b1cf18e4de1793f1426b707111380eacd9876289d593b79ba4ed8d54382c3"),
		},
		expected: decodeHexString(c, "7a86197194aabfabb7aa94615ea71b2312015003c82337676adb69cffa1f4dc04b36573570d461233b38e03a702e0a0be9359385d56725b05b3bc2876f6c83c48f1cbe0857a079bff4bac98fdf58dbc3dc420699c74710083be78276314fd7fbb066dcbaf5a0d4bad3d7f09763c080c5d189f75bbfa7e2f25a332343c08a83975314d62e6628eae5ced4496d04e39ab7b70ea2ceb0e998e5a23de7d2a06a8f60bdbe60501dabc3816e33cac5890c95b0e2c388d0950b4d939590140f0d01d0f6"),
	})
}

func (s *drbgSuite) TestHashGenerate55_SHA384_10(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "12f626801d2bf16595dc860b5c2ab1d7698eea16d0a9f0ad1062857713ba66d6"),
		nonce:           decodeHexString(c, "21fd329fa9a4d08cbe47784fddaf6f9c"),
		personalization: decodeHexString(c, "13570610ba985eb5fa7f4012d1b24620c09f371ae777ace6b31084fdd817bd88"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e0c52c099d2649cc9b207acd2c161cc9a8ee8bdca44c797c79e29ff86a41f980"),
			decodeHexString(c, "b76d430600ff1634b4cdb59daf52cdeebf8474ff88be984d3db900bd347ab640"),
		},
		expected: decodeHexString(c, "a73da8ab954385d12b87086c35af4b64968bbaeb720d5487ba579cc831f8053c2120cd609d25647fecbcdfa967c788e1393913c18f4362194c4b87be4aa1098952288a6312880b3823ed3784487a744ff6ece81da4177e5967642a755a22916b578926308e12139ade9a291df3779665a5214834c44e469c7cd39542d1cb535d16d92a439c43afbcf4551531abd8c2b69cb8901152410fe26236e0fcc0aa3dec898531befb1422a9e6b226739ef9a9ad3bb6f223bad19febc7b2e4afa0fd45d7"),
	})
}

func (s *drbgSuite) TestHashGenerate55_SHA384_11(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "10b67c9740aac7c965c644e4f1743855dfeecec5ab2b8da4c3127dafa8488716"),
		nonce:           decodeHexString(c, "a52df195d047859c9b6883b641204109"),
		personalization: decodeHexString(c, "5e37bd9c2fa7f6e257f19b30b4e82076ef6a9c96323e8d1e82b545dc937c617d"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a8ed5e5dec946576b43719992985c59defe7f87a2babd834909cb0b9c589dcdc"),
			decodeHexString(c, "7d2325ef88c40ce2e1e4495b80f3c38c955024b760e945ca51002d0ae3006024"),
		},
		expected: decodeHexString(c, "0cfb605afe8fd756d5bcb94bd6f240a1801b834640d14b5f10aef6b7aecc35fa1abc88496ec84a64eb3bd7e629622b4a38a11220613d0e50391a5de16e0aa8d6a126a7e8ac41e820ce56c9d3890fbffcb3f7322cafdd74e078b2f75acb71de440deaa0431183934d5404753211771bfbd605e3d6c0ec6d5b6f2c9b18da0927977b9d72a0a035fe0e272c21c94a4916aea5bf264ddff0c76b239a459a28b973c6fdf2c456fc04b3bffac4af071b6c4193a96f7eded304a500967bc78afb2c4e5e"),
	})
}

func (s *drbgSuite) TestHashGenerate55_SHA384_12(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "92bc198252e5515648e06afeecbaecec614882b38a66a0c9111567d36b2a97fb"),
		nonce:           decodeHexString(c, "234003e9e6ccf82894b89ec20b53aaa6"),
		personalization: decodeHexString(c, "cc55b057b68e8ee1e334f5c7610d4b0627f95febdaa8d5667d3b453c9f6baa57"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e17c2d2172fdafe61ce30ddae5632372f1116925f4e157a3a4fe020110ca3d54"),
			decodeHexString(c, "ba5ce9e893f63b356a5af078284a02aee9db5f108872a3bf3c439d5b435c1d01"),
		},
		expected: decodeHexString(c, "a8aa68af678e8e340b21cf7a595a3ba72daad1dcf124ba7f3ed22e070aef517d08baaf6fb5d522f209f85ea4c4d5357a91a5511bd6dea955b66399f7f3a86952a89a489f5f2e4fb814c0c25c3d7368bf1759fcc0e1b34d527ecd4bf767b96761436434ef537937bc4141e7edbc24faeecd94c93f60e6b6d50d92370571cbe4118022cbb2091098b953db16d5424a32f4a28bab2f4e2380bf5e8d96d1a4f4ab5a94581cdedf59ac7e7b123d47789e1270e9c0bbb43d9ed04e6c42d27f1a8b7455"),
	})
}

func (s *drbgSuite) TestHashGenerate55_SHA384_13(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3af3ce7c2de63bff37a8a40e7d5a510ba3941bb4d037f377496a68b82c527fed"),
		nonce:           decodeHexString(c, "a968f6c45707f8d73938cdbfe04d1f17"),
		personalization: decodeHexString(c, "9c7d4d8266cd5da031f7bcf5c2aca5f4db1c6d8fed8411e5cde4af8f62a052f6"),
		additionalInput: [2][]byte{
			decodeHexString(c, "70a8bc04b426969c55599b66f797c20c88cf646f819d6b1d3cf9512556e1cf82"),
			decodeHexString(c, "bc33476d9491665ea2f5b7108c8b554c99c8a20787bd12ca689ca62dca0b8254"),
		},
		expected: decodeHexString(c, "07450117a5b116d7d7e0df5f1a420141887f39f16852dd5b3ed4badf061f684767ebccd6656b4a838db4d8e4efe3284b85b02c4b7076c056f3255f7ca9947d7988507b665b653d0a531c6e60aa677eacf53aa380eaaa4741bf2bf9634e9c4a90ede8d20522217b8a7c2e458cc8b002341aa72aaf93263736b56166c3c9c4d230ff96fc3d51fdb8ea2125facced58e1c94cc4405ac9dfa1212b55e0d37a524d14684d476b5b1842844a9bceab02d5b6e1b01cfad88aaf045a9d9b3974e265567b"),
	})
}

func (s *drbgSuite) TestHashGenerate55_SHA384_14(c *C) {
	s.testHashGenerate55_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f676e6f82d90414cd0cc23f83c112e6126436b962c454ea4b9eb0598621a27f2"),
		nonce:           decodeHexString(c, "78c9137a3ac268dcccbe19ba0a7580b8"),
		personalization: decodeHexString(c, "2952af91d73d96d41a9b6d4d1217de595f72979b9024e8c94912470ad29acdab"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0facad642bc0004f946e3fdd149a4c0e52475c9e832c85b228bff6f2a4af3af1"),
			decodeHexString(c, "19d477a7dd45a0b733e6c301a4fd44ddf65d4fe0a0435b57e319e31de4797427"),
		},
		expected: decodeHexString(c, "2a48844f6919ed43a2b0b64a1d28707fd3265b418e0673190b49a606358062c1a54a6071c845adc6ad74193d746668f890423ebb971a63cedae3241005432c8f3fa3fe7f98d5912da34dabcfeb17c03ee8881de7b2ef04fa2147b78532eb0ce7d9244d717697138f116341c7b9e99f15728207f6a73c651b8940582f9f926253420a853ae18132093183a6073e3bc85633b75e1c6cec9323ed4142d0c8ca0dd5ab2ff2e6b304ab8cfe4aa98ac64951d836e074169d375ebeae8498f11bd02c05"),
	})
}

func (s *drbgSuite) testHashGenerate57_SHA384(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHashGenerate57_SHA384_0(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "211aef52ebfa8b8ab712d6734f6d2403cba5ed8ee1aca4bceb8358215b526cc4"),
		nonce:           decodeHexString(c, "d24fd710c1773744b7af045a23e2b359"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cfee12401a1b8c02f02ee485c0eeffbd7a6983a620d357953e4eec75c486b43b"),
			decodeHexString(c, "9609829d8bc02dde14cab4f9264dc61798513c9e3ca977f735116a0cf553c065"),
		},
		expected: decodeHexString(c, "a6dc3d779f35be2209eccb4fcb5ebf15bacb10a8cdd0bf3cd28b54cf750c6ecaadc755ad48dcfa06420ef52cc93959984116d54d5f243ee5422acdf46448fcf47e33032cee872ee4c3245b5feaeecab94766ef0027fc9e1df5e99ed3252b1236c3d6459a43dfe9b30e8c3069351f57a0f650112c0be658856e43b3643c26e640ac966f9a1aefc541b37d0534ad20bc6889055d98b5d398deda10bfbc62842b992b8a10d46eb9c5348f1ded1ec46c1d124204e4175b24ffe97adc7692d3f20e2d"),
	})
}

func (s *drbgSuite) TestHashGenerate57_SHA384_1(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d559e3a0489a0cfbd5b8f5aeac9fc0bd5a082f580fb16b4e79391dfe27fe824b"),
		nonce:           decodeHexString(c, "ebd227125a5b9c502e1611c7fa68e557"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "406b3d5cee034080e84e3ca2ebe480aaf057b636f52a6878fd0a4530b379b85b"),
			decodeHexString(c, "96b9e8baa5c839a713b38a921bc69c17c9ec5fb1556f4c2139757dcfaf0a6eee"),
		},
		expected: decodeHexString(c, "8562e5da6c7d5b3e9e74ad6e6f5e684b4f04ca9e99a0df4bf514e2ccab93bdba59559b64a28f4d1ffef2b14e0394747cb74964b5b1139457014dedc674ebaac25214de7e13cf45ac37d502f69a92d13aa633e0edd25ec9ec04a8a40ef1613b4c53e9672e5d7d2267493b34a5a08f9ac7752e9adff76b00337d7649f3c57e7c7a71347a59cdfe41f8f3fa6b2dc701408caedfb46b08b8abf46cc93e237ee8279e83203be7dbc4694579889a1cebd034a86f13ddc7d316df2e0ba0d7ba23d8f2f7"),
	})
}

func (s *drbgSuite) TestHashGenerate57_SHA384_2(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "84bdcc44f1554efba8de2f3ddfb87c4fce23c8b97c1b0e70c42e2c1683675bce"),
		nonce:           decodeHexString(c, "7066b1fde6841ab4e7c9437d791dfdc8"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "31f4abe175e228cf53af8b3eca037a59a2126860eeb8ee69f1f88140da589d31"),
			decodeHexString(c, "e54f99458a3bfb6fc44f32527d01268cc7b8de06017050d0fd47764e005280da"),
		},
		expected: decodeHexString(c, "8dce21f6599b66704b3d718bc351eb8435f3a00ce80393810e85b799b526c9c4883eba9e4661484375d5bf3087fe22915ee41018a4f30764a9bbdf35897f64a82f840c67ec8c3c62e96d9a59a9c54e03f0cec78258a138a9e5370bcb0a2aee4842e9e1a29cf1425a74cf89fa48d4551487f41620b1073114637624c5f5d3b512e9326b85c84566c3c8ba51b8bfbf716ecef1d04262c4025638ba225e181e2566c6466054e56f20838517902ad90acd9333aba3c2296a6ddddda6ffda50221645"),
	})
}

func (s *drbgSuite) TestHashGenerate57_SHA384_3(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "7cf7a280292a7c3d15231003fb97cfdb93e722644436ba72a7975002e52581c6"),
		nonce:           decodeHexString(c, "edbb6d2cde1321234e2131856f9accb7"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "eb88a12d7562281162fd29222e7d01202503d97fea2a7e3aae0d6ba88e5c90f0"),
			decodeHexString(c, "8455c1a90b23ac3129e0e79246fee41b4cca6b885860f62aaa039dce21a3c21c"),
		},
		expected: decodeHexString(c, "145dacb9ff3e45a6e5a409d501c1316bac87d9ed5c4198db804b59bd752bf0100221963d497b83d047ff67b25f93c86c4fe9a9c3b2bec814a87a9dd56b87dc95f392c3282e98c53ed880f2fcf44aa48b5221f75f71e130f379f7911fff5c3ae54ff88f28ac1e82a7d6a6f674a92436503d1a99b179a53fed9591857d5515499c1f7f05a8daa6117cac680279104a081eff4de28fa6bb17fab7c1f0041c6fc10a38eaa4102318cbc859ab13993bfedd423d4d9f24dcc7c1366bab14daf5957632"),
	})
}

func (s *drbgSuite) TestHashGenerate57_SHA384_4(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "9155d2e19cbeec98860722bef799c2f3332f1408e6afb32baccf1392507d6bf5"),
		nonce:           decodeHexString(c, "b6b4ae01a586efde1d00255454a4170a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3af3a72a85bc795ed5f9ddda56229ddc462b32f92ba5b791f1be647009311f0e"),
			decodeHexString(c, "5491ae4f73534fcb6fc328ed1cb0b4f4e57ca3cc792203eb47c708580ea630ae"),
		},
		expected: decodeHexString(c, "6de2d0e3c5fbb6644ee11039bed584e909d974b8f569f60e12ecce8563e1dd280532bbc07a6fabb76bccca5a9d06cb01e817421492200f830efd1e995e8750c15aa2da8cf0d6f38c5cbe92f2ac221b1036b8376f92c129bf1b5fd0a2951041e0f6125c31a00bbd537be944d41cc46ca352d612e5c748671d61e5fb122444dacf57a80a3f22cb3e05bc36e444edbdce1c9ea1a1eacfe69ac7256d3d7bf7ec4037eed2fe7e8de50cca38f470657876dd98da5a7aa666dc5dbe64534f6cc6aca40f"),
	})
}

func (s *drbgSuite) TestHashGenerate57_SHA384_5(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f8851337b20f05c86ae5cf6e7c417d4771c8e3e5d2339a5d2ff9c21386e0ec7b"),
		nonce:           decodeHexString(c, "f361a2aeea782462b403004d8f85e7bb"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "6b3f59d3a5b8074d041a6c00f8d9cc01abf42de97bd04cf1b23a306dbff77373"),
			decodeHexString(c, "e475d94bd54d2d0f50aef24e77bdabcb84335eaadf20686b867dd66a1dc777fa"),
		},
		expected: decodeHexString(c, "d5dc0999ee0a31b756b2c84ffd4828feee1c0b97190fdd0c51e98ae23930d4b9a2dbfd720e4d9b786fa32991ec0bd2595153b9297438e5f32b18000bede539f504cee1d0b5848006f6d79668e48ddfc494715d66fa339a6d0ac3976c1e331acd70e498e1e8f122a4b121366d90896ce2fdad09296a0e44ebf074e4fcb555e252f11abe1a3b4809bb092ba35220274e71c046852c97f27dc030764963536e9c434640db8cc287ffe639830d891b57b8904a845c29967bb2332584d49fc14dc1bf"),
	})
}

func (s *drbgSuite) TestHashGenerate57_SHA384_6(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "38084c1e381ac23b82ebc85a7f86ba3093ba8d535e137a139a9fa12d7ef908d3"),
		nonce:           decodeHexString(c, "1c58efd1a23f32caf94d9c400919a0db"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "194888df78f5ad2a96fa0f01aed22c6652e66f450fc586889e5fbdc22596584b"),
			decodeHexString(c, "733888da96ada32c0c2ce72275efd118621224fba68557afa07a91fd6858f421"),
		},
		expected: decodeHexString(c, "cfd92af709819d97fd24f7dd0a1268e0946a3155911b2be0b4cfec2fa81aab610dfb2cae05b1dd4e8daa01e42b911e52093bc0dd3333d71fdc108c2616281df9c90669c68e72bbea98ce1ae8ce8ac0ef47a721085e66ba470cf2bf66dfd78acd1c6d8691bc43b0b950e8a717546482ae654e4f762a1ed7dc0a7c13a906964ed55262933dba034575465b14633b32a8391c78b626f64a13e0bc4bd68f36c63712dbda3e95c2567c093a694756f11e817948d4c225dd3b754b0b02a70a16cd527d"),
	})
}

func (s *drbgSuite) TestHashGenerate57_SHA384_7(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a9e25cc2e9b737b19a009c35bc6dfef47fe2b27490c3076daeb3da0a8a1650fc"),
		nonce:           decodeHexString(c, "3421e2b231823a613dad2f851734daa5"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c788311524aff96920b30692939980d366c70955587c853793ae73c16e9d596b"),
			decodeHexString(c, "10f12eece4f19fcb9c78bdee94732902a42a5854dcfe407d19d0fdc7a03c4f3e"),
		},
		expected: decodeHexString(c, "83a4bf357b8268379e3ed4767b1acc503178ae9c47b5d3a8566a5932763d318138b186fdd760332516ec3ae3a560373479e75285662609757d04f2ac51fabe61b1d0a635e1d198d0883934480b9ace1cc0c096734f4a906ebdbadfbd039c191f45c3c6bcd642970c4346a9a6b8017081d6f58ac07ab68c2a1c085c902388bd0c425adcca80e73822d3305836c224168426c397aedd43ef9aac8c860dc3ce8e24d067774bebff3194f2c0164db2a074a6262ff379003b53bb0530cb4707eb0b6c"),
	})
}

func (s *drbgSuite) TestHashGenerate57_SHA384_8(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "29240d738e28bfca0b228abf30f966ed25c49ef40767424393b449e7a6103798"),
		nonce:           decodeHexString(c, "29c23e30beda91e31499d2a303effc4d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "11b3964aebac9f8e83d8d382987def28c62ef2baca63a546371cf10c44abcb54"),
			decodeHexString(c, "06940635371bfae8f7a66dc47b56801d929feeb29a09e130085a1e6a98ac78c5"),
		},
		expected: decodeHexString(c, "dd60a097c02b8d810af0616971749539ddad3cc95defb3a1901b9e53dcc32eaf5e7ba348a5eec01d5821cb1fa674959ef6999aa02a8bd096c659d3a5ed4b66c84aebdd51e154c95a830e41cefcb1e7f088370b87bd28fac2aaf67bb94cc612c610bfaeebc050bb972dab69b1997d045d1b4c6c80beb70f61874dd4b06645c928c624af578fba39dc255fd789041fd8b68be1580a86598f696a24d445bf0e67b557f220d72e33e61c6b39fb2e5bbb3f803ddb2857c3add88a1c26cbb0ac5085fb"),
	})
}

func (s *drbgSuite) TestHashGenerate57_SHA384_9(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "899829f7c7c8b2fd0de58862019278b0d8ff9c9cffc905604b5fa2f5cd48d995"),
		nonce:           decodeHexString(c, "16a57264e2eb3db6af150382dbe4b5cc"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a148ac240727d0a4ef4d7c091f1c47a8d307c880c97ee792e47b8380975d518c"),
			decodeHexString(c, "d0d9ae85ac486f93410bb128e2dab6e54e6fc71ca5b6bf4c58eaa21c7da6d387"),
		},
		expected: decodeHexString(c, "2daf5b28c358333bd65aeaeab18d2e4329edfc1541173eea15e1c9057bd3e11c9035aef374ba9e8568bba5645b018b384bb189e1dfe774a9051bcb655a65ab2abde6ed3e51dc92353b7a113c74ebbba352debdd74af163337419e6bb5fdb167f1f1e278198c0856348cf1e46a68e29228b3cf4f977557e1dd502f3a155841b24841e642af62c985cb23c5e14622d843e7491f3db9c1019c511de0c089667dbf64c92107f99c107ee30ebde531732e02f19958a06c81e61777e785a9905bddcdf"),
	})
}

func (s *drbgSuite) TestHashGenerate57_SHA384_10(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "0a4e66d19092c36fd8fe2722e769ec81b5fc21564488959620c5c841d37d08f9"),
		nonce:           decodeHexString(c, "362ab0fac130deb87047d69e81c20e33"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b8c044329a928212631d19fb7e6c0eb34f32c42f8d6aaecfd84072d3aaed4938"),
			decodeHexString(c, "cbd5e50781aad8b7ca73edbbaf5c803e338144a9f0fcb7ad457d87def2c5962c"),
		},
		expected: decodeHexString(c, "41f849c0e0c2926f591ad257c4802e7552e078f0f6bcfc108d8e4e5f78ad6630a6bd02a3e2373d4c80e1fae46c6fc6306db3029d8cb199f110e20ac5ed0a82c275ed943d4fffd43ebc1fcdde7bc08e7190911eaa98cc493c290546755af7846575c3ca96175ab4cc1ffbc741b11d246fe056e5849ec5ea264c81061c2b54281f5e3d45aba4ae1bdb9645554bab59543d7bc0bd6e9ba3cfd01ee97f67e65f3a6dcecc02e507e420aab8a05151bf1d7351cace4758dccbdd4c34234b28d18a3654"),
	})
}

func (s *drbgSuite) TestHashGenerate57_SHA384_11(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "294e4f34a6e82f7d82870148945a52da13daae4a1961ab558e64d64bdb164a93"),
		nonce:           decodeHexString(c, "7b33da99b4650057465e01498dd71879"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "30927229807d278b9753514a9b762b62a5468eeb8874af4ae8e3d00b8eeb77fa"),
			decodeHexString(c, "eaa065cbee6f7ed92f391f3fe6badfd84e62765df9ba11fa5a12b8bbe11b87d5"),
		},
		expected: decodeHexString(c, "fe50f4780b107b519887148a3a95754456c6ddc63f603eeb4405a676e67bfccc83c8f1ca5babc79aade63825b64c0cd695bf01cf0889729551be22103d79a8009140a2d3fa97e4a607d11681a7088d13b8dc44f926dc952325bae51c830352177759055d7bb1ce02cdac368c7c8f9b3f03d3e916f52b3e73c9e3a7b4160f0d18d4ef6073ced56f057eb9177b87b7e1931ae562ab07adc6ac5442ff519f8a18ce0486572f62870a250f1871d67e4bee9ba84815c6f8987f729315d55b3ad9f710"),
	})
}

func (s *drbgSuite) TestHashGenerate57_SHA384_12(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "678348fca7958da9c6c9824f8e41f99cf9e5679aedf23e36efee944659931f0b"),
		nonce:           decodeHexString(c, "091632d69910829b3752f2ffcf7d7d90"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "5c90b6ae2ca748e1457a47881c51686e526faae7efaf615fe7b1e0faed5abe93"),
			decodeHexString(c, "3ea63094d37b5ac8b70780f6cb068a06754c34232cc4a510a67496d6df5c8125"),
		},
		expected: decodeHexString(c, "def000cebc30b3ca76ac26f65d8e91e6fa8f16983221ee5c8691961dc3a26d3b78ad2ad2f1e861c642d85a5bc4c6e4963bedd68011144c184ec6c4e0484e404ff8743b32e6124ee35c894f118eec2afd215d4fc04d834b08566ab4e50b8d710822895752645c07b5d0d3a25b69df294130b9ed16dfa8a4717a59cb9d1ebb16610b0f68c6e2b4c9f3cd11c77da6c1ca3dfeb1a9c50333ad53c25aa3f8dcbe9061f14a1b7beb7520c58ecdbb0ea2050951b00befe5d78a35b269969ae03e0b91ca"),
	})
}

func (s *drbgSuite) TestHashGenerate57_SHA384_13(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "4c562b473c4a1dce0d7a3f1fc037660225404bbd59b346ced01cd9c1a392aef3"),
		nonce:           decodeHexString(c, "ab44014749ec64303cfadb70e07c2c2d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "8f4f213671befdbaaf10f4a5177ac25f5505c82a194cf5255b0cfdd7d0f9f096"),
			decodeHexString(c, "490246159761af5ad163c02d8beaec64130bcb6fb44d85b56e999844b148a81a"),
		},
		expected: decodeHexString(c, "17face71c9cae2b898ed56a44b3634559d3ab58ed3806e1c0a88906ca1ee18a8825faa34c5be021177f2c642561a7e99132dd92c3ec3b47ef6d3f67225b644f431cd0bc6df12332ee910755aab48dce9da3775b21e7ae88135a2b074133b433a3b8bfbf21444e5d8dcb8615fbe3729bc5483d84ecb4c87fc73e187b361a81cd051ca65053da4dab05dae7f1a1963cc70e78ac6345fee5262cd34da4e1c42e2344602288bcefd8ae7cb3e87b0ec446e64e5033883f97b6ddcd279a772d660330c"),
	})
}

func (s *drbgSuite) TestHashGenerate57_SHA384_14(c *C) {
	s.testHashGenerate57_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "4ddffdcb19672ad540a056a61d38d5a5f9d3649ad96bc8db0c81993a8615e0f8"),
		nonce:           decodeHexString(c, "c4885909d8dfcb6d7e567623afcf47f6"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "c6a3bc83220c7708eb7fff5787ecba27e48c894e15302e0ee7f4e5f09b3d6b76"),
			decodeHexString(c, "39b854a1c487e24e1ed58916d8012277fafd6e7b6175c4be43927cfac9958404"),
		},
		expected: decodeHexString(c, "f7d2f39a513f6c4eab993fa440b769ce09a15476e06ceda47969be05f53ec7f8409de284749cdcfac07fe7df66b1b6bd39389401909f3a84538d041e1c038a289869e51bce8bac13a0f786cb091628f0a3a7f7f9a2f620c98889688d46a2a037fbc1b2a4fff40800eaccf98a0bc1452ff1f53f040daa94e17dcd6acef97192c74075d064be5a97205ad97f693257d96c04e78654a694e90b80a5234a25d1c7ceef360d53e768067335097c4aa8f126a31882eff8e55cee05eba4b4325c203f4b"),
	})
}

func (s *drbgSuite) testHashGenerate59_SHA384(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHashGenerate59_SHA384_0(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8d94e04ee26aa9ec7381eceff9dadf9163645c4f7c8692df7a3263f23754d315"),
		nonce:           decodeHexString(c, "90cbf3689ccbc2340920946316995252"),
		personalization: decodeHexString(c, "8227179c9134175c478821175bd8a5651a82c38c31cef5d2e49396194cf569c5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "3da647dd626a59ff5c6039e044438f0539755948975f2ba97278a439f4d0d69d"),
			decodeHexString(c, "db975d66964fc83fa4b9a5b2531c2320d6215c4eabe8543dbd7ce91753e3f25e"),
		},
		expected: decodeHexString(c, "03e97b7f175b8dd135c46dda67ded1b2548670523885d541bd79aaa44aea3fc95a197b9753b529320557dc2c9ca9073c952691ed423d12e9aac6f74e5055331cf9ce27a067da06eddeef444f9abffe49b0b3ce97e616409a18e8aee5255cb68addfdcd558676b476febd4a9ccefbaa8f55f69271aab0feb2fffeb5a4b563eec046524a07aa239c83da5615bd16494920268ac8a7ebb4bf8760eb872c3190ca692a8518cf6a8777d37a3ce3bf5a15128b7200820222eee0d31ab7f062c461c48c"),
	})
}

func (s *drbgSuite) TestHashGenerate59_SHA384_1(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "eba56435837cffd42ea2207c506df663675242879bec4ef87f8930f422475349"),
		nonce:           decodeHexString(c, "3777c3b8f9c6e090f8bfa8293655c80c"),
		personalization: decodeHexString(c, "8c2166f2d67e5b10211ec2717519174cdc5964281570325d0dedb450e5b68c8b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8ab7647bd61d94c2505c542574cfa587f92a532b0687a9389f37d426a344b1b0"),
			decodeHexString(c, "4edd5708217b45669d85e5ca9dd1710c79108c2d42035ed7e5c65c084d6b1ff4"),
		},
		expected: decodeHexString(c, "f8d2c53d8f59a53c2e35c57f09a299fb698f43096e3eb5f7a9fc24aa9ccb2c0fd577cf6a55cd9fa5d76a9868b716457ebea58091c09bb4b111723771b8d9d8c8750a13b0af4ee5185a69fb12c0c79bdcbfd10ee23454fc5fe9bc667cbdd24d7e02a9641c5058de33cfc6782010d39733a796a166da98dd7c6ad9e353d72d2937b65bc9ddada85a16218b5fed05dd00b7df8e78c8b2bd5021c5f7ea9cd3d4caf1920616145374220283ce279dbe4474b1c5476d943975f4e673430fc0996d0a92"),
	})
}

func (s *drbgSuite) TestHashGenerate59_SHA384_2(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f2f1f7659497a8305f35a8493a5d776067d3a9735d2acbcb7ac565807073c6df"),
		nonce:           decodeHexString(c, "70d09abdaa9442f9f503b77d14d25fbb"),
		personalization: decodeHexString(c, "0c2575f457bf117fb620a9ab2ac19d23e1f65f16c4948aee441ce970f8643086"),
		additionalInput: [2][]byte{
			decodeHexString(c, "a086eea1b4e71120d1137816dbdac96faf0e013b23b0b467a8fb16ae4887f8af"),
			decodeHexString(c, "b18e4342246fbfbc2ff5fa0e949f0c497feb60627c53873a3a6ede850de15f53"),
		},
		expected: decodeHexString(c, "840d3b8e9d7ba5eed72a0ee853d281307f813077ef32e8a3979ecbc249ea21381bdd203cfbd91a932570274fa46698534958bd4e0a83818b08d43dac55ab85fcb1e27c571fb8ab8638bd66af9d3c1aea9b1755362da194c2b3c9076746e54d16b07f29afe76358fd8bf9dc8498b3e2558d2a4cbe06c20473c82773a586c3adf2fe747ef2aa1febc6254a2b5e5bbe422c93d93c14684f8e119dd1c0215b49b5ede11115742fc5785f455227f4b68869862ce1787af3771a3fff7a406fac55f3a7"),
	})
}

func (s *drbgSuite) TestHashGenerate59_SHA384_3(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a292ceef569f185d60624e0602a0f78733a24f4e84bd52f83e38769ce3727336"),
		nonce:           decodeHexString(c, "01b0a5c0b7cd47554933603d8219ecef"),
		personalization: decodeHexString(c, "dbbb16c8fa840502888e141ad82f13a22d95780aa32915f2045554b29f3e1f1e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "67cea8f68935466233a17e27994ba5dbec679e69d9f5de89b62ab5b56c3e2d1a"),
			decodeHexString(c, "981094dfeadf088f477a2955c0b597a7cc55d17b7e133dbcd06192a7e70db4e3"),
		},
		expected: decodeHexString(c, "8bd1d3d2d24fc79506d92a3f55a972346422ab86dccbc9c5c6e66cc925ee12721bf71a47809f41755b4cacf005b37bdd2821be33d44771119652fb43817c1d90f6b01e3ecb2e0b5920a0ee30676e0ac074975b73f01bfe2d7cf07a278b75978f1b05033f9ca9fd5bf99b73831f7b6a9087145caddf35e54e23704013a8de64d36cc572be3de435a3377aeb077295b5e1059823953784aad9f0c2e33abaf9250cfc798e38be4dbf7237fc232e27569a97a6223b2c8f0b67d2e770781aed87e5db"),
	})
}

func (s *drbgSuite) TestHashGenerate59_SHA384_4(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "eff6e452706343f00434e8e72dcc922f2e56d1bb97515e220d2a698e4aefa42d"),
		nonce:           decodeHexString(c, "95529017b166e0766c2587908e30a8b0"),
		personalization: decodeHexString(c, "5ef174a49fedeb83841be9a638ad4231ab840d217b052ed7b655ee9cdf42efb7"),
		additionalInput: [2][]byte{
			decodeHexString(c, "be111b2165eb0acd6487d9b9004fbcadd09741acaefa5540461b842cacdae425"),
			decodeHexString(c, "a33d190998c427aa599a5ddb3bcd26e5397ad1f0a59f38278013e37e67449767"),
		},
		expected: decodeHexString(c, "6174cd69e59ef2f720728fc83c085ffc9623775664f53de26bc6ca12fdb391aa3ebf7a638413402f0ffce994b2cf3d23fea0db31f1be94c0a7f277b3a3f4a35fbbbaf8a1aaa30a044a2f66dc748e7fc44f374ea4802288f2ede3a9931770050ea9920ff8b9811bc5b75a77bbad2ecb9915bf2b20647e8d11e237c538727c96318683544383884d1fe0df7c93656b4a27f51d2cdb3acef1d1a590cb013a8521d0173633194eeb1629da4de90eeeac12417b7b25e204ec5b53984dc233485010c5"),
	})
}

func (s *drbgSuite) TestHashGenerate59_SHA384_5(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "d40168bceadfeee0513543da1c9ae57ff427e21bc2a8c5def2c0bd0a94d11dd1"),
		nonce:           decodeHexString(c, "2902d6db86bea33255d165ffede91564"),
		personalization: decodeHexString(c, "5d4077ea9f43ecfd30f03d548d8563dd5e13cce00ec525c008ae000848f84314"),
		additionalInput: [2][]byte{
			decodeHexString(c, "91caa77ddba8304dc282324a706000ca31dea9f52ddf51cc943f222466859856"),
			decodeHexString(c, "9f9fdcd790dba268c4b92054029c4c9a9a040fe0e3e674226687dfe2f6af348a"),
		},
		expected: decodeHexString(c, "eb8169d05935de5e5f382b31fc710a619dd0a7d572e170c6ffbdc15eed5be2609630f8b9f852f12dfbf46e0dee9badf48cfa8adc545e13d897d593d26a7033ac71ba5cce2c575d541b27aa692c6d2a2d51f5beb95ca75804571a8a4d0c1b25b1ac752b6a817bdf987342f21afad47145b9cc66a13f8bc523e8b5f5d0653c6502f004a6d7ecf5cbc96458054041eb846b9c089939aec1bda4913bce79fa7ced1f36ca7e84bff89490136b19d32d2b7932449c792fbbf6057ab2dbea5a57672377"),
	})
}

func (s *drbgSuite) TestHashGenerate59_SHA384_6(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "cfcae9e5c273119db4c4060400ee98d99b9c8fecb486c1e4be259eaf04826c13"),
		nonce:           decodeHexString(c, "cc1f73e20584132668df526b5649c844"),
		personalization: decodeHexString(c, "48b13013cee0c51a08792d4d057e093905eb93e8880cef5bc7f6b94d88f04cbc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ae81edf9c7c8ba49f70a4e2faf3bd7e06b443202f185d07cae00b0d2b5840e71"),
			decodeHexString(c, "d6fdec894b6478edfd196e085af5cbd89bca403b6eda394b1c98f77371449211"),
		},
		expected: decodeHexString(c, "734ab88603d7c3daf500b25cfce81ad6d34e12204758c4bcf34a9edaf459290701110b7c2d5ffc8358f54632ec15b65031b599d643c876c5acceb8156bc79e16393e61fc0166f4fe8d97f2bb64fbcc927af6f75ea69ff3cc6ece185e87c28a6ab3ecd1cfc9a03b69c6ee76d8b7631f1ccb51691ff3fd3d4cf359a74b217f23bdd11549cf42a8637333ac92d2d4ba95fd5bbd0f4181e5af92f533987cc50867675a1ea2dd250aa3f30c100df6ac6e3fa991595863bbbd7fb1df32efc7ff6202d0"),
	})
}

func (s *drbgSuite) TestHashGenerate59_SHA384_7(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "596fe2dbb26711a790e8feed790597f67a27877538aeb5f8d70a938608dae6d1"),
		nonce:           decodeHexString(c, "d211741ca6dfd385e29f04cc4f9b18f8"),
		personalization: decodeHexString(c, "36eef365489d9440b98c6519a95160894e582d2537fe5f34b2367c873af225d9"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f745c63afe49b4452cf4e9d68dd5efc4e46e0a0ec61f6e18438316819add6d1a"),
			decodeHexString(c, "6159be82b4f11bdf504a6992d0a57ab1d8fedafa1cc5d43a4bae2a1d85c08fb4"),
		},
		expected: decodeHexString(c, "6dac3928f926236148a6276b7f0ae75f498866ac9cf5995bffe6fbfd8fd7138b16d9f782e84115833801d0995e15f98a1133e70631e1dbfd513ab7f8ae28df5b27512bcee1984e8ac0943bd04cabb5a6d5bbee16dd17887f36d5204172316b35b82262104eff5117d36c04f5bae34e622932eec1b1f1fd09d40cefbd34a2ebf74a6d2b59b9c2f17ff2df640dfda5d9c4a7d4b0bb35d4da05e3d48df0af68c57ec89fd91e8e7149a26a795bd93f6265844b1f3d57c76be6f369d91f15a58ee14e"),
	})
}

func (s *drbgSuite) TestHashGenerate59_SHA384_8(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f3eaa2913258e0130f608f374be741acd8e546f2190d99caa15b7061b1e04c4d"),
		nonce:           decodeHexString(c, "081e8f87e462f2ad4073dc1cc3beb993"),
		personalization: decodeHexString(c, "dbc1512f971801a814d59b40cb8c3bba8699719412a317181fb8abe5a32357b3"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ee55a9905a0e77cc25a670484b72018843eb0dad7cf77b05f941af663ba8c15b"),
			decodeHexString(c, "d935e8d13f0c32b6fdae7850d4f050aa2772e5502c7631c11f7bad0e5d1d181e"),
		},
		expected: decodeHexString(c, "6feb6ca54d169de79de3a3a077b1a0b665cf9d4197b737e025891a0f743532ac88728b4c2c9f54e6e8fbbac29fdf7d448166a382cfb3097183e1b7c2508793713ba0430f660b58564a0c6ae1c408861a5dcba1422baed032b792f3f36ca3ef9ded9bf8f9e019dfceb5a2d2e875c26c7f2cae8da63ec009eaecc55204c58b6bbd0374e9ba7d10522edc52f6ba2dfee359bc947ebd7fefb28109a7481a327ce0d01d838fdb5818b9a47902c6687f393494a11f3b2cc8232de5c9ba69074facacc7"),
	})
}

func (s *drbgSuite) TestHashGenerate59_SHA384_9(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b9b962a5ddd44b4941041b1ea74485e249897dd88c0355d8303a57ebcf577209"),
		nonce:           decodeHexString(c, "d83a4e5373bee5a9cbdc560f5171d1f4"),
		personalization: decodeHexString(c, "682dacff9c2eb2f300173c4f13118be59affcede0099780e843e894e4ab5cf16"),
		additionalInput: [2][]byte{
			decodeHexString(c, "93b3e104230bb246b527b671edf8d8d9553e78729533823839d59ec84470ce56"),
			decodeHexString(c, "010b9610d7d10a4503b309287fad7b06cc16f9a03505c3454debeec9f7f06559"),
		},
		expected: decodeHexString(c, "2ebf81a2608c2e9a0abb9de9acd1d4c02d3a03a0128f0b5cb757c4b189c8c93d63ee515bf1c625582371ad0a557af695ba72f7e88175bb71eeb96a75371b401a83df8e9873ee9002dedf352ef48403dd7035c7dd2b41906286f6d98eea99a142f50cf3eda184c0e54ca2735cb68427dc1c02072ed3c4a8558be39fa2c35399b2283743549d0dbcc0df370a486edc76aff8ce5592903e447e6662d1185d61e11db98daf5fc0a779cded256bb6c3620ef5f3ade3e1e5892c72fe98643345484984"),
	})
}

func (s *drbgSuite) TestHashGenerate59_SHA384_10(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "561c3c79a72e42f1522caecf2af1873ad554b57d18c2c4f6c44648e8e6a48531"),
		nonce:           decodeHexString(c, "42ae3285a5102e0ff262ee8c9544b6d7"),
		personalization: decodeHexString(c, "84b6393ff308f55f803e33e36cb18f2ad515faaf0acd961a541dfec1efe6b75e"),
		additionalInput: [2][]byte{
			decodeHexString(c, "e3bc52ff5d1c85f3f2e5d459a2e475836e028ff1f764d7797b310f52d2f95743"),
			decodeHexString(c, "2aea6c35e008e671a5071b08967e7b5d1809f154dc71073e3c271bad6d354e83"),
		},
		expected: decodeHexString(c, "67e0ca620571236717abad4346155adee7f699e6cf8034ea19ecdcd83a0548b9afe354d9c4cc75d691acf5b0da98da343ed1069cbdc76895b95f951f5c12ae98fbab55fb210defd128ee8bfc2799c6f1e10cca8c5c7c7b605419f701ab03af687bd3e3a02f0ed7333b376f46a6ec2e27d87ab0128d7ac12887eac26fb7c323458f58b85a1c132ef1a47e1e0d2dcc7f26655a11add6b83c167fc3a0a7587ddf8fb0b7ddc1f1e0d838fbfaa0155e969d513c4554229d47313a19fde80ab61ef5cf"),
	})
}

func (s *drbgSuite) TestHashGenerate59_SHA384_11(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "cc16f7c25b9622d7cf01aec7f9b591ca7c7cc632d406ef91274ade219169863f"),
		nonce:           decodeHexString(c, "554538c7cfb05406142b17614b3534f6"),
		personalization: decodeHexString(c, "18a5eb7fdbe463e62188e7f101ded716a6f931c98feb0c591ff46c484ab37498"),
		additionalInput: [2][]byte{
			decodeHexString(c, "072073aa01a786bef9e8683d459ca1ff801a783079e7b84c8873f88fbd98dc97"),
			decodeHexString(c, "6784e0a93ab55e76df32eae827a7761b07b67d0816c04874eac024527ee5fce8"),
		},
		expected: decodeHexString(c, "c8eff9f699bc3393cbe96f4c0b16f4101647e0b04d8342b45fabb372e503f7f757032b3383ef3ebd135c934d9fb5bc9725d624fbb749485b4a5153259e85f66ad32fd780d7100c085086e105d2cca9e60de6f78747ce459ffcd1c607f68bc884bf910cf95e2abd960b635d2661d89a13e37745c10db7f4040d20bf36719b58cf89c7bb4e53b4392ab890c8745f6b26201ed341494cc398b9652096f69fcf512dfced15088842549e14851922e874521b2dae77275261a94c7ff096ce93598fb3"),
	})
}

func (s *drbgSuite) TestHashGenerate59_SHA384_12(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "85d542f5f5d5671a1f9bb22a9d95b6eaf56556ed6130f4f5cd301420397a8286"),
		nonce:           decodeHexString(c, "8434d2197f7cc2635de79cd20588d10c"),
		personalization: decodeHexString(c, "1cc81c3a8170b34f9f4a562749f677044dc6e9f5e1c717326a47169f91559362"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8e0fa487fe56900a3fffdf212030506d4e4eeb2d033ba660a656f10a9f3db146"),
			decodeHexString(c, "2d5532072c4d5740802472193b51cc282add5f191b0464349401863d28ec4ea6"),
		},
		expected: decodeHexString(c, "b11270c27b2b9e709bb64bb5bdacea40d8cc15d4ef38a9bae293d4b521d32661203b2188c131dfce2d8135cd79ae4f5c08f1e5a40cb7ad078936e2437f17d3de86bc6e3402a0c63f660766ef5b7e7b06e4fb05feaf01d15be98f002b7c9a9dc88733b1e9bc84d2e74af30ac855b78e105c325355845dd5a9548a7ee7f8afcc37907864bc586cd1a3635840b5a6ebe071d34d7d0688905e5a791920b8f66f257d3cdc4999bbfc6c0df5b4e259bb3cb0795e005cbdb35d1637534dca076b5cbb27"),
	})
}

func (s *drbgSuite) TestHashGenerate59_SHA384_13(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "253faed3a47cdc300773d76fcf43ba1d932639b6db6f0780f77631e6a70ad36f"),
		nonce:           decodeHexString(c, "97e289fa6c6511fef80c7644d0abaf6a"),
		personalization: decodeHexString(c, "4ddda6f3e6d726ea0329a011c0313b6683979a7ba8446e85981d454d3ed900c2"),
		additionalInput: [2][]byte{
			decodeHexString(c, "330d6b5ed6e0fb830d5270234904564f2920f1d2a60476dc79ef2295e43e1a70"),
			decodeHexString(c, "8f1f018f1164c4e8b05386294ac97eae52824abe0388ad1bd4f4dafc2eb05fd7"),
		},
		expected: decodeHexString(c, "a53301d45f17bc6c89017c1bf97587ab31f4916d0056a2961705eb8d0d6024b8366a88e604d1883f9f530a9f4f187e1d3e523cd7a03ad86e2abceaf59c8eb279044a60307bb13c1660594835396fd3852deeab551b20dc572df37e0689b176812aef1126a3807fa313014a1d24e7a456bded4b343c24ee5a3a01557f27e7d030e182a0a285d1498a577c5e6b12bdec1e9836e3692c228f513e86d7e95e3dc1065d08a0d2bda698be78ea0b2b7f6a3497c0d5ee6b81c94586beb0fa027a8669b7"),
	})
}

func (s *drbgSuite) TestHashGenerate59_SHA384_14(c *C) {
	s.testHashGenerate59_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b2e7ec92eefef5d32b32892d3aa2b65e01d305fd4bc1da9a37604693529fbbb0"),
		nonce:           decodeHexString(c, "1c2c282e101c24cb7a95d017a03ca680"),
		personalization: decodeHexString(c, "efbb618c2b16d52e4e47f557888e6e035717e71b1deeec604eddf56582649251"),
		additionalInput: [2][]byte{
			decodeHexString(c, "fa32817ad83c85b594976eafab28fe25c45aa74d0ab4750b33dbfd88361f9dcd"),
			decodeHexString(c, "2e5cb3c7c9503e019b3383eb6264d6000160c3c99ee5700e7a92433da1c01f56"),
		},
		expected: decodeHexString(c, "a7571c1afd3d1dc1d3b28dbab54fe3514a0ec74ccf999376a963a3820474cdd67b190551ad5b24f4376633b4964490f79a94059a55b967f8dbe58eb20d70f1fdac91565bd8daf5223abfa13b132a140acd33e36f29fe1b107f62e6c45a679247b80c0aa050f1c2d3195629baef7422b72fb3cfbb82a2e4dd1966b1cc27b8e6df1907fbd6320f25594e1eff912cd9685755473b908e06fd30c4359258be0580e6bb2f986b0450d53fdbfefc3bf06c0d80648800234100af755acec4f809c39f3e"),
	})
}

func (s *drbgSuite) testHashGenerate61_SHA384(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHashGenerate61_SHA384_0(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5f085635d4af1d4216f8f7475699380378affa49cb7c66ae95061c2ca1f53b85"),
		nonce:           decodeHexString(c, "b1317464462811438bc59ff5be27c06b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0f3f41382fe8f99ea64ffb2edd5c826be69898a519458ecba98623f2e2400edb"),
			decodeHexString(c, "41c6f4a8cc860a22e1545555cc50d8f8ed132b3385f7b8c1321cefdfe446051d"),
		},
		expected: decodeHexString(c, "d7dd1e0d38a8e52b988b7e208f01c3ab4f9887ac645df9b8c140c3e63cbaf6aff412057bd5c3e1544beacff77c3546085e24b30b27cbfca573394088be592df7ce4fe7918839476e802c97430833501a533ae69bfc58c5810a5691d7a14b0398d92817e24881dc6dcbf255801b629dbbd7ea3ee2440a0ebf1e762b71f44af8c0081a711818f246f1e0144416ef5cf56369c8b96f20b1ce3f2da20622d7fbec28b29fd09d24a2a2d2d2d56aca643340329a2bed795a9adbbccd40829661c301a6"),
	})
}

func (s *drbgSuite) TestHashGenerate61_SHA384_1(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5fe0188f578f6900174af80a2161d1a572c470a147d2441e4fa99dbc2178e8a6"),
		nonce:           decodeHexString(c, "06ae3907f4f7d47311e00fada6575d3b"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "d6f0387df3fb9d121a7e6ca908851bc1d43a3020ab8ee04bcdf57880f857fe26"),
			decodeHexString(c, "c10ae00ed2e53c045f3115ac10a796d3419109d8a0e5530413c179814925dae3"),
		},
		expected: decodeHexString(c, "86e0234d7d7e783d39d472425e770f62e9b3cfade4afc770bf1844b8914735a2115bf670af0f6dca2ce045eea63b951ab7e0763237cd1f98ce14a68d2fb653c33d6ddde96a65fcddda94b738c411a73b4e976b57abc9c1a77de67242f5ce00fcb23fe7fc6699ca250596d3e80757c5ce588d90118e9622b37d20e9dd259840dfd0826aaa61958d8df5cedb4fe2beffccfc42c465630341464320bb7a61c77a6e51b6b7f9f0e4fe0e518a5aabb84167dc31403113edbc8a0aa89c5a49fdff249c"),
	})
}

func (s *drbgSuite) TestHashGenerate61_SHA384_2(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "04e8408191c64461062e513951dc77be457b1bc273e214e00dd3fecf853658d3"),
		nonce:           decodeHexString(c, "c911660eb58098f1bc08bdba56e911ad"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "976e9987da9a03ff06e1de2e94ce4d777a09a7eb3afc0c46fa357e1ae7c26a80"),
			decodeHexString(c, "c21d79a86561879b21e01d33e94a71e230eadcdb49779a574e3c76598d2aaac6"),
		},
		expected: decodeHexString(c, "d3f33737fd112a8c2b6d674183f34317a7ff2ca4196982f9cba04aca0cdc3a3d2fce3a93c6ffee8439a7238c833572f06521c74471b31590d5a7cdeb6d2fbab57bb3798713900d67936bb265bf9caa5bb833dc652897d8ad052b06356ba9da97f37edc396fcadbb1b47632af0261b4df287e801388b43133d64a93fada91d4eba88635bb00548d24be99f2f480c3375378279b16762ed10b5453e2724a8beb298681dc90413e706bdb152d08d2ab633e9dd8dd0e63f5d47075dd4533dbd5abfc"),
	})
}

func (s *drbgSuite) TestHashGenerate61_SHA384_3(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "add2fbd036fd0916cdc65e0ddeb1d99556e09a8b0980e79119c088377668769e"),
		nonce:           decodeHexString(c, "09b3d33f8b126cd00efa559476401f10"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0cf2c8210a45194c20f2068a6b1be73ff278418cb6f3ab85079e147b1a2e3ea2"),
			decodeHexString(c, "a610f86fd389413acf796457d2c7e285393feecbf4e18285cf25f4adbc839732"),
		},
		expected: decodeHexString(c, "7241bce7a3de33fb091d01804888d245396072d8f8ecdb6ddcf535a745494260a5462ef9fe59002b7326c47d0cddedcf2d7f959b790a8ba4d4c4948d2c1c2a95f10c55beeeae785e863a252e9616bfda5c0c3ba3a5f3bdcecd4e3a4ec7488e76f7937797277f1f4076db53d35f01f52f864d319a504f3b6402865836758410b29b68b08f1564e83130f799cc1ea5df3c06d9744e4b78ef8386d4bf03d24037054652faea3fba22d018b868243b47de682105b004e2c6b5e3b21c6a0729ec6cdc"),
	})
}

func (s *drbgSuite) TestHashGenerate61_SHA384_4(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "87d5f880f80b99890342e59d3b85f80393ed0775a8d4b8ae7a5bf8db9aaddaaa"),
		nonce:           decodeHexString(c, "c0feaccb3fcdb3054f3a6edaed14202f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "eb93ee435cf552c75f0a0b86bdfdcb3170e1163fe433fcce0eda1a8fe2dbab80"),
			decodeHexString(c, "6f57145a1b51b26fe1ccf12697fd7d23c4d88d25d9fb3f5cad111bc75541d6cd"),
		},
		expected: decodeHexString(c, "29bfe06b883f6755510bd5a3d0dff03b738b6e9b6ed8404eb414d216b764b80cd4188e2b2464fc38988bfaaab14a9b1f2a606c5f08acd65afc998689c507e8ed2ea9be294076a6b10e9d265e816a4cfa696af39ae21800b8e09f36b767564cf734ae707e5baf665a21f48469b46b8b538e977ca3e9f18b30ccfcd59146826c54c0668f33310f8d698f2d4a4654a9dec2ca84d5039794472c252a45be06b321c013c8d527ec5c49f15894808dc337806e2c283637b7e6276c6f4f5675de54366a"),
	})
}

func (s *drbgSuite) TestHashGenerate61_SHA384_5(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "09e3acb7d872891027598067a5814755c4af34308df758da89913938fd298024"),
		nonce:           decodeHexString(c, "0f23249457b52b73fbe00f9a77ef1117"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a54d0108d940df646b44b06a73781d370d62785393a25befbe8312d117465d3e"),
			decodeHexString(c, "6cf2ee872895735082301bba9e45a0dcfcab202fefcdc1f0a88bf0e825078139"),
		},
		expected: decodeHexString(c, "978c96e8615c0d595bc521c6e59ba1895dd83f8e62b3a689798d7840c4b904e6cedba7f9d7996c20189ca1d5490b2ac49021a7fef21715fc1c2f71e9f31897d4151b5a9692238dd3d2e802b201ce72e2ea6af7464063b2222eb618660167f15ff2f781371e2dc4ef7aad1e78163bd69125cbdd300d001e3e6d64c2e8528fabe32becc906929692f6971db3f9f987df7066f25a440aec2c9e0019a2e1298a279fb20748517be723c19c613192dfc4e390dd49f1f31985208460357dee01738475"),
	})
}

func (s *drbgSuite) TestHashGenerate61_SHA384_6(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "8d82faa2471301c176a49034a3223363e5891be7bc3c35fdca216279f2b9ca5c"),
		nonce:           decodeHexString(c, "f8187460d3724d6233a3506b36e8c7c1"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "007f8ac83c3208948b0011d70f95db6378a3ba7597d92856a75794d4db2a119c"),
			decodeHexString(c, "3b914adb57d88bed5cb70f9788a5fd8f4694d0fb977bfebe60176c51e1f70246"),
		},
		expected: decodeHexString(c, "6c771ec00fa60496cc3684729b7054b2e539e285671bc5ab3f6e3f8b80bbbf178926b36d94cc6824506e9d920cb9988bfd025d4b122548609c9d9b306b7ffa0f6edcc2278cd8c536abf544ae2d21df23483765f8931e2065a3a450ee718a32e15150041d8dadbc1c756948d102176e486b9e7516e3eed1d201a63de0a9a3e3f2e5c4751f8d77c3be7275b1c8aff401e3f45c78b9c1fd6347c349b530861a8f6abc8570cb10179843e422e0e1e8961af24107fd6052526096997b9609499e499c"),
	})
}

func (s *drbgSuite) TestHashGenerate61_SHA384_7(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f933b5a23efa112d1e0e93d391aae55015beb2468786929d9d1d45c2b20ed6b9"),
		nonce:           decodeHexString(c, "7846542f383c388356fc4fa1d915d337"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2defa8187afeec70d0a254f34f75e180eeb107f9401739789fa57adc7cc211ac"),
			decodeHexString(c, "194469e824ffd7db69262cb3a064d8862f82abc54f6bb10b874ae6b0893d0baa"),
		},
		expected: decodeHexString(c, "81c5edd27c390ea387550e98c73c8ec9af0f433ace2cee681f340dca16cf3014db120b5064974aa0aa916091259d4c2422c1be79bf599df4adb5478c5e27816c4b7b3ba16590748083c1f26b00a732ff1df704fa2d07aff4746aeba53145ddb6078fb91734a4f1716d1bb91a4f1dddc27f0d3ab7cc310a90efa7fc39e8ede8f4143052c503731f4f1cdf825e3f1ed9c457e38a5473808d3a03e237c68764dd32a6d9667201a4e004fe072be3de158d332314487c2c619a483cc7a900119d8f4a"),
	})
}

func (s *drbgSuite) TestHashGenerate61_SHA384_8(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f4c916fb51e2fbf5237b4ad80b8fabdd86de22a4c7fac26f53b6082a62230f96"),
		nonce:           decodeHexString(c, "48fc31900aa0163f4a22ebf64d31912e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "dfabec14fc04c54c3654e08bbdf9eedab70078fafec610082bd800ff038b62e7"),
			decodeHexString(c, "5c5ddce832d692e3bdea8c72eef7276e3f99bfdcabf5388f4d3fc709bca1320d"),
		},
		expected: decodeHexString(c, "1c65ac44cd9c19e50e467649fc280903f176f37f3a870b9f7bb30f173e0acc736e8f3322cc1b1540189ced5a82b8b3e716012fba421ef39918de623f50bfc697abb56a034ccbe465d3b39cc6d305ed58eee98c539d7e77e6fdef520ed54b933ebde3c028e36156bdb9b3612fdff6bccc0c4524e3d8fc12439ee4f05de67c65ba35031f07100425778e9b9bee56e32d66f880cbe95e4af3050a5f61dfb86db936c58df7b2b737a80ffa253adf4456801f2ecacaf7f15068a685743be67f86ef29"),
	})
}

func (s *drbgSuite) TestHashGenerate61_SHA384_9(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "460fe13f8904f0e13caac6d00ee0605a74f4f8d58f8c9c6cc95fb94d4e181e4e"),
		nonce:           decodeHexString(c, "32ea29d7fcb4562e69e07a8b5c8be146"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "1cfd579a0a37f5c1a5555f4604353c57f6e10a125d2aca12ff0185a884512cf5"),
			decodeHexString(c, "ae1f19a9c43af40edfe61fbb778c13e72bdb2005d819c6d906d643393039b260"),
		},
		expected: decodeHexString(c, "79c4e16ea48251f6738d657b537585712aa4d882b483010b9f92dab4aa749ae29db2081e6d04a5bbdd9a4c5fe61cc4617d9a16fa815adcf530be39d1d3ad843f3fef9b6299fc58c88514521635cd9dc8cfc26a7973369cb090da50b6a1d6cb8c50e2e0fb90e96585a974edcee90c4c7c6792ab7dc5d10404ce31fe55fe0a0377ea13574e9ea8e9cba7547abc2432126d013bfbc27dd7de1a46241e2e15a85b7776e082b0c5cf76171a8f4a08dc395695feedb8d46eabeebbc2e3da07a405fe6a"),
	})
}

func (s *drbgSuite) TestHashGenerate61_SHA384_10(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "725d56ede85e1f1239df7adee388edbf0c69af3df69b60a250684b6b4801689a"),
		nonce:           decodeHexString(c, "c156af45d6c551212eea7fb6223a9c15"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "3c95dd25d31357eacd11117e3a44abdf6f0d3283ef16a4bdaecd124776230919"),
			decodeHexString(c, "7d7028f8a4bd307d1cf9e113bbac18bdf45772953190cc310080580d9f402d82"),
		},
		expected: decodeHexString(c, "31a724c055ff1668215946ed5a4b492aab198851280ced1de4f57871db31af69447086eb0b9ed1ffe77b771f08f67daf1c9526edcd4d4294759d80da8aae559590df5e49e0e54e53cfb2cf57316c7187af624fb86bf6fe44014b0579dc5f7f6ac3c5b4c95710e3e61882e8289e17a7081d0710e90c6c00fb2a295e1d6a1678d45ba12d4e5a039860e6d22c20328f4485bbf7737d57667acb15df6f3e010401b6ac64707ef6732b60cbea347a9b229547312ae90d701966e359b7980e9e2405ab"),
	})
}

func (s *drbgSuite) TestHashGenerate61_SHA384_11(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "708dc47c4af4ccd27d82bc7ab1da9a76f2daec1bcfd3fc2398daa0d6bd93611a"),
		nonce:           decodeHexString(c, "638ea30a5e5faea1ac2c959bd3c63f2e"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "5312decf4e3057949bc97e2d159ba6a6ca94aad01b6368b821a1e0708fcb88c5"),
			decodeHexString(c, "a05b03f26a49cd5e5ccf72e18b1542c7409c70f89b171e0cbecb260fbfeaac4b"),
		},
		expected: decodeHexString(c, "1f8d39a247712188d1f7fecf29897c5c4c4ea6a13f1098ad7def578490e1051613aacfe216805b63a5164bf34b67b4580391825b3200ac500b344d10030a965df6df064df95b0c1313acfce73a1b93a6994c833414b4b3b8071b96988121cfcf4c89a03ac16c5bb189dd12a9d1a42d4463dac8ce0296bbffcef917b8403b85b6dc5b94bc1bee9a865283ac02afeb20fa73da4ef9f3716ac6d558f76aa8515a0980e75c189cb836e02c3a0b2fb7dfd9ecd525bc4bad0498d2076ce94882dabfaa"),
	})
}

func (s *drbgSuite) TestHashGenerate61_SHA384_12(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a342fba3f7a2df8a8d25130c5706bd478998aaf8f02646824f0481035874568c"),
		nonce:           decodeHexString(c, "1a637cf494acb59084f600c18233d230"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0cf52f8ec7f53445200308ef04d24152ade65f8bed4bbcb4927d64cf2a0e78bd"),
			decodeHexString(c, "76be4a79c72ebe2d51dced9254f3cdd52ac20f571d323f1dfe6bbac829fdd740"),
		},
		expected: decodeHexString(c, "9b631cb56d5b8e07b1e14111c8a6d2485e442ab39af4b22f4b55ba1a7210b90682ac6d552531e35af6d8f4d659eab41cb89b581756bf12173eca35c3b2324be8230778fbd51f1b5f42f2c1ec8d3e38ee13b60418b0c82a8690822b62f73b1fc689214e9a33a90fff4a8a2e8cdfe84866baecb6bd19984752f8f72cb5346d8a68b6eb0bd2e19d698ca6016e6819317f23a3038416df7e72ce35532aef2f1428dc6127213dc68c06b26ebfe1d7bc0c96fc89f7e75a8353a279f5377bfb2669a085"),
	})
}

func (s *drbgSuite) TestHashGenerate61_SHA384_13(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "db08f992d8ecb7037f7631342da4cf771f540d4c50a0c09d3675ba670ffca750"),
		nonce:           decodeHexString(c, "c7972b4e81f028ad5d640f9e0995e830"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "4a2d43e01405bc9734a70e2f6fd343289c33ebbbe68ba59554d6f16344b2b419"),
			decodeHexString(c, "c580567053d8a0eaa818cb611adfc1b571308c0fb437cd84d11a4eb80fe752ac"),
		},
		expected: decodeHexString(c, "20e716b020bf03816f6bd2585b03529c8c258bb583450d8c47b89a3706ee488e8e3d73429be19798c69222784533239b973942d19d048378a58c6e076d9e223beccc32722e097b3df774018400bcb963a3319cb4889975755c422fae5b9bf504e59c341354276e5decbf3c279a4cceeae6eb41f0abb6c1355938e5d0d865c27bedf1f33a1accb70c7c6fcdc97be324ee3a86b93685f640d92eb9458d3e888e273a66e30cd98f8c58bb88c1bb1c541a525e62970875e5637a59ef24ce71d8b403"),
	})
}

func (s *drbgSuite) TestHashGenerate61_SHA384_14(c *C) {
	s.testHashGenerate61_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "0ba5abb25413c57b2d4a6d673bc03360c5ce1df9cc9fc8cd26f8ec0f4ec87ecc"),
		nonce:           decodeHexString(c, "35bcd2d6a138d4f3989b98b60632b7c9"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "7112823304b16377182ff9aba920c97ec4d4f23cd472fa9954ded16495d23f7e"),
			decodeHexString(c, "ba183a035635d9617bd71b59fccd561f1c78a7589c7fb3fedf41dc2e6d5015c9"),
		},
		expected: decodeHexString(c, "94e577e5c4f66be345c6be7038b02fcfb4070d5bf74f8004b59c279cce961dcf5bfdce2f01e007790cf770587a68d0d24ef0fcd1a148fca6920e707289e58b81fa4a58b5a018a358d336a20daef30b2881844838e51c56f11533b25c77b9c6c6bb2c0657350f011b24db6c60a84232dbcd218a816563737585c1ca6152ff13304ca86dff20f9f9596aaa21448f2c6e620eee58f69338e3b675d29b478f34f0e60dfe7f12f02e6181d19185f7dc945210d86d31e85eae03161e947fec0f0fc91d"),
	})
}

func (s *drbgSuite) testHashGenerate63_SHA384(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA384, data)
}

func (s *drbgSuite) TestHashGenerate63_SHA384_0(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "3367cba0b8f854e4d070ab8c7aade94fa952211c24b0bd593a6ed039296fc8ee"),
		nonce:           decodeHexString(c, "522ff5bad7c6cc6b3b75c217fa02451d"),
		personalization: decodeHexString(c, "160987249e693f453e084592fd889fe4af2881c888922e7f655f9980a2e42b0c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0bb082e1aa49086fcfaf99626560610a296f56072ac2129761d4dc8e7fd16616"),
			decodeHexString(c, "f92c004f6ba57517dbc7fa0ff0f21b89fc429240407b2f9196773ffded8847a4"),
		},
		expected: decodeHexString(c, "6b0a99904c5c172c56ad8bf9e3c08d28245ddc8934e3e494219c8387ab9b895d46f031e50a3b200892ae6a2fb0876fb60e57cc30989eae21da130a381fdefa9afd3ff78bf68a9ee8ac6c3619f2343532060ce7c7560f88da75170914f3b45913324fa8aa8ee85107ab61833325ca4aaa9caaa8f0e98b8c18da6739faacfb55dccc344191f94b58293fd1454cc8986588457dfb63f7e53206c09e07f423d06b6d77928d426426b318b34eba140b0a1e962b36871d9190a0fd9e7b39bd6684f52b"),
	})
}

func (s *drbgSuite) TestHashGenerate63_SHA384_1(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "b0b77fd8105556f7d2ba75ec05a1c572b5abbc8041b2e0c2f39fc2675227e653"),
		nonce:           decodeHexString(c, "de9e21eba0b8761f3b39d338dea7e62b"),
		personalization: decodeHexString(c, "cc6466b6ced020b7eec5899fdb4e9ba942cd54c0c41ebdbff769c39f235f350c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "07e18f9f5172dbc2e135b97d57a7da9a2adb0401327976b516a79b8e5f21c19e"),
			decodeHexString(c, "9c4dee11861ac4c4dfbdbedb9a8e150dd3c9ce3477c1ed31d4637a5b542e2734"),
		},
		expected: decodeHexString(c, "0b844db9a742ddb41c755d872ae421331e7e38f960be8a1a9d3a294bac5868d9e60cfaa7591523c9a353d409f9c75cfcd197bf3d7626db8333e4ee15195e6bbbb92c18a2b89e6c2d1419c85c3abdcedfb995dc73d87c5005a842a7d8a8e3a9306690f289de2d4124be6a7992579642e707461d344b3e62cc7fcb8a38147ac55a8bf39c3a4483168e6e3a068fb8720755e9117354cf9f42be654508dbeb7c626678091be07ba9a69c375f76cf6a81658176615a7b08a3f759ca4d8aada9cc06b7"),
	})
}

func (s *drbgSuite) TestHashGenerate63_SHA384_2(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "719e042c520c191cd66904eb45a6a31bc35823243a87d6aa694f46977556755d"),
		nonce:           decodeHexString(c, "0e7a1f3ccacf2d809e3b785b0cddb726"),
		personalization: decodeHexString(c, "9dec818051541fa05260656422e45801f216122f402d512b2bc073f9de847c2f"),
		additionalInput: [2][]byte{
			decodeHexString(c, "7faf1236fe5861e3eb3a60119e8b3c385ba0b758e56f5a833d0a2682c00b3eb0"),
			decodeHexString(c, "7cdc6f00a150165b23ccb1dcb278e34ac915a21d5a7ffa4a7ef1fd19307edc97"),
		},
		expected: decodeHexString(c, "b616ca393de06d6a7265e179dff284e2cffe8d460f97eba744293723e96dc78f2ba4518aa6a8259eec8f119fcafdddd3ed220079a5a121e571a7339f9a4d91b114bb29ad409ec2d99cb7849a2c5ab1f3a6d12e8a59f994b8b050e1539f4f69258bb87aaea49a1b90d011fe3585ea2c337511f3848a54f8ce6ff0aba6d37ef1f80596024660408ee779866adb75b2502fd59342c1c8ad074216fe0e72489cdc0d0a1b6893b6b55831fd93ddf7c7f65da27e9c878313a6639e18553ba5d912a01a"),
	})
}

func (s *drbgSuite) TestHashGenerate63_SHA384_3(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "53e1f9ac699031b33b16d55bb021e648ed8a28fdc3fa85322fd9502d2a84d518"),
		nonce:           decodeHexString(c, "59a039426593e41f396728576a8aca70"),
		personalization: decodeHexString(c, "ce18a5c3d2c6b59ecd716fd5f265ea8b4da4289d7e01cb1df34f772e3caa4327"),
		additionalInput: [2][]byte{
			decodeHexString(c, "721894371f14a98d6d86ab96862784e291d1a9e1308ac4deed9bc6f86425a83f"),
			decodeHexString(c, "c118a1a94ef21cb55db1a4402ef742dd71ecdecff420c0f11560ebe5e7104669"),
		},
		expected: decodeHexString(c, "6de0328425a72e2609f602e26b34324c11eee4fbf71f0e8a6b975c6f28828faabda27c45f905a769b199c16e64a98e82eed115980c2bc51eb3a61edf86e25e177e397c4665e65b3c3524010204c500cf3ce4a7280340a2ed4a57707c9c826c0f19aee2b3bf372d60cfec73b448bae063df55f8984d482e083a75c9b351d58a8e22c35409826902182926b645cf6a31243983ac9c7a274bebb44df8750ecb6574cce2484635b9dcb4a4e376a74c6ccc7260c283c148e9653144c6015ac05422e6"),
	})
}

func (s *drbgSuite) TestHashGenerate63_SHA384_4(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "6438ac32e88b88649bfea19571d7ba060261ec79026b05b816677fdb67398bf0"),
		nonce:           decodeHexString(c, "344b242d90e019934088688b776485fb"),
		personalization: decodeHexString(c, "c4f6966dda5fa6d4db09514926ba854e5a6c1d6b993c755730245bccadb5852b"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6ff7bf01fbe5a8e2e37b1b3b5a48797db4b7437a018feff8c8a362b68e253d81"),
			decodeHexString(c, "91e119ac3172d26dc7f6766a032c278c76a2115370e27da299ff4e4c9c1ed4ce"),
		},
		expected: decodeHexString(c, "7f9238ed1578762e2c9eb70209f429e8b9d4ac874101aad11bdfea76fc9c10a89d63ddafc02bdad6da82478102fcde4dcb75c869350ce82863e4b0c6a97c58dd19ca44d3e1a681e6ff9860f210f01eb786559c2cb96b196e1f56bf44ae2e0c995a1f339ec64404b060966ab86b0153708e5420e76a77edde266f17bf8931c6213d7ce678243fc8e9384df82546b5f00e6bd473c0089d44eec8f6fbff0fdb373df4a15f0d5a6006d9bc8b3f266418a5424af2d515d79926da9ce92a0414f6557b"),
	})
}

func (s *drbgSuite) TestHashGenerate63_SHA384_5(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "10b838c9514802f9755a3268e48bd5b5ae658f281b1a09b7f991b70f621ad90e"),
		nonce:           decodeHexString(c, "e35a4496b07dfa0f60c3bc7f6482f86a"),
		personalization: decodeHexString(c, "d960b9a4af9b5a3ae7f5ef89743248398886739da826f3f016cabf4f917c0226"),
		additionalInput: [2][]byte{
			decodeHexString(c, "0101a6605137fd0144e3a337f9abc2d345f474c429b4ad8ff02a831b61c7cab1"),
			decodeHexString(c, "9828206bbf49e20be0c59d6dc15bf41eadb9207b65ba09bc5f8b3f91a26406a1"),
		},
		expected: decodeHexString(c, "aefdfd6ec7f193c144c87a01e28bea811e29c809fdbde5d3105f8f6b42bfdd20986d3fba93e3b93761edc708d434865c6e0734c09984727048d3a22f2a91233a8282f6cdfe02181ed422ada52efc9eb83a78185f1c20f70a0df37277d6908b9a8d25e1651bb7e75a6c79f3bb556a18217bb2e2f9bd820672698b4da00afbbd7f4d8539ad935b9292991cc95fc2cc0d8f5cd9c4e46dbf0866ca6f9172959afff2ebabe01554baf93ea228fe8915e3ced5908e11227a13be93e806490a0c54ee2d"),
	})
}

func (s *drbgSuite) TestHashGenerate63_SHA384_6(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "e11ec151187fa63eb594726f36639c151ff6838b48f594ac9a213cf44c8fb88e"),
		nonce:           decodeHexString(c, "85d98d8fdd7e1ec7aed2a0f388662467"),
		personalization: decodeHexString(c, "59298aa898ca587ef9c12c0210541dc84564f04cff157747a7638d64cfc859f5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "8570c3a713f75e1441c6569c64dfff22c3d7cd4c5c0e3e20a52b6479e43d78c1"),
			decodeHexString(c, "c4befca8e4ca28bee4baa041c568b6d61afe88871ff31568684c319143c3e994"),
		},
		expected: decodeHexString(c, "80f4357149ada605dae89e177da4150f1aeb8850887551140e2bfa43491f4ceb0b0521f44a6c6938ec9b18b903438b7b7ff260831f28cedfca51c67bac0ccd40036c1cfccebaabbe93194bb6dbfac7e496e1da870e1d42ece5edec338d8e27ec9a884edc5176448c453c0aedb4dc5de7a707dab7259a31f2eece410be6e4caafec619c445c743702d14a6935b472ea7033e5b11237c819e9c6543e0816fc662f79d84e2cf47a2d6cf6dad74326da745ebd0a51800e9a6a47d3423013859360ff"),
	})
}

func (s *drbgSuite) TestHashGenerate63_SHA384_7(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "597dcf0f4f85dc1bb4b3cafb22de583cac96ca661e4f06d8784f695b965de45e"),
		nonce:           decodeHexString(c, "0b72e52811d44a40746bcd804e1ace8d"),
		personalization: decodeHexString(c, "36c78d2c4839a1fcba7364a1a6baaa89c493417b021d576682bdbf1a02b69b56"),
		additionalInput: [2][]byte{
			decodeHexString(c, "ea94293cbc27dab524c070e30ec4eb0be646f09feb77ecd2bc702d518420e1ad"),
			decodeHexString(c, "7f64490bb0ae24c93b901106362dc086a494c3f11f9d29bdc48d407a0ded757f"),
		},
		expected: decodeHexString(c, "b7c6d10f36ef924886827954850cc292ab2979323ff1f7cedb3b49222355e2404062db45a739b264bf94b85f15bff29adbb17bb4ea24bc3eb3dda163dee4a267dff1168aa30cd288159636c15c783941fd2e81699a8440469add2eb492de6a5fad7654b111328d0e9bf320a067873f948312bf69a532471aa0cc7335cb313bf49226aabc47b27f5dab9fdbd33b52ba3b7917dff009665a5b190eddd376312970e583d38f287fcfb6e535a745beb9747f6752c722b17a464097cddd0c17d7fb34"),
	})
}

func (s *drbgSuite) TestHashGenerate63_SHA384_8(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a84fb1a153b2fb6dfd6c8c01050028ed6ffcfda7438fa463dfcb6088424031ee"),
		nonce:           decodeHexString(c, "e8ab86143a21f103d2379ad2afdabaa7"),
		personalization: decodeHexString(c, "a061161d44625d4bc00c369eac66fd3690c7c6468c3584ec272db8e54fb09229"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b0f2fc219591ad6f67d3c43e04de22740fd63ce367a2685b1c591574b53b1811"),
			decodeHexString(c, "08c623db0ca9d92d493d306aa9c3c952ce2e15540c8921e9747aa3a36e5548f3"),
		},
		expected: decodeHexString(c, "df8dd6d322da1b88432dce878f10445f86efc23afb3c5200b392f5175f9d474cfd38005da15a2f701fe6fc8a7c9d69c9e3aa08e59e6c9fa414708bf0d40bad1917f1352915669f1a2ed8fd1af2c9edc75ddb66b568a8b8b44acefdcdad531832f452bc7e38259f7ad8f7dff1121ad0aaf97921c6b5dd8281ff21066513dd82718e8643fcca8ac51e3afd643d1f964a32bef160e44696de970022000a56d7154c0243dfc4c93ae79e17e3ddde4d885414d38def6dc16a4effe71167b3c1e4c1a5"),
	})
}

func (s *drbgSuite) TestHashGenerate63_SHA384_9(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a9b7db709f62ea96c92bcf593e08a67eef7123657aa60ee0db4fcb8ca35b01d8"),
		nonce:           decodeHexString(c, "3a6b2e969eb854705fbe64c40566346d"),
		personalization: decodeHexString(c, "1ff077215892c088e02f40e314b6cb8c3c1bce0d221acb447bdb7a27cde438f0"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6aaac8aa93b3e7e18ddea7f7137a2b150e68007c4f7e49a71af05f9a11bb46da"),
			decodeHexString(c, "a31e16dc94023a66d5cac7abbd99e12910b348cd86a4534ba89b6cbcfdeef9e2"),
		},
		expected: decodeHexString(c, "fefa6160da2ef6f934afd80507c05d4630addcdb325431e17a34b77262b6cd0614968078c3c757ac8c3ac7a013bee5f88cefd5820f02fbede8043a75695c4e3c9e087f32ae8e3cb0335e97f8983f4fb82d19d8b6372e0230401fd4e4a07712139a8ce1c57e72d8a734ee272120102a033dc5f5f656a034aed999e4cb2f4f592e1d7f2e4d4583937d7caf634b6e0507b1b4ad10e0ba16d44c1ccdbcee8784a6b65f58dd4ed768e9ce42e1dfc7d9bfd9d1528099f22e221d95695616320216d2be"),
	})
}

func (s *drbgSuite) TestHashGenerate63_SHA384_10(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "f386e0016584a36ba37014c68095ffe800d40e7b670721112a61624a791bdbce"),
		nonce:           decodeHexString(c, "a967ec6cb6fe0aeb03472482a937d01e"),
		personalization: decodeHexString(c, "0cd17ac981337a77ee1a476e747380a6702d8d5cdc9a4bf3ac433cf19dcca887"),
		additionalInput: [2][]byte{
			decodeHexString(c, "001a0f2652ad16e0bf515facc33e440906b7866f13310377ce76b7158fa2cde4"),
			decodeHexString(c, "a06a08311bfa08be609dee9ce0cef830bd7ad917af6b825be35256b0caef5f77"),
		},
		expected: decodeHexString(c, "50f6d93f2909fabdd9a4d7ad2c1eba8d970cef68dd00b3ae537d31476bfbf4fe046912465c546a8bf10da18dadd9835a10da49560742d0425d87c61a2d6133e857c70d11d0f54152ba91d9462a2c60dc79f65927e56dd7f9ad77dcde97704dedf253189e066deee70ba4d938e9c31f68dbe5b5bafd4c00ce72f78ffb714f6a9490507a09102fb32cd8aa40a4869324142f1cf5b01661b8bfe442111767cddb7d9e601fb1df7f510f2820930776253805646948932e72bc2a4e69fea690d2977e"),
	})
}

func (s *drbgSuite) TestHashGenerate63_SHA384_11(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "a6379c0799535e100d1092c675df9ec321b8e5490bd9410c3f7449a3547615d9"),
		nonce:           decodeHexString(c, "5d32a5226624a29329471de262112b93"),
		personalization: decodeHexString(c, "b7221d9819e0711d77c885aef71cc4204c730f441116c3893ceafa8e72d83b72"),
		additionalInput: [2][]byte{
			decodeHexString(c, "b222c369619ef10ddb6d5530770416408d22901b13c3fa3c4b381e6b05e79862"),
			decodeHexString(c, "85458492e9ea23e9fa7834874d032127f9c86f0e7784d7eddf9d6adcb9cf88b4"),
		},
		expected: decodeHexString(c, "0509dfd32fe93c7c26a8550a79e6bd294cbdfd12e5c7c1691be541cf5d86419392955480b23d27ca6270cd7576009dcd3a229a6e3c4af5e48733e71b741a5d9eb1e25cc94558115d27e35ef04157d6a6bf840dec1114cbe6654eb3d08903fc0ef09636f3254b2a58c7eea8723eace3b13c5ce9b0432741b33efec2ae2fc78dc64d2a6937ee2f10fb4433af43f5c7356c5615cfcb4cc0e8fee95be59c485fc170bd1c6ad9aa15e2d93ac3f07e41c47ca3d490d5524a806dd10409d416811c455e"),
	})
}

func (s *drbgSuite) TestHashGenerate63_SHA384_12(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "5611226d073719a6af19c98cee4933de42bf513682df50ae94fa906f1da49327"),
		nonce:           decodeHexString(c, "2efa79466faab2214ba0725d1bb37191"),
		personalization: decodeHexString(c, "42277298e322e8d9e7959a29ad4d5adc0e79c5ba85b17f29e1370acc00228bcf"),
		additionalInput: [2][]byte{
			decodeHexString(c, "263fa2502697af15129db52814752693e8461d327bbac88caa3b583862bdd845"),
			decodeHexString(c, "0c66e1b8ca1bcfb909a104fb582c8c9ba85db1792b98799a3e6292c95dedf205"),
		},
		expected: decodeHexString(c, "16973645325b777c6da555e9654b58c6555ed0c6f9054da814f53f363ec9c3d28130a2e558d1352ab26e3b205f20d5f77d7f3efc93a355d346eb4e192650c905947cf6ae166b6fe203ef41a366909a7e57a131109e4a29f9229a8004a8aa55d1c9a20236a4ea95bb8042bd0d15988963029f5ffbd3b5bb2ce433e26582c0ef89a9b7ac13df7051fdf1bf4b3031aad7fc8214cc233b7d4000596cf47a2e986a5d72c2ed3e005a7fc0e70ce77b93891bcabba208845fc9f9cd45dbb5e1a79a6cdd"),
	})
}

func (s *drbgSuite) TestHashGenerate63_SHA384_13(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "2d69eab46d8b77c84aaca91169774793c3e46f508a4b6445d9549eb531ec3a71"),
		nonce:           decodeHexString(c, "10dd5a1a07ffb2d71214626cc5182cd9"),
		personalization: decodeHexString(c, "d2f3e69da5dba1e14a218cd4030d8994bd10a96539e67e6968595bccc649e310"),
		additionalInput: [2][]byte{
			decodeHexString(c, "3ec61275d4b1ec9366aec719fe46dfc075d860e61f75340dc4cc4f790a9c5b0f"),
			decodeHexString(c, "83e7f1447c53d1520d5fc9b855b61aa8d4078e85b78f8e088b5a6de026f2fc86"),
		},
		expected: decodeHexString(c, "cadd0cff161e9f787dc90d2dd1a5d3bbae6a771edd657209dd67f61d618ffee286c031247ff3d921fb24b16f3b4091bd0e1246745eefd1f79bb06ada715774bb79ef0379f37c868ddf768b85a279531badc51f9114c68a1e6c89a54dacd0b45a61ddcdb58d79ac9a5930f413a463b6bf12d52866a4bde5460bef6707f5f6b5f1e2f74e1363d93c6cdad99773b2bb2ba8a30c208112a67f7d0c0f1ccd09e554525b63d3bd16c3527ec07cfe30db3237425f899143ab7053b6d6f962be1212619b"),
	})
}

func (s *drbgSuite) TestHashGenerate63_SHA384_14(c *C) {
	s.testHashGenerate63_SHA384(c, &testData{
		entropyInput:    decodeHexString(c, "161bef119af736fd23e188a227aae76edd0fe654f9f583d75d77a3764bb8479f"),
		nonce:           decodeHexString(c, "c6e14c68309ca84788ad9f15d5f0a90a"),
		personalization: decodeHexString(c, "8b2039a6d4b909906a8794df5995fe9ea977c5a1a30982015aadf937c863cfac"),
		additionalInput: [2][]byte{
			decodeHexString(c, "23e4e6b0e0c1b28a6f9731f8b09960ce7adac17527b3bbaca7c811daea4b1cf5"),
			decodeHexString(c, "dc7fac6aeded9e17b5bb5e2bcad9424d42dc07e809da59d52caecba6e75ca457"),
		},
		expected: decodeHexString(c, "5a42b35cf1b72d2520d92719a94ef1a7ca5b6d6c7eef2de25c8ea44c1fc3a9a5ff2128f47bbe58084a0c7a3fc790626eff5666b4c1e68fb2f53de3370b29c398d5067b255f5f7f29fdb0f8bc256ee3afbe78a33981626837c55f981e56eb2e1bdd89ca081e48f6da7ce6576fbd37dbd57a3f41cf410cb375614af239f2e10218e777fb97a55d9cc73243882b8d8d2a2c812fbdeaaed90b5bd71a274b4b171cd7e661912c9b3de1714a3fe4931d8fc7cb1c9f64f4e37d4e5dbc31602d2f8699e0"),
	})
}

func (s *drbgSuite) testHashGenerate65_SHA512(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHashGenerate65_SHA512_0(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "9c96a34f68689b8aa8d9c1f6cd0fa7c6f96071caf1bf5556f45bdbf48c6cf0c6"),
		nonce:           decodeHexString(c, "885c2539046afb1401eb7a5c84dbd9c2"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cb61c4f75c01b578aa233a0bae4881c0a11527c22fe7b34fb6ae62eebcfe6085"),
			decodeHexString(c, "c066fd2eb8e4aea2e7145eda0cfc8bef5eedcc367b1cb4de7eb2c2759fa75bf7"),
		},
		expected: decodeHexString(c, "782c208ed58044e78b5bbbd8772a3caf25b47d36afeb0d3493c43e01cc66a0ca2faced2ab186bc46825d989cf8ee7c95f8c0b0d2b76e6c8590e72834d4c52445aeceeb7bf5f5d9ac44a12cbd3fa7f4462f856452dc4a929182d2388aa7635b9698a912585df7f560adc5080d53b82bbd7e9e480b00d1da5bb2d480cae2ba8c67d4bf3bfd146a91d6aab39faae1600af2ce3204cabf4c1caee4cfd5e6f8db1902033f7f8d33bc6e0e5d32a320ba735d091f30867b7cb7880c2e3ce6aada79664191df360d35fe9ae7babca41485b06ab49dff528782fbe6f2b0e74996e9ce9272d1ef392be5c17cc62c74be504e6a8731dd9548b0db27e0b7db4886f537883623"),
	})
}

func (s *drbgSuite) TestHashGenerate65_SHA512_1(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "52ebc799bc7b658e84fb2f6760d403821c2350a4fd751d407c456532b16b0987"),
		nonce:           decodeHexString(c, "fc734458c02c5317cd2e38ec1e64f37f"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "50b0b7659b736a300d9938433ee8bcffccaee9761dada3462207ec11d00572cb"),
			decodeHexString(c, "711f06be74cbc8de412a7addb0855211fc0c20d2f955c5cd0d70c2834b0c1f42"),
		},
		expected: decodeHexString(c, "bd45e9f0591371a72c8d338b1f71894e7a3d9577a7b07b1a065942aa59455a0e41afc58e657debf2a8be99c2b2d3fa6f3f9852a5100cbb687811384d995539787a4dc49830f1bc7184d58f1b9f300b19733de1b6287b6a7a445dcea1f7d4fdea838ab2039ac2bd62813e4b65618af25555b18c8fb9d591e51e902e7b658eec9fe4870052b1b07fd1fcc17d5bd18e09576993ba08dee87600af7134b6facf1e53a0cd5ea027b1eaf7bba679ec4b790d7dcb875b24414a8ab647ec759e3128fe31d8e115241189d5399b6349dadefb24597e14f75e58397578a8d2b409588a630656543ba6984ce8083a7bdf0c74661baa0807d644efafb3fbeb3a98d1c09d70a7"),
	})
}

func (s *drbgSuite) TestHashGenerate65_SHA512_2(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "3d0a38151851da5410908381af03801f73e07426d149f1822d6904b6d5fcc839"),
		nonce:           decodeHexString(c, "3603d5a8171a2e1a0adc81cf82044ac0"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "6933feb91c17f882725f5f79eceb855d34bf82e01eb9079194b53007bf3408d7"),
			decodeHexString(c, "6c1701825040b577c9f91247a8d797ae5d3fae28e07a6540a76c92623acabff1"),
		},
		expected: decodeHexString(c, "7e4cacf28872c3c322a5f614b097d766b806762e652e0fbb697112972f0cb626a9ac2e847479519b92116f7c4dc8e1884cc4a37e8041f5e18a906c97e7c239faccfb8b41d0f6b2fb196b42991cc8b4f4c35e45963182196d7f51eaf08f7a69bbe43227e3768c13527d83aea146d0e1f77d5d1c2217cd6383f7bc2bc574078d9a20754857027885eb65b63b8d51f430f7b431314b96f7eee3966474247ce91a95b2be40b2f08dae914df6a65e01027ad9240ff416479a997135bc1762b3b30b80f7d36ec82c1c0451ead1d8773dd93324141a396290a4dc5c684db96a375fd82c2de9989e4bb2d710e63c4533e62dc673f50358b41b07afb63885447feb1660ec"),
	})
}

func (s *drbgSuite) TestHashGenerate65_SHA512_3(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "44f4d2d9b078320725d5ab9d41648ad8b52f76e1f1160ae6a4956ae7d4459ed9"),
		nonce:           decodeHexString(c, "29dc8dc0acf8891a6b9bb651a39dd909"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0cb4e347fee636a60e1fe51fc0d8f1974c4455445ad0a0f009a386b2f23f184f"),
			decodeHexString(c, "f37028b7c6f5fb7dbce83e22b6ba38a1150f239ca495285cc14d8f68978b3f8a"),
		},
		expected: decodeHexString(c, "ab66f5b9283b3a6068b6d8b3f3286951221aa8c860a1995068ce2d0126b8576da410874b8b41fdf9e75171eedee86c9b58cfc8dbbfc4a1df6acb3532b6098439616a04a010e9151a9c41c67e5670705c00024d0509917da47d1d36e4c6a3fe64d62c49e90e4f2b4ddc7f691180bcb4824546351dc796d75a19aba6538b26ea99f3d681965935da7ac5205824503aa3d19ee0419a1046cf9f527621a748a5d5c3860227d7789346cc79a777a2b82917a7d100c8ef5afbc43620bca5d509f35dcaa7eb245534b214a478b73e2743c4e8818059a9e5ee72acdcc2ce8dd44180fd34bed41aaa587bdf7cd093c0e2e3d08793593e8fe2c291386c52ea773240329922"),
	})
}

func (s *drbgSuite) TestHashGenerate65_SHA512_4(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "17051ddf920da86a7f9c4ed3ee7a346b3b58ce19dfa2364ca6fd5a9021931f05"),
		nonce:           decodeHexString(c, "aec5cdd0d86d6345d06623465b6c7a21"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "b5320cbcd949fc9534c173f36028c5ea68f921e348674472c6511df59a9cf045"),
			decodeHexString(c, "93bf72dc74518bee957273b296d756b26a699e397262f53c071475d971a73624"),
		},
		expected: decodeHexString(c, "03d2f3326a467f5c09a51ef4999b9de9631138a6b68f6f4d95bf49f7ac898c3658904764c2e2bb9146369b73f6e83706b83e59e53b7af21c53652a5c3c0cf0ee4fae56ae223d431895618a09157144a653f4c6febef566766b19fc9042292762f0324ff89cbc22bdac0ada6efa2809f8b1cc5733a42a25386a7f37bb90c1397b882fa7c17ab64f65a6b9ec063ca5ee8c1b82cc520e737e600d3b41cba59f5d5a6f5eaf6d42adffd2e84620d3276fe27159b6e01a47400288695c55073f7d6f27c314f539a4982129e3afa28a33ba0b81bf9c9a9877150ef19696b10d898d888b618fb5f7a4d9709acca57b23e355c140deab44faa97cf1267f29fac85f9dbc21"),
	})
}

func (s *drbgSuite) TestHashGenerate65_SHA512_5(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "12d1f373ee85a3de0fd9e089177bdd6cfe4a9e96d4b455914adba312c62cdbcb"),
		nonce:           decodeHexString(c, "e00da64eefd872ffa483c3ae184c6af1"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "05ba1f27821a05b87d5fa56ad1ddd330b943f62f6dd4f9a749e074db5489d2c5"),
			decodeHexString(c, "a0501b855a9acc67eb9f65cd4c5bedbe47ce7b967940798255ce86dbb9d4fd3e"),
		},
		expected: decodeHexString(c, "b8744ae9f2422e43746466c68ca9d9f43d32a1fd497defeca329697b4aece6f93609564b9afadf3605832c8705dab5eb8ff02a3006b2a7a91609aabaa4807b252a1a7e641c438bd5963b3307ac65231399edc841c3c43cfc23de8a180ca337500ea402fed377d10cc451ca85a6dd2a5d4354d0edf6191668b9ee8e2e9638b47e984fbfe0fc9e46d21e57e3029a2cefb739b0dab91a450e51aecb8c3eea5e9e0a7f699ada48406df6180d8fe1f03b0be0611bb39d91fb927547270327da75a0cf66230e35e27a1f382cc29ff283369cf5a0318ec3b5c71335f5823875b241415b40458b57149e98e2f47fdc948c08316b308c0c137057c6101cb0de490723137f"),
	})
}

func (s *drbgSuite) TestHashGenerate65_SHA512_6(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "820cfc585965e1c605005de29785b2cdc0c4e19b738a70f353ff4e7f9774a9dc"),
		nonce:           decodeHexString(c, "c8d6b9fad0a5a6da250678fbd536e254"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0fecd9bdc519db21f071f98d36a4050d3a432919f4db8e1136e38e0018e7adbd"),
			decodeHexString(c, "57411adc70853aa1915ae42708f670fb45eb413a5d1c663abb797e0342b42242"),
		},
		expected: decodeHexString(c, "e71c2ad46f888acf5620faa02c9f37c03dc841966794f4335e378e4872766cb33de96865e7c32fdcbb2cc2c940f44cefa623e1d3a68be8d10d125afa52ba45e27fe463dc32b92ad81b9e6f5945347b53df65dff542f575a58447720f274b25a6596c3e3833a297ad4f31a0ea1032de024f1ca426d2fd410700294978ce87f1b3d8f462f31ffc365b305a93750682ef058692e5131decf7ce540823d516794be16273c375b4afec3b9516fe7b6ddf4246d371de9ca6ae8c9c811818a5f98471647d24cdc074d46f0cd93c1bf01206d8a4a56adff5f801f25bc1ac85125485be9130e48e4aec90bf98f716e77685faed8c3d4ef2fc9ad7ac3bbe7a576c89c82291"),
	})
}

func (s *drbgSuite) TestHashGenerate65_SHA512_7(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "49a8859f1a16f4d17ca84648eb560051b7c4b3afb10d3537bfd58be0e1fb6b50"),
		nonce:           decodeHexString(c, "107510f7e7c13fb1381c968376740708"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "5ee96d4b5bb691b8cbcc233263bb9968584a9af81b017fedd76c29a9ea140d84"),
			decodeHexString(c, "5deecad0bb4252453db4d5dd0ba8d4c4b03a6bd3cc627bcbd77eb3a6b25d1732"),
		},
		expected: decodeHexString(c, "0f901a7323136deeaf06c9788a1489988795f0ffd00f6a636847e6f71fab27a8087e730057acf24cb407c768b4a736882c427e4c8c15e69a8483f6af89d9b7007ce17fb8481f31f0fed3c88e41d8fac36aeade3e8c6831171b2977d0109977a002c04012f62af906c1495a09f1ad63852a05a77a54f0ff1ce35f72faa5b5ebbd366fb07646fa69eb153ccff92a7a9003f953e3707b2af97b6d4b7f3a7fe6d809c4c249478a0151c3aaf3783587fdd8117b28026867452abc8ac5c2c81ff6b5733111c316a6fdc75bc3db89066a5d527c2ef6429b7f6d35a9813dd78a2fe0869459bed16f2bc29d4d0c4f7b9af5b1a2a2a0edd79d2feebe92bfe5ca46500f7315"),
	})
}

func (s *drbgSuite) TestHashGenerate65_SHA512_8(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "fcc5a24d87a92eae2414e981da7a979379945782e177c558febcbf8e10aa37b1"),
		nonce:           decodeHexString(c, "1a0031e5951a961ddbd97505c33a20c1"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "35c92dcef12f587a2a40b5694e9bcadc21add32bb20802555167f154e7174b7b"),
			decodeHexString(c, "8a88955f8b72bfe8ce5a89a61a58783a0973a143cf89b3a1d6ed779dd2919e01"),
		},
		expected: decodeHexString(c, "b98e6289d3f4ab10f6492e018a4eb3596eacc4bdaa68d2befc821594794390aa4ec4c59baa7560fa069f1ee527b5d774a6e0f3f009b710bf3471302826ff1fbff226291ac779a601c9fde3068ab31e03ca9894ede2ffcd724c3df84c78c83e6d0943815ee1ba44596c6fd06de3c8c615ee5055c6e4b7a9aed1710243d71c7027e45a04f139036bed07ec527bf6df39688d380aa2eaba8828515ff88e9c1ddf81e05185a654a5a44882a721af79b2f6903ad4a7f82666313713d0bc526b7df2a36b7b417a35ff9a85518f5279ffd540dd187211ba5b723f2d85577febf200d1a17b063343757b754bdc27daaf08fee194f5a2d94033491fa09185cf75e4ed5b88"),
	})
}

func (s *drbgSuite) TestHashGenerate65_SHA512_9(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "4a96a3641b34aa30dc6abce810bbc2bc33656111408da0fc30f3886c3df48447"),
		nonce:           decodeHexString(c, "8497e189704dcc920e6e5c84eb502584"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "9f87cc8980bd29d83c50c57736d8351162df19122933bb14b1dda2968d74dfb7"),
			decodeHexString(c, "f91feb3fdb4acf57164b169e1307902e5e58f6fe4df614b737951e49ad617001"),
		},
		expected: decodeHexString(c, "21558bba6e1db78e86ede32f3dee1487b5a849f08e1452b3ed338e87f83bebfb5f46f86f89705622c7f4ed5a2aca3da3cd958369a3258cbbe90825ab9c06279f8c79f6a439bf0c969ceb6a423bdbeae55f29dc6664c415e2dee884b089f3486fbfef2bf52a71707665231fdd7e7ad7a9e12c9cd28123e83c882f90b527c909dd2475cdfd155da8e1bcc16dd05206c7d66add9b64f72a683fca04ccd1e2fb86d235f132c900241835d350168f740a6428299ac4b6a4f3f8ebdf298f8dc3f3dd9c1b3c3cfc990ce299a232af0b3904ee858a59d05dff6fa4eef2d65b5877acb229519290871bb09ce4234e25a0e16e255d1c32095cc6710530692c1ab4c0f21608"),
	})
}

func (s *drbgSuite) TestHashGenerate65_SHA512_10(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "e6470fd79c149f2c59053d669639f58a66e5f4554b806e0a006e46b428263850"),
		nonce:           decodeHexString(c, "c77f87f88014c409b4bd929425537e28"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cd8e2bbbeaf5be685b8c8b0b86f9eb99fcdd2017d4e39a5648ea57e9ad6280ea"),
			decodeHexString(c, "6f5230cc7edab284cbc07a320782fc7900a82e36fa20a3e8ceefc82a3ab27e21"),
		},
		expected: decodeHexString(c, "ab9178160a25b4bc6e8b54323db41e0fd016c3ab6d07b0f8108c2ca8388c35ea344b1b919a493f2cb1803ed3a1b8cda434bb5663ec8c690da24bdf40f2740ce2abe7c7a92066312986a9a9836a60c889d87ba3194477d2620409f7d7a77ef874b72145332ca145098e2b9bb56f9e65b2bffb242b4651665eaa856babd26fc6d428b1174ed4d384621791f40babda141a48e35b17f281a6e9b93157b9230c4c774da8d15e8d10a9909f205eb49794e57977b2efdd97682f6353d4afd2c14d6ffde15103f97b48340a68b867b57e00cf39dd20cad29bc7d8724a3efbd3bc5c768ceb22567e2dbd6d1b89a1f342e2d39e6836e28b61a3176938090e1927af0ce0ee"),
	})
}

func (s *drbgSuite) TestHashGenerate65_SHA512_11(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "fe903cbad5c25d8e8b8d609eb10af84fe5f59fc0c12d14ecbd2a7b42f76a6101"),
		nonce:           decodeHexString(c, "0f607f8310695d76b484ad8bb00b1266"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0706e7908e1dd6769d6e0af00654ba8ad7b528c55f54822135ce8c584ce79c5e"),
			decodeHexString(c, "57a0e7c596cd4a459ef449b35ece7f802383d678f6e30f2c5f019dd74e1ff4a9"),
		},
		expected: decodeHexString(c, "469d2ff5091b318b183fa5f78b6c3245d713e5df96d9f05169c9f3cf60d628637e1f3eed9e369af9b1c26ba6a1c221279dbd1d123c8dd910110dab7a2d3eeab995f04b3d5ba646f821971a3f81ac684336b37ec5b73bd5bdb64132d7d61c72d872f775af4ec3fe599b22380242b4bf1e64c694a061937ceb20cf4ca4ec4b6325d2367790170bec3e6c9780635ee1140d55cd1711cbf1448bb19db26f8747025826bf4df0eeca18ecda9b0062b26922e9ae6ba8e379bbda7ab00774591eead3be7cf0adab7802625aac0e438cd8e122d21ec89c8e4753f5b689718d7da631d0df7d76b78d7383cd6a17f456462190cf45932f00c1e26b29ef826f9a8cd2f043cc"),
	})
}

func (s *drbgSuite) TestHashGenerate65_SHA512_12(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "747c41c808449dde40c5d1d62140a625c36c3f7590def00f8ce14088a81fbeb9"),
		nonce:           decodeHexString(c, "618d12d4b5c2b2f8e7487fe135bd31c6"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "626783eb913b63f6adc5a4fda8841f16ee08ff559130dc7ce948ac439e0a5a15"),
			decodeHexString(c, "c89cb3dfa26989799ed6dd59205630b44a1ed55bf1c261ac28b0d31f5f90cf3b"),
		},
		expected: decodeHexString(c, "ee956b27918f1b94c876fdc5a53a5bc39599bfc101a35363c41a917023652ceb797fe9208cc277a9c864374b3a708d63e2c48d9a5e1bf07a1c11645433eea36583f58ae44291286247e0dfd8ee6e7327010b666c6e079c46bd5a73cbd31e69e9a618bb199fb905ca81a2d3d678e7c7dbab236a6de260a2260f3c244483b6310d96190a7243d4ef847b0f1b02e25d09ff55fd025181d8f3e0fa02709a984cf6bedf67578d8daf113f31cf6371dcb4e170bf6ef45b2416ea4e7f67c66879cda2279f491e677b38c0a3c9025c31139d731a16f93fd61bf4c2da4e442240da8c5575e5c3089fa72d9cb6471256955f668c7cd4a3e7f33427133cc555c196d7f79b4d"),
	})
}

func (s *drbgSuite) TestHashGenerate65_SHA512_13(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "dccb23c10b786158d2c6559266677b23c2fb844a2cff749519571c9866b76c3e"),
		nonce:           decodeHexString(c, "986dbdd32d7d5fbf70602b3c0f6de064"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "4287f47eef5a9651e67f11958a210914382939a31459a3885d598d96cfa6e115"),
			decodeHexString(c, "8f60356493515f80076717b82c4b6fd753709680826c27917fb716747e45b213"),
		},
		expected: decodeHexString(c, "d59d0efd58992786f0879a26a2da0bdc077d376d459b1eaf8835f6eb958a19017c235b294d23053c5645ab897b9994bd627671f35fd039dd03eddedced1f9b7965f7040ba2677a3d6074e2d4bb8b7a7c9804e4c18d76daa08c19f0ac098bb165a52a89a82b3e18770d7c86e15f147486c7e80345b0daaa57a4affb2e30684cea9273d5f190650d9a8410fb2638bea8c72e33d0eb4c8bc36dc1a61ced57d5791d5868f164f414e5172239955c0cb50733ff5a9bb6e6ad1ec08237cab8188a797f764eb898d9390f3013ef61ab7bb8241b382513a93afa63e40a1544a3c9dd9871f772649d87c4808089467275b182c00df64ca7272b4224af0793a51ca09fdf58"),
	})
}

func (s *drbgSuite) TestHashGenerate65_SHA512_14(c *C) {
	s.testHashGenerate65_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "85bc56f0224c1340634c5c9a3375e6b8ab8c30975e94e0279862017141957217"),
		nonce:           decodeHexString(c, "5fea742395b8a7b8344fad63b0659bda"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "4b69404b80b6f2fec36a7dff1b194a228761694129efa6c6b9a044f55330ee3f"),
			decodeHexString(c, "519c4cf1b30500f729e5426d76373c291e26cafceb594c10c96bdb9aef4b42fa"),
		},
		expected: decodeHexString(c, "53568141a5c09b6b02ac4ab674d341aa6300f8be93c0f36a7376a6850abfce068927510a1b98301aaa29252cfadfe5a2f241abc677e9e70fbca287c579acd276c2eec5c8b508f2b119a40164c6a12c0e0ca1d3d53595bbebe32fda2eef2b613329a614a28d3b374a7b031b49dba74b465a7db60a8dbdcc9e952ea143e9d5a3a651c1b0d6dad79341a7c3fd5816933f2579cc005f3c5655eb8d3f9d1e4562a756ecca3fc1d688c9824391ec8444c6024774a295c44c17fe592694dcf41f305f50a16e07fc28e247bb3d9dd0c52c6fde79df84c8d521606cec9a55f909691f5cfd797b69304dff5b60ac816b0d5046a47c2434127da1fbaa86d2844f5164a9dbdd"),
	})
}

func (s *drbgSuite) testHashGenerate67_SHA512(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHashGenerate67_SHA512_0(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "31e8d6fbdc9026b0708405c20b558fcc0a107f3fdc836fe056f020df30d9dc57"),
		nonce:           decodeHexString(c, "2b8bbab9b486abb659c4ae8ff5978e22"),
		personalization: decodeHexString(c, "949eb753762869aa5ea0ce725523595f9bc9b219735113e71feab228d0872c38"),
		additionalInput: [2][]byte{
			decodeHexString(c, "88f1180d4ef564315280a9692f107ed9c0639d79bb7040dfc3b7d58bf24ef8f5"),
			decodeHexString(c, "f4fc8a26e0ad181838f1399fe5b8a4b86670e92ab92b2c4daf3913470724d3f2"),
		},
		expected: decodeHexString(c, "10509641332a4d72a3c5936512c37cb9ab9874693902ee4c76e963675627ef86aa2e7d7029a152b800072fc53eeb6b41d12f481cde99b467dac3486836f6e146e9a79d3fb90d9b26f213ddbfac590ca083ed83fde4924395d25b645b96a6983e65fd662cae66112ebfa990f09b86b01270b7f0ef35f183eb01ffcbd7d5ec6adc4839cf3814dac858e013c6d79528ef273dd83724ccdc82b73dc63698fcf8ef0924f27b6a49d6d38f0ce261aa5a0a88779e47a413c29e1d7d20e4ab914bbabd5e6e0241cf53263a8efa321b4a632eb062b255c0ce5a0833114161dd073dd037967a1f03daf2dd7e927b801b40e62f26c0872ea100132807650232126aa8f29d70"),
	})
}

func (s *drbgSuite) TestHashGenerate67_SHA512_1(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "2da0fc2bfa2be0783bb0c2dd7715a9eb9f6d242c410c94cbc3d0e9a3fca51833"),
		nonce:           decodeHexString(c, "06cc9be12a59a27227b4c17176e120d3"),
		personalization: decodeHexString(c, "8af60799a6550e35b9716abba2ac41b4b83d7d6356b46430018f7b539cb73289"),
		additionalInput: [2][]byte{
			decodeHexString(c, "104a667e2ca3d224ba0621f3f88a8c4b3209455c70e9d290129fa5938368f8b9"),
			decodeHexString(c, "405fbb0f4395c202c2c1d2998a661b105152b9022b25f09bf9e9d72d1f098785"),
		},
		expected: decodeHexString(c, "f27ec9f8757be0de04c52bfa3065b472cb299293937b0af7717ad7183a614a093915f6301c7c470c4377b8ea07b946bbba032f056bb75a461aff3c3b7788ff650da96d60421b12b7039377d1d49ff12b30573d507827adb19d5e7b147721c8a07e5a697e69b04427e86bd250f129bb6b1e66946b7f3cbcb3af6e9ea76141d85e3819f1abe9ee1d7aa255956b6429892fbc918ca1968725f07d57983d5d1751c2281e3715ecc24a20c6f81d0affea22efb98af0aeb51e28894835a8d1de57140c6cd5e4dcfbe4d75f55ce1723b4bdd3c6f1e888c5b4eacf6adf0a1d3c2557a192fc5f5d6b315e6dbfaeea98c8a20c7372551936e93a02b835842109938a21d508"),
	})
}

func (s *drbgSuite) TestHashGenerate67_SHA512_2(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "8bd067ccdb7b20356f4b69579a0d94ae74e8fa03ec51f23c9926f6ce183640d6"),
		nonce:           decodeHexString(c, "72d8095713f90db89f79394350f230ee"),
		personalization: decodeHexString(c, "c97e413f1f6e95c35a4cde25c12c536ef79953a48e9bf2aa7a35dfdf5b810f85"),
		additionalInput: [2][]byte{
			decodeHexString(c, "15f793339b41124cef9dc41fefcf8ac1c593ee1ad6d4a4969156b1d8eead4a7e"),
			decodeHexString(c, "30b86ca9b7d78adab135984ed7be67aa85e3abf4379756ab5f775f986ecb339f"),
		},
		expected: decodeHexString(c, "cb2f56f407197e0479a093eb4beaf92883275c70f7571477a6c3beeb71035b711a888aeaa8bb186782875dda6b05f3ad3df502b55f6b5eacf486447ba641c8688dd84727267d8ac91b04f192308567295537f12aac36aaf8f5c436a683463cb4bac86affcd653b5e1960abd94cca25064135f0c2bead0007917191cef1cf2d3207682e73714e7f7e3e1c2efae6b8d1c7fa46f0e1f75a6e8ac84659787ff0cd70d02311015c2dd926324d82cf38489ae450a01fd09a4dc411d62cde553947e30a6ddd6153fae1575e3e5222993584311b45cb091ad35484b8b75a90b6994faffec4820187b7b6ed20e1db84b0e6bc1fee1117b86b422b32787dff56b7a7923192"),
	})
}

func (s *drbgSuite) TestHashGenerate67_SHA512_3(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "0e18475cc467fa2d74121b23d255f883dc98cf089d8293c90d27b9abd46ce5b7"),
		nonce:           decodeHexString(c, "b5efdaecde8aee390772a53a242b1a04"),
		personalization: decodeHexString(c, "a6fc0bbfa739da1a63b3cd421f08796a5973b60e9a4a047dedfc5cc50370d9b5"),
		additionalInput: [2][]byte{
			decodeHexString(c, "aae86525c81ea75a989d2a4abc1e0abc2dd884d9d56c06cf57741295b2f6c8f3"),
			decodeHexString(c, "ffa8562e213fafef3c44058fa2273060ff7269335e14ae8e749e6c077912aba4"),
		},
		expected: decodeHexString(c, "6b305c9721936264c1c67fc487703eb61b226f053532527b466c2d3079652347da3b91cd829054d75bdacedf744be63526f7e49de08008fda4ea71732e60568eea31f1b4ecfcbfeb9bfe876470dfffe1ca9347862392602145c4f300ee8a38bbfc6eca65f4064ae8a8066bbbf174cda392467a1706790ec8863d2cf52ea3d8f206c4a873e412a49c1591e30196ddfc49f17df7b082f90fe7b39af699fe5b1d99e3a371d3e5b14fc64dd67c788d8220ca1f381cd6ab6c5cf139400bd9993d0526bc2fcc4be5d50f90765fe533fc5475031f526e24cf9cfba075b7ca4d2016cea733aa63910df56d21942f3ed7f2306cd668ea6df522240af8fae9d5cc659782db"),
	})
}

func (s *drbgSuite) TestHashGenerate67_SHA512_4(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "6b16be85b90e3505ea941adb6311223460d8fccff7f6a4c9aacdd65ae59e45aa"),
		nonce:           decodeHexString(c, "a8ecc0ec169130c03d5e0fac59ec2ab8"),
		personalization: decodeHexString(c, "eacca2a0e501afe855db355548811ac6252f6ae7b585d27eaa4d96b0f84e841c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9227378b4ffdf15e31abb003647624ccb297384969fce30b4e823e3e0a121f57"),
			decodeHexString(c, "d2ad216c4a649be4a4afab984e6b421025ef06c824517117060df6602b9447bb"),
		},
		expected: decodeHexString(c, "40da3a7999c6969eb06d1d632a8ccbca514ec947bae07c2436d34477348b84fb996804cc1d7ae1d2b7ebd9bd16a7516cb703581312a290b3b8e3a999381149fc4f38218471591716e25a192a72fc9888eb4b22ab377a783d9939ada6eeb1c2c8da33dbd5562ba5ff0016a5da8aa3550862930ebec3d2f8c24c3b4de0926e835101c1668ad3afa73cb937c05456aa8be3572b07ab2ef8c342c33852989a15de2a2ded0c5eb0cdfcbef5c06ffcb308f6b8e20083b45f5924fde6efc8c3169be57f3c0ba0ac72ee4be386fb8e489fc36c01187ee40292c5f58ca9f7a3673abcc22577e009b92826a59b48465d77171aabd8238bcefce704bc7890d132fb80e3dd6e"),
	})
}

func (s *drbgSuite) TestHashGenerate67_SHA512_5(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "9f942face5b5f3e682a9cf379636ff8acca12c337bf1c88d28e0b5c4cdb18975"),
		nonce:           decodeHexString(c, "ed8a2a285ae5001b0c1f9827128fddf3"),
		personalization: decodeHexString(c, "d1d855326c6d51d80e935c6b57bc1abd679404706070c6aaa7180cfc1cc2a70c"),
		additionalInput: [2][]byte{
			decodeHexString(c, "2ae71cf92ad651ae3ac7879a67d348609401422d44a7d2e1e9170c3e4ff24efd"),
			decodeHexString(c, "cebe3f8785219b9a60c2640151fb43dd1c81b21630c38526016f9ef7508d87e4"),
		},
		expected: decodeHexString(c, "3bd29f037621d985e6e42de47ab6f7bb79893a7c5e532ca914afe871cd3d63313cec5e9bc8a2c5d1c5d87d7b016f7b15c4e0c843f37b0f57e3e76503f085f5ba659228b31727418c0b8e5d5cd505b140345557ae5de1bce4adcfc960a575d44363be73f568dcdf0d91c0f380f6e164cb1864a8739aa6711e376966d7d2767e926f3cf353e0b6f3fbba99f999e4ae3f8856d45a7d273db353b8edb00bab99261095d2b1cc3cdc3d25e3e1ef27505972f7f3334a6e954622169fa28a9e19217d96ab329150aa6d585d7698ffc22d581cd6cf68e11d98d259c2797a664dd12f5e8796609963ece539803e325e54a8b57f93fc547ffeb2ce7ca610391b58459e77f6"),
	})
}

func (s *drbgSuite) TestHashGenerate67_SHA512_6(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "9a08a378fb535b1a8ffc730398f4071242c6954c248282ade345a50fcee38c42"),
		nonce:           decodeHexString(c, "006d8c510f406634360bed0fdb7dc12c"),
		personalization: decodeHexString(c, "0025cb801101a8d9d4647c02a0915c6b9639722b90e7ef88aab9dba3c18d80bc"),
		additionalInput: [2][]byte{
			decodeHexString(c, "99bac0346fac6b765bcc9caf8e2276fd75db65d2c182e272fd7dc66de3006482"),
			decodeHexString(c, "349bfe2d3728eaab69761b461e6bd96206dedd6540ac510ad2b65f198a1400d1"),
		},
		expected: decodeHexString(c, "0e383143abc652bd1e12e3a85c46c8acd1f97821543cfda5d9a05417def21b59821a174b58ddd1f1a8e2ada4e28d7806b43b693ea70fef21ec63fbf5cf11cfbd2075f3d242830fd708ff05e9fefeffb23c393b25ca503ac84046c7f020435c914238f18c35f7d3c293740caa7bf2eaa2a21a6028faccc13869bb734e41a515683acf08c223b9f8aaf3372369702a23eb6010b375ee7bbeac5c40c209db6369133d5026b97d4ccf588ec09a0427b8d50411bdc867f668dcdfd6b881ceb91820c24e79dac53aece4d3253c189203aa191e31fa1fdbf80ae6a8165a094b574c123bf7bdd15ff001049851a702f793871fcffb491ca38def8bdef9f1f5d48a9188ba"),
	})
}

func (s *drbgSuite) TestHashGenerate67_SHA512_7(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "7e745954ba8fe961c0093c552de15a469763640677b53628ff46a3062ca8fc92"),
		nonce:           decodeHexString(c, "a89bde60e20c10f33bc195221c184d72"),
		personalization: decodeHexString(c, "3127891b40deadefe09e9fb727fa91e1111f77133cfe306babd4dd3089043e53"),
		additionalInput: [2][]byte{
			decodeHexString(c, "6bf082cb8861f45272f9ffba27adef92d2b210838e9a619e1ab055e2c310a558"),
			decodeHexString(c, "999adc41ddebd8cfc328212a267d111cb9bfdf4dd165dbf5dbc9ccfa1376b1f7"),
		},
		expected: decodeHexString(c, "edcc91b47943c29bdcad2718bdfb61b42fd998436b0e2608123857b21ed9ee2831b6da585b63ef872f9604385b05f6d2082c7c81c6eae7bf4238bb2b4db6168854368a17e4f62ce48d4ee8bc18ca5598c16f8b3b03d1927483ce918877e388d4c5364818d357e409f4d8eb6a6fab102d682e8477b6d523bad31c4e96ab529fc987d87bf4f78ca186dc7d3d9f60a2210b73f6e12419f847ee6987f5cbf3e69d43625a048387da06f392d861dcfb2e24cc5db300ac74350aed4e3bd93c62002602ba0798bedb1cc03a92a939534aab0242d4d624503580ebe899c6822d3ab14b3b52755d3826a05d81ad12eaf55dd4c2e660519900629418dbdee42ba85d82d129"),
	})
}

func (s *drbgSuite) TestHashGenerate67_SHA512_8(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "d209666b09eadb34238b15eb97ebee268f095ccf8de068e45187eb691aedbe25"),
		nonce:           decodeHexString(c, "24633a170a9b3b9cedfcde94dc8545f3"),
		personalization: decodeHexString(c, "298a8b306373a4c6065b9309b1c7e0f6fbe4ea23b8e0b16608e7b30c0d84ea11"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f60ca1359b5dbf63404e306e073361ecb9ff9b9396388fc7a3e7b3b3224c86e7"),
			decodeHexString(c, "49a4b2bc9afc34a77894cc2c39f5f632389a369e70cd6338845676fcd6e838ac"),
		},
		expected: decodeHexString(c, "7c40b03b7b1aea5526ea092d9129ef4ce2319864624aa70eea4207ac5703ed90cbe9e274d445e65a8ae1f8c0961db98c3a8df6b687c1771fb936a18ca764b20eadd6eb84b8c9b617b51d2a61cb6ae62d07741b5b03033da15ee8194f155227a5dd2c34c251fd4986e1c32937e6a7e040d843b2de983ae272cc25049061a6f5cd85dc04ce33b23a3af8527331a0874227f2f72a2882b55c31a3751a8dd0ee569cf254ea9d0cccb8bf3358bff46a9e370b7b21c75a96ce2e393d37fe0c2630a29d4daad9aa4479aeaf8bbbaba3dff12cbdea796827b80189d531562d89e3b13b3d5bdcad13710846d2b68b3dfee11e3143eb4b207cd03b924ce5cbfadb6111f0e3"),
	})
}

func (s *drbgSuite) TestHashGenerate67_SHA512_9(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "4be833d06b234ae76f76f4a7f5f6dca13fbf5fa96fbbdcf4413143c1dadf4aa9"),
		nonce:           decodeHexString(c, "b474266a8a849772728daa323cd39f01"),
		personalization: decodeHexString(c, "a8416550b7e8ae43e7d23ac458d3e9a6f519124dcca4af19d9cdc3da491d1df4"),
		additionalInput: [2][]byte{
			decodeHexString(c, "9a2dc8a1ff7206518d04daa198291eca617badfda54bd22237f9a173e9cdf312"),
			decodeHexString(c, "7822e3112bdb3b625ccea19f509b332879658c03079f3e70423a9911427d5d57"),
		},
		expected: decodeHexString(c, "96d24630f653584ce05b24587f2d93cf6bf579abe0b6e2de96a12f706e2942b6329d5601b36b00026c8da2b4659150c4e1b47adae5b1d83cdffb841a0c5dc95c5ca7dbf92f8f6a6f2e849443bd3fe997660856556df7b7fbda85ac8fe7c367c228d7c616a3719027fc4e35819ed0e64c0a4705fbdf9990c1108805a347a2f02d9098f2710b0225bb0293aa093a6c1823959f2a6bb9334b7c84c3477a5edbf87f3b379a5655fc443bef0e71b1beb5f4ef4aeb5568b20994e8e895c40867b09eb105779bf6b2a751e14d06a7eaaceab83881ce70b69ec7785289839f72fba20e8212c61f7f9b6398c901daa6e4ac49e1567388f834798dca2406ed974ce0bbec1a"),
	})
}

func (s *drbgSuite) TestHashGenerate67_SHA512_10(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "de3371b2318c14c018d7a956b6be9e48cc8527fbd32a00bec1332cc59254ba90"),
		nonce:           decodeHexString(c, "c9bb8570480ee0bd7ce2320280ccc8da"),
		personalization: decodeHexString(c, "01a0375aff8275bd7e03ba2ad4eb1f1e1d76fd13e328166d0e79522e4d3e3aa8"),
		additionalInput: [2][]byte{
			decodeHexString(c, "eb2faef54c850df27a0d441b2cfafc980c7d041b56fc23e237d83e2cb303180a"),
			decodeHexString(c, "509182b16622938ccfb82685e78a8b38c0ac5c36874031bcbb76f9a71430d4f5"),
		},
		expected: decodeHexString(c, "cba7cd4e19320e1cd00c6a7e20bd543cfe3fe08fe6b9a47803da640ed3bcd4376ccd142bca574c3be77e444ec008476c654922ca0a4aa582fc7fc0f45b69fcf24512872b21192e89fe8fc020076b370b98de505c88a06b00aaa7ed0ec7ee478ee779d2abe95e4052ea2d9968bc16d2fb8c01c9dbb1f2ec2d6d55c133d32a229cf948a0b2f812a7859a897f00277e83cf2a394faa0b85e2003cd1f54ec3ad1f53f03cdda8b726407175f0888e7ab923248ad6d92184bc3a8971f92e6e1e09dda19f3db72ddee8f3188b6100cde7272c740c74c16ac159b62087bf00ee1319e225be2a4d2d49a41c79646eb0e3bb338398b5b459ec5dec4f75f0dcba50ffbfa19c"),
	})
}

func (s *drbgSuite) TestHashGenerate67_SHA512_11(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "3c0d31c4b26c7b82e5bbbe8a6f2c016f61cd7e9988a3f025f4cd0273d64b6c3e"),
		nonce:           decodeHexString(c, "b8faa8fda84f68331db3734c0a5c8d22"),
		personalization: decodeHexString(c, "1a7cd41cecb03bfb8d3e9b1fa50c19e77062ebd019e2d4f7f078afc64ae1fe73"),
		additionalInput: [2][]byte{
			decodeHexString(c, "f9f4162c3866486932d8976adaed4aace7f4c7f103395bc7adba35caae20cda2"),
			decodeHexString(c, "4f33cbd20b4422a5285336d63b0ae4ff1f38176e1373702347ea39812bb9365d"),
		},
		expected: decodeHexString(c, "a6fe9127f85cdd8758c05c64896375a06e2f4198a3e98555de0cd3bbba0d834ad54defa2b6740d34151c7ff12a4fc361673dfc75e7e9296320460b7c907a8ebfb86953646188222c7834704936c3bd635c5ef7aa7a80d0f59d581292c906333c8bd35d9382fb4db237e992d4b8cb82e6acae241cb5a97e43cc2a3f877885e3cc83bc25bfc900088c746f2fc6566a74bc2966429c1ce6e2790a0116930c41be92dd2c0c579c31bb3955ecbd4d3bbe436ca939959d2def816185f2262110b8ecbd57003d6ad86cfaa6b776c74f77409a5333e57e8b416cc5f0f6c2bdc16344003f0eeb2b87a2db01a85ebf4677b87e75d69e8f6743aff5ea9ca6da4f7776afaaec"),
	})
}

func (s *drbgSuite) TestHashGenerate67_SHA512_12(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "ba63b08d942ebfe09327bf80106744393d980061e15f387dc23ab452f2b35646"),
		nonce:           decodeHexString(c, "f60b6bf40766be9d9f9bbedb6205175b"),
		personalization: decodeHexString(c, "0e87ff3741d7377f840a7b5ac45c2d146ac0cd88c7e715746ac3e6d0cd0867a2"),
		additionalInput: [2][]byte{
			decodeHexString(c, "286593d37c6cf3c9154b256f82338cd3d72722d54eeebf945a9f152ee1243829"),
			decodeHexString(c, "437815fad750af17566c43e04403bcd5dae177111effcc4766cc5e618332f398"),
		},
		expected: decodeHexString(c, "9a438c0f075f6dadc1b68776e1c3651896110e6a03fd1d7fd95412caf21f945752de261742a6d3af8f171d34158fdace6f2f30d97d076e1de893a93e56a43efa46d5a3eeb1166dcec5936e89a911c48c3af61a82456d563eace8c0d3e7988937331219f30aaf7352f347df73eaade6c1831c20b9dbb622ac786b4a6b58ea09dc884806bed493b42477d47c8b6f06e73b070306374d506d48108ce8941368a455054e45f0409daa9f7dd2f3073ae8285615d990f905aedd9f8af0a9587136792107d4ef67683ee1be64a68ebc206c7ad0d5644e15b64af9825312a75c2ad56907930f9d957ca36044a3308e5167c8072292b010c8235c7500ee1f3283d837ce8b"),
	})
}

func (s *drbgSuite) TestHashGenerate67_SHA512_13(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "de2d8369fa5ce79a177da7d9e8961876f39d266ada2836bd7703a7fad2874e1c"),
		nonce:           decodeHexString(c, "d81c2f1bdd28c47cf29c01e4d98a7af2"),
		personalization: decodeHexString(c, "0abc4e24e778ee25901eae2a8efc99314ae9433462cfbf2e0b9eb864c0c6e0fa"),
		additionalInput: [2][]byte{
			decodeHexString(c, "69cab36f38ae07babf50c3b1a39df5cbdb3c89ba7e1e60c0da8cff10547cb078"),
			decodeHexString(c, "819603ce2fa8188e13a43f12d40de27d38b5653d0b91b8625d8a837ea7bdcee8"),
		},
		expected: decodeHexString(c, "49d569422a284f6d2d2d08e50d005a3be90c6b559e78637935fde60f6ab6725ef8f2b95694b91fd9073b315a30153079c2bfd26a346234e3f3ee8692df35c603411005417d2cfd1a15125a7a42e291c58481419558503e6d8f54a3464befd6d13ca91e534115d2d1cff137ab3dc281e0c28f9c090bc66ccefd6e6cb6337ff2ce7ea22410cf548a0aaf77ed3f4082dce69409e140f4653088be2909fa96ec48a1dd9f02a187883b96eaeffc50523a6467a691b5cf8c0f20d6d658402cdbee3b5bbce602f922b1319b50fe45d60c1758b9f721c919b38a32c118e55dc4e79f7bce966869b502cec92f0e6c5a514b04f87339f368ceb1ae4a870958f6aa56ce8717"),
	})
}

func (s *drbgSuite) TestHashGenerate67_SHA512_14(c *C) {
	s.testHashGenerate67_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "d1922372f788d6b1285df63bb3e05d8a77b7055b3a31a3310ea51524bfbc36d3"),
		nonce:           decodeHexString(c, "247717665b4d71ef9e2855d40cb962bd"),
		personalization: decodeHexString(c, "7593c7841c5bc0d0a68a49ef0e4fd311e84d16652a8f15ef56ef10b00021f255"),
		additionalInput: [2][]byte{
			decodeHexString(c, "64278bb6b8224b93c0b5339726fb752f6d81e85b204d76376d99779ff1f86cae"),
			decodeHexString(c, "4995815c060c80e9bead55dfe823b869862bd0e5b4357afe810a53c68d4b0e7b"),
		},
		expected: decodeHexString(c, "9b4249e1e692153ecd20e968f86eb31bf9a22d3671d0ce9d3eea243bfc70890644a95d551cb9956cc3770e95c2f14ff154760cba1b24c51c41f7a961a4502aa053068751618eaaf743e0d37fd41ab4969444519c22c8fd96f9eb1be6ff3ae01a25abba84a259dad8bbc78f47dcab3ac2242e6974a56454999b4c59243102b731fc4bb4e01c92d36f232ca8cfe00fcbc0ac200c2e403d17d5d1dd3d6c2095ddd15ad58a070f18b69a5f5d3f240435d298bd48bd9be028ccaeb10997f88857a848882f51a193522bb0b979b37b5508775fe150cab8ce97c0760b7418b5bbe496562fe639540e77c1025c0e191fe000aa5d1e49bf02a5a3c6f46b40dd2c47786d45"),
	})
}

func (s *drbgSuite) testHashGenerate69_SHA512(c *C, data *testData) {
	s.testHashGenerate(c, crypto.SHA512, data)
}

func (s *drbgSuite) TestHashGenerate69_SHA512_0(c *C) {
	s.testHashGenerate69_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "65004ce396e18c5271a336b04fe843d35507d2d26a461792e19c57861aca8e36"),
		nonce:           decodeHexString(c, "238745ee7e7f3f4fb1b077a946791214"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "0dc48dd1c82edb83d2273efa04025902e67469b1c2eaa3b69209a3d0970b7629"),
			decodeHexString(c, "a632c8a7089a05b6dbfe610e4e1dddadf539098d878017f0cb5fe8debeca0cc7"),
		},
		expected: decodeHexString(c, "b2b33bbea1cfbd663cf04869a4add52835754f52aa341d32754141ece3e396546745dfe0cf2871b3aac8b997ae3b4e04b0cdda4d9bf78c6a41819687be18c27fdbe95e170bb96e3813193a8e9bff55f75fcbf3174a74d97a529b933214b91c8512cd4645ce9f0e3164a1e15fef337a78d512e60db3c91190d96bc9ef62188102626380f130b6b1536a3450604552c46e0a5bb2fcb0c0b70a98bbe238b8fae9d74d100fe789503e53d3db7699d9ba39a0b8ccb76354e54c90753a9cc5f5ddb19bb6b388e9f4d6f01fdda589c89e08764dd735aa4d4ea31db17d5fc83755684b77142928cfc370358bbcc65cb1412b2ec9be5d52b84fb389330a68bc9cf2a03379"),
	})
}

func (s *drbgSuite) TestHashGenerate69_SHA512_1(c *C) {
	s.testHashGenerate69_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "4bb1834280b0f17bf106094792f29e519987c8b82517cf4c7a6ad43712ce33bf"),
		nonce:           decodeHexString(c, "a1a798d536bcfd05c6de26d790936e1a"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a4f4af98af2c1452cfdf2c85a7b09325967258ebc3f97ab031575ff4148f970b"),
			decodeHexString(c, "6f37aceac37cc913addea0f52b71b1faca2445043a6446bcf1d1a7769adc6d16"),
		},
		expected: decodeHexString(c, "8b7df4d489426784b8fd50db864fc580a7637b6693510345a2901b4d7482ce272386e2e52ecdee0bd5c678c383fc16bb4685024158879e8609f1fd93c2c2d236aec05cc70dddb6a9f5472596eb1eacea173a5fca3cc62846a57899fc0c9787e7a9d70b5c0809c56de846b9e43ebc69b42376f59b5428a043650b400a438ed2bf3e1a1952d7e96a4d653da7fd5fedfa914c1fb92c7d3c41477b512cd117a29f78a1c7b2b41fbd7d7d56e58d489d5683ed6643f88b9346bf541a69f1ef1dc67069569acd9fefbc005d0b8158dc573bdfbf8dd0799ad1090b6649085d61bf0a4ade98a3a114346c5c9d357e126b90fc745e8ea707d9d69dc2e7bac3801e7ba18426"),
	})
}

func (s *drbgSuite) TestHashGenerate69_SHA512_2(c *C) {
	s.testHashGenerate69_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "b7871ef8cf6a585a2d61206b3d86cf6d8fec7bd1780c9f221eb5b8626a59dc5d"),
		nonce:           decodeHexString(c, "275e760275885a5e66d7ca03308a3e0c"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "2fb7c9f6326516189584c8b3c290a8c50c480dbab6fe37935c7d5c0a996ea68f"),
			decodeHexString(c, "60c409d342067d2b36e01b9c8d0b08d55c5b1e9da615916b5d44e8882d86254c"),
		},
		expected: decodeHexString(c, "637b4d6d51b148c81c0963317b60ed72e69507aaf7a3622c98052e2526a69170e216d6c71bca8db1b07ecc7d52f0d841522741c59e8fc51d60c3d248b2f13b631c6b4e50c72ac872d57784b19720b290b078585c294704b707f301458323cf29045cd0b38018479829b208eb80c1d4cdb12c8da3cf3b141cdf26f9da21c40a588cc70ae4a70975be60ba399abc7b719d40e36c6ae0bf62acd2ee676aa81d7006307375c9553ce1de7e0915e2ae034f0e3270cdf78fdf28c2955af4f7665caae274abf11cebd6de12be719704a4865879e7002d5dce75cdf34eabec219c5f635f05023b6f45e8e837c48d56722eeaf09926b316fed39f5e632c29ef0d32140bf5"),
	})
}

func (s *drbgSuite) TestHashGenerate69_SHA512_3(c *C) {
	s.testHashGenerate69_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "c5a84d5e827a17bba96a1f3c2bc1f71e234143d7deab8499d5d96d21952708c8"),
		nonce:           decodeHexString(c, "ec028c6f19e44b5139856115b125917d"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "a2cb9280a6f5466b37af0da2b78cd6ee19645d20965b7163216401d4d59f961e"),
			decodeHexString(c, "7ecd7efe261b4676e93d92bf867ab872989185947af12f9c68cb8de432ccab56"),
		},
		expected: decodeHexString(c, "9551c9ec17d1bbeac3d6f04f2d8a8d2e7643e3339956dcf51eeb2875aeaafef0604f529cae938204f5d58df042ba9c4a0d135a09e5512f3cd9e04c8087c58b9caef0f6a46a6b0ccd1688b77134487447e0625ce4414c768527b8f89b3dfb71c3e5ca34b653c9b5e506d514789afbbb38c63c55155b3489e5dfb6e1e2d4750432510ec050b82faadb3b52727a00fbab39717dcbae41895f093d0b27e47592bb6ec287da1a4c2fe1cf8ee407545885af0e58dcc5a50e3c48a792a87e0ba347266fdab8825dcbb323a62ac602eae8a5f7bc6616f6be459c7ba928b3e311964c97f1d3a56e317bce5c37306a6b9dd1cfffea1369f948b4af9ffb5e959183fbcf2966"),
	})
}

func (s *drbgSuite) TestHashGenerate69_SHA512_4(c *C) {
	s.testHashGenerate69_SHA512(c, &testData{
		entropyInput:    decodeHexString(c, "d24d5c090aad7cd498c8b11869fd512c7a0e5340520c8523128202a1a04013a3"),
		nonce:           decodeHexString(c, "88a4bf3203001c04eb1b7b78519656b6"),
		personalization: decodeHexString(c, ""),
		additionalInput: [2][]byte{
			decodeHexString(c, "cf75784d2cf9de1df3a07886fb21e6b14ef822ed38341e0a2805460c1ab0725d"),
			decodeHexString(c, "65e36f63766d717c445845f1e6d48c3f8f79c9fd991a26303398fdf404b4b429"),
		},
		expected: decodeHexString(c, "eaec99b17173d5028bdaed59c931ceea295a76172d2dc4db609368d2a76426d4ac14e4cf4960de1b449aa6fe0a6d1a682784f28388ace97c7f2bc7a