# Contributing Guidelines

:+1::tada: First off, we appreciate you taking the time to contribute! THANK YOU! :tada::+1:

We put together the handy guide below to help you get support for your work. Read on!  

## I Just Want to Ask the Maintainers a Question

The [Linode Community](https://www.linode.com/community/questions/) is a great place to get additional support.

## How Do I Submit A (Good) Bug Report or Feature Request

Please open a [github issue](https://guides.github.com/features/issues/) to report bugs or suggest features.

When filing an issue or feature request, help us avoid duplication and redundant effort -- check existing open or recently closed issues first. 

Detailed bug reports and requests easier for us to work with. Please include the following in your issue:

* A reproducible test case or series of steps
* The version of our code being used
* Any modifications you've made, relevant to the bug
* Anything unusual about your environment or deployment
* Screenshots and code samples where illustrative and helpful

## How to Open a Pull Request

We follow the [fork and pull model](https://opensource.guide/how-to-contribute/#opening-a-pull-request) for open source contributions.

Tips for a faster merge:
 * address one feature or bug per pull request. 
 * large formatting changes make it hard for us to focus on your work.
 * follow language coding conventions.
 * make sure that tests pass.
 * make sure your commits are atomic, [addressing one change per commit](https://chris.beams.io/posts/git-commit/). 
 * add tests!

## Code of Conduct

This project follows the [Linode Community Code of Conduct](https://www.linode.com/community/questions/conduct). 

## Vulnerability Reporting

If you discover a potential security issue in this project we ask that you notify Linode Security via our [vulnerability reporting process](https://hackerone.com/linode). Please do **not** create a public github issue.

## Licensing

See the LICENSE file for our project's licensing.
