package org.wikidata.wdtk.wikibaseapi;

/*
 * #%L
 * Wikidata Toolkit Wikibase API
 * %%
 * Copyright (C) 2014 - 2018 Wikidata Toolkit Developers
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 * A mock version of the RandomGuidGenerator that returns predictable
 * identifiers.
 * 
 * @author antonin
 *
 */
public class MockGuidGenerator implements GuidGenerator {
	private static String nextGuid = null;
	
	/**
	 * Inits the mock supplier with an initial GUID.
	 * @param guid
	 */
	public MockGuidGenerator(String guid) {
		nextGuid = guid;
	}
	
	/**
	 * Sets the next GUID to be generated by this generator.
	 * @param guid
	 */
	public void setGuid(String guid) {
		nextGuid = guid;
	}

	/**
	 * Generates a statement id, using the provided entity
	 * id and the previously supplied GUID.
	 */
	@Override
	public String freshStatementId(String entityId) {
		return entityId + STATEMENT_GUID_SEPARATOR + nextGuid;
	}
	
	
}
