# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1125-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57163);
 script_cve_id("CVE-2006-2742", "CVE-2006-2743", "CVE-2006-2831", "CVE-2006-2832", "CVE-2006-2833");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1125-2 (drupal)";
 script_name(name);

 desc = "The remote host is missing an update to drupal
announced via advisory DSA 1125-2.

The Drupal update in DSA 1125 contained a regression. This update corrects
this flaw. For completeness, the original advisory text below:

Several remote vulnerabilities have been discovered in the Drupal web site
platform, which may lead to the execution of arbitrary web script. The
Common Vulnerabilities and Exposures project identifies the following
problems:

CVE-2006-2742

A SQL injection vulnerability has been discovered in the count and
from variables of the database interface.

CVE-2006-2743

Multiple file extensions were handled incorrectly if Drupal ran on
Apache with mod_mime enabled.

CVE-2006-2831

A variation of CVE-2006-2743 was adressed as well.

CVE-2006-2832

A Cross-Site-Scripting vulnerability in the upload module has been
discovered.

CVE-2006-2833

A Cross-Site-Scripting vulnerability in the taxonomy module has been
discovered.

For the stable distribution (sarge) these problems have been fixed in
version 4.5.3-6.1sarge2.

For the unstable distribution (sid) these problems have been fixed in
version 4.5.8-1.1.

We recommend that you upgrade your drupal packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201125-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1125-2 (drupal)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"drupal", ver:"4.5.3-6.1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
