# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 226-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53305);
 script_bugtraq_id(6475);
 script_cve_id("CVE-2002-1384");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 226-1 (xpdf-i)";
 script_name(name);

 desc = "The remote host is missing an update to xpdf-i
announced via advisory DSA 226-1.

iDEFENSE discovered an integer overflow in the pdftops filter from the
xpdf and xpdf-i packages that can be exploited to gain the privileges
of the target user.  This can lead to gaining privileged access to the
'lp' user if thee pdftops program is part of the print filter.

For the current stable distribution (woody) xpdf-i is only a dummy
package and the problem was fixed in xpdf already.

For the old stable distribution (potato) this problem has been
fixed in version 0.90-8.1.

For the unstable distribution (sid) this problem has been
fixed in version 2.01-2.

We recommend that you upgrade your xpdf-i package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20226-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 226-1 (xpdf-i)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xpdf-i", ver:"0.90-8.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
