###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for deluge FEDORA-2008-1288
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860440);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2008-1288");
  script_name( "Fedora Update for deluge FEDORA-2008-1288");
  desc = "

  Vulnerability Insight:
  Deluge is a new BitTorrent client, created using Python and GTK+. It is
  intended to bring a native, full-featured client to Linux GTK+ desktop
  environments such as GNOME and XFCE. It supports features such as DHT
  (Distributed Hash Tables), PEX (Torrent-compatible Peer Exchange), and UPnP
  (Universal Plug-n-Play) that allow one to more easily share BitTorrent data
  even from behind a router with virtually zero configuration of port-forwarding.


  Affected Software/OS:
  deluge on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-February/msg00069.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of deluge");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"deluge", rpm:"deluge~0.5.8.3~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}