/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by write_buildflag_header.py

// fix_include_guards: off
#ifndef GEN_BUILD_CONFIG_PERFETTO_BUILD_FLAGS_H_
#define GEN_BUILD_CONFIG_PERFETTO_BUILD_FLAGS_H_

// clang-format off

#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_ANDROID_BUILD() (1)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_CHROMIUM_BUILD() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_STANDALONE_BUILD() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_START_DAEMONS() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_IPC() (1)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_WATCHDOG() (PERFETTO_BUILDFLAG_DEFINE_PERFETTO_OS_ANDROID() || PERFETTO_BUILDFLAG_DEFINE_PERFETTO_OS_LINUX_BUT_NOT_QNX())
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_COMPONENT_BUILD() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_ENABLE_ETM_IMPORTER() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_LLVM_SYMBOLIZER() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_FORCE_DLOG_ON() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_FORCE_DLOG_OFF() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_FORCE_DCHECK_ON() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_FORCE_DCHECK_OFF() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_VERBOSE_LOGS() (1)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_VERSION_GEN() (1)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_TP_PERCENTILE() (1)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_TP_LINENOISE() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_TP_HTTPD() (1)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_TP_JSON() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_TP_INSTRUMENTS() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_LOCAL_SYMBOLIZER() (PERFETTO_BUILDFLAG_DEFINE_PERFETTO_OS_LINUX() || PERFETTO_BUILDFLAG_DEFINE_PERFETTO_OS_FREEBSD() || PERFETTO_BUILDFLAG_DEFINE_PERFETTO_OS_MAC() ||PERFETTO_BUILDFLAG_DEFINE_PERFETTO_OS_WIN())
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_ZLIB() (1)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_TRACED_PERF() (1)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_HEAPPROFD() (1)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_STDERR_CRASH_DUMP() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_X64_CPU_OPT() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_LLVM_DEMANGLE() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_SYSTEM_CONSUMER() (1)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_THREAD_SAFETY_ANNOTATIONS() (0)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_ENABLE_WINSCOPE() (1)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_ENABLE_RT_MUTEX() (1)
#define PERFETTO_BUILDFLAG_DEFINE_PERFETTO_ENABLE_LOCKFREE_TASKRUNNER() (1)

struct PerfettoBuildFlag {
  const char* name;
  int value;
};

static const struct PerfettoBuildFlag kPerfettoBuildFlags[] = {
    {"PERFETTO_ANDROID_BUILD", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_ANDROID_BUILD()},
    {"PERFETTO_CHROMIUM_BUILD", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_CHROMIUM_BUILD()},
    {"PERFETTO_STANDALONE_BUILD", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_STANDALONE_BUILD()},
    {"PERFETTO_START_DAEMONS", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_START_DAEMONS()},
    {"PERFETTO_IPC", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_IPC()},
    {"PERFETTO_COMPONENT_BUILD", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_COMPONENT_BUILD()},
    {"PERFETTO_ENABLE_ETM_IMPORTER", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_ENABLE_ETM_IMPORTER()},
    {"PERFETTO_LLVM_SYMBOLIZER", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_LLVM_SYMBOLIZER()},
    {"PERFETTO_FORCE_DLOG_ON", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_FORCE_DLOG_ON()},
    {"PERFETTO_FORCE_DLOG_OFF", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_FORCE_DLOG_OFF()},
    {"PERFETTO_FORCE_DCHECK_ON", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_FORCE_DCHECK_ON()},
    {"PERFETTO_FORCE_DCHECK_OFF", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_FORCE_DCHECK_OFF()},
    {"PERFETTO_VERBOSE_LOGS", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_VERBOSE_LOGS()},
    {"PERFETTO_VERSION_GEN", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_VERSION_GEN()},
    {"PERFETTO_TP_PERCENTILE", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_TP_PERCENTILE()},
    {"PERFETTO_TP_LINENOISE", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_TP_LINENOISE()},
    {"PERFETTO_TP_HTTPD", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_TP_HTTPD()},
    {"PERFETTO_TP_JSON", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_TP_JSON()},
    {"PERFETTO_TP_INSTRUMENTS", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_TP_INSTRUMENTS()},
    {"PERFETTO_ZLIB", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_ZLIB()},
    {"PERFETTO_TRACED_PERF", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_TRACED_PERF()},
    {"PERFETTO_HEAPPROFD", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_HEAPPROFD()},
    {"PERFETTO_STDERR_CRASH_DUMP", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_STDERR_CRASH_DUMP()},
    {"PERFETTO_X64_CPU_OPT", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_X64_CPU_OPT()},
    {"PERFETTO_LLVM_DEMANGLE", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_LLVM_DEMANGLE()},
    {"PERFETTO_SYSTEM_CONSUMER", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_SYSTEM_CONSUMER()},
    {"PERFETTO_THREAD_SAFETY_ANNOTATIONS", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_THREAD_SAFETY_ANNOTATIONS()},
    {"PERFETTO_ENABLE_WINSCOPE", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_ENABLE_WINSCOPE()},
    {"PERFETTO_ENABLE_RT_MUTEX", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_ENABLE_RT_MUTEX()},
    {"PERFETTO_ENABLE_LOCKFREE_TASKRUNNER", PERFETTO_BUILDFLAG_DEFINE_PERFETTO_ENABLE_LOCKFREE_TASKRUNNER()},
};

static const int kPerfettoBuildFlagsCount = sizeof(kPerfettoBuildFlags) / sizeof(struct PerfettoBuildFlag);

// clang-format on

#endif  // GEN_BUILD_CONFIG_PERFETTO_BUILD_FLAGS_H_
