# ==================================================================================================================== #
#             _____           _ _               _     _       _            _ _     _     _                             #
#  _ __  _   |_   _|__   ___ | (_)_ __   __ _  | |   (_)_ __ | | _____  __| | |   (_)___| |_                           #
# | '_ \| | | || |/ _ \ / _ \| | | '_ \ / _` | | |   | | '_ \| |/ / _ \/ _` | |   | / __| __|                          #
# | |_) | |_| || | (_) | (_) | | | | | | (_| |_| |___| | | | |   <  __/ (_| | |___| \__ \ |_                           #
# | .__/ \__, ||_|\___/ \___/|_|_|_| |_|\__, (_)_____|_|_| |_|_|\_\___|\__,_|_____|_|___/\__|                          #
# |_|    |___/                          |___/                                                                          #
# ==================================================================================================================== #
# Authors:                                                                                                             #
#   Patrick Lehmann                                                                                                    #
#                                                                                                                      #
# License:                                                                                                             #
# ==================================================================================================================== #
# Copyright 2025-2026 Patrick Lehmann - Bötzingen, Germany                                                             #
#                                                                                                                      #
# Licensed under the Apache License, Version 2.0 (the "License");                                                      #
# you may not use this file except in compliance with the License.                                                     #
# You may obtain a copy of the License at                                                                              #
#                                                                                                                      #
#   http://www.apache.org/licenses/LICENSE-2.0                                                                         #
#                                                                                                                      #
# Unless required by applicable law or agreed to in writing, software                                                  #
# distributed under the License is distributed on an "AS IS" BASIS,                                                    #
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.                                             #
# See the License for the specific language governing permissions and                                                  #
# limitations under the License.                                                                                       #
#                                                                                                                      #
# SPDX-License-Identifier: Apache-2.0                                                                                  #
# ==================================================================================================================== #
#
"""Performance tests for pyTooling.LinkedList."""
import timeit
from statistics import median
from typing import Callable, Iterable
from unittest import TestCase


if __name__ == "__main__":  # pragma: no cover
	print("ERROR: you called a testcase declaration file as an executable module.")
	print("Use: 'python -m unittest <testcase module>'")
	exit(1)


class PerformanceTest(TestCase):
	counts: Iterable[int] = (10, 100, 1000, 10000)

	randomArray = [
		22, 43, 49, 37, 2, 30, 19, 3, 12, 45, 46, 17, 49, 49, 1, 26, 10, 1, 42, 14, 44, 9, 49, 26, 7, 21, 8, 1, 9, 24, 5,
		26, 0, 49, 18, 11, 22, 27, 38, 6, 3, 31, 17, 10, 8, 30, 9, 50, 44, 30, 42, 21, 13, 37, 10, 11, 28, 43, 5, 31, 23,
		24, 43, 44, 13, 37, 38, 0, 40, 48, 48, 29, 11, 45, 4, 18, 14, 37, 42, 31, 32, 23, 45, 21, 49, 21, 38, 32, 2, 12, 0,
		28, 16, 18, 43, 42, 5, 18, 40, 46, 44, 1, 12, 21, 8, 25, 22, 42, 3, 13, 23, 5, 19, 9, 32, 37, 5, 24, 27, 24, 16, 43,
		22, 23, 27, 36, 3, 33, 2, 7, 18, 42, 37, 15, 19, 19, 23, 10, 46, 8, 5, 23, 9, 0, 1, 26, 48, 26, 14, 42, 42, 20, 33,
		0, 37, 5, 32, 20, 17, 11, 24, 11, 3, 44, 21, 15, 1, 5, 31, 25, 45, 38, 28, 41, 18, 43, 45, 42, 50, 33, 41, 26, 37,
		38, 9, 1, 25, 33, 45, 23, 32, 4, 9, 10, 34, 36, 7, 42, 35, 39, 15, 17, 24, 40, 50, 34, 15, 47, 20, 28, 38, 34, 6,
		48, 36, 37, 20, 35, 2, 3, 25, 4, 46, 25, 14, 23, 9, 0, 14, 3, 38, 1, 48, 12, 32, 23, 50, 19, 13, 32, 3, 11, 10, 20,
		0, 26, 18, 41, 8, 43, 36, 48, 35, 27, 46, 44, 19, 47, 2, 8, 12, 15, 0, 24, 22, 12, 6, 39, 30, 46, 11, 17, 31, 7, 32,
		17, 0, 18, 5, 23, 38, 16, 4, 30, 28, 17, 31, 14, 11, 24, 13, 6, 18, 39, 9, 29, 20, 32, 4, 22, 37, 5, 20, 25, 36, 8,
		39, 21, 14, 46, 37, 45, 46, 47, 25, 27, 15, 41, 22, 6, 35, 32, 30, 28, 27, 35, 29, 9, 5, 34, 1, 37, 5, 13, 31, 10,
		36, 31, 48, 11, 11, 6, 1, 6, 43, 36, 37, 38, 20, 4, 28, 48, 14, 13, 15, 28, 36, 0, 46, 36, 42, 33, 14, 12, 18, 43,
		25, 48, 18, 45, 16, 47, 16, 32, 32, 5, 1, 18, 10, 5, 43, 20, 9, 24, 32, 33, 29, 37, 11, 44, 46, 2, 2, 48, 17, 10, 7,
		47, 39, 10, 3, 33, 4, 50, 38, 13, 7, 23, 46, 11, 46, 36, 50, 3, 29, 45, 41, 39, 20, 40, 3, 48, 43, 32, 3, 15, 10,
		37, 42, 32, 12, 35, 14, 40, 18, 10, 35, 47, 26, 13, 50, 27, 13, 45, 5, 18, 31, 0, 49, 27, 39, 0, 5, 49, 29, 29, 15,
		50, 6, 21, 37, 40, 8, 50, 36, 31, 26, 37, 41, 5, 34, 15, 29, 24, 1, 7, 1, 41, 23, 5, 8, 12, 41, 44, 24, 22, 48, 5,
		42, 39, 32, 29, 47, 6, 7, 43, 0, 41, 0, 23, 15, 46, 14, 2, 47, 46, 4, 27, 16, 5, 22, 13, 38, 32, 39, 29, 47, 18, 19,
		14, 27, 43, 10, 45, 25, 31, 18, 39, 2, 37, 25, 32, 13, 8, 15, 18, 13, 27, 16, 1, 43, 11, 47, 41, 47, 3, 42, 29, 50,
		31, 14, 26, 13, 12, 42, 30, 24, 2, 5, 7, 26, 3, 7, 13, 36, 13, 3, 31, 32, 13, 11, 32, 28, 41, 8, 37, 29, 36, 42, 15,
		27, 6, 14, 10, 50, 20, 13, 50, 41, 24, 24, 14, 10, 1, 1, 9, 2, 46, 17, 42, 27, 9, 3, 40, 4, 30, 31, 14, 18, 11, 46,
		31, 42, 40, 27, 45, 0, 17, 22, 42, 17, 26, 20, 23, 33, 40, 12, 47, 1, 39, 48, 15, 7, 22, 16, 18, 6, 2, 46, 30, 29,
		35, 32, 5, 11, 26, 6, 33, 5, 12, 50, 33, 41, 22, 5, 37, 45, 40, 2, 29, 37, 29, 3, 27, 25, 31, 41, 27, 9, 2, 4, 10,
		9, 23, 13, 49, 23, 28, 1, 25, 50, 34, 22, 47, 49, 18, 0, 37, 46, 50, 17, 32, 12, 40, 27, 15, 17, 24, 14, 49, 15, 48,
		3, 18, 25, 39, 10, 9, 45, 42, 3, 40, 37, 29, 23, 50, 4, 6, 28, 39, 31, 7, 8, 17, 33, 34, 1, 23, 20, 28, 49, 36, 45,
		37, 34, 45, 21, 18, 50, 40, 38, 32, 48, 41, 17, 23, 28, 27, 4, 1, 21, 49, 0, 35, 46, 49, 11, 38, 39, 1, 16, 36, 42,
		19, 50, 10, 20, 49, 43, 23, 29, 33, 13, 47, 50, 28, 10, 3, 43, 15, 14, 45, 50, 42, 45, 9, 40, 9, 49, 10, 28, 7, 28,
		9, 12, 23, 34, 37, 14, 25, 28, 31, 45, 49, 40, 41, 13, 38, 31, 8, 22, 3, 31, 48, 0, 48, 37, 37, 32, 43, 15, 0, 11,
		14, 36, 27, 28, 21, 24, 3, 14, 22, 5, 9, 44, 38, 10, 3, 3, 48, 39, 20, 8, 20, 30, 43, 41, 11, 19, 11, 32, 16, 20,
		47, 1, 0, 10, 49, 35, 16, 9, 6, 18, 1, 29, 36, 8, 21, 13, 30, 13, 35, 42, 6, 0, 41, 47, 3, 2, 10, 31, 7, 25, 49, 42,
		41, 7, 11, 21, 3, 42, 14, 15, 9, 11, 0, 40, 21, 10, 42, 5, 37, 19, 30, 22, 13, 19, 1, 38, 2, 16, 12, 27, 36, 48, 46,
		47, 13, 32, 10, 14, 2, 35, 31, 44, 34, 25, 11, 19, 19, 36, 8, 21, 36, 26, 38, 49, 30, 35, 19, 33, 8, 23, 14, 3, 13,
		44, 31, 31, 49, 27, 7, 25, 6, 9, 1, 4, 11, 14, 38, 14, 44, 42, 12, 4, 6, 12, 10, 5, 15, 39, 28, 30, 37, 19, 36, 47,
		17, 16, 7, 12, 1, 5, 34, 6, 22, 46, 45, 25, 44, 37, 4, 38, 41, 4, 11, 17, 6, 34, 30, 21, 50, 2, 47, 29, 18, 14, 1,
		25, 49, 20, 37, 42, 15, 49, 15, 17, 3, 22, 30, 21, 36, 8, 10, 17, 8, 44, 46, 43, 3, 42, 27, 31, 40, 49, 41, 26, 18,
		9, 17, 2, 24, 42, 24, 31, 41, 37, 5, 2, 30, 45, 15, 45, 32, 12, 41, 10, 20, 25, 29, 14, 48, 34, 10, 38, 7, 10, 42,
		34, 1, 49, 29, 48, 34, 41, 13, 37, 38, 4, 45, 34, 49, 24, 12, 42, 25, 30, 33, 32, 47, 13, 22, 6, 3, 40, 4, 39, 15,
		22, 25, 11, 6, 28, 30, 43, 13, 32, 10, 26, 40, 46, 27, 39, 14, 21, 33, 36, 35, 40, 42, 31, 40, 32, 45, 5, 15, 12,
		20, 50, 12, 9, 23, 28, 4, 8, 50, 1, 12, 42, 33, 1, 32, 2, 16, 41, 33, 12, 21, 28, 30, 40, 38, 15, 22, 29, 39, 42, 1,
		39, 17, 44, 47, 5, 18, 5, 10, 35, 15, 8, 41, 17, 20, 32, 15, 7, 19, 27, 5, 24, 43, 28, 39, 21, 44, 27, 31, 14, 41,
		34, 21, 13, 14, 2, 31, 22, 38, 17, 16, 49, 21, 30, 17, 22, 13, 28, 47, 25, 38, 36, 44, 2, 24, 4, 45, 5, 47, 36, 43,
		4, 7, 31, 0, 19, 1, 11, 23, 42, 35, 35, 49, 16, 33, 23, 20, 17, 22, 21, 27, 46, 21, 46, 26, 1, 43, 8, 25, 12, 20, 1,
		4, 10, 44, 29, 27, 1, 8, 31, 14, 9, 37, 45, 23, 9, 3, 41, 41, 40, 40, 11, 15, 32, 17, 39, 3, 45, 14, 29, 23, 43, 22,
		2, 50, 22, 39, 46, 11, 39, 13, 25, 50, 14, 12, 2, 24, 40, 37, 9, 24, 14, 21, 27, 39, 39, 38, 49, 12, 26, 30, 41, 41,
		28, 49, 38, 24, 25, 42, 11, 20, 13, 10, 25, 12, 28, 45, 26, 14, 34, 47, 16, 22, 14, 27, 44, 29, 2, 24, 47, 2, 25,
		11, 12, 39, 2, 44, 18, 25, 38, 46, 37, 29, 50, 49, 26, 38, 47, 18, 30, 34, 10, 45, 29, 38, 18, 41, 10, 6, 9, 11, 11,
		7, 11, 44, 6, 43, 32, 18, 29, 22, 28, 11, 15, 28, 11, 12, 26, 12, 36, 31, 38, 38, 44, 9, 25, 14, 6, 24, 44, 9, 50,
		16, 35, 25, 41, 36, 26, 13, 3, 25, 3, 41, 39, 50, 47, 9, 6, 31, 19, 21, 15, 16, 24, 7, 30, 34, 9, 16, 30, 1, 25, 23,
		9, 12, 19, 13, 6, 43, 43, 33, 44, 25, 40, 0, 44, 8, 18, 16, 27, 22, 42, 49, 41, 50, 39, 19, 6, 44, 19, 10, 19, 48,
		27, 4, 17, 23, 28, 20, 16, 21, 2, 16, 42, 4, 6, 40, 15, 39, 14, 11, 1, 44, 30, 44, 11, 14, 10, 38, 35, 41, 14, 14,
		18, 45, 2, 33, 26, 9, 30, 38, 3, 33, 30, 42, 43, 42, 40, 28, 19, 2, 13, 8, 2, 38, 30, 45, 11, 5, 35, 16, 0, 45, 48,
		26, 41, 25, 37, 15, 50, 37, 15, 2, 1, 50, 26, 14, 39, 40, 32, 17, 1, 43, 30, 26, 37, 48, 45, 48, 38, 43, 6, 20, 44,
		8, 2, 13, 27, 23, 29, 23, 22, 17, 26, 28, 36, 46, 22, 44, 34, 34, 34, 46, 19, 49, 30, 22, 13, 26, 1, 23, 50, 11, 17,
		2, 11, 4, 35, 44, 30, 35, 17, 36, 17, 30, 29, 17, 23, 26, 10, 47, 6, 36, 31, 6, 10, 47, 16, 15, 10, 50, 25, 34, 45,
		42, 10, 22, 28, 11, 28, 40, 29, 48, 49, 42, 44, 13, 29, 46, 8, 45, 42, 17, 29, 26, 49, 27, 28, 37, 13, 11, 31, 29,
		12, 4, 44, 12, 44, 39, 48, 0, 29, 6, 26, 47, 32, 43, 1, 26, 16, 44, 9, 37, 16, 14, 2, 14, 28, 0, 24, 16, 42, 18, 42,
		22, 24, 21, 10, 49, 35, 16, 42, 10, 26, 48, 20, 42, 7, 46, 27, 28, 7, 34, 25, 7, 36, 48, 15, 18, 44, 35, 24, 43, 4,
		35, 34, 33, 10, 20, 0, 15, 26, 3, 49, 6, 19, 26, 33, 49, 11, 36, 20, 33, 17, 16, 5, 24, 1, 34, 1, 40, 1, 35, 6, 4,
		15, 34, 13, 43, 6, 31, 44, 6, 23, 34, 47, 34, 16, 47, 22, 27, 3, 32, 10, 50, 46, 40, 38, 23, 18, 15, 5, 40, 10, 31,
		11, 2, 12, 6, 19, 16, 25, 39, 32, 49, 22, 20, 32, 16, 8, 46, 17, 5, 22, 45, 9, 15, 41, 19, 38, 11, 37, 23, 7, 6, 31,
		17, 0, 22, 5, 28, 4, 19, 50, 37, 34, 33, 34, 48, 34, 9, 31, 31, 5, 9, 4, 35, 19, 31, 50, 25, 21, 2, 41, 3, 22, 38,
		47, 35, 33, 6, 15, 33, 36, 22, 27, 43, 12, 41, 32, 17, 34, 7, 12, 24, 33, 13, 28, 6, 11, 31, 33, 28, 6, 2, 9, 1, 27,
		32, 39, 20, 39, 4, 27, 26, 4, 0, 30, 45, 2, 40, 30, 17, 0, 20, 34, 46, 13, 36, 4, 2, 39, 4, 28, 31, 31, 44, 23, 31,
		46, 4, 17, 4, 24, 1, 50, 45, 34, 26, 37, 1, 25, 26, 19, 5, 0, 21, 36, 2, 15, 46, 29, 19, 7, 49, 14, 41, 16, 44, 2,
		39, 40, 0, 1, 28, 0, 5, 3, 18, 9, 36, 7, 43, 13, 14, 50, 8, 26, 24, 32, 10, 24, 46, 46, 7, 49, 28, 19, 48, 34, 42,
		32, 46, 46, 48, 40, 29, 44, 30, 9, 24, 3, 15, 29, 34, 28, 17, 30, 50, 24, 10, 2, 23, 37, 2, 17, 8, 49, 21, 26, 19,
		4, 16, 40, 39, 47, 45, 48, 16, 32, 16, 25, 0, 3, 36, 31, 45, 37, 0, 26, 28, 27, 32, 18, 31, 16, 6, 45, 20, 3, 17,
		39, 37, 27, 23, 33, 44, 12, 19, 1, 24, 12, 50, 14, 1, 47, 25, 28, 23, 24, 49, 24, 6, 42, 22, 27, 10, 25, 44, 26, 47,
		16, 10, 3, 47, 4, 39, 1, 14, 26, 24, 28, 17, 17, 44, 33, 5, 32, 41, 31, 21, 33, 35, 50, 6, 43, 8, 39, 47, 26, 15,
		21, 11, 30, 9, 22, 37, 5, 16, 42, 38, 43, 6, 14, 0, 22, 30, 17, 45, 1, 2, 21, 16, 18, 23, 11, 38, 37, 50, 49, 14,
		18, 41, 3, 50, 36, 48, 2, 46, 29, 17, 33, 30, 30, 47, 36, 37, 31, 5, 21, 38, 44, 29, 17, 4, 50, 19, 4, 5, 39, 40,
		43, 44, 19, 45, 5, 26, 21, 28, 50, 13, 27, 26, 48, 4, 22, 28, 48, 33, 24, 6, 17, 14, 47, 10, 44, 23, 39, 12, 11, 8,
		46, 26, 0, 17, 22, 3, 46, 14, 37, 17, 8, 23, 42, 49, 9, 6, 9, 36, 6, 3, 10, 33, 6, 41, 32, 18, 1, 46, 45, 12, 21,
		40, 2, 6, 33, 8, 35, 7, 37, 36, 12, 46, 17, 1, 16, 3, 49, 44, 18, 15, 25, 35, 50, 22, 32, 32, 49, 0, 32, 10, 4, 44,
		12, 31, 1, 39, 12, 26, 10, 42, 7, 50, 0, 11, 37, 49, 7, 44, 20, 28, 13, 27, 13, 21, 1, 18, 35, 4, 30, 3, 30, 23, 42,
		17, 38, 38, 25, 28, 39, 16, 49, 0, 41, 17, 49, 13, 22, 41, 7, 13, 42, 26, 44, 24, 38, 41, 6, 25, 44, 50, 31, 0, 17,
		28, 19, 37, 16, 21, 2, 31, 41, 7, 7, 11, 43, 23, 40, 30, 20, 27, 25, 9, 6, 5, 27, 2, 47, 18, 49, 28, 36, 48, 18, 46,
		18, 18, 12, 21, 16, 15, 50, 40, 50, 2, 21, 37, 25, 41, 38, 0, 8, 34, 49, 12, 48, 47, 35, 39, 33, 33, 5, 35, 31, 24,
		35, 20, 10, 34, 3, 21, 3, 30, 4, 9, 50, 28, 20, 7, 3, 29, 11, 35, 5, 8, 14, 47, 20, 0, 8, 4, 38, 24, 13, 34, 6, 46,
		20, 24, 35, 4, 16, 46, 25, 4, 24, 50, 28, 4, 18, 9, 30, 14, 41, 31, 19, 1, 7, 38, 27, 28, 8, 48, 34, 16, 2, 19, 16,
		42, 24, 2, 7, 15, 45, 31, 8, 25, 28, 16, 33, 11, 18, 32, 1, 20, 45, 11, 33, 49, 7, 20, 19, 8, 49, 34, 27, 27, 35, 5,
		27, 48, 27, 29, 37, 32, 10, 33, 6, 33, 35, 30, 19, 38, 31, 23, 16, 8, 14, 14, 45, 12, 8, 22, 29, 32, 23, 2, 39, 29,
		35, 36, 37, 14, 48, 27, 9, 26, 1, 42, 26, 6, 49, 32, 38, 1, 8, 1, 49, 29, 34, 34, 33, 23, 15, 27, 2, 50, 4, 6, 1,
		19, 45, 48, 0, 48, 41, 34, 50, 3, 3, 40, 20, 33, 31, 24, 38, 21, 50, 45, 38, 44, 14, 35, 0, 26, 15, 43, 18, 43, 3,
		9, 22, 27, 45, 22, 26, 44, 36, 2, 36, 24, 39, 36, 13, 12, 39, 16, 12, 27, 28, 40, 24, 11, 37, 28, 48, 11, 36, 4, 48,
		0, 15, 47, 38, 26, 46, 4, 47, 2, 37, 23, 26, 42, 41, 30, 43, 35, 44, 12, 47, 9, 35, 46, 31, 15, 20, 7, 30, 8, 25,
		15, 4, 37, 24, 11, 47, 9, 13, 24, 12, 25, 0, 15, 3, 24, 40, 48, 44, 8, 18, 29, 12, 29, 41, 0, 22, 42, 44, 38, 18,
		31, 26, 1, 11, 25, 14, 33, 39, 12, 37, 5, 16, 18, 13, 44, 13, 50, 6, 14, 50, 37, 41, 11, 23, 40, 13, 42, 6, 33, 28,
		4, 17, 35, 36, 14, 49, 36, 10, 39, 13, 9, 18, 2, 22, 32, 6, 26, 42, 35, 20, 11, 36, 20, 14, 22, 41, 46, 27, 7, 31,
		42, 34, 30, 7, 16, 28, 17, 21, 10, 21, 19, 43, 32, 6, 28, 22, 41, 4, 3, 46, 48, 6, 46, 12, 23, 15, 38, 8, 13, 44,
		50, 20, 2, 0, 3, 27, 27, 5, 22, 36, 7, 19, 19, 12, 35, 26, 38, 27, 25, 34, 10, 14, 16, 37, 23, 1, 33, 42, 42, 49, 2,
		43, 35, 34, 4, 17, 10, 6, 21, 13, 43, 0, 4, 15, 50, 9, 30, 36, 6, 3, 23, 12, 47, 0, 28, 35, 39, 7, 46, 41, 1, 14, 8,
		47, 27, 19, 26, 24, 49, 14, 40, 50, 26, 34, 25, 35, 9, 7, 10, 4, 50, 6, 24, 37, 20, 30, 6, 24, 5, 20, 9, 1, 46, 20,
		12, 17, 15, 32, 48, 18, 15, 26, 41, 16, 4, 14, 34, 37, 27, 19, 31, 46, 7, 25, 11, 37, 34, 25, 39, 50, 20, 46, 11,
		24, 46, 40, 40, 47, 14, 32, 40, 50, 43, 34, 8, 27, 4, 44, 21, 49, 10, 16, 7, 1, 34, 4, 6, 40, 37, 49, 29, 40, 10,
		35, 43, 41, 33, 29, 50, 12, 8, 36, 42, 45, 22, 20, 49, 47, 21, 10, 31, 39, 45, 10, 25, 20, 21, 37, 9, 23, 29, 48,
		25, 4, 32, 36, 48, 27, 35, 19, 50, 38, 24, 28, 12, 23, 42, 23, 21, 35, 10, 23, 28, 23, 15, 0, 9, 43, 39, 32, 32, 39,
		1, 50, 6, 33, 1, 16, 34, 4, 27, 38, 45, 21, 19, 0, 0, 46, 24, 28, 16, 6, 29, 7, 7, 11, 47, 28, 11, 27, 36, 23, 45,
		0, 3, 28, 34, 7, 49, 27, 24, 33, 5, 18, 40, 38, 37, 23, 0, 50, 24, 44, 9, 44, 44, 48, 0, 36, 22, 46, 41, 18, 13, 32,
		48, 3, 48, 1, 22, 8, 26, 32, 37, 39, 8, 20, 1, 48, 12, 36, 41, 2, 40, 49, 46, 32, 6, 0, 4, 32, 41, 49, 7, 39, 31, 0,
		8, 36, 10, 27, 36, 26, 19, 32, 29, 39, 46, 36, 22, 36, 2, 6, 30, 20, 39, 12, 4, 45, 23, 13, 26, 37, 11, 34, 33, 20,
		39, 25, 44, 39, 1, 49, 40, 41, 14, 34, 34, 27, 31, 21, 25, 19, 42, 41, 4, 22, 19, 38, 47, 47, 5, 6, 16, 45, 44, 44,
		26, 33, 22, 24, 8, 38, 13, 3, 48, 9, 28, 21, 38, 26, 5, 3, 40, 42, 9, 42, 25, 30, 33, 7, 24, 33, 33, 33, 22, 18, 33,
		16, 43, 30, 43, 31, 19, 47, 47, 31, 13, 39, 9, 10, 19, 50, 0, 12, 12, 6, 7, 5, 43, 13, 11, 43, 16, 40, 10, 3, 18, 3,
		7, 28, 41, 44, 28, 33, 23, 3, 3, 25, 27, 37, 29, 48, 43, 23, 30, 38, 42, 30, 26, 32, 13, 3, 13, 39, 46, 48, 46, 32,
		15, 21, 39, 34, 23, 20, 1, 25, 12, 20, 39, 43, 48, 38, 12, 7, 21, 49, 11, 27, 15, 10, 43, 23, 49, 41, 9, 22, 22, 6,
		30, 19, 1, 11, 6, 32, 3, 29, 27, 44, 24, 48, 11, 2, 25, 28, 31, 44, 41, 4, 21, 48, 16, 0, 5, 3, 46, 47, 4, 50, 45,
		17, 29, 48, 9, 46, 40, 9, 29, 16, 23, 49, 26, 17, 39, 29, 24, 30, 27, 49, 40, 2, 46, 23, 13, 3, 39, 29, 48, 31, 46,
		49, 32, 50, 39, 35, 4, 25, 42, 20, 13, 31, 29, 39, 3, 33, 18, 13, 9, 7, 32, 11, 12, 5, 7, 4, 43, 1, 31, 1, 50, 46,
		46, 18, 20, 12, 44, 45, 19, 6, 41, 7, 49, 37, 28, 28, 6, 50, 31, 44, 0, 43, 11, 38, 29, 29, 34, 24, 12, 46, 6, 8, 0,
		26, 47, 30, 9, 45, 4, 29, 36, 19, 13, 19, 13, 3, 18, 7, 21, 2, 4, 37, 47, 14, 18, 32, 8, 46, 3, 35, 30, 18, 19, 5,
		46, 3, 37, 19, 11, 9, 33, 32, 22, 50, 3, 3, 42, 38, 39, 39, 25, 17, 10, 37, 33, 38, 13, 26, 18, 39, 46, 29, 33, 34,
		18, 49, 2, 34, 44, 25, 47, 45, 7, 6, 31, 6, 45, 33, 13, 24, 3, 48, 43, 4, 33, 43, 42, 37, 27, 34, 13, 1, 7, 49, 35,
		38, 25, 34, 10, 25, 14, 26, 39, 43, 30, 41, 21, 39, 50, 38, 6, 2, 31, 48, 37, 24, 24, 16, 17, 29, 12, 8, 15, 34, 39,
		43, 28, 24, 10, 35, 46, 11, 1, 21, 20, 7, 8, 29, 24, 1, 9, 24, 30, 25, 23, 35, 22, 23, 39, 26, 35, 20, 25, 6, 35, 7,
		38, 17, 20, 33, 22, 5, 42, 9, 11, 19, 25, 22, 34, 25, 9, 21, 31, 26, 7, 32, 19, 5, 45, 40, 45, 8, 24, 42, 3, 43, 4,
		40, 26, 22, 36, 43, 19, 16, 2, 17, 34, 9, 33, 34, 9, 11, 13, 3, 41, 48, 26, 35, 41, 23, 40, 7, 37, 10, 24, 44, 45,
		10, 15, 43, 50, 45, 49, 24, 29, 43, 34, 39, 33, 33, 33, 15, 40, 44, 11, 34, 31, 14, 30, 4, 25, 4, 9, 25, 3, 7, 37,
		46, 42, 22, 43, 33, 6, 28, 8, 9, 49, 44, 48, 20, 0, 46, 10, 27, 30, 41, 35, 21, 44, 25, 9, 44, 12, 41, 17, 37, 16,
		5, 32, 23, 36, 38, 15, 39, 36, 21, 6, 24, 49, 16, 40, 6, 20, 44, 23, 49, 21, 11, 10, 38, 24, 35, 22, 5, 49, 2, 25,
		17, 19, 40, 25, 49, 38, 21, 37, 21, 40, 43, 7, 42, 9, 42, 17, 37, 23, 2, 49, 13, 26, 48, 17, 14, 39, 31, 31, 23, 2,
		50, 33, 0, 49, 45, 31, 36, 42, 45, 30, 28, 32, 49, 10, 27, 45, 26, 5, 22, 29, 36, 33, 38, 35, 45, 41, 25, 21, 0, 5,
		19, 49, 6, 0, 24, 32, 40, 44, 7, 1, 30, 8, 14, 16, 2, 28, 6, 25, 24, 28, 32, 7, 2, 37, 46, 48, 46, 41, 18, 33, 25,
		41, 50, 48, 10, 20, 1, 42, 47, 13, 6, 50, 27, 35, 3, 25, 21, 28, 35, 33, 15, 11, 26, 47, 16, 15, 12, 9, 37, 40, 47,
		28, 38, 9, 14, 23, 34, 4, 48, 4, 5, 40, 0, 33, 43, 25, 22, 7, 33, 31, 30, 47, 33, 37, 12, 0, 16, 46, 44, 43, 28, 7,
		35, 6, 22, 48, 10, 26, 31, 20, 6, 33, 11, 50, 6, 38, 6, 3, 14, 33, 13, 49, 15, 33, 16, 44, 8, 39, 30, 43, 37, 34,
		45, 41, 8, 45, 3, 31, 10, 33, 44, 26, 22, 1, 10, 26, 23, 22, 6, 41, 47, 5, 5, 18, 1, 14, 25, 44, 11, 3, 13, 30, 9,
		9, 44, 5, 6, 22, 10, 9, 27, 7, 1, 13, 22, 1, 33, 8, 0, 31, 15, 6, 17, 10, 44, 23, 42, 10, 37, 22, 47, 8, 0, 26, 9,
		15, 24, 39, 18, 16, 17, 32, 44, 5, 49, 3, 3, 24, 49, 27, 45, 26, 33, 34, 29, 12, 19, 43, 13, 50, 15, 43, 34, 3, 12,
		35, 6, 0, 40, 27, 3, 25, 11, 6, 47, 20, 13, 35, 45, 11, 9, 23, 25, 22, 10, 45, 31, 45, 14, 11, 33, 14, 19, 31, 29,
		16, 31, 49, 9, 11, 29, 14, 4, 40, 25, 45, 38, 48, 47, 41, 48, 22, 48, 41, 33, 17, 25, 5, 31, 44, 17, 12, 38, 1, 49,
		29, 40, 28, 5, 42, 38, 45, 20, 34, 26, 43, 10, 3, 17, 23, 8, 44, 28, 47, 41, 35, 4, 16, 12, 12, 22, 15, 38, 49, 33,
		10, 37, 37, 8, 46, 9, 49, 12, 18, 21, 45, 9, 31, 31, 37, 24, 27, 20, 6, 38, 33, 42, 19, 5, 19, 45, 42, 7, 30, 14,
		25, 47, 26, 34, 3, 9, 48, 30, 48, 13, 14, 42, 10, 47, 47, 4, 27, 22, 16, 8, 23, 14, 10, 13, 19, 48, 49, 30, 19, 14,
		4, 19, 7, 24, 15, 21, 31, 50, 6, 4, 33, 9, 40, 21, 37, 35, 9, 1, 29, 29, 46, 24, 31, 22, 48, 1, 10, 0, 37, 10, 39,
		36, 4, 45, 29, 45, 11, 48, 7, 34, 23, 28, 14, 42, 41, 28, 0, 36, 4, 50, 7, 11, 47, 22, 48, 29, 31, 50, 45, 10, 26,
		31, 44, 48, 0, 20, 44, 27, 16, 16, 29, 43, 0, 44, 42, 24, 18, 18, 44, 21, 10, 30, 48, 19, 0, 27, 44, 23, 18, 5, 30,
		10, 11, 7, 23, 50, 1, 28, 15, 11, 5, 26, 43, 5, 40, 25, 50, 37, 33, 29, 18, 49, 30, 12, 48, 4, 28, 15, 30, 20, 14,
		25, 2, 7, 8, 20, 34, 37, 17, 8, 31, 39, 37, 8, 8, 39, 49, 44, 0, 33, 22, 31, 5, 28, 28, 46, 41, 43, 50, 44, 37, 13,
		21, 47, 44, 47, 40, 16, 42, 16, 50, 31, 47, 30, 1, 24, 9, 30, 42, 34, 27, 21, 45, 34, 42, 12, 14, 41, 21, 42, 0, 49,
		20, 45, 28, 37, 26, 26, 22, 22, 19, 38, 43, 20, 42, 50, 11, 40, 41, 20, 4, 10, 35, 32, 37, 36, 39, 18, 8, 7, 39, 34,
		0, 17, 10, 11, 4, 21, 40, 7, 27, 16, 16, 4, 14, 28, 39, 38, 0, 9, 5, 34, 15, 6, 30, 18, 8, 22, 40, 31, 10, 28, 49,
		29, 9, 40, 12, 13, 14, 48, 34, 10, 46, 32, 4, 5, 13, 43, 19, 26, 14, 36, 27, 7, 38, 41, 18, 0, 13, 30, 40, 16, 45,
		6, 39, 38, 31, 37, 22, 10, 19, 2, 24, 49, 6, 47, 45, 36, 23, 42, 36, 49, 48, 42, 31, 43, 19, 45, 47, 50, 27, 39, 8,
		30, 33, 49, 39, 34, 33, 20, 14, 40, 48, 8, 40, 33, 16, 33, 17, 7, 3, 24, 16, 23, 34, 39, 13, 16, 3, 27, 7, 14, 25,
		40, 37, 9, 15, 32, 47, 28, 49, 42, 1, 5, 21, 5, 1, 4, 20, 6, 12, 44, 9, 16, 45, 43, 2, 24, 46, 13, 3, 30, 43, 42,
		12, 16, 38, 37, 45, 6, 47, 21, 29, 10, 29, 24, 46, 20, 21, 44, 44, 37, 10, 4, 35, 12, 42, 26, 45, 21, 26, 39, 18,
		16, 0, 15, 39, 35, 30, 28, 14, 5, 47, 27, 16, 10, 21, 47, 47, 20, 9, 41, 50, 0, 24, 11, 49, 49, 23, 22, 23, 5, 6,
		19, 23, 42, 42, 23, 24, 39, 35, 12, 47, 39, 22, 35, 36, 23, 9, 9, 27, 28, 5, 48, 21, 8, 20, 16, 46, 45, 4, 30, 21,
		49, 34, 24, 12, 36, 0, 14, 18, 49, 44, 12, 9, 15, 6, 47, 24, 9, 37, 2, 10, 38, 49, 40, 16, 0, 38, 43, 2, 21, 0, 18,
		6, 38, 45, 46, 24, 8, 20, 40, 39, 32, 7, 4, 10, 48, 38, 44, 33, 9, 13, 22, 47, 33, 20, 12, 49, 46, 33, 1, 20, 2, 15,
		13, 29, 19, 14, 8, 34, 29, 35, 41, 29, 24, 14, 48, 48, 40, 2, 2, 13, 28, 40, 13, 4, 18, 37, 41, 10, 18, 22, 35, 7,
		39, 46, 3, 17, 44, 16, 48, 7, 25, 23, 25, 31, 24, 31, 36, 25, 16, 19, 11, 34, 37, 44, 38, 6, 50, 16, 33, 42, 47, 41,
		2, 43, 35, 35, 3, 3, 44, 12, 11, 7, 48, 44, 22, 25, 24, 38, 18, 49, 38, 50, 21, 5, 0, 0, 49, 26, 19, 42, 37, 43, 40,
		0, 21, 46, 13, 33, 25, 32, 37, 50, 17, 2, 39, 36, 20, 9, 18, 2, 9, 30, 41, 24, 39, 6, 26, 17, 38, 11, 2, 17, 24, 26,
		21, 14, 15, 2, 26, 17, 45, 7, 9, 9, 35, 46, 43, 16, 34, 34, 11, 10, 19, 13, 44, 22, 44, 32, 21, 36, 23, 35, 7, 47,
		39, 17, 32, 46, 2, 42, 48, 30, 17, 5, 12, 48, 50, 49, 22, 35, 19, 35, 42, 13, 34, 33, 31, 24, 49, 0, 2, 39, 41, 37,
		14, 18, 34, 12, 2, 38, 18, 46, 42, 38, 15, 44, 42, 27, 18, 45, 35, 5, 15, 24, 5, 22, 23, 12, 33, 0, 4, 13, 23, 15,
		47, 18, 47, 47, 21, 38, 6, 20, 26, 44, 50, 39, 30, 5, 9, 19, 48, 36, 39, 49, 32, 33, 25, 23, 5, 31, 48, 26, 46, 41,
		28, 3, 9, 9, 9, 35, 7, 46, 32, 43, 26, 6, 6, 26, 2, 32, 45, 50, 4, 42, 0, 6, 26, 43, 10, 22, 40, 35, 22, 29, 50, 23,
		3, 7, 23, 28, 26, 22, 6, 42, 15, 22, 43, 15, 24, 26, 2, 41, 18, 11, 24, 31, 18, 50, 1, 22, 45, 9, 47, 12, 45, 45,
		31, 0, 15, 24, 31, 39, 42, 25, 39, 48, 16, 49, 11, 30, 42, 26, 44, 23, 3, 46, 42, 50, 1, 16, 39, 10, 18, 42, 35, 8,
		7, 36, 48, 3, 46, 17, 49, 27, 40, 41, 13, 16, 43, 30, 3, 41, 29, 16, 48, 50, 31, 9, 15, 28, 19, 18, 48, 40, 24, 10,
		23, 36, 24, 22, 18, 34, 3, 1, 41, 14, 6, 32, 13, 40, 50, 0, 49, 0, 49, 29, 34, 39, 13, 0, 44, 39, 39, 1, 44, 1, 38,
		46, 0, 10, 31, 35, 26, 7, 50, 32, 18, 8, 43, 28, 20, 13, 1, 35, 36, 8, 43, 23, 9, 11, 47, 27, 14, 2, 48, 27, 15, 42,
		26, 24, 34, 34, 2, 3, 20, 32, 18, 39, 12, 42, 27, 46, 21, 38, 24, 22, 14, 33, 33, 16, 3, 21, 28, 40, 35, 25, 46, 8,
		38, 33, 34, 30, 23, 1, 49, 8, 9, 33, 17, 44, 8, 6, 10, 13, 36, 30, 28, 21, 37, 14, 8, 46, 5, 6, 32, 13, 10, 43, 48,
		12, 4, 47, 37, 24, 13, 5, 17, 15, 12, 3, 41, 11, 50, 16, 20, 26, 29, 30, 30, 9, 36, 10, 19, 49, 38, 27, 48, 10, 50,
		37, 18, 10, 50, 18, 42, 18, 39, 4, 0, 15, 48, 23, 13, 1, 37, 41, 19, 45, 3, 0, 39, 24, 28, 45, 30, 2, 16, 33, 3, 44,
		16, 12, 9, 31, 34, 35, 5, 24, 2, 5, 48, 35, 28, 11, 39, 8, 34, 24, 35, 4, 33, 33, 18, 32, 50, 18, 21, 23, 12, 2, 49,
		42, 19, 46, 14, 42, 3, 47, 35, 2, 23, 42, 34, 22, 30, 0, 11, 1, 24, 50, 10, 35, 22, 40, 12, 41, 46, 0, 24, 40, 47,
		15, 7, 22, 10, 4, 35, 38, 0, 23, 30, 29, 26, 48, 39, 26, 29, 39, 43, 10, 15, 14, 29, 34, 0, 3, 0, 9, 5, 15, 1, 20,
		20, 37, 42, 50, 35, 45, 49, 26, 16, 28, 9, 20, 47, 30, 16, 11, 1, 7, 11, 26, 4, 33, 13, 36, 19, 20, 11, 45, 24, 43,
		7, 48, 40, 35, 13, 43, 10, 16, 44, 16, 5, 45, 27, 32, 4, 26, 9, 32, 16, 39, 48, 45, 22, 9, 35, 26, 10, 46, 28, 18,
		41, 9, 18, 42, 5, 42, 29, 45, 20, 35, 15, 13, 8, 44, 49, 48, 43, 14, 43, 48, 22, 32, 4, 1, 39, 18, 3, 1, 15, 17, 3,
		35, 6, 46, 8, 4, 9, 36, 23, 10, 31, 46, 11, 43, 23, 26, 17, 14, 12, 19, 21, 21, 15, 21, 38, 21, 37, 43, 45, 5, 43,
		15, 22, 16, 2, 34, 49, 37, 8, 7, 8, 47, 18, 40, 47, 19, 47, 42, 34, 10, 17, 50, 6, 47, 35, 21, 8, 28, 35, 29, 27,
		10, 27, 28, 40, 15, 7, 27, 18, 30, 40, 28, 32, 48, 40, 26, 5, 41, 24, 2, 36, 32, 40, 13, 34, 9, 47, 45, 6, 10, 22,
		42, 28, 47, 20, 37, 9, 30, 17, 6, 3, 44, 40, 16, 40, 7, 12, 12, 23, 38, 33, 49, 39, 32, 37, 31, 15, 24, 25, 19, 7,
		37, 19, 31, 27, 44, 3, 47, 14, 14, 45, 30, 25, 35, 43, 8, 39, 10, 25, 5, 37, 39, 25, 18, 8, 33, 40, 2, 3, 48, 33, 1,
		50, 37, 17, 40, 41, 7, 2, 17, 14, 10, 5, 32, 11, 15, 30, 46, 43, 11, 50, 2, 22, 24, 32, 49, 50, 26, 50, 23, 10, 35,
		12, 30, 50, 39, 6, 38, 25, 17, 6, 10, 22, 45, 41, 5, 36, 2, 7, 33, 39, 28, 29, 8, 40, 3, 4, 30, 29, 42, 19, 12, 4,
		30, 2, 45, 9, 25, 10, 17, 47, 13, 27, 50, 22, 4, 8, 28, 19, 15, 1, 12, 36, 5, 2, 29, 38, 8, 36, 8, 27, 13, 7, 42,
		31, 50, 30, 37, 24, 9, 30, 45, 25, 21, 47, 37, 45, 16, 24, 43, 46, 9, 6, 34, 11, 32, 19, 39, 48, 48, 24, 6, 46, 27,
		10, 29, 27, 17, 13, 27, 4, 9, 41, 42, 13, 17, 27, 50, 21, 22, 37, 25, 16, 1, 46, 39, 23, 10, 10, 26, 31, 50, 32, 4,
		26, 48, 34, 41, 0, 22, 25, 45, 15, 0, 13, 23, 6, 5, 39, 15, 14, 6, 43, 17, 49, 29, 0, 40, 6, 28, 9, 50, 0, 32, 22,
		24, 17, 17, 6, 4, 35, 18, 46, 0, 23, 33, 25, 17, 1, 43, 1, 39, 12, 45, 8, 30, 12, 48, 46, 40, 8, 46, 33, 11, 49, 6,
		24, 46, 40, 28, 44, 31, 31, 10, 38, 16, 32, 11, 7, 27, 23, 34, 23, 36, 30, 22, 4, 50, 24, 38, 40, 21, 31, 17, 32,
		27, 11, 49, 37, 44, 27, 38, 47, 42, 19, 4, 32, 11, 11, 15, 11, 10, 28, 17, 50, 40, 11, 32, 30, 17, 34, 18, 21, 28,
		33, 14, 34, 11, 35, 28, 29, 28, 43, 26, 32, 26, 11, 48, 32, 31, 43, 3, 17, 16, 39, 24, 4, 39, 47, 9, 8, 18, 26, 50,
		22, 5, 34, 26, 10, 16, 10, 14, 16, 36, 26, 3, 27, 4, 37, 36, 18, 10, 21, 12, 18, 43, 32, 27, 10, 46, 33, 48, 21, 18,
		46, 1, 22, 45, 12, 17, 49, 24, 24, 6, 50, 20, 26, 21, 20, 2, 45, 16, 20, 25, 42, 16, 36, 37, 19, 7, 25, 29, 4, 49,
		30, 35, 4, 16, 36, 35, 32, 32, 34, 16, 3, 25, 19, 29, 20, 23, 12, 50, 14, 2, 18, 46, 9, 16, 16, 49, 4, 25, 7, 25,
		42, 42, 47, 43, 27, 28, 50, 3, 31, 16, 35, 16, 29, 19, 28, 14, 5, 4, 45, 22, 21, 4, 28, 4, 34, 34, 44, 37, 1, 20,
		24, 36, 32, 13, 17, 1, 41, 37, 2, 32, 41, 6, 0, 32, 38, 31, 21, 14, 26, 5, 29, 49, 8, 47, 47, 49, 42, 49, 34, 47,
		42, 3, 3, 13, 2, 26, 46, 45, 27, 37, 39, 1, 15, 14, 12, 30, 10, 29, 30, 37, 35, 26, 13, 30, 46, 8, 32, 21, 11, 0,
		15, 47, 50, 36, 14, 3, 43, 38, 47, 13, 49, 13, 3, 16, 39, 25, 8, 23, 34, 18, 42, 41, 8, 33, 15, 36, 46, 1, 34, 27,
		41, 37, 12, 33, 20, 35, 16, 12, 50, 0, 38, 43, 43, 1, 12, 36, 48, 37, 50, 27, 24, 38, 40, 9, 25, 40, 43, 36, 30, 42,
		23, 37, 35, 38, 15, 7, 22, 19, 50, 29, 28, 31, 5, 31, 2, 27, 23, 15, 40, 50, 27, 32, 4, 35, 46, 1, 35, 7, 4, 17, 13,
		6, 36, 13, 38, 10, 28, 33, 30, 7, 47, 24, 36, 3, 29, 27, 8, 34, 49, 20, 30, 0, 13, 7, 40, 47, 17, 21, 36, 7, 19, 8,
		15, 22, 39, 22, 49, 0, 47, 50, 34, 28, 13, 21, 21, 35, 7, 7, 18, 3, 39, 35, 45, 16, 18, 28, 16, 3, 32, 37, 48, 11,
		16, 25, 30, 40, 44, 27, 9, 32, 50, 30, 15, 33, 39, 26, 23, 46, 26, 48, 50, 4, 7, 23, 11, 27, 26, 49, 19, 49, 21, 34,
		1, 3, 17, 46, 28, 17, 23, 10, 36, 27, 49, 42, 47, 20, 19, 41, 23, 32, 7, 41, 13, 35, 33, 12, 9, 8, 37, 48, 21, 36,
		43, 47, 23, 11, 22, 35, 49, 38, 32, 37, 38, 44, 8, 45, 37, 41, 4, 30, 12, 3, 41, 8, 1, 17, 50, 35, 16, 21, 41, 9,
		26, 34, 34, 21, 28, 6, 42, 11, 3, 50, 4, 18, 37, 17, 44, 50, 12, 21, 42, 24, 7, 33, 27, 50, 14, 3, 3, 22, 10, 29,
		36, 10, 21, 33, 42, 49, 46, 47, 18, 26, 31, 50, 11, 41, 44, 18, 5, 22, 48, 22, 34, 36, 1, 39, 32, 27, 32, 33, 22,
		35, 2, 26, 21, 21, 8, 25, 7, 29, 44, 26, 49, 10, 7, 46, 25, 10, 39, 15, 15, 37, 42, 45, 5, 39, 20, 38, 32, 19, 7,
		50, 50, 30, 2, 41, 32, 16, 40, 48, 4, 23, 9, 41, 8, 24, 50, 33, 37, 48, 20, 42, 6, 39, 43, 18, 19, 19, 47, 41, 34,
		24, 8, 11, 20, 13, 14, 20, 26, 17, 9, 13, 23, 31, 7, 16, 45, 11, 22, 20, 15, 6, 20, 41, 47, 24, 41, 32, 29, 38, 18,
		29, 30, 23, 39, 45, 43, 34, 47, 50, 19, 41, 49, 1, 14, 49, 23, 14, 50, 31, 37, 7, 22, 6, 16, 9, 21, 27, 1, 30, 29,
		20, 40, 8, 35, 6, 11, 38, 14, 43, 49, 8, 47, 21, 40, 14, 19, 5, 22, 14, 10, 47, 42, 48, 31, 8, 35, 40, 19, 0, 24, 4,
		6, 13, 23, 26, 38, 46, 33, 4, 48, 29, 36, 35, 22, 30, 7, 19, 0, 6, 13, 17, 34, 3, 11, 23, 1, 42, 22, 19, 50, 24, 47,
		8, 38, 46, 35, 1, 8, 47, 5, 3, 7, 9, 29, 48, 41, 13, 47, 49, 19, 6, 50, 31, 49, 11, 7, 40, 26, 12, 30, 19, 31, 27,
		38, 30, 12, 37, 39, 2, 14, 47, 15, 13, 6, 0, 33, 31, 2, 35, 13, 46, 23, 38, 2, 38, 38, 19, 19, 10, 13, 24, 38, 31,
		40, 1, 45, 29, 28, 8, 6, 7, 48, 30, 12, 39, 28, 5, 22, 3, 13, 22, 15, 27, 27, 19, 25, 40, 8, 16, 26, 31, 38, 29, 23,
		23, 41, 34, 11, 39, 24, 46, 30, 34, 12, 40, 38, 38, 36, 12, 35, 20, 50, 17, 3, 24, 47, 29, 32, 40, 2, 14, 21, 20,
		38, 6, 33, 33, 22, 5, 41, 49, 20, 44, 3, 6, 33, 35, 4, 4, 38, 19, 10, 43, 37, 26, 12, 21, 25, 18, 3, 45, 45, 20, 34,
		8, 13, 0, 32, 19, 14, 38, 26, 49, 19, 25, 7, 8, 29, 1, 13, 14, 17, 29, 47, 12, 4, 15, 34, 3, 6, 40, 13, 23, 40, 48,
		23, 37, 24, 27, 2, 28, 16, 36, 46, 38, 32, 12, 29, 18, 37, 19, 8, 34, 34, 12, 50, 9, 1, 25, 8, 45, 48, 9, 10, 11,
		40, 45, 1, 22, 42, 48, 42, 21, 46, 49, 6, 5, 29, 12, 33, 15, 16, 26, 20, 34, 17, 46, 50, 17, 39, 9, 25, 20, 43, 40,
		39, 44, 49, 15, 49, 20, 35, 33, 26, 7, 32, 0, 7, 9, 2, 9, 24, 17, 32, 44, 12, 46, 3, 27, 30, 35, 38, 31, 33, 44, 11,
		18, 4, 43, 27, 25, 24, 47, 38, 39, 35, 14, 10, 13, 3, 7, 11, 32, 19, 40, 0, 21, 4, 10, 10, 5, 35, 15, 18, 39, 26,
		40, 18, 39, 44, 8, 30, 50, 33, 1, 26, 3, 46, 42, 41, 26, 33, 35, 30, 43, 5, 13, 11, 48, 14, 2, 15, 19, 32, 46, 2, 2,
		48, 40, 16, 43, 31, 44, 44, 22, 22, 13, 13, 3, 46, 32, 50, 25, 1, 37, 14, 31, 0, 47, 46, 18, 28, 44, 50, 15, 42, 13,
		36, 9, 17, 0, 50, 34, 40, 28, 3, 0, 41, 14, 38, 43, 30, 41, 13, 43, 18, 35, 30, 47, 35, 7, 13, 20, 41, 4, 15, 23,
		34, 10, 36, 46, 11, 33, 36, 38, 31, 47, 24, 25, 47, 31, 47, 13, 10, 30, 40, 15, 26, 35, 18, 5, 43, 32, 26, 30, 5,
		19, 46, 15, 49, 24, 38, 10, 46, 19, 8, 0, 7, 21, 1, 17, 24, 7, 12, 14, 10, 39, 14, 46, 46, 22, 11, 42, 24, 50, 14,
		6, 20, 4, 32, 28, 10, 42, 50, 1, 45, 18, 25, 30, 19, 6, 8, 3, 24, 41, 46, 32, 2, 5, 29, 23, 30, 20, 32, 44, 8, 24,
		31, 13, 41, 7, 37, 31, 20, 41, 33, 46, 40, 38, 15, 6, 47, 23, 4, 42, 16, 48, 30, 43, 12, 5, 25, 8, 15, 33, 42, 34,
		24, 3, 1, 30, 39, 40, 37, 22, 32, 5, 11, 33, 16, 47, 10, 16, 36, 29, 3, 26, 49, 8, 6, 22, 8, 36, 8, 36, 50, 37, 38,
		41, 4, 41, 44, 28, 17, 9, 14, 36, 4, 49, 41, 44, 6, 6, 18, 48, 12, 39, 2, 21, 33, 33, 14, 6, 22, 21, 20, 5, 6, 34,
		46, 26, 41, 14, 3, 0, 44, 15, 34, 24, 43, 25, 1, 42, 16, 0, 8, 48, 16, 45, 10, 15, 49, 46, 4, 2, 6, 0, 9, 2, 10, 31,
		9, 14, 35, 8, 6, 3, 5, 24, 29, 47, 20, 48, 27, 33, 3, 46, 2, 12, 2, 10, 24, 2, 13, 44, 33, 22, 23, 44, 26, 38, 25,
		23, 50, 27, 17, 47, 23, 4, 14, 3, 34, 25, 16, 44, 11, 18, 24, 29, 39, 43, 6, 46, 1, 21, 6, 7, 9, 47, 26, 22, 21, 1,
		2, 0, 4, 22, 19, 40, 33, 34, 20, 39, 38, 37, 46, 24, 26, 45, 22, 22, 1, 27, 25, 24, 14, 41, 23, 48, 4, 34, 30, 27,
		38, 25, 46, 26, 7, 49, 36, 10, 42, 49, 12, 17, 16, 30, 10, 27, 31, 22, 40, 45, 0, 9, 30, 41, 40, 24, 18, 49, 34, 41,
		42, 14, 39, 11, 10, 36, 27, 3, 2, 14, 16, 1, 33, 11, 26, 16, 8, 34, 30, 32, 5, 34, 38, 46, 31, 36, 5, 20, 49, 42,
		13, 36, 11, 20, 8, 30, 44, 32, 17, 47, 46, 25, 0, 38, 14, 47, 2, 20, 43, 38, 32, 18, 30, 3, 32, 43, 1, 41, 11, 21,
		20, 34, 16, 39, 11, 7, 18, 13, 7, 22, 17, 7, 50, 26, 5, 21, 40, 1, 13, 36, 13, 43, 42, 26, 7, 45, 11, 27, 10, 14, 6,
		14, 34, 22, 19, 46, 20, 18, 29, 37, 23, 28, 31, 9, 34, 20, 11, 6, 27, 12, 6, 21, 31, 7, 26, 49, 29, 48, 13, 10, 1,
		8, 29, 21, 26, 12, 4, 20, 43, 25, 33, 25, 38, 13, 21, 0, 23, 32, 15, 34, 16, 26, 42, 15, 7, 8, 14, 41, 24, 49, 37,
		17, 1, 47, 50, 45, 49, 47, 25, 40, 37, 14, 34, 47, 35, 3, 13, 10, 47, 3, 46, 36, 27, 38, 34, 38, 1, 44, 14, 20, 29,
		13, 1, 3, 30, 35, 2, 3, 2, 32, 46, 15, 34, 22, 39, 17, 44, 43, 47, 12, 47, 4, 10, 39, 27, 41, 5, 5, 25, 3, 40, 29,
		37, 31, 42, 25, 41, 15, 47, 46, 20, 24, 8, 22, 6, 27, 15, 5, 40, 13, 43, 41, 0, 36, 22, 19, 10, 31, 0, 37, 30, 3,
		49, 49, 37, 1, 25, 38, 4, 14, 34, 17, 47, 27, 38, 38, 35, 32, 17, 46, 32, 41, 42, 45, 34, 38, 48, 7, 10, 28, 14, 41,
		7, 38, 25, 47, 17, 18, 20, 46, 21, 36, 3, 26, 39, 20, 39, 17, 48, 44, 13, 34, 30, 4, 37, 22, 45, 0, 36, 45, 31, 15,
		24, 10, 27, 10, 45, 41, 41, 49, 9, 42, 34, 44, 21, 30, 43, 19, 9, 16, 43, 11, 32, 5, 4, 31, 35, 23, 32, 46, 28, 49,
		45, 49, 42, 14, 10, 16, 11, 29, 13, 31, 22, 38, 37, 1, 36, 5, 49, 25, 0, 8, 7, 39, 1, 43, 44, 44, 20, 25, 24, 16,
		36, 23, 50, 38, 26, 3, 23, 31, 39, 8, 36, 19, 21, 0, 33, 33, 20, 12, 12, 13, 48, 22, 31, 29, 9, 7, 30, 48, 5, 40, 3,
		30, 17, 27, 39, 5, 35, 13, 16, 40, 0, 12, 40, 49, 43, 2, 7, 9, 15, 50, 45, 30, 17, 26, 27, 38, 5, 45, 26, 37, 25,
		47, 23, 17, 38, 17, 39, 36, 24, 29, 38, 45, 46, 22, 0, 18, 11, 26, 26, 10, 45, 41, 6, 2, 7, 10, 11, 44, 44, 42, 7,
		24, 9, 40, 27, 42, 32, 18, 18, 4, 26, 0, 22, 20, 49, 8, 24, 14, 46, 44, 31, 50, 29, 47, 27, 43, 0, 25, 13, 46, 27,
		33, 37, 49, 41, 46, 44, 34, 19, 12, 45, 36, 43, 17, 28, 12, 9, 10, 45, 4, 39, 3, 10, 38, 3, 17, 44, 30, 11, 20, 47,
		16, 49, 15, 20, 22, 39, 19, 8, 12, 40, 19, 24, 48, 20, 50, 44, 4, 17, 14, 17, 26, 37, 9, 4, 9, 13, 46, 15, 17, 22,
		15, 18, 45, 39, 20, 10, 24, 31, 4, 0, 17, 8, 5, 42, 40, 44, 30, 12, 30, 46, 42, 9, 31, 36, 22, 41, 39, 31, 25, 28,
		8, 44, 36, 45, 31, 19, 34, 39, 32, 19, 28, 40, 24, 40, 24, 37, 33, 43, 37, 12, 1, 26, 19, 26, 2, 43, 43, 32, 9, 7,
		30, 12, 5, 43, 5, 46, 36, 5, 16, 32, 28, 31, 48, 50, 8, 13, 22, 12, 33, 29, 10, 46, 0, 2, 50, 3, 36, 5, 29, 30, 33,
		22, 24, 18, 30, 39, 13, 14, 24, 6, 20, 21, 4, 26, 3, 50, 50, 16, 29, 18, 15, 9, 21, 11, 48, 41, 26, 2, 19, 22, 47,
		36, 37, 4, 48, 39, 1, 20, 26, 29, 1, 9, 25, 24, 50, 24, 7, 26, 23, 5, 18, 16, 5, 20, 32, 12, 24, 16, 1, 30, 22, 17,
		21, 18, 30, 27, 42, 4, 42, 46, 35, 11, 34, 23, 6, 7, 50, 18, 31, 30, 30, 21, 38, 35, 19, 46, 34, 5, 13, 11, 42, 23,
		24, 46, 30, 6, 21, 33, 18, 26, 23, 2, 20, 45, 9, 44, 2, 21, 40, 27, 21, 34, 17, 29, 50, 46, 25, 1, 15, 0, 34, 6, 6,
		47, 14, 15, 50, 17, 24, 13, 6, 42, 3, 15, 8, 37, 8, 7, 21, 34, 15, 8, 24, 22, 15, 6, 9, 9, 22, 13, 0, 37, 2, 34, 8,
		10, 39, 33, 30, 32, 6, 1, 32, 23, 1, 38, 20, 40, 25, 30, 17, 42, 9, 44, 39, 26, 17, 48, 3, 26, 31, 5, 41, 13, 0, 23,
		36, 31, 16, 41, 22, 40, 6, 30, 35, 34, 24, 26, 21, 47, 18, 16, 43, 0, 8, 10, 9, 27, 16, 1, 27, 29, 19, 24, 46, 1,
		32, 9, 40, 15, 25, 50, 5, 18, 11, 30, 21, 40, 23, 22, 10, 5, 42, 17, 29, 38, 27, 16, 11, 14, 16, 16, 21, 38, 26, 45,
		23, 0, 18, 9, 24, 6, 29, 21, 17, 37, 27, 46, 17, 0, 1, 35, 5, 1, 1, 29, 15, 44, 13, 1, 39, 25, 35, 21, 50, 39, 27,
		35, 32, 45, 41, 38, 47, 43, 2, 35, 13, 18, 42, 36, 42, 33, 7, 50, 15, 25, 9, 17, 37, 5, 1, 19, 26, 12, 1, 19, 19,
		36, 8, 32, 50, 7, 13, 49, 43, 21, 21, 44, 20, 6, 19, 50, 33, 6, 13, 46, 24, 29, 3, 8, 6, 34, 15, 10, 19, 37, 0, 38,
		31, 32, 13, 41, 13, 46, 17, 19, 7, 14, 2, 21, 35, 16, 6, 41, 27, 43, 48, 44, 0, 49, 13, 49, 40, 36, 13, 44, 0, 9, 7,
		30, 50, 12, 27, 22, 1, 48, 39, 37, 21, 35, 14, 12, 41, 11, 18, 13, 17, 40, 38, 23, 44, 46, 28, 18, 34, 27, 22, 39,
		31, 24, 2, 17, 12, 15, 7, 14, 11, 44, 40, 13, 9, 2, 2, 20, 10, 43, 24, 29, 39, 20, 30, 15, 42, 26, 30, 12, 33, 25,
		32, 8, 24, 40, 43, 1, 3, 32, 43, 34, 26, 25, 6, 27, 7, 3, 29, 12, 49, 4, 27, 20, 12, 27, 3, 24, 43, 31, 31, 34, 20,
		21, 2, 18, 28, 46, 19, 22, 40, 38, 31, 26, 16, 30, 14, 35, 26, 10, 34, 25, 40, 24, 32, 16, 4, 26, 31, 30, 5, 25, 19,
		48, 32, 13, 9, 21, 49, 34, 33, 41, 45, 29, 38, 46, 3, 0, 7, 43, 46, 36, 50, 27, 38, 46, 13, 49, 32, 7, 46, 21, 22,
		9, 12, 18, 25, 9, 17, 6, 47, 24, 50, 14, 1, 44, 50, 3, 13, 25, 39, 23, 49, 34, 7, 41, 15, 2, 17, 22, 45, 36, 29, 26,
		32, 34, 6, 11, 34, 45, 49, 28, 35, 0, 21, 33, 20, 0, 26, 13, 39, 14, 7, 26, 25, 44, 22, 23, 32, 15, 14, 20, 21, 2,
		40, 8, 11, 38, 6, 46, 27, 10, 35, 19, 42, 47, 13, 41, 41, 44, 37, 3, 42, 7, 19, 33, 1, 16, 47, 22, 43, 3, 8, 15, 15,
		27, 50, 42, 39, 35, 17, 30, 26, 30, 20, 45, 35, 35, 31, 28, 14, 12, 13, 47, 49, 25, 46, 20, 12, 1, 6, 29, 38, 26,
		18, 36, 29, 23, 8, 48, 46, 39, 48, 38, 10, 28, 40, 40, 18, 41, 27, 10, 22, 48, 4, 17, 12, 40, 8, 47, 44, 45, 15, 48,
		5, 46, 20, 47, 48, 22, 34, 35, 45, 38, 40, 12, 49, 19, 10, 49, 24, 12, 26, 0, 39, 26, 18, 19, 35, 40, 21, 9, 11, 50,
		28, 43, 22, 32, 35, 49, 37, 42, 18, 45, 50, 9, 48, 30, 35, 16, 3, 48, 8, 46, 15, 1, 1, 38, 29, 22, 6, 34, 3, 43, 10,
		41, 34, 46, 17, 33, 41, 35, 1, 48, 49, 12, 10, 4, 23, 11, 28, 47, 17, 50, 31, 27, 50, 18, 8, 33, 10, 21, 25, 45, 25,
		2, 44, 47, 9, 50, 47, 46, 12, 19, 38, 12, 18, 18, 30, 7, 13, 34, 50, 20, 12, 1, 17, 50, 7, 47, 31, 2, 8, 35, 39, 45,
		39, 47, 31, 33, 15, 13, 40, 46, 22, 27, 16, 23, 44, 29, 32, 16, 34, 6, 13, 45, 22, 46, 23, 24, 30, 29, 28, 7, 45, 8,
		20, 4, 33, 50, 49, 0, 43, 37, 27, 14, 46, 9, 10, 39, 46, 32, 43, 3, 10, 21, 1, 23, 35, 1, 2, 6, 14, 50, 26, 16, 6,
		46, 23, 35, 28, 43, 5, 6, 30, 21, 7, 9, 35, 1, 14, 11, 41, 10, 22, 9, 7, 46, 44, 35, 10, 43, 26, 14, 42, 1, 32, 45,
		47, 37, 8, 6, 25, 21, 22, 35, 26, 37, 46, 40, 9, 12, 7, 46, 50, 5, 26, 3, 34, 15, 5, 3, 49, 25, 9, 31, 48, 26, 50,
		44, 23, 12, 44, 38, 19, 44, 23, 44, 19, 5, 19, 34, 7, 0, 23, 27, 27, 38, 3, 7, 8, 22, 18, 10, 12, 3, 1, 2, 36, 12,
		25, 4, 2, 5, 16, 48, 7, 24, 36, 50, 47, 25, 21, 15, 12, 30, 10, 29, 33, 44, 36, 18, 28, 39, 36, 35, 11, 39, 0, 23,
		4, 32, 16, 13, 31, 32, 11, 7, 7, 23, 45, 9, 5, 50, 41, 9, 35, 13, 39, 7, 1, 40, 47, 28, 6, 7, 33, 39, 34, 21, 3, 34,
		21, 7, 47, 22, 30, 26, 15, 30, 50, 14, 22, 34, 9, 11, 28, 36, 7, 14, 27, 43, 4, 39, 37, 29, 13, 44, 14, 1, 23, 38,
		25, 50, 19, 46, 1, 8, 9, 6, 27, 46, 16, 8, 4, 38, 9, 22, 15, 46, 29, 1, 46, 2, 30, 49, 37, 40, 19, 20, 21, 37, 4, 9,
		30, 33, 42, 31, 18, 3, 13, 39, 37, 24, 40, 17, 44, 21, 17, 28, 41, 14, 11, 1, 19, 18, 15, 21, 45, 29, 25, 24, 3, 25,
		27, 5, 21, 33, 40, 6, 0, 15, 48, 26, 27, 4, 49, 47, 9, 43, 14, 2, 6, 37, 48, 24, 49, 4, 4, 41, 44, 27, 30, 6, 14,
		30, 17, 17, 42, 15, 32, 5, 10, 33, 33, 28, 18, 2, 1, 19, 6, 31, 48, 43, 42, 37, 29, 33, 43, 16, 46, 6, 35, 2, 46,
		36, 35, 27, 34, 36, 1, 2, 14, 6, 39, 7, 19, 18, 41, 47, 10, 43, 33, 7, 26, 46, 40, 46, 11, 27, 27, 35, 34, 40, 49,
		19, 40, 26, 6, 34, 42, 6, 10, 38, 48, 30, 40, 30, 12, 17, 7, 11, 32, 47, 34, 14, 36, 16, 3, 39, 18, 26, 23, 31, 5,
		31, 25, 14, 32, 37, 40, 46, 35, 26, 29, 25, 33, 41, 8, 11, 0, 2, 7, 16, 0, 50, 44, 38, 47, 20, 49, 0, 29, 9, 2, 23,
		10, 12, 35, 31, 24, 7, 5, 43, 0, 39, 37, 6, 21, 1, 21, 17, 3, 50, 34, 49, 8, 21, 19, 26, 28, 41, 47, 3, 36, 32, 23,
		15, 45, 42, 26, 39, 2, 6, 6, 31, 41, 15, 40, 36, 23, 19, 35, 11, 40, 25, 4, 12, 4, 44, 3, 43, 50, 21, 24, 9, 18, 30,
		29, 10, 45, 33, 45, 16, 32, 36, 45, 33, 42, 43, 35, 33, 32, 44, 47, 46, 0, 14, 29, 8, 40, 30, 47, 38, 41, 26, 43,
		43, 2, 12, 10, 42, 24, 9, 27, 14, 41, 22, 26, 50, 48, 12, 21, 29, 19, 16, 0, 49, 40, 34, 24, 41, 26, 31, 48, 49, 20,
		35, 24, 20, 14, 19, 18, 18, 19, 10, 41, 42, 32, 45, 47, 30, 38, 36, 46, 17, 35, 11, 16, 30, 3, 19, 30, 47, 1, 13, 1,
		26, 22, 48, 44, 23, 34, 27, 33, 3, 27, 1, 34, 47, 1, 5, 48, 42, 9, 8, 8, 10, 0, 2, 20, 7, 20, 25, 48, 27, 12, 19,
		32, 46, 44, 29, 32, 10, 49, 26, 43, 48, 6, 45, 33, 29, 4, 41, 13, 42, 34, 28, 7, 27, 31, 12, 0, 17, 37, 45, 33, 17,
		43, 2, 33, 30, 48, 2, 2, 31, 2, 3, 50, 17, 28, 8, 47, 41, 49, 14, 38, 30, 2, 10, 21, 34, 22, 45, 14, 44, 27, 50, 8,
		46, 21, 10, 6, 19, 37, 13, 38, 29, 37, 37, 47, 16, 14, 21, 25, 7, 9, 35, 35, 23, 22, 40, 34, 21, 49, 48, 43, 15, 36,
		43, 44, 18, 48, 21, 34, 40, 22, 16, 28, 7, 40, 50, 17, 33, 24, 7, 33, 30, 18, 11, 12, 0, 5, 17, 16, 35, 37, 0, 16,
		45, 41, 21, 16, 0, 38, 12, 40, 41, 33, 13, 31, 6, 41, 49, 27, 2, 12, 39, 3, 34, 13, 48, 35, 14, 24, 13, 48, 9, 30,
		5, 40, 7, 19, 0, 34, 35, 15, 43, 27, 22, 14, 5, 21, 19, 24, 3, 16, 37, 0, 15, 0, 34, 26, 9, 17, 45, 32, 37, 46, 35,
		29, 6, 7, 37, 17, 45, 43, 2, 39, 0, 46, 40, 20, 34, 27, 8, 47, 0, 2, 3, 33, 5, 5, 5, 49, 32, 47, 21, 18, 48, 30, 0,
		36, 7, 6, 3, 35, 4, 10, 13, 39, 20, 41, 26, 25, 35, 22, 43, 49, 48, 4, 32, 10, 18, 46, 2, 12, 49, 40, 37, 36, 9, 39,
		7, 46, 9, 4, 25, 27, 5, 35, 45, 4, 7, 33, 8, 38, 6, 16, 12, 24, 31, 30, 49, 9, 42, 33, 38, 31, 26, 45, 28, 12, 21,
		48, 5, 3, 22, 16, 47, 20, 16, 43, 17, 34, 50, 28, 46, 17, 1, 14, 25, 19, 46, 32, 0, 42, 6, 47, 33, 4, 5, 47, 40, 13,
		4, 32, 10, 46, 26, 47, 3, 39, 17, 25, 7, 12, 4, 25, 2, 45, 5, 16, 10, 47, 23, 42, 47, 28, 32, 2, 46, 27, 3, 11, 16,
		31, 17, 50, 23, 50, 30, 11, 12, 3, 39, 40, 27, 43, 24, 14, 4, 18, 19, 8, 43, 1, 28, 19, 21, 40, 10, 13, 23, 47, 0,
		36, 19, 21, 29, 5, 38, 12, 21, 20, 1, 11, 24, 25, 15, 0, 36, 8, 42, 10, 14, 36, 9, 14, 5, 21, 34, 11, 33, 6, 5, 4,
		26, 25, 13, 44, 4, 13, 0, 13, 33, 5, 15, 18, 46, 3, 15, 15, 48, 29, 6, 14, 25, 38, 19, 22, 37, 28, 17, 47, 18, 49,
		15, 26, 8, 24, 20, 3, 2, 2, 5, 35, 26, 6, 3, 14, 28, 26, 6, 42, 28, 4, 10, 16, 7, 14, 9, 35, 35, 2, 2, 0, 48, 31,
		16, 11, 37, 1, 28, 23, 0, 48, 15, 37, 43, 31, 8, 5, 19, 27, 36, 28, 44, 5, 30, 2, 42, 23, 33, 28, 9, 25, 46, 45, 44,
		4, 0, 21, 0, 33, 0, 16, 30, 6, 14, 19, 8, 23, 28, 8, 8, 31, 5, 48, 39, 32, 11, 45, 3, 41, 10, 39, 29, 49, 22, 19,
		11, 36, 36, 36, 5, 15, 4, 28, 42, 24, 42, 28, 25, 37, 18, 31, 0, 33, 16, 15, 24, 32, 50, 18, 18, 43, 32, 30, 26, 28,
		6, 41, 30, 42, 22, 47, 24, 13, 49, 12, 49, 41, 6, 36, 36, 0, 50, 46, 40, 38, 39, 49, 43, 7, 4, 35, 14, 32, 6, 14, 2,
		50, 48, 3, 40, 37, 14, 50, 4, 35, 17, 10, 3, 25, 9, 50, 43, 25, 24, 22, 40, 12, 12, 5, 15, 34, 19, 32, 31, 27, 43,
		46, 22, 48, 45, 27, 32, 3, 26, 44, 37, 3, 10, 8, 25, 19, 30, 19, 1, 17, 37, 33, 0, 32, 11, 19, 47, 44, 9, 23, 47,
		50, 18, 11, 40, 27, 35, 32, 29, 6, 47, 39, 25, 21, 28, 46, 19, 17, 21, 48, 9, 39, 39, 29, 27, 12, 34, 29, 33, 48,
		35, 32, 23, 45, 15, 45, 1, 37, 43, 13, 42, 50, 26, 19, 4, 10, 27, 38, 25, 12, 43, 17, 12, 18, 4, 14, 48, 1, 24, 2,
		47, 16, 38, 21, 31, 27, 24, 50, 20, 43, 29, 40, 38, 50, 20, 49, 4, 8, 41, 20, 44, 39, 47, 20, 8, 43, 7, 0, 37, 16,
		18, 24, 49, 20, 48, 3, 36, 42, 49, 21, 7, 25, 6, 33, 49, 16, 26, 15, 26, 7, 39, 16, 46, 8, 48, 33, 8, 15, 41, 47, 9,
		30, 35, 28, 25, 12, 11, 28, 10, 3, 28, 40, 2, 25, 34, 38, 46, 19, 21, 34, 23, 50, 44, 27, 38, 41, 37, 19, 29, 1
	]

	@staticmethod
	def minMaxSumMean(array):
		minimum = 1.0e9
		maximum = 0.0
		sum = 0.0
		for value in array:
			minimum = value if value < minimum else minimum
			maximum = value if value > maximum else maximum
			sum += value

		return minimum, maximum, sum, sum/len(array)

	def runSizedTests(self, func: Callable[[int], Callable[[], None]], counts: Iterable[int]):
		print()
		print(f"         min           mean          median        max")
		for count in counts:
			results = timeit.repeat(func(count), repeat=20, number=50)
			norm = count / 10

			minimum, maximum, _, mean = self.minMaxSumMean(results)
			print(f"{count:>6}x: {minimum/norm:.6f} s    {mean/norm:.6f} s    {median(results)/norm:.6f} s    {maximum/norm:.6f} s")
