/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef CHATWGT_H
#define CHATWGT_H

#include <QPushButton>
#include <QGridLayout>
#include <QTextEdit>
#include <QUdpSocket>
#include <QHostInfo>
#include <QLineEdit>
#include <QByteArray>
#include <QTabWidget>
#include <QColor>
#include <QSettings>
#include <QAction>
#include <QMenu>
#include <QMenuBar>
#include <QKeyEvent>
#include <QCloseEvent>
#include <QDialog>
#include <QTimer>
#include <QToolButton>
#include <QComboBox>
#include <QSplashScreen>
#include <QToolBar>
#include <QMainWindow>
#include <QTranslator>
#include <QLabel>
#include <QSystemTrayIcon>

#include <QCursor>

#include <QListWidget>
#include <QStackedWidget>
#include <QScrollArea>
#include <QTreeView>

#include "messagewithcheckbox.h"
#include "userlisticonformat.h"

class LogWgt;
class AddChannelDlg;
class EditUserInfoDlg;
class PreferencesDlg;
class ChatCore;
class ChannelWgt;
class SmilesWgt;
class UserWgt;
class InputTextWgt;
class QChatTrayIcon;
class Message;
class SingleMsgsHistoryView;
class QChatWidgetPlugin;
class FormattingToolBar;

struct QC_DatagramHeader;

#include "userinfo.h"

#include "singlemsgshistorymodel.h"

/**
        @author Anistratov Oleg <ower@users.sourceforge.net>
*/
class ChatWgt : public QMainWindow
{
  Q_OBJECT
  friend class ChatCore;

  private:
    QLabel*       m_profilesLab;

    QTranslator*  m_translator;
    ChatCore*     m_chatCore;

    QToolButton*  m_addChannelBtn;
    QToolButton*  m_delChannelBtn;
    QComboBox*    m_profilesCmbx;

    QTabWidget*   mw_tabs;

    QToolBar*     m_mainToolBar;
    QToolBar*     m_profilesToolBar;
    QToolBar*     m_pluginsToolBar;
    FormattingToolBar* m_formattingToolBar;
    QList<QToolBar*> m_toolbars;

    QMenuBar*     m_menuBar;
    QMenu*        m_menuFile;
    QMenu*        m_menuView;
    QMenu*        m_menuSettings;
    QMenu*        m_menuHelp;
    QMenu*        m_menuTranslations;
    QMenu*        m_menuToolbars;

    QAction*      m_connectToServerAct;
    QAction*      m_disconnectFromServerAct;
    QAction*      m_setServerModeAct;
    QAction*      m_setServerlessModeAct;

    QAction*      m_showSettingsAct;
    QAction*      m_showPreferencesAct;
    QAction*      m_showSmilesAct;
    QAction*      m_showEditShortcutsAct;
    QAction*      m_exitAct;
    QAction*      m_addChannelAct;
    QAction*      m_delChannelAct;
    QAction*      m_aboutAct;
    QAction*      m_aboutQtAct;
    QAction*      m_licenseAct;
    QAction*      m_writeSettingsAct;
    QAction*      m_addProfileAct;
    QAction*      m_deleteProfileAct;
    QAction*      m_renameProfileAct;
    QAction*      m_translatePlAct;
    QAction*      m_translateUkAct;
    QAction*      m_translateRuAct;
    QAction*      m_translateEnAct;
    QAction*      m_translateEsAct;
    QAction*      m_translateDeAct;
    QAction*      m_translateSrAct;

    QAction*      m_showMainTBarAct;
    QAction*      m_showProfilesTBarAct;
    QAction*      m_showPluginsTBarAct;
    QAction*      m_showFormattingTBarAct;

    QAction*      m_showSingleMessagesAct;
    QAction*      m_showPluginsAct;
    QAction*      m_broadcastMessageAct;

    QAction*      m_toolButtonsSizeDefault;
    QAction*      m_toolButtonsSize16;
    QAction*      m_toolButtonsSize24;
    QAction*      m_toolButtonsSize32;
    QAction*      m_toolButtonsSize48;

    LogWgt*       mw_log;
    SmilesWgt*    mw_smiles;
    QList<ChannelWgt*>  mw_channels;

    SingleMsgsHistoryView*     m_smhView;

    AddChannelDlg*             m_addChannelDlg;
    EditUserInfoDlg*           m_userInfoDlg;
    PreferencesDlg*            m_preferencesDlg;

    QChatTrayIcon* m_trayIcon;

    QTimer* m_activityTimer;
    int m_cursorX;
    int m_cursorY;

//     QList<QChatWidgetPlugin*> m_widgetPlugins;
    QList<QObject*> m_allPlugins;
    QTabWidget*     m_pluginsTabs;
    QStackedWidget* m_widgetsStack;

    QScrollArea* m_smilesScrllArea;

    bool m_hidePlugins;

    QListWidget* m_sectionsWgt;

  private:
    void retranslate  ();
    void createActions();
    void createWidgets();
    void setupLayout  ();
    void updateShortcuts();
    void setIcons     ();
    void createChannel(const QString &, quint64 = 0);

    QMenu* createPopupMenu();

  public:
    ChatWgt(ChatCore* chc, QWidget* parent = 0);
    ~ChatWgt();

    QString currentChannelName() const ;
    ChannelWgt* findChannel(const QString & name   , quint32 = 0) const ;
    ChannelWgt* findChannel(quint64, quint32 = 0) const ;
    void fillProfilesCmbx(const QStringList & profiles, const QString & current);

    const QList<ChannelWgt*> channels() const {return mw_channels;}

    void restoreAndShow();

    QChatWidgetPlugin* isPLugin(QWidget*);

    UserInfo* findUser(quint64);

    FormattingToolBar* formattingToolBar(){return m_formattingToolBar;}
    void addToolbar(QToolBar*);

    ChatCore* core(){return m_chatCore;}

    void setHidePlugins(bool b){m_hidePlugins = b;}

    SingleMsgsHistoryView* smhView() const {return m_smhView;}

  public slots:
    void setLanguage();

    void slot_addChannell    (const QString & name){createChannel(name);}
    void slot_privateChat    (const QString & name, quint64 uid){createChannel(name, uid);}
    void slot_delChannell    ();
    void slot_sendFile       (quint64);
    void slot_receiveFile    (const QString &, quint16, quint64);
    void slot_singleMessageIn(SingleMessage*, bool);
    void slot_about();
    void slot_aboutQt();
    void slot_license();
    void slot_showSettings();
    void slot_showPreferences();
    void slot_showUserInfo(UserWgt*);
    void slot_showSmiles();
    void slot_activateWindow();

    void slot_insertSmile(const QString &);
    void slot_openSocketError(quint16);
    void slot_exit();
    void slot_trayIconClicked(QSystemTrayIcon::ActivationReason);

    void slot_setCurrentProfileName(const QString &);
    void slot_reloadProfileData    ();

    void slot_editProfileName();
    void slot_addProfile     ();
    void slot_delProfile     ();
    void slot_changeSmileTheme(const QString &);
    void slot_focusChanged(QWidget*, QWidget*);
    void slot_processData(QC_DatagramHeader*);

    void activity();

    void slot_showSingleMessagesHistory();

    void showSingleMessage(const QModelIndex &);
    void showPlugins();

    void pluginSwitched();
    void setupPluginToolBar(QWidget*);

    void connect2server();
    void disconnectFromServer();
    void disconnectedFromServer();

    void chvisConnectToServerAct();
    void swapConnectDisconnectAct()
    {
      bool vis = m_connectToServerAct->isVisible();
      m_disconnectFromServerAct->setVisible(vis);
      m_connectToServerAct     ->setVisible(!vis);
    }

   void setToolbarsIconsSize();
   void setToolButtonsStyle ();

   void changeIconFormat(const UserListIconFormat&);

   void showConfigureShortcuts();
   void sendBroadcastMessage();

   void loadPlugin(const QString&);
   void unloadPlugin(const QString&);

   void setAnimationsRunning(bool);

   void setMode();

  protected:
    void keyPressEvent(QKeyEvent* ev);
    void mousePressEvent(QMouseEvent * ev){ QWidget::mousePressEvent(ev);}
    void closeEvent(QCloseEvent* ev);

  signals:
    void singleMessageOut (const QString &, quint64, bool);
    void singleMessage    (const QString &, quint64, bool);
    void closed           ();
    void wantLoadProfile  (const QString &);
    void wantRenameProfile(const QString &, const QString &);
    void wantDeleteProfile(const QString &);
    void wantChangeStyleSheet(const QString &);
};

#endif
