% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_mut_matrix.R
\name{pool_mut_mat}
\alias{pool_mut_mat}
\title{Pool multiple samples from a mutation matrix together}
\usage{
pool_mut_mat(mut_matrix, grouping)
}
\arguments{
\item{mut_matrix}{Mutation count matrix (dimensions: x mutation types
X n samples)}

\item{grouping}{Grouping variable}
}
\value{
Mutation count matrix (dimensions: x mutation types
X n groups)
}
\description{
The mutation counts of columns (samples) are added up according to the grouping variable.
}
\examples{
## See the 'mut_matrix()' example for how we obtained the mutation matrix:
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
  package = "MutationalPatterns"
))
grouping <- c(rep("colon", 3), rep("intestine", 3), rep("liver", 3))
pool_mut_mat(mut_mat, grouping)
}
