% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-browse.r
\name{BROWSE}
\alias{BROWSE}
\title{Open specified url in browser.}
\usage{
BROWSE(url = NULL, config = list(), ..., handle = NULL)
}
\arguments{
\item{url}{the url of the page to retrieve}

\item{config}{All configuration options are ignored because the request
is handled by the browser, not \pkg{RCurl}.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc,
passed on to \code{\link[=modify_url]{modify_url()}}. Unnamed parameters will be combined
with \code{\link[=config]{config()}}.}

\item{handle}{The handle to use with this request. If not
supplied, will be retrieved and reused from the \code{\link[=handle_pool]{handle_pool()}}
based on the scheme, hostname and port of the url. By default \pkg{httr}
requests to the same scheme/host/port combo. This substantially reduces
connection time, and ensures that cookies are maintained over multiple
requests to the same host. See \code{\link[=handle_pool]{handle_pool()}} for more
details.}
}
\value{
A \code{\link[=response]{response()}} object.
}
\description{
(This isn't really a http verb, but it seems to follow the same format).
}
\details{
Only works in interactive sessions.
}
\examples{
BROWSE("http://google.com")
BROWSE("http://had.co.nz")
}
\seealso{
Other http methods: \code{\link{DELETE}},
  \code{\link{GET}}, \code{\link{HEAD}},
  \code{\link{PATCH}}, \code{\link{POST}},
  \code{\link{PUT}}, \code{\link{VERB}}
}
\concept{http methods}
