#### Note: this error code is no longer emitted by the compiler

This is because it was too specific to the `inline` attribute.
Similar diagnostics occur for other attributes too.
The example here will now emit `E0539`


Erroneous code example:

```compile_fail,E0539
#[inline(unknown)] // error: invalid argument
pub fn something() {}

fn main() {}
```

The `inline` attribute only supports two arguments:

 * always
 * never

All other arguments given to the `inline` attribute will return this error.
Example:

```
#[inline(never)] // ok!
pub fn something() {}

fn main() {}
```

For more information see the [`inline` Attribute][inline-attribute] section
of the Reference.

[inline-attribute]: https://doc.rust-lang.org/reference/attributes/codegen.html#the-inline-attribute
