
(define-module (intr-gtk4-examples calc2 plugin-root-dialog-impl)

  #:use-module (oop goops)
  #:use-module (g-golf)
  #:use-module (intr-gtk4-examples calc2 current-filename)

  #:duplicates (merge-generics
                replace
                warn-override-core
                warn
                last)

  #:export (<plugin-root-dialog>))


(define %module-path
  (dirname (my-current-filename)))
  ;; ".")

(eval-when (expand load eval)

  (g-irepository-require "Gtk" #:version "4.0")

  (for-each (lambda (name)
              (gi-import-by-name "Gtk" name))
      '("Window"
        "Button"
        "Label"
        "DropDown")))


(define-class <plugin-root-dialog> (<gtk-window>)
  (dropdown-index #:child-id "dropdown-index")
  (button-conf #:child-id "button-conf")
  (button-ok #:child-id "button-ok")

  #:template (string-append %module-path
                            "/plugin-root-dialog-ui.ui")

  #:child-ids '("dropdown-index"
                "button-conf"
                "button-ok"))


(define-public (plugin-root-dialog-new)
  (make <plugin-root-dialog>))

