#!/usr/bin/env python
# coding: utf-8
# /*##########################################################################
#
# Copyright (c) 2017 European Synchrotron Radiation Facility
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# ###########################################################################*/
"""This module describe tomogui applications which are available  through
the silx launcher.

Your environment should provide a command `tomogui`. You can reach help with
`tomogui --help`, and check the version with `tomogui --version`.
"""

__authors__ = ["V. Valls", "P. Knobel", "H. Payno"]
__license__ = "MIT"
__date__ = "24/09/2017"


import logging
logging.basicConfig()

import sys
from silx.utils.launcher import Launcher
import tomogui._version


def main():
    """Main function of the launcher

    This function is referenced in the setup.py file, to create a
    launcher script generated by setuptools.

    :rtype: int
    :returns: The execution status
    """
    launcher = Launcher(prog="tomogui", version=tomogui._version.version)
    launcher.add_command("creator",
                         module_name="tomogui.app.creator",
                         description="Create an absorption matrix creator")
    launcher.add_command("norm",
                         module_name="tomogui.app.norm",
                         description="Launch matrix normer application")
    launcher.add_command("project",
                         module_name="tomogui.app.project",
                         description="Create a new tomogui project")
    launcher.add_command("recons",
                         module_name="tomogui.app.recons",
                         description="Launch the tomogui reconsparam manager")
    launcher.add_command("invert",
                         module_name="tomogui.app.invert",
                         description="Do a data.max() - data")
    launcher.add_command("materials",
                         module_name="tomogui.app.materials",
                         description="Allow materials edition from a .h5")
    launcher.add_command("test",
                         module_name="tomogui.app.test_",
                         description="Launch tomogui unittest")
    status = launcher.execute(sys.argv)
    return status


if __name__ == "__main__":
    # executed when using python -m PROJECT_NAME
    status = main()
    sys.exit(status)
