/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (C) 2019-21 Sean Anderson <seanga2@gmail.com>
 */

#ifndef CLOCK_K210_SYSCTL_H
#define CLOCK_K210_SYSCTL_H

/*
 * Arbitrary identifiers for clocks.
 */

#define K210_CLK_PLL0   0
#define K210_CLK_PLL1   1
#define K210_CLK_PLL2   2
#define K210_CLK_CPU    3
#define K210_CLK_SRAM0  4
#define K210_CLK_SRAM1  5
#define K210_CLK_ACLK   6
#define K210_CLK_CLINT  7
#define K210_CLK_APB0   8
#define K210_CLK_APB1   9
#define K210_CLK_APB2   10
#define K210_CLK_ROM    11
#define K210_CLK_DMA    12
#define K210_CLK_AI     13
#define K210_CLK_DVP    14
#define K210_CLK_FFT    15
#define K210_CLK_GPIO   16
#define K210_CLK_SPI0   17
#define K210_CLK_SPI1   18
#define K210_CLK_SPI2   19
#define K210_CLK_SPI3   20
#define K210_CLK_I2S0   21
#define K210_CLK_I2S1   22
#define K210_CLK_I2S2   23
#define K210_CLK_I2S0_M 24
#define K210_CLK_I2S1_M 25
#define K210_CLK_I2S2_M 26
#define K210_CLK_I2C0   27
#define K210_CLK_I2C1   28
#define K210_CLK_I2C2   29
#define K210_CLK_UART1  30
#define K210_CLK_UART2  31
#define K210_CLK_UART3  32
#define K210_CLK_AES    33
#define K210_CLK_FPIOA  34
#define K210_CLK_TIMER0 35
#define K210_CLK_TIMER1 36
#define K210_CLK_TIMER2 37
#define K210_CLK_WDT0   38
#define K210_CLK_WDT1   39
#define K210_CLK_SHA    40
#define K210_CLK_OTP    41
#define K210_CLK_RTC    42
#define K210_CLK_IN0	43

#endif /* CLOCK_K210_SYSCTL_H */
