; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck --check-prefix=CHECK --check-prefix=PENTIUM4 %s
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck --check-prefix=CHECK --check-prefix=AVX-512 %s

; PR3253

; The register+memory form of the BT instruction should be usable on
; pentium4, however it is currently disabled due to the register+memory
; form having different semantics than the register+register form.

; Test these patterns:
;    (X & (1 << N))  != 0  -->  BT(X, N).
;    ((X >>u N) & 1) != 0  -->  BT(X, N).
; as well as several variations:
;    - The second form can use an arithmetic shift.
;    - Either form can use == instead of !=.
;    - Either form can compare with an operand of the &
;      instead of with 0.
;    - The comparison can be commuted (only cases where neither
;      operand is constant are included).
;    - The and can be commuted.

define void @test2(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: test2:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jb .LBB0_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB0_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: test2:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    testb $1, %dil
; AVX-512-NEXT:    jne .LBB0_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB0_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = lshr i32 %x, %n
  %tmp3 = and i32 %tmp29, 1
  %tmp4 = icmp eq i32 %tmp3, 0
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @test2b(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: test2b:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jb .LBB1_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB1_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: test2b:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    testb $1, %dil
; AVX-512-NEXT:    jne .LBB1_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB1_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = lshr i32 %x, %n
  %tmp3 = and i32 1, %tmp29
  %tmp4 = icmp eq i32 %tmp3, 0
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @atest2(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: atest2:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jb .LBB2_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB2_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: atest2:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    testb $1, %dil
; AVX-512-NEXT:    jne .LBB2_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB2_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = ashr i32 %x, %n
  %tmp3 = and i32 %tmp29, 1
  %tmp4 = icmp eq i32 %tmp3, 0
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @atest2b(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: atest2b:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jb .LBB3_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB3_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: atest2b:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    testb $1, %dil
; AVX-512-NEXT:    jne .LBB3_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB3_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = ashr i32 %x, %n
  %tmp3 = and i32 1, %tmp29
  %tmp4 = icmp eq i32 %tmp3, 0
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @test3(i32 %x, i32 %n) nounwind {
; CHECK-LABEL: test3:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    btl %esi, %edi
; CHECK-NEXT:    jb .LBB4_2
; CHECK-NEXT:  # BB#1: # %bb
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:  .LBB4_2: # %UnifiedReturnBlock
; CHECK-NEXT:    retq
entry:
  %tmp29 = shl i32 1, %n
  %tmp3 = and i32 %tmp29, %x
  %tmp4 = icmp eq i32 %tmp3, 0
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @test3b(i32 %x, i32 %n) nounwind {
; CHECK-LABEL: test3b:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    btl %esi, %edi
; CHECK-NEXT:    jb .LBB5_2
; CHECK-NEXT:  # BB#1: # %bb
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:  .LBB5_2: # %UnifiedReturnBlock
; CHECK-NEXT:    retq
entry:
  %tmp29 = shl i32 1, %n
  %tmp3 = and i32 %x, %tmp29
  %tmp4 = icmp eq i32 %tmp3, 0
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @testne2(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: testne2:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jae .LBB6_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB6_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: testne2:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    testb $1, %dil
; AVX-512-NEXT:    je .LBB6_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB6_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = lshr i32 %x, %n
  %tmp3 = and i32 %tmp29, 1
  %tmp4 = icmp ne i32 %tmp3, 0
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @testne2b(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: testne2b:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jae .LBB7_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB7_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: testne2b:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    testb $1, %dil
; AVX-512-NEXT:    je .LBB7_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB7_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = lshr i32 %x, %n
  %tmp3 = and i32 1, %tmp29
  %tmp4 = icmp ne i32 %tmp3, 0
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @atestne2(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: atestne2:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jae .LBB8_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB8_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: atestne2:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    testb $1, %dil
; AVX-512-NEXT:    je .LBB8_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB8_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = ashr i32 %x, %n
  %tmp3 = and i32 %tmp29, 1
  %tmp4 = icmp ne i32 %tmp3, 0
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @atestne2b(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: atestne2b:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jae .LBB9_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB9_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: atestne2b:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    testb $1, %dil
; AVX-512-NEXT:    je .LBB9_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB9_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = ashr i32 %x, %n
  %tmp3 = and i32 1, %tmp29
  %tmp4 = icmp ne i32 %tmp3, 0
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @testne3(i32 %x, i32 %n) nounwind {
; CHECK-LABEL: testne3:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    btl %esi, %edi
; CHECK-NEXT:    jae .LBB10_2
; CHECK-NEXT:  # BB#1: # %bb
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:  .LBB10_2: # %UnifiedReturnBlock
; CHECK-NEXT:    retq
entry:
  %tmp29 = shl i32 1, %n
  %tmp3 = and i32 %tmp29, %x
  %tmp4 = icmp ne i32 %tmp3, 0
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @testne3b(i32 %x, i32 %n) nounwind {
; CHECK-LABEL: testne3b:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    btl %esi, %edi
; CHECK-NEXT:    jae .LBB11_2
; CHECK-NEXT:  # BB#1: # %bb
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:  .LBB11_2: # %UnifiedReturnBlock
; CHECK-NEXT:    retq
entry:
  %tmp29 = shl i32 1, %n
  %tmp3 = and i32 %x, %tmp29
  %tmp4 = icmp ne i32 %tmp3, 0
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @query2(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: query2:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jae .LBB12_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB12_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: query2:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    testb $1, %dil
; AVX-512-NEXT:    je .LBB12_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB12_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = lshr i32 %x, %n
  %tmp3 = and i32 %tmp29, 1
  %tmp4 = icmp eq i32 %tmp3, 1
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @query2b(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: query2b:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jae .LBB13_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB13_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: query2b:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    testb $1, %dil
; AVX-512-NEXT:    je .LBB13_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB13_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = lshr i32 %x, %n
  %tmp3 = and i32 1, %tmp29
  %tmp4 = icmp eq i32 %tmp3, 1
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @aquery2(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: aquery2:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jae .LBB14_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB14_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: aquery2:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    testb $1, %dil
; AVX-512-NEXT:    je .LBB14_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB14_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = ashr i32 %x, %n
  %tmp3 = and i32 %tmp29, 1
  %tmp4 = icmp eq i32 %tmp3, 1
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @aquery2b(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: aquery2b:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jae .LBB15_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB15_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: aquery2b:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    testb $1, %dil
; AVX-512-NEXT:    je .LBB15_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB15_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = ashr i32 %x, %n
  %tmp3 = and i32 1, %tmp29
  %tmp4 = icmp eq i32 %tmp3, 1
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @query3(i32 %x, i32 %n) nounwind {
; CHECK-LABEL: query3:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    btl %esi, %edi
; CHECK-NEXT:    jae .LBB16_2
; CHECK-NEXT:  # BB#1: # %bb
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:  .LBB16_2: # %UnifiedReturnBlock
; CHECK-NEXT:    retq
entry:
  %tmp29 = shl i32 1, %n
  %tmp3 = and i32 %tmp29, %x
  %tmp4 = icmp eq i32 %tmp3, %tmp29
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @query3b(i32 %x, i32 %n) nounwind {
; CHECK-LABEL: query3b:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    btl %esi, %edi
; CHECK-NEXT:    jae .LBB17_2
; CHECK-NEXT:  # BB#1: # %bb
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:  .LBB17_2: # %UnifiedReturnBlock
; CHECK-NEXT:    retq
entry:
  %tmp29 = shl i32 1, %n
  %tmp3 = and i32 %x, %tmp29
  %tmp4 = icmp eq i32 %tmp3, %tmp29
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @query3x(i32 %x, i32 %n) nounwind {
; CHECK-LABEL: query3x:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    btl %esi, %edi
; CHECK-NEXT:    jae .LBB18_2
; CHECK-NEXT:  # BB#1: # %bb
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:  .LBB18_2: # %UnifiedReturnBlock
; CHECK-NEXT:    retq
entry:
  %tmp29 = shl i32 1, %n
  %tmp3 = and i32 %tmp29, %x
  %tmp4 = icmp eq i32 %tmp29, %tmp3
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @query3bx(i32 %x, i32 %n) nounwind {
; CHECK-LABEL: query3bx:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    btl %esi, %edi
; CHECK-NEXT:    jae .LBB19_2
; CHECK-NEXT:  # BB#1: # %bb
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:  .LBB19_2: # %UnifiedReturnBlock
; CHECK-NEXT:    retq
entry:
  %tmp29 = shl i32 1, %n
  %tmp3 = and i32 %x, %tmp29
  %tmp4 = icmp eq i32 %tmp29, %tmp3
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @queryne2(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: queryne2:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jb .LBB20_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB20_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: queryne2:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    andl $1, %edi
; AVX-512-NEXT:    kmovw %edi, %k0
; AVX-512-NEXT:    kxnorw %k0, %k0, %k1
; AVX-512-NEXT:    kshiftrw $15, %k1, %k1
; AVX-512-NEXT:    kxorw %k1, %k0, %k0
; AVX-512-NEXT:    kmovw %k0, %eax
; AVX-512-NEXT:    testb %al, %al
; AVX-512-NEXT:    je .LBB20_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB20_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = lshr i32 %x, %n
  %tmp3 = and i32 %tmp29, 1
  %tmp4 = icmp ne i32 %tmp3, 1
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @queryne2b(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: queryne2b:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jb .LBB21_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB21_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: queryne2b:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    andl $1, %edi
; AVX-512-NEXT:    kmovw %edi, %k0
; AVX-512-NEXT:    kxnorw %k0, %k0, %k1
; AVX-512-NEXT:    kshiftrw $15, %k1, %k1
; AVX-512-NEXT:    kxorw %k1, %k0, %k0
; AVX-512-NEXT:    kmovw %k0, %eax
; AVX-512-NEXT:    testb %al, %al
; AVX-512-NEXT:    je .LBB21_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB21_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = lshr i32 %x, %n
  %tmp3 = and i32 1, %tmp29
  %tmp4 = icmp ne i32 %tmp3, 1
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @aqueryne2(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: aqueryne2:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jb .LBB22_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB22_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: aqueryne2:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    andl $1, %edi
; AVX-512-NEXT:    kmovw %edi, %k0
; AVX-512-NEXT:    kxnorw %k0, %k0, %k1
; AVX-512-NEXT:    kshiftrw $15, %k1, %k1
; AVX-512-NEXT:    kxorw %k1, %k0, %k0
; AVX-512-NEXT:    kmovw %k0, %eax
; AVX-512-NEXT:    testb %al, %al
; AVX-512-NEXT:    je .LBB22_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB22_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = ashr i32 %x, %n
  %tmp3 = and i32 %tmp29, 1
  %tmp4 = icmp ne i32 %tmp3, 1
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @aqueryne2b(i32 %x, i32 %n) nounwind {
; PENTIUM4-LABEL: aqueryne2b:
; PENTIUM4:       # BB#0: # %entry
; PENTIUM4-NEXT:    btl %esi, %edi
; PENTIUM4-NEXT:    jb .LBB23_2
; PENTIUM4-NEXT:  # BB#1: # %bb
; PENTIUM4-NEXT:    pushq %rax
; PENTIUM4-NEXT:    callq foo
; PENTIUM4-NEXT:    popq %rax
; PENTIUM4-NEXT:  .LBB23_2: # %UnifiedReturnBlock
; PENTIUM4-NEXT:    retq
;
; AVX-512-LABEL: aqueryne2b:
; AVX-512:       # BB#0: # %entry
; AVX-512-NEXT:    movl %esi, %ecx
; AVX-512-NEXT:    shrl %cl, %edi
; AVX-512-NEXT:    andl $1, %edi
; AVX-512-NEXT:    kmovw %edi, %k0
; AVX-512-NEXT:    kxnorw %k0, %k0, %k1
; AVX-512-NEXT:    kshiftrw $15, %k1, %k1
; AVX-512-NEXT:    kxorw %k1, %k0, %k0
; AVX-512-NEXT:    kmovw %k0, %eax
; AVX-512-NEXT:    testb %al, %al
; AVX-512-NEXT:    je .LBB23_2
; AVX-512-NEXT:  # BB#1: # %bb
; AVX-512-NEXT:    pushq %rax
; AVX-512-NEXT:    callq foo
; AVX-512-NEXT:    popq %rax
; AVX-512-NEXT:  .LBB23_2: # %UnifiedReturnBlock
; AVX-512-NEXT:    retq
entry:
  %tmp29 = ashr i32 %x, %n
  %tmp3 = and i32 1, %tmp29
  %tmp4 = icmp ne i32 %tmp3, 1
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @queryne3(i32 %x, i32 %n) nounwind {
; CHECK-LABEL: queryne3:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    btl %esi, %edi
; CHECK-NEXT:    jb .LBB24_2
; CHECK-NEXT:  # BB#1: # %bb
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:  .LBB24_2: # %UnifiedReturnBlock
; CHECK-NEXT:    retq
entry:
  %tmp29 = shl i32 1, %n
  %tmp3 = and i32 %tmp29, %x
  %tmp4 = icmp ne i32 %tmp3, %tmp29
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @queryne3b(i32 %x, i32 %n) nounwind {
; CHECK-LABEL: queryne3b:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    btl %esi, %edi
; CHECK-NEXT:    jb .LBB25_2
; CHECK-NEXT:  # BB#1: # %bb
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:  .LBB25_2: # %UnifiedReturnBlock
; CHECK-NEXT:    retq
entry:
  %tmp29 = shl i32 1, %n
  %tmp3 = and i32 %x, %tmp29
  %tmp4 = icmp ne i32 %tmp3, %tmp29
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @queryne3x(i32 %x, i32 %n) nounwind {
; CHECK-LABEL: queryne3x:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    btl %esi, %edi
; CHECK-NEXT:    jb .LBB26_2
; CHECK-NEXT:  # BB#1: # %bb
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:  .LBB26_2: # %UnifiedReturnBlock
; CHECK-NEXT:    retq
entry:
  %tmp29 = shl i32 1, %n
  %tmp3 = and i32 %tmp29, %x
  %tmp4 = icmp ne i32 %tmp29, %tmp3
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

define void @queryne3bx(i32 %x, i32 %n) nounwind {
; CHECK-LABEL: queryne3bx:
; CHECK:       # BB#0: # %entry
; CHECK-NEXT:    btl %esi, %edi
; CHECK-NEXT:    jb .LBB27_2
; CHECK-NEXT:  # BB#1: # %bb
; CHECK-NEXT:    pushq %rax
; CHECK-NEXT:    callq foo
; CHECK-NEXT:    popq %rax
; CHECK-NEXT:  .LBB27_2: # %UnifiedReturnBlock
; CHECK-NEXT:    retq
entry:
  %tmp29 = shl i32 1, %n
  %tmp3 = and i32 %x, %tmp29
  %tmp4 = icmp ne i32 %tmp29, %tmp3
  br i1 %tmp4, label %bb, label %UnifiedReturnBlock

bb:
  call void @foo()
  ret void

UnifiedReturnBlock:
  ret void
}

declare void @foo()

define zeroext i1 @invert(i32 %flags, i32 %flag) nounwind {
; CHECK-LABEL: invert:
; CHECK:       # BB#0:
; CHECK-NEXT:    notl %edi
; CHECK-NEXT:    btl %esi, %edi
; CHECK-NEXT:    setb %al
; CHECK-NEXT:    retq
  %neg = xor i32 %flags, -1
  %shl = shl i32 1, %flag
  %and = and i32 %shl, %neg
  %tobool = icmp ne i32 %and, 0
  ret i1 %tobool
}

