/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "cmpiOpenDRIM_OperatingSystemLoadAverages.h"

CMPIObjectPath* OS_OpenDRIM_OperatingSystemLoadAverages_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_OperatingSystemLoadAverages& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_OperatingSystemLoadAverages_classnames[0], OpenDRIM_OperatingSystemLoadAverages_NAMESPACE);

	if (!instance.Name_isNULL)
		op.addKey("Name", instance.Name);

	_L_;
	return op.getHdl();
}

CMPIInstance* OS_OpenDRIM_OperatingSystemLoadAverages_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_OperatingSystemLoadAverages& instance) {
	_E_;
	Objectpath op(broker, OS_OpenDRIM_OperatingSystemLoadAverages_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.InstanceID_isNULL)
		ci.setProperty("InstanceID", instance.InstanceID);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.LoadAverages_isNULL)
		ci.setProperty("LoadAverages", instance.LoadAverages);

	_L_;
	return ci.getHdl();
}

void OS_OpenDRIM_OperatingSystemLoadAverages_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_OperatingSystemLoadAverages& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	_L_;
}

void OS_OpenDRIM_OperatingSystemLoadAverages_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_OperatingSystemLoadAverages& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("LoadAverages", instance.LoadAverages) == OK)
		instance.LoadAverages_isNULL = false;

	_L_;
}

