#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Talos Principle
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250225.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='the-talos-principle'
GAME_NAME='The Talos Principle'

ARCHIVE_BASE_1_NAME='setup_the_talos_principle_gold_edition_1.01_(64bit)_(42512).exe'
ARCHIVE_BASE_1_MD5='b011b16d09532b2e709700477bc96017'
## Do not convert the file paths to lowercase
ARCHIVE_BASE_1_EXTRACTOR='innoextract'
ARCHIVE_BASE_1_EXTRACTOR_OPTIONS=' '
ARCHIVE_BASE_1_PART1_NAME='setup_the_talos_principle_gold_edition_1.01_(64bit)_(42512)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='2e2430b8a2991a4d24f1aaec583b2ec3'
ARCHIVE_BASE_1_PART2_NAME='setup_the_talos_principle_gold_edition_1.01_(64bit)_(42512)-2.bin'
ARCHIVE_BASE_1_PART2_MD5='3b8770c9fdcf8f670ff6d0b06f011cf0'
ARCHIVE_BASE_1_SIZE='6800000'
ARCHIVE_BASE_1_VERSION='1.01-gog42512'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/the_talos_principle_gold_edition'

ARCHIVE_BASE_0_NAME='setup_the_talos_principle_1.0_(64bit)_(41435).exe'
ARCHIVE_BASE_0_MD5='769f3ba085c913d2bc44e22726bdadc8'
## Do not convert the file paths to lowercase
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS=' '
ARCHIVE_BASE_0_PART1_NAME='setup_the_talos_principle_1.0_(64bit)_(41435)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='4b94687328d0017b219e932ce73c44f5'
ARCHIVE_BASE_0_PART2_NAME='setup_the_talos_principle_1.0_(64bit)_(41435)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='4216d66194c80ef8cfbfb5eeff82a54a'
ARCHIVE_BASE_0_SIZE='6900000'
ARCHIVE_BASE_0_VERSION='1.0-gog41435'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
Bin'
CONTENT_GAME_DATA_FILES='
Content'

USER_PERSISTENT_DIRECTORIES='
UserData'
USER_PERSISTENT_FILES='
UserCfg.lua'

APP_MAIN_EXE='Bin/x64/Talos.exe'
## Set a minimal configuration file
APP_MAIN_PRERUN='
# Set a minimal configuration file
CONF_FILE="UserData/Talos.ini"
if [ ! -e "$CONF_FILE" ] ; then
	cat > "$CONF_FILE" <<- EOF
	gfx_strAPI = "Vulkan";
	sfx_strAPI = "XAudio";
	sfx_strAudioDevice = "ID:0";
	EOF
fi
'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Work around broken graphics driver detection code

checkdriver_lua_file='Content/Talos/Config/CheckDriver.lua'
checkdriver_lua_content='-- assume no driver version detection
gfx_iReqDriverVersion = 0;
gfx_bWrongDriver = 0;'
REQUIREMENTS_LIST="${REQUIREMENTS_LIST:-}
dos2unix"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Work around broken graphics driver detection code
	printf '%s' "$checkdriver_lua_content" > "$checkdriver_lua_file"
	unix2dos --quiet "$checkdriver_lua_file"
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build package

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
