#!/bin/bash

echo "Extracting test CamiTK extension JSON files..."

# ---------------------- stdActions ----------------------
# Example taken from distributed source ./sdk/libraries/extensiongenerator/testdata/stdActions.camitk
#
# ⚠ Warning ⚠
# ⚠ Any $var$ / $func(..)$ should be changed to \$var$ and \$func(..)$ ⚠
#
cat <<EOF > stdActions.camitk
{
    "camitk": {
        "extensions": {
            "alwaysRebuild": true,
            "actions": [
                {
                    "classification": {
                        "family": "Extension Generator Test",
                        "tags": [
                            "test",
                            "autogenerated"
                        ]
                    },
                    "componentClass": "MeshComponent",
                    "description": "This description is void.",
                    "gui": "No GUI",
                    "implementationIncludes": "#include <QVector3D>\n#include <QColor>\n#include <QApplication>",
                    "name": "do something on MeshComponent",
                    "parameters": [
                        {
                            "defaultValue": "QVector3D(-1.0, -2.0, -3.0)",
                            "description": "testing QVector3D (a non Qt Core class)",
                            "name": "test of 3D vector",
                            "readOnly": true,
                            "type": "QVector3D",
                            "unit": "mm"
                        },
                        {
                            "defaultValue": "QColor(0, 154, 68)",
                            "description": "testing QColor (a Qt GUI class)",
                            "name": "test of Color",
                            "type": "QColor",
                            "unit": ""
                        }
                    ]
                },
                {
                    "classification": {
                        "family": "Extension Generator Test"
                    },
                    "componentClass": "",
                    "description": "Check compilation of an action with only a QVector3D parameter, but no tags.",
                    "gui": "Custom GUI",
                    "implementationIncludes": "#include <QVector3D>",
                    "name": "test Only one Vec3D",
                    "parameters": [
                        {
                            "defaultValue": "QVector3D(1.0, 2.0, 3.0)",
                            "description": "test 3D vector",
                            "name": "testVector3D",
                            "readOnly": false,
                            "type": "QVector3D",
                            "unit": ""
                        }
                    ]
                },
                {
                    "classification": {
                        "family": "Extension Generator Test",
                        "tags": [
                            "enum"
                        ]
                    },
                    "componentClass": "",
                    "description": "Action with an enum.",
                    "gui": "Default Action GUI",
                    "name": "test enums",
                    "parameters": [
                        {
                            "defaultValue": 0,
                            "description": "A custom enumeration parameter",
                            "enumValues": [
                                "Item 1",
                                "Item 2",
                                "Item 3"
                            ],
                            "name": "my enum",
                            "readOnly": false,
                            "type": "enum",
                            "unit": ""
                        },
                        {
                            "defaultValue": 0,
                            "description": "A custom empty enumeration parameter",
                            "enumValues": [],
                            "name": "my empty enum",
                            "readOnly": false,
                            "type": "enum",
                            "unit": ""
                        }
                    ]
                },
                {
                    "classMembers": "public:\nvoid setIncrement(int increment);\nprivate:\nint increment;\n",
                    "classification": {
                        "family": "Extension Generator Test",
                        "tags": [
                            "Image",
                            "ITK"
                        ]
                    },
                    "componentClass": "ImageComponent",
                    "description": "Example of simple ITK action on image component.",
                    "gui": "Default Action GUI",
                    "implementationIncludes": "#include <QDate>\n#include <QRegularExpression>",
                    "itkFilters": true,
                    "name": "ITK filter example",
                    "parameters": [
                        {
                            "defaultValue": 0,
                            "description": "alpha param",
                            "group": "Numeric Properties",
                            "minimum": 0.0,
                            "name": "alpha",
                            "type": "int",
                            "unit": ""
                        },
                        {
                            "defaultValue": false,
                            "description": "beta param",
                            "name": "beta",
                            "readOnly": true,
                            "type": "bool",
                            "unit": ""
                        },
                        {
                            "defaultValue": 0,
                            "description": "gamma param",
                            "name": "gamma",
                            "readOnly": true,
                            "type": "double",
                            "unit": ""
                        },
                        {
                            "defaultValue": "\"loweronly\"",
                            "description": "A QString constrained to lowercase characters only (no separators, numbers...)",
                            "name": "constrained string",
                            "readOnly": false,
                            "regExp": "[a-z]*",
                            "type": "QString",
                            "unit": ""
                        },
                        {
                            "decimals": 5,
                            "defaultValue": 3.14159,
                            "description": "delta param",
                            "group": "Numeric Properties",
                            "maximum": 3.14159,
                            "minimum": -3.14159,
                            "name": "delta",
                            "singleStep": 0.15708,
                            "type": "double",
                            "unit": "Radians"
                        },
                        {
                            "defaultValue": false,
                            "description": "A boolean parameter",
                            "name": "theta",
                            "type": "bool",
                            "unit": ""
                        }
                    ],
                    "userIncludesInImplementation": "#include <iostream>\n#include <QString>"
                },
                {
                    "classification": {
                        "family": "Extension Generator Test"
                    },
                    "componentClass": "",
                    "description": "Check compilation of an action with no parameters and no tags.",
                    "name": "Action with no parameters",
                    "parameters": [
                    ]
                },
                {                   
                    "description": "Check compilation of an action with no classification no componentClass.",
                    "name": "Action with an empty data model"
                }
            ],
            "contact": {
                "author": "Emmanuel Promayon",
                "email": "Emmanuel.Promayon@univ-grenoble-alpes.fr"
            },
            "description": "This extension has 4 example of actions.",
            "extensionDependencies": "NEEDS_ITK\n",
            "generationType": "Standard",
            "license": "LGPL",
            "name": "Std Actions"
        },
        "timestamp": "2024-05-14T22:46:05",
        "version": "camitk-6.0"
    }
}

EOF

# ---------------------- hotplugActions ----------------------
#
# remove the generationType value → default is hotplug, so no "generationType" means HotPlug
grep -v "generationType" stdActions.camitk > hotplugActions.camitk

# also edit the public and private section in classMembers that cannot be used in hotplug
sed -i -e "s+public:++g" -e "s+private:++g" hotplugActions.camitk

# change extension name
sed -i -e "s+Std Actions+Hotplug Actions+g" hotplugActions.camitk

# ---------------------- pyActions ----------------------
cp stdActions.camitk pyActions.camitk
sed -i -e 's+"generationType": "Standard",+"language": "Python",+g' pyActions.camitk
# change extension name
sed -i -e "s+Std Actions+Python Actions+g" pyActions.camitk

echo "[OK]"