from __future__ import absolute_import, division, print_function
import time
import mmtbx.model
import iotbx.pdb
from mmtbx.hydrogens import reduce_hydrogen
from libtbx.utils import null_out


# ------------------------------------------------------------------------------

def run():
  test_000()

# ------------------------------------------------------------------------------

def test_000():
  '''
  Make sure that mon_lib_query does not crash with a 2-letter residue code
  '''
  pdb_str = pdb_str_000
  pdb_inp = iotbx.pdb.input(lines=pdb_str.split("\n"), source_info=None)
  model = mmtbx.model.manager(model_input = pdb_inp, log = null_out())
  reduce_obj = reduce_hydrogen.place_hydrogens(model = model)
  try:
    reduce_obj.run()
  except Exception as e:
    assert 0

# ------------------------------------------------------------------------------

pdb_str_000 = '''
REMARK Based on PDB model 304d
CRYST1   33.380   25.330   28.110  90.00 120.45  90.00 C 1 2 1       4
ATOM      1  O5'  DI A   1     -10.440   9.856  10.553  1.00 10.10           O
ATOM      2  C5'  DI A   1     -10.065   8.479  10.485  1.00  8.71           C
ATOM      3  C4'  DI A   1      -8.568   8.311  10.801  1.00  8.53           C
ATOM      4  O4'  DI A   1      -8.286   6.940  11.033  1.00  7.73           O
ATOM      5  C3'  DI A   1      -7.663   8.755   9.640  1.00  9.23           C
ATOM      6  O3'  DI A   1      -6.532   9.256  10.342  1.00  9.67           O
ATOM      7  C2'  DI A   1      -7.455   7.423   8.888  1.00  8.19           C
ATOM      8  C1'  DI A   1      -7.347   6.439  10.044  1.00  7.99           C
ATOM      9  N9   DI A   1      -7.746   5.070   9.695  1.00  7.80           N
ATOM     10  C8   DI A   1      -9.027   4.685   9.363  1.00  8.46           C
ATOM     11  N7   DI A   1      -9.188   3.390   9.332  1.00  8.76           N
ATOM     12  C5   DI A   1      -8.019   2.908   9.927  1.00  8.10           C
ATOM     13  C6   DI A   1      -7.581   1.578  10.082  1.00  7.86           C
ATOM     14  O6   DI A   1      -8.216   0.558   9.808  1.00  9.66           O
ATOM     15  N1   DI A   1      -6.297   1.498  10.517  1.00  6.25           N
ATOM     16  C2   DI A   1      -5.476   2.556  10.763  1.00  5.74           C
ATOM     17  N3   DI A   1      -5.886   3.800  10.657  1.00  6.56           N
ATOM     18  C4   DI A   1      -7.136   3.918  10.158  1.00  7.23           C
ATOM     19  P    DC A   2      -5.209   9.909   9.732  1.00 11.56           P
ATOM     20  OP1  DC A   2      -4.319  10.754  10.566  1.00 13.73           O
ATOM     21  OP2  DC A   2      -5.664  10.286   8.361  1.00 12.68           O
ATOM     22  O5'  DC A   2      -4.716   8.421   9.774  1.00 10.62           O
ATOM     23  C5'  DC A   2      -3.806   8.101   8.781  1.00  9.17           C
ATOM     24  C4'  DC A   2      -2.940   6.938   9.222  1.00  8.60           C
ATOM     25  O4'  DC A   2      -3.752   5.725   9.207  1.00  7.96           O
ATOM     26  C3'  DC A   2      -1.951   6.901   8.105  1.00  7.53           C
ATOM     27  O3'  DC A   2      -0.646   6.416   8.411  1.00  8.57           O
ATOM     28  C2'  DC A   2      -2.705   5.997   7.188  1.00  7.82           C
ATOM     29  C1'  DC A   2      -3.319   4.971   8.079  1.00  6.41           C
ATOM     30  N1   DC A   2      -4.399   4.264   7.384  1.00  3.62           N
ATOM     31  C2   DC A   2      -4.446   2.901   7.534  1.00  2.78           C
ATOM     32  O2   DC A   2      -3.489   2.261   7.952  1.00  2.33           O
ATOM     33  N3   DC A   2      -5.569   2.250   7.168  1.00  2.90           N
ATOM     34  C4   DC A   2      -6.604   2.919   6.626  1.00  3.44           C
ATOM     35  N4   DC A   2      -7.696   2.247   6.218  1.00  2.31           N
ATOM     36  C5   DC A   2      -6.562   4.346   6.469  1.00  3.83           C
ATOM     37  C6   DC A   2      -5.400   4.952   6.771  1.00  3.65           C
ATOM     38  P    DA A   3       0.515   7.433   7.969  1.00  8.06           P
ATOM     39  OP1  DA A   3       0.567   8.051   9.298  1.00 10.02           O
ATOM     40  OP2  DA A   3       0.639   8.240   6.758  1.00  8.31           O
ATOM     41  O5'  DA A   3       1.549   6.168   7.917  1.00  7.72           O
ATOM     42  C5'  DA A   3       1.997   5.354   9.002  1.00  8.91           C
ATOM     43  C4'  DA A   3       2.537   4.024   8.529  1.00  9.03           C
ATOM     44  O4'  DA A   3       1.514   3.238   7.914  1.00  8.59           O
ATOM     45  C3'  DA A   3       3.586   4.257   7.446  1.00  9.96           C
ATOM     46  O3'  DA A   3       4.768   3.561   7.904  1.00 10.60           O
ATOM     47  C2'  DA A   3       2.959   3.861   6.102  1.00  9.01           C
ATOM     48  C1'  DA A   3       1.844   2.899   6.550  1.00  9.21           C
ATOM     49  N9   DA A   3       0.641   3.118   5.788  1.00  7.98           N
ATOM     50  C8   DA A   3      -0.011   4.303   5.566  1.00  7.50           C
ATOM     51  N7   DA A   3      -1.211   4.177   5.142  1.00  7.31           N
ATOM     52  C5   DA A   3      -1.388   2.789   5.127  1.00  6.77           C
ATOM     53  C6   DA A   3      -2.450   1.993   4.747  1.00  6.54           C
ATOM     54  N6   DA A   3      -3.555   2.544   4.292  1.00  5.00           N
ATOM     55  N1   DA A   3      -2.341   0.648   4.888  1.00  6.19           N
ATOM     56  C2   DA A   3      -1.172   0.161   5.268  1.00  6.64           C
ATOM     57  N3   DA A   3      -0.042   0.802   5.507  1.00  7.53           N
ATOM     58  C4   DA A   3      -0.261   2.140   5.514  1.00  7.71           C
ATOM     59  P    DT A   4       5.998   3.243   6.999  1.00 11.89           P
ATOM     60  OP1  DT A   4       7.070   2.671   7.855  1.00 10.12           O
ATOM     61  OP2  DT A   4       6.043   4.640   6.453  1.00 11.02           O
ATOM     62  O5'  DT A   4       5.606   2.244   5.828  1.00 11.55           O
ATOM     63  C5'  DT A   4       5.370   0.851   6.036  1.00 11.24           C
ATOM     64  C4'  DT A   4       4.969   0.229   4.711  1.00 10.69           C
ATOM     65  O4'  DT A   4       3.650   0.657   4.297  1.00 11.43           O
ATOM     66  C3'  DT A   4       5.927   0.598   3.583  1.00 10.37           C
ATOM     67  O3'  DT A   4       6.395  -0.579   2.937  1.00  9.38           O
ATOM     68  C2'  DT A   4       5.010   1.377   2.642  1.00 10.23           C
ATOM     69  C1'  DT A   4       3.684   0.732   2.860  1.00 10.71           C
ATOM     70  N1   DT A   4       2.524   1.505   2.392  1.00 10.47           N
ATOM     71  C2   DT A   4       1.344   0.818   2.147  1.00 10.54           C
ATOM     72  O2   DT A   4       1.243  -0.391   1.962  1.00 11.35           O
ATOM     73  N3   DT A   4       0.214   1.582   2.027  1.00 10.38           N
ATOM     74  C4   DT A   4       0.142   2.960   1.947  1.00 10.14           C
ATOM     75  O4   DT A   4      -0.953   3.499   1.785  1.00  9.97           O
ATOM     76  C5   DT A   4       1.424   3.599   2.107  1.00 10.95           C
ATOM     77  C7   DT A   4       1.543   5.113   2.009  1.00 11.51           C
ATOM     78  C6   DT A   4       2.545   2.871   2.330  1.00 10.63           C
ATOM     79  P    DA A   5       7.955  -0.866   2.686  1.00 10.09           P
ATOM     80  OP1  DA A   5       8.472  -0.825   4.061  1.00  9.34           O
ATOM     81  OP2  DA A   5       8.636  -0.011   1.666  1.00  9.60           O
ATOM     82  O5'  DA A   5       8.004  -2.378   2.195  1.00 10.06           O
ATOM     83  C5'  DA A   5       7.426  -3.361   3.039  1.00  9.90           C
ATOM     84  C4'  DA A   5       6.585  -4.308   2.227  1.00 10.23           C
ATOM     85  O4'  DA A   5       5.514  -3.625   1.577  1.00 10.62           O
ATOM     86  C3'  DA A   5       7.350  -5.018   1.144  1.00 10.43           C
ATOM     87  O3'  DA A   5       6.840  -6.366   1.133  1.00 11.09           O
ATOM     88  C2'  DA A   5       7.026  -4.182  -0.096  1.00  9.64           C
ATOM     89  C1'  DA A   5       5.642  -3.628   0.143  1.00  8.45           C
ATOM     90  N9   DA A   5       5.431  -2.243  -0.289  1.00  6.95           N
ATOM     91  C8   DA A   5       6.256  -1.162  -0.149  1.00  5.70           C
ATOM     92  N7   DA A   5       5.699  -0.025  -0.414  1.00  5.27           N
ATOM     93  C5   DA A   5       4.381  -0.353  -0.699  1.00  5.49           C
ATOM     94  C6   DA A   5       3.268   0.437  -0.979  1.00  5.87           C
ATOM     95  N6   DA A   5       3.346   1.754  -1.037  1.00  6.33           N
ATOM     96  N1   DA A   5       2.082  -0.185  -1.104  1.00  6.82           N
ATOM     97  C2   DA A   5       2.049  -1.519  -1.012  1.00  6.71           C
ATOM     98  N3   DA A   5       3.047  -2.363  -0.767  1.00  6.01           N
ATOM     99  C4   DA A   5       4.177  -1.688  -0.525  1.00  6.20           C
ATOM    100  P    DT A   6       7.356  -7.409   0.005  1.00 12.69           P
ATOM    101  OP1  DT A   6       7.148  -8.698   0.734  1.00 12.66           O
ATOM    102  OP2  DT A   6       8.698  -6.930  -0.354  1.00  9.43           O
ATOM    103  O5'  DT A   6       6.430  -7.281  -1.265  1.00 10.15           O
ATOM    104  C5'  DT A   6       5.095  -7.676  -1.250  1.00 10.44           C
ATOM    105  C4'  DT A   6       4.415  -7.021  -2.405  1.00  8.98           C
ATOM    106  O4'  DT A   6       4.485  -5.597  -2.313  1.00  8.37           O
ATOM    107  C3'  DT A   6       5.094  -7.440  -3.700  1.00  9.04           C
ATOM    108  O3'  DT A   6       4.181  -8.411  -4.216  1.00  9.58           O
ATOM    109  C2'  DT A   6       5.196  -6.133  -4.464  1.00  7.64           C
ATOM    110  C1'  DT A   6       4.357  -5.168  -3.653  1.00  7.45           C
ATOM    111  N1   DT A   6       4.751  -3.769  -3.772  1.00  6.43           N
ATOM    112  C2   DT A   6       3.781  -2.873  -4.170  1.00  5.47           C
ATOM    113  O2   DT A   6       2.691  -3.208  -4.576  1.00  4.21           O
ATOM    114  N3   DT A   6       4.110  -1.529  -4.126  1.00  4.91           N
ATOM    115  C4   DT A   6       5.375  -1.023  -3.805  1.00  4.70           C
ATOM    116  O4   DT A   6       5.578   0.195  -3.840  1.00  4.02           O
ATOM    117  C5   DT A   6       6.337  -2.053  -3.455  1.00  5.11           C
ATOM    118  C7   DT A   6       7.758  -1.696  -3.100  1.00  2.99           C
ATOM    119  C6   DT A   6       5.991  -3.361  -3.438  1.00  5.34           C
ATOM    120  P    DI A   7       4.440  -9.073  -5.606  1.00 11.13           P
ATOM    121  OP1  DI A   7       3.775 -10.368  -5.351  1.00 10.57           O
ATOM    122  OP2  DI A   7       5.868  -9.000  -5.970  1.00 12.00           O
ATOM    123  O5'  DI A   7       3.683  -8.331  -6.786  1.00  9.51           O
ATOM    124  C5'  DI A   7       2.241  -8.141  -6.780  1.00  9.01           C
ATOM    125  C4'  DI A   7       1.863  -6.886  -7.570  1.00  7.81           C
ATOM    126  O4'  DI A   7       2.687  -5.815  -7.057  1.00  7.34           O
ATOM    127  C3'  DI A   7       2.291  -7.036  -8.977  1.00  7.93           C
ATOM    128  O3'  DI A   7       1.181  -7.173  -9.890  1.00  8.81           O
ATOM    129  C2'  DI A   7       3.175  -5.804  -9.214  1.00  7.39           C
ATOM    130  C1'  DI A   7       3.022  -4.854  -8.048  1.00  5.99           C
ATOM    131  N9   DI A   7       4.283  -4.109  -7.674  1.00  3.60           N
ATOM    132  C8   DI A   7       5.565  -4.599  -7.483  1.00  3.24           C
ATOM    133  N7   DI A   7       6.438  -3.679  -7.172  1.00  2.61           N
ATOM    134  C5   DI A   7       5.727  -2.486  -7.195  1.00  2.72           C
ATOM    135  C6   DI A   7       6.168  -1.145  -7.024  1.00  2.43           C
ATOM    136  O6   DI A   7       7.281  -0.749  -6.660  1.00  4.03           O
ATOM    137  N1   DI A   7       5.168  -0.240  -7.271  1.00  2.03           N
ATOM    138  C2   DI A   7       3.929  -0.556  -7.734  1.00  2.00           C
ATOM    139  N3   DI A   7       3.489  -1.797  -7.815  1.00  2.36           N
ATOM    140  C4   DI A   7       4.422  -2.728  -7.554  1.00  2.60           C
ATOM    141  P    DC A   8       1.353  -7.338 -11.568  1.00  9.22           P
ATOM    142  OP1  DC A   8       0.433  -8.366 -11.052  1.00 10.61           O
ATOM    143  OP2  DC A   8       2.819  -7.493 -11.599  1.00 10.13           O
ATOM    144  O5'  DC A   8       0.823  -5.843 -11.301  1.00  9.41           O
ATOM    145  C5'  DC A   8       0.506  -5.141 -12.485  1.00  9.16           C
ATOM    146  C4'  DC A   8       0.541  -3.656 -12.375  1.00  7.90           C
ATOM    147  O4'  DC A   8       1.682  -3.273 -11.579  1.00  7.05           O
ATOM    148  C3'  DC A   8       0.703  -3.066 -13.790  1.00  6.96           C
ATOM    149  O3'  DC A   8      -0.171  -1.907 -13.814  1.00  6.77           O
ATOM    150  C2'  DC A   8       2.244  -2.780 -13.764  1.00  7.01           C
ATOM    151  C1'  DC A   8       2.450  -2.363 -12.313  1.00  6.05           C
ATOM    152  N1   DC A   8       3.788  -2.381 -11.743  1.00  5.08           N
ATOM    153  C2   DC A   8       4.332  -1.159 -11.357  1.00  5.34           C
ATOM    154  O2   DC A   8       3.702  -0.096 -11.473  1.00  5.98           O
ATOM    155  N3   DC A   8       5.570  -1.166 -10.781  1.00  4.76           N
ATOM    156  C4   DC A   8       6.253  -2.317 -10.626  1.00  4.35           C
ATOM    157  N4   DC A   8       7.509  -2.272 -10.195  1.00  5.50           N
ATOM    158  C5   DC A   8       5.684  -3.579 -10.972  1.00  4.82           C
ATOM    159  C6   DC A   8       4.476  -3.563 -11.588  1.00  5.17           C
TER     160       DC A   8
HETATM  161  C1  DMY A   9      -2.781  -2.017  -5.559  1.00  5.25           C
HETATM  162  O1  DMY A   9      -3.588  -2.653  -6.232  1.00  3.99           O
HETATM  163  N1  DMY A   9      -2.322  -2.312  -4.337  1.00  5.16           N
HETATM  164  C2  DMY A   9      -2.668  -3.433  -3.696  1.00  5.74           C
HETATM  165  C3  DMY A   9      -2.301  -3.765  -2.404  1.00  5.56           C
HETATM  166  C4  DMY A   9      -2.650  -5.063  -2.161  1.00  5.22           C
HETATM  167  N2  DMY A   9      -3.229  -5.586  -3.272  1.00  6.58           N
HETATM  168  C5  DMY A   9      -3.235  -4.644  -4.222  1.00  6.28           C
HETATM  169  C6  DMY A   9      -4.062  -6.870  -3.403  1.00  7.25           C
HETATM  170  C7  DMY A   9      -2.311  -5.839  -1.033  1.00  5.26           C
HETATM  171  O2  DMY A   9      -2.307  -7.069  -1.138  1.00  5.55           O
HETATM  172  N3  DMY A   9      -2.029  -5.119   0.088  1.00  3.95           N
HETATM  173  C8  DMY A   9      -1.451  -5.716   1.160  1.00  4.72           C
HETATM  174  C9  DMY A   9      -1.127  -5.120   2.362  1.00  4.42           C
HETATM  175  C10 DMY A   9      -0.575  -6.082   3.199  1.00  5.70           C
HETATM  176  N4  DMY A   9      -0.511  -7.252   2.546  1.00  5.38           N
HETATM  177  C11 DMY A   9      -1.016  -7.073   1.330  1.00  4.71           C
HETATM  178  C12 DMY A   9      -0.160  -8.637   3.046  1.00  5.60           C
HETATM  179  C13 DMY A   9      -0.046  -5.909   4.504  1.00  6.46           C
HETATM  180  O3  DMY A   9       0.713  -6.751   5.018  1.00  8.29           O
HETATM  181  N5  DMY A   9      -0.450  -4.740   5.059  1.00  5.86           N
HETATM  182  C14 DMY A   9       0.057  -4.265   6.215  1.00  6.36           C
HETATM  183  C15 DMY A   9      -0.295  -3.085   6.847  1.00  6.53           C
HETATM  184  C16 DMY A   9       0.417  -2.971   8.021  1.00  6.10           C
HETATM  185  N6  DMY A   9       1.250  -4.029   8.113  1.00  6.49           N
HETATM  186  C17 DMY A   9       1.038  -4.833   7.075  1.00  6.17           C
HETATM  187  C18 DMY A   9       2.500  -4.216   9.003  1.00  6.25           C
HETATM  188  C19 DMY A   9       0.348  -1.935   8.997  1.00  5.94           C
HETATM  189  O4  DMY A   9       1.244  -1.695   9.825  1.00  7.35           O
HETATM  190  N7  DMY A   9      -0.804  -1.249   9.004  1.00  4.49           N
HETATM  191  C20 DMY A   9      -0.941  -0.100   9.896  1.00  3.44           C
HETATM  192  C21 DMY A   9      -0.155   1.108   9.432  1.00  2.78           C
HETATM  193  C22 DMY A   9      -0.428   2.408  10.162  1.00  2.34           C
HETATM  194  N8  DMY A   9       0.491   2.814  10.999  1.00  2.00           N
HETATM  195  N9  DMY A   9      -1.523   3.128   9.979  1.00  2.88           N
'''

if (__name__ == "__main__"):
  t0 = time.time()
  run()
  print("OK. Time: %8.3f"%(time.time()-t0))
