/*
 * Goodvibes Radio Player
 *
 * Copyright (C) 2020-2024 Arnaud Rebillout
 *
 * SPDX-License-Identifier: GPL-3.0-only
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

#pragma once

/*
 * FIP <https://www.radiofrance.fr/fip>
 * (generated by scripts/print-fip-stations.sh)
 */

#define DEFAULT_STATIONS_FIP \
	"<Station>" \
	"  <name>FIP</name>" \
	"  <uri>https://stream.radiofrance.fr/fip/fip.m3u8</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>FIP Electro</name>" \
	"  <uri>https://stream.radiofrance.fr/fipelectro/fipelectro.m3u8</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>FIP Groove</name>" \
	"  <uri>https://stream.radiofrance.fr/fipgroove/fipgroove.m3u8</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>FIP Hip-Hop</name>" \
	"  <uri>https://stream.radiofrance.fr/fiphiphop/fiphiphop.m3u8</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>FIP Jazz</name>" \
	"  <uri>https://stream.radiofrance.fr/fipjazz/fipjazz.m3u8</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>FIP Metal</name>" \
	"  <uri>https://stream.radiofrance.fr/fipmetal/fipmetal.m3u8</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>FIP Monde</name>" \
	"  <uri>https://stream.radiofrance.fr/fipworld/fipworld.m3u8</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>FIP Nouveautés</name>" \
	"  <uri>https://stream.radiofrance.fr/fipnouveautes/fipnouveautes.m3u8</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>FIP Pop</name>" \
	"  <uri>https://stream.radiofrance.fr/fippop/fippop.m3u8</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>FIP Reggae</name>" \
	"  <uri>https://stream.radiofrance.fr/fipreggae/fipreggae.m3u8</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>FIP Rock</name>" \
	"  <uri>https://stream.radiofrance.fr/fiprock/fiprock.m3u8</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>FIP Sacré français !</name>" \
	"  <uri>https://stream.radiofrance.fr/fipsacrefrancais/fipsacrefrancais.m3u8</uri>" \
	"</Station>"

/*
 * Radio Nova <https://www.nova.fr/>
 * (generated by scripts/print-nova-stations.sh)
 */

#define DEFAULT_STATIONS_NOVA_WITH_ADS \
	"<Station>" \
	"  <name>Nova</name>" \
	"  <uri>https://novazz.ice.infomaniak.ch/novazz-128.mp3</uri>" \
	"</Station>"

#define DEFAULT_STATIONS_NOVA_NO_ADS \
	"<Station>" \
	"  <name>Nova Classics</name>" \
	"  <uri>https://nova-vnt.ice.infomaniak.ch/nova-vnt-128.mp3</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>Nova Danse</name>" \
	"  <uri>https://nova-dance.ice.infomaniak.ch/nova-dance-128.mp3</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>Nova Hip-Hop</name>" \
	"  <uri>https://nova-odn.ice.infomaniak.ch/nova-odn-128.mp3</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>Nova la Nuit</name>" \
	"  <uri>https://nova-ln.ice.infomaniak.ch/nova-ln-128.mp3</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>Nova la Plage</name>" \
	"  <uri>https://nova-sm.ice.infomaniak.ch/nova-sm-128.mp3</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>Nova Nouvo</name>" \
	"  <uri>https://nova-nouvo.ice.infomaniak.ch/nova-nouvo-128.mp3</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>Nova Reggae</name>" \
	"  <uri>https://nova-reggae.ice.infomaniak.ch/nova-reggae-128.mp3</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>Nova Soul</name>" \
	"  <uri>https://nova-soul.ice.infomaniak.ch/nova-soul-128.mp3</uri>" \
	"</Station>"

#define DEFAULT_STATIONS_NOVA DEFAULT_STATIONS_NOVA_NO_ADS

/*
 * Misc
 * - Pedro Broadcasting Basement <https://www.laurentgarnier.com/radio.html>
 * - Radio Grenouille <http://www.radiogrenouille.com/>
 * - Radio Meuh <https://www.radiomeuh.com/>
 * - Rock Attack <https://www.rockattack.fr/>
 */

#define DEFAULT_STATIONS_MISC_NO_ADS \
	"<Station>" \
	"  <name>Pedro Broadcasting Basement</name>" \
	"  <uri>https://pbbradio.com:8443/pbb128</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>Radio Meuh</name>" \
	"  <uri>https://radiomeuh2.ice.infomaniak.ch/radiomeuh2-128.mp3</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>Rock Attack</name>" \
	"  <uri>https://listen.radioking.com/radio/176026/stream/218008</uri>" \
	"</Station>"

#define DEFAULT_STATIONS_MISC_WITH_ADS \
	"<Station>" \
        "  <name>Radio Grenouille</name>" \
        "  <uri>http://live.radiogrenouille.com/live</uri>" \
        "</Station>"

#define DEFAULT_STATIONS_MISC DEFAULT_STATIONS_MISC_NO_ADS

/*
 * SomaFM <https://somafm.com>
 * (generated by scripts/print-somafm-stations.sh)
 */

#define DEFAULT_STATIONS_SOMAFM \
	"<Station>" \
	"  <name>SomaFM Beat Blender</name>" \
	"  <uri>https://somafm.com/beatblender130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Black Rock FM</name>" \
	"  <uri>https://somafm.com/brfm130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Boot Liquor</name>" \
	"  <uri>https://somafm.com/bootliquor130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Bossa Beyond</name>" \
	"  <uri>https://somafm.com/bossa130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Chillits Radio</name>" \
	"  <uri>https://somafm.com/chillits130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Christmas Lounge</name>" \
	"  <uri>https://somafm.com/christmas130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Christmas Rocks!</name>" \
	"  <uri>https://somafm.com/xmasrocks130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM cliqhop idm</name>" \
	"  <uri>https://somafm.com/cliqhop130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Covers</name>" \
	"  <uri>https://somafm.com/covers130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Deep Space One</name>" \
	"  <uri>https://somafm.com/deepspaceone130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM DEF CON Radio</name>" \
	"  <uri>https://somafm.com/defcon130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Department Store Christmas</name>" \
	"  <uri>https://somafm.com/deptstore130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Digitalis</name>" \
	"  <uri>https://somafm.com/digitalis130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Doomed</name>" \
	"  <uri>https://somafm.com/doomed130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Drone Zone</name>" \
	"  <uri>https://somafm.com/dronezone130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Dub Step Beyond</name>" \
	"  <uri>https://somafm.com/dubstep130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Fluid</name>" \
	"  <uri>https://somafm.com/fluid130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Folk Forward</name>" \
	"  <uri>https://somafm.com/folkfwd130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Groove Salad</name>" \
	"  <uri>https://somafm.com/groovesalad130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Groove Salad Classic</name>" \
	"  <uri>https://somafm.com/gsclassic130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Heavyweight Reggae</name>" \
	"  <uri>https://somafm.com/reggae130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Illinois Street Lounge</name>" \
	"  <uri>https://somafm.com/illstreet130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Indie Pop Rocks!</name>" \
	"  <uri>https://somafm.com/indiepop130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Jolly Ol&#39; Soul</name>" \
	"  <uri>https://somafm.com/jollysoul130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Left Coast 70s</name>" \
	"  <uri>https://somafm.com/seventies130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Live</name>" \
	"  <uri>https://somafm.com/live130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Lush</name>" \
	"  <uri>https://somafm.com/lush130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Metal Detector</name>" \
	"  <uri>https://somafm.com/metal130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Mission Control</name>" \
	"  <uri>https://somafm.com/missioncontrol130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM n5MD Radio</name>" \
	"  <uri>https://somafm.com/n5md130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM PopTron</name>" \
	"  <uri>https://somafm.com/poptron130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Secret Agent</name>" \
	"  <uri>https://somafm.com/secretagent130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Seven Inch Soul</name>" \
	"  <uri>https://somafm.com/7soul130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM SF 10-33</name>" \
	"  <uri>https://somafm.com/sf1033130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM SF in SF</name>" \
	"  <uri>https://somafm.com/sfinsf130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM SF Police Scanner</name>" \
	"  <uri>https://somafm.com/scanner130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Sonic Universe</name>" \
	"  <uri>https://somafm.com/sonicuniverse130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Space Station Soma</name>" \
	"  <uri>https://somafm.com/spacestation130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Specials</name>" \
	"  <uri>https://somafm.com/specials130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Suburbs of Goa</name>" \
	"  <uri>https://somafm.com/suburbsofgoa130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Synphaera Radio</name>" \
	"  <uri>https://somafm.com/synphaera130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM The Dark Zone</name>" \
	"  <uri>https://somafm.com/darkzone130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM The In-Sound</name>" \
	"  <uri>https://somafm.com/insound130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM The Trip</name>" \
	"  <uri>https://somafm.com/thetrip130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM ThistleRadio</name>" \
	"  <uri>https://somafm.com/thistle130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Tiki Time</name>" \
	"  <uri>https://somafm.com/tikitime130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Underground 80s</name>" \
	"  <uri>https://somafm.com/u80s130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Vaporwaves</name>" \
	"  <uri>https://somafm.com/vaporwaves130.pls</uri>" \
	"</Station>" \
	"<Station>" \
	"  <name>SomaFM Xmas in Frisko</name>" \
	"  <uri>https://somafm.com/xmasinfrisko130.pls</uri>" \
	"</Station>"

/*
 * Default stations
 */

#define DEFAULT_STATIONS \
        "<Stations>" \
        DEFAULT_STATIONS_FIP \
	DEFAULT_STATIONS_NOVA \
        DEFAULT_STATIONS_MISC \
	DEFAULT_STATIONS_SOMAFM \
        "</Stations>"
