/*
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * Copyright © 2021 Keith Packard
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _PICO_ONEXIT_H_
#define _PICO_ONEXIT_H_

#include <stdlib.h>

#if !defined(__USE_SYSTEM_LIBC) || !defined(__ENABLE_PROFILING)

#define ENABLE_PICOLIBC_EXIT

enum pico_onexit_kind {
    PICO_ONEXIT_EMPTY,
    PICO_ONEXIT_ONEXIT,
    PICO_ONEXIT_ATEXIT,
    PICO_ONEXIT_CXA_ATEXIT
};

union on_exit_func {
    void (*on_exit)(int, void *);
    void (*atexit)(void);
    void (*cxa_atexit)(void *);
};

int  _on_exit(enum pico_onexit_kind kind, union on_exit_func func, void *arg);

int  __cxa_atexit(void (*func)(void *), void *arg, void *d);

void __libc_fini_array(void);

#ifndef __INIT_FINI_ARRAY
void __call_exitprocs(int code, void *param) __weak;
#endif

#endif

#endif /* _PICO_ONEXIT_H_ */
