# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security.aio import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterSecurityConnectorsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_security_connectors_list(self, resource_group):
        response = self.client.security_connectors.list(
            api_version="2024-08-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_security_connectors_list_by_resource_group(self, resource_group):
        response = self.client.security_connectors.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-08-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_security_connectors_get(self, resource_group):
        response = await self.client.security_connectors.get(
            resource_group_name=resource_group.name,
            security_connector_name="str",
            api_version="2024-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_security_connectors_create_or_update(self, resource_group):
        response = await self.client.security_connectors.create_or_update(
            resource_group_name=resource_group.name,
            security_connector_name="str",
            security_connector={
                "environmentData": "environment_data",
                "environmentName": "str",
                "etag": "str",
                "hierarchyIdentifier": "str",
                "hierarchyIdentifierTrialEndDate": "2020-02-20 00:00:00",
                "id": "str",
                "kind": "str",
                "location": "str",
                "name": "str",
                "offerings": ["cloud_offering"],
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_security_connectors_update(self, resource_group):
        response = await self.client.security_connectors.update(
            resource_group_name=resource_group.name,
            security_connector_name="str",
            security_connector={
                "environmentData": "environment_data",
                "environmentName": "str",
                "etag": "str",
                "hierarchyIdentifier": "str",
                "hierarchyIdentifierTrialEndDate": "2020-02-20 00:00:00",
                "id": "str",
                "kind": "str",
                "location": "str",
                "name": "str",
                "offerings": ["cloud_offering"],
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_security_connectors_delete(self, resource_group):
        response = await self.client.security_connectors.delete(
            resource_group_name=resource_group.name,
            security_connector_name="str",
            api_version="2024-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...
