# generated by datamodel-codegen:
#   filename:  api_constrained.yaml
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from typing import Annotated, List, Union

from msgspec import UNSET, Meta, Struct, UnsetType
from typing_extensions import TypeAlias


class Pet(Struct):
    id: Annotated[int, Meta(ge=0, le=9223372036854775807)]
    name: Annotated[str, Meta(max_length=256)]
    tag: Union[Annotated[str, Meta(max_length=64)], UnsetType] = UNSET


Pets: TypeAlias = List[Pet]


UID: TypeAlias = Annotated[int, Meta(ge=0)]


Phone: TypeAlias = Annotated[str, Meta(min_length=3)]


FaxItem: TypeAlias = Annotated[str, Meta(min_length=3)]


class User(Struct):
    id: Annotated[int, Meta(ge=0)]
    name: Annotated[str, Meta(max_length=256)]
    uid: UID
    tag: Union[Annotated[str, Meta(max_length=64)], UnsetType] = UNSET
    phones: Union[List[Phone], UnsetType] = UNSET
    fax: Union[List[FaxItem], UnsetType] = UNSET
    height: Union[Annotated[Union[int, float], Meta(ge=1.0, le=300.0)], UnsetType] = (
        UNSET
    )
    weight: Union[Annotated[Union[float, int], Meta(ge=1.0, le=1000.0)], UnsetType] = (
        UNSET
    )
    age: Union[Annotated[int, Meta(gt=0, le=200)], UnsetType] = UNSET
    rating: Union[Annotated[float, Meta(gt=0.0, le=5.0)], UnsetType] = UNSET


Users: TypeAlias = List[User]


Id: TypeAlias = str


Rules: TypeAlias = List[str]


class Error(Struct):
    code: int
    message: str


class Api(Struct):
    apiKey: Union[
        Annotated[str, Meta(description='To be used as a dataset parameter value')],
        UnsetType,
    ] = UNSET
    apiVersionNumber: Union[
        Annotated[str, Meta(description='To be used as a version parameter value')],
        UnsetType,
    ] = UNSET
    apiUrl: Union[
        Annotated[
            str,
            Meta(description="The URL describing the dataset's fields", min_length=1),
        ],
        UnsetType,
    ] = UNSET
    apiDocumentationUrl: Union[
        Annotated[str, Meta(description='A URL to the API console for each API')],
        UnsetType,
    ] = UNSET


Apis: TypeAlias = List[Api]


class Event(Struct):
    name: Union[str, UnsetType] = UNSET


class Result(Struct):
    event: Union[Event, UnsetType] = UNSET
