//
// Copyright 2024 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package internal

import (
	"testing"
)

func FuzzParseAccessTokenSuccess(f *testing.F) {
	f.Fuzz(func(_ *testing.T, body []byte, formUrlEncoded bool) {
		var contentType string
		if formUrlEncoded {
			contentType = "application/x-www-form-urlencoded"
		} else {
			contentType = ""
		}
		parseAccessTokenSuccess(body, contentType)
	})
}
