Special comments in the Jedi Code Formatter
===========================================

The code formatter now recognizes certain comments to disable and enable formatting options around blocks of code.

Since the earliest versions, the comments `{(*}` and `{*)}` could be used to disable and reenable formatting respectively, in order to exclude a block of code from formatting.

From version 0.52, a more extensive syntax has been implemented to allow for fine-grained control over which formatting options are temporarily disabled. The original special comments `{(*}` and `{*)}` are retained as synonymns for `//jcf:format=off` and `//jcf:format=on` respectively.

For instance, in the following line of code, the formatter will not alter the spacing

```
//jcf:space=off
 a  :=   a   +   1  ;
//jcf:space=on
```

As you can see, the new syntax has the form of a comment like `//jcf:**flag**=**state**`, where **state** is one of `on` or `off`, and the flags are listed below.

Flags
-----

| **Flag** | **Description** |
| --- | --- |
| `parse` | Stop parsing tokens (to avoid errors on unsupported code)- to turn it on again need jcf:parse=on (since lazarus 3.99)|
| `all` | all=on is used to reverse the effects of all `off` comments (except parse), as described below. `all=off` is not valid |
| `format` | All formatting (except parse)|
| `space` | All processes that insert or remove spaces |
| `addspace` | All processes that insert spaces |
| `removespace` | All processes that remove spaces |
| `return` | All processes that insert or remove returns |
| `addreturn` | All processes that insert returns |
| `removereturn` | All processes that remove returns |
| `add` | All processes that insert spaces or returns |
| `remove` | All processes that remove spaces or returns |
| `align` | All processes that align statements - i.e. alignment of variables, constants, types and assignment statements |
| `aligndef` | Alignment of variables, constants and types |
| `alignfn` | Alignment of variables and assignments |
| `alignvars` | Alignment of variables |
| `alignconst` | Alignment of constants |
| `aligntypedef` | Alignment of types |
| `alignassign` | Alignment of assignment |
| `indent` | Correct block indent of statements and declarations |
| `caps` | Capitalisation of reserved words or user-specified words |
| `capsreservedwords` | Capitalisation of reserved words |
| `capsspecificwords` | Capitalisation of user-specified words |
| `linebreaking` | Breaking of long lines |
| `blockstyle` | Line-breaking in blocks of statements |
| `warnings` | Warnings generated by the code fornatter |
| `warnassigntofunctionname` | Warning asign to function name (since lazarus 3.99)|
| `warncasenoelse` | Warning case has no else  (since lazarus 3.99)|
| `warnemptyblock` | Warning empty block (since lazarus 3.99)|
| `warnunusedparam` | Warning unused param (since lazarus 3.99)|
| `findreplace` | Find and replace |
| `findreplaceuses` | Maniupulation of the uses clause |

The following rules apply:

* Turning a flag on will not enable it if it is not enabled in the configuration - the flags are to 'block out' a section of code where a format option is not wanted. The on state is there only to end a previous off state.
* All processes (except parse) turned off by a flag comment remain turned off until the corresponding flag comment that turns it back on is reached, or the end of the file is reached, or the flag comment `//jcf:all=on` is reached.
* The flag comment `//jcf:all=on` will reenable all processes that have been turned off by comments, ie it returns formatting to the options specified in the configuration (except parse).
* Flag comments only affect the file in which they occur, from the position in which the occur onwards.
* The effects of some of the flags overlap - this is done to allow degrees of granularity e.g. turn off all alignment, or just alignment of variable declarations for a block of code.
* In these special comments, character case and some spaces are ignored.
* A comment that starts with `//jcf:` but cannot be recognised as one of the options given will cause a warning in the log but will have no effect of the file's format.

For examples see the test case unit TestExclusionFlags.pas, for implmentation see the unit FormatFlags.pas

* * *

