// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from TacPlusServerSettings.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.tacplus {

  public class ServerSettings : ICloneable {
    public object Clone() {
      ServerSettings copy = new ServerSettings();
      copy.server = this.server;
      copy.port = this.port;
      copy.timeoutSeconds = this.timeoutSeconds;
      copy.retries = this.retries;
      copy.sharedSecret = this.sharedSecret;
      copy.authenType = this.authenType;
      copy.disableAccounting = this.disableAccounting;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["server"] = this.server;
      json["port"] = this.port;
      json["timeoutSeconds"] = this.timeoutSeconds;
      json["retries"] = this.retries;
      json["sharedSecret"] = this.sharedSecret;
      json["authenType"] = (int)this.authenType;
      json["disableAccounting"] = this.disableAccounting;
      return json;
    }

    public static ServerSettings Decode(LightJson.JsonObject json, Agent agent) {
      ServerSettings inst = new ServerSettings();
      inst.server = (string)json["server"];
      inst.port = (int)json["port"];
      inst.timeoutSeconds = (int)json["timeoutSeconds"];
      inst.retries = (int)json["retries"];
      inst.sharedSecret = (string)json["sharedSecret"];
      inst.authenType = (Com.Raritan.Idl.tacplus.AuthenType)(int)json["authenType"];
      inst.disableAccounting = (bool)json["disableAccounting"];
      return inst;
    }

    public string server = "";
    public int port = 0;
    public int timeoutSeconds = 0;
    public int retries = 0;
    public string sharedSecret = "";
    public Com.Raritan.Idl.tacplus.AuthenType authenType = Com.Raritan.Idl.tacplus.AuthenType.ASCII;
    public bool disableAccounting = false;
  }
}
