#pragma once
#include "Core/Exception.h"

namespace graphics {

	/**
	 * Load error.
	 */
	class EXCEPTION_EXPORT ImageLoadError : public storm::Exception {
		STORM_EXCEPTION;
	public:
		ImageLoadError(const wchar *msg) {
			this->msg = new (this) Str(msg);
		}
		STORM_CTOR ImageLoadError(Str *msg) {
			this->msg = msg;
		}
		virtual void STORM_FN message(StrBuf *to) const {
			*to << msg;
		}
	private:
		Str *msg;
	};


	/**
	 * Save error.
	 */
	class EXCEPTION_EXPORT ImageSaveError : public storm::Exception {
		STORM_EXCEPTION;
	public:
		ImageSaveError(const wchar *msg) {
			this->msg = new (this) Str(msg);
		}
		STORM_CTOR ImageSaveError(Str *msg) {
			this->msg = msg;
		}
		virtual void STORM_FN message(StrBuf *to) const {
			*to << msg;
		}
	private:
		Str *msg;
	};

}
