#ifndef __DYNAREC_LA64_CONSTS__
#define __DYNAREC_LA64_CONSTS__
#include <stdint.h>

typedef enum la64_consts_s {
    const_none,
    const_daa8,
    const_das8,
    const_aaa16,
    const_aas16,
    const_aam16,
    const_aad16,
    const_native_br,
    const_native_ud,
    const_native_priv,
    const_native_int3,
    const_native_int,
    const_native_div0,
    const_native_clflush,
    const_native_fprem,
    const_native_fprem1,
    const_native_frstor16,
    const_native_fsave16,
    const_native_fsave,
    const_native_aesimc,
    const_native_aesd,
    const_native_aesd_y,
    const_native_aesdlast,
    const_native_aesdlast_y,
    const_native_aese,
    const_native_aese_y,
    const_native_aeselast,
    const_native_aeselast_y,
    const_native_aeskeygenassist,
    const_native_pclmul,
    const_native_pclmul_x,
    const_native_pclmul_y,
    const_native_f2xm1,
    const_native_fyl2x,
    const_native_fyl2xp1,
    const_native_fxtract,
    const_native_ftan,
    const_native_fpatan,
    const_native_fcos,
    const_native_fsin,
    const_native_fsincos,
    const_native_fscale,
    const_native_fld,
    const_native_fstp,
    const_native_frstor,
    const_native_next,
    const_int3,
    const_x86syscall,
    const_x64syscall,
    const_rcl8,
    const_rcl16,
    const_rcl32,
    const_rcl64,
    const_rcr8,
    const_rcr16,
    const_rcr32,
    const_rcr64,
    const_rol8,
    const_rol16,
    const_ror8,
    const_ror16,
    const_div64,
    const_div8,
    const_idiv64,
    const_idiv8,
    const_random32,
    const_random64,
    const_readtsc,
    const_helper_getcpu,
    const_cpuid,
    const_getsegmentbase,
    const_updateflags,
    const_reset_fpu,
    const_sha1nexte,
    const_sha1msg1,
    const_sha1msg2,
    const_sha1rnds4,
    const_sha256msg1,
    const_sha256msg2,
    const_sha256rnds2,
    const_fpu_loadenv,
    const_fpu_savenv,
    const_fpu_fxsave32,
    const_fpu_fxsave64,
    const_fpu_fxrstor32,
    const_fpu_fxrstor64,
    const_fpu_xsave,
    const_fpu_xrstor,
    const_fpu_fbld,
    const_fpu_fbst,
    const_sse42_compare_string_explicit_len,
    const_sse42_compare_string_implicit_len,
    const_x64test_step,
    const_printtrace,
    const_epilog,
    const_epilog_fast,
    const_jmptbl32,
    const_jmptbl48,
    const_jmptbl64,
    const_context,

    const_last
} la64_consts_t;

uintptr_t getConst(la64_consts_t which);

// temporary define...
#define const_PrintTrace const_printtrace

#endif //__DYNAREC_LA64_CONSTS__