#! /usr/bin/env python3
# -*- coding: utf-8 -*-

#	Copyright 2013, Marten de Vries
#
#	This file is part of Code of Conduct Signing Assistant.
#
#	Code of Conduct Signing Assistant is free software: you can
#	redistribute it and/or modify it under the terms of the GNU General
#	Public License as published by the Free Software Foundation, either
#	version 3 of the License, or (at your option) any later version.
#
#	Code of Conduct Signing Assistant is distributed in the hope that it
#	will be useful, but WITHOUT ANY WARRANTY; without even the implied
#	warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#	See the GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with Code of Conduct Signing Assistant. If not, see
#	<http://www.gnu.org/licenses/>.

import subprocess
import os

subprocess.check_call([
	"xgettext",
	"--output=code-of-conduct-signing-assistant.pot",
	"--default-domain=code-of-conduct-signing-assistant",
	"--language=Python",
	"--output-dir=po",
	"--add-comments=TRANSLATORS",
	"--force-po",

	"codeOfConductSigningAssistant/codeOfConductSigningAssistant.py",
])

for file in os.listdir("po"):
	if file.endswith(".po"):
		inPath = os.path.join("po", file)
		lang = file[:-3]
		outPath = "translations/" + lang + "/LC_MESSAGES/code-of-conduct-signing-assistant.mo"
		try:
			os.makedirs(os.path.dirname(outPath))
		except OSError:
			"""The directory exists already, probably."""
		subprocess.check_call(["msgmerge", "-o", inPath, inPath, "po/code-of-conduct-signing-assistant.pot"])
		subprocess.check_call(["msgfmt", "-o", outPath, inPath])
