/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file filter.h
 * \brief Contains filter related structure and typedefs
 */

#ifndef FILTER_H
#define FILTER_H

enum {
	COL_FILTER_TYPE,
	COL_FILTER_COUNT,
	COL_FILTER_DURATION
};

struct sFilterInfo {
	gint nCount;
	gint nDuration;
};

struct sFilterOptions {
	gint nType;
	gint nSubType;
	gchar *pnEntry;
};

struct sFilter {
	gchar *pnName;
	GList *psOptions;
};

gint checkFilter( struct sCaller *psCaller, struct sFilter *psFilter );
struct sFilter *findFilter( const gchar *pnName );
void updateFilter( GtkListStore *psStore, GtkWidget *psSelectionTreeView );
void filterAdd( GtkWidget *psWidget, gpointer pData );
void filterDel( GtkWidget *psWidget, gpointer pData );
void filterEdit( GtkWidget *psWidget, gpointer pData );
void LoadFilters( void );
void SaveFilters( void );

#endif
