/* application.c generated by valac 0.38.1.9-3e35a, the Vala compiler
 * generated from application.vala, do not modify */

/* Copyright (C) 2014-2015 Juan R. García Blanco <juanrgar@gmail.com>
 * Copyright (C) 2016 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of GNOME 2048.
 *
 * GNOME 2048 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME 2048 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME 2048; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <libgnome-games-support.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <clutter/clutter.h>
#include <stdio.h>
#include <clutter-gtk/clutter-gtk.h>
#include <gdk/gdk.h>


#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _ApplicationPrivate ApplicationPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
enum  {
	APPLICATION_DUMMY_PROPERTY,
	APPLICATION_LAST_PROPERTY
};
static GParamSpec* application_properties[APPLICATION_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Application {
	GtkApplication parent_instance;
	ApplicationPrivate * priv;
};

struct _ApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ApplicationPrivate {
	GSettings* _settings;
	gint _window_width;
	gint _window_height;
	gboolean _window_maximized;
	gint WINDOW_MINIMUM_SIZE_HEIGHT;
	gint WINDOW_MINIMUM_SIZE_WIDTH;
	GtkWindow* _window;
	GtkHeaderBar* _header_bar;
	GtkButton* _undo_button;
	GtkButton* _new_game_button;
	GtkDialog* _preferences_dialog;
	GtkDialog* _congrats_dialog;
	GtkLabel* _congrats_message;
	GtkLabel* _score;
	GtkComboBoxText* _grid_size_combo;
	GamesScoresContext* _scores_ctx;
	GamesScoresCategory* _grid4_cat;
	GamesScoresCategory* _grid5_cat;
	gboolean _game_restored;
	Game* _game;
};


static gpointer application_parent_class = NULL;

GType application_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APPLICATION, ApplicationPrivate))
static void application_undo_cb (Application* self);
static void _application_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_new_game_cb (Application* self);
static void _application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_scores_cb (Application* self);
static void _application_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_preferences_cb (Application* self);
static void _application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_about_cb (Application* self);
static void _application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void application_quit_cb (Application* self);
static void _application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
gint application_main (gchar** args, int args_length1);
Application* application_new (void);
Application* application_construct (GType object_type);
static void application_real_startup (GApplication* base);
static void _application_init_game (Application* self);
static void _application_create_window (Application* self, GtkBuilder* builder);
static void _application_create_preferences_dialog (Application* self, GtkBuilder* builder);
static void _application_create_congrats_dialog (Application* self, GtkBuilder* builder);
static void _application_create_scores (Application* self);
gboolean game_restore_game (Game* self);
static void application_real_activate (GApplication* base);
static void application_real_shutdown (GApplication* base);
void game_save_game (Game* self);
Game* game_new (GSettings* settings);
Game* game_construct (GType object_type, GSettings* settings);
static void __lambda4_ (Application* self, GObject* s, GParamSpec* p);
guint game_get_score (Game* self);
static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda5_ (Application* self, Game* s);
static void ___lambda6_ (Application* self, GObject* object, GAsyncResult* _result_);
static void ____lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda5__game_finished (Game* _sender, gpointer self);
static void __lambda7_ (Application* self, Game* s, guint v);
static void ___lambda7__game_target_value_reached (Game* _sender, guint val, gpointer self);
static void __lambda8_ (Application* self, Game* s);
static void ___lambda8__game_undo_enabled (Game* _sender, gpointer self);
static void __lambda9_ (Application* self, Game* s);
static void ___lambda9__game_undo_disabled (Game* _sender, gpointer self);
static void _application_create_header_bar (Application* self);
static void _application_create_game_view (Application* self, GtkBuilder* builder);
static gboolean application_key_press_event_cb (Application* self, GtkWidget* widget, GdkEventKey* event);
static gboolean _application_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void application_window_size_allocate_cb (Application* self);
static void _application_window_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean application_window_state_event_cb (Application* self, GdkEventWindowState* event);
static gboolean _application_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
void game_set_view (Game* self, ClutterActor* value);
static void __lambda10_ (Application* self, gint response_id);
static void ___lambda10__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean __lambda11_ (Application* self, GdkEventAny* response_id);
gboolean game_reload_settings (Game* self);
static gboolean ___lambda11__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void __lambda12_ (Application* self, gint response_id);
static void ___lambda12__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean __lambda13_ (Application* self, GdkEventAny* response_id);
static gboolean ___lambda13__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static GamesScoresCategory* application_category_request (Application* self, const gchar* key);
static GamesScoresCategory* _application_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self);
void game_undo (Game* self);
void game_new_game (Game* self);
gboolean game_key_pressed (Game* self, GdkEventKey* event);
static void application_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry APPLICATION_action_entries[6] = {{"undo", _application_undo_cb_gsimple_action_activate_callback}, {"new-game", _application_new_game_cb_gsimple_action_activate_callback}, {"scores", _application_scores_cb_gsimple_action_activate_callback}, {"preferences", _application_preferences_cb_gsimple_action_activate_callback}, {"about", _application_about_cb_gsimple_action_activate_callback}, {"quit", _application_quit_cb_gsimple_action_activate_callback}};

static void _application_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_undo_cb ((Application*) self);
}


static void _application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_new_game_cb ((Application*) self);
}


static void _application_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_scores_cb ((Application*) self);
}


static void _application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_preferences_cb ((Application*) self);
}


static void _application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_about_cb ((Application*) self);
}


static void _application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	application_quit_cb ((Application*) self);
}


gint application_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionGroup* _tmp2_;
	GOptionContext* _tmp3_;
	GOptionGroup* _tmp4_;
	Application* app = NULL;
	Application* _tmp20_;
	Application* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gint _tmp23_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new ("");
	context = _tmp0_;
	_tmp1_ = context;
	_tmp2_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp1_, _tmp2_);
	_tmp3_ = context;
	_tmp4_ = clutter_get_option_group_without_init ();
	g_option_context_add_group (_tmp3_, _tmp4_);
	{
		GOptionContext* _tmp5_;
		_tmp5_ = context;
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s\n", _tmp8_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp9_ = 0;
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp9_;
	}
	g_set_application_name ("org.gnome.gnome-2048");
	gtk_window_set_default_icon_name ("gnome-2048");
	{
		GOptionEntry* _tmp10_;
		GOptionEntry* _tmp11_;
		gint _tmp11__length1;
		_tmp10_ = g_new0 (GOptionEntry, 0);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 0;
		gtk_clutter_init_with_args (&args_length1, &args, "", _tmp11_, NULL, &_inner_error_);
		_tmp11_ = (g_free (_tmp11_), NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GtkMessageDialog* dialog = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		GtkMessageDialog* _tmp14_;
		GtkMessageDialog* _tmp15_;
		const gchar* _tmp16_;
		GtkMessageDialog* _tmp17_;
		GtkMessageDialog* _tmp18_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "Unable to initialize Clutter:\n%s", _tmp13_);
		g_object_ref_sink (_tmp14_);
		dialog = _tmp14_;
		_tmp15_ = dialog;
		_tmp16_ = g_get_application_name ();
		gtk_window_set_title ((GtkWindow*) _tmp15_, _tmp16_);
		_tmp17_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp17_);
		_tmp18_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp18_);
		result = EXIT_FAILURE;
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp19_ = 0;
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp19_;
	}
	_tmp20_ = application_new ();
	app = _tmp20_;
	_tmp21_ = app;
	_tmp22_ = args;
	_tmp22__length1 = args_length1;
	_tmp23_ = g_application_run ((GApplication*) _tmp21_, _tmp22__length1, _tmp22_);
	result = _tmp23_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	return application_main (argv, argc);
}


Application* application_construct (GType object_type) {
	Application * self = NULL;
	self = (Application*) g_object_new (object_type, "application-id", "org.gnome.gnome-2048", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


Application* application_new (void) {
	return application_construct (TYPE_APPLICATION);
}


static void application_real_startup (GApplication* base) {
	Application * self;
	GSettings* _tmp0_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp1_;
	GtkBuilder* _tmp2_;
	GtkBuilder* _tmp3_;
	GtkBuilder* _tmp4_;
	GtkWindow* _tmp5_;
	Game* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	self = (Application*) base;
	G_APPLICATION_CLASS (application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	g_action_map_add_action_entries ((GActionMap*) self, APPLICATION_action_entries, G_N_ELEMENTS (APPLICATION_action_entries), self);
	_tmp0_ = g_settings_new ("org.gnome.2048");
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	_application_init_game (self);
	_tmp1_ = gtk_builder_new ();
	builder = _tmp1_;
	_tmp2_ = builder;
	_application_create_window (self, _tmp2_);
	_tmp3_ = builder;
	_application_create_preferences_dialog (self, _tmp3_);
	_tmp4_ = builder;
	_application_create_congrats_dialog (self, _tmp4_);
	_application_create_scores (self);
	_tmp5_ = self->priv->_window;
	gtk_widget_show_all ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->_game;
	_tmp7_ = game_restore_game (_tmp6_);
	self->priv->_game_restored = _tmp7_;
	_tmp8_ = self->priv->_game_restored;
	if (!_tmp8_) {
		application_new_game_cb (self);
	}
	_g_object_unref0 (builder);
}


static void application_real_activate (GApplication* base) {
	Application * self;
	GtkWindow* _tmp0_;
	self = (Application*) base;
	_tmp0_ = self->priv->_window;
	gtk_window_present (_tmp0_);
}


static void application_real_shutdown (GApplication* base) {
	Application * self;
	Game* _tmp0_;
	GSettings* _tmp1_;
	gint _tmp2_;
	GSettings* _tmp3_;
	gint _tmp4_;
	GSettings* _tmp5_;
	gboolean _tmp6_;
	self = (Application*) base;
	G_APPLICATION_CLASS (application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->_game;
	game_save_game (_tmp0_);
	_tmp1_ = self->priv->_settings;
	_tmp2_ = self->priv->_window_width;
	g_settings_set_int (_tmp1_, "window-width", _tmp2_);
	_tmp3_ = self->priv->_settings;
	_tmp4_ = self->priv->_window_height;
	g_settings_set_int (_tmp3_, "window-height", _tmp4_);
	_tmp5_ = self->priv->_settings;
	_tmp6_ = self->priv->_window_maximized;
	g_settings_set_boolean (_tmp5_, "window-maximized", _tmp6_);
}


static void __lambda4_ (Application* self, GObject* s, GParamSpec* p) {
	GtkLabel* _tmp0_;
	Game* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->_score;
	_tmp1_ = self->priv->_game;
	_tmp2_ = game_get_score (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%u", _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
}


static void ___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda4_ ((Application*) self, _sender, pspec);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ___lambda6_ (Application* self, GObject* object, GAsyncResult* _result_) {
	GAction* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (_result_ != NULL);
	{
		GamesScoresContext* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = self->priv->_scores_ctx;
		_tmp1_ = _result_;
		games_scores_context_add_score_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = stderr;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		fprintf (_tmp2_, "%s\n", _tmp4_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) self, "scores");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction), TRUE);
	g_debug ("application.vala:178: score added");
}


static void ____lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda6_ ((Application*) self, source_object, res);
	g_object_unref (self);
}


static void __lambda5_ (Application* self, Game* s) {
	GtkHeaderBar* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->_header_bar;
	gtk_header_bar_set_subtitle (_tmp0_, _ ("Game Over"));
	_tmp1_ = self->priv->_game_restored;
	if (!_tmp1_) {
		GamesScoresCategory* _tmp2_ = NULL;
		GSettings* _tmp3_;
		gint _tmp4_;
		GamesScoresCategory* cat = NULL;
		GamesScoresCategory* _tmp7_;
		GamesScoresContext* _tmp8_;
		Game* _tmp9_;
		guint _tmp10_;
		guint _tmp11_;
		GamesScoresCategory* _tmp12_;
		_tmp3_ = self->priv->_settings;
		_tmp4_ = g_settings_get_int (_tmp3_, "rows");
		if (_tmp4_ == 4) {
			GamesScoresCategory* _tmp5_;
			_tmp5_ = self->priv->_grid4_cat;
			_tmp2_ = _tmp5_;
		} else {
			GamesScoresCategory* _tmp6_;
			_tmp6_ = self->priv->_grid5_cat;
			_tmp2_ = _tmp6_;
		}
		_tmp7_ = _g_object_ref0 (_tmp2_);
		cat = _tmp7_;
		_tmp8_ = self->priv->_scores_ctx;
		_tmp9_ = self->priv->_game;
		_tmp10_ = game_get_score (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = cat;
		games_scores_context_add_score (_tmp8_, (glong) _tmp11_, _tmp12_, NULL, ____lambda6__gasync_ready_callback, g_object_ref (self));
		_g_object_unref0 (cat);
	}
	g_debug ("application.vala:182: finished");
}


static void ___lambda5__game_finished (Game* _sender, gpointer self) {
	__lambda5_ ((Application*) self, _sender);
}


static void __lambda7_ (Application* self, Game* s, guint v) {
	GSettings* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "do-congrat");
	if (_tmp1_) {
		gchar* message = NULL;
		guint _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GtkLabel* _tmp7_;
		const gchar* _tmp8_;
		GtkDialog* _tmp9_;
		GSettings* _tmp10_;
		_tmp2_ = v;
		_tmp3_ = g_strdup_printf ("You have obtained the %u tile", _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_ (_tmp4_));
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		message = _tmp6_;
		_tmp7_ = self->priv->_congrats_message;
		_tmp8_ = message;
		gtk_label_set_text (_tmp7_, _tmp8_);
		_tmp9_ = self->priv->_congrats_dialog;
		gtk_window_present ((GtkWindow*) _tmp9_);
		_tmp10_ = self->priv->_settings;
		g_settings_set_boolean (_tmp10_, "do-congrat", FALSE);
		_g_free0 (message);
	}
	g_debug ("application.vala:192: target value reached");
}


static void ___lambda7__game_target_value_reached (Game* _sender, guint val, gpointer self) {
	__lambda7_ ((Application*) self, _sender, val);
}


static void __lambda8_ (Application* self, Game* s) {
	GAction* _tmp0_;
	g_return_if_fail (s != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), TRUE);
}


static void ___lambda8__game_undo_enabled (Game* _sender, gpointer self) {
	__lambda8_ ((Application*) self, _sender);
}


static void __lambda9_ (Application* self, Game* s) {
	GAction* _tmp0_;
	g_return_if_fail (s != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), FALSE);
}


static void ___lambda9__game_undo_disabled (Game* _sender, gpointer self) {
	__lambda9_ ((Application*) self, _sender);
}


static void _application_init_game (Application* self) {
	GSettings* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	Game* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	Game* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = game_new (_tmp0_);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp1_;
	_tmp2_ = self->priv->_game;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::score", (GCallback) ___lambda4__g_object_notify, self, 0);
	_tmp3_ = self->priv->_game;
	g_signal_connect_object (_tmp3_, "finished", (GCallback) ___lambda5__game_finished, self, 0);
	_tmp4_ = self->priv->_game;
	g_signal_connect_object (_tmp4_, "target-value-reached", (GCallback) ___lambda7__game_target_value_reached, self, 0);
	_tmp5_ = self->priv->_game;
	g_signal_connect_object (_tmp5_, "undo-enabled", (GCallback) ___lambda8__game_undo_enabled, self, 0);
	_tmp6_ = self->priv->_game;
	g_signal_connect_object (_tmp6_, "undo-disabled", (GCallback) ___lambda9__game_undo_disabled, self, 0);
}


static gboolean _application_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = application_key_press_event_cb ((Application*) self, _sender, event);
	return result;
}


static void _application_window_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	application_window_size_allocate_cb ((Application*) self);
}


static gboolean _application_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = application_window_state_event_cb ((Application*) self, event);
	return result;
}


static void _application_create_window (Application* self, GtkBuilder* builder) {
	GtkBuilder* _tmp4_;
	GObject* _tmp5_;
	GtkWindow* _tmp6_;
	GtkWindow* _tmp7_;
	GSettings* _tmp8_;
	gint _tmp9_;
	GSettings* _tmp10_;
	gint _tmp11_;
	GSettings* _tmp12_;
	gboolean _tmp13_;
	GtkWindow* _tmp15_;
	GtkBuilder* _tmp16_;
	GtkWindow* _tmp17_;
	GtkWindow* _tmp18_;
	gint _tmp19_;
	GtkWindow* _tmp20_;
	GtkWindow* _tmp21_;
	GtkWindow* _tmp22_;
	GdkGeometry geom = {0};
	gint _tmp23_;
	gint _tmp24_;
	GtkWindow* _tmp25_;
	GtkWindow* _tmp26_;
	GdkGeometry _tmp27_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	{
		GtkBuilder* _tmp0_;
		_tmp0_ = builder;
		gtk_builder_add_from_resource (_tmp0_, "/org/gnome/gnome-2048/data/mainwindow.ui", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "%s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = builder;
	_tmp5_ = gtk_builder_get_object (_tmp4_, "applicationwindow");
	_tmp6_ = _g_object_ref0 ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_application_window_get_type (), GtkApplicationWindow));
	_g_object_unref0 (self->priv->_window);
	self->priv->_window = _tmp6_;
	_tmp7_ = self->priv->_window;
	_tmp8_ = self->priv->_settings;
	_tmp9_ = g_settings_get_int (_tmp8_, "window-width");
	_tmp10_ = self->priv->_settings;
	_tmp11_ = g_settings_get_int (_tmp10_, "window-height");
	gtk_window_set_default_size (_tmp7_, _tmp9_, _tmp11_);
	_tmp12_ = self->priv->_settings;
	_tmp13_ = g_settings_get_boolean (_tmp12_, "window-maximized");
	if (_tmp13_) {
		GtkWindow* _tmp14_;
		_tmp14_ = self->priv->_window;
		gtk_window_maximize (_tmp14_);
	}
	_tmp15_ = self->priv->_window;
	gtk_application_add_window ((GtkApplication*) self, _tmp15_);
	_application_create_header_bar (self);
	_tmp16_ = builder;
	_application_create_game_view (self, _tmp16_);
	_tmp17_ = self->priv->_window;
	_tmp18_ = self->priv->_window;
	_tmp19_ = gtk_widget_get_events ((GtkWidget*) _tmp18_);
	gtk_widget_set_events ((GtkWidget*) _tmp17_, ((_tmp19_ | GDK_STRUCTURE_MASK) | GDK_KEY_PRESS_MASK) | GDK_KEY_RELEASE_MASK);
	_tmp20_ = self->priv->_window;
	g_signal_connect_object ((GtkWidget*) _tmp20_, "key-press-event", (GCallback) _application_key_press_event_cb_gtk_widget_key_press_event, self, 0);
	_tmp21_ = self->priv->_window;
	g_signal_connect_object ((GtkWidget*) _tmp21_, "size-allocate", (GCallback) _application_window_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	_tmp22_ = self->priv->_window;
	g_signal_connect_object ((GtkWidget*) _tmp22_, "window-state-event", (GCallback) _application_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	memset (&geom, 0, sizeof (GdkGeometry));
	_tmp23_ = self->priv->WINDOW_MINIMUM_SIZE_HEIGHT;
	geom.min_height = _tmp23_;
	_tmp24_ = self->priv->WINDOW_MINIMUM_SIZE_WIDTH;
	geom.min_width = _tmp24_;
	_tmp25_ = self->priv->_window;
	_tmp26_ = self->priv->_window;
	_tmp27_ = geom;
	gtk_window_set_geometry_hints (_tmp25_, (GtkWidget*) _tmp26_, &_tmp27_, GDK_HINT_MIN_SIZE);
}


static void _application_create_header_bar (Application* self) {
	GtkHeaderBar* _tmp0_;
	GtkHeaderBar* _tmp1_;
	GtkHeaderBar* _tmp2_;
	GtkWindow* _tmp3_;
	GtkHeaderBar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkHeaderBar* _tmp6_;
	GtkLabel* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkHeaderBar* _tmp10_;
	GtkButton* _tmp11_;
	GAction* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkHeaderBar* _tmp15_;
	GtkButton* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkHeaderBar*) gtk_header_bar_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_header_bar);
	self->priv->_header_bar = _tmp0_;
	_tmp1_ = self->priv->_header_bar;
	gtk_header_bar_set_show_close_button (_tmp1_, TRUE);
	_tmp2_ = self->priv->_header_bar;
	gtk_header_bar_set_title (_tmp2_, "2048");
	_tmp3_ = self->priv->_window;
	_tmp4_ = self->priv->_header_bar;
	gtk_window_set_titlebar (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = (GtkLabel*) gtk_label_new ("0");
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->_score);
	self->priv->_score = _tmp5_;
	_tmp6_ = self->priv->_header_bar;
	_tmp7_ = self->priv->_score;
	gtk_header_bar_pack_end (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->_undo_button);
	self->priv->_undo_button = _tmp8_;
	_tmp9_ = self->priv->_undo_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp9_, "app.undo");
	_tmp10_ = self->priv->_header_bar;
	_tmp11_ = self->priv->_undo_button;
	gtk_header_bar_pack_start (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_simple_action_get_type (), GSimpleAction), FALSE);
	_tmp13_ = (GtkButton*) gtk_button_new_with_label (_ ("New Game"));
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->_new_game_button);
	self->priv->_new_game_button = _tmp13_;
	_tmp14_ = self->priv->_new_game_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp14_, "app.new-game");
	_tmp15_ = self->priv->_header_bar;
	_tmp16_ = self->priv->_new_game_button;
	gtk_header_bar_pack_start (_tmp15_, (GtkWidget*) _tmp16_);
}


static void _application_create_game_view (Application* self, GtkBuilder* builder) {
	GtkClutterEmbed* embed = NULL;
	GtkClutterEmbed* _tmp0_;
	GtkAspectFrame* frame = NULL;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_;
	GtkAspectFrame* _tmp3_;
	Game* _tmp4_;
	ClutterActor* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = (GtkClutterEmbed*) gtk_clutter_embed_new ();
	g_object_ref_sink (_tmp0_);
	embed = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = gtk_builder_get_object (_tmp1_, "aspectframe");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	frame = _tmp3_;
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) embed);
	_tmp4_ = self->priv->_game;
	_tmp5_ = gtk_clutter_embed_get_stage (embed);
	game_set_view (_tmp4_, _tmp5_);
	_g_object_unref0 (frame);
	_g_object_unref0 (embed);
}


static void __lambda10_ (Application* self, gint response_id) {
	GtkDialog* _tmp0_;
	_tmp0_ = self->priv->_preferences_dialog;
	gtk_widget_hide_on_delete ((GtkWidget*) _tmp0_);
}


static void ___lambda10__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda10_ ((Application*) self, response_id);
}


static gboolean __lambda11_ (Application* self, GdkEventAny* response_id) {
	gboolean result = FALSE;
	gint grid_size = 0;
	gint rows = 0;
	gint cols = 0;
	gboolean settings_changed = FALSE;
	GtkComboBoxText* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GSettings* _tmp5_;
	gint _tmp6_;
	GSettings* _tmp7_;
	gint _tmp8_;
	Game* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GtkDialog* _tmp12_;
	gboolean _tmp13_;
	g_return_val_if_fail (response_id != NULL, FALSE);
	_tmp0_ = self->priv->_grid_size_combo;
	_tmp1_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
	grid_size = _tmp1_;
	_tmp2_ = grid_size;
	if (_tmp2_ == 0) {
		gint _tmp3_;
		cols = 4;
		_tmp3_ = cols;
		rows = _tmp3_;
	} else {
		gint _tmp4_;
		cols = 5;
		_tmp4_ = cols;
		rows = _tmp4_;
	}
	_tmp5_ = self->priv->_settings;
	_tmp6_ = rows;
	g_settings_set_int (_tmp5_, "rows", _tmp6_);
	_tmp7_ = self->priv->_settings;
	_tmp8_ = cols;
	g_settings_set_int (_tmp7_, "cols", _tmp8_);
	_tmp9_ = self->priv->_game;
	_tmp10_ = game_reload_settings (_tmp9_);
	settings_changed = _tmp10_;
	_tmp11_ = settings_changed;
	if (_tmp11_) {
		application_new_game_cb (self);
	}
	_tmp12_ = self->priv->_preferences_dialog;
	_tmp13_ = gtk_widget_hide_on_delete ((GtkWidget*) _tmp12_);
	result = _tmp13_;
	return result;
}


static gboolean ___lambda11__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda11_ ((Application*) self, event);
	return result;
}


static void _application_create_preferences_dialog (Application* self, GtkBuilder* builder) {
	GtkBuilder* _tmp4_;
	GObject* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkWindow* _tmp8_;
	GtkBuilder* _tmp9_;
	GObject* _tmp10_;
	GtkComboBoxText* _tmp11_;
	GtkDialog* _tmp12_;
	GtkDialog* _tmp13_;
	GSettings* _tmp14_;
	GtkBuilder* _tmp15_;
	GObject* _tmp16_;
	GSettings* _tmp17_;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_;
	GSettings* _tmp20_;
	GtkBuilder* _tmp21_;
	GObject* _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	{
		GtkBuilder* _tmp0_;
		_tmp0_ = builder;
		gtk_builder_add_from_resource (_tmp0_, "/org/gnome/gnome-2048/data/preferences.ui", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "%s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = builder;
	_tmp5_ = gtk_builder_get_object (_tmp4_, "preferencesdialog");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_dialog_get_type (), GtkDialog));
	_g_object_unref0 (self->priv->_preferences_dialog);
	self->priv->_preferences_dialog = _tmp6_;
	_tmp7_ = self->priv->_preferences_dialog;
	_tmp8_ = self->priv->_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp7_, _tmp8_);
	_tmp9_ = builder;
	_tmp10_ = gtk_builder_get_object (_tmp9_, "gridsizecombo");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_combo_box_text_get_type (), GtkComboBoxText));
	_g_object_unref0 (self->priv->_grid_size_combo);
	self->priv->_grid_size_combo = _tmp11_;
	_tmp12_ = self->priv->_preferences_dialog;
	g_signal_connect_object (_tmp12_, "response", (GCallback) ___lambda10__gtk_dialog_response, self, 0);
	_tmp13_ = self->priv->_preferences_dialog;
	g_signal_connect_object ((GtkWidget*) _tmp13_, "delete-event", (GCallback) ___lambda11__gtk_widget_delete_event, self, 0);
	_tmp14_ = self->priv->_settings;
	_tmp15_ = builder;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "congratswitch");
	g_settings_bind (_tmp14_, "do-congrat", _tmp16_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp17_ = self->priv->_settings;
	_tmp18_ = builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "animationsspeed");
	g_settings_bind (_tmp17_, "animations-speed", _tmp19_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp20_ = self->priv->_settings;
	_tmp21_ = builder;
	_tmp22_ = gtk_builder_get_object (_tmp21_, "undoswitch");
	g_settings_bind (_tmp20_, "allow-undo", _tmp22_, "active", G_SETTINGS_BIND_DEFAULT);
}


static void __lambda12_ (Application* self, gint response_id) {
	gint _tmp0_;
	GtkDialog* _tmp1_;
	_tmp0_ = response_id;
	if (_tmp0_ == 0) {
		application_new_game_cb (self);
	}
	_tmp1_ = self->priv->_congrats_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
}


static void ___lambda12__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda12_ ((Application*) self, response_id);
}


static gboolean __lambda13_ (Application* self, GdkEventAny* response_id) {
	gboolean result = FALSE;
	GtkDialog* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (response_id != NULL, FALSE);
	_tmp0_ = self->priv->_congrats_dialog;
	_tmp1_ = gtk_widget_hide_on_delete ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean ___lambda13__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda13_ ((Application*) self, event);
	return result;
}


static void _application_create_congrats_dialog (Application* self, GtkBuilder* builder) {
	GtkBuilder* _tmp4_;
	GObject* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkWindow* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* _tmp10_;
	GtkBuilder* _tmp11_;
	GObject* _tmp12_;
	GtkLabel* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	{
		GtkBuilder* _tmp0_;
		_tmp0_ = builder;
		gtk_builder_add_from_resource (_tmp0_, "/org/gnome/gnome-2048/data/congrats.ui", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "%s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = builder;
	_tmp5_ = gtk_builder_get_object (_tmp4_, "congratsdialog");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_dialog_get_type (), GtkDialog));
	_g_object_unref0 (self->priv->_congrats_dialog);
	self->priv->_congrats_dialog = _tmp6_;
	_tmp7_ = self->priv->_congrats_dialog;
	_tmp8_ = self->priv->_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp7_, _tmp8_);
	_tmp9_ = self->priv->_congrats_dialog;
	g_signal_connect_object (_tmp9_, "response", (GCallback) ___lambda12__gtk_dialog_response, self, 0);
	_tmp10_ = self->priv->_congrats_dialog;
	g_signal_connect_object ((GtkWidget*) _tmp10_, "delete-event", (GCallback) ___lambda13__gtk_widget_delete_event, self, 0);
	_tmp11_ = builder;
	_tmp12_ = gtk_builder_get_object (_tmp11_, "messagelabel");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->_congrats_message);
	self->priv->_congrats_message = _tmp13_;
}


static GamesScoresCategory* application_category_request (Application* self, const gchar* key) {
	GamesScoresCategory* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	if (g_strcmp0 (_tmp0_, "grid4") == 0) {
		GamesScoresCategory* _tmp1_;
		GamesScoresCategory* _tmp2_;
		_tmp1_ = self->priv->_grid4_cat;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = key;
	if (g_strcmp0 (_tmp3_, "grid5") == 0) {
		GamesScoresCategory* _tmp4_;
		GamesScoresCategory* _tmp5_;
		_tmp4_ = self->priv->_grid5_cat;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		result = _tmp5_;
		return result;
	}
	g_assert_not_reached ();
}


static GamesScoresCategory* _application_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self) {
	GamesScoresCategory* result;
	result = application_category_request ((Application*) self, category_key);
	return result;
}


static void _application_create_scores (Application* self) {
	GamesScoresCategory* _tmp0_;
	GamesScoresCategory* _tmp1_;
	GtkWindow* _tmp2_;
	GamesScoresContext* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_scores_category_new ("grid4", "Grid 4 x 4");
	_g_object_unref0 (self->priv->_grid4_cat);
	self->priv->_grid4_cat = _tmp0_;
	_tmp1_ = games_scores_category_new ("grid5", "Grid 5 x 5");
	_g_object_unref0 (self->priv->_grid5_cat);
	self->priv->_grid5_cat = _tmp1_;
	_tmp2_ = self->priv->_window;
	_tmp3_ = games_scores_context_new ("gnome-2048", "", _tmp2_, _application_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER);
	_g_object_unref0 (self->priv->_scores_ctx);
	self->priv->_scores_ctx = _tmp3_;
}


static void application_undo_cb (Application* self) {
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	game_undo (_tmp0_);
}


static void application_new_game_cb (Application* self) {
	GtkHeaderBar* _tmp0_;
	Game* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_header_bar;
	gtk_header_bar_set_subtitle (_tmp0_, NULL);
	self->priv->_game_restored = FALSE;
	_tmp1_ = self->priv->_game;
	game_new_game (_tmp1_);
}


static void application_scores_cb (Application* self) {
	GamesScoresContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_scores_ctx;
	games_scores_context_run_dialog (_tmp0_);
}


static void application_preferences_cb (Application* self) {
	GSettings* _tmp0_;
	gint _tmp1_;
	GtkDialog* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_settings_get_int (_tmp0_, "rows");
	if (_tmp1_ == 4) {
		GtkComboBoxText* _tmp2_;
		_tmp2_ = self->priv->_grid_size_combo;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp2_, 0);
	} else {
		GtkComboBoxText* _tmp3_;
		_tmp3_ = self->priv->_grid_size_combo;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp3_, 1);
	}
	_tmp4_ = self->priv->_preferences_dialog;
	gtk_window_present ((GtkWindow*) _tmp4_);
}


static void application_about_cb (Application* self) {
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint authors_length1;
	gint _authors_size_;
	GtkWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Juan R. García Blanco");
	_tmp1_ = g_strdup ("Arnaud Bonatti");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	authors = _tmp2_;
	authors_length1 = 2;
	_authors_size_ = authors_length1;
	_tmp3_ = self->priv->_window;
	gtk_show_about_dialog (_tmp3_, "program-name", "2048", "version", VERSION, "comments", _ ("A clone of 2048 for GNOME"), "copyright", _ ("Copyright \xc2\xa9 2014-2015 – Juan R. García Blanco\n" \
"Copyright \xc2\xa9 2016 – Arnaud Bonatti"), "license-type", GTK_LICENSE_GPL_3_0, "wrap-license", FALSE, "authors", authors, "translator-credits", _ ("translator-credits"), "logo-icon-name", "gnome-2048", "website", "http://www.gnome.org", NULL, NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void application_quit_cb (Application* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static gboolean application_key_press_event_cb (Application* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	Game* _tmp0_;
	GdkEventKey* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->_game_restored = FALSE;
	_tmp0_ = self->priv->_game;
	_tmp1_ = event;
	_tmp2_ = game_key_pressed (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static void application_window_size_allocate_cb (Application* self) {
	gboolean _tmp0_;
	GtkWindow* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window_maximized;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->_window;
	gtk_window_get_size (_tmp1_, &_tmp2_, &_tmp3_);
	self->priv->_window_width = _tmp2_;
	self->priv->_window_height = _tmp3_;
}


static gboolean application_window_state_event_cb (Application* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_;
	GdkWindowState _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_;
		GdkWindowState _tmp3_;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->_window_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	result = FALSE;
	return result;
}


static void application_class_init (ApplicationClass * klass) {
	application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ApplicationPrivate));
	((GApplicationClass *) klass)->startup = (void (*) (GApplication *)) application_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication *)) application_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication *)) application_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = application_finalize;
}


static void application_instance_init (Application * self) {
	self->priv = APPLICATION_GET_PRIVATE (self);
	self->priv->WINDOW_MINIMUM_SIZE_HEIGHT = 600;
	self->priv->WINDOW_MINIMUM_SIZE_WIDTH = 600;
}


static void application_finalize (GObject * obj) {
	Application * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLICATION, Application);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->_header_bar);
	_g_object_unref0 (self->priv->_undo_button);
	_g_object_unref0 (self->priv->_new_game_button);
	_g_object_unref0 (self->priv->_preferences_dialog);
	_g_object_unref0 (self->priv->_congrats_dialog);
	_g_object_unref0 (self->priv->_congrats_message);
	_g_object_unref0 (self->priv->_score);
	_g_object_unref0 (self->priv->_grid_size_combo);
	_g_object_unref0 (self->priv->_scores_ctx);
	_g_object_unref0 (self->priv->_grid4_cat);
	_g_object_unref0 (self->priv->_grid5_cat);
	_g_object_unref0 (self->priv->_game);
	G_OBJECT_CLASS (application_parent_class)->finalize (obj);
}


GType application_get_type (void) {
	static volatile gsize application_type_id__volatile = 0;
	if (g_once_init_enter (&application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Application), 0, (GInstanceInitFunc) application_instance_init, NULL };
		GType application_type_id;
		application_type_id = g_type_register_static (gtk_application_get_type (), "Application", &g_define_type_info, 0);
		g_once_init_leave (&application_type_id__volatile, application_type_id);
	}
	return application_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



