#ifndef __DRAW_H
#define __DRAW_H
/*-------------------------------------------------------------------------
 * Copyright (c) 2002 Kenneth W. Sodemann (stufflehead@bigfoot.com)
 *-------------------------------------------------------------------------
 * draw
 *
 * Synopsis:
 *    routines used to draw the game board
 *
 * $Id: draw.h,v 1.4 2002/05/25 16:44:49 stuffle Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to 
 * Free Software Foundation, Inc. 
 * 59 Temple Place, Suite 330 
 * Boston, MA  02111-1307  USA
 *
 *-------------------------------------------------------------------------
 */

/*! \file draw.h

  \brief Draw the game board.

  This module contains the routines that are used to draw the game board,
  and to write various items onto the game board.

  \author Kenneth W. Sodemann <stufflehead@bigfoot.com>
  $Revision: 1.4 $
  $Date: 2002/05/25 16:44:49 $
*/

#include "game_engine.h"
#include "operators.h"
#include "player.h"

void draw_cards_up (gint card_one_val, gint card_two_val,
                    operator_type operator);

void draw_cards_down (void);

void clear_message_area (void);
void draw_message (const gchar *str1, const gchar *str2, gboolean center);

gint board_width (void);
gint board_height (void);

void refresh_board (const player_object *player1,
                    const player_object *player2);

void setup_text_gc (void);
void init_draw_objects (void);
void destroy_draw_objects (void);

void draw_pause (void);
void draw_game_over (const game_engine *game);

#endif
