/*
 * Copyright 2014 Higher Frequency Trading
 *
 * http://www.higherfrequencytrading.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.openhft.chronicle.tcp;

import net.openhft.chronicle.MappingFunction;
import net.openhft.chronicle.MappingProvider;

/**
 * Created by Rob Austin
 */
public class Attached implements MappingProvider<Attached> {

    private MappingFunction mappingFunction;

    @Override
    public MappingFunction withMapping() {
        return mappingFunction;
    }

    @Override
    public Attached withMapping(MappingFunction mappingFunction) {
        this.mappingFunction = mappingFunction;
        return this;
    }

    @Override
    public String toString() {
        return "Attached{" +
                "mappingFunction=" + (mappingFunction == null ? "null" : mappingFunction.getClass()
        ) + '}';
    }
}
