/**********************************************************************
  DFTD3vdW_init.c:
  
     DFTD3vdW_init.c is a subroutine to initialize the DFT-D3 calculation.

  Log of DFTD3vdW_init.c:

     Jan/2014  Released by Michael E Ellner

     Parameters taken from:
     r0ab, c6ab taken from dftd3 (http://www.thch.uni-bonn.de/tc/)
     rcov taken from Pyykko and Atsumi, Chem. Eur. J. 15, 2009, 188-197 
     with values for metals decreased by 10 as in dftd3
***********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include "openmx_common.h"
#include "mpi.h"
#include <omp.h>

#define  measure_time   0
#define maxint(a,b) (((a)>(b))?  (a):(b))
int limit_c6(int* iat);

void DFTD3vdW_init(){
  int maxci[95]={0};
  double rcov[95];
  double r2r4[95];
  double r0ab[95][95];
  double c6ab[95][95][5][5][3]={-1.0};
  double maxlentv,templen;
  int i,j,k,l,iZ,jZ;
  int iat,jat,iadr,jadr;
  int myid,numprocs;
  
  double coef, a[4], b[4], c[4], v[4], n[4]; /* PBC */
  
  MPI_Comm_size(mpi_comm_level1,&numprocs);
  MPI_Comm_rank(mpi_comm_level1,&myid);

  k1_dftD=16.0;
  k2_dftD=4.0/3.0;
  k3_dftD=4.0;
  sr8_dftD=1.0;
  alp6_dftD=14.0;
  alp8_dftD=alp6_dftD+2.0;
 /* START PARAMETERS */
  int nlines=32385;
  double c6ab_tmp[]={
  0.30267000E+01, 0.100E+01, 0.100E+01, 0.91180000E+00, 0.91180000E+00,
  0.20835000E+01, 0.200E+01, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.15583000E+01, 0.200E+01, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.38944800E+02, 0.300E+01, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.22150800E+02, 0.300E+01, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.11634454E+04, 0.300E+01, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.24441500E+02, 0.400E+01, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.14824600E+02, 0.400E+01, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.49461900E+03, 0.400E+01, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.25748630E+03, 0.400E+01, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.17314300E+02, 0.500E+01, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.11097500E+02, 0.500E+01, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.28373080E+03, 0.500E+01, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.16159710E+03, 0.500E+01, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.10717770E+03, 0.500E+01, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.12140200E+02, 0.600E+01, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.81841000E+01, 0.600E+01, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.16990300E+03, 0.600E+01, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.10295600E+03, 0.600E+01, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.71279400E+02, 0.600E+01, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.49113000E+02, 0.600E+01, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.87171000E+01, 0.700E+01, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.61380000E+01, 0.700E+01, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.10848540E+03, 0.700E+01, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.68645800E+02, 0.700E+01, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.49113200E+02, 0.700E+01, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.34814600E+02, 0.700E+01, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.25268500E+02, 0.700E+01, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.67180000E+01, 0.800E+01, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.48949000E+01, 0.800E+01, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.76961300E+02, 0.800E+01, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.50125200E+02, 0.800E+01, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.36724700E+02, 0.800E+01, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.26592900E+02, 0.800E+01, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.19654600E+02, 0.800E+01, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.15505900E+02, 0.800E+01, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.51616000E+01, 0.900E+01, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.38825000E+01, 0.900E+01, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.55093300E+02, 0.900E+01, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.36745300E+02, 0.900E+01, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.27482100E+02, 0.900E+01, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.20282700E+02, 0.900E+01, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.15241800E+02, 0.900E+01, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.12183400E+02, 0.900E+01, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.96916000E+01, 0.900E+01, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.40112000E+01, 0.100E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.31025000E+01, 0.100E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.40473100E+02, 0.100E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.27486700E+02, 0.100E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.20902200E+02, 0.100E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.15674000E+02, 0.100E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.11947900E+02, 0.100E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.96606000E+01, 0.100E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.77691000E+01, 0.100E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.62896000E+01, 0.100E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.46823200E+02, 0.110E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.26862800E+02, 0.110E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.13673272E+04, 0.110E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.58745630E+03, 0.110E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.33872120E+03, 0.110E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.20376310E+03, 0.110E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.13065630E+03, 0.110E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.93026300E+02, 0.110E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.66842300E+02, 0.110E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.49279900E+02, 0.110E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.16080286E+04, 0.110E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.38353100E+02, 0.120E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.23032000E+02, 0.120E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.83081560E+03, 0.120E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.41821640E+03, 0.120E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.25813030E+03, 0.120E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.16260820E+03, 0.120E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.10761500E+03, 0.120E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.78225000E+02, 0.120E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.57160500E+02, 0.120E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.42677100E+02, 0.120E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.98516970E+03, 0.120E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.68337580E+03, 0.120E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.36290900E+02, 0.130E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.22322400E+02, 0.130E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.70582540E+03, 0.130E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.37263020E+03, 0.130E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.23647800E+03, 0.130E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.15209340E+03, 0.130E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.10220000E+03, 0.130E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.75075500E+02, 0.130E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.55341200E+02, 0.130E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.41596600E+02, 0.130E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.83896480E+03, 0.130E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.60346890E+03, 0.130E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.54054060E+03, 0.130E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.29594700E+02, 0.140E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.18850000E+02, 0.140E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.49534490E+03, 0.140E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.27978630E+03, 0.140E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.18451110E+03, 0.140E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.12213870E+03, 0.140E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.83849800E+02, 0.140E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.62534900E+02, 0.140E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.46693600E+02, 0.140E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.35455000E+02, 0.140E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.59104580E+03, 0.140E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.44764230E+03, 0.140E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.40896060E+03, 0.140E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.31785740E+03, 0.140E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.23760400E+02, 0.150E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.15668900E+02, 0.150E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.35080300E+03, 0.150E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.20873310E+03, 0.150E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.14234810E+03, 0.150E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.96750300E+02, 0.150E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.67787300E+02, 0.150E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.51309800E+02, 0.150E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.38808400E+02, 0.150E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.29776700E+02, 0.150E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.42000640E+03, 0.150E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.33078010E+03, 0.150E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.30729650E+03, 0.150E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.24435460E+03, 0.150E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.19168870E+03, 0.150E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.20094800E+02, 0.160E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.13610800E+02, 0.160E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.27378670E+03, 0.160E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.16795130E+03, 0.160E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.11711210E+03, 0.160E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.81091900E+02, 0.160E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.57673400E+02, 0.160E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.44147000E+02, 0.160E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.33726400E+02, 0.160E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.26094000E+02, 0.160E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.32859900E+03, 0.160E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.26466650E+03, 0.160E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.24850080E+03, 0.160E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.20053740E+03, 0.160E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.15948980E+03, 0.160E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.13400660E+03, 0.160E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.16705200E+02, 0.170E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.11630200E+02, 0.170E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.21066260E+03, 0.170E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.13298080E+03, 0.170E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.94761200E+02, 0.170E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.66840700E+02, 0.170E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.48262400E+02, 0.170E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.37368800E+02, 0.170E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.28844500E+02, 0.170E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.22512100E+02, 0.170E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.25351360E+03, 0.170E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.20849780E+03, 0.170E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.19775940E+03, 0.170E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.16186860E+03, 0.170E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.13047250E+03, 0.170E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.11070060E+03, 0.170E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.92346000E+02, 0.170E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.13870000E+02, 0.180E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.99130000E+01, 0.180E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.16354970E+03, 0.180E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.10572290E+03, 0.180E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.76794900E+02, 0.180E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.55089800E+02, 0.180E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.40343500E+02, 0.180E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.31578300E+02, 0.180E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.24617800E+02, 0.180E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.19377400E+02, 0.180E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.19734400E+03, 0.180E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.16510060E+03, 0.180E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.15795950E+03, 0.180E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.13089270E+03, 0.180E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.10676980E+03, 0.180E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.91401400E+02, 0.180E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.76938300E+02, 0.180E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.64646200E+02, 0.180E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.76237600E+02, 0.190E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.44041100E+02, 0.190E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.23871574E+04, 0.190E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.97231970E+03, 0.190E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.55419800E+03, 0.190E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.33226940E+03, 0.190E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.21320010E+03, 0.190E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.15214200E+03, 0.190E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.10964390E+03, 0.190E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.81086100E+02, 0.190E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.27986124E+04, 0.190E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.16420587E+04, 0.190E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.13879361E+04, 0.190E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.96762830E+03, 0.190E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.68449680E+03, 0.190E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.53523840E+03, 0.190E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.41315120E+03, 0.190E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.32211550E+03, 0.190E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.49835009E+04, 0.190E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.65818000E+02, 0.200E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.39070100E+02, 0.200E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.16144719E+04, 0.200E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.75790700E+03, 0.200E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.45484390E+03, 0.200E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.28170350E+03, 0.200E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.18454980E+03, 0.200E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.13338470E+03, 0.200E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.97082400E+02, 0.200E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.72307200E+02, 0.200E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.19077081E+04, 0.200E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.12525932E+04, 0.200E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.10888420E+04, 0.200E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.79063470E+03, 0.200E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.57546270E+03, 0.200E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.45684430E+03, 0.200E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.35747370E+03, 0.200E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.28168230E+03, 0.200E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.32404393E+04, 0.200E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.23526862E+04, 0.200E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.54966900E+02, 0.210E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.32899500E+02, 0.210E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.12781183E+04, 0.210E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.61733580E+03, 0.210E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.37504180E+03, 0.210E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.23419500E+03, 0.210E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.15429470E+03, 0.210E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.11193590E+03, 0.210E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.81724200E+02, 0.210E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.61015400E+02, 0.210E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.15125338E+04, 0.210E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.10155454E+04, 0.210E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.88860250E+03, 0.210E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.65120400E+03, 0.210E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.47727970E+03, 0.210E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.38041070E+03, 0.210E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.29876860E+03, 0.210E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.23614170E+03, 0.210E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.25499412E+04, 0.210E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.18887902E+04, 0.210E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.15224676E+04, 0.210E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.53687500E+02, 0.220E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.32531600E+02, 0.220E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.11929128E+04, 0.220E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.58748980E+03, 0.220E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.36108650E+03, 0.220E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.22757230E+03, 0.220E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.15101990E+03, 0.220E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.11014520E+03, 0.220E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.80797500E+02, 0.220E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.60559400E+02, 0.220E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.14131570E+04, 0.220E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.96298310E+03, 0.220E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.84746150E+03, 0.220E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.62623530E+03, 0.220E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.46232470E+03, 0.220E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.37026310E+03, 0.220E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.29218530E+03, 0.220E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.23192080E+03, 0.220E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.23746690E+04, 0.220E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.17795162E+04, 0.220E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.14382841E+04, 0.220E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.13619185E+04, 0.220E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.49481900E+02, 0.230E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.30185100E+02, 0.230E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.10690426E+04, 0.230E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.53334990E+03, 0.230E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.33010230E+03, 0.230E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.20914500E+03, 0.230E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.13935120E+03, 0.230E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.10193250E+03, 0.230E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.74967100E+02, 0.230E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.56310800E+02, 0.230E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.12673139E+04, 0.230E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.87225790E+03, 0.230E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.77034320E+03, 0.230E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.57211290E+03, 0.230E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.42414700E+03, 0.230E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.34060200E+03, 0.230E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.26948630E+03, 0.230E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.21440020E+03, 0.230E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.21241985E+04, 0.230E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.16049178E+04, 0.230E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.12995197E+04, 0.230E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.12323235E+04, 0.230E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.11160984E+04, 0.230E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.39122100E+02, 0.240E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.24146300E+02, 0.240E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.84409360E+03, 0.240E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.41816350E+03, 0.240E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.25930210E+03, 0.240E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.16498820E+03, 0.240E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.11048610E+03, 0.240E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.81200000E+02, 0.240E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.60009900E+02, 0.240E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.45282000E+02, 0.240E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.10004652E+04, 0.240E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.68440150E+03, 0.240E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.60440710E+03, 0.240E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.44922160E+03, 0.240E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.33383800E+03, 0.240E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.26880290E+03, 0.240E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.21336680E+03, 0.240E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.17034650E+03, 0.240E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.16836701E+04, 0.240E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.12630809E+04, 0.240E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.10216871E+04, 0.240E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.96885650E+03, 0.240E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.87738550E+03, 0.240E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.69074250E+03, 0.240E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.43002800E+02, 0.250E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.26497800E+02, 0.250E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.89197560E+03, 0.250E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.45336860E+03, 0.250E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.28347440E+03, 0.250E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.18100350E+03, 0.250E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.12132330E+03, 0.250E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.89134600E+02, 0.250E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.65811200E+02, 0.250E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.49595900E+02, 0.250E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.10585103E+04, 0.250E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.73904110E+03, 0.250E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.65607380E+03, 0.250E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.49081560E+03, 0.250E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.36612040E+03, 0.250E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.29517370E+03, 0.250E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.23445330E+03, 0.250E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.18717280E+03, 0.250E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.17680322E+04, 0.250E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.13514785E+04, 0.250E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.10971539E+04, 0.250E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.10426625E+04, 0.250E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.94560720E+03, 0.250E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.74331790E+03, 0.250E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.80274840E+03, 0.250E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.33911000E+02, 0.260E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.21175000E+02, 0.260E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.69845390E+03, 0.260E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.35353580E+03, 0.260E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.22175470E+03, 0.260E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.14234670E+03, 0.260E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.95978200E+02, 0.260E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.70894200E+02, 0.260E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.52631000E+02, 0.260E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.39865900E+02, 0.260E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.82889360E+03, 0.260E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.57651210E+03, 0.260E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.51208230E+03, 0.260E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.38374450E+03, 0.260E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.28716060E+03, 0.260E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.23226250E+03, 0.260E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.18518230E+03, 0.260E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.14843190E+03, 0.260E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.13889522E+04, 0.260E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.10565193E+04, 0.260E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.85717300E+03, 0.260E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.81484020E+03, 0.260E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.73905420E+03, 0.260E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.58181140E+03, 0.260E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.62754030E+03, 0.260E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.49133490E+03, 0.260E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.36323400E+02, 0.270E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.22723300E+02, 0.270E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.70153240E+03, 0.270E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.36919280E+03, 0.270E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.23486930E+03, 0.270E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.15187030E+03, 0.270E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.10275030E+03, 0.270E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.75991200E+02, 0.270E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.56430700E+02, 0.270E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.42727000E+02, 0.270E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.83418260E+03, 0.270E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.59833020E+03, 0.270E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.53597060E+03, 0.270E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.40599070E+03, 0.270E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.30592560E+03, 0.270E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.24821160E+03, 0.270E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.19835700E+03, 0.270E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.15919570E+03, 0.270E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.13829771E+04, 0.270E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.10817690E+04, 0.270E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.88245030E+03, 0.270E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.84183350E+03, 0.270E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.76531780E+03, 0.270E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.60141780E+03, 0.270E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.65196880E+03, 0.270E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.50977640E+03, 0.270E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.53277940E+03, 0.270E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.37159600E+02, 0.280E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.23079200E+02, 0.280E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.73885800E+03, 0.280E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.38391400E+03, 0.280E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.24241740E+03, 0.280E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.15585070E+03, 0.280E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.10498340E+03, 0.280E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.77401000E+02, 0.280E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.57324800E+02, 0.280E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.43312900E+02, 0.280E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.87793540E+03, 0.280E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.62363050E+03, 0.280E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.55653890E+03, 0.280E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.41935930E+03, 0.280E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.31456980E+03, 0.280E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.25446830E+03, 0.280E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.20277050E+03, 0.280E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.16232640E+03, 0.280E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.14584501E+04, 0.280E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.11321074E+04, 0.280E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.92189900E+03, 0.280E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.87809390E+03, 0.280E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.79751950E+03, 0.280E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.62664720E+03, 0.280E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.67845310E+03, 0.280E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.53032210E+03, 0.280E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.55308340E+03, 0.280E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.57474360E+03, 0.280E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.28594000E+02, 0.290E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.18021600E+02, 0.290E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.56945260E+03, 0.290E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.29279550E+03, 0.290E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.18517410E+03, 0.290E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.11963500E+03, 0.290E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.81085500E+02, 0.290E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.60133500E+02, 0.290E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.44809800E+02, 0.290E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.34054400E+02, 0.290E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.67647730E+03, 0.290E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.47624260E+03, 0.290E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.42477230E+03, 0.290E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.32019130E+03, 0.290E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.24079740E+03, 0.290E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.19540750E+03, 0.290E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.15631610E+03, 0.290E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.12567760E+03, 0.290E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.11299518E+04, 0.290E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.86836740E+03, 0.290E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.70607200E+03, 0.290E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.67241280E+03, 0.290E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.61057000E+03, 0.290E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.48069380E+03, 0.290E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.51930780E+03, 0.290E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.40672680E+03, 0.290E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.42308770E+03, 0.290E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.43963650E+03, 0.290E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.33718080E+03, 0.290E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.29868900E+02, 0.300E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.18969500E+02, 0.300E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.54091600E+03, 0.300E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.29331060E+03, 0.300E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.18962930E+03, 0.300E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.12410320E+03, 0.300E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.84731100E+02, 0.300E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.63077400E+02, 0.300E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.47112200E+02, 0.300E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.35842700E+02, 0.300E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.64434080E+03, 0.300E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.47291430E+03, 0.300E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.42716100E+03, 0.300E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.32728100E+03, 0.300E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.24897430E+03, 0.300E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.20324270E+03, 0.300E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.16338480E+03, 0.300E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.13181190E+03, 0.300E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.10625928E+04, 0.300E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.84685270E+03, 0.300E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.69367870E+03, 0.300E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.66410090E+03, 0.300E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.60506230E+03, 0.300E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.47555940E+03, 0.300E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.51709100E+03, 0.300E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.40455580E+03, 0.300E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.42487900E+03, 0.300E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.44009000E+03, 0.300E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.33664930E+03, 0.300E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.34052130E+03, 0.300E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.35169700E+02, 0.310E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.22045800E+02, 0.310E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.65674410E+03, 0.310E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.35111410E+03, 0.310E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.22539330E+03, 0.310E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.14655440E+03, 0.310E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.99440700E+02, 0.310E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.73625300E+02, 0.310E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.54678200E+02, 0.310E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.41368100E+02, 0.310E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.78135240E+03, 0.310E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.56716380E+03, 0.310E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.51058540E+03, 0.310E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.38926560E+03, 0.310E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.29479250E+03, 0.310E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.23981830E+03, 0.310E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.19205780E+03, 0.310E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.15434230E+03, 0.310E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.12928121E+04, 0.310E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.10198835E+04, 0.310E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.83374240E+03, 0.310E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.79686170E+03, 0.310E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.72525140E+03, 0.310E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.56976450E+03, 0.310E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.61883870E+03, 0.310E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.48378150E+03, 0.310E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.50713160E+03, 0.310E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.52581620E+03, 0.310E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.40196130E+03, 0.310E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.40545650E+03, 0.310E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.48375160E+03, 0.310E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.31817000E+02, 0.320E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.20431800E+02, 0.320E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.52792680E+03, 0.320E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.29842200E+03, 0.320E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.19734480E+03, 0.320E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.13109540E+03, 0.320E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.90332800E+02, 0.320E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.67593200E+02, 0.320E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.50641200E+02, 0.320E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.38574600E+02, 0.320E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.63010410E+03, 0.320E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.47737440E+03, 0.320E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.43650600E+03, 0.320E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.33983280E+03, 0.320E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.26182350E+03, 0.320E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.21531010E+03, 0.320E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.17419690E+03, 0.320E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.14120630E+03, 0.320E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.10326651E+04, 0.320E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.84336440E+03, 0.320E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.69470240E+03, 0.320E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.66837860E+03, 0.320E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.61076390E+03, 0.320E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.47996390E+03, 0.320E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.52418480E+03, 0.320E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.41021060E+03, 0.320E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.43385080E+03, 0.320E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.44798680E+03, 0.320E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.34242610E+03, 0.320E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.34998850E+03, 0.320E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.41595300E+03, 0.320E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.36354740E+03, 0.320E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.27788400E+02, 0.330E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.18328400E+02, 0.330E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.41515320E+03, 0.330E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.24548310E+03, 0.330E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.16690600E+03, 0.330E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.11326160E+03, 0.330E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.79308600E+02, 0.330E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.60028900E+02, 0.330E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.45418000E+02, 0.330E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.34868600E+02, 0.330E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.49693380E+03, 0.330E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.38949270E+03, 0.330E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.36119130E+03, 0.330E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.28659090E+03, 0.330E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.22447740E+03, 0.330E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.18663480E+03, 0.330E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.15260350E+03, 0.330E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.12485610E+03, 0.330E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.81065540E+03, 0.330E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.67900440E+03, 0.330E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.56269470E+03, 0.330E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.54467970E+03, 0.330E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.49949700E+03, 0.330E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.39319220E+03, 0.330E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.43091460E+03, 0.330E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.33800960E+03, 0.330E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.35971500E+03, 0.330E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.37003590E+03, 0.330E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.28333230E+03, 0.330E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.29250300E+03, 0.330E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.34635080E+03, 0.330E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.30710100E+03, 0.330E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.26294980E+03, 0.330E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.25309800E+02, 0.340E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.17024300E+02, 0.340E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.35454290E+03, 0.340E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.21502380E+03, 0.340E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.14880080E+03, 0.340E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.10243460E+03, 0.340E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.72540300E+02, 0.340E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.55362700E+02, 0.340E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.42192300E+02, 0.340E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.32584300E+02, 0.340E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.42518640E+03, 0.340E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.33957420E+03, 0.340E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.31761820E+03, 0.340E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.25500990E+03, 0.340E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.20190190E+03, 0.340E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.16913080E+03, 0.340E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.13931630E+03, 0.340E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.11474490E+03, 0.340E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.69291160E+03, 0.340E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.58796470E+03, 0.340E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.48887150E+03, 0.340E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.47503480E+03, 0.340E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.43657180E+03, 0.340E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.34429560E+03, 0.340E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.37782760E+03, 0.340E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.29703960E+03, 0.340E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.31701740E+03, 0.340E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.32534190E+03, 0.340E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.24963850E+03, 0.340E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.25904590E+03, 0.340E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.30595010E+03, 0.340E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.27365300E+03, 0.340E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.23634730E+03, 0.340E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.21367380E+03, 0.340E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.22483400E+02, 0.350E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.15455300E+02, 0.350E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.29478970E+03, 0.350E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.18337420E+03, 0.350E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.12924950E+03, 0.350E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.90342400E+02, 0.350E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.64763200E+02, 0.350E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.49879500E+02, 0.350E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.38322500E+02, 0.350E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.29795800E+02, 0.350E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.35428690E+03, 0.350E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.28827360E+03, 0.350E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.27200980E+03, 0.350E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.22105370E+03, 0.350E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.17699300E+03, 0.350E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.14945630E+03, 0.350E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.12409090E+03, 0.350E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.10294710E+03, 0.350E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.57723180E+03, 0.350E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.49597540E+03, 0.350E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.41374680E+03, 0.350E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.40365760E+03, 0.350E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.37180710E+03, 0.350E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.29391850E+03, 0.350E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.32284330E+03, 0.350E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.25453060E+03, 0.350E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.27230530E+03, 0.350E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.27877050E+03, 0.350E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.21450590E+03, 0.350E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.22363480E+03, 0.350E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.26334580E+03, 0.350E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.23762950E+03, 0.350E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.20707720E+03, 0.350E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.18836050E+03, 0.350E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.16712970E+03, 0.350E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.19818200E+02, 0.360E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.13921100E+02, 0.360E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.24455540E+03, 0.360E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.15556160E+03, 0.360E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.11153710E+03, 0.360E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.79108000E+02, 0.360E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.57389500E+02, 0.360E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.44600300E+02, 0.360E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.34545200E+02, 0.360E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.27043000E+02, 0.360E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.29455740E+03, 0.360E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.24359650E+03, 0.360E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.23169040E+03, 0.360E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.19039340E+03, 0.360E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.15405750E+03, 0.360E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.13109280E+03, 0.360E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.10968390E+03, 0.360E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.91643000E+02, 0.360E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.48024720E+03, 0.360E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.41697770E+03, 0.360E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.34884740E+03, 0.360E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.34162730E+03, 0.360E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.31532510E+03, 0.360E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.24994130E+03, 0.360E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.27464190E+03, 0.360E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.21720710E+03, 0.360E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.23275940E+03, 0.360E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.23774470E+03, 0.360E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.18353470E+03, 0.360E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.19204840E+03, 0.360E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.22545370E+03, 0.360E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.20505980E+03, 0.360E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.18018180E+03, 0.360E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.16484940E+03, 0.360E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.14718300E+03, 0.360E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.13040170E+03, 0.360E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.85949900E+02, 0.370E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.50049100E+02, 0.370E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.26473331E+04, 0.370E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.10827052E+04, 0.370E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.62008780E+03, 0.370E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.37353840E+03, 0.370E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.24069400E+03, 0.370E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.17233980E+03, 0.370E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.12458790E+03, 0.370E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.92382700E+02, 0.370E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.31041016E+04, 0.370E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.18264648E+04, 0.370E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.15469229E+04, 0.370E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.10820563E+04, 0.370E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.76813350E+03, 0.370E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.60222210E+03, 0.370E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.46615650E+03, 0.370E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.36440670E+03, 0.370E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.55302806E+04, 0.370E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.35994349E+04, 0.370E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.28340920E+04, 0.370E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.26412435E+04, 0.370E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.23637175E+04, 0.370E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.18740326E+04, 0.370E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.19687631E+04, 0.370E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.15471982E+04, 0.370E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.15418997E+04, 0.370E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.16251034E+04, 0.370E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.12594427E+04, 0.370E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.11862631E+04, 0.370E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.14423807E+04, 0.370E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.11551526E+04, 0.370E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.90942570E+03, 0.370E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.77892040E+03, 0.370E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.65036060E+03, 0.370E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.54231600E+03, 0.370E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.61387755E+04, 0.370E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.78390100E+02, 0.380E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.46665800E+02, 0.380E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.19442260E+04, 0.380E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.90392650E+03, 0.380E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.54157290E+03, 0.380E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.33545970E+03, 0.380E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.21996080E+03, 0.380E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.15914600E+03, 0.380E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.11596470E+03, 0.380E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.86462700E+02, 0.380E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.22961906E+04, 0.380E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.14958141E+04, 0.380E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.12985356E+04, 0.380E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.94141210E+03, 0.380E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.68496320E+03, 0.380E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.54396270E+03, 0.380E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.42589970E+03, 0.380E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.33586900E+03, 0.380E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.39153529E+04, 0.380E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.28194935E+04, 0.380E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.22604217E+04, 0.380E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.21283951E+04, 0.380E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.19186941E+04, 0.380E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.15113043E+04, 0.380E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.16147190E+04, 0.380E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.12632327E+04, 0.380E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.12908718E+04, 0.380E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.13513702E+04, 0.380E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.10377284E+04, 0.380E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.10096809E+04, 0.380E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.12165138E+04, 0.380E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.10044824E+04, 0.380E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.80833700E+03, 0.380E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.70005320E+03, 0.380E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.59073260E+03, 0.380E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.49691200E+03, 0.380E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.43492577E+04, 0.380E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.33813672E+04, 0.380E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.70057000E+02, 0.390E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.42419500E+02, 0.390E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.15853950E+04, 0.390E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.77148440E+03, 0.390E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.47243640E+03, 0.390E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.29721710E+03, 0.390E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.19706110E+03, 0.390E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.14366020E+03, 0.390E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.10534470E+03, 0.390E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.78931600E+02, 0.390E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.18768634E+04, 0.390E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.12667602E+04, 0.390E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.11122980E+04, 0.390E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.81954180E+03, 0.390E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.60399160E+03, 0.390E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.48337970E+03, 0.390E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.38124620E+03, 0.390E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.30251430E+03, 0.390E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.31660625E+04, 0.390E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.23508018E+04, 0.390E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.18967809E+04, 0.390E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.17943180E+04, 0.390E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.16224689E+04, 0.390E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.12764352E+04, 0.390E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.13714492E+04, 0.390E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.10723265E+04, 0.390E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.11053016E+04, 0.390E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.11535737E+04, 0.390E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.88416480E+03, 0.390E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.87069350E+03, 0.390E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.10455505E+04, 0.390E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.87478360E+03, 0.390E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.71175060E+03, 0.390E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.62033340E+03, 0.390E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.52682990E+03, 0.390E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.44570130E+03, 0.390E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.35209466E+04, 0.390E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.28137007E+04, 0.390E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.23658925E+04, 0.390E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.63780100E+02, 0.400E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.39108800E+02, 0.400E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.13632842E+04, 0.400E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.68152830E+03, 0.400E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.42323020E+03, 0.400E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.26904900E+03, 0.400E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.17977770E+03, 0.400E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.13178520E+03, 0.400E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.97097700E+02, 0.400E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.73031500E+02, 0.400E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.16162863E+04, 0.400E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.11138339E+04, 0.400E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.98504940E+03, 0.400E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.73318070E+03, 0.400E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.54488820E+03, 0.400E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.43838900E+03, 0.400E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.34753340E+03, 0.400E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.27699080E+03, 0.400E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.27111542E+04, 0.400E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.20485251E+04, 0.400E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.16591156E+04, 0.400E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.15741401E+04, 0.400E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.14260687E+04, 0.400E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.11215489E+04, 0.400E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.12087451E+04, 0.400E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.94517130E+03, 0.400E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.97897670E+03, 0.400E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.10197589E+04, 0.400E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.78111330E+03, 0.400E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.77458710E+03, 0.400E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.92819820E+03, 0.400E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.78294420E+03, 0.400E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.64155640E+03, 0.400E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.56154740E+03, 0.400E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.47900400E+03, 0.400E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.40687270E+03, 0.400E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.30176856E+04, 0.400E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.24494723E+04, 0.400E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.20726170E+04, 0.400E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.18227181E+04, 0.400E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.58676800E+02, 0.410E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.36341800E+02, 0.410E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.12090304E+04, 0.410E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.61398500E+03, 0.410E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.38490720E+03, 0.410E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.24652410E+03, 0.410E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.16569430E+03, 0.410E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.12198680E+03, 0.410E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.90223400E+02, 0.410E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.68076900E+02, 0.410E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.14346641E+04, 0.410E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.10005663E+04, 0.410E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.88903020E+03, 0.410E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.66615070E+03, 0.410E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.49797030E+03, 0.410E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.40219740E+03, 0.410E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.32006760E+03, 0.410E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.25597690E+03, 0.410E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.24006918E+04, 0.410E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.18308523E+04, 0.410E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.14860620E+04, 0.410E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.14126818E+04, 0.410E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.12813349E+04, 0.410E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.10078571E+04, 0.410E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.10879837E+04, 0.410E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.85106340E+03, 0.410E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.88388900E+03, 0.410E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.91953540E+03, 0.410E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.70437890E+03, 0.410E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.70135490E+03, 0.410E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.83928280E+03, 0.410E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.71168230E+03, 0.410E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.58600840E+03, 0.410E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.51450770E+03, 0.410E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.44029990E+03, 0.410E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.37513390E+03, 0.410E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.26739344E+04, 0.410E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.21882864E+04, 0.410E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.18586377E+04, 0.410E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.16384938E+04, 0.410E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.14752500E+04, 0.410E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.46040600E+02, 0.420E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.29161700E+02, 0.420E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.89051260E+03, 0.420E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.46330650E+03, 0.420E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.29535920E+03, 0.420E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.19195280E+03, 0.420E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.13060450E+03, 0.420E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.97067500E+02, 0.420E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.72418600E+02, 0.420E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.55048700E+02, 0.420E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.10583899E+04, 0.420E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.75166280E+03, 0.420E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.67311930E+03, 0.420E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.51023520E+03, 0.420E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.38558950E+03, 0.420E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.31386570E+03, 0.420E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.25177230E+03, 0.420E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.20285720E+03, 0.420E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.17658946E+04, 0.420E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.13654837E+04, 0.420E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.11120098E+04, 0.420E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.10606255E+04, 0.420E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.96394340E+03, 0.420E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.75899550E+03, 0.420E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.82093130E+03, 0.420E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.64312470E+03, 0.420E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.67034900E+03, 0.420E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.69583480E+03, 0.420E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.53365350E+03, 0.420E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.53452070E+03, 0.420E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.63792330E+03, 0.420E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.54578450E+03, 0.420E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.45341860E+03, 0.420E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.40049980E+03, 0.420E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.34498260E+03, 0.420E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.29579940E+03, 0.420E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.19694796E+04, 0.420E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.16315424E+04, 0.420E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.13940976E+04, 0.420E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.12339095E+04, 0.420E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.11140924E+04, 0.420E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.84589720E+03, 0.420E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.51052700E+02, 0.430E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.32058800E+02, 0.430E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.10116099E+04, 0.430E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.52142490E+03, 0.430E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.33032570E+03, 0.430E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.21347990E+03, 0.430E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.14456970E+03, 0.430E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.10705880E+03, 0.430E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.79612100E+02, 0.430E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.60352100E+02, 0.430E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.12015234E+04, 0.430E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.84734970E+03, 0.430E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.75661950E+03, 0.430E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.57105010E+03, 0.430E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.42976770E+03, 0.430E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.34877440E+03, 0.430E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.27891230E+03, 0.430E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.22407940E+03, 0.430E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.20076137E+04, 0.430E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.15434258E+04, 0.430E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.12553446E+04, 0.430E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.11958434E+04, 0.430E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.10860231E+04, 0.430E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.85474740E+03, 0.430E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.92387430E+03, 0.430E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.72332020E+03, 0.430E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.75296780E+03, 0.430E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.78224830E+03, 0.430E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.59961920E+03, 0.430E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.59931410E+03, 0.430E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.71598110E+03, 0.430E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.61053270E+03, 0.430E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.50550910E+03, 0.430E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.44547780E+03, 0.430E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.38275910E+03, 0.430E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.32738270E+03, 0.430E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.22379665E+04, 0.430E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.18443774E+04, 0.430E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.15723759E+04, 0.430E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.13895979E+04, 0.430E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.12533465E+04, 0.430E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.94964900E+03, 0.430E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.10670169E+04, 0.430E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.39574500E+02, 0.440E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.25462200E+02, 0.440E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.73055330E+03, 0.440E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.38726810E+03, 0.440E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.24993820E+03, 0.440E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.16412790E+03, 0.440E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.11263780E+03, 0.440E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.84272500E+02, 0.440E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.63259900E+02, 0.440E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.48342900E+02, 0.440E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.86937740E+03, 0.440E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.62621040E+03, 0.440E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.56407160E+03, 0.440E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.43121320E+03, 0.440E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.32840720E+03, 0.440E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.26878240E+03, 0.440E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.21680700E+03, 0.440E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.17558760E+03, 0.440E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.14473048E+04, 0.440E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.11311769E+04, 0.440E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.92358110E+03, 0.440E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.88314920E+03, 0.440E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.80388070E+03, 0.440E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.63343940E+03, 0.440E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.68617720E+03, 0.440E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.53814350E+03, 0.440E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.56248000E+03, 0.440E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.58290140E+03, 0.440E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.44742590E+03, 0.440E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.45015430E+03, 0.440E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.53610930E+03, 0.440E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.46167950E+03, 0.440E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.38598830E+03, 0.440E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.34238140E+03, 0.440E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.29626680E+03, 0.440E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.25515160E+03, 0.440E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.16158387E+04, 0.440E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.13511988E+04, 0.440E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.11599071E+04, 0.440E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.10297665E+04, 0.440E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.93174450E+03, 0.440E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.71028370E+03, 0.440E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.79619510E+03, 0.440E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.59819880E+03, 0.440E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.43166100E+02, 0.450E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.27574500E+02, 0.450E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.79420060E+03, 0.450E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.42441200E+03, 0.450E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.27371950E+03, 0.450E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.17927080E+03, 0.450E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.12264260E+03, 0.450E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.91495900E+02, 0.450E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.68488800E+02, 0.450E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.52207200E+02, 0.450E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.94542210E+03, 0.450E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.68566280E+03, 0.450E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.61792440E+03, 0.450E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.47237380E+03, 0.450E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.35925470E+03, 0.450E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.29352140E+03, 0.450E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.23627500E+03, 0.450E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.19093520E+03, 0.450E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.15674954E+04, 0.450E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.12346013E+04, 0.450E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.10091933E+04, 0.450E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.96523080E+03, 0.450E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.87880270E+03, 0.450E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.69163140E+03, 0.450E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.75032510E+03, 0.450E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.58775440E+03, 0.450E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.61543640E+03, 0.450E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.63776340E+03, 0.450E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.48875010E+03, 0.450E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.49263190E+03, 0.450E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.58677320E+03, 0.450E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.50544520E+03, 0.450E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.42219710E+03, 0.450E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.37406320E+03, 0.450E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.32319410E+03, 0.450E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.27786800E+03, 0.450E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.17497615E+04, 0.450E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.14735487E+04, 0.450E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.12668436E+04, 0.450E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.11253403E+04, 0.450E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.10182915E+04, 0.450E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.77583530E+03, 0.450E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.86989620E+03, 0.450E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.65317750E+03, 0.450E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.71394270E+03, 0.450E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.40237200E+02, 0.460E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.25871600E+02, 0.460E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.72242940E+03, 0.460E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.39043100E+03, 0.460E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.25334250E+03, 0.460E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.16671110E+03, 0.460E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.11447630E+03, 0.460E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.85642700E+02, 0.460E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.64270700E+02, 0.460E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.49099000E+02, 0.460E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.86062090E+03, 0.460E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.62959120E+03, 0.460E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.56914100E+03, 0.460E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.43694630E+03, 0.460E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.33352190E+03, 0.460E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.27315680E+03, 0.460E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.22040990E+03, 0.460E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.17850210E+03, 0.460E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.14240271E+04, 0.460E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.11296670E+04, 0.460E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.92485560E+03, 0.460E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.88576570E+03, 0.460E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.80712580E+03, 0.460E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.63532570E+03, 0.460E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.68996470E+03, 0.460E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.54065990E+03, 0.460E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.56710440E+03, 0.460E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.58718190E+03, 0.460E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.45005590E+03, 0.460E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.45480310E+03, 0.460E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.54115010E+03, 0.460E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.46770420E+03, 0.460E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.39185280E+03, 0.460E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.34783930E+03, 0.460E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.30113900E+03, 0.460E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.25939640E+03, 0.460E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.15904415E+04, 0.460E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.13479007E+04, 0.460E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.11619289E+04, 0.460E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.10338735E+04, 0.460E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.93655280E+03, 0.460E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.71494950E+03, 0.460E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.80104420E+03, 0.460E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.60279560E+03, 0.460E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.65887530E+03, 0.460E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.60850410E+03, 0.460E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.33541300E+02, 0.470E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.21789600E+02, 0.470E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.61414770E+03, 0.470E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.32557750E+03, 0.470E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.21068110E+03, 0.470E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.13887580E+03, 0.470E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.95713700E+02, 0.470E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.71892600E+02, 0.470E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.54190300E+02, 0.470E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.41578000E+02, 0.470E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.73108320E+03, 0.470E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.52647760E+03, 0.470E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.47457130E+03, 0.470E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.36335850E+03, 0.470E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.27735770E+03, 0.470E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.22750240E+03, 0.470E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.18398760E+03, 0.470E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.14942690E+03, 0.470E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.12184699E+04, 0.470E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.95149350E+03, 0.470E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.77689140E+03, 0.470E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.74320410E+03, 0.470E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.67665530E+03, 0.470E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.53368780E+03, 0.470E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.57781270E+03, 0.470E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.45363270E+03, 0.470E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.47392440E+03, 0.470E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.49097830E+03, 0.470E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.37735310E+03, 0.470E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.37956550E+03, 0.470E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.45158870E+03, 0.470E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.38930750E+03, 0.470E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.32603710E+03, 0.470E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.28964690E+03, 0.470E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.25111890E+03, 0.470E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.21673360E+03, 0.470E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.13607517E+04, 0.470E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.11369099E+04, 0.470E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.97620250E+03, 0.470E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.86700560E+03, 0.470E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.78481880E+03, 0.470E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.59905300E+03, 0.470E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.67117170E+03, 0.470E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.50502690E+03, 0.470E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.55108020E+03, 0.470E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.50877420E+03, 0.470E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.42674500E+03, 0.470E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.35687900E+02, 0.480E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.23156300E+02, 0.480E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.62105360E+03, 0.480E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.34041220E+03, 0.480E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.22262730E+03, 0.480E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.14741380E+03, 0.480E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.10173770E+03, 0.480E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.76409200E+02, 0.480E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.57550000E+02, 0.480E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.44106200E+02, 0.480E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.74057870E+03, 0.480E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.54767210E+03, 0.480E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.49703370E+03, 0.480E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.38367900E+03, 0.480E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.29424650E+03, 0.480E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.24176140E+03, 0.480E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.19570440E+03, 0.480E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.15896500E+03, 0.480E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.12225553E+04, 0.480E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.97842510E+03, 0.480E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.80260200E+03, 0.480E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.77003030E+03, 0.480E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.70242130E+03, 0.480E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.55309190E+03, 0.480E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.60140530E+03, 0.480E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.47153290E+03, 0.480E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.49563130E+03, 0.480E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.51262200E+03, 0.480E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.39305100E+03, 0.480E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.39845720E+03, 0.480E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.47342030E+03, 0.480E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.41090580E+03, 0.480E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.34560850E+03, 0.480E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.30755390E+03, 0.480E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.26697000E+03, 0.480E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.23054930E+03, 0.480E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.13663938E+04, 0.480E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.11670471E+04, 0.480E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.10094418E+04, 0.480E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.90011540E+03, 0.480E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.81654950E+03, 0.480E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.62495060E+03, 0.480E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.69953820E+03, 0.480E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.52793870E+03, 0.480E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.57701070E+03, 0.480E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.53341340E+03, 0.480E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.44587010E+03, 0.480E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.46819000E+03, 0.480E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.44041700E+02, 0.490E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.27958600E+02, 0.490E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.82896730E+03, 0.490E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.43833960E+03, 0.490E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.28117370E+03, 0.490E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.18333680E+03, 0.490E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.12497980E+03, 0.490E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.92996800E+02, 0.490E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.69455800E+02, 0.490E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.52851700E+02, 0.490E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.98609990E+03, 0.490E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.70935650E+03, 0.490E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.63758320E+03, 0.490E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.48553920E+03, 0.490E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.36802750E+03, 0.490E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.29998530E+03, 0.490E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.24091040E+03, 0.490E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.19426460E+03, 0.490E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.16388153E+04, 0.490E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.12812612E+04, 0.490E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.10458401E+04, 0.490E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.99909710E+03, 0.490E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.90897530E+03, 0.490E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.71527990E+03, 0.490E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.77527360E+03, 0.490E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.60709640E+03, 0.490E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.63472630E+03, 0.490E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.65825260E+03, 0.490E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.50438020E+03, 0.490E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.50724520E+03, 0.490E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.60471830E+03, 0.490E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.51935010E+03, 0.490E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.43261670E+03, 0.490E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.38259680E+03, 0.490E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.32992500E+03, 0.490E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.28312690E+03, 0.490E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.18285696E+04, 0.490E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.15296862E+04, 0.490E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.13118922E+04, 0.490E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.11635963E+04, 0.490E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.10518917E+04, 0.490E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.79999940E+03, 0.490E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.89764510E+03, 0.490E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.67265160E+03, 0.490E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.73525250E+03, 0.490E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.67809960E+03, 0.490E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.56733030E+03, 0.490E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.59335740E+03, 0.490E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.75773970E+03, 0.490E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.41533400E+02, 0.500E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.26786200E+02, 0.500E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.70845970E+03, 0.500E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.39379910E+03, 0.500E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.25871460E+03, 0.500E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.17143670E+03, 0.500E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.11815090E+03, 0.500E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.88540800E+02, 0.500E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.66499600E+02, 0.500E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.50811000E+02, 0.500E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.84513480E+03, 0.500E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.63194340E+03, 0.500E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.57540180E+03, 0.500E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.44576230E+03, 0.500E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.34241690E+03, 0.500E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.28132550E+03, 0.500E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.22756350E+03, 0.500E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.18458450E+03, 0.500E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.13902912E+04, 0.500E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.11230616E+04, 0.500E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.92301820E+03, 0.500E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.88663180E+03, 0.500E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.80941340E+03, 0.500E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.63665610E+03, 0.500E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.69374420E+03, 0.500E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.54336290E+03, 0.500E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.57281690E+03, 0.500E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.59204640E+03, 0.500E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.45320890E+03, 0.500E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.46119710E+03, 0.500E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.54805490E+03, 0.500E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.47710340E+03, 0.500E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.40194150E+03, 0.500E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.35778710E+03, 0.500E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.31050930E+03, 0.500E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.26795320E+03, 0.500E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.15543698E+04, 0.500E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.13385665E+04, 0.500E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.11613674E+04, 0.500E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.10372812E+04, 0.500E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.94177920E+03, 0.500E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.72129060E+03, 0.500E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.80723580E+03, 0.500E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.60961520E+03, 0.500E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.66689540E+03, 0.500E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.61675220E+03, 0.500E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.51444770E+03, 0.500E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.54154900E+03, 0.500E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.68561380E+03, 0.500E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.62756770E+03, 0.500E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.37768100E+02, 0.510E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.24858300E+02, 0.510E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.58668880E+03, 0.510E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.34030300E+03, 0.510E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.22904210E+03, 0.510E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.15448510E+03, 0.510E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.10784360E+03, 0.510E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.81535800E+02, 0.510E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.61691200E+02, 0.510E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.47407300E+02, 0.510E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.70169030E+03, 0.510E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.54198260E+03, 0.510E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.49972920E+03, 0.510E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.39368990E+03, 0.510E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.30669120E+03, 0.510E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.25424180E+03, 0.510E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.20740430E+03, 0.510E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.16945330E+03, 0.510E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.11476700E+04, 0.510E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.95065430E+03, 0.510E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.78583230E+03, 0.510E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.75894060E+03, 0.510E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.69506830E+03, 0.510E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.54719810E+03, 0.510E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.59851680E+03, 0.510E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.46945690E+03, 0.510E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.49804720E+03, 0.510E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.51305850E+03, 0.510E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.39302490E+03, 0.510E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.40386210E+03, 0.510E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.47839930E+03, 0.510E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.42186160E+03, 0.510E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.35955640E+03, 0.510E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.32236080E+03, 0.510E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.28180500E+03, 0.510E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.24479020E+03, 0.510E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.12861750E+04, 0.510E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.11321713E+04, 0.510E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.99240010E+03, 0.510E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.89208770E+03, 0.510E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.81343450E+03, 0.510E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.62768490E+03, 0.510E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.70051630E+03, 0.510E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.53338040E+03, 0.510E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.58333460E+03, 0.510E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.54091250E+03, 0.510E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.45064270E+03, 0.510E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.47657830E+03, 0.510E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.59828910E+03, 0.510E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.55335920E+03, 0.510E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.49293790E+03, 0.510E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.35484100E+02, 0.520E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.23691100E+02, 0.520E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.52125110E+03, 0.520E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.30954390E+03, 0.520E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.21148980E+03, 0.520E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.14430320E+03, 0.520E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.10161240E+03, 0.520E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.77297000E+02, 0.520E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.58788100E+02, 0.520E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.45361300E+02, 0.520E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.62440760E+03, 0.520E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.49087600E+03, 0.520E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.45604000E+03, 0.520E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.36295180E+03, 0.520E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.28527790E+03, 0.520E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.23790180E+03, 0.520E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.19518610E+03, 0.520E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.16026740E+03, 0.520E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.10193121E+04, 0.520E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.85518820E+03, 0.520E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.70913030E+03, 0.520E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.68712350E+03, 0.520E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.63049010E+03, 0.520E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.49691430E+03, 0.520E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.54441560E+03, 0.520E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.42764390E+03, 0.520E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.45508360E+03, 0.520E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.46784930E+03, 0.520E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.35881670E+03, 0.520E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.37059360E+03, 0.520E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.43811020E+03, 0.520E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.38929970E+03, 0.520E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.33422340E+03, 0.520E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.30105450E+03, 0.520E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.26445160E+03, 0.520E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.23074260E+03, 0.520E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.11441913E+04, 0.520E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.10183413E+04, 0.520E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.89780430E+03, 0.520E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.81010280E+03, 0.520E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.74062110E+03, 0.520E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.57429320E+03, 0.520E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.63974650E+03, 0.520E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.48969560E+03, 0.520E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.53521890E+03, 0.520E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.49709590E+03, 0.520E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.41415120E+03, 0.520E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.43888610E+03, 0.520E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.54812670E+03, 0.520E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.50996980E+03, 0.520E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.45710570E+03, 0.520E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.42553550E+03, 0.520E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.32517100E+02, 0.530E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.22081300E+02, 0.530E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.44985120E+03, 0.530E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.27373980E+03, 0.530E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.19010940E+03, 0.530E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.13140510E+03, 0.530E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.93456200E+02, 0.530E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.71605900E+02, 0.530E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.54799000E+02, 0.530E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.42495400E+02, 0.530E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.53985360E+03, 0.530E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.43217920E+03, 0.530E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.40476310E+03, 0.530E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.32569120E+03, 0.530E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.25851210E+03, 0.530E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.21703370E+03, 0.530E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.17923060E+03, 0.530E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.14802160E+03, 0.530E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.88017410E+03, 0.530E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.74793060E+03, 0.530E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.62218410E+03, 0.530E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.60505080E+03, 0.530E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.55631660E+03, 0.530E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.43916600E+03, 0.530E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.48180770E+03, 0.530E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.37922120E+03, 0.530E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.40469290E+03, 0.530E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.41513030E+03, 0.530E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.31896420E+03, 0.530E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.33106510E+03, 0.530E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.39045420E+03, 0.530E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.34977600E+03, 0.530E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.30267430E+03, 0.530E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.27406300E+03, 0.530E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.24205560E+03, 0.530E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.21228200E+03, 0.530E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.98989210E+03, 0.530E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.89067230E+03, 0.530E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.79002570E+03, 0.530E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.71573180E+03, 0.530E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.65622760E+03, 0.530E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.51167720E+03, 0.530E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.56879090E+03, 0.530E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.43799920E+03, 0.530E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.47824810E+03, 0.530E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.44496620E+03, 0.530E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.37093440E+03, 0.530E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.39376550E+03, 0.530E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.48897090E+03, 0.530E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.45771560E+03, 0.530E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.41298520E+03, 0.530E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.38609970E+03, 0.530E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.35196670E+03, 0.530E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.29605500E+02, 0.540E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.20459400E+02, 0.540E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.38699690E+03, 0.540E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.24076890E+03, 0.540E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.16985780E+03, 0.540E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.11891780E+03, 0.540E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.85429300E+02, 0.540E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.65940300E+02, 0.540E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.50790000E+02, 0.540E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.39595100E+02, 0.540E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.46528170E+03, 0.540E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.37861340E+03, 0.540E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.35729600E+03, 0.540E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.29049850E+03, 0.540E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.23277860E+03, 0.540E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.19673740E+03, 0.540E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.16353680E+03, 0.540E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.13585920E+03, 0.540E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.75832530E+03, 0.540E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.65153920E+03, 0.540E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.54356310E+03, 0.540E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.53043120E+03, 0.540E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.48865220E+03, 0.540E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.38650670E+03, 0.540E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.42441250E+03, 0.540E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.33482590E+03, 0.540E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.35809540E+03, 0.540E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.36655970E+03, 0.540E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.28228880E+03, 0.540E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.29421380E+03, 0.540E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.34613450E+03, 0.540E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.31242650E+03, 0.540E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.27241100E+03, 0.540E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.24792750E+03, 0.540E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.22015810E+03, 0.540E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.19406990E+03, 0.540E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.85452230E+03, 0.540E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.77608590E+03, 0.540E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.69223860E+03, 0.540E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.62952300E+03, 0.540E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.57878760E+03, 0.540E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.45379980E+03, 0.540E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.50338110E+03, 0.540E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.38995320E+03, 0.540E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.42526840E+03, 0.540E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.39634680E+03, 0.540E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.33076460E+03, 0.540E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.35152850E+03, 0.540E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.43409320E+03, 0.540E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.40859520E+03, 0.540E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.37095720E+03, 0.540E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.34822390E+03, 0.540E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.31889050E+03, 0.540E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.29022230E+03, 0.540E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.10500960E+03, 0.550E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.61318400E+02, 0.550E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.32422404E+04, 0.550E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.13162189E+04, 0.550E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.75492430E+03, 0.550E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.45569600E+03, 0.550E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.29414830E+03, 0.550E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.21086720E+03, 0.550E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.15256720E+03, 0.550E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.11317640E+03, 0.550E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.37989439E+04, 0.550E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.22209652E+04, 0.550E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.18817164E+04, 0.550E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.13170056E+04, 0.550E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.93630690E+03, 0.550E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.73500610E+03, 0.550E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.56967010E+03, 0.550E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.44581710E+03, 0.550E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.68083900E+04, 0.550E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.43871669E+04, 0.550E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.34508369E+04, 0.550E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.32158544E+04, 0.550E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.28775279E+04, 0.550E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.22830674E+04, 0.550E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.23963445E+04, 0.550E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.18842824E+04, 0.550E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.18757209E+04, 0.550E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.19768609E+04, 0.550E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.15334063E+04, 0.550E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.14430004E+04, 0.550E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.17555105E+04, 0.550E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.14062206E+04, 0.550E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.11083145E+04, 0.550E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.95019750E+03, 0.550E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.79421840E+03, 0.550E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.66295560E+03, 0.550E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.75604361E+04, 0.550E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.53051627E+04, 0.550E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.42896097E+04, 0.550E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.36748556E+04, 0.550E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.32563633E+04, 0.550E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.23987520E+04, 0.550E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.27260486E+04, 0.550E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.19683066E+04, 0.550E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.21299275E+04, 0.550E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.19358392E+04, 0.550E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.16577829E+04, 0.550E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.16630447E+04, 0.550E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.22264867E+04, 0.550E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.18919207E+04, 0.550E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.15665042E+04, 0.550E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.13945709E+04, 0.550E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.12075672E+04, 0.550E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.10433955E+04, 0.550E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.93307294E+04, 0.550E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.99457900E+02, 0.560E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.59114100E+02, 0.560E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.25515260E+04, 0.560E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.11604419E+04, 0.560E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.69068520E+03, 0.560E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.42636670E+03, 0.560E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.27907420E+03, 0.560E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.20174110E+03, 0.560E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.14691740E+03, 0.560E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.10950000E+03, 0.560E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.30097233E+04, 0.560E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.19263504E+04, 0.560E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.16657662E+04, 0.560E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.12012021E+04, 0.560E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.87116470E+03, 0.560E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.69086510E+03, 0.560E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.54031600E+03, 0.560E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.42579090E+03, 0.560E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.51712978E+04, 0.560E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.36591655E+04, 0.560E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.29244395E+04, 0.560E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.27489797E+04, 0.560E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.24751427E+04, 0.560E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.19521126E+04, 0.560E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.20794950E+04, 0.560E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.16284040E+04, 0.560E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.16569384E+04, 0.560E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.17363987E+04, 0.560E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.13357319E+04, 0.560E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.12926630E+04, 0.560E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.15597012E+04, 0.560E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.12819152E+04, 0.560E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.10285424E+04, 0.560E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.88961470E+03, 0.560E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.74984750E+03, 0.560E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.63024360E+03, 0.560E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.57435673E+04, 0.560E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.43943607E+04, 0.560E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.36394735E+04, 0.560E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.31601776E+04, 0.560E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.28195147E+04, 0.560E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.20984813E+04, 0.560E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.23739131E+04, 0.560E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.17354827E+04, 0.560E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.18901371E+04, 0.560E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.17272738E+04, 0.560E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.14605858E+04, 0.560E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.14937369E+04, 0.560E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.19640913E+04, 0.560E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.17108832E+04, 0.560E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.14425135E+04, 0.560E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.12956354E+04, 0.560E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.11317221E+04, 0.560E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.98512660E+03, 0.560E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.70164917E+04, 0.560E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.57269887E+04, 0.560E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.89101800E+02, 0.570E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.53798200E+02, 0.570E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.20850661E+04, 0.570E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.99403160E+03, 0.570E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.60449150E+03, 0.570E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.37879280E+03, 0.570E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.25055770E+03, 0.570E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.18240750E+03, 0.570E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.13361230E+03, 0.570E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.10002770E+03, 0.570E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.24655965E+04, 0.570E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.16371586E+04, 0.570E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.14317496E+04, 0.570E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.10491934E+04, 0.570E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.77049240E+03, 0.570E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.61555590E+03, 0.570E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.48476910E+03, 0.570E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.38423060E+03, 0.570E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.41858968E+04, 0.570E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.30598941E+04, 0.570E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.24617619E+04, 0.570E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.23247454E+04, 0.570E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.20995853E+04, 0.570E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.16534435E+04, 0.570E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.17717653E+04, 0.570E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.13863132E+04, 0.570E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.14234023E+04, 0.570E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.14871454E+04, 0.570E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.11414078E+04, 0.570E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.11183973E+04, 0.570E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.13447968E+04, 0.570E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.11200021E+04, 0.570E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.90836700E+03, 0.570E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.79048550E+03, 0.570E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.67038430E+03, 0.570E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.56651010E+03, 0.570E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.46537454E+04, 0.570E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.36666556E+04, 0.570E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.30693037E+04, 0.570E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.26820879E+04, 0.570E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.24019326E+04, 0.570E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.17981970E+04, 0.570E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.20296163E+04, 0.570E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.14938895E+04, 0.570E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.16299126E+04, 0.570E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.14934855E+04, 0.570E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.12574297E+04, 0.570E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.12959364E+04, 0.570E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.16894085E+04, 0.570E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.14890440E+04, 0.570E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.12682622E+04, 0.570E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.11455595E+04, 0.570E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.10065104E+04, 0.570E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.88082020E+03, 0.570E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.56757434E+04, 0.570E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.47544826E+04, 0.570E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.39906172E+04, 0.570E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.44510400E+02, 0.580E+02, 0.100E+01, 0.27991000E+01, 0.91180000E+00,
  0.29308100E+02, 0.580E+02, 0.200E+01, 0.27991000E+01, 0.00000000E+00,
  0.70433450E+03, 0.580E+02, 0.300E+01, 0.27991000E+01, 0.00000000E+00,
  0.40374270E+03, 0.580E+02, 0.400E+01, 0.27991000E+01, 0.00000000E+00,
  0.27061870E+03, 0.580E+02, 0.500E+01, 0.27991000E+01, 0.00000000E+00,
  0.18221640E+03, 0.580E+02, 0.600E+01, 0.27991000E+01, 0.00000000E+00,
  0.12713550E+03, 0.580E+02, 0.700E+01, 0.27991000E+01, 0.00000000E+00,
  0.96118900E+02, 0.580E+02, 0.800E+01, 0.27991000E+01, 0.00000000E+00,
  0.72735900E+02, 0.580E+02, 0.900E+01, 0.27991000E+01, 0.00000000E+00,
  0.55904800E+02, 0.580E+02, 0.100E+02, 0.27991000E+01, 0.00000000E+00,
  0.84189860E+03, 0.580E+02, 0.110E+02, 0.27991000E+01, 0.00000000E+00,
  0.64422200E+03, 0.580E+02, 0.120E+02, 0.27991000E+01, 0.00000000E+00,
  0.59240470E+03, 0.580E+02, 0.130E+02, 0.27991000E+01, 0.00000000E+00,
  0.46526310E+03, 0.580E+02, 0.140E+02, 0.27991000E+01, 0.00000000E+00,
  0.36180150E+03, 0.580E+02, 0.150E+02, 0.27991000E+01, 0.00000000E+00,
  0.29974470E+03, 0.580E+02, 0.160E+02, 0.27991000E+01, 0.00000000E+00,
  0.24444680E+03, 0.580E+02, 0.170E+02, 0.27991000E+01, 0.00000000E+00,
  0.19971380E+03, 0.580E+02, 0.180E+02, 0.27991000E+01, 0.00000000E+00,
  0.13810183E+04, 0.580E+02, 0.190E+02, 0.27991000E+01, 0.00000000E+00,
  0.11346748E+04, 0.580E+02, 0.200E+02, 0.27991000E+01, 0.00000000E+00,
  0.93640680E+03, 0.580E+02, 0.210E+02, 0.27991000E+01, 0.00000000E+00,
  0.90333060E+03, 0.580E+02, 0.220E+02, 0.27991000E+01, 0.00000000E+00,
  0.82670470E+03, 0.580E+02, 0.230E+02, 0.27991000E+01, 0.00000000E+00,
  0.65114400E+03, 0.580E+02, 0.240E+02, 0.27991000E+01, 0.00000000E+00,
  0.71114230E+03, 0.580E+02, 0.250E+02, 0.27991000E+01, 0.00000000E+00,
  0.55801770E+03, 0.580E+02, 0.260E+02, 0.27991000E+01, 0.00000000E+00,
  0.59073870E+03, 0.580E+02, 0.270E+02, 0.27991000E+01, 0.00000000E+00,
  0.60892420E+03, 0.580E+02, 0.280E+02, 0.27991000E+01, 0.00000000E+00,
  0.46681100E+03, 0.580E+02, 0.290E+02, 0.27991000E+01, 0.00000000E+00,
  0.47833500E+03, 0.580E+02, 0.300E+02, 0.27991000E+01, 0.00000000E+00,
  0.56687830E+03, 0.580E+02, 0.310E+02, 0.27991000E+01, 0.00000000E+00,
  0.49862840E+03, 0.580E+02, 0.320E+02, 0.27991000E+01, 0.00000000E+00,
  0.42429060E+03, 0.580E+02, 0.330E+02, 0.27991000E+01, 0.00000000E+00,
  0.38016060E+03, 0.580E+02, 0.340E+02, 0.27991000E+01, 0.00000000E+00,
  0.33218840E+03, 0.580E+02, 0.350E+02, 0.27991000E+01, 0.00000000E+00,
  0.28850100E+03, 0.580E+02, 0.360E+02, 0.27991000E+01, 0.00000000E+00,
  0.15470780E+04, 0.580E+02, 0.370E+02, 0.27991000E+01, 0.00000000E+00,
  0.13520803E+04, 0.580E+02, 0.380E+02, 0.27991000E+01, 0.00000000E+00,
  0.11820124E+04, 0.580E+02, 0.390E+02, 0.27991000E+01, 0.00000000E+00,
  0.10609721E+04, 0.580E+02, 0.400E+02, 0.27991000E+01, 0.00000000E+00,
  0.96662010E+03, 0.580E+02, 0.410E+02, 0.27991000E+01, 0.00000000E+00,
  0.74511760E+03, 0.580E+02, 0.420E+02, 0.27991000E+01, 0.00000000E+00,
  0.83183600E+03, 0.580E+02, 0.430E+02, 0.27991000E+01, 0.00000000E+00,
  0.63266390E+03, 0.580E+02, 0.440E+02, 0.27991000E+01, 0.00000000E+00,
  0.69156460E+03, 0.580E+02, 0.450E+02, 0.27991000E+01, 0.00000000E+00,
  0.64096110E+03, 0.580E+02, 0.460E+02, 0.27991000E+01, 0.00000000E+00,
  0.53459930E+03, 0.580E+02, 0.470E+02, 0.27991000E+01, 0.00000000E+00,
  0.56439100E+03, 0.580E+02, 0.480E+02, 0.27991000E+01, 0.00000000E+00,
  0.70950090E+03, 0.580E+02, 0.490E+02, 0.27991000E+01, 0.00000000E+00,
  0.65467230E+03, 0.580E+02, 0.500E+02, 0.27991000E+01, 0.00000000E+00,
  0.58216180E+03, 0.580E+02, 0.510E+02, 0.27991000E+01, 0.00000000E+00,
  0.53941670E+03, 0.580E+02, 0.520E+02, 0.27991000E+01, 0.00000000E+00,
  0.48703330E+03, 0.580E+02, 0.530E+02, 0.27991000E+01, 0.00000000E+00,
  0.43728340E+03, 0.580E+02, 0.540E+02, 0.27991000E+01, 0.00000000E+00,
  0.18844554E+04, 0.580E+02, 0.550E+02, 0.27991000E+01, 0.00000000E+00,
  0.17247415E+04, 0.580E+02, 0.560E+02, 0.27991000E+01, 0.00000000E+00,
  0.15122504E+04, 0.580E+02, 0.570E+02, 0.27991000E+01, 0.00000000E+00,
  0.68803530E+03, 0.580E+02, 0.580E+02, 0.27991000E+01, 0.27991000E+01,
  0.88687700E+02, 0.590E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.53152300E+02, 0.590E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.22103168E+04, 0.590E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.10189540E+04, 0.590E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.61076150E+03, 0.590E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.37910380E+03, 0.590E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.24926330E+03, 0.590E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.18083830E+03, 0.590E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.13215840E+03, 0.590E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.98822000E+02, 0.590E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.26090440E+04, 0.590E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.16875419E+04, 0.590E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.14644446E+04, 0.590E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.10615213E+04, 0.590E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.77317210E+03, 0.590E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.61486520E+03, 0.590E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.48225090E+03, 0.590E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.38105030E+03, 0.590E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.44737784E+04, 0.590E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.31902086E+04, 0.590E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.25547353E+04, 0.590E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.24050561E+04, 0.590E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.21676325E+04, 0.590E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.17091137E+04, 0.590E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.18237858E+04, 0.590E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.14281039E+04, 0.590E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.14570358E+04, 0.590E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.15254141E+04, 0.590E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.11729549E+04, 0.590E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.11394352E+04, 0.590E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.13728649E+04, 0.590E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.11331627E+04, 0.590E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.91252630E+03, 0.590E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.79102140E+03, 0.590E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.66833280E+03, 0.590E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.56301560E+03, 0.590E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.49710778E+04, 0.590E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.38289626E+04, 0.590E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.31814405E+04, 0.590E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.27679894E+04, 0.590E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.24726905E+04, 0.590E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.18440715E+04, 0.590E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.20845975E+04, 0.590E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.15276056E+04, 0.590E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.16644640E+04, 0.590E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.15224806E+04, 0.590E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.12860441E+04, 0.590E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.13182791E+04, 0.590E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.17282162E+04, 0.590E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.15110459E+04, 0.590E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.12783406E+04, 0.590E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.11504200E+04, 0.590E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.10070198E+04, 0.590E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.87837980E+03, 0.590E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.60738935E+04, 0.590E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.49833126E+04, 0.590E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.41503203E+04, 0.590E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.15271461E+04, 0.590E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.43422386E+04, 0.590E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.85408000E+02, 0.600E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.51295200E+02, 0.600E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.20915068E+04, 0.600E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.97461670E+03, 0.600E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.58618960E+03, 0.600E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.36465190E+03, 0.600E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.24011390E+03, 0.600E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.17436780E+03, 0.600E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.12753080E+03, 0.600E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.95420200E+02, 0.600E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.24706020E+04, 0.600E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.16117831E+04, 0.600E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.14013191E+04, 0.600E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.10185098E+04, 0.600E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.74324070E+03, 0.600E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.59167520E+03, 0.600E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.46450620E+03, 0.600E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.36731630E+03, 0.600E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.42163998E+04, 0.600E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.30363662E+04, 0.600E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.24350889E+04, 0.600E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.22942857E+04, 0.600E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.20689809E+04, 0.600E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.16306018E+04, 0.600E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.17421942E+04, 0.600E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.13638456E+04, 0.600E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.13940822E+04, 0.600E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.14587399E+04, 0.600E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.11209931E+04, 0.600E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.10915722E+04, 0.600E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.13142306E+04, 0.600E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.10872533E+04, 0.600E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.87700660E+03, 0.600E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.76089490E+03, 0.600E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.64343050E+03, 0.600E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.54243830E+03, 0.600E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.46850846E+04, 0.600E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.36420492E+04, 0.600E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.30329183E+04, 0.600E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.26420526E+04, 0.600E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.23616974E+04, 0.600E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.17631139E+04, 0.600E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.19921534E+04, 0.600E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.14616458E+04, 0.600E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.15933696E+04, 0.600E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.14581671E+04, 0.600E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.12304969E+04, 0.600E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.12633482E+04, 0.600E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.16535039E+04, 0.600E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.14488711E+04, 0.600E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.12277455E+04, 0.600E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.11058143E+04, 0.600E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.96879470E+03, 0.600E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.84567030E+03, 0.600E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.57167999E+04, 0.600E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.47334185E+04, 0.600E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.39519956E+04, 0.600E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.14659695E+04, 0.600E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.41259023E+04, 0.600E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.39244211E+04, 0.600E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.83331000E+02, 0.610E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.50074800E+02, 0.610E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.20312740E+04, 0.610E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.94912550E+03, 0.610E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.57141130E+03, 0.610E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.35567120E+03, 0.610E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.23429130E+03, 0.610E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.17018170E+03, 0.610E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.12449460E+03, 0.610E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.93163500E+02, 0.610E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.23998207E+04, 0.610E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.15689885E+04, 0.610E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.13648494E+04, 0.610E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.99275070E+03, 0.610E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.72481970E+03, 0.610E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.57716960E+03, 0.610E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.45323130E+03, 0.610E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.35847210E+03, 0.610E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.40920575E+04, 0.610E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.29529794E+04, 0.610E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.23691244E+04, 0.610E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.22326503E+04, 0.610E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.20137194E+04, 0.610E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.15868512E+04, 0.610E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.16960441E+04, 0.610E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.13276064E+04, 0.610E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.13577395E+04, 0.610E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.14205045E+04, 0.610E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.10914214E+04, 0.610E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.10634898E+04, 0.610E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.12801762E+04, 0.610E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.10597536E+04, 0.610E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.85521770E+03, 0.610E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.74216490E+03, 0.610E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.62773420E+03, 0.610E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.52930700E+03, 0.610E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.45470720E+04, 0.610E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.35414930E+04, 0.610E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.29509303E+04, 0.610E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.25714964E+04, 0.610E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.22990481E+04, 0.610E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.17168038E+04, 0.610E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.19396215E+04, 0.610E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.14235531E+04, 0.610E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.15520522E+04, 0.610E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.14205469E+04, 0.610E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.11984194E+04, 0.610E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.12309598E+04, 0.610E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.16104142E+04, 0.610E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.14119588E+04, 0.610E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.11970157E+04, 0.610E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.10783854E+04, 0.610E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.94498140E+03, 0.610E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.82504730E+03, 0.610E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.55474900E+04, 0.610E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.46012171E+04, 0.610E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.38440367E+04, 0.610E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.14290690E+04, 0.610E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.40113635E+04, 0.610E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.38161118E+04, 0.610E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.37109375E+04, 0.610E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.81412300E+02, 0.620E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.48940600E+02, 0.620E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.19766955E+04, 0.620E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.92581580E+03, 0.620E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.55783800E+03, 0.620E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.34739210E+03, 0.620E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.22890650E+03, 0.620E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.16630040E+03, 0.620E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.12167270E+03, 0.620E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.91061400E+02, 0.620E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.23356474E+04, 0.620E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.15299120E+04, 0.620E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.13314786E+04, 0.620E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.96910260E+03, 0.620E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.70786040E+03, 0.620E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.56378900E+03, 0.620E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.44280950E+03, 0.620E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.35028120E+03, 0.620E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.39796309E+04, 0.620E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.28770680E+04, 0.620E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.23089962E+04, 0.620E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.21764184E+04, 0.620E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.19632723E+04, 0.620E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.15469195E+04, 0.620E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.16538773E+04, 0.620E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.12944951E+04, 0.620E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.13244770E+04, 0.620E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.13855313E+04, 0.620E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.10643798E+04, 0.620E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.10377490E+04, 0.620E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.12489915E+04, 0.620E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.10345024E+04, 0.620E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.83516220E+03, 0.620E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.72489870E+03, 0.620E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.61324050E+03, 0.620E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.51716170E+03, 0.620E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.44222696E+04, 0.620E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.34499906E+04, 0.620E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.28761716E+04, 0.620E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.25070805E+04, 0.620E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.22418085E+04, 0.620E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.16744360E+04, 0.620E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.18915883E+04, 0.620E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.13886668E+04, 0.620E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.15142016E+04, 0.620E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.13860622E+04, 0.620E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.11690360E+04, 0.620E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.12012473E+04, 0.620E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.15709643E+04, 0.620E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.13780830E+04, 0.620E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.11687524E+04, 0.620E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.10531255E+04, 0.620E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.92301940E+03, 0.620E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.80600020E+03, 0.620E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.53944846E+04, 0.620E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.44810449E+04, 0.620E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.37456921E+04, 0.620E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.13951471E+04, 0.620E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.39071923E+04, 0.620E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.37175407E+04, 0.620E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.36152067E+04, 0.620E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.35220508E+04, 0.620E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.79713800E+02, 0.630E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.47936500E+02, 0.630E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.19280810E+04, 0.630E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.90511010E+03, 0.630E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.54580150E+03, 0.630E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.34005800E+03, 0.630E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.22413830E+03, 0.630E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.16286380E+03, 0.630E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.11917340E+03, 0.630E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.89198800E+02, 0.630E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.22784898E+04, 0.630E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.14951792E+04, 0.630E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.13018438E+04, 0.630E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.94812880E+03, 0.630E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.69283380E+03, 0.630E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.55193900E+03, 0.630E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.43358310E+03, 0.630E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.34303070E+03, 0.630E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.38794729E+04, 0.630E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.28095233E+04, 0.630E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.22555157E+04, 0.630E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.21264190E+04, 0.630E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.19184254E+04, 0.630E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.15114156E+04, 0.630E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.16164023E+04, 0.630E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.12650643E+04, 0.630E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.12949313E+04, 0.630E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.13544595E+04, 0.630E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.10403490E+04, 0.630E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.10148959E+04, 0.630E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.12213030E+04, 0.630E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.10121053E+04, 0.630E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.81738880E+03, 0.630E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.70960390E+03, 0.630E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.60040640E+03, 0.630E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.50640980E+03, 0.630E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.43110961E+04, 0.630E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.33685646E+04, 0.630E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.28096885E+04, 0.630E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.24498188E+04, 0.630E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.21909387E+04, 0.630E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.16367956E+04, 0.630E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.18489097E+04, 0.630E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.13576810E+04, 0.630E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.14805878E+04, 0.630E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.13554425E+04, 0.630E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.11429352E+04, 0.630E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.11748699E+04, 0.630E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.15359254E+04, 0.630E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.13480216E+04, 0.630E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.11436919E+04, 0.630E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.10307380E+04, 0.630E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.90356300E+03, 0.630E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.78913200E+03, 0.630E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.52582068E+04, 0.630E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.43740826E+04, 0.630E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.36582120E+04, 0.630E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.13650615E+04, 0.630E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.38144921E+04, 0.630E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.36298268E+04, 0.630E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.35300228E+04, 0.630E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.34391601E+04, 0.630E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.33583122E+04, 0.630E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.64188000E+02, 0.640E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.39578600E+02, 0.640E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.14077335E+04, 0.640E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.68992870E+03, 0.640E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.42648970E+03, 0.640E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.27091830E+03, 0.640E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.18125810E+03, 0.640E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.13314380E+03, 0.640E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.98357300E+02, 0.640E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.74191200E+02, 0.640E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.16673895E+04, 0.640E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.11308198E+04, 0.640E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.99679240E+03, 0.640E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.73902000E+03, 0.640E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.54836330E+03, 0.640E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.44123030E+03, 0.640E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.35003690E+03, 0.640E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.27935150E+03, 0.640E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.28176333E+04, 0.640E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.20945326E+04, 0.640E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.16917052E+04, 0.640E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.16028927E+04, 0.640E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.14507174E+04, 0.640E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.11427015E+04, 0.640E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.12280426E+04, 0.640E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.96156000E+03, 0.640E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.99206730E+03, 0.640E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.10341932E+04, 0.640E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.79387630E+03, 0.640E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.78351140E+03, 0.640E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.93936520E+03, 0.640E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.78963690E+03, 0.640E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.64598490E+03, 0.640E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.56529910E+03, 0.640E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.48231720E+03, 0.640E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.40998030E+03, 0.640E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.31359242E+04, 0.640E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.25077589E+04, 0.640E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.21132076E+04, 0.640E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.18544837E+04, 0.640E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.16654372E+04, 0.640E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.12530730E+04, 0.640E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.14116759E+04, 0.640E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.10450617E+04, 0.640E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.11404525E+04, 0.640E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.10471279E+04, 0.640E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.88053130E+03, 0.640E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.91107960E+03, 0.640E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.11799720E+04, 0.640E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.10480976E+04, 0.640E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.89951620E+03, 0.640E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.81630470E+03, 0.640E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.72098470E+03, 0.640E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.63421630E+03, 0.640E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.38238426E+04, 0.640E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.32436561E+04, 0.640E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.27405478E+04, 0.640E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.10709597E+04, 0.640E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.28381357E+04, 0.640E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.27056826E+04, 0.640E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.26326657E+04, 0.640E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.25660607E+04, 0.640E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.25068352E+04, 0.640E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.18916719E+04, 0.640E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.70179400E+02, 0.650E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.42367900E+02, 0.650E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.18023852E+04, 0.650E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.80848660E+03, 0.650E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.48279770E+03, 0.650E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.29984690E+03, 0.650E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.19762340E+03, 0.650E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.14377540E+03, 0.650E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.10539700E+03, 0.650E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.79048400E+02, 0.650E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.21240831E+04, 0.650E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.13433651E+04, 0.650E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.11621560E+04, 0.650E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.83917760E+03, 0.650E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.61083180E+03, 0.650E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.48623190E+03, 0.650E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.38195840E+03, 0.650E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.30241490E+03, 0.650E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.36876305E+04, 0.650E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.25641443E+04, 0.650E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.20454927E+04, 0.650E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.19228302E+04, 0.650E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.17309890E+04, 0.650E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.13680049E+04, 0.650E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.14541614E+04, 0.650E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.11408713E+04, 0.650E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.11579011E+04, 0.650E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.12132014E+04, 0.650E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.93575440E+03, 0.650E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.90359910E+03, 0.650E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.10900939E+04, 0.650E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.89646510E+03, 0.650E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.72120420E+03, 0.650E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.62544800E+03, 0.650E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.52893810E+03, 0.650E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.44620840E+03, 0.650E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.40985678E+04, 0.650E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.30839899E+04, 0.650E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.25485911E+04, 0.650E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.22114907E+04, 0.650E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.19735648E+04, 0.650E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.14705265E+04, 0.650E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.16631347E+04, 0.650E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.12173511E+04, 0.650E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.13235223E+04, 0.650E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.12096847E+04, 0.650E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.10256835E+04, 0.650E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.10465789E+04, 0.650E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.13756067E+04, 0.650E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.11975597E+04, 0.650E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.10112975E+04, 0.650E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.90991270E+03, 0.650E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.79669950E+03, 0.650E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.69543500E+03, 0.650E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.50226967E+04, 0.650E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.40300910E+04, 0.650E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.33357435E+04, 0.650E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.12096287E+04, 0.650E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.35071716E+04, 0.650E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.33250797E+04, 0.650E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.32313241E+04, 0.650E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.31461740E+04, 0.650E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.30703853E+04, 0.650E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.22762532E+04, 0.650E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.28516677E+04, 0.650E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.67958000E+02, 0.660E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.41162200E+02, 0.660E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.17207353E+04, 0.660E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.77577180E+03, 0.660E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.46524390E+03, 0.660E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.28984550E+03, 0.660E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.19145500E+03, 0.660E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.13949370E+03, 0.660E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.10238110E+03, 0.660E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.76855700E+02, 0.660E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.20278568E+04, 0.660E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.12872471E+04, 0.660E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.11160341E+04, 0.660E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.80833220E+03, 0.660E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.58989410E+03, 0.660E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.47029770E+03, 0.660E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.36998330E+03, 0.660E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.29329050E+03, 0.660E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.35269705E+04, 0.660E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.24517734E+04, 0.660E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.19574581E+04, 0.660E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.18415883E+04, 0.660E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.16587019E+04, 0.660E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.13107538E+04, 0.660E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.13944853E+04, 0.660E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.10940016E+04, 0.660E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.11118174E+04, 0.660E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.11642755E+04, 0.660E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.89783730E+03, 0.660E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.86875770E+03, 0.660E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.10475640E+04, 0.660E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.86358600E+03, 0.660E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.69627600E+03, 0.660E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.60460480E+03, 0.660E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.51197160E+03, 0.660E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.43238930E+03, 0.660E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.39216962E+04, 0.660E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.29485688E+04, 0.660E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.24401762E+04, 0.660E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.21194908E+04, 0.660E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.18927858E+04, 0.660E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.14117363E+04, 0.660E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.15962074E+04, 0.660E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.11696785E+04, 0.660E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.12718937E+04, 0.660E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.11630374E+04, 0.660E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.98556970E+03, 0.660E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.10068382E+04, 0.660E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.13215257E+04, 0.660E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.11527975E+04, 0.660E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.97544350E+03, 0.660E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.87867530E+03, 0.660E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.77029080E+03, 0.660E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.67313940E+03, 0.660E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.48123323E+04, 0.660E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.38522949E+04, 0.660E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.31924039E+04, 0.660E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.11661633E+04, 0.660E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.33558765E+04, 0.660E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.31799629E+04, 0.660E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.30904072E+04, 0.660E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.30090778E+04, 0.660E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.29367065E+04, 0.660E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.21810675E+04, 0.660E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.27299739E+04, 0.660E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.26173310E+04, 0.660E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.72220300E+02, 0.670E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.43571100E+02, 0.670E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.17049679E+04, 0.670E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.81136880E+03, 0.670E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.49188750E+03, 0.670E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.30751980E+03, 0.670E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.20315540E+03, 0.670E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.14783550E+03, 0.670E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.10830760E+03, 0.670E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.81141600E+02, 0.670E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.20163392E+04, 0.670E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.13374783E+04, 0.670E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.11679358E+04, 0.670E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.85407400E+03, 0.670E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.62593940E+03, 0.670E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.49945760E+03, 0.670E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.39293850E+03, 0.670E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.31124870E+03, 0.670E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.34195160E+04, 0.670E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.25014164E+04, 0.670E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.20120352E+04, 0.670E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.18992044E+04, 0.670E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.17148635E+04, 0.670E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.13502932E+04, 0.670E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.14466020E+04, 0.670E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.11317710E+04, 0.670E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.11614905E+04, 0.670E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.12139348E+04, 0.670E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.93167930E+03, 0.670E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.91200820E+03, 0.670E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.10964450E+04, 0.670E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.91172230E+03, 0.670E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.73821290E+03, 0.670E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.64174520E+03, 0.670E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.54371620E+03, 0.670E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.45912050E+03, 0.670E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.38008304E+04, 0.670E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.29970212E+04, 0.670E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.25073572E+04, 0.670E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.21900272E+04, 0.670E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.19605194E+04, 0.670E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.14668017E+04, 0.670E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.16559466E+04, 0.670E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.12180651E+04, 0.670E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.13291426E+04, 0.670E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.12176582E+04, 0.670E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.10253902E+04, 0.670E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.10563718E+04, 0.670E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.13778901E+04, 0.670E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.12131043E+04, 0.670E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.10318071E+04, 0.670E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.93112390E+03, 0.670E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.81732200E+03, 0.670E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.71464770E+03, 0.670E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.46328428E+04, 0.670E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.38855093E+04, 0.670E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.32599132E+04, 0.670E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.12305989E+04, 0.670E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.33915411E+04, 0.670E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.32298168E+04, 0.670E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.31416098E+04, 0.670E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.30612537E+04, 0.670E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.29897660E+04, 0.670E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.22379026E+04, 0.670E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.27243602E+04, 0.670E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.26065136E+04, 0.670E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.26641668E+04, 0.670E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.70715400E+02, 0.680E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.42665800E+02, 0.680E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.16647700E+04, 0.680E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.79368770E+03, 0.680E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.48143850E+03, 0.680E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.30106920E+03, 0.680E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.19891850E+03, 0.680E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.14475870E+03, 0.680E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.10605520E+03, 0.680E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.79453900E+02, 0.680E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.19689928E+04, 0.680E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.13079814E+04, 0.680E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.11425656E+04, 0.680E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.83589690E+03, 0.680E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.61278090E+03, 0.680E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.48901070E+03, 0.680E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.38474960E+03, 0.680E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.30477480E+03, 0.680E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.33372227E+04, 0.680E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.24446758E+04, 0.680E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.19669050E+04, 0.680E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.18568743E+04, 0.680E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.16768129E+04, 0.680E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.13201912E+04, 0.680E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.14147048E+04, 0.680E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.11067246E+04, 0.680E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.11361897E+04, 0.680E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.11873873E+04, 0.680E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.91117070E+03, 0.680E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.89233320E+03, 0.680E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.10726768E+04, 0.680E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.89230170E+03, 0.680E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.72266540E+03, 0.680E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.62829340E+03, 0.680E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.53236410E+03, 0.680E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.44955920E+03, 0.680E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.37094297E+04, 0.680E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.29287164E+04, 0.680E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.24511775E+04, 0.680E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.21414202E+04, 0.680E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.19172203E+04, 0.680E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.14346130E+04, 0.680E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.16195186E+04, 0.680E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.11914716E+04, 0.680E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.13002637E+04, 0.680E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.11912962E+04, 0.680E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.10029797E+04, 0.680E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.10336009E+04, 0.680E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.13478497E+04, 0.680E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.11871040E+04, 0.680E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.10099583E+04, 0.680E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.91151370E+03, 0.680E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.80019180E+03, 0.680E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.69972310E+03, 0.680E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.45209645E+04, 0.680E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.37960924E+04, 0.680E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.31862327E+04, 0.680E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.12044185E+04, 0.680E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.33138879E+04, 0.680E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.31561992E+04, 0.680E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.30700842E+04, 0.680E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.29916275E+04, 0.680E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.29218310E+04, 0.680E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.21877803E+04, 0.680E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.26611461E+04, 0.680E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.25461249E+04, 0.680E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.26039653E+04, 0.680E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.25451713E+04, 0.680E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.69379100E+02, 0.690E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.41872700E+02, 0.690E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.16270951E+04, 0.690E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.77746020E+03, 0.690E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.47198600E+03, 0.690E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.29530140E+03, 0.690E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.19516300E+03, 0.690E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.14204780E+03, 0.690E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.10408000E+03, 0.690E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.77978800E+02, 0.690E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.19246593E+04, 0.690E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.12807911E+04, 0.690E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.11193391E+04, 0.690E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.81942800E+03, 0.690E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.60097010E+03, 0.690E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.47969090E+03, 0.690E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.37748730E+03, 0.690E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.29906220E+03, 0.690E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.32599368E+04, 0.690E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.23919954E+04, 0.690E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.19251263E+04, 0.690E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.18177881E+04, 0.690E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.16417354E+04, 0.690E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.12924384E+04, 0.690E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.13853712E+04, 0.690E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.10836957E+04, 0.690E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.11130259E+04, 0.690E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.11630369E+04, 0.690E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.89235160E+03, 0.690E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.87439610E+03, 0.690E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.10509705E+04, 0.690E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.87471320E+03, 0.690E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.70869500E+03, 0.690E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.61626580E+03, 0.690E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.52226550E+03, 0.690E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.44109320E+03, 0.690E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.36236511E+04, 0.690E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.28652613E+04, 0.690E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.23992487E+04, 0.690E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.20966400E+04, 0.690E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.18774174E+04, 0.690E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.14051352E+04, 0.690E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.15861100E+04, 0.690E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.11671878E+04, 0.690E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.12739026E+04, 0.690E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.11672707E+04, 0.690E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.98252100E+03, 0.690E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.10128904E+04, 0.690E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.13203887E+04, 0.690E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.11634988E+04, 0.690E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.99025880E+03, 0.690E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.89390800E+03, 0.690E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.78488410E+03, 0.690E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.68644520E+03, 0.690E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.44159694E+04, 0.690E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.37128812E+04, 0.690E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.31180001E+04, 0.690E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.11807776E+04, 0.690E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.32417266E+04, 0.690E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.30878489E+04, 0.690E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.30036922E+04, 0.690E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.29270118E+04, 0.690E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.28587977E+04, 0.690E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.21415264E+04, 0.690E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.26023122E+04, 0.690E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.24899643E+04, 0.690E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.25481802E+04, 0.690E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.24906989E+04, 0.690E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.24374539E+04, 0.690E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.68494900E+02, 0.700E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.41286600E+02, 0.700E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.16127581E+04, 0.700E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.76939830E+03, 0.700E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.46660990E+03, 0.700E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.29168170E+03, 0.700E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.19263240E+03, 0.700E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.14013000E+03, 0.700E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.10262510E+03, 0.700E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.76858100E+02, 0.700E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.19075332E+04, 0.700E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.12678866E+04, 0.700E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.11075215E+04, 0.700E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.81018450E+03, 0.700E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.59379110E+03, 0.700E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.47373900E+03, 0.700E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.37262670E+03, 0.700E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.29508360E+03, 0.700E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.32317117E+04, 0.700E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.23690958E+04, 0.700E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.19062802E+04, 0.700E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.17996377E+04, 0.700E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.16251430E+04, 0.700E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.12793493E+04, 0.700E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.13711198E+04, 0.700E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.10724959E+04, 0.700E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.11012182E+04, 0.700E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.11508553E+04, 0.700E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.88299190E+03, 0.700E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.86485460E+03, 0.700E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.10396601E+04, 0.700E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.86479960E+03, 0.700E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.70027180E+03, 0.700E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.60871740E+03, 0.700E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.51566490E+03, 0.700E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.43535350E+03, 0.700E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.35920465E+04, 0.700E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.28379423E+04, 0.700E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.23754679E+04, 0.700E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.20753417E+04, 0.700E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.18580353E+04, 0.700E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.13902059E+04, 0.700E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.15694426E+04, 0.700E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.11545209E+04, 0.700E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.12600764E+04, 0.700E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.11544639E+04, 0.700E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.97180930E+03, 0.700E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.10016214E+04, 0.700E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.13062023E+04, 0.700E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.11504571E+04, 0.700E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.97868710E+03, 0.700E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.88319190E+03, 0.700E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.77520910E+03, 0.700E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.67775440E+03, 0.700E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.43774766E+04, 0.700E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.36779606E+04, 0.700E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.30875154E+04, 0.700E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.11670799E+04, 0.700E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.32108489E+04, 0.700E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.30582277E+04, 0.700E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.29748238E+04, 0.700E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.28988349E+04, 0.700E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.28312344E+04, 0.700E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.21199794E+04, 0.700E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.25778005E+04, 0.700E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.24663583E+04, 0.700E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.25233630E+04, 0.700E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.24664143E+04, 0.700E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.24136514E+04, 0.700E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.23901227E+04, 0.700E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.58651900E+02, 0.710E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.35951600E+02, 0.710E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.12947583E+04, 0.710E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.63458810E+03, 0.710E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.39146520E+03, 0.710E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.24795570E+03, 0.710E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.16541840E+03, 0.710E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.12121480E+03, 0.710E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.89340500E+02, 0.710E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.67257500E+02, 0.710E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.15332675E+04, 0.710E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.10401825E+04, 0.710E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.91638240E+03, 0.710E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.67855410E+03, 0.710E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.50255170E+03, 0.710E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.40367180E+03, 0.710E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.31962860E+03, 0.710E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.25459790E+03, 0.710E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.25921299E+04, 0.710E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.19255453E+04, 0.710E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.15553939E+04, 0.710E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.14734091E+04, 0.710E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.13334027E+04, 0.710E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.10496142E+04, 0.710E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.11285309E+04, 0.710E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.88302170E+03, 0.710E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.91141500E+03, 0.710E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.95032780E+03, 0.710E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.72889260E+03, 0.710E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.71952410E+03, 0.710E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.86291390E+03, 0.710E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.72475130E+03, 0.710E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.59205870E+03, 0.710E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.51745760E+03, 0.710E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.44084280E+03, 0.710E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.37414020E+03, 0.710E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.28847585E+04, 0.710E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.23048558E+04, 0.710E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.19421387E+04, 0.710E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.17040440E+04, 0.710E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.15299721E+04, 0.710E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.11501604E+04, 0.710E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.12962701E+04, 0.710E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.95869920E+03, 0.710E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.10467597E+04, 0.710E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.96091280E+03, 0.710E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.80744060E+03, 0.710E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.83583100E+03, 0.710E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.10833008E+04, 0.710E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.96184020E+03, 0.710E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.82469640E+03, 0.710E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.74775790E+03, 0.710E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.65970490E+03, 0.710E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.57959110E+03, 0.710E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.35195236E+04, 0.710E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.29806436E+04, 0.710E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.25182192E+04, 0.710E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.98175310E+03, 0.710E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.26089193E+04, 0.710E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.24861931E+04, 0.710E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.24191164E+04, 0.710E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.23579439E+04, 0.710E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.23035540E+04, 0.710E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.17376565E+04, 0.710E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.20919380E+04, 0.710E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.20059243E+04, 0.710E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.20565310E+04, 0.710E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.20105203E+04, 0.710E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.19680474E+04, 0.710E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.19483102E+04, 0.710E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.15974796E+04, 0.710E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.58850400E+02, 0.720E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.36574900E+02, 0.720E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.11772268E+04, 0.720E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.60758590E+03, 0.720E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.38350840E+03, 0.720E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.24668260E+03, 0.720E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.16624720E+03, 0.720E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.12259130E+03, 0.720E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.90778400E+02, 0.720E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.68550500E+02, 0.720E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.13981254E+04, 0.720E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.98752390E+03, 0.720E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.88079020E+03, 0.720E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.66333140E+03, 0.720E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.49770150E+03, 0.720E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.40279470E+03, 0.720E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.32111450E+03, 0.720E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.25716510E+03, 0.720E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.23300562E+04, 0.720E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.17971024E+04, 0.720E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.14619589E+04, 0.720E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.13919848E+04, 0.720E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.12638660E+04, 0.720E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.99362820E+03, 0.720E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.10747287E+04, 0.720E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.84045370E+03, 0.720E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.87543360E+03, 0.720E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.90984070E+03, 0.720E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.69642830E+03, 0.720E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.69621350E+03, 0.720E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.83232490E+03, 0.720E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.70869710E+03, 0.720E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.58542500E+03, 0.720E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.51487840E+03, 0.720E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.44133770E+03, 0.720E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.37652870E+03, 0.720E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.25964033E+04, 0.720E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.21464040E+04, 0.720E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.18297515E+04, 0.720E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.16164737E+04, 0.720E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.14572492E+04, 0.720E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.11025669E+04, 0.720E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.12395201E+04, 0.720E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.92341980E+03, 0.720E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.10097527E+04, 0.720E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.92946760E+03, 0.720E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.77779950E+03, 0.720E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.81120400E+03, 0.720E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.10422993E+04, 0.720E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.93663610E+03, 0.720E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.81148690E+03, 0.720E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.74006690E+03, 0.720E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.65681710E+03, 0.720E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.58013770E+03, 0.720E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.31606446E+04, 0.720E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.27609094E+04, 0.720E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.23609186E+04, 0.720E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.96347730E+03, 0.720E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.24240491E+04, 0.720E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.23170514E+04, 0.720E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.22560584E+04, 0.720E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.22002906E+04, 0.720E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.21507417E+04, 0.720E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.16406567E+04, 0.720E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.19309949E+04, 0.720E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.18529581E+04, 0.720E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.19265925E+04, 0.720E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.18843048E+04, 0.720E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.18455050E+04, 0.720E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.18262149E+04, 0.720E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.15072441E+04, 0.720E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.14412394E+04, 0.720E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.54401500E+02, 0.730E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.34283400E+02, 0.730E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.10273577E+04, 0.730E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.54443550E+03, 0.730E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.34862850E+03, 0.730E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.22671590E+03, 0.730E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.15406960E+03, 0.730E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.11429670E+03, 0.730E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.85081400E+02, 0.730E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.64523800E+02, 0.730E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.12220335E+04, 0.730E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.88084690E+03, 0.730E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.79141350E+03, 0.730E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.60213470E+03, 0.730E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.45569700E+03, 0.730E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.37087230E+03, 0.730E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.29728390E+03, 0.730E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.23922910E+03, 0.730E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.20266698E+04, 0.730E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.15894883E+04, 0.730E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.12977826E+04, 0.730E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.12395033E+04, 0.730E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.11275812E+04, 0.730E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.88658800E+03, 0.730E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.96151940E+03, 0.730E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.75231040E+03, 0.730E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.78703270E+03, 0.730E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.81634550E+03, 0.730E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.62484080E+03, 0.730E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.62867410E+03, 0.730E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.74997760E+03, 0.730E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.64373010E+03, 0.730E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.53560150E+03, 0.730E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.47316850E+03, 0.730E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.40746910E+03, 0.730E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.34913050E+03, 0.730E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.22608400E+04, 0.730E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.18969799E+04, 0.730E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.16272670E+04, 0.730E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.14431973E+04, 0.730E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.13043213E+04, 0.730E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.99116570E+03, 0.730E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.11124511E+04, 0.730E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.83281910E+03, 0.730E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.91084260E+03, 0.730E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.83983510E+03, 0.730E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.70192840E+03, 0.730E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.73456590E+03, 0.730E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.93877020E+03, 0.730E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.84925790E+03, 0.730E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.74051010E+03, 0.730E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.67794300E+03, 0.730E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.60419180E+03, 0.730E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.53577730E+03, 0.730E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.27516509E+04, 0.730E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.24344207E+04, 0.730E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.20948531E+04, 0.730E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.87810980E+03, 0.730E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.21417667E+04, 0.730E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.20496125E+04, 0.730E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.19962879E+04, 0.730E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.19474669E+04, 0.730E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.19041085E+04, 0.730E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.14623131E+04, 0.730E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.17026705E+04, 0.730E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.16355752E+04, 0.730E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.17084912E+04, 0.730E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.16713110E+04, 0.730E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.16373225E+04, 0.730E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.16197710E+04, 0.730E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.13428697E+04, 0.730E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.12925836E+04, 0.730E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.11638241E+04, 0.730E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.46481300E+02, 0.740E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.29820600E+02, 0.740E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.84241230E+03, 0.740E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.45198610E+03, 0.740E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.29290150E+03, 0.740E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.19259840E+03, 0.740E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.13214100E+03, 0.740E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.98766600E+02, 0.740E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.74030900E+02, 0.740E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.56476700E+02, 0.740E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.10029508E+04, 0.740E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.72933520E+03, 0.740E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.65874710E+03, 0.740E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.50518900E+03, 0.740E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.38541090E+03, 0.740E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.31556320E+03, 0.740E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.25452870E+03, 0.740E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.20602860E+03, 0.740E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.16644321E+04, 0.740E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.13117641E+04, 0.740E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.10728050E+04, 0.740E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.10269214E+04, 0.740E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.93538590E+03, 0.740E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.73650630E+03, 0.740E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.79917580E+03, 0.740E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.62633800E+03, 0.740E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.65622600E+03, 0.740E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.67963140E+03, 0.740E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.52108220E+03, 0.740E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.52588940E+03, 0.740E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.62622030E+03, 0.740E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.54069840E+03, 0.740E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.45278370E+03, 0.740E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.40184290E+03, 0.740E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.34779630E+03, 0.740E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.29948800E+03, 0.740E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.18587683E+04, 0.740E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.15659413E+04, 0.740E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.13478163E+04, 0.740E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.11983202E+04, 0.740E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.10850878E+04, 0.740E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.82786250E+03, 0.740E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.92774070E+03, 0.740E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.69763460E+03, 0.740E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.76226600E+03, 0.740E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.70376190E+03, 0.740E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.58870290E+03, 0.740E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.61664100E+03, 0.740E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.78470960E+03, 0.740E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.71294940E+03, 0.740E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.62490100E+03, 0.740E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.57415840E+03, 0.740E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.51383150E+03, 0.740E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.45758530E+03, 0.740E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.22639013E+04, 0.740E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.20087751E+04, 0.740E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.17339129E+04, 0.740E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.74068630E+03, 0.740E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.17694139E+04, 0.740E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.16938988E+04, 0.740E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.16500004E+04, 0.740E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.16097798E+04, 0.740E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.15740661E+04, 0.740E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.12144448E+04, 0.740E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.14078390E+04, 0.740E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.13533433E+04, 0.740E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.14132821E+04, 0.740E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.13825761E+04, 0.740E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.13545779E+04, 0.740E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.13397711E+04, 0.740E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.11143056E+04, 0.740E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.10763807E+04, 0.740E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.97195240E+03, 0.740E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.81436220E+03, 0.740E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.47481400E+02, 0.750E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.30549200E+02, 0.750E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.84030290E+03, 0.750E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.45686870E+03, 0.750E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.29769360E+03, 0.750E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.19640730E+03, 0.750E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.13504060E+03, 0.750E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.10106690E+03, 0.750E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.75833700E+02, 0.750E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.57897000E+02, 0.750E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.10011833E+04, 0.750E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.73565530E+03, 0.750E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.66653080E+03, 0.750E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.51321450E+03, 0.750E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.39266040E+03, 0.750E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.32200220E+03, 0.750E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.26008050E+03, 0.750E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.21074970E+03, 0.750E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.16563829E+04, 0.750E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.13172961E+04, 0.750E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.10793168E+04, 0.750E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.10345489E+04, 0.750E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.94314230E+03, 0.750E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.74238390E+03, 0.750E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.80678450E+03, 0.750E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.63220880E+03, 0.750E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.66388710E+03, 0.750E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.68701430E+03, 0.750E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.52648590E+03, 0.750E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.53299620E+03, 0.750E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.63416620E+03, 0.750E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.54932810E+03, 0.750E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.46115310E+03, 0.750E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.40981080E+03, 0.750E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.35513780E+03, 0.750E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.30613060E+03, 0.750E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.18506131E+04, 0.750E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.15716863E+04, 0.750E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.13568533E+04, 0.750E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.12084737E+04, 0.750E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.10954282E+04, 0.750E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.83707080E+03, 0.750E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.93753010E+03, 0.750E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.70623580E+03, 0.750E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.77195670E+03, 0.750E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.71318460E+03, 0.750E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.59599800E+03, 0.750E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.62541990E+03, 0.750E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.79423010E+03, 0.750E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.72367260E+03, 0.750E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.63581610E+03, 0.750E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.58492700E+03, 0.750E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.52412750E+03, 0.750E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.46726420E+03, 0.750E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.22535037E+04, 0.750E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.20134740E+04, 0.750E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.17433791E+04, 0.750E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.75313690E+03, 0.750E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.17753357E+04, 0.750E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.17005706E+04, 0.750E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.16567768E+04, 0.750E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.16166266E+04, 0.750E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.15809835E+04, 0.750E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.12234224E+04, 0.750E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.14105904E+04, 0.750E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.13567115E+04, 0.750E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.14207081E+04, 0.750E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.13899934E+04, 0.750E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.13620334E+04, 0.750E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.13469951E+04, 0.750E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.11225706E+04, 0.750E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.10876931E+04, 0.750E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.98375910E+03, 0.750E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.82496150E+03, 0.750E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.83633100E+03, 0.750E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.43502700E+02, 0.760E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.28354600E+02, 0.760E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.73192340E+03, 0.760E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.40716460E+03, 0.760E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.26873040E+03, 0.760E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.17905630E+03, 0.760E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.12405100E+03, 0.760E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.93359700E+02, 0.760E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.70395400E+02, 0.760E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.53964200E+02, 0.760E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.87335890E+03, 0.760E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.65307500E+03, 0.760E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.59556280E+03, 0.760E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.46268400E+03, 0.760E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.35670880E+03, 0.760E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.29400210E+03, 0.760E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.23864150E+03, 0.760E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.19423140E+03, 0.760E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.14396620E+04, 0.760E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.11612618E+04, 0.760E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.95445330E+03, 0.760E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.91746900E+03, 0.760E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.83784550E+03, 0.760E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.65982040E+03, 0.760E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.71850590E+03, 0.760E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.56350590E+03, 0.760E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.59375330E+03, 0.760E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.61335130E+03, 0.760E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.47025530E+03, 0.760E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.47853750E+03, 0.760E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.56822510E+03, 0.760E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.49561460E+03, 0.760E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.41868920E+03, 0.760E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.37355900E+03, 0.760E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.32506940E+03, 0.760E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.28130190E+03, 0.760E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.16103754E+04, 0.760E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.13848254E+04, 0.760E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.12021044E+04, 0.760E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.10743491E+04, 0.760E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.97608420E+03, 0.760E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.74894180E+03, 0.760E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.83752750E+03, 0.760E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.63378860E+03, 0.760E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.69267540E+03, 0.760E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.64089680E+03, 0.760E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.53528690E+03, 0.760E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.56312050E+03, 0.760E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.71169730E+03, 0.760E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.65211350E+03, 0.760E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.57610750E+03, 0.760E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.53178230E+03, 0.760E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.47825570E+03, 0.760E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.42787240E+03, 0.760E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.19610192E+04, 0.760E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.17707984E+04, 0.760E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.15416747E+04, 0.760E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.68178680E+03, 0.760E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.15643082E+04, 0.760E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.14998732E+04, 0.760E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.14616315E+04, 0.760E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.14265281E+04, 0.760E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.13953763E+04, 0.760E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.10864242E+04, 0.760E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.12413205E+04, 0.760E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.11950783E+04, 0.760E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.12556728E+04, 0.760E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.12287111E+04, 0.760E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.12042523E+04, 0.760E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.11906528E+04, 0.760E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.99636440E+03, 0.760E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.97080130E+03, 0.760E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.88109380E+03, 0.760E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.74095590E+03, 0.760E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.75215710E+03, 0.760E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.67852780E+03, 0.760E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.40192800E+02, 0.770E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.26493600E+02, 0.770E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.64922250E+03, 0.770E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.36768190E+03, 0.770E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.24523810E+03, 0.770E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.16475860E+03, 0.770E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.11488740E+03, 0.770E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.86879300E+02, 0.770E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.65790400E+02, 0.770E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.50615900E+02, 0.770E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.77563370E+03, 0.770E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.58794870E+03, 0.770E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.53899920E+03, 0.770E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.42178390E+03, 0.770E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.32723040E+03, 0.770E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.27085510E+03, 0.770E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.22077630E+03, 0.770E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.18037110E+03, 0.770E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.12755198E+04, 0.770E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.10398993E+04, 0.770E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.85678860E+03, 0.770E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.82551250E+03, 0.770E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.75491930E+03, 0.770E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.59487280E+03, 0.770E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.64870850E+03, 0.770E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.50921810E+03, 0.770E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.53789460E+03, 0.770E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.55484790E+03, 0.770E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.42567880E+03, 0.770E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.43487920E+03, 0.770E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.51550510E+03, 0.770E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.45212560E+03, 0.770E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.38392650E+03, 0.770E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.34368330E+03, 0.770E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.30011780E+03, 0.770E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.26056720E+03, 0.770E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.14282493E+04, 0.770E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.12397351E+04, 0.770E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.10808340E+04, 0.770E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.96864880E+03, 0.770E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.88171010E+03, 0.770E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.67887180E+03, 0.770E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.75818340E+03, 0.770E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.57594520E+03, 0.770E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.62929090E+03, 0.770E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.58296220E+03, 0.770E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.48681310E+03, 0.770E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.51303760E+03, 0.770E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.64586290E+03, 0.770E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.59440490E+03, 0.770E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.52746810E+03, 0.770E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.48823190E+03, 0.770E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.44042470E+03, 0.770E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.39518890E+03, 0.770E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.17394992E+04, 0.770E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.15831333E+04, 0.770E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.13842225E+04, 0.770E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.62381140E+03, 0.770E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.14006813E+04, 0.770E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.13439514E+04, 0.770E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.13099454E+04, 0.770E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.12786986E+04, 0.770E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.12509767E+04, 0.770E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.97887040E+03, 0.770E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.11106969E+04, 0.770E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.10701912E+04, 0.770E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.11269388E+04, 0.770E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.11028614E+04, 0.770E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.10810811E+04, 0.770E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.10686460E+04, 0.770E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.89729150E+03, 0.770E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.87805750E+03, 0.770E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.79916860E+03, 0.770E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.67370750E+03, 0.770E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.68458550E+03, 0.770E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.61911480E+03, 0.770E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.56606600E+03, 0.770E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.33737400E+02, 0.780E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.22655000E+02, 0.780E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.52329220E+03, 0.780E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.30016240E+03, 0.780E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.20254080E+03, 0.780E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.13757620E+03, 0.780E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.96865800E+02, 0.780E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.73818300E+02, 0.780E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.56305300E+02, 0.780E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.43593000E+02, 0.780E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.62596250E+03, 0.780E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.47885350E+03, 0.780E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.44120140E+03, 0.780E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.34788170E+03, 0.780E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.27198720E+03, 0.780E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.22647100E+03, 0.780E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.18574640E+03, 0.780E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.15265670E+03, 0.780E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.10299899E+04, 0.780E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.84443870E+03, 0.780E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.69692720E+03, 0.780E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.67305270E+03, 0.780E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.61630660E+03, 0.780E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.48652160E+03, 0.780E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.53065270E+03, 0.780E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.41743140E+03, 0.780E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.44140210E+03, 0.780E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.45462950E+03, 0.780E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.34958030E+03, 0.780E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.35801260E+03, 0.780E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.42342920E+03, 0.780E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.37342980E+03, 0.780E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.31904090E+03, 0.780E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.28687030E+03, 0.780E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.25174820E+03, 0.780E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.21965520E+03, 0.780E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.11547638E+04, 0.780E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.10070623E+04, 0.780E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.88099930E+03, 0.780E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.79155440E+03, 0.780E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.72193400E+03, 0.780E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.55823890E+03, 0.780E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.62242220E+03, 0.780E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.47507150E+03, 0.780E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.51845950E+03, 0.780E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.48093890E+03, 0.780E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.40219150E+03, 0.780E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.42403900E+03, 0.780E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.53144420E+03, 0.780E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.49101090E+03, 0.780E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.43782090E+03, 0.780E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.40661850E+03, 0.780E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.36825920E+03, 0.780E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.33179040E+03, 0.780E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.14071724E+04, 0.780E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.12854322E+04, 0.780E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.11275157E+04, 0.780E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.51768570E+03, 0.780E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.11388994E+04, 0.780E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.10932462E+04, 0.780E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.10657050E+04, 0.780E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.10403742E+04, 0.780E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.10179032E+04, 0.780E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.80035340E+03, 0.780E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.90395940E+03, 0.780E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.87158450E+03, 0.780E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.91760410E+03, 0.780E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.89802720E+03, 0.780E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.88036430E+03, 0.780E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.87003670E+03, 0.780E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.73291850E+03, 0.780E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.71957520E+03, 0.780E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.65682120E+03, 0.780E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.55562970E+03, 0.780E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.56502640E+03, 0.780E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.51242690E+03, 0.780E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.46966640E+03, 0.780E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.39114480E+03, 0.780E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.31643100E+02, 0.790E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.21405700E+02, 0.790E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.48271200E+03, 0.790E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.27848740E+03, 0.790E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.18878590E+03, 0.790E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.12878430E+03, 0.790E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.91021000E+02, 0.790E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.69577200E+02, 0.790E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.53225800E+02, 0.790E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.41316600E+02, 0.790E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.57775500E+03, 0.790E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.44384910E+03, 0.790E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.40978640E+03, 0.790E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.32409250E+03, 0.790E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.25414960E+03, 0.790E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.21210390E+03, 0.790E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.17438080E+03, 0.790E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.14364860E+03, 0.790E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.95062180E+03, 0.790E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.78160440E+03, 0.790E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.64557500E+03, 0.790E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.62406930E+03, 0.790E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.57177460E+03, 0.790E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.45167990E+03, 0.790E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.49272680E+03, 0.790E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.38791960E+03, 0.790E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.41040680E+03, 0.790E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.42244780E+03, 0.790E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.32511980E+03, 0.790E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.33331770E+03, 0.790E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.39382270E+03, 0.790E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.34809220E+03, 0.790E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.29810130E+03, 0.790E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.26850000E+03, 0.790E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.23607650E+03, 0.790E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.20637560E+03, 0.790E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.10663289E+04, 0.790E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.93220550E+03, 0.790E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.81674650E+03, 0.790E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.73461520E+03, 0.790E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.67055170E+03, 0.790E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.51941000E+03, 0.790E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.57874610E+03, 0.790E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.44259210E+03, 0.790E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.48280890E+03, 0.790E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.44812160E+03, 0.790E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.37494860E+03, 0.790E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.39541490E+03, 0.790E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.49465360E+03, 0.790E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.45775290E+03, 0.790E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.40894270E+03, 0.790E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.38029110E+03, 0.790E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.34494080E+03, 0.790E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.31127000E+03, 0.790E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.12995975E+04, 0.790E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.11895405E+04, 0.790E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.10448996E+04, 0.790E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.48348310E+03, 0.790E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.10546339E+04, 0.790E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.10125735E+04, 0.790E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.98712160E+03, 0.790E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.96370210E+03, 0.790E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.94292740E+03, 0.790E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.74291920E+03, 0.790E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.83729210E+03, 0.790E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.80754210E+03, 0.790E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.85029540E+03, 0.790E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.83217180E+03, 0.790E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.81583760E+03, 0.790E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.80619030E+03, 0.790E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.68007310E+03, 0.790E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.66862000E+03, 0.790E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.61103860E+03, 0.790E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.51760830E+03, 0.790E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.52653700E+03, 0.790E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.47806720E+03, 0.790E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.43860830E+03, 0.790E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.36582470E+03, 0.790E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.34235260E+03, 0.790E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.32647500E+02, 0.800E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.22083700E+02, 0.800E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.48740200E+03, 0.800E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.28506170E+03, 0.800E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.19416150E+03, 0.800E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.13273170E+03, 0.800E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.93883600E+02, 0.800E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.71776000E+02, 0.800E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.54902300E+02, 0.800E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.42608500E+02, 0.800E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.58379600E+03, 0.800E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.45335960E+03, 0.800E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.41983840E+03, 0.800E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.33321670E+03, 0.800E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.26185840E+03, 0.800E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.21871850E+03, 0.800E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.17991240E+03, 0.800E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.14823250E+03, 0.800E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.95736170E+03, 0.800E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.79465850E+03, 0.800E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.65759170E+03, 0.800E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.63652100E+03, 0.800E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.58366570E+03, 0.800E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.46085090E+03, 0.800E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.50355400E+03, 0.800E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.39629990E+03, 0.800E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.42025520E+03, 0.800E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.43227410E+03, 0.800E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.33243400E+03, 0.800E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.34187100E+03, 0.800E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.40370590E+03, 0.800E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.35784550E+03, 0.800E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.30703710E+03, 0.800E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.27676970E+03, 0.800E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.24349600E+03, 0.800E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.21293560E+03, 0.800E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.10744128E+04, 0.800E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.94720110E+03, 0.800E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.83242220E+03, 0.800E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.74998240E+03, 0.800E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.68523850E+03, 0.800E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.53145620E+03, 0.800E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.59192160E+03, 0.800E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.45328020E+03, 0.800E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.49471860E+03, 0.800E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.45942820E+03, 0.800E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.38395180E+03, 0.800E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.40566070E+03, 0.800E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.50664510E+03, 0.800E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.47008500E+03, 0.800E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.42079320E+03, 0.800E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.39167400E+03, 0.800E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.35554970E+03, 0.800E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.32102510E+03, 0.800E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.13092921E+04, 0.800E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.12070341E+04, 0.800E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.10636276E+04, 0.800E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.49715300E+03, 0.800E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.10712093E+04, 0.800E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.10290835E+04, 0.800E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.10033846E+04, 0.800E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.97972320E+03, 0.800E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.95873970E+03, 0.800E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.75756310E+03, 0.800E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.84922660E+03, 0.800E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.81952610E+03, 0.800E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.86529630E+03, 0.800E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.84694850E+03, 0.800E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.83044190E+03, 0.800E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.82053560E+03, 0.800E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.69354790E+03, 0.800E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.68391950E+03, 0.800E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.62592010E+03, 0.800E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.53051690E+03, 0.800E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.54005040E+03, 0.800E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.49085310E+03, 0.800E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.45068210E+03, 0.800E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.37600960E+03, 0.800E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.35193500E+03, 0.800E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.36207550E+03, 0.800E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.45565900E+02, 0.810E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.29383200E+02, 0.810E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.84156200E+03, 0.810E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.44509900E+03, 0.810E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.28743460E+03, 0.810E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.18891370E+03, 0.810E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.12977590E+03, 0.810E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.97188700E+02, 0.810E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.73035300E+02, 0.810E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.55878200E+02, 0.810E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.10013499E+04, 0.810E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.71984280E+03, 0.810E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.64850370E+03, 0.810E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.49588920E+03, 0.810E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.37786060E+03, 0.810E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.30940570E+03, 0.810E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.24971520E+03, 0.810E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.20236390E+03, 0.810E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.16699732E+04, 0.810E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.13012325E+04, 0.810E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.10621257E+04, 0.810E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.10156676E+04, 0.810E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.92450540E+03, 0.810E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.72875260E+03, 0.810E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.78917040E+03, 0.810E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.61912140E+03, 0.810E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.64688450E+03, 0.810E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.67034360E+03, 0.810E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.51478030E+03, 0.810E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.51777130E+03, 0.810E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.61653920E+03, 0.810E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.53101480E+03, 0.810E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.44413160E+03, 0.810E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.39408930E+03, 0.810E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.34115420E+03, 0.810E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.29394640E+03, 0.810E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.18646164E+04, 0.810E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.15547036E+04, 0.810E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.13341432E+04, 0.810E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.11843558E+04, 0.810E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.10716858E+04, 0.810E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.81713880E+03, 0.810E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.91594930E+03, 0.810E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.68833610E+03, 0.810E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.75141170E+03, 0.810E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.69349420E+03, 0.810E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.58127400E+03, 0.810E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.60745600E+03, 0.810E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.77388330E+03, 0.810E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.70133540E+03, 0.810E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.61379650E+03, 0.810E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.56366330E+03, 0.810E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.50431850E+03, 0.810E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.44915730E+03, 0.810E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.22724078E+04, 0.810E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.19977665E+04, 0.810E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.17187930E+04, 0.810E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.72802070E+03, 0.810E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.17584731E+04, 0.810E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.16821281E+04, 0.810E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.16382173E+04, 0.810E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.15980083E+04, 0.810E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.15622939E+04, 0.810E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.12025229E+04, 0.810E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.14026627E+04, 0.810E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.13479037E+04, 0.810E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.14013832E+04, 0.810E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.13707449E+04, 0.810E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.13427654E+04, 0.810E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.13281907E+04, 0.810E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.11030932E+04, 0.810E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.10619960E+04, 0.810E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.95783300E+03, 0.810E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.80262850E+03, 0.810E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.81249710E+03, 0.810E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.72924020E+03, 0.810E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.66279090E+03, 0.810E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.54691720E+03, 0.810E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.50961460E+03, 0.810E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.52190910E+03, 0.810E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.79223780E+03, 0.810E+02, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.45178600E+02, 0.820E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.29396300E+02, 0.820E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.77049850E+03, 0.820E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.42598770E+03, 0.820E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.28017140E+03, 0.820E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.18622350E+03, 0.820E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.12882430E+03, 0.820E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.96880100E+02, 0.820E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.73028500E+02, 0.820E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.55990900E+02, 0.820E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.91912570E+03, 0.820E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.68410110E+03, 0.820E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.62271340E+03, 0.820E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.48258810E+03, 0.820E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.37129390E+03, 0.820E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.30563890E+03, 0.820E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.24781410E+03, 0.820E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.20153300E+03, 0.820E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.15164193E+04, 0.820E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.12187009E+04, 0.820E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.10008602E+04, 0.820E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.96137180E+03, 0.820E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.87756550E+03, 0.820E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.69108340E+03, 0.820E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.75211560E+03, 0.820E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.58980850E+03, 0.820E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.62087440E+03, 0.820E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.64167640E+03, 0.820E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.49199760E+03, 0.820E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.49993220E+03, 0.820E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.59373850E+03, 0.820E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.51689320E+03, 0.820E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.43592810E+03, 0.820E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.38853730E+03, 0.820E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.33776830E+03, 0.820E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.29204720E+03, 0.820E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.16956909E+04, 0.820E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.14534745E+04, 0.820E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.12598691E+04, 0.820E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.11249617E+04, 0.820E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.10214733E+04, 0.820E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.78299060E+03, 0.820E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.87595820E+03, 0.820E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.66216750E+03, 0.820E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.72370460E+03, 0.820E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.66938820E+03, 0.820E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.55927100E+03, 0.820E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.58793680E+03, 0.820E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.74387970E+03, 0.820E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.68057520E+03, 0.820E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.60037140E+03, 0.820E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.55368260E+03, 0.820E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.49748720E+03, 0.820E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.44470070E+03, 0.820E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.20646687E+04, 0.820E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.18594085E+04, 0.820E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.16164677E+04, 0.820E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.71062890E+03, 0.820E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.16419885E+04, 0.820E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.15739763E+04, 0.820E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.15337469E+04, 0.820E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.14968291E+04, 0.820E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.14640624E+04, 0.820E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.11380979E+04, 0.820E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.13034316E+04, 0.820E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.12545335E+04, 0.820E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.13170177E+04, 0.820E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.12886907E+04, 0.820E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.12629662E+04, 0.820E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.12487891E+04, 0.820E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.10439034E+04, 0.820E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.10154887E+04, 0.820E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.92083050E+03, 0.820E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.77385260E+03, 0.820E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.78529450E+03, 0.820E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.70790090E+03, 0.820E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.64554700E+03, 0.820E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.53402070E+03, 0.820E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.49813010E+03, 0.820E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.51131450E+03, 0.820E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.76196480E+03, 0.820E+02, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.73881560E+03, 0.820E+02, 0.820E+02, 0.00000000E+00, 0.00000000E+00,
  0.42241900E+02, 0.830E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.27932900E+02, 0.830E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.66152780E+03, 0.830E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.38103070E+03, 0.830E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.25605370E+03, 0.830E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.17278310E+03, 0.830E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.12079930E+03, 0.830E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.91493400E+02, 0.830E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.69368900E+02, 0.830E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.53420400E+02, 0.830E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.79108680E+03, 0.830E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.60760080E+03, 0.830E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.55943360E+03, 0.830E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.44013430E+03, 0.830E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.34277880E+03, 0.830E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.28429480E+03, 0.830E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.23212190E+03, 0.830E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.18987560E+03, 0.830E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.12966253E+04, 0.830E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.10686331E+04, 0.830E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.88251530E+03, 0.830E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.85188550E+03, 0.830E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.77993360E+03, 0.830E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.61445090E+03, 0.830E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.67130550E+03, 0.830E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.52693210E+03, 0.830E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.55817400E+03, 0.830E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.57514870E+03, 0.830E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.44105510E+03, 0.830E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.45236780E+03, 0.830E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.53570130E+03, 0.830E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.47183760E+03, 0.830E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.40199200E+03, 0.830E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.36047350E+03, 0.830E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.31527740E+03, 0.830E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.27407550E+03, 0.830E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.14529418E+04, 0.830E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.12732370E+04, 0.830E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.11143977E+04, 0.830E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.10010315E+04, 0.830E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.91248200E+03, 0.830E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.70407130E+03, 0.830E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.78575170E+03, 0.830E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.59827920E+03, 0.830E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.65393370E+03, 0.830E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.60631280E+03, 0.830E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.50575740E+03, 0.830E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.53417140E+03, 0.830E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.67073540E+03, 0.830E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.61958270E+03, 0.830E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.55156050E+03, 0.830E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.51139760E+03, 0.830E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.46208340E+03, 0.830E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.41520110E+03, 0.830E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.17696390E+04, 0.830E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.16234740E+04, 0.830E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.14251223E+04, 0.830E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.65171260E+03, 0.830E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.14382615E+04, 0.830E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.13809451E+04, 0.830E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.13462674E+04, 0.830E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.13143784E+04, 0.830E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.12860963E+04, 0.830E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.10103860E+04, 0.830E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.11390166E+04, 0.830E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.10983110E+04, 0.830E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.11597774E+04, 0.830E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.11351424E+04, 0.830E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.11129109E+04, 0.830E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.10999410E+04, 0.830E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.92612910E+03, 0.830E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.90981540E+03, 0.830E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.82982850E+03, 0.830E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.70043950E+03, 0.830E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.71241700E+03, 0.830E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.64537650E+03, 0.830E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.59085050E+03, 0.830E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.49072340E+03, 0.830E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.45847260E+03, 0.830E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.47152310E+03, 0.830E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.68856550E+03, 0.830E+02, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.67269040E+03, 0.830E+02, 0.820E+02, 0.00000000E+00, 0.00000000E+00,
  0.61752960E+03, 0.830E+02, 0.830E+02, 0.00000000E+00, 0.00000000E+00,
  0.40710600E+02, 0.840E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.27211800E+02, 0.840E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.60731510E+03, 0.840E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.35746030E+03, 0.840E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.24330570E+03, 0.840E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.16573270E+03, 0.840E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.11666150E+03, 0.840E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.88773600E+02, 0.840E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.67567200E+02, 0.840E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.52188100E+02, 0.840E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.72726310E+03, 0.840E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.56780720E+03, 0.840E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.52626000E+03, 0.840E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.41768440E+03, 0.840E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.32771360E+03, 0.840E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.27309950E+03, 0.840E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.22398500E+03, 0.840E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.18392230E+03, 0.840E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.11891902E+04, 0.840E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.99221250E+03, 0.840E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.82178250E+03, 0.840E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.79553840E+03, 0.840E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.72956570E+03, 0.840E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.57517310E+03, 0.840E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.62948100E+03, 0.840E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.49459140E+03, 0.840E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.52549790E+03, 0.840E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.54053270E+03, 0.840E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.41478690E+03, 0.840E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.42746160E+03, 0.840E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.50536000E+03, 0.840E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.44808220E+03, 0.840E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.38408530E+03, 0.840E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.34572660E+03, 0.840E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.30354480E+03, 0.840E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.26479780E+03, 0.840E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.13343692E+04, 0.840E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.11818604E+04, 0.840E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.10398622E+04, 0.840E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.93720360E+03, 0.840E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.85623980E+03, 0.840E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.66336080E+03, 0.840E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.73919570E+03, 0.840E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.56531410E+03, 0.840E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.61769980E+03, 0.840E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.57350990E+03, 0.840E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.47823360E+03, 0.840E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.50616860E+03, 0.840E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.63278330E+03, 0.840E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.58760970E+03, 0.840E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.52587280E+03, 0.840E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.48916400E+03, 0.840E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.44353000E+03, 0.840E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.39983350E+03, 0.840E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.16260419E+04, 0.840E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.15047607E+04, 0.840E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.13277397E+04, 0.840E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.62085480E+03, 0.840E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.13354309E+04, 0.840E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.12832336E+04, 0.840E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.12512879E+04, 0.840E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.12218775E+04, 0.840E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.11958046E+04, 0.840E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.94515700E+03, 0.840E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.10569864E+04, 0.840E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.10202790E+04, 0.840E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.10796889E+04, 0.840E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.10568831E+04, 0.840E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.10363788E+04, 0.840E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.10240338E+04, 0.840E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.86580300E+03, 0.840E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.85504390E+03, 0.840E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.78248020E+03, 0.840E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.66238200E+03, 0.840E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.67449800E+03, 0.840E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.61277720E+03, 0.840E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.56231000E+03, 0.840E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.46825250E+03, 0.840E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.43792710E+03, 0.840E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.45080740E+03, 0.840E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.65074290E+03, 0.840E+02, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.63822510E+03, 0.840E+02, 0.820E+02, 0.00000000E+00, 0.00000000E+00,
  0.58861880E+03, 0.840E+02, 0.830E+02, 0.00000000E+00, 0.00000000E+00,
  0.56260110E+03, 0.840E+02, 0.840E+02, 0.00000000E+00, 0.00000000E+00,
  0.38046800E+02, 0.850E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.25807100E+02, 0.850E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.53565210E+03, 0.850E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.32315400E+03, 0.850E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.22339710E+03, 0.850E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.15398830E+03, 0.850E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.10936180E+03, 0.850E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.83743700E+02, 0.850E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.64079700E+02, 0.850E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.49704300E+02, 0.850E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.64255990E+03, 0.850E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.51104720E+03, 0.850E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.47738160E+03, 0.850E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.38289140E+03, 0.850E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.30317170E+03, 0.850E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.25418990E+03, 0.850E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.20969510E+03, 0.850E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.17306680E+03, 0.850E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.10486754E+04, 0.850E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.88679380E+03, 0.850E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.73687680E+03, 0.850E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.71582420E+03, 0.850E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.65777000E+03, 0.850E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.51922800E+03, 0.850E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.56918500E+03, 0.850E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.44794120E+03, 0.850E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.47740460E+03, 0.850E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.49002960E+03, 0.850E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.37654500E+03, 0.850E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.39005450E+03, 0.850E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.46013230E+03, 0.850E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.41119140E+03, 0.850E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.35508990E+03, 0.850E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.32115720E+03, 0.850E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.28336260E+03, 0.850E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.24831690E+03, 0.850E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.11787843E+04, 0.850E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.10561781E+04, 0.850E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.93492800E+03, 0.850E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.84595890E+03, 0.850E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.77500770E+03, 0.850E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.60351860E+03, 0.850E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.67120920E+03, 0.850E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.51618070E+03, 0.850E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.56361340E+03, 0.850E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.52417160E+03, 0.850E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.43716280E+03, 0.850E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.46363160E+03, 0.850E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.57648690E+03, 0.850E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.53857130E+03, 0.850E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.48503660E+03, 0.850E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.45297260E+03, 0.850E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.41249290E+03, 0.850E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.37339600E+03, 0.850E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.14375237E+04, 0.850E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.13427557E+04, 0.850E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.11918004E+04, 0.850E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.57219880E+03, 0.850E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.11941552E+04, 0.850E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.11484879E+04, 0.850E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.11201674E+04, 0.850E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.10940580E+04, 0.850E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.10709219E+04, 0.850E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.85263060E+03, 0.850E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.94504500E+03, 0.850E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.91333710E+03, 0.850E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.96825870E+03, 0.850E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.94792020E+03, 0.850E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.92971630E+03, 0.850E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.91834420E+03, 0.850E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.78031510E+03, 0.850E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.77523370E+03, 0.850E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.71228880E+03, 0.850E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.60524130E+03, 0.850E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.61710680E+03, 0.850E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.56258800E+03, 0.850E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.51772850E+03, 0.850E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.43264880E+03, 0.850E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.40518020E+03, 0.850E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.41747370E+03, 0.850E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.59434970E+03, 0.850E+02, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.58543140E+03, 0.850E+02, 0.820E+02, 0.00000000E+00, 0.00000000E+00,
  0.54287440E+03, 0.850E+02, 0.830E+02, 0.00000000E+00, 0.00000000E+00,
  0.52058720E+03, 0.850E+02, 0.840E+02, 0.00000000E+00, 0.00000000E+00,
  0.48365360E+03, 0.850E+02, 0.850E+02, 0.00000000E+00, 0.00000000E+00,
  0.35275000E+02, 0.860E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.24288600E+02, 0.860E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.47129940E+03, 0.860E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.29040790E+03, 0.860E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.20366210E+03, 0.860E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.14199460E+03, 0.860E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.10173400E+03, 0.860E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.78399300E+02, 0.860E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.60320800E+02, 0.860E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.46997000E+02, 0.860E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.56630470E+03, 0.860E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.45752070E+03, 0.860E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.43040700E+03, 0.860E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.34853240E+03, 0.860E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.27834410E+03, 0.860E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.23475630E+03, 0.860E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.19477780E+03, 0.860E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.16157780E+03, 0.860E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.92348960E+03, 0.860E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.78946510E+03, 0.860E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.65782090E+03, 0.860E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.64106890E+03, 0.860E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.59013650E+03, 0.860E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.46657860E+03, 0.860E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.51200690E+03, 0.860E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.40371620E+03, 0.860E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.43125430E+03, 0.860E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.44180520E+03, 0.860E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.34010290E+03, 0.860E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.35375690E+03, 0.860E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.41640720E+03, 0.860E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.37473780E+03, 0.860E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.32584680E+03, 0.860E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.29605910E+03, 0.860E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.26246780E+03, 0.860E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.23103920E+03, 0.860E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.10398788E+04, 0.860E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.94037660E+03, 0.860E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.83682440E+03, 0.860E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.75986860E+03, 0.860E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.69790750E+03, 0.860E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.54617620E+03, 0.860E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.60628810E+03, 0.860E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.46875270E+03, 0.860E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.51133700E+03, 0.860E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.47629130E+03, 0.860E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.39751230E+03, 0.860E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.42213930E+03, 0.860E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.52225240E+03, 0.860E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.49045740E+03, 0.860E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.44423510E+03, 0.860E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.41640380E+03, 0.860E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.38074630E+03, 0.860E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.34603400E+03, 0.860E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.12691514E+04, 0.860E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.11942553E+04, 0.860E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.10653886E+04, 0.860E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.52379990E+03, 0.860E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.10641113E+04, 0.860E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.10241601E+04, 0.860E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.99910040E+03, 0.860E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.97596710E+03, 0.860E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.95547530E+03, 0.860E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.76577540E+03, 0.860E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.84248080E+03, 0.860E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.81508100E+03, 0.860E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.86486000E+03, 0.860E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.84676410E+03, 0.860E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.83063370E+03, 0.860E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.82022230E+03, 0.860E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.70009390E+03, 0.860E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.69908500E+03, 0.860E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.64467130E+03, 0.860E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.54983920E+03, 0.860E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.56121370E+03, 0.860E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.51327610E+03, 0.860E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.47360870E+03, 0.860E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.39719060E+03, 0.860E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.37248250E+03, 0.860E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.38402410E+03, 0.860E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.53990550E+03, 0.860E+02, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.53369840E+03, 0.860E+02, 0.820E+02, 0.00000000E+00, 0.00000000E+00,
  0.49729720E+03, 0.860E+02, 0.830E+02, 0.00000000E+00, 0.00000000E+00,
  0.47831130E+03, 0.860E+02, 0.840E+02, 0.00000000E+00, 0.00000000E+00,
  0.44604470E+03, 0.860E+02, 0.850E+02, 0.00000000E+00, 0.00000000E+00,
  0.41282750E+03, 0.860E+02, 0.860E+02, 0.00000000E+00, 0.00000000E+00,
  0.10074940E+03, 0.870E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.59659400E+02, 0.870E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.28945966E+04, 0.870E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.12189348E+04, 0.870E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.71065850E+03, 0.870E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.43419670E+03, 0.870E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.28277630E+03, 0.870E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.20397230E+03, 0.870E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.14835840E+03, 0.870E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.11051200E+03, 0.870E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.33986461E+04, 0.870E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.20446296E+04, 0.870E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.17465418E+04, 0.870E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.12378269E+04, 0.870E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.88882250E+03, 0.870E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.70197610E+03, 0.870E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.54727120E+03, 0.870E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.43044680E+03, 0.870E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.60209123E+04, 0.870E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.39885535E+04, 0.870E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.31533933E+04, 0.870E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.29483214E+04, 0.870E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.26441348E+04, 0.870E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.20951563E+04, 0.870E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.22092516E+04, 0.870E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.17359767E+04, 0.870E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.17406013E+04, 0.870E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.18302286E+04, 0.870E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.14168737E+04, 0.870E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.13464975E+04, 0.870E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.16330869E+04, 0.870E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.13219669E+04, 0.870E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.10509064E+04, 0.870E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.90547240E+03, 0.870E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.76070860E+03, 0.870E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.63792100E+03, 0.870E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.66879551E+04, 0.870E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.48140613E+04, 0.870E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.39238630E+04, 0.870E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.33777348E+04, 0.870E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.30012009E+04, 0.870E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.22208404E+04, 0.870E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.25189457E+04, 0.870E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.18286037E+04, 0.870E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.19819822E+04, 0.870E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.18052792E+04, 0.870E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.15403020E+04, 0.870E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.15550964E+04, 0.870E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.20671731E+04, 0.870E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.17732620E+04, 0.870E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.14801255E+04, 0.870E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.13236329E+04, 0.870E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.11516386E+04, 0.870E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.99949930E+03, 0.870E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.82315280E+04, 0.870E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.63397235E+04, 0.870E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.51715628E+04, 0.870E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.17765919E+04, 0.870E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.54969601E+04, 0.870E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.51886826E+04, 0.870E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.50376830E+04, 0.870E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.49009739E+04, 0.870E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.47792385E+04, 0.870E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.35004650E+04, 0.870E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.45180145E+04, 0.870E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.43256882E+04, 0.870E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.42216216E+04, 0.870E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.41211013E+04, 0.870E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.40270614E+04, 0.870E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.39908778E+04, 0.870E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.32187704E+04, 0.870E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.29218119E+04, 0.870E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.25563295E+04, 0.870E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.21076991E+04, 0.870E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.21032454E+04, 0.870E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.18383882E+04, 0.870E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.16363884E+04, 0.870E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.13271181E+04, 0.870E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.12270914E+04, 0.870E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.12394986E+04, 0.870E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.21094753E+04, 0.870E+02, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.19333025E+04, 0.870E+02, 0.820E+02, 0.00000000E+00, 0.00000000E+00,
  0.16699965E+04, 0.870E+02, 0.830E+02, 0.00000000E+00, 0.00000000E+00,
  0.15408317E+04, 0.870E+02, 0.840E+02, 0.00000000E+00, 0.00000000E+00,
  0.13687363E+04, 0.870E+02, 0.850E+02, 0.00000000E+00, 0.00000000E+00,
  0.12134959E+04, 0.870E+02, 0.860E+02, 0.00000000E+00, 0.00000000E+00,
  0.73147398E+04, 0.870E+02, 0.870E+02, 0.00000000E+00, 0.00000000E+00,
  0.99413100E+02, 0.880E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.59674000E+02, 0.880E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.24340697E+04, 0.880E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.11320344E+04, 0.880E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.68137890E+03, 0.880E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.42416130E+03, 0.880E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.27936020E+03, 0.880E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.20282600E+03, 0.880E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.14825160E+03, 0.880E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.11081260E+03, 0.880E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.28745717E+04, 0.880E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.18719600E+04, 0.880E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.16279493E+04, 0.880E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.11837103E+04, 0.880E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.86434290E+03, 0.880E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.68837560E+03, 0.880E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.54058680E+03, 0.880E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.42751470E+03, 0.880E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.49128581E+04, 0.880E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.35289590E+04, 0.880E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.28292273E+04, 0.880E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.26655950E+04, 0.880E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.24036878E+04, 0.880E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.18947707E+04, 0.880E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.20238919E+04, 0.880E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.15845838E+04, 0.880E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.16192221E+04, 0.880E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.16942469E+04, 0.880E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.13022136E+04, 0.880E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.12677966E+04, 0.880E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.15270149E+04, 0.880E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.12635730E+04, 0.880E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.10197251E+04, 0.880E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.88504330E+03, 0.880E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.74865020E+03, 0.880E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.63127570E+03, 0.880E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.54594039E+04, 0.880E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.42339736E+04, 0.880E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.35246180E+04, 0.880E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.30700206E+04, 0.880E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.27442675E+04, 0.880E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.20488350E+04, 0.880E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.23149349E+04, 0.880E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.16984672E+04, 0.880E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.18511077E+04, 0.880E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.16939362E+04, 0.880E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.14296950E+04, 0.880E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.14674624E+04, 0.880E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.19210215E+04, 0.880E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.16832537E+04, 0.880E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.14267831E+04, 0.880E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.12854608E+04, 0.880E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.11265319E+04, 0.880E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.98363370E+03, 0.880E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.66646049E+04, 0.880E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.55052582E+04, 0.880E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.45943095E+04, 0.880E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.17037104E+04, 0.880E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.47976061E+04, 0.880E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.45623865E+04, 0.880E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.44362592E+04, 0.880E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.43214914E+04, 0.880E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.42193690E+04, 0.880E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.31447184E+04, 0.880E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.38693475E+04, 0.880E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.37006978E+04, 0.880E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.37536534E+04, 0.880E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.36679746E+04, 0.880E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.35884351E+04, 0.880E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.35540067E+04, 0.880E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.28892983E+04, 0.880E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.26921229E+04, 0.880E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.23813318E+04, 0.880E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.19684730E+04, 0.880E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.19760672E+04, 0.880E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.17428522E+04, 0.880E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.15616887E+04, 0.880E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.12704258E+04, 0.880E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.11766222E+04, 0.880E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.11957573E+04, 0.880E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.19547292E+04, 0.880E+02, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.18286515E+04, 0.880E+02, 0.820E+02, 0.00000000E+00, 0.00000000E+00,
  0.16046349E+04, 0.880E+02, 0.830E+02, 0.00000000E+00, 0.00000000E+00,
  0.14914089E+04, 0.880E+02, 0.840E+02, 0.00000000E+00, 0.00000000E+00,
  0.13351632E+04, 0.880E+02, 0.850E+02, 0.00000000E+00, 0.00000000E+00,
  0.11909286E+04, 0.880E+02, 0.860E+02, 0.00000000E+00, 0.00000000E+00,
  0.60457168E+04, 0.880E+02, 0.870E+02, 0.00000000E+00, 0.00000000E+00,
  0.53054399E+04, 0.880E+02, 0.880E+02, 0.00000000E+00, 0.00000000E+00,
  0.89406000E+02, 0.890E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.54461300E+02, 0.890E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.20082591E+04, 0.890E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.97721480E+03, 0.890E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.60005330E+03, 0.890E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.37866720E+03, 0.890E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.25180860E+03, 0.890E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.18403180E+03, 0.890E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.13527920E+03, 0.890E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.10158570E+03, 0.890E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.23774617E+04, 0.890E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.16040300E+04, 0.890E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.14098711E+04, 0.890E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.10405681E+04, 0.890E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.76851320E+03, 0.890E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.61613190E+03, 0.890E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.48688350E+03, 0.890E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.38707200E+03, 0.890E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.40174782E+04, 0.890E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.29771478E+04, 0.890E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.24021540E+04, 0.890E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.22732739E+04, 0.890E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.20559589E+04, 0.890E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.16183634E+04, 0.890E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.17384495E+04, 0.890E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.13600663E+04, 0.890E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.14017622E+04, 0.890E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.14625357E+04, 0.890E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.11217466E+04, 0.890E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.11049523E+04, 0.890E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.13263601E+04, 0.890E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.11110958E+04, 0.890E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.90553420E+03, 0.890E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.79026450E+03, 0.890E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.67216580E+03, 0.890E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.56954790E+03, 0.890E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.44690053E+04, 0.890E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.35643510E+04, 0.890E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.29977722E+04, 0.890E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.26270446E+04, 0.890E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.23567083E+04, 0.890E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.17692538E+04, 0.890E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.19948729E+04, 0.890E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.14730457E+04, 0.890E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.16081722E+04, 0.890E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.14753924E+04, 0.890E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.12402274E+04, 0.890E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.12822835E+04, 0.890E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.16650502E+04, 0.890E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.14751121E+04, 0.890E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.12620917E+04, 0.890E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.11429090E+04, 0.890E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.10069141E+04, 0.890E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.88341400E+03, 0.890E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.54478929E+04, 0.890E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.46120247E+04, 0.890E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.38897052E+04, 0.890E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.15031569E+04, 0.890E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.40323992E+04, 0.890E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.38433536E+04, 0.890E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.37393646E+04, 0.890E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.36445469E+04, 0.890E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.35602278E+04, 0.890E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.26796802E+04, 0.890E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.32333681E+04, 0.890E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.30968078E+04, 0.890E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.31769406E+04, 0.890E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.31056847E+04, 0.890E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.30398461E+04, 0.890E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.30095999E+04, 0.890E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.24623774E+04, 0.890E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.23202277E+04, 0.890E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.20645670E+04, 0.890E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.17115570E+04, 0.890E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.17232231E+04, 0.890E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.15276535E+04, 0.890E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.13743640E+04, 0.890E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.11213924E+04, 0.890E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.10400238E+04, 0.890E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.10600607E+04, 0.890E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.16946605E+04, 0.890E+02, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.16008616E+04, 0.890E+02, 0.820E+02, 0.00000000E+00, 0.00000000E+00,
  0.14174346E+04, 0.890E+02, 0.830E+02, 0.00000000E+00, 0.00000000E+00,
  0.13236360E+04, 0.890E+02, 0.840E+02, 0.00000000E+00, 0.00000000E+00,
  0.11913272E+04, 0.890E+02, 0.850E+02, 0.00000000E+00, 0.00000000E+00,
  0.10675065E+04, 0.890E+02, 0.860E+02, 0.00000000E+00, 0.00000000E+00,
  0.49814961E+04, 0.890E+02, 0.870E+02, 0.00000000E+00, 0.00000000E+00,
  0.44669584E+04, 0.890E+02, 0.880E+02, 0.00000000E+00, 0.00000000E+00,
  0.37996565E+04, 0.890E+02, 0.890E+02, 0.00000000E+00, 0.00000000E+00,
  0.82083600E+02, 0.900E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.51110300E+02, 0.900E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.16724768E+04, 0.900E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.85252490E+03, 0.900E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.53608580E+03, 0.900E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.34435760E+03, 0.900E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.23207230E+03, 0.900E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.17124180E+03, 0.900E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.12693930E+03, 0.900E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.95984500E+02, 0.900E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.19852103E+04, 0.900E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.13883756E+04, 0.900E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.12352681E+04, 0.900E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.92751070E+03, 0.900E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.69479830E+03, 0.900E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.56206360E+03, 0.900E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.44804860E+03, 0.900E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.35892730E+03, 0.900E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.33208171E+04, 0.900E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.25377308E+04, 0.900E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.20608901E+04, 0.900E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.19602827E+04, 0.900E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.17786546E+04, 0.900E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.13994778E+04, 0.900E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.15110816E+04, 0.900E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.11825093E+04, 0.900E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.12287380E+04, 0.900E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.12777896E+04, 0.900E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.97919840E+03, 0.900E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.97588560E+03, 0.900E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.11670583E+04, 0.900E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.99120150E+03, 0.900E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.81755520E+03, 0.900E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.71866790E+03, 0.900E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.61585050E+03, 0.900E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.52542400E+03, 0.900E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.36996637E+04, 0.900E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.30331273E+04, 0.900E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.25787074E+04, 0.900E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.22748325E+04, 0.900E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.20492299E+04, 0.900E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.15491780E+04, 0.900E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.17421202E+04, 0.900E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.12966551E+04, 0.900E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.14168423E+04, 0.900E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.13036060E+04, 0.900E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.10925939E+04, 0.900E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.11371745E+04, 0.900E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.14631580E+04, 0.900E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.13115880E+04, 0.900E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.11344385E+04, 0.900E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.10338769E+04, 0.900E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.91709200E+03, 0.900E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.80980180E+03, 0.900E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.45055681E+04, 0.900E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.39071262E+04, 0.900E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.33315473E+04, 0.900E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.13478223E+04, 0.900E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.34277894E+04, 0.900E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.32744792E+04, 0.900E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.31877428E+04, 0.900E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.31084769E+04, 0.900E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.30380345E+04, 0.900E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.23122086E+04, 0.900E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.27358113E+04, 0.900E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.26241922E+04, 0.900E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.27191319E+04, 0.900E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.26591268E+04, 0.900E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.26040009E+04, 0.900E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.25769767E+04, 0.900E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.21236819E+04, 0.900E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.20248239E+04, 0.900E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.18137564E+04, 0.900E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.15101361E+04, 0.900E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.15249297E+04, 0.900E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.13598576E+04, 0.900E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.12292164E+04, 0.900E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.10074225E+04, 0.900E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.93609580E+03, 0.900E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.95680470E+03, 0.900E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.14915698E+04, 0.900E+02, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.14229431E+04, 0.900E+02, 0.820E+02, 0.00000000E+00, 0.00000000E+00,
  0.12726601E+04, 0.900E+02, 0.830E+02, 0.00000000E+00, 0.00000000E+00,
  0.11951492E+04, 0.900E+02, 0.840E+02, 0.00000000E+00, 0.00000000E+00,
  0.10828719E+04, 0.900E+02, 0.850E+02, 0.00000000E+00, 0.00000000E+00,
  0.97614170E+03, 0.900E+02, 0.860E+02, 0.00000000E+00, 0.00000000E+00,
  0.41555932E+04, 0.900E+02, 0.870E+02, 0.00000000E+00, 0.00000000E+00,
  0.38047750E+04, 0.900E+02, 0.880E+02, 0.00000000E+00, 0.00000000E+00,
  0.32704258E+04, 0.900E+02, 0.890E+02, 0.00000000E+00, 0.00000000E+00,
  0.28472704E+04, 0.900E+02, 0.900E+02, 0.00000000E+00, 0.00000000E+00,
  0.80726000E+02, 0.910E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.50005200E+02, 0.910E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.17306038E+04, 0.910E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.85763790E+03, 0.910E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.53308180E+03, 0.910E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.33998630E+03, 0.910E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.22813330E+03, 0.910E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.16791870E+03, 0.910E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.12426420E+03, 0.910E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.93866300E+02, 0.910E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.20511151E+04, 0.910E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.14030924E+04, 0.910E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.12403071E+04, 0.910E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.92324960E+03, 0.910E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.68729140E+03, 0.910E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.55412740E+03, 0.910E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.44044180E+03, 0.910E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.35207430E+03, 0.910E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.34570434E+04, 0.910E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.25892888E+04, 0.910E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.20945389E+04, 0.910E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.19869265E+04, 0.910E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.17996577E+04, 0.910E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.14173421E+04, 0.910E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.15251022E+04, 0.910E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.11941778E+04, 0.910E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.12344914E+04, 0.910E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.12859300E+04, 0.910E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.98684670E+03, 0.910E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.97668650E+03, 0.910E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.11699494E+04, 0.910E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.98664000E+03, 0.910E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.80937540E+03, 0.910E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.70943800E+03, 0.910E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.60630260E+03, 0.910E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.51614250E+03, 0.910E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.38488310E+04, 0.910E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.30987868E+04, 0.910E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.26179361E+04, 0.910E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.23009943E+04, 0.910E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.20684111E+04, 0.910E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.15587481E+04, 0.910E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.17549706E+04, 0.910E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.13015598E+04, 0.910E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.14207211E+04, 0.910E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.13053320E+04, 0.910E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.10968175E+04, 0.910E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.11367042E+04, 0.910E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.14690715E+04, 0.910E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.13085146E+04, 0.910E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.11258498E+04, 0.910E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.10231942E+04, 0.910E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.90511410E+03, 0.910E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.79733130E+03, 0.910E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.46916964E+04, 0.910E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.40037089E+04, 0.910E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.33915606E+04, 0.910E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.13396248E+04, 0.910E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.35059336E+04, 0.910E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.33442162E+04, 0.910E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.32544268E+04, 0.910E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.31724783E+04, 0.910E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.30996207E+04, 0.910E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.23450320E+04, 0.910E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.28084101E+04, 0.910E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.26917985E+04, 0.910E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.27690943E+04, 0.910E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.27073188E+04, 0.910E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.26503867E+04, 0.910E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.26234579E+04, 0.910E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.21538516E+04, 0.910E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.20393959E+04, 0.910E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.18205331E+04, 0.910E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.15133881E+04, 0.910E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.15256409E+04, 0.910E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.13566458E+04, 0.910E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.12236676E+04, 0.910E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.10014754E+04, 0.910E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.92999430E+03, 0.910E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.94896980E+03, 0.910E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.14976018E+04, 0.910E+02, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.14206996E+04, 0.910E+02, 0.820E+02, 0.00000000E+00, 0.00000000E+00,
  0.12642423E+04, 0.910E+02, 0.830E+02, 0.00000000E+00, 0.00000000E+00,
  0.11841627E+04, 0.910E+02, 0.840E+02, 0.00000000E+00, 0.00000000E+00,
  0.10698651E+04, 0.910E+02, 0.850E+02, 0.00000000E+00, 0.00000000E+00,
  0.96217680E+03, 0.910E+02, 0.860E+02, 0.00000000E+00, 0.00000000E+00,
  0.43039645E+04, 0.910E+02, 0.870E+02, 0.00000000E+00, 0.00000000E+00,
  0.38865716E+04, 0.910E+02, 0.880E+02, 0.00000000E+00, 0.00000000E+00,
  0.33200764E+04, 0.910E+02, 0.890E+02, 0.00000000E+00, 0.00000000E+00,
  0.28725136E+04, 0.910E+02, 0.900E+02, 0.00000000E+00, 0.00000000E+00,
  0.29089206E+04, 0.910E+02, 0.910E+02, 0.00000000E+00, 0.00000000E+00,
  0.78203400E+02, 0.920E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.48498000E+02, 0.920E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.16716156E+04, 0.920E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.82971320E+03, 0.920E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.51601950E+03, 0.920E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.32928020E+03, 0.920E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.22106590E+03, 0.920E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.16279260E+03, 0.920E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.12052900E+03, 0.920E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.91086900E+02, 0.920E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.19814675E+04, 0.920E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.13571628E+04, 0.920E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.12000275E+04, 0.920E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.89364440E+03, 0.920E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.66549650E+03, 0.920E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.53670890E+03, 0.920E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.42673540E+03, 0.920E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.34123400E+03, 0.920E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.33376961E+04, 0.920E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.25033576E+04, 0.920E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.20254740E+04, 0.920E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.19216819E+04, 0.920E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.17407294E+04, 0.920E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.13709264E+04, 0.920E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.14753669E+04, 0.920E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.11552737E+04, 0.920E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.11945389E+04, 0.920E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.12442037E+04, 0.920E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.95483090E+03, 0.920E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.94527750E+03, 0.920E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.11321107E+04, 0.920E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.95506070E+03, 0.920E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.78370690E+03, 0.920E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.68708390E+03, 0.920E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.58734500E+03, 0.920E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.50013680E+03, 0.920E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.37160678E+04, 0.920E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.29957186E+04, 0.920E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.25317373E+04, 0.920E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.22256807E+04, 0.920E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.20009439E+04, 0.920E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.15082494E+04, 0.920E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.16979484E+04, 0.920E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.12596142E+04, 0.920E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.13749665E+04, 0.920E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.12634136E+04, 0.920E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.10615457E+04, 0.920E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.11003399E+04, 0.920E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.14216099E+04, 0.920E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.12666329E+04, 0.920E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.10901053E+04, 0.920E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.99086960E+03, 0.920E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.87669020E+03, 0.920E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.77245190E+03, 0.920E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.45291727E+04, 0.920E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.38697611E+04, 0.920E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.32793360E+04, 0.920E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.12970461E+04, 0.920E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.33890395E+04, 0.920E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.32330975E+04, 0.920E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.31463690E+04, 0.920E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.30672053E+04, 0.920E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.29968237E+04, 0.920E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.22680138E+04, 0.920E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.27140296E+04, 0.920E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.26013226E+04, 0.920E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.26775672E+04, 0.920E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.26178718E+04, 0.920E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.25628645E+04, 0.920E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.25367915E+04, 0.920E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.20830385E+04, 0.920E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.19730821E+04, 0.920E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.17616844E+04, 0.920E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.14646529E+04, 0.920E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.14766337E+04, 0.920E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.13133066E+04, 0.920E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.11847530E+04, 0.920E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.96980220E+03, 0.920E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.90065620E+03, 0.920E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.91908240E+03, 0.920E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.14493061E+04, 0.920E+02, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.13752752E+04, 0.920E+02, 0.820E+02, 0.00000000E+00, 0.00000000E+00,
  0.12241322E+04, 0.920E+02, 0.830E+02, 0.00000000E+00, 0.00000000E+00,
  0.11467509E+04, 0.920E+02, 0.840E+02, 0.00000000E+00, 0.00000000E+00,
  0.10362496E+04, 0.920E+02, 0.850E+02, 0.00000000E+00, 0.00000000E+00,
  0.93211210E+03, 0.920E+02, 0.860E+02, 0.00000000E+00, 0.00000000E+00,
  0.41565121E+04, 0.920E+02, 0.870E+02, 0.00000000E+00, 0.00000000E+00,
  0.37572430E+04, 0.920E+02, 0.880E+02, 0.00000000E+00, 0.00000000E+00,
  0.32107560E+04, 0.920E+02, 0.890E+02, 0.00000000E+00, 0.00000000E+00,
  0.27789432E+04, 0.920E+02, 0.900E+02, 0.00000000E+00, 0.00000000E+00,
  0.28136269E+04, 0.920E+02, 0.910E+02, 0.00000000E+00, 0.00000000E+00,
  0.27215209E+04, 0.920E+02, 0.920E+02, 0.00000000E+00, 0.00000000E+00,
  0.79439100E+02, 0.930E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.48724100E+02, 0.930E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.18005066E+04, 0.930E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.86956410E+03, 0.930E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.53289880E+03, 0.930E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.33646270E+03, 0.930E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.22420940E+03, 0.930E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.16429590E+03, 0.930E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.12116670E+03, 0.930E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.91309000E+02, 0.930E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.21313007E+04, 0.930E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.14294308E+04, 0.930E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.12543604E+04, 0.930E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.92419700E+03, 0.930E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.68227500E+03, 0.930E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.54731890E+03, 0.930E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.43301050E+03, 0.930E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.34483050E+03, 0.930E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.36085602E+04, 0.930E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.26611178E+04, 0.930E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.21449232E+04, 0.930E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.20287846E+04, 0.930E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.18341800E+04, 0.930E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.14450682E+04, 0.930E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.15501899E+04, 0.930E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.12138708E+04, 0.930E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.12487909E+04, 0.930E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.13033334E+04, 0.930E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.10009549E+04, 0.930E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.98372150E+03, 0.930E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.11804499E+04, 0.930E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.98737510E+03, 0.930E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.80425620E+03, 0.930E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.70203110E+03, 0.930E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.59750350E+03, 0.930E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.50682160E+03, 0.930E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.40138973E+04, 0.930E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.31875734E+04, 0.930E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.26766472E+04, 0.930E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.23437586E+04, 0.930E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.21018417E+04, 0.930E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.15778736E+04, 0.930E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.17790323E+04, 0.930E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.13137158E+04, 0.930E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.14331563E+04, 0.930E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.13146561E+04, 0.930E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.11068617E+04, 0.930E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.11425196E+04, 0.930E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.14840150E+04, 0.930E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.13126653E+04, 0.930E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.11221440E+04, 0.930E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.10160025E+04, 0.930E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.89523210E+03, 0.930E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.78580380E+03, 0.930E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.48930436E+04, 0.930E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.41279330E+04, 0.930E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.34757124E+04, 0.930E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.13372850E+04, 0.930E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.36078825E+04, 0.930E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.34378544E+04, 0.930E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.33445279E+04, 0.930E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.32594431E+04, 0.930E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.31837627E+04, 0.930E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.23935584E+04, 0.930E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.28964080E+04, 0.930E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.27730351E+04, 0.930E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.28396469E+04, 0.930E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.27757424E+04, 0.930E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.27166522E+04, 0.930E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.26897033E+04, 0.930E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.21986632E+04, 0.930E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.20680029E+04, 0.930E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.18390464E+04, 0.930E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.15251115E+04, 0.930E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.15347972E+04, 0.930E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.13602378E+04, 0.930E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.12236448E+04, 0.930E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.99920960E+03, 0.930E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.92702850E+03, 0.930E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.94428620E+03, 0.930E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.15116714E+04, 0.930E+02, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.14258266E+04, 0.930E+02, 0.820E+02, 0.00000000E+00, 0.00000000E+00,
  0.12612415E+04, 0.930E+02, 0.830E+02, 0.00000000E+00, 0.00000000E+00,
  0.11774038E+04, 0.930E+02, 0.840E+02, 0.00000000E+00, 0.00000000E+00,
  0.10596377E+04, 0.930E+02, 0.850E+02, 0.00000000E+00, 0.00000000E+00,
  0.94975540E+03, 0.930E+02, 0.860E+02, 0.00000000E+00, 0.00000000E+00,
  0.44697774E+04, 0.930E+02, 0.870E+02, 0.00000000E+00, 0.00000000E+00,
  0.39952606E+04, 0.930E+02, 0.880E+02, 0.00000000E+00, 0.00000000E+00,
  0.33932601E+04, 0.930E+02, 0.890E+02, 0.00000000E+00, 0.00000000E+00,
  0.29170992E+04, 0.930E+02, 0.900E+02, 0.00000000E+00, 0.00000000E+00,
  0.29646668E+04, 0.930E+02, 0.910E+02, 0.00000000E+00, 0.00000000E+00,
  0.28671025E+04, 0.930E+02, 0.920E+02, 0.00000000E+00, 0.00000000E+00,
  0.30329760E+04, 0.930E+02, 0.930E+02, 0.00000000E+00, 0.00000000E+00,
  0.77102100E+02, 0.940E+02, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.47379800E+02, 0.940E+02, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.17278140E+04, 0.940E+02, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.83944780E+03, 0.940E+02, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.51579770E+03, 0.940E+02, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.32625000E+03, 0.940E+02, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.21767650E+03, 0.940E+02, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.15964350E+03, 0.940E+02, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.11781930E+03, 0.940E+02, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.88836500E+02, 0.940E+02, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.20459284E+04, 0.940E+02, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.13785876E+04, 0.940E+02, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.12114443E+04, 0.940E+02, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.89432550E+03, 0.940E+02, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.66120920E+03, 0.940E+02, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.53088280E+03, 0.940E+02, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.42034980E+03, 0.940E+02, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.33497590E+03, 0.940E+02, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.34586883E+04, 0.940E+02, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.25612750E+04, 0.940E+02, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.20661768E+04, 0.940E+02, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.19554505E+04, 0.940E+02, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.17685649E+04, 0.940E+02, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.13931385E+04, 0.940E+02, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.14955657E+04, 0.940E+02, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.11710013E+04, 0.940E+02, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.12060158E+04, 0.940E+02, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.12582170E+04, 0.940E+02, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.96605990E+03, 0.940E+02, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.95086030E+03, 0.940E+02, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.11405197E+04, 0.940E+02, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.95550390E+03, 0.940E+02, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.77929760E+03, 0.940E+02, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.68073550E+03, 0.940E+02, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.57979560E+03, 0.940E+02, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.49211280E+03, 0.940E+02, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.38477324E+04, 0.940E+02, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.30671463E+04, 0.940E+02, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.25790022E+04, 0.940E+02, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.22600639E+04, 0.940E+02, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.20277440E+04, 0.940E+02, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.15233742E+04, 0.940E+02, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.17171041E+04, 0.940E+02, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.12690647E+04, 0.940E+02, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.13847315E+04, 0.940E+02, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.12706578E+04, 0.940E+02, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.10692791E+04, 0.940E+02, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.11047467E+04, 0.940E+02, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.14334370E+04, 0.940E+02, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.12697368E+04, 0.940E+02, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.10867671E+04, 0.940E+02, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.98462910E+03, 0.940E+02, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.86818680E+03, 0.940E+02, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.76254070E+03, 0.940E+02, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.46894909E+04, 0.940E+02, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.39694488E+04, 0.940E+02, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.33469278E+04, 0.940E+02, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.12946997E+04, 0.940E+02, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.34708103E+04, 0.940E+02, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.33082782E+04, 0.940E+02, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.32187253E+04, 0.940E+02, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.31370576E+04, 0.940E+02, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.30644224E+04, 0.940E+02, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.23068366E+04, 0.940E+02, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.27842586E+04, 0.940E+02, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.26660816E+04, 0.940E+02, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.27342974E+04, 0.940E+02, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.26729042E+04, 0.940E+02, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.26161724E+04, 0.940E+02, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.25900957E+04, 0.940E+02, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.21189811E+04, 0.940E+02, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.19960266E+04, 0.940E+02, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.17764187E+04, 0.940E+02, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.14737544E+04, 0.940E+02, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.14836747E+04, 0.940E+02, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.13158080E+04, 0.940E+02, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.11842955E+04, 0.940E+02, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.96746430E+03, 0.940E+02, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.89773860E+03, 0.940E+02, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.91479120E+03, 0.940E+02, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.14602247E+04, 0.940E+02, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.13790263E+04, 0.940E+02, 0.820E+02, 0.00000000E+00, 0.00000000E+00,
  0.12212647E+04, 0.940E+02, 0.830E+02, 0.00000000E+00, 0.00000000E+00,
  0.11407827E+04, 0.940E+02, 0.840E+02, 0.00000000E+00, 0.00000000E+00,
  0.10273948E+04, 0.940E+02, 0.850E+02, 0.00000000E+00, 0.00000000E+00,
  0.92140470E+03, 0.940E+02, 0.860E+02, 0.00000000E+00, 0.00000000E+00,
  0.42885858E+04, 0.940E+02, 0.870E+02, 0.00000000E+00, 0.00000000E+00,
  0.38444325E+04, 0.940E+02, 0.880E+02, 0.00000000E+00, 0.00000000E+00,
  0.32695288E+04, 0.940E+02, 0.890E+02, 0.00000000E+00, 0.00000000E+00,
  0.28146033E+04, 0.940E+02, 0.900E+02, 0.00000000E+00, 0.00000000E+00,
  0.28581875E+04, 0.940E+02, 0.910E+02, 0.00000000E+00, 0.00000000E+00,
  0.27642585E+04, 0.940E+02, 0.920E+02, 0.00000000E+00, 0.00000000E+00,
  0.29218223E+04, 0.940E+02, 0.930E+02, 0.00000000E+00, 0.00000000E+00,
  0.28152366E+04, 0.940E+02, 0.940E+02, 0.00000000E+00, 0.00000000E+00,
  0.47379000E+01, 0.101E+03, 0.100E+01, 0.00000000E+00, 0.91180000E+00,
  0.31287000E+01, 0.101E+03, 0.200E+01, 0.00000000E+00, 0.00000000E+00,
  0.68939100E+02, 0.101E+03, 0.300E+01, 0.00000000E+00, 0.00000000E+00,
  0.41307800E+02, 0.101E+03, 0.400E+01, 0.00000000E+00, 0.00000000E+00,
  0.28276700E+02, 0.101E+03, 0.500E+01, 0.00000000E+00, 0.00000000E+00,
  0.19265300E+02, 0.101E+03, 0.600E+01, 0.00000000E+00, 0.00000000E+00,
  0.13516400E+02, 0.101E+03, 0.700E+01, 0.00000000E+00, 0.00000000E+00,
  0.10237100E+02, 0.101E+03, 0.800E+01, 0.00000000E+00, 0.00000000E+00,
  0.77441000E+01, 0.101E+03, 0.900E+01, 0.00000000E+00, 0.00000000E+00,
  0.59403000E+01, 0.101E+03, 0.100E+02, 0.00000000E+00, 0.00000000E+00,
  0.82564100E+02, 0.101E+03, 0.110E+02, 0.00000000E+00, 0.00000000E+00,
  0.65370300E+02, 0.101E+03, 0.120E+02, 0.00000000E+00, 0.00000000E+00,
  0.60855800E+02, 0.101E+03, 0.130E+02, 0.00000000E+00, 0.00000000E+00,
  0.48518200E+02, 0.101E+03, 0.140E+02, 0.00000000E+00, 0.00000000E+00,
  0.38139700E+02, 0.101E+03, 0.150E+02, 0.00000000E+00, 0.00000000E+00,
  0.31771300E+02, 0.101E+03, 0.160E+02, 0.00000000E+00, 0.00000000E+00,
  0.26017000E+02, 0.101E+03, 0.170E+02, 0.00000000E+00, 0.00000000E+00,
  0.21305500E+02, 0.101E+03, 0.180E+02, 0.00000000E+00, 0.00000000E+00,
  0.13444410E+03, 0.101E+03, 0.190E+02, 0.00000000E+00, 0.00000000E+00,
  0.11348570E+03, 0.101E+03, 0.200E+02, 0.00000000E+00, 0.00000000E+00,
  0.94208300E+02, 0.101E+03, 0.210E+02, 0.00000000E+00, 0.00000000E+00,
  0.91333400E+02, 0.101E+03, 0.220E+02, 0.00000000E+00, 0.00000000E+00,
  0.83831300E+02, 0.101E+03, 0.230E+02, 0.00000000E+00, 0.00000000E+00,
  0.65983700E+02, 0.101E+03, 0.240E+02, 0.00000000E+00, 0.00000000E+00,
  0.72411100E+02, 0.101E+03, 0.250E+02, 0.00000000E+00, 0.00000000E+00,
  0.56799300E+02, 0.101E+03, 0.260E+02, 0.00000000E+00, 0.00000000E+00,
  0.60574600E+02, 0.101E+03, 0.270E+02, 0.00000000E+00, 0.00000000E+00,
  0.62253200E+02, 0.101E+03, 0.280E+02, 0.00000000E+00, 0.00000000E+00,
  0.47649900E+02, 0.101E+03, 0.290E+02, 0.00000000E+00, 0.00000000E+00,
  0.49346900E+02, 0.101E+03, 0.300E+02, 0.00000000E+00, 0.00000000E+00,
  0.58420700E+02, 0.101E+03, 0.310E+02, 0.00000000E+00, 0.00000000E+00,
  0.51990500E+02, 0.101E+03, 0.320E+02, 0.00000000E+00, 0.00000000E+00,
  0.44651200E+02, 0.101E+03, 0.330E+02, 0.00000000E+00, 0.00000000E+00,
  0.40201000E+02, 0.101E+03, 0.340E+02, 0.00000000E+00, 0.00000000E+00,
  0.35274000E+02, 0.101E+03, 0.350E+02, 0.00000000E+00, 0.00000000E+00,
  0.30726100E+02, 0.101E+03, 0.360E+02, 0.00000000E+00, 0.00000000E+00,
  0.15093400E+03, 0.101E+03, 0.370E+02, 0.00000000E+00, 0.00000000E+00,
  0.13506640E+03, 0.101E+03, 0.380E+02, 0.00000000E+00, 0.00000000E+00,
  0.11929610E+03, 0.101E+03, 0.390E+02, 0.00000000E+00, 0.00000000E+00,
  0.10773060E+03, 0.101E+03, 0.400E+02, 0.00000000E+00, 0.00000000E+00,
  0.98518300E+02, 0.101E+03, 0.410E+02, 0.00000000E+00, 0.00000000E+00,
  0.76366100E+02, 0.101E+03, 0.420E+02, 0.00000000E+00, 0.00000000E+00,
  0.85080000E+02, 0.101E+03, 0.430E+02, 0.00000000E+00, 0.00000000E+00,
  0.65086300E+02, 0.101E+03, 0.440E+02, 0.00000000E+00, 0.00000000E+00,
  0.71198500E+02, 0.101E+03, 0.450E+02, 0.00000000E+00, 0.00000000E+00,
  0.66121100E+02, 0.101E+03, 0.460E+02, 0.00000000E+00, 0.00000000E+00,
  0.54965800E+02, 0.101E+03, 0.470E+02, 0.00000000E+00, 0.00000000E+00,
  0.58356800E+02, 0.101E+03, 0.480E+02, 0.00000000E+00, 0.00000000E+00,
  0.72907600E+02, 0.101E+03, 0.490E+02, 0.00000000E+00, 0.00000000E+00,
  0.67943000E+02, 0.101E+03, 0.500E+02, 0.00000000E+00, 0.00000000E+00,
  0.60947000E+02, 0.101E+03, 0.510E+02, 0.00000000E+00, 0.00000000E+00,
  0.56742700E+02, 0.101E+03, 0.520E+02, 0.00000000E+00, 0.00000000E+00,
  0.51465600E+02, 0.101E+03, 0.530E+02, 0.00000000E+00, 0.00000000E+00,
  0.46379400E+02, 0.101E+03, 0.540E+02, 0.00000000E+00, 0.00000000E+00,
  0.18402230E+03, 0.101E+03, 0.550E+02, 0.00000000E+00, 0.00000000E+00,
  0.17170330E+03, 0.101E+03, 0.560E+02, 0.00000000E+00, 0.00000000E+00,
  0.15211060E+03, 0.101E+03, 0.570E+02, 0.00000000E+00, 0.00000000E+00,
  0.71883000E+02, 0.101E+03, 0.580E+02, 0.00000000E+00, 0.27991000E+01,
  0.15245020E+03, 0.101E+03, 0.590E+02, 0.00000000E+00, 0.00000000E+00,
  0.14658510E+03, 0.101E+03, 0.600E+02, 0.00000000E+00, 0.00000000E+00,
  0.14296200E+03, 0.101E+03, 0.610E+02, 0.00000000E+00, 0.00000000E+00,
  0.13962540E+03, 0.101E+03, 0.620E+02, 0.00000000E+00, 0.00000000E+00,
  0.13666950E+03, 0.101E+03, 0.630E+02, 0.00000000E+00, 0.00000000E+00,
  0.10836620E+03, 0.101E+03, 0.640E+02, 0.00000000E+00, 0.00000000E+00,
  0.12040560E+03, 0.101E+03, 0.650E+02, 0.00000000E+00, 0.00000000E+00,
  0.11631780E+03, 0.101E+03, 0.660E+02, 0.00000000E+00, 0.00000000E+00,
  0.12352200E+03, 0.101E+03, 0.670E+02, 0.00000000E+00, 0.00000000E+00,
  0.12093020E+03, 0.101E+03, 0.680E+02, 0.00000000E+00, 0.00000000E+00,
  0.11860700E+03, 0.101E+03, 0.690E+02, 0.00000000E+00, 0.00000000E+00,
  0.11718110E+03, 0.101E+03, 0.700E+02, 0.00000000E+00, 0.00000000E+00,
  0.99298400E+02, 0.101E+03, 0.710E+02, 0.00000000E+00, 0.00000000E+00,
  0.98513600E+02, 0.101E+03, 0.720E+02, 0.00000000E+00, 0.00000000E+00,
  0.90285800E+02, 0.101E+03, 0.730E+02, 0.00000000E+00, 0.00000000E+00,
  0.76415000E+02, 0.101E+03, 0.740E+02, 0.00000000E+00, 0.00000000E+00,
  0.77879300E+02, 0.101E+03, 0.750E+02, 0.00000000E+00, 0.00000000E+00,
  0.70802400E+02, 0.101E+03, 0.760E+02, 0.00000000E+00, 0.00000000E+00,
  0.64989000E+02, 0.101E+03, 0.770E+02, 0.00000000E+00, 0.00000000E+00,
  0.54045100E+02, 0.101E+03, 0.780E+02, 0.00000000E+00, 0.00000000E+00,
  0.50508600E+02, 0.101E+03, 0.790E+02, 0.00000000E+00, 0.00000000E+00,
  0.52054700E+02, 0.101E+03, 0.800E+02, 0.00000000E+00, 0.00000000E+00,
  0.74881700E+02, 0.101E+03, 0.810E+02, 0.00000000E+00, 0.00000000E+00,
  0.73669200E+02, 0.101E+03, 0.820E+02, 0.00000000E+00, 0.00000000E+00,
  0.68103100E+02, 0.101E+03, 0.830E+02, 0.00000000E+00, 0.00000000E+00,
  0.65160500E+02, 0.101E+03, 0.840E+02, 0.00000000E+00, 0.00000000E+00,
  0.60333800E+02, 0.101E+03, 0.850E+02, 0.00000000E+00, 0.00000000E+00,
  0.55434500E+02, 0.101E+03, 0.860E+02, 0.00000000E+00, 0.00000000E+00,
  0.17492120E+03, 0.101E+03, 0.870E+02, 0.00000000E+00, 0.00000000E+00,
  0.17050820E+03, 0.101E+03, 0.880E+02, 0.00000000E+00, 0.00000000E+00,
  0.15181390E+03, 0.101E+03, 0.890E+02, 0.00000000E+00, 0.00000000E+00,
  0.13747240E+03, 0.101E+03, 0.900E+02, 0.00000000E+00, 0.00000000E+00,
  0.13587010E+03, 0.101E+03, 0.910E+02, 0.00000000E+00, 0.00000000E+00,
  0.13156440E+03, 0.101E+03, 0.920E+02, 0.00000000E+00, 0.00000000E+00,
  0.13473040E+03, 0.101E+03, 0.930E+02, 0.00000000E+00, 0.00000000E+00,
  0.13059460E+03, 0.101E+03, 0.940E+02, 0.00000000E+00, 0.00000000E+00,
  0.75916000E+01, 0.101E+03, 0.101E+03, 0.00000000E+00, 0.00000000E+00,
  0.14316500E+02, 0.103E+03, 0.100E+01, 0.98650000E+00, 0.91180000E+00,
  0.87773000E+01, 0.103E+03, 0.200E+01, 0.98650000E+00, 0.00000000E+00,
  0.28221060E+03, 0.103E+03, 0.300E+01, 0.98650000E+00, 0.00000000E+00,
  0.14813230E+03, 0.103E+03, 0.400E+01, 0.98650000E+00, 0.00000000E+00,
  0.93672900E+02, 0.103E+03, 0.500E+01, 0.98650000E+00, 0.00000000E+00,
  0.60086000E+02, 0.103E+03, 0.600E+01, 0.98650000E+00, 0.00000000E+00,
  0.40294400E+02, 0.103E+03, 0.700E+01, 0.98650000E+00, 0.00000000E+00,
  0.29557500E+02, 0.103E+03, 0.800E+01, 0.98650000E+00, 0.00000000E+00,
  0.21760500E+02, 0.103E+03, 0.900E+01, 0.98650000E+00, 0.00000000E+00,
  0.16338800E+02, 0.103E+03, 0.100E+02, 0.98650000E+00, 0.00000000E+00,
  0.33534500E+03, 0.103E+03, 0.110E+02, 0.98650000E+00, 0.00000000E+00,
  0.24016270E+03, 0.103E+03, 0.120E+02, 0.98650000E+00, 0.00000000E+00,
  0.21472650E+03, 0.103E+03, 0.130E+02, 0.98650000E+00, 0.00000000E+00,
  0.16205080E+03, 0.103E+03, 0.140E+02, 0.98650000E+00, 0.00000000E+00,
  0.12150670E+03, 0.103E+03, 0.150E+02, 0.98650000E+00, 0.00000000E+00,
  0.98124900E+02, 0.103E+03, 0.160E+02, 0.98650000E+00, 0.00000000E+00,
  0.77986500E+02, 0.103E+03, 0.170E+02, 0.98650000E+00, 0.00000000E+00,
  0.62220500E+02, 0.103E+03, 0.180E+02, 0.98650000E+00, 0.00000000E+00,
  0.55515160E+03, 0.103E+03, 0.190E+02, 0.98650000E+00, 0.00000000E+00,
  0.43415760E+03, 0.103E+03, 0.200E+02, 0.98650000E+00, 0.00000000E+00,
  0.35403170E+03, 0.103E+03, 0.210E+02, 0.98650000E+00, 0.00000000E+00,
  0.33738960E+03, 0.103E+03, 0.220E+02, 0.98650000E+00, 0.00000000E+00,
  0.30654820E+03, 0.103E+03, 0.230E+02, 0.98650000E+00, 0.00000000E+00,
  0.24050330E+03, 0.103E+03, 0.240E+02, 0.98650000E+00, 0.00000000E+00,
  0.26090190E+03, 0.103E+03, 0.250E+02, 0.98650000E+00, 0.00000000E+00,
  0.20361490E+03, 0.103E+03, 0.260E+02, 0.98650000E+00, 0.00000000E+00,
  0.21289780E+03, 0.103E+03, 0.270E+02, 0.98650000E+00, 0.00000000E+00,
  0.22117390E+03, 0.103E+03, 0.280E+02, 0.98650000E+00, 0.00000000E+00,
  0.16880750E+03, 0.103E+03, 0.290E+02, 0.98650000E+00, 0.00000000E+00,
  0.16949490E+03, 0.103E+03, 0.300E+02, 0.98650000E+00, 0.00000000E+00,
  0.20269000E+03, 0.103E+03, 0.310E+02, 0.98650000E+00, 0.00000000E+00,
  0.17294250E+03, 0.103E+03, 0.320E+02, 0.98650000E+00, 0.00000000E+00,
  0.14284710E+03, 0.103E+03, 0.330E+02, 0.98650000E+00, 0.00000000E+00,
  0.12547680E+03, 0.103E+03, 0.340E+02, 0.98650000E+00, 0.00000000E+00,
  0.10733800E+03, 0.103E+03, 0.350E+02, 0.98650000E+00, 0.00000000E+00,
  0.91333300E+02, 0.103E+03, 0.360E+02, 0.98650000E+00, 0.00000000E+00,
  0.61856810E+03, 0.103E+03, 0.370E+02, 0.98650000E+00, 0.00000000E+00,
  0.51783930E+03, 0.103E+03, 0.380E+02, 0.98650000E+00, 0.00000000E+00,
  0.44294480E+03, 0.103E+03, 0.390E+02, 0.98650000E+00, 0.00000000E+00,
  0.39191790E+03, 0.103E+03, 0.400E+02, 0.98650000E+00, 0.00000000E+00,
  0.35350080E+03, 0.103E+03, 0.410E+02, 0.98650000E+00, 0.00000000E+00,
  0.26737610E+03, 0.103E+03, 0.420E+02, 0.98650000E+00, 0.00000000E+00,
  0.30065330E+03, 0.103E+03, 0.430E+02, 0.98650000E+00, 0.00000000E+00,
  0.22388710E+03, 0.103E+03, 0.440E+02, 0.98650000E+00, 0.00000000E+00,
  0.24525610E+03, 0.103E+03, 0.450E+02, 0.98650000E+00, 0.00000000E+00,
  0.22580420E+03, 0.103E+03, 0.460E+02, 0.98650000E+00, 0.00000000E+00,
  0.18833740E+03, 0.103E+03, 0.470E+02, 0.98650000E+00, 0.00000000E+00,
  0.19709400E+03, 0.103E+03, 0.480E+02, 0.98650000E+00, 0.00000000E+00,
  0.25313700E+03, 0.103E+03, 0.490E+02, 0.98650000E+00, 0.00000000E+00,
  0.22808140E+03, 0.103E+03, 0.500E+02, 0.98650000E+00, 0.00000000E+00,
  0.19776980E+03, 0.103E+03, 0.510E+02, 0.98650000E+00, 0.00000000E+00,
  0.18030560E+03, 0.103E+03, 0.520E+02, 0.98650000E+00, 0.00000000E+00,
  0.15986700E+03, 0.103E+03, 0.530E+02, 0.98650000E+00, 0.00000000E+00,
  0.14098180E+03, 0.103E+03, 0.540E+02, 0.98650000E+00, 0.00000000E+00,
  0.75234180E+03, 0.103E+03, 0.550E+02, 0.98650000E+00, 0.00000000E+00,
  0.66457190E+03, 0.103E+03, 0.560E+02, 0.98650000E+00, 0.00000000E+00,
  0.57042660E+03, 0.103E+03, 0.570E+02, 0.98650000E+00, 0.00000000E+00,
  0.23452710E+03, 0.103E+03, 0.580E+02, 0.98650000E+00, 0.27991000E+01,
  0.58397970E+03, 0.103E+03, 0.590E+02, 0.98650000E+00, 0.00000000E+00,
  0.55869720E+03, 0.103E+03, 0.600E+02, 0.98650000E+00, 0.00000000E+00,
  0.54412320E+03, 0.103E+03, 0.610E+02, 0.98650000E+00, 0.00000000E+00,
  0.53079090E+03, 0.103E+03, 0.620E+02, 0.98650000E+00, 0.00000000E+00,
  0.51894980E+03, 0.103E+03, 0.630E+02, 0.98650000E+00, 0.00000000E+00,
  0.39672230E+03, 0.103E+03, 0.640E+02, 0.98650000E+00, 0.00000000E+00,
  0.46354420E+03, 0.103E+03, 0.650E+02, 0.98650000E+00, 0.00000000E+00,
  0.44501010E+03, 0.103E+03, 0.660E+02, 0.98650000E+00, 0.00000000E+00,
  0.46541000E+03, 0.103E+03, 0.670E+02, 0.98650000E+00, 0.00000000E+00,
  0.45528270E+03, 0.103E+03, 0.680E+02, 0.98650000E+00, 0.00000000E+00,
  0.44600300E+03, 0.103E+03, 0.690E+02, 0.98650000E+00, 0.00000000E+00,
  0.44132200E+03, 0.103E+03, 0.700E+02, 0.98650000E+00, 0.00000000E+00,
  0.36474670E+03, 0.103E+03, 0.710E+02, 0.98650000E+00, 0.00000000E+00,
  0.35006170E+03, 0.103E+03, 0.720E+02, 0.98650000E+00, 0.00000000E+00,
  0.31424830E+03, 0.103E+03, 0.730E+02, 0.98650000E+00, 0.00000000E+00,
  0.26138330E+03, 0.103E+03, 0.740E+02, 0.98650000E+00, 0.00000000E+00,
  0.26436970E+03, 0.103E+03, 0.750E+02, 0.98650000E+00, 0.00000000E+00,
  0.23602580E+03, 0.103E+03, 0.760E+02, 0.98650000E+00, 0.00000000E+00,
  0.21346440E+03, 0.103E+03, 0.770E+02, 0.98650000E+00, 0.00000000E+00,
  0.17461320E+03, 0.103E+03, 0.780E+02, 0.98650000E+00, 0.00000000E+00,
  0.16213420E+03, 0.103E+03, 0.790E+02, 0.98650000E+00, 0.00000000E+00,
  0.16604890E+03, 0.103E+03, 0.800E+02, 0.98650000E+00, 0.00000000E+00,
  0.25738230E+03, 0.103E+03, 0.810E+02, 0.98650000E+00, 0.00000000E+00,
  0.24683550E+03, 0.103E+03, 0.820E+02, 0.98650000E+00, 0.00000000E+00,
  0.22143250E+03, 0.103E+03, 0.830E+02, 0.98650000E+00, 0.00000000E+00,
  0.20812690E+03, 0.103E+03, 0.840E+02, 0.98650000E+00, 0.00000000E+00,
  0.18860730E+03, 0.103E+03, 0.850E+02, 0.98650000E+00, 0.00000000E+00,
  0.16989430E+03, 0.103E+03, 0.860E+02, 0.98650000E+00, 0.00000000E+00,
  0.69764490E+03, 0.103E+03, 0.870E+02, 0.98650000E+00, 0.00000000E+00,
  0.64903250E+03, 0.103E+03, 0.880E+02, 0.98650000E+00, 0.00000000E+00,
  0.56135190E+03, 0.103E+03, 0.890E+02, 0.98650000E+00, 0.00000000E+00,
  0.49107770E+03, 0.103E+03, 0.900E+02, 0.98650000E+00, 0.00000000E+00,
  0.49346510E+03, 0.103E+03, 0.910E+02, 0.98650000E+00, 0.00000000E+00,
  0.47742540E+03, 0.103E+03, 0.920E+02, 0.98650000E+00, 0.00000000E+00,
  0.49952020E+03, 0.103E+03, 0.930E+02, 0.98650000E+00, 0.00000000E+00,
  0.48234660E+03, 0.103E+03, 0.940E+02, 0.98650000E+00, 0.00000000E+00,
  0.24057300E+02, 0.103E+03, 0.101E+03, 0.98650000E+00, 0.00000000E+00,
  0.85319700E+02, 0.103E+03, 0.103E+03, 0.98650000E+00, 0.98650000E+00,
  0.18465600E+02, 0.104E+03, 0.100E+01, 0.98080000E+00, 0.91180000E+00,
  0.11465500E+02, 0.104E+03, 0.200E+01, 0.98080000E+00, 0.00000000E+00,
  0.35221600E+03, 0.104E+03, 0.300E+01, 0.98080000E+00, 0.00000000E+00,
  0.18634530E+03, 0.104E+03, 0.400E+01, 0.98080000E+00, 0.00000000E+00,
  0.11908150E+03, 0.104E+03, 0.500E+01, 0.98080000E+00, 0.00000000E+00,
  0.77095100E+02, 0.104E+03, 0.600E+01, 0.98080000E+00, 0.00000000E+00,
  0.52085200E+02, 0.104E+03, 0.700E+01, 0.98080000E+00, 0.00000000E+00,
  0.38413200E+02, 0.104E+03, 0.800E+01, 0.98080000E+00, 0.00000000E+00,
  0.28409800E+02, 0.104E+03, 0.900E+01, 0.98080000E+00, 0.00000000E+00,
  0.21406700E+02, 0.104E+03, 0.100E+02, 0.98080000E+00, 0.00000000E+00,
  0.41864880E+03, 0.104E+03, 0.110E+02, 0.98080000E+00, 0.00000000E+00,
  0.30137770E+03, 0.104E+03, 0.120E+02, 0.98080000E+00, 0.00000000E+00,
  0.27074610E+03, 0.104E+03, 0.130E+02, 0.98080000E+00, 0.00000000E+00,
  0.20575440E+03, 0.104E+03, 0.140E+02, 0.98080000E+00, 0.00000000E+00,
  0.15536440E+03, 0.104E+03, 0.150E+02, 0.98080000E+00, 0.00000000E+00,
  0.12609930E+03, 0.104E+03, 0.160E+02, 0.98080000E+00, 0.00000000E+00,
  0.10072120E+03, 0.104E+03, 0.170E+02, 0.98080000E+00, 0.00000000E+00,
  0.80717400E+02, 0.104E+03, 0.180E+02, 0.98080000E+00, 0.00000000E+00,
  0.69485960E+03, 0.104E+03, 0.190E+02, 0.98080000E+00, 0.00000000E+00,
  0.54358420E+03, 0.104E+03, 0.200E+02, 0.98080000E+00, 0.00000000E+00,
  0.44371900E+03, 0.104E+03, 0.210E+02, 0.98080000E+00, 0.00000000E+00,
  0.42362170E+03, 0.104E+03, 0.220E+02, 0.98080000E+00, 0.00000000E+00,
  0.38527540E+03, 0.104E+03, 0.230E+02, 0.98080000E+00, 0.00000000E+00,
  0.30260610E+03, 0.104E+03, 0.240E+02, 0.98080000E+00, 0.00000000E+00,
  0.32840120E+03, 0.104E+03, 0.250E+02, 0.98080000E+00, 0.00000000E+00,
  0.25660430E+03, 0.104E+03, 0.260E+02, 0.98080000E+00, 0.00000000E+00,
  0.26862840E+03, 0.104E+03, 0.270E+02, 0.98080000E+00, 0.00000000E+00,
  0.27871160E+03, 0.104E+03, 0.280E+02, 0.98080000E+00, 0.00000000E+00,
  0.21297970E+03, 0.104E+03, 0.290E+02, 0.98080000E+00, 0.00000000E+00,
  0.21442560E+03, 0.104E+03, 0.300E+02, 0.98080000E+00, 0.00000000E+00,
  0.25620490E+03, 0.104E+03, 0.310E+02, 0.98080000E+00, 0.00000000E+00,
  0.21973750E+03, 0.104E+03, 0.320E+02, 0.98080000E+00, 0.00000000E+00,
  0.18253380E+03, 0.104E+03, 0.330E+02, 0.98080000E+00, 0.00000000E+00,
  0.16096870E+03, 0.104E+03, 0.340E+02, 0.98080000E+00, 0.00000000E+00,
  0.13827470E+03, 0.104E+03, 0.350E+02, 0.98080000E+00, 0.00000000E+00,
  0.11812400E+03, 0.104E+03, 0.360E+02, 0.98080000E+00, 0.00000000E+00,
  0.77496560E+03, 0.104E+03, 0.370E+02, 0.98080000E+00, 0.00000000E+00,
  0.64864220E+03, 0.104E+03, 0.380E+02, 0.98080000E+00, 0.00000000E+00,
  0.55615030E+03, 0.104E+03, 0.390E+02, 0.98080000E+00, 0.00000000E+00,
  0.49301000E+03, 0.104E+03, 0.400E+02, 0.98080000E+00, 0.00000000E+00,
  0.44537360E+03, 0.104E+03, 0.410E+02, 0.98080000E+00, 0.00000000E+00,
  0.33790350E+03, 0.104E+03, 0.420E+02, 0.98080000E+00, 0.00000000E+00,
  0.37952540E+03, 0.104E+03, 0.430E+02, 0.98080000E+00, 0.00000000E+00,
  0.28356950E+03, 0.104E+03, 0.440E+02, 0.98080000E+00, 0.00000000E+00,
  0.31037810E+03, 0.104E+03, 0.450E+02, 0.98080000E+00, 0.00000000E+00,
  0.28603950E+03, 0.104E+03, 0.460E+02, 0.98080000E+00, 0.00000000E+00,
  0.23869620E+03, 0.104E+03, 0.470E+02, 0.98080000E+00, 0.00000000E+00,
  0.24999150E+03, 0.104E+03, 0.480E+02, 0.98080000E+00, 0.00000000E+00,
  0.32009120E+03, 0.104E+03, 0.490E+02, 0.98080000E+00, 0.00000000E+00,
  0.28947130E+03, 0.104E+03, 0.500E+02, 0.98080000E+00, 0.00000000E+00,
  0.25216490E+03, 0.104E+03, 0.510E+02, 0.98080000E+00, 0.00000000E+00,
  0.23063090E+03, 0.104E+03, 0.520E+02, 0.98080000E+00, 0.00000000E+00,
  0.20522370E+03, 0.104E+03, 0.530E+02, 0.98080000E+00, 0.00000000E+00,
  0.18162600E+03, 0.104E+03, 0.540E+02, 0.98080000E+00, 0.00000000E+00,
  0.94385470E+03, 0.104E+03, 0.550E+02, 0.98080000E+00, 0.00000000E+00,
  0.83262510E+03, 0.104E+03, 0.560E+02, 0.98080000E+00, 0.00000000E+00,
  0.71607580E+03, 0.104E+03, 0.570E+02, 0.98080000E+00, 0.00000000E+00,
  0.29887820E+03, 0.104E+03, 0.580E+02, 0.98080000E+00, 0.27991000E+01,
  0.73216420E+03, 0.104E+03, 0.590E+02, 0.98080000E+00, 0.00000000E+00,
  0.70044420E+03, 0.104E+03, 0.600E+02, 0.98080000E+00, 0.00000000E+00,
  0.68219010E+03, 0.104E+03, 0.610E+02, 0.98080000E+00, 0.00000000E+00,
  0.66548680E+03, 0.104E+03, 0.620E+02, 0.98080000E+00, 0.00000000E+00,
  0.65065570E+03, 0.104E+03, 0.630E+02, 0.98080000E+00, 0.00000000E+00,
  0.49918370E+03, 0.104E+03, 0.640E+02, 0.98080000E+00, 0.00000000E+00,
  0.58212240E+03, 0.104E+03, 0.650E+02, 0.98080000E+00, 0.00000000E+00,
  0.55929170E+03, 0.104E+03, 0.660E+02, 0.98080000E+00, 0.00000000E+00,
  0.58370670E+03, 0.104E+03, 0.670E+02, 0.98080000E+00, 0.00000000E+00,
  0.57100390E+03, 0.104E+03, 0.680E+02, 0.98080000E+00, 0.00000000E+00,
  0.55938980E+03, 0.104E+03, 0.690E+02, 0.98080000E+00, 0.00000000E+00,
  0.55342660E+03, 0.104E+03, 0.700E+02, 0.98080000E+00, 0.00000000E+00,
  0.45865820E+03, 0.104E+03, 0.710E+02, 0.98080000E+00, 0.00000000E+00,
  0.44137890E+03, 0.104E+03, 0.720E+02, 0.98080000E+00, 0.00000000E+00,
  0.39713120E+03, 0.104E+03, 0.730E+02, 0.98080000E+00, 0.00000000E+00,
  0.33121240E+03, 0.104E+03, 0.740E+02, 0.98080000E+00, 0.00000000E+00,
  0.33522610E+03, 0.104E+03, 0.750E+02, 0.98080000E+00, 0.00000000E+00,
  0.29995650E+03, 0.104E+03, 0.760E+02, 0.98080000E+00, 0.00000000E+00,
  0.27181190E+03, 0.104E+03, 0.770E+02, 0.98080000E+00, 0.00000000E+00,
  0.22291570E+03, 0.104E+03, 0.780E+02, 0.98080000E+00, 0.00000000E+00,
  0.20718310E+03, 0.104E+03, 0.790E+02, 0.98080000E+00, 0.00000000E+00,
  0.21231320E+03, 0.104E+03, 0.800E+02, 0.98080000E+00, 0.00000000E+00,
  0.32610680E+03, 0.104E+03, 0.810E+02, 0.98080000E+00, 0.00000000E+00,
  0.31346750E+03, 0.104E+03, 0.820E+02, 0.98080000E+00, 0.00000000E+00,
  0.28229350E+03, 0.104E+03, 0.830E+02, 0.98080000E+00, 0.00000000E+00,
  0.26602000E+03, 0.104E+03, 0.840E+02, 0.98080000E+00, 0.00000000E+00,
  0.24186880E+03, 0.104E+03, 0.850E+02, 0.98080000E+00, 0.00000000E+00,
  0.21856870E+03, 0.104E+03, 0.860E+02, 0.98080000E+00, 0.00000000E+00,
  0.87585630E+03, 0.104E+03, 0.870E+02, 0.98080000E+00, 0.00000000E+00,
  0.81413080E+03, 0.104E+03, 0.880E+02, 0.98080000E+00, 0.00000000E+00,
  0.70540110E+03, 0.104E+03, 0.890E+02, 0.98080000E+00, 0.00000000E+00,
  0.61906050E+03, 0.104E+03, 0.900E+02, 0.98080000E+00, 0.00000000E+00,
  0.62133990E+03, 0.104E+03, 0.910E+02, 0.98080000E+00, 0.00000000E+00,
  0.60114960E+03, 0.104E+03, 0.920E+02, 0.98080000E+00, 0.00000000E+00,
  0.62763850E+03, 0.104E+03, 0.930E+02, 0.98080000E+00, 0.00000000E+00,
  0.60621390E+03, 0.104E+03, 0.940E+02, 0.98080000E+00, 0.00000000E+00,
  0.30786600E+02, 0.104E+03, 0.101E+03, 0.98080000E+00, 0.00000000E+00,
  0.10750830E+03, 0.104E+03, 0.103E+03, 0.98080000E+00, 0.98650000E+00,
  0.13584450E+03, 0.104E+03, 0.104E+03, 0.98080000E+00, 0.98080000E+00,
  0.14723700E+02, 0.105E+03, 0.100E+01, 0.97060000E+00, 0.91180000E+00,
  0.95836000E+01, 0.105E+03, 0.200E+01, 0.97060000E+00, 0.00000000E+00,
  0.23142090E+03, 0.105E+03, 0.300E+01, 0.97060000E+00, 0.00000000E+00,
  0.13372650E+03, 0.105E+03, 0.400E+01, 0.97060000E+00, 0.00000000E+00,
  0.89742900E+02, 0.105E+03, 0.500E+01, 0.97060000E+00, 0.00000000E+00,
  0.60299600E+02, 0.105E+03, 0.600E+01, 0.97060000E+00, 0.00000000E+00,
  0.41901500E+02, 0.105E+03, 0.700E+01, 0.97060000E+00, 0.00000000E+00,
  0.31535400E+02, 0.105E+03, 0.800E+01, 0.97060000E+00, 0.00000000E+00,
  0.23736900E+02, 0.105E+03, 0.900E+01, 0.97060000E+00, 0.00000000E+00,
  0.18142400E+02, 0.105E+03, 0.100E+02, 0.97060000E+00, 0.00000000E+00,
  0.27656710E+03, 0.105E+03, 0.110E+02, 0.97060000E+00, 0.00000000E+00,
  0.21299790E+03, 0.105E+03, 0.120E+02, 0.97060000E+00, 0.00000000E+00,
  0.19620140E+03, 0.105E+03, 0.130E+02, 0.97060000E+00, 0.00000000E+00,
  0.15429010E+03, 0.105E+03, 0.140E+02, 0.97060000E+00, 0.00000000E+00,
  0.11993530E+03, 0.105E+03, 0.150E+02, 0.97060000E+00, 0.00000000E+00,
  0.99215900E+02, 0.105E+03, 0.160E+02, 0.97060000E+00, 0.00000000E+00,
  0.80727200E+02, 0.105E+03, 0.170E+02, 0.97060000E+00, 0.00000000E+00,
  0.65758000E+02, 0.105E+03, 0.180E+02, 0.97060000E+00, 0.00000000E+00,
  0.45251930E+03, 0.105E+03, 0.190E+02, 0.97060000E+00, 0.00000000E+00,
  0.37388150E+03, 0.105E+03, 0.200E+02, 0.97060000E+00, 0.00000000E+00,
  0.30887210E+03, 0.105E+03, 0.210E+02, 0.97060000E+00, 0.00000000E+00,
  0.29808710E+03, 0.105E+03, 0.220E+02, 0.97060000E+00, 0.00000000E+00,
  0.27287470E+03, 0.105E+03, 0.230E+02, 0.97060000E+00, 0.00000000E+00,
  0.21463600E+03, 0.105E+03, 0.240E+02, 0.97060000E+00, 0.00000000E+00,
  0.23480000E+03, 0.105E+03, 0.250E+02, 0.97060000E+00, 0.00000000E+00,
  0.18397370E+03, 0.105E+03, 0.260E+02, 0.97060000E+00, 0.00000000E+00,
  0.19517310E+03, 0.105E+03, 0.270E+02, 0.97060000E+00, 0.00000000E+00,
  0.20113510E+03, 0.105E+03, 0.280E+02, 0.97060000E+00, 0.00000000E+00,
  0.15388240E+03, 0.105E+03, 0.290E+02, 0.97060000E+00, 0.00000000E+00,
  0.15808480E+03, 0.105E+03, 0.300E+02, 0.97060000E+00, 0.00000000E+00,
  0.18757970E+03, 0.105E+03, 0.310E+02, 0.97060000E+00, 0.00000000E+00,
  0.16519300E+03, 0.105E+03, 0.320E+02, 0.97060000E+00, 0.00000000E+00,
  0.14056250E+03, 0.105E+03, 0.330E+02, 0.97060000E+00, 0.00000000E+00,
  0.12584370E+03, 0.105E+03, 0.340E+02, 0.97060000E+00, 0.00000000E+00,
  0.10980600E+03, 0.105E+03, 0.350E+02, 0.97060000E+00, 0.00000000E+00,
  0.95176300E+02, 0.105E+03, 0.360E+02, 0.97060000E+00, 0.00000000E+00,
  0.50694210E+03, 0.105E+03, 0.370E+02, 0.97060000E+00, 0.00000000E+00,
  0.44526080E+03, 0.105E+03, 0.380E+02, 0.97060000E+00, 0.00000000E+00,
  0.38988230E+03, 0.105E+03, 0.390E+02, 0.97060000E+00, 0.00000000E+00,
  0.35019700E+03, 0.105E+03, 0.400E+02, 0.97060000E+00, 0.00000000E+00,
  0.31911510E+03, 0.105E+03, 0.410E+02, 0.97060000E+00, 0.00000000E+00,
  0.24585270E+03, 0.105E+03, 0.420E+02, 0.97060000E+00, 0.00000000E+00,
  0.27453340E+03, 0.105E+03, 0.430E+02, 0.97060000E+00, 0.00000000E+00,
  0.20863620E+03, 0.105E+03, 0.440E+02, 0.97060000E+00, 0.00000000E+00,
  0.22828220E+03, 0.105E+03, 0.450E+02, 0.97060000E+00, 0.00000000E+00,
  0.21155590E+03, 0.105E+03, 0.460E+02, 0.97060000E+00, 0.00000000E+00,
  0.17606030E+03, 0.105E+03, 0.470E+02, 0.97060000E+00, 0.00000000E+00,
  0.18621990E+03, 0.105E+03, 0.480E+02, 0.97060000E+00, 0.00000000E+00,
  0.23421710E+03, 0.105E+03, 0.490E+02, 0.97060000E+00, 0.00000000E+00,
  0.21642760E+03, 0.105E+03, 0.500E+02, 0.97060000E+00, 0.00000000E+00,
  0.19255420E+03, 0.105E+03, 0.510E+02, 0.97060000E+00, 0.00000000E+00,
  0.17839190E+03, 0.105E+03, 0.520E+02, 0.97060000E+00, 0.00000000E+00,
  0.16096790E+03, 0.105E+03, 0.530E+02, 0.97060000E+00, 0.00000000E+00,
  0.14436970E+03, 0.105E+03, 0.540E+02, 0.97060000E+00, 0.00000000E+00,
  0.61760580E+03, 0.105E+03, 0.550E+02, 0.97060000E+00, 0.00000000E+00,
  0.56751360E+03, 0.105E+03, 0.560E+02, 0.97060000E+00, 0.00000000E+00,
  0.49845340E+03, 0.105E+03, 0.570E+02, 0.97060000E+00, 0.00000000E+00,
  0.22741890E+03, 0.105E+03, 0.580E+02, 0.97060000E+00, 0.27991000E+01,
  0.50249670E+03, 0.105E+03, 0.590E+02, 0.97060000E+00, 0.00000000E+00,
  0.48250770E+03, 0.105E+03, 0.600E+02, 0.97060000E+00, 0.00000000E+00,
  0.47040290E+03, 0.105E+03, 0.610E+02, 0.97060000E+00, 0.00000000E+00,
  0.45927530E+03, 0.105E+03, 0.620E+02, 0.97060000E+00, 0.00000000E+00,
  0.44941020E+03, 0.105E+03, 0.630E+02, 0.97060000E+00, 0.00000000E+00,
  0.35290870E+03, 0.105E+03, 0.640E+02, 0.97060000E+00, 0.00000000E+00,
  0.39744990E+03, 0.105E+03, 0.650E+02, 0.97060000E+00, 0.00000000E+00,
  0.38329520E+03, 0.105E+03, 0.660E+02, 0.97060000E+00, 0.00000000E+00,
  0.40532850E+03, 0.105E+03, 0.670E+02, 0.97060000E+00, 0.00000000E+00,
  0.39673770E+03, 0.105E+03, 0.680E+02, 0.97060000E+00, 0.00000000E+00,
  0.38898900E+03, 0.105E+03, 0.690E+02, 0.97060000E+00, 0.00000000E+00,
  0.38447010E+03, 0.105E+03, 0.700E+02, 0.97060000E+00, 0.00000000E+00,
  0.32364500E+03, 0.105E+03, 0.710E+02, 0.97060000E+00, 0.00000000E+00,
  0.31828720E+03, 0.105E+03, 0.720E+02, 0.97060000E+00, 0.00000000E+00,
  0.29018010E+03, 0.105E+03, 0.730E+02, 0.97060000E+00, 0.00000000E+00,
  0.24456750E+03, 0.105E+03, 0.740E+02, 0.97060000E+00, 0.00000000E+00,
  0.24877750E+03, 0.105E+03, 0.750E+02, 0.97060000E+00, 0.00000000E+00,
  0.22518190E+03, 0.105E+03, 0.760E+02, 0.97060000E+00, 0.00000000E+00,
  0.20597020E+03, 0.105E+03, 0.770E+02, 0.97060000E+00, 0.00000000E+00,
  0.17065560E+03, 0.105E+03, 0.780E+02, 0.97060000E+00, 0.00000000E+00,
  0.15926350E+03, 0.105E+03, 0.790E+02, 0.97060000E+00, 0.00000000E+00,
  0.16388200E+03, 0.105E+03, 0.800E+02, 0.97060000E+00, 0.00000000E+00,
  0.24000000E+03, 0.105E+03, 0.810E+02, 0.97060000E+00, 0.00000000E+00,
  0.23460480E+03, 0.105E+03, 0.820E+02, 0.97060000E+00, 0.00000000E+00,
  0.21530270E+03, 0.105E+03, 0.830E+02, 0.97060000E+00, 0.00000000E+00,
  0.20513340E+03, 0.105E+03, 0.840E+02, 0.97060000E+00, 0.00000000E+00,
  0.18899910E+03, 0.105E+03, 0.850E+02, 0.97060000E+00, 0.00000000E+00,
  0.17288540E+03, 0.105E+03, 0.860E+02, 0.97060000E+00, 0.00000000E+00,
  0.58298150E+03, 0.105E+03, 0.870E+02, 0.97060000E+00, 0.00000000E+00,
  0.56100860E+03, 0.105E+03, 0.880E+02, 0.97060000E+00, 0.00000000E+00,
  0.49563890E+03, 0.105E+03, 0.890E+02, 0.97060000E+00, 0.00000000E+00,
  0.44481020E+03, 0.105E+03, 0.900E+02, 0.97060000E+00, 0.00000000E+00,
  0.44155780E+03, 0.105E+03, 0.910E+02, 0.97060000E+00, 0.00000000E+00,
  0.42748070E+03, 0.105E+03, 0.920E+02, 0.97060000E+00, 0.00000000E+00,
  0.44027100E+03, 0.105E+03, 0.930E+02, 0.97060000E+00, 0.00000000E+00,
  0.42632550E+03, 0.105E+03, 0.940E+02, 0.97060000E+00, 0.00000000E+00,
  0.23841200E+02, 0.105E+03, 0.101E+03, 0.97060000E+00, 0.00000000E+00,
  0.77663300E+02, 0.105E+03, 0.103E+03, 0.97060000E+00, 0.98650000E+00,
  0.98993800E+02, 0.105E+03, 0.104E+03, 0.97060000E+00, 0.98080000E+00,
  0.75368600E+02, 0.105E+03, 0.105E+03, 0.97060000E+00, 0.97060000E+00,
  0.11393200E+02, 0.106E+03, 0.100E+01, 0.98680000E+00, 0.91180000E+00,
  0.77065000E+01, 0.106E+03, 0.200E+01, 0.98680000E+00, 0.00000000E+00,
  0.16045900E+03, 0.106E+03, 0.300E+01, 0.98680000E+00, 0.00000000E+00,
  0.96543100E+02, 0.106E+03, 0.400E+01, 0.98680000E+00, 0.00000000E+00,
  0.66798600E+02, 0.106E+03, 0.500E+01, 0.98680000E+00, 0.00000000E+00,
  0.46068100E+02, 0.106E+03, 0.600E+01, 0.98680000E+00, 0.00000000E+00,
  0.32700900E+02, 0.106E+03, 0.700E+01, 0.98680000E+00, 0.00000000E+00,
  0.25009700E+02, 0.106E+03, 0.800E+01, 0.98680000E+00, 0.00000000E+00,
  0.19097400E+02, 0.106E+03, 0.900E+01, 0.98680000E+00, 0.00000000E+00,
  0.14771600E+02, 0.106E+03, 0.100E+02, 0.98680000E+00, 0.00000000E+00,
  0.19237290E+03, 0.106E+03, 0.110E+02, 0.98680000E+00, 0.00000000E+00,
  0.15261300E+03, 0.106E+03, 0.120E+02, 0.98680000E+00, 0.00000000E+00,
  0.14260940E+03, 0.106E+03, 0.130E+02, 0.98680000E+00, 0.00000000E+00,
  0.11444050E+03, 0.106E+03, 0.140E+02, 0.98680000E+00, 0.00000000E+00,
  0.90676700E+02, 0.106E+03, 0.150E+02, 0.98680000E+00, 0.00000000E+00,
  0.76055200E+02, 0.106E+03, 0.160E+02, 0.98680000E+00, 0.00000000E+00,
  0.62746500E+02, 0.106E+03, 0.170E+02, 0.98680000E+00, 0.00000000E+00,
  0.51768400E+02, 0.106E+03, 0.180E+02, 0.98680000E+00, 0.00000000E+00,
  0.31458000E+03, 0.106E+03, 0.190E+02, 0.98680000E+00, 0.00000000E+00,
  0.26512060E+03, 0.106E+03, 0.200E+02, 0.98680000E+00, 0.00000000E+00,
  0.22018540E+03, 0.106E+03, 0.210E+02, 0.98680000E+00, 0.00000000E+00,
  0.21386820E+03, 0.106E+03, 0.220E+02, 0.98680000E+00, 0.00000000E+00,
  0.19648850E+03, 0.106E+03, 0.230E+02, 0.98680000E+00, 0.00000000E+00,
  0.15511710E+03, 0.106E+03, 0.240E+02, 0.98680000E+00, 0.00000000E+00,
  0.16997960E+03, 0.106E+03, 0.250E+02, 0.98680000E+00, 0.00000000E+00,
  0.13377000E+03, 0.106E+03, 0.260E+02, 0.98680000E+00, 0.00000000E+00,
  0.14251400E+03, 0.106E+03, 0.270E+02, 0.98680000E+00, 0.00000000E+00,
  0.14627110E+03, 0.106E+03, 0.280E+02, 0.98680000E+00, 0.00000000E+00,
  0.11239140E+03, 0.106E+03, 0.290E+02, 0.98680000E+00, 0.00000000E+00,
  0.11639870E+03, 0.106E+03, 0.300E+02, 0.98680000E+00, 0.00000000E+00,
  0.13747230E+03, 0.106E+03, 0.310E+02, 0.98680000E+00, 0.00000000E+00,
  0.12288050E+03, 0.106E+03, 0.320E+02, 0.98680000E+00, 0.00000000E+00,
  0.10616860E+03, 0.106E+03, 0.330E+02, 0.98680000E+00, 0.00000000E+00,
  0.96059900E+02, 0.106E+03, 0.340E+02, 0.98680000E+00, 0.00000000E+00,
  0.84772300E+02, 0.106E+03, 0.350E+02, 0.98680000E+00, 0.00000000E+00,
  0.74286500E+02, 0.106E+03, 0.360E+02, 0.98680000E+00, 0.00000000E+00,
  0.35363020E+03, 0.106E+03, 0.370E+02, 0.98680000E+00, 0.00000000E+00,
  0.31589230E+03, 0.106E+03, 0.380E+02, 0.98680000E+00, 0.00000000E+00,
  0.27947270E+03, 0.106E+03, 0.390E+02, 0.98680000E+00, 0.00000000E+00,
  0.25282130E+03, 0.106E+03, 0.400E+02, 0.98680000E+00, 0.00000000E+00,
  0.23159760E+03, 0.106E+03, 0.410E+02, 0.98680000E+00, 0.00000000E+00,
  0.18033900E+03, 0.106E+03, 0.420E+02, 0.98680000E+00, 0.00000000E+00,
  0.20054640E+03, 0.106E+03, 0.430E+02, 0.98680000E+00, 0.00000000E+00,
  0.15419380E+03, 0.106E+03, 0.440E+02, 0.98680000E+00, 0.00000000E+00,
  0.16831150E+03, 0.106E+03, 0.450E+02, 0.98680000E+00, 0.00000000E+00,
  0.15650060E+03, 0.106E+03, 0.460E+02, 0.98680000E+00, 0.00000000E+00,
  0.13051440E+03, 0.106E+03, 0.470E+02, 0.98680000E+00, 0.00000000E+00,
  0.13836720E+03, 0.106E+03, 0.480E+02, 0.98680000E+00, 0.00000000E+00,
  0.17212290E+03, 0.106E+03, 0.490E+02, 0.98680000E+00, 0.00000000E+00,
  0.16079100E+03, 0.106E+03, 0.500E+02, 0.98680000E+00, 0.00000000E+00,
  0.14484620E+03, 0.106E+03, 0.510E+02, 0.98680000E+00, 0.00000000E+00,
  0.13531220E+03, 0.106E+03, 0.520E+02, 0.98680000E+00, 0.00000000E+00,
  0.12325380E+03, 0.106E+03, 0.530E+02, 0.98680000E+00, 0.00000000E+00,
  0.11159230E+03, 0.106E+03, 0.540E+02, 0.98680000E+00, 0.00000000E+00,
  0.43151720E+03, 0.106E+03, 0.550E+02, 0.98680000E+00, 0.00000000E+00,
  0.40187740E+03, 0.106E+03, 0.560E+02, 0.98680000E+00, 0.00000000E+00,
  0.35646100E+03, 0.106E+03, 0.570E+02, 0.98680000E+00, 0.00000000E+00,
  0.17092620E+03, 0.106E+03, 0.580E+02, 0.98680000E+00, 0.27991000E+01,
  0.35713990E+03, 0.106E+03, 0.590E+02, 0.98680000E+00, 0.00000000E+00,
  0.34341530E+03, 0.106E+03, 0.600E+02, 0.98680000E+00, 0.00000000E+00,
  0.33492450E+03, 0.106E+03, 0.610E+02, 0.98680000E+00, 0.00000000E+00,
  0.32709910E+03, 0.106E+03, 0.620E+02, 0.98680000E+00, 0.00000000E+00,
  0.32016570E+03, 0.106E+03, 0.630E+02, 0.98680000E+00, 0.00000000E+00,
  0.25481220E+03, 0.106E+03, 0.640E+02, 0.98680000E+00, 0.00000000E+00,
  0.28285470E+03, 0.106E+03, 0.650E+02, 0.98680000E+00, 0.00000000E+00,
  0.27333750E+03, 0.106E+03, 0.660E+02, 0.98680000E+00, 0.00000000E+00,
  0.28939200E+03, 0.106E+03, 0.670E+02, 0.98680000E+00, 0.00000000E+00,
  0.28330010E+03, 0.106E+03, 0.680E+02, 0.98680000E+00, 0.00000000E+00,
  0.27784930E+03, 0.106E+03, 0.690E+02, 0.98680000E+00, 0.00000000E+00,
  0.27445000E+03, 0.106E+03, 0.700E+02, 0.98680000E+00, 0.00000000E+00,
  0.23313940E+03, 0.106E+03, 0.710E+02, 0.98680000E+00, 0.00000000E+00,
  0.23163340E+03, 0.106E+03, 0.720E+02, 0.98680000E+00, 0.00000000E+00,
  0.21280410E+03, 0.106E+03, 0.730E+02, 0.98680000E+00, 0.00000000E+00,
  0.18084620E+03, 0.106E+03, 0.740E+02, 0.98680000E+00, 0.00000000E+00,
  0.18435860E+03, 0.106E+03, 0.750E+02, 0.98680000E+00, 0.00000000E+00,
  0.16804770E+03, 0.106E+03, 0.760E+02, 0.98680000E+00, 0.00000000E+00,
  0.15462480E+03, 0.106E+03, 0.770E+02, 0.98680000E+00, 0.00000000E+00,
  0.12918350E+03, 0.106E+03, 0.780E+02, 0.98680000E+00, 0.00000000E+00,
  0.12094850E+03, 0.106E+03, 0.790E+02, 0.98680000E+00, 0.00000000E+00,
  0.12459510E+03, 0.106E+03, 0.800E+02, 0.98680000E+00, 0.00000000E+00,
  0.17748530E+03, 0.106E+03, 0.810E+02, 0.98680000E+00, 0.00000000E+00,
  0.17476750E+03, 0.106E+03, 0.820E+02, 0.98680000E+00, 0.00000000E+00,
  0.16207400E+03, 0.106E+03, 0.830E+02, 0.98680000E+00, 0.00000000E+00,
  0.15545060E+03, 0.106E+03, 0.840E+02, 0.98680000E+00, 0.00000000E+00,
  0.14445320E+03, 0.106E+03, 0.850E+02, 0.98680000E+00, 0.00000000E+00,
  0.13324320E+03, 0.106E+03, 0.860E+02, 0.98680000E+00, 0.00000000E+00,
  0.41058600E+03, 0.106E+03, 0.870E+02, 0.98680000E+00, 0.00000000E+00,
  0.39952250E+03, 0.106E+03, 0.880E+02, 0.98680000E+00, 0.00000000E+00,
  0.35611270E+03, 0.106E+03, 0.890E+02, 0.98680000E+00, 0.00000000E+00,
  0.32349590E+03, 0.106E+03, 0.900E+02, 0.98680000E+00, 0.00000000E+00,
  0.31967610E+03, 0.106E+03, 0.910E+02, 0.98680000E+00, 0.00000000E+00,
  0.30960820E+03, 0.106E+03, 0.920E+02, 0.98680000E+00, 0.00000000E+00,
  0.31659670E+03, 0.106E+03, 0.930E+02, 0.98680000E+00, 0.00000000E+00,
  0.30693030E+03, 0.106E+03, 0.940E+02, 0.98680000E+00, 0.00000000E+00,
  0.18057500E+02, 0.106E+03, 0.101E+03, 0.98680000E+00, 0.00000000E+00,
  0.56346800E+02, 0.106E+03, 0.103E+03, 0.98680000E+00, 0.98650000E+00,
  0.72316200E+02, 0.106E+03, 0.104E+03, 0.98680000E+00, 0.98080000E+00,
  0.56529500E+02, 0.106E+03, 0.105E+03, 0.98680000E+00, 0.97060000E+00,
  0.43245200E+02, 0.106E+03, 0.106E+03, 0.98680000E+00, 0.98680000E+00,
  0.81417000E+01, 0.107E+03, 0.100E+01, 0.99440000E+00, 0.91180000E+00,
  0.57601000E+01, 0.107E+03, 0.200E+01, 0.99440000E+00, 0.00000000E+00,
  0.10127010E+03, 0.107E+03, 0.300E+01, 0.99440000E+00, 0.00000000E+00,
  0.63858000E+02, 0.107E+03, 0.400E+01, 0.99440000E+00, 0.00000000E+00,
  0.45731900E+02, 0.107E+03, 0.500E+01, 0.99440000E+00, 0.00000000E+00,
  0.32484800E+02, 0.107E+03, 0.600E+01, 0.99440000E+00, 0.00000000E+00,
  0.23629500E+02, 0.107E+03, 0.700E+01, 0.99440000E+00, 0.00000000E+00,
  0.18412800E+02, 0.107E+03, 0.800E+01, 0.99440000E+00, 0.00000000E+00,
  0.14301500E+02, 0.107E+03, 0.900E+01, 0.99440000E+00, 0.00000000E+00,
  0.11224300E+02, 0.107E+03, 0.100E+02, 0.99440000E+00, 0.00000000E+00,
  0.12196010E+03, 0.107E+03, 0.110E+02, 0.99440000E+00, 0.00000000E+00,
  0.10014430E+03, 0.107E+03, 0.120E+02, 0.99440000E+00, 0.00000000E+00,
  0.95091600E+02, 0.107E+03, 0.130E+02, 0.99440000E+00, 0.00000000E+00,
  0.78046600E+02, 0.107E+03, 0.140E+02, 0.99440000E+00, 0.00000000E+00,
  0.63166900E+02, 0.107E+03, 0.150E+02, 0.99440000E+00, 0.00000000E+00,
  0.53810700E+02, 0.107E+03, 0.160E+02, 0.99440000E+00, 0.00000000E+00,
  0.45095200E+02, 0.107E+03, 0.170E+02, 0.99440000E+00, 0.00000000E+00,
  0.37752200E+02, 0.107E+03, 0.180E+02, 0.99440000E+00, 0.00000000E+00,
  0.19944050E+03, 0.107E+03, 0.190E+02, 0.99440000E+00, 0.00000000E+00,
  0.17204550E+03, 0.107E+03, 0.200E+02, 0.99440000E+00, 0.00000000E+00,
  0.14376580E+03, 0.107E+03, 0.210E+02, 0.99440000E+00, 0.00000000E+00,
  0.14071150E+03, 0.107E+03, 0.220E+02, 0.99440000E+00, 0.00000000E+00,
  0.12982970E+03, 0.107E+03, 0.230E+02, 0.99440000E+00, 0.00000000E+00,
  0.10301890E+03, 0.107E+03, 0.240E+02, 0.99440000E+00, 0.00000000E+00,
  0.11302480E+03, 0.107E+03, 0.250E+02, 0.99440000E+00, 0.00000000E+00,
  0.89486800E+02, 0.107E+03, 0.260E+02, 0.99440000E+00, 0.00000000E+00,
  0.95705100E+02, 0.107E+03, 0.270E+02, 0.99440000E+00, 0.00000000E+00,
  0.97776100E+02, 0.107E+03, 0.280E+02, 0.99440000E+00, 0.00000000E+00,
  0.75598700E+02, 0.107E+03, 0.290E+02, 0.99440000E+00, 0.00000000E+00,
  0.78918300E+02, 0.107E+03, 0.300E+02, 0.99440000E+00, 0.00000000E+00,
  0.92602500E+02, 0.107E+03, 0.310E+02, 0.99440000E+00, 0.00000000E+00,
  0.84127600E+02, 0.107E+03, 0.320E+02, 0.99440000E+00, 0.00000000E+00,
  0.73914200E+02, 0.107E+03, 0.330E+02, 0.99440000E+00, 0.00000000E+00,
  0.67663600E+02, 0.107E+03, 0.340E+02, 0.99440000E+00, 0.00000000E+00,
  0.60472800E+02, 0.107E+03, 0.350E+02, 0.99440000E+00, 0.00000000E+00,
  0.53649600E+02, 0.107E+03, 0.360E+02, 0.99440000E+00, 0.00000000E+00,
  0.22519190E+03, 0.107E+03, 0.370E+02, 0.99440000E+00, 0.00000000E+00,
  0.20515740E+03, 0.107E+03, 0.380E+02, 0.99440000E+00, 0.00000000E+00,
  0.18368510E+03, 0.107E+03, 0.390E+02, 0.99440000E+00, 0.00000000E+00,
  0.16755010E+03, 0.107E+03, 0.400E+02, 0.99440000E+00, 0.00000000E+00,
  0.15443560E+03, 0.107E+03, 0.410E+02, 0.99440000E+00, 0.00000000E+00,
  0.12180660E+03, 0.107E+03, 0.420E+02, 0.99440000E+00, 0.00000000E+00,
  0.13478870E+03, 0.107E+03, 0.430E+02, 0.99440000E+00, 0.00000000E+00,
  0.10509050E+03, 0.107E+03, 0.440E+02, 0.99440000E+00, 0.00000000E+00,
  0.11434960E+03, 0.107E+03, 0.450E+02, 0.99440000E+00, 0.00000000E+00,
  0.10674380E+03, 0.107E+03, 0.460E+02, 0.99440000E+00, 0.00000000E+00,
  0.89341900E+02, 0.107E+03, 0.470E+02, 0.99440000E+00, 0.00000000E+00,
  0.94877000E+02, 0.107E+03, 0.480E+02, 0.99440000E+00, 0.00000000E+00,
  0.11649590E+03, 0.107E+03, 0.490E+02, 0.99440000E+00, 0.00000000E+00,
  0.11009510E+03, 0.107E+03, 0.500E+02, 0.99440000E+00, 0.00000000E+00,
  0.10051820E+03, 0.107E+03, 0.510E+02, 0.99440000E+00, 0.00000000E+00,
  0.94750800E+02, 0.107E+03, 0.520E+02, 0.99440000E+00, 0.00000000E+00,
  0.87202800E+02, 0.107E+03, 0.530E+02, 0.99440000E+00, 0.00000000E+00,
  0.79777300E+02, 0.107E+03, 0.540E+02, 0.99440000E+00, 0.00000000E+00,
  0.27525670E+03, 0.107E+03, 0.550E+02, 0.99440000E+00, 0.00000000E+00,
  0.26044810E+03, 0.107E+03, 0.560E+02, 0.99440000E+00, 0.00000000E+00,
  0.23366190E+03, 0.107E+03, 0.570E+02, 0.99440000E+00, 0.00000000E+00,
  0.11854700E+03, 0.107E+03, 0.580E+02, 0.99440000E+00, 0.27991000E+01,
  0.23257830E+03, 0.107E+03, 0.590E+02, 0.99440000E+00, 0.00000000E+00,
  0.22400400E+03, 0.107E+03, 0.600E+02, 0.99440000E+00, 0.00000000E+00,
  0.21856110E+03, 0.107E+03, 0.610E+02, 0.99440000E+00, 0.00000000E+00,
  0.21352770E+03, 0.107E+03, 0.620E+02, 0.99440000E+00, 0.00000000E+00,
  0.20907000E+03, 0.107E+03, 0.630E+02, 0.99440000E+00, 0.00000000E+00,
  0.16905560E+03, 0.107E+03, 0.640E+02, 0.99440000E+00, 0.00000000E+00,
  0.18459040E+03, 0.107E+03, 0.650E+02, 0.99440000E+00, 0.00000000E+00,
  0.17880740E+03, 0.107E+03, 0.660E+02, 0.99440000E+00, 0.00000000E+00,
  0.18945310E+03, 0.107E+03, 0.670E+02, 0.99440000E+00, 0.00000000E+00,
  0.18549310E+03, 0.107E+03, 0.680E+02, 0.99440000E+00, 0.00000000E+00,
  0.18198230E+03, 0.107E+03, 0.690E+02, 0.99440000E+00, 0.00000000E+00,
  0.17962020E+03, 0.107E+03, 0.700E+02, 0.99440000E+00, 0.00000000E+00,
  0.15422920E+03, 0.107E+03, 0.710E+02, 0.99440000E+00, 0.00000000E+00,
  0.15491020E+03, 0.107E+03, 0.720E+02, 0.99440000E+00, 0.00000000E+00,
  0.14357630E+03, 0.107E+03, 0.730E+02, 0.99440000E+00, 0.00000000E+00,
  0.12323020E+03, 0.107E+03, 0.740E+02, 0.99440000E+00, 0.00000000E+00,
  0.12591210E+03, 0.107E+03, 0.750E+02, 0.99440000E+00, 0.00000000E+00,
  0.11569380E+03, 0.107E+03, 0.760E+02, 0.99440000E+00, 0.00000000E+00,
  0.10717750E+03, 0.107E+03, 0.770E+02, 0.99440000E+00, 0.00000000E+00,
  0.90445600E+02, 0.107E+03, 0.780E+02, 0.99440000E+00, 0.00000000E+00,
  0.85014600E+02, 0.107E+03, 0.790E+02, 0.99440000E+00, 0.00000000E+00,
  0.87649000E+02, 0.107E+03, 0.800E+02, 0.99440000E+00, 0.00000000E+00,
  0.12108000E+03, 0.107E+03, 0.810E+02, 0.99440000E+00, 0.00000000E+00,
  0.12012680E+03, 0.107E+03, 0.820E+02, 0.99440000E+00, 0.00000000E+00,
  0.11264850E+03, 0.107E+03, 0.830E+02, 0.99440000E+00, 0.00000000E+00,
  0.10881340E+03, 0.107E+03, 0.840E+02, 0.99440000E+00, 0.00000000E+00,
  0.10205240E+03, 0.107E+03, 0.850E+02, 0.99440000E+00, 0.00000000E+00,
  0.94992800E+02, 0.107E+03, 0.860E+02, 0.99440000E+00, 0.00000000E+00,
  0.26444300E+03, 0.107E+03, 0.870E+02, 0.99440000E+00, 0.00000000E+00,
  0.26065290E+03, 0.107E+03, 0.880E+02, 0.99440000E+00, 0.00000000E+00,
  0.23476520E+03, 0.107E+03, 0.890E+02, 0.99440000E+00, 0.00000000E+00,
  0.21630740E+03, 0.107E+03, 0.900E+02, 0.99440000E+00, 0.00000000E+00,
  0.21274560E+03, 0.107E+03, 0.910E+02, 0.99440000E+00, 0.00000000E+00,
  0.20616310E+03, 0.107E+03, 0.920E+02, 0.99440000E+00, 0.00000000E+00,
  0.20915240E+03, 0.107E+03, 0.930E+02, 0.99440000E+00, 0.00000000E+00,
  0.20304180E+03, 0.107E+03, 0.940E+02, 0.99440000E+00, 0.00000000E+00,
  0.12598000E+02, 0.107E+03, 0.101E+03, 0.99440000E+00, 0.00000000E+00,
  0.37493900E+02, 0.107E+03, 0.103E+03, 0.99440000E+00, 0.98650000E+00,
  0.48488500E+02, 0.107E+03, 0.104E+03, 0.99440000E+00, 0.98080000E+00,
  0.39043300E+02, 0.107E+03, 0.105E+03, 0.99440000E+00, 0.97060000E+00,
  0.30541000E+02, 0.107E+03, 0.106E+03, 0.99440000E+00, 0.98680000E+00,
  0.22124100E+02, 0.107E+03, 0.107E+03, 0.99440000E+00, 0.99440000E+00,
  0.60575000E+01, 0.108E+03, 0.100E+01, 0.99250000E+00, 0.91180000E+00,
  0.44593000E+01, 0.108E+03, 0.200E+01, 0.99250000E+00, 0.00000000E+00,
  0.67931200E+02, 0.108E+03, 0.300E+01, 0.99250000E+00, 0.00000000E+00,
  0.44496800E+02, 0.108E+03, 0.400E+01, 0.99250000E+00, 0.00000000E+00,
  0.32813600E+02, 0.108E+03, 0.500E+01, 0.99250000E+00, 0.00000000E+00,
  0.23912000E+02, 0.108E+03, 0.600E+01, 0.99250000E+00, 0.00000000E+00,
  0.17769800E+02, 0.108E+03, 0.700E+01, 0.99250000E+00, 0.00000000E+00,
  0.14076400E+02, 0.108E+03, 0.800E+01, 0.99250000E+00, 0.00000000E+00,
  0.11099400E+02, 0.108E+03, 0.900E+01, 0.99250000E+00, 0.00000000E+00,
  0.88252000E+01, 0.108E+03, 0.100E+02, 0.99250000E+00, 0.00000000E+00,
  0.82182000E+02, 0.108E+03, 0.110E+02, 0.99250000E+00, 0.00000000E+00,
  0.69367500E+02, 0.108E+03, 0.120E+02, 0.99250000E+00, 0.00000000E+00,
  0.66745100E+02, 0.108E+03, 0.130E+02, 0.99250000E+00, 0.00000000E+00,
  0.55817500E+02, 0.108E+03, 0.140E+02, 0.99250000E+00, 0.00000000E+00,
  0.45993700E+02, 0.108E+03, 0.150E+02, 0.99250000E+00, 0.00000000E+00,
  0.39709100E+02, 0.108E+03, 0.160E+02, 0.99250000E+00, 0.00000000E+00,
  0.33731300E+02, 0.108E+03, 0.170E+02, 0.99250000E+00, 0.00000000E+00,
  0.28600000E+02, 0.108E+03, 0.180E+02, 0.99250000E+00, 0.00000000E+00,
  0.13465080E+03, 0.108E+03, 0.190E+02, 0.99250000E+00, 0.00000000E+00,
  0.11824110E+03, 0.108E+03, 0.200E+02, 0.99250000E+00, 0.00000000E+00,
  0.99293900E+02, 0.108E+03, 0.210E+02, 0.99250000E+00, 0.00000000E+00,
  0.97834500E+02, 0.108E+03, 0.220E+02, 0.99250000E+00, 0.00000000E+00,
  0.90600700E+02, 0.108E+03, 0.230E+02, 0.99250000E+00, 0.00000000E+00,
  0.72287200E+02, 0.108E+03, 0.240E+02, 0.99250000E+00, 0.00000000E+00,
  0.79304700E+02, 0.108E+03, 0.250E+02, 0.99250000E+00, 0.00000000E+00,
  0.63186500E+02, 0.108E+03, 0.260E+02, 0.99250000E+00, 0.00000000E+00,
  0.67711700E+02, 0.108E+03, 0.270E+02, 0.99250000E+00, 0.00000000E+00,
  0.68908600E+02, 0.108E+03, 0.280E+02, 0.99250000E+00, 0.00000000E+00,
  0.53642000E+02, 0.108E+03, 0.290E+02, 0.99250000E+00, 0.00000000E+00,
  0.56288400E+02, 0.108E+03, 0.300E+02, 0.99250000E+00, 0.00000000E+00,
  0.65621400E+02, 0.108E+03, 0.310E+02, 0.99250000E+00, 0.00000000E+00,
  0.60404100E+02, 0.108E+03, 0.320E+02, 0.99250000E+00, 0.00000000E+00,
  0.53815300E+02, 0.108E+03, 0.330E+02, 0.99250000E+00, 0.00000000E+00,
  0.49755200E+02, 0.108E+03, 0.340E+02, 0.99250000E+00, 0.00000000E+00,
  0.44951000E+02, 0.108E+03, 0.350E+02, 0.99250000E+00, 0.00000000E+00,
  0.40304300E+02, 0.108E+03, 0.360E+02, 0.99250000E+00, 0.00000000E+00,
  0.15267570E+03, 0.108E+03, 0.370E+02, 0.99250000E+00, 0.00000000E+00,
  0.14115920E+03, 0.108E+03, 0.380E+02, 0.99250000E+00, 0.00000000E+00,
  0.12762820E+03, 0.108E+03, 0.390E+02, 0.99250000E+00, 0.00000000E+00,
  0.11723280E+03, 0.108E+03, 0.400E+02, 0.99250000E+00, 0.00000000E+00,
  0.10863780E+03, 0.108E+03, 0.410E+02, 0.99250000E+00, 0.00000000E+00,
  0.86680300E+02, 0.108E+03, 0.420E+02, 0.99250000E+00, 0.00000000E+00,
  0.95496600E+02, 0.108E+03, 0.430E+02, 0.99250000E+00, 0.00000000E+00,
  0.75391000E+02, 0.108E+03, 0.440E+02, 0.99250000E+00, 0.00000000E+00,
  0.81764000E+02, 0.108E+03, 0.450E+02, 0.99250000E+00, 0.00000000E+00,
  0.76587100E+02, 0.108E+03, 0.460E+02, 0.99250000E+00, 0.00000000E+00,
  0.64388000E+02, 0.108E+03, 0.470E+02, 0.99250000E+00, 0.00000000E+00,
  0.68394300E+02, 0.108E+03, 0.480E+02, 0.99250000E+00, 0.00000000E+00,
  0.83027800E+02, 0.108E+03, 0.490E+02, 0.99250000E+00, 0.00000000E+00,
  0.79170400E+02, 0.108E+03, 0.500E+02, 0.99250000E+00, 0.00000000E+00,
  0.73071800E+02, 0.108E+03, 0.510E+02, 0.99250000E+00, 0.00000000E+00,
  0.69390100E+02, 0.108E+03, 0.520E+02, 0.99250000E+00, 0.00000000E+00,
  0.64414100E+02, 0.108E+03, 0.530E+02, 0.99250000E+00, 0.00000000E+00,
  0.59446800E+02, 0.108E+03, 0.540E+02, 0.99250000E+00, 0.00000000E+00,
  0.18687910E+03, 0.108E+03, 0.550E+02, 0.99250000E+00, 0.00000000E+00,
  0.17895490E+03, 0.108E+03, 0.560E+02, 0.99250000E+00, 0.00000000E+00,
  0.16203710E+03, 0.108E+03, 0.570E+02, 0.99250000E+00, 0.00000000E+00,
  0.86166500E+02, 0.108E+03, 0.580E+02, 0.99250000E+00, 0.27991000E+01,
  0.16052330E+03, 0.108E+03, 0.590E+02, 0.99250000E+00, 0.00000000E+00,
  0.15480670E+03, 0.108E+03, 0.600E+02, 0.99250000E+00, 0.00000000E+00,
  0.15109700E+03, 0.108E+03, 0.610E+02, 0.99250000E+00, 0.00000000E+00,
  0.14765520E+03, 0.108E+03, 0.620E+02, 0.99250000E+00, 0.00000000E+00,
  0.14460750E+03, 0.108E+03, 0.630E+02, 0.99250000E+00, 0.00000000E+00,
  0.11853880E+03, 0.108E+03, 0.640E+02, 0.99250000E+00, 0.00000000E+00,
  0.12778280E+03, 0.108E+03, 0.650E+02, 0.99250000E+00, 0.00000000E+00,
  0.12401580E+03, 0.108E+03, 0.660E+02, 0.99250000E+00, 0.00000000E+00,
  0.13130040E+03, 0.108E+03, 0.670E+02, 0.99250000E+00, 0.00000000E+00,
  0.12856660E+03, 0.108E+03, 0.680E+02, 0.99250000E+00, 0.00000000E+00,
  0.12616140E+03, 0.108E+03, 0.690E+02, 0.99250000E+00, 0.00000000E+00,
  0.12444020E+03, 0.108E+03, 0.700E+02, 0.99250000E+00, 0.00000000E+00,
  0.10783510E+03, 0.108E+03, 0.710E+02, 0.99250000E+00, 0.00000000E+00,
  0.10920420E+03, 0.108E+03, 0.720E+02, 0.99250000E+00, 0.00000000E+00,
  0.10197340E+03, 0.108E+03, 0.730E+02, 0.99250000E+00, 0.00000000E+00,
  0.88315600E+02, 0.108E+03, 0.740E+02, 0.99250000E+00, 0.00000000E+00,
  0.90391800E+02, 0.108E+03, 0.750E+02, 0.99250000E+00, 0.00000000E+00,
  0.83622700E+02, 0.108E+03, 0.760E+02, 0.99250000E+00, 0.00000000E+00,
  0.77919400E+02, 0.108E+03, 0.770E+02, 0.99250000E+00, 0.00000000E+00,
  0.66359100E+02, 0.108E+03, 0.780E+02, 0.99250000E+00, 0.00000000E+00,
  0.62600800E+02, 0.108E+03, 0.790E+02, 0.99250000E+00, 0.00000000E+00,
  0.64555200E+02, 0.108E+03, 0.800E+02, 0.99250000E+00, 0.00000000E+00,
  0.86955200E+02, 0.108E+03, 0.810E+02, 0.99250000E+00, 0.00000000E+00,
  0.86739200E+02, 0.108E+03, 0.820E+02, 0.99250000E+00, 0.00000000E+00,
  0.82055900E+02, 0.108E+03, 0.830E+02, 0.99250000E+00, 0.00000000E+00,
  0.79713300E+02, 0.108E+03, 0.840E+02, 0.99250000E+00, 0.00000000E+00,
  0.75326800E+02, 0.108E+03, 0.850E+02, 0.99250000E+00, 0.00000000E+00,
  0.70648000E+02, 0.108E+03, 0.860E+02, 0.99250000E+00, 0.00000000E+00,
  0.18100550E+03, 0.108E+03, 0.870E+02, 0.99250000E+00, 0.00000000E+00,
  0.18009880E+03, 0.108E+03, 0.880E+02, 0.99250000E+00, 0.00000000E+00,
  0.16360420E+03, 0.108E+03, 0.890E+02, 0.99250000E+00, 0.00000000E+00,
  0.15256500E+03, 0.108E+03, 0.900E+02, 0.99250000E+00, 0.00000000E+00,
  0.14955510E+03, 0.108E+03, 0.910E+02, 0.99250000E+00, 0.00000000E+00,
  0.14501130E+03, 0.108E+03, 0.920E+02, 0.99250000E+00, 0.00000000E+00,
  0.14619280E+03, 0.108E+03, 0.930E+02, 0.99250000E+00, 0.00000000E+00,
  0.14207750E+03, 0.108E+03, 0.940E+02, 0.99250000E+00, 0.00000000E+00,
  0.91812000E+01, 0.108E+03, 0.101E+03, 0.99250000E+00, 0.00000000E+00,
  0.26270800E+02, 0.108E+03, 0.103E+03, 0.99250000E+00, 0.98650000E+00,
  0.34198300E+02, 0.108E+03, 0.104E+03, 0.99250000E+00, 0.98080000E+00,
  0.28232700E+02, 0.108E+03, 0.105E+03, 0.99250000E+00, 0.97060000E+00,
  0.22517800E+02, 0.108E+03, 0.106E+03, 0.99250000E+00, 0.98680000E+00,
  0.16677500E+02, 0.108E+03, 0.107E+03, 0.99250000E+00, 0.99440000E+00,
  0.12816100E+02, 0.108E+03, 0.108E+03, 0.99250000E+00, 0.99250000E+00,
  0.42672000E+01, 0.109E+03, 0.100E+01, 0.99820000E+00, 0.91180000E+00,
  0.33077000E+01, 0.109E+03, 0.200E+01, 0.99820000E+00, 0.00000000E+00,
  0.42062700E+02, 0.109E+03, 0.300E+01, 0.99820000E+00, 0.00000000E+00,
  0.28861500E+02, 0.109E+03, 0.400E+01, 0.99820000E+00, 0.00000000E+00,
  0.22093100E+02, 0.109E+03, 0.500E+01, 0.99820000E+00, 0.00000000E+00,
  0.16637300E+02, 0.109E+03, 0.600E+01, 0.99820000E+00, 0.00000000E+00,
  0.12710700E+02, 0.109E+03, 0.700E+01, 0.99820000E+00, 0.00000000E+00,
  0.10286700E+02, 0.109E+03, 0.800E+01, 0.99820000E+00, 0.00000000E+00,
  0.82739000E+01, 0.109E+03, 0.900E+01, 0.99820000E+00, 0.00000000E+00,
  0.66950000E+01, 0.109E+03, 0.100E+02, 0.99820000E+00, 0.00000000E+00,
  0.51249800E+02, 0.109E+03, 0.110E+02, 0.99820000E+00, 0.00000000E+00,
  0.44714100E+02, 0.109E+03, 0.120E+02, 0.99820000E+00, 0.00000000E+00,
  0.43736400E+02, 0.109E+03, 0.130E+02, 0.99820000E+00, 0.00000000E+00,
  0.37442100E+02, 0.109E+03, 0.140E+02, 0.99820000E+00, 0.00000000E+00,
  0.31557700E+02, 0.109E+03, 0.150E+02, 0.99820000E+00, 0.00000000E+00,
  0.27713700E+02, 0.109E+03, 0.160E+02, 0.99820000E+00, 0.00000000E+00,
  0.23950500E+02, 0.109E+03, 0.170E+02, 0.99820000E+00, 0.00000000E+00,
  0.20639400E+02, 0.109E+03, 0.180E+02, 0.99820000E+00, 0.00000000E+00,
  0.84368800E+02, 0.109E+03, 0.190E+02, 0.99820000E+00, 0.00000000E+00,
  0.75585000E+02, 0.109E+03, 0.200E+02, 0.99820000E+00, 0.00000000E+00,
  0.63856400E+02, 0.109E+03, 0.210E+02, 0.99820000E+00, 0.00000000E+00,
  0.63474800E+02, 0.109E+03, 0.220E+02, 0.99820000E+00, 0.00000000E+00,
  0.59066500E+02, 0.109E+03, 0.230E+02, 0.99820000E+00, 0.00000000E+00,
  0.47531800E+02, 0.109E+03, 0.240E+02, 0.99820000E+00, 0.00000000E+00,
  0.52078000E+02, 0.109E+03, 0.250E+02, 0.99820000E+00, 0.00000000E+00,
  0.41894200E+02, 0.109E+03, 0.260E+02, 0.99820000E+00, 0.00000000E+00,
  0.44940700E+02, 0.109E+03, 0.270E+02, 0.99820000E+00, 0.00000000E+00,
  0.45515500E+02, 0.109E+03, 0.280E+02, 0.99820000E+00, 0.00000000E+00,
  0.35810000E+02, 0.109E+03, 0.290E+02, 0.99820000E+00, 0.00000000E+00,
  0.37755900E+02, 0.109E+03, 0.300E+02, 0.99820000E+00, 0.00000000E+00,
  0.43568500E+02, 0.109E+03, 0.310E+02, 0.99820000E+00, 0.00000000E+00,
  0.40750000E+02, 0.109E+03, 0.320E+02, 0.99820000E+00, 0.00000000E+00,
  0.36938900E+02, 0.109E+03, 0.330E+02, 0.99820000E+00, 0.00000000E+00,
  0.34579200E+02, 0.109E+03, 0.340E+02, 0.99820000E+00, 0.00000000E+00,
  0.31669900E+02, 0.109E+03, 0.350E+02, 0.99820000E+00, 0.00000000E+00,
  0.28780000E+02, 0.109E+03, 0.360E+02, 0.99820000E+00, 0.00000000E+00,
  0.96223500E+02, 0.109E+03, 0.370E+02, 0.99820000E+00, 0.00000000E+00,
  0.90408100E+02, 0.109E+03, 0.380E+02, 0.99820000E+00, 0.00000000E+00,
  0.82733700E+02, 0.109E+03, 0.390E+02, 0.99820000E+00, 0.00000000E+00,
  0.76671200E+02, 0.109E+03, 0.400E+02, 0.99820000E+00, 0.00000000E+00,
  0.71549300E+02, 0.109E+03, 0.410E+02, 0.99820000E+00, 0.00000000E+00,
  0.57978400E+02, 0.109E+03, 0.420E+02, 0.99820000E+00, 0.00000000E+00,
  0.63507900E+02, 0.109E+03, 0.430E+02, 0.99820000E+00, 0.00000000E+00,
  0.50977000E+02, 0.109E+03, 0.440E+02, 0.99820000E+00, 0.00000000E+00,
  0.55024000E+02, 0.109E+03, 0.450E+02, 0.99820000E+00, 0.00000000E+00,
  0.51774000E+02, 0.109E+03, 0.460E+02, 0.99820000E+00, 0.00000000E+00,
  0.43848000E+02, 0.109E+03, 0.470E+02, 0.99820000E+00, 0.00000000E+00,
  0.46534000E+02, 0.109E+03, 0.480E+02, 0.99820000E+00, 0.00000000E+00,
  0.55658900E+02, 0.109E+03, 0.490E+02, 0.99820000E+00, 0.00000000E+00,
  0.53624300E+02, 0.109E+03, 0.500E+02, 0.99820000E+00, 0.00000000E+00,
  0.50147300E+02, 0.109E+03, 0.510E+02, 0.99820000E+00, 0.00000000E+00,
  0.48053500E+02, 0.109E+03, 0.520E+02, 0.99820000E+00, 0.00000000E+00,
  0.45084800E+02, 0.109E+03, 0.530E+02, 0.99820000E+00, 0.00000000E+00,
  0.42063400E+02, 0.109E+03, 0.540E+02, 0.99820000E+00, 0.00000000E+00,
  0.11797180E+03, 0.109E+03, 0.550E+02, 0.99820000E+00, 0.00000000E+00,
  0.11446760E+03, 0.109E+03, 0.560E+02, 0.99820000E+00, 0.00000000E+00,
  0.10480950E+03, 0.109E+03, 0.570E+02, 0.99820000E+00, 0.00000000E+00,
  0.59137900E+02, 0.109E+03, 0.580E+02, 0.99820000E+00, 0.27991000E+01,
  0.10336160E+03, 0.109E+03, 0.590E+02, 0.99820000E+00, 0.00000000E+00,
  0.99833100E+02, 0.109E+03, 0.600E+02, 0.99820000E+00, 0.00000000E+00,
  0.97478900E+02, 0.109E+03, 0.610E+02, 0.99820000E+00, 0.00000000E+00,
  0.95284600E+02, 0.109E+03, 0.620E+02, 0.99820000E+00, 0.00000000E+00,
  0.93341000E+02, 0.109E+03, 0.630E+02, 0.99820000E+00, 0.00000000E+00,
  0.77874200E+02, 0.109E+03, 0.640E+02, 0.99820000E+00, 0.00000000E+00,
  0.82715400E+02, 0.109E+03, 0.650E+02, 0.99820000E+00, 0.00000000E+00,
  0.80460700E+02, 0.109E+03, 0.660E+02, 0.99820000E+00, 0.00000000E+00,
  0.84947800E+02, 0.109E+03, 0.670E+02, 0.99820000E+00, 0.00000000E+00,
  0.83182700E+02, 0.109E+03, 0.680E+02, 0.99820000E+00, 0.00000000E+00,
  0.81643700E+02, 0.109E+03, 0.690E+02, 0.99820000E+00, 0.00000000E+00,
  0.80457500E+02, 0.109E+03, 0.700E+02, 0.99820000E+00, 0.00000000E+00,
  0.70552200E+02, 0.109E+03, 0.710E+02, 0.99820000E+00, 0.00000000E+00,
  0.72088700E+02, 0.109E+03, 0.720E+02, 0.99820000E+00, 0.00000000E+00,
  0.67959000E+02, 0.109E+03, 0.730E+02, 0.99820000E+00, 0.00000000E+00,
  0.59575800E+02, 0.109E+03, 0.740E+02, 0.99820000E+00, 0.00000000E+00,
  0.61094900E+02, 0.109E+03, 0.750E+02, 0.99820000E+00, 0.00000000E+00,
  0.57011100E+02, 0.109E+03, 0.760E+02, 0.99820000E+00, 0.00000000E+00,
  0.53521400E+02, 0.109E+03, 0.770E+02, 0.99820000E+00, 0.00000000E+00,
  0.46144200E+02, 0.109E+03, 0.780E+02, 0.99820000E+00, 0.00000000E+00,
  0.43746800E+02, 0.109E+03, 0.790E+02, 0.99820000E+00, 0.00000000E+00,
  0.45120500E+02, 0.109E+03, 0.800E+02, 0.99820000E+00, 0.00000000E+00,
  0.58912900E+02, 0.109E+03, 0.810E+02, 0.99820000E+00, 0.00000000E+00,
  0.59109700E+02, 0.109E+03, 0.820E+02, 0.99820000E+00, 0.00000000E+00,
  0.56500700E+02, 0.109E+03, 0.830E+02, 0.99820000E+00, 0.00000000E+00,
  0.55261400E+02, 0.109E+03, 0.840E+02, 0.99820000E+00, 0.00000000E+00,
  0.52703300E+02, 0.109E+03, 0.850E+02, 0.99820000E+00, 0.00000000E+00,
  0.49892700E+02, 0.109E+03, 0.860E+02, 0.99820000E+00, 0.00000000E+00,
  0.11543210E+03, 0.109E+03, 0.870E+02, 0.99820000E+00, 0.00000000E+00,
  0.11600620E+03, 0.109E+03, 0.880E+02, 0.99820000E+00, 0.00000000E+00,
  0.10653030E+03, 0.109E+03, 0.890E+02, 0.99820000E+00, 0.00000000E+00,
  0.10090290E+03, 0.109E+03, 0.900E+02, 0.99820000E+00, 0.00000000E+00,
  0.98576800E+02, 0.109E+03, 0.910E+02, 0.99820000E+00, 0.00000000E+00,
  0.95662500E+02, 0.109E+03, 0.920E+02, 0.99820000E+00, 0.00000000E+00,
  0.95732200E+02, 0.109E+03, 0.930E+02, 0.99820000E+00, 0.00000000E+00,
  0.93161400E+02, 0.109E+03, 0.940E+02, 0.99820000E+00, 0.00000000E+00,
  0.63000000E+01, 0.109E+03, 0.101E+03, 0.99820000E+00, 0.00000000E+00,
  0.17173300E+02, 0.109E+03, 0.103E+03, 0.99820000E+00, 0.98650000E+00,
  0.22541300E+02, 0.109E+03, 0.104E+03, 0.99820000E+00, 0.98080000E+00,
  0.19202900E+02, 0.109E+03, 0.105E+03, 0.99820000E+00, 0.97060000E+00,
  0.15685700E+02, 0.109E+03, 0.106E+03, 0.99820000E+00, 0.98680000E+00,
  0.11947000E+02, 0.109E+03, 0.107E+03, 0.99820000E+00, 0.99440000E+00,
  0.94048000E+01, 0.109E+03, 0.108E+03, 0.99820000E+00, 0.99250000E+00,
  0.71341000E+01, 0.109E+03, 0.109E+03, 0.99820000E+00, 0.99820000E+00,
  0.20756700E+02, 0.111E+03, 0.100E+01, 0.96840000E+00, 0.91180000E+00,
  0.12728700E+02, 0.111E+03, 0.200E+01, 0.96840000E+00, 0.00000000E+00,
  0.42571610E+03, 0.111E+03, 0.300E+01, 0.96840000E+00, 0.00000000E+00,
  0.21865720E+03, 0.111E+03, 0.400E+01, 0.96840000E+00, 0.00000000E+00,
  0.13695360E+03, 0.111E+03, 0.500E+01, 0.96840000E+00, 0.00000000E+00,
  0.87395600E+02, 0.111E+03, 0.600E+01, 0.96840000E+00, 0.00000000E+00,
  0.58485300E+02, 0.111E+03, 0.700E+01, 0.96840000E+00, 0.00000000E+00,
  0.42891100E+02, 0.111E+03, 0.800E+01, 0.96840000E+00, 0.00000000E+00,
  0.31606000E+02, 0.111E+03, 0.900E+01, 0.96840000E+00, 0.00000000E+00,
  0.23774500E+02, 0.111E+03, 0.100E+02, 0.96840000E+00, 0.00000000E+00,
  0.50543630E+03, 0.111E+03, 0.110E+02, 0.96840000E+00, 0.00000000E+00,
  0.35591800E+03, 0.111E+03, 0.120E+02, 0.96840000E+00, 0.00000000E+00,
  0.31645880E+03, 0.111E+03, 0.130E+02, 0.96840000E+00, 0.00000000E+00,
  0.23713260E+03, 0.111E+03, 0.140E+02, 0.96840000E+00, 0.00000000E+00,
  0.17692050E+03, 0.111E+03, 0.150E+02, 0.96840000E+00, 0.00000000E+00,
  0.14254300E+03, 0.111E+03, 0.160E+02, 0.96840000E+00, 0.00000000E+00,
  0.11310250E+03, 0.111E+03, 0.170E+02, 0.96840000E+00, 0.00000000E+00,
  0.90173500E+02, 0.111E+03, 0.180E+02, 0.96840000E+00, 0.00000000E+00,
  0.84082990E+03, 0.111E+03, 0.190E+02, 0.96840000E+00, 0.00000000E+00,
  0.64831050E+03, 0.111E+03, 0.200E+02, 0.96840000E+00, 0.00000000E+00,
  0.52709170E+03, 0.111E+03, 0.210E+02, 0.96840000E+00, 0.00000000E+00,
  0.50123930E+03, 0.111E+03, 0.220E+02, 0.96840000E+00, 0.00000000E+00,
  0.45480300E+03, 0.111E+03, 0.230E+02, 0.96840000E+00, 0.00000000E+00,
  0.35715080E+03, 0.111E+03, 0.240E+02, 0.96840000E+00, 0.00000000E+00,
  0.38634260E+03, 0.111E+03, 0.250E+02, 0.96840000E+00, 0.00000000E+00,
  0.30174010E+03, 0.111E+03, 0.260E+02, 0.96840000E+00, 0.00000000E+00,
  0.31417180E+03, 0.111E+03, 0.270E+02, 0.96840000E+00, 0.00000000E+00,
  0.32682710E+03, 0.111E+03, 0.280E+02, 0.96840000E+00, 0.00000000E+00,
  0.24981970E+03, 0.111E+03, 0.290E+02, 0.96840000E+00, 0.00000000E+00,
  0.24939250E+03, 0.111E+03, 0.300E+02, 0.96840000E+00, 0.00000000E+00,
  0.29840070E+03, 0.111E+03, 0.310E+02, 0.96840000E+00, 0.00000000E+00,
  0.25314330E+03, 0.111E+03, 0.320E+02, 0.96840000E+00, 0.00000000E+00,
  0.20818020E+03, 0.111E+03, 0.330E+02, 0.96840000E+00, 0.00000000E+00,
  0.18247440E+03, 0.111E+03, 0.340E+02, 0.96840000E+00, 0.00000000E+00,
  0.15582020E+03, 0.111E+03, 0.350E+02, 0.96840000E+00, 0.00000000E+00,
  0.13243480E+03, 0.111E+03, 0.360E+02, 0.96840000E+00, 0.00000000E+00,
  0.93630060E+03, 0.111E+03, 0.370E+02, 0.96840000E+00, 0.00000000E+00,
  0.77398540E+03, 0.111E+03, 0.380E+02, 0.96840000E+00, 0.00000000E+00,
  0.65879630E+03, 0.111E+03, 0.390E+02, 0.96840000E+00, 0.00000000E+00,
  0.58124800E+03, 0.111E+03, 0.400E+02, 0.96840000E+00, 0.00000000E+00,
  0.52340580E+03, 0.111E+03, 0.410E+02, 0.96840000E+00, 0.00000000E+00,
  0.39500580E+03, 0.111E+03, 0.420E+02, 0.96840000E+00, 0.00000000E+00,
  0.44452690E+03, 0.111E+03, 0.430E+02, 0.96840000E+00, 0.00000000E+00,
  0.33022730E+03, 0.111E+03, 0.440E+02, 0.96840000E+00, 0.00000000E+00,
  0.36142870E+03, 0.111E+03, 0.450E+02, 0.96840000E+00, 0.00000000E+00,
  0.33243920E+03, 0.111E+03, 0.460E+02, 0.96840000E+00, 0.00000000E+00,
  0.27794280E+03, 0.111E+03, 0.470E+02, 0.96840000E+00, 0.00000000E+00,
  0.28984740E+03, 0.111E+03, 0.480E+02, 0.96840000E+00, 0.00000000E+00,
  0.37337940E+03, 0.111E+03, 0.490E+02, 0.96840000E+00, 0.00000000E+00,
  0.33470230E+03, 0.111E+03, 0.500E+02, 0.96840000E+00, 0.00000000E+00,
  0.28898880E+03, 0.111E+03, 0.510E+02, 0.96840000E+00, 0.00000000E+00,
  0.26288460E+03, 0.111E+03, 0.520E+02, 0.96840000E+00, 0.00000000E+00,
  0.23260530E+03, 0.111E+03, 0.530E+02, 0.96840000E+00, 0.00000000E+00,
  0.20479860E+03, 0.111E+03, 0.540E+02, 0.96840000E+00, 0.00000000E+00,
  0.11389256E+04, 0.111E+03, 0.550E+02, 0.96840000E+00, 0.00000000E+00,
  0.99536600E+03, 0.111E+03, 0.560E+02, 0.96840000E+00, 0.00000000E+00,
  0.85007680E+03, 0.111E+03, 0.570E+02, 0.96840000E+00, 0.00000000E+00,
  0.34313820E+03, 0.111E+03, 0.580E+02, 0.96840000E+00, 0.27991000E+01,
  0.87351340E+03, 0.111E+03, 0.590E+02, 0.96840000E+00, 0.00000000E+00,
  0.83492630E+03, 0.111E+03, 0.600E+02, 0.96840000E+00, 0.00000000E+00,
  0.81293500E+03, 0.111E+03, 0.610E+02, 0.96840000E+00, 0.00000000E+00,
  0.79283360E+03, 0.111E+03, 0.620E+02, 0.96840000E+00, 0.00000000E+00,
  0.77497190E+03, 0.111E+03, 0.630E+02, 0.96840000E+00, 0.00000000E+00,
  0.58968210E+03, 0.111E+03, 0.640E+02, 0.96840000E+00, 0.00000000E+00,
  0.69502110E+03, 0.111E+03, 0.650E+02, 0.96840000E+00, 0.00000000E+00,
  0.66665150E+03, 0.111E+03, 0.660E+02, 0.96840000E+00, 0.00000000E+00,
  0.69407420E+03, 0.111E+03, 0.670E+02, 0.96840000E+00, 0.00000000E+00,
  0.67884860E+03, 0.111E+03, 0.680E+02, 0.96840000E+00, 0.00000000E+00,
  0.66485800E+03, 0.111E+03, 0.690E+02, 0.96840000E+00, 0.00000000E+00,
  0.65799220E+03, 0.111E+03, 0.700E+02, 0.96840000E+00, 0.00000000E+00,
  0.54208720E+03, 0.111E+03, 0.710E+02, 0.96840000E+00, 0.00000000E+00,
  0.51742950E+03, 0.111E+03, 0.720E+02, 0.96840000E+00, 0.00000000E+00,
  0.46327240E+03, 0.111E+03, 0.730E+02, 0.96840000E+00, 0.00000000E+00,
  0.38490910E+03, 0.111E+03, 0.740E+02, 0.96840000E+00, 0.00000000E+00,
  0.38879710E+03, 0.111E+03, 0.750E+02, 0.96840000E+00, 0.00000000E+00,
  0.34639970E+03, 0.111E+03, 0.760E+02, 0.96840000E+00, 0.00000000E+00,
  0.31281320E+03, 0.111E+03, 0.770E+02, 0.96840000E+00, 0.00000000E+00,
  0.25572890E+03, 0.111E+03, 0.780E+02, 0.96840000E+00, 0.00000000E+00,
  0.23740440E+03, 0.111E+03, 0.790E+02, 0.96840000E+00, 0.00000000E+00,
  0.24279190E+03, 0.111E+03, 0.800E+02, 0.96840000E+00, 0.00000000E+00,
  0.37972090E+03, 0.111E+03, 0.810E+02, 0.96840000E+00, 0.00000000E+00,
  0.36256490E+03, 0.111E+03, 0.820E+02, 0.96840000E+00, 0.00000000E+00,
  0.32393500E+03, 0.111E+03, 0.830E+02, 0.96840000E+00, 0.00000000E+00,
  0.30383030E+03, 0.111E+03, 0.840E+02, 0.96840000E+00, 0.00000000E+00,
  0.27473150E+03, 0.111E+03, 0.850E+02, 0.96840000E+00, 0.00000000E+00,
  0.24706350E+03, 0.111E+03, 0.860E+02, 0.96840000E+00, 0.00000000E+00,
  0.10521318E+04, 0.111E+03, 0.870E+02, 0.96840000E+00, 0.00000000E+00,
  0.96974210E+03, 0.111E+03, 0.880E+02, 0.96840000E+00, 0.00000000E+00,
  0.83486500E+03, 0.111E+03, 0.890E+02, 0.96840000E+00, 0.00000000E+00,
  0.72693870E+03, 0.111E+03, 0.900E+02, 0.96840000E+00, 0.00000000E+00,
  0.73265540E+03, 0.111E+03, 0.910E+02, 0.96840000E+00, 0.00000000E+00,
  0.70879360E+03, 0.111E+03, 0.920E+02, 0.96840000E+00, 0.00000000E+00,
  0.74391900E+03, 0.111E+03, 0.930E+02, 0.96840000E+00, 0.00000000E+00,
  0.71791000E+03, 0.111E+03, 0.940E+02, 0.96840000E+00, 0.00000000E+00,
  0.34995200E+02, 0.111E+03, 0.101E+03, 0.96840000E+00, 0.00000000E+00,
  0.12582450E+03, 0.111E+03, 0.103E+03, 0.96840000E+00, 0.98650000E+00,
  0.15832680E+03, 0.111E+03, 0.104E+03, 0.96840000E+00, 0.98080000E+00,
  0.11340160E+03, 0.111E+03, 0.105E+03, 0.96840000E+00, 0.97060000E+00,
  0.82014400E+02, 0.111E+03, 0.106E+03, 0.96840000E+00, 0.98680000E+00,
  0.54445400E+02, 0.111E+03, 0.107E+03, 0.96840000E+00, 0.99440000E+00,
  0.38122700E+02, 0.111E+03, 0.108E+03, 0.96840000E+00, 0.99250000E+00,
  0.24956000E+02, 0.111E+03, 0.109E+03, 0.96840000E+00, 0.99820000E+00,
  0.18610520E+03, 0.111E+03, 0.111E+03, 0.96840000E+00, 0.96840000E+00,
  0.31991300E+02, 0.112E+03, 0.100E+01, 0.96280000E+00, 0.91180000E+00,
  0.19464800E+02, 0.112E+03, 0.200E+01, 0.96280000E+00, 0.00000000E+00,
  0.67003300E+03, 0.112E+03, 0.300E+01, 0.96280000E+00, 0.00000000E+00,
  0.34026020E+03, 0.112E+03, 0.400E+01, 0.96280000E+00, 0.00000000E+00,
  0.21221800E+03, 0.112E+03, 0.500E+01, 0.96280000E+00, 0.00000000E+00,
  0.13492270E+03, 0.112E+03, 0.600E+01, 0.96280000E+00, 0.00000000E+00,
  0.89964600E+02, 0.112E+03, 0.700E+01, 0.96280000E+00, 0.00000000E+00,
  0.65760900E+02, 0.112E+03, 0.800E+01, 0.96280000E+00, 0.00000000E+00,
  0.48286500E+02, 0.112E+03, 0.900E+01, 0.96280000E+00, 0.00000000E+00,
  0.36191100E+02, 0.112E+03, 0.100E+02, 0.96280000E+00, 0.00000000E+00,
  0.79475970E+03, 0.112E+03, 0.110E+02, 0.96280000E+00, 0.00000000E+00,
  0.55459670E+03, 0.112E+03, 0.120E+02, 0.96280000E+00, 0.00000000E+00,
  0.49208290E+03, 0.112E+03, 0.130E+02, 0.96280000E+00, 0.00000000E+00,
  0.36758110E+03, 0.112E+03, 0.140E+02, 0.96280000E+00, 0.00000000E+00,
  0.27352680E+03, 0.112E+03, 0.150E+02, 0.96280000E+00, 0.00000000E+00,
  0.21994890E+03, 0.112E+03, 0.160E+02, 0.96280000E+00, 0.00000000E+00,
  0.17413990E+03, 0.112E+03, 0.170E+02, 0.96280000E+00, 0.00000000E+00,
  0.13851900E+03, 0.112E+03, 0.180E+02, 0.96280000E+00, 0.00000000E+00,
  0.13273176E+04, 0.112E+03, 0.190E+02, 0.96280000E+00, 0.00000000E+00,
  0.10137695E+04, 0.112E+03, 0.200E+02, 0.96280000E+00, 0.00000000E+00,
  0.82289570E+03, 0.112E+03, 0.210E+02, 0.96280000E+00, 0.00000000E+00,
  0.78169930E+03, 0.112E+03, 0.220E+02, 0.96280000E+00, 0.00000000E+00,
  0.70876840E+03, 0.112E+03, 0.230E+02, 0.96280000E+00, 0.00000000E+00,
  0.55661270E+03, 0.112E+03, 0.240E+02, 0.96280000E+00, 0.00000000E+00,
  0.60144990E+03, 0.112E+03, 0.250E+02, 0.96280000E+00, 0.00000000E+00,
  0.46964370E+03, 0.112E+03, 0.260E+02, 0.96280000E+00, 0.00000000E+00,
  0.48817150E+03, 0.112E+03, 0.270E+02, 0.96280000E+00, 0.00000000E+00,
  0.50815850E+03, 0.112E+03, 0.280E+02, 0.96280000E+00, 0.00000000E+00,
  0.38842090E+03, 0.112E+03, 0.290E+02, 0.96280000E+00, 0.00000000E+00,
  0.38688840E+03, 0.112E+03, 0.300E+02, 0.96280000E+00, 0.00000000E+00,
  0.46356910E+03, 0.112E+03, 0.310E+02, 0.96280000E+00, 0.00000000E+00,
  0.39225330E+03, 0.112E+03, 0.320E+02, 0.96280000E+00, 0.00000000E+00,
  0.32187320E+03, 0.112E+03, 0.330E+02, 0.96280000E+00, 0.00000000E+00,
  0.28171730E+03, 0.112E+03, 0.340E+02, 0.96280000E+00, 0.00000000E+00,
  0.24015650E+03, 0.112E+03, 0.350E+02, 0.96280000E+00, 0.00000000E+00,
  0.20374730E+03, 0.112E+03, 0.360E+02, 0.96280000E+00, 0.00000000E+00,
  0.14776556E+04, 0.112E+03, 0.370E+02, 0.96280000E+00, 0.00000000E+00,
  0.12109593E+04, 0.112E+03, 0.380E+02, 0.96280000E+00, 0.00000000E+00,
  0.10281365E+04, 0.112E+03, 0.390E+02, 0.96280000E+00, 0.00000000E+00,
  0.90577500E+03, 0.112E+03, 0.400E+02, 0.96280000E+00, 0.00000000E+00,
  0.81492890E+03, 0.112E+03, 0.410E+02, 0.96280000E+00, 0.00000000E+00,
  0.61402650E+03, 0.112E+03, 0.420E+02, 0.96280000E+00, 0.00000000E+00,
  0.69144970E+03, 0.112E+03, 0.430E+02, 0.96280000E+00, 0.00000000E+00,
  0.51267590E+03, 0.112E+03, 0.440E+02, 0.96280000E+00, 0.00000000E+00,
  0.56100100E+03, 0.112E+03, 0.450E+02, 0.96280000E+00, 0.00000000E+00,
  0.51564570E+03, 0.112E+03, 0.460E+02, 0.96280000E+00, 0.00000000E+00,
  0.43128070E+03, 0.112E+03, 0.470E+02, 0.96280000E+00, 0.00000000E+00,
  0.44915670E+03, 0.112E+03, 0.480E+02, 0.96280000E+00, 0.00000000E+00,
  0.57992340E+03, 0.112E+03, 0.490E+02, 0.96280000E+00, 0.00000000E+00,
  0.51865180E+03, 0.112E+03, 0.500E+02, 0.96280000E+00, 0.00000000E+00,
  0.44692300E+03, 0.112E+03, 0.510E+02, 0.96280000E+00, 0.00000000E+00,
  0.40607280E+03, 0.112E+03, 0.520E+02, 0.96280000E+00, 0.00000000E+00,
  0.35880520E+03, 0.112E+03, 0.530E+02, 0.96280000E+00, 0.00000000E+00,
  0.31545810E+03, 0.112E+03, 0.540E+02, 0.96280000E+00, 0.00000000E+00,
  0.17990180E+04, 0.112E+03, 0.550E+02, 0.96280000E+00, 0.00000000E+00,
  0.15595050E+04, 0.112E+03, 0.560E+02, 0.96280000E+00, 0.00000000E+00,
  0.13282510E+04, 0.112E+03, 0.570E+02, 0.96280000E+00, 0.00000000E+00,
  0.53086500E+03, 0.112E+03, 0.580E+02, 0.96280000E+00, 0.27991000E+01,
  0.13672714E+04, 0.112E+03, 0.590E+02, 0.96280000E+00, 0.00000000E+00,
  0.13059000E+04, 0.112E+03, 0.600E+02, 0.96280000E+00, 0.00000000E+00,
  0.12712883E+04, 0.112E+03, 0.610E+02, 0.96280000E+00, 0.00000000E+00,
  0.12396749E+04, 0.112E+03, 0.620E+02, 0.96280000E+00, 0.00000000E+00,
  0.12115825E+04, 0.112E+03, 0.630E+02, 0.96280000E+00, 0.00000000E+00,
  0.91963290E+03, 0.112E+03, 0.640E+02, 0.96280000E+00, 0.00000000E+00,
  0.10898214E+04, 0.112E+03, 0.650E+02, 0.96280000E+00, 0.00000000E+00,
  0.10451961E+04, 0.112E+03, 0.660E+02, 0.96280000E+00, 0.00000000E+00,
  0.10842313E+04, 0.112E+03, 0.670E+02, 0.96280000E+00, 0.00000000E+00,
  0.10603386E+04, 0.112E+03, 0.680E+02, 0.96280000E+00, 0.00000000E+00,
  0.10383601E+04, 0.112E+03, 0.690E+02, 0.96280000E+00, 0.00000000E+00,
  0.10277356E+04, 0.112E+03, 0.700E+02, 0.96280000E+00, 0.00000000E+00,
  0.84553860E+03, 0.112E+03, 0.710E+02, 0.96280000E+00, 0.00000000E+00,
  0.80500140E+03, 0.112E+03, 0.720E+02, 0.96280000E+00, 0.00000000E+00,
  0.71971520E+03, 0.112E+03, 0.730E+02, 0.96280000E+00, 0.00000000E+00,
  0.59743440E+03, 0.112E+03, 0.740E+02, 0.96280000E+00, 0.00000000E+00,
  0.60309070E+03, 0.112E+03, 0.750E+02, 0.96280000E+00, 0.00000000E+00,
  0.53662210E+03, 0.112E+03, 0.760E+02, 0.96280000E+00, 0.00000000E+00,
  0.48407160E+03, 0.112E+03, 0.770E+02, 0.96280000E+00, 0.00000000E+00,
  0.39524010E+03, 0.112E+03, 0.780E+02, 0.96280000E+00, 0.00000000E+00,
  0.36670170E+03, 0.112E+03, 0.790E+02, 0.96280000E+00, 0.00000000E+00,
  0.37485520E+03, 0.112E+03, 0.800E+02, 0.96280000E+00, 0.00000000E+00,
  0.58953950E+03, 0.112E+03, 0.810E+02, 0.96280000E+00, 0.00000000E+00,
  0.56172980E+03, 0.112E+03, 0.820E+02, 0.96280000E+00, 0.00000000E+00,
  0.50092230E+03, 0.112E+03, 0.830E+02, 0.96280000E+00, 0.00000000E+00,
  0.46935230E+03, 0.112E+03, 0.840E+02, 0.96280000E+00, 0.00000000E+00,
  0.42385000E+03, 0.112E+03, 0.850E+02, 0.96280000E+00, 0.00000000E+00,
  0.38067930E+03, 0.112E+03, 0.860E+02, 0.96280000E+00, 0.00000000E+00,
  0.16575070E+04, 0.112E+03, 0.870E+02, 0.96280000E+00, 0.00000000E+00,
  0.15173457E+04, 0.112E+03, 0.880E+02, 0.96280000E+00, 0.00000000E+00,
  0.13028376E+04, 0.112E+03, 0.890E+02, 0.96280000E+00, 0.00000000E+00,
  0.11313898E+04, 0.112E+03, 0.900E+02, 0.96280000E+00, 0.00000000E+00,
  0.11418668E+04, 0.112E+03, 0.910E+02, 0.96280000E+00, 0.00000000E+00,
  0.11045083E+04, 0.112E+03, 0.920E+02, 0.96280000E+00, 0.00000000E+00,
  0.11608135E+04, 0.112E+03, 0.930E+02, 0.96280000E+00, 0.00000000E+00,
  0.11198466E+04, 0.112E+03, 0.940E+02, 0.96280000E+00, 0.00000000E+00,
  0.54102100E+02, 0.112E+03, 0.101E+03, 0.96280000E+00, 0.00000000E+00,
  0.19570570E+03, 0.112E+03, 0.103E+03, 0.96280000E+00, 0.98650000E+00,
  0.24622270E+03, 0.112E+03, 0.104E+03, 0.96280000E+00, 0.98080000E+00,
  0.17556460E+03, 0.112E+03, 0.105E+03, 0.96280000E+00, 0.97060000E+00,
  0.12666570E+03, 0.112E+03, 0.106E+03, 0.96280000E+00, 0.98680000E+00,
  0.83770300E+02, 0.112E+03, 0.107E+03, 0.96280000E+00, 0.99440000E+00,
  0.58430300E+02, 0.112E+03, 0.108E+03, 0.96280000E+00, 0.99250000E+00,
  0.37988400E+02, 0.112E+03, 0.109E+03, 0.96280000E+00, 0.99820000E+00,
  0.28960820E+03, 0.112E+03, 0.111E+03, 0.96280000E+00, 0.96840000E+00,
  0.45127080E+03, 0.112E+03, 0.112E+03, 0.96280000E+00, 0.96280000E+00,
  0.33104800E+02, 0.113E+03, 0.100E+01, 0.96480000E+00, 0.91180000E+00,
  0.20515800E+02, 0.113E+03, 0.200E+01, 0.96480000E+00, 0.00000000E+00,
  0.62753090E+03, 0.113E+03, 0.300E+01, 0.96480000E+00, 0.00000000E+00,
  0.33473350E+03, 0.113E+03, 0.400E+01, 0.96480000E+00, 0.00000000E+00,
  0.21388480E+03, 0.113E+03, 0.500E+01, 0.96480000E+00, 0.00000000E+00,
  0.13832540E+03, 0.113E+03, 0.600E+01, 0.96480000E+00, 0.00000000E+00,
  0.93354200E+02, 0.113E+03, 0.700E+01, 0.96480000E+00, 0.00000000E+00,
  0.68798300E+02, 0.113E+03, 0.800E+01, 0.96480000E+00, 0.00000000E+00,
  0.50857700E+02, 0.113E+03, 0.900E+01, 0.96480000E+00, 0.00000000E+00,
  0.38315400E+02, 0.113E+03, 0.100E+02, 0.96480000E+00, 0.00000000E+00,
  0.74634190E+03, 0.113E+03, 0.110E+02, 0.96480000E+00, 0.00000000E+00,
  0.54102850E+03, 0.113E+03, 0.120E+02, 0.96480000E+00, 0.00000000E+00,
  0.48623650E+03, 0.113E+03, 0.130E+02, 0.96480000E+00, 0.00000000E+00,
  0.36962320E+03, 0.113E+03, 0.140E+02, 0.96480000E+00, 0.00000000E+00,
  0.27892720E+03, 0.113E+03, 0.150E+02, 0.96480000E+00, 0.00000000E+00,
  0.22621560E+03, 0.113E+03, 0.160E+02, 0.96480000E+00, 0.00000000E+00,
  0.18054300E+03, 0.113E+03, 0.170E+02, 0.96480000E+00, 0.00000000E+00,
  0.14457980E+03, 0.113E+03, 0.180E+02, 0.96480000E+00, 0.00000000E+00,
  0.12332237E+04, 0.113E+03, 0.190E+02, 0.96480000E+00, 0.00000000E+00,
  0.97304930E+03, 0.113E+03, 0.200E+02, 0.96480000E+00, 0.00000000E+00,
  0.79522060E+03, 0.113E+03, 0.210E+02, 0.96480000E+00, 0.00000000E+00,
  0.75945320E+03, 0.113E+03, 0.220E+02, 0.96480000E+00, 0.00000000E+00,
  0.69091560E+03, 0.113E+03, 0.230E+02, 0.96480000E+00, 0.00000000E+00,
  0.54224590E+03, 0.113E+03, 0.240E+02, 0.96480000E+00, 0.00000000E+00,
  0.58914750E+03, 0.113E+03, 0.250E+02, 0.96480000E+00, 0.00000000E+00,
  0.46004960E+03, 0.113E+03, 0.260E+02, 0.96480000E+00, 0.00000000E+00,
  0.48229900E+03, 0.113E+03, 0.270E+02, 0.96480000E+00, 0.00000000E+00,
  0.50035250E+03, 0.113E+03, 0.280E+02, 0.96480000E+00, 0.00000000E+00,
  0.38199230E+03, 0.113E+03, 0.290E+02, 0.96480000E+00, 0.00000000E+00,
  0.38514490E+03, 0.113E+03, 0.300E+02, 0.96480000E+00, 0.00000000E+00,
  0.45995440E+03, 0.113E+03, 0.310E+02, 0.96480000E+00, 0.00000000E+00,
  0.39466500E+03, 0.113E+03, 0.320E+02, 0.96480000E+00, 0.00000000E+00,
  0.32772290E+03, 0.113E+03, 0.330E+02, 0.96480000E+00, 0.00000000E+00,
  0.28884850E+03, 0.113E+03, 0.340E+02, 0.96480000E+00, 0.00000000E+00,
  0.24796920E+03, 0.113E+03, 0.350E+02, 0.96480000E+00, 0.00000000E+00,
  0.21169490E+03, 0.113E+03, 0.360E+02, 0.96480000E+00, 0.00000000E+00,
  0.13752558E+04, 0.113E+03, 0.370E+02, 0.96480000E+00, 0.00000000E+00,
  0.11602539E+04, 0.113E+03, 0.380E+02, 0.96480000E+00, 0.00000000E+00,
  0.99637570E+03, 0.113E+03, 0.390E+02, 0.96480000E+00, 0.00000000E+00,
  0.88385410E+03, 0.113E+03, 0.400E+02, 0.96480000E+00, 0.00000000E+00,
  0.79860940E+03, 0.113E+03, 0.410E+02, 0.96480000E+00, 0.00000000E+00,
  0.60591350E+03, 0.113E+03, 0.420E+02, 0.96480000E+00, 0.00000000E+00,
  0.68054270E+03, 0.113E+03, 0.430E+02, 0.96480000E+00, 0.00000000E+00,
  0.50852890E+03, 0.113E+03, 0.440E+02, 0.96480000E+00, 0.00000000E+00,
  0.55700430E+03, 0.113E+03, 0.450E+02, 0.96480000E+00, 0.00000000E+00,
  0.51341630E+03, 0.113E+03, 0.460E+02, 0.96480000E+00, 0.00000000E+00,
  0.42799620E+03, 0.113E+03, 0.470E+02, 0.96480000E+00, 0.00000000E+00,
  0.44880710E+03, 0.113E+03, 0.480E+02, 0.96480000E+00, 0.00000000E+00,
  0.57434200E+03, 0.113E+03, 0.490E+02, 0.96480000E+00, 0.00000000E+00,
  0.51984240E+03, 0.113E+03, 0.500E+02, 0.96480000E+00, 0.00000000E+00,
  0.45284940E+03, 0.113E+03, 0.510E+02, 0.96480000E+00, 0.00000000E+00,
  0.41405440E+03, 0.113E+03, 0.520E+02, 0.96480000E+00, 0.00000000E+00,
  0.36827920E+03, 0.113E+03, 0.530E+02, 0.96480000E+00, 0.00000000E+00,
  0.32576250E+03, 0.113E+03, 0.540E+02, 0.96480000E+00, 0.00000000E+00,
  0.16731922E+04, 0.113E+03, 0.550E+02, 0.96480000E+00, 0.00000000E+00,
  0.14872964E+04, 0.113E+03, 0.560E+02, 0.96480000E+00, 0.00000000E+00,
  0.12815229E+04, 0.113E+03, 0.570E+02, 0.96480000E+00, 0.00000000E+00,
  0.53656260E+03, 0.113E+03, 0.580E+02, 0.96480000E+00, 0.27991000E+01,
  0.13086041E+04, 0.113E+03, 0.590E+02, 0.96480000E+00, 0.00000000E+00,
  0.12526928E+04, 0.113E+03, 0.600E+02, 0.96480000E+00, 0.00000000E+00,
  0.12202246E+04, 0.113E+03, 0.610E+02, 0.96480000E+00, 0.00000000E+00,
  0.11905003E+04, 0.113E+03, 0.620E+02, 0.96480000E+00, 0.00000000E+00,
  0.11641089E+04, 0.113E+03, 0.630E+02, 0.96480000E+00, 0.00000000E+00,
  0.89395150E+03, 0.113E+03, 0.640E+02, 0.96480000E+00, 0.00000000E+00,
  0.10381047E+04, 0.113E+03, 0.650E+02, 0.96480000E+00, 0.00000000E+00,
  0.99738370E+03, 0.113E+03, 0.660E+02, 0.96480000E+00, 0.00000000E+00,
  0.10450038E+04, 0.113E+03, 0.670E+02, 0.96480000E+00, 0.00000000E+00,
  0.10223674E+04, 0.113E+03, 0.680E+02, 0.96480000E+00, 0.00000000E+00,
  0.10016784E+04, 0.113E+03, 0.690E+02, 0.96480000E+00, 0.00000000E+00,
  0.99098080E+03, 0.113E+03, 0.700E+02, 0.96480000E+00, 0.00000000E+00,
  0.82160050E+03, 0.113E+03, 0.710E+02, 0.96480000E+00, 0.00000000E+00,
  0.79184560E+03, 0.113E+03, 0.720E+02, 0.96480000E+00, 0.00000000E+00,
  0.71274220E+03, 0.113E+03, 0.730E+02, 0.96480000E+00, 0.00000000E+00,
  0.59416160E+03, 0.113E+03, 0.740E+02, 0.96480000E+00, 0.00000000E+00,
  0.60157800E+03, 0.113E+03, 0.750E+02, 0.96480000E+00, 0.00000000E+00,
  0.53838550E+03, 0.113E+03, 0.760E+02, 0.96480000E+00, 0.00000000E+00,
  0.48789840E+03, 0.113E+03, 0.770E+02, 0.96480000E+00, 0.00000000E+00,
  0.39997680E+03, 0.113E+03, 0.780E+02, 0.96480000E+00, 0.00000000E+00,
  0.37172100E+03, 0.113E+03, 0.790E+02, 0.96480000E+00, 0.00000000E+00,
  0.38105900E+03, 0.113E+03, 0.800E+02, 0.96480000E+00, 0.00000000E+00,
  0.58469720E+03, 0.113E+03, 0.810E+02, 0.96480000E+00, 0.00000000E+00,
  0.56268750E+03, 0.113E+03, 0.820E+02, 0.96480000E+00, 0.00000000E+00,
  0.50686630E+03, 0.113E+03, 0.830E+02, 0.96480000E+00, 0.00000000E+00,
  0.47758620E+03, 0.113E+03, 0.840E+02, 0.96480000E+00, 0.00000000E+00,
  0.43409690E+03, 0.113E+03, 0.850E+02, 0.96480000E+00, 0.00000000E+00,
  0.39211690E+03, 0.113E+03, 0.860E+02, 0.96480000E+00, 0.00000000E+00,
  0.15558848E+04, 0.113E+03, 0.870E+02, 0.96480000E+00, 0.00000000E+00,
  0.14554241E+04, 0.113E+03, 0.880E+02, 0.96480000E+00, 0.00000000E+00,
  0.12633724E+04, 0.113E+03, 0.890E+02, 0.96480000E+00, 0.00000000E+00,
  0.11100628E+04, 0.113E+03, 0.900E+02, 0.96480000E+00, 0.00000000E+00,
  0.11130738E+04, 0.113E+03, 0.910E+02, 0.96480000E+00, 0.00000000E+00,
  0.10770005E+04, 0.113E+03, 0.920E+02, 0.96480000E+00, 0.00000000E+00,
  0.11238008E+04, 0.113E+03, 0.930E+02, 0.96480000E+00, 0.00000000E+00,
  0.10856846E+04, 0.113E+03, 0.940E+02, 0.96480000E+00, 0.00000000E+00,
  0.55263600E+02, 0.113E+03, 0.101E+03, 0.96480000E+00, 0.00000000E+00,
  0.19307070E+03, 0.113E+03, 0.103E+03, 0.96480000E+00, 0.98650000E+00,
  0.24376120E+03, 0.113E+03, 0.104E+03, 0.96480000E+00, 0.98080000E+00,
  0.17772540E+03, 0.113E+03, 0.105E+03, 0.96480000E+00, 0.97060000E+00,
  0.12969220E+03, 0.113E+03, 0.106E+03, 0.96480000E+00, 0.98680000E+00,
  0.86872800E+02, 0.113E+03, 0.107E+03, 0.96480000E+00, 0.99440000E+00,
  0.61217500E+02, 0.113E+03, 0.108E+03, 0.96480000E+00, 0.99250000E+00,
  0.40322000E+02, 0.113E+03, 0.109E+03, 0.96480000E+00, 0.99820000E+00,
  0.28422510E+03, 0.113E+03, 0.111E+03, 0.96480000E+00, 0.96840000E+00,
  0.44173220E+03, 0.113E+03, 0.112E+03, 0.96480000E+00, 0.96280000E+00,
  0.43775750E+03, 0.113E+03, 0.113E+03, 0.96480000E+00, 0.96480000E+00,
  0.27498900E+02, 0.114E+03, 0.100E+01, 0.95070000E+00, 0.91180000E+00,
  0.17635600E+02, 0.114E+03, 0.200E+01, 0.95070000E+00, 0.00000000E+00,
  0.45095830E+03, 0.114E+03, 0.300E+01, 0.95070000E+00, 0.00000000E+00,
  0.25658810E+03, 0.114E+03, 0.400E+01, 0.95070000E+00, 0.00000000E+00,
  0.17018910E+03, 0.114E+03, 0.500E+01, 0.95070000E+00, 0.00000000E+00,
  0.11320460E+03, 0.114E+03, 0.600E+01, 0.95070000E+00, 0.00000000E+00,
  0.78019000E+02, 0.114E+03, 0.700E+01, 0.95070000E+00, 0.00000000E+00,
  0.58355700E+02, 0.114E+03, 0.800E+01, 0.95070000E+00, 0.00000000E+00,
  0.43685500E+02, 0.114E+03, 0.900E+01, 0.95070000E+00, 0.00000000E+00,
  0.33241600E+02, 0.114E+03, 0.100E+02, 0.95070000E+00, 0.00000000E+00,
  0.53834120E+03, 0.114E+03, 0.110E+02, 0.95070000E+00, 0.00000000E+00,
  0.40991740E+03, 0.114E+03, 0.120E+02, 0.95070000E+00, 0.00000000E+00,
  0.37552330E+03, 0.114E+03, 0.130E+02, 0.95070000E+00, 0.00000000E+00,
  0.29299940E+03, 0.114E+03, 0.140E+02, 0.95070000E+00, 0.00000000E+00,
  0.22606570E+03, 0.114E+03, 0.150E+02, 0.95070000E+00, 0.00000000E+00,
  0.18600510E+03, 0.114E+03, 0.160E+02, 0.95070000E+00, 0.00000000E+00,
  0.15052310E+03, 0.114E+03, 0.170E+02, 0.95070000E+00, 0.00000000E+00,
  0.12200120E+03, 0.114E+03, 0.180E+02, 0.95070000E+00, 0.00000000E+00,
  0.88126240E+03, 0.114E+03, 0.190E+02, 0.95070000E+00, 0.00000000E+00,
  0.72251110E+03, 0.114E+03, 0.200E+02, 0.95070000E+00, 0.00000000E+00,
  0.59567250E+03, 0.114E+03, 0.210E+02, 0.95070000E+00, 0.00000000E+00,
  0.57349880E+03, 0.114E+03, 0.220E+02, 0.95070000E+00, 0.00000000E+00,
  0.52428080E+03, 0.114E+03, 0.230E+02, 0.95070000E+00, 0.00000000E+00,
  0.41188790E+03, 0.114E+03, 0.240E+02, 0.95070000E+00, 0.00000000E+00,
  0.45022340E+03, 0.114E+03, 0.250E+02, 0.95070000E+00, 0.00000000E+00,
  0.35224080E+03, 0.114E+03, 0.260E+02, 0.95070000E+00, 0.00000000E+00,
  0.37301250E+03, 0.114E+03, 0.270E+02, 0.95070000E+00, 0.00000000E+00,
  0.38500480E+03, 0.114E+03, 0.280E+02, 0.95070000E+00, 0.00000000E+00,
  0.29414060E+03, 0.114E+03, 0.290E+02, 0.95070000E+00, 0.00000000E+00,
  0.30117090E+03, 0.114E+03, 0.300E+02, 0.95070000E+00, 0.00000000E+00,
  0.35794110E+03, 0.114E+03, 0.310E+02, 0.95070000E+00, 0.00000000E+00,
  0.31339110E+03, 0.114E+03, 0.320E+02, 0.95070000E+00, 0.00000000E+00,
  0.26507110E+03, 0.114E+03, 0.330E+02, 0.95070000E+00, 0.00000000E+00,
  0.23633230E+03, 0.114E+03, 0.340E+02, 0.95070000E+00, 0.00000000E+00,
  0.20529760E+03, 0.114E+03, 0.350E+02, 0.95070000E+00, 0.00000000E+00,
  0.17718110E+03, 0.114E+03, 0.360E+02, 0.95070000E+00, 0.00000000E+00,
  0.98604380E+03, 0.114E+03, 0.370E+02, 0.95070000E+00, 0.00000000E+00,
  0.86034210E+03, 0.114E+03, 0.380E+02, 0.95070000E+00, 0.00000000E+00,
  0.75038170E+03, 0.114E+03, 0.390E+02, 0.95070000E+00, 0.00000000E+00,
  0.67218340E+03, 0.114E+03, 0.400E+02, 0.95070000E+00, 0.00000000E+00,
  0.61131470E+03, 0.114E+03, 0.410E+02, 0.95070000E+00, 0.00000000E+00,
  0.46910920E+03, 0.114E+03, 0.420E+02, 0.95070000E+00, 0.00000000E+00,
  0.52464790E+03, 0.114E+03, 0.430E+02, 0.95070000E+00, 0.00000000E+00,
  0.39698620E+03, 0.114E+03, 0.440E+02, 0.95070000E+00, 0.00000000E+00,
  0.43472510E+03, 0.114E+03, 0.450E+02, 0.95070000E+00, 0.00000000E+00,
  0.40236620E+03, 0.114E+03, 0.460E+02, 0.95070000E+00, 0.00000000E+00,
  0.33466730E+03, 0.114E+03, 0.470E+02, 0.95070000E+00, 0.00000000E+00,
  0.35359760E+03, 0.114E+03, 0.480E+02, 0.95070000E+00, 0.00000000E+00,
  0.44659370E+03, 0.114E+03, 0.490E+02, 0.95070000E+00, 0.00000000E+00,
  0.41089600E+03, 0.114E+03, 0.500E+02, 0.95070000E+00, 0.00000000E+00,
  0.36378460E+03, 0.114E+03, 0.510E+02, 0.95070000E+00, 0.00000000E+00,
  0.33592400E+03, 0.114E+03, 0.520E+02, 0.95070000E+00, 0.00000000E+00,
  0.30198520E+03, 0.114E+03, 0.530E+02, 0.95070000E+00, 0.00000000E+00,
  0.26983720E+03, 0.114E+03, 0.540E+02, 0.95070000E+00, 0.00000000E+00,
  0.12005803E+04, 0.114E+03, 0.550E+02, 0.95070000E+00, 0.00000000E+00,
  0.10973980E+04, 0.114E+03, 0.560E+02, 0.95070000E+00, 0.00000000E+00,
  0.96023320E+03, 0.114E+03, 0.570E+02, 0.95070000E+00, 0.00000000E+00,
  0.42980740E+03, 0.114E+03, 0.580E+02, 0.95070000E+00, 0.27991000E+01,
  0.97039570E+03, 0.114E+03, 0.590E+02, 0.95070000E+00, 0.00000000E+00,
  0.93129170E+03, 0.114E+03, 0.600E+02, 0.95070000E+00, 0.00000000E+00,
  0.90779700E+03, 0.114E+03, 0.610E+02, 0.95070000E+00, 0.00000000E+00,
  0.88621930E+03, 0.114E+03, 0.620E+02, 0.95070000E+00, 0.00000000E+00,
  0.86708440E+03, 0.114E+03, 0.630E+02, 0.95070000E+00, 0.00000000E+00,
  0.67748060E+03, 0.114E+03, 0.640E+02, 0.95070000E+00, 0.00000000E+00,
  0.76730550E+03, 0.114E+03, 0.650E+02, 0.95070000E+00, 0.00000000E+00,
  0.73939750E+03, 0.114E+03, 0.660E+02, 0.95070000E+00, 0.00000000E+00,
  0.78137480E+03, 0.114E+03, 0.670E+02, 0.95070000E+00, 0.00000000E+00,
  0.76476680E+03, 0.114E+03, 0.680E+02, 0.95070000E+00, 0.00000000E+00,
  0.74974130E+03, 0.114E+03, 0.690E+02, 0.95070000E+00, 0.00000000E+00,
  0.74120300E+03, 0.114E+03, 0.700E+02, 0.95070000E+00, 0.00000000E+00,
  0.62181690E+03, 0.114E+03, 0.710E+02, 0.95070000E+00, 0.00000000E+00,
  0.60906080E+03, 0.114E+03, 0.720E+02, 0.95070000E+00, 0.00000000E+00,
  0.55365420E+03, 0.114E+03, 0.730E+02, 0.95070000E+00, 0.00000000E+00,
  0.46519420E+03, 0.114E+03, 0.740E+02, 0.95070000E+00, 0.00000000E+00,
  0.47279230E+03, 0.114E+03, 0.750E+02, 0.95070000E+00, 0.00000000E+00,
  0.42679800E+03, 0.114E+03, 0.760E+02, 0.95070000E+00, 0.00000000E+00,
  0.38949880E+03, 0.114E+03, 0.770E+02, 0.95070000E+00, 0.00000000E+00,
  0.32171830E+03, 0.114E+03, 0.780E+02, 0.95070000E+00, 0.00000000E+00,
  0.29988580E+03, 0.114E+03, 0.790E+02, 0.95070000E+00, 0.00000000E+00,
  0.30842630E+03, 0.114E+03, 0.800E+02, 0.95070000E+00, 0.00000000E+00,
  0.45658720E+03, 0.114E+03, 0.810E+02, 0.95070000E+00, 0.00000000E+00,
  0.44500360E+03, 0.114E+03, 0.820E+02, 0.95070000E+00, 0.00000000E+00,
  0.40670170E+03, 0.114E+03, 0.830E+02, 0.95070000E+00, 0.00000000E+00,
  0.38646750E+03, 0.114E+03, 0.840E+02, 0.95070000E+00, 0.00000000E+00,
  0.35486660E+03, 0.114E+03, 0.850E+02, 0.95070000E+00, 0.00000000E+00,
  0.32354110E+03, 0.114E+03, 0.860E+02, 0.95070000E+00, 0.00000000E+00,
  0.11298915E+04, 0.114E+03, 0.870E+02, 0.95070000E+00, 0.00000000E+00,
  0.10825018E+04, 0.114E+03, 0.880E+02, 0.95070000E+00, 0.00000000E+00,
  0.95314260E+03, 0.114E+03, 0.890E+02, 0.95070000E+00, 0.00000000E+00,
  0.85147580E+03, 0.114E+03, 0.900E+02, 0.95070000E+00, 0.00000000E+00,
  0.84679590E+03, 0.114E+03, 0.910E+02, 0.95070000E+00, 0.00000000E+00,
  0.81968560E+03, 0.114E+03, 0.920E+02, 0.95070000E+00, 0.00000000E+00,
  0.84655430E+03, 0.114E+03, 0.930E+02, 0.95070000E+00, 0.00000000E+00,
  0.81936980E+03, 0.114E+03, 0.940E+02, 0.95070000E+00, 0.00000000E+00,
  0.44903000E+02, 0.114E+03, 0.101E+03, 0.95070000E+00, 0.00000000E+00,
  0.14874780E+03, 0.114E+03, 0.103E+03, 0.95070000E+00, 0.98650000E+00,
  0.18910900E+03, 0.114E+03, 0.104E+03, 0.95070000E+00, 0.98080000E+00,
  0.14251230E+03, 0.114E+03, 0.105E+03, 0.95070000E+00, 0.97060000E+00,
  0.10608060E+03, 0.114E+03, 0.106E+03, 0.95070000E+00, 0.98680000E+00,
  0.72637300E+02, 0.114E+03, 0.107E+03, 0.95070000E+00, 0.99440000E+00,
  0.52131100E+02, 0.114E+03, 0.108E+03, 0.95070000E+00, 0.99250000E+00,
  0.35129000E+02, 0.114E+03, 0.109E+03, 0.95070000E+00, 0.99820000E+00,
  0.21750490E+03, 0.114E+03, 0.111E+03, 0.95070000E+00, 0.96840000E+00,
  0.33702500E+03, 0.114E+03, 0.112E+03, 0.95070000E+00, 0.96280000E+00,
  0.33965160E+03, 0.114E+03, 0.113E+03, 0.95070000E+00, 0.96480000E+00,
  0.27026500E+03, 0.114E+03, 0.114E+03, 0.95070000E+00, 0.95070000E+00,
  0.23090800E+02, 0.115E+03, 0.100E+01, 0.99470000E+00, 0.91180000E+00,
  0.15261900E+02, 0.115E+03, 0.200E+01, 0.99470000E+00, 0.00000000E+00,
  0.33966930E+03, 0.115E+03, 0.300E+01, 0.99470000E+00, 0.00000000E+00,
  0.20222820E+03, 0.115E+03, 0.400E+01, 0.99470000E+00, 0.00000000E+00,
  0.13807740E+03, 0.115E+03, 0.500E+01, 0.99470000E+00, 0.00000000E+00,
  0.93966300E+02, 0.115E+03, 0.600E+01, 0.99470000E+00, 0.00000000E+00,
  0.65912700E+02, 0.115E+03, 0.700E+01, 0.99470000E+00, 0.00000000E+00,
  0.49937400E+02, 0.115E+03, 0.800E+01, 0.99470000E+00, 0.00000000E+00,
  0.37803500E+02, 0.115E+03, 0.900E+01, 0.99470000E+00, 0.00000000E+00,
  0.29028000E+02, 0.115E+03, 0.100E+02, 0.99470000E+00, 0.00000000E+00,
  0.40671500E+03, 0.115E+03, 0.110E+02, 0.99470000E+00, 0.00000000E+00,
  0.32041760E+03, 0.115E+03, 0.120E+02, 0.99470000E+00, 0.00000000E+00,
  0.29780760E+03, 0.115E+03, 0.130E+02, 0.99470000E+00, 0.00000000E+00,
  0.23698640E+03, 0.115E+03, 0.140E+02, 0.99470000E+00, 0.00000000E+00,
  0.18606840E+03, 0.115E+03, 0.150E+02, 0.99470000E+00, 0.00000000E+00,
  0.15492290E+03, 0.115E+03, 0.160E+02, 0.99470000E+00, 0.00000000E+00,
  0.12683120E+03, 0.115E+03, 0.170E+02, 0.99470000E+00, 0.00000000E+00,
  0.10386530E+03, 0.115E+03, 0.180E+02, 0.99470000E+00, 0.00000000E+00,
  0.66311840E+03, 0.115E+03, 0.190E+02, 0.99470000E+00, 0.00000000E+00,
  0.55742550E+03, 0.115E+03, 0.200E+02, 0.99470000E+00, 0.00000000E+00,
  0.46235110E+03, 0.115E+03, 0.210E+02, 0.99470000E+00, 0.00000000E+00,
  0.44795900E+03, 0.115E+03, 0.220E+02, 0.99470000E+00, 0.00000000E+00,
  0.41101210E+03, 0.115E+03, 0.230E+02, 0.99470000E+00, 0.00000000E+00,
  0.32359140E+03, 0.115E+03, 0.240E+02, 0.99470000E+00, 0.00000000E+00,
  0.35484320E+03, 0.115E+03, 0.250E+02, 0.99470000E+00, 0.00000000E+00,
  0.27840200E+03, 0.115E+03, 0.260E+02, 0.99470000E+00, 0.00000000E+00,
  0.29657890E+03, 0.115E+03, 0.270E+02, 0.99470000E+00, 0.00000000E+00,
  0.30491450E+03, 0.115E+03, 0.280E+02, 0.99470000E+00, 0.00000000E+00,
  0.23348980E+03, 0.115E+03, 0.290E+02, 0.99470000E+00, 0.00000000E+00,
  0.24143800E+03, 0.115E+03, 0.300E+02, 0.99470000E+00, 0.00000000E+00,
  0.28580720E+03, 0.115E+03, 0.310E+02, 0.99470000E+00, 0.00000000E+00,
  0.25397440E+03, 0.115E+03, 0.320E+02, 0.99470000E+00, 0.00000000E+00,
  0.21789200E+03, 0.115E+03, 0.330E+02, 0.99470000E+00, 0.00000000E+00,
  0.19608060E+03, 0.115E+03, 0.340E+02, 0.99470000E+00, 0.00000000E+00,
  0.17199100E+03, 0.115E+03, 0.350E+02, 0.99470000E+00, 0.00000000E+00,
  0.14979330E+03, 0.115E+03, 0.360E+02, 0.99470000E+00, 0.00000000E+00,
  0.74424750E+03, 0.115E+03, 0.370E+02, 0.99470000E+00, 0.00000000E+00,
  0.66356560E+03, 0.115E+03, 0.380E+02, 0.99470000E+00, 0.00000000E+00,
  0.58524670E+03, 0.115E+03, 0.390E+02, 0.99470000E+00, 0.00000000E+00,
  0.52808410E+03, 0.115E+03, 0.400E+02, 0.99470000E+00, 0.00000000E+00,
  0.48270360E+03, 0.115E+03, 0.410E+02, 0.99470000E+00, 0.00000000E+00,
  0.37394270E+03, 0.115E+03, 0.420E+02, 0.99470000E+00, 0.00000000E+00,
  0.41670800E+03, 0.115E+03, 0.430E+02, 0.99470000E+00, 0.00000000E+00,
  0.31859120E+03, 0.115E+03, 0.440E+02, 0.99470000E+00, 0.00000000E+00,
  0.34844490E+03, 0.115E+03, 0.450E+02, 0.99470000E+00, 0.00000000E+00,
  0.32352760E+03, 0.115E+03, 0.460E+02, 0.99470000E+00, 0.00000000E+00,
  0.26912200E+03, 0.115E+03, 0.470E+02, 0.99470000E+00, 0.00000000E+00,
  0.28548020E+03, 0.115E+03, 0.480E+02, 0.99470000E+00, 0.00000000E+00,
  0.35690690E+03, 0.115E+03, 0.490E+02, 0.99470000E+00, 0.00000000E+00,
  0.33217220E+03, 0.115E+03, 0.500E+02, 0.99470000E+00, 0.00000000E+00,
  0.29765980E+03, 0.115E+03, 0.510E+02, 0.99470000E+00, 0.00000000E+00,
  0.27698090E+03, 0.115E+03, 0.520E+02, 0.99470000E+00, 0.00000000E+00,
  0.25110810E+03, 0.115E+03, 0.530E+02, 0.99470000E+00, 0.00000000E+00,
  0.22622110E+03, 0.115E+03, 0.540E+02, 0.99470000E+00, 0.00000000E+00,
  0.90729930E+03, 0.115E+03, 0.550E+02, 0.99470000E+00, 0.00000000E+00,
  0.84401200E+03, 0.115E+03, 0.560E+02, 0.99470000E+00, 0.00000000E+00,
  0.74659930E+03, 0.115E+03, 0.570E+02, 0.99470000E+00, 0.00000000E+00,
  0.35115850E+03, 0.115E+03, 0.580E+02, 0.99470000E+00, 0.27991000E+01,
  0.74914380E+03, 0.115E+03, 0.590E+02, 0.99470000E+00, 0.00000000E+00,
  0.72014500E+03, 0.115E+03, 0.600E+02, 0.99470000E+00, 0.00000000E+00,
  0.70229590E+03, 0.115E+03, 0.610E+02, 0.99470000E+00, 0.00000000E+00,
  0.68586200E+03, 0.115E+03, 0.620E+02, 0.99470000E+00, 0.00000000E+00,
  0.67130090E+03, 0.115E+03, 0.630E+02, 0.99470000E+00, 0.00000000E+00,
  0.53154240E+03, 0.115E+03, 0.640E+02, 0.99470000E+00, 0.00000000E+00,
  0.59201350E+03, 0.115E+03, 0.650E+02, 0.99470000E+00, 0.00000000E+00,
  0.57174810E+03, 0.115E+03, 0.660E+02, 0.99470000E+00, 0.00000000E+00,
  0.60649400E+03, 0.115E+03, 0.670E+02, 0.99470000E+00, 0.00000000E+00,
  0.59374030E+03, 0.115E+03, 0.680E+02, 0.99470000E+00, 0.00000000E+00,
  0.58229560E+03, 0.115E+03, 0.690E+02, 0.99470000E+00, 0.00000000E+00,
  0.57532620E+03, 0.115E+03, 0.700E+02, 0.99470000E+00, 0.00000000E+00,
  0.48706190E+03, 0.115E+03, 0.710E+02, 0.99470000E+00, 0.00000000E+00,
  0.48246160E+03, 0.115E+03, 0.720E+02, 0.99470000E+00, 0.00000000E+00,
  0.44186160E+03, 0.115E+03, 0.730E+02, 0.99470000E+00, 0.00000000E+00,
  0.37386540E+03, 0.115E+03, 0.740E+02, 0.99470000E+00, 0.00000000E+00,
  0.38091200E+03, 0.115E+03, 0.750E+02, 0.99470000E+00, 0.00000000E+00,
  0.34613260E+03, 0.115E+03, 0.760E+02, 0.99470000E+00, 0.00000000E+00,
  0.31760850E+03, 0.115E+03, 0.770E+02, 0.99470000E+00, 0.00000000E+00,
  0.26410910E+03, 0.115E+03, 0.780E+02, 0.99470000E+00, 0.00000000E+00,
  0.24683080E+03, 0.115E+03, 0.790E+02, 0.99470000E+00, 0.00000000E+00,
  0.25431280E+03, 0.115E+03, 0.800E+02, 0.99470000E+00, 0.00000000E+00,
  0.36658420E+03, 0.115E+03, 0.810E+02, 0.99470000E+00, 0.00000000E+00,
  0.36026310E+03, 0.115E+03, 0.820E+02, 0.99470000E+00, 0.00000000E+00,
  0.33271860E+03, 0.115E+03, 0.830E+02, 0.99470000E+00, 0.00000000E+00,
  0.31818410E+03, 0.115E+03, 0.840E+02, 0.99470000E+00, 0.00000000E+00,
  0.29447100E+03, 0.115E+03, 0.850E+02, 0.99470000E+00, 0.00000000E+00,
  0.27046770E+03, 0.115E+03, 0.860E+02, 0.99470000E+00, 0.00000000E+00,
  0.86138240E+03, 0.115E+03, 0.870E+02, 0.99470000E+00, 0.00000000E+00,
  0.83751280E+03, 0.115E+03, 0.880E+02, 0.99470000E+00, 0.00000000E+00,
  0.74476320E+03, 0.115E+03, 0.890E+02, 0.99470000E+00, 0.00000000E+00,
  0.67356880E+03, 0.115E+03, 0.900E+02, 0.99470000E+00, 0.00000000E+00,
  0.66625820E+03, 0.115E+03, 0.910E+02, 0.99470000E+00, 0.00000000E+00,
  0.64514050E+03, 0.115E+03, 0.920E+02, 0.99470000E+00, 0.00000000E+00,
  0.66128050E+03, 0.115E+03, 0.930E+02, 0.99470000E+00, 0.00000000E+00,
  0.64087610E+03, 0.115E+03, 0.940E+02, 0.99470000E+00, 0.00000000E+00,
  0.37023600E+02, 0.115E+03, 0.101E+03, 0.99470000E+00, 0.00000000E+00,
  0.11774720E+03, 0.115E+03, 0.103E+03, 0.99470000E+00, 0.98650000E+00,
  0.15060680E+03, 0.115E+03, 0.104E+03, 0.99470000E+00, 0.98080000E+00,
  0.11638180E+03, 0.115E+03, 0.105E+03, 0.99470000E+00, 0.97060000E+00,
  0.88076900E+02, 0.115E+03, 0.106E+03, 0.99470000E+00, 0.98680000E+00,
  0.61428600E+02, 0.115E+03, 0.107E+03, 0.99470000E+00, 0.99440000E+00,
  0.44777000E+02, 0.115E+03, 0.108E+03, 0.99470000E+00, 0.99250000E+00,
  0.30768800E+02, 0.115E+03, 0.109E+03, 0.99470000E+00, 0.99820000E+00,
  0.17144690E+03, 0.115E+03, 0.111E+03, 0.99470000E+00, 0.96840000E+00,
  0.26503780E+03, 0.115E+03, 0.112E+03, 0.99470000E+00, 0.96280000E+00,
  0.27035800E+03, 0.115E+03, 0.113E+03, 0.99470000E+00, 0.96480000E+00,
  0.21928630E+03, 0.115E+03, 0.114E+03, 0.99470000E+00, 0.95070000E+00,
  0.18062380E+03, 0.115E+03, 0.115E+03, 0.99470000E+00, 0.99470000E+00,
  0.19866700E+02, 0.116E+03, 0.100E+01, 0.99480000E+00, 0.91180000E+00,
  0.13459800E+02, 0.116E+03, 0.200E+01, 0.99480000E+00, 0.00000000E+00,
  0.27130110E+03, 0.116E+03, 0.300E+01, 0.99480000E+00, 0.00000000E+00,
  0.16618070E+03, 0.116E+03, 0.400E+01, 0.99480000E+00, 0.00000000E+00,
  0.11581680E+03, 0.116E+03, 0.500E+01, 0.99480000E+00, 0.00000000E+00,
  0.80180400E+02, 0.116E+03, 0.600E+01, 0.99480000E+00, 0.00000000E+00,
  0.57025500E+02, 0.116E+03, 0.700E+01, 0.99480000E+00, 0.00000000E+00,
  0.43654800E+02, 0.116E+03, 0.800E+01, 0.99480000E+00, 0.00000000E+00,
  0.33355000E+02, 0.116E+03, 0.900E+01, 0.99480000E+00, 0.00000000E+00,
  0.25810700E+02, 0.116E+03, 0.100E+02, 0.99480000E+00, 0.00000000E+00,
  0.32559690E+03, 0.116E+03, 0.110E+02, 0.99480000E+00, 0.00000000E+00,
  0.26194370E+03, 0.116E+03, 0.120E+02, 0.99480000E+00, 0.00000000E+00,
  0.24585680E+03, 0.116E+03, 0.130E+02, 0.99480000E+00, 0.00000000E+00,
  0.19832660E+03, 0.116E+03, 0.140E+02, 0.99480000E+00, 0.00000000E+00,
  0.15769710E+03, 0.116E+03, 0.150E+02, 0.99480000E+00, 0.00000000E+00,
  0.13249220E+03, 0.116E+03, 0.160E+02, 0.99480000E+00, 0.00000000E+00,
  0.10944860E+03, 0.116E+03, 0.170E+02, 0.99480000E+00, 0.00000000E+00,
  0.90371600E+02, 0.116E+03, 0.180E+02, 0.99480000E+00, 0.00000000E+00,
  0.53051920E+03, 0.116E+03, 0.190E+02, 0.99480000E+00, 0.00000000E+00,
  0.45237450E+03, 0.116E+03, 0.200E+02, 0.99480000E+00, 0.00000000E+00,
  0.37661420E+03, 0.116E+03, 0.210E+02, 0.99480000E+00, 0.00000000E+00,
  0.36651510E+03, 0.116E+03, 0.220E+02, 0.99480000E+00, 0.00000000E+00,
  0.33712500E+03, 0.116E+03, 0.230E+02, 0.99480000E+00, 0.00000000E+00,
  0.26607620E+03, 0.116E+03, 0.240E+02, 0.99480000E+00, 0.00000000E+00,
  0.29212570E+03, 0.116E+03, 0.250E+02, 0.99480000E+00, 0.00000000E+00,
  0.22987760E+03, 0.116E+03, 0.260E+02, 0.99480000E+00, 0.00000000E+00,
  0.24559880E+03, 0.116E+03, 0.270E+02, 0.99480000E+00, 0.00000000E+00,
  0.25180970E+03, 0.116E+03, 0.280E+02, 0.99480000E+00, 0.00000000E+00,
  0.19338650E+03, 0.116E+03, 0.290E+02, 0.99480000E+00, 0.00000000E+00,
  0.20107040E+03, 0.116E+03, 0.300E+02, 0.99480000E+00, 0.00000000E+00,
  0.23725630E+03, 0.116E+03, 0.310E+02, 0.99480000E+00, 0.00000000E+00,
  0.21294370E+03, 0.116E+03, 0.320E+02, 0.99480000E+00, 0.00000000E+00,
  0.18454670E+03, 0.116E+03, 0.330E+02, 0.99480000E+00, 0.00000000E+00,
  0.16722640E+03, 0.116E+03, 0.340E+02, 0.99480000E+00, 0.00000000E+00,
  0.14776790E+03, 0.116E+03, 0.350E+02, 0.99480000E+00, 0.00000000E+00,
  0.12961230E+03, 0.116E+03, 0.360E+02, 0.99480000E+00, 0.00000000E+00,
  0.59687630E+03, 0.116E+03, 0.370E+02, 0.99480000E+00, 0.00000000E+00,
  0.53867240E+03, 0.116E+03, 0.380E+02, 0.99480000E+00, 0.00000000E+00,
  0.47852040E+03, 0.116E+03, 0.390E+02, 0.99480000E+00, 0.00000000E+00,
  0.43390360E+03, 0.116E+03, 0.400E+02, 0.99480000E+00, 0.00000000E+00,
  0.39804190E+03, 0.116E+03, 0.410E+02, 0.99480000E+00, 0.00000000E+00,
  0.31058610E+03, 0.116E+03, 0.420E+02, 0.99480000E+00, 0.00000000E+00,
  0.34514340E+03, 0.116E+03, 0.430E+02, 0.99480000E+00, 0.00000000E+00,
  0.26595280E+03, 0.116E+03, 0.440E+02, 0.99480000E+00, 0.00000000E+00,
  0.29041460E+03, 0.116E+03, 0.450E+02, 0.99480000E+00, 0.00000000E+00,
  0.27025240E+03, 0.116E+03, 0.460E+02, 0.99480000E+00, 0.00000000E+00,
  0.22511810E+03, 0.116E+03, 0.470E+02, 0.99480000E+00, 0.00000000E+00,
  0.23917840E+03, 0.116E+03, 0.480E+02, 0.99480000E+00, 0.00000000E+00,
  0.29682140E+03, 0.116E+03, 0.490E+02, 0.99480000E+00, 0.00000000E+00,
  0.27827870E+03, 0.116E+03, 0.500E+02, 0.99480000E+00, 0.00000000E+00,
  0.25143440E+03, 0.116E+03, 0.510E+02, 0.99480000E+00, 0.00000000E+00,
  0.23525190E+03, 0.116E+03, 0.520E+02, 0.99480000E+00, 0.00000000E+00,
  0.21460020E+03, 0.116E+03, 0.530E+02, 0.99480000E+00, 0.00000000E+00,
  0.19452370E+03, 0.116E+03, 0.540E+02, 0.99480000E+00, 0.00000000E+00,
  0.72846530E+03, 0.116E+03, 0.550E+02, 0.99480000E+00, 0.00000000E+00,
  0.68423530E+03, 0.116E+03, 0.560E+02, 0.99480000E+00, 0.00000000E+00,
  0.60944200E+03, 0.116E+03, 0.570E+02, 0.99480000E+00, 0.00000000E+00,
  0.29645810E+03, 0.116E+03, 0.580E+02, 0.99480000E+00, 0.27991000E+01,
  0.60891190E+03, 0.116E+03, 0.590E+02, 0.99480000E+00, 0.00000000E+00,
  0.58591340E+03, 0.116E+03, 0.600E+02, 0.99480000E+00, 0.00000000E+00,
  0.57153970E+03, 0.116E+03, 0.610E+02, 0.99480000E+00, 0.00000000E+00,
  0.55828160E+03, 0.116E+03, 0.620E+02, 0.99480000E+00, 0.00000000E+00,
  0.54653950E+03, 0.116E+03, 0.630E+02, 0.99480000E+00, 0.00000000E+00,
  0.43677850E+03, 0.116E+03, 0.640E+02, 0.99480000E+00, 0.00000000E+00,
  0.48158940E+03, 0.116E+03, 0.650E+02, 0.99480000E+00, 0.00000000E+00,
  0.46577580E+03, 0.116E+03, 0.660E+02, 0.99480000E+00, 0.00000000E+00,
  0.49452850E+03, 0.116E+03, 0.670E+02, 0.99480000E+00, 0.00000000E+00,
  0.48417910E+03, 0.116E+03, 0.680E+02, 0.99480000E+00, 0.00000000E+00,
  0.47494430E+03, 0.116E+03, 0.690E+02, 0.99480000E+00, 0.00000000E+00,
  0.46905670E+03, 0.116E+03, 0.700E+02, 0.99480000E+00, 0.00000000E+00,
  0.39959520E+03, 0.116E+03, 0.710E+02, 0.99480000E+00, 0.00000000E+00,
  0.39859150E+03, 0.116E+03, 0.720E+02, 0.99480000E+00, 0.00000000E+00,
  0.36694770E+03, 0.116E+03, 0.730E+02, 0.99480000E+00, 0.00000000E+00,
  0.31220810E+03, 0.116E+03, 0.740E+02, 0.99480000E+00, 0.00000000E+00,
  0.31855560E+03, 0.116E+03, 0.750E+02, 0.99480000E+00, 0.00000000E+00,
  0.29082630E+03, 0.116E+03, 0.760E+02, 0.99480000E+00, 0.00000000E+00,
  0.26791140E+03, 0.116E+03, 0.770E+02, 0.99480000E+00, 0.00000000E+00,
  0.22401000E+03, 0.116E+03, 0.780E+02, 0.99480000E+00, 0.00000000E+00,
  0.20979980E+03, 0.116E+03, 0.790E+02, 0.99480000E+00, 0.00000000E+00,
  0.21632530E+03, 0.116E+03, 0.800E+02, 0.99480000E+00, 0.00000000E+00,
  0.30615090E+03, 0.116E+03, 0.810E+02, 0.99480000E+00, 0.00000000E+00,
  0.30235050E+03, 0.116E+03, 0.820E+02, 0.99480000E+00, 0.00000000E+00,
  0.28117730E+03, 0.116E+03, 0.830E+02, 0.99480000E+00, 0.00000000E+00,
  0.27007790E+03, 0.116E+03, 0.840E+02, 0.99480000E+00, 0.00000000E+00,
  0.25135500E+03, 0.116E+03, 0.850E+02, 0.99480000E+00, 0.00000000E+00,
  0.23212580E+03, 0.116E+03, 0.860E+02, 0.99480000E+00, 0.00000000E+00,
  0.69553530E+03, 0.116E+03, 0.870E+02, 0.99480000E+00, 0.00000000E+00,
  0.68165580E+03, 0.116E+03, 0.880E+02, 0.99480000E+00, 0.00000000E+00,
  0.60993410E+03, 0.116E+03, 0.890E+02, 0.99480000E+00, 0.00000000E+00,
  0.55624920E+03, 0.116E+03, 0.900E+02, 0.99480000E+00, 0.00000000E+00,
  0.54849710E+03, 0.116E+03, 0.910E+02, 0.99480000E+00, 0.00000000E+00,
  0.53125540E+03, 0.116E+03, 0.920E+02, 0.99480000E+00, 0.00000000E+00,
  0.54187030E+03, 0.116E+03, 0.930E+02, 0.99480000E+00, 0.00000000E+00,
  0.52557770E+03, 0.116E+03, 0.940E+02, 0.99480000E+00, 0.00000000E+00,
  0.31412700E+02, 0.116E+03, 0.101E+03, 0.99480000E+00, 0.00000000E+00,
  0.97084900E+02, 0.116E+03, 0.103E+03, 0.99480000E+00, 0.98650000E+00,
  0.12475120E+03, 0.116E+03, 0.104E+03, 0.99480000E+00, 0.98080000E+00,
  0.98113900E+02, 0.116E+03, 0.105E+03, 0.99480000E+00, 0.97060000E+00,
  0.75203900E+02, 0.116E+03, 0.106E+03, 0.99480000E+00, 0.98680000E+00,
  0.53208600E+02, 0.116E+03, 0.107E+03, 0.99480000E+00, 0.99440000E+00,
  0.39268300E+02, 0.116E+03, 0.108E+03, 0.99480000E+00, 0.99250000E+00,
  0.27411700E+02, 0.116E+03, 0.109E+03, 0.99480000E+00, 0.99820000E+00,
  0.14105990E+03, 0.116E+03, 0.111E+03, 0.99480000E+00, 0.96840000E+00,
  0.21766290E+03, 0.116E+03, 0.112E+03, 0.99480000E+00, 0.96280000E+00,
  0.22379420E+03, 0.116E+03, 0.113E+03, 0.99480000E+00, 0.96480000E+00,
  0.18394830E+03, 0.116E+03, 0.114E+03, 0.99480000E+00, 0.95070000E+00,
  0.15318230E+03, 0.116E+03, 0.115E+03, 0.99480000E+00, 0.99470000E+00,
  0.13099650E+03, 0.116E+03, 0.116E+03, 0.99480000E+00, 0.99480000E+00,
  0.16527300E+02, 0.117E+03, 0.100E+01, 0.99720000E+00, 0.91180000E+00,
  0.11509200E+02, 0.117E+03, 0.200E+01, 0.99720000E+00, 0.00000000E+00,
  0.20877430E+03, 0.117E+03, 0.300E+01, 0.99720000E+00, 0.00000000E+00,
  0.13164980E+03, 0.117E+03, 0.400E+01, 0.99720000E+00, 0.00000000E+00,
  0.93774300E+02, 0.117E+03, 0.500E+01, 0.99720000E+00, 0.00000000E+00,
  0.66135400E+02, 0.117E+03, 0.600E+01, 0.99720000E+00, 0.00000000E+00,
  0.47754000E+02, 0.117E+03, 0.700E+01, 0.99720000E+00, 0.00000000E+00,
  0.36978300E+02, 0.117E+03, 0.800E+01, 0.99720000E+00, 0.00000000E+00,
  0.28546800E+02, 0.117E+03, 0.900E+01, 0.99720000E+00, 0.00000000E+00,
  0.22283200E+02, 0.117E+03, 0.100E+02, 0.99720000E+00, 0.00000000E+00,
  0.25123260E+03, 0.117E+03, 0.110E+02, 0.99720000E+00, 0.00000000E+00,
  0.20645210E+03, 0.117E+03, 0.120E+02, 0.99720000E+00, 0.00000000E+00,
  0.19576470E+03, 0.117E+03, 0.130E+02, 0.99720000E+00, 0.00000000E+00,
  0.16018790E+03, 0.117E+03, 0.140E+02, 0.99720000E+00, 0.00000000E+00,
  0.12909560E+03, 0.117E+03, 0.150E+02, 0.99720000E+00, 0.00000000E+00,
  0.10952700E+03, 0.117E+03, 0.160E+02, 0.99720000E+00, 0.00000000E+00,
  0.91366700E+02, 0.117E+03, 0.170E+02, 0.99720000E+00, 0.00000000E+00,
  0.76125600E+02, 0.117E+03, 0.180E+02, 0.99720000E+00, 0.00000000E+00,
  0.40951050E+03, 0.117E+03, 0.190E+02, 0.99720000E+00, 0.00000000E+00,
  0.35409350E+03, 0.117E+03, 0.200E+02, 0.99720000E+00, 0.00000000E+00,
  0.29590280E+03, 0.117E+03, 0.210E+02, 0.99720000E+00, 0.00000000E+00,
  0.28935120E+03, 0.117E+03, 0.220E+02, 0.99720000E+00, 0.00000000E+00,
  0.26685570E+03, 0.117E+03, 0.230E+02, 0.99720000E+00, 0.00000000E+00,
  0.21129280E+03, 0.117E+03, 0.240E+02, 0.99720000E+00, 0.00000000E+00,
  0.23214470E+03, 0.117E+03, 0.250E+02, 0.99720000E+00, 0.00000000E+00,
  0.18336610E+03, 0.117E+03, 0.260E+02, 0.99720000E+00, 0.00000000E+00,
  0.19637550E+03, 0.117E+03, 0.270E+02, 0.99720000E+00, 0.00000000E+00,
  0.20075710E+03, 0.117E+03, 0.280E+02, 0.99720000E+00, 0.00000000E+00,
  0.15477560E+03, 0.117E+03, 0.290E+02, 0.99720000E+00, 0.00000000E+00,
  0.16173370E+03, 0.117E+03, 0.300E+02, 0.99720000E+00, 0.00000000E+00,
  0.19011390E+03, 0.117E+03, 0.310E+02, 0.99720000E+00, 0.00000000E+00,
  0.17239330E+03, 0.117E+03, 0.320E+02, 0.99720000E+00, 0.00000000E+00,
  0.15099990E+03, 0.117E+03, 0.330E+02, 0.99720000E+00, 0.00000000E+00,
  0.13784430E+03, 0.117E+03, 0.340E+02, 0.99720000E+00, 0.00000000E+00,
  0.12277630E+03, 0.117E+03, 0.350E+02, 0.99720000E+00, 0.00000000E+00,
  0.10852260E+03, 0.117E+03, 0.360E+02, 0.99720000E+00, 0.00000000E+00,
  0.46202520E+03, 0.117E+03, 0.370E+02, 0.99720000E+00, 0.00000000E+00,
  0.42188670E+03, 0.117E+03, 0.380E+02, 0.99720000E+00, 0.00000000E+00,
  0.37756420E+03, 0.117E+03, 0.390E+02, 0.99720000E+00, 0.00000000E+00,
  0.34413180E+03, 0.117E+03, 0.400E+02, 0.99720000E+00, 0.00000000E+00,
  0.31691100E+03, 0.117E+03, 0.410E+02, 0.99720000E+00, 0.00000000E+00,
  0.24926710E+03, 0.117E+03, 0.420E+02, 0.99720000E+00, 0.00000000E+00,
  0.27614550E+03, 0.117E+03, 0.430E+02, 0.99720000E+00, 0.00000000E+00,
  0.21463800E+03, 0.117E+03, 0.440E+02, 0.99720000E+00, 0.00000000E+00,
  0.23390310E+03, 0.117E+03, 0.450E+02, 0.99720000E+00, 0.00000000E+00,
  0.21819030E+03, 0.117E+03, 0.460E+02, 0.99720000E+00, 0.00000000E+00,
  0.18215470E+03, 0.117E+03, 0.470E+02, 0.99720000E+00, 0.00000000E+00,
  0.19372730E+03, 0.117E+03, 0.480E+02, 0.99720000E+00, 0.00000000E+00,
  0.23849880E+03, 0.117E+03, 0.490E+02, 0.99720000E+00, 0.00000000E+00,
  0.22523810E+03, 0.117E+03, 0.500E+02, 0.99720000E+00, 0.00000000E+00,
  0.20525120E+03, 0.117E+03, 0.510E+02, 0.99720000E+00, 0.00000000E+00,
  0.19314490E+03, 0.117E+03, 0.520E+02, 0.99720000E+00, 0.00000000E+00,
  0.17734580E+03, 0.117E+03, 0.530E+02, 0.99720000E+00, 0.00000000E+00,
  0.16181190E+03, 0.117E+03, 0.540E+02, 0.99720000E+00, 0.00000000E+00,
  0.56460060E+03, 0.117E+03, 0.550E+02, 0.99720000E+00, 0.00000000E+00,
  0.53526780E+03, 0.117E+03, 0.560E+02, 0.99720000E+00, 0.00000000E+00,
  0.48012440E+03, 0.117E+03, 0.570E+02, 0.99720000E+00, 0.00000000E+00,
  0.24192230E+03, 0.117E+03, 0.580E+02, 0.99720000E+00, 0.27991000E+01,
  0.47771970E+03, 0.117E+03, 0.590E+02, 0.99720000E+00, 0.00000000E+00,
  0.46012500E+03, 0.117E+03, 0.600E+02, 0.99720000E+00, 0.00000000E+00,
  0.44895170E+03, 0.117E+03, 0.610E+02, 0.99720000E+00, 0.00000000E+00,
  0.43862430E+03, 0.117E+03, 0.620E+02, 0.99720000E+00, 0.00000000E+00,
  0.42948100E+03, 0.117E+03, 0.630E+02, 0.99720000E+00, 0.00000000E+00,
  0.34664610E+03, 0.117E+03, 0.640E+02, 0.99720000E+00, 0.00000000E+00,
  0.37839840E+03, 0.117E+03, 0.650E+02, 0.99720000E+00, 0.00000000E+00,
  0.36651660E+03, 0.117E+03, 0.660E+02, 0.99720000E+00, 0.00000000E+00,
  0.38919850E+03, 0.117E+03, 0.670E+02, 0.99720000E+00, 0.00000000E+00,
  0.38108470E+03, 0.117E+03, 0.680E+02, 0.99720000E+00, 0.00000000E+00,
  0.37388780E+03, 0.117E+03, 0.690E+02, 0.99720000E+00, 0.00000000E+00,
  0.36907690E+03, 0.117E+03, 0.700E+02, 0.99720000E+00, 0.00000000E+00,
  0.31653270E+03, 0.117E+03, 0.710E+02, 0.99720000E+00, 0.00000000E+00,
  0.31792390E+03, 0.117E+03, 0.720E+02, 0.99720000E+00, 0.00000000E+00,
  0.29429820E+03, 0.117E+03, 0.730E+02, 0.99720000E+00, 0.00000000E+00,
  0.25196160E+03, 0.117E+03, 0.740E+02, 0.99720000E+00, 0.00000000E+00,
  0.25744470E+03, 0.117E+03, 0.750E+02, 0.99720000E+00, 0.00000000E+00,
  0.23620650E+03, 0.117E+03, 0.760E+02, 0.99720000E+00, 0.00000000E+00,
  0.21851340E+03, 0.117E+03, 0.770E+02, 0.99720000E+00, 0.00000000E+00,
  0.18384350E+03, 0.117E+03, 0.780E+02, 0.99720000E+00, 0.00000000E+00,
  0.17259550E+03, 0.117E+03, 0.790E+02, 0.99720000E+00, 0.00000000E+00,
  0.17806050E+03, 0.117E+03, 0.800E+02, 0.99720000E+00, 0.00000000E+00,
  0.24721900E+03, 0.117E+03, 0.810E+02, 0.99720000E+00, 0.00000000E+00,
  0.24529500E+03, 0.117E+03, 0.820E+02, 0.99720000E+00, 0.00000000E+00,
  0.22972670E+03, 0.117E+03, 0.830E+02, 0.99720000E+00, 0.00000000E+00,
  0.22165670E+03, 0.117E+03, 0.840E+02, 0.99720000E+00, 0.00000000E+00,
  0.20750080E+03, 0.117E+03, 0.850E+02, 0.99720000E+00, 0.00000000E+00,
  0.19273160E+03, 0.117E+03, 0.860E+02, 0.99720000E+00, 0.00000000E+00,
  0.54229530E+03, 0.117E+03, 0.870E+02, 0.99720000E+00, 0.00000000E+00,
  0.53547060E+03, 0.117E+03, 0.880E+02, 0.99720000E+00, 0.00000000E+00,
  0.48217720E+03, 0.117E+03, 0.890E+02, 0.99720000E+00, 0.00000000E+00,
  0.44362620E+03, 0.117E+03, 0.900E+02, 0.99720000E+00, 0.00000000E+00,
  0.43615260E+03, 0.117E+03, 0.910E+02, 0.99720000E+00, 0.00000000E+00,
  0.42258040E+03, 0.117E+03, 0.920E+02, 0.99720000E+00, 0.00000000E+00,
  0.42886190E+03, 0.117E+03, 0.930E+02, 0.99720000E+00, 0.00000000E+00,
  0.41631150E+03, 0.117E+03, 0.940E+02, 0.99720000E+00, 0.00000000E+00,
  0.25741400E+02, 0.117E+03, 0.101E+03, 0.99720000E+00, 0.00000000E+00,
  0.77202300E+02, 0.117E+03, 0.103E+03, 0.99720000E+00, 0.98650000E+00,
  0.99699500E+02, 0.117E+03, 0.104E+03, 0.99720000E+00, 0.98080000E+00,
  0.79883300E+02, 0.117E+03, 0.105E+03, 0.99720000E+00, 0.97060000E+00,
  0.62086400E+02, 0.117E+03, 0.106E+03, 0.99720000E+00, 0.98680000E+00,
  0.44621700E+02, 0.117E+03, 0.107E+03, 0.99720000E+00, 0.99440000E+00,
  0.33380100E+02, 0.117E+03, 0.108E+03, 0.99720000E+00, 0.99250000E+00,
  0.23705900E+02, 0.117E+03, 0.109E+03, 0.99720000E+00, 0.99820000E+00,
  0.11198290E+03, 0.117E+03, 0.111E+03, 0.99720000E+00, 0.96840000E+00,
  0.17241480E+03, 0.117E+03, 0.112E+03, 0.99720000E+00, 0.96280000E+00,
  0.17871270E+03, 0.117E+03, 0.113E+03, 0.99720000E+00, 0.96480000E+00,
  0.14895590E+03, 0.117E+03, 0.114E+03, 0.99720000E+00, 0.95070000E+00,
  0.12549300E+03, 0.117E+03, 0.115E+03, 0.99720000E+00, 0.99470000E+00,
  0.10828930E+03, 0.117E+03, 0.116E+03, 0.99720000E+00, 0.99480000E+00,
  0.90398500E+02, 0.117E+03, 0.117E+03, 0.99720000E+00, 0.99720000E+00,
  0.29300000E+02, 0.119E+03, 0.100E+01, 0.97670000E+00, 0.91180000E+00,
  0.18665500E+02, 0.119E+03, 0.200E+01, 0.97670000E+00, 0.00000000E+00,
  0.56029540E+03, 0.119E+03, 0.300E+01, 0.97670000E+00, 0.00000000E+00,
  0.29222240E+03, 0.119E+03, 0.400E+01, 0.97670000E+00, 0.00000000E+00,
  0.18695660E+03, 0.119E+03, 0.500E+01, 0.97670000E+00, 0.00000000E+00,
  0.12192920E+03, 0.119E+03, 0.600E+01, 0.97670000E+00, 0.00000000E+00,
  0.83215300E+02, 0.119E+03, 0.700E+01, 0.97670000E+00, 0.00000000E+00,
  0.61994800E+02, 0.119E+03, 0.800E+01, 0.97670000E+00, 0.00000000E+00,
  0.46352000E+02, 0.119E+03, 0.900E+01, 0.97670000E+00, 0.00000000E+00,
  0.35296900E+02, 0.119E+03, 0.100E+02, 0.97670000E+00, 0.00000000E+00,
  0.66603570E+03, 0.119E+03, 0.110E+02, 0.97670000E+00, 0.00000000E+00,
  0.47376610E+03, 0.119E+03, 0.120E+02, 0.97670000E+00, 0.00000000E+00,
  0.42489260E+03, 0.119E+03, 0.130E+02, 0.97670000E+00, 0.00000000E+00,
  0.32282330E+03, 0.119E+03, 0.140E+02, 0.97670000E+00, 0.00000000E+00,
  0.24457290E+03, 0.119E+03, 0.150E+02, 0.97670000E+00, 0.00000000E+00,
  0.19946720E+03, 0.119E+03, 0.160E+02, 0.97670000E+00, 0.00000000E+00,
  0.16033040E+03, 0.119E+03, 0.170E+02, 0.97670000E+00, 0.00000000E+00,
  0.12942830E+03, 0.119E+03, 0.180E+02, 0.97670000E+00, 0.00000000E+00,
  0.11122277E+04, 0.119E+03, 0.190E+02, 0.97670000E+00, 0.00000000E+00,
  0.86017710E+03, 0.119E+03, 0.200E+02, 0.97670000E+00, 0.00000000E+00,
  0.70072810E+03, 0.119E+03, 0.210E+02, 0.97670000E+00, 0.00000000E+00,
  0.66875460E+03, 0.119E+03, 0.220E+02, 0.97670000E+00, 0.00000000E+00,
  0.60799510E+03, 0.119E+03, 0.230E+02, 0.97670000E+00, 0.00000000E+00,
  0.47897440E+03, 0.119E+03, 0.240E+02, 0.97670000E+00, 0.00000000E+00,
  0.51805830E+03, 0.119E+03, 0.250E+02, 0.97670000E+00, 0.00000000E+00,
  0.40608760E+03, 0.119E+03, 0.260E+02, 0.97670000E+00, 0.00000000E+00,
  0.42338090E+03, 0.119E+03, 0.270E+02, 0.97670000E+00, 0.00000000E+00,
  0.43928450E+03, 0.119E+03, 0.280E+02, 0.97670000E+00, 0.00000000E+00,
  0.33711170E+03, 0.119E+03, 0.290E+02, 0.97670000E+00, 0.00000000E+00,
  0.33789860E+03, 0.119E+03, 0.300E+02, 0.97670000E+00, 0.00000000E+00,
  0.40307450E+03, 0.119E+03, 0.310E+02, 0.97670000E+00, 0.00000000E+00,
  0.34544340E+03, 0.119E+03, 0.320E+02, 0.97670000E+00, 0.00000000E+00,
  0.28755350E+03, 0.119E+03, 0.330E+02, 0.97670000E+00, 0.00000000E+00,
  0.25436700E+03, 0.119E+03, 0.340E+02, 0.97670000E+00, 0.00000000E+00,
  0.21946470E+03, 0.119E+03, 0.350E+02, 0.97670000E+00, 0.00000000E+00,
  0.18848190E+03, 0.119E+03, 0.360E+02, 0.97670000E+00, 0.00000000E+00,
  0.12408631E+04, 0.119E+03, 0.370E+02, 0.97670000E+00, 0.00000000E+00,
  0.10279671E+04, 0.119E+03, 0.380E+02, 0.97670000E+00, 0.00000000E+00,
  0.87903460E+03, 0.119E+03, 0.390E+02, 0.97670000E+00, 0.00000000E+00,
  0.77852380E+03, 0.119E+03, 0.400E+02, 0.97670000E+00, 0.00000000E+00,
  0.70330600E+03, 0.119E+03, 0.410E+02, 0.97670000E+00, 0.00000000E+00,
  0.53463030E+03, 0.119E+03, 0.420E+02, 0.97670000E+00, 0.00000000E+00,
  0.59993020E+03, 0.119E+03, 0.430E+02, 0.97670000E+00, 0.00000000E+00,
  0.44930300E+03, 0.119E+03, 0.440E+02, 0.97670000E+00, 0.00000000E+00,
  0.49058070E+03, 0.119E+03, 0.450E+02, 0.97670000E+00, 0.00000000E+00,
  0.45224640E+03, 0.119E+03, 0.460E+02, 0.97670000E+00, 0.00000000E+00,
  0.37908360E+03, 0.119E+03, 0.470E+02, 0.97670000E+00, 0.00000000E+00,
  0.39551350E+03, 0.119E+03, 0.480E+02, 0.97670000E+00, 0.00000000E+00,
  0.50568380E+03, 0.119E+03, 0.490E+02, 0.97670000E+00, 0.00000000E+00,
  0.45646130E+03, 0.119E+03, 0.500E+02, 0.97670000E+00, 0.00000000E+00,
  0.39784160E+03, 0.119E+03, 0.510E+02, 0.97670000E+00, 0.00000000E+00,
  0.36440900E+03, 0.119E+03, 0.520E+02, 0.97670000E+00, 0.00000000E+00,
  0.32510680E+03, 0.119E+03, 0.530E+02, 0.97670000E+00, 0.00000000E+00,
  0.28872750E+03, 0.119E+03, 0.540E+02, 0.97670000E+00, 0.00000000E+00,
  0.15118898E+04, 0.119E+03, 0.550E+02, 0.97670000E+00, 0.00000000E+00,
  0.13222619E+04, 0.119E+03, 0.560E+02, 0.97670000E+00, 0.00000000E+00,
  0.11337749E+04, 0.119E+03, 0.570E+02, 0.97670000E+00, 0.00000000E+00,
  0.47224550E+03, 0.119E+03, 0.580E+02, 0.97670000E+00, 0.27991000E+01,
  0.11622835E+04, 0.119E+03, 0.590E+02, 0.97670000E+00, 0.00000000E+00,
  0.11112638E+04, 0.119E+03, 0.600E+02, 0.97670000E+00, 0.00000000E+00,
  0.10820865E+04, 0.119E+03, 0.610E+02, 0.97670000E+00, 0.00000000E+00,
  0.10553891E+04, 0.119E+03, 0.620E+02, 0.97670000E+00, 0.00000000E+00,
  0.10316716E+04, 0.119E+03, 0.630E+02, 0.97670000E+00, 0.00000000E+00,
  0.79078540E+03, 0.119E+03, 0.640E+02, 0.97670000E+00, 0.00000000E+00,
  0.92736720E+03, 0.119E+03, 0.650E+02, 0.97670000E+00, 0.00000000E+00,
  0.89050560E+03, 0.119E+03, 0.660E+02, 0.97670000E+00, 0.00000000E+00,
  0.92461970E+03, 0.119E+03, 0.670E+02, 0.97670000E+00, 0.00000000E+00,
  0.90432570E+03, 0.119E+03, 0.680E+02, 0.97670000E+00, 0.00000000E+00,
  0.88575380E+03, 0.119E+03, 0.690E+02, 0.97670000E+00, 0.00000000E+00,
  0.87628990E+03, 0.119E+03, 0.700E+02, 0.97670000E+00, 0.00000000E+00,
  0.72564410E+03, 0.119E+03, 0.710E+02, 0.97670000E+00, 0.00000000E+00,
  0.69618310E+03, 0.119E+03, 0.720E+02, 0.97670000E+00, 0.00000000E+00,
  0.62634420E+03, 0.119E+03, 0.730E+02, 0.97670000E+00, 0.00000000E+00,
  0.52368920E+03, 0.119E+03, 0.740E+02, 0.97670000E+00, 0.00000000E+00,
  0.52962490E+03, 0.119E+03, 0.750E+02, 0.97670000E+00, 0.00000000E+00,
  0.47425390E+03, 0.119E+03, 0.760E+02, 0.97670000E+00, 0.00000000E+00,
  0.43019640E+03, 0.119E+03, 0.770E+02, 0.97670000E+00, 0.00000000E+00,
  0.35414110E+03, 0.119E+03, 0.780E+02, 0.97670000E+00, 0.00000000E+00,
  0.32964710E+03, 0.119E+03, 0.790E+02, 0.97670000E+00, 0.00000000E+00,
  0.33733350E+03, 0.119E+03, 0.800E+02, 0.97670000E+00, 0.00000000E+00,
  0.51695330E+03, 0.119E+03, 0.810E+02, 0.97670000E+00, 0.00000000E+00,
  0.49569810E+03, 0.119E+03, 0.820E+02, 0.97670000E+00, 0.00000000E+00,
  0.44630330E+03, 0.119E+03, 0.830E+02, 0.97670000E+00, 0.00000000E+00,
  0.42086840E+03, 0.119E+03, 0.840E+02, 0.97670000E+00, 0.00000000E+00,
  0.38335330E+03, 0.119E+03, 0.850E+02, 0.97670000E+00, 0.00000000E+00,
  0.34734370E+03, 0.119E+03, 0.860E+02, 0.97670000E+00, 0.00000000E+00,
  0.14001686E+04, 0.119E+03, 0.870E+02, 0.97670000E+00, 0.00000000E+00,
  0.12915073E+04, 0.119E+03, 0.880E+02, 0.97670000E+00, 0.00000000E+00,
  0.11159288E+04, 0.119E+03, 0.890E+02, 0.97670000E+00, 0.00000000E+00,
  0.97819280E+03, 0.119E+03, 0.900E+02, 0.97670000E+00, 0.00000000E+00,
  0.98391310E+03, 0.119E+03, 0.910E+02, 0.97670000E+00, 0.00000000E+00,
  0.95206270E+03, 0.119E+03, 0.920E+02, 0.97670000E+00, 0.00000000E+00,
  0.99535270E+03, 0.119E+03, 0.930E+02, 0.97670000E+00, 0.00000000E+00,
  0.96105430E+03, 0.119E+03, 0.940E+02, 0.97670000E+00, 0.00000000E+00,
  0.48449900E+02, 0.119E+03, 0.101E+03, 0.97670000E+00, 0.00000000E+00,
  0.16874120E+03, 0.119E+03, 0.103E+03, 0.97670000E+00, 0.98650000E+00,
  0.21344440E+03, 0.119E+03, 0.104E+03, 0.97670000E+00, 0.98080000E+00,
  0.15577810E+03, 0.119E+03, 0.105E+03, 0.97670000E+00, 0.97060000E+00,
  0.11457230E+03, 0.119E+03, 0.106E+03, 0.97670000E+00, 0.98680000E+00,
  0.77631700E+02, 0.119E+03, 0.107E+03, 0.97670000E+00, 0.99440000E+00,
  0.55403200E+02, 0.119E+03, 0.108E+03, 0.97670000E+00, 0.99250000E+00,
  0.37198200E+02, 0.119E+03, 0.109E+03, 0.97670000E+00, 0.99820000E+00,
  0.24922000E+03, 0.119E+03, 0.111E+03, 0.97670000E+00, 0.96840000E+00,
  0.38733490E+03, 0.119E+03, 0.112E+03, 0.97670000E+00, 0.96280000E+00,
  0.38264220E+03, 0.119E+03, 0.113E+03, 0.97670000E+00, 0.96480000E+00,
  0.29694090E+03, 0.119E+03, 0.114E+03, 0.97670000E+00, 0.95070000E+00,
  0.23721910E+03, 0.119E+03, 0.115E+03, 0.97670000E+00, 0.99470000E+00,
  0.19738060E+03, 0.119E+03, 0.116E+03, 0.97670000E+00, 0.99480000E+00,
  0.15873300E+03, 0.119E+03, 0.117E+03, 0.97670000E+00, 0.99720000E+00,
  0.33802070E+03, 0.119E+03, 0.119E+03, 0.97670000E+00, 0.97670000E+00,
  0.52987100E+02, 0.120E+03, 0.100E+01, 0.98310000E+00, 0.91180000E+00,
  0.31879600E+02, 0.120E+03, 0.200E+01, 0.98310000E+00, 0.00000000E+00,
  0.13100314E+04, 0.120E+03, 0.300E+01, 0.98310000E+00, 0.00000000E+00,
  0.60256610E+03, 0.120E+03, 0.400E+01, 0.98310000E+00, 0.00000000E+00,
  0.36268620E+03, 0.120E+03, 0.500E+01, 0.98310000E+00, 0.00000000E+00,
  0.22596290E+03, 0.120E+03, 0.600E+01, 0.98310000E+00, 0.00000000E+00,
  0.14897930E+03, 0.120E+03, 0.700E+01, 0.98310000E+00, 0.00000000E+00,
  0.10827180E+03, 0.120E+03, 0.800E+01, 0.98310000E+00, 0.00000000E+00,
  0.79221800E+02, 0.120E+03, 0.900E+01, 0.98310000E+00, 0.00000000E+00,
  0.59277900E+02, 0.120E+03, 0.100E+02, 0.98310000E+00, 0.00000000E+00,
  0.15457064E+04, 0.120E+03, 0.110E+02, 0.98310000E+00, 0.00000000E+00,
  0.99724860E+03, 0.120E+03, 0.120E+02, 0.98310000E+00, 0.00000000E+00,
  0.86695170E+03, 0.120E+03, 0.130E+02, 0.98310000E+00, 0.00000000E+00,
  0.63004560E+03, 0.120E+03, 0.140E+02, 0.98310000E+00, 0.00000000E+00,
  0.46026350E+03, 0.120E+03, 0.150E+02, 0.98310000E+00, 0.00000000E+00,
  0.36677110E+03, 0.120E+03, 0.160E+02, 0.98310000E+00, 0.00000000E+00,
  0.28821820E+03, 0.120E+03, 0.170E+02, 0.98310000E+00, 0.00000000E+00,
  0.22808920E+03, 0.120E+03, 0.180E+02, 0.98310000E+00, 0.00000000E+00,
  0.26610830E+04, 0.120E+03, 0.190E+02, 0.98310000E+00, 0.00000000E+00,
  0.18864221E+04, 0.120E+03, 0.200E+02, 0.98310000E+00, 0.00000000E+00,
  0.15101427E+04, 0.120E+03, 0.210E+02, 0.98310000E+00, 0.00000000E+00,
  0.14223244E+04, 0.120E+03, 0.220E+02, 0.98310000E+00, 0.00000000E+00,
  0.12821610E+04, 0.120E+03, 0.230E+02, 0.98310000E+00, 0.00000000E+00,
  0.10115955E+04, 0.120E+03, 0.240E+02, 0.98310000E+00, 0.00000000E+00,
  0.10791532E+04, 0.120E+03, 0.250E+02, 0.98310000E+00, 0.00000000E+00,
  0.84546860E+03, 0.120E+03, 0.260E+02, 0.98310000E+00, 0.00000000E+00,
  0.86250360E+03, 0.120E+03, 0.270E+02, 0.98310000E+00, 0.00000000E+00,
  0.90260140E+03, 0.120E+03, 0.280E+02, 0.98310000E+00, 0.00000000E+00,
  0.69450580E+03, 0.120E+03, 0.290E+02, 0.98310000E+00, 0.00000000E+00,
  0.67502990E+03, 0.120E+03, 0.300E+02, 0.98310000E+00, 0.00000000E+00,
  0.81349430E+03, 0.120E+03, 0.310E+02, 0.98310000E+00, 0.00000000E+00,
  0.67269170E+03, 0.120E+03, 0.320E+02, 0.98310000E+00, 0.00000000E+00,
  0.54301230E+03, 0.120E+03, 0.330E+02, 0.98310000E+00, 0.00000000E+00,
  0.47148220E+03, 0.120E+03, 0.340E+02, 0.98310000E+00, 0.00000000E+00,
  0.39902260E+03, 0.120E+03, 0.350E+02, 0.98310000E+00, 0.00000000E+00,
  0.33664830E+03, 0.120E+03, 0.360E+02, 0.98310000E+00, 0.00000000E+00,
  0.29580410E+04, 0.120E+03, 0.370E+02, 0.98310000E+00, 0.00000000E+00,
  0.22654155E+04, 0.120E+03, 0.380E+02, 0.98310000E+00, 0.00000000E+00,
  0.18821338E+04, 0.120E+03, 0.390E+02, 0.98310000E+00, 0.00000000E+00,
  0.16379667E+04, 0.120E+03, 0.400E+02, 0.98310000E+00, 0.00000000E+00,
  0.14638890E+04, 0.120E+03, 0.410E+02, 0.98310000E+00, 0.00000000E+00,
  0.10926733E+04, 0.120E+03, 0.420E+02, 0.98310000E+00, 0.00000000E+00,
  0.12349316E+04, 0.120E+03, 0.430E+02, 0.98310000E+00, 0.00000000E+00,
  0.90575150E+03, 0.120E+03, 0.440E+02, 0.98310000E+00, 0.00000000E+00,
  0.98637270E+03, 0.120E+03, 0.450E+02, 0.98310000E+00, 0.00000000E+00,
  0.90244050E+03, 0.120E+03, 0.460E+02, 0.98310000E+00, 0.00000000E+00,
  0.76261740E+03, 0.120E+03, 0.470E+02, 0.98310000E+00, 0.00000000E+00,
  0.78166000E+03, 0.120E+03, 0.480E+02, 0.98310000E+00, 0.00000000E+00,
  0.10241614E+04, 0.120E+03, 0.490E+02, 0.98310000E+00, 0.00000000E+00,
  0.89641550E+03, 0.120E+03, 0.500E+02, 0.98310000E+00, 0.00000000E+00,
  0.75979880E+03, 0.120E+03, 0.510E+02, 0.98310000E+00, 0.00000000E+00,
  0.68470730E+03, 0.120E+03, 0.520E+02, 0.98310000E+00, 0.00000000E+00,
  0.60026980E+03, 0.120E+03, 0.530E+02, 0.98310000E+00, 0.00000000E+00,
  0.52435470E+03, 0.120E+03, 0.540E+02, 0.98310000E+00, 0.00000000E+00,
  0.36192660E+04, 0.120E+03, 0.550E+02, 0.98310000E+00, 0.00000000E+00,
  0.29513362E+04, 0.120E+03, 0.560E+02, 0.98310000E+00, 0.00000000E+00,
  0.24567601E+04, 0.120E+03, 0.570E+02, 0.98310000E+00, 0.00000000E+00,
  0.90740120E+03, 0.120E+03, 0.580E+02, 0.98310000E+00, 0.27991000E+01,
  0.25715319E+04, 0.120E+03, 0.590E+02, 0.98310000E+00, 0.00000000E+00,
  0.24420495E+04, 0.120E+03, 0.600E+02, 0.98310000E+00, 0.00000000E+00,
  0.23740445E+04, 0.120E+03, 0.610E+02, 0.98310000E+00, 0.00000000E+00,
  0.23122147E+04, 0.120E+03, 0.620E+02, 0.98310000E+00, 0.00000000E+00,
  0.22571993E+04, 0.120E+03, 0.630E+02, 0.98310000E+00, 0.00000000E+00,
  0.16806338E+04, 0.120E+03, 0.640E+02, 0.98310000E+00, 0.00000000E+00,
  0.20816173E+04, 0.120E+03, 0.650E+02, 0.98310000E+00, 0.00000000E+00,
  0.19928728E+04, 0.120E+03, 0.660E+02, 0.98310000E+00, 0.00000000E+00,
  0.20062958E+04, 0.120E+03, 0.670E+02, 0.98310000E+00, 0.00000000E+00,
  0.19602391E+04, 0.120E+03, 0.680E+02, 0.98310000E+00, 0.00000000E+00,
  0.19174640E+04, 0.120E+03, 0.690E+02, 0.98310000E+00, 0.00000000E+00,
  0.18991306E+04, 0.120E+03, 0.700E+02, 0.98310000E+00, 0.00000000E+00,
  0.15446852E+04, 0.120E+03, 0.710E+02, 0.98310000E+00, 0.00000000E+00,
  0.14351503E+04, 0.120E+03, 0.720E+02, 0.98310000E+00, 0.00000000E+00,
  0.12687518E+04, 0.120E+03, 0.730E+02, 0.98310000E+00, 0.00000000E+00,
  0.10493296E+04, 0.120E+03, 0.740E+02, 0.98310000E+00, 0.00000000E+00,
  0.10529922E+04, 0.120E+03, 0.750E+02, 0.98310000E+00, 0.00000000E+00,
  0.92845210E+03, 0.120E+03, 0.760E+02, 0.98310000E+00, 0.00000000E+00,
  0.83187520E+03, 0.120E+03, 0.770E+02, 0.98310000E+00, 0.00000000E+00,
  0.67699020E+03, 0.120E+03, 0.780E+02, 0.98310000E+00, 0.00000000E+00,
  0.62708530E+03, 0.120E+03, 0.790E+02, 0.98310000E+00, 0.00000000E+00,
  0.63711120E+03, 0.120E+03, 0.800E+02, 0.98310000E+00, 0.00000000E+00,
  0.10430556E+04, 0.120E+03, 0.810E+02, 0.98310000E+00, 0.00000000E+00,
  0.97428450E+03, 0.120E+03, 0.820E+02, 0.98310000E+00, 0.00000000E+00,
  0.85466400E+03, 0.120E+03, 0.830E+02, 0.98310000E+00, 0.00000000E+00,
  0.79444910E+03, 0.120E+03, 0.840E+02, 0.98310000E+00, 0.00000000E+00,
  0.71141430E+03, 0.120E+03, 0.850E+02, 0.98310000E+00, 0.00000000E+00,
  0.63479210E+03, 0.120E+03, 0.860E+02, 0.98310000E+00, 0.00000000E+00,
  0.32712563E+04, 0.120E+03, 0.870E+02, 0.98310000E+00, 0.00000000E+00,
  0.28409447E+04, 0.120E+03, 0.880E+02, 0.98310000E+00, 0.00000000E+00,
  0.23867637E+04, 0.120E+03, 0.890E+02, 0.98310000E+00, 0.00000000E+00,
  0.20296245E+04, 0.120E+03, 0.900E+02, 0.98310000E+00, 0.00000000E+00,
  0.20761172E+04, 0.120E+03, 0.910E+02, 0.98310000E+00, 0.00000000E+00,
  0.20066915E+04, 0.120E+03, 0.920E+02, 0.98310000E+00, 0.00000000E+00,
  0.21352269E+04, 0.120E+03, 0.930E+02, 0.98310000E+00, 0.00000000E+00,
  0.20540131E+04, 0.120E+03, 0.940E+02, 0.98310000E+00, 0.00000000E+00,
  0.90792700E+02, 0.120E+03, 0.101E+03, 0.98310000E+00, 0.00000000E+00,
  0.34561200E+03, 0.120E+03, 0.103E+03, 0.98310000E+00, 0.98650000E+00,
  0.43402840E+03, 0.120E+03, 0.104E+03, 0.98310000E+00, 0.98080000E+00,
  0.29872640E+03, 0.120E+03, 0.105E+03, 0.98310000E+00, 0.97060000E+00,
  0.21289570E+03, 0.120E+03, 0.106E+03, 0.98310000E+00, 0.98680000E+00,
  0.13902190E+03, 0.120E+03, 0.107E+03, 0.98310000E+00, 0.99440000E+00,
  0.96158400E+02, 0.120E+03, 0.108E+03, 0.98310000E+00, 0.99250000E+00,
  0.62058000E+02, 0.120E+03, 0.109E+03, 0.98310000E+00, 0.99820000E+00,
  0.51669170E+03, 0.120E+03, 0.111E+03, 0.98310000E+00, 0.96840000E+00,
  0.80921820E+03, 0.120E+03, 0.112E+03, 0.98310000E+00, 0.96280000E+00,
  0.77508320E+03, 0.120E+03, 0.113E+03, 0.98310000E+00, 0.96480000E+00,
  0.57629620E+03, 0.120E+03, 0.114E+03, 0.98310000E+00, 0.95070000E+00,
  0.44601700E+03, 0.120E+03, 0.115E+03, 0.98310000E+00, 0.99470000E+00,
  0.36319510E+03, 0.120E+03, 0.116E+03, 0.98310000E+00, 0.99480000E+00,
  0.28549050E+03, 0.120E+03, 0.117E+03, 0.98310000E+00, 0.99720000E+00,
  0.68899110E+03, 0.120E+03, 0.119E+03, 0.98310000E+00, 0.97670000E+00,
  0.15251891E+04, 0.120E+03, 0.120E+03, 0.98310000E+00, 0.98310000E+00,
  0.29995300E+02, 0.121E+03, 0.100E+01, 0.18627000E+01, 0.91180000E+00,
  0.19384100E+02, 0.121E+03, 0.200E+01, 0.18627000E+01, 0.00000000E+00,
  0.50482680E+03, 0.121E+03, 0.300E+01, 0.18627000E+01, 0.00000000E+00,
  0.28244200E+03, 0.121E+03, 0.400E+01, 0.18627000E+01, 0.00000000E+00,
  0.18614190E+03, 0.121E+03, 0.500E+01, 0.18627000E+01, 0.00000000E+00,
  0.12363790E+03, 0.121E+03, 0.600E+01, 0.18627000E+01, 0.00000000E+00,
  0.85340400E+02, 0.121E+03, 0.700E+01, 0.18627000E+01, 0.00000000E+00,
  0.64007200E+02, 0.121E+03, 0.800E+01, 0.18627000E+01, 0.00000000E+00,
  0.48093600E+02, 0.121E+03, 0.900E+01, 0.18627000E+01, 0.00000000E+00,
  0.36746800E+02, 0.121E+03, 0.100E+02, 0.18627000E+01, 0.00000000E+00,
  0.60249290E+03, 0.121E+03, 0.110E+02, 0.18627000E+01, 0.00000000E+00,
  0.45276000E+03, 0.121E+03, 0.120E+02, 0.18627000E+01, 0.00000000E+00,
  0.41290580E+03, 0.121E+03, 0.130E+02, 0.18627000E+01, 0.00000000E+00,
  0.32058960E+03, 0.121E+03, 0.140E+02, 0.18627000E+01, 0.00000000E+00,
  0.24673580E+03, 0.121E+03, 0.150E+02, 0.18627000E+01, 0.00000000E+00,
  0.20296720E+03, 0.121E+03, 0.160E+02, 0.18627000E+01, 0.00000000E+00,
  0.16436550E+03, 0.121E+03, 0.170E+02, 0.18627000E+01, 0.00000000E+00,
  0.13344040E+03, 0.121E+03, 0.180E+02, 0.18627000E+01, 0.00000000E+00,
  0.98858810E+03, 0.121E+03, 0.190E+02, 0.18627000E+01, 0.00000000E+00,
  0.80323800E+03, 0.121E+03, 0.200E+02, 0.18627000E+01, 0.00000000E+00,
  0.66067800E+03, 0.121E+03, 0.210E+02, 0.18627000E+01, 0.00000000E+00,
  0.63504570E+03, 0.121E+03, 0.220E+02, 0.18627000E+01, 0.00000000E+00,
  0.57995840E+03, 0.121E+03, 0.230E+02, 0.18627000E+01, 0.00000000E+00,
  0.45620230E+03, 0.121E+03, 0.240E+02, 0.18627000E+01, 0.00000000E+00,
  0.49734740E+03, 0.121E+03, 0.250E+02, 0.18627000E+01, 0.00000000E+00,
  0.38959740E+03, 0.121E+03, 0.260E+02, 0.18627000E+01, 0.00000000E+00,
  0.41105720E+03, 0.121E+03, 0.270E+02, 0.18627000E+01, 0.00000000E+00,
  0.42466930E+03, 0.121E+03, 0.280E+02, 0.18627000E+01, 0.00000000E+00,
  0.32508500E+03, 0.121E+03, 0.290E+02, 0.18627000E+01, 0.00000000E+00,
  0.33123100E+03, 0.121E+03, 0.300E+02, 0.18627000E+01, 0.00000000E+00,
  0.39353000E+03, 0.121E+03, 0.310E+02, 0.18627000E+01, 0.00000000E+00,
  0.34316790E+03, 0.121E+03, 0.320E+02, 0.18627000E+01, 0.00000000E+00,
  0.28955820E+03, 0.121E+03, 0.330E+02, 0.18627000E+01, 0.00000000E+00,
  0.25800840E+03, 0.121E+03, 0.340E+02, 0.18627000E+01, 0.00000000E+00,
  0.22413750E+03, 0.121E+03, 0.350E+02, 0.18627000E+01, 0.00000000E+00,
  0.19358680E+03, 0.121E+03, 0.360E+02, 0.18627000E+01, 0.00000000E+00,
  0.11054608E+04, 0.121E+03, 0.370E+02, 0.18627000E+01, 0.00000000E+00,
  0.95722710E+03, 0.121E+03, 0.380E+02, 0.18627000E+01, 0.00000000E+00,
  0.83166790E+03, 0.121E+03, 0.390E+02, 0.18627000E+01, 0.00000000E+00,
  0.74343180E+03, 0.121E+03, 0.400E+02, 0.18627000E+01, 0.00000000E+00,
  0.67533140E+03, 0.121E+03, 0.410E+02, 0.18627000E+01, 0.00000000E+00,
  0.51773400E+03, 0.121E+03, 0.420E+02, 0.18627000E+01, 0.00000000E+00,
  0.57916230E+03, 0.121E+03, 0.430E+02, 0.18627000E+01, 0.00000000E+00,
  0.43784320E+03, 0.121E+03, 0.440E+02, 0.18627000E+01, 0.00000000E+00,
  0.47895980E+03, 0.121E+03, 0.450E+02, 0.18627000E+01, 0.00000000E+00,
  0.44308160E+03, 0.121E+03, 0.460E+02, 0.18627000E+01, 0.00000000E+00,
  0.36949330E+03, 0.121E+03, 0.470E+02, 0.18627000E+01, 0.00000000E+00,
  0.38918590E+03, 0.121E+03, 0.480E+02, 0.18627000E+01, 0.00000000E+00,
  0.49219040E+03, 0.121E+03, 0.490E+02, 0.18627000E+01, 0.00000000E+00,
  0.45113400E+03, 0.121E+03, 0.500E+02, 0.18627000E+01, 0.00000000E+00,
  0.39831520E+03, 0.121E+03, 0.510E+02, 0.18627000E+01, 0.00000000E+00,
  0.36739080E+03, 0.121E+03, 0.520E+02, 0.18627000E+01, 0.00000000E+00,
  0.33004180E+03, 0.121E+03, 0.530E+02, 0.18627000E+01, 0.00000000E+00,
  0.29487060E+03, 0.121E+03, 0.540E+02, 0.18627000E+01, 0.00000000E+00,
  0.13445274E+04, 0.121E+03, 0.550E+02, 0.18627000E+01, 0.00000000E+00,
  0.12227426E+04, 0.121E+03, 0.560E+02, 0.18627000E+01, 0.00000000E+00,
  0.10658140E+04, 0.121E+03, 0.570E+02, 0.18627000E+01, 0.00000000E+00,
  0.47118540E+03, 0.121E+03, 0.580E+02, 0.18627000E+01, 0.27991000E+01,
  0.10799647E+04, 0.121E+03, 0.590E+02, 0.18627000E+01, 0.00000000E+00,
  0.10362055E+04, 0.121E+03, 0.600E+02, 0.18627000E+01, 0.00000000E+00,
  0.10098893E+04, 0.121E+03, 0.610E+02, 0.18627000E+01, 0.00000000E+00,
  0.98572640E+03, 0.121E+03, 0.620E+02, 0.18627000E+01, 0.00000000E+00,
  0.96428550E+03, 0.121E+03, 0.630E+02, 0.18627000E+01, 0.00000000E+00,
  0.75078480E+03, 0.121E+03, 0.640E+02, 0.18627000E+01, 0.00000000E+00,
  0.85514710E+03, 0.121E+03, 0.650E+02, 0.18627000E+01, 0.00000000E+00,
  0.82284200E+03, 0.121E+03, 0.660E+02, 0.18627000E+01, 0.00000000E+00,
  0.86811040E+03, 0.121E+03, 0.670E+02, 0.18627000E+01, 0.00000000E+00,
  0.84953940E+03, 0.121E+03, 0.680E+02, 0.18627000E+01, 0.00000000E+00,
  0.83269610E+03, 0.121E+03, 0.690E+02, 0.18627000E+01, 0.00000000E+00,
  0.82330890E+03, 0.121E+03, 0.700E+02, 0.18627000E+01, 0.00000000E+00,
  0.68862420E+03, 0.121E+03, 0.710E+02, 0.18627000E+01, 0.00000000E+00,
  0.67192580E+03, 0.121E+03, 0.720E+02, 0.18627000E+01, 0.00000000E+00,
  0.60975150E+03, 0.121E+03, 0.730E+02, 0.18627000E+01, 0.00000000E+00,
  0.51221050E+03, 0.121E+03, 0.740E+02, 0.18627000E+01, 0.00000000E+00,
  0.52005780E+03, 0.121E+03, 0.750E+02, 0.18627000E+01, 0.00000000E+00,
  0.46895650E+03, 0.121E+03, 0.760E+02, 0.18627000E+01, 0.00000000E+00,
  0.42768450E+03, 0.121E+03, 0.770E+02, 0.18627000E+01, 0.00000000E+00,
  0.35348450E+03, 0.121E+03, 0.780E+02, 0.18627000E+01, 0.00000000E+00,
  0.32959850E+03, 0.121E+03, 0.790E+02, 0.18627000E+01, 0.00000000E+00,
  0.33854780E+03, 0.121E+03, 0.800E+02, 0.18627000E+01, 0.00000000E+00,
  0.50363930E+03, 0.121E+03, 0.810E+02, 0.18627000E+01, 0.00000000E+00,
  0.48925410E+03, 0.121E+03, 0.820E+02, 0.18627000E+01, 0.00000000E+00,
  0.44592310E+03, 0.121E+03, 0.830E+02, 0.18627000E+01, 0.00000000E+00,
  0.42320630E+03, 0.121E+03, 0.840E+02, 0.18627000E+01, 0.00000000E+00,
  0.38821220E+03, 0.121E+03, 0.850E+02, 0.18627000E+01, 0.00000000E+00,
  0.35380050E+03, 0.121E+03, 0.860E+02, 0.18627000E+01, 0.00000000E+00,
  0.12630191E+04, 0.121E+03, 0.870E+02, 0.18627000E+01, 0.00000000E+00,
  0.12039859E+04, 0.121E+03, 0.880E+02, 0.18627000E+01, 0.00000000E+00,
  0.10563541E+04, 0.121E+03, 0.890E+02, 0.18627000E+01, 0.00000000E+00,
  0.94062410E+03, 0.121E+03, 0.900E+02, 0.18627000E+01, 0.00000000E+00,
  0.93765790E+03, 0.121E+03, 0.910E+02, 0.18627000E+01, 0.00000000E+00,
  0.90769560E+03, 0.121E+03, 0.920E+02, 0.18627000E+01, 0.00000000E+00,
  0.93986910E+03, 0.121E+03, 0.930E+02, 0.18627000E+01, 0.00000000E+00,
  0.90928950E+03, 0.121E+03, 0.940E+02, 0.18627000E+01, 0.00000000E+00,
  0.48975300E+02, 0.121E+03, 0.101E+03, 0.18627000E+01, 0.00000000E+00,
  0.16364460E+03, 0.121E+03, 0.103E+03, 0.18627000E+01, 0.98650000E+00,
  0.20781070E+03, 0.121E+03, 0.104E+03, 0.18627000E+01, 0.98080000E+00,
  0.15582280E+03, 0.121E+03, 0.105E+03, 0.18627000E+01, 0.97060000E+00,
  0.11597260E+03, 0.121E+03, 0.106E+03, 0.18627000E+01, 0.98680000E+00,
  0.79538300E+02, 0.121E+03, 0.107E+03, 0.18627000E+01, 0.99440000E+00,
  0.57261100E+02, 0.121E+03, 0.108E+03, 0.18627000E+01, 0.99250000E+00,
  0.38809700E+02, 0.121E+03, 0.109E+03, 0.18627000E+01, 0.99820000E+00,
  0.23997140E+03, 0.121E+03, 0.111E+03, 0.18627000E+01, 0.96840000E+00,
  0.37177680E+03, 0.121E+03, 0.112E+03, 0.18627000E+01, 0.96280000E+00,
  0.37318450E+03, 0.121E+03, 0.113E+03, 0.18627000E+01, 0.96480000E+00,
  0.29561010E+03, 0.121E+03, 0.114E+03, 0.18627000E+01, 0.95070000E+00,
  0.23937010E+03, 0.121E+03, 0.115E+03, 0.18627000E+01, 0.99470000E+00,
  0.20076220E+03, 0.121E+03, 0.116E+03, 0.18627000E+01, 0.99480000E+00,
  0.16268060E+03, 0.121E+03, 0.117E+03, 0.18627000E+01, 0.99720000E+00,
  0.32770920E+03, 0.121E+03, 0.119E+03, 0.18627000E+01, 0.97670000E+00,
  0.64070760E+03, 0.121E+03, 0.120E+03, 0.18627000E+01, 0.98310000E+00,
  0.32450680E+03, 0.121E+03, 0.121E+03, 0.18627000E+01, 0.18627000E+01,
  0.29000900E+02, 0.122E+03, 0.100E+01, 0.18299000E+01, 0.91180000E+00,
  0.18808400E+02, 0.122E+03, 0.200E+01, 0.18299000E+01, 0.00000000E+00,
  0.48829310E+03, 0.122E+03, 0.300E+01, 0.18299000E+01, 0.00000000E+00,
  0.27202010E+03, 0.122E+03, 0.400E+01, 0.18299000E+01, 0.00000000E+00,
  0.17950770E+03, 0.122E+03, 0.500E+01, 0.18299000E+01, 0.00000000E+00,
  0.11943760E+03, 0.122E+03, 0.600E+01, 0.18299000E+01, 0.00000000E+00,
  0.82583400E+02, 0.122E+03, 0.700E+01, 0.18299000E+01, 0.00000000E+00,
  0.62030900E+02, 0.122E+03, 0.800E+01, 0.18299000E+01, 0.00000000E+00,
  0.46676500E+02, 0.122E+03, 0.900E+01, 0.18299000E+01, 0.00000000E+00,
  0.35711700E+02, 0.122E+03, 0.100E+02, 0.18299000E+01, 0.00000000E+00,
  0.58252700E+03, 0.122E+03, 0.110E+02, 0.18299000E+01, 0.00000000E+00,
  0.43610910E+03, 0.122E+03, 0.120E+02, 0.18299000E+01, 0.00000000E+00,
  0.39786180E+03, 0.122E+03, 0.130E+02, 0.18299000E+01, 0.00000000E+00,
  0.30910810E+03, 0.122E+03, 0.140E+02, 0.18299000E+01, 0.00000000E+00,
  0.23816440E+03, 0.122E+03, 0.150E+02, 0.18299000E+01, 0.00000000E+00,
  0.19611280E+03, 0.122E+03, 0.160E+02, 0.18299000E+01, 0.00000000E+00,
  0.15898920E+03, 0.122E+03, 0.170E+02, 0.18299000E+01, 0.00000000E+00,
  0.12921800E+03, 0.122E+03, 0.180E+02, 0.18299000E+01, 0.00000000E+00,
  0.96033760E+03, 0.122E+03, 0.190E+02, 0.18299000E+01, 0.00000000E+00,
  0.77468630E+03, 0.122E+03, 0.200E+02, 0.18299000E+01, 0.00000000E+00,
  0.63687060E+03, 0.122E+03, 0.210E+02, 0.18299000E+01, 0.00000000E+00,
  0.61222250E+03, 0.122E+03, 0.220E+02, 0.18299000E+01, 0.00000000E+00,
  0.55911570E+03, 0.122E+03, 0.230E+02, 0.18299000E+01, 0.00000000E+00,
  0.44007620E+03, 0.122E+03, 0.240E+02, 0.18299000E+01, 0.00000000E+00,
  0.47949690E+03, 0.122E+03, 0.250E+02, 0.18299000E+01, 0.00000000E+00,
  0.37582420E+03, 0.122E+03, 0.260E+02, 0.18299000E+01, 0.00000000E+00,
  0.39627480E+03, 0.122E+03, 0.270E+02, 0.18299000E+01, 0.00000000E+00,
  0.40935550E+03, 0.122E+03, 0.280E+02, 0.18299000E+01, 0.00000000E+00,
  0.31360260E+03, 0.122E+03, 0.290E+02, 0.18299000E+01, 0.00000000E+00,
  0.31938340E+03, 0.122E+03, 0.300E+02, 0.18299000E+01, 0.00000000E+00,
  0.37941090E+03, 0.122E+03, 0.310E+02, 0.18299000E+01, 0.00000000E+00,
  0.33097100E+03, 0.122E+03, 0.320E+02, 0.18299000E+01, 0.00000000E+00,
  0.27949900E+03, 0.122E+03, 0.330E+02, 0.18299000E+01, 0.00000000E+00,
  0.24922580E+03, 0.122E+03, 0.340E+02, 0.18299000E+01, 0.00000000E+00,
  0.21669210E+03, 0.122E+03, 0.350E+02, 0.18299000E+01, 0.00000000E+00,
  0.18732310E+03, 0.122E+03, 0.360E+02, 0.18299000E+01, 0.00000000E+00,
  0.10741973E+04, 0.122E+03, 0.370E+02, 0.18299000E+01, 0.00000000E+00,
  0.92365570E+03, 0.122E+03, 0.380E+02, 0.18299000E+01, 0.00000000E+00,
  0.80203240E+03, 0.122E+03, 0.390E+02, 0.18299000E+01, 0.00000000E+00,
  0.71686090E+03, 0.122E+03, 0.400E+02, 0.18299000E+01, 0.00000000E+00,
  0.65128470E+03, 0.122E+03, 0.410E+02, 0.18299000E+01, 0.00000000E+00,
  0.49950110E+03, 0.122E+03, 0.420E+02, 0.18299000E+01, 0.00000000E+00,
  0.55872110E+03, 0.122E+03, 0.430E+02, 0.18299000E+01, 0.00000000E+00,
  0.42257080E+03, 0.122E+03, 0.440E+02, 0.18299000E+01, 0.00000000E+00,
  0.46203140E+03, 0.122E+03, 0.450E+02, 0.18299000E+01, 0.00000000E+00,
  0.42745770E+03, 0.122E+03, 0.460E+02, 0.18299000E+01, 0.00000000E+00,
  0.35672450E+03, 0.122E+03, 0.470E+02, 0.18299000E+01, 0.00000000E+00,
  0.37552610E+03, 0.122E+03, 0.480E+02, 0.18299000E+01, 0.00000000E+00,
  0.47481120E+03, 0.122E+03, 0.490E+02, 0.18299000E+01, 0.00000000E+00,
  0.43519480E+03, 0.122E+03, 0.500E+02, 0.18299000E+01, 0.00000000E+00,
  0.38444870E+03, 0.122E+03, 0.510E+02, 0.18299000E+01, 0.00000000E+00,
  0.35477930E+03, 0.122E+03, 0.520E+02, 0.18299000E+01, 0.00000000E+00,
  0.31891710E+03, 0.122E+03, 0.530E+02, 0.18299000E+01, 0.00000000E+00,
  0.28513250E+03, 0.122E+03, 0.540E+02, 0.18299000E+01, 0.00000000E+00,
  0.13086418E+04, 0.122E+03, 0.550E+02, 0.18299000E+01, 0.00000000E+00,
  0.11809424E+04, 0.122E+03, 0.560E+02, 0.18299000E+01, 0.00000000E+00,
  0.10284169E+04, 0.122E+03, 0.570E+02, 0.18299000E+01, 0.00000000E+00,
  0.45482000E+03, 0.122E+03, 0.580E+02, 0.18299000E+01, 0.27991000E+01,
  0.10433187E+04, 0.122E+03, 0.590E+02, 0.18299000E+01, 0.00000000E+00,
  0.10002155E+04, 0.122E+03, 0.600E+02, 0.18299000E+01, 0.00000000E+00,
  0.97472270E+03, 0.122E+03, 0.610E+02, 0.18299000E+01, 0.00000000E+00,
  0.95132570E+03, 0.122E+03, 0.620E+02, 0.18299000E+01, 0.00000000E+00,
  0.93056540E+03, 0.122E+03, 0.630E+02, 0.18299000E+01, 0.00000000E+00,
  0.72458860E+03, 0.122E+03, 0.640E+02, 0.18299000E+01, 0.00000000E+00,
  0.82779700E+03, 0.122E+03, 0.650E+02, 0.18299000E+01, 0.00000000E+00,
  0.79723640E+03, 0.122E+03, 0.660E+02, 0.18299000E+01, 0.00000000E+00,
  0.83746180E+03, 0.122E+03, 0.670E+02, 0.18299000E+01, 0.00000000E+00,
  0.81949730E+03, 0.122E+03, 0.680E+02, 0.18299000E+01, 0.00000000E+00,
  0.80320320E+03, 0.122E+03, 0.690E+02, 0.18299000E+01, 0.00000000E+00,
  0.79414040E+03, 0.122E+03, 0.700E+02, 0.18299000E+01, 0.00000000E+00,
  0.66477270E+03, 0.122E+03, 0.710E+02, 0.18299000E+01, 0.00000000E+00,
  0.64787460E+03, 0.122E+03, 0.720E+02, 0.18299000E+01, 0.00000000E+00,
  0.58798130E+03, 0.122E+03, 0.730E+02, 0.18299000E+01, 0.00000000E+00,
  0.49423570E+03, 0.122E+03, 0.740E+02, 0.18299000E+01, 0.00000000E+00,
  0.50177330E+03, 0.122E+03, 0.750E+02, 0.18299000E+01, 0.00000000E+00,
  0.45257260E+03, 0.122E+03, 0.760E+02, 0.18299000E+01, 0.00000000E+00,
  0.41285580E+03, 0.122E+03, 0.770E+02, 0.18299000E+01, 0.00000000E+00,
  0.34145400E+03, 0.122E+03, 0.780E+02, 0.18299000E+01, 0.00000000E+00,
  0.31846190E+03, 0.122E+03, 0.790E+02, 0.18299000E+01, 0.00000000E+00,
  0.32707700E+03, 0.122E+03, 0.800E+02, 0.18299000E+01, 0.00000000E+00,
  0.48621160E+03, 0.122E+03, 0.810E+02, 0.18299000E+01, 0.00000000E+00,
  0.47215520E+03, 0.122E+03, 0.820E+02, 0.18299000E+01, 0.00000000E+00,
  0.43048050E+03, 0.122E+03, 0.830E+02, 0.18299000E+01, 0.00000000E+00,
  0.40869510E+03, 0.122E+03, 0.840E+02, 0.18299000E+01, 0.00000000E+00,
  0.37510290E+03, 0.122E+03, 0.850E+02, 0.18299000E+01, 0.00000000E+00,
  0.34205750E+03, 0.122E+03, 0.860E+02, 0.18299000E+01, 0.00000000E+00,
  0.12263970E+04, 0.122E+03, 0.870E+02, 0.18299000E+01, 0.00000000E+00,
  0.11623660E+04, 0.122E+03, 0.880E+02, 0.18299000E+01, 0.00000000E+00,
  0.10191422E+04, 0.122E+03, 0.890E+02, 0.18299000E+01, 0.00000000E+00,
  0.90723670E+03, 0.122E+03, 0.900E+02, 0.18299000E+01, 0.00000000E+00,
  0.90483310E+03, 0.122E+03, 0.910E+02, 0.18299000E+01, 0.00000000E+00,
  0.87587480E+03, 0.122E+03, 0.920E+02, 0.18299000E+01, 0.00000000E+00,
  0.90696160E+03, 0.122E+03, 0.930E+02, 0.18299000E+01, 0.00000000E+00,
  0.87736450E+03, 0.122E+03, 0.940E+02, 0.18299000E+01, 0.00000000E+00,
  0.47275500E+02, 0.122E+03, 0.101E+03, 0.18299000E+01, 0.00000000E+00,
  0.15766670E+03, 0.122E+03, 0.103E+03, 0.18299000E+01, 0.98650000E+00,
  0.20036690E+03, 0.122E+03, 0.104E+03, 0.18299000E+01, 0.98080000E+00,
  0.15035200E+03, 0.122E+03, 0.105E+03, 0.18299000E+01, 0.97060000E+00,
  0.11205230E+03, 0.122E+03, 0.106E+03, 0.18299000E+01, 0.98680000E+00,
  0.76983400E+02, 0.122E+03, 0.107E+03, 0.18299000E+01, 0.99440000E+00,
  0.55516000E+02, 0.122E+03, 0.108E+03, 0.18299000E+01, 0.99250000E+00,
  0.37722200E+02, 0.122E+03, 0.109E+03, 0.18299000E+01, 0.99820000E+00,
  0.23126120E+03, 0.122E+03, 0.111E+03, 0.18299000E+01, 0.96840000E+00,
  0.35836020E+03, 0.122E+03, 0.112E+03, 0.18299000E+01, 0.96280000E+00,
  0.35964970E+03, 0.122E+03, 0.113E+03, 0.18299000E+01, 0.96480000E+00,
  0.28509570E+03, 0.122E+03, 0.114E+03, 0.18299000E+01, 0.95070000E+00,
  0.23107730E+03, 0.122E+03, 0.115E+03, 0.18299000E+01, 0.99470000E+00,
  0.19398450E+03, 0.122E+03, 0.116E+03, 0.18299000E+01, 0.99480000E+00,
  0.15736040E+03, 0.122E+03, 0.117E+03, 0.18299000E+01, 0.99720000E+00,
  0.31625180E+03, 0.122E+03, 0.119E+03, 0.18299000E+01, 0.97670000E+00,
  0.61943010E+03, 0.122E+03, 0.120E+03, 0.18299000E+01, 0.98310000E+00,
  0.31292020E+03, 0.122E+03, 0.121E+03, 0.18299000E+01, 0.18627000E+01,
  0.30199880E+03, 0.122E+03, 0.122E+03, 0.18299000E+01, 0.18299000E+01,
  0.28406700E+02, 0.123E+03, 0.100E+01, 0.19138000E+01, 0.91180000E+00,
  0.18435900E+02, 0.123E+03, 0.200E+01, 0.19138000E+01, 0.00000000E+00,
  0.47914020E+03, 0.123E+03, 0.300E+01, 0.19138000E+01, 0.00000000E+00,
  0.26670500E+03, 0.123E+03, 0.400E+01, 0.19138000E+01, 0.00000000E+00,
  0.17589090E+03, 0.123E+03, 0.500E+01, 0.19138000E+01, 0.00000000E+00,
  0.11700980E+03, 0.123E+03, 0.600E+01, 0.19138000E+01, 0.00000000E+00,
  0.80914400E+02, 0.123E+03, 0.700E+01, 0.19138000E+01, 0.00000000E+00,
  0.60793300E+02, 0.123E+03, 0.800E+01, 0.19138000E+01, 0.00000000E+00,
  0.45763000E+02, 0.123E+03, 0.900E+01, 0.19138000E+01, 0.00000000E+00,
  0.35029000E+02, 0.123E+03, 0.100E+02, 0.19138000E+01, 0.00000000E+00,
  0.57164550E+03, 0.123E+03, 0.110E+02, 0.19138000E+01, 0.00000000E+00,
  0.42771560E+03, 0.123E+03, 0.120E+02, 0.19138000E+01, 0.00000000E+00,
  0.39004320E+03, 0.123E+03, 0.130E+02, 0.19138000E+01, 0.00000000E+00,
  0.30289850E+03, 0.123E+03, 0.140E+02, 0.19138000E+01, 0.00000000E+00,
  0.23331760E+03, 0.123E+03, 0.150E+02, 0.19138000E+01, 0.00000000E+00,
  0.19211130E+03, 0.123E+03, 0.160E+02, 0.19138000E+01, 0.00000000E+00,
  0.15575070E+03, 0.123E+03, 0.170E+02, 0.19138000E+01, 0.00000000E+00,
  0.12660270E+03, 0.123E+03, 0.180E+02, 0.19138000E+01, 0.00000000E+00,
  0.94198370E+03, 0.123E+03, 0.190E+02, 0.19138000E+01, 0.00000000E+00,
  0.76007180E+03, 0.123E+03, 0.200E+02, 0.19138000E+01, 0.00000000E+00,
  0.62478010E+03, 0.123E+03, 0.210E+02, 0.19138000E+01, 0.00000000E+00,
  0.60052210E+03, 0.123E+03, 0.220E+02, 0.19138000E+01, 0.00000000E+00,
  0.54839080E+03, 0.123E+03, 0.230E+02, 0.19138000E+01, 0.00000000E+00,
  0.43166830E+03, 0.123E+03, 0.240E+02, 0.19138000E+01, 0.00000000E+00,
  0.47025290E+03, 0.123E+03, 0.250E+02, 0.19138000E+01, 0.00000000E+00,
  0.36861360E+03, 0.123E+03, 0.260E+02, 0.19138000E+01, 0.00000000E+00,
  0.38857290E+03, 0.123E+03, 0.270E+02, 0.19138000E+01, 0.00000000E+00,
  0.40143290E+03, 0.123E+03, 0.280E+02, 0.19138000E+01, 0.00000000E+00,
  0.30757630E+03, 0.123E+03, 0.290E+02, 0.19138000E+01, 0.00000000E+00,
  0.31312860E+03, 0.123E+03, 0.300E+02, 0.19138000E+01, 0.00000000E+00,
  0.37194270E+03, 0.123E+03, 0.310E+02, 0.19138000E+01, 0.00000000E+00,
  0.32434350E+03, 0.123E+03, 0.320E+02, 0.19138000E+01, 0.00000000E+00,
  0.27383520E+03, 0.123E+03, 0.330E+02, 0.19138000E+01, 0.00000000E+00,
  0.24415540E+03, 0.123E+03, 0.340E+02, 0.19138000E+01, 0.00000000E+00,
  0.21227920E+03, 0.123E+03, 0.350E+02, 0.19138000E+01, 0.00000000E+00,
  0.18351710E+03, 0.123E+03, 0.360E+02, 0.19138000E+01, 0.00000000E+00,
  0.10535834E+04, 0.123E+03, 0.370E+02, 0.19138000E+01, 0.00000000E+00,
  0.90623640E+03, 0.123E+03, 0.380E+02, 0.19138000E+01, 0.00000000E+00,
  0.78672550E+03, 0.123E+03, 0.390E+02, 0.19138000E+01, 0.00000000E+00,
  0.70307840E+03, 0.123E+03, 0.400E+02, 0.19138000E+01, 0.00000000E+00,
  0.63870140E+03, 0.123E+03, 0.410E+02, 0.19138000E+01, 0.00000000E+00,
  0.48981600E+03, 0.123E+03, 0.420E+02, 0.19138000E+01, 0.00000000E+00,
  0.54789060E+03, 0.123E+03, 0.430E+02, 0.19138000E+01, 0.00000000E+00,
  0.41435750E+03, 0.123E+03, 0.440E+02, 0.19138000E+01, 0.00000000E+00,
  0.45302620E+03, 0.123E+03, 0.450E+02, 0.19138000E+01, 0.00000000E+00,
  0.41911340E+03, 0.123E+03, 0.460E+02, 0.19138000E+01, 0.00000000E+00,
  0.34982880E+03, 0.123E+03, 0.470E+02, 0.19138000E+01, 0.00000000E+00,
  0.36818710E+03, 0.123E+03, 0.480E+02, 0.19138000E+01, 0.00000000E+00,
  0.46556470E+03, 0.123E+03, 0.490E+02, 0.19138000E+01, 0.00000000E+00,
  0.42659330E+03, 0.123E+03, 0.500E+02, 0.19138000E+01, 0.00000000E+00,
  0.37675440E+03, 0.123E+03, 0.510E+02, 0.19138000E+01, 0.00000000E+00,
  0.34763740E+03, 0.123E+03, 0.520E+02, 0.19138000E+01, 0.00000000E+00,
  0.31247140E+03, 0.123E+03, 0.530E+02, 0.19138000E+01, 0.00000000E+00,
  0.27936120E+03, 0.123E+03, 0.540E+02, 0.19138000E+01, 0.00000000E+00,
  0.12831193E+04, 0.123E+03, 0.550E+02, 0.19138000E+01, 0.00000000E+00,
  0.11586662E+04, 0.123E+03, 0.560E+02, 0.19138000E+01, 0.00000000E+00,
  0.10088336E+04, 0.123E+03, 0.570E+02, 0.19138000E+01, 0.00000000E+00,
  0.44575700E+03, 0.123E+03, 0.580E+02, 0.19138000E+01, 0.27991000E+01,
  0.10235395E+04, 0.123E+03, 0.590E+02, 0.19138000E+01, 0.00000000E+00,
  0.98134570E+03, 0.123E+03, 0.600E+02, 0.19138000E+01, 0.00000000E+00,
  0.95633210E+03, 0.123E+03, 0.610E+02, 0.19138000E+01, 0.00000000E+00,
  0.93337380E+03, 0.123E+03, 0.620E+02, 0.19138000E+01, 0.00000000E+00,
  0.91300140E+03, 0.123E+03, 0.630E+02, 0.19138000E+01, 0.00000000E+00,
  0.71072370E+03, 0.123E+03, 0.640E+02, 0.19138000E+01, 0.00000000E+00,
  0.81199050E+03, 0.123E+03, 0.650E+02, 0.19138000E+01, 0.00000000E+00,
  0.78182720E+03, 0.123E+03, 0.660E+02, 0.19138000E+01, 0.00000000E+00,
  0.82162740E+03, 0.123E+03, 0.670E+02, 0.19138000E+01, 0.00000000E+00,
  0.80399890E+03, 0.123E+03, 0.680E+02, 0.19138000E+01, 0.00000000E+00,
  0.78800640E+03, 0.123E+03, 0.690E+02, 0.19138000E+01, 0.00000000E+00,
  0.77912190E+03, 0.123E+03, 0.700E+02, 0.19138000E+01, 0.00000000E+00,
  0.65197940E+03, 0.123E+03, 0.710E+02, 0.19138000E+01, 0.00000000E+00,
  0.63529960E+03, 0.123E+03, 0.720E+02, 0.19138000E+01, 0.00000000E+00,
  0.57649460E+03, 0.123E+03, 0.730E+02, 0.19138000E+01, 0.00000000E+00,
  0.48455830E+03, 0.123E+03, 0.740E+02, 0.19138000E+01, 0.00000000E+00,
  0.49191200E+03, 0.123E+03, 0.750E+02, 0.19138000E+01, 0.00000000E+00,
  0.44364130E+03, 0.123E+03, 0.760E+02, 0.19138000E+01, 0.00000000E+00,
  0.40468640E+03, 0.123E+03, 0.770E+02, 0.19138000E+01, 0.00000000E+00,
  0.33471530E+03, 0.123E+03, 0.780E+02, 0.19138000E+01, 0.00000000E+00,
  0.31218730E+03, 0.123E+03, 0.790E+02, 0.19138000E+01, 0.00000000E+00,
  0.32060120E+03, 0.123E+03, 0.800E+02, 0.19138000E+01, 0.00000000E+00,
  0.47675960E+03, 0.123E+03, 0.810E+02, 0.19138000E+01, 0.00000000E+00,
  0.46287410E+03, 0.123E+03, 0.820E+02, 0.19138000E+01, 0.00000000E+00,
  0.42191810E+03, 0.123E+03, 0.830E+02, 0.19138000E+01, 0.00000000E+00,
  0.40051720E+03, 0.123E+03, 0.840E+02, 0.19138000E+01, 0.00000000E+00,
  0.36755880E+03, 0.123E+03, 0.850E+02, 0.19138000E+01, 0.00000000E+00,
  0.33516100E+03, 0.123E+03, 0.860E+02, 0.19138000E+01, 0.00000000E+00,
  0.12027024E+04, 0.123E+03, 0.870E+02, 0.19138000E+01, 0.00000000E+00,
  0.11403430E+04, 0.123E+03, 0.880E+02, 0.19138000E+01, 0.00000000E+00,
  0.99965520E+03, 0.123E+03, 0.890E+02, 0.19138000E+01, 0.00000000E+00,
  0.88972590E+03, 0.123E+03, 0.900E+02, 0.19138000E+01, 0.00000000E+00,
  0.88748800E+03, 0.123E+03, 0.910E+02, 0.19138000E+01, 0.00000000E+00,
  0.85909970E+03, 0.123E+03, 0.920E+02, 0.19138000E+01, 0.00000000E+00,
  0.88977190E+03, 0.123E+03, 0.930E+02, 0.19138000E+01, 0.00000000E+00,
  0.86071780E+03, 0.123E+03, 0.940E+02, 0.19138000E+01, 0.00000000E+00,
  0.46308900E+02, 0.123E+03, 0.101E+03, 0.19138000E+01, 0.00000000E+00,
  0.15457620E+03, 0.123E+03, 0.103E+03, 0.19138000E+01, 0.98650000E+00,
  0.19640270E+03, 0.123E+03, 0.104E+03, 0.19138000E+01, 0.98080000E+00,
  0.14731530E+03, 0.123E+03, 0.105E+03, 0.19138000E+01, 0.97060000E+00,
  0.10977970E+03, 0.123E+03, 0.106E+03, 0.19138000E+01, 0.98680000E+00,
  0.75430300E+02, 0.123E+03, 0.107E+03, 0.19138000E+01, 0.99440000E+00,
  0.54410900E+02, 0.123E+03, 0.108E+03, 0.19138000E+01, 0.99250000E+00,
  0.36996200E+02, 0.123E+03, 0.109E+03, 0.19138000E+01, 0.99820000E+00,
  0.22678860E+03, 0.123E+03, 0.111E+03, 0.19138000E+01, 0.96840000E+00,
  0.35139280E+03, 0.123E+03, 0.112E+03, 0.19138000E+01, 0.96280000E+00,
  0.35255750E+03, 0.123E+03, 0.113E+03, 0.19138000E+01, 0.96480000E+00,
  0.27935630E+03, 0.123E+03, 0.114E+03, 0.19138000E+01, 0.95070000E+00,
  0.22637670E+03, 0.123E+03, 0.115E+03, 0.19138000E+01, 0.99470000E+00,
  0.19002990E+03, 0.123E+03, 0.116E+03, 0.19138000E+01, 0.99480000E+00,
  0.15415760E+03, 0.123E+03, 0.117E+03, 0.19138000E+01, 0.99720000E+00,
  0.31011080E+03, 0.123E+03, 0.119E+03, 0.19138000E+01, 0.97670000E+00,
  0.60755710E+03, 0.123E+03, 0.120E+03, 0.19138000E+01, 0.98310000E+00,
  0.30673890E+03, 0.123E+03, 0.121E+03, 0.19138000E+01, 0.18627000E+01,
  0.29600290E+03, 0.123E+03, 0.122E+03, 0.19138000E+01, 0.18299000E+01,
  0.29014360E+03, 0.123E+03, 0.123E+03, 0.19138000E+01, 0.19138000E+01,
  0.28056200E+02, 0.124E+03, 0.100E+01, 0.18269000E+01, 0.91180000E+00,
  0.18175400E+02, 0.124E+03, 0.200E+01, 0.18269000E+01, 0.00000000E+00,
  0.48059440E+03, 0.124E+03, 0.300E+01, 0.18269000E+01, 0.00000000E+00,
  0.26540880E+03, 0.124E+03, 0.400E+01, 0.18269000E+01, 0.00000000E+00,
  0.17437190E+03, 0.124E+03, 0.500E+01, 0.18269000E+01, 0.00000000E+00,
  0.11571820E+03, 0.124E+03, 0.600E+01, 0.18269000E+01, 0.00000000E+00,
  0.79902400E+02, 0.124E+03, 0.700E+01, 0.18269000E+01, 0.00000000E+00,
  0.59982900E+02, 0.124E+03, 0.800E+01, 0.18269000E+01, 0.00000000E+00,
  0.45129000E+02, 0.124E+03, 0.900E+01, 0.18269000E+01, 0.00000000E+00,
  0.34535000E+02, 0.124E+03, 0.100E+02, 0.18269000E+01, 0.00000000E+00,
  0.57314360E+03, 0.124E+03, 0.110E+02, 0.18269000E+01, 0.00000000E+00,
  0.42622760E+03, 0.124E+03, 0.120E+02, 0.18269000E+01, 0.00000000E+00,
  0.38786950E+03, 0.124E+03, 0.130E+02, 0.18269000E+01, 0.00000000E+00,
  0.30039280E+03, 0.124E+03, 0.140E+02, 0.18269000E+01, 0.00000000E+00,
  0.23090900E+03, 0.124E+03, 0.150E+02, 0.18269000E+01, 0.00000000E+00,
  0.18990520E+03, 0.124E+03, 0.160E+02, 0.18269000E+01, 0.00000000E+00,
  0.15380570E+03, 0.124E+03, 0.170E+02, 0.18269000E+01, 0.00000000E+00,
  0.12492650E+03, 0.124E+03, 0.180E+02, 0.18269000E+01, 0.00000000E+00,
  0.94587000E+03, 0.124E+03, 0.190E+02, 0.18269000E+01, 0.00000000E+00,
  0.75936840E+03, 0.124E+03, 0.200E+02, 0.18269000E+01, 0.00000000E+00,
  0.62353320E+03, 0.124E+03, 0.210E+02, 0.18269000E+01, 0.00000000E+00,
  0.59879810E+03, 0.124E+03, 0.220E+02, 0.18269000E+01, 0.00000000E+00,
  0.54652440E+03, 0.124E+03, 0.230E+02, 0.18269000E+01, 0.00000000E+00,
  0.43023530E+03, 0.124E+03, 0.240E+02, 0.18269000E+01, 0.00000000E+00,
  0.46829610E+03, 0.124E+03, 0.250E+02, 0.18269000E+01, 0.00000000E+00,
  0.36707850E+03, 0.124E+03, 0.260E+02, 0.18269000E+01, 0.00000000E+00,
  0.38644860E+03, 0.124E+03, 0.270E+02, 0.18269000E+01, 0.00000000E+00,
  0.39945300E+03, 0.124E+03, 0.280E+02, 0.18269000E+01, 0.00000000E+00,
  0.30611810E+03, 0.124E+03, 0.290E+02, 0.18269000E+01, 0.00000000E+00,
  0.31106030E+03, 0.124E+03, 0.300E+02, 0.18269000E+01, 0.00000000E+00,
  0.36963020E+03, 0.124E+03, 0.310E+02, 0.18269000E+01, 0.00000000E+00,
  0.32164040E+03, 0.124E+03, 0.320E+02, 0.18269000E+01, 0.00000000E+00,
  0.27107700E+03, 0.124E+03, 0.330E+02, 0.18269000E+01, 0.00000000E+00,
  0.24145850E+03, 0.124E+03, 0.340E+02, 0.18269000E+01, 0.00000000E+00,
  0.20973930E+03, 0.124E+03, 0.350E+02, 0.18269000E+01, 0.00000000E+00,
  0.18118190E+03, 0.124E+03, 0.360E+02, 0.18269000E+01, 0.00000000E+00,
  0.10575718E+04, 0.124E+03, 0.370E+02, 0.18269000E+01, 0.00000000E+00,
  0.90561870E+03, 0.124E+03, 0.380E+02, 0.18269000E+01, 0.00000000E+00,
  0.78474890E+03, 0.124E+03, 0.390E+02, 0.18269000E+01, 0.00000000E+00,
  0.70054320E+03, 0.124E+03, 0.400E+02, 0.18269000E+01, 0.00000000E+00,
  0.63596390E+03, 0.124E+03, 0.410E+02, 0.18269000E+01, 0.00000000E+00,
  0.48719110E+03, 0.124E+03, 0.420E+02, 0.18269000E+01, 0.00000000E+00,
  0.54517240E+03, 0.124E+03, 0.430E+02, 0.18269000E+01, 0.00000000E+00,
  0.41181870E+03, 0.124E+03, 0.440E+02, 0.18269000E+01, 0.00000000E+00,
  0.45019430E+03, 0.124E+03, 0.450E+02, 0.18269000E+01, 0.00000000E+00,
  0.41632300E+03, 0.124E+03, 0.460E+02, 0.18269000E+01, 0.00000000E+00,
  0.34767860E+03, 0.124E+03, 0.470E+02, 0.18269000E+01, 0.00000000E+00,
  0.36555310E+03, 0.124E+03, 0.480E+02, 0.18269000E+01, 0.00000000E+00,
  0.46283040E+03, 0.124E+03, 0.490E+02, 0.18269000E+01, 0.00000000E+00,
  0.42332080E+03, 0.124E+03, 0.500E+02, 0.18269000E+01, 0.00000000E+00,
  0.37325910E+03, 0.124E+03, 0.510E+02, 0.18269000E+01, 0.00000000E+00,
  0.34409820E+03, 0.124E+03, 0.520E+02, 0.18269000E+01, 0.00000000E+00,
  0.30900630E+03, 0.124E+03, 0.530E+02, 0.18269000E+01, 0.00000000E+00,
  0.27604060E+03, 0.124E+03, 0.540E+02, 0.18269000E+01, 0.00000000E+00,
  0.12879616E+04, 0.124E+03, 0.550E+02, 0.18269000E+01, 0.00000000E+00,
  0.11586672E+04, 0.124E+03, 0.560E+02, 0.18269000E+01, 0.00000000E+00,
  0.10069636E+04, 0.124E+03, 0.570E+02, 0.18269000E+01, 0.00000000E+00,
  0.44178090E+03, 0.124E+03, 0.580E+02, 0.18269000E+01, 0.27991000E+01,
  0.10229773E+04, 0.124E+03, 0.590E+02, 0.18269000E+01, 0.00000000E+00,
  0.98048290E+03, 0.124E+03, 0.600E+02, 0.18269000E+01, 0.00000000E+00,
  0.95540420E+03, 0.124E+03, 0.610E+02, 0.18269000E+01, 0.00000000E+00,
  0.93239460E+03, 0.124E+03, 0.620E+02, 0.18269000E+01, 0.00000000E+00,
  0.91197350E+03, 0.124E+03, 0.630E+02, 0.18269000E+01, 0.00000000E+00,
  0.70857690E+03, 0.124E+03, 0.640E+02, 0.18269000E+01, 0.00000000E+00,
  0.81204950E+03, 0.124E+03, 0.650E+02, 0.18269000E+01, 0.00000000E+00,
  0.78162600E+03, 0.124E+03, 0.660E+02, 0.18269000E+01, 0.00000000E+00,
  0.82030710E+03, 0.124E+03, 0.670E+02, 0.18269000E+01, 0.00000000E+00,
  0.80266090E+03, 0.124E+03, 0.680E+02, 0.18269000E+01, 0.00000000E+00,
  0.78663360E+03, 0.124E+03, 0.690E+02, 0.18269000E+01, 0.00000000E+00,
  0.77782320E+03, 0.124E+03, 0.700E+02, 0.18269000E+01, 0.00000000E+00,
  0.65005720E+03, 0.124E+03, 0.710E+02, 0.18269000E+01, 0.00000000E+00,
  0.63220990E+03, 0.124E+03, 0.720E+02, 0.18269000E+01, 0.00000000E+00,
  0.57309450E+03, 0.124E+03, 0.730E+02, 0.18269000E+01, 0.00000000E+00,
  0.48138140E+03, 0.124E+03, 0.740E+02, 0.18269000E+01, 0.00000000E+00,
  0.48847190E+03, 0.124E+03, 0.750E+02, 0.18269000E+01, 0.00000000E+00,
  0.44016550E+03, 0.124E+03, 0.760E+02, 0.18269000E+01, 0.00000000E+00,
  0.40125220E+03, 0.124E+03, 0.770E+02, 0.18269000E+01, 0.00000000E+00,
  0.33169650E+03, 0.124E+03, 0.780E+02, 0.18269000E+01, 0.00000000E+00,
  0.30930750E+03, 0.124E+03, 0.790E+02, 0.18269000E+01, 0.00000000E+00,
  0.31751490E+03, 0.124E+03, 0.800E+02, 0.18269000E+01, 0.00000000E+00,
  0.47384960E+03, 0.124E+03, 0.810E+02, 0.18269000E+01, 0.00000000E+00,
  0.45937430E+03, 0.124E+03, 0.820E+02, 0.18269000E+01, 0.00000000E+00,
  0.41810440E+03, 0.124E+03, 0.830E+02, 0.18269000E+01, 0.00000000E+00,
  0.39657360E+03, 0.124E+03, 0.840E+02, 0.18269000E+01, 0.00000000E+00,
  0.36360680E+03, 0.124E+03, 0.850E+02, 0.18269000E+01, 0.00000000E+00,
  0.33130140E+03, 0.124E+03, 0.860E+02, 0.18269000E+01, 0.00000000E+00,
  0.12054436E+04, 0.124E+03, 0.870E+02, 0.18269000E+01, 0.00000000E+00,
  0.11392761E+04, 0.124E+03, 0.880E+02, 0.18269000E+01, 0.00000000E+00,
  0.99702490E+03, 0.124E+03, 0.890E+02, 0.18269000E+01, 0.00000000E+00,
  0.88576610E+03, 0.124E+03, 0.900E+02, 0.18269000E+01, 0.00000000E+00,
  0.88442800E+03, 0.124E+03, 0.910E+02, 0.18269000E+01, 0.00000000E+00,
  0.85610390E+03, 0.124E+03, 0.920E+02, 0.18269000E+01, 0.00000000E+00,
  0.88770660E+03, 0.124E+03, 0.930E+02, 0.18269000E+01, 0.00000000E+00,
  0.85853020E+03, 0.124E+03, 0.940E+02, 0.18269000E+01, 0.00000000E+00,
  0.45817300E+02, 0.124E+03, 0.101E+03, 0.18269000E+01, 0.00000000E+00,
  0.15375390E+03, 0.124E+03, 0.103E+03, 0.18269000E+01, 0.98650000E+00,
  0.19523170E+03, 0.124E+03, 0.104E+03, 0.18269000E+01, 0.98080000E+00,
  0.14594770E+03, 0.124E+03, 0.105E+03, 0.18269000E+01, 0.97060000E+00,
  0.10858200E+03, 0.124E+03, 0.106E+03, 0.18269000E+01, 0.98680000E+00,
  0.74489000E+02, 0.124E+03, 0.107E+03, 0.18269000E+01, 0.99440000E+00,
  0.53673300E+02, 0.124E+03, 0.108E+03, 0.18269000E+01, 0.99250000E+00,
  0.36459400E+02, 0.124E+03, 0.109E+03, 0.18269000E+01, 0.99820000E+00,
  0.22578370E+03, 0.124E+03, 0.111E+03, 0.18269000E+01, 0.96840000E+00,
  0.34993280E+03, 0.124E+03, 0.112E+03, 0.18269000E+01, 0.96280000E+00,
  0.35042960E+03, 0.124E+03, 0.113E+03, 0.18269000E+01, 0.96480000E+00,
  0.27695120E+03, 0.124E+03, 0.114E+03, 0.18269000E+01, 0.95070000E+00,
  0.22403030E+03, 0.124E+03, 0.115E+03, 0.18269000E+01, 0.99470000E+00,
  0.18785700E+03, 0.124E+03, 0.116E+03, 0.18269000E+01, 0.99480000E+00,
  0.15223830E+03, 0.124E+03, 0.117E+03, 0.18269000E+01, 0.99720000E+00,
  0.30839010E+03, 0.124E+03, 0.119E+03, 0.18269000E+01, 0.97670000E+00,
  0.60707000E+03, 0.124E+03, 0.120E+03, 0.18269000E+01, 0.98310000E+00,
  0.30430940E+03, 0.124E+03, 0.121E+03, 0.18269000E+01, 0.18627000E+01,
  0.29365980E+03, 0.124E+03, 0.122E+03, 0.18269000E+01, 0.18299000E+01,
  0.28786570E+03, 0.124E+03, 0.123E+03, 0.18269000E+01, 0.19138000E+01,
  0.28569050E+03, 0.124E+03, 0.124E+03, 0.18269000E+01, 0.18269000E+01,
  0.26181000E+02, 0.125E+03, 0.100E+01, 0.16406000E+01, 0.91180000E+00,
  0.17152600E+02, 0.125E+03, 0.200E+01, 0.16406000E+01, 0.00000000E+00,
  0.41608360E+03, 0.125E+03, 0.300E+01, 0.16406000E+01, 0.00000000E+00,
  0.23896060E+03, 0.125E+03, 0.400E+01, 0.16406000E+01, 0.00000000E+00,
  0.15984920E+03, 0.125E+03, 0.500E+01, 0.16406000E+01, 0.00000000E+00,
  0.10733820E+03, 0.125E+03, 0.600E+01, 0.16406000E+01, 0.00000000E+00,
  0.74699800E+02, 0.125E+03, 0.700E+01, 0.16406000E+01, 0.00000000E+00,
  0.56362200E+02, 0.125E+03, 0.800E+01, 0.16406000E+01, 0.00000000E+00,
  0.42576400E+02, 0.125E+03, 0.900E+01, 0.16406000E+01, 0.00000000E+00,
  0.32680600E+02, 0.125E+03, 0.100E+02, 0.16406000E+01, 0.00000000E+00,
  0.49735820E+03, 0.125E+03, 0.110E+02, 0.16406000E+01, 0.00000000E+00,
  0.38129680E+03, 0.125E+03, 0.120E+02, 0.16406000E+01, 0.00000000E+00,
  0.35045220E+03, 0.125E+03, 0.130E+02, 0.16406000E+01, 0.00000000E+00,
  0.27492570E+03, 0.125E+03, 0.140E+02, 0.16406000E+01, 0.00000000E+00,
  0.21341010E+03, 0.125E+03, 0.150E+02, 0.16406000E+01, 0.00000000E+00,
  0.17651650E+03, 0.125E+03, 0.160E+02, 0.16406000E+01, 0.00000000E+00,
  0.14370010E+03, 0.125E+03, 0.170E+02, 0.16406000E+01, 0.00000000E+00,
  0.11720570E+03, 0.125E+03, 0.180E+02, 0.16406000E+01, 0.00000000E+00,
  0.81424680E+03, 0.125E+03, 0.190E+02, 0.16406000E+01, 0.00000000E+00,
  0.67083370E+03, 0.125E+03, 0.200E+02, 0.16406000E+01, 0.00000000E+00,
  0.55379310E+03, 0.125E+03, 0.210E+02, 0.16406000E+01, 0.00000000E+00,
  0.53412660E+03, 0.125E+03, 0.220E+02, 0.16406000E+01, 0.00000000E+00,
  0.48879470E+03, 0.125E+03, 0.230E+02, 0.16406000E+01, 0.00000000E+00,
  0.38469310E+03, 0.125E+03, 0.240E+02, 0.16406000E+01, 0.00000000E+00,
  0.42042070E+03, 0.125E+03, 0.250E+02, 0.16406000E+01, 0.00000000E+00,
  0.32962730E+03, 0.125E+03, 0.260E+02, 0.16406000E+01, 0.00000000E+00,
  0.34919410E+03, 0.125E+03, 0.270E+02, 0.16406000E+01, 0.00000000E+00,
  0.36001720E+03, 0.125E+03, 0.280E+02, 0.16406000E+01, 0.00000000E+00,
  0.27572060E+03, 0.125E+03, 0.290E+02, 0.16406000E+01, 0.00000000E+00,
  0.28266670E+03, 0.125E+03, 0.300E+02, 0.16406000E+01, 0.00000000E+00,
  0.33506150E+03, 0.125E+03, 0.310E+02, 0.16406000E+01, 0.00000000E+00,
  0.29451840E+03, 0.125E+03, 0.320E+02, 0.16406000E+01, 0.00000000E+00,
  0.25028310E+03, 0.125E+03, 0.330E+02, 0.16406000E+01, 0.00000000E+00,
  0.22398570E+03, 0.125E+03, 0.340E+02, 0.16406000E+01, 0.00000000E+00,
  0.19545360E+03, 0.125E+03, 0.350E+02, 0.16406000E+01, 0.00000000E+00,
  0.16950970E+03, 0.125E+03, 0.360E+02, 0.16406000E+01, 0.00000000E+00,
  0.91194330E+03, 0.125E+03, 0.370E+02, 0.16406000E+01, 0.00000000E+00,
  0.79901250E+03, 0.125E+03, 0.380E+02, 0.16406000E+01, 0.00000000E+00,
  0.69867600E+03, 0.125E+03, 0.390E+02, 0.16406000E+01, 0.00000000E+00,
  0.62707900E+03, 0.125E+03, 0.400E+02, 0.16406000E+01, 0.00000000E+00,
  0.57118620E+03, 0.125E+03, 0.410E+02, 0.16406000E+01, 0.00000000E+00,
  0.43993260E+03, 0.125E+03, 0.420E+02, 0.16406000E+01, 0.00000000E+00,
  0.49132100E+03, 0.125E+03, 0.430E+02, 0.16406000E+01, 0.00000000E+00,
  0.37334420E+03, 0.125E+03, 0.440E+02, 0.16406000E+01, 0.00000000E+00,
  0.40836770E+03, 0.125E+03, 0.450E+02, 0.16406000E+01, 0.00000000E+00,
  0.37842950E+03, 0.125E+03, 0.460E+02, 0.16406000E+01, 0.00000000E+00,
  0.31534820E+03, 0.125E+03, 0.470E+02, 0.16406000E+01, 0.00000000E+00,
  0.33315180E+03, 0.125E+03, 0.480E+02, 0.16406000E+01, 0.00000000E+00,
  0.41907070E+03, 0.125E+03, 0.490E+02, 0.16406000E+01, 0.00000000E+00,
  0.38661840E+03, 0.125E+03, 0.500E+02, 0.16406000E+01, 0.00000000E+00,
  0.34352050E+03, 0.125E+03, 0.510E+02, 0.16406000E+01, 0.00000000E+00,
  0.31804850E+03, 0.125E+03, 0.520E+02, 0.16406000E+01, 0.00000000E+00,
  0.28687200E+03, 0.125E+03, 0.530E+02, 0.16406000E+01, 0.00000000E+00,
  0.25728030E+03, 0.125E+03, 0.540E+02, 0.16406000E+01, 0.00000000E+00,
  0.11103588E+04, 0.125E+03, 0.550E+02, 0.16406000E+01, 0.00000000E+00,
  0.10186688E+04, 0.125E+03, 0.560E+02, 0.16406000E+01, 0.00000000E+00,
  0.89350560E+03, 0.125E+03, 0.570E+02, 0.16406000E+01, 0.00000000E+00,
  0.40587370E+03, 0.125E+03, 0.580E+02, 0.16406000E+01, 0.27991000E+01,
  0.90204820E+03, 0.125E+03, 0.590E+02, 0.16406000E+01, 0.00000000E+00,
  0.86604420E+03, 0.125E+03, 0.600E+02, 0.16406000E+01, 0.00000000E+00,
  0.84428560E+03, 0.125E+03, 0.610E+02, 0.16406000E+01, 0.00000000E+00,
  0.82428300E+03, 0.125E+03, 0.620E+02, 0.16406000E+01, 0.00000000E+00,
  0.80654320E+03, 0.125E+03, 0.630E+02, 0.16406000E+01, 0.00000000E+00,
  0.63257430E+03, 0.125E+03, 0.640E+02, 0.16406000E+01, 0.00000000E+00,
  0.71375520E+03, 0.125E+03, 0.650E+02, 0.16406000E+01, 0.00000000E+00,
  0.68811250E+03, 0.125E+03, 0.660E+02, 0.16406000E+01, 0.00000000E+00,
  0.72723780E+03, 0.125E+03, 0.670E+02, 0.16406000E+01, 0.00000000E+00,
  0.71180010E+03, 0.125E+03, 0.680E+02, 0.16406000E+01, 0.00000000E+00,
  0.69785650E+03, 0.125E+03, 0.690E+02, 0.16406000E+01, 0.00000000E+00,
  0.68978470E+03, 0.125E+03, 0.700E+02, 0.16406000E+01, 0.00000000E+00,
  0.58012870E+03, 0.125E+03, 0.710E+02, 0.16406000E+01, 0.00000000E+00,
  0.56940560E+03, 0.125E+03, 0.720E+02, 0.16406000E+01, 0.00000000E+00,
  0.51879050E+03, 0.125E+03, 0.730E+02, 0.16406000E+01, 0.00000000E+00,
  0.43720880E+03, 0.125E+03, 0.740E+02, 0.16406000E+01, 0.00000000E+00,
  0.44459970E+03, 0.125E+03, 0.750E+02, 0.16406000E+01, 0.00000000E+00,
  0.40230970E+03, 0.125E+03, 0.760E+02, 0.16406000E+01, 0.00000000E+00,
  0.36794540E+03, 0.125E+03, 0.770E+02, 0.16406000E+01, 0.00000000E+00,
  0.30505010E+03, 0.125E+03, 0.780E+02, 0.16406000E+01, 0.00000000E+00,
  0.28480180E+03, 0.125E+03, 0.790E+02, 0.16406000E+01, 0.00000000E+00,
  0.29291770E+03, 0.125E+03, 0.800E+02, 0.16406000E+01, 0.00000000E+00,
  0.42959510E+03, 0.125E+03, 0.810E+02, 0.16406000E+01, 0.00000000E+00,
  0.41941490E+03, 0.125E+03, 0.820E+02, 0.16406000E+01, 0.00000000E+00,
  0.38444960E+03, 0.125E+03, 0.830E+02, 0.16406000E+01, 0.00000000E+00,
  0.36605470E+03, 0.125E+03, 0.840E+02, 0.16406000E+01, 0.00000000E+00,
  0.33709280E+03, 0.125E+03, 0.850E+02, 0.16406000E+01, 0.00000000E+00,
  0.30829470E+03, 0.125E+03, 0.860E+02, 0.16406000E+01, 0.00000000E+00,
  0.10472098E+04, 0.125E+03, 0.870E+02, 0.16406000E+01, 0.00000000E+00,
  0.10062859E+04, 0.125E+03, 0.880E+02, 0.16406000E+01, 0.00000000E+00,
  0.88823000E+03, 0.125E+03, 0.890E+02, 0.16406000E+01, 0.00000000E+00,
  0.79631050E+03, 0.125E+03, 0.900E+02, 0.16406000E+01, 0.00000000E+00,
  0.79125770E+03, 0.125E+03, 0.910E+02, 0.16406000E+01, 0.00000000E+00,
  0.76609840E+03, 0.125E+03, 0.920E+02, 0.16406000E+01, 0.00000000E+00,
  0.78992350E+03, 0.125E+03, 0.930E+02, 0.16406000E+01, 0.00000000E+00,
  0.76480610E+03, 0.125E+03, 0.940E+02, 0.16406000E+01, 0.00000000E+00,
  0.42392700E+02, 0.125E+03, 0.101E+03, 0.16406000E+01, 0.00000000E+00,
  0.13874910E+03, 0.125E+03, 0.103E+03, 0.16406000E+01, 0.98650000E+00,
  0.17668170E+03, 0.125E+03, 0.104E+03, 0.16406000E+01, 0.98080000E+00,
  0.13421360E+03, 0.125E+03, 0.105E+03, 0.16406000E+01, 0.97060000E+00,
  0.10064630E+03, 0.125E+03, 0.106E+03, 0.16406000E+01, 0.98680000E+00,
  0.69621500E+02, 0.125E+03, 0.107E+03, 0.16406000E+01, 0.99440000E+00,
  0.50485800E+02, 0.125E+03, 0.108E+03, 0.16406000E+01, 0.99250000E+00,
  0.34548100E+02, 0.125E+03, 0.109E+03, 0.16406000E+01, 0.99820000E+00,
  0.20296760E+03, 0.125E+03, 0.111E+03, 0.16406000E+01, 0.96840000E+00,
  0.31401190E+03, 0.125E+03, 0.112E+03, 0.16406000E+01, 0.96280000E+00,
  0.31732870E+03, 0.125E+03, 0.113E+03, 0.16406000E+01, 0.96480000E+00,
  0.25388000E+03, 0.125E+03, 0.114E+03, 0.16406000E+01, 0.95070000E+00,
  0.20709950E+03, 0.125E+03, 0.115E+03, 0.16406000E+01, 0.99470000E+00,
  0.17457750E+03, 0.125E+03, 0.116E+03, 0.16406000E+01, 0.99480000E+00,
  0.14221510E+03, 0.125E+03, 0.117E+03, 0.16406000E+01, 0.99720000E+00,
  0.27872590E+03, 0.125E+03, 0.119E+03, 0.16406000E+01, 0.97670000E+00,
  0.53581490E+03, 0.125E+03, 0.120E+03, 0.16406000E+01, 0.98310000E+00,
  0.27819650E+03, 0.125E+03, 0.121E+03, 0.16406000E+01, 0.18627000E+01,
  0.26846570E+03, 0.125E+03, 0.122E+03, 0.16406000E+01, 0.18299000E+01,
  0.26311270E+03, 0.125E+03, 0.123E+03, 0.16406000E+01, 0.19138000E+01,
  0.26077730E+03, 0.125E+03, 0.124E+03, 0.16406000E+01, 0.18269000E+01,
  0.23955540E+03, 0.125E+03, 0.125E+03, 0.16406000E+01, 0.16406000E+01,
  0.24345200E+02, 0.126E+03, 0.100E+01, 0.16483000E+01, 0.91180000E+00,
  0.16056000E+02, 0.126E+03, 0.200E+01, 0.16483000E+01, 0.00000000E+00,
  0.37921170E+03, 0.126E+03, 0.300E+01, 0.16483000E+01, 0.00000000E+00,
  0.21947750E+03, 0.126E+03, 0.400E+01, 0.16483000E+01, 0.00000000E+00,
  0.14762980E+03, 0.126E+03, 0.500E+01, 0.16483000E+01, 0.00000000E+00,
  0.99588000E+02, 0.126E+03, 0.600E+01, 0.16483000E+01, 0.00000000E+00,
  0.69563800E+02, 0.126E+03, 0.700E+01, 0.16483000E+01, 0.00000000E+00,
  0.52635100E+02, 0.126E+03, 0.800E+01, 0.16483000E+01, 0.00000000E+00,
  0.39862800E+02, 0.126E+03, 0.900E+01, 0.16483000E+01, 0.00000000E+00,
  0.30664800E+02, 0.126E+03, 0.100E+02, 0.16483000E+01, 0.00000000E+00,
  0.45354440E+03, 0.126E+03, 0.110E+02, 0.16483000E+01, 0.00000000E+00,
  0.34971160E+03, 0.126E+03, 0.120E+02, 0.16483000E+01, 0.00000000E+00,
  0.32227810E+03, 0.126E+03, 0.130E+02, 0.16483000E+01, 0.00000000E+00,
  0.25376380E+03, 0.126E+03, 0.140E+02, 0.16483000E+01, 0.00000000E+00,
  0.19765690E+03, 0.126E+03, 0.150E+02, 0.16483000E+01, 0.00000000E+00,
  0.16387940E+03, 0.126E+03, 0.160E+02, 0.16483000E+01, 0.00000000E+00,
  0.13373240E+03, 0.126E+03, 0.170E+02, 0.16483000E+01, 0.00000000E+00,
  0.10931550E+03, 0.126E+03, 0.180E+02, 0.16483000E+01, 0.00000000E+00,
  0.74225200E+03, 0.126E+03, 0.190E+02, 0.16483000E+01, 0.00000000E+00,
  0.61392330E+03, 0.126E+03, 0.200E+02, 0.16483000E+01, 0.00000000E+00,
  0.50734010E+03, 0.126E+03, 0.210E+02, 0.16483000E+01, 0.00000000E+00,
  0.48989960E+03, 0.126E+03, 0.220E+02, 0.16483000E+01, 0.00000000E+00,
  0.44862620E+03, 0.126E+03, 0.230E+02, 0.16483000E+01, 0.00000000E+00,
  0.35327090E+03, 0.126E+03, 0.240E+02, 0.16483000E+01, 0.00000000E+00,
  0.38626020E+03, 0.126E+03, 0.250E+02, 0.16483000E+01, 0.00000000E+00,
  0.30304800E+03, 0.126E+03, 0.260E+02, 0.16483000E+01, 0.00000000E+00,
  0.32134480E+03, 0.126E+03, 0.270E+02, 0.16483000E+01, 0.00000000E+00,
  0.33106140E+03, 0.126E+03, 0.280E+02, 0.16483000E+01, 0.00000000E+00,
  0.25370380E+03, 0.126E+03, 0.290E+02, 0.16483000E+01, 0.00000000E+00,
  0.26053410E+03, 0.126E+03, 0.300E+02, 0.16483000E+01, 0.00000000E+00,
  0.30855290E+03, 0.126E+03, 0.310E+02, 0.16483000E+01, 0.00000000E+00,
  0.27197110E+03, 0.126E+03, 0.320E+02, 0.16483000E+01, 0.00000000E+00,
  0.23176180E+03, 0.126E+03, 0.330E+02, 0.16483000E+01, 0.00000000E+00,
  0.20779480E+03, 0.126E+03, 0.340E+02, 0.16483000E+01, 0.00000000E+00,
  0.18168360E+03, 0.126E+03, 0.350E+02, 0.16483000E+01, 0.00000000E+00,
  0.15786610E+03, 0.126E+03, 0.360E+02, 0.16483000E+01, 0.00000000E+00,
  0.83179600E+03, 0.126E+03, 0.370E+02, 0.16483000E+01, 0.00000000E+00,
  0.73123300E+03, 0.126E+03, 0.380E+02, 0.16483000E+01, 0.00000000E+00,
  0.64066410E+03, 0.126E+03, 0.390E+02, 0.16483000E+01, 0.00000000E+00,
  0.57577520E+03, 0.126E+03, 0.400E+02, 0.16483000E+01, 0.00000000E+00,
  0.52495880E+03, 0.126E+03, 0.410E+02, 0.16483000E+01, 0.00000000E+00,
  0.40508170E+03, 0.126E+03, 0.420E+02, 0.16483000E+01, 0.00000000E+00,
  0.45208310E+03, 0.126E+03, 0.430E+02, 0.16483000E+01, 0.00000000E+00,
  0.34423220E+03, 0.126E+03, 0.440E+02, 0.16483000E+01, 0.00000000E+00,
  0.37640450E+03, 0.126E+03, 0.450E+02, 0.16483000E+01, 0.00000000E+00,
  0.34902580E+03, 0.126E+03, 0.460E+02, 0.16483000E+01, 0.00000000E+00,
  0.29090830E+03, 0.126E+03, 0.470E+02, 0.16483000E+01, 0.00000000E+00,
  0.30752090E+03, 0.126E+03, 0.480E+02, 0.16483000E+01, 0.00000000E+00,
  0.38606280E+03, 0.126E+03, 0.490E+02, 0.16483000E+01, 0.00000000E+00,
  0.35691590E+03, 0.126E+03, 0.500E+02, 0.16483000E+01, 0.00000000E+00,
  0.31786240E+03, 0.126E+03, 0.510E+02, 0.16483000E+01, 0.00000000E+00,
  0.29473480E+03, 0.126E+03, 0.520E+02, 0.16483000E+01, 0.00000000E+00,
  0.26629100E+03, 0.126E+03, 0.530E+02, 0.16483000E+01, 0.00000000E+00,
  0.23921900E+03, 0.126E+03, 0.540E+02, 0.16483000E+01, 0.00000000E+00,
  0.10130459E+04, 0.126E+03, 0.550E+02, 0.16483000E+01, 0.00000000E+00,
  0.93186100E+03, 0.126E+03, 0.560E+02, 0.16483000E+01, 0.00000000E+00,
  0.81889940E+03, 0.126E+03, 0.570E+02, 0.16483000E+01, 0.00000000E+00,
  0.37545680E+03, 0.126E+03, 0.580E+02, 0.16483000E+01, 0.27991000E+01,
  0.82577350E+03, 0.126E+03, 0.590E+02, 0.16483000E+01, 0.00000000E+00,
  0.79302390E+03, 0.126E+03, 0.600E+02, 0.16483000E+01, 0.00000000E+00,
  0.77315750E+03, 0.126E+03, 0.610E+02, 0.16483000E+01, 0.00000000E+00,
  0.75488610E+03, 0.126E+03, 0.620E+02, 0.16483000E+01, 0.00000000E+00,
  0.73868360E+03, 0.126E+03, 0.630E+02, 0.16483000E+01, 0.00000000E+00,
  0.58077730E+03, 0.126E+03, 0.640E+02, 0.16483000E+01, 0.00000000E+00,
  0.65347520E+03, 0.126E+03, 0.650E+02, 0.16483000E+01, 0.00000000E+00,
  0.63025330E+03, 0.126E+03, 0.660E+02, 0.16483000E+01, 0.00000000E+00,
  0.66633780E+03, 0.126E+03, 0.670E+02, 0.16483000E+01, 0.00000000E+00,
  0.65221550E+03, 0.126E+03, 0.680E+02, 0.16483000E+01, 0.00000000E+00,
  0.63947820E+03, 0.126E+03, 0.690E+02, 0.16483000E+01, 0.00000000E+00,
  0.63201230E+03, 0.126E+03, 0.700E+02, 0.16483000E+01, 0.00000000E+00,
  0.53244100E+03, 0.126E+03, 0.710E+02, 0.16483000E+01, 0.00000000E+00,
  0.52361220E+03, 0.126E+03, 0.720E+02, 0.16483000E+01, 0.00000000E+00,
  0.47773970E+03, 0.126E+03, 0.730E+02, 0.16483000E+01, 0.00000000E+00,
  0.40318600E+03, 0.126E+03, 0.740E+02, 0.16483000E+01, 0.00000000E+00,
  0.41018490E+03, 0.126E+03, 0.750E+02, 0.16483000E+01, 0.00000000E+00,
  0.37164480E+03, 0.126E+03, 0.760E+02, 0.16483000E+01, 0.00000000E+00,
  0.34026720E+03, 0.126E+03, 0.770E+02, 0.16483000E+01, 0.00000000E+00,
  0.28250560E+03, 0.126E+03, 0.780E+02, 0.16483000E+01, 0.00000000E+00,
  0.26390350E+03, 0.126E+03, 0.790E+02, 0.16483000E+01, 0.00000000E+00,
  0.27150750E+03, 0.126E+03, 0.800E+02, 0.16483000E+01, 0.00000000E+00,
  0.39615750E+03, 0.126E+03, 0.810E+02, 0.16483000E+01, 0.00000000E+00,
  0.38734040E+03, 0.126E+03, 0.820E+02, 0.16483000E+01, 0.00000000E+00,
  0.35575280E+03, 0.126E+03, 0.830E+02, 0.16483000E+01, 0.00000000E+00,
  0.33914780E+03, 0.126E+03, 0.840E+02, 0.16483000E+01, 0.00000000E+00,
  0.31279910E+03, 0.126E+03, 0.850E+02, 0.16483000E+01, 0.00000000E+00,
  0.28650170E+03, 0.126E+03, 0.860E+02, 0.16483000E+01, 0.00000000E+00,
  0.95682050E+03, 0.126E+03, 0.870E+02, 0.16483000E+01, 0.00000000E+00,
  0.92149130E+03, 0.126E+03, 0.880E+02, 0.16483000E+01, 0.00000000E+00,
  0.81480800E+03, 0.126E+03, 0.890E+02, 0.16483000E+01, 0.00000000E+00,
  0.73215470E+03, 0.126E+03, 0.900E+02, 0.16483000E+01, 0.00000000E+00,
  0.72684330E+03, 0.126E+03, 0.910E+02, 0.16483000E+01, 0.00000000E+00,
  0.70377870E+03, 0.126E+03, 0.920E+02, 0.16483000E+01, 0.00000000E+00,
  0.72468840E+03, 0.126E+03, 0.930E+02, 0.16483000E+01, 0.00000000E+00,
  0.70180630E+03, 0.126E+03, 0.940E+02, 0.16483000E+01, 0.00000000E+00,
  0.39274200E+02, 0.126E+03, 0.101E+03, 0.16483000E+01, 0.00000000E+00,
  0.12754920E+03, 0.126E+03, 0.103E+03, 0.16483000E+01, 0.98650000E+00,
  0.16261080E+03, 0.126E+03, 0.104E+03, 0.16483000E+01, 0.98080000E+00,
  0.12411700E+03, 0.126E+03, 0.105E+03, 0.16483000E+01, 0.97060000E+00,
  0.93384800E+02, 0.126E+03, 0.106E+03, 0.16483000E+01, 0.98680000E+00,
  0.64846800E+02, 0.126E+03, 0.107E+03, 0.16483000E+01, 0.99440000E+00,
  0.47181600E+02, 0.126E+03, 0.108E+03, 0.16483000E+01, 0.99250000E+00,
  0.32432100E+02, 0.126E+03, 0.109E+03, 0.16483000E+01, 0.99820000E+00,
  0.18646690E+03, 0.126E+03, 0.111E+03, 0.16483000E+01, 0.96840000E+00,
  0.28833710E+03, 0.126E+03, 0.112E+03, 0.16483000E+01, 0.96280000E+00,
  0.29202470E+03, 0.126E+03, 0.113E+03, 0.16483000E+01, 0.96480000E+00,
  0.23448430E+03, 0.126E+03, 0.114E+03, 0.16483000E+01, 0.95070000E+00,
  0.19184290E+03, 0.126E+03, 0.115E+03, 0.16483000E+01, 0.99470000E+00,
  0.16207500E+03, 0.126E+03, 0.116E+03, 0.16483000E+01, 0.99480000E+00,
  0.13234800E+03, 0.126E+03, 0.117E+03, 0.16483000E+01, 0.99720000E+00,
  0.25675790E+03, 0.126E+03, 0.119E+03, 0.16483000E+01, 0.97670000E+00,
  0.49074810E+03, 0.126E+03, 0.120E+03, 0.16483000E+01, 0.98310000E+00,
  0.25688890E+03, 0.126E+03, 0.121E+03, 0.16483000E+01, 0.18627000E+01,
  0.24796360E+03, 0.126E+03, 0.122E+03, 0.16483000E+01, 0.18299000E+01,
  0.24301480E+03, 0.126E+03, 0.123E+03, 0.16483000E+01, 0.19138000E+01,
  0.24078340E+03, 0.126E+03, 0.124E+03, 0.16483000E+01, 0.18269000E+01,
  0.22153400E+03, 0.126E+03, 0.125E+03, 0.16483000E+01, 0.16406000E+01,
  0.20499250E+03, 0.126E+03, 0.126E+03, 0.16483000E+01, 0.16483000E+01,
  0.23231000E+02, 0.127E+03, 0.100E+01, 0.17149000E+01, 0.91180000E+00,
  0.15354500E+02, 0.127E+03, 0.200E+01, 0.17149000E+01, 0.00000000E+00,
  0.36237460E+03, 0.127E+03, 0.300E+01, 0.17149000E+01, 0.00000000E+00,
  0.20922270E+03, 0.127E+03, 0.400E+01, 0.17149000E+01, 0.00000000E+00,
  0.14074280E+03, 0.127E+03, 0.500E+01, 0.17149000E+01, 0.00000000E+00,
  0.95005100E+02, 0.127E+03, 0.600E+01, 0.17149000E+01, 0.00000000E+00,
  0.66421800E+02, 0.127E+03, 0.700E+01, 0.17149000E+01, 0.00000000E+00,
  0.50301600E+02, 0.127E+03, 0.800E+01, 0.17149000E+01, 0.00000000E+00,
  0.38131300E+02, 0.127E+03, 0.900E+01, 0.17149000E+01, 0.00000000E+00,
  0.29359800E+02, 0.127E+03, 0.100E+02, 0.17149000E+01, 0.00000000E+00,
  0.43337360E+03, 0.127E+03, 0.110E+02, 0.17149000E+01, 0.00000000E+00,
  0.33347670E+03, 0.127E+03, 0.120E+02, 0.17149000E+01, 0.00000000E+00,
  0.30725400E+03, 0.127E+03, 0.130E+02, 0.17149000E+01, 0.00000000E+00,
  0.24191590E+03, 0.127E+03, 0.140E+02, 0.17149000E+01, 0.00000000E+00,
  0.18848520E+03, 0.127E+03, 0.150E+02, 0.17149000E+01, 0.00000000E+00,
  0.15634230E+03, 0.127E+03, 0.160E+02, 0.17149000E+01, 0.00000000E+00,
  0.12765130E+03, 0.127E+03, 0.170E+02, 0.17149000E+01, 0.00000000E+00,
  0.10440910E+03, 0.127E+03, 0.180E+02, 0.17149000E+01, 0.00000000E+00,
  0.71018180E+03, 0.127E+03, 0.190E+02, 0.17149000E+01, 0.00000000E+00,
  0.58595780E+03, 0.127E+03, 0.200E+02, 0.17149000E+01, 0.00000000E+00,
  0.48407230E+03, 0.127E+03, 0.210E+02, 0.17149000E+01, 0.00000000E+00,
  0.46739840E+03, 0.127E+03, 0.220E+02, 0.17149000E+01, 0.00000000E+00,
  0.42799360E+03, 0.127E+03, 0.230E+02, 0.17149000E+01, 0.00000000E+00,
  0.33714360E+03, 0.127E+03, 0.240E+02, 0.17149000E+01, 0.00000000E+00,
  0.36847190E+03, 0.127E+03, 0.250E+02, 0.17149000E+01, 0.00000000E+00,
  0.28919370E+03, 0.127E+03, 0.260E+02, 0.17149000E+01, 0.00000000E+00,
  0.30649680E+03, 0.127E+03, 0.270E+02, 0.17149000E+01, 0.00000000E+00,
  0.31577130E+03, 0.127E+03, 0.280E+02, 0.17149000E+01, 0.00000000E+00,
  0.24210300E+03, 0.127E+03, 0.290E+02, 0.17149000E+01, 0.00000000E+00,
  0.24848550E+03, 0.127E+03, 0.300E+02, 0.17149000E+01, 0.00000000E+00,
  0.29424080E+03, 0.127E+03, 0.310E+02, 0.17149000E+01, 0.00000000E+00,
  0.25932240E+03, 0.127E+03, 0.320E+02, 0.17149000E+01, 0.00000000E+00,
  0.22102330E+03, 0.127E+03, 0.330E+02, 0.17149000E+01, 0.00000000E+00,
  0.19822130E+03, 0.127E+03, 0.340E+02, 0.17149000E+01, 0.00000000E+00,
  0.17337930E+03, 0.127E+03, 0.350E+02, 0.17149000E+01, 0.00000000E+00,
  0.15071900E+03, 0.127E+03, 0.360E+02, 0.17149000E+01, 0.00000000E+00,
  0.79588590E+03, 0.127E+03, 0.370E+02, 0.17149000E+01, 0.00000000E+00,
  0.69807620E+03, 0.127E+03, 0.380E+02, 0.17149000E+01, 0.00000000E+00,
  0.61134030E+03, 0.127E+03, 0.390E+02, 0.17149000E+01, 0.00000000E+00,
  0.54932940E+03, 0.127E+03, 0.400E+02, 0.17149000E+01, 0.00000000E+00,
  0.50083550E+03, 0.127E+03, 0.410E+02, 0.17149000E+01, 0.00000000E+00,
  0.38652450E+03, 0.127E+03, 0.420E+02, 0.17149000E+01, 0.00000000E+00,
  0.43134780E+03, 0.127E+03, 0.430E+02, 0.17149000E+01, 0.00000000E+00,
  0.32850150E+03, 0.127E+03, 0.440E+02, 0.17149000E+01, 0.00000000E+00,
  0.35910570E+03, 0.127E+03, 0.450E+02, 0.17149000E+01, 0.00000000E+00,
  0.33298960E+03, 0.127E+03, 0.460E+02, 0.17149000E+01, 0.00000000E+00,
  0.27768230E+03, 0.127E+03, 0.470E+02, 0.17149000E+01, 0.00000000E+00,
  0.29340740E+03, 0.127E+03, 0.480E+02, 0.17149000E+01, 0.00000000E+00,
  0.36832240E+03, 0.127E+03, 0.490E+02, 0.17149000E+01, 0.00000000E+00,
  0.34042650E+03, 0.127E+03, 0.500E+02, 0.17149000E+01, 0.00000000E+00,
  0.30318560E+03, 0.127E+03, 0.510E+02, 0.17149000E+01, 0.00000000E+00,
  0.28116330E+03, 0.127E+03, 0.520E+02, 0.17149000E+01, 0.00000000E+00,
  0.25408770E+03, 0.127E+03, 0.530E+02, 0.17149000E+01, 0.00000000E+00,
  0.22832560E+03, 0.127E+03, 0.540E+02, 0.17149000E+01, 0.00000000E+00,
  0.96954620E+03, 0.127E+03, 0.550E+02, 0.17149000E+01, 0.00000000E+00,
  0.88993460E+03, 0.127E+03, 0.560E+02, 0.17149000E+01, 0.00000000E+00,
  0.78163500E+03, 0.127E+03, 0.570E+02, 0.17149000E+01, 0.00000000E+00,
  0.35816770E+03, 0.127E+03, 0.580E+02, 0.17149000E+01, 0.27991000E+01,
  0.78858090E+03, 0.127E+03, 0.590E+02, 0.17149000E+01, 0.00000000E+00,
  0.75717110E+03, 0.127E+03, 0.600E+02, 0.17149000E+01, 0.00000000E+00,
  0.73817480E+03, 0.127E+03, 0.610E+02, 0.17149000E+01, 0.00000000E+00,
  0.72070520E+03, 0.127E+03, 0.620E+02, 0.17149000E+01, 0.00000000E+00,
  0.70521290E+03, 0.127E+03, 0.630E+02, 0.17149000E+01, 0.00000000E+00,
  0.55434620E+03, 0.127E+03, 0.640E+02, 0.17149000E+01, 0.00000000E+00,
  0.62444810E+03, 0.127E+03, 0.650E+02, 0.17149000E+01, 0.00000000E+00,
  0.60226720E+03, 0.127E+03, 0.660E+02, 0.17149000E+01, 0.00000000E+00,
  0.63603570E+03, 0.127E+03, 0.670E+02, 0.17149000E+01, 0.00000000E+00,
  0.62253720E+03, 0.127E+03, 0.680E+02, 0.17149000E+01, 0.00000000E+00,
  0.61036000E+03, 0.127E+03, 0.690E+02, 0.17149000E+01, 0.00000000E+00,
  0.60323520E+03, 0.127E+03, 0.700E+02, 0.17149000E+01, 0.00000000E+00,
  0.50816310E+03, 0.127E+03, 0.710E+02, 0.17149000E+01, 0.00000000E+00,
  0.49947010E+03, 0.127E+03, 0.720E+02, 0.17149000E+01, 0.00000000E+00,
  0.45568660E+03, 0.127E+03, 0.730E+02, 0.17149000E+01, 0.00000000E+00,
  0.38467230E+03, 0.127E+03, 0.740E+02, 0.17149000E+01, 0.00000000E+00,
  0.39131100E+03, 0.127E+03, 0.750E+02, 0.17149000E+01, 0.00000000E+00,
  0.35455820E+03, 0.127E+03, 0.760E+02, 0.17149000E+01, 0.00000000E+00,
  0.32464910E+03, 0.127E+03, 0.770E+02, 0.17149000E+01, 0.00000000E+00,
  0.26963380E+03, 0.127E+03, 0.780E+02, 0.17149000E+01, 0.00000000E+00,
  0.25191510E+03, 0.127E+03, 0.790E+02, 0.17149000E+01, 0.00000000E+00,
  0.25913820E+03, 0.127E+03, 0.800E+02, 0.17149000E+01, 0.00000000E+00,
  0.37809130E+03, 0.127E+03, 0.810E+02, 0.17149000E+01, 0.00000000E+00,
  0.36955020E+03, 0.127E+03, 0.820E+02, 0.17149000E+01, 0.00000000E+00,
  0.33939390E+03, 0.127E+03, 0.830E+02, 0.17149000E+01, 0.00000000E+00,
  0.32357100E+03, 0.127E+03, 0.840E+02, 0.17149000E+01, 0.00000000E+00,
  0.29847990E+03, 0.127E+03, 0.850E+02, 0.17149000E+01, 0.00000000E+00,
  0.27345010E+03, 0.127E+03, 0.860E+02, 0.17149000E+01, 0.00000000E+00,
  0.91516100E+03, 0.127E+03, 0.870E+02, 0.17149000E+01, 0.00000000E+00,
  0.87983390E+03, 0.127E+03, 0.880E+02, 0.17149000E+01, 0.00000000E+00,
  0.77761650E+03, 0.127E+03, 0.890E+02, 0.17149000E+01, 0.00000000E+00,
  0.69856190E+03, 0.127E+03, 0.900E+02, 0.17149000E+01, 0.00000000E+00,
  0.69371430E+03, 0.127E+03, 0.910E+02, 0.17149000E+01, 0.00000000E+00,
  0.67170070E+03, 0.127E+03, 0.920E+02, 0.17149000E+01, 0.00000000E+00,
  0.69179850E+03, 0.127E+03, 0.930E+02, 0.17149000E+01, 0.00000000E+00,
  0.66991580E+03, 0.127E+03, 0.940E+02, 0.17149000E+01, 0.00000000E+00,
  0.37449600E+02, 0.127E+03, 0.101E+03, 0.17149000E+01, 0.00000000E+00,
  0.12160370E+03, 0.127E+03, 0.103E+03, 0.17149000E+01, 0.98650000E+00,
  0.15505540E+03, 0.127E+03, 0.104E+03, 0.17149000E+01, 0.98080000E+00,
  0.11835300E+03, 0.127E+03, 0.105E+03, 0.17149000E+01, 0.97060000E+00,
  0.89099200E+02, 0.127E+03, 0.106E+03, 0.17149000E+01, 0.98680000E+00,
  0.61925600E+02, 0.127E+03, 0.107E+03, 0.17149000E+01, 0.99440000E+00,
  0.45100200E+02, 0.127E+03, 0.108E+03, 0.17149000E+01, 0.99250000E+00,
  0.31051600E+02, 0.127E+03, 0.109E+03, 0.17149000E+01, 0.99820000E+00,
  0.17783550E+03, 0.127E+03, 0.111E+03, 0.17149000E+01, 0.96840000E+00,
  0.27498400E+03, 0.127E+03, 0.112E+03, 0.17149000E+01, 0.96280000E+00,
  0.27841730E+03, 0.127E+03, 0.113E+03, 0.17149000E+01, 0.96480000E+00,
  0.22355480E+03, 0.127E+03, 0.114E+03, 0.17149000E+01, 0.95070000E+00,
  0.18295110E+03, 0.127E+03, 0.115E+03, 0.17149000E+01, 0.99470000E+00,
  0.15462430E+03, 0.127E+03, 0.116E+03, 0.17149000E+01, 0.99480000E+00,
  0.12633190E+03, 0.127E+03, 0.117E+03, 0.17149000E+01, 0.99720000E+00,
  0.24501880E+03, 0.127E+03, 0.119E+03, 0.17149000E+01, 0.97670000E+00,
  0.46868990E+03, 0.127E+03, 0.120E+03, 0.17149000E+01, 0.98310000E+00,
  0.24500350E+03, 0.127E+03, 0.121E+03, 0.17149000E+01, 0.18627000E+01,
  0.23653250E+03, 0.127E+03, 0.122E+03, 0.17149000E+01, 0.18299000E+01,
  0.23181800E+03, 0.127E+03, 0.123E+03, 0.17149000E+01, 0.19138000E+01,
  0.22970220E+03, 0.127E+03, 0.124E+03, 0.17149000E+01, 0.18269000E+01,
  0.21130250E+03, 0.127E+03, 0.125E+03, 0.17149000E+01, 0.16406000E+01,
  0.19554300E+03, 0.127E+03, 0.126E+03, 0.17149000E+01, 0.16483000E+01,
  0.18654620E+03, 0.127E+03, 0.127E+03, 0.17149000E+01, 0.17149000E+01,
  0.22682200E+02, 0.128E+03, 0.100E+01, 0.17937000E+01, 0.91180000E+00,
  0.14983300E+02, 0.128E+03, 0.200E+01, 0.17937000E+01, 0.00000000E+00,
  0.35596060E+03, 0.128E+03, 0.300E+01, 0.17937000E+01, 0.00000000E+00,
  0.20490860E+03, 0.128E+03, 0.400E+01, 0.17937000E+01, 0.00000000E+00,
  0.13762540E+03, 0.128E+03, 0.500E+01, 0.17937000E+01, 0.00000000E+00,
  0.92810700E+02, 0.128E+03, 0.600E+01, 0.17937000E+01, 0.00000000E+00,
  0.64851900E+02, 0.128E+03, 0.700E+01, 0.17937000E+01, 0.00000000E+00,
  0.49099600E+02, 0.128E+03, 0.800E+01, 0.17937000E+01, 0.00000000E+00,
  0.37215800E+02, 0.128E+03, 0.900E+01, 0.17937000E+01, 0.00000000E+00,
  0.28655400E+02, 0.128E+03, 0.100E+02, 0.17937000E+01, 0.00000000E+00,
  0.42564550E+03, 0.128E+03, 0.110E+02, 0.17937000E+01, 0.00000000E+00,
  0.32678640E+03, 0.128E+03, 0.120E+02, 0.17937000E+01, 0.00000000E+00,
  0.30082710E+03, 0.128E+03, 0.130E+02, 0.17937000E+01, 0.00000000E+00,
  0.23659520E+03, 0.128E+03, 0.140E+02, 0.17937000E+01, 0.00000000E+00,
  0.18418470E+03, 0.128E+03, 0.150E+02, 0.17937000E+01, 0.00000000E+00,
  0.15270360E+03, 0.128E+03, 0.160E+02, 0.17937000E+01, 0.00000000E+00,
  0.12463170E+03, 0.128E+03, 0.170E+02, 0.17937000E+01, 0.00000000E+00,
  0.10191160E+03, 0.128E+03, 0.180E+02, 0.17937000E+01, 0.00000000E+00,
  0.69776500E+03, 0.128E+03, 0.190E+02, 0.17937000E+01, 0.00000000E+00,
  0.57475220E+03, 0.128E+03, 0.200E+02, 0.17937000E+01, 0.00000000E+00,
  0.47462540E+03, 0.128E+03, 0.210E+02, 0.17937000E+01, 0.00000000E+00,
  0.45811360E+03, 0.128E+03, 0.220E+02, 0.17937000E+01, 0.00000000E+00,
  0.41940370E+03, 0.128E+03, 0.230E+02, 0.17937000E+01, 0.00000000E+00,
  0.33038080E+03, 0.128E+03, 0.240E+02, 0.17937000E+01, 0.00000000E+00,
  0.36096920E+03, 0.128E+03, 0.250E+02, 0.17937000E+01, 0.00000000E+00,
  0.28330110E+03, 0.128E+03, 0.260E+02, 0.17937000E+01, 0.00000000E+00,
  0.30010550E+03, 0.128E+03, 0.270E+02, 0.17937000E+01, 0.00000000E+00,
  0.30925430E+03, 0.128E+03, 0.280E+02, 0.17937000E+01, 0.00000000E+00,
  0.23712000E+03, 0.128E+03, 0.290E+02, 0.17937000E+01, 0.00000000E+00,
  0.24319600E+03, 0.128E+03, 0.300E+02, 0.17937000E+01, 0.00000000E+00,
  0.28800730E+03, 0.128E+03, 0.310E+02, 0.17937000E+01, 0.00000000E+00,
  0.25361340E+03, 0.128E+03, 0.320E+02, 0.17937000E+01, 0.00000000E+00,
  0.21600430E+03, 0.128E+03, 0.330E+02, 0.17937000E+01, 0.00000000E+00,
  0.19364320E+03, 0.128E+03, 0.340E+02, 0.17937000E+01, 0.00000000E+00,
  0.16931330E+03, 0.128E+03, 0.350E+02, 0.17937000E+01, 0.00000000E+00,
  0.14714170E+03, 0.128E+03, 0.360E+02, 0.17937000E+01, 0.00000000E+00,
  0.78184410E+03, 0.128E+03, 0.370E+02, 0.17937000E+01, 0.00000000E+00,
  0.68477150E+03, 0.128E+03, 0.380E+02, 0.17937000E+01, 0.00000000E+00,
  0.59926520E+03, 0.128E+03, 0.390E+02, 0.17937000E+01, 0.00000000E+00,
  0.53824800E+03, 0.128E+03, 0.400E+02, 0.17937000E+01, 0.00000000E+00,
  0.49059730E+03, 0.128E+03, 0.410E+02, 0.17937000E+01, 0.00000000E+00,
  0.37845940E+03, 0.128E+03, 0.420E+02, 0.17937000E+01, 0.00000000E+00,
  0.42241440E+03, 0.128E+03, 0.430E+02, 0.17937000E+01, 0.00000000E+00,
  0.32155060E+03, 0.128E+03, 0.440E+02, 0.17937000E+01, 0.00000000E+00,
  0.35149860E+03, 0.128E+03, 0.450E+02, 0.17937000E+01, 0.00000000E+00,
  0.32588580E+03, 0.128E+03, 0.460E+02, 0.17937000E+01, 0.00000000E+00,
  0.27180880E+03, 0.128E+03, 0.470E+02, 0.17937000E+01, 0.00000000E+00,
  0.28709580E+03, 0.128E+03, 0.480E+02, 0.17937000E+01, 0.00000000E+00,
  0.36057310E+03, 0.128E+03, 0.490E+02, 0.17937000E+01, 0.00000000E+00,
  0.33303010E+03, 0.128E+03, 0.500E+02, 0.17937000E+01, 0.00000000E+00,
  0.29640640E+03, 0.128E+03, 0.510E+02, 0.17937000E+01, 0.00000000E+00,
  0.27477510E+03, 0.128E+03, 0.520E+02, 0.17937000E+01, 0.00000000E+00,
  0.24822370E+03, 0.128E+03, 0.530E+02, 0.17937000E+01, 0.00000000E+00,
  0.22298560E+03, 0.128E+03, 0.540E+02, 0.17937000E+01, 0.00000000E+00,
  0.95234010E+03, 0.128E+03, 0.550E+02, 0.17937000E+01, 0.00000000E+00,
  0.87316220E+03, 0.128E+03, 0.560E+02, 0.17937000E+01, 0.00000000E+00,
  0.76636770E+03, 0.128E+03, 0.570E+02, 0.17937000E+01, 0.00000000E+00,
  0.35020540E+03, 0.128E+03, 0.580E+02, 0.17937000E+01, 0.27991000E+01,
  0.77355490E+03, 0.128E+03, 0.590E+02, 0.17937000E+01, 0.00000000E+00,
  0.74267570E+03, 0.128E+03, 0.600E+02, 0.17937000E+01, 0.00000000E+00,
  0.72402070E+03, 0.128E+03, 0.610E+02, 0.17937000E+01, 0.00000000E+00,
  0.70686710E+03, 0.128E+03, 0.620E+02, 0.17937000E+01, 0.00000000E+00,
  0.69165380E+03, 0.128E+03, 0.630E+02, 0.17937000E+01, 0.00000000E+00,
  0.54327420E+03, 0.128E+03, 0.640E+02, 0.17937000E+01, 0.00000000E+00,
  0.61263290E+03, 0.128E+03, 0.650E+02, 0.17937000E+01, 0.00000000E+00,
  0.59076940E+03, 0.128E+03, 0.660E+02, 0.17937000E+01, 0.00000000E+00,
  0.62369960E+03, 0.128E+03, 0.670E+02, 0.17937000E+01, 0.00000000E+00,
  0.61045110E+03, 0.128E+03, 0.680E+02, 0.17937000E+01, 0.00000000E+00,
  0.59849350E+03, 0.128E+03, 0.690E+02, 0.17937000E+01, 0.00000000E+00,
  0.59152550E+03, 0.128E+03, 0.700E+02, 0.17937000E+01, 0.00000000E+00,
  0.49802530E+03, 0.128E+03, 0.710E+02, 0.17937000E+01, 0.00000000E+00,
  0.48915250E+03, 0.128E+03, 0.720E+02, 0.17937000E+01, 0.00000000E+00,
  0.44609160E+03, 0.128E+03, 0.730E+02, 0.17937000E+01, 0.00000000E+00,
  0.37646650E+03, 0.128E+03, 0.740E+02, 0.17937000E+01, 0.00000000E+00,
  0.38290120E+03, 0.128E+03, 0.750E+02, 0.17937000E+01, 0.00000000E+00,
  0.34682510E+03, 0.128E+03, 0.760E+02, 0.17937000E+01, 0.00000000E+00,
  0.31748840E+03, 0.128E+03, 0.770E+02, 0.17937000E+01, 0.00000000E+00,
  0.26363220E+03, 0.128E+03, 0.780E+02, 0.17937000E+01, 0.00000000E+00,
  0.24629020E+03, 0.128E+03, 0.790E+02, 0.17937000E+01, 0.00000000E+00,
  0.25331490E+03, 0.128E+03, 0.800E+02, 0.17937000E+01, 0.00000000E+00,
  0.37009330E+03, 0.128E+03, 0.810E+02, 0.17937000E+01, 0.00000000E+00,
  0.36153570E+03, 0.128E+03, 0.820E+02, 0.17937000E+01, 0.00000000E+00,
  0.33183930E+03, 0.128E+03, 0.830E+02, 0.17937000E+01, 0.00000000E+00,
  0.31626530E+03, 0.128E+03, 0.840E+02, 0.17937000E+01, 0.00000000E+00,
  0.29163450E+03, 0.128E+03, 0.850E+02, 0.17937000E+01, 0.00000000E+00,
  0.26709740E+03, 0.128E+03, 0.860E+02, 0.17937000E+01, 0.00000000E+00,
  0.89847060E+03, 0.128E+03, 0.870E+02, 0.17937000E+01, 0.00000000E+00,
  0.86294020E+03, 0.128E+03, 0.880E+02, 0.17937000E+01, 0.00000000E+00,
  0.76220730E+03, 0.128E+03, 0.890E+02, 0.17937000E+01, 0.00000000E+00,
  0.68424210E+03, 0.128E+03, 0.900E+02, 0.17937000E+01, 0.00000000E+00,
  0.67974920E+03, 0.128E+03, 0.910E+02, 0.17937000E+01, 0.00000000E+00,
  0.65817270E+03, 0.128E+03, 0.920E+02, 0.17937000E+01, 0.00000000E+00,
  0.67818560E+03, 0.128E+03, 0.930E+02, 0.17937000E+01, 0.00000000E+00,
  0.65668000E+03, 0.128E+03, 0.940E+02, 0.17937000E+01, 0.00000000E+00,
  0.36590100E+02, 0.128E+03, 0.101E+03, 0.17937000E+01, 0.00000000E+00,
  0.11907250E+03, 0.128E+03, 0.103E+03, 0.17937000E+01, 0.98650000E+00,
  0.15177980E+03, 0.128E+03, 0.104E+03, 0.17937000E+01, 0.98080000E+00,
  0.11570000E+03, 0.128E+03, 0.105E+03, 0.17937000E+01, 0.97060000E+00,
  0.87043200E+02, 0.128E+03, 0.106E+03, 0.17937000E+01, 0.98680000E+00,
  0.60460800E+02, 0.128E+03, 0.107E+03, 0.17937000E+01, 0.99440000E+00,
  0.44017300E+02, 0.128E+03, 0.108E+03, 0.17937000E+01, 0.99250000E+00,
  0.30300400E+02, 0.128E+03, 0.109E+03, 0.17937000E+01, 0.99820000E+00,
  0.17420010E+03, 0.128E+03, 0.111E+03, 0.17937000E+01, 0.96840000E+00,
  0.26937790E+03, 0.128E+03, 0.112E+03, 0.17937000E+01, 0.96280000E+00,
  0.27254090E+03, 0.128E+03, 0.113E+03, 0.17937000E+01, 0.96480000E+00,
  0.21860660E+03, 0.128E+03, 0.114E+03, 0.17937000E+01, 0.95070000E+00,
  0.17877350E+03, 0.128E+03, 0.115E+03, 0.17937000E+01, 0.99470000E+00,
  0.15102860E+03, 0.128E+03, 0.116E+03, 0.17937000E+01, 0.99480000E+00,
  0.12334570E+03, 0.128E+03, 0.117E+03, 0.17937000E+01, 0.99720000E+00,
  0.23988490E+03, 0.128E+03, 0.119E+03, 0.17937000E+01, 0.97670000E+00,
  0.45968120E+03, 0.128E+03, 0.120E+03, 0.17937000E+01, 0.98310000E+00,
  0.23965630E+03, 0.128E+03, 0.121E+03, 0.17937000E+01, 0.18627000E+01,
  0.23136310E+03, 0.128E+03, 0.122E+03, 0.17937000E+01, 0.18299000E+01,
  0.22676010E+03, 0.128E+03, 0.123E+03, 0.17937000E+01, 0.19138000E+01,
  0.22471760E+03, 0.128E+03, 0.124E+03, 0.17937000E+01, 0.18269000E+01,
  0.20661260E+03, 0.128E+03, 0.125E+03, 0.17937000E+01, 0.16406000E+01,
  0.19117980E+03, 0.128E+03, 0.126E+03, 0.17937000E+01, 0.16483000E+01,
  0.18238760E+03, 0.128E+03, 0.127E+03, 0.17937000E+01, 0.17149000E+01,
  0.17833110E+03, 0.128E+03, 0.128E+03, 0.17937000E+01, 0.17937000E+01,
  0.22155000E+02, 0.129E+03, 0.100E+01, 0.95760000E+00, 0.91180000E+00,
  0.14514700E+02, 0.129E+03, 0.200E+01, 0.95760000E+00, 0.00000000E+00,
  0.36743080E+03, 0.129E+03, 0.300E+01, 0.95760000E+00, 0.00000000E+00,
  0.20593130E+03, 0.129E+03, 0.400E+01, 0.95760000E+00, 0.00000000E+00,
  0.13637050E+03, 0.129E+03, 0.500E+01, 0.95760000E+00, 0.00000000E+00,
  0.91102500E+02, 0.129E+03, 0.600E+01, 0.95760000E+00, 0.00000000E+00,
  0.63270900E+02, 0.129E+03, 0.700E+01, 0.95760000E+00, 0.00000000E+00,
  0.47723900E+02, 0.129E+03, 0.800E+01, 0.95760000E+00, 0.00000000E+00,
  0.36074900E+02, 0.129E+03, 0.900E+01, 0.95760000E+00, 0.00000000E+00,
  0.27728200E+02, 0.129E+03, 0.100E+02, 0.95760000E+00, 0.00000000E+00,
  0.43871980E+03, 0.129E+03, 0.110E+02, 0.95760000E+00, 0.00000000E+00,
  0.33000180E+03, 0.129E+03, 0.120E+02, 0.95760000E+00, 0.00000000E+00,
  0.30146500E+03, 0.129E+03, 0.130E+02, 0.95760000E+00, 0.00000000E+00,
  0.23475480E+03, 0.129E+03, 0.140E+02, 0.95760000E+00, 0.00000000E+00,
  0.18132670E+03, 0.129E+03, 0.150E+02, 0.95760000E+00, 0.00000000E+00,
  0.14964210E+03, 0.129E+03, 0.160E+02, 0.95760000E+00, 0.00000000E+00,
  0.12163290E+03, 0.129E+03, 0.170E+02, 0.95760000E+00, 0.00000000E+00,
  0.99139800E+02, 0.129E+03, 0.180E+02, 0.95760000E+00, 0.00000000E+00,
  0.72200020E+03, 0.129E+03, 0.190E+02, 0.95760000E+00, 0.00000000E+00,
  0.58537040E+03, 0.129E+03, 0.200E+02, 0.95760000E+00, 0.00000000E+00,
  0.48164720E+03, 0.129E+03, 0.210E+02, 0.95760000E+00, 0.00000000E+00,
  0.46339240E+03, 0.129E+03, 0.220E+02, 0.95760000E+00, 0.00000000E+00,
  0.42341930E+03, 0.129E+03, 0.230E+02, 0.95760000E+00, 0.00000000E+00,
  0.33350140E+03, 0.129E+03, 0.240E+02, 0.95760000E+00, 0.00000000E+00,
  0.36341710E+03, 0.129E+03, 0.250E+02, 0.95760000E+00, 0.00000000E+00,
  0.28510180E+03, 0.129E+03, 0.260E+02, 0.95760000E+00, 0.00000000E+00,
  0.30073560E+03, 0.129E+03, 0.270E+02, 0.95760000E+00, 0.00000000E+00,
  0.31051330E+03, 0.129E+03, 0.280E+02, 0.95760000E+00, 0.00000000E+00,
  0.23812070E+03, 0.129E+03, 0.290E+02, 0.95760000E+00, 0.00000000E+00,
  0.24268930E+03, 0.129E+03, 0.300E+02, 0.95760000E+00, 0.00000000E+00,
  0.28785200E+03, 0.129E+03, 0.310E+02, 0.95760000E+00, 0.00000000E+00,
  0.25153860E+03, 0.129E+03, 0.320E+02, 0.95760000E+00, 0.00000000E+00,
  0.21283460E+03, 0.129E+03, 0.330E+02, 0.95760000E+00, 0.00000000E+00,
  0.19007710E+03, 0.129E+03, 0.340E+02, 0.95760000E+00, 0.00000000E+00,
  0.16558600E+03, 0.129E+03, 0.350E+02, 0.95760000E+00, 0.00000000E+00,
  0.14345250E+03, 0.129E+03, 0.360E+02, 0.95760000E+00, 0.00000000E+00,
  0.80787860E+03, 0.129E+03, 0.370E+02, 0.95760000E+00, 0.00000000E+00,
  0.69786230E+03, 0.129E+03, 0.380E+02, 0.95760000E+00, 0.00000000E+00,
  0.60685850E+03, 0.129E+03, 0.390E+02, 0.95760000E+00, 0.00000000E+00,
  0.54294990E+03, 0.129E+03, 0.400E+02, 0.95760000E+00, 0.00000000E+00,
  0.49363630E+03, 0.129E+03, 0.410E+02, 0.95760000E+00, 0.00000000E+00,
  0.37922990E+03, 0.129E+03, 0.420E+02, 0.95760000E+00, 0.00000000E+00,
  0.42391540E+03, 0.129E+03, 0.430E+02, 0.95760000E+00, 0.00000000E+00,
  0.32125020E+03, 0.129E+03, 0.440E+02, 0.95760000E+00, 0.00000000E+00,
  0.35112220E+03, 0.129E+03, 0.450E+02, 0.95760000E+00, 0.00000000E+00,
  0.32504660E+03, 0.129E+03, 0.460E+02, 0.95760000E+00, 0.00000000E+00,
  0.27146340E+03, 0.129E+03, 0.470E+02, 0.95760000E+00, 0.00000000E+00,
  0.28581800E+03, 0.129E+03, 0.480E+02, 0.95760000E+00, 0.00000000E+00,
  0.36066260E+03, 0.129E+03, 0.490E+02, 0.95760000E+00, 0.00000000E+00,
  0.33100630E+03, 0.129E+03, 0.500E+02, 0.95760000E+00, 0.00000000E+00,
  0.29285890E+03, 0.129E+03, 0.510E+02, 0.95760000E+00, 0.00000000E+00,
  0.27055260E+03, 0.129E+03, 0.520E+02, 0.95760000E+00, 0.00000000E+00,
  0.24354750E+03, 0.129E+03, 0.530E+02, 0.95760000E+00, 0.00000000E+00,
  0.21809290E+03, 0.129E+03, 0.540E+02, 0.95760000E+00, 0.00000000E+00,
  0.98359160E+03, 0.129E+03, 0.550E+02, 0.95760000E+00, 0.00000000E+00,
  0.89168850E+03, 0.129E+03, 0.560E+02, 0.95760000E+00, 0.00000000E+00,
  0.77770700E+03, 0.129E+03, 0.570E+02, 0.95760000E+00, 0.00000000E+00,
  0.34643740E+03, 0.129E+03, 0.580E+02, 0.95760000E+00, 0.27991000E+01,
  0.78837610E+03, 0.129E+03, 0.590E+02, 0.95760000E+00, 0.00000000E+00,
  0.75615770E+03, 0.129E+03, 0.600E+02, 0.95760000E+00, 0.00000000E+00,
  0.73695090E+03, 0.129E+03, 0.610E+02, 0.95760000E+00, 0.00000000E+00,
  0.71931180E+03, 0.129E+03, 0.620E+02, 0.95760000E+00, 0.00000000E+00,
  0.70365920E+03, 0.129E+03, 0.630E+02, 0.95760000E+00, 0.00000000E+00,
  0.54891190E+03, 0.129E+03, 0.640E+02, 0.95760000E+00, 0.00000000E+00,
  0.62523960E+03, 0.129E+03, 0.650E+02, 0.95760000E+00, 0.00000000E+00,
  0.60214160E+03, 0.129E+03, 0.660E+02, 0.95760000E+00, 0.00000000E+00,
  0.63352600E+03, 0.129E+03, 0.670E+02, 0.95760000E+00, 0.00000000E+00,
  0.61995970E+03, 0.129E+03, 0.680E+02, 0.95760000E+00, 0.00000000E+00,
  0.60766330E+03, 0.129E+03, 0.690E+02, 0.95760000E+00, 0.00000000E+00,
  0.60075720E+03, 0.129E+03, 0.700E+02, 0.95760000E+00, 0.00000000E+00,
  0.50338410E+03, 0.129E+03, 0.710E+02, 0.95760000E+00, 0.00000000E+00,
  0.49122120E+03, 0.129E+03, 0.720E+02, 0.95760000E+00, 0.00000000E+00,
  0.44629550E+03, 0.129E+03, 0.730E+02, 0.95760000E+00, 0.00000000E+00,
  0.37560840E+03, 0.129E+03, 0.740E+02, 0.95760000E+00, 0.00000000E+00,
  0.38145840E+03, 0.129E+03, 0.750E+02, 0.95760000E+00, 0.00000000E+00,
  0.34444290E+03, 0.129E+03, 0.760E+02, 0.95760000E+00, 0.00000000E+00,
  0.31453250E+03, 0.129E+03, 0.770E+02, 0.95760000E+00, 0.00000000E+00,
  0.26057850E+03, 0.129E+03, 0.780E+02, 0.95760000E+00, 0.00000000E+00,
  0.24322040E+03, 0.129E+03, 0.790E+02, 0.95760000E+00, 0.00000000E+00,
  0.24982310E+03, 0.129E+03, 0.800E+02, 0.95760000E+00, 0.00000000E+00,
  0.36971340E+03, 0.129E+03, 0.810E+02, 0.95760000E+00, 0.00000000E+00,
  0.35938220E+03, 0.129E+03, 0.820E+02, 0.95760000E+00, 0.00000000E+00,
  0.32809610E+03, 0.129E+03, 0.830E+02, 0.95760000E+00, 0.00000000E+00,
  0.31175430E+03, 0.129E+03, 0.840E+02, 0.95760000E+00, 0.00000000E+00,
  0.28648030E+03, 0.129E+03, 0.850E+02, 0.95760000E+00, 0.00000000E+00,
  0.26159230E+03, 0.129E+03, 0.860E+02, 0.95760000E+00, 0.00000000E+00,
  0.92344480E+03, 0.129E+03, 0.870E+02, 0.95760000E+00, 0.00000000E+00,
  0.87838880E+03, 0.129E+03, 0.880E+02, 0.95760000E+00, 0.00000000E+00,
  0.77137100E+03, 0.129E+03, 0.890E+02, 0.95760000E+00, 0.00000000E+00,
  0.68798510E+03, 0.129E+03, 0.900E+02, 0.95760000E+00, 0.00000000E+00,
  0.68576140E+03, 0.129E+03, 0.910E+02, 0.95760000E+00, 0.00000000E+00,
  0.66390850E+03, 0.129E+03, 0.920E+02, 0.95760000E+00, 0.00000000E+00,
  0.68694090E+03, 0.129E+03, 0.930E+02, 0.95760000E+00, 0.00000000E+00,
  0.66465810E+03, 0.129E+03, 0.940E+02, 0.95760000E+00, 0.00000000E+00,
  0.35987100E+02, 0.129E+03, 0.101E+03, 0.95760000E+00, 0.00000000E+00,
  0.11943970E+03, 0.129E+03, 0.103E+03, 0.95760000E+00, 0.98650000E+00,
  0.15184260E+03, 0.129E+03, 0.104E+03, 0.95760000E+00, 0.98080000E+00,
  0.11434660E+03, 0.129E+03, 0.105E+03, 0.95760000E+00, 0.97060000E+00,
  0.85473100E+02, 0.129E+03, 0.106E+03, 0.95760000E+00, 0.98680000E+00,
  0.58990300E+02, 0.129E+03, 0.107E+03, 0.95760000E+00, 0.99440000E+00,
  0.42745800E+02, 0.129E+03, 0.108E+03, 0.95760000E+00, 0.99250000E+00,
  0.29280800E+02, 0.129E+03, 0.109E+03, 0.95760000E+00, 0.99820000E+00,
  0.17525310E+03, 0.129E+03, 0.111E+03, 0.95760000E+00, 0.96840000E+00,
  0.27127550E+03, 0.129E+03, 0.112E+03, 0.95760000E+00, 0.96280000E+00,
  0.27263840E+03, 0.129E+03, 0.113E+03, 0.95760000E+00, 0.96480000E+00,
  0.21661540E+03, 0.129E+03, 0.114E+03, 0.95760000E+00, 0.95070000E+00,
  0.17596280E+03, 0.129E+03, 0.115E+03, 0.95760000E+00, 0.99470000E+00,
  0.14802440E+03, 0.129E+03, 0.116E+03, 0.95760000E+00, 0.99480000E+00,
  0.12039270E+03, 0.129E+03, 0.117E+03, 0.95760000E+00, 0.99720000E+00,
  0.24017910E+03, 0.129E+03, 0.119E+03, 0.95760000E+00, 0.97670000E+00,
  0.46791560E+03, 0.129E+03, 0.120E+03, 0.95760000E+00, 0.98310000E+00,
  0.23801280E+03, 0.129E+03, 0.121E+03, 0.95760000E+00, 0.18627000E+01,
  0.22972260E+03, 0.129E+03, 0.122E+03, 0.95760000E+00, 0.18299000E+01,
  0.22520200E+03, 0.129E+03, 0.123E+03, 0.95760000E+00, 0.19138000E+01,
  0.22340090E+03, 0.129E+03, 0.124E+03, 0.95760000E+00, 0.18269000E+01,
  0.20444800E+03, 0.129E+03, 0.125E+03, 0.95760000E+00, 0.16406000E+01,
  0.18894450E+03, 0.129E+03, 0.126E+03, 0.95760000E+00, 0.16483000E+01,
  0.18027190E+03, 0.129E+03, 0.127E+03, 0.95760000E+00, 0.17149000E+01,
  0.17633580E+03, 0.129E+03, 0.128E+03, 0.95760000E+00, 0.17937000E+01,
  0.17499690E+03, 0.129E+03, 0.129E+03, 0.95760000E+00, 0.95760000E+00,
  0.21213900E+02, 0.130E+03, 0.100E+01, 0.19419000E+01, 0.91180000E+00,
  0.14118500E+02, 0.130E+03, 0.200E+01, 0.19419000E+01, 0.00000000E+00,
  0.31788260E+03, 0.130E+03, 0.300E+01, 0.19419000E+01, 0.00000000E+00,
  0.18730120E+03, 0.130E+03, 0.400E+01, 0.19419000E+01, 0.00000000E+00,
  0.12724880E+03, 0.130E+03, 0.500E+01, 0.19419000E+01, 0.00000000E+00,
  0.86470900E+02, 0.130E+03, 0.600E+01, 0.19419000E+01, 0.00000000E+00,
  0.60733100E+02, 0.130E+03, 0.700E+01, 0.19419000E+01, 0.00000000E+00,
  0.46135500E+02, 0.130E+03, 0.800E+01, 0.19419000E+01, 0.00000000E+00,
  0.35062900E+02, 0.130E+03, 0.900E+01, 0.19419000E+01, 0.00000000E+00,
  0.27052400E+02, 0.130E+03, 0.100E+02, 0.19419000E+01, 0.00000000E+00,
  0.38065680E+03, 0.130E+03, 0.110E+02, 0.19419000E+01, 0.00000000E+00,
  0.29754400E+03, 0.130E+03, 0.120E+02, 0.19419000E+01, 0.00000000E+00,
  0.27562990E+03, 0.130E+03, 0.130E+02, 0.19419000E+01, 0.00000000E+00,
  0.21852820E+03, 0.130E+03, 0.140E+02, 0.19419000E+01, 0.00000000E+00,
  0.17118890E+03, 0.130E+03, 0.150E+02, 0.19419000E+01, 0.00000000E+00,
  0.14245910E+03, 0.130E+03, 0.160E+02, 0.19419000E+01, 0.00000000E+00,
  0.11666370E+03, 0.130E+03, 0.170E+02, 0.19419000E+01, 0.00000000E+00,
  0.95658600E+02, 0.130E+03, 0.180E+02, 0.19419000E+01, 0.00000000E+00,
  0.62148410E+03, 0.130E+03, 0.190E+02, 0.19419000E+01, 0.00000000E+00,
  0.51951820E+03, 0.130E+03, 0.200E+02, 0.19419000E+01, 0.00000000E+00,
  0.43036750E+03, 0.130E+03, 0.210E+02, 0.19419000E+01, 0.00000000E+00,
  0.41653280E+03, 0.130E+03, 0.220E+02, 0.19419000E+01, 0.00000000E+00,
  0.38196290E+03, 0.130E+03, 0.230E+02, 0.19419000E+01, 0.00000000E+00,
  0.30093230E+03, 0.130E+03, 0.240E+02, 0.19419000E+01, 0.00000000E+00,
  0.32951960E+03, 0.130E+03, 0.250E+02, 0.19419000E+01, 0.00000000E+00,
  0.25872900E+03, 0.130E+03, 0.260E+02, 0.19419000E+01, 0.00000000E+00,
  0.27503810E+03, 0.130E+03, 0.270E+02, 0.19419000E+01, 0.00000000E+00,
  0.28296560E+03, 0.130E+03, 0.280E+02, 0.19419000E+01, 0.00000000E+00,
  0.21695700E+03, 0.130E+03, 0.290E+02, 0.19419000E+01, 0.00000000E+00,
  0.22366220E+03, 0.130E+03, 0.300E+02, 0.19419000E+01, 0.00000000E+00,
  0.26447240E+03, 0.130E+03, 0.310E+02, 0.19419000E+01, 0.00000000E+00,
  0.23434070E+03, 0.130E+03, 0.320E+02, 0.19419000E+01, 0.00000000E+00,
  0.20064080E+03, 0.130E+03, 0.330E+02, 0.19419000E+01, 0.00000000E+00,
  0.18041890E+03, 0.130E+03, 0.340E+02, 0.19419000E+01, 0.00000000E+00,
  0.15822130E+03, 0.130E+03, 0.350E+02, 0.19419000E+01, 0.00000000E+00,
  0.13785900E+03, 0.130E+03, 0.360E+02, 0.19419000E+01, 0.00000000E+00,
  0.69720120E+03, 0.130E+03, 0.370E+02, 0.19419000E+01, 0.00000000E+00,
  0.61859280E+03, 0.130E+03, 0.380E+02, 0.19419000E+01, 0.00000000E+00,
  0.54431400E+03, 0.130E+03, 0.390E+02, 0.19419000E+01, 0.00000000E+00,
  0.49050970E+03, 0.130E+03, 0.400E+02, 0.19419000E+01, 0.00000000E+00,
  0.44803280E+03, 0.130E+03, 0.410E+02, 0.19419000E+01, 0.00000000E+00,
  0.34683870E+03, 0.130E+03, 0.420E+02, 0.19419000E+01, 0.00000000E+00,
  0.38662560E+03, 0.130E+03, 0.430E+02, 0.19419000E+01, 0.00000000E+00,
  0.29543070E+03, 0.130E+03, 0.440E+02, 0.19419000E+01, 0.00000000E+00,
  0.32298310E+03, 0.130E+03, 0.450E+02, 0.19419000E+01, 0.00000000E+00,
  0.29983170E+03, 0.130E+03, 0.460E+02, 0.19419000E+01, 0.00000000E+00,
  0.24983480E+03, 0.130E+03, 0.470E+02, 0.19419000E+01, 0.00000000E+00,
  0.26457160E+03, 0.130E+03, 0.480E+02, 0.19419000E+01, 0.00000000E+00,
  0.33095850E+03, 0.130E+03, 0.490E+02, 0.19419000E+01, 0.00000000E+00,
  0.30726350E+03, 0.130E+03, 0.500E+02, 0.19419000E+01, 0.00000000E+00,
  0.27478160E+03, 0.130E+03, 0.510E+02, 0.19419000E+01, 0.00000000E+00,
  0.25542890E+03, 0.130E+03, 0.520E+02, 0.19419000E+01, 0.00000000E+00,
  0.23140060E+03, 0.130E+03, 0.530E+02, 0.19419000E+01, 0.00000000E+00,
  0.20840550E+03, 0.130E+03, 0.540E+02, 0.19419000E+01, 0.00000000E+00,
  0.84934460E+03, 0.130E+03, 0.550E+02, 0.19419000E+01, 0.00000000E+00,
  0.78727710E+03, 0.130E+03, 0.560E+02, 0.19419000E+01, 0.00000000E+00,
  0.69479590E+03, 0.130E+03, 0.570E+02, 0.19419000E+01, 0.00000000E+00,
  0.32433650E+03, 0.130E+03, 0.580E+02, 0.19419000E+01, 0.27991000E+01,
  0.69872430E+03, 0.130E+03, 0.590E+02, 0.19419000E+01, 0.00000000E+00,
  0.67147320E+03, 0.130E+03, 0.600E+02, 0.19419000E+01, 0.00000000E+00,
  0.65477760E+03, 0.130E+03, 0.610E+02, 0.19419000E+01, 0.00000000E+00,
  0.63940750E+03, 0.130E+03, 0.620E+02, 0.19419000E+01, 0.00000000E+00,
  0.62578200E+03, 0.130E+03, 0.630E+02, 0.19419000E+01, 0.00000000E+00,
  0.49442430E+03, 0.130E+03, 0.640E+02, 0.19419000E+01, 0.00000000E+00,
  0.55258030E+03, 0.130E+03, 0.650E+02, 0.19419000E+01, 0.00000000E+00,
  0.53339380E+03, 0.130E+03, 0.660E+02, 0.19419000E+01, 0.00000000E+00,
  0.56508580E+03, 0.130E+03, 0.670E+02, 0.19419000E+01, 0.00000000E+00,
  0.55316870E+03, 0.130E+03, 0.680E+02, 0.19419000E+01, 0.00000000E+00,
  0.54245160E+03, 0.130E+03, 0.690E+02, 0.19419000E+01, 0.00000000E+00,
  0.53600770E+03, 0.130E+03, 0.700E+02, 0.19419000E+01, 0.00000000E+00,
  0.45307620E+03, 0.130E+03, 0.710E+02, 0.19419000E+01, 0.00000000E+00,
  0.44744320E+03, 0.130E+03, 0.720E+02, 0.19419000E+01, 0.00000000E+00,
  0.40933690E+03, 0.130E+03, 0.730E+02, 0.19419000E+01, 0.00000000E+00,
  0.34623600E+03, 0.130E+03, 0.740E+02, 0.19419000E+01, 0.00000000E+00,
  0.35258880E+03, 0.130E+03, 0.750E+02, 0.19419000E+01, 0.00000000E+00,
  0.32019590E+03, 0.130E+03, 0.760E+02, 0.19419000E+01, 0.00000000E+00,
  0.29371130E+03, 0.130E+03, 0.770E+02, 0.19419000E+01, 0.00000000E+00,
  0.24437210E+03, 0.130E+03, 0.780E+02, 0.19419000E+01, 0.00000000E+00,
  0.22847850E+03, 0.130E+03, 0.790E+02, 0.19419000E+01, 0.00000000E+00,
  0.23524690E+03, 0.130E+03, 0.800E+02, 0.19419000E+01, 0.00000000E+00,
  0.34006610E+03, 0.130E+03, 0.810E+02, 0.19419000E+01, 0.00000000E+00,
  0.33355770E+03, 0.130E+03, 0.820E+02, 0.19419000E+01, 0.00000000E+00,
  0.30748710E+03, 0.130E+03, 0.830E+02, 0.19419000E+01, 0.00000000E+00,
  0.29376220E+03, 0.130E+03, 0.840E+02, 0.19419000E+01, 0.00000000E+00,
  0.27163520E+03, 0.130E+03, 0.850E+02, 0.19419000E+01, 0.00000000E+00,
  0.24938090E+03, 0.130E+03, 0.860E+02, 0.19419000E+01, 0.00000000E+00,
  0.80499020E+03, 0.130E+03, 0.870E+02, 0.19419000E+01, 0.00000000E+00,
  0.78026750E+03, 0.130E+03, 0.880E+02, 0.19419000E+01, 0.00000000E+00,
  0.69268280E+03, 0.130E+03, 0.890E+02, 0.19419000E+01, 0.00000000E+00,
  0.62529330E+03, 0.130E+03, 0.900E+02, 0.19419000E+01, 0.00000000E+00,
  0.61943840E+03, 0.130E+03, 0.910E+02, 0.19419000E+01, 0.00000000E+00,
  0.59985590E+03, 0.130E+03, 0.920E+02, 0.19419000E+01, 0.00000000E+00,
  0.61596070E+03, 0.130E+03, 0.930E+02, 0.19419000E+01, 0.00000000E+00,
  0.59681690E+03, 0.130E+03, 0.940E+02, 0.19419000E+01, 0.00000000E+00,
  0.34031200E+02, 0.130E+03, 0.101E+03, 0.19419000E+01, 0.00000000E+00,
  0.10901270E+03, 0.130E+03, 0.103E+03, 0.19419000E+01, 0.98650000E+00,
  0.13924200E+03, 0.130E+03, 0.104E+03, 0.19419000E+01, 0.98080000E+00,
  0.10720260E+03, 0.130E+03, 0.105E+03, 0.19419000E+01, 0.97060000E+00,
  0.81068600E+02, 0.130E+03, 0.106E+03, 0.19419000E+01, 0.98680000E+00,
  0.56614000E+02, 0.130E+03, 0.107E+03, 0.19419000E+01, 0.99440000E+00,
  0.41386200E+02, 0.130E+03, 0.108E+03, 0.19419000E+01, 0.99250000E+00,
  0.28629100E+02, 0.130E+03, 0.109E+03, 0.19419000E+01, 0.99820000E+00,
  0.15912280E+03, 0.130E+03, 0.111E+03, 0.19419000E+01, 0.96840000E+00,
  0.24580540E+03, 0.130E+03, 0.112E+03, 0.19419000E+01, 0.96280000E+00,
  0.25007300E+03, 0.130E+03, 0.113E+03, 0.19419000E+01, 0.96480000E+00,
  0.20213060E+03, 0.130E+03, 0.114E+03, 0.19419000E+01, 0.95070000E+00,
  0.16618870E+03, 0.130E+03, 0.115E+03, 0.19419000E+01, 0.99470000E+00,
  0.14088040E+03, 0.130E+03, 0.116E+03, 0.19419000E+01, 0.99480000E+00,
  0.11545010E+03, 0.130E+03, 0.117E+03, 0.19419000E+01, 0.99720000E+00,
  0.21998520E+03, 0.130E+03, 0.119E+03, 0.19419000E+01, 0.97670000E+00,
  0.41556380E+03, 0.130E+03, 0.120E+03, 0.19419000E+01, 0.98310000E+00,
  0.22124670E+03, 0.130E+03, 0.121E+03, 0.19419000E+01, 0.18627000E+01,
  0.21361910E+03, 0.130E+03, 0.122E+03, 0.19419000E+01, 0.18299000E+01,
  0.20934280E+03, 0.130E+03, 0.123E+03, 0.19419000E+01, 0.19138000E+01,
  0.20729260E+03, 0.130E+03, 0.124E+03, 0.19419000E+01, 0.18269000E+01,
  0.19131250E+03, 0.130E+03, 0.125E+03, 0.19419000E+01, 0.16406000E+01,
  0.17720340E+03, 0.130E+03, 0.126E+03, 0.19419000E+01, 0.16483000E+01,
  0.16904610E+03, 0.130E+03, 0.127E+03, 0.19419000E+01, 0.17149000E+01,
  0.16523610E+03, 0.130E+03, 0.128E+03, 0.19419000E+01, 0.17937000E+01,
  0.16292360E+03, 0.130E+03, 0.129E+03, 0.19419000E+01, 0.95760000E+00,
  0.15345280E+03, 0.130E+03, 0.130E+03, 0.19419000E+01, 0.19419000E+01,
  0.33251500E+02, 0.131E+03, 0.100E+01, 0.96010000E+00, 0.91180000E+00,
  0.20987400E+02, 0.131E+03, 0.200E+01, 0.96010000E+00, 0.00000000E+00,
  0.60281040E+03, 0.131E+03, 0.300E+01, 0.96010000E+00, 0.00000000E+00,
  0.32666720E+03, 0.131E+03, 0.400E+01, 0.96010000E+00, 0.00000000E+00,
  0.21127560E+03, 0.131E+03, 0.500E+01, 0.96010000E+00, 0.00000000E+00,
  0.13814970E+03, 0.131E+03, 0.600E+01, 0.96010000E+00, 0.00000000E+00,
  0.94132900E+02, 0.131E+03, 0.700E+01, 0.96010000E+00, 0.00000000E+00,
  0.69903900E+02, 0.131E+03, 0.800E+01, 0.96010000E+00, 0.00000000E+00,
  0.52047600E+02, 0.131E+03, 0.900E+01, 0.96010000E+00, 0.00000000E+00,
  0.39458700E+02, 0.131E+03, 0.100E+02, 0.96010000E+00, 0.00000000E+00,
  0.71775310E+03, 0.131E+03, 0.110E+02, 0.96010000E+00, 0.00000000E+00,
  0.52642360E+03, 0.131E+03, 0.120E+02, 0.96010000E+00, 0.00000000E+00,
  0.47573180E+03, 0.131E+03, 0.130E+02, 0.96010000E+00, 0.00000000E+00,
  0.36461100E+03, 0.131E+03, 0.140E+02, 0.96010000E+00, 0.00000000E+00,
  0.27735230E+03, 0.131E+03, 0.150E+02, 0.96010000E+00, 0.00000000E+00,
  0.22627960E+03, 0.131E+03, 0.160E+02, 0.96010000E+00, 0.00000000E+00,
  0.18171780E+03, 0.131E+03, 0.170E+02, 0.96010000E+00, 0.00000000E+00,
  0.14638550E+03, 0.131E+03, 0.180E+02, 0.96010000E+00, 0.00000000E+00,
  0.11848327E+04, 0.131E+03, 0.190E+02, 0.96010000E+00, 0.00000000E+00,
  0.94258280E+03, 0.131E+03, 0.200E+02, 0.96010000E+00, 0.00000000E+00,
  0.77197630E+03, 0.131E+03, 0.210E+02, 0.96010000E+00, 0.00000000E+00,
  0.73902810E+03, 0.131E+03, 0.220E+02, 0.96010000E+00, 0.00000000E+00,
  0.67328230E+03, 0.131E+03, 0.230E+02, 0.96010000E+00, 0.00000000E+00,
  0.52900060E+03, 0.131E+03, 0.240E+02, 0.96010000E+00, 0.00000000E+00,
  0.57532290E+03, 0.131E+03, 0.250E+02, 0.96010000E+00, 0.00000000E+00,
  0.44990400E+03, 0.131E+03, 0.260E+02, 0.96010000E+00, 0.00000000E+00,
  0.47264010E+03, 0.131E+03, 0.270E+02, 0.96010000E+00, 0.00000000E+00,
  0.48954990E+03, 0.131E+03, 0.280E+02, 0.96010000E+00, 0.00000000E+00,
  0.37425370E+03, 0.131E+03, 0.290E+02, 0.96010000E+00, 0.00000000E+00,
  0.37873290E+03, 0.131E+03, 0.300E+02, 0.96010000E+00, 0.00000000E+00,
  0.45140030E+03, 0.131E+03, 0.310E+02, 0.96010000E+00, 0.00000000E+00,
  0.38973700E+03, 0.131E+03, 0.320E+02, 0.96010000E+00, 0.00000000E+00,
  0.32572680E+03, 0.131E+03, 0.330E+02, 0.96010000E+00, 0.00000000E+00,
  0.28839340E+03, 0.131E+03, 0.340E+02, 0.96010000E+00, 0.00000000E+00,
  0.24882110E+03, 0.131E+03, 0.350E+02, 0.96010000E+00, 0.00000000E+00,
  0.21348210E+03, 0.131E+03, 0.360E+02, 0.96010000E+00, 0.00000000E+00,
  0.13227322E+04, 0.131E+03, 0.370E+02, 0.96010000E+00, 0.00000000E+00,
  0.11239167E+04, 0.131E+03, 0.380E+02, 0.96010000E+00, 0.00000000E+00,
  0.96907770E+03, 0.131E+03, 0.390E+02, 0.96010000E+00, 0.00000000E+00,
  0.86203630E+03, 0.131E+03, 0.400E+02, 0.96010000E+00, 0.00000000E+00,
  0.78048050E+03, 0.131E+03, 0.410E+02, 0.96010000E+00, 0.00000000E+00,
  0.59457650E+03, 0.131E+03, 0.420E+02, 0.96010000E+00, 0.00000000E+00,
  0.66676010E+03, 0.131E+03, 0.430E+02, 0.96010000E+00, 0.00000000E+00,
  0.50051620E+03, 0.131E+03, 0.440E+02, 0.96010000E+00, 0.00000000E+00,
  0.54783460E+03, 0.131E+03, 0.450E+02, 0.96010000E+00, 0.00000000E+00,
  0.50566980E+03, 0.131E+03, 0.460E+02, 0.96010000E+00, 0.00000000E+00,
  0.42174200E+03, 0.131E+03, 0.470E+02, 0.96010000E+00, 0.00000000E+00,
  0.44286390E+03, 0.131E+03, 0.480E+02, 0.96010000E+00, 0.00000000E+00,
  0.56415640E+03, 0.131E+03, 0.490E+02, 0.96010000E+00, 0.00000000E+00,
  0.51303150E+03, 0.131E+03, 0.500E+02, 0.96010000E+00, 0.00000000E+00,
  0.44930060E+03, 0.131E+03, 0.510E+02, 0.96010000E+00, 0.00000000E+00,
  0.41227930E+03, 0.131E+03, 0.520E+02, 0.96010000E+00, 0.00000000E+00,
  0.36821830E+03, 0.131E+03, 0.530E+02, 0.96010000E+00, 0.00000000E+00,
  0.32708380E+03, 0.131E+03, 0.540E+02, 0.96010000E+00, 0.00000000E+00,
  0.16098951E+04, 0.131E+03, 0.550E+02, 0.96010000E+00, 0.00000000E+00,
  0.14393610E+04, 0.131E+03, 0.560E+02, 0.96010000E+00, 0.00000000E+00,
  0.12450382E+04, 0.131E+03, 0.570E+02, 0.96010000E+00, 0.00000000E+00,
  0.53206830E+03, 0.131E+03, 0.580E+02, 0.96010000E+00, 0.27991000E+01,
  0.12682581E+04, 0.131E+03, 0.590E+02, 0.96010000E+00, 0.00000000E+00,
  0.12147867E+04, 0.131E+03, 0.600E+02, 0.96010000E+00, 0.00000000E+00,
  0.11834931E+04, 0.131E+03, 0.610E+02, 0.96010000E+00, 0.00000000E+00,
  0.11548172E+04, 0.131E+03, 0.620E+02, 0.96010000E+00, 0.00000000E+00,
  0.11293623E+04, 0.131E+03, 0.630E+02, 0.96010000E+00, 0.00000000E+00,
  0.87169660E+03, 0.131E+03, 0.640E+02, 0.96010000E+00, 0.00000000E+00,
  0.10061273E+04, 0.131E+03, 0.650E+02, 0.96010000E+00, 0.00000000E+00,
  0.96741930E+03, 0.131E+03, 0.660E+02, 0.96010000E+00, 0.00000000E+00,
  0.10147443E+04, 0.131E+03, 0.670E+02, 0.96010000E+00, 0.00000000E+00,
  0.99283980E+03, 0.131E+03, 0.680E+02, 0.96010000E+00, 0.00000000E+00,
  0.97287530E+03, 0.131E+03, 0.690E+02, 0.96010000E+00, 0.00000000E+00,
  0.96226810E+03, 0.131E+03, 0.700E+02, 0.96010000E+00, 0.00000000E+00,
  0.80056070E+03, 0.131E+03, 0.710E+02, 0.96010000E+00, 0.00000000E+00,
  0.77479490E+03, 0.131E+03, 0.720E+02, 0.96010000E+00, 0.00000000E+00,
  0.69954820E+03, 0.131E+03, 0.730E+02, 0.96010000E+00, 0.00000000E+00,
  0.58500690E+03, 0.131E+03, 0.740E+02, 0.96010000E+00, 0.00000000E+00,
  0.59290660E+03, 0.131E+03, 0.750E+02, 0.96010000E+00, 0.00000000E+00,
  0.53219500E+03, 0.131E+03, 0.760E+02, 0.96010000E+00, 0.00000000E+00,
  0.48350900E+03, 0.131E+03, 0.770E+02, 0.96010000E+00, 0.00000000E+00,
  0.39773910E+03, 0.131E+03, 0.780E+02, 0.96010000E+00, 0.00000000E+00,
  0.37015170E+03, 0.131E+03, 0.790E+02, 0.96010000E+00, 0.00000000E+00,
  0.37970920E+03, 0.131E+03, 0.800E+02, 0.96010000E+00, 0.00000000E+00,
  0.57562810E+03, 0.131E+03, 0.810E+02, 0.96010000E+00, 0.00000000E+00,
  0.55583070E+03, 0.131E+03, 0.820E+02, 0.96010000E+00, 0.00000000E+00,
  0.50298850E+03, 0.131E+03, 0.830E+02, 0.96010000E+00, 0.00000000E+00,
  0.47531340E+03, 0.131E+03, 0.840E+02, 0.96010000E+00, 0.00000000E+00,
  0.43366250E+03, 0.131E+03, 0.850E+02, 0.96010000E+00, 0.00000000E+00,
  0.39318500E+03, 0.131E+03, 0.860E+02, 0.96010000E+00, 0.00000000E+00,
  0.15014541E+04, 0.131E+03, 0.870E+02, 0.96010000E+00, 0.00000000E+00,
  0.14115217E+04, 0.131E+03, 0.880E+02, 0.96010000E+00, 0.00000000E+00,
  0.12297307E+04, 0.131E+03, 0.890E+02, 0.96010000E+00, 0.00000000E+00,
  0.10857394E+04, 0.131E+03, 0.900E+02, 0.96010000E+00, 0.00000000E+00,
  0.10865380E+04, 0.131E+03, 0.910E+02, 0.96010000E+00, 0.00000000E+00,
  0.10514942E+04, 0.131E+03, 0.920E+02, 0.96010000E+00, 0.00000000E+00,
  0.10941031E+04, 0.131E+03, 0.930E+02, 0.96010000E+00, 0.00000000E+00,
  0.10575095E+04, 0.131E+03, 0.940E+02, 0.96010000E+00, 0.00000000E+00,
  0.54991900E+02, 0.131E+03, 0.101E+03, 0.96010000E+00, 0.00000000E+00,
  0.18876220E+03, 0.131E+03, 0.103E+03, 0.96010000E+00, 0.98650000E+00,
  0.23890680E+03, 0.131E+03, 0.104E+03, 0.96010000E+00, 0.98080000E+00,
  0.17609760E+03, 0.131E+03, 0.105E+03, 0.96010000E+00, 0.97060000E+00,
  0.12956700E+03, 0.131E+03, 0.106E+03, 0.96010000E+00, 0.98680000E+00,
  0.87664500E+02, 0.131E+03, 0.107E+03, 0.96010000E+00, 0.99440000E+00,
  0.62352200E+02, 0.131E+03, 0.108E+03, 0.96010000E+00, 0.99250000E+00,
  0.41590900E+02, 0.131E+03, 0.109E+03, 0.96010000E+00, 0.99820000E+00,
  0.27751430E+03, 0.131E+03, 0.111E+03, 0.96010000E+00, 0.96840000E+00,
  0.43082970E+03, 0.131E+03, 0.112E+03, 0.96010000E+00, 0.96280000E+00,
  0.42895210E+03, 0.131E+03, 0.113E+03, 0.96010000E+00, 0.96480000E+00,
  0.33552060E+03, 0.131E+03, 0.114E+03, 0.96010000E+00, 0.95070000E+00,
  0.26893700E+03, 0.131E+03, 0.115E+03, 0.96010000E+00, 0.99470000E+00,
  0.22384530E+03, 0.131E+03, 0.116E+03, 0.96010000E+00, 0.99480000E+00,
  0.17986830E+03, 0.131E+03, 0.117E+03, 0.96010000E+00, 0.99720000E+00,
  0.37584950E+03, 0.131E+03, 0.119E+03, 0.96010000E+00, 0.97670000E+00,
  0.75181440E+03, 0.131E+03, 0.120E+03, 0.96010000E+00, 0.98310000E+00,
  0.36854170E+03, 0.131E+03, 0.121E+03, 0.96010000E+00, 0.18627000E+01,
  0.35534980E+03, 0.131E+03, 0.122E+03, 0.96010000E+00, 0.18299000E+01,
  0.34832930E+03, 0.131E+03, 0.123E+03, 0.96010000E+00, 0.19138000E+01,
  0.34597960E+03, 0.131E+03, 0.124E+03, 0.96010000E+00, 0.18269000E+01,
  0.31442440E+03, 0.131E+03, 0.125E+03, 0.96010000E+00, 0.16406000E+01,
  0.28975880E+03, 0.131E+03, 0.126E+03, 0.96010000E+00, 0.16483000E+01,
  0.27631300E+03, 0.131E+03, 0.127E+03, 0.96010000E+00, 0.17149000E+01,
  0.27040230E+03, 0.131E+03, 0.128E+03, 0.96010000E+00, 0.17937000E+01,
  0.26973440E+03, 0.131E+03, 0.129E+03, 0.96010000E+00, 0.95760000E+00,
  0.24870030E+03, 0.131E+03, 0.130E+03, 0.96010000E+00, 0.19419000E+01,
  0.42164970E+03, 0.131E+03, 0.131E+03, 0.96010000E+00, 0.96010000E+00,
  0.29952700E+02, 0.132E+03, 0.100E+01, 0.94340000E+00, 0.91180000E+00,
  0.19376100E+02, 0.132E+03, 0.200E+01, 0.94340000E+00, 0.00000000E+00,
  0.48401650E+03, 0.132E+03, 0.300E+01, 0.94340000E+00, 0.00000000E+00,
  0.27657170E+03, 0.132E+03, 0.400E+01, 0.94340000E+00, 0.00000000E+00,
  0.18420550E+03, 0.132E+03, 0.500E+01, 0.94340000E+00, 0.00000000E+00,
  0.12305740E+03, 0.132E+03, 0.600E+01, 0.94340000E+00, 0.00000000E+00,
  0.85162100E+02, 0.132E+03, 0.700E+01, 0.94340000E+00, 0.00000000E+00,
  0.63924500E+02, 0.132E+03, 0.800E+01, 0.94340000E+00, 0.00000000E+00,
  0.48023300E+02, 0.132E+03, 0.900E+01, 0.94340000E+00, 0.00000000E+00,
  0.36661500E+02, 0.132E+03, 0.100E+02, 0.94340000E+00, 0.00000000E+00,
  0.57808820E+03, 0.132E+03, 0.110E+02, 0.94340000E+00, 0.00000000E+00,
  0.44152390E+03, 0.132E+03, 0.120E+02, 0.94340000E+00, 0.00000000E+00,
  0.40516110E+03, 0.132E+03, 0.130E+02, 0.94340000E+00, 0.00000000E+00,
  0.31697000E+03, 0.132E+03, 0.140E+02, 0.94340000E+00, 0.00000000E+00,
  0.24526830E+03, 0.132E+03, 0.150E+02, 0.94340000E+00, 0.00000000E+00,
  0.20228630E+03, 0.132E+03, 0.160E+02, 0.94340000E+00, 0.00000000E+00,
  0.16412660E+03, 0.132E+03, 0.170E+02, 0.94340000E+00, 0.00000000E+00,
  0.13337940E+03, 0.132E+03, 0.180E+02, 0.94340000E+00, 0.00000000E+00,
  0.94657560E+03, 0.132E+03, 0.190E+02, 0.94340000E+00, 0.00000000E+00,
  0.77753610E+03, 0.132E+03, 0.200E+02, 0.94340000E+00, 0.00000000E+00,
  0.64140640E+03, 0.132E+03, 0.210E+02, 0.94340000E+00, 0.00000000E+00,
  0.61804010E+03, 0.132E+03, 0.220E+02, 0.94340000E+00, 0.00000000E+00,
  0.56526390E+03, 0.132E+03, 0.230E+02, 0.94340000E+00, 0.00000000E+00,
  0.44441960E+03, 0.132E+03, 0.240E+02, 0.94340000E+00, 0.00000000E+00,
  0.48576480E+03, 0.132E+03, 0.250E+02, 0.94340000E+00, 0.00000000E+00,
  0.38038530E+03, 0.132E+03, 0.260E+02, 0.94340000E+00, 0.00000000E+00,
  0.40291460E+03, 0.132E+03, 0.270E+02, 0.94340000E+00, 0.00000000E+00,
  0.41564390E+03, 0.132E+03, 0.280E+02, 0.94340000E+00, 0.00000000E+00,
  0.31786240E+03, 0.132E+03, 0.290E+02, 0.94340000E+00, 0.00000000E+00,
  0.32569280E+03, 0.132E+03, 0.300E+02, 0.94340000E+00, 0.00000000E+00,
  0.38671290E+03, 0.132E+03, 0.310E+02, 0.94340000E+00, 0.00000000E+00,
  0.33924040E+03, 0.132E+03, 0.320E+02, 0.94340000E+00, 0.00000000E+00,
  0.28758470E+03, 0.132E+03, 0.330E+02, 0.94340000E+00, 0.00000000E+00,
  0.25685170E+03, 0.132E+03, 0.340E+02, 0.94340000E+00, 0.00000000E+00,
  0.22357440E+03, 0.132E+03, 0.350E+02, 0.94340000E+00, 0.00000000E+00,
  0.19336340E+03, 0.132E+03, 0.360E+02, 0.94340000E+00, 0.00000000E+00,
  0.10596044E+04, 0.132E+03, 0.370E+02, 0.94340000E+00, 0.00000000E+00,
  0.92600250E+03, 0.132E+03, 0.380E+02, 0.94340000E+00, 0.00000000E+00,
  0.80859910E+03, 0.132E+03, 0.390E+02, 0.94340000E+00, 0.00000000E+00,
  0.72498050E+03, 0.132E+03, 0.400E+02, 0.94340000E+00, 0.00000000E+00,
  0.65980390E+03, 0.132E+03, 0.410E+02, 0.94340000E+00, 0.00000000E+00,
  0.50715030E+03, 0.132E+03, 0.420E+02, 0.94340000E+00, 0.00000000E+00,
  0.56682940E+03, 0.132E+03, 0.430E+02, 0.94340000E+00, 0.00000000E+00,
  0.42969960E+03, 0.132E+03, 0.440E+02, 0.94340000E+00, 0.00000000E+00,
  0.47030780E+03, 0.132E+03, 0.450E+02, 0.94340000E+00, 0.00000000E+00,
  0.43552680E+03, 0.132E+03, 0.460E+02, 0.94340000E+00, 0.00000000E+00,
  0.36250760E+03, 0.132E+03, 0.470E+02, 0.94340000E+00, 0.00000000E+00,
  0.38302040E+03, 0.132E+03, 0.480E+02, 0.94340000E+00, 0.00000000E+00,
  0.48291150E+03, 0.132E+03, 0.490E+02, 0.94340000E+00, 0.00000000E+00,
  0.44490480E+03, 0.132E+03, 0.500E+02, 0.94340000E+00, 0.00000000E+00,
  0.39458220E+03, 0.132E+03, 0.510E+02, 0.94340000E+00, 0.00000000E+00,
  0.36482430E+03, 0.132E+03, 0.520E+02, 0.94340000E+00, 0.00000000E+00,
  0.32847500E+03, 0.132E+03, 0.530E+02, 0.94340000E+00, 0.00000000E+00,
  0.29399660E+03, 0.132E+03, 0.540E+02, 0.94340000E+00, 0.00000000E+00,
  0.12903249E+04, 0.132E+03, 0.550E+02, 0.94340000E+00, 0.00000000E+00,
  0.11809729E+04, 0.132E+03, 0.560E+02, 0.94340000E+00, 0.00000000E+00,
  0.10344900E+04, 0.132E+03, 0.570E+02, 0.94340000E+00, 0.00000000E+00,
  0.46618800E+03, 0.132E+03, 0.580E+02, 0.94340000E+00, 0.27991000E+01,
  0.10448624E+04, 0.132E+03, 0.590E+02, 0.94340000E+00, 0.00000000E+00,
  0.10029138E+04, 0.132E+03, 0.600E+02, 0.94340000E+00, 0.00000000E+00,
  0.97765230E+03, 0.132E+03, 0.610E+02, 0.94340000E+00, 0.00000000E+00,
  0.95444310E+03, 0.132E+03, 0.620E+02, 0.94340000E+00, 0.00000000E+00,
  0.93386150E+03, 0.132E+03, 0.630E+02, 0.94340000E+00, 0.00000000E+00,
  0.73092270E+03, 0.132E+03, 0.640E+02, 0.94340000E+00, 0.00000000E+00,
  0.82651040E+03, 0.132E+03, 0.650E+02, 0.94340000E+00, 0.00000000E+00,
  0.79662990E+03, 0.132E+03, 0.660E+02, 0.94340000E+00, 0.00000000E+00,
  0.84175260E+03, 0.132E+03, 0.670E+02, 0.94340000E+00, 0.00000000E+00,
  0.82386870E+03, 0.132E+03, 0.680E+02, 0.94340000E+00, 0.00000000E+00,
  0.80770310E+03, 0.132E+03, 0.690E+02, 0.94340000E+00, 0.00000000E+00,
  0.79843800E+03, 0.132E+03, 0.700E+02, 0.94340000E+00, 0.00000000E+00,
  0.67060970E+03, 0.132E+03, 0.710E+02, 0.94340000E+00, 0.00000000E+00,
  0.65755650E+03, 0.132E+03, 0.720E+02, 0.94340000E+00, 0.00000000E+00,
  0.59836780E+03, 0.132E+03, 0.730E+02, 0.94340000E+00, 0.00000000E+00,
  0.50344310E+03, 0.132E+03, 0.740E+02, 0.94340000E+00, 0.00000000E+00,
  0.51179750E+03, 0.132E+03, 0.750E+02, 0.94340000E+00, 0.00000000E+00,
  0.46250420E+03, 0.132E+03, 0.760E+02, 0.94340000E+00, 0.00000000E+00,
  0.42248760E+03, 0.132E+03, 0.770E+02, 0.94340000E+00, 0.00000000E+00,
  0.34951600E+03, 0.132E+03, 0.780E+02, 0.94340000E+00, 0.00000000E+00,
  0.32600720E+03, 0.132E+03, 0.790E+02, 0.94340000E+00, 0.00000000E+00,
  0.33530450E+03, 0.132E+03, 0.800E+02, 0.94340000E+00, 0.00000000E+00,
  0.49429340E+03, 0.132E+03, 0.810E+02, 0.94340000E+00, 0.00000000E+00,
  0.48215480E+03, 0.132E+03, 0.820E+02, 0.94340000E+00, 0.00000000E+00,
  0.44128680E+03, 0.132E+03, 0.830E+02, 0.94340000E+00, 0.00000000E+00,
  0.41974070E+03, 0.132E+03, 0.840E+02, 0.94340000E+00, 0.00000000E+00,
  0.38594190E+03, 0.132E+03, 0.850E+02, 0.94340000E+00, 0.00000000E+00,
  0.35237490E+03, 0.132E+03, 0.860E+02, 0.94340000E+00, 0.00000000E+00,
  0.12154454E+04, 0.132E+03, 0.870E+02, 0.94340000E+00, 0.00000000E+00,
  0.11657107E+04, 0.132E+03, 0.880E+02, 0.94340000E+00, 0.00000000E+00,
  0.10274859E+04, 0.132E+03, 0.890E+02, 0.94340000E+00, 0.00000000E+00,
  0.91935170E+03, 0.132E+03, 0.900E+02, 0.94340000E+00, 0.00000000E+00,
  0.91390230E+03, 0.132E+03, 0.910E+02, 0.94340000E+00, 0.00000000E+00,
  0.88471530E+03, 0.132E+03, 0.920E+02, 0.94340000E+00, 0.00000000E+00,
  0.91297050E+03, 0.132E+03, 0.930E+02, 0.94340000E+00, 0.00000000E+00,
  0.88377800E+03, 0.132E+03, 0.940E+02, 0.94340000E+00, 0.00000000E+00,
  0.48724700E+02, 0.132E+03, 0.101E+03, 0.94340000E+00, 0.00000000E+00,
  0.16045020E+03, 0.132E+03, 0.103E+03, 0.94340000E+00, 0.98650000E+00,
  0.20416900E+03, 0.132E+03, 0.104E+03, 0.94340000E+00, 0.98080000E+00,
  0.15444090E+03, 0.132E+03, 0.105E+03, 0.94340000E+00, 0.97060000E+00,
  0.11534880E+03, 0.132E+03, 0.106E+03, 0.94340000E+00, 0.98680000E+00,
  0.79327800E+02, 0.132E+03, 0.107E+03, 0.94340000E+00, 0.99440000E+00,
  0.57175200E+02, 0.132E+03, 0.108E+03, 0.94340000E+00, 0.99250000E+00,
  0.38758300E+02, 0.132E+03, 0.109E+03, 0.94340000E+00, 0.99820000E+00,
  0.23460480E+03, 0.132E+03, 0.111E+03, 0.94340000E+00, 0.96840000E+00,
  0.36333200E+03, 0.132E+03, 0.112E+03, 0.94340000E+00, 0.96280000E+00,
  0.36665610E+03, 0.132E+03, 0.113E+03, 0.94340000E+00, 0.96480000E+00,
  0.29253350E+03, 0.132E+03, 0.114E+03, 0.94340000E+00, 0.95070000E+00,
  0.23795800E+03, 0.132E+03, 0.115E+03, 0.94340000E+00, 0.99470000E+00,
  0.20005260E+03, 0.132E+03, 0.116E+03, 0.94340000E+00, 0.99480000E+00,
  0.16242060E+03, 0.132E+03, 0.117E+03, 0.94340000E+00, 0.99720000E+00,
  0.32115740E+03, 0.132E+03, 0.119E+03, 0.94340000E+00, 0.97670000E+00,
  0.62067350E+03, 0.132E+03, 0.120E+03, 0.94340000E+00, 0.98310000E+00,
  0.32013420E+03, 0.132E+03, 0.121E+03, 0.94340000E+00, 0.18627000E+01,
  0.30883040E+03, 0.132E+03, 0.122E+03, 0.94340000E+00, 0.18299000E+01,
  0.30262720E+03, 0.132E+03, 0.123E+03, 0.94340000E+00, 0.19138000E+01,
  0.29997060E+03, 0.132E+03, 0.124E+03, 0.94340000E+00, 0.18269000E+01,
  0.27526070E+03, 0.132E+03, 0.125E+03, 0.94340000E+00, 0.16406000E+01,
  0.25437350E+03, 0.132E+03, 0.126E+03, 0.94340000E+00, 0.16483000E+01,
  0.24255720E+03, 0.132E+03, 0.127E+03, 0.94340000E+00, 0.17149000E+01,
  0.23717370E+03, 0.132E+03, 0.128E+03, 0.94340000E+00, 0.17937000E+01,
  0.23483270E+03, 0.132E+03, 0.129E+03, 0.94340000E+00, 0.95760000E+00,
  0.21945080E+03, 0.132E+03, 0.130E+03, 0.94340000E+00, 0.19419000E+01,
  0.36268320E+03, 0.132E+03, 0.131E+03, 0.94340000E+00, 0.96010000E+00,
  0.31685210E+03, 0.132E+03, 0.132E+03, 0.94340000E+00, 0.94340000E+00,
  0.27357400E+02, 0.133E+03, 0.100E+01, 0.98890000E+00, 0.91180000E+00,
  0.18081600E+02, 0.133E+03, 0.200E+01, 0.98890000E+00, 0.00000000E+00,
  0.40634270E+03, 0.133E+03, 0.300E+01, 0.98890000E+00, 0.00000000E+00,
  0.24075590E+03, 0.133E+03, 0.400E+01, 0.98890000E+00, 0.00000000E+00,
  0.16396550E+03, 0.133E+03, 0.500E+01, 0.98890000E+00, 0.00000000E+00,
  0.11142570E+03, 0.133E+03, 0.600E+01, 0.98890000E+00, 0.00000000E+00,
  0.78113800E+02, 0.133E+03, 0.700E+01, 0.98890000E+00, 0.00000000E+00,
  0.59176400E+02, 0.133E+03, 0.800E+01, 0.98890000E+00, 0.00000000E+00,
  0.44807900E+02, 0.133E+03, 0.900E+01, 0.98890000E+00, 0.00000000E+00,
  0.34422600E+02, 0.133E+03, 0.100E+02, 0.98890000E+00, 0.00000000E+00,
  0.48646380E+03, 0.133E+03, 0.110E+02, 0.98890000E+00, 0.00000000E+00,
  0.38183960E+03, 0.133E+03, 0.120E+02, 0.98890000E+00, 0.00000000E+00,
  0.35437060E+03, 0.133E+03, 0.130E+02, 0.98890000E+00, 0.00000000E+00,
  0.28148930E+03, 0.133E+03, 0.140E+02, 0.98890000E+00, 0.00000000E+00,
  0.22071460E+03, 0.133E+03, 0.150E+02, 0.98890000E+00, 0.00000000E+00,
  0.18364620E+03, 0.133E+03, 0.160E+02, 0.98890000E+00, 0.00000000E+00,
  0.15027420E+03, 0.133E+03, 0.170E+02, 0.98890000E+00, 0.00000000E+00,
  0.12303580E+03, 0.133E+03, 0.180E+02, 0.98890000E+00, 0.00000000E+00,
  0.79363060E+03, 0.133E+03, 0.190E+02, 0.98890000E+00, 0.00000000E+00,
  0.66532210E+03, 0.133E+03, 0.200E+02, 0.98890000E+00, 0.00000000E+00,
  0.55149990E+03, 0.133E+03, 0.210E+02, 0.98890000E+00, 0.00000000E+00,
  0.53402660E+03, 0.133E+03, 0.220E+02, 0.98890000E+00, 0.00000000E+00,
  0.48982100E+03, 0.133E+03, 0.230E+02, 0.98890000E+00, 0.00000000E+00,
  0.38565770E+03, 0.133E+03, 0.240E+02, 0.98890000E+00, 0.00000000E+00,
  0.42268740E+03, 0.133E+03, 0.250E+02, 0.98890000E+00, 0.00000000E+00,
  0.33163890E+03, 0.133E+03, 0.260E+02, 0.98890000E+00, 0.00000000E+00,
  0.35300740E+03, 0.133E+03, 0.270E+02, 0.98890000E+00, 0.00000000E+00,
  0.36305660E+03, 0.133E+03, 0.280E+02, 0.98890000E+00, 0.00000000E+00,
  0.27805780E+03, 0.133E+03, 0.290E+02, 0.98890000E+00, 0.00000000E+00,
  0.28717780E+03, 0.133E+03, 0.300E+02, 0.98890000E+00, 0.00000000E+00,
  0.33996250E+03, 0.133E+03, 0.310E+02, 0.98890000E+00, 0.00000000E+00,
  0.30168000E+03, 0.133E+03, 0.320E+02, 0.98890000E+00, 0.00000000E+00,
  0.25852630E+03, 0.133E+03, 0.330E+02, 0.98890000E+00, 0.00000000E+00,
  0.23250720E+03, 0.133E+03, 0.340E+02, 0.98890000E+00, 0.00000000E+00,
  0.20384000E+03, 0.133E+03, 0.350E+02, 0.98890000E+00, 0.00000000E+00,
  0.17747160E+03, 0.133E+03, 0.360E+02, 0.98890000E+00, 0.00000000E+00,
  0.89049310E+03, 0.133E+03, 0.370E+02, 0.98890000E+00, 0.00000000E+00,
  0.79208160E+03, 0.133E+03, 0.380E+02, 0.98890000E+00, 0.00000000E+00,
  0.69780370E+03, 0.133E+03, 0.390E+02, 0.98890000E+00, 0.00000000E+00,
  0.62921900E+03, 0.133E+03, 0.400E+02, 0.98890000E+00, 0.00000000E+00,
  0.57490090E+03, 0.133E+03, 0.410E+02, 0.98890000E+00, 0.00000000E+00,
  0.44507990E+03, 0.133E+03, 0.420E+02, 0.98890000E+00, 0.00000000E+00,
  0.49610230E+03, 0.133E+03, 0.430E+02, 0.98890000E+00, 0.00000000E+00,
  0.37904270E+03, 0.133E+03, 0.440E+02, 0.98890000E+00, 0.00000000E+00,
  0.41454110E+03, 0.133E+03, 0.450E+02, 0.98890000E+00, 0.00000000E+00,
  0.38481520E+03, 0.133E+03, 0.460E+02, 0.98890000E+00, 0.00000000E+00,
  0.32022310E+03, 0.133E+03, 0.470E+02, 0.98890000E+00, 0.00000000E+00,
  0.33948140E+03, 0.133E+03, 0.480E+02, 0.98890000E+00, 0.00000000E+00,
  0.42470080E+03, 0.133E+03, 0.490E+02, 0.98890000E+00, 0.00000000E+00,
  0.39481650E+03, 0.133E+03, 0.500E+02, 0.98890000E+00, 0.00000000E+00,
  0.35342450E+03, 0.133E+03, 0.510E+02, 0.98890000E+00, 0.00000000E+00,
  0.32867560E+03, 0.133E+03, 0.520E+02, 0.98890000E+00, 0.00000000E+00,
  0.29780640E+03, 0.133E+03, 0.530E+02, 0.98890000E+00, 0.00000000E+00,
  0.26817000E+03, 0.133E+03, 0.540E+02, 0.98890000E+00, 0.00000000E+00,
  0.10853677E+04, 0.133E+03, 0.550E+02, 0.98890000E+00, 0.00000000E+00,
  0.10077913E+04, 0.133E+03, 0.560E+02, 0.98890000E+00, 0.00000000E+00,
  0.89047640E+03, 0.133E+03, 0.570E+02, 0.98890000E+00, 0.00000000E+00,
  0.41703500E+03, 0.133E+03, 0.580E+02, 0.98890000E+00, 0.27991000E+01,
  0.89428150E+03, 0.133E+03, 0.590E+02, 0.98890000E+00, 0.00000000E+00,
  0.85952480E+03, 0.133E+03, 0.600E+02, 0.98890000E+00, 0.00000000E+00,
  0.83818370E+03, 0.133E+03, 0.610E+02, 0.98890000E+00, 0.00000000E+00,
  0.81853810E+03, 0.133E+03, 0.620E+02, 0.98890000E+00, 0.00000000E+00,
  0.80112860E+03, 0.133E+03, 0.630E+02, 0.98890000E+00, 0.00000000E+00,
  0.63358090E+03, 0.133E+03, 0.640E+02, 0.98890000E+00, 0.00000000E+00,
  0.70687070E+03, 0.133E+03, 0.650E+02, 0.98890000E+00, 0.00000000E+00,
  0.68251260E+03, 0.133E+03, 0.660E+02, 0.98890000E+00, 0.00000000E+00,
  0.72360130E+03, 0.133E+03, 0.670E+02, 0.98890000E+00, 0.00000000E+00,
  0.70836530E+03, 0.133E+03, 0.680E+02, 0.98890000E+00, 0.00000000E+00,
  0.69468070E+03, 0.133E+03, 0.690E+02, 0.98890000E+00, 0.00000000E+00,
  0.68640110E+03, 0.133E+03, 0.700E+02, 0.98890000E+00, 0.00000000E+00,
  0.58061170E+03, 0.133E+03, 0.710E+02, 0.98890000E+00, 0.00000000E+00,
  0.57440900E+03, 0.133E+03, 0.720E+02, 0.98890000E+00, 0.00000000E+00,
  0.52573750E+03, 0.133E+03, 0.730E+02, 0.98890000E+00, 0.00000000E+00,
  0.44464860E+03, 0.133E+03, 0.740E+02, 0.98890000E+00, 0.00000000E+00,
  0.45291770E+03, 0.133E+03, 0.750E+02, 0.98890000E+00, 0.00000000E+00,
  0.41136690E+03, 0.133E+03, 0.760E+02, 0.98890000E+00, 0.00000000E+00,
  0.37733280E+03, 0.133E+03, 0.770E+02, 0.98890000E+00, 0.00000000E+00,
  0.31370400E+03, 0.133E+03, 0.780E+02, 0.98890000E+00, 0.00000000E+00,
  0.29316560E+03, 0.133E+03, 0.790E+02, 0.98890000E+00, 0.00000000E+00,
  0.30197230E+03, 0.133E+03, 0.800E+02, 0.98890000E+00, 0.00000000E+00,
  0.43615840E+03, 0.133E+03, 0.810E+02, 0.98890000E+00, 0.00000000E+00,
  0.42826390E+03, 0.133E+03, 0.820E+02, 0.98890000E+00, 0.00000000E+00,
  0.39514950E+03, 0.133E+03, 0.830E+02, 0.98890000E+00, 0.00000000E+00,
  0.37768730E+03, 0.133E+03, 0.840E+02, 0.98890000E+00, 0.00000000E+00,
  0.34934070E+03, 0.133E+03, 0.850E+02, 0.98890000E+00, 0.00000000E+00,
  0.32071970E+03, 0.133E+03, 0.860E+02, 0.98890000E+00, 0.00000000E+00,
  0.10295399E+04, 0.133E+03, 0.870E+02, 0.98890000E+00, 0.00000000E+00,
  0.99943950E+03, 0.133E+03, 0.880E+02, 0.98890000E+00, 0.00000000E+00,
  0.88791120E+03, 0.133E+03, 0.890E+02, 0.98890000E+00, 0.00000000E+00,
  0.80215530E+03, 0.133E+03, 0.900E+02, 0.98890000E+00, 0.00000000E+00,
  0.79394730E+03, 0.133E+03, 0.910E+02, 0.98890000E+00, 0.00000000E+00,
  0.76878210E+03, 0.133E+03, 0.920E+02, 0.98890000E+00, 0.00000000E+00,
  0.78864020E+03, 0.133E+03, 0.930E+02, 0.98890000E+00, 0.00000000E+00,
  0.76421100E+03, 0.133E+03, 0.940E+02, 0.98890000E+00, 0.00000000E+00,
  0.43906700E+02, 0.133E+03, 0.101E+03, 0.98890000E+00, 0.00000000E+00,
  0.14013530E+03, 0.133E+03, 0.103E+03, 0.98890000E+00, 0.98650000E+00,
  0.17913900E+03, 0.133E+03, 0.104E+03, 0.98890000E+00, 0.98080000E+00,
  0.13814460E+03, 0.133E+03, 0.105E+03, 0.98890000E+00, 0.97060000E+00,
  0.10445320E+03, 0.133E+03, 0.106E+03, 0.98890000E+00, 0.98680000E+00,
  0.72807300E+02, 0.133E+03, 0.107E+03, 0.98890000E+00, 0.99440000E+00,
  0.53064500E+02, 0.133E+03, 0.108E+03, 0.98890000E+00, 0.99250000E+00,
  0.36472800E+02, 0.133E+03, 0.109E+03, 0.98890000E+00, 0.99820000E+00,
  0.20419370E+03, 0.133E+03, 0.111E+03, 0.98890000E+00, 0.96840000E+00,
  0.31566880E+03, 0.133E+03, 0.112E+03, 0.98890000E+00, 0.96280000E+00,
  0.32160430E+03, 0.133E+03, 0.113E+03, 0.98890000E+00, 0.96480000E+00,
  0.26040440E+03, 0.133E+03, 0.114E+03, 0.98890000E+00, 0.95070000E+00,
  0.21425140E+03, 0.133E+03, 0.115E+03, 0.98890000E+00, 0.99470000E+00,
  0.18159050E+03, 0.133E+03, 0.116E+03, 0.98890000E+00, 0.99480000E+00,
  0.14869430E+03, 0.133E+03, 0.117E+03, 0.98890000E+00, 0.99720000E+00,
  0.28230700E+03, 0.133E+03, 0.119E+03, 0.98890000E+00, 0.97670000E+00,
  0.53224610E+03, 0.133E+03, 0.120E+03, 0.98890000E+00, 0.98310000E+00,
  0.28445160E+03, 0.133E+03, 0.121E+03, 0.98890000E+00, 0.18627000E+01,
  0.27459290E+03, 0.133E+03, 0.122E+03, 0.98890000E+00, 0.18299000E+01,
  0.26902700E+03, 0.133E+03, 0.123E+03, 0.98890000E+00, 0.19138000E+01,
  0.26629390E+03, 0.133E+03, 0.124E+03, 0.98890000E+00, 0.18269000E+01,
  0.24597130E+03, 0.133E+03, 0.125E+03, 0.98890000E+00, 0.16406000E+01,
  0.22781130E+03, 0.133E+03, 0.126E+03, 0.98890000E+00, 0.16483000E+01,
  0.21726350E+03, 0.133E+03, 0.127E+03, 0.98890000E+00, 0.17149000E+01,
  0.21232210E+03, 0.133E+03, 0.128E+03, 0.98890000E+00, 0.17937000E+01,
  0.20913220E+03, 0.133E+03, 0.129E+03, 0.98890000E+00, 0.95760000E+00,
  0.19727710E+03, 0.133E+03, 0.130E+03, 0.98890000E+00, 0.19419000E+01,
  0.31978710E+03, 0.133E+03, 0.131E+03, 0.98890000E+00, 0.96010000E+00,
  0.28257170E+03, 0.133E+03, 0.132E+03, 0.98890000E+00, 0.94340000E+00,
  0.25419240E+03, 0.133E+03, 0.133E+03, 0.98890000E+00, 0.98890000E+00,
  0.25314900E+02, 0.134E+03, 0.100E+01, 0.99010000E+00, 0.91180000E+00,
  0.17028000E+02, 0.134E+03, 0.200E+01, 0.99010000E+00, 0.00000000E+00,
  0.35504500E+03, 0.134E+03, 0.300E+01, 0.99010000E+00, 0.00000000E+00,
  0.21516710E+03, 0.134E+03, 0.400E+01, 0.99010000E+00, 0.00000000E+00,
  0.14885900E+03, 0.134E+03, 0.500E+01, 0.99010000E+00, 0.00000000E+00,
  0.10246200E+03, 0.134E+03, 0.600E+01, 0.99010000E+00, 0.00000000E+00,
  0.72556700E+02, 0.134E+03, 0.700E+01, 0.99010000E+00, 0.00000000E+00,
  0.55375200E+02, 0.134E+03, 0.800E+01, 0.99010000E+00, 0.00000000E+00,
  0.42202700E+02, 0.134E+03, 0.900E+01, 0.99010000E+00, 0.00000000E+00,
  0.32593500E+02, 0.134E+03, 0.100E+02, 0.99010000E+00, 0.00000000E+00,
  0.42577330E+03, 0.134E+03, 0.110E+02, 0.99010000E+00, 0.00000000E+00,
  0.33984270E+03, 0.134E+03, 0.120E+02, 0.99010000E+00, 0.00000000E+00,
  0.31781330E+03, 0.134E+03, 0.130E+02, 0.99010000E+00, 0.00000000E+00,
  0.25511530E+03, 0.134E+03, 0.140E+02, 0.99010000E+00, 0.00000000E+00,
  0.20196030E+03, 0.134E+03, 0.150E+02, 0.99010000E+00, 0.00000000E+00,
  0.16917120E+03, 0.134E+03, 0.160E+02, 0.99010000E+00, 0.00000000E+00,
  0.13934530E+03, 0.134E+03, 0.170E+02, 0.99010000E+00, 0.00000000E+00,
  0.11476770E+03, 0.134E+03, 0.180E+02, 0.99010000E+00, 0.00000000E+00,
  0.69398180E+03, 0.134E+03, 0.190E+02, 0.99010000E+00, 0.00000000E+00,
  0.58857630E+03, 0.134E+03, 0.200E+02, 0.99010000E+00, 0.00000000E+00,
  0.48933050E+03, 0.134E+03, 0.210E+02, 0.99010000E+00, 0.00000000E+00,
  0.47544530E+03, 0.134E+03, 0.220E+02, 0.99010000E+00, 0.00000000E+00,
  0.43692930E+03, 0.134E+03, 0.230E+02, 0.99010000E+00, 0.00000000E+00,
  0.34458580E+03, 0.134E+03, 0.240E+02, 0.99010000E+00, 0.00000000E+00,
  0.37811330E+03, 0.134E+03, 0.250E+02, 0.99010000E+00, 0.00000000E+00,
  0.29726970E+03, 0.134E+03, 0.260E+02, 0.99010000E+00, 0.00000000E+00,
  0.31722330E+03, 0.134E+03, 0.270E+02, 0.99010000E+00, 0.00000000E+00,
  0.32556670E+03, 0.134E+03, 0.280E+02, 0.99010000E+00, 0.00000000E+00,
  0.24982100E+03, 0.134E+03, 0.290E+02, 0.99010000E+00, 0.00000000E+00,
  0.25919160E+03, 0.134E+03, 0.300E+02, 0.99010000E+00, 0.00000000E+00,
  0.30612750E+03, 0.134E+03, 0.310E+02, 0.99010000E+00, 0.00000000E+00,
  0.27376800E+03, 0.134E+03, 0.320E+02, 0.99010000E+00, 0.00000000E+00,
  0.23642060E+03, 0.134E+03, 0.330E+02, 0.99010000E+00, 0.00000000E+00,
  0.21372980E+03, 0.134E+03, 0.340E+02, 0.99010000E+00, 0.00000000E+00,
  0.18840310E+03, 0.134E+03, 0.350E+02, 0.99010000E+00, 0.00000000E+00,
  0.16488330E+03, 0.134E+03, 0.360E+02, 0.99010000E+00, 0.00000000E+00,
  0.78009860E+03, 0.134E+03, 0.370E+02, 0.99010000E+00, 0.00000000E+00,
  0.70080150E+03, 0.134E+03, 0.380E+02, 0.99010000E+00, 0.00000000E+00,
  0.62089180E+03, 0.134E+03, 0.390E+02, 0.99010000E+00, 0.00000000E+00,
  0.56200010E+03, 0.134E+03, 0.400E+02, 0.99010000E+00, 0.00000000E+00,
  0.51489450E+03, 0.134E+03, 0.410E+02, 0.99010000E+00, 0.00000000E+00,
  0.40077220E+03, 0.134E+03, 0.420E+02, 0.99010000E+00, 0.00000000E+00,
  0.44579160E+03, 0.134E+03, 0.430E+02, 0.99010000E+00, 0.00000000E+00,
  0.34259700E+03, 0.134E+03, 0.440E+02, 0.99010000E+00, 0.00000000E+00,
  0.37429000E+03, 0.134E+03, 0.450E+02, 0.99010000E+00, 0.00000000E+00,
  0.34804020E+03, 0.134E+03, 0.460E+02, 0.99010000E+00, 0.00000000E+00,
  0.28983280E+03, 0.134E+03, 0.470E+02, 0.99010000E+00, 0.00000000E+00,
  0.30772140E+03, 0.134E+03, 0.480E+02, 0.99010000E+00, 0.00000000E+00,
  0.38283810E+03, 0.134E+03, 0.490E+02, 0.99010000E+00, 0.00000000E+00,
  0.35796090E+03, 0.134E+03, 0.500E+02, 0.99010000E+00, 0.00000000E+00,
  0.32248120E+03, 0.134E+03, 0.510E+02, 0.99010000E+00, 0.00000000E+00,
  0.30115060E+03, 0.134E+03, 0.520E+02, 0.99010000E+00, 0.00000000E+00,
  0.27413770E+03, 0.134E+03, 0.530E+02, 0.99010000E+00, 0.00000000E+00,
  0.24798670E+03, 0.134E+03, 0.540E+02, 0.99010000E+00, 0.00000000E+00,
  0.95163050E+03, 0.134E+03, 0.550E+02, 0.99010000E+00, 0.00000000E+00,
  0.89062640E+03, 0.134E+03, 0.560E+02, 0.99010000E+00, 0.00000000E+00,
  0.79124710E+03, 0.134E+03, 0.570E+02, 0.99010000E+00, 0.00000000E+00,
  0.38031600E+03, 0.134E+03, 0.580E+02, 0.99010000E+00, 0.27991000E+01,
  0.79188170E+03, 0.134E+03, 0.590E+02, 0.99010000E+00, 0.00000000E+00,
  0.76169980E+03, 0.134E+03, 0.600E+02, 0.99010000E+00, 0.00000000E+00,
  0.74294350E+03, 0.134E+03, 0.610E+02, 0.99010000E+00, 0.00000000E+00,
  0.72565360E+03, 0.134E+03, 0.620E+02, 0.99010000E+00, 0.00000000E+00,
  0.71033760E+03, 0.134E+03, 0.630E+02, 0.99010000E+00, 0.00000000E+00,
  0.56579140E+03, 0.134E+03, 0.640E+02, 0.99010000E+00, 0.00000000E+00,
  0.62617050E+03, 0.134E+03, 0.650E+02, 0.99010000E+00, 0.00000000E+00,
  0.60528280E+03, 0.134E+03, 0.660E+02, 0.99010000E+00, 0.00000000E+00,
  0.64237950E+03, 0.134E+03, 0.670E+02, 0.99010000E+00, 0.00000000E+00,
  0.62891080E+03, 0.134E+03, 0.680E+02, 0.99010000E+00, 0.00000000E+00,
  0.61686660E+03, 0.134E+03, 0.690E+02, 0.99010000E+00, 0.00000000E+00,
  0.60931460E+03, 0.134E+03, 0.700E+02, 0.99010000E+00, 0.00000000E+00,
  0.51790690E+03, 0.134E+03, 0.710E+02, 0.99010000E+00, 0.00000000E+00,
  0.51523880E+03, 0.134E+03, 0.720E+02, 0.99010000E+00, 0.00000000E+00,
  0.47346190E+03, 0.134E+03, 0.730E+02, 0.99010000E+00, 0.00000000E+00,
  0.40207780E+03, 0.134E+03, 0.740E+02, 0.99010000E+00, 0.00000000E+00,
  0.41003520E+03, 0.134E+03, 0.750E+02, 0.99010000E+00, 0.00000000E+00,
  0.37374220E+03, 0.134E+03, 0.760E+02, 0.99010000E+00, 0.00000000E+00,
  0.34383760E+03, 0.134E+03, 0.770E+02, 0.99010000E+00, 0.00000000E+00,
  0.28699450E+03, 0.134E+03, 0.780E+02, 0.99010000E+00, 0.00000000E+00,
  0.26861450E+03, 0.134E+03, 0.790E+02, 0.99010000E+00, 0.00000000E+00,
  0.27687780E+03, 0.134E+03, 0.800E+02, 0.99010000E+00, 0.00000000E+00,
  0.39433850E+03, 0.134E+03, 0.810E+02, 0.99010000E+00, 0.00000000E+00,
  0.38873570E+03, 0.134E+03, 0.820E+02, 0.99010000E+00, 0.00000000E+00,
  0.36061850E+03, 0.134E+03, 0.830E+02, 0.99010000E+00, 0.00000000E+00,
  0.34584750E+03, 0.134E+03, 0.840E+02, 0.99010000E+00, 0.00000000E+00,
  0.32125280E+03, 0.134E+03, 0.850E+02, 0.99010000E+00, 0.00000000E+00,
  0.29613640E+03, 0.134E+03, 0.860E+02, 0.99010000E+00, 0.00000000E+00,
  0.90670650E+03, 0.134E+03, 0.870E+02, 0.99010000E+00, 0.00000000E+00,
  0.88597380E+03, 0.134E+03, 0.880E+02, 0.99010000E+00, 0.00000000E+00,
  0.79097170E+03, 0.134E+03, 0.890E+02, 0.99010000E+00, 0.00000000E+00,
  0.71920180E+03, 0.134E+03, 0.900E+02, 0.99010000E+00, 0.00000000E+00,
  0.71002990E+03, 0.134E+03, 0.910E+02, 0.99010000E+00, 0.00000000E+00,
  0.68765590E+03, 0.134E+03, 0.920E+02, 0.99010000E+00, 0.00000000E+00,
  0.70268800E+03, 0.134E+03, 0.930E+02, 0.99010000E+00, 0.00000000E+00,
  0.68135890E+03, 0.134E+03, 0.940E+02, 0.99010000E+00, 0.00000000E+00,
  0.40211700E+02, 0.134E+03, 0.101E+03, 0.99010000E+00, 0.00000000E+00,
  0.12555640E+03, 0.134E+03, 0.103E+03, 0.99010000E+00, 0.98650000E+00,
  0.16106370E+03, 0.134E+03, 0.104E+03, 0.99010000E+00, 0.98080000E+00,
  0.12588880E+03, 0.134E+03, 0.105E+03, 0.99010000E+00, 0.97060000E+00,
  0.96087200E+02, 0.134E+03, 0.106E+03, 0.99010000E+00, 0.98680000E+00,
  0.67679600E+02, 0.134E+03, 0.107E+03, 0.99010000E+00, 0.99440000E+00,
  0.49766500E+02, 0.134E+03, 0.108E+03, 0.99010000E+00, 0.99250000E+00,
  0.34588200E+02, 0.134E+03, 0.109E+03, 0.99010000E+00, 0.99820000E+00,
  0.18260620E+03, 0.134E+03, 0.111E+03, 0.99010000E+00, 0.96840000E+00,
  0.28192490E+03, 0.134E+03, 0.112E+03, 0.99010000E+00, 0.96280000E+00,
  0.28901630E+03, 0.134E+03, 0.113E+03, 0.99010000E+00, 0.96480000E+00,
  0.23642530E+03, 0.134E+03, 0.114E+03, 0.99010000E+00, 0.95070000E+00,
  0.19613740E+03, 0.134E+03, 0.115E+03, 0.99010000E+00, 0.99470000E+00,
  0.16726720E+03, 0.134E+03, 0.116E+03, 0.99010000E+00, 0.99480000E+00,
  0.13787350E+03, 0.134E+03, 0.117E+03, 0.99010000E+00, 0.99720000E+00,
  0.25453760E+03, 0.134E+03, 0.119E+03, 0.99010000E+00, 0.97670000E+00,
  0.47198210E+03, 0.134E+03, 0.120E+03, 0.99010000E+00, 0.98310000E+00,
  0.25812950E+03, 0.134E+03, 0.121E+03, 0.99010000E+00, 0.18627000E+01,
  0.24934370E+03, 0.134E+03, 0.122E+03, 0.99010000E+00, 0.18299000E+01,
  0.24427270E+03, 0.134E+03, 0.123E+03, 0.99010000E+00, 0.19138000E+01,
  0.24158030E+03, 0.134E+03, 0.124E+03, 0.99010000E+00, 0.18269000E+01,
  0.22407570E+03, 0.134E+03, 0.125E+03, 0.99010000E+00, 0.16406000E+01,
  0.20787480E+03, 0.134E+03, 0.126E+03, 0.99010000E+00, 0.16483000E+01,
  0.19829930E+03, 0.134E+03, 0.127E+03, 0.99010000E+00, 0.17149000E+01,
  0.19372130E+03, 0.134E+03, 0.128E+03, 0.99010000E+00, 0.17937000E+01,
  0.19016850E+03, 0.134E+03, 0.129E+03, 0.99010000E+00, 0.95760000E+00,
  0.18048120E+03, 0.134E+03, 0.130E+03, 0.99010000E+00, 0.19419000E+01,
  0.28854930E+03, 0.134E+03, 0.131E+03, 0.99010000E+00, 0.96010000E+00,
  0.25695230E+03, 0.134E+03, 0.132E+03, 0.99010000E+00, 0.94340000E+00,
  0.23257840E+03, 0.134E+03, 0.133E+03, 0.99010000E+00, 0.98890000E+00,
  0.21378620E+03, 0.134E+03, 0.134E+03, 0.99010000E+00, 0.99010000E+00,
  0.22623000E+02, 0.135E+03, 0.100E+01, 0.99740000E+00, 0.91180000E+00,
  0.15538700E+02, 0.135E+03, 0.200E+01, 0.99740000E+00, 0.00000000E+00,
  0.29768350E+03, 0.135E+03, 0.300E+01, 0.99740000E+00, 0.00000000E+00,
  0.18488320E+03, 0.135E+03, 0.400E+01, 0.99740000E+00, 0.00000000E+00,
  0.13018810E+03, 0.135E+03, 0.500E+01, 0.99740000E+00, 0.00000000E+00,
  0.90934300E+02, 0.135E+03, 0.600E+01, 0.99740000E+00, 0.00000000E+00,
  0.65154300E+02, 0.135E+03, 0.700E+01, 0.99740000E+00, 0.00000000E+00,
  0.50163200E+02, 0.135E+03, 0.800E+01, 0.99740000E+00, 0.00000000E+00,
  0.38529400E+02, 0.135E+03, 0.900E+01, 0.99740000E+00, 0.00000000E+00,
  0.29950100E+02, 0.135E+03, 0.100E+02, 0.99740000E+00, 0.00000000E+00,
  0.35772460E+03, 0.135E+03, 0.110E+02, 0.99740000E+00, 0.00000000E+00,
  0.29072760E+03, 0.135E+03, 0.120E+02, 0.99740000E+00, 0.00000000E+00,
  0.27418940E+03, 0.135E+03, 0.130E+02, 0.99740000E+00, 0.00000000E+00,
  0.22268120E+03, 0.135E+03, 0.140E+02, 0.99740000E+00, 0.00000000E+00,
  0.17819840E+03, 0.135E+03, 0.150E+02, 0.99740000E+00, 0.00000000E+00,
  0.15042030E+03, 0.135E+03, 0.160E+02, 0.99740000E+00, 0.00000000E+00,
  0.12484950E+03, 0.135E+03, 0.170E+02, 0.99740000E+00, 0.00000000E+00,
  0.10354670E+03, 0.135E+03, 0.180E+02, 0.99740000E+00, 0.00000000E+00,
  0.58289140E+03, 0.135E+03, 0.190E+02, 0.99740000E+00, 0.00000000E+00,
  0.50041520E+03, 0.135E+03, 0.200E+02, 0.99740000E+00, 0.00000000E+00,
  0.41736480E+03, 0.135E+03, 0.210E+02, 0.99740000E+00, 0.00000000E+00,
  0.40709700E+03, 0.135E+03, 0.220E+02, 0.99740000E+00, 0.00000000E+00,
  0.37492830E+03, 0.135E+03, 0.230E+02, 0.99740000E+00, 0.00000000E+00,
  0.29636070E+03, 0.135E+03, 0.240E+02, 0.99740000E+00, 0.00000000E+00,
  0.32549450E+03, 0.135E+03, 0.250E+02, 0.99740000E+00, 0.00000000E+00,
  0.25659390E+03, 0.135E+03, 0.260E+02, 0.99740000E+00, 0.00000000E+00,
  0.27446200E+03, 0.135E+03, 0.270E+02, 0.99740000E+00, 0.00000000E+00,
  0.28101540E+03, 0.135E+03, 0.280E+02, 0.99740000E+00, 0.00000000E+00,
  0.21621400E+03, 0.135E+03, 0.290E+02, 0.99740000E+00, 0.00000000E+00,
  0.22534570E+03, 0.135E+03, 0.300E+02, 0.99740000E+00, 0.00000000E+00,
  0.26539390E+03, 0.135E+03, 0.310E+02, 0.99740000E+00, 0.00000000E+00,
  0.23936360E+03, 0.135E+03, 0.320E+02, 0.99740000E+00, 0.00000000E+00,
  0.20849570E+03, 0.135E+03, 0.330E+02, 0.99740000E+00, 0.00000000E+00,
  0.18959740E+03, 0.135E+03, 0.340E+02, 0.99740000E+00, 0.00000000E+00,
  0.16817910E+03, 0.135E+03, 0.350E+02, 0.99740000E+00, 0.00000000E+00,
  0.14806890E+03, 0.135E+03, 0.360E+02, 0.99740000E+00, 0.00000000E+00,
  0.65665740E+03, 0.135E+03, 0.370E+02, 0.99740000E+00, 0.00000000E+00,
  0.59602140E+03, 0.135E+03, 0.380E+02, 0.99740000E+00, 0.00000000E+00,
  0.53134260E+03, 0.135E+03, 0.390E+02, 0.99740000E+00, 0.00000000E+00,
  0.48298730E+03, 0.135E+03, 0.400E+02, 0.99740000E+00, 0.00000000E+00,
  0.44388480E+03, 0.135E+03, 0.410E+02, 0.99740000E+00, 0.00000000E+00,
  0.34768000E+03, 0.135E+03, 0.420E+02, 0.99740000E+00, 0.00000000E+00,
  0.38579860E+03, 0.135E+03, 0.430E+02, 0.99740000E+00, 0.00000000E+00,
  0.29851740E+03, 0.135E+03, 0.440E+02, 0.99740000E+00, 0.00000000E+00,
  0.32566500E+03, 0.135E+03, 0.450E+02, 0.99740000E+00, 0.00000000E+00,
  0.30341070E+03, 0.135E+03, 0.460E+02, 0.99740000E+00, 0.00000000E+00,
  0.25300950E+03, 0.135E+03, 0.470E+02, 0.99740000E+00, 0.00000000E+00,
  0.26894910E+03, 0.135E+03, 0.480E+02, 0.99740000E+00, 0.00000000E+00,
  0.33247910E+03, 0.135E+03, 0.490E+02, 0.99740000E+00, 0.00000000E+00,
  0.31279940E+03, 0.135E+03, 0.500E+02, 0.99740000E+00, 0.00000000E+00,
  0.28377610E+03, 0.135E+03, 0.510E+02, 0.99740000E+00, 0.00000000E+00,
  0.26623860E+03, 0.135E+03, 0.520E+02, 0.99740000E+00, 0.00000000E+00,
  0.24362960E+03, 0.135E+03, 0.530E+02, 0.99740000E+00, 0.00000000E+00,
  0.22153670E+03, 0.135E+03, 0.540E+02, 0.99740000E+00, 0.00000000E+00,
  0.80186140E+03, 0.135E+03, 0.550E+02, 0.99740000E+00, 0.00000000E+00,
  0.75662710E+03, 0.135E+03, 0.560E+02, 0.99740000E+00, 0.00000000E+00,
  0.67619300E+03, 0.135E+03, 0.570E+02, 0.99740000E+00, 0.00000000E+00,
  0.33452620E+03, 0.135E+03, 0.580E+02, 0.99740000E+00, 0.27991000E+01,
  0.67428760E+03, 0.135E+03, 0.590E+02, 0.99740000E+00, 0.00000000E+00,
  0.64912820E+03, 0.135E+03, 0.600E+02, 0.99740000E+00, 0.00000000E+00,
  0.63328350E+03, 0.135E+03, 0.610E+02, 0.99740000E+00, 0.00000000E+00,
  0.61865400E+03, 0.135E+03, 0.620E+02, 0.99740000E+00, 0.00000000E+00,
  0.60569940E+03, 0.135E+03, 0.630E+02, 0.99740000E+00, 0.00000000E+00,
  0.48634440E+03, 0.135E+03, 0.640E+02, 0.99740000E+00, 0.00000000E+00,
  0.53364850E+03, 0.135E+03, 0.650E+02, 0.99740000E+00, 0.00000000E+00,
  0.51649050E+03, 0.135E+03, 0.660E+02, 0.99740000E+00, 0.00000000E+00,
  0.54846290E+03, 0.135E+03, 0.670E+02, 0.99740000E+00, 0.00000000E+00,
  0.53700790E+03, 0.135E+03, 0.680E+02, 0.99740000E+00, 0.00000000E+00,
  0.52681470E+03, 0.135E+03, 0.690E+02, 0.99740000E+00, 0.00000000E+00,
  0.52016740E+03, 0.135E+03, 0.700E+02, 0.99740000E+00, 0.00000000E+00,
  0.44455160E+03, 0.135E+03, 0.710E+02, 0.99740000E+00, 0.00000000E+00,
  0.44488510E+03, 0.135E+03, 0.720E+02, 0.99740000E+00, 0.00000000E+00,
  0.41064300E+03, 0.135E+03, 0.730E+02, 0.99740000E+00, 0.00000000E+00,
  0.35042340E+03, 0.135E+03, 0.740E+02, 0.99740000E+00, 0.00000000E+00,
  0.35779320E+03, 0.135E+03, 0.750E+02, 0.99740000E+00, 0.00000000E+00,
  0.32743170E+03, 0.135E+03, 0.760E+02, 0.99740000E+00, 0.00000000E+00,
  0.30224750E+03, 0.135E+03, 0.770E+02, 0.99740000E+00, 0.00000000E+00,
  0.25348160E+03, 0.135E+03, 0.780E+02, 0.99740000E+00, 0.00000000E+00,
  0.23768320E+03, 0.135E+03, 0.790E+02, 0.99740000E+00, 0.00000000E+00,
  0.24514110E+03, 0.135E+03, 0.800E+02, 0.99740000E+00, 0.00000000E+00,
  0.34374040E+03, 0.135E+03, 0.810E+02, 0.99740000E+00, 0.00000000E+00,
  0.34024220E+03, 0.135E+03, 0.820E+02, 0.99740000E+00, 0.00000000E+00,
  0.31748380E+03, 0.135E+03, 0.830E+02, 0.99740000E+00, 0.00000000E+00,
  0.30560970E+03, 0.135E+03, 0.840E+02, 0.99740000E+00, 0.00000000E+00,
  0.28522290E+03, 0.135E+03, 0.850E+02, 0.99740000E+00, 0.00000000E+00,
  0.26413340E+03, 0.135E+03, 0.860E+02, 0.99740000E+00, 0.00000000E+00,
  0.76779060E+03, 0.135E+03, 0.870E+02, 0.99740000E+00, 0.00000000E+00,
  0.75526170E+03, 0.135E+03, 0.880E+02, 0.99740000E+00, 0.00000000E+00,
  0.67787670E+03, 0.135E+03, 0.890E+02, 0.99740000E+00, 0.00000000E+00,
  0.62082600E+03, 0.135E+03, 0.900E+02, 0.99740000E+00, 0.00000000E+00,
  0.61130750E+03, 0.135E+03, 0.910E+02, 0.99740000E+00, 0.00000000E+00,
  0.59218710E+03, 0.135E+03, 0.920E+02, 0.99740000E+00, 0.00000000E+00,
  0.60258350E+03, 0.135E+03, 0.930E+02, 0.99740000E+00, 0.00000000E+00,
  0.58469980E+03, 0.135E+03, 0.940E+02, 0.99740000E+00, 0.00000000E+00,
  0.35512300E+02, 0.135E+03, 0.101E+03, 0.99740000E+00, 0.00000000E+00,
  0.10820480E+03, 0.135E+03, 0.103E+03, 0.99740000E+00, 0.98650000E+00,
  0.13936170E+03, 0.135E+03, 0.104E+03, 0.99740000E+00, 0.98080000E+00,
  0.11058020E+03, 0.135E+03, 0.105E+03, 0.99740000E+00, 0.97060000E+00,
  0.85326500E+02, 0.135E+03, 0.106E+03, 0.99740000E+00, 0.98680000E+00,
  0.60835900E+02, 0.135E+03, 0.107E+03, 0.99740000E+00, 0.99440000E+00,
  0.45201900E+02, 0.135E+03, 0.108E+03, 0.99740000E+00, 0.99250000E+00,
  0.31831300E+02, 0.135E+03, 0.109E+03, 0.99740000E+00, 0.99820000E+00,
  0.15710050E+03, 0.135E+03, 0.111E+03, 0.99740000E+00, 0.96840000E+00,
  0.24214760E+03, 0.135E+03, 0.112E+03, 0.99740000E+00, 0.96280000E+00,
  0.24992480E+03, 0.135E+03, 0.113E+03, 0.99740000E+00, 0.96480000E+00,
  0.20678800E+03, 0.135E+03, 0.114E+03, 0.99740000E+00, 0.95070000E+00,
  0.17315820E+03, 0.135E+03, 0.115E+03, 0.99740000E+00, 0.99470000E+00,
  0.14872190E+03, 0.135E+03, 0.116E+03, 0.99740000E+00, 0.99480000E+00,
  0.12352740E+03, 0.135E+03, 0.117E+03, 0.99740000E+00, 0.99720000E+00,
  0.22116420E+03, 0.135E+03, 0.119E+03, 0.99740000E+00, 0.97670000E+00,
  0.40253800E+03, 0.135E+03, 0.120E+03, 0.99740000E+00, 0.98310000E+00,
  0.22577840E+03, 0.135E+03, 0.121E+03, 0.99740000E+00, 0.18627000E+01,
  0.21827110E+03, 0.135E+03, 0.122E+03, 0.99740000E+00, 0.18299000E+01,
  0.21382760E+03, 0.135E+03, 0.123E+03, 0.99740000E+00, 0.19138000E+01,
  0.21128090E+03, 0.135E+03, 0.124E+03, 0.99740000E+00, 0.18269000E+01,
  0.19683950E+03, 0.135E+03, 0.125E+03, 0.99740000E+00, 0.16406000E+01,
  0.18295500E+03, 0.135E+03, 0.126E+03, 0.99740000E+00, 0.16483000E+01,
  0.17459100E+03, 0.135E+03, 0.127E+03, 0.99740000E+00, 0.17149000E+01,
  0.17050040E+03, 0.135E+03, 0.128E+03, 0.99740000E+00, 0.17937000E+01,
  0.16678160E+03, 0.135E+03, 0.129E+03, 0.99740000E+00, 0.95760000E+00,
  0.15930490E+03, 0.135E+03, 0.130E+03, 0.99740000E+00, 0.19419000E+01,
  0.25072470E+03, 0.135E+03, 0.131E+03, 0.99740000E+00, 0.96010000E+00,
  0.22517920E+03, 0.135E+03, 0.132E+03, 0.99740000E+00, 0.94340000E+00,
  0.20523050E+03, 0.135E+03, 0.133E+03, 0.99740000E+00, 0.98890000E+00,
  0.18964080E+03, 0.135E+03, 0.134E+03, 0.99740000E+00, 0.99010000E+00,
  0.16923750E+03, 0.135E+03, 0.135E+03, 0.99740000E+00, 0.99740000E+00,
  0.35196300E+02, 0.137E+03, 0.100E+01, 0.97380000E+00, 0.91180000E+00,
  0.22623100E+02, 0.137E+03, 0.200E+01, 0.97380000E+00, 0.00000000E+00,
  0.65740760E+03, 0.137E+03, 0.300E+01, 0.97380000E+00, 0.00000000E+00,
  0.34543780E+03, 0.137E+03, 0.400E+01, 0.97380000E+00, 0.00000000E+00,
  0.22250810E+03, 0.137E+03, 0.500E+01, 0.97380000E+00, 0.00000000E+00,
  0.14599740E+03, 0.137E+03, 0.600E+01, 0.97380000E+00, 0.00000000E+00,
  0.10014180E+03, 0.137E+03, 0.700E+01, 0.97380000E+00, 0.00000000E+00,
  0.74886800E+02, 0.137E+03, 0.800E+01, 0.97380000E+00, 0.00000000E+00,
  0.56177900E+02, 0.137E+03, 0.900E+01, 0.97380000E+00, 0.00000000E+00,
  0.42895700E+02, 0.137E+03, 0.100E+02, 0.97380000E+00, 0.00000000E+00,
  0.78185270E+03, 0.137E+03, 0.110E+02, 0.97380000E+00, 0.00000000E+00,
  0.55913370E+03, 0.137E+03, 0.120E+02, 0.97380000E+00, 0.00000000E+00,
  0.50299330E+03, 0.137E+03, 0.130E+02, 0.97380000E+00, 0.00000000E+00,
  0.38390840E+03, 0.137E+03, 0.140E+02, 0.97380000E+00, 0.00000000E+00,
  0.29216040E+03, 0.137E+03, 0.150E+02, 0.97380000E+00, 0.00000000E+00,
  0.23905720E+03, 0.137E+03, 0.160E+02, 0.97380000E+00, 0.00000000E+00,
  0.19278770E+03, 0.137E+03, 0.170E+02, 0.97380000E+00, 0.00000000E+00,
  0.15610100E+03, 0.137E+03, 0.180E+02, 0.97380000E+00, 0.00000000E+00,
  0.13058840E+04, 0.137E+03, 0.190E+02, 0.97380000E+00, 0.00000000E+00,
  0.10130706E+04, 0.137E+03, 0.200E+02, 0.97380000E+00, 0.00000000E+00,
  0.82610410E+03, 0.137E+03, 0.210E+02, 0.97380000E+00, 0.00000000E+00,
  0.78941170E+03, 0.137E+03, 0.220E+02, 0.97380000E+00, 0.00000000E+00,
  0.71821250E+03, 0.137E+03, 0.230E+02, 0.97380000E+00, 0.00000000E+00,
  0.56618560E+03, 0.137E+03, 0.240E+02, 0.97380000E+00, 0.00000000E+00,
  0.61264440E+03, 0.137E+03, 0.250E+02, 0.97380000E+00, 0.00000000E+00,
  0.48062360E+03, 0.137E+03, 0.260E+02, 0.97380000E+00, 0.00000000E+00,
  0.50159400E+03, 0.137E+03, 0.270E+02, 0.97380000E+00, 0.00000000E+00,
  0.51998260E+03, 0.137E+03, 0.280E+02, 0.97380000E+00, 0.00000000E+00,
  0.39935340E+03, 0.137E+03, 0.290E+02, 0.97380000E+00, 0.00000000E+00,
  0.40105480E+03, 0.137E+03, 0.300E+02, 0.97380000E+00, 0.00000000E+00,
  0.47797370E+03, 0.137E+03, 0.310E+02, 0.97380000E+00, 0.00000000E+00,
  0.41103890E+03, 0.137E+03, 0.320E+02, 0.97380000E+00, 0.00000000E+00,
  0.34339780E+03, 0.137E+03, 0.330E+02, 0.97380000E+00, 0.00000000E+00,
  0.30453120E+03, 0.137E+03, 0.340E+02, 0.97380000E+00, 0.00000000E+00,
  0.26345920E+03, 0.137E+03, 0.350E+02, 0.97380000E+00, 0.00000000E+00,
  0.22685900E+03, 0.137E+03, 0.360E+02, 0.97380000E+00, 0.00000000E+00,
  0.14577817E+04, 0.137E+03, 0.370E+02, 0.97380000E+00, 0.00000000E+00,
  0.12108108E+04, 0.137E+03, 0.380E+02, 0.97380000E+00, 0.00000000E+00,
  0.10374434E+04, 0.137E+03, 0.390E+02, 0.97380000E+00, 0.00000000E+00,
  0.92013580E+03, 0.137E+03, 0.400E+02, 0.97380000E+00, 0.00000000E+00,
  0.83213680E+03, 0.137E+03, 0.410E+02, 0.97380000E+00, 0.00000000E+00,
  0.63394710E+03, 0.137E+03, 0.420E+02, 0.97380000E+00, 0.00000000E+00,
  0.71077790E+03, 0.137E+03, 0.430E+02, 0.97380000E+00, 0.00000000E+00,
  0.53361350E+03, 0.137E+03, 0.440E+02, 0.97380000E+00, 0.00000000E+00,
  0.58237420E+03, 0.137E+03, 0.450E+02, 0.97380000E+00, 0.00000000E+00,
  0.53725650E+03, 0.137E+03, 0.460E+02, 0.97380000E+00, 0.00000000E+00,
  0.45047140E+03, 0.137E+03, 0.470E+02, 0.97380000E+00, 0.00000000E+00,
  0.47031190E+03, 0.137E+03, 0.480E+02, 0.97380000E+00, 0.00000000E+00,
  0.59989870E+03, 0.137E+03, 0.490E+02, 0.97380000E+00, 0.00000000E+00,
  0.54287770E+03, 0.137E+03, 0.500E+02, 0.97380000E+00, 0.00000000E+00,
  0.47456410E+03, 0.137E+03, 0.510E+02, 0.97380000E+00, 0.00000000E+00,
  0.43555550E+03, 0.137E+03, 0.520E+02, 0.97380000E+00, 0.00000000E+00,
  0.38946840E+03, 0.137E+03, 0.530E+02, 0.97380000E+00, 0.00000000E+00,
  0.34667910E+03, 0.137E+03, 0.540E+02, 0.97380000E+00, 0.00000000E+00,
  0.17768880E+04, 0.137E+03, 0.550E+02, 0.97380000E+00, 0.00000000E+00,
  0.15569958E+04, 0.137E+03, 0.560E+02, 0.97380000E+00, 0.00000000E+00,
  0.13375010E+04, 0.137E+03, 0.570E+02, 0.97380000E+00, 0.00000000E+00,
  0.56314800E+03, 0.137E+03, 0.580E+02, 0.97380000E+00, 0.27991000E+01,
  0.13695245E+04, 0.137E+03, 0.590E+02, 0.97380000E+00, 0.00000000E+00,
  0.13097014E+04, 0.137E+03, 0.600E+02, 0.97380000E+00, 0.00000000E+00,
  0.12753968E+04, 0.137E+03, 0.610E+02, 0.97380000E+00, 0.00000000E+00,
  0.12439950E+04, 0.137E+03, 0.620E+02, 0.97380000E+00, 0.00000000E+00,
  0.12161018E+04, 0.137E+03, 0.630E+02, 0.97380000E+00, 0.00000000E+00,
  0.93460820E+03, 0.137E+03, 0.640E+02, 0.97380000E+00, 0.00000000E+00,
  0.10930934E+04, 0.137E+03, 0.650E+02, 0.97380000E+00, 0.00000000E+00,
  0.10500925E+04, 0.137E+03, 0.660E+02, 0.97380000E+00, 0.00000000E+00,
  0.10903500E+04, 0.137E+03, 0.670E+02, 0.97380000E+00, 0.00000000E+00,
  0.10664469E+04, 0.137E+03, 0.680E+02, 0.97380000E+00, 0.00000000E+00,
  0.10446045E+04, 0.137E+03, 0.690E+02, 0.97380000E+00, 0.00000000E+00,
  0.10333196E+04, 0.137E+03, 0.700E+02, 0.97380000E+00, 0.00000000E+00,
  0.85724780E+03, 0.137E+03, 0.710E+02, 0.97380000E+00, 0.00000000E+00,
  0.82420500E+03, 0.137E+03, 0.720E+02, 0.97380000E+00, 0.00000000E+00,
  0.74273970E+03, 0.137E+03, 0.730E+02, 0.97380000E+00, 0.00000000E+00,
  0.62209770E+03, 0.137E+03, 0.740E+02, 0.97380000E+00, 0.00000000E+00,
  0.62947280E+03, 0.137E+03, 0.750E+02, 0.97380000E+00, 0.00000000E+00,
  0.56455160E+03, 0.137E+03, 0.760E+02, 0.97380000E+00, 0.00000000E+00,
  0.51279660E+03, 0.137E+03, 0.770E+02, 0.97380000E+00, 0.00000000E+00,
  0.42290190E+03, 0.137E+03, 0.780E+02, 0.97380000E+00, 0.00000000E+00,
  0.39392880E+03, 0.137E+03, 0.790E+02, 0.97380000E+00, 0.00000000E+00,
  0.40326450E+03, 0.137E+03, 0.800E+02, 0.97380000E+00, 0.00000000E+00,
  0.61404690E+03, 0.137E+03, 0.810E+02, 0.97380000E+00, 0.00000000E+00,
  0.58982750E+03, 0.137E+03, 0.820E+02, 0.97380000E+00, 0.00000000E+00,
  0.53239070E+03, 0.137E+03, 0.830E+02, 0.97380000E+00, 0.00000000E+00,
  0.50286730E+03, 0.137E+03, 0.840E+02, 0.97380000E+00, 0.00000000E+00,
  0.45900050E+03, 0.137E+03, 0.850E+02, 0.97380000E+00, 0.00000000E+00,
  0.41673210E+03, 0.137E+03, 0.860E+02, 0.97380000E+00, 0.00000000E+00,
  0.16476456E+04, 0.137E+03, 0.870E+02, 0.97380000E+00, 0.00000000E+00,
  0.15223656E+04, 0.137E+03, 0.880E+02, 0.97380000E+00, 0.00000000E+00,
  0.13176426E+04, 0.137E+03, 0.890E+02, 0.97380000E+00, 0.00000000E+00,
  0.11578649E+04, 0.137E+03, 0.900E+02, 0.97380000E+00, 0.00000000E+00,
  0.11634976E+04, 0.137E+03, 0.910E+02, 0.97380000E+00, 0.00000000E+00,
  0.11259076E+04, 0.137E+03, 0.920E+02, 0.97380000E+00, 0.00000000E+00,
  0.11753584E+04, 0.137E+03, 0.930E+02, 0.97380000E+00, 0.00000000E+00,
  0.11351209E+04, 0.137E+03, 0.940E+02, 0.97380000E+00, 0.00000000E+00,
  0.57903900E+02, 0.137E+03, 0.101E+03, 0.97380000E+00, 0.00000000E+00,
  0.19967710E+03, 0.137E+03, 0.103E+03, 0.97380000E+00, 0.98650000E+00,
  0.25295740E+03, 0.137E+03, 0.104E+03, 0.97380000E+00, 0.98080000E+00,
  0.18572060E+03, 0.137E+03, 0.105E+03, 0.97380000E+00, 0.97060000E+00,
  0.13721250E+03, 0.137E+03, 0.106E+03, 0.97380000E+00, 0.98680000E+00,
  0.93458400E+02, 0.137E+03, 0.107E+03, 0.97380000E+00, 0.99440000E+00,
  0.67004500E+02, 0.137E+03, 0.108E+03, 0.97380000E+00, 0.99250000E+00,
  0.45248900E+02, 0.137E+03, 0.109E+03, 0.97380000E+00, 0.99820000E+00,
  0.29467950E+03, 0.137E+03, 0.111E+03, 0.97380000E+00, 0.96840000E+00,
  0.45778310E+03, 0.137E+03, 0.112E+03, 0.97380000E+00, 0.96280000E+00,
  0.45336360E+03, 0.137E+03, 0.113E+03, 0.97380000E+00, 0.96480000E+00,
  0.35341420E+03, 0.137E+03, 0.114E+03, 0.97380000E+00, 0.95070000E+00,
  0.28343680E+03, 0.137E+03, 0.115E+03, 0.97380000E+00, 0.99470000E+00,
  0.23654670E+03, 0.137E+03, 0.116E+03, 0.97380000E+00, 0.99480000E+00,
  0.19086020E+03, 0.137E+03, 0.117E+03, 0.97380000E+00, 0.99720000E+00,
  0.40103710E+03, 0.137E+03, 0.119E+03, 0.97380000E+00, 0.97670000E+00,
  0.81234890E+03, 0.137E+03, 0.120E+03, 0.97380000E+00, 0.98310000E+00,
  0.38990570E+03, 0.137E+03, 0.121E+03, 0.97380000E+00, 0.18627000E+01,
  0.37639190E+03, 0.137E+03, 0.122E+03, 0.97380000E+00, 0.18299000E+01,
  0.36906490E+03, 0.137E+03, 0.123E+03, 0.97380000E+00, 0.19138000E+01,
  0.36686860E+03, 0.137E+03, 0.124E+03, 0.97380000E+00, 0.18269000E+01,
  0.33222150E+03, 0.137E+03, 0.125E+03, 0.97380000E+00, 0.16406000E+01,
  0.30627200E+03, 0.137E+03, 0.126E+03, 0.97380000E+00, 0.16483000E+01,
  0.29229920E+03, 0.137E+03, 0.127E+03, 0.97380000E+00, 0.17149000E+01,
  0.28612410E+03, 0.137E+03, 0.128E+03, 0.97380000E+00, 0.17937000E+01,
  0.28601310E+03, 0.137E+03, 0.129E+03, 0.97380000E+00, 0.95760000E+00,
  0.26273320E+03, 0.137E+03, 0.130E+03, 0.97380000E+00, 0.19419000E+01,
  0.44607980E+03, 0.137E+03, 0.131E+03, 0.97380000E+00, 0.96010000E+00,
  0.38250120E+03, 0.137E+03, 0.132E+03, 0.97380000E+00, 0.94340000E+00,
  0.33721600E+03, 0.137E+03, 0.133E+03, 0.97380000E+00, 0.98890000E+00,
  0.30472790E+03, 0.137E+03, 0.134E+03, 0.97380000E+00, 0.99010000E+00,
  0.26546470E+03, 0.137E+03, 0.135E+03, 0.97380000E+00, 0.99740000E+00,
  0.47625910E+03, 0.137E+03, 0.137E+03, 0.97380000E+00, 0.97380000E+00,
  0.64406500E+02, 0.138E+03, 0.100E+01, 0.98010000E+00, 0.91180000E+00,
  0.38833300E+02, 0.138E+03, 0.200E+01, 0.98010000E+00, 0.00000000E+00,
  0.16182465E+04, 0.138E+03, 0.300E+01, 0.98010000E+00, 0.00000000E+00,
  0.73479260E+03, 0.138E+03, 0.400E+01, 0.98010000E+00, 0.00000000E+00,
  0.44112610E+03, 0.138E+03, 0.500E+01, 0.98010000E+00, 0.00000000E+00,
  0.27470310E+03, 0.138E+03, 0.600E+01, 0.98010000E+00, 0.00000000E+00,
  0.18119730E+03, 0.138E+03, 0.700E+01, 0.98010000E+00, 0.00000000E+00,
  0.13178460E+03, 0.138E+03, 0.800E+01, 0.98010000E+00, 0.00000000E+00,
  0.96508000E+02, 0.138E+03, 0.900E+01, 0.98010000E+00, 0.00000000E+00,
  0.72270300E+02, 0.138E+03, 0.100E+02, 0.98010000E+00, 0.00000000E+00,
  0.19079592E+04, 0.138E+03, 0.110E+02, 0.98010000E+00, 0.00000000E+00,
  0.12181274E+04, 0.138E+03, 0.120E+02, 0.98010000E+00, 0.00000000E+00,
  0.10570218E+04, 0.138E+03, 0.130E+02, 0.98010000E+00, 0.00000000E+00,
  0.76638470E+03, 0.138E+03, 0.140E+02, 0.98010000E+00, 0.00000000E+00,
  0.55938210E+03, 0.138E+03, 0.150E+02, 0.98010000E+00, 0.00000000E+00,
  0.44578600E+03, 0.138E+03, 0.160E+02, 0.98010000E+00, 0.00000000E+00,
  0.35042730E+03, 0.138E+03, 0.170E+02, 0.98010000E+00, 0.00000000E+00,
  0.27747590E+03, 0.138E+03, 0.180E+02, 0.98010000E+00, 0.00000000E+00,
  0.33022504E+04, 0.138E+03, 0.190E+02, 0.98010000E+00, 0.00000000E+00,
  0.23148420E+04, 0.138E+03, 0.200E+02, 0.98010000E+00, 0.00000000E+00,
  0.18497319E+04, 0.138E+03, 0.210E+02, 0.98010000E+00, 0.00000000E+00,
  0.17407410E+04, 0.138E+03, 0.220E+02, 0.98010000E+00, 0.00000000E+00,
  0.15682263E+04, 0.138E+03, 0.230E+02, 0.98010000E+00, 0.00000000E+00,
  0.12385036E+04, 0.138E+03, 0.240E+02, 0.98010000E+00, 0.00000000E+00,
  0.13188096E+04, 0.138E+03, 0.250E+02, 0.98010000E+00, 0.00000000E+00,
  0.10340602E+04, 0.138E+03, 0.260E+02, 0.98010000E+00, 0.00000000E+00,
  0.10522336E+04, 0.138E+03, 0.270E+02, 0.98010000E+00, 0.00000000E+00,
  0.11016666E+04, 0.138E+03, 0.280E+02, 0.98010000E+00, 0.00000000E+00,
  0.84879520E+03, 0.138E+03, 0.290E+02, 0.98010000E+00, 0.00000000E+00,
  0.82251670E+03, 0.138E+03, 0.300E+02, 0.98010000E+00, 0.00000000E+00,
  0.99191230E+03, 0.138E+03, 0.310E+02, 0.98010000E+00, 0.00000000E+00,
  0.81848870E+03, 0.138E+03, 0.320E+02, 0.98010000E+00, 0.00000000E+00,
  0.66009280E+03, 0.138E+03, 0.330E+02, 0.98010000E+00, 0.00000000E+00,
  0.57308500E+03, 0.138E+03, 0.340E+02, 0.98010000E+00, 0.00000000E+00,
  0.48506500E+03, 0.138E+03, 0.350E+02, 0.98010000E+00, 0.00000000E+00,
  0.40937610E+03, 0.138E+03, 0.360E+02, 0.98010000E+00, 0.00000000E+00,
  0.36709261E+04, 0.138E+03, 0.370E+02, 0.98010000E+00, 0.00000000E+00,
  0.27824577E+04, 0.138E+03, 0.380E+02, 0.98010000E+00, 0.00000000E+00,
  0.23056086E+04, 0.138E+03, 0.390E+02, 0.98010000E+00, 0.00000000E+00,
  0.20037829E+04, 0.138E+03, 0.400E+02, 0.98010000E+00, 0.00000000E+00,
  0.17897638E+04, 0.138E+03, 0.410E+02, 0.98010000E+00, 0.00000000E+00,
  0.13350700E+04, 0.138E+03, 0.420E+02, 0.98010000E+00, 0.00000000E+00,
  0.15092981E+04, 0.138E+03, 0.430E+02, 0.98010000E+00, 0.00000000E+00,
  0.11061259E+04, 0.138E+03, 0.440E+02, 0.98010000E+00, 0.00000000E+00,
  0.12034301E+04, 0.138E+03, 0.450E+02, 0.98010000E+00, 0.00000000E+00,
  0.11005370E+04, 0.138E+03, 0.460E+02, 0.98010000E+00, 0.00000000E+00,
  0.93160220E+03, 0.138E+03, 0.470E+02, 0.98010000E+00, 0.00000000E+00,
  0.95275330E+03, 0.138E+03, 0.480E+02, 0.98010000E+00, 0.00000000E+00,
  0.12501173E+04, 0.138E+03, 0.490E+02, 0.98010000E+00, 0.00000000E+00,
  0.10916636E+04, 0.138E+03, 0.500E+02, 0.98010000E+00, 0.00000000E+00,
  0.92413690E+03, 0.138E+03, 0.510E+02, 0.98010000E+00, 0.00000000E+00,
  0.83250600E+03, 0.138E+03, 0.520E+02, 0.98010000E+00, 0.00000000E+00,
  0.72971760E+03, 0.138E+03, 0.530E+02, 0.98010000E+00, 0.00000000E+00,
  0.63746600E+03, 0.138E+03, 0.540E+02, 0.98010000E+00, 0.00000000E+00,
  0.44969846E+04, 0.138E+03, 0.550E+02, 0.98010000E+00, 0.00000000E+00,
  0.36314540E+04, 0.138E+03, 0.560E+02, 0.98010000E+00, 0.00000000E+00,
  0.30140781E+04, 0.138E+03, 0.570E+02, 0.98010000E+00, 0.00000000E+00,
  0.11044325E+04, 0.138E+03, 0.580E+02, 0.98010000E+00, 0.27991000E+01,
  0.31621198E+04, 0.138E+03, 0.590E+02, 0.98010000E+00, 0.00000000E+00,
  0.29999283E+04, 0.138E+03, 0.600E+02, 0.98010000E+00, 0.00000000E+00,
  0.29157949E+04, 0.138E+03, 0.610E+02, 0.98010000E+00, 0.00000000E+00,
  0.28393501E+04, 0.138E+03, 0.620E+02, 0.98010000E+00, 0.00000000E+00,
  0.27713234E+04, 0.138E+03, 0.630E+02, 0.98010000E+00, 0.00000000E+00,
  0.20594692E+04, 0.138E+03, 0.640E+02, 0.98010000E+00, 0.00000000E+00,
  0.25668729E+04, 0.138E+03, 0.650E+02, 0.98010000E+00, 0.00000000E+00,
  0.24578402E+04, 0.138E+03, 0.660E+02, 0.98010000E+00, 0.00000000E+00,
  0.24609470E+04, 0.138E+03, 0.670E+02, 0.98010000E+00, 0.00000000E+00,
  0.24041111E+04, 0.138E+03, 0.680E+02, 0.98010000E+00, 0.00000000E+00,
  0.23512803E+04, 0.138E+03, 0.690E+02, 0.98010000E+00, 0.00000000E+00,
  0.23289369E+04, 0.138E+03, 0.700E+02, 0.98010000E+00, 0.00000000E+00,
  0.18927447E+04, 0.138E+03, 0.710E+02, 0.98010000E+00, 0.00000000E+00,
  0.17529565E+04, 0.138E+03, 0.720E+02, 0.98010000E+00, 0.00000000E+00,
  0.15479897E+04, 0.138E+03, 0.730E+02, 0.98010000E+00, 0.00000000E+00,
  0.12804929E+04, 0.138E+03, 0.740E+02, 0.98010000E+00, 0.00000000E+00,
  0.12840434E+04, 0.138E+03, 0.750E+02, 0.98010000E+00, 0.00000000E+00,
  0.11312913E+04, 0.138E+03, 0.760E+02, 0.98010000E+00, 0.00000000E+00,
  0.10131095E+04, 0.138E+03, 0.770E+02, 0.98010000E+00, 0.00000000E+00,
  0.82466090E+03, 0.138E+03, 0.780E+02, 0.98010000E+00, 0.00000000E+00,
  0.76388530E+03, 0.138E+03, 0.790E+02, 0.98010000E+00, 0.00000000E+00,
  0.77550460E+03, 0.138E+03, 0.800E+02, 0.98010000E+00, 0.00000000E+00,
  0.12742283E+04, 0.138E+03, 0.810E+02, 0.98010000E+00, 0.00000000E+00,
  0.11873359E+04, 0.138E+03, 0.820E+02, 0.98010000E+00, 0.00000000E+00,
  0.10400523E+04, 0.138E+03, 0.830E+02, 0.98010000E+00, 0.00000000E+00,
  0.96630350E+03, 0.138E+03, 0.840E+02, 0.98010000E+00, 0.00000000E+00,
  0.86500840E+03, 0.138E+03, 0.850E+02, 0.98010000E+00, 0.00000000E+00,
  0.77178770E+03, 0.138E+03, 0.860E+02, 0.98010000E+00, 0.00000000E+00,
  0.40533897E+04, 0.138E+03, 0.870E+02, 0.98010000E+00, 0.00000000E+00,
  0.34910837E+04, 0.138E+03, 0.880E+02, 0.98010000E+00, 0.00000000E+00,
  0.29248174E+04, 0.138E+03, 0.890E+02, 0.98010000E+00, 0.00000000E+00,
  0.24812627E+04, 0.138E+03, 0.900E+02, 0.98010000E+00, 0.00000000E+00,
  0.25425532E+04, 0.138E+03, 0.910E+02, 0.98010000E+00, 0.00000000E+00,
  0.24572393E+04, 0.138E+03, 0.920E+02, 0.98010000E+00, 0.00000000E+00,
  0.26180036E+04, 0.138E+03, 0.930E+02, 0.98010000E+00, 0.00000000E+00,
  0.25175053E+04, 0.138E+03, 0.940E+02, 0.98010000E+00, 0.00000000E+00,
  0.11032750E+03, 0.138E+03, 0.101E+03, 0.98010000E+00, 0.00000000E+00,
  0.42146100E+03, 0.138E+03, 0.103E+03, 0.98010000E+00, 0.98650000E+00,
  0.52954940E+03, 0.138E+03, 0.104E+03, 0.98010000E+00, 0.98080000E+00,
  0.36336070E+03, 0.138E+03, 0.105E+03, 0.98010000E+00, 0.97060000E+00,
  0.25898850E+03, 0.138E+03, 0.106E+03, 0.98010000E+00, 0.98680000E+00,
  0.16917720E+03, 0.138E+03, 0.107E+03, 0.98010000E+00, 0.99440000E+00,
  0.11710180E+03, 0.138E+03, 0.108E+03, 0.98010000E+00, 0.99250000E+00,
  0.75675800E+02, 0.138E+03, 0.109E+03, 0.98010000E+00, 0.99820000E+00,
  0.63083040E+03, 0.138E+03, 0.111E+03, 0.98010000E+00, 0.96840000E+00,
  0.98878570E+03, 0.138E+03, 0.112E+03, 0.98010000E+00, 0.96280000E+00,
  0.94475350E+03, 0.138E+03, 0.113E+03, 0.98010000E+00, 0.96480000E+00,
  0.70100090E+03, 0.138E+03, 0.114E+03, 0.98010000E+00, 0.95070000E+00,
  0.54212620E+03, 0.138E+03, 0.115E+03, 0.98010000E+00, 0.99470000E+00,
  0.44147190E+03, 0.138E+03, 0.116E+03, 0.98010000E+00, 0.99480000E+00,
  0.34712550E+03, 0.138E+03, 0.117E+03, 0.98010000E+00, 0.99720000E+00,
  0.84199830E+03, 0.138E+03, 0.119E+03, 0.98010000E+00, 0.97670000E+00,
  0.18769417E+04, 0.138E+03, 0.120E+03, 0.98010000E+00, 0.98310000E+00,
  0.77994880E+03, 0.138E+03, 0.121E+03, 0.98010000E+00, 0.18627000E+01,
  0.75467530E+03, 0.138E+03, 0.122E+03, 0.98010000E+00, 0.18299000E+01,
  0.74017630E+03, 0.138E+03, 0.123E+03, 0.98010000E+00, 0.19138000E+01,
  0.73983150E+03, 0.138E+03, 0.124E+03, 0.98010000E+00, 0.18269000E+01,
  0.65184050E+03, 0.138E+03, 0.125E+03, 0.98010000E+00, 0.16406000E+01,
  0.59697670E+03, 0.138E+03, 0.126E+03, 0.98010000E+00, 0.16483000E+01,
  0.57030240E+03, 0.138E+03, 0.127E+03, 0.98010000E+00, 0.17149000E+01,
  0.55938830E+03, 0.138E+03, 0.128E+03, 0.98010000E+00, 0.17937000E+01,
  0.56991510E+03, 0.138E+03, 0.129E+03, 0.98010000E+00, 0.95760000E+00,
  0.50526080E+03, 0.138E+03, 0.130E+03, 0.98010000E+00, 0.19419000E+01,
  0.91623120E+03, 0.138E+03, 0.131E+03, 0.98010000E+00, 0.96010000E+00,
  0.75505840E+03, 0.138E+03, 0.132E+03, 0.98010000E+00, 0.94340000E+00,
  0.64702200E+03, 0.138E+03, 0.133E+03, 0.98010000E+00, 0.98890000E+00,
  0.57371350E+03, 0.138E+03, 0.134E+03, 0.98010000E+00, 0.99010000E+00,
  0.48934610E+03, 0.138E+03, 0.135E+03, 0.98010000E+00, 0.99740000E+00,
  0.99279700E+03, 0.138E+03, 0.137E+03, 0.98010000E+00, 0.97380000E+00,
  0.23126602E+04, 0.138E+03, 0.138E+03, 0.98010000E+00, 0.98010000E+00,
  0.51235600E+02, 0.139E+03, 0.100E+01, 0.19153000E+01, 0.91180000E+00,
  0.31988900E+02, 0.139E+03, 0.200E+01, 0.19153000E+01, 0.00000000E+00,
  0.10745875E+04, 0.139E+03, 0.300E+01, 0.19153000E+01, 0.00000000E+00,
  0.53251100E+03, 0.139E+03, 0.400E+01, 0.19153000E+01, 0.00000000E+00,
  0.33413510E+03, 0.139E+03, 0.500E+01, 0.19153000E+01, 0.00000000E+00,
  0.21477600E+03, 0.139E+03, 0.600E+01, 0.19153000E+01, 0.00000000E+00,
  0.14492070E+03, 0.139E+03, 0.700E+01, 0.19153000E+01, 0.00000000E+00,
  0.10704380E+03, 0.139E+03, 0.800E+01, 0.19153000E+01, 0.00000000E+00,
  0.79407600E+02, 0.139E+03, 0.900E+01, 0.19153000E+01, 0.00000000E+00,
  0.60062800E+02, 0.139E+03, 0.100E+02, 0.19153000E+01, 0.00000000E+00,
  0.12727028E+04, 0.139E+03, 0.110E+02, 0.19153000E+01, 0.00000000E+00,
  0.86937390E+03, 0.139E+03, 0.120E+02, 0.19153000E+01, 0.00000000E+00,
  0.77186060E+03, 0.139E+03, 0.130E+02, 0.19153000E+01, 0.00000000E+00,
  0.57805500E+03, 0.139E+03, 0.140E+02, 0.19153000E+01, 0.00000000E+00,
  0.43301710E+03, 0.139E+03, 0.150E+02, 0.19153000E+01, 0.00000000E+00,
  0.35057750E+03, 0.139E+03, 0.160E+02, 0.19153000E+01, 0.00000000E+00,
  0.27973550E+03, 0.139E+03, 0.170E+02, 0.19153000E+01, 0.00000000E+00,
  0.22431260E+03, 0.139E+03, 0.180E+02, 0.19153000E+01, 0.00000000E+00,
  0.21637031E+04, 0.139E+03, 0.190E+02, 0.19153000E+01, 0.00000000E+00,
  0.16036362E+04, 0.139E+03, 0.200E+02, 0.19153000E+01, 0.00000000E+00,
  0.12972964E+04, 0.139E+03, 0.210E+02, 0.19153000E+01, 0.00000000E+00,
  0.12323433E+04, 0.139E+03, 0.220E+02, 0.19153000E+01, 0.00000000E+00,
  0.11169531E+04, 0.139E+03, 0.230E+02, 0.19153000E+01, 0.00000000E+00,
  0.88060690E+03, 0.139E+03, 0.240E+02, 0.19153000E+01, 0.00000000E+00,
  0.94758340E+03, 0.139E+03, 0.250E+02, 0.19153000E+01, 0.00000000E+00,
  0.74266410E+03, 0.139E+03, 0.260E+02, 0.19153000E+01, 0.00000000E+00,
  0.76821070E+03, 0.139E+03, 0.270E+02, 0.19153000E+01, 0.00000000E+00,
  0.79937100E+03, 0.139E+03, 0.280E+02, 0.19153000E+01, 0.00000000E+00,
  0.61409830E+03, 0.139E+03, 0.290E+02, 0.19153000E+01, 0.00000000E+00,
  0.60904990E+03, 0.139E+03, 0.300E+02, 0.19153000E+01, 0.00000000E+00,
  0.72958130E+03, 0.139E+03, 0.310E+02, 0.19153000E+01, 0.00000000E+00,
  0.61799850E+03, 0.139E+03, 0.320E+02, 0.19153000E+01, 0.00000000E+00,
  0.50955030E+03, 0.139E+03, 0.330E+02, 0.19153000E+01, 0.00000000E+00,
  0.44813810E+03, 0.139E+03, 0.340E+02, 0.19153000E+01, 0.00000000E+00,
  0.38429010E+03, 0.139E+03, 0.350E+02, 0.19153000E+01, 0.00000000E+00,
  0.32813160E+03, 0.139E+03, 0.360E+02, 0.19153000E+01, 0.00000000E+00,
  0.24114577E+04, 0.139E+03, 0.370E+02, 0.19153000E+01, 0.00000000E+00,
  0.19209295E+04, 0.139E+03, 0.380E+02, 0.19153000E+01, 0.00000000E+00,
  0.16243636E+04, 0.139E+03, 0.390E+02, 0.19153000E+01, 0.00000000E+00,
  0.14293576E+04, 0.139E+03, 0.400E+02, 0.19153000E+01, 0.00000000E+00,
  0.12864770E+04, 0.139E+03, 0.410E+02, 0.19153000E+01, 0.00000000E+00,
  0.97159590E+03, 0.139E+03, 0.420E+02, 0.19153000E+01, 0.00000000E+00,
  0.10932424E+04, 0.139E+03, 0.430E+02, 0.19153000E+01, 0.00000000E+00,
  0.81262860E+03, 0.139E+03, 0.440E+02, 0.19153000E+01, 0.00000000E+00,
  0.88627500E+03, 0.139E+03, 0.450E+02, 0.19153000E+01, 0.00000000E+00,
  0.81484020E+03, 0.139E+03, 0.460E+02, 0.19153000E+01, 0.00000000E+00,
  0.68497960E+03, 0.139E+03, 0.470E+02, 0.19153000E+01, 0.00000000E+00,
  0.71021720E+03, 0.139E+03, 0.480E+02, 0.19153000E+01, 0.00000000E+00,
  0.91615920E+03, 0.139E+03, 0.490E+02, 0.19153000E+01, 0.00000000E+00,
  0.81841300E+03, 0.139E+03, 0.500E+02, 0.19153000E+01, 0.00000000E+00,
  0.70709330E+03, 0.139E+03, 0.510E+02, 0.19153000E+01, 0.00000000E+00,
  0.64444940E+03, 0.139E+03, 0.520E+02, 0.19153000E+01, 0.00000000E+00,
  0.57184320E+03, 0.139E+03, 0.530E+02, 0.19153000E+01, 0.00000000E+00,
  0.50522620E+03, 0.139E+03, 0.540E+02, 0.19153000E+01, 0.00000000E+00,
  0.29502475E+04, 0.139E+03, 0.550E+02, 0.19153000E+01, 0.00000000E+00,
  0.24856310E+04, 0.139E+03, 0.560E+02, 0.19153000E+01, 0.00000000E+00,
  0.21057491E+04, 0.139E+03, 0.570E+02, 0.19153000E+01, 0.00000000E+00,
  0.84084100E+03, 0.139E+03, 0.580E+02, 0.19153000E+01, 0.27991000E+01,
  0.21783229E+04, 0.139E+03, 0.590E+02, 0.19153000E+01, 0.00000000E+00,
  0.20748807E+04, 0.139E+03, 0.600E+02, 0.19153000E+01, 0.00000000E+00,
  0.20189224E+04, 0.139E+03, 0.610E+02, 0.19153000E+01, 0.00000000E+00,
  0.19678827E+04, 0.139E+03, 0.620E+02, 0.19153000E+01, 0.00000000E+00,
  0.19225226E+04, 0.139E+03, 0.630E+02, 0.19153000E+01, 0.00000000E+00,
  0.14581969E+04, 0.139E+03, 0.640E+02, 0.19153000E+01, 0.00000000E+00,
  0.17521144E+04, 0.139E+03, 0.650E+02, 0.19153000E+01, 0.00000000E+00,
  0.16830549E+04, 0.139E+03, 0.660E+02, 0.19153000E+01, 0.00000000E+00,
  0.17170123E+04, 0.139E+03, 0.670E+02, 0.19153000E+01, 0.00000000E+00,
  0.16785781E+04, 0.139E+03, 0.680E+02, 0.19153000E+01, 0.00000000E+00,
  0.16432139E+04, 0.139E+03, 0.690E+02, 0.19153000E+01, 0.00000000E+00,
  0.16263339E+04, 0.139E+03, 0.700E+02, 0.19153000E+01, 0.00000000E+00,
  0.13398149E+04, 0.139E+03, 0.710E+02, 0.19153000E+01, 0.00000000E+00,
  0.12689492E+04, 0.139E+03, 0.720E+02, 0.19153000E+01, 0.00000000E+00,
  0.11346407E+04, 0.139E+03, 0.730E+02, 0.19153000E+01, 0.00000000E+00,
  0.94540990E+03, 0.139E+03, 0.740E+02, 0.19153000E+01, 0.00000000E+00,
  0.95356340E+03, 0.139E+03, 0.750E+02, 0.19153000E+01, 0.00000000E+00,
  0.84938170E+03, 0.139E+03, 0.760E+02, 0.19153000E+01, 0.00000000E+00,
  0.76730030E+03, 0.139E+03, 0.770E+02, 0.19153000E+01, 0.00000000E+00,
  0.62916050E+03, 0.139E+03, 0.780E+02, 0.19153000E+01, 0.00000000E+00,
  0.58463530E+03, 0.139E+03, 0.790E+02, 0.19153000E+01, 0.00000000E+00,
  0.59694450E+03, 0.139E+03, 0.800E+02, 0.19153000E+01, 0.00000000E+00,
  0.93562990E+03, 0.139E+03, 0.810E+02, 0.19153000E+01, 0.00000000E+00,
  0.88887560E+03, 0.139E+03, 0.820E+02, 0.19153000E+01, 0.00000000E+00,
  0.79367010E+03, 0.139E+03, 0.830E+02, 0.19153000E+01, 0.00000000E+00,
  0.74514710E+03, 0.139E+03, 0.840E+02, 0.19153000E+01, 0.00000000E+00,
  0.67518420E+03, 0.139E+03, 0.850E+02, 0.19153000E+01, 0.00000000E+00,
  0.60886250E+03, 0.139E+03, 0.860E+02, 0.19153000E+01, 0.00000000E+00,
  0.26980970E+04, 0.139E+03, 0.870E+02, 0.19153000E+01, 0.00000000E+00,
  0.24134225E+04, 0.139E+03, 0.880E+02, 0.19153000E+01, 0.00000000E+00,
  0.20622685E+04, 0.139E+03, 0.890E+02, 0.19153000E+01, 0.00000000E+00,
  0.17871863E+04, 0.139E+03, 0.900E+02, 0.19153000E+01, 0.00000000E+00,
  0.18092861E+04, 0.139E+03, 0.910E+02, 0.19153000E+01, 0.00000000E+00,
  0.17497379E+04, 0.139E+03, 0.920E+02, 0.19153000E+01, 0.00000000E+00,
  0.18406901E+04, 0.139E+03, 0.930E+02, 0.19153000E+01, 0.00000000E+00,
  0.17746391E+04, 0.139E+03, 0.940E+02, 0.19153000E+01, 0.00000000E+00,
  0.85681500E+02, 0.139E+03, 0.101E+03, 0.19153000E+01, 0.00000000E+00,
  0.30688620E+03, 0.139E+03, 0.103E+03, 0.19153000E+01, 0.98650000E+00,
  0.38765640E+03, 0.139E+03, 0.104E+03, 0.19153000E+01, 0.98080000E+00,
  0.27740500E+03, 0.139E+03, 0.105E+03, 0.19153000E+01, 0.97060000E+00,
  0.20197440E+03, 0.139E+03, 0.106E+03, 0.19153000E+01, 0.98680000E+00,
  0.13518390E+03, 0.139E+03, 0.107E+03, 0.19153000E+01, 0.99440000E+00,
  0.95445800E+02, 0.139E+03, 0.108E+03, 0.19153000E+01, 0.99250000E+00,
  0.63188900E+02, 0.139E+03, 0.109E+03, 0.19153000E+01, 0.99820000E+00,
  0.45499280E+03, 0.139E+03, 0.111E+03, 0.19153000E+01, 0.96840000E+00,
  0.70969610E+03, 0.139E+03, 0.112E+03, 0.19153000E+01, 0.96280000E+00,
  0.69347320E+03, 0.139E+03, 0.113E+03, 0.19153000E+01, 0.96480000E+00,
  0.53081800E+03, 0.139E+03, 0.114E+03, 0.19153000E+01, 0.95070000E+00,
  0.41987180E+03, 0.139E+03, 0.115E+03, 0.19153000E+01, 0.99470000E+00,
  0.34697100E+03, 0.139E+03, 0.116E+03, 0.19153000E+01, 0.99480000E+00,
  0.27697730E+03, 0.139E+03, 0.117E+03, 0.19153000E+01, 0.99720000E+00,
  0.61384630E+03, 0.139E+03, 0.119E+03, 0.19153000E+01, 0.97670000E+00,
  0.12935159E+04, 0.139E+03, 0.120E+03, 0.19153000E+01, 0.98310000E+00,
  0.58631350E+03, 0.139E+03, 0.121E+03, 0.19153000E+01, 0.18627000E+01,
  0.56686700E+03, 0.139E+03, 0.122E+03, 0.19153000E+01, 0.18299000E+01,
  0.55572150E+03, 0.139E+03, 0.123E+03, 0.19153000E+01, 0.19138000E+01,
  0.55347640E+03, 0.139E+03, 0.124E+03, 0.19153000E+01, 0.18269000E+01,
  0.49633310E+03, 0.139E+03, 0.125E+03, 0.19153000E+01, 0.16406000E+01,
  0.45638780E+03, 0.139E+03, 0.126E+03, 0.19153000E+01, 0.16483000E+01,
  0.43567010E+03, 0.139E+03, 0.127E+03, 0.19153000E+01, 0.17149000E+01,
  0.42674050E+03, 0.139E+03, 0.128E+03, 0.19153000E+01, 0.17937000E+01,
  0.42937430E+03, 0.139E+03, 0.129E+03, 0.19153000E+01, 0.95760000E+00,
  0.38958110E+03, 0.139E+03, 0.130E+03, 0.19153000E+01, 0.19419000E+01,
  0.67825900E+03, 0.139E+03, 0.131E+03, 0.19153000E+01, 0.96010000E+00,
  0.57321390E+03, 0.139E+03, 0.132E+03, 0.19153000E+01, 0.94340000E+00,
  0.50000710E+03, 0.139E+03, 0.133E+03, 0.19153000E+01, 0.98890000E+00,
  0.44848720E+03, 0.139E+03, 0.134E+03, 0.19153000E+01, 0.99010000E+00,
  0.38738760E+03, 0.139E+03, 0.135E+03, 0.19153000E+01, 0.99740000E+00,
  0.72686130E+03, 0.139E+03, 0.137E+03, 0.19153000E+01, 0.97380000E+00,
  0.15865402E+04, 0.139E+03, 0.138E+03, 0.19153000E+01, 0.98010000E+00,
  0.11322983E+04, 0.139E+03, 0.139E+03, 0.19153000E+01, 0.19153000E+01,
  0.39666900E+02, 0.140E+03, 0.100E+01, 0.19355000E+01, 0.91180000E+00,
  0.25703700E+02, 0.140E+03, 0.200E+01, 0.19355000E+01, 0.00000000E+00,
  0.67848100E+03, 0.140E+03, 0.300E+01, 0.19355000E+01, 0.00000000E+00,
  0.37401350E+03, 0.140E+03, 0.400E+01, 0.19355000E+01, 0.00000000E+00,
  0.24601470E+03, 0.140E+03, 0.500E+01, 0.19355000E+01, 0.00000000E+00,
  0.16345480E+03, 0.140E+03, 0.600E+01, 0.19355000E+01, 0.00000000E+00,
  0.11293390E+03, 0.140E+03, 0.700E+01, 0.19355000E+01, 0.00000000E+00,
  0.84787600E+02, 0.140E+03, 0.800E+01, 0.19355000E+01, 0.00000000E+00,
  0.63768000E+02, 0.140E+03, 0.900E+01, 0.19355000E+01, 0.00000000E+00,
  0.48760000E+02, 0.140E+03, 0.100E+02, 0.19355000E+01, 0.00000000E+00,
  0.80899730E+03, 0.140E+03, 0.110E+02, 0.19355000E+01, 0.00000000E+00,
  0.60055110E+03, 0.140E+03, 0.120E+02, 0.19355000E+01, 0.00000000E+00,
  0.54671760E+03, 0.140E+03, 0.130E+02, 0.19355000E+01, 0.00000000E+00,
  0.42369920E+03, 0.140E+03, 0.140E+02, 0.19355000E+01, 0.00000000E+00,
  0.32600870E+03, 0.140E+03, 0.150E+02, 0.19355000E+01, 0.00000000E+00,
  0.26830770E+03, 0.140E+03, 0.160E+02, 0.19355000E+01, 0.00000000E+00,
  0.21743220E+03, 0.140E+03, 0.170E+02, 0.19355000E+01, 0.00000000E+00,
  0.17666900E+03, 0.140E+03, 0.180E+02, 0.19355000E+01, 0.00000000E+00,
  0.13359899E+04, 0.140E+03, 0.190E+02, 0.19355000E+01, 0.00000000E+00,
  0.10709104E+04, 0.140E+03, 0.200E+02, 0.19355000E+01, 0.00000000E+00,
  0.87901650E+03, 0.140E+03, 0.210E+02, 0.19355000E+01, 0.00000000E+00,
  0.84415650E+03, 0.140E+03, 0.220E+02, 0.19355000E+01, 0.00000000E+00,
  0.77041850E+03, 0.140E+03, 0.230E+02, 0.19355000E+01, 0.00000000E+00,
  0.60670400E+03, 0.140E+03, 0.240E+02, 0.19355000E+01, 0.00000000E+00,
  0.66010050E+03, 0.140E+03, 0.250E+02, 0.19355000E+01, 0.00000000E+00,
  0.51758120E+03, 0.140E+03, 0.260E+02, 0.19355000E+01, 0.00000000E+00,
  0.54466430E+03, 0.140E+03, 0.270E+02, 0.19355000E+01, 0.00000000E+00,
  0.56293440E+03, 0.140E+03, 0.280E+02, 0.19355000E+01, 0.00000000E+00,
  0.43155440E+03, 0.140E+03, 0.290E+02, 0.19355000E+01, 0.00000000E+00,
  0.43840800E+03, 0.140E+03, 0.300E+02, 0.19355000E+01, 0.00000000E+00,
  0.52118020E+03, 0.140E+03, 0.310E+02, 0.19355000E+01, 0.00000000E+00,
  0.45369050E+03, 0.140E+03, 0.320E+02, 0.19355000E+01, 0.00000000E+00,
  0.38264580E+03, 0.140E+03, 0.330E+02, 0.19355000E+01, 0.00000000E+00,
  0.34103380E+03, 0.140E+03, 0.340E+02, 0.19355000E+01, 0.00000000E+00,
  0.29639440E+03, 0.140E+03, 0.350E+02, 0.19355000E+01, 0.00000000E+00,
  0.25615010E+03, 0.140E+03, 0.360E+02, 0.19355000E+01, 0.00000000E+00,
  0.14937993E+04, 0.140E+03, 0.370E+02, 0.19355000E+01, 0.00000000E+00,
  0.12775813E+04, 0.140E+03, 0.380E+02, 0.19355000E+01, 0.00000000E+00,
  0.11066630E+04, 0.140E+03, 0.390E+02, 0.19355000E+01, 0.00000000E+00,
  0.98782570E+03, 0.140E+03, 0.400E+02, 0.19355000E+01, 0.00000000E+00,
  0.89679520E+03, 0.140E+03, 0.410E+02, 0.19355000E+01, 0.00000000E+00,
  0.68718480E+03, 0.140E+03, 0.420E+02, 0.19355000E+01, 0.00000000E+00,
  0.76884280E+03, 0.140E+03, 0.430E+02, 0.19355000E+01, 0.00000000E+00,
  0.58090070E+03, 0.140E+03, 0.440E+02, 0.19355000E+01, 0.00000000E+00,
  0.63480240E+03, 0.140E+03, 0.450E+02, 0.19355000E+01, 0.00000000E+00,
  0.58702020E+03, 0.140E+03, 0.460E+02, 0.19355000E+01, 0.00000000E+00,
  0.49038170E+03, 0.140E+03, 0.470E+02, 0.19355000E+01, 0.00000000E+00,
  0.51538610E+03, 0.140E+03, 0.480E+02, 0.19355000E+01, 0.00000000E+00,
  0.65256540E+03, 0.140E+03, 0.490E+02, 0.19355000E+01, 0.00000000E+00,
  0.59689190E+03, 0.140E+03, 0.500E+02, 0.19355000E+01, 0.00000000E+00,
  0.52654260E+03, 0.140E+03, 0.510E+02, 0.19355000E+01, 0.00000000E+00,
  0.48561760E+03, 0.140E+03, 0.520E+02, 0.19355000E+01, 0.00000000E+00,
  0.43630460E+03, 0.140E+03, 0.530E+02, 0.19355000E+01, 0.00000000E+00,
  0.38993850E+03, 0.140E+03, 0.540E+02, 0.19355000E+01, 0.00000000E+00,
  0.18190406E+04, 0.140E+03, 0.550E+02, 0.19355000E+01, 0.00000000E+00,
  0.16353622E+04, 0.140E+03, 0.560E+02, 0.19355000E+01, 0.00000000E+00,
  0.14206192E+04, 0.140E+03, 0.570E+02, 0.19355000E+01, 0.00000000E+00,
  0.62328410E+03, 0.140E+03, 0.580E+02, 0.19355000E+01, 0.27991000E+01,
  0.14429680E+04, 0.140E+03, 0.590E+02, 0.19355000E+01, 0.00000000E+00,
  0.13832190E+04, 0.140E+03, 0.600E+02, 0.19355000E+01, 0.00000000E+00,
  0.13477804E+04, 0.140E+03, 0.610E+02, 0.19355000E+01, 0.00000000E+00,
  0.13152670E+04, 0.140E+03, 0.620E+02, 0.19355000E+01, 0.00000000E+00,
  0.12864106E+04, 0.140E+03, 0.630E+02, 0.19355000E+01, 0.00000000E+00,
  0.99936150E+03, 0.140E+03, 0.640E+02, 0.19355000E+01, 0.00000000E+00,
  0.11461276E+04, 0.140E+03, 0.650E+02, 0.19355000E+01, 0.00000000E+00,
  0.11025614E+04, 0.140E+03, 0.660E+02, 0.19355000E+01, 0.00000000E+00,
  0.11568729E+04, 0.140E+03, 0.670E+02, 0.19355000E+01, 0.00000000E+00,
  0.11319421E+04, 0.140E+03, 0.680E+02, 0.19355000E+01, 0.00000000E+00,
  0.11093035E+04, 0.140E+03, 0.690E+02, 0.19355000E+01, 0.00000000E+00,
  0.10968681E+04, 0.140E+03, 0.700E+02, 0.19355000E+01, 0.00000000E+00,
  0.91629250E+03, 0.140E+03, 0.710E+02, 0.19355000E+01, 0.00000000E+00,
  0.89141000E+03, 0.140E+03, 0.720E+02, 0.19355000E+01, 0.00000000E+00,
  0.80810660E+03, 0.140E+03, 0.730E+02, 0.19355000E+01, 0.00000000E+00,
  0.67904580E+03, 0.140E+03, 0.740E+02, 0.19355000E+01, 0.00000000E+00,
  0.68897190E+03, 0.140E+03, 0.750E+02, 0.19355000E+01, 0.00000000E+00,
  0.62088940E+03, 0.140E+03, 0.760E+02, 0.19355000E+01, 0.00000000E+00,
  0.56604620E+03, 0.140E+03, 0.770E+02, 0.19355000E+01, 0.00000000E+00,
  0.46802460E+03, 0.140E+03, 0.780E+02, 0.19355000E+01, 0.00000000E+00,
  0.43643220E+03, 0.140E+03, 0.790E+02, 0.19355000E+01, 0.00000000E+00,
  0.44796630E+03, 0.140E+03, 0.800E+02, 0.19355000E+01, 0.00000000E+00,
  0.66836720E+03, 0.140E+03, 0.810E+02, 0.19355000E+01, 0.00000000E+00,
  0.64781650E+03, 0.140E+03, 0.820E+02, 0.19355000E+01, 0.00000000E+00,
  0.58976480E+03, 0.140E+03, 0.830E+02, 0.19355000E+01, 0.00000000E+00,
  0.55956430E+03, 0.140E+03, 0.840E+02, 0.19355000E+01, 0.00000000E+00,
  0.51325740E+03, 0.140E+03, 0.850E+02, 0.19355000E+01, 0.00000000E+00,
  0.46784580E+03, 0.140E+03, 0.860E+02, 0.19355000E+01, 0.00000000E+00,
  0.17028592E+04, 0.140E+03, 0.870E+02, 0.19355000E+01, 0.00000000E+00,
  0.16078178E+04, 0.140E+03, 0.880E+02, 0.19355000E+01, 0.00000000E+00,
  0.14061219E+04, 0.140E+03, 0.890E+02, 0.19355000E+01, 0.00000000E+00,
  0.12490250E+04, 0.140E+03, 0.900E+02, 0.19355000E+01, 0.00000000E+00,
  0.12473212E+04, 0.140E+03, 0.910E+02, 0.19355000E+01, 0.00000000E+00,
  0.12073349E+04, 0.140E+03, 0.920E+02, 0.19355000E+01, 0.00000000E+00,
  0.12519154E+04, 0.140E+03, 0.930E+02, 0.19355000E+01, 0.00000000E+00,
  0.12106981E+04, 0.140E+03, 0.940E+02, 0.19355000E+01, 0.00000000E+00,
  0.64706800E+02, 0.140E+03, 0.101E+03, 0.19355000E+01, 0.00000000E+00,
  0.21671700E+03, 0.140E+03, 0.103E+03, 0.19355000E+01, 0.98650000E+00,
  0.27536440E+03, 0.140E+03, 0.104E+03, 0.19355000E+01, 0.98080000E+00,
  0.20600140E+03, 0.140E+03, 0.105E+03, 0.19355000E+01, 0.97060000E+00,
  0.15342290E+03, 0.140E+03, 0.106E+03, 0.19355000E+01, 0.98680000E+00,
  0.10531510E+03, 0.140E+03, 0.107E+03, 0.19355000E+01, 0.99440000E+00,
  0.75899400E+02, 0.140E+03, 0.108E+03, 0.19355000E+01, 0.99250000E+00,
  0.51515800E+02, 0.140E+03, 0.109E+03, 0.19355000E+01, 0.99820000E+00,
  0.31816780E+03, 0.140E+03, 0.111E+03, 0.19355000E+01, 0.96840000E+00,
  0.49330570E+03, 0.140E+03, 0.112E+03, 0.19355000E+01, 0.96280000E+00,
  0.49402450E+03, 0.140E+03, 0.113E+03, 0.19355000E+01, 0.96480000E+00,
  0.39071920E+03, 0.140E+03, 0.114E+03, 0.19355000E+01, 0.95070000E+00,
  0.31631690E+03, 0.140E+03, 0.115E+03, 0.19355000E+01, 0.99470000E+00,
  0.26540890E+03, 0.140E+03, 0.116E+03, 0.19355000E+01, 0.99480000E+00,
  0.21521010E+03, 0.140E+03, 0.117E+03, 0.19355000E+01, 0.99720000E+00,
  0.43506490E+03, 0.140E+03, 0.119E+03, 0.19355000E+01, 0.97670000E+00,
  0.85671310E+03, 0.140E+03, 0.120E+03, 0.19355000E+01, 0.98310000E+00,
  0.42930190E+03, 0.140E+03, 0.121E+03, 0.19355000E+01, 0.18627000E+01,
  0.41420300E+03, 0.140E+03, 0.122E+03, 0.19355000E+01, 0.18299000E+01,
  0.40602230E+03, 0.140E+03, 0.123E+03, 0.19355000E+01, 0.19138000E+01,
  0.40292000E+03, 0.140E+03, 0.124E+03, 0.19355000E+01, 0.18269000E+01,
  0.36779370E+03, 0.140E+03, 0.125E+03, 0.19355000E+01, 0.16406000E+01,
  0.33962780E+03, 0.140E+03, 0.126E+03, 0.19355000E+01, 0.16483000E+01,
  0.32399210E+03, 0.140E+03, 0.127E+03, 0.19355000E+01, 0.17149000E+01,
  0.31694170E+03, 0.140E+03, 0.128E+03, 0.19355000E+01, 0.17937000E+01,
  0.31499080E+03, 0.140E+03, 0.129E+03, 0.19355000E+01, 0.95760000E+00,
  0.29240050E+03, 0.140E+03, 0.130E+03, 0.19355000E+01, 0.19419000E+01,
  0.48787590E+03, 0.140E+03, 0.131E+03, 0.19355000E+01, 0.96010000E+00,
  0.42320760E+03, 0.140E+03, 0.132E+03, 0.19355000E+01, 0.94340000E+00,
  0.37591790E+03, 0.140E+03, 0.133E+03, 0.19355000E+01, 0.98890000E+00,
  0.34120400E+03, 0.140E+03, 0.134E+03, 0.19355000E+01, 0.99010000E+00,
  0.29856340E+03, 0.140E+03, 0.135E+03, 0.19355000E+01, 0.99740000E+00,
  0.51769610E+03, 0.140E+03, 0.137E+03, 0.19355000E+01, 0.97380000E+00,
  0.10443401E+04, 0.140E+03, 0.138E+03, 0.19355000E+01, 0.98010000E+00,
  0.78082120E+03, 0.140E+03, 0.139E+03, 0.19355000E+01, 0.19153000E+01,
  0.56867890E+03, 0.140E+03, 0.140E+03, 0.19355000E+01, 0.19355000E+01,
  0.40030400E+02, 0.141E+03, 0.100E+01, 0.19545000E+01, 0.91180000E+00,
  0.25953400E+02, 0.141E+03, 0.200E+01, 0.19545000E+01, 0.00000000E+00,
  0.68410400E+03, 0.141E+03, 0.300E+01, 0.19545000E+01, 0.00000000E+00,
  0.37796930E+03, 0.141E+03, 0.400E+01, 0.19545000E+01, 0.00000000E+00,
  0.24842660E+03, 0.141E+03, 0.500E+01, 0.19545000E+01, 0.00000000E+00,
  0.16499800E+03, 0.141E+03, 0.600E+01, 0.19545000E+01, 0.00000000E+00,
  0.11399890E+03, 0.141E+03, 0.700E+01, 0.19545000E+01, 0.00000000E+00,
  0.85602400E+02, 0.141E+03, 0.800E+01, 0.19545000E+01, 0.00000000E+00,
  0.64401000E+02, 0.141E+03, 0.900E+01, 0.19545000E+01, 0.00000000E+00,
  0.49263500E+02, 0.141E+03, 0.100E+02, 0.19545000E+01, 0.00000000E+00,
  0.81603170E+03, 0.141E+03, 0.110E+02, 0.19545000E+01, 0.00000000E+00,
  0.60700730E+03, 0.141E+03, 0.120E+02, 0.19545000E+01, 0.00000000E+00,
  0.55235500E+03, 0.141E+03, 0.130E+02, 0.19545000E+01, 0.00000000E+00,
  0.42788370E+03, 0.141E+03, 0.140E+02, 0.19545000E+01, 0.00000000E+00,
  0.32909470E+03, 0.141E+03, 0.150E+02, 0.19545000E+01, 0.00000000E+00,
  0.27080590E+03, 0.141E+03, 0.160E+02, 0.19545000E+01, 0.00000000E+00,
  0.21944620E+03, 0.141E+03, 0.170E+02, 0.19545000E+01, 0.00000000E+00,
  0.17831830E+03, 0.141E+03, 0.180E+02, 0.19545000E+01, 0.00000000E+00,
  0.13433714E+04, 0.141E+03, 0.190E+02, 0.19545000E+01, 0.00000000E+00,
  0.10819930E+04, 0.141E+03, 0.200E+02, 0.19545000E+01, 0.00000000E+00,
  0.88833560E+03, 0.141E+03, 0.210E+02, 0.19545000E+01, 0.00000000E+00,
  0.85304640E+03, 0.141E+03, 0.220E+02, 0.19545000E+01, 0.00000000E+00,
  0.77852660E+03, 0.141E+03, 0.230E+02, 0.19545000E+01, 0.00000000E+00,
  0.61302240E+03, 0.141E+03, 0.240E+02, 0.19545000E+01, 0.00000000E+00,
  0.66703050E+03, 0.141E+03, 0.250E+02, 0.19545000E+01, 0.00000000E+00,
  0.52300200E+03, 0.141E+03, 0.260E+02, 0.19545000E+01, 0.00000000E+00,
  0.55040920E+03, 0.141E+03, 0.270E+02, 0.19545000E+01, 0.00000000E+00,
  0.56890880E+03, 0.141E+03, 0.280E+02, 0.19545000E+01, 0.00000000E+00,
  0.43610420E+03, 0.141E+03, 0.290E+02, 0.19545000E+01, 0.00000000E+00,
  0.44298860E+03, 0.141E+03, 0.300E+02, 0.19545000E+01, 0.00000000E+00,
  0.52649640E+03, 0.141E+03, 0.310E+02, 0.19545000E+01, 0.00000000E+00,
  0.45819200E+03, 0.141E+03, 0.320E+02, 0.19545000E+01, 0.00000000E+00,
  0.38630910E+03, 0.141E+03, 0.330E+02, 0.19545000E+01, 0.00000000E+00,
  0.34424250E+03, 0.141E+03, 0.340E+02, 0.19545000E+01, 0.00000000E+00,
  0.29915350E+03, 0.141E+03, 0.350E+02, 0.19545000E+01, 0.00000000E+00,
  0.25853040E+03, 0.141E+03, 0.360E+02, 0.19545000E+01, 0.00000000E+00,
  0.15017789E+04, 0.141E+03, 0.370E+02, 0.19545000E+01, 0.00000000E+00,
  0.12904826E+04, 0.141E+03, 0.380E+02, 0.19545000E+01, 0.00000000E+00,
  0.11181402E+04, 0.141E+03, 0.390E+02, 0.19545000E+01, 0.00000000E+00,
  0.99812240E+03, 0.141E+03, 0.400E+02, 0.19545000E+01, 0.00000000E+00,
  0.90608010E+03, 0.141E+03, 0.410E+02, 0.19545000E+01, 0.00000000E+00,
  0.69429830E+03, 0.141E+03, 0.420E+02, 0.19545000E+01, 0.00000000E+00,
  0.77673680E+03, 0.141E+03, 0.430E+02, 0.19545000E+01, 0.00000000E+00,
  0.58689450E+03, 0.141E+03, 0.440E+02, 0.19545000E+01, 0.00000000E+00,
  0.64141640E+03, 0.141E+03, 0.450E+02, 0.19545000E+01, 0.00000000E+00,
  0.59314140E+03, 0.141E+03, 0.460E+02, 0.19545000E+01, 0.00000000E+00,
  0.49548000E+03, 0.141E+03, 0.470E+02, 0.19545000E+01, 0.00000000E+00,
  0.52076290E+03, 0.141E+03, 0.480E+02, 0.19545000E+01, 0.00000000E+00,
  0.65928650E+03, 0.141E+03, 0.490E+02, 0.19545000E+01, 0.00000000E+00,
  0.60296920E+03, 0.141E+03, 0.500E+02, 0.19545000E+01, 0.00000000E+00,
  0.53174240E+03, 0.141E+03, 0.510E+02, 0.19545000E+01, 0.00000000E+00,
  0.49032060E+03, 0.141E+03, 0.520E+02, 0.19545000E+01, 0.00000000E+00,
  0.44045990E+03, 0.141E+03, 0.530E+02, 0.19545000E+01, 0.00000000E+00,
  0.39361210E+03, 0.141E+03, 0.540E+02, 0.19545000E+01, 0.00000000E+00,
  0.18264461E+04, 0.141E+03, 0.550E+02, 0.19545000E+01, 0.00000000E+00,
  0.16509334E+04, 0.141E+03, 0.560E+02, 0.19545000E+01, 0.00000000E+00,
  0.14348956E+04, 0.141E+03, 0.570E+02, 0.19545000E+01, 0.00000000E+00,
  0.62949770E+03, 0.141E+03, 0.580E+02, 0.19545000E+01, 0.27991000E+01,
  0.14565113E+04, 0.141E+03, 0.590E+02, 0.19545000E+01, 0.00000000E+00,
  0.13970298E+04, 0.141E+03, 0.600E+02, 0.19545000E+01, 0.00000000E+00,
  0.13613178E+04, 0.141E+03, 0.610E+02, 0.19545000E+01, 0.00000000E+00,
  0.13285415E+04, 0.141E+03, 0.620E+02, 0.19545000E+01, 0.00000000E+00,
  0.12994488E+04, 0.141E+03, 0.630E+02, 0.19545000E+01, 0.00000000E+00,
  0.10094419E+04, 0.141E+03, 0.640E+02, 0.19545000E+01, 0.00000000E+00,
  0.11553947E+04, 0.141E+03, 0.650E+02, 0.19545000E+01, 0.00000000E+00,
  0.11106913E+04, 0.141E+03, 0.660E+02, 0.19545000E+01, 0.00000000E+00,
  0.11688393E+04, 0.141E+03, 0.670E+02, 0.19545000E+01, 0.00000000E+00,
  0.11436857E+04, 0.141E+03, 0.680E+02, 0.19545000E+01, 0.00000000E+00,
  0.11208436E+04, 0.141E+03, 0.690E+02, 0.19545000E+01, 0.00000000E+00,
  0.11082791E+04, 0.141E+03, 0.700E+02, 0.19545000E+01, 0.00000000E+00,
  0.92522660E+03, 0.141E+03, 0.710E+02, 0.19545000E+01, 0.00000000E+00,
  0.90068080E+03, 0.141E+03, 0.720E+02, 0.19545000E+01, 0.00000000E+00,
  0.81649740E+03, 0.141E+03, 0.730E+02, 0.19545000E+01, 0.00000000E+00,
  0.68598560E+03, 0.141E+03, 0.740E+02, 0.19545000E+01, 0.00000000E+00,
  0.69600400E+03, 0.141E+03, 0.750E+02, 0.19545000E+01, 0.00000000E+00,
  0.62720650E+03, 0.141E+03, 0.760E+02, 0.19545000E+01, 0.00000000E+00,
  0.57177930E+03, 0.141E+03, 0.770E+02, 0.19545000E+01, 0.00000000E+00,
  0.47276430E+03, 0.141E+03, 0.780E+02, 0.19545000E+01, 0.00000000E+00,
  0.44085970E+03, 0.141E+03, 0.790E+02, 0.19545000E+01, 0.00000000E+00,
  0.45247610E+03, 0.141E+03, 0.800E+02, 0.19545000E+01, 0.00000000E+00,
  0.67515180E+03, 0.141E+03, 0.810E+02, 0.19545000E+01, 0.00000000E+00,
  0.65444510E+03, 0.141E+03, 0.820E+02, 0.19545000E+01, 0.00000000E+00,
  0.59566400E+03, 0.141E+03, 0.830E+02, 0.19545000E+01, 0.00000000E+00,
  0.56506480E+03, 0.141E+03, 0.840E+02, 0.19545000E+01, 0.00000000E+00,
  0.51821240E+03, 0.141E+03, 0.850E+02, 0.19545000E+01, 0.00000000E+00,
  0.47230580E+03, 0.141E+03, 0.860E+02, 0.19545000E+01, 0.00000000E+00,
  0.17127050E+04, 0.141E+03, 0.870E+02, 0.19545000E+01, 0.00000000E+00,
  0.16235376E+04, 0.141E+03, 0.880E+02, 0.19545000E+01, 0.00000000E+00,
  0.14203983E+04, 0.141E+03, 0.890E+02, 0.19545000E+01, 0.00000000E+00,
  0.12619867E+04, 0.141E+03, 0.900E+02, 0.19545000E+01, 0.00000000E+00,
  0.12600147E+04, 0.141E+03, 0.910E+02, 0.19545000E+01, 0.00000000E+00,
  0.12197064E+04, 0.141E+03, 0.920E+02, 0.19545000E+01, 0.00000000E+00,
  0.12648378E+04, 0.141E+03, 0.930E+02, 0.19545000E+01, 0.00000000E+00,
  0.12232638E+04, 0.141E+03, 0.940E+02, 0.19545000E+01, 0.00000000E+00,
  0.65312900E+02, 0.141E+03, 0.101E+03, 0.19545000E+01, 0.00000000E+00,
  0.21897060E+03, 0.141E+03, 0.103E+03, 0.19545000E+01, 0.98650000E+00,
  0.27808810E+03, 0.141E+03, 0.104E+03, 0.19545000E+01, 0.98080000E+00,
  0.20799430E+03, 0.141E+03, 0.105E+03, 0.19545000E+01, 0.97060000E+00,
  0.15487640E+03, 0.141E+03, 0.106E+03, 0.19545000E+01, 0.98680000E+00,
  0.10631410E+03, 0.141E+03, 0.107E+03, 0.19545000E+01, 0.99440000E+00,
  0.76634700E+02, 0.141E+03, 0.108E+03, 0.19545000E+01, 0.99250000E+00,
  0.52041200E+02, 0.141E+03, 0.109E+03, 0.19545000E+01, 0.99820000E+00,
  0.32153780E+03, 0.141E+03, 0.111E+03, 0.19545000E+01, 0.96840000E+00,
  0.49834860E+03, 0.141E+03, 0.112E+03, 0.19545000E+01, 0.96280000E+00,
  0.49907610E+03, 0.141E+03, 0.113E+03, 0.19545000E+01, 0.96480000E+00,
  0.39454030E+03, 0.141E+03, 0.114E+03, 0.19545000E+01, 0.95070000E+00,
  0.31930990E+03, 0.141E+03, 0.115E+03, 0.19545000E+01, 0.99470000E+00,
  0.26788580E+03, 0.141E+03, 0.116E+03, 0.19545000E+01, 0.99480000E+00,
  0.21720780E+03, 0.141E+03, 0.117E+03, 0.19545000E+01, 0.99720000E+00,
  0.43952280E+03, 0.141E+03, 0.119E+03, 0.19545000E+01, 0.97670000E+00,
  0.86414110E+03, 0.141E+03, 0.120E+03, 0.19545000E+01, 0.98310000E+00,
  0.43378650E+03, 0.141E+03, 0.121E+03, 0.19545000E+01, 0.18627000E+01,
  0.41830680E+03, 0.141E+03, 0.122E+03, 0.19545000E+01, 0.18299000E+01,
  0.41010330E+03, 0.141E+03, 0.123E+03, 0.19545000E+01, 0.19138000E+01,
  0.40698940E+03, 0.141E+03, 0.124E+03, 0.19545000E+01, 0.18269000E+01,
  0.37146910E+03, 0.141E+03, 0.125E+03, 0.19545000E+01, 0.16406000E+01,
  0.34300120E+03, 0.141E+03, 0.126E+03, 0.19545000E+01, 0.16483000E+01,
  0.32719950E+03, 0.141E+03, 0.127E+03, 0.19545000E+01, 0.17149000E+01,
  0.32009600E+03, 0.141E+03, 0.128E+03, 0.19545000E+01, 0.17937000E+01,
  0.31821360E+03, 0.141E+03, 0.129E+03, 0.19545000E+01, 0.95760000E+00,
  0.29527620E+03, 0.141E+03, 0.130E+03, 0.19545000E+01, 0.19419000E+01,
  0.49283160E+03, 0.141E+03, 0.131E+03, 0.19545000E+01, 0.96010000E+00,
  0.42736220E+03, 0.141E+03, 0.132E+03, 0.19545000E+01, 0.94340000E+00,
  0.37950970E+03, 0.141E+03, 0.133E+03, 0.19545000E+01, 0.98890000E+00,
  0.34441690E+03, 0.141E+03, 0.134E+03, 0.19545000E+01, 0.99010000E+00,
  0.30134630E+03, 0.141E+03, 0.135E+03, 0.19545000E+01, 0.99740000E+00,
  0.52294490E+03, 0.141E+03, 0.137E+03, 0.19545000E+01, 0.97380000E+00,
  0.10528629E+04, 0.141E+03, 0.138E+03, 0.19545000E+01, 0.98010000E+00,
  0.78749500E+03, 0.141E+03, 0.139E+03, 0.19545000E+01, 0.19153000E+01,
  0.57445910E+03, 0.141E+03, 0.140E+03, 0.19545000E+01, 0.19355000E+01,
  0.58058240E+03, 0.141E+03, 0.141E+03, 0.19545000E+01, 0.19545000E+01,
  0.37547800E+02, 0.142E+03, 0.100E+01, 0.19420000E+01, 0.91180000E+00,
  0.24553000E+02, 0.142E+03, 0.200E+01, 0.19420000E+01, 0.00000000E+00,
  0.62818170E+03, 0.142E+03, 0.300E+01, 0.19420000E+01, 0.00000000E+00,
  0.34918970E+03, 0.142E+03, 0.400E+01, 0.19420000E+01, 0.00000000E+00,
  0.23104490E+03, 0.142E+03, 0.500E+01, 0.19420000E+01, 0.00000000E+00,
  0.15432880E+03, 0.142E+03, 0.600E+01, 0.19420000E+01, 0.00000000E+00,
  0.10713040E+03, 0.142E+03, 0.700E+01, 0.19420000E+01, 0.00000000E+00,
  0.80736000E+02, 0.142E+03, 0.800E+01, 0.19420000E+01, 0.00000000E+00,
  0.60941400E+02, 0.142E+03, 0.900E+01, 0.19420000E+01, 0.00000000E+00,
  0.46749800E+02, 0.142E+03, 0.100E+02, 0.19420000E+01, 0.00000000E+00,
  0.74949740E+03, 0.142E+03, 0.110E+02, 0.19420000E+01, 0.00000000E+00,
  0.55988560E+03, 0.142E+03, 0.120E+02, 0.19420000E+01, 0.00000000E+00,
  0.51108100E+03, 0.142E+03, 0.130E+02, 0.19420000E+01, 0.00000000E+00,
  0.39766020E+03, 0.142E+03, 0.140E+02, 0.19420000E+01, 0.00000000E+00,
  0.30713840E+03, 0.142E+03, 0.150E+02, 0.19420000E+01, 0.00000000E+00,
  0.25349850E+03, 0.142E+03, 0.160E+02, 0.19420000E+01, 0.00000000E+00,
  0.20604590E+03, 0.142E+03, 0.170E+02, 0.19420000E+01, 0.00000000E+00,
  0.16790140E+03, 0.142E+03, 0.180E+02, 0.19420000E+01, 0.00000000E+00,
  0.12379643E+04, 0.142E+03, 0.190E+02, 0.19420000E+01, 0.00000000E+00,
  0.99601570E+03, 0.142E+03, 0.200E+02, 0.19420000E+01, 0.00000000E+00,
  0.81851610E+03, 0.142E+03, 0.210E+02, 0.19420000E+01, 0.00000000E+00,
  0.78705650E+03, 0.142E+03, 0.220E+02, 0.19420000E+01, 0.00000000E+00,
  0.71884690E+03, 0.142E+03, 0.230E+02, 0.19420000E+01, 0.00000000E+00,
  0.56643000E+03, 0.142E+03, 0.240E+02, 0.19420000E+01, 0.00000000E+00,
  0.61659930E+03, 0.142E+03, 0.250E+02, 0.19420000E+01, 0.00000000E+00,
  0.48385370E+03, 0.142E+03, 0.260E+02, 0.19420000E+01, 0.00000000E+00,
  0.50969990E+03, 0.142E+03, 0.270E+02, 0.19420000E+01, 0.00000000E+00,
  0.52637950E+03, 0.142E+03, 0.280E+02, 0.19420000E+01, 0.00000000E+00,
  0.40384000E+03, 0.142E+03, 0.290E+02, 0.19420000E+01, 0.00000000E+00,
  0.41098660E+03, 0.142E+03, 0.300E+02, 0.19420000E+01, 0.00000000E+00,
  0.48798580E+03, 0.142E+03, 0.310E+02, 0.19420000E+01, 0.00000000E+00,
  0.42607030E+03, 0.142E+03, 0.320E+02, 0.19420000E+01, 0.00000000E+00,
  0.36044960E+03, 0.142E+03, 0.330E+02, 0.19420000E+01, 0.00000000E+00,
  0.32194150E+03, 0.142E+03, 0.340E+02, 0.19420000E+01, 0.00000000E+00,
  0.28047020E+03, 0.142E+03, 0.350E+02, 0.19420000E+01, 0.00000000E+00,
  0.24296840E+03, 0.142E+03, 0.360E+02, 0.19420000E+01, 0.00000000E+00,
  0.13851228E+04, 0.142E+03, 0.370E+02, 0.19420000E+01, 0.00000000E+00,
  0.11881982E+04, 0.142E+03, 0.380E+02, 0.19420000E+01, 0.00000000E+00,
  0.10314745E+04, 0.142E+03, 0.390E+02, 0.19420000E+01, 0.00000000E+00,
  0.92206600E+03, 0.142E+03, 0.400E+02, 0.19420000E+01, 0.00000000E+00,
  0.83798490E+03, 0.142E+03, 0.410E+02, 0.19420000E+01, 0.00000000E+00,
  0.64347210E+03, 0.142E+03, 0.420E+02, 0.19420000E+01, 0.00000000E+00,
  0.71936590E+03, 0.142E+03, 0.430E+02, 0.19420000E+01, 0.00000000E+00,
  0.54480750E+03, 0.142E+03, 0.440E+02, 0.19420000E+01, 0.00000000E+00,
  0.59515030E+03, 0.142E+03, 0.450E+02, 0.19420000E+01, 0.00000000E+00,
  0.55075570E+03, 0.142E+03, 0.460E+02, 0.19420000E+01, 0.00000000E+00,
  0.46023670E+03, 0.142E+03, 0.470E+02, 0.19420000E+01, 0.00000000E+00,
  0.48402860E+03, 0.142E+03, 0.480E+02, 0.19420000E+01, 0.00000000E+00,
  0.61139110E+03, 0.142E+03, 0.490E+02, 0.19420000E+01, 0.00000000E+00,
  0.56051040E+03, 0.142E+03, 0.500E+02, 0.19420000E+01, 0.00000000E+00,
  0.49569480E+03, 0.142E+03, 0.510E+02, 0.19420000E+01, 0.00000000E+00,
  0.45793020E+03, 0.142E+03, 0.520E+02, 0.19420000E+01, 0.00000000E+00,
  0.41222750E+03, 0.142E+03, 0.530E+02, 0.19420000E+01, 0.00000000E+00,
  0.36915310E+03, 0.142E+03, 0.540E+02, 0.19420000E+01, 0.00000000E+00,
  0.16877490E+04, 0.142E+03, 0.550E+02, 0.19420000E+01, 0.00000000E+00,
  0.15201317E+04, 0.142E+03, 0.560E+02, 0.19420000E+01, 0.00000000E+00,
  0.13232583E+04, 0.142E+03, 0.570E+02, 0.19420000E+01, 0.00000000E+00,
  0.58664300E+03, 0.142E+03, 0.580E+02, 0.19420000E+01, 0.27991000E+01,
  0.13428116E+04, 0.142E+03, 0.590E+02, 0.19420000E+01, 0.00000000E+00,
  0.12872763E+04, 0.142E+03, 0.600E+02, 0.19420000E+01, 0.00000000E+00,
  0.12544039E+04, 0.142E+03, 0.610E+02, 0.19420000E+01, 0.00000000E+00,
  0.12242314E+04, 0.142E+03, 0.620E+02, 0.19420000E+01, 0.00000000E+00,
  0.11974564E+04, 0.142E+03, 0.630E+02, 0.19420000E+01, 0.00000000E+00,
  0.93283320E+03, 0.142E+03, 0.640E+02, 0.19420000E+01, 0.00000000E+00,
  0.10667077E+04, 0.142E+03, 0.650E+02, 0.19420000E+01, 0.00000000E+00,
  0.10271026E+04, 0.142E+03, 0.660E+02, 0.19420000E+01, 0.00000000E+00,
  0.10774205E+04, 0.142E+03, 0.670E+02, 0.19420000E+01, 0.00000000E+00,
  0.10542484E+04, 0.142E+03, 0.680E+02, 0.19420000E+01, 0.00000000E+00,
  0.10332364E+04, 0.142E+03, 0.690E+02, 0.19420000E+01, 0.00000000E+00,
  0.10215311E+04, 0.142E+03, 0.700E+02, 0.19420000E+01, 0.00000000E+00,
  0.85524570E+03, 0.142E+03, 0.710E+02, 0.19420000E+01, 0.00000000E+00,
  0.83345230E+03, 0.142E+03, 0.720E+02, 0.19420000E+01, 0.00000000E+00,
  0.75675320E+03, 0.142E+03, 0.730E+02, 0.19420000E+01, 0.00000000E+00,
  0.63690770E+03, 0.142E+03, 0.740E+02, 0.19420000E+01, 0.00000000E+00,
  0.64654950E+03, 0.142E+03, 0.750E+02, 0.19420000E+01, 0.00000000E+00,
  0.58352570E+03, 0.142E+03, 0.760E+02, 0.19420000E+01, 0.00000000E+00,
  0.53265790E+03, 0.142E+03, 0.770E+02, 0.19420000E+01, 0.00000000E+00,
  0.44119610E+03, 0.142E+03, 0.780E+02, 0.19420000E+01, 0.00000000E+00,
  0.41171360E+03, 0.142E+03, 0.790E+02, 0.19420000E+01, 0.00000000E+00,
  0.42271910E+03, 0.142E+03, 0.800E+02, 0.19420000E+01, 0.00000000E+00,
  0.62693260E+03, 0.142E+03, 0.810E+02, 0.19420000E+01, 0.00000000E+00,
  0.60866200E+03, 0.142E+03, 0.820E+02, 0.19420000E+01, 0.00000000E+00,
  0.55532550E+03, 0.142E+03, 0.830E+02, 0.19420000E+01, 0.00000000E+00,
  0.52759970E+03, 0.142E+03, 0.840E+02, 0.19420000E+01, 0.00000000E+00,
  0.48478900E+03, 0.142E+03, 0.850E+02, 0.19420000E+01, 0.00000000E+00,
  0.44266740E+03, 0.142E+03, 0.860E+02, 0.19420000E+01, 0.00000000E+00,
  0.15815449E+04, 0.142E+03, 0.870E+02, 0.19420000E+01, 0.00000000E+00,
  0.14962077E+04, 0.142E+03, 0.880E+02, 0.19420000E+01, 0.00000000E+00,
  0.13112088E+04, 0.142E+03, 0.890E+02, 0.19420000E+01, 0.00000000E+00,
  0.11676309E+04, 0.142E+03, 0.900E+02, 0.19420000E+01, 0.00000000E+00,
  0.11649288E+04, 0.142E+03, 0.910E+02, 0.19420000E+01, 0.00000000E+00,
  0.11276927E+04, 0.142E+03, 0.920E+02, 0.19420000E+01, 0.00000000E+00,
  0.11676383E+04, 0.142E+03, 0.930E+02, 0.19420000E+01, 0.00000000E+00,
  0.11294830E+04, 0.142E+03, 0.940E+02, 0.19420000E+01, 0.00000000E+00,
  0.60977300E+02, 0.142E+03, 0.101E+03, 0.19420000E+01, 0.00000000E+00,
  0.20251730E+03, 0.142E+03, 0.103E+03, 0.19420000E+01, 0.98650000E+00,
  0.25760880E+03, 0.142E+03, 0.104E+03, 0.19420000E+01, 0.98080000E+00,
  0.19375570E+03, 0.142E+03, 0.105E+03, 0.19420000E+01, 0.97060000E+00,
  0.14487380E+03, 0.142E+03, 0.106E+03, 0.19420000E+01, 0.98680000E+00,
  0.99938100E+02, 0.142E+03, 0.107E+03, 0.19420000E+01, 0.99440000E+00,
  0.72352000E+02, 0.142E+03, 0.108E+03, 0.19420000E+01, 0.99250000E+00,
  0.49416600E+02, 0.142E+03, 0.109E+03, 0.19420000E+01, 0.99820000E+00,
  0.29717130E+03, 0.142E+03, 0.111E+03, 0.19420000E+01, 0.96840000E+00,
  0.46042340E+03, 0.142E+03, 0.112E+03, 0.19420000E+01, 0.96280000E+00,
  0.46216780E+03, 0.142E+03, 0.113E+03, 0.19420000E+01, 0.96480000E+00,
  0.36695490E+03, 0.142E+03, 0.114E+03, 0.19420000E+01, 0.95070000E+00,
  0.29806610E+03, 0.142E+03, 0.115E+03, 0.19420000E+01, 0.99470000E+00,
  0.25075730E+03, 0.142E+03, 0.116E+03, 0.19420000E+01, 0.99480000E+00,
  0.20393970E+03, 0.142E+03, 0.117E+03, 0.19420000E+01, 0.99720000E+00,
  0.40759060E+03, 0.142E+03, 0.119E+03, 0.19420000E+01, 0.97670000E+00,
  0.79747730E+03, 0.142E+03, 0.120E+03, 0.19420000E+01, 0.98310000E+00,
  0.40315400E+03, 0.142E+03, 0.121E+03, 0.19420000E+01, 0.18627000E+01,
  0.38917870E+03, 0.142E+03, 0.122E+03, 0.19420000E+01, 0.18299000E+01,
  0.38148040E+03, 0.142E+03, 0.123E+03, 0.19420000E+01, 0.19138000E+01,
  0.37844740E+03, 0.142E+03, 0.124E+03, 0.19420000E+01, 0.18269000E+01,
  0.34604230E+03, 0.142E+03, 0.125E+03, 0.19420000E+01, 0.16406000E+01,
  0.31976370E+03, 0.142E+03, 0.126E+03, 0.19420000E+01, 0.16483000E+01,
  0.30508870E+03, 0.142E+03, 0.127E+03, 0.19420000E+01, 0.17149000E+01,
  0.29841290E+03, 0.142E+03, 0.128E+03, 0.19420000E+01, 0.17937000E+01,
  0.29619890E+03, 0.142E+03, 0.129E+03, 0.19420000E+01, 0.95760000E+00,
  0.27560550E+03, 0.142E+03, 0.130E+03, 0.19420000E+01, 0.19419000E+01,
  0.45716410E+03, 0.142E+03, 0.131E+03, 0.19420000E+01, 0.96010000E+00,
  0.39775920E+03, 0.142E+03, 0.132E+03, 0.19420000E+01, 0.94340000E+00,
  0.35418680E+03, 0.142E+03, 0.133E+03, 0.19420000E+01, 0.98890000E+00,
  0.32209780E+03, 0.142E+03, 0.134E+03, 0.19420000E+01, 0.99010000E+00,
  0.28249330E+03, 0.142E+03, 0.135E+03, 0.19420000E+01, 0.99740000E+00,
  0.48541290E+03, 0.142E+03, 0.137E+03, 0.19420000E+01, 0.97380000E+00,
  0.97212330E+03, 0.142E+03, 0.138E+03, 0.19420000E+01, 0.98010000E+00,
  0.73014460E+03, 0.142E+03, 0.139E+03, 0.19420000E+01, 0.19153000E+01,
  0.53401080E+03, 0.142E+03, 0.140E+03, 0.19420000E+01, 0.19355000E+01,
  0.53935320E+03, 0.142E+03, 0.141E+03, 0.19420000E+01, 0.19545000E+01,
  0.50200730E+03, 0.142E+03, 0.142E+03, 0.19420000E+01, 0.19420000E+01,
  0.41338500E+02, 0.143E+03, 0.100E+01, 0.16682000E+01, 0.91180000E+00,
  0.26621700E+02, 0.143E+03, 0.200E+01, 0.16682000E+01, 0.00000000E+00,
  0.76378140E+03, 0.143E+03, 0.300E+01, 0.16682000E+01, 0.00000000E+00,
  0.40277270E+03, 0.143E+03, 0.400E+01, 0.16682000E+01, 0.00000000E+00,
  0.26037960E+03, 0.143E+03, 0.500E+01, 0.16682000E+01, 0.00000000E+00,
  0.17125810E+03, 0.143E+03, 0.600E+01, 0.16682000E+01, 0.00000000E+00,
  0.11764790E+03, 0.143E+03, 0.700E+01, 0.16682000E+01, 0.00000000E+00,
  0.88060900E+02, 0.143E+03, 0.800E+01, 0.16682000E+01, 0.00000000E+00,
  0.66109300E+02, 0.143E+03, 0.900E+01, 0.16682000E+01, 0.00000000E+00,
  0.50508700E+02, 0.143E+03, 0.100E+02, 0.16682000E+01, 0.00000000E+00,
  0.90840250E+03, 0.143E+03, 0.110E+02, 0.16682000E+01, 0.00000000E+00,
  0.65125640E+03, 0.143E+03, 0.120E+02, 0.16682000E+01, 0.00000000E+00,
  0.58698620E+03, 0.143E+03, 0.130E+02, 0.16682000E+01, 0.00000000E+00,
  0.44911910E+03, 0.143E+03, 0.140E+02, 0.16682000E+01, 0.00000000E+00,
  0.34248830E+03, 0.143E+03, 0.150E+02, 0.16682000E+01, 0.00000000E+00,
  0.28056130E+03, 0.143E+03, 0.160E+02, 0.16682000E+01, 0.00000000E+00,
  0.22648330E+03, 0.143E+03, 0.170E+02, 0.16682000E+01, 0.00000000E+00,
  0.18352050E+03, 0.143E+03, 0.180E+02, 0.16682000E+01, 0.00000000E+00,
  0.15188755E+04, 0.143E+03, 0.190E+02, 0.16682000E+01, 0.00000000E+00,
  0.11783302E+04, 0.143E+03, 0.200E+02, 0.16682000E+01, 0.00000000E+00,
  0.96136570E+03, 0.143E+03, 0.210E+02, 0.16682000E+01, 0.00000000E+00,
  0.91930990E+03, 0.143E+03, 0.220E+02, 0.16682000E+01, 0.00000000E+00,
  0.83673410E+03, 0.143E+03, 0.230E+02, 0.16682000E+01, 0.00000000E+00,
  0.65972010E+03, 0.143E+03, 0.240E+02, 0.16682000E+01, 0.00000000E+00,
  0.71418300E+03, 0.143E+03, 0.250E+02, 0.16682000E+01, 0.00000000E+00,
  0.56036480E+03, 0.143E+03, 0.260E+02, 0.16682000E+01, 0.00000000E+00,
  0.58529350E+03, 0.143E+03, 0.270E+02, 0.16682000E+01, 0.00000000E+00,
  0.60647400E+03, 0.143E+03, 0.280E+02, 0.16682000E+01, 0.00000000E+00,
  0.46581470E+03, 0.143E+03, 0.290E+02, 0.16682000E+01, 0.00000000E+00,
  0.46845290E+03, 0.143E+03, 0.300E+02, 0.16682000E+01, 0.00000000E+00,
  0.55815220E+03, 0.143E+03, 0.310E+02, 0.16682000E+01, 0.00000000E+00,
  0.48089260E+03, 0.143E+03, 0.320E+02, 0.16682000E+01, 0.00000000E+00,
  0.40245400E+03, 0.143E+03, 0.330E+02, 0.16682000E+01, 0.00000000E+00,
  0.35725110E+03, 0.143E+03, 0.340E+02, 0.16682000E+01, 0.00000000E+00,
  0.30935300E+03, 0.143E+03, 0.350E+02, 0.16682000E+01, 0.00000000E+00,
  0.26657770E+03, 0.143E+03, 0.360E+02, 0.16682000E+01, 0.00000000E+00,
  0.16961214E+04, 0.143E+03, 0.370E+02, 0.16682000E+01, 0.00000000E+00,
  0.14083895E+04, 0.143E+03, 0.380E+02, 0.16682000E+01, 0.00000000E+00,
  0.12079868E+04, 0.143E+03, 0.390E+02, 0.16682000E+01, 0.00000000E+00,
  0.10721935E+04, 0.143E+03, 0.400E+02, 0.16682000E+01, 0.00000000E+00,
  0.97020700E+03, 0.143E+03, 0.410E+02, 0.16682000E+01, 0.00000000E+00,
  0.73979150E+03, 0.143E+03, 0.420E+02, 0.16682000E+01, 0.00000000E+00,
  0.82924080E+03, 0.143E+03, 0.430E+02, 0.16682000E+01, 0.00000000E+00,
  0.62313860E+03, 0.143E+03, 0.440E+02, 0.16682000E+01, 0.00000000E+00,
  0.68005240E+03, 0.143E+03, 0.450E+02, 0.16682000E+01, 0.00000000E+00,
  0.62758100E+03, 0.143E+03, 0.460E+02, 0.16682000E+01, 0.00000000E+00,
  0.52609770E+03, 0.143E+03, 0.470E+02, 0.16682000E+01, 0.00000000E+00,
  0.54963380E+03, 0.143E+03, 0.480E+02, 0.16682000E+01, 0.00000000E+00,
  0.70042290E+03, 0.143E+03, 0.490E+02, 0.16682000E+01, 0.00000000E+00,
  0.63478310E+03, 0.143E+03, 0.500E+02, 0.16682000E+01, 0.00000000E+00,
  0.55577940E+03, 0.143E+03, 0.510E+02, 0.16682000E+01, 0.00000000E+00,
  0.51056820E+03, 0.143E+03, 0.520E+02, 0.16682000E+01, 0.00000000E+00,
  0.45697070E+03, 0.143E+03, 0.530E+02, 0.16682000E+01, 0.00000000E+00,
  0.40709700E+03, 0.143E+03, 0.540E+02, 0.16682000E+01, 0.00000000E+00,
  0.20688557E+04, 0.143E+03, 0.550E+02, 0.16682000E+01, 0.00000000E+00,
  0.18110626E+04, 0.143E+03, 0.560E+02, 0.16682000E+01, 0.00000000E+00,
  0.15570674E+04, 0.143E+03, 0.570E+02, 0.16682000E+01, 0.00000000E+00,
  0.65923480E+03, 0.143E+03, 0.580E+02, 0.16682000E+01, 0.27991000E+01,
  0.15936331E+04, 0.143E+03, 0.590E+02, 0.16682000E+01, 0.00000000E+00,
  0.15238714E+04, 0.143E+03, 0.600E+02, 0.16682000E+01, 0.00000000E+00,
  0.14839817E+04, 0.143E+03, 0.610E+02, 0.16682000E+01, 0.00000000E+00,
  0.14474665E+04, 0.143E+03, 0.620E+02, 0.16682000E+01, 0.00000000E+00,
  0.14150358E+04, 0.143E+03, 0.630E+02, 0.16682000E+01, 0.00000000E+00,
  0.10889839E+04, 0.143E+03, 0.640E+02, 0.16682000E+01, 0.00000000E+00,
  0.12727235E+04, 0.143E+03, 0.650E+02, 0.16682000E+01, 0.00000000E+00,
  0.12232739E+04, 0.143E+03, 0.660E+02, 0.16682000E+01, 0.00000000E+00,
  0.12689174E+04, 0.143E+03, 0.670E+02, 0.16682000E+01, 0.00000000E+00,
  0.12411151E+04, 0.143E+03, 0.680E+02, 0.16682000E+01, 0.00000000E+00,
  0.12157298E+04, 0.143E+03, 0.690E+02, 0.16682000E+01, 0.00000000E+00,
  0.12025314E+04, 0.143E+03, 0.700E+02, 0.16682000E+01, 0.00000000E+00,
  0.99886140E+03, 0.143E+03, 0.710E+02, 0.16682000E+01, 0.00000000E+00,
  0.96131920E+03, 0.143E+03, 0.720E+02, 0.16682000E+01, 0.00000000E+00,
  0.86700540E+03, 0.143E+03, 0.730E+02, 0.16682000E+01, 0.00000000E+00,
  0.72670660E+03, 0.143E+03, 0.740E+02, 0.16682000E+01, 0.00000000E+00,
  0.73557240E+03, 0.143E+03, 0.750E+02, 0.16682000E+01, 0.00000000E+00,
  0.66018700E+03, 0.143E+03, 0.760E+02, 0.16682000E+01, 0.00000000E+00,
  0.60002740E+03, 0.143E+03, 0.770E+02, 0.16682000E+01, 0.00000000E+00,
  0.49511760E+03, 0.143E+03, 0.780E+02, 0.16682000E+01, 0.00000000E+00,
  0.46130260E+03, 0.143E+03, 0.790E+02, 0.16682000E+01, 0.00000000E+00,
  0.47242330E+03, 0.143E+03, 0.800E+02, 0.16682000E+01, 0.00000000E+00,
  0.71722290E+03, 0.143E+03, 0.810E+02, 0.16682000E+01, 0.00000000E+00,
  0.68964350E+03, 0.143E+03, 0.820E+02, 0.16682000E+01, 0.00000000E+00,
  0.62335390E+03, 0.143E+03, 0.830E+02, 0.16682000E+01, 0.00000000E+00,
  0.58927250E+03, 0.143E+03, 0.840E+02, 0.16682000E+01, 0.00000000E+00,
  0.53837470E+03, 0.143E+03, 0.850E+02, 0.16682000E+01, 0.00000000E+00,
  0.48918620E+03, 0.143E+03, 0.860E+02, 0.16682000E+01, 0.00000000E+00,
  0.19184029E+04, 0.143E+03, 0.870E+02, 0.16682000E+01, 0.00000000E+00,
  0.17715639E+04, 0.143E+03, 0.880E+02, 0.16682000E+01, 0.00000000E+00,
  0.15346792E+04, 0.143E+03, 0.890E+02, 0.16682000E+01, 0.00000000E+00,
  0.13502400E+04, 0.143E+03, 0.900E+02, 0.16682000E+01, 0.00000000E+00,
  0.13560504E+04, 0.143E+03, 0.910E+02, 0.16682000E+01, 0.00000000E+00,
  0.13122121E+04, 0.143E+03, 0.920E+02, 0.16682000E+01, 0.00000000E+00,
  0.13686610E+04, 0.143E+03, 0.930E+02, 0.16682000E+01, 0.00000000E+00,
  0.13219594E+04, 0.143E+03, 0.940E+02, 0.16682000E+01, 0.00000000E+00,
  0.67892400E+02, 0.143E+03, 0.101E+03, 0.16682000E+01, 0.00000000E+00,
  0.23295390E+03, 0.143E+03, 0.103E+03, 0.16682000E+01, 0.98650000E+00,
  0.29538160E+03, 0.143E+03, 0.104E+03, 0.16682000E+01, 0.98080000E+00,
  0.21747620E+03, 0.143E+03, 0.105E+03, 0.16682000E+01, 0.97060000E+00,
  0.16092230E+03, 0.143E+03, 0.106E+03, 0.16682000E+01, 0.98680000E+00,
  0.10977550E+03, 0.143E+03, 0.107E+03, 0.16682000E+01, 0.99440000E+00,
  0.78792000E+02, 0.143E+03, 0.108E+03, 0.16682000E+01, 0.99250000E+00,
  0.53288000E+02, 0.143E+03, 0.109E+03, 0.16682000E+01, 0.99820000E+00,
  0.34355920E+03, 0.143E+03, 0.111E+03, 0.16682000E+01, 0.96840000E+00,
  0.53370850E+03, 0.143E+03, 0.112E+03, 0.16682000E+01, 0.96280000E+00,
  0.52930430E+03, 0.143E+03, 0.113E+03, 0.16682000E+01, 0.96480000E+00,
  0.41359910E+03, 0.143E+03, 0.114E+03, 0.16682000E+01, 0.95070000E+00,
  0.33227830E+03, 0.143E+03, 0.115E+03, 0.16682000E+01, 0.99470000E+00,
  0.27760020E+03, 0.143E+03, 0.116E+03, 0.16682000E+01, 0.99480000E+00,
  0.22420950E+03, 0.143E+03, 0.117E+03, 0.16682000E+01, 0.99720000E+00,
  0.46809770E+03, 0.143E+03, 0.119E+03, 0.16682000E+01, 0.97670000E+00,
  0.94599430E+03, 0.143E+03, 0.120E+03, 0.16682000E+01, 0.98310000E+00,
  0.45591090E+03, 0.143E+03, 0.121E+03, 0.16682000E+01, 0.18627000E+01,
  0.44025610E+03, 0.143E+03, 0.122E+03, 0.16682000E+01, 0.18299000E+01,
  0.43163910E+03, 0.143E+03, 0.123E+03, 0.16682000E+01, 0.19138000E+01,
  0.42896620E+03, 0.143E+03, 0.124E+03, 0.16682000E+01, 0.18269000E+01,
  0.38890660E+03, 0.143E+03, 0.125E+03, 0.16682000E+01, 0.16406000E+01,
  0.35865620E+03, 0.143E+03, 0.126E+03, 0.16682000E+01, 0.16483000E+01,
  0.34229790E+03, 0.143E+03, 0.127E+03, 0.16682000E+01, 0.17149000E+01,
  0.33502870E+03, 0.143E+03, 0.128E+03, 0.16682000E+01, 0.17937000E+01,
  0.33456150E+03, 0.143E+03, 0.129E+03, 0.16682000E+01, 0.95760000E+00,
  0.30788150E+03, 0.143E+03, 0.130E+03, 0.16682000E+01, 0.19419000E+01,
  0.52114410E+03, 0.143E+03, 0.131E+03, 0.16682000E+01, 0.96010000E+00,
  0.44771310E+03, 0.143E+03, 0.132E+03, 0.16682000E+01, 0.94340000E+00,
  0.39524720E+03, 0.143E+03, 0.133E+03, 0.16682000E+01, 0.98890000E+00,
  0.35747370E+03, 0.143E+03, 0.134E+03, 0.16682000E+01, 0.99010000E+00,
  0.31169010E+03, 0.143E+03, 0.135E+03, 0.16682000E+01, 0.99740000E+00,
  0.55612550E+03, 0.143E+03, 0.137E+03, 0.16682000E+01, 0.97380000E+00,
  0.11562604E+04, 0.143E+03, 0.138E+03, 0.16682000E+01, 0.98010000E+00,
  0.84837270E+03, 0.143E+03, 0.139E+03, 0.16682000E+01, 0.19153000E+01,
  0.60533890E+03, 0.143E+03, 0.140E+03, 0.16682000E+01, 0.19355000E+01,
  0.61127640E+03, 0.143E+03, 0.141E+03, 0.16682000E+01, 0.19545000E+01,
  0.56776700E+03, 0.143E+03, 0.142E+03, 0.16682000E+01, 0.19420000E+01,
  0.64971430E+03, 0.143E+03, 0.143E+03, 0.16682000E+01, 0.16682000E+01,
  0.33187500E+02, 0.144E+03, 0.100E+01, 0.18584000E+01, 0.91180000E+00,
  0.22061600E+02, 0.144E+03, 0.200E+01, 0.18584000E+01, 0.00000000E+00,
  0.51733300E+03, 0.144E+03, 0.300E+01, 0.18584000E+01, 0.00000000E+00,
  0.29751860E+03, 0.144E+03, 0.400E+01, 0.18584000E+01, 0.00000000E+00,
  0.20032990E+03, 0.144E+03, 0.500E+01, 0.18584000E+01, 0.00000000E+00,
  0.13555170E+03, 0.144E+03, 0.600E+01, 0.18584000E+01, 0.00000000E+00,
  0.95019000E+02, 0.144E+03, 0.700E+01, 0.18584000E+01, 0.00000000E+00,
  0.72117300E+02, 0.144E+03, 0.800E+01, 0.18584000E+01, 0.00000000E+00,
  0.54778100E+02, 0.144E+03, 0.900E+01, 0.18584000E+01, 0.00000000E+00,
  0.42243200E+02, 0.144E+03, 0.100E+02, 0.18584000E+01, 0.00000000E+00,
  0.61866690E+03, 0.144E+03, 0.110E+02, 0.18584000E+01, 0.00000000E+00,
  0.47441800E+03, 0.144E+03, 0.120E+02, 0.18584000E+01, 0.00000000E+00,
  0.43702090E+03, 0.144E+03, 0.130E+02, 0.18584000E+01, 0.00000000E+00,
  0.34421130E+03, 0.144E+03, 0.140E+02, 0.18584000E+01, 0.00000000E+00,
  0.26854160E+03, 0.144E+03, 0.150E+02, 0.18584000E+01, 0.00000000E+00,
  0.22308830E+03, 0.144E+03, 0.160E+02, 0.18584000E+01, 0.00000000E+00,
  0.18247210E+03, 0.144E+03, 0.170E+02, 0.18584000E+01, 0.00000000E+00,
  0.14952220E+03, 0.144E+03, 0.180E+02, 0.18584000E+01, 0.00000000E+00,
  0.10157997E+04, 0.144E+03, 0.190E+02, 0.18584000E+01, 0.00000000E+00,
  0.83526920E+03, 0.144E+03, 0.200E+02, 0.18584000E+01, 0.00000000E+00,
  0.68960880E+03, 0.144E+03, 0.210E+02, 0.18584000E+01, 0.00000000E+00,
  0.66581430E+03, 0.144E+03, 0.220E+02, 0.18584000E+01, 0.00000000E+00,
  0.60961590E+03, 0.144E+03, 0.230E+02, 0.18584000E+01, 0.00000000E+00,
  0.48063820E+03, 0.144E+03, 0.240E+02, 0.18584000E+01, 0.00000000E+00,
  0.52477480E+03, 0.144E+03, 0.250E+02, 0.18584000E+01, 0.00000000E+00,
  0.41224680E+03, 0.144E+03, 0.260E+02, 0.18584000E+01, 0.00000000E+00,
  0.43640540E+03, 0.144E+03, 0.270E+02, 0.18584000E+01, 0.00000000E+00,
  0.44958060E+03, 0.144E+03, 0.280E+02, 0.18584000E+01, 0.00000000E+00,
  0.34510430E+03, 0.144E+03, 0.290E+02, 0.18584000E+01, 0.00000000E+00,
  0.35378800E+03, 0.144E+03, 0.300E+02, 0.18584000E+01, 0.00000000E+00,
  0.41885730E+03, 0.144E+03, 0.310E+02, 0.18584000E+01, 0.00000000E+00,
  0.36917340E+03, 0.144E+03, 0.320E+02, 0.18584000E+01, 0.00000000E+00,
  0.31492530E+03, 0.144E+03, 0.330E+02, 0.18584000E+01, 0.00000000E+00,
  0.28273020E+03, 0.144E+03, 0.340E+02, 0.18584000E+01, 0.00000000E+00,
  0.24762030E+03, 0.144E+03, 0.350E+02, 0.18584000E+01, 0.00000000E+00,
  0.21556830E+03, 0.144E+03, 0.360E+02, 0.18584000E+01, 0.00000000E+00,
  0.11385265E+04, 0.144E+03, 0.370E+02, 0.18584000E+01, 0.00000000E+00,
  0.99561160E+03, 0.144E+03, 0.380E+02, 0.18584000E+01, 0.00000000E+00,
  0.87126000E+03, 0.144E+03, 0.390E+02, 0.18584000E+01, 0.00000000E+00,
  0.78271660E+03, 0.144E+03, 0.400E+02, 0.18584000E+01, 0.00000000E+00,
  0.71364770E+03, 0.144E+03, 0.410E+02, 0.18584000E+01, 0.00000000E+00,
  0.55112400E+03, 0.144E+03, 0.420E+02, 0.18584000E+01, 0.00000000E+00,
  0.61481850E+03, 0.144E+03, 0.430E+02, 0.18584000E+01, 0.00000000E+00,
  0.46856950E+03, 0.144E+03, 0.440E+02, 0.18584000E+01, 0.00000000E+00,
  0.51183150E+03, 0.144E+03, 0.450E+02, 0.18584000E+01, 0.00000000E+00,
  0.47463690E+03, 0.144E+03, 0.460E+02, 0.18584000E+01, 0.00000000E+00,
  0.39627420E+03, 0.144E+03, 0.470E+02, 0.18584000E+01, 0.00000000E+00,
  0.41825790E+03, 0.144E+03, 0.480E+02, 0.18584000E+01, 0.00000000E+00,
  0.52482360E+03, 0.144E+03, 0.490E+02, 0.18584000E+01, 0.00000000E+00,
  0.48488550E+03, 0.144E+03, 0.500E+02, 0.18584000E+01, 0.00000000E+00,
  0.43198650E+03, 0.144E+03, 0.510E+02, 0.18584000E+01, 0.00000000E+00,
  0.40083190E+03, 0.144E+03, 0.520E+02, 0.18584000E+01, 0.00000000E+00,
  0.36253740E+03, 0.144E+03, 0.530E+02, 0.18584000E+01, 0.00000000E+00,
  0.32611570E+03, 0.144E+03, 0.540E+02, 0.18584000E+01, 0.00000000E+00,
  0.13871242E+04, 0.144E+03, 0.550E+02, 0.18584000E+01, 0.00000000E+00,
  0.12701002E+04, 0.144E+03, 0.560E+02, 0.18584000E+01, 0.00000000E+00,
  0.11145962E+04, 0.144E+03, 0.570E+02, 0.18584000E+01, 0.00000000E+00,
  0.51058640E+03, 0.144E+03, 0.580E+02, 0.18584000E+01, 0.27991000E+01,
  0.11251127E+04, 0.144E+03, 0.590E+02, 0.18584000E+01, 0.00000000E+00,
  0.10801628E+04, 0.144E+03, 0.600E+02, 0.18584000E+01, 0.00000000E+00,
  0.10529974E+04, 0.144E+03, 0.610E+02, 0.18584000E+01, 0.00000000E+00,
  0.10280158E+04, 0.144E+03, 0.620E+02, 0.18584000E+01, 0.00000000E+00,
  0.10058586E+04, 0.144E+03, 0.630E+02, 0.18584000E+01, 0.00000000E+00,
  0.79051760E+03, 0.144E+03, 0.640E+02, 0.18584000E+01, 0.00000000E+00,
  0.89187640E+03, 0.144E+03, 0.650E+02, 0.18584000E+01, 0.00000000E+00,
  0.85997290E+03, 0.144E+03, 0.660E+02, 0.18584000E+01, 0.00000000E+00,
  0.90692140E+03, 0.144E+03, 0.670E+02, 0.18584000E+01, 0.00000000E+00,
  0.88762020E+03, 0.144E+03, 0.680E+02, 0.18584000E+01, 0.00000000E+00,
  0.87020630E+03, 0.144E+03, 0.690E+02, 0.18584000E+01, 0.00000000E+00,
  0.86003450E+03, 0.144E+03, 0.700E+02, 0.18584000E+01, 0.00000000E+00,
  0.72429040E+03, 0.144E+03, 0.710E+02, 0.18584000E+01, 0.00000000E+00,
  0.71147790E+03, 0.144E+03, 0.720E+02, 0.18584000E+01, 0.00000000E+00,
  0.64914710E+03, 0.144E+03, 0.730E+02, 0.18584000E+01, 0.00000000E+00,
  0.54842120E+03, 0.144E+03, 0.740E+02, 0.18584000E+01, 0.00000000E+00,
  0.55775610E+03, 0.144E+03, 0.750E+02, 0.18584000E+01, 0.00000000E+00,
  0.50549330E+03, 0.144E+03, 0.760E+02, 0.18584000E+01, 0.00000000E+00,
  0.46298700E+03, 0.144E+03, 0.770E+02, 0.18584000E+01, 0.00000000E+00,
  0.38491460E+03, 0.144E+03, 0.780E+02, 0.18584000E+01, 0.00000000E+00,
  0.35974270E+03, 0.144E+03, 0.790E+02, 0.18584000E+01, 0.00000000E+00,
  0.36989520E+03, 0.144E+03, 0.800E+02, 0.18584000E+01, 0.00000000E+00,
  0.53929820E+03, 0.144E+03, 0.810E+02, 0.18584000E+01, 0.00000000E+00,
  0.52677380E+03, 0.144E+03, 0.820E+02, 0.18584000E+01, 0.00000000E+00,
  0.48381430E+03, 0.144E+03, 0.830E+02, 0.18584000E+01, 0.00000000E+00,
  0.46139360E+03, 0.144E+03, 0.840E+02, 0.18584000E+01, 0.00000000E+00,
  0.42587210E+03, 0.144E+03, 0.850E+02, 0.18584000E+01, 0.00000000E+00,
  0.39047110E+03, 0.144E+03, 0.860E+02, 0.18584000E+01, 0.00000000E+00,
  0.13086904E+04, 0.144E+03, 0.870E+02, 0.18584000E+01, 0.00000000E+00,
  0.12553593E+04, 0.144E+03, 0.880E+02, 0.18584000E+01, 0.00000000E+00,
  0.11084934E+04, 0.144E+03, 0.890E+02, 0.18584000E+01, 0.00000000E+00,
  0.99548230E+03, 0.144E+03, 0.900E+02, 0.18584000E+01, 0.00000000E+00,
  0.98913640E+03, 0.144E+03, 0.910E+02, 0.18584000E+01, 0.00000000E+00,
  0.95777810E+03, 0.144E+03, 0.920E+02, 0.18584000E+01, 0.00000000E+00,
  0.98673520E+03, 0.144E+03, 0.930E+02, 0.18584000E+01, 0.00000000E+00,
  0.95542490E+03, 0.144E+03, 0.940E+02, 0.18584000E+01, 0.00000000E+00,
  0.53364800E+02, 0.144E+03, 0.101E+03, 0.18584000E+01, 0.00000000E+00,
  0.17297080E+03, 0.144E+03, 0.103E+03, 0.18584000E+01, 0.98650000E+00,
  0.22067460E+03, 0.144E+03, 0.104E+03, 0.18584000E+01, 0.98080000E+00,
  0.16859440E+03, 0.144E+03, 0.105E+03, 0.18584000E+01, 0.97060000E+00,
  0.12721250E+03, 0.144E+03, 0.106E+03, 0.18584000E+01, 0.98680000E+00,
  0.88661300E+02, 0.144E+03, 0.107E+03, 0.18584000E+01, 0.99440000E+00,
  0.64744800E+02, 0.144E+03, 0.108E+03, 0.18584000E+01, 0.99250000E+00,
  0.44708700E+02, 0.144E+03, 0.109E+03, 0.18584000E+01, 0.99820000E+00,
  0.25309000E+03, 0.144E+03, 0.111E+03, 0.18584000E+01, 0.96840000E+00,
  0.39136060E+03, 0.144E+03, 0.112E+03, 0.18584000E+01, 0.96280000E+00,
  0.39606340E+03, 0.144E+03, 0.113E+03, 0.18584000E+01, 0.96480000E+00,
  0.31817950E+03, 0.144E+03, 0.114E+03, 0.18584000E+01, 0.95070000E+00,
  0.26070120E+03, 0.144E+03, 0.115E+03, 0.18584000E+01, 0.99470000E+00,
  0.22064770E+03, 0.144E+03, 0.116E+03, 0.18584000E+01, 0.99480000E+00,
  0.18059160E+03, 0.144E+03, 0.117E+03, 0.18584000E+01, 0.99720000E+00,
  0.34947530E+03, 0.144E+03, 0.119E+03, 0.18584000E+01, 0.97670000E+00,
  0.66876460E+03, 0.144E+03, 0.120E+03, 0.18584000E+01, 0.98310000E+00,
  0.34907020E+03, 0.144E+03, 0.121E+03, 0.18584000E+01, 0.18627000E+01,
  0.33705530E+03, 0.144E+03, 0.122E+03, 0.18584000E+01, 0.18299000E+01,
  0.33035670E+03, 0.144E+03, 0.123E+03, 0.18584000E+01, 0.19138000E+01,
  0.32735530E+03, 0.144E+03, 0.124E+03, 0.18584000E+01, 0.18269000E+01,
  0.30103970E+03, 0.144E+03, 0.125E+03, 0.18584000E+01, 0.16406000E+01,
  0.27865260E+03, 0.144E+03, 0.126E+03, 0.18584000E+01, 0.16483000E+01,
  0.26587520E+03, 0.144E+03, 0.127E+03, 0.18584000E+01, 0.17149000E+01,
  0.25994720E+03, 0.144E+03, 0.128E+03, 0.18584000E+01, 0.17937000E+01,
  0.25694800E+03, 0.144E+03, 0.129E+03, 0.18584000E+01, 0.95760000E+00,
  0.24091240E+03, 0.144E+03, 0.130E+03, 0.18584000E+01, 0.19419000E+01,
  0.39335710E+03, 0.144E+03, 0.131E+03, 0.18584000E+01, 0.96010000E+00,
  0.34538720E+03, 0.144E+03, 0.132E+03, 0.18584000E+01, 0.94340000E+00,
  0.30960350E+03, 0.144E+03, 0.133E+03, 0.18584000E+01, 0.98890000E+00,
  0.28284600E+03, 0.144E+03, 0.134E+03, 0.18584000E+01, 0.99010000E+00,
  0.24934040E+03, 0.144E+03, 0.135E+03, 0.18584000E+01, 0.99740000E+00,
  0.41708310E+03, 0.144E+03, 0.137E+03, 0.18584000E+01, 0.97380000E+00,
  0.81419750E+03, 0.144E+03, 0.138E+03, 0.18584000E+01, 0.98010000E+00,
  0.62130580E+03, 0.144E+03, 0.139E+03, 0.18584000E+01, 0.19153000E+01,
  0.46191410E+03, 0.144E+03, 0.140E+03, 0.18584000E+01, 0.19355000E+01,
  0.46653580E+03, 0.144E+03, 0.141E+03, 0.18584000E+01, 0.19545000E+01,
  0.43510620E+03, 0.144E+03, 0.142E+03, 0.18584000E+01, 0.19420000E+01,
  0.48832640E+03, 0.144E+03, 0.143E+03, 0.18584000E+01, 0.16682000E+01,
  0.37926550E+03, 0.144E+03, 0.144E+03, 0.18584000E+01, 0.18584000E+01,
  0.31102400E+02, 0.145E+03, 0.100E+01, 0.19003000E+01, 0.91180000E+00,
  0.20777600E+02, 0.145E+03, 0.200E+01, 0.19003000E+01, 0.00000000E+00,
  0.48243420E+03, 0.145E+03, 0.300E+01, 0.19003000E+01, 0.00000000E+00,
  0.27741740E+03, 0.145E+03, 0.400E+01, 0.19003000E+01, 0.00000000E+00,
  0.18713270E+03, 0.145E+03, 0.500E+01, 0.19003000E+01, 0.00000000E+00,
  0.12690850E+03, 0.145E+03, 0.600E+01, 0.19003000E+01, 0.00000000E+00,
  0.89165900E+02, 0.145E+03, 0.700E+01, 0.19003000E+01, 0.00000000E+00,
  0.67811400E+02, 0.145E+03, 0.800E+01, 0.19003000E+01, 0.00000000E+00,
  0.51611700E+02, 0.145E+03, 0.900E+01, 0.19003000E+01, 0.00000000E+00,
  0.39876200E+02, 0.145E+03, 0.100E+02, 0.19003000E+01, 0.00000000E+00,
  0.57701810E+03, 0.145E+03, 0.110E+02, 0.19003000E+01, 0.00000000E+00,
  0.44233810E+03, 0.145E+03, 0.120E+02, 0.19003000E+01, 0.00000000E+00,
  0.40769990E+03, 0.145E+03, 0.130E+02, 0.19003000E+01, 0.00000000E+00,
  0.32145940E+03, 0.145E+03, 0.140E+02, 0.19003000E+01, 0.00000000E+00,
  0.25114770E+03, 0.145E+03, 0.150E+02, 0.19003000E+01, 0.00000000E+00,
  0.20890670E+03, 0.145E+03, 0.160E+02, 0.19003000E+01, 0.00000000E+00,
  0.17111870E+03, 0.145E+03, 0.170E+02, 0.19003000E+01, 0.00000000E+00,
  0.14042730E+03, 0.145E+03, 0.180E+02, 0.19003000E+01, 0.00000000E+00,
  0.94851400E+03, 0.145E+03, 0.190E+02, 0.19003000E+01, 0.00000000E+00,
  0.77905470E+03, 0.145E+03, 0.200E+02, 0.19003000E+01, 0.00000000E+00,
  0.64318930E+03, 0.145E+03, 0.210E+02, 0.19003000E+01, 0.00000000E+00,
  0.62118070E+03, 0.145E+03, 0.220E+02, 0.19003000E+01, 0.00000000E+00,
  0.56883480E+03, 0.145E+03, 0.230E+02, 0.19003000E+01, 0.00000000E+00,
  0.44875270E+03, 0.145E+03, 0.240E+02, 0.19003000E+01, 0.00000000E+00,
  0.48979330E+03, 0.145E+03, 0.250E+02, 0.19003000E+01, 0.00000000E+00,
  0.38501530E+03, 0.145E+03, 0.260E+02, 0.19003000E+01, 0.00000000E+00,
  0.40745740E+03, 0.145E+03, 0.270E+02, 0.19003000E+01, 0.00000000E+00,
  0.41967090E+03, 0.145E+03, 0.280E+02, 0.19003000E+01, 0.00000000E+00,
  0.32239880E+03, 0.145E+03, 0.290E+02, 0.19003000E+01, 0.00000000E+00,
  0.33047130E+03, 0.145E+03, 0.300E+02, 0.19003000E+01, 0.00000000E+00,
  0.39105080E+03, 0.145E+03, 0.310E+02, 0.19003000E+01, 0.00000000E+00,
  0.34491000E+03, 0.145E+03, 0.320E+02, 0.19003000E+01, 0.00000000E+00,
  0.29454210E+03, 0.145E+03, 0.330E+02, 0.19003000E+01, 0.00000000E+00,
  0.26467170E+03, 0.145E+03, 0.340E+02, 0.19003000E+01, 0.00000000E+00,
  0.23205800E+03, 0.145E+03, 0.350E+02, 0.19003000E+01, 0.00000000E+00,
  0.20225670E+03, 0.145E+03, 0.360E+02, 0.19003000E+01, 0.00000000E+00,
  0.10633477E+04, 0.145E+03, 0.370E+02, 0.19003000E+01, 0.00000000E+00,
  0.92882550E+03, 0.145E+03, 0.380E+02, 0.19003000E+01, 0.00000000E+00,
  0.81293380E+03, 0.145E+03, 0.390E+02, 0.19003000E+01, 0.00000000E+00,
  0.73049700E+03, 0.145E+03, 0.400E+02, 0.19003000E+01, 0.00000000E+00,
  0.66622590E+03, 0.145E+03, 0.410E+02, 0.19003000E+01, 0.00000000E+00,
  0.51491280E+03, 0.145E+03, 0.420E+02, 0.19003000E+01, 0.00000000E+00,
  0.57424560E+03, 0.145E+03, 0.430E+02, 0.19003000E+01, 0.00000000E+00,
  0.43804260E+03, 0.145E+03, 0.440E+02, 0.19003000E+01, 0.00000000E+00,
  0.47828480E+03, 0.145E+03, 0.450E+02, 0.19003000E+01, 0.00000000E+00,
  0.44362800E+03, 0.145E+03, 0.460E+02, 0.19003000E+01, 0.00000000E+00,
  0.37063780E+03, 0.145E+03, 0.470E+02, 0.19003000E+01, 0.00000000E+00,
  0.39106750E+03, 0.145E+03, 0.480E+02, 0.19003000E+01, 0.00000000E+00,
  0.49033250E+03, 0.145E+03, 0.490E+02, 0.19003000E+01, 0.00000000E+00,
  0.45317940E+03, 0.145E+03, 0.500E+02, 0.19003000E+01, 0.00000000E+00,
  0.40403840E+03, 0.145E+03, 0.510E+02, 0.19003000E+01, 0.00000000E+00,
  0.37513030E+03, 0.145E+03, 0.520E+02, 0.19003000E+01, 0.00000000E+00,
  0.33956200E+03, 0.145E+03, 0.530E+02, 0.19003000E+01, 0.00000000E+00,
  0.30572010E+03, 0.145E+03, 0.540E+02, 0.19003000E+01, 0.00000000E+00,
  0.12958507E+04, 0.145E+03, 0.550E+02, 0.19003000E+01, 0.00000000E+00,
  0.11851747E+04, 0.145E+03, 0.560E+02, 0.19003000E+01, 0.00000000E+00,
  0.10401066E+04, 0.145E+03, 0.570E+02, 0.19003000E+01, 0.00000000E+00,
  0.47759450E+03, 0.145E+03, 0.580E+02, 0.19003000E+01, 0.27991000E+01,
  0.10500763E+04, 0.145E+03, 0.590E+02, 0.19003000E+01, 0.00000000E+00,
  0.10080521E+04, 0.145E+03, 0.600E+02, 0.19003000E+01, 0.00000000E+00,
  0.98268750E+03, 0.145E+03, 0.610E+02, 0.19003000E+01, 0.00000000E+00,
  0.95935980E+03, 0.145E+03, 0.620E+02, 0.19003000E+01, 0.00000000E+00,
  0.93866880E+03, 0.145E+03, 0.630E+02, 0.19003000E+01, 0.00000000E+00,
  0.73813170E+03, 0.145E+03, 0.640E+02, 0.19003000E+01, 0.00000000E+00,
  0.83296700E+03, 0.145E+03, 0.650E+02, 0.19003000E+01, 0.00000000E+00,
  0.80325110E+03, 0.145E+03, 0.660E+02, 0.19003000E+01, 0.00000000E+00,
  0.84631030E+03, 0.145E+03, 0.670E+02, 0.19003000E+01, 0.00000000E+00,
  0.82828260E+03, 0.145E+03, 0.680E+02, 0.19003000E+01, 0.00000000E+00,
  0.81202140E+03, 0.145E+03, 0.690E+02, 0.19003000E+01, 0.00000000E+00,
  0.80250260E+03, 0.145E+03, 0.700E+02, 0.19003000E+01, 0.00000000E+00,
  0.67613200E+03, 0.145E+03, 0.710E+02, 0.19003000E+01, 0.00000000E+00,
  0.66419530E+03, 0.145E+03, 0.720E+02, 0.19003000E+01, 0.00000000E+00,
  0.60624630E+03, 0.145E+03, 0.730E+02, 0.19003000E+01, 0.00000000E+00,
  0.51256560E+03, 0.145E+03, 0.740E+02, 0.19003000E+01, 0.00000000E+00,
  0.52130610E+03, 0.145E+03, 0.750E+02, 0.19003000E+01, 0.00000000E+00,
  0.47268090E+03, 0.145E+03, 0.760E+02, 0.19003000E+01, 0.00000000E+00,
  0.43312920E+03, 0.145E+03, 0.770E+02, 0.19003000E+01, 0.00000000E+00,
  0.36041730E+03, 0.145E+03, 0.780E+02, 0.19003000E+01, 0.00000000E+00,
  0.33697140E+03, 0.145E+03, 0.790E+02, 0.19003000E+01, 0.00000000E+00,
  0.34645260E+03, 0.145E+03, 0.800E+02, 0.19003000E+01, 0.00000000E+00,
  0.50424040E+03, 0.145E+03, 0.810E+02, 0.19003000E+01, 0.00000000E+00,
  0.49256890E+03, 0.145E+03, 0.820E+02, 0.19003000E+01, 0.00000000E+00,
  0.45264510E+03, 0.145E+03, 0.830E+02, 0.19003000E+01, 0.00000000E+00,
  0.43185880E+03, 0.145E+03, 0.840E+02, 0.19003000E+01, 0.00000000E+00,
  0.39887680E+03, 0.145E+03, 0.850E+02, 0.19003000E+01, 0.00000000E+00,
  0.36599140E+03, 0.145E+03, 0.860E+02, 0.19003000E+01, 0.00000000E+00,
  0.12224485E+04, 0.145E+03, 0.870E+02, 0.19003000E+01, 0.00000000E+00,
  0.11715378E+04, 0.145E+03, 0.880E+02, 0.19003000E+01, 0.00000000E+00,
  0.10345633E+04, 0.145E+03, 0.890E+02, 0.19003000E+01, 0.00000000E+00,
  0.92953190E+03, 0.145E+03, 0.900E+02, 0.19003000E+01, 0.00000000E+00,
  0.92366730E+03, 0.145E+03, 0.910E+02, 0.19003000E+01, 0.00000000E+00,
  0.89441350E+03, 0.145E+03, 0.920E+02, 0.19003000E+01, 0.00000000E+00,
  0.92128530E+03, 0.145E+03, 0.930E+02, 0.19003000E+01, 0.00000000E+00,
  0.89206410E+03, 0.145E+03, 0.940E+02, 0.19003000E+01, 0.00000000E+00,
  0.49909000E+02, 0.145E+03, 0.101E+03, 0.19003000E+01, 0.00000000E+00,
  0.16134990E+03, 0.145E+03, 0.103E+03, 0.19003000E+01, 0.98650000E+00,
  0.20595300E+03, 0.145E+03, 0.104E+03, 0.19003000E+01, 0.98080000E+00,
  0.15759490E+03, 0.145E+03, 0.105E+03, 0.19003000E+01, 0.97060000E+00,
  0.11912650E+03, 0.145E+03, 0.106E+03, 0.19003000E+01, 0.98680000E+00,
  0.83222700E+02, 0.145E+03, 0.107E+03, 0.19003000E+01, 0.99440000E+00,
  0.60915900E+02, 0.145E+03, 0.108E+03, 0.19003000E+01, 0.99250000E+00,
  0.42208400E+02, 0.145E+03, 0.109E+03, 0.19003000E+01, 0.99820000E+00,
  0.23614440E+03, 0.145E+03, 0.111E+03, 0.19003000E+01, 0.96840000E+00,
  0.36507050E+03, 0.145E+03, 0.112E+03, 0.19003000E+01, 0.96280000E+00,
  0.36958140E+03, 0.145E+03, 0.113E+03, 0.19003000E+01, 0.96480000E+00,
  0.29723390E+03, 0.145E+03, 0.114E+03, 0.19003000E+01, 0.95070000E+00,
  0.24384390E+03, 0.145E+03, 0.115E+03, 0.19003000E+01, 0.99470000E+00,
  0.20662580E+03, 0.145E+03, 0.116E+03, 0.19003000E+01, 0.99480000E+00,
  0.16935840E+03, 0.145E+03, 0.117E+03, 0.19003000E+01, 0.99720000E+00,
  0.32659470E+03, 0.145E+03, 0.119E+03, 0.19003000E+01, 0.97670000E+00,
  0.62428500E+03, 0.145E+03, 0.120E+03, 0.19003000E+01, 0.98310000E+00,
  0.32625030E+03, 0.145E+03, 0.121E+03, 0.19003000E+01, 0.18627000E+01,
  0.31509820E+03, 0.145E+03, 0.122E+03, 0.19003000E+01, 0.18299000E+01,
  0.30884820E+03, 0.145E+03, 0.123E+03, 0.19003000E+01, 0.19138000E+01,
  0.30603400E+03, 0.145E+03, 0.124E+03, 0.19003000E+01, 0.18269000E+01,
  0.28151340E+03, 0.145E+03, 0.125E+03, 0.19003000E+01, 0.16406000E+01,
  0.26065670E+03, 0.145E+03, 0.126E+03, 0.19003000E+01, 0.16483000E+01,
  0.24873880E+03, 0.145E+03, 0.127E+03, 0.19003000E+01, 0.17149000E+01,
  0.24319090E+03, 0.145E+03, 0.128E+03, 0.19003000E+01, 0.17937000E+01,
  0.24032600E+03, 0.145E+03, 0.129E+03, 0.19003000E+01, 0.95760000E+00,
  0.22543980E+03, 0.145E+03, 0.130E+03, 0.19003000E+01, 0.19419000E+01,
  0.36731970E+03, 0.145E+03, 0.131E+03, 0.19003000E+01, 0.96010000E+00,
  0.32278160E+03, 0.145E+03, 0.132E+03, 0.19003000E+01, 0.94340000E+00,
  0.28959340E+03, 0.145E+03, 0.133E+03, 0.19003000E+01, 0.98890000E+00,
  0.26478150E+03, 0.145E+03, 0.134E+03, 0.19003000E+01, 0.99010000E+00,
  0.23366080E+03, 0.145E+03, 0.135E+03, 0.19003000E+01, 0.99740000E+00,
  0.38991830E+03, 0.145E+03, 0.137E+03, 0.19003000E+01, 0.97380000E+00,
  0.76024370E+03, 0.145E+03, 0.138E+03, 0.19003000E+01, 0.98010000E+00,
  0.58041450E+03, 0.145E+03, 0.139E+03, 0.19003000E+01, 0.19153000E+01,
  0.43182880E+03, 0.145E+03, 0.140E+03, 0.19003000E+01, 0.19355000E+01,
  0.43614400E+03, 0.145E+03, 0.141E+03, 0.19003000E+01, 0.19545000E+01,
  0.40693380E+03, 0.145E+03, 0.142E+03, 0.19003000E+01, 0.19420000E+01,
  0.45656180E+03, 0.145E+03, 0.143E+03, 0.19003000E+01, 0.16682000E+01,
  0.35492820E+03, 0.145E+03, 0.144E+03, 0.19003000E+01, 0.18584000E+01,
  0.33224250E+03, 0.145E+03, 0.145E+03, 0.19003000E+01, 0.19003000E+01,
  0.28966100E+02, 0.146E+03, 0.100E+01, 0.18630000E+01, 0.91180000E+00,
  0.19468900E+02, 0.146E+03, 0.200E+01, 0.18630000E+01, 0.00000000E+00,
  0.44391060E+03, 0.146E+03, 0.300E+01, 0.18630000E+01, 0.00000000E+00,
  0.25623270E+03, 0.146E+03, 0.400E+01, 0.18630000E+01, 0.00000000E+00,
  0.17343600E+03, 0.146E+03, 0.500E+01, 0.18630000E+01, 0.00000000E+00,
  0.11801370E+03, 0.146E+03, 0.600E+01, 0.18630000E+01, 0.00000000E+00,
  0.83171000E+02, 0.146E+03, 0.700E+01, 0.18630000E+01, 0.00000000E+00,
  0.63412500E+02, 0.146E+03, 0.800E+01, 0.18630000E+01, 0.00000000E+00,
  0.48382400E+02, 0.146E+03, 0.900E+01, 0.18630000E+01, 0.00000000E+00,
  0.37464700E+02, 0.146E+03, 0.100E+02, 0.18630000E+01, 0.00000000E+00,
  0.53116760E+03, 0.146E+03, 0.110E+02, 0.18630000E+01, 0.00000000E+00,
  0.40830220E+03, 0.146E+03, 0.120E+02, 0.18630000E+01, 0.00000000E+00,
  0.37687760E+03, 0.146E+03, 0.130E+02, 0.18630000E+01, 0.00000000E+00,
  0.29781740E+03, 0.146E+03, 0.140E+02, 0.18630000E+01, 0.00000000E+00,
  0.23321060E+03, 0.146E+03, 0.150E+02, 0.18630000E+01, 0.00000000E+00,
  0.19433730E+03, 0.146E+03, 0.160E+02, 0.18630000E+01, 0.00000000E+00,
  0.15949140E+03, 0.146E+03, 0.170E+02, 0.18630000E+01, 0.00000000E+00,
  0.13113380E+03, 0.146E+03, 0.180E+02, 0.18630000E+01, 0.00000000E+00,
  0.87329840E+03, 0.146E+03, 0.190E+02, 0.18630000E+01, 0.00000000E+00,
  0.71849830E+03, 0.146E+03, 0.200E+02, 0.18630000E+01, 0.00000000E+00,
  0.59349940E+03, 0.146E+03, 0.210E+02, 0.18630000E+01, 0.00000000E+00,
  0.57359720E+03, 0.146E+03, 0.220E+02, 0.18630000E+01, 0.00000000E+00,
  0.52547320E+03, 0.146E+03, 0.230E+02, 0.18630000E+01, 0.00000000E+00,
  0.41479180E+03, 0.146E+03, 0.240E+02, 0.18630000E+01, 0.00000000E+00,
  0.45273530E+03, 0.146E+03, 0.250E+02, 0.18630000E+01, 0.00000000E+00,
  0.35613440E+03, 0.146E+03, 0.260E+02, 0.18630000E+01, 0.00000000E+00,
  0.37699280E+03, 0.146E+03, 0.270E+02, 0.18630000E+01, 0.00000000E+00,
  0.38812000E+03, 0.146E+03, 0.280E+02, 0.18630000E+01, 0.00000000E+00,
  0.29838940E+03, 0.146E+03, 0.290E+02, 0.18630000E+01, 0.00000000E+00,
  0.30606330E+03, 0.146E+03, 0.300E+02, 0.18630000E+01, 0.00000000E+00,
  0.36187800E+03, 0.146E+03, 0.310E+02, 0.18630000E+01, 0.00000000E+00,
  0.31969460E+03, 0.146E+03, 0.320E+02, 0.18630000E+01, 0.00000000E+00,
  0.27350100E+03, 0.146E+03, 0.330E+02, 0.18630000E+01, 0.00000000E+00,
  0.24609210E+03, 0.146E+03, 0.340E+02, 0.18630000E+01, 0.00000000E+00,
  0.21609450E+03, 0.146E+03, 0.350E+02, 0.18630000E+01, 0.00000000E+00,
  0.18863390E+03, 0.146E+03, 0.360E+02, 0.18630000E+01, 0.00000000E+00,
  0.97940320E+03, 0.146E+03, 0.370E+02, 0.18630000E+01, 0.00000000E+00,
  0.85671690E+03, 0.146E+03, 0.380E+02, 0.18630000E+01, 0.00000000E+00,
  0.75059330E+03, 0.146E+03, 0.390E+02, 0.18630000E+01, 0.00000000E+00,
  0.67499290E+03, 0.146E+03, 0.400E+02, 0.18630000E+01, 0.00000000E+00,
  0.61597590E+03, 0.146E+03, 0.410E+02, 0.18630000E+01, 0.00000000E+00,
  0.47670900E+03, 0.146E+03, 0.420E+02, 0.18630000E+01, 0.00000000E+00,
  0.53137000E+03, 0.146E+03, 0.430E+02, 0.18630000E+01, 0.00000000E+00,
  0.40593980E+03, 0.146E+03, 0.440E+02, 0.18630000E+01, 0.00000000E+00,
  0.44306590E+03, 0.146E+03, 0.450E+02, 0.18630000E+01, 0.00000000E+00,
  0.41113610E+03, 0.146E+03, 0.460E+02, 0.18630000E+01, 0.00000000E+00,
  0.34367070E+03, 0.146E+03, 0.470E+02, 0.18630000E+01, 0.00000000E+00,
  0.36264320E+03, 0.146E+03, 0.480E+02, 0.18630000E+01, 0.00000000E+00,
  0.45405760E+03, 0.146E+03, 0.490E+02, 0.18630000E+01, 0.00000000E+00,
  0.42012680E+03, 0.146E+03, 0.500E+02, 0.18630000E+01, 0.00000000E+00,
  0.37509950E+03, 0.146E+03, 0.510E+02, 0.18630000E+01, 0.00000000E+00,
  0.34860740E+03, 0.146E+03, 0.520E+02, 0.18630000E+01, 0.00000000E+00,
  0.31592880E+03, 0.146E+03, 0.530E+02, 0.18630000E+01, 0.00000000E+00,
  0.28479640E+03, 0.146E+03, 0.540E+02, 0.18630000E+01, 0.00000000E+00,
  0.11937040E+04, 0.146E+03, 0.550E+02, 0.18630000E+01, 0.00000000E+00,
  0.10930044E+04, 0.146E+03, 0.560E+02, 0.18630000E+01, 0.00000000E+00,
  0.96013460E+03, 0.146E+03, 0.570E+02, 0.18630000E+01, 0.00000000E+00,
  0.44336290E+03, 0.146E+03, 0.580E+02, 0.18630000E+01, 0.27991000E+01,
  0.96887580E+03, 0.146E+03, 0.590E+02, 0.18630000E+01, 0.00000000E+00,
  0.93022500E+03, 0.146E+03, 0.600E+02, 0.18630000E+01, 0.00000000E+00,
  0.90685110E+03, 0.146E+03, 0.610E+02, 0.18630000E+01, 0.00000000E+00,
  0.88534770E+03, 0.146E+03, 0.620E+02, 0.18630000E+01, 0.00000000E+00,
  0.86627480E+03, 0.146E+03, 0.630E+02, 0.18630000E+01, 0.00000000E+00,
  0.68220730E+03, 0.146E+03, 0.640E+02, 0.18630000E+01, 0.00000000E+00,
  0.76879040E+03, 0.146E+03, 0.650E+02, 0.18630000E+01, 0.00000000E+00,
  0.74151490E+03, 0.146E+03, 0.660E+02, 0.18630000E+01, 0.00000000E+00,
  0.78120400E+03, 0.146E+03, 0.670E+02, 0.18630000E+01, 0.00000000E+00,
  0.76457050E+03, 0.146E+03, 0.680E+02, 0.18630000E+01, 0.00000000E+00,
  0.74957790E+03, 0.146E+03, 0.690E+02, 0.18630000E+01, 0.00000000E+00,
  0.74073920E+03, 0.146E+03, 0.700E+02, 0.18630000E+01, 0.00000000E+00,
  0.62471570E+03, 0.146E+03, 0.710E+02, 0.18630000E+01, 0.00000000E+00,
  0.61425310E+03, 0.146E+03, 0.720E+02, 0.18630000E+01, 0.00000000E+00,
  0.56115170E+03, 0.146E+03, 0.730E+02, 0.18630000E+01, 0.00000000E+00,
  0.47494930E+03, 0.146E+03, 0.740E+02, 0.18630000E+01, 0.00000000E+00,
  0.48315690E+03, 0.146E+03, 0.750E+02, 0.18630000E+01, 0.00000000E+00,
  0.43846770E+03, 0.146E+03, 0.760E+02, 0.18630000E+01, 0.00000000E+00,
  0.40208340E+03, 0.146E+03, 0.770E+02, 0.18630000E+01, 0.00000000E+00,
  0.33498540E+03, 0.146E+03, 0.780E+02, 0.18630000E+01, 0.00000000E+00,
  0.31334830E+03, 0.146E+03, 0.790E+02, 0.18630000E+01, 0.00000000E+00,
  0.32218840E+03, 0.146E+03, 0.800E+02, 0.18630000E+01, 0.00000000E+00,
  0.46735710E+03, 0.146E+03, 0.810E+02, 0.18630000E+01, 0.00000000E+00,
  0.45686740E+03, 0.146E+03, 0.820E+02, 0.18630000E+01, 0.00000000E+00,
  0.42032740E+03, 0.146E+03, 0.830E+02, 0.18630000E+01, 0.00000000E+00,
  0.40133490E+03, 0.146E+03, 0.840E+02, 0.18630000E+01, 0.00000000E+00,
  0.37107280E+03, 0.146E+03, 0.850E+02, 0.18630000E+01, 0.00000000E+00,
  0.34084580E+03, 0.146E+03, 0.860E+02, 0.18630000E+01, 0.00000000E+00,
  0.11269549E+04, 0.146E+03, 0.870E+02, 0.18630000E+01, 0.00000000E+00,
  0.10810405E+04, 0.146E+03, 0.880E+02, 0.18630000E+01, 0.00000000E+00,
  0.95553590E+03, 0.146E+03, 0.890E+02, 0.18630000E+01, 0.00000000E+00,
  0.85969500E+03, 0.146E+03, 0.900E+02, 0.18630000E+01, 0.00000000E+00,
  0.85393730E+03, 0.146E+03, 0.910E+02, 0.18630000E+01, 0.00000000E+00,
  0.82694450E+03, 0.146E+03, 0.920E+02, 0.18630000E+01, 0.00000000E+00,
  0.85119160E+03, 0.146E+03, 0.930E+02, 0.18630000E+01, 0.00000000E+00,
  0.82429470E+03, 0.146E+03, 0.940E+02, 0.18630000E+01, 0.00000000E+00,
  0.46348900E+02, 0.146E+03, 0.101E+03, 0.18630000E+01, 0.00000000E+00,
  0.14912090E+03, 0.146E+03, 0.103E+03, 0.18630000E+01, 0.98650000E+00,
  0.19048260E+03, 0.146E+03, 0.104E+03, 0.18630000E+01, 0.98080000E+00,
  0.14620200E+03, 0.146E+03, 0.105E+03, 0.18630000E+01, 0.97060000E+00,
  0.11079460E+03, 0.146E+03, 0.106E+03, 0.18630000E+01, 0.98680000E+00,
  0.77647900E+02, 0.146E+03, 0.107E+03, 0.18630000E+01, 0.99440000E+00,
  0.57004900E+02, 0.146E+03, 0.108E+03, 0.18630000E+01, 0.99250000E+00,
  0.39663600E+02, 0.146E+03, 0.109E+03, 0.18630000E+01, 0.99820000E+00,
  0.21823330E+03, 0.146E+03, 0.111E+03, 0.18630000E+01, 0.96840000E+00,
  0.33722560E+03, 0.146E+03, 0.112E+03, 0.18630000E+01, 0.96280000E+00,
  0.34179460E+03, 0.146E+03, 0.113E+03, 0.18630000E+01, 0.96480000E+00,
  0.27549250E+03, 0.146E+03, 0.114E+03, 0.18630000E+01, 0.95070000E+00,
  0.22646050E+03, 0.146E+03, 0.115E+03, 0.18630000E+01, 0.99470000E+00,
  0.19221720E+03, 0.146E+03, 0.116E+03, 0.18630000E+01, 0.99480000E+00,
  0.15785240E+03, 0.146E+03, 0.117E+03, 0.18630000E+01, 0.99720000E+00,
  0.30246350E+03, 0.146E+03, 0.119E+03, 0.18630000E+01, 0.97670000E+00,
  0.57613740E+03, 0.146E+03, 0.120E+03, 0.18630000E+01, 0.98310000E+00,
  0.30248980E+03, 0.146E+03, 0.121E+03, 0.18630000E+01, 0.18627000E+01,
  0.29221350E+03, 0.146E+03, 0.122E+03, 0.18630000E+01, 0.18299000E+01,
  0.28642780E+03, 0.146E+03, 0.123E+03, 0.18630000E+01, 0.19138000E+01,
  0.28377850E+03, 0.146E+03, 0.124E+03, 0.18630000E+01, 0.18269000E+01,
  0.26126350E+03, 0.146E+03, 0.125E+03, 0.18630000E+01, 0.16406000E+01,
  0.24201470E+03, 0.146E+03, 0.126E+03, 0.18630000E+01, 0.16483000E+01,
  0.23097880E+03, 0.146E+03, 0.127E+03, 0.18630000E+01, 0.17149000E+01,
  0.22581650E+03, 0.146E+03, 0.128E+03, 0.18630000E+01, 0.17937000E+01,
  0.22301540E+03, 0.146E+03, 0.129E+03, 0.18630000E+01, 0.95760000E+00,
  0.20945460E+03, 0.146E+03, 0.130E+03, 0.18630000E+01, 0.19419000E+01,
  0.34006750E+03, 0.146E+03, 0.131E+03, 0.18630000E+01, 0.96010000E+00,
  0.29932800E+03, 0.146E+03, 0.132E+03, 0.18630000E+01, 0.94340000E+00,
  0.26894270E+03, 0.146E+03, 0.133E+03, 0.18630000E+01, 0.98890000E+00,
  0.24619370E+03, 0.146E+03, 0.134E+03, 0.18630000E+01, 0.99010000E+00,
  0.21757380E+03, 0.146E+03, 0.135E+03, 0.18630000E+01, 0.99740000E+00,
  0.36130470E+03, 0.146E+03, 0.137E+03, 0.18630000E+01, 0.97380000E+00,
  0.70165500E+03, 0.146E+03, 0.138E+03, 0.18630000E+01, 0.98010000E+00,
  0.53685660E+03, 0.146E+03, 0.139E+03, 0.18630000E+01, 0.19153000E+01,
  0.40042090E+03, 0.146E+03, 0.140E+03, 0.18630000E+01, 0.19355000E+01,
  0.40443000E+03, 0.146E+03, 0.141E+03, 0.18630000E+01, 0.19545000E+01,
  0.37755350E+03, 0.146E+03, 0.142E+03, 0.18630000E+01, 0.19420000E+01,
  0.42312790E+03, 0.146E+03, 0.143E+03, 0.18630000E+01, 0.16682000E+01,
  0.32968260E+03, 0.146E+03, 0.144E+03, 0.18630000E+01, 0.18584000E+01,
  0.30870590E+03, 0.146E+03, 0.145E+03, 0.18630000E+01, 0.19003000E+01,
  0.28695190E+03, 0.146E+03, 0.146E+03, 0.18630000E+01, 0.18630000E+01,
  0.27951800E+02, 0.147E+03, 0.100E+01, 0.96790000E+00, 0.91180000E+00,
  0.18773100E+02, 0.147E+03, 0.200E+01, 0.96790000E+00, 0.00000000E+00,
  0.43260780E+03, 0.147E+03, 0.300E+01, 0.96790000E+00, 0.00000000E+00,
  0.24865730E+03, 0.147E+03, 0.400E+01, 0.96790000E+00, 0.00000000E+00,
  0.16783500E+03, 0.147E+03, 0.500E+01, 0.96790000E+00, 0.00000000E+00,
  0.11399930E+03, 0.147E+03, 0.600E+01, 0.96790000E+00, 0.00000000E+00,
  0.80266300E+02, 0.147E+03, 0.700E+01, 0.96790000E+00, 0.00000000E+00,
  0.61174800E+02, 0.147E+03, 0.800E+01, 0.96790000E+00, 0.00000000E+00,
  0.46672600E+02, 0.147E+03, 0.900E+01, 0.96790000E+00, 0.00000000E+00,
  0.36148600E+02, 0.147E+03, 0.100E+02, 0.96790000E+00, 0.00000000E+00,
  0.51756800E+03, 0.147E+03, 0.110E+02, 0.96790000E+00, 0.00000000E+00,
  0.39661250E+03, 0.147E+03, 0.120E+02, 0.96790000E+00, 0.00000000E+00,
  0.36552690E+03, 0.147E+03, 0.130E+02, 0.96790000E+00, 0.00000000E+00,
  0.28828630E+03, 0.147E+03, 0.140E+02, 0.96790000E+00, 0.00000000E+00,
  0.22539450E+03, 0.147E+03, 0.150E+02, 0.96790000E+00, 0.00000000E+00,
  0.18765970E+03, 0.147E+03, 0.160E+02, 0.96790000E+00, 0.00000000E+00,
  0.15390320E+03, 0.147E+03, 0.170E+02, 0.96790000E+00, 0.00000000E+00,
  0.12648250E+03, 0.147E+03, 0.180E+02, 0.96790000E+00, 0.00000000E+00,
  0.85100880E+03, 0.147E+03, 0.190E+02, 0.96790000E+00, 0.00000000E+00,
  0.69886180E+03, 0.147E+03, 0.200E+02, 0.96790000E+00, 0.00000000E+00,
  0.57696360E+03, 0.147E+03, 0.210E+02, 0.96790000E+00, 0.00000000E+00,
  0.55728800E+03, 0.147E+03, 0.220E+02, 0.96790000E+00, 0.00000000E+00,
  0.51036440E+03, 0.147E+03, 0.230E+02, 0.96790000E+00, 0.00000000E+00,
  0.40283830E+03, 0.147E+03, 0.240E+02, 0.96790000E+00, 0.00000000E+00,
  0.43950990E+03, 0.147E+03, 0.250E+02, 0.96790000E+00, 0.00000000E+00,
  0.34569950E+03, 0.147E+03, 0.260E+02, 0.96790000E+00, 0.00000000E+00,
  0.36569250E+03, 0.147E+03, 0.270E+02, 0.96790000E+00, 0.00000000E+00,
  0.37662810E+03, 0.147E+03, 0.280E+02, 0.96790000E+00, 0.00000000E+00,
  0.28955800E+03, 0.147E+03, 0.290E+02, 0.96790000E+00, 0.00000000E+00,
  0.29667280E+03, 0.147E+03, 0.300E+02, 0.96790000E+00, 0.00000000E+00,
  0.35080100E+03, 0.147E+03, 0.310E+02, 0.96790000E+00, 0.00000000E+00,
  0.30945430E+03, 0.147E+03, 0.320E+02, 0.96790000E+00, 0.00000000E+00,
  0.26439570E+03, 0.147E+03, 0.330E+02, 0.96790000E+00, 0.00000000E+00,
  0.23772170E+03, 0.147E+03, 0.340E+02, 0.96790000E+00, 0.00000000E+00,
  0.20860440E+03, 0.147E+03, 0.350E+02, 0.96790000E+00, 0.00000000E+00,
  0.18200160E+03, 0.147E+03, 0.360E+02, 0.96790000E+00, 0.00000000E+00,
  0.95413200E+03, 0.147E+03, 0.370E+02, 0.96790000E+00, 0.00000000E+00,
  0.83331680E+03, 0.147E+03, 0.380E+02, 0.96790000E+00, 0.00000000E+00,
  0.72933160E+03, 0.147E+03, 0.390E+02, 0.96790000E+00, 0.00000000E+00,
  0.65543290E+03, 0.147E+03, 0.400E+02, 0.96790000E+00, 0.00000000E+00,
  0.59785280E+03, 0.147E+03, 0.410E+02, 0.96790000E+00, 0.00000000E+00,
  0.46233830E+03, 0.147E+03, 0.420E+02, 0.96790000E+00, 0.00000000E+00,
  0.51549530E+03, 0.147E+03, 0.430E+02, 0.96790000E+00, 0.00000000E+00,
  0.39350880E+03, 0.147E+03, 0.440E+02, 0.96790000E+00, 0.00000000E+00,
  0.42951430E+03, 0.147E+03, 0.450E+02, 0.96790000E+00, 0.00000000E+00,
  0.39846620E+03, 0.147E+03, 0.460E+02, 0.96790000E+00, 0.00000000E+00,
  0.33315830E+03, 0.147E+03, 0.470E+02, 0.96790000E+00, 0.00000000E+00,
  0.35137120E+03, 0.147E+03, 0.480E+02, 0.96790000E+00, 0.00000000E+00,
  0.44027330E+03, 0.147E+03, 0.490E+02, 0.96790000E+00, 0.00000000E+00,
  0.40690290E+03, 0.147E+03, 0.500E+02, 0.96790000E+00, 0.00000000E+00,
  0.36287400E+03, 0.147E+03, 0.510E+02, 0.96790000E+00, 0.00000000E+00,
  0.33701310E+03, 0.147E+03, 0.520E+02, 0.96790000E+00, 0.00000000E+00,
  0.30521220E+03, 0.147E+03, 0.530E+02, 0.96790000E+00, 0.00000000E+00,
  0.27497440E+03, 0.147E+03, 0.540E+02, 0.96790000E+00, 0.00000000E+00,
  0.11625520E+04, 0.147E+03, 0.550E+02, 0.96790000E+00, 0.00000000E+00,
  0.10633544E+04, 0.147E+03, 0.560E+02, 0.96790000E+00, 0.00000000E+00,
  0.93316800E+03, 0.147E+03, 0.570E+02, 0.96790000E+00, 0.00000000E+00,
  0.42899800E+03, 0.147E+03, 0.580E+02, 0.96790000E+00, 0.27991000E+01,
  0.94235470E+03, 0.147E+03, 0.590E+02, 0.96790000E+00, 0.00000000E+00,
  0.90466880E+03, 0.147E+03, 0.600E+02, 0.96790000E+00, 0.00000000E+00,
  0.88190710E+03, 0.147E+03, 0.610E+02, 0.96790000E+00, 0.00000000E+00,
  0.86096980E+03, 0.147E+03, 0.620E+02, 0.96790000E+00, 0.00000000E+00,
  0.84239660E+03, 0.147E+03, 0.630E+02, 0.96790000E+00, 0.00000000E+00,
  0.66260290E+03, 0.147E+03, 0.640E+02, 0.96790000E+00, 0.00000000E+00,
  0.74772470E+03, 0.147E+03, 0.650E+02, 0.96790000E+00, 0.00000000E+00,
  0.72101030E+03, 0.147E+03, 0.660E+02, 0.96790000E+00, 0.00000000E+00,
  0.75950840E+03, 0.147E+03, 0.670E+02, 0.96790000E+00, 0.00000000E+00,
  0.74332210E+03, 0.147E+03, 0.680E+02, 0.96790000E+00, 0.00000000E+00,
  0.72872030E+03, 0.147E+03, 0.690E+02, 0.96790000E+00, 0.00000000E+00,
  0.72016540E+03, 0.147E+03, 0.700E+02, 0.96790000E+00, 0.00000000E+00,
  0.60683130E+03, 0.147E+03, 0.710E+02, 0.96790000E+00, 0.00000000E+00,
  0.59598520E+03, 0.147E+03, 0.720E+02, 0.96790000E+00, 0.00000000E+00,
  0.54409850E+03, 0.147E+03, 0.730E+02, 0.96790000E+00, 0.00000000E+00,
  0.46026700E+03, 0.147E+03, 0.740E+02, 0.96790000E+00, 0.00000000E+00,
  0.46810840E+03, 0.147E+03, 0.750E+02, 0.96790000E+00, 0.00000000E+00,
  0.42458230E+03, 0.147E+03, 0.760E+02, 0.96790000E+00, 0.00000000E+00,
  0.38918700E+03, 0.147E+03, 0.770E+02, 0.96790000E+00, 0.00000000E+00,
  0.32412400E+03, 0.147E+03, 0.780E+02, 0.96790000E+00, 0.00000000E+00,
  0.30315550E+03, 0.147E+03, 0.790E+02, 0.96790000E+00, 0.00000000E+00,
  0.31163540E+03, 0.147E+03, 0.800E+02, 0.96790000E+00, 0.00000000E+00,
  0.45304550E+03, 0.147E+03, 0.810E+02, 0.96790000E+00, 0.00000000E+00,
  0.44250950E+03, 0.147E+03, 0.820E+02, 0.96790000E+00, 0.00000000E+00,
  0.40670840E+03, 0.147E+03, 0.830E+02, 0.96790000E+00, 0.00000000E+00,
  0.38810010E+03, 0.147E+03, 0.840E+02, 0.96790000E+00, 0.00000000E+00,
  0.35859540E+03, 0.147E+03, 0.850E+02, 0.96790000E+00, 0.00000000E+00,
  0.32919900E+03, 0.147E+03, 0.860E+02, 0.96790000E+00, 0.00000000E+00,
  0.10968369E+04, 0.147E+03, 0.870E+02, 0.96790000E+00, 0.00000000E+00,
  0.10511515E+04, 0.147E+03, 0.880E+02, 0.96790000E+00, 0.00000000E+00,
  0.92833020E+03, 0.147E+03, 0.890E+02, 0.96790000E+00, 0.00000000E+00,
  0.83431790E+03, 0.147E+03, 0.900E+02, 0.96790000E+00, 0.00000000E+00,
  0.82919230E+03, 0.147E+03, 0.910E+02, 0.96790000E+00, 0.00000000E+00,
  0.80298090E+03, 0.147E+03, 0.920E+02, 0.96790000E+00, 0.00000000E+00,
  0.82716130E+03, 0.147E+03, 0.930E+02, 0.96790000E+00, 0.00000000E+00,
  0.80093320E+03, 0.147E+03, 0.940E+02, 0.96790000E+00, 0.00000000E+00,
  0.44783500E+02, 0.147E+03, 0.101E+03, 0.96790000E+00, 0.00000000E+00,
  0.14465630E+03, 0.147E+03, 0.103E+03, 0.96790000E+00, 0.98650000E+00,
  0.18465300E+03, 0.147E+03, 0.104E+03, 0.96790000E+00, 0.98080000E+00,
  0.14140600E+03, 0.147E+03, 0.105E+03, 0.96790000E+00, 0.97060000E+00,
  0.10702860E+03, 0.147E+03, 0.106E+03, 0.96790000E+00, 0.98680000E+00,
  0.74935400E+02, 0.147E+03, 0.107E+03, 0.96790000E+00, 0.99440000E+00,
  0.54985600E+02, 0.147E+03, 0.108E+03, 0.96790000E+00, 0.99250000E+00,
  0.38253900E+02, 0.147E+03, 0.109E+03, 0.96790000E+00, 0.99820000E+00,
  0.21184190E+03, 0.147E+03, 0.111E+03, 0.96790000E+00, 0.96840000E+00,
  0.32735090E+03, 0.147E+03, 0.112E+03, 0.96790000E+00, 0.96280000E+00,
  0.33138320E+03, 0.147E+03, 0.113E+03, 0.96790000E+00, 0.96480000E+00,
  0.26660080E+03, 0.147E+03, 0.114E+03, 0.96790000E+00, 0.95070000E+00,
  0.21886170E+03, 0.147E+03, 0.115E+03, 0.96790000E+00, 0.99470000E+00,
  0.18561970E+03, 0.147E+03, 0.116E+03, 0.96790000E+00, 0.99480000E+00,
  0.15232700E+03, 0.147E+03, 0.117E+03, 0.96790000E+00, 0.99720000E+00,
  0.29329110E+03, 0.147E+03, 0.119E+03, 0.96790000E+00, 0.97670000E+00,
  0.56012980E+03, 0.147E+03, 0.120E+03, 0.96790000E+00, 0.98310000E+00,
  0.29290630E+03, 0.147E+03, 0.121E+03, 0.96790000E+00, 0.18627000E+01,
  0.28293320E+03, 0.147E+03, 0.122E+03, 0.96790000E+00, 0.18299000E+01,
  0.27735250E+03, 0.147E+03, 0.123E+03, 0.96790000E+00, 0.19138000E+01,
  0.27484520E+03, 0.147E+03, 0.124E+03, 0.96790000E+00, 0.18269000E+01,
  0.25282980E+03, 0.147E+03, 0.125E+03, 0.96790000E+00, 0.16406000E+01,
  0.23415110E+03, 0.147E+03, 0.126E+03, 0.96790000E+00, 0.16483000E+01,
  0.22348050E+03, 0.147E+03, 0.127E+03, 0.96790000E+00, 0.17149000E+01,
  0.21850750E+03, 0.147E+03, 0.128E+03, 0.96790000E+00, 0.17937000E+01,
  0.21595810E+03, 0.147E+03, 0.129E+03, 0.96790000E+00, 0.95760000E+00,
  0.20256850E+03, 0.147E+03, 0.130E+03, 0.96790000E+00, 0.19419000E+01,
  0.32953870E+03, 0.147E+03, 0.131E+03, 0.96790000E+00, 0.96010000E+00,
  0.28964110E+03, 0.147E+03, 0.132E+03, 0.96790000E+00, 0.94340000E+00,
  0.25997060E+03, 0.147E+03, 0.133E+03, 0.96790000E+00, 0.98890000E+00,
  0.23782380E+03, 0.147E+03, 0.134E+03, 0.96790000E+00, 0.99010000E+00,
  0.21004110E+03, 0.147E+03, 0.135E+03, 0.96790000E+00, 0.99740000E+00,
  0.35022950E+03, 0.147E+03, 0.137E+03, 0.96790000E+00, 0.97380000E+00,
  0.68218170E+03, 0.147E+03, 0.138E+03, 0.96790000E+00, 0.98010000E+00,
  0.52087240E+03, 0.147E+03, 0.139E+03, 0.96790000E+00, 0.19153000E+01,
  0.38773360E+03, 0.147E+03, 0.140E+03, 0.96790000E+00, 0.19355000E+01,
  0.39166370E+03, 0.147E+03, 0.141E+03, 0.96790000E+00, 0.19545000E+01,
  0.36552610E+03, 0.147E+03, 0.142E+03, 0.96790000E+00, 0.19420000E+01,
  0.41006670E+03, 0.147E+03, 0.143E+03, 0.96790000E+00, 0.16682000E+01,
  0.31896650E+03, 0.147E+03, 0.144E+03, 0.96790000E+00, 0.18584000E+01,
  0.29866780E+03, 0.147E+03, 0.145E+03, 0.96790000E+00, 0.19003000E+01,
  0.27760230E+03, 0.147E+03, 0.146E+03, 0.96790000E+00, 0.18630000E+01,
  0.26861300E+03, 0.147E+03, 0.147E+03, 0.96790000E+00, 0.96790000E+00,
  0.27928100E+02, 0.148E+03, 0.100E+01, 0.19539000E+01, 0.91180000E+00,
  0.18860700E+02, 0.148E+03, 0.200E+01, 0.19539000E+01, 0.00000000E+00,
  0.40844290E+03, 0.148E+03, 0.300E+01, 0.19539000E+01, 0.00000000E+00,
  0.24209500E+03, 0.148E+03, 0.400E+01, 0.19539000E+01, 0.00000000E+00,
  0.16565870E+03, 0.148E+03, 0.500E+01, 0.19539000E+01, 0.00000000E+00,
  0.11343690E+03, 0.148E+03, 0.600E+01, 0.19539000E+01, 0.00000000E+00,
  0.80249200E+02, 0.148E+03, 0.700E+01, 0.19539000E+01, 0.00000000E+00,
  0.61323400E+02, 0.148E+03, 0.800E+01, 0.19539000E+01, 0.00000000E+00,
  0.46869200E+02, 0.148E+03, 0.900E+01, 0.19539000E+01, 0.00000000E+00,
  0.36340100E+02, 0.148E+03, 0.100E+02, 0.19539000E+01, 0.00000000E+00,
  0.48951290E+03, 0.148E+03, 0.110E+02, 0.19539000E+01, 0.00000000E+00,
  0.38417280E+03, 0.148E+03, 0.120E+02, 0.19539000E+01, 0.00000000E+00,
  0.35686540E+03, 0.148E+03, 0.130E+02, 0.19539000E+01, 0.00000000E+00,
  0.28421390E+03, 0.148E+03, 0.140E+02, 0.19539000E+01, 0.00000000E+00,
  0.22377830E+03, 0.148E+03, 0.150E+02, 0.19539000E+01, 0.00000000E+00,
  0.18701630E+03, 0.148E+03, 0.160E+02, 0.19539000E+01, 0.00000000E+00,
  0.15385920E+03, 0.148E+03, 0.170E+02, 0.19539000E+01, 0.00000000E+00,
  0.12673560E+03, 0.148E+03, 0.180E+02, 0.19539000E+01, 0.00000000E+00,
  0.80025930E+03, 0.148E+03, 0.190E+02, 0.19539000E+01, 0.00000000E+00,
  0.67026330E+03, 0.148E+03, 0.200E+02, 0.19539000E+01, 0.00000000E+00,
  0.55566790E+03, 0.148E+03, 0.210E+02, 0.19539000E+01, 0.00000000E+00,
  0.53855020E+03, 0.148E+03, 0.220E+02, 0.19539000E+01, 0.00000000E+00,
  0.49422370E+03, 0.148E+03, 0.230E+02, 0.19539000E+01, 0.00000000E+00,
  0.38999530E+03, 0.148E+03, 0.240E+02, 0.19539000E+01, 0.00000000E+00,
  0.42685790E+03, 0.148E+03, 0.250E+02, 0.19539000E+01, 0.00000000E+00,
  0.33576420E+03, 0.148E+03, 0.260E+02, 0.19539000E+01, 0.00000000E+00,
  0.35691720E+03, 0.148E+03, 0.270E+02, 0.19539000E+01, 0.00000000E+00,
  0.36686680E+03, 0.148E+03, 0.280E+02, 0.19539000E+01, 0.00000000E+00,
  0.28186750E+03, 0.148E+03, 0.290E+02, 0.19539000E+01, 0.00000000E+00,
  0.29078950E+03, 0.148E+03, 0.300E+02, 0.19539000E+01, 0.00000000E+00,
  0.34329430E+03, 0.148E+03, 0.310E+02, 0.19539000E+01, 0.00000000E+00,
  0.30514680E+03, 0.148E+03, 0.320E+02, 0.19539000E+01, 0.00000000E+00,
  0.26228400E+03, 0.148E+03, 0.330E+02, 0.19539000E+01, 0.00000000E+00,
  0.23657790E+03, 0.148E+03, 0.340E+02, 0.19539000E+01, 0.00000000E+00,
  0.20821130E+03, 0.148E+03, 0.350E+02, 0.19539000E+01, 0.00000000E+00,
  0.18208670E+03, 0.148E+03, 0.360E+02, 0.19539000E+01, 0.00000000E+00,
  0.89853420E+03, 0.148E+03, 0.370E+02, 0.19539000E+01, 0.00000000E+00,
  0.79845280E+03, 0.148E+03, 0.380E+02, 0.19539000E+01, 0.00000000E+00,
  0.70379920E+03, 0.148E+03, 0.390E+02, 0.19539000E+01, 0.00000000E+00,
  0.63513700E+03, 0.148E+03, 0.400E+02, 0.19539000E+01, 0.00000000E+00,
  0.58084120E+03, 0.148E+03, 0.410E+02, 0.19539000E+01, 0.00000000E+00,
  0.45097760E+03, 0.148E+03, 0.420E+02, 0.19539000E+01, 0.00000000E+00,
  0.50211680E+03, 0.148E+03, 0.430E+02, 0.19539000E+01, 0.00000000E+00,
  0.38494360E+03, 0.148E+03, 0.440E+02, 0.19539000E+01, 0.00000000E+00,
  0.42037460E+03, 0.148E+03, 0.450E+02, 0.19539000E+01, 0.00000000E+00,
  0.39057700E+03, 0.148E+03, 0.460E+02, 0.19539000E+01, 0.00000000E+00,
  0.32596620E+03, 0.148E+03, 0.470E+02, 0.19539000E+01, 0.00000000E+00,
  0.34505990E+03, 0.148E+03, 0.480E+02, 0.19539000E+01, 0.00000000E+00,
  0.43036070E+03, 0.148E+03, 0.490E+02, 0.19539000E+01, 0.00000000E+00,
  0.40034740E+03, 0.148E+03, 0.500E+02, 0.19539000E+01, 0.00000000E+00,
  0.35905550E+03, 0.148E+03, 0.510E+02, 0.19539000E+01, 0.00000000E+00,
  0.33449170E+03, 0.148E+03, 0.520E+02, 0.19539000E+01, 0.00000000E+00,
  0.30384100E+03, 0.148E+03, 0.530E+02, 0.19539000E+01, 0.00000000E+00,
  0.27444070E+03, 0.148E+03, 0.540E+02, 0.19539000E+01, 0.00000000E+00,
  0.10949943E+04, 0.148E+03, 0.550E+02, 0.19539000E+01, 0.00000000E+00,
  0.10161802E+04, 0.148E+03, 0.560E+02, 0.19539000E+01, 0.00000000E+00,
  0.89820920E+03, 0.148E+03, 0.570E+02, 0.19539000E+01, 0.00000000E+00,
  0.42389100E+03, 0.148E+03, 0.580E+02, 0.19539000E+01, 0.27991000E+01,
  0.90262940E+03, 0.148E+03, 0.590E+02, 0.19539000E+01, 0.00000000E+00,
  0.86759380E+03, 0.148E+03, 0.600E+02, 0.19539000E+01, 0.00000000E+00,
  0.84606160E+03, 0.148E+03, 0.610E+02, 0.19539000E+01, 0.00000000E+00,
  0.82622610E+03, 0.148E+03, 0.620E+02, 0.19539000E+01, 0.00000000E+00,
  0.80864130E+03, 0.148E+03, 0.630E+02, 0.19539000E+01, 0.00000000E+00,
  0.64073930E+03, 0.148E+03, 0.640E+02, 0.19539000E+01, 0.00000000E+00,
  0.71462060E+03, 0.148E+03, 0.650E+02, 0.19539000E+01, 0.00000000E+00,
  0.69004230E+03, 0.148E+03, 0.660E+02, 0.19539000E+01, 0.00000000E+00,
  0.73042860E+03, 0.148E+03, 0.670E+02, 0.19539000E+01, 0.00000000E+00,
  0.71501980E+03, 0.148E+03, 0.680E+02, 0.19539000E+01, 0.00000000E+00,
  0.70118290E+03, 0.148E+03, 0.690E+02, 0.19539000E+01, 0.00000000E+00,
  0.69275040E+03, 0.148E+03, 0.700E+02, 0.19539000E+01, 0.00000000E+00,
  0.58668300E+03, 0.148E+03, 0.710E+02, 0.19539000E+01, 0.00000000E+00,
  0.58027960E+03, 0.148E+03, 0.720E+02, 0.19539000E+01, 0.00000000E+00,
  0.53179240E+03, 0.148E+03, 0.730E+02, 0.19539000E+01, 0.00000000E+00,
  0.45093600E+03, 0.148E+03, 0.740E+02, 0.19539000E+01, 0.00000000E+00,
  0.45935930E+03, 0.148E+03, 0.750E+02, 0.19539000E+01, 0.00000000E+00,
  0.41790820E+03, 0.148E+03, 0.760E+02, 0.19539000E+01, 0.00000000E+00,
  0.38396000E+03, 0.148E+03, 0.770E+02, 0.19539000E+01, 0.00000000E+00,
  0.32036400E+03, 0.148E+03, 0.780E+02, 0.19539000E+01, 0.00000000E+00,
  0.29986260E+03, 0.148E+03, 0.790E+02, 0.19539000E+01, 0.00000000E+00,
  0.30870590E+03, 0.148E+03, 0.800E+02, 0.19539000E+01, 0.00000000E+00,
  0.44321180E+03, 0.148E+03, 0.810E+02, 0.19539000E+01, 0.00000000E+00,
  0.43519640E+03, 0.148E+03, 0.820E+02, 0.19539000E+01, 0.00000000E+00,
  0.40209000E+03, 0.148E+03, 0.830E+02, 0.19539000E+01, 0.00000000E+00,
  0.38476220E+03, 0.148E+03, 0.840E+02, 0.19539000E+01, 0.00000000E+00,
  0.35659780E+03, 0.148E+03, 0.850E+02, 0.19539000E+01, 0.00000000E+00,
  0.32818400E+03, 0.148E+03, 0.860E+02, 0.19539000E+01, 0.00000000E+00,
  0.10391920E+04, 0.148E+03, 0.870E+02, 0.19539000E+01, 0.00000000E+00,
  0.10081792E+04, 0.148E+03, 0.880E+02, 0.19539000E+01, 0.00000000E+00,
  0.89630090E+03, 0.148E+03, 0.890E+02, 0.19539000E+01, 0.00000000E+00,
  0.81114820E+03, 0.148E+03, 0.900E+02, 0.19539000E+01, 0.00000000E+00,
  0.80315200E+03, 0.148E+03, 0.910E+02, 0.19539000E+01, 0.00000000E+00,
  0.77787630E+03, 0.148E+03, 0.920E+02, 0.19539000E+01, 0.00000000E+00,
  0.79775990E+03, 0.148E+03, 0.930E+02, 0.19539000E+01, 0.00000000E+00,
  0.77311930E+03, 0.148E+03, 0.940E+02, 0.19539000E+01, 0.00000000E+00,
  0.44500600E+02, 0.148E+03, 0.101E+03, 0.19539000E+01, 0.00000000E+00,
  0.14109010E+03, 0.148E+03, 0.103E+03, 0.19539000E+01, 0.98650000E+00,
  0.18052070E+03, 0.148E+03, 0.104E+03, 0.19539000E+01, 0.98080000E+00,
  0.13987930E+03, 0.148E+03, 0.105E+03, 0.19539000E+01, 0.97060000E+00,
  0.10643320E+03, 0.148E+03, 0.106E+03, 0.19539000E+01, 0.98680000E+00,
  0.74892500E+02, 0.148E+03, 0.107E+03, 0.19539000E+01, 0.99440000E+00,
  0.55139200E+02, 0.148E+03, 0.108E+03, 0.19539000E+01, 0.99250000E+00,
  0.38490600E+02, 0.148E+03, 0.109E+03, 0.19539000E+01, 0.99820000E+00,
  0.20596470E+03, 0.148E+03, 0.111E+03, 0.19539000E+01, 0.96840000E+00,
  0.31790020E+03, 0.148E+03, 0.112E+03, 0.19539000E+01, 0.96280000E+00,
  0.32408300E+03, 0.148E+03, 0.113E+03, 0.19539000E+01, 0.96480000E+00,
  0.26314380E+03, 0.148E+03, 0.114E+03, 0.19539000E+01, 0.95070000E+00,
  0.21731990E+03, 0.148E+03, 0.115E+03, 0.19539000E+01, 0.99470000E+00,
  0.18495220E+03, 0.148E+03, 0.116E+03, 0.19539000E+01, 0.99480000E+00,
  0.15226460E+03, 0.148E+03, 0.117E+03, 0.19539000E+01, 0.99720000E+00,
  0.28627350E+03, 0.148E+03, 0.119E+03, 0.19539000E+01, 0.97670000E+00,
  0.53708890E+03, 0.148E+03, 0.120E+03, 0.19539000E+01, 0.98310000E+00,
  0.28838750E+03, 0.148E+03, 0.121E+03, 0.19539000E+01, 0.18627000E+01,
  0.27858690E+03, 0.148E+03, 0.122E+03, 0.19539000E+01, 0.18299000E+01,
  0.27303310E+03, 0.148E+03, 0.123E+03, 0.19539000E+01, 0.19138000E+01,
  0.27028900E+03, 0.148E+03, 0.124E+03, 0.19539000E+01, 0.18269000E+01,
  0.24982010E+03, 0.148E+03, 0.125E+03, 0.19539000E+01, 0.16406000E+01,
  0.23161700E+03, 0.148E+03, 0.126E+03, 0.19539000E+01, 0.16483000E+01,
  0.22102480E+03, 0.148E+03, 0.127E+03, 0.19539000E+01, 0.17149000E+01,
  0.21602110E+03, 0.148E+03, 0.128E+03, 0.19539000E+01, 0.17937000E+01,
  0.21274680E+03, 0.148E+03, 0.129E+03, 0.19539000E+01, 0.95760000E+00,
  0.20082240E+03, 0.148E+03, 0.130E+03, 0.19539000E+01, 0.19419000E+01,
  0.32310800E+03, 0.148E+03, 0.131E+03, 0.19539000E+01, 0.96010000E+00,
  0.28605510E+03, 0.148E+03, 0.132E+03, 0.19539000E+01, 0.94340000E+00,
  0.25796890E+03, 0.148E+03, 0.133E+03, 0.19539000E+01, 0.98890000E+00,
  0.23666040E+03, 0.148E+03, 0.134E+03, 0.19539000E+01, 0.99010000E+00,
  0.20960830E+03, 0.148E+03, 0.135E+03, 0.19539000E+01, 0.99740000E+00,
  0.34234100E+03, 0.148E+03, 0.137E+03, 0.19539000E+01, 0.97380000E+00,
  0.65327820E+03, 0.148E+03, 0.138E+03, 0.19539000E+01, 0.98010000E+00,
  0.50567470E+03, 0.148E+03, 0.139E+03, 0.19539000E+01, 0.19153000E+01,
  0.38134050E+03, 0.148E+03, 0.140E+03, 0.19539000E+01, 0.19355000E+01,
  0.38512060E+03, 0.148E+03, 0.141E+03, 0.19539000E+01, 0.19545000E+01,
  0.35990590E+03, 0.148E+03, 0.142E+03, 0.19539000E+01, 0.19420000E+01,
  0.40123820E+03, 0.148E+03, 0.143E+03, 0.19539000E+01, 0.16682000E+01,
  0.31533650E+03, 0.148E+03, 0.144E+03, 0.19539000E+01, 0.18584000E+01,
  0.29530360E+03, 0.148E+03, 0.145E+03, 0.19539000E+01, 0.19003000E+01,
  0.27461540E+03, 0.148E+03, 0.146E+03, 0.19539000E+01, 0.18630000E+01,
  0.26554500E+03, 0.148E+03, 0.147E+03, 0.19539000E+01, 0.96790000E+00,
  0.26345080E+03, 0.148E+03, 0.148E+03, 0.19539000E+01, 0.19539000E+01,
  0.42282700E+02, 0.149E+03, 0.100E+01, 0.96330000E+00, 0.91180000E+00,
  0.27023600E+02, 0.149E+03, 0.200E+01, 0.96330000E+00, 0.00000000E+00,
  0.76925140E+03, 0.149E+03, 0.300E+01, 0.96330000E+00, 0.00000000E+00,
  0.41349650E+03, 0.149E+03, 0.400E+01, 0.96330000E+00, 0.00000000E+00,
  0.26747500E+03, 0.149E+03, 0.500E+01, 0.96330000E+00, 0.00000000E+00,
  0.17545850E+03, 0.149E+03, 0.600E+01, 0.96330000E+00, 0.00000000E+00,
  0.12012790E+03, 0.149E+03, 0.700E+01, 0.96330000E+00, 0.00000000E+00,
  0.89652000E+02, 0.149E+03, 0.800E+01, 0.96330000E+00, 0.00000000E+00,
  0.67123200E+02, 0.149E+03, 0.900E+01, 0.96330000E+00, 0.00000000E+00,
  0.51174700E+02, 0.149E+03, 0.100E+02, 0.96330000E+00, 0.00000000E+00,
  0.91594130E+03, 0.149E+03, 0.110E+02, 0.96330000E+00, 0.00000000E+00,
  0.66728440E+03, 0.149E+03, 0.120E+02, 0.96330000E+00, 0.00000000E+00,
  0.60241430E+03, 0.149E+03, 0.130E+02, 0.96330000E+00, 0.00000000E+00,
  0.46150930E+03, 0.149E+03, 0.140E+02, 0.96330000E+00, 0.00000000E+00,
  0.35151570E+03, 0.149E+03, 0.150E+02, 0.96330000E+00, 0.00000000E+00,
  0.28739220E+03, 0.149E+03, 0.160E+02, 0.96330000E+00, 0.00000000E+00,
  0.23145540E+03, 0.149E+03, 0.170E+02, 0.96330000E+00, 0.00000000E+00,
  0.18709160E+03, 0.149E+03, 0.180E+02, 0.96330000E+00, 0.00000000E+00,
  0.15173687E+04, 0.149E+03, 0.190E+02, 0.96330000E+00, 0.00000000E+00,
  0.11989287E+04, 0.149E+03, 0.200E+02, 0.96330000E+00, 0.00000000E+00,
  0.98084640E+03, 0.149E+03, 0.210E+02, 0.96330000E+00, 0.00000000E+00,
  0.93876410E+03, 0.149E+03, 0.220E+02, 0.96330000E+00, 0.00000000E+00,
  0.85507440E+03, 0.149E+03, 0.230E+02, 0.96330000E+00, 0.00000000E+00,
  0.67285260E+03, 0.149E+03, 0.240E+02, 0.96330000E+00, 0.00000000E+00,
  0.73052210E+03, 0.149E+03, 0.250E+02, 0.96330000E+00, 0.00000000E+00,
  0.57217290E+03, 0.149E+03, 0.260E+02, 0.96330000E+00, 0.00000000E+00,
  0.59982550E+03, 0.149E+03, 0.270E+02, 0.96330000E+00, 0.00000000E+00,
  0.62133050E+03, 0.149E+03, 0.280E+02, 0.96330000E+00, 0.00000000E+00,
  0.47601650E+03, 0.149E+03, 0.290E+02, 0.96330000E+00, 0.00000000E+00,
  0.48059720E+03, 0.149E+03, 0.300E+02, 0.96330000E+00, 0.00000000E+00,
  0.57226580E+03, 0.149E+03, 0.310E+02, 0.96330000E+00, 0.00000000E+00,
  0.49379840E+03, 0.149E+03, 0.320E+02, 0.96330000E+00, 0.00000000E+00,
  0.41301260E+03, 0.149E+03, 0.330E+02, 0.96330000E+00, 0.00000000E+00,
  0.36615190E+03, 0.149E+03, 0.340E+02, 0.96330000E+00, 0.00000000E+00,
  0.31652310E+03, 0.149E+03, 0.350E+02, 0.96330000E+00, 0.00000000E+00,
  0.27222880E+03, 0.149E+03, 0.360E+02, 0.96330000E+00, 0.00000000E+00,
  0.16942091E+04, 0.149E+03, 0.370E+02, 0.96330000E+00, 0.00000000E+00,
  0.14306640E+04, 0.149E+03, 0.380E+02, 0.96330000E+00, 0.00000000E+00,
  0.12316979E+04, 0.149E+03, 0.390E+02, 0.96330000E+00, 0.00000000E+00,
  0.10950419E+04, 0.149E+03, 0.400E+02, 0.96330000E+00, 0.00000000E+00,
  0.99140130E+03, 0.149E+03, 0.410E+02, 0.96330000E+00, 0.00000000E+00,
  0.75589180E+03, 0.149E+03, 0.420E+02, 0.96330000E+00, 0.00000000E+00,
  0.84735570E+03, 0.149E+03, 0.430E+02, 0.96330000E+00, 0.00000000E+00,
  0.63674800E+03, 0.149E+03, 0.440E+02, 0.96330000E+00, 0.00000000E+00,
  0.69613210E+03, 0.149E+03, 0.450E+02, 0.96330000E+00, 0.00000000E+00,
  0.64264560E+03, 0.149E+03, 0.460E+02, 0.96330000E+00, 0.00000000E+00,
  0.53720580E+03, 0.149E+03, 0.470E+02, 0.96330000E+00, 0.00000000E+00,
  0.56303120E+03, 0.149E+03, 0.480E+02, 0.96330000E+00, 0.00000000E+00,
  0.71679570E+03, 0.149E+03, 0.490E+02, 0.96330000E+00, 0.00000000E+00,
  0.65114030E+03, 0.149E+03, 0.500E+02, 0.96330000E+00, 0.00000000E+00,
  0.57030150E+03, 0.149E+03, 0.510E+02, 0.96330000E+00, 0.00000000E+00,
  0.52361310E+03, 0.149E+03, 0.520E+02, 0.96330000E+00, 0.00000000E+00,
  0.46816800E+03, 0.149E+03, 0.530E+02, 0.96330000E+00, 0.00000000E+00,
  0.41650530E+03, 0.149E+03, 0.540E+02, 0.96330000E+00, 0.00000000E+00,
  0.20626273E+04, 0.149E+03, 0.550E+02, 0.96330000E+00, 0.00000000E+00,
  0.18342595E+04, 0.149E+03, 0.560E+02, 0.96330000E+00, 0.00000000E+00,
  0.15838792E+04, 0.149E+03, 0.570E+02, 0.96330000E+00, 0.00000000E+00,
  0.67579110E+03, 0.149E+03, 0.580E+02, 0.96330000E+00, 0.27991000E+01,
  0.16159882E+04, 0.149E+03, 0.590E+02, 0.96330000E+00, 0.00000000E+00,
  0.15472492E+04, 0.149E+03, 0.600E+02, 0.96330000E+00, 0.00000000E+00,
  0.15072236E+04, 0.149E+03, 0.610E+02, 0.96330000E+00, 0.00000000E+00,
  0.14705492E+04, 0.149E+03, 0.620E+02, 0.96330000E+00, 0.00000000E+00,
  0.14379844E+04, 0.149E+03, 0.630E+02, 0.96330000E+00, 0.00000000E+00,
  0.11092250E+04, 0.149E+03, 0.640E+02, 0.96330000E+00, 0.00000000E+00,
  0.12845648E+04, 0.149E+03, 0.650E+02, 0.96330000E+00, 0.00000000E+00,
  0.12348582E+04, 0.149E+03, 0.660E+02, 0.96330000E+00, 0.00000000E+00,
  0.12913513E+04, 0.149E+03, 0.670E+02, 0.96330000E+00, 0.00000000E+00,
  0.12633503E+04, 0.149E+03, 0.680E+02, 0.96330000E+00, 0.00000000E+00,
  0.12378116E+04, 0.149E+03, 0.690E+02, 0.96330000E+00, 0.00000000E+00,
  0.12243143E+04, 0.149E+03, 0.700E+02, 0.96330000E+00, 0.00000000E+00,
  0.10181407E+04, 0.149E+03, 0.710E+02, 0.96330000E+00, 0.00000000E+00,
  0.98356470E+03, 0.149E+03, 0.720E+02, 0.96330000E+00, 0.00000000E+00,
  0.88792510E+03, 0.149E+03, 0.730E+02, 0.96330000E+00, 0.00000000E+00,
  0.74340350E+03, 0.149E+03, 0.740E+02, 0.96330000E+00, 0.00000000E+00,
  0.75315120E+03, 0.149E+03, 0.750E+02, 0.96330000E+00, 0.00000000E+00,
  0.67623400E+03, 0.149E+03, 0.760E+02, 0.96330000E+00, 0.00000000E+00,
  0.61465820E+03, 0.149E+03, 0.770E+02, 0.96330000E+00, 0.00000000E+00,
  0.50654420E+03, 0.149E+03, 0.780E+02, 0.96330000E+00, 0.00000000E+00,
  0.47177480E+03, 0.149E+03, 0.790E+02, 0.96330000E+00, 0.00000000E+00,
  0.48363130E+03, 0.149E+03, 0.800E+02, 0.96330000E+00, 0.00000000E+00,
  0.73258080E+03, 0.149E+03, 0.810E+02, 0.96330000E+00, 0.00000000E+00,
  0.70644460E+03, 0.149E+03, 0.820E+02, 0.96330000E+00, 0.00000000E+00,
  0.63913150E+03, 0.149E+03, 0.830E+02, 0.96330000E+00, 0.00000000E+00,
  0.60410820E+03, 0.149E+03, 0.840E+02, 0.96330000E+00, 0.00000000E+00,
  0.55158440E+03, 0.149E+03, 0.850E+02, 0.96330000E+00, 0.00000000E+00,
  0.50067860E+03, 0.149E+03, 0.860E+02, 0.96330000E+00, 0.00000000E+00,
  0.19210063E+04, 0.149E+03, 0.870E+02, 0.96330000E+00, 0.00000000E+00,
  0.17975569E+04, 0.149E+03, 0.880E+02, 0.96330000E+00, 0.00000000E+00,
  0.15637265E+04, 0.149E+03, 0.890E+02, 0.96330000E+00, 0.00000000E+00,
  0.13796361E+04, 0.149E+03, 0.900E+02, 0.96330000E+00, 0.00000000E+00,
  0.13822903E+04, 0.149E+03, 0.910E+02, 0.96330000E+00, 0.00000000E+00,
  0.13377839E+04, 0.149E+03, 0.920E+02, 0.96330000E+00, 0.00000000E+00,
  0.13931101E+04, 0.149E+03, 0.930E+02, 0.96330000E+00, 0.00000000E+00,
  0.13462697E+04, 0.149E+03, 0.940E+02, 0.96330000E+00, 0.00000000E+00,
  0.69675400E+02, 0.149E+03, 0.101E+03, 0.96330000E+00, 0.00000000E+00,
  0.23904190E+03, 0.149E+03, 0.103E+03, 0.96330000E+00, 0.98650000E+00,
  0.30266780E+03, 0.149E+03, 0.104E+03, 0.96330000E+00, 0.98080000E+00,
  0.22316290E+03, 0.149E+03, 0.105E+03, 0.96330000E+00, 0.97060000E+00,
  0.16468120E+03, 0.149E+03, 0.106E+03, 0.96330000E+00, 0.98680000E+00,
  0.11197070E+03, 0.149E+03, 0.107E+03, 0.96330000E+00, 0.99440000E+00,
  0.80098600E+02, 0.149E+03, 0.108E+03, 0.96330000E+00, 0.99250000E+00,
  0.53936400E+02, 0.149E+03, 0.109E+03, 0.96330000E+00, 0.99820000E+00,
  0.35200740E+03, 0.149E+03, 0.111E+03, 0.96330000E+00, 0.96840000E+00,
  0.54627620E+03, 0.149E+03, 0.112E+03, 0.96330000E+00, 0.96280000E+00,
  0.54321880E+03, 0.149E+03, 0.113E+03, 0.96330000E+00, 0.96480000E+00,
  0.42482930E+03, 0.149E+03, 0.114E+03, 0.96330000E+00, 0.95070000E+00,
  0.34093960E+03, 0.149E+03, 0.115E+03, 0.96330000E+00, 0.99470000E+00,
  0.28433500E+03, 0.149E+03, 0.116E+03, 0.96330000E+00, 0.99480000E+00,
  0.22912290E+03, 0.149E+03, 0.117E+03, 0.96330000E+00, 0.99720000E+00,
  0.47801410E+03, 0.149E+03, 0.119E+03, 0.96330000E+00, 0.97670000E+00,
  0.95798970E+03, 0.149E+03, 0.120E+03, 0.96330000E+00, 0.98310000E+00,
  0.46767000E+03, 0.149E+03, 0.121E+03, 0.96330000E+00, 0.18627000E+01,
  0.45116580E+03, 0.149E+03, 0.122E+03, 0.96330000E+00, 0.18299000E+01,
  0.44234200E+03, 0.149E+03, 0.123E+03, 0.96330000E+00, 0.19138000E+01,
  0.43947280E+03, 0.149E+03, 0.124E+03, 0.96330000E+00, 0.18269000E+01,
  0.39910790E+03, 0.149E+03, 0.125E+03, 0.96330000E+00, 0.16406000E+01,
  0.36795920E+03, 0.149E+03, 0.126E+03, 0.96330000E+00, 0.16483000E+01,
  0.35103000E+03, 0.149E+03, 0.127E+03, 0.96330000E+00, 0.17149000E+01,
  0.34356200E+03, 0.149E+03, 0.128E+03, 0.96330000E+00, 0.17937000E+01,
  0.34289310E+03, 0.149E+03, 0.129E+03, 0.96330000E+00, 0.95760000E+00,
  0.31591660E+03, 0.149E+03, 0.130E+03, 0.96330000E+00, 0.19419000E+01,
  0.53451270E+03, 0.149E+03, 0.131E+03, 0.96330000E+00, 0.96010000E+00,
  0.45962850E+03, 0.149E+03, 0.132E+03, 0.96330000E+00, 0.94340000E+00,
  0.40554530E+03, 0.149E+03, 0.133E+03, 0.96330000E+00, 0.98890000E+00,
  0.36636520E+03, 0.149E+03, 0.134E+03, 0.96330000E+00, 0.99010000E+00,
  0.31893050E+03, 0.149E+03, 0.135E+03, 0.96330000E+00, 0.99740000E+00,
  0.56760020E+03, 0.149E+03, 0.137E+03, 0.96330000E+00, 0.97380000E+00,
  0.11685036E+04, 0.149E+03, 0.138E+03, 0.96330000E+00, 0.98010000E+00,
  0.86288330E+03, 0.149E+03, 0.139E+03, 0.96330000E+00, 0.19153000E+01,
  0.61965370E+03, 0.149E+03, 0.140E+03, 0.96330000E+00, 0.19355000E+01,
  0.62602540E+03, 0.149E+03, 0.141E+03, 0.96330000E+00, 0.19545000E+01,
  0.58105490E+03, 0.149E+03, 0.142E+03, 0.96330000E+00, 0.19420000E+01,
  0.66303800E+03, 0.149E+03, 0.143E+03, 0.96330000E+00, 0.16682000E+01,
  0.50016280E+03, 0.149E+03, 0.144E+03, 0.96330000E+00, 0.18584000E+01,
  0.46737710E+03, 0.149E+03, 0.145E+03, 0.96330000E+00, 0.19003000E+01,
  0.43299730E+03, 0.149E+03, 0.146E+03, 0.96330000E+00, 0.18630000E+01,
  0.41968680E+03, 0.149E+03, 0.147E+03, 0.96330000E+00, 0.96790000E+00,
  0.41115760E+03, 0.149E+03, 0.148E+03, 0.96330000E+00, 0.19539000E+01,
  0.67899200E+03, 0.149E+03, 0.149E+03, 0.96330000E+00, 0.96330000E+00,
  0.39050000E+02, 0.150E+03, 0.100E+01, 0.95140000E+00, 0.91180000E+00,
  0.25410500E+02, 0.150E+03, 0.200E+01, 0.95140000E+00, 0.00000000E+00,
  0.64241900E+03, 0.150E+03, 0.300E+01, 0.95140000E+00, 0.00000000E+00,
  0.36274340E+03, 0.150E+03, 0.400E+01, 0.95140000E+00, 0.00000000E+00,
  0.24059340E+03, 0.150E+03, 0.500E+01, 0.95140000E+00, 0.00000000E+00,
  0.16058760E+03, 0.150E+03, 0.600E+01, 0.95140000E+00, 0.00000000E+00,
  0.11127680E+03, 0.150E+03, 0.700E+01, 0.95140000E+00, 0.00000000E+00,
  0.83712000E+02, 0.150E+03, 0.800E+01, 0.95140000E+00, 0.00000000E+00,
  0.63080600E+02, 0.150E+03, 0.900E+01, 0.95140000E+00, 0.00000000E+00,
  0.48325800E+02, 0.150E+03, 0.100E+02, 0.95140000E+00, 0.00000000E+00,
  0.76709550E+03, 0.150E+03, 0.110E+02, 0.95140000E+00, 0.00000000E+00,
  0.58045000E+03, 0.150E+03, 0.120E+02, 0.95140000E+00, 0.00000000E+00,
  0.53107940E+03, 0.150E+03, 0.130E+02, 0.95140000E+00, 0.00000000E+00,
  0.41414030E+03, 0.150E+03, 0.140E+02, 0.95140000E+00, 0.00000000E+00,
  0.31993070E+03, 0.150E+03, 0.150E+02, 0.95140000E+00, 0.00000000E+00,
  0.26382770E+03, 0.150E+03, 0.160E+02, 0.95140000E+00, 0.00000000E+00,
  0.21417230E+03, 0.150E+03, 0.170E+02, 0.95140000E+00, 0.00000000E+00,
  0.17426390E+03, 0.150E+03, 0.180E+02, 0.95140000E+00, 0.00000000E+00,
  0.12595964E+04, 0.150E+03, 0.190E+02, 0.95140000E+00, 0.00000000E+00,
  0.10266097E+04, 0.150E+03, 0.200E+02, 0.95140000E+00, 0.00000000E+00,
  0.84554470E+03, 0.150E+03, 0.210E+02, 0.95140000E+00, 0.00000000E+00,
  0.81389640E+03, 0.150E+03, 0.220E+02, 0.95140000E+00, 0.00000000E+00,
  0.74392530E+03, 0.150E+03, 0.230E+02, 0.95140000E+00, 0.00000000E+00,
  0.58540690E+03, 0.150E+03, 0.240E+02, 0.95140000E+00, 0.00000000E+00,
  0.63875870E+03, 0.150E+03, 0.250E+02, 0.95140000E+00, 0.00000000E+00,
  0.50063040E+03, 0.150E+03, 0.260E+02, 0.95140000E+00, 0.00000000E+00,
  0.52899650E+03, 0.150E+03, 0.270E+02, 0.95140000E+00, 0.00000000E+00,
  0.54604730E+03, 0.150E+03, 0.280E+02, 0.95140000E+00, 0.00000000E+00,
  0.41817300E+03, 0.150E+03, 0.290E+02, 0.95140000E+00, 0.00000000E+00,
  0.42710250E+03, 0.150E+03, 0.300E+02, 0.95140000E+00, 0.00000000E+00,
  0.50688380E+03, 0.150E+03, 0.310E+02, 0.95140000E+00, 0.00000000E+00,
  0.44348920E+03, 0.150E+03, 0.320E+02, 0.95140000E+00, 0.00000000E+00,
  0.37536940E+03, 0.150E+03, 0.330E+02, 0.95140000E+00, 0.00000000E+00,
  0.33511820E+03, 0.150E+03, 0.340E+02, 0.95140000E+00, 0.00000000E+00,
  0.29171790E+03, 0.150E+03, 0.350E+02, 0.95140000E+00, 0.00000000E+00,
  0.25244080E+03, 0.150E+03, 0.360E+02, 0.95140000E+00, 0.00000000E+00,
  0.14095386E+04, 0.150E+03, 0.370E+02, 0.95140000E+00, 0.00000000E+00,
  0.12233073E+04, 0.150E+03, 0.380E+02, 0.95140000E+00, 0.00000000E+00,
  0.10654342E+04, 0.150E+03, 0.390E+02, 0.95140000E+00, 0.00000000E+00,
  0.95393220E+03, 0.150E+03, 0.400E+02, 0.95140000E+00, 0.00000000E+00,
  0.86754750E+03, 0.150E+03, 0.410E+02, 0.95140000E+00, 0.00000000E+00,
  0.66641970E+03, 0.150E+03, 0.420E+02, 0.95140000E+00, 0.00000000E+00,
  0.74499930E+03, 0.150E+03, 0.430E+02, 0.95140000E+00, 0.00000000E+00,
  0.56445890E+03, 0.150E+03, 0.440E+02, 0.95140000E+00, 0.00000000E+00,
  0.61737910E+03, 0.150E+03, 0.450E+02, 0.95140000E+00, 0.00000000E+00,
  0.57156020E+03, 0.150E+03, 0.460E+02, 0.95140000E+00, 0.00000000E+00,
  0.47659660E+03, 0.150E+03, 0.470E+02, 0.95140000E+00, 0.00000000E+00,
  0.50255130E+03, 0.150E+03, 0.480E+02, 0.95140000E+00, 0.00000000E+00,
  0.63411950E+03, 0.150E+03, 0.490E+02, 0.95140000E+00, 0.00000000E+00,
  0.58276930E+03, 0.150E+03, 0.500E+02, 0.95140000E+00, 0.00000000E+00,
  0.51594670E+03, 0.150E+03, 0.510E+02, 0.95140000E+00, 0.00000000E+00,
  0.47668110E+03, 0.150E+03, 0.520E+02, 0.95140000E+00, 0.00000000E+00,
  0.42899630E+03, 0.150E+03, 0.530E+02, 0.95140000E+00, 0.00000000E+00,
  0.38394570E+03, 0.150E+03, 0.540E+02, 0.95140000E+00, 0.00000000E+00,
  0.17161526E+04, 0.150E+03, 0.550E+02, 0.95140000E+00, 0.00000000E+00,
  0.15618289E+04, 0.150E+03, 0.560E+02, 0.95140000E+00, 0.00000000E+00,
  0.13644290E+04, 0.150E+03, 0.570E+02, 0.95140000E+00, 0.00000000E+00,
  0.61000420E+03, 0.150E+03, 0.580E+02, 0.95140000E+00, 0.27991000E+01,
  0.13811677E+04, 0.150E+03, 0.590E+02, 0.95140000E+00, 0.00000000E+00,
  0.13251151E+04, 0.150E+03, 0.600E+02, 0.95140000E+00, 0.00000000E+00,
  0.12915707E+04, 0.150E+03, 0.610E+02, 0.95140000E+00, 0.00000000E+00,
  0.12607608E+04, 0.150E+03, 0.620E+02, 0.95140000E+00, 0.00000000E+00,
  0.12334280E+04, 0.150E+03, 0.630E+02, 0.95140000E+00, 0.00000000E+00,
  0.96322340E+03, 0.150E+03, 0.640E+02, 0.95140000E+00, 0.00000000E+00,
  0.10940703E+04, 0.150E+03, 0.650E+02, 0.95140000E+00, 0.00000000E+00,
  0.10539748E+04, 0.150E+03, 0.660E+02, 0.95140000E+00, 0.00000000E+00,
  0.11110005E+04, 0.150E+03, 0.670E+02, 0.95140000E+00, 0.00000000E+00,
  0.10872901E+04, 0.150E+03, 0.680E+02, 0.95140000E+00, 0.00000000E+00,
  0.10658196E+04, 0.150E+03, 0.690E+02, 0.95140000E+00, 0.00000000E+00,
  0.10536773E+04, 0.150E+03, 0.700E+02, 0.95140000E+00, 0.00000000E+00,
  0.88359210E+03, 0.150E+03, 0.710E+02, 0.95140000E+00, 0.00000000E+00,
  0.86380750E+03, 0.150E+03, 0.720E+02, 0.95140000E+00, 0.00000000E+00,
  0.78517710E+03, 0.150E+03, 0.730E+02, 0.95140000E+00, 0.00000000E+00,
  0.66055390E+03, 0.150E+03, 0.740E+02, 0.95140000E+00, 0.00000000E+00,
  0.67110130E+03, 0.150E+03, 0.750E+02, 0.95140000E+00, 0.00000000E+00,
  0.60606460E+03, 0.150E+03, 0.760E+02, 0.95140000E+00, 0.00000000E+00,
  0.55342010E+03, 0.150E+03, 0.770E+02, 0.95140000E+00, 0.00000000E+00,
  0.45807960E+03, 0.150E+03, 0.780E+02, 0.95140000E+00, 0.00000000E+00,
  0.42739480E+03, 0.150E+03, 0.790E+02, 0.95140000E+00, 0.00000000E+00,
  0.43923750E+03, 0.150E+03, 0.800E+02, 0.95140000E+00, 0.00000000E+00,
  0.64947520E+03, 0.150E+03, 0.810E+02, 0.95140000E+00, 0.00000000E+00,
  0.63216060E+03, 0.150E+03, 0.820E+02, 0.95140000E+00, 0.00000000E+00,
  0.57757500E+03, 0.150E+03, 0.830E+02, 0.95140000E+00, 0.00000000E+00,
  0.54893280E+03, 0.150E+03, 0.840E+02, 0.95140000E+00, 0.00000000E+00,
  0.50441400E+03, 0.150E+03, 0.850E+02, 0.95140000E+00, 0.00000000E+00,
  0.46043530E+03, 0.150E+03, 0.860E+02, 0.95140000E+00, 0.00000000E+00,
  0.16132050E+04, 0.150E+03, 0.870E+02, 0.95140000E+00, 0.00000000E+00,
  0.15396549E+04, 0.150E+03, 0.880E+02, 0.95140000E+00, 0.00000000E+00,
  0.13539743E+04, 0.150E+03, 0.890E+02, 0.95140000E+00, 0.00000000E+00,
  0.12088936E+04, 0.150E+03, 0.900E+02, 0.95140000E+00, 0.00000000E+00,
  0.12037043E+04, 0.150E+03, 0.910E+02, 0.95140000E+00, 0.00000000E+00,
  0.11652987E+04, 0.150E+03, 0.920E+02, 0.95140000E+00, 0.00000000E+00,
  0.12045686E+04, 0.150E+03, 0.930E+02, 0.95140000E+00, 0.00000000E+00,
  0.11657062E+04, 0.150E+03, 0.940E+02, 0.95140000E+00, 0.00000000E+00,
  0.63518900E+02, 0.150E+03, 0.101E+03, 0.95140000E+00, 0.00000000E+00,
  0.21038150E+03, 0.150E+03, 0.103E+03, 0.95140000E+00, 0.98650000E+00,
  0.26750360E+03, 0.150E+03, 0.104E+03, 0.95140000E+00, 0.98080000E+00,
  0.20167580E+03, 0.150E+03, 0.105E+03, 0.95140000E+00, 0.97060000E+00,
  0.15060400E+03, 0.150E+03, 0.106E+03, 0.95140000E+00, 0.98680000E+00,
  0.10370700E+03, 0.150E+03, 0.107E+03, 0.95140000E+00, 0.99440000E+00,
  0.74928900E+02, 0.150E+03, 0.108E+03, 0.95140000E+00, 0.99250000E+00,
  0.51049200E+02, 0.150E+03, 0.109E+03, 0.95140000E+00, 0.99820000E+00,
  0.30824700E+03, 0.150E+03, 0.111E+03, 0.95140000E+00, 0.96840000E+00,
  0.47728480E+03, 0.150E+03, 0.112E+03, 0.95140000E+00, 0.96280000E+00,
  0.48037350E+03, 0.150E+03, 0.113E+03, 0.95140000E+00, 0.96480000E+00,
  0.38212550E+03, 0.150E+03, 0.114E+03, 0.95140000E+00, 0.95070000E+00,
  0.31042380E+03, 0.150E+03, 0.115E+03, 0.95140000E+00, 0.99470000E+00,
  0.26094970E+03, 0.150E+03, 0.116E+03, 0.95140000E+00, 0.99480000E+00,
  0.21197090E+03, 0.150E+03, 0.117E+03, 0.95140000E+00, 0.99720000E+00,
  0.42200550E+03, 0.150E+03, 0.119E+03, 0.95140000E+00, 0.97670000E+00,
  0.81999260E+03, 0.150E+03, 0.120E+03, 0.95140000E+00, 0.98310000E+00,
  0.41914320E+03, 0.150E+03, 0.121E+03, 0.95140000E+00, 0.18627000E+01,
  0.40443780E+03, 0.150E+03, 0.122E+03, 0.95140000E+00, 0.18299000E+01,
  0.39640790E+03, 0.150E+03, 0.123E+03, 0.95140000E+00, 0.19138000E+01,
  0.39312150E+03, 0.150E+03, 0.124E+03, 0.95140000E+00, 0.18269000E+01,
  0.36011140E+03, 0.150E+03, 0.125E+03, 0.95140000E+00, 0.16406000E+01,
  0.33275950E+03, 0.150E+03, 0.126E+03, 0.95140000E+00, 0.16483000E+01,
  0.31739780E+03, 0.150E+03, 0.127E+03, 0.95140000E+00, 0.17149000E+01,
  0.31042370E+03, 0.150E+03, 0.128E+03, 0.95140000E+00, 0.17937000E+01,
  0.30781940E+03, 0.150E+03, 0.129E+03, 0.95140000E+00, 0.95760000E+00,
  0.28694640E+03, 0.150E+03, 0.130E+03, 0.95140000E+00, 0.19419000E+01,
  0.47510140E+03, 0.150E+03, 0.131E+03, 0.95140000E+00, 0.96010000E+00,
  0.41406130E+03, 0.150E+03, 0.132E+03, 0.95140000E+00, 0.94340000E+00,
  0.36881960E+03, 0.150E+03, 0.133E+03, 0.95140000E+00, 0.98890000E+00,
  0.33526670E+03, 0.150E+03, 0.134E+03, 0.95140000E+00, 0.99010000E+00,
  0.29382390E+03, 0.150E+03, 0.135E+03, 0.95140000E+00, 0.99740000E+00,
  0.50249860E+03, 0.150E+03, 0.137E+03, 0.95140000E+00, 0.97380000E+00,
  0.99819190E+03, 0.150E+03, 0.138E+03, 0.95140000E+00, 0.98010000E+00,
  0.75411460E+03, 0.150E+03, 0.139E+03, 0.95140000E+00, 0.19153000E+01,
  0.55441070E+03, 0.150E+03, 0.140E+03, 0.95140000E+00, 0.19355000E+01,
  0.55998500E+03, 0.150E+03, 0.141E+03, 0.95140000E+00, 0.19545000E+01,
  0.52115630E+03, 0.150E+03, 0.142E+03, 0.95140000E+00, 0.19420000E+01,
  0.58793550E+03, 0.150E+03, 0.143E+03, 0.95140000E+00, 0.16682000E+01,
  0.45216820E+03, 0.150E+03, 0.144E+03, 0.95140000E+00, 0.18584000E+01,
  0.42274380E+03, 0.150E+03, 0.145E+03, 0.95140000E+00, 0.19003000E+01,
  0.39214710E+03, 0.150E+03, 0.146E+03, 0.95140000E+00, 0.18630000E+01,
  0.37963350E+03, 0.150E+03, 0.147E+03, 0.95140000E+00, 0.96790000E+00,
  0.37434300E+03, 0.150E+03, 0.148E+03, 0.95140000E+00, 0.19539000E+01,
  0.60309650E+03, 0.150E+03, 0.149E+03, 0.95140000E+00, 0.96330000E+00,
  0.54204390E+03, 0.150E+03, 0.150E+03, 0.95140000E+00, 0.95140000E+00,
  0.37118600E+02, 0.151E+03, 0.100E+01, 0.97490000E+00, 0.91180000E+00,
  0.24506800E+02, 0.151E+03, 0.200E+01, 0.97490000E+00, 0.00000000E+00,
  0.56950200E+03, 0.151E+03, 0.300E+01, 0.97490000E+00, 0.00000000E+00,
  0.33206650E+03, 0.151E+03, 0.400E+01, 0.97490000E+00, 0.00000000E+00,
  0.22424380E+03, 0.151E+03, 0.500E+01, 0.97490000E+00, 0.00000000E+00,
  0.15163340E+03, 0.151E+03, 0.600E+01, 0.97490000E+00, 0.00000000E+00,
  0.10605380E+03, 0.151E+03, 0.700E+01, 0.97490000E+00, 0.00000000E+00,
  0.80289900E+02, 0.151E+03, 0.800E+01, 0.97490000E+00, 0.00000000E+00,
  0.60817400E+02, 0.151E+03, 0.900E+01, 0.97490000E+00, 0.00000000E+00,
  0.46777500E+02, 0.151E+03, 0.100E+02, 0.97490000E+00, 0.00000000E+00,
  0.68136500E+03, 0.151E+03, 0.110E+02, 0.97490000E+00, 0.00000000E+00,
  0.52835450E+03, 0.151E+03, 0.120E+02, 0.97490000E+00, 0.00000000E+00,
  0.48798470E+03, 0.151E+03, 0.130E+02, 0.97490000E+00, 0.00000000E+00,
  0.38531020E+03, 0.151E+03, 0.140E+02, 0.97490000E+00, 0.00000000E+00,
  0.30075580E+03, 0.151E+03, 0.150E+02, 0.97490000E+00, 0.00000000E+00,
  0.24964690E+03, 0.151E+03, 0.160E+02, 0.97490000E+00, 0.00000000E+00,
  0.20391030E+03, 0.151E+03, 0.170E+02, 0.97490000E+00, 0.00000000E+00,
  0.16677960E+03, 0.151E+03, 0.180E+02, 0.97490000E+00, 0.00000000E+00,
  0.11139369E+04, 0.151E+03, 0.190E+02, 0.97490000E+00, 0.00000000E+00,
  0.92532660E+03, 0.151E+03, 0.200E+02, 0.97490000E+00, 0.00000000E+00,
  0.76543030E+03, 0.151E+03, 0.210E+02, 0.97490000E+00, 0.00000000E+00,
  0.73977510E+03, 0.151E+03, 0.220E+02, 0.97490000E+00, 0.00000000E+00,
  0.67780140E+03, 0.151E+03, 0.230E+02, 0.97490000E+00, 0.00000000E+00,
  0.53372530E+03, 0.151E+03, 0.240E+02, 0.97490000E+00, 0.00000000E+00,
  0.58400790E+03, 0.151E+03, 0.250E+02, 0.97490000E+00, 0.00000000E+00,
  0.45821350E+03, 0.151E+03, 0.260E+02, 0.97490000E+00, 0.00000000E+00,
  0.48646450E+03, 0.151E+03, 0.270E+02, 0.97490000E+00, 0.00000000E+00,
  0.50090110E+03, 0.151E+03, 0.280E+02, 0.97490000E+00, 0.00000000E+00,
  0.38380100E+03, 0.151E+03, 0.290E+02, 0.97490000E+00, 0.00000000E+00,
  0.39484340E+03, 0.151E+03, 0.300E+02, 0.97490000E+00, 0.00000000E+00,
  0.46751190E+03, 0.151E+03, 0.310E+02, 0.97490000E+00, 0.00000000E+00,
  0.41296610E+03, 0.151E+03, 0.320E+02, 0.97490000E+00, 0.00000000E+00,
  0.35254270E+03, 0.151E+03, 0.330E+02, 0.97490000E+00, 0.00000000E+00,
  0.31639840E+03, 0.151E+03, 0.340E+02, 0.97490000E+00, 0.00000000E+00,
  0.27688560E+03, 0.151E+03, 0.350E+02, 0.97490000E+00, 0.00000000E+00,
  0.24075150E+03, 0.151E+03, 0.360E+02, 0.97490000E+00, 0.00000000E+00,
  0.12488109E+04, 0.151E+03, 0.370E+02, 0.97490000E+00, 0.00000000E+00,
  0.11019644E+04, 0.151E+03, 0.380E+02, 0.97490000E+00, 0.00000000E+00,
  0.96716720E+03, 0.151E+03, 0.390E+02, 0.97490000E+00, 0.00000000E+00,
  0.87013340E+03, 0.151E+03, 0.400E+02, 0.97490000E+00, 0.00000000E+00,
  0.79387710E+03, 0.151E+03, 0.410E+02, 0.97490000E+00, 0.00000000E+00,
  0.61324700E+03, 0.151E+03, 0.420E+02, 0.97490000E+00, 0.00000000E+00,
  0.68412920E+03, 0.151E+03, 0.430E+02, 0.97490000E+00, 0.00000000E+00,
  0.52150710E+03, 0.151E+03, 0.440E+02, 0.97490000E+00, 0.00000000E+00,
  0.57027900E+03, 0.151E+03, 0.450E+02, 0.97490000E+00, 0.00000000E+00,
  0.52899540E+03, 0.151E+03, 0.460E+02, 0.97490000E+00, 0.00000000E+00,
  0.44070410E+03, 0.151E+03, 0.470E+02, 0.97490000E+00, 0.00000000E+00,
  0.46629410E+03, 0.151E+03, 0.480E+02, 0.97490000E+00, 0.00000000E+00,
  0.58471100E+03, 0.151E+03, 0.490E+02, 0.97490000E+00, 0.00000000E+00,
  0.54152090E+03, 0.151E+03, 0.500E+02, 0.97490000E+00, 0.00000000E+00,
  0.48305960E+03, 0.151E+03, 0.510E+02, 0.97490000E+00, 0.00000000E+00,
  0.44833330E+03, 0.151E+03, 0.520E+02, 0.97490000E+00, 0.00000000E+00,
  0.40544000E+03, 0.151E+03, 0.530E+02, 0.97490000E+00, 0.00000000E+00,
  0.36450640E+03, 0.151E+03, 0.540E+02, 0.97490000E+00, 0.00000000E+00,
  0.15212386E+04, 0.151E+03, 0.550E+02, 0.97490000E+00, 0.00000000E+00,
  0.14035743E+04, 0.151E+03, 0.560E+02, 0.97490000E+00, 0.00000000E+00,
  0.12355723E+04, 0.151E+03, 0.570E+02, 0.97490000E+00, 0.00000000E+00,
  0.57038460E+03, 0.151E+03, 0.580E+02, 0.97490000E+00, 0.27991000E+01,
  0.12443690E+04, 0.151E+03, 0.590E+02, 0.97490000E+00, 0.00000000E+00,
  0.11953394E+04, 0.151E+03, 0.600E+02, 0.97490000E+00, 0.00000000E+00,
  0.11654811E+04, 0.151E+03, 0.610E+02, 0.97490000E+00, 0.00000000E+00,
  0.11380116E+04, 0.151E+03, 0.620E+02, 0.97490000E+00, 0.00000000E+00,
  0.11136574E+04, 0.151E+03, 0.630E+02, 0.97490000E+00, 0.00000000E+00,
  0.87723370E+03, 0.151E+03, 0.640E+02, 0.97490000E+00, 0.00000000E+00,
  0.98436690E+03, 0.151E+03, 0.650E+02, 0.97490000E+00, 0.00000000E+00,
  0.94971600E+03, 0.151E+03, 0.660E+02, 0.97490000E+00, 0.00000000E+00,
  0.10050059E+04, 0.151E+03, 0.670E+02, 0.97490000E+00, 0.00000000E+00,
  0.98375110E+03, 0.151E+03, 0.680E+02, 0.97490000E+00, 0.00000000E+00,
  0.96460520E+03, 0.151E+03, 0.690E+02, 0.97490000E+00, 0.00000000E+00,
  0.95326960E+03, 0.151E+03, 0.700E+02, 0.97490000E+00, 0.00000000E+00,
  0.80412310E+03, 0.151E+03, 0.710E+02, 0.97490000E+00, 0.00000000E+00,
  0.79227200E+03, 0.151E+03, 0.720E+02, 0.97490000E+00, 0.00000000E+00,
  0.72359370E+03, 0.151E+03, 0.730E+02, 0.97490000E+00, 0.00000000E+00,
  0.61110290E+03, 0.151E+03, 0.740E+02, 0.97490000E+00, 0.00000000E+00,
  0.62195650E+03, 0.151E+03, 0.750E+02, 0.97490000E+00, 0.00000000E+00,
  0.56397010E+03, 0.151E+03, 0.760E+02, 0.97490000E+00, 0.00000000E+00,
  0.51667170E+03, 0.151E+03, 0.770E+02, 0.97490000E+00, 0.00000000E+00,
  0.42917250E+03, 0.151E+03, 0.780E+02, 0.97490000E+00, 0.00000000E+00,
  0.40097810E+03, 0.151E+03, 0.790E+02, 0.97490000E+00, 0.00000000E+00,
  0.41268870E+03, 0.151E+03, 0.800E+02, 0.97490000E+00, 0.00000000E+00,
  0.60016760E+03, 0.151E+03, 0.810E+02, 0.97490000E+00, 0.00000000E+00,
  0.58760720E+03, 0.151E+03, 0.820E+02, 0.97490000E+00, 0.00000000E+00,
  0.54048320E+03, 0.151E+03, 0.830E+02, 0.97490000E+00, 0.00000000E+00,
  0.51568470E+03, 0.151E+03, 0.840E+02, 0.97490000E+00, 0.00000000E+00,
  0.47605910E+03, 0.151E+03, 0.850E+02, 0.97490000E+00, 0.00000000E+00,
  0.43636860E+03, 0.151E+03, 0.860E+02, 0.97490000E+00, 0.00000000E+00,
  0.14387730E+04, 0.151E+03, 0.870E+02, 0.97490000E+00, 0.00000000E+00,
  0.13892118E+04, 0.151E+03, 0.880E+02, 0.97490000E+00, 0.00000000E+00,
  0.12302614E+04, 0.151E+03, 0.890E+02, 0.97490000E+00, 0.00000000E+00,
  0.11073931E+04, 0.151E+03, 0.900E+02, 0.97490000E+00, 0.00000000E+00,
  0.10983173E+04, 0.151E+03, 0.910E+02, 0.97490000E+00, 0.00000000E+00,
  0.10634833E+04, 0.151E+03, 0.920E+02, 0.97490000E+00, 0.00000000E+00,
  0.10937836E+04, 0.151E+03, 0.930E+02, 0.97490000E+00, 0.00000000E+00,
  0.10594592E+04, 0.151E+03, 0.940E+02, 0.97490000E+00, 0.00000000E+00,
  0.59779600E+02, 0.151E+03, 0.101E+03, 0.97490000E+00, 0.00000000E+00,
  0.19308010E+03, 0.151E+03, 0.103E+03, 0.97490000E+00, 0.98650000E+00,
  0.24635800E+03, 0.151E+03, 0.104E+03, 0.97490000E+00, 0.98080000E+00,
  0.18865770E+03, 0.151E+03, 0.105E+03, 0.97490000E+00, 0.97060000E+00,
  0.14217370E+03, 0.151E+03, 0.106E+03, 0.97490000E+00, 0.98680000E+00,
  0.98858300E+02, 0.151E+03, 0.107E+03, 0.97490000E+00, 0.99440000E+00,
  0.71981600E+02, 0.151E+03, 0.108E+03, 0.97490000E+00, 0.99250000E+00,
  0.49497000E+02, 0.151E+03, 0.109E+03, 0.97490000E+00, 0.99820000E+00,
  0.28199230E+03, 0.151E+03, 0.111E+03, 0.97490000E+00, 0.96840000E+00,
  0.43599230E+03, 0.151E+03, 0.112E+03, 0.97490000E+00, 0.96280000E+00,
  0.44239460E+03, 0.151E+03, 0.113E+03, 0.97490000E+00, 0.96480000E+00,
  0.35616810E+03, 0.151E+03, 0.114E+03, 0.97490000E+00, 0.95070000E+00,
  0.29192250E+03, 0.151E+03, 0.115E+03, 0.97490000E+00, 0.99470000E+00,
  0.24688440E+03, 0.151E+03, 0.116E+03, 0.97490000E+00, 0.99480000E+00,
  0.20178980E+03, 0.151E+03, 0.117E+03, 0.97490000E+00, 0.99720000E+00,
  0.38878440E+03, 0.151E+03, 0.119E+03, 0.97490000E+00, 0.97670000E+00,
  0.73983800E+03, 0.151E+03, 0.120E+03, 0.97490000E+00, 0.98310000E+00,
  0.38986450E+03, 0.151E+03, 0.121E+03, 0.97490000E+00, 0.18627000E+01,
  0.37633360E+03, 0.151E+03, 0.122E+03, 0.97490000E+00, 0.18299000E+01,
  0.36879080E+03, 0.151E+03, 0.123E+03, 0.97490000E+00, 0.19138000E+01,
  0.36529400E+03, 0.151E+03, 0.124E+03, 0.97490000E+00, 0.18269000E+01,
  0.33651780E+03, 0.151E+03, 0.125E+03, 0.97490000E+00, 0.16406000E+01,
  0.31148590E+03, 0.151E+03, 0.126E+03, 0.97490000E+00, 0.16483000E+01,
  0.29711100E+03, 0.151E+03, 0.127E+03, 0.97490000E+00, 0.17149000E+01,
  0.29044330E+03, 0.151E+03, 0.128E+03, 0.97490000E+00, 0.17937000E+01,
  0.28674360E+03, 0.151E+03, 0.129E+03, 0.97490000E+00, 0.95760000E+00,
  0.26942080E+03, 0.151E+03, 0.130E+03, 0.97490000E+00, 0.19419000E+01,
  0.43926920E+03, 0.151E+03, 0.131E+03, 0.97490000E+00, 0.96010000E+00,
  0.38642600E+03, 0.151E+03, 0.132E+03, 0.97490000E+00, 0.94340000E+00,
  0.34656560E+03, 0.151E+03, 0.133E+03, 0.97490000E+00, 0.98890000E+00,
  0.31651250E+03, 0.151E+03, 0.134E+03, 0.97490000E+00, 0.99010000E+00,
  0.27880760E+03, 0.151E+03, 0.135E+03, 0.97490000E+00, 0.99740000E+00,
  0.46396320E+03, 0.151E+03, 0.137E+03, 0.97490000E+00, 0.97380000E+00,
  0.89977960E+03, 0.151E+03, 0.138E+03, 0.97490000E+00, 0.98010000E+00,
  0.69024350E+03, 0.151E+03, 0.139E+03, 0.97490000E+00, 0.19153000E+01,
  0.51535410E+03, 0.151E+03, 0.140E+03, 0.97490000E+00, 0.19355000E+01,
  0.52041820E+03, 0.151E+03, 0.141E+03, 0.97490000E+00, 0.19545000E+01,
  0.48533740E+03, 0.151E+03, 0.142E+03, 0.97490000E+00, 0.19420000E+01,
  0.54348220E+03, 0.151E+03, 0.143E+03, 0.97490000E+00, 0.16682000E+01,
  0.42337510E+03, 0.151E+03, 0.144E+03, 0.97490000E+00, 0.18584000E+01,
  0.39603590E+03, 0.151E+03, 0.145E+03, 0.97490000E+00, 0.19003000E+01,
  0.36774930E+03, 0.151E+03, 0.146E+03, 0.97490000E+00, 0.18630000E+01,
  0.35570800E+03, 0.151E+03, 0.147E+03, 0.97490000E+00, 0.96790000E+00,
  0.35221320E+03, 0.151E+03, 0.148E+03, 0.97490000E+00, 0.19539000E+01,
  0.55762720E+03, 0.151E+03, 0.149E+03, 0.97490000E+00, 0.96330000E+00,
  0.50519000E+03, 0.151E+03, 0.150E+03, 0.97490000E+00, 0.95140000E+00,
  0.47347030E+03, 0.151E+03, 0.151E+03, 0.97490000E+00, 0.97490000E+00,
  0.35486100E+02, 0.152E+03, 0.100E+01, 0.98110000E+00, 0.91180000E+00,
  0.23710000E+02, 0.152E+03, 0.200E+01, 0.98110000E+00, 0.00000000E+00,
  0.51945180E+03, 0.152E+03, 0.300E+01, 0.98110000E+00, 0.00000000E+00,
  0.30894260E+03, 0.152E+03, 0.400E+01, 0.98110000E+00, 0.00000000E+00,
  0.21127990E+03, 0.152E+03, 0.500E+01, 0.98110000E+00, 0.00000000E+00,
  0.14426000E+03, 0.152E+03, 0.600E+01, 0.98110000E+00, 0.00000000E+00,
  0.10163150E+03, 0.152E+03, 0.700E+01, 0.98110000E+00, 0.00000000E+00,
  0.77336500E+02, 0.152E+03, 0.800E+01, 0.98110000E+00, 0.00000000E+00,
  0.58833200E+02, 0.152E+03, 0.900E+01, 0.98110000E+00, 0.00000000E+00,
  0.45404400E+02, 0.152E+03, 0.100E+02, 0.98110000E+00, 0.00000000E+00,
  0.62230990E+03, 0.152E+03, 0.110E+02, 0.98110000E+00, 0.00000000E+00,
  0.48978200E+03, 0.152E+03, 0.120E+02, 0.98110000E+00, 0.00000000E+00,
  0.45524770E+03, 0.152E+03, 0.130E+02, 0.98110000E+00, 0.00000000E+00,
  0.36255610E+03, 0.152E+03, 0.140E+02, 0.98110000E+00, 0.00000000E+00,
  0.28512390E+03, 0.152E+03, 0.150E+02, 0.98110000E+00, 0.00000000E+00,
  0.23785710E+03, 0.152E+03, 0.160E+02, 0.98110000E+00, 0.00000000E+00,
  0.19521310E+03, 0.152E+03, 0.170E+02, 0.98110000E+00, 0.00000000E+00,
  0.16033310E+03, 0.152E+03, 0.180E+02, 0.98110000E+00, 0.00000000E+00,
  0.10157738E+04, 0.152E+03, 0.190E+02, 0.98110000E+00, 0.00000000E+00,
  0.85290360E+03, 0.152E+03, 0.200E+02, 0.98110000E+00, 0.00000000E+00,
  0.70737690E+03, 0.152E+03, 0.210E+02, 0.98110000E+00, 0.00000000E+00,
  0.68556870E+03, 0.152E+03, 0.220E+02, 0.98110000E+00, 0.00000000E+00,
  0.62913900E+03, 0.152E+03, 0.230E+02, 0.98110000E+00, 0.00000000E+00,
  0.49588010E+03, 0.152E+03, 0.240E+02, 0.98110000E+00, 0.00000000E+00,
  0.54334380E+03, 0.152E+03, 0.250E+02, 0.98110000E+00, 0.00000000E+00,
  0.42683610E+03, 0.152E+03, 0.260E+02, 0.98110000E+00, 0.00000000E+00,
  0.45431700E+03, 0.152E+03, 0.270E+02, 0.98110000E+00, 0.00000000E+00,
  0.46700090E+03, 0.152E+03, 0.280E+02, 0.98110000E+00, 0.00000000E+00,
  0.35818700E+03, 0.152E+03, 0.290E+02, 0.98110000E+00, 0.00000000E+00,
  0.37006740E+03, 0.152E+03, 0.300E+02, 0.98110000E+00, 0.00000000E+00,
  0.43744170E+03, 0.152E+03, 0.310E+02, 0.98110000E+00, 0.00000000E+00,
  0.38889460E+03, 0.152E+03, 0.320E+02, 0.98110000E+00, 0.00000000E+00,
  0.33402630E+03, 0.152E+03, 0.330E+02, 0.98110000E+00, 0.00000000E+00,
  0.30096170E+03, 0.152E+03, 0.340E+02, 0.98110000E+00, 0.00000000E+00,
  0.26444460E+03, 0.152E+03, 0.350E+02, 0.98110000E+00, 0.00000000E+00,
  0.23079470E+03, 0.152E+03, 0.360E+02, 0.98110000E+00, 0.00000000E+00,
  0.11403397E+04, 0.152E+03, 0.370E+02, 0.98110000E+00, 0.00000000E+00,
  0.10156122E+04, 0.152E+03, 0.380E+02, 0.98110000E+00, 0.00000000E+00,
  0.89573040E+03, 0.152E+03, 0.390E+02, 0.98110000E+00, 0.00000000E+00,
  0.80842520E+03, 0.152E+03, 0.400E+02, 0.98110000E+00, 0.00000000E+00,
  0.73920970E+03, 0.152E+03, 0.410E+02, 0.98110000E+00, 0.00000000E+00,
  0.57337000E+03, 0.152E+03, 0.420E+02, 0.98110000E+00, 0.00000000E+00,
  0.63864620E+03, 0.152E+03, 0.430E+02, 0.98110000E+00, 0.00000000E+00,
  0.48901000E+03, 0.152E+03, 0.440E+02, 0.98110000E+00, 0.00000000E+00,
  0.53445110E+03, 0.152E+03, 0.450E+02, 0.98110000E+00, 0.00000000E+00,
  0.49643130E+03, 0.152E+03, 0.460E+02, 0.98110000E+00, 0.00000000E+00,
  0.41359130E+03, 0.152E+03, 0.470E+02, 0.98110000E+00, 0.00000000E+00,
  0.43835340E+03, 0.152E+03, 0.480E+02, 0.98110000E+00, 0.00000000E+00,
  0.54729130E+03, 0.152E+03, 0.490E+02, 0.98110000E+00, 0.00000000E+00,
  0.50938490E+03, 0.152E+03, 0.500E+02, 0.98110000E+00, 0.00000000E+00,
  0.45675890E+03, 0.152E+03, 0.510E+02, 0.98110000E+00, 0.00000000E+00,
  0.42531520E+03, 0.152E+03, 0.520E+02, 0.98110000E+00, 0.00000000E+00,
  0.38599880E+03, 0.152E+03, 0.530E+02, 0.98110000E+00, 0.00000000E+00,
  0.34821640E+03, 0.152E+03, 0.540E+02, 0.98110000E+00, 0.00000000E+00,
  0.13899562E+04, 0.152E+03, 0.550E+02, 0.98110000E+00, 0.00000000E+00,
  0.12920505E+04, 0.152E+03, 0.560E+02, 0.98110000E+00, 0.00000000E+00,
  0.11428009E+04, 0.152E+03, 0.570E+02, 0.98110000E+00, 0.00000000E+00,
  0.53897800E+03, 0.152E+03, 0.580E+02, 0.98110000E+00, 0.27991000E+01,
  0.11473718E+04, 0.152E+03, 0.590E+02, 0.98110000E+00, 0.00000000E+00,
  0.11029411E+04, 0.152E+03, 0.600E+02, 0.98110000E+00, 0.00000000E+00,
  0.10755989E+04, 0.152E+03, 0.610E+02, 0.98110000E+00, 0.00000000E+00,
  0.10504168E+04, 0.152E+03, 0.620E+02, 0.98110000E+00, 0.00000000E+00,
  0.10280990E+04, 0.152E+03, 0.630E+02, 0.98110000E+00, 0.00000000E+00,
  0.81457180E+03, 0.152E+03, 0.640E+02, 0.98110000E+00, 0.00000000E+00,
  0.90749290E+03, 0.152E+03, 0.650E+02, 0.98110000E+00, 0.00000000E+00,
  0.87640540E+03, 0.152E+03, 0.660E+02, 0.98110000E+00, 0.00000000E+00,
  0.92881650E+03, 0.152E+03, 0.670E+02, 0.98110000E+00, 0.00000000E+00,
  0.90926160E+03, 0.152E+03, 0.680E+02, 0.98110000E+00, 0.00000000E+00,
  0.89171060E+03, 0.152E+03, 0.690E+02, 0.98110000E+00, 0.00000000E+00,
  0.88100370E+03, 0.152E+03, 0.700E+02, 0.98110000E+00, 0.00000000E+00,
  0.74613080E+03, 0.152E+03, 0.710E+02, 0.98110000E+00, 0.00000000E+00,
  0.73873540E+03, 0.152E+03, 0.720E+02, 0.98110000E+00, 0.00000000E+00,
  0.67688650E+03, 0.152E+03, 0.730E+02, 0.98110000E+00, 0.00000000E+00,
  0.57338870E+03, 0.152E+03, 0.740E+02, 0.98110000E+00, 0.00000000E+00,
  0.58418960E+03, 0.152E+03, 0.750E+02, 0.98110000E+00, 0.00000000E+00,
  0.53122090E+03, 0.152E+03, 0.760E+02, 0.98110000E+00, 0.00000000E+00,
  0.48779780E+03, 0.152E+03, 0.770E+02, 0.98110000E+00, 0.00000000E+00,
  0.40633480E+03, 0.152E+03, 0.780E+02, 0.98110000E+00, 0.00000000E+00,
  0.38005290E+03, 0.152E+03, 0.790E+02, 0.98110000E+00, 0.00000000E+00,
  0.39145330E+03, 0.152E+03, 0.800E+02, 0.98110000E+00, 0.00000000E+00,
  0.56288150E+03, 0.152E+03, 0.810E+02, 0.98110000E+00, 0.00000000E+00,
  0.55306450E+03, 0.152E+03, 0.820E+02, 0.98110000E+00, 0.00000000E+00,
  0.51099880E+03, 0.152E+03, 0.830E+02, 0.98110000E+00, 0.00000000E+00,
  0.48888150E+03, 0.152E+03, 0.840E+02, 0.98110000E+00, 0.00000000E+00,
  0.45282060E+03, 0.152E+03, 0.850E+02, 0.98110000E+00, 0.00000000E+00,
  0.41635580E+03, 0.152E+03, 0.860E+02, 0.98110000E+00, 0.00000000E+00,
  0.13196282E+04, 0.152E+03, 0.870E+02, 0.98110000E+00, 0.00000000E+00,
  0.12821564E+04, 0.152E+03, 0.880E+02, 0.98110000E+00, 0.00000000E+00,
  0.11403381E+04, 0.152E+03, 0.890E+02, 0.98110000E+00, 0.00000000E+00,
  0.10319646E+04, 0.152E+03, 0.900E+02, 0.98110000E+00, 0.00000000E+00,
  0.10211167E+04, 0.152E+03, 0.910E+02, 0.98110000E+00, 0.00000000E+00,
  0.98886570E+03, 0.152E+03, 0.920E+02, 0.98110000E+00, 0.00000000E+00,
  0.10136901E+04, 0.152E+03, 0.930E+02, 0.98110000E+00, 0.00000000E+00,
  0.98242950E+03, 0.152E+03, 0.940E+02, 0.98110000E+00, 0.00000000E+00,
  0.56715600E+02, 0.152E+03, 0.101E+03, 0.98110000E+00, 0.00000000E+00,
  0.17998120E+03, 0.152E+03, 0.103E+03, 0.98110000E+00, 0.98650000E+00,
  0.23026410E+03, 0.152E+03, 0.104E+03, 0.98110000E+00, 0.98080000E+00,
  0.17825090E+03, 0.152E+03, 0.105E+03, 0.98110000E+00, 0.97060000E+00,
  0.13527200E+03, 0.152E+03, 0.106E+03, 0.98110000E+00, 0.98680000E+00,
  0.94770500E+02, 0.152E+03, 0.107E+03, 0.98110000E+00, 0.99440000E+00,
  0.69431700E+02, 0.152E+03, 0.108E+03, 0.98110000E+00, 0.99250000E+00,
  0.48103700E+02, 0.152E+03, 0.109E+03, 0.98110000E+00, 0.99820000E+00,
  0.26236970E+03, 0.152E+03, 0.111E+03, 0.98110000E+00, 0.96840000E+00,
  0.40525290E+03, 0.152E+03, 0.112E+03, 0.98110000E+00, 0.96280000E+00,
  0.41338560E+03, 0.152E+03, 0.113E+03, 0.98110000E+00, 0.96480000E+00,
  0.33559140E+03, 0.152E+03, 0.114E+03, 0.98110000E+00, 0.95070000E+00,
  0.27683720E+03, 0.152E+03, 0.115E+03, 0.98110000E+00, 0.99470000E+00,
  0.23520590E+03, 0.152E+03, 0.116E+03, 0.98110000E+00, 0.99480000E+00,
  0.19317040E+03, 0.152E+03, 0.117E+03, 0.98110000E+00, 0.99720000E+00,
  0.36384820E+03, 0.152E+03, 0.119E+03, 0.98110000E+00, 0.97670000E+00,
  0.68296210E+03, 0.152E+03, 0.120E+03, 0.98110000E+00, 0.98310000E+00,
  0.36699000E+03, 0.152E+03, 0.121E+03, 0.98110000E+00, 0.18627000E+01,
  0.35440290E+03, 0.152E+03, 0.122E+03, 0.98110000E+00, 0.18299000E+01,
  0.34726480E+03, 0.152E+03, 0.123E+03, 0.98110000E+00, 0.19138000E+01,
  0.34370870E+03, 0.152E+03, 0.124E+03, 0.98110000E+00, 0.18269000E+01,
  0.31777500E+03, 0.152E+03, 0.125E+03, 0.98110000E+00, 0.16406000E+01,
  0.29450790E+03, 0.152E+03, 0.126E+03, 0.98110000E+00, 0.16483000E+01,
  0.28094820E+03, 0.152E+03, 0.127E+03, 0.98110000E+00, 0.17149000E+01,
  0.27455800E+03, 0.152E+03, 0.128E+03, 0.98110000E+00, 0.17937000E+01,
  0.27027830E+03, 0.152E+03, 0.129E+03, 0.98110000E+00, 0.95760000E+00,
  0.25527130E+03, 0.152E+03, 0.130E+03, 0.98110000E+00, 0.19419000E+01,
  0.41170180E+03, 0.152E+03, 0.131E+03, 0.98110000E+00, 0.96010000E+00,
  0.36448820E+03, 0.152E+03, 0.132E+03, 0.98110000E+00, 0.94340000E+00,
  0.32849090E+03, 0.152E+03, 0.133E+03, 0.98110000E+00, 0.98890000E+00,
  0.30105670E+03, 0.152E+03, 0.134E+03, 0.98110000E+00, 0.99010000E+00,
  0.26622780E+03, 0.152E+03, 0.135E+03, 0.98110000E+00, 0.99740000E+00,
  0.43493910E+03, 0.152E+03, 0.137E+03, 0.98110000E+00, 0.97380000E+00,
  0.83036610E+03, 0.152E+03, 0.138E+03, 0.98110000E+00, 0.98010000E+00,
  0.64326970E+03, 0.152E+03, 0.139E+03, 0.98110000E+00, 0.19153000E+01,
  0.48508560E+03, 0.152E+03, 0.140E+03, 0.98110000E+00, 0.19355000E+01,
  0.48977500E+03, 0.152E+03, 0.141E+03, 0.98110000E+00, 0.19545000E+01,
  0.45747170E+03, 0.152E+03, 0.142E+03, 0.98110000E+00, 0.19420000E+01,
  0.50987810E+03, 0.152E+03, 0.143E+03, 0.98110000E+00, 0.16682000E+01,
  0.40053650E+03, 0.152E+03, 0.144E+03, 0.98110000E+00, 0.18584000E+01,
  0.37486560E+03, 0.152E+03, 0.145E+03, 0.98110000E+00, 0.19003000E+01,
  0.34838020E+03, 0.152E+03, 0.146E+03, 0.98110000E+00, 0.18630000E+01,
  0.33677710E+03, 0.152E+03, 0.147E+03, 0.98110000E+00, 0.96790000E+00,
  0.33432410E+03, 0.152E+03, 0.148E+03, 0.98110000E+00, 0.19539000E+01,
  0.52288630E+03, 0.152E+03, 0.149E+03, 0.98110000E+00, 0.96330000E+00,
  0.47620870E+03, 0.152E+03, 0.150E+03, 0.98110000E+00, 0.95140000E+00,
  0.44801730E+03, 0.152E+03, 0.151E+03, 0.98110000E+00, 0.97490000E+00,
  0.42510150E+03, 0.152E+03, 0.152E+03, 0.98110000E+00, 0.98110000E+00,
  0.32815100E+02, 0.153E+03, 0.100E+01, 0.99680000E+00, 0.91180000E+00,
  0.22271700E+02, 0.153E+03, 0.200E+01, 0.99680000E+00, 0.00000000E+00,
  0.45439540E+03, 0.153E+03, 0.300E+01, 0.99680000E+00, 0.00000000E+00,
  0.27643090E+03, 0.153E+03, 0.400E+01, 0.99680000E+00, 0.00000000E+00,
  0.19192730E+03, 0.153E+03, 0.500E+01, 0.99680000E+00, 0.00000000E+00,
  0.13262510E+03, 0.153E+03, 0.600E+01, 0.99680000E+00, 0.00000000E+00,
  0.94299100E+02, 0.153E+03, 0.700E+01, 0.99680000E+00, 0.00000000E+00,
  0.72235800E+02, 0.153E+03, 0.800E+01, 0.99680000E+00, 0.00000000E+00,
  0.55268900E+02, 0.153E+03, 0.900E+01, 0.99680000E+00, 0.00000000E+00,
  0.42851200E+02, 0.153E+03, 0.100E+02, 0.99680000E+00, 0.00000000E+00,
  0.54528550E+03, 0.153E+03, 0.110E+02, 0.99680000E+00, 0.00000000E+00,
  0.43644520E+03, 0.153E+03, 0.120E+02, 0.99680000E+00, 0.00000000E+00,
  0.40871490E+03, 0.153E+03, 0.130E+02, 0.99680000E+00, 0.00000000E+00,
  0.32881570E+03, 0.153E+03, 0.140E+02, 0.99680000E+00, 0.00000000E+00,
  0.26094460E+03, 0.153E+03, 0.150E+02, 0.99680000E+00, 0.00000000E+00,
  0.21904300E+03, 0.153E+03, 0.160E+02, 0.99680000E+00, 0.00000000E+00,
  0.18086040E+03, 0.153E+03, 0.170E+02, 0.99680000E+00, 0.00000000E+00,
  0.14934300E+03, 0.153E+03, 0.180E+02, 0.99680000E+00, 0.00000000E+00,
  0.88900260E+03, 0.153E+03, 0.190E+02, 0.99680000E+00, 0.00000000E+00,
  0.75534780E+03, 0.153E+03, 0.200E+02, 0.99680000E+00, 0.00000000E+00,
  0.62833170E+03, 0.153E+03, 0.210E+02, 0.99680000E+00, 0.00000000E+00,
  0.61099490E+03, 0.153E+03, 0.220E+02, 0.99680000E+00, 0.00000000E+00,
  0.56176430E+03, 0.153E+03, 0.230E+02, 0.99680000E+00, 0.00000000E+00,
  0.44344010E+03, 0.153E+03, 0.240E+02, 0.99680000E+00, 0.00000000E+00,
  0.48650250E+03, 0.153E+03, 0.250E+02, 0.99680000E+00, 0.00000000E+00,
  0.38289000E+03, 0.153E+03, 0.260E+02, 0.99680000E+00, 0.00000000E+00,
  0.40860640E+03, 0.153E+03, 0.270E+02, 0.99680000E+00, 0.00000000E+00,
  0.41915920E+03, 0.153E+03, 0.280E+02, 0.99680000E+00, 0.00000000E+00,
  0.32203460E+03, 0.153E+03, 0.290E+02, 0.99680000E+00, 0.00000000E+00,
  0.33424140E+03, 0.153E+03, 0.300E+02, 0.99680000E+00, 0.00000000E+00,
  0.39422890E+03, 0.153E+03, 0.310E+02, 0.99680000E+00, 0.00000000E+00,
  0.35311560E+03, 0.153E+03, 0.320E+02, 0.99680000E+00, 0.00000000E+00,
  0.30552140E+03, 0.153E+03, 0.330E+02, 0.99680000E+00, 0.00000000E+00,
  0.27661090E+03, 0.153E+03, 0.340E+02, 0.99680000E+00, 0.00000000E+00,
  0.24427520E+03, 0.153E+03, 0.350E+02, 0.99680000E+00, 0.00000000E+00,
  0.21420040E+03, 0.153E+03, 0.360E+02, 0.99680000E+00, 0.00000000E+00,
  0.99978710E+03, 0.153E+03, 0.370E+02, 0.99680000E+00, 0.00000000E+00,
  0.89949300E+03, 0.153E+03, 0.380E+02, 0.99680000E+00, 0.00000000E+00,
  0.79779010E+03, 0.153E+03, 0.390E+02, 0.99680000E+00, 0.00000000E+00,
  0.72272400E+03, 0.153E+03, 0.400E+02, 0.99680000E+00, 0.00000000E+00,
  0.66260680E+03, 0.153E+03, 0.410E+02, 0.99680000E+00, 0.00000000E+00,
  0.51659320E+03, 0.153E+03, 0.420E+02, 0.99680000E+00, 0.00000000E+00,
  0.57428050E+03, 0.153E+03, 0.430E+02, 0.99680000E+00, 0.00000000E+00,
  0.44217100E+03, 0.153E+03, 0.440E+02, 0.99680000E+00, 0.00000000E+00,
  0.48282170E+03, 0.153E+03, 0.450E+02, 0.99680000E+00, 0.00000000E+00,
  0.44920610E+03, 0.153E+03, 0.460E+02, 0.99680000E+00, 0.00000000E+00,
  0.37444670E+03, 0.153E+03, 0.470E+02, 0.99680000E+00, 0.00000000E+00,
  0.39749790E+03, 0.153E+03, 0.480E+02, 0.99680000E+00, 0.00000000E+00,
  0.49366250E+03, 0.153E+03, 0.490E+02, 0.99680000E+00, 0.00000000E+00,
  0.46207160E+03, 0.153E+03, 0.500E+02, 0.99680000E+00, 0.00000000E+00,
  0.41687150E+03, 0.153E+03, 0.510E+02, 0.99680000E+00, 0.00000000E+00,
  0.38970290E+03, 0.153E+03, 0.520E+02, 0.99680000E+00, 0.00000000E+00,
  0.35521750E+03, 0.153E+03, 0.530E+02, 0.99680000E+00, 0.00000000E+00,
  0.32180290E+03, 0.153E+03, 0.540E+02, 0.99680000E+00, 0.00000000E+00,
  0.12196272E+04, 0.153E+03, 0.550E+02, 0.99680000E+00, 0.00000000E+00,
  0.11429378E+04, 0.153E+03, 0.560E+02, 0.99680000E+00, 0.00000000E+00,
  0.10164155E+04, 0.153E+03, 0.570E+02, 0.99680000E+00, 0.00000000E+00,
  0.49161500E+03, 0.153E+03, 0.580E+02, 0.99680000E+00, 0.27991000E+01,
  0.10169588E+04, 0.153E+03, 0.590E+02, 0.99680000E+00, 0.00000000E+00,
  0.97834710E+03, 0.153E+03, 0.600E+02, 0.99680000E+00, 0.00000000E+00,
  0.95429670E+03, 0.153E+03, 0.610E+02, 0.99680000E+00, 0.00000000E+00,
  0.93211660E+03, 0.153E+03, 0.620E+02, 0.99680000E+00, 0.00000000E+00,
  0.91246710E+03, 0.153E+03, 0.630E+02, 0.99680000E+00, 0.00000000E+00,
  0.72800530E+03, 0.153E+03, 0.640E+02, 0.99680000E+00, 0.00000000E+00,
  0.80453430E+03, 0.153E+03, 0.650E+02, 0.99680000E+00, 0.00000000E+00,
  0.77785480E+03, 0.153E+03, 0.660E+02, 0.99680000E+00, 0.00000000E+00,
  0.82536440E+03, 0.153E+03, 0.670E+02, 0.99680000E+00, 0.00000000E+00,
  0.80806540E+03, 0.153E+03, 0.680E+02, 0.99680000E+00, 0.00000000E+00,
  0.79260610E+03, 0.153E+03, 0.690E+02, 0.99680000E+00, 0.00000000E+00,
  0.78284050E+03, 0.153E+03, 0.700E+02, 0.99680000E+00, 0.00000000E+00,
  0.66614790E+03, 0.153E+03, 0.710E+02, 0.99680000E+00, 0.00000000E+00,
  0.66319200E+03, 0.153E+03, 0.720E+02, 0.99680000E+00, 0.00000000E+00,
  0.61001430E+03, 0.153E+03, 0.730E+02, 0.99680000E+00, 0.00000000E+00,
  0.51873530E+03, 0.153E+03, 0.740E+02, 0.99680000E+00, 0.00000000E+00,
  0.52912210E+03, 0.153E+03, 0.750E+02, 0.99680000E+00, 0.00000000E+00,
  0.48278010E+03, 0.153E+03, 0.760E+02, 0.99680000E+00, 0.00000000E+00,
  0.44456400E+03, 0.153E+03, 0.770E+02, 0.99680000E+00, 0.00000000E+00,
  0.37168100E+03, 0.153E+03, 0.780E+02, 0.99680000E+00, 0.00000000E+00,
  0.34813080E+03, 0.153E+03, 0.790E+02, 0.99680000E+00, 0.00000000E+00,
  0.35883830E+03, 0.153E+03, 0.800E+02, 0.99680000E+00, 0.00000000E+00,
  0.50911500E+03, 0.153E+03, 0.810E+02, 0.99680000E+00, 0.00000000E+00,
  0.50219660E+03, 0.153E+03, 0.820E+02, 0.99680000E+00, 0.00000000E+00,
  0.46641830E+03, 0.153E+03, 0.830E+02, 0.99680000E+00, 0.00000000E+00,
  0.44766490E+03, 0.153E+03, 0.840E+02, 0.99680000E+00, 0.00000000E+00,
  0.41630430E+03, 0.153E+03, 0.850E+02, 0.99680000E+00, 0.00000000E+00,
  0.38423110E+03, 0.153E+03, 0.860E+02, 0.99680000E+00, 0.00000000E+00,
  0.11630702E+04, 0.153E+03, 0.870E+02, 0.99680000E+00, 0.00000000E+00,
  0.11376470E+04, 0.153E+03, 0.880E+02, 0.99680000E+00, 0.00000000E+00,
  0.10167803E+04, 0.153E+03, 0.890E+02, 0.99680000E+00, 0.00000000E+00,
  0.92598120E+03, 0.153E+03, 0.900E+02, 0.99680000E+00, 0.00000000E+00,
  0.91390750E+03, 0.153E+03, 0.910E+02, 0.99680000E+00, 0.00000000E+00,
  0.88520210E+03, 0.153E+03, 0.920E+02, 0.99680000E+00, 0.00000000E+00,
  0.90396880E+03, 0.153E+03, 0.930E+02, 0.99680000E+00, 0.00000000E+00,
  0.87665190E+03, 0.153E+03, 0.940E+02, 0.99680000E+00, 0.00000000E+00,
  0.51949600E+02, 0.153E+03, 0.101E+03, 0.99680000E+00, 0.00000000E+00,
  0.16143030E+03, 0.153E+03, 0.103E+03, 0.99680000E+00, 0.98650000E+00,
  0.20721850E+03, 0.153E+03, 0.104E+03, 0.99680000E+00, 0.98080000E+00,
  0.16249390E+03, 0.153E+03, 0.105E+03, 0.99680000E+00, 0.97060000E+00,
  0.12439580E+03, 0.153E+03, 0.106E+03, 0.99680000E+00, 0.98680000E+00,
  0.87986900E+02, 0.153E+03, 0.107E+03, 0.99680000E+00, 0.99440000E+00,
  0.64976400E+02, 0.153E+03, 0.108E+03, 0.99680000E+00, 0.99250000E+00,
  0.45461800E+02, 0.153E+03, 0.109E+03, 0.99680000E+00, 0.99820000E+00,
  0.23487760E+03, 0.153E+03, 0.111E+03, 0.99680000E+00, 0.96840000E+00,
  0.36232580E+03, 0.153E+03, 0.112E+03, 0.99680000E+00, 0.96280000E+00,
  0.37186150E+03, 0.153E+03, 0.113E+03, 0.99680000E+00, 0.96480000E+00,
  0.30487150E+03, 0.153E+03, 0.114E+03, 0.99680000E+00, 0.95070000E+00,
  0.25346770E+03, 0.153E+03, 0.115E+03, 0.99680000E+00, 0.99470000E+00,
  0.21658660E+03, 0.153E+03, 0.116E+03, 0.99680000E+00, 0.99480000E+00,
  0.17895810E+03, 0.153E+03, 0.117E+03, 0.99680000E+00, 0.99720000E+00,
  0.32822070E+03, 0.153E+03, 0.119E+03, 0.99680000E+00, 0.97670000E+00,
  0.60618590E+03, 0.153E+03, 0.120E+03, 0.99680000E+00, 0.98310000E+00,
  0.33318010E+03, 0.153E+03, 0.121E+03, 0.99680000E+00, 0.18627000E+01,
  0.32194330E+03, 0.153E+03, 0.122E+03, 0.99680000E+00, 0.18299000E+01,
  0.31543490E+03, 0.153E+03, 0.123E+03, 0.99680000E+00, 0.19138000E+01,
  0.31193950E+03, 0.153E+03, 0.124E+03, 0.99680000E+00, 0.18269000E+01,
  0.28957840E+03, 0.153E+03, 0.125E+03, 0.99680000E+00, 0.16406000E+01,
  0.26879340E+03, 0.153E+03, 0.126E+03, 0.99680000E+00, 0.16483000E+01,
  0.25647210E+03, 0.153E+03, 0.127E+03, 0.99680000E+00, 0.17149000E+01,
  0.25055360E+03, 0.153E+03, 0.128E+03, 0.99680000E+00, 0.17937000E+01,
  0.24584350E+03, 0.153E+03, 0.129E+03, 0.99680000E+00, 0.95760000E+00,
  0.23356320E+03, 0.153E+03, 0.130E+03, 0.99680000E+00, 0.19419000E+01,
  0.37176550E+03, 0.153E+03, 0.131E+03, 0.99680000E+00, 0.96010000E+00,
  0.33159870E+03, 0.153E+03, 0.132E+03, 0.99680000E+00, 0.94340000E+00,
  0.30060430E+03, 0.153E+03, 0.133E+03, 0.99680000E+00, 0.98890000E+00,
  0.27668620E+03, 0.153E+03, 0.134E+03, 0.99680000E+00, 0.99010000E+00,
  0.24586470E+03, 0.153E+03, 0.135E+03, 0.99680000E+00, 0.99740000E+00,
  0.39318090E+03, 0.153E+03, 0.137E+03, 0.99680000E+00, 0.97380000E+00,
  0.73690210E+03, 0.153E+03, 0.138E+03, 0.99680000E+00, 0.98010000E+00,
  0.57738050E+03, 0.153E+03, 0.139E+03, 0.99680000E+00, 0.19153000E+01,
  0.44044740E+03, 0.153E+03, 0.140E+03, 0.99680000E+00, 0.19355000E+01,
  0.44464020E+03, 0.153E+03, 0.141E+03, 0.99680000E+00, 0.19545000E+01,
  0.41612070E+03, 0.153E+03, 0.142E+03, 0.99680000E+00, 0.19420000E+01,
  0.46132230E+03, 0.153E+03, 0.143E+03, 0.99680000E+00, 0.16682000E+01,
  0.36592820E+03, 0.153E+03, 0.144E+03, 0.99680000E+00, 0.18584000E+01,
  0.34272790E+03, 0.153E+03, 0.145E+03, 0.99680000E+00, 0.19003000E+01,
  0.31886290E+03, 0.153E+03, 0.146E+03, 0.99680000E+00, 0.18630000E+01,
  0.30804750E+03, 0.153E+03, 0.147E+03, 0.99680000E+00, 0.96790000E+00,
  0.30665490E+03, 0.153E+03, 0.148E+03, 0.99680000E+00, 0.19539000E+01,
  0.47264410E+03, 0.153E+03, 0.149E+03, 0.99680000E+00, 0.96330000E+00,
  0.43305890E+03, 0.153E+03, 0.150E+03, 0.99680000E+00, 0.95140000E+00,
  0.40924850E+03, 0.153E+03, 0.151E+03, 0.99680000E+00, 0.97490000E+00,
  0.38959960E+03, 0.153E+03, 0.152E+03, 0.99680000E+00, 0.98110000E+00,
  0.35849950E+03, 0.153E+03, 0.153E+03, 0.99680000E+00, 0.99680000E+00,
  0.42305800E+02, 0.155E+03, 0.100E+01, 0.99090000E+00, 0.91180000E+00,
  0.27469500E+02, 0.155E+03, 0.200E+01, 0.99090000E+00, 0.00000000E+00,
  0.73291200E+03, 0.155E+03, 0.300E+01, 0.99090000E+00, 0.00000000E+00,
  0.39940200E+03, 0.155E+03, 0.400E+01, 0.99090000E+00, 0.00000000E+00,
  0.26223870E+03, 0.155E+03, 0.500E+01, 0.99090000E+00, 0.00000000E+00,
  0.17427180E+03, 0.155E+03, 0.600E+01, 0.99090000E+00, 0.00000000E+00,
  0.12049820E+03, 0.155E+03, 0.700E+01, 0.99090000E+00, 0.00000000E+00,
  0.90530300E+02, 0.155E+03, 0.800E+01, 0.99090000E+00, 0.00000000E+00,
  0.68123900E+02, 0.155E+03, 0.900E+01, 0.99090000E+00, 0.00000000E+00,
  0.52104100E+02, 0.155E+03, 0.100E+02, 0.99090000E+00, 0.00000000E+00,
  0.87326650E+03, 0.155E+03, 0.110E+02, 0.99090000E+00, 0.00000000E+00,
  0.64218460E+03, 0.155E+03, 0.120E+02, 0.99090000E+00, 0.00000000E+00,
  0.58368500E+03, 0.155E+03, 0.130E+02, 0.99090000E+00, 0.00000000E+00,
  0.45161710E+03, 0.155E+03, 0.140E+02, 0.99090000E+00, 0.00000000E+00,
  0.34740300E+03, 0.155E+03, 0.150E+02, 0.99090000E+00, 0.00000000E+00,
  0.28604180E+03, 0.155E+03, 0.160E+02, 0.99090000E+00, 0.00000000E+00,
  0.23194830E+03, 0.155E+03, 0.170E+02, 0.99090000E+00, 0.00000000E+00,
  0.18859500E+03, 0.155E+03, 0.180E+02, 0.99090000E+00, 0.00000000E+00,
  0.14495860E+04, 0.155E+03, 0.190E+02, 0.99090000E+00, 0.00000000E+00,
  0.11498295E+04, 0.155E+03, 0.200E+02, 0.99090000E+00, 0.00000000E+00,
  0.94227450E+03, 0.155E+03, 0.210E+02, 0.99090000E+00, 0.00000000E+00,
  0.90422250E+03, 0.155E+03, 0.220E+02, 0.99090000E+00, 0.00000000E+00,
  0.82477800E+03, 0.155E+03, 0.230E+02, 0.99090000E+00, 0.00000000E+00,
  0.65006270E+03, 0.155E+03, 0.240E+02, 0.99090000E+00, 0.00000000E+00,
  0.70614120E+03, 0.155E+03, 0.250E+02, 0.99090000E+00, 0.00000000E+00,
  0.55409250E+03, 0.155E+03, 0.260E+02, 0.99090000E+00, 0.00000000E+00,
  0.58184580E+03, 0.155E+03, 0.270E+02, 0.99090000E+00, 0.00000000E+00,
  0.60158080E+03, 0.155E+03, 0.280E+02, 0.99090000E+00, 0.00000000E+00,
  0.46170190E+03, 0.155E+03, 0.290E+02, 0.99090000E+00, 0.00000000E+00,
  0.46787310E+03, 0.155E+03, 0.300E+02, 0.99090000E+00, 0.00000000E+00,
  0.55650160E+03, 0.155E+03, 0.310E+02, 0.99090000E+00, 0.00000000E+00,
  0.48371170E+03, 0.155E+03, 0.320E+02, 0.99090000E+00, 0.00000000E+00,
  0.40779580E+03, 0.155E+03, 0.330E+02, 0.99090000E+00, 0.00000000E+00,
  0.36352860E+03, 0.155E+03, 0.340E+02, 0.99090000E+00, 0.00000000E+00,
  0.31607000E+03, 0.155E+03, 0.350E+02, 0.99090000E+00, 0.00000000E+00,
  0.27329990E+03, 0.155E+03, 0.360E+02, 0.99090000E+00, 0.00000000E+00,
  0.16207604E+04, 0.155E+03, 0.370E+02, 0.99090000E+00, 0.00000000E+00,
  0.13728515E+04, 0.155E+03, 0.380E+02, 0.99090000E+00, 0.00000000E+00,
  0.11863885E+04, 0.155E+03, 0.390E+02, 0.99090000E+00, 0.00000000E+00,
  0.10577660E+04, 0.155E+03, 0.400E+02, 0.99090000E+00, 0.00000000E+00,
  0.95979080E+03, 0.155E+03, 0.410E+02, 0.99090000E+00, 0.00000000E+00,
  0.73514980E+03, 0.155E+03, 0.420E+02, 0.99090000E+00, 0.00000000E+00,
  0.82258290E+03, 0.155E+03, 0.430E+02, 0.99090000E+00, 0.00000000E+00,
  0.62119680E+03, 0.155E+03, 0.440E+02, 0.99090000E+00, 0.00000000E+00,
  0.67827670E+03, 0.155E+03, 0.450E+02, 0.99090000E+00, 0.00000000E+00,
  0.62700570E+03, 0.155E+03, 0.460E+02, 0.99090000E+00, 0.00000000E+00,
  0.52450750E+03, 0.155E+03, 0.470E+02, 0.99090000E+00, 0.00000000E+00,
  0.55025650E+03, 0.155E+03, 0.480E+02, 0.99090000E+00, 0.00000000E+00,
  0.69737450E+03, 0.155E+03, 0.490E+02, 0.99090000E+00, 0.00000000E+00,
  0.63676120E+03, 0.155E+03, 0.500E+02, 0.99090000E+00, 0.00000000E+00,
  0.56125330E+03, 0.155E+03, 0.510E+02, 0.99090000E+00, 0.00000000E+00,
  0.51758070E+03, 0.155E+03, 0.520E+02, 0.99090000E+00, 0.00000000E+00,
  0.46507030E+03, 0.155E+03, 0.530E+02, 0.99090000E+00, 0.00000000E+00,
  0.41576900E+03, 0.155E+03, 0.540E+02, 0.99090000E+00, 0.00000000E+00,
  0.19759738E+04, 0.155E+03, 0.550E+02, 0.99090000E+00, 0.00000000E+00,
  0.17600602E+04, 0.155E+03, 0.560E+02, 0.99090000E+00, 0.00000000E+00,
  0.15249399E+04, 0.155E+03, 0.570E+02, 0.99090000E+00, 0.00000000E+00,
  0.66483460E+03, 0.155E+03, 0.580E+02, 0.99090000E+00, 0.27991000E+01,
  0.15520845E+04, 0.155E+03, 0.590E+02, 0.99090000E+00, 0.00000000E+00,
  0.14864897E+04, 0.155E+03, 0.600E+02, 0.99090000E+00, 0.00000000E+00,
  0.14481464E+04, 0.155E+03, 0.610E+02, 0.99090000E+00, 0.00000000E+00,
  0.14129908E+04, 0.155E+03, 0.620E+02, 0.99090000E+00, 0.00000000E+00,
  0.13817863E+04, 0.155E+03, 0.630E+02, 0.99090000E+00, 0.00000000E+00,
  0.10715717E+04, 0.155E+03, 0.640E+02, 0.99090000E+00, 0.00000000E+00,
  0.12355701E+04, 0.155E+03, 0.650E+02, 0.99090000E+00, 0.00000000E+00,
  0.11888012E+04, 0.155E+03, 0.660E+02, 0.99090000E+00, 0.00000000E+00,
  0.12416267E+04, 0.155E+03, 0.670E+02, 0.99090000E+00, 0.00000000E+00,
  0.12147181E+04, 0.155E+03, 0.680E+02, 0.99090000E+00, 0.00000000E+00,
  0.11902611E+04, 0.155E+03, 0.690E+02, 0.99090000E+00, 0.00000000E+00,
  0.11769746E+04, 0.155E+03, 0.700E+02, 0.99090000E+00, 0.00000000E+00,
  0.98243040E+03, 0.155E+03, 0.710E+02, 0.99090000E+00, 0.00000000E+00,
  0.95327210E+03, 0.155E+03, 0.720E+02, 0.99090000E+00, 0.00000000E+00,
  0.86345810E+03, 0.155E+03, 0.730E+02, 0.99090000E+00, 0.00000000E+00,
  0.72569910E+03, 0.155E+03, 0.740E+02, 0.99090000E+00, 0.00000000E+00,
  0.73587000E+03, 0.155E+03, 0.750E+02, 0.99090000E+00, 0.00000000E+00,
  0.66279760E+03, 0.155E+03, 0.760E+02, 0.99090000E+00, 0.00000000E+00,
  0.60405240E+03, 0.155E+03, 0.770E+02, 0.99090000E+00, 0.00000000E+00,
  0.49959380E+03, 0.155E+03, 0.780E+02, 0.99090000E+00, 0.00000000E+00,
  0.46588050E+03, 0.155E+03, 0.790E+02, 0.99090000E+00, 0.00000000E+00,
  0.47788590E+03, 0.155E+03, 0.800E+02, 0.99090000E+00, 0.00000000E+00,
  0.71477590E+03, 0.155E+03, 0.810E+02, 0.99090000E+00, 0.00000000E+00,
  0.69152340E+03, 0.155E+03, 0.820E+02, 0.99090000E+00, 0.00000000E+00,
  0.62890510E+03, 0.155E+03, 0.830E+02, 0.99090000E+00, 0.00000000E+00,
  0.59653870E+03, 0.155E+03, 0.840E+02, 0.99090000E+00, 0.00000000E+00,
  0.54712200E+03, 0.155E+03, 0.850E+02, 0.99090000E+00, 0.00000000E+00,
  0.49878710E+03, 0.155E+03, 0.860E+02, 0.99090000E+00, 0.00000000E+00,
  0.18443405E+04, 0.155E+03, 0.870E+02, 0.99090000E+00, 0.00000000E+00,
  0.17284117E+04, 0.155E+03, 0.880E+02, 0.99090000E+00, 0.00000000E+00,
  0.15078114E+04, 0.155E+03, 0.890E+02, 0.99090000E+00, 0.00000000E+00,
  0.13366572E+04, 0.155E+03, 0.900E+02, 0.99090000E+00, 0.00000000E+00,
  0.13367673E+04, 0.155E+03, 0.910E+02, 0.99090000E+00, 0.00000000E+00,
  0.12938174E+04, 0.155E+03, 0.920E+02, 0.99090000E+00, 0.00000000E+00,
  0.13431115E+04, 0.155E+03, 0.930E+02, 0.99090000E+00, 0.00000000E+00,
  0.12984675E+04, 0.155E+03, 0.940E+02, 0.99090000E+00, 0.00000000E+00,
  0.68953700E+02, 0.155E+03, 0.101E+03, 0.99090000E+00, 0.00000000E+00,
  0.23141650E+03, 0.155E+03, 0.103E+03, 0.99090000E+00, 0.98650000E+00,
  0.29414590E+03, 0.155E+03, 0.104E+03, 0.99090000E+00, 0.98080000E+00,
  0.21963870E+03, 0.155E+03, 0.105E+03, 0.99090000E+00, 0.97060000E+00,
  0.16367150E+03, 0.155E+03, 0.106E+03, 0.99090000E+00, 0.98680000E+00,
  0.11242780E+03, 0.155E+03, 0.107E+03, 0.99090000E+00, 0.99440000E+00,
  0.81084500E+02, 0.155E+03, 0.108E+03, 0.99090000E+00, 0.99250000E+00,
  0.55078600E+02, 0.155E+03, 0.109E+03, 0.99090000E+00, 0.99820000E+00,
  0.34006240E+03, 0.155E+03, 0.111E+03, 0.99090000E+00, 0.96840000E+00,
  0.52756300E+03, 0.155E+03, 0.112E+03, 0.99090000E+00, 0.96280000E+00,
  0.52732820E+03, 0.155E+03, 0.113E+03, 0.99090000E+00, 0.96480000E+00,
  0.41648610E+03, 0.155E+03, 0.114E+03, 0.99090000E+00, 0.95070000E+00,
  0.33711350E+03, 0.155E+03, 0.115E+03, 0.99090000E+00, 0.99470000E+00,
  0.28296690E+03, 0.155E+03, 0.116E+03, 0.99090000E+00, 0.99480000E+00,
  0.22958370E+03, 0.155E+03, 0.117E+03, 0.99090000E+00, 0.99720000E+00,
  0.46551820E+03, 0.155E+03, 0.119E+03, 0.99090000E+00, 0.97670000E+00,
  0.92179340E+03, 0.155E+03, 0.120E+03, 0.99090000E+00, 0.98310000E+00,
  0.45790120E+03, 0.155E+03, 0.121E+03, 0.99090000E+00, 0.18627000E+01,
  0.44205470E+03, 0.155E+03, 0.122E+03, 0.99090000E+00, 0.18299000E+01,
  0.43331390E+03, 0.155E+03, 0.123E+03, 0.99090000E+00, 0.19138000E+01,
  0.43010400E+03, 0.155E+03, 0.124E+03, 0.99090000E+00, 0.18269000E+01,
  0.39208310E+03, 0.155E+03, 0.125E+03, 0.99090000E+00, 0.16406000E+01,
  0.36204550E+03, 0.155E+03, 0.126E+03, 0.99090000E+00, 0.16483000E+01,
  0.34544700E+03, 0.155E+03, 0.127E+03, 0.99090000E+00, 0.17149000E+01,
  0.33794540E+03, 0.155E+03, 0.128E+03, 0.99090000E+00, 0.17937000E+01,
  0.33608210E+03, 0.155E+03, 0.129E+03, 0.99090000E+00, 0.95760000E+00,
  0.31158000E+03, 0.155E+03, 0.130E+03, 0.99090000E+00, 0.19419000E+01,
  0.52074900E+03, 0.155E+03, 0.131E+03, 0.99090000E+00, 0.96010000E+00,
  0.45117170E+03, 0.155E+03, 0.132E+03, 0.99090000E+00, 0.94340000E+00,
  0.40064390E+03, 0.155E+03, 0.133E+03, 0.99090000E+00, 0.98890000E+00,
  0.36372020E+03, 0.155E+03, 0.134E+03, 0.99090000E+00, 0.99010000E+00,
  0.31838270E+03, 0.155E+03, 0.135E+03, 0.99090000E+00, 0.99740000E+00,
  0.55397800E+03, 0.155E+03, 0.137E+03, 0.99090000E+00, 0.97380000E+00,
  0.11249345E+04, 0.155E+03, 0.138E+03, 0.99090000E+00, 0.98010000E+00,
  0.83761350E+03, 0.155E+03, 0.139E+03, 0.99090000E+00, 0.19153000E+01,
  0.60719510E+03, 0.155E+03, 0.140E+03, 0.99090000E+00, 0.19355000E+01,
  0.61320100E+03, 0.155E+03, 0.141E+03, 0.99090000E+00, 0.19545000E+01,
  0.57026210E+03, 0.155E+03, 0.142E+03, 0.99090000E+00, 0.19420000E+01,
  0.64766860E+03, 0.155E+03, 0.143E+03, 0.99090000E+00, 0.16682000E+01,
  0.49283010E+03, 0.155E+03, 0.144E+03, 0.99090000E+00, 0.18584000E+01,
  0.46081940E+03, 0.155E+03, 0.145E+03, 0.99090000E+00, 0.19003000E+01,
  0.42732470E+03, 0.155E+03, 0.146E+03, 0.99090000E+00, 0.18630000E+01,
  0.41377960E+03, 0.155E+03, 0.147E+03, 0.99090000E+00, 0.96790000E+00,
  0.40654590E+03, 0.155E+03, 0.148E+03, 0.99090000E+00, 0.19539000E+01,
  0.66184230E+03, 0.155E+03, 0.149E+03, 0.99090000E+00, 0.96330000E+00,
  0.59127640E+03, 0.155E+03, 0.150E+03, 0.99090000E+00, 0.95140000E+00,
  0.54930440E+03, 0.155E+03, 0.151E+03, 0.99090000E+00, 0.97490000E+00,
  0.51701090E+03, 0.155E+03, 0.152E+03, 0.99090000E+00, 0.98110000E+00,
  0.46948180E+03, 0.155E+03, 0.153E+03, 0.99090000E+00, 0.99680000E+00,
  0.64909240E+03, 0.155E+03, 0.155E+03, 0.99090000E+00, 0.99090000E+00,
  0.83014100E+02, 0.156E+03, 0.100E+01, 0.97970000E+00, 0.91180000E+00,
  0.49923200E+02, 0.156E+03, 0.200E+01, 0.97970000E+00, 0.00000000E+00,
  0.21804015E+04, 0.156E+03, 0.300E+01, 0.97970000E+00, 0.00000000E+00,
  0.96110490E+03, 0.156E+03, 0.400E+01, 0.97970000E+00, 0.00000000E+00,
  0.57230020E+03, 0.156E+03, 0.500E+01, 0.97970000E+00, 0.00000000E+00,
  0.35484660E+03, 0.156E+03, 0.600E+01, 0.97970000E+00, 0.00000000E+00,
  0.23350060E+03, 0.156E+03, 0.700E+01, 0.97970000E+00, 0.00000000E+00,
  0.16960300E+03, 0.156E+03, 0.800E+01, 0.97970000E+00, 0.00000000E+00,
  0.12408020E+03, 0.156E+03, 0.900E+01, 0.97970000E+00, 0.00000000E+00,
  0.92849400E+02, 0.156E+03, 0.100E+02, 0.97970000E+00, 0.00000000E+00,
  0.25659398E+04, 0.156E+03, 0.110E+02, 0.97970000E+00, 0.00000000E+00,
  0.15996001E+04, 0.156E+03, 0.120E+02, 0.97970000E+00, 0.00000000E+00,
  0.13814389E+04, 0.156E+03, 0.130E+02, 0.97970000E+00, 0.00000000E+00,
  0.99489260E+03, 0.156E+03, 0.140E+02, 0.97970000E+00, 0.00000000E+00,
  0.72325040E+03, 0.156E+03, 0.150E+02, 0.97970000E+00, 0.00000000E+00,
  0.57533170E+03, 0.156E+03, 0.160E+02, 0.97970000E+00, 0.00000000E+00,
  0.45158250E+03, 0.156E+03, 0.170E+02, 0.97970000E+00, 0.00000000E+00,
  0.35719350E+03, 0.156E+03, 0.180E+02, 0.97970000E+00, 0.00000000E+00,
  0.44958369E+04, 0.156E+03, 0.190E+02, 0.97970000E+00, 0.00000000E+00,
  0.30704624E+04, 0.156E+03, 0.200E+02, 0.97970000E+00, 0.00000000E+00,
  0.24434277E+04, 0.156E+03, 0.210E+02, 0.97970000E+00, 0.00000000E+00,
  0.22946062E+04, 0.156E+03, 0.220E+02, 0.97970000E+00, 0.00000000E+00,
  0.20640309E+04, 0.156E+03, 0.230E+02, 0.97970000E+00, 0.00000000E+00,
  0.16327022E+04, 0.156E+03, 0.240E+02, 0.97970000E+00, 0.00000000E+00,
  0.17320375E+04, 0.156E+03, 0.250E+02, 0.97970000E+00, 0.00000000E+00,
  0.13596156E+04, 0.156E+03, 0.260E+02, 0.97970000E+00, 0.00000000E+00,
  0.13759674E+04, 0.156E+03, 0.270E+02, 0.97970000E+00, 0.00000000E+00,
  0.14425133E+04, 0.156E+03, 0.280E+02, 0.97970000E+00, 0.00000000E+00,
  0.11138541E+04, 0.156E+03, 0.290E+02, 0.97970000E+00, 0.00000000E+00,
  0.10720643E+04, 0.156E+03, 0.300E+02, 0.97970000E+00, 0.00000000E+00,
  0.12954563E+04, 0.156E+03, 0.310E+02, 0.97970000E+00, 0.00000000E+00,
  0.10627315E+04, 0.156E+03, 0.320E+02, 0.97970000E+00, 0.00000000E+00,
  0.85391570E+03, 0.156E+03, 0.330E+02, 0.97970000E+00, 0.00000000E+00,
  0.74014960E+03, 0.156E+03, 0.340E+02, 0.97970000E+00, 0.00000000E+00,
  0.62555040E+03, 0.156E+03, 0.350E+02, 0.97970000E+00, 0.00000000E+00,
  0.52735210E+03, 0.156E+03, 0.360E+02, 0.97970000E+00, 0.00000000E+00,
  0.49979230E+04, 0.156E+03, 0.370E+02, 0.97970000E+00, 0.00000000E+00,
  0.36976569E+04, 0.156E+03, 0.380E+02, 0.97970000E+00, 0.00000000E+00,
  0.30451620E+04, 0.156E+03, 0.390E+02, 0.97970000E+00, 0.00000000E+00,
  0.26376782E+04, 0.156E+03, 0.400E+02, 0.97970000E+00, 0.00000000E+00,
  0.23521278E+04, 0.156E+03, 0.410E+02, 0.97970000E+00, 0.00000000E+00,
  0.17503829E+04, 0.156E+03, 0.420E+02, 0.97970000E+00, 0.00000000E+00,
  0.19809508E+04, 0.156E+03, 0.430E+02, 0.97970000E+00, 0.00000000E+00,
  0.14476221E+04, 0.156E+03, 0.440E+02, 0.97970000E+00, 0.00000000E+00,
  0.15723023E+04, 0.156E+03, 0.450E+02, 0.97970000E+00, 0.00000000E+00,
  0.14360400E+04, 0.156E+03, 0.460E+02, 0.97970000E+00, 0.00000000E+00,
  0.12194904E+04, 0.156E+03, 0.470E+02, 0.97970000E+00, 0.00000000E+00,
  0.12412980E+04, 0.156E+03, 0.480E+02, 0.97970000E+00, 0.00000000E+00,
  0.16356158E+04, 0.156E+03, 0.490E+02, 0.97970000E+00, 0.00000000E+00,
  0.14200022E+04, 0.156E+03, 0.500E+02, 0.97970000E+00, 0.00000000E+00,
  0.11973790E+04, 0.156E+03, 0.510E+02, 0.97970000E+00, 0.00000000E+00,
  0.10767503E+04, 0.156E+03, 0.520E+02, 0.97970000E+00, 0.00000000E+00,
  0.94225240E+03, 0.156E+03, 0.530E+02, 0.97970000E+00, 0.00000000E+00,
  0.82205680E+03, 0.156E+03, 0.540E+02, 0.97970000E+00, 0.00000000E+00,
  0.61419784E+04, 0.156E+03, 0.550E+02, 0.97970000E+00, 0.00000000E+00,
  0.48451776E+04, 0.156E+03, 0.560E+02, 0.97970000E+00, 0.00000000E+00,
  0.39942273E+04, 0.156E+03, 0.570E+02, 0.97970000E+00, 0.00000000E+00,
  0.14330469E+04, 0.156E+03, 0.580E+02, 0.97970000E+00, 0.27991000E+01,
  0.42139225E+04, 0.156E+03, 0.590E+02, 0.97970000E+00, 0.00000000E+00,
  0.39873600E+04, 0.156E+03, 0.600E+02, 0.97970000E+00, 0.00000000E+00,
  0.38737284E+04, 0.156E+03, 0.610E+02, 0.97970000E+00, 0.00000000E+00,
  0.37706523E+04, 0.156E+03, 0.620E+02, 0.97970000E+00, 0.00000000E+00,
  0.36789146E+04, 0.156E+03, 0.630E+02, 0.97970000E+00, 0.00000000E+00,
  0.27207653E+04, 0.156E+03, 0.640E+02, 0.97970000E+00, 0.00000000E+00,
  0.34419852E+04, 0.156E+03, 0.650E+02, 0.97970000E+00, 0.00000000E+00,
  0.32989422E+04, 0.156E+03, 0.660E+02, 0.97970000E+00, 0.00000000E+00,
  0.32598698E+04, 0.156E+03, 0.670E+02, 0.97970000E+00, 0.00000000E+00,
  0.31836011E+04, 0.156E+03, 0.680E+02, 0.97970000E+00, 0.00000000E+00,
  0.31125536E+04, 0.156E+03, 0.690E+02, 0.97970000E+00, 0.00000000E+00,
  0.30835002E+04, 0.156E+03, 0.700E+02, 0.97970000E+00, 0.00000000E+00,
  0.25019262E+04, 0.156E+03, 0.710E+02, 0.97970000E+00, 0.00000000E+00,
  0.22987008E+04, 0.156E+03, 0.720E+02, 0.97970000E+00, 0.00000000E+00,
  0.20237991E+04, 0.156E+03, 0.730E+02, 0.97970000E+00, 0.00000000E+00,
  0.16732640E+04, 0.156E+03, 0.740E+02, 0.97970000E+00, 0.00000000E+00,
  0.16751136E+04, 0.156E+03, 0.750E+02, 0.97970000E+00, 0.00000000E+00,
  0.14722933E+04, 0.156E+03, 0.760E+02, 0.97970000E+00, 0.00000000E+00,
  0.13162117E+04, 0.156E+03, 0.770E+02, 0.97970000E+00, 0.00000000E+00,
  0.10706911E+04, 0.156E+03, 0.780E+02, 0.97970000E+00, 0.00000000E+00,
  0.99139190E+03, 0.156E+03, 0.790E+02, 0.97970000E+00, 0.00000000E+00,
  0.10048014E+04, 0.156E+03, 0.800E+02, 0.97970000E+00, 0.00000000E+00,
  0.16688986E+04, 0.156E+03, 0.810E+02, 0.97970000E+00, 0.00000000E+00,
  0.15461030E+04, 0.156E+03, 0.820E+02, 0.97970000E+00, 0.00000000E+00,
  0.13487488E+04, 0.156E+03, 0.830E+02, 0.97970000E+00, 0.00000000E+00,
  0.12508513E+04, 0.156E+03, 0.840E+02, 0.97970000E+00, 0.00000000E+00,
  0.11176702E+04, 0.156E+03, 0.850E+02, 0.97970000E+00, 0.00000000E+00,
  0.99586790E+03, 0.156E+03, 0.860E+02, 0.97970000E+00, 0.00000000E+00,
  0.54979393E+04, 0.156E+03, 0.870E+02, 0.97970000E+00, 0.00000000E+00,
  0.46433162E+04, 0.156E+03, 0.880E+02, 0.97970000E+00, 0.00000000E+00,
  0.38656041E+04, 0.156E+03, 0.890E+02, 0.97970000E+00, 0.00000000E+00,
  0.32597257E+04, 0.156E+03, 0.900E+02, 0.97970000E+00, 0.00000000E+00,
  0.33538826E+04, 0.156E+03, 0.910E+02, 0.97970000E+00, 0.00000000E+00,
  0.32402913E+04, 0.156E+03, 0.920E+02, 0.97970000E+00, 0.00000000E+00,
  0.34630576E+04, 0.156E+03, 0.930E+02, 0.97970000E+00, 0.00000000E+00,
  0.33272478E+04, 0.156E+03, 0.940E+02, 0.97970000E+00, 0.00000000E+00,
  0.14256800E+03, 0.156E+03, 0.101E+03, 0.97970000E+00, 0.00000000E+00,
  0.55107920E+03, 0.156E+03, 0.103E+03, 0.97970000E+00, 0.98650000E+00,
  0.69284150E+03, 0.156E+03, 0.104E+03, 0.97970000E+00, 0.98080000E+00,
  0.47105030E+03, 0.156E+03, 0.105E+03, 0.97970000E+00, 0.97060000E+00,
  0.33492070E+03, 0.156E+03, 0.106E+03, 0.97970000E+00, 0.98680000E+00,
  0.21815960E+03, 0.156E+03, 0.107E+03, 0.97970000E+00, 0.99440000E+00,
  0.15070560E+03, 0.156E+03, 0.108E+03, 0.97970000E+00, 0.99250000E+00,
  0.97192600E+02, 0.156E+03, 0.109E+03, 0.97970000E+00, 0.99820000E+00,
  0.82695650E+03, 0.156E+03, 0.111E+03, 0.97970000E+00, 0.96840000E+00,
  0.12989425E+04, 0.156E+03, 0.112E+03, 0.97970000E+00, 0.96280000E+00,
  0.12335817E+04, 0.156E+03, 0.113E+03, 0.97970000E+00, 0.96480000E+00,
  0.90965670E+03, 0.156E+03, 0.114E+03, 0.97970000E+00, 0.95070000E+00,
  0.70099830E+03, 0.156E+03, 0.115E+03, 0.97970000E+00, 0.99470000E+00,
  0.56985090E+03, 0.156E+03, 0.116E+03, 0.97970000E+00, 0.99480000E+00,
  0.44736800E+03, 0.156E+03, 0.117E+03, 0.97970000E+00, 0.99720000E+00,
  0.11041068E+04, 0.156E+03, 0.119E+03, 0.97970000E+00, 0.97670000E+00,
  0.25056537E+04, 0.156E+03, 0.120E+03, 0.97970000E+00, 0.98310000E+00,
  0.10130298E+04, 0.156E+03, 0.121E+03, 0.97970000E+00, 0.18627000E+01,
  0.98236380E+03, 0.156E+03, 0.122E+03, 0.97970000E+00, 0.18299000E+01,
  0.96327250E+03, 0.156E+03, 0.123E+03, 0.97970000E+00, 0.19138000E+01,
  0.96365340E+03, 0.156E+03, 0.124E+03, 0.97970000E+00, 0.18269000E+01,
  0.84521190E+03, 0.156E+03, 0.125E+03, 0.97970000E+00, 0.16406000E+01,
  0.77366980E+03, 0.156E+03, 0.126E+03, 0.97970000E+00, 0.16483000E+01,
  0.73950900E+03, 0.156E+03, 0.127E+03, 0.97970000E+00, 0.17149000E+01,
  0.72552030E+03, 0.156E+03, 0.128E+03, 0.97970000E+00, 0.17937000E+01,
  0.74098720E+03, 0.156E+03, 0.129E+03, 0.97970000E+00, 0.95760000E+00,
  0.65373360E+03, 0.156E+03, 0.130E+03, 0.97970000E+00, 0.19419000E+01,
  0.11948773E+04, 0.156E+03, 0.131E+03, 0.97970000E+00, 0.96010000E+00,
  0.97957420E+03, 0.156E+03, 0.132E+03, 0.97970000E+00, 0.94340000E+00,
  0.83693640E+03, 0.156E+03, 0.133E+03, 0.97970000E+00, 0.98890000E+00,
  0.74102200E+03, 0.156E+03, 0.134E+03, 0.97970000E+00, 0.99010000E+00,
  0.63113970E+03, 0.156E+03, 0.135E+03, 0.97970000E+00, 0.99740000E+00,
  0.13013999E+04, 0.156E+03, 0.137E+03, 0.97970000E+00, 0.97380000E+00,
  0.30957594E+04, 0.156E+03, 0.138E+03, 0.97970000E+00, 0.98010000E+00,
  0.21010372E+04, 0.156E+03, 0.139E+03, 0.97970000E+00, 0.19153000E+01,
  0.13604000E+04, 0.156E+03, 0.140E+03, 0.97970000E+00, 0.19355000E+01,
  0.13693825E+04, 0.156E+03, 0.141E+03, 0.97970000E+00, 0.19545000E+01,
  0.12660803E+04, 0.156E+03, 0.142E+03, 0.97970000E+00, 0.19420000E+01,
  0.15162134E+04, 0.156E+03, 0.143E+03, 0.97970000E+00, 0.16682000E+01,
  0.10564422E+04, 0.156E+03, 0.144E+03, 0.97970000E+00, 0.18584000E+01,
  0.98676430E+03, 0.156E+03, 0.145E+03, 0.97970000E+00, 0.19003000E+01,
  0.91052680E+03, 0.156E+03, 0.146E+03, 0.97970000E+00, 0.18630000E+01,
  0.88540390E+03, 0.156E+03, 0.147E+03, 0.97970000E+00, 0.96790000E+00,
  0.84515800E+03, 0.156E+03, 0.148E+03, 0.97970000E+00, 0.19539000E+01,
  0.15259278E+04, 0.156E+03, 0.149E+03, 0.97970000E+00, 0.96330000E+00,
  0.12966408E+04, 0.156E+03, 0.150E+03, 0.97970000E+00, 0.95140000E+00,
  0.11653603E+04, 0.156E+03, 0.151E+03, 0.97970000E+00, 0.97490000E+00,
  0.10738698E+04, 0.156E+03, 0.152E+03, 0.97970000E+00, 0.98110000E+00,
  0.95154100E+03, 0.156E+03, 0.153E+03, 0.97970000E+00, 0.99680000E+00,
  0.14690705E+04, 0.156E+03, 0.155E+03, 0.97970000E+00, 0.99090000E+00,
  0.41717842E+04, 0.156E+03, 0.156E+03, 0.97970000E+00, 0.97970000E+00,
  0.64690600E+02, 0.157E+03, 0.100E+01, 0.19373000E+01, 0.91180000E+00,
  0.40332900E+02, 0.157E+03, 0.200E+01, 0.19373000E+01, 0.00000000E+00,
  0.13841283E+04, 0.157E+03, 0.300E+01, 0.19373000E+01, 0.00000000E+00,
  0.67673740E+03, 0.157E+03, 0.400E+01, 0.19373000E+01, 0.00000000E+00,
  0.42308150E+03, 0.157E+03, 0.500E+01, 0.19373000E+01, 0.00000000E+00,
  0.27142480E+03, 0.157E+03, 0.600E+01, 0.19373000E+01, 0.00000000E+00,
  0.18293910E+03, 0.157E+03, 0.700E+01, 0.19373000E+01, 0.00000000E+00,
  0.13503220E+03, 0.157E+03, 0.800E+01, 0.19373000E+01, 0.00000000E+00,
  0.10010900E+03, 0.157E+03, 0.900E+01, 0.19373000E+01, 0.00000000E+00,
  0.75679100E+02, 0.157E+03, 0.100E+02, 0.19373000E+01, 0.00000000E+00,
  0.16377878E+04, 0.157E+03, 0.110E+02, 0.19373000E+01, 0.00000000E+00,
  0.11067221E+04, 0.157E+03, 0.120E+02, 0.19373000E+01, 0.00000000E+00,
  0.98043760E+03, 0.157E+03, 0.130E+02, 0.19373000E+01, 0.00000000E+00,
  0.73212110E+03, 0.157E+03, 0.140E+02, 0.19373000E+01, 0.00000000E+00,
  0.54746530E+03, 0.157E+03, 0.150E+02, 0.19373000E+01, 0.00000000E+00,
  0.44287990E+03, 0.157E+03, 0.160E+02, 0.19373000E+01, 0.00000000E+00,
  0.35314670E+03, 0.157E+03, 0.170E+02, 0.19373000E+01, 0.00000000E+00,
  0.28303510E+03, 0.157E+03, 0.180E+02, 0.19373000E+01, 0.00000000E+00,
  0.28009569E+04, 0.157E+03, 0.190E+02, 0.19373000E+01, 0.00000000E+00,
  0.20504253E+04, 0.157E+03, 0.200E+02, 0.19373000E+01, 0.00000000E+00,
  0.16557011E+04, 0.157E+03, 0.210E+02, 0.19373000E+01, 0.00000000E+00,
  0.15712363E+04, 0.157E+03, 0.220E+02, 0.19373000E+01, 0.00000000E+00,
  0.14231173E+04, 0.157E+03, 0.230E+02, 0.19373000E+01, 0.00000000E+00,
  0.11226576E+04, 0.157E+03, 0.240E+02, 0.19373000E+01, 0.00000000E+00,
  0.12061393E+04, 0.157E+03, 0.250E+02, 0.19373000E+01, 0.00000000E+00,
  0.94568080E+03, 0.157E+03, 0.260E+02, 0.19373000E+01, 0.00000000E+00,
  0.97598360E+03, 0.157E+03, 0.270E+02, 0.19373000E+01, 0.00000000E+00,
  0.10161745E+04, 0.157E+03, 0.280E+02, 0.19373000E+01, 0.00000000E+00,
  0.78128810E+03, 0.157E+03, 0.290E+02, 0.19373000E+01, 0.00000000E+00,
  0.77266500E+03, 0.157E+03, 0.300E+02, 0.19373000E+01, 0.00000000E+00,
  0.92637230E+03, 0.157E+03, 0.310E+02, 0.19373000E+01, 0.00000000E+00,
  0.78274010E+03, 0.157E+03, 0.320E+02, 0.19373000E+01, 0.00000000E+00,
  0.64435600E+03, 0.157E+03, 0.330E+02, 0.19373000E+01, 0.00000000E+00,
  0.56629200E+03, 0.157E+03, 0.340E+02, 0.19373000E+01, 0.00000000E+00,
  0.48529550E+03, 0.157E+03, 0.350E+02, 0.19373000E+01, 0.00000000E+00,
  0.41416640E+03, 0.157E+03, 0.360E+02, 0.19373000E+01, 0.00000000E+00,
  0.31215559E+04, 0.157E+03, 0.370E+02, 0.19373000E+01, 0.00000000E+00,
  0.24580845E+04, 0.157E+03, 0.380E+02, 0.19373000E+01, 0.00000000E+00,
  0.20727978E+04, 0.157E+03, 0.390E+02, 0.19373000E+01, 0.00000000E+00,
  0.18212145E+04, 0.157E+03, 0.400E+02, 0.19373000E+01, 0.00000000E+00,
  0.16379243E+04, 0.157E+03, 0.410E+02, 0.19373000E+01, 0.00000000E+00,
  0.12356226E+04, 0.157E+03, 0.420E+02, 0.19373000E+01, 0.00000000E+00,
  0.13909989E+04, 0.157E+03, 0.430E+02, 0.19373000E+01, 0.00000000E+00,
  0.10325864E+04, 0.157E+03, 0.440E+02, 0.19373000E+01, 0.00000000E+00,
  0.11254492E+04, 0.157E+03, 0.450E+02, 0.19373000E+01, 0.00000000E+00,
  0.10341628E+04, 0.157E+03, 0.460E+02, 0.19373000E+01, 0.00000000E+00,
  0.87041020E+03, 0.157E+03, 0.470E+02, 0.19373000E+01, 0.00000000E+00,
  0.90076730E+03, 0.157E+03, 0.480E+02, 0.19373000E+01, 0.00000000E+00,
  0.11640480E+04, 0.157E+03, 0.490E+02, 0.19373000E+01, 0.00000000E+00,
  0.10373050E+04, 0.157E+03, 0.500E+02, 0.19373000E+01, 0.00000000E+00,
  0.89470260E+03, 0.157E+03, 0.510E+02, 0.19373000E+01, 0.00000000E+00,
  0.81481140E+03, 0.157E+03, 0.520E+02, 0.19373000E+01, 0.00000000E+00,
  0.72249320E+03, 0.157E+03, 0.530E+02, 0.19373000E+01, 0.00000000E+00,
  0.63795900E+03, 0.157E+03, 0.540E+02, 0.19373000E+01, 0.00000000E+00,
  0.38250881E+04, 0.157E+03, 0.550E+02, 0.19373000E+01, 0.00000000E+00,
  0.31862921E+04, 0.157E+03, 0.560E+02, 0.19373000E+01, 0.00000000E+00,
  0.26909591E+04, 0.157E+03, 0.570E+02, 0.19373000E+01, 0.00000000E+00,
  0.10645933E+04, 0.157E+03, 0.580E+02, 0.19373000E+01, 0.27991000E+01,
  0.27909891E+04, 0.157E+03, 0.590E+02, 0.19373000E+01, 0.00000000E+00,
  0.26551171E+04, 0.157E+03, 0.600E+02, 0.19373000E+01, 0.00000000E+00,
  0.25829722E+04, 0.157E+03, 0.610E+02, 0.19373000E+01, 0.00000000E+00,
  0.25172239E+04, 0.157E+03, 0.620E+02, 0.19373000E+01, 0.00000000E+00,
  0.24587886E+04, 0.157E+03, 0.630E+02, 0.19373000E+01, 0.00000000E+00,
  0.18607370E+04, 0.157E+03, 0.640E+02, 0.19373000E+01, 0.00000000E+00,
  0.22509654E+04, 0.157E+03, 0.650E+02, 0.19373000E+01, 0.00000000E+00,
  0.21634599E+04, 0.157E+03, 0.660E+02, 0.19373000E+01, 0.00000000E+00,
  0.21938636E+04, 0.157E+03, 0.670E+02, 0.19373000E+01, 0.00000000E+00,
  0.21444704E+04, 0.157E+03, 0.680E+02, 0.19373000E+01, 0.00000000E+00,
  0.20989702E+04, 0.157E+03, 0.690E+02, 0.19373000E+01, 0.00000000E+00,
  0.20775774E+04, 0.157E+03, 0.700E+02, 0.19373000E+01, 0.00000000E+00,
  0.17103545E+04, 0.157E+03, 0.710E+02, 0.19373000E+01, 0.00000000E+00,
  0.16140907E+04, 0.157E+03, 0.720E+02, 0.19373000E+01, 0.00000000E+00,
  0.14413394E+04, 0.157E+03, 0.730E+02, 0.19373000E+01, 0.00000000E+00,
  0.12005662E+04, 0.157E+03, 0.740E+02, 0.19373000E+01, 0.00000000E+00,
  0.12100818E+04, 0.157E+03, 0.750E+02, 0.19373000E+01, 0.00000000E+00,
  0.10767583E+04, 0.157E+03, 0.760E+02, 0.19373000E+01, 0.00000000E+00,
  0.97197370E+03, 0.157E+03, 0.770E+02, 0.19373000E+01, 0.00000000E+00,
  0.79670010E+03, 0.157E+03, 0.780E+02, 0.19373000E+01, 0.00000000E+00,
  0.74016750E+03, 0.157E+03, 0.790E+02, 0.19373000E+01, 0.00000000E+00,
  0.75524870E+03, 0.157E+03, 0.800E+02, 0.19373000E+01, 0.00000000E+00,
  0.11891662E+04, 0.157E+03, 0.810E+02, 0.19373000E+01, 0.00000000E+00,
  0.11270513E+04, 0.157E+03, 0.820E+02, 0.19373000E+01, 0.00000000E+00,
  0.10045839E+04, 0.157E+03, 0.830E+02, 0.19373000E+01, 0.00000000E+00,
  0.94243520E+03, 0.157E+03, 0.840E+02, 0.19373000E+01, 0.00000000E+00,
  0.85327010E+03, 0.157E+03, 0.850E+02, 0.19373000E+01, 0.00000000E+00,
  0.76899820E+03, 0.157E+03, 0.860E+02, 0.19373000E+01, 0.00000000E+00,
  0.34855386E+04, 0.157E+03, 0.870E+02, 0.19373000E+01, 0.00000000E+00,
  0.30892071E+04, 0.157E+03, 0.880E+02, 0.19373000E+01, 0.00000000E+00,
  0.26322561E+04, 0.157E+03, 0.890E+02, 0.19373000E+01, 0.00000000E+00,
  0.22749680E+04, 0.157E+03, 0.900E+02, 0.19373000E+01, 0.00000000E+00,
  0.23071665E+04, 0.157E+03, 0.910E+02, 0.19373000E+01, 0.00000000E+00,
  0.22309267E+04, 0.157E+03, 0.920E+02, 0.19373000E+01, 0.00000000E+00,
  0.23502253E+04, 0.157E+03, 0.930E+02, 0.19373000E+01, 0.00000000E+00,
  0.22650122E+04, 0.157E+03, 0.940E+02, 0.19373000E+01, 0.00000000E+00,
  0.10830590E+03, 0.157E+03, 0.101E+03, 0.19373000E+01, 0.00000000E+00,
  0.38990700E+03, 0.157E+03, 0.103E+03, 0.19373000E+01, 0.98650000E+00,
  0.49258240E+03, 0.157E+03, 0.104E+03, 0.19373000E+01, 0.98080000E+00,
  0.35111660E+03, 0.157E+03, 0.105E+03, 0.19373000E+01, 0.97060000E+00,
  0.25535340E+03, 0.157E+03, 0.106E+03, 0.19373000E+01, 0.98680000E+00,
  0.17069380E+03, 0.157E+03, 0.107E+03, 0.19373000E+01, 0.99440000E+00,
  0.12040040E+03, 0.157E+03, 0.108E+03, 0.19373000E+01, 0.99250000E+00,
  0.79615100E+02, 0.157E+03, 0.109E+03, 0.19373000E+01, 0.99820000E+00,
  0.57870070E+03, 0.157E+03, 0.111E+03, 0.19373000E+01, 0.96840000E+00,
  0.90345630E+03, 0.157E+03, 0.112E+03, 0.19373000E+01, 0.96280000E+00,
  0.88049000E+03, 0.157E+03, 0.113E+03, 0.19373000E+01, 0.96480000E+00,
  0.67215910E+03, 0.157E+03, 0.114E+03, 0.19373000E+01, 0.95070000E+00,
  0.53085730E+03, 0.157E+03, 0.115E+03, 0.19373000E+01, 0.99470000E+00,
  0.43834960E+03, 0.157E+03, 0.116E+03, 0.19373000E+01, 0.99480000E+00,
  0.34967640E+03, 0.157E+03, 0.117E+03, 0.19373000E+01, 0.99720000E+00,
  0.78068060E+03, 0.157E+03, 0.119E+03, 0.19373000E+01, 0.97670000E+00,
  0.16583459E+04, 0.157E+03, 0.120E+03, 0.19373000E+01, 0.98310000E+00,
  0.74263980E+03, 0.157E+03, 0.121E+03, 0.19373000E+01, 0.18627000E+01,
  0.71867820E+03, 0.157E+03, 0.122E+03, 0.19373000E+01, 0.18299000E+01,
  0.70447310E+03, 0.157E+03, 0.123E+03, 0.19373000E+01, 0.19138000E+01,
  0.70187680E+03, 0.157E+03, 0.124E+03, 0.19373000E+01, 0.18269000E+01,
  0.62823400E+03, 0.157E+03, 0.125E+03, 0.19373000E+01, 0.16406000E+01,
  0.57752630E+03, 0.157E+03, 0.126E+03, 0.19373000E+01, 0.16483000E+01,
  0.55142260E+03, 0.157E+03, 0.127E+03, 0.19373000E+01, 0.17149000E+01,
  0.54016790E+03, 0.157E+03, 0.128E+03, 0.19373000E+01, 0.17937000E+01,
  0.54406610E+03, 0.157E+03, 0.129E+03, 0.19373000E+01, 0.95760000E+00,
  0.49263420E+03, 0.157E+03, 0.130E+03, 0.19373000E+01, 0.19419000E+01,
  0.86066320E+03, 0.157E+03, 0.131E+03, 0.19373000E+01, 0.96010000E+00,
  0.72574740E+03, 0.157E+03, 0.132E+03, 0.19373000E+01, 0.94340000E+00,
  0.63226020E+03, 0.157E+03, 0.133E+03, 0.19373000E+01, 0.98890000E+00,
  0.56675130E+03, 0.157E+03, 0.134E+03, 0.19373000E+01, 0.99010000E+00,
  0.48922910E+03, 0.157E+03, 0.135E+03, 0.19373000E+01, 0.99740000E+00,
  0.92422030E+03, 0.157E+03, 0.137E+03, 0.19373000E+01, 0.97380000E+00,
  0.20365362E+04, 0.157E+03, 0.138E+03, 0.19373000E+01, 0.98010000E+00,
  0.14462394E+04, 0.157E+03, 0.139E+03, 0.19373000E+01, 0.19153000E+01,
  0.99010590E+03, 0.157E+03, 0.140E+03, 0.19373000E+01, 0.19355000E+01,
  0.99792220E+03, 0.157E+03, 0.141E+03, 0.19373000E+01, 0.19545000E+01,
  0.92583590E+03, 0.157E+03, 0.142E+03, 0.19373000E+01, 0.19420000E+01,
  0.10787908E+04, 0.157E+03, 0.143E+03, 0.19373000E+01, 0.16682000E+01,
  0.78658860E+03, 0.157E+03, 0.144E+03, 0.19373000E+01, 0.18584000E+01,
  0.73489180E+03, 0.157E+03, 0.145E+03, 0.19373000E+01, 0.19003000E+01,
  0.67965720E+03, 0.157E+03, 0.146E+03, 0.19373000E+01, 0.18630000E+01,
  0.65947100E+03, 0.157E+03, 0.147E+03, 0.19373000E+01, 0.96790000E+00,
  0.63938320E+03, 0.157E+03, 0.148E+03, 0.19373000E+01, 0.19539000E+01,
  0.10954590E+04, 0.157E+03, 0.149E+03, 0.19373000E+01, 0.96330000E+00,
  0.95522580E+03, 0.157E+03, 0.150E+03, 0.19373000E+01, 0.95140000E+00,
  0.87322870E+03, 0.157E+03, 0.151E+03, 0.19373000E+01, 0.97490000E+00,
  0.81328280E+03, 0.157E+03, 0.152E+03, 0.19373000E+01, 0.98110000E+00,
  0.72949490E+03, 0.157E+03, 0.153E+03, 0.19373000E+01, 0.99680000E+00,
  0.10633274E+04, 0.157E+03, 0.155E+03, 0.19373000E+01, 0.99090000E+00,
  0.27055816E+04, 0.157E+03, 0.156E+03, 0.19373000E+01, 0.97970000E+00,
  0.18500003E+04, 0.157E+03, 0.157E+03, 0.19373000E+01, 0.19373000E+01,
  0.43220200E+02, 0.159E+03, 0.100E+01, 0.29425000E+01, 0.91180000E+00,
  0.28506000E+02, 0.159E+03, 0.200E+01, 0.29425000E+01, 0.00000000E+00,
  0.68024790E+03, 0.159E+03, 0.300E+01, 0.29425000E+01, 0.00000000E+00,
  0.39079830E+03, 0.159E+03, 0.400E+01, 0.29425000E+01, 0.00000000E+00,
  0.26231920E+03, 0.159E+03, 0.500E+01, 0.29425000E+01, 0.00000000E+00,
  0.17683390E+03, 0.159E+03, 0.600E+01, 0.29425000E+01, 0.00000000E+00,
  0.12349550E+03, 0.159E+03, 0.700E+01, 0.29425000E+01, 0.00000000E+00,
  0.93432700E+02, 0.159E+03, 0.800E+01, 0.29425000E+01, 0.00000000E+00,
  0.70748100E+02, 0.159E+03, 0.900E+01, 0.29425000E+01, 0.00000000E+00,
  0.54406100E+02, 0.159E+03, 0.100E+02, 0.29425000E+01, 0.00000000E+00,
  0.81323530E+03, 0.159E+03, 0.110E+02, 0.29425000E+01, 0.00000000E+00,
  0.62332230E+03, 0.159E+03, 0.120E+02, 0.29425000E+01, 0.00000000E+00,
  0.57359020E+03, 0.159E+03, 0.130E+02, 0.29425000E+01, 0.00000000E+00,
  0.45092530E+03, 0.159E+03, 0.140E+02, 0.29425000E+01, 0.00000000E+00,
  0.35095780E+03, 0.159E+03, 0.150E+02, 0.29425000E+01, 0.00000000E+00,
  0.29093690E+03, 0.159E+03, 0.160E+02, 0.29425000E+01, 0.00000000E+00,
  0.23740720E+03, 0.159E+03, 0.170E+02, 0.29425000E+01, 0.00000000E+00,
  0.19406980E+03, 0.159E+03, 0.180E+02, 0.29425000E+01, 0.00000000E+00,
  0.13337958E+04, 0.159E+03, 0.190E+02, 0.29425000E+01, 0.00000000E+00,
  0.10971659E+04, 0.159E+03, 0.200E+02, 0.29425000E+01, 0.00000000E+00,
  0.90572410E+03, 0.159E+03, 0.210E+02, 0.29425000E+01, 0.00000000E+00,
  0.87400660E+03, 0.159E+03, 0.220E+02, 0.29425000E+01, 0.00000000E+00,
  0.80001520E+03, 0.159E+03, 0.230E+02, 0.29425000E+01, 0.00000000E+00,
  0.63019610E+03, 0.159E+03, 0.240E+02, 0.29425000E+01, 0.00000000E+00,
  0.68836930E+03, 0.159E+03, 0.250E+02, 0.29425000E+01, 0.00000000E+00,
  0.54023110E+03, 0.159E+03, 0.260E+02, 0.29425000E+01, 0.00000000E+00,
  0.57207380E+03, 0.159E+03, 0.270E+02, 0.29425000E+01, 0.00000000E+00,
  0.58956950E+03, 0.159E+03, 0.280E+02, 0.29425000E+01, 0.00000000E+00,
  0.45203420E+03, 0.159E+03, 0.290E+02, 0.29425000E+01, 0.00000000E+00,
  0.46341480E+03, 0.159E+03, 0.300E+02, 0.29425000E+01, 0.00000000E+00,
  0.54906920E+03, 0.159E+03, 0.310E+02, 0.29425000E+01, 0.00000000E+00,
  0.48331740E+03, 0.159E+03, 0.320E+02, 0.29425000E+01, 0.00000000E+00,
  0.41155330E+03, 0.159E+03, 0.330E+02, 0.29425000E+01, 0.00000000E+00,
  0.36892060E+03, 0.159E+03, 0.340E+02, 0.29425000E+01, 0.00000000E+00,
  0.32252720E+03, 0.159E+03, 0.350E+02, 0.29425000E+01, 0.00000000E+00,
  0.28024380E+03, 0.159E+03, 0.360E+02, 0.29425000E+01, 0.00000000E+00,
  0.14944074E+04, 0.159E+03, 0.370E+02, 0.29425000E+01, 0.00000000E+00,
  0.13073665E+04, 0.159E+03, 0.380E+02, 0.29425000E+01, 0.00000000E+00,
  0.11435524E+04, 0.159E+03, 0.390E+02, 0.29425000E+01, 0.00000000E+00,
  0.10268226E+04, 0.159E+03, 0.400E+02, 0.29425000E+01, 0.00000000E+00,
  0.93574670E+03, 0.159E+03, 0.410E+02, 0.29425000E+01, 0.00000000E+00,
  0.72166730E+03, 0.159E+03, 0.420E+02, 0.29425000E+01, 0.00000000E+00,
  0.80551110E+03, 0.159E+03, 0.430E+02, 0.29425000E+01, 0.00000000E+00,
  0.61296820E+03, 0.159E+03, 0.440E+02, 0.29425000E+01, 0.00000000E+00,
  0.66999170E+03, 0.159E+03, 0.450E+02, 0.29425000E+01, 0.00000000E+00,
  0.62106870E+03, 0.159E+03, 0.460E+02, 0.29425000E+01, 0.00000000E+00,
  0.51802070E+03, 0.159E+03, 0.470E+02, 0.29425000E+01, 0.00000000E+00,
  0.54699380E+03, 0.159E+03, 0.480E+02, 0.29425000E+01, 0.00000000E+00,
  0.68726670E+03, 0.159E+03, 0.490E+02, 0.29425000E+01, 0.00000000E+00,
  0.63451560E+03, 0.159E+03, 0.500E+02, 0.29425000E+01, 0.00000000E+00,
  0.56457530E+03, 0.159E+03, 0.510E+02, 0.29425000E+01, 0.00000000E+00,
  0.52332050E+03, 0.159E+03, 0.520E+02, 0.29425000E+01, 0.00000000E+00,
  0.47270040E+03, 0.159E+03, 0.530E+02, 0.29425000E+01, 0.00000000E+00,
  0.42459150E+03, 0.159E+03, 0.540E+02, 0.29425000E+01, 0.00000000E+00,
  0.18204201E+04, 0.159E+03, 0.550E+02, 0.29425000E+01, 0.00000000E+00,
  0.16674685E+04, 0.159E+03, 0.560E+02, 0.29425000E+01, 0.00000000E+00,
  0.14628142E+04, 0.159E+03, 0.570E+02, 0.29425000E+01, 0.00000000E+00,
  0.66720180E+03, 0.159E+03, 0.580E+02, 0.29425000E+01, 0.27991000E+01,
  0.14767389E+04, 0.159E+03, 0.590E+02, 0.29425000E+01, 0.00000000E+00,
  0.14176855E+04, 0.159E+03, 0.600E+02, 0.29425000E+01, 0.00000000E+00,
  0.13820320E+04, 0.159E+03, 0.610E+02, 0.29425000E+01, 0.00000000E+00,
  0.13492524E+04, 0.159E+03, 0.620E+02, 0.29425000E+01, 0.00000000E+00,
  0.13201809E+04, 0.159E+03, 0.630E+02, 0.29425000E+01, 0.00000000E+00,
  0.10364403E+04, 0.159E+03, 0.640E+02, 0.29425000E+01, 0.00000000E+00,
  0.11696897E+04, 0.159E+03, 0.650E+02, 0.29425000E+01, 0.00000000E+00,
  0.11277999E+04, 0.159E+03, 0.660E+02, 0.29425000E+01, 0.00000000E+00,
  0.11902918E+04, 0.159E+03, 0.670E+02, 0.29425000E+01, 0.00000000E+00,
  0.11649825E+04, 0.159E+03, 0.680E+02, 0.29425000E+01, 0.00000000E+00,
  0.11421370E+04, 0.159E+03, 0.690E+02, 0.29425000E+01, 0.00000000E+00,
  0.11288548E+04, 0.159E+03, 0.700E+02, 0.29425000E+01, 0.00000000E+00,
  0.95004210E+03, 0.159E+03, 0.710E+02, 0.29425000E+01, 0.00000000E+00,
  0.93285060E+03, 0.159E+03, 0.720E+02, 0.29425000E+01, 0.00000000E+00,
  0.85051620E+03, 0.159E+03, 0.730E+02, 0.29425000E+01, 0.00000000E+00,
  0.71766720E+03, 0.159E+03, 0.740E+02, 0.29425000E+01, 0.00000000E+00,
  0.72982300E+03, 0.159E+03, 0.750E+02, 0.29425000E+01, 0.00000000E+00,
  0.66090480E+03, 0.159E+03, 0.760E+02, 0.29425000E+01, 0.00000000E+00,
  0.60487530E+03, 0.159E+03, 0.770E+02, 0.29425000E+01, 0.00000000E+00,
  0.50215100E+03, 0.159E+03, 0.780E+02, 0.29425000E+01, 0.00000000E+00,
  0.46904220E+03, 0.159E+03, 0.790E+02, 0.29425000E+01, 0.00000000E+00,
  0.48234510E+03, 0.159E+03, 0.800E+02, 0.29425000E+01, 0.00000000E+00,
  0.70537820E+03, 0.159E+03, 0.810E+02, 0.29425000E+01, 0.00000000E+00,
  0.68881010E+03, 0.159E+03, 0.820E+02, 0.29425000E+01, 0.00000000E+00,
  0.63203130E+03, 0.159E+03, 0.830E+02, 0.29425000E+01, 0.00000000E+00,
  0.60229480E+03, 0.159E+03, 0.840E+02, 0.29425000E+01, 0.00000000E+00,
  0.55531140E+03, 0.159E+03, 0.850E+02, 0.29425000E+01, 0.00000000E+00,
  0.50853060E+03, 0.159E+03, 0.860E+02, 0.29425000E+01, 0.00000000E+00,
  0.17169108E+04, 0.159E+03, 0.870E+02, 0.29425000E+01, 0.00000000E+00,
  0.16476121E+04, 0.159E+03, 0.880E+02, 0.29425000E+01, 0.00000000E+00,
  0.14543881E+04, 0.159E+03, 0.890E+02, 0.29425000E+01, 0.00000000E+00,
  0.13048970E+04, 0.159E+03, 0.900E+02, 0.29425000E+01, 0.00000000E+00,
  0.12966238E+04, 0.159E+03, 0.910E+02, 0.29425000E+01, 0.00000000E+00,
  0.12554359E+04, 0.159E+03, 0.920E+02, 0.29425000E+01, 0.00000000E+00,
  0.12939094E+04, 0.159E+03, 0.930E+02, 0.29425000E+01, 0.00000000E+00,
  0.12527870E+04, 0.159E+03, 0.940E+02, 0.29425000E+01, 0.00000000E+00,
  0.69734100E+02, 0.159E+03, 0.101E+03, 0.29425000E+01, 0.00000000E+00,
  0.22705790E+03, 0.159E+03, 0.103E+03, 0.29425000E+01, 0.98650000E+00,
  0.28944340E+03, 0.159E+03, 0.104E+03, 0.29425000E+01, 0.98080000E+00,
  0.22051700E+03, 0.159E+03, 0.105E+03, 0.29425000E+01, 0.97060000E+00,
  0.16588050E+03, 0.159E+03, 0.106E+03, 0.29425000E+01, 0.98680000E+00,
  0.11516050E+03, 0.159E+03, 0.107E+03, 0.29425000E+01, 0.99440000E+00,
  0.83776500E+02, 0.159E+03, 0.108E+03, 0.29425000E+01, 0.99250000E+00,
  0.57559900E+02, 0.159E+03, 0.109E+03, 0.29425000E+01, 0.99820000E+00,
  0.33214950E+03, 0.159E+03, 0.111E+03, 0.29425000E+01, 0.96840000E+00,
  0.51379560E+03, 0.159E+03, 0.112E+03, 0.29425000E+01, 0.96280000E+00,
  0.51961650E+03, 0.159E+03, 0.113E+03, 0.29425000E+01, 0.96480000E+00,
  0.41662720E+03, 0.159E+03, 0.114E+03, 0.29425000E+01, 0.95070000E+00,
  0.34064700E+03, 0.159E+03, 0.115E+03, 0.29425000E+01, 0.99470000E+00,
  0.28774490E+03, 0.159E+03, 0.116E+03, 0.29425000E+01, 0.99480000E+00,
  0.23495440E+03, 0.159E+03, 0.117E+03, 0.29425000E+01, 0.99720000E+00,
  0.45743380E+03, 0.159E+03, 0.119E+03, 0.29425000E+01, 0.97670000E+00,
  0.87755280E+03, 0.159E+03, 0.120E+03, 0.29425000E+01, 0.98310000E+00,
  0.45670870E+03, 0.159E+03, 0.121E+03, 0.29425000E+01, 0.18627000E+01,
  0.44087260E+03, 0.159E+03, 0.122E+03, 0.29425000E+01, 0.18299000E+01,
  0.43208390E+03, 0.159E+03, 0.123E+03, 0.29425000E+01, 0.19138000E+01,
  0.42819360E+03, 0.159E+03, 0.124E+03, 0.29425000E+01, 0.18269000E+01,
  0.39355560E+03, 0.159E+03, 0.125E+03, 0.29425000E+01, 0.16406000E+01,
  0.36411700E+03, 0.159E+03, 0.126E+03, 0.29425000E+01, 0.16483000E+01,
  0.34735660E+03, 0.159E+03, 0.127E+03, 0.29425000E+01, 0.17149000E+01,
  0.33962320E+03, 0.159E+03, 0.128E+03, 0.29425000E+01, 0.17937000E+01,
  0.33586060E+03, 0.159E+03, 0.129E+03, 0.29425000E+01, 0.95760000E+00,
  0.31461930E+03, 0.159E+03, 0.130E+03, 0.29425000E+01, 0.19419000E+01,
  0.51545120E+03, 0.159E+03, 0.131E+03, 0.29425000E+01, 0.96010000E+00,
  0.45195710E+03, 0.159E+03, 0.132E+03, 0.29425000E+01, 0.94340000E+00,
  0.40453400E+03, 0.159E+03, 0.133E+03, 0.29425000E+01, 0.98890000E+00,
  0.36906970E+03, 0.159E+03, 0.134E+03, 0.29425000E+01, 0.99010000E+00,
  0.32478940E+03, 0.159E+03, 0.135E+03, 0.29425000E+01, 0.99740000E+00,
  0.54559170E+03, 0.159E+03, 0.137E+03, 0.29425000E+01, 0.97380000E+00,
  0.10680684E+04, 0.159E+03, 0.138E+03, 0.29425000E+01, 0.98010000E+00,
  0.81406370E+03, 0.159E+03, 0.139E+03, 0.29425000E+01, 0.19153000E+01,
  0.60412500E+03, 0.159E+03, 0.140E+03, 0.29425000E+01, 0.19355000E+01,
  0.61013660E+03, 0.159E+03, 0.141E+03, 0.29425000E+01, 0.19545000E+01,
  0.56871480E+03, 0.159E+03, 0.142E+03, 0.29425000E+01, 0.19420000E+01,
  0.63873760E+03, 0.159E+03, 0.143E+03, 0.29425000E+01, 0.16682000E+01,
  0.49520560E+03, 0.159E+03, 0.144E+03, 0.29425000E+01, 0.18584000E+01,
  0.46324120E+03, 0.159E+03, 0.145E+03, 0.29425000E+01, 0.19003000E+01,
  0.43008630E+03, 0.159E+03, 0.146E+03, 0.29425000E+01, 0.18630000E+01,
  0.41612810E+03, 0.159E+03, 0.147E+03, 0.29425000E+01, 0.96790000E+00,
  0.41129410E+03, 0.159E+03, 0.148E+03, 0.29425000E+01, 0.19539000E+01,
  0.65474970E+03, 0.159E+03, 0.149E+03, 0.29425000E+01, 0.96330000E+00,
  0.59136710E+03, 0.159E+03, 0.150E+03, 0.29425000E+01, 0.95140000E+00,
  0.55320050E+03, 0.159E+03, 0.151E+03, 0.29425000E+01, 0.97490000E+00,
  0.52290670E+03, 0.159E+03, 0.152E+03, 0.29425000E+01, 0.98110000E+00,
  0.47714300E+03, 0.159E+03, 0.153E+03, 0.29425000E+01, 0.99680000E+00,
  0.64438580E+03, 0.159E+03, 0.155E+03, 0.29425000E+01, 0.99090000E+00,
  0.13856402E+04, 0.159E+03, 0.156E+03, 0.29425000E+01, 0.97970000E+00,
  0.10306163E+04, 0.159E+03, 0.157E+03, 0.29425000E+01, 0.19373000E+01,
  0.64702500E+03, 0.159E+03, 0.159E+03, 0.29425000E+01, 0.29425000E+01,
  0.42334300E+02, 0.160E+03, 0.100E+01, 0.29455000E+01, 0.91180000E+00,
  0.27932400E+02, 0.160E+03, 0.200E+01, 0.29455000E+01, 0.00000000E+00,
  0.66553290E+03, 0.160E+03, 0.300E+01, 0.29455000E+01, 0.00000000E+00,
  0.38257600E+03, 0.160E+03, 0.400E+01, 0.29455000E+01, 0.00000000E+00,
  0.25686460E+03, 0.160E+03, 0.500E+01, 0.29455000E+01, 0.00000000E+00,
  0.17319330E+03, 0.160E+03, 0.600E+01, 0.29455000E+01, 0.00000000E+00,
  0.12097590E+03, 0.160E+03, 0.700E+01, 0.29455000E+01, 0.00000000E+00,
  0.91540700E+02, 0.160E+03, 0.800E+01, 0.29455000E+01, 0.00000000E+00,
  0.69326100E+02, 0.160E+03, 0.900E+01, 0.29455000E+01, 0.00000000E+00,
  0.53320100E+02, 0.160E+03, 0.100E+02, 0.29455000E+01, 0.00000000E+00,
  0.79568730E+03, 0.160E+03, 0.110E+02, 0.29455000E+01, 0.00000000E+00,
  0.61016250E+03, 0.160E+03, 0.120E+02, 0.29455000E+01, 0.00000000E+00,
  0.56154980E+03, 0.160E+03, 0.130E+02, 0.29455000E+01, 0.00000000E+00,
  0.44153690E+03, 0.160E+03, 0.140E+02, 0.29455000E+01, 0.00000000E+00,
  0.34370190E+03, 0.160E+03, 0.150E+02, 0.29455000E+01, 0.00000000E+00,
  0.28495290E+03, 0.160E+03, 0.160E+02, 0.29455000E+01, 0.00000000E+00,
  0.23255130E+03, 0.160E+03, 0.170E+02, 0.29455000E+01, 0.00000000E+00,
  0.19012240E+03, 0.160E+03, 0.180E+02, 0.29455000E+01, 0.00000000E+00,
  0.13047563E+04, 0.160E+03, 0.190E+02, 0.29455000E+01, 0.00000000E+00,
  0.10738235E+04, 0.160E+03, 0.200E+02, 0.29455000E+01, 0.00000000E+00,
  0.88652660E+03, 0.160E+03, 0.210E+02, 0.29455000E+01, 0.00000000E+00,
  0.85553540E+03, 0.160E+03, 0.220E+02, 0.29455000E+01, 0.00000000E+00,
  0.78313860E+03, 0.160E+03, 0.230E+02, 0.29455000E+01, 0.00000000E+00,
  0.61691000E+03, 0.160E+03, 0.240E+02, 0.29455000E+01, 0.00000000E+00,
  0.67388620E+03, 0.160E+03, 0.250E+02, 0.29455000E+01, 0.00000000E+00,
  0.52887800E+03, 0.160E+03, 0.260E+02, 0.29455000E+01, 0.00000000E+00,
  0.56009170E+03, 0.160E+03, 0.270E+02, 0.29455000E+01, 0.00000000E+00,
  0.57719940E+03, 0.160E+03, 0.280E+02, 0.29455000E+01, 0.00000000E+00,
  0.44255790E+03, 0.160E+03, 0.290E+02, 0.29455000E+01, 0.00000000E+00,
  0.45374620E+03, 0.160E+03, 0.300E+02, 0.29455000E+01, 0.00000000E+00,
  0.53757900E+03, 0.160E+03, 0.310E+02, 0.29455000E+01, 0.00000000E+00,
  0.47326730E+03, 0.160E+03, 0.320E+02, 0.29455000E+01, 0.00000000E+00,
  0.40304410E+03, 0.160E+03, 0.330E+02, 0.29455000E+01, 0.00000000E+00,
  0.36132220E+03, 0.160E+03, 0.340E+02, 0.29455000E+01, 0.00000000E+00,
  0.31591320E+03, 0.160E+03, 0.350E+02, 0.29455000E+01, 0.00000000E+00,
  0.27452240E+03, 0.160E+03, 0.360E+02, 0.29455000E+01, 0.00000000E+00,
  0.14619055E+04, 0.160E+03, 0.370E+02, 0.29455000E+01, 0.00000000E+00,
  0.12795273E+04, 0.160E+03, 0.380E+02, 0.29455000E+01, 0.00000000E+00,
  0.11193527E+04, 0.160E+03, 0.390E+02, 0.29455000E+01, 0.00000000E+00,
  0.10051742E+04, 0.160E+03, 0.400E+02, 0.29455000E+01, 0.00000000E+00,
  0.91606480E+03, 0.160E+03, 0.410E+02, 0.29455000E+01, 0.00000000E+00,
  0.70655730E+03, 0.160E+03, 0.420E+02, 0.29455000E+01, 0.00000000E+00,
  0.78861510E+03, 0.160E+03, 0.430E+02, 0.29455000E+01, 0.00000000E+00,
  0.60017770E+03, 0.160E+03, 0.440E+02, 0.29455000E+01, 0.00000000E+00,
  0.65600920E+03, 0.160E+03, 0.450E+02, 0.29455000E+01, 0.00000000E+00,
  0.60812890E+03, 0.160E+03, 0.460E+02, 0.29455000E+01, 0.00000000E+00,
  0.50722690E+03, 0.160E+03, 0.470E+02, 0.29455000E+01, 0.00000000E+00,
  0.53562280E+03, 0.160E+03, 0.480E+02, 0.29455000E+01, 0.00000000E+00,
  0.67289960E+03, 0.160E+03, 0.490E+02, 0.29455000E+01, 0.00000000E+00,
  0.62132160E+03, 0.160E+03, 0.500E+02, 0.29455000E+01, 0.00000000E+00,
  0.55289340E+03, 0.160E+03, 0.510E+02, 0.29455000E+01, 0.00000000E+00,
  0.51252450E+03, 0.160E+03, 0.520E+02, 0.29455000E+01, 0.00000000E+00,
  0.46298250E+03, 0.160E+03, 0.530E+02, 0.29455000E+01, 0.00000000E+00,
  0.41589380E+03, 0.160E+03, 0.540E+02, 0.29455000E+01, 0.00000000E+00,
  0.17807379E+04, 0.160E+03, 0.550E+02, 0.29455000E+01, 0.00000000E+00,
  0.16318559E+04, 0.160E+03, 0.560E+02, 0.29455000E+01, 0.00000000E+00,
  0.14317796E+04, 0.160E+03, 0.570E+02, 0.29455000E+01, 0.00000000E+00,
  0.65338750E+03, 0.160E+03, 0.580E+02, 0.29455000E+01, 0.27991000E+01,
  0.14452611E+04, 0.160E+03, 0.590E+02, 0.29455000E+01, 0.00000000E+00,
  0.13875284E+04, 0.160E+03, 0.600E+02, 0.29455000E+01, 0.00000000E+00,
  0.13526449E+04, 0.160E+03, 0.610E+02, 0.29455000E+01, 0.00000000E+00,
  0.13205717E+04, 0.160E+03, 0.620E+02, 0.29455000E+01, 0.00000000E+00,
  0.12921268E+04, 0.160E+03, 0.630E+02, 0.29455000E+01, 0.00000000E+00,
  0.10145593E+04, 0.160E+03, 0.640E+02, 0.29455000E+01, 0.00000000E+00,
  0.11446770E+04, 0.160E+03, 0.650E+02, 0.29455000E+01, 0.00000000E+00,
  0.11036788E+04, 0.160E+03, 0.660E+02, 0.29455000E+01, 0.00000000E+00,
  0.11650450E+04, 0.160E+03, 0.670E+02, 0.29455000E+01, 0.00000000E+00,
  0.11402779E+04, 0.160E+03, 0.680E+02, 0.29455000E+01, 0.00000000E+00,
  0.11179234E+04, 0.160E+03, 0.690E+02, 0.29455000E+01, 0.00000000E+00,
  0.11049164E+04, 0.160E+03, 0.700E+02, 0.29455000E+01, 0.00000000E+00,
  0.92996320E+03, 0.160E+03, 0.710E+02, 0.29455000E+01, 0.00000000E+00,
  0.91326380E+03, 0.160E+03, 0.720E+02, 0.29455000E+01, 0.00000000E+00,
  0.83272290E+03, 0.160E+03, 0.730E+02, 0.29455000E+01, 0.00000000E+00,
  0.70269660E+03, 0.160E+03, 0.740E+02, 0.29455000E+01, 0.00000000E+00,
  0.71461940E+03, 0.160E+03, 0.750E+02, 0.29455000E+01, 0.00000000E+00,
  0.64718140E+03, 0.160E+03, 0.760E+02, 0.29455000E+01, 0.00000000E+00,
  0.59234880E+03, 0.160E+03, 0.770E+02, 0.29455000E+01, 0.00000000E+00,
  0.49178730E+03, 0.160E+03, 0.780E+02, 0.29455000E+01, 0.00000000E+00,
  0.45937630E+03, 0.160E+03, 0.790E+02, 0.29455000E+01, 0.00000000E+00,
  0.47241230E+03, 0.160E+03, 0.800E+02, 0.29455000E+01, 0.00000000E+00,
  0.69065930E+03, 0.160E+03, 0.810E+02, 0.29455000E+01, 0.00000000E+00,
  0.67450000E+03, 0.160E+03, 0.820E+02, 0.29455000E+01, 0.00000000E+00,
  0.61895970E+03, 0.160E+03, 0.830E+02, 0.29455000E+01, 0.00000000E+00,
  0.58986940E+03, 0.160E+03, 0.840E+02, 0.29455000E+01, 0.00000000E+00,
  0.54389180E+03, 0.160E+03, 0.850E+02, 0.29455000E+01, 0.00000000E+00,
  0.49810570E+03, 0.160E+03, 0.860E+02, 0.29455000E+01, 0.00000000E+00,
  0.16797710E+04, 0.160E+03, 0.870E+02, 0.29455000E+01, 0.00000000E+00,
  0.16125437E+04, 0.160E+03, 0.880E+02, 0.29455000E+01, 0.00000000E+00,
  0.14236214E+04, 0.160E+03, 0.890E+02, 0.29455000E+01, 0.00000000E+00,
  0.12774745E+04, 0.160E+03, 0.900E+02, 0.29455000E+01, 0.00000000E+00,
  0.12692909E+04, 0.160E+03, 0.910E+02, 0.29455000E+01, 0.00000000E+00,
  0.12289809E+04, 0.160E+03, 0.920E+02, 0.29455000E+01, 0.00000000E+00,
  0.12665506E+04, 0.160E+03, 0.930E+02, 0.29455000E+01, 0.00000000E+00,
  0.12263194E+04, 0.160E+03, 0.940E+02, 0.29455000E+01, 0.00000000E+00,
  0.68293100E+02, 0.160E+03, 0.101E+03, 0.29455000E+01, 0.00000000E+00,
  0.22228830E+03, 0.160E+03, 0.103E+03, 0.29455000E+01, 0.98650000E+00,
  0.28337150E+03, 0.160E+03, 0.104E+03, 0.29455000E+01, 0.98080000E+00,
  0.21594380E+03, 0.160E+03, 0.105E+03, 0.29455000E+01, 0.97060000E+00,
  0.16246650E+03, 0.160E+03, 0.106E+03, 0.29455000E+01, 0.98680000E+00,
  0.11281340E+03, 0.160E+03, 0.107E+03, 0.29455000E+01, 0.99440000E+00,
  0.82084900E+02, 0.160E+03, 0.108E+03, 0.29455000E+01, 0.99250000E+00,
  0.56411700E+02, 0.160E+03, 0.109E+03, 0.29455000E+01, 0.99820000E+00,
  0.32516360E+03, 0.160E+03, 0.111E+03, 0.29455000E+01, 0.96840000E+00,
  0.50296550E+03, 0.160E+03, 0.112E+03, 0.29455000E+01, 0.96280000E+00,
  0.50872500E+03, 0.160E+03, 0.113E+03, 0.29455000E+01, 0.96480000E+00,
  0.40796290E+03, 0.160E+03, 0.114E+03, 0.29455000E+01, 0.95070000E+00,
  0.33360650E+03, 0.160E+03, 0.115E+03, 0.29455000E+01, 0.99470000E+00,
  0.28182650E+03, 0.160E+03, 0.116E+03, 0.29455000E+01, 0.99480000E+00,
  0.23014880E+03, 0.160E+03, 0.117E+03, 0.29455000E+01, 0.99720000E+00,
  0.44786360E+03, 0.160E+03, 0.119E+03, 0.29455000E+01, 0.97670000E+00,
  0.85883830E+03, 0.160E+03, 0.120E+03, 0.29455000E+01, 0.98310000E+00,
  0.44722200E+03, 0.160E+03, 0.121E+03, 0.29455000E+01, 0.18627000E+01,
  0.43170970E+03, 0.160E+03, 0.122E+03, 0.29455000E+01, 0.18299000E+01,
  0.42310550E+03, 0.160E+03, 0.123E+03, 0.29455000E+01, 0.19138000E+01,
  0.41928980E+03, 0.160E+03, 0.124E+03, 0.29455000E+01, 0.18269000E+01,
  0.38540430E+03, 0.160E+03, 0.125E+03, 0.29455000E+01, 0.16406000E+01,
  0.35658500E+03, 0.160E+03, 0.126E+03, 0.29455000E+01, 0.16483000E+01,
  0.34017190E+03, 0.160E+03, 0.127E+03, 0.29455000E+01, 0.17149000E+01,
  0.33259710E+03, 0.160E+03, 0.128E+03, 0.29455000E+01, 0.17937000E+01,
  0.32889540E+03, 0.160E+03, 0.129E+03, 0.29455000E+01, 0.95760000E+00,
  0.30812510E+03, 0.160E+03, 0.130E+03, 0.29455000E+01, 0.19419000E+01,
  0.50468300E+03, 0.160E+03, 0.131E+03, 0.29455000E+01, 0.96010000E+00,
  0.44257280E+03, 0.160E+03, 0.132E+03, 0.29455000E+01, 0.94340000E+00,
  0.39617290E+03, 0.160E+03, 0.133E+03, 0.29455000E+01, 0.98890000E+00,
  0.36146790E+03, 0.160E+03, 0.134E+03, 0.29455000E+01, 0.99010000E+00,
  0.31812780E+03, 0.160E+03, 0.135E+03, 0.29455000E+01, 0.99740000E+00,
  0.53419470E+03, 0.160E+03, 0.137E+03, 0.29455000E+01, 0.97380000E+00,
  0.10452541E+04, 0.160E+03, 0.138E+03, 0.29455000E+01, 0.98010000E+00,
  0.79688440E+03, 0.160E+03, 0.139E+03, 0.29455000E+01, 0.19153000E+01,
  0.59156300E+03, 0.160E+03, 0.140E+03, 0.29455000E+01, 0.19355000E+01,
  0.59746030E+03, 0.160E+03, 0.141E+03, 0.29455000E+01, 0.19545000E+01,
  0.55690660E+03, 0.160E+03, 0.142E+03, 0.29455000E+01, 0.19420000E+01,
  0.62539660E+03, 0.160E+03, 0.143E+03, 0.29455000E+01, 0.16682000E+01,
  0.48497040E+03, 0.160E+03, 0.144E+03, 0.29455000E+01, 0.18584000E+01,
  0.45367340E+03, 0.160E+03, 0.145E+03, 0.29455000E+01, 0.19003000E+01,
  0.42121350E+03, 0.160E+03, 0.146E+03, 0.29455000E+01, 0.18630000E+01,
  0.40754200E+03, 0.160E+03, 0.147E+03, 0.29455000E+01, 0.96790000E+00,
  0.40282810E+03, 0.160E+03, 0.148E+03, 0.29455000E+01, 0.19539000E+01,
  0.64108970E+03, 0.160E+03, 0.149E+03, 0.29455000E+01, 0.96330000E+00,
  0.57909510E+03, 0.160E+03, 0.150E+03, 0.29455000E+01, 0.95140000E+00,
  0.54176140E+03, 0.160E+03, 0.151E+03, 0.29455000E+01, 0.97490000E+00,
  0.51212090E+03, 0.160E+03, 0.152E+03, 0.29455000E+01, 0.98110000E+00,
  0.46733270E+03, 0.160E+03, 0.153E+03, 0.29455000E+01, 0.99680000E+00,
  0.63096990E+03, 0.160E+03, 0.155E+03, 0.29455000E+01, 0.99090000E+00,
  0.13558874E+04, 0.160E+03, 0.156E+03, 0.29455000E+01, 0.97970000E+00,
  0.10088176E+04, 0.160E+03, 0.157E+03, 0.29455000E+01, 0.19373000E+01,
  0.63363330E+03, 0.160E+03, 0.159E+03, 0.29455000E+01, 0.29425000E+01,
  0.62052060E+03, 0.160E+03, 0.160E+03, 0.29455000E+01, 0.29455000E+01,
  0.41035600E+02, 0.161E+03, 0.100E+01, 0.29413000E+01, 0.91180000E+00,
  0.27115000E+02, 0.161E+03, 0.200E+01, 0.29413000E+01, 0.00000000E+00,
  0.64218080E+03, 0.161E+03, 0.300E+01, 0.29413000E+01, 0.00000000E+00,
  0.36981420E+03, 0.161E+03, 0.400E+01, 0.29413000E+01, 0.00000000E+00,
  0.24860710E+03, 0.161E+03, 0.500E+01, 0.29413000E+01, 0.00000000E+00,
  0.16779680E+03, 0.161E+03, 0.600E+01, 0.29413000E+01, 0.00000000E+00,
  0.11730260E+03, 0.161E+03, 0.700E+01, 0.29413000E+01, 0.00000000E+00,
  0.88815900E+02, 0.161E+03, 0.800E+01, 0.29413000E+01, 0.00000000E+00,
  0.67299900E+02, 0.161E+03, 0.900E+01, 0.29413000E+01, 0.00000000E+00,
  0.51786000E+02, 0.161E+03, 0.100E+02, 0.29413000E+01, 0.00000000E+00,
  0.76786760E+03, 0.161E+03, 0.110E+02, 0.29413000E+01, 0.00000000E+00,
  0.58961410E+03, 0.161E+03, 0.120E+02, 0.29413000E+01, 0.00000000E+00,
  0.54296830E+03, 0.161E+03, 0.130E+02, 0.29413000E+01, 0.00000000E+00,
  0.42728580E+03, 0.161E+03, 0.140E+02, 0.29413000E+01, 0.00000000E+00,
  0.33286240E+03, 0.161E+03, 0.150E+02, 0.29413000E+01, 0.00000000E+00,
  0.27611290E+03, 0.161E+03, 0.160E+02, 0.29413000E+01, 0.00000000E+00,
  0.22545620E+03, 0.161E+03, 0.170E+02, 0.29413000E+01, 0.00000000E+00,
  0.18441100E+03, 0.161E+03, 0.180E+02, 0.29413000E+01, 0.00000000E+00,
  0.12590280E+04, 0.161E+03, 0.190E+02, 0.29413000E+01, 0.00000000E+00,
  0.10371340E+04, 0.161E+03, 0.200E+02, 0.29413000E+01, 0.00000000E+00,
  0.85644340E+03, 0.161E+03, 0.210E+02, 0.29413000E+01, 0.00000000E+00,
  0.82672570E+03, 0.161E+03, 0.220E+02, 0.29413000E+01, 0.00000000E+00,
  0.75688430E+03, 0.161E+03, 0.230E+02, 0.29413000E+01, 0.00000000E+00,
  0.59629710E+03, 0.161E+03, 0.240E+02, 0.29413000E+01, 0.00000000E+00,
  0.65144380E+03, 0.161E+03, 0.250E+02, 0.29413000E+01, 0.00000000E+00,
  0.51133840E+03, 0.161E+03, 0.260E+02, 0.29413000E+01, 0.00000000E+00,
  0.54164010E+03, 0.161E+03, 0.270E+02, 0.29413000E+01, 0.00000000E+00,
  0.55809040E+03, 0.161E+03, 0.280E+02, 0.29413000E+01, 0.00000000E+00,
  0.42796300E+03, 0.161E+03, 0.290E+02, 0.29413000E+01, 0.00000000E+00,
  0.43895460E+03, 0.161E+03, 0.300E+02, 0.29413000E+01, 0.00000000E+00,
  0.51995360E+03, 0.161E+03, 0.310E+02, 0.29413000E+01, 0.00000000E+00,
  0.45803850E+03, 0.161E+03, 0.320E+02, 0.29413000E+01, 0.00000000E+00,
  0.39031610E+03, 0.161E+03, 0.330E+02, 0.29413000E+01, 0.00000000E+00,
  0.35005540E+03, 0.161E+03, 0.340E+02, 0.29413000E+01, 0.00000000E+00,
  0.30619590E+03, 0.161E+03, 0.350E+02, 0.29413000E+01, 0.00000000E+00,
  0.26618930E+03, 0.161E+03, 0.360E+02, 0.29413000E+01, 0.00000000E+00,
  0.14108565E+04, 0.161E+03, 0.370E+02, 0.29413000E+01, 0.00000000E+00,
  0.12358086E+04, 0.161E+03, 0.380E+02, 0.29413000E+01, 0.00000000E+00,
  0.10815963E+04, 0.161E+03, 0.390E+02, 0.29413000E+01, 0.00000000E+00,
  0.97156440E+03, 0.161E+03, 0.400E+02, 0.29413000E+01, 0.00000000E+00,
  0.88562820E+03, 0.161E+03, 0.410E+02, 0.29413000E+01, 0.00000000E+00,
  0.68336810E+03, 0.161E+03, 0.420E+02, 0.29413000E+01, 0.00000000E+00,
  0.76261340E+03, 0.161E+03, 0.430E+02, 0.29413000E+01, 0.00000000E+00,
  0.58065630E+03, 0.161E+03, 0.440E+02, 0.29413000E+01, 0.00000000E+00,
  0.63462930E+03, 0.161E+03, 0.450E+02, 0.29413000E+01, 0.00000000E+00,
  0.58839190E+03, 0.161E+03, 0.460E+02, 0.29413000E+01, 0.00000000E+00,
  0.49078330E+03, 0.161E+03, 0.470E+02, 0.29413000E+01, 0.00000000E+00,
  0.51833560E+03, 0.161E+03, 0.480E+02, 0.29413000E+01, 0.00000000E+00,
  0.65088900E+03, 0.161E+03, 0.490E+02, 0.29413000E+01, 0.00000000E+00,
  0.60128620E+03, 0.161E+03, 0.500E+02, 0.29413000E+01, 0.00000000E+00,
  0.53534260E+03, 0.161E+03, 0.510E+02, 0.29413000E+01, 0.00000000E+00,
  0.49642060E+03, 0.161E+03, 0.520E+02, 0.29413000E+01, 0.00000000E+00,
  0.44860200E+03, 0.161E+03, 0.530E+02, 0.29413000E+01, 0.00000000E+00,
  0.40312330E+03, 0.161E+03, 0.540E+02, 0.29413000E+01, 0.00000000E+00,
  0.17186565E+04, 0.161E+03, 0.550E+02, 0.29413000E+01, 0.00000000E+00,
  0.15759396E+04, 0.161E+03, 0.560E+02, 0.29413000E+01, 0.00000000E+00,
  0.13833184E+04, 0.161E+03, 0.570E+02, 0.29413000E+01, 0.00000000E+00,
  0.63260690E+03, 0.161E+03, 0.580E+02, 0.29413000E+01, 0.27991000E+01,
  0.13959648E+04, 0.161E+03, 0.590E+02, 0.29413000E+01, 0.00000000E+00,
  0.13402848E+04, 0.161E+03, 0.600E+02, 0.29413000E+01, 0.00000000E+00,
  0.13066123E+04, 0.161E+03, 0.610E+02, 0.29413000E+01, 0.00000000E+00,
  0.12756493E+04, 0.161E+03, 0.620E+02, 0.29413000E+01, 0.00000000E+00,
  0.12481896E+04, 0.161E+03, 0.630E+02, 0.29413000E+01, 0.00000000E+00,
  0.98061140E+03, 0.161E+03, 0.640E+02, 0.29413000E+01, 0.00000000E+00,
  0.11056577E+04, 0.161E+03, 0.650E+02, 0.29413000E+01, 0.00000000E+00,
  0.10661553E+04, 0.161E+03, 0.660E+02, 0.29413000E+01, 0.00000000E+00,
  0.11255430E+04, 0.161E+03, 0.670E+02, 0.29413000E+01, 0.00000000E+00,
  0.11016251E+04, 0.161E+03, 0.680E+02, 0.29413000E+01, 0.00000000E+00,
  0.10800441E+04, 0.161E+03, 0.690E+02, 0.29413000E+01, 0.00000000E+00,
  0.10674513E+04, 0.161E+03, 0.700E+02, 0.29413000E+01, 0.00000000E+00,
  0.89877880E+03, 0.161E+03, 0.710E+02, 0.29413000E+01, 0.00000000E+00,
  0.88303380E+03, 0.161E+03, 0.720E+02, 0.29413000E+01, 0.00000000E+00,
  0.80541670E+03, 0.161E+03, 0.730E+02, 0.29413000E+01, 0.00000000E+00,
  0.67986960E+03, 0.161E+03, 0.740E+02, 0.29413000E+01, 0.00000000E+00,
  0.69147700E+03, 0.161E+03, 0.750E+02, 0.29413000E+01, 0.00000000E+00,
  0.62640460E+03, 0.161E+03, 0.760E+02, 0.29413000E+01, 0.00000000E+00,
  0.57347180E+03, 0.161E+03, 0.770E+02, 0.29413000E+01, 0.00000000E+00,
  0.47626530E+03, 0.161E+03, 0.780E+02, 0.29413000E+01, 0.00000000E+00,
  0.44493320E+03, 0.161E+03, 0.790E+02, 0.29413000E+01, 0.00000000E+00,
  0.45759140E+03, 0.161E+03, 0.800E+02, 0.29413000E+01, 0.00000000E+00,
  0.66821650E+03, 0.161E+03, 0.810E+02, 0.29413000E+01, 0.00000000E+00,
  0.65280350E+03, 0.161E+03, 0.820E+02, 0.29413000E+01, 0.00000000E+00,
  0.59931800E+03, 0.161E+03, 0.830E+02, 0.29413000E+01, 0.00000000E+00,
  0.57130760E+03, 0.161E+03, 0.840E+02, 0.29413000E+01, 0.00000000E+00,
  0.52695800E+03, 0.161E+03, 0.850E+02, 0.29413000E+01, 0.00000000E+00,
  0.48275550E+03, 0.161E+03, 0.860E+02, 0.29413000E+01, 0.00000000E+00,
  0.16217509E+04, 0.161E+03, 0.870E+02, 0.29413000E+01, 0.00000000E+00,
  0.15576603E+04, 0.161E+03, 0.880E+02, 0.29413000E+01, 0.00000000E+00,
  0.13757224E+04, 0.161E+03, 0.890E+02, 0.29413000E+01, 0.00000000E+00,
  0.12351334E+04, 0.161E+03, 0.900E+02, 0.29413000E+01, 0.00000000E+00,
  0.12269612E+04, 0.161E+03, 0.910E+02, 0.29413000E+01, 0.00000000E+00,
  0.11880136E+04, 0.161E+03, 0.920E+02, 0.29413000E+01, 0.00000000E+00,
  0.12239539E+04, 0.161E+03, 0.930E+02, 0.29413000E+01, 0.00000000E+00,
  0.11851389E+04, 0.161E+03, 0.940E+02, 0.29413000E+01, 0.00000000E+00,
  0.66143900E+02, 0.161E+03, 0.101E+03, 0.29413000E+01, 0.00000000E+00,
  0.21491570E+03, 0.161E+03, 0.103E+03, 0.29413000E+01, 0.98650000E+00,
  0.27404530E+03, 0.161E+03, 0.104E+03, 0.29413000E+01, 0.98080000E+00,
  0.20906270E+03, 0.161E+03, 0.105E+03, 0.29413000E+01, 0.97060000E+00,
  0.15740780E+03, 0.161E+03, 0.106E+03, 0.29413000E+01, 0.98680000E+00,
  0.10939440E+03, 0.161E+03, 0.107E+03, 0.29413000E+01, 0.99440000E+00,
  0.79656600E+02, 0.161E+03, 0.108E+03, 0.29413000E+01, 0.99250000E+00,
  0.54794700E+02, 0.161E+03, 0.109E+03, 0.29413000E+01, 0.99820000E+00,
  0.31433160E+03, 0.161E+03, 0.111E+03, 0.29413000E+01, 0.96840000E+00,
  0.48615820E+03, 0.161E+03, 0.112E+03, 0.29413000E+01, 0.96280000E+00,
  0.49197000E+03, 0.161E+03, 0.113E+03, 0.29413000E+01, 0.96480000E+00,
  0.39485010E+03, 0.161E+03, 0.114E+03, 0.29413000E+01, 0.95070000E+00,
  0.32309660E+03, 0.161E+03, 0.115E+03, 0.29413000E+01, 0.99470000E+00,
  0.27308190E+03, 0.161E+03, 0.116E+03, 0.29413000E+01, 0.99480000E+00,
  0.22312610E+03, 0.161E+03, 0.117E+03, 0.29413000E+01, 0.99720000E+00,
  0.43320740E+03, 0.161E+03, 0.119E+03, 0.29413000E+01, 0.97670000E+00,
  0.82964080E+03, 0.161E+03, 0.120E+03, 0.29413000E+01, 0.98310000E+00,
  0.43282760E+03, 0.161E+03, 0.121E+03, 0.29413000E+01, 0.18627000E+01,
  0.41783600E+03, 0.161E+03, 0.122E+03, 0.29413000E+01, 0.18299000E+01,
  0.40950580E+03, 0.161E+03, 0.123E+03, 0.29413000E+01, 0.19138000E+01,
  0.40578350E+03, 0.161E+03, 0.124E+03, 0.29413000E+01, 0.18269000E+01,
  0.37312230E+03, 0.161E+03, 0.125E+03, 0.29413000E+01, 0.16406000E+01,
  0.34526760E+03, 0.161E+03, 0.126E+03, 0.29413000E+01, 0.16483000E+01,
  0.32938120E+03, 0.161E+03, 0.127E+03, 0.29413000E+01, 0.17149000E+01,
  0.32203750E+03, 0.161E+03, 0.128E+03, 0.29413000E+01, 0.17937000E+01,
  0.31836420E+03, 0.161E+03, 0.129E+03, 0.29413000E+01, 0.95760000E+00,
  0.29841060E+03, 0.161E+03, 0.130E+03, 0.29413000E+01, 0.19419000E+01,
  0.48821620E+03, 0.161E+03, 0.131E+03, 0.29413000E+01, 0.96010000E+00,
  0.42840160E+03, 0.161E+03, 0.132E+03, 0.29413000E+01, 0.94340000E+00,
  0.38367750E+03, 0.161E+03, 0.133E+03, 0.29413000E+01, 0.98890000E+00,
  0.35019520E+03, 0.161E+03, 0.134E+03, 0.29413000E+01, 0.99010000E+00,
  0.30833610E+03, 0.161E+03, 0.135E+03, 0.29413000E+01, 0.99740000E+00,
  0.51680260E+03, 0.161E+03, 0.137E+03, 0.29413000E+01, 0.97380000E+00,
  0.10097020E+04, 0.161E+03, 0.138E+03, 0.29413000E+01, 0.98010000E+00,
  0.77048950E+03, 0.161E+03, 0.139E+03, 0.29413000E+01, 0.19153000E+01,
  0.57252260E+03, 0.161E+03, 0.140E+03, 0.29413000E+01, 0.19355000E+01,
  0.57822130E+03, 0.161E+03, 0.141E+03, 0.29413000E+01, 0.19545000E+01,
  0.53906400E+03, 0.161E+03, 0.142E+03, 0.29413000E+01, 0.19420000E+01,
  0.60508290E+03, 0.161E+03, 0.143E+03, 0.29413000E+01, 0.16682000E+01,
  0.46961340E+03, 0.161E+03, 0.144E+03, 0.29413000E+01, 0.18584000E+01,
  0.43933610E+03, 0.161E+03, 0.145E+03, 0.29413000E+01, 0.19003000E+01,
  0.40794200E+03, 0.161E+03, 0.146E+03, 0.29413000E+01, 0.18630000E+01,
  0.39468140E+03, 0.161E+03, 0.147E+03, 0.29413000E+01, 0.96790000E+00,
  0.39021360E+03, 0.161E+03, 0.148E+03, 0.29413000E+01, 0.19539000E+01,
  0.62022960E+03, 0.161E+03, 0.149E+03, 0.29413000E+01, 0.96330000E+00,
  0.56054060E+03, 0.161E+03, 0.150E+03, 0.29413000E+01, 0.95140000E+00,
  0.52460280E+03, 0.161E+03, 0.151E+03, 0.29413000E+01, 0.97490000E+00,
  0.49603960E+03, 0.161E+03, 0.152E+03, 0.29413000E+01, 0.98110000E+00,
  0.45281350E+03, 0.161E+03, 0.153E+03, 0.29413000E+01, 0.99680000E+00,
  0.61065170E+03, 0.161E+03, 0.155E+03, 0.29413000E+01, 0.99090000E+00,
  0.13096071E+04, 0.161E+03, 0.156E+03, 0.29413000E+01, 0.97970000E+00,
  0.97534290E+03, 0.161E+03, 0.157E+03, 0.29413000E+01, 0.19373000E+01,
  0.61350220E+03, 0.161E+03, 0.159E+03, 0.29413000E+01, 0.29425000E+01,
  0.60081010E+03, 0.161E+03, 0.160E+03, 0.29413000E+01, 0.29455000E+01,
  0.58174350E+03, 0.161E+03, 0.161E+03, 0.29413000E+01, 0.29413000E+01,
  0.41118600E+02, 0.162E+03, 0.100E+01, 0.29300000E+01, 0.91180000E+00,
  0.27091000E+02, 0.162E+03, 0.200E+01, 0.29300000E+01, 0.00000000E+00,
  0.65371250E+03, 0.162E+03, 0.300E+01, 0.29300000E+01, 0.00000000E+00,
  0.37335380E+03, 0.162E+03, 0.400E+01, 0.29300000E+01, 0.00000000E+00,
  0.25006900E+03, 0.162E+03, 0.500E+01, 0.29300000E+01, 0.00000000E+00,
  0.16835070E+03, 0.162E+03, 0.600E+01, 0.29300000E+01, 0.00000000E+00,
  0.11747400E+03, 0.162E+03, 0.700E+01, 0.29300000E+01, 0.00000000E+00,
  0.88833200E+02, 0.162E+03, 0.800E+01, 0.29300000E+01, 0.00000000E+00,
  0.67241500E+02, 0.162E+03, 0.900E+01, 0.29300000E+01, 0.00000000E+00,
  0.51697700E+02, 0.162E+03, 0.100E+02, 0.29300000E+01, 0.00000000E+00,
  0.78120500E+03, 0.162E+03, 0.110E+02, 0.29300000E+01, 0.00000000E+00,
  0.59600220E+03, 0.162E+03, 0.120E+02, 0.29300000E+01, 0.00000000E+00,
  0.54777420E+03, 0.162E+03, 0.130E+02, 0.29300000E+01, 0.00000000E+00,
  0.42994940E+03, 0.162E+03, 0.140E+02, 0.29300000E+01, 0.00000000E+00,
  0.33425170E+03, 0.162E+03, 0.150E+02, 0.29300000E+01, 0.00000000E+00,
  0.27691160E+03, 0.162E+03, 0.160E+02, 0.29300000E+01, 0.00000000E+00,
  0.22583700E+03, 0.162E+03, 0.170E+02, 0.29300000E+01, 0.00000000E+00,
  0.18453320E+03, 0.162E+03, 0.180E+02, 0.29300000E+01, 0.00000000E+00,
  0.12836315E+04, 0.162E+03, 0.190E+02, 0.29300000E+01, 0.00000000E+00,
  0.10509848E+04, 0.162E+03, 0.200E+02, 0.29300000E+01, 0.00000000E+00,
  0.86692280E+03, 0.162E+03, 0.210E+02, 0.29300000E+01, 0.00000000E+00,
  0.83609940E+03, 0.162E+03, 0.220E+02, 0.29300000E+01, 0.00000000E+00,
  0.76505120E+03, 0.162E+03, 0.230E+02, 0.29300000E+01, 0.00000000E+00,
  0.60271130E+03, 0.162E+03, 0.240E+02, 0.29300000E+01, 0.00000000E+00,
  0.65796350E+03, 0.162E+03, 0.250E+02, 0.29300000E+01, 0.00000000E+00,
  0.51637700E+03, 0.162E+03, 0.260E+02, 0.29300000E+01, 0.00000000E+00,
  0.54633630E+03, 0.162E+03, 0.270E+02, 0.29300000E+01, 0.00000000E+00,
  0.56322550E+03, 0.162E+03, 0.280E+02, 0.29300000E+01, 0.00000000E+00,
  0.43190330E+03, 0.162E+03, 0.290E+02, 0.29300000E+01, 0.00000000E+00,
  0.44225450E+03, 0.162E+03, 0.300E+02, 0.29300000E+01, 0.00000000E+00,
  0.52416760E+03, 0.162E+03, 0.310E+02, 0.29300000E+01, 0.00000000E+00,
  0.46081790E+03, 0.162E+03, 0.320E+02, 0.29300000E+01, 0.00000000E+00,
  0.39201390E+03, 0.162E+03, 0.330E+02, 0.29300000E+01, 0.00000000E+00,
  0.35121820E+03, 0.162E+03, 0.340E+02, 0.29300000E+01, 0.00000000E+00,
  0.30689590E+03, 0.162E+03, 0.350E+02, 0.29300000E+01, 0.00000000E+00,
  0.26654940E+03, 0.162E+03, 0.360E+02, 0.29300000E+01, 0.00000000E+00,
  0.14379300E+04, 0.162E+03, 0.370E+02, 0.29300000E+01, 0.00000000E+00,
  0.12526342E+04, 0.162E+03, 0.380E+02, 0.29300000E+01, 0.00000000E+00,
  0.10942695E+04, 0.162E+03, 0.390E+02, 0.29300000E+01, 0.00000000E+00,
  0.98185530E+03, 0.162E+03, 0.400E+02, 0.29300000E+01, 0.00000000E+00,
  0.89439170E+03, 0.162E+03, 0.410E+02, 0.29300000E+01, 0.00000000E+00,
  0.68930910E+03, 0.162E+03, 0.420E+02, 0.29300000E+01, 0.00000000E+00,
  0.76959900E+03, 0.162E+03, 0.430E+02, 0.29300000E+01, 0.00000000E+00,
  0.58520650E+03, 0.162E+03, 0.440E+02, 0.29300000E+01, 0.00000000E+00,
  0.63957050E+03, 0.162E+03, 0.450E+02, 0.29300000E+01, 0.00000000E+00,
  0.59271510E+03, 0.162E+03, 0.460E+02, 0.29300000E+01, 0.00000000E+00,
  0.49454430E+03, 0.162E+03, 0.470E+02, 0.29300000E+01, 0.00000000E+00,
  0.52185710E+03, 0.162E+03, 0.480E+02, 0.29300000E+01, 0.00000000E+00,
  0.65623190E+03, 0.162E+03, 0.490E+02, 0.29300000E+01, 0.00000000E+00,
  0.60519030E+03, 0.162E+03, 0.500E+02, 0.29300000E+01, 0.00000000E+00,
  0.53798990E+03, 0.162E+03, 0.510E+02, 0.29300000E+01, 0.00000000E+00,
  0.49842910E+03, 0.162E+03, 0.520E+02, 0.29300000E+01, 0.00000000E+00,
  0.44999200E+03, 0.162E+03, 0.530E+02, 0.29300000E+01, 0.00000000E+00,
  0.40401740E+03, 0.162E+03, 0.540E+02, 0.29300000E+01, 0.00000000E+00,
  0.17521410E+04, 0.162E+03, 0.550E+02, 0.29300000E+01, 0.00000000E+00,
  0.15986396E+04, 0.162E+03, 0.560E+02, 0.29300000E+01, 0.00000000E+00,
  0.14005068E+04, 0.162E+03, 0.570E+02, 0.29300000E+01, 0.00000000E+00,
  0.63591570E+03, 0.162E+03, 0.580E+02, 0.29300000E+01, 0.27991000E+01,
  0.14152709E+04, 0.162E+03, 0.590E+02, 0.29300000E+01, 0.00000000E+00,
  0.13581904E+04, 0.162E+03, 0.600E+02, 0.29300000E+01, 0.00000000E+00,
  0.13239329E+04, 0.162E+03, 0.610E+02, 0.29300000E+01, 0.00000000E+00,
  0.12924475E+04, 0.162E+03, 0.620E+02, 0.29300000E+01, 0.00000000E+00,
  0.12645213E+04, 0.162E+03, 0.630E+02, 0.29300000E+01, 0.00000000E+00,
  0.99151760E+03, 0.162E+03, 0.640E+02, 0.29300000E+01, 0.00000000E+00,
  0.11218549E+04, 0.162E+03, 0.650E+02, 0.29300000E+01, 0.00000000E+00,
  0.10816001E+04, 0.162E+03, 0.660E+02, 0.29300000E+01, 0.00000000E+00,
  0.11396825E+04, 0.162E+03, 0.670E+02, 0.29300000E+01, 0.00000000E+00,
  0.11153978E+04, 0.162E+03, 0.680E+02, 0.29300000E+01, 0.00000000E+00,
  0.10934602E+04, 0.162E+03, 0.690E+02, 0.29300000E+01, 0.00000000E+00,
  0.10807974E+04, 0.162E+03, 0.700E+02, 0.29300000E+01, 0.00000000E+00,
  0.90896190E+03, 0.162E+03, 0.710E+02, 0.29300000E+01, 0.00000000E+00,
  0.89127890E+03, 0.162E+03, 0.720E+02, 0.29300000E+01, 0.00000000E+00,
  0.81208250E+03, 0.162E+03, 0.730E+02, 0.29300000E+01, 0.00000000E+00,
  0.68499030E+03, 0.162E+03, 0.740E+02, 0.29300000E+01, 0.00000000E+00,
  0.69640000E+03, 0.162E+03, 0.750E+02, 0.29300000E+01, 0.00000000E+00,
  0.63031370E+03, 0.162E+03, 0.760E+02, 0.29300000E+01, 0.00000000E+00,
  0.57665350E+03, 0.162E+03, 0.770E+02, 0.29300000E+01, 0.00000000E+00,
  0.47857310E+03, 0.162E+03, 0.780E+02, 0.29300000E+01, 0.00000000E+00,
  0.44696260E+03, 0.162E+03, 0.790E+02, 0.29300000E+01, 0.00000000E+00,
  0.45952800E+03, 0.162E+03, 0.800E+02, 0.29300000E+01, 0.00000000E+00,
  0.67346620E+03, 0.162E+03, 0.810E+02, 0.29300000E+01, 0.00000000E+00,
  0.65702270E+03, 0.162E+03, 0.820E+02, 0.29300000E+01, 0.00000000E+00,
  0.60234550E+03, 0.162E+03, 0.830E+02, 0.29300000E+01, 0.00000000E+00,
  0.57374780E+03, 0.162E+03, 0.840E+02, 0.29300000E+01, 0.00000000E+00,
  0.52872700E+03, 0.162E+03, 0.850E+02, 0.29300000E+01, 0.00000000E+00,
  0.48398270E+03, 0.162E+03, 0.860E+02, 0.29300000E+01, 0.00000000E+00,
  0.16501361E+04, 0.162E+03, 0.870E+02, 0.29300000E+01, 0.00000000E+00,
  0.15785123E+04, 0.162E+03, 0.880E+02, 0.29300000E+01, 0.00000000E+00,
  0.13916728E+04, 0.162E+03, 0.890E+02, 0.29300000E+01, 0.00000000E+00,
  0.12470771E+04, 0.162E+03, 0.900E+02, 0.29300000E+01, 0.00000000E+00,
  0.12400445E+04, 0.162E+03, 0.910E+02, 0.29300000E+01, 0.00000000E+00,
  0.12006028E+04, 0.162E+03, 0.920E+02, 0.29300000E+01, 0.00000000E+00,
  0.12383187E+04, 0.162E+03, 0.930E+02, 0.29300000E+01, 0.00000000E+00,
  0.11987720E+04, 0.162E+03, 0.940E+02, 0.29300000E+01, 0.00000000E+00,
  0.66405700E+02, 0.162E+03, 0.101E+03, 0.29300000E+01, 0.00000000E+00,
  0.21686950E+03, 0.162E+03, 0.103E+03, 0.29300000E+01, 0.98650000E+00,
  0.27638280E+03, 0.162E+03, 0.104E+03, 0.29300000E+01, 0.98080000E+00,
  0.21014480E+03, 0.162E+03, 0.105E+03, 0.29300000E+01, 0.97060000E+00,
  0.15794060E+03, 0.162E+03, 0.106E+03, 0.29300000E+01, 0.98680000E+00,
  0.10955230E+03, 0.162E+03, 0.107E+03, 0.29300000E+01, 0.99440000E+00,
  0.79647700E+02, 0.162E+03, 0.108E+03, 0.29300000E+01, 0.99250000E+00,
  0.54685200E+02, 0.162E+03, 0.109E+03, 0.29300000E+01, 0.99820000E+00,
  0.31740960E+03, 0.162E+03, 0.111E+03, 0.29300000E+01, 0.96840000E+00,
  0.49113850E+03, 0.162E+03, 0.112E+03, 0.29300000E+01, 0.96280000E+00,
  0.49609590E+03, 0.162E+03, 0.113E+03, 0.29300000E+01, 0.96480000E+00,
  0.39717520E+03, 0.162E+03, 0.114E+03, 0.29300000E+01, 0.95070000E+00,
  0.32442460E+03, 0.162E+03, 0.115E+03, 0.29300000E+01, 0.99470000E+00,
  0.27388040E+03, 0.162E+03, 0.116E+03, 0.29300000E+01, 0.99480000E+00,
  0.22350790E+03, 0.162E+03, 0.117E+03, 0.29300000E+01, 0.99720000E+00,
  0.43688540E+03, 0.162E+03, 0.119E+03, 0.29300000E+01, 0.97670000E+00,
  0.84105190E+03, 0.162E+03, 0.120E+03, 0.29300000E+01, 0.98310000E+00,
  0.43551720E+03, 0.162E+03, 0.121E+03, 0.29300000E+01, 0.18627000E+01,
  0.42046710E+03, 0.162E+03, 0.122E+03, 0.29300000E+01, 0.18299000E+01,
  0.41208740E+03, 0.162E+03, 0.123E+03, 0.29300000E+01, 0.19138000E+01,
  0.40844600E+03, 0.162E+03, 0.124E+03, 0.29300000E+01, 0.18269000E+01,
  0.37510510E+03, 0.162E+03, 0.125E+03, 0.29300000E+01, 0.16406000E+01,
  0.34698680E+03, 0.162E+03, 0.126E+03, 0.29300000E+01, 0.16483000E+01,
  0.33102820E+03, 0.162E+03, 0.127E+03, 0.29300000E+01, 0.17149000E+01,
  0.32367720E+03, 0.162E+03, 0.128E+03, 0.29300000E+01, 0.17937000E+01,
  0.32026840E+03, 0.162E+03, 0.129E+03, 0.29300000E+01, 0.95760000E+00,
  0.29970920E+03, 0.162E+03, 0.130E+03, 0.29300000E+01, 0.19419000E+01,
  0.49191570E+03, 0.162E+03, 0.131E+03, 0.29300000E+01, 0.96010000E+00,
  0.43081190E+03, 0.162E+03, 0.132E+03, 0.29300000E+01, 0.94340000E+00,
  0.38530990E+03, 0.162E+03, 0.133E+03, 0.29300000E+01, 0.98890000E+00,
  0.35136440E+03, 0.162E+03, 0.134E+03, 0.29300000E+01, 0.99010000E+00,
  0.30905750E+03, 0.162E+03, 0.135E+03, 0.29300000E+01, 0.99740000E+00,
  0.52097030E+03, 0.162E+03, 0.137E+03, 0.29300000E+01, 0.97380000E+00,
  0.10240101E+04, 0.162E+03, 0.138E+03, 0.29300000E+01, 0.98010000E+00,
  0.77856140E+03, 0.162E+03, 0.139E+03, 0.29300000E+01, 0.19153000E+01,
  0.57624530E+03, 0.162E+03, 0.140E+03, 0.29300000E+01, 0.19355000E+01,
  0.58193050E+03, 0.162E+03, 0.141E+03, 0.29300000E+01, 0.19545000E+01,
  0.54238030E+03, 0.162E+03, 0.142E+03, 0.29300000E+01, 0.19420000E+01,
  0.60986550E+03, 0.162E+03, 0.143E+03, 0.29300000E+01, 0.16682000E+01,
  0.47194410E+03, 0.162E+03, 0.144E+03, 0.29300000E+01, 0.18584000E+01,
  0.44147690E+03, 0.162E+03, 0.145E+03, 0.29300000E+01, 0.19003000E+01,
  0.40984440E+03, 0.162E+03, 0.146E+03, 0.29300000E+01, 0.18630000E+01,
  0.39658040E+03, 0.162E+03, 0.147E+03, 0.29300000E+01, 0.96790000E+00,
  0.39174910E+03, 0.162E+03, 0.148E+03, 0.29300000E+01, 0.19539000E+01,
  0.62494310E+03, 0.162E+03, 0.149E+03, 0.29300000E+01, 0.96330000E+00,
  0.56383860E+03, 0.162E+03, 0.150E+03, 0.29300000E+01, 0.95140000E+00,
  0.52709190E+03, 0.162E+03, 0.151E+03, 0.29300000E+01, 0.97490000E+00,
  0.49801930E+03, 0.162E+03, 0.152E+03, 0.29300000E+01, 0.98110000E+00,
  0.45422360E+03, 0.162E+03, 0.153E+03, 0.29300000E+01, 0.99680000E+00,
  0.61477890E+03, 0.162E+03, 0.155E+03, 0.29300000E+01, 0.99090000E+00,
  0.13297509E+04, 0.162E+03, 0.156E+03, 0.29300000E+01, 0.97970000E+00,
  0.98604390E+03, 0.162E+03, 0.157E+03, 0.29300000E+01, 0.19373000E+01,
  0.61665720E+03, 0.162E+03, 0.159E+03, 0.29300000E+01, 0.29425000E+01,
  0.60388680E+03, 0.162E+03, 0.160E+03, 0.29300000E+01, 0.29455000E+01,
  0.58467880E+03, 0.162E+03, 0.161E+03, 0.29300000E+01, 0.29413000E+01,
  0.58778910E+03, 0.162E+03, 0.162E+03, 0.29300000E+01, 0.29300000E+01,
  0.39256400E+02, 0.163E+03, 0.100E+01, 0.18286000E+01, 0.91180000E+00,
  0.25691300E+02, 0.163E+03, 0.200E+01, 0.18286000E+01, 0.00000000E+00,
  0.65368460E+03, 0.163E+03, 0.300E+01, 0.18286000E+01, 0.00000000E+00,
  0.36511120E+03, 0.163E+03, 0.400E+01, 0.18286000E+01, 0.00000000E+00,
  0.24163430E+03, 0.163E+03, 0.500E+01, 0.18286000E+01, 0.00000000E+00,
  0.16139330E+03, 0.163E+03, 0.600E+01, 0.18286000E+01, 0.00000000E+00,
  0.11205120E+03, 0.163E+03, 0.700E+01, 0.18286000E+01, 0.00000000E+00,
  0.84473100E+02, 0.163E+03, 0.800E+01, 0.18286000E+01, 0.00000000E+00,
  0.63799600E+02, 0.163E+03, 0.900E+01, 0.18286000E+01, 0.00000000E+00,
  0.48980900E+02, 0.163E+03, 0.100E+02, 0.18286000E+01, 0.00000000E+00,
  0.78026740E+03, 0.163E+03, 0.110E+02, 0.18286000E+01, 0.00000000E+00,
  0.58523670E+03, 0.163E+03, 0.120E+02, 0.18286000E+01, 0.00000000E+00,
  0.53437570E+03, 0.163E+03, 0.130E+02, 0.18286000E+01, 0.00000000E+00,
  0.41591500E+03, 0.163E+03, 0.140E+02, 0.18286000E+01, 0.00000000E+00,
  0.32121200E+03, 0.163E+03, 0.150E+02, 0.18286000E+01, 0.00000000E+00,
  0.26508690E+03, 0.163E+03, 0.160E+02, 0.18286000E+01, 0.00000000E+00,
  0.21546030E+03, 0.163E+03, 0.170E+02, 0.18286000E+01, 0.00000000E+00,
  0.17559080E+03, 0.163E+03, 0.180E+02, 0.18286000E+01, 0.00000000E+00,
  0.12856965E+04, 0.163E+03, 0.190E+02, 0.18286000E+01, 0.00000000E+00,
  0.10394662E+04, 0.163E+03, 0.200E+02, 0.18286000E+01, 0.00000000E+00,
  0.85482160E+03, 0.163E+03, 0.210E+02, 0.18286000E+01, 0.00000000E+00,
  0.82218100E+03, 0.163E+03, 0.220E+02, 0.18286000E+01, 0.00000000E+00,
  0.75108930E+03, 0.163E+03, 0.230E+02, 0.18286000E+01, 0.00000000E+00,
  0.59166600E+03, 0.163E+03, 0.240E+02, 0.18286000E+01, 0.00000000E+00,
  0.64444210E+03, 0.163E+03, 0.250E+02, 0.18286000E+01, 0.00000000E+00,
  0.50560640E+03, 0.163E+03, 0.260E+02, 0.18286000E+01, 0.00000000E+00,
  0.53300400E+03, 0.163E+03, 0.270E+02, 0.18286000E+01, 0.00000000E+00,
  0.55039520E+03, 0.163E+03, 0.280E+02, 0.18286000E+01, 0.00000000E+00,
  0.42213760E+03, 0.163E+03, 0.290E+02, 0.18286000E+01, 0.00000000E+00,
  0.42993040E+03, 0.163E+03, 0.300E+02, 0.18286000E+01, 0.00000000E+00,
  0.51021570E+03, 0.163E+03, 0.310E+02, 0.18286000E+01, 0.00000000E+00,
  0.44563750E+03, 0.163E+03, 0.320E+02, 0.18286000E+01, 0.00000000E+00,
  0.37699910E+03, 0.163E+03, 0.330E+02, 0.18286000E+01, 0.00000000E+00,
  0.33669100E+03, 0.163E+03, 0.340E+02, 0.18286000E+01, 0.00000000E+00,
  0.29330360E+03, 0.163E+03, 0.350E+02, 0.18286000E+01, 0.00000000E+00,
  0.25408590E+03, 0.163E+03, 0.360E+02, 0.18286000E+01, 0.00000000E+00,
  0.14385445E+04, 0.163E+03, 0.370E+02, 0.18286000E+01, 0.00000000E+00,
  0.12395504E+04, 0.163E+03, 0.380E+02, 0.18286000E+01, 0.00000000E+00,
  0.10770858E+04, 0.163E+03, 0.390E+02, 0.18286000E+01, 0.00000000E+00,
  0.96327150E+03, 0.163E+03, 0.400E+02, 0.18286000E+01, 0.00000000E+00,
  0.87559310E+03, 0.163E+03, 0.410E+02, 0.18286000E+01, 0.00000000E+00,
  0.67249140E+03, 0.163E+03, 0.420E+02, 0.18286000E+01, 0.00000000E+00,
  0.75175670E+03, 0.163E+03, 0.430E+02, 0.18286000E+01, 0.00000000E+00,
  0.56950600E+03, 0.163E+03, 0.440E+02, 0.18286000E+01, 0.00000000E+00,
  0.62232140E+03, 0.163E+03, 0.450E+02, 0.18286000E+01, 0.00000000E+00,
  0.57599650E+03, 0.163E+03, 0.460E+02, 0.18286000E+01, 0.00000000E+00,
  0.48115240E+03, 0.163E+03, 0.470E+02, 0.18286000E+01, 0.00000000E+00,
  0.50633030E+03, 0.163E+03, 0.480E+02, 0.18286000E+01, 0.00000000E+00,
  0.63922390E+03, 0.163E+03, 0.490E+02, 0.18286000E+01, 0.00000000E+00,
  0.58633170E+03, 0.163E+03, 0.500E+02, 0.18286000E+01, 0.00000000E+00,
  0.51859750E+03, 0.163E+03, 0.510E+02, 0.18286000E+01, 0.00000000E+00,
  0.47906490E+03, 0.163E+03, 0.520E+02, 0.18286000E+01, 0.00000000E+00,
  0.43122670E+03, 0.163E+03, 0.530E+02, 0.18286000E+01, 0.00000000E+00,
  0.38614600E+03, 0.163E+03, 0.540E+02, 0.18286000E+01, 0.00000000E+00,
  0.17518319E+04, 0.163E+03, 0.550E+02, 0.18286000E+01, 0.00000000E+00,
  0.15845929E+04, 0.163E+03, 0.560E+02, 0.18286000E+01, 0.00000000E+00,
  0.13809239E+04, 0.163E+03, 0.570E+02, 0.18286000E+01, 0.00000000E+00,
  0.61365370E+03, 0.163E+03, 0.580E+02, 0.18286000E+01, 0.27991000E+01,
  0.14003880E+04, 0.163E+03, 0.590E+02, 0.18286000E+01, 0.00000000E+00,
  0.13429247E+04, 0.163E+03, 0.600E+02, 0.18286000E+01, 0.00000000E+00,
  0.13087424E+04, 0.163E+03, 0.610E+02, 0.18286000E+01, 0.00000000E+00,
  0.12773568E+04, 0.163E+03, 0.620E+02, 0.18286000E+01, 0.00000000E+00,
  0.12495054E+04, 0.163E+03, 0.630E+02, 0.18286000E+01, 0.00000000E+00,
  0.97406900E+03, 0.163E+03, 0.640E+02, 0.18286000E+01, 0.00000000E+00,
  0.11111877E+04, 0.163E+03, 0.650E+02, 0.18286000E+01, 0.00000000E+00,
  0.10699921E+04, 0.163E+03, 0.660E+02, 0.18286000E+01, 0.00000000E+00,
  0.11246771E+04, 0.163E+03, 0.670E+02, 0.18286000E+01, 0.00000000E+00,
  0.11005512E+04, 0.163E+03, 0.680E+02, 0.18286000E+01, 0.00000000E+00,
  0.10786794E+04, 0.163E+03, 0.690E+02, 0.18286000E+01, 0.00000000E+00,
  0.10664387E+04, 0.163E+03, 0.700E+02, 0.18286000E+01, 0.00000000E+00,
  0.89316870E+03, 0.163E+03, 0.710E+02, 0.18286000E+01, 0.00000000E+00,
  0.87110070E+03, 0.163E+03, 0.720E+02, 0.18286000E+01, 0.00000000E+00,
  0.79118140E+03, 0.163E+03, 0.730E+02, 0.18286000E+01, 0.00000000E+00,
  0.66583170E+03, 0.163E+03, 0.740E+02, 0.18286000E+01, 0.00000000E+00,
  0.67605760E+03, 0.163E+03, 0.750E+02, 0.18286000E+01, 0.00000000E+00,
  0.61029470E+03, 0.163E+03, 0.760E+02, 0.18286000E+01, 0.00000000E+00,
  0.55718050E+03, 0.163E+03, 0.770E+02, 0.18286000E+01, 0.00000000E+00,
  0.46153520E+03, 0.163E+03, 0.780E+02, 0.18286000E+01, 0.00000000E+00,
  0.43073110E+03, 0.163E+03, 0.790E+02, 0.18286000E+01, 0.00000000E+00,
  0.44232070E+03, 0.163E+03, 0.800E+02, 0.18286000E+01, 0.00000000E+00,
  0.65532760E+03, 0.163E+03, 0.810E+02, 0.18286000E+01, 0.00000000E+00,
  0.63664300E+03, 0.163E+03, 0.820E+02, 0.18286000E+01, 0.00000000E+00,
  0.58099830E+03, 0.163E+03, 0.830E+02, 0.18286000E+01, 0.00000000E+00,
  0.55199550E+03, 0.163E+03, 0.840E+02, 0.18286000E+01, 0.00000000E+00,
  0.50719420E+03, 0.163E+03, 0.850E+02, 0.18286000E+01, 0.00000000E+00,
  0.46310600E+03, 0.163E+03, 0.860E+02, 0.18286000E+01, 0.00000000E+00,
  0.16436058E+04, 0.163E+03, 0.870E+02, 0.18286000E+01, 0.00000000E+00,
  0.15604236E+04, 0.163E+03, 0.880E+02, 0.18286000E+01, 0.00000000E+00,
  0.13690464E+04, 0.163E+03, 0.890E+02, 0.18286000E+01, 0.00000000E+00,
  0.12201277E+04, 0.163E+03, 0.900E+02, 0.18286000E+01, 0.00000000E+00,
  0.12166738E+04, 0.163E+03, 0.910E+02, 0.18286000E+01, 0.00000000E+00,
  0.11778612E+04, 0.163E+03, 0.920E+02, 0.18286000E+01, 0.00000000E+00,
  0.12191450E+04, 0.163E+03, 0.930E+02, 0.18286000E+01, 0.00000000E+00,
  0.11794690E+04, 0.163E+03, 0.940E+02, 0.18286000E+01, 0.00000000E+00,
  0.63762900E+02, 0.163E+03, 0.101E+03, 0.18286000E+01, 0.00000000E+00,
  0.21174000E+03, 0.163E+03, 0.103E+03, 0.18286000E+01, 0.98650000E+00,
  0.26923050E+03, 0.163E+03, 0.104E+03, 0.18286000E+01, 0.98080000E+00,
  0.20261480E+03, 0.163E+03, 0.105E+03, 0.18286000E+01, 0.97060000E+00,
  0.15147130E+03, 0.163E+03, 0.106E+03, 0.18286000E+01, 0.98680000E+00,
  0.10450970E+03, 0.163E+03, 0.107E+03, 0.18286000E+01, 0.99440000E+00,
  0.75690800E+02, 0.163E+03, 0.108E+03, 0.18286000E+01, 0.99250000E+00,
  0.51755700E+02, 0.163E+03, 0.109E+03, 0.18286000E+01, 0.99820000E+00,
  0.31068640E+03, 0.163E+03, 0.111E+03, 0.18286000E+01, 0.96840000E+00,
  0.48112160E+03, 0.163E+03, 0.112E+03, 0.18286000E+01, 0.96280000E+00,
  0.48324150E+03, 0.163E+03, 0.113E+03, 0.18286000E+01, 0.96480000E+00,
  0.38377640E+03, 0.163E+03, 0.114E+03, 0.18286000E+01, 0.95070000E+00,
  0.31171580E+03, 0.163E+03, 0.115E+03, 0.18286000E+01, 0.99470000E+00,
  0.26222190E+03, 0.163E+03, 0.116E+03, 0.18286000E+01, 0.99480000E+00,
  0.21326140E+03, 0.163E+03, 0.117E+03, 0.18286000E+01, 0.99720000E+00,
  0.42593700E+03, 0.163E+03, 0.119E+03, 0.18286000E+01, 0.97670000E+00,
  0.83127500E+03, 0.163E+03, 0.120E+03, 0.18286000E+01, 0.98310000E+00,
  0.42169690E+03, 0.163E+03, 0.121E+03, 0.18286000E+01, 0.18627000E+01,
  0.40700940E+03, 0.163E+03, 0.122E+03, 0.18286000E+01, 0.18299000E+01,
  0.39898160E+03, 0.163E+03, 0.123E+03, 0.18286000E+01, 0.19138000E+01,
  0.39579870E+03, 0.163E+03, 0.124E+03, 0.18286000E+01, 0.18269000E+01,
  0.36204930E+03, 0.163E+03, 0.125E+03, 0.18286000E+01, 0.16406000E+01,
  0.33456150E+03, 0.163E+03, 0.126E+03, 0.18286000E+01, 0.16483000E+01,
  0.31919930E+03, 0.163E+03, 0.127E+03, 0.18286000E+01, 0.17149000E+01,
  0.31222210E+03, 0.163E+03, 0.128E+03, 0.18286000E+01, 0.17937000E+01,
  0.30989590E+03, 0.163E+03, 0.129E+03, 0.18286000E+01, 0.95760000E+00,
  0.28840040E+03, 0.163E+03, 0.130E+03, 0.18286000E+01, 0.19419000E+01,
  0.47803960E+03, 0.163E+03, 0.131E+03, 0.18286000E+01, 0.96010000E+00,
  0.41601900E+03, 0.163E+03, 0.132E+03, 0.18286000E+01, 0.94340000E+00,
  0.37044180E+03, 0.163E+03, 0.133E+03, 0.18286000E+01, 0.98890000E+00,
  0.33685390E+03, 0.163E+03, 0.134E+03, 0.18286000E+01, 0.99010000E+00,
  0.29542100E+03, 0.163E+03, 0.135E+03, 0.18286000E+01, 0.99740000E+00,
  0.50722850E+03, 0.163E+03, 0.137E+03, 0.18286000E+01, 0.97380000E+00,
  0.10128078E+04, 0.163E+03, 0.138E+03, 0.18286000E+01, 0.98010000E+00,
  0.76200330E+03, 0.163E+03, 0.139E+03, 0.18286000E+01, 0.19153000E+01,
  0.55829510E+03, 0.163E+03, 0.140E+03, 0.18286000E+01, 0.19355000E+01,
  0.56398160E+03, 0.163E+03, 0.141E+03, 0.18286000E+01, 0.19545000E+01,
  0.52490850E+03, 0.163E+03, 0.142E+03, 0.18286000E+01, 0.19420000E+01,
  0.59323860E+03, 0.163E+03, 0.143E+03, 0.18286000E+01, 0.16682000E+01,
  0.45513890E+03, 0.163E+03, 0.144E+03, 0.18286000E+01, 0.18584000E+01,
  0.42567220E+03, 0.163E+03, 0.145E+03, 0.18286000E+01, 0.19003000E+01,
  0.39496580E+03, 0.163E+03, 0.146E+03, 0.18286000E+01, 0.18630000E+01,
  0.38242790E+03, 0.163E+03, 0.147E+03, 0.18286000E+01, 0.96790000E+00,
  0.37661900E+03, 0.163E+03, 0.148E+03, 0.18286000E+01, 0.19539000E+01,
  0.60761490E+03, 0.163E+03, 0.149E+03, 0.18286000E+01, 0.96330000E+00,
  0.54518900E+03, 0.163E+03, 0.150E+03, 0.18286000E+01, 0.95140000E+00,
  0.50775680E+03, 0.163E+03, 0.151E+03, 0.18286000E+01, 0.97490000E+00,
  0.47858010E+03, 0.163E+03, 0.152E+03, 0.18286000E+01, 0.98110000E+00,
  0.43529630E+03, 0.163E+03, 0.153E+03, 0.18286000E+01, 0.99680000E+00,
  0.59594990E+03, 0.163E+03, 0.155E+03, 0.18286000E+01, 0.99090000E+00,
  0.13176067E+04, 0.163E+03, 0.156E+03, 0.18286000E+01, 0.97970000E+00,
  0.96582370E+03, 0.163E+03, 0.157E+03, 0.18286000E+01, 0.19373000E+01,
  0.59490700E+03, 0.163E+03, 0.159E+03, 0.18286000E+01, 0.29425000E+01,
  0.58256410E+03, 0.163E+03, 0.160E+03, 0.18286000E+01, 0.29455000E+01,
  0.56390150E+03, 0.163E+03, 0.161E+03, 0.18286000E+01, 0.29413000E+01,
  0.56731710E+03, 0.163E+03, 0.162E+03, 0.18286000E+01, 0.29300000E+01,
  0.54902810E+03, 0.163E+03, 0.163E+03, 0.18286000E+01, 0.18286000E+01,
  0.41327500E+02, 0.164E+03, 0.100E+01, 0.28732000E+01, 0.91180000E+00,
  0.27159500E+02, 0.164E+03, 0.200E+01, 0.28732000E+01, 0.00000000E+00,
  0.65909240E+03, 0.164E+03, 0.300E+01, 0.28732000E+01, 0.00000000E+00,
  0.37646100E+03, 0.164E+03, 0.400E+01, 0.28732000E+01, 0.00000000E+00,
  0.25184240E+03, 0.164E+03, 0.500E+01, 0.28732000E+01, 0.00000000E+00,
  0.16931590E+03, 0.164E+03, 0.600E+01, 0.28732000E+01, 0.00000000E+00,
  0.11799770E+03, 0.164E+03, 0.700E+01, 0.28732000E+01, 0.00000000E+00,
  0.89135900E+02, 0.164E+03, 0.800E+01, 0.28732000E+01, 0.00000000E+00,
  0.67403000E+02, 0.164E+03, 0.900E+01, 0.28732000E+01, 0.00000000E+00,
  0.51775600E+02, 0.164E+03, 0.100E+02, 0.28732000E+01, 0.00000000E+00,
  0.78761870E+03, 0.164E+03, 0.110E+02, 0.28732000E+01, 0.00000000E+00,
  0.60103840E+03, 0.164E+03, 0.120E+02, 0.28732000E+01, 0.00000000E+00,
  0.55215450E+03, 0.164E+03, 0.130E+02, 0.28732000E+01, 0.00000000E+00,
  0.43306620E+03, 0.164E+03, 0.140E+02, 0.28732000E+01, 0.00000000E+00,
  0.33637000E+03, 0.164E+03, 0.150E+02, 0.28732000E+01, 0.00000000E+00,
  0.27845510E+03, 0.164E+03, 0.160E+02, 0.28732000E+01, 0.00000000E+00,
  0.22691090E+03, 0.164E+03, 0.170E+02, 0.28732000E+01, 0.00000000E+00,
  0.18526210E+03, 0.164E+03, 0.180E+02, 0.28732000E+01, 0.00000000E+00,
  0.12927733E+04, 0.164E+03, 0.190E+02, 0.28732000E+01, 0.00000000E+00,
  0.10597192E+04, 0.164E+03, 0.200E+02, 0.28732000E+01, 0.00000000E+00,
  0.87413140E+03, 0.164E+03, 0.210E+02, 0.28732000E+01, 0.00000000E+00,
  0.84288400E+03, 0.164E+03, 0.220E+02, 0.28732000E+01, 0.00000000E+00,
  0.77118400E+03, 0.164E+03, 0.230E+02, 0.28732000E+01, 0.00000000E+00,
  0.60734870E+03, 0.164E+03, 0.240E+02, 0.28732000E+01, 0.00000000E+00,
  0.66313130E+03, 0.164E+03, 0.250E+02, 0.28732000E+01, 0.00000000E+00,
  0.52025690E+03, 0.164E+03, 0.260E+02, 0.28732000E+01, 0.00000000E+00,
  0.55050450E+03, 0.164E+03, 0.270E+02, 0.28732000E+01, 0.00000000E+00,
  0.56760260E+03, 0.164E+03, 0.280E+02, 0.28732000E+01, 0.00000000E+00,
  0.43508290E+03, 0.164E+03, 0.290E+02, 0.28732000E+01, 0.00000000E+00,
  0.44549820E+03, 0.164E+03, 0.300E+02, 0.28732000E+01, 0.00000000E+00,
  0.52813050E+03, 0.164E+03, 0.310E+02, 0.28732000E+01, 0.00000000E+00,
  0.46406710E+03, 0.164E+03, 0.320E+02, 0.28732000E+01, 0.00000000E+00,
  0.39450330E+03, 0.164E+03, 0.330E+02, 0.28732000E+01, 0.00000000E+00,
  0.35325210E+03, 0.164E+03, 0.340E+02, 0.28732000E+01, 0.00000000E+00,
  0.30847630E+03, 0.164E+03, 0.350E+02, 0.28732000E+01, 0.00000000E+00,
  0.26774640E+03, 0.164E+03, 0.360E+02, 0.28732000E+01, 0.00000000E+00,
  0.14479360E+04, 0.164E+03, 0.370E+02, 0.28732000E+01, 0.00000000E+00,
  0.12628491E+04, 0.164E+03, 0.380E+02, 0.28732000E+01, 0.00000000E+00,
  0.11030742E+04, 0.164E+03, 0.390E+02, 0.28732000E+01, 0.00000000E+00,
  0.98959400E+03, 0.164E+03, 0.400E+02, 0.28732000E+01, 0.00000000E+00,
  0.90127470E+03, 0.164E+03, 0.410E+02, 0.28732000E+01, 0.00000000E+00,
  0.69429580E+03, 0.164E+03, 0.420E+02, 0.28732000E+01, 0.00000000E+00,
  0.77529730E+03, 0.164E+03, 0.430E+02, 0.28732000E+01, 0.00000000E+00,
  0.58924130E+03, 0.164E+03, 0.440E+02, 0.28732000E+01, 0.00000000E+00,
  0.64413130E+03, 0.164E+03, 0.450E+02, 0.28732000E+01, 0.00000000E+00,
  0.59686540E+03, 0.164E+03, 0.460E+02, 0.28732000E+01, 0.00000000E+00,
  0.49784100E+03, 0.164E+03, 0.470E+02, 0.28732000E+01, 0.00000000E+00,
  0.52541210E+03, 0.164E+03, 0.480E+02, 0.28732000E+01, 0.00000000E+00,
  0.66098150E+03, 0.164E+03, 0.490E+02, 0.28732000E+01, 0.00000000E+00,
  0.60940140E+03, 0.164E+03, 0.500E+02, 0.28732000E+01, 0.00000000E+00,
  0.54146000E+03, 0.164E+03, 0.510E+02, 0.28732000E+01, 0.00000000E+00,
  0.50144410E+03, 0.164E+03, 0.520E+02, 0.28732000E+01, 0.00000000E+00,
  0.45249160E+03, 0.164E+03, 0.530E+02, 0.28732000E+01, 0.00000000E+00,
  0.40604790E+03, 0.164E+03, 0.540E+02, 0.28732000E+01, 0.00000000E+00,
  0.17636917E+04, 0.164E+03, 0.550E+02, 0.28732000E+01, 0.00000000E+00,
  0.16113765E+04, 0.164E+03, 0.560E+02, 0.28732000E+01, 0.00000000E+00,
  0.14116458E+04, 0.164E+03, 0.570E+02, 0.28732000E+01, 0.00000000E+00,
  0.63999700E+03, 0.164E+03, 0.580E+02, 0.28732000E+01, 0.27991000E+01,
  0.14263405E+04, 0.164E+03, 0.590E+02, 0.28732000E+01, 0.00000000E+00,
  0.13689945E+04, 0.164E+03, 0.600E+02, 0.28732000E+01, 0.00000000E+00,
  0.13344823E+04, 0.164E+03, 0.610E+02, 0.28732000E+01, 0.00000000E+00,
  0.13027626E+04, 0.164E+03, 0.620E+02, 0.28732000E+01, 0.00000000E+00,
  0.12746283E+04, 0.164E+03, 0.630E+02, 0.28732000E+01, 0.00000000E+00,
  0.99906170E+03, 0.164E+03, 0.640E+02, 0.28732000E+01, 0.00000000E+00,
  0.11300310E+04, 0.164E+03, 0.650E+02, 0.28732000E+01, 0.00000000E+00,
  0.10892614E+04, 0.164E+03, 0.660E+02, 0.28732000E+01, 0.00000000E+00,
  0.11488304E+04, 0.164E+03, 0.670E+02, 0.28732000E+01, 0.00000000E+00,
  0.11243657E+04, 0.164E+03, 0.680E+02, 0.28732000E+01, 0.00000000E+00,
  0.11022614E+04, 0.164E+03, 0.690E+02, 0.28732000E+01, 0.00000000E+00,
  0.10895200E+04, 0.164E+03, 0.700E+02, 0.28732000E+01, 0.00000000E+00,
  0.91593800E+03, 0.164E+03, 0.710E+02, 0.28732000E+01, 0.00000000E+00,
  0.89812800E+03, 0.164E+03, 0.720E+02, 0.28732000E+01, 0.00000000E+00,
  0.81811890E+03, 0.164E+03, 0.730E+02, 0.28732000E+01, 0.00000000E+00,
  0.68977370E+03, 0.164E+03, 0.740E+02, 0.28732000E+01, 0.00000000E+00,
  0.70124130E+03, 0.164E+03, 0.750E+02, 0.28732000E+01, 0.00000000E+00,
  0.63451700E+03, 0.164E+03, 0.760E+02, 0.28732000E+01, 0.00000000E+00,
  0.58034520E+03, 0.164E+03, 0.770E+02, 0.28732000E+01, 0.00000000E+00,
  0.48140120E+03, 0.164E+03, 0.780E+02, 0.28732000E+01, 0.00000000E+00,
  0.44951810E+03, 0.164E+03, 0.790E+02, 0.28732000E+01, 0.00000000E+00,
  0.46216400E+03, 0.164E+03, 0.800E+02, 0.28732000E+01, 0.00000000E+00,
  0.67804940E+03, 0.164E+03, 0.810E+02, 0.28732000E+01, 0.00000000E+00,
  0.66143650E+03, 0.164E+03, 0.820E+02, 0.28732000E+01, 0.00000000E+00,
  0.60616090E+03, 0.164E+03, 0.830E+02, 0.28732000E+01, 0.00000000E+00,
  0.57721150E+03, 0.164E+03, 0.840E+02, 0.28732000E+01, 0.00000000E+00,
  0.53169500E+03, 0.164E+03, 0.850E+02, 0.28732000E+01, 0.00000000E+00,
  0.48648120E+03, 0.164E+03, 0.860E+02, 0.28732000E+01, 0.00000000E+00,
  0.16615027E+04, 0.164E+03, 0.870E+02, 0.28732000E+01, 0.00000000E+00,
  0.15910020E+04, 0.164E+03, 0.880E+02, 0.28732000E+01, 0.00000000E+00,
  0.14026190E+04, 0.164E+03, 0.890E+02, 0.28732000E+01, 0.00000000E+00,
  0.12565351E+04, 0.164E+03, 0.900E+02, 0.28732000E+01, 0.00000000E+00,
  0.12494197E+04, 0.164E+03, 0.910E+02, 0.28732000E+01, 0.00000000E+00,
  0.12096721E+04, 0.164E+03, 0.920E+02, 0.28732000E+01, 0.00000000E+00,
  0.12478750E+04, 0.164E+03, 0.930E+02, 0.28732000E+01, 0.00000000E+00,
  0.12080168E+04, 0.164E+03, 0.940E+02, 0.28732000E+01, 0.00000000E+00,
  0.66823500E+02, 0.164E+03, 0.101E+03, 0.28732000E+01, 0.00000000E+00,
  0.21861950E+03, 0.164E+03, 0.103E+03, 0.28732000E+01, 0.98650000E+00,
  0.27850800E+03, 0.164E+03, 0.104E+03, 0.28732000E+01, 0.98080000E+00,
  0.21154850E+03, 0.164E+03, 0.105E+03, 0.28732000E+01, 0.97060000E+00,
  0.15883010E+03, 0.164E+03, 0.106E+03, 0.28732000E+01, 0.98680000E+00,
  0.11002650E+03, 0.164E+03, 0.107E+03, 0.28732000E+01, 0.99440000E+00,
  0.79894900E+02, 0.164E+03, 0.108E+03, 0.28732000E+01, 0.99250000E+00,
  0.54760000E+02, 0.164E+03, 0.109E+03, 0.28732000E+01, 0.99820000E+00,
  0.31995720E+03, 0.164E+03, 0.111E+03, 0.28732000E+01, 0.96840000E+00,
  0.49511470E+03, 0.164E+03, 0.112E+03, 0.28732000E+01, 0.96280000E+00,
  0.49998200E+03, 0.164E+03, 0.113E+03, 0.28732000E+01, 0.96480000E+00,
  0.39998160E+03, 0.164E+03, 0.114E+03, 0.28732000E+01, 0.95070000E+00,
  0.32645920E+03, 0.164E+03, 0.115E+03, 0.28732000E+01, 0.99470000E+00,
  0.27540540E+03, 0.164E+03, 0.116E+03, 0.28732000E+01, 0.99480000E+00,
  0.22456980E+03, 0.164E+03, 0.117E+03, 0.28732000E+01, 0.99720000E+00,
  0.43997650E+03, 0.164E+03, 0.119E+03, 0.28732000E+01, 0.97670000E+00,
  0.84744860E+03, 0.164E+03, 0.120E+03, 0.28732000E+01, 0.98310000E+00,
  0.43855500E+03, 0.164E+03, 0.121E+03, 0.28732000E+01, 0.18627000E+01,
  0.42330690E+03, 0.164E+03, 0.122E+03, 0.28732000E+01, 0.18299000E+01,
  0.41487410E+03, 0.164E+03, 0.123E+03, 0.28732000E+01, 0.19138000E+01,
  0.41122300E+03, 0.164E+03, 0.124E+03, 0.28732000E+01, 0.18269000E+01,
  0.37757470E+03, 0.164E+03, 0.125E+03, 0.28732000E+01, 0.16406000E+01,
  0.34920950E+03, 0.164E+03, 0.126E+03, 0.28732000E+01, 0.16483000E+01,
  0.33312400E+03, 0.164E+03, 0.127E+03, 0.28732000E+01, 0.17149000E+01,
  0.32573280E+03, 0.164E+03, 0.128E+03, 0.28732000E+01, 0.17937000E+01,
  0.32237280E+03, 0.164E+03, 0.129E+03, 0.28732000E+01, 0.95760000E+00,
  0.30155830E+03, 0.164E+03, 0.130E+03, 0.28732000E+01, 0.19419000E+01,
  0.49556680E+03, 0.164E+03, 0.131E+03, 0.28732000E+01, 0.96010000E+00,
  0.43376750E+03, 0.164E+03, 0.132E+03, 0.28732000E+01, 0.94340000E+00,
  0.38773360E+03, 0.164E+03, 0.133E+03, 0.28732000E+01, 0.98890000E+00,
  0.35339890E+03, 0.164E+03, 0.134E+03, 0.28732000E+01, 0.99010000E+00,
  0.31065690E+03, 0.164E+03, 0.135E+03, 0.28732000E+01, 0.99740000E+00,
  0.52453740E+03, 0.164E+03, 0.137E+03, 0.28732000E+01, 0.97380000E+00,
  0.10315808E+04, 0.164E+03, 0.138E+03, 0.28732000E+01, 0.98010000E+00,
  0.78404790E+03, 0.164E+03, 0.139E+03, 0.28732000E+01, 0.19153000E+01,
  0.58016290E+03, 0.164E+03, 0.140E+03, 0.28732000E+01, 0.19355000E+01,
  0.58594010E+03, 0.164E+03, 0.141E+03, 0.28732000E+01, 0.19545000E+01,
  0.54592550E+03, 0.164E+03, 0.142E+03, 0.28732000E+01, 0.19420000E+01,
  0.61398170E+03, 0.164E+03, 0.143E+03, 0.28732000E+01, 0.16682000E+01,
  0.47485900E+03, 0.164E+03, 0.144E+03, 0.28732000E+01, 0.18584000E+01,
  0.44414170E+03, 0.164E+03, 0.145E+03, 0.28732000E+01, 0.19003000E+01,
  0.41225320E+03, 0.164E+03, 0.146E+03, 0.28732000E+01, 0.18630000E+01,
  0.39892850E+03, 0.164E+03, 0.147E+03, 0.28732000E+01, 0.96790000E+00,
  0.39401610E+03, 0.164E+03, 0.148E+03, 0.28732000E+01, 0.19539000E+01,
  0.62938940E+03, 0.164E+03, 0.149E+03, 0.28732000E+01, 0.96330000E+00,
  0.56763680E+03, 0.164E+03, 0.150E+03, 0.28732000E+01, 0.95140000E+00,
  0.53044640E+03, 0.164E+03, 0.151E+03, 0.28732000E+01, 0.97490000E+00,
  0.50102050E+03, 0.164E+03, 0.152E+03, 0.28732000E+01, 0.98110000E+00,
  0.45675320E+03, 0.164E+03, 0.153E+03, 0.28732000E+01, 0.99680000E+00,
  0.61885080E+03, 0.164E+03, 0.155E+03, 0.28732000E+01, 0.99090000E+00,
  0.13390290E+04, 0.164E+03, 0.156E+03, 0.28732000E+01, 0.97970000E+00,
  0.99282930E+03, 0.164E+03, 0.157E+03, 0.28732000E+01, 0.19373000E+01,
  0.62058810E+03, 0.164E+03, 0.159E+03, 0.28732000E+01, 0.29425000E+01,
  0.60773400E+03, 0.164E+03, 0.160E+03, 0.28732000E+01, 0.29455000E+01,
  0.58838130E+03, 0.164E+03, 0.161E+03, 0.28732000E+01, 0.29413000E+01,
  0.59153680E+03, 0.164E+03, 0.162E+03, 0.28732000E+01, 0.29300000E+01,
  0.57104500E+03, 0.164E+03, 0.163E+03, 0.28732000E+01, 0.18286000E+01,
  0.59536280E+03, 0.164E+03, 0.164E+03, 0.28732000E+01, 0.28732000E+01,
  0.38915000E+02, 0.165E+03, 0.100E+01, 0.29086000E+01, 0.91180000E+00,
  0.25669500E+02, 0.165E+03, 0.200E+01, 0.29086000E+01, 0.00000000E+00,
  0.61281660E+03, 0.165E+03, 0.300E+01, 0.29086000E+01, 0.00000000E+00,
  0.35207530E+03, 0.165E+03, 0.400E+01, 0.29086000E+01, 0.00000000E+00,
  0.23626590E+03, 0.165E+03, 0.500E+01, 0.29086000E+01, 0.00000000E+00,
  0.15924220E+03, 0.165E+03, 0.600E+01, 0.29086000E+01, 0.00000000E+00,
  0.11120430E+03, 0.165E+03, 0.700E+01, 0.29086000E+01, 0.00000000E+00,
  0.84136300E+02, 0.165E+03, 0.800E+01, 0.29086000E+01, 0.00000000E+00,
  0.63715200E+02, 0.165E+03, 0.900E+01, 0.29086000E+01, 0.00000000E+00,
  0.49005000E+02, 0.165E+03, 0.100E+02, 0.29086000E+01, 0.00000000E+00,
  0.73264570E+03, 0.165E+03, 0.110E+02, 0.29086000E+01, 0.00000000E+00,
  0.56159910E+03, 0.165E+03, 0.120E+02, 0.29086000E+01, 0.00000000E+00,
  0.51672630E+03, 0.165E+03, 0.130E+02, 0.29086000E+01, 0.00000000E+00,
  0.40615220E+03, 0.165E+03, 0.140E+02, 0.29086000E+01, 0.00000000E+00,
  0.31605550E+03, 0.165E+03, 0.150E+02, 0.29086000E+01, 0.00000000E+00,
  0.26197720E+03, 0.165E+03, 0.160E+02, 0.29086000E+01, 0.00000000E+00,
  0.21376170E+03, 0.165E+03, 0.170E+02, 0.29086000E+01, 0.00000000E+00,
  0.17473800E+03, 0.165E+03, 0.180E+02, 0.29086000E+01, 0.00000000E+00,
  0.12013307E+04, 0.165E+03, 0.190E+02, 0.29086000E+01, 0.00000000E+00,
  0.98850950E+03, 0.165E+03, 0.200E+02, 0.29086000E+01, 0.00000000E+00,
  0.81603910E+03, 0.165E+03, 0.210E+02, 0.29086000E+01, 0.00000000E+00,
  0.78743780E+03, 0.165E+03, 0.220E+02, 0.29086000E+01, 0.00000000E+00,
  0.72076790E+03, 0.165E+03, 0.230E+02, 0.29086000E+01, 0.00000000E+00,
  0.56775360E+03, 0.165E+03, 0.240E+02, 0.29086000E+01, 0.00000000E+00,
  0.62017110E+03, 0.165E+03, 0.250E+02, 0.29086000E+01, 0.00000000E+00,
  0.48669710E+03, 0.165E+03, 0.260E+02, 0.29086000E+01, 0.00000000E+00,
  0.51538390E+03, 0.165E+03, 0.270E+02, 0.29086000E+01, 0.00000000E+00,
  0.53115950E+03, 0.165E+03, 0.280E+02, 0.29086000E+01, 0.00000000E+00,
  0.40724140E+03, 0.165E+03, 0.290E+02, 0.29086000E+01, 0.00000000E+00,
  0.41747630E+03, 0.165E+03, 0.300E+02, 0.29086000E+01, 0.00000000E+00,
  0.49461700E+03, 0.165E+03, 0.310E+02, 0.29086000E+01, 0.00000000E+00,
  0.43533390E+03, 0.165E+03, 0.320E+02, 0.29086000E+01, 0.00000000E+00,
  0.37064210E+03, 0.165E+03, 0.330E+02, 0.29086000E+01, 0.00000000E+00,
  0.33221730E+03, 0.165E+03, 0.340E+02, 0.29086000E+01, 0.00000000E+00,
  0.29041790E+03, 0.165E+03, 0.350E+02, 0.29086000E+01, 0.00000000E+00,
  0.25233250E+03, 0.165E+03, 0.360E+02, 0.29086000E+01, 0.00000000E+00,
  0.13459552E+04, 0.165E+03, 0.370E+02, 0.29086000E+01, 0.00000000E+00,
  0.11778523E+04, 0.165E+03, 0.380E+02, 0.29086000E+01, 0.00000000E+00,
  0.10302577E+04, 0.165E+03, 0.390E+02, 0.29086000E+01, 0.00000000E+00,
  0.92507300E+03, 0.165E+03, 0.400E+02, 0.29086000E+01, 0.00000000E+00,
  0.84300140E+03, 0.165E+03, 0.410E+02, 0.29086000E+01, 0.00000000E+00,
  0.65010950E+03, 0.165E+03, 0.420E+02, 0.29086000E+01, 0.00000000E+00,
  0.72565600E+03, 0.165E+03, 0.430E+02, 0.29086000E+01, 0.00000000E+00,
  0.55217930E+03, 0.165E+03, 0.440E+02, 0.29086000E+01, 0.00000000E+00,
  0.60356690E+03, 0.165E+03, 0.450E+02, 0.29086000E+01, 0.00000000E+00,
  0.55949210E+03, 0.165E+03, 0.460E+02, 0.29086000E+01, 0.00000000E+00,
  0.46665970E+03, 0.165E+03, 0.470E+02, 0.29086000E+01, 0.00000000E+00,
  0.49276250E+03, 0.165E+03, 0.480E+02, 0.29086000E+01, 0.00000000E+00,
  0.61913660E+03, 0.165E+03, 0.490E+02, 0.29086000E+01, 0.00000000E+00,
  0.57157510E+03, 0.165E+03, 0.500E+02, 0.29086000E+01, 0.00000000E+00,
  0.50851710E+03, 0.165E+03, 0.510E+02, 0.29086000E+01, 0.00000000E+00,
  0.47131940E+03, 0.165E+03, 0.520E+02, 0.29086000E+01, 0.00000000E+00,
  0.42569420E+03, 0.165E+03, 0.530E+02, 0.29086000E+01, 0.00000000E+00,
  0.38234290E+03, 0.165E+03, 0.540E+02, 0.29086000E+01, 0.00000000E+00,
  0.16393995E+04, 0.165E+03, 0.550E+02, 0.29086000E+01, 0.00000000E+00,
  0.15021922E+04, 0.165E+03, 0.560E+02, 0.29086000E+01, 0.00000000E+00,
  0.13178387E+04, 0.165E+03, 0.570E+02, 0.29086000E+01, 0.00000000E+00,
  0.60095180E+03, 0.165E+03, 0.580E+02, 0.29086000E+01, 0.27991000E+01,
  0.13303810E+04, 0.165E+03, 0.590E+02, 0.29086000E+01, 0.00000000E+00,
  0.12772241E+04, 0.165E+03, 0.600E+02, 0.29086000E+01, 0.00000000E+00,
  0.12451109E+04, 0.165E+03, 0.610E+02, 0.29086000E+01, 0.00000000E+00,
  0.12155853E+04, 0.165E+03, 0.620E+02, 0.29086000E+01, 0.00000000E+00,
  0.11893991E+04, 0.165E+03, 0.630E+02, 0.29086000E+01, 0.00000000E+00,
  0.93372280E+03, 0.165E+03, 0.640E+02, 0.29086000E+01, 0.00000000E+00,
  0.10536587E+04, 0.165E+03, 0.650E+02, 0.29086000E+01, 0.00000000E+00,
  0.10158840E+04, 0.165E+03, 0.660E+02, 0.29086000E+01, 0.00000000E+00,
  0.10723978E+04, 0.165E+03, 0.670E+02, 0.29086000E+01, 0.00000000E+00,
  0.10495999E+04, 0.165E+03, 0.680E+02, 0.29086000E+01, 0.00000000E+00,
  0.10290199E+04, 0.165E+03, 0.690E+02, 0.29086000E+01, 0.00000000E+00,
  0.10170572E+04, 0.165E+03, 0.700E+02, 0.29086000E+01, 0.00000000E+00,
  0.85590310E+03, 0.165E+03, 0.710E+02, 0.29086000E+01, 0.00000000E+00,
  0.84038840E+03, 0.165E+03, 0.720E+02, 0.29086000E+01, 0.00000000E+00,
  0.76618830E+03, 0.165E+03, 0.730E+02, 0.29086000E+01, 0.00000000E+00,
  0.64647490E+03, 0.165E+03, 0.740E+02, 0.29086000E+01, 0.00000000E+00,
  0.65742490E+03, 0.165E+03, 0.750E+02, 0.29086000E+01, 0.00000000E+00,
  0.59532710E+03, 0.165E+03, 0.760E+02, 0.29086000E+01, 0.00000000E+00,
  0.54484580E+03, 0.165E+03, 0.770E+02, 0.29086000E+01, 0.00000000E+00,
  0.45230750E+03, 0.165E+03, 0.780E+02, 0.29086000E+01, 0.00000000E+00,
  0.42248760E+03, 0.165E+03, 0.790E+02, 0.29086000E+01, 0.00000000E+00,
  0.43446390E+03, 0.165E+03, 0.800E+02, 0.29086000E+01, 0.00000000E+00,
  0.63542770E+03, 0.165E+03, 0.810E+02, 0.29086000E+01, 0.00000000E+00,
  0.62048770E+03, 0.165E+03, 0.820E+02, 0.29086000E+01, 0.00000000E+00,
  0.56929560E+03, 0.165E+03, 0.830E+02, 0.29086000E+01, 0.00000000E+00,
  0.54247560E+03, 0.165E+03, 0.840E+02, 0.29086000E+01, 0.00000000E+00,
  0.50012070E+03, 0.165E+03, 0.850E+02, 0.29086000E+01, 0.00000000E+00,
  0.45795880E+03, 0.165E+03, 0.860E+02, 0.29086000E+01, 0.00000000E+00,
  0.15463042E+04, 0.165E+03, 0.870E+02, 0.29086000E+01, 0.00000000E+00,
  0.14842932E+04, 0.165E+03, 0.880E+02, 0.29086000E+01, 0.00000000E+00,
  0.13102595E+04, 0.165E+03, 0.890E+02, 0.29086000E+01, 0.00000000E+00,
  0.11755520E+04, 0.165E+03, 0.900E+02, 0.29086000E+01, 0.00000000E+00,
  0.11681093E+04, 0.165E+03, 0.910E+02, 0.29086000E+01, 0.00000000E+00,
  0.11310127E+04, 0.165E+03, 0.920E+02, 0.29086000E+01, 0.00000000E+00,
  0.11657289E+04, 0.165E+03, 0.930E+02, 0.29086000E+01, 0.00000000E+00,
  0.11286850E+04, 0.165E+03, 0.940E+02, 0.29086000E+01, 0.00000000E+00,
  0.62797100E+02, 0.165E+03, 0.101E+03, 0.29086000E+01, 0.00000000E+00,
  0.20455140E+03, 0.165E+03, 0.103E+03, 0.29086000E+01, 0.98650000E+00,
  0.26072450E+03, 0.165E+03, 0.104E+03, 0.29086000E+01, 0.98080000E+00,
  0.19860250E+03, 0.165E+03, 0.105E+03, 0.29086000E+01, 0.97060000E+00,
  0.14938110E+03, 0.165E+03, 0.106E+03, 0.29086000E+01, 0.98680000E+00,
  0.10370340E+03, 0.165E+03, 0.107E+03, 0.29086000E+01, 0.99440000E+00,
  0.75446500E+02, 0.165E+03, 0.108E+03, 0.29086000E+01, 0.99250000E+00,
  0.51841400E+02, 0.165E+03, 0.109E+03, 0.29086000E+01, 0.99820000E+00,
  0.29924680E+03, 0.165E+03, 0.111E+03, 0.29086000E+01, 0.96840000E+00,
  0.46288270E+03, 0.165E+03, 0.112E+03, 0.29086000E+01, 0.96280000E+00,
  0.46808680E+03, 0.165E+03, 0.113E+03, 0.29086000E+01, 0.96480000E+00,
  0.37524590E+03, 0.165E+03, 0.114E+03, 0.29086000E+01, 0.95070000E+00,
  0.30676780E+03, 0.165E+03, 0.115E+03, 0.29086000E+01, 0.99470000E+00,
  0.25910430E+03, 0.165E+03, 0.116E+03, 0.29086000E+01, 0.99480000E+00,
  0.21155470E+03, 0.165E+03, 0.117E+03, 0.29086000E+01, 0.99720000E+00,
  0.41206550E+03, 0.165E+03, 0.119E+03, 0.29086000E+01, 0.97670000E+00,
  0.79052270E+03, 0.165E+03, 0.120E+03, 0.29086000E+01, 0.98310000E+00,
  0.41139690E+03, 0.165E+03, 0.121E+03, 0.29086000E+01, 0.18627000E+01,
  0.39711900E+03, 0.165E+03, 0.122E+03, 0.29086000E+01, 0.18299000E+01,
  0.38920800E+03, 0.165E+03, 0.123E+03, 0.29086000E+01, 0.19138000E+01,
  0.38571070E+03, 0.165E+03, 0.124E+03, 0.29086000E+01, 0.18269000E+01,
  0.35449400E+03, 0.165E+03, 0.125E+03, 0.29086000E+01, 0.16406000E+01,
  0.32797050E+03, 0.165E+03, 0.126E+03, 0.29086000E+01, 0.16483000E+01,
  0.31287350E+03, 0.165E+03, 0.127E+03, 0.29086000E+01, 0.17149000E+01,
  0.30591120E+03, 0.165E+03, 0.128E+03, 0.29086000E+01, 0.17937000E+01,
  0.30254470E+03, 0.165E+03, 0.129E+03, 0.29086000E+01, 0.95760000E+00,
  0.28337650E+03, 0.165E+03, 0.130E+03, 0.29086000E+01, 0.19419000E+01,
  0.46432020E+03, 0.165E+03, 0.131E+03, 0.29086000E+01, 0.96010000E+00,
  0.40707180E+03, 0.165E+03, 0.132E+03, 0.29086000E+01, 0.94340000E+00,
  0.36431690E+03, 0.165E+03, 0.133E+03, 0.29086000E+01, 0.98890000E+00,
  0.33235190E+03, 0.165E+03, 0.134E+03, 0.29086000E+01, 0.99010000E+00,
  0.29245640E+03, 0.165E+03, 0.135E+03, 0.29086000E+01, 0.99740000E+00,
  0.49146210E+03, 0.165E+03, 0.137E+03, 0.29086000E+01, 0.97380000E+00,
  0.96209720E+03, 0.165E+03, 0.138E+03, 0.29086000E+01, 0.98010000E+00,
  0.73326220E+03, 0.165E+03, 0.139E+03, 0.29086000E+01, 0.19153000E+01,
  0.54416190E+03, 0.165E+03, 0.140E+03, 0.29086000E+01, 0.19355000E+01,
  0.54959500E+03, 0.165E+03, 0.141E+03, 0.29086000E+01, 0.19545000E+01,
  0.51226070E+03, 0.165E+03, 0.142E+03, 0.29086000E+01, 0.19420000E+01,
  0.57535150E+03, 0.165E+03, 0.143E+03, 0.29086000E+01, 0.16682000E+01,
  0.44604100E+03, 0.165E+03, 0.144E+03, 0.29086000E+01, 0.18584000E+01,
  0.41725200E+03, 0.165E+03, 0.145E+03, 0.29086000E+01, 0.19003000E+01,
  0.38739090E+03, 0.165E+03, 0.146E+03, 0.29086000E+01, 0.18630000E+01,
  0.37483220E+03, 0.165E+03, 0.147E+03, 0.29086000E+01, 0.96790000E+00,
  0.37045920E+03, 0.165E+03, 0.148E+03, 0.29086000E+01, 0.19539000E+01,
  0.58983000E+03, 0.165E+03, 0.149E+03, 0.29086000E+01, 0.96330000E+00,
  0.53268550E+03, 0.165E+03, 0.150E+03, 0.29086000E+01, 0.95140000E+00,
  0.49826300E+03, 0.165E+03, 0.151E+03, 0.29086000E+01, 0.97490000E+00,
  0.47094350E+03, 0.165E+03, 0.152E+03, 0.29086000E+01, 0.98110000E+00,
  0.42969450E+03, 0.165E+03, 0.153E+03, 0.29086000E+01, 0.99680000E+00,
  0.58038410E+03, 0.165E+03, 0.155E+03, 0.29086000E+01, 0.99090000E+00,
  0.12480182E+04, 0.165E+03, 0.156E+03, 0.29086000E+01, 0.97970000E+00,
  0.92827050E+03, 0.165E+03, 0.157E+03, 0.29086000E+01, 0.19373000E+01,
  0.58277730E+03, 0.165E+03, 0.159E+03, 0.29086000E+01, 0.29425000E+01,
  0.57071750E+03, 0.165E+03, 0.160E+03, 0.29086000E+01, 0.29455000E+01,
  0.55258430E+03, 0.165E+03, 0.161E+03, 0.29086000E+01, 0.29413000E+01,
  0.55542950E+03, 0.165E+03, 0.162E+03, 0.29086000E+01, 0.29300000E+01,
  0.53587600E+03, 0.165E+03, 0.163E+03, 0.29086000E+01, 0.18286000E+01,
  0.55897620E+03, 0.165E+03, 0.164E+03, 0.29086000E+01, 0.28732000E+01,
  0.52491950E+03, 0.165E+03, 0.165E+03, 0.29086000E+01, 0.29086000E+01,
  0.39396700E+02, 0.166E+03, 0.100E+01, 0.28965000E+01, 0.91180000E+00,
  0.25865800E+02, 0.166E+03, 0.200E+01, 0.28965000E+01, 0.00000000E+00,
  0.63848500E+03, 0.166E+03, 0.300E+01, 0.28965000E+01, 0.00000000E+00,
  0.36118220E+03, 0.166E+03, 0.400E+01, 0.28965000E+01, 0.00000000E+00,
  0.24078360E+03, 0.166E+03, 0.500E+01, 0.28965000E+01, 0.00000000E+00,
  0.16156910E+03, 0.166E+03, 0.600E+01, 0.28965000E+01, 0.00000000E+00,
  0.11248360E+03, 0.166E+03, 0.700E+01, 0.28965000E+01, 0.00000000E+00,
  0.84928800E+02, 0.166E+03, 0.800E+01, 0.28965000E+01, 0.00000000E+00,
  0.64205600E+02, 0.166E+03, 0.900E+01, 0.28965000E+01, 0.00000000E+00,
  0.49316600E+02, 0.166E+03, 0.100E+02, 0.28965000E+01, 0.00000000E+00,
  0.76254390E+03, 0.166E+03, 0.110E+02, 0.28965000E+01, 0.00000000E+00,
  0.57748050E+03, 0.166E+03, 0.120E+02, 0.28965000E+01, 0.00000000E+00,
  0.52942090E+03, 0.166E+03, 0.130E+02, 0.28965000E+01, 0.00000000E+00,
  0.41417170E+03, 0.166E+03, 0.140E+02, 0.28965000E+01, 0.00000000E+00,
  0.32113630E+03, 0.166E+03, 0.150E+02, 0.28965000E+01, 0.00000000E+00,
  0.26561240E+03, 0.166E+03, 0.160E+02, 0.28965000E+01, 0.00000000E+00,
  0.21629400E+03, 0.166E+03, 0.170E+02, 0.28965000E+01, 0.00000000E+00,
  0.17651170E+03, 0.166E+03, 0.180E+02, 0.28965000E+01, 0.00000000E+00,
  0.12553434E+04, 0.166E+03, 0.190E+02, 0.28965000E+01, 0.00000000E+00,
  0.10213342E+04, 0.166E+03, 0.200E+02, 0.28965000E+01, 0.00000000E+00,
  0.84137840E+03, 0.166E+03, 0.210E+02, 0.28965000E+01, 0.00000000E+00,
  0.81057120E+03, 0.166E+03, 0.220E+02, 0.28965000E+01, 0.00000000E+00,
  0.74119950E+03, 0.166E+03, 0.230E+02, 0.28965000E+01, 0.00000000E+00,
  0.58388160E+03, 0.166E+03, 0.240E+02, 0.28965000E+01, 0.00000000E+00,
  0.63684280E+03, 0.166E+03, 0.250E+02, 0.28965000E+01, 0.00000000E+00,
  0.49970290E+03, 0.166E+03, 0.260E+02, 0.28965000E+01, 0.00000000E+00,
  0.52794350E+03, 0.166E+03, 0.270E+02, 0.28965000E+01, 0.00000000E+00,
  0.54462440E+03, 0.166E+03, 0.280E+02, 0.28965000E+01, 0.00000000E+00,
  0.41763490E+03, 0.166E+03, 0.290E+02, 0.28965000E+01, 0.00000000E+00,
  0.42675460E+03, 0.166E+03, 0.300E+02, 0.28965000E+01, 0.00000000E+00,
  0.50613150E+03, 0.166E+03, 0.310E+02, 0.28965000E+01, 0.00000000E+00,
  0.44382260E+03, 0.166E+03, 0.320E+02, 0.28965000E+01, 0.00000000E+00,
  0.37672490E+03, 0.166E+03, 0.330E+02, 0.28965000E+01, 0.00000000E+00,
  0.33707580E+03, 0.166E+03, 0.340E+02, 0.28965000E+01, 0.00000000E+00,
  0.29415100E+03, 0.166E+03, 0.350E+02, 0.28965000E+01, 0.00000000E+00,
  0.25518090E+03, 0.166E+03, 0.360E+02, 0.28965000E+01, 0.00000000E+00,
  0.14056043E+04, 0.166E+03, 0.370E+02, 0.28965000E+01, 0.00000000E+00,
  0.12176072E+04, 0.166E+03, 0.380E+02, 0.28965000E+01, 0.00000000E+00,
  0.10613052E+04, 0.166E+03, 0.390E+02, 0.28965000E+01, 0.00000000E+00,
  0.95099220E+03, 0.166E+03, 0.400E+02, 0.28965000E+01, 0.00000000E+00,
  0.86553240E+03, 0.166E+03, 0.410E+02, 0.28965000E+01, 0.00000000E+00,
  0.66608950E+03, 0.166E+03, 0.420E+02, 0.28965000E+01, 0.00000000E+00,
  0.74408720E+03, 0.166E+03, 0.430E+02, 0.28965000E+01, 0.00000000E+00,
  0.56489840E+03, 0.166E+03, 0.440E+02, 0.28965000E+01, 0.00000000E+00,
  0.61735350E+03, 0.166E+03, 0.450E+02, 0.28965000E+01, 0.00000000E+00,
  0.57182020E+03, 0.166E+03, 0.460E+02, 0.28965000E+01, 0.00000000E+00,
  0.47729120E+03, 0.166E+03, 0.470E+02, 0.28965000E+01, 0.00000000E+00,
  0.50312050E+03, 0.166E+03, 0.480E+02, 0.28965000E+01, 0.00000000E+00,
  0.63374930E+03, 0.166E+03, 0.490E+02, 0.28965000E+01, 0.00000000E+00,
  0.58321300E+03, 0.166E+03, 0.500E+02, 0.28965000E+01, 0.00000000E+00,
  0.51742880E+03, 0.166E+03, 0.510E+02, 0.28965000E+01, 0.00000000E+00,
  0.47882440E+03, 0.166E+03, 0.520E+02, 0.28965000E+01, 0.00000000E+00,
  0.43176670E+03, 0.166E+03, 0.530E+02, 0.28965000E+01, 0.00000000E+00,
  0.38721870E+03, 0.166E+03, 0.540E+02, 0.28965000E+01, 0.00000000E+00,
  0.17128830E+04, 0.166E+03, 0.550E+02, 0.28965000E+01, 0.00000000E+00,
  0.15552120E+04, 0.166E+03, 0.560E+02, 0.28965000E+01, 0.00000000E+00,
  0.13593802E+04, 0.166E+03, 0.570E+02, 0.28965000E+01, 0.00000000E+00,
  0.61183610E+03, 0.166E+03, 0.580E+02, 0.28965000E+01, 0.27991000E+01,
  0.13758472E+04, 0.166E+03, 0.590E+02, 0.28965000E+01, 0.00000000E+00,
  0.13197747E+04, 0.166E+03, 0.600E+02, 0.28965000E+01, 0.00000000E+00,
  0.12863433E+04, 0.166E+03, 0.610E+02, 0.28965000E+01, 0.00000000E+00,
  0.12556329E+04, 0.166E+03, 0.620E+02, 0.28965000E+01, 0.00000000E+00,
  0.12283897E+04, 0.166E+03, 0.630E+02, 0.28965000E+01, 0.00000000E+00,
  0.96089950E+03, 0.166E+03, 0.640E+02, 0.28965000E+01, 0.00000000E+00,
  0.10913776E+04, 0.166E+03, 0.650E+02, 0.28965000E+01, 0.00000000E+00,
  0.10518609E+04, 0.166E+03, 0.660E+02, 0.28965000E+01, 0.00000000E+00,
  0.11064740E+04, 0.166E+03, 0.670E+02, 0.28965000E+01, 0.00000000E+00,
  0.10828259E+04, 0.166E+03, 0.680E+02, 0.28965000E+01, 0.00000000E+00,
  0.10614329E+04, 0.166E+03, 0.690E+02, 0.28965000E+01, 0.00000000E+00,
  0.10492440E+04, 0.166E+03, 0.700E+02, 0.28965000E+01, 0.00000000E+00,
  0.88106130E+03, 0.166E+03, 0.710E+02, 0.28965000E+01, 0.00000000E+00,
  0.86194390E+03, 0.166E+03, 0.720E+02, 0.28965000E+01, 0.00000000E+00,
  0.78433470E+03, 0.166E+03, 0.730E+02, 0.28965000E+01, 0.00000000E+00,
  0.66095780E+03, 0.166E+03, 0.740E+02, 0.28965000E+01, 0.00000000E+00,
  0.67162740E+03, 0.166E+03, 0.750E+02, 0.28965000E+01, 0.00000000E+00,
  0.60723190E+03, 0.166E+03, 0.760E+02, 0.28965000E+01, 0.00000000E+00,
  0.55505840E+03, 0.166E+03, 0.770E+02, 0.28965000E+01, 0.00000000E+00,
  0.46025170E+03, 0.166E+03, 0.780E+02, 0.28965000E+01, 0.00000000E+00,
  0.42970270E+03, 0.166E+03, 0.790E+02, 0.28965000E+01, 0.00000000E+00,
  0.44159570E+03, 0.166E+03, 0.800E+02, 0.28965000E+01, 0.00000000E+00,
  0.65009130E+03, 0.166E+03, 0.810E+02, 0.28965000E+01, 0.00000000E+00,
  0.63314710E+03, 0.166E+03, 0.820E+02, 0.28965000E+01, 0.00000000E+00,
  0.57941850E+03, 0.166E+03, 0.830E+02, 0.28965000E+01, 0.00000000E+00,
  0.55135470E+03, 0.166E+03, 0.840E+02, 0.28965000E+01, 0.00000000E+00,
  0.50749380E+03, 0.166E+03, 0.850E+02, 0.28965000E+01, 0.00000000E+00,
  0.46406150E+03, 0.166E+03, 0.860E+02, 0.28965000E+01, 0.00000000E+00,
  0.16099709E+04, 0.166E+03, 0.870E+02, 0.28965000E+01, 0.00000000E+00,
  0.15338391E+04, 0.166E+03, 0.880E+02, 0.28965000E+01, 0.00000000E+00,
  0.13494846E+04, 0.166E+03, 0.890E+02, 0.28965000E+01, 0.00000000E+00,
  0.12065102E+04, 0.166E+03, 0.900E+02, 0.28965000E+01, 0.00000000E+00,
  0.12011049E+04, 0.166E+03, 0.910E+02, 0.28965000E+01, 0.00000000E+00,
  0.11628261E+04, 0.166E+03, 0.920E+02, 0.28965000E+01, 0.00000000E+00,
  0.12010327E+04, 0.166E+03, 0.930E+02, 0.28965000E+01, 0.00000000E+00,
  0.11623643E+04, 0.166E+03, 0.940E+02, 0.28965000E+01, 0.00000000E+00,
  0.63781600E+02, 0.166E+03, 0.101E+03, 0.28965000E+01, 0.00000000E+00,
  0.20966850E+03, 0.166E+03, 0.103E+03, 0.28965000E+01, 0.98650000E+00,
  0.26699220E+03, 0.166E+03, 0.104E+03, 0.28965000E+01, 0.98080000E+00,
  0.20215950E+03, 0.166E+03, 0.105E+03, 0.28965000E+01, 0.97060000E+00,
  0.15159630E+03, 0.166E+03, 0.106E+03, 0.28965000E+01, 0.98680000E+00,
  0.10489910E+03, 0.166E+03, 0.107E+03, 0.28965000E+01, 0.99440000E+00,
  0.76120900E+02, 0.166E+03, 0.108E+03, 0.28965000E+01, 0.99250000E+00,
  0.52145400E+02, 0.166E+03, 0.109E+03, 0.28965000E+01, 0.99820000E+00,
  0.30714640E+03, 0.166E+03, 0.111E+03, 0.28965000E+01, 0.96840000E+00,
  0.47548270E+03, 0.166E+03, 0.112E+03, 0.28965000E+01, 0.96280000E+00,
  0.47919230E+03, 0.166E+03, 0.113E+03, 0.28965000E+01, 0.96480000E+00,
  0.38242860E+03, 0.166E+03, 0.114E+03, 0.28965000E+01, 0.95070000E+00,
  0.31166960E+03, 0.166E+03, 0.115E+03, 0.28965000E+01, 0.99470000E+00,
  0.26271630E+03, 0.166E+03, 0.116E+03, 0.28965000E+01, 0.99480000E+00,
  0.21407020E+03, 0.166E+03, 0.117E+03, 0.28965000E+01, 0.99720000E+00,
  0.42205350E+03, 0.166E+03, 0.119E+03, 0.28965000E+01, 0.97670000E+00,
  0.81742610E+03, 0.166E+03, 0.120E+03, 0.28965000E+01, 0.98310000E+00,
  0.41957740E+03, 0.166E+03, 0.121E+03, 0.28965000E+01, 0.18627000E+01,
  0.40507580E+03, 0.166E+03, 0.122E+03, 0.28965000E+01, 0.18299000E+01,
  0.39701800E+03, 0.166E+03, 0.123E+03, 0.28965000E+01, 0.19138000E+01,
  0.39363860E+03, 0.166E+03, 0.124E+03, 0.28965000E+01, 0.18269000E+01,
  0.36094370E+03, 0.166E+03, 0.125E+03, 0.28965000E+01, 0.16406000E+01,
  0.33374440E+03, 0.166E+03, 0.126E+03, 0.28965000E+01, 0.16483000E+01,
  0.31840100E+03, 0.166E+03, 0.127E+03, 0.28965000E+01, 0.17149000E+01,
  0.31136890E+03, 0.166E+03, 0.128E+03, 0.28965000E+01, 0.17937000E+01,
  0.30844670E+03, 0.166E+03, 0.129E+03, 0.28965000E+01, 0.95760000E+00,
  0.28804090E+03, 0.166E+03, 0.130E+03, 0.28965000E+01, 0.19419000E+01,
  0.47467810E+03, 0.166E+03, 0.131E+03, 0.28965000E+01, 0.96010000E+00,
  0.41468730E+03, 0.166E+03, 0.132E+03, 0.28965000E+01, 0.94340000E+00,
  0.37023680E+03, 0.166E+03, 0.133E+03, 0.28965000E+01, 0.98890000E+00,
  0.33722390E+03, 0.166E+03, 0.134E+03, 0.28965000E+01, 0.99010000E+00,
  0.29624340E+03, 0.166E+03, 0.135E+03, 0.28965000E+01, 0.99740000E+00,
  0.50300950E+03, 0.166E+03, 0.137E+03, 0.28965000E+01, 0.97380000E+00,
  0.99563320E+03, 0.166E+03, 0.138E+03, 0.28965000E+01, 0.98010000E+00,
  0.75368720E+03, 0.166E+03, 0.139E+03, 0.28965000E+01, 0.19153000E+01,
  0.55531660E+03, 0.166E+03, 0.140E+03, 0.28965000E+01, 0.19355000E+01,
  0.56079120E+03, 0.166E+03, 0.141E+03, 0.28965000E+01, 0.19545000E+01,
  0.52244060E+03, 0.166E+03, 0.142E+03, 0.28965000E+01, 0.19420000E+01,
  0.58868540E+03, 0.166E+03, 0.143E+03, 0.28965000E+01, 0.16682000E+01,
  0.45392960E+03, 0.166E+03, 0.144E+03, 0.28965000E+01, 0.18584000E+01,
  0.42457780E+03, 0.166E+03, 0.145E+03, 0.28965000E+01, 0.19003000E+01,
  0.39405630E+03, 0.166E+03, 0.146E+03, 0.28965000E+01, 0.18630000E+01,
  0.38138420E+03, 0.166E+03, 0.147E+03, 0.28965000E+01, 0.96790000E+00,
  0.37631210E+03, 0.166E+03, 0.148E+03, 0.28965000E+01, 0.19539000E+01,
  0.60308050E+03, 0.166E+03, 0.149E+03, 0.28965000E+01, 0.96330000E+00,
  0.54294040E+03, 0.166E+03, 0.150E+03, 0.28965000E+01, 0.95140000E+00,
  0.50681590E+03, 0.166E+03, 0.151E+03, 0.28965000E+01, 0.97490000E+00,
  0.47839610E+03, 0.166E+03, 0.152E+03, 0.28965000E+01, 0.98110000E+00,
  0.43583490E+03, 0.166E+03, 0.153E+03, 0.28965000E+01, 0.99680000E+00,
  0.59259730E+03, 0.166E+03, 0.155E+03, 0.28965000E+01, 0.99090000E+00,
  0.12943501E+04, 0.166E+03, 0.156E+03, 0.28965000E+01, 0.97970000E+00,
  0.95498290E+03, 0.166E+03, 0.157E+03, 0.28965000E+01, 0.19373000E+01,
  0.59324060E+03, 0.166E+03, 0.159E+03, 0.28965000E+01, 0.29425000E+01,
  0.58094220E+03, 0.166E+03, 0.160E+03, 0.28965000E+01, 0.29455000E+01,
  0.56241030E+03, 0.166E+03, 0.161E+03, 0.28965000E+01, 0.29413000E+01,
  0.56558410E+03, 0.166E+03, 0.162E+03, 0.28965000E+01, 0.29300000E+01,
  0.54641960E+03, 0.166E+03, 0.163E+03, 0.28965000E+01, 0.18286000E+01,
  0.56923180E+03, 0.166E+03, 0.164E+03, 0.28965000E+01, 0.28732000E+01,
  0.53434800E+03, 0.166E+03, 0.165E+03, 0.28965000E+01, 0.29086000E+01,
  0.54443560E+03, 0.166E+03, 0.166E+03, 0.28965000E+01, 0.28965000E+01,
  0.37029500E+02, 0.167E+03, 0.100E+01, 0.29242000E+01, 0.91180000E+00,
  0.24480600E+02, 0.167E+03, 0.200E+01, 0.29242000E+01, 0.00000000E+00,
  0.57574990E+03, 0.167E+03, 0.300E+01, 0.29242000E+01, 0.00000000E+00,
  0.33286460E+03, 0.167E+03, 0.400E+01, 0.29242000E+01, 0.00000000E+00,
  0.22408560E+03, 0.167E+03, 0.500E+01, 0.29242000E+01, 0.00000000E+00,
  0.15136070E+03, 0.167E+03, 0.600E+01, 0.29242000E+01, 0.00000000E+00,
  0.10585820E+03, 0.167E+03, 0.700E+01, 0.29242000E+01, 0.00000000E+00,
  0.80170400E+02, 0.167E+03, 0.800E+01, 0.29242000E+01, 0.00000000E+00,
  0.60759800E+02, 0.167E+03, 0.900E+01, 0.29242000E+01, 0.00000000E+00,
  0.46759500E+02, 0.167E+03, 0.100E+02, 0.29242000E+01, 0.00000000E+00,
  0.68859100E+03, 0.167E+03, 0.110E+02, 0.29242000E+01, 0.00000000E+00,
  0.53038700E+03, 0.167E+03, 0.120E+02, 0.29242000E+01, 0.00000000E+00,
  0.48884720E+03, 0.167E+03, 0.130E+02, 0.29242000E+01, 0.00000000E+00,
  0.38509520E+03, 0.167E+03, 0.140E+02, 0.29242000E+01, 0.00000000E+00,
  0.30019740E+03, 0.167E+03, 0.150E+02, 0.29242000E+01, 0.00000000E+00,
  0.24909840E+03, 0.167E+03, 0.160E+02, 0.29242000E+01, 0.00000000E+00,
  0.20345290E+03, 0.167E+03, 0.170E+02, 0.29242000E+01, 0.00000000E+00,
  0.16644660E+03, 0.167E+03, 0.180E+02, 0.29242000E+01, 0.00000000E+00,
  0.11279480E+04, 0.167E+03, 0.190E+02, 0.29242000E+01, 0.00000000E+00,
  0.93174430E+03, 0.167E+03, 0.200E+02, 0.29242000E+01, 0.00000000E+00,
  0.76983360E+03, 0.167E+03, 0.210E+02, 0.29242000E+01, 0.00000000E+00,
  0.74340690E+03, 0.167E+03, 0.220E+02, 0.29242000E+01, 0.00000000E+00,
  0.68076970E+03, 0.167E+03, 0.230E+02, 0.29242000E+01, 0.00000000E+00,
  0.53627310E+03, 0.167E+03, 0.240E+02, 0.29242000E+01, 0.00000000E+00,
  0.58613150E+03, 0.167E+03, 0.250E+02, 0.29242000E+01, 0.00000000E+00,
  0.46004150E+03, 0.167E+03, 0.260E+02, 0.29242000E+01, 0.00000000E+00,
  0.48762020E+03, 0.167E+03, 0.270E+02, 0.29242000E+01, 0.00000000E+00,
  0.50232060E+03, 0.167E+03, 0.280E+02, 0.29242000E+01, 0.00000000E+00,
  0.38513270E+03, 0.167E+03, 0.290E+02, 0.29242000E+01, 0.00000000E+00,
  0.39536540E+03, 0.167E+03, 0.300E+02, 0.29242000E+01, 0.00000000E+00,
  0.46822770E+03, 0.167E+03, 0.310E+02, 0.29242000E+01, 0.00000000E+00,
  0.41281620E+03, 0.167E+03, 0.320E+02, 0.29242000E+01, 0.00000000E+00,
  0.35198750E+03, 0.167E+03, 0.330E+02, 0.29242000E+01, 0.00000000E+00,
  0.31577010E+03, 0.167E+03, 0.340E+02, 0.29242000E+01, 0.00000000E+00,
  0.27627680E+03, 0.167E+03, 0.350E+02, 0.29242000E+01, 0.00000000E+00,
  0.24022750E+03, 0.167E+03, 0.360E+02, 0.29242000E+01, 0.00000000E+00,
  0.12641518E+04, 0.167E+03, 0.370E+02, 0.29242000E+01, 0.00000000E+00,
  0.11100442E+04, 0.167E+03, 0.380E+02, 0.29242000E+01, 0.00000000E+00,
  0.97238640E+03, 0.167E+03, 0.390E+02, 0.29242000E+01, 0.00000000E+00,
  0.87389940E+03, 0.167E+03, 0.400E+02, 0.29242000E+01, 0.00000000E+00,
  0.79683270E+03, 0.167E+03, 0.410E+02, 0.29242000E+01, 0.00000000E+00,
  0.61510520E+03, 0.167E+03, 0.420E+02, 0.29242000E+01, 0.00000000E+00,
  0.68633810E+03, 0.167E+03, 0.430E+02, 0.29242000E+01, 0.00000000E+00,
  0.52281640E+03, 0.167E+03, 0.440E+02, 0.29242000E+01, 0.00000000E+00,
  0.57148280E+03, 0.167E+03, 0.450E+02, 0.29242000E+01, 0.00000000E+00,
  0.52993880E+03, 0.167E+03, 0.460E+02, 0.29242000E+01, 0.00000000E+00,
  0.44189760E+03, 0.167E+03, 0.470E+02, 0.29242000E+01, 0.00000000E+00,
  0.46694330E+03, 0.167E+03, 0.480E+02, 0.29242000E+01, 0.00000000E+00,
  0.58603950E+03, 0.167E+03, 0.490E+02, 0.29242000E+01, 0.00000000E+00,
  0.54179100E+03, 0.167E+03, 0.500E+02, 0.29242000E+01, 0.00000000E+00,
  0.48265820E+03, 0.167E+03, 0.510E+02, 0.29242000E+01, 0.00000000E+00,
  0.44769600E+03, 0.167E+03, 0.520E+02, 0.29242000E+01, 0.00000000E+00,
  0.40468130E+03, 0.167E+03, 0.530E+02, 0.29242000E+01, 0.00000000E+00,
  0.36373600E+03, 0.167E+03, 0.540E+02, 0.29242000E+01, 0.00000000E+00,
  0.15398453E+04, 0.167E+03, 0.550E+02, 0.29242000E+01, 0.00000000E+00,
  0.14149943E+04, 0.167E+03, 0.560E+02, 0.29242000E+01, 0.00000000E+00,
  0.12431883E+04, 0.167E+03, 0.570E+02, 0.29242000E+01, 0.00000000E+00,
  0.57024510E+03, 0.167E+03, 0.580E+02, 0.29242000E+01, 0.27991000E+01,
  0.12537691E+04, 0.167E+03, 0.590E+02, 0.29242000E+01, 0.00000000E+00,
  0.12039727E+04, 0.167E+03, 0.600E+02, 0.29242000E+01, 0.00000000E+00,
  0.11737842E+04, 0.167E+03, 0.610E+02, 0.29242000E+01, 0.00000000E+00,
  0.11460194E+04, 0.167E+03, 0.620E+02, 0.29242000E+01, 0.00000000E+00,
  0.11213978E+04, 0.167E+03, 0.630E+02, 0.29242000E+01, 0.00000000E+00,
  0.88175490E+03, 0.167E+03, 0.640E+02, 0.29242000E+01, 0.00000000E+00,
  0.99262670E+03, 0.167E+03, 0.650E+02, 0.29242000E+01, 0.00000000E+00,
  0.95731530E+03, 0.167E+03, 0.660E+02, 0.29242000E+01, 0.00000000E+00,
  0.10114677E+04, 0.167E+03, 0.670E+02, 0.29242000E+01, 0.00000000E+00,
  0.99000700E+03, 0.167E+03, 0.680E+02, 0.29242000E+01, 0.00000000E+00,
  0.97065280E+03, 0.167E+03, 0.690E+02, 0.29242000E+01, 0.00000000E+00,
  0.95930580E+03, 0.167E+03, 0.700E+02, 0.29242000E+01, 0.00000000E+00,
  0.80819030E+03, 0.167E+03, 0.710E+02, 0.29242000E+01, 0.00000000E+00,
  0.79471630E+03, 0.167E+03, 0.720E+02, 0.29242000E+01, 0.00000000E+00,
  0.72517730E+03, 0.167E+03, 0.730E+02, 0.29242000E+01, 0.00000000E+00,
  0.61226400E+03, 0.167E+03, 0.740E+02, 0.29242000E+01, 0.00000000E+00,
  0.62284620E+03, 0.167E+03, 0.750E+02, 0.29242000E+01, 0.00000000E+00,
  0.56442200E+03, 0.167E+03, 0.760E+02, 0.29242000E+01, 0.00000000E+00,
  0.51685750E+03, 0.167E+03, 0.770E+02, 0.29242000E+01, 0.00000000E+00,
  0.42931700E+03, 0.167E+03, 0.780E+02, 0.29242000E+01, 0.00000000E+00,
  0.40110390E+03, 0.167E+03, 0.790E+02, 0.29242000E+01, 0.00000000E+00,
  0.41259070E+03, 0.167E+03, 0.800E+02, 0.29242000E+01, 0.00000000E+00,
  0.60165160E+03, 0.167E+03, 0.810E+02, 0.29242000E+01, 0.00000000E+00,
  0.58816150E+03, 0.167E+03, 0.820E+02, 0.29242000E+01, 0.00000000E+00,
  0.54028410E+03, 0.167E+03, 0.830E+02, 0.29242000E+01, 0.00000000E+00,
  0.51517620E+03, 0.167E+03, 0.840E+02, 0.29242000E+01, 0.00000000E+00,
  0.47532260E+03, 0.167E+03, 0.850E+02, 0.29242000E+01, 0.00000000E+00,
  0.43554890E+03, 0.167E+03, 0.860E+02, 0.29242000E+01, 0.00000000E+00,
  0.14541544E+04, 0.167E+03, 0.870E+02, 0.29242000E+01, 0.00000000E+00,
  0.13992062E+04, 0.167E+03, 0.880E+02, 0.29242000E+01, 0.00000000E+00,
  0.12368406E+04, 0.167E+03, 0.890E+02, 0.29242000E+01, 0.00000000E+00,
  0.11113608E+04, 0.167E+03, 0.900E+02, 0.29242000E+01, 0.00000000E+00,
  0.11034821E+04, 0.167E+03, 0.910E+02, 0.29242000E+01, 0.00000000E+00,
  0.10684783E+04, 0.167E+03, 0.920E+02, 0.29242000E+01, 0.00000000E+00,
  0.11002364E+04, 0.167E+03, 0.930E+02, 0.29242000E+01, 0.00000000E+00,
  0.10654625E+04, 0.167E+03, 0.940E+02, 0.29242000E+01, 0.00000000E+00,
  0.59658600E+02, 0.167E+03, 0.101E+03, 0.29242000E+01, 0.00000000E+00,
  0.19347380E+03, 0.167E+03, 0.103E+03, 0.29242000E+01, 0.98650000E+00,
  0.24674640E+03, 0.167E+03, 0.104E+03, 0.29242000E+01, 0.98080000E+00,
  0.18847650E+03, 0.167E+03, 0.105E+03, 0.29242000E+01, 0.97060000E+00,
  0.14197970E+03, 0.167E+03, 0.106E+03, 0.29242000E+01, 0.98680000E+00,
  0.98721200E+02, 0.167E+03, 0.107E+03, 0.29242000E+01, 0.99440000E+00,
  0.71910400E+02, 0.167E+03, 0.108E+03, 0.29242000E+01, 0.99250000E+00,
  0.49479300E+02, 0.167E+03, 0.109E+03, 0.29242000E+01, 0.99820000E+00,
  0.28286510E+03, 0.167E+03, 0.111E+03, 0.29242000E+01, 0.96840000E+00,
  0.43742550E+03, 0.167E+03, 0.112E+03, 0.29242000E+01, 0.96280000E+00,
  0.44300780E+03, 0.167E+03, 0.113E+03, 0.29242000E+01, 0.96480000E+00,
  0.35589820E+03, 0.167E+03, 0.114E+03, 0.29242000E+01, 0.95070000E+00,
  0.29139070E+03, 0.167E+03, 0.115E+03, 0.29242000E+01, 0.99470000E+00,
  0.24635930E+03, 0.167E+03, 0.116E+03, 0.29242000E+01, 0.99480000E+00,
  0.20134780E+03, 0.167E+03, 0.117E+03, 0.29242000E+01, 0.99720000E+00,
  0.38995180E+03, 0.167E+03, 0.119E+03, 0.29242000E+01, 0.97670000E+00,
  0.74517810E+03, 0.167E+03, 0.120E+03, 0.29242000E+01, 0.98310000E+00,
  0.39002770E+03, 0.167E+03, 0.121E+03, 0.29242000E+01, 0.18627000E+01,
  0.37650890E+03, 0.167E+03, 0.122E+03, 0.29242000E+01, 0.18299000E+01,
  0.36899410E+03, 0.167E+03, 0.123E+03, 0.29242000E+01, 0.19138000E+01,
  0.36559720E+03, 0.167E+03, 0.124E+03, 0.29242000E+01, 0.18269000E+01,
  0.33635820E+03, 0.167E+03, 0.125E+03, 0.29242000E+01, 0.16406000E+01,
  0.31127980E+03, 0.167E+03, 0.126E+03, 0.29242000E+01, 0.16483000E+01,
  0.29694730E+03, 0.167E+03, 0.127E+03, 0.29242000E+01, 0.17149000E+01,
  0.29031390E+03, 0.167E+03, 0.128E+03, 0.29242000E+01, 0.17937000E+01,
  0.28689270E+03, 0.167E+03, 0.129E+03, 0.29242000E+01, 0.95760000E+00,
  0.26909650E+03, 0.167E+03, 0.130E+03, 0.29242000E+01, 0.19419000E+01,
  0.43973990E+03, 0.167E+03, 0.131E+03, 0.29242000E+01, 0.96010000E+00,
  0.38616340E+03, 0.167E+03, 0.132E+03, 0.29242000E+01, 0.94340000E+00,
  0.34600850E+03, 0.167E+03, 0.133E+03, 0.29242000E+01, 0.98890000E+00,
  0.31589290E+03, 0.167E+03, 0.134E+03, 0.29242000E+01, 0.99010000E+00,
  0.27820320E+03, 0.167E+03, 0.135E+03, 0.29242000E+01, 0.99740000E+00,
  0.46526060E+03, 0.167E+03, 0.137E+03, 0.29242000E+01, 0.97380000E+00,
  0.90671060E+03, 0.167E+03, 0.138E+03, 0.29242000E+01, 0.98010000E+00,
  0.69306070E+03, 0.167E+03, 0.139E+03, 0.29242000E+01, 0.19153000E+01,
  0.51580860E+03, 0.167E+03, 0.140E+03, 0.29242000E+01, 0.19355000E+01,
  0.52093800E+03, 0.167E+03, 0.141E+03, 0.29242000E+01, 0.19545000E+01,
  0.48572140E+03, 0.167E+03, 0.142E+03, 0.29242000E+01, 0.19420000E+01,
  0.54479060E+03, 0.167E+03, 0.143E+03, 0.29242000E+01, 0.16682000E+01,
  0.42334180E+03, 0.167E+03, 0.144E+03, 0.29242000E+01, 0.18584000E+01,
  0.39604750E+03, 0.167E+03, 0.145E+03, 0.29242000E+01, 0.19003000E+01,
  0.36776460E+03, 0.167E+03, 0.146E+03, 0.29242000E+01, 0.18630000E+01,
  0.35578930E+03, 0.167E+03, 0.147E+03, 0.29242000E+01, 0.96790000E+00,
  0.35190760E+03, 0.167E+03, 0.148E+03, 0.29242000E+01, 0.19539000E+01,
  0.55857850E+03, 0.167E+03, 0.149E+03, 0.29242000E+01, 0.96330000E+00,
  0.50519270E+03, 0.167E+03, 0.150E+03, 0.29242000E+01, 0.95140000E+00,
  0.47300760E+03, 0.167E+03, 0.151E+03, 0.29242000E+01, 0.97490000E+00,
  0.44736060E+03, 0.167E+03, 0.152E+03, 0.29242000E+01, 0.98110000E+00,
  0.40847930E+03, 0.167E+03, 0.153E+03, 0.29242000E+01, 0.99680000E+00,
  0.55005480E+03, 0.167E+03, 0.155E+03, 0.29242000E+01, 0.99090000E+00,
  0.11754332E+04, 0.167E+03, 0.156E+03, 0.29242000E+01, 0.97970000E+00,
  0.87714780E+03, 0.167E+03, 0.157E+03, 0.29242000E+01, 0.19373000E+01,
  0.55304140E+03, 0.167E+03, 0.159E+03, 0.29242000E+01, 0.29425000E+01,
  0.54160480E+03, 0.167E+03, 0.160E+03, 0.29242000E+01, 0.29455000E+01,
  0.52443100E+03, 0.167E+03, 0.161E+03, 0.29242000E+01, 0.29413000E+01,
  0.52702430E+03, 0.167E+03, 0.162E+03, 0.29242000E+01, 0.29300000E+01,
  0.50812970E+03, 0.167E+03, 0.163E+03, 0.29242000E+01, 0.18286000E+01,
  0.53036160E+03, 0.167E+03, 0.164E+03, 0.29242000E+01, 0.28732000E+01,
  0.49813190E+03, 0.167E+03, 0.165E+03, 0.29242000E+01, 0.29086000E+01,
  0.50688950E+03, 0.167E+03, 0.166E+03, 0.29242000E+01, 0.28965000E+01,
  0.47279500E+03, 0.167E+03, 0.167E+03, 0.29242000E+01, 0.29242000E+01,
  0.36008400E+02, 0.168E+03, 0.100E+01, 0.29282000E+01, 0.91180000E+00,
  0.23828900E+02, 0.168E+03, 0.200E+01, 0.29282000E+01, 0.00000000E+00,
  0.55724540E+03, 0.168E+03, 0.300E+01, 0.29282000E+01, 0.00000000E+00,
  0.32288400E+03, 0.168E+03, 0.400E+01, 0.29282000E+01, 0.00000000E+00,
  0.21762790E+03, 0.168E+03, 0.500E+01, 0.29282000E+01, 0.00000000E+00,
  0.14712440E+03, 0.168E+03, 0.600E+01, 0.29282000E+01, 0.00000000E+00,
  0.10295880E+03, 0.168E+03, 0.700E+01, 0.29282000E+01, 0.00000000E+00,
  0.78007900E+02, 0.168E+03, 0.800E+01, 0.29282000E+01, 0.00000000E+00,
  0.59142300E+02, 0.168E+03, 0.900E+01, 0.29282000E+01, 0.00000000E+00,
  0.45527900E+02, 0.168E+03, 0.100E+02, 0.29282000E+01, 0.00000000E+00,
  0.66655340E+03, 0.168E+03, 0.110E+02, 0.29282000E+01, 0.00000000E+00,
  0.51428720E+03, 0.168E+03, 0.120E+02, 0.29282000E+01, 0.00000000E+00,
  0.47430950E+03, 0.168E+03, 0.130E+02, 0.29282000E+01, 0.00000000E+00,
  0.37395400E+03, 0.168E+03, 0.140E+02, 0.29282000E+01, 0.00000000E+00,
  0.29171000E+03, 0.168E+03, 0.150E+02, 0.29282000E+01, 0.00000000E+00,
  0.24215880E+03, 0.168E+03, 0.160E+02, 0.29282000E+01, 0.00000000E+00,
  0.19786420E+03, 0.168E+03, 0.170E+02, 0.29282000E+01, 0.00000000E+00,
  0.16193000E+03, 0.168E+03, 0.180E+02, 0.29282000E+01, 0.00000000E+00,
  0.10915091E+04, 0.168E+03, 0.190E+02, 0.29282000E+01, 0.00000000E+00,
  0.90284450E+03, 0.168E+03, 0.200E+02, 0.29282000E+01, 0.00000000E+00,
  0.74618100E+03, 0.168E+03, 0.210E+02, 0.29282000E+01, 0.00000000E+00,
  0.72076670E+03, 0.168E+03, 0.220E+02, 0.29282000E+01, 0.00000000E+00,
  0.66014630E+03, 0.168E+03, 0.230E+02, 0.29282000E+01, 0.00000000E+00,
  0.52004920E+03, 0.168E+03, 0.240E+02, 0.29282000E+01, 0.00000000E+00,
  0.56851110E+03, 0.168E+03, 0.250E+02, 0.29282000E+01, 0.00000000E+00,
  0.44624320E+03, 0.168E+03, 0.260E+02, 0.29282000E+01, 0.00000000E+00,
  0.47314860E+03, 0.168E+03, 0.270E+02, 0.29282000E+01, 0.00000000E+00,
  0.48733120E+03, 0.168E+03, 0.280E+02, 0.29282000E+01, 0.00000000E+00,
  0.37365280E+03, 0.168E+03, 0.290E+02, 0.29282000E+01, 0.00000000E+00,
  0.38376960E+03, 0.168E+03, 0.300E+02, 0.29282000E+01, 0.00000000E+00,
  0.45441890E+03, 0.168E+03, 0.310E+02, 0.29282000E+01, 0.00000000E+00,
  0.40089710E+03, 0.168E+03, 0.320E+02, 0.29282000E+01, 0.00000000E+00,
  0.34201700E+03, 0.168E+03, 0.330E+02, 0.29282000E+01, 0.00000000E+00,
  0.30693000E+03, 0.168E+03, 0.340E+02, 0.29282000E+01, 0.00000000E+00,
  0.26863470E+03, 0.168E+03, 0.350E+02, 0.29282000E+01, 0.00000000E+00,
  0.23365510E+03, 0.168E+03, 0.360E+02, 0.29282000E+01, 0.00000000E+00,
  0.12234668E+04, 0.168E+03, 0.370E+02, 0.29282000E+01, 0.00000000E+00,
  0.10755659E+04, 0.168E+03, 0.380E+02, 0.29282000E+01, 0.00000000E+00,
  0.94268540E+03, 0.168E+03, 0.390E+02, 0.29282000E+01, 0.00000000E+00,
  0.84748690E+03, 0.168E+03, 0.400E+02, 0.29282000E+01, 0.00000000E+00,
  0.77291870E+03, 0.168E+03, 0.410E+02, 0.29282000E+01, 0.00000000E+00,
  0.59687070E+03, 0.168E+03, 0.420E+02, 0.29282000E+01, 0.00000000E+00,
  0.66589970E+03, 0.168E+03, 0.430E+02, 0.29282000E+01, 0.00000000E+00,
  0.50745680E+03, 0.168E+03, 0.440E+02, 0.29282000E+01, 0.00000000E+00,
  0.55468820E+03, 0.168E+03, 0.450E+02, 0.29282000E+01, 0.00000000E+00,
  0.51443460E+03, 0.168E+03, 0.460E+02, 0.29282000E+01, 0.00000000E+00,
  0.42894240E+03, 0.168E+03, 0.470E+02, 0.29282000E+01, 0.00000000E+00,
  0.45336080E+03, 0.168E+03, 0.480E+02, 0.29282000E+01, 0.00000000E+00,
  0.56875080E+03, 0.168E+03, 0.490E+02, 0.29282000E+01, 0.00000000E+00,
  0.52608060E+03, 0.168E+03, 0.500E+02, 0.29282000E+01, 0.00000000E+00,
  0.46889680E+03, 0.168E+03, 0.510E+02, 0.29282000E+01, 0.00000000E+00,
  0.43506030E+03, 0.168E+03, 0.520E+02, 0.29282000E+01, 0.00000000E+00,
  0.39338290E+03, 0.168E+03, 0.530E+02, 0.29282000E+01, 0.00000000E+00,
  0.35368410E+03, 0.168E+03, 0.540E+02, 0.29282000E+01, 0.00000000E+00,
  0.14903329E+04, 0.168E+03, 0.550E+02, 0.29282000E+01, 0.00000000E+00,
  0.13708120E+04, 0.168E+03, 0.560E+02, 0.29282000E+01, 0.00000000E+00,
  0.12050073E+04, 0.168E+03, 0.570E+02, 0.29282000E+01, 0.00000000E+00,
  0.55393560E+03, 0.168E+03, 0.580E+02, 0.29282000E+01, 0.27991000E+01,
  0.12148410E+04, 0.168E+03, 0.590E+02, 0.29282000E+01, 0.00000000E+00,
  0.11666903E+04, 0.168E+03, 0.600E+02, 0.29282000E+01, 0.00000000E+00,
  0.11374645E+04, 0.168E+03, 0.610E+02, 0.29282000E+01, 0.00000000E+00,
  0.11105819E+04, 0.168E+03, 0.620E+02, 0.29282000E+01, 0.00000000E+00,
  0.10867437E+04, 0.168E+03, 0.630E+02, 0.29282000E+01, 0.00000000E+00,
  0.85501380E+03, 0.168E+03, 0.640E+02, 0.29282000E+01, 0.00000000E+00,
  0.96171480E+03, 0.168E+03, 0.650E+02, 0.29282000E+01, 0.00000000E+00,
  0.92760080E+03, 0.168E+03, 0.660E+02, 0.29282000E+01, 0.00000000E+00,
  0.98034030E+03, 0.168E+03, 0.670E+02, 0.29282000E+01, 0.00000000E+00,
  0.95955360E+03, 0.168E+03, 0.680E+02, 0.29282000E+01, 0.00000000E+00,
  0.94081400E+03, 0.168E+03, 0.690E+02, 0.29282000E+01, 0.00000000E+00,
  0.92979290E+03, 0.168E+03, 0.700E+02, 0.29282000E+01, 0.00000000E+00,
  0.78364610E+03, 0.168E+03, 0.710E+02, 0.29282000E+01, 0.00000000E+00,
  0.77098740E+03, 0.168E+03, 0.720E+02, 0.29282000E+01, 0.00000000E+00,
  0.70375210E+03, 0.168E+03, 0.730E+02, 0.29282000E+01, 0.00000000E+00,
  0.59432800E+03, 0.168E+03, 0.740E+02, 0.29282000E+01, 0.00000000E+00,
  0.60467390E+03, 0.168E+03, 0.750E+02, 0.29282000E+01, 0.00000000E+00,
  0.54810470E+03, 0.168E+03, 0.760E+02, 0.29282000E+01, 0.00000000E+00,
  0.50202620E+03, 0.168E+03, 0.770E+02, 0.29282000E+01, 0.00000000E+00,
  0.41709650E+03, 0.168E+03, 0.780E+02, 0.29282000E+01, 0.00000000E+00,
  0.38972370E+03, 0.168E+03, 0.790E+02, 0.29282000E+01, 0.00000000E+00,
  0.40092380E+03, 0.168E+03, 0.800E+02, 0.29282000E+01, 0.00000000E+00,
  0.58398610E+03, 0.168E+03, 0.810E+02, 0.29282000E+01, 0.00000000E+00,
  0.57111950E+03, 0.168E+03, 0.820E+02, 0.29282000E+01, 0.00000000E+00,
  0.52486410E+03, 0.168E+03, 0.830E+02, 0.29282000E+01, 0.00000000E+00,
  0.50060050E+03, 0.168E+03, 0.840E+02, 0.29282000E+01, 0.00000000E+00,
  0.46201380E+03, 0.168E+03, 0.850E+02, 0.29282000E+01, 0.00000000E+00,
  0.42346810E+03, 0.168E+03, 0.860E+02, 0.29282000E+01, 0.00000000E+00,
  0.14079944E+04, 0.168E+03, 0.870E+02, 0.29282000E+01, 0.00000000E+00,
  0.13558908E+04, 0.168E+03, 0.880E+02, 0.29282000E+01, 0.00000000E+00,
  0.11991383E+04, 0.168E+03, 0.890E+02, 0.29282000E+01, 0.00000000E+00,
  0.10780836E+04, 0.168E+03, 0.900E+02, 0.29282000E+01, 0.00000000E+00,
  0.10701540E+04, 0.168E+03, 0.910E+02, 0.29282000E+01, 0.00000000E+00,
  0.10362222E+04, 0.168E+03, 0.920E+02, 0.29282000E+01, 0.00000000E+00,
  0.10666560E+04, 0.168E+03, 0.930E+02, 0.29282000E+01, 0.00000000E+00,
  0.10330090E+04, 0.168E+03, 0.940E+02, 0.29282000E+01, 0.00000000E+00,
  0.57976000E+02, 0.168E+03, 0.101E+03, 0.29282000E+01, 0.00000000E+00,
  0.18770500E+03, 0.168E+03, 0.103E+03, 0.29282000E+01, 0.98650000E+00,
  0.23944310E+03, 0.168E+03, 0.104E+03, 0.29282000E+01, 0.98080000E+00,
  0.18308850E+03, 0.168E+03, 0.105E+03, 0.29282000E+01, 0.97060000E+00,
  0.13800410E+03, 0.168E+03, 0.106E+03, 0.29282000E+01, 0.98680000E+00,
  0.96019300E+02, 0.168E+03, 0.107E+03, 0.29282000E+01, 0.99440000E+00,
  0.69979100E+02, 0.168E+03, 0.108E+03, 0.29282000E+01, 0.99250000E+00,
  0.48180500E+02, 0.168E+03, 0.109E+03, 0.29282000E+01, 0.99820000E+00,
  0.27437320E+03, 0.168E+03, 0.111E+03, 0.29282000E+01, 0.96840000E+00,
  0.42424930E+03, 0.168E+03, 0.112E+03, 0.29282000E+01, 0.96280000E+00,
  0.42989820E+03, 0.168E+03, 0.113E+03, 0.29282000E+01, 0.96480000E+00,
  0.34564250E+03, 0.168E+03, 0.114E+03, 0.29282000E+01, 0.95070000E+00,
  0.28315870E+03, 0.168E+03, 0.115E+03, 0.29282000E+01, 0.99470000E+00,
  0.23949360E+03, 0.168E+03, 0.116E+03, 0.29282000E+01, 0.99480000E+00,
  0.19581550E+03, 0.168E+03, 0.117E+03, 0.29282000E+01, 0.99720000E+00,
  0.37842050E+03, 0.168E+03, 0.119E+03, 0.29282000E+01, 0.97670000E+00,
  0.72211110E+03, 0.168E+03, 0.120E+03, 0.29282000E+01, 0.98310000E+00,
  0.37874080E+03, 0.168E+03, 0.121E+03, 0.29282000E+01, 0.18627000E+01,
  0.36562310E+03, 0.168E+03, 0.122E+03, 0.29282000E+01, 0.18299000E+01,
  0.35832130E+03, 0.168E+03, 0.123E+03, 0.29282000E+01, 0.19138000E+01,
  0.35499450E+03, 0.168E+03, 0.124E+03, 0.29282000E+01, 0.18269000E+01,
  0.32672790E+03, 0.168E+03, 0.125E+03, 0.29282000E+01, 0.16406000E+01,
  0.30240170E+03, 0.168E+03, 0.126E+03, 0.29282000E+01, 0.16483000E+01,
  0.28847830E+03, 0.168E+03, 0.127E+03, 0.29282000E+01, 0.17149000E+01,
  0.28202540E+03, 0.168E+03, 0.128E+03, 0.29282000E+01, 0.17937000E+01,
  0.27862110E+03, 0.168E+03, 0.129E+03, 0.29282000E+01, 0.95760000E+00,
  0.26147450E+03, 0.168E+03, 0.130E+03, 0.29282000E+01, 0.19419000E+01,
  0.42684110E+03, 0.168E+03, 0.131E+03, 0.29282000E+01, 0.96010000E+00,
  0.37506910E+03, 0.168E+03, 0.132E+03, 0.29282000E+01, 0.94340000E+00,
  0.33621830E+03, 0.168E+03, 0.133E+03, 0.29282000E+01, 0.98890000E+00,
  0.30704780E+03, 0.168E+03, 0.134E+03, 0.29282000E+01, 0.99010000E+00,
  0.27050300E+03, 0.168E+03, 0.135E+03, 0.29282000E+01, 0.99740000E+00,
  0.45156840E+03, 0.168E+03, 0.137E+03, 0.29282000E+01, 0.97380000E+00,
  0.87858370E+03, 0.168E+03, 0.138E+03, 0.29282000E+01, 0.98010000E+00,
  0.67226710E+03, 0.168E+03, 0.139E+03, 0.29282000E+01, 0.19153000E+01,
  0.50085680E+03, 0.168E+03, 0.140E+03, 0.29282000E+01, 0.19355000E+01,
  0.50582970E+03, 0.168E+03, 0.141E+03, 0.29282000E+01, 0.19545000E+01,
  0.47170110E+03, 0.168E+03, 0.142E+03, 0.29282000E+01, 0.19420000E+01,
  0.52880060E+03, 0.168E+03, 0.143E+03, 0.29282000E+01, 0.16682000E+01,
  0.41127310E+03, 0.168E+03, 0.144E+03, 0.29282000E+01, 0.18584000E+01,
  0.38477140E+03, 0.168E+03, 0.145E+03, 0.29282000E+01, 0.19003000E+01,
  0.35731920E+03, 0.168E+03, 0.146E+03, 0.29282000E+01, 0.18630000E+01,
  0.34566580E+03, 0.168E+03, 0.147E+03, 0.29282000E+01, 0.96790000E+00,
  0.34198940E+03, 0.168E+03, 0.148E+03, 0.29282000E+01, 0.19539000E+01,
  0.54219990E+03, 0.168E+03, 0.149E+03, 0.29282000E+01, 0.96330000E+00,
  0.49064160E+03, 0.168E+03, 0.150E+03, 0.29282000E+01, 0.95140000E+00,
  0.45955210E+03, 0.168E+03, 0.151E+03, 0.29282000E+01, 0.97490000E+00,
  0.43474240E+03, 0.168E+03, 0.152E+03, 0.29282000E+01, 0.98110000E+00,
  0.39707280E+03, 0.168E+03, 0.153E+03, 0.29282000E+01, 0.99680000E+00,
  0.53408180E+03, 0.168E+03, 0.155E+03, 0.29282000E+01, 0.99090000E+00,
  0.11387329E+04, 0.168E+03, 0.156E+03, 0.29282000E+01, 0.97970000E+00,
  0.85075470E+03, 0.168E+03, 0.157E+03, 0.29282000E+01, 0.19373000E+01,
  0.53723990E+03, 0.168E+03, 0.159E+03, 0.29282000E+01, 0.29425000E+01,
  0.52613310E+03, 0.168E+03, 0.160E+03, 0.29282000E+01, 0.29455000E+01,
  0.50946310E+03, 0.168E+03, 0.161E+03, 0.29282000E+01, 0.29413000E+01,
  0.51194390E+03, 0.168E+03, 0.162E+03, 0.29282000E+01, 0.29300000E+01,
  0.49346840E+03, 0.168E+03, 0.163E+03, 0.29282000E+01, 0.18286000E+01,
  0.51517330E+03, 0.168E+03, 0.164E+03, 0.29282000E+01, 0.28732000E+01,
  0.48389820E+03, 0.168E+03, 0.165E+03, 0.29282000E+01, 0.29086000E+01,
  0.49233800E+03, 0.168E+03, 0.166E+03, 0.29282000E+01, 0.28965000E+01,
  0.45931550E+03, 0.168E+03, 0.167E+03, 0.29282000E+01, 0.29242000E+01,
  0.44623140E+03, 0.168E+03, 0.168E+03, 0.29282000E+01, 0.29282000E+01,
  0.35748000E+02, 0.169E+03, 0.100E+01, 0.29246000E+01, 0.91180000E+00,
  0.23629700E+02, 0.169E+03, 0.200E+01, 0.29246000E+01, 0.00000000E+00,
  0.55525980E+03, 0.169E+03, 0.300E+01, 0.29246000E+01, 0.00000000E+00,
  0.32123930E+03, 0.169E+03, 0.400E+01, 0.29246000E+01, 0.00000000E+00,
  0.21630990E+03, 0.169E+03, 0.500E+01, 0.29246000E+01, 0.00000000E+00,
  0.14611730E+03, 0.169E+03, 0.600E+01, 0.29246000E+01, 0.00000000E+00,
  0.10218880E+03, 0.169E+03, 0.700E+01, 0.29246000E+01, 0.00000000E+00,
  0.77387400E+02, 0.169E+03, 0.800E+01, 0.29246000E+01, 0.00000000E+00,
  0.58646500E+02, 0.169E+03, 0.900E+01, 0.29246000E+01, 0.00000000E+00,
  0.45129800E+02, 0.169E+03, 0.100E+02, 0.29246000E+01, 0.00000000E+00,
  0.66409940E+03, 0.169E+03, 0.110E+02, 0.29246000E+01, 0.00000000E+00,
  0.51180090E+03, 0.169E+03, 0.120E+02, 0.29246000E+01, 0.00000000E+00,
  0.47179450E+03, 0.169E+03, 0.130E+02, 0.29246000E+01, 0.00000000E+00,
  0.37172710E+03, 0.169E+03, 0.140E+02, 0.29246000E+01, 0.00000000E+00,
  0.28980090E+03, 0.169E+03, 0.150E+02, 0.29246000E+01, 0.00000000E+00,
  0.24047400E+03, 0.169E+03, 0.160E+02, 0.29246000E+01, 0.00000000E+00,
  0.19640620E+03, 0.169E+03, 0.170E+02, 0.29246000E+01, 0.00000000E+00,
  0.16067610E+03, 0.169E+03, 0.180E+02, 0.29246000E+01, 0.00000000E+00,
  0.10876970E+04, 0.169E+03, 0.190E+02, 0.29246000E+01, 0.00000000E+00,
  0.89886340E+03, 0.169E+03, 0.200E+02, 0.29246000E+01, 0.00000000E+00,
  0.74273900E+03, 0.169E+03, 0.210E+02, 0.29246000E+01, 0.00000000E+00,
  0.71728970E+03, 0.169E+03, 0.220E+02, 0.29246000E+01, 0.00000000E+00,
  0.65688060E+03, 0.169E+03, 0.230E+02, 0.29246000E+01, 0.00000000E+00,
  0.51743220E+03, 0.169E+03, 0.240E+02, 0.29246000E+01, 0.00000000E+00,
  0.56559590E+03, 0.169E+03, 0.250E+02, 0.29246000E+01, 0.00000000E+00,
  0.44390510E+03, 0.169E+03, 0.260E+02, 0.29246000E+01, 0.00000000E+00,
  0.47058200E+03, 0.169E+03, 0.270E+02, 0.29246000E+01, 0.00000000E+00,
  0.48475110E+03, 0.169E+03, 0.280E+02, 0.29246000E+01, 0.00000000E+00,
  0.37163760E+03, 0.169E+03, 0.290E+02, 0.29246000E+01, 0.00000000E+00,
  0.38158090E+03, 0.169E+03, 0.300E+02, 0.29246000E+01, 0.00000000E+00,
  0.45190020E+03, 0.169E+03, 0.310E+02, 0.29246000E+01, 0.00000000E+00,
  0.39847870E+03, 0.169E+03, 0.320E+02, 0.29246000E+01, 0.00000000E+00,
  0.33979060E+03, 0.169E+03, 0.330E+02, 0.29246000E+01, 0.00000000E+00,
  0.30483420E+03, 0.169E+03, 0.340E+02, 0.29246000E+01, 0.00000000E+00,
  0.26670930E+03, 0.169E+03, 0.350E+02, 0.29246000E+01, 0.00000000E+00,
  0.23190470E+03, 0.169E+03, 0.360E+02, 0.29246000E+01, 0.00000000E+00,
  0.12190706E+04, 0.169E+03, 0.370E+02, 0.29246000E+01, 0.00000000E+00,
  0.10708351E+04, 0.169E+03, 0.380E+02, 0.29246000E+01, 0.00000000E+00,
  0.93818730E+03, 0.169E+03, 0.390E+02, 0.29246000E+01, 0.00000000E+00,
  0.84323610E+03, 0.169E+03, 0.400E+02, 0.29246000E+01, 0.00000000E+00,
  0.76891010E+03, 0.169E+03, 0.410E+02, 0.29246000E+01, 0.00000000E+00,
  0.59357780E+03, 0.169E+03, 0.420E+02, 0.29246000E+01, 0.00000000E+00,
  0.66231090E+03, 0.169E+03, 0.430E+02, 0.29246000E+01, 0.00000000E+00,
  0.50453730E+03, 0.169E+03, 0.440E+02, 0.29246000E+01, 0.00000000E+00,
  0.55152390E+03, 0.169E+03, 0.450E+02, 0.29246000E+01, 0.00000000E+00,
  0.51144340E+03, 0.169E+03, 0.460E+02, 0.29246000E+01, 0.00000000E+00,
  0.42643750E+03, 0.169E+03, 0.470E+02, 0.29246000E+01, 0.00000000E+00,
  0.45065890E+03, 0.169E+03, 0.480E+02, 0.29246000E+01, 0.00000000E+00,
  0.56556470E+03, 0.169E+03, 0.490E+02, 0.29246000E+01, 0.00000000E+00,
  0.52293560E+03, 0.169E+03, 0.500E+02, 0.29246000E+01, 0.00000000E+00,
  0.46590590E+03, 0.169E+03, 0.510E+02, 0.29246000E+01, 0.00000000E+00,
  0.43217320E+03, 0.169E+03, 0.520E+02, 0.29246000E+01, 0.00000000E+00,
  0.39065890E+03, 0.169E+03, 0.530E+02, 0.29246000E+01, 0.00000000E+00,
  0.35113440E+03, 0.169E+03, 0.540E+02, 0.29246000E+01, 0.00000000E+00,
  0.14849661E+04, 0.169E+03, 0.550E+02, 0.29246000E+01, 0.00000000E+00,
  0.13649240E+04, 0.169E+03, 0.560E+02, 0.29246000E+01, 0.00000000E+00,
  0.11993874E+04, 0.169E+03, 0.570E+02, 0.29246000E+01, 0.00000000E+00,
  0.55042640E+03, 0.169E+03, 0.580E+02, 0.29246000E+01, 0.27991000E+01,
  0.12094663E+04, 0.169E+03, 0.590E+02, 0.29246000E+01, 0.00000000E+00,
  0.11614494E+04, 0.169E+03, 0.600E+02, 0.29246000E+01, 0.00000000E+00,
  0.11323365E+04, 0.169E+03, 0.610E+02, 0.29246000E+01, 0.00000000E+00,
  0.11055604E+04, 0.169E+03, 0.620E+02, 0.29246000E+01, 0.00000000E+00,
  0.10818160E+04, 0.169E+03, 0.630E+02, 0.29246000E+01, 0.00000000E+00,
  0.85075460E+03, 0.169E+03, 0.640E+02, 0.29246000E+01, 0.00000000E+00,
  0.95749480E+03, 0.169E+03, 0.650E+02, 0.29246000E+01, 0.00000000E+00,
  0.92347850E+03, 0.169E+03, 0.660E+02, 0.29246000E+01, 0.00000000E+00,
  0.97580850E+03, 0.169E+03, 0.670E+02, 0.29246000E+01, 0.00000000E+00,
  0.95511040E+03, 0.169E+03, 0.680E+02, 0.29246000E+01, 0.00000000E+00,
  0.93644570E+03, 0.169E+03, 0.690E+02, 0.29246000E+01, 0.00000000E+00,
  0.92549440E+03, 0.169E+03, 0.700E+02, 0.29246000E+01, 0.00000000E+00,
  0.77979590E+03, 0.169E+03, 0.710E+02, 0.29246000E+01, 0.00000000E+00,
  0.76690850E+03, 0.169E+03, 0.720E+02, 0.29246000E+01, 0.00000000E+00,
  0.69985110E+03, 0.169E+03, 0.730E+02, 0.29246000E+01, 0.00000000E+00,
  0.59088900E+03, 0.169E+03, 0.740E+02, 0.29246000E+01, 0.00000000E+00,
  0.60112600E+03, 0.169E+03, 0.750E+02, 0.29246000E+01, 0.00000000E+00,
  0.54476460E+03, 0.169E+03, 0.760E+02, 0.29246000E+01, 0.00000000E+00,
  0.49887240E+03, 0.169E+03, 0.770E+02, 0.29246000E+01, 0.00000000E+00,
  0.41437420E+03, 0.169E+03, 0.780E+02, 0.29246000E+01, 0.00000000E+00,
  0.38714220E+03, 0.169E+03, 0.790E+02, 0.29246000E+01, 0.00000000E+00,
  0.39824650E+03, 0.169E+03, 0.800E+02, 0.29246000E+01, 0.00000000E+00,
  0.58061670E+03, 0.169E+03, 0.810E+02, 0.29246000E+01, 0.00000000E+00,
  0.56766880E+03, 0.169E+03, 0.820E+02, 0.29246000E+01, 0.00000000E+00,
  0.52151170E+03, 0.169E+03, 0.830E+02, 0.29246000E+01, 0.00000000E+00,
  0.49729730E+03, 0.169E+03, 0.840E+02, 0.29246000E+01, 0.00000000E+00,
  0.45884250E+03, 0.169E+03, 0.850E+02, 0.29246000E+01, 0.00000000E+00,
  0.42045390E+03, 0.169E+03, 0.860E+02, 0.29246000E+01, 0.00000000E+00,
  0.14024613E+04, 0.169E+03, 0.870E+02, 0.29246000E+01, 0.00000000E+00,
  0.13497931E+04, 0.169E+03, 0.880E+02, 0.29246000E+01, 0.00000000E+00,
  0.11933412E+04, 0.169E+03, 0.890E+02, 0.29246000E+01, 0.00000000E+00,
  0.10724182E+04, 0.169E+03, 0.900E+02, 0.29246000E+01, 0.00000000E+00,
  0.10647199E+04, 0.169E+03, 0.910E+02, 0.29246000E+01, 0.00000000E+00,
  0.10309456E+04, 0.169E+03, 0.920E+02, 0.29246000E+01, 0.00000000E+00,
  0.10614860E+04, 0.169E+03, 0.930E+02, 0.29246000E+01, 0.00000000E+00,
  0.10279565E+04, 0.169E+03, 0.940E+02, 0.29246000E+01, 0.00000000E+00,
  0.57593700E+02, 0.169E+03, 0.101E+03, 0.29246000E+01, 0.00000000E+00,
  0.18672100E+03, 0.169E+03, 0.103E+03, 0.29246000E+01, 0.98650000E+00,
  0.23814200E+03, 0.169E+03, 0.104E+03, 0.29246000E+01, 0.98080000E+00,
  0.18193830E+03, 0.169E+03, 0.105E+03, 0.29246000E+01, 0.97060000E+00,
  0.13705810E+03, 0.169E+03, 0.106E+03, 0.29246000E+01, 0.98680000E+00,
  0.95297900E+02, 0.169E+03, 0.107E+03, 0.29246000E+01, 0.99440000E+00,
  0.69413700E+02, 0.169E+03, 0.108E+03, 0.29246000E+01, 0.99250000E+00,
  0.47755100E+02, 0.169E+03, 0.109E+03, 0.29246000E+01, 0.99820000E+00,
  0.27296680E+03, 0.169E+03, 0.111E+03, 0.29246000E+01, 0.96840000E+00,
  0.42211770E+03, 0.169E+03, 0.112E+03, 0.29246000E+01, 0.96280000E+00,
  0.42756550E+03, 0.169E+03, 0.113E+03, 0.29246000E+01, 0.96480000E+00,
  0.34354750E+03, 0.169E+03, 0.114E+03, 0.29246000E+01, 0.95070000E+00,
  0.28129780E+03, 0.169E+03, 0.115E+03, 0.29246000E+01, 0.99470000E+00,
  0.23782830E+03, 0.169E+03, 0.116E+03, 0.29246000E+01, 0.99480000E+00,
  0.19437320E+03, 0.169E+03, 0.117E+03, 0.29246000E+01, 0.99720000E+00,
  0.37630470E+03, 0.169E+03, 0.119E+03, 0.29246000E+01, 0.97670000E+00,
  0.71887190E+03, 0.169E+03, 0.120E+03, 0.29246000E+01, 0.98310000E+00,
  0.37645520E+03, 0.169E+03, 0.121E+03, 0.29246000E+01, 0.18627000E+01,
  0.36340760E+03, 0.169E+03, 0.122E+03, 0.29246000E+01, 0.18299000E+01,
  0.35615030E+03, 0.169E+03, 0.123E+03, 0.29246000E+01, 0.19138000E+01,
  0.35286320E+03, 0.169E+03, 0.124E+03, 0.29246000E+01, 0.18269000E+01,
  0.32467610E+03, 0.169E+03, 0.125E+03, 0.29246000E+01, 0.16406000E+01,
  0.30047150E+03, 0.169E+03, 0.126E+03, 0.29246000E+01, 0.16483000E+01,
  0.28663320E+03, 0.169E+03, 0.127E+03, 0.29246000E+01, 0.17149000E+01,
  0.28022740E+03, 0.169E+03, 0.128E+03, 0.29246000E+01, 0.17937000E+01,
  0.27690380E+03, 0.169E+03, 0.129E+03, 0.29246000E+01, 0.95760000E+00,
  0.25976130E+03, 0.169E+03, 0.130E+03, 0.29246000E+01, 0.19419000E+01,
  0.42442030E+03, 0.169E+03, 0.131E+03, 0.29246000E+01, 0.96010000E+00,
  0.37275950E+03, 0.169E+03, 0.132E+03, 0.29246000E+01, 0.94340000E+00,
  0.33401900E+03, 0.169E+03, 0.133E+03, 0.29246000E+01, 0.98890000E+00,
  0.30495200E+03, 0.169E+03, 0.134E+03, 0.29246000E+01, 0.99010000E+00,
  0.26856840E+03, 0.169E+03, 0.135E+03, 0.29246000E+01, 0.99740000E+00,
  0.44898400E+03, 0.169E+03, 0.137E+03, 0.29246000E+01, 0.97380000E+00,
  0.87467070E+03, 0.169E+03, 0.138E+03, 0.29246000E+01, 0.98010000E+00,
  0.66876560E+03, 0.169E+03, 0.139E+03, 0.29246000E+01, 0.19153000E+01,
  0.49783950E+03, 0.169E+03, 0.140E+03, 0.29246000E+01, 0.19355000E+01,
  0.50278080E+03, 0.169E+03, 0.141E+03, 0.29246000E+01, 0.19545000E+01,
  0.46880410E+03, 0.169E+03, 0.142E+03, 0.29246000E+01, 0.19420000E+01,
  0.52574810E+03, 0.169E+03, 0.143E+03, 0.29246000E+01, 0.16682000E+01,
  0.40862370E+03, 0.169E+03, 0.144E+03, 0.29246000E+01, 0.18584000E+01,
  0.38227390E+03, 0.169E+03, 0.145E+03, 0.29246000E+01, 0.19003000E+01,
  0.35497280E+03, 0.169E+03, 0.146E+03, 0.29246000E+01, 0.18630000E+01,
  0.34340860E+03, 0.169E+03, 0.147E+03, 0.29246000E+01, 0.96790000E+00,
  0.33969190E+03, 0.169E+03, 0.148E+03, 0.29246000E+01, 0.19539000E+01,
  0.53908680E+03, 0.169E+03, 0.149E+03, 0.29246000E+01, 0.96330000E+00,
  0.48762850E+03, 0.169E+03, 0.150E+03, 0.29246000E+01, 0.95140000E+00,
  0.45659480E+03, 0.169E+03, 0.151E+03, 0.29246000E+01, 0.97490000E+00,
  0.43185070E+03, 0.169E+03, 0.152E+03, 0.29246000E+01, 0.98110000E+00,
  0.39432570E+03, 0.169E+03, 0.153E+03, 0.29246000E+01, 0.99680000E+00,
  0.53087060E+03, 0.169E+03, 0.155E+03, 0.29246000E+01, 0.99090000E+00,
  0.11338329E+04, 0.169E+03, 0.156E+03, 0.29246000E+01, 0.97970000E+00,
  0.84637940E+03, 0.169E+03, 0.157E+03, 0.29246000E+01, 0.19373000E+01,
  0.53382250E+03, 0.169E+03, 0.159E+03, 0.29246000E+01, 0.29425000E+01,
  0.52278360E+03, 0.169E+03, 0.160E+03, 0.29246000E+01, 0.29455000E+01,
  0.50620810E+03, 0.169E+03, 0.161E+03, 0.29246000E+01, 0.29413000E+01,
  0.50870480E+03, 0.169E+03, 0.162E+03, 0.29246000E+01, 0.29300000E+01,
  0.49043340E+03, 0.169E+03, 0.163E+03, 0.29246000E+01, 0.18286000E+01,
  0.51192810E+03, 0.169E+03, 0.164E+03, 0.29246000E+01, 0.28732000E+01,
  0.48082180E+03, 0.169E+03, 0.165E+03, 0.29246000E+01, 0.29086000E+01,
  0.48926080E+03, 0.169E+03, 0.166E+03, 0.29246000E+01, 0.28965000E+01,
  0.45637280E+03, 0.169E+03, 0.167E+03, 0.29246000E+01, 0.29242000E+01,
  0.44336390E+03, 0.169E+03, 0.168E+03, 0.29246000E+01, 0.29282000E+01,
  0.44052280E+03, 0.169E+03, 0.169E+03, 0.29246000E+01, 0.29246000E+01,
  0.37398600E+02, 0.170E+03, 0.100E+01, 0.28482000E+01, 0.91180000E+00,
  0.24543500E+02, 0.170E+03, 0.200E+01, 0.28482000E+01, 0.00000000E+00,
  0.59236510E+03, 0.170E+03, 0.300E+01, 0.28482000E+01, 0.00000000E+00,
  0.34023850E+03, 0.170E+03, 0.400E+01, 0.28482000E+01, 0.00000000E+00,
  0.22788020E+03, 0.170E+03, 0.500E+01, 0.28482000E+01, 0.00000000E+00,
  0.15321460E+03, 0.170E+03, 0.600E+01, 0.28482000E+01, 0.00000000E+00,
  0.10673400E+03, 0.170E+03, 0.700E+01, 0.28482000E+01, 0.00000000E+00,
  0.80586300E+02, 0.170E+03, 0.800E+01, 0.28482000E+01, 0.00000000E+00,
  0.60903100E+02, 0.170E+03, 0.900E+01, 0.28482000E+01, 0.00000000E+00,
  0.46756900E+02, 0.170E+03, 0.100E+02, 0.28482000E+01, 0.00000000E+00,
  0.70806290E+03, 0.170E+03, 0.110E+02, 0.28482000E+01, 0.00000000E+00,
  0.54277630E+03, 0.170E+03, 0.120E+02, 0.28482000E+01, 0.00000000E+00,
  0.49910710E+03, 0.170E+03, 0.130E+02, 0.28482000E+01, 0.00000000E+00,
  0.39184510E+03, 0.170E+03, 0.140E+02, 0.28482000E+01, 0.00000000E+00,
  0.30444600E+03, 0.170E+03, 0.150E+02, 0.28482000E+01, 0.00000000E+00,
  0.25199750E+03, 0.170E+03, 0.160E+02, 0.28482000E+01, 0.00000000E+00,
  0.20529690E+03, 0.170E+03, 0.170E+02, 0.28482000E+01, 0.00000000E+00,
  0.16755260E+03, 0.170E+03, 0.180E+02, 0.28482000E+01, 0.00000000E+00,
  0.11600767E+04, 0.170E+03, 0.190E+02, 0.28482000E+01, 0.00000000E+00,
  0.95507870E+03, 0.170E+03, 0.200E+02, 0.28482000E+01, 0.00000000E+00,
  0.78843250E+03, 0.170E+03, 0.210E+02, 0.28482000E+01, 0.00000000E+00,
  0.76056390E+03, 0.170E+03, 0.220E+02, 0.28482000E+01, 0.00000000E+00,
  0.69606330E+03, 0.170E+03, 0.230E+02, 0.28482000E+01, 0.00000000E+00,
  0.54795880E+03, 0.170E+03, 0.240E+02, 0.28482000E+01, 0.00000000E+00,
  0.59876220E+03, 0.170E+03, 0.250E+02, 0.28482000E+01, 0.00000000E+00,
  0.46957880E+03, 0.170E+03, 0.260E+02, 0.28482000E+01, 0.00000000E+00,
  0.49740630E+03, 0.170E+03, 0.270E+02, 0.28482000E+01, 0.00000000E+00,
  0.51274730E+03, 0.170E+03, 0.280E+02, 0.28482000E+01, 0.00000000E+00,
  0.39280830E+03, 0.170E+03, 0.290E+02, 0.28482000E+01, 0.00000000E+00,
  0.40272690E+03, 0.170E+03, 0.300E+02, 0.28482000E+01, 0.00000000E+00,
  0.47737550E+03, 0.170E+03, 0.310E+02, 0.28482000E+01, 0.00000000E+00,
  0.41982970E+03, 0.170E+03, 0.320E+02, 0.28482000E+01, 0.00000000E+00,
  0.35702170E+03, 0.170E+03, 0.330E+02, 0.28482000E+01, 0.00000000E+00,
  0.31968520E+03, 0.170E+03, 0.340E+02, 0.28482000E+01, 0.00000000E+00,
  0.27912740E+03, 0.170E+03, 0.350E+02, 0.28482000E+01, 0.00000000E+00,
  0.24221470E+03, 0.170E+03, 0.360E+02, 0.28482000E+01, 0.00000000E+00,
  0.12994482E+04, 0.170E+03, 0.370E+02, 0.28482000E+01, 0.00000000E+00,
  0.11377525E+04, 0.170E+03, 0.380E+02, 0.28482000E+01, 0.00000000E+00,
  0.99498690E+03, 0.170E+03, 0.390E+02, 0.28482000E+01, 0.00000000E+00,
  0.89315950E+03, 0.170E+03, 0.400E+02, 0.28482000E+01, 0.00000000E+00,
  0.81367980E+03, 0.170E+03, 0.410E+02, 0.28482000E+01, 0.00000000E+00,
  0.62696020E+03, 0.170E+03, 0.420E+02, 0.28482000E+01, 0.00000000E+00,
  0.70006760E+03, 0.170E+03, 0.430E+02, 0.28482000E+01, 0.00000000E+00,
  0.53219550E+03, 0.170E+03, 0.440E+02, 0.28482000E+01, 0.00000000E+00,
  0.58198660E+03, 0.170E+03, 0.450E+02, 0.28482000E+01, 0.00000000E+00,
  0.53936520E+03, 0.170E+03, 0.460E+02, 0.28482000E+01, 0.00000000E+00,
  0.44956060E+03, 0.170E+03, 0.470E+02, 0.28482000E+01, 0.00000000E+00,
  0.47487730E+03, 0.170E+03, 0.480E+02, 0.28482000E+01, 0.00000000E+00,
  0.59714660E+03, 0.170E+03, 0.490E+02, 0.28482000E+01, 0.00000000E+00,
  0.55105660E+03, 0.170E+03, 0.500E+02, 0.28482000E+01, 0.00000000E+00,
  0.48986860E+03, 0.170E+03, 0.510E+02, 0.28482000E+01, 0.00000000E+00,
  0.45372430E+03, 0.170E+03, 0.520E+02, 0.28482000E+01, 0.00000000E+00,
  0.40944070E+03, 0.170E+03, 0.530E+02, 0.28482000E+01, 0.00000000E+00,
  0.36738410E+03, 0.170E+03, 0.540E+02, 0.28482000E+01, 0.00000000E+00,
  0.15825500E+04, 0.170E+03, 0.550E+02, 0.28482000E+01, 0.00000000E+00,
  0.14507794E+04, 0.170E+03, 0.560E+02, 0.28482000E+01, 0.00000000E+00,
  0.12725822E+04, 0.170E+03, 0.570E+02, 0.28482000E+01, 0.00000000E+00,
  0.57883400E+03, 0.170E+03, 0.580E+02, 0.28482000E+01, 0.27991000E+01,
  0.12846682E+04, 0.170E+03, 0.590E+02, 0.28482000E+01, 0.00000000E+00,
  0.12333365E+04, 0.170E+03, 0.600E+02, 0.28482000E+01, 0.00000000E+00,
  0.12023371E+04, 0.170E+03, 0.610E+02, 0.28482000E+01, 0.00000000E+00,
  0.11738392E+04, 0.170E+03, 0.620E+02, 0.28482000E+01, 0.00000000E+00,
  0.11485655E+04, 0.170E+03, 0.630E+02, 0.28482000E+01, 0.00000000E+00,
  0.90112100E+03, 0.170E+03, 0.640E+02, 0.28482000E+01, 0.00000000E+00,
  0.10169049E+04, 0.170E+03, 0.650E+02, 0.28482000E+01, 0.00000000E+00,
  0.98043260E+03, 0.170E+03, 0.660E+02, 0.28482000E+01, 0.00000000E+00,
  0.10356000E+04, 0.170E+03, 0.670E+02, 0.28482000E+01, 0.00000000E+00,
  0.10136038E+04, 0.170E+03, 0.680E+02, 0.28482000E+01, 0.00000000E+00,
  0.99374150E+03, 0.170E+03, 0.690E+02, 0.28482000E+01, 0.00000000E+00,
  0.98222660E+03, 0.170E+03, 0.700E+02, 0.28482000E+01, 0.00000000E+00,
  0.82628510E+03, 0.170E+03, 0.710E+02, 0.28482000E+01, 0.00000000E+00,
  0.81115710E+03, 0.170E+03, 0.720E+02, 0.28482000E+01, 0.00000000E+00,
  0.73922210E+03, 0.170E+03, 0.730E+02, 0.28482000E+01, 0.00000000E+00,
  0.62322500E+03, 0.170E+03, 0.740E+02, 0.28482000E+01, 0.00000000E+00,
  0.63376790E+03, 0.170E+03, 0.750E+02, 0.28482000E+01, 0.00000000E+00,
  0.57362030E+03, 0.170E+03, 0.760E+02, 0.28482000E+01, 0.00000000E+00,
  0.52473400E+03, 0.170E+03, 0.770E+02, 0.28482000E+01, 0.00000000E+00,
  0.43520090E+03, 0.170E+03, 0.780E+02, 0.28482000E+01, 0.00000000E+00,
  0.40635950E+03, 0.170E+03, 0.790E+02, 0.28482000E+01, 0.00000000E+00,
  0.41792020E+03, 0.170E+03, 0.800E+02, 0.28482000E+01, 0.00000000E+00,
  0.61237220E+03, 0.170E+03, 0.810E+02, 0.28482000E+01, 0.00000000E+00,
  0.59791090E+03, 0.170E+03, 0.820E+02, 0.28482000E+01, 0.00000000E+00,
  0.54826140E+03, 0.170E+03, 0.830E+02, 0.28482000E+01, 0.00000000E+00,
  0.52217940E+03, 0.170E+03, 0.840E+02, 0.28482000E+01, 0.00000000E+00,
  0.48105700E+03, 0.170E+03, 0.850E+02, 0.28482000E+01, 0.00000000E+00,
  0.44014200E+03, 0.170E+03, 0.860E+02, 0.28482000E+01, 0.00000000E+00,
  0.14924670E+04, 0.170E+03, 0.870E+02, 0.28482000E+01, 0.00000000E+00,
  0.14332640E+04, 0.170E+03, 0.880E+02, 0.28482000E+01, 0.00000000E+00,
  0.12650809E+04, 0.170E+03, 0.890E+02, 0.28482000E+01, 0.00000000E+00,
  0.11344175E+04, 0.170E+03, 0.900E+02, 0.28482000E+01, 0.00000000E+00,
  0.11272049E+04, 0.170E+03, 0.910E+02, 0.28482000E+01, 0.00000000E+00,
  0.10913656E+04, 0.170E+03, 0.920E+02, 0.28482000E+01, 0.00000000E+00,
  0.11251094E+04, 0.170E+03, 0.930E+02, 0.28482000E+01, 0.00000000E+00,
  0.10893370E+04, 0.170E+03, 0.940E+02, 0.28482000E+01, 0.00000000E+00,
  0.60487100E+02, 0.170E+03, 0.101E+03, 0.28482000E+01, 0.00000000E+00,
  0.19759460E+03, 0.170E+03, 0.103E+03, 0.28482000E+01, 0.98650000E+00,
  0.25172230E+03, 0.170E+03, 0.104E+03, 0.28482000E+01, 0.98080000E+00,
  0.19141090E+03, 0.170E+03, 0.105E+03, 0.28482000E+01, 0.97060000E+00,
  0.14369300E+03, 0.170E+03, 0.106E+03, 0.28482000E+01, 0.98680000E+00,
  0.99505900E+02, 0.170E+03, 0.107E+03, 0.28482000E+01, 0.99440000E+00,
  0.72218200E+02, 0.170E+03, 0.108E+03, 0.28482000E+01, 0.99250000E+00,
  0.49450200E+02, 0.170E+03, 0.109E+03, 0.28482000E+01, 0.99820000E+00,
  0.28901230E+03, 0.170E+03, 0.111E+03, 0.28482000E+01, 0.96840000E+00,
  0.44716520E+03, 0.170E+03, 0.112E+03, 0.28482000E+01, 0.96280000E+00,
  0.45200550E+03, 0.170E+03, 0.113E+03, 0.28482000E+01, 0.96480000E+00,
  0.36191400E+03, 0.170E+03, 0.114E+03, 0.28482000E+01, 0.95070000E+00,
  0.29546110E+03, 0.170E+03, 0.115E+03, 0.28482000E+01, 0.99470000E+00,
  0.24922870E+03, 0.170E+03, 0.116E+03, 0.28482000E+01, 0.99480000E+00,
  0.20317400E+03, 0.170E+03, 0.117E+03, 0.28482000E+01, 0.99720000E+00,
  0.39728560E+03, 0.170E+03, 0.119E+03, 0.28482000E+01, 0.97670000E+00,
  0.76326450E+03, 0.170E+03, 0.120E+03, 0.28482000E+01, 0.98310000E+00,
  0.39658450E+03, 0.170E+03, 0.121E+03, 0.28482000E+01, 0.18627000E+01,
  0.38275050E+03, 0.170E+03, 0.122E+03, 0.28482000E+01, 0.18299000E+01,
  0.37510830E+03, 0.170E+03, 0.123E+03, 0.28482000E+01, 0.19138000E+01,
  0.37175280E+03, 0.170E+03, 0.124E+03, 0.28482000E+01, 0.18269000E+01,
  0.34156320E+03, 0.170E+03, 0.125E+03, 0.28482000E+01, 0.16406000E+01,
  0.31590920E+03, 0.170E+03, 0.126E+03, 0.28482000E+01, 0.16483000E+01,
  0.30132730E+03, 0.170E+03, 0.127E+03, 0.28482000E+01, 0.17149000E+01,
  0.29462620E+03, 0.170E+03, 0.128E+03, 0.28482000E+01, 0.17937000E+01,
  0.29146390E+03, 0.170E+03, 0.129E+03, 0.28482000E+01, 0.95760000E+00,
  0.27284960E+03, 0.170E+03, 0.130E+03, 0.28482000E+01, 0.19419000E+01,
  0.44803280E+03, 0.170E+03, 0.131E+03, 0.28482000E+01, 0.96010000E+00,
  0.39245010E+03, 0.170E+03, 0.132E+03, 0.28482000E+01, 0.94340000E+00,
  0.35089060E+03, 0.170E+03, 0.133E+03, 0.28482000E+01, 0.98890000E+00,
  0.31981290E+03, 0.170E+03, 0.134E+03, 0.28482000E+01, 0.99010000E+00,
  0.28109900E+03, 0.170E+03, 0.135E+03, 0.28482000E+01, 0.99740000E+00,
  0.47364740E+03, 0.170E+03, 0.137E+03, 0.28482000E+01, 0.97380000E+00,
  0.92871230E+03, 0.170E+03, 0.138E+03, 0.28482000E+01, 0.98010000E+00,
  0.70739100E+03, 0.170E+03, 0.139E+03, 0.28482000E+01, 0.19153000E+01,
  0.52442450E+03, 0.170E+03, 0.140E+03, 0.28482000E+01, 0.19355000E+01,
  0.52963760E+03, 0.170E+03, 0.141E+03, 0.28482000E+01, 0.19545000E+01,
  0.49348140E+03, 0.170E+03, 0.142E+03, 0.28482000E+01, 0.19420000E+01,
  0.55447820E+03, 0.170E+03, 0.143E+03, 0.28482000E+01, 0.16682000E+01,
  0.42941670E+03, 0.170E+03, 0.144E+03, 0.28482000E+01, 0.18584000E+01,
  0.40159420E+03, 0.170E+03, 0.145E+03, 0.28482000E+01, 0.19003000E+01,
  0.37273910E+03, 0.170E+03, 0.146E+03, 0.28482000E+01, 0.18630000E+01,
  0.36066920E+03, 0.170E+03, 0.147E+03, 0.28482000E+01, 0.96790000E+00,
  0.35642060E+03, 0.170E+03, 0.148E+03, 0.28482000E+01, 0.19539000E+01,
  0.56876740E+03, 0.170E+03, 0.149E+03, 0.28482000E+01, 0.96330000E+00,
  0.51338040E+03, 0.170E+03, 0.150E+03, 0.28482000E+01, 0.95140000E+00,
  0.47992240E+03, 0.170E+03, 0.151E+03, 0.28482000E+01, 0.97490000E+00,
  0.45334590E+03, 0.170E+03, 0.152E+03, 0.28482000E+01, 0.98110000E+00,
  0.41330020E+03, 0.170E+03, 0.153E+03, 0.28482000E+01, 0.99680000E+00,
  0.55918680E+03, 0.170E+03, 0.155E+03, 0.28482000E+01, 0.99090000E+00,
  0.12045119E+04, 0.170E+03, 0.156E+03, 0.28482000E+01, 0.97970000E+00,
  0.89547410E+03, 0.170E+03, 0.157E+03, 0.28482000E+01, 0.19373000E+01,
  0.56128730E+03, 0.170E+03, 0.159E+03, 0.28482000E+01, 0.29425000E+01,
  0.54966430E+03, 0.170E+03, 0.160E+03, 0.28482000E+01, 0.29455000E+01,
  0.53216530E+03, 0.170E+03, 0.161E+03, 0.28482000E+01, 0.29413000E+01,
  0.53496580E+03, 0.170E+03, 0.162E+03, 0.28482000E+01, 0.29300000E+01,
  0.51624120E+03, 0.170E+03, 0.163E+03, 0.28482000E+01, 0.18286000E+01,
  0.53845600E+03, 0.170E+03, 0.164E+03, 0.28482000E+01, 0.28732000E+01,
  0.50556900E+03, 0.170E+03, 0.165E+03, 0.28482000E+01, 0.29086000E+01,
  0.51473030E+03, 0.170E+03, 0.166E+03, 0.28482000E+01, 0.28965000E+01,
  0.47973200E+03, 0.170E+03, 0.167E+03, 0.28482000E+01, 0.29242000E+01,
  0.46600690E+03, 0.170E+03, 0.168E+03, 0.28482000E+01, 0.29282000E+01,
  0.46306960E+03, 0.170E+03, 0.169E+03, 0.28482000E+01, 0.29246000E+01,
  0.48707530E+03, 0.170E+03, 0.170E+03, 0.28482000E+01, 0.28482000E+01,
  0.34601200E+02, 0.171E+03, 0.100E+01, 0.29219000E+01, 0.91180000E+00,
  0.22892600E+02, 0.171E+03, 0.200E+01, 0.29219000E+01, 0.00000000E+00,
  0.53345810E+03, 0.171E+03, 0.300E+01, 0.29219000E+01, 0.00000000E+00,
  0.30982450E+03, 0.171E+03, 0.400E+01, 0.29219000E+01, 0.00000000E+00,
  0.20900590E+03, 0.171E+03, 0.500E+01, 0.29219000E+01, 0.00000000E+00,
  0.14134580E+03, 0.171E+03, 0.600E+01, 0.29219000E+01, 0.00000000E+00,
  0.98922300E+02, 0.171E+03, 0.700E+01, 0.29219000E+01, 0.00000000E+00,
  0.74945100E+02, 0.171E+03, 0.800E+01, 0.29219000E+01, 0.00000000E+00,
  0.56812400E+02, 0.171E+03, 0.900E+01, 0.29219000E+01, 0.00000000E+00,
  0.43726300E+02, 0.171E+03, 0.100E+02, 0.29219000E+01, 0.00000000E+00,
  0.63816340E+03, 0.171E+03, 0.110E+02, 0.29219000E+01, 0.00000000E+00,
  0.49328830E+03, 0.171E+03, 0.120E+02, 0.29219000E+01, 0.00000000E+00,
  0.45519600E+03, 0.171E+03, 0.130E+02, 0.29219000E+01, 0.00000000E+00,
  0.35911410E+03, 0.171E+03, 0.140E+02, 0.29219000E+01, 0.00000000E+00,
  0.28024060E+03, 0.171E+03, 0.150E+02, 0.29219000E+01, 0.00000000E+00,
  0.23266870E+03, 0.171E+03, 0.160E+02, 0.29219000E+01, 0.00000000E+00,
  0.19012190E+03, 0.171E+03, 0.170E+02, 0.29219000E+01, 0.00000000E+00,
  0.15559160E+03, 0.171E+03, 0.180E+02, 0.29219000E+01, 0.00000000E+00,
  0.10444701E+04, 0.171E+03, 0.190E+02, 0.29219000E+01, 0.00000000E+00,
  0.86528290E+03, 0.171E+03, 0.200E+02, 0.29219000E+01, 0.00000000E+00,
  0.71536520E+03, 0.171E+03, 0.210E+02, 0.29219000E+01, 0.00000000E+00,
  0.69115730E+03, 0.171E+03, 0.220E+02, 0.29219000E+01, 0.00000000E+00,
  0.63311630E+03, 0.171E+03, 0.230E+02, 0.29219000E+01, 0.00000000E+00,
  0.49870530E+03, 0.171E+03, 0.240E+02, 0.29219000E+01, 0.00000000E+00,
  0.54533910E+03, 0.171E+03, 0.250E+02, 0.29219000E+01, 0.00000000E+00,
  0.42801770E+03, 0.171E+03, 0.260E+02, 0.29219000E+01, 0.00000000E+00,
  0.45401590E+03, 0.171E+03, 0.270E+02, 0.29219000E+01, 0.00000000E+00,
  0.46756420E+03, 0.171E+03, 0.280E+02, 0.29219000E+01, 0.00000000E+00,
  0.35843930E+03, 0.171E+03, 0.290E+02, 0.29219000E+01, 0.00000000E+00,
  0.36835200E+03, 0.171E+03, 0.300E+02, 0.29219000E+01, 0.00000000E+00,
  0.43614550E+03, 0.171E+03, 0.310E+02, 0.29219000E+01, 0.00000000E+00,
  0.38497400E+03, 0.171E+03, 0.320E+02, 0.29219000E+01, 0.00000000E+00,
  0.32854540E+03, 0.171E+03, 0.330E+02, 0.29219000E+01, 0.00000000E+00,
  0.29488120E+03, 0.171E+03, 0.340E+02, 0.29219000E+01, 0.00000000E+00,
  0.25811290E+03, 0.171E+03, 0.350E+02, 0.29219000E+01, 0.00000000E+00,
  0.22451100E+03, 0.171E+03, 0.360E+02, 0.29219000E+01, 0.00000000E+00,
  0.11708400E+04, 0.171E+03, 0.370E+02, 0.29219000E+01, 0.00000000E+00,
  0.10307165E+04, 0.171E+03, 0.380E+02, 0.29219000E+01, 0.00000000E+00,
  0.90385210E+03, 0.171E+03, 0.390E+02, 0.29219000E+01, 0.00000000E+00,
  0.81281250E+03, 0.171E+03, 0.400E+02, 0.29219000E+01, 0.00000000E+00,
  0.74141830E+03, 0.171E+03, 0.410E+02, 0.29219000E+01, 0.00000000E+00,
  0.57266250E+03, 0.171E+03, 0.420E+02, 0.29219000E+01, 0.00000000E+00,
  0.63884880E+03, 0.171E+03, 0.430E+02, 0.29219000E+01, 0.00000000E+00,
  0.48694650E+03, 0.171E+03, 0.440E+02, 0.29219000E+01, 0.00000000E+00,
  0.53231850E+03, 0.171E+03, 0.450E+02, 0.29219000E+01, 0.00000000E+00,
  0.49373180E+03, 0.171E+03, 0.460E+02, 0.29219000E+01, 0.00000000E+00,
  0.41158220E+03, 0.171E+03, 0.470E+02, 0.29219000E+01, 0.00000000E+00,
  0.43515940E+03, 0.171E+03, 0.480E+02, 0.29219000E+01, 0.00000000E+00,
  0.54577490E+03, 0.171E+03, 0.490E+02, 0.29219000E+01, 0.00000000E+00,
  0.50506710E+03, 0.171E+03, 0.500E+02, 0.29219000E+01, 0.00000000E+00,
  0.45032940E+03, 0.171E+03, 0.510E+02, 0.29219000E+01, 0.00000000E+00,
  0.41790250E+03, 0.171E+03, 0.520E+02, 0.29219000E+01, 0.00000000E+00,
  0.37792070E+03, 0.171E+03, 0.530E+02, 0.29219000E+01, 0.00000000E+00,
  0.33981250E+03, 0.171E+03, 0.540E+02, 0.29219000E+01, 0.00000000E+00,
  0.14262370E+04, 0.171E+03, 0.550E+02, 0.29219000E+01, 0.00000000E+00,
  0.13133618E+04, 0.171E+03, 0.560E+02, 0.29219000E+01, 0.00000000E+00,
  0.11551299E+04, 0.171E+03, 0.570E+02, 0.29219000E+01, 0.00000000E+00,
  0.53193250E+03, 0.171E+03, 0.580E+02, 0.29219000E+01, 0.27991000E+01,
  0.11640997E+04, 0.171E+03, 0.590E+02, 0.29219000E+01, 0.00000000E+00,
  0.11180647E+04, 0.171E+03, 0.600E+02, 0.29219000E+01, 0.00000000E+00,
  0.10900872E+04, 0.171E+03, 0.610E+02, 0.29219000E+01, 0.00000000E+00,
  0.10643505E+04, 0.171E+03, 0.620E+02, 0.29219000E+01, 0.00000000E+00,
  0.10415296E+04, 0.171E+03, 0.630E+02, 0.29219000E+01, 0.00000000E+00,
  0.81984680E+03, 0.171E+03, 0.640E+02, 0.29219000E+01, 0.00000000E+00,
  0.92133410E+03, 0.171E+03, 0.650E+02, 0.29219000E+01, 0.00000000E+00,
  0.88874530E+03, 0.171E+03, 0.660E+02, 0.29219000E+01, 0.00000000E+00,
  0.93968880E+03, 0.171E+03, 0.670E+02, 0.29219000E+01, 0.00000000E+00,
  0.91978180E+03, 0.171E+03, 0.680E+02, 0.29219000E+01, 0.00000000E+00,
  0.90184110E+03, 0.171E+03, 0.690E+02, 0.29219000E+01, 0.00000000E+00,
  0.89126080E+03, 0.171E+03, 0.700E+02, 0.29219000E+01, 0.00000000E+00,
  0.75143080E+03, 0.171E+03, 0.710E+02, 0.29219000E+01, 0.00000000E+00,
  0.73969160E+03, 0.171E+03, 0.720E+02, 0.29219000E+01, 0.00000000E+00,
  0.67535320E+03, 0.171E+03, 0.730E+02, 0.29219000E+01, 0.00000000E+00,
  0.57039690E+03, 0.171E+03, 0.740E+02, 0.29219000E+01, 0.00000000E+00,
  0.58039830E+03, 0.171E+03, 0.750E+02, 0.29219000E+01, 0.00000000E+00,
  0.52619340E+03, 0.171E+03, 0.760E+02, 0.29219000E+01, 0.00000000E+00,
  0.48201740E+03, 0.171E+03, 0.770E+02, 0.29219000E+01, 0.00000000E+00,
  0.40048290E+03, 0.171E+03, 0.780E+02, 0.29219000E+01, 0.00000000E+00,
  0.37420390E+03, 0.171E+03, 0.790E+02, 0.29219000E+01, 0.00000000E+00,
  0.38500720E+03, 0.171E+03, 0.800E+02, 0.29219000E+01, 0.00000000E+00,
  0.56037600E+03, 0.171E+03, 0.810E+02, 0.29219000E+01, 0.00000000E+00,
  0.54825190E+03, 0.171E+03, 0.820E+02, 0.29219000E+01, 0.00000000E+00,
  0.50402540E+03, 0.171E+03, 0.830E+02, 0.29219000E+01, 0.00000000E+00,
  0.48080590E+03, 0.171E+03, 0.840E+02, 0.29219000E+01, 0.00000000E+00,
  0.44381570E+03, 0.171E+03, 0.850E+02, 0.29219000E+01, 0.00000000E+00,
  0.40683040E+03, 0.171E+03, 0.860E+02, 0.29219000E+01, 0.00000000E+00,
  0.13480198E+04, 0.171E+03, 0.870E+02, 0.29219000E+01, 0.00000000E+00,
  0.12994057E+04, 0.171E+03, 0.880E+02, 0.29219000E+01, 0.00000000E+00,
  0.11497484E+04, 0.171E+03, 0.890E+02, 0.29219000E+01, 0.00000000E+00,
  0.10341669E+04, 0.171E+03, 0.900E+02, 0.29219000E+01, 0.00000000E+00,
  0.10262543E+04, 0.171E+03, 0.910E+02, 0.29219000E+01, 0.00000000E+00,
  0.99371920E+03, 0.171E+03, 0.920E+02, 0.29219000E+01, 0.00000000E+00,
  0.10225738E+04, 0.171E+03, 0.930E+02, 0.29219000E+01, 0.00000000E+00,
  0.99038000E+03, 0.171E+03, 0.940E+02, 0.29219000E+01, 0.00000000E+00,
  0.55700800E+02, 0.171E+03, 0.101E+03, 0.29219000E+01, 0.00000000E+00,
  0.18012920E+03, 0.171E+03, 0.103E+03, 0.29219000E+01, 0.98650000E+00,
  0.22980950E+03, 0.171E+03, 0.104E+03, 0.29219000E+01, 0.98080000E+00,
  0.17585020E+03, 0.171E+03, 0.105E+03, 0.29219000E+01, 0.97060000E+00,
  0.13257550E+03, 0.171E+03, 0.106E+03, 0.29219000E+01, 0.98680000E+00,
  0.92251200E+02, 0.171E+03, 0.107E+03, 0.29219000E+01, 0.99440000E+00,
  0.67230800E+02, 0.171E+03, 0.108E+03, 0.29219000E+01, 0.99250000E+00,
  0.46277200E+02, 0.171E+03, 0.109E+03, 0.29219000E+01, 0.99820000E+00,
  0.26322190E+03, 0.171E+03, 0.111E+03, 0.29219000E+01, 0.96840000E+00,
  0.40699260E+03, 0.171E+03, 0.112E+03, 0.29219000E+01, 0.96280000E+00,
  0.41261700E+03, 0.171E+03, 0.113E+03, 0.29219000E+01, 0.96480000E+00,
  0.33194510E+03, 0.171E+03, 0.114E+03, 0.29219000E+01, 0.95070000E+00,
  0.27202390E+03, 0.171E+03, 0.115E+03, 0.29219000E+01, 0.99470000E+00,
  0.23010400E+03, 0.171E+03, 0.116E+03, 0.29219000E+01, 0.99480000E+00,
  0.18815090E+03, 0.171E+03, 0.117E+03, 0.29219000E+01, 0.99720000E+00,
  0.36307990E+03, 0.171E+03, 0.119E+03, 0.29219000E+01, 0.97670000E+00,
  0.69200830E+03, 0.171E+03, 0.120E+03, 0.29219000E+01, 0.98310000E+00,
  0.36363190E+03, 0.171E+03, 0.121E+03, 0.29219000E+01, 0.18627000E+01,
  0.35103090E+03, 0.171E+03, 0.122E+03, 0.29219000E+01, 0.18299000E+01,
  0.34401120E+03, 0.171E+03, 0.123E+03, 0.29219000E+01, 0.19138000E+01,
  0.34078980E+03, 0.171E+03, 0.124E+03, 0.29219000E+01, 0.18269000E+01,
  0.31376160E+03, 0.171E+03, 0.125E+03, 0.29219000E+01, 0.16406000E+01,
  0.29041450E+03, 0.171E+03, 0.126E+03, 0.29219000E+01, 0.16483000E+01,
  0.27703380E+03, 0.171E+03, 0.127E+03, 0.29219000E+01, 0.17149000E+01,
  0.27082780E+03, 0.171E+03, 0.128E+03, 0.29219000E+01, 0.17937000E+01,
  0.26748920E+03, 0.171E+03, 0.129E+03, 0.29219000E+01, 0.95760000E+00,
  0.25114070E+03, 0.171E+03, 0.130E+03, 0.29219000E+01, 0.19419000E+01,
  0.40972790E+03, 0.171E+03, 0.131E+03, 0.29219000E+01, 0.96010000E+00,
  0.36020340E+03, 0.171E+03, 0.132E+03, 0.29219000E+01, 0.94340000E+00,
  0.32297840E+03, 0.171E+03, 0.133E+03, 0.29219000E+01, 0.98890000E+00,
  0.29499200E+03, 0.171E+03, 0.134E+03, 0.29219000E+01, 0.99010000E+00,
  0.25990550E+03, 0.171E+03, 0.135E+03, 0.29219000E+01, 0.99740000E+00,
  0.43329230E+03, 0.171E+03, 0.137E+03, 0.29219000E+01, 0.97380000E+00,
  0.84185430E+03, 0.171E+03, 0.138E+03, 0.29219000E+01, 0.98010000E+00,
  0.64480130E+03, 0.171E+03, 0.139E+03, 0.29219000E+01, 0.19153000E+01,
  0.48082360E+03, 0.171E+03, 0.140E+03, 0.29219000E+01, 0.19355000E+01,
  0.48558420E+03, 0.171E+03, 0.141E+03, 0.29219000E+01, 0.19545000E+01,
  0.45284900E+03, 0.171E+03, 0.142E+03, 0.29219000E+01, 0.19420000E+01,
  0.50743830E+03, 0.171E+03, 0.143E+03, 0.29219000E+01, 0.16682000E+01,
  0.39493050E+03, 0.171E+03, 0.144E+03, 0.29219000E+01, 0.18584000E+01,
  0.36947180E+03, 0.171E+03, 0.145E+03, 0.29219000E+01, 0.19003000E+01,
  0.34311040E+03, 0.171E+03, 0.146E+03, 0.29219000E+01, 0.18630000E+01,
  0.33190160E+03, 0.171E+03, 0.147E+03, 0.29219000E+01, 0.96790000E+00,
  0.32846280E+03, 0.171E+03, 0.148E+03, 0.29219000E+01, 0.19539000E+01,
  0.52037630E+03, 0.171E+03, 0.149E+03, 0.29219000E+01, 0.96330000E+00,
  0.47110690E+03, 0.171E+03, 0.150E+03, 0.29219000E+01, 0.95140000E+00,
  0.44137250E+03, 0.171E+03, 0.151E+03, 0.29219000E+01, 0.97490000E+00,
  0.41760220E+03, 0.171E+03, 0.152E+03, 0.29219000E+01, 0.98110000E+00,
  0.38146630E+03, 0.171E+03, 0.153E+03, 0.29219000E+01, 0.99680000E+00,
  0.51266580E+03, 0.171E+03, 0.155E+03, 0.29219000E+01, 0.99090000E+00,
  0.10908422E+04, 0.171E+03, 0.156E+03, 0.29219000E+01, 0.97970000E+00,
  0.81591040E+03, 0.171E+03, 0.157E+03, 0.29219000E+01, 0.19373000E+01,
  0.51590750E+03, 0.171E+03, 0.159E+03, 0.29219000E+01, 0.29425000E+01,
  0.50524280E+03, 0.171E+03, 0.160E+03, 0.29219000E+01, 0.29455000E+01,
  0.48924070E+03, 0.171E+03, 0.161E+03, 0.29219000E+01, 0.29413000E+01,
  0.49159590E+03, 0.171E+03, 0.162E+03, 0.29219000E+01, 0.29300000E+01,
  0.47374820E+03, 0.171E+03, 0.163E+03, 0.29219000E+01, 0.18286000E+01,
  0.49470080E+03, 0.171E+03, 0.164E+03, 0.29219000E+01, 0.28732000E+01,
  0.46468280E+03, 0.171E+03, 0.165E+03, 0.29219000E+01, 0.29086000E+01,
  0.47273450E+03, 0.171E+03, 0.166E+03, 0.29219000E+01, 0.28965000E+01,
  0.44109990E+03, 0.171E+03, 0.167E+03, 0.29219000E+01, 0.29242000E+01,
  0.42854250E+03, 0.171E+03, 0.168E+03, 0.29219000E+01, 0.29282000E+01,
  0.42578520E+03, 0.171E+03, 0.169E+03, 0.29219000E+01, 0.29246000E+01,
  0.44751580E+03, 0.171E+03, 0.170E+03, 0.29219000E+01, 0.28482000E+01,
  0.41156650E+03, 0.171E+03, 0.171E+03, 0.29219000E+01, 0.29219000E+01,
  0.45346600E+02, 0.172E+03, 0.100E+01, 0.19254000E+01, 0.91180000E+00,
  0.28998600E+02, 0.172E+03, 0.200E+01, 0.19254000E+01, 0.00000000E+00,
  0.83344750E+03, 0.172E+03, 0.300E+01, 0.19254000E+01, 0.00000000E+00,
  0.44256360E+03, 0.172E+03, 0.400E+01, 0.19254000E+01, 0.00000000E+00,
  0.28628310E+03, 0.172E+03, 0.500E+01, 0.19254000E+01, 0.00000000E+00,
  0.18798820E+03, 0.172E+03, 0.600E+01, 0.19254000E+01, 0.00000000E+00,
  0.12879820E+03, 0.172E+03, 0.700E+01, 0.19254000E+01, 0.00000000E+00,
  0.96142400E+02, 0.172E+03, 0.800E+01, 0.19254000E+01, 0.00000000E+00,
  0.71959700E+02, 0.172E+03, 0.900E+01, 0.19254000E+01, 0.00000000E+00,
  0.54816700E+02, 0.172E+03, 0.100E+02, 0.19254000E+01, 0.00000000E+00,
  0.99134020E+03, 0.172E+03, 0.110E+02, 0.19254000E+01, 0.00000000E+00,
  0.71475720E+03, 0.172E+03, 0.120E+02, 0.19254000E+01, 0.00000000E+00,
  0.64492820E+03, 0.172E+03, 0.130E+02, 0.19254000E+01, 0.00000000E+00,
  0.49384800E+03, 0.172E+03, 0.140E+02, 0.19254000E+01, 0.00000000E+00,
  0.37640650E+03, 0.172E+03, 0.150E+02, 0.19254000E+01, 0.00000000E+00,
  0.30798130E+03, 0.172E+03, 0.160E+02, 0.19254000E+01, 0.00000000E+00,
  0.24821220E+03, 0.172E+03, 0.170E+02, 0.19254000E+01, 0.00000000E+00,
  0.20073430E+03, 0.172E+03, 0.180E+02, 0.19254000E+01, 0.00000000E+00,
  0.16539476E+04, 0.172E+03, 0.190E+02, 0.19254000E+01, 0.00000000E+00,
  0.12894650E+04, 0.172E+03, 0.200E+02, 0.19254000E+01, 0.00000000E+00,
  0.10530789E+04, 0.172E+03, 0.210E+02, 0.19254000E+01, 0.00000000E+00,
  0.10073778E+04, 0.172E+03, 0.220E+02, 0.19254000E+01, 0.00000000E+00,
  0.91714520E+03, 0.172E+03, 0.230E+02, 0.19254000E+01, 0.00000000E+00,
  0.72238490E+03, 0.172E+03, 0.240E+02, 0.19254000E+01, 0.00000000E+00,
  0.78308020E+03, 0.172E+03, 0.250E+02, 0.19254000E+01, 0.00000000E+00,
  0.61378620E+03, 0.172E+03, 0.260E+02, 0.19254000E+01, 0.00000000E+00,
  0.64219290E+03, 0.172E+03, 0.270E+02, 0.19254000E+01, 0.00000000E+00,
  0.66532650E+03, 0.172E+03, 0.280E+02, 0.19254000E+01, 0.00000000E+00,
  0.51028620E+03, 0.172E+03, 0.290E+02, 0.19254000E+01, 0.00000000E+00,
  0.51419020E+03, 0.172E+03, 0.300E+02, 0.19254000E+01, 0.00000000E+00,
  0.61287020E+03, 0.172E+03, 0.310E+02, 0.19254000E+01, 0.00000000E+00,
  0.52847210E+03, 0.172E+03, 0.320E+02, 0.19254000E+01, 0.00000000E+00,
  0.44218700E+03, 0.172E+03, 0.330E+02, 0.19254000E+01, 0.00000000E+00,
  0.39224560E+03, 0.172E+03, 0.340E+02, 0.19254000E+01, 0.00000000E+00,
  0.33928530E+03, 0.172E+03, 0.350E+02, 0.19254000E+01, 0.00000000E+00,
  0.29196450E+03, 0.172E+03, 0.360E+02, 0.19254000E+01, 0.00000000E+00,
  0.18469699E+04, 0.172E+03, 0.370E+02, 0.19254000E+01, 0.00000000E+00,
  0.15403424E+04, 0.172E+03, 0.380E+02, 0.19254000E+01, 0.00000000E+00,
  0.13230311E+04, 0.172E+03, 0.390E+02, 0.19254000E+01, 0.00000000E+00,
  0.11750345E+04, 0.172E+03, 0.400E+02, 0.19254000E+01, 0.00000000E+00,
  0.10634756E+04, 0.172E+03, 0.410E+02, 0.19254000E+01, 0.00000000E+00,
  0.81065520E+03, 0.172E+03, 0.420E+02, 0.19254000E+01, 0.00000000E+00,
  0.90884210E+03, 0.172E+03, 0.430E+02, 0.19254000E+01, 0.00000000E+00,
  0.68268070E+03, 0.172E+03, 0.440E+02, 0.19254000E+01, 0.00000000E+00,
  0.74565500E+03, 0.172E+03, 0.450E+02, 0.19254000E+01, 0.00000000E+00,
  0.68814480E+03, 0.172E+03, 0.460E+02, 0.19254000E+01, 0.00000000E+00,
  0.57595500E+03, 0.172E+03, 0.470E+02, 0.19254000E+01, 0.00000000E+00,
  0.60264510E+03, 0.172E+03, 0.480E+02, 0.19254000E+01, 0.00000000E+00,
  0.76801030E+03, 0.172E+03, 0.490E+02, 0.19254000E+01, 0.00000000E+00,
  0.69681050E+03, 0.172E+03, 0.500E+02, 0.19254000E+01, 0.00000000E+00,
  0.61025270E+03, 0.172E+03, 0.510E+02, 0.19254000E+01, 0.00000000E+00,
  0.56048120E+03, 0.172E+03, 0.520E+02, 0.19254000E+01, 0.00000000E+00,
  0.50136210E+03, 0.172E+03, 0.530E+02, 0.19254000E+01, 0.00000000E+00,
  0.44626410E+03, 0.172E+03, 0.540E+02, 0.19254000E+01, 0.00000000E+00,
  0.22528586E+04, 0.172E+03, 0.550E+02, 0.19254000E+01, 0.00000000E+00,
  0.19789909E+04, 0.172E+03, 0.560E+02, 0.19254000E+01, 0.00000000E+00,
  0.17040270E+04, 0.172E+03, 0.570E+02, 0.19254000E+01, 0.00000000E+00,
  0.72344560E+03, 0.172E+03, 0.580E+02, 0.19254000E+01, 0.27991000E+01,
  0.17420729E+04, 0.172E+03, 0.590E+02, 0.19254000E+01, 0.00000000E+00,
  0.16661615E+04, 0.172E+03, 0.600E+02, 0.19254000E+01, 0.00000000E+00,
  0.16226978E+04, 0.172E+03, 0.610E+02, 0.19254000E+01, 0.00000000E+00,
  0.15829071E+04, 0.172E+03, 0.620E+02, 0.19254000E+01, 0.00000000E+00,
  0.15475750E+04, 0.172E+03, 0.630E+02, 0.19254000E+01, 0.00000000E+00,
  0.11920226E+04, 0.172E+03, 0.640E+02, 0.19254000E+01, 0.00000000E+00,
  0.13894684E+04, 0.172E+03, 0.650E+02, 0.19254000E+01, 0.00000000E+00,
  0.13360613E+04, 0.172E+03, 0.660E+02, 0.19254000E+01, 0.00000000E+00,
  0.13884173E+04, 0.172E+03, 0.670E+02, 0.19254000E+01, 0.00000000E+00,
  0.13581065E+04, 0.172E+03, 0.680E+02, 0.19254000E+01, 0.00000000E+00,
  0.13304473E+04, 0.172E+03, 0.690E+02, 0.19254000E+01, 0.00000000E+00,
  0.13159859E+04, 0.172E+03, 0.700E+02, 0.19254000E+01, 0.00000000E+00,
  0.10939351E+04, 0.172E+03, 0.710E+02, 0.19254000E+01, 0.00000000E+00,
  0.10543108E+04, 0.172E+03, 0.720E+02, 0.19254000E+01, 0.00000000E+00,
  0.95118510E+03, 0.172E+03, 0.730E+02, 0.19254000E+01, 0.00000000E+00,
  0.79676620E+03, 0.172E+03, 0.740E+02, 0.19254000E+01, 0.00000000E+00,
  0.80679990E+03, 0.172E+03, 0.750E+02, 0.19254000E+01, 0.00000000E+00,
  0.72412960E+03, 0.172E+03, 0.760E+02, 0.19254000E+01, 0.00000000E+00,
  0.65806160E+03, 0.172E+03, 0.770E+02, 0.19254000E+01, 0.00000000E+00,
  0.54245470E+03, 0.172E+03, 0.780E+02, 0.19254000E+01, 0.00000000E+00,
  0.50520370E+03, 0.172E+03, 0.790E+02, 0.19254000E+01, 0.00000000E+00,
  0.51767100E+03, 0.172E+03, 0.800E+02, 0.19254000E+01, 0.00000000E+00,
  0.78562040E+03, 0.172E+03, 0.810E+02, 0.19254000E+01, 0.00000000E+00,
  0.75633770E+03, 0.172E+03, 0.820E+02, 0.19254000E+01, 0.00000000E+00,
  0.68397230E+03, 0.172E+03, 0.830E+02, 0.19254000E+01, 0.00000000E+00,
  0.64657460E+03, 0.172E+03, 0.840E+02, 0.19254000E+01, 0.00000000E+00,
  0.59053860E+03, 0.172E+03, 0.850E+02, 0.19254000E+01, 0.00000000E+00,
  0.53625670E+03, 0.172E+03, 0.860E+02, 0.19254000E+01, 0.00000000E+00,
  0.20908542E+04, 0.172E+03, 0.870E+02, 0.19254000E+01, 0.00000000E+00,
  0.19370166E+04, 0.172E+03, 0.880E+02, 0.19254000E+01, 0.00000000E+00,
  0.16804201E+04, 0.172E+03, 0.890E+02, 0.19254000E+01, 0.00000000E+00,
  0.14797956E+04, 0.172E+03, 0.900E+02, 0.19254000E+01, 0.00000000E+00,
  0.14847146E+04, 0.172E+03, 0.910E+02, 0.19254000E+01, 0.00000000E+00,
  0.14366817E+04, 0.172E+03, 0.920E+02, 0.19254000E+01, 0.00000000E+00,
  0.14973302E+04, 0.172E+03, 0.930E+02, 0.19254000E+01, 0.00000000E+00,
  0.14464901E+04, 0.172E+03, 0.940E+02, 0.19254000E+01, 0.00000000E+00,
  0.74629200E+02, 0.172E+03, 0.101E+03, 0.19254000E+01, 0.00000000E+00,
  0.25592080E+03, 0.172E+03, 0.103E+03, 0.19254000E+01, 0.98650000E+00,
  0.32443230E+03, 0.172E+03, 0.104E+03, 0.19254000E+01, 0.98080000E+00,
  0.23897670E+03, 0.172E+03, 0.105E+03, 0.19254000E+01, 0.97060000E+00,
  0.17654080E+03, 0.172E+03, 0.106E+03, 0.19254000E+01, 0.98680000E+00,
  0.12010680E+03, 0.172E+03, 0.107E+03, 0.19254000E+01, 0.99440000E+00,
  0.85937000E+02, 0.172E+03, 0.108E+03, 0.19254000E+01, 0.99250000E+00,
  0.57827200E+02, 0.172E+03, 0.109E+03, 0.19254000E+01, 0.99820000E+00,
  0.37699540E+03, 0.172E+03, 0.111E+03, 0.19254000E+01, 0.96840000E+00,
  0.58570530E+03, 0.172E+03, 0.112E+03, 0.19254000E+01, 0.96280000E+00,
  0.58157180E+03, 0.172E+03, 0.113E+03, 0.19254000E+01, 0.96480000E+00,
  0.45471270E+03, 0.172E+03, 0.114E+03, 0.19254000E+01, 0.95070000E+00,
  0.36512350E+03, 0.172E+03, 0.115E+03, 0.19254000E+01, 0.99470000E+00,
  0.30470560E+03, 0.172E+03, 0.116E+03, 0.19254000E+01, 0.99480000E+00,
  0.24570480E+03, 0.172E+03, 0.117E+03, 0.19254000E+01, 0.99720000E+00,
  0.51281530E+03, 0.172E+03, 0.119E+03, 0.19254000E+01, 0.97670000E+00,
  0.10341456E+04, 0.172E+03, 0.120E+03, 0.19254000E+01, 0.98310000E+00,
  0.50045280E+03, 0.172E+03, 0.121E+03, 0.19254000E+01, 0.18627000E+01,
  0.48316910E+03, 0.172E+03, 0.122E+03, 0.19254000E+01, 0.18299000E+01,
  0.47364140E+03, 0.172E+03, 0.123E+03, 0.19254000E+01, 0.19138000E+01,
  0.47060760E+03, 0.172E+03, 0.124E+03, 0.19254000E+01, 0.18269000E+01,
  0.42699780E+03, 0.172E+03, 0.125E+03, 0.19254000E+01, 0.16406000E+01,
  0.39370530E+03, 0.172E+03, 0.126E+03, 0.19254000E+01, 0.16483000E+01,
  0.37565220E+03, 0.172E+03, 0.127E+03, 0.19254000E+01, 0.17149000E+01,
  0.36764140E+03, 0.172E+03, 0.128E+03, 0.19254000E+01, 0.17937000E+01,
  0.36693480E+03, 0.172E+03, 0.129E+03, 0.19254000E+01, 0.95760000E+00,
  0.33796290E+03, 0.172E+03, 0.130E+03, 0.19254000E+01, 0.19419000E+01,
  0.57232270E+03, 0.172E+03, 0.131E+03, 0.19254000E+01, 0.96010000E+00,
  0.49197380E+03, 0.172E+03, 0.132E+03, 0.19254000E+01, 0.94340000E+00,
  0.43422870E+03, 0.172E+03, 0.133E+03, 0.19254000E+01, 0.98890000E+00,
  0.39247750E+03, 0.172E+03, 0.134E+03, 0.19254000E+01, 0.99010000E+00,
  0.34185570E+03, 0.172E+03, 0.135E+03, 0.19254000E+01, 0.99740000E+00,
  0.60910480E+03, 0.172E+03, 0.137E+03, 0.19254000E+01, 0.97380000E+00,
  0.12632459E+04, 0.172E+03, 0.138E+03, 0.19254000E+01, 0.98010000E+00,
  0.92911650E+03, 0.172E+03, 0.139E+03, 0.19254000E+01, 0.19153000E+01,
  0.66400370E+03, 0.172E+03, 0.140E+03, 0.19254000E+01, 0.19355000E+01,
  0.67040190E+03, 0.172E+03, 0.141E+03, 0.19254000E+01, 0.19545000E+01,
  0.62262030E+03, 0.172E+03, 0.142E+03, 0.19254000E+01, 0.19420000E+01,
  0.71174240E+03, 0.172E+03, 0.143E+03, 0.19254000E+01, 0.16682000E+01,
  0.53554020E+03, 0.172E+03, 0.144E+03, 0.19254000E+01, 0.18584000E+01,
  0.50050420E+03, 0.172E+03, 0.145E+03, 0.19254000E+01, 0.19003000E+01,
  0.46368240E+03, 0.172E+03, 0.146E+03, 0.19254000E+01, 0.18630000E+01,
  0.44930820E+03, 0.172E+03, 0.147E+03, 0.19254000E+01, 0.96790000E+00,
  0.43997740E+03, 0.172E+03, 0.148E+03, 0.19254000E+01, 0.19539000E+01,
  0.72721640E+03, 0.172E+03, 0.149E+03, 0.19254000E+01, 0.96330000E+00,
  0.64540420E+03, 0.172E+03, 0.150E+03, 0.19254000E+01, 0.95140000E+00,
  0.59673110E+03, 0.172E+03, 0.151E+03, 0.19254000E+01, 0.97490000E+00,
  0.55972270E+03, 0.172E+03, 0.152E+03, 0.19254000E+01, 0.98110000E+00,
  0.50615680E+03, 0.172E+03, 0.153E+03, 0.19254000E+01, 0.99680000E+00,
  0.71003790E+03, 0.172E+03, 0.155E+03, 0.19254000E+01, 0.99090000E+00,
  0.16551217E+04, 0.172E+03, 0.156E+03, 0.19254000E+01, 0.97970000E+00,
  0.11811130E+04, 0.172E+03, 0.157E+03, 0.19254000E+01, 0.19373000E+01,
  0.70092550E+03, 0.172E+03, 0.159E+03, 0.19254000E+01, 0.29425000E+01,
  0.68627630E+03, 0.172E+03, 0.160E+03, 0.19254000E+01, 0.29455000E+01,
  0.66395860E+03, 0.172E+03, 0.161E+03, 0.19254000E+01, 0.29413000E+01,
  0.66917280E+03, 0.172E+03, 0.162E+03, 0.19254000E+01, 0.29300000E+01,
  0.65059990E+03, 0.172E+03, 0.163E+03, 0.19254000E+01, 0.18286000E+01,
  0.67380220E+03, 0.172E+03, 0.164E+03, 0.19254000E+01, 0.28732000E+01,
  0.63135970E+03, 0.172E+03, 0.165E+03, 0.19254000E+01, 0.29086000E+01,
  0.64587040E+03, 0.172E+03, 0.166E+03, 0.19254000E+01, 0.28965000E+01,
  0.59787350E+03, 0.172E+03, 0.167E+03, 0.19254000E+01, 0.29242000E+01,
  0.58033350E+03, 0.172E+03, 0.168E+03, 0.19254000E+01, 0.29282000E+01,
  0.57700390E+03, 0.172E+03, 0.169E+03, 0.19254000E+01, 0.29246000E+01,
  0.60871420E+03, 0.172E+03, 0.170E+03, 0.19254000E+01, 0.28482000E+01,
  0.55695720E+03, 0.172E+03, 0.171E+03, 0.19254000E+01, 0.29219000E+01,
  0.78038720E+03, 0.172E+03, 0.172E+03, 0.19254000E+01, 0.19254000E+01,
  0.42599100E+02, 0.173E+03, 0.100E+01, 0.19459000E+01, 0.91180000E+00,
  0.27620800E+02, 0.173E+03, 0.200E+01, 0.19459000E+01, 0.00000000E+00,
  0.73880890E+03, 0.173E+03, 0.300E+01, 0.19459000E+01, 0.00000000E+00,
  0.40322390E+03, 0.173E+03, 0.400E+01, 0.19459000E+01, 0.00000000E+00,
  0.26458080E+03, 0.173E+03, 0.500E+01, 0.19459000E+01, 0.00000000E+00,
  0.17562680E+03, 0.173E+03, 0.600E+01, 0.19459000E+01, 0.00000000E+00,
  0.12132320E+03, 0.173E+03, 0.700E+01, 0.19459000E+01, 0.00000000E+00,
  0.91102500E+02, 0.173E+03, 0.800E+01, 0.19459000E+01, 0.00000000E+00,
  0.68542500E+02, 0.173E+03, 0.900E+01, 0.19459000E+01, 0.00000000E+00,
  0.52435800E+02, 0.173E+03, 0.100E+02, 0.19459000E+01, 0.00000000E+00,
  0.88035320E+03, 0.173E+03, 0.110E+02, 0.19459000E+01, 0.00000000E+00,
  0.64829810E+03, 0.173E+03, 0.120E+02, 0.19459000E+01, 0.00000000E+00,
  0.58923010E+03, 0.173E+03, 0.130E+02, 0.19459000E+01, 0.00000000E+00,
  0.45575650E+03, 0.173E+03, 0.140E+02, 0.19459000E+01, 0.00000000E+00,
  0.35031540E+03, 0.173E+03, 0.150E+02, 0.19459000E+01, 0.00000000E+00,
  0.28821970E+03, 0.173E+03, 0.160E+02, 0.19459000E+01, 0.00000000E+00,
  0.23353600E+03, 0.173E+03, 0.170E+02, 0.19459000E+01, 0.00000000E+00,
  0.18976410E+03, 0.173E+03, 0.180E+02, 0.19459000E+01, 0.00000000E+00,
  0.14604707E+04, 0.173E+03, 0.190E+02, 0.19459000E+01, 0.00000000E+00,
  0.11597504E+04, 0.173E+03, 0.200E+02, 0.19459000E+01, 0.00000000E+00,
  0.95068620E+03, 0.173E+03, 0.210E+02, 0.19459000E+01, 0.00000000E+00,
  0.91232910E+03, 0.173E+03, 0.220E+02, 0.19459000E+01, 0.00000000E+00,
  0.83223310E+03, 0.173E+03, 0.230E+02, 0.19459000E+01, 0.00000000E+00,
  0.65570910E+03, 0.173E+03, 0.240E+02, 0.19459000E+01, 0.00000000E+00,
  0.71259280E+03, 0.173E+03, 0.250E+02, 0.19459000E+01, 0.00000000E+00,
  0.55895410E+03, 0.173E+03, 0.260E+02, 0.19459000E+01, 0.00000000E+00,
  0.58724740E+03, 0.173E+03, 0.270E+02, 0.19459000E+01, 0.00000000E+00,
  0.60719280E+03, 0.173E+03, 0.280E+02, 0.19459000E+01, 0.00000000E+00,
  0.46580690E+03, 0.173E+03, 0.290E+02, 0.19459000E+01, 0.00000000E+00,
  0.47225470E+03, 0.173E+03, 0.300E+02, 0.19459000E+01, 0.00000000E+00,
  0.56160790E+03, 0.173E+03, 0.310E+02, 0.19459000E+01, 0.00000000E+00,
  0.48807900E+03, 0.173E+03, 0.320E+02, 0.19459000E+01, 0.00000000E+00,
  0.41125650E+03, 0.173E+03, 0.330E+02, 0.19459000E+01, 0.00000000E+00,
  0.36640670E+03, 0.173E+03, 0.340E+02, 0.19459000E+01, 0.00000000E+00,
  0.31837520E+03, 0.173E+03, 0.350E+02, 0.19459000E+01, 0.00000000E+00,
  0.27512740E+03, 0.173E+03, 0.360E+02, 0.19459000E+01, 0.00000000E+00,
  0.16328526E+04, 0.173E+03, 0.370E+02, 0.19459000E+01, 0.00000000E+00,
  0.13843496E+04, 0.173E+03, 0.380E+02, 0.19459000E+01, 0.00000000E+00,
  0.11967064E+04, 0.173E+03, 0.390E+02, 0.19459000E+01, 0.00000000E+00,
  0.10670698E+04, 0.173E+03, 0.400E+02, 0.19459000E+01, 0.00000000E+00,
  0.96823440E+03, 0.173E+03, 0.410E+02, 0.19459000E+01, 0.00000000E+00,
  0.74142020E+03, 0.173E+03, 0.420E+02, 0.19459000E+01, 0.00000000E+00,
  0.82976170E+03, 0.173E+03, 0.430E+02, 0.19459000E+01, 0.00000000E+00,
  0.62645270E+03, 0.173E+03, 0.440E+02, 0.19459000E+01, 0.00000000E+00,
  0.68426530E+03, 0.173E+03, 0.450E+02, 0.19459000E+01, 0.00000000E+00,
  0.63255740E+03, 0.173E+03, 0.460E+02, 0.19459000E+01, 0.00000000E+00,
  0.52892880E+03, 0.173E+03, 0.470E+02, 0.19459000E+01, 0.00000000E+00,
  0.55516740E+03, 0.173E+03, 0.480E+02, 0.19459000E+01, 0.00000000E+00,
  0.70365600E+03, 0.173E+03, 0.490E+02, 0.19459000E+01, 0.00000000E+00,
  0.64257250E+03, 0.173E+03, 0.500E+02, 0.19459000E+01, 0.00000000E+00,
  0.56623950E+03, 0.173E+03, 0.510E+02, 0.19459000E+01, 0.00000000E+00,
  0.52199830E+03, 0.173E+03, 0.520E+02, 0.19459000E+01, 0.00000000E+00,
  0.46882570E+03, 0.173E+03, 0.530E+02, 0.19459000E+01, 0.00000000E+00,
  0.41891390E+03, 0.173E+03, 0.540E+02, 0.19459000E+01, 0.00000000E+00,
  0.19906514E+04, 0.173E+03, 0.550E+02, 0.19459000E+01, 0.00000000E+00,
  0.17742433E+04, 0.173E+03, 0.560E+02, 0.19459000E+01, 0.00000000E+00,
  0.15377374E+04, 0.173E+03, 0.570E+02, 0.19459000E+01, 0.00000000E+00,
  0.67054450E+03, 0.173E+03, 0.580E+02, 0.19459000E+01, 0.27991000E+01,
  0.15650227E+04, 0.173E+03, 0.590E+02, 0.19459000E+01, 0.00000000E+00,
  0.14988909E+04, 0.173E+03, 0.600E+02, 0.19459000E+01, 0.00000000E+00,
  0.14602740E+04, 0.173E+03, 0.610E+02, 0.19459000E+01, 0.00000000E+00,
  0.14248668E+04, 0.173E+03, 0.620E+02, 0.19459000E+01, 0.00000000E+00,
  0.13934393E+04, 0.173E+03, 0.630E+02, 0.19459000E+01, 0.00000000E+00,
  0.10807361E+04, 0.173E+03, 0.640E+02, 0.19459000E+01, 0.00000000E+00,
  0.12454654E+04, 0.173E+03, 0.650E+02, 0.19459000E+01, 0.00000000E+00,
  0.11985562E+04, 0.173E+03, 0.660E+02, 0.19459000E+01, 0.00000000E+00,
  0.12522798E+04, 0.173E+03, 0.670E+02, 0.19459000E+01, 0.00000000E+00,
  0.12251780E+04, 0.173E+03, 0.680E+02, 0.19459000E+01, 0.00000000E+00,
  0.12005428E+04, 0.173E+03, 0.690E+02, 0.19459000E+01, 0.00000000E+00,
  0.11871547E+04, 0.173E+03, 0.700E+02, 0.19459000E+01, 0.00000000E+00,
  0.99115750E+03, 0.173E+03, 0.710E+02, 0.19459000E+01, 0.00000000E+00,
  0.96178800E+03, 0.173E+03, 0.720E+02, 0.19459000E+01, 0.00000000E+00,
  0.87115170E+03, 0.173E+03, 0.730E+02, 0.19459000E+01, 0.00000000E+00,
  0.73191440E+03, 0.173E+03, 0.740E+02, 0.19459000E+01, 0.00000000E+00,
  0.74227510E+03, 0.173E+03, 0.750E+02, 0.19459000E+01, 0.00000000E+00,
  0.66851880E+03, 0.173E+03, 0.760E+02, 0.19459000E+01, 0.00000000E+00,
  0.60921920E+03, 0.173E+03, 0.770E+02, 0.19459000E+01, 0.00000000E+00,
  0.50370150E+03, 0.173E+03, 0.780E+02, 0.19459000E+01, 0.00000000E+00,
  0.46968660E+03, 0.173E+03, 0.790E+02, 0.19459000E+01, 0.00000000E+00,
  0.48188500E+03, 0.173E+03, 0.800E+02, 0.19459000E+01, 0.00000000E+00,
  0.72091450E+03, 0.173E+03, 0.810E+02, 0.19459000E+01, 0.00000000E+00,
  0.69765140E+03, 0.173E+03, 0.820E+02, 0.19459000E+01, 0.00000000E+00,
  0.63443450E+03, 0.173E+03, 0.830E+02, 0.19459000E+01, 0.00000000E+00,
  0.60166450E+03, 0.173E+03, 0.840E+02, 0.19459000E+01, 0.00000000E+00,
  0.55163790E+03, 0.173E+03, 0.850E+02, 0.19459000E+01, 0.00000000E+00,
  0.50269970E+03, 0.173E+03, 0.860E+02, 0.19459000E+01, 0.00000000E+00,
  0.18580508E+04, 0.173E+03, 0.870E+02, 0.19459000E+01, 0.00000000E+00,
  0.17424506E+04, 0.173E+03, 0.880E+02, 0.19459000E+01, 0.00000000E+00,
  0.15208103E+04, 0.173E+03, 0.890E+02, 0.19459000E+01, 0.00000000E+00,
  0.13484147E+04, 0.173E+03, 0.900E+02, 0.19459000E+01, 0.00000000E+00,
  0.13482588E+04, 0.173E+03, 0.910E+02, 0.19459000E+01, 0.00000000E+00,
  0.13049404E+04, 0.173E+03, 0.920E+02, 0.19459000E+01, 0.00000000E+00,
  0.13545615E+04, 0.173E+03, 0.930E+02, 0.19459000E+01, 0.00000000E+00,
  0.13096099E+04, 0.173E+03, 0.940E+02, 0.19459000E+01, 0.00000000E+00,
  0.69517200E+02, 0.173E+03, 0.101E+03, 0.19459000E+01, 0.00000000E+00,
  0.23360750E+03, 0.173E+03, 0.103E+03, 0.19459000E+01, 0.98650000E+00,
  0.29681730E+03, 0.173E+03, 0.104E+03, 0.19459000E+01, 0.98080000E+00,
  0.22150850E+03, 0.173E+03, 0.105E+03, 0.19459000E+01, 0.97060000E+00,
  0.16489220E+03, 0.173E+03, 0.106E+03, 0.19459000E+01, 0.98680000E+00,
  0.11316000E+03, 0.173E+03, 0.107E+03, 0.19459000E+01, 0.99440000E+00,
  0.81561000E+02, 0.173E+03, 0.108E+03, 0.19459000E+01, 0.99250000E+00,
  0.55390500E+02, 0.173E+03, 0.109E+03, 0.19459000E+01, 0.99820000E+00,
  0.34328010E+03, 0.173E+03, 0.111E+03, 0.19459000E+01, 0.96840000E+00,
  0.53247660E+03, 0.173E+03, 0.112E+03, 0.19459000E+01, 0.96280000E+00,
  0.53228640E+03, 0.173E+03, 0.113E+03, 0.19459000E+01, 0.96480000E+00,
  0.42023260E+03, 0.173E+03, 0.114E+03, 0.19459000E+01, 0.95070000E+00,
  0.33991220E+03, 0.173E+03, 0.115E+03, 0.19459000E+01, 0.99470000E+00,
  0.28511970E+03, 0.173E+03, 0.116E+03, 0.19459000E+01, 0.99480000E+00,
  0.23115710E+03, 0.173E+03, 0.117E+03, 0.19459000E+01, 0.99720000E+00,
  0.46941050E+03, 0.173E+03, 0.119E+03, 0.19459000E+01, 0.97670000E+00,
  0.92943790E+03, 0.173E+03, 0.120E+03, 0.19459000E+01, 0.98310000E+00,
  0.46193760E+03, 0.173E+03, 0.121E+03, 0.19459000E+01, 0.18627000E+01,
  0.44595790E+03, 0.173E+03, 0.122E+03, 0.19459000E+01, 0.18299000E+01,
  0.43713970E+03, 0.173E+03, 0.123E+03, 0.19459000E+01, 0.19138000E+01,
  0.43391220E+03, 0.173E+03, 0.124E+03, 0.19459000E+01, 0.18269000E+01,
  0.39561160E+03, 0.173E+03, 0.125E+03, 0.19459000E+01, 0.16406000E+01,
  0.36527420E+03, 0.173E+03, 0.126E+03, 0.19459000E+01, 0.16483000E+01,
  0.34851570E+03, 0.173E+03, 0.127E+03, 0.19459000E+01, 0.17149000E+01,
  0.34095800E+03, 0.173E+03, 0.128E+03, 0.19459000E+01, 0.17937000E+01,
  0.33910500E+03, 0.173E+03, 0.129E+03, 0.19459000E+01, 0.95760000E+00,
  0.31436170E+03, 0.173E+03, 0.130E+03, 0.19459000E+01, 0.19419000E+01,
  0.52550400E+03, 0.173E+03, 0.131E+03, 0.19459000E+01, 0.96010000E+00,
  0.45518330E+03, 0.173E+03, 0.132E+03, 0.19459000E+01, 0.94340000E+00,
  0.40401890E+03, 0.173E+03, 0.133E+03, 0.19459000E+01, 0.98890000E+00,
  0.36659830E+03, 0.173E+03, 0.134E+03, 0.19459000E+01, 0.99010000E+00,
  0.32071300E+03, 0.173E+03, 0.135E+03, 0.19459000E+01, 0.99740000E+00,
  0.55849190E+03, 0.173E+03, 0.137E+03, 0.19459000E+01, 0.97380000E+00,
  0.11339963E+04, 0.173E+03, 0.138E+03, 0.19459000E+01, 0.98010000E+00,
  0.84472340E+03, 0.173E+03, 0.139E+03, 0.19459000E+01, 0.19153000E+01,
  0.61231920E+03, 0.173E+03, 0.140E+03, 0.19459000E+01, 0.19355000E+01,
  0.61833280E+03, 0.173E+03, 0.141E+03, 0.19459000E+01, 0.19545000E+01,
  0.57504470E+03, 0.173E+03, 0.142E+03, 0.19459000E+01, 0.19420000E+01,
  0.65304060E+03, 0.173E+03, 0.143E+03, 0.19459000E+01, 0.16682000E+01,
  0.49697040E+03, 0.173E+03, 0.144E+03, 0.19459000E+01, 0.18584000E+01,
  0.46466380E+03, 0.173E+03, 0.145E+03, 0.19459000E+01, 0.19003000E+01,
  0.43087120E+03, 0.173E+03, 0.146E+03, 0.19459000E+01, 0.18630000E+01,
  0.41726470E+03, 0.173E+03, 0.147E+03, 0.19459000E+01, 0.96790000E+00,
  0.41002790E+03, 0.173E+03, 0.148E+03, 0.19459000E+01, 0.19539000E+01,
  0.66780870E+03, 0.173E+03, 0.149E+03, 0.19459000E+01, 0.96330000E+00,
  0.59661500E+03, 0.173E+03, 0.150E+03, 0.19459000E+01, 0.95140000E+00,
  0.55414990E+03, 0.173E+03, 0.151E+03, 0.19459000E+01, 0.97490000E+00,
  0.52141070E+03, 0.173E+03, 0.152E+03, 0.19459000E+01, 0.98110000E+00,
  0.47327510E+03, 0.173E+03, 0.153E+03, 0.19459000E+01, 0.99680000E+00,
  0.65424880E+03, 0.173E+03, 0.155E+03, 0.19459000E+01, 0.99090000E+00,
  0.14806088E+04, 0.173E+03, 0.156E+03, 0.19459000E+01, 0.97970000E+00,
  0.10722142E+04, 0.173E+03, 0.157E+03, 0.19459000E+01, 0.19373000E+01,
  0.64990970E+03, 0.173E+03, 0.159E+03, 0.19459000E+01, 0.29425000E+01,
  0.63638010E+03, 0.173E+03, 0.160E+03, 0.19459000E+01, 0.29455000E+01,
  0.61587840E+03, 0.173E+03, 0.161E+03, 0.19459000E+01, 0.29413000E+01,
  0.62006220E+03, 0.173E+03, 0.162E+03, 0.19459000E+01, 0.29300000E+01,
  0.60108450E+03, 0.173E+03, 0.163E+03, 0.19459000E+01, 0.18286000E+01,
  0.62420110E+03, 0.173E+03, 0.164E+03, 0.19459000E+01, 0.28732000E+01,
  0.58539210E+03, 0.173E+03, 0.165E+03, 0.19459000E+01, 0.29086000E+01,
  0.59771440E+03, 0.173E+03, 0.166E+03, 0.19459000E+01, 0.28965000E+01,
  0.55479820E+03, 0.173E+03, 0.167E+03, 0.19459000E+01, 0.29242000E+01,
  0.53868740E+03, 0.173E+03, 0.168E+03, 0.19459000E+01, 0.29282000E+01,
  0.53545990E+03, 0.173E+03, 0.169E+03, 0.19459000E+01, 0.29246000E+01,
  0.56410720E+03, 0.173E+03, 0.170E+03, 0.19459000E+01, 0.28482000E+01,
  0.51709820E+03, 0.173E+03, 0.171E+03, 0.19459000E+01, 0.29219000E+01,
  0.71609920E+03, 0.173E+03, 0.172E+03, 0.19459000E+01, 0.19254000E+01,
  0.65975010E+03, 0.173E+03, 0.173E+03, 0.19459000E+01, 0.19459000E+01,
  0.39353000E+02, 0.174E+03, 0.100E+01, 0.19292000E+01, 0.91180000E+00,
  0.25891600E+02, 0.174E+03, 0.200E+01, 0.19292000E+01, 0.00000000E+00,
  0.64222390E+03, 0.174E+03, 0.300E+01, 0.19292000E+01, 0.00000000E+00,
  0.36075580E+03, 0.174E+03, 0.400E+01, 0.19292000E+01, 0.00000000E+00,
  0.24029820E+03, 0.174E+03, 0.500E+01, 0.19292000E+01, 0.00000000E+00,
  0.16132870E+03, 0.174E+03, 0.600E+01, 0.19292000E+01, 0.00000000E+00,
  0.11241380E+03, 0.174E+03, 0.700E+01, 0.19292000E+01, 0.00000000E+00,
  0.84942800E+02, 0.174E+03, 0.800E+01, 0.19292000E+01, 0.00000000E+00,
  0.64260400E+02, 0.174E+03, 0.900E+01, 0.19292000E+01, 0.00000000E+00,
  0.49383000E+02, 0.174E+03, 0.100E+02, 0.19292000E+01, 0.00000000E+00,
  0.76674770E+03, 0.174E+03, 0.110E+02, 0.19292000E+01, 0.00000000E+00,
  0.57730020E+03, 0.174E+03, 0.120E+02, 0.19292000E+01, 0.00000000E+00,
  0.52875590E+03, 0.174E+03, 0.130E+02, 0.19292000E+01, 0.00000000E+00,
  0.41330440E+03, 0.174E+03, 0.140E+02, 0.19292000E+01, 0.00000000E+00,
  0.32049320E+03, 0.174E+03, 0.150E+02, 0.19292000E+01, 0.00000000E+00,
  0.26521130E+03, 0.174E+03, 0.160E+02, 0.19292000E+01, 0.00000000E+00,
  0.21610340E+03, 0.174E+03, 0.170E+02, 0.19292000E+01, 0.00000000E+00,
  0.17647630E+03, 0.174E+03, 0.180E+02, 0.19292000E+01, 0.00000000E+00,
  0.12652105E+04, 0.174E+03, 0.190E+02, 0.19292000E+01, 0.00000000E+00,
  0.10237513E+04, 0.174E+03, 0.200E+02, 0.19292000E+01, 0.00000000E+00,
  0.84249870E+03, 0.174E+03, 0.210E+02, 0.19292000E+01, 0.00000000E+00,
  0.81128040E+03, 0.174E+03, 0.220E+02, 0.19292000E+01, 0.00000000E+00,
  0.74159550E+03, 0.174E+03, 0.230E+02, 0.19292000E+01, 0.00000000E+00,
  0.58457670E+03, 0.174E+03, 0.240E+02, 0.19292000E+01, 0.00000000E+00,
  0.63689720E+03, 0.174E+03, 0.250E+02, 0.19292000E+01, 0.00000000E+00,
  0.50004450E+03, 0.174E+03, 0.260E+02, 0.19292000E+01, 0.00000000E+00,
  0.52755830E+03, 0.174E+03, 0.270E+02, 0.19292000E+01, 0.00000000E+00,
  0.54433150E+03, 0.174E+03, 0.280E+02, 0.19292000E+01, 0.00000000E+00,
  0.41776790E+03, 0.174E+03, 0.290E+02, 0.19292000E+01, 0.00000000E+00,
  0.42620470E+03, 0.174E+03, 0.300E+02, 0.19292000E+01, 0.00000000E+00,
  0.50560850E+03, 0.174E+03, 0.310E+02, 0.19292000E+01, 0.00000000E+00,
  0.44299990E+03, 0.174E+03, 0.320E+02, 0.19292000E+01, 0.00000000E+00,
  0.37599840E+03, 0.174E+03, 0.330E+02, 0.19292000E+01, 0.00000000E+00,
  0.33652400E+03, 0.174E+03, 0.340E+02, 0.19292000E+01, 0.00000000E+00,
  0.29379580E+03, 0.174E+03, 0.350E+02, 0.19292000E+01, 0.00000000E+00,
  0.25500680E+03, 0.174E+03, 0.360E+02, 0.19292000E+01, 0.00000000E+00,
  0.14165256E+04, 0.174E+03, 0.370E+02, 0.19292000E+01, 0.00000000E+00,
  0.12211434E+04, 0.174E+03, 0.380E+02, 0.19292000E+01, 0.00000000E+00,
  0.10628100E+04, 0.174E+03, 0.390E+02, 0.19292000E+01, 0.00000000E+00,
  0.95167080E+03, 0.174E+03, 0.400E+02, 0.19292000E+01, 0.00000000E+00,
  0.86588950E+03, 0.174E+03, 0.410E+02, 0.19292000E+01, 0.00000000E+00,
  0.66629380E+03, 0.174E+03, 0.420E+02, 0.19292000E+01, 0.00000000E+00,
  0.74429510E+03, 0.174E+03, 0.430E+02, 0.19292000E+01, 0.00000000E+00,
  0.56498080E+03, 0.174E+03, 0.440E+02, 0.19292000E+01, 0.00000000E+00,
  0.61707470E+03, 0.174E+03, 0.450E+02, 0.19292000E+01, 0.00000000E+00,
  0.57145890E+03, 0.174E+03, 0.460E+02, 0.19292000E+01, 0.00000000E+00,
  0.47746470E+03, 0.174E+03, 0.470E+02, 0.19292000E+01, 0.00000000E+00,
  0.50269480E+03, 0.174E+03, 0.480E+02, 0.19292000E+01, 0.00000000E+00,
  0.63350610E+03, 0.174E+03, 0.490E+02, 0.19292000E+01, 0.00000000E+00,
  0.58238420E+03, 0.174E+03, 0.500E+02, 0.19292000E+01, 0.00000000E+00,
  0.51649490E+03, 0.174E+03, 0.510E+02, 0.19292000E+01, 0.00000000E+00,
  0.47798250E+03, 0.174E+03, 0.520E+02, 0.19292000E+01, 0.00000000E+00,
  0.43109430E+03, 0.174E+03, 0.530E+02, 0.19292000E+01, 0.00000000E+00,
  0.38674400E+03, 0.174E+03, 0.540E+02, 0.19292000E+01, 0.00000000E+00,
  0.17264733E+04, 0.174E+03, 0.550E+02, 0.19292000E+01, 0.00000000E+00,
  0.15612112E+04, 0.174E+03, 0.560E+02, 0.19292000E+01, 0.00000000E+00,
  0.13624276E+04, 0.174E+03, 0.570E+02, 0.19292000E+01, 0.00000000E+00,
  0.61099070E+03, 0.174E+03, 0.580E+02, 0.19292000E+01, 0.27991000E+01,
  0.13802768E+04, 0.174E+03, 0.590E+02, 0.19292000E+01, 0.00000000E+00,
  0.13236943E+04, 0.174E+03, 0.600E+02, 0.19292000E+01, 0.00000000E+00,
  0.12900298E+04, 0.174E+03, 0.610E+02, 0.19292000E+01, 0.00000000E+00,
  0.12591135E+04, 0.174E+03, 0.620E+02, 0.19292000E+01, 0.00000000E+00,
  0.12316839E+04, 0.174E+03, 0.630E+02, 0.19292000E+01, 0.00000000E+00,
  0.96239750E+03, 0.174E+03, 0.640E+02, 0.19292000E+01, 0.00000000E+00,
  0.10962341E+04, 0.174E+03, 0.650E+02, 0.19292000E+01, 0.00000000E+00,
  0.10560748E+04, 0.174E+03, 0.660E+02, 0.19292000E+01, 0.00000000E+00,
  0.11088832E+04, 0.174E+03, 0.670E+02, 0.19292000E+01, 0.00000000E+00,
  0.10850974E+04, 0.174E+03, 0.680E+02, 0.19292000E+01, 0.00000000E+00,
  0.10635675E+04, 0.174E+03, 0.690E+02, 0.19292000E+01, 0.00000000E+00,
  0.10513822E+04, 0.174E+03, 0.700E+02, 0.19292000E+01, 0.00000000E+00,
  0.88206880E+03, 0.174E+03, 0.710E+02, 0.19292000E+01, 0.00000000E+00,
  0.86187340E+03, 0.174E+03, 0.720E+02, 0.19292000E+01, 0.00000000E+00,
  0.78390750E+03, 0.174E+03, 0.730E+02, 0.19292000E+01, 0.00000000E+00,
  0.66076360E+03, 0.174E+03, 0.740E+02, 0.19292000E+01, 0.00000000E+00,
  0.67117640E+03, 0.174E+03, 0.750E+02, 0.19292000E+01, 0.00000000E+00,
  0.60666990E+03, 0.174E+03, 0.760E+02, 0.19292000E+01, 0.00000000E+00,
  0.55447220E+03, 0.174E+03, 0.770E+02, 0.19292000E+01, 0.00000000E+00,
  0.45992100E+03, 0.174E+03, 0.780E+02, 0.19292000E+01, 0.00000000E+00,
  0.42942760E+03, 0.174E+03, 0.790E+02, 0.19292000E+01, 0.00000000E+00,
  0.44112500E+03, 0.174E+03, 0.800E+02, 0.19292000E+01, 0.00000000E+00,
  0.65021480E+03, 0.174E+03, 0.810E+02, 0.19292000E+01, 0.00000000E+00,
  0.63255270E+03, 0.174E+03, 0.820E+02, 0.19292000E+01, 0.00000000E+00,
  0.57855330E+03, 0.174E+03, 0.830E+02, 0.19292000E+01, 0.00000000E+00,
  0.55048090E+03, 0.174E+03, 0.840E+02, 0.19292000E+01, 0.00000000E+00,
  0.50671990E+03, 0.174E+03, 0.850E+02, 0.19292000E+01, 0.00000000E+00,
  0.46345510E+03, 0.174E+03, 0.860E+02, 0.19292000E+01, 0.00000000E+00,
  0.16209287E+04, 0.174E+03, 0.870E+02, 0.19292000E+01, 0.00000000E+00,
  0.15387012E+04, 0.174E+03, 0.880E+02, 0.19292000E+01, 0.00000000E+00,
  0.13515716E+04, 0.174E+03, 0.890E+02, 0.19292000E+01, 0.00000000E+00,
  0.12069993E+04, 0.174E+03, 0.900E+02, 0.19292000E+01, 0.00000000E+00,
  0.12026346E+04, 0.174E+03, 0.910E+02, 0.19292000E+01, 0.00000000E+00,
  0.11642737E+04, 0.174E+03, 0.920E+02, 0.19292000E+01, 0.00000000E+00,
  0.12034096E+04, 0.174E+03, 0.930E+02, 0.19292000E+01, 0.00000000E+00,
  0.11644393E+04, 0.174E+03, 0.940E+02, 0.19292000E+01, 0.00000000E+00,
  0.63655000E+02, 0.174E+03, 0.101E+03, 0.19292000E+01, 0.00000000E+00,
  0.20943010E+03, 0.174E+03, 0.103E+03, 0.19292000E+01, 0.98650000E+00,
  0.26676230E+03, 0.174E+03, 0.104E+03, 0.19292000E+01, 0.98080000E+00,
  0.20180580E+03, 0.174E+03, 0.105E+03, 0.19292000E+01, 0.97060000E+00,
  0.15143990E+03, 0.174E+03, 0.106E+03, 0.19292000E+01, 0.98680000E+00,
  0.10487960E+03, 0.174E+03, 0.107E+03, 0.19292000E+01, 0.99440000E+00,
  0.76174700E+02, 0.174E+03, 0.108E+03, 0.19292000E+01, 0.99250000E+00,
  0.52233500E+02, 0.174E+03, 0.109E+03, 0.19292000E+01, 0.99820000E+00,
  0.30698940E+03, 0.174E+03, 0.111E+03, 0.19292000E+01, 0.96840000E+00,
  0.47538840E+03, 0.174E+03, 0.112E+03, 0.19292000E+01, 0.96280000E+00,
  0.47855460E+03, 0.174E+03, 0.113E+03, 0.19292000E+01, 0.96480000E+00,
  0.38166000E+03, 0.174E+03, 0.114E+03, 0.19292000E+01, 0.95070000E+00,
  0.31107370E+03, 0.174E+03, 0.115E+03, 0.19292000E+01, 0.99470000E+00,
  0.26232930E+03, 0.174E+03, 0.116E+03, 0.19292000E+01, 0.99480000E+00,
  0.21388550E+03, 0.174E+03, 0.117E+03, 0.19292000E+01, 0.99720000E+00,
  0.42224100E+03, 0.174E+03, 0.119E+03, 0.19292000E+01, 0.97670000E+00,
  0.82019820E+03, 0.174E+03, 0.120E+03, 0.19292000E+01, 0.98310000E+00,
  0.41903830E+03, 0.174E+03, 0.121E+03, 0.19292000E+01, 0.18627000E+01,
  0.40459180E+03, 0.174E+03, 0.122E+03, 0.19292000E+01, 0.18299000E+01,
  0.39656360E+03, 0.174E+03, 0.123E+03, 0.19292000E+01, 0.19138000E+01,
  0.39324210E+03, 0.174E+03, 0.124E+03, 0.19292000E+01, 0.18269000E+01,
  0.36030430E+03, 0.174E+03, 0.125E+03, 0.19292000E+01, 0.16406000E+01,
  0.33316370E+03, 0.174E+03, 0.126E+03, 0.19292000E+01, 0.16483000E+01,
  0.31788470E+03, 0.174E+03, 0.127E+03, 0.19292000E+01, 0.17149000E+01,
  0.31087480E+03, 0.174E+03, 0.128E+03, 0.19292000E+01, 0.17937000E+01,
  0.30807170E+03, 0.174E+03, 0.129E+03, 0.19292000E+01, 0.95760000E+00,
  0.28748760E+03, 0.174E+03, 0.130E+03, 0.19292000E+01, 0.19419000E+01,
  0.47409680E+03, 0.174E+03, 0.131E+03, 0.19292000E+01, 0.96010000E+00,
  0.41391720E+03, 0.174E+03, 0.132E+03, 0.19292000E+01, 0.94340000E+00,
  0.36953950E+03, 0.174E+03, 0.133E+03, 0.19292000E+01, 0.98890000E+00,
  0.33667770E+03, 0.174E+03, 0.134E+03, 0.19292000E+01, 0.99010000E+00,
  0.29588320E+03, 0.174E+03, 0.135E+03, 0.19292000E+01, 0.99740000E+00,
  0.50328860E+03, 0.174E+03, 0.137E+03, 0.19292000E+01, 0.97380000E+00,
  0.99960180E+03, 0.174E+03, 0.138E+03, 0.19292000E+01, 0.98010000E+00,
  0.75469660E+03, 0.174E+03, 0.139E+03, 0.19292000E+01, 0.19153000E+01,
  0.55497370E+03, 0.174E+03, 0.140E+03, 0.19292000E+01, 0.19355000E+01,
  0.56047340E+03, 0.174E+03, 0.141E+03, 0.19292000E+01, 0.19545000E+01,
  0.52208970E+03, 0.174E+03, 0.142E+03, 0.19292000E+01, 0.19420000E+01,
  0.58893300E+03, 0.174E+03, 0.143E+03, 0.19292000E+01, 0.16682000E+01,
  0.45342630E+03, 0.174E+03, 0.144E+03, 0.19292000E+01, 0.18584000E+01,
  0.42417090E+03, 0.174E+03, 0.145E+03, 0.19292000E+01, 0.19003000E+01,
  0.39371240E+03, 0.174E+03, 0.146E+03, 0.19292000E+01, 0.18630000E+01,
  0.38104950E+03, 0.174E+03, 0.147E+03, 0.19292000E+01, 0.96790000E+00,
  0.37575480E+03, 0.174E+03, 0.148E+03, 0.19292000E+01, 0.19539000E+01,
  0.60266490E+03, 0.174E+03, 0.149E+03, 0.19292000E+01, 0.96330000E+00,
  0.54210550E+03, 0.174E+03, 0.150E+03, 0.19292000E+01, 0.95140000E+00,
  0.50590030E+03, 0.174E+03, 0.151E+03, 0.19292000E+01, 0.97490000E+00,
  0.47755630E+03, 0.174E+03, 0.152E+03, 0.19292000E+01, 0.98110000E+00,
  0.43515150E+03, 0.174E+03, 0.153E+03, 0.19292000E+01, 0.99680000E+00,
  0.59256180E+03, 0.174E+03, 0.155E+03, 0.19292000E+01, 0.99090000E+00,
  0.13007753E+04, 0.174E+03, 0.156E+03, 0.19292000E+01, 0.97970000E+00,
  0.95659970E+03, 0.174E+03, 0.157E+03, 0.19292000E+01, 0.19373000E+01,
  0.59241900E+03, 0.174E+03, 0.159E+03, 0.19292000E+01, 0.29425000E+01,
  0.58013530E+03, 0.174E+03, 0.160E+03, 0.19292000E+01, 0.29455000E+01,
  0.56163190E+03, 0.174E+03, 0.161E+03, 0.19292000E+01, 0.29413000E+01,
  0.56485240E+03, 0.174E+03, 0.162E+03, 0.19292000E+01, 0.29300000E+01,
  0.54591020E+03, 0.174E+03, 0.163E+03, 0.19292000E+01, 0.18286000E+01,
  0.56845330E+03, 0.174E+03, 0.164E+03, 0.19292000E+01, 0.28732000E+01,
  0.53359460E+03, 0.174E+03, 0.165E+03, 0.19292000E+01, 0.29086000E+01,
  0.54379510E+03, 0.174E+03, 0.166E+03, 0.19292000E+01, 0.28965000E+01,
  0.50613240E+03, 0.174E+03, 0.167E+03, 0.19292000E+01, 0.29242000E+01,
  0.49159050E+03, 0.174E+03, 0.168E+03, 0.19292000E+01, 0.29282000E+01,
  0.48851540E+03, 0.174E+03, 0.169E+03, 0.19292000E+01, 0.29246000E+01,
  0.51389840E+03, 0.174E+03, 0.170E+03, 0.19292000E+01, 0.28482000E+01,
  0.47198590E+03, 0.174E+03, 0.171E+03, 0.19292000E+01, 0.29219000E+01,
  0.64582280E+03, 0.174E+03, 0.172E+03, 0.19292000E+01, 0.19254000E+01,
  0.59747460E+03, 0.174E+03, 0.173E+03, 0.19292000E+01, 0.19459000E+01,
  0.54340360E+03, 0.174E+03, 0.174E+03, 0.19292000E+01, 0.19292000E+01,
  0.39390200E+02, 0.175E+03, 0.100E+01, 0.18104000E+01, 0.91180000E+00,
  0.25661400E+02, 0.175E+03, 0.200E+01, 0.18104000E+01, 0.00000000E+00,
  0.67790210E+03, 0.175E+03, 0.300E+01, 0.18104000E+01, 0.00000000E+00,
  0.37113480E+03, 0.175E+03, 0.400E+01, 0.18104000E+01, 0.00000000E+00,
  0.24394890E+03, 0.175E+03, 0.500E+01, 0.18104000E+01, 0.00000000E+00,
  0.16225790E+03, 0.175E+03, 0.600E+01, 0.18104000E+01, 0.00000000E+00,
  0.11232650E+03, 0.175E+03, 0.700E+01, 0.18104000E+01, 0.00000000E+00,
  0.84509400E+02, 0.175E+03, 0.800E+01, 0.18104000E+01, 0.00000000E+00,
  0.63709900E+02, 0.175E+03, 0.900E+01, 0.18104000E+01, 0.00000000E+00,
  0.48832900E+02, 0.175E+03, 0.100E+02, 0.18104000E+01, 0.00000000E+00,
  0.80810000E+03, 0.175E+03, 0.110E+02, 0.18104000E+01, 0.00000000E+00,
  0.59653470E+03, 0.175E+03, 0.120E+02, 0.18104000E+01, 0.00000000E+00,
  0.54254110E+03, 0.175E+03, 0.130E+02, 0.18104000E+01, 0.00000000E+00,
  0.42013030E+03, 0.175E+03, 0.140E+02, 0.18104000E+01, 0.00000000E+00,
  0.32333970E+03, 0.175E+03, 0.150E+02, 0.18104000E+01, 0.00000000E+00,
  0.26632530E+03, 0.175E+03, 0.160E+02, 0.18104000E+01, 0.00000000E+00,
  0.21607690E+03, 0.175E+03, 0.170E+02, 0.18104000E+01, 0.00000000E+00,
  0.17582140E+03, 0.175E+03, 0.180E+02, 0.18104000E+01, 0.00000000E+00,
  0.13393807E+04, 0.175E+03, 0.190E+02, 0.18104000E+01, 0.00000000E+00,
  0.10664078E+04, 0.175E+03, 0.200E+02, 0.18104000E+01, 0.00000000E+00,
  0.87454390E+03, 0.175E+03, 0.210E+02, 0.18104000E+01, 0.00000000E+00,
  0.83959150E+03, 0.175E+03, 0.220E+02, 0.18104000E+01, 0.00000000E+00,
  0.76607010E+03, 0.175E+03, 0.230E+02, 0.18104000E+01, 0.00000000E+00,
  0.60376280E+03, 0.175E+03, 0.240E+02, 0.18104000E+01, 0.00000000E+00,
  0.65618380E+03, 0.175E+03, 0.250E+02, 0.18104000E+01, 0.00000000E+00,
  0.51491990E+03, 0.175E+03, 0.260E+02, 0.18104000E+01, 0.00000000E+00,
  0.54109810E+03, 0.175E+03, 0.270E+02, 0.18104000E+01, 0.00000000E+00,
  0.55933980E+03, 0.175E+03, 0.280E+02, 0.18104000E+01, 0.00000000E+00,
  0.42928690E+03, 0.175E+03, 0.290E+02, 0.18104000E+01, 0.00000000E+00,
  0.43539440E+03, 0.175E+03, 0.300E+02, 0.18104000E+01, 0.00000000E+00,
  0.51743050E+03, 0.175E+03, 0.310E+02, 0.18104000E+01, 0.00000000E+00,
  0.45007850E+03, 0.175E+03, 0.320E+02, 0.18104000E+01, 0.00000000E+00,
  0.37961010E+03, 0.175E+03, 0.330E+02, 0.18104000E+01, 0.00000000E+00,
  0.33848080E+03, 0.175E+03, 0.340E+02, 0.18104000E+01, 0.00000000E+00,
  0.29439730E+03, 0.175E+03, 0.350E+02, 0.18104000E+01, 0.00000000E+00,
  0.25467830E+03, 0.175E+03, 0.360E+02, 0.18104000E+01, 0.00000000E+00,
  0.14977174E+04, 0.175E+03, 0.370E+02, 0.18104000E+01, 0.00000000E+00,
  0.12728662E+04, 0.175E+03, 0.380E+02, 0.18104000E+01, 0.00000000E+00,
  0.11011436E+04, 0.175E+03, 0.390E+02, 0.18104000E+01, 0.00000000E+00,
  0.98233900E+03, 0.175E+03, 0.400E+02, 0.18104000E+01, 0.00000000E+00,
  0.89165750E+03, 0.175E+03, 0.410E+02, 0.18104000E+01, 0.00000000E+00,
  0.68333990E+03, 0.175E+03, 0.420E+02, 0.18104000E+01, 0.00000000E+00,
  0.76450150E+03, 0.175E+03, 0.430E+02, 0.18104000E+01, 0.00000000E+00,
  0.57773560E+03, 0.175E+03, 0.440E+02, 0.18104000E+01, 0.00000000E+00,
  0.63093880E+03, 0.175E+03, 0.450E+02, 0.18104000E+01, 0.00000000E+00,
  0.58342570E+03, 0.175E+03, 0.460E+02, 0.18104000E+01, 0.00000000E+00,
  0.48800010E+03, 0.175E+03, 0.470E+02, 0.18104000E+01, 0.00000000E+00,
  0.51225330E+03, 0.175E+03, 0.480E+02, 0.18104000E+01, 0.00000000E+00,
  0.64862950E+03, 0.175E+03, 0.490E+02, 0.18104000E+01, 0.00000000E+00,
  0.59271140E+03, 0.175E+03, 0.500E+02, 0.18104000E+01, 0.00000000E+00,
  0.52269700E+03, 0.175E+03, 0.510E+02, 0.18104000E+01, 0.00000000E+00,
  0.48212230E+03, 0.175E+03, 0.520E+02, 0.18104000E+01, 0.00000000E+00,
  0.43331830E+03, 0.175E+03, 0.530E+02, 0.18104000E+01, 0.00000000E+00,
  0.38749410E+03, 0.175E+03, 0.540E+02, 0.18104000E+01, 0.00000000E+00,
  0.18253618E+04, 0.175E+03, 0.550E+02, 0.18104000E+01, 0.00000000E+00,
  0.16308213E+04, 0.175E+03, 0.560E+02, 0.18104000E+01, 0.00000000E+00,
  0.14145400E+04, 0.175E+03, 0.570E+02, 0.18104000E+01, 0.00000000E+00,
  0.61899030E+03, 0.175E+03, 0.580E+02, 0.18104000E+01, 0.27991000E+01,
  0.14389986E+04, 0.175E+03, 0.590E+02, 0.18104000E+01, 0.00000000E+00,
  0.13785166E+04, 0.175E+03, 0.600E+02, 0.18104000E+01, 0.00000000E+00,
  0.13430628E+04, 0.175E+03, 0.610E+02, 0.18104000E+01, 0.00000000E+00,
  0.13105457E+04, 0.175E+03, 0.620E+02, 0.18104000E+01, 0.00000000E+00,
  0.12816825E+04, 0.175E+03, 0.630E+02, 0.18104000E+01, 0.00000000E+00,
  0.99495010E+03, 0.175E+03, 0.640E+02, 0.18104000E+01, 0.00000000E+00,
  0.11448282E+04, 0.175E+03, 0.650E+02, 0.18104000E+01, 0.00000000E+00,
  0.11017061E+04, 0.175E+03, 0.660E+02, 0.18104000E+01, 0.00000000E+00,
  0.11520955E+04, 0.175E+03, 0.670E+02, 0.18104000E+01, 0.00000000E+00,
  0.11271846E+04, 0.175E+03, 0.680E+02, 0.18104000E+01, 0.00000000E+00,
  0.11045493E+04, 0.175E+03, 0.690E+02, 0.18104000E+01, 0.00000000E+00,
  0.10921865E+04, 0.175E+03, 0.700E+02, 0.18104000E+01, 0.00000000E+00,
  0.91229470E+03, 0.175E+03, 0.710E+02, 0.18104000E+01, 0.00000000E+00,
  0.88587570E+03, 0.175E+03, 0.720E+02, 0.18104000E+01, 0.00000000E+00,
  0.80282330E+03, 0.175E+03, 0.730E+02, 0.18104000E+01, 0.00000000E+00,
  0.67490990E+03, 0.175E+03, 0.740E+02, 0.18104000E+01, 0.00000000E+00,
  0.68456550E+03, 0.175E+03, 0.750E+02, 0.18104000E+01, 0.00000000E+00,
  0.61687960E+03, 0.175E+03, 0.760E+02, 0.18104000E+01, 0.00000000E+00,
  0.56243030E+03, 0.175E+03, 0.770E+02, 0.18104000E+01, 0.00000000E+00,
  0.46538980E+03, 0.175E+03, 0.780E+02, 0.18104000E+01, 0.00000000E+00,
  0.43411300E+03, 0.175E+03, 0.790E+02, 0.18104000E+01, 0.00000000E+00,
  0.44539470E+03, 0.175E+03, 0.800E+02, 0.18104000E+01, 0.00000000E+00,
  0.66487270E+03, 0.175E+03, 0.810E+02, 0.18104000E+01, 0.00000000E+00,
  0.64374060E+03, 0.175E+03, 0.820E+02, 0.18104000E+01, 0.00000000E+00,
  0.58578780E+03, 0.175E+03, 0.830E+02, 0.18104000E+01, 0.00000000E+00,
  0.55576230E+03, 0.175E+03, 0.840E+02, 0.18104000E+01, 0.00000000E+00,
  0.50986150E+03, 0.175E+03, 0.850E+02, 0.18104000E+01, 0.00000000E+00,
  0.46493840E+03, 0.175E+03, 0.860E+02, 0.18104000E+01, 0.00000000E+00,
  0.17053318E+04, 0.175E+03, 0.870E+02, 0.18104000E+01, 0.00000000E+00,
  0.16022866E+04, 0.175E+03, 0.880E+02, 0.18104000E+01, 0.00000000E+00,
  0.13995346E+04, 0.175E+03, 0.890E+02, 0.18104000E+01, 0.00000000E+00,
  0.12420205E+04, 0.175E+03, 0.900E+02, 0.18104000E+01, 0.00000000E+00,
  0.12414957E+04, 0.175E+03, 0.910E+02, 0.18104000E+01, 0.00000000E+00,
  0.12016927E+04, 0.175E+03, 0.920E+02, 0.18104000E+01, 0.00000000E+00,
  0.12468949E+04, 0.175E+03, 0.930E+02, 0.18104000E+01, 0.00000000E+00,
  0.12056353E+04, 0.175E+03, 0.940E+02, 0.18104000E+01, 0.00000000E+00,
  0.64164300E+02, 0.175E+03, 0.101E+03, 0.18104000E+01, 0.00000000E+00,
  0.21507820E+03, 0.175E+03, 0.103E+03, 0.18104000E+01, 0.98650000E+00,
  0.27332730E+03, 0.175E+03, 0.104E+03, 0.18104000E+01, 0.98080000E+00,
  0.20434870E+03, 0.175E+03, 0.105E+03, 0.18104000E+01, 0.97060000E+00,
  0.15235770E+03, 0.175E+03, 0.106E+03, 0.18104000E+01, 0.98680000E+00,
  0.10479180E+03, 0.175E+03, 0.107E+03, 0.18104000E+01, 0.99440000E+00,
  0.75702000E+02, 0.175E+03, 0.108E+03, 0.18104000E+01, 0.99250000E+00,
  0.51588100E+02, 0.175E+03, 0.109E+03, 0.18104000E+01, 0.99820000E+00,
  0.31607860E+03, 0.175E+03, 0.111E+03, 0.18104000E+01, 0.96840000E+00,
  0.49005630E+03, 0.175E+03, 0.112E+03, 0.18104000E+01, 0.96280000E+00,
  0.49022120E+03, 0.175E+03, 0.113E+03, 0.18104000E+01, 0.96480000E+00,
  0.38746930E+03, 0.175E+03, 0.114E+03, 0.18104000E+01, 0.95070000E+00,
  0.31376610E+03, 0.175E+03, 0.115E+03, 0.18104000E+01, 0.99470000E+00,
  0.26346580E+03, 0.175E+03, 0.116E+03, 0.18104000E+01, 0.99480000E+00,
  0.21388020E+03, 0.175E+03, 0.117E+03, 0.18104000E+01, 0.99720000E+00,
  0.43270980E+03, 0.175E+03, 0.119E+03, 0.18104000E+01, 0.97670000E+00,
  0.85443090E+03, 0.175E+03, 0.120E+03, 0.18104000E+01, 0.98310000E+00,
  0.42613390E+03, 0.175E+03, 0.121E+03, 0.18104000E+01, 0.18627000E+01,
  0.41139560E+03, 0.175E+03, 0.122E+03, 0.18104000E+01, 0.18299000E+01,
  0.40328980E+03, 0.175E+03, 0.123E+03, 0.18104000E+01, 0.19138000E+01,
  0.40028790E+03, 0.175E+03, 0.124E+03, 0.18104000E+01, 0.18269000E+01,
  0.36513690E+03, 0.175E+03, 0.125E+03, 0.18104000E+01, 0.16406000E+01,
  0.33722470E+03, 0.175E+03, 0.126E+03, 0.18104000E+01, 0.16483000E+01,
  0.32177920E+03, 0.175E+03, 0.127E+03, 0.18104000E+01, 0.17149000E+01,
  0.31479940E+03, 0.175E+03, 0.128E+03, 0.18104000E+01, 0.17937000E+01,
  0.31300420E+03, 0.175E+03, 0.129E+03, 0.18104000E+01, 0.95760000E+00,
  0.29033450E+03, 0.175E+03, 0.130E+03, 0.18104000E+01, 0.19419000E+01,
  0.48428840E+03, 0.175E+03, 0.131E+03, 0.18104000E+01, 0.96010000E+00,
  0.41985020E+03, 0.175E+03, 0.132E+03, 0.18104000E+01, 0.94340000E+00,
  0.37295910E+03, 0.175E+03, 0.133E+03, 0.18104000E+01, 0.98890000E+00,
  0.33865860E+03, 0.175E+03, 0.134E+03, 0.18104000E+01, 0.99010000E+00,
  0.29654870E+03, 0.175E+03, 0.135E+03, 0.18104000E+01, 0.99740000E+00,
  0.51497470E+03, 0.175E+03, 0.137E+03, 0.18104000E+01, 0.97380000E+00,
  0.10423341E+04, 0.175E+03, 0.138E+03, 0.18104000E+01, 0.98010000E+00,
  0.77762370E+03, 0.175E+03, 0.139E+03, 0.18104000E+01, 0.19153000E+01,
  0.56481820E+03, 0.175E+03, 0.140E+03, 0.18104000E+01, 0.19355000E+01,
  0.57045940E+03, 0.175E+03, 0.141E+03, 0.18104000E+01, 0.19545000E+01,
  0.53064150E+03, 0.175E+03, 0.142E+03, 0.18104000E+01, 0.19420000E+01,
  0.60213570E+03, 0.175E+03, 0.143E+03, 0.18104000E+01, 0.16682000E+01,
  0.45894910E+03, 0.175E+03, 0.144E+03, 0.18104000E+01, 0.18584000E+01,
  0.42920470E+03, 0.175E+03, 0.145E+03, 0.18104000E+01, 0.19003000E+01,
  0.39810440E+03, 0.175E+03, 0.146E+03, 0.18104000E+01, 0.18630000E+01,
  0.38554200E+03, 0.175E+03, 0.147E+03, 0.18104000E+01, 0.96790000E+00,
  0.37894250E+03, 0.175E+03, 0.148E+03, 0.18104000E+01, 0.19539000E+01,
  0.61575540E+03, 0.175E+03, 0.149E+03, 0.18104000E+01, 0.96330000E+00,
  0.55049820E+03, 0.175E+03, 0.150E+03, 0.18104000E+01, 0.95140000E+00,
  0.51159560E+03, 0.175E+03, 0.151E+03, 0.18104000E+01, 0.97490000E+00,
  0.48159190E+03, 0.175E+03, 0.152E+03, 0.18104000E+01, 0.98110000E+00,
  0.43741870E+03, 0.175E+03, 0.153E+03, 0.18104000E+01, 0.99680000E+00,
  0.60346930E+03, 0.175E+03, 0.155E+03, 0.18104000E+01, 0.99090000E+00,
  0.13601123E+04, 0.175E+03, 0.156E+03, 0.18104000E+01, 0.97970000E+00,
  0.98679870E+03, 0.175E+03, 0.157E+03, 0.18104000E+01, 0.19373000E+01,
  0.59998280E+03, 0.175E+03, 0.159E+03, 0.18104000E+01, 0.29425000E+01,
  0.58750600E+03, 0.175E+03, 0.160E+03, 0.18104000E+01, 0.29455000E+01,
  0.56861140E+03, 0.175E+03, 0.161E+03, 0.18104000E+01, 0.29413000E+01,
  0.57238360E+03, 0.175E+03, 0.162E+03, 0.18104000E+01, 0.29300000E+01,
  0.55475530E+03, 0.175E+03, 0.163E+03, 0.18104000E+01, 0.18286000E+01,
  0.57615700E+03, 0.175E+03, 0.164E+03, 0.18104000E+01, 0.28732000E+01,
  0.54043300E+03, 0.175E+03, 0.165E+03, 0.18104000E+01, 0.29086000E+01,
  0.55166610E+03, 0.175E+03, 0.166E+03, 0.18104000E+01, 0.28965000E+01,
  0.51223480E+03, 0.175E+03, 0.167E+03, 0.18104000E+01, 0.29242000E+01,
  0.49737970E+03, 0.175E+03, 0.168E+03, 0.18104000E+01, 0.29282000E+01,
  0.49437500E+03, 0.175E+03, 0.169E+03, 0.18104000E+01, 0.29246000E+01,
  0.52066780E+03, 0.175E+03, 0.170E+03, 0.18104000E+01, 0.28482000E+01,
  0.47743820E+03, 0.175E+03, 0.171E+03, 0.18104000E+01, 0.29219000E+01,
  0.66008460E+03, 0.175E+03, 0.172E+03, 0.18104000E+01, 0.19254000E+01,
  0.60852880E+03, 0.175E+03, 0.173E+03, 0.18104000E+01, 0.19459000E+01,
  0.55146290E+03, 0.175E+03, 0.174E+03, 0.18104000E+01, 0.19292000E+01,
  0.56143380E+03, 0.175E+03, 0.175E+03, 0.18104000E+01, 0.18104000E+01,
  0.35464600E+02, 0.176E+03, 0.100E+01, 0.18858000E+01, 0.91180000E+00,
  0.23812500E+02, 0.176E+03, 0.200E+01, 0.18858000E+01, 0.00000000E+00,
  0.53066030E+03, 0.176E+03, 0.300E+01, 0.18858000E+01, 0.00000000E+00,
  0.31052240E+03, 0.176E+03, 0.400E+01, 0.18858000E+01, 0.00000000E+00,
  0.21141050E+03, 0.176E+03, 0.500E+01, 0.18858000E+01, 0.00000000E+00,
  0.14424940E+03, 0.176E+03, 0.600E+01, 0.18858000E+01, 0.00000000E+00,
  0.10174200E+03, 0.176E+03, 0.700E+01, 0.18858000E+01, 0.00000000E+00,
  0.77553600E+02, 0.176E+03, 0.800E+01, 0.18858000E+01, 0.00000000E+00,
  0.59120400E+02, 0.176E+03, 0.900E+01, 0.18858000E+01, 0.00000000E+00,
  0.45720500E+02, 0.176E+03, 0.100E+02, 0.18858000E+01, 0.00000000E+00,
  0.63530720E+03, 0.176E+03, 0.110E+02, 0.18858000E+01, 0.00000000E+00,
  0.49355920E+03, 0.176E+03, 0.120E+02, 0.18858000E+01, 0.00000000E+00,
  0.45721240E+03, 0.176E+03, 0.130E+02, 0.18858000E+01, 0.00000000E+00,
  0.36283630E+03, 0.176E+03, 0.140E+02, 0.18858000E+01, 0.00000000E+00,
  0.28491700E+03, 0.176E+03, 0.150E+02, 0.18858000E+01, 0.00000000E+00,
  0.23770450E+03, 0.176E+03, 0.160E+02, 0.18858000E+01, 0.00000000E+00,
  0.19521900E+03, 0.176E+03, 0.170E+02, 0.18858000E+01, 0.00000000E+00,
  0.16053010E+03, 0.176E+03, 0.180E+02, 0.18858000E+01, 0.00000000E+00,
  0.10420654E+04, 0.176E+03, 0.190E+02, 0.18858000E+01, 0.00000000E+00,
  0.86452710E+03, 0.176E+03, 0.200E+02, 0.18858000E+01, 0.00000000E+00,
  0.71543320E+03, 0.176E+03, 0.210E+02, 0.18858000E+01, 0.00000000E+00,
  0.69243390E+03, 0.176E+03, 0.220E+02, 0.18858000E+01, 0.00000000E+00,
  0.63488380E+03, 0.176E+03, 0.230E+02, 0.18858000E+01, 0.00000000E+00,
  0.50093670E+03, 0.176E+03, 0.240E+02, 0.18858000E+01, 0.00000000E+00,
  0.54765220E+03, 0.176E+03, 0.250E+02, 0.18858000E+01, 0.00000000E+00,
  0.43064570E+03, 0.176E+03, 0.260E+02, 0.18858000E+01, 0.00000000E+00,
  0.45696500E+03, 0.176E+03, 0.270E+02, 0.18858000E+01, 0.00000000E+00,
  0.47005570E+03, 0.176E+03, 0.280E+02, 0.18858000E+01, 0.00000000E+00,
  0.36110090E+03, 0.176E+03, 0.290E+02, 0.18858000E+01, 0.00000000E+00,
  0.37162530E+03, 0.176E+03, 0.300E+02, 0.18858000E+01, 0.00000000E+00,
  0.43932630E+03, 0.176E+03, 0.310E+02, 0.18858000E+01, 0.00000000E+00,
  0.38941390E+03, 0.176E+03, 0.320E+02, 0.18858000E+01, 0.00000000E+00,
  0.33396020E+03, 0.176E+03, 0.330E+02, 0.18858000E+01, 0.00000000E+00,
  0.30083180E+03, 0.176E+03, 0.340E+02, 0.18858000E+01, 0.00000000E+00,
  0.26438450E+03, 0.176E+03, 0.350E+02, 0.18858000E+01, 0.00000000E+00,
  0.23089140E+03, 0.176E+03, 0.360E+02, 0.18858000E+01, 0.00000000E+00,
  0.11693798E+04, 0.176E+03, 0.370E+02, 0.18858000E+01, 0.00000000E+00,
  0.10303644E+04, 0.176E+03, 0.380E+02, 0.18858000E+01, 0.00000000E+00,
  0.90555540E+03, 0.176E+03, 0.390E+02, 0.18858000E+01, 0.00000000E+00,
  0.81580510E+03, 0.176E+03, 0.400E+02, 0.18858000E+01, 0.00000000E+00,
  0.74526460E+03, 0.176E+03, 0.410E+02, 0.18858000E+01, 0.00000000E+00,
  0.57758390E+03, 0.176E+03, 0.420E+02, 0.18858000E+01, 0.00000000E+00,
  0.64348640E+03, 0.176E+03, 0.430E+02, 0.18858000E+01, 0.00000000E+00,
  0.49230820E+03, 0.176E+03, 0.440E+02, 0.18858000E+01, 0.00000000E+00,
  0.53754740E+03, 0.176E+03, 0.450E+02, 0.18858000E+01, 0.00000000E+00,
  0.49907810E+03, 0.176E+03, 0.460E+02, 0.18858000E+01, 0.00000000E+00,
  0.41664440E+03, 0.176E+03, 0.470E+02, 0.18858000E+01, 0.00000000E+00,
  0.44047370E+03, 0.176E+03, 0.480E+02, 0.18858000E+01, 0.00000000E+00,
  0.55060050E+03, 0.176E+03, 0.490E+02, 0.18858000E+01, 0.00000000E+00,
  0.51094940E+03, 0.176E+03, 0.500E+02, 0.18858000E+01, 0.00000000E+00,
  0.45728590E+03, 0.176E+03, 0.510E+02, 0.18858000E+01, 0.00000000E+00,
  0.42551160E+03, 0.176E+03, 0.520E+02, 0.18858000E+01, 0.00000000E+00,
  0.38604100E+03, 0.176E+03, 0.530E+02, 0.18858000E+01, 0.00000000E+00,
  0.34827200E+03, 0.176E+03, 0.540E+02, 0.18858000E+01, 0.00000000E+00,
  0.14257528E+04, 0.176E+03, 0.550E+02, 0.18858000E+01, 0.00000000E+00,
  0.13130562E+04, 0.176E+03, 0.560E+02, 0.18858000E+01, 0.00000000E+00,
  0.11570873E+04, 0.176E+03, 0.570E+02, 0.18858000E+01, 0.00000000E+00,
  0.54014830E+03, 0.176E+03, 0.580E+02, 0.18858000E+01, 0.27991000E+01,
  0.11649532E+04, 0.176E+03, 0.590E+02, 0.18858000E+01, 0.00000000E+00,
  0.11189840E+04, 0.176E+03, 0.600E+02, 0.18858000E+01, 0.00000000E+00,
  0.10910275E+04, 0.176E+03, 0.610E+02, 0.18858000E+01, 0.00000000E+00,
  0.10652955E+04, 0.176E+03, 0.620E+02, 0.18858000E+01, 0.00000000E+00,
  0.10424806E+04, 0.176E+03, 0.630E+02, 0.18858000E+01, 0.00000000E+00,
  0.82351360E+03, 0.176E+03, 0.640E+02, 0.18858000E+01, 0.00000000E+00,
  0.92339310E+03, 0.176E+03, 0.650E+02, 0.18858000E+01, 0.00000000E+00,
  0.89129600E+03, 0.176E+03, 0.660E+02, 0.18858000E+01, 0.00000000E+00,
  0.94085810E+03, 0.176E+03, 0.670E+02, 0.18858000E+01, 0.00000000E+00,
  0.92091700E+03, 0.176E+03, 0.680E+02, 0.18858000E+01, 0.00000000E+00,
  0.90298170E+03, 0.176E+03, 0.690E+02, 0.18858000E+01, 0.00000000E+00,
  0.89222740E+03, 0.176E+03, 0.700E+02, 0.18858000E+01, 0.00000000E+00,
  0.75415480E+03, 0.176E+03, 0.710E+02, 0.18858000E+01, 0.00000000E+00,
  0.74392130E+03, 0.176E+03, 0.720E+02, 0.18858000E+01, 0.00000000E+00,
  0.68068180E+03, 0.176E+03, 0.730E+02, 0.18858000E+01, 0.00000000E+00,
  0.57655350E+03, 0.176E+03, 0.740E+02, 0.18858000E+01, 0.00000000E+00,
  0.58693470E+03, 0.176E+03, 0.750E+02, 0.18858000E+01, 0.00000000E+00,
  0.53325550E+03, 0.176E+03, 0.760E+02, 0.18858000E+01, 0.00000000E+00,
  0.48940580E+03, 0.176E+03, 0.770E+02, 0.18858000E+01, 0.00000000E+00,
  0.40785710E+03, 0.176E+03, 0.780E+02, 0.18858000E+01, 0.00000000E+00,
  0.38154050E+03, 0.176E+03, 0.790E+02, 0.18858000E+01, 0.00000000E+00,
  0.39259340E+03, 0.176E+03, 0.800E+02, 0.18858000E+01, 0.00000000E+00,
  0.56672940E+03, 0.176E+03, 0.810E+02, 0.18858000E+01, 0.00000000E+00,
  0.55534130E+03, 0.176E+03, 0.820E+02, 0.18858000E+01, 0.00000000E+00,
  0.51207880E+03, 0.176E+03, 0.830E+02, 0.18858000E+01, 0.00000000E+00,
  0.48950850E+03, 0.176E+03, 0.840E+02, 0.18858000E+01, 0.00000000E+00,
  0.45312570E+03, 0.176E+03, 0.850E+02, 0.18858000E+01, 0.00000000E+00,
  0.41656370E+03, 0.176E+03, 0.860E+02, 0.18858000E+01, 0.00000000E+00,
  0.13491716E+04, 0.176E+03, 0.870E+02, 0.18858000E+01, 0.00000000E+00,
  0.13007391E+04, 0.176E+03, 0.880E+02, 0.18858000E+01, 0.00000000E+00,
  0.11529664E+04, 0.176E+03, 0.890E+02, 0.18858000E+01, 0.00000000E+00,
  0.10402935E+04, 0.176E+03, 0.900E+02, 0.18858000E+01, 0.00000000E+00,
  0.10315219E+04, 0.176E+03, 0.910E+02, 0.18858000E+01, 0.00000000E+00,
  0.99893380E+03, 0.176E+03, 0.920E+02, 0.18858000E+01, 0.00000000E+00,
  0.10261425E+04, 0.176E+03, 0.930E+02, 0.18858000E+01, 0.00000000E+00,
  0.99407460E+03, 0.176E+03, 0.940E+02, 0.18858000E+01, 0.00000000E+00,
  0.56656700E+02, 0.176E+03, 0.101E+03, 0.18858000E+01, 0.00000000E+00,
  0.18083220E+03, 0.176E+03, 0.103E+03, 0.18858000E+01, 0.98650000E+00,
  0.23124090E+03, 0.176E+03, 0.104E+03, 0.18858000E+01, 0.98080000E+00,
  0.17834690E+03, 0.176E+03, 0.105E+03, 0.18858000E+01, 0.97060000E+00,
  0.13537830E+03, 0.176E+03, 0.106E+03, 0.18858000E+01, 0.98680000E+00,
  0.94961200E+02, 0.176E+03, 0.107E+03, 0.18858000E+01, 0.99440000E+00,
  0.69708000E+02, 0.176E+03, 0.108E+03, 0.18858000E+01, 0.99250000E+00,
  0.48438300E+02, 0.176E+03, 0.109E+03, 0.18858000E+01, 0.99820000E+00,
  0.26414790E+03, 0.176E+03, 0.111E+03, 0.18858000E+01, 0.96840000E+00,
  0.40811310E+03, 0.176E+03, 0.112E+03, 0.18858000E+01, 0.96280000E+00,
  0.41494650E+03, 0.176E+03, 0.113E+03, 0.18858000E+01, 0.96480000E+00,
  0.33578860E+03, 0.176E+03, 0.114E+03, 0.18858000E+01, 0.95070000E+00,
  0.27667050E+03, 0.176E+03, 0.115E+03, 0.18858000E+01, 0.99470000E+00,
  0.23508600E+03, 0.176E+03, 0.116E+03, 0.18858000E+01, 0.99480000E+00,
  0.19319560E+03, 0.176E+03, 0.117E+03, 0.18858000E+01, 0.99720000E+00,
  0.36655110E+03, 0.176E+03, 0.119E+03, 0.18858000E+01, 0.97670000E+00,
  0.69317420E+03, 0.176E+03, 0.120E+03, 0.18858000E+01, 0.98310000E+00,
  0.36802850E+03, 0.176E+03, 0.121E+03, 0.18858000E+01, 0.18627000E+01,
  0.35552300E+03, 0.176E+03, 0.122E+03, 0.18858000E+01, 0.18299000E+01,
  0.34841720E+03, 0.176E+03, 0.123E+03, 0.18858000E+01, 0.19138000E+01,
  0.34501650E+03, 0.176E+03, 0.124E+03, 0.18858000E+01, 0.18269000E+01,
  0.31830430E+03, 0.176E+03, 0.125E+03, 0.18858000E+01, 0.16406000E+01,
  0.29495420E+03, 0.176E+03, 0.126E+03, 0.18858000E+01, 0.16483000E+01,
  0.28145410E+03, 0.176E+03, 0.127E+03, 0.18858000E+01, 0.17149000E+01,
  0.27510220E+03, 0.176E+03, 0.128E+03, 0.18858000E+01, 0.17937000E+01,
  0.27123140E+03, 0.176E+03, 0.129E+03, 0.18858000E+01, 0.95760000E+00,
  0.25547700E+03, 0.176E+03, 0.130E+03, 0.18858000E+01, 0.19419000E+01,
  0.41318390E+03, 0.176E+03, 0.131E+03, 0.18858000E+01, 0.96010000E+00,
  0.36483360E+03, 0.176E+03, 0.132E+03, 0.18858000E+01, 0.94340000E+00,
  0.32842530E+03, 0.176E+03, 0.133E+03, 0.18858000E+01, 0.98890000E+00,
  0.30094220E+03, 0.176E+03, 0.134E+03, 0.18858000E+01, 0.99010000E+00,
  0.26617570E+03, 0.176E+03, 0.135E+03, 0.18858000E+01, 0.99740000E+00,
  0.43809620E+03, 0.176E+03, 0.137E+03, 0.18858000E+01, 0.97380000E+00,
  0.84371770E+03, 0.176E+03, 0.138E+03, 0.18858000E+01, 0.98010000E+00,
  0.64942160E+03, 0.176E+03, 0.139E+03, 0.18858000E+01, 0.19153000E+01,
  0.48694320E+03, 0.176E+03, 0.140E+03, 0.18858000E+01, 0.19355000E+01,
  0.49170440E+03, 0.176E+03, 0.141E+03, 0.18858000E+01, 0.19545000E+01,
  0.45926500E+03, 0.176E+03, 0.142E+03, 0.18858000E+01, 0.19420000E+01,
  0.51329930E+03, 0.176E+03, 0.143E+03, 0.18858000E+01, 0.16682000E+01,
  0.40162410E+03, 0.176E+03, 0.144E+03, 0.18858000E+01, 0.18584000E+01,
  0.37601550E+03, 0.176E+03, 0.145E+03, 0.18858000E+01, 0.19003000E+01,
  0.34951790E+03, 0.176E+03, 0.146E+03, 0.18858000E+01, 0.18630000E+01,
  0.33798580E+03, 0.176E+03, 0.147E+03, 0.18858000E+01, 0.96790000E+00,
  0.33491410E+03, 0.176E+03, 0.148E+03, 0.18858000E+01, 0.19539000E+01,
  0.52556660E+03, 0.176E+03, 0.149E+03, 0.18858000E+01, 0.96330000E+00,
  0.47735010E+03, 0.176E+03, 0.150E+03, 0.18858000E+01, 0.95140000E+00,
  0.44845320E+03, 0.176E+03, 0.151E+03, 0.18858000E+01, 0.97490000E+00,
  0.42527250E+03, 0.176E+03, 0.152E+03, 0.18858000E+01, 0.98110000E+00,
  0.38963030E+03, 0.176E+03, 0.153E+03, 0.18858000E+01, 0.99680000E+00,
  0.51948750E+03, 0.176E+03, 0.155E+03, 0.18858000E+01, 0.99090000E+00,
  0.10935492E+04, 0.176E+03, 0.156E+03, 0.18858000E+01, 0.97970000E+00,
  0.82179670E+03, 0.176E+03, 0.157E+03, 0.18858000E+01, 0.19373000E+01,
  0.52402380E+03, 0.176E+03, 0.159E+03, 0.18858000E+01, 0.29425000E+01,
  0.51321590E+03, 0.176E+03, 0.160E+03, 0.18858000E+01, 0.29455000E+01,
  0.49708550E+03, 0.176E+03, 0.161E+03, 0.18858000E+01, 0.29413000E+01,
  0.49923160E+03, 0.176E+03, 0.162E+03, 0.18858000E+01, 0.29300000E+01,
  0.48040280E+03, 0.176E+03, 0.163E+03, 0.18858000E+01, 0.18286000E+01,
  0.50216590E+03, 0.176E+03, 0.164E+03, 0.18858000E+01, 0.28732000E+01,
  0.47197170E+03, 0.176E+03, 0.165E+03, 0.18858000E+01, 0.29086000E+01,
  0.47976830E+03, 0.176E+03, 0.166E+03, 0.18858000E+01, 0.28965000E+01,
  0.44820990E+03, 0.176E+03, 0.167E+03, 0.18858000E+01, 0.29242000E+01,
  0.43552800E+03, 0.176E+03, 0.168E+03, 0.18858000E+01, 0.29282000E+01,
  0.43264200E+03, 0.176E+03, 0.169E+03, 0.18858000E+01, 0.29246000E+01,
  0.45417000E+03, 0.176E+03, 0.170E+03, 0.18858000E+01, 0.28482000E+01,
  0.41827710E+03, 0.176E+03, 0.171E+03, 0.18858000E+01, 0.29219000E+01,
  0.56287830E+03, 0.176E+03, 0.172E+03, 0.18858000E+01, 0.19254000E+01,
  0.52375380E+03, 0.176E+03, 0.173E+03, 0.18858000E+01, 0.19459000E+01,
  0.47921590E+03, 0.176E+03, 0.174E+03, 0.18858000E+01, 0.19292000E+01,
  0.48386730E+03, 0.176E+03, 0.175E+03, 0.18858000E+01, 0.18104000E+01,
  0.42619030E+03, 0.176E+03, 0.176E+03, 0.18858000E+01, 0.18858000E+01,
  0.33511700E+02, 0.177E+03, 0.100E+01, 0.18648000E+01, 0.91180000E+00,
  0.22677900E+02, 0.177E+03, 0.200E+01, 0.18648000E+01, 0.00000000E+00,
  0.49147210E+03, 0.177E+03, 0.300E+01, 0.18648000E+01, 0.00000000E+00,
  0.28982980E+03, 0.177E+03, 0.400E+01, 0.18648000E+01, 0.00000000E+00,
  0.19838070E+03, 0.177E+03, 0.500E+01, 0.18648000E+01, 0.00000000E+00,
  0.13600690E+03, 0.177E+03, 0.600E+01, 0.18648000E+01, 0.00000000E+00,
  0.96324300E+02, 0.177E+03, 0.700E+01, 0.18648000E+01, 0.00000000E+00,
  0.73663400E+02, 0.177E+03, 0.800E+01, 0.18648000E+01, 0.00000000E+00,
  0.56326800E+02, 0.177E+03, 0.900E+01, 0.18648000E+01, 0.00000000E+00,
  0.43677300E+02, 0.177E+03, 0.100E+02, 0.18648000E+01, 0.00000000E+00,
  0.58883180E+03, 0.177E+03, 0.110E+02, 0.18648000E+01, 0.00000000E+00,
  0.46010610E+03, 0.177E+03, 0.120E+02, 0.18648000E+01, 0.00000000E+00,
  0.42726470E+03, 0.177E+03, 0.130E+02, 0.18648000E+01, 0.00000000E+00,
  0.34027370E+03, 0.177E+03, 0.140E+02, 0.18648000E+01, 0.00000000E+00,
  0.26810830E+03, 0.177E+03, 0.150E+02, 0.18648000E+01, 0.00000000E+00,
  0.22424930E+03, 0.177E+03, 0.160E+02, 0.18648000E+01, 0.00000000E+00,
  0.18465170E+03, 0.177E+03, 0.170E+02, 0.18648000E+01, 0.00000000E+00,
  0.15222030E+03, 0.177E+03, 0.180E+02, 0.18648000E+01, 0.00000000E+00,
  0.96506260E+03, 0.177E+03, 0.190E+02, 0.18648000E+01, 0.00000000E+00,
  0.80438060E+03, 0.177E+03, 0.200E+02, 0.18648000E+01, 0.00000000E+00,
  0.66634240E+03, 0.177E+03, 0.210E+02, 0.18648000E+01, 0.00000000E+00,
  0.64567380E+03, 0.177E+03, 0.220E+02, 0.18648000E+01, 0.00000000E+00,
  0.59240830E+03, 0.177E+03, 0.230E+02, 0.18648000E+01, 0.00000000E+00,
  0.46775860E+03, 0.177E+03, 0.240E+02, 0.18648000E+01, 0.00000000E+00,
  0.51152360E+03, 0.177E+03, 0.250E+02, 0.18648000E+01, 0.00000000E+00,
  0.40259270E+03, 0.177E+03, 0.260E+02, 0.18648000E+01, 0.00000000E+00,
  0.42750640E+03, 0.177E+03, 0.270E+02, 0.18648000E+01, 0.00000000E+00,
  0.43943760E+03, 0.177E+03, 0.280E+02, 0.18648000E+01, 0.00000000E+00,
  0.33788310E+03, 0.177E+03, 0.290E+02, 0.18648000E+01, 0.00000000E+00,
  0.34820520E+03, 0.177E+03, 0.300E+02, 0.18648000E+01, 0.00000000E+00,
  0.41118360E+03, 0.177E+03, 0.310E+02, 0.18648000E+01, 0.00000000E+00,
  0.36542010E+03, 0.177E+03, 0.320E+02, 0.18648000E+01, 0.00000000E+00,
  0.31422920E+03, 0.177E+03, 0.330E+02, 0.18648000E+01, 0.00000000E+00,
  0.28359750E+03, 0.177E+03, 0.340E+02, 0.18648000E+01, 0.00000000E+00,
  0.24976170E+03, 0.177E+03, 0.350E+02, 0.18648000E+01, 0.00000000E+00,
  0.21857530E+03, 0.177E+03, 0.360E+02, 0.18648000E+01, 0.00000000E+00,
  0.10836129E+04, 0.177E+03, 0.370E+02, 0.18648000E+01, 0.00000000E+00,
  0.95871100E+03, 0.177E+03, 0.380E+02, 0.18648000E+01, 0.00000000E+00,
  0.84420740E+03, 0.177E+03, 0.390E+02, 0.18648000E+01, 0.00000000E+00,
  0.76153710E+03, 0.177E+03, 0.400E+02, 0.18648000E+01, 0.00000000E+00,
  0.69635620E+03, 0.177E+03, 0.410E+02, 0.18648000E+01, 0.00000000E+00,
  0.54076150E+03, 0.177E+03, 0.420E+02, 0.18648000E+01, 0.00000000E+00,
  0.60199360E+03, 0.177E+03, 0.430E+02, 0.18648000E+01, 0.00000000E+00,
  0.46158650E+03, 0.177E+03, 0.440E+02, 0.18648000E+01, 0.00000000E+00,
  0.50378310E+03, 0.177E+03, 0.450E+02, 0.18648000E+01, 0.00000000E+00,
  0.46803160E+03, 0.177E+03, 0.460E+02, 0.18648000E+01, 0.00000000E+00,
  0.39092010E+03, 0.177E+03, 0.470E+02, 0.18648000E+01, 0.00000000E+00,
  0.41343530E+03, 0.177E+03, 0.480E+02, 0.18648000E+01, 0.00000000E+00,
  0.51570310E+03, 0.177E+03, 0.490E+02, 0.18648000E+01, 0.00000000E+00,
  0.47948370E+03, 0.177E+03, 0.500E+02, 0.18648000E+01, 0.00000000E+00,
  0.43006080E+03, 0.177E+03, 0.510E+02, 0.18648000E+01, 0.00000000E+00,
  0.40076390E+03, 0.177E+03, 0.520E+02, 0.18648000E+01, 0.00000000E+00,
  0.36420700E+03, 0.177E+03, 0.530E+02, 0.18648000E+01, 0.00000000E+00,
  0.32914390E+03, 0.177E+03, 0.540E+02, 0.18648000E+01, 0.00000000E+00,
  0.13211273E+04, 0.177E+03, 0.550E+02, 0.18648000E+01, 0.00000000E+00,
  0.12211564E+04, 0.177E+03, 0.560E+02, 0.18648000E+01, 0.00000000E+00,
  0.10781412E+04, 0.177E+03, 0.570E+02, 0.18648000E+01, 0.00000000E+00,
  0.50792020E+03, 0.177E+03, 0.580E+02, 0.18648000E+01, 0.27991000E+01,
  0.10842087E+04, 0.177E+03, 0.590E+02, 0.18648000E+01, 0.00000000E+00,
  0.10418248E+04, 0.177E+03, 0.600E+02, 0.18648000E+01, 0.00000000E+00,
  0.10158802E+04, 0.177E+03, 0.610E+02, 0.18648000E+01, 0.00000000E+00,
  0.99198570E+03, 0.177E+03, 0.620E+02, 0.18648000E+01, 0.00000000E+00,
  0.97080130E+03, 0.177E+03, 0.630E+02, 0.18648000E+01, 0.00000000E+00,
  0.76877680E+03, 0.177E+03, 0.640E+02, 0.18648000E+01, 0.00000000E+00,
  0.85938870E+03, 0.177E+03, 0.650E+02, 0.18648000E+01, 0.00000000E+00,
  0.82970230E+03, 0.177E+03, 0.660E+02, 0.18648000E+01, 0.00000000E+00,
  0.87655810E+03, 0.177E+03, 0.670E+02, 0.18648000E+01, 0.00000000E+00,
  0.85800850E+03, 0.177E+03, 0.680E+02, 0.18648000E+01, 0.00000000E+00,
  0.84134750E+03, 0.177E+03, 0.690E+02, 0.18648000E+01, 0.00000000E+00,
  0.83123230E+03, 0.177E+03, 0.700E+02, 0.18648000E+01, 0.00000000E+00,
  0.70368220E+03, 0.177E+03, 0.710E+02, 0.18648000E+01, 0.00000000E+00,
  0.69544610E+03, 0.177E+03, 0.720E+02, 0.18648000E+01, 0.00000000E+00,
  0.63722330E+03, 0.177E+03, 0.730E+02, 0.18648000E+01, 0.00000000E+00,
  0.54056670E+03, 0.177E+03, 0.740E+02, 0.18648000E+01, 0.00000000E+00,
  0.55051890E+03, 0.177E+03, 0.750E+02, 0.18648000E+01, 0.00000000E+00,
  0.50082420E+03, 0.177E+03, 0.760E+02, 0.18648000E+01, 0.00000000E+00,
  0.46015330E+03, 0.177E+03, 0.770E+02, 0.18648000E+01, 0.00000000E+00,
  0.38410330E+03, 0.177E+03, 0.780E+02, 0.18648000E+01, 0.00000000E+00,
  0.35955540E+03, 0.177E+03, 0.790E+02, 0.18648000E+01, 0.00000000E+00,
  0.37003820E+03, 0.177E+03, 0.800E+02, 0.18648000E+01, 0.00000000E+00,
  0.53143810E+03, 0.177E+03, 0.810E+02, 0.18648000E+01, 0.00000000E+00,
  0.52144650E+03, 0.177E+03, 0.820E+02, 0.18648000E+01, 0.00000000E+00,
  0.48170840E+03, 0.177E+03, 0.830E+02, 0.18648000E+01, 0.00000000E+00,
  0.46101200E+03, 0.177E+03, 0.840E+02, 0.18648000E+01, 0.00000000E+00,
  0.42739750E+03, 0.177E+03, 0.850E+02, 0.18648000E+01, 0.00000000E+00,
  0.39350690E+03, 0.177E+03, 0.860E+02, 0.18648000E+01, 0.00000000E+00,
  0.12524472E+04, 0.177E+03, 0.870E+02, 0.18648000E+01, 0.00000000E+00,
  0.12109999E+04, 0.177E+03, 0.880E+02, 0.18648000E+01, 0.00000000E+00,
  0.10753003E+04, 0.177E+03, 0.890E+02, 0.18648000E+01, 0.00000000E+00,
  0.97245520E+03, 0.177E+03, 0.900E+02, 0.18648000E+01, 0.00000000E+00,
  0.96345570E+03, 0.177E+03, 0.910E+02, 0.18648000E+01, 0.00000000E+00,
  0.93311220E+03, 0.177E+03, 0.920E+02, 0.18648000E+01, 0.00000000E+00,
  0.95733480E+03, 0.177E+03, 0.930E+02, 0.18648000E+01, 0.00000000E+00,
  0.92763110E+03, 0.177E+03, 0.940E+02, 0.18648000E+01, 0.00000000E+00,
  0.53325500E+02, 0.177E+03, 0.101E+03, 0.18648000E+01, 0.00000000E+00,
  0.16893310E+03, 0.177E+03, 0.103E+03, 0.18648000E+01, 0.98650000E+00,
  0.21625690E+03, 0.177E+03, 0.104E+03, 0.18648000E+01, 0.98080000E+00,
  0.16758690E+03, 0.177E+03, 0.105E+03, 0.18648000E+01, 0.97060000E+00,
  0.12766650E+03, 0.177E+03, 0.106E+03, 0.18648000E+01, 0.98680000E+00,
  0.89935700E+02, 0.177E+03, 0.107E+03, 0.18648000E+01, 0.99440000E+00,
  0.66274300E+02, 0.177E+03, 0.108E+03, 0.18648000E+01, 0.99250000E+00,
  0.46290900E+02, 0.177E+03, 0.109E+03, 0.18648000E+01, 0.99820000E+00,
  0.24667920E+03, 0.177E+03, 0.111E+03, 0.18648000E+01, 0.96840000E+00,
  0.38086140E+03, 0.177E+03, 0.112E+03, 0.18648000E+01, 0.96280000E+00,
  0.38803830E+03, 0.177E+03, 0.113E+03, 0.18648000E+01, 0.96480000E+00,
  0.31510570E+03, 0.177E+03, 0.114E+03, 0.18648000E+01, 0.95070000E+00,
  0.26039720E+03, 0.177E+03, 0.115E+03, 0.18648000E+01, 0.99470000E+00,
  0.22177880E+03, 0.177E+03, 0.116E+03, 0.18648000E+01, 0.99480000E+00,
  0.18273850E+03, 0.177E+03, 0.117E+03, 0.18648000E+01, 0.99720000E+00,
  0.34334310E+03, 0.177E+03, 0.119E+03, 0.18648000E+01, 0.97670000E+00,
  0.64530690E+03, 0.177E+03, 0.120E+03, 0.18648000E+01, 0.98310000E+00,
  0.34546620E+03, 0.177E+03, 0.121E+03, 0.18648000E+01, 0.18627000E+01,
  0.33378450E+03, 0.177E+03, 0.122E+03, 0.18648000E+01, 0.18299000E+01,
  0.32712730E+03, 0.177E+03, 0.123E+03, 0.18648000E+01, 0.19138000E+01,
  0.32385110E+03, 0.177E+03, 0.124E+03, 0.18648000E+01, 0.18269000E+01,
  0.29919940E+03, 0.177E+03, 0.125E+03, 0.18648000E+01, 0.16406000E+01,
  0.27742410E+03, 0.177E+03, 0.126E+03, 0.18648000E+01, 0.16483000E+01,
  0.26476150E+03, 0.177E+03, 0.127E+03, 0.18648000E+01, 0.17149000E+01,
  0.25876330E+03, 0.177E+03, 0.128E+03, 0.18648000E+01, 0.17937000E+01,
  0.25485680E+03, 0.177E+03, 0.129E+03, 0.18648000E+01, 0.95760000E+00,
  0.24052350E+03, 0.177E+03, 0.130E+03, 0.18648000E+01, 0.19419000E+01,
  0.38698910E+03, 0.177E+03, 0.131E+03, 0.18648000E+01, 0.96010000E+00,
  0.34259940E+03, 0.177E+03, 0.132E+03, 0.18648000E+01, 0.94340000E+00,
  0.30908100E+03, 0.177E+03, 0.133E+03, 0.18648000E+01, 0.98890000E+00,
  0.28369920E+03, 0.177E+03, 0.134E+03, 0.18648000E+01, 0.99010000E+00,
  0.25143160E+03, 0.177E+03, 0.135E+03, 0.18648000E+01, 0.99740000E+00,
  0.41068500E+03, 0.177E+03, 0.137E+03, 0.18648000E+01, 0.97380000E+00,
  0.78537910E+03, 0.177E+03, 0.138E+03, 0.18648000E+01, 0.98010000E+00,
  0.60690870E+03, 0.177E+03, 0.139E+03, 0.18648000E+01, 0.19153000E+01,
  0.45710620E+03, 0.177E+03, 0.140E+03, 0.18648000E+01, 0.19355000E+01,
  0.46161660E+03, 0.177E+03, 0.141E+03, 0.18648000E+01, 0.19545000E+01,
  0.43145100E+03, 0.177E+03, 0.142E+03, 0.18648000E+01, 0.19420000E+01,
  0.48128810E+03, 0.177E+03, 0.143E+03, 0.18648000E+01, 0.16682000E+01,
  0.37795500E+03, 0.177E+03, 0.144E+03, 0.18648000E+01, 0.18584000E+01,
  0.35398970E+03, 0.177E+03, 0.145E+03, 0.18648000E+01, 0.19003000E+01,
  0.32921750E+03, 0.177E+03, 0.146E+03, 0.18648000E+01, 0.18630000E+01,
  0.31831050E+03, 0.177E+03, 0.147E+03, 0.18648000E+01, 0.96790000E+00,
  0.31569280E+03, 0.177E+03, 0.148E+03, 0.18648000E+01, 0.19539000E+01,
  0.49262420E+03, 0.177E+03, 0.149E+03, 0.18648000E+01, 0.96330000E+00,
  0.44836200E+03, 0.177E+03, 0.150E+03, 0.18648000E+01, 0.95140000E+00,
  0.42188850E+03, 0.177E+03, 0.151E+03, 0.18648000E+01, 0.97490000E+00,
  0.40057160E+03, 0.177E+03, 0.152E+03, 0.18648000E+01, 0.98110000E+00,
  0.36757650E+03, 0.177E+03, 0.153E+03, 0.18648000E+01, 0.99680000E+00,
  0.48764860E+03, 0.177E+03, 0.155E+03, 0.18648000E+01, 0.99090000E+00,
  0.10171183E+04, 0.177E+03, 0.156E+03, 0.18648000E+01, 0.97970000E+00,
  0.76771820E+03, 0.177E+03, 0.157E+03, 0.18648000E+01, 0.19373000E+01,
  0.49283570E+03, 0.177E+03, 0.159E+03, 0.18648000E+01, 0.29425000E+01,
  0.48268880E+03, 0.177E+03, 0.160E+03, 0.18648000E+01, 0.29455000E+01,
  0.46758270E+03, 0.177E+03, 0.161E+03, 0.18648000E+01, 0.29413000E+01,
  0.46943970E+03, 0.177E+03, 0.162E+03, 0.18648000E+01, 0.29300000E+01,
  0.45134990E+03, 0.177E+03, 0.163E+03, 0.18648000E+01, 0.18286000E+01,
  0.47210950E+03, 0.177E+03, 0.164E+03, 0.18648000E+01, 0.28732000E+01,
  0.44388260E+03, 0.177E+03, 0.165E+03, 0.18648000E+01, 0.29086000E+01,
  0.45095330E+03, 0.177E+03, 0.166E+03, 0.18648000E+01, 0.28965000E+01,
  0.42164500E+03, 0.177E+03, 0.167E+03, 0.18648000E+01, 0.29242000E+01,
  0.40975870E+03, 0.177E+03, 0.168E+03, 0.18648000E+01, 0.29282000E+01,
  0.40699850E+03, 0.177E+03, 0.169E+03, 0.18648000E+01, 0.29246000E+01,
  0.42696980E+03, 0.177E+03, 0.170E+03, 0.18648000E+01, 0.28482000E+01,
  0.39353520E+03, 0.177E+03, 0.171E+03, 0.18648000E+01, 0.29219000E+01,
  0.52755310E+03, 0.177E+03, 0.172E+03, 0.18648000E+01, 0.19254000E+01,
  0.49159800E+03, 0.177E+03, 0.173E+03, 0.18648000E+01, 0.19459000E+01,
  0.45048000E+03, 0.177E+03, 0.174E+03, 0.18648000E+01, 0.19292000E+01,
  0.45433550E+03, 0.177E+03, 0.175E+03, 0.18648000E+01, 0.18104000E+01,
  0.40148890E+03, 0.177E+03, 0.176E+03, 0.18648000E+01, 0.18858000E+01,
  0.37849390E+03, 0.177E+03, 0.177E+03, 0.18648000E+01, 0.18648000E+01,
  0.32091700E+02, 0.178E+03, 0.100E+01, 0.19188000E+01, 0.91180000E+00,
  0.21833800E+02, 0.178E+03, 0.200E+01, 0.19188000E+01, 0.00000000E+00,
  0.46520110E+03, 0.178E+03, 0.300E+01, 0.19188000E+01, 0.00000000E+00,
  0.27545630E+03, 0.178E+03, 0.400E+01, 0.19188000E+01, 0.00000000E+00,
  0.18914850E+03, 0.178E+03, 0.500E+01, 0.19188000E+01, 0.00000000E+00,
  0.13007010E+03, 0.178E+03, 0.600E+01, 0.19188000E+01, 0.00000000E+00,
  0.92371000E+02, 0.178E+03, 0.700E+01, 0.19188000E+01, 0.00000000E+00,
  0.70797500E+02, 0.178E+03, 0.800E+01, 0.19188000E+01, 0.00000000E+00,
  0.54251600E+02, 0.178E+03, 0.900E+01, 0.19188000E+01, 0.00000000E+00,
  0.42149900E+02, 0.178E+03, 0.100E+02, 0.19188000E+01, 0.00000000E+00,
  0.55760480E+03, 0.178E+03, 0.110E+02, 0.19188000E+01, 0.00000000E+00,
  0.43700990E+03, 0.178E+03, 0.120E+02, 0.19188000E+01, 0.00000000E+00,
  0.40638720E+03, 0.178E+03, 0.130E+02, 0.19188000E+01, 0.00000000E+00,
  0.32432370E+03, 0.178E+03, 0.140E+02, 0.19188000E+01, 0.00000000E+00,
  0.25607430E+03, 0.178E+03, 0.150E+02, 0.19188000E+01, 0.00000000E+00,
  0.21453080E+03, 0.178E+03, 0.160E+02, 0.19188000E+01, 0.00000000E+00,
  0.17695160E+03, 0.178E+03, 0.170E+02, 0.19188000E+01, 0.00000000E+00,
  0.14611660E+03, 0.178E+03, 0.180E+02, 0.19188000E+01, 0.00000000E+00,
  0.91385330E+03, 0.178E+03, 0.190E+02, 0.19188000E+01, 0.00000000E+00,
  0.76327990E+03, 0.178E+03, 0.200E+02, 0.19188000E+01, 0.00000000E+00,
  0.63264330E+03, 0.178E+03, 0.210E+02, 0.19188000E+01, 0.00000000E+00,
  0.61344560E+03, 0.178E+03, 0.220E+02, 0.19188000E+01, 0.00000000E+00,
  0.56306260E+03, 0.178E+03, 0.230E+02, 0.19188000E+01, 0.00000000E+00,
  0.44482350E+03, 0.178E+03, 0.240E+02, 0.19188000E+01, 0.00000000E+00,
  0.48647550E+03, 0.178E+03, 0.250E+02, 0.19188000E+01, 0.00000000E+00,
  0.38312130E+03, 0.178E+03, 0.260E+02, 0.19188000E+01, 0.00000000E+00,
  0.40695490E+03, 0.178E+03, 0.270E+02, 0.19188000E+01, 0.00000000E+00,
  0.41813480E+03, 0.178E+03, 0.280E+02, 0.19188000E+01, 0.00000000E+00,
  0.32172230E+03, 0.178E+03, 0.290E+02, 0.19188000E+01, 0.00000000E+00,
  0.33177490E+03, 0.178E+03, 0.300E+02, 0.19188000E+01, 0.00000000E+00,
  0.39148440E+03, 0.178E+03, 0.310E+02, 0.19188000E+01, 0.00000000E+00,
  0.34844170E+03, 0.178E+03, 0.320E+02, 0.19188000E+01, 0.00000000E+00,
  0.30012110E+03, 0.178E+03, 0.330E+02, 0.19188000E+01, 0.00000000E+00,
  0.27118850E+03, 0.178E+03, 0.340E+02, 0.19188000E+01, 0.00000000E+00,
  0.23915510E+03, 0.178E+03, 0.350E+02, 0.19188000E+01, 0.00000000E+00,
  0.20957880E+03, 0.178E+03, 0.360E+02, 0.19188000E+01, 0.00000000E+00,
  0.10265038E+04, 0.178E+03, 0.370E+02, 0.19188000E+01, 0.00000000E+00,
  0.90978800E+03, 0.178E+03, 0.380E+02, 0.19188000E+01, 0.00000000E+00,
  0.80197930E+03, 0.178E+03, 0.390E+02, 0.19188000E+01, 0.00000000E+00,
  0.72399270E+03, 0.178E+03, 0.400E+02, 0.19188000E+01, 0.00000000E+00,
  0.66240900E+03, 0.178E+03, 0.410E+02, 0.19188000E+01, 0.00000000E+00,
  0.51504420E+03, 0.178E+03, 0.420E+02, 0.19188000E+01, 0.00000000E+00,
  0.57309040E+03, 0.178E+03, 0.430E+02, 0.19188000E+01, 0.00000000E+00,
  0.44003780E+03, 0.178E+03, 0.440E+02, 0.19188000E+01, 0.00000000E+00,
  0.48010810E+03, 0.178E+03, 0.450E+02, 0.19188000E+01, 0.00000000E+00,
  0.44621570E+03, 0.178E+03, 0.460E+02, 0.19188000E+01, 0.00000000E+00,
  0.37286390E+03, 0.178E+03, 0.470E+02, 0.19188000E+01, 0.00000000E+00,
  0.39438550E+03, 0.178E+03, 0.480E+02, 0.19188000E+01, 0.00000000E+00,
  0.49129160E+03, 0.178E+03, 0.490E+02, 0.19188000E+01, 0.00000000E+00,
  0.45727960E+03, 0.178E+03, 0.500E+02, 0.19188000E+01, 0.00000000E+00,
  0.41067770E+03, 0.178E+03, 0.510E+02, 0.19188000E+01, 0.00000000E+00,
  0.38304320E+03, 0.178E+03, 0.520E+02, 0.19188000E+01, 0.00000000E+00,
  0.34847210E+03, 0.178E+03, 0.530E+02, 0.19188000E+01, 0.00000000E+00,
  0.31527170E+03, 0.178E+03, 0.540E+02, 0.19188000E+01, 0.00000000E+00,
  0.12516079E+04, 0.178E+03, 0.550E+02, 0.19188000E+01, 0.00000000E+00,
  0.11586040E+04, 0.178E+03, 0.560E+02, 0.19188000E+01, 0.00000000E+00,
  0.10239496E+04, 0.178E+03, 0.570E+02, 0.19188000E+01, 0.00000000E+00,
  0.48500190E+03, 0.178E+03, 0.580E+02, 0.19188000E+01, 0.27991000E+01,
  0.10291720E+04, 0.178E+03, 0.590E+02, 0.19188000E+01, 0.00000000E+00,
  0.98909200E+03, 0.178E+03, 0.600E+02, 0.19188000E+01, 0.00000000E+00,
  0.96450040E+03, 0.178E+03, 0.610E+02, 0.19188000E+01, 0.00000000E+00,
  0.94184450E+03, 0.178E+03, 0.620E+02, 0.19188000E+01, 0.00000000E+00,
  0.92175840E+03, 0.178E+03, 0.630E+02, 0.19188000E+01, 0.00000000E+00,
  0.73100210E+03, 0.178E+03, 0.640E+02, 0.19188000E+01, 0.00000000E+00,
  0.81592560E+03, 0.178E+03, 0.650E+02, 0.19188000E+01, 0.00000000E+00,
  0.78790030E+03, 0.178E+03, 0.660E+02, 0.19188000E+01, 0.00000000E+00,
  0.83246930E+03, 0.178E+03, 0.670E+02, 0.19188000E+01, 0.00000000E+00,
  0.81486390E+03, 0.178E+03, 0.680E+02, 0.19188000E+01, 0.00000000E+00,
  0.79906290E+03, 0.178E+03, 0.690E+02, 0.19188000E+01, 0.00000000E+00,
  0.78940200E+03, 0.178E+03, 0.700E+02, 0.19188000E+01, 0.00000000E+00,
  0.66892220E+03, 0.178E+03, 0.710E+02, 0.19188000E+01, 0.00000000E+00,
  0.66171440E+03, 0.178E+03, 0.720E+02, 0.19188000E+01, 0.00000000E+00,
  0.60682340E+03, 0.178E+03, 0.730E+02, 0.19188000E+01, 0.00000000E+00,
  0.51528520E+03, 0.178E+03, 0.740E+02, 0.19188000E+01, 0.00000000E+00,
  0.52488810E+03, 0.178E+03, 0.750E+02, 0.19188000E+01, 0.00000000E+00,
  0.47789070E+03, 0.178E+03, 0.760E+02, 0.19188000E+01, 0.00000000E+00,
  0.43938870E+03, 0.178E+03, 0.770E+02, 0.19188000E+01, 0.00000000E+00,
  0.36716870E+03, 0.178E+03, 0.780E+02, 0.19188000E+01, 0.00000000E+00,
  0.34385620E+03, 0.178E+03, 0.790E+02, 0.19188000E+01, 0.00000000E+00,
  0.35390700E+03, 0.178E+03, 0.800E+02, 0.19188000E+01, 0.00000000E+00,
  0.50669330E+03, 0.178E+03, 0.810E+02, 0.19188000E+01, 0.00000000E+00,
  0.49751750E+03, 0.178E+03, 0.820E+02, 0.19188000E+01, 0.00000000E+00,
  0.46009860E+03, 0.178E+03, 0.830E+02, 0.19188000E+01, 0.00000000E+00,
  0.44063800E+03, 0.178E+03, 0.840E+02, 0.19188000E+01, 0.00000000E+00,
  0.40889250E+03, 0.178E+03, 0.850E+02, 0.19188000E+01, 0.00000000E+00,
  0.37682880E+03, 0.178E+03, 0.860E+02, 0.19188000E+01, 0.00000000E+00,
  0.11875608E+04, 0.178E+03, 0.870E+02, 0.19188000E+01, 0.00000000E+00,
  0.11496435E+04, 0.178E+03, 0.880E+02, 0.19188000E+01, 0.00000000E+00,
  0.10218132E+04, 0.178E+03, 0.890E+02, 0.19188000E+01, 0.00000000E+00,
  0.92532050E+03, 0.178E+03, 0.900E+02, 0.19188000E+01, 0.00000000E+00,
  0.91638160E+03, 0.178E+03, 0.910E+02, 0.19188000E+01, 0.00000000E+00,
  0.88757730E+03, 0.178E+03, 0.920E+02, 0.19188000E+01, 0.00000000E+00,
  0.90998500E+03, 0.178E+03, 0.930E+02, 0.19188000E+01, 0.00000000E+00,
  0.88186200E+03, 0.178E+03, 0.940E+02, 0.19188000E+01, 0.00000000E+00,
  0.50936600E+02, 0.178E+03, 0.101E+03, 0.19188000E+01, 0.00000000E+00,
  0.16064720E+03, 0.178E+03, 0.103E+03, 0.19188000E+01, 0.98650000E+00,
  0.20578590E+03, 0.178E+03, 0.104E+03, 0.19188000E+01, 0.98080000E+00,
  0.15992840E+03, 0.178E+03, 0.105E+03, 0.19188000E+01, 0.97060000E+00,
  0.12211080E+03, 0.178E+03, 0.106E+03, 0.19188000E+01, 0.98680000E+00,
  0.86265500E+02, 0.178E+03, 0.107E+03, 0.19188000E+01, 0.99440000E+00,
  0.63736400E+02, 0.178E+03, 0.108E+03, 0.19188000E+01, 0.99250000E+00,
  0.44679200E+02, 0.178E+03, 0.109E+03, 0.19188000E+01, 0.99820000E+00,
  0.23456040E+03, 0.178E+03, 0.111E+03, 0.19188000E+01, 0.96840000E+00,
  0.36198670E+03, 0.178E+03, 0.112E+03, 0.19188000E+01, 0.96280000E+00,
  0.36923330E+03, 0.178E+03, 0.113E+03, 0.19188000E+01, 0.96480000E+00,
  0.30045310E+03, 0.178E+03, 0.114E+03, 0.19188000E+01, 0.95070000E+00,
  0.24874070E+03, 0.178E+03, 0.115E+03, 0.19188000E+01, 0.99470000E+00,
  0.21216920E+03, 0.178E+03, 0.116E+03, 0.19188000E+01, 0.99480000E+00,
  0.17511990E+03, 0.178E+03, 0.117E+03, 0.19188000E+01, 0.99720000E+00,
  0.32711390E+03, 0.178E+03, 0.119E+03, 0.19188000E+01, 0.97670000E+00,
  0.61266150E+03, 0.178E+03, 0.120E+03, 0.19188000E+01, 0.98310000E+00,
  0.32950500E+03, 0.178E+03, 0.121E+03, 0.19188000E+01, 0.18627000E+01,
  0.31842170E+03, 0.178E+03, 0.122E+03, 0.19188000E+01, 0.18299000E+01,
  0.31208150E+03, 0.178E+03, 0.123E+03, 0.19188000E+01, 0.19138000E+01,
  0.30891510E+03, 0.178E+03, 0.124E+03, 0.19188000E+01, 0.18269000E+01,
  0.28562920E+03, 0.178E+03, 0.125E+03, 0.19188000E+01, 0.16406000E+01,
  0.26494780E+03, 0.178E+03, 0.126E+03, 0.19188000E+01, 0.16483000E+01,
  0.25288280E+03, 0.178E+03, 0.127E+03, 0.19188000E+01, 0.17149000E+01,
  0.24714320E+03, 0.178E+03, 0.128E+03, 0.19188000E+01, 0.17937000E+01,
  0.24327100E+03, 0.178E+03, 0.129E+03, 0.19188000E+01, 0.95760000E+00,
  0.22984390E+03, 0.178E+03, 0.130E+03, 0.19188000E+01, 0.19419000E+01,
  0.36860280E+03, 0.178E+03, 0.131E+03, 0.19188000E+01, 0.96010000E+00,
  0.32682470E+03, 0.178E+03, 0.132E+03, 0.19188000E+01, 0.94340000E+00,
  0.29524020E+03, 0.178E+03, 0.133E+03, 0.19188000E+01, 0.98890000E+00,
  0.27128510E+03, 0.178E+03, 0.134E+03, 0.19188000E+01, 0.99010000E+00,
  0.24074110E+03, 0.178E+03, 0.135E+03, 0.19188000E+01, 0.99740000E+00,
  0.39146850E+03, 0.178E+03, 0.137E+03, 0.19188000E+01, 0.97380000E+00,
  0.74566370E+03, 0.178E+03, 0.138E+03, 0.19188000E+01, 0.98010000E+00,
  0.57749450E+03, 0.178E+03, 0.139E+03, 0.19188000E+01, 0.19153000E+01,
  0.43601580E+03, 0.178E+03, 0.140E+03, 0.19188000E+01, 0.19355000E+01,
  0.44033040E+03, 0.178E+03, 0.141E+03, 0.19188000E+01, 0.19545000E+01,
  0.41176280E+03, 0.178E+03, 0.142E+03, 0.19188000E+01, 0.19420000E+01,
  0.45883330E+03, 0.178E+03, 0.143E+03, 0.19188000E+01, 0.16682000E+01,
  0.36109350E+03, 0.178E+03, 0.144E+03, 0.19188000E+01, 0.18584000E+01,
  0.33829080E+03, 0.178E+03, 0.145E+03, 0.19188000E+01, 0.19003000E+01,
  0.31473130E+03, 0.178E+03, 0.146E+03, 0.19188000E+01, 0.18630000E+01,
  0.30428650E+03, 0.178E+03, 0.147E+03, 0.19188000E+01, 0.96790000E+00,
  0.30192540E+03, 0.178E+03, 0.148E+03, 0.19188000E+01, 0.19539000E+01,
  0.46950870E+03, 0.178E+03, 0.149E+03, 0.19188000E+01, 0.96330000E+00,
  0.42783570E+03, 0.178E+03, 0.150E+03, 0.19188000E+01, 0.95140000E+00,
  0.40295210E+03, 0.178E+03, 0.151E+03, 0.19188000E+01, 0.97490000E+00,
  0.38287770E+03, 0.178E+03, 0.152E+03, 0.19188000E+01, 0.98110000E+00,
  0.35168470E+03, 0.178E+03, 0.153E+03, 0.19188000E+01, 0.99680000E+00,
  0.46516200E+03, 0.178E+03, 0.155E+03, 0.19188000E+01, 0.99090000E+00,
  0.96540540E+03, 0.178E+03, 0.156E+03, 0.19188000E+01, 0.97970000E+00,
  0.73040540E+03, 0.178E+03, 0.157E+03, 0.19188000E+01, 0.19373000E+01,
  0.47064590E+03, 0.178E+03, 0.159E+03, 0.19188000E+01, 0.29425000E+01,
  0.46096660E+03, 0.178E+03, 0.160E+03, 0.19188000E+01, 0.29455000E+01,
  0.44658000E+03, 0.178E+03, 0.161E+03, 0.19188000E+01, 0.29413000E+01,
  0.44826620E+03, 0.178E+03, 0.162E+03, 0.19188000E+01, 0.29300000E+01,
  0.43078610E+03, 0.178E+03, 0.163E+03, 0.19188000E+01, 0.18286000E+01,
  0.45075260E+03, 0.178E+03, 0.164E+03, 0.19188000E+01, 0.28732000E+01,
  0.42390040E+03, 0.178E+03, 0.165E+03, 0.19188000E+01, 0.29086000E+01,
  0.43051250E+03, 0.178E+03, 0.166E+03, 0.19188000E+01, 0.28965000E+01,
  0.40272530E+03, 0.178E+03, 0.167E+03, 0.19188000E+01, 0.29242000E+01,
  0.39139780E+03, 0.178E+03, 0.168E+03, 0.19188000E+01, 0.29282000E+01,
  0.38873440E+03, 0.178E+03, 0.169E+03, 0.19188000E+01, 0.29246000E+01,
  0.40763660E+03, 0.178E+03, 0.170E+03, 0.19188000E+01, 0.28482000E+01,
  0.37590100E+03, 0.178E+03, 0.171E+03, 0.19188000E+01, 0.29219000E+01,
  0.50277570E+03, 0.178E+03, 0.172E+03, 0.19188000E+01, 0.19254000E+01,
  0.46891240E+03, 0.178E+03, 0.173E+03, 0.19188000E+01, 0.19459000E+01,
  0.43008890E+03, 0.178E+03, 0.174E+03, 0.19188000E+01, 0.19292000E+01,
  0.43348520E+03, 0.178E+03, 0.175E+03, 0.19188000E+01, 0.18104000E+01,
  0.38382310E+03, 0.178E+03, 0.176E+03, 0.19188000E+01, 0.18858000E+01,
  0.36201210E+03, 0.178E+03, 0.177E+03, 0.19188000E+01, 0.18648000E+01,
  0.34636100E+03, 0.178E+03, 0.178E+03, 0.19188000E+01, 0.19188000E+01,
  0.30675700E+02, 0.179E+03, 0.100E+01, 0.98460000E+00, 0.91180000E+00,
  0.20941000E+02, 0.179E+03, 0.200E+01, 0.98460000E+00, 0.00000000E+00,
  0.44619080E+03, 0.179E+03, 0.300E+01, 0.98460000E+00, 0.00000000E+00,
  0.26322300E+03, 0.179E+03, 0.400E+01, 0.98460000E+00, 0.00000000E+00,
  0.18065820E+03, 0.179E+03, 0.500E+01, 0.98460000E+00, 0.00000000E+00,
  0.12431330E+03, 0.179E+03, 0.600E+01, 0.98460000E+00, 0.00000000E+00,
  0.88391500E+02, 0.179E+03, 0.700E+01, 0.98460000E+00, 0.00000000E+00,
  0.67837200E+02, 0.179E+03, 0.800E+01, 0.98460000E+00, 0.00000000E+00,
  0.52061000E+02, 0.179E+03, 0.900E+01, 0.98460000E+00, 0.00000000E+00,
  0.40509200E+02, 0.179E+03, 0