# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AKSIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The identity type."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"


class ComplianceStateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The compliance state of the configuration."""

    PENDING = "Pending"
    COMPLIANT = "Compliant"
    NONCOMPLIANT = "Noncompliant"
    INSTALLED = "Installed"
    FAILED = "Failed"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class FluxComplianceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Compliance state of the cluster object."""

    COMPLIANT = "Compliant"
    NON_COMPLIANT = "Non-Compliant"
    PENDING = "Pending"
    SUSPENDED = "Suspended"
    UNKNOWN = "Unknown"


class KustomizationValidationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify whether to validate the Kubernetes objects referenced in the Kustomization before
    applying them to the cluster.
    """

    NONE = "none"
    CLIENT = "client"
    SERVER = "server"


class LevelType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Level of the status."""

    ERROR = "Error"
    WARNING = "Warning"
    INFORMATION = "Information"


class MessageLevelType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Level of the message."""

    ERROR = "Error"
    WARNING = "Warning"
    INFORMATION = "Information"


class OperatorScopeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scope at which the operator will be installed."""

    CLUSTER = "cluster"
    NAMESPACE = "namespace"


class OperatorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the operator."""

    FLUX = "Flux"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the resource."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"


class ProvisioningStateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the resource provider."""

    ACCEPTED = "Accepted"
    DELETING = "Deleting"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"


class ScopeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scope at which the configuration will be installed."""

    CLUSTER = "cluster"
    NAMESPACE = "namespace"


class SourceKindType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Source Kind to pull the configuration data from."""

    GIT_REPOSITORY = "GitRepository"
    BUCKET = "Bucket"
    AZURE_BLOB = "AzureBlob"
