% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_trend_test.R
\name{prop_trend_test}
\alias{prop_trend_test}
\title{Test for Trend in Proportions}
\usage{
prop_trend_test(xtab, score = NULL)
}
\arguments{
\item{xtab}{a cross-tabulation (or contingency table) with two columns and
multiple rows (rx2 design). The columns give the counts of successes and
failures respectively.}

\item{score}{group score. If \code{NULL}, the default is group number.}
}
\value{
return a data frame with some the following columns: \itemize{ \item
 \code{n}: the number of participants.  \item \code{statistic}: the value of
 Chi-squared trend test statistic. \item \code{df}: the degrees of
 freedom.
 \item \code{p}: p-value. \item
 \code{method}: the used statistical test. \item \code{p.signif}: the significance level of p-values and adjusted p-values,
 respectively.}

 The \strong{returned object has an attribute called args}, which is a list
 holding the test arguments.
}
\description{
Performs chi-squared test for trend in proportion. This test is
 also known as Cochran-Armitage trend test.

 Wrappers around the R base function \code{\link[stats]{prop.trend.test}()} but
 returns a data frame for easy data visualization.
}
\examples{
# Proportion of renal stone (calculi) across age
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Data
xtab <- as.table(rbind(
  c(384, 536, 335),
  c(951, 869, 438)
))
dimnames(xtab) <- list(
  stone = c("yes", "no"),
  age = c("30-39", "40-49", "50-59")
)
xtab
# Compare the proportion of survived between groups
prop_trend_test(xtab)
}
