% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-inheritance.R
\name{inheritance-expectations}
\alias{inheritance-expectations}
\alias{expect_null}
\alias{expect_type}
\alias{expect_is}
\alias{expect_s3_class}
\alias{expect_s4_class}
\title{Expectation: does the object inherit from a S3 or S4 class, or a base type?}
\usage{
expect_null(object, info = NULL, label = NULL)

expect_type(object, type)

expect_is(object, class, info = NULL, label = NULL)

expect_s3_class(object, class)

expect_s4_class(object, class)
}
\arguments{
\item{object}{object to test}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{label}{object label. When \code{NULL}, computed from deparsed object.}

\item{type}{String giving base type (as returned by \code{\link[=typeof]{typeof()}}).}

\item{class}{character vector of class names}
}
\description{
Tests whether or not an object inherits from any of a list of classes, or
is an instance of a base type. \code{expect_null()} is a special case designed
for detecting \code{NULL}.
}
\details{
\code{expect_is()} is an older form. I'd recommend using \code{expect_s3_class()}
or \code{expect_s4_class()} in order to more clearly convey intent.
}
\examples{
expect_is(1, "numeric")
a <- matrix(1:10, nrow = 5)
expect_is(a, "matrix")

expect_is(mtcars, "data.frame")
# alternatively for classes that have an is method
expect_true(is.data.frame(mtcars))

f <- factor("a")
expect_is(f, "factor")
expect_s3_class(f, "factor")
expect_type(f, "integer")

expect_null(NULL)

}
\seealso{
\code{\link[=inherits]{inherits()}}

Other expectations: \code{\link{comparison-expectations}},
  \code{\link{equality-expectations}},
  \code{\link{expect_length}}, \code{\link{expect_match}},
  \code{\link{expect_named}},
  \code{\link{logical-expectations}},
  \code{\link{output-expectations}}
}
