# SPDX-License-Identifier: GPL-2.0-only
# This file is part of Scapy RPC
# See https://scapy.net/ for more information
# Copyright (C) Gabriel Potter

# [ms-nrpc] v45.0 (Tue, 08 Jul 2025)

"""
RPC definitions for the following interfaces:
- logon (v1.0): 12345678-1234-ABCD-EF00-01234567CFFB
This file is auto-generated by midl-to-scapy, do not modify.
"""

from enum import IntEnum
import uuid

from scapy.fields import PacketListField, StrFixedLenField, StrFixedLenFieldUtf16
from scapy.layers.dcerpc import (
    NDRPacket,
    DceRpcOp,
    NDRByteField,
    NDRConfFieldListField,
    NDRConfPacketListField,
    NDRConfStrLenField,
    NDRConfVarStrLenField,
    NDRConfVarStrLenFieldUtf16,
    NDRConfVarStrNullField,
    NDRConfVarStrNullFieldUtf16,
    NDRFieldListField,
    NDRFullEmbPointerField,
    NDRFullPointerField,
    NDRInt3264EnumField,
    NDRIntField,
    NDRLongField,
    NDRPacketField,
    NDRShortField,
    NDRSignedIntField,
    NDRSignedLongField,
    NDRUnionField,
    register_dcerpc_interface,
)


class PNETLOGON_VALIDATION_UAS_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("usrlog1_eff_name", "")),
        NDRIntField("usrlog1_priv", 0),
        NDRIntField("usrlog1_auth_flags", 0),
        NDRIntField("usrlog1_num_logons", 0),
        NDRIntField("usrlog1_bad_pw_count", 0),
        NDRIntField("usrlog1_last_logon", 0),
        NDRIntField("usrlog1_last_logoff", 0),
        NDRIntField("usrlog1_logoff_time", 0),
        NDRIntField("usrlog1_kickoff_time", 0),
        NDRIntField("usrlog1_password_age", 0),
        NDRIntField("usrlog1_pw_can_change", 0),
        NDRIntField("usrlog1_pw_must_change", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("usrlog1_computer", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("usrlog1_domain", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("usrlog1_script_path", "")),
        NDRIntField("usrlog1_reserved1", 0),
    ]


class NetrLogonUasLogon_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRConfVarStrNullFieldUtf16("UserName", ""),
        NDRConfVarStrNullFieldUtf16("Workstation", ""),
    ]


class NetrLogonUasLogon_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(
            NDRPacketField(
                "ValidationInformation",
                PNETLOGON_VALIDATION_UAS_INFO(),
                PNETLOGON_VALIDATION_UAS_INFO,
            )
        ),
        NDRIntField("status", 0),
    ]


class PNETLOGON_LOGOFF_UAS_INFO(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("Duration", 0), NDRShortField("LogonCount", 0)]


class NetrLogonUasLogoff_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRConfVarStrNullFieldUtf16("UserName", ""),
        NDRConfVarStrNullFieldUtf16("Workstation", ""),
    ]


class NetrLogonUasLogoff_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "LogoffInformation", PNETLOGON_LOGOFF_UAS_INFO(), PNETLOGON_LOGOFF_UAS_INFO
        ),
        NDRIntField("status", 0),
    ]


class NETLOGON_CREDENTIAL(NDRPacket):
    fields_desc = [StrFixedLenField("data", "", length=8)]


class PNETLOGON_AUTHENTICATOR(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [
        NDRPacketField("Credential", NETLOGON_CREDENTIAL(), NETLOGON_CREDENTIAL),
        NDRIntField("Timestamp", 0),
    ]


class NETLOGON_LOGON_INFO_CLASS(IntEnum):
    NetlogonInteractiveInformation = 1
    NetlogonNetworkInformation = 2
    NetlogonServiceInformation = 3
    NetlogonGenericInformation = 4
    NetlogonInteractiveTransitiveInformation = 5
    NetlogonNetworkTransitiveInformation = 6
    NetlogonServiceTransitiveInformation = 7
    NetlogonTicketLogonInformation = 8


class UNICODE_STRING(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRShortField("Length", None, size_of="Buffer", adjust=lambda _, x: (x * 2)),
        NDRShortField(
            "MaximumLength", None, size_of="Buffer", adjust=lambda _, x: (x * 2)
        ),
        NDRFullEmbPointerField(
            NDRConfVarStrLenFieldUtf16(
                "Buffer",
                "",
                size_is=lambda pkt: (pkt.MaximumLength // 2),
                length_is=lambda pkt: (pkt.Length // 2),
            )
        ),
    ]


class OLD_LARGE_INTEGER(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("LowPart", 0), NDRSignedIntField("HighPart", 0)]


class NETLOGON_LOGON_IDENTITY_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("LogonDomainName", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("ParameterControl", 0),
        NDRPacketField("Reserved", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("UserName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("Workstation", UNICODE_STRING(), UNICODE_STRING),
    ]


class CYPHER_BLOCK(NDRPacket):
    fields_desc = [StrFixedLenField("data", "", length=8)]


class LM_OWF_PASSWORD(NDRPacket):
    fields_desc = [
        PacketListField(
            "data", [CYPHER_BLOCK()] * 2, CYPHER_BLOCK, count_from=lambda _: 2
        )
    ]


class NT_OWF_PASSWORD(NDRPacket):
    fields_desc = [
        PacketListField(
            "data", [CYPHER_BLOCK()] * 2, CYPHER_BLOCK, count_from=lambda _: 2
        )
    ]


class PNETLOGON_INTERACTIVE_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField(
            "Identity", NETLOGON_LOGON_IDENTITY_INFO(), NETLOGON_LOGON_IDENTITY_INFO
        ),
        NDRPacketField("LmOwfPassword", LM_OWF_PASSWORD(), LM_OWF_PASSWORD),
        NDRPacketField("NtOwfPassword", NT_OWF_PASSWORD(), NT_OWF_PASSWORD),
    ]


class PNETLOGON_SERVICE_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField(
            "Identity", NETLOGON_LOGON_IDENTITY_INFO(), NETLOGON_LOGON_IDENTITY_INFO
        ),
        NDRPacketField("LmOwfPassword", LM_OWF_PASSWORD(), LM_OWF_PASSWORD),
        NDRPacketField("NtOwfPassword", NT_OWF_PASSWORD(), NT_OWF_PASSWORD),
    ]


class LM_CHALLENGE(NDRPacket):
    fields_desc = [StrFixedLenField("data", "", length=8)]


class STRING(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRShortField("Length", None, size_of="Buffer"),
        NDRShortField("MaximumLength", None, size_of="Buffer"),
        NDRFullEmbPointerField(
            NDRConfVarStrLenField(
                "Buffer",
                "",
                size_is=lambda pkt: pkt.MaximumLength,
                length_is=lambda pkt: pkt.Length,
            )
        ),
    ]


class PNETLOGON_NETWORK_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField(
            "Identity", NETLOGON_LOGON_IDENTITY_INFO(), NETLOGON_LOGON_IDENTITY_INFO
        ),
        NDRPacketField("LmChallenge", LM_CHALLENGE(), LM_CHALLENGE),
        NDRPacketField("NtChallengeResponse", STRING(), STRING),
        NDRPacketField("LmChallengeResponse", STRING(), STRING),
    ]


class PNETLOGON_GENERIC_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField(
            "Identity", NETLOGON_LOGON_IDENTITY_INFO(), NETLOGON_LOGON_IDENTITY_INFO
        ),
        NDRPacketField("PackageName", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("DataLength", None, size_of="LogonData"),
        NDRFullEmbPointerField(
            NDRConfStrLenField("LogonData", "", size_is=lambda pkt: pkt.DataLength)
        ),
    ]


class PNETLOGON_TICKET_LOGON_INFO(NDRPacket):
    ALIGNMENT = (8, 8)
    fields_desc = [
        NDRPacketField(
            "Identity", NETLOGON_LOGON_IDENTITY_INFO(), NETLOGON_LOGON_IDENTITY_INFO
        ),
        NDRLongField("RequestOptions", 0),
        NDRIntField("ServiceTicketLength", None, size_of="ServiceTicket"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "ServiceTicket", "", size_is=lambda pkt: pkt.ServiceTicketLength
            )
        ),
        NDRIntField("AdditionalTicketLength", None, size_of="AdditionalTicket"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "AdditionalTicket", "", size_is=lambda pkt: pkt.AdditionalTicketLength
            )
        ),
    ]


class NETLOGON_VALIDATION_INFO_CLASS(IntEnum):
    NetlogonValidationUasInfo = 1
    NetlogonValidationSamInfo = 2
    NetlogonValidationSamInfo2 = 3
    NetlogonValidationGenericInfo = 4
    NetlogonValidationGenericInfo2 = 5
    NetlogonValidationSamInfo4 = 6
    NetlogonValidationTicketLogon = 7


class PGROUP_MEMBERSHIP(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [NDRIntField("RelativeId", 0), NDRIntField("Attributes", 0)]


class USER_SESSION_KEY(NDRPacket):
    fields_desc = [
        PacketListField(
            "data", [CYPHER_BLOCK()] * 2, CYPHER_BLOCK, count_from=lambda _: 2
        )
    ]


class RPC_SID_IDENTIFIER_AUTHORITY(NDRPacket):
    fields_desc = [StrFixedLenField("Value", "", length=6)]


class PRPC_SID(NDRPacket):
    ALIGNMENT = (4, 8)
    DEPORTED_CONFORMANTS = ["SubAuthority"]
    fields_desc = [
        NDRByteField("Revision", 0),
        NDRByteField("SubAuthorityCount", None, size_of="SubAuthority"),
        NDRPacketField(
            "IdentifierAuthority",
            RPC_SID_IDENTIFIER_AUTHORITY(),
            RPC_SID_IDENTIFIER_AUTHORITY,
        ),
        NDRConfFieldListField(
            "SubAuthority",
            [],
            NDRIntField("", 0),
            size_is=lambda pkt: pkt.SubAuthorityCount,
            conformant_in_struct=True,
        ),
    ]


class PNETLOGON_VALIDATION_SAM_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("LogonTime", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("LogoffTime", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("KickOffTime", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("PasswordLastSet", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("PasswordCanChange", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("PasswordMustChange", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("EffectiveName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("FullName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("LogonScript", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ProfilePath", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("HomeDirectory", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("HomeDirectoryDrive", UNICODE_STRING(), UNICODE_STRING),
        NDRShortField("LogonCount", 0),
        NDRShortField("BadPasswordCount", 0),
        NDRIntField("UserId", 0),
        NDRIntField("PrimaryGroupId", 0),
        NDRIntField("GroupCount", None, size_of="GroupIds"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "GroupIds", [], PGROUP_MEMBERSHIP, size_is=lambda pkt: pkt.GroupCount
            )
        ),
        NDRIntField("UserFlags", 0),
        NDRPacketField("UserSessionKey", USER_SESSION_KEY(), USER_SESSION_KEY),
        NDRPacketField("LogonServer", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("LogonDomainName", UNICODE_STRING(), UNICODE_STRING),
        NDRFullEmbPointerField(NDRPacketField("LogonDomainId", PRPC_SID(), PRPC_SID)),
        NDRFieldListField(
            "ExpansionRoom", [0] * 10, NDRIntField("", 0), length_is=lambda _: 10
        ),
    ]


class PNETLOGON_SID_AND_ATTRIBUTES(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRPacketField("Sid", PRPC_SID(), PRPC_SID)),
        NDRIntField("Attributes", 0),
    ]


class PNETLOGON_VALIDATION_SAM_INFO2(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("LogonTime", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("LogoffTime", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("KickOffTime", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("PasswordLastSet", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("PasswordCanChange", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("PasswordMustChange", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("EffectiveName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("FullName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("LogonScript", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ProfilePath", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("HomeDirectory", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("HomeDirectoryDrive", UNICODE_STRING(), UNICODE_STRING),
        NDRShortField("LogonCount", 0),
        NDRShortField("BadPasswordCount", 0),
        NDRIntField("UserId", 0),
        NDRIntField("PrimaryGroupId", 0),
        NDRIntField("GroupCount", None, size_of="GroupIds"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "GroupIds", [], PGROUP_MEMBERSHIP, size_is=lambda pkt: pkt.GroupCount
            )
        ),
        NDRIntField("UserFlags", 0),
        NDRPacketField("UserSessionKey", USER_SESSION_KEY(), USER_SESSION_KEY),
        NDRPacketField("LogonServer", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("LogonDomainName", UNICODE_STRING(), UNICODE_STRING),
        NDRFullEmbPointerField(NDRPacketField("LogonDomainId", PRPC_SID(), PRPC_SID)),
        NDRFieldListField(
            "ExpansionRoom", [0] * 10, NDRIntField("", 0), length_is=lambda _: 10
        ),
        NDRIntField("SidCount", None, size_of="ExtraSids"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "ExtraSids",
                [],
                PNETLOGON_SID_AND_ATTRIBUTES,
                size_is=lambda pkt: pkt.SidCount,
            )
        ),
    ]


class PNETLOGON_VALIDATION_GENERIC_INFO2(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("DataLength", None, size_of="ValidationData"),
        NDRFullEmbPointerField(
            NDRConfStrLenField("ValidationData", "", size_is=lambda pkt: pkt.DataLength)
        ),
    ]


class PNETLOGON_VALIDATION_SAM_INFO4(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("LogonTime", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("LogoffTime", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("KickOffTime", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("PasswordLastSet", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("PasswordCanChange", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("PasswordMustChange", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("EffectiveName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("FullName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("LogonScript", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ProfilePath", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("HomeDirectory", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("HomeDirectoryDrive", UNICODE_STRING(), UNICODE_STRING),
        NDRShortField("LogonCount", 0),
        NDRShortField("BadPasswordCount", 0),
        NDRIntField("UserId", 0),
        NDRIntField("PrimaryGroupId", 0),
        NDRIntField("GroupCount", None, size_of="GroupIds"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "GroupIds", [], PGROUP_MEMBERSHIP, size_is=lambda pkt: pkt.GroupCount
            )
        ),
        NDRIntField("UserFlags", 0),
        NDRPacketField("UserSessionKey", USER_SESSION_KEY(), USER_SESSION_KEY),
        NDRPacketField("LogonServer", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("LogonDomainName", UNICODE_STRING(), UNICODE_STRING),
        NDRFullEmbPointerField(NDRPacketField("LogonDomainId", PRPC_SID(), PRPC_SID)),
        StrFixedLenField("LMKey", "", length=8),
        NDRIntField("UserAccountControl", 0),
        NDRIntField("SubAuthStatus", 0),
        NDRPacketField("LastSuccessfulILogon", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("LastFailedILogon", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRIntField("FailedILogonCount", 0),
        NDRFieldListField(
            "Reserved4", [0] * 1, NDRIntField("", 0), length_is=lambda _: 1
        ),
        NDRIntField("SidCount", None, size_of="ExtraSids"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "ExtraSids",
                [],
                PNETLOGON_SID_AND_ATTRIBUTES,
                size_is=lambda pkt: pkt.SidCount,
            )
        ),
        NDRPacketField("DnsLogonDomainName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("Upn", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ExpansionString1", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ExpansionString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ExpansionString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ExpansionString4", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ExpansionString5", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ExpansionString6", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ExpansionString7", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ExpansionString8", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ExpansionString9", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ExpansionString10", UNICODE_STRING(), UNICODE_STRING),
    ]


class PNETLOGON_VALIDATION_TICKET_LOGON(NDRPacket):
    ALIGNMENT = (8, 8)
    fields_desc = [
        NDRLongField("Results", 0),
        NDRSignedIntField("KerberosStatus", 0),
        NDRSignedIntField("NetlogonStatus", 0),
        NDRPacketField("SourceOfStatus", UNICODE_STRING(), UNICODE_STRING),
        NDRFullEmbPointerField(
            NDRPacketField(
                "UserInformation",
                PNETLOGON_VALIDATION_SAM_INFO4(),
                PNETLOGON_VALIDATION_SAM_INFO4,
            )
        ),
        NDRFullEmbPointerField(
            NDRPacketField(
                "DeviceInformation",
                PNETLOGON_VALIDATION_SAM_INFO4(),
                PNETLOGON_VALIDATION_SAM_INFO4,
            )
        ),
        NDRIntField("UserClaimsLength", None, size_of="UserClaims"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "UserClaims", "", size_is=lambda pkt: pkt.UserClaimsLength
            )
        ),
        NDRIntField("DeviceClaimsLength", None, size_of="DeviceClaims"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "DeviceClaims", "", size_is=lambda pkt: pkt.DeviceClaimsLength
            )
        ),
    ]


class NetrLogonSamLogon_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("LogonServer", "")),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ComputerName", "")),
        NDRFullPointerField(
            NDRPacketField(
                "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
            )
        ),
        NDRFullPointerField(
            NDRPacketField(
                "ReturnAuthenticator",
                PNETLOGON_AUTHENTICATOR(),
                PNETLOGON_AUTHENTICATOR,
            )
        ),
        NDRInt3264EnumField("LogonLevel", 0, NETLOGON_LOGON_INFO_CLASS),
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_INTERACTIVE_INFO(),
                            PNETLOGON_INTERACTIVE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_INTERACTIVE_INFO(),
                            PNETLOGON_INTERACTIVE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveTransitiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveTransitiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_SERVICE_INFO(),
                            PNETLOGON_SERVICE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_SERVICE_INFO(),
                            PNETLOGON_SERVICE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceTransitiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceTransitiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_NETWORK_INFO(),
                            PNETLOGON_NETWORK_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_NETWORK_INFO(),
                            PNETLOGON_NETWORK_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkTransitiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkTransitiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_GENERIC_INFO(),
                            PNETLOGON_GENERIC_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonGenericInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonGenericInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_TICKET_LOGON_INFO(),
                            PNETLOGON_TICKET_LOGON_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonTicketLogonInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonTicketLogonInformation
                        ),
                    ),
                ),
            ],
            StrFixedLenField("LogonInformation", "", length=0),
            align=(2, 8),
            switch_fmt=("H", "I"),
        ),
        NDRInt3264EnumField("ValidationLevel", 0, NETLOGON_VALIDATION_INFO_CLASS),
    ]


class NetrLogonSamLogon_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(
            NDRPacketField(
                "ReturnAuthenticator",
                PNETLOGON_AUTHENTICATOR(),
                PNETLOGON_AUTHENTICATOR,
            )
        ),
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_SAM_INFO(),
                            PNETLOGON_VALIDATION_SAM_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_SAM_INFO2(),
                            PNETLOGON_VALIDATION_SAM_INFO2,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo2
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo2
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_GENERIC_INFO2(),
                            PNETLOGON_VALIDATION_GENERIC_INFO2,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationGenericInfo2
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationGenericInfo2
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_SAM_INFO4(),
                            PNETLOGON_VALIDATION_SAM_INFO4,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo4
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo4
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_TICKET_LOGON(),
                            PNETLOGON_VALIDATION_TICKET_LOGON,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationTicketLogon
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationTicketLogon
                        ),
                    ),
                ),
            ],
            StrFixedLenField("ValidationInformation", "", length=0),
            align=(2, 8),
            switch_fmt=("H", "I"),
        ),
        NDRByteField("Authoritative", 0),
        NDRIntField("status", 0),
    ]


class NetrLogonSamLogoff_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("LogonServer", "")),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ComputerName", "")),
        NDRFullPointerField(
            NDRPacketField(
                "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
            )
        ),
        NDRFullPointerField(
            NDRPacketField(
                "ReturnAuthenticator",
                PNETLOGON_AUTHENTICATOR(),
                PNETLOGON_AUTHENTICATOR,
            )
        ),
        NDRInt3264EnumField("LogonLevel", 0, NETLOGON_LOGON_INFO_CLASS),
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_INTERACTIVE_INFO(),
                            PNETLOGON_INTERACTIVE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_INTERACTIVE_INFO(),
                            PNETLOGON_INTERACTIVE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveTransitiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveTransitiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_SERVICE_INFO(),
                            PNETLOGON_SERVICE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_SERVICE_INFO(),
                            PNETLOGON_SERVICE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceTransitiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceTransitiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_NETWORK_INFO(),
                            PNETLOGON_NETWORK_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_NETWORK_INFO(),
                            PNETLOGON_NETWORK_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkTransitiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkTransitiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_GENERIC_INFO(),
                            PNETLOGON_GENERIC_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonGenericInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonGenericInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_TICKET_LOGON_INFO(),
                            PNETLOGON_TICKET_LOGON_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonTicketLogonInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonTicketLogonInformation
                        ),
                    ),
                ),
            ],
            StrFixedLenField("LogonInformation", "", length=0),
            align=(2, 8),
            switch_fmt=("H", "I"),
        ),
    ]


class NetrLogonSamLogoff_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(
            NDRPacketField(
                "ReturnAuthenticator",
                PNETLOGON_AUTHENTICATOR(),
                PNETLOGON_AUTHENTICATOR,
            )
        ),
        NDRIntField("status", 0),
    ]


class PNETLOGON_CREDENTIAL(NDRPacket):
    fields_desc = [StrFixedLenField("data", "", length=8)]


class NetrServerReqChallenge_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("PrimaryName", "")),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField("ClientChallenge", PNETLOGON_CREDENTIAL(), PNETLOGON_CREDENTIAL),
    ]


class NetrServerReqChallenge_Response(NDRPacket):
    fields_desc = [
        NDRPacketField("ServerChallenge", PNETLOGON_CREDENTIAL(), PNETLOGON_CREDENTIAL),
        NDRIntField("status", 0),
    ]


class NETLOGON_SECURE_CHANNEL_TYPE(IntEnum):
    NullSecureChannel = 0
    MsvApSecureChannel = 1
    WorkstationSecureChannel = 2
    TrustedDnsDomainSecureChannel = 3
    TrustedDomainSecureChannel = 4
    UasServerSecureChannel = 5
    ServerSecureChannel = 6
    CdcServerSecureChannel = 7


class NetrServerAuthenticate_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("PrimaryName", "")),
        NDRConfVarStrNullFieldUtf16("AccountName", ""),
        NDRInt3264EnumField("SecureChannelType", 0, NETLOGON_SECURE_CHANNEL_TYPE),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "ClientCredential", PNETLOGON_CREDENTIAL(), PNETLOGON_CREDENTIAL
        ),
    ]


class NetrServerAuthenticate_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ServerCredential", PNETLOGON_CREDENTIAL(), PNETLOGON_CREDENTIAL
        ),
        NDRIntField("status", 0),
    ]


class PENCRYPTED_NT_OWF_PASSWORD(NDRPacket):
    fields_desc = [
        PacketListField(
            "data", [CYPHER_BLOCK()] * 2, CYPHER_BLOCK, count_from=lambda _: 2
        )
    ]


class NetrServerPasswordSet_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("PrimaryName", "")),
        NDRConfVarStrNullFieldUtf16("AccountName", ""),
        NDRInt3264EnumField("SecureChannelType", 0, NETLOGON_SECURE_CHANNEL_TYPE),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField(
            "UasNewPassword", PENCRYPTED_NT_OWF_PASSWORD(), PENCRYPTED_NT_OWF_PASSWORD
        ),
    ]


class NetrServerPasswordSet_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRIntField("status", 0),
    ]


class PNLPR_MODIFIED_COUNT(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [
        NDRPacketField("ModifiedCount", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER)
    ]


class NETLOGON_DELTA_TYPE(IntEnum):
    AddOrChangeDomain = 1
    AddOrChangeGroup = 2
    DeleteGroup = 3
    RenameGroup = 4
    AddOrChangeUser = 5
    DeleteUser = 6
    RenameUser = 7
    ChangeGroupMembership = 8
    AddOrChangeAlias = 9
    DeleteAlias = 10
    RenameAlias = 11
    ChangeAliasMembership = 12
    AddOrChangeLsaPolicy = 13
    AddOrChangeLsaTDomain = 14
    DeleteLsaTDomain = 15
    AddOrChangeLsaAccount = 16
    DeleteLsaAccount = 17
    AddOrChangeLsaSecret = 18
    DeleteLsaSecret = 19
    DeleteGroupByName = 20
    DeleteUserByName = 21
    SerialNumberSkip = 22


class PNETLOGON_DELTA_DOMAIN(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("DomainName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("OemInformation", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ForceLogoff", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRShortField("MinPasswordLength", 0),
        NDRShortField("PasswordHistoryLength", 0),
        NDRPacketField("MaxPasswordAge", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("MinPasswordAge", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("DomainModifiedCount", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("DomainCreationTime", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRIntField("SecurityInformation", 0),
        NDRIntField("SecuritySize", None, size_of="SecurityDescriptor"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "SecurityDescriptor", "", size_is=lambda pkt: pkt.SecuritySize
            )
        ),
        NDRPacketField("DomainLockoutInformation", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("PasswordProperties", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PNETLOGON_DELTA_GROUP(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("Name", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("RelativeId", 0),
        NDRIntField("Attributes", 0),
        NDRPacketField("AdminComment", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("SecurityInformation", 0),
        NDRIntField("SecuritySize", None, size_of="SecurityDescriptor"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "SecurityDescriptor", "", size_is=lambda pkt: pkt.SecuritySize
            )
        ),
        NDRPacketField("DummyString1", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PNETLOGON_DELTA_RENAME_GROUP(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("OldName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("NewName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString1", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class NLPR_LOGON_HOURS(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRShortField(
            "UnitsPerWeek",
            None,
            size_of="LogonHours",
            adjust=lambda _, x: ((x * 8) - 7),
        ),
        NDRFullEmbPointerField(
            NDRConfVarStrLenField(
                "LogonHours",
                "",
                size_is=lambda pkt: 1260,
                length_is=lambda pkt: ((pkt.UnitsPerWeek + 7) // 8),
            )
        ),
    ]


class ENCRYPTED_NT_OWF_PASSWORD(NDRPacket):
    fields_desc = [
        PacketListField(
            "data", [CYPHER_BLOCK()] * 2, CYPHER_BLOCK, count_from=lambda _: 2
        )
    ]


class ENCRYPTED_LM_OWF_PASSWORD(NDRPacket):
    fields_desc = [
        PacketListField(
            "data", [CYPHER_BLOCK()] * 2, CYPHER_BLOCK, count_from=lambda _: 2
        )
    ]


class NLPR_USER_PRIVATE_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRByteField("SensitiveData", 0),
        NDRIntField("DataLength", None, size_of="Data"),
        NDRFullEmbPointerField(
            NDRConfStrLenField("Data", "", size_is=lambda pkt: pkt.DataLength)
        ),
    ]


class PNETLOGON_DELTA_USER(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("UserName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("FullName", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("UserId", 0),
        NDRIntField("PrimaryGroupId", 0),
        NDRPacketField("HomeDirectory", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("HomeDirectoryDrive", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("ScriptPath", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("AdminComment", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("WorkStations", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("LastLogon", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("LastLogoff", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("LogonHours", NLPR_LOGON_HOURS(), NLPR_LOGON_HOURS),
        NDRShortField("BadPasswordCount", 0),
        NDRShortField("LogonCount", 0),
        NDRPacketField("PasswordLastSet", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("AccountExpires", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRIntField("UserAccountControl", 0),
        NDRPacketField(
            "EncryptedNtOwfPassword",
            ENCRYPTED_NT_OWF_PASSWORD(),
            ENCRYPTED_NT_OWF_PASSWORD,
        ),
        NDRPacketField(
            "EncryptedLmOwfPassword",
            ENCRYPTED_LM_OWF_PASSWORD(),
            ENCRYPTED_LM_OWF_PASSWORD,
        ),
        NDRByteField("NtPasswordPresent", 0),
        NDRByteField("LmPasswordPresent", 0),
        NDRByteField("PasswordExpired", 0),
        NDRPacketField("UserComment", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("Parameters", UNICODE_STRING(), UNICODE_STRING),
        NDRShortField("CountryCode", 0),
        NDRShortField("CodePage", 0),
        NDRPacketField("PrivateData", NLPR_USER_PRIVATE_INFO(), NLPR_USER_PRIVATE_INFO),
        NDRIntField("SecurityInformation", 0),
        NDRIntField("SecuritySize", None, size_of="SecurityDescriptor"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "SecurityDescriptor", "", size_is=lambda pkt: pkt.SecuritySize
            )
        ),
        NDRPacketField("ProfilePath", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PNETLOGON_DELTA_RENAME_USER(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("OldName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("NewName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString1", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PNETLOGON_DELTA_GROUP_MEMBER(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(
            NDRConfFieldListField(
                "Members", [], NDRIntField("", 0), size_is=lambda pkt: pkt.MemberCount
            )
        ),
        NDRFullEmbPointerField(
            NDRConfFieldListField(
                "Attributes",
                [],
                NDRIntField("", 0),
                size_is=lambda pkt: pkt.MemberCount,
            )
        ),
        NDRIntField("MemberCount", None, size_of="Attributes"),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PNETLOGON_DELTA_ALIAS(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("Name", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("RelativeId", 0),
        NDRIntField("SecurityInformation", 0),
        NDRIntField("SecuritySize", None, size_of="SecurityDescriptor"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "SecurityDescriptor", "", size_is=lambda pkt: pkt.SecuritySize
            )
        ),
        NDRPacketField("Comment", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PNETLOGON_DELTA_RENAME_ALIAS(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("OldName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("NewName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString1", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PNLPR_SID_INFORMATION(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRPacketField("SidPointer", PRPC_SID(), PRPC_SID))
    ]


class NLPR_SID_ARRAY(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("Count", None, size_of="Sids"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "Sids", [], PNLPR_SID_INFORMATION, size_is=lambda pkt: pkt.Count
            )
        ),
    ]


class PNETLOGON_DELTA_ALIAS_MEMBER(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("Members", NLPR_SID_ARRAY(), NLPR_SID_ARRAY),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class NLPR_QUOTA_LIMITS(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [
        NDRIntField("PagedPoolLimit", 0),
        NDRIntField("NonPagedPoolLimit", 0),
        NDRIntField("MinimumWorkingSetSize", 0),
        NDRIntField("MaximumWorkingSetSize", 0),
        NDRIntField("PagefileLimit", 0),
        NDRPacketField("Reserved", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
    ]


class PNETLOGON_DELTA_POLICY(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("MaximumLogSize", 0),
        NDRPacketField("AuditRetentionPeriod", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRByteField("AuditingMode", 0),
        NDRIntField(
            "MaximumAuditEventCount",
            None,
            size_of="EventAuditingOptions",
            adjust=lambda _, x: (x - 1),
        ),
        NDRFullEmbPointerField(
            NDRConfFieldListField(
                "EventAuditingOptions",
                [],
                NDRIntField("", 0),
                size_is=lambda pkt: (pkt.MaximumAuditEventCount + 1),
            )
        ),
        NDRPacketField("PrimaryDomainName", UNICODE_STRING(), UNICODE_STRING),
        NDRFullEmbPointerField(
            NDRPacketField("PrimaryDomainSid", PRPC_SID(), PRPC_SID)
        ),
        NDRPacketField("QuotaLimits", NLPR_QUOTA_LIMITS(), NLPR_QUOTA_LIMITS),
        NDRPacketField("ModifiedId", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("DatabaseCreationTime", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRIntField("SecurityInformation", 0),
        NDRIntField("SecuritySize", None, size_of="SecurityDescriptor"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "SecurityDescriptor", "", size_is=lambda pkt: pkt.SecuritySize
            )
        ),
        NDRPacketField("DummyString1", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PUNICODE_STRING(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRShortField("Length", None, size_of="Buffer", adjust=lambda _, x: (x * 2)),
        NDRShortField(
            "MaximumLength", None, size_of="Buffer", adjust=lambda _, x: (x * 2)
        ),
        NDRFullEmbPointerField(
            NDRConfVarStrLenFieldUtf16(
                "Buffer",
                "",
                size_is=lambda pkt: (pkt.MaximumLength // 2),
                length_is=lambda pkt: (pkt.Length // 2),
            )
        ),
    ]


class PNETLOGON_DELTA_TRUSTED_DOMAINS(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("DomainName", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("NumControllerEntries", None, size_of="ControllerNames"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "ControllerNames",
                [],
                PUNICODE_STRING,
                size_is=lambda pkt: pkt.NumControllerEntries,
            )
        ),
        NDRIntField("SecurityInformation", 0),
        NDRIntField("SecuritySize", None, size_of="SecurityDescriptor"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "SecurityDescriptor", "", size_is=lambda pkt: pkt.SecuritySize
            )
        ),
        NDRPacketField("DummyString1", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("TrustedPosixOffset", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PNETLOGON_DELTA_ACCOUNTS(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("PrivilegeEntries", None, size_of="PrivilegeNames"),
        NDRIntField("PrivilegeControl", 0),
        NDRFullEmbPointerField(
            NDRConfFieldListField(
                "PrivilegeAttributes",
                [],
                NDRIntField("", 0),
                size_is=lambda pkt: pkt.PrivilegeEntries,
            )
        ),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "PrivilegeNames",
                [],
                PUNICODE_STRING,
                size_is=lambda pkt: pkt.PrivilegeEntries,
            )
        ),
        NDRPacketField("QuotaLimits", NLPR_QUOTA_LIMITS(), NLPR_QUOTA_LIMITS),
        NDRIntField("SystemAccessFlags", 0),
        NDRIntField("SecurityInformation", 0),
        NDRIntField("SecuritySize", None, size_of="SecurityDescriptor"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "SecurityDescriptor", "", size_is=lambda pkt: pkt.SecuritySize
            )
        ),
        NDRPacketField("DummyString1", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class NLPR_CR_CIPHER_VALUE(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("Length", None, size_of="Buffer"),
        NDRIntField("MaximumLength", None, size_of="Buffer"),
        NDRFullEmbPointerField(
            NDRConfVarStrLenField(
                "Buffer",
                "",
                size_is=lambda pkt: pkt.MaximumLength,
                length_is=lambda pkt: pkt.Length,
            )
        ),
    ]


class PNETLOGON_DELTA_SECRET(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("CurrentValue", NLPR_CR_CIPHER_VALUE(), NLPR_CR_CIPHER_VALUE),
        NDRPacketField("CurrentValueSetTime", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRPacketField("OldValue", NLPR_CR_CIPHER_VALUE(), NLPR_CR_CIPHER_VALUE),
        NDRPacketField("OldValueSetTime", OLD_LARGE_INTEGER(), OLD_LARGE_INTEGER),
        NDRIntField("SecurityInformation", 0),
        NDRIntField("SecuritySize", None, size_of="SecurityDescriptor"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "SecurityDescriptor", "", size_is=lambda pkt: pkt.SecuritySize
            )
        ),
        NDRPacketField("DummyString1", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PNETLOGON_DELTA_DELETE_GROUP(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("AccountName", "")),
        NDRPacketField("DummyString1", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PNETLOGON_DELTA_DELETE_USER(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("AccountName", "")),
        NDRPacketField("DummyString1", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PNETLOGON_DELTA_ENUM(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRInt3264EnumField("DeltaType", 0, NETLOGON_DELTA_TYPE),
        NDRUnionField(
            [
                (
                    NDRIntField("DeltaID", 0),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            in [
                                NETLOGON_DELTA_TYPE.AddOrChangeDomain,
                                NETLOGON_DELTA_TYPE.AddOrChangeGroup,
                                NETLOGON_DELTA_TYPE.DeleteGroup,
                                NETLOGON_DELTA_TYPE.RenameGroup,
                                NETLOGON_DELTA_TYPE.AddOrChangeUser,
                                NETLOGON_DELTA_TYPE.DeleteUser,
                                NETLOGON_DELTA_TYPE.RenameUser,
                                NETLOGON_DELTA_TYPE.ChangeGroupMembership,
                                NETLOGON_DELTA_TYPE.AddOrChangeAlias,
                                NETLOGON_DELTA_TYPE.DeleteAlias,
                                NETLOGON_DELTA_TYPE.RenameAlias,
                                NETLOGON_DELTA_TYPE.ChangeAliasMembership,
                                NETLOGON_DELTA_TYPE.DeleteGroupByName,
                                NETLOGON_DELTA_TYPE.DeleteUserByName,
                            ]
                        ),
                        (
                            lambda _, val: val.tag
                            in [
                                NETLOGON_DELTA_TYPE.AddOrChangeDomain,
                                NETLOGON_DELTA_TYPE.AddOrChangeGroup,
                                NETLOGON_DELTA_TYPE.DeleteGroup,
                                NETLOGON_DELTA_TYPE.RenameGroup,
                                NETLOGON_DELTA_TYPE.AddOrChangeUser,
                                NETLOGON_DELTA_TYPE.DeleteUser,
                                NETLOGON_DELTA_TYPE.RenameUser,
                                NETLOGON_DELTA_TYPE.ChangeGroupMembership,
                                NETLOGON_DELTA_TYPE.AddOrChangeAlias,
                                NETLOGON_DELTA_TYPE.DeleteAlias,
                                NETLOGON_DELTA_TYPE.RenameAlias,
                                NETLOGON_DELTA_TYPE.ChangeAliasMembership,
                                NETLOGON_DELTA_TYPE.DeleteGroupByName,
                                NETLOGON_DELTA_TYPE.DeleteUserByName,
                            ]
                        ),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField("DeltaID", PRPC_SID(), PRPC_SID)
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            in [
                                NETLOGON_DELTA_TYPE.AddOrChangeLsaPolicy,
                                NETLOGON_DELTA_TYPE.AddOrChangeLsaTDomain,
                                NETLOGON_DELTA_TYPE.DeleteLsaTDomain,
                                NETLOGON_DELTA_TYPE.AddOrChangeLsaAccount,
                                NETLOGON_DELTA_TYPE.DeleteLsaAccount,
                            ]
                        ),
                        (
                            lambda _, val: val.tag
                            in [
                                NETLOGON_DELTA_TYPE.AddOrChangeLsaPolicy,
                                NETLOGON_DELTA_TYPE.AddOrChangeLsaTDomain,
                                NETLOGON_DELTA_TYPE.DeleteLsaTDomain,
                                NETLOGON_DELTA_TYPE.AddOrChangeLsaAccount,
                                NETLOGON_DELTA_TYPE.DeleteLsaAccount,
                            ]
                        ),
                    ),
                ),
                (
                    NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("DeltaID", "")),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            in [
                                NETLOGON_DELTA_TYPE.AddOrChangeLsaSecret,
                                NETLOGON_DELTA_TYPE.DeleteLsaSecret,
                            ]
                        ),
                        (
                            lambda _, val: val.tag
                            in [
                                NETLOGON_DELTA_TYPE.AddOrChangeLsaSecret,
                                NETLOGON_DELTA_TYPE.DeleteLsaSecret,
                            ]
                        ),
                    ),
                ),
            ],
            StrFixedLenField("DeltaID", "", length=0),
            align=(2, 8),
            switch_fmt=("H", "I"),
        ),
        NDRUnionField(
            [
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion",
                            PNETLOGON_DELTA_DOMAIN(),
                            PNETLOGON_DELTA_DOMAIN,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.AddOrChangeDomain
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_DELTA_TYPE.AddOrChangeDomain
                        ),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion", PNETLOGON_DELTA_GROUP(), PNETLOGON_DELTA_GROUP
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.AddOrChangeGroup
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_DELTA_TYPE.AddOrChangeGroup
                        ),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion",
                            PNETLOGON_DELTA_RENAME_GROUP(),
                            PNETLOGON_DELTA_RENAME_GROUP,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.RenameGroup
                        ),
                        (lambda _, val: val.tag == NETLOGON_DELTA_TYPE.RenameGroup),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion", PNETLOGON_DELTA_USER(), PNETLOGON_DELTA_USER
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.AddOrChangeUser
                        ),
                        (lambda _, val: val.tag == NETLOGON_DELTA_TYPE.AddOrChangeUser),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion",
                            PNETLOGON_DELTA_RENAME_USER(),
                            PNETLOGON_DELTA_RENAME_USER,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.RenameUser
                        ),
                        (lambda _, val: val.tag == NETLOGON_DELTA_TYPE.RenameUser),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion",
                            PNETLOGON_DELTA_GROUP_MEMBER(),
                            PNETLOGON_DELTA_GROUP_MEMBER,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.ChangeGroupMembership
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_DELTA_TYPE.ChangeGroupMembership
                        ),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion", PNETLOGON_DELTA_ALIAS(), PNETLOGON_DELTA_ALIAS
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.AddOrChangeAlias
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_DELTA_TYPE.AddOrChangeAlias
                        ),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion",
                            PNETLOGON_DELTA_RENAME_ALIAS(),
                            PNETLOGON_DELTA_RENAME_ALIAS,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.RenameAlias
                        ),
                        (lambda _, val: val.tag == NETLOGON_DELTA_TYPE.RenameAlias),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion",
                            PNETLOGON_DELTA_ALIAS_MEMBER(),
                            PNETLOGON_DELTA_ALIAS_MEMBER,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.ChangeAliasMembership
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_DELTA_TYPE.ChangeAliasMembership
                        ),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion",
                            PNETLOGON_DELTA_POLICY(),
                            PNETLOGON_DELTA_POLICY,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.AddOrChangeLsaPolicy
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_DELTA_TYPE.AddOrChangeLsaPolicy
                        ),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion",
                            PNETLOGON_DELTA_TRUSTED_DOMAINS(),
                            PNETLOGON_DELTA_TRUSTED_DOMAINS,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.AddOrChangeLsaTDomain
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_DELTA_TYPE.AddOrChangeLsaTDomain
                        ),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion",
                            PNETLOGON_DELTA_ACCOUNTS(),
                            PNETLOGON_DELTA_ACCOUNTS,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.AddOrChangeLsaAccount
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_DELTA_TYPE.AddOrChangeLsaAccount
                        ),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion",
                            PNETLOGON_DELTA_SECRET(),
                            PNETLOGON_DELTA_SECRET,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.AddOrChangeLsaSecret
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_DELTA_TYPE.AddOrChangeLsaSecret
                        ),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion",
                            PNETLOGON_DELTA_DELETE_GROUP(),
                            PNETLOGON_DELTA_DELETE_GROUP,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.DeleteGroupByName
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_DELTA_TYPE.DeleteGroupByName
                        ),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion",
                            PNETLOGON_DELTA_DELETE_USER(),
                            PNETLOGON_DELTA_DELETE_USER,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.DeleteUserByName
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_DELTA_TYPE.DeleteUserByName
                        ),
                    ),
                ),
                (
                    NDRFullEmbPointerField(
                        NDRPacketField(
                            "DeltaUnion", PNLPR_MODIFIED_COUNT(), PNLPR_MODIFIED_COUNT
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "DeltaType", None)
                            == NETLOGON_DELTA_TYPE.SerialNumberSkip
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_DELTA_TYPE.SerialNumberSkip
                        ),
                    ),
                ),
            ],
            StrFixedLenField("DeltaUnion", "", length=0),
            align=(2, 8),
            switch_fmt=("H", "I"),
        ),
    ]


class PNETLOGON_DELTA_ENUM_ARRAY(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("CountReturned", None, size_of="Deltas"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "Deltas",
                [],
                PNETLOGON_DELTA_ENUM,
                size_is=lambda pkt: pkt.CountReturned,
            )
        ),
    ]


class NetrDatabaseDeltas_Request(NDRPacket):
    fields_desc = [
        NDRConfVarStrNullFieldUtf16("PrimaryName", ""),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRIntField("DatabaseID", 0),
        NDRPacketField(
            "DomainModifiedCount", PNLPR_MODIFIED_COUNT(), PNLPR_MODIFIED_COUNT
        ),
        NDRIntField("PreferredMaximumLength", 0),
    ]


class NetrDatabaseDeltas_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField(
            "DomainModifiedCount", PNLPR_MODIFIED_COUNT(), PNLPR_MODIFIED_COUNT
        ),
        NDRFullPointerField(
            NDRPacketField(
                "DeltaArray", PNETLOGON_DELTA_ENUM_ARRAY(), PNETLOGON_DELTA_ENUM_ARRAY
            )
        ),
        NDRIntField("status", 0),
    ]


class NetrDatabaseSync_Request(NDRPacket):
    fields_desc = [
        NDRConfVarStrNullFieldUtf16("PrimaryName", ""),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRIntField("DatabaseID", 0),
        NDRIntField("SyncContext", 0),
        NDRIntField("PreferredMaximumLength", 0),
    ]


class NetrDatabaseSync_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRIntField("SyncContext", 0),
        NDRFullPointerField(
            NDRPacketField(
                "DeltaArray", PNETLOGON_DELTA_ENUM_ARRAY(), PNETLOGON_DELTA_ENUM_ARRAY
            )
        ),
        NDRIntField("status", 0),
    ]


class PUAS_INFO_0(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [
        StrFixedLenField("ComputerName", "", length=16),
        NDRIntField("TimeCreated", 0),
        NDRIntField("SerialNumber", 0),
    ]


class NetrAccountDeltas_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("PrimaryName", "")),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField("RecordId", PUAS_INFO_0(), PUAS_INFO_0),
        NDRIntField("Count", 0),
        NDRIntField("Level", 0),
        NDRIntField("BufferSize", 0),
    ]


class NetrAccountDeltas_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRConfStrLenField("Buffer", "", size_is=lambda pkt: pkt.BufferSize),
        NDRIntField("CountReturned", 0),
        NDRIntField("TotalEntries", 0),
        NDRPacketField("NextRecordId", PUAS_INFO_0(), PUAS_INFO_0),
        NDRIntField("status", 0),
    ]


class NetrAccountSync_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("PrimaryName", "")),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRIntField("Reference", 0),
        NDRIntField("Level", 0),
        NDRIntField("BufferSize", 0),
    ]


class NetrAccountSync_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRConfStrLenField("Buffer", "", size_is=lambda pkt: pkt.BufferSize),
        NDRIntField("CountReturned", 0),
        NDRIntField("TotalEntries", 0),
        NDRIntField("NextReference", 0),
        NDRPacketField("LastRecordId", PUAS_INFO_0(), PUAS_INFO_0),
        NDRIntField("status", 0),
    ]


class NetrGetDCName_Request(NDRPacket):
    fields_desc = [
        NDRConfVarStrNullFieldUtf16("ServerName", ""),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("DomainName", "")),
    ]


class NetrGetDCName_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("Buffer", "")),
        NDRIntField("status", 0),
    ]


class PNETLOGON_INFO_1(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [
        NDRIntField("netlog1_flags", 0),
        NDRIntField("netlog1_pdc_connection_status", 0),
    ]


class PNETLOGON_INFO_2(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("netlog2_flags", 0),
        NDRIntField("netlog2_pdc_connection_status", 0),
        NDRFullEmbPointerField(
            NDRConfVarStrNullFieldUtf16("netlog2_trusted_dc_name", "")
        ),
        NDRIntField("netlog2_tc_connection_status", 0),
    ]


class PNETLOGON_INFO_3(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [
        NDRIntField("netlog3_flags", 0),
        NDRIntField("netlog3_logon_attempts", 0),
        NDRIntField("netlog3_reserved1", 0),
        NDRIntField("netlog3_reserved2", 0),
        NDRIntField("netlog3_reserved3", 0),
        NDRIntField("netlog3_reserved4", 0),
        NDRIntField("netlog3_reserved5", 0),
    ]


class PNETLOGON_INFO_4(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(
            NDRConfVarStrNullFieldUtf16("netlog4_trusted_dc_name", "")
        ),
        NDRFullEmbPointerField(
            NDRConfVarStrNullFieldUtf16("netlog4_trusted_domain_name", "")
        ),
    ]


class NetrLogonControl_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRIntField("FunctionCode", 0),
        NDRIntField("QueryLevel", 0),
    ]


class NetrLogonControl_Response(NDRPacket):
    fields_desc = [
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField("Buffer", PNETLOGON_INFO_1(), PNETLOGON_INFO_1)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "QueryLevel", None) == 1),
                        (lambda _, val: val.tag == 1),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField("Buffer", PNETLOGON_INFO_2(), PNETLOGON_INFO_2)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "QueryLevel", None) == 2),
                        (lambda _, val: val.tag == 2),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField("Buffer", PNETLOGON_INFO_3(), PNETLOGON_INFO_3)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "QueryLevel", None) == 3),
                        (lambda _, val: val.tag == 3),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField("Buffer", PNETLOGON_INFO_4(), PNETLOGON_INFO_4)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "QueryLevel", None) == 4),
                        (lambda _, val: val.tag == 4),
                    ),
                ),
            ],
            StrFixedLenField("Buffer", "", length=0),
            align=(4, 8),
            switch_fmt=("L", "L"),
        ),
        NDRIntField("status", 0),
    ]


class NetrGetAnyDCName_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("DomainName", "")),
    ]


class NetrGetAnyDCName_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("Buffer", "")),
        NDRIntField("status", 0),
    ]


class NetrLogonControl2_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRIntField("FunctionCode", 0),
        NDRIntField("QueryLevel", 0),
        NDRUnionField(
            [
                (
                    NDRFullPointerField(NDRConfVarStrNullFieldUtf16("Data", "")),
                    (
                        (
                            lambda pkt: getattr(pkt, "FunctionCode", None)
                            in [5, 6, 9, 10]
                        ),
                        (lambda _, val: val.tag in [5, 6, 9, 10]),
                    ),
                ),
                (
                    NDRIntField("Data", 0),
                    (
                        (lambda pkt: getattr(pkt, "FunctionCode", None) == 65534),
                        (lambda _, val: val.tag == 65534),
                    ),
                ),
                (
                    NDRFullPointerField(NDRConfVarStrNullFieldUtf16("Data", "")),
                    (
                        (lambda pkt: getattr(pkt, "FunctionCode", None) == 8),
                        (lambda _, val: val.tag == 8),
                    ),
                ),
            ],
            StrFixedLenField("Data", "", length=0),
            align=(4, 8),
            switch_fmt=("L", "L"),
        ),
    ]


class NetrLogonControl2_Response(NDRPacket):
    fields_desc = [
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField("Buffer", PNETLOGON_INFO_1(), PNETLOGON_INFO_1)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "QueryLevel", None) == 1),
                        (lambda _, val: val.tag == 1),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField("Buffer", PNETLOGON_INFO_2(), PNETLOGON_INFO_2)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "QueryLevel", None) == 2),
                        (lambda _, val: val.tag == 2),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField("Buffer", PNETLOGON_INFO_3(), PNETLOGON_INFO_3)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "QueryLevel", None) == 3),
                        (lambda _, val: val.tag == 3),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField("Buffer", PNETLOGON_INFO_4(), PNETLOGON_INFO_4)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "QueryLevel", None) == 4),
                        (lambda _, val: val.tag == 4),
                    ),
                ),
            ],
            StrFixedLenField("Buffer", "", length=0),
            align=(4, 8),
            switch_fmt=("L", "L"),
        ),
        NDRIntField("status", 0),
    ]


class NetrServerAuthenticate2_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("PrimaryName", "")),
        NDRConfVarStrNullFieldUtf16("AccountName", ""),
        NDRInt3264EnumField("SecureChannelType", 0, NETLOGON_SECURE_CHANNEL_TYPE),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "ClientCredential", PNETLOGON_CREDENTIAL(), PNETLOGON_CREDENTIAL
        ),
        NDRIntField("NegotiateFlags", 0),
    ]


class NetrServerAuthenticate2_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ServerCredential", PNETLOGON_CREDENTIAL(), PNETLOGON_CREDENTIAL
        ),
        NDRIntField("NegotiateFlags", 0),
        NDRIntField("status", 0),
    ]


class SYNC_STATE(IntEnum):
    NormalState = 0
    DomainState = 1
    GroupState = 2
    UasBuiltInGroupState = 3
    UserState = 4
    GroupMemberState = 5
    AliasState = 6
    AliasMemberState = 7
    SamDoneState = 8


class NetrDatabaseSync2_Request(NDRPacket):
    fields_desc = [
        NDRConfVarStrNullFieldUtf16("PrimaryName", ""),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRIntField("DatabaseID", 0),
        NDRInt3264EnumField("RestartState", 0, SYNC_STATE),
        NDRIntField("SyncContext", 0),
        NDRIntField("PreferredMaximumLength", 0),
    ]


class NetrDatabaseSync2_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRIntField("SyncContext", 0),
        NDRFullPointerField(
            NDRPacketField(
                "DeltaArray", PNETLOGON_DELTA_ENUM_ARRAY(), PNETLOGON_DELTA_ENUM_ARRAY
            )
        ),
        NDRIntField("status", 0),
    ]


class NetrDatabaseRedo_Request(NDRPacket):
    fields_desc = [
        NDRConfVarStrNullFieldUtf16("PrimaryName", ""),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRConfStrLenField(
            "ChangeLogEntry", "", size_is=lambda pkt: pkt.ChangeLogEntrySize
        ),
        NDRIntField("ChangeLogEntrySize", None, size_of="ChangeLogEntry"),
    ]


class NetrDatabaseRedo_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRFullPointerField(
            NDRPacketField(
                "DeltaArray", PNETLOGON_DELTA_ENUM_ARRAY(), PNETLOGON_DELTA_ENUM_ARRAY
            )
        ),
        NDRIntField("status", 0),
    ]


class NetrLogonControl2Ex_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRIntField("FunctionCode", 0),
        NDRIntField("QueryLevel", 0),
        NDRUnionField(
            [
                (
                    NDRFullPointerField(NDRConfVarStrNullFieldUtf16("Data", "")),
                    (
                        (
                            lambda pkt: getattr(pkt, "FunctionCode", None)
                            in [5, 6, 9, 10]
                        ),
                        (lambda _, val: val.tag in [5, 6, 9, 10]),
                    ),
                ),
                (
                    NDRIntField("Data", 0),
                    (
                        (lambda pkt: getattr(pkt, "FunctionCode", None) == 65534),
                        (lambda _, val: val.tag == 65534),
                    ),
                ),
                (
                    NDRFullPointerField(NDRConfVarStrNullFieldUtf16("Data", "")),
                    (
                        (lambda pkt: getattr(pkt, "FunctionCode", None) == 8),
                        (lambda _, val: val.tag == 8),
                    ),
                ),
            ],
            StrFixedLenField("Data", "", length=0),
            align=(4, 8),
            switch_fmt=("L", "L"),
        ),
    ]


class NetrLogonControl2Ex_Response(NDRPacket):
    fields_desc = [
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField("Buffer", PNETLOGON_INFO_1(), PNETLOGON_INFO_1)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "QueryLevel", None) == 1),
                        (lambda _, val: val.tag == 1),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField("Buffer", PNETLOGON_INFO_2(), PNETLOGON_INFO_2)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "QueryLevel", None) == 2),
                        (lambda _, val: val.tag == 2),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField("Buffer", PNETLOGON_INFO_3(), PNETLOGON_INFO_3)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "QueryLevel", None) == 3),
                        (lambda _, val: val.tag == 3),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField("Buffer", PNETLOGON_INFO_4(), PNETLOGON_INFO_4)
                    ),
                    (
                        (lambda pkt: getattr(pkt, "QueryLevel", None) == 4),
                        (lambda _, val: val.tag == 4),
                    ),
                ),
            ],
            StrFixedLenField("Buffer", "", length=0),
            align=(4, 8),
            switch_fmt=("L", "L"),
        ),
        NDRIntField("status", 0),
    ]


class PDOMAIN_NAME_BUFFER(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("DomainNameByteCount", None, size_of="DomainNames"),
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "DomainNames", "", size_is=lambda pkt: pkt.DomainNameByteCount
            )
        ),
    ]


class NetrEnumerateTrustedDomains_Request(NDRPacket):
    fields_desc = [NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", ""))]


class NetrEnumerateTrustedDomains_Response(NDRPacket):
    fields_desc = [
        NDRPacketField("DomainNameBuffer", PDOMAIN_NAME_BUFFER(), PDOMAIN_NAME_BUFFER),
        NDRIntField("status", 0),
    ]


class GUID(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [
        NDRIntField("Data1", 0),
        NDRShortField("Data2", 0),
        NDRShortField("Data3", 0),
        StrFixedLenField("Data4", "", length=8),
    ]


class PDOMAIN_CONTROLLER_INFOW(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("DomainControllerName", "")),
        NDRFullEmbPointerField(
            NDRConfVarStrNullFieldUtf16("DomainControllerAddress", "")
        ),
        NDRIntField("DomainControllerAddressType", 0),
        NDRPacketField("DomainGuid", GUID(), GUID),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("DomainName", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("DnsForestName", "")),
        NDRIntField("Flags", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("DcSiteName", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("ClientSiteName", "")),
    ]


class DsrGetDcName_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ComputerName", "")),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("DomainName", "")),
        NDRFullPointerField(NDRPacketField("DomainGuid", GUID(), GUID)),
        NDRFullPointerField(NDRPacketField("SiteGuid", GUID(), GUID)),
        NDRIntField("Flags", 0),
    ]


class DsrGetDcName_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(
            NDRPacketField(
                "DomainControllerInfo",
                PDOMAIN_CONTROLLER_INFOW(),
                PDOMAIN_CONTROLLER_INFOW,
            )
        ),
        NDRIntField("status", 0),
    ]


class NetrLogonGetCapabilities_Request(NDRPacket):
    fields_desc = [
        NDRConfVarStrNullFieldUtf16("ServerName", ""),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ComputerName", "")),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRIntField("QueryLevel", 0),
    ]


class NetrLogonGetCapabilities_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRUnionField(
            [
                (
                    NDRIntField("Capabilities", 0),
                    (
                        (lambda pkt: getattr(pkt, "QueryLevel", None) == 1),
                        (lambda _, val: val.tag == 1),
                    ),
                ),
                (
                    NDRIntField("Capabilities", 0),
                    (
                        (lambda pkt: getattr(pkt, "QueryLevel", None) == 2),
                        (lambda _, val: val.tag == 2),
                    ),
                ),
            ],
            StrFixedLenField("Capabilities", "", length=0),
            align=(4, 4),
            switch_fmt=("L", "L"),
        ),
        NDRIntField("status", 0),
    ]


class NetrLogonSetServiceBits_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRIntField("ServiceBitsOfInterest", 0),
        NDRIntField("ServiceBits", 0),
    ]


class NetrLogonSetServiceBits_Response(NDRPacket):
    fields_desc = [NDRIntField("status", 0)]


class NetrLogonGetTrustRid_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("DomainName", "")),
    ]


class NetrLogonGetTrustRid_Response(NDRPacket):
    fields_desc = [NDRIntField("Rid", 0), NDRIntField("status", 0)]


class NetrLogonComputeServerDigest_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRIntField("Rid", 0),
        NDRConfStrLenField("Message", "", size_is=lambda pkt: pkt.MessageSize),
        NDRIntField("MessageSize", None, size_of="Message"),
    ]


class NetrLogonComputeServerDigest_Response(NDRPacket):
    fields_desc = [
        StrFixedLenField("NewMessageDigest", "", length=16),
        StrFixedLenField("OldMessageDigest", "", length=16),
        NDRIntField("status", 0),
    ]


class NetrLogonComputeClientDigest_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("DomainName", "")),
        NDRConfStrLenField("Message", "", size_is=lambda pkt: pkt.MessageSize),
        NDRIntField("MessageSize", None, size_of="Message"),
    ]


class NetrLogonComputeClientDigest_Response(NDRPacket):
    fields_desc = [
        StrFixedLenField("NewMessageDigest", "", length=16),
        StrFixedLenField("OldMessageDigest", "", length=16),
        NDRIntField("status", 0),
    ]


class NetrServerAuthenticate3_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("PrimaryName", "")),
        NDRConfVarStrNullFieldUtf16("AccountName", ""),
        NDRInt3264EnumField("SecureChannelType", 0, NETLOGON_SECURE_CHANNEL_TYPE),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "ClientCredential", PNETLOGON_CREDENTIAL(), PNETLOGON_CREDENTIAL
        ),
        NDRIntField("NegotiateFlags", 0),
    ]


class NetrServerAuthenticate3_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ServerCredential", PNETLOGON_CREDENTIAL(), PNETLOGON_CREDENTIAL
        ),
        NDRIntField("NegotiateFlags", 0),
        NDRIntField("AccountRid", 0),
        NDRIntField("status", 0),
    ]


class DsrGetDcNameEx_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ComputerName", "")),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("DomainName", "")),
        NDRFullPointerField(NDRPacketField("DomainGuid", GUID(), GUID)),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("SiteName", "")),
        NDRIntField("Flags", 0),
    ]


class DsrGetDcNameEx_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(
            NDRPacketField(
                "DomainControllerInfo",
                PDOMAIN_CONTROLLER_INFOW(),
                PDOMAIN_CONTROLLER_INFOW,
            )
        ),
        NDRIntField("status", 0),
    ]


class DsrGetSiteName_Request(NDRPacket):
    fields_desc = [NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ComputerName", ""))]


class DsrGetSiteName_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("SiteName", "")),
        NDRIntField("status", 0),
    ]


class NETLOGON_LSA_POLICY_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("LsaPolicySize", None, size_of="LsaPolicy"),
        NDRFullEmbPointerField(
            NDRConfStrLenField("LsaPolicy", "", size_is=lambda pkt: pkt.LsaPolicySize)
        ),
    ]


class PNETLOGON_WORKSTATION_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField(
            "LsaPolicy", NETLOGON_LSA_POLICY_INFO(), NETLOGON_LSA_POLICY_INFO
        ),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("DnsHostName", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("SiteName", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("Dummy1", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("Dummy2", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("Dummy3", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("Dummy4", "")),
        NDRPacketField("OsVersion", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("OsName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("WorkstationFlags", 0),
        NDRIntField("KerberosSupportedEncryptionTypes", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class NETLOGON_ONE_DOMAIN_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("DomainName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DnsDomainName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DnsForestName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DomainGuid", GUID(), GUID),
        NDRFullEmbPointerField(NDRPacketField("DomainSid", PRPC_SID(), PRPC_SID)),
        NDRPacketField("TrustExtension", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PNETLOGON_ONE_DOMAIN_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField("DomainName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DnsDomainName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DnsForestName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DomainGuid", GUID(), GUID),
        NDRFullEmbPointerField(NDRPacketField("DomainSid", PRPC_SID(), PRPC_SID)),
        NDRPacketField("TrustExtension", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("DummyLong1", 0),
        NDRIntField("DummyLong2", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PNETLOGON_DOMAIN_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRPacketField(
            "PrimaryDomain", NETLOGON_ONE_DOMAIN_INFO(), NETLOGON_ONE_DOMAIN_INFO
        ),
        NDRIntField("TrustedDomainCount", None, size_of="TrustedDomains"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "TrustedDomains",
                [],
                PNETLOGON_ONE_DOMAIN_INFO,
                size_is=lambda pkt: pkt.TrustedDomainCount,
            )
        ),
        NDRPacketField(
            "LsaPolicy", NETLOGON_LSA_POLICY_INFO(), NETLOGON_LSA_POLICY_INFO
        ),
        NDRPacketField("DnsHostNameInDs", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString2", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString3", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("DummyString4", UNICODE_STRING(), UNICODE_STRING),
        NDRIntField("WorkstationFlags", 0),
        NDRIntField("SupportedEncTypes", 0),
        NDRIntField("DummyLong3", 0),
        NDRIntField("DummyLong4", 0),
    ]


class PNETLOGON_LSA_POLICY_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("LsaPolicySize", None, size_of="LsaPolicy"),
        NDRFullEmbPointerField(
            NDRConfStrLenField("LsaPolicy", "", size_is=lambda pkt: pkt.LsaPolicySize)
        ),
    ]


class NetrLogonGetDomainInfo_Request(NDRPacket):
    fields_desc = [
        NDRConfVarStrNullFieldUtf16("ServerName", ""),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ComputerName", "")),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRIntField("Level", 0),
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "WkstaBuffer",
                            PNETLOGON_WORKSTATION_INFO(),
                            PNETLOGON_WORKSTATION_INFO,
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1),
                        (lambda _, val: val.tag == 1),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "WkstaBuffer",
                            PNETLOGON_WORKSTATION_INFO(),
                            PNETLOGON_WORKSTATION_INFO,
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 2),
                        (lambda _, val: val.tag == 2),
                    ),
                ),
            ],
            StrFixedLenField("WkstaBuffer", "", length=0),
            align=(4, 8),
            switch_fmt=("L", "L"),
        ),
    ]


class NetrLogonGetDomainInfo_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "DomBuffer", PNETLOGON_DOMAIN_INFO(), PNETLOGON_DOMAIN_INFO
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 1),
                        (lambda _, val: val.tag == 1),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "DomBuffer",
                            PNETLOGON_LSA_POLICY_INFO(),
                            PNETLOGON_LSA_POLICY_INFO,
                        )
                    ),
                    (
                        (lambda pkt: getattr(pkt, "Level", None) == 2),
                        (lambda _, val: val.tag == 2),
                    ),
                ),
            ],
            StrFixedLenField("DomBuffer", "", length=0),
            align=(4, 8),
            switch_fmt=("L", "L"),
        ),
        NDRIntField("status", 0),
    ]


class PNL_TRUST_PASSWORD(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [
        StrFixedLenFieldUtf16("Buffer", "", length=256 * 2),
        NDRIntField("Length", 0),
    ]


class NetrServerPasswordSet2_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("PrimaryName", "")),
        NDRConfVarStrNullFieldUtf16("AccountName", ""),
        NDRInt3264EnumField("SecureChannelType", 0, NETLOGON_SECURE_CHANNEL_TYPE),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField("ClearNewPassword", PNL_TRUST_PASSWORD(), PNL_TRUST_PASSWORD),
    ]


class NetrServerPasswordSet2_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRIntField("status", 0),
    ]


class NetrServerPasswordGet_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("PrimaryName", "")),
        NDRConfVarStrNullFieldUtf16("AccountName", ""),
        NDRInt3264EnumField("AccountType", 0, NETLOGON_SECURE_CHANNEL_TYPE),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
    ]


class NetrServerPasswordGet_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField(
            "EncryptedNtOwfPassword",
            PENCRYPTED_NT_OWF_PASSWORD(),
            PENCRYPTED_NT_OWF_PASSWORD,
        ),
        NDRIntField("status", 0),
    ]


class NetrLogonSendToSam_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("PrimaryName", "")),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRConfStrLenField(
            "OpaqueBuffer", "", size_is=lambda pkt: pkt.OpaqueBufferSize
        ),
        NDRIntField("OpaqueBufferSize", None, size_of="OpaqueBuffer"),
    ]


class NetrLogonSendToSam_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRIntField("status", 0),
    ]


class PNL_SOCKET_ADDRESS(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(
            NDRConfStrLenField(
                "lpSockaddr", "", size_is=lambda pkt: pkt.iSockaddrLength
            )
        ),
        NDRIntField("iSockaddrLength", None, size_of="lpSockaddr"),
    ]


class PNL_SITE_NAME_ARRAY(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("EntryCount", None, size_of="SiteNames"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "SiteNames", [], PUNICODE_STRING, size_is=lambda pkt: pkt.EntryCount
            )
        ),
    ]


class DsrAddressToSiteNamesW_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ComputerName", "")),
        NDRIntField("EntryCount", None, size_of="SocketAddresses"),
        NDRConfPacketListField(
            "SocketAddresses",
            [],
            PNL_SOCKET_ADDRESS,
            size_is=lambda pkt: pkt.EntryCount,
        ),
    ]


class DsrAddressToSiteNamesW_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(
            NDRPacketField("SiteNames", PNL_SITE_NAME_ARRAY(), PNL_SITE_NAME_ARRAY)
        ),
        NDRIntField("status", 0),
    ]


class DsrGetDcNameEx2_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ComputerName", "")),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("AccountName", "")),
        NDRIntField("AllowableAccountControlBits", 0),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("DomainName", "")),
        NDRFullPointerField(NDRPacketField("DomainGuid", GUID(), GUID)),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("SiteName", "")),
        NDRIntField("Flags", 0),
    ]


class DsrGetDcNameEx2_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(
            NDRPacketField(
                "DomainControllerInfo",
                PDOMAIN_CONTROLLER_INFOW(),
                PDOMAIN_CONTROLLER_INFOW,
            )
        ),
        NDRIntField("status", 0),
    ]


class NetrLogonGetTimeServiceParentDomain_Request(NDRPacket):
    fields_desc = [NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", ""))]


class NetrLogonGetTimeServiceParentDomain_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("DomainName", "")),
        NDRSignedIntField("PdcSameSite", 0),
        NDRIntField("status", 0),
    ]


class PDS_DOMAIN_TRUSTSW(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("NetbiosDomainName", "")),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("DnsDomainName", "")),
        NDRIntField("Flags", 0),
        NDRIntField("ParentIndex", 0),
        NDRIntField("TrustType", 0),
        NDRIntField("TrustAttributes", 0),
        NDRFullEmbPointerField(NDRPacketField("DomainSid", PRPC_SID(), PRPC_SID)),
        NDRPacketField("DomainGuid", GUID(), GUID),
    ]


class PNETLOGON_TRUSTED_DOMAIN_ARRAY(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("DomainCount", None, size_of="Domains"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "Domains", [], PDS_DOMAIN_TRUSTSW, size_is=lambda pkt: pkt.DomainCount
            )
        ),
    ]


class NetrEnumerateTrustedDomainsEx_Request(NDRPacket):
    fields_desc = [NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", ""))]


class NetrEnumerateTrustedDomainsEx_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "Domains", PNETLOGON_TRUSTED_DOMAIN_ARRAY(), PNETLOGON_TRUSTED_DOMAIN_ARRAY
        ),
        NDRIntField("status", 0),
    ]


class PNL_SITE_NAME_EX_ARRAY(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("EntryCount", None, size_of="SubnetNames"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "SiteNames", [], PUNICODE_STRING, size_is=lambda pkt: pkt.EntryCount
            )
        ),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "SubnetNames", [], PUNICODE_STRING, size_is=lambda pkt: pkt.EntryCount
            )
        ),
    ]


class DsrAddressToSiteNamesExW_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ComputerName", "")),
        NDRIntField("EntryCount", None, size_of="SocketAddresses"),
        NDRConfPacketListField(
            "SocketAddresses",
            [],
            PNL_SOCKET_ADDRESS,
            size_is=lambda pkt: pkt.EntryCount,
        ),
    ]


class DsrAddressToSiteNamesExW_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(
            NDRPacketField(
                "SiteNames", PNL_SITE_NAME_EX_ARRAY(), PNL_SITE_NAME_EX_ARRAY
            )
        ),
        NDRIntField("status", 0),
    ]


class DsrGetDcSiteCoverageW_Request(NDRPacket):
    fields_desc = [NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", ""))]


class DsrGetDcSiteCoverageW_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(
            NDRPacketField("SiteNames", PNL_SITE_NAME_ARRAY(), PNL_SITE_NAME_ARRAY)
        ),
        NDRIntField("status", 0),
    ]


class NetrLogonSamLogonEx_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("LogonServer", "")),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ComputerName", "")),
        NDRInt3264EnumField("LogonLevel", 0, NETLOGON_LOGON_INFO_CLASS),
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_INTERACTIVE_INFO(),
                            PNETLOGON_INTERACTIVE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_INTERACTIVE_INFO(),
                            PNETLOGON_INTERACTIVE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveTransitiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveTransitiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_SERVICE_INFO(),
                            PNETLOGON_SERVICE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_SERVICE_INFO(),
                            PNETLOGON_SERVICE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceTransitiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceTransitiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_NETWORK_INFO(),
                            PNETLOGON_NETWORK_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_NETWORK_INFO(),
                            PNETLOGON_NETWORK_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkTransitiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkTransitiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_GENERIC_INFO(),
                            PNETLOGON_GENERIC_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonGenericInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonGenericInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_TICKET_LOGON_INFO(),
                            PNETLOGON_TICKET_LOGON_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonTicketLogonInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonTicketLogonInformation
                        ),
                    ),
                ),
            ],
            StrFixedLenField("LogonInformation", "", length=0),
            align=(2, 8),
            switch_fmt=("H", "I"),
        ),
        NDRInt3264EnumField("ValidationLevel", 0, NETLOGON_VALIDATION_INFO_CLASS),
        NDRIntField("ExtraFlags", 0),
    ]


class NetrLogonSamLogonEx_Response(NDRPacket):
    fields_desc = [
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_SAM_INFO(),
                            PNETLOGON_VALIDATION_SAM_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_SAM_INFO2(),
                            PNETLOGON_VALIDATION_SAM_INFO2,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo2
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo2
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_GENERIC_INFO2(),
                            PNETLOGON_VALIDATION_GENERIC_INFO2,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationGenericInfo2
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationGenericInfo2
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_SAM_INFO4(),
                            PNETLOGON_VALIDATION_SAM_INFO4,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo4
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo4
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_TICKET_LOGON(),
                            PNETLOGON_VALIDATION_TICKET_LOGON,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationTicketLogon
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationTicketLogon
                        ),
                    ),
                ),
            ],
            StrFixedLenField("ValidationInformation", "", length=0),
            align=(2, 8),
            switch_fmt=("H", "I"),
        ),
        NDRByteField("Authoritative", 0),
        NDRIntField("ExtraFlags", 0),
        NDRIntField("status", 0),
    ]


class DsrEnumerateDomainTrusts_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRIntField("Flags", 0),
    ]


class DsrEnumerateDomainTrusts_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "Domains", PNETLOGON_TRUSTED_DOMAIN_ARRAY(), PNETLOGON_TRUSTED_DOMAIN_ARRAY
        ),
        NDRIntField("status", 0),
    ]


class DsrDeregisterDnsHostRecords_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("DnsDomainName", "")),
        NDRFullPointerField(NDRPacketField("DomainGuid", GUID(), GUID)),
        NDRFullPointerField(NDRPacketField("DsaGuid", GUID(), GUID)),
        NDRConfVarStrNullFieldUtf16("DnsHostName", ""),
    ]


class DsrDeregisterDnsHostRecords_Response(NDRPacket):
    fields_desc = [NDRIntField("status", 0)]


class NetrServerTrustPasswordsGet_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("TrustedDcName", "")),
        NDRConfVarStrNullFieldUtf16("AccountName", ""),
        NDRInt3264EnumField("SecureChannelType", 0, NETLOGON_SECURE_CHANNEL_TYPE),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
    ]


class NetrServerTrustPasswordsGet_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField(
            "EncryptedNewOwfPassword",
            PENCRYPTED_NT_OWF_PASSWORD(),
            PENCRYPTED_NT_OWF_PASSWORD,
        ),
        NDRPacketField(
            "EncryptedOldOwfPassword",
            PENCRYPTED_NT_OWF_PASSWORD(),
            PENCRYPTED_NT_OWF_PASSWORD,
        ),
        NDRIntField("status", 0),
    ]


class LSA_FOREST_TRUST_RECORD_TYPE(IntEnum):
    ForestTrustTopLevelName = 0
    ForestTrustTopLevelNameEx = 1
    ForestTrustDomainInfo = 2
    ForestTrustRecordTypeLast = ForestTrustDomainInfo


class LARGE_INTEGER(NDRPacket):
    ALIGNMENT = (8, 8)
    fields_desc = [NDRSignedLongField("QuadPart", 0)]


class LSA_FOREST_TRUST_DOMAIN_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRPacketField("Sid", PRPC_SID(), PRPC_SID)),
        NDRPacketField("DnsName", UNICODE_STRING(), UNICODE_STRING),
        NDRPacketField("NetbiosName", UNICODE_STRING(), UNICODE_STRING),
    ]


class LSA_FOREST_TRUST_BINARY_DATA(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("Length", None, size_of="Buffer"),
        NDRFullEmbPointerField(
            NDRConfStrLenField("Buffer", "", size_is=lambda pkt: pkt.Length)
        ),
    ]


class PLSA_FOREST_TRUST_RECORD(NDRPacket):
    ALIGNMENT = (8, 8)
    fields_desc = [
        NDRIntField("Flags", 0),
        NDRInt3264EnumField("ForestTrustType", 0, LSA_FOREST_TRUST_RECORD_TYPE),
        NDRPacketField("Time", LARGE_INTEGER(), LARGE_INTEGER),
        NDRUnionField(
            [
                (
                    NDRPacketField("ForestTrustData", UNICODE_STRING(), UNICODE_STRING),
                    (
                        (
                            lambda pkt: getattr(pkt, "ForestTrustType", None)
                            in [
                                LSA_FOREST_TRUST_RECORD_TYPE.ForestTrustTopLevelName,
                                LSA_FOREST_TRUST_RECORD_TYPE.ForestTrustTopLevelNameEx,
                            ]
                        ),
                        (
                            lambda _, val: val.tag
                            in [
                                LSA_FOREST_TRUST_RECORD_TYPE.ForestTrustTopLevelName,
                                LSA_FOREST_TRUST_RECORD_TYPE.ForestTrustTopLevelNameEx,
                            ]
                        ),
                    ),
                ),
                (
                    NDRPacketField(
                        "ForestTrustData",
                        LSA_FOREST_TRUST_DOMAIN_INFO(),
                        LSA_FOREST_TRUST_DOMAIN_INFO,
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ForestTrustType", None)
                            == LSA_FOREST_TRUST_RECORD_TYPE.ForestTrustDomainInfo
                        ),
                        (
                            lambda _, val: val.tag
                            == LSA_FOREST_TRUST_RECORD_TYPE.ForestTrustDomainInfo
                        ),
                    ),
                ),
            ],
            NDRPacketField(
                "ForestTrustData",
                LSA_FOREST_TRUST_BINARY_DATA(),
                LSA_FOREST_TRUST_BINARY_DATA,
            ),
            align=(2, 8),
            switch_fmt=("H", "I"),
        ),
    ]


class PLSA_FOREST_TRUST_INFORMATION(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("RecordCount", None, size_of="Entries"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "Entries",
                [],
                PLSA_FOREST_TRUST_RECORD,
                size_is=lambda pkt: pkt.RecordCount,
                ptr_pack=True,
            )
        ),
    ]


class DsrGetForestTrustInformation_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("TrustedDomainName", "")),
        NDRIntField("Flags", 0),
    ]


class DsrGetForestTrustInformation_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(
            NDRPacketField(
                "ForestTrustInfo",
                PLSA_FOREST_TRUST_INFORMATION(),
                PLSA_FOREST_TRUST_INFORMATION,
            )
        ),
        NDRIntField("status", 0),
    ]


class NetrGetForestTrustInformation_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRIntField("Flags", 0),
    ]


class NetrGetForestTrustInformation_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRFullPointerField(
            NDRPacketField(
                "ForestTrustInfo",
                PLSA_FOREST_TRUST_INFORMATION(),
                PLSA_FOREST_TRUST_INFORMATION,
            )
        ),
        NDRIntField("status", 0),
    ]


class NetrLogonSamLogonWithFlags_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("LogonServer", "")),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ComputerName", "")),
        NDRFullPointerField(
            NDRPacketField(
                "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
            )
        ),
        NDRFullPointerField(
            NDRPacketField(
                "ReturnAuthenticator",
                PNETLOGON_AUTHENTICATOR(),
                PNETLOGON_AUTHENTICATOR,
            )
        ),
        NDRInt3264EnumField("LogonLevel", 0, NETLOGON_LOGON_INFO_CLASS),
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_INTERACTIVE_INFO(),
                            PNETLOGON_INTERACTIVE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_INTERACTIVE_INFO(),
                            PNETLOGON_INTERACTIVE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveTransitiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonInteractiveTransitiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_SERVICE_INFO(),
                            PNETLOGON_SERVICE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_SERVICE_INFO(),
                            PNETLOGON_SERVICE_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceTransitiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonServiceTransitiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_NETWORK_INFO(),
                            PNETLOGON_NETWORK_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_NETWORK_INFO(),
                            PNETLOGON_NETWORK_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkTransitiveInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonNetworkTransitiveInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_GENERIC_INFO(),
                            PNETLOGON_GENERIC_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonGenericInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonGenericInformation
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "LogonInformation",
                            PNETLOGON_TICKET_LOGON_INFO(),
                            PNETLOGON_TICKET_LOGON_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "LogonLevel", None)
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonTicketLogonInformation
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_LOGON_INFO_CLASS.NetlogonTicketLogonInformation
                        ),
                    ),
                ),
            ],
            StrFixedLenField("LogonInformation", "", length=0),
            align=(2, 8),
            switch_fmt=("H", "I"),
        ),
        NDRInt3264EnumField("ValidationLevel", 0, NETLOGON_VALIDATION_INFO_CLASS),
        NDRIntField("ExtraFlags", 0),
    ]


class NetrLogonSamLogonWithFlags_Response(NDRPacket):
    fields_desc = [
        NDRFullPointerField(
            NDRPacketField(
                "ReturnAuthenticator",
                PNETLOGON_AUTHENTICATOR(),
                PNETLOGON_AUTHENTICATOR,
            )
        ),
        NDRUnionField(
            [
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_SAM_INFO(),
                            PNETLOGON_VALIDATION_SAM_INFO,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_SAM_INFO2(),
                            PNETLOGON_VALIDATION_SAM_INFO2,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo2
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo2
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_GENERIC_INFO2(),
                            PNETLOGON_VALIDATION_GENERIC_INFO2,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationGenericInfo2
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationGenericInfo2
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_SAM_INFO4(),
                            PNETLOGON_VALIDATION_SAM_INFO4,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo4
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationSamInfo4
                        ),
                    ),
                ),
                (
                    NDRFullPointerField(
                        NDRPacketField(
                            "ValidationInformation",
                            PNETLOGON_VALIDATION_TICKET_LOGON(),
                            PNETLOGON_VALIDATION_TICKET_LOGON,
                        )
                    ),
                    (
                        (
                            lambda pkt: getattr(pkt, "ValidationLevel", None)
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationTicketLogon
                        ),
                        (
                            lambda _, val: val.tag
                            == NETLOGON_VALIDATION_INFO_CLASS.NetlogonValidationTicketLogon
                        ),
                    ),
                ),
            ],
            StrFixedLenField("ValidationInformation", "", length=0),
            align=(2, 8),
            switch_fmt=("H", "I"),
        ),
        NDRByteField("Authoritative", 0),
        NDRIntField("ExtraFlags", 0),
        NDRIntField("status", 0),
    ]


class PNL_GENERIC_RPC_DATA(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("UlongEntryCount", None, size_of="UlongData"),
        NDRFullEmbPointerField(
            NDRConfFieldListField(
                "UlongData",
                [],
                NDRIntField("", 0),
                size_is=lambda pkt: pkt.UlongEntryCount,
            )
        ),
        NDRIntField("UnicodeStringEntryCount", None, size_of="UnicodeStringData"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "UnicodeStringData",
                [],
                PUNICODE_STRING,
                size_is=lambda pkt: pkt.UnicodeStringEntryCount,
            )
        ),
    ]


class NetrServerGetTrustInfo_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("TrustedDcName", "")),
        NDRConfVarStrNullFieldUtf16("AccountName", ""),
        NDRInt3264EnumField("SecureChannelType", 0, NETLOGON_SECURE_CHANNEL_TYPE),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
    ]


class NetrServerGetTrustInfo_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField(
            "EncryptedNewOwfPassword",
            PENCRYPTED_NT_OWF_PASSWORD(),
            PENCRYPTED_NT_OWF_PASSWORD,
        ),
        NDRPacketField(
            "EncryptedOldOwfPassword",
            PENCRYPTED_NT_OWF_PASSWORD(),
            PENCRYPTED_NT_OWF_PASSWORD,
        ),
        NDRFullPointerField(
            NDRPacketField("TrustInfo", PNL_GENERIC_RPC_DATA(), PNL_GENERIC_RPC_DATA)
        ),
        NDRIntField("status", 0),
    ]


class OpnumUnused47_Request(NDRPacket):
    fields_desc = []


class OpnumUnused47_Response(NDRPacket):
    fields_desc = [NDRIntField("status", 0)]


class PNL_DNS_NAME_INFO(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("Type", 0),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("DnsDomainInfo", "")),
        NDRIntField("DnsDomainInfoType", 0),
        NDRIntField("Priority", 0),
        NDRIntField("Weight", 0),
        NDRIntField("Port", 0),
        NDRByteField("Register", 0),
        NDRIntField("Status", 0),
    ]


class PNL_DNS_NAME_INFO_ARRAY(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRIntField("EntryCount", None, size_of="DnsNamesInfo"),
        NDRFullEmbPointerField(
            NDRConfPacketListField(
                "DnsNamesInfo",
                [],
                PNL_DNS_NAME_INFO,
                size_is=lambda pkt: pkt.EntryCount,
            )
        ),
    ]


class DsrUpdateReadOnlyServerDnsRecords_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("ServerName", "")),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("SiteName", "")),
        NDRIntField("DnsTtl", 0),
        NDRPacketField("DnsNames", PNL_DNS_NAME_INFO_ARRAY(), PNL_DNS_NAME_INFO_ARRAY),
    ]


class DsrUpdateReadOnlyServerDnsRecords_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField("DnsNames", PNL_DNS_NAME_INFO_ARRAY(), PNL_DNS_NAME_INFO_ARRAY),
        NDRIntField("status", 0),
    ]


class NL_OSVERSIONINFO_V1(NDRPacket):
    ALIGNMENT = (4, 4)
    fields_desc = [
        NDRIntField("dwOSVersionInfoSize", 0),
        NDRIntField("dwMajorVersion", 0),
        NDRIntField("dwMinorVersion", 0),
        NDRIntField("dwBuildNumber", 0),
        NDRIntField("dwPlatformId", 0),
        StrFixedLenFieldUtf16("szCSDVersion", "", length=128 * 2),
        NDRShortField("wServicePackMajor", 0),
        NDRShortField("wServicePackMinor", 0),
        NDRShortField("wSuiteMask", 0),
        NDRByteField("wProductType", 0),
        NDRByteField("wReserved", 0),
    ]


class NL_IN_CHAIN_SET_CLIENT_ATTRIBUTES_V1(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("ClientDnsHostName", "")),
        NDRFullEmbPointerField(
            NDRPacketField(
                "OsVersionInfo_V1", NL_OSVERSIONINFO_V1(), NL_OSVERSIONINFO_V1
            )
        ),
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("OsName", "")),
    ]


class NL_OUT_CHAIN_SET_CLIENT_ATTRIBUTES_V1(NDRPacket):
    ALIGNMENT = (4, 8)
    fields_desc = [
        NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("HubName", "")),
        NDRFullEmbPointerField(
            NDRFullEmbPointerField(NDRConfVarStrNullFieldUtf16("OldDnsHostName", ""))
        ),
        NDRFullEmbPointerField(NDRIntField("SupportedEncTypes", 0)),
    ]


class NetrChainSetClientAttributes_Request(NDRPacket):
    fields_desc = [
        NDRConfVarStrNullFieldUtf16("PrimaryName", ""),
        NDRConfVarStrNullFieldUtf16("ChainedFromServerName", ""),
        NDRConfVarStrNullFieldUtf16("ChainedForClientName", ""),
        NDRPacketField(
            "Authenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRIntField("dwInVersion", 0),
        NDRUnionField(
            [
                (
                    NDRPacketField(
                        "pmsgIn",
                        NL_IN_CHAIN_SET_CLIENT_ATTRIBUTES_V1(),
                        NL_IN_CHAIN_SET_CLIENT_ATTRIBUTES_V1,
                    ),
                    (
                        (lambda pkt: getattr(pkt, "dwInVersion", None) == 1),
                        (lambda _, val: val.tag == 1),
                    ),
                )
            ],
            StrFixedLenField("pmsgIn", "", length=0),
            align=(4, 8),
            switch_fmt=("L", "L"),
        ),
        NDRIntField("pdwOutVersion", 0),
        NDRUnionField(
            [
                (
                    NDRPacketField(
                        "pmsgOut",
                        NL_OUT_CHAIN_SET_CLIENT_ATTRIBUTES_V1(),
                        NL_OUT_CHAIN_SET_CLIENT_ATTRIBUTES_V1,
                    ),
                    (
                        (lambda pkt: getattr(pkt, "pdwOutVersion", None) == 1),
                        (lambda _, val: val.tag == 1),
                    ),
                )
            ],
            StrFixedLenField("pmsgOut", "", length=0),
            align=(4, 8),
            switch_fmt=("L", "L"),
        ),
    ]


class NetrChainSetClientAttributes_Response(NDRPacket):
    fields_desc = [
        NDRPacketField(
            "ReturnAuthenticator", PNETLOGON_AUTHENTICATOR(), PNETLOGON_AUTHENTICATOR
        ),
        NDRIntField("pdwOutVersion", 0),
        NDRUnionField(
            [
                (
                    NDRPacketField(
                        "pmsgOut",
                        NL_OUT_CHAIN_SET_CLIENT_ATTRIBUTES_V1(),
                        NL_OUT_CHAIN_SET_CLIENT_ATTRIBUTES_V1,
                    ),
                    (
                        (lambda pkt: getattr(pkt, "pdwOutVersion", None) == 1),
                        (lambda _, val: val.tag == 1),
                    ),
                )
            ],
            StrFixedLenField("pmsgOut", "", length=0),
            align=(4, 8),
            switch_fmt=("L", "L"),
        ),
        NDRIntField("status", 0),
    ]


class NetrServerAuthenticateKerberos_Request(NDRPacket):
    fields_desc = [
        NDRFullPointerField(NDRConfVarStrNullFieldUtf16("PrimaryName", "")),
        NDRConfVarStrNullFieldUtf16("AccountName", ""),
        NDRInt3264EnumField("AccountType", 0, NETLOGON_SECURE_CHANNEL_TYPE),
        NDRConfVarStrNullFieldUtf16("ComputerName", ""),
        NDRIntField("NegotiateFlags", 0),
    ]


class NetrServerAuthenticateKerberos_Response(NDRPacket):
    fields_desc = [
        NDRIntField("NegotiateFlags", 0),
        NDRIntField("AccountRid", 0),
        NDRIntField("status", 0),
    ]


LOGON_OPNUMS = {
    0: DceRpcOp(NetrLogonUasLogon_Request, NetrLogonUasLogon_Response),
    1: DceRpcOp(NetrLogonUasLogoff_Request, NetrLogonUasLogoff_Response),
    2: DceRpcOp(NetrLogonSamLogon_Request, NetrLogonSamLogon_Response),
    3: DceRpcOp(NetrLogonSamLogoff_Request, NetrLogonSamLogoff_Response),
    4: DceRpcOp(NetrServerReqChallenge_Request, NetrServerReqChallenge_Response),
    5: DceRpcOp(NetrServerAuthenticate_Request, NetrServerAuthenticate_Response),
    6: DceRpcOp(NetrServerPasswordSet_Request, NetrServerPasswordSet_Response),
    7: DceRpcOp(NetrDatabaseDeltas_Request, NetrDatabaseDeltas_Response),
    8: DceRpcOp(NetrDatabaseSync_Request, NetrDatabaseSync_Response),
    9: DceRpcOp(NetrAccountDeltas_Request, NetrAccountDeltas_Response),
    10: DceRpcOp(NetrAccountSync_Request, NetrAccountSync_Response),
    11: DceRpcOp(NetrGetDCName_Request, NetrGetDCName_Response),
    12: DceRpcOp(NetrLogonControl_Request, NetrLogonControl_Response),
    13: DceRpcOp(NetrGetAnyDCName_Request, NetrGetAnyDCName_Response),
    14: DceRpcOp(NetrLogonControl2_Request, NetrLogonControl2_Response),
    15: DceRpcOp(NetrServerAuthenticate2_Request, NetrServerAuthenticate2_Response),
    16: DceRpcOp(NetrDatabaseSync2_Request, NetrDatabaseSync2_Response),
    17: DceRpcOp(NetrDatabaseRedo_Request, NetrDatabaseRedo_Response),
    18: DceRpcOp(NetrLogonControl2Ex_Request, NetrLogonControl2Ex_Response),
    19: DceRpcOp(
        NetrEnumerateTrustedDomains_Request, NetrEnumerateTrustedDomains_Response
    ),
    20: DceRpcOp(DsrGetDcName_Request, DsrGetDcName_Response),
    21: DceRpcOp(NetrLogonGetCapabilities_Request, NetrLogonGetCapabilities_Response),
    22: DceRpcOp(NetrLogonSetServiceBits_Request, NetrLogonSetServiceBits_Response),
    23: DceRpcOp(NetrLogonGetTrustRid_Request, NetrLogonGetTrustRid_Response),
    24: DceRpcOp(
        NetrLogonComputeServerDigest_Request, NetrLogonComputeServerDigest_Response
    ),
    25: DceRpcOp(
        NetrLogonComputeClientDigest_Request, NetrLogonComputeClientDigest_Response
    ),
    26: DceRpcOp(NetrServerAuthenticate3_Request, NetrServerAuthenticate3_Response),
    27: DceRpcOp(DsrGetDcNameEx_Request, DsrGetDcNameEx_Response),
    28: DceRpcOp(DsrGetSiteName_Request, DsrGetSiteName_Response),
    29: DceRpcOp(NetrLogonGetDomainInfo_Request, NetrLogonGetDomainInfo_Response),
    30: DceRpcOp(NetrServerPasswordSet2_Request, NetrServerPasswordSet2_Response),
    31: DceRpcOp(NetrServerPasswordGet_Request, NetrServerPasswordGet_Response),
    32: DceRpcOp(NetrLogonSendToSam_Request, NetrLogonSendToSam_Response),
    33: DceRpcOp(DsrAddressToSiteNamesW_Request, DsrAddressToSiteNamesW_Response),
    34: DceRpcOp(DsrGetDcNameEx2_Request, DsrGetDcNameEx2_Response),
    35: DceRpcOp(
        NetrLogonGetTimeServiceParentDomain_Request,
        NetrLogonGetTimeServiceParentDomain_Response,
    ),
    36: DceRpcOp(
        NetrEnumerateTrustedDomainsEx_Request, NetrEnumerateTrustedDomainsEx_Response
    ),
    37: DceRpcOp(DsrAddressToSiteNamesExW_Request, DsrAddressToSiteNamesExW_Response),
    38: DceRpcOp(DsrGetDcSiteCoverageW_Request, DsrGetDcSiteCoverageW_Response),
    39: DceRpcOp(NetrLogonSamLogonEx_Request, NetrLogonSamLogonEx_Response),
    40: DceRpcOp(DsrEnumerateDomainTrusts_Request, DsrEnumerateDomainTrusts_Response),
    41: DceRpcOp(
        DsrDeregisterDnsHostRecords_Request, DsrDeregisterDnsHostRecords_Response
    ),
    42: DceRpcOp(
        NetrServerTrustPasswordsGet_Request, NetrServerTrustPasswordsGet_Response
    ),
    43: DceRpcOp(
        DsrGetForestTrustInformation_Request, DsrGetForestTrustInformation_Response
    ),
    44: DceRpcOp(
        NetrGetForestTrustInformation_Request, NetrGetForestTrustInformation_Response
    ),
    45: DceRpcOp(
        NetrLogonSamLogonWithFlags_Request, NetrLogonSamLogonWithFlags_Response
    ),
    46: DceRpcOp(NetrServerGetTrustInfo_Request, NetrServerGetTrustInfo_Response),
    47: DceRpcOp(OpnumUnused47_Request, OpnumUnused47_Response),
    48: DceRpcOp(
        DsrUpdateReadOnlyServerDnsRecords_Request,
        DsrUpdateReadOnlyServerDnsRecords_Response,
    ),
    49: DceRpcOp(
        NetrChainSetClientAttributes_Request, NetrChainSetClientAttributes_Response
    ),
    # 50: Opnum50NotUsedOnWire,
    # 51: Opnum51NotUsedOnWire,
    # 52: Opnum52NotUsedOnWire,
    # 53: Opnum53NotUsedOnWire,
    # 54: Opnum54NotUsedOnWire,
    # 55: Opnum55NotUsedOnWire,
    # 56: Opnum56NotUsedOnWire,
    # 57: Opnum57NotUsedOnWire,
    # 58: Opnum58NotUsedOnWire,
    59: DceRpcOp(
        NetrServerAuthenticateKerberos_Request, NetrServerAuthenticateKerberos_Response
    ),
}
register_dcerpc_interface(
    name="logon",
    uuid=uuid.UUID("12345678-1234-ABCD-EF00-01234567CFFB"),
    version="1.0",
    opnums=LOGON_OPNUMS,
)
