#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("enables or disables tracking of highlighted")

    def run(self):
        if not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "focus", "highlight"
        ):
            return
        attribute_delta = self.env["runtime"][
            "AttributeManager"
        ].get_attribute_delta()
        self.env["runtime"]["OutputManager"].present_text(
            attribute_delta, sound_icon="", interrupt=True, flush=False
        )

    def set_callback(self, callback):
        pass
