/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright 2009--2026 by Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once


/////////////////////// Qt includes
#include <QMainWindow>
#include <QDir>
#include <QStringList>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMassCore includes
#include <MsXpS/libXpertMassCore/PolChemDef.hpp>
#include <MsXpS/libXpertMassCore/PolChemDefSpec.hpp>
#include <MsXpS/libXpertMassCore/MassDataServer.hpp>
#include <MsXpS/libXpertMassCore/MassDataClient.hpp>


/////////////////////// libXpertMassGUI includes
#include <MsXpS/libXpertMassGui/MassDataClientServerConfigDlg.hpp>
#include <MsXpS/libXpertMassGui/IsotopicClusterGeneratorDlg.hpp>
#include <MsXpS/libXpertMassGui/IsotopicClusterShaperDlg.hpp>
#include "MsXpS/libXpertMassGui/JavaScriptingEnvironment.hpp"
#include "MsXpS/libXpertMassGui/JavaScriptingGuiUtils.hpp"
#include "MsXpS/libXpertMassGui/JavaScriptingWnd.hpp"


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

namespace MsXpS
{
namespace libXpertMassGui
{
class DECLSPEC JavaScriptWorker: public QObject
{
  Q_OBJECT

  public:
  JavaScriptWorker(QString script, const JavaScriptingEnvironment *env);

  public slots:
  void run();
  void requestAbort();

  signals:
  void finishedSignal(QJSValue result);


  private:
  QString m_script;
  const JavaScriptingEnvironment *mp_scriptingEnvironment = nullptr;
};


} // namespace libXpertMassGui
} // namespace MsXpS
