-- This reservoir simulation deck is made available under the Open Database
-- License: http://opendatacommons.org/licenses/odbl/1.0/. Any rights in
-- individual contents of the database are licensed under the Database Contents
-- License: http://opendatacommons.org/licenses/dbcl/1.0/

-- Copyright (C) 2015 Statoil

--
--         Generated by : Prosper 9.3 - License#:4474 - Sep 17 2006 14:05:16
--         Generated on : 09 Jan 07  14:19
--           Input File : C:\GAP\D3BH.OUT
--          Output File : Z:\res\sim\ior\linn\gap\D3BH.Ecl
--
--
--                Fluid : Oil
--           PVT Method : Black Oil
--    Equation Of State : 
--            Separator : Single-Stage
--            Emulsions : No
--             Hydrates : Disable Warning
--      Water Viscosity : Use Default Correlation
--         Water Vapour : No Calculations
--      Viscosity Model : Newtonian Fluid
--
--            Flow Type : Tubing
--            Well Type : Producer
--
--      Artificial Lift : None
--            Lift Type : 
--
--           Predicting : Pressure and Temperature (offshore)
--    Temperature Model : Rough Approximation
--                Range : Full System
--
--           Completion : Cased Hole
--          Gravel Pack : No
--
--          Inflow Type : Single Branch
--           Gas Coning : No
--
--              Company : Statoil
--                Field : Norne
--             Location : Nordland II
--                 Well : D-3AH
--             Platform : Transocean Prospect
--              Analyst : amoe + arild stokkenes
--                 Date : 30 May 06  12:37
--
--
--
--  Surface Equipment Correlation :  GRE (modified by PE) - (1.000) (1.350)
--      Vertical Lift Correlation :  OLGAS 2P - (0.948) (0.905)
--
--                    Rate Method :  User Selected
--                      Rate Type :  Liquid Rates
--
--                     First Node :    1            Xmas Tree        396 (m)
--                      Last Node :   20               Tubing       4826 (m)
--
--         Sensitivity Variable 1 :  First Node Pressure
--         Sensitivity Variable 2 :  Gas Oil Ratio
--         Sensitivity Variable 3 :  Water Cut
--
--
-- PROSPER Lift Curves For ECLIPSE Simulator    (Liquid - Producer Well)  (Units System  - METRIC)


VFPPROD

-- Table   Datum Depth   Rate Type   WFR Type   GFR Type   TAB Type
-- -----   -----------   ---------   --------   --------   --------
--    43       2607.24       'LIQ'      'WCT'      'GOR'            /

-- Prosper files are corrected from RKB to MSL depth. lmarr

-- Table   Datum Depth   Rate Type   WFR Type   GFR Type   TAB Type
-- -----   -----------   ---------   --------   --------   --------
      43       2583.24       'LIQ'      'WCT'      'GOR'            /


-- 'LIQ' units - SM3/DAY
  200.0   500.0  1000.0  1500.0  2000.0 
 2500.0  3000.0  3500.0  4000.0  4500.0 
 5000.0  5500.0  6000.0  6500.0  7000.0 
 7500.0  8000.0 10000.0 14000.0 /

-- 'THP' units - BARSA
  21.01   51.01   61.01   81.01  101.01 
 121.01  141.01  181.01  201.01 /

-- 'WCT' units - FRACTION
      0     0.1     0.2     0.3     0.4 
    0.5     0.6     0.7     0.8       1 /

-- 'GOR' units - SM3/SM3
     50     100     150     200     500 
   1000    2000    5000 /

-- 'ALQ' units - 
      0 /

 1  1  1  1  168.61  156.95  147.28  144.57  145.15 
             147.56  151.21  155.39  160.02  165.05 
             170.43  176.12  182.10  188.35  194.86 
             201.62  208.61  238.95  310.62 
/
 1  1  2  1  145.41  122.36  105.70  101.45  102.41 
             107.69  114.49  121.71  129.01  136.29 
             143.95  151.93  160.60  169.33  178.23 
             186.69  195.72  233.55  321.14 
/
 1  1  3  1  130.90  100.97   85.96   84.93   88.78 
              96.50  104.62  112.90  120.90  128.64 
             136.66  145.68  154.98  164.56  174.07 
             183.80  194.31  237.16  334.03 
/
 1  1  4  1  118.25   86.15   75.18   76.60   84.16 
              92.98  101.66  109.82  118.15  126.63 
             135.82  145.37  155.66  166.58  177.07 
             187.89  199.08  246.46  357.99 
/
 1  1  5  1   73.05   56.57   61.37   75.47   89.61 
             103.82  117.98  132.28  146.74  161.37 
             176.25  191.39  206.77  222.42  238.33 
             254.51  270.98  352.97  549.50 
/
 1  1  6  1   52.54   48.78   72.71   96.90  121.52 
             146.31  171.33  196.53  221.94  247.61 
             273.58  299.88  326.55  353.65  381.21 
             409.30  438.13  575.29  941.74 
/
 1  1  7  1   39.13   63.26  107.68  151.83  195.55 
             239.39  283.70  328.72  374.75  422.06 
             471.34  523.38  578.24  636.36  698.02 
             763.60  837.65 1164.40 1990.81 
/
 1  1  8  1   57.21  118.05  215.61  313.02  415.44 
             528.09  653.24  792.25  945.95 1112.62 
            1293.61 1490.63 1702.78 1930.90 2174.70 
            2399.81 2397.57 2396.75 2446.50 
/
 1  2  1  1  173.16  162.34  153.56  151.32  151.96 
             154.25  157.61  161.50  165.84  170.59 
             175.69  181.12  186.85  192.87  199.16 
             205.72  212.54  242.29  313.54 
/
 1  2  2  1  150.50  128.73  112.25  107.50  108.17 
             112.85  119.28  126.31  133.42  140.69 
             148.05  155.82  164.12  172.87  181.78 
             190.34  199.44  237.07  323.19 
/
 1  2  3  1  136.77  107.63   91.51   89.37   92.27 
              99.65  107.52  115.50  123.42  131.40 
             139.13  148.00  156.97  166.48  175.90 
             185.56  195.46  237.87  334.19 
/
 1  2  4  1  124.68   92.34   79.58   79.87   86.24 
              94.79  103.39  111.59  119.51  127.56 
             136.52  147.00  156.79  166.86  177.24 
             187.49  198.53  244.43  352.30 
/
 1  2  5  1   78.57   59.29   61.53   74.52   87.78 
             101.08  114.34  127.61  141.03  154.62 
             168.48  182.56  196.87  211.41  226.22 
             241.28  256.60  333.04  519.37 
/
 1  2  6  1   55.29   48.34   70.13   92.30  114.88 
             137.70  160.72  184.01  207.55  231.33 
             255.39  279.74  304.42  329.45  354.85 
             380.68  407.01  523.65  859.16 
/
 1  2  7  1   40.32   60.09  100.45  141.10  181.35 
             221.63  262.27  303.47  345.41  388.29 
             432.33  478.12  526.05  576.58  629.71 
             685.86  745.21 1035.44 1749.80 
/
 1  2  8  1   53.58  109.04  198.35  286.80  378.09 
             476.24  584.02  702.69  833.22  975.85 
            1128.86 1294.17 1472.76 1663.97 1868.47 
            2085.92 2316.41 2704.10 2731.47 
/
 1  3  1  1  177.85  167.94  160.16  158.40  159.14 
             161.33  164.41  168.01  172.06  176.51 
             181.33  186.49  191.96  197.74  203.80 
             210.15  216.76  245.85  316.44 
/
 1  3  2  1  155.84  135.54  119.52  114.47  114.97 
             119.05  125.04  131.68  138.66  145.72 
             153.08  160.40  168.48  176.78  185.66 
             194.74  203.49  240.98  327.19 
/
 1  3  3  1  142.96  115.03   98.04   94.88   96.84 
             103.48  111.10  118.83  126.60  134.54 
             142.45  150.88  159.95  169.07  178.40 
             187.96  197.78  239.09  333.01 
/
 1  3  4  1  131.56   99.52   84.97   84.43   89.10 
              97.27  105.57  114.02  122.00  130.27 
             138.80  148.15  157.76  167.68  177.52 
             188.08  198.48  242.89  347.02 
/
 1  3  5  1   85.25   62.58   62.52   74.06   86.29 
              98.66  111.04  123.37  135.73  148.25 
             161.05  174.07  187.29  200.71  214.37 
             228.28  242.44  314.13  487.71 
/
 1  3  6  1   58.89   48.80   67.86   88.00  108.50 
             129.28  150.28  171.52  193.05  214.89 
             236.99  259.37  282.05  305.04  328.35 
             352.01  376.05  477.32  777.46 
/
 1  3  7  1   43.38   57.18   93.30  130.28  167.02 
             203.72  240.68  278.08  316.08  354.76 
             394.28  434.77  476.71  520.23  565.87 
             613.75  663.93  907.79 1522.48 
/
 1  3  8  1   49.83   99.92  180.89  260.56  341.89 
             427.01  518.99  619.17  728.46  847.49 
             976.35 1113.56 1260.63 1418.47 1587.09 
            1765.83 1955.47 2820.07 3167.18 
/
 1  4  1  1  182.78  173.76  167.12  165.85  166.69 
             168.80  171.61  174.93  178.69  182.85 
             187.38  192.25  197.46  202.98  208.80 
             214.92  221.32  249.69  319.32 
/
 1  4  2  1  161.62  142.87  127.61  122.65  122.99 
             126.50  131.99  138.12  144.69  151.67 
             158.79  165.83  173.63  181.68  189.95 
             198.90  207.63  245.44  328.00 
/
 1  4  3  1  149.47  123.24  105.72  101.57  102.65 
             108.45  115.69  123.27  130.87  138.52 
             146.36  154.93  163.94  172.94  182.10 
             191.13  200.85  241.85  334.04 
/
 1  4  4  1  138.89  107.82   91.62   89.82   92.97 
             100.75  108.87  117.13  125.33  133.09 
             141.09  150.28  159.50  169.26  178.96 
             188.90  199.66  242.83  344.07 
/
 1  4  5  1   93.30   66.77   64.40   74.13   85.35 
              96.72  108.18  119.63  131.03  142.47 
             154.19  166.10  178.21  190.54  203.08 
             215.83  228.79  297.07  459.54 
/
 1  4  6  1   63.16   51.11   65.79   84.08  102.51 
             121.21  140.13  159.28  178.69  198.39 
             218.42  238.77  259.40  280.33  301.55 
             323.08  344.94  436.32  701.11 
/
 1  4  7  1   47.82   54.40   86.40  119.40  152.55 
             185.66  218.92  252.52  286.58  321.21 
             356.46  392.43  429.22  466.96  506.07 
             546.55  588.76  782.27 1309.98 
/
 1  4  8  1   46.07   90.72  163.19  234.25  306.07 
             380.18  457.93  541.52  631.72  729.20 
             834.42  947.47 1067.51 1194.64 1330.32 
            1474.57 1627.24 2321.59 4092.33 
/
 1  5  1  1  188.03  179.85  174.45  173.65  174.61 
             176.60  179.17  182.22  185.70  189.57 
             193.83  198.43  203.37  208.63  214.20 
             220.08  226.26  253.85  322.39 
/
 1  5  2  1  167.97  150.80  136.79  132.18  132.46 
             135.35  140.35  145.90  151.90  158.32 
             165.12  172.27  179.72  187.45  195.44 
             203.67  212.13  248.09  329.25 
/
 1  5  3  1  156.32  132.29  114.80  109.75  110.19 
             115.05  121.74  129.06  136.39  143.92 
             151.58  159.68  168.38  177.21  186.44 
             195.92  205.47  245.31  335.50 
/
 1  5  4  1  146.71  117.33   99.88   96.58   98.54 
             105.35  113.13  121.03  128.99  136.98 
             145.00  153.62  162.62  172.27  181.86 
             191.70  201.82  244.50  341.84 
/
 1  5  5  1  102.96   72.51   67.49   75.07   85.42 
              95.85  106.02  116.53  127.04  137.53 
             148.23  159.07  170.06  181.24  192.60 
             204.17  215.96  280.46  429.55 
/
 1  5  6  1   69.13   55.08   64.10   80.61   97.12 
             113.69  130.49  147.50  164.74  182.23 
             200.02  218.12  236.55  255.32  274.40 
             293.78  313.47  395.47  627.94 
/
 1  5  7  1   51.40   51.76   79.90  108.76  137.97 
             167.40  196.98  226.79  256.92  287.50 
             318.57  350.20  382.45  415.36  449.03 
             483.54  519.06  674.28 1116.17 
/
 1  5  8  1   42.81   81.49  145.25  207.72  270.33 
             334.28  400.38  469.34  542.77  621.14 
             705.06  794.86  890.70  992.49 1099.30 
            1212.13 1331.59 1874.14 3267.87 
/
 1  6  1  1  193.63  186.36  182.23  181.82  182.90 
             184.72  187.06  189.87  193.10  196.71 
             200.69  205.03  209.70  214.71  220.03 
             225.67  231.62  258.37  325.69 
/
 1  6  2  1  174.91  159.64  147.21  143.23  143.51 
             146.08  150.24  155.31  160.65  166.44 
             172.63  179.18  186.06  193.24  200.71 
             208.45  216.44  250.91  330.69 
/
 1  6  3  1  163.59  142.21  125.47  119.84  120.00 
             123.90  129.87  136.52  143.69  150.89 
             158.21  165.91  174.24  182.82  191.63 
             201.14  210.30  249.77  339.21 
/
 1  6  4  1  155.04  128.20  110.11  105.49  106.26 
             111.86  119.10  126.69  134.34  142.05 
             149.98  158.42  167.61  176.90  186.29 
             195.85  205.27  247.28  342.19 
/
 1  6  5  1  114.45   80.59   72.45   76.69   86.62 
              96.14  105.74  114.56  124.09  133.65 
             143.44  153.37  163.36  173.43  183.64 
             196.34  211.12  268.92  403.36 
/
 1  6  6  1   77.60   59.55   63.34   77.81   92.41 
             107.06  121.70  136.53  151.56  166.79 
             182.28  198.07  214.18  230.60  247.33 
             264.38  281.75  354.31  559.15 
/
 1  6  7  1   55.29   49.79   74.08   98.66  123.75 
             149.11  174.77  200.74  227.00  253.58 
             280.53  307.88  335.69  364.02  392.90 
             422.38  452.48  580.72  934.50 
/
 1  6  8  1   40.60   72.35  127.04  180.81  234.48 
             288.74  344.26  401.47  460.88  522.79 
             588.39  657.75  731.34  809.29  891.77 
             978.67 1069.39 1478.30 2537.66 
/
 1  7  1  1  199.69  193.42  190.45  190.42  191.46 
             193.13  195.29  197.88  200.88  204.25 
             207.99  212.07  216.50  221.25  226.33 
             231.73  237.44  263.33  329.30 
/
 1  7  2  1  182.53  169.45  159.00  156.08  156.51 
             158.80  162.30  166.64  171.29  176.38 
             181.89  187.76  193.99  200.54  207.41 
             214.57  222.01  254.54  332.26 
/
 1  7  3  1  171.52  153.14  137.93  132.67  132.74 
             135.80  140.90  146.67  152.95  159.65 
             166.76  174.23  182.02  190.13  198.07 
             207.16  216.06  253.85  338.23 
/
 1  7  4  1  163.93  140.53  122.90  117.19  117.23 
             121.52  127.86  134.92  142.27  149.72 
             157.33  165.06  173.68  182.92  192.07 
             201.78  211.06  251.31  343.25 
/
 1  7  5  1  127.92   92.20   80.18   81.19   88.98 
              98.31  107.33  115.83  124.67  133.44 
             142.05  152.34  162.63  172.92  184.04 
             194.69  208.65  258.86  380.19 
/
 1  7  6  1   89.78   65.30   64.67   76.21   88.77 
             101.53  114.31  127.03  139.80  152.74 
             165.94  179.42  193.13  207.08  221.30 
             235.80  250.58  312.73  495.05 
/
 1  7  7  1   61.52   50.31   69.17   89.61  110.42 
             131.57  152.98  174.69  196.75  219.20 
             242.00  265.16  288.68  312.57  336.86 
             361.54  386.66  492.36  761.49 
/
 1  7  8  1   40.55   63.83  108.64  153.50  198.13 
             243.07  288.71  335.18  382.89  432.01 
             482.83  535.46  590.21  647.81  708.11 
             771.41  837.86 1133.79 1914.98 
/
 1  8  1  1  206.27  201.15  199.17  199.30  200.28 
             201.83  203.83  206.25  209.05  212.21 
             215.72  219.58  223.77  228.29  233.13 
             238.30  243.78  268.79  333.30 
/
 1  8  2  1  190.97  180.35  172.60  170.94  171.66 
             173.77  176.62  180.23  184.15  188.51 
             193.28  198.42  203.93  209.78  215.96 
             222.46  229.27  259.53  333.58 
/
 1  8  3  1  180.87  165.57  153.12  149.09  149.24 
             151.68  155.84  160.58  165.81  171.49 
             177.59  184.08  190.93  198.11  205.60 
             213.40  221.47  256.46  338.16 
/
 1  8  4  1  173.59  154.44  138.69  133.01  132.96 
             136.05  141.26  147.15  153.58  160.42 
             167.68  175.32  182.96  191.20  199.73 
             208.53  217.60  256.97  343.45 
/
 1  8  5  1  143.53  108.86   92.22   90.68   94.91 
             103.14  111.68  120.32  128.65  136.50 
             145.32  154.75  164.73  175.00  185.63 
             196.15  206.96  254.32  365.10 
/
 1  8  6  1  107.24   75.09   69.59   77.06   87.71 
              98.45  108.89  119.74  130.59  141.43 
             152.37  163.51  174.83  186.32  198.02 
             209.93  222.08  274.02  435.79 
/
 1  8  7  1   71.84   56.92   65.32   82.20   99.02 
             115.83  132.88  150.16  167.70  185.52 
             203.67  222.17  241.04  260.32  279.99 
             300.02  320.41  405.64  602.93 
/
 1  8  8  1   48.43   56.47   90.67  125.91  161.36 
             196.90  232.75  269.14  306.21  344.08 
             382.78  422.39  463.06  504.89  548.07 
             592.58  638.46  840.18 1386.47 
/
 1  9  1  1  213.33  209.51  208.13  208.36  209.33 
             210.80  212.69  214.96  217.59  220.57 
             223.89  227.54  231.52  235.82  240.45 
             245.39  250.66  274.81  337.77 
/
 1  9  2  1  201.15  192.97  188.53  188.00  189.01 
             190.76  193.06  196.00  199.05  202.68 
             206.69  211.08  215.84  220.95  226.44 
             232.60  238.73  266.42  336.16 
/
 1  9  3  1  192.15  180.62  172.04  170.03  170.65 
             172.78  175.74  179.51  183.58  188.11 
             193.05  198.39  204.11  210.18  216.59 
             223.33  230.39  261.64  337.80 
/
 1  9  4  1  185.50  170.83  158.99  155.31  155.49 
             157.81  161.70  166.16  171.13  176.54 
             182.39  188.64  195.26  202.23  209.54 
             217.16  225.09  259.64  341.72 
/
 1  9  5  1  161.47  132.25  113.09  108.16  108.87 
             114.73  122.27  130.14  138.14  146.22 
             154.57  163.04  172.42  182.13  192.08 
             202.06  211.66  255.78  357.75 
/
 1  9  6  1  131.55   94.53   82.04   82.90   90.92 
             100.48  109.87  118.57  127.73  136.89 
             145.73  154.88  166.04  176.44  187.59 
             198.82  210.14  263.39  388.47 
/
 1  9  7  1   92.49   66.83   66.09   77.82   90.64 
             103.73  116.82  129.84  142.85  155.98 
             169.30  182.92  196.79  210.92  225.33 
             240.03  255.03  318.30  478.40 
/
 1  9  8  1   57.55   50.86   75.42  100.08  125.25 
             150.73  176.54  202.78  229.47  256.57 
             284.11  312.14  340.72  369.91  399.74 
             430.22  461.41  593.04  898.64 
/
 1 10  1  1  227.09  226.13  226.14  226.82  227.90 
             229.35  231.12  233.21  235.62  238.35 
             241.38  244.73  248.38  252.35  256.62 
             261.19  266.08  288.68  348.56 
/
 1 10  2  1  227.09  226.13  226.14  226.82  227.90 
             229.35  231.12  233.21  235.62  238.35 
             241.38  244.73  248.38  252.35  256.62 
             261.19  266.08  288.68  348.56 
/
 1 10  3  1  227.09  226.13  226.14  226.82  227.90 
             229.35  231.12  233.21  235.62  238.35 
             241.38  244.73  248.38  252.35  256.62 
             261.19  266.08  288.68  348.56 
/
 1 10  4  1  227.09  226.13  226.14  226.82  227.90 
             229.35  231.12  233.21  235.62  238.35 
             241.38  244.73  248.38  252.35  256.62 
             261.19  266.08  288.68  348.56 
/
 1 10  5  1  227.09  226.13  226.14  226.82  227.90 
             229.35  231.12  233.21  235.62  238.35 
             241.38  244.73  248.38  252.35  256.62 
             261.19  266.08  288.68  348.56 
/
 1 10  6  1  227.09  226.13  226.14  226.82  227.90 
             229.35  231.12  233.21  235.62  238.35 
             241.38  244.73  248.38  252.35  256.62 
             261.19  266.08  288.68  348.56 
/
 1 10  7  1  227.09  226.13  226.14  226.82  227.90 
             229.35  231.12  233.21  235.62  238.35 
             241.38  244.73  248.38  252.35  256.62 
             261.19  266.08  288.68  348.56 
/
 1 10  8  1  227.09  226.13  226.14  226.82  227.90 
             229.35  231.12  233.21  235.62  238.35 
             241.38  244.73  248.38  252.35  256.62 
             261.19  266.08  288.68  348.56 
/
 2  1  1  1  209.64  204.31  201.79  201.78  202.76 
             204.38  206.51  209.07  212.03  215.37 
             219.06  223.10  227.48  232.19  237.22 
             242.56  248.21  273.89  339.48 
/
 2  1  2  1  185.26  174.00  163.52  160.39  161.13 
             164.23  168.40  173.02  178.15  183.76 
             189.81  196.25  203.05  210.20  217.66 
             225.43  233.49  268.46  349.88 
/
 2  1  3  1  174.79  157.45  143.25  138.52  139.68 
             144.55  150.30  156.70  162.83  169.20 
             176.12  184.20  192.69  200.81  209.47 
             218.23  227.79  267.20  361.47 
/
 2  1  4  1  166.35  144.72  130.02  126.46  129.47 
             135.63  142.05  148.48  155.15  162.04 
             169.88  178.61  187.46  196.66  206.20 
             216.10  226.93  271.19  377.23 
/
 2  1  5  1  130.31  106.01  100.10  106.46  116.50 
             127.59  139.29  151.50  163.99  177.00 
             190.51  204.46  218.83  233.59  248.73 
             264.23  280.09  362.43  556.01 
/
 2  1  6  1  102.60   86.49   98.10  116.59  136.95 
             158.87  181.86  205.61  229.88  254.63 
             279.83  305.49  331.62  358.24  385.38 
             413.13  441.68  577.97  943.47 
/
 2  1  7  1   82.22   87.26  121.80  161.54  202.83 
             245.12  288.35  332.57  377.99  424.85 
             473.78  525.54  580.15  638.07  699.55 
             765.00  838.95 1165.40 1992.19 
/
 2  1  8  1   79.46  129.11  221.06  316.41  417.80 
             529.83  654.56  793.25  946.76 1113.33 
            1294.21 1491.21 1703.81 1932.00 2175.91 
            2401.16 2399.09 2398.33 2444.51 
/
 2  2  1  1  213.88  208.84  206.64  206.70  207.69 
             209.29  211.37  213.88  216.78  220.04 
             223.67  227.63  231.93  236.56  241.51 
             246.77  252.35  277.74  342.88 
/
 2  2  2  1  189.95  179.39  169.69  166.95  167.71 
             170.58  174.46  178.80  183.64  188.95 
             194.69  200.84  207.35  214.21  221.39 
             228.89  236.70  271.08  351.30 
/
 2  2  3  1  179.47  163.11  149.15  144.25  145.09 
             149.57  154.96  161.06  167.41  173.71 
             180.26  187.90  196.18  204.52  213.29 
             221.84  231.18  270.35  363.04 
/
 2  2  4  1  171.47  150.60  135.62  131.41  133.57 
             139.32  145.80  152.13  158.53  165.39 
             173.17  181.27  189.96  199.00  208.38 
             218.13  228.25  271.74  374.91 
/
 2  2  5  1  136.21  110.55  102.89  107.98  116.58 
             126.66  137.39  148.58  160.17  172.11 
             184.49  197.28  210.48  224.06  238.01 
             252.32  266.98  344.41  524.91 
/
 2  2  6  1  107.08   90.60   97.21  113.81  132.17 
             151.83  172.63  194.26  216.54  239.32 
             262.54  286.19  310.26  334.76  359.71 
             385.13  411.14  526.81  861.17 
/
 2  2  7  1   86.71   85.77  116.07  151.96  189.57 
             228.14  267.58  307.91  349.17  391.51 
             435.15  480.60  528.27  578.57  631.50 
             687.48  746.70 1036.56 1750.80 
/
 2  2  8  1   77.22  121.20  204.48  290.67  380.78 
             478.25  585.57  703.90  834.15  976.66 
            1129.58 1294.80 1473.37 1665.01 1869.58 
            2087.12 2317.72 2717.75 2733.11 
/
 2  3  1  1  218.24  213.56  211.65  211.77  212.77 
             214.34  216.38  218.83  221.67  224.86 
             228.41  232.30  236.52  241.07  245.94 
             251.13  256.63  281.72  346.37 
/
 2  3  2  1  195.03  185.21  176.45  174.14  174.97 
             177.62  181.21  185.24  189.77  194.77 
             200.19  206.02  212.21  218.76  225.65 
             232.86  240.41  273.70  352.95 
/
 2  3  3  1  184.38  169.17  155.69  150.86  151.41 
             155.52  160.52  166.22  172.40  178.95 
             185.39  192.55  200.33  208.81  217.30 
             226.51  235.32  274.00  364.88 
/
 2  3  4  1  176.88  157.06  141.95  137.16  138.52 
             143.83  150.07  156.55  162.79  169.37 
             176.81  185.26  193.59  202.03  211.26 
             220.85  230.26  272.94  373.24 
/
 2  3  5  1  142.82  115.92  106.36  110.27  117.83 
             126.41  136.12  146.29  156.85  167.88 
             179.17  190.81  202.83  215.23  227.96 
             241.04  254.46  327.05  497.64 
/
 2  3  6  1  112.48   94.16   96.68  111.47  127.95 
             145.38  163.90  183.29  203.38  224.09 
             245.26  266.86  288.87  311.27  334.07 
             357.28  380.93  481.04  779.85 
/
 2  3  7  1   90.05   84.50  110.92  142.55  176.41 
             211.23  246.85  283.26  320.49  358.57 
             397.60  437.69  479.33  522.58  568.01 
             615.68  665.69  909.14 1523.54 
/
 2  3  8  1   75.48  113.44  187.87  265.03  345.04 
             429.37  520.83  620.63  729.62  848.43 
             977.18 1114.31 1261.29 1419.11 1587.73 
            1766.94 1956.65 2821.66 3168.80 
/
 2  4  1  1  222.73  218.48  216.80  216.98  217.98 
             219.53  221.53  223.92  226.70  229.83 
             233.30  237.11  241.26  245.72  250.52 
             255.62  261.05  285.83  349.96 
/
 2  4  2  1  200.63  191.47  183.88  182.03  182.98 
             185.40  188.69  192.41  196.62  201.28 
             206.37  211.86  217.73  223.94  230.50 
             237.41  244.67  276.77  354.70 
/
 2  4  3  1  189.61  175.69  162.93  158.50  158.96 
             162.61  167.18  172.43  178.17  184.43 
             191.17  198.06  205.58  213.47  221.71 
             230.77  239.72  277.27  365.37 
/
 2  4  4  1  182.60  164.13  149.19  143.92  144.66 
             149.48  155.23  161.75  168.11  174.47 
             181.23  189.44  198.08  206.58  215.38 
             224.37  234.19  274.86  372.31 
/
 2  4  5  1  150.22  122.40  110.94  113.03  119.95 
             127.57  135.76  144.88  154.38  164.35 
             174.74  185.35  196.20  207.38  218.89 
             230.73  242.88  310.74  468.95 
/
 2  4  6  1  119.00   97.92   96.86  109.70  124.22 
             139.74  155.94  173.01  190.79  209.19 
             228.15  247.61  267.49  287.75  308.40 
             329.42  350.84  440.85  704.01 
/
 2  4  7  1   94.38   83.67  106.46  133.56  163.40 
             194.43  226.21  258.68  291.87  325.80 
             360.48  395.99  432.39  469.82  508.66 
             548.90  590.92  783.92 1311.18 
/
 2  4  8  1   74.50  105.94  171.26  239.51  309.82 
             383.01  460.15  543.30  633.17  730.39 
             835.41  948.36 1068.32 1195.41 1331.01 
            1475.25 1627.94 2323.00 4093.94 
/
 2  5  1  1  227.35  223.53  222.08  222.32  223.32 
             224.85  226.81  229.15  231.86  234.93 
             238.33  242.07  246.14  250.53  255.24 
             260.27  265.61  290.08  353.66 
/
 2  5  2  1  206.83  198.24  191.99  190.63  191.72 
             193.91  196.72  200.31  204.19  208.52 
             213.27  218.41  223.93  229.80  236.03 
             242.62  249.55  280.38  356.39 
/
 2  5  3  1  195.23  182.74  171.10  167.33  167.83 
             170.94  175.17  179.94  185.19  190.95 
             197.18  203.84  210.90  218.35  226.15 
             234.29  242.76  279.47  364.66 
/
 2  5  4  1  188.66  171.86  157.47  152.04  152.39 
             156.67  161.87  167.83  174.28  180.76 
             187.36  194.73  203.07  211.50  220.70 
             229.64  238.59  278.52  373.58 
/
 2  5  5  1  158.48  130.30  116.96  116.57  123.33 
             130.16  137.49  144.79  153.19  162.05 
             171.40  181.04  190.93  200.99  211.28 
             221.85  237.37  299.45  442.34 
/
 2  5  6  1  126.98  103.14   98.65  108.78  121.32 
             134.88  149.08  163.78  179.17  195.17 
             211.72  228.78  246.35  264.38  282.81 
             301.62  320.80  401.16  631.59 
/
 2  5  7  1   99.91   84.58  102.70  125.49  150.84 
             177.82  205.71  234.26  263.41  293.16 
             323.57  354.65  386.43  418.95  452.28 
             486.49  521.77  676.28 1117.54 
/
 2  5  8  1   74.99   98.91  154.74  214.02  274.90 
             337.76  403.13  471.57  544.60  622.67 
             706.35  795.95  891.68  993.39 1100.14 
            1212.95 1332.34 1875.38 3269.46 
/
 2  6  1  1  232.07  228.71  227.48  227.79  228.80 
             230.30  232.22  234.52  237.17  240.17 
             243.50  247.17  251.16  255.48  260.11 
             265.06  270.32  294.48  357.48 
/
 2  6  2  1  213.75  205.75  200.82  199.99  201.15 
             203.12  205.68  208.94  212.51  216.40 
             220.70  225.52  230.88  236.41  242.31 
             248.55  255.12  284.62  358.27 
/
 2  6  3  1  201.60  190.57  180.58  177.65  178.29 
             181.02  184.75  188.99  193.72  198.94 
             204.62  210.73  217.23  224.13  231.38 
             238.98  246.92  281.81  364.69 
/
 2  6  4  1  195.10  180.32  166.94  161.96  162.21 
             165.85  170.45  175.77  181.58  187.93 
             194.77  202.06  209.46  217.51  225.94 
             235.22  244.40  283.09  373.68 
/
 2  6  5  1  167.71  140.02  124.93  122.46  127.84 
             134.64  141.21  148.12  155.40  161.67 
             169.97  179.16  190.21  200.91  211.86 
             223.52  234.61  289.58  420.10 
/
 2  6  6  1  136.82  110.08  103.08  109.31  119.66 
             131.19  143.39  156.11  169.13  182.67 
             196.77  211.39  226.46  241.97  257.91 
             274.26  291.02  361.64  565.80 
/
 2  6  7  1  106.87   89.52   99.86  118.77  139.52 
             161.94  185.54  210.01  235.10  260.75 
             286.93  313.62  340.87  368.71  397.17 
             426.28  456.07  583.37  937.66 
/
 2  6  8  1   79.03   92.93  138.52  188.55  240.19 
             293.17  347.79  404.36  463.28  524.82 
             590.12  659.24  732.62  810.44  892.83 
             979.66 1070.31 1479.12 2539.33 
/
 2  7  1  1  236.91  234.01  233.02  233.38  234.40 
             235.88  237.77  240.02  242.62  245.55 
             248.82  252.42  256.34  260.58  265.13 
             270.00  275.19  299.03  361.42 
/
 2  7  2  1  221.45  214.18  210.46  210.18  211.27 
             213.05  215.37  218.18  221.43  225.10 
             229.19  233.82  238.65  243.84  249.38 
             255.26  261.48  289.58  360.68 
/
 2  7  3  1  209.24  199.53  191.72  189.71  190.61 
             192.97  195.99  199.90  204.07  208.71 
             213.80  219.31  225.21  231.50  238.15 
             245.16  252.51  285.15  365.08 
/
 2  7  4  1  202.14  189.65  177.99  174.15  174.57 
             177.50  181.56  186.18  191.27  196.89 
             202.98  209.52  216.48  223.84  231.57 
             239.67  248.11  285.09  371.22 
/
 2  7  5  1  177.99  151.98  135.52  131.33  134.43 
             140.93  147.61  154.12  160.75  167.32 
             175.21  184.78  194.40  204.05  214.47 
             224.90  235.72  284.08  401.78 
/
 2  7  6  1  148.97  119.74  109.18  113.00  120.70 
             129.56  139.65  150.23  161.23  172.60 
             184.32  196.41  208.91  221.78  235.05 
             248.70  262.73  322.50  503.45 
/
 2  7  7  1  116.64   96.58   98.33  113.45  130.29 
             148.05  166.93  186.74  207.32  228.60 
             250.47  272.83  295.66  318.97  342.74 
             366.97  391.68  496.12  764.90 
/
 2  7  8  1   86.81   88.37  122.99  163.43  205.57 
             248.92  293.46  339.14  386.22  434.85 
             485.28  537.58  592.08  649.46  709.56 
             772.74  839.09 1134.81 1918.03 
/
 2  8  1  1  241.85  239.43  238.67  239.10  240.13 
             241.60  243.45  245.65  248.20  251.08 
             254.28  257.81  261.66  265.83  270.31 
             275.10  280.21  303.73  365.50 
/
 2  8  2  1  229.87  223.66  221.04  221.07  222.06 
             223.69  225.82  228.40  231.44  234.87 
             238.64  242.78  247.28  252.12  257.31 
             262.84  268.70  295.37  363.77 
/
 2  8  3  1  218.80  210.10  204.71  203.70  204.83 
             206.80  209.36  212.72  216.34  220.41 
             224.91  229.80  235.09  240.75  246.77 
             253.15  259.88  290.08  365.63 
/
 2  8  4  1  210.86  200.48  191.79  189.37  190.14 
             192.59  195.93  199.79  204.11  208.91 
             214.18  219.88  225.99  232.49  239.37 
             246.62  254.21  287.94  370.07 
/
 2  8  5  1  189.49  166.68  149.89  144.17  144.89 
             150.38  156.86  163.74  170.27  177.03 
             184.00  192.74  201.72  210.20  219.83 
             229.86  240.31  284.57  390.85 
/
 2  8  6  1  163.98  133.76  119.56  118.93  125.91 
             132.99  140.56  148.10  156.84  165.94 
             175.56  185.52  195.77  206.20  216.82 
             227.74  238.96  295.25  448.90 
/
 2  8  7  1  130.91  105.54  100.72  110.63  123.48 
             137.36  151.88  166.86  182.49  198.78 
             215.65  233.09  251.06  269.55  288.54 
             307.98  327.84  411.42  608.96 
/
 2  8  8  1   95.48   85.11  110.08  139.45  171.69 
             205.20  239.61  274.92  311.16  348.36 
             386.53  425.71  466.01  507.52  550.43 
             594.69  640.36  841.62 1387.64 
/
 2  9  1  1  246.90  244.96  244.44  244.95  245.99 
             247.44  249.26  251.43  253.92  256.75 
             259.89  263.35  267.13  271.23  275.64 
             280.36  285.39  308.59  369.73 
/
 2  9  2  1  238.95  234.19  232.42  232.56  233.52 
             235.04  237.01  239.39  242.16  245.29 
             248.77  252.61  256.79  261.31  266.16 
             271.35  276.86  302.12  367.69 
/
 2  9  3  1  230.53  223.32  219.99  219.88  220.86 
             222.51  224.69  227.55  230.68  234.22 
             238.15  242.46  247.14  252.18  257.57 
             263.31  269.39  297.02  367.59 
/
 2  9  4  1  223.24  214.36  209.19  208.28  209.39 
             211.29  213.78  217.07  220.61  224.60 
             229.02  233.85  239.06  244.66  250.62 
             256.95  263.63  293.73  369.24 
/
 2  9  5  1  202.47  184.95  169.86  163.60  163.49 
             167.28  172.24  177.97  184.26  191.09 
             198.45  205.71  213.57  221.75  231.11 
             240.44  250.73  291.34  389.25 
/
 2  9  6  1  182.43  154.83  137.59  133.17  136.36 
             143.10  150.06  156.77  163.56  170.35 
             177.67  186.54  195.87  205.84  217.38 
             228.49  239.52  288.74  408.50 
/
 2  9  7  1  152.41  121.86  110.78  114.78  122.81 
             131.81  142.22  153.12  164.40  176.05 
             187.96  200.24  212.91  225.95  239.38 
             253.20  267.43  328.27  489.55 
/
 2  9  8  1  109.83   91.77  101.52  120.77  141.64 
             164.03  187.67  212.31  237.79  263.93 
             290.69  318.03  346.04  374.73  404.12 
             434.23  465.09  595.72  900.45 
/
 2 10  1  1  257.23  256.27  256.28  256.95  258.04 
             259.48  261.25  263.35  265.76  268.48 
             271.51  274.85  278.51  282.47  286.73 
             291.31  296.19  318.78  378.61 
/
 2 10  2  1  257.23  256.27  256.28  256.95  258.04 
             259.48  261.25  263.35  265.76  268.48 
             271.51  274.85  278.51  282.47  286.73 
             291.31  296.19  318.78  378.61 
/
 2 10  3  1  257.23  256.27  256.28  256.95  258.04 
             259.48  261.25  263.35  265.76  268.48 
             271.51  274.85  278.51  282.47  286.73 
             291.31  296.19  318.78  378.61 
/
 2 10  4  1  257.23  256.27  256.28  256.95  258.04 
             259.48  261.25  263.35  265.76  268.48 
             271.51  274.85  278.51  282.47  286.73 
             291.31  296.19  318.78  378.61 
/
 2 10  5  1  257.23  256.27  256.28  256.95  258.04 
             259.48  261.25  263.35  265.76  268.48 
             271.51  274.85  278.51  282.47  286.73 
             291.31  296.19  318.78  378.61 
/
 2 10  6  1  257.23  256.27  256.28  256.95  258.04 
             259.48  261.25  263.35  265.76  268.48 
             271.51  274.85  278.51  282.47  286.73 
             291.31  296.19  318.78  378.61 
/
 2 10  7  1  257.23  256.27  256.28  256.95  258.04 
             259.48  261.25  263.35  265.76  268.48 
             271.51  274.85  278.51  282.47  286.73 
             291.31  296.19  318.78  378.61 
/
 2 10  8  1  257.23  256.27  256.28  256.95  258.04 
             259.48  261.25  263.35  265.76  268.48 
             271.51  274.85  278.51  282.47  286.73 
             291.31  296.19  318.78  378.61 
/
 3  1  1  1  222.12  217.96  216.11  216.21  217.18 
             218.73  220.74  223.17  225.98  229.15 
             232.66  236.52  240.71  245.22  250.06 
             255.21  260.67  285.62  350.02 
/
 3  1  2  1  197.26  187.93  179.75  177.60  178.68 
             181.43  185.12  189.21  193.82  198.91 
             204.43  210.36  216.66  223.32  230.31 
             237.66  245.36  279.23  359.41 
/
 3  1  3  1  186.65  171.94  159.22  154.75  156.04 
             160.44  165.61  171.46  177.71  183.86 
             190.32  198.07  205.98  214.60  222.91 
             231.39  240.87  280.35  374.73 
/
 3  1  4  1  179.01  159.98  146.08  142.04  144.71 
             150.24  156.50  162.53  168.74  175.44 
             183.42  191.46  200.15  209.23  218.27 
             228.06  238.25  282.27  387.34 
/
 3  1  5  1  145.65  121.45  114.16  118.82  127.42 
             137.52  148.40  159.90  171.89  184.37 
             197.36  210.86  224.85  239.27  254.11 
             269.34  284.95  366.86  559.07 
/
 3  1  6  1  117.95  101.57  108.43  125.31  144.35 
             165.14  187.30  210.42  234.20  258.54 
             283.41  308.77  334.65  361.04  387.99 
             415.58  444.00  581.38  944.77 
/
 3  1  7  1   96.80   97.32  128.70  166.64  206.84 
             248.40  291.11  334.95  380.06  426.70 
             475.45  527.07  581.57  639.38  700.79 
             766.16  840.03 1166.16 1992.64 
/
 3  1  8  1   89.16  134.78  224.15  318.50  419.38 
             531.10  655.61  794.14  947.51 1113.95 
            1294.79 1491.73 1704.19 1932.31 2176.15 
            2401.33 2399.20 2398.86 2444.93 
/
 3  2  1  1  226.12  222.23  220.58  220.75  221.73 
             223.28  225.27  227.66  230.43  233.55 
             237.02  240.83  244.96  249.42  254.20 
             259.30  264.71  289.44  353.48 
/
 3  2  2  1  202.19  193.21  185.88  184.06  185.19 
             187.73  191.18  195.03  199.39  204.21 
             209.47  215.13  221.16  227.56  234.30 
             241.41  248.87  281.78  361.09 
/
 3  2  3  1  191.13  177.32  165.00  160.67  161.71 
             165.79  170.62  176.12  182.14  188.53 
             194.83  202.15  210.16  218.28  226.75 
             235.38  244.09  282.93  374.80 
/
 3  2  4  1  183.89  165.66  151.67  147.14  149.14 
             154.29  160.39  166.57  172.59  179.01 
             186.64  194.86  203.12  212.04  220.93 
             230.59  240.08  283.34  385.57 
/
 3  2  5  1  151.42  126.22  117.27  121.21  128.24 
             137.20  147.09  157.57  168.57  180.08 
             191.96  204.31  217.08  230.31  243.94 
             257.96  272.37  349.29  530.02 
/
 3  2  6  1  122.69  104.96  107.98  123.04  140.22 
             158.71  178.62  199.57  221.33  243.67 
             266.52  289.86  313.65  337.92  362.65 
             387.90  413.75  530.42  862.67 
/
 3  2  7  1  100.83   96.21  123.60  157.56  194.01 
             231.80  270.68  310.58  351.51  393.59 
             437.02  482.31  529.86  580.03  632.87 
             688.76  747.92 1037.44 1751.39 
/
 3  2  8  1   87.35  127.35  207.92  293.00  382.53 
             479.66  586.74  704.89  835.01  977.39 
            1130.20 1295.39 1473.90 1665.42 1869.91 
            2087.39 2317.93 2718.13 2733.58 
/
 3  3  1  1  230.24  226.64  225.18  225.42  226.42 
             227.95  229.92  232.28  235.00  238.08 
             241.50  245.25  249.33  253.74  258.46 
             263.50  268.85  293.37  357.02 
/
 3  3  2  1  207.53  198.90  192.52  191.05  192.25 
             194.60  197.79  201.40  205.49  210.04 
             215.02  220.40  226.16  232.28  238.77 
             245.62  252.80  284.69  362.92 
/
 3  3  3  1  195.89  183.10  171.35  167.42  168.31 
             172.02  176.49  181.61  187.25  193.41 
             200.06  207.15  214.66  222.55  230.81 
             239.42  248.36  285.96  375.20 
/
 3  3  4  1  189.04  171.84  157.97  153.05  154.49 
             159.24  164.91  171.30  177.31  183.66 
             190.64  198.80  207.11  215.64  224.26 
             233.77  243.12  285.03  384.49 
/
 3  3  5  1  157.82  131.85  121.20  123.84  130.29 
             137.68  146.51  155.96  165.89  176.43 
             187.34  198.55  210.17  222.18  234.56 
             247.33  260.48  332.94  501.45 
/
 3  3  6  1  128.31  108.39  108.11  121.25  136.51 
             152.99  170.56  189.22  208.73  228.96 
             249.74  271.00  292.72  314.86  337.43 
             360.44  383.93  483.50  783.79 
/
 3  3  7  1  104.54   95.29  119.19  148.73  181.37 
             215.35  250.35  286.30  323.17  360.95 
             399.74  439.64  481.12  524.24  569.57 
             617.13  667.06  910.74 1524.22 
/
 3  3  8  1   86.25  120.16  191.71  267.67  347.03 
             430.96  522.15  621.76  730.60  849.29 
             977.92 1114.94 1261.89 1419.66 1588.24 
            1767.31 1956.97 2821.80 3169.32 
/
 3  4  1  1  234.49  231.18  229.92  230.21  231.22 
             232.74  234.69  237.01  239.69  242.73 
             246.09  249.79  253.82  258.17  262.83 
             267.82  273.11  297.40  360.65 
/
 3  4  2  1  213.38  205.12  199.68  198.60  199.84 
             202.00  204.96  208.31  212.15  216.43 
             221.13  226.22  231.69  237.55  243.77 
             250.33  257.23  288.04  364.47 
/
 3  4  3  1  200.95  189.32  178.50  175.11  175.95 
             179.15  183.38  188.09  193.32  199.06 
             205.27  211.93  219.01  226.47  234.30 
             242.48  251.00  287.76  374.32 
/
 3  4  4  1  194.48  178.57  165.08  160.04  160.93 
             165.35  170.54  176.46  182.91  189.21 
             195.56  203.46  211.54  220.37  229.05 
             237.82  246.90  287.37  383.95 
/
 3  4  5  1  164.91  138.51  126.22  126.99  133.33 
             140.02  147.00  155.36  164.22  173.68 
             183.60  193.86  204.35  215.15  226.31 
             237.82  249.67  319.41  475.01 
/
 3  4  6  1  134.97  112.69  109.14  120.12  133.46 
             148.05  163.41  179.68  196.83  214.71 
             233.24  252.33  271.89  291.88  312.28 
             333.09  354.32  443.72  706.07 
/
 3  4  7  1  109.24   95.49  115.39  140.51  168.99 
             199.12  230.24  262.20  294.98  328.58 
             362.99  398.26  434.48  471.75  510.46 
             550.58  592.51  786.67 1311.97 
/
 3  4  8  1   86.07  113.31  175.62  242.54  312.11 
             384.84  461.67  544.60  634.30  731.39 
             836.29  949.14 1069.00 1196.01 1331.60 
            1475.79 1628.44 2323.22 4094.51 
/
 3  5  1  1  238.84  235.86  234.77  235.12  236.14 
             237.65  239.57  241.86  244.50  247.49 
             250.81  254.45  258.42  262.71  267.32 
             272.25  277.49  301.54  364.35 
/
 3  5  2  1  219.72  211.93  207.40  206.76  207.98 
             209.96  212.68  215.78  219.16  223.14 
             227.56  232.62  237.82  243.39  249.32 
             255.59  262.19  291.86  366.13 
/
 3  5  3  1  206.64  196.13  186.67  183.92  184.81 
             187.65  191.46  195.75  200.53  205.82 
             211.57  217.76  224.36  231.35  238.72 
             246.44  254.50  289.97  374.08 
/
 3  5  4  1  200.23  185.89  173.12  168.32  169.02 
             172.91  177.60  183.00  188.91  195.37 
             202.11  209.22  216.99  225.17  234.16 
             243.14  252.37  291.41  385.56 
/
 3  5  5  1  172.77  146.48  132.62  131.05  137.28 
             143.51  150.15  156.28  163.99  172.32 
             181.20  190.40  199.90  209.68  219.65 
             233.96  247.91  306.76  449.03 
/
 3  5  6  1  142.98  118.37  112.40  120.07  131.33 
             143.92  157.38  171.39  186.09  201.52 
             217.59  234.27  251.49  269.22  287.39 
             305.96  324.92  404.58  636.03 
/
 3  5  7  1  115.15   98.01  112.34  133.40  157.26 
             183.22  210.38  238.38  267.08  296.47 
             326.56  357.38  388.94  421.27  454.43 
             488.50  523.66  677.82 1118.52 
/
 3  5  8  1   88.24  107.12  159.76  217.55  277.60 
             339.93  404.93  473.10  545.94  623.86 
             707.41  796.90  892.54  994.16 1100.81 
            1213.56 1332.94 1875.74 3269.97 
/
 3  6  1  1  243.32  240.65  239.75  240.15  241.18 
             242.68  244.57  246.82  249.43  252.37 
             255.64  259.23  263.14  267.38  271.93 
             276.80  281.98  305.79  368.15 
/
 3  6  2  1  226.57  219.43  215.76  215.54  216.66 
             218.49  220.88  223.75  227.07  230.86 
             235.12  239.66  244.57  249.84  255.47 
             261.44  267.74  296.24  368.31 
/
 3  6  3  1  213.45  203.81  196.09  194.03  195.08 
             197.57  200.94  204.78  209.10  213.91 
             219.16  224.85  230.95  237.43  244.28 
             251.50  259.06  292.61  374.45 
/
 3  6  4  1  206.41  193.89  182.26  178.31  178.97 
             182.19  186.48  191.29  196.61  202.45 
             208.80  215.60  222.84  230.49  238.52 
             246.93  255.69  293.60  382.54 
/
 3  6  5  1  181.47  156.06  140.99  137.68  142.27 
             148.76  154.90  161.04  167.60  174.77 
             183.31  192.23  201.94  212.14  222.22 
             234.16  246.65  298.79  427.54 
/
 3  6  6  1  152.66  125.81  117.31  121.82  130.69 
             141.20  152.58  164.62  177.11  190.11 
             203.70  217.86  232.55  247.73  263.36 
             279.44  295.95  365.80  568.88 
/
 3  6  7  1  122.59  104.66  110.29  127.58  147.04 
             168.32  191.07  214.92  239.51  264.75 
             290.59  316.99  343.98  371.59  399.85 
             428.79  458.43  585.26  938.97 
/
 3  6  8  1   92.99  102.16  144.39  192.77  243.46 
             295.82  350.01  406.25  464.93  526.28 
             591.43  660.42  733.69  811.42  893.72 
             980.47 1071.05 1479.70 2539.54 
/
 3  7  1  1  247.90  245.57  244.84  245.30  246.34 
             247.82  249.69  251.91  254.47  257.36 
             260.58  264.13  267.99  272.17  276.66 
             281.47  286.59  310.16  372.04 
/
 3  7  2  1  234.01  227.63  224.83  224.87  225.91 
             227.61  229.84  232.56  235.67  239.18 
             243.07  247.33  251.96  256.94  262.27 
             267.94  273.94  301.23  370.99 
/
 3  7  3  1  221.63  212.71  206.84  205.58  206.78 
             208.92  211.67  215.27  219.12  223.44 
             228.19  233.36  238.93  244.88  251.20 
             257.88  264.91  296.38  374.73 
/
 3  7  4  1  213.49  202.77  193.26  190.40  191.23 
             193.96  197.64  201.82  206.50  211.68 
             217.34  223.45  229.98  236.91  244.24 
             251.93  259.99  295.61  380.72 
/
 3  7  5  1  191.13  167.62  151.77  146.94  149.56 
             155.50  162.17  168.55  174.86  181.52 
             189.19  197.76  206.82  216.26  226.11 
             236.89  247.67  295.37  410.28 
/
 3  7  6  1  164.38  135.94  124.22  126.73  133.31 
             140.91  150.10  159.95  170.31  181.20 
             192.53  204.19  216.28  228.79  241.69 
             255.02  268.77  327.67  509.13 
/
 3  7  7  1  132.80  111.08  109.87  123.31  138.95 
             155.78  173.71  192.78  212.77  233.57 
             255.04  277.06  299.61  322.65  346.20 
             370.22  394.75  498.61  767.64 
/
 3  7  8  1  101.48   98.49  130.04  168.64  209.67 
             252.28  296.29  341.58  388.36  436.74 
             486.98  539.11  593.47  650.74  710.74 
             773.83  840.11 1135.55 1918.44 
/
 3  8  1  1  252.59  250.60  250.05  250.56  251.61 
             253.08  254.92  257.11  259.63  262.48 
             265.65  269.14  272.95  277.07  281.51 
             286.26  291.32  314.65  376.04 
/
 3  8  2  1  242.04  236.62  234.61  234.72  235.72 
             237.31  239.38  241.87  244.77  248.04 
             251.68  255.67  260.03  264.72  269.76 
             275.14  280.84  306.92  374.26 
/
 3  8  3  1  231.34  223.40  219.20  218.80  219.91 
             221.75  224.15  227.29  230.71  234.55 
             238.81  243.46  248.50  253.92  259.69 
             265.83  272.30  301.58  375.66 
/
 3  8  4  1  222.98  213.44  206.78  205.12  206.26 
             208.49  211.35  215.10  219.09  223.57 
             228.50  233.85  239.62  245.78  252.33 
             259.25  266.52  299.08  379.66 
/
 3  8  5  1  201.89  181.58  165.94  159.95  160.71 
             165.66  171.57  178.33  184.78  191.17 
             197.90  206.13  215.10  224.30  232.99 
             242.97  252.80  296.98  402.51 
/
 3  8  6  1  178.58  150.15  135.39  133.46  139.91 
             146.36  153.23  159.58  167.64  176.17 
             185.32  194.86  204.70  214.85  225.19 
             235.79  246.70  305.39  455.75 
/
 3  8  7  1  147.19  120.94  114.45  121.98  133.55 
             146.47  160.26  174.58  189.54  205.25 
             221.65  238.67  256.27  274.45  293.17 
             312.37  332.02  414.90  611.56 
/
 3  8  8  1  110.50   96.68  118.81  146.16  177.05 
             209.69  243.45  278.26  314.11  351.01 
             388.92  427.88  467.99  509.34  552.12 
             596.25  641.82  842.76 1388.33 
/
 3  9  1  1  257.40  255.74  255.38  255.93  256.99 
             258.45  260.27  262.42  264.91  267.71 
             270.84  274.28  278.03  282.10  286.48 
             291.17  296.17  319.26  380.14 
/
 3  9  2  1  250.34  246.29  244.82  245.05  246.02 
             247.52  249.46  251.78  254.49  257.55 
             260.96  264.71  268.81  273.24  278.00 
             283.09  288.50  313.37  378.23 
/
 3  9  3  1  242.70  236.17  233.59  233.57  234.54 
             236.13  238.23  240.98  243.99  247.39 
             251.19  255.35  259.88  264.77  270.00 
             275.59  281.51  308.51  378.00 
/
 3  9  4  1  235.61  227.50  223.34  222.99  224.05 
             225.84  228.18  231.29  234.66  238.45 
             242.66  247.27  252.27  257.65  263.39 
             269.50  275.96  305.21  379.31 
/
 3  9  5  1  214.00  198.72  185.17  179.57  179.76 
             183.38  187.89  193.15  198.94  205.28 
             212.16  219.54  227.38  235.68  244.40 
             253.52  263.04  304.01  399.78 
/
 3  9  6  1  195.79  170.62  153.92  148.82  151.46 
             157.63  164.40  170.76  177.18  183.81 
             191.00  199.83  209.39  219.41  229.49 
             239.96  250.86  299.05  418.99 
/
 3  9  7  1  168.06  138.22  125.93  128.53  135.45 
             143.18  152.68  162.85  173.51  184.61 
             196.19  208.07  220.34  233.03  246.11 
             259.61  273.56  333.53  495.86 
/
 3  9  8  1  125.86  106.86  112.01  129.68  149.37 
             170.60  193.36  217.33  242.30  268.03 
             294.44  321.49  349.23  377.69  406.87 
             436.81  467.50  597.64  901.77 
/
 3 10  1  1  267.28  266.31  266.33  267.00  268.09 
             269.53  271.30  273.39  275.80  278.52 
             281.56  284.90  288.55  292.51  296.77 
             301.35  306.23  328.81  388.63 
/
 3 10  2  1  267.28  266.31  266.33  267.00  268.09 
             269.53  271.30  273.39  275.80  278.52 
             281.56  284.90  288.55  292.51  296.77 
             301.35  306.23  328.81  388.63 
/
 3 10  3  1  267.28  266.31  266.33  267.00  268.09 
             269.53  271.30  273.39  275.80  278.52 
             281.56  284.90  288.55  292.51  296.77 
             301.35  306.23  328.81  388.63 
/
 3 10  4  1  267.28  266.31  266.33  267.00  268.09 
             269.53  271.30  273.39  275.80  278.52 
             281.56  284.90  288.55  292.51  296.77 
             301.35  306.23  328.81  388.63 
/
 3 10  5  1  267.28  266.31  266.33  267.00  268.09 
             269.53  271.30  273.39  275.80  278.52 
             281.56  284.90  288.55  292.51  296.77 
             301.35  306.23  328.81  388.63 
/
 3 10  6  1  267.28  266.31  266.33  267.00  268.09 
             269.53  271.30  273.39  275.80  278.52 
             281.56  284.90  288.55  292.51  296.77 
             301.35  306.23  328.81  388.63 
/
 3 10  7  1  267.28  266.31  266.33  267.00  268.09 
             269.53  271.30  273.39  275.80  278.52 
             281.56  284.90  288.55  292.51  296.77 
             301.35  306.23  328.81  388.63 
/
 3 10  8  1  267.28  266.31  266.33  267.00  268.09 
             269.53  271.30  273.39  275.80  278.52 
             281.56  284.90  288.55  292.51  296.77 
             301.35  306.23  328.81  388.63 
/
 4  1  1  1  244.75  242.31  241.29  241.63  242.66 
             244.18  246.11  248.42  251.09  254.10 
             257.43  261.10  265.09  269.40  274.03 
             278.97  284.23  308.34  371.27 
/
 4  1  2  1  222.48  214.89  210.19  209.57  210.96 
             213.15  216.15  219.56  223.31  227.60 
             232.57  237.78  243.37  249.34  255.67 
             262.36  269.39  300.84  379.47 
/
 4  1  3  1  208.93  198.27  188.54  185.83  187.58 
             191.14  195.45  200.33  205.78  211.78 
             218.27  225.22  232.61  240.42  248.60 
             257.16  265.91  303.90  395.40 
/
 4  1  4  1  202.32  187.60  175.68  171.72  174.38 
             178.99  184.55  190.62  196.41  202.62 
             210.09  218.27  226.29  234.72  244.01 
             253.26  262.83  306.02  409.48 
/
 4  1  5  1  173.46  150.68  141.76  145.07  151.22 
             159.21  168.56  178.72  189.66  201.21 
             213.26  225.87  239.02  252.73  266.96 
             281.65  296.77  380.37  570.51 
/
 4  1  6  1  146.86  129.11  130.65  144.63  161.43 
             179.98  200.43  222.24  244.96  268.41 
             292.51  317.22  342.51  368.41  394.92 
             422.17  450.28  588.23  951.10 
/
 4  1  7  1  124.97  118.80  144.92  179.19  216.99 
             256.87  298.38  341.30  385.68  431.80 
             480.14  531.44  585.65  643.24  704.46 
             769.67  844.20 1168.68 1994.41 
/
 4  1  8  1  110.06  148.52  232.21  324.14  423.76 
             534.74  658.73  796.87  949.92 1116.04 
            1296.66 1493.38 1705.70 1933.63 2177.32 
            2402.37 2400.05 2399.36 2391.09 
/
 4  2  1  1  248.53  246.20  245.31  245.70  246.76 
             248.28  250.20  252.50  255.14  258.13 
             261.44  265.09  269.05  273.33  277.93 
             282.84  288.06  312.06  374.76 
/
 4  2  2  1  227.48  220.20  215.99  215.62  216.93 
             219.02  221.71  224.93  228.65  232.96 
             237.58  242.58  247.97  253.73  259.85 
             266.33  273.15  303.79  381.50 
/
 4  2  3  1  213.41  203.29  194.34  191.90  193.51 
             196.64  200.83  205.42  210.56  216.23 
             222.39  229.01  236.06  243.52  251.37 
             259.59  268.17  305.21  394.30 
/
 4  2  4  1  206.84  192.90  181.18  177.14  179.28 
             183.67  188.85  194.66  200.84  207.01 
             214.05  221.80  229.98  238.31  247.34 
             256.46  265.91  307.83  408.67 
/
 4  2  5  1  178.92  155.70  145.45  147.96  153.41 
             160.05  168.38  177.51  187.40  197.99 
             209.04  220.53  232.53  244.99  257.93 
             271.37  285.26  364.26  542.20 
/
 4  2  6  1  151.82  132.44  131.16  143.26  158.19 
             174.78  192.87  212.42  233.05  254.46 
             276.52  299.16  322.36  346.08  370.35 
             395.21  420.72  537.84  867.09 
/
 4  2  7  1  128.37  118.32  141.05  171.12  205.13 
             241.14  278.72  317.64  357.78  399.23 
             442.20  487.09  534.35  584.25  636.87 
             692.58  751.58 1041.00 1753.34 
/
 4  2  8  1  109.29  142.08  216.77  299.23  387.32 
             483.64  590.16  707.89  837.68  979.77 
            1132.30 1297.28 1475.60 1666.98 1871.31 
            2088.65 2319.05 2718.71 2748.44 
/
 4  3  1  1  252.42  250.22  249.45  249.89  250.95 
             252.47  254.39  256.67  259.29  262.25 
             265.55  269.16  273.09  277.34  281.91 
             286.79  291.98  315.84  378.31 
/
 4  3  2  1  232.82  225.88  222.19  222.05  223.29 
             225.27  227.84  230.95  234.57  238.56 
             242.95  247.75  252.93  258.48  264.39 
             270.65  277.26  307.05  382.71 
/
 4  3  3  1  218.44  208.75  200.80  198.70  200.22 
             203.08  206.96  211.24  216.05  221.39 
             227.20  233.46  240.15  247.24  254.73 
             262.58  270.80  306.89  393.65 
/
 4  3  4  1  211.62  198.63  187.29  183.39  185.19 
             189.22  194.01  199.44  205.45  212.05 
             218.51  225.99  234.25  242.67  251.44 
             260.26  269.58  310.17  408.33 
/
 4  3  5  1  184.91  161.48  149.99  150.97  156.52 
             162.09  169.11  177.20  186.01  195.57 
             205.64  216.13  226.96  238.24  249.96 
             262.09  276.00  348.93  514.51 
/
 4  3  6  1  157.56  136.36  132.48  142.50  155.55 
             170.31  186.15  203.30  221.61  240.84 
             260.79  281.33  302.41  323.99  346.06 
             368.64  391.76  490.13  788.85 
/
 4  3  7  1  132.62  118.78  137.74  163.48  193.57 
             225.74  259.35  294.22  330.24  367.33 
             405.55  445.00  486.12  528.94  574.02 
             621.35  671.09  914.08 1526.48 
/
 4  3  8  1  109.32  136.00  201.52  274.64  352.42 
             435.39  525.94  625.09  733.57  851.97 
             980.33 1117.10 1263.85 1421.43 1589.85 
            1768.82 1958.34 2822.63 3170.38 
/
 4  4  1  1  256.42  254.36  253.69  254.18  255.25 
             256.77  258.67  260.94  263.54  266.47 
             269.73  273.32  277.22  281.44  285.97 
             290.82  295.97  319.70  381.90 
/
 4  4  2  1  238.53  231.98  228.82  228.85  230.04 
             231.95  234.40  237.34  240.72  244.52 
             248.72  253.31  258.28  263.61  269.31 
             275.35  281.74  310.65  384.08 
/
 4  4  3  1  224.16  214.86  207.99  206.30  207.79 
             210.39  213.95  217.90  222.38  227.35 
             232.79  238.67  244.98  251.69  258.79 
             266.26  274.09  308.87  393.53 
/
 4  4  4  1  216.69  204.83  194.10  190.64  192.19 
             195.83  200.21  205.22  210.80  216.93 
             223.59  230.73  238.33  246.37  254.82 
             263.68  272.80  312.18  406.51 
/
 4  4  5  1  191.47  168.21  155.54  154.62  160.50 
             165.78  171.32  178.11  185.81  194.34 
             203.35  212.80  222.66  232.78  243.27 
             256.50  272.32  336.33  489.10 
/
 4  4  6  1  164.26  141.27  135.54  142.65  153.73 
             166.51  180.46  195.27  211.11  227.93 
             245.54  263.87  282.77  302.18  322.07 
             342.42  363.24  451.29  713.94 
/
 4  4  7  1  137.90  121.06  135.06  156.80  182.47 
             210.71  240.40  271.21  303.05  335.88 
             369.67  404.41  440.17  477.09  515.49 
             555.35  597.07  790.58 1317.10 
/
 4  4  8  1  111.19  130.39  186.58  250.44  318.26 
             389.86  465.96  548.35  637.65  734.41 
             839.05  951.66 1071.26 1198.10 1333.52 
            1477.55 1630.06 2324.40 4095.26 
/
 4  5  1  1  260.52  258.61  258.05  258.57  259.65 
             261.16  263.05  265.29  267.87  270.78 
             274.01  277.57  281.44  285.62  290.12 
             294.93  300.05  323.64  385.54 
/
 4  5  2  1  244.63  238.51  235.92  236.04  237.17 
             238.96  241.27  244.05  247.26  250.88 
             254.89  259.28  264.04  269.16  274.64 
             280.46  286.63  314.65  386.28 
/
 4  5  3  1  230.58  221.79  215.98  214.79  216.24 
             218.58  221.81  225.44  229.57  234.18 
             239.24  244.74  250.65  256.96  263.66 
             270.73  278.16  311.33  393.99 
/
 4  5  4  1  222.36  211.58  201.96  199.08  200.50 
             203.57  207.68  212.25  217.35  222.99 
             229.14  235.76  242.83  250.33  258.24 
             266.55  275.23  313.13  403.52 
/
 4  5  5  1  198.66  176.02  162.44  159.60  164.92 
             170.80  175.98  182.15  187.29  194.74 
             202.75  211.12  222.39  233.52  244.99 
             256.53  269.51  326.18  466.10 
/
 4  5  6  1  172.09  147.54  139.53  144.24  153.11 
             163.88  175.80  188.62  202.12  216.41 
             231.54  247.41  263.92  281.01  298.63 
             316.69  335.19  413.37  644.74 
/
 4  5  7  1  144.21  126.68  133.22  151.34  172.42 
             196.28  221.93  248.71  276.43  304.99 
             334.38  364.59  395.64  427.52  460.30 
             494.04  528.92  682.30 1121.63 
/
 4  5  8  1  114.79  125.82  172.15  226.64  284.74 
             345.79  409.90  477.43  549.80  627.35 
             710.60  799.83  895.24  996.65 1103.10 
            1215.69 1334.92 1877.27 3270.67 
/
 4  6  1  1  264.73  262.97  262.52  263.07  264.16 
             265.66  267.53  269.75  272.30  275.18 
             278.39  281.91  285.74  289.89  294.35 
             299.13  304.21  327.65  389.25 
/
 4  6  2  1  251.12  245.53  243.43  243.58  244.66 
             246.35  248.54  251.18  254.23  257.67 
             261.49  265.68  270.24  275.15  280.41 
             286.01  291.96  319.07  388.83 
/
 4  6  3  1  237.82  229.69  224.89  224.26  225.60 
             227.69  230.62  233.93  237.72  241.97 
             246.65  251.76  257.27  263.17  269.45 
             276.10  283.11  314.61  394.84 
/
 4  6  4  1  229.02  219.02  211.18  208.99  210.39 
             213.07  216.71  220.80  225.40  230.52 
             236.12  242.18  248.68  255.60  262.93 
             270.65  278.74  314.73  401.50 
/
 4  6  5  1  206.58  185.17  171.02  166.72  170.76 
             176.67  182.52  187.93  193.78  200.29 
             208.36  216.92  227.34  237.03  247.18 
             257.82  269.55  320.05  446.12 
/
 4  6  6  1  181.30  155.54  145.26  148.39  154.61 
             163.03  172.85  183.54  194.98  207.05 
             219.72  232.98  246.83  261.30  276.33 
             291.87  307.89  376.16  578.78 
/
 4  6  7  1  152.18  132.16  132.66  147.04  164.29 
             183.36  204.40  226.91  250.45  274.80 
             299.88  325.64  352.05  379.15  406.96 
             435.50  464.79  590.59  944.44 
/
 4  6  8  1  120.87  122.38  158.56  203.41  251.91 
             302.84  355.99  411.45  469.53  530.44 
             595.21  663.91  736.93  814.44  896.54 
             983.10 1073.48 1481.60 2540.70 
/
 4  7  1  1  269.05  267.44  267.09  267.67  268.76 
             270.25  272.11  274.30  276.83  279.68 
             282.85  286.34  290.14  294.25  298.68 
             303.41  308.46  331.73  393.01 
/
 4  7  2  1  257.88  253.07  251.30  251.50  252.54 
             254.15  256.23  258.73  261.62  264.90 
             268.54  272.54  276.90  281.60  286.65 
             292.03  297.76  323.95  391.79 
/
 4  7  3  1  246.06  238.64  234.90  234.78  235.94 
             237.82  240.26  243.46  246.92  250.82 
             255.13  259.84  264.95  270.44  276.30 
             282.52  289.10  318.85  394.51 
/
 4  7  4  1  237.18  228.00  221.94  220.61  222.01 
             224.30  227.47  231.08  235.17  239.74 
             244.78  250.26  256.16  262.47  269.18 
             276.28  283.75  317.22  400.47 
/
 4  7  5  1  215.30  195.92  181.74  176.37  178.90 
             184.06  190.25  196.47  202.31  208.44 
             216.19  224.58  232.88  242.18  251.53 
             261.75  271.87  318.56  432.75 
/
 4  7  6  1  192.18  166.05  153.30  154.02  159.73 
             165.47  172.77  181.25  190.41  200.32 
             210.84  221.78  233.10  244.88  257.12 
             269.80  282.94  340.03  520.70 
/
 4  7  7  1  162.70  139.41  134.63  144.72  158.13 
             173.28  189.52  207.08  225.86  245.65 
             266.29  287.59  309.51  332.00  355.05 
             378.64  402.77  505.34  774.20 
/
 4  7  8  1  129.14  120.16  146.57  181.38  220.01 
             260.93  303.73  348.11  394.16  441.96 
             491.73  543.46  597.51  654.50  714.27 
             777.16  843.25 1138.04 1920.11 
/
 4  8  1  1  273.47  272.03  271.77  272.37  273.46 
             274.94  276.78  278.95  281.45  284.27 
             287.41  290.86  294.62  298.70  303.09 
             307.78  312.79  335.90  396.83 
/
 4  8  2  1  264.91  260.95  259.54  259.80  260.82 
             262.36  264.34  266.72  269.47  272.59 
             276.06  279.88  284.05  288.55  293.39 
             298.56  304.06  329.33  395.20 
/
 4  8  3  1  255.49  248.88  246.26  246.30  247.34 
             249.03  251.24  254.12  257.27  260.83 
             264.78  269.11  273.82  278.90  284.33 
             290.13  296.26  324.22  396.09 
/
 4  8  4  1  247.16  239.04  234.62  234.23  235.44 
             237.38  239.91  243.26  246.85  250.90 
             255.37  260.27  265.57  271.26  277.34 
             283.79  290.61  321.42  399.18 
/
 4  8  5  1  224.99  208.70  195.33  189.60  190.89 
             195.16  200.26  206.13  212.56  219.27 
             225.82  233.43  242.10  250.95  260.22 
             269.34  279.01  322.69  427.01 
/
 4  8  6  1  205.05  180.08  165.39  162.09  167.62 
             173.75  179.07  185.45  190.89  198.42 
             206.73  215.45  224.54  233.98  243.79 
             253.85  264.86  324.46  471.34 
/
 4  8  7  1  176.86  150.45  141.93  146.40  155.45 
             166.53  178.79  191.97  205.78  220.37 
             235.75  251.93  268.82  286.35  304.51 
             323.21  342.40  423.83  620.87 
/
 4  8  8  1  139.42  121.80  138.11  161.97  190.09 
             220.87  253.21  286.89  321.85  358.01 
             395.33  433.79  473.46  514.44  556.89 
             600.73  646.03  846.22 1393.84 
/
 4  9  1  1  278.00  276.72  276.55  277.18  278.27 
             279.74  281.55  283.70  286.17  288.96 
             292.06  295.48  299.20  303.24  307.59 
             312.24  317.21  340.15  400.72 
/
 4  9  2  1  272.19  269.17  268.15  268.51  269.53 
             271.01  272.90  275.17  277.79  280.77 
             284.08  287.73  291.71  296.02  300.66 
             305.62  310.91  335.27  399.12 
/
 4  9  3  1  265.85  260.67  258.77  258.88  259.85 
             261.39  263.39  265.85  268.64  271.83 
             275.38  279.45  284.00  288.68  293.70 
             299.07  304.77  330.92  398.83 
/
 4  9  4  1  259.52  252.59  249.87  249.87  250.88 
             252.53  254.71  257.60  260.73  264.28 
             268.22  272.54  277.25  282.33  287.77 
             293.57  299.72  327.77  399.76 
/
 4  9  5  1  236.25  224.08  213.36  209.48  210.55 
             213.58  217.55  222.13  227.19  232.81 
             238.96  245.62  252.75  260.33  268.36 
             276.81  285.67  325.00  418.11 
/
 4  9  6  1  220.37  199.23  184.10  178.29  180.76 
             186.14  192.60  199.00  205.07  211.29 
             218.41  227.16  235.52  244.97  254.45 
             264.81  275.65  323.21  439.78 
/
 4  9  7  1  196.30  168.61  155.18  155.84  161.97 
             168.33  175.36  184.15  193.61  203.66 
             214.40  225.65  237.20  249.19  261.62 
             274.50  287.86  346.06  512.34 
/
 4  9  8  1  156.01  134.65  134.57  149.28  166.87 
             186.03  207.02  229.59  253.46  278.30 
             303.97  330.36  357.51  385.45  414.18 
             443.71  474.04  603.05  905.77 
/
 4 10  1  1  287.37  286.41  286.42  287.09  288.18 
             289.62  291.39  293.48  295.89  298.61 
             301.64  304.98  308.63  312.59  316.85 
             321.42  326.30  348.88  408.67 
/
 4 10  2  1  287.37  286.41  286.42  287.09  288.18 
             289.62  291.39  293.48  295.89  298.61 
             301.64  304.98  308.63  312.59  316.85 
             321.42  326.30  348.88  408.67 
/
 4 10  3  1  287.37  286.41  286.42  287.09  288.18 
             289.62  291.39  293.48  295.89  298.61 
             301.64  304.98  308.63  312.59  316.85 
             321.42  326.30  348.88  408.67 
/
 4 10  4  1  287.37  286.41  286.42  287.09  288.18 
             289.62  291.39  293.48  295.89  298.61 
             301.64  304.98  308.63  312.59  316.85 
             321.42  326.30  348.88  408.67 
/
 4 10  5  1  287.37  286.41  286.42  287.09  288.18 
             289.62  291.39  293.48  295.89  298.61 
             301.64  304.98  308.63  312.59  316.85 
             321.42  326.30  348.88  408.67 
/
 4 10  6  1  287.37  286.41  286.42  287.09  288.18 
             289.62  291.39  293.48  295.89  298.61 
             301.64  304.98  308.63  312.59  316.85 
             321.42  326.30  348.88  408.67 
/
 4 10  7  1  287.37  286.41  286.42  287.09  288.18 
             289.62  291.39  293.48  295.89  298.61 
             301.64  304.98  308.63  312.59  316.85 
             321.42  326.30  348.88  408.67 
/
 4 10  8  1  287.37  286.41  286.42  287.09  288.18 
             289.62  291.39  293.48  295.89  298.61 
             301.64  304.98  308.63  312.59  316.85 
             321.42  326.30  348.88  408.67 
/
 5  1  1  1  265.76  264.22  263.76  264.30  265.42 
             266.97  268.90  271.18  273.81  276.76 
             280.05  283.65  287.57  291.80  296.35 
             301.21  306.38  330.15  392.41 
/
 5  1  2  1  247.12  241.12  238.37  238.51  239.75 
             241.70  244.22  247.25  250.73  254.65 
             258.98  263.70  268.81  274.31  280.17 
             286.39  292.97  322.76  400.59 
/
 5  1  3  1  231.77  222.93  216.48  215.33  217.21 
             220.03  223.89  228.12  232.91  238.23 
             244.02  250.29  257.01  264.14  271.68 
             279.61  287.92  324.63  414.02 
/
 5  1  4  1  224.24  212.76  202.90  200.31  202.89 
             206.96  211.78  217.21  223.28  229.78 
             236.97  244.41  252.56  261.10  269.86 
             279.09  288.70  330.79  433.33 
/
 5  1  5  1  198.71  178.08  168.67  171.33  175.95 
             182.48  190.51  199.48  209.45  220.14 
             231.35  243.16  255.56  268.53  282.08 
             296.19  312.91  395.98  582.44 
/
 5  1  6  1  173.78  155.60  154.18  165.64  180.43 
             197.22  215.94  236.43  258.07  280.59 
             303.88  327.87  352.54  377.88  403.96 
             430.82  458.59  597.09  956.79 
/
 5  1  7  1  151.26  141.49  163.53  194.27  229.63 
             267.67  307.80  349.66  393.20  438.72 
             486.58  537.50  591.40  648.74  709.77 
             774.81  849.15 1172.63 1997.41 
/
 5  1  8  1  132.49  164.82  242.60  331.67  429.78 
             539.87  663.25  800.94  953.60 1119.35 
            1299.74 1496.17 1708.23 1935.91 2179.39 
            2404.23 2401.82 2400.54 2435.82 
/
 5  2  1  1  269.49  267.98  267.58  268.16  269.29 
             270.84  272.76  275.04  277.65  280.59 
             283.86  287.44  291.34  295.55  300.08 
             304.92  310.07  333.76  395.86 
/
 5  2  2  1  252.01  246.23  243.81  243.98  245.18 
             247.06  249.49  252.41  255.77  259.55 
             263.74  268.31  273.27  278.60  284.30 
             290.36  296.77  325.89  401.57 
/
 5  2  3  1  236.58  228.11  222.27  221.36  223.12 
             225.74  229.36  233.34  237.87  242.91 
             248.42  254.39  260.80  267.63  274.85 
             282.47  290.47  326.36  413.51 
/
 5  2  4  1  228.79  217.77  208.33  205.91  208.23 
             211.99  216.49  221.59  227.30  233.60 
             240.45  247.81  255.65  263.96  272.69 
             281.68  291.04  332.15  431.28 
/
 5  2  5  1  203.88  183.12  172.72  174.16  178.90 
             184.48  191.30  199.28  208.24  217.92 
             228.21  238.92  250.18  261.97  274.27 
             287.05  304.46  380.09  554.85 
/
 5  2  6  1  178.76  159.09  155.58  165.08  178.05 
             193.04  209.49  227.60  247.11  267.58 
             288.81  310.73  333.27  356.42  380.21 
             404.66  429.80  548.69  875.71 
/
 5  2  7  1  154.99  141.94  160.53  187.15  218.74 
             252.90  289.02  326.81  366.06  406.76 
             449.21  493.64  540.59  590.16  642.54 
             698.06  756.89 1045.30 1756.63 
/
 5  2  8  1  132.54  159.30  228.06  307.46  393.86 
             489.19  595.04  712.28  841.68  983.42 
            1135.64 1300.36 1478.46 1669.61 1873.70 
            2090.84 2321.05 2720.17 2735.28 
/
 5  3  1  1  273.31  271.85  271.51  272.12  273.25 
             274.80  276.71  278.98  281.57  284.50 
             287.74  291.31  295.19  299.38  303.88 
             308.70  313.82  337.42  399.34 
/
 5  3  2  1  257.15  251.67  249.54  249.73  250.90 
             252.71  255.05  257.85  261.09  264.74 
             268.79  273.22  278.02  283.19  288.72 
             294.62  300.86  329.28  402.21 
/
 5  3  3  1  241.87  233.82  228.60  227.99  229.61 
             232.04  235.41  239.14  243.41  248.16 
             253.38  259.05  265.15  271.66  278.56 
             285.86  293.53  327.89  413.44 
/
 5  3  4  1  233.75  223.18  214.48  212.31  214.38 
             217.83  222.00  226.74  232.08  237.98 
             244.42  251.36  258.77  266.64  274.94 
             283.66  292.70  332.22  427.93 
/
 5  3  5  1  209.51  188.87  177.53  177.45  183.04 
             187.80  193.16  200.06  207.99  216.69 
             225.94  235.71  245.88  256.48  267.56 
             282.66  299.36  366.64  529.70 
/
 5  3  6  1  184.45  163.38  158.22  165.28  176.38 
             189.49  203.98  219.71  236.77  255.01 
             274.13  293.93  314.35  335.35  356.92 
             379.06  401.77  501.55  798.04 
/
 5  3  7  1  159.55  143.81  158.09  180.68  208.25 
             238.57  270.71  304.38  339.42  375.72 
             413.28  452.23  492.94  535.41  580.23 
             627.29  676.83  919.57 1530.15 
/
 5  3  8  1  133.91  154.17  213.85  283.76  359.67 
             441.48  531.27  629.87  737.93  855.98 
             984.03 1120.50 1267.02 1424.40 1592.63 
            1771.38 1960.70 2824.39 3171.24 
/
 5  4  1  1  277.23  275.82  275.54  276.17  277.30 
             278.85  280.75  283.00  285.58  288.48 
             291.71  295.25  299.11  303.28  307.75 
             312.55  317.65  341.14  402.86 
/
 5  4  2  1  262.53  257.46  255.55  255.77  256.91 
             258.65  260.90  263.60  266.72  270.24 
             274.14  278.42  283.07  288.08  293.46 
             299.18  305.25  332.96  404.37 
/
 5  4  3  1  247.73  240.10  235.55  235.25  236.72 
             238.97  242.09  245.58  249.58  254.05 
             258.97  264.33  270.11  276.30  282.88 
             289.84  297.18  330.18  413.87 
/
 5  4  4  1  239.08  229.14  221.44  219.62  221.50 
             224.43  228.44  232.82  237.77  243.26 
             249.26  255.75  262.71  270.11  277.94 
             286.18  294.83  332.93  424.97 
/
 5  4  5  1  215.65  195.43  183.32  181.64  187.11 
             192.35  197.22  202.18  209.01  216.77 
             225.01  233.72  242.87  255.48  268.30 
             281.22  294.93  355.27  505.20 
/
 5  4  6  1  190.98  168.62  161.88  166.61  175.69 
             186.85  199.45  213.06  227.69  243.40 
             260.14  277.73  295.97  314.80  334.15 
             354.02  374.40  461.02  723.84 
/
 5  4  7  1  165.06  148.04  156.33  175.38  198.40 
             224.76  252.96  282.55  313.36  345.34 
             378.41  412.54  447.78  484.31  522.36 
             561.92  603.41  797.66 1321.25 
/
 5  4  8  1  136.74  149.74  200.12  260.63  326.39 
             396.66  471.88  553.64  642.47  738.86 
             843.18  955.50 1074.80 1201.45 1336.66 
            1480.51 1632.87 2326.51 4096.48 
/
 5  5  1  1  281.24  279.90  279.67  280.31  281.45 
             282.98  284.87  287.10  289.67  292.55 
             295.75  299.27  303.10  307.25  311.70 
             316.47  321.54  344.93  406.43 
/
 5  5  2  1  268.16  263.56  261.86  262.12  263.22 
             264.90  267.07  269.66  272.66  276.05 
             279.82  283.96  288.45  293.31  298.51 
             304.07  309.97  336.95  406.79 
/
 5  5  3  1  254.25  247.05  243.21  243.17  244.50 
             246.57  249.46  252.71  256.44  260.64 
             265.26  270.31  275.77  281.63  287.87 
             294.49  301.48  333.08  414.38 
/
 5  5  4  1  245.11  235.88  229.34  228.00  229.73 
             232.35  235.98  239.97  244.52  249.58 
             255.13  261.15  267.63  274.55  281.88 
             289.62  297.76  334.15  422.78 
/
 5  5  5  1  222.36  202.97  190.32  187.09  191.84 
             197.71  202.76  207.72  213.74  221.25 
             229.47  238.15  247.33  258.83  269.42 
             281.06  292.67  346.61  485.03 
/
 5  5  6  1  198.53  175.17  166.34  169.63  176.42 
             185.59  196.13  207.77  220.26  233.61 
             247.77  262.76  278.55  295.02  312.08 
             329.64  347.68  424.36  655.57 
/
 5  5  7  1  171.58  153.41  155.58  171.08  189.99 
             211.75  235.87  261.42  288.10  315.78 
             344.38  373.93  404.39  435.78  468.13 
             501.49  536.07  688.58 1128.69 
/
 5  5  8  1  140.97  146.37  187.15  238.14  294.04 
             353.59  416.64  483.41  555.22  632.34 
             715.24  804.18  899.33 1000.48 1106.67 
            1219.10 1338.15 1879.89 3272.29 
/
 5  6  1  1  285.36  284.08  283.90  284.55  285.69 
             287.21  289.08  291.30  293.84  296.70 
             299.88  303.37  307.17  311.29  315.72 
             320.45  325.50  348.77  410.03 
/
 5  6  2  1  274.05  269.96  268.48  268.77  269.85 
             271.48  273.56  276.05  278.94  282.21 
             285.84  289.84  294.18  298.88  303.92 
             309.30  315.03  341.28  409.51 
/
 5  6  3  1  261.55  254.77  251.69  251.81  253.02 
             254.92  257.58  260.60  264.07  267.99 
             272.32  277.06  282.19  287.72  293.62 
             299.89  306.53  336.69  414.23 
/
 5  6  4  1  252.14  243.71  238.31  237.57  239.11 
             241.43  244.68  248.30  252.44  257.07 
             262.16  267.71  273.70  280.11  286.93 
             294.15  301.76  335.94  421.53 
/
 5  6  5  1  229.69  211.66  198.82  194.48  198.26 
             203.60  209.80  215.12  220.80  227.69 
             235.30  243.83  252.57  262.11  272.20 
             282.31  293.42  343.05  466.57 
/
 5  6  6  1  207.26  183.37  172.50  174.94  179.60 
             186.38  194.85  204.34  214.75  225.99 
             237.79  250.25  263.34  277.07  291.43 
             306.42  321.96  388.70  592.69 
/
 5  6  7  1  179.73  159.02  156.47  168.18  183.47 
             200.76  220.07  241.26  263.74  287.17 
             311.45  336.52  362.32  388.87  416.18 
             444.28  473.19  597.85  951.66 
/
 5  6  8  1  148.18  144.05  175.19  216.60  262.71 
             311.99  363.93  418.49  475.84  536.23 
             600.57  668.93  741.65  818.91  900.78 
             987.11 1077.25 1484.76 2542.84 
/
 5  7  1  1  289.57  288.36  288.22  288.89  290.02 
             291.53  293.38  295.58  298.09  300.93 
             304.08  307.55  311.32  315.41  319.81 
             324.52  329.53  352.68  413.68 
/
 5  7  2  1  280.20  276.66  275.42  275.76  276.82 
             278.39  280.39  282.80  285.58  288.72 
             292.22  296.08  300.28  304.82  309.70 
             314.91  320.46  345.97  412.57 
/
 5  7  3  1  269.74  263.43  261.08  261.21  262.32 
             264.07  266.51  269.30  272.53  276.17 
             280.22  284.65  289.47  294.66  300.22 
             306.13  312.41  341.08  414.73 
/
 5  7  4  1  260.52  252.82  248.63  248.46  249.77 
             251.82  254.71  257.96  261.70  265.90 
             270.55  275.62  281.11  287.01  293.31 
             300.00  307.06  338.99  420.95 
/
 5  7  5  1  237.77  221.72  209.18  204.20  206.79 
             211.43  216.96  223.15  229.33  235.41 
             242.80  250.99  259.53  268.22  277.56 
             287.31  297.47  343.87  456.83 
/
 5  7  6  1  217.41  193.83  181.12  180.72  186.41 
             191.20  196.78  204.12  212.29  221.37 
             231.05  241.30  251.94  263.05  274.67 
             286.76  299.33  358.79  536.18 
/
 5  7  7  1  190.20  166.77  160.85  167.66  179.08 
             192.59  207.51  223.68  241.22  260.02 
             279.82  300.40  321.68  343.60  366.13 
             389.25  412.97  514.16  783.76 
/
 5  7  8  1  156.02  143.13  165.45  196.64  232.84 
             271.93  313.35  356.69  401.91  449.02 
             498.24  549.49  603.20  659.85  719.36 
             782.01  847.89 1141.93 1922.96 
/
 5  8  1  1  293.89  292.74  292.65  293.32  294.44 
             295.93  297.77  299.94  302.43  305.24 
             308.37  311.80  315.55  319.61  323.98 
             328.65  333.64  356.65  417.38 
/
 5  8  2  1  286.62  283.66  282.69  283.08  284.13 
             285.65  287.59  289.90  292.58  295.61 
             298.99  302.70  306.76  311.14  315.86 
             320.92  326.29  351.06  415.98 
/
 5  8  3  1  278.54  273.19  271.26  271.42  272.45 
             274.07  276.32  278.81  281.71  285.24 
             289.03  293.17  297.67  302.54  307.75 
             313.32  319.25  346.39  416.66 
/
 5  8  4  1  270.63  263.61  260.67  260.76  261.89 
             263.69  266.03  269.15  272.50  276.28 
             280.48  285.09  290.09  295.48  301.24 
             307.39  313.89  343.50  419.24 
/
 5  8  5  1  246.95  233.58  222.22  217.73  219.54 
             223.29  227.82  233.05  238.85  245.28 
             252.29  259.85  267.94  276.54  285.62 
             295.16  304.91  347.88  452.24 
/
 5  8  6  1  229.27  207.42  193.53  189.63  194.58 
             200.67  205.79  210.80  215.47  222.04 
             229.69  237.72  246.15  255.40  267.17 
             279.50  292.37  348.26  490.61 
/
 5  8  7  1  203.84  178.40  168.62  172.00  178.87 
             188.32  199.20  211.19  224.02  237.63 
             252.12  267.43  283.59  300.49  318.08 
             336.27  355.00  434.97  634.61 
/
 5  8  8  1  166.93  148.58  159.05  180.14  205.58 
             234.49  265.38  297.83  331.79  367.13 
             403.76  441.67  480.83  521.40  563.45 
             606.96  651.95  851.30 1397.69 
/
 5  9  1  1  298.31  297.22  297.17  297.84  298.95 
             300.43  302.25  304.39  306.86  309.64 
             312.74  316.14  319.86  323.89  328.22 
             332.86  337.81  360.68  421.11 
/
 5  9  2  1  293.32  290.98  290.30  290.76  291.80 
             293.29  295.16  297.39  299.97  302.89 
             306.15  309.73  313.65  317.89  322.45 
             327.34  332.55  356.57  419.79 
/
 5  9  3  1  287.82  283.70  282.24  282.48  283.48 
             284.99  286.96  289.32  292.06  295.17 
             298.64  302.46  306.88  311.45  316.34 
             321.57  327.13  352.73  419.54 
/
 5  9  4  1  282.39  276.61  274.50  274.60  275.60 
             277.20  279.28  282.04  285.03  288.42 
             292.19  296.35  300.86  305.75  310.99 
             316.59  322.54  349.78  420.32 
/
 5  9  5  1  258.93  248.15  239.90  237.58  239.16 
             241.77  245.36  249.45  254.04  259.16 
             264.80  270.93  277.53  284.60  292.11 
             300.05  308.42  345.90  437.42 
/
 5  9  6  1  243.24  225.31  211.79  206.09  208.74 
             213.48  219.26  225.75  231.95  238.05 
             245.04  253.37  262.12  270.99  280.48 
             290.38  301.29  347.68  464.03 
/
 5  9  7  1  221.94  196.70  183.18  182.62  188.65 
             193.75  199.70  207.02  215.44  224.60 
             234.53  245.02  256.01  267.35  279.18 
             291.48  304.28  360.65  526.29 
/
 5  9  8  1  184.05  161.50  158.59  170.51  186.12 
             203.70  223.02  244.22  266.97  290.90 
             315.79  341.51  368.03  395.40  423.63 
             452.71  482.64  610.42  911.58 
/
 5 10  1  1  307.46  306.50  306.51  307.18  308.27 
             309.71  311.48  313.57  315.97  318.69 
             321.73  325.07  328.71  332.67  336.93 
             341.50  346.38  368.94  428.70 
/
 5 10  2  1  307.46  306.50  306.51  307.18  308.27 
             309.71  311.48  313.57  315.97  318.69 
             321.73  325.07  328.71  332.67  336.93 
             341.50  346.38  368.94  428.70 
/
 5 10  3  1  307.46  306.50  306.51  307.18  308.27 
             309.71  311.48  313.57  315.97  318.69 
             321.73  325.07  328.71  332.67  336.93 
             341.50  346.38  368.94  428.70 
/
 5 10  4  1  307.46  306.50  306.51  307.18  308.27 
             309.71  311.48  313.57  315.97  318.69 
             321.73  325.07  328.71  332.67  336.93 
             341.50  346.38  368.94  428.70 
/
 5 10  5  1  307.46  306.50  306.51  307.18  308.27 
             309.71  311.48  313.57  315.97  318.69 
             321.73  325.07  328.71  332.67  336.93 
             341.50  346.38  368.94  428.70 
/
 5 10  6  1  307.46  306.50  306.51  307.18  308.27 
             309.71  311.48  313.57  315.97  318.69 
             321.73  325.07  328.71  332.67  336.93 
             341.50  346.38  368.94  428.70 
/
 5 10  7  1  307.46  306.50  306.51  307.18  308.27 
             309.71  311.48  313.57  315.97  318.69 
             321.73  325.07  328.71  332.67  336.93 
             341.50  346.38  368.94  428.70 
/
 5 10  8  1  307.46  306.50  306.51  307.18  308.27 
             309.71  311.48  313.57  315.97  318.69 
             321.73  325.07  328.71  332.67  336.93 
             341.50  346.38  368.94  428.70 
/
 6  1  1  1  286.09  284.90  284.73  285.41  286.59 
             288.18  290.13  292.42  295.05  298.00 
             301.27  304.86  308.77  312.98  317.51 
             322.35  327.49  351.15  413.17 
/
 6  1  2  1  270.55  266.11  264.30  264.55  265.74 
             267.55  269.89  272.69  275.92  279.57 
             283.62  288.06  292.87  298.06  303.62 
             309.55  315.84  344.53  420.09 
/
 6  1  3  1  254.50  247.46  243.17  243.23  244.89 
             247.35  250.77  254.55  258.88  263.70 
             269.01  274.77  280.97  287.60  294.65 
             302.10  309.94  345.71  433.79 
/
 6  1  4  1  246.39  236.56  229.02  227.97  230.37 
             233.96  238.20  243.07  248.57  254.66 
             261.29  268.45  276.12  284.26  292.86 
             301.90  311.24  352.37  452.83 
/
 6  1  5  1  222.29  203.93  194.68  196.86  201.07 
             206.66  213.43  221.52  230.64  240.51 
             251.00  262.07  273.78  286.11  299.01 
             315.54  335.07  412.56  597.87 
/
 6  1  6  1  199.13  181.17  178.41  187.72  200.77 
             216.08  233.25  252.40  273.00  294.62 
             317.10  340.37  364.40  389.21  414.84 
             441.31  468.72  608.54  966.51 
/
 6  1  7  1  176.77  164.95  183.57  211.22  244.29 
             280.48  319.15  359.85  402.46  447.34 
             494.69  545.18  598.75  655.84  716.67 
             781.54  856.49 1179.07 2001.76 
/
 6  1  8  1  155.68  182.97  255.04  341.00  437.40 
             546.49  669.18  806.37  958.61 1123.94 
            1304.05 1500.15 1711.92 1939.34 2182.54 
            2407.16 2404.55 2402.53 2436.89 
/
 6  2  1  1  289.81  288.63  288.50  289.19  290.38 
             291.96  293.91  296.19  298.80  301.74 
             304.99  308.57  312.45  316.65  321.16 
             325.98  331.10  354.69  416.58 
/
 6  2  2  1  275.13  270.92  269.27  269.57  270.74 
             272.51  274.78  277.51  280.65  284.20 
             288.14  292.47  297.17  302.23  307.66 
             313.46  319.61  347.72  420.47 
/
 6  2  3  1  259.48  252.67  248.83  248.99  250.54 
             252.87  256.09  259.68  263.79  268.39 
             273.45  278.96  284.91  291.28  298.05 
             305.22  312.78  347.01  433.71 
/
 6  2  4  1  250.87  241.55  234.58  233.67  235.85 
             239.17  243.13  247.70  252.88  258.62 
             264.89  271.67  278.95  286.70  294.90 
             303.54  312.61  352.36  449.54 
/
 6  2  5  1  227.21  208.91  198.86  199.83  204.73 
             209.04  214.98  222.10  230.31  239.22 
             248.77  258.84  269.42  280.58  293.84 
             310.68  327.32  398.38  572.65 
/
 6  2  6  1  204.05  184.93  180.54  187.87  199.16 
             212.71  227.82  244.56  262.91  282.48 
             302.92  324.12  346.02  368.63  391.94 
             415.96  440.69  561.29  886.04 
/
 6  2  7  1  180.67  166.38  181.26  204.95  234.30 
             266.67  301.30  337.88  376.15  416.05 
             457.94  501.88  548.47  597.70  649.84 
             705.15  763.83 1052.15 1761.32 
/
 6  2  8  1  156.57  178.21  241.43  317.57  402.06 
             496.28  601.37  718.06  847.03  988.38 
            1140.23 1304.69 1482.55 1673.41 1877.23 
            2094.15 2324.14 2708.75 2733.59 
/
 6  3  1  1  293.62  292.47  292.37  293.07  294.25 
             295.83  297.76  300.03  302.63  305.55 
             308.78  312.34  316.21  320.38  324.87 
             329.67  334.77  358.28  420.01 
/
 6  3  2  1  279.94  276.00  274.51  274.83  275.98 
             277.71  279.92  282.57  285.63  289.08 
             292.91  297.12  301.70  306.64  311.95 
             317.60  323.62  351.14  422.55 
/
 6  3  3  1  264.94  258.36  255.00  255.23  256.68 
             258.87  261.90  265.29  269.19  273.56 
             278.39  283.65  289.33  295.42  301.92 
             308.81  316.08  349.11  434.04 
/
 6  3  4  1  255.73  246.99  240.76  240.08  242.05 
             244.88  248.78  253.04  257.88  263.26 
             269.16  275.56  282.43  289.77  297.55 
             305.76  314.39  352.90  446.78 
/
 6  3  5  1  232.56  214.53  203.79  203.48  208.89 
             213.25  217.71  223.71  230.99  238.99 
             247.56  256.66  266.25  279.30  293.52 
             306.40  322.05  385.88  548.25 
/
 6  3  6  1  209.61  189.38  184.10  188.88  198.35 
             210.02  223.29  237.83  253.70  270.92 
             289.24  308.35  328.15  348.59  369.65 
             391.33  413.61  516.13  808.98 
/
 6  3  7  1  185.38  169.45  179.52  199.62  224.80 
             253.36  284.05  316.48  350.49  385.94 
             422.78  461.20  501.44  543.55  588.08 
             634.87  684.21  926.99 1537.87 
/
 6  3  8  1  158.78  173.89  228.26  294.83  368.66 
             449.19  538.10  636.09  743.69  861.36 
             989.05 1125.17 1271.48 1428.66 1596.62 
            1775.12 1964.23 2827.15 3172.87 
/
 6  4  1  1  297.53  296.40  296.32  297.03  298.21 
             299.78  301.69  303.95  306.53  309.43 
             312.65  316.18  320.03  324.18  328.65 
             333.43  338.51  361.93  423.47 
/
 6  4  2  1  284.99  281.33  280.00  280.35  281.49 
             283.18  285.32  287.89  290.86  294.22 
             297.95  302.04  306.50  311.32  316.49 
             322.01  327.88  354.80  424.85 
/
 6  4  3  1  270.95  264.59  261.73  262.00  263.34 
             265.40  268.24  271.44  275.13  279.27 
             283.86  288.86  294.28  300.10  306.31 
             312.91  319.90  351.69  434.26 
/
 6  4  4  1  261.22  253.07  247.65  247.25  249.02 
             251.60  255.20  259.14  263.64  268.67 
             274.19  280.19  286.66  293.57  300.92 
             308.69  316.88  354.01  444.44 
/
 6  4  5  1  238.37  220.89  209.64  208.07  212.89 
             218.41  222.80  228.10  234.14  242.07 
             250.78  260.34  269.99  281.45  292.97 
             305.11  318.02  375.74  524.56 
/
 6  4  6  1  215.94  194.80  187.22  191.14  198.62 
             208.41  219.76  232.31  245.97  260.70 
             276.50  293.31  310.93  329.18  348.01 
             367.40  387.34  473.79  735.53 
/
 6  4  7  1  190.94  174.48  178.56  195.34  216.11 
             240.67  267.44  295.83  325.61  356.67 
             388.97  422.45  457.13  493.25  530.93 
             570.18  611.44  806.40 1326.90 
/
 6  4  8  1  161.86  170.48  215.74  272.85  336.38 
             405.15  479.39  560.43  648.73  744.71 
             848.69  960.68 1079.64 1206.07 1341.06 
            1484.73 1636.91 2329.76 4098.12 
/
 6  5  1  1  301.53  300.42  300.37  301.08  302.26 
             303.81  305.71  307.95  310.51  313.39 
             316.59  320.10  323.92  328.05  332.50 
             337.25  342.31  365.62  426.97 
/
 6  5  2  1  290.28  286.94  285.76  286.15  287.27 
             288.91  290.99  293.49  296.37  299.63 
             303.25  307.24  311.58  316.27  321.31 
             326.69  332.42  358.73  427.38 
/
 6  5  3  1  277.59  271.45  269.08  269.32  270.57 
             272.50  275.15  278.17  281.65  285.57 
             289.91  294.66  299.81  305.35  311.28 
             317.59  324.30  354.80  435.38 
/
 6  5  4  1  267.53  259.94  255.37  255.27  256.85 
             259.19  262.48  266.12  270.28  274.94 
             280.09  285.69  291.74  298.22  305.13 
             312.46  320.18  354.99  442.84 
/
 6  5  5  1  244.71  228.12  216.58  213.78  218.10 
             223.63  229.11  234.16  240.13  247.51 
             255.69  264.24  273.60  283.56  294.11 
             305.25  316.90  369.33  505.38 
/
 6  5  6  1  223.17  201.44  192.26  195.36  200.59 
             208.31  217.68  228.23  239.87  252.33 
             265.67  279.83  294.84  310.66  327.20 
             344.28  361.88  437.13  668.19 
/
 6  5  7  1  197.54  178.84  178.79  192.05  209.14 
             229.01  251.66  276.01  301.67  328.45 
             356.27  385.11  414.96  445.82  477.70 
             510.70  544.95  696.57 1134.93 
/
 6  5  8  1  166.77  167.94  204.10  251.70  305.30 
             363.19  425.07  490.99  562.17  638.81 
             721.33  809.94  904.80 1005.66 1111.59 
            1223.82 1342.67 1883.72 3274.89 
/
 6  6  1  1  305.62  304.54  304.51  305.22  306.38 
             307.93  309.81  312.02  314.57  317.42 
             320.60  324.08  327.88  331.99  336.41 
             341.14  346.17  369.38  430.51 
/
 6  6  2  1  295.81  292.81  291.80  292.22  293.32 
             294.93  296.95  299.37  302.17  305.33 
             308.85  312.73  316.95  321.51  326.42 
             331.67  337.25  362.95  430.16 
/
 6  6  3  1  284.77  279.03  277.01  277.24  278.41 
             280.21  282.69  285.53  288.80  292.50 
             296.60  301.10  305.98  311.25  316.89 
             322.92  329.32  358.51  433.69 
/
 6  6  4  1  274.87  267.78  264.10  264.24  265.64 
             267.76  270.74  274.08  277.91  282.21 
             286.98  292.18  297.81  303.86  310.32 
             317.18  324.44  357.27  442.02 
/
 6  6  5  1  251.63  236.36  224.87  221.17  224.62 
             229.56  235.36  241.22  246.77  253.58 
             261.45  269.54  278.28  287.50  297.19 
             307.87  318.53  367.10  490.18 
/
 6  6  6  1  231.48  209.65  198.80  200.67  204.82 
             210.48  217.80  226.30  235.85  246.30 
             257.34  269.07  281.47  294.53  308.23 
             322.60  337.61  404.01  608.34 
/
 6  6  7  1  205.67  184.93  180.87  190.38  203.90 
             219.73  237.52  257.37  278.83  301.38 
             324.89  349.25  374.44  400.43  427.23 
             454.87  483.38  606.87  959.02 
/
 6  6  8  1  174.57  166.50  193.57  231.83  275.52 
             323.06  373.68  427.25  483.79  543.61 
             607.45  675.43  747.85  824.82  906.44 
             992.53 1082.40 1489.24 2546.16 
/
 6  7  1  1  309.81  308.75  308.74  309.45  310.60 
             312.13  313.99  316.18  318.70  321.54 
             324.68  328.15  331.92  336.00  340.39 
             345.09  350.09  373.19  434.08 
/
 6  7  2  1  301.61  298.97  298.14  298.59  299.68 
             301.24  303.21  305.56  308.27  311.34 
             314.76  318.52  322.62  327.07  331.84 
             336.95  342.39  367.46  433.23 
/
 6  7  3  1  292.41  287.35  285.56  285.80  286.91 
             288.60  290.78  293.41  296.44  300.12 
             303.99  308.24  312.86  317.85  323.22 
             328.95  335.04  362.91  435.10 
/
 6  7  4  1  283.53  276.83  274.07  274.27  275.50 
             277.42  280.12  283.16  286.66  290.62 
             295.00  299.81  305.02  310.63  316.64 
             323.03  329.81  360.62  441.77 
/
 6  7  5  1  259.59  245.91  234.94  230.99  233.70 
             237.88  242.91  248.55  254.90  261.54 
             268.85  276.67  285.27  294.29  303.62 
             313.52  323.24  369.60  481.88 
/
 6  7  6  1  241.05  219.91  207.69  206.74  212.39 
             216.67  221.50  227.73  235.14  243.54 
             252.54  262.11  272.17  282.68  293.72 
             305.27  317.32  381.58  555.05 
/
 6  7  7  1  215.90  193.10  186.84  191.41  201.13 
             213.21  226.93  241.94  258.31  276.09 
             295.09  314.99  335.64  356.99  379.01 
             401.67  424.97  524.79  795.26 
/
 6  7  8  1  182.05  167.11  185.69  213.75  247.69 
             284.94  324.90  367.12  411.44  457.82 
             506.40  557.13  610.45  666.74  725.97 
             788.37  854.02 1147.23 1928.12 
/
 6  8  1  1  314.09  313.06  313.06  313.76  314.90 
             316.41  318.25  320.43  322.92  325.73 
             328.85  332.28  336.03  340.08  344.44 
             349.11  354.08  377.05  437.69 
/
 6  8  2  1  307.69  305.42  304.77  305.27  306.35 
             307.87  309.78  312.06  314.69  317.67 
             320.99  324.64  328.63  332.95  337.59 
             342.56  347.86  372.31  436.60 
/
 6  8  3  1  300.51  296.26  294.78  295.05  296.11 
             297.71  299.76  302.24  305.11  308.37 
             312.14  316.15  320.52  325.25  330.33 
             335.76  341.53  368.06  437.20 
/
 6  8  4  1  293.53  287.46  285.32  285.48  286.59 
             288.31  290.74  293.50  296.70  300.31 
             304.33  308.74  313.54  318.71  324.27 
             330.20  336.49  365.23  439.48 
/
 6  8  5  1  269.32  257.22  247.72  244.71  246.79 
             250.16  254.28  259.03  264.37  270.31 
             276.82  283.88  291.46  299.56  308.15 
             317.21  326.74  368.43  470.58 
/
 6  8  6  1  252.13  232.95  220.09  216.34  220.82 
             226.56  232.01  236.65  241.85  248.27 
             256.10  264.56  273.89  283.30  293.34 
             304.99  317.66  371.27  511.24 
/
 6  8  7  1  229.00  204.99  194.75  198.02  203.31 
             211.11  220.81  231.72  243.65  256.44 
             270.11  284.65  300.04  316.30  333.36 
             351.08  369.36  447.89  650.16 
/
 6  8  8  1  193.26  175.40  181.00  199.80  222.88 
             250.02  279.49  310.74  343.65  378.12 
             414.02  451.32  489.94  530.05  571.68 
             614.82  659.49  857.94 1402.96 
/
 6  9  1  1  318.48  317.47  317.48  318.17  319.30 
             320.78  322.60  324.75  327.22  330.00 
             333.09  336.49  340.21  344.23  348.56 
             353.20  358.14  380.98  441.34 
/
 6  9  2  1  314.04  312.18  311.73  312.27  313.34 
             314.83  316.69  318.90  321.46  324.35 
             327.57  331.11  334.98  339.18  343.70 
             348.53  353.69  377.50  440.29 
/
 6  9  3  1  309.10  305.79  304.69  305.04  306.07 
             307.59  309.54  311.90  314.63  317.71 
             321.13  324.91  329.03  333.49  338.28 
             343.42  348.89  374.08  440.11 
/
 6  9  4  1  304.29  299.51  297.80  298.00  299.01 
             300.59  302.62  305.27  308.18  311.46 
             315.13  319.16  323.55  328.31  333.41 
             338.87  344.68  371.34  440.83 
/
 6  9  5  1  280.94  271.62  265.21  264.26  265.82 
             268.19  271.50  275.27  279.53  284.31 
             289.59  295.34  301.57  308.26  315.39 
             322.96  330.95  367.03  457.29 
/
 6  9  6  1  265.20  249.81  237.70  232.68  235.38 
             239.78  245.07  251.03  257.69  264.11 
             271.11  279.35  288.15  296.96  306.11 
             316.10  326.53  373.58  489.27 
/
 6  9  7  1  245.97  223.03  209.95  208.81  214.61 
             219.30  224.21  230.62  238.19  246.66 
             255.90  265.72  276.10  286.90  298.18 
             309.95  322.24  376.76  548.19 
/
 6  9  8  1  210.46  187.67  183.29  192.81  206.67 
             222.85  240.77  260.61  282.29  305.35 
             329.48  354.54  380.43  407.22  434.92 
             463.54  493.05  619.54  919.06 
/
 6 10  1  1  327.55  326.59  326.60  327.27  328.36 
             329.80  331.57  333.66  336.06  338.78 
             341.81  345.15  348.80  352.75  357.01 
             361.58  366.45  389.00  448.75 
/
 6 10  2  1  327.55  326.59  326.60  327.27  328.36 
             329.80  331.57  333.66  336.06  338.78 
             341.81  345.15  348.80  352.75  357.01 
             361.58  366.45  389.00  448.75 
/
 6 10  3  1  327.55  326.59  326.60  327.27  328.36 
             329.80  331.57  333.66  336.06  338.78 
             341.81  345.15  348.80  352.75  357.01 
             361.58  366.45  389.00  448.75 
/
 6 10  4  1  327.55  326.59  326.60  327.27  328.36 
             329.80  331.57  333.66  336.06  338.78 
             341.81  345.15  348.80  352.75  357.01 
             361.58  366.45  389.00  448.75 
/
 6 10  5  1  327.55  326.59  326.60  327.27  328.36 
             329.80  331.57  333.66  336.06  338.78 
             341.81  345.15  348.80  352.75  357.01 
             361.58  366.45  389.00  448.75 
/
 6 10  6  1  327.55  326.59  326.60  327.27  328.36 
             329.80  331.57  333.66  336.06  338.78 
             341.81  345.15  348.80  352.75  357.01 
             361.58  366.45  389.00  448.75 
/
 6 10  7  1  327.55  326.59  326.60  327.27  328.36 
             329.80  331.57  333.66  336.06  338.78 
             341.81  345.15  348.80  352.75  357.01 
             361.58  366.45  389.00  448.75 
/
 6 10  8  1  327.55  326.59  326.60  327.27  328.36 
             329.80  331.57  333.66  336.06  338.78 
             341.81  345.15  348.80  352.75  357.01 
             361.58  366.45  389.00  448.75 
/
 7  1  1  1  306.30  305.16  305.05  305.76  306.96 
             308.57  310.53  312.83  315.47  318.43 
             321.71  325.30  329.21  333.43  337.96 
             342.79  347.94  371.60  433.62 
/
 7  1  2  1  292.54  289.42  288.19  288.59  289.78 
             291.54  293.78  296.46  299.55  303.04 
             306.92  311.18  315.82  320.83  326.21 
             331.94  338.04  366.01  438.83 
/
 7  1  3  1  277.25  271.45  268.87  269.27  270.79 
             273.22  276.15  279.64  283.64  288.13 
             293.08  298.49  304.32  310.58  317.28 
             324.40  331.94  366.11  454.35 
/
 7  1  4  1  267.74  259.84  254.47  254.63  256.72 
             259.96  263.76  268.20  273.25  278.86 
             285.02  291.70  298.88  306.55  314.69 
             323.28  332.43  372.59  471.51 
/
 7  1  5  1  244.75  228.53  219.72  221.75  226.36 
             230.67  236.77  244.21  252.65  261.85 
             271.71  282.13  293.21  305.84  322.50 
             339.16  356.38  431.37  614.75 
/
 7  1  6  1  223.28  206.04  202.70  210.39  222.00 
             236.00  251.88  269.72  289.30  310.06 
             331.78  354.38  377.83  402.13  427.28 
             453.34  480.39  621.67  977.74 
/
 7  1  7  1  201.48  188.85  204.52  229.51  260.50 
             294.94  332.14  371.67  413.35  457.52 
             504.36  554.38  607.63  664.45  725.09 
             790.52  865.32 1185.83 2007.45 
/
 7  1  8  1  179.24  202.36  269.24  351.97  446.56 
             554.55  676.49  813.13  964.90 1129.78 
            1309.58 1505.33 1716.77 1943.91 2186.80 
            2401.33 2408.35 2405.47 2438.53 
/
 7  2  1  1  310.02  308.89  308.81  309.53  310.73 
             312.33  314.29  316.58  319.20  322.14 
             325.40  328.98  332.87  337.07  341.58 
             346.40  351.53  375.11  436.99 
/
 7  2  2  1  296.96  293.98  292.87  293.30  294.48 
             296.22  298.41  301.03  304.05  307.47 
             311.26  315.43  319.97  324.88  330.14 
             335.77  341.75  369.21  440.83 
/
 7  2  3  1  282.41  276.67  274.37  274.75  276.19 
             278.50  281.30  284.63  288.45  292.75 
             297.50  302.69  308.31  314.34  320.80 
             327.68  334.96  368.03  454.58 
/
 7  2  4  1  272.31  264.83  259.99  260.22  262.15 
             265.16  268.73  272.91  277.66  282.97 
             288.81  295.15  301.97  309.28  317.04 
             325.25  333.90  372.95  468.70 
/
 7  2  5  1  249.47  233.41  223.97  224.96  230.20 
             234.15  239.01  245.39  253.03  261.33 
             270.27  279.78  291.28  305.33  319.15 
             334.14  349.52  417.87  590.10 
/
 7  2  6  1  228.09  209.91  205.56  211.11  221.05 
             233.31  247.28  262.85  280.08  298.75 
             318.45  338.99  360.32  382.40  405.21 
             428.77  453.10  575.51  897.91 
/
 7  2  7  1  205.47  191.03  202.76  224.08  251.32 
             282.01  315.21  350.57  387.84  426.94 
             468.22  511.66  557.88  606.77  658.65 
             713.76  772.29 1059.28 1767.50 
/
 7  2  8  1  180.90  198.23  256.53  329.37  411.84 
             504.85  609.12  725.20  853.72  994.65 
            1146.09 1310.30 1487.86 1678.40 1881.95 
            2098.59 2328.34 2720.46 2703.17 
/
 7  3  1  1  313.83  312.72  312.66  313.39  314.59 
             316.18  318.12  320.39  323.00  325.92 
             329.16  332.72  336.59  340.77  345.26 
             350.06  355.17  378.67  440.39 
/
 7  3  2  1  301.60  298.78  297.78  298.24  299.42 
             301.12  303.26  305.82  308.77  312.11 
             315.82  319.90  324.34  329.14  334.30 
             339.81  345.67  372.61  443.00 
/
 7  3  3  1  287.97  282.34  280.30  280.66  282.02 
             284.20  286.87  290.04  293.69  297.80 
             302.35  307.32  312.71  318.52  324.74 
             331.37  338.39  370.33  454.64 
/
 7  3  4  1  277.42  270.35  266.10  266.41  268.18 
             270.73  274.30  278.21  282.68  287.69 
             293.19  299.19  305.66  312.59  319.97 
             327.79  336.03  373.76  466.41 
/
 7  3  5  1  254.59  238.88  228.92  228.90  233.79 
             238.65  242.98  247.71  254.53  263.28 
             272.50  283.03  293.23  305.57  317.70 
             330.65  344.43  406.34  566.29 
/
 7  3  6  1  233.50  214.46  209.04  212.76  220.94 
             231.41  243.59  257.12  272.02  288.25 
             305.73  324.18  343.39  363.29  383.85 
             405.06  426.93  530.90  821.47 
/
 7  3  7  1  210.28  194.91  201.61  219.68  242.69 
             269.64  298.95  330.19  363.16  397.74 
             433.84  471.74  511.49  553.25  597.46 
             643.97  693.11  936.01 1544.45 
/
 7  3  8  1  183.19  194.66  244.34  307.62  379.27 
             458.40  546.39  643.72  750.81  868.08 
             995.39 1131.13 1277.20 1434.16 1601.83 
            1780.07 1968.92 2831.01 3135.67 
/
 7  4  1  1  317.72  316.63  316.59  317.33  318.52 
             320.10  322.03  324.28  326.87  329.78 
             333.00  336.53  340.38  344.54  349.01 
             353.79  358.87  382.29  443.83 
/
 7  4  2  1  306.46  303.82  302.94  303.42  304.58 
             306.25  308.34  310.84  313.73  316.99 
             320.61  324.60  328.94  333.64  338.68 
             344.08  349.82  376.23  445.36 
/
 7  4  3  1  293.90  288.54  286.67  287.01  288.31 
             290.26  292.90  295.92  299.39  303.31 
             307.66  312.41  317.59  323.16  329.14 
             335.51  342.26  373.06  455.33 
/
 7  4  4  1  283.22  276.52  272.89  273.26  274.87 
             277.24  280.54  284.19  288.38  293.07 
             298.25  303.90  310.01  316.56  323.55 
             330.97  338.81  374.31  464.55 
/
 7  4  5  1  260.15  245.03  234.73  233.66  238.12 
             243.83  248.33  253.35  260.42  268.14 
             276.47  285.64  295.45  305.91  317.39 
             329.05  341.35  398.24  545.00 
/
 7  4  6  1  239.63  219.94  212.14  215.90  221.98 
             230.68  240.96  252.61  265.39  279.27 
             294.20  310.21  327.17  344.89  363.23 
             382.18  401.69  491.81  750.82 
/
 7  4  7  1  215.77  199.28  201.32  216.18  235.15 
             257.95  283.40  310.65  339.43  369.60 
             401.11  433.93  468.04  503.76  541.04 
             579.98  621.01  816.68 1336.44 
/
 7  4  8  1  186.59  191.96  232.93  286.77  348.03 
             415.20  488.38  568.67  656.41  751.93 
             855.55  967.21 1085.79 1211.99 1346.79 
            1490.24 1642.19 2334.16 4101.23 
/
 7  5  1  1  321.71  320.64  320.62  321.35  322.54 
             324.10  326.01  328.25  330.82  333.70 
             336.90  340.42  344.24  348.38  352.82 
             357.58  362.64  385.95  447.29 
/
 7  5  2  1  311.56  309.11  308.35  308.85  310.00 
             311.63  313.68  316.12  318.93  322.11 
             325.65  329.54  333.78  338.38  343.31 
             348.59  354.21  380.09  447.94 
/
 7  5  3  1  300.23  295.25  293.53  293.86  295.09 
             296.94  299.31  302.14  305.60  309.33 
             313.47  318.03  322.98  328.32  334.04 
             340.15  346.63  376.27  454.48 
/
 7  5  4  1  289.85  283.44  280.47  280.85  282.31 
             284.49  287.54  290.94  294.84  299.23 
             304.08  309.38  315.12  321.29  327.89 
             334.90  342.32  375.95  463.39 
/
 7  5  5  1  266.25  251.98  241.55  239.55  243.29 
             248.53  254.44  259.56  265.44  272.94 
             280.82  289.35  298.43  308.44  318.63 
             329.86  341.64  393.90  526.84 
/
 7  5  6  1  246.58  226.58  217.42  220.66  224.81 
             231.51  239.93  249.62  260.47  272.14 
             284.73  298.16  312.44  327.60  343.55 
             360.18  377.37  455.96  684.23 
/
 7  5  7  1  222.34  203.76  202.35  213.79  229.32 
             247.60  268.79  292.04  316.73  342.65 
             369.72  397.87  427.10  457.42  488.83 
             521.45  555.38  706.11 1144.98 
/
 7  5  8  1  191.99  190.10  222.42  266.95  318.23 
             374.43  435.04  500.07  570.57  646.70 
             728.80  817.08  911.64 1012.17 1117.80 
            1229.84 1348.52 1888.81 3278.57 
/
 7  6  1  1  325.79  324.74  324.74  325.47  326.64 
             328.19  330.08  332.30  334.84  337.71 
             340.88  344.37  348.17  352.28  356.70 
             361.43  366.46  389.67  450.78 
/
 7  6  2  1  316.90  314.66  314.01  314.54  315.67 
             317.27  319.27  321.65  324.39  327.49 
             330.95  334.74  338.89  343.37  348.20 
             353.36  358.85  384.19  450.74 
/
 7  6  3  1  306.97  302.45  300.89  301.23  302.41 
             304.17  306.42  309.13  312.34  315.90 
             319.85  324.19  328.92  334.02  339.49 
             345.33  351.55  380.02  453.91 
/
 7  6  4  1  297.52  291.30  288.95  289.27  290.59 
             292.60  295.40  298.54  302.17  306.25 
             310.77  315.73  321.11  326.89  333.09 
             339.69  346.68  378.50  462.40 
/
 7  6  5  1  273.43  259.89  249.63  247.01  250.20 
             254.76  260.09  266.13  272.19  278.87 
             286.69  294.84  303.54  312.85  322.67 
             333.00  343.81  392.45  514.71 
/
 7  6  6  1  254.52  234.68  224.17  225.67  229.86 
             234.76  241.15  248.87  257.76  267.51 
             277.92  288.99  300.77  313.22  326.34 
             340.12  354.58  424.99  625.39 
/
 7  6  7  1  230.36  210.13  205.47  213.15  225.21 
             239.75  256.26  274.83  295.29  317.01 
             339.77  363.47  388.05  413.50  439.82 
             467.02  495.11  617.44  970.20 
/
 7  6  8  1  199.47  189.43  213.19  248.62  290.02 
             335.78  385.05  437.56  493.24  552.46 
             615.78  683.36  755.44  832.13  913.48 
             999.28 1088.87 1495.06 2550.68 
/
 7  7  1  1  329.96  328.94  328.94  329.67  330.83 
             332.36  334.23  336.43  338.95  341.78 
             344.93  348.40  352.17  356.25  360.64 
             365.34  370.35  393.44  454.31 
/
 7  7  2  1  322.49  320.48  319.95  320.50  321.62 
             323.18  325.13  327.45  330.13  333.15 
             336.52  340.22  344.27  348.64  353.36 
             358.40  363.77  388.56  453.78 
/
 7  7  3  1  314.16  310.17  308.81  309.17  310.30 
             312.00  314.16  316.73  319.71  323.08 
             326.83  330.96  335.46  340.32  345.55 
             351.13  357.07  384.35  455.48 
/
 7  7  4  1  306.17  300.34  298.35  298.61  299.82 
             301.66  304.22  307.12  310.47  314.25 
             318.45  323.07  328.08  333.49  339.28 
             345.47  352.03  382.01  460.54 
/
 7  7  5  1  281.63  269.13  259.57  257.01  259.64 
             263.48  268.10  273.34  279.26  285.83 
             293.03  300.83  309.21  318.15  327.56 
             337.38  347.67  393.48  505.44 
/
 7  7  6  1  263.61  244.69  233.15  232.20  237.22 
             242.09  245.82  251.58  258.42  266.27 
             274.73  283.75  293.31  303.28  313.81 
             324.88  336.46  404.55  573.32 
/
 7  7  7  1  240.32  218.49  211.79  215.46  223.81 
             234.68  247.32  261.30  276.70  293.47 
             311.64  330.90  350.97  371.80  393.33 
             415.55  438.44  536.98  808.56 
/
 7  7  8  1  207.24  191.51  206.75  232.17  264.08 
             299.59  338.11  379.17  422.54  468.17 
             516.09  566.24  619.18  675.08  734.01 
             796.15  861.57 1153.89 1933.56 
/
 7  8  1  1  334.23  333.23  333.24  333.95  335.10 
             336.61  338.46  340.63  343.13  345.94 
             349.06  352.49  356.24  360.29  364.65 
             369.32  374.30  397.26  457.88 
/
 7  8  2  1  328.36  326.59  326.18  326.75  327.86 
             329.39  331.29  333.55  336.15  339.10 
             342.38  345.99  349.94  354.21  358.81 
             363.73  368.98  393.21  457.08 
/
 7  8  3  1  321.81  318.44  317.32  317.72  318.81 
             320.42  322.45  324.89  327.71  330.91 
             334.47  338.39  342.66  347.29  352.27 
             357.59  363.26  389.35  457.67 
/
 7  8  4  1  315.52  310.48  308.74  308.99  310.09 
             311.78  314.12  316.79  319.88  323.37 
             327.26  331.53  336.19  341.22  346.61 
             352.38  358.52  386.63  459.77 
/
 7  8  5  1  290.99  280.46  272.33  270.85  272.87 
             275.76  279.77  284.16  289.14  294.70 
             300.82  307.48  314.66  322.36  330.54 
             339.21  348.35  389.18  489.53 
/
 7  8  6  1  274.10  257.22  245.37  242.20  246.36 
             251.72  257.61  262.12  267.19  274.29 
             281.51  290.87  299.78  309.61  320.06 
             331.10  342.75  395.12  532.92 
/
 7  8  7  1  252.87  230.43  220.14  223.46  227.55 
             234.37  243.10  253.09  264.24  276.27 
             289.21  303.06  317.78  333.38  349.86 
             367.15  385.05  462.20  667.31 
/
 7  8  8  1  218.55  200.39  203.56  220.39  241.53 
             266.98  295.14  325.25  357.13  390.71 
             425.86  462.52  500.61  540.24  581.43 
             624.17  668.51  866.04 1411.32 
/
 7  9  1  1  338.60  337.61  337.63  338.33  339.46 
             340.95  342.78  344.92  347.39  350.17 
             353.26  356.67  360.38  364.40  368.73 
             373.37  378.31  401.14  461.48 
/
 7  9  2  1  334.50  332.98  332.70  333.30  334.40 
             335.89  337.75  339.95  342.49  345.36 
             348.55  352.07  355.92  360.08  364.57 
             369.38  374.50  398.17  460.68 
/
 7  9  3  1  329.95  327.27  326.45  326.90  327.97 
             329.50  331.43  333.74  336.42  339.44 
             342.82  346.54  350.60  354.99  359.73 
             364.79  370.19  395.09  460.57 
/
 7  9  4  1  325.59  321.60  320.22  320.51  321.55 
             323.11  325.25  327.52  330.31  333.72 
             337.33  341.28  345.58  350.24  355.25 
             360.61  366.31  392.56  461.27 
/
 7  9  5  1  302.69  294.48  289.64  289.56  291.01 
             293.22  296.36  299.90  303.93  308.46 
             313.48  318.98  324.93  331.33  338.18 
             345.47  353.18  388.17  477.47 
/
 7  9  6  1  287.53  273.22  262.41  258.45  261.19 
             265.24  270.17  275.70  281.95  288.88 
             296.46  304.67  313.16  322.50  332.20 
             341.67  352.31  398.61  514.94 
/
 7  9  7  1  268.93  248.09  235.61  234.24  239.69 
             244.83  248.61  254.73  261.32  269.27 
             277.97  287.24  297.07  307.40  318.17 
             329.48  341.30  394.11  568.57 
/
 7  9  8  1  235.60  213.11  208.28  215.70  228.05 
             242.98  259.70  278.33  298.96  321.22 
             344.63  369.06  394.37  420.59  447.77 
             475.92  505.01  630.20  928.07 
/
 7 10  1  1  347.64  346.68  346.69  347.36  348.45 
             349.89  351.66  353.74  356.15  358.87 
             361.90  365.23  368.88  372.83  377.09 
             381.66  386.53  409.07  468.78 
/
 7 10  2  1  347.64  346.68  346.69  347.36  348.45 
             349.89  351.66  353.74  356.15  358.87 
             361.90  365.23  368.88  372.83  377.09 
             381.66  386.53  409.07  468.78 
/
 7 10  3  1  347.64  346.68  346.69  347.36  348.45 
             349.89  351.66  353.74  356.15  358.87 
             361.90  365.23  368.88  372.83  377.09 
             381.66  386.53  409.07  468.78 
/
 7 10  4  1  347.64  346.68  346.69  347.36  348.45 
             349.89  351.66  353.74  356.15  358.87 
             361.90  365.23  368.88  372.83  377.09 
             381.66  386.53  409.07  468.78 
/
 7 10  5  1  347.64  346.68  346.69  347.36  348.45 
             349.89  351.66  353.74  356.15  358.87 
             361.90  365.23  368.88  372.83  377.09 
             381.66  386.53  409.07  468.78 
/
 7 10  6  1  347.64  346.68  346.69  347.36  348.45 
             349.89  351.66  353.74  356.15  358.87 
             361.90  365.23  368.88  372.83  377.09 
             381.66  386.53  409.07  468.78 
/
 7 10  7  1  347.64  346.68  346.69  347.36  348.45 
             349.89  351.66  353.74  356.15  358.87 
             361.90  365.23  368.88  372.83  377.09 
             381.66  386.53  409.07  468.78 
/
 7 10  8  1  347.64  346.68  346.69  347.36  348.45 
             349.89  351.66  353.74  356.15  358.87 
             361.90  365.23  368.88  372.83  377.09 
             381.66  386.53  409.07  468.78 
/
 8  1  1  1  346.63  345.57  345.51  346.25  347.47 
             349.10  351.07  353.39  356.04  359.01 
             362.30  365.90  369.82  374.05  378.59 
             383.44  388.60  412.30  474.40 
/
 8  1  2  1  334.31  332.73  332.30  332.96  334.23 
             335.99  338.17  340.75  343.73  347.09 
             350.82  354.92  359.39  364.22  369.41 
             374.97  380.89  408.12  479.64 
/
 8  1  3  1  321.74  318.08  316.82  317.38  318.84 
             320.93  323.57  326.72  330.34  334.43 
             338.97  343.94  349.35  355.19  361.45 
             368.12  375.22  407.69  496.06 
/
 8  1  4  1  310.46  305.37  303.41  304.13  305.93 
             308.72  312.01  315.90  320.36  325.36 
             330.89  336.92  343.44  350.45  357.94 
             365.89  374.31  413.78  511.01 
/
 8  1  5  1  287.72  274.98  267.40  269.87  274.98 
             278.97  283.37  290.42  299.05  308.91 
             318.73  330.47  342.37  355.18  368.94 
             383.67  399.39  471.68  653.46 
/
 8  1  6  1  268.96  253.80  250.75  256.21  265.72 
             277.64  291.53  307.29  324.92  344.06 
             364.44  385.84  408.20  431.50  455.78 
             481.10  507.60  652.03 1004.02 
/
 8  1  7  1  248.84  236.45  247.75  268.69  296.03 
             327.45  361.96  399.20  439.18  481.87 
             527.75  576.85  629.45  685.79  746.09 
             812.79  887.05 1204.35 2025.39 
/
 8  1  8  1  226.37  243.27  301.55  378.02  469.00 
             574.65  694.98  830.46  981.25 1145.13 
            1324.16 1519.17 1729.90 1956.38 2198.69 
            2397.90 2393.09 2414.38 2427.36 
/
 8  2  1  1  350.34  349.29  349.25  350.00  351.22 
             352.83  354.80  357.11  359.73  362.69 
             365.96  369.55  373.45  377.66  382.18 
             387.01  392.15  415.77  477.72 
/
 8  2  2  1  338.62  337.07  336.70  337.36  338.62 
             340.35  342.50  345.04  347.96  351.26 
             354.92  358.95  363.35  368.10  373.20 
             378.67  384.49  411.28  481.70 
/
 8  2  3  1  326.58  323.05  321.87  322.43  323.83 
             325.85  328.40  331.43  334.93  338.87 
             343.25  348.06  353.29  358.94  365.00 
             371.47  378.34  409.85  496.49 
/
 8  2  4  1  315.60  310.52  308.75  309.41  311.10 
             313.73  316.85  320.54  324.78  329.54 
             334.80  340.55  346.78  353.49  360.65 
             368.26  376.33  413.78  508.86 
/
 8  2  5  1  292.33  279.62  271.61  273.41  278.21 
             282.98  287.67  294.55  302.33  310.98 
             320.47  330.70  341.61  353.66  366.13 
             379.91  394.01  460.59  629.64 
/
 8  2  6  1  273.54  257.68  254.25  257.89  265.74 
             276.07  288.22  302.04  317.41  334.34 
             352.56  371.89  392.14  413.23  435.14 
             457.88  481.53  608.38  925.41 
/
 8  2  7  1  252.90  239.56  246.83  264.69  288.20 
             316.00  346.67  379.77  415.10  452.76 
             492.74  535.28  580.68  628.96  680.38 
             735.13  795.18 1079.55 1786.15 
/
 8  2  8  1  228.21  240.17  290.42  357.13  435.57 
             526.01  628.53  743.35  870.90 1010.87 
            1161.49 1325.09 1501.95 1691.85 1894.80 
            2110.84 2340.02 2711.65 2741.72 
/
 8  3  1  1  354.14  353.10  353.08  353.83  355.05 
             356.65  358.60  360.89  363.50  366.44 
             369.69  373.26  377.14  381.33  385.83 
             390.63  395.75  419.28  481.06 
/
 8  3  2  1  343.13  341.62  341.30  341.97  343.22 
             344.92  347.03  349.52  352.39  355.63 
             359.23  363.18  367.49  372.16  377.18 
             382.55  388.27  414.61  483.91 
/
 8  3  3  1  331.74  328.36  327.26  327.82  329.18 
             331.12  333.57  336.49  339.86  343.66 
             347.89  352.53  357.58  363.04  368.90 
             375.16  381.81  412.35  495.60 
/
 8  3  4  1  321.28  316.20  314.58  315.18  316.77 
             319.24  322.18  325.68  329.69  334.21 
             339.21  344.68  350.62  357.02  363.85 
             371.13  378.85  414.11  507.20 
/
 8  3  5  1  297.39  284.80  276.46  277.56  281.89 
             287.36  292.21  298.22  305.56  313.60 
             322.38  331.84  342.29  353.38  365.19 
             377.74  391.01  451.65  608.44 
/
 8  3  6  1  278.67  262.26  256.99  260.32  266.64 
             275.39  285.90  297.82  311.13  325.72 
             341.63  358.69  376.75  395.69  415.37 
             435.77  456.90  568.59  852.40 
/
 8  3  7  1  257.50  243.40  246.59  261.55  281.18 
             305.17  332.10  361.20  392.26  425.16 
             459.95  496.75  535.52  576.66  620.20 
             666.25  715.03  958.47 1564.07 
/
 8  3  8  1  230.77  237.73  279.98  337.24  404.52 
             480.86  566.94  662.86  768.90  885.31 
            1011.75 1146.72 1292.30 1448.71 1615.78 
            1793.45 1981.74 2841.97 3172.45 
/
 8  4  1  1  358.02  357.00  356.99  357.75  358.95 
             360.54  362.48  364.75  367.34  370.26 
             373.49  377.03  380.89  385.06  389.53 
             394.32  399.41  422.85  484.43 
/
 8  4  2  1  347.85  346.39  346.11  346.79  348.03 
             349.70  351.77  354.21  357.03  360.20 
             363.73  367.61  371.84  376.42  381.35 
             386.62  392.24  418.13  486.29 
/
 8  4  3  1  337.24  334.04  333.04  333.58  334.89 
             336.77  339.12  341.93  345.17  348.83 
             352.90  357.38  362.25  367.52  373.18 
             379.23  385.65  415.21  492.97 
/
 8  4  4  1  327.45  322.51  320.96  321.50  322.99 
             325.30  328.07  331.37  335.17  339.44 
             344.19  349.38  355.02  361.10  367.62 
             374.55  381.91  415.62  506.01 
/
 8  4  5  1  302.96  290.59  282.08  282.53  286.16 
             291.37  297.20  302.63  309.48  317.17 
             325.61  334.41  344.42  354.78  365.67 
             377.63  389.68  445.26  590.24 
/
 8  4  6  1  284.44  267.69  260.63  264.06  268.85 
             275.90  284.70  294.96  306.28  318.74 
             332.28  346.85  362.49  379.06  396.46 
             414.62  433.41  531.55  782.98 
/
 8  4  7  1  262.88  247.02  247.31  259.28  275.52 
             295.33  318.34  343.58  370.53  399.08 
             429.14  460.68  493.84  528.67  565.14 
             603.60  644.13  841.23 1356.98 
/
 8  4  8  1  234.68  235.97  270.34  318.52  375.40 
             439.28  510.35  589.09  675.63  770.23 
             873.07  983.97 1101.75 1227.51 1361.87 
            1504.90 1656.31 2346.35 4109.80 
/
 8  5  1  1  362.00  360.98  361.00  361.74  362.94 
             364.52  366.44  368.69  371.26  374.15 
             377.36  380.88  384.71  388.85  393.30 
             398.06  403.13  426.46  487.83 
/
 8  5  2  1  352.79  351.39  351.15  351.84  353.05 
             354.69  356.72  359.12  361.87  364.99 
             368.45  372.25  376.40  380.90  385.73 
             390.91  396.42  421.85  488.85 
/
 8  5  3  1  343.11  340.13  339.21  339.75  341.02 
             342.82  345.09  347.78  350.89  354.41 
             358.33  362.64  367.33  372.41  377.86 
             383.70  389.90  418.47  493.18 
/
 8  5  4  1  334.13  329.43  327.94  328.43  329.82 
             331.98  334.59  337.69  341.27  345.31 
             349.79  354.71  360.05  365.82  372.01 
             378.60  385.61  417.74  504.45 
/
 8  5  5  1  309.16  297.31  288.76  288.70  291.89 
             296.53  301.77  307.84  314.56  321.95 
             329.97  338.59  347.97  357.54  368.05 
             379.13  390.70  442.19  573.91 
/
 8  5  6  1  290.95  274.18  265.65  269.10  272.45 
             278.14  285.10  293.66  303.31  313.74 
             325.09  337.33  350.42  364.34  379.16 
             394.76  411.07  499.51  719.76 
/
 8  5  7  1  269.29  251.89  249.51  258.28  271.38 
             287.25  305.88  327.02  350.00  374.38 
             400.05  426.94  455.05  484.36  514.91 
             546.83  580.13  729.22 1166.58 
/
 8  5  8  1  240.51  235.10  261.63  301.09  348.06 
             400.93  458.93  522.17  591.30  666.37 
             747.61  835.16  929.08 1028.91 1133.95 
            1245.60 1363.90 1902.59 3289.07 
/
 8  6  1  1  366.07  365.06  365.08  365.83  367.01 
             368.57  370.47  372.70  375.24  378.11 
             381.30  384.79  388.59  392.71  397.13 
             401.86  406.90  430.12  491.26 
/
 8  6  2  1  357.96  356.62  356.43  357.12  358.31 
             359.92  361.91  364.25  366.95  370.00 
             373.39  377.12  381.19  385.59  390.33 
             395.41  400.82  425.78  491.61 
/
 8  6  3  1  349.37  346.63  345.82  346.36  347.58 
             349.31  351.49  354.08  357.06  360.44 
             364.21  368.35  372.86  377.75  383.00 
             388.63  394.61  422.17  494.43 
/
 8  6  4  1  341.38  337.00  335.60  336.05  337.34 
             339.23  341.80  344.72  348.08  351.88 
             356.11  360.75  365.80  371.25  377.11 
             383.36  390.01  420.56  503.06 
/
 8  6  5  1  316.11  305.12  296.88  296.59  299.32 
             303.33  308.00  313.37  319.47  326.26 
             333.72  341.82  350.55  359.90  369.81 
             380.14  391.02  439.52  559.84 
/
 8  6  6  1  298.34  281.99  272.49  274.11  278.85 
             282.26  287.90  294.56  302.53  311.29 
             320.71  330.75  341.51  352.97  365.12 
             377.92  391.41  471.41  662.53 
/
 8  6  7  1  277.01  258.46  254.16  259.17  269.06 
             281.53  296.02  312.50  331.02  351.18 
             372.64  395.14  418.64  443.10  468.52 
             494.91  522.27  642.46  996.26 
/
 8  6  8  1  247.48  235.58  254.64  285.24  322.76 
             365.18  411.74  462.15  516.05  574.09 
             636.33  703.09  774.47  850.56  931.36 
            1016.57 1105.58 1510.41 2564.60 
/
 8  7  1  1  370.23  369.23  369.26  369.99  371.16 
             372.70  374.58  376.79  379.31  382.15 
             385.30  388.77  392.55  396.63  401.03 
             405.73  410.74  433.83  494.72 
/
 8  7  2  1  363.38  362.11  361.96  362.65  363.82 
             365.40  367.34  369.63  372.28  375.26 
             378.58  382.23  386.21  390.53  395.18 
             400.15  405.46  429.94  494.57 
/
 8  7  3  1  356.07  353.60  352.91  353.45  354.63 
             356.30  358.38  360.86  363.73  366.97 
             370.58  374.55  378.89  383.59  388.64 
             394.05  399.81  426.37  496.15 
/
 8  7  4  1  349.25  345.27  344.00  344.43  345.64 
             347.41  349.80  352.53  355.68  359.25 
             363.22  367.59  372.35  377.49  383.02 
             388.94  395.23  424.17  499.71 
/
 8  7  5  1  323.92  314.22  306.98  306.90  309.13 
             312.51  316.54  321.19  326.49  332.41 
             338.94  346.05  353.73  361.97  370.75 
             380.07  390.04  433.88  542.61 
/
 8  7  6  1  306.90  291.48  281.37  281.23  285.49 
             291.15  294.73  298.62  304.93  311.99 
             319.68  327.95  337.53  349.47  363.29 
             374.69  388.92  450.84  615.90 
/
 8  7  7  1  286.44  266.91  260.06  263.20  269.67 
             278.77  289.68  302.04  315.87  331.07 
             347.66  365.54  384.51  404.40  425.09 
             446.52  468.70  564.97  840.34 
/
 8  7  8  1  255.49  240.10  250.17  271.63  299.95 
             332.54  368.37  407.18  448.66  492.79 
             539.35  588.38  640.53  695.64  753.96 
             815.57  880.50 1171.02 1948.29 
/
 8  8  1  1  374.48  373.50  373.53  374.25  375.40 
             376.92  378.77  380.95  383.45  386.26 
             389.39  392.82  396.57  400.62  404.99 
             409.66  414.63  437.60  498.21 
/
 8  8  2  1  369.06  367.86  367.75  368.44  369.59 
             371.13  373.03  375.27  377.86  380.77 
             384.02  387.59  391.49  395.72  400.27 
             405.14  410.34  434.35  497.76 
/
 8  8  3  1  363.24  361.08  360.51  361.07  362.21 
             363.81  365.81  368.18  370.93  374.03 
             377.49  381.31  385.47  389.97  394.83 
             400.02  405.56  431.11  498.39 
/
 8  8  4  1  357.79  354.33  353.23  353.66  354.81 
             356.47  358.58  361.09  364.01  367.53 
             371.25  375.35  379.82  384.66  389.87 
             395.44  401.38  428.70  500.30 
/
 8  8  5  1  332.86  324.86  319.77  320.11  321.88 
             324.42  328.03  331.96  336.46  341.52 
             347.11  353.23  359.86  366.98  374.60 
             382.71  391.29  430.83  528.58 
/
 8  8  6  1  317.55  303.15  293.11  291.51  294.94 
             299.84  305.48  311.61  317.19  324.29 
             332.18  340.39  349.53  359.26  369.57 
             380.45  391.85  444.15  580.25 
/
 8  8  7  1  298.12  278.66  268.82  271.99  275.45 
             281.14  288.34  296.98  306.91  317.75 
             329.49  342.15  355.74  370.23  385.65 
             401.97  419.08  493.98  704.20 
/
 8  8  8  1  266.64  248.45  249.30  263.03  281.34 
             303.74  329.64  357.78  387.80  419.70 
             453.40  488.78  525.82  564.48  604.78 
             646.73  690.42  886.10 1431.93 
/
 8  9  1  1  378.83  377.85  377.88  378.59  379.72 
             381.22  383.04  385.20  387.66  390.44 
             393.54  396.94  400.66  404.68  409.01 
             413.65  418.59  441.42  501.73 
/
 8  9  2  1  375.02  373.90  373.83  374.50  375.63 
             377.14  379.00  381.19  383.71  386.56 
             389.74  393.23  397.05  401.18  405.64 
             410.41  415.50  439.01  501.20 
/
 8  9  3  1  370.90  369.09  368.68  369.26  370.37 
             371.91  373.82  376.10  378.73  381.70 
             385.01  388.66  392.65  396.97  401.62 
             406.60  411.92  436.46  501.22 
/
 8  9  4  1  367.07  364.25  363.41  363.86  364.95 
             366.52  368.50  370.86  373.61  376.74 
             380.31  384.15  388.33  392.87  397.76 
             402.99  408.57  434.28  501.92 
/
 8  9  5  1  346.27  339.30  336.77  337.07  338.42 
             340.47  343.38  346.62  350.36  354.58 
             359.26  364.40  370.00  376.03  382.50 
             389.38  396.71  430.15  517.83 
/
 8  9  6  1  330.68  318.77  309.62  308.10  310.52 
             314.10  318.47  323.43  329.07  335.37 
             342.30  349.85  357.98  366.70  375.99 
             385.84  396.02  441.85  555.54 
/
 8  9  7  1  312.82  295.47  284.28  283.46  288.14 
             293.96  297.37  301.66  307.76  314.87 
             322.80  331.30  340.36  349.95  359.92 
             370.45  381.51  436.57  609.95 
/
 8  9  8  1  283.14  261.93  257.60  261.95  272.03 
             284.89  299.71  316.47  335.15  355.86 
             378.05  401.36  425.68  450.89  477.10 
             504.34  532.62  655.33  949.97 
/
 8 10  1  1  387.82  386.86  386.87  387.55  388.63 
             390.07  391.84  393.93  396.32  399.04 
             402.07  405.40  409.04  412.99  417.25 
             421.81  426.68  449.20  508.86 
/
 8 10  2  1  387.82  386.86  386.87  387.55  388.63 
             390.07  391.84  393.93  396.32  399.04 
             402.07  405.40  409.04  412.99  417.25 
             421.81  426.68  449.20  508.86 
/
 8 10  3  1  387.82  386.86  386.87  387.55  388.63 
             390.07  391.84  393.93  396.32  399.04 
             402.07  405.40  409.04  412.99  417.25 
             421.81  426.68  449.20  508.86 
/
 8 10  4  1  387.82  386.86  386.87  387.55  388.63 
             390.07  391.84  393.93  396.32  399.04 
             402.07  405.40  409.04  412.99  417.25 
             421.81  426.68  449.20  508.86 
/
 8 10  5  1  387.82  386.86  386.87  387.55  388.63 
             390.07  391.84  393.93  396.32  399.04 
             402.07  405.40  409.04  412.99  417.25 
             421.81  426.68  449.20  508.86 
/
 8 10  6  1  387.82  386.86  386.87  387.55  388.63 
             390.07  391.84  393.93  396.32  399.04 
             402.07  405.40  409.04  412.99  417.25 
             421.81  426.68  449.20  508.86 
/
 8 10  7  1  387.82  386.86  386.87  387.55  388.63 
             390.07  391.84  393.93  396.32  399.04 
             402.07  405.40  409.04  412.99  417.25 
             421.81  426.68  449.20  508.86 
/
 8 10  8  1  387.82  386.86  386.87  387.55  388.63 
             390.07  391.84  393.93  396.32  399.04 
             402.07  405.40  409.04  412.99  417.25 
             421.81  426.68  449.20  508.86 
/
 9  1  1  1  366.75  365.73  365.69  366.44  367.67 
             369.30  371.29  373.62  376.27  379.24 
             382.54  386.15  390.08  394.32  398.86 
             403.72  408.88  432.62  494.76 
/
 9  1  2  1  354.70  353.43  353.25  354.00  355.32 
             357.09  359.28  361.86  364.82  368.15 
             371.86  375.94  380.38  385.18  390.34 
             395.86  401.75  428.84  500.07 
/
 9  1  3  1  342.88  340.15  339.28  339.94  341.39 
             343.44  346.01  349.06  352.58  356.55 
             360.96  365.81  371.08  376.79  382.91 
             389.46  396.41  428.36  517.92 
/
 9  1  4  1  332.32  327.99  326.68  327.43  329.17 
             331.81  334.95  338.68  342.95  347.75 
             353.06  358.87  365.18  371.97  379.23 
             386.97  395.21  433.40  531.58 
/
 9  1  5  1  308.82  297.19  290.38  293.18  298.21 
             302.76  308.44  315.71  323.84  333.02 
             343.06  353.84  365.80  378.30  392.09 
             406.33  422.08  492.91  674.82 
/
 9  1  6  1  290.86  276.78  274.24  279.16  287.78 
             298.93  312.04  327.01  343.79  362.15 
             381.86  402.73  424.61  447.48  471.40 
             496.46  523.63  669.25 1018.75 
/
 9  1  7  1  271.67  259.82  269.63  289.05  314.78 
             344.92  378.26  414.49  453.68  495.73 
             541.14  589.83  642.14  698.26  758.41 
             826.48  899.71 1215.91 2034.89 
/
 9  1  8  1  249.42  264.31  319.11  392.72  482.01 
             586.48  706.00  840.90  991.14 1154.45 
            1333.07 1527.70 1738.05 1964.17 2206.19 
            2395.27 2398.14 2420.38 2398.16 
/
 9  2  1  1  370.46  369.44  369.42  370.18  371.41 
             373.03  375.01  377.32  379.95  382.91 
             386.19  389.79  393.69  397.91  402.44 
             407.27  412.42  436.07  498.05 
/
 9  2  2  1  358.99  357.74  357.59  358.34  359.64 
             361.39  363.54  366.08  368.98  372.26 
             375.91  379.91  384.28  389.00  394.08 
             399.51  405.30  431.97  502.12 
/
 9  2  3  1  347.63  344.98  344.17  344.82  346.24 
             348.22  350.71  353.66  357.06  360.90 
             365.18  369.87  374.98  380.51  386.45 
             392.80  399.55  430.58  516.33 
/
 9  2  4  1  337.42  333.15  331.87  332.57  334.22 
             336.73  339.71  343.26  347.33  351.91 
             356.98  362.54  368.57  375.07  382.04 
             389.47  397.37  433.48  529.66 
/
 9  2  5  1  313.35  301.72  294.49  296.75  301.31 
             306.63  311.70  318.45  326.16  334.67 
             344.18  354.24  365.26  377.07  389.68 
             403.07  417.26  482.45  651.34 
/
 9  2  6  1  295.34  280.66  277.46  280.87  288.15 
             297.77  309.27  322.36  336.98  353.15 
             370.68  389.39  409.15  429.81  451.33 
             473.74  497.10  627.11  940.71 
/
 9  2  7  1  275.64  263.00  269.03  285.58  307.59 
             334.08  363.66  395.75  430.24  467.24 
             506.61  548.80  593.79  641.80  693.02 
             747.62  809.40 1090.31 1798.64 
/
 9  2  8  1  251.31  261.61  308.67  372.63  449.17 
             538.37  640.00  754.18  881.23 1020.70 
            1170.88 1334.11 1510.62 1700.16 1902.78 
            2118.56 2347.48 2718.08 2746.62 
/
 9  3  1  1  374.26  373.25  373.25  374.01  375.23 
             376.84  378.80  381.09  383.71  386.65 
             389.91  393.48  397.37  401.56  406.07 
             410.88  416.00  439.56  501.37 
/
 9  3  2  1  363.48  362.25  362.13  362.88  364.16 
             365.88  367.99  370.49  373.34  376.56 
             380.14  384.08  388.37  393.01  398.00 
             403.34  409.03  435.26  504.32 
/
 9  3  3  1  352.69  350.14  349.39  350.04  351.41 
             353.33  355.73  358.58  361.87  365.59 
             369.72  374.26  379.21  384.56  390.31 
             396.47  403.01  433.12  512.66 
/
 9  3  4  1  342.94  338.78  337.53  338.18  339.74 
             342.10  344.94  348.30  352.17  356.53 
             361.37  366.67  372.43  378.65  385.31 
             392.43  399.99  434.62  528.21 
/
 9  3  5  1  318.32  306.82  299.28  300.97  305.07 
             310.26  315.81  321.88  329.25  337.36 
             346.25  355.86  366.16  377.03  389.00 
             401.74  414.63  475.14  630.52 
/
 9  3  6  1  300.34  285.20  280.33  283.56  289.39 
             297.53  307.49  318.79  331.44  345.38 
             360.59  377.01  394.47  412.92  432.22 
             452.28  473.09  586.74  868.30 
/
 9  3  7  1  280.17  266.51  269.11  282.91  301.26 
             323.94  349.80  377.97  408.18  440.33 
             474.57  510.83  549.20  590.06  633.29 
             679.14  727.76  972.30 1574.32 
/
 9  3  8  1  253.99  259.54  298.93  353.58  418.80 
             493.85  578.98  674.19  779.68  895.66 
            1021.63 1156.21 1301.52 1457.62 1624.37 
            1801.72 1989.77 2849.01 3137.49 
/
 9  4  1  1  378.15  377.14  377.15  377.91  379.13 
             380.72  382.67  384.94  387.54  390.46 
             393.70  397.24  401.11  405.28  409.76 
             414.55  419.65  443.10  504.71 
/
 9  4  2  1  368.18  366.98  366.88  367.62  368.89 
             370.57  372.65  375.09  377.89  381.05 
             384.57  388.43  392.64  397.20  402.11 
             407.36  412.95  438.74  506.69 
/
 9  4  3  1  358.08  355.65  354.97  355.61  356.94 
             358.79  361.11  363.86  367.04  370.62 
             374.61  379.00  383.79  388.96  394.53 
             400.49  406.82  435.99  512.46 
/
 9  4  4  1  348.92  344.90  343.70  344.30  345.77 
             348.00  350.68  353.87  357.54  361.69 
             366.28  371.33  376.82  382.74  389.11 
             395.91  403.13  436.26  526.18 
/
 9  4  5  1  323.82  312.67  304.93  306.07  309.48 
             314.44  320.00  326.33  333.29  340.89 
             349.33  358.61  368.16  378.65  389.70 
             401.33  414.17  470.18  612.96 
/
 9  4  6  1  305.97  290.58  284.04  287.57  291.86 
             298.46  306.81  316.56  327.34  339.23 
             352.19  366.18  381.24  397.25  414.14 
             431.86  450.33  550.48  801.53 
/
 9  4  7  1  285.48  270.24  270.18  281.13  296.30 
             314.93  336.82  361.15  387.32  415.14 
             444.55  475.53  508.27  542.68  578.83 
             617.09  657.36  855.76 1367.77 
/
 9  4  8  1  258.01  258.12  289.96  335.81  390.70 
             453.00  523.08  601.04  686.98  781.11 
             883.56  994.07 1111.45 1236.97 1371.15 
            1513.88 1665.00 2354.08 4114.70 
/
 9  5  1  1  382.12  381.12  381.15  381.90  383.11 
             384.69  386.61  388.87  391.44  394.34 
             397.55  401.07  404.91  409.06  413.51 
             418.27  423.34  446.69  508.08 
/
 9  5  2  1  373.09  371.92  371.84  372.58  373.82 
             375.48  377.51  379.91  382.65  385.75 
             389.20  392.99  397.13  401.60  406.42 
             411.57  417.07  442.41  509.22 
/
 9  5  3  1  363.84  361.55  360.94  361.57  362.85 
             364.64  366.88  369.53  372.59  376.05 
             379.90  384.13  388.75  393.75  399.13 
             404.89  411.02  439.25  513.37 
/
 9  5  4  1  355.40  351.58  350.43  350.99  352.38 
             354.47  357.00  360.02  363.50  367.42 
             371.78  376.57  381.79  387.43  393.50 
             399.97  406.85  438.47  525.53 
/
 9  5  5  1  329.94  319.35  311.71  312.41  315.42 
             319.83  324.81  330.60  337.18  344.50 
             352.54  361.28  370.73  380.76  391.32 
             402.49  414.16  466.41  597.32 
/
 9  5  6  1  312.31  296.97  288.89  292.39  295.75 
             301.03  307.67  315.88  325.09  335.07 
             345.93  357.68  370.30  383.74  398.05 
             413.18  429.06  520.53  738.82 
/
 9  5  7  1  291.79  275.36  272.75  280.64  292.82 
             307.74  325.35  345.52  367.69  391.41 
             416.46  442.80  470.39  499.24  529.46 
             561.05  594.06  745.46 1180.24 
/
 9  5  8  1  263.90  257.62  282.02  319.39  364.48 
             415.80  472.53  534.92  603.38  677.92 
             758.73  845.93  939.52 1038.96 1143.73 
            1255.20 1373.32 1911.10 3296.02 
/
 9  6  1  1  386.18  385.20  385.23  385.98  387.17 
             388.73  390.63  392.86  395.41  398.29 
             401.47  404.97  408.78  412.90  417.32 
             422.06  427.10  450.33  511.48 
/
 9  6  2  1  378.23  377.09  377.04  377.77  378.99 
             380.61  382.60  384.95  387.64  390.68 
             394.05  397.77  401.83  406.22  410.94 
             416.00  421.39  446.28  511.94 
/
 9  6  3  1  369.99  367.86  367.32  367.94  369.19 
             370.91  373.06  375.62  378.56  381.90 
             385.61  389.69  394.15  398.97  404.16 
             409.72  415.64  442.92  514.67 
/
 9  6  4  1  362.43  358.87  357.79  358.32  359.63 
             361.50  363.85  366.82  370.11  373.82 
             377.94  382.48  387.43  392.79  398.55 
             404.70  411.25  441.34  520.58 
/
 9  6  5  1  336.78  327.06  319.95  320.47  323.03 
             326.85  331.26  336.38  342.21  348.72 
             355.89  363.70  372.12  381.16  390.87 
             401.10  411.76  459.33  578.30 
/
 9  6  6  1  319.56  304.63  295.67  297.58  302.45 
             305.49  310.79  317.30  324.94  333.34 
             342.44  352.14  362.50  373.55  385.31 
             397.74  415.59  493.11  684.04 
/
 9  6  7  1  299.35  281.73  277.89  282.05  291.18 
             302.86  316.55  332.22  349.89  369.28 
             390.12  412.12  435.14  459.16  484.19 
             510.22  537.27  656.55 1010.81 
/
 9  6  8  1  270.70  258.59  275.86  304.51  340.45 
             381.39  426.69  476.05  529.13  586.57 
             648.30  714.65  785.70  861.50  942.01 
            1026.89 1115.62 1519.83 2573.02 
/
 9  7  1  1  390.34  389.36  389.39  390.13  391.31 
             392.85  394.73  396.94  399.46  402.31 
             405.46  408.93  412.71  416.80  421.20 
             425.90  430.91  454.02  514.91 
/
 9  7  2  1  383.62  382.51  382.47  383.20  384.39 
             385.98  387.92  390.22  392.86  395.83 
             399.14  402.78  406.76  411.06  415.70 
             420.66  425.95  450.37  514.87 
/
 9  7  3  1  376.57  374.62  374.16  374.78  375.98 
             377.64  379.71  382.17  385.01  388.21 
             391.78  395.71  400.00  404.65  409.65 
             415.01  420.72  447.06  516.42 
/
 9  7  4  1  370.08  366.83  365.85  366.37  367.60 
             369.37  371.60  374.26  377.45  380.95 
             384.85  389.15  393.83  398.89  404.34 
             410.18  416.38  444.96  519.83 
/
 9  7  5  1  344.46  335.93  330.09  330.68  332.79 
             336.02  339.85  344.29  349.37  355.06 
             361.34  368.20  375.63  383.60  392.13 
             401.19  410.77  454.28  561.78 
/
 9  7  6  1  328.35  313.89  304.45  304.83  308.88 
             314.59  318.67  323.58  330.37  337.69 
             345.86  354.88  364.73  376.48  388.33 
             400.51  413.39  474.55  638.04 
/
 9  7  7  1  308.55  290.16  283.55  286.76  292.49 
             300.96  311.22  322.97  336.18  350.75 
             366.68  383.96  402.36  421.79  442.08 
             463.17  485.03  580.35  858.20 
/
 9  7  8  1  278.77  263.89  272.13  292.14  318.88 
             350.26  384.94  422.71  463.31  506.69 
             552.60  601.12  652.85  707.60  765.63 
             826.98  891.66 1181.29 1957.32 
/
 9  8  1  1  394.59  393.62  393.65  394.38  395.53 
             397.05  398.91  401.09  403.59  406.40 
             409.53  412.97  416.72  420.77  425.14 
             429.81  434.79  457.75  518.36 
/
 9  8  2  1  389.26  388.19  388.17  388.88  390.05 
             391.60  393.50  395.75  398.33  401.24 
             404.48  408.04  411.94  416.15  420.69 
             425.56  430.74  454.70  518.01 
/
 9  8  3  1  383.61  381.87  381.50  382.12  383.28 
             384.88  386.87  389.23  391.96  395.04 
             398.47  402.25  406.38  410.85  415.66 
             420.82  426.32  451.70  518.66 
/
 9  8  4  1  378.39  375.54  374.71  375.22  376.40 
             378.07  380.20  382.73  385.64  388.94 
             392.61  396.65  401.07  405.85  411.00 
             416.51  422.38  449.43  520.51 
/
 9  8  5  1  353.51  346.52  342.89  343.49  345.19 
             347.64  351.10  354.88  359.23  364.12 
             369.53  375.46  381.90  388.83  396.25 
             404.15  412.53  450.79  548.45 
/
 9  8  6  1  338.78  325.42  315.94  315.16  318.41 
             323.10  328.48  334.67  341.08  348.14 
             356.14  364.73  373.98  383.56  394.09 
             405.21  416.89  469.74  605.52 
/
 9  8  7  1  319.90  301.76  292.28  295.41  298.88 
             304.17  310.90  319.13  328.61  338.99 
             350.25  362.43  375.52  389.54  404.49 
             420.38  437.09  510.98  727.69 
/
 9  8  8  1  289.72  271.85  272.12  284.70  301.91 
             323.09  347.94  375.27  404.51  435.64 
             468.67  503.44  540.01  578.18  618.04 
             659.61  703.01  897.80 1443.96 
/
 9  9  1  1  398.93  397.96  398.00  398.71  399.84 
             401.34  403.17  405.32  407.79  410.57 
             413.67  417.07  420.79  424.81  429.14 
             433.77  438.72  461.54  521.85 
/
 9  9  2  1  395.18  394.15  394.14  394.84  395.98 
             397.49  399.35  401.55  404.06  406.91 
             410.08  413.57  417.38  421.51  425.95 
             430.72  435.80  459.28  521.38 
/
 9  9  3  1  391.16  389.65  389.38  390.00  391.14 
             392.68  394.59  396.86  399.47  402.43 
             405.72  409.35  413.32  417.61  422.24 
             427.20  432.49  456.91  521.45 
/
 9  9  4  1  387.44  385.09  384.46  384.99  386.11 
             387.69  389.68  392.04  394.78  397.87 
             401.32  405.13  409.28  413.78  418.62 
             423.81  429.34  454.87  522.16 
/
 9  9  5  1  367.97  361.49  359.43  359.77  361.10 
             363.09  365.93  369.09  372.73  376.84 
             381.41  386.43  391.90  397.80  404.13 
             410.89  418.07  450.95  538.20 
/
 9  9  6  1  351.64  340.82  332.46  332.00  334.29 
             337.70  341.86  346.61  352.03  358.08 
             364.76  372.05  379.93  388.38  397.40 
             406.98  417.08  462.12  574.39 
/
 9  9  7  1  334.58  318.18  307.58  307.19  311.62 
             317.39  321.22  324.70  330.70  337.49 
             345.13  353.36  362.16  371.50  381.23 
             391.47  402.24  466.36  632.31 
/
 9  9  8  1  305.92  285.47  281.38  284.94  294.20 
             306.26  320.33  336.33  354.24  374.21 
             395.82  418.66  442.55  467.36  493.13 
             519.96  547.86  669.40  962.53 
/
 9 10  1  1  407.91  406.95  406.96  407.64  408.72 
             410.16  411.93  414.01  416.41  419.13 
             422.15  425.48  429.12  433.07  437.33 
             441.89  446.75  469.26  528.90 
/
 9 10  2  1  407.91  406.95  406.96  407.64  408.72 
             410.16  411.93  414.01  416.41  419.13 
             422.15  425.48  429.12  433.07  437.33 
             441.89  446.75  469.26  528.90 
/
 9 10  3  1  407.91  406.95  406.96  407.64  408.72 
             410.16  411.93  414.01  416.41  419.13 
             422.15  425.48  429.12  433.07  437.33 
             441.89  446.75  469.26  528.90 
/
 9 10  4  1  407.91  406.95  406.96  407.64  408.72 
             410.16  411.93  414.01  416.41  419.13 
             422.15  425.48  429.12  433.07  437.33 
             441.89  446.75  469.26  528.90 
/
 9 10  5  1  407.91  406.95  406.96  407.64  408.72 
             410.16  411.93  414.01  416.41  419.13 
             422.15  425.48  429.12  433.07  437.33 
             441.89  446.75  469.26  528.90 
/
 9 10  6  1  407.91  406.95  406.96  407.64  408.72 
             410.16  411.93  414.01  416.41  419.13 
             422.15  425.48  429.12  433.07  437.33 
             441.89  446.75  469.26  528.90 
/
 9 10  7  1  407.91  406.95  406.96  407.64  408.72 
             410.16  411.93  414.01  416.41  419.13 
             422.15  425.48  429.12  433.07  437.33 
             441.89  446.75  469.26  528.90 
/
 9 10  8  1  407.91  406.95  406.96  407.64  408.72 
             410.16  411.93  414.01  416.41  419.13 
             422.15  425.48  429.12  433.07  437.33 
             441.89  446.75  469.26  528.90 
/
