# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.azurestackhcivm import AzureStackHCIVmClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAzureStackHCIVmVirtualHardDisksOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AzureStackHCIVmClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_hard_disks_get(self, resource_group):
        response = self.client.virtual_hard_disks.get(
            resource_group_name=resource_group.name,
            virtual_hard_disk_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_hard_disks_begin_create_or_update(self, resource_group):
        response = self.client.virtual_hard_disks.begin_create_or_update(
            resource_group_name=resource_group.name,
            virtual_hard_disk_name="str",
            resource={
                "location": "str",
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "name": "str",
                "properties": {
                    "blockSizeBytes": 0,
                    "containerId": "str",
                    "createFromLocal": bool,
                    "diskFileFormat": "str",
                    "diskSizeGB": 0,
                    "downloadUrl": "str",
                    "dynamic": bool,
                    "hyperVGeneration": "str",
                    "logicalSectorBytes": 0,
                    "maxShares": 0,
                    "physicalSectorBytes": 0,
                    "provisioningState": "str",
                    "status": {
                        "downloadStatus": {"downloadedSizeInMB": 0, "progressPercentage": 0, "status": "str"},
                        "errorCode": "str",
                        "errorMessage": "str",
                        "managedBy": ["str"],
                        "provisioningStatus": {"operationId": "str", "status": "str"},
                        "uniqueId": "str",
                        "uploadStatus": {
                            "errorCode": "str",
                            "errorMessage": "str",
                            "progressPercentage": 0,
                            "status": "str",
                            "uploadedSizeInMB": 0,
                        },
                    },
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_hard_disks_begin_update(self, resource_group):
        response = self.client.virtual_hard_disks.begin_update(
            resource_group_name=resource_group.name,
            virtual_hard_disk_name="str",
            properties={"properties": {"diskSizeGB": 0}, "tags": {"str": "str"}},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_hard_disks_begin_delete(self, resource_group):
        response = self.client.virtual_hard_disks.begin_delete(
            resource_group_name=resource_group.name,
            virtual_hard_disk_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_hard_disks_list_by_resource_group(self, resource_group):
        response = self.client.virtual_hard_disks.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_hard_disks_list_all(self, resource_group):
        response = self.client.virtual_hard_disks.list_all()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_virtual_hard_disks_begin_upload(self, resource_group):
        response = self.client.virtual_hard_disks.begin_upload(
            resource_group_name=resource_group.name,
            virtual_hard_disk_name="str",
            body={"azureManagedDiskUploadUrl": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
