# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementFlowLogsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_flow_logs_begin_create_or_update(self, resource_group):
        response = self.client.flow_logs.begin_create_or_update(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            flow_log_name="str",
            parameters={
                "enabled": bool,
                "enabledFilteringCriteria": "str",
                "etag": "str",
                "flowAnalyticsConfiguration": {
                    "networkWatcherFlowAnalyticsConfiguration": {
                        "enabled": bool,
                        "trafficAnalyticsInterval": 0,
                        "workspaceId": "str",
                        "workspaceRegion": "str",
                        "workspaceResourceId": "str",
                    }
                },
                "format": {"type": "str", "version": 0},
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "location": "str",
                "name": "str",
                "provisioningState": "str",
                "recordTypes": "str",
                "retentionPolicy": {"days": 0, "enabled": False},
                "storageId": "str",
                "tags": {"str": "str"},
                "targetResourceGuid": "str",
                "targetResourceId": "str",
                "type": "str",
            },
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_flow_logs_update_tags(self, resource_group):
        response = self.client.flow_logs.update_tags(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            flow_log_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_flow_logs_get(self, resource_group):
        response = self.client.flow_logs.get(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            flow_log_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_flow_logs_begin_delete(self, resource_group):
        response = self.client.flow_logs.begin_delete(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            flow_log_name="str",
            api_version="2025-03-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_flow_logs_list(self, resource_group):
        response = self.client.flow_logs.list(
            resource_group_name=resource_group.name,
            network_watcher_name="str",
            api_version="2025-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
