% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-introspect.R
\name{method}
\alias{method}
\title{Find a method for an S7 generic}
\usage{
method(generic, class = NULL, object = NULL)
}
\arguments{
\item{generic}{A generic function, i.e. an \link[=new_generic]{S7 generic},
an \link[=new_external_generic]{external generic}, an \link[=UseMethod]{S3 generic},
or an \link[methods:setGeneric]{S4 generic}.}

\item{class, object}{Perform introspection either with a \code{class}
(processed with \code{\link[=as_class]{as_class()}}) or a concrete \code{object}. If \code{generic} uses
multiple dispatch then both \code{object} and \code{class} must be a list of
classes/objects.}
}
\value{
Either a function with class \code{S7_method} or an error if no
matching method is found.
}
\description{
\code{method()} takes a generic and class signature and performs method dispatch
to find the corresponding method implementation. This is rarely needed
because you'll usually rely on the the generic to do dispatch for you (via
\code{\link[=S7_dispatch]{S7_dispatch()}}). However, this introspection is useful if you want to see
the implementation of a specific method.
}
\examples{
# Create a generic and register some methods
bizarro <- new_generic("bizarro", "x")
method(bizarro, class_numeric) <- function(x) rev(x)
method(bizarro, class_factor) <- function(x) {
  levels(x) <- rev(levels(x))
  x
}

# Printing the generic shows the registered method
bizarro

# And you can use method() to inspect specific implementations
method(bizarro, class = class_integer)
method(bizarro, object = 1)
method(bizarro, class = class_factor)

# errors if method not found
try(method(bizarro, class = class_data.frame))
try(method(bizarro, object = "x"))
}
\seealso{
\code{\link[=method_explain]{method_explain()}} to explain why a specific method was picked.
}
