// Copyright (c) 2022 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCRAND_MRG31K3P_PRECOMPUTED_H_
#define ROCRAND_MRG31K3P_PRECOMPUTED_H_

// Auto-generated file. Do not edit!
// Generated by tools/mrg31k3p_precomputed_generator

#define MRG31K3P_DIM 64
#define MRG31K3P_N 576

static const __device__ unsigned int d_mrg31k3p_A1[MRG31K3P_N] = {
    // clang-format off
    0, 4194304, 129, 1, 0, 0, 0, 1, 0, 
    4194304, 129, 0, 0, 4194304, 129, 1, 0, 0, 
    8192, 1082130432, 16641, 129, 8192, 541065216, 4194304, 129, 0, 
    1153433697, 2154945, 408969216, 3170304, 1153433697, 2148753, 16657, 3170304, 8388673, 
    2114723322, 1721212208, 372069324, 2050484945, 2114723322, 840597819, 2104058429, 2050484945, 1854761289, 
    2031391056, 1474597190, 220631129, 667596721, 2031391056, 1804643306, 629934405, 667596721, 667011916, 
    1626637155, 47085990, 25108805, 1565027687, 1626637155, 685757807, 621260874, 1565027687, 1315045259, 
    186789822, 229794953, 948835832, 1072773560, 186789822, 529689580, 686639683, 1072773560, 2051914008, 
    133777926, 1849297334, 1160315623, 391879376, 133777926, 976116713, 1472516881, 391879376, 1133340572, 
    315040025, 1357549030, 448994521, 1634902263, 315040025, 318362774, 468588410, 1634902263, 876161549, 
    1108588757, 1006700199, 1139321936, 624776875, 1108588757, 288253948, 85470327, 624776875, 609299647, 
    1800574616, 1663202423, 368689287, 2000517263, 1800574616, 1059509691, 1106925817, 2000517263, 754030956, 
    1086502913, 1682234256, 1789246123, 1245759969, 1086502913, 1809824555, 1329155292, 1245759969, 161160027, 
    1720262475, 565559801, 1398990386, 1325970531, 1720262475, 147733919, 866797547, 1325970531, 1806649895, 
    1476358256, 539279285, 975405418, 1139568166, 1476358256, 377670014, 1068345918, 1139568166, 1214224795, 
    400054507, 1914771670, 200204594, 1965916860, 400054507, 1122402837, 258408198, 1965916860, 1448125803, 
    2949404, 1576782032, 520268929, 1086098496, 2949404, 1306225290, 1408487222, 1086098496, 847447860, 
    381424493, 1433687186, 455906132, 1518425721, 381424493, 923210727, 1755108478, 1518425721, 1996997890, 
    928372573, 545485986, 280054605, 1250707970, 928372573, 534654589, 2085039616, 1250707970, 924300230, 
    1362662654, 1947668898, 168367491, 201071095, 1362662654, 1985024917, 2146224277, 201071095, 733519514, 
    1620396146, 958413413, 1981393580, 581363082, 1620396146, 1452205810, 2042210936, 581363082, 1113090973, 
    580884245, 1414992990, 1420238151, 909956241, 580884245, 805041652, 938481596, 909956241, 864263945, 
    1232863855, 1411246633, 1387550558, 1275940370, 1232863855, 1333257090, 1458638251, 1275940370, 1586530792, 
    265378350, 1344095500, 1646881501, 545475645, 265378350, 1087177574, 274782294, 545475645, 2051615169, 
    1364138796, 806636338, 1935176304, 414533208, 1364138796, 436727951, 619330410, 414533208, 1992074766, 
    1803497226, 1844275260, 2103387029, 382542847, 1803497226, 1847722410, 463796751, 382542847, 1739676813, 
    1913524296, 1430627077, 1356264156, 1658582521, 1913524296, 1456747786, 1393006903, 1658582521, 606375036, 
    120859840, 472996648, 1037593448, 1522934925, 120859840, 2026108949, 1880188197, 1522934925, 1035740173, 
    2111757135, 1248103941, 85606846, 932904582, 2111757135, 684245126, 71892866, 932904582, 492615376, 
    1190592709, 1401162145, 2104012173, 665549414, 1190592709, 972043236, 656774461, 665549414, 2007199226, 
    667839840, 1878445499, 142470751, 483872066, 667839840, 526934549, 20731924, 483872066, 583913268, 
    562420240, 633335206, 670353591, 1703206865, 562420240, 827140918, 589062547, 1703206865, 1018448863, 
    1408922715, 297418199, 2051604018, 1514148312, 1408922715, 462233038, 1585063407, 1514148312, 1477130056, 
    741306356, 684854080, 1857139347, 613694191, 741306356, 1828700450, 480296454, 613694191, 715202453, 
    1047704485, 1456393032, 1648359057, 262485378, 1047704485, 1984362669, 215148577, 262485378, 908872241, 
    1863657812, 1890266319, 666587201, 421346344, 1863657812, 1721671217, 779115651, 421346344, 1312682278, 
    523503690, 2020624237, 1690539270, 1061876039, 523503690, 647012853, 154840044, 1061876039, 607087348, 
    702121434, 460891510, 195545005, 384400534, 702121434, 1978478775, 1313815529, 384400534, 796024380, 
    2141457694, 989525486, 316892471, 69045171, 2141457694, 1312352040, 1658242117, 69045171, 1848811964, 
    312098455, 52959419, 1841143700, 80861072, 312098455, 522563535, 1502295285, 80861072, 1429043452, 
    483325749, 1255376843, 823834294, 1737690958, 483325749, 1998569027, 581496225, 1737690958, 880648894, 
    951315709, 320387170, 790882849, 988313318, 951315709, 1501250598, 461110923, 988313318, 367406846, 
    786673668, 1116857731, 566863927, 1535933019, 786673668, 732176198, 471796266, 1535933019, 609591423, 
    1820693727, 995258782, 742860132, 105641566, 1820693727, 600787875, 204423191, 105641566, 1723825471, 
    1631817342, 1581973938, 1881330950, 980119244, 1631817342, 724421627, 1071033915, 980119244, 1382261543, 
    131983533, 1244304830, 2005033071, 315191773, 131983533, 1390489861, 1492376236, 315191773, 1555132095, 
    649479311, 854605130, 321726041, 518555962, 649479311, 1684064517, 412586605, 518555962, 191494342, 
    1346575254, 2047163226, 2135287938, 116435580, 1346575254, 1526842117, 194954746, 116435580, 1371360307, 
    2025597527, 567446578, 1643108977, 46031599, 2025597527, 1712401664, 779043794, 46031599, 69530294, 
    489637171, 1625130585, 381262278, 452428843, 489637171, 1443891863, 876845283, 452428843, 1683301222, 
    651368970, 819199709, 2031524031, 1763700054, 651368970, 1528786662, 810914742, 1763700054, 960163648, 
    198884098, 215325655, 632733037, 537614029, 198884098, 1501926955, 744117887, 537614029, 1812237782, 
    1319538504, 262631980, 395918435, 569072577, 1319538504, 525761662, 986258115, 569072577, 499722939, 
    1873712945, 1328139957, 636168787, 1236821385, 1873712945, 1824846466, 1046270020, 1236821385, 1586456777, 
    2132644776, 1561739817, 2116746853, 1448064655, 2132644776, 959126094, 7435086, 1448064655, 731732719, 
    1170264917, 1887271366, 2055201704, 581935238, 1170264917, 1324098038, 1275448490, 581935238, 454742127, 
    2046293185, 133016457, 1987176594, 714585192, 2046293185, 1842896814, 1912062268, 714585192, 717158625, 
    2141188152, 371769702, 238274411, 168318689, 2141188152, 1575206202, 1610338266, 168318689, 149942865, 
    1171704025, 72174675, 1399149001, 843204119, 1171704025, 2121542447, 482566547, 843204119, 1627940648, 
    358961052, 449506273, 225035397, 1400105905, 358961052, 778121707, 2086926958, 1400105905, 2040995230, 
    1386279708, 1147668810, 1782545300, 130348301, 1386279708, 19146448, 283150143, 130348301, 47743705, 
    796733104, 729200619, 621776084, 420998971, 796733104, 1554656243, 78640239, 420998971, 331011766, 
    670353591, 1685250609, 1474479719, 827140918, 670353591, 383400860, 1018448863, 827140918, 806776465, 
    1646003433, 516429741, 823438334, 1571216288, 1646003433, 916014143, 672987287, 1571216288, 1011349101,
    // clang-format on
};

static const unsigned int h_mrg31k3p_A1[MRG31K3P_N] = {
    // clang-format off
    0, 4194304, 129, 1, 0, 0, 0, 1, 0, 
    4194304, 129, 0, 0, 4194304, 129, 1, 0, 0, 
    8192, 1082130432, 16641, 129, 8192, 541065216, 4194304, 129, 0, 
    1153433697, 2154945, 408969216, 3170304, 1153433697, 2148753, 16657, 3170304, 8388673, 
    2114723322, 1721212208, 372069324, 2050484945, 2114723322, 840597819, 2104058429, 2050484945, 1854761289, 
    2031391056, 1474597190, 220631129, 667596721, 2031391056, 1804643306, 629934405, 667596721, 667011916, 
    1626637155, 47085990, 25108805, 1565027687, 1626637155, 685757807, 621260874, 1565027687, 1315045259, 
    186789822, 229794953, 948835832, 1072773560, 186789822, 529689580, 686639683, 1072773560, 2051914008, 
    133777926, 1849297334, 1160315623, 391879376, 133777926, 976116713, 1472516881, 391879376, 1133340572, 
    315040025, 1357549030, 448994521, 1634902263, 315040025, 318362774, 468588410, 1634902263, 876161549, 
    1108588757, 1006700199, 1139321936, 624776875, 1108588757, 288253948, 85470327, 624776875, 609299647, 
    1800574616, 1663202423, 368689287, 2000517263, 1800574616, 1059509691, 1106925817, 2000517263, 754030956, 
    1086502913, 1682234256, 1789246123, 1245759969, 1086502913, 1809824555, 1329155292, 1245759969, 161160027, 
    1720262475, 565559801, 1398990386, 1325970531, 1720262475, 147733919, 866797547, 1325970531, 1806649895, 
    1476358256, 539279285, 975405418, 1139568166, 1476358256, 377670014, 1068345918, 1139568166, 1214224795, 
    400054507, 1914771670, 200204594, 1965916860, 400054507, 1122402837, 258408198, 1965916860, 1448125803, 
    2949404, 1576782032, 520268929, 1086098496, 2949404, 1306225290, 1408487222, 1086098496, 847447860, 
    381424493, 1433687186, 455906132, 1518425721, 381424493, 923210727, 1755108478, 1518425721, 1996997890, 
    928372573, 545485986, 280054605, 1250707970, 928372573, 534654589, 2085039616, 1250707970, 924300230, 
    1362662654, 1947668898, 168367491, 201071095, 1362662654, 1985024917, 2146224277, 201071095, 733519514, 
    1620396146, 958413413, 1981393580, 581363082, 1620396146, 1452205810, 2042210936, 581363082, 1113090973, 
    580884245, 1414992990, 1420238151, 909956241, 580884245, 805041652, 938481596, 909956241, 864263945, 
    1232863855, 1411246633, 1387550558, 1275940370, 1232863855, 1333257090, 1458638251, 1275940370, 1586530792, 
    265378350, 1344095500, 1646881501, 545475645, 265378350, 1087177574, 274782294, 545475645, 2051615169, 
    1364138796, 806636338, 1935176304, 414533208, 1364138796, 436727951, 619330410, 414533208, 1992074766, 
    1803497226, 1844275260, 2103387029, 382542847, 1803497226, 1847722410, 463796751, 382542847, 1739676813, 
    1913524296, 1430627077, 1356264156, 1658582521, 1913524296, 1456747786, 1393006903, 1658582521, 606375036, 
    120859840, 472996648, 1037593448, 1522934925, 120859840, 2026108949, 1880188197, 1522934925, 1035740173, 
    2111757135, 1248103941, 85606846, 932904582, 2111757135, 684245126, 71892866, 932904582, 492615376, 
    1190592709, 1401162145, 2104012173, 665549414, 1190592709, 972043236, 656774461, 665549414, 2007199226, 
    667839840, 1878445499, 142470751, 483872066, 667839840, 526934549, 20731924, 483872066, 583913268, 
    562420240, 633335206, 670353591, 1703206865, 562420240, 827140918, 589062547, 1703206865, 1018448863, 
    1408922715, 297418199, 2051604018, 1514148312, 1408922715, 462233038, 1585063407, 1514148312, 1477130056, 
    741306356, 684854080, 1857139347, 613694191, 741306356, 1828700450, 480296454, 613694191, 715202453, 
    1047704485, 1456393032, 1648359057, 262485378, 1047704485, 1984362669, 215148577, 262485378, 908872241, 
    1863657812, 1890266319, 666587201, 421346344, 1863657812, 1721671217, 779115651, 421346344, 1312682278, 
    523503690, 2020624237, 1690539270, 1061876039, 523503690, 647012853, 154840044, 1061876039, 607087348, 
    702121434, 460891510, 195545005, 384400534, 702121434, 1978478775, 1313815529, 384400534, 796024380, 
    2141457694, 989525486, 316892471, 69045171, 2141457694, 1312352040, 1658242117, 69045171, 1848811964, 
    312098455, 52959419, 1841143700, 80861072, 312098455, 522563535, 1502295285, 80861072, 1429043452, 
    483325749, 1255376843, 823834294, 1737690958, 483325749, 1998569027, 581496225, 1737690958, 880648894, 
    951315709, 320387170, 790882849, 988313318, 951315709, 1501250598, 461110923, 988313318, 367406846, 
    786673668, 1116857731, 566863927, 1535933019, 786673668, 732176198, 471796266, 1535933019, 609591423, 
    1820693727, 995258782, 742860132, 105641566, 1820693727, 600787875, 204423191, 105641566, 1723825471, 
    1631817342, 1581973938, 1881330950, 980119244, 1631817342, 724421627, 1071033915, 980119244, 1382261543, 
    131983533, 1244304830, 2005033071, 315191773, 131983533, 1390489861, 1492376236, 315191773, 1555132095, 
    649479311, 854605130, 321726041, 518555962, 649479311, 1684064517, 412586605, 518555962, 191494342, 
    1346575254, 2047163226, 2135287938, 116435580, 1346575254, 1526842117, 194954746, 116435580, 1371360307, 
    2025597527, 567446578, 1643108977, 46031599, 2025597527, 1712401664, 779043794, 46031599, 69530294, 
    489637171, 1625130585, 381262278, 452428843, 489637171, 1443891863, 876845283, 452428843, 1683301222, 
    651368970, 819199709, 2031524031, 1763700054, 651368970, 1528786662, 810914742, 1763700054, 960163648, 
    198884098, 215325655, 632733037, 537614029, 198884098, 1501926955, 744117887, 537614029, 1812237782, 
    1319538504, 262631980, 395918435, 569072577, 1319538504, 525761662, 986258115, 569072577, 499722939, 
    1873712945, 1328139957, 636168787, 1236821385, 1873712945, 1824846466, 1046270020, 1236821385, 1586456777, 
    2132644776, 1561739817, 2116746853, 1448064655, 2132644776, 959126094, 7435086, 1448064655, 731732719, 
    1170264917, 1887271366, 2055201704, 581935238, 1170264917, 1324098038, 1275448490, 581935238, 454742127, 
    2046293185, 133016457, 1987176594, 714585192, 2046293185, 1842896814, 1912062268, 714585192, 717158625, 
    2141188152, 371769702, 238274411, 168318689, 2141188152, 1575206202, 1610338266, 168318689, 149942865, 
    1171704025, 72174675, 1399149001, 843204119, 1171704025, 2121542447, 482566547, 843204119, 1627940648, 
    358961052, 449506273, 225035397, 1400105905, 358961052, 778121707, 2086926958, 1400105905, 2040995230, 
    1386279708, 1147668810, 1782545300, 130348301, 1386279708, 19146448, 283150143, 130348301, 47743705, 
    796733104, 729200619, 621776084, 420998971, 796733104, 1554656243, 78640239, 420998971, 331011766, 
    670353591, 1685250609, 1474479719, 827140918, 670353591, 383400860, 1018448863, 827140918, 806776465, 
    1646003433, 516429741, 823438334, 1571216288, 1646003433, 916014143, 672987287, 1571216288, 1011349101,
    // clang-format on
};

static const __device__ unsigned int d_mrg31k3p_A2[MRG31K3P_N] = {
    // clang-format off
    32768, 0, 32769, 1, 0, 0, 0, 1, 0, 
    1073741824, 32769, 1073774592, 32768, 0, 32769, 1, 0, 0, 
    647927940, 1418936320, 2066843192, 345227265, 1073774592, 1418936320, 1073741824, 32769, 1073774592, 
    1314440335, 617121792, 1628410894, 879507346, 565536787, 617121792, 1873224312, 2135609866, 565536787, 
    813564905, 1320864099, 1072638028, 53376886, 1941766342, 1320864099, 985989666, 1865965032, 1941766342, 
    969605357, 1637560648, 855544258, 1362726736, 1476787835, 1637560648, 5030508, 1877659175, 1476787835, 
    633780322, 1737004819, 586803631, 999008403, 1045985094, 1737004819, 868697656, 130701240, 1045985094, 
    115137691, 1307913292, 141093694, 2133573813, 2107617810, 1307913292, 1363330341, 41528283, 2107617810, 
    900827702, 379583115, 1676012592, 1008216312, 233031422, 379583115, 1067943171, 1696576368, 233031422, 
    1617670309, 153551074, 1398493661, 91002977, 310179625, 153551074, 390911161, 328363064, 310179625, 
    1357310439, 1323429466, 62109082, 1522538381, 670277159, 1323429466, 1745128153, 1944237068, 670277159, 
    1784622088, 295466624, 1221707205, 1225642127, 1788557010, 295466624, 1655905884, 438618808, 1788557010, 
    317985026, 330742340, 448778905, 1412650741, 1281856862, 330742340, 1144550175, 78995997, 1281856862, 
    481763475, 1204434680, 2141494556, 1422794534, 1910526032, 1204434680, 1554881186, 1773241040, 1910526032, 
    282271498, 1991744193, 1428470436, 1741920224, 595721286, 1991744193, 1005276946, 755452977, 595721286, 
    1993242805, 2087979925, 1317159425, 763765939, 1439849319, 2087979925, 1774051695, 449837709, 1439849319, 
    2006177490, 722230104, 1340090108, 100044798, 766132180, 722230104, 325198558, 1850475831, 766132180, 
    1367472795, 783478871, 1399986914, 844767696, 812253577, 783478871, 1524985129, 1586273954, 812253577, 
    219328683, 627687580, 108788941, 2050410997, 13488160, 627687580, 616819112, 2039542529, 13488160, 
    580750845, 2058508653, 1158102041, 1323088288, 745737092, 2058508653, 1508575166, 773154801, 745737092, 
    45080292, 1661978879, 1702151287, 2058520224, 401449229, 1661978879, 1555681549, 1952222894, 401449229, 
    2015651827, 140756174, 1500648674, 343440586, 858443739, 140756174, 592491377, 795175789, 858443739, 
    164383728, 2048795949, 664762374, 1068738274, 568359628, 2048795949, 1181628951, 201571276, 568359628, 
    908277196, 869088079, 94576347, 1912724980, 578963250, 869088079, 1535538612, 431712934, 578963250, 
    1398999701, 740552586, 2076371924, 1986051751, 1308679528, 740552586, 1584619174, 682655760, 1308679528, 
    1990327868, 1399459270, 582702598, 1997343440, 1257506131, 1399459270, 790833727, 1388717897, 1257506131, 
    1492699803, 1433982978, 1237001632, 630009911, 885708082, 1433982978, 1506983307, 703010240, 885708082, 
    285576484, 1260302795, 424966911, 367851702, 228461275, 1260302795, 380787265, 1635798751, 228461275, 
    1443969674, 898920571, 891253751, 1902853755, 308107099, 898920571, 831514667, 1835447851, 308107099, 
    994949952, 198447863, 587308601, 839827894, 1247469245, 198447863, 1451045649, 2092425680, 1247469245, 
    251618763, 124162616, 235520856, 2058409934, 2074507841, 124162616, 2068367606, 1855152345, 2074507841, 
    201761503, 1759261085, 593948768, 827049092, 434861827, 1759261085, 2082965909, 1150753916, 434861827, 
    1240385784, 372397750, 134631825, 1536826866, 495118246, 372397750, 1847920968, 864887505, 495118246, 
    322688568, 1536133357, 1895436234, 1827243, 576542156, 1536133357, 1130366221, 1743522686, 576542156, 
    1931434023, 910585211, 345731164, 604031503, 42271783, 910585211, 265568951, 2106477822, 42271783, 
    39627827, 479453126, 1969966590, 485858893, 702982709, 479453126, 912566629, 918972396, 702982709, 
    900429713, 1941084875, 1197421431, 760092417, 463100699, 1941084875, 1215571943, 34579485, 463100699, 
    1577284327, 1276676196, 699135781, 1252625923, 2130774469, 1276676196, 287075064, 263024791, 2130774469, 
    513765688, 82922892, 152229673, 69273404, 430809419, 82922892, 682204778, 668555290, 430809419, 
    190371932, 1635428571, 1297683401, 2052085612, 944774143, 1635428571, 1786947956, 56142418, 944774143, 
    566013561, 1889079356, 2145085793, 828472628, 1396862975, 1889079356, 523734705, 1610590556, 1396862975, 
    1792877373, 906764528, 542141157, 710332602, 1961068818, 906764528, 2119704107, 1923272181, 1961068818, 
    1969877446, 422474587, 969169389, 1414763689, 268009167, 422474587, 2034889164, 879715687, 268009167, 
    87718469, 121890570, 170625350, 1362967968, 1280061087, 121890570, 717593980, 1958671378, 1280061087, 
    1210786378, 876481504, 2049980045, 1546059986, 706866319, 876481504, 489036658, 1158615140, 706866319, 
    1189552724, 20989072, 269567383, 770156239, 1690141580, 20989072, 154790430, 903957597, 1690141580, 
    1690944505, 969736270, 1627452966, 1983744384, 2047235923, 969736270, 1691445540, 557991075, 2047235923, 
    1936363419, 1100132076, 1810066552, 1170284395, 1296581262, 1100132076, 1868127450, 1938279769, 1296581262, 
    1694349818, 635737758, 1382916034, 1192880368, 1504314152, 635737758, 781308084, 1338450694, 1504314152, 
    1878518942, 886920697, 1350207018, 8888207, 537200131, 886920697, 2000891525, 1122859035, 537200131, 
    729740288, 836854758, 1843209703, 1530260137, 416790722, 836854758, 507253722, 1200659101, 416790722, 
    2032396621, 1384287554, 2026197481, 700023620, 706222760, 1384287554, 682375558, 2145574203, 706222760, 
    302197641, 1990420817, 190519420, 908756877, 1020435098, 1990420817, 1966585721, 884921781, 1020435098, 
    68760530, 1870518584, 997715174, 1503562259, 574607615, 1870518584, 1183720578, 816764253, 574607615, 
    1708344133, 1606991363, 591550640, 882686839, 1999480332, 1606991363, 610230128, 2033388183, 1999480332, 
    841972544, 396108542, 491107052, 905292782, 1256158274, 396108542, 1473267489, 1982451729, 1256158274, 
    1372254995, 836608500, 1989549396, 1928707414, 1311413013, 836608500, 1112388734, 57025069, 1311413013, 
    112784681, 809236105, 1268891956, 1211160695, 55053420, 809236105, 1820803489, 75265500, 55053420, 
    712258206, 1554233137, 1242834134, 1241108644, 710532716, 1554233137, 602888782, 289764289, 710532716, 
    2033053696, 497096546, 352611996, 1831733625, 1364712746, 497096546, 641259069, 1975896148, 1364712746, 
    1108246666, 1838060851, 2084491956, 1878184093, 901938803, 1838060851, 44749841, 84873083, 901938803, 
    2041302020, 1214133801, 565311654, 988522410, 317050197, 1214133801, 1148771268, 923159877, 317050197, 
    1733455881, 598501892, 1843117501, 217561458, 107899838, 598501892, 984329288, 603388854, 107899838, 
    507758885, 224620200, 1151968532, 383536360, 1886789292, 224620200, 1916857550, 2075773710, 1886789292,
    // clang-format on
};

static const unsigned int h_mrg31k3p_A2[MRG31K3P_N] = {
    // clang-format off
    32768, 0, 32769, 1, 0, 0, 0, 1, 0, 
    1073741824, 32769, 1073774592, 32768, 0, 32769, 1, 0, 0, 
    647927940, 1418936320, 2066843192, 345227265, 1073774592, 1418936320, 1073741824, 32769, 1073774592, 
    1314440335, 617121792, 1628410894, 879507346, 565536787, 617121792, 1873224312, 2135609866, 565536787, 
    813564905, 1320864099, 1072638028, 53376886, 1941766342, 1320864099, 985989666, 1865965032, 1941766342, 
    969605357, 1637560648, 855544258, 1362726736, 1476787835, 1637560648, 5030508, 1877659175, 1476787835, 
    633780322, 1737004819, 586803631, 999008403, 1045985094, 1737004819, 868697656, 130701240, 1045985094, 
    115137691, 1307913292, 141093694, 2133573813, 2107617810, 1307913292, 1363330341, 41528283, 2107617810, 
    900827702, 379583115, 1676012592, 1008216312, 233031422, 379583115, 1067943171, 1696576368, 233031422, 
    1617670309, 153551074, 1398493661, 91002977, 310179625, 153551074, 390911161, 328363064, 310179625, 
    1357310439, 1323429466, 62109082, 1522538381, 670277159, 1323429466, 1745128153, 1944237068, 670277159, 
    1784622088, 295466624, 1221707205, 1225642127, 1788557010, 295466624, 1655905884, 438618808, 1788557010, 
    317985026, 330742340, 448778905, 1412650741, 1281856862, 330742340, 1144550175, 78995997, 1281856862, 
    481763475, 1204434680, 2141494556, 1422794534, 1910526032, 1204434680, 1554881186, 1773241040, 1910526032, 
    282271498, 1991744193, 1428470436, 1741920224, 595721286, 1991744193, 1005276946, 755452977, 595721286, 
    1993242805, 2087979925, 1317159425, 763765939, 1439849319, 2087979925, 1774051695, 449837709, 1439849319, 
    2006177490, 722230104, 1340090108, 100044798, 766132180, 722230104, 325198558, 1850475831, 766132180, 
    1367472795, 783478871, 1399986914, 844767696, 812253577, 783478871, 1524985129, 1586273954, 812253577, 
    219328683, 627687580, 108788941, 2050410997, 13488160, 627687580, 616819112, 2039542529, 13488160, 
    580750845, 2058508653, 1158102041, 1323088288, 745737092, 2058508653, 1508575166, 773154801, 745737092, 
    45080292, 1661978879, 1702151287, 2058520224, 401449229, 1661978879, 1555681549, 1952222894, 401449229, 
    2015651827, 140756174, 1500648674, 343440586, 858443739, 140756174, 592491377, 795175789, 858443739, 
    164383728, 2048795949, 664762374, 1068738274, 568359628, 2048795949, 1181628951, 201571276, 568359628, 
    908277196, 869088079, 94576347, 1912724980, 578963250, 869088079, 1535538612, 431712934, 578963250, 
    1398999701, 740552586, 2076371924, 1986051751, 1308679528, 740552586, 1584619174, 682655760, 1308679528, 
    1990327868, 1399459270, 582702598, 1997343440, 1257506131, 1399459270, 790833727, 1388717897, 1257506131, 
    1492699803, 1433982978, 1237001632, 630009911, 885708082, 1433982978, 1506983307, 703010240, 885708082, 
    285576484, 1260302795, 424966911, 367851702, 228461275, 1260302795, 380787265, 1635798751, 228461275, 
    1443969674, 898920571, 891253751, 1902853755, 308107099, 898920571, 831514667, 1835447851, 308107099, 
    994949952, 198447863, 587308601, 839827894, 1247469245, 198447863, 1451045649, 2092425680, 1247469245, 
    251618763, 124162616, 235520856, 2058409934, 2074507841, 124162616, 2068367606, 1855152345, 2074507841, 
    201761503, 1759261085, 593948768, 827049092, 434861827, 1759261085, 2082965909, 1150753916, 434861827, 
    1240385784, 372397750, 134631825, 1536826866, 495118246, 372397750, 1847920968, 864887505, 495118246, 
    322688568, 1536133357, 1895436234, 1827243, 576542156, 1536133357, 1130366221, 1743522686, 576542156, 
    1931434023, 910585211, 345731164, 604031503, 42271783, 910585211, 265568951, 2106477822, 42271783, 
    39627827, 479453126, 1969966590, 485858893, 702982709, 479453126, 912566629, 918972396, 702982709, 
    900429713, 1941084875, 1197421431, 760092417, 463100699, 1941084875, 1215571943, 34579485, 463100699, 
    1577284327, 1276676196, 699135781, 1252625923, 2130774469, 1276676196, 287075064, 263024791, 2130774469, 
    513765688, 82922892, 152229673, 69273404, 430809419, 82922892, 682204778, 668555290, 430809419, 
    190371932, 1635428571, 1297683401, 2052085612, 944774143, 1635428571, 1786947956, 56142418, 944774143, 
    566013561, 1889079356, 2145085793, 828472628, 1396862975, 1889079356, 523734705, 1610590556, 1396862975, 
    1792877373, 906764528, 542141157, 710332602, 1961068818, 906764528, 2119704107, 1923272181, 1961068818, 
    1969877446, 422474587, 969169389, 1414763689, 268009167, 422474587, 2034889164, 879715687, 268009167, 
    87718469, 121890570, 170625350, 1362967968, 1280061087, 121890570, 717593980, 1958671378, 1280061087, 
    1210786378, 876481504, 2049980045, 1546059986, 706866319, 876481504, 489036658, 1158615140, 706866319, 
    1189552724, 20989072, 269567383, 770156239, 1690141580, 20989072, 154790430, 903957597, 1690141580, 
    1690944505, 969736270, 1627452966, 1983744384, 2047235923, 969736270, 1691445540, 557991075, 2047235923, 
    1936363419, 1100132076, 1810066552, 1170284395, 1296581262, 1100132076, 1868127450, 1938279769, 1296581262, 
    1694349818, 635737758, 1382916034, 1192880368, 1504314152, 635737758, 781308084, 1338450694, 1504314152, 
    1878518942, 886920697, 1350207018, 8888207, 537200131, 886920697, 2000891525, 1122859035, 537200131, 
    729740288, 836854758, 1843209703, 1530260137, 416790722, 836854758, 507253722, 1200659101, 416790722, 
    2032396621, 1384287554, 2026197481, 700023620, 706222760, 1384287554, 682375558, 2145574203, 706222760, 
    302197641, 1990420817, 190519420, 908756877, 1020435098, 1990420817, 1966585721, 884921781, 1020435098, 
    68760530, 1870518584, 997715174, 1503562259, 574607615, 1870518584, 1183720578, 816764253, 574607615, 
    1708344133, 1606991363, 591550640, 882686839, 1999480332, 1606991363, 610230128, 2033388183, 1999480332, 
    841972544, 396108542, 491107052, 905292782, 1256158274, 396108542, 1473267489, 1982451729, 1256158274, 
    1372254995, 836608500, 1989549396, 1928707414, 1311413013, 836608500, 1112388734, 57025069, 1311413013, 
    112784681, 809236105, 1268891956, 1211160695, 55053420, 809236105, 1820803489, 75265500, 55053420, 
    712258206, 1554233137, 1242834134, 1241108644, 710532716, 1554233137, 602888782, 289764289, 710532716, 
    2033053696, 497096546, 352611996, 1831733625, 1364712746, 497096546, 641259069, 1975896148, 1364712746, 
    1108246666, 1838060851, 2084491956, 1878184093, 901938803, 1838060851, 44749841, 84873083, 901938803, 
    2041302020, 1214133801, 565311654, 988522410, 317050197, 1214133801, 1148771268, 923159877, 317050197, 
    1733455881, 598501892, 1843117501, 217561458, 107899838, 598501892, 984329288, 603388854, 107899838, 
    507758885, 224620200, 1151968532, 383536360, 1886789292, 224620200, 1916857550, 2075773710, 1886789292,
    // clang-format on
};

static const __device__ unsigned int d_mrg31k3p_A1P72[MRG31K3P_N] = {
    // clang-format off
    1516919229, 758510237, 499121365, 1884998244, 1516919229, 335398200, 601897748, 1884998244, 358115744, 
    1698053532, 465195060, 1970364842, 1530165711, 1698053532, 667727351, 920769984, 1530165711, 1964690609, 
    446522508, 1159864719, 227261603, 967297001, 446522508, 1254444459, 1957442102, 967297001, 216206963, 
    192962807, 1827843892, 640770341, 21614372, 192962807, 603064909, 687208484, 21614372, 40625659, 
    287996737, 615994322, 672698674, 188333479, 287996737, 988919539, 640258125, 188333479, 2111268472, 
    1785922250, 121913950, 2056399925, 1031417848, 1785922250, 153453894, 900136208, 1031417848, 643313484, 
    875905623, 237341159, 1461720509, 1626105692, 875905623, 922031027, 822858370, 1626105692, 329038958, 
    1070040588, 1514860938, 605256199, 1686055074, 1070040588, 832090614, 56391795, 1686055074, 587585488, 
    1452177032, 2006630243, 561389490, 154176297, 1452177032, 760620830, 771665648, 154176297, 444036913, 
    1426991517, 1767408547, 1269035208, 858842645, 1426991517, 1677650736, 1711015370, 858842645, 1650142106, 
    383872123, 1528246888, 1309365923, 2024456490, 383872123, 274390280, 2016433423, 2024456490, 1390761040, 
    1246317022, 1244715268, 620321426, 1469758778, 1246317022, 2072316837, 1364484436, 1469758778, 1965072301, 
    1376418744, 509646979, 796579342, 1337947838, 1376418744, 1857599687, 1679116003, 1337947838, 421032213, 
    857793380, 2054292320, 1064272952, 1872732104, 857793380, 138032017, 1033193939, 1872732104, 1044519103, 
    750036143, 1161334237, 1558612811, 977617553, 750036143, 551250748, 736748304, 977617553, 1755230141, 
    727953836, 37180940, 2114560913, 1531283510, 727953836, 1955181383, 681042847, 1531283510, 1133471162, 
    801465127, 1174582241, 1616880209, 2126723282, 801465127, 289624645, 834603155, 2126723282, 183272355, 
    1181399498, 1905769507, 36298092, 749403583, 1181399498, 29451941, 116758430, 749403583, 1592213246, 
    1221328335, 383784873, 333511784, 718413245, 1221328335, 663400090, 1736447282, 718413245, 2081963460, 
    2121598261, 1792927429, 1772029414, 896036145, 2121598261, 511914639, 453441652, 896036145, 1634173369, 
    1984745436, 915707657, 1654510134, 1561011545, 1984745436, 1613107574, 1277688874, 1561011545, 1806089182, 
    0, 2146689, 0, 0, 0, 2146689, 16641, 0, 1069547487, 
    0, 0, 1921239906, 1363313297, 0, 1536646846, 2142748478, 1363313297, 809509920, 
    66750221, 65330683, 1019085500, 1972264774, 66750221, 841619147, 2020830546, 1972264774, 792612182, 
    623416331, 2128674825, 829534783, 1787676628, 623416331, 162248998, 1482854989, 1787676628, 297558722, 
    820111461, 896364577, 1202338804, 1590800661, 820111461, 1878918984, 1412926708, 1590800661, 1941425310, 
    735019899, 2048655112, 2008269626, 1979932868, 735019899, 1222704472, 242538570, 1979932868, 424167695, 
    1454076251, 1934759817, 75338489, 216997100, 1454076251, 944480251, 1438977317, 216997100, 222334677, 
    192789109, 1360448366, 1099902144, 557882655, 192789109, 155593504, 1782452277, 557882655, 2114493292, 
    713611054, 708652832, 379262556, 1900716266, 713611054, 1870957007, 1029980306, 1900716266, 99230990, 
    381010121, 1603087966, 1793084142, 912846520, 381010121, 829553127, 805494327, 912846520, 148750170, 
    1408185467, 1427181283, 1510874885, 1726369694, 1408185467, 1834851259, 1495820898, 1726369694, 994222150, 
    44843381, 789025048, 94923239, 1515627404, 44843381, 1272604102, 292866869, 1515627404, 895715087, 
    1058231077, 1341120276, 1258148326, 991935531, 1058231077, 1158827830, 1091048565, 991935531, 565366555, 
    1455037813, 2013427336, 1726377802, 1345155578, 1455037813, 2035965903, 1114495245, 1345155578, 324593289, 
    1273711912, 637164659, 1631962772, 1177952078, 1273711912, 1381450083, 510123717, 1177952078, 446437689, 
    2010581145, 1793773126, 1096019963, 75084919, 2010581145, 1294504300, 2140871404, 75084919, 1016544012, 
    1498901823, 235112706, 740326496, 1820279411, 1498901823, 1896696160, 1546241796, 1820279411, 405362780, 
    149606741, 184883570, 358729377, 652020090, 149606741, 745646829, 1853614974, 652020090, 691245919, 
    2005525734, 1357865130, 1767350024, 80289028, 2005525734, 267189276, 401603076, 80289028, 1987964137, 
    2072145098, 2131402664, 1575766865, 927809050, 2072145098, 2020538633, 881315413, 927809050, 1713907939, 
    856503340, 2054389709, 2034741677, 232186272, 856503340, 309105757, 1334168973, 232186272, 1336242501, 
    2106799039, 986807912, 1178472986, 774904812, 2106799039, 1069180506, 1856122987, 774904812, 1654383271, 
    531726619, 1663739363, 317885787, 951352354, 531726619, 1519274917, 644369407, 951352354, 534662389, 
    159746903, 1245652383, 1112433051, 308272393, 159746903, 133559729, 1615809872, 308272393, 894788528, 
    1038219652, 18216470, 1766133299, 379928477, 1038219652, 432710518, 586004947, 379928477, 1225818791, 
    1487530228, 275537595, 2114928731, 1131754520, 1487530228, 172663841, 1416347084, 1131754520, 1702867733, 
    32170162, 1534397985, 161702529, 1849088274, 32170162, 381547189, 1184906094, 1849088274, 642224276, 
    896241465, 168931119, 1327219052, 76877160, 896241465, 806315176, 239310746, 76877160, 1323593069, 
    1874582332, 1188510, 1813116237, 1662124010, 1874582332, 90216862, 1682062521, 1662124010, 1095350814, 
    1803808400, 926038245, 36645026, 316580111, 1803808400, 1936247188, 897309151, 316580111, 1940467875, 
    2075587016, 1770077961, 1897571433, 913656499, 2075587016, 1017513060, 1805780984, 913656499, 2105614532, 
    1891648234, 144874618, 396155802, 552427257, 1891648234, 1246897610, 26313033, 552427257, 511670826, 
    293603129, 1275371358, 179929319, 1865876727, 293603129, 235733980, 1783073521, 1865876727, 1426776947, 
    14816320, 746642637, 2038989453, 1613933485, 14816320, 1091617655, 1123821876, 1613933485, 868259371, 
    867365198, 1221888551, 779757833, 1121404358, 867365198, 1462967940, 1010170440, 1121404358, 563402321, 
    73279627, 823258938, 1063650596, 174716954, 73279627, 713865790, 1437189608, 174716954, 171135912, 
    1620809839, 879825918, 1184601952, 1890312047, 1620809839, 1484307982, 494273905, 1890312047, 72146285, 
    1266710339, 1210337590, 1323536716, 1991272021, 1266710339, 849932547, 805652307, 1991272021, 1990751391, 
    863887666, 1090773817, 69681024, 1848374929, 863887666, 478989630, 952601221, 1848374929, 304184685, 
    1353679080, 1245383923, 1510330256, 477828468, 1353679080, 1831653224, 1179500066, 477828468, 1208769033, 
    1302366464, 1554680558, 324931800, 2100061018, 1302366464, 99349693, 1332542957, 2100061018, 1379455617, 
    1702500920, 1849582496, 1656874625, 828554832, 1702500920, 1512419905, 1143731069, 828554832, 102237247, 
    645483870, 620564265, 664205456, 770918242, 645483870, 1281758597, 575939555, 770918242, 765993804,
    // clang-format on
};

static const unsigned int h_mrg31k3p_A1P72[MRG31K3P_N] = {
    // clang-format off
    1516919229, 758510237, 499121365, 1884998244, 1516919229, 335398200, 601897748, 1884998244, 358115744, 
    1698053532, 465195060, 1970364842, 1530165711, 1698053532, 667727351, 920769984, 1530165711, 1964690609, 
    446522508, 1159864719, 227261603, 967297001, 446522508, 1254444459, 1957442102, 967297001, 216206963, 
    192962807, 1827843892, 640770341, 21614372, 192962807, 603064909, 687208484, 21614372, 40625659, 
    287996737, 615994322, 672698674, 188333479, 287996737, 988919539, 640258125, 188333479, 2111268472, 
    1785922250, 121913950, 2056399925, 1031417848, 1785922250, 153453894, 900136208, 1031417848, 643313484, 
    875905623, 237341159, 1461720509, 1626105692, 875905623, 922031027, 822858370, 1626105692, 329038958, 
    1070040588, 1514860938, 605256199, 1686055074, 1070040588, 832090614, 56391795, 1686055074, 587585488, 
    1452177032, 2006630243, 561389490, 154176297, 1452177032, 760620830, 771665648, 154176297, 444036913, 
    1426991517, 1767408547, 1269035208, 858842645, 1426991517, 1677650736, 1711015370, 858842645, 1650142106, 
    383872123, 1528246888, 1309365923, 2024456490, 383872123, 274390280, 2016433423, 2024456490, 1390761040, 
    1246317022, 1244715268, 620321426, 1469758778, 1246317022, 2072316837, 1364484436, 1469758778, 1965072301, 
    1376418744, 509646979, 796579342, 1337947838, 1376418744, 1857599687, 1679116003, 1337947838, 421032213, 
    857793380, 2054292320, 1064272952, 1872732104, 857793380, 138032017, 1033193939, 1872732104, 1044519103, 
    750036143, 1161334237, 1558612811, 977617553, 750036143, 551250748, 736748304, 977617553, 1755230141, 
    727953836, 37180940, 2114560913, 1531283510, 727953836, 1955181383, 681042847, 1531283510, 1133471162, 
    801465127, 1174582241, 1616880209, 2126723282, 801465127, 289624645, 834603155, 2126723282, 183272355, 
    1181399498, 1905769507, 36298092, 749403583, 1181399498, 29451941, 116758430, 749403583, 1592213246, 
    1221328335, 383784873, 333511784, 718413245, 1221328335, 663400090, 1736447282, 718413245, 2081963460, 
    2121598261, 1792927429, 1772029414, 896036145, 2121598261, 511914639, 453441652, 896036145, 1634173369, 
    1984745436, 915707657, 1654510134, 1561011545, 1984745436, 1613107574, 1277688874, 1561011545, 1806089182, 
    0, 2146689, 0, 0, 0, 2146689, 16641, 0, 1069547487, 
    0, 0, 1921239906, 1363313297, 0, 1536646846, 2142748478, 1363313297, 809509920, 
    66750221, 65330683, 1019085500, 1972264774, 66750221, 841619147, 2020830546, 1972264774, 792612182, 
    623416331, 2128674825, 829534783, 1787676628, 623416331, 162248998, 1482854989, 1787676628, 297558722, 
    820111461, 896364577, 1202338804, 1590800661, 820111461, 1878918984, 1412926708, 1590800661, 1941425310, 
    735019899, 2048655112, 2008269626, 1979932868, 735019899, 1222704472, 242538570, 1979932868, 424167695, 
    1454076251, 1934759817, 75338489, 216997100, 1454076251, 944480251, 1438977317, 216997100, 222334677, 
    192789109, 1360448366, 1099902144, 557882655, 192789109, 155593504, 1782452277, 557882655, 2114493292, 
    713611054, 708652832, 379262556, 1900716266, 713611054, 1870957007, 1029980306, 1900716266, 99230990, 
    381010121, 1603087966, 1793084142, 912846520, 381010121, 829553127, 805494327, 912846520, 148750170, 
    1408185467, 1427181283, 1510874885, 1726369694, 1408185467, 1834851259, 1495820898, 1726369694, 994222150, 
    44843381, 789025048, 94923239, 1515627404, 44843381, 1272604102, 292866869, 1515627404, 895715087, 
    1058231077, 1341120276, 1258148326, 991935531, 1058231077, 1158827830, 1091048565, 991935531, 565366555, 
    1455037813, 2013427336, 1726377802, 1345155578, 1455037813, 2035965903, 1114495245, 1345155578, 324593289, 
    1273711912, 637164659, 1631962772, 1177952078, 1273711912, 1381450083, 510123717, 1177952078, 446437689, 
    2010581145, 1793773126, 1096019963, 75084919, 2010581145, 1294504300, 2140871404, 75084919, 1016544012, 
    1498901823, 235112706, 740326496, 1820279411, 1498901823, 1896696160, 1546241796, 1820279411, 405362780, 
    149606741, 184883570, 358729377, 652020090, 149606741, 745646829, 1853614974, 652020090, 691245919, 
    2005525734, 1357865130, 1767350024, 80289028, 2005525734, 267189276, 401603076, 80289028, 1987964137, 
    2072145098, 2131402664, 1575766865, 927809050, 2072145098, 2020538633, 881315413, 927809050, 1713907939, 
    856503340, 2054389709, 2034741677, 232186272, 856503340, 309105757, 1334168973, 232186272, 1336242501, 
    2106799039, 986807912, 1178472986, 774904812, 2106799039, 1069180506, 1856122987, 774904812, 1654383271, 
    531726619, 1663739363, 317885787, 951352354, 531726619, 1519274917, 644369407, 951352354, 534662389, 
    159746903, 1245652383, 1112433051, 308272393, 159746903, 133559729, 1615809872, 308272393, 894788528, 
    1038219652, 18216470, 1766133299, 379928477, 1038219652, 432710518, 586004947, 379928477, 1225818791, 
    1487530228, 275537595, 2114928731, 1131754520, 1487530228, 172663841, 1416347084, 1131754520, 1702867733, 
    32170162, 1534397985, 161702529, 1849088274, 32170162, 381547189, 1184906094, 1849088274, 642224276, 
    896241465, 168931119, 1327219052, 76877160, 896241465, 806315176, 239310746, 76877160, 1323593069, 
    1874582332, 1188510, 1813116237, 1662124010, 1874582332, 90216862, 1682062521, 1662124010, 1095350814, 
    1803808400, 926038245, 36645026, 316580111, 1803808400, 1936247188, 897309151, 316580111, 1940467875, 
    2075587016, 1770077961, 1897571433, 913656499, 2075587016, 1017513060, 1805780984, 913656499, 2105614532, 
    1891648234, 144874618, 396155802, 552427257, 1891648234, 1246897610, 26313033, 552427257, 511670826, 
    293603129, 1275371358, 179929319, 1865876727, 293603129, 235733980, 1783073521, 1865876727, 1426776947, 
    14816320, 746642637, 2038989453, 1613933485, 14816320, 1091617655, 1123821876, 1613933485, 868259371, 
    867365198, 1221888551, 779757833, 1121404358, 867365198, 1462967940, 1010170440, 1121404358, 563402321, 
    73279627, 823258938, 1063650596, 174716954, 73279627, 713865790, 1437189608, 174716954, 171135912, 
    1620809839, 879825918, 1184601952, 1890312047, 1620809839, 1484307982, 494273905, 1890312047, 72146285, 
    1266710339, 1210337590, 1323536716, 1991272021, 1266710339, 849932547, 805652307, 1991272021, 1990751391, 
    863887666, 1090773817, 69681024, 1848374929, 863887666, 478989630, 952601221, 1848374929, 304184685, 
    1353679080, 1245383923, 1510330256, 477828468, 1353679080, 1831653224, 1179500066, 477828468, 1208769033, 
    1302366464, 1554680558, 324931800, 2100061018, 1302366464, 99349693, 1332542957, 2100061018, 1379455617, 
    1702500920, 1849582496, 1656874625, 828554832, 1702500920, 1512419905, 1143731069, 828554832, 102237247, 
    645483870, 620564265, 664205456, 770918242, 645483870, 1281758597, 575939555, 770918242, 765993804,
    // clang-format on
};

static const __device__ unsigned int d_mrg31k3p_A2P72[MRG31K3P_N] = {
    // clang-format off
    1228857673, 1496414766, 954677935, 1133297478, 1407477216, 1496414766, 2002613992, 1639496704, 1407477216, 
    1282690299, 1795612190, 365601547, 1650534289, 420160462, 1795612190, 237875349, 92797448, 420160462, 
    505218833, 106598948, 240377218, 1527655423, 1792497038, 106598948, 1464608251, 738202147, 1792497038, 
    1302569189, 2004716257, 548890929, 1686255562, 292471243, 2004716257, 1396183817, 1077723122, 292471243, 
    1511679103, 1365813281, 1182951296, 1881826449, 63091677, 1365813281, 326135665, 842148833, 63091677, 
    1906484943, 921680632, 196823907, 464768575, 26967032, 921680632, 1317903938, 860991881, 26967032, 
    1265660338, 1815469593, 1351575494, 1228922758, 1143007602, 1815469593, 457543768, 2018459512, 1143007602, 
    1868867057, 1924149801, 428176873, 923902335, 217129940, 1924149801, 682064366, 1829279479, 217129940, 
    1966319684, 1320317703, 660439901, 1358854314, 517271518, 1320317703, 1814855550, 1853392161, 517271518, 
    1931191663, 2107925076, 330836203, 1283677495, 736570376, 2107925076, 918579860, 94332279, 736570376, 
    781285592, 1944331553, 638450083, 1260684674, 1403520183, 1944331553, 595102217, 2058917917, 1403520183, 
    1236253286, 1958401382, 1540728644, 26129294, 1869116515, 1958401382, 1870447309, 2085637800, 1869116515, 
    1401905347, 1092699728, 644454700, 44320216, 801770863, 1092699728, 435043770, 1534126837, 801770863, 
    442209260, 1545744602, 322901296, 1529427342, 1648735306, 1545744602, 1666167242, 1649849982, 1648735306, 
    1763879653, 988335134, 1669493586, 1622787936, 1717174003, 988335134, 1824020089, 311010312, 1717174003, 
    1952226836, 1613634339, 1601098186, 514223580, 865352230, 1613634339, 1759619881, 660209122, 865352230, 
    120332194, 1753280429, 715267904, 1780169940, 1185234230, 1753280429, 171226633, 198116144, 1185234230, 
    309292275, 929759701, 1253715449, 1602066707, 657643533, 929759701, 767817185, 1440124191, 657643533, 
    195827234, 625924881, 725236536, 1265929991, 736520689, 625924881, 1364226996, 2004232106, 736520689, 
    2127942035, 621908231, 1405247044, 882842737, 1605537728, 621908231, 1358459938, 1619394444, 1605537728, 
    1453441668, 1924170040, 448959804, 943497443, 1947979307, 1924170040, 1900657142, 919984545, 1947979307, 
    1357988379, 435226864, 161383746, 1827992388, 877134442, 435226864, 669895258, 2062660782, 877134442, 
    862446210, 637999621, 1961422328, 436446481, 1484932942, 637999621, 1582518977, 1380965837, 1484932942, 
    1918341115, 610284457, 921832714, 935713404, 1932221805, 610284457, 1477140493, 1802569440, 1932221805, 
    1166693335, 1111258125, 2045013533, 806057166, 2075199547, 1111258125, 910095642, 604894683, 2075199547, 
    1337340001, 933479796, 250448516, 869700825, 1956592310, 933479796, 180114152, 116335181, 1956592310, 
    1032796075, 964470743, 305424253, 1684740865, 264650108, 964470743, 1488423039, 61230582, 264650108, 
    1712024538, 699327583, 233487965, 477089965, 1955626538, 699327583, 740286143, 518048525, 1955626538, 
    1070062360, 1537084641, 1162060325, 1210633168, 1118635203, 1537084641, 425489461, 99037988, 1118635203, 
    2087553842, 1110969145, 1144785928, 933557607, 1876325521, 1110969145, 1104402037, 926990499, 1876325521, 
    1815728387, 871758224, 1545321856, 704727347, 975133878, 871758224, 1128052279, 961021402, 975133878, 
    1513608227, 1279502601, 565649640, 28327672, 976286259, 1279502601, 859771158, 1756058808, 976286259, 
    2094140247, 1737489625, 933512842, 1458276750, 471441576, 1737489625, 1263470614, 984257739, 471441576, 
    1860977403, 658703383, 2060162056, 547069801, 347885148, 658703383, 1624395424, 1512761842, 347885148, 
    1879082616, 308724097, 736059294, 487787239, 1630810561, 308724097, 1407141665, 1586204807, 1630810561, 
    1353046646, 468021422, 1721982830, 124631461, 1903157856, 468021422, 1670262955, 1326872994, 1903157856, 
    517335945, 1465221011, 1459241612, 1042549176, 100643509, 1465221011, 991629940, 568958105, 100643509, 
    1403944694, 1286617553, 360369598, 1870136409, 766248926, 1286617553, 827266830, 1410785686, 766248926, 
    196325686, 516891667, 1004127870, 1467650175, 659847991, 516891667, 1162970729, 2113729237, 659847991, 
    1032019899, 83968668, 877074995, 1317574910, 1472519814, 83968668, 150401617, 1384007859, 1472519814, 
    1741538312, 800873109, 1059523969, 2104898230, 639449994, 800873109, 1701008257, 857570799, 639449994, 
    1502112416, 1963152593, 253090559, 840407495, 2089429352, 1963152593, 591367390, 1616084871, 2089429352, 
    1319732484, 951587645, 1946666920, 57728760, 1578256903, 951587645, 719716367, 1973320061, 1578256903, 
    1355881756, 586536795, 852266854, 703919797, 1207534699, 586536795, 619897924, 737280926, 1207534699, 
    1940584308, 1721665993, 885174226, 1855604019, 763551522, 1721665993, 331389193, 465327219, 763551522, 
    1109702463, 2632136, 298184035, 1020232403, 1831750831, 2632136, 446609909, 1464210176, 1831750831, 
    784484809, 684307252, 662903252, 1159895117, 1281476674, 684307252, 212021293, 687609158, 1281476674, 
    1731308168, 1890967465, 904934541, 877846934, 1704220561, 1890967465, 354789768, 1489131816, 1704220561, 
    1587550693, 754049360, 310811546, 753708625, 2030447772, 754049360, 1492152019, 1491811284, 2030447772, 
    2014208213, 1642652920, 2067720926, 92203000, 38690287, 1642652920, 1721349286, 170899366, 38690287, 
    245548435, 1718293988, 1665512322, 1505614172, 85650285, 1718293988, 2020052636, 1807372820, 85650285, 
    2081370320, 1099098606, 2099739989, 673550388, 655180719, 1099098606, 411320890, 2133235251, 655180719, 
    1094209948, 15990642, 1941196129, 145805425, 1446281823, 15990642, 1860820163, 1990634946, 1446281823, 
    1683608456, 1683166214, 1349081652, 1550822532, 1885349336, 1683166214, 1799466284, 1667122602, 1885349336, 
    1397008732, 1449356459, 1208832805, 1557961388, 1746137315, 1449356459, 1893433983, 2002038912, 1746137315, 
    1438247187, 939961626, 1729100372, 1747761867, 1456908682, 939961626, 464594653, 1272394894, 1456908682, 
    1176204019, 1862103892, 685956562, 40192881, 530440338, 1862103892, 674067403, 999618971, 530440338, 
    1472574795, 888439292, 1144519156, 1694793075, 2022848714, 888439292, 711653837, 1518007620, 2022848714, 
    1677906195, 1532623415, 1966044219, 515348784, 227210760, 1532623415, 2069786788, 1052512157, 227210760, 
    1799019626, 995353695, 560784494, 1348234869, 439007422, 995353695, 631706404, 984587578, 439007422, 
    991695888, 1668598579, 599027790, 59784702, 452452800, 1668598579, 690969104, 1229617806, 452452800, 
    1644842953, 1858581354, 735437056, 255274869, 1164680766, 1858581354, 1186341548, 1730497642, 1164680766, 
    796789021, 1464208080, 607337906, 1241679051, 1431130166, 1464208080, 1401213391, 1178684362, 1431130166, 
    449379819, 1859560334, 1507943303, 281118586, 1370017681, 1859560334, 586645827, 1155666658, 1370017681,
    // clang-format on
};

static const unsigned int h_mrg31k3p_A2P72[MRG31K3P_N] = {
    // clang-format off
    1228857673, 1496414766, 954677935, 1133297478, 1407477216, 1496414766, 2002613992, 1639496704, 1407477216, 
    1282690299, 1795612190, 365601547, 1650534289, 420160462, 1795612190, 237875349, 92797448, 420160462, 
    505218833, 106598948, 240377218, 1527655423, 1792497038, 106598948, 1464608251, 738202147, 1792497038, 
    1302569189, 2004716257, 548890929, 1686255562, 292471243, 2004716257, 1396183817, 1077723122, 292471243, 
    1511679103, 1365813281, 1182951296, 1881826449, 63091677, 1365813281, 326135665, 842148833, 63091677, 
    1906484943, 921680632, 196823907, 464768575, 26967032, 921680632, 1317903938, 860991881, 26967032, 
    1265660338, 1815469593, 1351575494, 1228922758, 1143007602, 1815469593, 457543768, 2018459512, 1143007602, 
    1868867057, 1924149801, 428176873, 923902335, 217129940, 1924149801, 682064366, 1829279479, 217129940, 
    1966319684, 1320317703, 660439901, 1358854314, 517271518, 1320317703, 1814855550, 1853392161, 517271518, 
    1931191663, 2107925076, 330836203, 1283677495, 736570376, 2107925076, 918579860, 94332279, 736570376, 
    781285592, 1944331553, 638450083, 1260684674, 1403520183, 1944331553, 595102217, 2058917917, 1403520183, 
    1236253286, 1958401382, 1540728644, 26129294, 1869116515, 1958401382, 1870447309, 2085637800, 1869116515, 
    1401905347, 1092699728, 644454700, 44320216, 801770863, 1092699728, 435043770, 1534126837, 801770863, 
    442209260, 1545744602, 322901296, 1529427342, 1648735306, 1545744602, 1666167242, 1649849982, 1648735306, 
    1763879653, 988335134, 1669493586, 1622787936, 1717174003, 988335134, 1824020089, 311010312, 1717174003, 
    1952226836, 1613634339, 1601098186, 514223580, 865352230, 1613634339, 1759619881, 660209122, 865352230, 
    120332194, 1753280429, 715267904, 1780169940, 1185234230, 1753280429, 171226633, 198116144, 1185234230, 
    309292275, 929759701, 1253715449, 1602066707, 657643533, 929759701, 767817185, 1440124191, 657643533, 
    195827234, 625924881, 725236536, 1265929991, 736520689, 625924881, 1364226996, 2004232106, 736520689, 
    2127942035, 621908231, 1405247044, 882842737, 1605537728, 621908231, 1358459938, 1619394444, 1605537728, 
    1453441668, 1924170040, 448959804, 943497443, 1947979307, 1924170040, 1900657142, 919984545, 1947979307, 
    1357988379, 435226864, 161383746, 1827992388, 877134442, 435226864, 669895258, 2062660782, 877134442, 
    862446210, 637999621, 1961422328, 436446481, 1484932942, 637999621, 1582518977, 1380965837, 1484932942, 
    1918341115, 610284457, 921832714, 935713404, 1932221805, 610284457, 1477140493, 1802569440, 1932221805, 
    1166693335, 1111258125, 2045013533, 806057166, 2075199547, 1111258125, 910095642, 604894683, 2075199547, 
    1337340001, 933479796, 250448516, 869700825, 1956592310, 933479796, 180114152, 116335181, 1956592310, 
    1032796075, 964470743, 305424253, 1684740865, 264650108, 964470743, 1488423039, 61230582, 264650108, 
    1712024538, 699327583, 233487965, 477089965, 1955626538, 699327583, 740286143, 518048525, 1955626538, 
    1070062360, 1537084641, 1162060325, 1210633168, 1118635203, 1537084641, 425489461, 99037988, 1118635203, 
    2087553842, 1110969145, 1144785928, 933557607, 1876325521, 1110969145, 1104402037, 926990499, 1876325521, 
    1815728387, 871758224, 1545321856, 704727347, 975133878, 871758224, 1128052279, 961021402, 975133878, 
    1513608227, 1279502601, 565649640, 28327672, 976286259, 1279502601, 859771158, 1756058808, 976286259, 
    2094140247, 1737489625, 933512842, 1458276750, 471441576, 1737489625, 1263470614, 984257739, 471441576, 
    1860977403, 658703383, 2060162056, 547069801, 347885148, 658703383, 1624395424, 1512761842, 347885148, 
    1879082616, 308724097, 736059294, 487787239, 1630810561, 308724097, 1407141665, 1586204807, 1630810561, 
    1353046646, 468021422, 1721982830, 124631461, 1903157856, 468021422, 1670262955, 1326872994, 1903157856, 
    517335945, 1465221011, 1459241612, 1042549176, 100643509, 1465221011, 991629940, 568958105, 100643509, 
    1403944694, 1286617553, 360369598, 1870136409, 766248926, 1286617553, 827266830, 1410785686, 766248926, 
    196325686, 516891667, 1004127870, 1467650175, 659847991, 516891667, 1162970729, 2113729237, 659847991, 
    1032019899, 83968668, 877074995, 1317574910, 1472519814, 83968668, 150401617, 1384007859, 1472519814, 
    1741538312, 800873109, 1059523969, 2104898230, 639449994, 800873109, 1701008257, 857570799, 639449994, 
    1502112416, 1963152593, 253090559, 840407495, 2089429352, 1963152593, 591367390, 1616084871, 2089429352, 
    1319732484, 951587645, 1946666920, 57728760, 1578256903, 951587645, 719716367, 1973320061, 1578256903, 
    1355881756, 586536795, 852266854, 703919797, 1207534699, 586536795, 619897924, 737280926, 1207534699, 
    1940584308, 1721665993, 885174226, 1855604019, 763551522, 1721665993, 331389193, 465327219, 763551522, 
    1109702463, 2632136, 298184035, 1020232403, 1831750831, 2632136, 446609909, 1464210176, 1831750831, 
    784484809, 684307252, 662903252, 1159895117, 1281476674, 684307252, 212021293, 687609158, 1281476674, 
    1731308168, 1890967465, 904934541, 877846934, 1704220561, 1890967465, 354789768, 1489131816, 1704220561, 
    1587550693, 754049360, 310811546, 753708625, 2030447772, 754049360, 1492152019, 1491811284, 2030447772, 
    2014208213, 1642652920, 2067720926, 92203000, 38690287, 1642652920, 1721349286, 170899366, 38690287, 
    245548435, 1718293988, 1665512322, 1505614172, 85650285, 1718293988, 2020052636, 1807372820, 85650285, 
    2081370320, 1099098606, 2099739989, 673550388, 655180719, 1099098606, 411320890, 2133235251, 655180719, 
    1094209948, 15990642, 1941196129, 145805425, 1446281823, 15990642, 1860820163, 1990634946, 1446281823, 
    1683608456, 1683166214, 1349081652, 1550822532, 1885349336, 1683166214, 1799466284, 1667122602, 1885349336, 
    1397008732, 1449356459, 1208832805, 1557961388, 1746137315, 1449356459, 1893433983, 2002038912, 1746137315, 
    1438247187, 939961626, 1729100372, 1747761867, 1456908682, 939961626, 464594653, 1272394894, 1456908682, 
    1176204019, 1862103892, 685956562, 40192881, 530440338, 1862103892, 674067403, 999618971, 530440338, 
    1472574795, 888439292, 1144519156, 1694793075, 2022848714, 888439292, 711653837, 1518007620, 2022848714, 
    1677906195, 1532623415, 1966044219, 515348784, 227210760, 1532623415, 2069786788, 1052512157, 227210760, 
    1799019626, 995353695, 560784494, 1348234869, 439007422, 995353695, 631706404, 984587578, 439007422, 
    991695888, 1668598579, 599027790, 59784702, 452452800, 1668598579, 690969104, 1229617806, 452452800, 
    1644842953, 1858581354, 735437056, 255274869, 1164680766, 1858581354, 1186341548, 1730497642, 1164680766, 
    796789021, 1464208080, 607337906, 1241679051, 1431130166, 1464208080, 1401213391, 1178684362, 1431130166, 
    449379819, 1859560334, 1507943303, 281118586, 1370017681, 1859560334, 586645827, 1155666658, 1370017681,
    // clang-format on
};

static const __device__ unsigned int d_mrg31k3p_A1P134[MRG31K3P_N] = {
    // clang-format off
    1702500920, 1849582496, 1656874625, 828554832, 1702500920, 1512419905, 1143731069, 828554832, 102237247, 
    645483870, 620564265, 664205456, 770918242, 645483870, 1281758597, 575939555, 770918242, 765993804, 
    617402461, 1368756598, 28735665, 1198818281, 617402461, 1462884148, 1792586313, 1198818281, 307717124, 
    162610726, 1023662615, 268281397, 384964382, 162610726, 1970823435, 614575463, 384964382, 803138895, 
    845166865, 242449311, 1181536570, 2090054205, 845166865, 2129998277, 1381578739, 2090054205, 896994421, 
    366572538, 692324442, 1362760821, 509978839, 366572538, 1937036677, 1796261914, 509978839, 254012310, 
    455661184, 1672661504, 1755909826, 296613425, 455661184, 1466561285, 277723253, 296613425, 2111868835, 
    1524212047, 1290402814, 1698959568, 562526511, 1524212047, 18430018, 1731447514, 562526511, 606472042, 
    1652961203, 215070855, 2060152039, 1597450376, 1652961203, 1789009138, 47162608, 1597450376, 646236129, 
    2078015280, 187202008, 1807168324, 696542619, 2078015280, 609466277, 71313185, 696542619, 865722141, 
    183377628, 1681399087, 1185786577, 1540730869, 183377628, 1724527191, 63309908, 1540730869, 1978416087, 
    1366196111, 1633591539, 1290946307, 1325132980, 1366196111, 876028669, 339734121, 1325132980, 925130648, 
    1724783401, 1801293992, 308731192, 2133229752, 1724783401, 1025375592, 7948648, 2133229752, 214818437, 
    1157813323, 1416970207, 1826698806, 363750817, 1157813323, 1814718636, 2061668273, 363750817, 1485136643, 
    1282397429, 1815517899, 916628618, 1172406852, 1282397429, 1528015370, 1426853685, 1172406852, 2131054317, 
    2129819678, 1577854465, 1610308761, 1960200740, 2129819678, 1423031004, 1209626772, 1960200740, 1506700134, 
    1630622394, 982109384, 1295036091, 1708049365, 1630622394, 1159128422, 425164493, 1708049365, 769959675, 
    145802313, 308057876, 1172263339, 1940157879, 145802313, 610452697, 787148714, 1940157879, 504975057, 
    797914368, 583402810, 853552393, 2087511692, 797914368, 2139606726, 1964303825, 2087511692, 991210125, 
    259143302, 52193900, 1164542374, 541736582, 259143302, 1636582732, 1594166893, 541736582, 1946334206, 
    1078006211, 1572070265, 1777835147, 380019189, 1078006211, 1617465384, 212304412, 380019189, 960151042, 
    1853880518, 806781606, 1967554328, 281606920, 1853880518, 1846418984, 180784926, 281606920, 653956479, 
    1041535125, 1050674614, 304377591, 551715798, 1041535125, 1225757812, 1990514045, 551715798, 1587101226, 
    2007648138, 1607919899, 886196014, 1987881783, 2007648138, 299608774, 1034446472, 1987881783, 1435202391, 
    1233503151, 469054309, 892939014, 356512369, 1233503151, 2141885291, 33250922, 356512369, 788841984, 
    874678388, 214950247, 23713635, 1648252672, 874678388, 1285472827, 1042088829, 1648252672, 1422096882, 
    1078189672, 1190126686, 910551326, 1721716023, 1078189672, 2029819063, 1397449316, 1721716023, 656029879, 
    1410346282, 481562416, 911772508, 639660086, 1410346282, 253820664, 601265364, 639660086, 519979488, 
    731766923, 460662147, 1453906457, 1026747356, 731766923, 609651725, 1120085706, 1026747356, 2029813495, 
    1543150734, 451002172, 1416425958, 260687447, 1543150734, 85588569, 1448966402, 260687447, 458190290, 
    2061622376, 801587966, 916597495, 639697489, 2061622376, 460599933, 1501814947, 639697489, 1375017592, 
    76166254, 1426470107, 667934894, 1270361954, 76166254, 2086688963, 2030482250, 1270361954, 835563796, 
    238008363, 1734569564, 1782076789, 396699230, 238008363, 1339530185, 1874865881, 396699230, 1471666195, 
    1673237948, 1596265562, 947846739, 1805240935, 1673237948, 1160726389, 1240887723, 1805240935, 2027330179, 
    1781455951, 600161726, 1848333959, 1479278255, 1781455951, 2010752958, 864592395, 1479278255, 1733629950, 
    1304430887, 1104552021, 2030139403, 398622196, 1304430887, 1154105110, 242006792, 398622196, 196661962, 
    76775611, 667871474, 765471737, 2020240256, 76775611, 1200796604, 375546022, 2020240256, 1527271306, 
    1170643171, 75245340, 265830856, 1134067588, 1170643171, 593124060, 1253134865, 1134067588, 1096892474, 
    2077914257, 1645516487, 1056674057, 1922614678, 2077914257, 2086357604, 1930596721, 1922614678, 526445385, 
    375401972, 1550819682, 1227358939, 2040467937, 375401972, 1676857817, 379236419, 2040467937, 93642908, 
    1053319317, 2017208884, 1970115630, 264979615, 1053319317, 1349797010, 1325589187, 264979615, 232840996, 
    1691497299, 2017815949, 1292005205, 1474965629, 1691497299, 1490647157, 527617366, 1474965629, 256014829, 
    1217151312, 840798379, 224995176, 1949461875, 1217151312, 1428387700, 1892201859, 1949461875, 1737743605, 
    952774017, 608757611, 314921493, 651680494, 952774017, 1756724093, 1478568101, 651680494, 257826029, 
    1094160296, 1720758185, 1400853540, 1309337814, 1094160296, 820619829, 306010275, 1309337814, 409891068, 
    13069239, 474547195, 1409404604, 1825466063, 13069239, 1750244551, 2094462794, 1825466063, 772341819, 
    76488958, 1120908370, 1530532496, 627809515, 76488958, 134020740, 1699049246, 627809515, 1021083206, 
    2053156627, 1477901940, 413814692, 669094268, 2053156627, 2030243243, 1330863964, 669094268, 590939492, 
    31223127, 2133530841, 662211389, 121663542, 31223127, 1906800801, 763903604, 121663542, 1690675511, 
    2021060853, 435346596, 1749961419, 812629275, 2021060853, 1394255045, 426987180, 812629275, 1298806606, 
    348793657, 1401722248, 1335230639, 2124539952, 348793657, 1196246164, 292274947, 2124539952, 1409381719, 
    737228385, 2371063, 1848392607, 363918986, 737228385, 1570329979, 744648143, 363918986, 941294890, 
    0, 1679057135, 162637753, 683794320, 0, 0, 0, 683794320, 0, 
    401845057, 311931463, 0, 0, 401845057, 311931463, 1733722719, 0, 0, 
    1114720233, 1425190872, 1251749276, 1924126889, 1114720233, 712595436, 1653592841, 1924126889, 0, 
    610798891, 608296164, 740754146, 1171043484, 610798891, 2099181193, 499040364, 1171043484, 156839371, 
    1971192737, 812099860, 1173994584, 558457015, 1971192737, 43451492, 2064584680, 558457015, 2067823641, 
    435678011, 743904728, 1941437443, 1346822707, 435678011, 527364711, 453561420, 1346822707, 116025045, 
    1539249556, 1452496481, 1643958331, 1843931469, 1539249556, 52191821, 1914827994, 1843931469, 621151386, 
    227354251, 1012981194, 1906761699, 1413142543, 227354251, 947306590, 639935544, 1413142543, 2138707000, 
    576852484, 708579549, 1542097685, 128484366, 576852484, 649608347, 121565844, 128484366, 2103341706, 
    1853292988, 1291223334, 1496855187, 1060374612, 1853292988, 936830754, 956150377, 1060374612, 1411023587, 
    855345339, 1546249211, 1601856434, 1627192017, 855345339, 666461566, 88402169, 1627192017, 1958274630, 
    1096937602, 786590498, 578966606, 1469438198, 1096937602, 1899405365, 1979088959, 1469438198, 828831042,
    // clang-format on
};

static const unsigned int h_mrg31k3p_A1P134[MRG31K3P_N] = {
    // clang-format off
    1702500920, 1849582496, 1656874625, 828554832, 1702500920, 1512419905, 1143731069, 828554832, 102237247, 
    645483870, 620564265, 664205456, 770918242, 645483870, 1281758597, 575939555, 770918242, 765993804, 
    617402461, 1368756598, 28735665, 1198818281, 617402461, 1462884148, 1792586313, 1198818281, 307717124, 
    162610726, 1023662615, 268281397, 384964382, 162610726, 1970823435, 614575463, 384964382, 803138895, 
    845166865, 242449311, 1181536570, 2090054205, 845166865, 2129998277, 1381578739, 2090054205, 896994421, 
    366572538, 692324442, 1362760821, 509978839, 366572538, 1937036677, 1796261914, 509978839, 254012310, 
    455661184, 1672661504, 1755909826, 296613425, 455661184, 1466561285, 277723253, 296613425, 2111868835, 
    1524212047, 1290402814, 1698959568, 562526511, 1524212047, 18430018, 1731447514, 562526511, 606472042, 
    1652961203, 215070855, 2060152039, 1597450376, 1652961203, 1789009138, 47162608, 1597450376, 646236129, 
    2078015280, 187202008, 1807168324, 696542619, 2078015280, 609466277, 71313185, 696542619, 865722141, 
    183377628, 1681399087, 1185786577, 1540730869, 183377628, 1724527191, 63309908, 1540730869, 1978416087, 
    1366196111, 1633591539, 1290946307, 1325132980, 1366196111, 876028669, 339734121, 1325132980, 925130648, 
    1724783401, 1801293992, 308731192, 2133229752, 1724783401, 1025375592, 7948648, 2133229752, 214818437, 
    1157813323, 1416970207, 1826698806, 363750817, 1157813323, 1814718636, 2061668273, 363750817, 1485136643, 
    1282397429, 1815517899, 916628618, 1172406852, 1282397429, 1528015370, 1426853685, 1172406852, 2131054317, 
    2129819678, 1577854465, 1610308761, 1960200740, 2129819678, 1423031004, 1209626772, 1960200740, 1506700134, 
    1630622394, 982109384, 1295036091, 1708049365, 1630622394, 1159128422, 425164493, 1708049365, 769959675, 
    145802313, 308057876, 1172263339, 1940157879, 145802313, 610452697, 787148714, 1940157879, 504975057, 
    797914368, 583402810, 853552393, 2087511692, 797914368, 2139606726, 1964303825, 2087511692, 991210125, 
    259143302, 52193900, 1164542374, 541736582, 259143302, 1636582732, 1594166893, 541736582, 1946334206, 
    1078006211, 1572070265, 1777835147, 380019189, 1078006211, 1617465384, 212304412, 380019189, 960151042, 
    1853880518, 806781606, 1967554328, 281606920, 1853880518, 1846418984, 180784926, 281606920, 653956479, 
    1041535125, 1050674614, 304377591, 551715798, 1041535125, 1225757812, 1990514045, 551715798, 1587101226, 
    2007648138, 1607919899, 886196014, 1987881783, 2007648138, 299608774, 1034446472, 1987881783, 1435202391, 
    1233503151, 469054309, 892939014, 356512369, 1233503151, 2141885291, 33250922, 356512369, 788841984, 
    874678388, 214950247, 23713635, 1648252672, 874678388, 1285472827, 1042088829, 1648252672, 1422096882, 
    1078189672, 1190126686, 910551326, 1721716023, 1078189672, 2029819063, 1397449316, 1721716023, 656029879, 
    1410346282, 481562416, 911772508, 639660086, 1410346282, 253820664, 601265364, 639660086, 519979488, 
    731766923, 460662147, 1453906457, 1026747356, 731766923, 609651725, 1120085706, 1026747356, 2029813495, 
    1543150734, 451002172, 1416425958, 260687447, 1543150734, 85588569, 1448966402, 260687447, 458190290, 
    2061622376, 801587966, 916597495, 639697489, 2061622376, 460599933, 1501814947, 639697489, 1375017592, 
    76166254, 1426470107, 667934894, 1270361954, 76166254, 2086688963, 2030482250, 1270361954, 835563796, 
    238008363, 1734569564, 1782076789, 396699230, 238008363, 1339530185, 1874865881, 396699230, 1471666195, 
    1673237948, 1596265562, 947846739, 1805240935, 1673237948, 1160726389, 1240887723, 1805240935, 2027330179, 
    1781455951, 600161726, 1848333959, 1479278255, 1781455951, 2010752958, 864592395, 1479278255, 1733629950, 
    1304430887, 1104552021, 2030139403, 398622196, 1304430887, 1154105110, 242006792, 398622196, 196661962, 
    76775611, 667871474, 765471737, 2020240256, 76775611, 1200796604, 375546022, 2020240256, 1527271306, 
    1170643171, 75245340, 265830856, 1134067588, 1170643171, 593124060, 1253134865, 1134067588, 1096892474, 
    2077914257, 1645516487, 1056674057, 1922614678, 2077914257, 2086357604, 1930596721, 1922614678, 526445385, 
    375401972, 1550819682, 1227358939, 2040467937, 375401972, 1676857817, 379236419, 2040467937, 93642908, 
    1053319317, 2017208884, 1970115630, 264979615, 1053319317, 1349797010, 1325589187, 264979615, 232840996, 
    1691497299, 2017815949, 1292005205, 1474965629, 1691497299, 1490647157, 527617366, 1474965629, 256014829, 
    1217151312, 840798379, 224995176, 1949461875, 1217151312, 1428387700, 1892201859, 1949461875, 1737743605, 
    952774017, 608757611, 314921493, 651680494, 952774017, 1756724093, 1478568101, 651680494, 257826029, 
    1094160296, 1720758185, 1400853540, 1309337814, 1094160296, 820619829, 306010275, 1309337814, 409891068, 
    13069239, 474547195, 1409404604, 1825466063, 13069239, 1750244551, 2094462794, 1825466063, 772341819, 
    76488958, 1120908370, 1530532496, 627809515, 76488958, 134020740, 1699049246, 627809515, 1021083206, 
    2053156627, 1477901940, 413814692, 669094268, 2053156627, 2030243243, 1330863964, 669094268, 590939492, 
    31223127, 2133530841, 662211389, 121663542, 31223127, 1906800801, 763903604, 121663542, 1690675511, 
    2021060853, 435346596, 1749961419, 812629275, 2021060853, 1394255045, 426987180, 812629275, 1298806606, 
    348793657, 1401722248, 1335230639, 2124539952, 348793657, 1196246164, 292274947, 2124539952, 1409381719, 
    737228385, 2371063, 1848392607, 363918986, 737228385, 1570329979, 744648143, 363918986, 941294890, 
    0, 1679057135, 162637753, 683794320, 0, 0, 0, 683794320, 0, 
    401845057, 311931463, 0, 0, 401845057, 311931463, 1733722719, 0, 0, 
    1114720233, 1425190872, 1251749276, 1924126889, 1114720233, 712595436, 1653592841, 1924126889, 0, 
    610798891, 608296164, 740754146, 1171043484, 610798891, 2099181193, 499040364, 1171043484, 156839371, 
    1971192737, 812099860, 1173994584, 558457015, 1971192737, 43451492, 2064584680, 558457015, 2067823641, 
    435678011, 743904728, 1941437443, 1346822707, 435678011, 527364711, 453561420, 1346822707, 116025045, 
    1539249556, 1452496481, 1643958331, 1843931469, 1539249556, 52191821, 1914827994, 1843931469, 621151386, 
    227354251, 1012981194, 1906761699, 1413142543, 227354251, 947306590, 639935544, 1413142543, 2138707000, 
    576852484, 708579549, 1542097685, 128484366, 576852484, 649608347, 121565844, 128484366, 2103341706, 
    1853292988, 1291223334, 1496855187, 1060374612, 1853292988, 936830754, 956150377, 1060374612, 1411023587, 
    855345339, 1546249211, 1601856434, 1627192017, 855345339, 666461566, 88402169, 1627192017, 1958274630, 
    1096937602, 786590498, 578966606, 1469438198, 1096937602, 1899405365, 1979088959, 1469438198, 828831042,
    // clang-format on
};

static const __device__ unsigned int d_mrg31k3p_A2P134[MRG31K3P_N] = {
    // clang-format off
    796789021, 1464208080, 607337906, 1241679051, 1431130166, 1464208080, 1401213391, 1178684362, 1431130166, 
    449379819, 1859560334, 1507943303, 281118586, 1370017681, 1859560334, 586645827, 1155666658, 1370017681, 
    1905411591, 1963018101, 343016434, 121181645, 1683576802, 1963018101, 659653144, 965279267, 1683576802, 
    923789351, 579378463, 1299982062, 923273606, 547080895, 579378463, 1469275547, 1813170690, 547080895, 
    2090750644, 1130285516, 237847599, 1939860162, 1645300628, 1130285516, 421282912, 1230857558, 1645300628, 
    2008026844, 513985244, 434089712, 312541827, 1886478959, 513985244, 819379249, 617935832, 1886478959, 
    776220511, 1984739738, 346366517, 1418021351, 1847875345, 1984739738, 1948301741, 1381583354, 1847875345, 
    1700525394, 111040671, 2093663073, 640783524, 247645845, 111040671, 2052114933, 434395207, 247645845, 
    376956109, 290880205, 199150100, 948142688, 1125948697, 290880205, 1722880835, 232680739, 1125948697, 
    247078818, 588036491, 688300042, 951237683, 510016459, 588036491, 1721382636, 2084583828, 510016459, 
    757891938, 856677280, 1234670468, 257321638, 1928005687, 856677280, 1749832311, 1150476669, 1928005687, 
    1217360713, 521402766, 19797074, 121827115, 1319390754, 521402766, 947038455, 547462804, 1319390754, 
    1048768886, 1469640699, 1164579305, 982183962, 866373543, 1469640699, 1779472094, 1292015357, 866373543, 
    102819547, 516349604, 1341579158, 1763871247, 525111636, 516349604, 1720397448, 820456512, 525111636, 
    599356592, 848762501, 1180929028, 368530105, 1934420248, 848762501, 934400507, 454168111, 1934420248, 
    1348206367, 1361201495, 592298891, 1599883922, 208328819, 1361201495, 413622556, 652304983, 208328819, 
    2064097552, 1417070886, 1357680052, 606028385, 1312445885, 1417070886, 1708497864, 897455363, 1312445885, 
    469061732, 2003625712, 59424357, 511555199, 921192574, 2003625712, 1785648525, 293578012, 921192574, 
    2087203840, 1126514522, 879262502, 758640974, 1966582312, 1126514522, 156855701, 1936444732, 1966582312, 
    673754100, 2050883370, 237566383, 1289965851, 1726153568, 2050883370, 2042540727, 1281623208, 1726153568, 
    276940357, 642398106, 1330827576, 1330433295, 276546076, 642398106, 215493282, 903528471, 276546076, 
    1443969571, 488130244, 175038278, 1154375427, 275844141, 488130244, 1942292534, 461075138, 275844141, 
    1317965065, 1002864713, 205640281, 546423407, 1658748191, 1002864713, 499722452, 43281146, 1658748191, 
    146753883, 1351632120, 727674162, 815519302, 234599023, 1351632120, 1884846131, 1348733313, 234599023, 
    642749055, 1354357254, 1055708756, 1096208681, 683248980, 1354357254, 781723214, 523574641, 683248980, 
    1737066390, 942511753, 1932891932, 41279467, 1992916504, 942511753, 527572287, 1773802580, 1992916504, 
    1652401837, 430696203, 1202166331, 277308320, 727543826, 430696203, 1093306140, 939918257, 727543826, 
    458862064, 1393557250, 1426081092, 1008405285, 41186257, 1393557250, 1607117043, 1221965078, 41186257, 
    1345916124, 1748092973, 1614043471, 596796005, 328668658, 1748092973, 1655163813, 503866845, 328668658, 
    2146828500, 2127048966, 10643923, 1570900428, 1559622426, 2127048966, 963798460, 407649922, 1559622426, 
    1188264804, 35897774, 1970542303, 1365513163, 583235664, 35897774, 1479940899, 662093709, 583235664, 
    1308109289, 895977286, 37247186, 2050081147, 1173480671, 895977286, 1277600139, 284241421, 1173480671, 
    2013888788, 2043482286, 658176641, 1871783831, 1080033399, 2043482286, 401912906, 230214451, 1080033399, 
    452030369, 255369901, 1350332603, 1860008949, 961706715, 255369901, 1195401760, 652578229, 961706715, 
    2131053590, 740482187, 984920239, 1450610916, 449281688, 740482187, 1574920235, 137586385, 449281688, 
    1634858243, 497927143, 1901866904, 51698324, 1932152242, 497927143, 1002347892, 556119073, 1932152242, 
    1472216392, 577373840, 769534590, 1340835970, 2043517772, 577373840, 655613324, 1419075454, 2043517772, 
    1855299310, 506099840, 569067263, 422641986, 1708874033, 506099840, 1336633796, 1253175942, 1708874033, 
    572710688, 261672892, 1394962173, 246579059, 1571790153, 261672892, 670676362, 655582529, 1571790153, 
    594443199, 704082826, 607911385, 232268769, 218800583, 704082826, 436735778, 2112384300, 218800583, 
    267693324, 641808781, 154341361, 2113521010, 79410394, 641808781, 2011893649, 1336143299, 79410394, 
    1318819653, 1868464067, 1588101830, 1212415570, 943133393, 1868464067, 77451914, 1568865996, 943133393, 
    985435018, 180447434, 1577900962, 183148352, 1738144987, 180447434, 1655902374, 1658603292, 1738144987, 
    49821488, 611723857, 242459635, 602652151, 410014004, 611723857, 82459631, 73387925, 410014004, 
    1437111298, 74797434, 533133248, 2039676476, 796191947, 74797434, 1886773167, 1704189630, 796191947, 
    1637483663, 74168688, 1054079355, 700321621, 1283725929, 74168688, 2060960811, 539651165, 1283725929, 
    1887163718, 655848906, 87023570, 169996184, 1970136332, 655848906, 420940767, 2082550624, 1970136332, 
    18989030, 1801200908, 1296446318, 1480765767, 203308479, 1801200908, 1713948855, 1393513714, 203308479, 
    1287186326, 1297009802, 187411713, 1576345091, 528657125, 1297009802, 184581514, 463916803, 528657125, 
    1696668232, 1107403276, 87597923, 976253094, 437860824, 1107403276, 1930908628, 1799758446, 437860824, 
    1682379101, 297028150, 917205235, 1818447583, 436158870, 297028150, 2051989542, 1425946396, 436158870, 
    814496749, 542253708, 865467163, 1286053011, 1235082597, 542253708, 973776701, 1717576004, 1235082597, 
    1530574627, 725445924, 457192432, 1733109114, 659028730, 725445924, 1576361510, 436562121, 659028730, 
    1879960851, 566221965, 924162160, 963040885, 1918839576, 566221965, 1609385463, 2006204383, 1918839576, 
    1614225341, 1340553167, 1004137727, 1241691160, 1851778774, 1340553167, 458053542, 359191535, 1851778774, 
    755675013, 882429580, 1549541854, 1579204593, 785337752, 882429580, 768798741, 1465573754, 785337752, 
    2061271255, 466021298, 1573816382, 1311501570, 1798956443, 466021298, 1731012316, 429030009, 1798956443, 
    269410335, 525102330, 66372845, 85064323, 288101813, 525102330, 514518411, 74480404, 288101813, 
    283661186, 1203833319, 84000195, 1978192481, 30390893, 1203833319, 554252338, 1328611500, 30390893, 
    247697233, 341540512, 744092679, 503908690, 7513244, 341540512, 176426220, 338794398, 7513244, 
    1402001034, 1394863287, 1687749293, 1678557380, 1392809121, 1394863287, 2110151132, 246382646, 1392809121, 
    1502257169, 26035216, 1533979144, 1212348385, 1180626410, 26035216, 1908070020, 946920610, 1180626410, 
    542049032, 2094774459, 705590104, 1947410772, 1783869700, 2094774459, 1123436733, 976073046, 1783869700, 
    1431452905, 2101958470, 118477317, 811765310, 2124740898, 2101958470, 1786241326, 496048166, 2124740898,
    // clang-format on
};

static const unsigned int h_mrg31k3p_A2P134[MRG31K3P_N] = {
    // clang-format off
    796789021, 1464208080, 607337906, 1241679051, 1431130166, 1464208080, 1401213391, 1178684362, 1431130166, 
    449379819, 1859560334, 1507943303, 281118586, 1370017681, 1859560334, 586645827, 1155666658, 1370017681, 
    1905411591, 1963018101, 343016434, 121181645, 1683576802, 1963018101, 659653144, 965279267, 1683576802, 
    923789351, 579378463, 1299982062, 923273606, 547080895, 579378463, 1469275547, 1813170690, 547080895, 
    2090750644, 1130285516, 237847599, 1939860162, 1645300628, 1130285516, 421282912, 1230857558, 1645300628, 
    2008026844, 513985244, 434089712, 312541827, 1886478959, 513985244, 819379249, 617935832, 1886478959, 
    776220511, 1984739738, 346366517, 1418021351, 1847875345, 1984739738, 1948301741, 1381583354, 1847875345, 
    1700525394, 111040671, 2093663073, 640783524, 247645845, 111040671, 2052114933, 434395207, 247645845, 
    376956109, 290880205, 199150100, 948142688, 1125948697, 290880205, 1722880835, 232680739, 1125948697, 
    247078818, 588036491, 688300042, 951237683, 510016459, 588036491, 1721382636, 2084583828, 510016459, 
    757891938, 856677280, 1234670468, 257321638, 1928005687, 856677280, 1749832311, 1150476669, 1928005687, 
    1217360713, 521402766, 19797074, 121827115, 1319390754, 521402766, 947038455, 547462804, 1319390754, 
    1048768886, 1469640699, 1164579305, 982183962, 866373543, 1469640699, 1779472094, 1292015357, 866373543, 
    102819547, 516349604, 1341579158, 1763871247, 525111636, 516349604, 1720397448, 820456512, 525111636, 
    599356592, 848762501, 1180929028, 368530105, 1934420248, 848762501, 934400507, 454168111, 1934420248, 
    1348206367, 1361201495, 592298891, 1599883922, 208328819, 1361201495, 413622556, 652304983, 208328819, 
    2064097552, 1417070886, 1357680052, 606028385, 1312445885, 1417070886, 1708497864, 897455363, 1312445885, 
    469061732, 2003625712, 59424357, 511555199, 921192574, 2003625712, 1785648525, 293578012, 921192574, 
    2087203840, 1126514522, 879262502, 758640974, 1966582312, 1126514522, 156855701, 1936444732, 1966582312, 
    673754100, 2050883370, 237566383, 1289965851, 1726153568, 2050883370, 2042540727, 1281623208, 1726153568, 
    276940357, 642398106, 1330827576, 1330433295, 276546076, 642398106, 215493282, 903528471, 276546076, 
    1443969571, 488130244, 175038278, 1154375427, 275844141, 488130244, 1942292534, 461075138, 275844141, 
    1317965065, 1002864713, 205640281, 546423407, 1658748191, 1002864713, 499722452, 43281146, 1658748191, 
    146753883, 1351632120, 727674162, 815519302, 234599023, 1351632120, 1884846131, 1348733313, 234599023, 
    642749055, 1354357254, 1055708756, 1096208681, 683248980, 1354357254, 781723214, 523574641, 683248980, 
    1737066390, 942511753, 1932891932, 41279467, 1992916504, 942511753, 527572287, 1773802580, 1992916504, 
    1652401837, 430696203, 1202166331, 277308320, 727543826, 430696203, 1093306140, 939918257, 727543826, 
    458862064, 1393557250, 1426081092, 1008405285, 41186257, 1393557250, 1607117043, 1221965078, 41186257, 
    1345916124, 1748092973, 1614043471, 596796005, 328668658, 1748092973, 1655163813, 503866845, 328668658, 
    2146828500, 2127048966, 10643923, 1570900428, 1559622426, 2127048966, 963798460, 407649922, 1559622426, 
    1188264804, 35897774, 1970542303, 1365513163, 583235664, 35897774, 1479940899, 662093709, 583235664, 
    1308109289, 895977286, 37247186, 2050081147, 1173480671, 895977286, 1277600139, 284241421, 1173480671, 
    2013888788, 2043482286, 658176641, 1871783831, 1080033399, 2043482286, 401912906, 230214451, 1080033399, 
    452030369, 255369901, 1350332603, 1860008949, 961706715, 255369901, 1195401760, 652578229, 961706715, 
    2131053590, 740482187, 984920239, 1450610916, 449281688, 740482187, 1574920235, 137586385, 449281688, 
    1634858243, 497927143, 1901866904, 51698324, 1932152242, 497927143, 1002347892, 556119073, 1932152242, 
    1472216392, 577373840, 769534590, 1340835970, 2043517772, 577373840, 655613324, 1419075454, 2043517772, 
    1855299310, 506099840, 569067263, 422641986, 1708874033, 506099840, 1336633796, 1253175942, 1708874033, 
    572710688, 261672892, 1394962173, 246579059, 1571790153, 261672892, 670676362, 655582529, 1571790153, 
    594443199, 704082826, 607911385, 232268769, 218800583, 704082826, 436735778, 2112384300, 218800583, 
    267693324, 641808781, 154341361, 2113521010, 79410394, 641808781, 2011893649, 1336143299, 79410394, 
    1318819653, 1868464067, 1588101830, 1212415570, 943133393, 1868464067, 77451914, 1568865996, 943133393, 
    985435018, 180447434, 1577900962, 183148352, 1738144987, 180447434, 1655902374, 1658603292, 1738144987, 
    49821488, 611723857, 242459635, 602652151, 410014004, 611723857, 82459631, 73387925, 410014004, 
    1437111298, 74797434, 533133248, 2039676476, 796191947, 74797434, 1886773167, 1704189630, 796191947, 
    1637483663, 74168688, 1054079355, 700321621, 1283725929, 74168688, 2060960811, 539651165, 1283725929, 
    1887163718, 655848906, 87023570, 169996184, 1970136332, 655848906, 420940767, 2082550624, 1970136332, 
    18989030, 1801200908, 1296446318, 1480765767, 203308479, 1801200908, 1713948855, 1393513714, 203308479, 
    1287186326, 1297009802, 187411713, 1576345091, 528657125, 1297009802, 184581514, 463916803, 528657125, 
    1696668232, 1107403276, 87597923, 976253094, 437860824, 1107403276, 1930908628, 1799758446, 437860824, 
    1682379101, 297028150, 917205235, 1818447583, 436158870, 297028150, 2051989542, 1425946396, 436158870, 
    814496749, 542253708, 865467163, 1286053011, 1235082597, 542253708, 973776701, 1717576004, 1235082597, 
    1530574627, 725445924, 457192432, 1733109114, 659028730, 725445924, 1576361510, 436562121, 659028730, 
    1879960851, 566221965, 924162160, 963040885, 1918839576, 566221965, 1609385463, 2006204383, 1918839576, 
    1614225341, 1340553167, 1004137727, 1241691160, 1851778774, 1340553167, 458053542, 359191535, 1851778774, 
    755675013, 882429580, 1549541854, 1579204593, 785337752, 882429580, 768798741, 1465573754, 785337752, 
    2061271255, 466021298, 1573816382, 1311501570, 1798956443, 466021298, 1731012316, 429030009, 1798956443, 
    269410335, 525102330, 66372845, 85064323, 288101813, 525102330, 514518411, 74480404, 288101813, 
    283661186, 1203833319, 84000195, 1978192481, 30390893, 1203833319, 554252338, 1328611500, 30390893, 
    247697233, 341540512, 744092679, 503908690, 7513244, 341540512, 176426220, 338794398, 7513244, 
    1402001034, 1394863287, 1687749293, 1678557380, 1392809121, 1394863287, 2110151132, 246382646, 1392809121, 
    1502257169, 26035216, 1533979144, 1212348385, 1180626410, 26035216, 1908070020, 946920610, 1180626410, 
    542049032, 2094774459, 705590104, 1947410772, 1783869700, 2094774459, 1123436733, 976073046, 1783869700, 
    1431452905, 2101958470, 118477317, 811765310, 2124740898, 2101958470, 1786241326, 496048166, 2124740898,
    // clang-format on
};

#endif // ROCRAND_MRG31K3P_PRECOMPUTED_H_
