<?php

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/**
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class Symfony_DI_PhpDumper_Test_Almost_Circular_Public extends Container
{
    protected $parameters = [];

    public function __construct()
    {
        $this->services = $this->privates = [];
        $this->methodMap = [
            'bar' => 'getBarService',
            'bar3' => 'getBar3Service',
            'bar5' => 'getBar5Service',
            'baz6' => 'getBaz6Service',
            'connection' => 'getConnectionService',
            'connection2' => 'getConnection2Service',
            'connection3' => 'getConnection3Service',
            'connection4' => 'getConnection4Service',
            'dispatcher' => 'getDispatcherService',
            'dispatcher2' => 'getDispatcher2Service',
            'doctrine.entity_listener_resolver' => 'getDoctrine_EntityListenerResolverService',
            'doctrine.entity_manager' => 'getDoctrine_EntityManagerService',
            'doctrine.listener' => 'getDoctrine_ListenerService',
            'foo' => 'getFooService',
            'foo2' => 'getFoo2Service',
            'foo4' => 'getFoo4Service',
            'foo5' => 'getFoo5Service',
            'foo6' => 'getFoo6Service',
            'foobar' => 'getFoobarService',
            'foobar2' => 'getFoobar2Service',
            'foobar3' => 'getFoobar3Service',
            'foobar4' => 'getFoobar4Service',
            'listener3' => 'getListener3Service',
            'listener4' => 'getListener4Service',
            'logger' => 'getLoggerService',
            'mailer.transport' => 'getMailer_TransportService',
            'mailer.transport_factory' => 'getMailer_TransportFactoryService',
            'mailer.transport_factory.amazon' => 'getMailer_TransportFactory_AmazonService',
            'mailer_inline.transport_factory' => 'getMailerInline_TransportFactoryService',
            'mailer_inline.transport_factory.amazon' => 'getMailerInline_TransportFactory_AmazonService',
            'manager' => 'getManagerService',
            'manager2' => 'getManager2Service',
            'manager3' => 'getManager3Service',
            'monolog.logger' => 'getMonolog_LoggerService',
            'monolog.logger_2' => 'getMonolog_Logger2Service',
            'monolog_inline.logger' => 'getMonologInline_LoggerService',
            'monolog_inline.logger_2' => 'getMonologInline_Logger2Service',
            'pA' => 'getPAService',
            'pB' => 'getPBService',
            'pC' => 'getPCService',
            'pD' => 'getPDService',
            'root' => 'getRootService',
            'subscriber' => 'getSubscriberService',
        ];

        $this->aliases = [];
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return [
            'bar2' => true,
            'bar6' => true,
            'config' => true,
            'config2' => true,
            'doctrine.config' => true,
            'level2' => true,
            'level3' => true,
            'level4' => true,
            'level5' => true,
            'level6' => true,
            'logger2' => true,
            'mailer_inline.mailer' => true,
            'manager4' => true,
            'multiuse1' => true,
            'subscriber2' => true,
        ];
    }

    /**
     * Gets the public 'bar' shared service.
     *
     * @return \BarCircular
     */
    protected static function getBarService($container)
    {
        $instance = new \BarCircular();

        if (isset($container->services['bar'])) {
            return $container->services['bar'];
        }

        $container->services['bar'] = $instance;

        $instance->addFoobar(($container->services['foobar'] ?? self::getFoobarService($container)));

        return $instance;
    }

    /**
     * Gets the public 'bar3' shared service.
     *
     * @return \BarCircular
     */
    protected static function getBar3Service($container)
    {
        $container->services['bar3'] = $instance = new \BarCircular();

        $a = ($container->services['foobar3'] ??= new \FoobarCircular());

        $instance->addFoobar($a, $a);

        return $instance;
    }

    /**
     * Gets the public 'bar5' shared service.
     *
     * @return \stdClass
     */
    protected static function getBar5Service($container)
    {
        $a = ($container->services['foo5'] ?? self::getFoo5Service($container));

        if (isset($container->services['bar5'])) {
            return $container->services['bar5'];
        }

        $instance = new \stdClass($a);

        if (isset($container->services['bar5'])) {
            return $container->services['bar5'];
        }

        $container->services['bar5'] = $instance;

        $instance->foo = $a;

        return $instance;
    }

    /**
     * Gets the public 'baz6' shared service.
     *
     * @return \stdClass
     */
    protected static function getBaz6Service($container)
    {
        $container->services['baz6'] = $instance = new \stdClass();

        $instance->bar6 = ($container->privates['bar6'] ?? self::getBar6Service($container));

        return $instance;
    }

    /**
     * Gets the public 'connection' shared service.
     *
     * @return \stdClass
     */
    protected static function getConnectionService($container)
    {
        $a = ($container->services['dispatcher'] ?? self::getDispatcherService($container));

        if (isset($container->services['connection'])) {
            return $container->services['connection'];
        }
        $b = new \stdClass();

        $instance = new \stdClass($a, $b);

        if (isset($container->services['connection'])) {
            return $container->services['connection'];
        }

        $container->services['connection'] = $instance;

        $b->logger = ($container->services['logger'] ?? self::getLoggerService($container));

        return $instance;
    }

    /**
     * Gets the public 'connection2' shared service.
     *
     * @return \stdClass
     */
    protected static function getConnection2Service($container)
    {
        $a = ($container->services['dispatcher2'] ?? self::getDispatcher2Service($container));

        if (isset($container->services['connection2'])) {
            return $container->services['connection2'];
        }
        $b = new \stdClass();

        $instance = new \stdClass($a, $b);

        if (isset($container->services['connection2'])) {
            return $container->services['connection2'];
        }

        $container->services['connection2'] = $instance;

        $c = new \stdClass($instance);
        $c->handler2 = new \stdClass(($container->services['manager2'] ?? self::getManager2Service($container)));

        $b->logger2 = $c;

        return $instance;
    }

    /**
     * Gets the public 'connection3' shared service.
     *
     * @return \stdClass
     */
    protected static function getConnection3Service($container)
    {
        $instance = new \stdClass();

        if (isset($container->services['connection3'])) {
            return $container->services['connection3'];
        }

        $container->services['connection3'] = $instance;

        $instance->listener = [($container->services['listener3'] ?? self::getListener3Service($container))];

        return $instance;
    }

    /**
     * Gets the public 'connection4' shared service.
     *
     * @return \stdClass
     */
    protected static function getConnection4Service($container)
    {
        $instance = new \stdClass();

        if (isset($container->services['connection4'])) {
            return $container->services['connection4'];
        }

        $container->services['connection4'] = $instance;

        $instance->listener = [($container->services['listener4'] ?? self::getListener4Service($container))];

        return $instance;
    }

    /**
     * Gets the public 'dispatcher' shared service.
     *
     * @return \stdClass
     */
    protected static function getDispatcherService($container, $lazyLoad = true)
    {
        $instance = new \stdClass();

        if (isset($container->services['dispatcher'])) {
            return $container->services['dispatcher'];
        }

        $container->services['dispatcher'] = $instance;

        $instance->subscriber = ($container->services['subscriber'] ?? self::getSubscriberService($container));

        return $instance;
    }

    /**
     * Gets the public 'dispatcher2' shared service.
     *
     * @return \stdClass
     */
    protected static function getDispatcher2Service($container, $lazyLoad = true)
    {
        $instance = new \stdClass();

        if (isset($container->services['dispatcher2'])) {
            return $container->services['dispatcher2'];
        }

        $container->services['dispatcher2'] = $instance;

        $instance->subscriber2 = ($container->privates['subscriber2'] ?? self::getSubscriber2Service($container));

        return $instance;
    }

    /**
     * Gets the public 'doctrine.entity_listener_resolver' shared service.
     *
     * @return \stdClass
     */
    protected static function getDoctrine_EntityListenerResolverService($container)
    {
        $instance = new \stdClass(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->services['doctrine.listener'] ?? self::getDoctrine_ListenerService($container));
        }, 1));

        if (isset($container->services['doctrine.entity_listener_resolver'])) {
            return $container->services['doctrine.entity_listener_resolver'];
        }

        return $container->services['doctrine.entity_listener_resolver'] = $instance;
    }

    /**
     * Gets the public 'doctrine.entity_manager' shared service.
     *
     * @return \stdClass
     */
    protected static function getDoctrine_EntityManagerService($container)
    {
        $a = ($container->services['doctrine.entity_listener_resolver'] ?? self::getDoctrine_EntityListenerResolverService($container));

        if (isset($container->services['doctrine.entity_manager'])) {
            return $container->services['doctrine.entity_manager'];
        }
        $b = new \stdClass();
        $b->resolver = $a;
        $b->flag = 'ok';

        $instance = \FactoryChecker::create($b);

        if (isset($container->services['doctrine.entity_manager'])) {
            return $container->services['doctrine.entity_manager'];
        }

        return $container->services['doctrine.entity_manager'] = $instance;
    }

    /**
     * Gets the public 'doctrine.listener' shared service.
     *
     * @return \stdClass
     */
    protected static function getDoctrine_ListenerService($container)
    {
        $a = ($container->services['doctrine.entity_manager'] ?? self::getDoctrine_EntityManagerService($container));

        if (isset($container->services['doctrine.listener'])) {
            return $container->services['doctrine.listener'];
        }

        $instance = new \stdClass($a);

        if (isset($container->services['doctrine.listener'])) {
            return $container->services['doctrine.listener'];
        }

        return $container->services['doctrine.listener'] = $instance;
    }

    /**
     * Gets the public 'foo' shared service.
     *
     * @return \FooCircular
     */
    protected static function getFooService($container)
    {
        $a = ($container->services['bar'] ?? self::getBarService($container));

        if (isset($container->services['foo'])) {
            return $container->services['foo'];
        }

        $instance = new \FooCircular($a);

        if (isset($container->services['foo'])) {
            return $container->services['foo'];
        }

        return $container->services['foo'] = $instance;
    }

    /**
     * Gets the public 'foo2' shared service.
     *
     * @return \FooCircular
     */
    protected static function getFoo2Service($container)
    {
        $a = new \BarCircular();

        $instance = new \FooCircular($a);

        if (isset($container->services['foo2'])) {
            return $container->services['foo2'];
        }

        $container->services['foo2'] = $instance;

        $a->addFoobar(($container->services['foobar2'] ?? self::getFoobar2Service($container)));

        return $instance;
    }

    /**
     * Gets the public 'foo4' service.
     *
     * @return \stdClass
     */
    protected static function getFoo4Service($container)
    {
        $container->factories['foo4'] = function ($container) {
            $instance = new \stdClass();

            $instance->foobar = ($container->services['foobar4'] ?? self::getFoobar4Service($container));

            return $instance;
        };

        return $container->factories['foo4']($container);
    }

    /**
     * Gets the public 'foo5' shared service.
     *
     * @return \stdClass
     */
    protected static function getFoo5Service($container)
    {
        $instance = new \stdClass();

        if (isset($container->services['foo5'])) {
            return $container->services['foo5'];
        }

        $container->services['foo5'] = $instance;

        $instance->bar = ($container->services['bar5'] ?? self::getBar5Service($container));

        return $instance;
    }

    /**
     * Gets the public 'foo6' shared service.
     *
     * @return \stdClass
     */
    protected static function getFoo6Service($container)
    {
        $instance = new \stdClass();

        if (isset($container->services['foo6'])) {
            return $container->services['foo6'];
        }

        $container->services['foo6'] = $instance;

        $instance->bar6 = ($container->privates['bar6'] ?? self::getBar6Service($container));

        return $instance;
    }

    /**
     * Gets the public 'foobar' shared service.
     *
     * @return \FoobarCircular
     */
    protected static function getFoobarService($container)
    {
        $a = ($container->services['foo'] ?? self::getFooService($container));

        if (isset($container->services['foobar'])) {
            return $container->services['foobar'];
        }

        $instance = new \FoobarCircular($a);

        if (isset($container->services['foobar'])) {
            return $container->services['foobar'];
        }

        return $container->services['foobar'] = $instance;
    }

    /**
     * Gets the public 'foobar2' shared service.
     *
     * @return \FoobarCircular
     */
    protected static function getFoobar2Service($container)
    {
        $a = ($container->services['foo2'] ?? self::getFoo2Service($container));

        if (isset($container->services['foobar2'])) {
            return $container->services['foobar2'];
        }

        $instance = new \FoobarCircular($a);

        if (isset($container->services['foobar2'])) {
            return $container->services['foobar2'];
        }

        return $container->services['foobar2'] = $instance;
    }

    /**
     * Gets the public 'foobar3' shared service.
     *
     * @return \FoobarCircular
     */
    protected static function getFoobar3Service($container)
    {
        return $container->services['foobar3'] = new \FoobarCircular();
    }

    /**
     * Gets the public 'foobar4' shared service.
     *
     * @return \stdClass
     */
    protected static function getFoobar4Service($container)
    {
        $a = new \stdClass();

        $container->services['foobar4'] = $instance = new \stdClass($a);

        $a->foobar = $instance;

        return $instance;
    }

    /**
     * Gets the public 'listener3' shared service.
     *
     * @return \stdClass
     */
    protected static function getListener3Service($container)
    {
        $instance = new \stdClass();

        if (isset($container->services['listener3'])) {
            return $container->services['listener3'];
        }

        $container->services['listener3'] = $instance;

        $instance->manager = ($container->services['manager3'] ?? self::getManager3Service($container));

        return $instance;
    }

    /**
     * Gets the public 'listener4' shared service.
     *
     * @return \stdClass
     */
    protected static function getListener4Service($container)
    {
        $a = ($container->privates['manager4'] ?? self::getManager4Service($container));

        if (isset($container->services['listener4'])) {
            return $container->services['listener4'];
        }

        $instance = new \stdClass($a);

        if (isset($container->services['listener4'])) {
            return $container->services['listener4'];
        }

        return $container->services['listener4'] = $instance;
    }

    /**
     * Gets the public 'logger' shared service.
     *
     * @return \stdClass
     */
    protected static function getLoggerService($container)
    {
        $a = ($container->services['connection'] ?? self::getConnectionService($container));

        if (isset($container->services['logger'])) {
            return $container->services['logger'];
        }

        $instance = new \stdClass($a);

        if (isset($container->services['logger'])) {
            return $container->services['logger'];
        }

        $container->services['logger'] = $instance;

        $instance->handler = new \stdClass(($container->services['manager'] ?? self::getManagerService($container)));

        return $instance;
    }

    /**
     * Gets the public 'mailer.transport' shared service.
     *
     * @return \stdClass
     */
    protected static function getMailer_TransportService($container)
    {
        $a = ($container->services['mailer.transport_factory'] ?? self::getMailer_TransportFactoryService($container));

        if (isset($container->services['mailer.transport'])) {
            return $container->services['mailer.transport'];
        }

        $instance = $a->create();

        if (isset($container->services['mailer.transport'])) {
            return $container->services['mailer.transport'];
        }

        return $container->services['mailer.transport'] = $instance;
    }

    /**
     * Gets the public 'mailer.transport_factory' shared service.
     *
     * @return \FactoryCircular
     */
    protected static function getMailer_TransportFactoryService($container)
    {
        $instance = new \FactoryCircular(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->services['mailer.transport_factory.amazon'] ?? self::getMailer_TransportFactory_AmazonService($container));
            yield 1 => ($container->services['mailer_inline.transport_factory.amazon'] ?? self::getMailerInline_TransportFactory_AmazonService($container));
        }, 2));

        if (isset($container->services['mailer.transport_factory'])) {
            return $container->services['mailer.transport_factory'];
        }

        return $container->services['mailer.transport_factory'] = $instance;
    }

    /**
     * Gets the public 'mailer.transport_factory.amazon' shared service.
     *
     * @return \stdClass
     */
    protected static function getMailer_TransportFactory_AmazonService($container)
    {
        $a = ($container->services['monolog.logger_2'] ?? self::getMonolog_Logger2Service($container));

        if (isset($container->services['mailer.transport_factory.amazon'])) {
            return $container->services['mailer.transport_factory.amazon'];
        }

        $instance = new \stdClass($a);

        if (isset($container->services['mailer.transport_factory.amazon'])) {
            return $container->services['mailer.transport_factory.amazon'];
        }

        return $container->services['mailer.transport_factory.amazon'] = $instance;
    }

    /**
     * Gets the public 'mailer_inline.transport_factory' shared service.
     *
     * @return \FactoryCircular
     */
    protected static function getMailerInline_TransportFactoryService($container)
    {
        return $container->services['mailer_inline.transport_factory'] = new \FactoryCircular(new RewindableGenerator(fn () => new \EmptyIterator(), 0));
    }

    /**
     * Gets the public 'mailer_inline.transport_factory.amazon' shared service.
     *
     * @return \stdClass
     */
    protected static function getMailerInline_TransportFactory_AmazonService($container)
    {
        return $container->services['mailer_inline.transport_factory.amazon'] = new \stdClass(($container->services['monolog_inline.logger_2'] ?? self::getMonologInline_Logger2Service($container)));
    }

    /**
     * Gets the public 'manager' shared service.
     *
     * @return \stdClass
     */
    protected static function getManagerService($container)
    {
        $a = ($container->services['connection'] ?? self::getConnectionService($container));

        if (isset($container->services['manager'])) {
            return $container->services['manager'];
        }

        $instance = new \stdClass($a);

        if (isset($container->services['manager'])) {
            return $container->services['manager'];
        }

        return $container->services['manager'] = $instance;
    }

    /**
     * Gets the public 'manager2' shared service.
     *
     * @return \stdClass
     */
    protected static function getManager2Service($container)
    {
        $a = ($container->services['connection2'] ?? self::getConnection2Service($container));

        if (isset($container->services['manager2'])) {
            return $container->services['manager2'];
        }

        $instance = new \stdClass($a);

        if (isset($container->services['manager2'])) {
            return $container->services['manager2'];
        }

        return $container->services['manager2'] = $instance;
    }

    /**
     * Gets the public 'manager3' shared service.
     *
     * @return \stdClass
     */
    protected static function getManager3Service($container, $lazyLoad = true)
    {
        $a = ($container->services['connection3'] ?? self::getConnection3Service($container));

        if (isset($container->services['manager3'])) {
            return $container->services['manager3'];
        }

        $instance = new \stdClass($a);

        if (isset($container->services['manager3'])) {
            return $container->services['manager3'];
        }

        return $container->services['manager3'] = $instance;
    }

    /**
     * Gets the public 'monolog.logger' shared service.
     *
     * @return \stdClass
     */
    protected static function getMonolog_LoggerService($container)
    {
        $container->services['monolog.logger'] = $instance = new \stdClass();

        $instance->handler = ($container->services['mailer.transport'] ?? self::getMailer_TransportService($container));

        return $instance;
    }

    /**
     * Gets the public 'monolog.logger_2' shared service.
     *
     * @return \stdClass
     */
    protected static function getMonolog_Logger2Service($container)
    {
        $instance = new \stdClass();

        if (isset($container->services['monolog.logger_2'])) {
            return $container->services['monolog.logger_2'];
        }

        $container->services['monolog.logger_2'] = $instance;

        $instance->handler = ($container->services['mailer.transport'] ?? self::getMailer_TransportService($container));

        return $instance;
    }

    /**
     * Gets the public 'monolog_inline.logger' shared service.
     *
     * @return \stdClass
     */
    protected static function getMonologInline_LoggerService($container)
    {
        $container->services['monolog_inline.logger'] = $instance = new \stdClass();

        $instance->handler = ($container->privates['mailer_inline.mailer'] ?? self::getMailerInline_MailerService($container));

        return $instance;
    }

    /**
     * Gets the public 'monolog_inline.logger_2' shared service.
     *
     * @return \stdClass
     */
    protected static function getMonologInline_Logger2Service($container)
    {
        $container->services['monolog_inline.logger_2'] = $instance = new \stdClass();

        $instance->handler = ($container->privates['mailer_inline.mailer'] ?? self::getMailerInline_MailerService($container));

        return $instance;
    }

    /**
     * Gets the public 'pA' shared service.
     *
     * @return \stdClass
     */
    protected static function getPAService($container)
    {
        $a = ($container->services['pB'] ?? self::getPBService($container));

        if (isset($container->services['pA'])) {
            return $container->services['pA'];
        }
        $b = ($container->services['pC'] ?? self::getPCService($container));

        if (isset($container->services['pA'])) {
            return $container->services['pA'];
        }

        $instance = new \stdClass($a, $b);

        if (isset($container->services['pA'])) {
            return $container->services['pA'];
        }

        return $container->services['pA'] = $instance;
    }

    /**
     * Gets the public 'pB' shared service.
     *
     * @return \stdClass
     */
    protected static function getPBService($container)
    {
        $instance = new \stdClass();

        if (isset($container->services['pB'])) {
            return $container->services['pB'];
        }

        $container->services['pB'] = $instance;

        $instance->d = ($container->services['pD'] ?? self::getPDService($container));

        return $instance;
    }

    /**
     * Gets the public 'pC' shared service.
     *
     * @return \stdClass
     */
    protected static function getPCService($container, $lazyLoad = true)
    {
        $instance = new \stdClass();

        if (isset($container->services['pC'])) {
            return $container->services['pC'];
        }

        $container->services['pC'] = $instance;

        $instance->d = ($container->services['pD'] ?? self::getPDService($container));

        return $instance;
    }

    /**
     * Gets the public 'pD' shared service.
     *
     * @return \stdClass
     */
    protected static function getPDService($container)
    {
        $a = ($container->services['pA'] ?? self::getPAService($container));

        if (isset($container->services['pD'])) {
            return $container->services['pD'];
        }

        $instance = new \stdClass($a);

        if (isset($container->services['pD'])) {
            return $container->services['pD'];
        }

        return $container->services['pD'] = $instance;
    }

    /**
     * Gets the public 'root' shared service.
     *
     * @return \stdClass
     */
    protected static function getRootService($container)
    {
        $a = new \Symfony\Component\DependencyInjection\Tests\Fixtures\FooForCircularWithAddCalls();

        $b = new \stdClass();

        $a->call(new \stdClass(new \stdClass($b, ($container->privates['level5'] ?? self::getLevel5Service($container)))));

        return $container->services['root'] = new \stdClass($a, $b);
    }

    /**
     * Gets the public 'subscriber' shared service.
     *
     * @return \stdClass
     */
    protected static function getSubscriberService($container)
    {
        $a = ($container->services['manager'] ?? self::getManagerService($container));

        if (isset($container->services['subscriber'])) {
            return $container->services['subscriber'];
        }

        $instance = new \stdClass($a);

        if (isset($container->services['subscriber'])) {
            return $container->services['subscriber'];
        }

        return $container->services['subscriber'] = $instance;
    }

    /**
     * Gets the private 'bar6' shared service.
     *
     * @return \stdClass
     */
    protected static function getBar6Service($container)
    {
        $a = ($container->services['foo6'] ?? self::getFoo6Service($container));

        if (isset($container->privates['bar6'])) {
            return $container->privates['bar6'];
        }

        $instance = new \stdClass($a);

        if (isset($container->privates['bar6'])) {
            return $container->privates['bar6'];
        }

        return $container->privates['bar6'] = $instance;
    }

    /**
     * Gets the private 'level5' shared service.
     *
     * @return \stdClass
     */
    protected static function getLevel5Service($container)
    {
        $a = new \Symfony\Component\DependencyInjection\Tests\Fixtures\FooForCircularWithAddCalls();

        $container->privates['level5'] = $instance = new \stdClass($a);

        $a->call($instance);

        return $instance;
    }

    /**
     * Gets the private 'mailer_inline.mailer' shared service.
     *
     * @return \stdClass
     */
    protected static function getMailerInline_MailerService($container)
    {
        return $container->privates['mailer_inline.mailer'] = new \stdClass(($container->services['mailer_inline.transport_factory'] ?? self::getMailerInline_TransportFactoryService($container))->create());
    }

    /**
     * Gets the private 'manager4' shared service.
     *
     * @return \stdClass
     */
    protected static function getManager4Service($container, $lazyLoad = true)
    {
        $a = ($container->services['connection4'] ?? self::getConnection4Service($container));

        if (isset($container->privates['manager4'])) {
            return $container->privates['manager4'];
        }

        $instance = new \stdClass($a);

        if (isset($container->privates['manager4'])) {
            return $container->privates['manager4'];
        }

        return $container->privates['manager4'] = $instance;
    }

    /**
     * Gets the private 'subscriber2' shared service.
     *
     * @return \stdClass
     */
    protected static function getSubscriber2Service($container)
    {
        $a = ($container->services['manager2'] ?? self::getManager2Service($container));

        if (isset($container->privates['subscriber2'])) {
            return $container->privates['subscriber2'];
        }

        $instance = new \stdClass($a);

        if (isset($container->privates['subscriber2'])) {
            return $container->privates['subscriber2'];
        }

        return $container->privates['subscriber2'] = $instance;
    }
}
