/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.gantt;

import com.projectlibre1.configuration.Dictionary;
import com.projectlibre1.graphic.configuration.BarStyles;
import com.projectlibre1.graphic.configuration.GraphicConfiguration;
import com.projectlibre1.pm.graphic.gantt.GanttParams;
import com.projectlibre1.pm.graphic.gantt.link_routing.DefaultGanttLinkRouting;
import com.projectlibre1.pm.graphic.graph.GraphParams;
import com.projectlibre1.pm.graphic.graph.LinkRouting;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCache;
import com.projectlibre1.pm.graphic.timescale.CoordinatesConverter;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.Serializable;

public class GanttParamsImpl
implements GanttParams,
Serializable,
Cloneable {
    private static final long serialVersionUID = 2314555242629487089L;
    protected NodeModelCache cache;
    protected BarStyles barStyles;
    protected GraphicConfiguration configuration;
    protected Font columnHeaderFont;
    protected LinkRouting routing = new DefaultGanttLinkRouting();
    protected CoordinatesConverter coord;
    protected Rectangle printBounds;
    protected boolean rightPartVisible = true;
    protected boolean leftPartVisible = true;
    protected int rowHeight;
    protected boolean supportLeftAndRightParts = false;

    public GanttParamsImpl() {
        this.configuration = GraphicConfiguration.getInstance();
        this.barStyles = (BarStyles)Dictionary.get("BarStylesCategory", "standard");
        this.columnHeaderFont = new Font("Default", 0, 10);
        this.routing = new DefaultGanttLinkRouting();
        this.rowHeight = this.configuration.getRowHeight();
    }

    @Override
    public GraphicConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(GraphicConfiguration graphicConfiguration) {
        this.configuration = graphicConfiguration;
    }

    @Override
    public BarStyles getBarStyles() {
        return this.barStyles;
    }

    @Override
    public void setBarStyles(BarStyles barStyles) {
        this.barStyles = barStyles;
    }

    @Override
    public NodeModelCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(NodeModelCache nodeModelCache) {
        this.cache = nodeModelCache;
    }

    @Override
    public CoordinatesConverter getCoord() {
        return this.coord;
    }

    @Override
    public void setCoord(CoordinatesConverter coordinatesConverter) {
        this.coord = coordinatesConverter;
    }

    @Override
    public LinkRouting getRouting() {
        return this.routing;
    }

    @Override
    public void setRouting(LinkRouting linkRouting) {
        this.routing = linkRouting;
    }

    @Override
    public int getRowHeight() {
        return this.rowHeight;
    }

    @Override
    public void setRowHeight(int n) {
        this.rowHeight = n;
    }

    @Override
    public Rectangle getGanttBounds() {
        return new Rectangle(0, this.configuration.getColumnHeaderHeight(), (int)Math.ceil(this.coord.getWidth()), this.getRowHeight() * this.cache.getSize());
    }

    @Override
    public Rectangle getDrawingBounds() {
        return this.getGanttBounds();
    }

    @Override
    public Font getColumnHeaderFont() {
        return this.columnHeaderFont;
    }

    @Override
    public void setColumnHeaderFont(Font font) {
        this.columnHeaderFont = font;
    }

    @Override
    public boolean useTextures() {
        return false;
    }

    @Override
    public Rectangle getPrintBounds() {
        return this.printBounds;
    }

    @Override
    public void setPrintBounds(Rectangle rectangle) {
        this.printBounds = rectangle;
        this.updateDrawingBounds();
    }

    public void updateDrawingBounds() {
    }

    @Override
    public int getPrintCols() {
        return (int)Math.ceil(this.getGanttBounds().getWidth() / this.getPrintBounds().getWidth());
    }

    @Override
    public int getPrintRows() {
        return (int)Math.ceil(this.getGanttBounds().getHeight() / this.getPrintBounds().getHeight());
    }

    @Override
    public boolean isLeftPartVisible() {
        return this.leftPartVisible;
    }

    @Override
    public void setLeftPartVisible(boolean bl) {
        this.leftPartVisible = bl;
    }

    @Override
    public boolean isRightPartVisible() {
        return this.rightPartVisible;
    }

    @Override
    public void setRightPartVisible(boolean bl) {
        this.rightPartVisible = bl;
    }

    @Override
    public boolean isSupportLeftAndRightParts() {
        return this.supportLeftAndRightParts;
    }

    @Override
    public void setSupportLeftAndRightParts(boolean bl) {
        this.supportLeftAndRightParts = bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public GraphParams createSafePrintCopy() {
        GanttParamsImpl ganttParamsImpl = (GanttParamsImpl)this.clone();
        if (ganttParamsImpl.printBounds != null) {
            ganttParamsImpl.printBounds = (Rectangle)ganttParamsImpl.printBounds.clone();
        }
        return ganttParamsImpl;
    }
}

