{application, tsung,
      [{description,  "tsung, a load testing tool for TCP/UDP servers"},
       {vsn,          "1.8.0"},
       {modules,      [
                       gen_ts_transport,
                       mochijson2,
                       mochinum,
                       mochiutf8,
                       mochiweb_charref,
                       mochiweb_headers,
                       mochiweb_html,
                       mochiweb_util,
                       mochiweb_xpath,
                       mochiweb_xpath_functions,
                       mochiweb_xpath_parser,
                       mochiweb_xpath_utils,
                       mqtt_frame,
                       oauth,
                       oauth_hmac_sha1,
                       oauth_http,
                       oauth_plaintext,
                       oauth_rsa_sha1,
                       oauth_unix,
                       oauth_uri,
                       pgsql_proto,
                       pgsql_util,
                       rabbit_binary_generator,
                       rabbit_binary_parser,
                       rabbit_command_assembler,
                       rabbit_framing_amqp_0_9_1,
                       rabbit_misc,
                       rfc4515_parser,
                       ts_amqp,
                       ts_bosh,
                       ts_bosh_ssl,
                       ts_client,
                       ts_client_sup,
                       ts_cport,
                       ts_digest,
                       ts_dynvars,
                       ts_erlang,
                       ts_fs,
                       ts_http,
                       ts_http_common,
                       ts_ip_scan,
                       ts_jabber,
                       ts_jabber_common,
                       ts_job,
                       ts_launcher,
                       ts_launcher_mgr,
                       ts_launcher_static,
                       ts_ldap,
                       ts_ldap_common,
                       ts_local_mon,
                       ts_mon_cache,
                       ts_mqtt,
                       ts_mysql,
                       ts_pgsql,
                       ts_plugin,
                       ts_raw,
                       ts_reports,
                       ts_search,
                       ts_server_websocket,
                       ts_session_cache,
                       ts_shell,
                       ts_ssl,
                       ts_ssl6,
                       ts_ssl_session_cache,
                       ts_stats,
                       ts_sup,
                       ts_tcp,
                       ts_tcp6,
                       ts_udp,
                       ts_udp6,
                       tsung,
                       ts_utils,
                       ts_webdav,
                       ts_websocket,
                       uuid,
                       websocket
                      ]},
       {registered,   [
                       ts_launcher,
                       ts_launcher_static,
                       ts_mon_cache,
                       ts_sup,
                       ts_session_cache
                      ]},
       {env,        [
                     {debug_level, 2},
                     {snd_size, 32768},      % send buffer size
                     {rcv_size, 32768},      % receive buffer size
                     {idle_timeout, 600000},  % 10min timeout
                     {global_ack_timeout, infinity}, % global ack timeout
                     {connect_timeout, 30000},
                     {max_warm_delay, 15000},
                     {dump, full},           % full or light
                     {parse_type, noparse},
                     {persistent, true},  % persistent connection: true or false
                     {mes_type, dynamic}, % dynamic or static
                     {nclients, 10},      % number of client to connect
                     {log_file, "./tsung.log"}, % log file name
                     %% use for IMS GET :
                     {http_modified_since_date, "Fri, 14 Nov 2003 02:43:31 GMT"},
                     {client_retry_timeout, 10}, % retry sending (in microsec.)
                     {max_retries, 3},        % number of max retries
                     {ssl_ciphers, negotiate},
                     {ssl_versions, negotiate},

%%% -------- JABBER OPTIONS
                     {jabber_users, 2000000},
                     {jabber_username, "c"},
                     {jabber_password, "pas"},
                     {jabber_domain, "mydomain.com"},
%%% -------- WEBSOCKET OPTIONS
                     {websocket_path, "/chat"}
                    ]},
       {applications, [ kernel,stdlib,asn1,crypto,public_key,ssl,crypto]},
       {mod,          {tsung, []}}
      ]}.
